<?php
/**
 * Internationalization file for the Validator extension
 *
 * @file Validator.i18n.php
 * @ingroup Validator
 *
 * @licence GNU GPL v2+
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */

$messages = array();

/** English
 * @author Jeroen De Dauw
 * @author Daniel Werner
 */
$messages['en'] = array(
	'validator-desc' => 'Provides generic parameter handling support for other extensions',

	// General
	'validator-warning' => 'Warning: $1',
	'validator-error' => 'Error: $1',
	'validator-fatal-error' => 'Fatal error: $1',
	'validator_error_parameters' => 'The following {{PLURAL:$1|error has|errors have}} been detected in your syntax:',
	'validator_warning_parameters' => 'There {{PLURAL:$1|is an error|are errors}} in your syntax.',
	'validator-warning-adittional-errors' => '... and {{PLURAL:$1|one more issue|multiple more issues}}.',
	'validator-error-omitted' => 'The {{PLURAL:$2|value "$1" has|values "$1" have}} been omitted.',
	'validator-error-problem' => 'There was a problem with parameter $1.',

	// General errors
	'validator_error_unknown_argument' => '$1 is not a valid parameter.',
	'validator_error_required_missing' => 'The required parameter "$1" is not provided.',
	'validator-error-override-argument' => 'Tried to override parameter $1 (value: $2) with value "$3"',

	// Parameter types
	'validator-type-string' => 'text',
	'validator-type-integer' => 'whole number',
	'validator-type-float' => 'number',
	'validator-type-boolean' => 'yes/no',
	'validator-type-char' => 'character',
	'validator-type-title' => 'title',

	// Parameter types: lists
	'validator-type-string-list' => 'list of texts',
	'validator-type-integer-list' => 'list of integers',
	'validator-type-float-list' => 'list of numbers',
	'validator-type-boolean-list' => 'list of yes/no',
	'validator-type-char-list' => 'list characters',
	'validator-type-title-list' => 'list of titles',

	// Listerrors
	'validator-listerrors-errors' => 'Errors',
	'validator-listerrors-severity-message' => '($1) $2', // $1 = severity; $2 = message
	'validator-listerrors-minor' => 'Minor',
	'validator-listerrors-low' => 'Low',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'High',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => 'Lists errors (and warnings) that occurred in parser hooks added via Validator.
Only lists for parser hooks added above where listerrors is inserted;
place listerrors at or near the bottom of the page to get all errors.',
	'validator-listerrors-par-minseverity' => 'The minimum severity of an issue for it to be listed.',

	// Describe
	'validator-describe-description' => 'Generates documentation for one or more parser hooks defined via Validator.',
	'validator-describe-notfound' => 'There is no parser hook that handles "$1".',
	'validator-describe-descriptionmsg' => "'''Description''': $1", // Because it's 1360 < 3
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliases}}''': $1",
	'validator-describe-parserfunction' => 'Implemented only as parser function.',
	'validator-describe-tagextension' => 'Implemented only as tag extension.',
	'validator-describe-bothhooks' => 'Implemented as both parser function and as tag extension.',
	'validator-describe-par-hooks' => 'The parser hooks for which to display documentation.',
	'validator-describe-par-pre' => 'Allows you to get the actual wikitext for the documentation, without it being rendered on the page.',
	'validator-describe-par-language' => 'The language to display the descriptions in',
	'validator-describe-listtype' => 'List of $1 items',
	'validator-describe-empty' => 'empty',
	'validator-describe-required' => 'required',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Aliases',
	'validator-describe-header-type' => 'Type',
	'validator-describe-header-default' => 'Default',
	'validator-describe-header-description' => 'Description',
	'validator-describe-parameters' => 'Parameters',
	'validator-describe-syntax' => 'Syntax',
	'validator-describe-tagmin' => 'Tag extension with only the required parameters.',
	'validator-describe-tagmax' => 'Tag extension with all parameters.',
	'validator-describe-tagdefault' => 'Tag extension with all parameters using the default parameter notation.',
	'validator-describe-pfmin' => 'Parser function with only the required parameters.',
	'validator-describe-pfmax' => 'Parser function with all parameters.',
	'validator-describe-pfdefault' => 'Parser function with all parameters using the default parameter notation.',
	'validator-describe-autogen' => 'The contents of this section was auto-generated by the "describe" parser hook of the Validator extension.',

	// Criteria errors for single values
	'validator_error_empty_argument' => 'Parameter $1 can not have an empty value.',
	'validator_error_must_be_number' => 'Parameter $1 can only be a number.',
	'validator_error_must_be_integer' => 'Parameter $1 can only be an integer.',
	'validator_error_must_be_title' => 'Parameter $1 can only be a valid wiki page name.',
	'validator_error_must_be_existing_title' => 'Parameter $1 can only be an existing wiki page name.',
	'validator-error-must-be-float' => 'Parameter $1 can only be a floating point number.',
	'validator_error_invalid_range' => 'Parameter $1 must be between $2 and $3.',
	'validator-error-invalid-regex' => 'Parameter $1 must match this regular expression: $2.',
	'validator-error-invalid-length' => 'Parameter $1 must have a length of $2.',
	'validator-error-invalid-length-range' => 'Parameter $1 must have a length between $2 and $3.',
	'validator_error_invalid_argument' => 'The value $1 is not valid for parameter $2.',

	// Criteria errors for lists
	'validator_list_error_empty_argument' => 'Parameter $1 does not accept empty values.',
	'validator_list_error_must_be_number' => 'Parameter $1 can only contain numbers.',
	'validator_list_error_must_be_integer' => 'Parameter $1 can only contain integers.',
	'validator_list_error_must_be_title' => 'Parameter $1 can only contain valid wiki page names.',
	'validator_list_error_must_be_existing_title' => 'Parameter $1 can only contain existing wiki page names.',
	'validator-list-error-must-be-float' => 'Parameter $1 can only contain floats.',
	'validator_list_error_invalid_range' => 'All values of parameter $1 must be between $2 and $3.',
	'validator-list-error-invalid-regex' => 'All values of parameter $1 must match this regular expression: $2.',
	'validator_list_error_invalid_argument' => 'One or more values for parameter $1 are invalid.',
	'validator-list-error-accepts-only' => 'One or more values for parameter $1 are invalid. It only accepts {{PLURAL:$3|this value|these values}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'One or more values for parameter $1 are invalid. It only accepts {{PLURAL:$3|this value|these values}}: $2 (and $4 omitted {{PLURAL:$4|value|values}}).',

	// Criteria errors for single values & lists
	'validator_error_accepts_only' => 'The value "$4" is not valid for parameter $1. It only accepts {{PLURAL:$3|this value|these values}}: $2.',
	'validator-error-accepts-only-omitted' => 'The value "$2" is not valid for parameter $1. It only accepts {{PLURAL:$5|this value|these values}}: $3 (and $4 omitted {{PLURAL:$4|value|values}}).',

	'validator_list_omitted' => 'The {{PLURAL:$2|value|values}} $1 {{PLURAL:$2|has|have}} been omitted.',

	// Parameter descriptions
	'validator-message-nodesc' => 'No description provided',
);

/** Message documentation (Message documentation)
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author Kghbln
 * @author Purodha
 * @author Raymond
 */
$messages['qqq'] = array(
	'validator-desc' => '{{desc}}',
	'validator-warning' => 'This message indicates an error detected. $1 holds the warning message.

{{Identical|Warning}}',
	'validator-error' => 'This message indicates an error detected. $1 holds the error report.

{{Identical|Error}}',
	'validator-fatal-error' => 'This message indicates a fatal error detected. $1 holds the fatal error report.',
	'validator_error_parameters' => 'Parameters:
* $1 is the number of syntax errors, for PLURAL support (optional)',
	'validator-error-problem' => 'This is an error message. $1 holds the name of the parameter causing the error.',
	'validator_error_unknown_argument' => 'This is an error message. $1 holds the name of the erroneous parameter provided.',
	'validator_error_required_missing' => 'This is an error message. $1 holds the name of the parameter which was not provided.',
	'validator-type-string' => 'This is the name of a type of values that may be assigned to a parameter. In this case it is some "text" (string).

{{Identical|Text}}',
	'validator-type-integer' => 'This is the name of a type of values that may be assigned to a parameter. In this case it is some "whole number" (integer).',
	'validator-type-float' => 'This is the name of a type of values that may be assigned to a parameter. In this case it is some "number".',
	'validator-type-boolean' => 'This is the name of a type of values that may be assigned to a parameter. In this case it is a boolean value (yes or no).',
	'validator-type-char' => 'This is the name of a type of values that may be assigned to a parameter. In this case it is some "character".',
	'validator-type-title' => 'This is the name of a type of values that may be assigned to a parameter. In this case it is the "title" of a page.

{{Identical|Title}}',
	'validator-type-string-list' => 'This is the name of a type of values that may be assigned to a parameter. In this case multiple "texts" (strings).',
	'validator-type-integer-list' => 'This is the name of a type of values that may be assigned to a parameter. In this case multiple "whole numbers" (integers).',
	'validator-type-float-list' => 'This is the name of a type of values that may be assigned to a parameter. In this case multiple "numbers".',
	'validator-type-boolean-list' => 'This is the name of a type of values that may be assigned to a parameter. In this case multiple "booleans" (yes or no).',
	'validator-type-char-list' => 'This is the name of a type of values that may be assigned to a parameter. In this case multiple "characters".',
	'validator-type-title-list' => 'This is the name of a type of values that may be assigned to a parameter. In this case multiple "page names".',
	'validator-listerrors-errors' => 'This is the title of the section added to a page after inserting the "listerrors" tag or the "listerrors" parser function. Possible errors which were detected are listed in this section.

{{Identical|Error}}',
	'validator-listerrors-severity-message' => '{{Optional}}
* $1 = severity
* $2 = message',
	'validator-listerrors-minor' => 'This is the name of a status that is assigned to an error report.',
	'validator-listerrors-low' => 'This is the name of a status that is assigned to an error report.',
	'validator-listerrors-normal' => 'This is the name of a status that is assigned to an error report.

{{Identical|Normal}}',
	'validator-listerrors-high' => 'This is the name of a status that is assigned to an error report.',
	'validator-listerrors-fatal' => 'This is the name of a status that is assigned to an error report.',
	'validator-describe-descriptionmsg' => '{{Identical|Description}}',
	'validator-describe-listtype' => 'This is a patchwork message. $1 stands for one of these messages: {{msg-mw|Validator-type-string}}, {{msg-mw|Validator-type-number}}, {{msg-mw|Validator-type-integer}}, {{msg-mw|Validator-type-float}}, {{msg-mw|Validator-type-boolean}}, {{msg-mw|Validator-type-char}}',
	'validator-describe-empty' => '{{Identical|Empty}}',
	'validator-describe-required' => '{{Identical|Required}}',
	'validator-describe-header-parameter' => '{{Identical|Parameter}}',
	'validator-describe-header-type' => '{{Identical|Type}}',
	'validator-describe-header-default' => '{{Identical|Default}}',
	'validator-describe-header-description' => '{{Identical|Description}}',
	'validator-describe-parameters' => '{{Identical|Parameter}}',
	'validator-message-nodesc' => 'Indicates that no parameter description is available',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'validator-desc' => 'Die valideerder gee ander uitbreidings die vermoë om parameters van ontlederfunksies en etiket-uitbreidings te valideer, op hulle verstekwaardes in te stel en om foutboodskappe te genereer',
	'validator-warning' => 'Waarskuwing: $ 1', # Fuzzy
	'validator-error' => 'Fout: $1',
	'validator-fatal-error' => 'Onherstelbare fout: $1',
	'validator_error_parameters' => 'Die volgende {{PLURAL:$1|fout|foute}} is in u sintaks waargeneem:',
	'validator_error_unknown_argument' => "$1 is nie 'n geldige parameter nie.",
	'validator_error_required_missing' => 'Die verpligte parameter $1 is nie verskaf nie.',
	'validator-listerrors-errors' => 'Foute',
	'validator-listerrors-minor' => 'Oorkomelik',
	'validator-listerrors-low' => 'Laag',
	'validator-listerrors-normal' => 'Gemiddeld',
	'validator-listerrors-high' => 'Groot',
	'validator-listerrors-fatal' => 'Fataal',
	'validator_error_empty_argument' => 'Die parameter $1 mag nie leeg wees nie.',
	'validator_error_must_be_number' => "Die parameter $1 mag net 'n getal wees.",
	'validator_error_must_be_integer' => "Die parameter $1 kan slegs 'n heelgetal wees.",
	'validator_error_invalid_range' => 'Die parameter $1 moet tussen $2 en $3 lê.',
	'validator_error_invalid_argument' => 'Die waarde $1 is nie geldig vir parameter $2 nie.',
	'validator_error_accepts_only' => 'Die parameter $1 kan slegs die volgende {{PLURAL:$3|waarde|waardes}} hê: $2.', # Fuzzy
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'validator-desc' => 'Validator është një zgjerim MediaWiki që ofron parametër përgjithshme trajtimin mbështetje të shtesave të tjera',
	'validator_error_parameters' => 'Më poshtë {{PLURAL:$1|gabim ka gabime|kanë}} është zbuluar në sintaksën e juaj:',
	'validator_warning_parameters' => 'Ka {{PLURAL:$1|është|janë gabime gabim}} në sintaksë tuaj.',
	'validator_error_unknown_argument' => '$1 nuk është një parametër i vlefshëm.',
	'validator_error_required_missing' => 'Parametrat e nevojshëm $1 nuk jepet.',
	'validator_error_empty_argument' => 'Parametër $1 nuk mund të ketë një vlerë bosh.',
	'validator_error_must_be_number' => 'Parametër $1 mund të jetë vetëm një numër.',
	'validator_error_must_be_integer' => 'Parametër $1 mund të jetë vetëm një numër i plotë.',
	'validator_error_invalid_range' => 'Parametër $1 duhet të jetë në mes të $2 dhe $3.',
	'validator_error_invalid_argument' => 'Vlera $1 nuk është i vlefshëm për parametër $2.',
	'validator_list_error_empty_argument' => 'Parametër $1 nuk e pranon vlerat bosh.',
	'validator_list_error_must_be_number' => 'Parametër $1 mund të përmbajë vetëm numrat.',
	'validator_list_error_must_be_integer' => 'Parametër $1 mund të përmbajë vetëm numra të plotë.',
	'validator_list_error_invalid_range' => 'Të gjitha vlerat e parametrit $1 duhet të jetë në mes të $2 dhe $3.',
	'validator_list_error_invalid_argument' => 'Një ose më shumë vlera për parametër $1 janë të pavlefshme.',
	'validator_error_accepts_only' => 'Parametër $1 vetëm pranon {{PLURAL:$3|kjo vlerë|këtyre vlerave}}: $2.', # Fuzzy
	'validator_list_omitted' => '{{PLURAL:$2 |vlerë|vlerat}} $1 {{PLURAL:$2|ka|kanë}} janë lënë jashtë.',
);

/** Arabic (العربية)
 * @author Meno25
 * @author روخو
 */
$messages['ar'] = array(
	'validator-desc' => 'المحقق يوفر طريقة سهلة للامتدادات الأخرى للتحقق من محددات دوال المحلل وامتدادات الوسوم، وضبط القيم الافتراضية وتوليد رسائل الخطأ',
	'validator-warning' => 'تحذير: $1',
	'validator-error' => 'خطأ: $1',
	'validator-fatal-error' => 'خطأ قاتل: $1',
	'validator_error_parameters' => '{{PLURAL:$1|الخطأ التالي|الاخطاء التالية}} تم كشفها في صياغتك:',
	'validator_warning_parameters' => 'هناك {{PLURAL:$1|خطأ|أخطاء}} في صياغتك.',
	'validator_error_unknown_argument' => '$1 ليس محددا صحيحا.',
	'validator_error_required_missing' => 'المحدد المطلوب $1 ليس متوفرا.',
	'validator-type-string' => 'نص',
	'validator-type-float' => 'رقم',
	'validator-type-boolean' => 'نعم/لا',
	'validator-type-title' => 'عنوان',
	'validator-listerrors-errors' => 'أخطاء',
	'validator-listerrors-minor' => 'ثانوي',
	'validator-listerrors-low' => 'منخفض',
	'validator-listerrors-normal' => 'طبيعي',
	'validator-listerrors-high' => 'مرتفع',
	'validator-listerrors-fatal' => 'قاتل',
	'validator-describe-descriptionmsg' => "'''وصف''': $1",
	'validator-describe-empty' => 'فارغ',
	'validator-describe-required' => 'مطلوب',
	'validator-describe-header-parameter' => 'محدد',
	'validator-describe-header-type' => 'نوع',
	'validator-describe-header-default' => 'افتراضي',
	'validator-describe-header-description' => 'الوصف',
	'validator-describe-parameters' => 'محددات',
	'validator-describe-syntax' => 'صياغة',
	'validator_error_empty_argument' => 'المحدد $1 لا يمكن أن تكون قيمته فارغة.',
	'validator_error_must_be_number' => 'المحدد $1 يمكن أن يكون فقط عددا.',
	'validator_error_must_be_integer' => 'المحدد $1 يمكن أن يكون عددا صحيحا فقط.',
	'validator_error_invalid_range' => 'المحدد $1 يجب أن يكون بين $2 و $3.',
	'validator_error_invalid_argument' => 'القيمة $1 ليست صحيحة للمحدد $2.',
	'validator_list_error_empty_argument' => 'المحدد $1 لا يقبل القيم الفارغة.',
	'validator_list_error_must_be_number' => 'المحدد $1 يمكن أن يحتوي فقط على أرقام.',
	'validator_list_error_must_be_integer' => 'المحدد $1 يمكن أن يحتوي فقط على أرقام صحيحة.',
	'validator_list_error_invalid_range' => 'كل قيم المحدد $1 يجب أن تكون بين $2 و$3.',
	'validator_list_error_invalid_argument' => 'قيمة واحدة أو أكثر للمحدد $1 غير صحيحة.',
	'validator_error_accepts_only' => 'المحدد $1 يقبل فقط {{PLURAL:$3|هذه القيمة|هذه القيم}}: $2.', # Fuzzy
	'validator_list_omitted' => '{{PLURAL:$2|القيمة|القيم}} $1 {{PLURAL:$2|تم|تم}} مسحها.',
	'validator-message-nodesc' => 'لا وصف تم توفيره',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'validator-desc' => 'Правяраючы палягчае іншым пашырэньням працу па праверцы парамэтраў функцыяў парсэру і тэгаў пашырэньняў, устанаўлівае значэньні па змоўчваньні і стварае паведамленьні пра памылкі',
	'validator-warning' => 'Папярэджаньне: $1',
	'validator-error' => 'Памылка: $1',
	'validator-fatal-error' => 'Крытычная памылка: $1',
	'validator_error_parameters' => 'У сынтаксісе {{PLURAL:$1|выяўленая наступная памылка|выяўленыя наступныя памылкі}}:',
	'validator_warning_parameters' => 'У Вашы сынтаксісе {{PLURAL:$1|маецца памылка|маюцца памылкі}}.',
	'validator-warning-adittional-errors' => '... і {{PLURAL:$1|яшчэ адна праблема|яшчэ некалькі праблемаў}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Значэньне «$1» было прапушчанае|Значэньні «$1» былі прапушчаныя}}.',
	'validator-error-problem' => 'Узьнікла праблема з парамэтрам $1.',
	'validator_error_unknown_argument' => 'Няслушны парамэтар $1.',
	'validator_error_required_missing' => 'Не пададзены абавязковы парамэтар $1.',
	'validator-error-override-argument' => 'Спрабаваў памяняць значэньне парамэтру $1 з «$2» на «$3»',
	'validator-type-string' => 'тэкст',
	'validator-type-integer' => 'цэлы лік',
	'validator-type-float' => 'лік',
	'validator-type-boolean' => 'так/не',
	'validator-type-char' => 'сымбаль',
	'validator-type-title' => 'назва',
	'validator-type-string-list' => 'сьпіс тэкстаў',
	'validator-type-integer-list' => 'сьпіс цэлых лікаў',
	'validator-type-float-list' => 'сьпіс лічбаў',
	'validator-type-boolean-list' => 'сьпіс «так/не»',
	'validator-type-char-list' => 'сьпіс сымбаляў',
	'validator-type-title-list' => 'сьпіс загалоўкаў',
	'validator-listerrors-errors' => 'Памылкі',
	'validator-listerrors-minor' => 'Дробная',
	'validator-listerrors-low' => 'Малая',
	'validator-listerrors-normal' => 'Звычайная',
	'validator-listerrors-high' => 'Значная',
	'validator-listerrors-fatal' => 'Фатальная',
	'validator-listerrors-description' => 'Пералічвае памылкі (і папярэджаньні), якія адбыліся ў працэдурах-перахопніках парсэра, дададзеных праз Validator.
Паказваюцца толькі працэдуры-перахопнікі парсэра, якія знаходзяцца Вышэй listerrors.
Зьмясьціце listerrors у самы канец старонкі, каб атрымаць сьпіс усіх памылак.',
	'validator-listerrors-par-minseverity' => 'Мінімальная сур’ёзнасьць праблемы, для таго каб яна была ўключаная ў сьпіс.',
	'validator-describe-description' => 'Стварае дакумэнтацыю для аднаго ці болей працэдур-перахопнікаў парсэра, атрымаўшым вызначэньне праз Validator.',
	'validator-describe-notfound' => 'Не існуе працэдур-перахопніка парсэра для «$1».',
	'validator-describe-descriptionmsg' => "'''Апісаньне''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Псэўданім|Псэўданімы}}''': $1",
	'validator-describe-parserfunction' => 'Рэалізаваная толькі функцыя парсэру.',
	'validator-describe-tagextension' => 'Рэалізаваная толькі як пашырэньне тэгу.',
	'validator-describe-bothhooks' => 'Рэалізаваная як функцыя парсэру і як пашырэньне тэгу.',
	'validator-describe-par-hooks' => 'Працэдура-перахопнік парсэра, для якой паказваць дакумэнтацыю.',
	'validator-describe-par-pre' => 'Дазваляе Вам атрымліваць актуальны вікі-тэкст для дакумэнтацыі, без паказу на старонцы.',
	'validator-describe-par-language' => 'Мова, на якой паказваць апісаньні',
	'validator-describe-listtype' => 'Сьпіс элемэнтаў $1',
	'validator-describe-empty' => 'пуста',
	'validator-describe-required' => 'абавязкова',
	'validator-describe-header-parameter' => 'Парамэтар',
	'validator-describe-header-aliases' => 'Псэўданімы',
	'validator-describe-header-type' => 'Тып',
	'validator-describe-header-default' => 'Па змоўчваньні',
	'validator-describe-header-description' => 'Апісаньне',
	'validator-describe-parameters' => 'Парамэтры',
	'validator-describe-syntax' => 'Сынтаксіс',
	'validator-describe-tagmin' => 'Пашырэньне тэга, якое мае толькі неабходныя парамэтры.',
	'validator-describe-tagmax' => 'Пашырэньне тэга з усімі парамэтрамі.',
	'validator-describe-tagdefault' => 'Пашырэньне тэга з усімі парамэтрамі, выкарыстаньнем запісаў парамэтраў па змоўчваньні.',
	'validator-describe-pfmin' => 'Функцыя парсэра, якае мае толькі неабходныя парамэтры.',
	'validator-describe-pfmax' => 'Функцыя парсэра з усімі парамэтрамі.',
	'validator-describe-pfdefault' => 'Функцыя парсэра з усімі парамэтрамі, выкарыстаньнем запісаў парамэтраў па змоўчваньні.',
	'validator-describe-autogen' => 'Зьмест гэтай сэкцыі быў аўтаматычна створаны працэдурай-перахопнікам парсэра «describe» пашырэньня Validator.',
	'validator_error_empty_argument' => 'Парамэтар $1 ня можа мець пустое значэньне.',
	'validator_error_must_be_number' => 'Парамэтар $1 можа быць толькі лікам.',
	'validator_error_must_be_integer' => 'Парамэтар $1 можа быць толькі цэлым лікам.',
	'validator_error_must_be_title' => 'Парамэтар $1 можа быць роўны толькі слушнай назьве вікістаронкі.',
	'validator_error_must_be_existing_title' => 'Парамэтар $1 можа быць роўны толькі назьве наяўнай вікістаронкі.',
	'validator-error-must-be-float' => 'Парамэтар $1 можа быць толькі лікам з плаваючай коскай.',
	'validator_error_invalid_range' => 'Парамэтар $1 павінен быць паміж $2 і $3.',
	'validator-error-invalid-regex' => 'парамэтар $1 мусіць адпавядаць гэтаму рэгулярнаму выразу: $2.',
	'validator-error-invalid-length' => 'Парамэтар $1 павінен мець даўжыню $2.',
	'validator-error-invalid-length-range' => 'Парамэтар $1 павінен мець даўжыню паміж $2 і $3.',
	'validator_error_invalid_argument' => 'Значэньне $1 не зьяўляецца слушным для парамэтру $2.',
	'validator_list_error_empty_argument' => 'Парамэтар $1 ня можа прымаць пустыя значэньні.',
	'validator_list_error_must_be_number' => 'Парамэтар $1 можа ўтрымліваць толькі лікі.',
	'validator_list_error_must_be_integer' => 'Парамэтар $1 можа ўтрымліваць толькі цэлыя лікі.',
	'validator_list_error_must_be_title' => 'Парамэтра $1 можа ўтрымліваць толькі слушныя назвы вікістаронак.',
	'validator_list_error_must_be_existing_title' => 'Парамэтар $1 можа ўтрымліваць толькі назвы наяўных вікістаронак.',
	'validator-list-error-must-be-float' => 'Парамэтар $1 можа ўтрымліваць толькі лікі з плаваючай кропкай.',
	'validator_list_error_invalid_range' => 'Усе значэньні парамэтру $1 павінны знаходзіцца паміж $2 і $3.',
	'validator-list-error-invalid-regex' => 'Усе значэньні парамэтру $1 мусяць адпавядаць гэтаму рэгулярнаму выразу: $2.',
	'validator_list_error_invalid_argument' => 'Адно ці болей значэньняў парамэтру $1 зьяўляюцца няслушнымі.',
	'validator-list-error-accepts-only' => 'Адзін ці некалькі значэньняў парамэтру $1 зьяўляюцца няслушнымі.
{{PLURAL:$3|Ён мусіць мець наступнае значэньне|Яны мусяць мець наступныя значэньні}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Адзін ці некалькі значэньняў парамэтру $1 зьяўляюцца няслушнымі.
{{PLURAL:$3|Ён мусіць мець наступнае значэньне|Яны мусяць мець наступныя значэньні}}: $2. (і $4  {{PLURAL:$4|прапушчанае значэньне|прапушчаныя значэньні|прапушчаных значэньняў}}).',
	'validator_error_accepts_only' => 'Значэньне «$4» зьяўляецца няслушным для парамэтру $1. Ён можа прымаць толькі {{PLURAL:$3|гэтае значэньне|гэтыя значэньні}}: $2.',
	'validator-error-accepts-only-omitted' => 'Значэньне «$2» зьяўляецца няслушным для парамэтру $1.
{{PLURAL:$5|Ён мусіць мець наступнае значэньне|Яны мусяць мець наступныя значэньні}}: $3. (і $4  {{PLURAL:$4|прапушчанае значэньне|прапушчаныя значэньні|прапушчаных значэньняў}}).',
	'validator_list_omitted' => '{{PLURAL:$2|Значэньне|Значэньні}} $1 {{PLURAL:$2|было прапушчанае|былі прапушчаныя}}.',
	'validator-message-nodesc' => 'Апісаньне не пазначанае',
);

/** Bulgarian (български)
 * @author DCLXVI
 * @author Reedy
 */
$messages['bg'] = array(
	'validator_error_empty_argument' => 'Параметърът $1 не може да има празна стойност.', # Fuzzy
);

/** Bengali (বাংলা)
 * @author Ehsanulhb
 */
$messages['bn'] = array(
	'validator-describe-descriptionmsg' => "'''বিবরণ''': $1",
	'validator-describe-header-description' => 'বিবরণ',
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Gwendal
 * @author Y-M D
 */
$messages['br'] = array(
	'validator-desc' => 'Un doare aes eo kadarnataer evit an astennoù all da gadarnaat arventennoù ar fonksionoù parser hag astennoù ar balizennoù, evit termeniñ talvoudennoù dre ziouer ha sevel kemennoù fazioù',
	'validator-warning' => 'Diwallit : $1',
	'validator-error' => 'Fazi : $1',
	'validator-fatal-error' => 'Fazi diremed: $1',
	'validator_error_parameters' => "Kavet eo bet ar {{PLURAL:$1|fazi|fazioù}} da-heul en hoc'h ereadur :",
	'validator_warning_parameters' => "{{PLURAL:$1|Ur fazi|Fazioù}} zo en hoc'h ereadur.",
	'validator-warning-adittional-errors' => '... {{PLURAL:$1|hag ur gudenn bennak all|ha meur a gudenn all}}.',
	'validator-error-omitted' => 'N\'eo ket bet merket ar {{PLURAL:$2|roadenn "$1"|roadennoù "$1"}}.',
	'validator-error-problem' => 'Ur gudenn zo bet gant an arventenn $1.',
	'validator_error_unknown_argument' => "$1 n'eo ket un arventenn reizh.",
	'validator_error_required_missing' => "N'eo ket bet pourchaset an arventenn rekis $1",
	'validator-error-override-argument' => 'Klasket en deus ar meziant erlec\'hiañ an arventenn $1 (talvoud : $2) gant an talvoud "$3"',
	'validator-type-string' => 'testenn',
	'validator-type-integer' => 'Niver klok',
	'validator-type-float' => 'niver',
	'validator-type-boolean' => 'ya/nann',
	'validator-type-char' => 'arouezenn',
	'validator-type-title' => 'titl',
	'validator-type-string-list' => 'roll testennoù',
	'validator-type-integer-list' => 'roll niveroù anterin',
	'validator-type-float-list' => 'roll niveroù',
	'validator-type-boolean-list' => 'roll ya/ket',
	'validator-type-char-list' => 'roll arouezennoù',
	'validator-type-title-list' => 'roll titiloù',
	'validator-listerrors-errors' => 'Fazioù',
	'validator-listerrors-minor' => 'Minor',
	'validator-listerrors-low' => 'Gwan',
	'validator-listerrors-normal' => 'Reizh',
	'validator-listerrors-high' => 'Uhel',
	'validator-listerrors-fatal' => 'Diremed',
	'validator-describe-descriptionmsg' => "'''Deskrivadur''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasoù}}''': $1",
	'validator-describe-listtype' => 'Roll gant $1 elfenn',
	'validator-describe-empty' => 'goullo',
	'validator-describe-required' => 'rekis',
	'validator-describe-header-parameter' => 'Arventenn',
	'validator-describe-header-aliases' => 'Aliasoù',
	'validator-describe-header-type' => 'Seurt',
	'validator-describe-header-default' => 'Diouer',
	'validator-describe-header-description' => 'Deskrivadur',
	'validator-describe-parameters' => 'Arventennoù',
	'validator-describe-syntax' => 'Ereadurezh',
	'validator_error_empty_argument' => "N'hall ket an arventenn $1 bezañ goullo he zalvoudenn",
	'validator_error_must_be_number' => 'Un niver e rank an arventenn $1 bezañ hepken.',
	'validator_error_must_be_integer' => 'Rankout a ra an arventenn $1 bezañ un niver anterin.',
	'validator-error-must-be-float' => 'Rankout a ra an arventenn $1 bezañ un niver skej war-neuñv.',
	'validator_error_invalid_range' => 'Rankout a ra an arventenn $1 bezañ etre $2 hag $3.',
	'validator-error-invalid-regex' => 'Rankout a ra an arventenn $1 klotañ gant ar jedad poellek-mañ : $2.',
	'validator-error-invalid-length' => "Ret eo d'an arventenn $1 bezañ par he hed da $2.",
	'validator-error-invalid-length-range' => 'Rankout a ra an arventenn $1 bezañ he hed etre $2 hag $3.',
	'validator_error_invalid_argument' => "N'eo ket reizh an dalvoudenn $1 evit an arventenn $2.",
	'validator_list_error_empty_argument' => 'Ne zegemer ket an arventenn $1 an talvoudennoù goullo.',
	'validator_list_error_must_be_number' => "N'hall bezañ nemet niveroù en arventenn $1.",
	'validator_list_error_must_be_integer' => "N'hall bezañ nemet niveroù anterin en arventenn $1.",
	'validator-list-error-must-be-float' => "N'hall bezañ nemet niveroù gant skej en arventenn $1.",
	'validator_list_error_invalid_range' => 'An holl talvoudennoù eus an arventenn $1 a rank bezañ etre $2 ha $3.',
	'validator-list-error-invalid-regex' => 'Rankout a ra holl dalvoudoù an arventenn $1 klotañ gant ar jedad poellek-mañ : $2.',
	'validator_list_error_invalid_argument' => 'Faziek eo unan pe meur a dalvoudenn eus an arventenn $1.',
	'validator-list-error-accepts-only' => 'Direizh eo unan pe meur a hini eus an talvoudoù evit an arventenn $1.
Ne zegemer nemet an {{PLURAL:$3|talvoud|talvoudoù}}-mañ : $2.',
	'validator-list-error-accepts-only-omitted' => 'Direizh eo unan pe meur a hini eus an talvoudoù evit an arventenn $1.
Ne zegemer nemet an {{PLURAL:$3|talvoud|talvoudoù}}-mañ : $2 (ha $4 {{PLURAL:$4|talvoud anroet|talvoud anroet}}).',
	'validator_error_accepts_only' => 'Ne zegemer ket an arventenn $1 an talvoud "$4". Ne zegemer nemet {{PLURAL:$3|an talvoud|an talvoudoù}}-mañ : $2.',
	'validator-error-accepts-only-omitted' => 'Direizh eo an talvoud "$2" evit an arventenn $1.
Ne zegemer nemet an {{PLURAL:$5|talvoud|talvoudoù}}-mañ : $3 (ha $4 {{PLURAL:$4|talvoud anroet|talvoud anroet}}).',
	'validator_list_omitted' => 'Disoñjet eo bet an {{PLURAL:$2|talvoudenn|talvoudennoù}} $1.',
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'validator-desc' => 'Validator pruža jednostavni način za druga proširenja u svrhu validacije parametara parserskih funkcija i proširenja oznaka, postavlja pretpostavljene vrijednosti i generira poruke pogrešaka.',
	'validator-warning' => 'Upozorenje: $1',
	'validator-error' => 'Greška: $1',
	'validator-fatal-error' => 'Fatalna greška: $1',
	'validator_error_parameters' => 'U Vašoj sintaksi {{PLURAL:$1|je|su}} {{PLURAL:$1|otkivena slijedeća greška|otkrivene slijedeće greške}}:',
	'validator_warning_parameters' => '{{PLURAL:$1|Postoji greška|Postoje greške}} u Vašoj sintaksi.',
	'validator-warning-adittional-errors' => '... i {{PLURAL:$1|još jedan problem|još nekoliko problema}}.',
	'validator_error_unknown_argument' => '$1 nije valjan parametar.',
	'validator_error_required_missing' => 'Obavezni parametar $1 nije naveden.',
	'validator-error-override-argument' => 'Pokušano da se preskoči parametar $1 (vrijednost: $2) vrijednošću "$3"',
	'validator-listerrors-normal' => 'Normalno',
	'validator_error_empty_argument' => 'Parametar $1 ne može imati praznu vrijednost.',
	'validator_error_must_be_number' => 'Parametar $1 može biti samo broj.',
	'validator_error_must_be_integer' => 'Parametar $1 može biti samo cijeli broj.',
	'validator-error-must-be-float' => 'Parametar $1 može biti samo broj sa plutajućim zarezom.',
	'validator_error_invalid_range' => 'Parametar $1 mora biti između $2 i $3.',
	'validator-error-invalid-length' => 'Parametar $1 mora imati dužinu $2.',
	'validator-error-invalid-length-range' => 'Parametar $1 mora imati dužinu između $2 i $3.',
	'validator_error_invalid_argument' => 'Vrijednost $1 nije valjana za parametar $2.',
	'validator_list_error_empty_argument' => 'Parametar $1 ne prima prazne vrijednosti.',
	'validator_list_error_must_be_number' => 'Parametar $1 može sadržavati samo brojeve.',
	'validator_list_error_must_be_integer' => 'Parametar $1 može sadržavati samo cijele brojeve.',
	'validator_list_error_invalid_range' => 'Sve vrijednosti parametra $1 moraju biti između $2 i $3.',
	'validator_list_error_invalid_argument' => 'Jedna ili više vrijednosti za parametar $1 nisu valjane.',
	'validator_error_accepts_only' => 'Vrijednost "$4" nije valjana za parametar $1. On prihvata samo {{PLURAL:$3|ovu vrijednost|ove vrijednosti}}: $2.',
	'validator_list_omitted' => '{{PLURAL:$2|Vrijednost|Vrijednosti}} $1 {{PLURAL:$2|je ispuštena|su ispuštene}}.',
);

/** Czech (česky)
 * @author Matěj Grabovský
 * @author Mormegil
 * @author Reaperman
 */
$messages['cs'] = array(
	'validator-desc' => 'Validátor poskytuje ostatním rozšířením snadnější způsob ověřování parametrů funkcí parseru a značek, nastavování výchozích hodnot a vytváření chybových zpráv.',
	'validator-warning' => 'Varování: $1',
	'validator-error' => 'Chyba: $1',
	'validator-fatal-error' => 'Kritická chyba: $1',
	'validator_error_parameters' => 'Ve vaší syntaxi {{PLURAL:$1|byla nalezena následující chyba|byly nalezeny následující chyby}}:',
	'validator_warning_parameters' => 'Ve vaší syntaxi {{PLURAL:$1|je chyba|jsou chyby}}.',
	'validator_error_unknown_argument' => '$1 není platný parametr.',
	'validator_error_required_missing' => 'Povinný parameter $1 nebyl specifikován.',
	'validator-type-string' => 'text',
	'validator-type-integer' => 'celé číslo',
	'validator-type-boolean' => 'ano/ne',
	'validator-type-char' => 'znak',
	'validator-listerrors-errors' => 'Chyby',
	'validator-listerrors-low' => 'Nízká',
	'validator-listerrors-normal' => 'Střední',
	'validator-listerrors-high' => 'Vysoká',
	'validator-listerrors-fatal' => 'Kritická',
	'validator-describe-descriptionmsg' => "''' Popis ''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasy}}''': $1",
	'validator-describe-header-parameter' => 'Parametr',
	'validator-describe-header-aliases' => 'Aliasy',
	'validator-describe-header-type' => 'Typ',
	'validator-describe-header-default' => 'Výchozí',
	'validator-describe-header-description' => 'Popis',
	'validator-describe-parameters' => 'Parametry',
	'validator-describe-syntax' => 'Syntaxe',
	'validator_error_empty_argument' => 'Parametr $1 nemůže být prázdný.',
	'validator_error_must_be_number' => 'Parametr $1 může být pouze číslo.',
	'validator_error_must_be_integer' => 'Parametr $1 může být pouze celé číslo.',
	'validator_error_invalid_range' => 'Parametr $1 musí být v rozmezí $2 až $3.',
	'validator-error-invalid-regex' => 'Parametr  $1  musí odpovídat tomuto regulárnímu výrazu:  $2.',
	'validator_error_invalid_argument' => '$1 není platná hodnota pro parametr $2.',
	'validator_list_error_empty_argument' => 'Parametr $1 npeřijímá prázdné hoodnoty.',
	'validator_list_error_must_be_number' => 'Parametr $1 může obsahovat pouze čísla.',
	'validator_list_error_must_be_integer' => 'Paramter $1 může obsahovat pouze celá čísla.',
	'validator_list_error_must_be_title' => 'Parametr  $1  může obsahovat pouze platné názvy wiki stránek.',
	'validator_list_error_must_be_existing_title' => 'Parametr  $1  může obsahovat pouze názvy existujících wiki stránek.',
	'validator_list_error_invalid_range' => 'Všechny hodnoty parametru $1 musí být v rozmezí $2 až $3.',
	'validator-list-error-invalid-regex' => 'Všechny hodnoty parametru  $1  musí odpovídat tomuto regulárnímu výrazu:  $2.',
	'validator_list_error_invalid_argument' => 'Jedna nebo více hodnot parametru $1 jsou neplatné.',
	'validator_error_accepts_only' => 'Parametr $1 nemůže mít hodnotu „$4“; přijímá pouze {{PLURAL:$3|tuto hodnotu|tyto hodnoty}}: $2.',
	'validator_list_omitted' => '{{PLURAL:$2|Hodnota $1 byla vynechána|Hodnoty $1 byly vynechány}}.',
);

/** German (Deutsch)
 * @author DaSch
 * @author Imre
 * @author Kghbln
 * @author LWChris
 * @author Metalhead64
 * @author Purodha
 */
$messages['de'] = array(
	'validator-desc' => 'Ermöglicht anderen Programmerweiterungen die Verarbeitung von Parametern',
	'validator-warning' => 'Warnung: $1',
	'validator-error' => 'Fehler: $1',
	'validator-fatal-error' => "'''Schwerwiegender Fehler:''' $1",
	'validator_error_parameters' => '{{PLURAL:$1|Der folgende Fehler wurde|Die folgenden Fehler wurden}} in der Syntax gefunden:',
	'validator_warning_parameters' => '{{PLURAL:$1|Es ist ein Fehler|Es sind Fehler}} in der Syntax.',
	'validator-warning-adittional-errors' => '… und {{PLURAL:$1|ein weiteres Problem|weitere Probleme}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Der Wert „$1“ wurde|Die Werte „$1“ wurden}} ausgelassen.',
	'validator-error-problem' => 'Es gab ein Problem mit Parameter $1.',
	'validator_error_unknown_argument' => '„$1“ ist kein gültiger Parameter.',
	'validator_error_required_missing' => 'Der notwendige Parameter „$1“ wurde nicht angegeben.',
	'validator-error-override-argument' => 'Es wurde versucht Parameter $1 ($2) mit dem Wert „$3“ zu überschreiben.',
	'validator-type-string' => 'Text',
	'validator-type-integer' => 'Ganzzahl',
	'validator-type-float' => 'Gleitkommazahl',
	'validator-type-boolean' => 'ja/nein',
	'validator-type-char' => 'Zeichen',
	'validator-type-title' => 'Titel',
	'validator-type-string-list' => 'Liste mit Texten',
	'validator-type-integer-list' => 'Liste mit ganzen Zahlen',
	'validator-type-float-list' => 'Liste mit Zahlen',
	'validator-type-boolean-list' => 'Liste mit Ja/Nein-Angaben',
	'validator-type-char-list' => 'Liste mit Zeichen',
	'validator-type-title-list' => 'Liste mit Seitennamen',
	'validator-listerrors-errors' => 'Fehler',
	'validator-listerrors-minor' => 'Marginal',
	'validator-listerrors-low' => 'Klein',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Groß',
	'validator-listerrors-fatal' => 'Schwerwiegend',
	'validator-listerrors-description' => 'Zeigt Fehler und Warnungen an, die bei über die Erweiterung Validator genutzten Parsererweiterungen auftraten.
Sie zeigt sie lediglich für die Parsererweiterungen an, die oberhalb des Tags „<code>listerrors</code>“ eingefügt wurden. „<code>listerrors</code>“ sollte daher am oder gegen Ende der Seite eingefügt werden, um alle Fehler und Warnungen angezeigt zu bekommen.',
	'validator-listerrors-par-minseverity' => 'Der Mindestschweregrad eines Problems, damit dieses angezeigt wird.',
	'validator-describe-description' => 'Erzeugt die Dokumentation für eine oder mehrere Parsererweiterungen, die über die Erweiterung Validator definiert wurden.',
	'validator-describe-notfound' => 'Es ist keine Parsererweiterung vorhanden, die „$1“ verarbeitet.',
	'validator-describe-descriptionmsg' => "'''Beschreibung:''' $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasse}}:''' $1",
	'validator-describe-parserfunction' => 'Sie ist lediglich als Parsererweiterung in Form einer Funktion implementiert.',
	'validator-describe-tagextension' => 'Sie ist lediglich als Parsererweiterung in Form eines Tags implementiert.',
	'validator-describe-bothhooks' => 'Sie ist sowohl als Parsererweiterung in Form einer Funktion wie auch eines Tags implementiert.',
	'validator-describe-par-hooks' => 'Die Parsererweiterungen zu der die Dokumentation angezeigt werden soll.',
	'validator-describe-par-pre' => 'Ermöglicht die Ausgabe der Dokumentation in Wikitext, wobei dieser nicht gerendert wird.',
	'validator-describe-par-language' => 'Die Sprache in der die Beschreibungen angezeigt werden sollen',
	'validator-describe-listtype' => 'Liste von Elementen: $1',
	'validator-describe-empty' => 'leer',
	'validator-describe-required' => 'erforderlich',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Aliasse',
	'validator-describe-header-type' => 'Typ',
	'validator-describe-header-default' => 'Standard',
	'validator-describe-header-description' => 'Beschreibung',
	'validator-describe-parameters' => 'Parameter',
	'validator-describe-syntax' => 'Syntax',
	'validator-describe-tagmin' => 'Parsererweiterung als Tag, nur mit den erforderlichen Parametern.',
	'validator-describe-tagmax' => 'Parsererweiterung als Tag mitsamt allen Parametern.',
	'validator-describe-tagdefault' => 'Parsererweiterung als Tag mitsamt allen Parametern, welche die Standardnotation für Parameter nutzen.',
	'validator-describe-pfmin' => 'Parsererweiterung als Funktion, nur mit den erforderlichen Parametern.',
	'validator-describe-pfmax' => 'Parsererweiterung als Funktion mitsamt allen Parametern.',
	'validator-describe-pfdefault' => 'Parsererweiterung als Funktion mitsamt allen Parametern, welche die Standardnotation für Parameter nutzen.',
	'validator-describe-autogen' => 'Der Inhalt dieses Abschnitts wurde automatisch mit Hilfe der Parserfunktion „<code>describe</code>“ der Erweiterung Validator erstellt.',
	'validator_error_empty_argument' => 'Parameter $1 kann keinen leeren Wert haben.',
	'validator_error_must_be_number' => 'Parameter $1 kann nur eine Nummer sein.',
	'validator_error_must_be_integer' => 'Parameter $1 kann nur eine ganze Zahl sein.',
	'validator_error_must_be_title' => 'Parameter $1 kann nur ein gültiger Seitenname sein.',
	'validator_error_must_be_existing_title' => 'Parameter $1 kann nur ein vorhandener Seitenname sein.',
	'validator-error-must-be-float' => 'Parameter $1 kann nur eine Gleitkommazahl sein.',
	'validator_error_invalid_range' => 'Parameter $1 muss zwischen $2 und $3 liegen.',
	'validator-error-invalid-regex' => 'Parameter $1 muss diesem regulären Ausdruck entsprechen: $2.',
	'validator-error-invalid-length' => 'Parameter $1 muss eine Länge von $2 haben.',
	'validator-error-invalid-length-range' => 'Parameter $1 muss eine Länge zwischen $2 und $3 haben.',
	'validator_error_invalid_argument' => 'Der Wert $1 ist nicht gültig für den Parameter $2.',
	'validator_list_error_empty_argument' => 'Parameter $1 akzeptiert keine leeren Werte.',
	'validator_list_error_must_be_number' => 'Parameter $1 kann nur Ziffern enthalten.',
	'validator_list_error_must_be_integer' => 'Parameter $1 kann nur ganze Zahlen enthalten.',
	'validator_list_error_must_be_title' => 'Parameter $1 kann nur gültige Seitennamen enthalten.',
	'validator_list_error_must_be_existing_title' => 'Parameter $1 kann nur vorhandene Seitennamen enthalten.',
	'validator-list-error-must-be-float' => 'Parameter $1 kann nur Gleitkommazahlen enthalten.',
	'validator_list_error_invalid_range' => 'Alle Werte des Parameters $1 müssen zwischen $2 und $3 liegen.',
	'validator-list-error-invalid-regex' => 'Alle Werte des Parameters $1 müssen diesem regulären Ausdruck entsprechen: $2.',
	'validator_list_error_invalid_argument' => 'Einer oder mehrere Werte für Parameter $1 sind ungültig.',
	'validator-list-error-accepts-only' => 'Einer oder mehrere Werte für Parameter $1 sind ungültig.
Nur {{PLURAL:$3|der folgende Wert wird|die folgenden Werte werden}} akzeptiert: $2.',
	'validator-list-error-accepts-only-omitted' => 'Einer oder mehrere Werte für Parameter $1 sind ungültig.
Nur {{PLURAL:$3|der folgende Wert wird|die folgenden Werte werden}} akzeptiert: $2 (sowie $4 ausgelassene {{PLURAL:$4|Wert|Werte}}).',
	'validator_error_accepts_only' => 'Der Wert „$4“ ist nicht gültig für den Parameter $1. Nur {{PLURAL:$3|der folgende Wert wird|die folgenden Werte werden}} akzeptiert: $2.',
	'validator-error-accepts-only-omitted' => 'Der Wert „$2“ ist nicht gültig für den Parameter $1. Nur {{PLURAL:$5|der folgende Wert wird|die folgenden Werte werden}} akzeptiert: $3 (sowie $4 nicht angezeigte {{PLURAL:$4|Wert|Werte}}).',
	'validator_list_omitted' => '{{PLURAL:$2|Der Wert „$1“ wurde|Die Werte „$1“ wurden}} ausgelassen.',
	'validator-message-nodesc' => 'Die Beschreibung dieses Parameters ist nicht vorhanden',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 */
$messages['diq'] = array(
	'validator-listerrors-errors' => 'Xırabi',
	'validator-listerrors-minor' => 'Qıcek',
	'validator-listerrors-low' => 'Kêm',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Berz',
	'validator-describe-required' => 'mecburiyo',
	'validator-describe-header-parameter' => 'Parametre',
	'validator-describe-header-type' => 'Babet',
	'validator-describe-header-default' => 'Hesıbyaye',
	'validator-describe-header-description' => 'Sılasnayış',
	'validator-describe-parameters' => 'Parametrey',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'validator-desc' => 'Validator stoj lažki nałog za druge rozšyrjenja k dispoziciji, aby se pśekontrolěrowali parametry parserowych funkcijow a toflickich rozšyrjenjow, nastajili standardne gódnoty a napórali zmólkowe powěsći',
	'validator-warning' => 'Warnowanje: $1',
	'validator-error' => 'Zmólka: $1',
	'validator-fatal-error' => 'Rozwažna zmólka: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Slědujuca zmólka jo se namakała|Slědujucej zmólce stej se namakałej|Slědujuce zmólki su se namakali|Slědujuce zmólki su se namakali}} w twójej syntaksy:',
	'validator_warning_parameters' => '{{PLURAL:$1|Jo zmólka|Stej zmólce|Su zmólki|Su zmólki}} w twójej syntaksy.',
	'validator-error-problem' => 'Jo był problem z parametrom $1.',
	'validator_error_unknown_argument' => '$1 njejo płaśiwy parameter.',
	'validator_error_required_missing' => 'Trěbny parameter $1 njejo pódany.',
	'validator-type-string' => 'tekst',
	'validator-type-integer' => 'ceła licba',
	'validator-type-float' => 'licba',
	'validator-type-boolean' => 'jo/ně',
	'validator-type-char' => 'znamuško',
	'validator-listerrors-errors' => 'Zmólki',
	'validator-listerrors-minor' => 'Snadna',
	'validator-listerrors-low' => 'Niska',
	'validator-listerrors-normal' => 'Normalna',
	'validator-listerrors-high' => 'Wusoka',
	'validator-listerrors-fatal' => 'Rozwažna',
	'validator-describe-descriptionmsg' => "'''wopisanje''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasa|Aliase|Aliase}}''': $1",
	'validator-describe-listtype' => 'Lisćina $1 {{PLURAL:$1|elementa|elementowu|elementow|elementow}}',
	'validator-describe-empty' => 'prozny',
	'validator-describe-required' => 'trěbny',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Aliase',
	'validator-describe-header-type' => 'Typ',
	'validator-describe-header-default' => 'Standard',
	'validator-describe-header-description' => 'Wopisanje',
	'validator-describe-parameters' => 'Parametry',
	'validator-describe-syntax' => 'Syntaksa',
	'validator_error_empty_argument' => 'Parameter $1 njamóžo proznu gódnotu měś.',
	'validator_error_must_be_number' => 'Parameter $1 móžo jano licba byś.',
	'validator_error_must_be_integer' => 'Parameter $1 móžo jano ceła licba byś.',
	'validator_error_invalid_range' => 'Parameter $1 musy mjazy $2 a $3 byś.',
	'validator_error_invalid_argument' => 'Gódnota $1 njejo płaśiwa za parameter $2.',
	'validator_list_error_empty_argument' => 'Parameter $1 njeakceptěrujo prozne gódnoty.',
	'validator_list_error_must_be_number' => 'Parameter $1 móžo jano licby wopśimjeś.',
	'validator_list_error_must_be_integer' => 'Parameter $1 móžo jano cełe licby wopśimjeś.',
	'validator_list_error_invalid_range' => 'Wšykne gódnoty parametra $1 muse mjazy $2 a $3 byś.',
	'validator_list_error_invalid_argument' => 'Jadna gódnota abo wěcej gódnotow za parameter $1 su njepłaśiwe.',
	'validator_error_accepts_only' => 'Gódnota "$4" njejo płaśiwa za parameter $1. Akcepteptěrujo se jano {{PLURAL:$3|toś ta gódnota|toś tej gódnośe|toś te gódnoty|toś te gódnoty}}: $2.',
	'validator_list_omitted' => '{{PLURAL:$2|Gódnota|Gódnośe|Gódnoty|Gódnoty}} $1 {{PLURAL:$2|jo se wuwóstajiła|stej se wuwóstajiłej|su se wuwóstajili|su se wuwostajili}}.',
);

/** Greek (Ελληνικά)
 * @author Dada
 * @author Lou
 * @author ZaDiak
 * @author Απεργός
 */
$messages['el'] = array(
	'validator_error_unknown_argument' => '$1 δεν είναι μια έγκυρη παράμετρος.',
	'validator_error_required_missing' => 'Λείπει η απαιτούμενη παράμετρος $1.',
	'validator_error_must_be_number' => 'Η παράμετρος $1 μπορεί να είναι μόνο αριθμός.',
	'validator_error_must_be_integer' => 'Η παράμετρος $1 μπορεί να είναι μόνο ακέραιος αριθμός.',
	'validator_list_error_must_be_number' => 'Η παράμετρος $1 μπορεί να περιέχει μόνο αριθμούς.',
	'validator_list_error_must_be_integer' => 'Η παράμετρος $1 μπορεί να περιέχει μόνο ακέραιους αριθμούς.',
	'validator_list_error_invalid_range' => 'Όλες οι τιμές της παραμέτρου $1 πρέπει να είναι μεταξύ $2 και $3.',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'validator_error_unknown_argument' => '$1 ne estas valida parametro.',
	'validator_error_required_missing' => 'La nepra parametro $1 mankas.',
	'validator_error_empty_argument' => 'Parametro $1 ne povas esti nula valoro.',
	'validator_error_must_be_number' => 'Parametro $1 nur povas esti numero.',
	'validator_error_must_be_integer' => 'Parametro $1 nur povas esti entjero.',
	'validator_error_invalid_range' => 'Parametro $1 estu inter $2 kaj $3.',
	'validator_list_error_invalid_argument' => 'Unu aŭ pliaj valoroj por parametro $1 estas malvalida.',
);

/** Spanish (español)
 * @author Armando-Martin
 * @author Crazymadlover
 * @author Imre
 * @author Translationista
 */
$messages['es'] = array(
	'validator-desc' => 'FUZZY!!! El validador es una herramienta para que otras funciones validen fácilmente parámetros de funciones de análisis y extensiones de etiquetas, establecer valores predeterminados y generar mensajes de error',
	'validator-warning' => 'Advertencia: $1',
	'validator-error' => 'Error: $1',
	'validator-fatal-error' => 'Error fatal: $1',
	'validator_error_parameters' => 'Se detectó {{PLURAL:$1|el siguiente error|los siguientes errores}} en la sintaxis empleada:',
	'validator_warning_parameters' => 'Hay {{PLURAL:$1|un error|errores}} en tu sintaxis.',
	'validator-warning-adittional-errors' => '...y {{PLURAL:$1|otro problema|muchos otros problemas}}.',
	'validator-error-omitted' => '{{PLURAL:$2|el valor "$1" ha sido  omitido|los valores "$1" han sido omitidos}}.',
	'validator-error-problem' => 'Ha habido un problema con el parámetro $1.',
	'validator_error_unknown_argument' => '$1 no es un parámetro válido.',
	'validator_error_required_missing' => 'No se ha provisto el parámetro requerido $1.',
	'validator-error-override-argument' => 'Se ha intentado sobreescribir el parámetro $1 (valor: $2) con el valor "$3"',
	'validator-type-string' => 'texto',
	'validator-type-integer' => 'número entero',
	'validator-type-float' => 'número',
	'validator-type-boolean' => 'sí/no',
	'validator-type-char' => 'carácter',
	'validator-type-title' => 'título',
	'validator-type-string-list' => 'lista de textos',
	'validator-type-integer-list' => 'lista de números enteros',
	'validator-type-float-list' => 'lista de números',
	'validator-type-boolean-list' => 'lista de sí/no',
	'validator-type-char-list' => 'listar caracteres',
	'validator-type-title-list' => 'lista de títulos',
	'validator-listerrors-errors' => 'Errores',
	'validator-listerrors-minor' => 'Menor',
	'validator-listerrors-low' => 'Bajo',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Alto',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => 'Lista los errores (y advertencias) que se produjeron en las asociaciones (hook) del analizador (parser) añadidas a través de validador.
Sólo se muestran en las listas las asociaciones del analizador agregados antes de la inserción de listerrors;
 coloque listerrors alfinal o cerca de la parte inferior de la página para obtener todos los errores.',
	'validator-listerrors-par-minseverity' => 'La gravedad mínima de una cuestión para que  aparezca en la lista.',
	'validator-describe-description' => 'Genera documentación para una o más asociaciones del analizador (parser hooks) definidas a través de Validator.',
	'validator-describe-notfound' => 'No hay ninguna asociación del analizador (parser hook) que controle "$1".',
	'validator-describe-descriptionmsg' => "'''Descripción''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Alias}}''': $1",
	'validator-describe-parserfunction' => 'Implementado sólo como función del analizador (parser).',
	'validator-describe-tagextension' => 'Implementado sólo como etiqueta de extensión.',
	'validator-describe-bothhooks' => 'Implementado como función del analizador y como etiqueta de extensión.',
	'validator-describe-par-hooks' => 'Asociación del analizador (parser hook) para que la que desea mostrar la documentación.',
	'validator-describe-par-pre' => 'Le permite obtener el texto wiki real para la documentación, sin que se procese (render) como imagen en la página.',
	'validator-describe-par-language' => 'El idioma en el que mostrar las descripciones',
	'validator-describe-listtype' => 'Lista de $1 elementos',
	'validator-describe-empty' => 'vacío',
	'validator-describe-required' => 'obligatorio',
	'validator-describe-header-parameter' => 'Parámetro',
	'validator-describe-header-aliases' => 'Alias',
	'validator-describe-header-type' => 'Tipo',
	'validator-describe-header-default' => 'Por defecto',
	'validator-describe-header-description' => 'Descripción',
	'validator-describe-parameters' => 'Parámetros',
	'validator-describe-syntax' => 'Sintaxis',
	'validator-describe-tagmin' => 'Etiqueta de extensión sólo con los parámetros obligatorios.',
	'validator-describe-tagmax' => 'Etiqueta de extensión con todos los parámetros.',
	'validator-describe-tagdefault' => 'Etiqueta de extensión con todos los parámetros, empleando la notación de los parámetros por defecto.',
	'validator-describe-pfmin' => 'Función del analizador (parser) sólo con los parámetros obligatorios.',
	'validator-describe-pfmax' => 'Función del analizador (parser) con todos los parámetros.',
	'validator-describe-pfdefault' => 'Función del analizador (parser) con todos los parámetros, empleando la notación predeterminada de los parámetros.',
	'validator-describe-autogen' => 'El contenido de esta sección fue generado automáticamente por la asociación del analizador (parser hook) "describe" de la extensión Validator.',
	'validator_error_empty_argument' => 'El parámetro $1 no puede tener un valor vacío.',
	'validator_error_must_be_number' => 'El parámetro $1 sólo puede ser un número.',
	'validator_error_must_be_integer' => 'El parámetro $1 sólo puede ser un número entero.',
	'validator_error_must_be_title' => 'El parámetro $1 sólo puede ser un nombre de página wiki válido.',
	'validator_error_must_be_existing_title' => 'El parámetro $1 sólo puede ser un nombre de página wiki existente.',
	'validator-error-must-be-float' => 'El parámetro $1 tiene que ser un número de punto flotante.',
	'validator_error_invalid_range' => 'El parámetro $1 debe ser entre $2 y $3.',
	'validator-error-invalid-regex' => 'El parámetro $1 tiene que coincidir con esta expresión racional : $2.',
	'validator-error-invalid-length' => 'El parámetro $1 tiene que tener una longitud de $2.',
	'validator-error-invalid-length-range' => 'El parámetro $1 tiene que tener una longitud comprendida entre $2 y $3.',
	'validator_error_invalid_argument' => 'El valor $1 no es válido para el parámetro $2.',
	'validator_list_error_empty_argument' => 'El parámetro $1 no acepta valores vacíos.',
	'validator_list_error_must_be_number' => 'El parámetro $1 sólo puede contener números.',
	'validator_list_error_must_be_integer' => 'El parámetro $1 sólo puede contener números enteros.',
	'validator_list_error_must_be_title' => 'El parámetro $1 sólo puede contener nombres válidos de página wiki.',
	'validator_list_error_must_be_existing_title' => 'El parámetro $1 sólo puede contener nombres de páginas wiki existentes.',
	'validator-list-error-must-be-float' => 'El parámetro $1 sólo puede contener floats.',
	'validator_list_error_invalid_range' => 'Todos los valores del parámetro $1 deben ser entre $2 y $3.',
	'validator-list-error-invalid-regex' => 'El parámetro $1 tiene que coincidir con esta expresión regular: $2.',
	'validator_list_error_invalid_argument' => 'Uno o más valores del parámetros $1 son inválidos.',
	'validator-list-error-accepts-only' => 'Uno o más valores para el parámetro $1 son inválidos.
Sólo acepta{{PLURAL:$3|este valor| estos valores}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Uno o más valores para el parámetro $1 son inválidos.
Sólo acepta {{PLURAL:$3|este valor|estos valores}}: $2 (y $4 {{PLURAL:$4|valor omitido|valores omitidos}}).',
	'validator_error_accepts_only' => 'El valor "$4" no es válido para el parámetro $1. El parámetro sólo acepta {{PLURAL:$3|este valor|estos valores}}: $2.',
	'validator-error-accepts-only-omitted' => 'El valor $2 no es válido para el parámetro $1.
Sólo acepta {{PLURAL:$5|este valor|estos valores}}: $3 (y $4 {{PLURAL:$4|valor omitido|valores omitidos}}).',
	'validator_list_omitted' => '{{PLURAL:$2|El valor|Los valores}} $1 {{PLURAL:$2|ha sido omitido|han sido omitidos}}.',
	'validator-message-nodesc' => 'No se aporta ninguna descripción',
);

/** Estonian (eesti)
 * @author Avjoska
 */
$messages['et'] = array(
	'validator-type-float' => 'number',
	'validator-type-boolean' => 'jah/ei',
	'validator-type-title' => 'pealkiri',
	'validator-describe-empty' => 'tühi',
	'validator-describe-required' => 'nõutav',
	'validator-describe-header-parameter' => 'Parameeter',
	'validator-describe-header-description' => 'Kirjeldus',
	'validator-describe-parameters' => 'Parameetrid',
);

/** Basque (euskara)
 * @author පසිඳු කාවින්ද
 */
$messages['eu'] = array(
	'validator-type-string' => 'testua',
	'validator-listerrors-low' => 'Baxua',
	'validator-listerrors-normal' => 'Normala',
	'validator-listerrors-high' => 'Altua',
	'validator-describe-empty' => 'hutsik',
	'validator-describe-header-type' => 'Mota',
	'validator-describe-header-default' => 'Lehenetsia',
	'validator-describe-header-description' => 'Deskribapena',
);

/** Persian (فارسی)
 * @author Mjbmr
 * @author پاناروما
 */
$messages['fa'] = array(
	'validator-type-string' => 'متن',
	'validator-type-integer' => 'عدد صحیح',
	'validator-type-float' => 'شماره',
	'validator-type-boolean' => 'بله/خیر',
	'validator-type-char' => 'شخصیت',
	'validator-type-title' => 'عنوان',
	'validator-type-string-list' => 'فهرست متون',
	'validator-type-integer-list' => 'فهرست اعداد صحیح',
	'validator-type-float-list' => 'فهرست شماره‌ها',
	'validator-type-char-list' => 'فهرست شخصیت‌ها',
	'validator-type-title-list' => 'فهرست عناوین',
	'validator-listerrors-errors' => 'خطاها',
	'validator-listerrors-low' => 'کم',
	'validator-listerrors-normal' => 'عادی',
	'validator-listerrors-high' => 'زیاد',
	'validator-listerrors-fatal' => 'کشنده',
	'validator-describe-empty' => 'خالی',
	'validator-describe-required' => 'ضروری',
	'validator-describe-header-parameter' => 'مولفه',
	'validator-describe-header-aliases' => 'نام‌های مستعار',
	'validator-describe-header-type' => 'نوع',
	'validator-describe-header-default' => 'پیش فرض',
	'validator-describe-header-description' => 'تشریح',
);

/** Finnish (suomi)
 * @author Beluga
 * @author Crt
 * @author Silvonen
 * @author Str4nd
 */
$messages['fi'] = array(
	'validator-desc' => 'Tarkastaja tarjoaa helpon tavan muille laajennuksille jäsenninfunktioiden ja tagilaajennusten parametrien tarkastukseen, oletusarvojen asettamiseen ja virheilmoitusten luomiseen.',
	'validator-type-string' => 'teksti',
	'validator-type-integer' => 'kokonaisluku',
	'validator-type-float' => 'luku',
	'validator-type-boolean' => 'kyllä/ei',
	'validator-type-char' => 'merkki',
	'validator-type-title' => 'otsikko',
	'validator-listerrors-errors' => 'Virheet',
	'validator_error_must_be_number' => 'Parametrin $1 on oltava luku.',
	'validator_error_must_be_integer' => 'Parametrin $1 on oltava kokonaisluku.',
);

/** French (français)
 * @author Cedric31
 * @author Crochet.david
 * @author DavidL
 * @author Gomoko
 * @author IAlex
 * @author Jean-Frédéric
 * @author McDutchie
 * @author Peter17
 * @author PieRRoMaN
 * @author Sherbrooke
 * @author Urhixidur
 * @author Verdy p
 */
$messages['fr'] = array(
	'validator-desc' => 'Le validateur fournit aux autres extensions un moyen simple de valider les paramètres des fonctions de l’analyseur syntaxique et des extensions de balises, de définir des valeurs par défaut et de générer des messages d’erreur',
	'validator-warning' => 'Attention : $1',
	'validator-error' => 'Erreur : $1',
	'validator-fatal-error' => 'Erreur fatale : $1',
	'validator_error_parameters' => '{{PLURAL:$1|L’erreur suivante a été détectée|Les erreurs suivantes ont été détectées}} dans votre syntaxe :',
	'validator_warning_parameters' => 'Il y a {{PLURAL:$1|une erreur|des erreurs}} dans votre syntaxe.',
	'validator-warning-adittional-errors' => '... et {{PLURAL:$1|un problème supplémentaire|plusieurs autres problèmes}}.',
	'validator-error-omitted' => '{{PLURAL:$2|La valeur « $1 » a été oubliée|Les valeurs « $1 » ont été oubliées}}.',
	'validator-error-problem' => 'Il y a un problème avec le paramètre $1.',
	'validator_error_unknown_argument' => '$1 n’est pas un paramètre valide.',
	'validator_error_required_missing' => 'Le paramètre requis $1 n’est pas fourni.',
	'validator-error-override-argument' => 'Le logiciel a essayé de remplacer le paramètre $1 (valeur : $2) avec la valeur « $3 »',
	'validator-type-string' => 'texte',
	'validator-type-integer' => 'nombre entier',
	'validator-type-float' => 'nombre',
	'validator-type-boolean' => 'oui/non',
	'validator-type-char' => 'caractère',
	'validator-type-title' => 'titre',
	'validator-type-string-list' => 'liste de textes',
	'validator-type-integer-list' => 'liste de nombres entiers',
	'validator-type-float-list' => 'liste de nombres',
	'validator-type-boolean-list' => 'liste de oui/non',
	'validator-type-char-list' => 'caractères de la liste',
	'validator-type-title-list' => 'liste de titres',
	'validator-listerrors-errors' => 'Erreurs',
	'validator-listerrors-minor' => 'Mineur',
	'validator-listerrors-low' => 'Faible',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Élevé',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => "Liste les erreurs (et les avertissements) qui se sont produits dans les ''hooks'' de l'analyseur syntaxique ''via'' ''Validator''.
Seules les listes pour les ''hooks'' de l'analyseur syntaxique (ajoutées où apparaît <code>listerrors</code>) sont insérées ;
placer <code>listerrors</code> au plus bas de la page pour obtenir toutes les erreurs.",
	'validator-listerrors-par-minseverity' => "La sévérité minimale d'une erreur pour être listée.",
	'validator-describe-description' => "Génère la documentation pour un ou plusieurs ''hooks'' de l'analyseur syntaxique ''via'' ''Validator'.",
	'validator-describe-notfound' => "Il n'y a pas de ''hook'' qui gère « $1 ».",
	'validator-describe-descriptionmsg' => "'''Description''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Alias}}''': $1",
	'validator-describe-parserfunction' => "Mis en oeuvre uniquement comme fonction de l'analyseur syntaxique.",
	'validator-describe-tagextension' => "Mis en œuvre seulement comme balise d'extension.",
	'validator-describe-bothhooks' => "Mis en oeuvre comme fonction de l'analyseur syntaxique et comme balise d'extension.",
	'validator-describe-par-hooks' => "Les ''hooks'' de l'analyseur syntaxique dont il faut afficher la documentation.",
	'validator-describe-par-pre' => "Permet d'obtenir le wikitexte de la documentation, sans qu'il soit rendu sur la page.",
	'validator-describe-par-language' => 'La langue dans laquelle afficher les descriptions',
	'validator-describe-listtype' => 'Liste de $1 éléments',
	'validator-describe-empty' => 'vide',
	'validator-describe-required' => 'requis',
	'validator-describe-header-parameter' => 'Paramètre',
	'validator-describe-header-aliases' => 'Alias',
	'validator-describe-header-type' => 'Type',
	'validator-describe-header-default' => 'Par défaut',
	'validator-describe-header-description' => 'Description',
	'validator-describe-parameters' => 'Paramètres',
	'validator-describe-syntax' => 'Syntaxe',
	'validator-describe-tagmin' => "Balise d'extension avec seulement les paramètres requis.",
	'validator-describe-tagmax' => "Balise d'extension avec tous les paramètres.",
	'validator-describe-tagdefault' => "Balise d'extension avec tous les paramètres en utilisant la notation par défaut des paramètres.",
	'validator-describe-pfmin' => "Fonction de l'analyseur syntaxique avec seulement les paramètres requis.",
	'validator-describe-pfmax' => "Fonction de l'analyseur syntaxique avec tous les paramètres.",
	'validator-describe-pfdefault' => "Fonction de l'analyseur syntaxique avec tous les paramètres en utilisant la notation par défaut des paramètres.",
	'validator-describe-autogen' => "Le contenu de cette section a été généré automatiquement par le ''hook'' ''Describe'' de l'extension ''Validator''.",
	'validator_error_empty_argument' => 'Le paramètre $1 ne peut pas avoir une valeur vide.',
	'validator_error_must_be_number' => 'Le paramètre $1 peut être uniquement un nombre.',
	'validator_error_must_be_integer' => 'Le paramètre $1 peut seulement être un entier.',
	'validator_error_must_be_title' => "Le paramètre $1 ne peut être qu'un nom de page wiki valide.",
	'validator_error_must_be_existing_title' => "Le paramètre $1 ne peut être qu'un nom de page wiki existante.",
	'validator-error-must-be-float' => 'Le paramètre $1 doit être un nombre à virgule flottante.',
	'validator_error_invalid_range' => 'Le paramètre $1 doit être entre $2 et $3.',
	'validator-error-invalid-regex' => 'Le paramètre $1 doit vérifier cette expression rationnelle : « $2 ».',
	'validator-error-invalid-length' => 'Le paramètre $1 doit avoir une longueur de $2.',
	'validator-error-invalid-length-range' => 'Le paramètre $1 doit avoir une longueur comprise entre $2 et $3.',
	'validator_error_invalid_argument' => 'La valeur $1 n’est pas valide pour le paramètre $2.',
	'validator_list_error_empty_argument' => 'Le paramètre $1 n’accepte pas les valeurs vides.',
	'validator_list_error_must_be_number' => 'Le paramètre $1 ne peut contenir que des nombres.',
	'validator_list_error_must_be_integer' => 'Le paramètre $1 ne peut contenir que des entiers.',
	'validator_list_error_must_be_title' => 'Le paramètre $1 ne peut contenir que des noms de page wiki valides.',
	'validator_list_error_must_be_existing_title' => 'Le paramètre $1 ne peut contenir que des noms de page wiki existantes.',
	'validator-list-error-must-be-float' => 'Le paramètre $1 ne peut contenir que des nombres à virgule.',
	'validator_list_error_invalid_range' => 'Toutes les valeurs du paramètre $1 doivent être comprises entre $2 et $3.',
	'validator-list-error-invalid-regex' => 'Toutes les valeurs du paramètre $1 doivent vérifier cette expression rationnelle : « $2 ».',
	'validator_list_error_invalid_argument' => 'Une ou plusieurs valeurs du paramètre $1 sont invalides.',
	'validator-list-error-accepts-only' => 'Une ou plusieurs valeur(s) du paramètre $1 est(sont) invalide(s).
Il n’accepte que {{PLURAL:$3|cette valeur|ces valeurs}} : $2.',
	'validator-list-error-accepts-only-omitted' => 'Une ou plusieurs valeur(s) du paramètre $1 est(sont) invalide(s).
Celui-ci n’accepte que {{PLURAL:$3|cette valeur|ces valeurs}} : $2 (et $4 {{PLURAL:$4|valeur omise|valeurs omises}}).',
	'validator_error_accepts_only' => "La valeur « $4 » n'est pas valable pour le paramètre $1. Il accepte uniquement {{PLURAL:$3|cette valeur|ces valeurs}} : $2.",
	'validator-error-accepts-only-omitted' => 'La valeur « $2 » n’est pas valable pour le paramètre $1.
Celui-ci n’accepte que {{PLURAL:$5|cette valeur|ces valeurs}} : $3 (et $4 {{PLURAL:$4|valeur omise|valeurs omises}}).',
	'validator_list_omitted' => '{{PLURAL:$2|La valeur|Les valeurs}} $1 {{PLURAL:$2|a été oubliée|ont été oubliées}}.',
	'validator-message-nodesc' => 'Aucune description fournie',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'validator-warning' => 'Avèrtissement : $1',
	'validator-error' => 'Èrror : $1',
	'validator-fatal-error' => 'Èrror fatala : $1',
	'validator_error_parameters' => '{{PLURAL:$1|Ceta èrror at étâ dècelâ|Cetes èrrors ont étâ dècelâs}} dens voutra sintaxa :',
	'validator_warning_parameters' => 'Y at {{PLURAL:$1|una èrror|des èrrors}} dens voutra sintaxa.',
	'validator-warning-adittional-errors' => '... et un {{PLURAL:$1|problèmo de ples|mouél d’ôtros problèmos}}.',
	'validator-error-omitted' => '{{PLURAL:$2|La valor « $1 » at étâ oubliâ|Les valors « $1 » ont étâ oubliâs}}.',
	'validator-error-problem' => 'Y at un problèmo avouéc lo paramètre $1.',
	'validator_error_unknown_argument' => '$1 est pas un paramètre valido.',
	'validator_error_required_missing' => 'Lo paramètre nècèssèro $1 est pas balyê.',
	'validator-error-override-argument' => 'La programeria at tâchiê de remplaciér lo paramètre $1 (valor : $2) avouéc la valor « $3 »',
	'validator-type-string' => 'tèxto',
	'validator-type-integer' => 'nombro entiér',
	'validator-type-float' => 'nombro',
	'validator-type-boolean' => 'ouè/nan',
	'validator-type-char' => 'caractèro',
	'validator-type-title' => 'titro',
	'validator-type-string-list' => 'lista de tèxtos',
	'validator-type-integer-list' => 'lista de nombros entiérs',
	'validator-type-float-list' => 'lista de nombros',
	'validator-type-boolean-list' => 'lista de ouè / nan',
	'validator-type-char-list' => 'lista de caractèros',
	'validator-type-title-list' => 'lista de titros',
	'validator-listerrors-errors' => 'Èrrors',
	'validator-listerrors-minor' => 'Petiôt',
	'validator-listerrors-low' => 'Fêblo',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Hôt',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-describe-descriptionmsg' => "'''Dèscripcion :''' $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Nom paralèlo|Noms paralèlos}} :''' $1",
	'validator-describe-listtype' => 'Lista de $1 èlèments',
	'validator-describe-empty' => 'vouedo',
	'validator-describe-required' => 'nècèssèro',
	'validator-describe-header-parameter' => 'Paramètre',
	'validator-describe-header-aliases' => 'Noms paralèlos',
	'validator-describe-header-type' => 'Tipo',
	'validator-describe-header-default' => 'Per dèfôt',
	'validator-describe-header-description' => 'Dèscripcion',
	'validator-describe-parameters' => 'Paramètres',
	'validator-describe-syntax' => 'Sintaxa',
	'validator_error_empty_argument' => 'Lo paramètre $1 pôt pas avêr una valor voueda.',
	'validator_error_must_be_number' => 'Lo paramètre $1 pôt étre ren qu’un nombro.',
	'validator_error_must_be_integer' => 'Lo paramètre $1 pôt étre ren qu’un entiér.',
	'validator_error_invalid_range' => 'Lo paramètre $1 dêt étre entre-mié $2 et $3.',
	'validator_error_invalid_argument' => 'La valor $1 est pas valida por lo paramètre $2.',
	'validator_list_error_empty_argument' => 'Lo paramètre $1 accèpte pas les valors vouedes.',
	'validator_list_error_must_be_number' => 'Lo paramètre $1 pôt contegnir ren que des nombros.',
	'validator_list_error_must_be_integer' => 'Lo paramètre $1 pôt contegnir ren que des entiérs.',
	'validator_list_error_invalid_range' => 'Totes les valors du paramètre $1 dêvont étre entre-mié $2 et $3.',
	'validator_list_error_invalid_argument' => 'Yona ou ben un mouél de valors du paramètre $1 sont envalides.',
	'validator_error_accepts_only' => 'La valor « $4 » est pas valida por lo paramètre $1. Accèpte ren que {{PLURAL:$3|ceta valor|cetes valors}} : $2.',
	'validator_list_omitted' => '{{PLURAL:$2|La valor|Les valors}} $1 {{PLURAL:$2|at étâ oubliâ|ont étâ oubliâs}}.',
);

/** Irish (Gaeilge)
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'validator-type-title' => 'Teideal',
	'validator-listerrors-normal' => 'Gnáth',
	'validator-describe-header-type' => 'Cineál',
	'validator-describe-header-default' => 'réamhshocrú',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'validator-desc' => 'O servizo de validación ofrece un medio sinxelo a outras extensións para validar os parámetros de funcións analíticas e etiquetas de extensións, para establecer os valores por defecto e para xerar mensaxes de erro',
	'validator-warning' => 'Atención: $1',
	'validator-error' => 'Erro: $1',
	'validator-fatal-error' => 'Erro fatal: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Detectouse o seguinte erro|Detectáronse os seguintes erros}} na sintaxe empregada:',
	'validator_warning_parameters' => 'Hai {{PLURAL:$1|un erro|erros}} na súa sintaxe.',
	'validator-warning-adittional-errors' => '... e {{PLURAL:$1|un problema máis|moitos máis problemas}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Omitiuse o valor "$1"|Omitíronse os valores "$1"}}.',
	'validator-error-problem' => 'Houbo un problema co parámetro $1.',
	'validator_error_unknown_argument' => '"$1" non é un parámetro válido.',
	'validator_error_required_missing' => 'Non se proporcionou o parámetro $1 necesario.',
	'validator-error-override-argument' => 'Intentouse sobrescribir o parámetro $1 (valor: $2) co valor "$3"',
	'validator-type-string' => 'texto',
	'validator-type-integer' => 'número enteiro',
	'validator-type-float' => 'número',
	'validator-type-boolean' => 'si/non',
	'validator-type-char' => 'carácter',
	'validator-type-title' => 'título',
	'validator-type-string-list' => 'lista de textos',
	'validator-type-integer-list' => 'lista de números enteiros',
	'validator-type-float-list' => 'lista de números',
	'validator-type-boolean-list' => 'lista de si/non',
	'validator-type-char-list' => 'lista de caracteres',
	'validator-type-title-list' => 'lista de títulos',
	'validator-listerrors-errors' => 'Erros',
	'validator-listerrors-minor' => 'Menor',
	'validator-listerrors-low' => 'Baixo',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Alto',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => 'Lista os erros (e avisos) que ocorreron no asociador do analizador engadidos a través do Validator.
Só aparecerán nas listas para os asociadores do analizador que estean colocados enriba de listerrors;
coloque listerrors na parte inferior da páxina para obter todos os erros.',
	'validator-listerrors-par-minseverity' => 'A severidade mínima dun problema para que apareza na lista.',
	'validator-describe-description' => 'Xera a documentación para un ou máis asociadores do analizador definidos a través do Validator.',
	'validator-describe-notfound' => 'Non hai ningún asociador do analizador que manexe "$1".',
	'validator-describe-descriptionmsg' => "'''Descrición:''' $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alcume|Alcumes}}:''' $1",
	'validator-describe-parserfunction' => 'Implementado só como función analítica.',
	'validator-describe-tagextension' => 'Implementado só como etiqueta de extensión.',
	'validator-describe-bothhooks' => 'Implementado como función analítica e como etiqueta de extensión.',
	'validator-describe-par-hooks' => 'O analizador de asociadores para o que mostrar a documentación.',
	'validator-describe-par-pre' => 'Permite obter o texto wiki para a documentación, sen que sexa renderizado na páxina.',
	'validator-describe-par-language' => 'A lingua na que mostrar as descricións',
	'validator-describe-listtype' => 'Lista de $1 elementos',
	'validator-describe-empty' => 'baleiro',
	'validator-describe-required' => 'obrigatorio',
	'validator-describe-header-parameter' => 'Parámetro',
	'validator-describe-header-aliases' => 'Pseudónimos',
	'validator-describe-header-type' => 'Tipo',
	'validator-describe-header-default' => 'Por defecto',
	'validator-describe-header-description' => 'Descrición',
	'validator-describe-parameters' => 'Parámetros',
	'validator-describe-syntax' => 'Sintaxe',
	'validator-describe-tagmin' => 'Etiqueta de extensión cos únicos parámetros obrigatorios.',
	'validator-describe-tagmax' => 'Etiqueta de extensión con todos os parámetros.',
	'validator-describe-tagdefault' => 'Etiqueta de extensión con todos os parámetros, empregando a notación por defecto dos parámetros.',
	'validator-describe-pfmin' => 'Función analítica cos únicos parámetros obrigatorios.',
	'validator-describe-pfmax' => 'Función analítica con todos os parámetros.',
	'validator-describe-pfdefault' => 'Función analítica con todos os parámetros, empregando a notación por defecto dos parámetros.',
	'validator-describe-autogen' => 'O contido desta sección foi xerado automaticamente polo analizador do asociador "describir" da extensión Validator.',
	'validator_error_empty_argument' => 'O parámetro $1 non pode ter un valor baleiro.',
	'validator_error_must_be_number' => 'O parámetro $1 só pode ser un número.',
	'validator_error_must_be_integer' => 'O parámetro $1 só pode ser un número enteiro.',
	'validator_error_must_be_title' => 'O parámetro $1 só pode ser o nome válido para unha páxina do wiki.',
	'validator_error_must_be_existing_title' => 'O parámetro $1 só pode ser o nome dunha páxina do wiki que exista.',
	'validator-error-must-be-float' => 'O parámetro $1 só pode ser un número de coma flotante.',
	'validator_error_invalid_range' => 'O parámetro $1 debe estar entre $2 e $3.',
	'validator-error-invalid-regex' => 'O parámetro $1 debe coincidir con esta expresión regular: $2.',
	'validator-error-invalid-length' => 'O parámetro $1 debe ter unha lonxitude de $2.',
	'validator-error-invalid-length-range' => 'O parámetro $1 ter unha lonxitude de entre $2 e $3.',
	'validator_error_invalid_argument' => 'O valor $1 non é válido para o parámetro $2.',
	'validator_list_error_empty_argument' => 'O parámetro $1 non acepta valores en branco.',
	'validator_list_error_must_be_number' => 'O parámetro $1 só pode conter números.',
	'validator_list_error_must_be_integer' => 'O parámetro $1 só pode conter números enteiros.',
	'validator_list_error_must_be_title' => 'O parámetro $1 só pode conter nomes válidos para páxinas do wiki.',
	'validator_list_error_must_be_existing_title' => 'O parámetro $1 só pode conter nomes de páxinas do wiki que existan.',
	'validator-list-error-must-be-float' => 'O parámetro $1 só pode conter comas flotantes.',
	'validator_list_error_invalid_range' => 'Todos os valores do parámetro $1 deben estar comprendidos entre $2 e $3.',
	'validator-list-error-invalid-regex' => 'Todos os valores do parámetro $1 deben coincidir con esta expresión regular: $2.',
	'validator_list_error_invalid_argument' => 'Un ou varios valores do parámetro $1 non son válidos.',
	'validator-list-error-accepts-only' => 'Un ou varios valores do parámetro $1 non son válidos.
Só acepta {{PLURAL:$3|este valor|estes valores}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Un ou varios valores do parámetro $1 non son válidos.
Só acepta {{PLURAL:$3|este valor|estes valores}}: $2 (e $4 {{PLURAL:$4|valor omitido|valores omitidos}}).',
	'validator_error_accepts_only' => 'O valor "$4" non é válido para o parámetro "$1". Só acepta {{PLURAL:$3|este valor|estes valores}}: $2.',
	'validator-error-accepts-only-omitted' => 'O valor "$2" non é válido para o parámetro $1.
Só acepta {{PLURAL:$5|este valor|estes valores}}: $3 (e $4 {{PLURAL:$4|valor omitido|valores omitidos}}).',
	'validator_list_omitted' => '{{PLURAL:$2|O valor|Os valores}} $1 {{PLURAL:$2|foi omitido|foron omitidos}}.',
	'validator-message-nodesc' => 'Non se achegou descrición ningunha',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'validator-desc' => 'Validator stellt e eifachi Form z Verfiegig fir anderi Erwyterige go Parameter validiere vu Parser- un Tag-Funktione, go Standardwärt definiere un Fählermäldige generiere',
	'validator-warning' => 'Warnig: $1',
	'validator-error' => 'Fähler: $1',
	'validator-fatal-error' => 'Fähler, wu nit cha behobe wäre: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Dää Fähler isch|Die Fähler sin}} in Dyyre Syntax gfunde wore:',
	'validator_warning_parameters' => 'S het {{PLURAL:$1|e Fähler|Fähler}} in dyyre Syntax.',
	'validator-warning-adittional-errors' => '... un {{PLURAL:$1|e ander Probläm|$1 anderi Probläm}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Dr Wärt|D Wärt}} „$1“ {{PLURAL:$2|isch|sin}} uusgloo wore.',
	'validator-error-problem' => 'S het e Probläm gee mit em Parameter $1.',
	'validator_error_unknown_argument' => '$1 isch kei giltige Parameter.',
	'validator_error_required_missing' => 'Dr Paramter $1, wu aagforderet woren isch, wird nit z Verfiegig gstellt.',
	'validator-error-override-argument' => 'S isch versuecht wore, dr Parameter $1 (Wärt: $2) mit em Wärt „$3“ z iberschryybe',
	'validator-type-string' => 'Täxt',
	'validator-type-integer' => 'Ganzzahl',
	'validator-type-float' => 'Zahl',
	'validator-type-boolean' => 'Jo/Nei',
	'validator-type-char' => 'Zeiche',
	'validator-listerrors-errors' => 'Fähler',
	'validator-listerrors-minor' => 'Gring',
	'validator-listerrors-low' => 'Chlei',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Groß',
	'validator-listerrors-fatal' => 'Schwär',
	'validator-listerrors-description' => 'Zeigt Fähler un Warnigen aa, wu ufträtte sin bi dr Parserhook, wu iber d Erwyterig Validator gnutzt wäre.
Zeigt nume d Parserhook aa, wu iber em Elemänt „listerrors“ yygfiegt wore sin.
„Listerrors“ sott wäge däm am oder gege Änd vu dr Syte yygfiegt wäre, ass alli Fähler un Warnigen aazeigt wäre.',
	'validator-listerrors-par-minseverity' => 'Dr Mindeschtschwärigrad vun eme Probläm, ass es aazeigt wird.',
	'validator-describe-description' => 'Generiert d Dokumentation fir ein oder mehreri Parserhook, wu mit dr Erwyterig Validator definiert wore sin.',
	'validator-describe-notfound' => 'S git kei Parserhook, wu „$1“ verarbeitet.',
	'validator-describe-descriptionmsg' => "'''Bschrybig:''' $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasse}}:''' $1",
	'validator-describe-parserfunction' => 'Numen as Parserfunktion implementiert.',
	'validator-describe-tagextension' => 'Numen as Elementerweiteryg implementiert.',
	'validator-describe-bothhooks' => 'As Parserfunktion un au as Elementerwyterig implementiert.',
	'validator-describe-par-hooks' => 'D Parserhook, wu d Dokumentation derfir soll aazeigt wäre.',
	'validator-describe-par-pre' => 'Macht d Uusgab vu dr Dokumentation in Wikitext megli ohni ass dää bi dr Darstellig vu dr Syte gnutzt wird.',
	'validator-describe-par-language' => 'D Sprooch, wo d Beschrybe drin aazeigt worde sölle',
	'validator-describe-listtype' => 'Lischt vu $1 {{PLURAL:$1|Element|Element}}',
	'validator-describe-empty' => 'läär',
	'validator-describe-required' => 'erforderlig',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Aliasse',
	'validator-describe-header-type' => 'Typ',
	'validator-describe-header-default' => 'Standard',
	'validator-describe-header-description' => 'Bschrybig',
	'validator-describe-parameters' => 'Parameter',
	'validator-describe-syntax' => 'Syntax',
	'validator-describe-tagmin' => 'Elementerwyterig, nume mit dr erforderlige Parameter.',
	'validator-describe-tagmax' => 'Elementerwyterig mit allne Parameter.',
	'validator-describe-tagdefault' => 'Elementerwyterig mit allne Parameter, wu d Standardnotation fir Parameter nutze.',
	'validator-describe-pfmin' => 'Parserfunktion, nume mit dr erforderlige Parameter.',
	'validator-describe-pfmax' => 'Parserfunktion mit allne Parameter.',
	'validator-describe-pfdefault' => 'Parserfunktion mit allne Parameter, wu d Standardnotation fir Parameter nutze.',
	'validator-describe-autogen' => 'Dr Inhalt vu däm Abschnitt isch automatisch dur dr Parserhook „describe“ vu dr Erwyterig Validator generiert wore.',
	'validator_error_empty_argument' => 'Dr Parameter $1 cha kei lääre Wärt haa.',
	'validator_error_must_be_number' => 'Dr Parameter $1 cha nume ne Zahl syy.',
	'validator_error_must_be_integer' => 'Parameter $1 cha nume ne giltigi Zahl syy.',
	'validator-error-must-be-float' => 'Parameter $1 cha nume ne Gleitkommazahl syy.',
	'validator_error_invalid_range' => 'Dr Parameter $1 muess zwische $2 un $3 syy.',
	'validator-error-invalid-regex' => 'Parameter $1 mueß däm reguläre Uusdruck entspräche: $2.',
	'validator-error-invalid-length' => 'Parameter $1 mueß e Lengi haa vu $2.',
	'validator-error-invalid-length-range' => 'Parameter $1 mueß e Lengi haa zwische $2 un $3.',
	'validator_error_invalid_argument' => 'Dr Wärt $1 isch nit giltig fir dr Parameter $2.',
	'validator_list_error_empty_argument' => 'Bim Parameter $1 sin keini lääre Wärt zuegloo.',
	'validator_list_error_must_be_number' => 'Fir dr Parameter $1 si nume Zahle zuegloo.',
	'validator_list_error_must_be_integer' => 'Fir dr Parameter $1 sin nume ganzi Zahle zuegloo.',
	'validator-list-error-must-be-float' => 'Im Parameter $1 cha s nume Gleitkommazahle haa.',
	'validator_list_error_invalid_range' => 'Alli Wärt fir dr Parameter $1 mien zwische $2 un $3 lige.',
	'validator-list-error-invalid-regex' => 'Alli Wärt vum Parameter $1 mien däm reguläre Uusdruck entspräche: $2.',
	'validator_list_error_invalid_argument' => 'Ein oder mehreri Wärt fir dr Parameter $1 sin nit giltig.',
	'validator-list-error-accepts-only' => 'Ein oder meh Wärt fir dr Parameter $1 sin nit giltig.
Nume {{PLURAL:$3|dää Wärt wird|die Wärt wäre}} akzeptiert: $2.',
	'validator-list-error-accepts-only-omitted' => 'Ein oder meh Wärt fir dr Parameter $1 sin nit giltig.
Nume {{PLURAL:$3|dää Wärt wird|die Wärt wäre}} akzeptiert: $2 (un $4 uusglosseni {{PLURAL:$4|Wärt|Wärt}}).',
	'validator_error_accepts_only' => 'Dr Wärt „$4“ isch nit giltig fir dr Parameter $1. Nume {{PLURAL:$3|dää Wärt wird|die Wärt wäre}} akzeptiert: „$2“.',
	'validator-error-accepts-only-omitted' => 'Dr Wärt „$2“ isch nit giltig fir dr Parameter $1.
Nume {{PLURAL:$5|dää Wärt wird|die Wärt wäre}} akzeptiert: $3 (un $4 uusglosseni {{PLURAL:$4|Wärt|Wärt}}).',
	'validator_list_omitted' => '{{PLURAL:$2|Dr Wärt|D Wärt}} $1 {{PLURAL:$2|isch|sin}} uusgloo wore.',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'validator-desc' => 'כלים כלליים לטיפול בפרמטרים עבור הרחבות אחרות',
	'validator-warning' => 'אזהרה: $1',
	'validator-error' => 'שגיאה: $1',
	'validator-fatal-error' => 'שגיאה חמורה: $1',
	'validator_error_parameters' => '{{PLURAL:$1|השגיאה הבאה נמצאה|השגיאות הבאות נמצאו}} בתחביר:',
	'validator_warning_parameters' => '{{PLURAL:$1|ישנה שגיאה|ישנן שגיאות}} בתחביר שלכם.',
	'validator-warning-adittional-errors' => '... ועוד {{PLURAL:$1|בעיה אחת|מספר בעיות}}.',
	'validator-error-omitted' => '{{PLURAL:$2|הערך|הערכים}} "$1" {{PLURAL:$2|הושמט|הושמטו}}.',
	'validator-error-problem' => 'הייתה בעיה עם הפרמטר $1.',
	'validator_error_unknown_argument' => '$1 אינו פרמטר תקני.',
	'validator_error_required_missing' => 'הפרמטר הדרוש $1 לא צוין.',
	'validator-error-override-argument' => 'ניסיתי לעקוף את הפרמטר $1 (ערך: $2) ולהציב את הערך "$3"',
	'validator-type-string' => 'טקסט',
	'validator-type-integer' => 'מספר שלם',
	'validator-type-float' => 'מספר',
	'validator-type-boolean' => 'כן או לא',
	'validator-type-char' => 'תו',
	'validator-type-title' => 'כותרת',
	'validator-type-string-list' => 'רשימת טקסטים',
	'validator-type-integer-list' => 'רשימת מספרים שלמים',
	'validator-type-float-list' => 'רשימת מספרים',
	'validator-type-boolean-list' => 'רשימת כן/לא',
	'validator-type-char-list' => 'רשימת תווים',
	'validator-type-title-list' => 'רשימת כותרות',
	'validator-listerrors-errors' => 'שגיאות',
	'validator-listerrors-minor' => 'משנית',
	'validator-listerrors-low' => 'נמוכה',
	'validator-listerrors-normal' => 'רגילה',
	'validator-listerrors-high' => 'גבוהה',
	'validator-listerrors-fatal' => 'חמורה',
	'validator-listerrors-description' => 'מכין רשימת של שגיאות ואזהרות שהתרחשו במילות הפעלה של מפענח שנוספו דרך Validator.
רק רשימות עבור מילות הפעלה של מפענח מעל listerrors;
יש לשים את listerrors בתחתית העמוד או קרוב אליה כדי לקבל את כל השגיאות.',
	'validator-listerrors-par-minseverity' => 'יש להזין את רמת החומרה המזערית.',
	'validator-describe-description' => 'מחולל תיעוד עבור מילות הפעלה במפענח שמוגדרות דרך Validator.',
	'validator-describe-notfound' => '"$1" אינו מטופל על־ידי שום מילת הפעלה במפענח.',
	'validator-describe-descriptionmsg' => "'''תיאור''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|כינוי|כינויים}}''': $1",
	'validator-describe-parserfunction' => 'מיושם רק בתור פונקציית מפענח.',
	'validator-describe-tagextension' => 'מיושם רק בתור הרחבת תג.',
	'validator-describe-bothhooks' => 'מיושם הן בתור פונקציית מפענח והן בתור הרחבת תג.',
	'validator-describe-par-hooks' => 'מילות הפעלה של מפענח שעבורן יש להציג תיעוד.',
	'validator-describe-par-pre' => 'מאפשר לייצר את קוד הוויקי עבור התיעוד מבלי להציג אותו על הדף.',
	'validator-describe-par-language' => 'באיזו שפה להציג את התיאורים',
	'validator-describe-listtype' => 'רשימה של פריטים מסוג "$1"',
	'validator-describe-empty' => 'ריק',
	'validator-describe-required' => 'נדרש',
	'validator-describe-header-parameter' => 'פרמטר',
	'validator-describe-header-aliases' => 'כינויים',
	'validator-describe-header-type' => 'סוג',
	'validator-describe-header-default' => 'בררת המחדל',
	'validator-describe-header-description' => 'תיאור',
	'validator-describe-parameters' => 'פרמטרים',
	'validator-describe-syntax' => 'תחביר',
	'validator-describe-tagmin' => 'הרחבת תג רק עם הפרמטרים הדרושים.',
	'validator-describe-tagmax' => 'הרחבת תג עם כל הפרמטרים.',
	'validator-describe-tagdefault' => 'הרחבת תג עם כל הפרמטרים עם ציון פרמטרים בבררת מחדל.',
	'validator-describe-pfmin' => 'פונקציית מפענח רק עם הפרמטרים הדרושים.',
	'validator-describe-pfmax' => 'פונקציית מפענח עם כל הפרמטרים.',
	'validator-describe-pfdefault' => 'פונקציית מפענח שבה כל הפרמטרים משתמשים בציון פרמטרים בבררת מחדל.',
	'validator-describe-autogen' => 'תוכן החלק הזה חולל באופן אוטומטי באמצעות מילת ההפעלה "descrbibe" של ההרחבה Validator.',
	'validator_error_empty_argument' => 'הפרמטר $1 לא יכול להיות ערך ריק.',
	'validator_error_must_be_number' => 'הפרמטר $1 יכול להיות מספר בלבד.',
	'validator_error_must_be_integer' => 'הפרמטר $1 יכול להיות מספר שלם בלבד.',
	'validator_error_must_be_title' => 'פרמטר $1 יכול להיות רק שם תקין של דף ויקי.',
	'validator_error_must_be_existing_title' => 'פרמטר $1 יכול להיות רק שם של דף ויקי קיים.',
	'validator-error-must-be-float' => 'הפרמטר $1 יכול להיות רק מספר עם נקודה צפה.',
	'validator_error_invalid_range' => 'הפרמטר $1 חייב להיות בין $2 ל־$3.',
	'validator-error-invalid-regex' => 'פרמטר $1 חייב להתאים לביטוי הרגולרי הבא: $2.',
	'validator-error-invalid-length' => 'אורך פרמטר $1 חייב להיות $2.',
	'validator-error-invalid-length-range' => 'אורך פרמטר $1 חייב להיות בין $2 לבין $3.',
	'validator_error_invalid_argument' => 'הערך $1 אינו תקני עבור הפרמטר $2.',
	'validator_list_error_empty_argument' => 'פרמטר $1 אינו יכול להיות ריק.',
	'validator_list_error_must_be_number' => 'פרמטר $1 יכול להכיל רק מספרים.',
	'validator_list_error_must_be_integer' => 'פרמטר $1 יכול להכיל רק מספרים שלמים.',
	'validator_list_error_must_be_title' => 'פרמטר $1 יכול להכיל רק שמות של דפי ויקי תקינים.',
	'validator_list_error_must_be_existing_title' => 'פרמטר $1 יכול להכיל רק שמות של דפי ויקי קיימים.',
	'validator-list-error-must-be-float' => 'פרמטר $1 יכול להכיל רק מספר עם נקודה צפה.',
	'validator_list_error_invalid_range' => 'כל הערכים של הפרמטר $1 צריכים להיות בין $2 לבין $3.',
	'validator-list-error-invalid-regex' => 'כל הערכים של הפרמטר $1 צריכים להתאים לביטוי הרגולרי הבא: $2.',
	'validator_list_error_invalid_argument' => 'ערך בלתי־חוקי אחד או יותר עבור הפרמטר $1.',
	'validator-list-error-accepts-only' => 'ערך בלתי־חוקי אחד או יותר עבור הפרמטר $1. הוא מקבל רק את {{PLURAL:$3|הערך הזה|הערכים האלה}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'ערכים לא תקינים הוזנו לפרמטר "$1". הוא יכול לקבל רק את {{PLURAL:$3|הערך הבא|הערכים הבאים}}: $2 (וכן {{PLURAL:$4|ערך מושמט אחד|$4 ערכים מושמטים}}).',
	'validator_error_accepts_only' => 'הערך "$4" אינו תקין עבור הפרמטר $1. הוא מקבל רק את {{PLURAL:$3|הערך הבא|הערכים הבאים}}: $2.',
	'validator-error-accepts-only-omitted' => 'הערך "$2" אינו תקין עבור הפרמטר $1. הוא יכול לקבל רק את {{PLURAL:$5|הערך הבא|הערכים הבאים}}: $3 (וכן {{PLURAL:$4|ערך מושמט אחד|$4 ערכים מושמטים}}).',
	'validator_list_omitted' => '{{PLURAL:$2|הערך|הערכים}} $1 {{PLURAL:$2|הושמט|הושמטו}}.',
	'validator-message-nodesc' => 'ללא תיאור',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'validator-desc' => 'Validator skići lochke wašnje za druhe rozšěrjenja, zo bychu so parametry parserowych funkcijow a tafličkowych rozšěrjenjow přepruwowali, standardne hódnoty nastajili a zmylkowe powěsće wutworili',
	'validator-warning' => 'Warnowanje: $1',
	'validator-error' => 'Zmylk: $1',
	'validator-fatal-error' => 'Chutny zmylk: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Slědowacy zmylk bu|Slědowacej zmylkaj buštej|Slědowace zmylki buchu|Slědowace zmylki buchu}} w twojej syntaksy {{PLURAL:$1|wotkryty|wotkrytej|wotkryte|wotkryte}}:',
	'validator_warning_parameters' => '{{PLURAL:$1|Je zmylk|Stej zmylkaj|Su zmylki|Su zmylki}} w twojej syntaksy.',
	'validator-warning-adittional-errors' => '... a {{PLURAL:$1|dalši problem|dalšej problemaj|dalše problemy|dalše problemy}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Hódnota "$1" je so wuwostajena|Hódnoće "$1" stej so wuwostajenej|Hódnoty "$1" su so wuwostajene|Hódnoty "$1" su so wuwostajene}}.',
	'validator-error-problem' => 'Bě problem z parametrom $1.',
	'validator_error_unknown_argument' => '$1 płaćiwy parameter njeje.',
	'validator_error_required_missing' => 'Trěbny parameter $1 njeje podaty.',
	'validator-error-override-argument' => 'Spyta so parameter $1 (hódnota: $2) přez "$3" přepisować',
	'validator-type-string' => 'tekst',
	'validator-type-integer' => 'cyła ličba',
	'validator-type-float' => 'ličba',
	'validator-type-boolean' => 'haj/ně',
	'validator-type-char' => 'znamješko',
	'validator-type-title' => 'titul',
	'validator-type-string-list' => 'tekstowa lisćina',
	'validator-type-integer-list' => 'lisćina cyłych ličbow',
	'validator-type-float-list' => 'lisćina ličbow',
	'validator-type-boolean-list' => 'lisćina haj-ně',
	'validator-type-char-list' => 'znamješka nalistować',
	'validator-type-title-list' => 'lisćina titulow',
	'validator-listerrors-errors' => 'Zmylki',
	'validator-listerrors-minor' => 'Snadny',
	'validator-listerrors-low' => 'Niski',
	'validator-listerrors-normal' => 'Normalny',
	'validator-listerrors-high' => 'Wysoki',
	'validator-listerrors-fatal' => 'Chutny',
	'validator-listerrors-description' => 'Nalistuje zmylki (a warnowanja), kotrež su w parserowych hóčkach wustupili, kotrež su so přez Validator přidali.
Listuje jenož parserowe hóčki, kotrež bu wyše "listerror" zasunjene;
staj "listerrors" deleka na stronje abo blisko kónca strony, zo by wšě zmylki widźał.',
	'validator-listerrors-par-minseverity' => 'Minimalna ćežkosć problema, zo by so zwobraznił.',
	'validator-describe-description' => 'Płodźi dokumentaciju za jednu parserowu hóčku abo wjacore parserowe hóčki přez Validator.',
	'validator-describe-notfound' => 'Njeje parserowa hóčka, kotraž "$1" wobdźěłuje.',
	'validator-describe-descriptionmsg' => "'''Wopisanje''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasaj|Aliasy|Aliasow}}''': $1",
	'validator-describe-parserfunction' => 'Jenož jako parserowa funkcija implementowany.',
	'validator-describe-tagextension' => 'Jenož jako elementowe rozšěrjenje implementowany.',
	'validator-describe-bothhooks' => 'Jako parserowa funkcija kaž tež jako elementowe rozšěrjenje implementowany.',
	'validator-describe-par-hooks' => 'Parserowe hóčki, za kotrež ma so dokumentacija zwobraznić.',
	'validator-describe-par-pre' => 'Zmóžnja woprawdźity wikitekst za dokumentaciju wobstarać, bjez toho zo so na stronje rysował.',
	'validator-describe-par-language' => 'Rěč, w kotrejž wopisanje ma so zwobraznić',
	'validator-describe-listtype' => 'Lisćina $1 {{PLURAL:$1|elementa|elementow|elementow|elementow}}',
	'validator-describe-empty' => 'prózdny',
	'validator-describe-required' => 'trěbny',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Aliasy',
	'validator-describe-header-type' => 'Typ',
	'validator-describe-header-default' => 'Standard',
	'validator-describe-header-description' => 'Wopisanje',
	'validator-describe-parameters' => 'Parametry',
	'validator-describe-syntax' => 'Syntaksa',
	'validator-describe-tagmin' => 'Elementowe rozšěrjenje jenož z trěbnymi parametrami.',
	'validator-describe-tagmax' => 'Elementowe rozšěrjenje ze wšěmi parametrami.',
	'validator-describe-tagdefault' => 'Elementowe rozšěrjenje ze wšěmi parametrami, kotrež standardnu notaciju za parametry wužiwaja.',
	'validator-describe-pfmin' => 'Parserowa funkcija jenož z trěbnymi parametrami.',
	'validator-describe-pfmax' => 'Parserowa funkcija ze wšěmi parametrami.',
	'validator-describe-pfdefault' => 'Parserowa funkcija ze wšěmi parametrami, kotrež standardnu notaciju za parametry wužiwaja.',
	'validator-describe-autogen' => 'Wobsah tutoho wotrězka je so přez parserowu hóčku rozšěrjenja Validator awtomatisce spłodźił.',
	'validator_error_empty_argument' => 'Parameter $1 njemóže prózdnu hódnotu měć.',
	'validator_error_must_be_number' => 'Parameter $1 móže jenož ličba być.',
	'validator_error_must_be_integer' => 'Parameter $1 móže jenož cyła ličba być.',
	'validator_error_must_be_title' => 'Parameter $1 móže jenož płaćiwe mjeno wikistrony być.',
	'validator_error_must_be_existing_title' => 'Parameter $1 móže jenož ekistowace mjeno wikistrony być.',
	'validator-error-must-be-float' => 'Parameter $1 móže jenož ličba z pohibliwej komu być.',
	'validator_error_invalid_range' => 'Parameter $1 dyrbi mjez $2 a $3 być.',
	'validator-error-invalid-regex' => 'Parameter $1 dyrbi tutomu regularnemu wurazej wotpowědować: $2',
	'validator-error-invalid-length' => 'Parameter $1 dyrbi $2 dołhi być.',
	'validator-error-invalid-length-range' => 'Parameter $1 dyrbi mjez $2 a $3 dołhi być.',
	'validator_error_invalid_argument' => 'Hódnota $1 njeje płaćiwa za parameter $2.',
	'validator_list_error_empty_argument' => 'Parameter $1 njeakceptuje prózdne hódnoty.',
	'validator_list_error_must_be_number' => 'Parameter $1 móže jenož ličby wobsahować.',
	'validator_list_error_must_be_integer' => 'Parameter $1 móže jenož cyłe ličby wobsahować.',
	'validator_list_error_must_be_title' => 'Parameter $1 móže jenož płaćiwe mjena wikistronow wobsahować.',
	'validator_list_error_must_be_existing_title' => 'Parameter $1 móže jenož eksistowace mjena wikistronow wobsahować.',
	'validator-list-error-must-be-float' => 'Parameter $1 móže jenož ličby z pohibliwej komu wobsahować.',
	'validator_list_error_invalid_range' => 'Wšě hódnoty parametra $1 dyrbja mjez $2 a $3 być.',
	'validator-list-error-invalid-regex' => 'Wšě hódnoty parametra $1 dyrbja tutomu regularnemu wurazej wotpowědować: $2',
	'validator_list_error_invalid_argument' => 'Jedna hódnota abo wjace hódnotow za parameter $1 su njepłaćiwe.',
	'validator-list-error-accepts-only' => 'Jedna abo wjacore hódnoty za parameter $1 su njepłaćiwe. {{PLURAL:$3|Akceptuje|Akceptujetej|Akceptuja|Akceptuja}} so jenož {{PLURAL:$3|tuta hódnota|tutej hódnoće|tute hódnoty|tute hódnoty}}: $2',
	'validator-list-error-accepts-only-omitted' => 'Jedna abo wjacore hódnoty za parameter $1 su njepłaćiwe. {{PLURAL:$3|Akceptuje|Akceptujetej|Akceptuja|Akceptuja}} so jenož {{PLURAL:$3|tuta hódnota|tutej hódnoće|tute hódnoty|tute hódnoty}}: $2 (a $4 {{PLURAl:$4|wuwostajena hódnota|wuwostajenej hódnoće|wuwostajene hódnoty|wuwostajenych hódnotow}}).',
	'validator_error_accepts_only' => 'Hódnota "$4" za parameter $1 płaćiwa njeje. Akceptuje jenož {{PLURAL:$3|tutu hódnotu|tutej hódnoće|tute hódnoty|tute hódnoty}}: $2.',
	'validator-error-accepts-only-omitted' => 'Hódnota "$2" njeje płaćiwa za parameter $1. {{PLURAL:$5|Akceptuje|Akceptujetej|Akceptuja|Akceptuja}} so jenož {{PLURAL:$5|tuta hódnota|tutej hódnoće|tute hódnoty|tute hódnoty}}: $3 (a $4 {{PLURAl:$4|wuwostajena hódnota|wuwostajenej hódnoće|wuwostajene hódnoty|wuwostajenych hódnotow}}).',
	'validator_list_omitted' => '{{PLURAL:$2|Hódnota|Hódnoće|Hódnoty|Hódnoty}} $1 {{PLURAL:$2|je so wuwostajiła|stej so wuwostajiłoj|su so wuwostajili|su so wuwostajili}}.',
	'validator-message-nodesc' => 'Žane wopisanje podate',
);

/** Hungarian (magyar)
 * @author Dani
 * @author Glanthor Reviol
 * @author TK-999
 */
$messages['hu'] = array(
	'validator-desc' => 'Az érvényesség-ellenőrző egyszerű lehetőséget nyújt más kiterjesztéseknek az elemzőfüggvények és tagek paramétereinek ellenőrzésére, alapértelmezett értékek beállítására, valamint hibaüzenetek generálására.',
	'validator-warning' => 'Figyelmeztetés: $1',
	'validator-error' => 'Hiba: $1',
	'validator-fatal-error' => 'Végzetes hiba: $1',
	'validator_error_parameters' => 'A következő {{PLURAL:$1|hiba található|hibák találhatóak}} a szintaxisban:',
	'validator_warning_parameters' => '{{PLURAL:$1|Hiba van|Hibák vannak}} a szintaxisodban.',
	'validator-warning-adittional-errors' => '... és {{PLURAL:$1|egy|több}} további hiba.',
	'validator-error-omitted' => 'A(z) "$1" {{PLURAL:$2|értéket|értékeket}} kihagyták.',
	'validator-error-problem' => 'Probléma volt a(z) $1 paraméterrel.',
	'validator_error_unknown_argument' => 'A(z) $1 nem érvényes paraméter.',
	'validator_error_required_missing' => 'A(z) $1 kötelező paraméter nem lett megadva.',
	'validator-error-override-argument' => 'Megkísérelte a(z) $1 paraméter (érték: $2) felülírását a(z) "$3" értékkel.',
	'validator-type-string' => 'szöveg',
	'validator-type-integer' => 'egész szám',
	'validator-type-float' => 'szám',
	'validator-type-boolean' => 'igen/nem',
	'validator-type-char' => 'karakter',
	'validator-type-title' => 'cím',
	'validator-type-string-list' => 'szövegek listája',
	'validator-type-integer-list' => 'egész számok listája',
	'validator-type-float-list' => 'számok listája',
	'validator-type-boolean-list' => 'igen/nem lista',
	'validator-listerrors-errors' => 'Hibák',
	'validator-listerrors-minor' => 'Apró',
	'validator-listerrors-low' => 'Alacsony',
	'validator-listerrors-normal' => 'Normális',
	'validator-listerrors-high' => 'Komoly',
	'validator-listerrors-fatal' => 'Végzetes',
	'validator-describe-descriptionmsg' => "'''Leírás''': $1",
	'validator-describe-empty' => 'üres',
	'validator-describe-required' => 'kötelező',
	'validator-describe-header-parameter' => 'Paraméter',
	'validator-describe-header-aliases' => 'Álnevek',
	'validator-describe-header-type' => 'Típus',
	'validator-describe-header-default' => 'Alapértelmezett',
	'validator-describe-header-description' => 'Leírás',
	'validator-describe-parameters' => 'Paraméterek',
	'validator-describe-syntax' => 'Szintaxis',
	'validator_error_empty_argument' => 'A(z) $1 paraméter értéke nem lehet üres.',
	'validator_error_must_be_number' => 'A(z) $1 paraméter csak szám lehet.',
	'validator_error_must_be_integer' => 'A(z) $1 paraméter csak egész szám lehet.',
	'validator-error-must-be-float' => 'A(z) $1 paraméter csak lebegőpontos szám lehet.',
	'validator_error_invalid_range' => 'A(z) $1 paraméter értékének $2 és $3 között kell lennie.',
	'validator-error-invalid-regex' => 'A(z) $1 paraméternek illeszkednie kell a következő reguláris kifejezésre: $2.',
	'validator-error-invalid-length' => 'A(z) $1 paraméternek legalább $2 karakter hosszúnak kell lennie.',
	'validator-error-invalid-length-range' => 'A(z) $1 paraméternek $2 és $3 karakter közötti hosszúnak kell lennie.',
	'validator_error_invalid_argument' => 'A(z) $1 érték nem érvényes a(z) $2 paraméterhez.',
	'validator_list_error_empty_argument' => 'A(z) $1 paraméter nem fogad el üres értékeket.',
	'validator_list_error_must_be_number' => 'A(z) $1 paraméter csak számokat tartalmazhat.',
	'validator_list_error_must_be_integer' => 'A(z) $1 paraméter csak egész számokat tartalmazhat.',
	'validator-list-error-must-be-float' => 'A(z) $1 paraméter csak lebegőpontos számokat tartalmazhat.',
	'validator_list_error_invalid_range' => 'A(z) $1 paraméter összes értékének $2 és $3 közöttinek kell lennie.',
	'validator_list_error_invalid_argument' => 'A(z) $1 paraméter egy vagy több értéke érvénytelen.',
	'validator_error_accepts_only' => 'A(z) $1 paraméter csak a következő {{PLURAL:$3|értéket|értékeket}} fogadja el: $2', # Fuzzy
	'validator_list_omitted' => 'A(z) $1 {{PLURAL:$2|érték mellőzve lett.|értékek mellőzve lettek.}}',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'validator-desc' => 'Validator provide un modo facile a altere extensiones de validar parametros de functiones del analysator syntactic e extensiones de etiquettas, predefinir valores e generar messages de error',
	'validator-warning' => 'Aviso: $1',
	'validator-error' => 'Error: $1',
	'validator-fatal-error' => 'Error fatal: $1',
	'validator_error_parameters' => 'Le sequente {{PLURAL:$1|error|errores}} ha essite detegite in tu syntaxe:',
	'validator_warning_parameters' => 'Il ha {{PLURAL:$1|un error|errores}} in tu syntaxe.',
	'validator-warning-adittional-errors' => '... e {{PLURAL:$1|un altere problema|plure altere problemas}}.',
	'validator-error-omitted' => 'Le {{PLURAL:$2|valor|valores}} "$1" ha essite omittite.',
	'validator-error-problem' => 'Il habeva un problema con le parametro $1.',
	'validator_error_unknown_argument' => '$1 non es un parametro valide.',
	'validator_error_required_missing' => 'Le parametro requisite $1 non ha essite fornite.',
	'validator-error-override-argument' => 'Tentava supplantar le parametro $1 (valor: $2) con le valor "$3"',
	'validator-type-string' => 'texto',
	'validator-type-integer' => 'numero integre',
	'validator-type-float' => 'numero',
	'validator-type-boolean' => 'si/no',
	'validator-type-char' => 'character',
	'validator-type-title' => 'titulo',
	'validator-type-string-list' => 'lista de textos',
	'validator-type-integer-list' => 'lista de numeros integre',
	'validator-type-float-list' => 'lista de numeros',
	'validator-type-boolean-list' => 'lista de si/no',
	'validator-type-char-list' => 'lista de characteres',
	'validator-type-title-list' => 'lista de titulos',
	'validator-listerrors-errors' => 'Errores',
	'validator-listerrors-minor' => 'Minor',
	'validator-listerrors-low' => 'Basse',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Alte',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => 'Lista errores (e advertimentos) que occurreva in uncinos analysator addite con Validator.
Isto face listas solmente pro le uncinos analysator addite supra le loco ubi "listerrors" es inserite;
mitte "listerrors" al fin del pagina, o proxime al fin, pro obtener tote le errores.',
	'validator-listerrors-par-minseverity' => 'Le severitate minime de un problema pro esser listate.',
	'validator-describe-description' => 'Genera documentation pro un o plus uncinos del analysator syntactic, definite via Validator.',
	'validator-describe-notfound' => 'Non existe un uncino del analysator syntactic que manea "$1".',
	'validator-describe-descriptionmsg' => "'''Description''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliases}}''': $1",
	'validator-describe-parserfunction' => 'Implementate solmente como function del analysator syntactic.',
	'validator-describe-tagextension' => 'Implementate solmente como extension de etiquetta.',
	'validator-describe-bothhooks' => 'Implementate como function del analysator syntactic e como extension de etiquetta.',
	'validator-describe-par-hooks' => 'Le uncinos del analysator syntactic pro le quales presentar documentation.',
	'validator-describe-par-pre' => 'Permitte obtener le ver wikitexto pro le documentation, sin render lo in le pagina.',
	'validator-describe-par-language' => 'Le lingua in que presentar le descriptiones',
	'validator-describe-listtype' => 'Lista de $1 elementos',
	'validator-describe-empty' => 'vacue',
	'validator-describe-required' => 'requirite',
	'validator-describe-header-parameter' => 'Parametro',
	'validator-describe-header-aliases' => 'Aliases',
	'validator-describe-header-type' => 'Typo',
	'validator-describe-header-default' => 'Predefinition',
	'validator-describe-header-description' => 'Description',
	'validator-describe-parameters' => 'Parametros',
	'validator-describe-syntax' => 'Syntaxe',
	'validator-describe-tagmin' => 'Extension de etiquetta con solmente le parametros obligatori.',
	'validator-describe-tagmax' => 'Extension de etiquetta con tote le parametros.',
	'validator-describe-tagdefault' => 'Extension de etiquetta con tote le parametros usante le notation predefinite de parametros.',
	'validator-describe-pfmin' => 'Function analysator con solmente le parametros obligatori.',
	'validator-describe-pfmax' => 'Function analysator con tote le parametros.',
	'validator-describe-pfdefault' => 'Function analysator con tote le parametros usante le notation predefinite de parametros.',
	'validator-describe-autogen' => 'Le contento de iste section esseva auto-generate per le uncino analysator "describe" del extension Validator.',
	'validator_error_empty_argument' => 'Le parametro $1 non pote haber un valor vacue.',
	'validator_error_must_be_number' => 'Le parametro $1 pote solmente esser un numero.',
	'validator_error_must_be_integer' => 'Le parametro $1 pote solmente esser un numero integre.',
	'validator_error_must_be_title' => 'Le parametro $1 pote solmente esser un nomine de pagina wiki valide.',
	'validator_error_must_be_existing_title' => 'Le parametro $1 pote solmente esser un nomine de pagina wiki existente.',
	'validator-error-must-be-float' => 'Le parametro $1 pote solmente esser un numero con fraction decimal.',
	'validator_error_invalid_range' => 'Le parametro $1 debe esser inter $2 e $3.',
	'validator-error-invalid-regex' => 'Le parametro $1 debe corresponder a iste expression regular: $2.',
	'validator-error-invalid-length' => 'Le parametro $1 debe haber un longitude de $2.',
	'validator-error-invalid-length-range' => 'Le parametro $1 debe haber un longitude inter $2 e $3.',
	'validator_error_invalid_argument' => 'Le valor $1 non es valide pro le parametro $2.',
	'validator_list_error_empty_argument' => 'Le parametro $1 non accepta valores vacue.',
	'validator_list_error_must_be_number' => 'Le parametro $1 pote solmente continer numeros.',
	'validator_list_error_must_be_integer' => 'Le parametro $1 pote solmente continer numeros integre.',
	'validator_list_error_must_be_title' => 'Le parametro $1 pote solmente continer nomines de pagina wiki valide.',
	'validator_list_error_must_be_existing_title' => 'Le parametro $1 pote solmente continer nomines de pagina wiki existente.',
	'validator-list-error-must-be-float' => 'Le parametro $1 pote solmente continer numeros a comma flottante.',
	'validator_list_error_invalid_range' => 'Tote le valores del parametro $1 debe esser inter $2 e $3.',
	'validator-list-error-invalid-regex' => 'Tote le valores del parametro $1 debe corresponder a iste expression regular: $2.',
	'validator_list_error_invalid_argument' => 'Un o plus valores pro le parametro $1 es invalide.',
	'validator-list-error-accepts-only' => 'Un o plus valores del parametro $1 es invalide.
Illo accepta solmente iste {{PLURAL:$3|valor|valores}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Un o plus valores del parametro $1 es invalide.
Illo accepta solmente iste {{PLURAL:$3|valor|valores}}: $2. (e $4 {{PLURAL:$4|valor|valores}} omittite).',
	'validator_error_accepts_only' => 'Le valor "$4" non es valide pro le parametro $1. Illo accepta solmente iste {{PLURAL:$3|valor|valores}}: $2.',
	'validator-error-accepts-only-omitted' => 'Le valor "$2" non es valide pro le parametro $1.
Illo accepta solmente iste {{PLURAL:$5|valor|valores}}: $3 (e $4 {{PLURAL:$4|valor|valores}} omittite).',
	'validator_list_omitted' => 'Le {{PLURAL:$2|valor|valores}} $1 ha essite omittite.',
	'validator-message-nodesc' => 'Sin description',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Farras
 * @author Irwangatot
 * @author IvanLanin
 */
$messages['id'] = array(
	'validator-desc' => 'Validator memberikan cara mudah untuk ekstensi lain untuk memvalidasi parameter ParserFunction dan ekstensi tag, mengatur nilai biasa dan membuat pesan kesalahan',
	'validator-warning' => 'Peringatan: $1',
	'validator-error' => 'Kesalahan: $1',
	'validator-fatal-error' => 'Kesalahan fatal: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Kesalahan|Kesalahan}} berikut telah terdeteksi pada sintaks Anda:',
	'validator_warning_parameters' => 'Terdapat {{PLURAL:$1|kesalahan|kesalahan}} pada sintaks Anda.',
	'validator-warning-adittional-errors' => '... dan {{PLURAL:$1|satu|banyak}} masalah lain.',
	'validator-error-omitted' => 'Nilai {{PLURAL:$2|"$1"|"$1"}} telah diabaikan.',
	'validator-error-problem' => 'Ada masalah dengan parameter $1.',
	'validator_error_unknown_argument' => '$1 bukan parameter yang benar.',
	'validator_error_required_missing' => 'Parameter $1 yang diperlukan tidak diberikan.',
	'validator-error-override-argument' => 'Mencoba menimpa parameter $1 (nilai: $2) dengan nilai "$3"',
	'validator-type-string' => 'teks',
	'validator-type-integer' => 'bilangan bulat',
	'validator-type-float' => 'nomor',
	'validator-type-boolean' => 'ya/tidak',
	'validator-type-char' => 'karakter',
	'validator-listerrors-errors' => 'Kesalahan',
	'validator-listerrors-minor' => 'Kecil',
	'validator-listerrors-low' => 'Rendah',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Tinggi',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => 'Daftar galat (dan peringatan) yang terjadi pada pengait parser yang ditambahkan melalui Validator.
Hanya daftar untuk pengait parser yang ditambahkan di atas bagian tempat listerrors disisipkan;
tempatkan listerrors pada atau di dekat bagian bawah halaman untuk mendapatkan semua kesalahan.',
	'validator-listerrors-par-minseverity' => 'Tingkat keparahan minimum masalah yang didaftarkan.',
	'validator-describe-description' => 'Menghasilkan dokumentasi untuk satu atau beberapa pengait parser yang didefinisikan melalui Validator.',
	'validator-describe-notfound' => 'Tidak ada pengait parser yang menangani "$1".',
	'validator-describe-descriptionmsg' => "'''Deskripsi''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Alias}}''': $1",
	'validator-describe-parserfunction' => 'Diterapkan hanya sebagai fungsi parser.',
	'validator-describe-tagextension' => 'Diterapkan hanya sebagai ekstensi tag.',
	'validator-describe-bothhooks' => 'Diterapkan sebagai fungsi parser dan ekstensi tag.',
	'validator-describe-par-hooks' => 'Pengait parser untuk menampilkan dokumentasi.',
	'validator-describe-par-pre' => 'Memungkinkan Anda mengambil tekswiki aktual untuk dokumentasi, tanpa ditampilkan pada halaman.',
	'validator-describe-listtype' => 'Daftar $1 butir',
	'validator-describe-empty' => 'kosong',
	'validator-describe-required' => 'wajib diisi',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Alias',
	'validator-describe-header-type' => 'Jenis',
	'validator-describe-header-default' => 'Bawaan',
	'validator-describe-header-description' => 'Deskripsi',
	'validator-describe-parameters' => 'Parameter',
	'validator-describe-syntax' => 'Sintaksis',
	'validator-describe-tagmin' => 'Ekstensi tag hanya dengan parameter wajib.',
	'validator-describe-tagmax' => 'Ekstensi tag dengan semua parameter.',
	'validator-describe-tagdefault' => 'Ekstensi tag dengan semua parameter menggunakan notasi parameter bawaan.',
	'validator-describe-pfmin' => 'Fungsi parser hanya dengan parameter wajib.',
	'validator-describe-pfmax' => 'Fungsi parser dengan semua parameter.',
	'validator-describe-pfdefault' => 'Fungsi parser dengan semua parameter menggunakan notasi parameter bawaan.',
	'validator-describe-autogen' => 'Isi bagian ini adalah dihasilkan otomatis oleh pengait parser "describe" dari ekstensi Validator.',
	'validator_error_empty_argument' => 'Parameter $1 tidak dapat bernilai kosong.',
	'validator_error_must_be_number' => 'Parameter $1 hanya dapat berupa angka.',
	'validator_error_must_be_integer' => 'Parameter $1 hanya dapat berupa integer.',
	'validator-error-must-be-float' => 'Parameter $1 hanya dapat berupa angka titik kambang.',
	'validator_error_invalid_range' => 'Parameter $1 harus antara $2 dan $3.',
	'validator-error-invalid-regex' => 'Parameter $1 harus sesuai dengan persamaan reguler: $2.',
	'validator-error-invalid-length' => 'Parameter $1 harus memiliki panjang $2.',
	'validator-error-invalid-length-range' => 'Parameter $1 harus memiliki panjang antara $2 dan $3.',
	'validator_error_invalid_argument' => 'Nilai $1 tidak valid untuk parameter $2.',
	'validator_list_error_empty_argument' => 'Parameter $1 tidak menerima nilai kosong.',
	'validator_list_error_must_be_number' => 'Parameter $1 hanya dapat berisi angka.',
	'validator_list_error_must_be_integer' => 'Parameter $1 hanya dapat berisi bilangan bulat.',
	'validator-list-error-must-be-float' => 'Parameter $1 hanya dapat berisi angka kambang.',
	'validator_list_error_invalid_range' => 'Semua nilai parameter $1 harus antara $2 dan $3.',
	'validator-list-error-invalid-regex' => 'Semua nilai parameter $1 harus sesuai dengan persamaan reguler: $2.',
	'validator_list_error_invalid_argument' => 'Satu nilai atau lebih untuk parameter $1 tidak sah.',
	'validator-list-error-accepts-only' => 'Satu atau lebih nilai untuk parameter $1 tidak sah. Parameter itu hanya menerima {{PLURAL:$3|nilai berikut|nilai berikut}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Satu atau lebih nilai untuk parameter $1 tidak sah. Parameter itu hanya menerima {{PLURAL:$3|nilai berikut|nilai berikut}}: $2 (dan $4 {{PLURAL:$4|nilai|nilai}} yang diabaikan).',
	'validator_error_accepts_only' => 'Nilai "$4" tidak sah untuk parameter $1. Nilai yang diterima hanyalah {{PLURAL:$3|nilai ini|nilai-nilai ini}}: $2.',
	'validator-error-accepts-only-omitted' => 'Nilai "$2" tidak sah untuk parameter $1. Parameter itu hanya menerima {{PLURAL:$5|nilai berikut|nilai berikut}}: $3 (dan $4 {{PLURAL:$4|nilai|nilai}} yang diabaikan).',
	'validator_list_omitted' => '{{PLURAL:$2|Nilai|Nilai}} $1 {{PLURAL:$2|telah|telah}} dihapus.',
);

/** Italian (italiano)
 * @author Beta16
 * @author Civvì
 * @author HalphaZ
 */
$messages['it'] = array(
	'validator-desc' => 'Permette ad altre estensioni di gestire i parametri in modo semplice',
	'validator-warning' => 'Attenzione: $1',
	'validator-error' => 'Errore: $1',
	'validator-fatal-error' => 'Errore fatale: $1',
	'validator_error_parameters' => 'Nella tua sintassi {{PLURAL:$1|è stato individuato il seguente errore|sono stati individuati i seguenti errori}}:',
	'validator_warning_parameters' => "Nella tua sintassi {{PLURAL:$1|c'è un errore|ci sono errori}}.",
	'validator-warning-adittional-errors' => '... e {{PLURAL:$1|un altro problema|altri problemi}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Il valore "$1" è stato omesso|I valori "$1" sono stati omessi}}.',
	'validator-error-problem' => "C'era un problema con il parametro $1.",
	'validator_error_unknown_argument' => '$1 non è un parametro valido.',
	'validator_error_required_missing' => 'Il parametro richiesto $1 non è stato fornito.',
	'validator-error-override-argument' => 'Tentativo di sovrascrivere il parametro $1 (valore: $2) con il valore "$3"',
	'validator-type-string' => 'testo',
	'validator-type-integer' => 'numero intero',
	'validator-type-float' => 'numero',
	'validator-type-boolean' => 'sì/no',
	'validator-type-char' => 'carattere',
	'validator-type-title' => 'titolo',
	'validator-type-string-list' => 'elenco dei testi',
	'validator-type-integer-list' => 'elenco di numeri interi',
	'validator-type-float-list' => 'elenco dei numeri',
	'validator-type-boolean-list' => 'elenco di sì/no',
	'validator-type-char-list' => 'elenco dei caratteri',
	'validator-type-title-list' => 'elenco dei titoli',
	'validator-listerrors-errors' => 'Errori',
	'validator-listerrors-minor' => 'Minore',
	'validator-listerrors-low' => 'Bassa',
	'validator-listerrors-normal' => 'Normale',
	'validator-listerrors-high' => 'Alta',
	'validator-listerrors-fatal' => 'Fatale',
	'validator-listerrors-description' => "Elenca gli errori (e gli avvisi) che si sono verificati negli hook del parser aggiunti tramite Validator.
Vengono elencati solo per gli hook del parser aggiunti sopra l'inserimento di listerrors;
metti listerrors alla fine o in prossimità della parte inferiore della pagina per ottenere tutti gli errori.",
	'validator-listerrors-par-minseverity' => 'Il livello minimo di gravità di un problema per poter essere elencato.',
	'validator-describe-description' => 'Genera la documentazione per uno o più hook del parser definito tramite Validator.',
	'validator-describe-notfound' => 'Non c\'è alcun hook del parser che gestisce "$1".',
	'validator-describe-descriptionmsg' => "'''Descrizione''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias}}''': $1",
	'validator-describe-parserfunction' => 'Implementato solo come funzione parser.',
	'validator-describe-tagextension' => 'Implementato solo come tag di estensione.',
	'validator-describe-bothhooks' => 'Implementato come sia funzione parser che come tag di estensione.',
	'validator-describe-par-hooks' => "L'hook del parser di cui visualizzare la documentazione.",
	'validator-describe-par-pre' => 'Consente di ottenere il wikitesto attuale per la documentazione, senza che sia stato effettuato il rendering della pagina.',
	'validator-describe-par-language' => 'La lingua in cui visualizzare la descrizione',
	'validator-describe-listtype' => 'Elenco di elementi di tipo $1',
	'validator-describe-empty' => 'vuota',
	'validator-describe-required' => 'obbligatorio',
	'validator-describe-header-parameter' => 'Parametro',
	'validator-describe-header-aliases' => 'Alias',
	'validator-describe-header-type' => 'Tipo',
	'validator-describe-header-default' => 'Predefinito',
	'validator-describe-header-description' => 'Descrizione',
	'validator-describe-parameters' => 'Parametri',
	'validator-describe-syntax' => 'Sintassi',
	'validator-describe-tagmin' => 'Ttag di estensione con solo i parametri obbligatori.',
	'validator-describe-tagmax' => 'Ttag di estensione con tutti i parametri.',
	'validator-describe-tagdefault' => 'Ttag di estensione con tutti i parametri utilizzando la notazione per i parametri predefinita.',
	'validator-describe-pfmin' => 'Funzione parser con solo i parametri obbligatori.',
	'validator-describe-pfmax' => 'Funzione parser con tutti i parametri.',
	'validator-describe-pfdefault' => 'Funzione parser con tutti i parametri utilizzando la notazione per i parametri predefinita.',
	'validator-describe-autogen' => 'Il contenuto di questa sezione è stata generata automaticamente dal hook del parser "describe" dell\'estensione Validator.',
	'validator_error_empty_argument' => 'Il parametro $1 non può avere un valore vuoto.',
	'validator_error_must_be_number' => 'Il parametro $1 può essere solo un numero.',
	'validator_error_must_be_integer' => 'Il parametro $1 può essere solo un intero.',
	'validator_error_must_be_title' => 'Il parametro $1 può essere solo un nome valido di una pagina wiki.',
	'validator_error_must_be_existing_title' => 'Il parametro $1 può essere solo un nome di una pagina wiki esistente.',
	'validator-error-must-be-float' => 'Il parametro $1 può essere solo un numero decimale.',
	'validator_error_invalid_range' => 'Il parametro $1 deve essere compreso tra $2 e $3.',
	'validator-error-invalid-regex' => 'Il parametro $1 deve corrispondere a questa espressione regolare: $2.',
	'validator-error-invalid-length' => 'Il parametro $1 deve avere una lunghezza di $2.',
	'validator-error-invalid-length-range' => 'Il parametro $1 deve avere una lunghezza compresa tra $2 e $3.',
	'validator_error_invalid_argument' => 'Il valore $1 non è valido per il parametro $2.',
	'validator_list_error_empty_argument' => 'Il parametro $1 non accetta valori vuoti.',
	'validator_list_error_must_be_number' => 'Il parametro $1 può contenere solo numeri.',
	'validator_list_error_must_be_integer' => 'Il parametro $1 può contenere solo numeri interi.',
	'validator_list_error_must_be_title' => 'Il parametro $1 può contenere solo un nome valido di una pagina wiki.',
	'validator_list_error_must_be_existing_title' => 'Il parametro $1 può contenere solo un nome di una pagina wiki esistente.',
	'validator-list-error-must-be-float' => 'Il parametro $1 può contenere solo numeri decimali.',
	'validator_list_error_invalid_range' => 'Tutti i valori del parametro $1 devono essere compresi tra $2 e $3.',
	'validator-list-error-invalid-regex' => 'Tutti i valori del parametro $1 devono corrispondere a questa espressione regolare: $2.',
	'validator_list_error_invalid_argument' => 'Uno o più valori del parametro $1 non sono validi.',
	'validator-list-error-accepts-only' => 'Uno o più valori del parametro $1 non sono validi. {{PLURAL:$3|Il valore accettato è|I valori accettati sono}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Uno o più valori del parametro $1 non sono validi. {{PLURAL:$3|Il valore accettato è|I valori accettati sono}}: $2 (e $4 {{PLURAL:$4|valore omesso|valori omessi}}).',
	'validator_error_accepts_only' => 'Il valore "$4" non è valido per il parametro $1. Accetta solo {{PLURAL:$3|questo valore|questi valori}}: $2.',
	'validator-error-accepts-only-omitted' => 'Il valore "$2" non è valido per il parametro $1. {{PLURAL:$5|Il valore accettato è|I valori accettati sono}}: $3 (e $4 {{PLURAL:$4|valore omesso|valori omessi}}).',
	'validator_list_omitted' => '{{PLURAL:$2|Il valore|I valori}} $1 {{PLURAL:$2|è stato omesso|sono stati omessi}}.',
	'validator-message-nodesc' => 'Nessuna descrizione fornita',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Marine-Blue
 * @author Shirayuki
 * @author Whym
 * @author Yanajin66
 */
$messages['ja'] = array(
	'validator-desc' => '他の拡張機能に、汎用的な引数処理機能を提供する',
	'validator-warning' => '警告: $1',
	'validator-error' => 'エラー: $1',
	'validator-fatal-error' => '致命的なエラー: $1',
	'validator_error_parameters' => '以下の構文{{PLURAL:$1|エラー}}を検出しました:',
	'validator_warning_parameters' => '構文{{PLURAL:$1|エラー}}があります。',
	'validator-warning-adittional-errors' => '...と{{PLURAL:$1|&#32;1 件の問題点|複数の問題点}}。',
	'validator-error-omitted' => '{{PLURAL:$2|値 $1}} を省略しました。',
	'validator-error-problem' => '引数 $1 に問題点がありました。',
	'validator_error_unknown_argument' => '$1 は有効な引数ではありません。',
	'validator_error_required_missing' => '必須の引数「$1」が指定されていません。',
	'validator-error-override-argument' => '引数 $1 (値: $2) を値「$3」で上書きしようとしました',
	'validator-type-string' => 'テキスト',
	'validator-type-float' => '数値',
	'validator-type-boolean' => 'はい/いいえ',
	'validator-type-char' => '文字',
	'validator-type-title' => 'ページ名',
	'validator-listerrors-errors' => 'エラー',
	'validator-listerrors-minor' => '非常に軽度',
	'validator-listerrors-low' => '軽度',
	'validator-listerrors-normal' => '普通',
	'validator-listerrors-high' => '重大',
	'validator-listerrors-fatal' => '非常に重大',
	'validator-describe-descriptionmsg' => "'''説明''': $1",
	'validator-describe-parserfunction' => 'パーサー関数としてのみ実装されています。',
	'validator-describe-tagextension' => 'タグ拡張機能としてのみ実装されています。',
	'validator-describe-bothhooks' => 'パーサー関数およびタグ拡張機能の両方として実装されています。',
	'validator-describe-empty' => '空',
	'validator-describe-required' => '必須',
	'validator-describe-header-parameter' => '引数',
	'validator-describe-header-aliases' => '別名',
	'validator-describe-header-type' => '種類',
	'validator-describe-header-default' => '既定',
	'validator-describe-header-description' => '説明',
	'validator-describe-parameters' => '引数',
	'validator-describe-syntax' => '構文',
	'validator_error_empty_argument' => '引数「$1」は空の値を取ることはできません。',
	'validator_error_must_be_number' => '引数「$1」には数値のみを指定できます。',
	'validator_error_must_be_integer' => '引数「$1」には整数のみを指定できます。',
	'validator_error_must_be_title' => '引数 $1 には有効なウィキ ページ名のみを指定できます。',
	'validator_error_must_be_existing_title' => '引数 $1 には既存のウィキ ページ名のみを指定できます。',
	'validator-error-must-be-float' => '引数 $1 には浮動小数点数のみ指定できます。',
	'validator_error_invalid_range' => '引数「$1」は $2 から $3 の間の値である必要があります。',
	'validator-error-invalid-regex' => '引数 $1 はこの正規表現に一致する必要があります: $2',
	'validator-error-invalid-length' => '引数 $1 は長さが $2 である必要があります。',
	'validator-error-invalid-length-range' => '引数 $1 は長さが $2 から $3 までの範囲である必要があります。',
	'validator_error_invalid_argument' => '値「$1」は引数「$2」として無効です。',
	'validator_list_error_empty_argument' => '引数「$1」は空の値を取りません。',
	'validator_list_error_must_be_number' => '引数「$1」には数値のみを指定できます。',
	'validator_list_error_must_be_integer' => '引数「$1」には整数のみを指定できます。',
	'validator_list_error_must_be_title' => '引数 $1 には有効なウィキ ページ名 (複数) のみを指定できます。',
	'validator_list_error_must_be_existing_title' => '引数 $1 には既存のウィキ ページ名 (複数) のみを指定できます。',
	'validator-list-error-must-be-float' => '引数 $1 には浮動小数点数のみを指定できます。',
	'validator_list_error_invalid_range' => '引数「$1」の値はすべて $2 と $3 の間のものでなくてはなりません。',
	'validator-list-error-invalid-regex' => 'パラメーター $1 の値は次の正規表現と一致する必要があります： $2',
	'validator_list_error_invalid_argument' => 'パラメーター「$1」の値に不正なものが1つ以上あります。',
	'validator-list-error-accepts-only' => 'パラメーター $1 に無効な値が含まれています。{{PLURAL:$3|この値|これらの値}}のみを使用できます：$2',
	'validator-list-error-accepts-only-omitted' => 'パラメーター $1 に無効な値が含まれています。{{PLURAL:$3|この値|これらの値}}のみを使用できます：$2（と省略された $4 の{{PLURAL:$4|値}}）',
	'validator_error_accepts_only' => 'パラメーター $1 の値「$4」は有効ではありません。{{PLURAL:$3|この値|これらの値}}のみを使用できます：$2。',
	'validator-error-accepts-only-omitted' => 'パラメーター $1 の値「$2」は有効ではありません。{{PLURAL:$5|この値|これらの値}}のみを使用できます：$3（と省略された $4 の{{PLURAL:$4|値}}）',
	'validator_list_omitted' => '{{PLURAL:$2|値}} $1 は省略されました。',
	'validator-message-nodesc' => '説明はありません',
);

/** Georgian (ქართული)
 * @author David1010
 * @author ITshnik
 */
$messages['ka'] = array(
	'validator-warning' => 'გაფრთხილება: $1',
	'validator-error' => 'შეცდომა: $1',
	'validator-fatal-error' => 'ფატალური შეცდომა: $1',
	'validator_error_unknown_argument' => '$1 არ არის სწორი პარამეტრი.',
	'validator-type-string' => 'ტექსტი',
	'validator-type-integer' => 'მთლიანი რიცხვი',
	'validator-type-float' => 'ნომერი',
	'validator-type-boolean' => 'დიახ/არა',
	'validator-type-char' => 'სიმბოლო',
	'validator-type-title' => 'სათაური',
	'validator-type-string-list' => 'ტექსტების სია',
	'validator-type-float-list' => 'რიცხვების სია',
	'validator-type-boolean-list' => 'დიახ/არა სია',
	'validator-type-char-list' => 'სიმბოლოების სია',
	'validator-type-title-list' => 'სათაურების სია',
	'validator-listerrors-errors' => 'შეცდომები',
	'validator-listerrors-minor' => 'უმნიშვნელო',
	'validator-listerrors-low' => 'დაბალი',
	'validator-listerrors-normal' => 'ნორმალური',
	'validator-listerrors-high' => 'მაღალი',
	'validator-listerrors-fatal' => 'ფატალური',
	'validator-describe-descriptionmsg' => "'''აღწერა''': $1",
	'validator-describe-empty' => 'ცარიელი',
	'validator-describe-required' => 'სავალდებულოა',
	'validator-describe-header-parameter' => 'პარამეტრი',
	'validator-describe-header-aliases' => 'ფსევდონიმები',
	'validator-describe-header-type' => 'ტიპი',
	'validator-describe-header-default' => 'სტანდარტული',
	'validator-describe-header-description' => 'აღწერა',
	'validator-describe-parameters' => 'პარამეტრები',
	'validator-describe-syntax' => 'სინტაქსი',
	'validator_error_empty_argument' => 'პარამეტრი $1 არ შეუძლია ცარიელი მნიშვნელობის მიღება.',
);

/** Korean (한국어)
 * @author 아라
 */
$messages['ko'] = array(
	'validator-desc' => '다른 확장 기능에 대한 일반 변수 처리 지원을 제공',
	'validator-warning' => '경고: $1',
	'validator-error' => '오류: $1',
	'validator-fatal-error' => '치명적인 오류: $1',
	'validator_error_parameters' => '문법에서 지정한 다음 {{PLURAL:$1|오류가 있습니다}}:',
	'validator_warning_parameters' => '문법에서 {{PLURAL:$1|오류가 있습니다}}.',
	'validator-warning-adittional-errors' => '... 그리고 {{PLURAL:$1|하나의 많은 문제|여러 많은 문제}}가 있습니다.',
	'validator-error-omitted' => '{{PLURAL:$2|"$1" 값}}은 생략합니다.',
	'validator-error-problem' => '$1 변수에 문제가 있습니다.',
	'validator_error_unknown_argument' => '$1(은)는 올바른 변수가 아닙니다.',
	'validator_error_required_missing' => '"$1" 필수 변수를 제공하지 않았습니다.',
	'validator-error-override-argument' => '"$3" 값으로 $1 변수(값: $2)를 무시하려 했습니다',
	'validator-type-string' => '텍스트',
	'validator-type-integer' => '정수',
	'validator-type-float' => '숫자',
	'validator-type-boolean' => '예/아니오',
	'validator-type-char' => '글자',
	'validator-type-title' => '제목',
	'validator-type-string-list' => '텍스트 목록',
	'validator-type-integer-list' => '정수 목록',
	'validator-type-float-list' => '숫자 목록',
	'validator-type-boolean-list' => '예/아니오 목록',
	'validator-type-char-list' => '글자 목록',
	'validator-type-title-list' => '제목 목록',
	'validator-listerrors-errors' => '오류',
	'validator-listerrors-minor' => '사소',
	'validator-listerrors-low' => '낮음',
	'validator-listerrors-normal' => '보통',
	'validator-listerrors-high' => '높음',
	'validator-listerrors-fatal' => '심각',
	'validator-listerrors-description' => '변수기를 통해 추가한 파서 훅에서 발생한 오류(와 경고) 목록입니다.
파서 훅에 대한 목록만 오류 목록이 삽입하는 곳에 추가됩니다.
모든 오류를 얻으려면 문서 하단이나 가까운 오류 목록에 넣으십시오.',
	'validator-listerrors-par-minseverity' => '이에 대한 문제의 최소 심각도를 나타내야 합니다.',
	'validator-describe-description' => '변수기를 통해 지정한 하나 이상의 파서 훅에 대한 문서를 만듭니다.',
	'validator-describe-notfound' => '"$1" 핸들에는 파서 훅이 없습니다.',
	'validator-describe-descriptionmsg' => "'''설명''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|별칭}}''': $1",
	'validator-describe-parserfunction' => '파서 함수로만 구현합니다.',
	'validator-describe-tagextension' => '태그 확장 기능으로만 구현합니다.',
	'validator-describe-bothhooks' => '파서 함수와 태그 확장 기능 모두로 구현합니다.',
	'validator-describe-par-hooks' => '파서는 문서를 보여주는 데에 대해서 연결합니다.',
	'validator-describe-par-pre' => '문서에 렌더링되지 않고 문서에 대한 실제 위키텍스트를 얻도록 허용합니다.',
	'validator-describe-par-language' => '설명을 보여줄 언어',
	'validator-describe-listtype' => '$1 항목의 목록',
	'validator-describe-empty' => '비었음',
	'validator-describe-required' => '필수',
	'validator-describe-header-parameter' => '변수',
	'validator-describe-header-aliases' => '별칭',
	'validator-describe-header-type' => '종류',
	'validator-describe-header-default' => '기본값',
	'validator-describe-header-description' => '설명',
	'validator-describe-parameters' => '변수',
	'validator-describe-syntax' => '문법',
	'validator-describe-tagmin' => '필요한 변수에만 태그 확장 기능.',
	'validator-describe-tagmax' => '모든 변수와 태그 확장 기능.',
	'validator-describe-tagdefault' => '기본 변수 표기을 사용하여 모든 변수와 태그 확장 기능.',
	'validator-describe-pfmin' => '필요한 변수에만 파서 함수.',
	'validator-describe-pfmax' => '모든 변수와 파서 함수.',
	'validator-describe-pfdefault' => '기본 변수 표기을 사용하여 모든 변수와 파서 함수.',
	'validator-describe-autogen' => '이 부분의 내용은 변수기 확장 기능의 "설명" 파서 훅에 의해 자동으로 만들었습니다.',
	'validator_error_empty_argument' => '$1 변수는 빈 값을 가질 수 없습니다.',
	'validator_error_must_be_number' => '$1 변수만 숫자가 될 수 있습니다.',
	'validator_error_must_be_integer' => '$1 변수만 정수가 될 수 있습니다.',
	'validator_error_must_be_title' => '$1 변수만 유효한 위키 문서 이름이 될 수 있습니다.',
	'validator_error_must_be_existing_title' => '$1 변수만 기존 위키 문서 이름이 될 수 있습니다.',
	'validator-error-must-be-float' => '$1 변수만 부동 소수점 숫자가 될 수 있습니다.',
	'validator_error_invalid_range' => '$1 변수는 $2(와)과 $3 사이여야 합니다.',
	'validator-error-invalid-regex' => '$1 변수는 이 정규 표현식과 일치해야 합니다: $2.',
	'validator-error-invalid-length' => '$1 변수는 $2의 길이를 가져야 합니다.',
	'validator-error-invalid-length-range' => '$1 변수는 $2(와)과 $3 사이의 길이를 가져야 합니다.',
	'validator_error_invalid_argument' => '$1 값은 $2 변수에 유효하지 않습니다.',
	'validator_list_error_empty_argument' => '$1 변수는 빈 값을 허용하지 않습니다.',
	'validator_list_error_must_be_number' => '$1 변수는 숫자만 포함할 수 있습니다.',
	'validator_list_error_must_be_integer' => '$1 변수는 정수만 포함할 수 있습니다.',
	'validator_list_error_must_be_title' => '$1 변수는 유효한 위키 문서 이름만 포함할 수 있습니다.',
	'validator_list_error_must_be_existing_title' => '$1 변수는 기존 위키 문서 이름만 포함할 수 있습니다.',
	'validator-list-error-must-be-float' => '$1 변수는 부동 소수점 숫자만 포함할 수 있습니다.',
	'validator_list_error_invalid_range' => '$1 변수의 모든 값은 $2(와)과 $3 사이여야 합니다.',
	'validator-list-error-invalid-regex' => '$1 변수의 모든 값은 이 정규 표현식과 일치해야 합니다: $2.',
	'validator_list_error_invalid_argument' => '$1 변수에 대해 하나 이상의 값이 잘못되었습니다.',
	'validator-list-error-accepts-only' => '$1 변수에 대해 하나 이상의 값이 잘못되었습니다. 이는 {{PLURAL:$3|이 값}}만 승인합니다: $2.',
	'validator-list-error-accepts-only-omitted' => '$1 변수에 대해 하나 이상의 값이 잘못되었습니다. 이는 {{PLURAL:$3|이 값}}만 승인합니다: $2 (그리고 $4 값은 생략합니다).',
	'validator_error_accepts_only' => '"$4" 값은 $1 변수에 대해 유효하지 않습니다. 이는 {{PLURAL:$3|이 값}}만 승인합니다: $2.',
	'validator-error-accepts-only-omitted' => '"$2" 값은 $1 변수에 대해 유효하지 않습니다. 이는 {{PLURAL:$5|이 값}}만 승인합니다: $3 (그리고 $4 값은 생략합니다).',
	'validator_list_omitted' => '$1 {{PLURAL:$2|값}}은 생략{{PLURAL:$2|합니다}}.',
	'validator-message-nodesc' => '설명을 제공하지 않았습니다',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'validator-desc' => '{{int:validator_name}} brängk eine eijfache Wääsch, der Parrammeetere fun Paaser-Fungkßjohne un Zohsatzprojramme ze prööve, Schtandatt-Wääte enzefööje, un Fähler ze mällde.',
	'validator-warning' => 'Opjepaß: $1',
	'validator-error' => 'Fähler: $1',
	'validator-fatal-error' => "'''Dä!''' $1",
	'validator_error_parameters' => '{{PLURAL:$1|Heh dä|Heh di|Keine}} Fähler {{PLURAL:$1|es|sin|es}} en Dinge Syntax opjevalle:',
	'validator_warning_parameters' => 'Et {{PLURAL:$1|es ene|sin|es keine}} Fähler en Dinge Süntax.',
	'validator-warning-adittional-errors' => '…&nbsp;un {{PLURAL:$1|noch e Probleem|söns Probleeme|söns kei Probleem}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Dä Wert „$1“ fählt|De Wääte „$1“ fähle|Nix fählt}}.',
	'validator-error-problem' => 'Et johv e Probleem mem Parrameeter $1.',
	'validator_error_unknown_argument' => '„$1“ es keine jöltijje Parameeter.',
	'validator_error_required_missing' => 'Dä Parameeter $1 moß aanjejovve sin, un fählt.',
	'validator-error-override-argument' => 'Versooht, dä Parrameeter $1 (mem Wäät: $2) met „$3“ ze övverschriive.',
	'validator-type-string' => 'Täx',
	'validator-type-integer' => 'janze Zahl (ohne Komma!)',
	'validator-type-float' => 'Zahl (met Komma)',
	'validator-type-boolean' => 'Joh udder Nää',
	'validator-type-char' => 'Zeiche, Zeffer, Boochshtaabe,&nbsp;…',
	'validator-type-title' => 'Tittel',
	'validator-type-string-list' => 'Lėß met Täxte',
	'validator-type-integer-list' => 'Lėß met janze Zahle',
	'validator-type-float-list' => 'Lėß met Zahle',
	'validator-type-boolean-list' => 'Lėß met Joh udder Nää',
	'validator-type-title-list' => 'Leß vun Tittelle',
	'validator-listerrors-errors' => 'Fähler',
	'validator-listerrors-minor' => 'Bahl ejaal',
	'validator-listerrors-low' => 'Kleineshkeit',
	'validator-listerrors-normal' => 'Nomaal',
	'validator-listerrors-high' => 'Huh',
	'validator-listerrors-fatal' => 'Schlemm',
	'validator-listerrors-par-minseverity' => 'Wi schlemm ene Fähler winnishßdens sin moß, domet_e aanjezeish weed.',
	'validator-describe-notfound' => 'Et jidd_er keine Paaserhooke, dä „$1“ afhandele deiht.',
	'validator-describe-parserfunction' => 'Bloß als ene Paaserfunxjuhn enjeresht.',
	'validator-describe-listtype' => 'Leß met {{PLURAL:$1|einem Endraach|$1 Endrääsh|keinem Endraach}}',
	'validator-describe-empty' => 'nix dren',
	'validator-describe-required' => 'nüüdesch',
	'validator-describe-header-parameter' => 'Parrameeter',
	'validator-describe-header-type' => 'Zoot',
	'validator-describe-header-default' => 'Shtandatt',
	'validator-describe-header-description' => 'Beschrievong',
	'validator-describe-parameters' => 'Parrameetere',
	'validator-describe-syntax' => 'Süntax',
	'validator_error_empty_argument' => 'Dä Parameeter $1 kann keine Wäät met nix dren hann.',
	'validator_error_must_be_number' => 'Dä Parameeter $1 kann blohß en Zahl sin.',
	'validator_error_must_be_integer' => 'Dä Parrameeter $1 kann bloß en jannze Zahl sin.',
	'validator-error-must-be-float' => 'Dä Parameeter $1 kann blohß en Zahl met Komma sin.',
	'validator_error_invalid_range' => 'Dä Parameeter $1 moß zwesche $2 un $3 sin.',
	'validator-error-invalid-regex' => 'Dä Parrameeter $1 moß op di <i lang="en">regular expression</i> „<code>$2</code>“ paße.',
	'validator-error-invalid-length' => 'Dä Parameeter $1 moß $2 Zeijshe lang sin.',
	'validator-error-invalid-length-range' => 'Dä Parameeter $1 moß zwesche $2 un $3 Zeijshe lang sin.',
	'validator_error_invalid_argument' => 'Däm Parameeter $2 singe Wäät es $1, dat es ävver doför nit jöltesch.',
	'validator_list_error_empty_argument' => 'Dä Parameeter $1 kann nit läddesh sin.',
	'validator_list_error_must_be_number' => 'Dä Parameeter $1 kann blohß Zeffere änthallde.',
	'validator_list_error_must_be_integer' => 'Dä Parameeter $1 kann blohß janze Zahle änthallde.',
	'validator-list-error-must-be-float' => 'Dä Parameeter $1 kann blohß Zahle met Komma dren änthallde.',
	'validator_list_error_invalid_range' => 'All de Wääte vum Parameeter $1 möße zwesche $2 un $3 lijje.',
	'validator_error_accepts_only' => '„$4“ es nit ze Bruche, weil dä Parameeter $1 {{PLURAL:$3|bloß eine Wäät|bloß eine vun heh dä Wääte|keine Wäät}} han kann: $2',
	'validator_list_omitted' => '{{PLURAL:$2|Dä Wäät|De Wääte|Keine Wäät}} $1 {{PLURAL:$2|es|sen|se}} fottjelohße woode.',
	'validator-message-nodesc' => 'Kein Beschrievong doh',
);

/** Kurdish (Latin script) (Kurdî (latînî)‎)
 * @author George Animal
 */
$messages['ku-latn'] = array(
	'validator-error' => 'Çewtî:$1',
	'validator-type-string' => 'nivîs',
	'validator-type-boolean' => 'erê/na',
	'validator-type-title' => 'sernav',
	'validator-listerrors-errors' => 'Çewtî',
	'validator-listerrors-high' => 'bilind',
	'validator-describe-empty' => 'vala',
	'validator-describe-header-parameter' => 'Parametre',
	'validator-describe-header-type' => 'Cure',
	'validator-describe-header-description' => 'Danasîn',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'validator-desc' => 'Validator erlaabt et op eng einfach Manéier fir Parametere vu Parser-Fonctiounen an Tag-Erweiderungen ze validéieren, fir Standard-Wäerter festzeleeën a fir Feeler-Messagen ze generéieren',
	'validator-warning' => 'Opgepasst: $1',
	'validator-error' => 'Feeler: $1',
	'validator-fatal-error' => 'Fatale Feeler: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Dëse Feeler gouf|Dës Feeler goufen}} an Ärer Syntax fonnt:',
	'validator_warning_parameters' => 'Et {{PLURAL:$1|ass ee|si}} Feeler an Ärer Syntax.',
	'validator-warning-adittional-errors' => '… an {{PLURAL:$1|e weidere Sujet|weider Sujeten}}.',
	'validator-error-omitted' => '{{PLURAL:$2|De Wäert|D\'Wäerter}} "$1" {{PLURAL:$2|gouf|goufe}} vergiess.',
	'validator-error-problem' => 'Et gouf e Problem mam Parameter $1.',
	'validator_error_unknown_argument' => '$1 ass kee valbele Parameter.',
	'validator_error_required_missing' => 'Den obligatoresche Parameter $1 war net derbäi.',
	'validator-error-override-argument' => 'huet versicht de Parameter $1 (Wäert: $2) mam Wäert "$3" z\'iwwerschreiwen',
	'validator-type-string' => 'Text',
	'validator-type-integer' => 'Ganz Zuel',
	'validator-type-float' => 'Zuel',
	'validator-type-boolean' => 'Jo/Neen',
	'validator-type-char' => 'Zeechen',
	'validator-type-title' => 'Titel',
	'validator-type-string-list' => 'Lëscht vun den Texter',
	'validator-type-float-list' => 'Lëscht vun Zuelen',
	'validator-type-boolean-list' => 'Jo/Neen Lëscht',
	'validator-type-title-list' => 'Lëscht vun Titelen',
	'validator-listerrors-errors' => 'Feeler',
	'validator-listerrors-minor' => 'Marginal',
	'validator-listerrors-low' => 'Niddreg',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Héich',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-par-minseverity' => 'Déi mannste Schwieregkeet vun engem Feeler fir datt en hei gewise gëtt.',
	'validator-describe-descriptionmsg' => "'''Beschreiwung''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasen}}:''' $1",
	'validator-describe-par-language' => "D'Sprooch an där d'Beschreiwunge gewise solle ginn",
	'validator-describe-listtype' => 'Lëscht mat {{PLURAL:$1|engem Element|$1 Elementer}}',
	'validator-describe-empty' => 'eidel',
	'validator-describe-required' => 'obligatoresch',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Aliasen',
	'validator-describe-header-type' => 'Typ',
	'validator-describe-header-default' => 'Standard',
	'validator-describe-header-description' => 'Beschreiwung',
	'validator-describe-parameters' => 'Parameteren',
	'validator-describe-syntax' => 'Syntax',
	'validator-describe-pfmax' => 'Parserfonctioun mat alle Parameter.',
	'validator_error_empty_argument' => 'De Parameter $1 ka keen eidele Wäert hunn.',
	'validator_error_must_be_number' => 'De Parameter $1 ka just eng Zuel sinn',
	'validator_error_must_be_integer' => 'De Parameter $1 ka just eng ganz Zuel sinn.',
	'validator-error-must-be-float' => 'Parameter $1 kann nëmmen eng Féisskommazuel sinn.',
	'validator_error_invalid_range' => 'De Parameter $1 muss tëschent $2 an $3 leien.',
	'validator-error-invalid-regex' => 'De Parameter $1 muss esou ausgesinn: $2',
	'validator-error-invalid-length' => 'Parameter $1 muss eng Längt vu(n) $2 hunn.',
	'validator-error-invalid-length-range' => 'De Parameter $1 muss eng Längt tëschent $2 an $3 hunn.',
	'validator_error_invalid_argument' => 'De Wäert $1 ass net valabel fir de Parameter $2.',
	'validator_list_error_empty_argument' => 'De Parameter $1 hëlt keng eidel Wäerter un.',
	'validator_list_error_must_be_number' => 'Am Parameter $1 kënnen nëmmen Zuelen dra sinn.',
	'validator_list_error_must_be_integer' => 'Am Parameter $1 kënnen nëmme ganz Zuele sinn.',
	'validator-list-error-must-be-float' => 'Am Parameter $1 kënnen nëmme Kommazuelen dra sinn.',
	'validator_list_error_invalid_range' => 'All Wäerter vum Parameter $1 mussen tëschent $2 an $3 leien.',
	'validator-list-error-invalid-regex' => 'All Wäerter vum Parameter $1 mussen dësem regulären Ausdrock entspriechen: $2',
	'validator_list_error_invalid_argument' => 'Een oder méi Wäerter fir de Parameter $1 sinn net valabel.',
	'validator-list-error-accepts-only' => 'Een oder méi Wäerter vum Parameter $1 sinn net valabel.
En akzeptéiert nëmmen {{PLURAL:$3|dëse Wäert|dës Wäerter}}: $2.',
	'validator_error_accepts_only' => 'De Wäert $4 ass net valabel fir de Parameter $1. En akzeptéiert just {{PLURAL:$3|dëse Wäert|dës Wäerter}}: $2',
	'validator-error-accepts-only-omitted' => 'De Wäert "$2" ass net valabel fir de Parameter $1.
En akzeptéiert nëmmen {{PLURAL:$5|dëse Wäert|dës Wäerter}}: $3 (an {{PLURAL:$4|een ausgeloossene Wäert|$4 ausgeloosse Wäerter}}).',
	'validator_list_omitted' => "{{PLURAL:$2|De Wäert|D'Wäerter}} $1 {{PLURAL:$2|gouf|goufe}} vergiess.",
	'validator-message-nodesc' => 'Et gëtt keng Beschreiwung',
);

/** Latvian (latviešu)
 * @author GreenZeb
 */
$messages['lv'] = array(
	'validator-listerrors-errors' => 'Kļūdas',
	'validator-listerrors-minor' => 'Maznozīmīgas',
	'validator-listerrors-fatal' => 'Fatālas',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 * @author McDutchie
 */
$messages['mk'] = array(
	'validator-desc' => 'Потврдувачот овозможува лесен начин другите додатоци да ги потврдат параметрите на парсерските функции и додатоците со ознаки, да поставаат основно зададени вредности и да создаваат пораки за грешки',
	'validator-warning' => 'Предупредување: $1',
	'validator-error' => 'Грешка: $1',
	'validator-fatal-error' => 'Фатална грешка: $1',
	'validator_error_parameters' => 'Во вашата синтакса {{PLURAL:$1|е откриена следнава грешка|се откриени следниве грешки}}:',
	'validator_warning_parameters' => 'Имате {{PLURAL:$1|грешка|грешки}} во синтаксата.',
	'validator-warning-adittional-errors' => '... и {{PLURAL:$1|уште еден проблем|повеќе други проблеми}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Изоставена е вредноста „$1“|Изоставени се вредностите „$1“}}.',
	'validator-error-problem' => 'Се појави проблем со параметарот $1.',
	'validator_error_unknown_argument' => '$1 не е важечки параметар.',
	'validator_error_required_missing' => 'Бараниот параметар $1 не е наведен.',
	'validator-error-override-argument' => 'Се обидовте да презапишете врз параметарот $1 (вредност: $2) со вредност „$3“',
	'validator-type-string' => 'текст',
	'validator-type-integer' => 'цел број',
	'validator-type-float' => 'број',
	'validator-type-boolean' => 'да/не',
	'validator-type-char' => 'знак',
	'validator-type-title' => 'наслов',
	'validator-type-string-list' => 'список на текстови',
	'validator-type-integer-list' => 'список на цели броеви',
	'validator-type-float-list' => 'список на броеви',
	'validator-type-boolean-list' => 'список на да/не',
	'validator-type-char-list' => 'список на знаци',
	'validator-type-title-list' => 'списо на наслови',
	'validator-listerrors-errors' => 'Грешки',
	'validator-listerrors-severity-message' => '($1) $2',
	'validator-listerrors-minor' => 'Ситни',
	'validator-listerrors-low' => 'Малку',
	'validator-listerrors-normal' => 'Нормално',
	'validator-listerrors-high' => 'Многу',
	'validator-listerrors-fatal' => 'Фатални',
	'validator-listerrors-description' => 'Ги наведува грешките (и предупредувањата) што се јавиле кај парсерските куки додадени преки Потврдувачот (Validator).
Ги наведува само парсерските куки додадени погоре каде е вметнато „listerrors“;
ставете го „listerrors“ на или близу дното на страницата за да ви се прикажат сите грешки.',
	'validator-listerrors-par-minseverity' => 'Минималната сериозност на проблемот за да биде наведен.',
	'validator-describe-description' => 'Создава документација за една или повеќе парсерски куки определени преку Потврдувачот.',
	'validator-describe-notfound' => 'Нема парсерска кука што работи со „$1“.',
	'validator-describe-descriptionmsg' => "'''Опис''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Алијас|Алијаси}}''': $1",
	'validator-describe-parserfunction' => 'Се применува само во својство на парсерска функција.',
	'validator-describe-tagextension' => 'Се применува само во својство на додаток за означување.',
	'validator-describe-bothhooks' => 'Се применува во својство на парсерска функција и додаток за означување (обете).',
	'validator-describe-par-hooks' => 'Парсерските куки за кои сакате да се прикаже документација.',
	'validator-describe-par-pre' => 'Ви овозможува да го добиете самиот викитекст за документацијата, без да се испише на страницата',
	'validator-describe-par-language' => 'На кој јазик да се прикажуваат описите',
	'validator-describe-listtype' => 'Список на $1 ставки',
	'validator-describe-empty' => 'празно',
	'validator-describe-required' => 'задолжително',
	'validator-describe-header-parameter' => 'Параметар',
	'validator-describe-header-aliases' => 'Алијаси',
	'validator-describe-header-type' => 'Вид',
	'validator-describe-header-default' => 'По основно',
	'validator-describe-header-description' => 'Опис',
	'validator-describe-parameters' => 'Параметри',
	'validator-describe-syntax' => 'Синтакса',
	'validator-describe-tagmin' => 'Додаток за означување само со задолжителните параметри.',
	'validator-describe-tagmax' => 'Додаток за означување со сите параметри.',
	'validator-describe-tagdefault' => 'Додаток за означување кајшто сите параметри ја користат стандардната параметарска нотација.',
	'validator-describe-pfmin' => 'Парсерска функција само со задолжителните параметри.',
	'validator-describe-pfmax' => 'Парсерска функција со сите параметри.',
	'validator-describe-pfdefault' => 'Парсерска функција кајшто сите параметри ја користат стандардната параметарска нотација.',
	'validator-describe-autogen' => 'Содржината на овој поднаслов е создадена автоматски од парсерската кука „describe“ на додатокот Потврдувач (Validator).',
	'validator_error_empty_argument' => 'Параметарот $1 не може да има празна вредност.',
	'validator_error_must_be_number' => 'Параметарот $1 може да биде само број.',
	'validator_error_must_be_integer' => 'Параметарот $1 може да биде само цел број.',
	'validator_error_must_be_title' => 'Параметарот $1 може да биде само важечко име на викистраница.',
	'validator_error_must_be_existing_title' => 'Параметарот $1 може да биде само постоечко име на викистраница.',
	'validator-error-must-be-float' => 'Параметарот $1 може да биде само број со подвижна точка.',
	'validator_error_invalid_range' => 'Параметарот $1 мора да изнесува помеѓу $2 и $3.',
	'validator-error-invalid-regex' => 'Параметарот $1 мора да се совпаѓа со следниов регуларен израз: $2.',
	'validator-error-invalid-length' => 'Параметарот $1 мора да има должина од $2.',
	'validator-error-invalid-length-range' => 'Должината на параметарот параметарот $1 мора да изнесува помеѓу $2 и $3.',
	'validator_error_invalid_argument' => 'Вредноста $1 е неважечка за параметарот $2.',
	'validator_list_error_empty_argument' => 'Параметарот $1 не прифаќа празни вредности.',
	'validator_list_error_must_be_number' => 'Параметарот $1 може да содржи само бројки.',
	'validator_list_error_must_be_integer' => 'Параметарот $1 може да содржи само цели броеви.',
	'validator_list_error_must_be_title' => 'Параметарот $1 може да содржи само важечки имиња на викистраници.',
	'validator_list_error_must_be_existing_title' => 'Параметарот $1 може да содржи само постоечки имиња на викистраници.',
	'validator-list-error-must-be-float' => 'Параметарот $1 може да содржи само подвижни бинарни точки.',
	'validator_list_error_invalid_range' => 'Сите вредности на параметарот $1 мора да бидат помеѓу $2 и $3.',
	'validator-list-error-invalid-regex' => 'Сите вредности на параметарот $1 мора да се совпаднат со следниов регуларен израз: $2.',
	'validator_list_error_invalid_argument' => 'Една или повеќе вредности на параметарот $1 се неважечки.',
	'validator-list-error-accepts-only' => 'Параметарот $1 има една или повеќе неважечки вредности.
Се {{PLURAL:$3|прифаќа само следнава вредност|прифаќаат само следниве вредности}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Параметарот $1 има една или повеќе неважечки вредности.
Се {{PLURAL:$3|прифаќа само следнава вредност|прифаќаат само следниве вредности}}: $2 (и $4 {{PLURAL:$4|изоставена вредност|изоставени вредности}}).',
	'validator_error_accepts_only' => 'Вредноста „$4“ е неважечка за параметарот $1. Се {{PLURAL:$3|прифаќа само следнава вредност|прифаќаат само следниве вредности}}: $2.',
	'validator-error-accepts-only-omitted' => 'Вредноста „$2“ не е важечка за параметарот $1. Се прифаќаат само следниве вредности: $3 (и $4 изоставени вредности).',
	'validator_list_omitted' => '{{PLURAL:$2|Вредноста|Вредностите}} $1 {{PLURAL:$2|беше испуштена|беа испуштени}}.',
	'validator-message-nodesc' => 'Нема наведено опис',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'validator-describe-descriptionmsg' => "'''Keterangan''': $1",
	'validator-describe-empty' => 'kosong',
	'validator-describe-required' => 'wajib',
	'validator-describe-header-default' => 'Asali',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Event
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'validator-desc' => 'Gir generisk støtte for parameterhåndtering fra andre utvidelser',
	'validator-warning' => 'Advarsel: $1',
	'validator-error' => 'Feil: $1',
	'validator-fatal-error' => 'Kritisk feil: $1',
	'validator_error_parameters' => 'Følgende {{PLURAL:$1|feil|feil}} har blitt oppdaget i syntaksen din:',
	'validator_warning_parameters' => 'Det er {{PLURAL:$1|én feil|flere feil}} i syntaksen din.',
	'validator-warning-adittional-errors' => '... og {{PLURAL:$1|ett problem til|flere problem}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Verdien|Verdiene}} «$1» har blitt utelatt.',
	'validator-error-problem' => 'Det var et problem med parameter $1.',
	'validator_error_unknown_argument' => '$1 er ikke en gyldig parameter.',
	'validator_error_required_missing' => 'Den nødvendige parameteren «$1» er ikke angitt.',
	'validator-error-override-argument' => 'Prøvde å overkjøre parameter $1 (verdi: $2) med verdien «$3»',
	'validator-type-string' => 'tekst',
	'validator-type-integer' => 'heltall',
	'validator-type-float' => 'tall',
	'validator-type-boolean' => 'ja/nei',
	'validator-type-char' => 'tegn',
	'validator-listerrors-errors' => 'Feil',
	'validator-listerrors-minor' => 'Mindre',
	'validator-listerrors-low' => 'Lav',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Høy',
	'validator-listerrors-fatal' => 'Kritisk',
	'validator-listerrors-description' => 'Lister opp feil (og advarsler) som oppsto i "parser hooks" via Validator.
Lister bare opp for "parser hooks" lagt til over der "listerrors" er satt inn;
plasser "listerrors" på eller nær bunnen av siden for å få frem alle feilene.',
	'validator-listerrors-par-minseverity' => 'Minimum alvorlighetsgrad for at en sak skal listes opp.',
	'validator-describe-description' => 'Genererer dokumentasjon for en eller flere "parser hooks" definert via Validator.',
	'validator-describe-notfound' => 'Det finnes ingen "parser hook" som håndterer "$1".',
	'validator-describe-descriptionmsg' => "''Beskrivelse''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliaser}}''': $1",
	'validator-describe-parserfunction' => 'Bare implementert som en parser-funksjon.',
	'validator-describe-tagextension' => 'Bare implementert som en tag-utvidelse.',
	'validator-describe-bothhooks' => 'Implementert både som en parser-funksjon og en tag-utvidelse.',
	'validator-describe-par-hooks' => '"Parser hooks" som brukes for å angi dokumentasjon.',
	'validator-describe-par-pre' => 'Tillater deg å få den faktiske wikiteksten for dokumentasjonen uten at den blir gjengitt på siden.',
	'validator-describe-par-language' => 'Språket som brukes for beskrivelsene',
	'validator-describe-listtype' => 'Liste av $1 elementer',
	'validator-describe-empty' => 'tom',
	'validator-describe-required' => 'påkrevet',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Aliaser',
	'validator-describe-header-type' => 'Type',
	'validator-describe-header-default' => 'Standard',
	'validator-describe-header-description' => 'Beskrivelse',
	'validator-describe-parameters' => 'Parametre',
	'validator-describe-syntax' => 'Syntaks',
	'validator-describe-tagmin' => 'Tag-utvidelse bare med de påkrevde parametrene.',
	'validator-describe-tagmax' => 'Tag-utvidelse med alle parametrene.',
	'validator-describe-tagdefault' => 'Tag-utvidelse med alle parametrene som bruker standard parameternotasjon.',
	'validator-describe-pfmin' => 'Parser-funksjon bare med de påkrevde parametrene.',
	'validator-describe-pfmax' => 'Parser-funksjon med alle parametrene.',
	'validator-describe-pfdefault' => 'Parser-funksjon med alle parametrene som bruker standard parameternotasjon.',
	'validator-describe-autogen' => 'Innholdet i dette avsnittet ble autogenerert av "describe parser hook" fra Validator-utvidelsen.',
	'validator_error_empty_argument' => 'Parameter $1 kan ikke ha en tom verdi.',
	'validator_error_must_be_number' => 'Parameter $1 må være et tall.',
	'validator_error_must_be_integer' => 'Parameter $1 må være et heltall.',
	'validator-error-must-be-float' => 'Parameter $1 må være et flyttall.',
	'validator_error_invalid_range' => 'Parameter $1 må være mellom $2 og $3.',
	'validator-error-invalid-regex' => 'Parameter $1 må samsvare med dette regulæruttrykket: $2.',
	'validator-error-invalid-length' => 'Parameter $1 må ha en lengde på $2.',
	'validator-error-invalid-length-range' => 'Parameter $1 må ha en lengde mellom $2 og $3.',
	'validator_error_invalid_argument' => 'Verdien $1 er ikke gyldig for parameter $2.',
	'validator_list_error_empty_argument' => 'Parameter $1 kan ikke ikke ha en tom verdi.',
	'validator_list_error_must_be_number' => 'Parameter $1 kan bare inneholde tall.',
	'validator_list_error_must_be_integer' => 'Parameter $1 kan bare inneholde heltall.',
	'validator-list-error-must-be-float' => 'Parameter $1 kan bare innholde flyttall.',
	'validator_list_error_invalid_range' => 'Alle verdier av parameter $1 må være mellom $2 og $3.',
	'validator-list-error-invalid-regex' => 'Alle verdier av parameter $1 må samsvare med dette regulæruttrykket: $2.',
	'validator_list_error_invalid_argument' => 'Parameter $1 har en eller flere ugyldige verdier.',
	'validator-list-error-accepts-only' => 'En eller flere verdier for parameter $1 er ugyldige.
Den godtar bare {{PLURAL:$3|denne verdien|disse verdiene}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'En eller flere verdier for parameter $1 er ugyldige.
Den godtar bare {{PLURAL:$3|denne verdien|disse verdiene}}: $2 (og $4 {{PLURAL:$4|utelatt verdi|utelatte verdier}}).',
	'validator_error_accepts_only' => 'Verdien «$4» er ikke gyldig for parameter $1. Den godtar kun {{PLURAL:$3|denne verdien|disse verdiene}}: $2.',
	'validator-error-accepts-only-omitted' => 'Verdien «$2» er ikke gyldig for parameter $1.
Den godtar bare {{PLURAL:$5|denne verdien|disse verdiene}}: $3 (og $4 {{PLURAL:$4|utelatt verdi|utelatte verdier}}).',
	'validator_list_omitted' => '{{PLURAL:$2|Verdien|Verdiene}} $1 har blitt utelatt.',
);

/** Dutch (Nederlands)
 * @author Jeroen De Dauw
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'validator-desc' => 'Validator geeft andere uitbreidingen de mogelijkheid om parameters van parserfuncties en taguitbreidingen te valideren, in te stellen op hun standaardwaarden en foutberichten te genereren',
	'validator-warning' => 'Waarschuwing: $1',
	'validator-error' => 'Fout: $1',
	'validator-fatal-error' => 'Onherstelbare fout: $1',
	'validator_error_parameters' => 'In uw syntaxis {{PLURAL:$1|is de volgende fout|zijn de volgende fouten}} gedetecteerd:',
	'validator_warning_parameters' => 'Er {{PLURAL:$1|zit een fout|zitten $1 fouten}} in uw syntaxis.',
	'validator-warning-adittional-errors' => '... en nog {{PLURAL:$1|een ander probleem|$1 andere problemen}}.',
	'validator-error-omitted' => 'De {{PLURAL:$2|waarde "$1" mist|waarden "$1" missen}}.',
	'validator-error-problem' => 'Er was een probleem met de parameter $1.',
	'validator_error_unknown_argument' => '$1 is geen geldige parameter.',
	'validator_error_required_missing' => 'De verplichte parameter $1 is niet opgegeven.',
	'validator-error-override-argument' => 'Geprobeerd de parameter $1 (waarde: $2) te overschrijven met waarde "$3".',
	'validator-type-string' => 'tekst',
	'validator-type-integer' => 'geheel getal',
	'validator-type-float' => 'getal',
	'validator-type-boolean' => 'ja / nee',
	'validator-type-char' => 'teken',
	'validator-type-title' => 'paginanaam',
	'validator-type-string-list' => 'lijst met teksten',
	'validator-type-integer-list' => 'lijst met gehele getallen',
	'validator-type-float-list' => 'lijst met getallen',
	'validator-type-boolean-list' => 'lijst met ja/nee',
	'validator-type-char-list' => 'lijst met tekens',
	'validator-type-title-list' => 'lijst met paginanamen',
	'validator-listerrors-errors' => 'Fouten',
	'validator-listerrors-minor' => 'Overkomelijk',
	'validator-listerrors-low' => 'Laag',
	'validator-listerrors-normal' => 'Gemiddeld',
	'validator-listerrors-high' => 'Groot',
	'validator-listerrors-fatal' => 'Fataal',
	'validator-listerrors-description' => "Fouten en waarschuwingen weergeven die zijn opgetreden in parserhooks die via Validator zijn toegevoegd.
Geeft alleen parserhooks weer die zijn toegevoegd voordat de fout is opgetreden;
plaats fouten onderaan of bijna onderaan pagina's om alle fouten weer te geven.",
	'validator-listerrors-par-minseverity' => 'De minimale ernst van een probleem voordat het wordt weergegeven.',
	'validator-describe-description' => 'Maakt documentatie aan voor een of meer parserhooks die via Validator zijn gedefinieerd.',
	'validator-describe-notfound' => 'Er is geen parserhook die "$1" afhandelt.',
	'validator-describe-descriptionmsg' => "'''Beschrijving''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliassen}}''': $1",
	'validator-describe-parserfunction' => 'Alleen als parserfunctie geïmplementeerd.',
	'validator-describe-tagextension' => 'Alleen als labeluitbreiding geïmplementeerd.',
	'validator-describe-bothhooks' => 'Als parserfunctie en labeluitbreiding geïmplementeerd.',
	'validator-describe-par-hooks' => 'Parserhooks waarvoor documentatie weergegeven moet worden.',
	'validator-describe-par-pre' => 'Maakt het mogelijk de wikitekst voor de documentatie weer te geven zonder dat deze wordt verwerkt.',
	'validator-describe-par-language' => 'De taal om de beschrijvingen in weer te geven',
	'validator-describe-listtype' => 'Lijst met $1 items',
	'validator-describe-empty' => 'leeg',
	'validator-describe-required' => 'verplicht',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Aliassen',
	'validator-describe-header-type' => 'Type',
	'validator-describe-header-default' => 'Standaard',
	'validator-describe-header-description' => 'Beschrijving',
	'validator-describe-parameters' => 'Parameters',
	'validator-describe-syntax' => 'Syntaxis',
	'validator-describe-tagmin' => 'Labeluitbreiding met alleen de verplichte parameters.',
	'validator-describe-tagmax' => 'Labeluitbreiding met alle parameters.',
	'validator-describe-tagdefault' => 'Labeluitbreiding met alle parameters die de standaard parameternotatie gebruiken.',
	'validator-describe-pfmin' => 'Parserfunctie met alleen de verplichte parameters.',
	'validator-describe-pfmax' => 'Parserfunctie met alle parameters.',
	'validator-describe-pfdefault' => 'Parserfunctie met alle parameters die de standaard parameternotatie gebruiken.',
	'validator-describe-autogen' => 'De inhoud van deze paragraaf is automatisch aangemaakt door de parserhook "beschrijven" (describe) van de uitbreiding Validator.',
	'validator_error_empty_argument' => 'De parameter $1 mag niet leeg zijn.',
	'validator_error_must_be_number' => 'De parameter $1 mag alleen een getal zijn.',
	'validator_error_must_be_integer' => 'De parameter $1 kan alleen een heel getal zijn.',
	'validator_error_must_be_title' => 'Parameter $1 kan alleen een geldige wikipaginanaam zijn.',
	'validator_error_must_be_existing_title' => 'Parameter $1 kan alleen een bestaande wikipaginanaam zijn.',
	'validator-error-must-be-float' => 'Parameter $1 kan alleen een getal met decimalen zijn.',
	'validator_error_invalid_range' => 'De parameter $1 moet tussen $2 en $3 liggen.',
	'validator-error-invalid-regex' => 'De parameter $1 moet voldoen aan deze reguliere expressie: $2.',
	'validator-error-invalid-length' => 'Parameter $1 moet een lengte hebben van $2.',
	'validator-error-invalid-length-range' => 'Parameter $1 moet een lengte hebben tussen $2 en $3.',
	'validator_error_invalid_argument' => 'De waarde $1 is niet geldig voor de parameter $2.',
	'validator_list_error_empty_argument' => 'Voor de parameter $1 zijn lege waarden niet toegestaan.',
	'validator_list_error_must_be_number' => 'Voor de parameter $1 zijn alleen getallen toegestaan.',
	'validator_list_error_must_be_integer' => 'Voor de parameter $1 zijn alleen hele getallen toegestaan.',
	'validator_list_error_must_be_title' => 'Parameter $1 kan alleen geldige wikipaginanamen bevatten.',
	'validator_list_error_must_be_existing_title' => 'Parameter $1 kan alleen bestaande wikipaginanamen bevatten.',
	'validator-list-error-must-be-float' => 'Voor de parameter $1 zijn alleen getallen met drijvende komma toegestaan.',
	'validator_list_error_invalid_range' => 'Alle waarden voor de parameter $1 moeten tussen $2 en $3 liggen.',
	'validator-list-error-invalid-regex' => 'Alle waarden voor de parameter $1 moeten voldoen aan deze reguliere expressie: $2.',
	'validator_list_error_invalid_argument' => 'Een of meerdere waarden voor de parameter $1 zijn ongeldig.',
	'validator-list-error-accepts-only' => 'Een of meer waarden voor de parameter $1 zijn ongeldig.
Alleen deze {{PLURAL:$3|waarde is|waarden zijn}} toegestaan: $2.',
	'validator-list-error-accepts-only-omitted' => 'Een of meer waarden voor de parameter $1 zijn ongeldig.
Alleen deze {{PLURAL:$3|waarde is|waarden zijn}} toegestaan: $2.
Als ook $4 weggelaten {{PLURAL:$4|waarde|waarden}}.',
	'validator_error_accepts_only' => 'De waarde "$4" is ongeldig voor parameter $1. Deze kan alleen de volgende {{PLURAL:$3|waarde|waarden}} hebben: $2.',
	'validator-error-accepts-only-omitted' => 'De waarde "$2" is niet geldig voor de parameter $1.
Alleen deze {{PLURAL:$5|waarde is|waarden zijn}} toegestaan: $3.
Als ook $4 weggelaten {{PLURAL:$4|waarde|waarden}}.',
	'validator_list_omitted' => 'De {{PLURAL:$2|waarde|waarden}} $1 {{PLURAL:$2|mist|missen}}.',
	'validator-message-nodesc' => 'Geen beschrijving',
);

/** Occitan (occitan)
 * @author Cedric31
 * @author Jfblanc
 */
$messages['oc'] = array(
	'validator-desc' => "Validator porgís a d'autras extensions un biais per validar aisidament los paramètres de foncions d'analisi e las extensions de mercas, definir de valors per manca e crear de messatges d'error",
	'validator_error_parameters' => '{{PLURAL:$1|Aquela error es estada detectada|Aquelas errors son estadas detectadas}} dins la sintaxi', # Fuzzy
	'validator_error_unknown_argument' => '$1 es pas un paramètre valedor.',
	'validator_error_required_missing' => "Manca lo paramètre $1 qu'es obligatòri.",
	'validator_error_empty_argument' => 'Lo paramètre $1 pòt pas estar voide.',
	'validator_error_must_be_number' => 'Lo paramètre $1 deu èsser un nombre.',
	'validator_error_must_be_integer' => 'Lo paramètre $1 deu èsser un nombre entièr.',
	'validator_error_invalid_range' => 'Lo paramètre $1 deu èsser entre $2 e $3.',
	'validator_error_invalid_argument' => '$1 es pas valedor pel paramètre $2.',
	'validator_error_accepts_only' => 'Sonque {{PLURAL:$3|aquela valor es valedora|aquelas valors son valedoras}}pel paramètre $1 : $2.', # Fuzzy
);

/** Ossetic (Ирон)
 * @author Amikeco
 */
$messages['os'] = array(
	'validator-describe-empty' => 'афтид',
);

/** Pälzisch (Pälzisch)
 * @author Manuae
 */
$messages['pfl'] = array(
	'validator-type-string' => 'Tegschd',
	'validator-type-boolean' => 'Ja/Nä',
	'validator-type-char' => 'Zaische',
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Fizykaa
 * @author Sp5uhe
 * @author Woytecr
 */
$messages['pl'] = array(
	'validator-desc' => 'Dostarcza innym rozszerzeniom ogólną obsługę parametrów',
	'validator-warning' => 'Uwaga – $1',
	'validator-error' => 'Błąd – $1',
	'validator-fatal-error' => 'Błąd krytyczny – $1',
	'validator_error_parameters' => 'W Twoim kodzie {{PLURAL:$1|został wykryty następujący błąd|zostały wykryte następujące błędy}} składni:',
	'validator_warning_parameters' => 'W Twoim kodzie {{PLURAL:$1|wystąpił błąd|wystąpiły błędy}} składni.',
	'validator-warning-adittional-errors' => '... i {{PLURAL:$1|jeszcze jeden problem|wiele więcej problemów}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Wartość „$1” została pominięta|Wartości „$1” zostały pominięte}}.',
	'validator-error-problem' => 'Wystąpił problem z parametrem $1.',
	'validator_error_unknown_argument' => '$1 jest niepoprawnym parametrem.',
	'validator_error_required_missing' => 'Obowiązkowy parametr $1 nie został przekazany.',
	'validator-error-override-argument' => 'Próba nadpisania parametru $1 o wartości „$2” nową wartością „$3”',
	'validator-type-string' => 'tekst',
	'validator-type-integer' => 'liczba całkowita',
	'validator-type-float' => 'liczba rzeczywista',
	'validator-type-boolean' => 'tak lub nie',
	'validator-type-char' => 'znak',
	'validator-type-title' => 'tytuł',
	'validator-type-string-list' => 'lista ciągów znaków',
	'validator-type-integer-list' => 'lista liczb całkowitych',
	'validator-type-float-list' => 'lista liczb',
	'validator-type-boolean-list' => 'lista tak/nie',
	'validator-type-char-list' => 'lista znaków',
	'validator-type-title-list' => 'lista tytułów',
	'validator-listerrors-errors' => 'Błędy',
	'validator-listerrors-minor' => 'Nieistotny',
	'validator-listerrors-low' => 'Mało istotny',
	'validator-listerrors-normal' => 'Typowy',
	'validator-listerrors-high' => 'Istotny',
	'validator-listerrors-fatal' => 'Krytyczny',
	'validator-listerrors-description' => 'Wyświetla błędy (i ostrzeżenia), które wystąpiły w przechwyceniu parsera dodawanemu przez walidator.
Tylko wyświetlenia dla przechwyceń parsera dodanych powyżej miejsca umieszczenia listerrors;
 umieść listerrors na lub w pobliżu końca strony, aby uzyskać wszystkie błędy.',
	'validator-listerrors-par-minseverity' => 'Minimalna waga problemu aby został wymieniony.',
	'validator-describe-description' => 'Generuje dokumentację dla jednego lub więcej przechwyceń parsera, zdefiniowanych przez walidator.',
	'validator-describe-notfound' => 'Nie ma żadnych przechwyceń analizatora składni, obsługujących " $1 ".',
	'validator-describe-descriptionmsg' => "'''Opis''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasy}}''': $1",
	'validator-describe-parserfunction' => 'Zaimplementowano wyłącznie jako funkcję parsera.',
	'validator-describe-tagextension' => 'Zaimplementowano wyłącznie jako rozszerzenie znacznika.',
	'validator-describe-bothhooks' => 'Zaimplementowano jako zarówno funkcję parsera i rozszerzenie znacznika.',
	'validator-describe-par-hooks' => 'Przechwycenia parsera, dla których wyświetlić dokumentację.',
	'validator-describe-par-pre' => 'Umożliwia uzyskanie rzeczywistego wikitekstu dokumentacji, bez renderowania na stronie.',
	'validator-describe-par-language' => 'Język wyświetlania opisów',
	'validator-describe-listtype' => 'Lista  $1  elementów',
	'validator-describe-empty' => 'puste',
	'validator-describe-required' => 'wymagane',
	'validator-describe-header-parameter' => 'Parametr',
	'validator-describe-header-aliases' => 'Aliasy',
	'validator-describe-header-type' => 'Typ',
	'validator-describe-header-default' => 'Domyślnie',
	'validator-describe-header-description' => 'Opis',
	'validator-describe-parameters' => 'Parametry',
	'validator-describe-syntax' => 'Składnia',
	'validator-describe-tagmin' => 'Rozszerzenie znacznika wyłącznie z wymaganymi parametrami.',
	'validator-describe-tagmax' => 'Rozszerzenie znacznika ze wszystkimi parametrami.',
	'validator-describe-tagdefault' => 'Rozszerzenie znacznika z wszystkimi parametrami przy użyciu domyślnej notacji parametrów.',
	'validator-describe-pfmin' => 'Funkcja parsera wyłącznie z wymaganymi parametrami.',
	'validator-describe-pfmax' => 'Funkcja parsera ze wszystkimi parametrami.',
	'validator-describe-pfdefault' => 'Funkcja analizatora składni  ze wszystkimi parametrami przy użyciu domyślnej notacji parametrów.',
	'validator-describe-autogen' => 'Zawartość niniejszej sekcji została automatycznie wygenerowana przez przechwycenie analizatora składni "describe" rozszerzenia walidatora.',
	'validator_error_empty_argument' => 'Parametr $1 nie może być pusty.',
	'validator_error_must_be_number' => 'Parametr $1 musi być liczbą.',
	'validator_error_must_be_integer' => 'Parametr $1 musi być liczbą całkowitą.',
	'validator_error_must_be_title' => 'Parametr $1 może być tylko poprawną nazwą strony wiki.',
	'validator_error_must_be_existing_title' => 'Parametr $1 może być tylko nazwą istniejącej strony wiki.',
	'validator-error-must-be-float' => 'Parametr $1 musi być liczbą rzeczywistą.',
	'validator_error_invalid_range' => 'Parametr $1 musi zawierać się w przedziale od $2 do $3.',
	'validator-error-invalid-regex' => 'Parametr $1 musi pasować do wyrażenia regularnego $2.',
	'validator-error-invalid-length' => 'Parametr $1 musi mieć długość $2.',
	'validator-error-invalid-length-range' => 'Długość parametru $1 musi zawierać się w przedziale od $2 do $3.',
	'validator_error_invalid_argument' => 'Nieprawidłowa wartość $1 parametru $2.',
	'validator_list_error_empty_argument' => 'Parametr $1 nie może być pusty.',
	'validator_list_error_must_be_number' => 'Parametrem $1 mogą być wyłącznie liczby.',
	'validator_list_error_must_be_integer' => 'Parametrem $1 mogą być wyłącznie liczby całkowite.',
	'validator_list_error_must_be_title' => 'Parametr $1 może być tylko poprawnymi nazwami stron wiki.',
	'validator_list_error_must_be_existing_title' => 'Parametr $1 może być tylko nazwami istniejących stron wiki.',
	'validator-list-error-must-be-float' => 'Parametrem $1 mogą być wyłącznie liczby rzeczywiste.',
	'validator_list_error_invalid_range' => 'Wartości parametru $1 muszą zawierać się w przedziale od $2 do $3.',
	'validator-list-error-invalid-regex' => 'Wszystkie wartości parametru $1 muszą pasować do wyrażenia regularnego $2.',
	'validator_list_error_invalid_argument' => 'Przynajmniej jedna wartość parametru $1 jest nieprawidłowa.',
	'validator-list-error-accepts-only' => 'Jedna lub więcej wartości parametru $1 są nieprawidłowe.
Może przyjmować wyłącznie {{PLURAL:$3|wartość|wartości:}} $2.',
	'validator-list-error-accepts-only-omitted' => 'Jedna lub więcej wartości parametru $1 są nieprawidłowe.
Może przyjmować wyłącznie {{PLURAL:$3|wartość|wartości:}} $2 (oraz $4 {{PLURAL:$4|pominiętą wartość|pominięte wartości|pominiętych wartości}}).',
	'validator_error_accepts_only' => 'Wartość „$4” jest nieprawidłowa dla parametru $1. {{PLURAL:$3|Dopuszczalna jest wyłącznie wartość|Dopuszczalne są wyłącznie wartości:}} $2.',
	'validator-error-accepts-only-omitted' => 'Wartość „$2” parametru $1 jest nieprawidłowa.
Parametr może przyjmować wyłącznie {{PLURAL:$5|wartość|wartości:}} $3 (oraz $4 {{PLURAL:$4|pominiętą wartość|pominięte wartości|pominiętych wartości}}).',
	'validator_list_omitted' => '{{PLURAL:$2|Parametr|Parametry}} $1 {{PLURAL:$2|został opuszczony|zostały opuszczone}}.',
	'validator-message-nodesc' => 'Nie podano opisu',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 * @author McDutchie
 */
$messages['pms'] = array(
	'validator-desc' => "Validator a dà na manera bel fé për àutre estension ëd validé ij paràmetr ëd le funsion dël parser e j'estension dij tag, d'amposté ij valor ëd default e generé mëssagi d'eror",
	'validator-warning' => 'Avis: $1',
	'validator-error' => 'Eror: $1',
	'validator-fatal-error' => 'Eror Fatal: $1',
	'validator_error_parameters' => "{{PLURAL:$1|L'eror sì-sota a l'é stàit|J'eror sì-sota a son ëstàit}} trovà an soa sintassi:",
	'validator_warning_parameters' => "{{PLURAL:$1|A-i é n'|A-i son dj'}}eror ant soa sintassi.",
	'validator-warning-adittional-errors' => "... e {{PLURAL:$1|ëdcò n'àutr problema|vàire àutri problema}}.",
	'validator-error-omitted' => '{{PLURAL:$2|Ël valor "$1" a l\'é|Ij valor "$1" a son}} stàit sautà.',
	'validator-error-problem' => 'A-i é staje un problema con ël paràmetr $1.',
	'validator_error_unknown_argument' => "$1 a l'é un paràmetr pa bon.",
	'validator_error_required_missing' => "Ël paràmetr obligatòri $1 a l'é pa dàit.",
	'validator-error-override-argument' => 'Provà a coaté ël paràmetr $1 (valor: $2) con ël valor "$3"',
	'validator-type-string' => 'test',
	'validator-type-integer' => 'nùmer antregh',
	'validator-type-float' => 'nùmer',
	'validator-type-boolean' => 'bò/nò',
	'validator-type-char' => 'caràter',
	'validator-listerrors-errors' => 'Eror',
	'validator-listerrors-minor' => 'Pi cit',
	'validator-listerrors-low' => 'Bass',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Àut',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => "A lista j'eror (e j'avis) che a son capità ant ij gancio ëd l'analisator sintàtich via Validator.
Mach le liste dij gancio ëd l'analisator sintàtich giontà anté ch'a-i é listerrors a son anserìe;
piassé listerrors dzora o davzin ël fond ëd la pàgina për ciapé tùit j'eror.",
	'validator-listerrors-par-minseverity' => "La gravità mìnima ëd n'eror përchè a sia listà.",
	'validator-describe-description' => "A genera la documentassion për un o pi gancio ëd l'analisator sintàtich definì via Validator.",
	'validator-describe-notfound' => 'A-i é gnun gancio ëd l\'analisator sintàtich ch\'a gestissa "$1".',
	'validator-describe-descriptionmsg' => "'''Descrission''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Alias}}''': $1",
	'validator-describe-parserfunction' => "Realisà mach com funsion ëd l'analisator sintàtich.",
	'validator-describe-tagextension' => 'Realisà mach com estension ëd tichëtta.',
	'validator-describe-bothhooks' => "Realisà sia com funsion ëd l'analisator sintàtich che com estension ëd tichëtta.",
	'validator-describe-par-hooks' => "Ij gancio ëd l'analisator sintàtich dont ësmon-e la documentassion.",
	'validator-describe-par-pre' => "A-j përmët d'avèj ël wikitest atual për la documentassion, sensa ch'a sia smonù an sla pàgina.",
	'validator-describe-par-language' => 'La lenga ant la qual smon-e le descrission',
	'validator-describe-listtype' => 'Lista ëd $1 element',
	'validator-describe-empty' => 'veuid',
	'validator-describe-required' => 'ciamà',
	'validator-describe-header-parameter' => 'Paràmetr',
	'validator-describe-header-aliases' => 'Alias',
	'validator-describe-header-type' => 'Sòrt',
	'validator-describe-header-default' => 'Për sòlit',
	'validator-describe-header-description' => 'Descrission',
	'validator-describe-parameters' => 'Paràmetr',
	'validator-describe-syntax' => 'Sintassi',
	'validator-describe-tagmin' => 'Estension ëd tichëtta con mach ij paràmetr obligatòri.',
	'validator-describe-tagmax' => 'Estension ëd tichëtta con tùit ij paràmetr.',
	'validator-describe-tagdefault' => 'Estension ëd tichëtta con tùit ij paràmetr an dovrand la notassion dë stàndard dij paràmetr.',
	'validator-describe-pfmin' => "Funsion ëd l'analisator sintàtich con mach ij paràmetr obligatòri.",
	'validator-describe-pfmax' => "Funsion ëd l'analisator sintàtich con tùit ij paràmetr.",
	'validator-describe-pfdefault' => "Funsion ëd l'analisator sintàtich con tùit ij paràmetr an dovrand la notassion dë stàndard dij paràmetr.",
	'validator-describe-autogen' => "Ël contnù dë sta session a l'é stàit generà an automàtich dal gancio \"descrive\" ëd l'analisator sintàtich ëd l'estension ëd Validator.",
	'validator_error_empty_argument' => 'Ël paràmetr $1 a peul pa avèj un valor veuid.',
	'validator_error_must_be_number' => 'Ël paràmetr $1 a peul mach esse un nùmer.',
	'validator_error_must_be_integer' => "Ël paràmetr $1 a peul mach esse n'antregh.",
	'validator-error-must-be-float' => 'Ël paràmetr $1 a peul mach esse un nùmer an vìrgola mòbil.',
	'validator_error_invalid_range' => 'Ël paràmetr $1 a deuv esse an tra $2 e $3.',
	'validator-error-invalid-regex' => 'Ël paràmetr $1 a dev cobiesse con sta espression regolar: $2.',
	'validator-error-invalid-length' => 'Ël paràmetr $1 a dev avèj na longheur ëd $2.',
	'validator-error-invalid-length-range' => 'Ël paràmetr $1 a dev avèj na longheur antra $2 e $3.',
	'validator_error_invalid_argument' => "Ël valor $1 a l'é pa bon për ël paràmetr $2.",
	'validator_list_error_empty_argument' => 'Ël paràmetr $1 a aceta pa dij valor veuid.',
	'validator_list_error_must_be_number' => 'Ël paràmetr $1 a peul mach conten-e dij nùmer.',
	'validator_list_error_must_be_integer' => "Ël paràmetr $1 a peul mach conten-e dj'antegr.",
	'validator-list-error-must-be-float' => 'Ël paràmetr $1 a peul mach conten-e dij nùmer con vìrgola.',
	'validator_list_error_invalid_range' => 'Tùit ij valor dël paràmetr $1 a deuvo esse tra $2 e $3.',
	'validator-list-error-invalid-regex' => 'Tùit ij valor dël paràmetr $1 a devo cobiesse con sta espression regolar: $2.',
	'validator_list_error_invalid_argument' => 'Un o pi valor dël paràmetr $1 a son pa bon.',
	'validator-list-error-accepts-only' => 'Un o pi valor për ël paràmetr $1 a son pa bon.
A aceta mach {{PLURAL:$3|sto valor|sti valor}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Un o pi valor për ël paràmetr $1 a son pa bon.
A aceta mach {{PLURAL:$3|sto valor|sti valor}}: $2 (e $4 {{PLURAL:$4|valor|valor}} sautà).',
	'validator_error_accepts_only' => 'Ël valor "$4" a l\'é pa bon për ël paràmetr $1. A aceta mach {{PLURAL:$3|sto valor-sì|sti valor-sì}}: $2.',
	'validator-error-accepts-only-omitted' => 'Ël valor "$2" a l\'é pa bon për ël paràmetr $1. A aceta mach sti valor: $3 (e ij valor pa butà $4).',
	'validator_list_omitted' => "{{PLURAL:$2|Ël valor|Ij valor}} $1 {{PLURAL:$2|a l'é|a son}} pa stàit butà.",
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'validator-error' => 'تېروتنه: $1',
	'validator-type-string' => 'متن',
	'validator-type-float' => 'شمېره',
	'validator-type-boolean' => 'هو/نه',
	'validator-type-char' => 'لوښه',
	'validator-type-title' => 'سرليک',
	'validator-type-float-list' => 'د شمېرو لړليک',
	'validator-type-boolean-list' => 'د هو/نه لړليک',
	'validator-type-char-list' => 'د لوښو لړليک',
	'validator-listerrors-errors' => 'تېروتنې',
	'validator-listerrors-normal' => 'نورمال',
	'validator-describe-empty' => 'تش',
	'validator-describe-header-default' => 'تلواليز',
	'validator-describe-header-description' => 'څرګندونه',
);

/** Portuguese (português)
 * @author Giro720
 * @author Hamilton Abreu
 * @author Lijealso
 * @author SandroHc
 * @author Waldir
 */
$messages['pt'] = array(
	'validator-desc' => 'O Serviço de Validação permite que, de forma simples, as outras extensões possam validar parâmetros das funções do analisador sintáctico e das extensões dos elementos HTML, definir valores por omissão e gerar mensagens de erro',
	'validator-warning' => 'Aviso: $1',
	'validator-error' => 'Erro: $1',
	'validator-fatal-error' => 'Erro fatal: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Foi detectado o seguinte erro sintáctico|Foram detectados os seguintes erros sintácticos}}:',
	'validator_warning_parameters' => '{{PLURAL:$1|Existe um erro sintáctico|Existem erros sintácticos}}.',
	'validator-warning-adittional-errors' => '... e {{PLURAL:$1|mais um problema|vários outros problemas}}.',
	'validator-error-omitted' => '{{PLURAL:$2|O valor "$1" foi omitido|Os valores "$1" foram omitidos}}.',
	'validator-error-problem' => 'Houve um problema com o parâmetro $1.',
	'validator_error_unknown_argument' => '$1 não é um parâmetro válido.',
	'validator_error_required_missing' => 'O parâmetro obrigatório $1 não foi fornecido.',
	'validator-error-override-argument' => 'Tentativa de sobrepor o parâmetro $1 (valor: $2) com o valor "$3"',
	'validator-type-string' => 'texto',
	'validator-type-integer' => 'número inteiro',
	'validator-type-float' => 'número',
	'validator-type-boolean' => 'sim/não',
	'validator-type-char' => 'carácter',
	'validator-type-title' => 'título',
	'validator-type-string-list' => 'lista de textos',
	'validator-type-integer-list' => 'lista de números inteiros',
	'validator-type-float-list' => 'lista de números',
	'validator-type-boolean-list' => 'lista de sim/não',
	'validator-type-char-list' => 'lista de caracteres',
	'validator-type-title-list' => 'lista de títulos',
	'validator-listerrors-errors' => 'Erros',
	'validator-listerrors-minor' => 'Menor',
	'validator-listerrors-low' => 'Baixo',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Alto',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => 'Lista os erros (e avisos) que ocorreram nos hooks do analisador sintáctico adicionados através do Serviço de Validação.
Da lista constarão apenas os hooks que apareçam acima do ponto na página onde está listerrors;
para obter todos os erros, coloque listerrors ao fundo da página.',
	'validator-listerrors-par-minseverity' => 'A gravidade mínima de um problema, para que este seja listado.',
	'validator-describe-description' => 'Gera documentação para um ou mais hooks do analisador sintáctico definidos através do Serviço de Validação.',
	'validator-describe-notfound' => 'Não existe nenhum hook para lidar com "$1".',
	'validator-describe-descriptionmsg' => "'''Descrição''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Nome alternativo|Nomes alternativos}}''': $1",
	'validator-describe-parserfunction' => 'Implementada apenas como função do analisador sintáctico.',
	'validator-describe-tagextension' => 'Implementada apenas como extensão de tag.',
	'validator-describe-bothhooks' => 'Implementada como função do analisador sintáctico e como extensão de tag.',
	'validator-describe-par-hooks' => 'Os hooks do analisador sintáctico para os quais será mostrada documentação.',
	'validator-describe-par-pre' => 'Permite obter o texto wiki real da documentação, sem que este seja formatado na página.',
	'validator-describe-par-language' => 'A língua em que as descrições serão apresentadas',
	'validator-describe-listtype' => 'Lista de $1 elementos',
	'validator-describe-empty' => 'vazio',
	'validator-describe-required' => 'necessário',
	'validator-describe-header-parameter' => 'Parâmetro',
	'validator-describe-header-aliases' => 'Nomes alternativos',
	'validator-describe-header-type' => 'Tipo',
	'validator-describe-header-default' => 'Por omissão',
	'validator-describe-header-description' => 'Descrição',
	'validator-describe-parameters' => 'Parâmetros',
	'validator-describe-syntax' => 'Sintaxe',
	'validator-describe-tagmin' => 'Extensão de tag só com os parâmetros obrigatórios.',
	'validator-describe-tagmax' => 'Extensão de tag com todos os parâmetros.',
	'validator-describe-tagdefault' => 'Extensão de tag com todos os parâmetros, usando a notação do parâmetro por omissão.',
	'validator-describe-pfmin' => 'Função do analisador sintáctico só com os parâmetros obrigatórios.',
	'validator-describe-pfmax' => 'Função do analisador sintáctico com todos os parâmetros.',
	'validator-describe-pfdefault' => 'Função do analisador sintáctico com todos os parâmetros, usando a notação do parâmetro por omissão.',
	'validator-describe-autogen' => 'O conteúdo desta secção foi gerado de forma automática pelo hook "describe" do analisador sintáctico, criado pela extensão Serviço de Validação.',
	'validator_error_empty_argument' => 'O parâmetro $1 não pode estar vazio.',
	'validator_error_must_be_number' => 'O parâmetro $1 só pode ser numérico.',
	'validator_error_must_be_integer' => 'O parâmetro $1 só pode ser um número inteiro.',
	'validator_error_must_be_title' => 'O parâmetro $1 só pode ser um nome válido de página wiki.',
	'validator_error_must_be_existing_title' => 'O parâmetro $1 só pode ser um nome de uma página wiki já existente.',
	'validator-error-must-be-float' => 'O parâmetro $1 só pode ser um número de vírgula flutuante.',
	'validator_error_invalid_range' => 'O parâmetro $1 tem de ser entre $2 e $3.',
	'validator-error-invalid-regex' => 'O parâmetro $1 deve corresponder à expressão regular: $2.',
	'validator-error-invalid-length' => 'O parâmetro $1 tem de ter um comprimento de $2.',
	'validator-error-invalid-length-range' => 'O parâmetro $1 tem de ter um comprimento entre $2 e $3.',
	'validator_error_invalid_argument' => 'O valor $1 não é válido para o parâmetro $2.',
	'validator_list_error_empty_argument' => 'O parâmetro $1 não pode estar vazio.',
	'validator_list_error_must_be_number' => 'O parâmetro $1 só pode ser numérico.',
	'validator_list_error_must_be_integer' => 'O parâmetro $1 só pode ser um número inteiro.',
	'validator-list-error-must-be-float' => 'O parâmetro $1 só pode conter valores de vírgula flutuante.',
	'validator_list_error_invalid_range' => 'Todos os valores do parâmetro $1 têm de ser entre $2 e $3.',
	'validator-list-error-invalid-regex' => 'Todos os valores do parâmetro $1 devem corresponder à expressão regular: $2.',
	'validator_list_error_invalid_argument' => 'Um ou mais valores do parâmetro $1 são inválidos.',
	'validator-list-error-accepts-only' => 'Um ou mais valores para o parâmetro $1 são inválidos.
Só {{PLURAL:$3|é aceite este valor|são aceites estes valores}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Um ou mais valores para o parâmetro $1 são inválidos.
Só {{PLURAL:$3|é aceite este valor|são aceites estes valores}}: $2 (e $4 {{PLURAL:$4|valor omitido|valores omitidos}}).',
	'validator_error_accepts_only' => 'O valor "$4" não é válido para o parâmetro $1. O parâmetro só aceita {{PLURAL:$3|este valor|estes valores}}: $2.',
	'validator-error-accepts-only-omitted' => 'O valor $2 não é válido para o parâmetro $1.
Só {{PLURAL:$5|é aceite este valor|são aceites estes valores}}: $3 (e $4 {{PLURAL:$4|valor omitido|valores omitidos}}).',
	'validator_list_omitted' => '{{PLURAL:$2|O valor $1 foi omitido|Os valores $1 foram omitidos}}.',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Giro720
 * @author Jaideraf
 * @author Luckas Blade
 */
$messages['pt-br'] = array(
	'validator-desc' => 'Fornece suporte a manipulação de parâmetros genéricos para outras extensões',
	'validator-warning' => 'Atenção: $1',
	'validator-error' => 'Erro: $1',
	'validator-fatal-error' => 'Erro crítico: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Foi detectado o seguinte erro sintático|Foram detectados os seguintes erros sintáticos}}:',
	'validator_warning_parameters' => '{{PLURAL:$1|Existe um erro|Existem erros}} em sua sintaxe.',
	'validator-warning-adittional-errors' => '... e {{PLURAL:$1|mais um problema|vários outros problemas}}.',
	'validator-error-omitted' => '{{PLURAL:$2|O valor "$1" foi omitido|Os valores "$1" foram omitidos}}.',
	'validator-error-problem' => 'Houve um problema com o parâmetro $1.',
	'validator_error_unknown_argument' => '$1 não é um parâmetro válido.',
	'validator_error_required_missing' => 'O parâmetro obrigatório "$1" não foi fornecido.',
	'validator-error-override-argument' => 'Tentativa de sobrepor o parâmetro $1 (valor: $2) com o valor "$3"',
	'validator-type-string' => 'texto',
	'validator-type-integer' => 'número inteiro',
	'validator-type-float' => 'número',
	'validator-type-boolean' => 'sim/não',
	'validator-type-char' => 'caractere',
	'validator-type-title' => 'título',
	'validator-type-string-list' => 'lista de textos',
	'validator-type-integer-list' => 'lista de números inteiros',
	'validator-type-float-list' => 'lista de números',
	'validator-type-boolean-list' => 'lista de sim/não',
	'validator-type-char-list' => 'lista de caracteres',
	'validator-type-title-list' => 'lista de títulos',
	'validator-listerrors-errors' => 'Erros',
	'validator-listerrors-minor' => 'Menor',
	'validator-listerrors-low' => 'Baixo',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Alto',
	'validator-listerrors-fatal' => 'Fatal',
	'validator-listerrors-description' => 'Lista os erros (e avisos) que ocorreram nos hooks do analisador sintático adicionados através da extensão Validator.
Constarão na lista apenas os hooks adicionados acima de onde estão inseridos os listerrors;
para obter todos os erros, coloque listerrors ao final da página.',
	'validator-listerrors-par-minseverity' => 'A gravidade mínima de um problema para que ele seja listado.',
	'validator-describe-description' => 'Gera a documentação para um ou mais hooks do analisador sintático definidos através da extensão Validator.',
	'validator-describe-notfound' => 'Não existe qualquer hook para lidar com "$1".',
	'validator-describe-descriptionmsg' => "'''Descrição''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Nome alternativo|Nomes alternativos}}''': $1",
	'validator-describe-parserfunction' => 'Implementado apenas como parser function.',
	'validator-describe-tagextension' => 'Implementado apenas como extensão de tag.',
	'validator-describe-bothhooks' => 'Implementado tanto como parser function e como extensão de tag.',
	'validator-describe-par-hooks' => 'Os hooks do analisador sintático para os quais serão mostradas a documentação.',
	'validator-describe-par-pre' => 'Permite obter o wikitexto real da documentação sem que ele esteja formatado na página.',
	'validator-describe-par-language' => 'A língua em que as descrições serão apresentadas',
	'validator-describe-listtype' => 'Lista de $1 itens',
	'validator-describe-empty' => 'vazio',
	'validator-describe-required' => 'obrigatório',
	'validator-describe-header-parameter' => 'Parâmetro',
	'validator-describe-header-aliases' => 'Nomes alternativos',
	'validator-describe-header-type' => 'Tipo',
	'validator-describe-header-default' => 'Padrão',
	'validator-describe-header-description' => 'Descrição',
	'validator-describe-parameters' => 'Parâmetros',
	'validator-describe-syntax' => 'Sintaxe',
	'validator-describe-tagmin' => 'Extensão de tag só com os parâmetros obrigatórios.',
	'validator-describe-tagmax' => 'Extensão de tag com todos os parâmetros.',
	'validator-describe-tagdefault' => 'Extensão de tag com todos os parâmetros utilizando a notação de parâmetro padrão.',
	'validator-describe-pfmin' => 'Parser function só com os parâmetros obrigatórios.',
	'validator-describe-pfmax' => 'Parser function com todos os parâmetros.',
	'validator-describe-pfdefault' => 'Parser function com todos os parâmetros utilizando a notação de parâmetro padrão.',
	'validator-describe-autogen' => 'O conteúdo desta seção foi gerado de forma automática pelo hook "describe" do analisador sintático criado pela extensão Validator.',
	'validator_error_empty_argument' => 'O parâmetro $1 não pode estar vazio.',
	'validator_error_must_be_number' => 'O parâmetro $1 só pode ser um número.',
	'validator_error_must_be_integer' => 'O parâmetro $1 só pode ser um número inteiro.',
	'validator_error_must_be_title' => 'O parâmetro $1 só pode ser um nome válido de página wiki.',
	'validator_error_must_be_existing_title' => 'O parâmetro $1 só pode ser um nome de página wiki existente.',
	'validator-error-must-be-float' => 'O parâmetro $1 deve ser um número de ponto flutuante.',
	'validator_error_invalid_range' => 'O parâmetro $1 precisa estar entre $2 e $3.',
	'validator-error-invalid-regex' => 'O parâmetro $1 deve corresponder à expressão regular: $2.',
	'validator-error-invalid-length' => 'O parâmetro $1 deve ter um comprimento de $2.',
	'validator-error-invalid-length-range' => 'O parâmetro $1 precisa ter um comprimento entre $2 e $3.',
	'validator_error_invalid_argument' => 'O valor $1 não é válido para o parâmetro $2.',
	'validator_list_error_empty_argument' => 'O parâmetro $1 não pode estar vazio.',
	'validator_list_error_must_be_number' => 'O parâmetro $1 só pode conter números.',
	'validator_list_error_must_be_integer' => 'O parâmetro $1 só pode conter números inteiros.',
	'validator_list_error_must_be_title' => 'O parâmetro $1 só pode conter nomes válidos de páginas wiki.',
	'validator_list_error_must_be_existing_title' => 'O parâmetro $1 só pode conter nomes de páginas wiki existentes.',
	'validator-list-error-must-be-float' => 'O parâmetro $1 só pode conter valores de ponto flutuante.',
	'validator_list_error_invalid_range' => 'Todos os valores do parâmetro $1 precisam estar entre $2 e $3.',
	'validator-list-error-invalid-regex' => 'Todos os valores do parâmetro $1 devem corresponder à expressão regular: $2.',
	'validator_list_error_invalid_argument' => 'Um ou mais valores do parâmetro $1 são inválidos.',
	'validator-list-error-accepts-only' => 'Um ou mais valores para o parâmetro $1 são inválidos. Só {{PLURAL:$3|é permitido este valor|são permitidos estes valores}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Um ou mais valores para o parâmetro $1 são inválidos. Só {{PLURAL:$3|é permitido este valor|são permitidos estes valores}}: $2 (e $4 {{PLURAL:$4|valor omitido|valores omitidos}}).',
	'validator_error_accepts_only' => 'O valor "$4" não é válido para o parâmetro $1. Esse parâmetro só aceita {{PLURAL:$3|este valor|estes valores}}: $2.',
	'validator-error-accepts-only-omitted' => 'O valor "$2" não é válido para o parâmetro $1. Só {{PLURAL:$5|é permitido este valor|são permitidos estes valores}}: $3 (e $4 {{PLURAL:$4|valor omitido|valores omitidos}}).',
	'validator_list_omitted' => '{{PLURAL:$2|O valor $1 foi omitido|Os valores $1 foram omitidos}}.',
	'validator-message-nodesc' => 'Nenhuma descrição fornecida',
);

/** Romanian (română)
 * @author Minisarm
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'validator-warning' => 'Avertisment: $1',
	'validator-error' => 'Eroare: $1',
	'validator-fatal-error' => 'Eroare fatală: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Următoarea eroare a fost detectată|Următoarele erori au fost detectate}} în sintaxa dumneavoastră:',
	'validator_warning_parameters' => 'Există {{PLURAL:$1|o eroare|erori}} în sintaxa dumneavoastră.',
	'validator-warning-adittional-errors' => '... și încă {{PLURAL:$1|o problemă|alte câteva probleme}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Valoarea „$1” a fost omisă|Valorile „$1” au fost omise}}.',
	'validator-error-problem' => 'S-a produs o problemă cu parametrul $1.',
	'validator_error_unknown_argument' => '$1 nu este un parametru valid.',
	'validator_error_required_missing' => 'Parametrul solicitat „$1” nu este furnizat.',
	'validator-error-override-argument' => 'S-a încercat suprascrierea parametrului $1 (valoare: $2) cu valoarea „$3”',
	'validator-type-string' => 'text',
	'validator-type-integer' => 'număr întreg',
	'validator-type-float' => 'număr',
	'validator-type-boolean' => 'da/nu',
	'validator-type-char' => 'caracter',
	'validator-type-title' => 'titlu',
	'validator-type-string-list' => 'listă de texte',
	'validator-type-integer-list' => 'listă de numere întregi',
	'validator-type-float-list' => 'listă de numere',
	'validator-type-boolean-list' => 'listă de valori da/nu',
	'validator-type-char-list' => 'listă de caractere',
	'validator-type-title-list' => 'listă de titluri',
	'validator-listerrors-errors' => 'Erori',
	'validator-listerrors-minor' => 'Minoră',
	'validator-describe-descriptionmsg' => "'''Descriere''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Alias|Aliasuri}}''': $1",
	'validator-describe-listtype' => 'Listă de elemente „$1”',
	'validator-describe-empty' => 'fără conținut',
	'validator-describe-required' => 'necesar',
	'validator-describe-header-parameter' => 'Parametru',
	'validator-describe-header-aliases' => 'Aliasuri',
	'validator-describe-header-type' => 'Tip',
	'validator-describe-header-default' => 'Implicit',
	'validator-describe-header-description' => 'Descriere',
	'validator-describe-parameters' => 'Parametri',
	'validator-describe-syntax' => 'Sintaxă',
	'validator_error_empty_argument' => 'Parametrul $1 nu poate avea o valoare goală.',
	'validator_error_must_be_number' => 'Parametrul $1 poate fi doar un număr.',
	'validator_error_must_be_integer' => 'Parametrul $1 poate fi doar un număr întreg.',
	'validator-message-nodesc' => 'Nicio descriere furnizată',
);

/** Russian (русский)
 * @author Aleksandrit
 * @author Eleferen
 * @author Haffman
 * @author Lockal
 * @author MaxSem
 * @author McDutchie
 * @author Van de Bugger
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'validator-desc' => 'Валидатор предоставляет другим расширениям возможности проверки параметров функций парсера и тегов, установки значения по умолчанию и создания сообщения об ошибках',
	'validator-warning' => 'Внимание: $1',
	'validator-error' => 'Ошибка: $1',
	'validator-fatal-error' => 'Критическая ошибка: $1',
	'validator_error_parameters' => 'В вашем синтаксисе {{PLURAL:$1|обнаружена следующая ошибка|обнаружены следующие ошибки}}:',
	'validator_warning_parameters' => 'В вашем синтаксисе {{PLURAL:$1|имеется ошибка|имеются ошибки}}.',
	'validator-warning-adittional-errors' => '… и {{PLURAL:$1|ещё одна проблема|ещё несколько проблем}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Значение «$1» пропущено|Значения «$1» пропущены}}.',
	'validator-error-problem' => 'Обнаружена проблема с параметром «$1».',
	'validator_error_unknown_argument' => '$1 не является допустимым параметром.',
	'validator_error_required_missing' => 'Не указан обязательный параметр $1.',
	'validator-error-override-argument' => 'Попытка переопределения параметра $1 (значение: $2) значением «$3»',
	'validator-type-string' => 'текст',
	'validator-type-integer' => 'целое число',
	'validator-type-float' => 'число',
	'validator-type-boolean' => 'да/нет',
	'validator-type-char' => 'символ',
	'validator-listerrors-errors' => 'Ошибки',
	'validator-listerrors-minor' => 'Незначительная',
	'validator-listerrors-low' => 'Низкая',
	'validator-listerrors-normal' => 'Обычная',
	'validator-listerrors-high' => 'Высокая',
	'validator-listerrors-fatal' => 'Фатальная',
	'validator-listerrors-description' => 'Перечисляет ошибки (и предупреждения), произошедшие в обработчиках парсера, добавленных с помощью Validator.
Выводятся только обработчики парсера, добавленные выше вставленно listerrors.
Поместите listerrors в самый конец страницы, чтобы получить все ошибки.',
	'validator-listerrors-par-minseverity' => 'Минимальная серьезность вопроса, для включения в список.',
	'validator-describe-description' => 'Создает документацию для одного или нескольких обработчиков парсера, по пределениям Validator.',
	'validator-describe-notfound' => 'Не существует обработчика парсера для «$1».',
	'validator-describe-descriptionmsg' => "'''Описание''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Псевдоним|Псевдонимы}}''': $1",
	'validator-describe-parserfunction' => 'Реализована только функция парсера.',
	'validator-describe-tagextension' => 'Реализовано только как дополнительный тег.',
	'validator-describe-bothhooks' => 'Реализовано и функция парсера, и дополнительный тег.',
	'validator-describe-par-hooks' => 'Обработчик парсера, для которого отображать документацию.',
	'validator-describe-par-pre' => 'Позволяет получить фактический викитекст для документации, без показа на странице.',
	'validator-describe-par-language' => 'Язык для отображения описания',
	'validator-describe-listtype' => 'Перечень пунктов $1',
	'validator-describe-empty' => 'пусто',
	'validator-describe-required' => 'требуется',
	'validator-describe-header-parameter' => 'Параметр',
	'validator-describe-header-aliases' => 'Псевдонимы',
	'validator-describe-header-type' => 'Тип',
	'validator-describe-header-default' => 'По умолчанию',
	'validator-describe-header-description' => 'Описание',
	'validator-describe-parameters' => 'Параметры',
	'validator-describe-syntax' => 'Синтаксис',
	'validator-describe-tagmin' => 'Теговое расширение, имеющее только обязательные параметры.',
	'validator-describe-tagmax' => 'Теговое расширение со всеми параметрами.',
	'validator-describe-tagdefault' => 'Теговое расширение со всеми параметрами, использованием параметров по умолчанию.',
	'validator-describe-pfmin' => 'Парсерная функция, имеющая только обязательные параметры.',
	'validator-describe-pfmax' => 'Парсерная функция со всеми параметрами.',
	'validator-describe-pfdefault' => 'Парсерная функция со всеми параметрами, использованием параметров по умолчанию.',
	'validator-describe-autogen' => 'Содержимое этого раздела было автоматически создано парсерным обработчиком «describe» расширения Validator.',
	'validator_error_empty_argument' => 'Параметр «$1» не может принимать пустое значение.',
	'validator_error_must_be_number' => 'Значением параметра «$1» могут быть только числа.',
	'validator_error_must_be_integer' => 'Параметр $1 может быть только целым числом.',
	'validator-error-must-be-float' => 'Параметр $1 может быть числом с плавающей точкой.',
	'validator_error_invalid_range' => 'Параметр $1 должен быть от $2 до $3.',
	'validator-error-invalid-regex' => 'Параметр «$1» должен соответствовать регулярному выражению «$2».',
	'validator-error-invalid-length' => 'Параметр $1 должен иметь длину $2.',
	'validator-error-invalid-length-range' => 'Параметр $1 должен иметь длину от $2 до $3.',
	'validator_error_invalid_argument' => 'Значение $1 не является допустимым параметром $2',
	'validator_list_error_empty_argument' => 'Параметр $1 не может принимать пустые значения.',
	'validator_list_error_must_be_number' => 'Параметр $1 может содержать только цифры.',
	'validator_list_error_must_be_integer' => 'Параметр $1 может содержать только целые числа.',
	'validator-list-error-must-be-float' => 'Параметр «$1» может содержать только числа с плавающей точкой.',
	'validator_list_error_invalid_range' => 'Все значения параметра $1 должна находиться в диапазоне от $2 до $3.',
	'validator-list-error-invalid-regex' => 'Все значения параметра «$1» должны соответствовать регулярноve выражению «$2».',
	'validator_list_error_invalid_argument' => 'Одно или несколько значений параметра $1 ошибочны.',
	'validator-list-error-accepts-only' => 'Ошибочны один или несколько значений параметра $1.
{{PLURAL:$3|Допустимо только следующее значение|Допустимы только следующие значения}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Ошибочны один или несколько значений параметра $1.
{{PLURAL:$3|Допустимо только следующее значение|Допустимы только следующие значения}}: $2 (и $4 {{PLURAL:$4|опущенное значение|опущенных значения|опущенных значений}}).',
	'validator_error_accepts_only' => 'Значение «$4» не подходит для параметра $1. Оно может принимать только {{PLURAL:$3|следующее значение|следующие значения}}: $2.',
	'validator-error-accepts-only-omitted' => 'Значение «$2» не подходит для параметра $1.
{{PLURAL:$5|Допускается только значение|Допускаются только значения}}: $3 (и $4 {{PLURAL:$4|пропущенное значение|пропущенных значения|пропущенных значений}}).',
	'validator_list_omitted' => '{{PLURAL:$2|Значение $1 было пропущено|Значения $1 были пропущены}}.',
);

/** Rusyn (русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'validator-type-string' => 'текст',
	'validator-listerrors-errors' => 'Хыбы',
);

/** Sinhala (සිංහල)
 * @author Calcey
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'validator-desc' => 'තහවුරු කරන්නා ටැග් දිඟුවන් හා parser ශ්‍රිතවල පරාමිතීන් තහවුරු කිරීමට අනෙක් දිඟුවන් සඳහා පහසු ක්‍රමයක් සපයයි,පෙරනිමි අගයන් පිහිටුවීම හා දෝෂ පණිවුඩ ජනනය කිරීම ද සිදු කරයි',
	'validator-warning' => 'අවවාදය: $1',
	'validator-error' => 'දෝෂය: $1',
	'validator-fatal-error' => 'මාරාන්තික දෝෂය: $1',
	'validator_error_parameters' => 'ඔබේ වාග් රීතිය මඟින් පහත {{PLURAL:$1|දෝෂය|දෝෂයන්}} අනාවරණය කරනු ලැබ ඇත', # Fuzzy
	'validator_error_unknown_argument' => '$1 වලංගු පරාමිතියක් නොවේ.',
	'validator_error_required_missing' => 'අවශ්‍ය වන $1 පරාමිතිය සපයා නොමැත.',
	'validator-type-string' => 'පෙළ',
	'validator-type-integer' => 'සම්පූර්ණ අංකය',
	'validator-type-float' => 'අංකය',
	'validator-type-boolean' => 'ඔව්/නැහැ',
	'validator-type-char' => 'අක්ෂරය',
	'validator-type-title' => 'ශීර්ෂය',
	'validator-type-string-list' => 'පාඨ ලැයිස්තුව',
	'validator-type-float-list' => 'අංක ලැයිස්තුව',
	'validator-type-char-list' => 'අක්ෂර ලැයිස්තුව',
	'validator-type-title-list' => 'ශීර්ෂ ලැයිස්තුව',
	'validator-listerrors-errors' => 'දෝෂ',
	'validator-listerrors-minor' => 'සුළු',
	'validator-listerrors-low' => 'අවම',
	'validator-listerrors-normal' => 'සාමාන්‍ය',
	'validator-listerrors-high' => 'ඉහළ',
	'validator-listerrors-fatal' => 'මාරාන්තික',
	'validator-describe-descriptionmsg' => "'''විස්තරය''': $1",
	'validator-describe-empty' => 'හිස්',
	'validator-describe-required' => 'අවශ්‍යයි',
	'validator-describe-header-parameter' => 'පරාමිතිය',
	'validator-describe-header-type' => 'වර්ගය',
	'validator-describe-header-default' => 'සාමාන්‍ය',
	'validator-describe-header-description' => 'විස්තරය',
	'validator-describe-parameters' => 'පරාමිතීන්',
	'validator-describe-syntax' => 'වාක්‍ය වින්‍යාසය',
	'validator_error_empty_argument' => '$1 පරාමිතියට හිස් අගයක් තිබිය නොහැක.',
	'validator_error_must_be_number' => '$1 පරාමිතිය විය හැක්කේ ඉලක්කමක් පමණි.',
	'validator_error_invalid_range' => '$1 පරාමිතිය $2 හා $3 අතර විය යුතුය.',
	'validator_error_invalid_argument' => '$2 පරාමිතිය සඳහා $1 අගය වලංගු නොවේ.',
	'validator_error_accepts_only' => '$1 පරාමිතිය විසින් පිළිගනු ලබන්නේ {{PLURAL:$3|මෙම අගය|මෙම අගයන්}}: $2 පමණි.', # Fuzzy
	'validator-message-nodesc' => 'විස්තරයක් සපයා නොමැත',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 */
$messages['sr-ec'] = array(
	'validator-listerrors-severity-message' => '($1) $2',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 */
$messages['sr-el'] = array(
	'validator-listerrors-severity-message' => '($1) $2',
);

/** Swedish (svenska)
 * @author Cybjit
 * @author Fluff
 * @author Martinwiss
 * @author Ozp
 * @author Per
 * @author Sertion
 */
$messages['sv'] = array(
	'validator-desc' => 'Valideraren skapar ett smidigt sätt för andra tillägg att validera olika parserfunktioners parametrar och taggar, sätta standardvärden för tilläggen samt att generera felmeddelanden',
	'validator-warning' => 'Varning: $1',
	'validator-error' => 'Fel: $1',
	'validator-fatal-error' => 'Kritiskt fel: $1',
	'validator_error_parameters' => 'Följande {{PLURAL:$1|fel|fel}} har upptäckts i din syntax:',
	'validator_warning_parameters' => 'Det finns {{PLURAL:$1|ett|flera}} fel i din syntax.',
	'validator-warning-adittional-errors' => '
... och {{PLURAL:$1|ett problem till|fler problem}}.',
	'validator-error-omitted' => '{{PLURAL:$2|Värdet "$1" har|Värdena"$1" har}} uteslutits',
	'validator-error-problem' => 'Ett problem uppstod med parametern $1.',
	'validator_error_unknown_argument' => '$1 är inte en giltig paramter.',
	'validator_error_required_missing' => 'Den nödvändiga parametern $1 har inte angivits.',
	'validator-error-override-argument' => 'Försökte skriva över parametern $1 (värde: $2) med värde "$3"',
	'validator-type-string' => 'text',
	'validator-type-integer' => 'helt nummer',
	'validator-type-float' => 'nummer',
	'validator-type-boolean' => 'ja/nej',
	'validator-type-char' => 'tecken',
	'validator-type-title' => 'titel',
	'validator-type-string-list' => 'listor med texter',
	'validator-type-integer-list' => 'listor med heltal',
	'validator-type-float-list' => 'listor med siffror',
	'validator-type-boolean-list' => 'listor med ja/nej',
	'validator-type-char-list' => 'listor med tecken',
	'validator-type-title-list' => 'listor med rubriker',
	'validator-listerrors-errors' => 'Fel',
	'validator-listerrors-minor' => 'Smärre',
	'validator-listerrors-low' => 'Låg',
	'validator-listerrors-normal' => 'Normal',
	'validator-listerrors-high' => 'Hög',
	'validator-listerrors-fatal' => 'Kritisk',
	'validator-describe-listtype' => 'Lista med "$1"-element',
	'validator-describe-empty' => 'tom',
	'validator-describe-required' => 'behövs',
	'validator-describe-header-parameter' => 'Parameter',
	'validator-describe-header-aliases' => 'Alias',
	'validator-describe-header-type' => 'Typ',
	'validator-describe-header-default' => 'Förvalt',
	'validator-describe-header-description' => 'Beskrivning',
	'validator-describe-parameters' => 'Parametrar',
	'validator-describe-syntax' => 'Syntax',
	'validator_error_empty_argument' => 'Parametern $1 kan inte lämnas tom.',
	'validator_error_must_be_number' => 'Parameter $1 måste bestå av ett tal.',
	'validator_error_must_be_integer' => 'Parametern $1 måste vara ett heltal.',
	'validator_error_invalid_range' => 'Parameter $1 måste vara i mellan $2 och $3.',
	'validator_error_invalid_argument' => 'Värdet $1 är inte giltigt som parameter $2.',
	'validator_list_error_empty_argument' => 'Parameter $1 accepterar inte tomma värden.',
	'validator_list_error_must_be_number' => 'Parameter $1 får endast innehålla siffror.',
	'validator_list_error_must_be_integer' => 'Parameter $1 får endast innehålla heltal.',
	'validator_list_error_invalid_range' => 'Alla värden av parameter $1 måste vara mellan $2 och $3.',
	'validator_list_error_invalid_argument' => 'Ett eller flera värden av parameter $1 är ogiltiga.',
	'validator_error_accepts_only' => 'Värdet "$4" är inte giltigt för parametern $1. Den accepterar bara {{PLURAL:$3|detta värde|ett av dessa värden}}: $2.',
	'validator_list_omitted' => '{{PLURAL:$2|Värdet|Värdena}} $1 har blivit {{PLURAL:$2|utelämnat|utelämnade}}.',
);

/** Tamil (தமிழ்)
 * @author Karthi.dr
 * @author Shanmugamp7
 * @author மதனாஹரன்
 */
$messages['ta'] = array(
	'validator-warning' => 'எச்சரிக்கை: $1',
	'validator-error' => 'பிழை: $1',
	'validator-type-string' => 'உரை',
	'validator-type-integer' => 'முழு எண்',
	'validator-type-float' => 'எண்',
	'validator-type-boolean' => 'ஆம்/இல்லை',
	'validator-type-char' => 'வரியுரு',
	'validator-type-title' => 'தலைப்பு',
	'validator-type-string-list' => 'உரைகளின் பட்டியல்',
	'validator-type-integer-list' => 'முழு எண்களின் பட்டியல்',
	'validator-type-float-list' => 'எண்களின் பட்டியல்',
	'validator-type-boolean-list' => 'ஆம்/இல்லை களின் பட்டியல்',
	'validator-type-char-list' => 'எழுத்துகளை பட்டியலிடு',
	'validator-type-title-list' => 'தலைப்புகளின் பட்டியல்',
	'validator-listerrors-errors' => 'பிழைகள்',
	'validator-listerrors-minor' => 'சிறிய',
	'validator-listerrors-low' => 'குறைவு',
	'validator-listerrors-normal' => 'சாதரணம்',
	'validator-listerrors-high' => 'அதிகம்',
	'validator-describe-listtype' => '$1 உருப்படிகளின் பட்டியல்',
	'validator-describe-empty' => 'காலி',
	'validator-describe-required' => 'தேவைபடுகிறது',
	'validator-describe-header-parameter' => 'அளபுரு',
	'validator-describe-header-type' => 'வகை',
	'validator-describe-header-default' => 'இயல்புநிலை',
	'validator-describe-header-description' => 'விளக்கம்',
	'validator-describe-parameters' => 'அளபுருக்கள்',
	'validator-describe-syntax' => 'வழிமுறைத் தொடரமைப்பு',
	'validator-message-nodesc' => 'விவரணமேதும் வழங்கப்படவில்லை',
);

/** Telugu (తెలుగు)
 * @author Ravichandra
 * @author Veeven
 */
$messages['te'] = array(
	'validator-warning' => 'హెచ్చరిక: $1',
	'validator-error' => 'పొరపాటు: $1',
	'validator_error_unknown_argument' => '$1 అనేది సరైన పరామితి కాదు.',
	'validator_error_required_missing' => 'తప్పకుండా కావాల్సిన $1 పరామితిని ఇవ్వలేదు.',
	'validator-type-string' => 'పాఠ్యం',
	'validator-type-integer' => 'పూర్ణ సంఖ్య',
	'validator-type-float' => 'సంఖ్య',
	'validator-type-boolean' => 'అవును/కాదు',
	'validator-type-title' => 'శీర్షిక',
	'validator-listerrors-errors' => 'పొరపాట్లు',
	'validator-describe-descriptionmsg' => "'''వివరణ''': $1",
	'validator-describe-required' => 'తప్పనిసరి',
	'validator-describe-header-aliases' => 'మారుపేర్లు',
	'validator-describe-header-type' => 'రకం',
	'validator-describe-header-default' => 'అప్రమేయం',
	'validator-describe-header-description' => 'వివరణ',
	'validator-describe-parameters' => 'పరామితులు',
	'validator_error_empty_argument' => '$1 పరామితి ఖాళీగా ఉండకూడదు',
	'validator_error_must_be_number' => '$1 పరామితి ఖచ్చితంగా ఓ సంఖ్య అయిఉండాలి',
	'validator_error_must_be_integer' => '$1 పరామితి ఒక పూర్ణసంఖ్య అయిఉండాలి',
	'validator_error_invalid_range' => '$1 పరామితి $2,  $3 మద్యలో ఉండాలి.',
	'validator_error_invalid_argument' => '$2 పరామితి కోసం $1 విలువ సరైంది కాదు',
	'validator_list_error_must_be_number' => '$1 పరామితి ఖచ్చితంగా సంఖ్యలను మాత్రమే కలిగివుండాలి.',
	'validator_list_error_must_be_integer' => '$1 పరామితి పూర్ణసంఖ్యలను మాత్రమే కలిగివుండాలి.',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'validator-desc' => 'Nagbibigay ng panlahatang magtangkilik na paghawak sa ibang mga dugtong',
	'validator-warning' => 'Babala: $1',
	'validator-error' => 'Kamalian: $1',
	'validator-fatal-error' => 'Masidhing kamalian: $1',
	'validator_error_parameters' => 'Ang sumusunod na {{PLURAL:$1|kamalian|mga kamalian}} ay napansin sa iyong sintaks:',
	'validator_warning_parameters' => 'May {{PLURAL:$1|mali|mga mali}} sa sintaks mo.',
	'validator-warning-adittional-errors' => '... at {{PLURAL:$1|isa pang paksa|maramihan pang mga paksa}}.',
	'validator-error-omitted' => 'Ang {{PLURAL:$2|halagang "$1" ay|mga halaga "$1" ay}} natanggal na.',
	'validator-error-problem' => 'Nagkaroon ng suliranin sa parametrong $1.',
	'validator_error_unknown_argument' => 'Ang $1 ay isang hindi tanggap na parametro.',
	'validator_error_required_missing' => 'Hindi ibinigay ang kailangang parametro na $1.',
	'validator-error-override-argument' => 'Sinubukang pangingibabawan ang parametrong $1 (halaga: $2) ng halagang "$3"',
	'validator-type-string' => 'teksto',
	'validator-type-integer' => 'buong bilang',
	'validator-type-float' => 'bilang',
	'validator-type-boolean' => 'oo/hindi',
	'validator-type-char' => 'panitik',
	'validator-type-title' => 'pamagat',
	'validator-type-string-list' => 'lista ng mga teksto',
	'validator-type-integer-list' => 'lista ng mga buumbilang',
	'validator-type-float-list' => 'lista ng mga bilang',
	'validator-type-boolean-list' => 'lista ng oo/hindi',
	'validator-type-char-list' => 'lista ng mga panitik',
	'validator-type-title-list' => 'lista ng mga pamagat',
	'validator-listerrors-errors' => 'Mga kamalian',
	'validator-listerrors-severity-message' => '($1) $2',
	'validator-listerrors-minor' => 'Munti',
	'validator-listerrors-low' => 'Mababa',
	'validator-listerrors-normal' => 'Karaniwan',
	'validator-listerrors-high' => 'Mataas',
	'validator-listerrors-fatal' => 'Nakamamatay',
	'validator-listerrors-description' => 'Naglilista ng mga kamalian (at mga babala) na naganap sa mga kawit na pambanghay na idinagdag sa pamamagitan ng Validator (Tagapagpatunay).
Naglilista lang ng mga kawit na pambanghay na idinagdag sa itaas kung saan isiningit ang listerrors (mga kamalian sa lista);
ilagay ang listerrrors (mga kamalian sa lista) doon o malapit sa ilalim ng pahina upang makuha ang lahat ng mga kamalian.',
	'validator-listerrors-par-minseverity' => 'Ang pinakamaliit na kalubhaan ng isang paksa para ito maitala.',
	'validator-describe-description' => 'Bumbuo ng dokumentasyon para sa isa o mahigit pang mga kalawit na pambanghay na binigyan ng kahulugan sa pamamagitan ng Tagapagpatunay.',
	'validator-describe-notfound' => 'Walang kawit ng pambanghay na humahawak sa "$1".',
	'validator-describe-descriptionmsg' => "'''Paglalarawan''': $1",
	'validator-describe-aliases' => "'''{{PLURAL:$2|Taguri|Mga taguri}}''': $1",
	'validator-describe-parserfunction' => 'Ipinatupad lamang bilang tungkuling pambanghay.',
	'validator-describe-tagextension' => 'Ipinatupad lamang bilang dugtong ng tatak.',
	'validator-describe-bothhooks' => 'Ipinatupad bilang kapwa tungkulin ng pambanghay at bilang dugtong ng tatak.',
	'validator-describe-par-hooks' => 'Ang mga kalawit ng pambanghay para kung saan ipapakita ang dokumentasyon.',
	'validator-describe-par-pre' => 'Nagpapahintulot sa iyo upang makuha ang talagang teksto ng wiki para sa dokumentasyon, na hindi ito inihaharap sa ibabaw ng pahina.',
	'validator-describe-par-language' => 'Ang wika na pagpapakitaan ng mga paglalarawan',
	'validator-describe-listtype' => 'Tala ng $1 mga bagay',
	'validator-describe-empty' => 'walang laman',
	'validator-describe-required' => 'kailangan',
	'validator-describe-header-parameter' => 'parametro',
	'validator-describe-header-aliases' => 'Mga taguri',
	'validator-describe-header-type' => 'Uri',
	'validator-describe-header-default' => 'Likas na nakatakda',
	'validator-describe-header-description' => 'Paglalarawan',
	'validator-describe-parameters' => 'Mga parametro',
	'validator-describe-syntax' => 'Palaugnayan',
	'validator-describe-tagmin' => 'Tatakan ang mga dugtong na may kinakailangang mga parametro lamang.',
	'validator-describe-tagmax' => 'Dugtong ng tatak na mayroon ng lahat ng mga parametro.',
	'validator-describe-tagdefault' => 'Dugtong ng tatak na mayroon ng lahat ng mga parametro na ginagamit ang likas na nakatakdang talihalat ng parametro.',
	'validator-describe-pfmin' => 'Tungkuling pambanghay na mayroon lamang ng kinakailangang mga parametro.',
	'validator-describe-pfmax' => 'Tungkulin ng pambanghay na mayroon ng lahat ng mga parametro.',
	'validator-describe-pfdefault' => 'Tungkulin ng pambanghay na mayroon ng lahat ng mga parametro na ginagamit ang likas na nakatakdang katalaan ng parametro.',
	'validator-describe-autogen' => 'Ang nilalaman ng seksiyong ito ay kusang nilikha ng kawit na pambanghay na "describe" ng dugtong na Validator.',
	'validator_error_empty_argument' => 'Hindi dapat na isang halagang walang laman ang parametrong $1.',
	'validator_error_must_be_number' => 'Dapat na bilang lang ang parametrong $1.',
	'validator_error_must_be_integer' => 'Dapat na tambilang lang ang parametrong $1.',
	'validator_error_must_be_title' => 'Ang parametrong $1 ay maaaring maging isang katanggap-tanggap na pangalan ng pahina ng wiki lamang.',
	'validator_error_must_be_existing_title' => 'Ang parametrong $1 ay maaaring maging isang umiiral na pangalan ng pahina ng wiki lamang.',
	'validator-error-must-be-float' => 'Ang parametrong $1 ay maaaring isang lumulutang na bilang ng punto lamang.',
	'validator_error_invalid_range' => 'Dapat na nasa pagitan ng $2 at $3 ang parametrong $1.',
	'validator-error-invalid-regex' => 'Ang parametrong $1 ay dapat tumugma sa ganitong pangkaraniwang pagsasaad: $2.',
	'validator-error-invalid-length' => 'Ang parametrong $1 ay dapat na may isang haba na $2.',
	'validator-error-invalid-length-range' => 'Ang parametrong $1 ay dapat na may isang haba na nasa pagitan ng $2 at $3.',
	'validator_error_invalid_argument' => 'Ang halagang $1 ay hindi tanggap para sa parametrong $2.',
	'validator_list_error_empty_argument' => 'Hindi tumatanggap ng halagang walang laman ang parametrong $1.',
	'validator_list_error_must_be_number' => 'Dapat na naglalaman lang ng mga bilang ang parametrong $1.',
	'validator_list_error_must_be_integer' => 'Dapat na naglalaman lang ng mga tambilang ang parametrong $1.',
	'validator_list_error_must_be_title' => 'Ang parametrong $1 ay maaaring maglaman lamang ng katanggap-tanggap na mga pangalan ng pahina ng wiki.',
	'validator_list_error_must_be_existing_title' => 'Ang parametrong $1 ay maaaring maglaman lamang ng umiiral na mga pangalan ng pahina ng wiki lamang.',
	'validator-list-error-must-be-float' => 'Ang parametrong $1 ay maaaring maglaman lamang ng mga palutang.',
	'validator_list_error_invalid_range' => 'Dapat na nasa pagitan ng $2 at $3 ang lahat ng mga halaga ng parametrong $1.',
	'validator-list-error-invalid-regex' => 'Ang lahat ng mga halaga ng parametrong $1 ay dapat na tumugma sa pangkaraniwang pagsasaad na ito: $2.',
	'validator_list_error_invalid_argument' => 'Hindi tanggap ang isa o higit pang mga halaga para sa parametrong $1.',
	'validator-list-error-accepts-only' => 'Hindi katanggap-tanggap ang isa o mas maraming mga halaga para sa parametrong $1. Tumatanggap lamang ito ng {{PLURAL:$3|ganitong halaga|ganitong mga halaga}}: $2.',
	'validator-list-error-accepts-only-omitted' => 'Hindi katanggap-tanggap ang isa o masa marami pang mga halaga para sa parametrong $1. Tumatanggap lamang ito ng {{PLURAL:$3|ganitong halaga|ganitong mga halaga}}: $2 (at $4 na inalis na {{PLURAL:$4|halaga|mga halaga}}).',
	'validator_error_accepts_only' => 'Ang halagang "$4" ay hindi katanggap-tanggap para sa parametrong $1.  Tumatanggap lamang ito ng
{{PLURAL:$3|ganitong halaga|ganitong mga halaga}}: $2.',
	'validator-error-accepts-only-omitted' => 'Ang halagang "$2" ay hindi katanggap-tanggap para sa parametrong $1. Tumatanggap lamang ito ng {{PLURAL:$5|ganitong halaga|ganitong mga halaga}}: $3 (at $4 na inalis na {{PLURAL:$4|halaga|mga halaga}}).',
	'validator_list_omitted' => 'Tinanggal {{PLURAL:$2|na ang|na ang mga}} {{PLURAL:$2|halaga|halaga}} ng $1.',
	'validator-message-nodesc' => 'Walang ibinigay na paglalarawan',
);

/** Turkish (Türkçe)
 * @author Erdemaslancan
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'validator_error_unknown_argument' => '$1, geçerli bir parametre değildir.',
	'validator-describe-required' => 'gerekli',
	'validator-describe-header-parameter' => 'Parametre',
	'validator-describe-header-type' => 'Tür',
	'validator_error_empty_argument' => '$1 parametresi boş bir değere sahip olamaz.',
	'validator_error_must_be_number' => '$1 parametresi sadece sayı olabilir.',
	'validator_error_must_be_integer' => '$1 parametresi sadece bir tamsayı olabilir',
	'validator_list_error_empty_argument' => '$1 parametresi boş değerleri kabul etmemektedir.',
	'validator_list_error_must_be_number' => '$1 parametresi sadece sayı içerebilir.',
);

/** Ukrainian (українська)
 * @author NickK
 * @author Olvin
 * @author Prima klasy4na
 */
$messages['uk'] = array(
	'validator-desc' => 'Валідатор забезпечує іншим розширенням можливості перевірки параметрів функцій парсера і тегів, встановлення значень за умовчанням та створення повідомлень про помилки',
	'validator_error_parameters' => 'У вашому синтаксисі {{PLURAL:$1|виявлена така помилка|виявлені такі помилки}}:',
	'validator-describe-header-default' => 'Стандартно',
	'validator-describe-header-description' => 'Опис',
	'validator-describe-parameters' => 'Параметри',
	'validator-describe-syntax' => 'Синтаксис',
	'validator-describe-tagmin' => "Доповнення тегу з одними лише обов'язковими параметрами.",
	'validator-describe-tagmax' => 'Доповнення тегу з усіма параметрами.',
	'validator-describe-tagdefault' => 'Доповнення тегу з усіма параметрами, із застосуванням стандартної нотації параметрів.',
	'validator-describe-pfmin' => "Функція аналізатора, що має лише обов'язкові параметри.",
);

/** Urdu (اردو)
 * @author පසිඳු කාවින්ද
 */
$messages['ur'] = array(
	'validator-type-string' => 'ٹیکسٹ',
	'validator-type-char' => 'کردار',
	'validator-type-title' => 'عنوان',
	'validator-listerrors-errors' => 'غلطیاں',
	'validator-listerrors-low' => 'کم',
	'validator-listerrors-normal' => 'عام',
	'validator-listerrors-high' => 'اعلی',
	'validator-listerrors-fatal' => 'مہلک',
	'validator-describe-empty' => 'خالی',
	'validator-describe-header-type' => 'قسم',
	'validator-describe-header-default' => 'پہلے سے طے شدہ',
	'validator-describe-header-description' => 'تفصیل',
	'validator-describe-syntax' => 'نحو',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 * @author පසිඳු කාවින්ද
 */
$messages['vi'] = array(
	'validator-desc' => 'Bộ phê chuẩn cho phép các phần mở rộng khác phê chuẩn tham số của hàm cú pháp và thẻ mở rộng, đặt giá trị mặc định, và báo cáo lỗi.',
	'validator-warning' => 'Cảnh báo: $1',
	'validator-error' => 'Lỗi: $1',
	'validator_error_parameters' => '{{PLURAL:$1|Lỗi|Các lỗi}} cú pháp sau được nhận ra trong mã của bạn:',
	'validator_warning_parameters' => 'Có {{PLURAL:$1|lỗi|lỗi}} cú pháp trong mã của bạn.',
	'validator_error_unknown_argument' => '$1 không phải là tham số hợp lệ.',
	'validator_error_required_missing' => 'Không định rõ tham số bắt buộc “$1”.',
	'validator-type-string' => 'văn bản',
	'validator-type-integer' => 'số nguyên',
	'validator-type-float' => 'Số',
	'validator-type-boolean' => 'có/không',
	'validator-type-char' => 'ký tự',
	'validator-type-title' => 'Tựa đề',
	'validator-type-string-list' => 'danh sách văn bản',
	'validator-type-integer-list' => 'danh sách số nguyên',
	'validator-type-float-list' => 'danh sách con số',
	'validator-type-boolean-list' => 'danh sách có/không',
	'validator-type-char-list' => 'danh sách ký tự',
	'validator-type-title-list' => 'danh sách tiêu đề',
	'validator-listerrors-errors' => 'Lỗi',
	'validator-listerrors-low' => 'Thấp',
	'validator-listerrors-normal' => 'Thường',
	'validator-listerrors-high' => 'Cao',
	'validator-describe-descriptionmsg' => "'''Miêu tả''': $1",
	'validator-describe-empty' => 'có sản phẩm nào',
	'validator-describe-header-parameter' => 'Tham số',
	'validator-describe-header-type' => 'Loại',
	'validator-describe-header-default' => 'Mặc định',
	'validator-describe-header-description' => 'Miêu tả',
	'validator-describe-parameters' => 'Tham số',
	'validator-describe-syntax' => 'Cú pháp',
	'validator_error_empty_argument' => 'Tham số “$1” không được để trống.',
	'validator_error_must_be_number' => 'Tham số “$1” phải là con số.',
	'validator_error_must_be_integer' => 'Tham số “$1” phải là số nguyên.',
	'validator_error_invalid_range' => 'Tham số “$1” phải nằm giữa $2 và $3.',
	'validator_error_invalid_argument' => 'Giá trị “$1” không hợp tham số “$2”.',
	'validator_list_error_empty_argument' => 'Không được để trống tham số “$1”.',
	'validator_list_error_must_be_number' => 'Tham số “$1” chỉ được phép bao gồm con số.',
	'validator_list_error_must_be_integer' => 'Tham số “$1” chỉ được phép bao gồm số nguyên.',
	'validator_list_error_invalid_range' => 'Tất cả các giá trị của tham số “$1” phải nằm giữa $2 và $3.',
	'validator_list_error_invalid_argument' => 'Ít nhất một giá trị của tham số “$1” không hợp lệ.',
	'validator_error_accepts_only' => 'Tham số $1 có giá trị không hợp lệ “$4”. Tham số chỉ nhận được {{PLURAL:$3|giá trị|các giá trị}} này: $2.',
	'validator_list_omitted' => '{{PLURAL:$2|Giá trị|Các giá trị}} “$1” bị bỏ qua.',
);

/** Yiddish (ייִדיש)
 * @author පසිඳු කාවින්ද
 */
$messages['yi'] = array(
	'validator-type-string' => 'טעקסט',
	'validator-type-title' => 'קעפל',
	'validator-listerrors-normal' => 'נארמאַל',
	'validator-describe-empty' => 'ליידיק',
	'validator-describe-header-description' => 'באַשרײַבונג',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Hydra
 * @author Richarddong
 * @author Shirayuki
 * @author Wilsonmess
 * @author Xiaomingyan
 */
$messages['zh-hans'] = array(
	'validator-warning' => '警告：$1',
	'validator-error' => '错误：$1',
	'validator-fatal-error' => '致命错误：$1',
	'validator_error_parameters' => '从您的语法中检测到以下错误：', # Fuzzy
	'validator_warning_parameters' => '您的语法中存在错误。', # Fuzzy
	'validator-warning-adittional-errors' => '⋯⋯以及更多的问题。', # Fuzzy
	'validator-error-omitted' => '"$1"等值被忽略。', # Fuzzy
	'validator-error-problem' => '参数 $1 存在一个问题。',
	'validator_error_unknown_argument' => '$1 不是一个有效的参数。',
	'validator_error_required_missing' => '未能提供必要的参数 $1 。',
	'validator-error-override-argument' => '试图用 "$3" 覆盖参数 $1 的值（$2）',
	'validator-type-string' => '文本',
	'validator-type-float' => '浮点数',
	'validator-type-boolean' => '布尔值',
	'validator-type-char' => '字符',
	'validator-listerrors-errors' => '错误',
	'validator-listerrors-minor' => '很小',
	'validator-listerrors-low' => '小',
	'validator-listerrors-normal' => '中',
	'validator-listerrors-high' => '大',
	'validator-listerrors-fatal' => '致命',
	'validator-describe-descriptionmsg' => "'''说明'''：$1",
	'validator-describe-empty' => '空白',
	'validator-describe-required' => '必填',
	'validator-describe-header-parameter' => '参数',
	'validator-describe-header-aliases' => '别名',
	'validator-describe-header-type' => '类型',
	'validator-describe-header-default' => '默认',
	'validator-describe-header-description' => '说明',
	'validator-describe-parameters' => '参数',
	'validator-describe-syntax' => '语法',
	'validator_error_empty_argument' => '参数 $1 不能为空。',
	'validator_error_must_be_number' => '参数 $1 只能为数字。',
	'validator_error_must_be_integer' => '参数 $1 只能为整数。',
	'validator_error_invalid_range' => '参数 $1 的范围必须介于 $2 与 $3 之间。',
	'validator_error_invalid_argument' => '值 $1 对于参数 $2 不合法。',
	'validator_list_error_empty_argument' => '参数 $1 不接受空值。',
	'validator_list_error_must_be_number' => '参数 $1 只能包含数字。',
	'validator_list_error_must_be_integer' => '参数 $1 只能包含整数。',
	'validator-list-error-must-be-float' => '参数 $1 只能包含浮点数。',
	'validator_list_error_invalid_range' => '参数 $1 所有合法的值都必须介于 $2 与 $3 之间。',
	'validator_list_error_invalid_argument' => '参数 $1 的一个或多个值不合法。',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Mark85296341
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'validator-warning' => '警告：$1',
	'validator-error' => '錯誤：$1',
	'validator-fatal-error' => '致命錯誤：$1',
	'validator-error-problem' => '參數 $1 存在一個問題。',
	'validator_error_unknown_argument' => '$1 不是一個有效的參數。',
	'validator_error_required_missing' => '未能提供必要的參數 $1 。',
	'validator-error-override-argument' => '試圖用 "$3" 覆蓋參數 $1 的值（$2）',
	'validator-type-string' => '文本',
	'validator-type-float' => '浮點數',
	'validator-type-boolean' => '布爾值',
	'validator-type-char' => '字符',
	'validator-listerrors-errors' => '錯誤',
	'validator-listerrors-minor' => '很小',
	'validator-listerrors-low' => '小',
	'validator-listerrors-normal' => '中',
	'validator-listerrors-high' => '大',
	'validator-listerrors-fatal' => '致命',
	'validator-describe-descriptionmsg' => "'''說明'''：$1",
	'validator-describe-empty' => '空白',
	'validator-describe-required' => '必填',
	'validator-describe-header-parameter' => '參數',
	'validator-describe-header-aliases' => '別名',
	'validator-describe-header-type' => '類型',
	'validator-describe-header-default' => '默認',
	'validator-describe-header-description' => '說明',
	'validator-describe-parameters' => '參數',
	'validator-describe-syntax' => '語法',
	'validator_error_empty_argument' => '參數 $1 不能為空。',
	'validator_error_must_be_number' => '參數 $1 只能為數字。',
	'validator_error_must_be_integer' => '參數 $1 只能為整數。',
	'validator_error_invalid_range' => '參數 $1 的範圍必須介於 $2 與 $3 之間。',
	'validator_error_invalid_argument' => '值 $1 對於參數 $2 不合法。',
	'validator_list_error_empty_argument' => '參數 $1 不接受空值。',
	'validator_list_error_must_be_number' => '參數 $1 只能包含數字。',
	'validator_list_error_must_be_integer' => '參數 $1 只能包含整數。',
	'validator-list-error-must-be-float' => '參數 $1 只能包含浮點數。',
	'validator_list_error_invalid_range' => '參數 $1 所有合法的值都必須介於 $2 與 $3 之間。',
	'validator_list_error_invalid_argument' => '參數 $1 的一個或多個值不合法。',
);
