<?php

/**
 * Aliases for the special pages of the Semantic Watchlist extension.
 *
 * @file SemanticWatchlist.i18n.alias.php
 * @ingroup SemanticWatchlist
 *
 * @licence GNU GPL v3+
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'SemanticWatchlist' => array( 'SemanticWatchlist' ),
	'WatchlistConditions' => array( 'WatchlistConditions', 'WatchlistGroups' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'SemanticWatchlist' => array( 'قائمة_مراقبة_سيمانتيك' ),
	'WatchlistConditions' => array( 'شروط_قائمة_المراقبة' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'SemanticWatchlist' => array( 'Semantische_Beobachtungsliste' ),
	'WatchlistConditions' => array( 'Semantische_Beobachtungsliste_einstellen' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'SemanticWatchlist' => array( 'BewniWiki' ),
	'WatchlistConditions' => array( 'GrubeListeyseyri' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'SemanticWatchlist' => array( 'فهرست_پی‌گیری_معنایی' ),
	'WatchlistConditions' => array( 'شرایط_فهرست_پی‌گیری' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'SemanticWatchlist' => array( 'Semanttinen_tarkkailulista' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'SemanticWatchlist' => array( 'Semantischi_Beobachtigslischt' ),
	'WatchlistConditions' => array( 'Semantischi_Beobachtigslischt_yystelle' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'SemanticWatchlist' => array( 'Observatorio_semantic' ),
	'WatchlistConditions' => array( 'Conditiones_del_observatorio_semantic', 'Gruppos_del_observatorio_semantic' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'SemanticWatchlist' => array( '意味的ウォッチリスト' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'SemanticWatchlist' => array( '시멘틱주시문서목록', '시멘틱주시목록' ),
	'WatchlistConditions' => array( '조건주시문서목록', '그룹주시문서목록' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'SemanticWatchlist' => array( 'Semantesch_Iwwerwaachungslëscht' ),
	'WatchlistConditions' => array( 'Iwwerwaachungslëscht_Conditiounen', 'Iwwerwaachungslëscht_Gruppen' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'SemanticWatchlist' => array( 'СемантичкиСписокНаНабљудувања' ),
	'WatchlistConditions' => array( 'УсловиНаСписокНаНабљудувања', 'ГрупиНаНабљудувања' ),
);

/** Norwegian Bokmål (norsk (bokmål)‎) */
$specialPageAliases['nb'] = array(
	'SemanticWatchlist' => array( 'Semantisk_overvåkningsliste' ),
);

/** Nedersaksisch (Nedersaksisch) */
$specialPageAliases['nds-nl'] = array(
	'SemanticWatchlist' => array( 'Semantiese_volglieste' ),
	'WatchlistConditions' => array( 'Volgliestkondisies' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'SemanticWatchlist' => array( 'SemantischeVolglijst' ),
	'WatchlistConditions' => array( 'Volglijstcondities' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'SemanticWatchlist' => array( '语义监视列表' ),
);