<?php

namespace SMW\Tests;

/**
 * Tests for the SMWDIGeoCoord class.
 *
 * @file
 * @since 1.8
 *
 * @ingroup SMW
 * @ingroup Test
 *
 * @group SMW
 * @group SMWExtension
 * @group SMWDataItems
 *
 * @author Nischay Nahata
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */
class SMWDIGeoCoordTest extends DataItemTest {

	/**
	 * @see DataItemTest::getClass
	 *
	 * @since 1.8
	 *
	 * @return string
	 */
	public function getClass() {
		return '\SMWDIGeoCoord';
	}

	/**
	 * @see DataItemTest::constructorProvider
	 *
	 * @since 1.8
	 *
	 * @return array
	 */
	public function constructorProvider() {
		return array(
			array( true, array( 'lat'=>83.34, 'lon'=>38.44, 'alt'=>54 ) ),
			array( true, array( 'lat'=>42.43, 'lon'=>33.32 ) ),
		);
	}

}