<?php
/**
 * Internationalization file for Semantic MediaWiki
 *
 * @file
 * @ingroup Language
 * @ingroup I18n
 * @ingroup SMWLanguage
 */

$messages = array();

/** English
 *  @author Markus Krötzsch
 */
$messages['en'] = array(
	'smw-desc'              => 'Making your wiki more accessible - for machines \'\'and\'\' humans ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])',
	'smw_viewasrdf'         => 'RDF feed',
	'smw_finallistconjunct' => ', and', // used in "A, B, and C"
	'smw_factbox_head'      => 'Facts about "$1"',
	'smw_isspecprop'        => 'This property is a special property in this wiki.',
	'smw_concept_description' => 'Description of concept "$1"', // used in the namespace "Concept:"
	'smw_no_concept_namespace' => 'Concepts can only be defined on pages in the Concept: namespace.',
	'smw_multiple_concepts'   => 'Each concept page can have only one concept definition.',
	'smw_concept_cache_miss'  => 'The concept "$1" can not be used at the moment, since the wiki configuration requires it to be computed off-line.
If the problem does not go away after some time, ask your site administrator to make this concept available.',
	'smw_noinvannot'        => 'Values cannot be assigned to inverse properties.',
	'version-semantic'      => 'Semantic extensions',

	// URIs that should not be used in objects in cases where users can provide URIs
	'smw_uri_blacklist' => " http://www.w3.org/1999/02/22-rdf-syntax-ns#\n http://www.w3.org/2000/01/rdf-schema#\n http://www.w3.org/2002/07/owl#",
	'smw_baduri'        => 'URIs of the form "$1" are not allowed.',

	// Link to CSV files
	'smw_csv_link' => 'CSV',
	// Link to DSV files
	'smw_dsv_link' => 'DSV',
	// Link to JSON files
	'smw_json_link' => 'JSON',
	// Link to RDF files
	'smw_rdf_link' => 'RDF',

	// Names for result formats:
	'smw_printername_count' => 'Count results',
	'smw_printername_csv' => 'CSV export',
	'smw_printername_dsv' => 'DSV export',
	'smw_printername_debug' => 'Debug query (for experts)',
	'smw_printername_embedded' => 'Embed page contents',
	'smw_printername_json' => 'JSON export',
	'smw_printername_list' => 'List',
	'smw_printername_ol' => 'Enumeration',
	'smw_printername_ul' => 'Itemization',
	'smw_printername_table' => 'Table',
	'smw_printername_broadtable' => 'Broad table',
	'smw_printername_template' => 'Template',
	'smw_printername_rdf' => 'RDF export',
	'smw_printername_category' => 'Category',

	// Messages for query parameter descriptions
	'validator-type-class-SMWParamSource' => 'text',
	'smw-paramdesc-limit'	=> 'The maximum number of results to return',
	'smw-paramdesc-offset' => 'The offset of the first result',
	'smw-paramdesc-headers'	=> 'Display the headers/property names',
	'smw-paramdesc-mainlabel'	=> 'The label to give to the main page name',
	'smw-paramdesc-link'	=> 'Show values as links',
	'smw-paramdesc-intro'	=> 'The text to display before the query results, if there are any',
	'smw-paramdesc-outro'	=> 'The text to display after the query results, if there are any',
	'smw-paramdesc-default'	=> 'The text to display if there are no query results',
	'smw-paramdesc-sep'	=> 'The separator for values',
	'smw-paramdesc-showsep' => 'Show separator in top of CSV file ("sep=<value>")',
	'smw-paramdesc-distribution' => 'Instead of displaying all values, count their occurrences, and show these.',
	'smw-paramdesc-distributionsort' => 'Sort the value distribution by occurrence count.',
	'smw-paramdesc-distributionlimit' => 'Limit the value distribution to the count of only some values.',
	'smw-paramdesc-template'	=> 'The name of a template with which to display the printouts',
	'smw-paramdesc-columns'	=> 'The number of columns in which to display results (default is $1)',
	'smw-paramdesc-userparam'	=> 'A value passed into each template call, if a template is used',
	'smw-paramdesc-introtemplate'	=> 'The name of a template to display before the query results, if there are any',
	'smw-paramdesc-outrotemplate'	=> 'The name of a template to display after the query results, if there are any',
	'smw-paramdesc-embedformat'	=> 'The HTML tag used to define headings',
	'smw-paramdesc-embedonly'	=> 'Display no headings',
	'smw-paramdesc-table-class'	=> 'An additional CSS class to set for the table',
	'smw-paramdesc-rdfsyntax'	=> 'The RDF syntax to be used',
	'smw-paramdesc-csv-sep'		=> 'The separator to use',
	'smw-paramdesc-dsv-separator'	=> 'The separator to use',
	'smw-paramdesc-dsv-filename'	=> 'The name for the DSV file',
	'smw-smwdoc-description' => 'Shows a table of all parameters that can be used for the specified result format together with default values and descriptions.',
	'smw-smwdoc-par-format'	=> 'The result format to display parameter documentation for.',
	'smw-smwdoc-par-parameters' => 'Which parameters to show. "specific" for those added by the format, "base" for those available in all formats, and "all" for both.',
	'smw-paramdesc-sort' => 'Property to sort the query by',
	'smw-paramdesc-order' => 'Order of the query sort',
	'smw-paramdesc-searchlabel' => 'Text for continuing the search',
	'smw-paramdesc-named_args' => 'Name the arguments passed to the template',
	'smw-paramdesc-export' => 'Export option',
	'smw-paramdesc-prettyprint' => 'A pretty-print output that displays additional indents and newlines',
	'smw-paramdesc-source' => 'Alternative query source',
	'smw-paramdesc-jsonsyntax' => 'JSON syntax to be used',

	// Feed printer
	'smw-printername-feed' => 'RSS and Atom feed',
	'smw-paramdesc-feedtype'  => 'Feed type',
	'smw-paramdesc-feedtitle' => 'The text to be used as the title of the feed',
	'smw-paramdesc-feeddescription' => 'The text to be used as the description of the feed',
	'smw-paramdesc-feedpagecontent' => 'Page content to be displayed with the feed',
	'smw-label-feed-link' => 'RSS',
	'smw-label-feed-description' => '$1 $2 feed',

	// Messages and strings for inline queries
	'smw_iq_disabled'    => "Semantic queries have been disabled for this wiki.",
	'smw_iq_moreresults' => '… further results',

	// Messages and strings for basic data type processing
	'smw_parseerror'    => 'The given value was not understood.', // generic error, "something" went wrong
	'smw_decseparator'  => '.',
	'smw_kiloseparator' => ',',
	'smw_notitle'       => '"$1" cannot be used as a page name in this wiki.',
	'smw_noproperty'    => '"$1" cannot be used as a property name in this wiki.',
	'smw_wrong_namespace' => 'Only pages in namespace "$1" are allowed here.',
	'smw_manytypes'     => 'More than one type defined for property.',
	'smw_emptystring'   => 'Empty strings are not accepted.',
	'smw_maxstring'     => 'String representation $1 is too long.',
	'smw_notinenum'     => '"$1" is not in the list of possible values ($2) for this property.',
	'smw_noboolean'     => '"$1" is not recognized as a Boolean (true/false) value.',
	'smw_true_words'    => 'true,t,yes,y', // comma-separated synonyms for Boolean TRUE besides '1', primary value first
	'smw_false_words'   => 'false,f,no,n', // comma-separated synonyms for Boolean FALSE besides '0', primary value first
	'smw_nofloat'       => '"$1" is not a number.',
	'smw_infinite'      => 'Numbers as large as "$1" are not supported.',
	'smw_unitnotallowed'=> '"$1" is not declared as a valid unit of measurement for this property.',
	'smw_nounitsdeclared' => 'No units of measurement were declared for this property.',
	'smw_novalues'      => 'No values specified.',

	// Currently unused, floats silently store units.  'smw_unexpectedunit' => 'this property supports no unit conversion',

	// some links for online maps; can be translated to different language versions of services, but need not

	// Messages for datetime parsing
	'smw_nodatetime' => 'The date "$1" was not understood.',

	// Errors and notices related to queries
	'smw_toomanyclosing'    => 'There appear to be too many occurrences of "$1" in the query.',
	'smw_noclosingbrackets' => 'Some use of "<nowiki>[[</nowiki>" in your query was not closed by a matching "]]".',
	'smw_misplacedsymbol'   => 'The symbol "$1" was used in a place where it is not useful.',
	'smw_unexpectedpart'    => 'The part "$1" of the query was not understood.
Results might not be as expected.',
	'smw_emptysubquery'     => 'Some subquery has no valid condition.',
	'smw_misplacedsubquery' => 'Some subquery was used in a place where no subqueries are allowed.',
	'smw_valuesubquery'     => 'Subqueries not supported for values of property "$1".',
	'smw_badqueryatom'      => 'Some part "<nowiki>[[…]]</nowiki>" of the query was not understood.',
	'smw_propvalueproblem'  => 'The value of property "$1" was not understood.',
	'smw_noqueryfeature'    => 'Some query feature was not supported in this wiki and part of the query was dropped ($1).',
	'smw_noconjunctions'    => 'Conjunctions in queries are not supported in this wiki and part of the query was dropped ($1).',
	'smw_nodisjunctions'    => 'Disjunctions in queries are not supported in this wiki and part of the query was dropped ($1).',
	'smw_querytoolarge'     => 'The following query conditions could not be considered due to the wikis restrictions in query size or depth: $1.',
	'smw_notemplategiven'   => 'Provide a value for the parameter "template" for this query format to work.',

	// Messages from the database backend
	'smw_db_sparqlqueryproblem'   => 'The query result could not be obtained from the SPARQL database. This error might be temporary or indicate a bug in the database software.',
	'smw_db_sparqlqueryincomplete'=> 'Answering the query turned out to be too difficult and was aborted. Some results could be missing. If possible, try using a simpler query instead.',

	// Messages for pages of types and properties
	'smw_type_header'             => 'Properties of type "$1"',
	'smw_typearticlecount'        => 'Showing $1 {{PLURAL:$1|property|properties}} using this type.',
	'smw_attribute_header'        => 'Pages using the property "$1"',
	'smw_attributearticlecount'   => 'Showing $1 {{PLURAL:$1|page|pages}} using this property.',
	'smw_subproperty_header'      => 'Subproperties',
	'smw_subpropertyarticlecount' => 'This property has the following $1 {{PLURAL:$1|subproperty|subproperties}}:',
	'smw_concept_header'          => 'Pages of concept "$1"',
	'smw_conceptarticlecount'     => 'Showing $1 {{PLURAL:$1|page|pages}} belonging to that concept.',

	// Group name for SMW special pages
	'specialpages-group-smw_group' => 'Semantic MediaWiki',

	// Messages for Export RDF Special
	'exportrdf'               => 'Export pages to RDF', // name of this special
	'smw_exportrdf_docu'      => 'This page allows you to obtain data from a page in RDF format.
To export pages, enter the titles in the text box below, one title per line.',
	'smw_exportrdf_recursive' => 'Recursively export all related pages.
Note that the result could be large!',
	'smw_exportrdf_backlinks' => 'Also export all pages that refer to the exported pages.
Generates browsable RDF.',
	'smw_exportrdf_lastdate'  => 'Do not export pages that were not changed since the given point in time.',
	'smw_exportrdf_submit'  => 'Export',
	'uriresolver' => 'URIResolver',

	// Messages for Properties Special
	'properties'             => 'Properties',
	'smw_properties_docu'    => 'The following properties are used in the wiki.',
	'smw_property_template'  => '$1 of type $2 ($3 {{PLURAL:$3|use|uses}})', // <propname> of type <type> (<count> uses)
	'smw_property_template_notype' => '$1 ($2)', // <propname> (<count>)
	'smw_propertylackspage'  => 'All properties should be described by a page!',
	'smw_propertylackstype'  => 'No type was specified for this property (assuming type $1 for now).',
	'smw_propertyhardlyused' => 'This property is hardly used within the wiki!',

	// Messages for Unused Properties Special
	'unusedproperties' => 'Unused properties',
	'smw_unusedproperties_docu' => 'The following properties exist although no other page makes use of them.',
	'smw_unusedproperty_template' => '$1 of type $2', // <propname> of type <type>

	// Messages for Wanted Properties Special
	'wantedproperties'            => 'Wanted properties',
	'smw_wantedproperties_docu'   => 'The following properties are used in the wiki but do not yet have a page for describing them.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|use|uses}})', // <propname> (<count> uses)

	// Messages for the refresh button
	'smw_purge'     => 'Refresh',

	// Messages for (data)Types Special
	'types'          => 'Types',
	'smw_types_docu' => 'The following is a list of all data types that can be assigned to properties.',
	'smw-special-types-no-such-type' => 'The specified data type does not exist',

	/*Messages for SemanticStatistics Special*/
	'semanticstatistics' => 'Semantic statistics',
	'smw_semstats_text'  => 'This wiki contains \'\'\'$1\'\'\' property {{PLURAL:$1|value|values}} for a total of \'\'\'$2\'\'\' [[Special:Properties|{{PLURAL:$2|property|different properties}}]].
\'\'\'$3\'\'\' {{PLURAL:$3|property has|properties have}} an own page, and the intended data type is specified for \'\'\'$4\'\'\' of those.
Some of the existing properties might be [[Special:UnusedProperties|unused properties]].
Properties that still lack a page are found on the [[Special:WantedProperties|list of wanted properties]].',

	// Name of the URI Resolver Special (no content)
	'smw_uri_doc' => 'The URI resolver implements the [$1 W3C TAG finding on httpRange-14].
It takes care that humans do not turn into websites.',

	// Messages for ask Special
	'ask'                   => 'Semantic search',
	'smw_ask_doculink'      => 'http://semantic-mediawiki.org/wiki/Help:Semantic_search',
	'smw_ask_sortby'        => 'Sort by column (optional)',
	'smw_ask_ascorder'      => 'Ascending',
	'smw_ask_descorder'     => 'Descending',
	'smw_ask_submit'        => 'Find results',
	'smw_ask_editquery'     => '[Edit query]',
	'smw_add_sortcondition' => '[Add sorting condition]',
	'smw_ask_hidequery'     => 'Hide query',
	'smw_ask_help'          => 'Querying help',
	'smw_ask_queryhead'     => 'Query',
	'smw_ask_printhead'     => 'Additional data to display',
	'smw_ask_printdesc'     => '(add one property name per line)',
	'smw_ask_format_as'     => 'Format as:',
	'smw_ask_defaultformat'	=> 'default',
	'smw_ask_otheroptions'  => 'Other options',
	'smw-ask-otheroptions-info' => 'This section contains options that alter printout statements. Parameter descriptions can be viewed by hovering over them.',
	'smw-ask-otheroptions-collapsed-info' => 'Please use the plus icon to view all available options',
	'smw_ask_show_embed'	=> 'Show embed code',
	'smw_ask_hide_embed'	=> 'Hide embed code',
	'smw_ask_embed_instr'	=> 'To embed this query inline into a wiki page use the code below.',
	'smw-ask-delete'        => '[Delete]',
	'smw-ask-sorting'       => 'Sorting',
	'smw-ask-format-selection-help' => 'For a detailed description, please visit the $1 help page.',

	// Messages for Query Creator Special
	'querycreator'             => 'Query Creator',
	'smw_qc_addmainlabel'      => 'Add main label',
	'smw_qc_show_addnal_opts'  => 'Show more options',
	'smw_qc_hide_addnal_opts'  => 'Show less options',
	'smw_qc_otheropt'          => 'Other options',
	'smw_qc_intro'             => 'Intro:',
	'smw_qc_outro'             => 'Outro:',
	'smw_qc_default'           => 'Default:',
	'smw_qc_formatopt'         => 'Format options',
	'smw_qc_query_help'        => 'Enter a query using the form below. Select wiki pages based on
Categories (<strong><nowiki>e.g. [[Category:Actor]]</nowiki></strong>),
Properties (<strong><nowiki>e.g. [[Located in::Germany]]</nowiki></strong>),
Names(<strong><nowiki>e.g. [[Germany]]</nowiki></strong>) and
Namespaces (<strong><nowiki>e.g. [[Help:+]]</nowiki></strong>)',

	//Generic messages for Query UI
	'smw_qui_property'      => '<strong>Property</strong>',
	'smw_qui_prop'          => 'Property:',
	'smw_qui_labl'          => 'Label:',
	'smw_qui_formt'         => 'Format:',
	'smw_qui_limt'          => 'Limit:',
	'smw_qui_shownresults'  => 'show in results',
	'smw_qui_noquery'       => 'No query has been specified',
	'smw_qui_invalidprop'   => '"$1" may not be a valid property',
	'smw_qui_invalidformat' => 'The chosen format "$1" does not exist for this wiki',
	'smw_qui_nosort'        => 'No sorting',
	'smw_qui_ascorder'      => 'Ascending',
	'smw_qui_descorder'     => 'Descending',
	'smw_qui_randorder'     => 'Random',
	'smw_qui_addnprop'      => 'add property',
	'smw_qui_delete'        => 'Remove',
	'smw_qui_rescol'		=> 'Query-matches',
	'smw_qui_options'		=> 'options',
	'smw_qui_addcategory'	=> 'add category',
	'smw_qui_addrescol'		=> 'add query-matches',
	'smw_qui_ok'			=> 'Ok',
	'smw_qui_cancel'		=> 'Cancel',
	'smw_qui_category'		=> '<strong>Category</strong>',
	'smw_qui_label'			=> 'Label',
	'smw_prp_options'		=> 'Property Options',
	'smw_qui_catopts'		=> 'Category Options',
	'smw_qui_mainlabopts'   => 'Result Options',
	'smw_qui_dlabel'		=> 'Label:',
	'smw_qui_dcategory'		=> 'Category:',
	'smw_qui_dcatyes'		=> 'Show text when category is present:',
	'smw_qui_dcatno'		=> 'Show text when category is absent:',

	// Messages for the search by property special
	'searchbyproperty'      => 'Search by property',
	'smw_sbv_docu'          => 'Search for all pages that have a given property and value.',
	# unused / Siebrand 2009-04-25
	# 'smw_sbv_noproperty'    => 'Enter a property.',
	'smw_sbv_novalue'       => 'Enter a valid value for the property, or view all property values for "$1".',
	'smw_sbv_displayresult' => 'A list of all pages that have property "$1" with value "$2"',
	'smw_sbv_displayresultfuzzy' => 'A list of all pages that have property "$1" with value "$2".
Since there have been only a few results, also nearby values are displayed.',
	'smw_sbv_property'      => 'Property:',
	'smw_sbv_value'         => 'Value:',
	'smw_sbv_submit'        => 'Find results',

	// Messages for the browsing special
	'browse'                     => 'Browse wiki',
	'smw_browselink'             => 'Browse properties',
	'smw_browse_article'         => 'Enter the name of the page to start browsing from.',
	'smw_browse_go'              => 'Go',
	'smw_browse_more'            => '…',
	'smw_browse_show_incoming'   => 'show properties that link here',
	'smw_browse_hide_incoming'   => 'hide properties that link here',
	'smw_browse_no_outgoing'     => 'This page has no properties.',
	'smw_browse_no_incoming'     => 'No properties link to this page.',
	'smw_inverse_label_default'  => '$1 of',
	'smw_inverse_label_property' => 'Inverse property label', # this is the name of a special property

	// Messages for the page property special
	'pageproperty'  => 'Page property search',
	'smw_pp_docu'   => 'Search for all the values of a property on a given page.
Enter both a page and a property.',
	'smw_pp_from'   => 'From page',
	'smw_pp_type'   => 'Property',
	'smw_pp_submit' => 'Find results',

	// Generic messages for result navigation in all kinds of search pages
	'smw_result_prev'      => 'Previous',
	'smw_result_next'      => 'Next',
	'smw_result_results'   => 'Results',
	'smw_result_noresults' => 'No results.',

	// Messages for SMWAdmin
	'smwadmin' => 'Admin functions for Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'The storage engine was set up successfully.',
	'smw_smwadmin_return' => 'Return to $1',
	'smw_smwadmin_updatestarted' => 'A new update process for refreshing the semantic data was started.
All stored data will be rebuilt or repaired where needed.
You can follow the progress of the update on this special page.

Return to $1.',
	'smw_smwadmin_updatenotstarted' => 'There is already an update process running.
Not creating another one.

Return to $1.',
	'smw_smwadmin_updatestopped' => 'All existing update processes have been stopped.

Return to $1.',
	'smw_smwadmin_updatenotstopped' => 'To stop the running update process, you must activate the checkbox to indicate that you are really sure.

Return to $1.',
	'smw_smwadmin_docu' => 'This special page helps you during installation and upgrade of <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Remember to back up valuable data before executing administrative functions.',
	'smw_smwadmin_db' => 'Database installation and upgrade',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki requires some extensions to the MediaWiki database in order to store the semantic data.
The below function ensures that your database is set up properly.
The changes made in this step do not affect the rest of the MediaWiki database, and can easily be undone if desired.
This setup function can be executed multiple times without doing any harm, but it is needed only once on installation or upgrade.',
	'smw_smwadmin_permissionswarn' => 'If the operation fails with SQL errors, the database user employed by your wiki (check your LocalSettings.php) probably does not have sufficient permissions.
Either grant this user additional pemissions to create and delete tables, temporarily enter the login of your database root in LocalSettings.php, or use the maintenance script <tt>SMW_setup.php</tt> which can use the credentials of an administrator.',
	'smw_smwadmin_dbbutton' => 'Initialise or upgrade tables',
	'smw_smwadmin_announce' => 'Announce your wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki has a web service for announcing new semantic wiki sites.
This is used to maintain a list of public sites that use Semantic MediaWiki, mainly to help the <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki project</a> to get an overview of typical uses of Semantic MediaWiki.
See the Semantic MediaWiki homepage for <a href="http://semantic-mediawiki.org/wiki/Registry">further information about this service</a>.',
	'smw_smwadmin_announcebutton' => 'Press the following button to submit your wiki URL to that service.
The service will not register wikis that are not publicly accessible, and it will only store publicly accessible information.',
	'smw_smwadmin_datarefresh' => 'Data repair and upgrade',
	'smw_smwadmin_datarefreshdocu' => 'It is possible to restore all Semantic MediaWiki data based on the current contents of the wiki.
This can be useful to repair broken data or to refresh the data if the internal format has changed due to some software upgrade.
The update is executed page by page and will not be completed immediately.
The following shows if an update is in progress and allows you to start or stop updates (unless this feature was disabled by the site administrator).',
	'smw_smwadmin_datarefreshprogress' => '<strong>An update is already in progress.</strong>
It is normal that the update progresses only slowly since it only refreshes data in small chunks each time a user accesses the wiki.
To finish this update more quickly, you can invoke the MediaWiki maintenance script <tt>runJobs.php</tt> (use the option <tt>--maxjobs 1000</tt> to restrict the number of updates done in one batch).
Estimated progress of current update:',
	'smw_smwadmin_datarefreshbutton' => 'Start updating data',
	'smw_smwadmin_datarefreshstop' => 'Stop this update',
	'smw_smwadmin_datarefreshstopconfirm' => 'Yes, I am sure.',
	'smw_smwadmin_support' => 'Getting support',
	'smw_smwadmin_supportdocu' => 'Various resources might help you in case of problems:',
	'smw_smwadmin_installfile' => 'If you experience problems with your installation, start by checking the guidelines in the <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL file</a>.',
	'smw_smwadmin_smwhomepage' => 'The complete user documentation to Semantic MediaWiki is at <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Bugs can be reported to <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'If you have further questions or suggestions, join the discussion on <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>.',

	// Messages for Admin Links page
	'smw_adminlinks_datastructure' => 'Data structure',
	'smw_adminlinks_displayingdata' => 'Data display',
	'smw_adminlinks_inlinequerieshelp' => 'Inline queries help',

	// Messages for automated property creation
	'smw-createproperty-isproperty' => 'This is a property of type $1.',
	'smw-createproperty-allowedvals' => 'The allowed {{PLURAL:$1|value for this property is|values for this property are}}:',

	// Category QP
	'smw-paramdesc-category-delim' => 'The delimiter',
	'smw-paramdesc-category-template' => 'A template to format the items with',
	'smw-paramdesc-category-userparam' => 'A parameter to pass to the template',

	// Messages for info parser function.
	'smw-info-par-message' => 'Message to display.',
	'smw-info-par-icon' => 'Icon to show, either "info" or "warning".',

	// User preference
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Semantic search options',
	'smw-prefs-intro-text' => 'Options below are provided by [http://semantic-mediawiki.org/ Semantic MediaWiki] (or related extensions) to enable individual customization on selected functions. For more information, please have a look at this [http://semantic-mediawiki.org/wiki/Help:User_preferences help section].',
	'smw-prefs-ask-options-tooltip-display' => 'Display parameter text as an info tooltip',
	'smw-prefs-ask-options-collapsed-default' => 'Enable option box to be collapsed by default',

	// Tooltip UI
	'smw-ui-tooltip-title-property' => 'Property',
	'smw-ui-tooltip-title-quantity' => 'Quantity',
	'smw-ui-tooltip-title-info' => 'Information',
	'smw-ui-tooltip-title-service' => 'Service links',
	'smw-ui-tooltip-title-warning' => 'Error',
	'smw-ui-tooltip-title-parameter' => 'Parameter',
	'smw-ui-tooltip-title-event' => 'Event',

	'smw_unknowntype' => 'The type of this property is invalid',
);

/** Message documentation (Message documentation)
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author Helix84
 * @author Jon Harald Søby
 * @author Kghbln
 * @author Markus Krötzsch
 * @author McDutchie
 * @author Meno25
 * @author Pietrodn
 * @author Purodha
 * @author Raymond
 * @author Shirayuki
 * @author Siebrand
 * @author Umherirrender
 * @author Тест
 */
$messages['qqq'] = array(
	'smw-desc' => '{{desc}}',
	'smw_viewasrdf' => 'This is the text of the link that is triggering the results export when clicked. It appears on pages in namespace Concept: or within the [http://semantic-mediawiki.org/wiki/Help:Browsing_interfaces#The_factbox factbox].',
	'smw_finallistconjunct' => 'The last separator in a list. For example a list could look like this: "A, B, and C". The comma might not be appropriate in your language. 
	{{Identical|And}}',
	'smw_factbox_head' => 'Title of the box [http://semantic-mediawiki.org/wiki/Help:Browsing_interfaces#The_factbox factbox] containing information about property values. $1 holds the name of the page',
	'smw_isspecprop' => 'Used on [[Special:Properties]] to identify a special (build in) property.',
	'smw_concept_description' => 'Title of the section containing the code of a [http://semantic-mediawiki.org/wiki/Help:Concepts concept] (special precomputable query). $1 holds the name of the concept',
	'smw_no_concept_namespace' => 'This is an error/warning message that appears when a concept is added to a page in namespaces other than Concept:.',
	'smw_multiple_concepts' => 'This is an error/warning message that appears when more than concept is added to a page in namespaces Concept:.',
	'smw_concept_cache_miss' => 'This is an information message. $1 holds the name of the [http://semantic-mediawiki.org/wiki/Help:Concepts concept] (special precomputable query)',
	'smw_noinvannot' => 'This is an information message.',
	'version-semantic' => 'This is the name of the extension group on [[Special:Version]].',
	'smw_uri_blacklist' => '{{notranslate}}',
	'smw_baduri' => 'This is an information message. $1 holds the malformed URI.',
	'smw_csv_link' => 'This is the text of the link that is triggering the results export to a CSV-file when clicked.

{{optional}}',
	'smw_dsv_link' => 'This is the text of the link that is triggering the results export to a DSV-file when clicked.

{{optional}}',
	'smw_json_link' => 'This is the text of the link that is triggering the results export to a JSON-file when clicked.

{{optional}}',
	'smw_rdf_link' => 'This is the text of the link that is triggering the results export to a RDF-file when clicked.

{{optional}}',
	'smw_printername_count' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Count_format count].',
	'smw_printername_csv' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:CSV_format CSV].',
	'smw_printername_dsv' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:DSV_format DSV].',
	'smw_printername_debug' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Debug_format Debug].',
	'smw_printername_embedded' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Embedded_format Embedded].',
	'smw_printername_json' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:JSON_format JSON].',
	'smw_printername_list' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:List_format List].',
	'smw_printername_ol' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Ol_format Enumeration (numbered list)].',
	'smw_printername_ul' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Ul_format Itemization (bulleted list)].',
	'smw_printername_table' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Table_format Table].

{{Identical|Table}}',
	'smw_printername_broadtable' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Broadtable_format Broadtable].',
	'smw_printername_template' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Template_format Template].

{{Identical|Template}}',
	'smw_printername_rdf' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:RDF_format RDF].',
	'smw_printername_category' => 'This is the name of the result format [http://semantic-mediawiki.org/wiki/Help:Category_format Category].

{{Identical|Category}}',
	'validator-type-class-SMWParamSource' => 'This is the description of the "source" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-limit' => 'This is the description of the "limit" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-offset' => 'This is the description of the "offset" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-headers' => 'This is the description of the "headers" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-mainlabel' => 'This is the description of the "mainlabel" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-link' => 'This is the description of the "link" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-intro' => 'This is the description of the "intro" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-outro' => 'This is the description of the "outro" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-default' => 'This is the description of the "default" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-sep' => 'This is the description of the "sep" (value separator) parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-showsep' => 'This is the description of the "showsep" (show value separator at top of csv file) parameter for the "csv" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-distribution' => 'This is the description of the "distribution" parameter for the "jqplotbar" and "jqplotpie" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-distributionsort' => 'This is the description of the "distributionsort" parameter for the "jqplotbar" and "jqplotpie" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-distributionlimit' => 'This is the description of the "distributionlimit" parameter for the "jqplotbar" and "jqplotpie" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-template' => 'This is the description of the "introtemplate" parameter of the "template", "list", "ol" and "ul" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-columns' => 'This is the description of the "columns" parameter of the "category" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-userparam' => 'This is the description of the "userparam" parameter for the "template", "list", "ol" and "ul" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-introtemplate' => 'This is the description of the "introtemplate" parameter of the "template", "list", "ol" and "ul" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-outrotemplate' => 'This is the description of the "outrotemplate" parameter of the "template", "list", "ol" and "ul" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-embedformat' => 'This is the description of the "embedformat" parameter of the "embedded" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-embedonly' => 'This is the description of the "embedonly" parameter of the "embedded" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-table-class' => 'This is the description of the "css" parameter of the "table" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-rdfsyntax' => 'This is the description of the "syntax" parameter for the "rdf" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-csv-sep' => 'This is the description of the "separator" parameter for the "csv" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-dsv-separator' => 'This is the description of the "separator" parameter for the "dsv" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-dsv-filename' => 'This is the description of the "filename" parameter for the "dsv" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-smwdoc-description' => 'This is the short description of the [http://semantic-mediawiki.org/wiki/Help:Generating_documentation smwdoc parser function].',
	'smw-smwdoc-par-format' => 'This is the description of the parameter "format" of the [http://semantic-mediawiki.org/wiki/Help:Generating_documentation smwdoc parser function].',
	'smw-smwdoc-par-parameters' => 'This is the description of the parameter "parameters" of the [http://semantic-mediawiki.org/wiki/Help:Generating_documentation smwdoc parser function]. {{doc-important|Do not translate the possible parameter values "specific", "base" and "all".}}',
	'smw-paramdesc-sort' => 'This is the description of the "sort" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-order' => 'This is the description of the "order" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-searchlabel' => 'This is the description of the "searchlabel" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries]. "… further results" must be identical to message {{msg-mw|Smw iq moreresults}}.',
	'smw-paramdesc-named_args' => 'This is the description of the "named args" parameter of the "template", "list", "ol" and "ul" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-export' => 'This is the description of the "export" parameter of the "json" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-prettyprint' => 'This is the description of the "[[wikipedia:prettyprint|prettyprint]]" parameter of the "JSON" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-source' => 'This is the description of the "source" parameter for [http://semantic-mediawiki.org/wiki/Help:Inline_queries#Standard_parameters_for_inline_queries inline queries].',
	'smw-paramdesc-jsonsyntax' => 'This is the description of the "syntax" parameter used by [http://www.semantic-mediawiki.org/wiki/Help:JSON_format].',
	'smw-printername-feed' => 'This is the name of the [http://semantic-mediawiki.org/wiki/Help:Feed_format Feed result format].',
	'smw-paramdesc-feedtype' => 'This is the description of the feed type',
	'smw-paramdesc-feedtitle' => 'This is the description of the "title" parameter of the "feed" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-feeddescription' => 'This is the description of the "description" parameter for the "feed" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-feedpagecontent' => 'Option the enable page content to be generated with the feed',
	'smw-label-feed-link' => 'This is the text of the link that is triggering the results export to a RSS-file when clicked. {{optional}}',
	'smw-label-feed-description' => 'Parameters:
* $1 is a feed description.
* $2 is a feed type.',
	'smw_iq_disabled' => 'This is an information message.',
	'smw_iq_moreresults' => 'This is the text of the link that points to further results in case the [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline query] has more than currently displayed on the page. See also message {{msg-mw|Smw-paramdesc-searchlabel}}.',
	'smw_parseerror' => 'This is an error/warning message.',
	'smw_decseparator' => "{{optional}}
This message is as a separator symbol for decimal digits in numbers, like \".\" in English 1,234.23. It is used for formatting number output '''and''' for reading user input. Therefore it should be carefully considered whether to change an existing value, since existing installations may depend on this value for their content to be read properly.

Note that spaces and space-like HTML entities are always ignored when reading numbers.",
	'smw_kiloseparator' => "{{optional}}
This message is as a separator symbol for thousands in numbers, like \",\" in English 1,234.23. It is used for formatting number output '''and''' for reading user input. Therefore it should be carefully considered whether to change an existing value, since existing installations may depend on this value for their content to be read properly.

Note that spaces and space-like HTML entities are always ignored when reading numbers, whether or not a space symbol is used here.",
	'smw_notitle' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_noproperty' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_wrong_namespace' => 'This is an error/warning message. $1 holds the name of the namespace that may be used.',
	'smw_manytypes' => 'This is an error/warning message.',
	'smw_emptystring' => 'This is an error/warning message.',
	'smw_maxstring' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_notinenum' => 'This is an error/warning message. $1 holds the property value causing the error/warning. $2 holds the property values that may be used.',
	'smw_noboolean' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_true_words' => 'These are the boolean values for "true" which may be assigned to properties of datatype [http://semantic-mediawiki.org/wiki/Help:Type_Boolean Boolean], given as a comma separated list. See also message {{msg-mw|Smw_false_words}}.',
	'smw_false_words' => 'These are the boolean values for "false" which may be assigned to properties of datatype [http://semantic-mediawiki.org/wiki/Help:Type_Boolean Boolean], given as a comma separated list. See also message {{msg-mw|Smw_true_words}}.',
	'smw_nofloat' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_infinite' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_unitnotallowed' => 'This is an error/warning message. $1 holds the unit causing the error/warning.',
	'smw_nounitsdeclared' => 'This is an error/warning message.',
	'smw_novalues' => 'This is an error/warning message.',
	'smw_nodatetime' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_toomanyclosing' => 'This is an error/warning message. $1 holds the string causing the error/warning.',
	'smw_noclosingbrackets' => 'This is an error/warning message.',
	'smw_misplacedsymbol' => 'This is an error/warning message. $1 holds the string causing the error/warning.',
	'smw_unexpectedpart' => 'This is an error/warning message. $1 holds the string causing the error/warning.',
	'smw_emptysubquery' => 'This is an error/warning message.',
	'smw_misplacedsubquery' => 'This is an error/warning message.',
	'smw_valuesubquery' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_badqueryatom' => 'This is an error/warning message.',
	'smw_propvalueproblem' => 'This is an error/warning message. $1 holds the property value causing the error/warning.',
	'smw_noqueryfeature' => 'This is an error/warning message. $1 holds the part(s) of the query which were dropped.',
	'smw_noconjunctions' => 'This is an error/warning message. $1 holds the part(s) of the query which were dropped.',
	'smw_nodisjunctions' => 'This is an error/warning message. $1 holds the part(s) of the query which were dropped.',
	'smw_querytoolarge' => 'This is an error/warning message. $1 holds the part(s) of the query which were dropped.',
	'smw_notemplategiven' => 'This is an error/warning message.',
	'smw_db_sparqlqueryproblem' => 'This is an error message.',
	'smw_db_sparqlqueryincomplete' => 'This is an error message.',
	'smw_type_header' => 'This is the header on [[Special:Types]]. $1 holds the name of the respective datatype.',
	'smw_typearticlecount' => 'This is the introductory message below the header on [[Special:Types]]. $1 holds the number of property pages displayed in the current view.',
	'smw_attribute_header' => 'This is the header on a page in namespace "Property". $1 holds the name of the respective property.',
	'smw_attributearticlecount' => 'This is the introductory message below the header on a page in namespace "Property". $1 holds the number of property pages displayed in the current view.',
	'smw_subproperty_header' => 'This is the header for subproperties on a page in namespace "Property". $1 holds the name of the respective subproperty.',
	'smw_subpropertyarticlecount' => 'This is the introductory message for subproperties below the header for subproperties on pages in namespace "Property". $1 holds the number of subproperty pages displayed in the current view.',
	'smw_concept_header' => 'This is the header on a page in namespace "Concept". $1 holds the name of the respective concept.',
	'smw_conceptarticlecount' => 'This is the introductory message below the header on pages in namespace "Concept". $1 holds the number of pages displayed in the current view.',
	'specialpages-group-smw_group' => 'This is the name of the group of extensions on [[Special:Version]] which are related to or dependant on Semantic MediaWiki.

{{optional}}',
	'exportrdf' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:ExportRDF]].',
	'smw_exportrdf_docu' => 'This is the introductory message at the top of [[Special:ExportRDF]].',
	'smw_exportrdf_recursive' => 'This is the text describing an option available to choose from on [[Special:ExportRDF]].',
	'smw_exportrdf_backlinks' => 'This is the text describing an option available to choose from on [[Special:ExportRDF]].',
	'smw_exportrdf_lastdate' => 'This is the text describing an optional input field available on [[Special:ExportRDF]].',
	'smw_exportrdf_submit' => 'This is the name of the submit button on [[Special:ExportRDF]] to trigger the export.

{{Identical|Export}}',
	'uriresolver' => 'This is the name of [[Special:URIResolver]].',
	'properties' => 'This is the title of the special page on [[Special:SpecialPages]] showing all properties.

{{Identical|Property}}',
	'smw_properties_docu' => 'This is the introductory message at the top of [[Special:Properties]].',
	'smw_property_template' => 'Used on [[Special:Properties]]
* $1 link to Property page
* $2 link to Type page
* $3 Number of times the property is used', # Fuzzy
	'smw_property_template_notype' => 'This is used on [[Special:Properties]].
*$1 holds the link to the property page.
*$2 holds the number of times the property is used within the wiki.
{{optional}}',
	'smw_propertylackspage' => 'This is an error/warning message.',
	'smw_propertylackstype' => 'This is an error/warning message. $1 holds the name of the assumed datatype which is in fact always datatype Page.',
	'smw_propertyhardlyused' => 'This is an error/warning message.',
	'unusedproperties' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:UnusedProperties]].',
	'smw_unusedproperties_docu' => 'This is the introductory message at the top of [[Special:UnusedProperties]].',
	'smw_unusedproperty_template' => 'Used on [[Special:UnusedProperties]]
* $1 is the name of the [http://semantic-mediawiki.org/wiki/Help:Properties_and_types property]
* $2 is the name of the [http://semantic-mediawiki.org/wiki/Help:Properties_and_types#Datatypes_for_properties datatype] assigned to the property.',
	'wantedproperties' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:WantedProperties]].',
	'smw_wantedproperties_docu' => 'This is the introductory message at the top of [[Special:WantedProperties]].',
	'smw_wantedproperty_template' => 'This is the message on [[Special:WantedProperties]] showing the name of the property without an assigned datatype and how often it is used in the wiki. $1 holds the name of the wanted property. $2 holds the number of values annotated with the wanted property.',
	'smw_purge' => 'This is the label of a tab of an action item for the content area.',
	'types' => 'This is the title of the special page on [[Special:SpecialPages]] showing all datatypes.

{{Identical|Type}}',
	'smw_types_docu' => 'This is the introductory message at the top of [[Special:Types]].',
	'smw-special-types-no-such-type' => 'Error message shown on [[Special:Types]] when specifying an invalid data type.',
	'semanticstatistics' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:SemanticStatistics]].',
	'smw_semstats_text' => 'This it the contents of [[Special:SemanticStatistics]]. $1 to $4 hold numerical values.',
	'smw_uri_doc' => "This message sketches the (very technical) function of this unlisted special page.
It probably does not need translation in most cases. The special page as such is used in all URIs used by Semantic MediaWiki.
When somebody resolves such a URI, the special page will redirect to the according wiki page or to the according metadata export (OWL/RDF/XML).
This is controlled by the HTTP request header. Semantic Web crawlers and browsers can thus request more metadata on a particular subject, while humans are referred to readable pages.
This method is called ''content negotiation''.

{{doc-important|Do not alter or translate link targets!}}",
	'ask' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:Ask]].',
	'smw_ask_doculink' => "{{notranslate}}
This message should be the URL of the semantic query documentation for that language. For English, this is http://semantic-mediawiki.org/wiki/Help:Semantic_search. For other languages, it should be an ''existing'' page on semantic-mediawiki.org. Note that only some languages have own documentations yet. 

The SMW Project welcomes documentation translators! Please contact Markus Krötzsch (http://semantic-mediawiki.org/wiki/Markus) for getting a login at semantic-mediawiki.org if you wish to create SMW handbooks in another language.",
	'smw_ask_sortby' => 'This is the text describing the textbox on [[Special:Ask]] available for optionally entering an printout statement for a query.',
	'smw_ask_ascorder' => 'This is the value in a dropdown menu on [[Special:Ask]] available for selecting an printout statement for a query.',
	'smw_ask_descorder' => 'This is the value in a dropdown menu on [[Special:Ask]] available for selecting an printout statement for a query.',
	'smw_ask_submit' => 'This is the name of the submit button on [[Special:Ask]] to start the semantic search.

{{Identical|Find results}}',
	'smw_ask_editquery' => 'This is the text of the action link on [[Special:Ask]] to edit a query.',
	'smw_add_sortcondition' => 'This is the text of the action link on [[Special:Ask]] to add an printout statement to a query.',
	'smw_ask_hidequery' => 'This is the text of the action link on [[Special:Ask]] to abandon a query.',
	'smw_ask_help' => 'This is the text of a link on [[Special:Ask]] pointing to the help page on [http://semantic-mediawiki.org/wiki/Help:Semantic_search semantic search].',
	'smw_ask_queryhead' => 'This is the header of the edit field available on [[Special:Ask]] to enter the [http://semantic-mediawiki.org/wiki/Help:Selecting_pages query conditions] of the query.',
	'smw_ask_printhead' => 'This is the header of the edit field available on [[Special:Ask]] to enter the [http://semantic-mediawiki.org/wiki/Help:Displaying_information printout statements] of the query.',
	'smw_ask_printdesc' => 'This is an additional information message for the header of the edit field available on [[Special:Ask]] to enter the [http://semantic-mediawiki.org/wiki/Help:Displaying_information printout statements] of the query.',
	'smw_ask_format_as' => 'This is the text describing a dropdown box on [[Special:Ask]] available for choosing the [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for a query.',
	'smw_ask_defaultformat' => 'This is the label used for indicating the default [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] within a dropdown field.

{{Identical|Default}}',
	'smw_ask_otheroptions' => 'This is the text for the header of a section on [[Special:Ask]] that is containing various different options to choose or enter in order to specify printout statements of a query.',
	'smw-ask-otheroptions-info' => "This is the text describing the section ''Other options'' on [[Special:Ask]] that is containing various different options to choose or enter in order to specify printout statements of a query.",
	'smw-ask-otheroptions-collapsed-info' => 'Please use the plus icon to view all available options',
	'smw_ask_show_embed' => 'This is the text of the action link on [[Special:Ask]] to show the code of a query.',
	'smw_ask_hide_embed' => 'This is the text of the action link on [[Special:Ask]] to hide the code of a query.',
	'smw_ask_embed_instr' => 'This is an information message for the field on [[Special:Ask]] that contains the code of a query that may be copied and when pasted into a regular page on the wiki..',
	'smw-ask-delete' => 'This is the text of the action link on [[Special:Ask]] to delete an printout statement from a query.',
	'smw-ask-sorting' => 'This is the text for the header of the section on [[Special:Ask]] that allows to specify sorting options for specific properties that are queried for.',
	'smw-ask-format-selection-help' => 'This is a text displayed on [[Special:Ask]] to inform about a help page on [http://semantic-mediawiki.org/wiki/ Semantic MediaWiki]',
	'querycreator' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:QueryCreator]].',
	'smw_qc_addmainlabel' => 'This is the text of the action link on [[Special:QueryCreator]].',
	'smw_qc_show_addnal_opts' => 'This is the text of the action link on [[Special:QueryCreator]] to show the input and selection areas for printout statements of a query.',
	'smw_qc_hide_addnal_opts' => 'This is the text of the action link on [[Special:QueryCreator]] to hide the input and selection areas for printout statements of a query.',
	'smw_qc_otheropt' => 'This is the text for the header of the section on [[Special:QueryCreator]] containing various different universal options to choose or enter in order to specify printout statements of a query.',
	'smw_qc_intro' => 'This is the text describing the textbox on [[Special:QueryCreator]] available for optionally entering an printout statement for a query (parameter "intro" - text that is prepended to the output, if at least one result exists).',
	'smw_qc_outro' => 'This is the text describing the textbox on [[Special:QueryCreator]] available for optionally entering an printout statement for a query (parameter "outro" - text that is appended to the output, if at least one result exists).',
	'smw_qc_default' => 'This is the text describing the textbox on [[Special:QueryCreator]] available for optionally entering an printout statement for a query (parameter "default" - text that is printed in case no result exists).',
	'smw_qc_formatopt' => 'This is the text for the header of the section on [[Special:QueryCreator]] containing various different format specific options to choose or enter in order to specify printout statements of a query.',
	'smw_qc_query_help' => 'This is the introductory message at the top of [[Special:QueryCreator]] containing a simple example.

{{doc-important|You may translate/localise "Actor", "Located in" and "Germany".}}',
	'smw_qui_property' => 'This is the text describing a textbox on [[Special:QueryCreator]] where a property is expected to be typed in.

{{Identical|Property}}',
	'smw_qui_prop' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where a property is expected to be typed in.

{{Identical|Property}}',
	'smw_qui_labl' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where the label for a property is expected to be typed in.

{{Identical|Label}}',
	'smw_qui_formt' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where the format for property is expected to be typed in.

{{Identical|Format}}',
	'smw_qui_limt' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where the limit for results of a property is expected to be typed in.

{{Identical|Limit}}',
	'smw_qui_shownresults' => 'This is the message next to a checkbox on [[Special:QueryCreatory]] indicating if an item should be shown in the results or not.',
	'smw_qui_noquery' => 'This is an error message on [[Special:QueryCreatory]].',
	'smw_qui_invalidprop' => 'This is an error/warning message on [[Special:QueryCreatory]]. $1 holds the property name.',
	'smw_qui_invalidformat' => 'This is an error/warning message on [[Special:QueryCreatory]]. $1 holds the name of the result format.',
	'smw_qui_nosort' => 'This is an option in a drop-down menu on [[Special:QueryCreatory]] indicating that user does not want any sorting to be done by the given property.',
	'smw_qui_ascorder' => 'This is an option in a drop-down menu on [[Special:QueryCreatory]] indicating that user wants to sort the results in ascending order by the given property.',
	'smw_qui_descorder' => 'This is an option in a drop-down menu on [[Special:QueryCreatory]] indicating that user wants to sort the results in descending order by the given property.',
	'smw_qui_randorder' => 'This is an option in a drop-down menu on [[Special:QueryCreatory]] indicating that user wants to sort the results in random order by the given property.',
	'smw_qui_addnprop' => 'This is the text of the action link on [[Special:QueryCreator]] which shows an new form to add another property to a query when clicked.',
	'smw_qui_delete' => 'This is the text of the action link on [[Special:QueryCreator]] which allows to remove the respective query option when clicked.

{{Identical|Remove}}',
	'smw_qui_rescol' => 'Label for the main result column. See http://semantic-mediawiki.org/wiki/Help:Displaying_information#The_main_result_column/ for further information. The text appears as a label next to an text-box',
	'smw_qui_options' => 'This is the text for the header of the section on [[Special:QueryCreator]] allowing to specify various options for the printout statements of a query.

{{Identical|Options}}',
	'smw_qui_addcategory' => 'This is the text of the action link on [[Special:QueryCreator]] which shows an new form to add another category to a query when clicked.',
	'smw_qui_addrescol' => 'This is the text of the action link on [[Special:QueryCreator]] which shows an new form to add query-matches to a query when clicked.',
	'smw_qui_ok' => 'This is the label of the Ok button within a modal pop-up window on [[Special:QueryCreator]] to submit the entries when clicked.

{{Identical|OK}}',
	'smw_qui_cancel' => 'This is the label of the Cancel button within a modal pop-up window on [[Special:QueryCreator]] to abandon the entries when clicked.

{{Identical|Cancel}}',
	'smw_qui_category' => 'This is the text describing a textbox on [[Special:QueryCreator]] where a category is expected to be typed in.

{{Identical|Category}}',
	'smw_qui_label' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where the label for a category is expected to be typed in.

{{Identical|Label}}',
	'smw_prp_options' => 'This is the title of a modal pop-up window on [[Special:QueryCreator]] where options for a property are expected to be typed in.',
	'smw_qui_catopts' => 'This is the title of a modal pop-up window on [[Special:QueryCreator]] where options for a category are expected to be typed in.',
	'smw_qui_mainlabopts' => 'This is the title of a modal pop-up window on [[Special:QueryCreator]] where options for results are expected to be typed in.',
	'smw_qui_dlabel' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where the label for a category is expected to be typed in.

{{Identical|Label}}',
	'smw_qui_dcategory' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where a category is expected to be typed in.

{{identical|Category}}',
	'smw_qui_dcatyes' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where the text to be shown in case a category is present is expected to be typed in.',
	'smw_qui_dcatno' => 'This is the text describing a textbox within a modal pop-up window on [[Special:QueryCreator]] where the text to be shown in case a category is absent is expected to be typed in.',
	'searchbyproperty' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:SearchByProperty]].',
	'smw_sbv_docu' => 'This is the information message shown on [[Special:SearchByProperty]] in case no property and no property value were not yet provided to search for.',
	'smw_sbv_novalue' => 'This is an information message shown on [[Special:SearchByProperty]] in case no property value was provided. $1 holds the name of the property.',
	'smw_sbv_displayresult' => 'This is an information message shown on [[Special:SearchByProperty]] in case more than 20 results were found. $1 holds the name of the property and $2 holds the value of the property one searched for.',
	'smw_sbv_displayresultfuzzy' => 'This is an information message shown on [[Special:SearchByProperty]] in case less than 20 results were found. $1 holds the name of the property and $2 holds the value of the property one searched for.',
	'smw_sbv_property' => 'This is the text describing a textbox on [[Special:SearchByProperty]] where the name of a property is expected to be typed in.

{{Identical|Property}}',
	'smw_sbv_value' => 'This is the text describing a textbox on [[Special:SearchByProperty]] where the value of a property is expected to be typed in.

{{Identical|Value}}',
	'smw_sbv_submit' => 'This is the name of the submit button on [[Special:SearchByProperty]] to trigger the search.

{{Identical|Find results}}',
	'browse' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:Browse]].',
	'smw_browselink' => 'This is the text of the link shown within the toolbox in the sidebar pointing to [[Special:Browse]]',
	'smw_browse_article' => 'This is the text describing a textbox on [[Special:Browse]] where the name of a page is expected to be typed in.',
	'smw_browse_go' => 'This is the name of the submit button on [[Special:Browse]] to trigger the browsing of pages.

{{Identical|Go}}',
	'smw_browse_more' => '{{optional}}',
	'smw_browse_show_incoming' => 'This is the text of the link on [[Special:Browse]] that shows the properties linking to a page when clicked.',
	'smw_browse_hide_incoming' => 'This is the text of the link on [[Special:Browse]] that hides the properties linking to a page when clicked.',
	'smw_browse_no_outgoing' => 'This is the information message shown on [[Special:Browse]] in case the browsed page does not contain any properties.',
	'smw_browse_no_incoming' => 'This is the information message shown on [[Special:Browse]] in case no properties link to the browsed page.',
	'smw_inverse_label_default' => 'Inverse label default, $1 is a place marker',
	'smw_inverse_label_property' => 'Can as well be translated as "Name of", or "Denomination of the inverse propery". The inverse property is one having both its direction, and its source/target sets inverted. For example, the property "is child of" is the inverse propery of "is parent of".',
	'pageproperty' => 'This is the name of [[Special:PageProperty]].',
	'smw_pp_docu' => 'This is the introductory message at the top of [[Special:PageProperty]].',
	'smw_pp_from' => 'This is the text describing a textbox on [[Special:PageProperty]] where the name of a page is expected to be typed in.',
	'smw_pp_type' => 'This is the text describing a textbox on [[Special:PageProperty]] where the name of a property is expected to be typed in.

{{Identical|Property}}',
	'smw_pp_submit' => 'This is the name of the submit button on [[Special:PageProperty]] to trigger the search.

{{Identical|Find results}}',
	'smw_result_prev' => 'This is the text of the link on [[Special:Ask]] or [[Special:SearchByProperty]] that allows to return to the previous page containing results for the query.

{{Identical|Previous}}',
	'smw_result_next' => 'This is the text of the link on [[Special:Ask]] or [[Special:SearchByProperty]] that allows to proceed to the next page containing results for the query.

{{Identical|Next}}',
	'smw_result_results' => "This is the text on [[Special:Ask]] or [[Special:SearchByProperty]] preceding the shown range of results which were returned by the query, e.g. '''Results 1 - 50'''.

{{Identical|Result}}",
	'smw_result_noresults' => 'This is the text on [[Special:Ask]] or [[Special:SearchByProperty]] shown in case a query does not return any results.

{{Identical|Sorry, no results}}',
	'smwadmin' => 'This is the link text on [[Special:SpecialPages]] pointing to [[Special:SMWAdmin]].',
	'smw_smwadmin_setupsuccess' => "This is the confirmation message at the bottom of the script's report concerning setup or update of the SMW database tables (process triggered from [[Special:SMWAdmin]]).",
	'smw_smwadmin_return' => 'This is the text of the link at the bottom of the report concerning setup or update of the SMW database tables pointing to [[Special:SMWAdmin]]. $1 holds the link back to Special:SMWAdmin.

{{Identical|Return to $1}}',
	'smw_smwadmin_updatestarted' => 'This is the message at the top of [[Special:SMWAdmin]] confirming that the update process has been started. $1 holds the link back to Special:SMWAdmin.

{{Identical|Return to $1}}',
	'smw_smwadmin_updatenotstarted' => 'This is the message at the top of [[Special:SMWAdmin]] informing that a new update process will not be started. $1 holds the link back to Special:SMWAdmin.

{{Identical|Return to $1}}',
	'smw_smwadmin_updatestopped' => 'This is the message at the top of [[Special:SMWAdmin]] confirming that the update process has been stopped. $1 holds the link back to Special:SMWAdmin.

{{Identical|Return to $1}}',
	'smw_smwadmin_updatenotstopped' => 'This is the message at the top of [[Special:SMWAdmin]] asking for reassurance concerning the termination of the current update process. $1 holds the link back to Special:SMWAdmin.

{{Identical|Return to $1}}',
	'smw_smwadmin_docu' => 'This is the introductory message at the top of [[Special:SMWAdmin]].',
	'smw_smwadmin_db' => 'This is a section header on [[Special:SMWAdmin]].',
	'smw_smwadmin_dbdocu' => 'This is the text describing an available administrative option on [[Special:SMWAdmin]].',
	'smw_smwadmin_permissionswarn' => 'This is the text describing a problem (including a solution) that may arise when using an available administrative option on [[Special:SMWAdmin]].',
	'smw_smwadmin_dbbutton' => 'This is the name of the submit button on [[Special:SMWAdmin]] to trigger the respective process.',
	'smw_smwadmin_announce' => 'This is the section header on [[Special:SMWAdmin]] as well as the name of the submit button to register the wiki at [http://semantic-mediawiki.org/wiki/Special:SMWRegistry semantic-mediawiki.org].',
	'smw_smwadmin_announcedocu' => 'This is the text describing an available administrative option on [[Special:SMWAdmin]].

{{doc-important|Do not alter or translate link targets!}}',
	'smw_smwadmin_announcebutton' => 'This is the text describing an available administrative option on [[Special:SMWAdmin]].',
	'smw_smwadmin_datarefresh' => 'This is a section header on [[Special:SMWAdmin]].',
	'smw_smwadmin_datarefreshdocu' => 'This is the text describing an available administrative option on [[Special:SMWAdmin]].',
	'smw_smwadmin_datarefreshprogress' => 'This is an information message on [[Special:SMWAdmin]].',
	'smw_smwadmin_datarefreshbutton' => 'This is the name of the submit button on [[Special:SMWAdmin]] to trigger the respective process.',
	'smw_smwadmin_datarefreshstop' => 'This is the name of the submit button on [[Special:SMWAdmin]] to abort the respective process.',
	'smw_smwadmin_datarefreshstopconfirm' => 'This is the text next to the checkbox on [[Special:SMWAdmin]] reassuring that the respective process should indeed be cancelled.',
	'smw_smwadmin_support' => 'This is a section header on [[Special:SMWAdmin]].',
	'smw_smwadmin_supportdocu' => 'This is the introductory text on [[Special:SMWAdmin]] followed by a list of resources.',
	'smw_smwadmin_installfile' => 'This text on [[Special:SMWAdmin]] describes a resource for help.

{{doc-important|Do not alter or translate link targets!}}',
	'smw_smwadmin_smwhomepage' => 'This text on [[Special:SMWAdmin]] describes a resource for help.

{{doc-important|Do not alter or translate link targets!}}',
	'smw_smwadmin_mediazilla' => 'This text on [[Special:SMWAdmin]] describes where to report bugs.

{{doc-important|Do not alter or translate link targets!}}',
	'smw_smwadmin_questions' => 'This text on [[Special:SMWAdmin]] describes a resource for help.

{{doc-important|Do not alter or translate link targets!}}',
	'smw_adminlinks_datastructure' => 'This is a section header on [[Special:AdminLinks]] which is needed for the integration of the [https://www.mediawiki.org/wiki/Extension:Admin_Links Admin Links extension] into this extension.',
	'smw_adminlinks_displayingdata' => 'This is a section header on [[Special:AdminLinks]] which is needed for the integration of the [https://www.mediawiki.org/wiki/Extension:Admin_Links Admin Links extension] into this extension.',
	'smw_adminlinks_inlinequerieshelp' => 'This is the link text for a link on [[Special:AdminLinks]] which is needed for the integration of the [https://www.mediawiki.org/wiki/Extension:Admin_Links Admin Links extension] into this extension.',
	'smw-createproperty-isproperty' => 'This an information message at the top on a page in namespace "Property". $1 holds the name of the datatype which was assigned to the respective property.',
	'smw-createproperty-allowedvals' => 'This an information message at the top on a page in namespace "Property" which gets inserted in case only certain property values are [http://semantic-mediawiki.org/wiki/Help:Special_property_Allows_value allowed to be used] for the respective property.',
	'smw-paramdesc-category-delim' => 'This is the description of the "delim" parameter of the "category" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-category-template' => 'This is the description of the "template" parameter of the "category" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-paramdesc-category-userparam' => 'This is the description of the "userparam" parameter of the "category" [http://semantic-mediawiki.org/wiki/Help:Result_formats result format] for [http://semantic-mediawiki.org/wiki/Help:Inline_queries inline queries].',
	'smw-info-par-message' => 'This is the description of the "message" parameter of the parser function "[http://semantic-mediawiki.org/wiki/Help:Adding_tooltips #info]".',
	'smw-info-par-icon' => 'This is the description of the "icon" parameter of the parser function "[http://semantic-mediawiki.org/wiki/Help:Adding_tooltips #info]".

{{doc-important|Do not translate the possible parameter values "info" and "warning".}}',
	'prefs-smw' => 'This is the text of a section header on [[Special:Preferences#mw-prefsection-smw|Special:Preferences]].',
	'prefs-ask-options' => 'This is the text of a header within a section on [[Special:Preferences#mw-prefsection-smw|Special:Preferences]].',
	'smw-prefs-intro-text' => 'This is an user preference intro text on [[Special:Preferences#mw-prefsection-smw|Special:Preferences]].',
	'smw-prefs-ask-options-tooltip-display' => 'This is the text describing an user option on [[Special:Preferences#mw-prefsection-smw|Special:Preferences]].',
	'smw-prefs-ask-options-collapsed-default' => 'This is the text describing an user option on [[Special:Preferences#mw-prefsection-smw|Special:Preferences]].',
	'smw-ui-tooltip-title-property' => 'Is a label that is displayed on the info tooltip',
	'smw-ui-tooltip-title-quantity' => 'Is a label that is displayed on the info tooltip',
	'smw-ui-tooltip-title-info' => 'Is a label that is displayed on the info tooltip',
	'smw-ui-tooltip-title-service' => 'Is a label that is displayed on the info tooltip',
	'smw-ui-tooltip-title-warning' => 'Is a label that is displayed on the info tooltip',
	'smw-ui-tooltip-title-parameter' => 'Is a label that is displayed on the info tooltip',
	'smw-ui-tooltip-title-event' => 'Is a label that is displayed on the info tooltip',
	'smw_unknowntype' => 'Error message shown for properties that have a type unknown to the system',
);

/** Afrikaans (Afrikaans)
 * @author Arnobarnard
 * @author Naudefj
 */
$messages['af'] = array(
	'smw_finallistconjunct' => ', en',
	'smw_factbox_head' => 'Feite oor $1',
	'smw_isspecprop' => "Hierdie eienskap is 'n spesiale eienskap van hierdie wiki.",
	'smw_printername_template' => 'Sjabloon',
	'smw_parseerror' => 'Die gegewe waarde is onverstaanbaar.',
	'smw_manytypes' => 'Meer as een tipe gedefinieer vir eienskap.',
	'smw_emptystring' => 'Leë stringe word nie aanvaar nie.',
	'smw_true_words' => 'waar,w,ja,j',
	'smw_false_words' => 'vals,v,nee,n',
	'smw_nofloat' => '"$1" is nie \'n nommer nie.',
	'smw_nodatetime' => 'Die datum "$1" kon nie verwerk word nie.',
	'smw_emptysubquery' => "'n Sub-navraag het geen geldige kondisie.",
	'smw_exportrdf_submit' => 'Eksporteer',
	'smw_propertyhardlyused' => 'Hierdie eienskap word skaars gebruik in hierdie wiki!',
	'smw_unusedproperty_template' => '$1 van tipe $2',
	'smw_wantedproperty_template' => '$1 ($2 gebruike)', # Fuzzy
	'smw_purge' => 'Verfris',
	'types' => 'Tipes',
	'smw_ask_sortby' => 'Sorteer volgens kolom (optioneel)',
	'smw_ask_ascorder' => 'Toenemend',
	'smw_ask_descorder' => 'Afnemend',
	'smw_ask_submit' => 'Vind resultate',
	'smw_ask_editquery' => '[Wysig navraag]',
	'smw_ask_hidequery' => 'Versteek navraag',
	'smw_ask_help' => 'Navraag hulp',
	'smw_ask_queryhead' => 'Navraag',
	'smw_ask_printhead' => 'Addisionele uitdrukke (optioneel)', # Fuzzy
	'smw_ask_defaultformat' => 'standaard',
	'searchbyproperty' => 'Soek volgens eienskap',
	'smw_sbv_property' => 'Eienskap:',
	'smw_sbv_value' => 'Waarde:',
	'smw_sbv_submit' => 'Vind resultate',
	'smw_browse_go' => 'Laat waai',
	'smw_pp_from' => 'Vanaf bladsy',
	'smw_pp_type' => 'Eienskap',
	'smw_pp_submit' => 'Vind resultate',
	'smw_result_prev' => 'Vorige',
	'smw_result_next' => 'Volgende',
	'smw_result_results' => 'Resultate',
	'smw_result_noresults' => 'Geen resultate.',
	'smw_unknowntype' => 'Onondersteunde tipe "$1" gedefinieer vir eienskap.', # Fuzzy
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'smw_isspecprop' => 'Kjo pronë është një veti të veçantë në këtë wiki.',
	'smw_concept_description' => 'Përshkrimi i konceptit "$1"',
	'smw_no_concept_namespace' => 'Konceptet mund të përcaktohet në faqet në Konceptin: hapësira.',
	'smw_multiple_concepts' => 'Çdo faqe koncept mund të ketë vetëm një përkufizim koncept.',
	'smw_concept_cache_miss' => 'Koncepti "$1" nuk mund të përdoret në këtë moment, që nga konfigurimi Wiki kërkon që ajo të jetë llogaritur off-line. Nëse problemi nuk zhduken pas disa kohë, pyesni administratorin e faqes tuaj për të bërë këtë koncept në dispozicion.',
	'smw_noinvannot' => 'Vlerat nuk mund të vendoset në pronat e anasjelltas.',
	'smw_baduri' => 'URI e formës "$1" nuk lejohen.',
	'smw_printername_count' => 'Rezultatet Count',
	'smw_printername_csv' => 'eksport CSV',
	'smw_printername_debug' => 'query Debug (për ekspertët)',
	'smw_printername_embedded' => 'Embed faqe Përmbajtja',
	'smw_printername_json' => 'eksport JSON',
	'smw_printername_list' => 'Listë',
	'smw_printername_ol' => 'Renditje',
	'smw_printername_ul' => 'Itemization',
	'smw_printername_rss' => 'eksport RSS',
	'smw_printername_table' => 'Tryezë',
	'smw_printername_broadtable' => 'Tabela Broad',
	'smw_printername_template' => 'Shabllon',
	'smw-paramdesc-limit' => 'Numri maksimal i rezultateve të kthehen',
	'smw-paramdesc-headers' => 'Afisho e titullit / emrat e pronës',
	'smw-paramdesc-mainlabel' => 'Etiketë për të dhënë për emrin kryesore faqe',
	'smw-paramdesc-link' => 'Show vlerat si link',
	'smw-paramdesc-intro' => 'Teksti që do shfaqet para se rezultatet e pyetjes, nëse ka ndonjë',
	'smw-paramdesc-outro' => 'Teksti që do shfaqet pas rezultatet e pyetjes, nëse ka ndonjë',
	'smw-paramdesc-default' => 'Teksti që do shfaqet në qoftë se nuk ka rezultate query',
	'smw-paramdesc-sep' => 'Ndarës për vlerat e',
	'smw-paramdesc-template' => 'Emri i një template me të cilin për të shfaqur shkresat e',
	'smw-paramdesc-columns' => 'Numri i rreshtave në të cilat për të shfaqur rezultate (default është $1)',
	'smw-paramdesc-embedformat' => 'HTML tag përdoret për të definuar tituj',
	'smw-paramdesc-embedonly' => 'Afisho nuk ka tituj',
	'smw-paramdesc-rsstitle' => "Teksti për t'u përdorur si titulli i feed",
	'smw-paramdesc-rssdescription' => 'Teksti që do të përdoret si përshkrim i feed',
	'smw-paramdesc-searchlabel' => 'Teksti në lidhje me rezultatet e', # Fuzzy
	'smw_iq_disabled' => 'pyetje Semantic kanë qenë të paaftë për këtë wiki.',
	'smw_iq_moreresults' => 'Rezultatet e ... më tej',
	'smw_parseerror' => 'Vlera e dhënë nuk është kuptuar.',
	'smw_notitle' => '"$1" nuk mund të përdoret si një emër faqe në këtë wiki.',
	'smw_wrong_namespace' => 'Vetëm faqet në hapësirën "$1" lejohen këtu.',
	'smw_unknowntype' => 'Lloj i pasuportuar "$1" të përcaktuara për pronën.', # Fuzzy
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'smw_result_next' => 'ቀጥሎ',
);

/** Aragonese (aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'smw_printername_template' => 'Plantilla',
	'smw_nodatetime' => 'No s\'ha entendito a calendata "$1".',
);

/** Arabic (العربية)
 * @author Mahmoud Zouari  mahmoudzouari@yahoo.fr http://www.cri.ensmp.fr
 * @author Meno25
 * @author OsamaK
 * @author Ouda
 * @author روخو
 */
$messages['ar'] = array(
	'smw-desc' => "جعل الويكي الخاص بك أكثر قابلية للوصول - للآلات ''و'' البشر ([http://semantic-mediawiki.org/wiki/Help:User_manual توثيق على الإنترنت])",
	'smw_viewasrdf' => 'تلقيم RDF',
	'smw_finallistconjunct' => '، و',
	'smw_factbox_head' => 'حقائق عن $1',
	'smw_isspecprop' => 'هذه الخاصية هى خاصية خاصة في هذا الويكي.',
	'smw_concept_description' => 'وصف المبدأ "$1"',
	'smw_no_concept_namespace' => 'المبادئ يمكن تعريفها فقط في الصفحات في نطاق Concept:',
	'smw_multiple_concepts' => 'كل صفحة مبدأ يمكن أن تحتوي على تعريف مبدأ واحد.',
	'smw_concept_cache_miss' => 'المبدأ "$1" لا يمكن استخدامه حاليا، بما أن ضبط الويكي يحتاجه إلى أن يتم حسابه خارجيا. لو أن المشكلة لم تنته بعد بعض الوقت، سل إداري موقعك ليجعل هذا المبدأ متوفرا.',
	'smw_noinvannot' => 'القيم لا يمكن تعيينها لخصائص معكوسة.',
	'smw_baduri' => 'URIs من النوع "$1" غير مسموح بها.',
	'smw_rss_link' => 'آر إس إس',
	'smw_csv_link' => 'سي في إس',
	'smw_json_link' => 'جسون',
	'smw_rdf_link' => 'آر دي إف',
	'smw_printername_count' => 'عد النتائج',
	'smw_printername_csv' => 'تصدير CSV',
	'smw_printername_debug' => 'استعلام التصليح (للخبراء)',
	'smw_printername_embedded' => 'تضمين محتويات الصفحة',
	'smw_printername_json' => 'تصدير JSON',
	'smw_printername_list' => 'قائمة',
	'smw_printername_ol' => 'ترقيم',
	'smw_printername_ul' => 'ترتيب في عناصر',
	'smw_printername_rss' => 'تصدير RSS',
	'smw_printername_table' => 'جدول',
	'smw_printername_broadtable' => 'جدول عريض',
	'smw_printername_template' => 'قالب',
	'smw-paramdesc-limit' => 'الرقم الأقصى للعناصر المُرجعة',
	'smw-paramdesc-headers' => 'اعرض العناوين/أسماء الخصائص',
	'smw-paramdesc-mainlabel' => 'العلامة للإعطاء لاسم الصفحة الرئيسية',
	'smw-paramdesc-link' => 'أظهر القيم كوصلات',
	'smw-paramdesc-intro' => 'النص للعرض قبل نتائج الاستعلام، لو كانت هناك أي',
	'smw-paramdesc-outro' => 'النص المطلوب عرضه بعد نتائج الاستعلام، إن وُجدت',
	'smw-paramdesc-default' => 'النص المطلوب عرضه إذا لم تتوفر نتائج للاستعلام',
	'smw-paramdesc-sep' => 'فاصل القيم',
	'smw-paramdesc-template' => 'اسم القالب لعرض الخرج به',
	'smw-paramdesc-columns' => 'رقم الأعمدة لعرض النتائج بها (افتراضيا $1)',
	'smw-paramdesc-embedformat' => 'وسم HTML المستخدم لتعريف الترويسة',
	'smw-paramdesc-embedonly' => 'لا تظهر الترويسات',
	'smw-paramdesc-rsstitle' => 'النص المستخدم كعنوان للتغذية',
	'smw-paramdesc-rssdescription' => 'النص المستخدم لوصف التغذية',
	'smw-paramdesc-searchlabel' => 'نص وصلة النتائج', # Fuzzy
	'smw_iq_disabled' => 'استعلامات السيمانتيك تم تعطيلها في هذا الويكي.',
	'smw_iq_moreresults' => '… مزيد من النتائج',
	'smw_parseerror' => 'القيمة المعطاة لم يتم فهمها.',
	'smw_kiloseparator' => '،',
	'smw_notitle' => '"$1" لا يمكن أن تستخدم مثل هذا الاسم في صفحة ويكي.',
	'smw_wrong_namespace' => 'فقط الصفحات في النطاق "$1" مسموح بها هنا.',
	'smw_manytypes' => 'أكثر من نوع واحد لتعريف الخاصية.',
	'smw_emptystring' => 'السلاسل الفارغة غير مقبولة.',
	'smw_maxstring' => 'تمثيل السلسلة $1 طويل جدا.',
	'smw_notinenum' => '"$1" ليس ضمن قائمة القيم الممكنة ($2) لهذه الخاصية.',
	'smw_noboolean' => '"$1" غير متعرف عليها كقيمة بووليان (صواب/خطأ).',
	'smw_true_words' => 'صحيح،ص،نعم،ن',
	'smw_false_words' => 'خطأ،خ،لا،ل',
	'smw_nofloat' => 'ليس عددا "$1".',
	'smw_infinite' => 'الأرقام الكبيرة مثل "$1" غير مدعومة.',
	'smw_nodatetime' => 'التاريخ "$1" لم يتم فهمه.',
	'smw_toomanyclosing' => 'يبدو أنه هناك الكثير من "$1" في الاستعلام.',
	'smw_noclosingbrackets' => '"]]" في استعلامك لم تكن مغلقة باستخدام "<nowiki>[[</nowiki>" بعض استخدام',
	'smw_misplacedsymbol' => 'الرمز "$1" تم استخدامه في مكان حيث هو ليس مفيدا.',
	'smw_unexpectedpart' => 'الجزء "$1" من الاستعلام لم يفهم.
النتائج قد لا تكون كما هو متوقع.',
	'smw_emptysubquery' => 'بعض الاستعلامات الفرعية ليس لها شرط صحيح.',
	'smw_misplacedsubquery' => 'بعض الاستعلامات الفرعية تم استخدمها في مكان غير مسموح فيه بالاستعلامات الفرعية.',
	'smw_valuesubquery' => 'الاستعلامات الفرعية غير مدعومة لقيم الخاصية "$1".',
	'smw_badqueryatom' => 'جزء ما "<nowiki>[[…]]</nowiki>" من الاستعلام لم يتم فهمه.',
	'smw_propvalueproblem' => 'قيمة الخاصية "$1" لم يتم فهمها.',
	'smw_noqueryfeature' => 'ميزة استعلام ما لم يتم دعمها في هذا الويكي وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_noconjunctions' => 'الوقوفات في الاستعلامات غير مدعومة في هذا الويكي وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_nodisjunctions' => 'المفارق في استعلامات ليست مدعومة في هذا الويكي وجزء من الاستعلام رفض $1.',
	'smw_querytoolarge' => 'شروط الاستفسار التالية لم يمكن اعتبارها نتيجة لقيود الويكي في حجم أو عمق الاستعلام: $1.',
	'smw_notemplategiven' => 'وفر قيمة للمحدد "template" لتعمل صيغة الاستعلام هذه.',
	'smw_type_header' => 'خصائص النوع "$1"',
	'smw_typearticlecount' => 'عرض {{PLURAL:$1||خاصية واحدة تستخدم|خاصيتين تستخدمان|$1 خصائص تستخدم|$1 خاصية تستخدم}} هذا النوع.',
	'smw_attribute_header' => 'الصفحات التي تستخدم الخاصية "$1"',
	'smw_attributearticlecount' => 'عرض {{PLURAL:$1||الصفحة التي تستخدم|الصفحتين اللتين تستخدمان|الصفحات التي تستخدم}} هذه الخاصية.',
	'smw_subproperty_header' => 'خواص فرعية',
	'smw_subpropertyarticlecount' => 'لهذه الخاصية {{PLURAL:$1||الخاصية الفرعية التالية|الخاصيتين الفرعيتين التاليتين|الخصائص الفرعية التالية}}:',
	'smw_concept_header' => 'صفحات المبدأ "$1"',
	'smw_conceptarticlecount' => 'عرض {{PLURAL:$1||صفحة واحدة تنتمي|صفحتين تنتميان|$1 صفحات تنتمي|$1 صفحة تنتمي}} إلى هذا المبدأ.',
	'smw_rss_description' => '$1 تلقيم آر إس إس',
	'specialpages-group-smw_group' => 'سيمانتيك ميدياويكي',
	'exportrdf' => 'آر دی‌ إف إلى صفحات تصدير',
	'smw_exportrdf_docu' => ' هذه الصفحة تتيح لك الحصول على بيانات من صفحة في شكل آر دی‌ إف.
التصدير إلى صفحات، أدخل العناوين في مربع النص أدناه، عنوان واحد لكل سطر.',
	'smw_exportrdf_recursive' => 'تصدير جميع الصفحات ذات الصلة بشكل تكراري.
علما أنه يمكن أن تكون النتيجة كبيرة!',
	'smw_exportrdf_backlinks' => 'أيضا تصدير كل الصفحات التي تشير إلى الصفحات تم تصديرها.
يولد آر دي إف قابل للتصفح.',
	'smw_exportrdf_lastdate' => 'لا تصدر الصفحات التي لم تتغير منذ نقطة زمنية محددة.',
	'smw_exportrdf_submit' => 'تصدير',
	'uriresolver' => 'محلل URI',
	'properties' => 'الخصائص',
	'smw_properties_docu' => 'الخصائص التالية تستخدم في الويكي.',
	'smw_property_template' => '$1 من نوع $2 ($3)',
	'smw_propertylackspage' => 'جميع الخصائص ينبغي أن توصف بصفحة!',
	'smw_propertylackstype' => 'لا نوع تم تحديده لهذه الخاصية (افتراض النوع $1 حاليا).',
	'smw_propertyhardlyused' => 'هذه الخاصية لا تكاد تستخدم داخل الويكي!',
	'unusedproperties' => 'خصائص غير مستخدمة',
	'smw_unusedproperties_docu' => 'الخصائص التالية موجودة على الرغم من أنه لا صفحة أخرى تستخدمها.',
	'smw_unusedproperty_template' => '$1 من نوع $2',
	'wantedproperties' => 'خصائص مطلوبة',
	'smw_wantedproperties_docu' => 'الخصائص التالية مستخدمة في الويكي ولكن ليس لديها حتى الآن صفحة لوصفها.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|استخدام|استخدام}})',
	'smw_purge' => 'أنعش',
	'types' => 'أنواع',
	'smw_types_docu' => 'التالي قائمة بجميع أنواع البيانات التي يمكن أن تسند إلى الخصائص.
كل نوع بيانات له صفحة حيث يمكن توفير معلومات إضافية.', # Fuzzy
	'semanticstatistics' => 'إحصاءات سيمانتيك',
	'smw_semstats_text' => "هذا الويكي يحتوي على '''$1''' {{PLURAL:$1|قيمة|قيمة}} خاصية بإجمالي '''$2''' [[Special:Properties|{{PLURAL:$2|خاصية|خاصية مختلفة}}]].
'''$3''' {{PLURAL:$3|خاصية تمتلك|خاصية تمتلك}} صفحتها الخاصة، ونوع البيانات المقصود محدد ل'''$4''' من هؤلاء.
بعض الخواص الموجودة ربما تكون [[Special:UnusedProperties|خواص غير مستخدمة]].
الخواص التي مازالت تفتقد صفحة موجودة في [[Special:WantedProperties|قائمة الخواص المطلوبة]].",
	'smw_uri_doc' => 'محلل URI ينفذ <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C على httpRange-14</a>. إنه يتأكد من أن البشر لا يتحولون إلى مواقع ويب.',
	'ask' => 'بحث سيمانتيك',
	'smw_ask_sortby' => 'الترتيب حسب العمود (اختياري)',
	'smw_ask_ascorder' => 'تصاعدي',
	'smw_ask_descorder' => 'تنازلي',
	'smw_ask_submit' => 'جِد نتائجًا',
	'smw_ask_editquery' => '[عدل الاستعلام]',
	'smw_add_sortcondition' => '[أضف شرط ترتيب]',
	'smw_ask_hidequery' => 'إخفاء الاستعلام',
	'smw_ask_help' => 'مساعدة الاستعلام',
	'smw_ask_queryhead' => 'استعلام',
	'smw_ask_printhead' => 'بيانات إضافية للعرض',
	'smw_ask_printdesc' => '(أضف اسمًا مناسبًا واحدًا في كل سطر)',
	'smw_ask_format_as' => 'صياغة ك:',
	'smw_ask_defaultformat' => 'افتراضي',
	'smw_ask_otheroptions' => 'خيارات أخرى',
	'smw_ask_show_embed' => 'عرض الكود المضمن',
	'smw_ask_hide_embed' => 'إخفاء الكود المضمن',
	'smw_ask_embed_instr' => 'لتضمين هذا الاستعلام في صفحة ويكي، استخدم الكود أدناه',
	'smw_qui_labl' => 'علامة:',
	'smw_qui_formt' => 'الصيغة:',
	'smw_qui_limt' => 'الحد:',
	'smw_qui_options' => 'خيارات',
	'smw_qui_ok' => 'موافق',
	'searchbyproperty' => 'البحث حسب الخصائص',
	'smw_sbv_docu' => 'البحث عن كل الصفحات التي لها خصائص معينة وقيمة',
	'smw_sbv_novalue' => 'أدخل قيمة صحيحة للخاصية، أو انظر كل قيم الخصائص ل"$1"',
	'smw_sbv_displayresult' => 'قائمة بكل الصفحات التي بها الخاصية "$1" بالقيمة "$2"',
	'smw_sbv_displayresultfuzzy' => 'قائمة بكل الصفحات التي لديها الخاصية "$1" بالقيمة "$2".
بما أنه كانت هناك فقط عدة نتائج، فالقيم المقاربة معروضة أيضا.',
	'smw_sbv_property' => 'خاصية:',
	'smw_sbv_value' => 'قيمة:',
	'smw_sbv_submit' => 'جِد نتائجًا',
	'browse' => 'استعرض يكي',
	'smw_browselink' => 'خصائص التصفح',
	'smw_browse_article' => 'أدخل اسم الصفحة لبدء التصفح منها.',
	'smw_browse_go' => 'اذهب',
	'smw_browse_show_incoming' => 'أظهر الخواص التي تصل هنا',
	'smw_browse_hide_incoming' => 'أخفِ الخواص التي تصل هنا',
	'smw_browse_no_outgoing' => 'هذه الصفحة ليس لديها خصائص.',
	'smw_browse_no_incoming' => 'لا خصائص تصل إلى هذه الصفحة.',
	'smw_inverse_label_default' => '$1 من',
	'smw_inverse_label_property' => 'اعكس علامة الخاصية',
	'pageproperty' => 'بحث خصائص الصفحة',
	'smw_pp_docu' => 'البحث عن جميع قيم خاصية على صفحة معينة.
أدخل صفحة وخاصية.',
	'smw_pp_from' => 'من صفحة',
	'smw_pp_type' => 'الخاصية',
	'smw_pp_submit' => 'جِد نتائجًا',
	'smw_result_prev' => 'السابق',
	'smw_result_next' => 'التالي',
	'smw_result_results' => 'النتائج',
	'smw_result_noresults' => 'لا توجد نتائج.',
	'smwadmin' => 'وظائف إدارية لسيمانتيك ميدياويكي',
	'smw_smwadmin_setupsuccess' => 'تم تنصيب محرك التخزين بنجاح',
	'smw_smwadmin_return' => 'أرجع إلى $1',
	'smw_smwadmin_updatestarted' => 'عملية تحديث جديدة لتحديث بيانات سيمانتيك بدأت.
كل البيانات المخزنة ستتم إعادة بنائها أو إصلاحها عند الحاجة.
أنت يمكنك متابعة تطور التحديث على هذه الصفحة الخاصة.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'يوجد بالفعل عملية تحديث جارية.
لا تنشئ واحدة أخرى.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'كل عمليات التحديث الموجودة تم إيقافها', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'لوقف عملية التحديث الجارية، يجب عليك تفعيل الصندوق لتعبر عن أنك متأكد حقا.', # Fuzzy
	'smw_smwadmin_docu' => 'هذه الصفحة الخاصة تساعدك خلال تنصيب وترقية <a href="http://semantic-mediawiki.org">سيمانتيك ميدياويكي</a>.
تذكر أن تخزن احتياطيا البيانات القيمة قبل تنفيذ وظائف إدارية.',
	'smw_smwadmin_db' => 'تثبيت و تحديث قاعدة البيانات',
	'smw_smwadmin_dbdocu' => 'سيمانتيك ميدياويكي يتطلب بعض الامتدادات لقاعدة بيانات ميدياويكي حتى يخزن البيانات السيمانتيك.
الوظيفة التالية تؤكد أن قاعدة بياناتك منصبة بشكل صحيح.
التغييرات المعمولة في هذه الخطوة لا تؤثر على بقية قاعدة بيانات ميدياويكي، ويمكن استرجاعها بسهولة في حالة الرغبة في ذلك.
وظيفة التنصيب هذه يمكن تنفيذها عدة مرات بدون عمل أي ضرر، لكنها مطلوبة مرة واحدة عند التنصيب أو الترقية.',
	'smw_smwadmin_permissionswarn' => 'لو أن العملية فشلت مع أخطاء SQL، فقاعدة البيانات التي طبقها المستخدم بواسطة الويكي الخاص بك (تحقق من LocalSettings.php الخاص بك) على الأرجح لا تمتلك سماحات كافية.
إما أن تمنح هذا المستخدم سماحات إضافية لإنشاء وحذف الجداول، مؤقتا أدخل تسجيل الدخول للroot الخاص بقاعدة بياناتك في LocalSettings.php، أو استخدم سكريبت الصيانة <tt>SMW_setup.php</tt> الذي يمكنه استخدام تأكيدات AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'جداول البدء أو الترقية',
	'smw_smwadmin_announce' => 'أعلن عن الويكي الخاص بك',
	'smw_smwadmin_announcedocu' => 'سيمانتيك ميدياويكي لديه خدمة وب لإعلان مواقع الويكي السيمانتيك الجديدة.
هذا يستخدم للاعتناء بقائمة من المواقع العلنية التي تستخدم سيمانتيك ميدياويكي، أساسا لمساعدة <a href="http://semantic-mediawiki.org/wiki/SMW_Project">مشروع سيمانتيك ميدياويكي</a> للحصول على عرض عام للاستخدامات النمطية لسيمانتيك ميدياويكي.
انظر الصفحة الرئيسية لسيمانتيك ميدياويكي ل<a href="http://semantic-mediawiki.org/wiki/Registry">مزيد من المعلومات حول هذه الخدمة</a>.',
	'smw_smwadmin_announcebutton' => 'اضغط على الزر التالي لإرسال مسار الويكي الخاص بك إلى تلك الخدمة.
الخدمة لن تسجل الويكيات التي لا يمكن الوصول إليها بشكل علني، وستخزن فقط البيانات التي يمكن الوصول إليها بشكل علني.',
	'smw_smwadmin_datarefresh' => 'إصلاح البيانات وتحديثها',
	'smw_smwadmin_datarefreshdocu' => 'من الممكن استرجاع كل بيانات سيمانتيك ميدياويكي بناء على المحتويات الحالية للويكي.
هذا يمكن أن يكون مفيدا لإصلاح البيانات المكسورة أو لتحديث البيانات لو أن الصيغة الداخلية تغيرت بسبب ترقية برنامج.
التحديث يتم تنفيذه صفحة بصفحة ولن يتم إكماله حالا.
التالي يعرض ما إذا كان التحديث يجري ويسمح لك ببدء أو إنهاء التحديثات (إلا لو كانت هذه الخاصية تم تعطيلها بواسطة إداري الموقع).',
	'smw_smwadmin_datarefreshprogress' => '<strong>تحديث يجري بالفعل.</strong>
من الطبيعي أن تتقدم عمليات التحديث ببطء فقط بما أنها تحدث البيانات فقط في كميات صغيرة كل مرة مستخدم ما يصل إلى الويكي.
للانتهاء من هذا التحديث سريعا، يمكنك تشغيل سكريبت صيانة ميدياويكي <tt>runJobs.php</tt> (استخدم الخيار <tt>--maxjobs 1000</tt> لتحديد عدد التحديثات المعمولة كل مرة).
التقدم المقدر للتحديث الحالي:',
	'smw_smwadmin_datarefreshbutton' => 'أبدا تحديث البيانات',
	'smw_smwadmin_datarefreshstop' => 'أوقف هذا التحديث',
	'smw_smwadmin_datarefreshstopconfirm' => 'نعم، أنا متأكد',
	'smw_smwadmin_support' => 'أحصل على دعم',
	'smw_smwadmin_supportdocu' => ':مصادر متعددة يمكن أن تساعدة في حالة مشاكل',
	'smw_smwadmin_installfile' => 'لو أنك تواجه مشاكل مع تنصيبك، ابدأ بالتحقق من الإرشادات في <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">ملف INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'وثائق المستخدم الكاملة لسيمانتيك ميدياويكي موجودة في <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'العلل يمكن إبلاغها إلى <a href="https://bugzilla.wikimedia.org/">ميديازيللا</a>.',
	'smw_smwadmin_questions' => 'لو لديك أسئلة أو اقتراحات أخرى، انضم إلى النقاش في <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">منتدى مستخدمي سيمانتيك ميدياويكي</a>.',
	'smw_adminlinks_datastructure' => 'هيكل البيانات',
	'smw_adminlinks_displayingdata' => 'عرض البيانات',
	'smw_adminlinks_inlinequerieshelp' => 'مساعدة الاستعلامات الداخلية',
	'smw-createproperty-isproperty' => 'هذه خاصية من نوع $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1||القيمة المسموح بها لهذه الخاصية هي|القيمتان المسموح بهما لهذه الخاصية هما|القيم المسموح بها لهذه الخاصية هي}}:',
	'smw_unknowntype' => 'نوع غير مدعوم "$1" لتعريف الممتلكات.', # Fuzzy
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'smw_finallistconjunct' => ', ܘ',
	'smw_printername_list' => 'ܡܟܬܒܘܬܐ',
	'smw_printername_table' => 'ܠܘܚܝܬܐ',
	'smw_printername_template' => 'ܩܠܒܐ',
	'smw_iq_moreresults' => 'ܝܬܝܪ ܦܠܛ̈ܐ …',
	'smw_true_words' => 'ܬܪܝܨܐ,ܬ,ܐܝܢ,ܐ',
	'smw_false_words' => 'ܦܘܕܐ,ܦ,ܠܐ,ܠ',
	'smw_type_header' => 'ܕ̈ܝܠܝܬܐ ܕܐܕܫܐ "$1"',
	'exportrdf' => 'ܐܦܩ ܦܐܬܬ̈ܐ ܠ RDF',
	'smw_exportrdf_submit' => 'ܐܦܩ',
	'smw_property_template' => '$1 ܡܢ ܐܕܫܐ ܕ $2 ($3)', # Fuzzy
	'unusedproperties' => 'ܕ̈ܝܠܝܬܐ ܠܐ ܦܠܝܚܬ̈ܐ',
	'smw_unusedproperty_template' => '$1 ܡܢ ܐܕܫܐ ܕ $2',
	'wantedproperties' => 'ܕ̈ܝܠܝܬܐ ܣܢܝܩܬ̈ܐ',
	'types' => 'ܐܕܫ̈ܐ',
	'smw_ask_otheroptions' => 'ܓܒܝܬ̈ܐ ܐܚܪ̈ܢܝܬܐ',
	'smw_sbv_value' => 'ܛܝܡܐ:',
	'smw_sbv_submit' => 'ܐܫܟܚ ܦܠܛ̈ܐ',
	'browse' => 'ܦܐܬ ܘܝܩܝ',
	'smw_browselink' => 'ܕ̈ܝܠܝܬܐ ܕܡܦܐܬܢܘܬܐ',
	'smw_browse_article' => 'ܐܥܠ ܫܡܐ ܕܦܐܬܐ ܠܫܘܪܝ ܦܐܬܢܘܬܐ ܡܢܗ.',
	'smw_browse_go' => 'ܙܠ',
	'smw_browse_show_incoming' => 'ܚܘܝ ܕ̈ܝܠܝܬܐ ܕܐܣܝܪܝܢ ܠܗܪܟܐ',
	'smw_browse_hide_incoming' => 'ܛܫܝ ܕ̈ܝܠܝܬܐ ܕܐܣܝܪܝܢ ܠܗܪܟܐ',
	'smw_browse_no_outgoing' => 'ܦܐܬܐ ܗܕܐ ܠܝܬ ܠܗ ܕ̈ܝܠܝܬܐ.',
	'smw_browse_no_incoming' => 'ܠܝܬ ܕ̈ܝܠܝܬܐ ܕܐܣܝܪܝܢ ܥܡ ܦܐܬܐ ܗܕܐ.',
	'smw_inverse_label_default' => '$1 ܡܢ',
	'smw_pp_from' => 'ܡܢ ܦܐܬܐ',
	'smw_pp_type' => 'ܕܝܠܝܬܐ',
	'smw_result_prev' => 'ܕܩܕܡ',
	'smw_result_next' => 'ܕܒܬܪ',
	'smw_result_results' => 'ܦܠܛ̈ܐ',
	'smw_result_noresults' => 'ܠܝܬ ܦܠܛ̈ܐ.',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 * @author Meno25
 * @author Ouda
 * @author Ramsis II
 */
$messages['arz'] = array(
	'smw-desc' => "جعل الويكى الخاص بك أكثر قابليه للوصول - للآلات ''و'' البشر ([http://semantic-mediawiki.org/wiki/Help:User_manual توثيق على الإنترنت])",
	'smw_viewasrdf' => 'تلقيم RDF',
	'smw_finallistconjunct' => '، و',
	'smw_factbox_head' => 'حقائق عن $1',
	'smw_isspecprop' => 'هذه الخاصيه هى خاصيه خاصه فى هذا الويكى.',
	'smw_concept_description' => 'وصف المبدأ "$1"',
	'smw_no_concept_namespace' => 'المبادئ يمكن تعريفها فقط فى الصفحات فى نطاق Concept:',
	'smw_multiple_concepts' => 'كل صفحه مبدأ يمكن أن تحتوى على تعريف مبدأ واحد.',
	'smw_concept_cache_miss' => 'المبدأ "$1" لا يمكن استخدامه حاليا، بما أن ضبط الويكى يحتاجه إلى أن يتم حسابه خارجيا. لو أن المشكله لم تنته بعد بعض الوقت، سل إدارى موقعك ليجعل هذا المبدأ متوفرا.',
	'smw_noinvannot' => 'القيم لا يمكن تعيينها لخصائص معكوسه.',
	'smw_baduri' => 'URIs من النوع "$1" غير مسموح بها.',
	'smw_rss_link' => 'آر إس إس',
	'smw_csv_link' => 'سى فى إس',
	'smw_printername_count' => 'عد النتائج',
	'smw_printername_csv' => 'تصدير CSV',
	'smw_printername_debug' => 'استعلام التصليح (للخبراء)',
	'smw_printername_embedded' => 'تضمين محتويات الصفحة',
	'smw_printername_json' => 'تصدير JSON',
	'smw_printername_list' => 'قائمة',
	'smw_printername_ol' => 'ترقيم',
	'smw_printername_ul' => 'ترتيب فى عناصر',
	'smw_printername_rss' => 'تصدير RSS',
	'smw_printername_table' => 'جدول',
	'smw_printername_broadtable' => 'جدول عريض',
	'smw_printername_template' => 'قالب',
	'smw-paramdesc-limit' => 'الرقم الأقصى للعناصر المُرجعة',
	'smw-paramdesc-headers' => 'اعرض العناوين/أسماء الخصائص',
	'smw-paramdesc-mainlabel' => 'العلامه للإعطاء لاسم الصفحه الرئيسية',
	'smw-paramdesc-link' => 'أظهر القيم كوصلات',
	'smw-paramdesc-intro' => 'النص للعرض قبل نتائج الاستعلام، لو كانت هناك أي',
	'smw-paramdesc-outro' => 'النص المطلوب عرضه بعد نتائج الاستعلام، إن وُجدت',
	'smw-paramdesc-default' => 'النص المطلوب عرضه إذا لم تتوفر نتائج للاستعلام',
	'smw-paramdesc-sep' => 'فاصل القيم',
	'smw-paramdesc-template' => 'اسم القالب لعرض الخرج به',
	'smw-paramdesc-columns' => 'رقم الأعمده لعرض النتائج بها (افتراضيا $1)',
	'smw-paramdesc-embedformat' => 'وسم HTML المستخدم لتعريف الترويسة',
	'smw-paramdesc-embedonly' => 'لا تظهر الترويسات',
	'smw-paramdesc-rsstitle' => 'النص المستخدم كعنوان للتغذية',
	'smw-paramdesc-rssdescription' => 'النص المستخدم لوصف التغذية',
	'smw-paramdesc-searchlabel' => 'نص وصله النتائج', # Fuzzy
	'smw_iq_disabled' => 'استعلامات السيمانتيك تم تعطيلها فى هذا الويكى.',
	'smw_iq_moreresults' => '… مزيد من النتائج',
	'smw_parseerror' => 'القيمه المعطاه لم يتم فهمها.',
	'smw_kiloseparator' => '،',
	'smw_notitle' => '"$1" لا يمكن أن تستخدم مثل هذا الاسم فى صفحه ويكى.',
	'smw_wrong_namespace' => 'فقط الصفحات فى النطاق "$1" مسموح بها هنا.',
	'smw_manytypes' => 'أكثر من نوع واحد لتعريف الخاصيه.',
	'smw_emptystring' => 'السلاسل الفارغه غير مقبوله.',
	'smw_maxstring' => 'تمثيل السلسله $1 طويل جدا.',
	'smw_notinenum' => '"$1" ليس ضمن قائمه القيم الممكنه ($2) لهذه الخاصيه.',
	'smw_noboolean' => '"$1" غير متعرف عليها كقيمه بووليان (صواب/خطأ).',
	'smw_true_words' => 'صحيح،ص،نعم،ن',
	'smw_false_words' => 'خطأ،خ،لا،ل',
	'smw_nofloat' => 'ليس عددا "$1".',
	'smw_infinite' => 'الأرقام الكبيره مثل "$1" غير مدعومه.',
	'smw_nodatetime' => 'التاريخ "$1" لم يتم فهمه.',
	'smw_toomanyclosing' => 'يبدو أنه هناك الكثير من "$1" فى الاستعلام.',
	'smw_noclosingbrackets' => '"]]" فى استعلامك لم تكن مغلقه باستخدام "<nowiki>[[</nowiki>" بعض استخدام',
	'smw_misplacedsymbol' => 'الرمز "$1" تم استخدامه فى مكان حيث هو ليس مفيدا.',
	'smw_unexpectedpart' => 'الجزء "$1" من الاستعلام لم يفهم.
النتائج قد لا تكون كما هو متوقع.',
	'smw_emptysubquery' => 'بعض الاستعلامات الفرعيه ليس لها شرط صحيح.',
	'smw_misplacedsubquery' => 'بعض الاستعلامات الفرعيه تم استخدمها فى مكان غير مسموح فيه بالاستعلامات الفرعيه.',
	'smw_valuesubquery' => 'الاستعلامات الفرعيه غير مدعومه لقيم الخاصيه "$1".',
	'smw_badqueryatom' => 'جزء ما "<nowiki>[[…]]</nowiki>" من الاستعلام لم يتم فهمه.',
	'smw_propvalueproblem' => 'قيمه الخاصيه "$1" لم يتم فهمها.',
	'smw_noqueryfeature' => 'ميزه استعلام ما لم يتم دعمها فى هذا الويكى وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_noconjunctions' => 'الوقوفات فى الاستعلامات غير مدعومه فى هذا الويكى وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_nodisjunctions' => 'المفارق فى استعلامات ليست مدعومه فى هذا الويكى وجزء من الاستعلام رفض $1.',
	'smw_querytoolarge' => 'شروط الاستفسار التاليه لم يمكن اعتبارها نتيجه لقيود الويكى فى حجم أو عمق الاستعلام: $1.',
	'smw_notemplategiven' => 'وفر قيمه للمحدد "template" لتعمل صيغه الاستعلام هذه.',
	'smw_type_header' => 'خصائص النوع "$1"',
	'smw_typearticlecount' => 'عرض {{PLURAL:$1||خاصيه واحده تستخدم|خاصيتين تستخدمان|$1 خصائص تستخدم|$1 خاصيه تستخدم}} هذا النوع.',
	'smw_attribute_header' => 'الصفحات التى تستخدم الخاصيه "$1"',
	'smw_attributearticlecount' => 'عرض {{PLURAL:$1||الصفحه التى تستخدم|الصفحتين اللتين تستخدمان|الصفحات التى تستخدم}} هذه الخاصيه.',
	'smw_subproperty_header' => 'خواص فرعية',
	'smw_subpropertyarticlecount' => 'لهذه الخاصيه {{PLURAL:$1||الخاصيه الفرعيه التالية|الخاصيتين الفرعيتين التاليتين|الخصائص الفرعيه التالية}}:',
	'smw_concept_header' => 'صفحات المبدأ "$1"',
	'smw_conceptarticlecount' => 'عرض {{PLURAL:$1||صفحه واحده تنتمي|صفحتين تنتميان|$1 صفحات تنتمي|$1 صفحه تنتمي}} إلى هذا المبدأ.',
	'smw_rss_description' => '$1 تلقيم آر إس إس',
	'specialpages-group-smw_group' => 'سيمانتيك ميدياويكى',
	'exportrdf' => 'آر دی‌ إف إلى صفحات تصدير',
	'smw_exportrdf_docu' => ' هذه الصفحه تتيح لك الحصول على بيانات من صفحه فى شكل آر دی‌ إف.
التصدير إلى صفحات، أدخل العناوين فى مربع النص أدناه، عنوان واحد لكل سطر.',
	'smw_exportrdf_recursive' => 'تصدير جميع الصفحات ذات الصله بشكل تكرارى.
علما أنه يمكن أن تكون النتيجه كبيرة!',
	'smw_exportrdf_backlinks' => 'أيضا تصدير كل الصفحات التى تشير إلى الصفحات تم تصديرها.
يولد آر دى إف قابل للتصفح.',
	'smw_exportrdf_lastdate' => 'لا تصدر الصفحات التى لم تتغير منذ نقطه زمنيه محدده.',
	'smw_exportrdf_submit' => 'تصدير',
	'uriresolver' => 'محلل URI',
	'properties' => 'الخصائص',
	'smw_properties_docu' => 'الخصائص التاليه تستخدم فى الويكى.',
	'smw_property_template' => '$1 من نوع $2 ($3)',
	'smw_propertylackspage' => 'جميع الخصائص ينبغى أن توصف بصفحة!',
	'smw_propertylackstype' => 'لا نوع تم تحديده لهذه الخاصيه (افتراض النوع $1 حاليا).',
	'smw_propertyhardlyused' => 'هذه الخاصيه لا تكاد تستخدم داخل الويكي!',
	'unusedproperties' => 'خصائص غير مستخدمة',
	'smw_unusedproperties_docu' => 'الخصائص التاليه موجوده على الرغم من أنه لا صفحه أخرى تستخدمها.',
	'smw_unusedproperty_template' => '$1 من نوع $2',
	'wantedproperties' => 'خصائص مطلوبة',
	'smw_wantedproperties_docu' => 'الخصائص التاليه مستخدمه فى الويكى ولكن ليس لديها حتى الآن صفحه لوصفها.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|استخدام|استخدام}})',
	'smw_purge' => 'تحديث',
	'types' => 'أنواع',
	'smw_types_docu' => 'التالى قائمه بجميع أنواع البيانات التى يمكن أن تسند إلى الخصائص.
كل نوع بيانات له صفحه حيث يمكن توفير معلومات إضافيه.', # Fuzzy
	'semanticstatistics' => 'إحصاءات سيمانتيك',
	'smw_semstats_text' => "هذا الويكى يحتوى على '''$1''' {{PLURAL:$1|قيمة|قيمة}} خاصيه بإجمالى '''$2''' [[Special:Properties|{{PLURAL:$2|خاصية|خاصيه مختلفة}}]].
'''$3''' {{PLURAL:$3|خاصيه تمتلك|خاصيه تمتلك}} صفحتها الخاصه، ونوع البيانات المقصود محدد ل'''$4''' من هؤلاء.
بعض الخواص الموجوده ربما تكون [[Special:UnusedProperties|خواص غير مستخدمة]].
الخواص التى مازالت تفتقد صفحه موجوده فى [[Special:WantedProperties|قائمه الخواص المطلوبة]].",
	'smw_uri_doc' => 'محلل URI ينفذ <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C على httpRange-14</a>. إنه يتأكد من أن البشر لا يتحولون إلى مواقع ويب.',
	'ask' => 'بحث سيمانتيك',
	'smw_ask_sortby' => 'الترتيب حسب العمود (اختياري)',
	'smw_ask_ascorder' => 'تصاعدي',
	'smw_ask_descorder' => 'تنازلي',
	'smw_ask_submit' => 'جِد نتائجًا',
	'smw_ask_editquery' => '[عدل الاستعلام]',
	'smw_add_sortcondition' => '[أضف شرط ترتيب]',
	'smw_ask_hidequery' => 'إخفاء الاستعلام',
	'smw_ask_help' => 'مساعده الاستعلام',
	'smw_ask_queryhead' => 'استعلام',
	'smw_ask_printhead' => 'بيانات إضافيه للعرض',
	'smw_ask_printdesc' => '(أضف اسمًا مناسبًا واحدًا فى كل سطر)',
	'smw_ask_format_as' => 'صياغه ك:',
	'smw_ask_defaultformat' => 'افتراضي',
	'smw_ask_otheroptions' => 'خيارات أخرى',
	'smw_ask_show_embed' => 'عرض الكود المضمن',
	'smw_ask_hide_embed' => 'إخفاء الكود المضمن',
	'smw_ask_embed_instr' => 'لتضمين هذا الاستعلام فى صفحه ويكى، استخدم الكود أدناه',
	'searchbyproperty' => 'البحث حسب الخصائص',
	'smw_sbv_docu' => 'البحث عن كل الصفحات التى لها خصائص معينه وقيمة',
	'smw_sbv_novalue' => 'أدخل قيمه صحيحه للخاصيه، أو انظر كل قيم الخصائص ل"$1"',
	'smw_sbv_displayresult' => 'قائمه بكل الصفحات التى بها الخاصيه "$1" بالقيمه "$2"',
	'smw_sbv_displayresultfuzzy' => 'قائمه بكل الصفحات التى لديها الخاصيه "$1" بالقيمه "$2".
بما أنه كانت هناك فقط عده نتائج، فالقيم المقاربه معروضه أيضا.',
	'smw_sbv_property' => 'خاصية:',
	'smw_sbv_value' => 'قيمة:',
	'smw_sbv_submit' => 'جِد نتائجًا',
	'browse' => 'استعرض يكي',
	'smw_browselink' => 'خصائص التصفح',
	'smw_browse_article' => 'أدخل اسم الصفحه لبدء التصفح منها.',
	'smw_browse_go' => 'اذهب',
	'smw_browse_show_incoming' => 'أظهر الخواص التى تصل هنا',
	'smw_browse_hide_incoming' => 'أخفِ الخواص التى تصل هنا',
	'smw_browse_no_outgoing' => 'هذه الصفحه ليس لديها خصائص.',
	'smw_browse_no_incoming' => 'لا خصائص تصل إلى هذه الصفحه.',
	'smw_inverse_label_default' => '$1 من',
	'smw_inverse_label_property' => 'اعكس علامه الخاصية',
	'pageproperty' => 'بحث خصائص الصفحة',
	'smw_pp_docu' => 'البحث عن جميع قيم خاصيه على صفحه معينه.
أدخل صفحه وخاصيه.',
	'smw_pp_from' => 'من صفحة',
	'smw_pp_type' => 'الخاصية',
	'smw_pp_submit' => 'جِد نتائجًا',
	'smw_result_prev' => 'السابق',
	'smw_result_next' => 'التالي',
	'smw_result_results' => 'النتائج',
	'smw_result_noresults' => 'لا توجد نتائج.',
	'smwadmin' => 'وظائف إداريه لسيمانتيك ميدياويكي',
	'smw_smwadmin_setupsuccess' => 'تم تنصيب محرك التخزين بنجاح',
	'smw_smwadmin_return' => 'أرجع إلى $1',
	'smw_smwadmin_updatestarted' => 'عمليه تحديث جديده لتحديث بيانات سيمانتيك بدأت.
كل البيانات المخزنه ستتم إعاده بنائها أو إصلاحها عند الحاجه.
أنت يمكنك متابعه تطور التحديث على هذه الصفحه الخاصه.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'يوجد بالفعل عمليه تحديث جاريه.
لا تنشئ واحده أخرى.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'كل عمليات التحديث الموجوده تم إيقافها', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'لوقف عمليه التحديث الجاريه، يجب عليك تفعيل الصندوق لتعبر عن أنك متأكد حقا.', # Fuzzy
	'smw_smwadmin_docu' => 'هذه الصفحه الخاصه تساعدك خلال تنصيب وترقيه <a href="http://semantic-mediawiki.org">سيمانتيك ميدياويكي</a>.
تذكر أن تخزن احتياطيا البيانات القيمه قبل تنفيذ وظائف إداريه.',
	'smw_smwadmin_db' => 'تثبيت و تحديث قاعده البيانات',
	'smw_smwadmin_dbdocu' => 'سيمانتيك ميدياويكى يتطلب بعض الامتدادات لقاعده بيانات ميدياويكى حتى يخزن البيانات السيمانتيك.
الوظيفه التاليه تؤكد أن قاعده بياناتك منصبه بشكل صحيح.
التغييرات المعموله فى هذه الخطوه لا تؤثر على بقيه قاعده بيانات ميدياويكى، ويمكن استرجاعها بسهوله فى حاله الرغبه فى ذلك.
وظيفه التنصيب هذه يمكن تنفيذها عده مرات بدون عمل أى ضرر، لكنها مطلوبه مره واحده عند التنصيب أو الترقيه.',
	'smw_smwadmin_permissionswarn' => 'لو أن العمليه فشلت مع أخطاء SQL، فقاعده البيانات التى طبقها المستخدم بواسطه الويكى الخاص بك (تحقق من LocalSettings.php الخاص بك) على الأرجح لا تمتلك سماحات كافيه.
إما أن تمنح هذا المستخدم سماحات إضافيه لإنشاء وحذف الجداول، مؤقتا أدخل تسجيل الدخول للroot الخاص بقاعده بياناتك فى LocalSettings.php، أو استخدم سكريبت الصيانه <tt>SMW_setup.php</tt> الذى يمكنه استخدام تأكيدات AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'جداول البدء أو الترقية',
	'smw_smwadmin_announce' => 'أعلن عن الويكى الخاص بك',
	'smw_smwadmin_announcedocu' => 'سيمانتيك ميدياويكى لديه خدمه وب لإعلان مواقع الويكى السيمانتيك الجديده.
هذا يستخدم للاعتناء بقائمه من المواقع العلنيه التى تستخدم سيمانتيك ميدياويكى، أساسا لمساعده <a href="http://semantic-mediawiki.org/wiki/SMW_Project">مشروع سيمانتيك ميدياويكي</a> للحصول على عرض عام للاستخدامات النمطيه لسيمانتيك ميدياويكى.
انظر الصفحه الرئيسيه لسيمانتيك ميدياويكى ل<a href="http://semantic-mediawiki.org/wiki/Registry">مزيد من المعلومات حول هذه الخدمة</a>.',
	'smw_smwadmin_announcebutton' => 'اضغط على الزر التالى لإرسال مسار الويكى الخاص بك إلى تلك الخدمه.
الخدمه لن تسجل الويكيات التى لا يمكن الوصول إليها بشكل علنى، وستخزن فقط البيانات التى يمكن الوصول إليها بشكل علنى.',
	'smw_smwadmin_datarefresh' => 'إصلاح البيانات وتحديثها',
	'smw_smwadmin_datarefreshdocu' => 'من الممكن استرجاع كل بيانات سيمانتيك ميدياويكى بناء على المحتويات الحاليه للويكى.
هذا يمكن أن يكون مفيدا لإصلاح البيانات المكسوره أو لتحديث البيانات لو أن الصيغه الداخليه تغيرت بسبب ترقيه برنامج.
التحديث يتم تنفيذه صفحه بصفحه ولن يتم إكماله حالا.
التالى يعرض ما إذا كان التحديث يجرى ويسمح لك ببدء أو إنهاء التحديثات (إلا لو كانت هذه الخاصيه تم تعطيلها بواسطه إدارى الموقع).',
	'smw_smwadmin_datarefreshprogress' => '<strong>تحديث يجرى بالفعل.</strong>
من الطبيعى أن تتقدم عمليات التحديث ببطء فقط بما أنها تحدث البيانات فقط فى كميات صغيره كل مره مستخدم ما يصل إلى الويكى.
للانتهاء من هذا التحديث سريعا، يمكنك تشغيل سكريبت صيانه ميدياويكى <tt>runJobs.php</tt> (استخدم الخيار <tt>--maxjobs 1000</tt> لتحديد عدد التحديثات المعموله كل مرة).
التقدم المقدر للتحديث الحالي:',
	'smw_smwadmin_datarefreshbutton' => 'أبدا تحديث البيانات',
	'smw_smwadmin_datarefreshstop' => 'أوقف هذا التحديث',
	'smw_smwadmin_datarefreshstopconfirm' => 'نعم، أنا متأكد',
	'smw_smwadmin_support' => 'أحصل على دعم',
	'smw_smwadmin_supportdocu' => ':مصادر متعدده يمكن أن تساعده فى حاله مشاكل',
	'smw_smwadmin_installfile' => 'لو أنك تواجه مشاكل مع تنصيبك، ابدأ بالتحقق من الإرشادات فى <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">ملف INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'وثائق المستخدم الكامله لسيمانتيك ميدياويكى موجوده فى <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'العلل يمكن إبلاغها إلى <a href="https://bugzilla.wikimedia.org/">ميديازيللا</a>.',
	'smw_smwadmin_questions' => 'لو لديك أسئله أو اقتراحات أخرى، انضم إلى النقاش فى <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">منتدى مستخدمى سيمانتيك ميدياويكي</a>.',
	'smw_adminlinks_datastructure' => 'هيكل البيانات',
	'smw_adminlinks_displayingdata' => 'عرض البيانات',
	'smw_adminlinks_inlinequerieshelp' => 'مساعده الاستعلامات الداخلية',
	'smw-createproperty-isproperty' => 'هذه خاصية من نوع $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1||القيمة المسموح بها لهذه الخاصية هي|القيمتان المسموح بهما لهذه الخاصية هما|القيم المسموح بها لهذه الخاصية هي}}:',
	'smw_unknowntype' => 'نوع غير مدعوم "$1" لتعريف الممتلكات.', # Fuzzy
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'smw-desc' => "Facer la to wiki más accesible - pa les máquines ''y'' pa los humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentación en llinia])",
	'smw_viewasrdf' => 'Canal RDF',
	'smw_finallistconjunct' => ', y',
	'smw_factbox_head' => 'Fechos sobro $1',
	'smw_isspecprop' => 'Esta propiedá ye una propiedá especial nesta wiki.',
	'version-semantic' => 'Estensiones semántiques',
	'smw_baduri' => 'Les URIs de la forma «$1» nun tan permitíes.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Resultaos del recuentu',
	'smw_printername_csv' => 'Esportación a CSV',
	'smw_printername_dsv' => 'Esportación a DSV',
	'smw_printername_debug' => 'Consulta de depuración (pa espertos)',
	'smw_printername_json' => 'Esportación a JSON',
	'smw_printername_list' => 'Llista',
	'smw_printername_ol' => 'Enumeración',
	'smw_printername_rss' => 'Esportación a RSS',
	'smw_printername_table' => 'Tabla',
	'smw_printername_broadtable' => 'Tabla ancha',
	'smw_printername_template' => 'Plantía',
	'smw_printername_rdf' => 'Esportación a RDF',
	'smw_printername_category' => 'Categoría',
);

/** Azerbaijani (azərbaycanca)
 * @author Cekli829
 */
$messages['az'] = array(
	'smw_finallistconjunct' => ', və',
	'smw_dsv_link' => 'DSV',
	'smw_printername_list' => 'Siyahı',
	'smw_printername_table' => 'Cədvəl',
	'smw_printername_template' => 'Şablon',
	'smw_qui_ok' => 'Ok',
	'smw_qui_cancel' => 'İmtina',
	'smw_qui_category' => '<strong>Kateqoriya</strong>',
	'smw_qui_dcategory' => 'Kateqoriya:',
	'smw_result_results' => 'Nəticələr',
);

/** Bashkir (башҡортса)
 * @author Roustammr
 */
$messages['ba'] = array(
	'smw_browselink' => 'Үҙенсәлектәрҙе ҡарарға',
);

/** Bavarian (Boarisch)
 * @author Mucalexx
 */
$messages['bar'] = array(
	'smw_purge' => 'Neich loon',
	'smw_browselink' => "D' Attributt åzoang",
);

/** Belarusian (беларуская)
 * @author Тест
 */
$messages['be'] = array(
	'smw_printername_template' => 'Шаблон',
	'types' => 'Тыпы',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Red Winged Duck
 * @author Renessaince
 * @author Wizardist
 * @author Zedlik
 */
$messages['be-tarask'] = array(
	'smw-desc' => "Робіць {{GRAMMAR:вінавальны|{{SITENAME}}}} больш зручнай для кампутараў ''і'' людзей ([http://semantic-mediawiki.org/wiki/Help:User_manual дакумэнтацыя])",
	'smw_viewasrdf' => 'RDF-крыніца',
	'smw_finallistconjunct' => ' і',
	'smw_factbox_head' => 'Факты аб $1',
	'smw_isspecprop' => 'Гэтая ўласьцівасьць зьяўляецца спэцыяльнай у {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_concept_description' => 'Апісаньне канцэпцыі «$1»',
	'smw_no_concept_namespace' => 'Канцэпцыі могуць быць вызначаныя толькі на старонках прасторы назваў «Канцэпцыя:».',
	'smw_multiple_concepts' => 'Кожная старонка канцэпцыі можа мець толькі адно вызначэньне канцэпцыі.',
	'smw_concept_cache_miss' => 'Канцэпцыя «$1» ня можа быць выкарыстаная ў гэты момант, таму што канфігурацыя {{GRAMMAR:родны|{{SITENAME}}}} патрабуе, каб яна вылічалася аф-лайн. Калі гэта праблема ня зьнікне празь некаторы час, запытайце Вашага адміністратара сайта ўключыць гэтую канцэпцыю.',
	'smw_noinvannot' => 'Значэньні ня можа быць прызначаныя ў адваротныя уласьцівасьці.',
	'version-semantic' => 'Сэмантычныя пашырэньні',
	'smw_baduri' => 'Спасылкі на форму «$1» не дазволеныя.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Падлік вынікаў',
	'smw_printername_csv' => 'экспарт у фармаце CSV',
	'smw_printername_dsv' => 'Экспарт у фармат DSV',
	'smw_printername_debug' => 'Запыт для наладкі (для экспэртаў)',
	'smw_printername_embedded' => 'Устаўляць зьмест старонак',
	'smw_printername_json' => 'экспарт у фармаце JSON',
	'smw_printername_list' => 'Сьпіс',
	'smw_printername_ol' => 'Пералік',
	'smw_printername_ul' => 'Дэталізацыя',
	'smw_printername_rss' => 'экспарт у фармаце RSS',
	'smw_printername_table' => 'Табліца',
	'smw_printername_broadtable' => 'Шырокая табліца',
	'smw_printername_template' => 'Шаблён',
	'smw_printername_rdf' => 'Экспарт у фармат RDF',
	'smw_printername_category' => 'Катэгорыя',
	'smw-paramdesc-limit' => 'Максымальная колькасьць вынікаў для вяртаньня',
	'smw-paramdesc-offset' => 'Адхіленьне першага выніку',
	'smw-paramdesc-headers' => 'Паказваць назвы загалоўкаў/уласьцівасьцяў',
	'smw-paramdesc-mainlabel' => 'Метка для назвы галоўнай старонкі',
	'smw-paramdesc-link' => 'Паказваць значэньні як спасылкі',
	'smw-paramdesc-intro' => 'Тэкст для паказу перад вынікамі запыту, калі яны ёсьць',
	'smw-paramdesc-outro' => 'Тэкст для паказу пасьля вынікаў запыту, калі яны ёсьць',
	'smw-paramdesc-default' => 'Тэкст для паказу ў выпадку адсутнасьці вынікаў',
	'smw-paramdesc-sep' => 'Разьдзяляльнік значэньняў',
	'smw-paramdesc-distribution' => 'Замест адлюстраваньня ўсіх значэньняў падлічыць ужываньні і паказаць іх.',
	'smw-paramdesc-distributionsort' => 'Адсартаваць разьмеркаваньне значэньняў паводле колькасьці ўжываньня.',
	'smw-paramdesc-template' => 'Назва шаблёну, які будзе выкарыстоўвацца для вываду вынікаў',
	'smw-paramdesc-columns' => 'Колькасьць слупкоў у якіх будуць паказвацца вынікі (па змоўчваньні — $1)',
	'smw-paramdesc-userparam' => 'Значэньне, якое перадаецца ў кожны выклік шаблёну, калі ён выкарыстоўваецца',
	'smw-paramdesc-introtemplate' => 'Назва шаблёну для паказу перад вынікамі запыту, калі яны ёсьць',
	'smw-paramdesc-outrotemplate' => 'Назва шаблёну для паказу пасьля вынікаў запыту, калі яны ёсьць',
	'smw-paramdesc-embedformat' => 'Тэг HTML, які выкарыстоўваецца для вызначэньня загалоўкаў',
	'smw-paramdesc-embedonly' => 'Не паказваць загалоўкі',
	'smw-paramdesc-table-class' => 'Дадатковая кляса CSS для табліцы',
	'smw-paramdesc-rsstitle' => 'Тэкст, які будзе выкарыстоўвацца як назва стужкі',
	'smw-paramdesc-rssdescription' => 'Тэкст, які будзе выкарыстоўвацца як апісаньне стужкі',
	'smw-paramdesc-rdfsyntax' => 'Сынтаксіс RDF для выкарыстаньня',
	'smw-paramdesc-csv-sep' => 'Разьдзяляльнік',
	'smw-paramdesc-dsv-separator' => 'Разьдзяляльнік',
	'smw-paramdesc-dsv-filename' => 'Назва DSV-файла',
	'smw-smwdoc-description' => 'Паказвае табліцу з усімі парамэтрамі, якія могуць ужывацца для выбранага фармату вынікаў разам з значэньнямі па змоўчваньні і апісаньнямі.',
	'smw-smwdoc-par-format' => 'Фармат вынікаў для паказу дакумэнтацыі пра парамэтры.',
	'smw-paramdesc-sort' => 'Уласьцівасьць, паводле якой сартаваць запыт',
	'smw-paramdesc-order' => 'Парадак сартаваньня запыту',
	'smw-paramdesc-searchlabel' => 'Тэкст для працягу пошуку (па змоўчваньні «… дадатковыя вынікі»)', # Fuzzy
	'smw_iq_disabled' => 'Сэмантычныя запыты былі выключаны ў {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_iq_moreresults' => '… наступныя вынікі',
	'smw_parseerror' => 'Пададзенае значэньне не было распазнанае.',
	'smw_notitle' => '«$1» ня можа выкарыстоўвацца як назва старонкі ў {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_noproperty' => '«$1» ня можа выкарыстоўвацца як уласьцівасьць старонкі ў {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_wrong_namespace' => 'Тут дазволены толькі старонкі з прасторы назваў «$1».',
	'smw_manytypes' => 'Для ўласьцівасьці вызначана болей аднаго тыпу.',
	'smw_emptystring' => 'Пустыя радкі не дазволены.',
	'smw_maxstring' => 'Радковае прадстаўленьне «$1» занадта доўгае.',
	'smw_notinenum' => '«$1» не ўваходзіць у сьпіс магчымых значэньняў ($2) для гэтай уласьцівасьці.',
	'smw_noboolean' => '«$1» не зьяўляецца лягічным значэньнем (праўда/няпраўда).',
	'smw_true_words' => 'праўда,п,так,т',
	'smw_false_words' => 'няпраўда,н,не',
	'smw_nofloat' => '«$1» не зьяўляецца лікам.',
	'smw_infinite' => 'Лікі, большыя за «$1», не падтрымліваюцца.',
	'smw_unitnotallowed' => '«$1» не аб’яўленая як дапушчальная адзінка вымярэньняў для гэтай уласьцівасьці.',
	'smw_nounitsdeclared' => 'Няма вызначаных адзінак вымярэньня для гэтай уласьцівасьці.',
	'smw_novalues' => 'Значэньні не пазначаныя',
	'smw_nodatetime' => 'Дата «$1» не была распазнаная.',
	'smw_toomanyclosing' => 'Зашмат уваходжаньняў «$1» у запыце.',
	'smw_noclosingbrackets' => 'Выкарыстаныя дужкі «<nowiki>[[</nowiki>» у Вашым запыце не былі зачынены адпаведнымі дужкамі «]]».',
	'smw_misplacedsymbol' => 'Сымбаль «$1» быў выкарыстаны ў месцы, дзе ён ня мае сэнсу.',
	'smw_unexpectedpart' => 'Частка запыту «$1» не была распазнаная.
Вынікі могуць быць нечаканымі.',
	'smw_emptysubquery' => 'Нейкі падзапыт ня мае слушных умоваў.',
	'smw_misplacedsubquery' => 'Нейкі падзапыт быў выкарыстаны ў месцы, дзе выкарыстаньне падзапытаў не дазволена.',
	'smw_valuesubquery' => 'Падзапыты не падтрымліваюцца для значэньняў уласьцівасьці «$1».',
	'smw_badqueryatom' => 'Частка запыту «<nowiki>[[…]]</nowiki>» не была распазнаная.',
	'smw_propvalueproblem' => 'Значэньне ўласьцівасьці «$1» не было распазнанае.',
	'smw_noqueryfeature' => 'Нейкая ўласьцівасьць не падтрымліваецца ў {{GRAMMAR:месны|{{SITENAME}}}}, і частка запыту была ігнараваная ($1).',
	'smw_noconjunctions' => 'Злучэньні ў запытах не падтрымліваюцца ў {{GRAMMAR:месны|{{SITENAME}}}}, і частка запыту была ігнараваная ($1).',
	'smw_nodisjunctions' => 'Падзяленьні ў запытах не падтрымліваюцца ў {{GRAMMAR:месны|{{SITENAME}}}}, і частка запыту была ігнараваная ($1).',
	'smw_querytoolarge' => 'Наступныя ўмовы запыту ня могуць улічвацца з-за абмежаваньняў {{GRAMMAR:родны|{{SITENAME}}}} на глыбіню і памер запыту: $1.',
	'smw_notemplategiven' => 'Для выкананьня гэтага запыту, неабходна ўвесьці значэньне парамэтру «template».',
	'smw_db_sparqlqueryproblem' => 'Немагчыма атрымаць вынік запыту да базы зьвестак SPARQL. Магчыма гэтая часовая памылка ці праблема праграмнага забесьпячэньня базы зьвестак.',
	'smw_db_sparqlqueryincomplete' => 'Выкананьне запыту было перарванае, з-за таго, што ён зьяўляецца занадта складаным. Некаторыя вынікі могуць адсутнічаць. Калі магчыма, паспрабуйце спрасьціць запыт.',
	'smw_type_header' => 'Уласьцівасьці тыпу «$1»',
	'smw_typearticlecount' => '{{PLURAL:$1|Паказаная $1 уласьцівасьць, якая выкарыстоўвае|Паказаныя $1 уласьцівасьці, якія выкарыстоўваюць|Паказаныя $1 уласьцівасьцяў, якія выкарыстоўваюць}} гэты тып.',
	'smw_attribute_header' => 'Старонкі, якія выкарыстоўваюць уласьцівасьць «$1»',
	'smw_attributearticlecount' => '{{PLURAL:$1|Паказаная $1 старонка, якая выкарыстоўвае|Паказаныя $1 старонкі, якія выкарыстоўваюць|Паказаныя $1 старонак, якія выкарыстоўваюць}} гэтую ўласьцівасьць.',
	'smw_subproperty_header' => 'Падуласьцівасьці',
	'smw_subpropertyarticlecount' => 'Гэта ўласьцівасьць мае $1 {{PLURAL:$1|падуласьцівасьць|падуласьцівасьці|падуласьцівасьцяў}}:',
	'smw_concept_header' => 'Старонкі канцэпцыі «$1»',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Паказаная $1 старонка, якая належыць|Паказаныя $1 старонкі, якія належаць|Паказаныя $1 старонак, якія належаць}} гэтай канцэпцыі.',
	'exportrdf' => 'Экспарт старонак у фармаце RDF',
	'smw_exportrdf_docu' => 'Гэта старонка дазваляе Вам атрымліваць зьвесткі са старонкі ў фармаце RDF.
Каб экспартаваць старонкі, увядзіце іх назвы ніжэй у тэкставым полі, па адной назьве на радок.',
	'smw_exportrdf_recursive' => 'Рэкурсіўны экспарт усіх зьвязаных старонак.
Зьвярніце ўвагу на тое, што вынік можа быць вялікім!',
	'smw_exportrdf_backlinks' => 'Таксама экспартаваць усе старонкі, якія спасылаюцца на экспартаваныя старонкі.
Стварае RDF з поўнай навігацыяй.',
	'smw_exportrdf_lastdate' => 'Не экспартаваць старонкі, якія не зьмяняліся з пададзенага часу.',
	'smw_exportrdf_submit' => 'Экспартаваць',
	'uriresolver' => 'Пераўтваральнік URI',
	'properties' => 'Уласьцівасьці',
	'smw_properties_docu' => 'Наступныя ўласьцівасьці выкарыстоўваюцца ў {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_property_template' => '$1 тыпу $2 ($3)',
	'smw_propertylackspage' => 'Усе ўласьцівасьці павінны мець старонку апісаньня!',
	'smw_propertylackstype' => 'Для гэтай уласьцівасьці не пазначаны ніякі тып (пакуль будзе выкарыстоўвацца тып $1).',
	'smw_propertyhardlyused' => 'Гэтая ўласьцівасьць наўрад ці выкарыстоўваецца ў {{GRAMMAR:месны|{{SITENAME}}}}!',
	'unusedproperties' => 'Уласьцівасьці, якія не выкарыстоўваюцца',
	'smw_unusedproperties_docu' => 'Наступныя ўласьцівасьці існуюць, але не выкарыстоўваюцца ніякімі старонкамі.',
	'smw_unusedproperty_template' => '$1 тыпу $2',
	'wantedproperties' => 'Запатрабаваныя ўласьцівасьці',
	'smw_wantedproperties_docu' => 'Наступныя ўласьцівасьці выкарыстоўваюцца ў {{GRAMMAR:месны|{{SITENAME}}}}, але пакуль ня маюць апісаньня.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|выкарыстаньне|выкарыстаньні|выкарыстаньняў}})',
	'smw_purge' => 'Абнавіць',
	'types' => 'Тыпы',
	'smw_types_docu' => 'Ніжэй пададзены сьпіс усіх тыпаў зьвестак, якія можна выкарыстоўваць для ўласьцівасьцяў.',
	'semanticstatistics' => 'Сэмантычная статыстыка',
	'smw_semstats_text' => "{{SITENAME}} утрымлівае '''$1''' {{PLURAL:$1|значэньне|значэньні|значэньняў}} для '''$2''' [[Special:Properties|{{PLURAL:$1|уласьцівасьці|уласьцівасьцяў|ўласьцівасьцяў}}]].
<b>$3</b> {{PLURAL:$3|уласьцівасьць мае|уласьцівасьці маюць|уласьцівасьцяў маюць}} асабістыя старонкі, і пазначаны тып зьвестак падыходзіць для <b>$4</b> зь іх.
Некаторыя з існуючых уласьцівасьцяў могуць [[Special:UnusedProperties|не выкарыстоўвацца]].
Уласьцівасьці, якія яшчэ ня маюць асобных старонак, знаходзяцца ў [[Special:WantedProperties|сьпісе старонак, якія патрабуюць апісаньня]].",
	'smw_uri_doc' => 'Пераўтваральнік URI ажыцьцяўляе <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">пошук W3C TAG у httpRange-14</a>.
Гэта забясьпечвае ўпэўненасьць, што людзі не заходзяць на сайты.',
	'ask' => 'Сэмантычны пошук',
	'smw_ask_sortby' => 'Сартаваць па слупку (неабавязкова)',
	'smw_ask_ascorder' => 'Па павелічэньні',
	'smw_ask_descorder' => 'Па зьмяншэньні',
	'smw_ask_submit' => 'Шукаць',
	'smw_ask_editquery' => '[Рэдагаваць запыт]',
	'smw_add_sortcondition' => '[Дадаць умовы сартаваньня]',
	'smw_ask_hidequery' => 'Схаваць запыт',
	'smw_ask_help' => 'Дапамога па стварэньні запытаў',
	'smw_ask_queryhead' => 'Запыт',
	'smw_ask_printhead' => 'Паказваць дадатковыя зьвесткі',
	'smw_ask_printdesc' => '(дадавайце адну назву ўласьцівасьці на радок)',
	'smw_ask_format_as' => 'Фарматаваць як:',
	'smw_ask_defaultformat' => 'па змоўчваньні',
	'smw_ask_otheroptions' => 'Іншыя налады',
	'smw_ask_show_embed' => 'Паказаць убудаваны код',
	'smw_ask_hide_embed' => 'Схаваць убудаваны код',
	'smw_ask_embed_instr' => 'Каб убудаваць гэты запыт у старонку, выкарыстоўвайце код пададзены ніжэй.',
	'smw-ask-delete' => '[Выдаліць]',
	'querycreator' => 'Стваральнік запыту',
	'smw_qc_addmainlabel' => 'Дадаць галоўную метку',
	'smw_qc_show_addnal_opts' => 'Паказаць болей наладаў',
	'smw_qc_hide_addnal_opts' => 'Паказаць меней наладаў',
	'smw_qc_otheropt' => 'Іншыя налады',
	'smw_qc_intro' => 'Уступ:',
	'smw_qc_outro' => 'Заканчэньне:',
	'smw_qc_default' => 'Па змоўчваньні:',
	'smw_qc_formatopt' => 'Налады фармату',
	'smw_qc_query_help' => 'Увядзіце запыт з дапамогай формы пададзенай ніжэй для выбару вікі-старонкі па
Катэгорыям (<strong>[[{{ns:category}}:Актор]]</strong>), 
Уласьцівасьцям (<strong>[[Знаходзіцца ў::Нямеччыне]]</strong>), 
Назвам(<strong>[[Нямеччына]]</strong>) і Прасторам назваў (<strong>[[{{ns:help}}:+]]</strong>)', # Fuzzy
	'smw_qui_property' => '<strong>Уласьцівасьць</strong>',
	'smw_qui_prop' => 'Уласьцівасьць:',
	'smw_qui_labl' => 'Метка:',
	'smw_qui_formt' => 'Фармат:',
	'smw_qui_limt' => 'Ліміт:',
	'smw_qui_shownresults' => 'паказаць у выніках',
	'smw_qui_noquery' => 'Запыт не пазначаны',
	'smw_qui_invalidprop' => '«$1» можа не зьяўляецца слушнай уласьцівасьцю',
	'smw_qui_invalidformat' => 'Выбраны фармат «$1» не існуе ў {{GRAMMAR:месны|{{SITENAME}}}}',
	'smw_qui_nosort' => 'Няма сартаваньня',
	'smw_qui_ascorder' => 'Па павелічэньні',
	'smw_qui_descorder' => 'Па зьмяншэньні',
	'smw_qui_randorder' => 'Выпадковая',
	'smw_qui_addnprop' => 'дадаць уласьцівасьць',
	'smw_qui_delete' => 'Выдаліць',
	'smw_qui_rescol' => 'Адпаведнасьці запыту',
	'smw_qui_options' => 'налады',
	'smw_qui_addcategory' => 'дадаць катэгорыю',
	'smw_qui_addrescol' => 'дадаць адпаведнасьці запыту',
	'smw_qui_ok' => 'Добра',
	'smw_qui_cancel' => 'Скасаваць',
	'smw_qui_category' => '<strong>Катэгорыя</strong>',
	'smw_qui_label' => 'Метка',
	'smw_prp_options' => 'Налады ўласьцівасьці',
	'smw_qui_catopts' => 'Налады катэгорыі',
	'smw_qui_mainlabopts' => 'Налады выніку',
	'smw_qui_dlabel' => 'Метка:',
	'smw_qui_dcategory' => 'Катэгорыя:',
	'smw_qui_dcatyes' => 'Паказваць тэкст, калі катэгорыя існуе:',
	'smw_qui_dcatno' => 'Паказваць тэкст, калі катэгорыі не існуе:',
	'searchbyproperty' => 'Шукаць па ўласьцівасьці',
	'smw_sbv_docu' => 'Шукаць усе старонкі, якія ўтрымліваюць пададзеную ўласьцівасьць і значэньне.',
	'smw_sbv_novalue' => 'Увядзіце значэньне для ўласьцівасьці, ці паглядзіце ўсе значэньні ўласьцівасьцяў для «$1».',
	'smw_sbv_displayresult' => 'Сьпіс усіх старонак, якія ўтрымліваюць уласьцівасьць «$1» са значэньнем «$2»',
	'smw_sbv_displayresultfuzzy' => 'Сьпіс усіх старонак, якія ўтрымліваюць уласьцівасьць «$1» са значэньнем «$2».
З-за таго, што супала толькі некалькі вынікаў, паказаны старонкі, якія маюць блізкія значэньні.',
	'smw_sbv_property' => 'Уласьцівасьць:',
	'smw_sbv_value' => 'Значэньне:',
	'smw_sbv_submit' => 'Знайсьці',
	'browse' => 'Праглядзець {{GRAMMAR:родны|{{SITENAME}}}}',
	'smw_browselink' => 'Праглядзець уласьцівасьці',
	'smw_browse_article' => 'Увядзіце назву старонкі для пачатку прагляду.',
	'smw_browse_go' => 'Перайсьці',
	'smw_browse_show_incoming' => 'паказаць уласьцівасьці, якія спасылаюцца сюды',
	'smw_browse_hide_incoming' => 'схаваць уласьцівасьці, якія спасылаюцца сюды',
	'smw_browse_no_outgoing' => 'Гэта старонка ня мае ўласьцівасьцяў.',
	'smw_browse_no_incoming' => 'На гэту старонку не спасылаюцца ніякія ўласьцівасьці.',
	'smw_inverse_label_default' => '$1 з',
	'smw_inverse_label_property' => 'Паметка адваротнай уласьцівасьці',
	'pageproperty' => 'Старонка пошуку ўласьцівасьцяў',
	'smw_pp_docu' => 'Пошук усіх значэньняў уласьцівасьцяў на пададзенай старонцы.
Увядзіце назвы старонкі і ўласьцівасьці.',
	'smw_pp_from' => 'Са старонкі',
	'smw_pp_type' => 'Уласьцівасьць',
	'smw_pp_submit' => 'Шукаць',
	'smw_result_prev' => 'Папярэднія',
	'smw_result_next' => 'Наступныя',
	'smw_result_results' => 'Вынікі',
	'smw_result_noresults' => 'Вынікаў няма.',
	'smwadmin' => 'Адміністраваньне Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Сховішча было настроенае пасьпяхова.',
	'smw_smwadmin_return' => 'Вярнуцца да $1',
	'smw_smwadmin_updatestarted' => 'Быў распачаты новы працэс абнаўленьня сэмантычных зьвестак.
Усе зьвесткі будуць пераўтвораны, ці зьменены калі гэта будзе неабходна.
Вы можаце назіраць за працэсам абнаўленьня на гэтай спэцыяльнай старонцы.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Працэс абнаўленьня ўжо распачаты.
Не стварайце новы.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Усе існуючыя працэсы абнаўленьня былі спынены.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Каб спыніць працэс абнаўленьня, Вам неабходна паставіць паметку ў полі, каб пацьвердзіць Вашыя намеры.', # Fuzzy
	'smw_smwadmin_docu' => 'Гэта спэцыяльная старонка дапамагае Вам пад час усталяваньня і абнаўленьня <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Не забывайце захоўваць каштоўныя зьвесткі перад выкананьнем адміністратарскіх функцыяў.',
	'smw_smwadmin_db' => 'Усталяваньне і абнаўленьне базы зьвестак',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki патрабуе некаторыя пашырэньні, каб база зьвестак MediaWiki змагла захоўваць сэмантычныя зьвесткі.
Наступная функцыя гарантуе, што Вашая база зьвестак усталяваная правільна.
Зьмены, зробленыя на гэтым этапе, не паўплываюць на астатнія базы зьвестак MediaWiki, і могуць быць лёгка адмененыя па жаданьні.
Гэта ўсталёвачная функцыя можа быць выкананая некалькі разоў без аніякай шкоды, але для ўсталяваньня ці абнаўленьня дастаткова будзе аднаго разу.',
	'smw_smwadmin_permissionswarn' => 'Калі адбываюцца SQL-памылкі пад час выкананьня апэрацыі, то гэта азначае, што рахунак базы зьвестак, які выкарыстоўвае {{SITENAME}} (праверце Вашыя LocalSettings.php), магчыма ня мае адпаведных правоў.
Надайце рахунку дадатковыя правы на стварэньне і выдаленьне табліцаў, часова ўвядзіце рахунак адміністратара базы зьвестак у LocalSettings.php, ці карыстайцеся скрыптом падтрымкі <tt>SMW_setup.php</tt>, які можа выкарыстоўваць рахунак з AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Усталяваць ці абнавіць табліцы',
	'smw_smwadmin_announce' => 'Анансуйце {{GRAMMAR:вінавальны|{{SITENAME}}}}',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki мае сэрвіс для анансаваньня новых сэмантычных вікі-сайтаў.
Яна выкарыстоўваецца для падтрымкі сьпісу публічных сайтаў, якія выкарыстоўваюць Semantic MediaWiki, у асноўным для таго, каб дапамагчы <a href="http://semantic-mediawiki.org/wiki/SMW_Project">праекту Semantic MediaWiki</a> атрымаць агляд тыповых выкарыстаньняў Semantic MediaWiki.
Глядзіце хатнюю старонку Semantic MediaWiki для <a href="http://semantic-mediawiki.org/wiki/Registry">атрыманьня дадатковай інфармацыі пра гэты сэрвіс</a>.',
	'smw_smwadmin_announcebutton' => 'Націсьніце наступную кнопку, каб дадаць спасылку на {{GRAMMAR:вінавальны|{{SITENAME}}}} да гэтага сэрвісу.
Сэрвіс не рэгіструе вікі, якія ня маюць публічнага доступу, таму што ён захоўвае толькі агульнадаступную інфармацыю.',
	'smw_smwadmin_datarefresh' => 'Выпраўленьне і абнаўленьне зьвестак',
	'smw_smwadmin_datarefreshdocu' => 'Існуе магчымасьць аднаўленьня ўсіх зьвестак Semantic MediaWiki на аснове цяперашняга зьместу {{GRAMMAR:родны|{{SITENAME}}}}.
Гэта можа быць карысным для аднаўленьня парушаных зьвестак ці абнаўленьня зьвестак, калі ўнутраны фармат зьмяняецца пры абнаўленьні праграмнага забесьпячэньня.
Абнаўленьне будзе выконвацца старонка за старонкай і можа заняць пэўны час.
Ніжэй паказваецца інфармацыя, ці адбываецца абнаўленьне, якая дазваляе Вам пачынаць ці спыняць абнаўленьне (за выключэньнем выпадкаў, калі гэта магчымасьць забароненая адміністратарам сайта).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Ідзе працэс абнаўленьня.</strong>
Гэта нармальна, што працэс абнаўленьня запавольваецца, і зьвесткі абнаўляюцца невялікімі кавалкамі.
Каб скончыць абнаўленьне хутчэй, Вы можаце скарыстацца скрыптом падтрымкі МэдыяВікі <tt>runJobs.php</tt> (выкарыстоўвайце парамэтар <tt>--maxjobs 1000</tt>, каб абмежаваць колькасьць выкананых абнаўленьняў у адным пакеце).
Прыкладны час сканчэньня цяперашняга абнаўленьня:',
	'smw_smwadmin_datarefreshbutton' => 'Пачаць абнаўленьне зьвестак',
	'smw_smwadmin_datarefreshstop' => 'Спыніць гэта абнаўленьне',
	'smw_smwadmin_datarefreshstopconfirm' => 'Так, я ўпэўнены.',
	'smw_smwadmin_support' => 'Падтрымка',
	'smw_smwadmin_supportdocu' => 'Вы можаце знайсьці дапамогу ў розных крыніцах у выпадку праблемаў:',
	'smw_smwadmin_installfile' => 'Калі ўзьнікнуць выпадковыя праблемы з Вашым усталяваньнем, пачніце з рэкамэндацыяў у <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">файле INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Поўная дакумэнтацыя Semantic MediaWiki знаходзіцца на <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Можна паведамляць пра памылкі ў <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Калі Вы маеце пытаньні ці прапановы, далучайцеся да дыскусіі на <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">форуме карыстальнікаў Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Структура зьвестак',
	'smw_adminlinks_displayingdata' => 'Паказ зьвестак',
	'smw_adminlinks_inlinequerieshelp' => 'Дапамога па ўбудаваных запытах',
	'smw-createproperty-isproperty' => 'Гэта ўласьцівасьць тыпу $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Дазволенае значэньне|Дазволеныя значэньні}} для гэтай уласьцівасьці:',
	'smw_unknowntype' => 'Тып «$1» не падтрымліваецца для гэтай уласьцівасьці.', # Fuzzy
);

/** Bulgarian (български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'smw_viewasrdf' => 'RDF емисия',
	'smw_factbox_head' => 'Факти за $1',
	'smw_printername_template' => 'Шаблон',
	'smw_iq_disabled' => 'Съжаляваме. Семантичните заявки са изключени в това уики.',
	'smw_notitle' => '„$1“ не може да се използва като име на страница в това уики.',
	'smw_wrong_namespace' => 'Тук са позволени само страници от именното пространство „$1“.',
	'smw_emptystring' => 'Празните низове са неприемливи.',
	'smw_nofloat' => '„$1“ не е число.',
	'smw_rss_description' => '$1 RSS емисия',
	'exportrdf' => 'Изнасяне на страниците към RDF',
	'smw_exportrdf_docu' => 'Тази страница позволява да се извлечат данните опт страница в RDF формат.
За изнасяне на страници, въведете заглавията в текстовата кутия по-долу (по едно заглавие на ред).',
	'smw_exportrdf_recursive' => 'Рекурсивно изнасяне на всички свързани страници.
Обърнете внимание, че резултатът може да е огромен!',
	'smw_exportrdf_lastdate' => 'Без изнасяне на страници, които не са променяни от посоченото време.',
	'smw_exportrdf_submit' => 'Изнасяне',
	'smw_property_template' => '$1 от типа $2 ($3)',
	'smw_unusedproperty_template' => '$1 от типа $2',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|използване|използвания}})',
	'smw_purge' => 'Опресняване',
	'types' => 'Типове',
	'semanticstatistics' => 'Семантични статистики',
	'ask' => 'Семантично търсене',
	'smw_ask_sortby' => 'Сортиране по колона (незадължително)',
	'smw_ask_ascorder' => 'Възходящ',
	'smw_ask_descorder' => 'Низходящ',
	'smw_ask_editquery' => '[Редактиране на заявката]',
	'smw_add_sortcondition' => '[Добавяне на условие за сортиране]',
	'smw_ask_hidequery' => 'Скриване на заявката',
	'smw_ask_queryhead' => 'Заявка',
	'smw_sbv_value' => 'Стойност:',
	'smw_browse_go' => 'Отваряне',
	'smw_pp_from' => 'От страница',
	'smw_result_prev' => 'Предишни',
	'smw_result_next' => 'Следващи',
	'smw_result_results' => 'Резултати',
	'smw_result_noresults' => 'Съжаляваме, няма резултати.',
	'smwadmin' => 'Администраторски функции за Semantic MediaWiki',
);

/** Bengali (বাংলা)
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'smw_viewasrdf' => 'আরডিএফ ফিড',
	'smw_finallistconjunct' => ', এবং',
	'smw_dsv_link' => 'ডিএসভি',
	'smw_printername_csv' => 'সিএসভি রপ্তাপি',
	'smw_printername_dsv' => 'ডিএসভি রপ্তাপি',
	'smw_printername_debug' => 'ডিবাগ কোয়েরি (বিশেষজ্ঞদের জন্য)',
	'smw_printername_json' => 'জেএসঅন রপ্তানি',
	'smw_printername_list' => 'তালিকা',
	'smw_printername_rss' => 'আরএসএস রপ্তানি',
	'smw_printername_table' => 'ছক',
	'smw_printername_broadtable' => 'প্রশস্ত ছক',
	'smw_printername_template' => 'টেম্পলেট',
	'smw_printername_rdf' => 'আরডিএফ রপ্তানি',
	'smw_ask_queryhead' => 'কোয়েরি',
	'smw_sbv_value' => 'মান:',
	'smw_sbv_submit' => 'ফলাফল খুঁজুন',
	'browse' => 'উইকি ব্রাউজ',
	'smw_browse_go' => 'চলো',
	'smw_pp_from' => 'পাতা থেকে',
	'smw_pp_submit' => 'ফলাফল খুঁজুন',
	'smw_result_prev' => 'পূর্ববর্তী',
	'smw_result_next' => 'পরবর্তী',
	'smw_result_results' => 'ফলাফল',
	'smw_result_noresults' => 'ফলাফল নেই।',
	'smw_smwadmin_datarefreshbutton' => 'উপাত্ত হালনাগাদ শুরু',
	'smw_smwadmin_datarefreshstop' => 'এই হালানাগাদ বন্ধ করুন',
	'smw_smwadmin_datarefreshstopconfirm' => 'হ্যাঁ, আমি নিশ্চিত।',
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Gwendal
 * @author Y-M D
 */
$messages['br'] = array(
	'smw-desc' => "Aesaat monedusted ho wiki - evit ar mekanikoù ''hag'' an dud ([http://semantic-mediawiki.org/wiki/Help:User_manual diellerezh enlinenn])",
	'smw_viewasrdf' => 'Gwelet evel RDF',
	'smw_finallistconjunct' => ', ha',
	'smw_factbox_head' => 'Fedoù diwar-benn $1',
	'smw_isspecprop' => 'Ar perzh-mañ zo ur perzh arbennik er wiki-mañ',
	'smw_concept_description' => 'Deskrivadur eus ar meizad « $1 »',
	'smw_no_concept_namespace' => "N'hall ar meizadoù bezañ termenet nemet e pajennoù an esaouenn anv Concept:.",
	'smw_multiple_concepts' => "Pep pajenn meizad na c'hell kaout nemet un dermenadur.",
	'smw_noinvannot' => "Ne c'hell ket an talvoudennoù bezañ derannet evit eilpennañ perzhioù.",
	'version-semantic' => 'Astennoù steroniezh',
	'smw_baduri' => 'An URLoù er stumm « $1 » n"int ket aotreet.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => "Kontañ an disoc'hoù",
	'smw_printername_csv' => 'Ezporzh CSV',
	'smw_printername_dsv' => 'Ezporzhiañ e DSV',
	'smw_printername_debug' => 'Reked dizreinañ (evit an arbennigourien)',
	'smw_printername_embedded' => "Danvez ar pajennoù ensoc'het",
	'smw_printername_json' => 'ezporzhiadur JSON',
	'smw_printername_list' => 'Roll',
	'smw_printername_ol' => 'Niverenniñ',
	'smw_printername_ul' => 'Munudoù',
	'smw_printername_rss' => 'Ezporzh RSS',
	'smw_printername_table' => 'Taolenn',
	'smw_printername_broadtable' => 'Taolenn ledan',
	'smw_printername_template' => 'Patrom',
	'smw_printername_rdf' => 'Ezporzh RDF',
	'smw_printername_category' => 'Rummad',
	'smw-paramdesc-limit' => "An niver uhelañ a zisoc'hoù da adkas",
	'smw-paramdesc-headers' => 'Diskwel an talbennoù / anvioù ar perzhioù',
	'smw-paramdesc-mainlabel' => 'Al label hag a ro anv ar bajenn degemer',
	'smw-paramdesc-link' => 'Diskouez an talvoudoù evel liammoù',
	'smw-paramdesc-intro' => "An destenn da ziskouez a-raok disoc'hoù ar reked, ma 'z eus",
	'smw-paramdesc-outro' => "An destenn da ziskouez goude disoc'hoù ar reked, mar bez",
	'smw-paramdesc-default' => "An destenn da ziskwel ma n'eus disoc'h ebet d'ar reked",
	'smw-paramdesc-sep' => 'An disranner evit an talvoudoù',
	'smw-paramdesc-template' => "Anv ar patrom d'ober gantañ evit diskouez ar moulladurioù",
	'smw-paramdesc-columns' => "An niver a golonennoù evit pere ez eus da ziskouez an disoc'hoù ($1 dre ziouer)",
	'smw-paramdesc-userparam' => 'Un dalvoudenn tremenet dre pep galvadenn patromoù, pa vez implijet ur patrom',
	'smw-paramdesc-introtemplate' => "Anv ar patrom da ziskouez a-raok disoc'hoù ar reked, mar bez",
	'smw-paramdesc-outrotemplate' => "Anv ar patrom da ziskouez goude disoc'hoù ar reked, mar bez",
	'smw-paramdesc-embedformat' => 'An dikedenn HTML a servij da dermeniñ an talbennoù',
	'smw-paramdesc-embedonly' => 'Na ziskwel talbenn ebet',
	'smw-paramdesc-rsstitle' => 'Testenn da implijout evel titl ar gwazhioù',
	'smw-paramdesc-rssdescription' => 'Testenn da implijout evel deskrivadur ar gwazhioù',
	'smw-paramdesc-rdfsyntax' => 'An ereadur RDF da vezañ implijet',
	'smw-paramdesc-csv-sep' => "An dispartier d'ober gantañ",
	'smw-paramdesc-dsv-separator' => "An dispartier d'ober gantañ",
	'smw-paramdesc-dsv-filename' => 'Anv ar restr DSV',
	'smw-paramdesc-searchlabel' => "Testenn al liamm davet an disoc'hoù", # Fuzzy
	'smw_iq_disabled' => 'Diweredekaet eo bet ar goulennoù semantek evit ar wiki-mañ.',
	'smw_iq_moreresults' => "... disoc'hoù all",
	'smw_parseerror' => "An talvoud merket n'eo ket bet komprenet.",
	'smw_notitle' => "« $1 » ne c'hall ket bezañ implijet da anv pajenn er wiki-mañ.",
	'smw_wrong_namespace' => 'N\'eo aotreet amañ nemet ar pajennoù eus an esaouenn "$1".',
	'smw_manytypes' => 'Ouzhpenn ur seurt zo bet termenet evit ar perzh.',
	'smw_emptystring' => 'Ne zegemerer ket an neudennadoù goullo.',
	'smw_maxstring' => 'Re hir eo an neudennad $1.',
	'smw_notinenum' => "« $1 » n'emañ ket er roll talvoudoù posupl ($2) evit ar perzh-mañ.",
	'smw_noboolean' => 'N\'eo ket anavezet "$1" evel un talvoudenn Boolean (gwir/gaou).',
	'smw_true_words' => 'gwir,g,ya,true',
	'smw_false_words' => 'gaou,g,nann,n,false',
	'smw_nofloat' => '"$1" n\'eo ket un niver.',
	'smw_infinite' => "Niveroù ken bras ha « $1 » n'int ket skoret.",
	'smw_novalues' => "N'eus bet diferet talvoudoù ebet.",
	'smw_nodatetime' => 'An deiziad « $1 » n’eo ket bet komprenet.',
	'smw_toomanyclosing' => 'Re a reveziadennoù eus « $1 » zo er reked.',
	'smw_noclosingbrackets' => 'Implijout \'zo eus "<nowiki>[[</nowiki>" en ho reked n\'int ket bet serret gant ar "]]" a glot.',
	'smw_misplacedsymbol' => "Implijet eo bet an arouezenn « $1 » en ul lec'h ma n'eo ket talvoudus.",
	'smw_unexpectedpart' => "Al lodenn « $1 » eus ar reked n'eo ket bet komprenet.
Dic'hortoz e c'hall bezañ an disoc'hoù.",
	'smw_emptysubquery' => "Is-rekedoù 'zo o deus un amplegad direizh.",
	'smw_misplacedsubquery' => "Is-rekedoù 'zo a zo bet implijet en ul lec'h ma n'eo aotreet is-reked ebet.",
	'smw_valuesubquery' => "Isreked n'eo ket skoret evit talvoudoù ar perzh « $1 ».",
	'smw_badqueryatom' => "Al lodennoù « <nowiki>[[…]]</nowiki> » eus ar reked n'int ket bet komprenet.",
	'smw_propvalueproblem' => "Talvoud ar perzh « $1 » n'eo ket bet komprenet.",
	'smw_noqueryfeature' => "Un nebeut arc'hweladurioù rekedoù n'int ket skoret war ar wiki-mañ hag ul lodenn outo n'int ket bet tennet ($1).",
	'smw_notemplategiven' => 'Ret eo deoc\'h merkañ un talvoud evit an arventenn "patrom" evit ma c\'hallfe mont en-dro ar furmad goulenn-mañ.',
	'smw_type_header' => 'Perzhioù eus ar seurt « $1 »',
	'smw_typearticlecount' => 'Diskouez $1 {{PLURAL:$1|perzh|perzh}} a implij ar seurt-mañ.',
	'smw_attribute_header' => 'Pajennoù a implij ar perzh « $1 »',
	'smw_attributearticlecount' => 'Afficher {{PLURAL:$1|ar bajenn|an $1 pajenn}} a implij ar perzh-mañ.',
	'smw_subproperty_header' => 'Isperzhioù',
	'smw_subpropertyarticlecount' => 'Ar perzh he deus an {{PLURAL:$1||$1 }}is-perzh da-heul :',
	'smw_concept_header' => 'Pajennoù ar meizad « $1 »',
	'smw_conceptarticlecount' => 'Diskouez {{PLURAL:$1|ar bajenn|ar $1 pajenn}} diazezet war ar meizad-se',
	'exportrdf' => 'Ezporzhiañ pajennoù en RDF',
	'smw_exportrdf_lastdate' => "Arabat ezporzhiañ ar pajennoù n'int ket bet kemmet abaoe ar c'houlz merket.",
	'smw_exportrdf_submit' => 'Ezporzhiañ',
	'uriresolver' => 'Diskoulmer URI',
	'properties' => 'Perzhioù',
	'smw_properties_docu' => 'Ar perzhioù-mañ zo implijet er wiki.',
	'smw_property_template' => '$1 eus ar seurt $2 ($3)',
	'smw_propertylackspage' => 'An holl berzhioù a rank bezañ deskrivet gant ur bajenn !',
	'smw_propertyhardlyused' => 'Ar perzh-mañ a vez implijet a-boan er wiki !',
	'unusedproperties' => 'Perzhioù dizimplij',
	'smw_unusedproperties_docu' => 'Ar perzhioù-mañ zo anezho daoust ma ne vezont implijet gant pajenn all ebet.',
	'smw_unusedproperty_template' => '$1 eus ar seurt $2',
	'wantedproperties' => "Perzhioù c'hoantaet",
	'smw_wantedproperties_docu' => "Ar perzhioù-mañ zo implijet er wiki met n'eus pajenn ebet c'hoazh evit o deskrivañ.",
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|implij|implij}})',
	'smw_purge' => 'Freskaat',
	'types' => 'Seurtoù roadennoù',
	'semanticstatistics' => 'Stadegoù semantek',
	'ask' => 'Klask semantek',
	'smw_ask_sortby' => 'Urzhiañ dre vannoù (diret)',
	'smw_ask_ascorder' => 'War gresk',
	'smw_ask_descorder' => 'War zigresk',
	'smw_ask_submit' => "Kavout disoc'hoù",
	'smw_ask_editquery' => '[Kemmañ ar reked]',
	'smw_add_sortcondition' => '[ouzhpennañ un diviz urzhiañ]',
	'smw_ask_hidequery' => 'Kuzhat ar reked',
	'smw_ask_help' => 'Skoazell evit ar rekedoù',
	'smw_ask_queryhead' => 'Reked',
	'smw_ask_printhead' => 'Roadennoù ouzhpenn da ziskwel',
	'smw_ask_printdesc' => '(ouzhpennañ un anv perzh dre linenn)',
	'smw_ask_format_as' => 'Furmadiñ evel :',
	'smw_ask_defaultformat' => 'dre ziouer',
	'smw_ask_otheroptions' => 'Dibarzhioù all',
	'smw_ask_show_embed' => "Diskouez ar c'hod enframmet",
	'smw_ask_hide_embed' => "Kuzhat ar c'hod enframmet",
	'smw_ask_embed_instr' => "Evit enklozañ ar reked-mañ enlinenn e-barzh ur bajenn wiki, implijit ar c'hod amañ dindan.",
	'smw-ask-delete' => '[Diverkañ]',
	'smw_qc_show_addnal_opts' => 'Diskouez dibarzhioù ouzhpenn',
	'smw_qc_hide_addnal_opts' => "Diskouez nebeutoc'h a zibarzhioù",
	'smw_qc_otheropt' => 'Dibarzhioù all',
	'smw_qc_default' => 'Dre ziouer:',
	'smw_qui_property' => "<strong>Perc'henniezh </strong>",
	'smw_qui_prop' => "Perc'henniezh",
	'smw_qui_formt' => 'Furmad :',
	'smw_qui_limt' => 'Bevenn :',
	'smw_qui_shownresults' => "diskouez en disoc'hoù",
	'smw_qui_nosort' => 'Arabat urzhiañ',
	'smw_qui_ascorder' => 'War gresk',
	'smw_qui_descorder' => 'War zigresk',
	'smw_qui_randorder' => 'Dargouezhek',
	'smw_qui_addnprop' => "ouzhpennañ ar perc'henniezh",
	'smw_qui_delete' => 'Dilemel',
	'smw_qui_options' => 'dibarzhioù',
	'smw_qui_addcategory' => 'Ouzhpennañ ar rummad',
	'smw_qui_ok' => 'Mat eo',
	'smw_qui_cancel' => 'Nullañ',
	'smw_qui_category' => '<strong>Rummad</strong>',
	'smw_qui_label' => 'Tikedenn',
	'smw_prp_options' => "Dibarzhioù perc'henniezh",
	'smw_qui_catopts' => 'Dibarzhioù ar rummadoù',
	'smw_qui_mainlabopts' => "Dibarzhioù evit an disoc'hoù",
	'smw_qui_dlabel' => 'Tikedenn:',
	'smw_qui_dcategory' => 'Rummad :',
	'smw_qui_dcatyes' => 'Diskouez an destenn pa vez eus ar rummad:',
	'searchbyproperty' => 'Klask dre berzh',
	'smw_sbv_docu' => 'Klask an holl bajennoù dezho ur perzh hag un dalvoudenn roet.',
	'smw_sbv_novalue' => 'Ebarzhiñ un talvoud evit ar perzh, pe gwelet holl dalvoudoù ar perzhioù evit « $1 ».',
	'smw_sbv_displayresult' => 'Roll eus an holl bajennoù gant ar perzh « $1 » gant an talvoud « $2 ».',
	'smw_sbv_property' => 'Perzh :',
	'smw_sbv_value' => 'Talvoud :',
	'smw_sbv_submit' => "Kavout disoc'hoù",
	'browse' => 'Furchal ar wiki',
	'smw_browselink' => 'Furchal ar perzhioù',
	'smw_browse_article' => 'Ebarzhit anv ar bajenn da gregiñ da furchal ganti.',
	'smw_browse_go' => 'Mont',
	'smw_browse_show_incoming' => "diskouez ar perc'henniezhioù a gas betek amañ",
	'smw_browse_hide_incoming' => "kuzhat ar perc'henniezhioù a gas betek amañ",
	'smw_browse_no_outgoing' => "Ar bajenn-mañ n'he deus perzh ebet.",
	'smw_browse_no_incoming' => "Perc'henniezh ebet a gas betek ar bajenn-mañ.",
	'smw_inverse_label_default' => '$1 eus',
	'smw_inverse_label_property' => 'Label ar perzh eilpennet',
	'pageproperty' => 'Klask e perzhioù ar bajenn',
	'smw_pp_from' => 'Adalek ar bajenn',
	'smw_pp_type' => 'Perzh',
	'smw_pp_submit' => "Kavout disoc'hoù",
	'smw_result_prev' => 'Kent',
	'smw_result_next' => "War-lerc'h",
	'smw_result_results' => "Disoc'hoù",
	'smw_result_noresults' => "Disoc'h ebet.",
	'smwadmin' => "Arc'hwelioù merañ evit Semantic MediaWiki",
	'smw_smwadmin_setupsuccess' => "Staliet-mat eo ar c'heflusker stokañ.",
	'smw_smwadmin_return' => 'Distreiñ da $1',
	'smw_smwadmin_updatenotstarted' => 'Emeur krog dija gant un argerzh hizivaat.
Arabat krouiñ unan all.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Ehanet eo bet an holl argerzhoù hizivaat.', # Fuzzy
	'smw_smwadmin_db' => 'Staliañ ha lakaat an diaz roadennoù a-live',
	'smw_smwadmin_dbbutton' => 'Deraouekaat pe lakaat taolennoù a-live',
	'smw_smwadmin_announce' => 'Brudañ ho wiki',
	'smw_smwadmin_datarefresh' => 'Dresañ ha lakaat ar roadennoù a-live',
	'smw_smwadmin_datarefreshbutton' => 'Kregiñ da hizivaat ar roadennoù',
	'smw_smwadmin_datarefreshstop' => 'Paouez gant an hizivadenn-mañ',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ya, sur on.',
	'smw_smwadmin_support' => 'Kaout skoazell',
	'smw_smwadmin_supportdocu' => "Dafar a bep seurt a c'hallfe ho skoazellañ ma vez kudennoù :",
	'smw_smwadmin_smwhomepage' => 'Emañ teul titouriñ klok implijerien Semantic MediaWiki e <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'An drein a c\'hall bezañ danevellet da <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Ma chom goulennoù ganeoc\'h pe kinnigoù, kemerit perzh er gaoz war <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forom implijerien Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Framm ar roadennoù',
	'smw_adminlinks_displayingdata' => 'Diskwel roadennoù',
	'smw_adminlinks_inlinequerieshelp' => 'Skoazell evit ar rekedoù enlinenn',
	'smw-createproperty-isproperty' => 'Ar perzh-mañ zo eus ar seurt $1.',
	'smw-createproperty-allowedvals' => 'An talvoudenn{{PLURAL:$1||où}} aotreet evt ar perzh-se a zo :',
	'smw-paramdesc-category-delim' => 'Ar bevenner',
	'smw_unknowntype' => 'Ar seurt roadennoù "$1" nann skoret a zo distroet d\'an doareenn', # Fuzzy
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'smw_viewasrdf' => 'RDF fid',
	'smw_finallistconjunct' => ' i',
	'smw_factbox_head' => 'Činjenice o $1',
	'smw_isspecprop' => 'Ovo svojstvo je posebna osobina na ovoj wiki.',
	'smw_concept_description' => 'Opis koncepta "$1"',
	'version-semantic' => 'Semantička proširenja',
	'smw_printername_count' => 'Rezultati brojanja',
	'smw_printername_csv' => 'CSV izvoz',
	'smw_printername_json' => 'JSON izvoz',
	'smw_printername_list' => 'Spisak',
	'smw_printername_ul' => 'Ispit stavki',
	'smw_printername_rss' => 'RSS izvoz',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Široka tabela',
	'smw_printername_template' => 'Šablon',
	'smw-paramdesc-link' => 'Prikaži vrijednosti kao linkove',
	'smw-paramdesc-embedonly' => 'Ne prikazuj zaglavlja',
	'smw_iq_disabled' => 'Semantički upiti su onemogućeni na ovoj wiki.',
	'smw_iq_moreresults' => '...ostali rezultati',
	'smw_parseerror' => 'Navedena vrijednost nije razumljiva.',
	'smw_emptystring' => 'Prazni izrazi nisu prihvatljivi.',
	'smw_maxstring' => 'Prikazivanje izraza $1 je predugačko.',
	'smw_nofloat' => '"$1" nije broj.',
	'smw_nodatetime' => 'Datum "$1" nije razumljiv.',
	'smw_exportrdf_submit' => 'Izvezi',
	'properties' => 'Svojstva',
	'unusedproperties' => 'Neiskorištene osobine',
	'smw_purge' => 'Osvježi',
	'types' => 'Tipovi',
	'semanticstatistics' => 'Statistike semantike',
	'smw_ask_hidequery' => 'Sakrij upit',
	'smw_sbv_property' => 'Svojstvo:',
	'smw_sbv_value' => 'Vrijednost:',
	'smw_browselink' => 'Pregled svojstava',
	'smw_browse_go' => 'Idi',
	'smw_inverse_label_default' => '$1 od',
	'smw_result_prev' => 'Prethodno',
	'smw_result_next' => 'Slijedeće',
	'smw_result_noresults' => 'Nema rezultata.',
	'smw_smwadmin_return' => 'Natrag na $1',
	'smw_smwadmin_datarefreshstopconfirm' => 'Da, siguran sam.',
);

/** Catalan (català)
 * @author Dvdgmz
 * @author Loupeter
 * @author SMP
 * @author Solde
 * @author Toniher
 */
$messages['ca'] = array(
	'smw-desc' => 'Fent el vostre wiki més accessible — per a les màquines «i també» per als humans ([http://semantic-mediawiki.org/wiki/Help:User_manual documentació en línia])',
	'smw_viewasrdf' => 'Canal RDF',
	'smw_finallistconjunct' => ', i',
	'smw_factbox_head' => 'Dades sobre $1',
	'smw_isspecprop' => 'Aquesta propietat és una propietat especial en aquest wiki',
	'smw_concept_description' => 'Descripció del concepte «$1».',
	'smw_no_concept_namespace' => "Els conceptes només poden ser definits en pàgines dins l'espai de noms (namespace) Concept:",
	'smw_multiple_concepts' => 'Cada pàgina de concepte només pot tenir una definició de concepte.',
	'smw_concept_cache_miss' => "El concepte «$1» no pot ser utilitzat per ara, atès que la configuració del wiki s'ha de computar fora de línia.
Si el problema persisteix passat cert temps, demaneu a l'administrador del vostre wiki que posi disponible aquest concepte.",
	'smw_noinvannot' => 'No es poden assignar valors a propietats inverses.',
	'version-semantic' => 'Extensions semàntiques',
	'smw_baduri' => 'Les URI del formulari «$1» no són permeses.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Resultats del recompte',
	'smw_printername_csv' => 'exportació a CSV',
	'smw_printername_dsv' => 'Exportació DSV',
	'smw_printername_debug' => 'Consulta de depuració (per a experts)',
	'smw_printername_embedded' => 'Continguts de pàgina incrustada',
	'smw_printername_json' => 'exportació a JSON',
	'smw_printername_list' => 'Llista',
	'smw_printername_ol' => 'Enumeració',
	'smw_printername_ul' => 'Itemització',
	'smw_printername_rss' => 'exportació a RSS',
	'smw_printername_table' => 'Taula',
	'smw_printername_broadtable' => 'Taula ampla',
	'smw_printername_template' => 'Plantilla',
	'smw_printername_rdf' => 'Exportació RDF',
	'smw_printername_category' => 'Categoria',
	'smw-paramdesc-limit' => 'El nombre màxim de resultats a retornar',
	'smw-paramdesc-offset' => 'El desplaçament (offset) del primer resultat',
	'smw-paramdesc-headers' => 'Mostra les capçaleres / noms de les propietats',
	'smw-paramdesc-mainlabel' => "L'etiqueta que es donarà al nom de la pàgina principal",
	'smw-paramdesc-link' => 'Mostra els valors com a enllaços',
	'smw-paramdesc-intro' => "El text que apareixerà abans que el resultat de la consulta, si n'hi hagués",
	'smw-paramdesc-outro' => "El text que apareixerà després que els resultats de la consulta, si n'hi hagués",
	'smw-paramdesc-default' => 'El text que es mostrarà si no hi ha resultats de la consulta',
	'smw-paramdesc-sep' => 'El separador entre valors',
	'smw-paramdesc-distribution' => 'En comptes de mostrar tots els valors, compta les coincidències i mostra-ho.',
	'smw-paramdesc-distributionsort' => "Ordena la distribució de valor pel recompte d'aparició.",
	'smw-paramdesc-distributionlimit' => 'Limita la distribució de valor al recompte de només alguns valors.',
	'smw-paramdesc-template' => "El nom d'una plantilla amb la qual mostrar els llistats",
	'smw-paramdesc-columns' => 'El nombre de columnes amb les quals mostrar els resultats (per defecte és $1)',
	'smw-paramdesc-userparam' => "Es passa un valor a cada crida de la plantilla, sempre que s'utilitzi una plantilla",
	'smw-paramdesc-introtemplate' => "El nom d'una plantilla que es mostrarà abans dels resultats de la consulta, si n'hi ha cap",
	'smw-paramdesc-outrotemplate' => "El nom d'una plantilla que es mostrarà després dels resultats de la consulta, si n'hi ha cap",
	'smw-paramdesc-embedformat' => "L'etiqueta HTML que s'utilitza per a definir les capçaleres",
	'smw-paramdesc-embedonly' => 'No mostris capçaleres',
	'smw-paramdesc-table-class' => 'Una classe CSS addicional per definir per a la taula',
	'smw-paramdesc-rsstitle' => "El text que s'utilitzarà com a títol del canal",
	'smw-paramdesc-rssdescription' => "El text que s'utilitzarà com a descripció del canal",
	'smw-paramdesc-rdfsyntax' => "La sintaxi RDF que s'utilitzarà",
	'smw-paramdesc-csv-sep' => "El separador que s'utilitzarà",
	'smw-paramdesc-dsv-separator' => "El separador que s'utilitzarà",
	'smw-paramdesc-dsv-filename' => 'El nom del fitxer DSV',
	'smw-smwdoc-description' => 'Mostra una taula de tots els paràmetres que es poden utilitzar per al format del resultat especificat juntament amb els valors per defecte i les descripcions.',
	'smw-smwdoc-par-format' => 'El format del resultat per mostrar la documentació del paràmetre.',
	'smw-smwdoc-par-parameters' => 'Quins paràmetres mostrar. «specific» per a aquells afegits per format, «base» per a aquells disponibles en tots els formats, i «all» per als dos.',
	'smw-paramdesc-sort' => 'Propietat per ordenar la consulta per',
	'smw-paramdesc-order' => 'Ordre de la ordenació de la consulta',
	'smw-paramdesc-searchlabel' => 'Text per continuar la cerca (per defecte és «… més resultats»)', # Fuzzy
	'smw-paramdesc-named_args' => 'Anomena els arguments que es passen a la plantilla',
	'smw-paramdesc-export' => "Opció d'exportació",
	'smw_iq_disabled' => 'Les consultes semàntiques estan inhabilitades en aquest wiki.',
	'smw_iq_moreresults' => '... més resultats',
	'smw_parseerror' => "El valor donat no s'ha entès.",
	'smw_notitle' => '"$1" no es pot fer servir com a nom de pàgina en aquest wiki.',
	'smw_noproperty' => 'No es pot utilitzar «$1» com a nom de propietat en aquest wiki.',
	'smw_wrong_namespace' => 'Aquí només es poden fer servir pàgines en l\'espai de noms "$1".',
	'smw_manytypes' => "S'ha definit més d'un tipus per la propietat.",
	'smw_emptystring' => "No s'accepten cadenes buides.",
	'smw_maxstring' => 'La representació de cadena $1 és massa llarga',
	'smw_notinenum' => "«$1» no està a la llista de valors possibles ($2) d'aquesta propietat.",
	'smw_noboolean' => '«$1» no es pot reconèixer com un valor booleà (cert/fals).',
	'smw_true_words' => 'verdader,vertader,veritat,cert,true,t,sí,s,yes,y',
	'smw_false_words' => 'fals,f,no,n,false',
	'smw_nofloat' => '"$1" no és un nombre.',
	'smw_infinite' => 'No es permeten nombres tan llargs com «$1».',
	'smw_unitnotallowed' => '«$1» no està declarada com una unitat de mesura vàlida per a aquesta propietat.',
	'smw_nounitsdeclared' => "No s'ha declarat cap unitat de mesura d'aquesta propietat.",
	'smw_novalues' => "No s'ha especificat cap valor.",
	'smw_nodatetime' => "No s'ha entès la data «$1».",
	'smw_toomanyclosing' => 'Sembla ser que «$1» apareix massa vegades a la consulta.',
	'smw_noclosingbrackets' => 'Algun ús de "<nowiki>[[</nowiki>" en la vostra consulta no es clou amb els "]]" corresponents.',
	'smw_misplacedsymbol' => 'El símbol «$1» es fa servir en un lloc on no és útil.',
	'smw_unexpectedpart' => "La part «$1» de la consulta no s'ha entès.
Els resultats podrien no ser els esperats.",
	'smw_emptysubquery' => 'Alguna subconsulta no té una condició vàlida.',
	'smw_misplacedsubquery' => 'Alguna subconsulta es fa servir en un lloc on les subconsultes no són permeses.',
	'smw_valuesubquery' => 'Subconsultes no suportades per valors de la propietat "$1".',
	'smw_badqueryatom' => "Una part «<nowiki>[[…]]</nowiki>» de la consulta no s'ha pogut entendre.",
	'smw_propvalueproblem' => "El valor de la propietat «$1» no s'ha pogut entendre.",
	'smw_noqueryfeature' => "Algun aspecte d'aquesta consulta no està suportat en aquest wiki i part de la consulta no s'ha tingut en compte ($1).",
	'smw_noconjunctions' => "Les conjuncions en consultes no són suportades en aquest wiki i part de la consulta no s'ha tingut en compte ($1)",
	'smw_nodisjunctions' => "Les disjuncions en consultes no són suportades en aquest wiki i part de la consulta no s'ha tingut en compte ($1).",
	'smw_querytoolarge' => 'Les condicions de consulta següents podrien no ser considerades degut a les restriccions de mida o profunditat per consultes en el wiki: $1.',
	'smw_notemplategiven' => "Per fer que això funcioni, doneu un valor al paràmetre «template» (plantilla) per al format d'aquesta consulta.",
	'smw_db_sparqlqueryproblem' => "No s'ha pogut obtenir el resultat de la consulta de la base de dades SPARQL. Aquest error podria ser temporal o indicar alguna mena d'error en el programari de la base de dades.",
	'smw_db_sparqlqueryincomplete' => "Respondre la consulta ha acabat essent massa difícil i s'ha interromput. Podrien mancar-hi alguns resultats. Si fos possible, proveu millor una consulta més simple.",
	'smw_type_header' => 'Propietats de tipus «$1»',
	'smw_typearticlecount' => 'Es {{PLURAL:$1|mostra|mostren}} $1 {{PLURAL:$1|propietat que fa servir|propietats que fan servir}} aquesta propietat.',
	'smw_attribute_header' => 'Pàgines que fan servir la propietat "$1"',
	'smw_attributearticlecount' => 'Es {{PLURAL:$1|mostra|mostren}} $1 {{PLURAL:$1|pàgina que fa servir|pàgines que fan servir}} aquesta propietat.',
	'smw_subproperty_header' => 'Subpropietats',
	'smw_subpropertyarticlecount' => 'Aquesta propietat té {{PLURAL:$1|la subpropietat següent|les $1 subpropietats següents}}:',
	'smw_concept_header' => 'Pàgines del concepte "$1"',
	'smw_conceptarticlecount' => 'Es {{PLURAL:$1|mostra|mostren}} $1 {{PLURAL:$1|pàgina|pàgines}} que pertanyen a aquest concepte.',
	'smw_rss_description' => 'Canal RSS $1',
	'exportrdf' => 'Exporta les pàgines a RDF',
	'smw_exportrdf_docu' => "Aquesta pàgina permet obtenir dades en format RDF d'una pàgina del wiki.
Per exportar pàgines, entra els títols a la caixa de text següent, un títol per línia.",
	'smw_exportrdf_recursive' => 'Exporta recursivament totes les pàgines relacionades.
Tingueu en compte que el resultat pot ser molt gran!',
	'smw_exportrdf_backlinks' => 'També exporta totes les pàgines que es refereixen a les pàgines exportades.
Genera un RDF que es pot navegar.',
	'smw_exportrdf_lastdate' => "No exportis pàgines que no s'han canviat des del punt donat  en el temps.",
	'smw_exportrdf_submit' => 'Exporta',
	'uriresolver' => "Resolutor d'URI",
	'properties' => 'Propietats',
	'smw_properties_docu' => "S'utilitzen les propietats següents al wiki.",
	'smw_property_template' => '$1 de tipus $2 ($3)',
	'smw_property_template_notype' => '$1 ($2)',
	'smw_propertylackspage' => 'Cal descriure totes les propietats amb una pàgina!',
	'smw_propertylackstype' => "No s'ha especificat cap tipus per a la propietat (s'assumeix el tipus $1 per ara).",
	'smw_propertyhardlyused' => 'Propietats pràcticament no utilitzades al llarg del wiki!',
	'unusedproperties' => 'Propietats no utilitzades',
	'smw_unusedproperties_docu' => 'Les propietats següents existeixen, tot i que cap altra pàgina les fa servir.',
	'smw_unusedproperty_template' => '$1 del tipus $2',
	'wantedproperties' => 'Propietats per definir',
	'smw_wantedproperties_docu' => "Les propietats següents s'utilitzen en el wiki però encara no tenen cap pàgina per a descriure-les.",
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|ús|usos}})',
	'smw_purge' => 'Refresca',
	'types' => 'Tipus',
	'smw_types_docu' => 'La següent és una llista de tots els tipus de dades que poden assignar-se a les propietats.',
	'semanticstatistics' => 'Estadístiques semàntiques',
	'smw_semstats_text' => "Aquest wiki conté '''$1''' {{PLURAL:$1|valor|valors}} de propietat d'un total de '''$2''' [[Special:Properties|{{PLURAL:$2|propietat|diferents propietats}}]].
'''$3''' {{PLURAL:$3|propietat té|propietats tenen}} una pàgina pròpia, i se n'especifica el tipus de dades amb sagnat per a '''$4'''.
Algunes de les propietats existents podrien ser [[Special:UnusedProperties|propietats no utilitzades]].
Les propietats que encara no tenen cap pàgina es poden trobar a la [[Special:WantedProperties|llista de propietats per definir]].",
	'smw_uri_doc' => 'El resolutor d\'URI implementa la <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">cerca de W3C TAG en httpRange-14</a>.
Té cura que els humans no es tornin en llocs web.',
	'ask' => 'Cerca semàntica',
	'smw_ask_sortby' => 'Ordena per columna (opcional)',
	'smw_ask_ascorder' => 'Ascendent',
	'smw_ask_descorder' => 'Descendent',
	'smw_ask_submit' => "Cerca'n resultats",
	'smw_ask_editquery' => '[Edita la consulta]',
	'smw_add_sortcondition' => "Afegeix una condició d'ordenació",
	'smw_ask_hidequery' => 'Amaga la consulta',
	'smw_ask_help' => "Consulta de l'ajuda",
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Dades addicionals per mostrar',
	'smw_ask_printdesc' => '(afegeix un nom de propietat per línia)',
	'smw_ask_format_as' => 'Formata com:',
	'smw_ask_defaultformat' => 'per defecte',
	'smw_ask_otheroptions' => 'Altres opcions',
	'smw_ask_show_embed' => 'Mostra el codi incrustat',
	'smw_ask_hide_embed' => 'Amaga el codi incrustat',
	'smw_ask_embed_instr' => 'Per a incrustar aquesta consulta en línia a una pàgina wiki utilitzeu el codi a continuació.',
	'smw-ask-delete' => '[Suprimeix]',
	'querycreator' => 'Creador de consultes',
	'smw_qc_addmainlabel' => "Afegeix l'etiqueta principal",
	'smw_qc_show_addnal_opts' => 'Mostra més opcions',
	'smw_qc_hide_addnal_opts' => 'Mostra menys opcions',
	'smw_qc_otheropt' => 'Altres opcions',
	'smw_qc_intro' => 'Intro:',
	'smw_qc_outro' => 'Outro:',
	'smw_qc_default' => 'Per defecte:',
	'smw_qc_formatopt' => 'Opcions de format',
	'smw_qc_query_help' => 'Introduïu una consulta fent servir el formulari a continuació. Seleccioneu les pàgines wiki en funció de
Categories (<strong>[[{{ns:category}}:Actor]]</strong>), 
Propietats (<strong>[[Viu a::Elx]]</strong>), 
Noms (<strong>[[Lleida]]</strong>) i espais de noms (<strong>[[{{ns:help}}:+]]</strong>)', # Fuzzy
	'smw_qui_property' => '<strong>Propietat</strong>',
	'smw_qui_prop' => 'Propietat:',
	'smw_qui_labl' => 'Etiqueta:',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Límit:',
	'smw_qui_shownresults' => 'mostra en els resultats',
	'smw_qui_noquery' => "No s'ha especificat cap consulta",
	'smw_qui_invalidprop' => '«$1» podria ser que no fos una propietat vàlida',
	'smw_qui_invalidformat' => 'El format triat «$1» no existeix en aquest wiki',
	'smw_qui_nosort' => 'Sense ordenació',
	'smw_qui_ascorder' => 'Ascendent',
	'smw_qui_descorder' => 'Descendent',
	'smw_qui_randorder' => 'Aleatori',
	'smw_qui_addnprop' => 'afegeix la propietat',
	'smw_qui_delete' => 'Suprimeix',
	'smw_qui_rescol' => 'Coincidències de consulta',
	'smw_qui_options' => 'opcions',
	'smw_qui_addcategory' => 'afegeix la categoria',
	'smw_qui_addrescol' => 'afegeix coincidències de consulta',
	'smw_qui_ok' => "D'acord",
	'smw_qui_cancel' => 'Cancel·la',
	'smw_qui_category' => '<strong>Categoria</strong>',
	'smw_qui_label' => 'Etiqueta',
	'smw_prp_options' => 'Opcions de propietat',
	'smw_qui_catopts' => 'Opcions de categoria',
	'smw_qui_mainlabopts' => 'Opcions de resultat',
	'smw_qui_dlabel' => 'Etiqueta:',
	'smw_qui_dcategory' => 'Categoria:',
	'smw_qui_dcatyes' => 'Mostra el text quan la categoria és present:',
	'smw_qui_dcatno' => 'Mostra el text quan la categoria no existeix:',
	'searchbyproperty' => 'Cerca per propietat',
	'smw_sbv_docu' => 'Cerca totes les pàgines que tenen una propietat i valor donats.',
	'smw_sbv_novalue' => 'Introduïu un valor vàlid per a la propietat, o vegeu tots els valors de la propietat «$1».',
	'smw_sbv_displayresult' => 'Una llista de totes les pàgines que tenen la propietat «$1» amb el valor «$2»',
	'smw_sbv_displayresultfuzzy' => 'Una llista de totes les pàgines que tenen la propietat «$1» amb el valor «$2».
Com hi ha hagut només uns pocs resultats, també es mostren valors propers.',
	'smw_sbv_property' => 'Propietat:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Troba els resultats',
	'browse' => 'Explora el wiki',
	'smw_browselink' => 'Explora les propietats',
	'smw_browse_article' => "Introduïu el nom de la pàgina des d'on començar a navegar.",
	'smw_browse_go' => 'Vés-hi',
	'smw_browse_show_incoming' => 'mostra les propietats que hi enllacen',
	'smw_browse_hide_incoming' => 'amaga les propietats que hi enllacen',
	'smw_browse_no_outgoing' => 'La pàgina no té cap propietat.',
	'smw_browse_no_incoming' => 'No enllaça cap propietat a la pàgina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiqueta de propietat inversa',
	'pageproperty' => 'Cerca de les propietats de la pàgina',
	'smw_pp_docu' => "Cerqueu tots els valors d'una propietat en una pàgina donada.
Introduïu tant la pàgina com la propietat.",
	'smw_pp_from' => 'De la pàgina',
	'smw_pp_type' => 'Propietat',
	'smw_pp_submit' => 'Troba els resultats',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Següent',
	'smw_result_results' => 'Resultats',
	'smw_result_noresults' => 'Sense resultats.',
	'smwadmin' => "Funcions d'administració del Semantic MediaWiki",
	'smw_smwadmin_setupsuccess' => "El motor d'emmagatzematge s'ha configurat amb èxit.",
	'smw_smwadmin_return' => 'Torna a $1',
	'smw_smwadmin_updatestarted' => "S'ha iniciat un nou procés d'actualització per a refrescar les dades semàntiques.
Es reconstruiran totes les dades emmagatzemades o bé es repararan quan calgui.
Podeu seguir el progrés de l'actualització en aquesta pàgina especial.

Torna a $1.",
	'smw_smwadmin_updatenotstarted' => "Ja hi ha un procés d'actualització executant-se.
No es crearà cap altre.

Torna a $1.",
	'smw_smwadmin_updatestopped' => "S'han aturat tots els processos d'actualització existents.

Torna a $1.",
	'smw_smwadmin_updatenotstopped' => "Per a aturar l'execució del procés d'actualització, heu de marcar la casella per tal d'indicar que n'esteu plenament segur.

Torna a $1.",
	'smw_smwadmin_docu' => 'Aquesta pàgina especial us ajuda durant la instal·lació i l\'actualització del <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Recordeu fer una còpia de seguretat de les dades importants abans d\'executar cap funció administrativa.',
	'smw_smwadmin_db' => 'Instal·lació de la base de dades i actualització',
	'smw_smwadmin_dbdocu' => "El Semantic MediaWiki necessita algunes extensions a la base de dades del MediaWiki per a poder emmagatzemar les dades semàntiques.
La funció a continuació garanteix que la vostra base de dades està configurada correctament.
Els canvis fets en aquest pas no afecten la resta de la base de dades del MediaWiki, i poden desfer-se fàcilment si així es vol.
La funció de configuració pot executar-se moltes vegades sense que es faci cap mal, però només cal una vegada per a la instal·lació o l'actualització.",
	'smw_smwadmin_permissionswarn' => "Si l'operació falla amb errors SQL, l'usuari de la base de dades que utilitza el vostre wiki (comproveu el LocalSettings.php) probablement no té suficients permisos.
Podeu atorgar l'usuari permisos addicionals per a crear o suprimir taules, introduïu temporalment les dades d'inici de l'administrador (root) de la base de dades al LocalSettings.php, o bé feu servir l'script de manteniment <tt>SMW_setup.php</tt>, que pot utilitzar les credencials d'un administrador.",
	'smw_smwadmin_dbbutton' => 'Inicialitza o actualitza les taules',
	'smw_smwadmin_announce' => 'Feu conèixer el vostre wiki',
	'smw_smwadmin_announcedocu' => 'El Semantic MediaWiki té un servei web per a anunciar nous llocs wiki semàntics.
S\'utilitza per a mantenir una llista de llocs públics que utilitzen el Semantic MediaWiki, majoritàriament per a ajudar el <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projecte Semantic MediaWiki</a> a tenir una visió dels usos típics del Semantic MediaWiki.
Consulteu la pàgina inicial del Semantic MediaWiki per a <a href="http://semantic-mediawiki.org/wiki/Registry">obtenir més informació del servei</a>.',
	'smw_smwadmin_announcebutton' => "Premeu el botó següent per a trametre l'URL del vostre wiki al servei.
El servei no registrarà wikis que no són accessibles públicament, i només emmagatzemarà informació que és accessible de forma pública.",
	'smw_smwadmin_datarefresh' => 'Reparació de les dades i actualització',
	'smw_smwadmin_datarefreshdocu' => "És possible restaurar totes les dades del Semantic MediaWiki a partir dels continguts actuals del wiki.
Això pot ser útil per a reparar dades inconsistents o refrescar les dades si el format intern ha canviat per alguna actualització de programari.
L'actualització s'executa pàgina per pàgina i no es completarà immediatament.
A continuació és mostra si l'actualització és en curs i us permet iniciar o aturar les actualitzacions (a menys que aquesta característica estigui inhabilitada per l'administrador del lloc).",
	'smw_smwadmin_datarefreshprogress' => "<strong>Ja hi ha una actualització en curs.</strong>
És normal que l'actualització progressi només lentament perquè només refresca les dades en trossos petits cada vegada que l'usuari accedeix al wiki.
Per a finalitzar l'actualització més ràpidament, podeu cridar l'script de manteniment del MediaWiki <tt>runJobs.php</tt> (empreu l'opció <tt>--maxjobs 1000</tt> per a restringir el nombre d'actualitzacions en un lot).
Progrés estimat de l'actualització actual:",
	'smw_smwadmin_datarefreshbutton' => "Inicia l'actualització de dades",
	'smw_smwadmin_datarefreshstop' => "Atura l'actualització",
	'smw_smwadmin_datarefreshstopconfirm' => "Sí, n'estic segur.",
	'smw_smwadmin_support' => 'Com obtenir assistència',
	'smw_smwadmin_supportdocu' => 'Diferents recursos poden ajudar-vos en cas de problemes:',
	'smw_smwadmin_installfile' => 'Si us trobeu amb problemes amb la vostra instal·lació, comenceu comprovant les instruccions del <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">fitxer INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Podeu trobar la documentació d\'usuari completa del Semantic MediaWiki a <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Es poden enviar informes d\'error al <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Si teniu més preguntes o suggeriments, uniu-vos a la discussió al <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">fòrum d\'usuaris del Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Estructura de dades',
	'smw_adminlinks_displayingdata' => 'Visualització de les dades',
	'smw_adminlinks_inlinequerieshelp' => 'Ajuda de les consultes en línia',
	'smw-createproperty-isproperty' => 'Aquesta és una propietat del tipus $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|El valor permès per a aquestapropietat és|Els valors permesos per a aquestes propietats són}}:',
	'smw-paramdesc-category-delim' => 'El delimitador',
	'smw-paramdesc-category-template' => 'Una plantilla per donar format als elements amb',
	'smw-paramdesc-category-userparam' => 'Un paràmetre per passar a la plantilla',
	'smw-info-par-message' => 'Missatge per mostrar.',
	'smw-info-par-icon' => 'La icona que es mostrarà, o bé «info», o bé «avís».',
	'smw_unknowntype' => "S'ha definit un tipus «$1» no permès per la propietat.", # Fuzzy
);

/** Chechen (нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'smw_printername_template' => 'Куцкеп',
);

/** Chamorro (Chamoru)
 * @author Jatrobat
 */
$messages['ch'] = array(
	'smw_browse_go' => 'Hånao',
);

/** Sorani Kurdish (کوردی)
 */
$messages['ckb'] = array(
	'smw_browse_go' => 'بڕۆ',
);

/** Czech (česky)
 * @author Kjbenes
 * @author Matěj Grabovský
 * @author Mormegil
 * @author XenoPheX
 */
$messages['cs'] = array(
	'smw-desc' => "Činíme vaší wiki přístupnější – pro stroje ''i'' lidi ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])",
	'smw_viewasrdf' => 'RDF kanál',
	'smw_finallistconjunct' => ' a',
	'smw_factbox_head' => 'Skutečnosti o $1 &mdash; kliknutím na <span class="smwsearchicon">+</span> vyhledáte podobné stránky.',
	'smw_isspecprop' => 'Tato vlastnost je speciální vlastnost na této wiki.',
	'smw_concept_description' => 'Popis pojmu „$1”',
	'smw_no_concept_namespace' => 'Pojmy je možné definovat pouze na stránkách ve jmenném prostoru Concept:',
	'smw_multiple_concepts' => 'Každá stránka konceptu může mít jen jednu definici.',
	'smw_concept_cache_miss' => 'Koncept „$1” není možné momentálně použít, protože konfigurace wiki vyžaduje, aby se vypočítal až dodatečně. Pokud problém přetrvává delší dobu, požádejte správce, aby tento koncept zpřístupnil.',
	'smw_noinvannot' => 'Inverzním vlastnostem nelze přiřazovat hodnoty.',
	'smw_baduri' => 'Promiňte, URI z rozsahu „$1“ na tomto místě nejsou dostupné.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_csv' => 'Export do CSV',
	'smw_printername_dsv' => 'Export do DSV',
	'smw_printername_json' => 'Export do JSON',
	'smw_printername_list' => 'Seznam',
	'smw_printername_ol' => 'Výčet',
	'smw_printername_rss' => 'Export do RSS',
	'smw_printername_table' => 'Tabulka',
	'smw_printername_broadtable' => 'Široká tabulka',
	'smw_printername_template' => 'Šablona',
	'smw_printername_rdf' => 'Export do RDF',
	'smw_printername_category' => 'Kategorie',
	'smw-paramdesc-limit' => 'Maximální počet vrácených výsledků',
	'smw-paramdesc-link' => 'Zobrazit hodnoty jako odkazy',
	'smw-paramdesc-sep' => 'Oddělovač hodnot',
	'smw-paramdesc-sort' => 'Vlastnost, podle které výsledky řadit',
	'smw-paramdesc-order' => 'Způsob řazení výsledků dotazu',
	'smw_iq_disabled' => 'Promiňtě, semantické dotazy byly pro tuto wiki zakázány.',
	'smw_iq_moreresults' => '…další výsledky',
	'smw_parseerror' => 'Zadaná hodnota nebyla pochopená.',
	'smw_notitle' => '„$1“ není možné použít na této wiki jako název stránky.',
	'smw_noproperty' => '„$1“ nelze na této wiki použít jako název vlastnosti.',
	'smw_wrong_namespace' => 'Zde jsou povoleny jen stránky ze jmenného prostoru "$1"',
	'smw_manytypes' => 'Pro vlastnost byl definován více než jeden typ.',
	'smw_emptystring' => 'Prázdné řetězce nejsou povolené.',
	'smw_maxstring' => 'Reprezentace řetězce $1 je příliš dlouhá.',
	'smw_notinenum' => '„$1“ není v seznamu možných hodnot ($2) této vlastnosti.',
	'smw_noboolean' => '„$1“ nebylo rozpoznáno jako platná hodnota typu boolean (ano/ne).',
	'smw_nofloat' => '“$1” není číslem.',
	'smw_infinite' => 'Tak dlouhá čísla jako $1 nejsou podporována.',
	'smw_unitnotallowed' => '"$1" není platnou měrnou jednotkou této vlastnosti.',
	'smw_nounitsdeclared' => 'Pro tuto vlastnost nebyly definovány žádné měrné jednotky.',
	'smw_nodatetime' => 'Datum "$1" nedává smysl.',
	'smw_toomanyclosing' => 'Dotazovaný řetězec „$1“ má příliš mnoho výskytů.',
	'smw_noclosingbrackets' => 'Některý výskyt „<nowiki>[[</nowiki>“ ve vašem dotazu nebyl ukončen odpovídajícím „]]“.',
	'smw_misplacedsymbol' => 'Symbol „$1“ byl užitý na místě, kde nemá význam.',
	'smw_unexpectedpart' => 'Část dotazu „$1“ nedává smysl.
Výsledky pravděpodobně nesplní očekávání.',
	'smw_emptysubquery' => 'Některý poddotaz nemá platné podmínky.',
	'smw_misplacedsubquery' => 'Některý poddotaz byl použitý na místě, kde nejsou poddotazy povoleny.',
	'smw_valuesubquery' => 'Poddotazy nejsou podporovány pro hodnoty vlastnosti „$1“.',
	'smw_badqueryatom' => 'Některá část „<nowiki>[[…]]</nowiki>“ nebyla srozumitelná.',
	'smw_propvalueproblem' => 'Hodnota vlastnosti „$1“ nedávala smysl.',
	'smw_noqueryfeature' => 'Určitá část dotazu není na této wiki podporovaná a bude proto ignorována ($1).',
	'smw_noconjunctions' => 'Konjunkce v dotazu není na této wiki podporována a bude proto ignorována ($1).',
	'smw_nodisjunctions' => 'Disjunkce nejsou v dotazech na této wiki podporované a část dotazu byla ignorována ($1).',
	'smw_querytoolarge' => 'Následující podmínky dotazu nebudou zohledněné z důvodu omezení této wiki na délku nebo hĺoubku dotazu: $1.',
	'smw_notemplategiven' => 'Aby tento formát dotazu fungoval, uveďte hodnotu parametru „template”.',
	'smw_db_sparqlqueryproblem' => 'Výsledek dotazu se nepodařilo získat z databáze SPARQL. Tato chyba může být dočasná nebo může indikovat chybu v softwaru databáze.',
	'smw_db_sparqlqueryincomplete' => 'Zodpovězení dotazu se ukázalo být příliš obtížným a bylo stornováno. Výsledky nemusí být úplné. Je-li to možné, zkuste použít jednodušší dotaz.',
	'smw_type_header' => 'Vlastností typu „$1“',
	'smw_typearticlecount' => 'Zobrazeno je $1 {{PLURAL:$1|vlastnost|vlastnosti|vlastností}} tohoto typu.',
	'smw_attribute_header' => 'Stránek používajících vlastnost „$1“',
	'smw_attributearticlecount' => 'Zobrazeno je $1 {{PLURAL:$1|stránka používající|stránky používající|stránek používajících}} tuto vlastnost.',
	'smw_subproperty_header' => 'Podvlastnosti',
	'smw_subpropertyarticlecount' => 'Této vlastnosti náleží $1 {{PLURAL:$1|podvlastnost|podvlastností}}.', # Fuzzy
	'smw_concept_header' => 'Stran konceptu "$1"',
	'smw_conceptarticlecount' => '{{PLURAL:$1|zobrazena je|zobrazeny jsou|zobrazeno je}} $1 {{PLURAL:$1|stránka náležející|stránky náležející|stránek náležejících}} tomuto konceptu.',
	'exportrdf' => 'Export stránek do RDF',
	'smw_exportrdf_docu' => 'Tato stránka vám umožňuje exportovat části stránek do formátu RDF. Po zadaní názvů stránek do spodního textového pole (jeden název na řádek) můžete exportovat stránky.',
	'smw_exportrdf_recursive' => 'Rekurzívně exportovat všechny související stránky. Pozor, výsledek může být velmi rozsáhlý!',
	'smw_exportrdf_backlinks' => 'Exportovat také stránky, které odkazují na exportované stránky. Vytvoří přehledné RDF.',
	'smw_exportrdf_lastdate' => 'Neexportovat stránky, které nebyly změněné od zadaného času.',
	'uriresolver' => 'Překladač URI',
	'properties' => 'Vlastnosti',
	'smw_properties_docu' => 'Na této wiki se používají následující vlastnosti.',
	'smw_property_template' => '$1 typu $2 ($3)',
	'smw_propertylackspage' => 'Všechny vlastnosti by měly mít stránku s popisem!',
	'smw_propertylackstype' => 'Této vlastnosti nebyl definován žádný typ (předpokládá se prozatím typ $1)',
	'smw_propertyhardlyused' => 'Tato vlastnost se na wiki téměř nepoužívá!',
	'unusedproperties' => 'Nepoužité vlastnosti',
	'smw_unusedproperties_docu' => 'Nasledující vlastnosti existují i když je nevyužívá žádná jiná stránka.',
	'smw_unusedproperty_template' => '$1 typu $2',
	'wantedproperties' => 'Požadované vlastnosti',
	'smw_wantedproperties_docu' => 'Následující vlastnosti, které existují na této wiki, zatím nemají popisnou stránku.',
	'smw_wantedproperty_template' => '$1 (užité $2-krát)', # Fuzzy
	'smw_purge' => 'Obnovit',
	'types' => 'Typy',
	'smw_types_docu' => 'Následuje seznam všech údajových typů, které je možné přiřadit vlastnostem. Každý údajový typ má stránku, kde je možné uvést dodatečné informace.', # Fuzzy
	'semanticstatistics' => 'Statistika sémantik',
	'smw_semstats_text' => 'Tato wiki obsahuje <b>$1</b> hodnot vlastností celkem <b>$2</b> rozličných <a href="$3">vlastností</a>.
<b>$4</b> vlastností nemá vlastní stránku a zamýšlený datový typ má uvedený <b>$5</b> z nich.
Některé z existujících vlastností mohou být <a href="$6">nepoužívané</a>.
Vlastnosti, kterým stále chybí stránka se nacházejí na <a href="$7">seznamu požadovaných vlastností</a>.', # Fuzzy
	'smw_uri_doc' => 'URI resolver se stará o implementaci <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG hledání na httpRange-14</a>. Stará se o to, aby se lidé nestali webstránkami.',
	'ask' => 'Sémantické vyhledávání',
	'smw_ask_sortby' => 'Řadit podle sloupce', # Fuzzy
	'smw_ask_ascorder' => 'Vzestupně',
	'smw_ask_descorder' => 'Sestupně',
	'smw_ask_submit' => 'Najdi výsledky',
	'smw_ask_editquery' => '[Upravit dotaz]',
	'smw_add_sortcondition' => '[Přidat podmínku na řazení]',
	'smw_ask_hidequery' => 'Skrýt dotaz',
	'smw_ask_help' => 'Pomocník pro dotazy',
	'smw_ask_queryhead' => 'Dotaz',
	'smw_ask_printhead' => 'Přídavné výpisy (volitelné)', # Fuzzy
	'smw_ask_printdesc' => '(každý název vlastnosti na samostatný řádek)',
	'smw_ask_format_as' => 'Formát výstupu:',
	'smw_ask_defaultformat' => 'výchozí',
	'smw_ask_show_embed' => 'Zobrazit kód pro vložení do stránky',
	'smw_ask_hide_embed' => 'Skrýt kód pro vložení do stránky',
	'smw_ask_embed_instr' => 'Tento kód použijte ke vložení tohoto dotazu do textu stránky na wiki.',
	'smw_qc_intro' => 'Intro:',
	'smw_qc_outro' => 'Outro:',
	'smw_qc_query_help' => 'Zadejte dotaz pomocí níže uvedeného formuláře. Vyhledejte wiki stránky podle
Kategorií (<strong>[[{{ns:category}}:Herec]]</strong>),
Vlastností (<strong>[[Nachází se v::Německo]]</strong>),
Jmen (<strong>[[Německo]]</strong>) a Jmenných prostorů (<strong>[[{{ns:help}}:+]]</strong>)', # Fuzzy
	'smw_qui_property' => '<strong>Vlastnost</strong>',
	'smw_qui_noquery' => 'Nebyl zadán žádný dotaz',
	'smw_qui_nosort' => 'Neřadit',
	'smw_qui_ascorder' => 'Vzestupně',
	'smw_qui_descorder' => 'Sestupně',
	'smw_qui_randorder' => 'Náhodně',
	'smw_qui_cancel' => 'Storno',
	'smw_qui_category' => '<strong>Kategorie</strong>',
	'smw_qui_dcategory' => 'Kategorie:',
	'searchbyproperty' => 'Hledat podle hodnoty vlastnosti',
	'smw_sbv_docu' => 'Hledat na wiki článek, který má vlastnost s jistou hodnotou.',
	'smw_sbv_novalue' => 'Nebyla uvedena hodnota. Prosím, vložte jí ve formuláři nebo zobrazte všechny atributy typu $1',
	'smw_sbv_displayresult' => 'Seznam všech článků, které mají vlastnost $1 s hodnotou $2.',
	'smw_sbv_displayresultfuzzy' => 'Seznam všech stránek, jejichž vlastnost „$1“ má hodnotu „$2“. Jelikož bylo výsledků málo, jsou zobrazeny i blízké hodnoty.',
	'smw_sbv_property' => 'Vlastnost:',
	'smw_sbv_value' => 'Hodnota:', # Fuzzy
	'smw_sbv_submit' => 'Hledat výsledky',
	'browse' => 'Prohledat wiki',
	'smw_browselink' => 'Projít vlastnosti',
	'smw_browse_article' => 'Zadejte název stránky, od které chcete začít prohledávat.',
	'smw_browse_go' => 'Provést',
	'smw_browse_no_outgoing' => 'Tato stránka nemá žádné vlastnosti.',
	'smw_browse_no_incoming' => 'Na tuto stránku neodkazují žádné vlastnosti.',
	'pageproperty' => 'Hledání vlastností stránky',
	'smw_pp_docu' => 'Hledání všech nositelů vlastnosti na zadané stránce.
Prosím, zadejte stránku i vlastnost.',
	'smw_pp_from' => 'Od stránky',
	'smw_pp_type' => 'Vlastnost',
	'smw_pp_submit' => 'Výsledky hledání',
	'smw_result_prev' => 'Zpět',
	'smw_result_next' => 'Dále',
	'smw_result_results' => 'Výsledky',
	'smw_result_noresults' => 'Bohužel nejsou žádné výsledky.',
	'smwadmin' => 'Funkce pro administraci Sémantické wiki',
	'smw_smwadmin_return' => 'Zpět na $1',
	'smw_smwadmin_updatestarted' => 'Byl spuštěn nový proces updatu sémantických dat.
Všechna uložená data budou zkontrolována a, bude-li to nutné, znovu vytvořena.
Průběh updatu můžete sledovat na této speciální stránce.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Proces updatu již probíhá.
Další nebyl vytvořen.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Všechny procesy aktualizace byly zastaveny.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Abyste zastavili běžící proces aktualizace, musíte zaškrtnout políčko, čímž potvrdíte, že si jste jisti.', # Fuzzy
	'smw_smwadmin_docu' => 'Tato speciální stránka vám pomůže s instalací a upgradem <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Před spuštěním administrativních funkcí nezapomeňte zálohovat cenná data.',
	'smw_smwadmin_db' => 'Instalace a upgrade databáze',
	'smw_smwadmin_dbdocu' => 'Aby mohla Semantic MediaWiki ukládat sémantická data, potřebuje rozšířit databázi MediaWiki.
Funkce níže zajišťuje, že je vaše databáze správně nastavena.
Změny provedené v tomto kroku nemají žádný vliv na zbytek databáze MediaWiki, a lze je snadno vzít zpět.
Tuto přípravnou funkci můžete spustit vícekrát, aniž by došlo k jakémukoli poškození, ale je to nutné pouze jednou při instalaci nebo upgradu.',
	'smw_smwadmin_permissionswarn' => 'Selže-li operace s SQL chybami, pak uživatel databáze, kterého vaše wiki používá (zkontrolujte LocalSettings.php) pravděpodobně nemá dostatečná oprávnění.
Přidělte tomuto uživateli dostatečná oprávnění k tvorbě a mazání tabulek, dočasně do LocalSettings.php zadejte údaje rootu databáze, nebo použijte údržbový skript <tt>SMW_setup.php</tt>, který používá údaje z AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Inicializovat či upgradovat tabulky',
	'smw_smwadmin_announce' => 'Nahlásit tuto wiki',
	'smw_smwadmin_announcedocu' => 'Nové sémantické wiki lze ohlásit příslušné webové službě Semantic MediaWiki.
Tato hlášení slouží k údržbě seznamu veřejných stránek, které Semantic MediaWiki používají. <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Projekt Semantic MediaWiki</a> si tak udržuje přehled o typických využitích Semantic MediaWiki.
Na domovské stránce Semantic MediaWiki můžete najít <a href="http://semantic-mediawiki.org/wiki/Registry">více informací o této službě</a>.',
	'smw_smwadmin_announcebutton' => 'Stisknutím následujícího tlačítka této službě odešlete URL vaší wiki.
Služba neregistruje wiki, které nejsou veřejně přístupné, a ukládá pouze veřejně přístupné informace.',
	'smw_smwadmin_datarefresh' => 'Oprava a upgrade dat',
	'smw_smwadmin_datarefreshdocu' => 'Na základě obsahu stránek wiki je možné obnovit všechna data Semantic MediaWiki.
To může být užitečné při opravě poškozených dat nebo při jejich úpravě, pokud se v důsledku upgradu softwaru změní vnitřní formát.
Update se spouští stránku po stránce a nebude dokončen ihned.
Následující se zobrazuje pokud update právě probíhá a umožňuje vám updaty spouštět či zastavovat (pokud tuto možnost nezakázal administrátor).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Probíhá update.</strong>
Je normální, že update postupuje pomalu, protože data zpracovává v malých dávkách vždy, když wiki navštíví nějaký uživatel.
Chcete-li update dokončit rychleji, můžete spustit údržbový skript MediaWiki <tt>runJobs.php</tt> (k omezení počtu updatů provedených v jedné dávce použijte nastavení <tt>--maxjobs 1000</tt>).
Odhadovaný průběh updatu:',
	'smw_smwadmin_datarefreshbutton' => 'Spustit update dat',
	'smw_smwadmin_datarefreshstop' => 'Zastavit update',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ano, jsem si jistý/á.',
	'smw_smwadmin_support' => 'Získání podpory',
	'smw_smwadmin_supportdocu' => 'V případě problémů vám může pomoci několik zdrojů:',
	'smw_smwadmin_installfile' => 'Máte-li problémy s instalací, začněte kontrolou podle osnovy v <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">souboru INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Kompletní uživatelská dokumentace Semantic MediaWiki je dostupná na <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Chyby lze hlásit na <a href="https://bugzilla.wikimedia.org/">Bugzille</a>.',
	'smw_smwadmin_questions' => 'Další otázky či návrhy můžete pokládat v diskuzi v <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">uživatelském fóru Semantic MediaWiki</a>.',
	'smw-createproperty-isproperty' => 'Toto je vlastnost typu $1.',
	'smw-paramdesc-category-delim' => 'Oddělovač',
	'smw-info-par-message' => 'Jaká zpráva se má zobrazit.',
	'smw-info-par-icon' => 'Jaká ikona se má zobrazit, buď „info“ nebo „warning“ (varování).',
	'smw_unknowntype' => 'Pro vlastnost je definován nepodporovaný typ „$1“.', # Fuzzy
);

/** German (Deutsch)
 * @author Als-Holder
 * @author DaSch
 * @author Denny
 * @author Imre
 * @author Jan Luca
 * @author Jens Liebenau
 * @author Kghbln
 * @author MF-Warburg
 * @author Markus Krötzsch
 * @author Melancholie
 * @author Metalhead64
 * @author Michawiki
 * @author Omnipaedista
 * @author Pill
 * @author Purodha
 * @author Revolus
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de'] = array(
	'smw-desc' => "Ermöglicht es, das Wiki zugänglicher zu machen – für Menschen ''und'' Maschinen ([https://semantic-mediawiki.org/wiki/Help:Nutzeranleitung Dokumentation])",
	'smw_viewasrdf' => 'RDF-Feed',
	'smw_finallistconjunct' => ' und',
	'smw_factbox_head' => 'Fakten zu „$1“',
	'smw_isspecprop' => 'Dieses Attribut ist ein Spezialattribut in diesem Wiki.',
	'smw_concept_description' => 'Beschreibung des Konzepts „$1“',
	'smw_no_concept_namespace' => "Konzepte können nur im Konzeptnamensraum (''Konzept:'') erstellt werden.",
	'smw_multiple_concepts' => 'Jede Konzeptseite kann nur eine Konzeptdefinition beinhalten.',
	'smw_concept_cache_miss' => 'Das Konzept „$1“ kann im Moment nicht genutzt werden, da es, gemäß der Konfiguration des Wikis, offline zu berechnen ist.
Falls sich das Problem nicht in angemessener Zeit von selbst erledigt, bitte deinen Websiteadministrator, die Daten dieses Konzepts zu aktualisieren.',
	'smw_noinvannot' => 'Inversen Attributen können keine Werte zugewiesen werden.',
	'version-semantic' => 'Semantische Erweiterungen',
	'smw_baduri' => 'URIs der Form „$1“ sind nicht zulässig.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Ergebnisse zählen',
	'smw_printername_csv' => 'Export (CSV)',
	'smw_printername_dsv' => 'Export (DSV)',
	'smw_printername_debug' => 'Debug-Abfrage (für Experten)',
	'smw_printername_embedded' => 'Einbettung (Seiteninhalt)',
	'smw_printername_json' => 'Export (JSON)',
	'smw_printername_list' => 'Liste',
	'smw_printername_ol' => 'Liste (Aufzählung)',
	'smw_printername_ul' => 'Liste (Auflistung)',
	'smw_printername_table' => 'Tabelle',
	'smw_printername_broadtable' => 'Tabelle (breit)',
	'smw_printername_template' => 'Vorlage',
	'smw_printername_rdf' => 'Export (RDF)',
	'smw_printername_category' => 'Kategorie',
	'validator-type-class-SMWParamSource' => 'Text',
	'smw-paramdesc-limit' => 'Die maximale Anzahl der auszugebenden Ergebnisse',
	'smw-paramdesc-offset' => 'Das erste auszugebende Ergebnis',
	'smw-paramdesc-headers' => 'Die Überschriften/Attributnamen anzeigen',
	'smw-paramdesc-mainlabel' => 'Die Bezeichnung für die Hauptergebnisspalte',
	'smw-paramdesc-link' => 'Die Ergebniswerte als Links anzeigen',
	'smw-paramdesc-intro' => 'Der vor etwaigen Abfrageergebnissen anzuzeigende Text',
	'smw-paramdesc-outro' => 'Der nach etwaigen Abfrageergebnissen anzuzeigende Text',
	'smw-paramdesc-default' => 'Der anzuzeigende Text, sofern keine Abfrageergebnisse vorhanden sind',
	'smw-paramdesc-sep' => 'Das Trennzeichen für die Ergebniswerte',
	'smw-paramdesc-showsep' => 'Das Trennzeichen im Kopfbereich der CSV-Datei anzeigen (<code>sep=<value><code>)',
	'smw-paramdesc-distribution' => 'Die Anzahl der Vorkommen von Werten zählen und anzeigen, anstatt sie alle anzuzeigen.',
	'smw-paramdesc-distributionsort' => 'Die Werteverteilung nach Anzahl der Vorkommen sortieren.',
	'smw-paramdesc-distributionlimit' => 'Die Anzahl der Vorkommen von Werten auf bestimmte Werte beschränken.',
	'smw-paramdesc-template' => 'Der Name einer Vorlage, die zum Anzeigen der Abfrageergebnisse verwendet werden soll',
	'smw-paramdesc-columns' => 'Die Anzahl der Spalten, die für die Anzeige Suchergebnisse verwendet werden sollen (standardmäßig $1)',
	'smw-paramdesc-userparam' => 'Der Wert, der bei jedem Vorlagenaufruf übergeben wird, sofern eine Vorlage genutzt wird',
	'smw-paramdesc-introtemplate' => 'Der Name der vor etwaigen Abfrageergebnissen anzuzeigenden Vorlage',
	'smw-paramdesc-outrotemplate' => 'Der Name der nach etwaigen Abfrageergebnissen anzuzeigenden Vorlage',
	'smw-paramdesc-embedformat' => 'Das zum Festlegen der Überschriften genutzte HTML-Tag',
	'smw-paramdesc-embedonly' => 'Die Ergebniswerte ohne Überschriften anzeigen',
	'smw-paramdesc-table-class' => 'Eine zusätzliche auf die Tabelle anwendbare CSS-Klasse',
	'smw-paramdesc-rdfsyntax' => 'Die zu verwendende RDF-Syntax',
	'smw-paramdesc-csv-sep' => 'Das zur Abgrenzung der Ergebnisse zu verwendende Trennzeichen',
	'smw-paramdesc-dsv-separator' => 'Das zur Abgrenzung der Ergebnisse zu verwendende Trennzeichen',
	'smw-paramdesc-dsv-filename' => 'Der Name für die DSV-Datei',
	'smw-smwdoc-description' => 'Zeigt eine Übersicht aller Parameter mitsamt deren Standardwerten einschließlich ihrer Beschreibung, die im Zusammenhang mit dem angegebenen Ergebnisformat genutzt werden können.',
	'smw-smwdoc-par-format' => 'Das Ergebnisformat zu dessen Parametern die Dokumentation angezeigt werden soll.',
	'smw-smwdoc-par-parameters' => 'Die anzuzeigenden Parameter: „specific“ für die vom jeweiligen Ergebnisformat bereitgestellten, „base“ für die für alle Ergebnisformate verfügbaren und „all“ zur Anzeige aller.',
	'smw-paramdesc-sort' => 'Das Attribut nach dem die Abfrage sortiert werden soll',
	'smw-paramdesc-order' => 'Die Sortierreihenfolge für die Ergebnisse der Abfrage',
	'smw-paramdesc-searchlabel' => 'Der Text zum Anzeigen weiterer Abfrageergebnisse',
	'smw-paramdesc-named_args' => 'Die an die Vorlage zu übergebenden Argumente',
	'smw-paramdesc-export' => 'Die Exportoption',
	'smw-paramdesc-prettyprint' => 'Die unformatierte Anzeige mit zusätzlichen Einzügen und neuen Zeilen',
	'smw-paramdesc-source' => 'Die alternative Abfragequelle',
	'smw-paramdesc-jsonsyntax' => 'Die zu verwendende JSON-Syntax',
	'smw-printername-feed' => 'Feed (RSS/Atom)',
	'smw-paramdesc-feedtype' => 'Der Feedtyp',
	'smw-paramdesc-feedtitle' => 'Der Text, der als Titel des Feeds verwendet werden soll',
	'smw-paramdesc-feeddescription' => 'Der Text, der als Beschreibung des Feeds verwendet werden soll',
	'smw-paramdesc-feedpagecontent' => 'Der Seiteninhalt, der mit dem Feed angezeigt werden soll',
	'smw-label-feed-description' => '$2-Feed: $1',
	'smw_iq_disabled' => 'Semantische Abfragen wurden in diesem Wiki deaktiviert.',
	'smw_iq_moreresults' => '… weitere Ergebnisse',
	'smw_parseerror' => 'Der eingegebene Wert wurde nicht verstanden.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '„$1“ kann nicht als Seitenname in diesem Wiki verwendet werden.',
	'smw_noproperty' => '„$1“ kann nicht als Attribut in diesem Wiki verwendet werden.',
	'smw_wrong_namespace' => 'Nur Seiten im Namensraum „$1“ sind hier zulässig.',
	'smw_manytypes' => 'Dem Attribut wurden mehrere Datentypen zugewiesen.',
	'smw_emptystring' => 'Leere Zeichenfolgen werden nicht akzeptiert.',
	'smw_maxstring' => 'Die Zeichenkette „$1“ ist zu lang.',
	'smw_notinenum' => '„$1“ gehört nicht zu den möglichen Werten dieses Attributs ($2).',
	'smw_noboolean' => '„$1“ ist kein Wahrheitswert (wahr/falsch).',
	'smw_true_words' => 'wahr,w,ja,j',
	'smw_false_words' => 'falsch,f,nein,n',
	'smw_nofloat' => '„$1“ ist keine Zahl.',
	'smw_infinite' => 'Die Zahl „$1“ ist zu lang.',
	'smw_unitnotallowed' => '„$1“ wurde nicht als gültige Maßeinheit für dieses Attribut festgelegt.',
	'smw_nounitsdeclared' => 'Es wurden keine Maßeinheiten für dieses Attribut angegeben.',
	'smw_novalues' => 'Es wurden keine Werte angegeben.',
	'smw_nodatetime' => 'Das Datum „$1“ wurde nicht verstanden.',
	'smw_toomanyclosing' => 'In der Abfrage kommen zu viele „$1“ vor.',
	'smw_noclosingbrackets' => 'Ein Vorkommen von „<nowiki>[[</nowiki>“ in der Abfrage wurde nicht durch ein entsprechendes „]]“ abgeschlossen.',
	'smw_misplacedsymbol' => 'Das Symbol „$1“ wurde an einer Stelle verwendet, an der es nicht sinnvoll ist.',
	'smw_unexpectedpart' => 'Der Teil „$1“ der Abfrage konnte nicht interpretiert werden. Die Ergebnisse entsprechen möglicherweise nicht den Erwartungen.',
	'smw_emptysubquery' => 'Eine Teilabfrage enthält eine ungültige Bedingung.',
	'smw_misplacedsubquery' => 'Eine Teilabfrage wurde an einer Stelle eingesetzt, an der sie nicht vorkommen darf.',
	'smw_valuesubquery' => 'Teilabfragen werden für Werte des Attributs „$1“ nicht unterstützt.',
	'smw_badqueryatom' => 'Ein Teil „<nowiki>[[…]]</nowiki>“ der Abfrage konnte nicht interpretiert werden.',
	'smw_propvalueproblem' => 'Der Wert des Attributs „$1“ wurde nicht verstanden.',
	'smw_noqueryfeature' => 'Einige Abfragebestandteile werden nicht von diesem Wiki unterstützt. Der entsprechende Teil der Abfrage wurde ignoriert ($1).',
	'smw_noconjunctions' => 'UND-Verknüpfungen in den Abfragen werden nicht von diesem Wiki unterstützt. Der entsprechende Teil der Abfrage wurde ignoriert ($1).',
	'smw_nodisjunctions' => 'Disjunktionen (ODER) in Abfragen werden nicht von diesem Wiki unterstützt. Der entsprechende Teil der Abfrage wurde ignoriert ($1).',
	'smw_querytoolarge' => 'Die folgenden Abfragebedingungen konnten, wegen der auf diesem Wiki gültigen Beschränkungen, bezüglich Größe und Tiefe von Abfragen, nicht berücksichtigt werden: $1.',
	'smw_notemplategiven' => 'Der Parameter „template“ muss angegeben werden, damit diese Abfrage durchgeführt werden kann.',
	'smw_db_sparqlqueryproblem' => 'Das Abfrageergebnis konnte nicht aus der SPARQL-Datenbank abgerufen werden. Dieser Fehler kann vorübergehend sein oder auf einen Fehler Datenbank hinweisen.',
	'smw_db_sparqlqueryincomplete' => 'Das Ausführen der Abfrage erwies sich als zu umfangreich und wurde abgebrochen. Einige der möglichen Ergebnisse könnten daher fehlen. Sofern möglich, sollte stattdessen eine einfachere Abfrage genutzt werden.',
	'smw_type_header' => 'Attribute mit dem Datentyp „$1“',
	'smw_typearticlecount' => 'Es {{PLURAL:$1|wird ein Attribut|werden $1 Attribute}} mit diesem Datentyp angezeigt:',
	'smw_attribute_header' => 'Seiten mit dem Attribut „$1“',
	'smw_attributearticlecount' => 'Es {{PLURAL:$1|wird eine Seiten|werden $1 Seiten}} angezeigt, die dieses Attribut {{PLURAL:$1|verwendet|verwenden}}:',
	'smw_subproperty_header' => 'Unterattribute',
	'smw_subpropertyarticlecount' => 'Dieses Attribut hat {{PLURAL:$1|folgendes Unterattribut|folgende $1 Unterattribute}}:',
	'smw_concept_header' => 'Seiten mit dem Konzept „$1“',
	'smw_conceptarticlecount' => 'Es {{PLURAL:$1|wird eine Seite|werden $1 Seiten}} angezeigt, die zu diesem Konzept {{PLURAL:$1|gehört|gehören}}:',
	'exportrdf' => 'Seiten als RDF exportieren',
	'smw_exportrdf_docu' => 'Hier können Informationen zu einzelnen Seiten im RDF-Format abgerufen werden. Bitte die Namen der gewünschten Seiten <i>zeilenweise</i> angeben.',
	'smw_exportrdf_recursive' => 'Exportiere auch alle relevanten Seiten rekursiv. Diese Einstellung kann zu sehr großen Ergebnismengen führen!',
	'smw_exportrdf_backlinks' => 'Exportiere auch alle Seiten, die auf zu exportierende Seiten verweisen. Diese Einstellung erzeugt RDF, das leichter durchsucht werden kann.',
	'smw_exportrdf_lastdate' => 'Exportiere keine Seiten, die seit dem angegebenen Zeitpunkt nicht mehr verändert wurden.',
	'smw_exportrdf_submit' => 'Exportieren',
	'uriresolver' => 'URI-Auflöser',
	'properties' => 'Attribute',
	'smw_properties_docu' => 'In diesem Wiki werden die folgenden Attribute genutzt:',
	'smw_property_template' => '$1 mit Datentyp $2 ($3 {{PLURAL:$3|Vorkommen}})',
	'smw_property_template_notype' => '$1 ($2)',
	'smw_propertylackspage' => 'Alle Attribute sollten auf einer Seite beschrieben werden!',
	'smw_propertylackstype' => 'Für dieses Attribut wurde kein Datentyp angegeben ($1 wird vorläufig als Typ angenommen).',
	'smw_propertyhardlyused' => 'Dieses Attribut wird im Wiki kaum verwendet!',
	'unusedproperties' => 'Verwaiste Attribute',
	'smw_unusedproperties_docu' => 'Die folgenden Attribute wurden auf einer zugehörigen Seite im Namensraum „Attribut:“ beschrieben, werden aber nicht im Wiki verwendet.',
	'smw_unusedproperty_template' => '$1 mit Datentyp $2',
	'wantedproperties' => 'Gewünschte Attribute',
	'smw_wantedproperties_docu' => 'Die folgenden Attribute wurden bislang noch nicht auf einer zugehörigen Seite im Namensraum „Attribut:“ beschrieben, obwohl sie bereits im Wiki verwendet werden.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|Vorkommen}})',
	'smw_purge' => 'Neu laden',
	'types' => 'Datentypen',
	'smw_types_docu' => 'Die folgenden Datentypen können Attributen zugewiesen werden:',
	'semanticstatistics' => 'Statistik zu semantischen Daten',
	'smw_semstats_text' => "In diesem Wiki {{PLURAL:$1|wurde '''1''' Wert|wurden '''$1''' Werte}} für insgesamt '''$2''' [[Special:Properties|{{PLURAL:$2|Attribut|verschiedene Attribute}}]] eingegeben. '''$3''' {{PLURAL:$3|Attribut hat|Attribute haben}} eine eigene Seite und der gewünschte Datentyp ist für '''$4''' von diesen angegeben worden.

Einige der vorhandenen Attribute könnten [[Special:UnusedProperties|verwaiste Attribute]] sein. Attribute, für die noch eine Seite angelegt werden sollte, sind in der [[Special:WantedProperties|Liste gewünschter Attribute]] aufgeführt.",
	'smw_uri_doc' => 'Der URI-Auflöser setzt die Empfehlungen „[$1 W3C TAG finding on httpRange-14]“ um. Er sorgt dafür, dass Menschen nicht zu Webseiten werden.',
	'ask' => 'Semantische Suche',
	'smw_ask_sortby' => 'Sortiere nach Spalte (optional)',
	'smw_ask_ascorder' => 'Aufsteigend',
	'smw_ask_descorder' => 'Absteigend',
	'smw_ask_submit' => 'Ergebnisse suchen',
	'smw_ask_editquery' => '[Abfrage bearbeiten]',
	'smw_add_sortcondition' => '[Sortieranweisung hinzufügen]',
	'smw_ask_hidequery' => 'Code der Abfrage ausblenden',
	'smw_ask_help' => 'Hilfe zu Abfragen',
	'smw_ask_queryhead' => 'Abfrage',
	'smw_ask_printhead' => 'Zusätzlich anzuzeigende Daten',
	'smw_ask_printdesc' => '(ein Attribut je Zeile angeben)',
	'smw_ask_format_as' => 'Formatiert als:',
	'smw_ask_defaultformat' => 'Standard',
	'smw_ask_otheroptions' => 'Weitere Optionen',
	'smw-ask-otheroptions-info' => 'Dieser Abschnitt enthält Optionen, mit denen die Ergebnisausgabe gesteuert werden kann. Die Beschreibungen der Ausgabeparameter werden angezeigt, wenn man die Maus über deren Namen führt.',
	'smw-ask-otheroptions-collapsed-info' => 'Bitte auf das kleine Plus-Symbol klicken, um sich die weiteren verfügbaren Optionen anzeigen zu lassen.',
	'smw_ask_show_embed' => 'Code der Abfrage anzeigen',
	'smw_ask_hide_embed' => 'Code der Abfrage verstecken',
	'smw_ask_embed_instr' => 'Zum Einbetten dieser Abfrage in eine Wikiseite kann der unten angegebene Code verwendet werden.',
	'smw-ask-delete' => '[Löschen]',
	'smw-ask-sorting' => 'Sortierung',
	'smw-ask-format-selection-help' => 'Weitere Informationen sind auf der Hilfeseite $1 verfügbar',
	'querycreator' => 'Abfragenersteller',
	'smw_qc_addmainlabel' => 'Bezeichnung für die Hauptergebnisspalte hinzufügen',
	'smw_qc_show_addnal_opts' => 'Weitere Optionen anzeigen',
	'smw_qc_hide_addnal_opts' => 'Weitere Optionen ausblenden',
	'smw_qc_otheropt' => 'Andere Optionen',
	'smw_qc_intro' => 'Vorangestellter Text:',
	'smw_qc_outro' => 'Nachfolgender Text:',
	'smw_qc_default' => 'Standardtext:',
	'smw_qc_formatopt' => 'Formatierungsoptionen',
	'smw_qc_query_help' => 'Bitte eine Abfrage unter Verwendung des untenstehenden Formulars angeben, um Wikiseiten auf Basis von
Kategorien (bspw. <strong><nowiki>[[Kategorie:Schauspieler]]</nowiki></strong>),
Attributen (bspw. <strong><nowiki>[[Liegt in::Deutschland]]</nowiki></strong>),
Seitennamen (bspw. <strong><nowiki>[[Deutschland]]</nowiki></strong>) und
Namensräumen (bspw. <strong><nowiki>[[Hilfe:+]]</nowiki></strong>) auszuwählen.',
	'smw_qui_property' => '<strong>Attribut</strong>',
	'smw_qui_prop' => 'Attribut:',
	'smw_qui_labl' => 'Bezeichnung:',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Begrenzung:',
	'smw_qui_shownresults' => 'in den Ergebnissen anzeigen',
	'smw_qui_noquery' => 'Es wurde keine Abfrage angegeben',
	'smw_qui_invalidprop' => '„$1“ ist möglicherweise kein gültiges Attribut',
	'smw_qui_invalidformat' => 'Das ausgewählte Ergebnisformat „$1“ ist für dieses Wiki nicht verfügbar',
	'smw_qui_nosort' => 'Keine Sortierung',
	'smw_qui_ascorder' => 'Aufsteigend',
	'smw_qui_descorder' => 'Absteigend',
	'smw_qui_randorder' => 'Zufällig',
	'smw_qui_addnprop' => 'Attribut hinzufügen',
	'smw_qui_delete' => 'Entfernen',
	'smw_qui_rescol' => 'Abfrageergebnisse',
	'smw_qui_options' => 'Optionen',
	'smw_qui_addcategory' => 'Kategorie hinzufügen',
	'smw_qui_addrescol' => 'Abfrageergebnisse hinzufügen',
	'smw_qui_ok' => 'Okay',
	'smw_qui_cancel' => 'Abbrechen',
	'smw_qui_category' => '<strong>Kategorie</strong>',
	'smw_qui_label' => 'Beschriftung',
	'smw_prp_options' => 'Optionen zu Attributen',
	'smw_qui_catopts' => 'Optionen zu Kategorien',
	'smw_qui_mainlabopts' => 'Ergebnisoptionen',
	'smw_qui_dlabel' => 'Beschriftung:',
	'smw_qui_dcategory' => 'Kategorie:',
	'smw_qui_dcatyes' => 'Der anzuzeigende Text, sofern die Kategorie vorhanden ist:',
	'smw_qui_dcatno' => 'Der anzuzeigende Text, sofern die Kategorie nicht vorhanden ist:',
	'searchbyproperty' => 'Suche mittels Attribut',
	'smw_sbv_docu' => 'Diese Spezialseite ermittelt alle Seiten, die einen bestimmten Wert für das angegebene Attribut haben.',
	'smw_sbv_novalue' => 'Bitte den gewünschten Wert eingeben oder alle Werte für das Attribut $1 ansehen.',
	'smw_sbv_displayresult' => 'Eine Liste aller Seiten, die ein Attribut $1 mit dem Wert $2 haben.',
	'smw_sbv_displayresultfuzzy' => 'Eine Liste aller Seiten, die das Attribut „$1“ mit dem Wert „$2“ haben.
Weil nur wenige Ergebnisse gefunden wurden, werden auch ähnliche Werte aufgelistet.',
	'smw_sbv_property' => 'Attribut:',
	'smw_sbv_value' => 'Wert:',
	'smw_sbv_submit' => 'Ergebnisse suchen',
	'browse' => 'Semantisches Browsen',
	'smw_browselink' => 'Attribute anzeigen',
	'smw_browse_article' => 'Bitte den Namen einer Seite angeben, um mit dem Browsen zu beginnen.',
	'smw_browse_go' => 'Los',
	'smw_browse_show_incoming' => 'zeige Attribute die hierhin verlinken',
	'smw_browse_hide_incoming' => 'verstecke Attribute die hierhin verlinken',
	'smw_browse_no_outgoing' => 'Diese Seite enthält keine Attribute.',
	'smw_browse_no_incoming' => 'Keine Attribute verlinken auf diese Seite.',
	'smw_inverse_label_default' => '$1 von',
	'smw_inverse_label_property' => 'Bezeichnung des inversen Attributs',
	'pageproperty' => 'Attributwerte einer Seite',
	'smw_pp_docu' => 'Suche nach allen Werten, die für ein bestimmtes Attribut auf der benannten Seite angegeben sind.',
	'smw_pp_from' => 'Von Seite',
	'smw_pp_type' => 'Attribut',
	'smw_pp_submit' => 'Ergebnisse anzeigen',
	'smw_result_prev' => 'Vorherige',
	'smw_result_next' => 'Nächste',
	'smw_result_results' => 'Ergebnisse',
	'smw_result_noresults' => 'Es wurden keine Ergebnisse gefunden.',
	'smwadmin' => 'Administration von Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Die Speichereinheit wurde erfolgreich eingerichtet.',
	'smw_smwadmin_return' => 'Zurück zur Seite $1.',
	'smw_smwadmin_updatestarted' => 'Ein Aktualisierungsprozess zu Erneuerung der semantischen Daten wurde gestartet.
Alle gespeicherten Daten werden, sofern notwendig, entweder neu erstellt oder repariert.
Der Fortschritt der Aktualisierung kann auf dieser Spezialseite eingesehen werden.

Zurück zur Seite $1.',
	'smw_smwadmin_updatenotstarted' => 'Es läuft bereits ein Aktualisierungsprozess.
Es wird kein Neuer begonnen.

Zurück zur Seite  $1',
	'smw_smwadmin_updatestopped' => 'Alle laufenden Aktualisierungsprozesse wurden vorzeitig beendet.

Zurück zur Seite  $1.',
	'smw_smwadmin_updatenotstopped' => 'Um den laufenden Aktualisierungsprozess zu vorzeitig zu beenden, musst das Kontrollkästchen markiert werden, um dadurch anzuzeigen, dass man sich diesbezüglich tatsächlich sicher ist.

Zurück zur Seite  $1.',
	'smw_smwadmin_docu' => 'Diese Spezialseite bietet während Installation und Aktualisierung von <a href="http://semantic-mediawiki.org/wiki/Semantic_MediaWiki_–_Startseite">Semantic MediaWiki</a> Unterstützung. Wichtige Daten sollten vor der Ausführung administrativer Funktionen gesichert werden.',
	'smw_smwadmin_db' => 'Datenbankinstallation und -aktualisierung',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki benötigt weitere Datentabellen in der MediaWiki-Datenbank, um die semantischen Daten speichern zu können.
Die folgende Funktion gewährleistet, dass die Datenbank richtig eingerichtet ist.
Die Datenbankänderungen, die in diesem Schritt durchgeführt werden, beeinträchtigen den Rest der MediaWiki-Datenbank nicht. Sie können, sofern dies gewünscht ist, leicht rückgängig gemacht werden.
Diese Einrichtungsfunktion kann mehrere Male ausgeführt werden, ohne Schaden zu verursachen. Sie braucht allerdings nur einmal, während der Installation oder Aktualisierung von Semantic MediaWiki, durchgeführt werden.',
	'smw_smwadmin_permissionswarn' => 'Sofern diese Aktion mit einem SQL-Fehler abbricht, könnte es sein, dass der Datenbankbenutzer, mit dem das Wiki auf die Datenbank zugreift (siehe die Datei LocalSettings.php), über keine ausreichenden Rechte verfügt.
Um das Problem zu beheben, ist es notwendig, entweder dem Benutzer zusätzliche Rechte zur Erstellung und Löschung von Datenbanktabellen einzuräumen, den Datenbankadministrator zeitweilig in die Datei LocalSettings.php einzutragen, oder aber das Wartungsskript <tt>SMW_setup.php</tt> zu nutzen, das von einem Servernutzer mit Administrationsberechtigung ausgeführt werden kann.',
	'smw_smwadmin_dbbutton' => 'Tabellen initialisieren oder aktualisieren',
	'smw_smwadmin_announce' => 'Wiki bekannt geben',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki bietet einen Webservice zur Bekanntgabe neuer semantischer Wikis.
Dieser Service wird genutzt, um eine Liste aller öffentlich zugänglichen Wikis zu erhalten, die Semantic MediaWiki verwenden. Er dient aber auch dazu, dem <a href="http://semantic-mediawiki.org/wiki/SMW_Project">„Semantic MediaWiki“-Projekt</a> einen Überblick über typische Anwendungen von Semantic MediaWiki zu ermöglichen.
Siehe hierzu die Website von Semantic MediaWiki für <a href="http://semantic-mediawiki.org/wiki/Registry">weiterführende Informationen zu diesem Service</a>.',
	'smw_smwadmin_announcebutton' => 'Bitte die folgende Schaltfläche anklicken, um dem Verzeichnisdienst die URL dieses Wikis hinzuzufügen.
Es werden dabei nur öffentlich zugängliche Informationen gespeichert. Es werden keine Wikis aufgenommen, die nicht öffentlich zugänglich sind.',
	'smw_smwadmin_datarefresh' => 'Datenreparatur oder -aktualisierung',
	'smw_smwadmin_datarefreshdocu' => 'Es ist möglich alle Datenbanken von Semantic MediaWiki auf Basis des aktuellen Inhalts des Wikis wiederherzustellen.
Dies kann hilfreich sein, um eine fehlerhafte Datenbank zu erneuern oder um Daten zu aktualisieren, sofern bspw. aufgrund einer Softwareaktualisierung die Datenbankstruktur geändert wurde.
Die Datenaktualisierung wird für jede Seite ausgeführt und daher einige Zeit in Anspruch nehmen.
Nachfolgend wird angezeigt, ob eine momentan Aktualisierung läuft bzw. ermöglicht es eine Aktualisierung zu starten oder zu stoppen (sofern diese Funktion nicht vom Websiteadministrator deaktiviert wurde).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Eine Aktualisierung wird bereits durchgeführt.</strong>
Eine Aktualisierung geht normalerweise nur langsam voran, da die Daten lediglich in kleinen Schritten erneuert werden, und zwar jedes Mal, wenn ein Benutzer auf das Wiki zugreift.
Um diese Aktualisierung schneller zu Ende zu führen, kann man das MediaWiki-Wartungsskript <tt>runJobs.php</tt> einsetzen. Mit dem Parameter <tt>--maxjobs 1000</tt> beschränkt man dabei die Anzahl der Aktualisierungsschritte, die in einem Durchgang durchgeführt werden, um Probleme bei der Nutzung des hierfür erforderlichen Arbeitsspeichers zu vermeiden.
Geschätzter Fortschritt der laufenden Aktualisierung:',
	'smw_smwadmin_datarefreshbutton' => 'Datenaktualisierung starten',
	'smw_smwadmin_datarefreshstop' => 'Diese Datenaktualisierung beenden',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, ich bin mir sicher.',
	'smw_smwadmin_support' => 'Unterstützung erhalten',
	'smw_smwadmin_supportdocu' => 'Verschiedene Hinweise helfen vielleicht im Fall eines Problems:',
	'smw_smwadmin_installfile' => 'Sofern es Probleme mit der Installation gibt, könnte die Datei <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL</a> weiterhelfen.',
	'smw_smwadmin_smwhomepage' => 'Die komplette Nutzerdokumentation von Semantic MediaWiki ist auf <b><a href="http://semantic-mediawiki.org/wiki/Semantic_MediaWiki_%E2%80%93_Startseite">semantic-mediawiki.org</a></b> verfügbar.',
	'smw_smwadmin_mediazilla' => 'Fehler können bei <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> berichtet werden.',
	'smw_smwadmin_questions' => 'Im Fall weiterer Fragen oder Anregungen kann man sich an den Diskussionen im <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">„Semantic MediaWiki“-Benutzerforum</a> beteiligen.',
	'smw_adminlinks_datastructure' => 'Datenstruktur',
	'smw_adminlinks_displayingdata' => 'Datenanzeige',
	'smw_adminlinks_inlinequerieshelp' => 'Hilfe zu eingebetteten Abfragen',
	'smw-createproperty-isproperty' => 'Dies ist ein Attribut des Datentyps $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Der mögliche Wert für dieses Attribut ist|Die möglichen Werte für dieses Attribut sind}}:',
	'smw-paramdesc-category-delim' => 'Das Trennzeichen für die Ergebniswerte',
	'smw-paramdesc-category-template' => 'Die Vorlage, mit der die Objekte formatiert werden sollen',
	'smw-paramdesc-category-userparam' => 'Der Parameter, der an die Vorlage übergeben werden soll',
	'smw-info-par-message' => 'Die anzuzeigende Nachricht',
	'smw-info-par-icon' => 'Das anzuzeigende Symbol, entweder „Info“ (<code>info<code>) oder „Warnung“(<code>warning</code>)',
	'prefs-smw' => 'Semantische Suche',
	'prefs-ask-options' => 'Optionen für die Semantische Suche',
	'smw-prefs-intro-text' => 'Die unten angegebenen Optionen werden von [http://semantic-mediawiki.org/wiki/Semantic_MediaWiki_–_Startseite Semantic MediaWiki] oder zugehörigen Programmerweiterungen bereitgestellt, damit vorhandene Funktionen individuellen Bedürfnissen angepasst werden können. Weitere Informationen hierzu sind auf der Hilfeseite zu den [http://semantic-mediawiki.org/wiki/Help:Benutzereinstellungen Benutzereinstellungen] verfügbar.',
	'smw-prefs-ask-options-tooltip-display' => 'Beschreibung der Ausgabeparameter als Tooltip anzeigen',
	'smw-prefs-ask-options-collapsed-default' => 'Bereich mit den Ausgabeparametern standardmäßig einklappen',
	'smw-ui-tooltip-title-property' => 'Attribut',
	'smw-ui-tooltip-title-quantity' => 'Menge',
	'smw-ui-tooltip-title-info' => 'Information',
	'smw-ui-tooltip-title-service' => 'Servicelinks',
	'smw-ui-tooltip-title-warning' => 'Warnhinweis',
	'smw-ui-tooltip-title-parameter' => 'Parameter',
	'smw-ui-tooltip-title-event' => 'Ereignis',
	'smw_unknowntype' => 'Der Datentyp dieses Attributs ist ungültig.',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 * @author Mirzali
 */
$messages['diq'] = array(
	'smw_finallistconjunct' => ', u',
	'smw_printername_csv' => 'CSV Teberdayış',
	'smw_printername_dsv' => 'DSV Teberdayış',
	'smw_printername_json' => 'JSON teberdayış',
	'smw_printername_table' => 'Tablo',
	'smw_printername_template' => 'Şablon',
	'smw_printername_rdf' => 'RDF teberdayış',
	'smw_printername_category' => 'Kategoriye',
	'smw-paramdesc-export' => 'Weçenegê teberdayışi',
	'smw_true_words' => 'raştay,r,eya,e',
	'smw_false_words' => 'zuray,z,nê,n',
	'specialpages-group-smw_group' => 'Fahm kerdışê MediaWiki',
	'exportrdf' => 'Pela ahûlnê RDF',
	'properties' => 'Xısusiyey',
	'unusedproperties' => 'Xısusiyetê ke nê xebtênê',
	'wantedproperties' => 'Xısusiyetê ke waştênê',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|vıraştene|vıraştene}})',
	'smw_purge' => 'Newe ke',
	'types' => 'Babeti',
	'semanticstatistics' => 'İstatistike fahm kerdeni',
	'ask' => 'Fahmyayış cı geyrayış',
	'smw_ask_defaultformat' => 'hesıbyaye',
	'querycreator' => 'Vıraşterê Persiyayışi',
	'smw_qui_cancel' => 'Bıtexelne',
	'smw_qui_category' => '<strong>Kategoriye</strong>',
	'smw_qui_dcategory' => 'Kategoriye:',
	'searchbyproperty' => 'Xısusiyeti heta cıgeyrê',
	'smw_sbv_value' => 'Qıymet:',
	'smw_browselink' => 'Xısusiyetan bıvêne',
	'smw_browse_go' => 'Şo',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'smw-desc' => "Twój wiki pśistupnjejšy cyniś - za mašiny ''a'' luźi
([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentacija online])",
	'smw_viewasrdf' => 'Kanal RDF',
	'smw_finallistconjunct' => 'a',
	'smw_factbox_head' => 'Fakty wó $1',
	'smw_isspecprop' => 'Toś ta kakosć jo specialna kakosć w toś tom wikiju.',
	'smw_concept_description' => 'Wopisanje koncepta "$1"',
	'smw_no_concept_namespace' => 'Koncepty daju se jano na bokach w mjenjowem rumje Concept: definěrowaś.',
	'smw_multiple_concepts' => 'Kuždy konceptowy bok móžo jano jadnu konceptowu definiciju měś.',
	'smw_concept_cache_miss' => 'Koncept "$1" njedajo se we wokugnuśu wužywaś, dokulaž wikijowa konfiguracija trjeba jón za pśeźěłowanje off-line.
Jolic problem se njezgubujo pó wěstem casu, pšos swójogo sedłowego administratora, aby wón toś ten koncept k dispoziciji stajił.',
	'smw_noinvannot' => 'Gódnoty njedaju se nawopacnym kakosćam pśipokazaś.',
	'version-semantic' => 'Semantiske rozšyrjenja',
	'smw_baduri' => 'URI formy "$1" njejsu dowólone.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Wuslědki licyś',
	'smw_printername_csv' => 'Ako CSV eksportěrowaś',
	'smw_printername_dsv' => 'DSV-eksport',
	'smw_printername_debug' => 'Wótpšašanje za zmólkami pśepytaś (za ekspertow)',
	'smw_printername_embedded' => 'Bokowe wopśimjeśe zasajźiś',
	'smw_printername_json' => 'Ako JSON eksportěrowaś',
	'smw_printername_list' => 'Lisćina',
	'smw_printername_ol' => 'Nalicenje',
	'smw_printername_ul' => 'Nalistowanje',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Šyroka tabela',
	'smw_printername_template' => 'Pśedłoga',
	'smw_printername_rdf' => 'RDF-eksport',
	'smw_printername_category' => 'Kategorija',
	'smw-paramdesc-limit' => 'Maksimalna licba wuslědkow, kótarež maju se wrośiś',
	'smw-paramdesc-headers' => 'Mjenja głowow resp. atributow zwobrazniś',
	'smw-paramdesc-mainlabel' => 'Pomjenjenje, kótarež ma se głownemu bokoju daś',
	'smw-paramdesc-link' => 'Gódnoty ako wótkaze pokazaś',
	'smw-paramdesc-intro' => 'Tekst, kótaryž ma se pśed napšašowańskimi wuslědkami zwobrazniś, jolic take su',
	'smw-paramdesc-outro' => 'Tekst, kótaryž ma se za napšašowańskimi wuslědkami zwobrazniś, jolic take su',
	'smw-paramdesc-default' => 'Tekst, kótaryž ma se zwobrazniś, jolic napšašowańske wuslědki njejsu',
	'smw-paramdesc-sep' => 'Źěleńske znamuško za gódnoty',
	'smw-paramdesc-distributionlimit' => 'Rozdźělenje gódnotow na wěste gódnoty wobgranicowaś.',
	'smw-paramdesc-template' => 'Mjenja pśedłogi, z kótarejuž wuśišće maju se zwobrazniś',
	'smw-paramdesc-columns' => 'Licba słupow, w kótarychž maju se wuslědki zwobrazniś (standard jo $1)',
	'smw-paramdesc-userparam' => 'Gódnota jo se do zawołanje pśedłogi pśepódała, jolic pśedłoga se wužywa',
	'smw-paramdesc-introtemplate' => 'Mě pśedłogi, kótarež ma se zwobrazniś pśed wuslědkami napšašowanja, joli take su',
	'smw-paramdesc-outrotemplate' => 'Mě pśedłogi, kótarež ma se zwobrazniś za wuslědkami napšašowanja, joli take su',
	'smw-paramdesc-embedformat' => 'HTML-toflicka, kótaraž wužywa se, aby definěrowała nadpisma',
	'smw-paramdesc-embedonly' => 'Žedne nadpisma zwobraznis',
	'smw-paramdesc-table-class' => 'Pśidatna CSS-klasa za tabelu',
	'smw-paramdesc-rdfsyntax' => 'RDF-syntaksa, kótaraž ma se wužywaś',
	'smw-paramdesc-csv-sep' => 'Źěleńske znamuško, kótarež ma se wužywaś',
	'smw-paramdesc-dsv-separator' => 'Źěleńske znamuško, kótarež ma se wužywaś',
	'smw-paramdesc-dsv-filename' => 'Mě za DSV-dataju',
	'smw-smwdoc-par-format' => 'Wuslědkowy format, za kótaregož parametry dokumentacija ma se zwobrazniś.',
	'smw-paramdesc-sort' => 'Kakosć, pó kótarejž napšašowanje ma se sortěrowaś',
	'smw-paramdesc-searchlabel' => 'Tekst za dalšne pytańske wuslědki',
	'smw-paramdesc-named_args' => 'Argumenty, kótarež maju se pśedłoze pśepódaś',
	'smw-paramdesc-export' => 'Eksportowe nastajenje',
	'smw-paramdesc-prettyprint' => 'Njeformatěrowane wudaśe, kótarež zwobraznja pśidatne zasunjenja a nowe smužki',
	'smw-paramdesc-source' => 'Alternatiwne napšašowańske žrědło',
	'smw-paramdesc-jsonsyntax' => 'JSON-syntaksa, kótaraž ma se wužywaś',
	'smw_iq_disabled' => 'Semantiske wótpšašanja su se znjemóžnili za toś ten wiki.',
	'smw_iq_moreresults' => '... dalšne wuslědki',
	'smw_parseerror' => 'Zapódana gódnota njejo se rozměła.',
	'smw_notitle' => '"$1" njedajo se ako bokowe mě w toś tom wikiju wužywaś.',
	'smw_noproperty' => '"$1" njedajo se ako mě kakosći w toś tom wikiju wužywaś.',
	'smw_wrong_namespace' => 'Jano boki w mjenjowem rumje "$1" su how dowólone.',
	'smw_manytypes' => 'Wěcej ako jaden typ za kakosć definěrowany.',
	'smw_emptystring' => 'Prozne znamješkowe rědy se njeakceptěruju.',
	'smw_maxstring' => 'Znamješkowy rěd $1 jo pśedłujki.',
	'smw_notinenum' => '"$1" njejo w lisćinje móžnych gódnotow ($2) za toś tu kakosć.',
	'smw_noboolean' => '"$1" njejo dowólona gódnota typa Boolean (wěrny/njewěrny).',
	'smw_true_words' => 'wěrny, w, jo, j',
	'smw_false_words' => 'njewěrny, ně, n',
	'smw_nofloat' => '"$1" njejo licba.',
	'smw_infinite' => 'Licby, kótarež su dłujke ako "$1", se njepódpěraju.',
	'smw_unitnotallowed' => '"$1" njejo ako płaśiwa měrjeńska jadnotka za toś ten atribut póstajił.',
	'smw_nounitsdeclared' => 'Za toś tu kakosć njesu se žedne měrjeńške jadnotki namakali.',
	'smw_novalues' => 'Žedne gódnoty pódane',
	'smw_nodatetime' => 'Datum "$1" njejo se rozměł.',
	'smw_toomanyclosing' => 'Zda se, až jo pśewjele wustupowanjow "$1" w napšašowanju.',
	'smw_noclosingbrackets' => 'Jadne wustupowanje "<nowiki>[[</nowiki>" w twójom napšašanju njejo se pśez wótpowědnej "]]" wótzamknuło.',
	'smw_misplacedsymbol' => 'Symbol "$1" jo se na městnje wužył, źož njejo wužytny,',
	'smw_unexpectedpart' => 'Źěl "$1" wótpšašanja njejo se rozměł.
Wuslědki snaź njejsu ako wócakowane.',
	'smw_emptysubquery' => 'Pódwótpšašanje njama płaśiwe wuměnjenje.',
	'smw_misplacedsubquery' => 'Pódwótpšašanje wužywa se na městnje, źož pódwótpšašanja njejsu dowólone.',
	'smw_valuesubquery' => 'Pódwótpšašanja njepódpěraju se za gódnoty kakosći "$1".',
	'smw_badqueryatom' => 'Źěl wótpšašanja "<nowiki>[[…]]</nowiki>" njejo se rozměł.',
	'smw_propvalueproblem' => 'Gódnota kakosći "$1" njejo se rozměła.',
	'smw_noqueryfeature' => 'Někaka wótpšašowańska funkcije njejo se pódprěła a źěl wótpšašanja jo se wótpórał ($1).',
	'smw_noconjunctions' => 'Konjunkcije (zwězanja A) we wótpšašanjach njepódpěraju se w toś tom wikiju a źěl wótpšašanja jo se wótpórał ($1).',
	'smw_nodisjunctions' => 'Disjunkcije (zwězanja ABO) we wótpšašanjach njepódpěraju se w toś tom wikiju a źěl wótpšašanja jo se wótpórał ($1).',
	'smw_querytoolarge' => 'Dla wikijowych wobgranicowanjow we wjelikosći abo dłymokosći njejo było móžno slědujuce wótpšašańske wuměnjenja zapśimjeś: $1',
	'smw_notemplategiven' => 'Pódaj gódnotu za parameter "template", aby napšašowański format funkcioněrował.',
	'smw_type_header' => 'Kakosći typa "$1"',
	'smw_typearticlecount' => '$1 {{PLURAL:$1|kakosć pokazujo|kakosći pokazujotej|kakosći pokazuju|kakosćow pokazujo}} se z pomocu toś togo typa.',
	'smw_attribute_header' => 'Boki, kótarež wužywaju kakosć "$1"',
	'smw_attributearticlecount' => '$1 {{PLURAL:$1|bok pokazujo|boka pokazujotej|boki pokazuju|bokow pokazujo}} se z pomocu toś teje kakosći.',
	'smw_subproperty_header' => 'Pódkakosći',
	'smw_subpropertyarticlecount' => 'Toś ta kakosć ma {{PLURAL:$1|slědujucu pódkakosć|slědujucej $1 pódkakosći|slědujuce $1 pódkakosći|slědujucych $1 pódkakosćow}}:',
	'smw_concept_header' => 'Boki koncepta "$1"',
	'smw_conceptarticlecount' => '$1 {{PLURAL:$|bok se pokazujo|boka se pokazujotej|boki se pokazuju|bokow se pokazujo}}, {{PLURAL:$1|kótaryž słuša|kótarejž słušatej|kótarež słušaju|kótarež słušaju}} k tomu konceptoju.',
	'exportrdf' => 'Boki ako RDF eksportěrowaś',
	'smw_exportrdf_docu' => 'Toś ten bok śi dowólujo, daty z boka w formaśe RDF dobyś.
Aby boki eksportěrował, zapódaj titele do slědujucego tekstowego póla, jaden titel na smužku.',
	'smw_exportrdf_recursive' => 'Wšykne pśiwuzne boki rekursiwnje eksportěrowaś.
Źiwaj na to, až wuslědk by mógł wjeliki byś!',
	'smw_exportrdf_backlinks' => 'Teke wšykne boki eksportěrowaś, kótarež póśěgaju se na eksportěrowane boki.
Napórajo RDF, kótaryž dajo se pśepytaś.',
	'smw_exportrdf_lastdate' => 'Boki njeeksportěrowaś, kótarež njejsu se změnili wót pódanego casa.',
	'smw_exportrdf_submit' => 'Eksportěrowaś',
	'uriresolver' => 'Rezolwer URI',
	'properties' => 'Kakosći',
	'smw_properties_docu' => 'Slědujuce kakosći wužywaju se we wikiju.',
	'smw_property_template' => '$1 typa $2 ($3 {{PLURAL:$3|wužyśe|wužyśi|wužyśa|wužyśow}})',
	'smw_propertylackspage' => 'Wše kakosći měli se pśez bok wopisaś!',
	'smw_propertylackstype' => 'Za toś tu kakosć njejo se žeden typ pódał (mysli se tuchylu typ $1).',
	'smw_propertyhardlyused' => 'Toś ta kakosć se lěbda we wikiju wužywa!',
	'unusedproperties' => 'Njewužywane kakosći',
	'smw_unusedproperties_docu' => 'Slědujuce kakosći eksistěruju, lěcrownož žeden drugi bok je njewužywa.',
	'smw_unusedproperty_template' => '$1 typa $2',
	'wantedproperties' => 'Póžedane kakosći',
	'smw_wantedproperties_docu' => 'Slědujuce kakosći se we wikiju wužywaju, ale hyšći njamaju  bok, kótaryž je wopisujo.',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|raz|dwójcy|$2 raze|$2 raz}} wužyta)',
	'smw_purge' => 'Aktualizěrowaś',
	'types' => 'Typy',
	'smw_types_docu' => 'Slědujuca lisćina wšych datowych typow, kótarež daju se kakosćam pśipokazaś.',
	'semanticstatistics' => 'Semantiska statistika',
	'smw_semstats_text' => "Toś ten wiki wopśimujo '''$1''' {{PLURAL:$1|kakosćowu gódnotu|kakosćowej gódnośe|kakosćowe gódnoty|kakosćowych gódnotow}} za dogromady '''$2''' [[Special:Properties|{{PLURAL:$2|kakosć|rozdźělnej kakosći|rozdźělne kakosći|rozdźělnych kakosćow}}]].
'''$3''' {{PLURAL:$3|kakosć ma|kakosći matej|kakosći maju|kakosćow ma}} swójski bok a póžedany datowy typ je za '''$4''' z nich pódany.
Někotare eksistěrowacych kakosćow by mógli [[Special:UnusedProperties|njewužywane kakosći]] byś. Kakosći, kótarež njamaju bok, su se na [[Special:WantedProperties|lisćinje póžedanych kakosćow]] namakali.",
	'smw_uri_doc' => 'Rezolwer URI implementěrujo <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>.
Stara se za to, až luźe njebudu websedła.',
	'ask' => 'Semantiske pytanje',
	'smw_ask_sortby' => 'Pó słupje sortěrowaś (opcionalny)',
	'smw_ask_ascorder' => 'Stupajucy',
	'smw_ask_descorder' => 'Spadujucy',
	'smw_ask_submit' => 'Wuslědki namakaś',
	'smw_ask_editquery' => '[Wótpšašanje wobźěłaś]',
	'smw_add_sortcondition' => '[Sortěrowańske wuměnjenje pśidaś]',
	'smw_ask_hidequery' => '[Wótpšašanje schowaś]',
	'smw_ask_help' => 'Wótpšašowańska pomoc',
	'smw_ask_queryhead' => 'Wótpšašanje',
	'smw_ask_printhead' => 'Pśidatne daty, kótarež maju se zwobrazniś',
	'smw_ask_printdesc' => '(pśidaj jadne atributowe mě na smužku)',
	'smw_ask_format_as' => 'Formatěrowaś ako:',
	'smw_ask_defaultformat' => 'standard',
	'smw_ask_otheroptions' => 'Druge opcije',
	'smw-ask-otheroptions-collapsed-info' => 'Pšosym wužyj plusowy symbol (+), aby se wšykne k dispoziciji stojece opcije woglědał',
	'smw_ask_show_embed' => 'Zasajźony kod pokazaś',
	'smw_ask_hide_embed' => 'Zasajźony kod schowaś',
	'smw_ask_embed_instr' => 'Aby toś to wótpšašanje do wikiboka zasajźił, wužyj slědujucy kod.',
	'smw-ask-delete' => '[Lašowaś]',
	'smw-ask-sorting' => 'Sortěrowanje',
	'smw_qc_addmainlabel' => 'Głowne pomjenjenje pśidaś',
	'smw_qc_show_addnal_opts' => 'Dalšne opcije pokazaś',
	'smw_qc_hide_addnal_opts' => 'Mjenjej opcijow pokazaś',
	'smw_qc_otheropt' => 'Druge opcije',
	'smw_qc_intro' => 'Zawjeźenje:',
	'smw_qc_outro' => 'Naslědujucy tekst:',
	'smw_qc_default' => 'Standard:',
	'smw_qc_formatopt' => 'Formatowe opcije',
	'smw_qui_property' => '<strong>Kakosć</strong>',
	'smw_qui_prop' => 'Kakosć:',
	'smw_qui_labl' => 'Pomjenjenje:',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Limit:',
	'smw_qui_shownresults' => 'we wuslědkach pokazaś',
	'smw_qui_noquery' => 'Napšašowanje njejo se pódało',
	'smw_qui_invalidprop' => 'Móžo byś, až "$1" njejo płaśiwa kakosć',
	'smw_qui_invalidformat' => 'Wubrany format "$1" njeeksistěrujo za toś tón wiki',
	'smw_qui_nosort' => 'Žedno sortěrowanje',
	'smw_qui_ascorder' => 'Stupajucy',
	'smw_qui_descorder' => 'Spadujucy',
	'smw_qui_randorder' => 'Pśipadny',
	'smw_qui_addnprop' => 'kakosć pśidaś',
	'smw_qui_delete' => 'Wótpóraś',
	'smw_qui_options' => 'opcije',
	'smw_qui_addcategory' => 'kategoriju pśidaś',
	'smw_qui_ok' => 'W pórěźe',
	'smw_qui_cancel' => 'Pśetergnuś',
	'smw_qui_category' => '<strong>Kategorija</strong>',
	'smw_qui_label' => 'Pomjenjenje',
	'smw_prp_options' => 'Opcije kakosćow',
	'smw_qui_catopts' => 'Opcije kategorijow',
	'smw_qui_mainlabopts' => 'Opcije wuslědkow',
	'smw_qui_dlabel' => 'Pomjenjenje:',
	'smw_qui_dcategory' => 'Kategorija:',
	'smw_qui_dcatyes' => 'Tekst, kótaryž ma se pokazaś, gaž kategorija eksistěrujo:',
	'smw_qui_dcatno' => 'Tekst, kótaryž ma se pokazaś, gaž kategorija njeeksistěrujo:',
	'searchbyproperty' => 'Pó kakosći pytaś',
	'smw_sbv_docu' => 'Wšykne boki pytaś, kótarež maju wěstu kakosć a gódnotu.',
	'smw_sbv_novalue' => 'Zapódaj płaśiwu gódnotu za kakosć abo woglědaj se wšykne gódnoty za kakosć "$1".',
	'smw_sbv_displayresult' => 'Lisćina wšych bokow, kótarež maju kakosć "$1" z gódnotu "$2"',
	'smw_sbv_displayresultfuzzy' => 'Lisćina wšych bokow, kótarež maju kakosć "$1" z gódnotu "$2".
Dokulaž jo jano mało wuslědkow było, zwobraznjuju se pódobne gódnoty.',
	'smw_sbv_property' => 'Kakosć:',
	'smw_sbv_value' => 'Gódnota:',
	'smw_sbv_submit' => 'Wuslědki namakaś',
	'browse' => 'Wiki pśepytaś',
	'smw_browselink' => 'Kakosći pśepytaś',
	'smw_browse_article' => 'Zapódaj mě boka, wót kótaregož ma se pytaś.',
	'smw_browse_go' => 'Pytaś',
	'smw_browse_show_incoming' => 'Kakosći pokazaś, kótarež sem wótkazuju',
	'smw_browse_hide_incoming' => 'Kakosći schowaś, kótarež sem wótkazuju',
	'smw_browse_no_outgoing' => 'Toś ten bok njama kakosći.',
	'smw_browse_no_incoming' => 'Žedne kakosći njewótkazuju k toś tomu bokoju.',
	'smw_inverse_label_default' => '$1 wót',
	'smw_inverse_label_property' => 'Pomjenjenje nawopacneje kakosći',
	'pageproperty' => 'Pytanje za bokoweju kakosću',
	'smw_pp_docu' => 'Wše gódnoty kakosći na pódanem boku pytaś.
Zapódaj ako bok tak teke kakosć.',
	'smw_pp_from' => 'Wót boka',
	'smw_pp_type' => 'Kakosć',
	'smw_pp_submit' => 'Wuslědki namakaś',
	'smw_result_prev' => 'Slědk',
	'smw_result_next' => 'Pśiducy',
	'smw_result_results' => 'Wuslědki',
	'smw_result_noresults' => 'Žedne wuslědki.',
	'smwadmin' => 'Administratorowe funkcije za Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Składowańska jadnotka jo se wuspěšnje nastajiła.',
	'smw_smwadmin_return' => 'Slědk k $1',
	'smw_smwadmin_updatestarted' => 'Nowy aktualizěrowański proces za wótnowjenje semantiskich datow jo se startował.
Wšykne skłaźone daty budu se znowego natwarjaś abo pórěźaś, źož trjeba.
Móžoš póstupoju aktualizacije na toś tom specialnem boku slědowaś.

Slědk k $1.',
	'smw_smwadmin_updatenotstarted' => 'Proces aktualizacije južo běžy.
Nowy se njestartujo.

Slědk k $1.',
	'smw_smwadmin_updatestopped' => 'Wše eksistěrujuce aktualizěrowańske procese su se zastajili.

Slědk k $1.',
	'smw_smwadmin_updatenotstopped' => 'Aby běžecy proces zastajił, musyš kontrolowy kašćik aktiwěrowaś, aby pódał, až sy napšawdu wěsty.

Slědk k $1.',
	'smw_smwadmin_docu' => 'Toś ten specialny bok śi pomaga za instalaciju a aktualizaciju a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>. Mysli se na zawěsćenje gódnotnych datow, nježli až wuwjeźoš administratiwne funkcije.',
	'smw_smwadmin_db' => 'Instalacija a aktualizacija datoweje banki',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki trjeba rozšyrjenja za datowu banku MediaWiki, aby semantiske daty składował. Slědujuca funkcija zawěsćijo, až twója datowa banka se pórědnje zarědujo.
Změny, kótarež cynje se w toś tom kšacu, njewobwliwuju zbytk datoweje banki MediaWiki a daju se lažko anulěrowaś, jolic póžedane.
Toś te zarědowańska funkcija móžo se někotare razy wugbaś, mimo až zawinuju škódu, ale jo trěbna jano jaden raz pśi instalaciji abo aktualizaciji.',
	'smw_smwadmin_permissionswarn' => 'Jolic operacija raźi se z SQL-zmólkami, wužywaŕ datoweje banki, kótaregož twój wiki wužywa (skontrolěruj twóju dataja LocalSettings.php), nejskerjej njama dosegajuce pšawa.
Pak zwól toś tomu wužywarjeju pśidatne pšawa za napóranje a lašowanje tabelow, zapódaj nachylu twójo admininistratorowe wužywarske mě w LocalSettings.php, pak wužyj wótglědowański skript <tt>SMW_setup.php</tt>, kótarež mógu wósobinske pódaśa administratora wužywaś.',
	'smw_smwadmin_dbbutton' => 'Tabele inicializěrowaś abo aktualizěrowaś',
	'smw_smwadmin_announce' => 'Twój wiki pśipowěźeś',
	'smw_smwadmin_announcedocu' => 'Semantic Mediawiki ma websłužbu za wuzjawjenje nowych semantiskich wikisedłow.
To se wužywa, aby wuźaržowało lisćinu zjawnych sedłow, kótarež wužywaju Semantic MediaWiki, głownje aby  pomagało <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektoju Semantic MediaWiki</a> pśeglěd typiskich wužywanjow Semantic MediaWiki daś.
Glědaj startowy bok Semantic MediaWiki za <a href="http://semantic-mediawiki.org/wiki/Registry">dalšne informacije wó toś tej słužbje</a>.',
	'smw_smwadmin_announcebutton' => 'Tłoc na slědujucy tłocašk, aby pósłał swój wikiijowy URL k tej słužbje.
Słužba njebuźo wikije registrěrowaś, kótarež njejsu zjawnje pśistupne a buźo pśistupne informacije jano zjawnje składowaś.',
	'smw_smwadmin_datarefresh' => 'Reparatura a aktualizacija datow',
	'smw_smwadmin_datarefreshdocu' => 'Jo móžno, wšykne daty Semantic MediaWiki wótnowiś, kótarež bazěruju na aktualnem wopśimjeśu wikija.
To móžo wužytne byś, aby se wobškóźone daty pórěźili abo daty aktualizěrowali, jolic interny format jo se změnił pśez aktualizaciju softwara.
Aktualizacija pśewjedujo se bok pó boku a njebuźo se ned kóńcyś.
Slědujuce pokazujo, lěc aktualizacija rowno wótběgujo a dowólujo śi aktualizacije startowaś abo zastajiś (snaźkuli toś ta funkcija jo se wót administratora sedła znjemóžniła).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Aktualizacija se rowno wótměwa.</strong>
Jo normalne, až aktualizacija jano pómałem póstupujo, dokulaž aktualizěrujo daty jano w małych porcijach kuždy raz, gaž wužywaŕ ma pśistup na wiki.
Aby skóńcył toś tu aktualizaciju malsnjeje, móžoš wótwardowański skript MediaWiki <tt>runJobs.php</tt> zawołaś (wužyj opciju <tt>--maxjobs 1000</tt>, aby wobgranicował licbu aktualizacijow, kótarež se naraz pśewjadu).
Licony póstup aktualneje aktualizacije:',
	'smw_smwadmin_datarefreshbutton' => 'Aktualizaciju datow zachopiś',
	'smw_smwadmin_datarefreshstop' => 'Toś tu aktualizaciju zastajiś',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jo, som se wěsty.',
	'smw_smwadmin_support' => 'Pódpěru wobstaraś',
	'smw_smwadmin_supportdocu' => 'Wšake resurse mógli śi w paźe problemow pomagaś:',
	'smw_smwadmin_installfile' => 'Joli maš problemy ze swójeju instalaciju, pśecytaj směrnice w dataji <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Dopołna wužywarska dokumentacija za Semantic MediaWiki jo na <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Zmólki daju se na <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> k wěsći daś.',
	'smw_smwadmin_questions' => 'Jolic maš dalšne pšašanja abo naraźenja, pśizamkni se diskusiji na <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">wužywarskem forumje Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Datowa struktura',
	'smw_adminlinks_displayingdata' => 'Daty zwobrazniś',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoc k wótpšašanjam',
	'smw-createproperty-isproperty' => 'To jo kakosć typa $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Dowólona gódnota za toś tu kakosć jo|Dowólonej gódnośe za toś tu kakosć stej|Dowólone gódnoty za toś tu kakosć su|Dowólone gódnoty za toś tu kakosć su}}:',
	'smw-paramdesc-category-delim' => 'Źěleńske znamuško',
	'smw-paramdesc-category-template' => 'Pśedłoga, z kótarejuž zapiski maju se formatěrowaś',
	'smw-paramdesc-category-userparam' => 'Parmeter, kótaryž ma se pśedłoze pśepódaś',
	'smw-info-par-message' => 'Powěsć, kótaraž ma se zwobrazniś.',
	'smw-info-par-icon' => 'Symbol, kótaryž ma se pokazaś, pak "info" pak "warnowanje".',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Semantiske pytańske opcije',
	'smw-prefs-ask-options-tooltip-display' => 'Parametrowy tekst ako spěšne info zwobrazniś',
	'smw-ui-tooltip-title-property' => 'Kakosć',
	'smw-ui-tooltip-title-info' => 'Informacije',
	'smw-ui-tooltip-title-service' => 'Słužbne wótkaze',
	'smw-ui-tooltip-title-warning' => 'Zmólka',
	'smw_unknowntype' => 'Typ toś teje kakosći jo njepłaśiwy',
);

/** Ewe (eʋegbe)
 */
$messages['ee'] = array(
	'smw_browse_go' => 'Yi',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Crazymadlover
 * @author Geraki
 * @author Lou
 * @author Omnipaedista
 * @author Protnet
 * @author ZaDiak
 */
$messages['el'] = array(
	'smw-desc' => "Κάνοντας το βίκι σας πιο προσιτό - σε μηχανές ''και'' ανθρώπους ([http://semantic-mediawiki.org/wiki/Help:User_manual ηλεκτρονική τεκμηρίωση])",
	'smw_viewasrdf' => 'Ροή RDF',
	'smw_finallistconjunct' => ', και',
	'smw_factbox_head' => 'Γεγονότα για $1',
	'smw_isspecprop' => 'Αυτή η ιδιότητα είναι μια ειδική ιδιότητα σε αυτό το βίκι.',
	'smw_concept_description' => 'Περιγραφή του κόνσεπτ "$1"',
	'version-semantic' => 'Σημασιολογικές επεκτάσεις',
	'smw_printername_count' => 'Αποτελέσματα μέτρησης',
	'smw_printername_csv' => 'Εξαγωγή CSV',
	'smw_printername_debug' => 'Αίτημα εκσφαλμάτωσης (για ειδικούς)',
	'smw_printername_embedded' => 'Ενσωμάτωση περιεχομένων σελίδων',
	'smw_printername_json' => 'Εξαγωγή JSON',
	'smw_printername_list' => 'Λίστα',
	'smw_printername_ol' => 'Αριθμοποίηση',
	'smw_printername_ul' => 'Αντικειμενοποίηση',
	'smw_printername_table' => 'Πίνακας',
	'smw_printername_broadtable' => 'Πίνακας Επιτροπής',
	'smw_printername_template' => 'Πρότυπο',
	'smw_printername_category' => 'Κατηγορία',
	'validator-type-class-SMWParamSource' => 'κείμενο',
	'smw-paramdesc-limit' => 'Ο μέγιστος αριθμός αποτελεσμάτων που θα επιστραφούν',
	'smw-paramdesc-headers' => 'Προβολή των κεφαλίδων/ονομάτων ιδιοτήτων',
	'smw-paramdesc-mainlabel' => 'Η ετικέτα που θα δοθεί στο όνομα της κύριας σελίδας',
	'smw-paramdesc-link' => 'Εμφάνιση τιμών ως σύνδεσμοι',
	'smw-paramdesc-intro' => 'Το κείμενο που θα εμφανίζεται πριν από τα αποτελέσματα του ερωτήματος, αν υπάρχουν',
	'smw-paramdesc-outro' => 'Το κείμενο που θα εμφανίζεται μετά από τα αποτελέσματα του ερωτήματος, αν υπάρχουν',
	'smw-paramdesc-default' => 'Το κείμενο που θα εμφανίζεται αν δεν υπάρχουν αποτελέσματα ερωτήματος',
	'smw-paramdesc-sep' => 'Το διαχωριστικό για τις τιμές',
	'smw-paramdesc-showsep' => 'Εμφάνιση διαχωριστικού στην αρχή του αρχείου CSV ("sep=<value>")',
	'smw-paramdesc-distribution' => 'Αντί για προβολή όλων των τιμών, καταμέτρηση των εμφανίσεών τους και προβολή αυτών.',
	'smw-paramdesc-distributionsort' => 'Ταξινόμηση της κατανομής τιμών βάσει πλήθους εμφανίσεων.',
	'smw-paramdesc-distributionlimit' => 'Περιορισμός της κατανομής τιμών σε πλήθος μόνο κάποιων τιμών.',
	'smw-paramdesc-embedonly' => 'Μη εμφάνιση επικεφαλίδων',
	'smw_iq_moreresults' => '... περισσότερα αποτελέσματα',
	'smw_emptystring' => 'Κενές συμβολοσειρές δεν γίνονται δεκτές.',
	'smw_true_words' => 'αλήθεια,α,ναι,ν',
	'smw_false_words' => 'σφάλμα,σ,όχι,ο',
	'smw_nofloat' => 'Το "$1" δεν είναι αριθμός',
	'smw_nodatetime' => 'Η ημερομηνία "$1" δεν έγινε κατανοητή.',
	'smw_type_header' => 'Ιδιότητες του τύπου "$1"',
	'smw_attribute_header' => 'Σελίδες που χρησιμοποιούν την ιδιότητα "$1"',
	'smw_subproperty_header' => 'Υποϊδιότητες',
	'smw_concept_header' => 'Σελίδες του κόνσεπτ "$1"',
	'exportrdf' => 'Εξαγωγή σελίδων στο RDF',
	'smw_exportrdf_submit' => 'Εξαγωγή',
	'uriresolver' => 'Επιλύτης URI',
	'properties' => 'Ιδιότητες',
	'smw_property_template' => '$1 του τύπου $2 ($3)', # Fuzzy
	'unusedproperties' => 'Αχρησιμοποίητες ιδιότητες',
	'smw_unusedproperty_template' => '$1 του τύπου $2',
	'wantedproperties' => 'Επιθυμητές ιδιότητες',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|χρήση|χρήσεις}})',
	'smw_purge' => 'Ανανέωση',
	'types' => 'Τύποι',
	'semanticstatistics' => 'Σημασιολογικά στατιστικά',
	'ask' => 'Σημασιολογική αναζήτηση',
	'smw_ask_sortby' => 'Κατάταξη βάσει στήλης (προαιρετικό)',
	'smw_ask_ascorder' => 'Αύξουσα',
	'smw_ask_descorder' => 'Φθίνουσα',
	'smw_ask_submit' => 'Αναζήτηση αποτελεσμάτων',
	'smw_ask_editquery' => '[Επεξεργασία αιτήματος]',
	'smw_add_sortcondition' => '[Προσθήκη κατατακτικού όρου]',
	'smw_ask_hidequery' => 'Απόκρυψη αιτήματος',
	'smw_ask_help' => 'Βοήθεια σχετικά με αίτημα',
	'smw_ask_queryhead' => 'Αίτημα',
	'smw_ask_printhead' => 'Πρόσθετα δεδομένα προς εμφάνιση',
	'smw_ask_format_as' => 'Μορφοποίηση ως:',
	'smw_ask_defaultformat' => 'Προεπιλογή',
	'smw_ask_otheroptions' => 'Άλλες επιλογές',
	'smw_ask_show_embed' => 'Εμφάνιση ενσωματωμένου κώδικα',
	'smw_ask_hide_embed' => 'Απόκρυψη ενσωματωμένου κώδικα',
	'searchbyproperty' => 'Αναζήτηση κατά ιδιότητα',
	'smw_sbv_property' => 'Ιδιότητα:',
	'smw_sbv_value' => 'Τιμή:',
	'smw_sbv_submit' => 'Αναζήτηση αποτελεσμάτων',
	'browse' => 'Πλοήγηση στο wiki',
	'smw_browselink' => 'Πλοήγηση στις ιδιότητες',
	'smw_browse_go' => 'Πήγαινε',
	'smw_browse_show_incoming' => 'εμφάνιση ιδιοτήτων που συνδέουν εδώ',
	'smw_browse_hide_incoming' => 'απόκρυψη ιδιοτήτων που συνδέουν εδώ',
	'smw_inverse_label_default' => '$1 από',
	'pageproperty' => 'Αναζήτηση ιδιότητας σελίδας',
	'smw_pp_from' => 'Από τη σελίδα',
	'smw_pp_type' => 'Ιδιότητα',
	'smw_pp_submit' => 'Αναζήτηση αποτελεσμάτων',
	'smw_result_prev' => 'Προηγούμενος',
	'smw_result_next' => 'Επόμενο',
	'smw_result_results' => 'Αποτελέσματα',
	'smw_result_noresults' => 'Συγνώμη, δεν υπάρχουν αποτελέσματα.',
	'smw_smwadmin_return' => 'Επιστροφή στην $1',
	'smw_smwadmin_updatestopped' => 'Όλες οι υπάρχουσες εργασίες ενημέρωσης έχουν διακοπεί.', # Fuzzy
	'smw_smwadmin_db' => 'Εγκατάσταση βάσεως δεδομένων και αναβάθμιση',
	'smw_smwadmin_dbbutton' => 'Αρχικοποίηση ή αναβάθμιση πινάκων',
	'smw_smwadmin_announce' => 'Ανακοίνωση του wiki σας',
	'smw_smwadmin_datarefresh' => 'Επιδιόρθωση και αναβάθμιση δεδομένων',
	'smw_smwadmin_datarefreshbutton' => 'Έναρξη ενημέρωσης δεδομένων',
	'smw_smwadmin_datarefreshstop' => 'Σταμάτα αυτή την ενημέρωση',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ναι, είμαι σίγουρος.',
	'smw_smwadmin_support' => 'Παίρνοντας υποστήριξη',
	'smw_smwadmin_supportdocu' => 'Διάφορες πηγές ενδέχεται να σας βοηθήσουν σε περίπτωση που αντιμετωπίζετε προβλήματα:',
	'smw_adminlinks_datastructure' => 'Δομή δεδομένων',
	'smw_adminlinks_displayingdata' => 'Προβαλλόμενα δεδομένα',
	'smw_adminlinks_inlinequerieshelp' => 'Βοήθεια με τα αιτήματα',
	'smw-createproperty-isproperty' => 'Αυτή είναι μια ιδιότητα του τύπου $1.',
);

/** British English (British English)
 * @author Reedy
 */
$messages['en-gb'] = array(
	'smw_printername_ul' => 'Itemisation',
	'smw_noboolean' => '"$1" is not recognised as a Boolean (true/false) value.',
);

/** Esperanto (Esperanto)
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'smw_viewasrdf' => 'RDF-fonto',
	'smw_finallistconjunct' => ', kaj',
	'smw_factbox_head' => 'Faktoj pri $1',
	'smw_isspecprop' => 'Ĉi tiu atributo estas speciala atributo en ĉi tiu vikio.',
	'smw_concept_description' => 'Priskribo de koncepto "$1"',
	'smw_no_concept_namespace' => 'Konceptoj povas nur esti difinita en paĝoj en la nomspaco Concept:.',
	'smw_baduri' => 'Bedaŭrinde, URI-oj de la kamparo "$1" ne estas permesita.',
	'smw_printername_csv' => 'CSV-eksporto',
	'smw_printername_list' => 'Listo',
	'smw_printername_rss' => 'RSS-eksporti',
	'smw_printername_table' => 'Tabelo',
	'smw_printername_broadtable' => 'Larĝa tabelo',
	'smw_printername_template' => 'Ŝablono',
	'smw_printername_category' => 'Kategorio',
	'smw_iq_disabled' => 'Bedaŭrinde, semantikaj informmendoj estis malebligitaj por ĉi tiu vikio.',
	'smw_iq_moreresults' => '… pluaj rezultoj',
	'smw_parseerror' => 'La donata valoro ne estas komprenita.',
	'smw_notitle' => '"$1" ne eblas esti uzata kiel paĝnomo en ĉi tiu vikio.',
	'smw_manytypes' => 'Pli ol unu tipo estas difinita por atributo.',
	'smw_emptystring' => 'Malplenaj ĉenoj ne estas akceptitaj.',
	'smw_maxstring' => 'Ĉena reprezentado $1 estas tro longa.',
	'smw_notinenum' => '"$1" ne estas en la listo de eblaj valoroj ($2) por ĉi tiu atributo.',
	'smw_noboolean' => '"$1" ne estas agnoskita kiel Bulea (vera/falsa) valoro.',
	'smw_true_words' => 'vera,v,jes,j',
	'smw_false_words' => 'falsa,f,ne,n',
	'smw_nofloat' => '"$1" ne estas nombro.',
	'smw_nodatetime' => 'La dato "$1" ne estis komprenita.',
	'smw_toomanyclosing' => 'Verŝajne estas tro da okazoj de "$1" en la mendo.',
	'smw_misplacedsymbol' => 'La signo "$1" estis uzita en loko kie ĝi ne estas utila.',
	'smw_emptysubquery' => 'Iu submendo havas neniun validan kondiĉon.',
	'smw_propvalueproblem' => 'La valoro de atributo "$1" ne estas komprenita.',
	'smw_type_header' => 'Atributoj de tipo "$1"',
	'smw_typearticlecount' => 'Montrante $1 {{PLURAL:$1|atributon|atributojn}} uzante ĉi tiun tipon.',
	'smw_attribute_header' => 'Paĝoj uzantaj atrubuton "$1"',
	'smw_attributearticlecount' => 'Jen $1 {{PLURAL:$1|paĝo havanta|paĝoj havantaj}} ĉi tiun atributon.',
	'smw_subproperty_header' => 'Subatributoj',
	'smw_subpropertyarticlecount' => 'Ĉi tiu atributo havas la $1 {{PLURAL:$1|jenan subatributon|jenajn subatributojn}}.',
	'smw_concept_header' => 'Paĝoj de koncepto "$1"',
	'exportrdf' => 'Eksporti paĝojn al RDF',
	'smw_exportrdf_submit' => 'Eksporti',
	'properties' => 'Atributoj',
	'smw_properties_docu' => 'La jenaj atributoj estas uzataj en la vikio.',
	'smw_property_template' => '$1 de datumtipo $2 ($3)',
	'unusedproperties' => 'Neuzitaj atributoj',
	'smw_unusedproperty_template' => '$1 de datumtipo $2',
	'wantedproperties' => 'Volitaj atributoj',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uzo|uzoj}})',
	'smw_purge' => 'Refreŝigi',
	'types' => 'Datumtipoj',
	'smw_types_docu' => 'Jen listo de ĉiuj datentipoj kiu povas esti asignitaj al atributoj.
Ĉiu datentipo havas paĝon kie plua informo povas esti aldonita.',
	'semanticstatistics' => 'Semantikaj Statistikoj',
	'ask' => 'Semantika serĉo',
	'smw_ask_sortby' => 'Ordigi laŭ kolumnoj (nedevige)',
	'smw_ask_submit' => 'Trovi rezultojn',
	'smw_ask_editquery' => '[Redakti serĉomendon]',
	'smw_add_sortcondition' => '[Aldoni ordigan kondiĉon]',
	'smw_ask_hidequery' => 'Kaŝi serĉmendon',
	'smw_ask_help' => 'Helpo pri serĉomendoj',
	'smw_ask_queryhead' => 'Serĉomendo',
	'smw_ask_format_as' => 'Formati kiel:',
	'smw_ask_defaultformat' => 'defaŭlta',
	'smw_ask_otheroptions' => 'Aliaj opcioj',
	'smw_ask_show_embed' => 'Montri enkorpigitan kodon',
	'smw_ask_hide_embed' => 'Kaŝi enkorpigitan kodon',
	'querycreator' => 'Mendo-Kreilo',
	'smw_qc_addmainlabel' => 'Aldoni ĉefan etikedon',
	'smw_qc_default' => 'Defaŭlta:',
	'smw_qui_addnprop' => 'aldoni atributon',
	'smw_qui_delete' => 'Forigi',
	'smw_qui_addcategory' => 'aldoni kategorion',
	'smw_qui_cancel' => 'Nuligi',
	'smw_qui_dlabel' => 'Etikedo:',
	'smw_qui_dcategory' => 'Kategorio:',
	'searchbyproperty' => 'Serĉi laŭ atributo',
	'smw_sbv_property' => 'Atributo:',
	'smw_sbv_value' => 'Valoro:',
	'smw_sbv_submit' => 'Trovi rezultojn',
	'browse' => 'Foliumi vikion',
	'smw_browselink' => 'Trovidi atributojn',
	'smw_browse_article' => 'Enigi la nomon de la paĝo por komenci retumadon.',
	'smw_browse_go' => 'Ek',
	'smw_browse_show_incoming' => 'malkaŝi atributojn kiu enligiĝas ĉi tien',
	'smw_browse_hide_incoming' => 'kaŝi atributojn kiu enligiĝas ĉi tien',
	'smw_browse_no_outgoing' => 'Ĉi tiu paĝo havas neniujn atributojn.',
	'smw_browse_no_incoming' => 'Neniuj atributojn ligas al ĉi tiun paĝon.',
	'smw_inverse_label_default' => '$1 el',
	'smw_inverse_label_property' => 'Inversa atributa etikedo',
	'pageproperty' => 'Serĉo de paĝaj atributoj',
	'smw_pp_from' => 'De paĝo',
	'smw_pp_type' => 'Atributo',
	'smw_pp_submit' => 'Trovi rezultojn',
	'smw_result_prev' => 'Antaŭe',
	'smw_result_next' => 'Sekve',
	'smw_result_results' => 'Rezultoj',
	'smw_result_noresults' => 'Bedaŭrinde, neniuj rezultoj',
	'smwadmin' => 'Administradaj funkcioj por Semantic MediaWiki',
	'smw_smwadmin_return' => 'Reiri al $1',
	'smw_smwadmin_db' => 'Datenbaza instalado kaj promociado',
	'smw_smwadmin_announce' => 'Anonci vian vikion',
	'smw_smwadmin_datarefreshstop' => 'Halti ĉi tiun ĝisdatigon',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jes, mi certas.',
	'smw_smwadmin_support' => 'Teni subtenon',
	'smw_smwadmin_mediazilla' => 'Cimoj povas esti raportitaj al <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_adminlinks_datastructure' => 'Datumstrukturo',
	'smw-createproperty-isproperty' => 'Ĉi tiu estas atributo de speco $1.',
	'smw-createproperty-allowedvals' => 'La {{PLURAL:$1|permesita valoro por ĉi tiu atributo|permesitaj valoroj por ĉi tiuj atributoj}} estas:',
	'smw_unknowntype' => 'Nesubtenita datumtipo "$1" difinita por atributo.', # Fuzzy
);

/** Spanish (español)
 * @author Antur
 * @author Armando-Martin
 * @author Bola
 * @author Carmen Jorge García-Reyes
 * @author Crazymadlover
 * @author Dvdgmz
 * @author Fitoschido
 * @author Imre
 * @author Javier Calzada Prado
 * @author Locos epraix
 * @author MaxSem
 * @author Sanbec
 * @author Translationista
 */
$messages['es'] = array(
	'smw-desc' => "Haciendo tu wiki más accesible - para máquinas ''y'' humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentación en línea])",
	'smw_viewasrdf' => 'Ver como RDF',
	'smw_finallistconjunct' => ' y',
	'smw_factbox_head' => 'Hechos relativos a $1 — Búsqueda de páginas similares con <span class="smwsearchicon">+</span>.',
	'smw_isspecprop' => 'Esta propiedad es una propiedad especial en este wiki.',
	'smw_concept_description' => 'Descripción del concepto "$1"',
	'smw_no_concept_namespace' => 'Conceptos solo pueden ser definidos en páginas en el Concept: espacio de nombre.',
	'smw_multiple_concepts' => 'Cada página de concepto solamente puede tener una definición de concepto.',
	'smw_concept_cache_miss' => 'El concepto "$1" no puede ser utilizado en este momento, ya que la configuración wiki exige que sea computado sin conexión.
Si el problema persiste después de pasado algún tiempo, solicita al administrador de tu sitio que haga este concepto disponible.',
	'smw_noinvannot' => 'Los valores no pueden asignarse a propiedades inversas.',
	'version-semantic' => 'Extensiones semánticas',
	'smw_baduri' => 'Lo sentimos. Las URIs del dominio $1 no están disponibles en este emplazamiento',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Contar resultados',
	'smw_printername_csv' => 'Exporta CSV',
	'smw_printername_dsv' => 'Exportar en DSV',
	'smw_printername_debug' => 'Depura requerimiento (para expertos)',
	'smw_printername_embedded' => 'Incluye contenido de la página',
	'smw_printername_json' => 'Exportar JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'enumeración',
	'smw_printername_ul' => 'Itemización',
	'smw_printername_table' => 'Tabla',
	'smw_printername_broadtable' => 'Tabla ancha',
	'smw_printername_template' => 'Plantilla',
	'smw_printername_rdf' => 'Exportar en RDF',
	'smw_printername_category' => 'Categoría',
	'validator-type-class-SMWParamSource' => 'texto',
	'smw-paramdesc-limit' => 'La cantidad máxima de resultados a devolver',
	'smw-paramdesc-offset' => 'El desplazamiento del primer resultado',
	'smw-paramdesc-headers' => 'Muestra los nombres de encabezados/propiedades',
	'smw-paramdesc-mainlabel' => 'La etiqueta a asignar al nombre de la página principal',
	'smw-paramdesc-link' => 'Mostrar los valores como vínculos',
	'smw-paramdesc-intro' => 'El texto a mostrar antes de los resultados de la consulta, si los hubiere',
	'smw-paramdesc-outro' => 'El texto a mostrar después de los resultados de la consulta, si los hubiere',
	'smw-paramdesc-default' => 'El texto a mostrar si no hay resultados de consulta',
	'smw-paramdesc-sep' => 'El separador para los valores',
	'smw-paramdesc-showsep' => 'Mostrar separador al comienzo del archivo CSV ("sep=<value>")',
	'smw-paramdesc-distribution' => 'En vez de mostrar todos los valores, contar sus ocurrencias y mostrarlas.',
	'smw-paramdesc-distributionsort' => 'Ordenar la distribución de valores por número de ocurrencias.',
	'smw-paramdesc-distributionlimit' => 'Limitar la distribución de valores al recuento de algunos valores solamente.',
	'smw-paramdesc-template' => 'El nombre de la plantilla con la que se mostrará la vista de impresión',
	'smw-paramdesc-columns' => 'El número de columnas donde se muestran los resultados (el predeterminado es $1)',
	'smw-paramdesc-userparam' => 'Un valor pasado en cada llamada de plantilla,si una plantilla es usada',
	'smw-paramdesc-introtemplate' => 'El nombre de una plantilla a mostrar antes de los resultados de la consulta, si hay alguna',
	'smw-paramdesc-outrotemplate' => 'El nombre de una plantilla a mostrar después de los resultados de la consulta, si hay alguna',
	'smw-paramdesc-embedformat' => 'La etiqueta HTML usada para definir encabezados',
	'smw-paramdesc-embedonly' => 'No mostrar encabezados',
	'smw-paramdesc-table-class' => 'Una clase CSS adicional a establecer para la tabla',
	'smw-paramdesc-rdfsyntax' => 'La sintaxis de RDF a usar',
	'smw-paramdesc-csv-sep' => 'El separador a usar',
	'smw-paramdesc-dsv-separator' => 'El separador a usar',
	'smw-paramdesc-dsv-filename' => 'El nombre para el archivo DSV',
	'smw-smwdoc-description' => 'Muestra una tabla de todos los parámetros que se pueden usar para un formato de resultados especificado junto a los valores por defecto y las descripciones.',
	'smw-smwdoc-par-format' => 'El formato de resultados en el que mostrar la documentación de un parámetro.',
	'smw-smwdoc-par-parameters' => 'Los parámetros que mostrar. "specific" para los añadidos por el formato, "base" para los disponibles en todos los formatos, y "all" para ambos.',
	'smw-paramdesc-sort' => 'Propiedad a partir de la que ordenar la petición',
	'smw-paramdesc-order' => 'Orden de ordenación de la consulta',
	'smw-paramdesc-searchlabel' => 'Texto para continuar la búsqueda',
	'smw-paramdesc-named_args' => 'Nombre los argumentos que se pasan a la plantilla',
	'smw-paramdesc-export' => 'Opción de exportación',
	'smw-paramdesc-prettyprint' => 'Una salida con formato agradable que muestra sangrías y saltos de línea adicionales',
	'smw-paramdesc-source' => 'Fuente de consulta alternativa',
	'smw-paramdesc-jsonsyntax' => 'Sintaxis JSON a utilizar',
	'smw-printername-feed' => 'Fuente web (feed) RSS o Atom',
	'smw-paramdesc-feedtype' => 'Tipo de fuente de noticias',
	'smw-paramdesc-feedtitle' => 'Texto a ser usado como título de la fuente web o canal',
	'smw-paramdesc-feeddescription' => 'Texto que se utilizará como descripción de la fuente web o canal (feed)',
	'smw-paramdesc-feedpagecontent' => 'Contenido de página que se mostrará con la fuente de noticias (feed)',
	'smw-label-feed-description' => 'Fuente de noticias $1 $2',
	'smw_iq_disabled' => 'Lo sentimos. Las búsquedas en los artículos de este wiki no están autorizadas.',
	'smw_iq_moreresults' => '&hellip; siguientes resultados',
	'smw_parseerror' => 'El valor dado no fue entendido.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" no puede ser usada como nombre de página en este wiki.',
	'smw_noproperty' => '"$1" no puede ser usado como nombre de página en este wiki.',
	'smw_wrong_namespace' => 'Solamente paginas en espacio de nombre "$1" estan permitidas aqui.',
	'smw_manytypes' => 'Demasiados tipos de datos han sido asignados al atributo.',
	'smw_emptystring' => 'No se aceptan cadenas vacías.',
	'smw_maxstring' => 'La representación de la cadena $1 es demasiado grande.',
	'smw_notinenum' => '"$1" no esta en la lista de posibles valores ($2) para este atributo.',
	'smw_noboolean' => '"$1" no es reconocido como un valor booleano (verdadero/falso).',
	'smw_true_words' => 'verdadero,t,si,s,true',
	'smw_false_words' => 'falso,f,no,n,false',
	'smw_nofloat' => '"$1" no es un número.',
	'smw_infinite' => 'números tan largos como $1 no son soportados.',
	'smw_unitnotallowed' => '"$1" no está declarada como una unidad de medida válida para esta propiedad.',
	'smw_nounitsdeclared' => 'No hyi unidades de medida declaradas para esta propiedad.',
	'smw_novalues' => 'No se ha especificado valores.',
	'smw_nodatetime' => 'La fecha «$1» no ha sido comprendida.',
	'smw_toomanyclosing' => 'Parece haber demasiadas coincidencias de "$1" en la solicitud.',
	'smw_noclosingbrackets' => 'Algún uso de "<nowiki>[[</nowiki>" en su consulta no está cerrado por "]]" coincidentes.',
	'smw_misplacedsymbol' => 'El símbolo "$1" se ha usado en un lugar donde no es de utilidad.',
	'smw_unexpectedpart' => 'La parte "$1" de la consulta no fue entendida.
Los resultados podrían no ser como esperabas.',
	'smw_emptysubquery' => 'Alguna subconsulta no tiene condición válida.',
	'smw_misplacedsubquery' => 'Alguna subconsulta fue usada en un lugar donde las subconsultas no están permitidas.',
	'smw_valuesubquery' => 'Subconsultas no soportadas para valores de propiedad "$1".',
	'smw_badqueryatom' => 'Alguna parte "<nowiki>[[…]]</nowiki>" de la interrogante no fue entendida.',
	'smw_propvalueproblem' => 'El valor de propiedad "$1" no fue entendida.',
	'smw_noqueryfeature' => 'Alguna característica de la consulta no tiene soporte en esta wiki, y parte de ella se ha eliminado ($1).',
	'smw_noconjunctions' => 'Las conjunciones no tienen soporte en esta wiki: parte de la consulta se ha eliminado ($1).',
	'smw_nodisjunctions' => 'Las disjunciones en consultas no tienen soporte en esta wiki: parte de la consulta se ha eliminado ($1).',
	'smw_querytoolarge' => 'Las siguientes condiciones de consulta no podrían ser consideradas debido a las restricciones de los wikia en tamaño o profundidad de consultas: $1.',
	'smw_notemplategiven' => 'Proveer un valor para el parámetro "plantilla" para este formato de consulta para funcionar.',
	'smw_db_sparqlqueryproblem' => 'No se pudieron obtener los resultados de la consulta de la base de datos SPARQL. Este error puede ser temporal o indicar un error en el programa de la base de datos.',
	'smw_db_sparqlqueryincomplete' => 'Resultó demasiado difícil responder la consulta y fue abandonada. Es probable que falten algunos resultados. Si fuese posible, intente hacer una consulta más sencilla.',
	'smw_type_header' => 'Atributos de tipo “$1”',
	'smw_typearticlecount' => 'Mostrando {{PLURAL:$1|un atributo|$1 atributos}} usando este tipo.',
	'smw_attribute_header' => 'Paginas usando el atributo “$1”',
	'smw_attributearticlecount' => 'Mostrando {{PLURAL:$1|una página|$1 páginas}} que {{PLURAL:$1|usa|usan}} esta propiedad.',
	'smw_subproperty_header' => 'Subpropiedades',
	'smw_subpropertyarticlecount' => 'Esta propiedad tiene las siguientes $1 {{PLURAL:$1|subpropiedad|subpropiedades}}:',
	'smw_concept_header' => 'Páginas de concepto "$1"',
	'smw_conceptarticlecount' => 'Mostrando $1 {{PLURAL:$1|página|páginas}} pertenecientes al concepto.',
	'exportrdf' => 'Exportar el artículo como RDF',
	'smw_exportrdf_docu' => ' En esta página, las partes de contenido de un artículo pueden ser exportadas a formato RDF. Introduzca el nombre de las páginas deseadas en el cuadro de texto que se encuentra debajo, <i>un nombre por línea </i>.<p/>',
	'smw_exportrdf_recursive' => 'Exportar igualmente todas las páginas pertinentes de forma recurrente. Esta posibilidad puede conseguir un gran número de resultados !',
	'smw_exportrdf_backlinks' => 'Exportar igualmente todas las páginas que reenvían a páginas exportadas. Resulta un RDF en el que se facilita la navegación.',
	'smw_exportrdf_lastdate' => 'No exportar páginas que no fueron cambiadas desde el punto dado en el tiempo.',
	'smw_exportrdf_submit' => 'Exportar',
	'uriresolver' => 'Traductor de URI',
	'properties' => 'Propiedades',
	'smw_properties_docu' => 'Las siguientes propiedades son usadas en el Wiki.',
	'smw_property_template' => '"$1" de tipo "$2" ($3 {{PLURAL:$3|uso|usos}})',
	'smw_propertylackspage' => 'Todas las propiedades deberían ser descritas por una página!',
	'smw_propertylackstype' => 'Ningún tipo fue especificada para esta propiedad (asumiendo tipo $1 por ahora).',
	'smw_propertyhardlyused' => 'Esta propiedad es dificilmente usada dentro del wiki!',
	'unusedproperties' => 'Propiedades no usadas',
	'smw_unusedproperties_docu' => 'Las siguientes propiedades existen a pesar que ninguna otra página haga uso de ellas.',
	'smw_unusedproperty_template' => '$1 de tipo $2',
	'wantedproperties' => 'Propiedades no usadas',
	'smw_wantedproperties_docu' => 'Las siguientes propiedades son usadas en el wiki pero no tienen aún una página para describirlas.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'smw_purge' => 'Actualizar',
	'types' => 'Tipos de datos',
	'smw_types_docu' => 'Lo siguiente es una lista de todos los tipos de datos que pueden ser asignados a las propiedades.',
	'semanticstatistics' => 'Estadísticas de semántica',
	'smw_semstats_text' => "Esta wiki contiene '''$1''' {{PLURAL:$1|valor de propiedad|valores de propiedades}} sobre un total de '''$2''' [[Special:Properties|{{PLURAL:$2|propiedad|propiedades diferentes}}]].
'''$3''' {{PLURAL:$3|propiedad tiene|propiedades tienen}} su propia página, y el tipo de datos previstos se ha especificado para '''$4''' de ellas.
Algunas de las propiedades existentes pueden estar [[Special:UnusedProperties|sin uso]].
Las propiedades faltantes pueden encontrarse en la [[Special:WantedProperties|lista de propiedades requeridas]].",
	'smw_uri_doc' => 'El traductor de URI implementa <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Esto se preocupa de cosas que los humanos no lo hacen en los sitios web..',
	'ask' => 'Búsqueda semántica',
	'smw_ask_sortby' => 'Ordenar por columna',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Buscar resultados',
	'smw_ask_editquery' => '[Editar consulta]',
	'smw_add_sortcondition' => '[Agregar condición de orden]',
	'smw_ask_hidequery' => 'Ocultar pregunta',
	'smw_ask_help' => 'Consultando ayuda',
	'smw_ask_queryhead' => 'consulta',
	'smw_ask_printhead' => 'Datos adicionales a mostrar',
	'smw_ask_printdesc' => '(añade un nombre de propiedad por línea)',
	'smw_ask_format_as' => 'Formatear como:',
	'smw_ask_defaultformat' => 'por defecto',
	'smw_ask_otheroptions' => 'Otras opciones',
	'smw-ask-otheroptions-info' => 'Esta sección contiene opciones que alteran los formatos de impresión. Las descripciones de dichas opciones pueden verse pasando el ratón sobre ellas.',
	'smw-ask-otheroptions-collapsed-info' => 'Por favor, utiliza el icono en forma de signo más para ver todas las opciones disponibles',
	'smw_ask_show_embed' => 'Mostrar código embebido',
	'smw_ask_hide_embed' => 'Ocultar código embebido',
	'smw_ask_embed_instr' => 'Para incluír esta consulta en línea dentro de una wiki use el código siguiente:',
	'smw-ask-delete' => '[Eliminar]',
	'smw-ask-sorting' => 'Clasificación',
	'smw-ask-format-selection-help' => 'Para una descripción detallada, visita la página de ayuda $1.',
	'querycreator' => 'Creador de consultas',
	'smw_qc_addmainlabel' => 'Añadir la etiqueta principal',
	'smw_qc_show_addnal_opts' => 'Mostrar más opciones',
	'smw_qc_hide_addnal_opts' => 'Mostrar menos opciones',
	'smw_qc_otheropt' => 'Otras opciones',
	'smw_qc_intro' => 'Introducción:',
	'smw_qc_outro' => 'Parte final (outro):',
	'smw_qc_default' => 'Por defecto:',
	'smw_qc_formatopt' => 'Opciones de formato',
	'smw_qc_query_help' => 'Introduce una consulta utilizando el siguiente formulario. Selecciona páginas wiki basadas en
Categorías (<strong><nowiki>por ej. [[Category:Actor]]</nowiki></strong>),
Propiedades (<strong><nowiki>por ej. [[Localizado en::Alemania]]</nowiki></strong>),
Nombres (<strong><nowiki>por ej. [[Alemania]]</nowiki></strong>) y Espacios de nombres (<strong><nowiki>por ej. [[Help:+]]</nowiki></strong>)',
	'smw_qui_property' => '<strong>Propiedad</strong>',
	'smw_qui_prop' => 'Propiedad:',
	'smw_qui_labl' => 'Etiqueta:',
	'smw_qui_formt' => 'Formato:',
	'smw_qui_limt' => 'Límite:',
	'smw_qui_shownresults' => 'mostrar en los resultados',
	'smw_qui_noquery' => 'No se ha especificado ninguna consulta',
	'smw_qui_invalidprop' => '"$1" puede ​​no ser una propiedad válida',
	'smw_qui_invalidformat' => 'El formato escogido, "$1", no existe en este wiki',
	'smw_qui_nosort' => 'Sin ordenación',
	'smw_qui_ascorder' => 'Ascendente',
	'smw_qui_descorder' => 'Descendente',
	'smw_qui_randorder' => 'Aleatorio',
	'smw_qui_addnprop' => 'añadir propiedad',
	'smw_qui_delete' => 'Eliminar',
	'smw_qui_rescol' => 'Coincidencias',
	'smw_qui_options' => 'opciones',
	'smw_qui_addcategory' => 'añadir categoría',
	'smw_qui_addrescol' => 'añadir coincidencias',
	'smw_qui_ok' => 'Aceptar',
	'smw_qui_cancel' => 'Cancelar',
	'smw_qui_category' => '<strong>Categoría</strong>',
	'smw_qui_label' => 'Etiqueta',
	'smw_prp_options' => 'Opciones de la propiedad',
	'smw_qui_catopts' => 'Opciones de categoría',
	'smw_qui_mainlabopts' => 'Opciones de los resultados',
	'smw_qui_dlabel' => 'Etiqueta:',
	'smw_qui_dcategory' => 'Categoría:',
	'smw_qui_dcatyes' => 'Mostrar el texto cuando la categoría esté presente:',
	'smw_qui_dcatno' => 'Mostrar el texto cuando la categoría esté ausente:',
	'searchbyproperty' => 'Buscar por atributo',
	'smw_sbv_docu' => 'Buscar por todas las páginas que tiene un atributo y valor dado.',
	'smw_sbv_novalue' => 'Por favor introduzca un valor, o ver todos los valores de atributo para $1.',
	'smw_sbv_displayresult' => 'Una lista de todas las páginas que tienen un atributo $1 con el valor $2.',
	'smw_sbv_displayresultfuzzy' => 'Lista de todas las páginas que tienen la propiedad "$1" con valor "$2".
En el caso de existir muy pocos resultados, se muestran también los valores aproximados.',
	'smw_sbv_property' => 'Propiedad:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Buscar resultados',
	'browse' => 'Explorar artículos',
	'smw_browselink' => 'Explorar propiedades',
	'smw_browse_article' => 'Introduzca el nombre de la página para empezar a explorar.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'mostrar propiedades que vinculen aquí',
	'smw_browse_hide_incoming' => 'ocultar propiedades que vinculen aquí',
	'smw_browse_no_outgoing' => 'Esta página no tiene propiedades.',
	'smw_browse_no_incoming' => 'Ninguna propiedad vincula aquí.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiqueta de propiedad inversa',
	'pageproperty' => 'Página de búsqueda de propiedades',
	'smw_pp_docu' => 'Busca todos los valores de una propiedad en una determinada página.
Ingrese la página y la propiedad.',
	'smw_pp_from' => 'De página',
	'smw_pp_type' => 'Propiedad',
	'smw_pp_submit' => 'Encontrar resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Siguiente',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Lo siento, no hay resultados.',
	'smwadmin' => 'Funciones de administración para Semantic Mediawiki',
	'smw_smwadmin_setupsuccess' => 'El motor de almacenamiento fue configurado con éxito.',
	'smw_smwadmin_return' => 'Regresar a $1',
	'smw_smwadmin_updatestarted' => 'Se ha iniciado un nuevo proceso de actualización para volver a cargar los datos semánticos.
Todos los datos almacenados serán reconstruidos o reparados donde sea necesario.
Puedes hacer un seguimiento del progreso de la actualización en esta página especial.

Volver a $1.',
	'smw_smwadmin_updatenotstarted' => 'Ya hay un proceso de actualización ejecutándose.
No crear otro más.

Volver a $1.',
	'smw_smwadmin_updatestopped' => 'Todos los procesos de actualización existentes han sido detenidos.

Volver a $1.',
	'smw_smwadmin_updatenotstopped' => 'Para detener el proceso de actualización en ejecución, debes activar la tabla de verificación para indicar que estás realmente seguro.

Volver a $1.',
	'smw_smwadmin_docu' => 'Esta página especial te ayudará durante la instalación y actualización de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Recuerda respaldar cualquier información importante antes de ejecutar funciones administrativas.',
	'smw_smwadmin_db' => 'Instalación de la base de datos y actualización',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki necesita algunas extensiones en la base de datos de MediaWiki para poder almacenar la información semántica.
La función indicada abajo asegura que tu base de datos está configurada correctamente.
Los cambios realizados en este paso no afectan el resto de la base de datos de MediaWiki y pueden ser revertidos fácilmente si así se desea.
Esta función de configuración puede ejecutarse varias veces sin hacer ningún daño, pero es necesaria sólo una vez para la instalación o actualización.',
	'smw_smwadmin_permissionswarn' => 'Si la operación falla con errores SQL, la base de datos de usuarios empleada por su wiki (revise su archivo LocalSettings.php) probablemente no tiene permisos suficientes.
Ud puede conceder a este usuario permisos adicionales para crear y borrar tablas, ingresando temporalmente la clave de acceso de su base de datos raíz en LocalSettings.php, o bien usar el script de mantenimiento <tt>SMW_setup.php</tt>, que puede usar las credenciales de un administrador.',
	'smw_smwadmin_dbbutton' => 'Inicializar o actualizar tablas',
	'smw_smwadmin_announce' => 'Anunciar tu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki cuenta con un servicio Web para anunciar nuevos sitios wiki semánticos, que es usado para mantener un listado de sitios Web públicos que usan Semantic MediaWiki, principalmente para ayudar al <a href="http://semantic-mediawiki.org/wiki/SMW_Project">proyecto Semantic MediaWiki</a>, para tener una visión general de los usos típicos de Semantic MediaWiki.
See the Semantic MediaWiki homepage for <a href="http://semantic-mediawiki.org/wiki/Registry">further information about this service</a>.',
	'smw_smwadmin_announcebutton' => 'Presione el botón siguiente para enviar la URL de su wiki al servicio.
El servicio no registrará wikis que no sean de acceso público, y solamente guardará información públicamente accesible.',
	'smw_smwadmin_datarefresh' => 'Reparación de datos y actualización',
	'smw_smwadmin_datarefreshdocu' => 'Es posible restaurar toda la información de MediaWiki Semántica basándose en los contenidos actuales de la wiki.
Esto puede ser útil para reparar la información destruida o para volver a cargar la información si el formato interno ha cambiado a causa de alguna actualización de software.
La actualización se ejecuta página a página y no se completará de inmediato.
Lo siguiente muestra es hay una actualización en progreso y le permite iniciar o detener actualizaciones (a menos que esta característica haya sido inhabilitada por el administrador del sitio).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Actualización en progreso.</strong>
Es normal que el proceso de actualización se retrase ya que sólo actualiza datos en porciones pequeñas cada vez que un usuario ingresa a la wiki.
Para finalizar esta actualización en forma mas rápida, Ud. puede invocar el script de matenimiento MediaWiki <tt>runJobs.php</tt> (use la opción <tt>--maxjobs 1000</tt>  para restringir el número de actualizaciones hechas en cada paquete).
Progeso estimado de la actualización:',
	'smw_smwadmin_datarefreshbutton' => 'Comenzar actualización de datos',
	'smw_smwadmin_datarefreshstop' => 'Detener esta actualización',
	'smw_smwadmin_datarefreshstopconfirm' => 'Sí, estoy seguro.',
	'smw_smwadmin_support' => 'Obteniendo ayuda',
	'smw_smwadmin_supportdocu' => 'Varios recursos podrían ayudarlo en caso de problemas:',
	'smw_smwadmin_installfile' => 'Si experimentas problemas con tu instalación, comienza revisando las líneas guía en el <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">archivo de INSTALACION</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentación de usuario completa a Semantic MediaWiki está en <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Los defectos pueden ser reportados a <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Si tienes preguntas o sugerencias adicionales, únete a la discusión en <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Foro de usuarios de Semantic MediaWiki
</a>.',
	'smw_adminlinks_datastructure' => 'Estructura de datos',
	'smw_adminlinks_displayingdata' => 'Mostrando datos',
	'smw_adminlinks_inlinequerieshelp' => 'Ayuda de consultas en línea',
	'smw-createproperty-isproperty' => 'Esta es una propiedad de tipo $1.',
	'smw-createproperty-allowedvals' => 'Los {{PLURAL:$1|valor permitido para esta propiedad es|valores permitidos para esta propiedad son}}:',
	'smw-paramdesc-category-delim' => 'El delimitador',
	'smw-paramdesc-category-template' => 'Una plantilla con la que dar formato a los elementos',
	'smw-paramdesc-category-userparam' => 'Un parámetro que pasar a la plantilla',
	'smw-info-par-message' => 'Mensaje a mostrar',
	'smw-info-par-icon' => 'Icono a mostrar; ya sea "información" o bien "aviso".',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Opciones de búsqueda semántica',
	'smw-prefs-intro-text' => 'Las opciones mostradas a continuación se suministran por [http://semantic-mediawiki.org/ Semantic MediaWiki] (o sus extensiones relacionadas) para permitir personalización individual de las funciones seleccionadas. Para más información, mira [http://semantic-mediawiki.org/wiki/Help:User_preferences esta página de ayuda].',
	'smw-prefs-ask-options-tooltip-display' => 'Mostrar el texto del parámetro como ayuda informativa',
	'smw-prefs-ask-options-collapsed-default' => 'Activar la contracción de la caja de opciones por defecto',
	'smw-ui-tooltip-title-property' => 'Propiedad',
	'smw-ui-tooltip-title-quantity' => 'Cantidad',
	'smw-ui-tooltip-title-info' => 'información',
	'smw-ui-tooltip-title-service' => 'Enlaces de servivio',
	'smw-ui-tooltip-title-warning' => 'Error',
	'smw-ui-tooltip-title-parameter' => 'Parámetro',
	'smw-ui-tooltip-title-event' => 'Evento',
	'smw_unknowntype' => 'El tipo de esta propiedad no es válido',
);

/** Estonian (eesti)
 * @author Avjoska
 */
$messages['et'] = array(
	'smw_printername_table' => 'Tabel',
	'smw_purge' => 'Värskenda',
	'smw_qui_addcategory' => 'lisa kategooria',
	'smw_qui_dcategory' => 'Kategooria:',
	'smw_result_prev' => 'Eelmine',
	'smw_result_next' => 'Järgmine',
);

/** Basque (euskara)
 * @author An13sa
 * @author Kobazulo
 * @author පසිඳු කාවින්ද
 */
$messages['eu'] = array(
	'smw_viewasrdf' => 'RDF jarioa',
	'smw_finallistconjunct' => ', eta',
	'smw_true_words' => 'egia,e,bai,b',
	'smw_false_words' => 'gezurra,g,ez,e',
	'smw_nofloat' => '"$1" ez da zenbakia.',
	'smw_subproperty_header' => 'Azpipropietateak',
	'properties' => 'Propietateak',
	'unusedproperties' => 'Erabili gabeko propietateak',
	'wantedproperties' => 'Eskatutako propietateak',
	'smw_purge' => 'Eguneratu',
	'types' => 'Motak',
	'smw_ask_sortby' => 'Zutabeka sailkatu (hautazkoa)',
	'smw_ask_ascorder' => 'Gorantz',
	'smw_ask_descorder' => 'Beherantz',
	'smw_ask_submit' => 'Emaitzak bilatu',
	'smw_qui_formt' => 'Formatua:',
	'smw_qui_limt' => 'Muga:',
	'smw_qui_randorder' => 'Ausazkoa',
	'smw_qui_delete' => 'Kendu',
	'smw_qui_cancel' => 'Utzi',
	'smw_qui_dcategory' => 'Kategoria:',
	'searchbyproperty' => 'Propietateen arabera bilatu',
	'smw_sbv_property' => 'Propietatea:',
	'smw_sbv_value' => 'Balioa:',
	'smw_sbv_submit' => 'Emaitzak bilatu',
	'smw_browse_go' => 'Joan',
	'smw_pp_type' => 'Propietatea',
	'smw_pp_submit' => 'Emaitzak bilatu',
	'smw_result_prev' => 'Aurrekoa',
	'smw_result_next' => 'Hurrengoa',
	'smw_result_results' => 'Emaitzak',
	'smw_result_noresults' => 'Ez dago emaitzarik.',
	'smw_smwadmin_return' => '$1-(e)ra itzuli',
	'smw_smwadmin_datarefreshstopconfirm' => 'Bai, ziur nago.',
);

/** Persian (فارسی)
 * @author Huji
 * @author Mjbmr
 * @author Momeni
 * @author ZxxZxxZ
 */
$messages['fa'] = array(
	'smw_viewasrdf' => 'خوراک RDF',
	'smw_finallistconjunct' => '، و',
	'smw_isspecprop' => 'این خصوصیت یک خصوصیت ویژه در این ویکی است.',
	'smw_concept_description' => 'توصیف مفهوم "$1"',
	'smw_no_concept_namespace' => 'مفاهیم فقط می‌توانند در صفحه‌های داخل فضای نام مفهوم: تعریف شوند.',
	'smw_multiple_concepts' => 'هر صفحه مفهوم فقط می‌تواند شامل یک تعریف مفهوم باشد.',
	'smw_concept_cache_miss' => 'مفهوم "$1" نمی‌تواند در حال حاضر استفاده شود، زیرا تنظیمات ویکی نیاز به محاسبه آن به‌صورت برون‌خط دارد.
اگر این مشکل پس از مدتی از بین نرفت، از مدیر سایت بخواهید تا این مفهوم را در دسترس قرار دهد.',
	'smw_printername_json' => 'برون‌بری در قالب JSON',
	'smw_printername_table' => 'جدول',
	'smw_printername_rdf' => 'برون‌بری در قالب RDF',
	'smw_printername_category' => 'رده',
	'smw_subproperty_header' => 'زیرخصوصیت‌ها',
	'smw_concept_header' => 'صفحه‌های مفهوم "$1"',
	'exportrdf' => 'برون‌بری صفحه‌ها به آردی‌اف',
	'smw_exportrdf_recursive' => 'تمام صفحه‌های مرتبط را به صورت بازگشتی برون‌بری کن.
توجه کنید که نتیجه می‌تواند بزرگ شود!',
	'smw_exportrdf_backlinks' => 'همچنین تمام صفحه‌هایی را که به صفحه‌های برون‌بری شده ارجاع دارند، برون‌بری کن.
آردی‌اف قابل مرور تولید می‌کند.',
	'smw_exportrdf_lastdate' => 'صفحه‌هایی را که از زمان داده شده تغییری نکرده‌اند، برون‌بری نکن.',
	'properties' => 'ویژگی‌ها',
	'smw_properties_docu' => 'خصوصیت‌های زیر در این ویکی استفاده شده‌اند.',
	'smw_property_template' => '$1 از نوع $2 ($3)',
	'smw_propertylackspage' => 'تمام خصوصیت‌ها باید توسط یک صفحه توصیف شوند.',
	'smw_propertylackstype' => 'هیچ نوعی برای این خصوصیت مشخص نشده است (با فرض نوع $1 برای اکنون).',
	'smw_propertyhardlyused' => 'این خصوصیت به ندرت در این ویکی استفاده شده است.',
	'unusedproperties' => 'خصوصیت‌های استفاده نشده',
	'smw_unusedproperties_docu' => 'خصوصیت‌های زیر با وجود این‌که هیچ صفحه‌ای از آن‌ها استفاده نمی‌کند، وجود دارند.',
	'smw_unusedproperty_template' => '$1 از نوع $2',
	'wantedproperties' => 'خصوصیت‌های خواسته شده',
	'smw_wantedproperties_docu' => 'خصوصیت‌های زیر در این ویکی استفاده شده‌اند ولی هنوز صفحه‌ای برای توصیف آن‌ها وجود ندارد.',
	'smw_wantedproperty_template' => '$1 ($2 استفاده شده)', # Fuzzy
	'smw_purge' => 'بازخوانی',
	'types' => 'نوع‌ها',
	'smw_types_docu' => 'در ذیل لیستی از تمام نوع‌داده‌هایی که می‌تواند به خصوصیت‌ها انتصاب شود، آمده است.
هر نوع‌داده یک صفحه دارد که اطلاعات اضافه می‌تواند در آن فراهم آورده شود.', # Fuzzy
	'semanticstatistics' => 'آمار معنایی',
	'ask' => 'جستجوی معنایی',
	'smw_ask_sortby' => 'مرتب‌سازی با ستون (اختیاری)',
	'smw_ask_ascorder' => 'صعودی',
	'smw_ask_descorder' => 'نزولی',
	'smw_ask_submit' => 'نتایج را جستجو کن',
	'smw_ask_editquery' => '[ویرایش پرس‌وجو]',
	'smw_add_sortcondition' => '[افزودن شرایط مرتب‌سازی]',
	'smw_ask_hidequery' => 'مخفی‌کردن پرس‌و‌جو',
	'smw_ask_help' => 'پرس‌و‌جو از راهنما',
	'smw_qui_options' => 'گزینه‌ها',
	'smw_qui_ok' => 'تأیید',
	'smw_qui_cancel' => 'لغو',
	'smw_qui_dlabel' => 'برچسب:',
	'smw_qui_dcategory' => 'رده:',
	'searchbyproperty' => 'جستجو بر اساس ویژگی',
	'browse' => 'مرور ویکی',
	'smw_browselink' => 'مرور خصوصیات',
	'smw_browse_article' => 'نام صفحه‌ای را که می‌خواهید مرور کردن را از آن شروع کنید، وارد کنید.',
	'smw_browse_go' => 'برو',
	'smw_browse_show_incoming' => 'خصوصیاتی که به اینجا پیوند دارند، نمایش بده',
	'smw_browse_hide_incoming' => 'خصوصیاتی که به اینجا پیوند دارند مخفی کن',
	'smw_browse_no_outgoing' => 'این صفحه هیچ خصوصیاتی ندارد',
	'smw_browse_no_incoming' => 'هیچ خصوصیتی به این صفحه پیوند ندارد',
	'smw_inverse_label_default' => '$1 از',
	'smw_inverse_label_property' => 'برچسب خصوصیت برعکس',
	'pageproperty' => 'جستجوی خصوصیت صفحه',
	'smwadmin' => 'عملکردهای مدیریتی برای مدیاویکی معنایی',
	'smw_adminlinks_datastructure' => 'ساختار داده‌ها',
	'smw_adminlinks_displayingdata' => 'نمایش داده‌ها',
	'smw-createproperty-isproperty' => 'این یک ویژگی از نوع $1 است.',
	'smw-createproperty-allowedvals' => 'مقادیر مجاز برای این ویژگی یا صفت این‌ها هستند:', # Fuzzy
);

/** Finnish (suomi)
 * @author Beluga
 * @author Cimon Avaro
 * @author Crt
 * @author Nedergard
 * @author Nike
 * @author Silvonen
 * @author Str4nd
 */
$messages['fi'] = array(
	'smw-desc' => 'Lisää wikisi helppokäyttöisyyttä - niin koneille "kuin" ihmisillekin ([http://semantic-mediawiki.org/wiki/Help:User_manual käyttäjän opas])',
	'smw_viewasrdf' => 'RDF-syöte',
	'smw_finallistconjunct' => ' ja',
	'smw_factbox_head' => 'Tietoja kohteesta $1',
	'smw_isspecprop' => 'Tämä on erikoisominaisuus.',
	'smw_concept_description' => 'Käsitteen ”$1” kuvaus',
	'smw_no_concept_namespace' => 'Konseptit voidaan määritellä vain Konsepit: -nimiavaruuden sivuilla.',
	'smw_multiple_concepts' => 'Kullakin käsitesivulla voi olla vain yksi käsitteen määritelmä.',
	'smw_noinvannot' => 'Arvoja ei voi kohdistaa käänteisiin ominaisuuksiin.',
	'version-semantic' => 'Semanttiset laajennukset',
	'smw_baduri' => '$1 ei ole sallittu URI:n muoto.',
	'smw_printername_count' => 'Laskennan tulokset',
	'smw_printername_csv' => 'CSV-vienti',
	'smw_printername_dsv' => 'DSV-vienti',
	'smw_printername_embedded' => 'Upota sivujen sisällöt',
	'smw_printername_json' => 'JSON-vienti',
	'smw_printername_list' => 'Luettelo',
	'smw_printername_ol' => 'Numerointi',
	'smw_printername_ul' => 'Kohteittainen esitys',
	'smw_printername_table' => 'Taulukko',
	'smw_printername_broadtable' => 'Leveä taulukko',
	'smw_printername_template' => 'Malline',
	'smw_printername_rdf' => 'RDF-vienti',
	'smw_printername_category' => 'Luokka',
	'validator-type-class-SMWParamSource' => 'teksti',
	'smw-paramdesc-limit' => 'Palautettavien tulosten enimmäismäärän',
	'smw-paramdesc-offset' => 'Ensimmäisen näytettävän osuman järjestysnumero',
	'smw-paramdesc-link' => 'Näytä arvot linkkeinä',
	'smw-paramdesc-intro' => 'Teksti, joka näytetään ennen kyselyn tuloksia, jos niitä on.',
	'smw-paramdesc-outro' => 'Teksti, joka näytetään kyselyn tulosten jälkeen, jos niitä on.',
	'smw-paramdesc-default' => 'Teksti, joka näytetään, jos kysely ei tuottanut tuloksia.',
	'smw-paramdesc-sep' => 'Arvojen erotin',
	'smw-paramdesc-showsep' => 'Näytä erotin CSV-tiedoston alussa ("sep=<arvo>")',
	'smw-paramdesc-template' => 'Tulosteiden näyttämisessä käytettävän mallineen nimi',
	'smw-paramdesc-columns' => 'Tulosnäkymän sarakkeiden lukumäärä (oeltusarvo on $1)',
	'smw-paramdesc-userparam' => 'Arvo, joka välitetään jokaisessa mallinekutsussa, jos mallinetta käytetään',
	'smw-paramdesc-introtemplate' => 'Ennen kyselytuloksia näytettävän mallineen nimi, jos tuloksia löytyi.',
	'smw-paramdesc-outrotemplate' => 'Kyselytulosten jälkeen näytettävän mallineen nimi, jos tuloksia löytyi.',
	'smw-paramdesc-rdfsyntax' => 'Käytettävä RDF-syntaksi',
	'smw-paramdesc-csv-sep' => 'Käytettävä erotin',
	'smw-paramdesc-dsv-separator' => 'Käytettävä erotin',
	'smw-paramdesc-dsv-filename' => 'DSV-tiedoston nimi',
	'smw-paramdesc-sort' => 'Ominaisuus, jonka mukaan kysely lajitellaan.',
	'smw-paramdesc-searchlabel' => 'Haun jatkamisesta kertova teksti',
	'smw-paramdesc-source' => 'Vaihtoehtoinen kyselyn tietolähde',
	'smw-paramdesc-jsonsyntax' => 'Käytettävä JSON-syntaksi',
	'smw-printername-feed' => 'RSS- ja Atom-syöte',
	'smw-paramdesc-feedtype' => 'Syötteen tyyppi',
	'smw-paramdesc-feedtitle' => 'Syötteen otsikkoteksti',
	'smw-paramdesc-feeddescription' => 'Syötteen kuvausteksti',
	'smw-paramdesc-feedpagecontent' => 'Sivun sisältö, joka näytetään syötteessä',
	'smw-label-feed-description' => '$2-syöte $1',
	'smw_iq_disabled' => 'Semanttiset hakukyselyt on estetty tässä wikissä.',
	'smw_iq_moreresults' => '… lisää tuloksia',
	'smw_parseerror' => 'Tarjottua arvoa ei ymmärretty.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => 'Nimeä ”$1” ei voi käyttää sivun nimenä tässä wikissä.',
	'smw_noproperty' => 'Nimeä "$1" ei voi käyttää ominaisuuden nimenä tässä wikissä.',
	'smw_wrong_namespace' => 'Vain nimiavaruuden "$1" sivut sallitaan tässä.',
	'smw_manytypes' => 'Ominaisuudelle on määritelty useampi kuin yksi tyyppi.',
	'smw_emptystring' => 'Tyhjiä merkkijonoja ei hyväksytä.',
	'smw_maxstring' => 'Merkkijonon esitysmuoto $1 on liian pitkä.',
	'smw_notinenum' => '"$1" ei ole tämän ominaisuuden sallittujen arvojen luettelossa ($2).',
	'smw_noboolean' => '”$1” ei ole tunnistettavissa totuusarvoksi.',
	'smw_true_words' => 'kyllä,k,y',
	'smw_false_words' => 'ei,e,n',
	'smw_nofloat' => '”$1” ei ole luku.',
	'smw_infinite' => 'Numeron "$1" kokoisia arvoja ei tueta.',
	'smw_unitnotallowed' => '"$1" ei ole sallittu mittayksikkö tälle ominaisuudelle.',
	'smw_nounitsdeclared' => 'Tälle ominaisuudelle ei ole määritetty mittayksikköä.',
	'smw_novalues' => 'Arvoja ei ole määritetty.',
	'smw_nodatetime' => 'Päiväystä ”$1” ei tunnistettu.',
	'smw_toomanyclosing' => 'Hakukyselyssä tuntuisi olevan liian monta esiintymää "$1" termistä.',
	'smw_noclosingbrackets' => 'Joiltain kyselyn hakasuluilta "<nowiki>[[</nowiki>" puuttuu sulkevat hakasulut "]]".',
	'smw_misplacedsymbol' => 'Symbolia "$1" käytettiin yhteydessä johon se ei soveltunut.',
	'smw_unexpectedpart' => 'Kyselyn osaa "$1" ei voitu tulkita.
Tulokset eivät ehkä vastaa odotuksia.',
	'smw_emptysubquery' => 'Jollakin alikyselyllä ei ole kelvollista ehtoa.',
	'smw_misplacedsubquery' => 'Jotain alikyselyä käytettiin kohdassa, jossa alikysely ei ole sallittu.',
	'smw_valuesubquery' => 'Alikyselyjä ei käytetä ominaisuuden "$1" arvoille.',
	'smw_badqueryatom' => 'Kyselyn osaa "<nowiki>[[…]]</nowiki>" ei voitu tulkita.',
	'smw_propvalueproblem' => 'Ominaisuuden "$1" arvoa ei voitu tulkita.',
	'smw_noqueryfeature' => 'Joitain kyselyn ehtoja ei tueta tässä wikissä ja siksi osa kyselystä jäi tekemättä ($1).',
	'smw_noconjunctions' => 'Kyselyjen JA-toimituksia ei tueta tässä wikissä ja siksi osa kyselystä jäi tekemättä ($1).',
	'smw_nodisjunctions' => 'Kyselyjen TAI-toimituksia ei tueta tässä wikissä ja siksi osa kyselystä jäi tekemättä ($1).',
	'smw_querytoolarge' => 'Seuraavia kyselyehtoja ei voitu huomioida, koska wiki rajoittaa kyselyn kokoa tai syvyyttä: $1.',
	'smw_notemplategiven' => 'Parametri "template" on pakollinen, jotta tämä kyselymuoto toimisi.',
	'smw_db_sparqlqueryproblem' => 'Kyselyn tulosta ei voitu noutaa SPARQL-tietokannasta. Virhe voi olla väliaikainen tai osoitus tietokannan ohjelmistovirheestä.',
	'smw_db_sparqlqueryincomplete' => 'Kyselyyn vastaaminen osoittautui liian vaikeaksi ja kysely keskeytettiin. Jotkut tulokset voivat puuttua. Voit yrittää uudelleen yksinkertaisemmalla kyselyllä mikäli vain mahdollista.',
	'smw_type_header' => 'Tyypin $1 ominaisuudet',
	'smw_typearticlecount' => 'Näytetään $1 tätä tyyppiä {{PLURAL:$1|käyttävä ominaisuus|käyttävää ominaisuutta}}.',
	'smw_attribute_header' => 'Ominaisuutta ”$1” käyttävät sivut',
	'smw_attributearticlecount' => 'Näytetään $1 tätä ominaisuutta {{PLURAL:$1|käyttävä sivu|käyttävää sivua}}.',
	'smw_subproperty_header' => 'Alaominaisuudet',
	'smw_subpropertyarticlecount' => 'Tällä ominaisuudella on $1 {{PLURAL:$1|alaominaisuus|alaominaisuutta}}:',
	'smw_concept_header' => 'Konseptin "$1" sivut',
	'smw_conceptarticlecount' => 'Näytetään $1 {{PLURAL:$1|sivu, joka|sivua, jotka}} kuuluvat tähän konseptiin.',
	'exportrdf' => 'Vie sivut RDF:nä',
	'smw_exportrdf_docu' => 'Tämän sivun avulla voit noutaa sivun tiedot RDF-muodossa.
Syötä vietävien sivujen otsikot alla olevaan tekstiruutuun, yksi otsikko yhdellä rivillä.',
	'smw_exportrdf_recursive' => 'Tee vienti rekursiivisesti kaikista liittyvistä sivuista.
Huomioi, että tulos saattaa olla suuri.',
	'smw_exportrdf_backlinks' => 'Vie myös sivut, joilta viitataan vietäville sivuille.
Generoi selailtavan RDF:n.',
	'smw_exportrdf_lastdate' => 'Älä vie sivuja, jotka eivät ole muuttuneet määrätyn ajankohdan jälkeen.',
	'smw_exportrdf_submit' => 'Vie',
	'properties' => 'Ominaisuudet',
	'smw_properties_docu' => 'Wikissä käytetään seuraavia ominaisuuksia.',
	'smw_property_template' => '$1 on tyypiltään $2 ($3 {{PLURAL:$3|esiintymä|esiintymää}})',
	'smw_propertylackspage' => 'Jokaisella ominaisuudella pitäisi olla kuvaussivu.',
	'smw_propertylackstype' => 'Ominaisuuden tyyppiä ei ole määritelty (oletetaan tyypiksi $1).',
	'smw_propertyhardlyused' => 'Tätä ominaisuutta ei juurikaan käytetä.',
	'unusedproperties' => 'Käyttämättömät ominaisuudet',
	'smw_unusedproperties_docu' => 'Seuraavat ominaisuudet ovat olemassa, vaikka mikään muu sivu ei käytä niitä.',
	'smw_unusedproperty_template' => '$1 on tyypiltään $2',
	'wantedproperties' => 'Halutut ominaisuudet',
	'smw_wantedproperties_docu' => 'Seuraavia ominaisuuksia käytetään wikissä mutta niillä ei ole vielä kuvaussivua.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|esiintymä|esiintymää}})',
	'smw_purge' => 'Päivitä',
	'types' => 'Tyypit',
	'semanticstatistics' => 'Semanttiset tilastot',
	'ask' => 'Semanttinen haku',
	'smw_ask_sortby' => 'Järjestä sarakkeen mukaan (valinnainen)',
	'smw_ask_ascorder' => 'Nouseva',
	'smw_ask_descorder' => 'Laskeva',
	'smw_ask_submit' => 'Hae tuloksia',
	'smw_ask_editquery' => '[Muokkaa kyselyä]',
	'smw_add_sortcondition' => '[Lisää lajitteluehto]',
	'smw_ask_hidequery' => 'Piilota kysely',
	'smw_ask_help' => 'Hakukyselyn ohjeet',
	'smw_ask_queryhead' => 'Kysely',
	'smw_ask_printhead' => 'Valinnaiset näytettävät tiedot',
	'smw_ask_printdesc' => '(lisää yksi ominaisuuden nimi per rivi)',
	'smw_ask_format_as' => 'Muotoilu:',
	'smw_ask_defaultformat' => 'oletus',
	'smw_ask_otheroptions' => 'Muut valinnat',
	'smw-ask-otheroptions-info' => 'Tämän osion valinnat vaikuttavat tulostuslausekkeisiin. Parametrin kuvauksen saa näkyviin siirtämällä kohdistin nimen kohdalle.',
	'smw-ask-otheroptions-collapsed-info' => 'Katso kaikki vaihtoehot plus-kuvakkeen avulla.',
	'smw_ask_show_embed' => 'Näytä upotettava koodi',
	'smw_ask_hide_embed' => 'Piilota upotettava koodi',
	'smw_ask_embed_instr' => 'Jos haluat lisätä tämän kyselyn wikisivulle, käytä allaolevaa koodia.',
	'smw-ask-delete' => '[Poista]',
	'smw-ask-sorting' => 'Lajittelu',
	'smw-ask-format-selection-help' => 'Yksityiskohtaiset tiedot löytyvät $1 -ohjesivulta',
	'querycreator' => 'Kyselyjen luontityökalu',
	'smw_qc_addmainlabel' => 'Lisää pääotsikko',
	'smw_qc_show_addnal_opts' => 'Näytä lisää valintoja',
	'smw_qc_hide_addnal_opts' => 'Piilota lisävalinnat',
	'smw_qc_otheropt' => 'Muut valinnat',
	'smw_qc_intro' => 'Alussa oleva teksti',
	'smw_qc_outro' => 'Lopussa oleva teksti',
	'smw_qc_default' => 'Oletus:',
	'smw_qc_formatopt' => 'Muotoiluasetukset',
	'smw_qc_query_help' => 'Voit luoda kyselyn alla olevan lomakkeen avulla. Voit valita wikisivuja luokkien (<strong><nowiki>esim. [[Luokka:Näyttelijä]]</nowiki></strong>), ominaisuuksien (<strong><nowiki>esim. [[Sijainti::Saksa]]</nowiki></strong>), nimien (<strong><nowiki>esim. [[Saksa]]</nowiki></strong>) ja nimiavaruuksien (<strong><nowiki>esim. [[Ohje:+]]</nowiki></strong>) perusteella.',
	'smw_qui_property' => '<strong>Ominaisuus</strong>',
	'smw_qui_prop' => 'Ominaisuus:',
	'smw_qui_labl' => 'Otsikko:',
	'smw_qui_formt' => 'Muoto:',
	'smw_qui_limt' => 'Rajoitus:',
	'smw_qui_shownresults' => 'näytä tuloksissa',
	'smw_qui_noquery' => 'Kyselyä ei ole määritelty',
	'smw_qui_invalidprop' => '"$1" ei välttämättä ole sallittu ominaisuus',
	'smw_qui_invalidformat' => 'Muotoiluvalintaa "$1" ei ole tässä wikissä',
	'smw_qui_nosort' => 'Ei lajittelua',
	'smw_qui_ascorder' => 'Nouseva',
	'smw_qui_descorder' => 'Laskeva',
	'smw_qui_randorder' => 'Satunnainen',
	'smw_qui_addnprop' => 'lisää ominaisuus',
	'smw_qui_delete' => 'Poista',
	'smw_qui_options' => 'valinnat',
	'smw_qui_addcategory' => 'lisää luokka',
	'smw_qui_ok' => 'Ok',
	'smw_qui_cancel' => 'Peruuta',
	'smw_qui_category' => '<strong>Luokka</strong>',
	'smw_qui_label' => 'Otsikko',
	'smw_prp_options' => 'Ominaisuuden valinnat',
	'smw_qui_catopts' => 'Luokkavalinnat',
	'smw_qui_mainlabopts' => 'Tulosten valinnat',
	'smw_qui_dlabel' => 'Otsikko:',
	'smw_qui_dcategory' => 'Luokka:',
	'smw_qui_dcatyes' => 'Näytä teksti, kun luokka on olemassa:',
	'smw_qui_dcatno' => 'Näytä teksti, kun luokkaa ei ole:',
	'searchbyproperty' => 'Selaaminen ominaisuuksittain',
	'smw_sbv_docu' => 'Voit selata sivuja, joilla on tietty arvo tietylle ominaisuudelle.',
	'smw_sbv_novalue' => 'Syötä ominaisuuden arvo alle. Lista mahdollisista arvoista löytyy sivulta $1.',
	'smw_sbv_displayresult' => 'Lista kaikista sivuista, joilla ominaisuuden $1 arvona on $2.',
	'smw_sbv_displayresultfuzzy' => 'Lista kaikista sivuista, joilla ominaisuuden $1 arvona on $2.
Koska tuloksia on vain vähän, myös lähellä olevat arvot näytetään.',
	'smw_sbv_property' => 'Ominaisuus',
	'smw_sbv_value' => 'Arvo',
	'smw_sbv_submit' => 'Etsi tuloksia',
	'browse' => 'Selaa semanttista wikiä',
	'smw_browselink' => 'Selaa ominaisuuksia',
	'smw_browse_article' => 'Kirjoita sen sivun nimi, jonka ominaisuuksia haluat selata.',
	'smw_browse_go' => 'Siirry',
	'smw_browse_show_incoming' => 'näytä ominaisuudet, jotka viittaavat tähän',
	'smw_browse_hide_incoming' => 'piilota ominaisuudet, jotka viittaavat tähän',
	'smw_browse_no_outgoing' => 'Tällä sivulla ei ole ominaisuuksia.',
	'smw_browse_no_incoming' => 'Mikään ominaisuus ei viittaa tälle sivulle.',
	'smw_inverse_label_default' => '$1 /',
	'pageproperty' => 'Sivun ominaisuuksien haku',
	'smw_pp_docu' => 'Etsi ominaisuuden kaikkia arvoja joltain tietyltä sivulta.
Syötä sekä sivu että ominaisuus.',
	'smw_pp_from' => 'Sivu',
	'smw_pp_type' => 'Ominaisuus',
	'smw_pp_submit' => 'Hae',
	'smw_result_prev' => 'Edellinen',
	'smw_result_next' => 'Seuraava',
	'smw_result_results' => 'Tulokset',
	'smw_result_noresults' => 'Ei hakutuloksia.',
	'smwadmin' => 'Ylläpitotoiminnot semanttiselle MediaWikille',
	'smw_smwadmin_return' => 'Palaa kohteeseen $1',
	'smw_smwadmin_updatestarted' => 'Semanttisten tietojen päivitysprosessi on käynnistetty.
Tietokantaan tallennetut tiedot kootaan uudellee tai korjataan tarpeen vaatiessa.
Voit seurata päivityksen etenemistä tällä toimintosivulla.

Palaa sivulle $1.',
	'smw_smwadmin_updatenotstarted' => 'Päivitysprosessi on jo käynnissä.
Uutta ei käynnistetä.

Palaa sivulle $1.',
	'smw_smwadmin_updatestopped' => 'Kaikki nykyiset päivitysprosessit on pysäytetty.

Palaa sivulle $1.',
	'smw_smwadmin_updatenotstopped' => 'Jos haluat pysäyttää käynnissä olevan päivitysprosessin, varmista päätöksesi aktivoimalla valintaruutu.

Palaa sivulle $1.',
	'smw_smwadmin_docu' => 'Tämä toimintosivu auttaa <a href="http://semantic-mediawiki.org">Semantic MediaWikin</a> asennuksessa ja päivityksessä.
Muista tehdä varmuuskopiot tärkeistä tiedoista ennen kuin aloitat ylläpitotoiminnot.',
	'smw_smwadmin_db' => 'Tietokannan asennus ja päivitys',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki tarvitseen joitain MediaWiki-tietokannan laajennuksia, jotta semanttista tietoa voidaan tallentaa.
Alla oleva toiminto varmistaa, että tietokanta on asennettu oikein.
Tässä vaiheessa tehyt muutokset eivät vaikuta muuhun MediaWiki-tietokantaan ja muutokset on helppo tarvittaessa kumota.
Asennus voidaan suorittaa monta kertaa ilman että siitä eiheutuisi vahinkoa, mutta se on tehtävä vain kerran asennuksen tai päivityksen yhteydessä.',
	'smw_smwadmin_dbbutton' => 'Alusta tai päivitä taulukot',
	'smw_smwadmin_announce' => 'Julkista wikisi',
	'smw_smwadmin_datarefresh' => 'Tietojen korjaus ja päivitys',
	'smw_smwadmin_datarefreshbutton' => 'Aloita tietojen päivitys',
	'smw_smwadmin_datarefreshstop' => 'Lopeta tämä päivitys',
	'smw_smwadmin_datarefreshstopconfirm' => 'Kyllä, olen varma.',
	'smw_smwadmin_support' => 'Tuen hankkiminen',
	'smw_smwadmin_installfile' => 'Jos asennuksen kanssa on ongelmia, lue ensin <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL-tiedoston</a> ohjeet.',
	'smw_smwadmin_smwhomepage' => 'Semantic MediaWikin täydellinen käyttäjän opas löytyy osoitteesta <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Ohjelmistovirheet voi raportoida <a href="https://bugzilla.wikimedia.org/">Bugzillaan</a>.',
	'smw_smwadmin_questions' => 'Jos sinulla on kysymyksiä tai ehdotuksia, liity keskusteluun <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semanttisen MediaWikin käyttäjäfoorumilla</a>.',
	'smw_adminlinks_datastructure' => 'Tietorakenne',
	'smw_adminlinks_inlinequerieshelp' => 'Upotettujen kyselyjen ohje',
	'smw-createproperty-isproperty' => 'Tämä on ominaisuus, jonka tyyppi on $1.',
	'smw-createproperty-allowedvals' => 'Tämän ominaisuuden  {{PLURAL:$1|sallittu arvo on|sallitut arvot ovat}}:',
	'smw-paramdesc-category-delim' => 'Erotin',
	'smw-paramdesc-category-template' => 'Malline, jolla kohteita muotoillaan',
	'smw-paramdesc-category-userparam' => 'Parametri, jotka välitetään mallineeseen',
	'smw-info-par-message' => 'Näytettävä sanoma.',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Semanttiset hakuvalinnat',
	'smw-prefs-ask-options-tooltip-display' => 'Näytä parametri työkaluvihjeenä',
	'smw-prefs-ask-options-collapsed-default' => 'Mahdollistaa valintaruudun laajentamisen oletusarvoisesti',
	'smw-ui-tooltip-title-property' => 'Ominaisuus',
	'smw-ui-tooltip-title-quantity' => 'Määrä',
	'smw-ui-tooltip-title-info' => 'Tiedot',
	'smw-ui-tooltip-title-service' => 'Palvelun linkit',
	'smw-ui-tooltip-title-warning' => 'Virhe',
	'smw-ui-tooltip-title-parameter' => 'Parametri',
	'smw-ui-tooltip-title-event' => 'Tapahtuma',
	'smw_unknowntype' => 'Tämän ominaisuuden tyyppi on virheellinen',
);

/** French (français)
 * @author Boniface
 * @author Brunoperel
 * @author Crochet.david
 * @author Erkethan
 * @author Faure.thomas
 * @author Gomoko
 * @author Grondin
 * @author IAlex
 * @author LIMAFOX76
 * @author McDutchie
 * @author Meithal
 * @author Nicolas NALLET
 * @author Od1n
 * @author Peter17
 * @author PieRRoMaN
 * @author Pierre Matringe
 * @author Seb35
 * @author Sherbrooke
 * @author Solitarius
 * @author Tititou36
 * @author Urhixidur
 * @author Verdy p
 * @author Wyz
 * @author Zetud
 */
$messages['fr'] = array(
	'smw-desc' => "Rendre le wiki plus accessible - pour les machines ''et'' les humains ([http://semantic-mediawiki.org/wiki/Help:User_manual documentation en ligne])",
	'smw_viewasrdf' => 'Voir comme RDF',
	'smw_finallistconjunct' => ' et',
	'smw_factbox_head' => 'Faits relatifs à $1 &mdash; Recherche de pages similaires avec <span class="smwsearchicon">+</span>.',
	'smw_isspecprop' => 'Cette propriété est une propriété spéciale dans ce wiki.',
	'smw_concept_description' => 'Description du concept « $1 »',
	'smw_no_concept_namespace' => 'Les concepts ne peuvent être définis que dans les pages appartenant à l’espace de noms Concept:.',
	'smw_multiple_concepts' => 'Chaque page de concept ne peut avoir qu’une seule définition de concept.',
	'smw_concept_cache_miss' => "Le concept « $1 » ne peut être utilisé en ce moment, car la configuration du wiki exige qu’il soit lancé hors-ligne. Si le problème persiste encore, demandez à l'administrateur de votre site de rendre ce concept disponible.",
	'smw_noinvannot' => 'Les valeurs ne peuvent pas être allouées pour inverser des propriétés.',
	'version-semantic' => 'Extensions sémantiques',
	'smw_baduri' => 'Désolé. Les URIs du domaine « $1 » ne sont pas autorisées.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Comptage des résultats',
	'smw_printername_csv' => 'Exporter au format CSV',
	'smw_printername_dsv' => 'Exporter au format DSV',
	'smw_printername_debug' => 'Requête de débogage (pour les experts)',
	'smw_printername_embedded' => 'Contenu des pages incrustées',
	'smw_printername_json' => 'Exporter au format JSON',
	'smw_printername_list' => 'Liste',
	'smw_printername_ol' => 'Énumération',
	'smw_printername_ul' => 'Liste détaillée',
	'smw_printername_table' => 'Tableau',
	'smw_printername_broadtable' => 'Tableau élargi',
	'smw_printername_template' => 'Modèle',
	'smw_printername_rdf' => 'Exporter au format RDF',
	'smw_printername_category' => 'Catégorie',
	'validator-type-class-SMWParamSource' => 'texte',
	'smw-paramdesc-limit' => 'Le nombre maximal de résultats à renvoyer',
	'smw-paramdesc-offset' => 'Le décalage du premier résultat',
	'smw-paramdesc-headers' => 'Afficher les en-têtes / noms de propriétés',
	'smw-paramdesc-mainlabel' => 'L’étiquette de la page d’accueil',
	'smw-paramdesc-link' => 'Montrer les valeurs en tant que liens',
	'smw-paramdesc-intro' => 'Le texte à afficher avant les résultats de la requête, s’il y en a',
	'smw-paramdesc-outro' => 'Le texte à afficher après les résultats de la requête, s’il y en a',
	'smw-paramdesc-default' => 'Le texte à afficher s’il n’y a aucun résultat pour la requête',
	'smw-paramdesc-sep' => 'Le séparateur des valeurs',
	'smw-paramdesc-showsep' => 'Afficher le séparateur en haut du fichier CSV ("sep =<valeur>")',
	'smw-paramdesc-distribution' => "Au lieu d'afficher toutes les valeurs, compter leurs occurrences et les afficher.",
	'smw-paramdesc-distributionsort' => "Trier la distribution de valeurs par nombre d'occurrences.",
	'smw-paramdesc-distributionlimit' => 'Limiter la distribution des valeurs au comptage de seulement certaines valeurs.',
	'smw-paramdesc-template' => "Le nom d'un modèle qui servira à afficher les résultats",
	'smw-paramdesc-columns' => 'Le nombre de colonnes dans lesquelles il faut afficher les résultats ($1 par défaut)',
	'smw-paramdesc-userparam' => 'Une valeur passée dans chaque appel de modèle, si un modèle est utilisé',
	'smw-paramdesc-introtemplate' => "Le nom d'un modèle à afficher avant les résultats de requête, s'il y en a",
	'smw-paramdesc-outrotemplate' => "Le nom d'un modèle à afficher après les résultats de la requête, s'il y en a",
	'smw-paramdesc-embedformat' => 'La balise HTML qui sert à définir les en-têtes',
	'smw-paramdesc-embedonly' => 'Ne pas afficher d’en-tête',
	'smw-paramdesc-table-class' => 'Une classe CSS supplémentaire à mettre pour la table',
	'smw-paramdesc-rdfsyntax' => 'La syntaxe de RDF à utiliser',
	'smw-paramdesc-csv-sep' => 'Le séparateur à utiliser',
	'smw-paramdesc-dsv-separator' => 'Le séparateur à utiliser',
	'smw-paramdesc-dsv-filename' => 'Le nom du fichier DSV',
	'smw-smwdoc-description' => 'Montre un tableau de tous les paramètres qui peuvent être utilisés pour un format de résultat spécifié ensemble avec des valeurs et des descriptions par défaut.',
	'smw-smwdoc-par-format' => "Le format de résultat dans lequel afficher la documentation d'un paramètre",
	'smw-smwdoc-par-parameters' => 'Les paramètres à afficher. "specific" pour ceux ajoutés par le format, "base" pour ceux disponibles dans tous les formats, et "all" pour les deux.',
	'smw-paramdesc-sort' => 'Propriété sur laquelle trier la requête',
	'smw-paramdesc-order' => 'Ordre du tri de la requête',
	'smw-paramdesc-searchlabel' => "Titre du lien permettant d'accéder aux résultats suivants (par défaut, «… autres résultats»)",
	'smw-paramdesc-named_args' => 'Nommez les arguments transmis au modèle',
	'smw-paramdesc-export' => 'Options d’exportation',
	'smw-paramdesc-prettyprint' => "Une sortie d'impression plus claire qui affiche de nouvelles lignes et indentations",
	'smw-paramdesc-source' => 'Source de requête alternative',
	'smw-paramdesc-jsonsyntax' => 'Syntaxe JSON à utiliser',
	'smw-printername-feed' => 'Flux RSS ou Atom',
	'smw-paramdesc-feedtype' => 'Type de flux',
	'smw-paramdesc-feedtitle' => 'Le texte à utiliser comme titre du flux',
	'smw-paramdesc-feeddescription' => 'Le texte à utiliser comme description du flux',
	'smw-paramdesc-feedpagecontent' => 'Contenu de la page à afficher avec le flux',
	'smw-label-feed-description' => 'Flux $1 $2',
	'smw_iq_disabled' => 'Désolé. Les recherches dans les pages de ce wiki ne sont pas autorisées.',
	'smw_iq_moreresults' => '&hellip; autres résultats',
	'smw_parseerror' => 'La donnée indiquée n’a pas été comprise.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => '« $1 » ne peut être utilisé comme nom de page sur ce wiki.',
	'smw_noproperty' => '"$1" ne peut être utilisé comme un nom de propriété dans ce wiki.',
	'smw_wrong_namespace' => 'Seules les pages dans l’espace « $1 » sont autorisées ici.',
	'smw_manytypes' => 'Plusieurs types de données ont été assignés à cette propriété.',
	'smw_emptystring' => 'Les chaînes vides ne sont pas acceptées.',
	'smw_maxstring' => 'La chaîne de représentation $1 est trop grande.',
	'smw_notinenum' => '« $1 » ne fait pas partie des valeurs possibles ($2) pour cette propriété.',
	'smw_noboolean' => '« $1 » n’est pas reconnu comme valeur booléenne (vrai/faux).',
	'smw_true_words' => 'vrai,v,oui,true',
	'smw_false_words' => 'faux,f,non,false',
	'smw_nofloat' => '« $1 » n’est pas un nombre.',
	'smw_infinite' => 'Les nombres aussi grand que « $1 » ne sont pas supportés.',
	'smw_unitnotallowed' => '"$1" n\'est pas déclaré comme une unité valide de mesure pour cette propriété.',
	'smw_nounitsdeclared' => "Aucune unité de mesure n'a été déclarée pour cette propriété.",
	'smw_novalues' => 'Aucune valeur n’a été spécifiée.',
	'smw_nodatetime' => 'La date « $1 » n’a pas été comprise.',
	'smw_toomanyclosing' => 'Il semble y avoir trop d’occurences de « $1 » dans la requête.',
	'smw_noclosingbrackets' => 'Certains « <nowiki>[[</nowiki> » dans votre requête n’ont pas été clos par des « ]] » correspondants.',
	'smw_misplacedsymbol' => 'Le symbole « $1 » a été utilisé à un endroit où il n’est pas utile.',
	'smw_unexpectedpart' => 'La partie « $1 » de la requête n’a pas été comprise. Les résultats peuvent être inattendus.',
	'smw_emptysubquery' => 'Certaines sous-requêtes ont une condition invalide.',
	'smw_misplacedsubquery' => 'Certaines sous-requêtes ont été utilisées à un endroit où aucune sous-requête n’est permise.',
	'smw_valuesubquery' => 'Sous-requête non supportée pour les valeurs de la propriété « $1 ».',
	'smw_badqueryatom' => 'Les parties « <nowiki>[[…]]</nowiki> » de la requête n’ont pas été comprises.',
	'smw_propvalueproblem' => 'La valeur de la propriété « $1 » n’a pas été comprise.',
	'smw_noqueryfeature' => 'Quelques fonctionnalités de requêtes ne sont pas supportées sur ce wiki et une partie d’entre elles ont été retirées ($1).',
	'smw_noconjunctions' => 'Les conjonctions dans les requêtes ne sont pas supportées sur ce wiki et une parties d’entres elles ont été retirées ($1).',
	'smw_nodisjunctions' => 'Les disjonctions dans les requêtes ne sont pas supportées sur ce wiki et des parties de la requête ont été ignorées ($1).',
	'smw_querytoolarge' => 'Les conditions suivantes de la requête n’ont pu être évaluées en raison des restrictions de ce wiki à la taille ou à la profondeur des requêtes : $1.',
	'smw_notemplategiven' => 'Veuillez fournir une valeur pour le paramètre « modèle » pour ce format de requête afin de travailler.',
	'smw_db_sparqlqueryproblem' => "Le résultat de la requête n'a pas pu être obtenu à partir de la base de données SPARQL. Cette erreur peut être temporaire ou indiquer un bogue dans le logiciel de la base de données.",
	'smw_db_sparqlqueryincomplete' => 'Il s’est avéré trop difficile de répondre à la requête et celle-ci a été abandonnée. Certains résultats pourraient manquer. Si possible, essayez plutôt d’utiliser une requête plus simple.',
	'smw_type_header' => 'Propriétés de type « $1 »',
	'smw_typearticlecount' => 'Afficher {{PLURAL:$1|la propriété|les $1 propriétés}} utilisant ce type.',
	'smw_attribute_header' => 'Pages utilisant la propriété « $1 »',
	'smw_attributearticlecount' => 'Afficher {{PLURAL:$1|la page|les $1 pages}} utilisant cette propriété.',
	'smw_subproperty_header' => 'Sous-propriétés',
	'smw_subpropertyarticlecount' => 'Cette propriété dispose {{PLURAL:$1|de la sous-propriété suivante|des $1 sous-propriétés suivantes}} :',
	'smw_concept_header' => 'Page du concept « $1 »',
	'smw_conceptarticlecount' => 'Afficher {{PLURAL:$1|la page|les $1 pages}} reposant sur ce concept',
	'specialpages-group-smw_group' => 'MediaWiki sémantique',
	'exportrdf' => 'Exporter des pages en RDF',
	'smw_exportrdf_docu' => 'Cette page permet d’obtenir des données d’une page au format RDF. Veuillez entrer le nom des pages souhaitées dans la boîte de texte ci-dessous, un nom par ligne.',
	'smw_exportrdf_recursive' => 'Exporter également toutes les pages pertinentes de manière récursive. Cette possibilité peut aboutir à un très grand nombre de résultats !',
	'smw_exportrdf_backlinks' => 'Exporter également toutes les pages qui renvoient à des pages exportées. Produit un RDF dans lequel la navigation est facilitée.',
	'smw_exportrdf_lastdate' => 'Ne pas exporter les pages non modifiées depuis le moment indiqué.',
	'smw_exportrdf_submit' => 'Exporter',
	'uriresolver' => 'Résolveur d’URI',
	'properties' => 'Propriétés',
	'smw_properties_docu' => 'Sur ce wiki, sont utilisées les propriétés suivantes.',
	'smw_property_template' => '$1 du type $2 ($3 {{PLURAL:$3|utilisation|utilisations}})',
	'smw_propertylackspage' => 'Toute propriété devrait être décrite par une page !',
	'smw_propertylackstype' => 'Aucun type n’a été spécifié pour cette propriété (type actuellement supposé : $1).',
	'smw_propertyhardlyused' => 'Cette propriété est à peine utilisée sur ce wiki !',
	'unusedproperties' => 'Propriétés inutilisées',
	'smw_unusedproperties_docu' => 'Les propriétés suivantes existent, bien qu’aucune page ne les utilise.',
	'smw_unusedproperty_template' => '$1 de type $2',
	'wantedproperties' => 'Propriétés demandées',
	'smw_wantedproperties_docu' => 'Les propriétés suivantes sont utilisées sur ce wiki mais n’ont pas encore de page pour les décrire.',
	'smw_wantedproperty_template' => '$1 ($2 utilisation{{PLURAL:$2||s}})',
	'smw_purge' => 'Réactualiser',
	'types' => 'Types de données',
	'smw_types_docu' => 'Ceci est une liste de tous les types de données qui peuvent être assignés aux propriétés.',
	'semanticstatistics' => 'Statistiques sémantiques',
	'smw_semstats_text' => "Ce wiki contient '''$1''' valeur{{PLURAL:$1||s}} de propriété pour un total de '''$2''' [[Special:Properties|{{PLURAL:$2|propriété différente|propriétés différentes}}]].
'''$3''' {{PLURAL:$3|propriété a sa|propriétés ont leur}} propre page, et le type de données voulu est spécifié pour '''$4''' de celles-ci.
Certaines des propriétés existantes peuvent en faite être [[Special:UnusedProperties|inutilisées]].
Les propriétés qui n’ont pas encore de page se trouvent dans la [[Special:WantedProperties|liste des propriétés demandées]].",
	'smw_uri_doc' => 'Le résolveur d’URI implémente la <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">Conclusion du TAG du W3C à propos du httpRange-14</a>. Il peut veiller à ce que les humains ne deviennent pas des sites web.',
	'ask' => 'Recherche sémantique',
	'smw_ask_sortby' => 'Trier par colonnes (optionnel)',
	'smw_ask_ascorder' => 'Croissant',
	'smw_ask_descorder' => 'Décroissant',
	'smw_ask_submit' => 'Trouver des résultats',
	'smw_ask_editquery' => '[Modifier la requête]',
	'smw_add_sortcondition' => '[Ajoute les conditions de tri]',
	'smw_ask_hidequery' => 'Masquer la requête',
	'smw_ask_help' => 'Aide à la requête',
	'smw_ask_queryhead' => 'Requête',
	'smw_ask_printhead' => 'Données supplémentaires à afficher',
	'smw_ask_printdesc' => '(ajouter un nom de propriété par ligne)',
	'smw_ask_format_as' => 'Formater en :',
	'smw_ask_defaultformat' => 'défaut',
	'smw_ask_otheroptions' => 'Autres options',
	'smw-ask-otheroptions-info' => "Cette section contient des options qui modifient l'affichage des données. Placez votre souris sur les paramètres pour voir leur description.",
	'smw-ask-otheroptions-collapsed-info' => 'Veuillez utiliser l\'icône "plus" pour afficher toutes les options disponibles',
	'smw_ask_show_embed' => 'Montrer le code incrusté',
	'smw_ask_hide_embed' => 'Masquer le code incrusté',
	'smw_ask_embed_instr' => 'Pour incruster cette requête dans une page wiki, utilisez le code ci-dessous.',
	'smw-ask-delete' => '[Supprimer]',
	'smw-ask-sorting' => 'Tri',
	'smw-ask-format-selection-help' => "Pour une description détaillée, veuillez visiter la page d'aide $1.",
	'querycreator' => 'Créateur de requêtes',
	'smw_qc_addmainlabel' => 'Ajouter le libellé principal',
	'smw_qc_show_addnal_opts' => "Afficher plus d'options",
	'smw_qc_hide_addnal_opts' => "Afficher moins d'options",
	'smw_qc_otheropt' => 'Autres options',
	'smw_qc_intro' => 'Intro:',
	'smw_qc_outro' => 'Outro:',
	'smw_qc_default' => 'Par défaut:',
	'smw_qc_formatopt' => 'Options de format',
	'smw_qc_query_help' => 'Saisissez une requête en utilisant le formulaire ci-dessous. Sélectionner les pages wiki basées sur les
Catégories(<strong><nowiki>exemple [[Catégorie:Acteur]]</nowiki></strong>),
Propriétés(<strong><nowiki>exemple [[Situé en::Allemagne]]</nowiki></strong>),
Noms (<strong><nowiki>exemple [[Allemagne]]</nowiki></strong>) et
Espaces de noms (<strong><nowiki>exemple [[Aide:+]]</nowiki></strong>)',
	'smw_qui_property' => '<strong>Propriété</strong>',
	'smw_qui_prop' => 'Propriété :',
	'smw_qui_labl' => 'Libellé :',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Limite :',
	'smw_qui_shownresults' => 'afficher les résultats',
	'smw_qui_noquery' => "Aucune requête n'a été spécifiée",
	'smw_qui_invalidprop' => '"$1" n\'est peut-être pas une propriété valide',
	'smw_qui_invalidformat' => 'Le format choisi "$1" n\'existe pas pour ce wiki',
	'smw_qui_nosort' => 'Pas de tri',
	'smw_qui_ascorder' => 'Croissant',
	'smw_qui_descorder' => 'Décroissant',
	'smw_qui_randorder' => 'Aléatoire',
	'smw_qui_addnprop' => 'ajouter la propriété',
	'smw_qui_delete' => 'Supprimer',
	'smw_qui_rescol' => 'Correspondances de la requête',
	'smw_qui_options' => 'options',
	'smw_qui_addcategory' => 'ajouter la catégorie',
	'smw_qui_addrescol' => 'ajouter les correspondances de requête',
	'smw_qui_ok' => 'Ok',
	'smw_qui_cancel' => 'Annuler',
	'smw_qui_category' => '<strong>Catégorie</strong>',
	'smw_qui_label' => 'Libellé',
	'smw_prp_options' => 'Options de propriété',
	'smw_qui_catopts' => 'Options de catégorie',
	'smw_qui_mainlabopts' => 'Options de résultat',
	'smw_qui_dlabel' => 'Libellé :',
	'smw_qui_dcategory' => 'Catégorie :',
	'smw_qui_dcatyes' => 'Afficher le texte quand la catégorie est présente:',
	'smw_qui_dcatno' => 'Afficher le texte quand la catégorie est absente:',
	'searchbyproperty' => 'Recherche par propriété',
	'smw_sbv_docu' => 'Rechercher toutes les pages qui ont une propriété donnée avec une certaine valeur.',
	'smw_sbv_novalue' => 'Entrez une valeur correcte pour le critère, ou consultez toutes les valeurs de critère pour "$1".',
	'smw_sbv_displayresult' => 'Une liste de toutes les pages qui ont un critère « $1 » avec la valeur « $2 ».',
	'smw_sbv_displayresultfuzzy' => 'Une liste de toutes les pages qui ont la propriété « $1 » avec la valeur « $2 ». Puisqu’il n’y a que quelques résultats, les valeurs proches sont également affichées.',
	'smw_sbv_property' => 'Propriété :',
	'smw_sbv_value' => 'Valeur :',
	'smw_sbv_submit' => 'Trouver des résultats',
	'browse' => 'Parcourir le wiki',
	'smw_browselink' => 'Chercher les propriétés',
	'smw_browse_article' => 'Entrez le nom de la page à partir de laquelle commencer la navigation.',
	'smw_browse_go' => 'Démarrer',
	'smw_browse_show_incoming' => 'afficher les propriétés qui pointent ici',
	'smw_browse_hide_incoming' => 'cacher les propriétés qui pointent ici',
	'smw_browse_no_outgoing' => 'Cette page n’a aucune propriété.',
	'smw_browse_no_incoming' => 'Aucune propriété ne pointe vers cette page.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Label de la propriété inverse',
	'pageproperty' => 'Rechercher dans les propriétés de la page',
	'smw_pp_docu' => 'Rechercher toutes les valeurs d’une propriété dans une page donnée. Veuillez entrer la page et une propriété.',
	'smw_pp_from' => 'De la page',
	'smw_pp_type' => 'Propriété',
	'smw_pp_submit' => 'Afficher les résultats',
	'smw_result_prev' => 'Précédent',
	'smw_result_next' => 'Suivant',
	'smw_result_results' => 'Résultats',
	'smw_result_noresults' => 'Désolé, aucun résultat.',
	'smwadmin' => 'Fonctions administrateur pour Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Le moteur de stockage a été installé avec succès.',
	'smw_smwadmin_return' => 'Revenir vers $1',
	'smw_smwadmin_updatestarted' => 'Un nouveau processus de rafraîchissement des données sémantiques a commencé.
Toutes les données stockées seront reconstruites, voire réparées si nécessaire.
Vous pouvez suivre la progression de la mise à jour sur cette page spéciale.

Retour à $1.',
	'smw_smwadmin_updatenotstarted' => "Un processus de mise à jour est déjà en cours d’exécution.
Aucune action n'a été prise.

Retour à $1.",
	'smw_smwadmin_updatestopped' => 'Tous les processus de mise à jour existantes ont été arrêtés. 

Retour à  $1 .',
	'smw_smwadmin_updatenotstopped' => 'Pour arrêter le processus de mise à jour en cours, vous devez activer la case à cocher pour indiquer que vous êtes vraiment sûr. 

Revenir à $1.',
	'smw_smwadmin_docu' => 'Cette page spéciale vous aide pendant l’installation et la mise à niveau de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
N’oubliez pas de sauvegarder vos données avant d’exécuter les fonctions d’administration du site.',
	'smw_smwadmin_db' => 'Installation et mise à niveau de la base de données',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki doit étendre la base de données MediaWiki afin de stocker ses données sémantiques.
La fonction ci-dessous s’assure que votre base de données a été correctement installée.
Les modifications faites lors de cette étape n’affecteront pas le reste de la base de données Mediawiki, et peuvent être annulées si nécessaire.
Cette fonction d’installation peut être lancée plusieurs fois sans causer le moindre dégat, et n’est nécessaire qu’une fois par installation ou mise à niveau.',
	'smw_smwadmin_permissionswarn' => 'Si l’opération échoue avec des erreurs SQL, l’utilisateur de la base de données utilisée par votre wiki (regardez votre LocalSettings.php) n’a probablement pas les droits suffisants.
Il faut soit permettre à cet utilisateur de créer et supprimer les tables, soit saisir temporairement les identifiants du compte root de votre base de données dans LocalSettings.php, soit utiliser le script de maintenance <tt>SMW_setup.php</tt> qui peut utiliser les informations de connexion d’un administrateur.',
	'smw_smwadmin_dbbutton' => 'Initialiser ou mettre à niveau les tables',
	'smw_smwadmin_announce' => 'Annoncer votre wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki dispose d’un service Internet pour annoncer de nouveaux sites wiki sémantiques.
Ce service maintient une liste des sites publics utilisant Semantic MediaWiki, principalement pour aider <a href="http://semantic-mediawiki.org/wiki/SMW_Project">le projet Semantic MediaWiki</a> à obtenir une vue d’ensemble de ses utilisations typiques.
Voyez la page d’accueil de Semantic MediaWiki pour <a href="http://semantic-mediawiki.org/wiki/Registry">de plus amples informations concernant ce service</a>.',
	'smw_smwadmin_announcebutton' => 'Appuyez sur le bouton suivant pour soumettre l’adresse Internet de votre wiki à ce service.
Le service n’enregistrera pas les wikis qui ne sont pas accessibles au public, et il ne stockera que les informations publiquement accessibles.',
	'smw_smwadmin_datarefresh' => 'Réparation et mise à niveau des données',
	'smw_smwadmin_datarefreshdocu' => 'Il est possible de restaurer toutes les données Semantic MediaWiki à partir du contenu courant de ce wiki.
Ceci peut être utile pour réparer des données corrompues ou pour rafraîchir les données si le format interne a changé lors des mises à niveau.
La mise à jour est exécutée page par page et se sera pas achevée immédiatement.
La page suivante spécifie si une mise à jour est en cours d’exécution et vous permet de commencer ou d’arrêter celle-ci (à moins que cette fonctionnalité n’ait été désactivée par l’administrateur du site).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Une mise à jour est en cours d’exécution.</strong>
Il est normal qu’une mise à jour progresse lentement parce qu’elle ne rafraîchit les données que par petits tronçons, au fur et à mesure qu’un utilisateur accède au wiki.
Pour terminer cette mise à jour plus rapidement, vous pouvez invoquer le script d’entretien Mediawiki <tt>runJobs.php</tt> (utilisez l’option <tt>--maxjobs 1000</tt> pour restreindre le nombre de mises à jour par script lancé).
Progression estimée de la mise à jour actuelle :',
	'smw_smwadmin_datarefreshbutton' => 'Commencer la mise à jour des données',
	'smw_smwadmin_datarefreshstop' => 'Arrêter cette mise à jour',
	'smw_smwadmin_datarefreshstopconfirm' => 'Oui, j’en suis sûr.',
	'smw_smwadmin_support' => 'Obtenir de l’aide',
	'smw_smwadmin_supportdocu' => 'Diverses ressources pourraient vous aider en cas de problèmes :',
	'smw_smwadmin_installfile' => 'Si vous rencontrez des problèmes lors de votre installation, commencez par regarder le guide en ligne dans le <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">fichier INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentation complète de l’utilisateur de Semantic MediaWiki se trouve sur <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Les bogues peuvent être soumis sur <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Si vous avez d’autres questions ou des suggestions, joignez-vous à la discussion sur <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">le forum des utilisateurs de Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Structure des données',
	'smw_adminlinks_displayingdata' => 'Affichage des données',
	'smw_adminlinks_inlinequerieshelp' => 'Aide sur les requêtes',
	'smw-createproperty-isproperty' => 'Cette propriété est de type $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|La valeur autorisée pour cett propriété est|Les valeurs autorisées pour cette propriété sont}} :',
	'smw-paramdesc-category-delim' => 'Le délimiteur',
	'smw-paramdesc-category-template' => 'Un modèle pour mettre en forme les éléments',
	'smw-paramdesc-category-userparam' => 'Un paramètre à passer au modèle',
	'smw-info-par-message' => 'Message à afficher.',
	'smw-info-par-icon' => 'Icône à afficher, soit « info » ou « attention »',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Options de recherche sémantique',
	'smw-prefs-intro-text' => "Les options ci-dessous sont fournies par [http://semantic-mediawiki.org/ Semantic MediaWiki] (ou l'une de ses extensions) pour permettre une personnalisation individuelle de certaines fonctions. Pour plus d'information, vous pouvez consulter [http://semantic-mediawiki.org/wiki/Help:User_preferences cette section d'aide].",
	'smw-prefs-ask-options-tooltip-display' => 'Afficher le texte du paramètre comme info-bulle',
	'smw-prefs-ask-options-collapsed-default' => 'Réduire par défaut les option box',
	'smw-ui-tooltip-title-property' => 'Propriété',
	'smw-ui-tooltip-title-quantity' => 'Quantité',
	'smw-ui-tooltip-title-info' => 'Information',
	'smw-ui-tooltip-title-service' => 'Liens de service',
	'smw-ui-tooltip-title-warning' => 'Erreur',
	'smw-ui-tooltip-title-parameter' => 'Paramètre',
	'smw-ui-tooltip-title-event' => 'Évènement',
	'smw_unknowntype' => "Le type de cette propriété n'est pas valide",
);

/** Franco-Provençal (arpetan)
 * @author Cedric31
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'smw_viewasrdf' => 'Flux RDF',
	'smw_finallistconjunct' => ' et',
	'smw_factbox_head' => 'Fêts sur $1',
	'smw_concept_description' => 'Dèscripcion du concèpte « $1 »',
	'version-semantic' => 'Èxtensions sèmantiques',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Comptar los rèsultats',
	'smw_printername_csv' => 'èxportacion en CSV',
	'smw_printername_dsv' => 'Èxportacion en DSV',
	'smw_printername_debug' => 'Requéta d’èliminacion de les cofieries (por los èxpèrts)',
	'smw_printername_embedded' => 'Entrebetar lo contegnu de les pâges',
	'smw_printername_json' => 'èxportacion en JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Ènumèracion',
	'smw_printername_ul' => 'Dètaly',
	'smw_printername_rss' => 'èxportacion en RSS',
	'smw_printername_table' => 'Tablô',
	'smw_printername_broadtable' => 'Trâbla lârge',
	'smw_printername_template' => 'Modèlo',
	'smw_printername_rdf' => 'Èxportacion RDF',
	'smw_printername_category' => 'Catègorie',
	'smw-paramdesc-link' => 'Montrar les valors coment lims',
	'smw-paramdesc-sep' => 'Lo sèparator de les valors',
	'smw-paramdesc-embedonly' => 'Pas fâre vêre les en-tétes',
	'smw-paramdesc-rdfsyntax' => 'La sintaxa RDF a utilisar',
	'smw-paramdesc-csv-sep' => 'Lo sèparator a utilisar',
	'smw-paramdesc-dsv-separator' => 'Lo sèparator a utilisar',
	'smw-paramdesc-dsv-filename' => 'Lo nom du fichiér DSV',
	'smw-paramdesc-searchlabel' => 'Lo tèxto du lim de vers los rèsultats', # Fuzzy
	'smw_iq_moreresults' => '&hellip; ôtros rèsultats',
	'smw_true_words' => 'veré,v,ouè,o',
	'smw_false_words' => 'fôx,f,nan,n',
	'smw_nofloat' => '« $1 » est pas un nombro.',
	'smw_novalues' => 'Gins de valor spècefiâ.',
	'smw_type_header' => 'Propriètâts de tipo « $1 »',
	'smw_typearticlecount' => 'Fâre vêre l{{PLURAL:$1|a propriètât qu’utilise|es $1 propriètâts qu’utilisont}} ceti tipo.',
	'smw_attribute_header' => 'Pâges qu’utilisont la propriètât « $1 »',
	'smw_attributearticlecount' => 'Fâre vêre l{{PLURAL:$1|a pâge qu’utilise|es $1 pâges qu’utilisont}} ceta propriètât.',
	'smw_subproperty_header' => 'Sot-propriètâts',
	'smw_subpropertyarticlecount' => 'Ceta propriètât at cet{{PLURAL:$1|a sot-propriètât|es $1 sot-propriètâts}} :',
	'smw_concept_header' => 'Pâges du concèpte « $1 »',
	'smw_conceptarticlecount' => 'Fâre vêre l{{PLURAL:$1|a pâge que repôse|es $1 pâges que repôsont}} sur cél concèpte.',
	'exportrdf' => 'Èxportar des pâges en RDF',
	'smw_exportrdf_submit' => 'Èxportar',
	'uriresolver' => 'Rèsolvior d’URI',
	'properties' => 'Propriètâts',
	'smw_property_template' => '$1 du tipo $2 ($3)',
	'unusedproperties' => 'Propriètâts inutilisâs',
	'smw_unusedproperty_template' => '$1 de tipo $2',
	'wantedproperties' => 'Propriètâts demandâs',
	'smw_wantedproperty_template' => '$1 ($2 usâjo{{PLURAL:$2||s}})',
	'smw_purge' => 'Rafrèchir',
	'types' => 'Tipos',
	'semanticstatistics' => 'Statistiques sèmantiques',
	'ask' => 'Rechèrche sèmantica',
	'smw_ask_sortby' => 'Triyér per colones (u chouèx)',
	'smw_ask_ascorder' => 'Crèssent',
	'smw_ask_descorder' => 'Dècrèssent',
	'smw_ask_submit' => 'Trovar des rèsultats',
	'smw_ask_editquery' => '[Changiér la requéta]',
	'smw_add_sortcondition' => '[Apondre les condicions de tri]',
	'smw_ask_hidequery' => 'Cachiér la requéta',
	'smw_ask_help' => 'Éde a la requéta',
	'smw_ask_queryhead' => 'Requéta',
	'smw_ask_printhead' => 'Balyês de ples a fâre vêre',
	'smw_ask_printdesc' => '(apondre yon nom de propriètât per legne)',
	'smw_ask_format_as' => 'Formatar en :',
	'smw_ask_defaultformat' => 'per dèfôt',
	'smw_ask_otheroptions' => 'Ôtros chouèx',
	'smw_ask_show_embed' => 'Fâre vêre lo code entrebetâ',
	'smw_ask_hide_embed' => 'Cachiér lo code entrebetâ',
	'smw-ask-delete' => '[Suprimar]',
	'querycreator' => 'Crèator de requétes',
	'smw_qc_addmainlabel' => 'Apondre lo lambél principâl',
	'smw_qc_show_addnal_opts' => 'Fâre vêre més de chouèx',
	'smw_qc_hide_addnal_opts' => 'Fâre vêre muens de chouèx',
	'smw_qc_otheropt' => 'Ôtros chouèx',
	'smw_qc_intro' => 'Entrô :',
	'smw_qc_outro' => 'Outrô :',
	'smw_qc_default' => 'Per dèfôt :',
	'smw_qc_formatopt' => 'Chouèx de format',
	'smw_qc_query_help' => 'Buchiéd una requéta en utilisent lo formulèro ce-desot por chouèsir les pâges vouiqui basâs sur les
catègories (<strong>[[{{ns:category}}:Actor]]</strong>), les
propriètâts (<strong>[[Placiê en::Alemagnes]]</strong>), los
noms (<strong>[[Alemagnes]]</strong>) et los èspâços de noms (<strong>[[{{ns:help}}:+]]</strong>)', # Fuzzy
	'smw_qui_property' => '<strong>Propriètât</strong>',
	'smw_qui_prop' => 'Propriètât :',
	'smw_qui_labl' => 'Lambél :',
	'smw_qui_formt' => 'Format :',
	'smw_qui_limt' => 'Limita :',
	'smw_qui_shownresults' => 'fâre vêre los rèsultats',
	'smw_qui_noquery' => 'Niona requéta at étâ spècefiâ',
	'smw_qui_invalidprop' => '« $1 » est pôt-étre pas una propriètât valida',
	'smw_qui_invalidformat' => 'Lo format chouèsi « $1 » ègziste pas por ceti vouiqui',
	'smw_qui_nosort' => 'Gins de tri',
	'smw_qui_ascorder' => 'Crèssent',
	'smw_qui_descorder' => 'Dècrèssent',
	'smw_qui_randorder' => 'A l’hasârd',
	'smw_qui_addnprop' => 'apondre una propriètât',
	'smw_qui_delete' => 'Enlevar',
	'smw_qui_rescol' => 'Corrèspondances de la requéta',
	'smw_qui_options' => 'chouèx',
	'smw_qui_addcategory' => 'apondre una catègorie',
	'smw_qui_addrescol' => 'apondre les corrèspondances de requéta',
	'smw_qui_ok' => 'D’acôrd',
	'smw_qui_cancel' => 'Anular',
	'smw_qui_category' => '<strong>Catègorie</strong>',
	'smw_qui_label' => 'Lambél',
	'smw_prp_options' => 'Chouèx de propriètât',
	'smw_qui_catopts' => 'Chouèx de catègorie',
	'smw_qui_mainlabopts' => 'Chouèx de rèsultat',
	'smw_qui_dlabel' => 'Lambél :',
	'smw_qui_dcategory' => 'Catègorie :',
	'searchbyproperty' => 'Rechèrchiér per propriètât',
	'smw_sbv_property' => 'Propriètât :',
	'smw_sbv_value' => 'Valor :',
	'smw_sbv_submit' => 'Trovar des rèsultats',
	'browse' => 'Navegar lo vouiqui',
	'smw_browselink' => 'Navegar les propriètâts',
	'smw_browse_go' => 'Emmodar',
	'smw_browse_show_incoming' => 'fâre vêre les propriètâts que pouentont ique',
	'smw_browse_hide_incoming' => 'cachiér les propriètâts que pouentont ique',
	'smw_browse_no_outgoing' => 'Ceta pâge at gins de propriètât.',
	'smw_browse_no_incoming' => 'Niona propriètât pouente vers ceta pâge.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Lambél de la propriètât envèrsa',
	'pageproperty' => 'Rechèrche dens les propriètâts de la pâge',
	'smw_pp_from' => 'De la pâge',
	'smw_pp_type' => 'Propriètât',
	'smw_pp_submit' => 'Trovar des rèsultats',
	'smw_result_prev' => 'Devant',
	'smw_result_next' => 'Aprés',
	'smw_result_results' => 'Rèsultats',
	'smw_result_noresults' => 'Dèsolâ, gins de rèsultat.',
	'smw_smwadmin_return' => 'Tornar a $1',
	'smw_smwadmin_dbbutton' => 'Inicialisar ou ben betar a nivél les trâbles',
	'smw_smwadmin_announce' => 'Anonciér voutron vouiqui',
	'smw_smwadmin_datarefresh' => 'Rèparacion et misa a nivél de les balyês',
	'smw_smwadmin_datarefreshbutton' => 'Comenciér la misa a jorn de les balyês',
	'smw_smwadmin_datarefreshstop' => 'Arrètar ceta misa a jorn',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ouè, je nen su de sûr.',
	'smw_smwadmin_support' => 'Avêr d’assistance',
	'smw_adminlinks_datastructure' => 'Structura de les balyês',
	'smw_adminlinks_displayingdata' => 'Visualisacion de les balyês',
	'smw_adminlinks_inlinequerieshelp' => 'Éde sur les requétes entrebetâs',
	'smw-createproperty-isproperty' => 'Ceta propriètât est de tipo « $1 ».',
	'smw-info-par-message' => 'Mèssâjo a fâre vêre.',
);

/** Irish (Gaeilge)
 * @author Alison
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'smw_printername_category' => 'Catagóir',
	'smw_exportrdf_submit' => 'Easportáil',
	'smw_ask_defaultformat' => 'réamhshocrú',
	'smw_qc_default' => 'réamhshocrú:',
	'smw_qui_formt' => 'Formáid:',
	'smw_qui_options' => 'Roghanna',
	'smw_qui_cancel' => 'Cealaigh',
	'smw_qui_dcategory' => 'Catagóir:',
	'smw_sbv_property' => 'Airí', # Fuzzy
	'smw_browse_go' => 'Gabh',
	'smw_pp_type' => 'Airí',
	'smw_result_prev' => 'Siar',
	'smw_result_next' => 'Ar aghaidh',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'smw-desc' => "Fai o seu wiki máis accesible; para máquinas ''e'' humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentación en liña])",
	'smw_viewasrdf' => 'Fonte de novas RDF',
	'smw_finallistconjunct' => 'e',
	'smw_factbox_head' => 'Feitos acerca de $1',
	'smw_isspecprop' => 'Esta propiedade é especial neste wiki.',
	'smw_concept_description' => 'Descrición do concepto "$1"',
	'smw_no_concept_namespace' => 'O conceptos só poden ser definidos nas páxinas que están no espazo de nomes Concepto:.',
	'smw_multiple_concepts' => 'Cada páxina de conceptos só pode conter unha definición dun concepto.',
	'smw_concept_cache_miss' => 'O concepto "$1" non pode ser usado desde que a configuración do wiki o require para calcular a desconexión. Se o problema non se resolve en breve, pregúntelle ao administrador do wiki para que o concepto poida estar dispoñible.',
	'smw_noinvannot' => 'Non se poden asignar os valores para inverter as propiedades.',
	'version-semantic' => 'Extensións semánticas',
	'smw_baduri' => 'Sentímolo, os enderezos URI da forma "$1" non están permitidos.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Contador de resultados',
	'smw_printername_csv' => 'Exportación en CSV',
	'smw_printername_dsv' => 'Exportación en DSV',
	'smw_printername_debug' => 'Depurar a pescuda (para expertos)',
	'smw_printername_embedded' => 'Contidos incrustados na páxina',
	'smw_printername_json' => 'Exportación en JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeración',
	'smw_printername_ul' => 'Lista detallada',
	'smw_printername_table' => 'Táboa',
	'smw_printername_broadtable' => 'Táboa ampla',
	'smw_printername_template' => 'Modelo',
	'smw_printername_rdf' => 'Exportación en RDF',
	'smw_printername_category' => 'Categoría',
	'validator-type-class-SMWParamSource' => 'texto',
	'smw-paramdesc-limit' => 'O número máximo de resultados a devolver',
	'smw-paramdesc-offset' => 'O desprazamento do primeiro resultado',
	'smw-paramdesc-headers' => 'Mostrar as cabeceiras/os nomes de propiedade',
	'smw-paramdesc-mainlabel' => 'A lapela para dar nome á páxina principal',
	'smw-paramdesc-link' => 'Mostrar os valores como ligazóns',
	'smw-paramdesc-intro' => 'O texto a mostrar antes dos resultados da pescuda, se houbese algún',
	'smw-paramdesc-outro' => 'O texto a mostrar despois dos resultados da pescuda, se houbese algún',
	'smw-paramdesc-default' => 'O texto a mostrar se non hai resultados para a pescuda',
	'smw-paramdesc-sep' => 'O separador dos valores',
	'smw-paramdesc-showsep' => 'Mostrar o separador ao comezo do ficheiro CSV ("sep=<value>")',
	'smw-paramdesc-distribution' => 'No canto de mostrar todos os valores, contar as súas ocorrencias e mostralas.',
	'smw-paramdesc-distributionsort' => 'Ordenar a distribución de valores por número de ocorrencias.',
	'smw-paramdesc-distributionlimit' => 'Limitar a distribución de valores á contaxe dalgúns valores soamente.',
	'smw-paramdesc-template' => 'O nome dun modelo co que mostrar as impresións',
	'smw-paramdesc-columns' => 'O número de columnas nas que mostrar os resultados ($1 por defecto)',
	'smw-paramdesc-userparam' => 'O valor pasado en cada chamada de modelo, se se empregase algún modelo',
	'smw-paramdesc-introtemplate' => 'O nome dun modelo a mostrar antes dos resultados da pescuda, se houbese algún',
	'smw-paramdesc-outrotemplate' => 'O nome dun modelo a mostrar despois dos resultados da pescuda, se houbese algún',
	'smw-paramdesc-embedformat' => 'A etiqueta HTML utilizada para definir as cabeceiras',
	'smw-paramdesc-embedonly' => 'Non mostrar as cabeceiras',
	'smw-paramdesc-table-class' => 'Unha clase CSS adicional que establecer para a táboa',
	'smw-paramdesc-rdfsyntax' => 'A sintaxe de RDF a usar',
	'smw-paramdesc-csv-sep' => 'O separador a empregar',
	'smw-paramdesc-dsv-separator' => 'O separador a empregar',
	'smw-paramdesc-dsv-filename' => 'O nome para o ficheiro DSV',
	'smw-smwdoc-description' => 'Mostra unha táboa de todos os parámetros que se poden empregar para un formato de resultados especificado xunto aos valores por defecto e descricións.',
	'smw-smwdoc-par-format' => 'O formato dos resultados do que mostrar a documentación do parámetro.',
	'smw-smwdoc-par-parameters' => 'Os parámetros que mostrar. "specific" para aqueles engadidos polo formato, "base" para aqueles dispoñibles en todos os formatos e "all" para ambos.',
	'smw-paramdesc-sort' => 'Propiedade a partir da que ordenar a pescuda',
	'smw-paramdesc-order' => 'Orde da ordenación da pescuda',
	'smw-paramdesc-searchlabel' => 'Texto para continuar a procura',
	'smw-paramdesc-named_args' => 'Dea nome aos argumentos que se lle pasan ao modelo',
	'smw-paramdesc-export' => 'Opción de exportación',
	'smw-paramdesc-prettyprint' => 'Unha saída cun formato xeitoso que mostra sangrías e liñas novas adicionais',
	'smw-paramdesc-source' => 'Fonte alternativa de pescuda',
	'smw-paramdesc-jsonsyntax' => 'Sintaxe JSON a utilizar',
	'smw-printername-feed' => 'Fonte de novas RSS e Atom',
	'smw-paramdesc-feedtype' => 'Tipo de fonte de novas',
	'smw-paramdesc-feedtitle' => 'O texto a usar como título da fonte de novas',
	'smw-paramdesc-feeddescription' => 'O texto a usar como descrición da fonte de novas',
	'smw-paramdesc-feedpagecontent' => 'Contido da páxina a mostrar coa fonte de novas',
	'smw-label-feed-description' => 'Fonte de novas $1 $2',
	'smw_iq_disabled' => 'As preguntas semánticas están deshabilitadas neste wiki.',
	'smw_iq_moreresults' => '… máis resultados',
	'smw_parseerror' => 'O valor dado non foi entendido.',
	'smw_notitle' => '"$1" non pode usarse como nome de páxina neste wiki.',
	'smw_noproperty' => '"$1" non pode usarse como nome de propiedade neste wiki.',
	'smw_wrong_namespace' => 'Aquí só están permitidas as páxinas no espazo de nomes "$1".',
	'smw_manytypes' => 'Máis dun tipo definido para a propiedade.',
	'smw_emptystring' => 'As cordas baleiras non están aceptadas.',
	'smw_maxstring' => 'A representación da corda $1 é demasiado longa.',
	'smw_notinenum' => '"$1" non é a lista de posibles valores ($2) para esta propiedade.',
	'smw_noboolean' => '"$1" non é recoñecido como un valor booleano (verdadeiro/falso).',
	'smw_true_words' => 'verdadeiro,v,si,s',
	'smw_false_words' => 'falso,f,non,n',
	'smw_nofloat' => '"$1" non é un número.',
	'smw_infinite' => 'Os números tan longos como "$1" non están soportados.',
	'smw_unitnotallowed' => '"$1" non está declarada como unha unidade de medida válida para esta propiedade.',
	'smw_nounitsdeclared' => 'Non hai unidades de medida declaradas para esta propiedade.',
	'smw_novalues' => 'Non se especificou ningún valor.',
	'smw_nodatetime' => 'A data "$1" non foi entendida.',
	'smw_toomanyclosing' => 'Parece que hai demasiados acontecementos de "$1" na pregunta.',
	'smw_noclosingbrackets' => 'Algún uso de "<nowiki>[[</nowiki>" na súa pregunta non foi pechado polo seu "]]" correspondente.',
	'smw_misplacedsymbol' => 'O símbolo "$1" foi usado nun lugar no que non era útil.',
	'smw_unexpectedpart' => 'A parte "$1" da pregunta non foi entendida.
Pode que os resultados non sexan os agardados.',
	'smw_emptysubquery' => 'Algunha subcuestión non ten unha condición válida.',
	'smw_misplacedsubquery' => 'Algunha subcuestión foi usada nun lugar onde non están permitidas.',
	'smw_valuesubquery' => 'As subcuestións non están soportadas para os valores da propiedade "$1".',
	'smw_badqueryatom' => 'Unha parte "<nowiki>[[…]]</nowiki>" da pregunta non foi entendida.',
	'smw_propvalueproblem' => 'O valor da propiedade "$1" non foi entendido.',
	'smw_noqueryfeature' => 'Algunha característica da pregunta non está soportada neste wiki, polo que unha parte foi excluída ($1).',
	'smw_noconjunctions' => 'As conxuncións nas preguntas non están soportadas neste wiki, polo que unha parte foi excluída ($1).',
	'smw_nodisjunctions' => 'Non están soportadas as disxuncións nas preguntas neste wiki e parte desta foi ignorada ($1).',
	'smw_querytoolarge' => 'As seguintes condicións da pregunta non poden ser consideradas debido ás restricións do wiki no tamaño ou profundidade desta: $1.',
	'smw_notemplategiven' => 'Por favor, proporcione un valor para o parámetro “modelo” do formato desta pregunta para poder funcionar.',
	'smw_db_sparqlqueryproblem' => 'Non se puideron obter os resultado da pescuda da base de datos SPARQL. Este erro pode ser temporal ou indicar un erro no programa da base de datos.',
	'smw_db_sparqlqueryincomplete' => 'Resultou demasiado difícil responder á pescuda e cancelouse. É probable que falten algúns resultados. Se fose posible, intente facer unha consulta máis sinxela.',
	'smw_type_header' => 'Propiedades do tipo "$1"',
	'smw_typearticlecount' => 'Mostrando $1 {{PLURAL:$1|propiedade|propiedades}} que {{PLURAL:$1|usa|usan}} este tipo.',
	'smw_attribute_header' => 'Páxinas que usan a propiedade "$1"',
	'smw_attributearticlecount' => 'Mostrando $1 {{PLURAL:$1|páxina|páxinas}} que {{PLURAL:$1|usa|usan}} esta propiedade.',
	'smw_subproperty_header' => 'Subpropiedades',
	'smw_subpropertyarticlecount' => 'Esta propiedade ten {{PLURAL:$1|a seguinte subpropiedade|as seguintes $1 subpropiedades}}:',
	'smw_concept_header' => 'Páxinas do concepto "$1"',
	'smw_conceptarticlecount' => 'Mostrando $1 {{PLURAL:$1|páxina|páxinas}} que {{PLURAL:$1|pertence|pertencen}} a ese concepto.',
	'exportrdf' => 'Exportar páxinas a RDF',
	'smw_exportrdf_docu' => 'Esta páxina permítelle obter datos dunha páxina en formato RDF.
Para exportar páxinas, insira os títulos na caixa de embaixo (un título por liña).',
	'smw_exportrdf_recursive' => 'Exportar igualmente todas as páxinas relacionadas.
Déase conta de que o resultado pode ser longo!',
	'smw_exportrdf_backlinks' => 'Exportar tamén todas as páxinas que se refiren ás páxinas exportadas.
Xera un RDF que se pode navegar.',
	'smw_exportrdf_lastdate' => 'Non exportar páxina que non tiveron cambios desde a data dada.',
	'smw_exportrdf_submit' => 'Exportar',
	'uriresolver' => 'Solucionador de URI',
	'properties' => 'Propiedades',
	'smw_properties_docu' => 'Este wiki usa as seguintes propiedades.',
	'smw_property_template' => '"$1" de tipo "$2" ($3 {{PLURAL:$3|uso|usos}})',
	'smw_property_template_notype' => '$1 ($2)',
	'smw_propertylackspage' => 'Todas as propiedades deberían estar descritas nunha páxina!',
	'smw_propertylackstype' => 'Non foi especificado ningún tipo para esta propiedade (asúmese o tipo "$1" polo de agora).',
	'smw_propertyhardlyused' => 'Esta propiedade apenas ten uso neste wiki!',
	'unusedproperties' => 'Propiedades non usadas',
	'smw_unusedproperties_docu' => 'As seguintes propiedades existen aínda que ningunha páxina faga uso delas.',
	'smw_unusedproperty_template' => '"$1" de tipo "$2"',
	'wantedproperties' => 'Propiedades requiridas',
	'smw_wantedproperties_docu' => 'As seguintes propiedades teñen uso no wiki, pero aínda non contan con ningunha páxina que as describa.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'smw_purge' => 'Refrescar',
	'types' => 'Tipos',
	'smw_types_docu' => 'O que segue é unha lista de todos os tipos de datos que poden ser asignados ás propiedades.',
	'semanticstatistics' => 'Estatísticas semánticas',
	'smw_semstats_text' => "Este wiki contén '''$1''' {{PLURAL:$1|valor|valores}} de propiedade, dun total {{PLURAL:$2|'''dunha'''|de '''$2'''}} [[Special:Properties|{{PLURAL:$2|propiedade|propiedades diferentes}}]].
'''$3''' {{PLURAL:$3|propiedade ten|propiedades teñen}} unha páxina propia e o tipo de datos desexado está especificado para '''$4''' de elas.
Algunhas das propiedades existentes poden [[Special:UnusedProperties|non ser usadas]].
As propiedades ás que aínda lles falta unha páxina atópanse na [[Special:WantedProperties|lista de propiedades desexadas]].",
	'smw_uri_doc' => 'O solucionador de URI pon en práctica o <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">descubrimento da ETIQUETA de W3C en httpRange-14</a>. Vixía que os humanos non entren en sitios web.',
	'ask' => 'Procura semántica',
	'smw_ask_sortby' => 'Ordenar por columnas (opcional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Atopar os resultados',
	'smw_ask_editquery' => '[Editar a pregunta]',
	'smw_add_sortcondition' => '[Engadir unha condición de ordenación]',
	'smw_ask_hidequery' => 'Agochar a pescuda',
	'smw_ask_help' => 'Axuda sobre as pescudas',
	'smw_ask_queryhead' => 'Pescuda',
	'smw_ask_printhead' => 'Datos adicionais a mostrar',
	'smw_ask_printdesc' => '(engada un nome de propiedade por liña)',
	'smw_ask_format_as' => 'Formato de:',
	'smw_ask_defaultformat' => 'predeterminado',
	'smw_ask_otheroptions' => 'Outras opcións',
	'smw-ask-otheroptions-info' => 'Esta sección contén opcións que alteran os formatos de saída. As descricións dos parámetros pódense consultar pasando o rato por riba delas.',
	'smw-ask-otheroptions-collapsed-info' => 'Use a icona do signo máis para ollar todas as opcións dispoñibles',
	'smw_ask_show_embed' => 'Mostrar o código incrustado',
	'smw_ask_hide_embed' => 'Agochar o código incrustado',
	'smw_ask_embed_instr' => 'Para incrustar esta pescuda en liña nunha páxina wiki use o seguinte código.',
	'smw-ask-delete' => '[Borrar]',
	'smw-ask-sorting' => 'Ordenación',
	'smw-ask-format-selection-help' => 'Para ler unha descrición detallada visite a páxina de axuda $1.',
	'querycreator' => 'Creador de consultas',
	'smw_qc_addmainlabel' => 'Engadir a etiqueta principal',
	'smw_qc_show_addnal_opts' => 'Mostrar máis opcións',
	'smw_qc_hide_addnal_opts' => 'Mostrar menos opcións',
	'smw_qc_otheropt' => 'Outras opcións',
	'smw_qc_intro' => 'Introdución:',
	'smw_qc_outro' => 'Outro:',
	'smw_qc_default' => 'Por defecto:',
	'smw_qc_formatopt' => 'Opcións de formato',
	'smw_qc_query_help' => 'Introduza unha consulta utilizando o seguinte formulario. Seleccione páxinas wiki baseadas en
categorías (<strong><nowiki>por exemplo, [[Categoría:Actor]]</nowiki></strong>),
propiedades (<strong><nowiki>por exemplo, [[Localizado en::Alemaña]]</nowiki></strong>),
nomes (<strong><nowiki>por exemplo, [[Alemaña]]</nowiki></strong>) e
espazos de nomes (<strong><nowiki>por exemplo, [[Axuda:+]]</strong>)',
	'smw_qui_property' => '<strong>Propiedade</strong>',
	'smw_qui_prop' => 'Propiedade:',
	'smw_qui_labl' => 'Etiqueta:',
	'smw_qui_formt' => 'Formato:',
	'smw_qui_limt' => 'Límite:',
	'smw_qui_shownresults' => 'mostrar nos resultados',
	'smw_qui_noquery' => 'Non se especificou ningunha pescuda',
	'smw_qui_invalidprop' => '"$1" pode ​​non ser unha propiedade válida',
	'smw_qui_invalidformat' => 'O formato escollido, "$1", non existe neste wiki',
	'smw_qui_nosort' => 'Sen orde',
	'smw_qui_ascorder' => 'Ascendente',
	'smw_qui_descorder' => 'Descendente',
	'smw_qui_randorder' => 'Ao chou',
	'smw_qui_addnprop' => 'engadir unha propiedade',
	'smw_qui_delete' => 'Eliminar',
	'smw_qui_rescol' => 'Coincidencias',
	'smw_qui_options' => 'opcións',
	'smw_qui_addcategory' => 'engadir unha categoría',
	'smw_qui_addrescol' => 'engadir as coincidencias',
	'smw_qui_ok' => 'Aceptar',
	'smw_qui_cancel' => 'Cancelar',
	'smw_qui_category' => '<strong>Categoría</strong>',
	'smw_qui_label' => 'Etiqueta',
	'smw_prp_options' => 'Opcións da propiedade',
	'smw_qui_catopts' => 'Opcións da categoría',
	'smw_qui_mainlabopts' => 'Opcións dos resultados',
	'smw_qui_dlabel' => 'Etiqueta:',
	'smw_qui_dcategory' => 'Categoría:',
	'smw_qui_dcatyes' => 'Mostrar o texto cando a categoría estea presente:',
	'smw_qui_dcatno' => 'Mostrar o texto cando a categoría estea ausente:',
	'searchbyproperty' => 'Procurar por propiedade',
	'smw_sbv_docu' => 'Procurar por todas as páxinas que teñen a propiedade e o valor dados.',
	'smw_sbv_novalue' => 'Por favor, insira un valor válido para a propiedade ou vexa todos os valores das propiedades para "$1".',
	'smw_sbv_displayresult' => 'Unha lista de todas as páxinas que teñen a propiedade "$1" co valor "$2"',
	'smw_sbv_displayresultfuzzy' => 'Unha lista con todas as páxinas que teñen a propiedade "$1" co valor "$2".
Como houbo só uns poucos resultados, móstranse tamén os resultados próximos.',
	'smw_sbv_property' => 'Propiedade:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Atopar os resultados',
	'browse' => 'Explorar o wiki',
	'smw_browselink' => 'Explorar as propiedades',
	'smw_browse_article' => 'Insira o nome da páxina para comezar a navegación.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'mostrar as propiedades que ligan cara a aquí',
	'smw_browse_hide_incoming' => 'agochar as propiedades que ligan cara a aquí',
	'smw_browse_no_outgoing' => 'Esta páxina non ten propiedades.',
	'smw_browse_no_incoming' => 'Ningunha propiedade liga con esta páxina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiqueta da propiedade inversa',
	'pageproperty' => 'Procura de propiedades de páxinas',
	'smw_pp_docu' => 'Procurar por todos os valores dunha propiedade nunha páxina dada.
Insira tanto a páxina como a propiedade.',
	'smw_pp_from' => 'Da páxina',
	'smw_pp_type' => 'Propiedade',
	'smw_pp_submit' => 'Atopar os resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Seguinte',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Non hai resultados.',
	'smwadmin' => 'Funcións do administrador Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'O motor de almacenamento foi configurado con éxito.',
	'smw_smwadmin_return' => 'Volver a "$1"',
	'smw_smwadmin_updatestarted' => 'Comezou un novo proceso de actualización para refrescar os datos semánticos.
Todos os datos almacenados serán reconstruídos ou reparados onde sexa necesario.
Pode seguir o proceso da actualización nesta páxina especial.

Volver a "$1".',
	'smw_smwadmin_updatenotstarted' => 'Xa hai un proceso de actualización en curso.
Non se pode crear outro.

Volver a "$1".',
	'smw_smwadmin_updatestopped' => 'Todos os procesos de actualización existentes foron detidos.

Volver a "$1".',
	'smw_smwadmin_updatenotstopped' => 'Para deter os procesos de actualización actuais, debe activar a caixa de verificación para indicar que está seguro de facelo.

Volver a "$1".',
	'smw_smwadmin_docu' => 'Esta páxina especial axúdarao durante a instalación e actualización do <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Lembre facer unha copia de seguranza dos datos antes de executar funcións administrativas.',
	'smw_smwadmin_db' => 'Instalación e actualización da base de datos',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki require algunhas extensións da base de datos MediaWiki para almacenar os datos semánticos.
A función de embaixo asegúrase de que a súa base de datos está configurada apropiadamente.
Os cambios feitos neste paso non afectarán ao resto da base de datos MediaWiki, e poden ser desfeitos de xeito sinxelo se se desexa.
Esta función de configuración pode ser executada múltiples veces sen facer ningún dano, pero só é necesaria unha vez na instalación ou actualización.',
	'smw_smwadmin_permissionswarn' => 'Se a operación falla con erros SQL, probablemente a base de datos empregada polo seu wiki (comprobe o seu LocalSettings.php) non teña os permisos suficientes.
Fai falla conceder a este usuario os permisos para crear e eliminar táboas; temporalmente insira o rexistro da súa base de datos en LocalSettings.php ou use a escritura de mantemento <tt>SMW_setup.php</tt>, que pode usar as credenciais dun usuario SysOp.',
	'smw_smwadmin_dbbutton' => 'Inicialice ou actualice as táboas',
	'smw_smwadmin_announce' => 'Anunciar o seu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki ten un servizo web para anunciar novos wikis semánticos.
Isto é usado para manter unha lista de sitios públicos que usan Semantic MediaWiki, principalmente para axudar ao <a href="http://semantic-mediawiki.org/wiki/SMW_Project">proxecto Semantic MediaWiki</a> para obter unha vista xeral dos usos típicos de Semantic MediaWiki.
Vaia á páxina principal de Semantic MediaWiki para <a href="http://semantic-mediawiki.org/wiki/Registry">obter máis información acerca deste servizo</a>.',
	'smw_smwadmin_announcebutton' => 'Prema o seguinte botón para enviar o enderezo URL do seu wiki a ese servizo.
O servizo non rexistrará wikis que non sexan publicamente accesibles e só almacenará información publicamente accesible.',
	'smw_smwadmin_datarefresh' => 'Reparación e actualización dos datos',
	'smw_smwadmin_datarefreshdocu' => 'É posible restaurar todos os datos de Semantic MediaWiki baseados nos contidos actuais do wiki.
Isto pode ser útil para reparar datos rotos ou para refrescar os datos se o formato interno cambiou debido a actualizacións do software.
Esta actualización é executada páxina a páxina e non será completada inmediatamente.
O seguinte amosa se unha actualización está en curso e permítelle comezalas ou detelas (a non ser que esta característica fose deshabilitada polo administrador do sitio).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Xa hai unha actualización en curso.</strong>
É normal que os progresos de actualización vaian lentos, xa que só se refrescan os datos nos pequenos anacos nos que un usuario accede ao wiki.
Para finalizar esta actualización máis rápido, pode invocar a escritura <tt>runJobs.php</tt> de mantemento de MediaWiki (use a opción <tt>--maxjobs 1000</tt> para restrinxir o número de actualizacións feitas nunha quenda).
Progreso estimado da actualización actual:',
	'smw_smwadmin_datarefreshbutton' => 'Comezar a actualizar os datos',
	'smw_smwadmin_datarefreshstop' => 'Deter esta actualización',
	'smw_smwadmin_datarefreshstopconfirm' => 'Si, estou seguro.',
	'smw_smwadmin_support' => 'Obtendo a asistencia',
	'smw_smwadmin_supportdocu' => 'Diversas fontes poden axudalo en caso de problemas:',
	'smw_smwadmin_installfile' => 'Se experimenta problemas durante a súa instalación, comece comprobando a guía no <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">ficheiro INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'A documentación do usuario completa de Semantic MediaWiki está en <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Pode informar dos erros en <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Se ten máis preguntas ou suxestións, únase á conversa no <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">foro de usuarios de Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Estrutura dos datos',
	'smw_adminlinks_displayingdata' => 'Mostrando os datos',
	'smw_adminlinks_inlinequerieshelp' => 'Axuda coas pescudas',
	'smw-createproperty-isproperty' => 'Esta é unha propiedade de clase $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|O valor permitido|Os valores permitidos}} para esta propiedade {{PLURAL:$1|é|son}}:',
	'smw-paramdesc-category-delim' => 'O delimitador',
	'smw-paramdesc-category-template' => 'Un modelo co que dar formato aos elementos',
	'smw-paramdesc-category-userparam' => 'Un parámetro que pasar ao modelo',
	'smw-info-par-message' => 'A mensaxe a mostrar.',
	'smw-info-par-icon' => 'A icona a mostrar; ou ben "info" ou ben "warning".',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Opcións de procura semántica',
	'smw-prefs-intro-text' => '[http://semantic-mediawiki.org/?uselang=gl Semantic MediaWiki] (ou as extensións relacionadas) proporcionan as opcións inferiores para activar a personalización individual nas funcións seleccionadas. Para atopar máis información consulte esta [http://semantic-mediawiki.org/wiki/Help:User_preferences?uselang=gl sección de axuda].',
	'smw-prefs-ask-options-tooltip-display' => 'Mostrar o texto do parámetro como axuda informativa',
	'smw-prefs-ask-options-collapsed-default' => 'Activar a contracción da caixa de opcións por defecto',
	'smw-ui-tooltip-title-property' => 'Propiedade',
	'smw-ui-tooltip-title-quantity' => 'Cantidade',
	'smw-ui-tooltip-title-info' => 'Información',
	'smw-ui-tooltip-title-service' => 'Ligazóns de servizo',
	'smw-ui-tooltip-title-warning' => 'Erro',
	'smw-ui-tooltip-title-parameter' => 'Parámetro',
	'smw-ui-tooltip-title-event' => 'Evento',
	'smw_unknowntype' => 'O tipo desta propiedade non é válido',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'smw_finallistconjunct' => ', καὶ',
	'smw_printername_template' => 'Πρότυπον',
	'smw_nofloat' => 'Τὸ "$1" οὐκ ἔστιν ἀριθμός.',
	'smw_exportrdf_submit' => 'Ἐξάγειν',
	'properties' => 'Ἰδιότητες',
	'types' => 'Τύποι',
	'smw_ask_queryhead' => 'Πεῦσις',
	'smw_ask_format_as' => 'Μορφοποιεῖν ὡς:',
	'smw_ask_defaultformat' => 'προκαθωρισμένη',
	'smw_sbv_property' => 'Ἰδιότης:',
	'smw_sbv_value' => 'Τιμή:',
	'smw_browselink' => 'Ἲδιότηται πλοηγήσεως',
	'smw_browse_go' => 'Ἱέναι',
	'smw_inverse_label_default' => '$1 τοῦ',
	'smw_pp_type' => 'Ἰδιότης',
	'smw_result_prev' => 'Προηγουμέναι',
	'smw_result_next' => 'Ἑπόμεναι',
	'smw_result_noresults' => 'Οὐδὲν ἀποτέλεσμα.',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'smw-desc' => "Dyy Wiki zuegängliger mache - fir Maschine ''un'' Mänsche ([http://semantic-mediawiki.org/wiki/Help:User_manual online-Dokumäntation])",
	'smw_viewasrdf' => 'RDF-Feed',
	'smw_finallistconjunct' => ' un',
	'smw_factbox_head' => 'Fakte zue $1',
	'smw_isspecprop' => 'Die Eigeschaft isch e Spezialeigeschaft in däm Wiki.',
	'smw_concept_description' => 'Bschryybig vum Konzäpt „$1“',
	'smw_no_concept_namespace' => "Konzäpt chenne nume im ''Konzäpt:'' Namensruum aagleit wäre.",
	'smw_multiple_concepts' => 'In jedwädere Konzäptsyte cha s nume ei Konzäptdefinition din haa.',
	'smw_concept_cache_miss' => 'S Konzäpt „$1“ cha im Momänt nit aagwändet wäre, wel d Wiki-Konfiguration offline grächnet muess wäre.
Wänn s Probläm imfall noch eme Rung nit verschwindet, no bitt Dyy Syteverwalter, des Konzäpt megli z mache.',
	'smw_noinvannot' => 'Wärt chenne nit mit umgchehrte Eigeschafte gchännzeichnet wäre',
	'version-semantic' => 'Semantischi Erwyterige',
	'smw_baduri' => 'URI mit dr Form „$1“ sin nit zuelässig.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Zellerergebnis',
	'smw_printername_csv' => 'CSV-Export',
	'smw_printername_dsv' => 'DSV-Export',
	'smw_printername_debug' => 'Debug-Abfrog (fir Experte)',
	'smw_printername_embedded' => 'Inhalt vu yyböute Syte',
	'smw_printername_json' => 'JSON-Export',
	'smw_printername_list' => 'Lischt',
	'smw_printername_ol' => 'Uflischtig',
	'smw_printername_ul' => 'Ufgliderig',
	'smw_printername_rss' => 'RSS-Export',
	'smw_printername_table' => 'Tabälle',
	'smw_printername_broadtable' => 'Breiti Tabälle',
	'smw_printername_template' => 'Vorlag',
	'smw_printername_rdf' => 'RDF-Export',
	'smw-paramdesc-limit' => 'Di maximal Aazahl vu Ergebnis, wu zruck gee solle wäre',
	'smw-paramdesc-headers' => 'Chopfzyyle bzw. d Nämme vu dr Eigeschafte aazeige',
	'smw-paramdesc-mainlabel' => 'S Label vu Hauptsytename',
	'smw-paramdesc-link' => 'Wärt as Links aazeige',
	'smw-paramdesc-intro' => 'Dr Text, wu vor dr Suechergebnis soll aazeigt wäre, wänn s het',
	'smw-paramdesc-outro' => 'Dr Text, wu no dr Suechergebnis soll aazeigt wäre, wänn s het',
	'smw-paramdesc-default' => 'Dr Text, wu soll aazeigt wäre, wänn s kei Suechergebnis het',
	'smw-paramdesc-sep' => 'S Trännzeiche fir Wärt',
	'smw-paramdesc-template' => 'Dr Name vu dr Vorlag, wu Uusdruck dermit solle aazeigt wäre',
	'smw-paramdesc-columns' => 'D Aazahl vu dr Spalte go Ergebnis aazeige (Standard isch $1)',
	'smw-paramdesc-userparam' => 'E Wärt, wu bi jedem Vorlageufruef ibergee wird, wänn e Vorlag brucht wird',
	'smw-paramdesc-introtemplate' => 'Dr Vorlagename, wu vor dr Abfrogergebnis aazeigt wird, wänn s git',
	'smw-paramdesc-outrotemplate' => 'Dr Vorlagename, wu no dr Abfrogergebnis soll aazeigt wäre, wänn s het',
	'smw-paramdesc-embedformat' => 'Dr HTML-Befähl zum Iberschrifte definiere',
	'smw-paramdesc-embedonly' => 'Kei Iberschrifte aazeige',
	'smw-paramdesc-rsstitle' => 'Dr Text, wu as Titel fir dr Kanal soll brucht wäre',
	'smw-paramdesc-rssdescription' => 'Dr Text, wu as Bschryybig fir dr Kanal soll brucht wäre',
	'smw-paramdesc-rdfsyntax' => 'D RDF-Syntax, wu brucht wäre soll',
	'smw-paramdesc-csv-sep' => 'Trännzeiche, wu sott brucht wäre',
	'smw-paramdesc-dsv-separator' => 'Trännzeiche, wu sott brucht wäre',
	'smw-paramdesc-dsv-filename' => 'Dr Name fir d DSV-Datei',
	'smw-paramdesc-searchlabel' => 'De Teggst für de Link zue de Ergebniss', # Fuzzy
	'smw_iq_disabled' => 'Semantischi Aafroge sin in däm Wiki zur Zyt nit megli.',
	'smw_iq_moreresults' => '… meh Ergebniss',
	'smw_parseerror' => 'Dr Wärt, wu Du yygee hesch, isch nit verstande wore.',
	'smw_notitle' => '„$1“ cha nit as Sytename in däm Wiki bruucht wäre.',
	'smw_wrong_namespace' => 'Nume Syten im Namensruum „$1“ sin doo zuelässig.',
	'smw_manytypes' => 'In dr Eigeschaft sin e paar Datetype zuegwise wore.',
	'smw_emptystring' => 'Lääri Zeichefolge wäre nit akzeptiert.',
	'smw_maxstring' => 'D Zeichechette „$1“ isch z lang.',
	'smw_notinenum' => '„$1“ ghert nit zue dr meglige Wärt vu däre Eigeschaft ($2).',
	'smw_noboolean' => '„$1“ isch kei Wohretswärt (wohr/falsch).',
	'smw_true_words' => 'wohr,w,jo,j',
	'smw_false_words' => 'falsch,f,nei,n',
	'smw_nofloat' => '„$1“ isch kei Zahl.',
	'smw_infinite' => 'D Zahl „$1“ isch z lang.',
	'smw_novalues' => 'Kei Wärt spezifiziert.',
	'smw_nodatetime' => 'S Datum „$1“ isch nit verstande wore.',
	'smw_toomanyclosing' => 'In dr Aafrog chemme z vyyl „$1“ vor.',
	'smw_noclosingbrackets' => 'In dr Aafrog chunnt e „<nowiki>[[</nowiki>“ vor, isch aber nit mit eme „]]“ abgschlosse.',
	'smw_misplacedsymbol' => 'S Symbol „$1“ isch an ere Stell bruucht wore, wu s nit sinnvoll isch.',
	'smw_unexpectedpart' => 'Dr Teil „$1“ vu dr Aafrog isch nit verstande wore. D Ergebnis sin villicht nit wie s erwartet woren isch.',
	'smw_emptysubquery' => 'In ere Teilaafrog het s kei Bedingig.',
	'smw_misplacedsubquery' => 'E Teilaafrog isch an ere Stell bruucht wore, wu keini Teilaafroge derfe vorchu.',
	'smw_valuesubquery' => 'Teilaafroge wäre fir Wärt vudr Eigeschaft „$1“ nit unterstitzt.',
	'smw_badqueryatom' => 'E Teil „<nowiki>[[…]]</nowiki>“ vu dr Aafrog isch nit verstande wore.',
	'smw_propvalueproblem' => 'Dr Wärt vu dr Eigeschaft „$1“ isch nit verstande wore.',
	'smw_noqueryfeature' => 'E Teil Aafrog-Feature sin im Momänt mit däm Wiki nit megli un dää Teil vu dr Frog isch glescht wore ($1).',
	'smw_noconjunctions' => 'UND-Verchnipfige in dr Aafroge wäre in däm Wiki nit unterstitzt un dää Teil vu dr Aafrog isch glescht wore ($1).',
	'smw_nodisjunctions' => 'ODER-Verchnipfige wäre in däm Wiki nit unterstitzt un e Teil vu dr Aafrog isch glescht wore ($1).',
	'smw_querytoolarge' => 'Die Aafrogbedingige chenne für Greßi un Tiefi vu Aafroge nit berucksichtigt wäre wäge dr Beschränkige, wu in däm Wiki giltig sin: $1.',
	'smw_notemplategiven' => 'Ass die Aafrog cha bearbeitet wäre, muess im Parameter „template“ e Wärt yytrage syy.',
	'smw_type_header' => 'Eigeschafte mit em Datetyp „$1“',
	'smw_typearticlecount' => 'S {{PLURAL:$1|wird ei Eigeschaft|wäre $1 Eigeschafte}} mit däm Datetyp aazeigt:',
	'smw_attribute_header' => 'Syte mit dr Eigeschaft „$1“',
	'smw_attributearticlecount' => 'S {{PLURAL:$1|wird ei Syten|wäre $1 Syten}} aazeigt, wu die Eigeschaft {{PLURAL:$1|bruucht|bruuche}}:',
	'smw_subproperty_header' => 'Untereigeschafte',
	'smw_subpropertyarticlecount' => 'Die Eigeschaft het {{PLURAL:$1|die Untereigeschaft|die $1 Untereigeschafte}}:',
	'smw_concept_header' => 'Syte vum Konzäpt „$1“',
	'smw_conceptarticlecount' => 'S {{PLURAL:$1|wird ei Syten|wäre $1 Syten}} aazeigt, wu zue däm Konzäpt {{PLURAL:$1|ghert|ghere}}:',
	'exportrdf' => 'Syten as RDF exportiere',
	'smw_exportrdf_docu' => 'Doo chenne Informationen iber einzelni Syten im RDF-Format abgruefe wäre. Bitte gib d Name vu dr Syte  <i>zyylewyys</i> yy.',
	'smw_exportrdf_recursive' => 'Exportier au alli relevante Syte rekursiv. Dänk dra, ass d Ergebnis chenne arg groß syy!',
	'smw_exportrdf_backlinks' => 'Exportier au alli Syte, wu uf exportierti Syte verwyye. Leit e RDF aa, wu lyychter cha dursuecht wäre.',
	'smw_exportrdf_lastdate' => 'Exportier keini Syte, wu nimi gänderet wore sin syt em Zytpunkt, wu aagee isch.',
	'smw_exportrdf_submit' => 'Exportiere',
	'uriresolver' => 'URI-Ufleser',
	'properties' => 'Eigeschafte',
	'smw_properties_docu' => 'In däm Wiki git s die Eigeschafte:',
	'smw_property_template' => '$1 mit Datetyp $2 ($3)',
	'smw_propertylackspage' => 'Alli Eigeschafte sotte uf ere Syte bschribe syy!',
	'smw_propertylackstype' => 'Fir die Eigeschaft isch kei Datetyp aagee wore ($1 wird vorerscht as Typ aagnuh).',
	'smw_propertyhardlyused' => 'Die Eigeschaft wird im Wiki chuum bruucht!',
	'unusedproperties' => 'Verwaisti Eigeschafte',
	'smw_unusedproperties_docu' => 'Die Eigeschafte git s, trotz ass si nit bruucht wäre.',
	'smw_unusedproperty_template' => '$1 mit Datetyp $2',
	'wantedproperties' => 'Gwinschti Eigeschafte',
	'smw_wantedproperties_docu' => 'Die Attribut wäre no uf keinere Syte bschribe, trotz ass si scho in däm Wiki bruucht wäre.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|Vorchu|Vorchu}})',
	'smw_purge' => 'nej lade',
	'types' => 'Datetype',
	'smw_types_docu' => 'Die Datetype chenne Eigeschafte zuegwise wäre. E jede Datetyp het e eigeni Syte, wu gnaueri Informatione druf chenne yytrage wäre.', # Fuzzy
	'semanticstatistics' => 'Statischtik iber semantischi Date',
	'smw_semstats_text' => "In däm Wiki {{PLURAL:$1|isch '''1''' Wert|sin '''$1''' Wärt}} fir insgsamt '''$2''' [[Special:Properties|{{PLURAL:$2|Eigeschaft|verschideni Eigeschafte}}]] yygee wore. '''$3''' {{PLURAL:$3|Eigeschaft het|Eigeschafte hän}} e eigeni Syte un dr gwischt Datetyp isch fir '''$4''' vu däne aagee wore. E paar vo dr Eigeschafte, wu s het, chenne [[Special:UnusedProperties|verwaisti Eigeschafte]] syy. Eigeschafte, wu no ne Syte sott aagleit wäre derfir, sin in dr [[Special:WantedProperties|Lischt vu dr gwinschte Eigeschafte]] ufgfiert.",
	'smw_uri_doc' => 'Dr URI-Ufleser setzt d Empfählige »<a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>« um. Är sorgt defir, ass Mänsche nit zue Netzsyte wäre.',
	'ask' => 'Semantischi Suechi',
	'smw_ask_sortby' => 'Sortiere no Spalte (optional)',
	'smw_ask_ascorder' => 'Obsgi',
	'smw_ask_descorder' => 'Nidsgi',
	'smw_ask_submit' => 'Ergebnis finde',
	'smw_ask_editquery' => '[Aafrog bearbeite]',
	'smw_add_sortcondition' => '[Sortieraawyysig zuefiege]',
	'smw_ask_hidequery' => 'Aafrog uusblände',
	'smw_ask_help' => 'Hilf',
	'smw_ask_queryhead' => 'Aafrog',
	'smw_ask_printhead' => 'Zuesätzligi Aagabe, wu solle aazeigt wäre',
	'smw_ask_printdesc' => '(ei Eigeschaftsname je Zyyle yyfiege)',
	'smw_ask_format_as' => 'Formatiert as:',
	'smw_ask_defaultformat' => 'Standard',
	'smw_ask_otheroptions' => 'Andri Optione',
	'smw_ask_show_embed' => 'Yyböute Code zeige',
	'smw_ask_hide_embed' => 'Yyböute Code verstecke',
	'smw_ask_embed_instr' => 'Verwänd dää Code unte go die Abstimmig in e Wikisyte yyböue.',
	'searchbyproperty' => 'Iber e Eigeschaft sueche',
	'smw_sbv_docu' => 'Diese Spezialsyte findet alli Syte, wu e bstimmte Wärt hän fir d Eigeschaft, wu aagee woren isch.',
	'smw_sbv_novalue' => 'Bitte dr gwinscht Wärt yygee oder alli Wärte fir d Eigeschaft $1 aaluege.',
	'smw_sbv_displayresult' => 'E Lischt vu allene Syte, wu e Eigeschaft $1 mit em Wärt $2 hän.',
	'smw_sbv_displayresultfuzzy' => 'E Lischt vu allene Syte, wu d Eigeschaft „$1“ mit em Wärt „$2“ hän.
Wel nume wenig Ergebnis gfunde wore sin, wäre au ähnligi Wärt ufglischtet.',
	'smw_sbv_property' => 'Eigeschaft:',
	'smw_sbv_value' => 'Wärt:',
	'smw_sbv_submit' => 'Ergebnis finde',
	'browse' => 'Wiki browse',
	'smw_browselink' => 'Eigeschaften aazeige',
	'smw_browse_article' => 'Bitte gib dr Titel vun ere Syte yy.',
	'smw_browse_go' => 'Gang',
	'smw_browse_show_incoming' => 'zeig Eigeschafte, wu do druff verwyyse',
	'smw_browse_hide_incoming' => 'versteck Eigeschafte, wu do druff verwyyse',
	'smw_browse_no_outgoing' => 'Die Syte het kei Eigeschafte.',
	'smw_browse_no_incoming' => 'Kei Eigeschafte verwyyse uf die Syte.',
	'smw_inverse_label_default' => '$1 vu',
	'smw_inverse_label_property' => 'Umgchehrti Eigeschaftbezeichnig',
	'pageproperty' => 'Eigeschaftswärt vun ere Syte',
	'smw_pp_docu' => 'No allene Wärt sueche, wu e bstimmt Attribut fir d Syte hän, wu aagee woren isch. Gib e Syte un au ne Attribut yy.',
	'smw_pp_from' => 'Vu dr Syte',
	'smw_pp_type' => 'Eigeschaft',
	'smw_pp_submit' => 'Ergebnis aazeige',
	'smw_result_prev' => 'Zrugg',
	'smw_result_next' => 'Firschi',
	'smw_result_results' => 'Ergebnis',
	'smw_result_noresults' => 'Kei Ergebnis gfunde.',
	'smwadmin' => 'Admin-Funktione fir Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'D Spychereinheit isch erfolgryych yygrichtet wore.',
	'smw_smwadmin_return' => 'Zrugg zue $1',
	'smw_smwadmin_updatestarted' => 'E neje Update-Prozäss fir d Aktualisierig vu dr semantische Date isch gstartet wore.
Alli gspycherete Date wäre nej aagleit oder repariert, wänn netig.
Du chasch dr Fortschritt vum Update uf däre Spezialsyte verfolge.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'S lauft scho ne Update-Prozäss.
S wird kei neje aagfange.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Alli Aktualisierigsprozäss, wu s git, sin aaghalte wore.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Go Prozäss aahlate, wu am laufe sin, muesch Du s Kontrollchäschtli aktiviere zum aazeige, ass Du Dir wirkli sicher bisch.', # Fuzzy
	'smw_smwadmin_docu' => 'Die Spezialsyte hilft währed dr Installation un em Upgrade vu <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Dänk dra, wichtigi Date vor dr Uusfierig vu adminischtrative Funktione z sichere.',
	'smw_smwadmin_db' => 'Datebankinstallation un -aktualisierig',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki bruucht e paar Erwyterige an dr MediaWiki-Datebank go di semantische Date z spychere.
Die Funktion gwährleischtet, ass d Datebank richtig yygrichtet isch.
D Änderige, wu in däm Schritt gmacht wäre, stere dr Räscht vu dr MediaWiki-Datebank nit un chenne eifach zrugggsetzt wäre, wänn gwinscht.
Die Setup-Funktion cha e paar Mol uusgfiert wäre ohni Schade z verursache, s isch aber nume eimol netig bi dr  Installation oder em Update.',
	'smw_smwadmin_permissionswarn' => 'Wänn d Aktion mit eme SQL-Fähler abbricht, chennt s syy, ass dr Datebankbenutzer, wu s Wiki iber en uf d Datenbank zuegryft (lueg d Datei LocalSettings.php), nit d Rächt dezue het.
Go des Probläm lese  isch s megli, em Benutzer zuesätzligi Rächt fir s Aalege und Lesche vu Tabälle z gee, dr  Datebank-Adminischtrator zytwyys in d LocalSettings.php yyztrage oder s Wartigsskript <tt>SMW_setup.php</tt> z verwände, wu d Benutzerdate us AdminSettings.php cha verwände.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Tabällen initialisiere oder aktualisere',
	'smw_smwadmin_announce' => 'Dyy Wiki aachinde',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki het e Netzservice zum neji semantischi Wikisyte bekannt gee.
Dää Service wird bruucht go ne Lischt kriege, weli effentligi Syte Semantic MediaWiki bruuche, in dr Hauptsach aber zum im <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic-MediaWiki-Projäkt</a> e Iberbick iber typischi Aawändige vu  Semantic MediaWiki z gee.
Lueg d Semantic-MediaWiki-Homepage fir <a href="http://semantic-mediawiki.org/wiki/Registry">meh Informatione iber dää Service</a>.',
	'smw_smwadmin_announcebutton' => 'Druck dää Chnopf go d URL vu Dynem Wiki zue däm Dienscht zuefiege.
Dää Dienscht nimmt kei Wiki uf, wu nit efffentlig zuegängig sin. Gspycheret wäre au nume effentlig zuegängigi Informatione.',
	'smw_smwadmin_datarefresh' => 'Datereparatur un -aktualisierig',
	'smw_smwadmin_datarefreshdocu' => 'S isch megli alli Datebanke vu Semantic MediaWiki uf dr Grundlag vum aktuälle Inhalt vum Wiki widerhärzstelle.
Des cha hälfe, ne kaputti Datebank nej z lade oder Date z aktualisiere, wänn wägen eme Softwareupgrade d Datebankstruktur gänderet wore isch.
S Update wird fir jedi Syte uusgfiert un wird e Wyyli bruuche.
Doo wird zeigt, eb e Update lauft un Di wird erlaubt e Update z starte oder z stoppe (usser wänn die Funktion vum Sytebetryyber deaktiviert woren isch).',
	'smw_smwadmin_datarefreshprogress' => '<strong>E Update lauft scho.</strong>
E Update bruucht nromalerwyys lang, wel d Date nume in chleine Prtione aktualisiert wäre, jedes Mol wänn eber uf s Wiki zuegryft.
Go des Update schnäller z beände, cha mer s MediaWiki-Wartigsskript <tt>runJobs.php</tt> bruuche (mit em Parameter <tt>--maxjobs 1000</tt> cha d Aazahl vu dr Updates, wu uf eimol durgfiert wäre, bschränkt wäre).
Gschätzte Fortschritt vum Update, wu grad lauft:',
	'smw_smwadmin_datarefreshbutton' => 'Mit dr Datenaktualisierig aafange',
	'smw_smwadmin_datarefreshstop' => 'Mit däre Aktualisierig ufhere',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jo, ich bi mer sicher.',
	'smw_smwadmin_support' => 'Unterstitzig iberchu',
	'smw_smwadmin_supportdocu' => 'Verschideni Quälle hälfe Dir villicht bi me Problämfall:',
	'smw_smwadmin_installfile' => 'Wänn s Probläm mit dr Inschtallation git, chennt d Datei <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL</a> villicht wyterhälfe.',
	'smw_smwadmin_smwhomepage' => 'Di vollständig Benutzerdokumentation vu Semantic MediaWiki findsch uf <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Fähler chennte bi <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> berichtet wäre.',
	'smw_smwadmin_questions' => 'Wänn Du meh Frogen oder Vorschleg hesch, mach mit an dr Diskussion uf <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>.',
	'smw_adminlinks_datastructure' => 'Datestruktur',
	'smw_adminlinks_displayingdata' => 'Date abbilde',
	'smw_adminlinks_inlinequerieshelp' => 'Hilf fir Inline-Abfroge',
	'smw-createproperty-isproperty' => 'Des isch e Eigeschaft vum Typ $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Dr erlaubt Wärt fir die Eigeschaft isch|Di erlaubte Wärt fir die Eigeschaft sin}}:',
	'smw_unknowntype' => 'Imn dr Eigeschaft isch dr nit bekannt Datetyp „$1“ zuegwise wore.', # Fuzzy
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Inkbug
 * @author Rotemliss
 * @author Udi Oron אודי אורון
 * @author YaronSh
 * @author חיים
 */
$messages['he'] = array(
	'smw-desc' => 'הופכת את הוויקי שלכם לנגיש יותר – עבור מכונות וגם עבור בני אדם ([http://semantic-mediawiki.org/wiki/Help:User_manual תיעוד מקוון])',
	'smw_viewasrdf' => 'הזנת RDF',
	'smw_finallistconjunct' => ', וגם',
	'smw_factbox_head' => 'עובדות על $1',
	'smw_isspecprop' => 'זהו מאפיין מיוחד באתר ויקי זה.',
	'smw_concept_description' => 'תיאור הרעיון "$1"',
	'smw_no_concept_namespace' => 'ניתן להגדיר רעיונות רק בדפים שבמרחב השם Concept: .',
	'smw_multiple_concepts' => 'לכל דף רעיון יכולה להיות רק הגדרת רעיון אחת.',
	'smw_concept_cache_miss' => 'לא ניתן להשתמש ברעיון "$1" כרגע, כיוון שתצורת הוויקי דורשת את עיבודו באופן לא מקוון.
אם התקלה אינה נעלמת לאחר זמן מה, בקשו ממנהל האתר להפוך רעיון זה לזמין.',
	'smw_noinvannot' => 'ערכים אים יכולים להיות מושמים למאפיינים הפוכים.',
	'version-semantic' => 'הרחבות סמנטיות',
	'smw_baduri' => 'כתובות מהצורה "$1" אינן מורשות.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'ספירת התוצאות',
	'smw_printername_csv' => 'ייצוא ל־CVS',
	'smw_printername_dsv' => 'יצוא DSV',
	'smw_printername_debug' => 'חיפוש שגיאות (למומחים)',
	'smw_printername_embedded' => 'הטמעת תוכן הדף',
	'smw_printername_json' => 'ייצוא JSON',
	'smw_printername_list' => 'רשימה',
	'smw_printername_ol' => 'ספירה',
	'smw_printername_ul' => 'פירוט',
	'smw_printername_table' => 'טבלה',
	'smw_printername_broadtable' => 'טבלה רחבה',
	'smw_printername_template' => 'תבנית',
	'smw_printername_rdf' => 'יצוא RDF',
	'smw_printername_category' => 'קטגוריה',
	'smw-paramdesc-limit' => 'מספר התוצאות המרבי להחזרה',
	'smw-paramdesc-offset' => 'ההיסט של התוצאה הראשונה',
	'smw-paramdesc-headers' => 'הצגת הכותרות או שמות המאפיינים',
	'smw-paramdesc-mainlabel' => 'התווית שתינתן לשם הדף הראשי',
	'smw-paramdesc-link' => 'הצגת ערכים כקישורים',
	'smw-paramdesc-intro' => 'הטקסט להצגה לפני תוצאות התשאול, אם יש כאלו',
	'smw-paramdesc-outro' => 'הטקסט להצגה לאחר תוצאות התשאול, אם יש כאלו',
	'smw-paramdesc-default' => 'הטקסט להצגה אם אין תוצאות תשאול',
	'smw-paramdesc-sep' => 'המפריד בין הערכים',
	'smw-paramdesc-distribution' => 'במקום להציג את כל הערכים, לספור את המופעים שלהם ולהציג אותם.',
	'smw-paramdesc-distributionsort' => 'למיין את התפלגות הערכים לפי מניין המופעים.',
	'smw-paramdesc-distributionlimit' => 'להגביל את התפלגות הערכים לפי מניין של ערכים מסוימים בלבד.',
	'smw-paramdesc-template' => 'שם התבנית להצגת התדפיסים',
	'smw-paramdesc-columns' => 'מספר העמודות להצגת התוצאות (ברירת המחדל היא $1)',
	'smw-paramdesc-userparam' => 'הערך המועבר לכל קריאה לתבנית, אם נעשה שימוש בתבנית',
	'smw-paramdesc-introtemplate' => 'שם התבנית שתוצג לפני תוצאות השאילתה, אם יש תוצאות',
	'smw-paramdesc-outrotemplate' => 'שם התבנית שתוצג אחרי תוצאות השאילתה, אם יש תוצאות',
	'smw-paramdesc-embedformat' => 'תגית ה־HTML המשמשת להגדרת כותרות',
	'smw-paramdesc-embedonly' => 'לא יוצגו כותרות',
	'smw-paramdesc-table-class' => 'מחלקת CSS נוספת שתוחל על הטבלה',
	'smw-paramdesc-rdfsyntax' => 'באיזה תחביר RDF להשתמש',
	'smw-paramdesc-csv-sep' => 'תו הפרדה',
	'smw-paramdesc-dsv-separator' => 'באיזה תו הפרדה להשתמש',
	'smw-paramdesc-dsv-filename' => 'שם קובץ DSV',
	'smw-paramdesc-searchlabel' => 'טקסט עבור המשך החיפוש',
	'smw_iq_disabled' => 'שאילתות סמנטיות בוטלו באתר ויקי זה.',
	'smw_iq_moreresults' => '&hellip; תוצאות נוספות',
	'smw_parseerror' => 'הערך הניתן אינו ניתן לפענוח.',
	'smw_notitle' => 'לא ניתן להשתמש ב"$1" כשם לדף באתר ויקי זה.',
	'smw_noproperty' => 'המחרוזת "$1" לא יכולה להיות שם של מאפיין בוויקי הזה.',
	'smw_wrong_namespace' => 'רק דפים ממרחב השם "$1" מורשים כאן.',
	'smw_manytypes' => 'הוגדר יותר מסוג אחד למאפיין זה.',
	'smw_emptystring' => '[אופס! לא ניתן להשתמש כאן במחרוזות ריקות]',
	'smw_maxstring' => 'ייצוג המחרוזת $1 ארוך מדי.',
	'smw_notinenum' => '"$1" אינו אחד הערכים האפשריים ($2) למאפיין זה.',
	'smw_noboolean' => '[אופס! "$1" אינו מאפיין מסוג נכון-לאנכון]',
	'smw_true_words' => 'true,t,yes,y,כן,נכון,אמת,חיובי,כ',
	'smw_false_words' => 'false,f,no,n,לא,לא נכון,לא-נכון,ש,שקר,שלילי,ל',
	'smw_nofloat' => '"$1" אינו מספר.',
	'smw_infinite' => 'מספרים גדולים כמו "$1" אינם נתמכים.',
	'smw_unitnotallowed' => '"$1" אינה יחידה תקינה למדידת המאפיין הזה',
	'smw_nounitsdeclared' => 'לא הוגדרו יחידות מידה למאפיין הזה.',
	'smw_novalues' => 'לא צוינו ערכים.',
	'smw_nodatetime' => 'התאריך "$1" אינו מובן.',
	'smw_toomanyclosing' => 'נראה כי ישנם מופעים רבים מדי של "$1" בשאילתה.',
	'smw_noclosingbrackets' => 'בכמה מהפעמים בהם השתמשתם ב־"<nowiki>[[</nowiki>" בשאילתה לא דאגתם להציב "]]" תואם לסגירה.',
	'smw_misplacedsymbol' => 'נעשה שימוש בסימן "$1" במקום בו אינו מועיל.',
	'smw_unexpectedpart' => 'החלק "$1" מהשאילתה לא הובן.
ייתכן שהתוצאות לא יתאימו למצופה.',
	'smw_emptysubquery' => 'לאחת משאילתות המשנה אין תנאים תקינים.',
	'smw_misplacedsubquery' => 'נעשה שימוש בשאילתת משנה כלשהי במקום שבו שאילתות משנה אינן מורשות.',
	'smw_valuesubquery' => 'שאילתות משנה אינן נתמכות עבור ערכי המאפיין "$1".',
	'smw_badqueryatom' => 'כמה חלקים "<nowiki>[[…]]</nowiki>" מהשאילתה לא הובנו.',
	'smw_propvalueproblem' => 'ערך המאפיין "$1" לא הובן.',
	'smw_noqueryfeature' => 'חלק מהתכונות שבשאילתה אינן נתמכות באתר ויקי זה וחלקים מהשאילתה הושמטו ($1).',
	'smw_noconjunctions' => 'מילות חיבור בשאילתתות אינן נתמכות בוויקי הזה וחלק מהשאילתה נזרק ($1).',
	'smw_nodisjunctions' => 'מילות הפרדה בשאילתות אינן נתמכות בוויקי זה וחלק מהשאילתה נזרק ($1).',
	'smw_querytoolarge' => 'לא ניתן להתחשב בתנאי השאילתה הבאה עקב מגבלות אתרי הוויקי על גודל השאילתה או על עומקה: $1.',
	'smw_notemplategiven' => 'ציינו ערך עבור הפרמטר "template" כדי שמבנה שאילתה זו יעבוד.',
	'smw_db_sparqlqueryproblem' => 'לא ניתן היה לקבל את תוצאת השאילתה ממסד הנתונים SPARQL. השגיאה הזאת יכולה להיות זמנית או להצביע על באג בתכנת מסד הנתונים.',
	'smw_db_sparqlqueryincomplete' => 'הסתבר שמענה לשאילתה הזאת קשה מדי והוא בוטל. ייתכן שתוצאות אחדות חסרות. אם זה אפשרי, יש לנסות שאילתה פשוטה יותר.',
	'smw_type_header' => 'מאפיינים מסוג "$1"',
	'smw_typearticlecount' => 'הצגת {{PLURAL:$1|מאפיין אחד המשתמש|$1 מאפיינים המשתמשים}} בסוג זה.',
	'smw_attribute_header' => 'דפים המשתמשים במאפיין "$1"',
	'smw_attributearticlecount' => 'הצגת {{PLURAL:$1|דף אחד המשתמש|$1 דפים המשתמשים}} במאפיין זה.',
	'smw_subproperty_header' => 'מאפייני משנה',
	'smw_subpropertyarticlecount' => 'למאפיין זה {{PLURAL:$1|קיים מאפיין המשנה הבא|קיימים $1 מאפייני המשנה הבאים}}:',
	'smw_concept_header' => 'דפים מהרעיון "$1"',
	'smw_conceptarticlecount' => 'הצגת {{PLURAL:$1|דף אחד השייך|$1 דפים השייכים}} לרעיון זה.',
	'specialpages-group-smw_group' => 'מדיה־ויקי סמנטית',
	'exportrdf' => 'ייצוא דפים ל־RDF',
	'smw_exportrdf_docu' => 'דף זה מאפשר לכם לאחזר נתונים מדף במבנה RDF.
כדי לייצא דפים, כתבו את כותרות הדפים בתיבת הטקסט שלהלן, כותרת אחת בכל שורה.',
	'smw_exportrdf_recursive' => 'ייצוא רקורסיבי של כל הדפים הקשורים.
שימו לב שהתוצאה עלולה להיות גדולה!',
	'smw_exportrdf_backlinks' => 'כמו כן, יתבצע ייצוא של כל הדפים המפנים לדפים המיוצאים.
ייווצר RDF הניתן לעיון.',
	'smw_exportrdf_lastdate' => 'אין לייצא דפים שלא שונו מאז נקודת הזמן שצוינה.',
	'smw_exportrdf_submit' => 'ייצוא',
	'uriresolver' => 'פותר הכתובות',
	'properties' => 'מאפיינים',
	'smw_properties_docu' => 'בוויקי נעשה שימוש במאפיינים הבאים.',
	'smw_property_template' => '$1 מסוג $2 ($3 {{PLURAL:$3|פעם אחת|פעמים}})',
	'smw_propertylackspage' => 'פרטי כל המאפיינים אמורים להופיע בדף!',
	'smw_propertylackstype' => 'לא צוין סוג עבור מאפיין זה (בינתיים נעשה שימוש בסוג $1).',
	'smw_propertyhardlyused' => 'בקושי נעשה שימוש במאפיין זה בוויקי!',
	'unusedproperties' => 'מאפיינים שאינם בשימוש',
	'smw_unusedproperties_docu' => 'המאפיינים הבאים קיימים למרות ששום דף אחר אינו משתמש בהם.',
	'smw_unusedproperty_template' => '$1 מסוג $2',
	'wantedproperties' => 'מאפיינים מבוקשים',
	'smw_wantedproperties_docu' => 'באתר הוויקי נעשה שימוש במאפיינים אלה, אין להם עדיין דף שיתאר אותם.',
	'smw_wantedproperty_template' => '$1 (בשימוש {{PLURAL:$2|פעם אחת|$2 פעמים}})',
	'smw_purge' => 'רענון תבניות ושאילתות',
	'types' => 'טיפוסים',
	'smw_types_docu' => 'ברשימה זו מופיעים כל סוגי הנתונים שיכולים להיות מושמים למאפיינים.',
	'semanticstatistics' => 'סטטיסטיקה סמנטית',
	'smw_semstats_text' => "אתר ויקי זה מכיל {{PLURAL:$1|ערך מאפיין '''אחד'''|'''$1''' ערכי מאפיינים}} עבור סך כולל של [[Special:Properties|{{PLURAL:$2|מאפין '''אחד'''|'''$2''' מאפיינים שונים}}]].
ל{{PLURAL:מאפיין '''אחד'''|־'''$3''' מאפיינים}} יש דף משלהם, וסוג הנתונים המיועד צוין עבור '''$4''' מאלה.
ייתכן שכמה ממהמאפיינים הקיימים הם [[Special:UnusedProperties|מאפיינים שאינם בשימוש]].
מאפיינים שעדיין חסר להם דף נמצאים ב[[Special:WantedProperties|רשימת המאפיינים המבוקשים]].",
	'smw_uri_doc' => 'פותרן כתובות מיישם את <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">חיפוש W3C TAG ב־httpRange-14</a>. הוא דואג לכך שאנשים לא יהפכו לאתרי אינטרנט.',
	'ask' => 'חיפוש סמנטי',
	'smw_ask_sortby' => 'מיון לפי טור (אופציונאלי)',
	'smw_ask_ascorder' => 'בסדר עולה',
	'smw_ask_descorder' => 'בסדר יורד',
	'smw_ask_submit' => 'חפש תוצאות',
	'smw_ask_editquery' => '[עריכת השאילתה]',
	'smw_add_sortcondition' => '[הוספת הגדרת מיון]',
	'smw_ask_hidequery' => 'הסתרת השאילתה',
	'smw_ask_help' => 'עזרה בכתיבת שאילתות',
	'smw_ask_queryhead' => 'שאילתה',
	'smw_ask_printhead' => 'נתונים נוספים להצגה',
	'smw_ask_printdesc' => '(יש להוסיף כל שם מאפיין בשורה נפרדת)',
	'smw_ask_format_as' => 'עיצוב בתור:',
	'smw_ask_defaultformat' => 'ברירת מחדל',
	'smw_ask_otheroptions' => 'אפשרויות אחרות',
	'smw_ask_show_embed' => 'הצגת קוד הטמעה',
	'smw_ask_hide_embed' => 'הסתרת קוד הטמעה',
	'smw_ask_embed_instr' => 'כדי לשבץ את השאילתה הזאת אל תוך דף ויקי, השתמשו בקוד להלן.',
	'querycreator' => 'יוצר השאילתות',
	'smw_qc_otheropt' => 'אפשרויות אחרות',
	'smw_qc_default' => 'ברירת המחדל:',
	'smw_qc_query_help' => 'נא להזין שאילתה באמצעות הטופס להלן כדי לבחור דפי ויקי מבוססים על
קטגוריה (<strong>[[{{ns:category}}:שחקן]]</strong>),
מאפיינים (<strong>[[נמצא ב::גרמניה]]</strong>),
שמות (<strong>[[גרמניה]]</strong>) ומרחבי שם (<strong>[[{{ns:help}}:+]]</strong>)', # Fuzzy
	'smw_qui_ok' => 'אישור',
	'smw_qui_cancel' => 'ביטול',
	'smw_qui_category' => '<strong>קטגוריה</strong>',
	'smw_qui_label' => 'תווית',
	'smw_qui_dcategory' => 'קטגוריה:',
	'searchbyproperty' => 'חיפוש לפי מאפיין',
	'smw_sbv_docu' => 'חיפוש כל הדפים שיש להם מאפיין וערך מסוימים.',
	'smw_sbv_novalue' => 'כתבו ערך תקין למאפיין, או צפו בכל ערכי המאפיינים עבור "$1".',
	'smw_sbv_displayresult' => 'רשימת כל הדפים שיש להם את המאפיין "$1" עם הערך "$2"',
	'smw_sbv_displayresultfuzzy' => 'רשימת כל הדפים בעלי המאפיין "$1" עם הערך "$2".
מאחר שיש רק מעט תוצאות, יוצגו גם ערכים סמוכים.',
	'smw_sbv_property' => 'מאפיין:',
	'smw_sbv_value' => 'ערך:',
	'smw_sbv_submit' => 'חיפוש תוצאות',
	'browse' => 'עיון בוויקי',
	'smw_browselink' => 'עיון במאפיינים',
	'smw_browse_article' => 'כתבו את שם הדף ממנו יתחיל העיון.',
	'smw_browse_go' => 'הצגה',
	'smw_browse_show_incoming' => 'הצגת מאפיינים המקשרים לכאן',
	'smw_browse_hide_incoming' => 'הסתרת מאפיינים המקשרים לכאן',
	'smw_browse_no_outgoing' => 'לדף זה אין מאפיינים.',
	'smw_browse_no_incoming' => 'אין מאפיינים המקשרים לדף זה.',
	'smw_inverse_label_default' => '$1 מתוך',
	'smw_inverse_label_property' => 'תג מאפיין הפוך.',
	'pageproperty' => 'חיפוש במאפייני דף',
	'smw_pp_docu' => 'חיפוש כל הנתונים הממלאים מאפיין של דף נתון.
כתבו גם את הדף וגם את המאפיין.',
	'smw_pp_from' => 'מהדף',
	'smw_pp_type' => 'מאפיין',
	'smw_pp_submit' => 'חיפוש תוצאות',
	'smw_result_prev' => 'הקודם',
	'smw_result_next' => 'הבא',
	'smw_result_results' => 'תוצאות',
	'smw_result_noresults' => 'מצטערת, אין תוצאות',
	'smwadmin' => 'תכונות ניהוליות עבור המדיה־ויקי הסמנטית',
	'smw_smwadmin_setupsuccess' => 'מנוע האיחסון הוגדר בהצלחה.',
	'smw_smwadmin_return' => 'חזרה אל $1',
	'smw_smwadmin_updatestarted' => 'הותחל תהליך עדכון חדש לרענון הנתונים הסמנטיים.
כל הנתונים המאוחסנים ייבנו מחדש או יתוקנו היכן שיש צורך.
תוכלו לעקוב אחר תהליך העדכון בדף מיוחד זה.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'יש כבר תהליך עדכון פעיל.
לא ייווצר עוד אחד.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'כל תהליכי העדכון הקיימים נעצרו.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'כדי לעצור תהליך עדכון פעיל, עליכם לסמן את תיבת הסימון כדי לציין שאתם בטוחים בכך.', # Fuzzy
	'smw_smwadmin_docu' => 'דף מיוחד זה יעזור לכם במהלך ההתקנה והשדרוג של <a href="http://semantic-mediawiki.org">מדיה־ויקי הסמנטית</a>.
זִכרו לגבות את הנתונים החיוניים לכם בטרם הפעלת התכונות הניהוליות.',
	'smw_smwadmin_db' => 'התקנה ושדרוג של בסיס הנתונים',
	'smw_smwadmin_dbdocu' => 'מדיה־ויקי סמנטית דורשת כמה הרחבות לבסיס הנתונים של מדיה־ויקי כדי לאחסן את הנתונים הסמנטיים.
הפונקציה שלהלן מוודאת שמסד הנתונים שלכם מוגדר כראוי.
השינויים שנעשים בשלב זה אינם משפיעים על שאר בסיס הנתונים של מדיה־ויקי, וניתן לבטלם בקלות אם תרצו בכך.
ניתן להפעיל את פונקציית ההגדרה הזו מספר פעמים מבלי לגרום לנזק כלשהו, אך היא נדרשת רק פעם אחת עם ההתקנה או עם שדרוג.',
	'smw_smwadmin_permissionswarn' => 'אם הפעולה נכשלת עם שגיאות SQL, למשתמש של בסיס הנתונים של אתר הוויקי שלכם (תוכלו למצוא אותו בקובץ ה־LocalSettings.php שלכם) אין הרשאות מתאימות.
אנא הוסיפו למשתמש זה הרשאות ליצירה ולמחיקה של טבלאות, כִתבו את פרטי גישת העל לבסיס הנתונים לקובץ LocalSetting.php באופן זמני, או השתמשו בסקריפט התחזוקה <tt>SMW_setup.php</tt> שיכול להשתמש בהרשאות של הקובץ AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'אתחול או שדרוג של טבלאות',
	'smw_smwadmin_announce' => 'הכריזו על הוויקי שלכם',
	'smw_smwadmin_announcedocu' => 'למדיה־ויקי סמנטי, ישנ שירות מקוון להכרזה על אתרי ויקי סמנטיים חדשים.
שירות זה משמש לאחסון רשימת אתרים ציבוריים המשתמשים במדיה־ויקי סמנטית, לרוב כדי לעזור ל<a href="http://semantic-mediawiki.org/wiki/SMW_Project">מיזם מדיה־ויקי סמנטית</a> לקבל סקירה של שימושים טיפוסיים במדיה־ויקי הסמנטי.
עיינו בדף הבית של המדיה־ויקי הסמנטי ל<a href="http://semantic-mediawiki.org/wiki/Registry">מידע נוסף על שירות זה</a>.',
	'smw_smwadmin_announcebutton' => 'לחצו על הכפתור הבא כדי לשלוח את כתובת הוויקי שלכם לשירות זה.
השירות לא ירשום אתרי ויקי שאינם נגישים לציבור, והמידע שיישמר יהיה מידע הזמין לציבור בלבד.',
	'smw_smwadmin_datarefresh' => 'תיקון ושדרוג של נתונים',
	'smw_smwadmin_datarefreshdocu' => 'ניתן לשחזר את כל הנתונים של מדיה־ויקי הסמנטי לפי התוכן הנוכחי של אתר הוויקי.
פעולה זו עשויה להיות שימושית לתיקון נתונים שגויים או לעדכון הנתונים אם המבנה הפנימי שונה לאור שדרוג התוכנה.
העדכון מופעל דף־דף והוא לא יושלם מיד.
המידע להלן מראה האם העדכון מתבצע כעת ומאפשר לכם להתחיל או להפסיק את העדכונים (אלא אם כן תכונה זו בוטלה על ידי מנהל האתר).',
	'smw_smwadmin_datarefreshprogress' => '<strong>כבר מתבצע תהליך עדכון.</strong>
מצב בו העדכון מתקדם לאט הוא מצב נורמלי, מאחר שהנתונים מתעדכנים בחלקים קטנים בכל פעם שמשתמש ניגש לוויקי.
כדי לסיים את העדכון מהר יותר, תוכלו להפעיל את סקריפט התחזוקה <tt>runJobs.php</tt> (השתמשו באפשרות <tt>--maxjobs 1000</tt> כדי להגביל את מספר העדכונים שמתבצעים בבת אחת).
התקדמות משוערת של העדכון הנוכחי:',
	'smw_smwadmin_datarefreshbutton' => 'התחלת עדכון הנתונים',
	'smw_smwadmin_datarefreshstop' => 'עצירת עדכון זה',
	'smw_smwadmin_datarefreshstopconfirm' => 'כן, אנו בטוחים.',
	'smw_smwadmin_support' => 'קבלת תמיכה',
	'smw_smwadmin_supportdocu' => 'מגוון משאבים עומדים לרשותכם במקרה של תקלה:',
	'smw_smwadmin_installfile' => 'אם יש לכם בעיות בהתקנה, התחילו בבדיקת ההנחיות המופיעות בקובץ <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'התיעוד המלא למשתמשי המדיה־ויקי הסמנטי נמצא בכתובת <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'ניתן לדווח על באגים ב<a href="https://bugzilla.wikimedia.org/">באגזילה של מדיה־ויקי</a>.',
	'smw_smwadmin_questions' => 'אם יש לכם הצעות או שאלות נוספות, הצטרפו לדיון שנערך ב<a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">פורום המשתמשים של Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'מבנה הנתונים',
	'smw_adminlinks_displayingdata' => 'הצגת נתונים',
	'smw_adminlinks_inlinequerieshelp' => 'עזרה על שאילתות משובצות',
	'smw-createproperty-isproperty' => 'זהו מאפיין מסוג $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|הערך האפשרי למאפיין זה הוא|הערכים האפשריים למאפיין זה הם}}:',
	'smw_unknowntype' => '[אופס! סוג לא מוכר "$1" הוגדר עבור מאפיין זה]', # Fuzzy
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'smw_viewasrdf' => 'RDF फ़ीड',
	'smw_finallistconjunct' => ', और',
	'smw_factbox_head' => '$1 के बारेमें फ़ैक्ट्स',
	'smw_iq_moreresults' => '… आगे के रिज़ल्ट',
	'smw_true_words' => 'सही,t,हां,y',
	'smw_false_words' => 'गलत,f,ना,n',
	'smw_nofloat' => '“$1” यह संख्या नहीं हैं।',
	'smw_type_header' => '“$1” प्रकारके गुणधर्म',
	'properties' => 'गुणधर्म',
	'unusedproperties' => 'इस्तेमाल न किये हुए गुणधर्म',
	'smw_unusedproperty_template' => '$2 प्रकारके $1',
	'wantedproperties' => 'चाहिये होनेवाले गुणधर्म',
	'smw-createproperty-isproperty' => 'यह $1 प्रकार का गुणधर्म हैं।',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'smw_browse_go' => 'Lakat',
);

/** Croatian (hrvatski)
 * @author Dalibor Bosits
 * @author Tivek
 */
$messages['hr'] = array(
	'smw-desc' => "Čini Vaš wiki dostupnijim - za strojeve ''i'' ljude ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentacija])",
	'smw_viewasrdf' => 'RDF feed',
	'smw_finallistconjunct' => ', i',
	'smw_factbox_head' => 'Činjenice o $1',
	'smw_isspecprop' => 'Ovo svojstvo je specijalno na ovom wikiju.',
	'smw_concept_description' => 'Opis koncepta "$1"',
	'smw_no_concept_namespace' => 'Koncepti mogu biti definirani jedino u imenskom prostoru Concept: .',
	'smw_multiple_concepts' => 'Stranica koncepta smije imati samo jednu definiciju koncepta.',
	'smw_concept_cache_miss' => 'Koncept "$1" se trenutačno ne može se koristiti jer je wiki podešen tako da se koncept mora proračunati i izraditi off-line. Ako problem ne nestane nakon nekog vremena, zamolite administratora da ovaj koncept učini dostupnim.',
	'smw_noinvannot' => 'Vrijednosti se ne mogu dodijeliti inverznim svojstva.',
	'version-semantic' => 'Semantičke ekstenzije',
	'smw_baduri' => 'URI oblika "$1" nije dozvoljen.',
	'smw_printername_count' => 'Broji rezultate',
	'smw_printername_csv' => 'Izvoz u CSV',
	'smw_printername_debug' => 'Debugiranje upita (za stručnjake)',
	'smw_printername_embedded' => 'Umetni sadržaj stranice',
	'smw_printername_json' => 'Izvoz u JSON',
	'smw_printername_list' => 'Popis',
	'smw_printername_ol' => 'Nabrajanje',
	'smw_printername_ul' => 'Ispis po predmetima',
	'smw_printername_rss' => 'Izvoz u RSS',
	'smw_printername_table' => 'Tablica',
	'smw_printername_broadtable' => 'Široka tablica',
	'smw_printername_template' => 'Predložak',
	'smw-paramdesc-limit' => 'Maksimalni broj rezultata',
	'smw-paramdesc-headers' => 'Prikaz zaglavlja/imena svojstava',
	'smw-paramdesc-mainlabel' => 'Oznaka imenu glavne stranice',
	'smw-paramdesc-link' => 'Prikaži vrijednosti kao poveznice',
	'smw-paramdesc-intro' => 'Tekst za prikazati prije rezultata upita, ukoliko ih ima',
	'smw-paramdesc-outro' => 'Tekst za prikazati nakon rezultata upita, ukoliko ih ima',
	'smw-paramdesc-default' => 'Tekst koji će se prikazati ako nema rezultata upita',
	'smw-paramdesc-sep' => 'Znak za razdvajanje vrijednosti',
	'smw-paramdesc-template' => 'Naziv predloška kojim će se prikazati ispis',
	'smw-paramdesc-columns' => 'Broj stupaca u kojima se prikazuje rezultat (default je $1)',
	'smw-paramdesc-userparam' => 'Vrijednost koja se prenosi u svaki poziv predloška, ako se predložak koristi',
	'smw-paramdesc-introtemplate' => 'Ime predloška koji će se prikazati prije rezultata upita, ako ih ima',
	'smw-paramdesc-outrotemplate' => 'Ime predloška koji će se prikazati nakon rezultata upita, ako ih ima',
	'smw-paramdesc-embedformat' => 'HTML tag koji definira zaglavlja',
	'smw-paramdesc-embedonly' => 'Ne prikazuj zaglavlja',
	'smw-paramdesc-rsstitle' => 'Tekst za naslov feeda',
	'smw-paramdesc-rssdescription' => 'Tekst za opis feeda',
	'smw-paramdesc-searchlabel' => 'Tekst poveznice na rezultate', # Fuzzy
	'smw_iq_disabled' => 'Semantički upiti su isključeni na ovom wikiju.',
	'smw_iq_moreresults' => '… daljnji rezultati',
	'smw_parseerror' => 'Dana vrijednost nije razumljiva.',
	'smw_notitle' => '"$1" ne može biti ime stranice na ovom wikiju.',
	'smw_wrong_namespace' => 'Ovdje su dozvoljene samo stranice iz imenskog prostora "$1".',
	'smw_manytypes' => 'Za svojstvo je definirano više od jednog tipa.',
	'smw_emptystring' => 'Prazni nizovi se ne prihvaćaju.',
	'smw_maxstring' => 'Reprezentacija niza $1 je predugačka.',
	'smw_notinenum' => '"$1" nije na popisu dozvoljenih vrijednosti ($2) za ovo svojstvo.',
	'smw_noboolean' => '"$1" nije prepoznat kao booleovska vrijednost ("true/false" odn. istina/laž).',
	'smw_true_words' => 'true,t,yes,y,istina,i,da,d',
	'smw_false_words' => 'false,f,no,n,laž,l,ne',
	'smw_nofloat' => '"$1" nije broj.',
	'smw_infinite' => 'Veliki brojevi poput "$1" nisu podržani.',
	'smw_novalues' => 'Nisu naznačene vrijednosti.',
	'smw_nodatetime' => 'Datum "$1" nije razumljiv.',
	'smw_toomanyclosing' => 'Čini se da postoji previše pojava "$1" u upitu.',
	'smw_noclosingbrackets' => 'Jedna od "<nowiki>[[</nowiki>" u Vašem upitu nije zatvorena odgovarajućom "]]".',
	'smw_misplacedsymbol' => 'Simbol "$1" se javlja na mjestu gdje nije koristan.',
	'smw_unexpectedpart' => 'Dio upita "$1" nije razumljiv.
Rezultati možda neće biti odgovarajući.',
	'smw_emptysubquery' => 'Neki podupiti nemaju valjani uvjet.',
	'smw_misplacedsubquery' => 'Podupit je korišten na nedozvoljenom mjestu.',
	'smw_valuesubquery' => 'Podupiti ne mogu biti vrijednosti svojstva "$1".',
	'smw_badqueryatom' => 'Jedan od dijelova upita "<nowiki>[[…]]</nowiki>" nije razumljiv.',
	'smw_propvalueproblem' => 'Vrijednost svojstva "$1" nije razumljiva.',
	'smw_noqueryfeature' => 'Ovaj wiki ne podržava neku od osobina upita, pa je dio upita odbačen ($1).',
	'smw_noconjunctions' => 'Ovaj wiki ne podržava veznike u upitima, pa je dio upita odbačen ($1).',
	'smw_nodisjunctions' => 'Ovaj wiki ne podržava razdvajanja u upitima, pa je dio upita odbačen ($1).',
	'smw_querytoolarge' => 'Zbog ograničenja veličine ili dubine upita na ovom wikiju, sljedeći uvjeti upita nisu uzeti u obzir: $1.',
	'smw_notemplategiven' => 'Navedite vrijednost parametra "template" ("predložak") za ovaj format upita.',
	'smw_type_header' => 'Svojstva tipa "$1".',
	'smw_typearticlecount' => '{{PLURAL:$1|Prikazano je $1 svojstvo koje koristi|Prikazana su $1 svojstva koja koriste|Prikazano je $1 svojstava koja koriste}} ovaj tip.',
	'smw_attribute_header' => 'Stranice koje koriste svojstvo "$1".',
	'smw_attributearticlecount' => 'Prikazano {{PLURAL:$1|$1 stranica koja koristi|$1 stranice koje koriste|$1 stranica koje koriste}} ovo svojstvo.',
	'smw_subproperty_header' => 'Podsvojstva',
	'smw_subpropertyarticlecount' => 'Ovo svojstvo ima {{PLURAL:$1|sljedeće podsvojstvo|sljedeća $1 podsvojstva|sljedećih $1 podsvojstava}}:',
	'smw_concept_header' => 'Stranice koncepta "$1"',
	'smw_conceptarticlecount' => 'Prikazano $1 {{PLURAL:$1|stranica koja pripada|stranice koje pripadaju|stranica koje pripadaju}} tom konceptu.',
	'exportrdf' => 'Izvezi stranice u RDF',
	'smw_exportrdf_docu' => 'Na ovoj stranici možete dobiti podatke o nekoj stranici u RDF formatu. 
Da biste izvezli stranice unesite njihove naslove u prozor za uređivanje ispod, jedan naslov po retku.',
	'smw_exportrdf_recursive' => 'Rekurzivno izvezi sve srodne stranice.
Imajte na umu da bi rezultat mogao biti velik!',
	'smw_exportrdf_backlinks' => 'Također izvezi sve stranice koje se referenciraju na izvezene stranice. 
Generira RDF za pregled i pretraživanje.',
	'smw_exportrdf_lastdate' => 'Ne izvozi stranice koje nisu izmijenjene od navedenog datuma.',
	'smw_exportrdf_submit' => 'Izvezi',
	'uriresolver' => 'URI razrješitelj',
	'properties' => 'Svojstva',
	'smw_properties_docu' => 'U wikiju se koriste sljedeća svojstva.',
	'smw_property_template' => '$1 tipa $2 ($3)',
	'smw_propertylackspage' => 'Svako svojstvo mora biti opisano na svojoj stranici!',
	'smw_propertylackstype' => 'Za ovo svojstvo nije naveden tip (od sad na dalje pretpostavljam tip $1).',
	'smw_propertyhardlyused' => 'Ovo se svojstvo gotovo ne koristi u wikiji!',
	'unusedproperties' => 'Nekorištena svojstva',
	'smw_unusedproperties_docu' => 'Sljedeća svojstva postoje, no ne koristi ih ni jedna stranica.',
	'smw_unusedproperty_template' => '$1 tipa $2',
	'wantedproperties' => 'Tražena svojstva',
	'smw_wantedproperties_docu' => 'Sljedeća svojstva se koriste u wikiju, no još nemaju svoje stranice koje bi ih opisale.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|korištenje|korištenja|korištenja}})',
	'smw_purge' => 'Osvježi',
	'types' => 'Tipovi',
	'smw_types_docu' => 'Slijedi popis svih tipova podataka koji mogu biti dodijeljeni svojstvima.
Svaki tip podatka ima stranicu koja može pružiti dodatne informacije.', # Fuzzy
	'semanticstatistics' => 'Statistika o semantici',
	'smw_semstats_text' => "Ovaj wiki sadrži '''$1''' {{PLURAL:$1|vrijednost svojstva|vrijednosti svojstava|vrijednosti svojstava}} za ukupno '''$2''' [[Special:Properties|{{PLURAL:$2|svojstvo|različita svojstva|različitih svojstava}}]].
'''$3''' {{PLURAL:$3|svojstvo ima|svojstva imaju|svojstava imaju}} vlastitu stranicu i '''$4''' {{PLURAL:$3|ima|od njih imaju|od njih imaju}} zadan tip podatka.
Neka od postojećih svojstava su možda [[Special:UnusedProperties|nekorištena svojstva]].
Svojstva koja još uvijek nemaju stranicu nalaze se na [[Special:WantedProperties|popisu traženih svojstava]].",
	'smw_uri_doc' => 'URI razrješitelj implementira <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C traženje TAGova na httpRange-14</a> koje brine da se ljudi ne pretvore u web stranice.',
	'ask' => 'Smenatička pretraga',
	'smw_ask_sortby' => 'Razvrstavanje po stupcu (opcionalno)',
	'smw_ask_ascorder' => 'Rastuće',
	'smw_ask_descorder' => 'padajuće',
	'smw_ask_submit' => 'Nađi rezultate',
	'smw_ask_editquery' => '[Uredi upit]',
	'smw_add_sortcondition' => '[Dodaj uvjet na razvrstavanje]',
	'smw_ask_hidequery' => 'Sakrij upit',
	'smw_ask_help' => 'Pomoć za upite',
	'smw_ask_queryhead' => 'Upit',
	'smw_ask_printhead' => 'Dodatni podaci za prikazati',
	'smw_ask_printdesc' => '(dodaj jedno svojstvo po retku)',
	'smw_ask_format_as' => 'Formatiraj kao:',
	'smw_ask_defaultformat' => 'prvotno',
	'smw_ask_otheroptions' => 'Ostale opcije',
	'smw_ask_show_embed' => 'Prikaži kôd za umetanje',
	'smw_ask_hide_embed' => 'Sakrij kôd za umetanje',
	'smw_ask_embed_instr' => 'Da biste umetnuli ovaj upit u stranicu koristite kôd dolje.',
	'searchbyproperty' => 'Traži po svojstvu',
	'smw_sbv_docu' => 'Traži sve stranice koje imaju zadano svojstvo i vrijednost.',
	'smw_sbv_novalue' => 'Unesite valjanu vrijednost za svojstvo ili pogledajte sve vrijednosti za "$1".',
	'smw_sbv_displayresult' => 'Popis svih stranica koje imaju svojstvo "$1" vrijednosti "$2".',
	'smw_sbv_displayresultfuzzy' => 'Popis svih stranica koje imaju svojstvo "$1" vrijednosti "$2".
Budući da je rezultata malo, također su prikazane i bliske vrijednosti.',
	'smw_sbv_property' => 'Svojstvo:',
	'smw_sbv_value' => 'Vrijednost:',
	'smw_sbv_submit' => 'Nađi rezultate',
	'browse' => 'Pregledaj wiki',
	'smw_browselink' => 'Pregledaj svojstva',
	'smw_browse_article' => 'Unesite ime stranice od koje ćete početi pregledavanje.',
	'smw_browse_go' => 'Kreni',
	'smw_browse_show_incoming' => 'prikaži svojstva koja povezuju ovamo',
	'smw_browse_hide_incoming' => 'sakrij svojstva koja povezuju ovamo',
	'smw_browse_no_outgoing' => 'Ova stranica nema svojstva.',
	'smw_browse_no_incoming' => 'Nijedno svojstvo ne povezuje na ovu stranicu.',
	'smw_inverse_label_default' => '$1 od',
	'smw_inverse_label_property' => 'Oznaka inverznog svojstva',
	'pageproperty' => 'Pretraživanje svojstava stranica',
	'smw_pp_docu' => 'Pretraži sve vrijednosti nekog svojstva na zadanoj stranici.
Unesite stranicu i svojstvo.',
	'smw_pp_from' => 'Sa stranice',
	'smw_pp_type' => 'Svojstvo',
	'smw_pp_submit' => 'Nađi rezultate',
	'smw_result_prev' => 'Prethodni',
	'smw_result_next' => 'Sljedeći',
	'smw_result_results' => 'Rezultati',
	'smw_result_noresults' => 'Nema rezultata.',
	'smwadmin' => 'Administratorske funkcije za Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Spremište je uspješno postavljeno.',
	'smw_smwadmin_return' => 'Vrati se na $1',
	'smw_smwadmin_updatestarted' => 'Pokrenut je novi proces osvježavanja semantičkih podataka.
Svi spremljeni podaci će biti ponovno izgrađeni ili popravljeni ako je to potrebno.
Napredak osvježavanja možete pratiti na ovoj posebnoj stranici.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Već se izvršava proces osvježavanja.
Ne pokrećem novi.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Svi postojeći procesi osvježavanja su zaustavljeni.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Da biste zaustavili proces osvježavanja, označite u potvrdnom okviru da ste zaista sigurni.', # Fuzzy
	'smw_smwadmin_docu' => 'Ova posebna stranica pomaže prilikom instalacije i nadogradnje <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Ne zaboravite napraviti sigurnosnu kopiju važnih podataka prije izvršavanja administrativnih funkcija.',
	'smw_smwadmin_db' => 'Instalacija i nadgradnja baze podataka',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki zahtijeva određena proširenja MediaWiki baze podataka za čuvanje semantičkih podataka.
Funkcija ispod osigurava da je vaša baza pravilno postavljena.
Ovaj korak ne utječe na ostatak MediaWiki baze podataka i lako se može poništiti ukoliko to želite.
Ova se funkcija može izvršiti više puta bez ikakvih štetnih posljedica, no potrebna je samo kod instalacije ili nadgradnje.',
	'smw_smwadmin_permissionswarn' => 'Ako operacija ne uspije i vrati SQL grešku, baza podataka koju koristi Vaš wiki (provjerite svoj LocalSettings.php) vjerojatno nema dovoljna prava.
Učinite jedno od sljedećeg: dodijelite ovom korisniku dodatna prava za stvaranje i brisanje tablica, privremeno unesite administratorsko korisničko ime i lozinku Vaše baze podataka u LocalSettings.php, ili pokrenite skriptu za održavanje <tt>SMW_setup.php</tt> koja će koristiti prava iz AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Inicijaliziraj ili nadogradi tablice',
	'smw_smwadmin_announce' => 'Najavite svoj wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki pruža web uslugu koja prikazuje i najavljuje nove semantičke wikije.
Time se vodi popis javnih web stranica i projekata koji koriste Semantic MediaWiki, uglavnom kako bi <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Projekt Semantic MediaWiki</a> dobio pregled tipičnih upotreba Semantic MediaWiki.
Vidi početnu stranicu Semantic MediaWiki za <a href="http://semantic-mediawiki.org/wiki/Registry">više informacija o ovoj usluzi</a>.',
	'smw_smwadmin_announcebutton' => 'Pritisnite sljedeći gumb kako biste poslali URL svog wikija na tu uslugu.
Usluga neće registrirati wikije koji nisu javno dostupni i skupljat će samo javno dostupne podatke.',
	'smw_smwadmin_datarefresh' => 'Popravljanje i nadgradnja podataka',
	'smw_smwadmin_datarefreshdocu' => 'Moguće je povratiti sve semantičke podatke Semantic MediaWiki na osnovi trenutnog tekstualnog wikija, što možete koristiti za popravak pokvarenih podataka ili osvježivanje podataka u slučaju internih promjena softvera.
Osvježavanje se izvršava stranicu po stranicu i neće biti gotovo odmah.
Prikaz dolje sadrži popis svih osvježavanja u tijeku i omogućuje Vam da zaustavite ili pokrenete osvježavanje (osim ako to nije onemogućio administrator).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Osvježavanje je već u tijeku.</strong>
Normalno je da osvježavanje napreduje sporo jer se podaci osvježavaju u malim obrocima svaki put kad korisnik pristupi wikiju.
Da bi ovo osvježavanje završilo čim prije, možete pokrenuti MediaWiki skriptu za održavanje <tt>runJobs.php</tt> (koristite opciju <tt>--maxjobs 1000</tt> kako biste ograničili broj zasebnih osvježavanja po jednoj seriji).
Procjena napretka osvježavanja:',
	'smw_smwadmin_datarefreshbutton' => 'Pokreni osvježavanje podataka',
	'smw_smwadmin_datarefreshstop' => 'Zaustavi ovo osvježavanje',
	'smw_smwadmin_datarefreshstopconfirm' => 'Da, siguran sam.',
	'smw_smwadmin_support' => 'Zatražite pomoć',
	'smw_smwadmin_supportdocu' => 'U slučaju problema poslužite se sljedećim izvorima:',
	'smw_smwadmin_installfile' => 'U slučaju problema s Vašom instalacijom pogledajte naputke u datoteci <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Potpuna korisnička dokumentacija za Semantic MediaWiki nalazi se na <a href="http://semantic-mediawiki.org"><b>semantic-mediawiki.org</b></a>.',
	'smw_smwadmin_mediazilla' => 'Greške (bugove) možete prijaviti na <a href="https://bugzilla.wikimedia.org/">Bugzilli</a>.',
	'smw_smwadmin_questions' => 'Ukoliko imate pitanja ili prijedloge, pridružite se raspravi na <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">korisničkom forumu Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struktura podataka',
	'smw_adminlinks_displayingdata' => 'Prikaz podataka',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoć za umetnute upite',
	'smw_unknowntype' => 'Za svojstvo je definiran nepodržan tip "$1".', # Fuzzy
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'smw-desc' => "Twój wiki přistupniši činić - za mašiny ''a'' ludźi ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentacija online])",
	'smw_viewasrdf' => 'RDF-kanal',
	'smw_finallistconjunct' => 'a',
	'smw_factbox_head' => 'Fakty wo $1',
	'smw_isspecprop' => 'Tuta kajkosć je specialna kajkosć w tutym wikiju.',
	'smw_concept_description' => 'Wopisanje koncepta "$1"',
	'smw_no_concept_namespace' => "Koncepty hodźa so jenož w mjenowym rumje ''Koncept:'' definować.",
	'smw_multiple_concepts' => 'Kóžda konceptowa strona móže jenož jednu konceptowu definiciju měć.',
	'smw_concept_cache_miss' => 'Koncept "$1" njeda so tuchwilu wužiwać, dokelž wikijowa konfiguracija jón za předźěłowanje offline trjeba.
Jeli so problem po wěstym času njezhubi, woprašej so sydłoweho administratora, zo by wón tutón koncept k dispoziciji stajił.',
	'smw_noinvannot' => 'Hódnoty njedadźa so nawopačnym kajkosćam připokazać.',
	'version-semantic' => 'Semantiske rozšěrjenja',
	'smw_baduri' => 'URI formy "$1" njejsu dowolene.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Wuslědki ličić',
	'smw_printername_csv' => 'Eksport CSV',
	'smw_printername_dsv' => 'DSV-eksport',
	'smw_printername_debug' => 'Naprašowanje za zmylkami přepytać (za ekspertow)',
	'smw_printername_embedded' => 'Wobsah strony zasadźić',
	'smw_printername_json' => 'Eksport JSON',
	'smw_printername_list' => 'Lisćina',
	'smw_printername_ol' => 'Naličenje',
	'smw_printername_ul' => 'Nalistowanje',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Šěroka tabela',
	'smw_printername_template' => 'Předłoha',
	'smw_printername_rdf' => 'RDF-eksport',
	'smw_printername_category' => 'Kategorija',
	'validator-type-class-SMWParamSource' => 'tekst',
	'smw-paramdesc-limit' => 'Maksimalna ličba wuslědkow, kotraž ma so wróćić',
	'smw-paramdesc-offset' => 'Pozicija prěnjeho wuslědka',
	'smw-paramdesc-headers' => 'Mjena hłowow abo atributow zwobraznić',
	'smw-paramdesc-mainlabel' => 'Pomjenowanje, kotrež ma so hłownej stronje dać',
	'smw-paramdesc-link' => 'Hódnoty jako wotkazy pokazać',
	'smw-paramdesc-intro' => 'Tekst, kotryž ma so před naprašowanskimi wuslědkami zwobraznić, jeli tajke su',
	'smw-paramdesc-outro' => 'Tekst, kotryž ma so za naprašowanskimi wuslědkami zwobraznić, jeli tajke su',
	'smw-paramdesc-default' => 'Tekst, kotryž ma so zwobraznić, jeli žane naprašowanske wuslědki njejsu',
	'smw-paramdesc-sep' => 'Dźělatko za hódnoty',
	'smw-paramdesc-showsep' => 'Dźělatko horjeka w CSV-dataji pokazać ("sep=<value>")',
	'smw-paramdesc-distribution' => 'Město toho zo so wšě hódnoty zwobraznjeja, jich wustupowanja ličić a te pokazać.',
	'smw-paramdesc-distributionsort' => 'Rozdźělenje hódnotow po ličbje wustupowanjow sortěrować.',
	'smw-paramdesc-distributionlimit' => 'Rozdźělenje hódnotow na wěste hódnoty wobmjezować.',
	'smw-paramdesc-template' => 'Mjeno předłohi, z kotrejž maja so wućišće zwobraznić',
	'smw-paramdesc-columns' => 'Ličba špaltow, w kotrychž maja so wuslědki zwobraznić (standard je $1)',
	'smw-paramdesc-userparam' => 'Hódnota, kotraž so za kóždu namołwu předłohi přepodawa, jeli předłoha so wužiwa.',
	'smw-paramdesc-introtemplate' => 'Mjeno předłohi, kotraž ma so před naprašowanskimi wuslědkami zwobraznić, jeli tajke su',
	'smw-paramdesc-outrotemplate' => 'Mjeno předłohi, kotraž ma so za naprašowanskimi wuslědkami zwobraznić, jeli tajke su',
	'smw-paramdesc-embedformat' => 'HTML-taflički, kotrež so wužiwaja, zo bychu nadpisma definowali',
	'smw-paramdesc-embedonly' => 'Žane nadpisma zwobraznić',
	'smw-paramdesc-table-class' => 'Přidatna CSS-klasa za tabelu',
	'smw-paramdesc-rdfsyntax' => 'RDF-syntaksa, kotraž ma so wužiwać',
	'smw-paramdesc-csv-sep' => 'Dźělatko, kotrež ma so wužywać',
	'smw-paramdesc-dsv-separator' => 'Dźělatko, kotrež ma so wužywać',
	'smw-paramdesc-dsv-filename' => 'Mjeno za DSV-dataju',
	'smw-smwdoc-description' => 'Pokazuje tabelu wšěch parametrow, kotrež dadźa so za podaty wuslědkowy format hromadźe ze standardnymi hótnotami a wopisanjemi wužiwać.',
	'smw-smwdoc-par-format' => 'Wuslědkowy format, za kotrehož parametry dokumentacija ma so zwobraznić.',
	'smw-smwdoc-par-parameters' => 'Parametry, kotrež maja so pokazać: "specific" za tute, kotrež so přez format přidawaja, "base" za tute, kotrež su we wšěch formatach k dispoziciji a "all" za wobaj.',
	'smw-paramdesc-sort' => 'Kajkosć, po kotrejž naprašowanje ma so sortěrować',
	'smw-paramdesc-order' => 'Sortěrowanski porjad za naprašowanje',
	'smw-paramdesc-searchlabel' => 'Tekst za dalše pytanske wuslědki',
	'smw-paramdesc-named_args' => 'Argumenty, kotrež maja so předłoze přepodać',
	'smw-paramdesc-export' => 'Eksportowe nastajenje',
	'smw-paramdesc-prettyprint' => 'Njeformatowane wudaće, kotrež přidatne zasunjenja a nowe linki zwobraznja',
	'smw-paramdesc-source' => 'Alternatiwne naprašowanske žórło',
	'smw-paramdesc-jsonsyntax' => 'JSON-syntaksa, kotraž ma so wužiwać',
	'smw-printername-feed' => 'RSS- a Atom-kanal',
	'smw-paramdesc-feedtype' => 'Kanalowy typ',
	'smw-paramdesc-feedtitle' => 'Tekst, kotryž ma so jako titul kanala wužiwać',
	'smw-paramdesc-feeddescription' => 'Tekst, kotryž ma so jako wopisanje kanala wužiwać',
	'smw-paramdesc-feedpagecontent' => 'Wobsah strony, kotryž ma so z komentarom zwobraznić',
	'smw-label-feed-description' => '$1 $2 kanal',
	'smw_iq_disabled' => 'Semantiske naprašowanja su w tutym wikiju znjemóžnjene.',
	'smw_iq_moreresults' => '... dalše wuslědki',
	'smw_parseerror' => 'Podata hódnota njebu zrozumjena.',
	'smw_notitle' => '"$1" njeda so jako mjeno strony w tutym wikiju wužiwać.',
	'smw_noproperty' => '"$1" njeda so jako kajkosć w tutym wikiju wužiwać.',
	'smw_wrong_namespace' => 'Jenož strony w mjenowym rumje "$1" su tu dowolene.',
	'smw_manytypes' => 'Za kajkosć bu wjace hač jeden typ definowany.',
	'smw_emptystring' => 'Prózdne znamješkowe slědy so njeakceptuja.',
	'smw_maxstring' => 'Znamješkowy slěd $1 je předołhi.',
	'smw_notinenum' => '"$1" w lisćinje móžnych hódnotow ($2) za tutu kajkosć njeje.',
	'smw_noboolean' => '"$1" płaćiwa hódnota typa boolean (wěrny/njewěrny) njeje.',
	'smw_true_words' => 'wěrny, haj, true',
	'smw_false_words' => 'wopak, njewěrny, ně, false',
	'smw_nofloat' => '"$1" ličba njeje.',
	'smw_infinite' => 'Ličby, kotrež su tak wulke kaž "$1", so njepodpěruja.',
	'smw_unitnotallowed' => '"$1" njeje jako płaćiwa měrjenska jednotka za tutón atribut postajił.',
	'smw_nounitsdeclared' => 'Žane měrjenske jednotki njejsu so za tutu kajkosć podali.',
	'smw_novalues' => 'Žane hódnoty podate.',
	'smw_nodatetime' => 'Datum "$1" njebu zrozumjeny.',
	'smw_toomanyclosing' => 'Zda so, zo "$1" w tutym naprašowanju přehusto wustupuje.',
	'smw_noclosingbrackets' => 'Wustupowanje pora róžkatych spinkow "<nowiki>[[</nowiki>" w twojim naprašowanju njeje přez wotpowědny "]]" wukónčene.',
	'smw_misplacedsymbol' => 'Symbol "$1" so na městnje wužiwa, hdźež wužitny njeje.',
	'smw_unexpectedpart' => 'Dźěl "$1" naprašowanja njebu zrozumjeny.
Wuslědki snano kaž wočakowane njejsu.',
	'smw_emptysubquery' => 'Někajke podnaprašowanje nima płaćiwe wuměnjenje.',
	'smw_misplacedsubquery' => 'Někajke podnaprašowanje so na městnje wužiwa, hdźež podnaprašowanja njejsu dowolene.',
	'smw_valuesubquery' => 'Podnaprašowanja so za hódnoty kajkosće "$1" njepodpěruja.',
	'smw_badqueryatom' => 'Dźěl "<nowiki>[[…]]</nowiki>" naprašowanja njebu zrozumjeny.',
	'smw_propvalueproblem' => 'Hódnota kajkosće "$1" njebu zrozumjena.',
	'smw_noqueryfeature' => 'Wotprašowanska funkcija njepodpěruje so w tutym wikiju a dźěl wotprašowanja je so wotstronił ($1).',
	'smw_noconjunctions' => 'A-zwjazanja we wotprašowanajch njepodpěruja so w tutym wikiju a dźěl wotprašowanja je so wotstronił ($1).',
	'smw_nodisjunctions' => 'ABO-zwjazanja we wotprašowanjach njepodpěruja so w tutym wikiju a dźěl wotprašowanja je so wotstronił ($1).',
	'smw_querytoolarge' => 'Slědowace naprašowanske wuměnjenja njedachu so dla wikijowych wobmjezowanjow za wulkosć abo hłubokosć naprašowanja wobkedźbować: $1.',
	'smw_notemplategiven' => 'Podaj hódnotu za parameter "template", zo by tutón naprašowanski format fungował.',
	'smw_db_sparqlqueryproblem' => 'Naprašowanski wuslědk njeda so z datoweje banki SPARQL wotwołać. Tutón zmylk móhł nachwilny być abo programowy zmylk w datowej bance być.',
	'smw_db_sparqlqueryincomplete' => 'Wotmołwjenje na naprašowanje je so jako přećežko wukopało a je so přetorhnyło. Někotre wuslědki móhli falować. Jeli je móžno, spytaj jednoriše naprašowanje město toho wužiwać.',
	'smw_type_header' => 'Kajkosće typa "$1"',
	'smw_typearticlecount' => '{{PLURAL:$1|Pokazuje so kajkosć, kotraž tutón typ wužiwa|Pokazujetej so $1 kajkosći, kotrejž tutón typ wužiwatej|Pokazuja so $1 kajkosće, kotrež tutón typ wužiwaja|Pokazuje so $1 kajkosćow, kotrež tutón typ wužiwa}}.',
	'smw_attribute_header' => 'Strony, kotrež kajkosć "$1" wužiwaja',
	'smw_attributearticlecount' => '{{PLURAL:$1|Pokazuje so $1 strona, kotraž tutu kajkosć wužiwa|Pokazujetej $1 stronje, kotrejž tutu kajkosć wužiwatej|Pokazuja so $1 strony, kotrež tutu kajksć wužiwaja|Pokazuje so $1 stronow, kotrež tutu kajkosć wužiwa}}.',
	'smw_subproperty_header' => 'Podkajkosće',
	'smw_subpropertyarticlecount' => 'Tuta kajkosć ma {{PLURAL:$1|slědowacu podkajkosć|slědowacej $1 podkajkosći|slědowace $1 podkajkosće|slědowacych $1 podkajkosćow}}:',
	'smw_concept_header' => 'Strony koncepta "$1"',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Pokazuje so $1 strona, kotraž|Pokazujetej so $1 stronje, kotrejž|Pokazuja so $1, kotrež|Pokazuje so $1 stronow, kotrež}} k tutomu konceptej {{PLURAL:$1|słuša|słušatej|słušeja|słuša}}.',
	'exportrdf' => 'Do RDF eksportować',
	'smw_exportrdf_docu' => 'Tuta strona ći zmóžnja daty ze strony we formaće RDF wotwołać. Zo by strony eksportował, zapodaj titule w slědowacym kašćiku, jedyn titul na linku.',
	'smw_exportrdf_recursive' => 'Eksportuj wšě piwuzne strony.
Wobkedźbuj, zo wuslědk móhł wulki być!',
	'smw_exportrdf_backlinks' => 'Eksportuj tež wšě strony, kotrež so na eksportowane strony poćahuja.
Płodźi přepytujomny RDF.',
	'smw_exportrdf_lastdate' => 'Njeeksportuj strony, kotrež njejsu so wot podateho časoweho dypka změnili.',
	'smw_exportrdf_submit' => 'Eksportować',
	'uriresolver' => 'Rezolwer URI',
	'properties' => 'Kajkosće',
	'smw_properties_docu' => 'Slědowace kajkosće so we wikiju wužiwaja.',
	'smw_property_template' => '$1 typa $2 ($3 {{PLURAL:$3|wužiće|wužići|wužića|wužićow}})',
	'smw_propertylackspage' => 'Wšě kajkosće měli so přez stronu wopisać!',
	'smw_propertylackstype' => 'Za tutu kajkosć njeje so žadyn typ podał (mjeztym so typ $1 předpokładuje).',
	'smw_propertyhardlyused' => 'Tuta kajkosć so we wikiju lědma wužiwa!',
	'unusedproperties' => 'Njewužiwane kajkosće',
	'smw_unusedproperties_docu' => 'Slědowace kajkosće eksistuja, hačrunjež žana druha strona je wužiwa.',
	'smw_unusedproperty_template' => '$1 typa $2',
	'wantedproperties' => 'Požadane kajkosće',
	'smw_wantedproperties_docu' => 'Slědowace kajkosće so we wikiju wužiwaja, ale nimaja stronu, kotraž je wopisuje.',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|jónu wužity|dwójce wužitej|$2 razy wužite|$2 razow wužite}})',
	'smw_purge' => 'Aktualizować',
	'types' => 'Typy',
	'smw_types_docu' => 'Deleka je lisćina wšěch datowych typow, kotrež dadźa so kajkosćam připokazać.',
	'semanticstatistics' => 'Semantiska statistika',
	'smw_semstats_text' => "Tutón wiki wobsahuje '''$1''' {{PLURAL:$1|kajkostnu hódnotu|kajkostnej hódnoće|kajkostne hódnoty|kajkostnych hódnotow}} za dohromady '''$2''' [[Special:Properties|{{PLURAL:$2|kajkosć|rozdźělnej kajkosći|rozdźělne kajkosće|rozdźělnych kajkosćow}}]].
'''$3''' {{PLURAL:$3|kajkosć ma|kajkosći matej|kajkosće maja|kajkosćow ma}} swójsku stronu, a požadany datowy typ je za '''$4''' z nich podaty.
Někotre z eksistowacych kajkosćow móhli [[Special:UnusedProperties|njewužiwane kajkosće]] być. Kajkosće, kotrež stronu nimaja, su na [[Special:WantedProperties|lisćinje požadanych kajkosćow]].",
	'smw_uri_doc' => 'Rozpušćak URI implementuje <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>.
Stara so wo to, zo so ludźo z websydłami njestanu.',
	'ask' => 'Semantiske pytanje',
	'smw_ask_sortby' => 'Po špalće sortěrować (opcionalny)',
	'smw_ask_ascorder' => 'Postupowacy',
	'smw_ask_descorder' => 'Spadowacy',
	'smw_ask_submit' => 'Wuslědki namakać',
	'smw_ask_editquery' => '[Naprašowanje wobdźěłać]',
	'smw_add_sortcondition' => '[Sortěrowanske wuměnjenje přidać]',
	'smw_ask_hidequery' => 'Naprašowanje schować',
	'smw_ask_help' => 'Pomoc za naprašowanja',
	'smw_ask_queryhead' => 'Naprašowanje',
	'smw_ask_printhead' => 'Přidatne daty, kotrež maja so zwobraznić',
	'smw_ask_printdesc' => '(přidaj jedne atributowe mjeno na linku)',
	'smw_ask_format_as' => 'Formatowany jako:',
	'smw_ask_defaultformat' => 'standard',
	'smw_ask_otheroptions' => 'Druhe opcije',
	'smw-ask-otheroptions-info' => 'Tutón wotrězk wobsahuje opcije, kotrež měnjeja ćišćerske wudaće. Parametrowe wopisanje dadźa so wobhladać, jeli so kursor myški nad nich znošuje.',
	'smw-ask-otheroptions-collapsed-info' => 'Prošu wužij plusowy symbol (+), zo by sej wšě k dispoziciji stejace opcije wobhladał',
	'smw_ask_show_embed' => 'Zasadźeny kod pokazać',
	'smw_ask_hide_embed' => 'Zasadźeny kod schować',
	'smw_ask_embed_instr' => 'Wužij slědowacy kod, zo by tute wotprašowanje do wikijoweje strony zasadźił.',
	'smw-ask-delete' => '[Zhašeć]',
	'smw-ask-sorting' => 'Sortěrowanje',
	'smw-ask-format-selection-help' => 'Za podrobnostne wopisanje wopytaj prošu stronu $1 pomocy.',
	'querycreator' => 'Formular za wutworjenje naprašowanjow',
	'smw_qc_addmainlabel' => 'Hłowne pomjenowanje přidać',
	'smw_qc_show_addnal_opts' => 'Dalše opcije pokazać',
	'smw_qc_hide_addnal_opts' => 'Mjenje opcijow pokazać',
	'smw_qc_otheropt' => 'Druhe opcije',
	'smw_qc_intro' => 'Zawodny tekst:',
	'smw_qc_outro' => 'Naslědny tekst:',
	'smw_qc_default' => 'Standard:',
	'smw_qc_formatopt' => 'Formatowe opcije',
	'smw_qc_query_help' => 'Prošu wutwor naprašowanje z pomocu slědowaceho formulara. Wubjer wikistrony na zakładźe kategorijow (<strong><nowiki>na př. [[Category:Dźiwadźelnik]]</nowiki></strong>), 
kajkosćow (<strong><nowiki>na př. [[Leži w::Němskej]]</nowiki></strong>), 
mjenow (<strong><nowiki>na př. [[Němska]]</nowiki></strong>) a mjenowych rumow (<strong>[[{{ns:help}}:+]]</strong>)',
	'smw_qui_property' => '<strong>Kajkosć</strong>',
	'smw_qui_prop' => 'Kajkosć:',
	'smw_qui_labl' => 'Pomjenowanje:',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Limit:',
	'smw_qui_shownresults' => 'we wuslědkach pokazać',
	'smw_qui_noquery' => 'Naprašowanje njeje so podało',
	'smw_qui_invalidprop' => 'Móže być, zo "$1" płaćiwa kajkosć njeje',
	'smw_qui_invalidformat' => 'Wubrany format "$1" za tutón wiki njeeksistuje',
	'smw_qui_nosort' => 'Žane sortěrowanje',
	'smw_qui_ascorder' => 'Postupowacy',
	'smw_qui_descorder' => 'Spadowacy',
	'smw_qui_randorder' => 'Připadny',
	'smw_qui_addnprop' => 'kajkosć přidać',
	'smw_qui_delete' => 'Wotstronić',
	'smw_qui_rescol' => 'Naprašowanske wuslědki',
	'smw_qui_options' => 'opcije',
	'smw_qui_addcategory' => 'kategoriju přidać',
	'smw_qui_addrescol' => 'naprašowanske wuslědki přidać',
	'smw_qui_ok' => 'W porjadku',
	'smw_qui_cancel' => 'Přetorhnyć',
	'smw_qui_category' => '<strong>Kategorija</strong>',
	'smw_qui_label' => 'Pomjenowanje',
	'smw_prp_options' => 'Opcije kajkosćow',
	'smw_qui_catopts' => 'Opcije kategorijow',
	'smw_qui_mainlabopts' => 'Opcije wuslědkow',
	'smw_qui_dlabel' => 'Pomjenowanje:',
	'smw_qui_dcategory' => 'Kategorija:',
	'smw_qui_dcatyes' => 'Tekst, kotryž ma so pokazać, hdyž kategorija eksistuje:',
	'smw_qui_dcatno' => 'Tekst, kotryž ma so pokazać, hdyž kategorija njeeksistuje:',
	'searchbyproperty' => 'Po atribuće pytać',
	'smw_sbv_docu' => 'Wšě strrony pytać, kotrež maja wěstu kajkosć a hódnotu.',
	'smw_sbv_novalue' => 'Zapodaj płaćiwu hódnotu za kajkosć abo wobhladaj sej wšě hódnoty kajkosće za "$1".',
	'smw_sbv_displayresult' => 'Lisćina wšěch stronow, kotrež maja kajkosć "$1" z hódnotu "$2"',
	'smw_sbv_displayresultfuzzy' => 'Lisćina wšěch stronow, kotrež maja kajkosć "$1" z hódnotu "$2".
Dokelž je jenož mało wuslědkow, so tež podobne hódnoty nalistuja.',
	'smw_sbv_property' => 'Kajkosć:',
	'smw_sbv_value' => 'Hódnota:',
	'smw_sbv_submit' => 'Wuslědki namakać',
	'browse' => 'Wiki přepytać',
	'smw_browselink' => 'Kajkosće přepytać',
	'smw_browse_article' => 'Zapodaj mjeno strony, wot kotrejež ma so pytanje započeć.',
	'smw_browse_go' => 'Wotpósłać',
	'smw_browse_show_incoming' => 'kajkosće pokazać, kotrež sem wotkazuja',
	'smw_browse_hide_incoming' => 'kajkosće schować, kotrež sem wotkazuja',
	'smw_browse_no_outgoing' => 'Tuta strona nima kajkosće.',
	'smw_browse_no_incoming' => 'Žane kajkosće k tutej stronje njewotkazuja.',
	'smw_inverse_label_default' => '$1 z',
	'smw_inverse_label_property' => 'Pomjenowanje nawopačneje kajkosće',
	'pageproperty' => 'Pytanje kajkosćow strony',
	'smw_pp_docu' => 'Pytaj wšě hódnoty kajkosće na datej stronje.
Zapodaj stronu kaž tež kajkosć.',
	'smw_pp_from' => 'Ze strony',
	'smw_pp_type' => 'Kajkosć',
	'smw_pp_submit' => 'Wuslědki namakać',
	'smw_result_prev' => 'Předchadny',
	'smw_result_next' => 'Přichodny',
	'smw_result_results' => 'Wuslědki',
	'smw_result_noresults' => 'Žane wuslědki.',
	'smwadmin' => 'Administraciske funkcije za Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Składowanska jednotka je so wuspěšnje nastajiła.',
	'smw_smwadmin_return' => 'Wróćo k $1',
	'smw_smwadmin_updatestarted' => 'Nowy proces aktualizacije za wobnowjenje semantiskich datow bu startowany.
Wšě składowane daty budu so znowa tworić abo porjedźeć, hdźež je to trěbne.
Móžeš proces aktualizacije na tutej specialnej stronje slědować.

Wróćo k $1.',
	'smw_smwadmin_updatenotstarted' => 'Proces aktualizacije hižo běži.
Nowy so njezapočnje.

Wróćo k $1.',
	'smw_smwadmin_updatestopped' => 'Wšě eksistowace aktualizaciske procesy su so zastajili.

Wróćo k $1.',
	'smw_smwadmin_updatenotstopped' => 'Zo by běžny aktualizowanski proces zastajił, dyrbiš kontrolny kašćik aktiwizować, zo by podał, zo sy sej woprawdźe wěsty.

Wróćo k $1.',
	'smw_smwadmin_docu' => 'Tuta specialna strona ći za instalaciju a akutalizaciju <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a> pomha.
Njezabudź hódnotne daty zawěsćić, prjedy hač administratiwne funkcije wuwjedźeš.',
	'smw_smwadmin_db' => 'Instalacija a aktualizacija datoweje banki',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki trjeba někotre rozšěrjenja na datowej bance MediaWiki, zo by semantiske daty składował.
Slědowaca funkcija zawěsćuje, zo twoja datowa banka je prawje zarjadowana.
Změny, kotrež so w tutym kroku činja, njewobwliwuja zbytk datowje banki MediaWiki a dadźa so lochko cofnyć, jeli požadane.
Tuta zarjadowanska funkcija da so wjacore razy wuwjesć, bjeztoho zo so škoda zawinuje, je wšak jenož jedyn raz při instalaciji abo aktualizaciji trěbna.',
	'smw_smwadmin_permissionswarn' => 'Jeli operacija so ze zmylkami SQL njeradźi, najskerje wužiwar datoweje banki, kotrehož twój wiki wužiwa (hlej twoju dataju LocalSettings.php), dosahace prawa nima.
Zaruč tute přidatne wužiwarske prawa za wutworjenje a wušmórnjenje tabelow, zapodaj nachwilu přizjewjenje twojeho administratora datoweje banki do dataje LocalSettings.php abo wužij wothladowanski skript <tt>SMW_setup.php</tt>, kotryž móže wužiwarske daty administratora wužiwać.',
	'smw_smwadmin_dbbutton' => 'Tabele inicializować abo aktualizować',
	'smw_smwadmin_announce' => 'Twój wiki připowědźić',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki ma websłužbu za wozjewjenje nowych semantiskich wikisydłow.
To so wužiwa, zo by so lisćina zjawnych sydłow wothladowała, kotrež Semantic MediaWiki wužiwaja, hłownje, zo by <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektej Semantic MediaWiki</a> pomhała, zo by přehlad wo typiskich wužiwanskich móžnosćach Semantic MediaWiki dóstał.
Hlej startowu stronu Semantic MediaWiki za <a href="http://semantic-mediawiki.org/wiki/Registry">dalše informacije wo tutej słužbje</a>.',
	'smw_smwadmin_announcebutton' => 'Klikń na slědowace tłóčatko, zo by swój wikijowy URL tutej słužbje pósłał.
Słužba njebudźe wikije registrować, kotrež zjawnje přistupnje njejsu, a budźe jenož zjawnje přistupne informacije składować.',
	'smw_smwadmin_datarefresh' => 'Porjedźenje a aktualizacija datow',
	'smw_smwadmin_datarefreshdocu' => 'Je móžno wšě daty ze Semantic MediaWiki na zakładźe aktualneho wobsaha wikija wobnowić. To móže wužitne być, zo bychu so wobškodźene daty porjedźili abo daty aktualizowali, jeli interny format je so aktualizacije softwary dla změnił.
Aktualizacija so stronu po stronu přewjedźe a njebudźe so hnydom kónčić.
Naslědne pokazuje, jeli aktualizacija so wotměwa a ći dowoluje aktualizacije startować abo zastajić (chibazo tuta funkcija bu wot administratora sydła znjemóžnjena).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Aktualizacija so hižo wotměwa.</strong>
Je normalnje, zo so aktualizacija jenož pomału wotměwa, dokelž daty jenož w małych porcijach kóždy raz, hdyž wužiwar ma přistup na wiki, aktualizuje.
Zo by tutu aktualizaciju spěšnišo skónčił, móžeš wothladowanski skript MediaWiki <tt>runJobs.php</tt> zawołać (wužij opciju <tt>--maxjobs 1000</tt>, zo by ličbu aktualizacijow, kotrež so z jednym wotmachom přewjedu, wobmjezował).
Trochowany staw aktualneje aktualizacije:',
	'smw_smwadmin_datarefreshbutton' => 'Aktualizaciju datow započeć',
	'smw_smwadmin_datarefreshstop' => 'Tutu aktualizaciju zastajić',
	'smw_smwadmin_datarefreshstopconfirm' => 'Haj, sym wěsty.',
	'smw_smwadmin_support' => 'Podpěru dóstać',
	'smw_smwadmin_supportdocu' => 'Wšelake resursy móhli ći w problemowych padach pomhać:',
	'smw_smwadmin_installfile' => 'Jeli su problemy z twojej instalaciju, wobhladaj sej směrnicy w <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">dataji INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Kompletna wužiwarska dokumentacija za Semantic MediaWiki je na <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Zmylki móžeš w systemje <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> zdźělić.',
	'smw_smwadmin_questions' => 'Jeli maš dalše prašenja abo namjety, wobdźěl so na diskusiji na <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">wužiwarskim forumje Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struktura datow',
	'smw_adminlinks_displayingdata' => 'Zwobraznjenje datow',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoc za rjadowe wotprašowanja',
	'smw-createproperty-isproperty' => 'To je kajkosć typa $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Dowolena hódnota za tutu kajkosć je|Dowolenej hódnoće za tutu kajkosć stej|Dowolene hódnoty za tutu kajkosć su|Dowolene hódnoty za tutu kajkosć su}}:',
	'smw-paramdesc-category-delim' => 'Dźělatko',
	'smw-paramdesc-category-template' => 'Předłoha, z kotrejž zapiski maja so formatować',
	'smw-paramdesc-category-userparam' => 'Parmeter, kotryž ma so předłoze přepodać',
	'smw-info-par-message' => 'Powěsć, kotraž ma so zwobraznić.',
	'smw-info-par-icon' => 'Symbol, kotryž ma so pokazać, pak "info" pak "warnowanje".',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Semantiske pytanske opcije',
	'smw-prefs-intro-text' => 'Slědowace nastajenja so wot [http://semantic-mediawiki.org/ Semantic MediaWiki]  (abo podobnych rozšěrjenjow) k dispoziciji steja, zo bychu indiwiduelne přiměrjenje za wubrane funkcije zmóžnili. Za dalše informacije hlej tutón [http://semantic-mediawiki.org/wiki/Help:User_preferences wotrězk pomocy]',
	'smw-prefs-ask-options-tooltip-display' => 'Parametrowy tekst jako spěšne info zwobraznić',
	'smw-prefs-ask-options-collapsed-default' => 'Kašćik opcijow po standardźe sfałdowany zmóžnić',
	'smw-ui-tooltip-title-property' => 'Kajkosć',
	'smw-ui-tooltip-title-quantity' => 'Mnóstwo',
	'smw-ui-tooltip-title-info' => 'Informacije',
	'smw-ui-tooltip-title-service' => 'Słužbne wotkazy',
	'smw-ui-tooltip-title-warning' => 'Zmylk',
	'smw-ui-tooltip-title-parameter' => 'Parameter',
	'smw-ui-tooltip-title-event' => 'Podawk',
	'smw_unknowntype' => 'Typ tuteje kajkosće je njepłaćiwy',
);

/** Haitian (Kreyòl ayisyen)
 * @author Boukman
 * @author Jvm
 * @author Masterches
 */
$messages['ht'] = array(
	'smw_viewasrdf' => 'Wè tankou fòma RDF',
	'smw_finallistconjunct' => ', epi',
	'smw_factbox_head' => 'Bagay an relasyon ak $1',
	'smw_isspecprop' => 'Pwopryete sa espesyal toutbon nan wiki sa',
	'smw_baduri' => 'Eskize nou, URIs yo pou domèn "$1" pa otorize, oubyen li pa disponib nan plas isit la.',
	'smw_iq_disabled' => 'Eskize nou. Rechèch nan atik wiki sa a pa otorize oubyen nou dezaktive l.',
	'smw_iq_moreresults' => '… lòt rezilta yo',
	'smw_parseerror' => 'Valè ou bay oubyen sa li retounen pa klè, nou pa kapab konprann li.',
	'smw_notitle' => 'Nou pa kapab itilize "$1" tankou non yon paj nan wiki sa.',
	'smw_manytypes' => 'Plizyè tip done pase  nan atribi.',
	'smw_emptystring' => 'Chèn mo ou bay an pa dwe vid.',
	'smw_maxstring' => 'Chèn reprezantasyon $1 an two long.',
	'smw_notinenum' => '"$1" pa nan lis valè posib pou ($2) pou atribi, pwopryete a.',
	'smw_noboolean' => '"$1" pa rekonèt tankou yon valè bouleyen (vre/fo).',
	'smw_true_words' => 'vre,v,wi,w',
	'smw_false_words' => 'fo,f,non,n',
	'smw_nofloat' => '"$1" pa yon nimewo.',
	'smw_infinite' => 'Nimewo ki gwo tankou "$1" pa sipòte.',
	'smw_unknowntype' => 'Tip done "$1" yo ki pa sipòte retounen nan atribi a.', # Fuzzy
);

/** Hungarian (magyar)
 * @author Dani
 * @author Glanthor Reviol
 * @author TK-999
 */
$messages['hu'] = array(
	'smw-desc' => "A wiki elérhetőbbé tétele – gépek ''és'' emberek számára is ([http://semantic-mediawiki.org/wiki/Help:User_manual online dokumentáció])",
	'smw_viewasrdf' => 'RDF hírcsatorna',
	'smw_finallistconjunct' => ', és',
	'smw_factbox_head' => '$1-tények',
	'smw_isspecprop' => 'Ez a tulajdonság különleges ebben a wikiben.',
	'smw_concept_description' => 'A(z) „$1” koncepció leírása',
	'smw_no_concept_namespace' => "Koncepciókat csak a ''Koncepció:'' névtérben levő lapokon lehet megadni.",
	'smw_multiple_concepts' => 'Minden koncepció lapon csak egy koncepció definíciója szerepelhet.',
	'smw_concept_cache_miss' => 'A(z) „$1” koncepció nem használható pillanatnyilag, mivel a wiki konfigurációja szerint kapcsolat nélküli módban kell kiszámítani.
Ha a probléma nem szűnik meg bizonyos idő elteltével, kérd az oldal adminisztrátorát hogy tegye elérhetővé a koncepciót.',
	'smw_noinvannot' => 'Inverz tulajdonságokhoz nem lehet értékeket rendelni.',
	'version-semantic' => 'Szemantikai kiterjesztések',
	'smw_baduri' => '„$1” formájú URI-k nem engedélyezettek.',
	'smw_printername_count' => 'Eredmények megszámlálása',
	'smw_printername_csv' => 'CSV exportálás',
	'smw_printername_dsv' => 'DSV formátumú exportálás',
	'smw_printername_debug' => 'Lekérdezés hibakeresése (szakértőknek)',
	'smw_printername_embedded' => 'Lap tartalmának beágyazása',
	'smw_printername_json' => 'JSON exportálás',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Felsorolás',
	'smw_printername_ul' => 'Részletezés',
	'smw_printername_rss' => 'RSS exportálás',
	'smw_printername_table' => 'Táblázat',
	'smw_printername_broadtable' => 'Széles táblázat',
	'smw_printername_template' => 'Sablon',
	'smw_printername_rdf' => 'RDF formátumú exportálás',
	'smw_printername_category' => 'Kategória',
	'smw-paramdesc-limit' => 'Legfeljebb ennyi eredmény megjelenítése',
	'smw-paramdesc-headers' => 'Fejlécek/tulajdonságnevek megjelenítése',
	'smw-paramdesc-mainlabel' => 'A kezdőlap nevének címkéje',
	'smw-paramdesc-link' => 'Az értékek hivatkozásként jelenjenek meg',
	'smw-paramdesc-intro' => 'A lekérdezés eredményei előtt megjelenő szöveg',
	'smw-paramdesc-outro' => 'A lekérdezés eredményei után megjelenő szöveg',
	'smw-paramdesc-default' => 'Megjelenítendő szöveg, ha a lekérdezésnek nincs eredménye',
	'smw-paramdesc-sep' => 'Az értékek közötti elválasztó',
	'smw-paramdesc-distribution' => 'Az összes érték megjelenítése helyett számolja meg az előfordulásukat, és mutassa azokat.',
	'smw-paramdesc-distributionsort' => 'Értékszórás rendezése előfordulások száma szerint.',
	'smw-paramdesc-distributionlimit' => 'Értékszórás korlátozása néhány érték előfordulásának számára',
	'smw-paramdesc-template' => 'Egy sablon neve, amellyel megjelenítendő a kiírás',
	'smw-paramdesc-columns' => 'A keresési eredmények oszlopainak száma (az alapértelmezett $1)',
	'smw-paramdesc-introtemplate' => 'A lekérdezés eredményei előtt (ha vannak) megjelenítendő sablon neve',
	'smw-paramdesc-outrotemplate' => 'A lekérdezés eredményei után (ha vannak) megjelenítendő sablon neve',
	'smw-paramdesc-embedformat' => 'A címsorokhoz használt HTML-tag',
	'smw-paramdesc-embedonly' => 'Fejlécek kikapcsolása',
	'smw-paramdesc-table-class' => 'A táblázathoz beállítandó extra CSS osztály',
	'smw-paramdesc-rsstitle' => 'A hírcsatorna címeként használt szöveg',
	'smw-paramdesc-rssdescription' => 'A hírcsatorna leírásaként használt szöveg',
	'smw-paramdesc-rdfsyntax' => 'A használandó RDF-változat',
	'smw-paramdesc-csv-sep' => 'A használandó elválasztójel',
	'smw-paramdesc-dsv-separator' => 'A használandó elválasztójel',
	'smw-paramdesc-dsv-filename' => 'A DSV-fájl neve',
	'smw-smwdoc-description' => 'Egy táblázatot jelenít meg azon összes paraméterrel, amelyek az alapértékekkel és -leírásokkal együtt használhatóak a megadott célformátumban.',
	'smw-smwdoc-par-format' => 'A célfrmátum, amelynek paramétereinek dokumentációját meg kell jeleníteni.',
	'smw-smwdoc-par-parameters' => 'A megjelenítendő paraméterek. "specific" a formátum által hozzáadottakhoz, "base" a minden formátumban elérhetőkhöz és "all" mindkét fajtához.',
	'smw-paramdesc-sort' => 'A tulajdonság, amely szerint rendezni kell a lekérdezést',
	'smw-paramdesc-order' => 'A lekérdezések rendezési sorrendje',
	'smw-paramdesc-searchlabel' => 'Az eredményekre mutató hivatkozás szövege', # Fuzzy
	'smw-paramdesc-named_args' => 'Nevezd meg a sablonba átküldendő argumentumokat',
	'smw_iq_disabled' => 'A szemantikus lekérdezések le vannak tiltva ezen a wikin.',
	'smw_iq_moreresults' => '… további eredmények',
	'smw_parseerror' => 'A megadott érték nem érthető.',
	'smw_notitle' => 'A(z) „$1” nem használható lap neveként ebben a wikiben.',
	'smw_noproperty' => 'A(z) "$1" nem használható tulajdonság neveként ebben a wikiben.',
	'smw_wrong_namespace' => 'Csak a(z) „$1” névtérbeli lapok engedélyezettek itt.',
	'smw_manytypes' => 'Egynél több megadott típus a tulajdonsághoz.',
	'smw_emptystring' => 'Üres sztringek nem elfogadhatóak.',
	'smw_maxstring' => 'A(z) „$1” szöveges reprezentáció túl hosszú.',
	'smw_notinenum' => '„$1” nincs a lehetséges értékek listájában ($2) ehhez a tulajdonsághoz.',
	'smw_noboolean' => '„$1” nem értelmezhető mint logikai (igaz/hamis) érték',
	'smw_true_words' => 'igaz,igen,i',
	'smw_false_words' => 'hamis,nem,n',
	'smw_nofloat' => '„$1” nem egy szám.',
	'smw_infinite' => 'Ilyen nagy számok („$1”) nem támogatottak.',
	'smw_unitnotallowed' => 'A(z) "$1" nem érvényes mértékegysége ennek a tulajdonságnak.',
	'smw_nounitsdeclared' => 'Nem határozták meg mértékegységet ennek a tulajdonságnak.',
	'smw_novalues' => 'Nincsenek megadva értékek.',
	'smw_nodatetime' => 'A(z) „$1” dátum nem értelmezhető.',
	'smw_toomanyclosing' => 'A(z) „$1” túl sokszor fordul elő a lekérdezésben.',
	'smw_noclosingbrackets' => 'A lekérdezésben szerepelnek nyitó szögletes zárójelek „(<nowiki>[[</nowiki>)” a lezáró párjuk („]]”) nélkül.',
	'smw_misplacedsymbol' => 'A(z) „$1” szimbólum egy olyan helyen volt használva, ahol nincs haszna.',
	'smw_unexpectedpart' => 'A lekérdezés „$1” része nem értelmezhető.
Az eredmények eltérhetnek a várttól.',
	'smw_emptysubquery' => 'Valamely allekérdezés nem tartalmaz érvényes feltételt.',
	'smw_misplacedsubquery' => 'Allekérdezés volt egy olyan helyen, ahol nem engedélyezettek az allekérdezések.',
	'smw_valuesubquery' => 'A(z) „$1” tulajdonság értékeinél nem támogatottak az allekérdezések.',
	'smw_badqueryatom' => 'A lekérdezés egy részét („<nowiki>[[…]]</nowiki>”) nem sikerült értelmezni.',
	'smw_propvalueproblem' => 'A(z) „$1” tulajdonság értéke nem értelmezhető.',
	'smw_noqueryfeature' => 'A lekérdezés egyes részei nem támogatottak ebben a wikiben, így a lekérdezés egy része el lett dobva ($1).',
	'smw_noconjunctions' => 'A konjunkció a lekérdezésekben nem támogatott ebben a wikiben, így a lekérdezés egy része el lett dobva ($1).',
	'smw_nodisjunctions' => 'A diszjunkció a lekérdezésekben nem támogatott ebben a wikiben, így a lekérdezés egy része el lett dobva ($1).',
	'smw_querytoolarge' => 'A következő lekérdezés-feltételek nem lettek figyelembe véve a wikin érvényes lekérdezésméret vagy -mélység-korlátozások miatt: $1',
	'smw_notemplategiven' => 'Adj értéket a lekérdezés „paramétersablonjának”, hogy működjön ez a lekérdezésformátum.',
	'smw_db_sparqlqueryproblem' => 'A lekérdezés eredméynét nem tudtuk begyűjteni a SPARQL adatbázisból. Ez a hiba ideiglenes, de az adatbázisszoftver hibáját is jelentheti.',
	'smw_db_sparqlqueryincomplete' => 'A lekérdezés megválaszolása túl nehéznek bizonyult és megszakadt. Néhány eredmény hiányozhat. Ha lehet, próbálkozz egyszerűbb lekérdezéssel.',
	'smw_type_header' => 'A(z) „$1” típus tulajdonságai',
	'smw_typearticlecount' => '{{PLURAL:$1|Egy|$1}} tulajdonság megjelenítése ezen típus használatával.',
	'smw_attribute_header' => 'A(z) „$1” tulajdonságot használó lapok',
	'smw_attributearticlecount' => '{{PLURAL:$1|Egy|$1}} lap megjelenítése ezen tulajdonság használatával.',
	'smw_subproperty_header' => 'Altulajdonságok',
	'smw_subpropertyarticlecount' => 'Ez a tulajdonság a következő {{PLURAL:$1|egy|$1}} altulajdonsággal rendelkezik:',
	'smw_concept_header' => 'A(z) „$1” koncepcióhoz tartozó lapok',
	'smw_conceptarticlecount' => 'A koncepcióhoz tartozó $1 lap megjelenítése.',
	'specialpages-group-smw_group' => 'Szemantikus MediaWiki',
	'exportrdf' => 'Lapok exportálása RDF-be',
	'smw_exportrdf_docu' => 'Ez a lap lehetőséget teremt adatok beszerzésére egy lapról RDF formátumban.
A lapok exportálásához írd be a címeiket az alábbi szövegdobozba, soronként egyet.',
	'smw_exportrdf_recursive' => 'Az összes kapcsolódó lap rekurzív exportálása.
Az eredmény elég nagy lehet!',
	'smw_exportrdf_backlinks' => 'Kimenti az összes lapot, ami hivatkozik az exportált lapokra.
Böngészhető RDF-et készít.',
	'smw_exportrdf_lastdate' => 'Ne exportáljon lapokat, amelyek nem változtak mióta a megadott időpont óta.',
	'smw_exportrdf_submit' => 'Exportálás',
	'uriresolver' => 'URI feloldó',
	'properties' => 'Tulajdonságok',
	'smw_properties_docu' => 'A wikiben az alábbi tulajdonságok használatosak.',
	'smw_property_template' => '$2 típusú $1 ($3)',
	'smw_propertylackspage' => 'Minden tulajdonságnak kell hogy legyen leírólapja!',
	'smw_propertylackstype' => 'Nincs típus megadva ehhez a tulajdonsághoz ($1 típus feltételezése).',
	'smw_propertyhardlyused' => 'Ez a tulajdonság aligha használatos a wikiben!',
	'unusedproperties' => 'Nem használt tulajdonságok',
	'smw_unusedproperties_docu' => 'A következő tulajdonságok habár léteznek, de egyetlen lap sem használja őket.',
	'smw_unusedproperty_template' => '$2 típusú $1',
	'wantedproperties' => 'Keresett tulajdonságok',
	'smw_wantedproperties_docu' => 'A következő tulajdonságok használva vannak a wikiben, azoban még nem rendelkeznek leíró lappal.',
	'smw_wantedproperty_template' => '$1 ($2 helyen használva)',
	'smw_purge' => 'Frissítés',
	'types' => 'Típusok',
	'smw_types_docu' => 'Ez a tulajdonságokhoz rendelhető adattípusok listáját tartalmazza.',
	'semanticstatistics' => 'Szemantikus statisztika',
	'smw_semstats_text' => "Ez a wiki '''$1''' tulajdonságértéket tartalmaz '''$2''' [[Special:Properties|különböző tulajdonsághoz]].
'''$3''' tulajdonság rendelkezik saját lappal, és '''$4''' adattípusa van megadva.
A létező tulajdonságok egy része [[Special:UnusedProperties|használaton kívüli]] lehet.
A lappal nélküli tulajdonságok a [[Special:WantedProperties|keresett tulajdonságok listáján]] tekinthetőek meg.",
	'smw_uri_doc' => 'Az URI-feloldó implementálja a <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>-ben meghatározottakat.
Biztosítja, hogy az emberek ne váljanak weboldalakká.',
	'ask' => 'Szemantikus keresés',
	'smw_ask_sortby' => 'Rendezés oszlopok szerint (nem kötelező)',
	'smw_ask_ascorder' => 'Növekvő',
	'smw_ask_descorder' => 'Csökkenő',
	'smw_ask_submit' => 'Eredmények keresése',
	'smw_ask_editquery' => '[Lekérdezés szerkesztése]',
	'smw_add_sortcondition' => '[Rendezési feltétel hozzáadása]',
	'smw_ask_hidequery' => 'Lekérdezés elrejtése',
	'smw_ask_help' => 'Lekérdezések súgója',
	'smw_ask_queryhead' => 'Lekérdezés',
	'smw_ask_printhead' => 'További megjelenítendő adatok',
	'smw_ask_printdesc' => '(egy tulajdonságnevet adj meg soronként)',
	'smw_ask_format_as' => 'Formázás mint:',
	'smw_ask_defaultformat' => 'alapértelmezett',
	'smw_ask_otheroptions' => 'Egyéb beállítások',
	'smw_ask_show_embed' => 'Beágyazási kód megjelenítése',
	'smw_ask_hide_embed' => 'Beágyazási kód elrejtése',
	'smw_ask_embed_instr' => 'Ha egy wikilapra szeretnéd beilleszteni ezt a lekérdezést, másold be az alábbi kódot.',
	'smw-ask-delete' => '[Törlés]',
	'querycreator' => 'Lekérdezés létrehozása',
	'smw_qc_show_addnal_opts' => 'Több beállítási lehetőség megjelenítése',
	'smw_qc_hide_addnal_opts' => 'Kevesebb beállítási lehetőség megjelenítése',
	'smw_qc_otheropt' => 'Egyéb beállítások',
	'smw_qc_formatopt' => 'Formátum beállításai',
	'smw_qc_query_help' => 'Az alábbi űrlap segítségével lekérdezést adhatsz meg. A wiki lapjait kiválaszthatod
kategóriák (<strong>[[{{ns:category}}:Actor]]</strong>),
tulajdonságok (<strong>[[Located in::Germany]]</strong>),
nevek(<strong>[[Germany]]</strong>) és névterek (<strong>[[{{ns:help}}:+]]</strong>) alapján.', # Fuzzy
	'smw_qui_property' => '<strong>Tulajdonság</strong>',
	'smw_qui_prop' => 'Tulajdonság:',
	'searchbyproperty' => 'Keresés tulajdonság szerint',
	'smw_sbv_docu' => 'Az összes olyan lap megkeresése, ami a megadott tulajdonsággal és értékkel rendelkezik.',
	'smw_sbv_novalue' => 'Add meg a tulajdonság egy érvényes értékét, vagy nézd meg a(z) „$1” összes tulajdonság-értékét.',
	'smw_sbv_displayresult' => 'Az össze lap listája, amelyeknek vagy van „$1” tulajdonsága „$2” értékkel',
	'smw_sbv_displayresultfuzzy' => 'Az összes olyan lap listája, melyeknél a(z) „$1” tulajdonság a(z) „$2” értéket veszi fel.
Mivel csak néhány találat van, a közeli értékek is meg vannak jelenítve.',
	'smw_sbv_property' => 'Tulajdonság:',
	'smw_sbv_value' => 'Érték:',
	'smw_sbv_submit' => 'Eredmények keresése',
	'browse' => 'Wiki tallózása',
	'smw_browselink' => 'Tulajdonságok böngészése',
	'smw_browse_article' => 'Add meg a lap nevét, ahonnan el szeretnéd kezdeni a böngészést.',
	'smw_browse_go' => 'Menj',
	'smw_browse_show_incoming' => 'ide hivatkozó tulajdonságok megjelenítése',
	'smw_browse_hide_incoming' => 'ide hivatkozó tulajdonságok elrejtése',
	'smw_browse_no_outgoing' => 'Ehhez a laphoz nem tartoznak tulajdonságok.',
	'smw_browse_no_incoming' => 'Egy tulajdonság sem hivatkozik erre a lapra.',
	'smw_inverse_label_default' => '$1',
	'smw_inverse_label_property' => 'Tulajdonság címkéjének felcserélése',
	'pageproperty' => 'Laptulajdonság keresés',
	'smw_pp_docu' => 'Egy tulajdonság összes értékének keresése egy adott oldalon.
Add meg a lapot és a tulajdonságot is.',
	'smw_pp_from' => 'Ettől a laptól:',
	'smw_pp_type' => 'Tulajdonság',
	'smw_pp_submit' => 'Eredmények keresése',
	'smw_result_prev' => 'Előző',
	'smw_result_next' => 'Következő',
	'smw_result_results' => 'Eredmények',
	'smw_result_noresults' => 'Nincs találat.',
	'smwadmin' => 'A Szemantikus MediaWiki adminisztrációs funkciói',
	'smw_smwadmin_setupsuccess' => 'A tárolómotor sikeresen be lett állítva.',
	'smw_smwadmin_return' => 'Vissza ide: $1',
	'smw_smwadmin_updatestarted' => 'Egy új frissítő folyamat indult a szemantikus adatok frissítése céljából.
Minden tárolt adat újra elő lesz állítva, és javítva lesz, ahol szükséges.
A frissítési folyamat előrehaladását ezen a speciális lapon követheted figyelemmel.

Visszatérés a(z) $1 lapra.',
	'smw_smwadmin_updatenotstarted' => 'Már fut egy frissítő folyamat.
Nem kell újat készíteni.

Visszatérés a(z) $1 lapra.',
	'smw_smwadmin_updatestopped' => 'Minden futó frissítési folyamat leállítva.

Visszatérés a(z) $1 lapra.',
	'smw_smwadmin_updatenotstopped' => 'Az éppen futó frissítési folyamat megszakításához aktiválnod kell a jelölőnégyzetet, hogy jelezd, tényleg biztos vagy benne.

Visszatérés a(z) $1 lapra.',
	'smw_smwadmin_docu' => 'Ez a speciális lap segít a <a href="http://semantic-mediawiki.org">Szemantikus MediaWiki</a> telepítése és frissítése során.
Ne felejts el másolatot készíteni az értékes adatokról az adminisztratív funkciók használata előtt.',
	'smw_smwadmin_db' => 'Adatbázistelepítés és -frissítés',
	'smw_smwadmin_dbdocu' => 'A Szemantikus MediaWikinek szüksége van néhány kiterjesztésre az adatbázison a szemantikus adatok tárolásához.
Az alábbi funkció ellenőrzi, hogy az adatbázis megfelelően be van-e állítva.
Az ezen lépés során végrehajtott változások nincsenek hatással a MediaWiki adatbázisának többi részére, és egyszerűen visszavonható, amennyiben szükséges.
Ez a telepítési lépés többször is végrehajtható, anékül, hogy bármilyen kárt tenne, de csak egyszer szükséges a telepítés vagy frissítés során.',
	'smw_smwadmin_permissionswarn' => 'Ha a művelet SQL-hibákkal leáll, a wikid által használt adatbázis-felhasználó (amit a LocalSettings.php-ben adtál meg) valószínűleg nem rendelkezik a megfelelő jogosultságokkal.
Adj a felhasználó számára táblák készítéséhez és törléséhez jogosultságot, ideiglenesen add meg a root fiók adatait, vagy használd az <tt>SMW_setup.php</tt> karbantartó parancsfájlt, ami egy adminisztrátor adataival lép be.',
	'smw_smwadmin_dbbutton' => 'Táblák inicializálása vagy frissítése',
	'smw_smwadmin_announce' => 'Wiki bejelentése',
	'smw_smwadmin_announcedocu' => 'A Szemantikus MediaWikinek van egy webes szolgáltatása az új szemantikus wikioldalak jelzésére.
Ezt arra használjuk, hogy karbantartsuk azon nyilvános oldalak listáját, melyek Szemantikus MediaWikit használnak, főként azért, hogy segítsük a <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Szemantikus MediaWiki-projektet</a>, így nyerve áttekintést arról, hogy mire használják általában ezt a kiegészítőt.
A szolgáltatásról további információkat <a href="http://semantic-mediawiki.org/wiki/Registry">a Szemantikus MediaWiki honlapján</a> találsz.',
	'smw_smwadmin_announcebutton' => 'Kattints a következő gombra, ha el szeretnéd küldeni a wikid URL-címét ennek a szolgáltatásnak.
A szolgáltatás nem rögzít olyan wikiket, melyek nem érhetőek el nyilvánosan, és csak mindenki számára elérhető információkat gyűjt.',
	'smw_smwadmin_datarefresh' => 'Adatok javítása és aktualizálása',
	'smw_smwadmin_datarefreshdocu' => 'A wiki jelenlegi tartalma alapján lehetőség van az összes Szemantikus MediaWiki-adat helyreállítására.
Ez hasznos lehet a sérült adatok javításakor, vagy az adatok frissítésekor, ha a belső formátum megváltozott szoftverfrissítés miatt.
A frissítés oldalról oldalra van végrehajtva, és nem lesz azonnal kész.
Alább látható, hogy jelenleg folyamatban van-e ilyen frissítés, és elindíthatod vagy leállíthatod a frissítéseket (kivéve, ha az oldal adminisztrátora letiltotta ezt a lehetőséget).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Frissítés folyamatban.</strong>
Normális, ha a frissítés lassan halad, hiszen az adatok csak egy kis részét frissíti minden alkalommal, ha egy felhasználó hozzáfér a wikihez.
Ha gyorsabban be szeretnéd fejezni a frissítést, hívd meg a <tt>runJobs.php</tt> karbantartó parancsfájlt (használd a <tt>--maxjobs 1000</tt> kapcsolót az egy menetben végrehajtott frissítések korlátozásához).
A jelenlegi frissítés becsült előrehaladása:',
	'smw_smwadmin_datarefreshbutton' => 'Adatok frissítésének megkezdése',
	'smw_smwadmin_datarefreshstop' => 'Frissítés megszakítása',
	'smw_smwadmin_datarefreshstopconfirm' => 'Igen, biztos vagyok benne.',
	'smw_smwadmin_support' => 'Segítséget kérek',
	'smw_smwadmin_supportdocu' => 'Különböző források, amelyek segíthetnek problémák esetén:',
	'smw_smwadmin_installfile' => 'Ha problémákat észlelsz a telepítéssel, ellenőrizd az útmutatót az <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL fájlban</a>.',
	'smw_smwadmin_smwhomepage' => 'A Szemantikus MediaWiki teljes felhasználói dokumentációja a <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b> címen található.',
	'smw_smwadmin_mediazilla' => 'A hibákat a <a href="https://bugzilla.wikimedia.org/">Bugzillán</a> lehet jelenteni.',
	'smw_smwadmin_questions' => 'Ha további kérdéseid vagy javaslataid vannak, csatlakozz a <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Szemantikus MediaWiki felhasználói fórumán</a> folyó beszélgetéshez.',
	'smw_adminlinks_datastructure' => 'Adatstruktúra',
	'smw_adminlinks_displayingdata' => 'Adatok megjelenítése',
	'smw_adminlinks_inlinequerieshelp' => 'Szövegbeli lekérdezés-súgó',
	'smw-createproperty-isproperty' => 'Ez egy „$1” típusú tulajdonság.',
	'smw-createproperty-allowedvals' => 'A tulajdonság a következő {{PLURAL:$1|értéket|értékeket}} veheti fel:',
	'smw-paramdesc-category-delim' => 'A határolójel',
	'smw-paramdesc-category-template' => 'Az elemeket formázandó sablon',
	'smw-info-par-message' => 'Megjelenítendő üzenet.',
	'smw-info-par-icon' => 'Megjelenítendő jel, "info" vagy "warning."',
	'smw_unknowntype' => 'A megadott „$1” típus nem támogatott a tulajdonságnál.', # Fuzzy
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'smw-desc' => "Pro render tu wiki plus accessibile – a machinas '''e''' a humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentation in linea])",
	'smw_viewasrdf' => 'Syndication RDF',
	'smw_finallistconjunct' => ', e',
	'smw_factbox_head' => 'Factos super $1',
	'smw_isspecprop' => 'Iste proprietate es special in iste wiki.',
	'smw_concept_description' => 'Description del concepto "$1"',
	'smw_no_concept_namespace' => 'Le conceptos pote solmente esser definite in paginas in le spatio de nomines Concept:.',
	'smw_multiple_concepts' => 'Cata pagina de concepto pote haber un sol definition de concepto.',
	'smw_concept_cache_miss' => 'Le concepto "$1" non pote esser usate al momento, post que le configuration del wiki require que illo sia computate foras de linea. Si le problema non dispare post alcun tempore, demanda al administrator de tu sito de render disponibile iste concepto.',
	'smw_noinvannot' => 'Le valores non pote esser assignate al proprietates inverse.',
	'version-semantic' => 'Extensiones semantic',
	'smw_baduri' => 'Le adresses URI del forma "$1" non es permittite.',
	'smw_rss_link' => 'RSS',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Contar resultatos',
	'smw_printername_csv' => 'Exportation in CSV',
	'smw_printername_dsv' => 'Exportation in DSV',
	'smw_printername_debug' => 'Consulta de debugging (pro expertos)',
	'smw_printername_embedded' => 'Incastrar contento de pagina',
	'smw_printername_json' => 'Exportation in JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeration',
	'smw_printername_ul' => 'Lista detaliate',
	'smw_printername_rss' => 'Exportation in RSS',
	'smw_printername_table' => 'Tabella',
	'smw_printername_broadtable' => 'Tabella large',
	'smw_printername_template' => 'Patrono',
	'smw_printername_rdf' => 'Exportation in RDF',
	'smw_printername_category' => 'Categoria',
	'smw-paramdesc-limit' => 'Le numero maxime de resultatos a retornar',
	'smw-paramdesc-offset' => 'Le position del prime resultato',
	'smw-paramdesc-headers' => 'Monstrar le capites/nomines de proprietate',
	'smw-paramdesc-mainlabel' => 'Le etiquetta a dar al nomine del pagina principal',
	'smw-paramdesc-link' => 'Monstrar valores como ligamines',
	'smw-paramdesc-intro' => 'Le texto a monstrar ante le resultatos del consulta, si existe',
	'smw-paramdesc-outro' => 'Le texto a monstrar post le resultatos del consulta, si existe',
	'smw-paramdesc-default' => 'Le texto a monstrar si le consulta non produce resultatos',
	'smw-paramdesc-sep' => 'Le separator de valores',
	'smw-paramdesc-distribution' => 'In loco de presentar tote le valores, contar lor occurrentias, e monstrar istes.',
	'smw-paramdesc-distributionsort' => 'Ordinar le distribution de valores per numero de occurrentias.',
	'smw-paramdesc-distributionlimit' => 'Limitar le distribution de valores al numero de solmente alcun valores.',
	'smw-paramdesc-template' => 'Le nomine de un patrono con le qual presentar le impressiones',
	'smw-paramdesc-columns' => 'Le numero de columnas in le quales presentar resultatos (predefinition es $1)',
	'smw-paramdesc-userparam' => 'Un valor passate a cata appello de patrono, si un patrono es usate',
	'smw-paramdesc-introtemplate' => 'Le nomine de un patrono a monstrar ante le resultatos del consulta, si existe',
	'smw-paramdesc-outrotemplate' => 'Le nomine de un patrono a monstrar post le resultatos del consulta, si existe',
	'smw-paramdesc-embedformat' => 'Le etiquetta HTML usate pro definir capites',
	'smw-paramdesc-embedonly' => 'Non monstrar capites',
	'smw-paramdesc-table-class' => 'Un classe CSS additional a definir pro le tabella',
	'smw-paramdesc-rsstitle' => 'Le texto a usar como titulo del syndication',
	'smw-paramdesc-rssdescription' => 'Le texto a usar como description del syndicato',
	'smw-paramdesc-rdfsyntax' => 'Le syntaxe RDF a usar',
	'smw-paramdesc-csv-sep' => 'Le separator a usar',
	'smw-paramdesc-dsv-separator' => 'Le separator a usar',
	'smw-paramdesc-dsv-filename' => 'Le nomine del file DSV',
	'smw-smwdoc-description' => 'Presenta un tabella de tote le parametros que pote esser usate pro le formato de resultatos specificate, insimul con lor valores predefinite e lor descriptiones.',
	'smw-smwdoc-par-format' => 'Le formato de resultatos pro le qual presentar le documentation de parametros.',
	'smw-smwdoc-par-parameters' => 'Le parametros a monstrar: "specific" pro illos addite per le formato, "base" pro illos disponibile in tote le formatos, e "all" pro ambes.',
	'smw-paramdesc-sort' => 'Proprietate per le qual ordinar le consulta',
	'smw-paramdesc-order' => 'Ordination del consulta',
	'smw-paramdesc-searchlabel' => 'Texto pro continuar le recerca (predefinition es «… altere resultatos»)', # Fuzzy
	'smw-paramdesc-named_args' => 'Nominar le parametros passate al patrono',
	'smw-paramdesc-export' => 'Option de exportation',
	'smw-paramdesc-prettyprint' => 'Pro imprimer con un disposition plus nette', # Fuzzy
	'smw-paramdesc-source' => 'Fonte alternative de consultas',
	'smw_iq_disabled' => 'Le consultas semantic ha essite disactivate pro iste wiki.',
	'smw_iq_moreresults' => '… ulterior resultatos',
	'smw_parseerror' => 'Le valor date non esseva comprendite.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => '"$1" non pote esser usate como nomine de pagina in iste wiki.',
	'smw_noproperty' => '"$1" non pote esser usate como nomine de proprietate in iste wiki.',
	'smw_wrong_namespace' => 'Solmente le paginas in le spatio de nomines "$1" es permittite hic.',
	'smw_manytypes' => 'Plus de un typo definite pro proprietate.',
	'smw_emptystring' => 'Series de characteres vacue non es acceptate.',
	'smw_maxstring' => 'Le representation de serie de characteres $1 es troppo longe.',
	'smw_notinenum' => '"$1" non es in le lista de valores possibile ($2) pro iste proprietate.',
	'smw_noboolean' => '"$1" non es recognoscite como un valor boolean (ver/false).',
	'smw_true_words' => 'ver,v,si,s',
	'smw_false_words' => 'false,f,no,n',
	'smw_nofloat' => '"$1" non es un numero.',
	'smw_infinite' => 'Le numeros tanto grande como "$1" non es supportate.',
	'smw_unitnotallowed' => '"$1" non es declarate como unitate de mesura valide pro iste proprietate.',
	'smw_nounitsdeclared' => 'Nulle unitate de mesura ha essite declarate pro iste proprietate.',
	'smw_novalues' => 'Nulle valor specificate.',
	'smw_nodatetime' => 'Le data "$1" non esseva comprendite.',
	'smw_toomanyclosing' => 'Il pare haber troppo de occurrentias de "$1" in le consulta.',
	'smw_noclosingbrackets' => 'Alcun uso de "<nowiki>[[</nowiki>" in tu consulta non esseva claudite per un correspondente "]]".',
	'smw_misplacedsymbol' => 'Le symbolo "$1" esseva usate in un loco ubi illo non es utile.',
	'smw_unexpectedpart' => 'Le parte "$1" del consulta non esseva comprendite.
Le resultatos pote non esser como expectate.',
	'smw_emptysubquery' => 'Alcun subconsulta ha nulle condition valide.',
	'smw_misplacedsubquery' => 'Alcun subconsulta esseva usate in un loco ubi nulle subconsultas es permittite.',
	'smw_valuesubquery' => 'Le subconsultas non es supportate pro valores del proprietate "$1".',
	'smw_badqueryatom' => 'Alcun parte "<nowiki>[[…]]</nowiki>" del consulta non esseva comprendite.',
	'smw_propvalueproblem' => 'Le valor del proprietate "$1" non esseva comprendite.',
	'smw_noqueryfeature' => 'Alcun functionalitate de consulta non esseva supportate in iste wiki; un parte del consulta ha essite omittite ($1).',
	'smw_noconjunctions' => 'Le conjunctiones in consultas non es supportate in iste wiki; un parte del consulta ha essite ommittite ($1).',
	'smw_nodisjunctions' => 'Le disjunctiones in consultas non es supportate in iste wiki; un parte del consulta ha essite omittite ($1).',
	'smw_querytoolarge' => 'Le sequente conditiones de consulta non pote esseva considerate a causa del restrictiones de iste wiki concernente le grandor o profunditate del consultas: $1.',
	'smw_notemplategiven' => 'Forni un valor pro le parametro "template" pro facer functionar iste formato de consulta.',
	'smw_db_sparqlqueryproblem' => 'Le resultato del consulta non poteva esser obtenite del base de datos SPARQL. Iste error pote esser temporari o pote indicar un defecto in le software del base de datos.',
	'smw_db_sparqlqueryincomplete' => 'Responder al consulta provava troppo difficile e ha essite abortate. Alcun resultatos pote mancar. Si possibile, tenta usar un consulta plus simple.',
	'smw_type_header' => 'Proprietates del typo "$1"',
	'smw_typearticlecount' => 'Presentation de $1 {{PLURAL:$1|proprietate|proprietates}} que usa iste typo.',
	'smw_attribute_header' => 'Paginas que usa le proprietate "$1"',
	'smw_attributearticlecount' => 'Presentation de $1 {{PLURAL:$1|pagina|paginas}} que usa iste proprietate.',
	'smw_subproperty_header' => 'Subproprietates',
	'smw_subpropertyarticlecount' => 'Iste proprietate ha le sequente $1 {{PLURAL:$1|subproprietate|subproprietates}}:',
	'smw_concept_header' => 'Paginas del concepto "$1"',
	'smw_conceptarticlecount' => 'Presentation de $1 {{PLURAL:$1|pagina|paginas}} que appertine a ille concepto.',
	'smw_rss_description' => 'Syndication RSS de $1',
	'specialpages-group-smw_group' => 'MediaWiki semantic',
	'exportrdf' => 'Exportar paginas verso RDF',
	'smw_exportrdf_docu' => 'Iste pagina permitte obtener le datos de un pagina in formato RDF.
Pro exportar pagina, entra le titulos in le quadro de texto in basso, un titulo per linea.',
	'smw_exportrdf_recursive' => 'Exportar recursivemente tote le paginas connexe.
Nota que le resultato pote esser grande!',
	'smw_exportrdf_backlinks' => 'Exportar equalmente tote le paginas con referentias al paginas exportate.
Genera un RDF navigabile.',
	'smw_exportrdf_lastdate' => 'Non exportar paginas que non esseva cambiate post le momento specificate.',
	'smw_exportrdf_submit' => 'Exportar',
	'uriresolver' => 'Resolvitor de URI',
	'properties' => 'Proprietates',
	'smw_properties_docu' => 'Le sequente proprietates es usate in le wiki.',
	'smw_property_template' => '$1 del typo $2 ($3)',
	'smw_property_template_notype' => '$1 ($2)',
	'smw_propertylackspage' => 'Tote le proprietates debe esser describite per un pagina!',
	'smw_propertylackstype' => 'Nulle typo esseva specificate pro iste proprietate (es assumite le typo $1 pro le momento).',
	'smw_propertyhardlyused' => 'Iste proprietate es a pena usate in iste wiki!',
	'unusedproperties' => 'Proprietates non usate',
	'smw_unusedproperties_docu' => 'Le sequente proprietates existe ben que nulle altere pagina los utilisa.',
	'smw_unusedproperty_template' => '$1 del typo $2',
	'wantedproperties' => 'Proprietates desirate',
	'smw_wantedproperties_docu' => 'Le sequente proprietates es uate in le wiki sed non ha ancora un pagina pro describer los.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'smw_purge' => 'Refrescar',
	'types' => 'Typos',
	'smw_types_docu' => 'Le sequente lista contine tote le typos de datos que pote esser assignate a proprietates.',
	'semanticstatistics' => 'Statisticas semantic',
	'smw_semstats_text' => "Iste wiki contine '''$1''' {{PLURAL:$1|valor|valores}} de proprietate pro un total de '''$2'''
[[Special:Properties|{{PLURAL:$2|proprietate|proprietates distincte}}]].
<b>$3</b> {{PLURAL:$3|proprietate ha su proprie pagina|proprietates ha lor proprie paginas}}, e le typo de datos intendite es specificate pro '''$4''' de {{PLURAL:$3|illo|illos}}.
Alcunes del proprietates existente pote esser [[Special:UnusedProperties|proprietates non usate]].
Le proprietates al quales manca ancora un pagina se trova in le [[Special:WantedProperties|lista de proprietates desirate]].",
	'smw_uri_doc' => 'Le resolvitor de URL implementa le <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">conclusion del Gruppo de Architectura Technic del W3C a proposito de httpRange-14</a>.
Illo assecura que le humanos non se transforma in sitos web.',
	'ask' => 'Recerca semantic',
	'smw_ask_sortby' => 'Ordinar per columna (optional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Cercar resultatos',
	'smw_ask_editquery' => '[Modificar consulta]',
	'smw_add_sortcondition' => '[Adder condition de ordinamento]',
	'smw_ask_hidequery' => 'Celar consulta',
	'smw_ask_help' => 'Adjuta super le consultas',
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Datos additional a presentar',
	'smw_ask_printdesc' => '(adde un nomine de proprietate per linea)',
	'smw_ask_format_as' => 'Formatar in:',
	'smw_ask_defaultformat' => 'predefinition',
	'smw_ask_otheroptions' => 'Altere optiones',
	'smw_ask_show_embed' => 'Revelar codice de incastrar',
	'smw_ask_hide_embed' => 'Celar codice de incastrar',
	'smw_ask_embed_instr' => 'Pro incastrar iste consulta in linea in un pagina wiki usa le codice sequente.',
	'smw-ask-delete' => '[Deler]',
	'querycreator' => 'Creator de consultas',
	'smw_qc_addmainlabel' => 'Adder etiquetta principal',
	'smw_qc_show_addnal_opts' => 'Monstrar plus optiones',
	'smw_qc_hide_addnal_opts' => 'Monstrar minus optiones',
	'smw_qc_otheropt' => 'Altere optiones',
	'smw_qc_intro' => 'Prefacio:',
	'smw_qc_outro' => 'Postfacio:',
	'smw_qc_default' => 'Predefinition:',
	'smw_qc_formatopt' => 'Optiones de formato',
	'smw_qc_query_help' => 'Specifica un consulta in le formulario sequente pro seliger paginas wiki a base de 
Categorias (<strong>[[{{ns:category}}:Actor]]</strong>), 
Proprietates (<strong>[[Localisate in::Germania]]</strong>), 
Nomines (<strong>[[Germania]]</strong>) e Spatios de nomines (<strong>[[{{ns:help}}:+]]</strong>)', # Fuzzy
	'smw_qui_property' => '<strong>Proprietate</strong>',
	'smw_qui_prop' => 'Proprietate:',
	'smw_qui_labl' => 'Etiquetta:',
	'smw_qui_formt' => 'Formato:',
	'smw_qui_limt' => 'Limite:',
	'smw_qui_shownresults' => 'monstrar in resultatos',
	'smw_qui_noquery' => 'Nulle consulta ha essite specificate',
	'smw_qui_invalidprop' => '"$1" pote esser un proprietate invalide',
	'smw_qui_invalidformat' => 'Le formato seligite "$1" non existe pro iste wiki',
	'smw_qui_nosort' => 'Nulle ordination',
	'smw_qui_ascorder' => 'Ascendente',
	'smw_qui_descorder' => 'Descendente',
	'smw_qui_randorder' => 'Aleatori',
	'smw_qui_addnprop' => 'adder proprietate',
	'smw_qui_delete' => 'Remover',
	'smw_qui_rescol' => 'Resultatos',
	'smw_qui_options' => 'optiones',
	'smw_qui_addcategory' => 'adder categoria',
	'smw_qui_addrescol' => 'adder resultatos',
	'smw_qui_ok' => 'OK',
	'smw_qui_cancel' => 'Cancellar',
	'smw_qui_category' => '<strong>Categoria</strong>',
	'smw_qui_label' => 'Etiquetta',
	'smw_prp_options' => 'Optiones del proprietate',
	'smw_qui_catopts' => 'Optiones del categoria',
	'smw_qui_mainlabopts' => 'optiones de resultato',
	'smw_qui_dlabel' => 'Etiquetta:',
	'smw_qui_dcategory' => 'Categoria:',
	'smw_qui_dcatyes' => 'Monstrar texto si categoria es presente:',
	'smw_qui_dcatno' => 'Monstrar texto si categoria es absente:',
	'searchbyproperty' => 'Cercar per proprietate',
	'smw_sbv_docu' => 'Cercar tote le paginas que ha un proprietate e valor date.',
	'smw_sbv_novalue' => 'Entra un valor valide pro le proprietate, o vide tote le valores possibile del proprietate "$1".',
	'smw_sbv_displayresult' => 'Un lista de tote le paginas que ha le proprietate "$1" con valor "$2"',
	'smw_sbv_displayresultfuzzy' => 'Un lista de tote le paginas que ha le proprietate "$1" con valor "$2".
Post que il ha pauc resultatos, le valores proxime es equalmente monstrate.',
	'smw_sbv_property' => 'Proprietate:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Cercar resultatos',
	'browse' => 'Percurrer le wiki',
	'smw_browselink' => 'Percurrer proprietates',
	'smw_browse_article' => 'Entra le nomine del pagina ab le qual tu vole initiar le exploration.',
	'smw_browse_go' => 'Va',
	'smw_browse_more' => '…',
	'smw_browse_show_incoming' => 'monstrar le proprietates con ligamines verso hic',
	'smw_browse_hide_incoming' => 'celar le proprietates con ligamines verso hic',
	'smw_browse_no_outgoing' => 'Iste pagina non ha proprietates.',
	'smw_browse_no_incoming' => 'Nulle proprietate ha un ligamine a iste pagina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiquetta de proprietate inverse',
	'pageproperty' => 'Recerca de proprietates de paginas',
	'smw_pp_docu' => 'Cercar tote le filtros de un proprietate in un pagina date.
Entra e un pagina e un proprietate.',
	'smw_pp_from' => 'Ab pagina',
	'smw_pp_type' => 'Proprietate',
	'smw_pp_submit' => 'Cercar resultatos',
	'smw_result_prev' => 'Precedente',
	'smw_result_next' => 'Sequente',
	'smw_result_results' => 'Resultatos',
	'smw_result_noresults' => 'Nulle resultato.',
	'smwadmin' => 'Functiones admin pro MediaWiki Semantic',
	'smw_smwadmin_setupsuccess' => 'Le motor de immagazinage ha essite installate con successo.',
	'smw_smwadmin_return' => 'Retornar a $1',
	'smw_smwadmin_updatestarted' => 'Un nove processo de actualisation pro le refrescamento del datos semantic ha essite comenciate.
Tote le datos immagazinate essera reconstruite o reparate ubi necessari.
Tu pote sequer le progresso del actualisation in iste pagina special.

Retornar a $1.',
	'smw_smwadmin_updatenotstarted' => 'Il ha ja un processo de actualisation in curso de execution.
Non es create un altere.

Retornar a $1.',
	'smw_smwadmin_updatestopped' => 'Tote le processos de actualisation existente ha essite stoppate.

Retornar a $1.',
	'smw_smwadmin_updatenotstopped' => 'Pro stoppar le processo de actualisation in curso, tu debe marcar le quadrato pro indicar que tu es absolutemente secur de voler facer isto.

Retornar a $1.',
	'smw_smwadmin_docu' => 'Iste pagina special te adjuta durante le installation e actualisation de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Non oblida facer un copia de reserva del datos de valor ante de executar un function administrative.',
	'smw_smwadmin_db' => 'Installation e actualisation del base de datos',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki require alcun extensiones al base de datos de MediaWiki a fin de poter immagazinar le datos semantic.
Le function infra assecura que tu base de datos es configurate correctemente.
Le cambiamentos facite durante iste passo non afficera le resto del base de datos de MediaWiki, e pote esser facilemente disfacite si desirate.
Iste function de installation pote esser executate plure vices sin causar alcun damno, sed es necessari solmente un vice post cata installation o actualisation.',
	'smw_smwadmin_permissionswarn' => 'Si le operation falle con errores de SQL, le usator del base de datos que tu wiki usa (verifica tu LocalSettings.php) probabilemente non ha permissiones sufficiente.
O da a iste usator le permissiones additional de crear e deler tabulas, o entra temporarimente le nomine e contrasigno del usator "root" de tu base de datos in LocalSettings.php, o usa le script de mantenentia SMW_setup.php le qual pote usar le datos de identification de un administrator.',
	'smw_smwadmin_dbbutton' => 'Initialisar u actualisar tabulas',
	'smw_smwadmin_announce' => 'Annunciar tu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki dispone de un servicio web pro annunciar nove sitos de wiki semantic.
Iste es usate pro mantener un lista de sitos public que usa Semantic MediaWiki, principalmente pro adjutar le <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projecto Semantic MediaWiki</a> a obtener un impression general del usos typic de Semantic MediaWiki.
Vide le pagina principal de Semantic MediaWiki pro <a href="http://semantic-mediawiki.org/wiki/Registry">ulterior informationes a proposito de iste servicio</a>.',
	'smw_smwadmin_announcebutton' => 'Preme le sequente button pro submitter le adresse URL de tu wiki a iste servicio.
Le servicio non registrara wikis que non es aperte al publico, e illo retenera solmente le informationes publicamente accessibile.',
	'smw_smwadmin_datarefresh' => 'Reparation e actualisation de datos',
	'smw_smwadmin_datarefreshdocu' => 'Es possibile restaurar tote le datos de Semantic MediaWiki a base del conento actual del wiki.
Isto pote esser utile pro reparar datos corrumpite o pro refrescar le datos si le formato interne ha cambiate a causa de alcun actualisation de software.
Le actualisation es executate pagina a pagina e non essera completate immediatemente.
Lo sequente monstra si un actualisation es in progresso e permitte comenciar o stoppar le actualisationes (a minus que iste function ha essite disactivate per le administrator del sito).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Un actualisation es ja in curso.</strong>
Es normal que le actualisation progrede lentemente post que illo refresca datos solmente in micre pecias cata vice que un usator accede al wiki.
Pro completar iste actualisation plus rapidemente, tu pote invocar le script de mantenentia de MediaWiki <tt>runJobs.php</tt> (usa le option <tt>--maxjobs 1000</tt> pro restringer le numero de actualisationes facite in un lot).
Progresso estimate del actualisation currente:',
	'smw_smwadmin_datarefreshbutton' => 'Comenciar le actualisation del datos',
	'smw_smwadmin_datarefreshstop' => 'Stoppar iste actualisation',
	'smw_smwadmin_datarefreshstopconfirm' => 'Si, io es secur.',
	'smw_smwadmin_support' => 'Obtener supporto',
	'smw_smwadmin_supportdocu' => 'Plure ressources poterea adjutar te in caso de problemas:',
	'smw_smwadmin_installfile' => 'Si tu incontra problemas con tu installation, comencia per verificar le directivas in le <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">file INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Le documentation de usator complete de Semantic MediaWiki se trova a <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Le defectos pote esser reportate in <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Si tu ha ulterior questiones o suggestiones, participa in le discussion al <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">foro del usatores de Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Structura de datos',
	'smw_adminlinks_displayingdata' => 'Monstrar datos',
	'smw_adminlinks_inlinequerieshelp' => 'Adjuta super consultas incorporate',
	'smw-createproperty-isproperty' => 'Isto es un proprietate del typo $1.',
	'smw-createproperty-allowedvals' => 'Le {{PLURAL:$1|valor|valores}} permittite pro iste proprietate es:',
	'smw-paramdesc-category-delim' => 'Le delimitator',
	'smw-paramdesc-category-template' => 'Un patrono con le qual formatar le elementos',
	'smw-paramdesc-category-userparam' => 'Un parametro a passar al patrono',
	'smw-info-par-message' => 'Le message a monstrar.',
	'smw-info-par-icon' => 'Le icone a monstrar, o "info" o "attention!".',
	'smw_unknowntype' => 'Typo non supportate "$1" definite pro proprietate.', # Fuzzy
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Farras
 * @author Irwangatot
 * @author IvanLanin
 * @author Rex
 */
$messages['id'] = array(
	'smw-desc' => "Membuat wiki Anda lebih mudah diakses - oleh mesin ''dan'' manusia ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentasi daring])",
	'smw_viewasrdf' => 'Umpan RDF',
	'smw_finallistconjunct' => ', dan',
	'smw_factbox_head' => 'Fakta tentang $1',
	'smw_isspecprop' => 'Sifat ini adalah sifat khusus di wiki ini.',
	'smw_concept_description' => 'Deskripsi konsep "$1"',
	'smw_no_concept_namespace' => 'Konsep hanya dapat didefinisikan pada halaman dalam ruang nama Konsep:.',
	'smw_multiple_concepts' => 'Setiap halaman konsep hanya dapat memiliki satu konsep definisi.',
	'smw_concept_cache_miss' => 'Konsep "$1" tidak dapat digunakan saat ini karena konfigurasi wiki membutuhkannya untuk dihitung secara luring.
Jika masalah ini tidak hilang setelah beberapa waktu, mintalah pengelola situs untuk membuat konsep ini tersedia.',
	'smw_noinvannot' => 'Nilai tidak dapat diberikan pada properti inversi.',
	'version-semantic' => 'Ekstensi semantik',
	'smw_baduri' => 'URI berbentuk "$1" tidak diperbolehkan.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Hasil perhitungan',
	'smw_printername_csv' => 'Expor CSV',
	'smw_printername_dsv' => 'Ekspor DSV',
	'smw_printername_debug' => 'Debug query (untuk ahli)',
	'smw_printername_embedded' => 'Sertakan isi halaman',
	'smw_printername_json' => 'Ekspor JSON',
	'smw_printername_list' => 'Daftar',
	'smw_printername_ol' => 'Enumerasi',
	'smw_printername_ul' => 'Itemisasi',
	'smw_printername_rss' => 'Ekspor RSS',
	'smw_printername_table' => 'Tabel',
	'smw_printername_broadtable' => 'Tabel lebar',
	'smw_printername_template' => 'Templat',
	'smw_printername_rdf' => 'Ekspor RDF',
	'smw-paramdesc-limit' => 'Jumlah maksimum hasil yang diberikan',
	'smw-paramdesc-headers' => 'Tampilkan nama kepala/properti',
	'smw-paramdesc-mainlabel' => 'Label untuk nama halaman utama',
	'smw-paramdesc-link' => 'Tampilkan nilai sebagai pranala',
	'smw-paramdesc-intro' => 'Tulisan yang ditampilkan sebelum hasil kueri, jika ada',
	'smw-paramdesc-outro' => 'Tulisan untuk ditampilkan setelah hasil kueri, jika ada',
	'smw-paramdesc-default' => 'Tulisan untuk ditampilkan jika tidak ada hasil kueri',
	'smw-paramdesc-sep' => 'Pemisah untuk nilai',
	'smw-paramdesc-template' => 'Nama templat yang digunakan untuk menampilkan cetakan',
	'smw-paramdesc-columns' => 'Jumlah kolom untuk menampilkan hasil (bawaannya adalah $1)',
	'smw-paramdesc-userparam' => 'Sebuah nilai dimasukkan ke setiap pencarian templat, bila sebuah templat digunakan',
	'smw-paramdesc-introtemplate' => 'Nama templat yang ditampilkan sebelum hasil pencarian, bila ada',
	'smw-paramdesc-outrotemplate' => 'Nama templat yang ditampilkan setelah hasil pencarian, bila ada',
	'smw-paramdesc-embedformat' => 'Tag HTML yang digunakan untuk menentukan judul',
	'smw-paramdesc-embedonly' => 'Jangan tampilkan judul',
	'smw-paramdesc-rsstitle' => 'Tulisan yang digunakan sebagai judul umpan',
	'smw-paramdesc-rssdescription' => 'Tulisan yang digunakan sebagai deskripsi umpan',
	'smw-paramdesc-rdfsyntax' => 'Sintaks RDF untuk digunakan',
	'smw-paramdesc-csv-sep' => 'Pemisah yang dipakai',
	'smw-paramdesc-dsv-separator' => 'Pemisah yang dipakai',
	'smw-paramdesc-dsv-filename' => 'Nama berkas DSV',
	'smw-paramdesc-searchlabel' => 'Tulisan pada pranala menuju hasil', # Fuzzy
	'smw_iq_disabled' => 'Query semantik telah dinonaktifkan di wiki ini.',
	'smw_iq_moreresults' => '… hasil lebih lanjut',
	'smw_parseerror' => 'Nilai yang diberikan tidak dipahami.',
	'smw_notitle' => '"$1" tidak dapat digunakan sebagai nama halaman di wiki ini.',
	'smw_noproperty' => '"$1" tidak dapat digunakan sebagai nama properti di wiki ini.',
	'smw_wrong_namespace' => 'Hanya halaman pada ruang nama "$1" yang diizinkan di sini.',
	'smw_manytypes' => 'Lebih dari satu tipe yang ditetapkan untuk properti.',
	'smw_emptystring' => 'Untaian kosong tidak diterima.',
	'smw_maxstring' => 'Representasi untaian $1 terlalu panjang.',
	'smw_notinenum' => '"$1" tidak ada dalam daftar kemungkinan nilai ($2) untuk properti ini.',
	'smw_noboolean' => '"$1" tidak dikenali sebagai suatu nilai Boolean (true/false)',
	'smw_true_words' => 'benar,t,ya,y',
	'smw_false_words' => 'salah,f,tidak,n',
	'smw_nofloat' => '"$1" bukan angka.',
	'smw_infinite' => 'Angka sebesar "$1" tidak didukung.',
	'smw_unitnotallowed' => '"$1" bukanlah satuan ukuran yang sah untuk properti ini.',
	'smw_nounitsdeclared' => 'Tidak ada satuan pengukuran yang dinyatakan untuk properti ini.',
	'smw_novalues' => 'Tidak ada nilai yang disebutkan.',
	'smw_nodatetime' => 'Tanggal "$1" tidak dipahami.',
	'smw_toomanyclosing' => 'Tampaknya ada terlalu banyak penyebutan "$1" pada query.',
	'smw_noclosingbrackets' => 'Penggunaan beberapa "<nowiki>[[</nowiki>" pada query Anda tidak ditutup dengan pasangan "]]".',
	'smw_misplacedsymbol' => 'Simbol "$1" digunakan pada tempat yang mubazir.',
	'smw_unexpectedpart' => 'Bagian "$1" dari query tidak dipahami.
Hasilnya mungkin tidak seperti yang diharapkan.',
	'smw_emptysubquery' => 'Beberapa subquery tidak memiliki kondisi yang valid.',
	'smw_misplacedsubquery' => 'Beberapa subquery digunakan pada tempat yang tidak mengizinkan subquery.',
	'smw_valuesubquery' => 'Subquery tidak didukung untuk nilai dari properti "$1".',
	'smw_badqueryatom' => 'Beberapa bagian "<nowiki>[[…]]</nowiki>" pada query tidak dipahami.',
	'smw_propvalueproblem' => 'Nilai properti "$1" tidak dipahami.',
	'smw_noqueryfeature' => 'Beberapa fitur query belum didukung di wiki ini dan sebagian query diabaikan ($1).',
	'smw_noconjunctions' => 'Konjungsi dalam query tidak didukung dalam wiki ini dan sebagian dari query diabaikan ($1).',
	'smw_nodisjunctions' => 'Disjungsi dalam query tidak didukung dalam wiki ini dan sebagian dari query diabaikan ($1).',
	'smw_querytoolarge' => 'Kondisi query berikut tidak dapat diproses karena pembatas wiki terhadap ukuran atau kedalaman query: $1.',
	'smw_notemplategiven' => 'Berikan suatu nilai bagi parameter "template" agar format query ini dapat bekerja.',
	'smw_db_sparqlqueryproblem' => 'Hasil kueri tidak dapat diambil dari basis data SPARQL. Galat ini mungkin sementara atau menandakan adanya bug dalam perangkat lunak basis data.',
	'smw_type_header' => 'Properti bertipe "$1"',
	'smw_typearticlecount' => 'Menampilkan $1 {{PLURAL:$1|properti|properti}} yang menggunakan tipe ini.',
	'smw_attribute_header' => 'Halaman yang menggunakan properti "$1"',
	'smw_attributearticlecount' => 'Menampilkan $1 {{PLURAL:$1|halaman|halaman}} yang menggunakan properti ini.',
	'smw_subproperty_header' => 'Subproperti',
	'smw_subpropertyarticlecount' => 'Properti ini memiliki $1 {{PLURAL:$1|subproperti|subproperti}} berikut:',
	'smw_concept_header' => 'Halaman berkonsep "$1"',
	'smw_conceptarticlecount' => 'Menampilkan $1 {{PLURAL:$1|halaman|halaman}} yang termasuk konsep ini.',
	'exportrdf' => 'Ekspor halaman ke RDF',
	'smw_exportrdf_docu' => 'Halaman ini mengizinkan Anda untuk mendapatkan data dari suatu halaman dalam format RDF.
Untuk mengekspor halaman, masukkan judul di kotak teks di bawah, satu judul per baris.',
	'smw_exportrdf_recursive' => 'Ekspor semua halaman yang terkait secara rekursif.
Perhatikan bahwa hasilnya bisa besar!',
	'smw_exportrdf_backlinks' => 'Ekspor juga semua halaman yang merujuk ke halaman yang diekspor.
Menghasilkan RDF yang dapat ditelurusi.',
	'smw_exportrdf_lastdate' => 'Jangan mengekspor halaman yang tidak berubah sejak waktu yang diberikan.',
	'smw_exportrdf_submit' => 'Ekspor',
	'uriresolver' => 'Pengurai URI',
	'properties' => 'Properti',
	'smw_properties_docu' => 'Properti berikut digunakan dalam wiki ini.',
	'smw_property_template' => '$1 bertipe $2 ($3)',
	'smw_propertylackspage' => 'Semua properti harus dideskripsikan dengan suatu halaman!',
	'smw_propertylackstype' => 'Tidak ada tipe yang dispesifikasikan untuk properti ini (untu saat ini diasumsikan bertipe $1)',
	'smw_propertyhardlyused' => 'Properti ini hampir tak digunakan di wiki ini!',
	'unusedproperties' => 'Properti yang tak digunakan',
	'smw_unusedproperties_docu' => 'Properti berikut ada walaupun tidak ada halaman lain yang memanfaatkan mereka.',
	'smw_unusedproperty_template' => '$1 bertipe $2',
	'wantedproperties' => 'Properti yang diinginkan',
	'smw_wantedproperties_docu' => 'Properti berikut digunakan pada wiki ini tetapi belum memiliki sebuah halaman untuk mendeskripsikannya.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|penggunaan|penggunaan}})',
	'smw_purge' => 'Segarkan',
	'types' => 'Tipe',
	'smw_types_docu' => 'Berikut adalah daftar semua tipe data yang dapat diberikan pada properti.
Setiap tipe data memiliki suatu halaman yang memberikan informasi tambahan.', # Fuzzy
	'semanticstatistics' => 'Statistik semantik',
	'smw_semstats_text' => "Wiki ini memiliki '''$1''' {{PLURAL:$1|nilai|nilai}} properti dari total '''$2''' [[Special:Properties|{{PLURAL:$2|properti|properti}}]].
'''$3''' {{PLURAL:$3|properti|properti}} telah memiliki halaman sendiri, dan tipe data telah diberikan pada '''$4''' di antaranya.
Beberapa properti yang ada mungkin merupakan [[Special:UnusedProperties|properti yang tak digunakan]].
Properti yang masih tidak memiliki halaman ditemukan pada [[Special:WantedProperties|daftar properti yang diinginkan]].",
	'smw_uri_doc' => 'Pengurai URI menerapkan <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C pencarian TAG pada httpRange-14</a>.
Ini memastikan bahwa manusia tidak berubah menjadi situs web.',
	'ask' => 'Pencarian semantik',
	'smw_ask_sortby' => 'Urut berdasar kolom (pilihan)',
	'smw_ask_ascorder' => 'Menanjak',
	'smw_ask_descorder' => 'Menurun',
	'smw_ask_submit' => 'Temukan hasil',
	'smw_ask_editquery' => '[Sunting query]',
	'smw_add_sortcondition' => '[Tambahkan kondisi pengurutan]',
	'smw_ask_hidequery' => 'Sembunyikan query',
	'smw_ask_help' => 'Bantuan query',
	'smw_ask_queryhead' => 'Query',
	'smw_ask_printhead' => 'Data tambahan untuk ditampilkan',
	'smw_ask_printdesc' => '(tambahkan satu nama properti per baris)',
	'smw_ask_format_as' => 'Format sebagai:',
	'smw_ask_defaultformat' => 'baku',
	'smw_ask_otheroptions' => 'Pilihan lain',
	'smw_ask_show_embed' => 'Tampilkan kode sertaan',
	'smw_ask_hide_embed' => 'Sembunyikan kode sertaan',
	'smw_ask_embed_instr' => 'Untuk menyertakan query ini secara tersisip dalam suatu halaman wiki gunakan kode di bawah.',
	'searchbyproperty' => 'Pencarian menurut properti',
	'smw_sbv_docu' => 'Cari semua halaman yang memiliki properti dan nilai yang diberikan.',
	'smw_sbv_novalue' => 'Masukkan nilai yang valid untuk properti, atau lihat semua nilai properti untuk "$1".',
	'smw_sbv_displayresult' => 'Daftar semua halaman yang memiliki properti "$1" dengan nilai "$2"',
	'smw_sbv_displayresultfuzzy' => 'Daftar semua halaman yang memiliki properti "$1" dengan nilai "$2".
Karena hanya ada sedikit hasil, nilai yang mendekati juga ditampilkan.',
	'smw_sbv_property' => 'Properti:',
	'smw_sbv_value' => 'Nilai:',
	'smw_sbv_submit' => 'Temukan hasil',
	'browse' => 'Jelajahi wiki',
	'smw_browselink' => 'Jelajahi properti',
	'smw_browse_article' => 'Masukkan nama halaman untuk memulai penelusuran',
	'smw_browse_go' => 'Tuju ke',
	'smw_browse_show_incoming' => 'tampilkan properti yang bertaut ke sini',
	'smw_browse_hide_incoming' => 'sembunyikan properti yang bertaut ke sini',
	'smw_browse_no_outgoing' => 'Halaman ini tidak memiliki properti.',
	'smw_browse_no_incoming' => 'Tidak ada properti yang bertaut ke halaman ini.',
	'smw_inverse_label_default' => '$1 dari',
	'smw_inverse_label_property' => 'Label properti inversi',
	'pageproperty' => 'Pencarian properti halaman',
	'smw_pp_docu' => 'Pencarian semua nilai suatu properti pada suatu halaman.
Masukkan satu halaman dan satu properti.',
	'smw_pp_from' => 'Dari halaman',
	'smw_pp_type' => 'Properti',
	'smw_pp_submit' => 'Temukan hasil',
	'smw_result_prev' => 'Sebelumnya',
	'smw_result_next' => 'Selanjutnya',
	'smw_result_results' => 'Hasil',
	'smw_result_noresults' => 'Tidak ada hasilnya.',
	'smwadmin' => 'Fungsi admin untuk Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Mesin penyimpanan berhasil disiapkan.',
	'smw_smwadmin_return' => 'Kembali ke $1',
	'smw_smwadmin_updatestarted' => 'Suatu proses pembaruan untuk menyegarkan data semantik telah dimulai.
Semua data tersimpan akan dibangun ulang atau diperbaiki jika diperlukan.
Anda dapat mengikuti kemajuan pembaruan tersebut di halaman istimewa ini.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Sudah ada suatu proses pembaruan yang sedang berjalan.
Tidak membuat proses lain.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Semua proses pembaruan yang ada telah dihentikan.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Untuk menghentikan proses pembaruan yang sedang berjalan, Anda harus memilih kotak centang untuk menunjukkan bahwa Anda benar-benar yakin.', # Fuzzy
	'smw_smwadmin_docu' => 'Halaman istimewa ini akan membantu Anda selama instalasi dan peningkatan dari <a href="http://semantic-mediawiki.org">Semantic MediaWiki.</a>
Jangan lupa untuk mencadangkan data Anda yang berharga sebelum melaksanakan fungsi administratif.',
	'smw_smwadmin_db' => 'Instalasi dan peningkatan basis data',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki mensyaratkan beberapa pengembangan basis data MediaWiki untuk menyimpan data semantik.
Fungsi berikut memastikan bahwa basis data Anda dipersiapkan dengan baik.
Perubahan yang dilakukan pada langkah ini tidak memengaruhi bagian lain dari basis data MediaWiki, dan dengan mudah dapat dibatalkan jika diingkan.
Fungsi persiapan ini dapat dilakukan berulang kali tanpa menyebabkan kerusaan, tapi hanya dibutuhkan sekali sewaktu instalasi atau peningkatan.',
	'smw_smwadmin_permissionswarn' => 'Jika operasi gagal karena kesalahan SQL, pengguna basis data yang digunakan oleh wiki Anda (cek LocalSettings.php Anda) mungkin tidak mempunyai hak akses yang cukup.
Anda dapat memberikan hak akses tambahan untuk membuat dan menghapus tabel, memasukkan sementara pengguna root basis data Anda di LocalSettings.php, atau menggunakan skrip pemeliharaan <tt>SMW_setup.php</tt> yang dapat menggunakan hak akses dari AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Inisiasi atau tingkatkan tabel',
	'smw_smwadmin_announce' => 'Umumkan wiki Anda',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki memiliki layanan web untuk mengumumkan situs wiki semantik baru.
Ini digunakan untuk memelihara suatu daftar situs publik yang menggunakan Semantic MediaWiki, terutama untuk membantu <a href="http://semantic-mediawiki.org/wiki/SMW_Project">proyek Semantic MediaWiki</a> untuk mendapat gambaran penggunaan umum dari Semantic MediaWiki.
Kunjungin beranda Semantic MediaWiki untuk <a href="http://semantic-mediawiki.org/wiki/Registry">informasi lebih lanjut tentang layanan ini</a>.',
	'smw_smwadmin_announcebutton' => 'Tekan tombol berikut untuk mengirim URL wiki Anda ke layanan itu.
Layanan ini tidak akan mendaftarkan wiki yang tidak bisa diakses publik, dan hanya akan menyimpan informasi yang bisa diakses publik.',
	'smw_smwadmin_datarefresh' => 'Perbaikan dan peningkatan data',
	'smw_smwadmin_datarefreshdocu' => 'Dimungkinkan untuk memulihkan semua data Semantic MediaWiki berdasarkan isi yang ada sekarang di wiki ini.
Hal ini berguna untuk memperbaiki data yang rusak atau menyegarkan data jika format internal telah berubah karena suatu peningkatan perangkat lunak.
Pembaruan dilaksanakan halaman per halaman dan tidak akan langsung selesai.
Tampilan berikut menunjukkan jika suatu pembaruan sedang berlangsung dan memungkinkan Anda untuk memulai atau menghentikan proses (kecuali jika fitur ini dimatikan oleh pengelola situs).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Suatu pembaruan sedang dalam proses.</strong>
Adalah wajar jika kemajuan pembaruan berjalan lambat karena ia hanya menyegarkan data sedikit demi sedikit setiap kali seorang pengguna mengakses wiki ini.
Untuk menyelesaikan pembaruan ini dengan lebih cepat, Anda dapat menjalankan skrip pemeliharaan MediaWiki <tt>runJobs.php</tt> (gunakan opsi <tt>--maxjobs 1000</tt> untuk membatasi jumlah pembaruan yang dilakukan dalam satu saat).
Perkiraan kemajuan pembaruan saat ini:',
	'smw_smwadmin_datarefreshbutton' => 'Mulai pembaruan data',
	'smw_smwadmin_datarefreshstop' => 'Hentikan pembaruan ini',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ya, saya yakin.',
	'smw_smwadmin_support' => 'Cari dukungan',
	'smw_smwadmin_supportdocu' => 'Berbagai sumber dapat membantu Anda jika ada masalah:',
	'smw_smwadmin_installfile' => 'Jika Anda menghadapi masalah dengan instalasi Anda, mulailah dengan mengecek pedoman di <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">berkas INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Dokumentasi pengguna lengkap untuk Semantic MediaWiki tersedia di <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Bug dapat dilaporkan ke <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Jika Anda memiliki pertanyaan atau saran lain, bergabunglah dengan diskusi di <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forum pengguna Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struktur data',
	'smw_adminlinks_displayingdata' => 'Menampilkan data',
	'smw_adminlinks_inlinequerieshelp' => 'Bantuan query sisip',
	'smw-createproperty-isproperty' => 'Ini adalah properti bertipe $1',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Nilai|Nilai}} yang diizinkan untuk properti ini adalah:',
	'smw_unknowntype' => 'Tipe "$1" yang tidak didukung ditetapkan untuk properti.', # Fuzzy
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'smw_viewasrdf' => 'ntá RDF',
	'smw_finallistconjunct' => ', na',
	'smw_factbox_head' => 'Ómárí maka $1',
	'smw_printername_count' => 'güó ihe futárá',
	'smw_printername_list' => 'Ndetu',
	'smw_printername_table' => 'Agada',
	'smw_printername_template' => 'Àtụ',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'smw_printername_template' => 'Shablono',
	'smw_result_next' => 'Sequanta',
);

/** Italian (italiano)
 * @author Beta16
 * @author Civvì
 * @author Cruccone
 * @author Darth Kule
 * @author Davide Eynard, David Laniado
 * @author F. Cosoleto
 * @author Gianfranco
 * @author Gmelfi
 * @author Melos
 * @author Pietrodn
 * @author Ximo17
 */
$messages['it'] = array(
	'smw-desc' => "Rende la tua wiki più accessibile - per le macchine ''e'' per gli umani ([http://semantic-mediawiki.org/wiki/Help:User_manual documentazione in linea])",
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => ' e',
	'smw_factbox_head' => 'Fatti riguardanti $1',
	'smw_isspecprop' => "Questa proprietà è una proprietà speciale all'interno di questo wiki.",
	'smw_concept_description' => 'Descrizione del concetto "$1"',
	'smw_no_concept_namespace' => 'I concetti possono essere definiti solo sulle pagine nel namespace Concept:.',
	'smw_multiple_concepts' => 'Ogni pagina concetto può avere una sola definizione di concetto.',
	'smw_concept_cache_miss' => 'Il concetto "$1" non può essere usato ora, siccome la configurazione della wiki richiede che sia elaborato off-line. Se il problema non si risolve dopo un po\' di tempo, chiedi all\'amministratore del tuo sito di rendere disponibile questo concetto.',
	'smw_noinvannot' => 'Il valore non può essere assegnato alla proprietà inversa.',
	'smw_baduri' => 'Spiacenti. Gli URI del tipo “$1” non sono consentiti.',
	'smw_csv_link' => 'CSV',
	'smw_printername_count' => 'Conta risultati',
	'smw_printername_csv' => 'Esportazione CSV',
	'smw_printername_debug' => 'Debug della query (per utenti esperti)',
	'smw_printername_embedded' => 'Includi i contenuti della pagina',
	'smw_printername_json' => 'Esportazione JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumerazione',
	'smw_printername_ul' => 'Creazione lista di elementi',
	'smw_printername_rss' => 'Esportazione RSS',
	'smw_printername_table' => 'Tabella',
	'smw_printername_broadtable' => 'Tabella estesa',
	'smw_printername_template' => 'Template',
	'smw_printername_category' => 'Categoria',
	'smw-paramdesc-limit' => 'Il numero massimo di risultati da restituire',
	'smw-paramdesc-headers' => 'Mostra i nomi di header/proprietà',
	'smw-paramdesc-mainlabel' => "L'etichetta da dare al nome della pagina principale",
	'smw-paramdesc-link' => 'Mostra i valori come link',
	'smw-paramdesc-intro' => 'Testo da mostrare prima dei risultati della query, se ce ne sono',
	'smw-paramdesc-outro' => 'Testo da mostrare dopo i risultati della query, se ce ne sono',
	'smw-paramdesc-default' => 'Testo da mostrare se la query non dà risultati',
	'smw-paramdesc-sep' => 'Il separatore per i valori',
	'smw-paramdesc-template' => 'Il nome di un template con cui mostrare quanto restituito',
	'smw-paramdesc-columns' => 'Il numero di colonne in cui ordinare la visualizzazione dei risultati (valore predefinito: $1)',
	'smw-paramdesc-embedformat' => 'Il tag HTML usato per definire le intestazioni',
	'smw-paramdesc-embedonly' => 'Non mostrare intestazioni',
	'smw-paramdesc-rsstitle' => 'Testo da usare come titolo del feed',
	'smw-paramdesc-rssdescription' => 'Testo da usare come descrizione del feed',
	'smw-paramdesc-rdfsyntax' => 'La sintassi RDF da utilizzare',
	'smw-paramdesc-csv-sep' => 'Il separatore da usare',
	'smw-paramdesc-dsv-separator' => 'Il separatore da usare',
	'smw-paramdesc-dsv-filename' => 'Il nome per il file DSV',
	'smw-paramdesc-searchlabel' => 'Testo per continuare la ricerca ai risultati successivi',
	'smw-paramdesc-export' => 'Opzioni di esportazione',
	'smw_iq_disabled' => 'Spiacenti. Le query semantiche sono state disabilitate per questo wiki.',
	'smw_iq_moreresults' => '&hellip; risultati successivi',
	'smw_parseerror' => 'Il valore dato non è stato compreso.',
	'smw_notitle' => "“$1” non pu&ograve; essere utilizzato come nome di una pagina all'interno di questo wiki.",
	'smw_wrong_namespace' => 'Qui sono consentite solo pagine del namespace "$1".',
	'smw_manytypes' => 'È stato definito più di un tipo per la proprietà.',
	'smw_emptystring' => 'Le stringhe vuote non sono accettate.',
	'smw_maxstring' => 'La stringa $1 è troppo lunga.',
	'smw_notinenum' => '"$1" non è nella lista dei valori possibili ($2) per questa proprietà.',
	'smw_noboolean' => '“$1” non &egrave; riconosciuto come valore Booleano (vero/falso).',
	'smw_true_words' => 'vero,v,si,s,true,t,yes,y',
	'smw_false_words' => 'falso,f,no,n,false',
	'smw_nofloat' => '“$1” non &egrave; un numero.',
	'smw_infinite' => 'I numeri grandi come "$1" non sono supportati.',
	'smw_novalues' => 'Nessun valore specificato',
	'smw_nodatetime' => 'Non &egrave; stato possibile comprendere la data “$1”.',
	'smw_toomanyclosing' => "Sembrano esserci troppe ripetizioni di “$1” all'interno della query.",
	'smw_noclosingbrackets' => 'Alcune "<nowiki>[[</nowiki>" all\'interno della query non sono state chiuse con le corrispondenti "]]".',
	'smw_misplacedsymbol' => 'Il simbolo “$1” &grave; stato usato in un punto in cui &egrave; inutile.',
	'smw_unexpectedpart' => 'Non &egrave; stato possibile comprendere la parte “$1” della query. Il risultato potrebbe essere diverso da quello atteso.',
	'smw_emptysubquery' => 'Qualche subquery ha una condizione non valida.',
	'smw_misplacedsubquery' => 'Qualche subquery &egrave; stata utilizzata in una posizione in cui non era consentito.',
	'smw_valuesubquery' => 'Le subquery non sono supportate per i valori della proprietà "$1".',
	'smw_badqueryatom' => 'Non è stato possibile comprendere parte "<nowiki>[[…]]</nowiki>" della query.',
	'smw_propvalueproblem' => 'Non è stato possibile comprendere il valore della proprietà "$1".',
	'smw_noqueryfeature' => 'Qualche funzionalità di query non è stata supportata in questa wiki e parte della query è stata rimossa ($1).',
	'smw_noconjunctions' => 'Le congiunzioni nelle query non sono supportate in questa wiki e parte della query è stata rimossa ($1).',
	'smw_nodisjunctions' => "La disgiunzione all'interno delle query non &egrave; supportata in questo wiki, quindi parte della query &egrave; stata ignorata ($1).",
	'smw_querytoolarge' => "Le seguenti condizioni all'interno della query non sono state considerate a causa delle restrizioni di dimensione o profondit&agrave; delle query impostate per questo wiki: $1.",
	'smw_notemplategiven' => 'Per favore fornisci un valore per il parametro "template" per far funzionare questo formato di query.',
	'smw_type_header' => 'Proprietà del tipo "$1"',
	'smw_typearticlecount' => 'Visualizzazione di $1 {{PLURAL:$1|proprietà|proprietà}} che usano questo tipo.',
	'smw_attribute_header' => 'Pagine che usano la proprietà "$1"',
	'smw_attributearticlecount' => 'Visualizzazione di $1 {{PLURAL:$1|pagina che usa|pagine che usano}} questa proprietà.',
	'smw_subproperty_header' => 'Sottoproprietà',
	'smw_subpropertyarticlecount' => 'Questa proprietà ha {{PLURAL:$1|la seguente|le seguenti $1}} sottoproprietà.',
	'smw_concept_header' => 'Pagine del concetto "$1"',
	'smw_conceptarticlecount' => 'Mostro {{PLURAL:$1|una pagina|$1 pagine}} appartenenti a quel concetto.',
	'exportrdf' => 'Esporta le pagine in RDF',
	'smw_exportrdf_docu' => 'Questa pagina consente di ottenere dati da una pagina in formato RDF. Per esportare delle pagine, inseritene i titoli nella casella di testo sottostante, un titolo per riga.',
	'smw_exportrdf_recursive' => 'Esporta ricorsivamente tutte le pagine correlate. Nota: il risultato potrebbe essere molto grande!',
	'smw_exportrdf_backlinks' => 'Esporta anche le pagine che si riferiscono a quelle esportate. Genera un RDF navigabile.',
	'smw_exportrdf_lastdate' => 'Non esportare le pagine che non hanno sub&igrave;to modifiche dal momento specificato.',
	'smw_exportrdf_submit' => 'Esporta',
	'uriresolver' => 'Risolutore di URI',
	'properties' => 'Proprietà',
	'smw_properties_docu' => "Le seguenti proprietà sono utilizzate all'interno del wiki.",
	'smw_property_template' => '$1 di tipo $2 ($3)',
	'smw_propertylackspage' => 'Tutte le proprietà dovrebbero essere descritte da una pagina!',
	'smw_propertylackstype' => 'Non è stato specificato nessun tipo per questa proprietà (per il momento si suppone sia di tipo $1).',
	'smw_propertyhardlyused' => 'Questa proprietà non è quasi mai usata nel wiki!',
	'unusedproperties' => 'Propietà non utilizzate',
	'smw_unusedproperties_docu' => "Le seguenti proprietà esistono nonostante nessun'altra pagina ne faccia uso.",
	'smw_unusedproperty_template' => '$1 di tipo $2',
	'wantedproperties' => 'Proprietà senza descrizione',
	'smw_wantedproperties_docu' => 'Le seguenti proprietà sono usate nel wiki ma non hanno ancora una pagina che le descriva.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usi}})',
	'smw_purge' => 'Aggiorna',
	'types' => 'Tipi',
	'smw_types_docu' => 'La seguente è una lista di tutti i tipi di dati che possono essere assegnati alle proprietà.',
	'semanticstatistics' => 'Statistiche Semantiche',
	'smw_semstats_text' => "Questo sito contiene '''$1''' {{PLURAL:$1|valore|valori}} di proprietà per un totale di '''$2''' [[Special:Properties|{{PLURAL:$2|proprietà|differenti proprietà}}]].
'''$3''' proprietà {{PLURAL:$3|ha|hanno}} una propria pagina e il tipo di dato inteso è specificato per '''$4''' di queste.
Alcune delle proprietà esistenti possono essere [[Special:UnusedProperties|proprietà non utilizzate]].
Le proprietà che ancora non hanno una pagina si possono trovare nell'[[Special:WantedProperties|elenco delle proprietà senza descrizione]].",
	'smw_uri_doc' => 'Il risolutore di URI implementa il <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Fa in modo che gli esseri umani non diventino siti Web.',
	'ask' => 'Ricerca semantica',
	'smw_ask_sortby' => 'Ordina per colonna (opzionale)',
	'smw_ask_ascorder' => 'Crescente',
	'smw_ask_descorder' => 'Decrescente',
	'smw_ask_submit' => 'Trova risultati',
	'smw_ask_editquery' => '[Modifica query]',
	'smw_add_sortcondition' => '[Aggiungi condizione di ordinamento]',
	'smw_ask_hidequery' => 'Nascondi query',
	'smw_ask_help' => 'Help sulle query',
	'smw_ask_queryhead' => 'Interrogazione',
	'smw_ask_printhead' => 'Dati supplementari da mostrare',
	'smw_ask_printdesc' => '(aggiungi un nome di proprietà per riga)',
	'smw_ask_format_as' => 'Formatta come:',
	'smw_ask_defaultformat' => 'predefinito',
	'smw_ask_otheroptions' => 'Altre opzioni',
	'smw_ask_show_embed' => 'Mostra codice di inclusione',
	'smw_ask_hide_embed' => 'Nascondi codice di inclusione',
	'smw_ask_embed_instr' => 'Per includere questa query in linea in una pagina wiki, usa il codice qui sotto.',
	'smw-ask-delete' => '[Cancella]',
	'smw_qc_show_addnal_opts' => 'Mostra più opzioni',
	'smw_qc_hide_addnal_opts' => 'Mostra meno opzioni',
	'smw_qc_default' => 'Predefinito:',
	'smw_qui_property' => '<strong>Proprietà</strong>',
	'smw_qui_prop' => 'Proprietà:',
	'smw_qui_labl' => 'Etichetta:',
	'smw_qui_formt' => 'Formato:',
	'smw_qui_limt' => 'Limite:',
	'smw_qui_shownresults' => 'mostra nei risultati',
	'smw_qui_invalidformat' => 'Il formato scelto "$1" non esiste per questa wiki',
	'smw_qui_nosort' => 'Nessun ordinamento',
	'smw_qui_ascorder' => 'Crescente',
	'smw_qui_descorder' => 'Decrescente',
	'smw_qui_randorder' => 'Casuale',
	'smw_qui_addnprop' => 'aggiungi proprietà',
	'smw_qui_delete' => 'Rimuovi',
	'smw_qui_options' => 'opzioni',
	'smw_qui_addcategory' => 'aggiungi categoria',
	'smw_qui_ok' => 'Ok',
	'smw_qui_cancel' => 'Annulla',
	'smw_qui_category' => '<strong>Categoria</strong>',
	'smw_qui_label' => 'Etichetta',
	'smw_qui_dlabel' => 'Etichetta:',
	'smw_qui_dcategory' => 'Categoria:',
	'searchbyproperty' => 'Cerca per proprietà',
	'smw_sbv_docu' => 'Cerca tutte le pagine che hanno proprietà e valore specificati.',
	'smw_sbv_novalue' => 'Inserire un valore valido per la proprietà, o visualizzare tutti i valori di proprietà per "$1".',
	'smw_sbv_displayresult' => 'Lista di tutte le pagine che hanno proprietà "$1" con valore "$2"',
	'smw_sbv_displayresultfuzzy' => 'Una lista di tutte le pagine che hanno la proprietà "$1" col valore "$2".
Siccome ci sono solo pochi risultati, sono visualizzati anche i valori vicini.',
	'smw_sbv_property' => 'Proprietà:',
	'smw_sbv_value' => 'Valore:',
	'smw_sbv_submit' => 'Trova risultati',
	'browse' => 'Esplora il wiki',
	'smw_browselink' => 'Sfoglia le proprietà',
	'smw_browse_article' => "Inserire il nome della pagina da cui iniziare l'esplorazione",
	'smw_browse_go' => 'Vai',
	'smw_browse_show_incoming' => 'mostra le proprietà che linkano qui',
	'smw_browse_hide_incoming' => 'nascondi le proprietà che linkano qui',
	'smw_browse_no_outgoing' => 'Questa pagina non ha proprietà.',
	'smw_browse_no_incoming' => 'Nessuna proprietà linka a questa pagina.',
	'smw_inverse_label_default' => '$1 di',
	'smw_inverse_label_property' => 'Etichetta della proprietà inversa',
	'pageproperty' => 'Ricerca proprietà della pagina',
	'smw_pp_docu' => 'Cerca tutti i valori che soddisfano una proprietà su una data pagina. Inserire sia la pagina sia la proprietà.',
	'smw_pp_from' => 'Da pagina',
	'smw_pp_type' => 'Proprietà',
	'smw_pp_submit' => 'Trova risultati',
	'smw_result_prev' => 'Precedente',
	'smw_result_next' => 'Successivo',
	'smw_result_results' => 'Risultati',
	'smw_result_noresults' => 'Spiacenti, nessun risultato.',
	'smwadmin' => 'Funzioni amministrative per Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Il motore di storage è stato installato correttamente.',
	'smw_smwadmin_return' => 'Torna a $1',
	'smw_smwadmin_updatestarted' => "E' iniziato un nuovo processo di aggiornamento per ricaricare i dati semantici.
Tutti i dati registrati saranno ricostruiti o riparati se necessario.
Puoi seguire i progressi dell'aggiornamento in questa pagina speciale.

Torna a $1.",
	'smw_smwadmin_updatenotstarted' => 'Un processo di aggiornamento è già in corso.
Non ne verrà avviato un altro.

Torna a $1.',
	'smw_smwadmin_updatestopped' => 'Tutti i processi di aggiornamento in corso sono stati arrestati.

Torna a $1.',
	'smw_smwadmin_updatenotstopped' => 'Per arrestare il processo di aggiornamento in corso, devi cliccare nel riquadro per confermare che sei davvero sicuro di volerlo fare.

Torna a $1.',
	'smw_smwadmin_docu' => 'Questa pagina speciale serve ad aiutarti durante l\'installazione e l\'aggiornamento di <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Ricordati di fare un backup dei dati importanti prima di eseguire funzioni amministrative.',
	'smw_smwadmin_db' => 'Installazione database e aggiornamento',
	'smw_smwadmin_dbdocu' => "Semantic MediaWiki richiede alcune estensioni del database MediaWiki per poter registrare i dati semantici.
La funzione qui sotto verifica che il tuo database sia installato correttamente.
Le modifiche effettuate in questo passaggio non hanno effetto sul resto del database MediaWiki, e possono essere facilmente annullate se necessario.
Questa funzione di setup può essere rieseguita più volte senza conseguenze indesiderate, ma è richiesta solo una volta all'atto dell'installazione o dell'aggiornamento.",
	'smw_smwadmin_permissionswarn' => "Se l'operazione avrà esito negativo con errori SQL, l'utente del database usato dal tuo wiki (controlla nel LocalSettings.php) probabilmente non ha permessi sufficienti.
Puoi assegnare a questo utente permessi aggiuntivi per creare e cancellare tabelle, oppure inserire temporaneamente in LocalSettings.php i dati di accesso root al database, oppure usare lo script di manutenzione <tt>SMW_setup.php</tt> che può utilizzare le credenziali di un utente amministratore di sistema.",
	'smw_smwadmin_dbbutton' => 'Inizializza o aggiorna tabelle',
	'smw_smwadmin_announce' => 'Annuncia il tuo wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki dispone di un servizio web per dare notizia di nuovi siti wiki semantici.
Il servizio è usato per mantenere una lista di siti pubblici che usano Semantic MediaWiki principalmente per fornire al <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Progetto Semantic MediaWiki</a> una panoramica degli usi tipici del Semantic MediaWiki.
Visita la Home Page di Semantic MediaWiki per <a href="http://semantic-mediawiki.org/wiki/Registry">maggiori informazioni su questo servizio</a>.',
	'smw_smwadmin_announcebutton' => 'Premi il bottone seguente per inviare la URL del tuo wiki a quel servizio.
Il servizio non registrerà wiki che non siano pubblicamente accessibili, e conserverà esclusivamente informazioni pubblicamente accessibili.',
	'smw_smwadmin_datarefresh' => 'Riparazione ed aggiornamento dei dati',
	'smw_smwadmin_datarefreshdocu' => "Si possono ripristinare tutti i dati Semantic MediaWiki basati sui contenuti attuali del wiki.
Questo può essere utile per riparare dati corrotti o per aggiornare i dati se il loro formato interno si è modificato per qualche aggiornamento di software.
L'aggiornamento è eseguito pagina per pagina e non sarà completato immediatamente.
Qui di seguito si vede se un aggiornamento è in corso e potrai avviare od arrestare gli aggiornamenti (a meno che questa funzionalità non sia stata disattivata dall'amministratore del sito).",
	'smw_smwadmin_datarefreshprogress' => "<strong>Un aggiornamento è già in corso.</strong>
Non è anormale che l'aggiornamento proceda solo lentamente, poiché verifica i dati solo a piccoli pacchetti ogni volta che un utente accede al wiki.
Per terminare il processo pià rapidamente, puoi invocare lo script di manutenzione MediaWiki <tt>runJobs.php</tt> (usa l'opzione <tt>--maxjobs 1000</tt> per restringere il numero di verifiche svolte in ciascuna tornata).
Progresso stimato dell'aggiornamento in corso:",
	'smw_smwadmin_datarefreshbutton' => "Inizia l'aggiornamento dei dati",
	'smw_smwadmin_datarefreshstop' => 'Ferma questo aggiornamento',
	'smw_smwadmin_datarefreshstopconfirm' => 'Sì, sono sicuro.',
	'smw_smwadmin_support' => 'Ottenere supporto',
	'smw_smwadmin_supportdocu' => "Diverse risorse potrebbero esserti d'aiuto in caso di problemi:",
	'smw_smwadmin_installfile' => 'Se hai problemi con la tua installazione, inizia a verificare le linee guida nel <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">file INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentazione completa per l\'utente di Semantic MediaWiki si trova in <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'I Bug possono essere riportati a <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Se hai altre domande o suggerimenti, unisciti alle discussioni sul <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forum degli utenti di Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struttura dei dati',
	'smw_adminlinks_displayingdata' => 'Visualizzazione dati',
	'smw_adminlinks_inlinequerieshelp' => 'Aiuto sulle query inline',
	'smw-createproperty-isproperty' => 'Questa è una proprietà di tipo $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Il valore permesso per questa proprità è|I valori permessi per questa proprietà sono}}:',
	'smw-ui-tooltip-title-property' => 'Proprietà',
	'smw-ui-tooltip-title-quantity' => 'Quantità',
	'smw-ui-tooltip-title-info' => 'Informazione',
	'smw-ui-tooltip-title-service' => 'Collegamento di servizio',
	'smw-ui-tooltip-title-warning' => 'Errore',
	'smw-ui-tooltip-title-parameter' => 'Parametro',
	'smw-ui-tooltip-title-event' => 'Evento',
	'smw_unknowntype' => 'Il tipo di questa proprietà non è valido',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Hosiryuhosi
 * @author Likibp
 * @author Naohiro19
 * @author Schu
 * @author Shirayuki
 * @author Whym
 * @author 青子守歌
 */
$messages['ja'] = array(
	'smw-desc' => 'ウィキを機械や人間にとってよりアクセスしやすいものにする（[http://semantic-mediawiki.org/wiki/Help:User_manual オンラインドキュメント]）',
	'smw_viewasrdf' => 'RDF フィード',
	'smw_finallistconjunct' => ',',
	'smw_factbox_head' => '「$1」に関する事実',
	'smw_isspecprop' => 'このプロパティはこのウィキ内の特別なプロパティです。',
	'smw_concept_description' => '概念「$1」の説明',
	'smw_no_concept_namespace' => '概念を定義できるのは、Concept: 名前空間内のみです。',
	'smw_multiple_concepts' => '各概念ページが持てる概念定義は 1 つのみです。',
	'smw_concept_cache_miss' => '概念「$1」は、ウィキの設定によりオフラインでの処理が必要なため、現時点では利用できません。
しばらく経っても問題が消えない場合は、この概念を利用可能にするようにサイト管理者にお問い合わせください。',
	'smw_noinvannot' => '逆プロパティには値を割り当てられません。',
	'version-semantic' => 'セマンティック拡張機能',
	'smw_baduri' => '「$1」の形式の URI は許可されていません。',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => '集計結果',
	'smw_printername_csv' => 'CSV 形式で書き出し',
	'smw_printername_dsv' => 'DSV 形式で書き出し',
	'smw_printername_debug' => 'クエリをデバッグ (上級者向け)',
	'smw_printername_embedded' => 'ページの内容を埋め込む',
	'smw_printername_json' => 'JSON 形式で書き出し',
	'smw_printername_list' => '一覧',
	'smw_printername_ol' => '番号付き箇条書き',
	'smw_printername_ul' => '箇条書き',
	'smw_printername_table' => '表',
	'smw_printername_broadtable' => '幅広の表',
	'smw_printername_template' => 'テンプレート',
	'smw_printername_rdf' => 'RDF 形式で書き出し',
	'smw_printername_category' => 'カテゴリ',
	'validator-type-class-SMWParamSource' => 'テキスト',
	'smw-paramdesc-limit' => '返す結果の最大数',
	'smw-paramdesc-offset' => '最初の結果のオフセット',
	'smw-paramdesc-headers' => 'ヘッダー名やプロパティ名を表示',
	'smw-paramdesc-mainlabel' => 'メインページ名に付けるラベル',
	'smw-paramdesc-link' => '値をリンクとして表示',
	'smw-paramdesc-intro' => '問い合わせ結果がある場合、その前に表示する文字列',
	'smw-paramdesc-outro' => '問い合わせ結果がある場合、その後に表示する文字列',
	'smw-paramdesc-default' => '問い合わせ結果がない場合に表示する文字列',
	'smw-paramdesc-sep' => '値の区切り文字',
	'smw-paramdesc-showsep' => 'CSV ファイルの先頭に区切り文字を表示する ("sep=<value>")',
	'smw-paramdesc-template' => '印刷出力とともに表示するテンプレートの名前',
	'smw-paramdesc-columns' => '結果を表示する列の数 (既定は$1)',
	'smw-paramdesc-userparam' => 'テンプレートが使用されている場合に、各テンプレート呼出しに渡される値',
	'smw-paramdesc-introtemplate' => '問い合わせ結果がある場合、その前に表示するテンプレートの名前',
	'smw-paramdesc-outrotemplate' => '問い合わせ結果がある場合、その後に表示するテンプレートの名前',
	'smw-paramdesc-embedformat' => '見出しの定義に使用する HTML タグ',
	'smw-paramdesc-embedonly' => '見出しを表示しない',
	'smw-paramdesc-table-class' => '表に設定する追加 CSS クラス',
	'smw-paramdesc-rdfsyntax' => '使用する RDF 構文',
	'smw-paramdesc-csv-sep' => '使用する区切り文字',
	'smw-paramdesc-dsv-separator' => '使用する区切り文字',
	'smw-paramdesc-dsv-filename' => 'DSV ファイルの名前',
	'smw-paramdesc-sort' => 'クエリの並び順のプロパティ',
	'smw-paramdesc-order' => 'クエリの並べ替えでの並び順',
	'smw-paramdesc-searchlabel' => '検索結果の続きへのリンク文字列',
	'smw-paramdesc-named_args' => 'テンプレートに渡した引数に名前を付ける',
	'smw-paramdesc-export' => '書き出しオプション',
	'smw-paramdesc-jsonsyntax' => 'JSON 構文を使用します',
	'smw-printername-feed' => 'RSS / Atom フィード',
	'smw-paramdesc-feedtype' => 'フィードの種類',
	'smw-paramdesc-feedtitle' => 'フィードの表題として使用する文字列',
	'smw-paramdesc-feeddescription' => 'フィードの説明として使用する文字列',
	'smw-paramdesc-feedpagecontent' => 'フィードにページの本文も含める',
	'smw-label-feed-description' => '$1 の $2 フィード',
	'smw_iq_disabled' => 'このウィキでは、意味的クエリは無効になっています。',
	'smw_iq_moreresults' => '… その他の結果',
	'smw_parseerror' => '指定した値を理解できませんでした。',
	'smw_notitle' => '「$1」はこのウィキではページ名として使用できません。',
	'smw_noproperty' => '「$1」はこのウィキではプロパティ名として使用できません。',
	'smw_wrong_namespace' => 'ここでは、「$1」名前空間のページのみが許可されています。',
	'smw_manytypes' => 'プロパティに対して複数の型を定義しました。',
	'smw_emptystring' => '空文字列は受け入れられません。',
	'smw_maxstring' => '文字列表現 $1 は長すぎます。',
	'smw_notinenum' => '「$1」は、このプロパティが取りうる値 ($2) の一覧にありません。',
	'smw_noboolean' => '「$1」はブール値 (真/偽) として認識されません。',
	'smw_true_words' => 'true,t,yes,y',
	'smw_false_words' => 'false,f,no,n',
	'smw_nofloat' => '「$1」は数値ではありません。',
	'smw_infinite' => '「$1」を超える数値には対応していません。',
	'smw_unitnotallowed' => '「$1」はこのプロパティの測定値の有効な単位として宣言されていません。',
	'smw_nounitsdeclared' => 'このプロパティの測定の単位は何も宣言されませんでした。',
	'smw_novalues' => '値が指定されていません。',
	'smw_nodatetime' => '日付「$1」を理解できませんでした。',
	'smw_toomanyclosing' => 'クエリ内の「$1」の数が多すぎるようです。',
	'smw_noclosingbrackets' => 'クエリ内の「<nowiki>[[</nowiki>」に、対応する「]]」で閉じられていないものがありました。',
	'smw_misplacedsymbol' => '記号「$1」が、無意味な場所で使用されました。',
	'smw_unexpectedpart' => 'クエリの一部「$1」を理解できませんでした。
結果は予期しないものになる可能性があります。',
	'smw_emptysubquery' => '有効な条件がないサブクエリがあります。',
	'smw_misplacedsubquery' => '許可されていない場所で使用されているサブクエリがあります。',
	'smw_valuesubquery' => 'プロパティ「$1」の値は、サブクエリに対応していません。',
	'smw_badqueryatom' => 'クエリの一部「<nowiki>[[…]]</nowiki>」を理解できませんでした。',
	'smw_propvalueproblem' => 'プロパティ「$1」の値を理解できませんでした。',
	'smw_noqueryfeature' => 'このウィキが対応していないクエリ機能があるため、クエリの一部を破棄しました ($1)。',
	'smw_noconjunctions' => 'このウィキはクエリの連言に対応していないため、クエリの一部を破棄しました ($1)。',
	'smw_nodisjunctions' => 'このウィキはクエリの選言に対応していないため、クエリの一部を破棄しました ($1)。',
	'smw_querytoolarge' => 'クエリの長さまたは深さに関するウィキ上の制限のため、以下のクエリ条件は考慮されませんでした: $1',
	'smw_notemplategiven' => 'このクエリ形式を動作させるには、引数「テンプレート」の値を指定してください。',
	'smw_db_sparqlqueryproblem' => 'クエリの結果を SPARQL データベースから取得できませんでした。このエラーは一時的なものである可能性、またはデータベース ソフトウェアのバグである可能性があります。',
	'smw_type_header' => '型「$1」のプロパティ',
	'smw_typearticlecount' => 'この型を使用している $1 {{PLURAL:$1|プロパティ}}を表示しています。',
	'smw_attribute_header' => 'プロパティ「$1」を使用しているページ',
	'smw_attributearticlecount' => 'このプロパティを使用している $1 {{PLURAL:$1|件のページ}}を表示しています。',
	'smw_subproperty_header' => '下位プロパティ',
	'smw_subpropertyarticlecount' => 'このプロパティには以下の $1 {{PLURAL:$1|下位プロパティ}}があります：',
	'smw_concept_header' => '概念「$1」のページ',
	'smw_conceptarticlecount' => 'この概念に属する $1 {{PLURAL:$1|件のページ}}を表示しています。',
	'specialpages-group-smw_group' => 'Semantic MediaWiki',
	'exportrdf' => 'ページをRDFに書き出し',
	'smw_exportrdf_docu' => 'このページを使用すると、ページからデータをRDF形式で取得できます。
ページを書き出すには、下のテキストボックスにページ名を一行に一つずつ入力してください。',
	'smw_exportrdf_recursive' => 'すべての関連ページを再帰的に書き出す。
結果が大きくなる場合があるため注意してください。',
	'smw_exportrdf_backlinks' => '書き出し対象のページを参照するページもすべて書き出す。
閲覧できるRDFを生成する。',
	'smw_exportrdf_lastdate' => '指定した時点以降に変更がされていないページを書き出さない。',
	'smw_exportrdf_submit' => '書き出し',
	'uriresolver' => 'URI リゾルバー',
	'properties' => 'プロパティ',
	'smw_properties_docu' => 'このウィキでは以下のプロパティが使用されています。',
	'smw_property_template' => '$1、$2 型 ($3 {{PLURAL:$3|回使用}})',
	'smw_property_template_notype' => '$1 ($2 件)',
	'smw_propertylackspage' => 'すべてのプロパティについて、各プロパティのページで解説する必要があります！',
	'smw_propertylackstype' => 'このプロパティには型が指定されていません (現時点では型 $1 と想定します)。',
	'smw_propertyhardlyused' => 'このプロパティはウィキ内でほとんど使用されていません！',
	'unusedproperties' => '使われていないプロパティ',
	'smw_unusedproperties_docu' => '以下のプロパティは存在しますが、他のページで使用されていません。',
	'smw_unusedproperty_template' => '$1: 型 $2',
	'wantedproperties' => '望まれているプロパティ',
	'smw_wantedproperties_docu' => 'このウィキでは以下のプロパティが使用されていますが、これらのプロパティを説明するページはまだありません。',
	'smw_wantedproperty_template' => '$1 ($2{{PLURAL:$2|件}})',
	'smw_purge' => '更新',
	'types' => '型',
	'smw_types_docu' => '以下はプロパティに割り当てられているすべてのデータ型の一覧です。',
	'semanticstatistics' => '意味的統計',
	'smw_semstats_text' => "このウィキには、計 '''$2'''種の[[Special:Properties|{{PLURAL:$2|プロパティ}}]]と '''$1'''個の{{PLURAL:$1|プロパティ値}}があります。
'''$3'''個の{{PLURAL:$3|プロパティ}}には専用のページがあり、うち '''$4'''個にはデータ型が指定されています。
既存のプロパティには[[Special:UnusedProperties|使われていないプロパティ]]があるかもしれません。
まだ解説ページないプロパティは[[Special:WantedProperties|望まれているプロパティ一覧]]に載っています。",
	'smw_uri_doc' => 'URI リゾルバーは [$1 W3C TAG での httpRange-14 に関する議論成果]を実装しています。
これは人間がウェブサイトに向かわないように取り計らいます。',
	'ask' => '意味的検索',
	'smw_ask_sortby' => '列ごとに並べ替え (任意選択)',
	'smw_ask_ascorder' => '昇順',
	'smw_ask_descorder' => '降順',
	'smw_ask_submit' => '結果を取得',
	'smw_ask_editquery' => '[クエリを編集]',
	'smw_add_sortcondition' => '[並べ替え条件を追加]',
	'smw_ask_hidequery' => 'クエリを非表示',
	'smw_ask_help' => 'クエリのヘルプ',
	'smw_ask_queryhead' => 'クエリ',
	'smw_ask_printhead' => '表示する追加データ',
	'smw_ask_printdesc' => '(プロパティ名を各行に 1 つ追加してください)',
	'smw_ask_format_as' => '書式:',
	'smw_ask_defaultformat' => '既定',
	'smw_ask_otheroptions' => '他の選択肢',
	'smw-ask-otheroptions-collapsed-info' => '利用できるオプションをすべて表示するには + アイコンを使用してください',
	'smw_ask_show_embed' => '埋め込み用コードを表示',
	'smw_ask_hide_embed' => '埋め込み用コードを非表示',
	'smw_ask_embed_instr' => 'このクエリをウィキページにインラインで埋め込むには、下記のコードを使用します。',
	'smw-ask-delete' => '[削除]',
	'smw-ask-sorting' => '並べ替え',
	'smw-ask-format-selection-help' => '詳細な説明は、$1のヘルプ ページを参照してください。',
	'querycreator' => 'クエリ作成',
	'smw_qc_addmainlabel' => 'メイン ラベルを追加',
	'smw_qc_show_addnal_opts' => 'その他のオプションを表示',
	'smw_qc_hide_addnal_opts' => 'オプションを折り畳む',
	'smw_qc_otheropt' => 'その他のオプション',
	'smw_qc_default' => '既定:',
	'smw_qc_formatopt' => '書式オプション',
	'smw_qc_query_help' => '下記のフォームを使ってクエリを入力します。カテゴリ (<strong><nowiki>例: [[Category:俳優]]</nowiki></strong>)、プロパティ (<strong><nowiki>例: [[Located in::ドイツ]]</nowiki></strong>)、名前 (<strong><nowiki>例: [[ドイツ]]</nowiki></strong>)、名前空間 (<strong><nowiki>[[Help:+]]</nowiki></strong>) などで対象のページを指定します。',
	'smw_qui_property' => '<strong>プロパティ</strong>',
	'smw_qui_prop' => 'プロパティ:',
	'smw_qui_labl' => 'ラベル:',
	'smw_qui_formt' => '書式:',
	'smw_qui_limt' => '制限:',
	'smw_qui_shownresults' => '結果に表示',
	'smw_qui_noquery' => 'クエリが指定されていません',
	'smw_qui_invalidprop' => '「$1」は有効なプロパティではない可能性があります',
	'smw_qui_invalidformat' => '選択した書式「$1」はこのウィキに存在しません',
	'smw_qui_nosort' => '並べ替えなし',
	'smw_qui_ascorder' => '昇順',
	'smw_qui_descorder' => '降順',
	'smw_qui_randorder' => '無作為',
	'smw_qui_addnprop' => 'プロパティを追加',
	'smw_qui_delete' => '除去',
	'smw_qui_options' => 'オプション',
	'smw_qui_addcategory' => 'カテゴリを追加',
	'smw_qui_ok' => 'OK',
	'smw_qui_cancel' => 'キャンセル',
	'smw_qui_category' => '<strong>カテゴリ</strong>',
	'smw_qui_label' => 'ラベル',
	'smw_prp_options' => 'プロパティ オプション',
	'smw_qui_catopts' => 'カテゴリ オプション',
	'smw_qui_mainlabopts' => '結果オプション',
	'smw_qui_dlabel' => 'ラベル:',
	'smw_qui_dcategory' => 'カテゴリ:',
	'searchbyproperty' => 'プロパティによる検索',
	'smw_sbv_docu' => '指定したプロパティと値を持つすべてのページを検索します。',
	'smw_sbv_novalue' => 'そのプロパティに対して有効な値を入力するか、「$1」のすべてのプロパティ値を確認してください。',
	'smw_sbv_displayresult' => 'プロパティ「$1」の値が「$2」であるすべてのページの一覧',
	'smw_sbv_displayresultfuzzy' => 'プロパティ「$1」の値が「$2」であるすべてのページの一覧。
結果がごく少数だったため、近い値も表示しています。',
	'smw_sbv_property' => 'プロパティ:',
	'smw_sbv_value' => '値:',
	'smw_sbv_submit' => '結果を取得',
	'browse' => 'ウィキの閲覧',
	'smw_browselink' => 'プロパティを閲覧',
	'smw_browse_article' => '閲覧を開始するページの名前を入力してください。',
	'smw_browse_go' => '表示',
	'smw_browse_show_incoming' => 'このページにリンクしているプロパティを表示',
	'smw_browse_hide_incoming' => 'このページにリンクしているプロパティを隠す',
	'smw_browse_no_outgoing' => 'このページにはプロパティはありません。',
	'smw_browse_no_incoming' => 'このページは、他のプロパティからリンクされていません。',
	'smw_inverse_label_default' => '$1である',
	'smw_inverse_label_property' => '逆プロパティのラベル',
	'pageproperty' => 'ページのプロパティの検索',
	'smw_pp_docu' => '指定したページのプロパティについてすべての値を検索します。
ページとプロパティの両方を入力してください。',
	'smw_pp_from' => '対象ページ',
	'smw_pp_type' => 'プロパティ',
	'smw_pp_submit' => '結果を取得',
	'smw_result_prev' => '前へ',
	'smw_result_next' => '次へ',
	'smw_result_results' => '結果',
	'smw_result_noresults' => '該当結果はありません。',
	'smwadmin' => 'Semantic MediaWiki の管理機能',
	'smw_smwadmin_setupsuccess' => 'ストレージ エンジンを構築しました。',
	'smw_smwadmin_return' => '$1 に戻る',
	'smw_smwadmin_updatestarted' => '意味的データを最新の状態にするための新しい更新プロセスを開始しました。
格納済みのデータはすべて必要に応じて再構築または修復されます。
この特別ページで更新の状況を追うことができます。

$1に戻る。',
	'smw_smwadmin_updatenotstarted' => '既に実行中の更新プロセスがあります。
新たに作成しないでください。

$1に戻る。',
	'smw_smwadmin_updatestopped' => '既存のすべての更新プロセスは停止されました。

$1に戻る。',
	'smw_smwadmin_updatenotstopped' => '実行中の更新プロセスを停止するには、本当に理解していることを示すためにチェックボックスを選択する必要があります。

$1に戻る。',
	'smw_smwadmin_docu' => 'この特別ページは <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a> のインストールとアップグレードを支援します。
管理機能を実行する前に、重要なデータをバックアップするようにしてください。',
	'smw_smwadmin_db' => 'データベースのインストールおよびアップグレード',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki は意味的データを格納するため、MediaWiki のデータベースに対していくつかの拡張を必要とします。
以下の機能はあなたのデータベースが適切に構築されていることを確実にするものです。
この作業でなされた変更は MediaWiki のデータベースのその他の部分には影響を与えず、必要なら簡単に取り消しができます。
この機能は複数回実行しても何の害もありませんが、インストールもしくはアップグレード時に一度だけ実行すれば十分です。',
	'smw_smwadmin_permissionswarn' => 'SQL エラーを出して処理が失敗する場合、おそらくあなたのウィキのデータベース ユーザー (LocalSettings.php を確認してください) に必要な権限がありません。
LocalSettings.php に一時的にデータベースの root のログイン情報を記入してこのユーザーにテーブルを作成および削除するための追加権限を与えるか、<tt>SMW_setup.php</tt> の認証情報を使用できるメンテナンススクリプト <tt>SMW_setup.php</tt> を使用してください。',
	'smw_smwadmin_dbbutton' => 'テーブルを初期化またはアップグレード',
	'smw_smwadmin_announce' => 'あなたのウィキの発表',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki には新しい意味的ウィキのサイトを発表するためのウェブサービスがあります。
このサービスは Semantic MediaWiki を使用するサイト一覧の保守に使用されており、主に <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki プロジェクト</a>が Semantic MediaWiki の典型的な使用法を把握するために使用されています。
Semantic MediaWiki のホームページで<a href="http://semantic-mediawiki.org/wiki/Registry">このサービスの詳細情報</a>をご覧ください。',
	'smw_smwadmin_announcebutton' => '以下のボタンを押して、あなたのウィキのURLをこのサービスに送信します。
このサービスでは、公開されていないウィキを登録せず、公開されている情報のみを保管します。',
	'smw_smwadmin_datarefresh' => 'データの修復とアップグレード',
	'smw_smwadmin_datarefreshdocu' => 'ウィキの現在の内容に基づいて、Semantic MediaWiki の全データを復旧できます。
この機能は破損したデータを修復する場合や、ソフトウェアのアップグレードで内部形式が変わった際にデータを移行する場合などに有用です。
この更新は1ページずつ実行され、直ちには完了しません。
以下に更新が進行中かどうかを表示します。更新を開始または停止できます (サイト管理者が機能を無効にしていない場合のみ)。',
	'smw_smwadmin_datarefreshprogress' => '<strong>更新が既に進行しています。</strong>
利用者がウィキにアクセスするたびに少量の塊のデータを更新するのみのため、更新がゆっくりとしか進まないのは正常な動作です。
この更新をより早く終えたい場合は、MediaWiki のメンテナンス スクリプト <tt>runJobs.php</tt> を起動できます (1つのバッチで行われる更新の数を制限するには <tt>--maxjobs 1000</tt> オプションを使用してください)。
現在の更新の推定進捗：',
	'smw_smwadmin_datarefreshbutton' => 'データの更新を開始',
	'smw_smwadmin_datarefreshstop' => 'この更新を停止',
	'smw_smwadmin_datarefreshstopconfirm' => 'はい、もちろんです。',
	'smw_smwadmin_support' => '支援を得る',
	'smw_smwadmin_supportdocu' => '問題が発生したときにさまざまなリソースが助けとなるかもしれません：',
	'smw_smwadmin_installfile' => 'インストールに問題を発見した場合、<a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL ファイル</a>にある指針を確認することから始めてください。',
	'smw_smwadmin_smwhomepage' => 'Semantic MediaWiki 利用者用の完全なドキュメントは <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b> にあります。',
	'smw_smwadmin_mediazilla' => 'バグは <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> で報告できます。',
	'smw_smwadmin_questions' => 'さらなる質問や提案がある場合は、<a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki 利用者フォーラム</a>での議論に参加してください。',
	'smw_adminlinks_datastructure' => 'データ構造',
	'smw_adminlinks_displayingdata' => 'データの表示',
	'smw_adminlinks_inlinequerieshelp' => 'インラインクエリのヘルプ',
	'smw-createproperty-isproperty' => 'これは型 $1 のプロパティです。',
	'smw-createproperty-allowedvals' => 'このプロパティが取れる{{PLURAL:$1|値}}:',
	'smw-paramdesc-category-delim' => '区切り文字',
	'smw-paramdesc-category-template' => '項目の整形に使用するテンプレート',
	'smw-paramdesc-category-userparam' => 'テンプレートに渡すパラメーター',
	'smw-info-par-message' => '表示するメッセージです。',
	'smw-info-par-icon' => '表示するアイコン ("info" と "warning" のいずれか) です。',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => '意味的検索オプション',
	'smw-prefs-intro-text' => '以下のオプションは [http://semantic-mediawiki.org/ Semantic MediaWiki] (または関連する拡張機能) が提供しています。選択した機能の個別のカスタマイズを有効化できます。これについての詳細は[http://semantic-mediawiki.org/wiki/Help:User_preferences ヘルプ]を参照してください。',
	'smw-prefs-ask-options-tooltip-display' => 'パラメーター文字列を情報ツールチップとして表示',
	'smw-prefs-ask-options-collapsed-default' => 'オプションボックスを既定では折り畳む',
	'smw-ui-tooltip-title-property' => 'プロパティ',
	'smw-ui-tooltip-title-quantity' => '数量',
	'smw-ui-tooltip-title-info' => '情報',
	'smw-ui-tooltip-title-service' => 'サービスのリンク',
	'smw-ui-tooltip-title-warning' => 'エラー',
	'smw-ui-tooltip-title-parameter' => 'パラメーター',
	'smw-ui-tooltip-title-event' => 'イベント',
	'smw_unknowntype' => 'このプロパティの型は無効です',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 * @author Pras
 */
$messages['jv'] = array(
	'smw_viewasrdf' => 'RDF feed',
	'smw_finallistconjunct' => ', lan',
	'smw_factbox_head' => 'Fakta-fakta ngenani $1',
	'smw_isspecprop' => 'Sifat iki iku sawijining sifat kusus ing wiki iki.',
	'smw_baduri' => 'Nuwun sèwu, URI awujud “$1” ora diidinaké.',
	'smw_iq_disabled' => 'Nuwun sèwu. Kwéri sémantik kanggo wiki iki dipatèni.',
	'smw_iq_moreresults' => '… pituwas sabanjuré',
	'smw_parseerror' => 'Bijih sing diwènèhaké ora dimangertèni.',
	'smw_notitle' => '“$1” ora bisa dienggo minangka jeneng kaca ing wiki iki.',
	'smw_manytypes' => 'Sifaté didéfinisi luwih saka sajenis.',
	'smw_emptystring' => 'Rangkéan kosong ora ditampa.',
	'smw_maxstring' => 'Répresèntasi string $1 kedawan.',
	'smw_notinenum' => '“$1” ora ana ing daftar bijih-bijih sing mungkin ($2) kanggo sifat iki.',
	'smw_noboolean' => '“$1” ora ditepungi minangka sawijining bijih Boolean (bener/salah).',
	'smw_true_words' => 'bener,t,ya,y',
	'smw_false_words' => 'salah,s,ora,o',
	'smw_nofloat' => '“$1” iku dudu angka.',
	'smw_infinite' => 'Angka sing gedhéné nganti "$1" ora didhukung.',
	'smw_nodatetime' => 'Tanggal “$1” ora dimangertèni.',
	'smw_toomanyclosing' => 'Katoné ana kakèhan “$1” sajroning kwéri.',
	'smw_noclosingbrackets' => 'Sawetara panrapan “<nowiki>[[</nowiki>” ing kwéri panjenengan ora ditutup déning “]]” sing cocog.',
	'smw_misplacedsymbol' => 'Simbul “$1” dienggo ing sawijining panggonan sing ora miguna.',
	'smw_unexpectedpart' => 'Bagéyan “$1” saka kwéri ora dimangertèni.
Pituwasé bisa-bisa ora kaya sing diarepaké.',
	'smw_emptysubquery' => 'Sawetara subkwéri ora nduwé kondisi absah.',
	'smw_misplacedsubquery' => 'Sawetara subkwéri dienggo ing panggonan sing ora diparengaké anané subkwéri.',
	'smw_valuesubquery' => 'Subkwéri ora disengkuyung kanggo bijih saka sifat “$1”.',
	'smw_badqueryatom' => 'Ora mudheng “<nowiki>[[…]]</nowiki>” sawetara bagéyan kwéri.',
	'smw_propvalueproblem' => 'Bijih sifat "$1" ora dimangertèni.',
	'smw_nodisjunctions' => 'Pamisahan ing kwéri ora disengkuyung ing wiki iki lan sabagéyan saka kwéri dadi dilirwakaké ($1).',
	'smw_querytoolarge' => 'Sarat kwéri sing kapacak ing ngisor iki ora bisa digalih amerga anané rèstriksi wiki ing ukuran utawa jeroné: $1.',
	'smw_type_header' => 'Sifat-sifat saka jenis "$1"',
	'smw_typearticlecount' => 'Nuduhaké $1 {{PLURAL:$1|sifat|sifat}} nganggo jinis iki.',
	'smw_attribute_header' => 'Kaca-kaca sing nganggo sifat “$1”',
	'smw_attributearticlecount' => 'Nuduhaké $1 {{PLURAL:$1|kaca|kaca}} nganggo sifat iki.',
	'exportrdf' => 'Èkspor kaca-kaca menyang RDF',
	'smw_exportrdf_docu' => 'Kaca iki marengaké panjenengan kanggo olèh data saka sawijining kaca ing format RDF.
Kanggo ngèkspor kaca-kaca, mangga lebokna irah-irahan ing kothak tèks ing ngisor iki, sairah-irahan per baris.',
	'smw_exportrdf_recursive' => 'Ngèkspor kabèh kaca sing ana gandhèngané minangka rékursif.
Pènget: pituwasé bisa gedhé!',
	'smw_exportrdf_backlinks' => 'Uga ngèkspor kabèh kaca ing ngrujuk ing kaca-kaca sing dièkspor.
Nggawé berkas RDF sing bisa dijlajah.',
	'smw_exportrdf_lastdate' => 'Aja ngèkspor kaca-kaca sing ora diowahi wiwit sawijining wektu tartamtu.',
	'uriresolver' => 'URI Resolver',
	'properties' => 'Sifat-sifat',
	'smw_properties_docu' => 'Sifat-sifat ing ngisori iki dienggo ing wiki iki.',
	'smw_property_template' => '$1 saka jenis $2 ($3)',
	'smw_propertylackspage' => 'Kabèh sifat kudu didèskripsi déning sawijining kaca!',
	'smw_propertylackstype' => 'Ora ana jenis sing dispésifikasi kanggo sifat iki (ngasumsi jenis $1 kanggo saiki).',
	'smw_propertyhardlyused' => 'Sifat iki mèh ora dienggo sajroning wiki iki!',
	'unusedproperties' => 'Sifat-sifat sing ora dienggo',
	'smw_unusedproperties_docu' => 'Sifat-sifat sing kapacak iki ana, senadyan ora ana kaca liya sing nganggo.',
	'smw_unusedproperty_template' => '$1 saka jenis $2',
	'wantedproperties' => 'Sifat sing dipéngini',
	'smw_wantedproperties_docu' => 'Sifat-sifat iki dienggo ing wiki, nanging durung duwé kaca sing ndéskripsi.',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|dianggo kaping|dianggo kaping }}$2)',
	'smw_purge' => 'Anyarana',
	'types' => 'Jenis-jenis',
	'smw_types_docu' => 'Ing ngisor iki kapacak sawijining daftar kabèh jenis data sing bisa ditunjukaké menyang sifat-sifat.
Saben jenis data duwé kaca ing ngendi informasi tambahan bisa diwènèhaké.', # Fuzzy
	'semanticstatistics' => 'Statistik sémantik',
	'smw_semstats_text' => "Wiki iki ngandhut '''$1''' {{PLURAL:$1|aji|aji}} sifat nganti gunggung '''$2''' [[Special:Properties|{{PLURAL:$2|sifat|sifat}}]].
'''$3''' {{PLURAL:$3|sifat nduwèni|sifat nduwèni}} kaca dhéwé, lan jinis-data sing dimaksudaké kanggo '''$4'''.
Sawetara sifat sing ana mbokmanawa [[Special:UnusedProperties|ora dipigunakaké]].
Sifat-sifat sing isih ora duwé kaca bisa ditemokaké ing [[Special:WantedProperties|dhaptar sifat-sifat sing dikarepaké]].",
	'smw_uri_doc' => "''URI resolver''-é ngimplèmèntasi <a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG finding on httpRange-14</a>. Iku ngurusi supaya manungsa ora owah lan dadi situs-situs wèb.",
	'ask' => 'Panggolèkan sémantik',
	'smw_ask_sortby' => 'Sortir miturut kolom (opsional)',
	'smw_ask_ascorder' => 'Munggah saka ngisor menyang ndhuwur',
	'smw_ask_descorder' => 'Mudhun saka ndhuwur menyang ngisor',
	'smw_ask_submit' => 'Pituwas panggolèkan',
	'smw_ask_editquery' => '[Sunting kwéri]',
	'smw_add_sortcondition' => '[Tambah sarat nyortir]',
	'smw_ask_hidequery' => 'Delikna kwéri',
	'smw_ask_help' => 'Pitulung kwéri',
	'smw_ask_queryhead' => 'Kwéri',
	'smw_ask_printhead' => 'Cithakan tambahan (opsional)', # Fuzzy
	'searchbyproperty' => 'Golèk miturut sifat',
	'smw_sbv_docu' => 'Golèk kabèh kaca sing duwé sifat lan bijih tartamtu.',
	'smw_sbv_novalue' => 'Mangga lebokna bijih absah kanggo sifat iki, utawa tuduhna kabèh bijih-bijihé sifat kanggo “$1.”',
	'smw_sbv_displayresult' => 'Sawijining daftar kabèh kaca sing duwé sifat “$1” mawa bijih “$2”',
	'smw_sbv_property' => 'Sifat/properti:',
	'smw_sbv_value' => 'Aji:',
	'smw_sbv_submit' => 'Golèk pituwas (kasil)',
	'browse' => 'Jlajaha wiki',
	'smw_browse_article' => 'Lebokna irah-irahan kaca sing arep didadèkaké kaca awal olèhé panjenengan njlajah-njlajah.',
	'smw_browse_go' => 'Tumuju',
	'pageproperty' => 'Panggolèkan sifat kaca',
	'smw_pp_docu' => 'Nggolèki kabèh pangisi sawijining sifat ing sawijining kaca.
Tulung isèkna loro-loroné sawijining kaca lan sifat.',
	'smw_pp_from' => 'Saka kaca',
	'smw_pp_type' => 'Sifat',
	'smw_pp_submit' => 'Pituwas panggolèkan',
	'smw_result_prev' => 'Sadurungé',
	'smw_result_next' => 'Sabanjuré',
	'smw_result_results' => 'Pituwas (kasil)',
	'smw_result_noresults' => 'Nuwun sèwu, ora ana pituwasé (kasilé).',
	'smw_unknowntype' => 'Jenis “$1” sing ora disengkuyung, didéfinisi kanggo sifat.', # Fuzzy
);

/** Georgian (ქართული)
 * @author David1010
 * @author Malafaya
 */
$messages['ka'] = array(
	'smw_finallistconjunct' => ', და',
	'smw_printername_count' => 'დათვლის შედეგები',
	'smw_printername_csv' => 'CSV-ის ექსპორტი',
	'smw_printername_dsv' => 'DSV-ის ექსპორტი',
	'smw_printername_json' => 'JSON-ის ექსპორტი',
	'smw_printername_list' => 'სია',
	'smw_printername_rss' => 'RSS-ის ექსპორტი',
	'smw_printername_template' => 'თარგი',
	'smw_printername_rdf' => 'RDF-ის ექსპორტი',
	'smw_printername_category' => 'კატეგორია',
	'smw_true_words' => 'სიმართლე,ს,დიახ,დ',
	'smw_false_words' => 'ტყუილი,ტ,არა,ა',
	'smw_nofloat' => '„$1“ არ არის ნომერი.',
	'exportrdf' => 'გვერდების ექსპორტი RDF-ში',
	'smw_exportrdf_submit' => 'ექსპორტი',
	'properties' => 'პარამეტრები',
	'smw_purge' => 'განახლება',
	'types' => 'ტიპები',
	'semanticstatistics' => 'სემანტიკური სტატისტიკა',
	'ask' => 'სემანტიკური ძიება',
	'smw_ask_sortby' => 'სვეტების მოხედვით დალაგება (არასავალდებულო)',
	'smw_ask_ascorder' => 'ზრდის მიხედვით',
	'smw_ask_descorder' => 'კლების მიხედვით',
	'smw_ask_defaultformat' => 'სტანდარტული',
	'smw_ask_otheroptions' => 'სხვა პარამეტრები',
	'smw-ask-delete' => '[წაშლა]',
	'smw_qc_default' => 'სტანდარტული:',
	'smw_qc_formatopt' => 'ფორმატის პარამეტრები',
	'smw_qui_labl' => 'იარლიყი:',
	'smw_qui_formt' => 'ფორმატი:',
	'smw_qui_limt' => 'ლიმიტი:',
	'smw_qui_shownresults' => 'შედეგებში ჩვენება',
	'smw_qui_ascorder' => 'ზრდის მიხედვით',
	'smw_qui_descorder' => 'კლების მიხედვით',
	'smw_qui_randorder' => 'შემთხვევითი',
	'smw_qui_delete' => 'წაშლა',
	'smw_qui_options' => 'პარამეტრები',
	'smw_qui_addcategory' => 'კატეგორიის დამატება',
	'smw_qui_ok' => 'კარგი',
	'smw_qui_cancel' => 'გაუქმება',
	'smw_qui_category' => '<strong>კატეგორია</strong>',
	'smw_qui_label' => 'იარლიყი',
	'smw_qui_dlabel' => 'იარლიყი:',
	'smw_qui_dcategory' => 'კატეგორია:',
	'smw_sbv_value' => 'მნიშვნელობა:',
	'smw_browse_go' => 'მიდი',
	'smw_result_prev' => 'წინა',
	'smw_result_next' => 'შემდეგი',
	'smw_result_results' => 'შედეგები',
	'smw_result_noresults' => 'შედეგები არ არის.',
	'smw_smwadmin_datarefreshbutton' => 'მონაცემების განახლების დაწყება',
	'smw_smwadmin_datarefreshstop' => 'ამ განახლების შეჩერება',
	'smw_smwadmin_datarefreshstopconfirm' => 'დიახ, დარწმუნებული ვარ.',
	'smw_smwadmin_mediazilla' => 'შეცდომების შეტყობინება შესაძლებელია <a href="https://bugzilla.wikimedia.org/">ბაგზილაში</a>.',
	'smw_adminlinks_datastructure' => 'მონაცემების სტრუქტურა',
);

/** Kirmanjki (Kırmancki)
 * @author Erdemaslancan
 */
$messages['kiu'] = array(
	'querycreator' => 'Dekerdışê Werênayışi',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'smw_finallistconjunct' => 'និង',
	'smw_factbox_head' => 'ហេតុការណ៍ពិត​អំពី $1',
	'smw_isspecprop' => 'លក្ខណៈសម្បត្តិ​នេះ គឺជា​លក្ខណៈសម្បត្តិ​ពិសេស​នៅក្នុង​វិគី​នេះ​។',
	'smw_baduri' => 'URIs នៃ​ទម្រង់ "$1" មិន​ត្រូវ​បាន​អនុញ្ញាត​ទេ​។',
	'smw_iq_moreresults' => '... លទ្ធផល​ខាងមុខ​ទៀត',
	'smw_parseerror' => 'តម្លៃ​ដែល​បាន​ផ្ដល់ឱ្យ មិន​អាច​យល់​បាន​ទេ​។',
	'smw_notitle' => '"$1" មិន​អាច​ត្រូវ​បាន​ប្រើប្រាស់​ជា​ឈ្មោះ​ទំព័រ​នៅក្នុង​វិគី​នេះ​ទេ​។',
	'smw_wrong_namespace' => 'មានតែ​ទំព័រ​នៅ​ក្នុង​លំហឈ្មោះ "$1" ប៉ុណ្ណោះ ដែល​ត្រូវ​បាន​អនុញ្ញាត​នៅទីនេះ​។',
	'smw_noboolean' => '"$1" មិន​ត្រូវ​បាន​ទទួលស្គាល់​ជា​តម្លៃ​ប៊ូលីន (ត្រូវ/ខុស) ទេ​។',
	'smw_true_words' => 'ត្រូវ,ត,បាទ,ប',
	'smw_false_words' => 'ខុស,ខ,ទេ,ទ',
	'smw_nofloat' => '"$1" មិនមែន​ជា​លេខ​ទេ​។',
	'smw_nodatetime' => 'កាលបរិច្ឆេទ "$1" មិន​អាច​យល់​បាន​ទេ​។',
	'smw_toomanyclosing' => 'ហាក់ដូចជា មាន​​ការគាប់ជួន​ច្រើនពេក​នៃ "$1" នៅក្នុង​សំណួរ​របស់​អ្នក​។',
	'smw_noclosingbrackets' => 'ការប្រើប្រាស់​នៃ "<nowiki>[[</nowiki>" នៅក្នុង​សំណួរ​របស់​អ្នក​មិនត្រូវ​បាន​បិទ​ដោយ​សញ្ញា​ "]]" ជាគូ​។',
	'smw_misplacedsymbol' => 'និមិត្តសញ្ញា "$1" ត្រូវ​បាន​ប្រើ​ជំនួស​កន្លែង ដែល​មិន​ត្រូវ​បាន​ប្រើ​។',
	'smw_propvalueproblem' => 'តម្លៃ​នៃ​លក្ខណៈសម្បត្តិ "$1" មិន​អាច​យល់​បាន​ទេ​។',
	'smw_notemplategiven' => 'ផ្ដល់​តម្លៃ​សម្រាប់​ប៉ារ៉ាម៉ែត្រ "ទំព័រគំរូ" សម្រាប់​ទ្រង់ទ្រង់​សំណួរ​នេះ​ដើម្បី​ធ្វើការ​។',
	'smw_type_header' => 'លក្ខណៈសម្បត្តិ​នៃ​គំរូ "$1"',
	'smw_typearticlecount' => 'បង្ហាញ $1 {{PLURAL:$1|លក្ខណៈសម្បត្តិ|លក្ខណៈសម្បត្តិ}} ដែល​កំពុង​ប្រើប្រាស់​គំរូនេះ​។',
	'smw_attribute_header' => 'ទំព័រ​ដែល​កំពុង​ប្រើប្រាស់​លក្ខណៈសម្បត្តិ "$1"',
	'smw_attributearticlecount' => 'បង្ហាញ $1 {{PLURAL:$1|ទំព័រ|ទំព័រ}} ដែល​កំពុង​ប្រើប្រាស់​លក្ខណៈសម្បត្តិ​នេះ​។',
	'smw_subproperty_header' => 'លក្ខណៈសម្បត្តិ​រង',
	'smw_subpropertyarticlecount' => 'លក្ខណៈសម្បត្តិ​នេះមាន $1 {{PLURAL:$1|លក្ខណៈសម្បត្តិ​រង|លក្ខណៈសម្បត្តិ​រង}}​ ដូចតទៅ៖',
	'exportrdf' => 'នាំចេញ​ទំព័រ​ទៅ RDF',
	'uriresolver' => 'អ្នកដោះស្រាយ URI',
	'properties' => 'លក្ខណៈសម្បត្តិ',
	'smw_properties_docu' => 'លក្ខណៈសម្បត្តិ​ដូច​ខាងក្រោម​ត្រូវ​បាន​ប្រើប្រាស់​នៅ​ក្នុង​វិគី​។',
	'smw_property_template' => '$1 នៃ​គំរូ $2 ($3)',
	'smw_propertylackspage' => 'លក្ខណៈសម្បត្តិ​ទាំងអស់ គួរតែ​ត្រូវ​បាន​ពីពណ៌នា​ដោយ​ទំព័រ​មួយ​!',
	'smw_propertyhardlyused' => 'លក្ខណៈសម្បត្តិ ស្ទើរតែ​មិនត្រូវ​បាន​ប្រើប្រាស់​ជាមួយ​វិគី​!',
	'unusedproperties' => 'លក្ខណៈសម្បត្តិ​មិន​ប្រើប្រាស់',
	'smw_unusedproperty_template' => '$1 នៃ​គំរូ $2',
	'wantedproperties' => 'លក្ខណៈសម្បត្តិ​ដែល​ចង់បាន',
	'smw_wantedproperties_docu' => 'លក្ខណៈសម្បត្តិ​ដូចតទៅនេះ ត្រូវ​បាន​ប្រើប្រាស់​នោក្នុង​វិគី ប៉ុន្ដែ​នៅ​មិនទាំន់​មាន​ទំព័រ​ណាមួយ​សម្រាប់​ពិពណ៌នា​ពួកវា​ឡើយ​។',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|ប្រើប្រាស់|ប្រើប្រាស់}})',
	'smw_purge' => 'ធ្វើឱ្យស្រស់',
	'types' => 'ប្រភេទ',
	'semanticstatistics' => 'ស្ថិតិ​និឃណ្ដសាស្ត្រ',
	'smw_ask_sortby' => 'តម្រៀប​តាម​ជួរឈរ (តាមបំណង)',
	'smw_ask_ascorder' => 'លំដាប់ឡើង',
	'smw_ask_descorder' => 'លំដាប់ចុះ',
	'smw_ask_submit' => 'ស្វែងរកលទ្ធផល',
	'searchbyproperty' => 'ស្វែងរក​តាម​រយៈ​លក្ខណៈសម្បត្តិ',
	'smw_sbv_docu' => 'ស្វែងរក​គ្រប់​ទំព័រ​ទាំងអស់ ដែល​ត្រូវ​បាន​ផ្ដល់​លក្ខណៈសម្បត្តិ និង​តម្លៃ​។',
	'smw_sbv_novalue' => 'បញ្ចូល​តម្លៃ​ត្រឹមត្រូវ​សម្រាប់​លក្ខណៈសម្បត្តិ ឬ​ក៏ មើល​គ្រប់​លក្ខណៈសម្បត្តិ​ទាំងអស់​សម្រាប់ "$1"​។',
	'smw_sbv_displayresult' => 'បញ្ជី​មួយ​នៃ​ទំព័រ​ទាំងអស់ ដែល​មានន​លក្ខណៈសម្បត្តិ "$1" ជាមួយ​តម្លៃ "$2"',
	'smw_sbv_displayresultfuzzy' => 'បញ្ជី​មួយ​នៃ​ទំព័រ​ទាំងអស់ ដែល​មានន​លក្ខណៈសម្បត្តិ "$1" ជាមួយ​តម្លៃ "$2"​។
ដោយហេតុតែ មាន​លទ្ធផល​តិចតួច​ប៉ុណ្ណោះ ក៏ប្រហាក់ប្រហែល​ជាមួយ​តម្លៃ​ដែល​ត្រូវ​បាន​បង្ហាញ​ផងដែរ​។',
	'smw_sbv_property' => 'លក្ខណៈសម្បត្តិ៖',
	'smw_sbv_value' => 'តំលៃលេខ៖',
	'smw_sbv_submit' => 'ស្វែងរក​លទ្ធផល',
	'browse' => 'រាវរកវិគី',
	'smw_browselink' => 'រកមើល​លក្ខណៈសម្បត្តិ',
	'smw_browse_article' => 'សូម​បញ្ចូល​ឈ្មោះ​នៃ​ទំព័រ ដើម្បី​ចាប់ផ្ដើម​រុករក​ពី​។',
	'smw_browse_go' => 'ទៅ',
	'smw_browse_show_incoming' => 'បង្ហាញ​លក្ខណៈសម្បត្តិ ដែល​មាន​តំណភ្ជាប់​នៅទីនេះ​។',
	'smw_browse_hide_incoming' => 'លាក់​លក្ខណៈសម្បត្តិ ដែល​មាន​តំណភ្ជាប់​នៅទីនេះ​។',
	'smw_browse_no_outgoing' => 'ទំព័រ​នេះ​មិនមាន​លក្ខណៈសម្បត្តិ​ទេ​។',
	'smw_browse_no_incoming' => 'គ្មាន​លក្ខណៈសម្បត្តិ ដែល​ភ្ជាប់ទៅ​ទំព័រ​នេះ​ទេ​។',
	'smw_inverse_label_default' => '$1 នៃ',
	'pageproperty' => 'ស្វែងរក​លក្ខណៈសម្បត្តិ​ទំព័រ',
	'smw_pp_from' => 'ពីទំព័រ',
	'smw_pp_type' => 'លក្ខណៈសម្បត្តិ',
	'smw_pp_submit' => 'ស្វែងរកលទ្ធផល',
	'smw_result_prev' => 'មុន',
	'smw_result_next' => 'បន្ទាប់',
	'smw_result_results' => 'លទ្ធផល',
	'smw_result_noresults' => 'សូមអភ័យទោស! មិនមានលទ្ធផលទេ។',
	'smw_smwadmin_return' => 'ត្រឡប់​ទៅកាន់ $1',
	'smw_smwadmin_db' => 'ការដំឡើង និង​ធ្វើឱ្យប្រសើរ​នូវ​មូលដ្ឋានទិន្នន័យ',
	'smw_smwadmin_announce' => 'ប្រកាស​វិគី​របស់​អ្នក',
	'smw_smwadmin_datarefresh' => 'ជួសជុល និង​ធ្វើឱ្យ​ប្រសើរ​នូវ​ទិន្នន័យ',
	'smw_smwadmin_datarefreshbutton' => 'ចាប់ផ្ដើម​បន្ទាន់សម័យ​ទិន្នន័យ',
	'smw_smwadmin_datarefreshstop' => 'បញ្ឈប់​ការ​បន្ទាន់សម័យ​នេះ',
	'smw_smwadmin_datarefreshstopconfirm' => 'បាទ/ចាស, ខ្ញុំ​ប្រាកដ​ហើយ​។',
	'smw-createproperty-isproperty' => 'នេះ​គឺជា​លក្ខណៈសម្បត្តិមួយ​នៃ​គំរូ $1 ។',
	'smw-createproperty-allowedvals' => 'តម្លៃ​ចំនួន$1 ​សម្រាប់​លក្ខណៈសម្បត្តិ​នេះគឺ​៖',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'smw_finallistconjunct' => ', ಮತ್ತು',
	'smw_printername_template' => 'ಟೆಂಪ್ಲೇಟು',
	'smw_browse_go' => 'ಹೋಗು',
);

/** Korean (한국어)
 * @author Albamhandae
 * @author Kwj2772
 * @author 아라
 */
$messages['ko'] = array(
	'smw_viewasrdf' => 'RDF 피드',
	'smw_factbox_head' => '$1에 대한 사실',
	'smw_isspecprop' => '이 속성은 이 위키의 특별한 속성입니다.',
	'smw_baduri' => '죄송합니다, uri의 범위에서 “$1” 해당 장소에서 사용할 수 없다.',
	'smw_maxstring' => '문자열 표현 $1 이 너무 긴이 사이트에 대한.',
	'smw_infinite' => '"$1" 크기와 같은 숫자는 지원하지 않습니다.',
	'smw_nodatetime' => '의 날짜 “$1” 는 이해할 수 없다.',
	'smw_typearticlecount' => '이 유형을 사용하여 보여주 $1 의 등록 정보를합니다.',
	'smw_attributearticlecount' => '이 속성을 사용하여 보여주 $1 페이지입니다.',
	'smw_rss_description' => '$1 RSS 피드',
	'specialpages-group-smw_group' => 'Semantic MediaWiki',
	'exportrdf' => 'RDF로 문서 내보내기',
	'smw_qui_formt' => '형식:',
	'smw_qui_cancel' => '취소',
	'smw_pp_type' => '속성',
	'smw_unknowntype' => '이 속성의 형식이 잘못되었습니다',
);

/** Krio (Krio)
 * @author Jose77
 */
$messages['kri'] = array(
	'smw_browse_go' => 'Go to am',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'smw_browse_go' => 'Agto',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'smw-desc' => 'Määt Ding Wiki besser ze bruche - för Minsche un Maschiene. ([http://semantic-mediawiki.org/wiki/Help:User_manual Handbooch])',
	'smw_viewasrdf' => 'RDF Kannaal',
	'smw_finallistconjunct' => ', un',
	'smw_factbox_head' => 'Tatsaache övver $1',
	'smw_isspecprop' => 'Die Eijeschaff es en spezijelle Eijeschaff en hee dämm Wiki.',
	'smw_concept_description' => 'Beschrievong för et Kunzäp: „$1“',
	'smw_no_concept_namespace' => 'Kunzäpter kam_mer bloß em {{ns:concept}}-Appachtemang faßlääje.',
	'smw_multiple_concepts' => 'Op jeede {{ns:concept}}-Sigg kann bloß ei Kunzäp faßjelaat wääde.',
	'smw_concept_cache_miss' => 'Dat Kunzap „$1“ kann för der Momang noch nit jebruch wääde.
Dem Wiki sing Kumfijurazjuhn fordert, dat dat offline ußjeräshent weed.
Wann dat nit noh en jeweße Zick nit fun sellfs jedonn es, un hee di
Aanforderung dorschjeiht, dann froch Dinge Wiki-Köbes donoh, noh dämm Kunzäp.',
	'smw_noinvannot' => 'För Eijeschaffte met ömjedriehte Reschtung künne kei Wääte verjovve wääde.',
	'version-semantic' => 'Projrammzohsäz vum „Semantesch MediaWiki“',
	'smw_baduri' => 'URIs met dämm Opbou „$1“ sin nit zojelohße.',
	'smw_rss_link' => '<i lang="en">RSS</i>',
	'smw_csv_link' => '<i lang="en">CSV</i>',
	'smw_dsv_link' => '<i lang="en">DSV</i>-Dattei',
	'smw_json_link' => '<i lang="en">JSON</i>',
	'smw_rdf_link' => '<i lang="en">RDF</i>',
	'smw_printername_count' => 'Zälle, wat erus kütt',
	'smw_printername_csv' => 'Expoot em <i lang="en">CSV</i>-Fommaat',
	'smw_printername_dsv' => 'Äxpoot als en <i lang="en">DSV</i>-Dattei',
	'smw_printername_debug' => 'En dä Frooch noh Fählere söhke (joot för de Expächte)',
	'smw_printername_embedded' => 'Sigge-Enhallt enföhje',
	'smw_printername_json' => 'Expoot em <i lang="en">JSON</i>-Fommaat',
	'smw_printername_list' => 'Leß',
	'smw_printername_ol' => 'Opzälle',
	'smw_printername_ul' => 'Einzel met Einzelheite opföhre',
	'smw_printername_rss' => 'Expoot em <i lang="en">RSS</i>-Fommaat',
	'smw_printername_table' => 'Tabäll',
	'smw_printername_broadtable' => 'En breed Tabäll',
	'smw_printername_template' => 'Schabloon',
	'smw_printername_rdf' => 'Äxpoot als en <i lang="en">RDF</i>-Dattei',
	'smw-paramdesc-limit' => 'De hühßte Aanzahl vun Äjeebnesse för zeröck ze jävve',
	'smw-paramdesc-headers' => 'Donn der Name vun de Övveschrefte un Eijeschaffte aanzeije',
	'smw-paramdesc-mainlabel' => 'Wi dä <code>mainlabel</code> Parrameeter för inlain Affroore beschrevve weed',
	'smw-paramdesc-link' => 'Donn de Wääte als Lengks aanzeije',
	'smw-paramdesc-intro' => 'Wat för ene Täx aanjezeijsch wääde sull, für dämm, wat jefonge woodt',
	'smw-paramdesc-outro' => 'Wat för ene Täx aanjezeijsch wääde sull, noh dämm, wat jefonge woodt',
	'smw-paramdesc-default' => 'Wat för ene Täx aanjezeijsch wääde sull, wann nix jefonge woodt',
	'smw-paramdesc-sep' => 'Wat zwesche de Wääte schtonn sull',
	'smw-paramdesc-template' => 'Dä Name vun ene Schabloon, för de Ußjabe met aanzzeije',
	'smw-paramdesc-columns' => 'De Aanzahl Schpallde för aanzezije, wad eruß kütt — der Schtandatt wöhr $1',
	'smw-paramdesc-userparam' => 'Ene Wäät, dä aan jehde Schabloon wigger_jejovve weed, wann övverhoub en Schabloon jebruch weed',
	'smw-paramdesc-introtemplate' => 'Dä Name vun en Schabloon, di aanjezeijsch wääde sull, für dämm, wat jefonge woodt',
	'smw-paramdesc-outrotemplate' => 'Dä Name vun en Schabloon, di aanjezeijsch wääde sull, noh dämm, wat jefonge woodt',
	'smw-paramdesc-embedformat' => 'De <i lang="en">html</i>-Befähle för de Övverschreffte ze makeere',
	'smw-paramdesc-embedonly' => 'Kein Övverschreffte aanzeije',
	'smw-paramdesc-rsstitle' => 'Dä Täx met dämm dä Kannaal beschrevve wääde sull',
	'smw-paramdesc-rssdescription' => 'Dä Täx met dämm dä Kannaal beschrevve wääde sull',
	'smw-paramdesc-rdfsyntax' => 'De Zoot Opbou (Syntax) vun dä <i lang="en">RDF</i>-Dattei',
	'smw-paramdesc-csv-sep' => 'Dat Zeishe för Fälder ze tränne',
	'smw-paramdesc-dsv-separator' => 'Dat Zeishe för Fälder ze tränne',
	'smw-paramdesc-dsv-filename' => 'Dä Name för di <i lang="en">DSV</i>-Dattei',
	'smw-paramdesc-searchlabel' => 'Dä Täx för em Lengk för wat eruß kütt', # Fuzzy
	'smw_iq_disabled' => 'Semantesche Frore sem em Wiki em Momang afjeschaldt.',
	'smw_iq_moreresults' => '…&nbsp;mieh vun däm, wat jefonge woodt',
	'smw_parseerror' => 'Dä aanjejovve Wäät kunnte mer nit vershtonn.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => '„$1“ kam_mer en hee däm Wiki nit als ene Siggename bruche.',
	'smw_wrong_namespace' => 'Bloß Sigge uß däm Appachtemang „$1“ sin hee zohjelohße.',
	'smw_manytypes' => 'Di Eijeschaff es en mieh wi ein Zoot dren.',
	'smw_emptystring' => 'De jonn kei Reihe uß Boochstabe un Zeishe, woh nit ens ei dofun dren shteiht. Alsu nit leddesch lohße.',
	'smw_maxstring' => '„$1“ es zoh lang, en Boochshtabe ußjedröck.',
	'smw_notinenum' => '„$1“ es nit bei dä zohjeloße Wääte för di Eijeschaff, dat wöhre: $2',
	'smw_noboolean' => '„$1“ es keine vun dä Wääte för „wohr“ un „verkeeht“.',
	'smw_true_words' => 'wohr,wor,woo,woh,wo,w,j,jo,joh,true,t,yes,y',
	'smw_false_words' => 'verkiehrt,verkihrt,verkirt,verkeht,verkeet,verket,vokiehrt,vokihrt,vokirt,vokeht,vokeet,voket,ferkiehrt,ferkihrt,ferkirt,ferkeht,ferkeet,ferket,fokiehrt,fokihrt,fokirt,fokeht,fokeet,foket,fallsch,falsch,näh,nää,nä,false,f,no,n',
	'smw_nofloat' => '„$1“ es kei Zahl.',
	'smw_infinite' => 'Zahle esu jruuß udder esu lang wi „$1“ dom_mer hee nit ongershtöze.',
	'smw_unitnotallowed' => '„$1“ es nit als en jölteje Mohßeinheit för heh di Eijeschaff enjedraare.',
	'smw_novalues' => 'Et sinn_er kein Wääte aanjejovvwe.',
	'smw_nodatetime' => 'Dat Dattum „$1“ künne mer nit vershtonn.',
	'smw_toomanyclosing' => 'En dä Frooch es zoh öff „$1“ enthallde.',
	'smw_noclosingbrackets' => 'En <code><nowiki>[[</nowiki></code> en Dinge Frooch woh nit zohjemaat, un hät kei <code>]]</code> wat drop paßße deiht.',
	'smw_misplacedsymbol' => 'Dat Sümbohl „$1“ wohr aan ene Shtell, woh et nix nöz.',
	'smw_unexpectedpart' => 'Dä Aandeil „$1“ en dä Frooch kunnte mer nit vershtonn. Wat eruß kütt, künnt jet angersch sin, wi jedaach.',
	'smw_emptysubquery' => 'En Ongerfrooch hät kein reschtejje Bedengung.',
	'smw_misplacedsubquery' => 'En Ongerfrooch douch aan ene Shtäll op, woh kei Ongerfroore sin dörve.',
	'smw_valuesubquery' => 'En Ongerfrooch noh de Wääte fun dä Eijeschaff „$1“ künne mer nit.',
	'smw_badqueryatom' => 'Ene Aandeil „<nowiki>[[…]]</nowiki>“ en dä Anfrooch es nit ze vershtonn.',
	'smw_propvalueproblem' => 'Dä Eijeschaff „$1“ ier Wäät es nit ze vershtonn.',
	'smw_noqueryfeature' => 'Ene Deijl vun dä Aanfrooch iere Eijeschaffte sin hee en dämm Wiki nit
müjjelesch, un dä Aandeil ($1) es dröm us dä Frooch eruß jenumme woode.',
	'smw_noconjunctions' => 'Konjunxjohne (e „un“ en Aanfroore) sin hee en dämm Wiki nit müjjelesch, un dä Aandeil ($1) es dröm us dä Frooch eruß jenumme woode.',
	'smw_nodisjunctions' => 'Dißjunxjohne (e „of“ un „odder“ en Aanfroore) sin hee en dämm Wiki nit müjjelesch, un dä Aandeil ($1) es dröm us dä Frooch eruß jenumme woode.',
	'smw_querytoolarge' => 'De Bedengunge hee noh kunnte mer nit mieh beärbeide, weil dem Wiki sing Jrenze för der Ömfang udder de Aanzahl Verschachtelunge vun Datebangk_Froore övverschredde wohre: $1.',
	'smw_notemplategiven' => 'Jiv ene Wäät för dä Parrammeeter „Schabloon“ aan, domet di Aat Frooch jonn kann.',
	'smw_db_sparqlqueryproblem' => 'De Antwood op di Aanfrooch kunnt nit vun dä Daatebangk för <i lang="en">SPARQL</i> jehollt wääde.
Heh dä Fähler künnt wider vörbei jonn, udder ene Fähler em Programm för de Daatebangk opzeije.',
	'smw_type_header' => 'Eijeschaffte vun dä Aat „$1“',
	'smw_typearticlecount' => 'Mer zeije {{PLURAL:$1|Ein Eijeschaff|$1 Eijeschaffte|kei Eijeschaff}} met dämm Datentüp aan:',
	'smw_attribute_header' => 'Sigge met dä Eijeschaff „$1“',
	'smw_attributearticlecount' => '{{PLURAL:$1|Hee kütt ein Sigg|Hee kumme $1 Sigge|Et jitt kei Sigge}} met dä Eijeschaff dren{{PLURAL:$1|:|:|.}}',
	'smw_subproperty_header' => 'Unger-Eijeschaffte',
	'smw_subpropertyarticlecount' => 'Di Eijeschaff hät {{PLURAL:$1|ein Onger-Eijeschaff:|$1 Onger-Eijeschaffte:|kein Onger-Eijeschaff.}}',
	'smw_concept_header' => 'Sigge vun däm Kumzäp „$1“',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Ein Sigg jehööt|$1 Sigge jehüüre|Et jehüüere kein Sigge}} zoh dämm Kumzäp{{PLURAL:$1|:|:|.}}',
	'smw_rss_description' => '<i lang="en">RSS</i> Kanaal $1',
	'specialpages-group-smw_group' => 'Semantesch MediaWiki',
	'exportrdf' => 'Sigge em Fommaat RDF expoteere',
	'smw_exportrdf_docu' => 'Hee di Sigg määd et müjjelesch, Daate vun en Sigg em <i lang="en">RDF</i>-Fommaat ze krijje. Öm Sigge ze Expoteere, doon dänne ier Tittele, jeeder_ein en en Reih fö sesch, onge en dat Täx-Feld erin schriive.',
	'smw_exportrdf_recursive' => 'Donn all de Sigge expotteere, di domet zosamme hange, un di domet och, un esu wigger. Opjepaß, dat künnt reschtesch vill wääde!',
	'smw_exportrdf_backlinks' => 'Donn och all de Sigge expoteere, di op expoteete Sigge verwiese donn, un maach en <i lang="en">RDF</i> Dattei, woh me dren bläddere udder mem Brauser draan jonn kann.',
	'smw_exportrdf_lastdate' => 'Donn kein Sigge expoteere, di noh däm aanjejovve Dattum un dä aanjejovve Uhrzick nimmieh verändert woodte.',
	'smw_exportrdf_submit' => 'Loß Jonn!',
	'uriresolver' => 'Oplööser för <i lang="en">URIs</i>',
	'properties' => 'Eijeschaffte',
	'smw_properties_docu' => 'Hee di Eijeschaffte wäde em Wiki jebruch:',
	'smw_property_template' => '$1 fun dä Zoot $2 ({{PLURAL:$3|ei|$3|kei}} mol)',
	'smw_propertylackspage' => 'Alle Eijeschaffte sullte op en Sigg beschrevve sin!',
	'smw_propertylackstype' => 'För die Eijeschaff es bes jetz kei Date-Aat aanjejovve, mer nämme för der Momang ens „$1“.',
	'smw_propertyhardlyused' => 'Die Eijeschaff weed em Wiki koum jebruch!',
	'unusedproperties' => 'Eijeschaffte, die nit jebruch wääde',
	'smw_unusedproperties_docu' => 'Hee die Eijeschaffte jidd_et un han Sigge, ävver de Eijeschaffte sellver wääde em Momang nörjenswoh jebruch.',
	'smw_unusedproperty_template' => '$1 vun de Aat $2',
	'wantedproperties' => 'Nit aanjelaate Eijeschaffte',
	'smw_wantedproperties_docu' => 'De Eijeschaffte hee noh wäde em Wiki jebruch, ävver se han noch kei Sigg, die se beschrief, un äkliere deiht.',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|eimol|$2 mol|nit}} jebruch)',
	'smw_purge' => 'Nöü Aanzeije',
	'types' => 'Date-Tüpe',
	'smw_types_docu' => 'Hee kütt en Leß met alle Datte-Tüpe, die en Eijeschaff hann künnt.
Jede Tüp hät en eije Sigg, woh mer zosäzlesch Enfommazjuhne enndraare kann.', # Fuzzy
	'semanticstatistics' => 'Shtatistik övver de semantesche Date',
	'smw_semstats_text' => "Dat Wiki hät {{PLURAL:$1|'''eine''' Wäät|'''$1''' Wääte|'''nit eine''' Wäät}} för ensjesamp '''{{PLURAL:$2|ein|$2|keine}}''' ongerscheedlijje [[Special:Properties|{{PLURAL:$2|Eijeschaff|Eijeschaffte|Eijeschaff}}]].
{{PLURAL:$3|'''Ein''' Eijeschaff hät|'''$3''' Eijeschaffte han|'''Kein''' Eijeschaff hät}} en eije Sigg, un en Zoot (dä Datetyp) es för '''{{PLURAL:$4|eine|$4|keine}}'''  dovun aanjejovve. Et künne och [[Special:UnusedProperties|{{lcfirst:{{#special:UnusedProperties}}}}]] dronger sinn. Eijeschaffte ohne eije Sigg sin op dä Sigg met de [[Special:WantedProperties|{{lcfirst:{{#special:WantedProperties}}}}]] opjeleß.",
	'smw_uri_doc' => 'Dä <i lang="en">URI resolver</i> hät dä Vörschlaach <<i lang="en">a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a></i> opjenumme
(-: un sorresch esu doför, dat uß Minsche kei Websigge wääde :-)',
	'ask' => 'Semantesch Söke',
	'smw_ask_sortby' => 'Noh de Spallde zotteere (moß ävver nit)',
	'smw_ask_ascorder' => 'Nomaal eröm zotteere',
	'smw_ask_descorder' => 'Röckwääts zotteere',
	'smw_ask_submit' => 'Lohß Jonn!',
	'smw_ask_editquery' => '[Opdraach ändere]',
	'smw_add_sortcondition' => '[Zoteere dobeidonn]',
	'smw_ask_hidequery' => 'Opdrach nit aanzeije',
	'smw_ask_help' => 'Hölp',
	'smw_ask_queryhead' => 'Froore',
	'smw_ask_printhead' => 'Zosäzlijje Ußdröcker för aanzezeije',
	'smw_ask_printdesc' => '(Donn jeede Eijeschaff op ein Reih för sesch enjävve)',
	'smw_ask_format_as' => 'Fommatteere als:',
	'smw_ask_defaultformat' => 'Shtandadt-Fommaat',
	'smw_ask_otheroptions' => 'Ander Ußwahle',
	'smw_ask_show_embed' => 'Donn dä Wiki_Kood zom ennfööje aanzeije',
	'smw_ask_hide_embed' => 'Donn dä Wiki_Kood zom Ennfööje vershteishe',
	'smw_ask_embed_instr' => 'Öm di Frooch en en Sigg em Wiki enzeboue, donn dä Wiki_Koode hee dronger en di Sigg enfööje.',
	'searchbyproperty' => 'Övver de Eijeschaffte söke',
	'smw_sbv_docu' => 'Donn noh all dä Sigge söhke, die beshtemmpte Eijeschaff han, un medd_ennem beshtemmpte Wäät för se.',
	'smw_sbv_novalue' => 'Donn ene jöltijje Wäät för di Eijeschaff aanjevve, udder donn Der all de müjjelesche Wääte för „$1“ aanlooere.',
	'smw_sbv_displayresult' => 'Leß met alle Sigge met dä Eijeschaff „$1“, die do dä Wäät „$2“ hät.',
	'smw_sbv_displayresultfuzzy' => 'Leß met alle Sigge met dä Eijeschaff „$1“, die do dä Wäät „$2“ hät.<br />
(Weil nur winnisch dovun do sin, dom_mer de ähnlesche Wääte metzeije)',
	'smw_sbv_property' => 'Eijeschaff:',
	'smw_sbv_value' => 'Wäät:',
	'smw_sbv_submit' => 'Lohß Jonn!',
	'browse' => 'Em Wiki bläddere',
	'smw_browselink' => 'Eijeschaffte aanzeije',
	'smw_browse_article' => 'Beß esu joot, un jif dä Tittel vun dä Sigg aan, wo De met däm Bläddere aanfange wells.',
	'smw_browse_go' => 'Lohß Jonn!',
	'smw_browse_more' => '&nbsp;…',
	'smw_browse_show_incoming' => 'donn de Eijeschaffte aanzeije, di ene Lengk noh hee han',
	'smw_browse_hide_incoming' => 'donn de Eijeschaffte vershteishe, di ene Lengk noh hee han',
	'smw_browse_no_outgoing' => 'Die Sigg hee hät kei Eijeschaffte.',
	'smw_browse_no_incoming' => 'Mer han kein Eijeschaffte em Wiki, di ene Lengk noh heh han.',
	'smw_inverse_label_default' => '$1 vun',
	'smw_inverse_label_property' => 'Dä Name för di Eijeschaff, wann dä ier Reschtung ömjedrieht weed',
	'pageproperty' => 'Söke noh Eijeschaffte vun Sigge',
	'smw_pp_docu' => 'Söhk noh all dä Wääte, di en beshtemmpte Eijeschaff en dä aanjejovve Sigg hät. Donn sowohl en Sigg aanjevve als och en Eijeschaff.',
	'smw_pp_from' => 'Vun Sigg',
	'smw_pp_type' => 'Eijeschaff',
	'smw_pp_submit' => 'Lohß Jonn!',
	'smw_result_prev' => 'Vörijje',
	'smw_result_next' => 'Wigger',
	'smw_result_results' => 'Erus jekumme',
	'smw_result_noresults' => 'Nix jefonge.',
	'smwadmin' => 'Verwalldung fun <i lang="en">Semantic MediaWiki</i>',
	'smw_smwadmin_setupsuccess' => 'Dä Shpeisherplaz es opjesaz för <i lang="en">Semantic MediaWiki</i>.',
	'smw_smwadmin_return' => 'Jangk retuur noh $1',
	'smw_smwadmin_updatestarted' => 'Ene Projrammlouf för de semantesche Date neu opzeboue es em Jang. All de jeshpeisherte Date wäde neu zosamme jebout un woh nüdesch repareet. Mer kann bei däm Louf hee op dä Söndersigg metloore.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Et es ald e Projramm för dat op der neuste Shtand ze bränge aam Loufe.
Mer donn jetz nit noch ein aanshtüße!', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Alle Projramme för et op der neuste Shtand Bränge, sin jetz aanjehallde woode.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Öm dat Projramm anzehallde, wat ald am Loufe es, moß De dat Höcksche en dat Käßje maache, öm ze zeije, dat De Der janz sesher bes.', # Fuzzy
	'smw_smwadmin_docu' => 'Hee di Söndersigg hellef beim Enshtallerere un beim op der neue Shtand bränge vum <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>. Opjepaß: Donn Ding Date seschere, ih dat De di Funkßjohne aanschmiiße deihß!',
	'smw_smwadmin_db' => 'Datebangk inshtalleere un op der neuste Shatnd bränge',
	'smw_smwadmin_dbdocu' => 'Semantesch MediaWiki hät bruch eije zosätzlejje Plaz en de Datebangk vum MediaWiki, öm sing semantesche Date ongerzebrenge. De Funkßjuhne hee dronger sorje doför, dat de Datebangk em Wiki öhndlesch för Semantesch MediaWiki opjesaz es. Wat hee verändert weet, dathät keine Enfloß op dä Rääß vun dä Datebangk vum MediaWiki, un mer kann et och eifach widder retuur maache, wann mer well. Di Funkßjuhn zom Opseze kam_mer esu öff loufe lohße, wi mer well, dat schaadt nix, ävver et es bloß eijmohl nüdesch bemm Enreschte, udder bem Ömshteije op en neuere Projrammversion.',
	'smw_smwadmin_permissionswarn' => 'Wann de Aufjab met enem Fähler em <i lang="en">SQL</i> donävve jeiht, dann künnd et sin, dat dä Name för op de Datebangk zohzejriife en de <code>LocalSettings.php</code> för Ding Wiki nit jenooch Rääschte en dä Datebangk hät. Entweder jiß De dämm dat Rääsch, Tabälle aanzelääje udder fott ze maache, udder donn för der Momang Dinge <i lang="en">English text sample</i> udder Datebank-Köbes en dä <code>tings.php </code> enndraare, udder nemm dat Waadungsprojramm <code>SMW_setup.php</code> wat sesch op de Aanjabe en <code>AdminSettings.php</code> betrecke kann.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Tabelle aanlääje udder op der neuste Shatnd bränge',
	'smw_smwadmin_announce' => 'Donn Ding Wiki annongßeere un bikannt maache',
	'smw_smwadmin_announcedocu' => 'Semantesch MediaWiki hät en Websigg för neu Semantsche MediaWiki ßaits aanzeköndijje. Doh weed en Leß met de öffentlesche Websaits jehallde, en de Houpsaach, öm dämm <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantesch MediaWiki Projäk</a> zoh enem Övverbleck ze verhellve, wi Semantesch MediaWiki esu enjesaz weed. Op dä Houpäjtsch fun dämm Projäk fengks De <a href="http://semantic-mediawiki.org/wiki/Registry">mieh övver dä Deens</a>.',
	'smw_smwadmin_announcebutton' => 'Met dämm Knopp hee deihs De Dingem Wiki sing <i lang="en">URL</i> aan dä Deens schecke. Dä deiht bloß öffentlesch oproofbaare Wikis opnämme, un bloß öffentlesch oproofbaare Enfomazjuhne övvernämme.',
	'smw_smwadmin_datarefresh' => 'Date repareere un op der neuste Shtand bränge',
	'smw_smwadmin_datarefreshdocu' => 'Et es müjjelesch, all Date vun Semantesch MediaWiki uß dä nommaale Date em Wiki widder neu zesamme ze krijje. Dat kann joot sin, öm kapodde Date ze repareere, udder de Date op der aktoälle Shtand ze bränge, nohdämm sesh jet draan jeändert hät, dorjen Änderung aan de Projramme. De Aanpassung weed Sigg för Sigg jedonn un weed dröm nit paaftisch fäädesch weede. Heenoh kanns De sin, ov en Aanpassung em Jang es, un Do kanns ein aanfange udder aanhallde, ußer wann ene Wiki_Köbes di Müjjeleschkeit ußjeschalldt hät.',
	'smw_smwadmin_datarefreshprogress' => '<strong>En XXXXXXX es ald ungerwähß.</strong> Es es nomaal för ene XXXXXXXXX dat dat langsam föran jeiht, weil dobei de Date nur en klein Häppsche jeändert wääde, un nur dann, wann eine dat wiki bruch. Öm flöcker fäädesch ze wäde, kanns de dat Waadungs-Projramm <code>runJobs.php</code> vun MediaWiki aanschmiiße. Nemm dä Parrameeter <code>--maxjobs 1000</code> öm dä XXXXXXXXXX en jedem Rötsch faß_ze_lääje. Mer sen onjefähr esu wick:',
	'smw_smwadmin_datarefreshbutton' => 'Aanfange met de Date op der neue Shtand ze brenge',
	'smw_smwadmin_datarefreshstop' => 'Donn dat op der neue Shtand brenge ophüüre',
	'smw_smwadmin_datarefreshstopconfirm' => 'Joh, esch ben mer sescher, esch well dat han.',
	'smw_smwadmin_support' => 'Hölp krijje',
	'smw_smwadmin_supportdocu' => 'Bei Probleme kriss De velleich Hölp övver en Aanzahl vun Müjjeleschkeite:',
	'smw_smwadmin_installfile' => 'Wann De Schwiireschkeite met Dinge Enshtallzjuhn häs, dann donn met de Reeschlinnije en dä Dattei <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL</a> anfange, donoh ze söke, wat De donn kanns.',
	'smw_smwadmin_smwhomepage' => 'De kumplätte Dokku för et <i lang="en">Semantic Mediawiki</i> es op <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b> ze fenge.',
	'smw_smwadmin_mediazilla' => 'Fähler kanns De övver <a href="https://bugzilla.wikimedia.org/" lang="en">Bugzilla</a> melde.',
	'smw_smwadmin_questions' => 'Wann De noch Froore häß odder Vörschlääsch maache odder klaafe wells, jangk op et <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user"><i lang="en">Semantic MediaWiki</i> Metmaacher Forum</a> un donn doh metschwaade.',
	'smw_adminlinks_datastructure' => 'De Daateshtruktur',
	'smw_adminlinks_displayingdata' => 'Daate aanzeije',
	'smw_adminlinks_inlinequerieshelp' => 'Hölp övver de em Wiki sing Sigge enjeboute Froore',
	'smw-createproperty-isproperty' => 'Dat ess_en Eijeschaff vun dä Zoot $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Dä einzijje müjjelesche Wäät för di Eijeschaff es:|De müjjelesche Wääte för di Eijeschaff sin:|Mer han kein müjjelesche Wääte för di Eijeschaff.}}',
	'smw_unknowntype' => 'De Zoot „$1“ för de Eijeschaff dom_mer nit ongershtöze.', # Fuzzy
);

/** Kurdish (Latin script) (Kurdî (latînî)‎)
 * @author George Animal
 */
$messages['ku-latn'] = array(
	'smw_finallistconjunct' => ', û',
	'smw_printername_list' => 'Lîste',
	'smw_printername_category' => 'Kategorî',
	'smw_true_words' => 'rast, r, erê, e',
	'smw_false_words' => 'nerast, n, na, n',
	'smw_qui_dcategory' => 'Kategorî:',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'smw-desc' => "Är Wiki méi accessibel machen - fir Maschinnen ''a'' Menschen ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])",
	'smw_viewasrdf' => 'RDF-Feed',
	'smw_finallistconjunct' => ', an',
	'smw_factbox_head' => 'Fakten iwwer $1',
	'smw_isspecprop' => 'Dëse Eegeschaft ass eng Spezial-Eegschaft an dëser Wiki.',
	'smw_concept_description' => 'Beschreiwung vum Konzept "$1"',
	'smw_multiple_concepts' => 'Op jiddwer Konzeptsäit ka just eng Definitioun vun engem Konzept stoen.',
	'version-semantic' => 'Softwareerweiderungen (Semantic MediaWiki)',
	'smw_baduri' => 'URIë vun der Form "$1" sinn net erlaabt.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Resultater zielen',
	'smw_printername_csv' => 'Export als CSV',
	'smw_printername_dsv' => 'DSV-Export',
	'smw_printername_debug' => 'Debug-Ufro (fir Experten)',
	'smw_printername_embedded' => 'Säiteninhalter abannen',
	'smw_printername_json' => 'Export als JSON',
	'smw_printername_list' => 'Lëscht',
	'smw_printername_ol' => 'Opzielung',
	'smw_printername_ul' => 'Opzielung',
	'smw_printername_rss' => 'Export als RSS',
	'smw_printername_table' => 'Tabell',
	'smw_printername_broadtable' => 'Breed Tabell',
	'smw_printername_template' => 'Schabloun',
	'smw_printername_rdf' => 'RDF-Export',
	'smw_printername_category' => 'Kategorie',
	'validator-type-class-SMWParamSource' => 'Text',
	'smw-paramdesc-limit' => "D'maximal Zuel vu Resultater déi gewise gëtt",
	'smw-paramdesc-mainlabel' => "D'Etiquette déi der Haaptsäit den Numm gëtt",
	'smw-paramdesc-link' => "D'Werter als Linke weisen",
	'smw-paramdesc-intro' => 'Den Text dee virun de Resultater vun der Ufro gewise gëtt, wann et der gëtt',
	'smw-paramdesc-outro' => 'Den Text deen no de Resultater vun der Ufro gewise gëtt, wann et der gëtt',
	'smw-paramdesc-default' => 'Den Text den ugewise gëtt wann et keng Resultater beim Siche gëtt',
	'smw-paramdesc-sep' => "D'Trennzeeche fir Wäerter",
	'smw-paramdesc-template' => "Den Numm vun enger Schabloun mat där d'Drockversioune gewise ginn",
	'smw-paramdesc-columns' => "D?zuel vu Colonnen an deenen d'Resultater vun dr Sich gewise ginn (Standard ass $1)",
	'smw-paramdesc-introtemplate' => 'Den Numm vun enger Schabloun déi virun de Resultater vun der Ufro gewise gëtt, wann et der gëtt',
	'smw-paramdesc-outrotemplate' => 'Den Numm vun enger Schabloun déi no de Resultater vun der Ufro gewise gëtt, wann et der gëtt',
	'smw-paramdesc-embedformat' => "Den HTML-Tag dee benotzt gëtt fir d'Iwwerschrëften ze definéieren",
	'smw-paramdesc-embedonly' => 'Keng Iwwerschrëfte weisen',
	'smw-paramdesc-rsstitle' => 'Den Text deen als Iwwerschrëft vun der Rubrik benotzt gëtt',
	'smw-paramdesc-rssdescription' => 'Den Text deen als Beschreiwung vum Feed benotzt gëtt',
	'smw-paramdesc-rdfsyntax' => 'RDF-Syntax déi benotzt gi muss',
	'smw-paramdesc-dsv-filename' => 'Den Numm fir den DSV-Fichier',
	'smw-paramdesc-searchlabel' => 'Den Text fir mam Siche virunzefueren',
	'smw_iq_moreresults' => '… weider Resultater',
	'smw_parseerror' => 'De Wäert deen Dir aginn hutt gouf net verstan.',
	'smw_notitle' => '"$1" kann net als Numm vun enger Säit op dëser Wiki benotzt ginn.',
	'smw_wrong_namespace' => 'Nëmme Säiten aus dem Nummraum "$1" sinn hei erlaabt.',
	'smw_emptystring' => 'Eidel Zeeche ginn net akzeptéiert.',
	'smw_maxstring' => "D'Zeecheketten $1 ass ze laang.",
	'smw_notinenum' => '"$1" ass net an der Lëscht vun de méigleche Wäerter ($2) fir dës Eegeschaft.',
	'smw_true_words' => 'wouer,w,jo,j',
	'smw_false_words' => 'falsch,f,neen,n',
	'smw_nofloat' => '"$1" ass keng Zuel.',
	'smw_infinite' => 'Zuelen esou grouss wéi "$1" ginn net ënnerstëtzt.',
	'smw_novalues' => 'Keng Wäerter spezifizéiert.',
	'smw_nodatetime' => 'Den Datum "$1" gouf net verstan.',
	'smw_noclosingbrackets' => 'Eng oder méi "<nowiki>[[</nowiki>" an Ärer Ufro war net zou duerch eng entspriechent "]]".',
	'smw_misplacedsymbol' => 'D\'Symbol "$1" gouf op ener Plaz benotzt wou et net nëtzlech ass.',
	'smw_badqueryatom' => 'Een Deel "<nowiki>[[…]]</nowiki>" vun der Ufro gouf net verstan.',
	'smw_propvalueproblem' => 'De Wäert vun der Eegeschaft "$1" gouf net verstan.',
	'smw_type_header' => 'Eegeschafte vum Typ "$1"',
	'smw_attribute_header' => 'Säiten déi d\'Eegeschaft "$1" benotzen',
	'smw_concept_header' => 'Säite vum Konzept "$1"',
	'smw_conceptarticlecount' => 'Déi $1 {{PLURAL:$1|Säit|Säite}} weisen déi zu deem Konzept gehéieren.',
	'exportrdf' => 'Säiten als RDF exportéieren',
	'smw_exportrdf_backlinks' => 'Och all Säiten déi op déi exportéiert Säite referéieren exportéieren.
Et gët en RDF ugeluecht dee liicht duerchsicht ka ginn.',
	'smw_exportrdf_lastdate' => 'Keng Säiten exportéieren déi zënter dem Zäitpunkt deen uginn ass net geännert goufen.',
	'smw_exportrdf_submit' => 'Exportéieren',
	'properties' => 'Eegeschaften',
	'smw_properties_docu' => 'Dës Eegeschafte ginn op dëser Wiki benotzt.',
	'smw_property_template' => '$1 vum Typ $2 ($3)', # Fuzzy
	'smw_propertylackspage' => 'All Eegeschafte sollen op enger Säit beschriwwe sinn!',
	'smw_propertyhardlyused' => 'Dës Eegeschaft gëtt an dëser Wiki kaum benotzt!',
	'unusedproperties' => 'Onbenotzten Eegeschaften',
	'smw_unusedproperties_docu' => 'Dës Eegeschafte gëtt et och wa keng aner Säit se benotzt.',
	'smw_unusedproperty_template' => '$1 vum Typ $2',
	'wantedproperties' => 'Gewënschten Eegeschaften',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|mol benotzt|mol benotzt}})',
	'smw_purge' => 'Aktualiséieren',
	'types' => 'Typen',
	'semanticstatistics' => 'Semantesch Statistiken',
	'ask' => 'Semantesch sichen',
	'smw_ask_sortby' => 'No der Kolonn zortéieren (Optioun)',
	'smw_ask_ascorder' => 'Vu kleng op grouss (croissant)',
	'smw_ask_descorder' => 'vu grouss op kleng (décroissant)',
	'smw_ask_submit' => 'Resultater sichen',
	'smw_ask_editquery' => '[Ufro änneren]',
	'smw_add_sortcondition' => "[Konditioun fir d'Zortéieren derbäisetzen]",
	'smw_ask_hidequery' => 'Ufro verstoppen',
	'smw_ask_help' => 'Hëllef ufroen',
	'smw_ask_queryhead' => 'Ufro',
	'smw_ask_printhead' => 'Zousätzlech Date weisen',
	'smw_ask_printdesc' => '(eng Eegeschaft pro Linn derbäisetzen)',
	'smw_ask_format_as' => 'Formatéieren als:',
	'smw_ask_defaultformat' => 'Standard',
	'smw_ask_otheroptions' => 'Aner Optiounen',
	'smw_ask_show_embed' => 'Agebonnene Code weisen',
	'smw_ask_hide_embed' => 'Agebonnene Code verstoppen',
	'smw-ask-delete' => '[Läschen]',
	'smw_qc_addmainlabel' => 'Haaptetiquette derbäisetzen',
	'smw_qc_show_addnal_opts' => 'Méi Optioune weisen',
	'smw_qc_hide_addnal_opts' => 'Manner Optioune weisen',
	'smw_qc_otheropt' => 'Aner Optiounen',
	'smw_qc_default' => 'Standard:',
	'smw_qc_formatopt' => 'Optioune fir de Format',
	'smw_qui_labl' => 'Etiquette:',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Limit:',
	'smw_qui_invalidformat' => 'Den erausgesichte Format "$1" gëtt et fir dës Wiki net',
	'smw_qui_nosort' => 'Net zortéieren',
	'smw_qui_randorder' => 'Zoufall',
	'smw_qui_delete' => 'Ewechhuelen',
	'smw_qui_options' => 'Optiounen',
	'smw_qui_addcategory' => 'Kategorie derbäisetzen',
	'smw_qui_ok' => 'OK',
	'smw_qui_cancel' => 'Ofbriechen',
	'smw_qui_category' => '<strong>Kategorie</strong>',
	'smw_qui_label' => 'Etiquette',
	'smw_qui_catopts' => 'Optioune vun der Kategorie',
	'smw_qui_mainlabopts' => "Optioune fir d'Resultat",
	'smw_qui_dlabel' => 'Etiquette:',
	'smw_qui_dcategory' => 'Kategorie:',
	'smw_qui_dcatyes' => "Den Text dee gewise gëtt wann d'Kategorie do ass:",
	'smw_qui_dcatno' => "Den Text dee gewise gëtt wann d'Kategorie net do ass:",
	'searchbyproperty' => 'No Eegeschafte sichen',
	'smw_sbv_docu' => 'Sichen no alle Säiten déi eng bestëmmten Eegeschaft mat engem bestëmmte Wäert hunn.',
	'smw_sbv_displayresult' => 'Eng Lëscht vun alle Säiten déi d\'Eegeschaft "$1" mam Wäert "$2" hunn',
	'smw_sbv_property' => 'Eegeschaft:',
	'smw_sbv_value' => 'Wäert:',
	'smw_sbv_submit' => 'Resultater sichen',
	'browse' => "Duerch d'Wiki goen",
	'smw_browse_go' => 'Lass',
	'smw_browse_show_incoming' => 'Eegeschafte weisen déi heihi linken',
	'smw_browse_hide_incoming' => 'Eegeschafte verstoppen déi hei hi linken',
	'smw_browse_no_outgoing' => 'Dës Säit huet keng Eegeschaften.',
	'smw_browse_no_incoming' => 'Et linke keng Eegeschaften op dës Säit.',
	'smw_inverse_label_default' => '$1 vu(n)',
	'pageproperty' => 'An den Eegeschafte vun der Säit sichen',
	'smw_pp_from' => 'Vun der Säit',
	'smw_pp_type' => 'Eegeschaft',
	'smw_pp_submit' => 'Resultater sichen',
	'smw_result_prev' => 'Vireg',
	'smw_result_next' => 'Nächst',
	'smw_result_results' => 'Resultater',
	'smw_result_noresults' => 'Pardon, et gouf näischt fonnt.',
	'smwadmin' => 'Admin-Fonctiounen fir Semantic MediaWiki',
	'smw_smwadmin_return' => 'Zréck op $1',
	'smw_smwadmin_updatenotstarted' => "Et ass schonn een Aktualiséiereungs-Prozess amgaang.
Et ka keen neien ugefaang ginn.

Zréck op d'Säit $1.",
	'smw_smwadmin_updatestopped' => "All Aktualisatiouns-Prozesser goufe gestoppt.

Zréck op d'Säit $1.",
	'smw_smwadmin_db' => 'Datebankinstallatioun and -aktualiséierung',
	'smw_smwadmin_dbbutton' => 'Tabellen initialiséieren oder aktualiséieren',
	'smw_smwadmin_announce' => 'Är wiki ukënnegen',
	'smw_smwadmin_datarefresh' => 'Donnéeë gi gefléckt an aktualiséiert',
	'smw_smwadmin_datarefreshbutton' => "Ufänken Daten z'aktualiséieren",
	'smw_smwadmin_datarefreshstop' => 'Dësn Update stoppen',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jo, ech si sécher.',
	'smw_smwadmin_support' => 'Ënnerstëtzung kréien',
	'smw_smwadmin_supportdocu' => 'Verschidde Quellen kéinten Iech bei Problemer hëllefen:',
	'smw_smwadmin_installfile' => 'Wann Dir Problemer bäi der Installatioun hutt, da kuckt d\'Directiven am <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL Fichier</a> no.',
	'smw_smwadmin_smwhomepage' => 'Déi komplett Benotzerdokumentatioun vu Semantic MediaWiki fannt Dir op b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Feeler kënnen op <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> gemellt ginn.',
	'smw_smwadmin_questions' => 'Wann dir nach Froen oder Propositiounen hutt, da bedeelegt Iech un der Diskussioun op dem <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki Benotzer-Forum</a>.',
	'smw_adminlinks_datastructure' => 'Datestruktur',
	'smw_adminlinks_displayingdata' => 'Donnéeë weisen',
	'smw_adminlinks_inlinequerieshelp' => 'Hëllef fir intern Ufroen',
	'smw-paramdesc-category-template' => "Eng Schabloun fir d'Objeten ze formatéieren",
	'smw-paramdesc-category-userparam' => 'E Parameter deen der Schabloun iwwergi gëtt',
	'smw-info-par-message' => 'Message fir ze weisen.',
	'smw-info-par-icon' => 'Symbol fir entweder "Info" oder "Warnung" ze weisen.',
	'smw-ui-tooltip-title-warning' => 'Feeler',
	'smw-ui-tooltip-title-parameter' => 'Parameter',
);

/** Lithuanian (lietuvių)
 * @author Vpovilaitis
 */
$messages['lt'] = array(
	'smw-desc' => "Padaryti Jūsų wiki labiau prieinamą - mašinoms ''ir'' žmonėms ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])",
	'smw_finallistconjunct' => ', ir',
	'smw_factbox_head' => 'Faktai apie $1',
	'smw_isspecprop' => 'Ši savybė yra speciali šioje wiki.',
	'smw_concept_description' => 'Sąvokos "$1" aprašymas',
	'smw_no_concept_namespace' => 'Sąvokos gali būti apibrėžtos tik Concept: vardų srities puslapiuose.',
	'smw_multiple_concepts' => 'Kiekviename sąvokos aprašymo puslapyje gali turėti tik vieną sąvokos apibrėžimą.',
	'smw_concept_cache_miss' => 'Sąvoka "$1" negali būti naudojamas šiuo metu, nes wiki konfigūracija reikalauja ją apskaičiuoti off-line. 
Jei problema neišnyksta po tam tikro laiko, kreipkitės į svetainės administratorių, kad šią sąvoką padarytų prieinamą.',
	'smw_noinvannot' => 'Reikšmės negali būti priskiriamos atvirkštinei savybei.',
	'version-semantic' => 'Semantiniai praplėtimai',
	'smw_baduri' => 'URI formoje "$1" yra draudžiami.',
	'smw_printername_count' => 'Paskaičiuoti rezultatus',
	'smw_printername_csv' => 'CSV eksportavimas',
	'smw_printername_debug' => 'Derinti užklausą (ekspertams)',
	'smw_printername_embedded' => 'Įstatyti puslapio turinį',
	'smw_printername_json' => 'JSON eksportas',
	'smw_printername_list' => 'Sąrašas',
	'smw_printername_ol' => 'Išvardinimas',
	'smw_printername_ul' => 'Sudarymas iš elementų',
	'smw_printername_rss' => 'RSS eksportas',
	'smw_printername_table' => 'Lentelė',
	'smw_printername_broadtable' => 'Plati lentelė',
	'smw_printername_template' => 'Šablonas',
	'smw-paramdesc-limit' => 'Maksimalus grąžinamas rezultatų skaičius',
	'smw-paramdesc-headers' => 'Rodyti antraštes/savybių pavadinimus',
	'smw-paramdesc-mainlabel' => 'Etiketėje pateikti pagrindinio puslapio pavadinimą',
	'smw-paramdesc-link' => 'Rodyti reikšmes kaip nuorodas',
	'smw-paramdesc-intro' => 'Tekstas būtų rodomas prieš užklausos rezultatus, jei yra kokių nors rezultatų',
	'smw-paramdesc-outro' => 'Tekstas būtų rodomas po užklausos rezultatų, jei yra kokių nors rezultatų',
	'smw-paramdesc-default' => 'Tekstas būtų rodomas, jei nėra užklausos rezultatų',
	'smw-paramdesc-sep' => 'Reikšmių skirtukas',
	'smw-paramdesc-template' => 'Šablono, su kuriuo būtų galima parodyti išvedimą, pavadinimas',
	'smw-paramdesc-columns' => 'Stulpelių skaičius, kuriuose bus rodomas rezultatas (pagal nutylėjimą yra $1)',
	'smw-paramdesc-userparam' => 'Reikšmė patenka į kiekvieną šabloną iškvietimą, jei šablonas yra naudojamas',
	'smw-paramdesc-introtemplate' => 'Šablono pavadinimas, kuris būtų rodomas prieš užklausos rezultatus, jei yra kokių nors rezultatų',
	'smw-paramdesc-outrotemplate' => 'Šablono pavadinimas, kuris būtų rodomas po užklausos rezultatų, jei yra kokių nors rezultatų',
	'smw-paramdesc-embedformat' => 'HTML žymė naudojama apibrėžti antraštes',
	'smw-paramdesc-embedonly' => 'Nerodyti antraščių',
	'smw-paramdesc-searchlabel' => 'Nuorodos į rezultatus tekstas', # Fuzzy
	'smw_iq_disabled' => 'Semantinės užklausos yra išjungtos šioje wiki.',
	'smw_iq_moreresults' => '... tolesni rezultatai',
	'smw_parseerror' => 'Nurodyta reikšmė yra nesuprantama.',
	'smw_notitle' => '"$1" negali būti naudojamas kaip puslapio pavadinimas šiame wiki.',
	'smw_wrong_namespace' => 'Čia leidžiami tik puslapiai, priklausantys vardų sričiai "$1".',
	'smw_manytypes' => 'Savybei apibrėžtas daugiau negu vienas tipas.',
	'smw_emptystring' => 'Tuščios eilutės yra nepriimtinos.',
	'smw_maxstring' => 'Simbolių eilutė $1 yra per ilga.',
	'smw_notinenum' => '"$1" nėra šios savybės galimų reikšmių sąraše ($2).',
	'smw_noboolean' => '"$1" nėra pripažįstama kaip loginė (true / false) vertė.',
	'smw_true_words' => 'tiesa,t,taip,yes,y',
	'smw_false_words' => 'klaida,k,ne,n,false,f,no',
	'smw_nofloat' => '"$1" nėra skaičius.',
	'smw_infinite' => 'Tokie dideli skaičiai, kaip "$1" yra nepalaikomi.',
	'smw_novalues' => 'Nenurodyta reikšmė.',
	'smw_nodatetime' => 'Data "$1" buvo neatpažinta.',
	'smw_toomanyclosing' => 'Atrodo, kad yra per daug elementų "$1" užklausoje.',
	'smw_noclosingbrackets' => 'Kažkuris panaudojimas "<nowiki>[[</nowiki>" jūsų užklausoje nebuvo uždaryta atitikimo "]]".',
	'smw_misplacedsymbol' => 'Simbolis "$1" buvo panaudotas toje vietoje, kurioje jis nėra naudojamas.',
	'smw_unexpectedpart' => 'Užklausos dalis "$1" nebuvo suprasta. 
Rezultatas gali būti ne tas, kurio tikėtasi.',
	'smw_emptysubquery' => 'Kai kurios užklausos dalys turi blogas sąlygas.',
	'smw-createproperty-isproperty' => 'Tai yra „$1“ tipo savybė.',
	'smw-createproperty-allowedvals' => 'Šios savybės leidžiamos reikšmės yra:', # Fuzzy
	'smw_unknowntype' => 'Savybei nustatytas nepalaikomas tipas "$1".', # Fuzzy
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 * @author Rancher
 */
$messages['mk'] = array(
	'smw-desc' => "Го прави вашето вики подостапно - за машини ''и'' луѓе ([http://semantic-mediawiki.org/wiki/Help:User_manual?uselang=mk документација])",
	'smw_viewasrdf' => 'RDF канал',
	'smw_finallistconjunct' => ' и',
	'smw_factbox_head' => 'Факти за $1',
	'smw_isspecprop' => 'Ова својство е специјално својство во ова вики.',
	'smw_concept_description' => 'Опис на концептот „$1“',
	'smw_no_concept_namespace' => 'Концептите можат да се определуваат само на страници во именскиот простор „Концепт:“ („Concept:“).',
	'smw_multiple_concepts' => 'Секоја концептна страница може да има само по една одредба на концепт.',
	'smw_concept_cache_miss' => 'Концептот „$1“ во моментов не може да се користи, бидејќи местењата на викито бараат тој да се пресмета вон интернет.
Ако проблемот не исчезне по извесно време, побарајте од вашиот администратор да го овозможи тој концепт.',
	'smw_noinvannot' => 'На обратните својства не можат да им се назначуваат вредности.',
	'version-semantic' => 'Семантички додатоци',
	'smw_baduri' => 'URI-ја од обликот „$1“ не се дозволени.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_json_link' => 'JSON',
	'smw_rdf_link' => 'RDF',
	'smw_printername_count' => 'Резултати од пребројувањето',
	'smw_printername_csv' => 'CSV извоз',
	'smw_printername_dsv' => 'DSV-извоз',
	'smw_printername_debug' => 'Поправање грешки во барања (за експерти)',
	'smw_printername_embedded' => 'Вметни содржина од страница',
	'smw_printername_json' => 'JSON извоз',
	'smw_printername_list' => 'Список',
	'smw_printername_ol' => 'Набројување',
	'smw_printername_ul' => 'Список',
	'smw_printername_table' => 'Табела',
	'smw_printername_broadtable' => 'Широка табела',
	'smw_printername_template' => 'Шаблон',
	'smw_printername_rdf' => 'RDF-извоз',
	'smw_printername_category' => 'Категорија',
	'validator-type-class-SMWParamSource' => 'текст',
	'smw-paramdesc-limit' => 'Максималниот број на дадени резултати',
	'smw-paramdesc-offset' => 'Отстапувањето на првиот резултат.',
	'smw-paramdesc-headers' => 'Прикажувај наслови/имиња на својства',
	'smw-paramdesc-mainlabel' => 'Ознаката која се дава на името на главната страница',
	'smw-paramdesc-link' => 'Прикажи ги вредностите како врски',
	'smw-paramdesc-intro' => 'Текстот за прикажување пред резултатите од барањето, ако ги има',
	'smw-paramdesc-outro' => 'Текстот за прикажување по резултатите од барањето, ако ги има',
	'smw-paramdesc-default' => 'Текстот за прикажување ако нема резултати од барањето',
	'smw-paramdesc-sep' => 'Разделувачот за вредностите',
	'smw-paramdesc-showsep' => 'Прикажувај го одделувачот најгоре во CSV-податотеката ("sep=<value>")',
	'smw-paramdesc-distribution' => 'Наместо да се прикажат сите вредности, изброј колку пати се јавуваат и прикажи ги нив.',
	'smw-paramdesc-distributionsort' => 'Подреди ја распределбата на вредностите по број на јавувања.',
	'smw-paramdesc-distributionlimit' => 'Ограничи ја распределбата на вредности според бројот на само некои вредности.',
	'smw-paramdesc-template' => 'Името на шаблонот со чија помош ќе се прикажуваат податоците',
	'smw-paramdesc-columns' => 'Бројот на колони за приказ на резултати ($1 по основно)',
	'smw-paramdesc-userparam' => 'Вредност која се дава при секое повикување на шаблон, ако се користи',
	'smw-paramdesc-introtemplate' => 'Име на шаблонот за приказ пред резултатите од пребарувањето, ако ги има',
	'smw-paramdesc-outrotemplate' => 'Име на шаблонот за приказ по резултатите од пребарувањето, ако ги има',
	'smw-paramdesc-embedformat' => 'HTML-ознаката која се користи за определување на наслови',
	'smw-paramdesc-embedonly' => 'Не прикажувај наслови',
	'smw-paramdesc-table-class' => 'Дополнителна CSS-класа за табелата',
	'smw-paramdesc-rdfsyntax' => 'RDF-синтаксата што ќе се користи',
	'smw-paramdesc-csv-sep' => 'Кој разделник да се користи',
	'smw-paramdesc-dsv-separator' => 'Кој разделник да се користи',
	'smw-paramdesc-dsv-filename' => 'Име на DSV-податотеката',
	'smw-smwdoc-description' => 'Прикажува табела на сите параметри што можат да се искористат за назначениот формат на резултати заедно со основните вредности и описи.',
	'smw-smwdoc-par-format' => 'Форматот на резултатите за кој се прикажува параметарска документација.',
	'smw-smwdoc-par-parameters' => 'Кои параметри да се прикажуваат. „specific“ за оние што ги додава форматот, „base“ за оние достапни во сите формати, а „all“ за обете.',
	'smw-paramdesc-sort' => 'По кое својство да се подреди барањето',
	'smw-paramdesc-order' => 'Редослед на подредување на барањето',
	'smw-paramdesc-searchlabel' => 'Текст за продолжување на пребарувањето',
	'smw-paramdesc-named_args' => 'Именувајте ги аргументите што му се предаваат на шаблонот.',
	'smw-paramdesc-export' => 'Можност за извоз',
	'smw-paramdesc-prettyprint' => 'Дали исписот да се форматира со дополнителни вовлекувања и нови редови',
	'smw-paramdesc-source' => 'Алтернативен извор за барање',
	'smw-paramdesc-jsonsyntax' => 'JSON-синтакса што ќе се користи',
	'smw-printername-feed' => 'RSS и Atom канал',
	'smw-paramdesc-feedtype' => 'Вид на канал',
	'smw-paramdesc-feedtitle' => 'Текст на насловот на каналот',
	'smw-paramdesc-feeddescription' => 'Текст на описот на каналот',
	'smw-paramdesc-feedpagecontent' => 'Содржина на страницата што се прикажува со каналот',
	'smw-label-feed-description' => '$2-канал на $1',
	'smw_iq_disabled' => 'На ова вики се оневозможени семантички барања.',
	'smw_iq_moreresults' => '… понатамошни резултати',
	'smw_parseerror' => 'Дадената вредност не беше разбрана.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '„$1“ не може да се користи како име на страница во ова вики.',
	'smw_noproperty' => '„$1“ не може да се користи како име на својство во ова вики.',
	'smw_wrong_namespace' => 'Тука се дозвоени само страници во именскиот простор „$1“.',
	'smw_manytypes' => 'За својството е определен повеќе од еден тип.',
	'smw_emptystring' => 'Не се прифаќаат празни низи.',
	'smw_maxstring' => 'Низната претстава $1 е предолга.',
	'smw_notinenum' => '„$1“ не е на списокот на можни вредности ($2) за ова својство.',
	'smw_noboolean' => '„$1“ не претставува Булова вредност (точно/неточно).',
	'smw_true_words' => 'вистина,да,в,д,true,t,yes,y',
	'smw_false_words' => 'лага,л,невистина,н,не,false,f,no,n',
	'smw_nofloat' => '„$1“ не претставува број.',
	'smw_infinite' => 'Броевите со толкава должина како „$1“ не се поддржани.',
	'smw_unitnotallowed' => '„$1“ не се смета за важечка мерна единица за ова својство.',
	'smw_nounitsdeclared' => 'Нема наведено мерни единици за ова својство.',
	'smw_novalues' => 'Нема назначено вредности.',
	'smw_nodatetime' => 'Датумот „$1“ не е разбран.',
	'smw_toomanyclosing' => 'Во барањето има премногу јавувања на „$1“.',
	'smw_noclosingbrackets' => 'Во вашето барање беа искористени загради „<nowiki>[[</nowiki>“ на кои им недостатуваат соодветни затворачки загради „]]“.',
	'smw_misplacedsymbol' => 'Знакот „$1“ е додаден на место кајшто не е корисен',
	'smw_unexpectedpart' => 'Делот „$1“ од барањето не беше разбран.
Резултатите може да се разликуваат од очекуваното.',
	'smw_emptysubquery' => 'Едно од подбарањата нема важечки услов.',
	'smw_misplacedsubquery' => 'Користено е подбарање на некое место кадешто не се дозволени подбарања.',
	'smw_valuesubquery' => 'Подбарањата не се поддржани за вредностите на својството „$1“.',
	'smw_badqueryatom' => 'Извесен дел „<nowiki>[[…]]</nowiki>“ од барањето не беше разбран.',
	'smw_propvalueproblem' => 'Вредноста на својството „$1“ не е разбрана.',
	'smw_noqueryfeature' => 'Некои функции од барањето не се поддржани на ова вики, и затоа е испуштен дел од барањето ($1).',
	'smw_noconjunctions' => 'Сврзници во барања не се поддржани во ова вики, и затоа е испуштен дел од барањето ($1).',
	'smw_nodisjunctions' => 'Во ова вики не се поддржани дисјункции во барањата, и затоа еден дел од барањето е отфрлен ($1).',
	'smw_querytoolarge' => 'Следниве услови на барањето не можеа да бидат земени предвид заради ограничувањата на големината или длабочината на барањата во ова вики: $1',
	'smw_notemplategiven' => 'Наведете вредност за параметарот „template“ за да може да работи овој формат на барање.',
	'smw_db_sparqlqueryproblem' => 'Не можев да добијам резултат за барањето од базата SPARQL. Грешката може да е привремена или да се должи на бубачка во програмот на базата.',
	'smw_db_sparqlqueryincomplete' => 'Одговарањето на барањето испадна претешко и беше прекинато. Може да се изоставени некои резултати. Ако можете, обидете се со поедноставно барање.',
	'smw_type_header' => 'Својства од типот „$1“',
	'smw_typearticlecount' => '{{PLURAL:$1|Прикажано е $1 својство кое го користи|Прикажани се $1 својства кои го користат}} овој тип.',
	'smw_attribute_header' => 'Страници кои го користат својството „$1“',
	'smw_attributearticlecount' => '{{PLURAL:$1|Прикажана е $1 страница која го користи ова својство|Прикажани се $1 страници кои го користат}} ова својство.',
	'smw_subproperty_header' => 'Потсвојства',
	'smw_subpropertyarticlecount' => 'Ова својство {{PLURAL:$1|го има следново $1 потсвојство|ги има следниве $1 потсвојства}}:',
	'smw_concept_header' => 'Страници на концептот „$1“',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Прикажана е $1 страница која му припаѓа|Прикажани се $1 страници кои му припаѓаат}} на тој концепт.',
	'specialpages-group-smw_group' => 'Семантички МедијаВики',
	'exportrdf' => 'Извези страници во RDF',
	'smw_exportrdf_docu' => 'Оваа страница ви овозможува да преземете податоци од страница во RDF формат.
За да ги извезете страниците, внесете ги насловите во кутијата подолу (по еден наслов во секој ред).',
	'smw_exportrdf_recursive' => 'Рекурзивно извези ги сите поврзани страници.
Имајте на ум дека резултатот може да биде мошне голем!',
	'smw_exportrdf_backlinks' => 'Извези ги и страниците кои укажуваат на извезените страници.
Создава RDF со поддршка за прелистување.',
	'smw_exportrdf_lastdate' => 'Не извезувај страници кои се немаат променето од назначениот датум наваму.',
	'smw_exportrdf_submit' => 'Извези',
	'uriresolver' => 'URI претворач',
	'properties' => 'Својства',
	'smw_properties_docu' => 'Во викито се користат следниве својства.',
	'smw_property_template' => '$1 од типот $2 ($3 {{PLURAL:$3|употреба|употреби}})',
	'smw_property_template_notype' => '$1 ($2)',
	'smw_propertylackspage' => 'Сите својства треба да се опишани во страница!',
	'smw_propertylackstype' => 'Нема назначено тип за ова својство (засега по основно ќе се користи типот $1)',
	'smw_propertyhardlyused' => 'Ова својство речиси не се користи на викито!',
	'unusedproperties' => 'Неискористени својства',
	'smw_unusedproperties_docu' => 'Следниве својства постојат, но ниедна друга страница не ги користи.',
	'smw_unusedproperty_template' => '$1 од типот $2',
	'wantedproperties' => 'Потребни својства',
	'smw_wantedproperties_docu' => 'Следниве својства се користат во викито, но сè уште немаат своја страница за опис.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|употреба|употреби}})',
	'smw_purge' => 'Превчитај',
	'types' => 'Типови',
	'smw_types_docu' => 'Ова е список на сите типови на податоци кои можат да се назначуваат на својства.',
	'semanticstatistics' => 'Семантички статистики',
	'smw_semstats_text' => "Ова вики содржи '''$1''' {{PLURAL:$1|својствена вредност|својствени вредности}} од вкупно '''$2''' [[Special:Properties|{{PLURAL:$2|својство|различни својства}}]].
'''$3''' {{PLURAL:$3|својство има|својства имаат}} своја страница, а предвидениот тип на податоци е назначен за '''$4''' од нив.
Некои од постоечките својства може да се [[Special:UnusedProperties|неискористени]].
Својствата кои сè уште немаат страница се наведени на [[Special:WantedProperties|списокот на потребни својства]].",
	'smw_uri_doc' => 'URI-претварачот применува <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C пронаоѓање на ознаки на httpRange-14</a>.
Тој има за задача да внимава луѓето да не се претворат во мрежни места.',
	'ask' => 'Семантичко пребарување',
	'smw_ask_sortby' => 'Подреди по колона (незадолжително)',
	'smw_ask_ascorder' => 'Нагорен',
	'smw_ask_descorder' => 'Надолен',
	'smw_ask_submit' => 'Пронајди',
	'smw_ask_editquery' => '(Уреди барање)',
	'smw_add_sortcondition' => '(Додај услов за подредување)',
	'smw_ask_hidequery' => 'Скриј барање',
	'smw_ask_help' => 'Помош со поставување барања',
	'smw_ask_queryhead' => 'Барање',
	'smw_ask_printhead' => 'Дополнителни податоци за приказ',
	'smw_ask_printdesc' => '(додавајте едно име на својство по ред)',
	'smw_ask_format_as' => 'Форматирај како:',
	'smw_ask_defaultformat' => 'по основно',
	'smw_ask_otheroptions' => 'Други нагодувања',
	'smw-ask-otheroptions-info' => 'Овој поднаслов содржи можности за менување на исписот. Описите на параметрите ќе ги видите ако отидете со глувчето врз нив.',
	'smw-ask-otheroptions-collapsed-info' => 'Стиснете на иконата „+“ (плус) за да ги погледате сите расположиви можности',
	'smw_ask_show_embed' => 'Прикажи вграден код',
	'smw_ask_hide_embed' => 'Скриј вметнат код',
	'smw_ask_embed_instr' => 'За да го вметнете ова барање во вики-страницата меѓу редови, употребете го кодот подолу.',
	'smw-ask-delete' => '[Избриши]',
	'smw-ask-sorting' => 'Подредување',
	'smw-ask-format-selection-help' => 'Подробен опис можете да прочитате на страницата за помош за $1.',
	'querycreator' => 'Создавач на барања',
	'smw_qc_addmainlabel' => 'Додај главен признак',
	'smw_qc_show_addnal_opts' => 'Повеќе можности',
	'smw_qc_hide_addnal_opts' => 'Помалку можности',
	'smw_qc_otheropt' => 'Други нагодувања',
	'smw_qc_intro' => 'Вовед:',
	'smw_qc_outro' => 'Завршник:',
	'smw_qc_default' => 'По основно:',
	'smw_qc_formatopt' => 'Нагодувања на форматот',
	'smw_qc_query_help' => 'Внесете барање со помош на долунаведениот образец. Изберете вики-страници според
Категории (<strong><nowiki>на пр. [[Category:Глумец]]</nowiki></strong>),
Својства (<strong><nowiki>на пр. [[Се наоѓа во::Македонија]]</nowiki></strong>),
Имиња (<strong><nowiki>на пр. [[Македонија]]</nowiki></strong>) and
Именски простори (<strong><nowiki>на пр. [[Help:+]]</nowiki></strong>)',
	'smw_qui_property' => '<strong>Својство</strong>',
	'smw_qui_prop' => 'Својство:',
	'smw_qui_labl' => 'Натпис:',
	'smw_qui_formt' => 'Формат:',
	'smw_qui_limt' => 'Ограничување:',
	'smw_qui_shownresults' => 'прикажи во резултатите',
	'smw_qui_noquery' => 'Нема определено барање',
	'smw_qui_invalidprop' => '„$1“ може да не е важечко својство',
	'smw_qui_invalidformat' => 'Одбраниот формат „$1“ не постои на ова вики',
	'smw_qui_nosort' => 'Без подредување',
	'smw_qui_ascorder' => 'Нагорно',
	'smw_qui_descorder' => 'Надолно',
	'smw_qui_randorder' => 'Случајно',
	'smw_qui_addnprop' => 'додај својство',
	'smw_qui_delete' => 'Отстрани',
	'smw_qui_rescol' => 'Совпаѓања на бараното',
	'smw_qui_options' => 'поставки',
	'smw_qui_addcategory' => 'додај категорија',
	'smw_qui_addrescol' => 'додај совпаѓања на бараното',
	'smw_qui_ok' => 'Ок',
	'smw_qui_cancel' => 'Откажи',
	'smw_qui_category' => '<strong>Категорија</strong>',
	'smw_qui_label' => 'Натпис',
	'smw_prp_options' => 'Поставки за својства',
	'smw_qui_catopts' => 'Поставки за категории',
	'smw_qui_mainlabopts' => 'Нагодувања на резултатите',
	'smw_qui_dlabel' => 'Ознака:',
	'smw_qui_dcategory' => 'Категорија:',
	'smw_qui_dcatyes' => 'Прикажи текст кога ја има категоријата:',
	'smw_qui_dcatno' => 'Прикажи текст кога ја нема категоријата:',
	'searchbyproperty' => 'Пребарај по својство',
	'smw_sbv_docu' => 'Пребарување на сите страници кои имаат дадено својство и вредност.',
	'smw_sbv_novalue' => 'Внесете важечка вредност за својството, или пак погледнете ги сите вредности на својството „$1“.',
	'smw_sbv_displayresult' => 'Список на сите страници што го содржат својството „$1“ со вредност „$2“',
	'smw_sbv_displayresultfuzzy' => 'Список на сите страници кои имаат својство „$1“ со вредност „$2“.
Бидејќи има само неколку резултати, прикажани се и приближни вредности.',
	'smw_sbv_property' => 'Својство:',
	'smw_sbv_value' => 'Вредност:',
	'smw_sbv_submit' => 'Пронајди',
	'browse' => 'Прелистај вики',
	'smw_browselink' => 'Прелистај својства',
	'smw_browse_article' => 'Внесете го името на страницата од која би почнале да прелистувате.',
	'smw_browse_go' => 'Оди',
	'smw_browse_more' => '…',
	'smw_browse_show_incoming' => 'прикажи својства кои водат овде',
	'smw_browse_hide_incoming' => 'скриј својства што водат овде',
	'smw_browse_no_outgoing' => 'Оваа страница нема својства.',
	'smw_browse_no_incoming' => 'До оваа страница не водат никакви својства.',
	'smw_inverse_label_default' => '$1 од',
	'smw_inverse_label_property' => 'Обратен наслов на својството',
	'pageproperty' => 'Пребарување својства на страница',
	'smw_pp_docu' => 'Пребарај ги сите вредности на едно својство на дадена страница.
Внесете и страница и својство.',
	'smw_pp_from' => 'Од страница',
	'smw_pp_type' => 'Својство',
	'smw_pp_submit' => 'Пребарај резултати',
	'smw_result_prev' => 'Претходно',
	'smw_result_next' => 'Следно',
	'smw_result_results' => 'Резултати',
	'smw_result_noresults' => 'Нема резултати.',
	'smwadmin' => 'Администраторски функции за Семантички МедијаВики',
	'smw_smwadmin_setupsuccess' => 'Складишниот систем е успешно поставен.',
	'smw_smwadmin_return' => 'Назад на $1',
	'smw_smwadmin_updatestarted' => 'Започнат е нов процес за обнова на семантичките податоци.
Сите складирани податоци ќе бидат преработени или поправени, каде што е потребно.
На оваа специјална страница можете да го следите процесот на поднова.

Назад на $1.',
	'smw_smwadmin_updatenotstarted' => 'Веќе е во тек едно подновување.
Нема да се создаде друго.

Назад на $1.',
	'smw_smwadmin_updatestopped' => 'Сите постоечки процеси на поднова се сопрени.

Назад на $1.',
	'smw_smwadmin_updatenotstopped' => 'За да го запрете текот на подновата, мора да го активирате кутивчето за избор кое укажува на тоа дека сте навистина сигурни дека сакате да направите така.

Назад на $1.',
	'smw_smwadmin_docu' => 'Оваа специјална страница ви помага во текот на инсталацијата и подновата на <a href="http://semantic-mediawiki.org/?uselang=mk">Семантички МедијаВики</a>.
Не заборавајте да направите резервни примероци од значајни податоци пред да вршите административни постапки.',
	'smw_smwadmin_db' => 'Инсталација и поднова на базата на податоци',
	'smw_smwadmin_dbdocu' => 'Семантички МедијаВики бара додавање на извесни додатоци кон базата на податоци на МедијаВики за да складира семантички податоци.
Функцијата подолу ви гарантира дека вашата база на податоци е правилно поставена.
Промените извршени во овој чекор немаат влијание врз остатокот од базата на МедијаВики, и лесно можат да се вратат по старо ако се јави потреба.
Оваа функција на поставката може да се врши повеќе пати без тоа да причини било каква штета, но потребна е само еднаш при инсталирање или подновување.',
	'smw_smwadmin_permissionswarn' => 'Ако операцијата не успее со грешки при исполнувањето на SQL-наредбите, тогаш корисникот на базата на податоци што го употребува вашето вики (проверете ги вашите LocalSettings.php) нема доволно дозволи.
Доделете му доволно дозволи на корисникот за да може да создава и брише табели, привремено внесете го најавниот корен (root) на вашата база на податоци во LocalSettings.php, или пак употребете ја скриптата за одржување <tt>SMW_setup.php</tt> која може да ги користи акердитивите за пристап од корисник на SysOp.',
	'smw_smwadmin_dbbutton' => 'Започни или поднови табели',
	'smw_smwadmin_announce' => 'Објавете го вашето вики',
	'smw_smwadmin_announcedocu' => 'Семантички МедијаВики има мрежна служба за соопштување на нови семантички вики-страници.
Ова се користи за одржување на список на јавни мрежни места кои го користат Семантички МедијаВики, главно со цел да му се помогне на <a href="http://semantic-mediawiki.org/wiki/SMW_Project?uselang=mk">проектот Semantic MediaWiki</a> да добие претстава за типичните употреби на Семантички МедијаВики.
Погледајте го мрежното место на Семантички МедијаВики за <a href="http://semantic-mediawiki.org/wiki/Registry?uselang=mk">повеќе информации за оваа служба</a>.',
	'smw_smwadmin_announcebutton' => 'Притиснете го следново копче за да ја испратите URL-адресата на вашето вики во таа служба.
Службата нема да регистрира викија што не се јавно достапни, и ќе складира само достапни информации.',
	'smw_smwadmin_datarefresh' => 'Поправка и поднова на податоци',
	'smw_smwadmin_datarefreshdocu' => 'Постои можност за враќање на сите податоци на Семантички МедијаВики врз основа на тековните содржини на викито.
Ова е корисно за поправка на оштетени податоци или за обнова на податоците ако внатрешниот формат се има променето како резултат на некаква надградба на програмската опрема.
Подновувањето се врши страница по страница, и ќе треба да помине некое време за да профункционира.
Подолу е прикажано дали има поднова во тек, и тоа ви овозможува да започнувате или запирате подновувања (освен ако таа можност не е исклучена од администраторот на мрежното место).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Веќе е во тек една поднова.</strong>
Нормално е подновата да биде бавна, бидејќи податоците се обновуваат во мали делчиња секојпат кога корисникот ќе отиде на викито.
За да ја убрзате подновата, можете да ја повикате скриптата за одржување на MediaWiki <tt>runJobs.php</tt> (користете ја можноста <tt>--maxjobs 1000</tt> за да го ограничите бројот на поднови во една партија).
Проценет напредок на тековната поднова:',
	'smw_smwadmin_datarefreshbutton' => 'Започни со подновување на податоци',
	'smw_smwadmin_datarefreshstop' => 'Започни го ова подновување',
	'smw_smwadmin_datarefreshstopconfirm' => 'Да, сигурен сум.',
	'smw_smwadmin_support' => 'Како да добиете поддршка',
	'smw_smwadmin_supportdocu' => 'Различни ресурси кои можат да ви помогнат во случај на проблеми:',
	'smw_smwadmin_installfile' => 'Ако наидете на проблеми при инсталацијата, најпрвин прочитајте ги напатствијата во <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">податотеката INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Целосната корисничка документација за Семантички МедијаВики ќе ја најдете на <b><a href="http://semantic-mediawiki.org?uselang=mk">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Бубачките (грешките) можат да се пријават на <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Ако имате некои други прашања или предлози, приклучете ѝ се на дискусијата на <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">форумот за корисници на Семантички МедијаВики</a>.',
	'smw_adminlinks_datastructure' => 'Структура на податоците',
	'smw_adminlinks_displayingdata' => 'Приказ на податоци',
	'smw_adminlinks_inlinequerieshelp' => 'Помош со вметнати барања',
	'smw-createproperty-isproperty' => 'Ова е својство од типот $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Дозволената вредност за ова својство е|Дозволените вредности за ова својство се}}:',
	'smw-paramdesc-category-delim' => 'Разделувачот',
	'smw-paramdesc-category-template' => 'Шаблон со кој ќе се форматираат елементите',
	'smw-paramdesc-category-userparam' => 'Параметар што ќе му даде на шаблонот',
	'smw-info-par-message' => 'Порака за приказ.',
	'smw-info-par-icon' => 'Икона за приказ на „инфо“ или „предупредување“.',
	'prefs-smw' => 'Семантички МедијаВики',
	'prefs-ask-options' => 'Можности за семантичко пребарување',
	'smw-prefs-intro-text' => 'Долунаведените можности се достапни преку [http://semantic-mediawiki.org/ Семантички МедијаВики] (или поврзаните додтоци) со цел да овозможи поединечни прилагодувања на извесни функции. Повеќе информации ќе најдете на оваа [http://semantic-mediawiki.org/wiki/Help:User_preferences страница за помош].',
	'smw-prefs-ask-options-tooltip-display' => 'Прикажи го текстот на параметарот како информативен отскочен текст',
	'smw-prefs-ask-options-collapsed-default' => 'Полето за можности нека стои расклопено (отворено) по основно',
	'smw-ui-tooltip-title-property' => 'Својство',
	'smw-ui-tooltip-title-quantity' => 'Количина',
	'smw-ui-tooltip-title-info' => 'Информации',
	'smw-ui-tooltip-title-service' => 'Услужни врски',
	'smw-ui-tooltip-title-warning' => 'Грешка',
	'smw-ui-tooltip-title-parameter' => 'Параметар',
	'smw-ui-tooltip-title-event' => 'Настан',
	'smw_unknowntype' => 'Ова својство е од неважечки тип',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'smw_finallistconjunct' => 'ഉം',
	'smw_factbox_head' => '$1നെ കുറിച്ചുള്ള സത്യങ്ങൾ',
	'smw_iq_moreresults' => '… കൂടുതൽ ഫലങ്ങൾ',
	'smw_parseerror' => 'താങ്കൾ ചേർത്ത മൂല്യം മനസ്സിലാക്കാൻ സാധിച്ചില്ല.',
	'smw_true_words' => 'ശരി,ശരി,അതെ,അതെ',
	'smw_false_words' => 'തെറ്റ്,തെറ്റ്,അല്ല,അല്ല',
	'smw_nofloat' => '“$1” ഒരു സംഖ്യയല്ല.',
	'smw_infinite' => '“$1” എന്ന സംഖ്യയുടെയത്ര വലിപ്പമുള്ള സംഖ്യകൾ പിന്തുണയ്ക്കുന്നില്ല.',
	'smw_misplacedsymbol' => '“$1” എന്ന ചിഹ്നം അതു ഉപയോഗിക്കാൻ പാടില്ലാത്ത ഒരു സ്ഥലത്ത് ഉപയോഗിച്ചിരിക്കുന്നു.',
	'exportrdf' => 'RDFലേക്ക് താളുകൾ എക്സ്‌പോർട്ട് ചെയ്യുക',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|ഒരുപയോഗം|$2 ഉപയോഗങ്ങൾ}})',
	'types' => 'തരങ്ങൾ',
	'smw_ask_ascorder' => 'ആരോഹണം',
	'smw_ask_descorder' => 'അവരോഹണം',
	'smw_ask_submit' => 'ഫലങ്ങൾ കാണുക',
	'smw_sbv_value' => 'മൂല്യം:',
	'smw_sbv_submit' => 'ഫലങ്ങൾ കാണുക',
	'browse' => 'വിക്കിയിൽ പരതുക',
	'smw_browse_go' => 'പോകൂ',
	'smw_pp_from' => 'ഈ താളിൽ നിന്ന്',
	'smw_pp_submit' => 'ഫലങ്ങൾ കാണുക',
	'smw_result_prev' => 'മുമ്പത്തെ',
	'smw_result_next' => 'അടുത്തത്',
	'smw_result_results' => 'ഫലങ്ങൾ',
	'smw_result_noresults' => 'ക്ഷമിക്കുക, ഫലങ്ങൾ ഒന്നുമില്ല',
);

/** Mongolian (монгол)
 * @author Chinneeb
 */
$messages['mn'] = array(
	'smw_browse_go' => 'Явах',
);

/** Marathi (मराठी)
 * @author Htt
 * @author Kaustubh
 */
$messages['mr'] = array(
	'smw_viewasrdf' => 'RDF फीड',
	'smw_finallistconjunct' => ', व',
	'smw_factbox_head' => '$1 च्या फॅक्ट्स',
	'smw_isspecprop' => 'हा गुणधर्म या विकिवरील विशेष गुणधर्म आहे.',
	'smw_baduri' => 'माफ करा, “$1” अर्जाचे URI वापरण्यास परवानगी नाही.',
	'smw_iq_disabled' => 'माफ करा. या विकिवर सिमँटिक पॄच्छा करण्यास बंदी आहे.',
	'smw_iq_moreresults' => '… पुढचे निकाल',
	'smw_parseerror' => 'दिलेली किंमत समजलेली नाही.',
	'smw_notitle' => 'या विकिवर “$1” हे पानाच्या शीर्षकात वापरता येत नाही.',
	'smw_manytypes' => 'गुणधर्माला एकापेक्षा जास्त प्रकार दिलेले आहेत.',
	'smw_emptystring' => 'रिकाम्या किंमती वापरता येत नाहीत.',
	'smw_maxstring' => '{{SITENAME}} साठी $1 हे स्ट्रींग रिप्रेझेंटेशन खूप लांब आहे.', # Fuzzy
	'smw_notinenum' => 'या गुणधर्माच्या योग्य किंमतींच्या ($2) यादीत “$1” नाही आहे.',
	'smw_noboolean' => '“$1” ही योग्य बुलियन (बरोबर/चूक) किंमत नाही.',
	'smw_true_words' => 'बरोबर,t,हो,y',
	'smw_false_words' => 'चूक,f,नाही,n',
	'smw_nofloat' => '“$1” ही संख्या नाही.',
	'smw_infinite' => '{{SITENAME}} वर “$1” एवढ्या मोठ्या संख्या वापरता येत नाहीत.', # Fuzzy
	'smw_nodatetime' => '“$1” हा दिनांक समजला नाही.',
	'smw_toomanyclosing' => 'या पृच्छेमध्ये “$1” खूप ठिकाणी आलेले आहे.',
	'smw_noclosingbrackets' => 'तुमच्या पृच्छेत कुठेतरी वापरलेले “<nowiki>[[</nowiki>” हे योग्य अशा जुळणार्‍या “]]” ने बंद केलेले नाही.',
	'smw_misplacedsymbol' => '“$1” चिन्ह जिथे उपयोगी नाही अशा ठिकाणी वापरलेले आहे.',
	'smw_unexpectedpart' => 'पृच्छेचा “$1” हा भाग समजलेला नाही.
निकाल योग्य असतीलच याची खात्री नाही.',
	'smw_emptysubquery' => 'कुठल्यातरी उपपृच्छेमध्ये योग्य कंडिशन दिलेली नाही.',
	'smw_misplacedsubquery' => 'एक उपपृच्छा अशा ठिकाणी दिलेली आहे जिथे उपपृच्छा वापरायला परवानगी नाही.',
	'smw_valuesubquery' => '“$1” गुणधर्माच्या किंमतींसाठी उपपृच्छा वापरता येत नाहीत.',
	'smw_badqueryatom' => 'पृच्छेचा काही भाग “<nowiki>[[…]]</nowiki>” समजलेला नाही.',
	'smw_propvalueproblem' => '“$1” गुणधर्माची किंमत समजलेली नाही.',
	'smw_nodisjunctions' => 'पृच्छे मध्ये तुकडे या विकिवर चालत नाहीत, त्यामुळे पृच्छेचा तुकडा टाकून दिला  ($1).',
	'smw_querytoolarge' => 'पृच्छेचा आकार अथवा खोलीवर असणार्‍या ह्या विकिवरील मर्यादांमुळे खालील पृच्छा अटी लक्षात घेता आलेल्या नाहीत: $1.',
	'smw_type_header' => '“$1” प्रकारचे गुणधर्म',
	'smw_typearticlecount' => 'हा प्रकार {{PLURAL:$1|वापरणारा|वापरणारे}} $1 गुणधर्म दाखवित आहे.',
	'smw_attribute_header' => '“$1” गुणधर्म वापरणारी पृष्ठे',
	'smw_attributearticlecount' => 'हा गुणधर्म वापरणारी $1 पाने दाखवित आहे..', # Fuzzy
	'smw_rss_description' => '$1 आरएसएस फीड',
	'specialpages-group-smw_group' => 'सिमँटिक मीडियाविकि',
	'exportrdf' => 'RDF कडे पाने निर्यात करा',
	'smw_exportrdf_docu' => 'हे पान तुम्हाला एखाद्या पानावरील मजकूर RDF मध्ये घेण्यास मदत करते.
पाने निर्यात करण्याकरीता, खाली एका ओळीत एक याप्रमाणे पानांची शीर्षके लिहा.',
	'smw_exportrdf_recursive' => 'सर्व जुळलेली पाने आपोआप निर्यात करा.
कृपया नोंद घ्या की निकाल खूप मोठा असू शकतो!',
	'smw_exportrdf_backlinks' => 'निर्यात केलेल्या पानांचे संदर्भ देणारी पाने सुद्धा निर्यात करा.
ब्राउजेबल RDF तयार होईल.',
	'smw_exportrdf_lastdate' => 'दिलेल्या वेळेनंतर ज्या पानांमध्ये बदल झालेले नाहीत अशी पाने निर्यात करू नका.',
	'uriresolver' => 'URI रिजल्व्हर',
	'properties' => 'गुणधर्म',
	'smw_properties_docu' => 'या विकिवर खालील गुणधर्म वापरलेले आहेत.',
	'smw_property_template' => '$2 प्रकारची $1 ($3)',
	'smw_propertylackspage' => 'एका पानावर सर्व गुणधर्मांची माहिती असणे आवश्यक आहे!',
	'smw_propertylackstype' => 'या गुणधर्माचा प्रकार दिलेला नाही (आत्तापुरता $1 हा प्रकार गृहीत धरत आहे).',
	'smw_propertyhardlyused' => 'या विकिवर हा गुणधर्म क्वचितच वापरला जातो!',
	'unusedproperties' => 'न वापरलेले गुणधर्म',
	'smw_unusedproperties_docu' => 'खालील गुणधर्म कुठल्याही पानावर वापरण्यात आलेले नाहीत.',
	'smw_unusedproperty_template' => '$2 प्रकारचे $1',
	'wantedproperties' => 'पाहिजे असलेले गुणधर्म',
	'smw_wantedproperties_docu' => 'या विकिवर वापरण्यात आलेल्या खालील गुणधर्मांसाठी माहिती पृष्ठे अस्तित्वात नाहीत.',
	'smw_wantedproperty_template' => '$1 ($2 वापरतो)', # Fuzzy
	'smw_purge' => 'ताजेतवाने करा',
	'types' => 'प्रकार',
	'smw_types_docu' => 'खाली गुणधर्माशी जोडता येणार्‍या सर्व डाटा प्रकारांची यादी आहे.
प्रत्येक डाटा प्रकाराचे एक पाने आहे जिथे जास्तीची माहिती देता येईल.', # Fuzzy
	'semanticstatistics' => 'सिमँटिक सांख्यिकी',
	'smw_semstats_text' => 'ह्या विकिमध्ये <b>$1</b> गुणधर्मांच्या किंमती आहेत ज्या एकूण <b>$2</b> वेगवेगळ्या <a href="$3">गुणधर्म</a> दर्शवितात.
<b>$4</b> गुणधर्मांना स्वत:ची पाने आहेत, व त्यापैकी <b>$5</b> गुणधर्मांना जुळणारे डाटा प्रकार दिलेले आहेत.
यातील काही गुणधर्म हे <a href="$6">न वापरलेले गुणधर्म</a> असण्याची शक्यता आहे.
ज्या गुणधर्मांना स्वत:चे पान नाही असे गुणधर्म <a href="$7">पाहिजे असलेल्या गुणधर्मांची यादी</a> मध्ये सापडतील.', # Fuzzy
	'smw_uri_doc' => 'URI रिझॉल्वर मध्ये एक <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C टॅग आहे जो httpRange-14 शोधण्यास मदत करतो</a>. हा मनुष्यप्राणी संकेतस्थळामध्ये बदलणार नाही याची काळजी घेतो.',
	'ask' => 'सिमंटिक शोध',
	'smw_ask_sortby' => 'रकान्या प्रमाणे लावा (वैकल्पिक)',
	'smw_ask_ascorder' => 'चढत्या श्रेणीने',
	'smw_ask_descorder' => 'उतरत्या श्रेणीने',
	'smw_ask_submit' => 'निकाल शोधा',
	'smw_ask_editquery' => '[पृच्छा संपादा]',
	'smw_add_sortcondition' => '[लावण्याची अट वाढवा]',
	'smw_ask_hidequery' => 'पृच्छा लपवा',
	'smw_ask_help' => 'पृच्छा करण्यासाठी मदत',
	'smw_ask_queryhead' => 'पॄच्छा',
	'smw_ask_printhead' => 'जास्तीच्या छापील प्रती (वैकल्पिक)', # Fuzzy
	'searchbyproperty' => 'गुणधर्माप्रमाणे शोधा',
	'smw_sbv_docu' => 'दिलेला गुणधर्म व किंमत असणारी सर्व पाने शोधा.',
	'smw_sbv_novalue' => 'कृपया या गुणधर्माची एक योग्य किंमत द्या, किंवा “$1” साठीच्या सर्व किंमती पहा.',
	'smw_sbv_displayresult' => 'गुणधर्म  “$1” व त्याची किंमत “$2” असणार्‍ सर्व पानांची यादी',
	'smw_sbv_property' => 'गुणधर्म', # Fuzzy
	'smw_sbv_value' => 'किंमत:',
	'smw_sbv_submit' => 'निकाल शोधा',
	'browse' => 'विकि न्याहाळा',
	'smw_browse_article' => 'विकि ज्या पानापासून न्याहाळायचा त्या पानाचे नाव लिहा',
	'smw_browse_go' => 'चला',
	'pageproperty' => 'पान गुणधर्म शोध',
	'smw_pp_docu' => 'दिलेल्या पानावरील एखाद्या गुणधर्माच्या सर्व किंमतींचा शोध घ्या.
कृपया पान व गुणधर्म दोन्ही द्या.',
	'smw_pp_from' => 'पानावरून',
	'smw_pp_type' => 'गुणधर्म',
	'smw_pp_submit' => 'निकाल शोधा',
	'smw_result_prev' => 'मागील',
	'smw_result_next' => 'पुढील',
	'smw_result_results' => 'निकाल',
	'smw_result_noresults' => 'माफ करा, निकाल नाहीत.',
	'smw-createproperty-isproperty' => 'हा $1 प्रकारचा गुणधर्म आहे.',
	'smw-createproperty-allowedvals' => 'या गुणधर्माच्या योग्य किंमती पुढीलप्रमाणे आहेत:', # Fuzzy
	'smw_unknowntype' => 'गुणधर्माचा प्रकार “$1” वापरता येत नाही.', # Fuzzy
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'smw-desc' => 'Meningkatkan kebolehcapaian wiki anda – baik untuk mesin mahupun manusia ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentasi])',
	'smw_viewasrdf' => 'Suapan RDF',
	'smw_finallistconjunct' => ', dan',
	'smw_factbox_head' => 'Fakta-fakta tentang $1',
	'smw_isspecprop' => 'Sifat ini merupakan sifat khas di wiki ini.',
	'smw_concept_description' => 'Keterangan konsep "$1"',
	'smw_no_concept_namespace' => 'Konsep hanya boleh ditakrifkan di laman-laman dalam ruang nama Concept:.',
	'smw_multiple_concepts' => 'Setiap laman konsep hanya boleh ada satu takrifan konsep.',
	'smw_concept_cache_miss' => 'Konsep "$1" tidak boleh digunakan buat masa ini kerana konfigurasi wiki memerlukannya untuk dikomput di luar talian.
Jika masalah ini masih berlarutan selepas beberapa ketika, mintalah pentadbir tapak anda untuk menyediakan konsep ini.',
	'smw_noinvannot' => 'Nilai tidak dapat diberikan kepada sifat songsang.',
	'version-semantic' => 'Sambungan semantik',
	'smw_baduri' => 'URI yang berbentuk "$1" tidak dibenarkan.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Hasil pengiraan',
	'smw_printername_csv' => 'Eksport CSV',
	'smw_printername_dsv' => 'Eksport DSV',
	'smw_printername_debug' => 'Pertanyaan nyahpepijat (debug) (untuk pakar)',
	'smw_printername_embedded' => 'Benamkan kandungan laman',
	'smw_printername_json' => 'Eksport JSON',
	'smw_printername_list' => 'Senarai',
	'smw_printername_ol' => 'Penyenaraian dengan urutan',
	'smw_printername_ul' => 'Penyenaraian tanpa urutan',
	'smw_printername_rss' => 'Eksport RSS',
	'smw_printername_table' => 'Jadual',
	'smw_printername_broadtable' => 'Jadual lebar',
	'smw_printername_template' => 'Templat',
	'smw_printername_rdf' => 'Eksport RDF',
	'smw_printername_category' => 'Kategori',
	'smw-paramdesc-limit' => 'Bilangan hasil maksimum untuk diberikan',
	'smw-paramdesc-offset' => 'Ofset hasil pertama',
	'smw-paramdesc-headers' => 'Paparkan nama pengatas/sifat',
	'smw-paramdesc-mainlabel' => 'Label untuk nama laman utama',
	'smw_purge' => 'Muat semula',
	'types' => 'Jenis',
	'smw_ask_defaultformat' => 'asali',
	'smw_qui_ok' => 'OK',
	'smw_qui_cancel' => 'Batalkan',
	'smw_sbv_value' => 'Nilai:',
	'smw_sbv_submit' => 'Cari hasil',
	'browse' => 'Semak seimbas wiki',
	'smw_browselink' => 'Semak seimbas sifat-sifat',
	'smw_browse_go' => 'Pergi',
	'smw_inverse_label_default' => '$1 daripada',
	'smw_inverse_label_property' => 'Label sifat songsang',
	'smw_result_prev' => 'Sebelumnya',
	'smw_result_next' => 'Berikutnya',
	'smw_result_results' => 'Hasil',
	'smw_result_noresults' => 'Tiada hasil.',
	'smwadmin' => 'Fungsi pentadbir untuk Semantic MediaWiki',
);

/** Maltese (Malti)
 * @author Chrisportelli
 * @author Roderick Mallia
 * @author පසිඳු කාවින්ද
 */
$messages['mt'] = array(
	'smw_qui_ok' => 'Ok',
	'smw_browse_go' => 'Mur',
	'smw_result_prev' => "Ta' qabel",
);

/** Erzya (эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'smw_sbv_property' => 'Уликсчись:',
	'smw_browse_go' => 'Адя',
	'smw_pp_type' => 'Уликсчи',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'smw_finallistconjunct' => ' īhuān',
	'smw_nofloat' => '"$1" ahmo tlapōhualli.',
	'smw_purge' => 'Ticyancuīyāz',
	'smw_browse_go' => 'Yāuh',
	'smw_result_prev' => 'Achtopa',
	'smw_result_next' => 'Niman',
	'smw_smwadmin_return' => 'Titocuepāz īhuīc $1',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Audun
 * @author Event
 * @author Harald Khan
 * @author Laaknor
 * @author Nghtwlkr
 * @author Njardarlogar
 */
$messages['nb'] = array(
	'smw-desc' => "Gjøre wikien din mer tilgjengelig - for maskiner ''og'' mennesker ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])",
	'smw_viewasrdf' => 'RDF-kilde',
	'smw_finallistconjunct' => ' og',
	'smw_factbox_head' => 'Fakta om $1',
	'smw_isspecprop' => 'Denne egenskapen er en spesialegenskap på denne wikien.',
	'smw_concept_description' => 'Beskrivelse av konseptet «$1»',
	'smw_no_concept_namespace' => 'Konsepter kan kun defineres på sider i Concept:-navnerommet.',
	'smw_multiple_concepts' => 'Hver konseptside kan kun ha én konseptdefinisjon.',
	'smw_concept_cache_miss' => 'Konseptet "$1" kan ikke brukes for øyeblikket da wikiens konfigurasjon krever at den blir satt opp frakoplet.
Hvis problemet ikke forsvinner etter en periode, spør sidens administratorer om å gjøre konseptet tilgjengelig.',
	'smw_noinvannot' => 'Verdier kan ikke tildeles inverse egenskaper.',
	'version-semantic' => 'Semantiske utvidelser',
	'smw_baduri' => 'Beklager, URI-er på formen «$1» er ikke tillatt.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Tell opp resultat',
	'smw_printername_csv' => 'CSV-eksport',
	'smw_printername_dsv' => 'DSV-eksport',
	'smw_printername_debug' => 'Feilsøkspørring (for eksperter)',
	'smw_printername_embedded' => 'Innkapselert sideinnhold',
	'smw_printername_json' => 'JSON eksport',
	'smw_printername_list' => 'Liste',
	'smw_printername_ol' => 'Nummerering',
	'smw_printername_ul' => 'Objektsering',
	'smw_printername_rss' => 'RSS eksport',
	'smw_printername_table' => 'Tabell',
	'smw_printername_broadtable' => 'Bred tabell',
	'smw_printername_template' => 'Mal',
	'smw_printername_rdf' => 'RDF-eksport',
	'smw_printername_category' => 'Kategori',
	'smw-paramdesc-limit' => 'Maksimalt antall resultat som skal returneres',
	'smw-paramdesc-offset' => 'Forskyvningen av det første resultet',
	'smw-paramdesc-headers' => 'Viser overskriftene/egenskapsnavnene',
	'smw-paramdesc-mainlabel' => 'Etiketten å gi til hovedsidenavnet',
	'smw-paramdesc-link' => 'Vis verdier som lenker',
	'smw-paramdesc-intro' => 'Tekst som skal vises før spørringsresultat, dersom det er noen',
	'smw-paramdesc-outro' => 'Tekst som skal vises etter spørringsresultat, dersom det er noen',
	'smw-paramdesc-default' => 'Tekst som skal vises dersom det ikke er noen resultat for spørringen',
	'smw-paramdesc-sep' => 'Separatorverdier',
	'smw-paramdesc-distribution' => 'Istedenfor å vise hver av verdiene vises antall verdier',
	'smw-paramdesc-distributionsort' => 'Sorter verdifordelingen mot forekomstantallet',
	'smw-paramdesc-distributionlimit' => 'Begrens verdifordelingen til antallet av visse verdier.',
	'smw-paramdesc-template' => 'Navnet på malen som skal vise frem utskriftene',
	'smw-paramdesc-columns' => 'Antall kolonner som resultatene skal vises i (standard er $1)',
	'smw-paramdesc-userparam' => 'En verdi sendt til hvert malkall, hvis en mal brukes',
	'smw-paramdesc-introtemplate' => 'Navnet på en mal som skal vises før spørringsresultatene, hvis det er noen',
	'smw-paramdesc-outrotemplate' => 'Navnet på en mal som skal vises etter spørringsresultatene, hvis det er noen',
	'smw-paramdesc-embedformat' => 'HTML-elementet brukt for å definere overskrifter',
	'smw-paramdesc-embedonly' => 'Ikke vis overskrifter',
	'smw-paramdesc-table-class' => 'En CSS-klasse til som kan brukes for tabellen',
	'smw-paramdesc-rsstitle' => 'Tekst som skal brukes som tittel på matingen',
	'smw-paramdesc-rssdescription' => 'Tekst som skal brukes som beskrivelse av matingen',
	'smw-paramdesc-rdfsyntax' => 'RDF-syntaksen som blir brukt',
	'smw-paramdesc-csv-sep' => 'Skilletegnet som blir brukt',
	'smw-paramdesc-dsv-separator' => 'Skilletegnet som blir brukt',
	'smw-paramdesc-dsv-filename' => 'Navnet på DSV-filen',
	'smw-smwdoc-description' => 'Viser en tabell over alle parametre som kan brukes for det angitte resultatformatet sammen med standardverdier og beskrivelser.',
	'smw-smwdoc-par-format' => 'Resultatformatet for å vise parameterdokumentasjon.',
	'smw-smwdoc-par-parameters' => 'Hvilke parametre som skal vises. "specific" for dem som er lagt til av formatet, "base" for dem som er tilgjengelig i alle formater og "all" for begge.',
	'smw-paramdesc-sort' => 'Egenskap som spørringen skal sorteres etter',
	'smw-paramdesc-order' => 'Sorteringsrekkefølge for spørringen',
	'smw-paramdesc-searchlabel' => 'Tekst som forteller om fortsatt søk (standard er «… flere resultater»)', # Fuzzy
	'smw_iq_disabled' => 'Beklager. Semantiske spørringer er slått av på denne wikien.',
	'smw_iq_moreresults' => '… flere resultater',
	'smw_parseerror' => 'Den gitte verdien ble ikke forstått.',
	'smw_notitle' => '«$1» kan ikke brukes som sidenavn på denne wikien.',
	'smw_noproperty' => '"$1" kan ikke brukes som en egenskap i denne wikien.',
	'smw_wrong_namespace' => 'Kun sider i navnerommet «$1» er tillatte her.',
	'smw_manytypes' => 'Mer enn én type definert for egenskapen.',
	'smw_emptystring' => 'Tomme strenger godtas ikke.',
	'smw_maxstring' => 'Strengrepresentasjonen $1 er for lang.',
	'smw_notinenum' => '«$1» er ikke i listen over mulige verdier ($2) for denne egenskapen.',
	'smw_noboolean' => '«$1» gjenkjennes ikke som en Boolean-verdi (true/false).',
	'smw_true_words' => 'true,t,yes,y,ja,j,sant,s',
	'smw_false_words' => 'false,f,no,n,nei,usant,u',
	'smw_nofloat' => '«$1» er ikke et tall.',
	'smw_infinite' => 'Tall så store som «$1» støttes ikke.',
	'smw_unitnotallowed' => '"$1" er ikke definert som en lovlig måleenhet for denne egenskapen.',
	'smw_nounitsdeclared' => 'Ingen måleenhet ble definert for denne egenskapen.',
	'smw_novalues' => 'Ingen verdier angitt.',
	'smw_nodatetime' => 'Datoen «$1» ble ikke forstått.',
	'smw_toomanyclosing' => '«$1» opptrer for mange ganger i spørringen.',
	'smw_noclosingbrackets' => 'Bruken av «<nowiki>[[</nowiki>» i spørringen din ble ikke stengt av «]]».',
	'smw_misplacedsymbol' => 'Symbolet «$1» ble brukt på et sted hvor det ikke er nyttig.',
	'smw_unexpectedpart' => '«$1»-delen av spørringen var uforståelig.
Resultatene kan være uventede.',
	'smw_emptysubquery' => 'En underspørring har ingen gyldige betingelser.',
	'smw_misplacedsubquery' => 'En underspørring ble brukt på et sted hvor underspørringer ikke tillates.',
	'smw_valuesubquery' => 'Underspørringer støttes ikke for verdier av egenskapen «$1».',
	'smw_badqueryatom' => 'En del («<nowiki>[[…]]</nowiki>») av spørringen ble ikke forstått.',
	'smw_propvalueproblem' => 'Verdien av egenskapen «$1» ble ikke forstått.',
	'smw_noqueryfeature' => 'Noen spørringsfunksjoner ble ikke støttet i denne wikien, og deler av spørringen ble hoppet over ($1).',
	'smw_noconjunctions' => 'Konjunksjoner i spørringer støttes ikke i denne wikien, og deler av spørringen ble hoppet over ($1).',
	'smw_nodisjunctions' => 'Disjunksjoner i spørringer støttes ikke på denne wikien, og deler av spøringen ble utelatt ($1).',
	'smw_querytoolarge' => 'Følgende spørringsbetingelser kunne ikke tas til hensyn på grunn av wikiens begrensninger i spørringsstørrelse eller dybde: $1',
	'smw_notemplategiven' => 'Oppgi en verdi for parameteret «mal» for at dette spørringsformatet skal fungere.',
	'smw_db_sparqlqueryproblem' => 'Spørringen ga ikke noe resultat fra SPARQL-databasen. Denne feilen kan være midlertidig eller indikere en feil i database-programvaren.',
	'smw_db_sparqlqueryincomplete' => 'Det viste seg å være for vanskelig å gi et svar på spørringen og denne ble derfor avbrutt. Noen resultater kan mangle. Hvis mulig, bruk en enklere spørring.',
	'smw_type_header' => 'Egenskaper av typen «$1»',
	'smw_typearticlecount' => 'Viser {{PLURAL:$1|én egenskap|$1 egenskaper}} som bruker denne typen.',
	'smw_attribute_header' => 'Sider som bruker egenskapen «$1»',
	'smw_attributearticlecount' => 'Viser {{PLURAL:$1|én side|$1 sider}} som bruker denne egenskapen.',
	'smw_subproperty_header' => 'Underegenskaper',
	'smw_subpropertyarticlecount' => 'Denne egenskapen har følgende {{PLURAL:$|underegenskap|$1 underegenskaper}}:',
	'smw_concept_header' => 'Sider av konseptet «$1»',
	'smw_conceptarticlecount' => 'Viser {{PLURAL:$1|én side|$1 sider}} som hører til det konseptet.',
	'exportrdf' => 'Eksporter sider til RDF',
	'smw_exportrdf_docu' => 'Denne siden lar deg skaffe data fra en side i RDF-format.
Skriv inn titler i tekstboksten nedenfor for å eksportere sider, én tittel per linje.',
	'smw_exportrdf_recursive' => 'Eksporter alle relaterte sider rekursivt.
Merk at resultatet kan være stort.',
	'smw_exportrdf_backlinks' => 'Eksporter også alle sider som refererer til de eksporterte sidene.
Lager en RDF som kan gås gjennom.',
	'smw_exportrdf_lastdate' => 'Ikke eksporter sider som ikke ble endret siden gitte tidspunkt.',
	'smw_exportrdf_submit' => 'Eksporter',
	'uriresolver' => 'URI-løser',
	'properties' => 'Egenskaper',
	'smw_properties_docu' => 'Følgende egenskaper brukes på wikien.',
	'smw_property_template' => '$1 av type $2 ($3)',
	'smw_propertylackspage' => 'Alle egenskaper burde beskrives av en side.',
	'smw_propertylackstype' => 'Ingen type spesifisert for denne egenskapen (bruker foreløpig typen $1).',
	'smw_propertyhardlyused' => 'Denne egenskapen brukes nesten ikke på wikien.',
	'unusedproperties' => 'Ubrukte egenskaper',
	'smw_unusedproperties_docu' => 'Følgende egenskaper finnes, selv om ingen andre sider bruker dem.',
	'smw_unusedproperty_template' => '$1 av type $2',
	'wantedproperties' => 'Ønskede egenskaper',
	'smw_wantedproperties_docu' => 'Følgende egenskaper brukes på wikien, men har så langt ingen beskrivelsesside.',
	'smw_wantedproperty_template' => '$1 (brukt {{PLURAL:$2|én gang|$2 ganger}})',
	'smw_purge' => 'Gjenoppfrisk',
	'types' => 'Typer',
	'smw_types_docu' => 'Følgende er en liste over alle datatyper som kan knyttes til egenskaper.',
	'semanticstatistics' => 'Semantisk statistikk',
	'smw_semstats_text' => "Denne wikien inneholder {{PLURAL:$1|'''én''' egenskapsverdi|'''$1''' egenskapsverdier}} for totalt [[Special:Properties|{{PLURAL:$2|'''én''' egenskap|'''$2''' forskjellige egenskaper}}]].
{{PLURAL:$3|'''Én''' egenskap|'''$3''' egenskaper}} har en egen side, og den mente datatypen er spesifisert for '''$4''' av disse.
Enkelte av de eksisterende egenskapene kan være [[Special:UnusedProperties|ubrukte egenskaper]].
Egenskaper som fortsatt mangler en egen side finnes på [[Special:WantedProperties|listen over ønskede egenskaper]].",
	'smw_uri_doc' => 'URI-løseren implementerer <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">finning av W3C TAG-er på «httpRange-14»</a>.
Den sørger for at mennesker ikke gjøres til nettsteder.',
	'ask' => 'Semantisk søk',
	'smw_ask_sortby' => 'Sorter etter kolonne (valgfritt)',
	'smw_ask_ascorder' => 'Stigende',
	'smw_ask_descorder' => 'Synkende',
	'smw_ask_submit' => 'Finn resultater',
	'smw_ask_editquery' => '[Rediger spørring]',
	'smw_add_sortcondition' => '[Legg til sorteringsbetingelse]',
	'smw_ask_hidequery' => 'Skjul spørring',
	'smw_ask_help' => 'Spørringshjelp',
	'smw_ask_queryhead' => 'Spørring',
	'smw_ask_printhead' => 'Tilleggsdata kan vises',
	'smw_ask_printdesc' => '(legg til et egenskapsnavn per linje)',
	'smw_ask_format_as' => 'Formater som:',
	'smw_ask_defaultformat' => 'standard',
	'smw_ask_otheroptions' => 'Andre valgmuligheter',
	'smw_ask_show_embed' => 'Vis innkapslet kode',
	'smw_ask_hide_embed' => 'Skjul innkapslet kode',
	'smw_ask_embed_instr' => 'For å bygge inn denne spørringen i en wikiside, bruk koden nedenfor.',
	'querycreator' => 'Spørregenerator',
	'smw_qc_addmainlabel' => 'Legg til hovedledetekst',
	'smw_qc_show_addnal_opts' => 'Vis flere valgmuligheter',
	'smw_qc_hide_addnal_opts' => 'Vis færre valgmuligheter',
	'smw_qc_otheropt' => 'Andre valgmuligheter',
	'smw_qc_intro' => 'Innledningstekst:',
	'smw_qc_outro' => 'Avslutningstekst:',
	'smw_qc_default' => 'Tomspørringstekst:',
	'smw_qc_formatopt' => 'Formatvalg',
	'smw_qc_query_help' => 'Legg inn en spørring ved hjelp av skjemaet under. Velg wikisider basert på
Kategorier (<strong>[[{{ns:category}}:Actor]]</strong>), 
Egenskaper (<strong>[[Located in::Germany]]</strong>), 
Navn (<strong>[[Germany]]</strong>) og navnerom (<strong>[[{{ns:help}}:+]]</strong>)', # Fuzzy
	'smw_qui_property' => '<strong>Egenskap</strong>',
	'smw_qui_prop' => 'Egenskap:',
	'smw_qui_labl' => 'Ledetekst:',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Grense:',
	'smw_qui_shownresults' => 'vis i resultater',
	'smw_qui_noquery' => 'Ingen spørring er angitt',
	'smw_qui_invalidprop' => '" $1 " er kanskje ikke en gyldig egenskap',
	'smw_qui_invalidformat' => '↓Det valgte formatet "$1" finnes ikke i denne wikien',
	'smw_qui_nosort' => 'Ingen sortering',
	'smw_qui_ascorder' => 'Stigende',
	'smw_qui_descorder' => 'Synkende',
	'smw_qui_randorder' => 'Tilfeldig',
	'smw_qui_addnprop' => 'legg til egenskap',
	'smw_qui_delete' => 'Fjern',
	'smw_qui_rescol' => 'Treff på spørringen',
	'smw_qui_options' => 'valgmuligheter',
	'smw_qui_addcategory' => 'legg til kategori',
	'smw_qui_addrescol' => 'legg til treff på spørring',
	'smw_qui_ok' => 'Ok-knapp',
	'smw_qui_cancel' => 'Avbryt',
	'smw_qui_category' => '<strong>Kategori</strong>',
	'smw_qui_label' => 'Ledetekst:',
	'smw_prp_options' => 'Valgmuligheter for egenskap',
	'smw_qui_catopts' => 'Valgmuligheter for kategori',
	'smw_qui_mainlabopts' => 'Valgmuligheter for resultat',
	'smw_qui_dlabel' => 'Ledetekst:',
	'smw_qui_dcategory' => 'Kategori:',
	'smw_qui_dcatyes' => 'Vis tekst når kategori er til stede',
	'smw_qui_dcatno' => 'Vis tekst når kategori ikke er fraværende:',
	'searchbyproperty' => 'Søk etter egenskap',
	'smw_sbv_docu' => 'Søk etter alle sider som har en gitt egenskap og verdi.',
	'smw_sbv_novalue' => 'Skriv inn en gyldig verdi for egenskapen, eller vis alle egenskapsverdier for «$1».',
	'smw_sbv_displayresult' => 'En liste over alle sider som har egenskapen «$1» med verdien «$2»',
	'smw_sbv_displayresultfuzzy' => 'En liste over alle sider som har egenskapen «$1» med verdien «$2».
Siden det bare ble noen få resultater, vises også nære verdier.',
	'smw_sbv_property' => 'Egenskap:',
	'smw_sbv_value' => 'Verdi:',
	'smw_sbv_submit' => 'Finn resultater',
	'browse' => 'Bla gjennom wikien',
	'smw_browselink' => 'Bla gjennom egenskaper',
	'smw_browse_article' => 'Skriv inn navnet på siden du vil starte å bla fra.',
	'smw_browse_go' => 'Gå',
	'smw_browse_show_incoming' => 'vis egenskaper som lenker hit',
	'smw_browse_hide_incoming' => 'skjul egenskaper som lenker hit',
	'smw_browse_no_outgoing' => 'Denne siden har ingen egenskaper.',
	'smw_browse_no_incoming' => 'Ingen egenskaper lenker til denne siden.',
	'smw_inverse_label_default' => '$1 av',
	'smw_inverse_label_property' => 'Invers egenskapsmerkelapp',
	'pageproperty' => 'Sideegenskapssøk',
	'smw_pp_docu' => 'Søk etter alle egenskapsverdier på en gitt side.
Skriv inn både sidenavn og egenskap.',
	'smw_pp_from' => 'Fra side',
	'smw_pp_type' => 'Egenskap',
	'smw_pp_submit' => 'Finn resultater',
	'smw_result_prev' => 'Forrige',
	'smw_result_next' => 'Neste',
	'smw_result_results' => 'Resultater',
	'smw_result_noresults' => 'Beklager, ingen resultater funnet',
	'smwadmin' => 'Administratorfunksjoner for Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Lagringsmotoren ble vellykket initialisert.',
	'smw_smwadmin_return' => 'Gå tilbake til $1',
	'smw_smwadmin_updatestarted' => 'En ny oppdateringsprosess for oppfriskning av de semantiske dataene ble startet.
Alle lagrede data vil bli bygd på nytt eller reparert der det trengs.
Du kan følge med på fremgangen til oppdateringen på denne spesialsiden.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Det kjører allerede en oppdateringsprosess.
Starter derfor ikke enda en.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Alle eksisterende oppdateringsprosesser har blitt stoppet.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'For å stoppe den kjørende oppdateringsprosessen må du markere avkrysningsboksen for å vise at du er helt sikker.', # Fuzzy
	'smw_smwadmin_docu' => 'Denne spesialsiden hjelper deg under innstallasjon og oppgradering av <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Husk å ta sikkerhetskopier av viktige data før du starter administrerende funksjoner.',
	'smw_smwadmin_db' => 'Databaseinstallering og -oppgradering',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki krever noen utvidelser i MediaWiki-databasen for å kunne lagre semantiske data.
Funksjonen under sikrer at databasen din blir satt opp riktig.
Endringene gjort i dette steget har ingen effekt på resten av MediaWiki-databasen og kan enkelt gjøres om om ønskelig.
Denne initialiseringsfunksjonen kan bli kjørt flere ganger uten skadevirkning, men den trenger kun kjøres en gang ved installering eller oppgradering.',
	'smw_smwadmin_permissionswarn' => 'Dersom operasjonen mislykkes med SQL-feil, har databasebrukeren anvendt av din wiki sannsynligvis manglende rettigheter (sjekk LocalSettings.php).
Enten må denne brukeren gis tilstrekkelige rettigheter til å opprette og slette tabeller, eller en må midlertidig skrive inn innloggingsinformasjonen til database-roten i LocalSettings.php, eller en må bruke vedlikeholdsskriptet <tt>SMW_setup.php</tt> som har rettighetene til AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Initialiser eller oppgrader tabeller',
	'smw_smwadmin_announce' => 'Kunngjør din wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki har en nettjeneste for kunngjøring av nye semantiske wikisider.
Dette er brukt for å opprettholde en liste over offentlige nettsteder som bruker Semantic MediaWiki, hovedsaklig for å hjelpe <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki</a> med å få et overblikk over typiske bruksområder av Semantic MediaWiki.
Se hjemmesiden til Semantic MediaWiki for <a href="http://semantic-mediawiki.org/wiki/Registry">mer informasjon om denne tjenesten</a>.',
	'smw_smwadmin_announcebutton' => 'Trykk på følgende knapp for å oppgi din wikis URL til den tjenesten.
Tjenesten vil ikke registrere wikier som ikke er offentlig tilgjengelig, og den vil bare lagre offentlig tilgjengelig informasjon.',
	'smw_smwadmin_datarefresh' => 'Datareparering og -oppgradering',
	'smw_smwadmin_datarefreshdocu' => 'Det er mulig å gjenopprette alle Semantic MediaWiki-data basert på det nåværende innholdet på wikien.
Dette kan være nyttig for å reparere ødelagte data eller for å oppfriske data hvis det interne formatet har blitt endret på grunn av programvareoppdateringer.
Oppdateringen blir utført side for side og vil ikke bli fullført umiddelbart.
Det følgende viser om en oppdatering er i gang og lar deg starte eller stoppe oppdateringer (ved mindre denne muligheten er gjort utilgjengelig av sidens administratorer).',
	'smw_smwadmin_datarefreshprogress' => '<strong>En oppdatering er allerede i gang.</strong>
Det er normalt at oppdateringen går tregt fremover siden den bare oppdaterer data i små biter hver gang en bruker besøker wikien.
For å fullføre denne oppdateringen raskere kan du starte MediaWiki-vedlikeholdsskriptet <tt>runJobs.php</tt> (bruk valget <tt>--maxjobs 1000</tt> for å avgrense antallet oppdateringer som gjøres sammenhengende).
Anslått fremdrift for gjeldende oppdatering:',
	'smw_smwadmin_datarefreshbutton' => 'Start oppdatering av data',
	'smw_smwadmin_datarefreshstop' => 'Stopp denne oppdateringen',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, jeg er sikker.',
	'smw_smwadmin_support' => 'Få støtte',
	'smw_smwadmin_supportdocu' => 'Følgende ressurser kan kanskje hjelpe deg om du skulle ha problemer:',
	'smw_smwadmin_installfile' => 'Hvis du opplever problemer med installeringen, start med å sjekke retningslinjene i <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL-filen</a>.',
	'smw_smwadmin_smwhomepage' => 'Den komplette brukerdokumentasjonen til Semantic MediaWiki finnes på <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Feil kan rapporteres til <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Hvis du har ytterligere spørsmål eller forslag, bli med i diskusjonen på <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki brukerforum</a>.',
	'smw_adminlinks_datastructure' => 'Datastruktur',
	'smw_adminlinks_displayingdata' => 'Datavisning',
	'smw_adminlinks_inlinequerieshelp' => 'Hjelp for innebygde spørringer',
	'smw-createproperty-isproperty' => 'Dette er en egenskap av type $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Den tillatte verdien|De tillatte verdiene}} for denne egenskapen er:',
	'smw-paramdesc-category-delim' => 'Skilletegnet',
	'smw-paramdesc-category-template' => 'En mal til bruk for å formatere elementene',
	'smw-paramdesc-category-userparam' => 'En parameter som gis til malen',
	'smw-info-par-message' => 'Melding å vise frem.',
	'smw-info-par-icon' => 'Ikon for å vise frem enten "info" eller "advarsel".',
	'smw_unknowntype' => 'Typen «$1» som er definert for egenskapen støttes ikke.', # Fuzzy
);

/** Niuean (ko e vagahau Niuē)
 * @author Jose77
 */
$messages['niu'] = array(
	'smw_browse_go' => 'Fano',
);

/** Dutch (Nederlands)
 * @author Kghbln
 * @author Rcdeboer
 * @author SPQRobin
 * @author Saruman
 * @author Siebrand
 * @author Tjcool007
 * @author Wiki13
 */
$messages['nl'] = array(
	'smw-desc' => "Maakt uw wiki toegankelijker - voor machines ''en'' mensen ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentatie])",
	'smw_viewasrdf' => 'RDF-feed',
	'smw_finallistconjunct' => ', en',
	'smw_factbox_head' => 'Feiten over $1',
	'smw_isspecprop' => 'Dit is een speciale eigenschap in de wiki.',
	'smw_concept_description' => 'Beschrijving van het concept "$1"',
	'smw_no_concept_namespace' => "Concepten kunnen alleen gedefinieerd worden op pagina's in de naamruimte Concept:",
	'smw_multiple_concepts' => 'Iedere conceptpagina kan maar één conceptdefinitie bevatten.',
	'smw_concept_cache_miss' => 'Het concept "$1" kan op het moment niet gebruikt worden omdat de dit volgende de instellingen van de wiki offline berekend moet worden.
Als het probleem over enige tijd nog niet verholpen is, vraag de beheerder dan om dit concept beschikbaar te maken.',
	'smw_noinvannot' => 'Waarden kunnen niet toegekend worden aan omgekeerde eigenschappen.',
	'version-semantic' => 'Semantische uitbreidingen',
	'smw_baduri' => 'URI\'s uit de reeks "$1" zijn hier niet beschikbaar.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Resultaten tellen',
	'smw_printername_csv' => 'Naar CSV exporteren',
	'smw_printername_dsv' => 'Naar DSV exporteren',
	'smw_printername_debug' => 'Query debuggen (voor experts)',
	'smw_printername_embedded' => 'Paginainhoud insluiten',
	'smw_printername_json' => 'Naar JSON exporteren',
	'smw_printername_list' => 'Lijst',
	'smw_printername_ol' => 'Opsomming',
	'smw_printername_ul' => 'Itemisatie',
	'smw_printername_table' => 'Tabel',
	'smw_printername_broadtable' => 'Brede tabel',
	'smw_printername_template' => 'Sjabloon',
	'smw_printername_rdf' => 'Naar RDF exporteren',
	'smw_printername_category' => 'Categorie',
	'validator-type-class-SMWParamSource' => 'tekst',
	'smw-paramdesc-limit' => 'Het maximaal aantal weer te geven resultaten',
	'smw-paramdesc-offset' => 'De resultaatpositie van het eerste resultaat',
	'smw-paramdesc-headers' => 'De namen van koppen en eigenschappen weergeven',
	'smw-paramdesc-mainlabel' => 'Het label voor de hoofdpaginanaam',
	'smw-paramdesc-link' => 'Waarden als verwijzingen weergeven',
	'smw-paramdesc-intro' => 'De tekst die wordt weergegeven boven de zoekresultaten, als die er zijn',
	'smw-paramdesc-outro' => 'De tekst die wordt weergegeven onder de zoekresultaten, als die er zijn',
	'smw-paramdesc-default' => 'De tekst die wordt weergegeven als er geen zoekresultaten zijn',
	'smw-paramdesc-sep' => 'Het scheidingsteken voor waarden',
	'smw-paramdesc-showsep' => 'Toon het scheidingsteken bovenaan het CSV-bestand ("sep =<value>")',
	'smw-paramdesc-distribution' => 'Geef het aantal waarden weer in plaats van alle waarden.',
	'smw-paramdesc-distributionsort' => 'De waardeverdeling sorteren op aantal keer dat die voorkomt.',
	'smw-paramdesc-distributionlimit' => 'Beperk de waardeverdeling tot het aantal van sommige waarden.',
	'smw-paramdesc-template' => 'De naam van de sjabloon waar de afdrukken mee worden weergegeven',
	'smw-paramdesc-columns' => 'Het aantal kolommen om resultaten in weer te geven (standaard $1)',
	'smw-paramdesc-userparam' => 'Een aan iedere sjabloon doorgegeven waarde als een sjabloon wordt gebruikt',
	'smw-paramdesc-introtemplate' => 'De naam van een weer te geven sjabloon voor de zoekresultaten als die er zijn',
	'smw-paramdesc-outrotemplate' => 'De naam van een weer te geven sjabloon na de zoekresultaten als die er zijn',
	'smw-paramdesc-embedformat' => 'Het HTML-label voor de koptekstdefinities',
	'smw-paramdesc-embedonly' => 'Geen koppen weergeven',
	'smw-paramdesc-table-class' => 'Een extra CSS-klasse om in te stellen voor de tabel',
	'smw-paramdesc-rdfsyntax' => 'De te gebruiken RDF-syntaxis',
	'smw-paramdesc-csv-sep' => 'Het te gebruiken scheidingsteken',
	'smw-paramdesc-dsv-separator' => 'Het te gebruiken scheidingsteken',
	'smw-paramdesc-dsv-filename' => 'De naam voor het DSV-bestand',
	'smw-smwdoc-description' => 'Geeft een tabel weer met alle parameters die kunnen worden gebruikt met de opgegeven resultaatopmaak samen met standaardwaarden en beschrijvingen.',
	'smw-smwdoc-par-format' => 'De resultaatopmaak waarvoor parameterdocumentatie weergegeven moet worden.',
	'smw-smwdoc-par-parameters' => 'Welke parameters weer te geven. "specific" voor parameters toegevoegd door de opmaak, "base" voor de parameteres die beschikbaar zijn in alle opmaken, en "alle" voor beiden.',
	'smw-paramdesc-sort' => 'Eigenschap om de zoekopdracht op te sorteren',
	'smw-paramdesc-order' => 'Sorteervolgorde',
	'smw-paramdesc-searchlabel' => 'Tekst voor de voortzetting van de zoekopdracht',
	'smw-paramdesc-named_args' => 'Naam voor de aan de sjabloon door te geven parameters',
	'smw-paramdesc-export' => 'Exportoptie',
	'smw-paramdesc-prettyprint' => 'Een netjes opgemaakte uitvoer inschakelen die tabs en nieuwe regels toevoegt',
	'smw-paramdesc-source' => 'Alternatieve zoekopdrachtbron',
	'smw-paramdesc-jsonsyntax' => 'Te gebruiken JSON-syntaxis',
	'smw-printername-feed' => 'RSS- en Atom-feed',
	'smw-paramdesc-feedtype' => 'Feedtype',
	'smw-paramdesc-feedtitle' => 'De tekst die dient te worden gebruikt voor de titel van de feed',
	'smw-paramdesc-feeddescription' => 'De tekst die dient te worden gebruikt voor de beschrijving van de feed',
	'smw-paramdesc-feedpagecontent' => 'In de feed weer te geven paginainhoud',
	'smw-label-feed-description' => 'Feed van type $2: $1',
	'smw_iq_disabled' => 'Zoekopdrachten binnen tekst zijn uitgeschakeld in deze wiki.',
	'smw_iq_moreresults' => '… overige resultaten',
	'smw_parseerror' => 'De opgegeven waarde is niet begrepen.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" kan niet gebruikt worden als paginanaam.',
	'smw_noproperty' => '"$1" kan niet gebruikt worden als eigenschapsnaam in deze wiki.',
	'smw_wrong_namespace' => 'Hier zijn alleen pagina\'s uit de naamruimte "$1" toegestaan.',
	'smw_manytypes' => 'Meer dan één type gedefinieerd voor eigenschap.',
	'smw_emptystring' => 'Lege strings zijn niet toegestaan.',
	'smw_maxstring' => 'De stringrepresentatie $1 is te lang.',
	'smw_notinenum' => '"$1" komt niet voor in de lijst met mogelijke waarden ($2) voor deze eigenschap.',
	'smw_noboolean' => '"$1" is niet herkend als een booleaanse waarde (waar/onwaar).',
	'smw_true_words' => 'waar,w,ja,j,true',
	'smw_false_words' => 'onwaar,o,nee,n,false',
	'smw_nofloat' => '"$1" is geen getal.',
	'smw_infinite' => 'Getallen zo groot als "$1" worden niet ondersteund.',
	'smw_unitnotallowed' => '"$1" is niet ingesteld als een geldige meeteenheid voor deze eigenschap.',
	'smw_nounitsdeclared' => 'Er zijn geen meeteenheden aangegeven voor deze eigenschap.',
	'smw_novalues' => 'Geen waarden opgegeven.',
	'smw_nodatetime' => 'De datum "$1" kon niet verwerkt worden.',
	'smw_toomanyclosing' => '"$1" lijkt te vaak voor te komen in de zoekopdracht.',
	'smw_noclosingbrackets' => 'In uw zoekopdracht is het gebruik van "<nowiki>[[</nowiki>" niet gesloten door een bijbehorende "]]".',
	'smw_misplacedsymbol' => 'Het symbool "$1" is gebruikt op een plaats waar het niet gebruikt hoort te worden.',
	'smw_unexpectedpart' => 'Het deel "$1" van de zoekopdracht is niet begrepen.
De resultaten kunnen afwijken van de verwachting.',
	'smw_emptysubquery' => 'Er is een subzoekopdracht met een onjuiste conditie.',
	'smw_misplacedsubquery' => 'Er is een subzoekopdracht gebruikt op een plaats waar subzoekopdrachten niet gebruikt mogen worden.',
	'smw_valuesubquery' => 'Subzoekopdrachten worden niet ondersteund voor waarden van de eigenschap "$1".',
	'smw_badqueryatom' => 'Een onderdeel "<nowiki>[[…]]</nowiki>" van de zoekopdracht is niet begrepen.',
	'smw_propvalueproblem' => 'De waarde van eigenschap "$1" is niet begrepen.',
	'smw_noqueryfeature' => 'Een bepaalde vraagoptie wordt niet ondersteund in deze wiki en een deel van de zoekopdracht is genegeerd ($1).',
	'smw_noconjunctions' => 'Verbindingen in zoekopdrachten worden in deze wiki niet ondersteund en een deel van de zoekopdracht is genegeerd ($1).',
	'smw_nodisjunctions' => 'Scheidingen in zoekopdrachten worden niet ondersteund in deze wiki, dus een deel van de zoekopdracht is genegeerd ($1).',
	'smw_querytoolarge' => 'De volgende zoekopdrachtcondities zijn niet in acht genomen vanwege beperkingen in de grootte of diepte van zoekopdrachten in deze wiki: $1.',
	'smw_notemplategiven' => 'Geef een waarde voor de parameter "sjabloon" op om deze zoekopdracht te laten werken.',
	'smw_db_sparqlqueryproblem' => 'Er is geen antwoord op de zoekopdracht gekomen uit de SPARQL-database. Deze fout kan tijdelijk zijn of wijzen op een bug in de databasesoftware.',
	'smw_db_sparqlqueryincomplete' => 'De zoekopdracht beantwoorden bleek te moeilijk en deze is afgebroken. Sommige resultaten kunnen ontbreken. Probeer een eenvoudigere zoekopdracht te gebruiken.',
	'smw_type_header' => 'Eigenschappen van het type "$1"',
	'smw_typearticlecount' => 'Er {{PLURAL:$1|is $1 eigenschap die gebruik maakt|zijn $1 eigenschappen die gebruik maken}} van dit type.',
	'smw_attribute_header' => 'Pagina\'s die de eigenschap "$1" gebruiken',
	'smw_attributearticlecount' => "Er {{PLURAL:$1|is $1 pagina die deze eigenschap gebruikt|zijn $1 pagina's die deze eigenschappen gebruiken}}.",
	'smw_subproperty_header' => 'Subeigenschappen',
	'smw_subpropertyarticlecount' => 'Deze eigenschap heeft de volgende $1 {{PLURAL:$1|subeigenschap|subeigenschappen}}:',
	'smw_concept_header' => 'Pagina\'s met het concept "$1"',
	'smw_conceptarticlecount' => "$1 {{PLURAL:$1|pagina|pagina's}} die bij dat concept {{PLURAL:$1|hoort|horen}} worden weergegeven.",
	'exportrdf' => "Pagina's exporteren naar RDF",
	'smw_exportrdf_docu' => "Deze pagina maakt het mogelijk gegevens te verkrijgen van een pagina in RDF-formaat.
Voer in het onderstaande invoerveld paginanamen in om pagina's te exporteren.
Iedere paginanaam op een eigen regel.",
	'smw_exportrdf_recursive' => "Alle gerelateerde pagina's recursief exporteren.
Het resultaat kan groot zijn!",
	'smw_exportrdf_backlinks' => "Ook alle pagina's exporteren die verwijzen naar de te exporteren pagina's.
Genereert door te bladeren RDF.",
	'smw_exportrdf_lastdate' => "Pagina's die sinds het opgegeven punt niet gewijzigd zijn niet exporteren.",
	'smw_exportrdf_submit' => 'Exporteren',
	'uriresolver' => 'URI-resolver',
	'properties' => 'Eigenschappen',
	'smw_properties_docu' => 'De volgende eigenschappen worden in de wiki gebruikt.',
	'smw_property_template' => '$1 van type $2 ($3 keer {{PLURAL:$3|gebruikt}})',
	'smw_propertylackspage' => 'Alle eigenschappen moeten op een pagina beschreven worden!',
	'smw_propertylackstype' => 'Er is geen type opgegeven voor deze eigenschap (type $1 wordt verondersteld).',
	'smw_propertyhardlyused' => 'Deze eigenschap wordt vrijwel niet gebruikt in de wiki.',
	'unusedproperties' => 'Ongebruikte eigenschappen',
	'smw_unusedproperties_docu' => 'De volgende eigenschappen bestaan, hoewel ze niet gebruikt worden.',
	'smw_unusedproperty_template' => '$1 van type $2',
	'wantedproperties' => 'Gewenste eigenschappen',
	'smw_wantedproperties_docu' => 'De volgende eigenschapen worden gebruikt in de wiki, maar hebben geen pagina waarop ze worden beschreven.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|keer|keren}} gebruikt)',
	'smw_purge' => 'Verversen',
	'types' => 'Typen',
	'smw_types_docu' => 'Hieronder staat een lijst van alle gegevenstypen die aan eigenschappen kunnen worden toegewezen.',
	'semanticstatistics' => 'Semantische statistieken',
	'smw_semstats_text' => "Deze wiki bevat '''$1''' {{PLURAL:$1|eigenschapwaarde|eigenschapwaarden}} voor '''$2''' verschillende [[Special:Properties|{{PLURAL:$2|eigenschap|verschillende eigenschappen}}]].
'''$3''' {{PLURAL:$3|eigenschap heeft|eigenschappen hebben}} een eigen pagina en het gegevenstype is voor '''$4''' daarvan aangegeven.
Een aantal van de bestaande eigenschappen is wellicht [[Special:UnusedProperties|ongebruikt]].
Eigenschappen waar nog geen pagina voor is zijn te vinden op de [[Special:WantedProperties|lijst met gewenste eigenschappen]].",
	'smw_uri_doc' => 'De URI-resolver implementeert de [$1 W3C TAG finding on httpRange-14].
Dit zorgt ervoor dat mensen niet veranderen in websites.',
	'ask' => 'Semantisch zoeken',
	'smw_ask_sortby' => 'Sorteren op kolom (optioneel)',
	'smw_ask_ascorder' => 'Oplopend',
	'smw_ask_descorder' => 'Aflopend',
	'smw_ask_submit' => 'Resultaten zoeken',
	'smw_ask_editquery' => '[zoekopdracht bewerken]',
	'smw_add_sortcondition' => '[sorteervoorwaarde toevoegen]',
	'smw_ask_hidequery' => 'Zoekopdracht verbergen',
	'smw_ask_help' => 'Hulp bij zoekopdrachten',
	'smw_ask_queryhead' => 'Zoekopdracht',
	'smw_ask_printhead' => 'Overige weer te geven gegevens',
	'smw_ask_printdesc' => '(voeg één eigenschapsnaam per regel toe)',
	'smw_ask_format_as' => 'Opmaken als:',
	'smw_ask_defaultformat' => 'standaard',
	'smw_ask_otheroptions' => 'Overige opties',
	'smw-ask-otheroptions-info' => 'Dit onderdeel bevat opties die de uitvoer wijzigen. Parameterbeschrijvingen zijn zichtbaar door er met de muisaanwijzer overeen te bewegen.',
	'smw-ask-otheroptions-collapsed-info' => 'Gebruik het "plusicoon" om alle beschikbaar opties te bekijken',
	'smw_ask_show_embed' => 'Ingesloten code weergeven',
	'smw_ask_hide_embed' => 'Ingesloten code verbergen',
	'smw_ask_embed_instr' => 'Gebruik de onderstaande code om deze zoekopdracht op te nemen in een wikipagina.',
	'smw-ask-delete' => '[Verwijderen]',
	'smw-ask-sorting' => 'Sortering',
	'smw-ask-format-selection-help' => 'Bezoek de hulppagina $1 voor een gedetailleerde beschrijving.',
	'querycreator' => 'Zoekopdrachtenmaker',
	'smw_qc_addmainlabel' => 'Hoofdlabel toevoegen',
	'smw_qc_show_addnal_opts' => 'Meer opties weergeven',
	'smw_qc_hide_addnal_opts' => 'Minder opties weergeven',
	'smw_qc_otheropt' => 'Overige instellingen',
	'smw_qc_intro' => 'Introductie:',
	'smw_qc_outro' => 'Afsluiting:',
	'smw_qc_default' => 'Standaard:',
	'smw_qc_formatopt' => 'Opmaakinstellingen',
	'smw_qc_query_help' => 'Maak een zoekopdracht met het onderstaande formulier.
Selecteer pagina op basis van
Categorieën (<strong>[[{{ns:category}}:Acteur]]</strong>),
Eigenschappen (<strong>[[Gelegen in::Duitsland]]</strong>),
Namen (<strong>[[Duitsland]]</strong>) en
Naamruimten (<strong>[[{{ns:help}}:+]]</strong>)',
	'smw_qui_property' => '<strong>Eigenschap</strong>',
	'smw_qui_prop' => 'Eigenschap:',
	'smw_qui_labl' => 'Label:',
	'smw_qui_formt' => 'Opmaak:',
	'smw_qui_limt' => 'Limiet:',
	'smw_qui_shownresults' => 'weergeven in resultaten',
	'smw_qui_noquery' => 'Er is geen zoekopdracht opgegeven',
	'smw_qui_invalidprop' => '"$1" is mogelijk een ongeldige eigenschap',
	'smw_qui_invalidformat' => 'Het gekozen opmaak "$1" bestaat niet voor deze wiki',
	'smw_qui_nosort' => 'Niet sorteren',
	'smw_qui_ascorder' => 'Oplopend',
	'smw_qui_descorder' => 'Aflopend',
	'smw_qui_randorder' => 'Willekeurig',
	'smw_qui_addnprop' => 'eigenschap toevoegen',
	'smw_qui_delete' => 'Verwijderen',
	'smw_qui_rescol' => 'Zoekopdachtresultaten',
	'smw_qui_options' => 'instellingen',
	'smw_qui_addcategory' => 'categorie toevoegen',
	'smw_qui_addrescol' => 'zoekresultaten toevoegen',
	'smw_qui_ok' => 'OK',
	'smw_qui_cancel' => 'Annuleren',
	'smw_qui_category' => '<strong>Annuleren</strong>',
	'smw_qui_label' => 'Label',
	'smw_prp_options' => 'Eigenschapsinstellingen',
	'smw_qui_catopts' => 'Categoriemogelijkheden',
	'smw_qui_mainlabopts' => 'Resultaatopties',
	'smw_qui_dlabel' => 'Label:',
	'smw_qui_dcategory' => 'Categorie:',
	'smw_qui_dcatyes' => 'Weer te geven tekst als de categorie aanwezig is:',
	'smw_qui_dcatno' => 'Weer te geven tekst als categorie niet aanwezig is:',
	'searchbyproperty' => 'Op eigenschap zoeken',
	'smw_sbv_docu' => "Alle pagina's zoeken die een bepaalde eigenschap en waarde hebben.",
	'smw_sbv_novalue' => 'Voer een geldige waarde in voor de eigenschap, of bekijk alle waarden voor eigenschap "$1."',
	'smw_sbv_displayresult' => 'Een lijst met alle pagina\'s waarop eigenschap "$1" de waarde "$2" heeft',
	'smw_sbv_displayresultfuzzy' => 'Een lijst van alle pagina\'s met de eigenschap "$1" met waarde "$2".
Omdat er een beperkt aantal resultaten is, worden ook nabije waarden weergegeven.',
	'smw_sbv_property' => 'Eigenschap:',
	'smw_sbv_value' => 'Waarde:',
	'smw_sbv_submit' => 'Resultaten zoeken',
	'browse' => 'Wiki bekijken',
	'smw_browselink' => 'Eigenschappen bekijken',
	'smw_browse_article' => 'Voer de naam in van de pagina waar u met browsen wilt beginnen.',
	'smw_browse_go' => 'OK',
	'smw_browse_show_incoming' => 'eigenschappen weergeven die hierheen verwijzen',
	'smw_browse_hide_incoming' => 'eigenschappen verbergen die hierheen verwijzen',
	'smw_browse_no_outgoing' => 'Deze pagina heeft geen eigenschappen.',
	'smw_browse_no_incoming' => 'Er verwijzen geen eigenschappen naar deze pagina.',
	'smw_inverse_label_default' => '$1 van',
	'smw_inverse_label_property' => 'Tegenovergesteld eigenschapslabel',
	'pageproperty' => 'Paginaeigenschap zoeken',
	'smw_pp_docu' => 'Zoek naar alle fillers voor een eigenschap op een gegeven pagina.
Voer zowel een pagina als een eigenschap in.',
	'smw_pp_from' => 'Van pagina',
	'smw_pp_type' => 'Eigenschap',
	'smw_pp_submit' => 'Resultaten zoeken',
	'smw_result_prev' => 'Vorige',
	'smw_result_next' => 'Volgende',
	'smw_result_results' => 'Resultaten',
	'smw_result_noresults' => 'Geen resultaten.',
	'smwadmin' => 'Administratieve functies voor Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'De opslag is ingesteld.',
	'smw_smwadmin_return' => 'Terug naar $1',
	'smw_smwadmin_updatestarted' => 'Er is een proces gestart voor het bijwerken van de semantische gegevens.
Alle opgeslagen gegevens worden opnieuw opgebouwd of gerepareerd als dat nodig is.
U kunt de voortgang volgen via deze speciale pagina.

Terug naar $1.',
	'smw_smwadmin_updatenotstarted' => 'Er loopt al een bijwerkproces.
Er wordt geen nieuw proces gestart.

Terug naar $1.',
	'smw_smwadmin_updatestopped' => 'Alle lopende bijwerkprocessen zijn afgebroken.

Terug naar $1.',
	'smw_smwadmin_updatenotstopped' => 'Om de lopende processen te stoppen, moet u het vinkje inschakelen om aan te geven dat u het zeker weet.

Terug naar $1.',
	'smw_smwadmin_docu' => 'Deze speciale pagina assisteert u tijdens de installatie en het bijwerken van <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Denk eraan een back-up te maken van uw waardevolle gegevens voordat u beheershandelingen uitvoert.',
	'smw_smwadmin_db' => 'Database installeren en bijwerken',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki heeft een aantal uitbreidingen aan de database van MediaWiki nodig om de semantische gegevens op te kunnen slaan.
De onderstaande functionaliteit zorgt ervoor dat uw database juist is ingesteld.
De wijzigingen die in deze stap worden gemaakt, hebben geen invloed op de bestaande database van MediaWiki, en zijn eventueel eenvoudig ongedaan te maken.
Deze instelfunctie kan meerdere keren worden uitgevoerd zonder schade aan te richten, hoewel het uiteraard slechts noodzakelijk is deze een keer uit te voeren per installatie of upgrade.',
	'smw_smwadmin_permissionswarn' => 'Als de handeling mislukt en er SQL-foutmeldingen worden weergegeven, heeft de databasegebruiker van uw wiki waarschijnlijk onvoldoende rechten (zie LocalSettings.php).
Geef deze gebruiker de benodigde extra rechten om tabellen aan te maken en te verwijderen, zet tijdelijk de aanmeldgegevens van de hoofdgebruiker (root) van uw databasesysteem in LocalSettings.php, of gebruik het beheerscript <tt>SMW_setup.php</tt> dat de gebruikersnaam en wachtwoord van een beheerder kan gebruiken.',
	'smw_smwadmin_dbbutton' => 'Tabellen initialiseren of bijwerken',
	'smw_smwadmin_announce' => 'Uw wiki aankondigen',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki heeft een webservice voor het aankondigen van nieuwe semantische wikisites.
Deze dienst wordt gebruikt om een lijst bij te houden van publiek toegankelijke sites die Semantic MediaWiki gebruiken, voornamelijk om het <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki-project</a> inzicht te geven in het typische gebruik van Semantic MediaWiki.
Op de homepage van Semantic MediaWiki staat <a href="http://semantic-mediawiki.org/wiki/Registry">meer informatie over deze dienst</a>.',
	'smw_smwadmin_announcebutton' => "Klik op de knop om de URL van uw wiki naar de dienst te sturen.
De dienst registreert geen wiki's die niet publiek toegankelijk zijn en slaat alleen publiek toegankelijke informatie op.",
	'smw_smwadmin_datarefresh' => 'Gegevens repareren en bijwerken',
	'smw_smwadmin_datarefreshdocu' => 'Het is mogelijk om alle gegevens van Semantic MediaWiki opnieuw te genereren op basis van de huidige inhoud van de wiki.
Dit kan handig zijn om gegevens te repareren of de gegevens te verversen als de interne opmaak gewijzigd is bij een softwareupdate.
De gegevens worden pagina voor pagina bijgewerkt en het kan enige tijd duren voor de taak is afgerond.
Hieronder wordt weergegeven of er op dit moment een taak loopt en stelt u in staat een taak te stoppen of te starten (tenzij deze mogelijkheid door de sitebeheerder is uitgeschaked).',
	'smw_smwadmin_datarefreshprogress' => "<strong>Er loopt een bijwerktaak</strong>
Het is normaal dat de voortgang langzaam is omdat de gegevens ververst worden in kleine porties iedere keer als een gebruiker de wiki raadpleegt.
Om het bijwerken sneller te laten verlopen, kunt u het beheerscript <tt>runJobs.php</tt> draaien. Gebruik de optie <tt>--maxjobs 1000</tt> om aan het aantal bij te werken pagina's per handeling te beperken.
Geschatte voortgang van de huidige taak:",
	'smw_smwadmin_datarefreshbutton' => 'Gegevens bijwerken',
	'smw_smwadmin_datarefreshstop' => 'Bijwerken afbreken',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, ik weet het zeker.',
	'smw_smwadmin_support' => 'Ondersteuning krijgen',
	'smw_smwadmin_supportdocu' => 'Een aantal bronnen kunnen u ondersteunen als u problemen ondervindt:',
	'smw_smwadmin_installfile' => 'Als u problemen ondervindt bij uw installatie, controleer dan de richlijnen in het bestand <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'De volledige gebruikersdocumentatie voor Semantic MediaWiki is te vinden op <b><a href="http://semantic-mediawiki.org/wiki/Semantic_MediaWiki_-_startpagina">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Problemen en suggesties kunt u rapporteren in <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Als u verdere vragen of suggesties hebt, neem dan deel aan het overleg op het <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki gebruikersforum</a>.',
	'smw_adminlinks_datastructure' => 'Gegevensstructuur',
	'smw_adminlinks_displayingdata' => 'Gegevens weergeven',
	'smw_adminlinks_inlinequerieshelp' => 'Hulp bij inline zoekopdrachten',
	'smw-createproperty-isproperty' => 'Dit is een eigenschap van type $1.',
	'smw-createproperty-allowedvals' => 'De toegelaten {{PLURAL:$1|waarde voor deze eigenschap is|waarden voor deze eigenschap zijn}}:',
	'smw-paramdesc-category-delim' => 'Het scheidingsteken',
	'smw-paramdesc-category-template' => 'Een sjabloon om de items mee op te maken',
	'smw-paramdesc-category-userparam' => 'Een aan de sjabloon door te geven parameter',
	'smw-info-par-message' => 'Weer te geven bericht.',
	'smw-info-par-icon' => 'Icoon dat "informatie" of "waarschuwing" aangeeft.',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Semantische zoekopties',
	'smw-prefs-ask-options-tooltip-display' => 'Parametertekst weergeven als infotooltip',
	'smw-prefs-ask-options-collapsed-default' => 'Optievenster standaard samengevouwen weergeven',
	'smw-ui-tooltip-title-property' => 'Eigenschap',
	'smw-ui-tooltip-title-quantity' => 'Hoeveelheid',
	'smw-ui-tooltip-title-info' => 'Gegevens',
	'smw-ui-tooltip-title-service' => 'Servicelinks',
	'smw-ui-tooltip-title-warning' => 'Fout',
	'smw-ui-tooltip-title-parameter' => 'Parameter',
	'smw-ui-tooltip-title-event' => 'Evenement',
	'smw_unknowntype' => 'Het type van deze eigenschap is ongeldig',
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Gunnernett
 * @author Harald Khan
 * @author Njardarlogar
 * @author Ranveig
 */
$messages['nn'] = array(
	'smw_viewasrdf' => 'RDF-mating',
	'smw_finallistconjunct' => ' og',
	'smw_factbox_head' => 'Fakta om $1',
	'smw_isspecprop' => 'Denne eigenskapen er ein spesialeigenskap på denne wikien',
	'smw_concept_description' => 'Skildring av konseptet «$1»',
	'smw_no_concept_namespace' => 'Konsept kan berre bli definerte frå sider i Concept:-namnerommet.',
	'smw_multiple_concepts' => 'Kvar konseptsida kan berre ha éin konseptdefinisjon.',
	'smw_concept_cache_miss' => 'Konseptet «$1» kan ikkje bli nytta for augneblinken, då wikikonfigurasjonen krev at det blir sett saman fråkopla.
Om problemet ikkje går vekk etter noko tid, be sideadministratoren om å gjera dette konseptet tilgjengleg.',
	'smw_baduri' => 'URI-ar på forma «$1» er ikkje tillatne.',
	'smw_printername_count' => 'Tel opp resultata',
	'smw_printername_csv' => 'CSV eksport',
	'smw_printername_json' => 'JSON eksport',
	'smw_printername_list' => 'Liste',
	'smw_printername_ol' => 'Nummerering',
	'smw_printername_ul' => 'Objektisering',
	'smw_printername_rss' => 'RSS eksport',
	'smw_printername_table' => 'Tabell',
	'smw_printername_broadtable' => 'Brei tabell',
	'smw_printername_template' => 'Mal',
	'smw_iq_disabled' => 'Semantiske spørjingar har blitt slegne av på denne wikien.',
	'smw_iq_moreresults' => '… fleire resultat',
	'smw_parseerror' => 'Den gjevne verdien blei ikkje forstått.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '«$1» kan ikkje bli nytta som sidenamn på denne wikien.',
	'smw_wrong_namespace' => 'Berre sider i namnerommet «$1» er tillatne her.',
	'smw_manytypes' => 'Meir enn éin type definert for eigenskapen.',
	'smw_emptystring' => 'Tomme strenger blir ikkje godtekne.',
	'smw_maxstring' => 'Strengerepresenteringa $1 er for lang.',
	'smw_notinenum' => '«$1» er ikkje i lista over moglege verdiar ($2) for denne eigenskapen.',
	'smw_noboolean' => '«$1» blir ikkje kjend att som ein Boolean-verdi (sant/usant).',
	'smw_true_words' => 'true,t,yes,y,ja,j,sant,s',
	'smw_false_words' => 'false,f,no,n,nei,usant,u',
	'smw_nofloat' => '«$1» er ikkje eit tal.',
	'smw_infinite' => 'Tal so store som «$1» er ikkje støtta.',
	'smw_nodatetime' => 'Datoen «$1» vart ikkje forstått.',
	'smw_toomanyclosing' => '«$1» finst for mange gonger i spørjinga.',
	'smw_noclosingbrackets' => 'Nokre klammar i spørjinga di («<nowiki>[[</nowiki>») vart ikkje lukka påfølgjande klammar («]]»).',
	'smw_misplacedsymbol' => 'Symbolet «$1» vart nytta på ein stad der det ikkje er gagnleg.',
	'smw_unexpectedpart' => '«$1»-delen av spørjinga var uforståeleg.
Resultata kan vera uventa.',
	'smw_emptysubquery' => 'Ei underspørjing har ikkje gyldige føresetnader.',
	'smw_misplacedsubquery' => 'Ei underspørjing vart nytta på ein stad der underspørjingar ikkje er tillatne.',
	'smw_valuesubquery' => 'Underspørjingar er ikkje støtta for verdiar av eigenskapen «$1».',
	'smw_badqueryatom' => 'Ein lut («<nowiki>[[…]]</nowiki>») av spørjinga vart ikkje forstått.',
	'smw_propvalueproblem' => 'Verdien av eigenskapen «$1» vart ikkje forstått.',
	'smw_noqueryfeature' => 'Nokre spørjefunksjonar er ikkje støtta på denne wikien, og luter av spørjinga vart difor hoppa over ($1).',
	'smw_noconjunctions' => 'Konjunksjonar i spørjingar er ikkje støtta på denne wikien, og luter av spørjinga vart difor hoppa over ($1).',
	'smw_nodisjunctions' => 'Disjunksjonar i spørjingar er ikkje støtta på denne wikien, og luter av spørjinga vart difor hoppa over ($1).',
	'smw_querytoolarge' => 'Følgjande spørjeføresetnader kunne ikkje verta teke omsyn til grunna avgrensingane til wikien når det gjeld spørjestorleik eller djupn: $1',
	'smw_notemplategiven' => 'Oppgje ein verdi for parameteren «mal» for at dette spørjeformatet skal verka.',
	'smw_type_header' => 'Eigenskapar av typen «$1»',
	'smw_typearticlecount' => 'Syner {{PLURAL:$1|éin eigenskap|$1 eigenskapar}} som nyttar denne typen.',
	'smw_attribute_header' => 'Sider som nyttar eigenskapen «$1»',
	'smw_attributearticlecount' => 'Syner {{PLURAL:$1|éi sida|$1 sider}} som nyttar denne eigenskapen.',
	'smw_subproperty_header' => 'Undereigenskapar',
	'smw_subpropertyarticlecount' => 'Denne eigenskapen har følgjande {{PLURAL:$|undereigenskap|$1 undereigenskapar}}:',
	'smw_concept_header' => 'Sider av konseptet «$1»',
	'smw_conceptarticlecount' => 'Syner {{PLURAL:$1|éi sida|$1 sider}} som høyrer til konseptet.',
	'exportrdf' => 'Eksporter sider til RDF',
	'smw_exportrdf_docu' => 'Denne sida lèt deg skaffa data frå ei sida i RDF-format.
Skriv inn titlar i tekstboksten nedanfor for å eksportera sider, éin tittel per linja.',
	'smw_exportrdf_recursive' => 'Eksporter alle relaterte sider rekursivt.
Merk at resultatet kan vera stort.',
	'smw_exportrdf_backlinks' => 'Eksporter òg alle sider som refererer til dei eksporterte sidene.
Lagar ein RDF som ein kan gå gjennom.',
	'smw_exportrdf_lastdate' => 'Ikkje eksporter sider som ikkje vart endra sidan det oppgjevne tidspunktet.',
	'smw_exportrdf_submit' => 'Eksport',
	'uriresolver' => 'URI-løysar',
	'properties' => 'Eigenskapar',
	'smw_properties_docu' => 'Følgjande eigenskapar er nytta på wikien.',
	'smw_property_template' => '$1 av typen $2 ($3)',
	'smw_propertylackspage' => 'Alle eigenskapar burde vore skildra av ei sida.',
	'smw_propertylackstype' => 'Ingen type blei oppgjeven for denne eigenskapen (reknar med at typen er $1 mellombels)',
	'smw_propertyhardlyused' => 'Denne eigenskapen blir knapt nytta på wikien!',
	'unusedproperties' => 'Unytta eigenskapar',
	'smw_unusedproperties_docu' => 'Dei følgjande eigenskpane finst, sjølv om ingen andre sider nyttar dei.',
	'smw_unusedproperty_template' => '$1 av typen $2',
	'wantedproperties' => 'Ynskte eigenskapar',
	'smw_wantedproperties_docu' => 'Dei følgjande eigenskapen er nytta på wikien, men har ikkje sider som skildrar dei.',
	'smw_wantedproperty_template' => '$1 (nytta {{PLURAL:$2|éin gong|$2 gonger}})',
	'smw_purge' => 'Oppfrisk',
	'types' => 'Typar',
	'smw_types_docu' => 'Fylgjande er ei lista over alle datatypar som eigenskapar kan ha.
Kvar datatype har ei sida der ekstra informasjon kan verta oppgjeven.', # Fuzzy
	'semanticstatistics' => 'Semantisk statistikk',
	'smw_semstats_text' => "Denne wikien inneheld <b>$1</b> {{PLURAL:$1|eigenskapsverdi|eigenskapsverdiar}} for totalt <b>$2</b> [[Special:Properties|{{PLURAL:$2|eigenskap|eigenskapar}}]].
'''$3''' {{PLURAL:$3|eigenskap|eigenskapar}} har ei eiga sida, og den meinte datatypen er oppgjeven for <b>$4</b> av desse.
Somme av dei eksisterande eigenskapane kan vera [[Special:UnusedProperties|unytta eigenskapar]].
Eigenskapar som framleis ikkje har ei eiga sida finst på [[Special:WantedProperties|lista over ynskte eigenskapar]].",
	'smw_uri_doc' => 'URI-løysaren implementerer [$1 finning av W3C TAG-ar på «httpRange-14»].
Han syter for at menneske ikkje vert til nettstader.',
	'ask' => 'Semantisk søk',
	'smw_ask_sortby' => 'Sorter etter kolonne (valfritt)',
	'smw_ask_ascorder' => 'Stigande',
	'smw_ask_descorder' => 'Søkkjande',
	'smw_ask_submit' => 'Finn resultat',
	'smw_ask_editquery' => '[Brigd spørjing]',
	'smw_add_sortcondition' => '[Legg til sorteringsføresetnader]',
	'smw_ask_hidequery' => 'Løyn spørjing',
	'smw_ask_help' => 'Spørjehjelp',
	'smw_ask_queryhead' => 'Spørjing',
	'smw_ask_printhead' => 'Ekstra utskrifter (valfritt)', # Fuzzy
	'smw_ask_format_as' => 'Formatér som:',
	'smw_ask_defaultformat' => 'standard',
	'searchbyproperty' => 'Søk etter eigenskap',
	'smw_sbv_docu' => 'Søk etter alle sider som har ein viss eigenskap og verdi.',
	'smw_sbv_novalue' => 'Skriv inn ein gyldig verdi for eigenskapen, eller sjå alle eigenskapsverdiar for «$1».',
	'smw_sbv_displayresult' => 'Ei lista over alle sider som har eigenskapen «$1» med verdien «$2»',
	'smw_sbv_displayresultfuzzy' => 'Ei lista over alle sider som har eigenskapen «$1» med verdien «$2».
Sidan det berre kom fram nokre få resultat er òg nære verdiar viste.',
	'smw_sbv_property' => 'Eigenskap:',
	'smw_sbv_value' => 'Verdi:',
	'smw_sbv_submit' => 'Finn resultat',
	'browse' => 'Bla gjennom wikien',
	'smw_browselink' => 'Bla gjennom eigenskapar',
	'smw_browse_article' => 'Skriv inn namnet på sida du vil starta å bla frå.',
	'smw_browse_go' => 'Gå',
	'smw_browse_show_incoming' => 'syn eigenskapar som lenkjar hit',
	'smw_browse_hide_incoming' => 'løyn eigenskapar som lenkjar hit',
	'smw_browse_no_outgoing' => 'Denne sida har ingen eigenskapar.',
	'smw_browse_no_incoming' => 'Ingen eigenskapar lenkjar til denne sida.',
	'smw_inverse_label_default' => '$1 av',
	'smw_inverse_label_property' => 'Vrengd eigenskapsmerke', # Fuzzy
	'pageproperty' => 'Sideeigenskapssøk',
	'smw_pp_docu' => 'Søk etter all eigenskapstekst på ei viss side.
Skriv inn både sidenamn og eigenskap.',
	'smw_pp_from' => 'Frå side',
	'smw_pp_type' => 'Eigenskap',
	'smw_pp_submit' => 'Finn resultat',
	'smw_result_prev' => 'Førre',
	'smw_result_next' => 'Neste',
	'smw_result_results' => 'Resultat',
	'smw_result_noresults' => 'Fann ingen resultat.',
	'smwadmin' => 'Administratorfunksjonar for Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Lagringseininga blei sett opp.',
	'smw_smwadmin_return' => 'Attende til $1',
	'smw_smwadmin_updatestarted' => 'Ein ny oppdateringsprosses for å oppfriska dei semantiske dataa blei starta.
Alle lagra data vil bygt om eller reparert der det trengst.
Du kan fylgja med på framgangen til oppdateringa på denne spesialsida.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Ein oppdateringsprosses køyrer frå før.
Startar ikkje ein ny ein.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Alle eksisterande oppdateringsprosessar har blitt stoppa.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'For å stoppa oppdateringsprosessen som køyrer, må du markera boksen for å syna at du verkeleg meiner det.', # Fuzzy
	'smw_smwadmin_docu' => 'Denne spesialsida hjelper deg under installering og oppgradering av <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Hugs å ta kopiar av viktige data før du køyrer administrerande funksjonar.',
	'smw_smwadmin_db' => 'Databaseinnstallering og -oppgradering',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki krev nokre utvidingar i MediaWiki-databasen for å kunna lagra semantiske data.
Funksjonen under syter for at databasen din er sett opp rett.
Endringar gjort i dette steget har ikkje nokon effekt på resten av MediaWiki-databasen og kan enkelt rullast attende om det skulle vera ynskjeleg.
Denne oppsettsfunksjonen kan køyrast fleire gongen utan at ein gjer nokon skade, men han trengst berre éin gong under installering eller oppgradering.',
	'smw_smwadmin_permissionswarn' => 'Om operasjonen mislukkast med SQL-feil, har sannsynlegvis ikkje databasebrukaren nytta av wikien din dei rette løyva (sjekk LocalSettings.php).
Anten gje denne brukaren dei rette løyva til å oppretta og sletta tabellar og mellombels skriv inn innloggingsinformasjonen til database-rooten din i LocalSettings.php, eller køyr vedlikehaldsskriptet <tt>SMW_setup.php</tt> som kan nytta løyva til AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Set i verk eller oppgrader tabellar',
	'smw_smwadmin_announce' => 'Kunngjer wikien din',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki har ei nettenesta for å kunngjera nye semantiske wikisider.
Dette er gjort for å vedlikehalda ei lista over offentlege sider som nyttar Semantic MediaWiki, hovudsakleg for å hjelpa <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki-prosjektet</a> med å få eit oversyn over typiske nytteområde av Semantic MediaWiki.
Sjå heimesida til Semantic MediaWiki for <a href="http://semantic-mediawiki.org/wiki/Registry">meir informasjon om denne tenesta</a>.',
	'smw_smwadmin_announcebutton' => 'Trykk den fylgjande knappen for å gje wikiadressa di til tenesta.
Tenesta vil ikkje registrera wikiar som ikkje er opne offentleg, og ho vil berre lagra informasjon som er offentleg tilgjengeleg.',
	'smw_smwadmin_datarefresh' => 'Datareparasjon eller -oppgradering',
	'smw_smwadmin_datarefreshdocu' => 'Det er mogleg å få attende alle Semantic MediaWiki-dataa basert på det noverande innahaldet til wikien.
Dette kan vera nyttig for å reparera øydelagde data eller for å oppfriska dataa om det interne formatet har blitt endra grunna programvareoppdatering.
Oppdateringa blir utført sida for sida og vil ikkje vera ferdig med ein gong.
Det fylgjande syner om ei oppdatering er på gong og lèt deg byrja eller stoppa oppdateringar (viss ikkje denne moglegheita er deaktivert av sideadministratoren).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Ei oppdatering held allereie på.</strong>
Det er normalt at oppdateringa går sakte då ho berre oppfriskar data i små bitar kvar gong ein brukar er innom wikien.
For å fullføra denne oppdateringa på ein kjappare måte, kan du setja i gang MediaWiki-vedlikehaldsskriptet <tt>runJobs.php</tt> (nytt valet <tt>--maxjobs 1000</tt> for å avgrensa talet på oppdetaringar som blir gjort i eitt stykke).
Estimert framdrift på den noverande oppdateringa:',
	'smw_smwadmin_datarefreshbutton' => 'Start oppdatering',
	'smw_smwadmin_datarefreshstop' => 'Stopp denne oppdateringa',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, eg er sikker.',
	'smw_smwadmin_support' => 'Får støtta',
	'smw_smwadmin_supportdocu' => 'Diverse ressursar kan kanskje hjelpa deg om du skulle få problem:',
	'smw_smwadmin_installfile' => 'Om du møter på problem under installeringa, start med å studera retningslinene i <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL-fila</a>.',
	'smw_smwadmin_smwhomepage' => 'Den komplette brukardokumentasjonen for Semantic MediaWiki finn du på <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Feil kan bli rapporterte til <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Om du har fleire spørsmål eller forslag, bli med i diskusjonen på <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki-brukarforumet</a>.',
	'smw-createproperty-isproperty' => 'Dette er ein eigenskap av typen $1.',
	'smw-createproperty-allowedvals' => 'Dei tillatne verdiane for denne eigenskapen er:', # Fuzzy
	'smw_unknowntype' => 'Typen «$1» som er definert for eigenskapen er ikkje støtta.', # Fuzzy
);

/** Occitan (occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'smw-desc' => "Rendre lo wiki mai accessible - per las maquinas ''e'' los umans ([http://semantic-mediawiki.org/wiki/Help:User_manual documentacion en linha])",
	'smw_viewasrdf' => 'Veire coma RDF',
	'smw_finallistconjunct' => ' e',
	'smw_factbox_head' => 'Faches relatius a $1 &mdash; Recèrca de paginas similaras amb <span class="smwsearchicon">+</span>.',
	'smw_isspecprop' => 'Aquesta proprietat es una proprietat especiala sus aqueste wiki.',
	'smw_concept_description' => 'Descripcion del concèpte « $1 »',
	'smw_no_concept_namespace' => 'Los concèptes pòt unicament èsser definits dins la pagina dins lo Concèpte : espaci de nom.',
	'smw_multiple_concepts' => 'Cada pagina de concèpte pòt pas aver qu’una sola definicion.',
	'smw_concept_cache_miss' => 'Lo concèpte « $1 » pòt pas èsser utilizat pel moment, perque la configuracion del wiki requerís que siá aviat fòra linha. Se lo problèma persistís aprèp qualques instants, demandatz a vòstre administrator del site de rendre disponible aqueste concèpte.',
	'smw_noinvannot' => 'Las valors pòdon pas èsser allogadas per inversar de proprietats.',
	'smw_baduri' => 'O planhèm. Las URIs del domeni $1 son pas disponiblas a aqueste emplaçament',
	'smw_csv_link' => 'CSV',
	'smw_printername_count' => 'Comptatge dels resultats',
	'smw_printername_csv' => 'expòrt en CSV',
	'smw_printername_debug' => 'Requèste de debogatge (pels expèrts)',
	'smw_printername_embedded' => 'Contengut de las paginas incrustadas',
	'smw_printername_json' => 'expòrt en JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeracion',
	'smw_printername_ul' => 'Detalh',
	'smw_printername_rss' => 'expòrt en RSS',
	'smw_printername_table' => 'Tablèu',
	'smw_printername_broadtable' => 'Taula larga',
	'smw_printername_template' => 'Modèl',
	'smw_iq_disabled' => "O planhèm. Las recèrcas dins los articles d'aqueste wiki son pas autorizadas.",
	'smw_iq_moreresults' => '… autres resultats',
	'smw_parseerror' => 'La donada indicada es pas estada compresa.',
	'smw_kiloseparator' => ',',
	'smw_notitle' => '“$1” pòt pas èsser utilizat coma nom de pagina sus aqueste wiki.',
	'smw_wrong_namespace' => "Solas las paginas de l'espaci de noms « $1 » son autorizadas aicí.",
	'smw_manytypes' => "Maites tipes de donadas son estats assignats a l'atribut.",
	'smw_emptystring' => 'Las cadenas voidas son pas acceptadas.',
	'smw_maxstring' => 'La cadena de representacion $1 es tròp granda.',
	'smw_notinenum' => '\\"$1\\" fa pas partida de las valors possiblas ($2) per aqueste atribut.',
	'smw_noboolean' => '\\"$1\\" es pas reconegut coma una valor boleana (verai/fals).',
	'smw_true_words' => 'verai,v,òc,true',
	'smw_false_words' => 'fals,f,non,false',
	'smw_nofloat' => '"$1" es pas un nombre.',
	'smw_infinite' => 'Los nombres tant grands coma « $1 » son pas suportats.',
	'smw_nodatetime' => 'La data "$1" es pas estada compresa.',
	'smw_toomanyclosing' => "Sembla que i a tròp d'ocuréncias de “$1” dins la requèsta.",
	'smw_noclosingbrackets' => "D'unes “<nowiki>[[</nowiki>” dins vòstra requèsta son pas estats clauses per de “]]” correspondents.",
	'smw_misplacedsymbol' => 'Lo simbòl “$1” es estat utilizat a un endrech ont es pas util.',
	'smw_unexpectedpart' => 'La partida “$1” de la requèsta es pas estada compresa. Los resultats pòdon èsser imprevists.',
	'smw_emptysubquery' => "D'unas sosrequèstas an una condicion invalida.",
	'smw_misplacedsubquery' => "D'unas sosrequèstas son estadas utilizadas a un endrech ont cap de sosrequèsta es pas permesa.",
	'smw_valuesubquery' => 'Sosrequèsta pas suportada per las valors de la proprietat “$1”.',
	'smw_badqueryatom' => 'Las partidas “<nowiki>[[…]]</nowiki>” de la requèsta son pas estadas compresas.',
	'smw_propvalueproblem' => 'La valor de la proprietat “$1” es pas estada compresa.',
	'smw_noqueryfeature' => 'Qualques foncionalitats de requèstas son pas suportadas sus aqueste wiki e una partida d’entre elas es estada levada ($1).',
	'smw_noconjunctions' => 'Las conjoncions dins las requèstas son pas suportadas sus aqueste wiki e una partida d’entre elas es estada levada ($1).',
	'smw_nodisjunctions' => 'Las disjoncions dins las requèstas son pas suportadas sus aqueste wiki e de partidas de la requèsta son estadas ignoradas($1).',
	'smw_querytoolarge' => "Las condicions seguentas de la requèsta an pas pogut èsser evaluadas en rason de las restriccions d'aqueste wiki a la talha o a la prigondor de las requèstas : $1.",
	'smw_notemplategiven' => 'Provesissètz una valor pel paramètre « modèl » per aqueste format de requèsta per trabalhar.',
	'smw_type_header' => 'Atributs de tipe “$1”',
	'smw_typearticlecount' => "Afichar {{PLURAL:$1|la proprietat qu'utiliza|las $1 proprietats qu'utilizan}} aqueste tipe.",
	'smw_attribute_header' => "Paginas utilizant l'atribut “$1”",
	'smw_attributearticlecount' => "Afichar {{PLURAL:$1|la pagina qu'utiliza|las $1 paginas qu'utilizan}} aquesta proprietat.",
	'smw_subproperty_header' => 'Sosproprietats',
	'smw_subpropertyarticlecount' => 'Aquesta proprietat dispausa {{PLURAL:$1|de la sosproprietat seguenta|de las $1 sosproprietats seguentas}} :',
	'smw_concept_header' => 'Paginas del concèpte « $1 »',
	'smw_conceptarticlecount' => 'Afichar {{PLURAL:$1|la pagina que repausa|las $1 paginas que repausan}} sus aqueste concèpte.',
	'smw_rss_description' => '$1 fial RSS',
	'exportrdf' => "Exportar l'article en RDF",
	'smw_exportrdf_docu' => "Sus aquesta pagina, de partidas del contengut d'un article pòdon èsser exportadas dins lo format RDF. Picatz lo nom de las paginas desiradas dins la bóstia de tèxte çaijós, <i>un nom per linha </i>.",
	'smw_exportrdf_recursive' => "Exportar tanben totas las paginas pertinentas d'un biais recursiu. Aquesta possibilitat pòt abotir a un fòrt grand nombre de resultats !",
	'smw_exportrdf_backlinks' => 'Exportar tanben totas las paginas que renvian a de paginas exportadas. Produsís un RDF dins lo qual la navigacion es mai aisida.',
	'smw_exportrdf_lastdate' => 'Exportar pas las paginas pas modificadas dempuèi lo moment indicat.',
	'smw_exportrdf_submit' => 'Exportar',
	'uriresolver' => "Resolveire d'URI",
	'properties' => 'Proprietats',
	'smw_properties_docu' => 'Sus aqueste wiki, son utilizadas las proprietats seguentas.',
	'smw_property_template' => '$1 del tipe $2 ($3)',
	'smw_propertylackspage' => 'Tota proprietat deuriá èsser descricha per una pagina !',
	'smw_propertylackstype' => 'Cap de tipe es pas estat especificat per aquesta proprietat (tipe actualament supausat : $1).',
	'smw_propertyhardlyused' => 'Aquesta proprietat es fòrça utilizada sus aqueste wiki !',
	'unusedproperties' => 'Proprietats inutilizadas',
	'smw_unusedproperties_docu' => 'Las proprietats seguentas existisson, quitament se cap de pagina las utiliza pas.',
	'smw_unusedproperty_template' => '$1 de tipe $2',
	'wantedproperties' => 'Proprietats demandadas',
	'smw_wantedproperties_docu' => 'Las proprietats seguentas son utilizadas sus aqueste wiki mas an pas encara de pagina per las descriure.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|utilizacion|utilizacions}})',
	'smw_purge' => 'Reactualizar',
	'types' => 'Tipes',
	'smw_types_docu' => "Los tipes de donadas seguents pòdon èsser assignadas als atributs. Cada tipe de donadas a son pròpri article, dins lo qual pòdon figurar d'entresenhas mai precisas.", # Fuzzy
	'semanticstatistics' => 'Estatisticas semanticas',
	'smw_semstats_text' => "Aqueste wiki conten '''$1''' {{PLURAL:$1|valor|valors}} de proprietat per una soma de '''$2''' [[Special:Properties|{{PLURAL:$2|proprietat diferenta|proprietats diferentas}}]].
'''$3''' {{PLURAL:$3|proprietat a sa|proprietats an lor}} pagina pròprie, e lo tipe de donadas volgut es especificat per '''$4''' d'aquesta.
Unas de las proprietats existentas pòdon en fach èsser [[Special:UnusedProperties|inutilizadas]].
Las proprietats qu'an pas encara de pagina se tròban dins la [[Special:WantedProperties|lista de las proprietats demandadas]].",
	'smw_uri_doc' => 'Lo resolveire d\'URI implementa la <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">conclusion del TAG del W3C a prepaus del httpRange-14</a>. Se pòt assegurar que los umans vengan pas de sites web.',
	'ask' => 'Recèrca semantica',
	'smw_ask_sortby' => 'Triar per colomnas (opcional)',
	'smw_ask_ascorder' => 'Creissent',
	'smw_ask_descorder' => 'Descreissent',
	'smw_ask_submit' => 'Trobar de resultats',
	'smw_ask_editquery' => '[Editar la requèsta]',
	'smw_add_sortcondition' => '[Apond las condicions de triada]',
	'smw_ask_hidequery' => 'Amagar la requèsta',
	'smw_ask_help' => 'Ajuda a la requèsta',
	'smw_ask_queryhead' => 'Requèsta',
	'smw_ask_printhead' => 'Condicions suplementàrias (facultatiu)', # Fuzzy
	'smw_ask_format_as' => 'Formatar en :',
	'smw_ask_defaultformat' => 'defaut',
	'smw_ask_show_embed' => 'Far veire lo còde incrustat',
	'smw_ask_hide_embed' => 'Amagar lo còde incrustat',
	'smw_ask_embed_instr' => 'Per incrustar aquesta requèsta dins una pagina wiki, utilizatz lo còde çaijós.',
	'searchbyproperty' => 'Recercar per atribut',
	'smw_sbv_docu' => "Recercar totas las paginas qu'an un atribut donat amb una cèrta valor.",
	'smw_sbv_novalue' => 'Picatz una valor o consultatz totas las valors dels atributs per $1.',
	'smw_sbv_displayresult' => "Lista de totas las paginas qu'an un atribut $1 amb la valor $2.",
	'smw_sbv_displayresultfuzzy' => 'Una lista de totas las paginas que son la proprietat « $1 » amb la valor « $2 ». Perque i a pas que qualques resultats, las valors pròchas tanben son afichadas.',
	'smw_sbv_property' => 'Proprietat :',
	'smw_sbv_value' => 'Valor :',
	'smw_sbv_submit' => 'Trobar de resultats',
	'browse' => 'Percórrer lo wiki',
	'smw_browselink' => 'Cercar las proprietats',
	'smw_browse_article' => 'Picatz lo nom de la pagina a partir de la quala volètz començar la navigacion.',
	'smw_browse_go' => 'Validar',
	'smw_browse_show_incoming' => 'afichar las proprietats que puntan aicí',
	'smw_browse_hide_incoming' => 'amagar las proprietats que puntan aicí',
	'smw_browse_no_outgoing' => 'Aquesta pagina a pas cap de proprietat.',
	'smw_browse_no_incoming' => 'Cap de proprietat punta pas cap a aquesta pagina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Inversar lo labèl de proprietat',
	'pageproperty' => 'Recercar dins las proprietats de la pagina',
	'smw_pp_docu' => "Recercar totas las valors d'una proprietat dins una pagina donada. Picatz la pagina e una proprietat.",
	'smw_pp_from' => 'De la pagina',
	'smw_pp_type' => 'Proprietat',
	'smw_pp_submit' => 'Trobar de resultats',
	'smw_result_prev' => 'Precedent',
	'smw_result_next' => 'Seguent',
	'smw_result_results' => 'Resultats',
	'smw_result_noresults' => 'O planhèm, pas de resultats.',
	'smwadmin' => "Foncions d'administrator per Semantic MediaWiki",
	'smw_smwadmin_setupsuccess' => "Lo motir d'estocatge es estat installat amb succès.",
	'smw_smwadmin_return' => 'Tornar cap a $1',
	'smw_smwadmin_updatestarted' => 'Un processús novèl pel refrescament de semantic data a començat.
Totas las donadas estocadas seràn reconstruchas o quitament reparadas se necessari.
Podètz seguir la progression de la mesa a jorn sus aquesta pagina especiala.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Un processús de mesa a jorn ja es en cors d’execucion.
Ne creetz pas un autre.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Totes los processús de mesa a jorn son estats arrestats.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Per arrestar lo processús en cors de mesa a jorn, vos cal marcar la casa per indicar que ne sètz vertadièrament segur(a).', # Fuzzy
	'smw_smwadmin_docu' => 'Aquesta pagina especiala vos ajuda pendent l’installacion e la mesa a nivèl de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Doblidetz pas de salvar las donadas abans las foncions d’administracion del site.',
	'smw_smwadmin_db' => 'Installacion e mesa a nivèl de la banca de donadas',
	'smw_smwadmin_dbdocu' => "Semantic MediaWiki requerís maitas extensions per la banca de donadas MediaWiki en òrdre per emmagazinar las donadas de semantica.
La foncion çaijós verifica que vòstra banca de donadas es estada installada corrèctament.
Las modificacions fachas al moment d'aquesta etapa afectaràn pas la rèsta de la banca de donadas Mediawiki, e pòt èsser desfacha a volontat.
Aquesta foncion d’installacion pòt èsser aviada mantun còp sens causar lo mendre degalh, mas una sola installacion o mesa e nivèl es necessària.",
	'smw_smwadmin_permissionswarn' => "Se l’operacion fracassa amb d'errors SQL, l’utilizaire de la banca de donadas utilizada per vòstre wiki, (agachatz vòstre LocalSettings.php) risca probablament d'aver pas las permissions sufisentas.
Cal siá permetre a aqueste utilizaire de dispausar de las permissions per crear e suprimir las taulas, siá entrar temporàriament la connexion en root a vòstra banca de donadas dins lo LocalSettings.php, siá utilizar l'escript de mantenença <tt>SMW_setup.php</tt> lo qual pòt utilizar las acreditacions de AdminSettings.php.", # Fuzzy
	'smw_smwadmin_dbbutton' => 'Inicializa las taulas de mesa a nivèl',
	'smw_smwadmin_announce' => 'Anonciar vòstre wiki',
	'smw_smwadmin_announcedocu' => "Semantic MediaWiki dispausa d’un servici internet per anonciar de sites wiki semantics novèls.
Aquò's utilizat per manténer una lista dels sites publics qu'utilizan Semantic MediaWiki, principalament per ajudar <a href=\"http://semantic-mediawiki.org/wiki/SMW_Project\">lo projècte Semantic MediaWiki</a> a obténer una vista d’ensemble dels usatges tipics d'aqueste projècte.
Vejatz la pagina d’acuèlh de Semantic MediaWiki <a href=\"http://semantic-mediawiki.org/wiki/Registry\">per mai d'entresenhas a prepaus d'aqueste servici</a>.",
	'smw_smwadmin_announcebutton' => 'Quichatz sul boton seguent per sometre l’adreça internet de vòstre wiki a aqueste servici.
Lo servici enregistrarà pas los wiki que son pas accessibles al public, e estocarà pas que las informacions publicament accessiblas.',
	'smw_smwadmin_datarefresh' => 'Reparacion e mesa a nivèl de las donadas',
	'smw_smwadmin_datarefreshdocu' => "Es possible de restablir totas las donadas Semantic MediaWiki basadas suls contenguts corrents d'aqueste wiki.
Aquò pòt èsser util per reparar de donadas rompudas o per refrescar las donadas se lo format intèrne a cambiat al moment de las remesas a nivèl.
La mesa a jorn es executada pagina per pagina e se serà pas acabada immediatament.
La pagina seguenta aficha se una mesa a jorn es en cors d’execucion e vos permet de començar o d’arrestar aquestas (levat s'aquesta foncionalitat est desactivada per l’administrator del site).",
	'smw_smwadmin_datarefreshprogress' => "<strong>Una mesa a jorn es en cors d’execucion.</strong>
Es normal qu’una mesa a jorn progresse lentament dempuèi que refresca unicament las donadas dins de troces pichons a cada còp qu’un utilizaire accedís al wiki.
Per acabar aquesta mesa a jorn mai rapidament, podètz invocar l'escript de mantenença Mediawiki <tt>runJobs.php</tt> (utilizatz l’opcion <tt>--maxjobs 1000</tt> per restrénher lo nombre de las mesas a jorn per escript aviat).
Progression estimada de la mesa a jorn actuala :",
	'smw_smwadmin_datarefreshbutton' => 'Començar la mesa a jorn de las donadas',
	'smw_smwadmin_datarefreshstop' => 'Arrestar aquesta mesa a jorn',
	'smw_smwadmin_datarefreshstopconfirm' => 'Òc, ne soi segur(a).',
	'smw_smwadmin_support' => 'Obtencion d’un supòrt',
	'smw_smwadmin_supportdocu' => 'De ressorsas divèrsas vos poiriàn ajudar en cas de problèmas :',
	'smw_smwadmin_installfile' => 'S\'experimentatz de problèmas amb vòstra installacion, començatz per agachar lo guida en linha dins lo <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">fichièr INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentacion completa de l’utilizaire de Semantic MediaWiki se tròba sus <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Los bògs pòdon èsser someses sus <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Avètz d’autras questions o de suggestions, rejonhètz la discussion sul <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forum dels utilizaires de Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Estructura de las donadas',
	'smw_adminlinks_displayingdata' => 'Afichatge de las donadas',
	'smw_adminlinks_inlinequerieshelp' => 'Ajuda sus las requèstas',
	'smw-createproperty-isproperty' => 'Aquò es una proprietat del tipe $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|La valor autorizada per aquesta proprietat es|Las valors autorizadas per aquesta proprietat son}} :',
	'smw_unknowntype' => 'Lo tipe de donadas "$1" pas suportat es estat tornat a l\'atribut.', # Fuzzy
);

/** Ossetic (Ирон)
 * @author Amikeco
 */
$messages['os'] = array(
	'smw_printername_template' => 'Шаблон',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'smw_finallistconjunct' => ' unn',
	'smw_printername_list' => 'Lischt',
	'smw_printername_template' => 'Moddel',
	'smw_true_words' => 'ya,yes,true',
	'smw_false_words' => 'nee,no,false',
	'smw_nofloat' => '„$1“ iss ken Zehl.',
	'smw_browse_go' => 'Geh los',
	'smw_inverse_label_default' => '$1 vun',
	'smw_pp_from' => 'Blatt',
	'smw_result_prev' => 'zerick',
	'smw_result_next' => 'vaerschich',
	'smw_smwadmin_return' => 'Zerick zu $1',
);

/** Pälzisch (Pälzisch)
 * @author Manuae
 */
$messages['pfl'] = array(
	'smw_true_words' => 'woah,w,ja,j',
	'smw_false_words' => 'falsch,f,nä,n',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, isch bin ma sischa',
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Maikking
 * @author Sp5uhe
 * @author ToSter
 * @author Vuh
 * @author Woytecr
 * @author Łukasz Bolikowski
 */
$messages['pl'] = array(
	'smw-desc' => 'Poprawia dostępność wiki zarówno dla automatów jak i ludzi ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentacja online])',
	'smw_viewasrdf' => 'Kanał RDF',
	'smw_finallistconjunct' => ' i',
	'smw_factbox_head' => 'Fakty o $1',
	'smw_isspecprop' => 'Ta własność jest unikalna dla tej wiki.',
	'smw_concept_description' => 'Opis koncepcji „$1”',
	'smw_no_concept_namespace' => 'Koncepcje można definiować tylko w przestrzeni nazw Koncepcja:',
	'smw_multiple_concepts' => 'Każda strona koncepcji może mieć tylko jedną definicję koncepcji.',
	'smw_concept_cache_miss' => 'Koncepcja „$1” w chwili obecnej nie może zostać użyta, ponieważ konfiguracja wiki wymaga aby została ona przeliczona offline. Jeśli problem nie ustąpi po jakimś czasie, skontaktuj się z administratorem witryny.',
	'smw_noinvannot' => 'Nie można przypisać wartości właściwościom odwrotnym.',
	'version-semantic' => 'Rozszerzenia semantyczne',
	'smw_baduri' => 'Niestety, URI z przestrzeni „$1” nie są w tym miejscu dostępne.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Wyniki obliczeń',
	'smw_printername_csv' => 'eksport CSV',
	'smw_printername_dsv' => 'Eksport DSV',
	'smw_printername_debug' => 'Śledzenie zapytania (dla specjalistów)',
	'smw_printername_embedded' => 'Zagnieżdżone fragmenty strony',
	'smw_printername_json' => 'eksport JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Lista numerowana',
	'smw_printername_ul' => 'Lista nienumerowana',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Szeroka tabela',
	'smw_printername_template' => 'Szablon',
	'smw_printername_rdf' => 'Eksport RDF',
	'smw_printername_category' => 'Kategoria',
	'validator-type-class-SMWParamSource' => 'tekst',
	'smw-paramdesc-limit' => 'Maksymalna liczba zwracanych wyników',
	'smw-paramdesc-offset' => 'Przesunięcie pierwszego wyniku',
	'smw-paramdesc-headers' => 'Wyświetlanie nazw nagłówków i właściwości',
	'smw-paramdesc-mainlabel' => 'Etykieta dająca nazwę stronie głównej',
	'smw-paramdesc-link' => 'Pokaż wartości jako linki',
	'smw-paramdesc-intro' => 'Tekst wyświetlany przed wynikami zapytania, jeśli są jakieś',
	'smw-paramdesc-outro' => 'Tekst wyświetlany poniżej wyników zapytania, jeśli są jakieś',
	'smw-paramdesc-default' => 'Tekst wyświetlany jeśli brak jest wyników zapytania',
	'smw-paramdesc-sep' => 'Separator oddzielający wartości',
	'smw-paramdesc-distribution' => 'Zamiast wyświetlania wszystkich wartości, policz ich wystąpienia i pokaż to.',
	'smw-paramdesc-template' => 'Nazwa szablonu, który zostanie wyświetlony na wydrukach',
	'smw-paramdesc-columns' => 'Liczba kolumn, w których zostaną wyświetlone wyniki (domyślnie $1)',
	'smw-paramdesc-userparam' => 'Wartość przekazywana do szablonu przy każdym jego użyciu',
	'smw-paramdesc-introtemplate' => 'Nazwa szablonu wyświetlana przed wynikami zapytania, jeśli są jakieś',
	'smw-paramdesc-outrotemplate' => 'Nazwa szablonu wyświetlana poniżej wyników zapytania, jeśli są jakieś',
	'smw-paramdesc-embedformat' => 'Znacznik HTML używany do definiowania nagłówków',
	'smw-paramdesc-embedonly' => 'Nie wyświetlaj nagłówków',
	'smw-paramdesc-rdfsyntax' => 'Wykorzystywana składnia RDF',
	'smw-paramdesc-csv-sep' => 'Używany separator',
	'smw-paramdesc-dsv-separator' => 'Użyty separator',
	'smw-paramdesc-dsv-filename' => 'Nazwa pliku DSV',
	'smw-smwdoc-description' => 'Pokazuje tabelę wszystkich parametrów, które mogą być użyte do formatowania określonego wyniku wraz z wartościami domyślnymi i opisami.',
	'smw-smwdoc-par-format' => 'Formatuj wynik, do wyświetlenia sparametryzowanej dokumentacji.',
	'smw-smwdoc-par-parameters' => 'Które parametry wyświetlić. "specific" dla dodanych przez format, "base" dla dostępnych we wszystkich formatach oraz "all" do obu.',
	'smw-paramdesc-searchlabel' => 'Treść linku do kolejnych wyników',
	'smw-paramdesc-named_args' => 'Nazwa argumentu przekazana do szablonu',
	'smw-paramdesc-export' => 'Opcje eksportu',
	'smw_iq_disabled' => 'Niestety, w tym wiki wyłączono możliwość tworzenia zapytań w artykułach.',
	'smw_iq_moreresults' => '&hellip; dalsze wyniki',
	'smw_parseerror' => 'Podana wartość jest niezrozumiała.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '„$1” nie może być użyte jako nazwa strony.',
	'smw_wrong_namespace' => 'Dozwolone są tutaj tylko strony z przestrzeni nazw „$1”.',
	'smw_manytypes' => 'Zdefiniowano więcej niż jeden typ dla atrybutu.',
	'smw_emptystring' => 'Puste łańcuchy znakowe są niedozwolone.',
	'smw_maxstring' => 'Reprezentacja znakowa $1 jest zbyt długa.',
	'smw_notinenum' => '“$1” nie jest na liście dozwolonych wartości ($2) dla tego atrybutu.',
	'smw_noboolean' => '“$1” nie zostało rozpoznane jako wartość logiczna (prawda/fałsz).',
	'smw_true_words' => 'prawda,t,yes,y,tak,true',
	'smw_false_words' => 'fałsz,f,no,n,nie,false',
	'smw_nofloat' => '„$1” nie jest liczbą.',
	'smw_infinite' => 'Liczby tak duże jak „$1” nie są obsługiwane.',
	'smw_novalues' => 'Nie określono wartości',
	'smw_nodatetime' => 'Data „$1” nie została zrozumiana.',
	'smw_toomanyclosing' => 'W zapytaniu jest zbyt wiele wystąpień „$1”.',
	'smw_noclosingbrackets' => 'W zapytaniu któryś z podwójnych nawiasów „<nowiki>[[</nowiki>” nie został zamknięty nawiasem „]]”.',
	'smw_misplacedsymbol' => 'Symbolu „$1” użyto w niewłaściwym miejscu.',
	'smw_unexpectedpart' => 'Część „$1” zapytania jest niezrozumiała.
Wyniki mogą być inne od oczekiwanych.',
	'smw_emptysubquery' => 'Podzapytanie nie ma prawidłowych warunków do wykonania.',
	'smw_misplacedsubquery' => 'Podzapytanie zostało użyte w niedozwolonym miejscu.',
	'smw_valuesubquery' => 'Podzapytania nie są dozwolone jako wartości własności „$1”.',
	'smw_badqueryatom' => 'Część zapytania „<nowiki>[[…]]</nowiki>” nie została zrozumiana.',
	'smw_propvalueproblem' => 'Wartość „$1” nie została rozpoznana.',
	'smw_noqueryfeature' => 'Niektóre elementy zapytania nie są obsługiwane na tej wiki, pominięto część zapytania ($1).',
	'smw_noconjunctions' => 'Koniunkcje w zapytaniach nie są obsługiwane na tej wiki, pominięto część zapytania ($1).',
	'smw_nodisjunctions' => 'Alternatywy w zapytaniach nie są obsługiwane na tej wiki, pominięto część zapytania ($1).',
	'smw_querytoolarge' => 'Następujące warunki zapytania nie mogły zostać uwzględnione ze względu na ograniczenia wiki w wielkości lub głębokości zapytania: $1.',
	'smw_notemplategiven' => 'Należy podać parametr „template”, aby to zapytanie zadziałało.',
	'smw_type_header' => 'Atrybuty typu “$1”',
	'smw_typearticlecount' => 'Pokazano $1 {{PLURAL:$1|atrybut używający|atrybuty używające|atrybutów używających}} tego typu.',
	'smw_attribute_header' => 'Strony używające atrybutu “$1”',
	'smw_attributearticlecount' => 'Pokazano $1 {{PLURAL:$1|stronę używającą|strony używające|stron używających}} tego atrybutu.',
	'smw_subproperty_header' => 'Podwłasności',
	'smw_subpropertyarticlecount' => 'Ta własność ma {{PLURAL:$1|podwłasność|$1 następujące podwłasności:|$1 następujących podwłasności:}}',
	'smw_concept_header' => 'Strony koncepcji „$1”',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Wyświetlona jest jedna strona należąca|Wyświetlone zostały $1 strony należące|Wyświetlonych zostało $1 stron należących}} do tej koncepcji.',
	'exportrdf' => 'Eksport stron do RDF',
	'smw_exportrdf_docu' => 'Ta strona pozwala eksportować fragmenty artykułu w formacie RDF.  Aby wyeksportować artykuły, wpisz ich tytuły w poniższym polu tekstowym, po jednym tytule w wierszu.',
	'smw_exportrdf_recursive' => 'Rekursywny eksport wszystkich powiązanych stron.  Zwróć uwagę, że wynik może być olbrzymi!',
	'smw_exportrdf_backlinks' => 'Eksportuj także wszystkie strony, które odwołują się do eksportowanych stron.  Tworzy przeglądalny RDF.',
	'smw_exportrdf_lastdate' => 'Nie eksportuj stron, które nie były zmieniane od podanego czasu.',
	'smw_exportrdf_submit' => 'Eksport',
	'uriresolver' => 'Przekształcanie URI',
	'properties' => 'Własności',
	'smw_properties_docu' => 'Następujące własności są wykorzystywane w wiki.',
	'smw_property_template' => '$1 typu $2 ($3)', # Fuzzy
	'smw_propertylackspage' => 'Wszystkie własności powinny być opisane stroną!',
	'smw_propertylackstype' => 'Nie określono żadnego typu dla tej własności (tymczasowo przypisano typ $1).',
	'smw_propertyhardlyused' => 'Ta własność jest rzadko używana w przestrzeni wiki!',
	'unusedproperties' => 'Niewykorzystywane własności',
	'smw_unusedproperties_docu' => 'Następujące własności istnieją, mimo że żadne inne strony ich nie wykorzystują.',
	'smw_unusedproperty_template' => '$1 typu $2',
	'wantedproperties' => 'Pożądane własności',
	'smw_wantedproperties_docu' => 'Następujące własności są wykorzystywane na wiki, ale nie mają jeszcze opisującej ich strony.',
	'smw_wantedproperty_template' => '$1 (wykorzystane {{PLURAL:$2|raz|$2 razy}})',
	'smw_purge' => 'Odśwież',
	'types' => 'Typy',
	'smw_types_docu' => 'Poniżej znajduje się lista wszystkich typów danych, które mogą zostać przypisane atrybutom.',
	'semanticstatistics' => 'Statystyka semantyczna',
	'smw_semstats_text' => "Ta wiki zawiera '''$1''' {{PLURAL:$1|wartość|wartości}} własności z ogólnej liczby '''$2''' [[Special:Properties|{{PLURAL:$2|właściwości|różnych właściwości}}]].
'''$3''' {{PLURAL:$3|właściwość ma swoją własną stronę|właściwości mają swoje własne strony}}. a typ danych został określony dla '''$4''' z nich.
Niektóre z istniejących właściwości mogą [[Special:UnusedProperties|być obecnie niewykorzystywane]].
Właściwości, które nie posiadają swojej strony odnaleźć można na stronie [[Special:WantedProperties|spisu brakujących właściwości]].",
	'smw_uri_doc' => 'Resolver URI implementuje <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Dzięki temu ludzie nie zamieniają się w strony WWW.',
	'ask' => 'Szukanie semantyczne',
	'smw_ask_sortby' => 'Sortuj według kolumny (opcjonalnie)',
	'smw_ask_ascorder' => 'Rosnąco',
	'smw_ask_descorder' => 'Malejąco',
	'smw_ask_submit' => 'Szukaj wyników',
	'smw_ask_editquery' => '[Edytuj zapytanie]',
	'smw_add_sortcondition' => '[Dodaj warunki sortowania]',
	'smw_ask_hidequery' => 'Ukryj zapytanie',
	'smw_ask_help' => 'Pomoc dla tworzenia zapytań',
	'smw_ask_queryhead' => 'Zapytanie',
	'smw_ask_printhead' => 'Dodatkowe dane do wyświetlenia',
	'smw_ask_printdesc' => '(dodaj w linii jedną nazwę właściwości)',
	'smw_ask_format_as' => 'Formatuj jako',
	'smw_ask_defaultformat' => 'domyślny',
	'smw_ask_otheroptions' => 'Inne opcje',
	'smw_ask_show_embed' => 'Pokaż kod zagnieżdżony',
	'smw_ask_hide_embed' => 'Ukryj zagnieżdżony kod',
	'smw_ask_embed_instr' => 'Aby zagnieździć to zapytanie na stronie wiki, użyj poniższego kodu.',
	'smw-ask-sorting' => 'Sortowanie',
	'smw-ask-format-selection-help' => 'Aby uzyskać szczegółowy opis, odwiedź $1 stronę pomocy.',
	'querycreator' => 'Kreator zapytań',
	'smw_qc_addmainlabel' => 'Dodaj główną etykietę',
	'smw_qc_show_addnal_opts' => 'Więcej opcji',
	'smw_qc_hide_addnal_opts' => 'Mniej opcji',
	'smw_qc_otheropt' => 'Inne opcje',
	'smw_qc_default' => 'Domyślnie',
	'smw_qc_formatopt' => 'Opcje formatowania',
	'smw_qc_query_help' => 'Wpisz zapytanie korzystając z poniższego formularza. Wybierz strony wiki opartych na
Kategoriach (<strong><nowiki>np. [[Kategoria:Aktor]]</nowiki></strong>),
Własnościach (<strong><nowiki>np. [[Located in::Niemcy]]</nowiki></strong>),
Nazwach (<strong><nowiki>np. [[Niemcy]]</nowiki></strong>) i
Przestrzeniach nazw (<strong><nowiki>np. [[Pomoc: +]]</nowiki></strong>)',
	'smw_qui_property' => '<strong>Właściwość</strong>',
	'smw_qui_prop' => 'Właściwość',
	'smw_qui_labl' => 'Etykieta:',
	'smw_qui_noquery' => 'Zapytanie nie zostało określone',
	'smw_qui_nosort' => 'Bez sortowania',
	'smw_qui_ascorder' => 'Rosnąco',
	'smw_qui_descorder' => 'Malejąco',
	'smw_qui_addnprop' => 'Dodaj właściwość',
	'smw_qui_delete' => 'Usuń',
	'smw_qui_options' => 'Opcje',
	'smw_qui_addcategory' => 'Dodaj kategorię',
	'smw_qui_ok' => 'Ok',
	'smw_qui_cancel' => 'Anuluj',
	'smw_qui_category' => '<strong>Kategoria</strong>',
	'smw_qui_label' => 'Etykieta',
	'smw_qui_dlabel' => 'Etykieta:',
	'smw_qui_dcategory' => 'Kategoria:',
	'searchbyproperty' => 'Szukaj po atrybucie',
	'smw_sbv_docu' => 'Szukanie wszystkich stron, które mają dany atrybut i wartość.',
	'smw_sbv_novalue' => 'Wpisz wartość, lub zobacz wszystkie wartości atrybutów dla $1.',
	'smw_sbv_displayresult' => 'Lista wszystkich stron, które mają atrybut $1 z wartością $2.',
	'smw_sbv_displayresultfuzzy' => 'Lista wszystkich stron, które posiadają własność „$1” o wartości „$2”.
Ponieważ znaleziono tylko kilka wyników, pokazano również wyniki podobne.',
	'smw_sbv_property' => 'Atrybut',
	'smw_sbv_value' => 'Wartość:',
	'smw_sbv_submit' => 'Znajdź wyniki',
	'browse' => 'Przeglądaj artykuły',
	'smw_browselink' => 'Przeglądaj właściwości',
	'smw_browse_article' => 'Wpisz nazwę artykułu, od którego chcesz rozpocząć przeglądanie.',
	'smw_browse_go' => 'Idź',
	'smw_browse_show_incoming' => 'pokaż własności linkujące tutaj',
	'smw_browse_hide_incoming' => 'ukryj własności linkujące tutaj',
	'smw_browse_no_outgoing' => 'Ta strona nie ma żadnych własności.',
	'smw_browse_no_incoming' => 'Żadne własności nie linkują do tej strony.',
	'smw_inverse_label_default' => '$1 z',
	'smw_inverse_label_property' => 'Etykieta odwrotnej własności',
	'pageproperty' => 'Szukanie własności stron',
	'smw_pp_docu' => 'Wyszukiwanie wszystkich wartości danej właściwości na zadanej stronie.
Podaj zarówno stronę, jak i właściwość.',
	'smw_pp_from' => 'Od strony',
	'smw_pp_type' => 'Własność',
	'smw_pp_submit' => 'Znajdź wyniki',
	'smw_result_prev' => 'Poprzednia',
	'smw_result_next' => 'Następne',
	'smw_result_results' => 'Wyniki',
	'smw_result_noresults' => 'Niestety, brak wyników.',
	'smwadmin' => 'Funkcje administracyjne dla Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Silnik przestrzeni dyskowej został pomyślnie ustawiony.',
	'smw_smwadmin_return' => 'Powrót do $1',
	'smw_smwadmin_updatestarted' => 'Uruchomiono nowy proces aktualizacji danych semantycznych.
Wszystkie zapisane dane zostaną uporządkowane oraz naprawione w razie potrzeby.
Możesz śledzić stan procesu aktualizacji na tej specjalnej stronie.

Powrót do $1.',
	'smw_smwadmin_updatenotstarted' => 'Jest już uruchomiony proces aktualizacji.
Kolejny nie zostanie utworzony.

Powrót do $1.',
	'smw_smwadmin_updatestopped' => 'Wszystkie istniejące procesy aktualizacji zostały zatrzymane.

Powrót do $1.',
	'smw_smwadmin_updatenotstopped' => 'W celu zatrzymania uruchomionego procesu aktualizacji należy zaznaczyć pole wyboru, aby potwierdzić decyzję.

Powrót do $1.',
	'smw_smwadmin_docu' => 'Ta strona specjalna pomoże Ci w instalacji i modernizacji <a href="http://semantic-mediawiki.org">Semantycznego MediaWiki</a>.
Pamiętaj przed wykonaniem funkcji administracyjnych o utworzeniu kopii zapasowej ważnych danych.',
	'smw_smwadmin_db' => 'Instalacja i aktualizacja bazy danych',
	'smw_smwadmin_dbdocu' => 'Semantyczne MediaWiki wymaga rozszerzeń do bazy danych MediaWiki, które umożliwiają przechowywanie danych semantycznych.
Poniższa funkcja zapewnia, że baza danych zostanie poprawnie przygotowana.
Zmiany wykonane w tym kroku nie mają wpływu na pozostałą część bazy danych MediaWiki i mogą łatwo zostać cofnięte w razie potrzeby.
Ta operacja może zostać wykonana wielokrotnie bez wyrządzenia szkód ale konieczna jest tylko raz w trakcie instalacji lub aktualizacji.',
	'smw_smwadmin_permissionswarn' => 'Jeśli operacja nie powiedzie się i wystąpią błędy SQL, najprawdopodobniej użytkownik bazy danych wykorzystywany przez Twoją wiki (sprawdź LocalSettings.php) nie ma wystarczających uprawnień.
Nadaj użytkownikowi dodatkowe uprawnienia do tworzenia i usuwania tabel, tymczasowo użyj konta root w LocalSettings.php lub użyj skryptu konserwacyjnego <tt>SMW_setup.php</tt>, który ma uprawnienia SysOp.',
	'smw_smwadmin_dbbutton' => 'Inicjuj lub aktualizuj tabele',
	'smw_smwadmin_announce' => 'Opublikuj swoją wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki posiada serwis internetowy do zamieszczania informacji o nowych semantycznych witrynach wiki.
Informacja ta jest wykorzystywana do generowania spisu publicznych witryn, które korzystają z Semantic MediaWiki, oraz przede wszystkim pomaga <a href="http://semantic-mediawiki.org/wiki/SMW_Project">twórcom Semantic MediaWiki</a>, określić typowe zastosowania Semantic MediaWiki.
Zobacz stronę główną Semantic MediaWiki jeśli szukasz <a href="http://semantic-mediawiki.org/wiki/Registry">dalszych informacji na temat tej usługi</a>.',
	'smw_smwadmin_announcebutton' => 'Naciśnij przycisk, aby zapisać adres URL swojej wiki w tym serwisie.
Nie rejestrujemy wiki, które nie są publicznie dostępne. Zapisujemy wyłącznie publicznie dostępne informacje.',
	'smw_smwadmin_datarefresh' => 'Naprawa i aktualizacja danych',
	'smw_smwadmin_datarefreshdocu' => 'Istnieje możliwość przywrócenia wszystkich danych Semantic MediaWiki w oparciu o aktualną zawartość wiki.
Może to być przydatne do naprawy uszkodzonych danych lub odświeżenia danych, jeśli wewnętrzny format zmienił się z powodu jakichś aktualizacji oprogramowania.
Aktualizacja jest wykonywana strona po stronie i nie zostanie ukończona natychmiast. 
Poniżej przedstawiono, czy aktualizacja jest w toku. Można również uruchomić lub zatrzymać aktualizację (chyba, że ta funkcja została wyłączona przez administratora).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Aktualizacja trwa.</strong> 
To normalne, że aktualizacja postępuje powoli, gdyż odświeżanie danych wykonywane jest w małymi porcjami za każdym razem, gdy użytkownik korzysta z wiki. 
Aby szybciej zakończyć aktualizację można uruchomić skrypt MediaWiki <tt>runJobs.php</tt> (użyj opcji <tt>--maxjobs 1000</tt>, aby ograniczyć liczbę aktualizacji, które wykonywane są podczas jednego uruchomienia). 
Przewidywany postęp bieżącej aktualizacji:',
	'smw_smwadmin_datarefreshbutton' => 'Rozpocznij aktualizację danych',
	'smw_smwadmin_datarefreshstop' => 'Zatrzymaj aktualizację danych',
	'smw_smwadmin_datarefreshstopconfirm' => 'Tak, jestem pewien.',
	'smw_smwadmin_support' => 'Jak otrzymać wsparcie',
	'smw_smwadmin_supportdocu' => 'Różnorodne źródła informacji mogą okazać się przydatne jeśli wystąpią problemy:',
	'smw_smwadmin_installfile' => 'Jeśli doświadczysz problemów z instalacją, zacznij od sprawdzenia wskazówek w <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">pliku INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Kompletna dokumentacja Semantic MediaWiki znajduje się na stronie <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Błędy możesz zgłaszać w <a href="https://bugzilla.wikimedia.org/">Bugzilli</a>.',
	'smw_smwadmin_questions' => 'Jeśli nadal masz pytania lub sugestie przyłącz się do dyskusji na <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forum użytkowników Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struktura danych',
	'smw_adminlinks_displayingdata' => 'Pokaż dane',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoc dotycząca wewnętrznych zapytań',
	'smw-createproperty-isproperty' => 'To jest własność typu $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Dopuszczalna wartość dla tej własności to|Dopuszczalne wartości dla tej własności to:}}',
	'smw-info-par-message' => 'Wiadomość do wyświetlenia.',
	'prefs-smw' => 'Semantyczna MediaWiki',
	'prefs-ask-options' => 'Opcje wyszukiwania semantycznego',
	'smw-ui-tooltip-title-info' => 'Informacja',
	'smw-ui-tooltip-title-warning' => 'Błąd',
	'smw-ui-tooltip-title-parameter' => 'Parametr',
	'smw-ui-tooltip-title-event' => 'Wydarzenie',
	'smw_unknowntype' => 'Typ atrybutu jest nieprawidłowy.',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'smw-desc' => "Rende soa wiki pì acessìbil - për le màchine ''e'' j'uman ([http://semantic-mediawiki.org/wiki/Help:User_manual documentassion an linia])",
	'smw_viewasrdf' => 'Fluss RDF',
	'smw_finallistconjunct' => 'e',
	'smw_factbox_head' => 'Fàit a propòsit ëd $1',
	'smw_isspecprop' => "Costa propietà a l'é na propietà special ëd costa wiki.",
	'smw_concept_description' => 'Descrission dël concet «$1»',
	'smw_no_concept_namespace' => 'Ij concet a peulo mach esse definì ant le pàgine dlë spassi nominal Concept:.',
	'smw_multiple_concepts' => 'Minca pàgina ëd concet a peul avèj mach na definission.',
	'smw_concept_cache_miss' => "Ël concet «$1» a peul pa esse dovrà ant ës moment, përchè la configurassion ëd la wiki a ciama ch'a sia calcolà fòra ëd linia.
Se ël problema a van nen via an chèich moment, ciamé a l'aministrator ëd sò sit ëd rende 's concet disponìbil.",
	'smw_noinvannot' => 'Ij valor a peulo pa esse assignà a le proprietà anverse.',
	'version-semantic' => 'Estension semàntiche',
	'smw_baduri' => 'URI dla forma "$1" a son pa përmëttù.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => "Conta dj'arzultà",
	'smw_printername_csv' => 'esportassion an CSV',
	'smw_printername_dsv' => 'esportassion an DSV',
	'smw_printername_debug' => "Arcesta d'eliminassion dij bigat (për gent pràtica)",
	'smw_printername_embedded' => 'Contù dle pàgine mojà',
	'smw_printername_json' => 'esportassion an JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumerassion',
	'smw_printername_ul' => 'Detaj',
	'smw_printername_rss' => 'Esportassion RSS',
	'smw_printername_table' => 'Tàula',
	'smw_printername_broadtable' => 'Tàula estèisa',
	'smw_printername_template' => 'Stamp',
	'smw_printername_rdf' => 'Esportassion RDF',
	'smw-paramdesc-limit' => "Ël màssim nùmer d'arzultà da smon-e",
	'smw-paramdesc-headers' => "Mostré j'antestassion/ij nòm dle proprietà",
	'smw-paramdesc-mainlabel' => "L'etichëtta da dé al nòm ëd la pàgina prinsipal",
	'smw-paramdesc-link' => 'Smon-e ij valor com dle liure',
	'smw-paramdesc-intro' => "Ël test da mostré prima dj'arzultà dl'arcesta, s'a-i na j'é",
	'smw-paramdesc-outro' => "Ël test da mostré apress a j'arzultà dl'arcesta, s'a-i na j'é",
	'smw-paramdesc-default' => "Ël test da mostré s'a-i é gnun arzultà a l'arcesta",
	'smw-paramdesc-sep' => 'Ël separator për ij valor',
	'smw-paramdesc-template' => "Ël nòm ëd në stamp con ël qual visualisé j'arzultà",
	'smw-paramdesc-columns' => "Ël nùmer ëd colòne andoa mostré j'arzultà (lë stàndard a l'é $1)",
	'smw-paramdesc-userparam' => "Un valor passà an mincadun-a ciamà dë stamp, se në stamp a l'é dovrà",
	'smw-paramdesc-introtemplate' => "Ël nòm ëd në stamp da mostré prima dj'arzultà dl'arserca, s'a-i në j'é",
	'smw-paramdesc-outrotemplate' => "Ël nòm ëd në stamp da mostré apress ëd j'arzultà dl'arserca, s'a-i në j'é",
	'smw-paramdesc-embedformat' => "L'etichëtta HTML dovrà për definì j'antestassion",
	'smw-paramdesc-embedonly' => "Smon-e nen j'antestassion",
	'smw-paramdesc-rsstitle' => 'Ël test da mostré com tìtol dël fluss',
	'smw-paramdesc-rssdescription' => 'Ël test da dovré com descrission dël fluss',
	'smw-paramdesc-rdfsyntax' => 'La sintassi RDF da dovré',
	'smw-paramdesc-csv-sep' => 'Ël separator da dovré',
	'smw-paramdesc-dsv-separator' => 'Ël separator da dovré',
	'smw-paramdesc-dsv-filename' => "Ël nòm për l'archivi DSV",
	'smw-paramdesc-searchlabel' => "Ël test ant ël colegament a j'arzultà", # Fuzzy
	'smw_iq_disabled' => "J'arceste semàntiche a son ëstàite disabilità për sta wiki-sì.",
	'smw_iq_moreresults' => '... àutri arzultà',
	'smw_parseerror' => "Ël valor dàit a l'é pa stàit capì.",
	'smw_notitle' => "''$1'' a peul pa esse dovrà com nòm ëd pàgina an sta wiki-sì.",
	'smw_noproperty' => "''$1'' a peul pa esse dovrà com nòm ëd propietà an sta wiki-sì.",
	'smw_wrong_namespace' => "Mach le pàgine ant lë spassi nominal ''$1'' a son possìbij ambelessì.",
	'smw_manytypes' => 'Pi che un tipo definì për proprietà.',
	'smw_emptystring' => 'Stringhe veuide a son pa acetà.',
	'smw_maxstring' => "La rapresentassion dë stringa $1 a l'é tròp longa.",
	'smw_notinenum' => "''$1'' a l'é pa ant la lista dij valor possìbij ($2) për sta proprietà-sì.",
	'smw_noboolean' => "''$1'' a l'é pa arconossù 'me valor Boolean (ver/fàuss).",
	'smw_true_words' => 'ver,v,é!,é',
	'smw_false_words' => 'fàuss,f,nò,n',
	'smw_nofloat' => "''$1'' a l'é pa un nùmer",
	'smw_infinite' => "Nùmer gròss com ''$1'' a son pa mantnù.",
	'smw_unitnotallowed' => '"$1" a l\'é pa diciarà com unità dë mzura bon-a për costa proprietà.',
	'smw_novalues' => 'Pa gnun valor specificà.',
	'smw_nodatetime' => "La data ''$1'' a l'é pa stàita capìa.",
	'smw_toomanyclosing' => "A smija ch'a-i sio tròpe ocorense ëd ''$1'' ant l'arcesta.",
	'smw_noclosingbrackets' => 'Chèich usagi ëd "<nowiki>[[</nowiki>" an soa arcesta a son pa stàit sarà da un corëspondent "]]".',
	'smw_misplacedsymbol' => 'Ël sìmbol "$1" a l\'era dovrà ant un pòst andoa a l\'é pa ùtil.',
	'smw_unexpectedpart' => 'La part "$1" ëd l\'arcesta a l\'é pa stàita capìa.
J\'arzultà a peulo esse pa coma spetà.',
	'smw_emptysubquery' => "Chèich sot-arcesta a l'ha ëd condission pa bon-e.",
	'smw_misplacedsubquery' => "Chèich sot-arcesta a l'era dovrà ant un pòst andoa gnun-e sot-arceste a j'ero përmëttùe.",
	'smw_valuesubquery' => 'Sot-arcesta pa mantnùa për ij valor ëd la proprietà "$1".',
	'smw_badqueryatom' => 'Chèich part "<nowiki>[[…]]</nowiki>" ëd l\'arcesta a l\'é pa stàita capìa.',
	'smw_propvalueproblem' => 'Ël valor ëd la proprietà "$1" a l\'é pa stàit capì.',
	'smw_noqueryfeature' => "Chèica funsion ëd l'arcesta a l'é pa mantnù su sta wiki-sì e part ëd l'arcesta a l'é stàita sautà ($1).",
	'smw_noconjunctions' => "Le congiunsion ant j'arcesta a son pa mantnùe su sta wiki-sì e part ëd l'arcesta a l'é stàita sautà ($1).",
	'smw_nodisjunctions' => "Le disgiunsion ant j'arceste a son pa apogià su sta wiki-sì e part ëd l'arcesta a l'é stàita sautà ($1).",
	'smw_querytoolarge' => "Le condission ëd l'arcesta sì-sota a son pa stàite considerà an rason dla le restrission ëd la wiki ant la dimension o profondità dj'arceste: $1.",
	'smw_notemplategiven' => 'Dà un valor për ël paràmetr "stamp" an manera che sto formà-sì d\'arcesta a travaja.',
	'smw_db_sparqlqueryproblem' => "L'arzultà dl'anterogassion a l'ha pa podù esse otnù da la base ëd dàit SPARQL. S'eror a peul esse temporani o andiché n'eror ant ël programa dla base ëd dàit.",
	'smw_type_header' => 'Proprietà dël tipo "$1".',
	'smw_typearticlecount' => "Mostré $1 {{PLURAL:$1|la proprietà|le proprietà}} ch'a deuvro sto tipo-sì.",
	'smw_attribute_header' => 'Pàgine ch\'a deuvro la proprietà "$1".',
	'smw_attributearticlecount' => "Smon-e $1 {{PLURAL:$1|la pàgine|le pàgine}} ch'a deuvro sta proprietà-sì.",
	'smw_subproperty_header' => 'Sot-proprietà',
	'smw_subpropertyarticlecount' => "Sta proprietà-sì a l'ha le $1 {{PLURAL:$1|sot-proprietà|sot-proprietà}} sì-dapress:",
	'smw_concept_header' => 'Pàgine dël concet "$1"',
	'smw_conceptarticlecount' => 'Smon-e $1 {{PLURAL:$1|pàgina|pàgine}} che a aparten-o a col concet.',
	'exportrdf' => 'Espòrta pàgine an RDF',
	'smw_exportrdf_docu' => "Sta pàgina-sì a-j përmët d'oten-e dat da na pàgina an formà RDF.
Për esporté dle pàgine, ch'a anserissa ij tìtoj ant la casela ëd test sì-sota, un tìtol për linia.",
	'smw_exportrdf_recursive' => "Esporté ricorsivament tute le pàgine corelà.
Noté che l'arzultà a podrìa esse motobin gròss!",
	'smw_exportrdf_backlinks' => "Esporté ëdcò tute le pàgine ch'a s'arferisso a le pàgine esportà.
A génera RDF navigàbij.",
	'smw_exportrdf_lastdate' => 'Espòrta pa pàgine che a son pa stàite cangià dal moment specificà.',
	'smw_exportrdf_submit' => 'Esporté',
	'uriresolver' => "Arzolvidor d'URI",
	'properties' => 'Proprietà',
	'smw_properties_docu' => 'Le proprietà sì-sota a son dovrà ant la wiki.',
	'smw_property_template' => '$1 ëd tipo $2 ($3)',
	'smw_propertylackspage' => 'Tute le proprietà a dovrìo esse descrivùe da na pàgina!',
	'smw_propertylackstype' => "Gnun tipo a l'é stàit specificà për sta proprietà-sì (as fa cont ch'a sia ëd tipo $1, për adess).",
	'smw_propertyhardlyused' => "Sta proprietà-sì a l'é dovrà apen-a ant la wiki!",
	'unusedproperties' => 'Proprietà pa dovrà',
	'smw_unusedproperties_docu' => 'Le proprietà sì-sota a esisto, bele che gnun-e àutre pàgine a-j deuvro.',
	'smw_unusedproperty_template' => '$1 ëd tipo $2',
	'wantedproperties' => 'Proprietà vorsùe',
	'smw_wantedproperties_docu' => "Le proprietà sì-sota a son dovrà ant la wiki ma a l'han ancó pa na pàgina për descrivje.",
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|usagi|usagi}})',
	'smw_purge' => 'Rinfrësca',
	'types' => 'Tipo',
	'smw_types_docu' => "Cola sì-sota a l'é na lista ëd tùit ij tipo ëd dat che a peulo esse assignà a la proprietà.
Minca tipo ëd dat a l'ha na pàgina andoa d'anformassion adissionaj a peulo esse smonùe.", # Fuzzy
	'semanticstatistics' => 'Statìstiche semàntiche',
	'smw_semstats_text' => "Sta wiki-sì a conten '''$1''' {{PLURAL:$1|valor|valor}} ëd proprietà për un total ëd '''$2''' [[Special:Properties|{{PLURAL:$2|proprietà|proprietà diferente}}]].
'''$3''' {{PLURAL:$3|proprietà a l'ha|proprietà a l'han}} na soa pàgina, e ël tipo ëd dat a l'é specificà për '''$4''' ëd lor.
Cheidun-e dle proprietà esistente a peulo esse [[Special:UnusedProperties|proprietà pa dovrà]].
Proprietà che a l'han pa ancó na pàgina a peulo esse trovà dzora a la [[Special:WantedProperties|lista dle proprietà vorsùe]].",
	'smw_uri_doc' => "L'arzolvidor d'URI a realisa la <a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG finding on httpRange-14</a>.
A fa an manera che j'uman a dvento pa ëd sit ëd la Ragnà.",
	'ask' => 'Arserca semàntica',
	'smw_ask_sortby' => 'Órdina për colòna (opsional)',
	'smw_ask_ascorder' => 'Chërsent',
	'smw_ask_descorder' => 'Calant',
	'smw_ask_submit' => "Trové d'arzultà",
	'smw_ask_editquery' => "[Modifiché l'arcesta]",
	'smw_add_sortcondition' => "[Gionta condission d'órdin]",
	'smw_ask_hidequery' => "Stërmé l'arcesta",
	'smw_ask_help' => "Agiut an sj'arceste",
	'smw_ask_queryhead' => 'Anterogassion',
	'smw_ask_printhead' => 'Dat adissionaj da smon-e',
	'smw_ask_printdesc' => '(gionta un nòm ëd proprietà për linia);',
	'smw_ask_format_as' => 'Ampaginé com:',
	'smw_ask_defaultformat' => 'stàndard',
	'smw_ask_otheroptions' => 'Àutre opsion',
	'smw_ask_show_embed' => 'Smon-e ël còdes antern',
	'smw_ask_hide_embed' => 'Stërmé ël còdes antern',
	'smw_ask_embed_instr' => "Për anclude costa anterogassion an linia ant na pàgina wiki, ch'a deuvra ël còdes sì-sota.",
	'searchbyproperty' => 'Serca për proprietà',
	'smw_sbv_docu' => "Serca për tute le pàgine che a l'han proprietà e valor dàit.",
	'smw_sbv_novalue' => 'Ch\'a anserissa un valor bon për la proprietà, o ch\'a varda tùit ij valor ëd le proprietà për "$1".',
	'smw_sbv_displayresult' => 'Na lista ëd tute le pàgine che a l\'han la proprietà "$1" con valor "$2"',
	'smw_sbv_displayresultfuzzy' => 'Na lista ëd tute le pàgine che a l\'han la proprietà "$1" con valor "$2".
Dagià ch\'a-i son ëstàje mach pòchi arzultà, a son smonù ëdcò ij valor davzin.',
	'smw_sbv_property' => 'Propietà:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => "Trové dj'arzultà",
	'browse' => 'Varda wiki',
	'smw_browselink' => 'Varda propietà',
	'smw_browse_article' => "Ch'a anseriss ël nòm ëd la pàgina da andoa ancaminé a vardé.",
	'smw_browse_go' => 'Va',
	'smw_browse_show_incoming' => 'smon-e le propietà che a colego ambelessì',
	'smw_browse_hide_incoming' => "stërmé le propietà ch'a colego ambelessì",
	'smw_browse_no_outgoing' => "Sta pàgina-sì a l'ha pa ëd propietà.",
	'smw_browse_no_incoming' => 'Gnun-a propietà a colega a sta pàgina-sì.',
	'smw_inverse_label_default' => '$1 ëd',
	'smw_inverse_label_property' => 'Etichëtta dla propietà anversa',
	'pageproperty' => 'Serca propietà dla pàgina',
	'smw_pp_docu' => 'Serca tùit ij valor ëd na propietà su na pàgina dàita.',
	'smw_pp_from' => 'Da pàgina',
	'smw_pp_type' => 'Propietà',
	'smw_pp_submit' => "Smon-e j'arzultà",
	'smw_result_prev' => 'Prima',
	'smw_result_next' => 'Apress',
	'smw_result_results' => 'Arzultà',
	'smw_result_noresults' => 'Pa gnun arzultà.',
	'smwadmin' => "Funsion d'aministrator për Semantic MediaWiki",
	'smw_smwadmin_setupsuccess' => "Ël motor ëd memorisassion a l'é stàit anstalà da bin.",
	'smw_smwadmin_return' => 'Torna a $1',
	'smw_smwadmin_updatestarted' => "Un process ëd modìfica neuv për rinfrësché ij dat semàntich a l'é stàit fàit parte.
Tùit ij dat memorisà a saran rifàit o riparà andoa a-i é dabzògn.
A peul trové l'andament ëd la modìfica an sta pàgina special-sì.", # Fuzzy
	'smw_smwadmin_updatenotstarted' => "A-i é già un process ëd modìfica an camin.
Creene nen n'àutr.", # Fuzzy
	'smw_smwadmin_updatestopped' => 'Tùit ij process ëd modìfica esistent a son ëstàit fërmà.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => "Për fërmé ël process ëd modìfica an cors, a deuv ativé la casela për indiché ch'a l'é pròpi sicur.", # Fuzzy
	'smw_smwadmin_docu' => "Sta pàgina special-sì a lo giuta durant l'instalassion e l'agiornament ëd <a href=\"http://semantic-mediawiki.org\">Semantic MediaWiki</a>.
Ch'as visa ëd salvé ij dat ëd valor prima ëd fé le funsion aministrative.",
	'smw_smwadmin_db' => 'Anstalassion e agiornament dla base ëd dàit',
	'smw_smwadmin_dbdocu' => "Semantic MediaWiki a l'ha dabzògn ëd chèiche estension a la base ëd dàit MediaWiki për memorisé ij dat semàntich.
La funsion sì-sota a assicura che soa base ëd dàit a l'é ampostà për da bin.
Ij cangiament fàit an cost pass-sì a toco pa ël rest dla bse ëd dàit mediaWiki, e a l'é bel fé torné andré s'as veul.
Sta funsion d'ampostassion-sì a peul esse fàita vàire vire sensa fé gnun dann, ma a-i n'a j'é dabzògn mach na vira për l'anstalassion o l'agiornament.",
	'smw_smwadmin_permissionswarn' => "Se l'operassion a faliss con dj'eror SQL, l'utent dla base ëd dàit dovrà da soa wiki (ch'a contròla sò LocalSettings.php) probabilment a l'ha pa basta 'd përmess.
O bin ch'a-j daga a st'utent dij përmess adissionaj për creé e scancelé 'd tabele, temporaneament ch'a anserissa lë stranòm ëd l'utent ris an  LocalSettings.php, opura ch'a deuvra ël senari ëd manteniment <tt>SMW_setup.php</tt> ch'a peul dovré le credensiaj d'AdminSettings.php.", # Fuzzy
	'smw_smwadmin_dbbutton' => 'Inissialisé o agiorné le tàule',
	'smw_smwadmin_announce' => 'Anonsia toa wiki',
	'smw_smwadmin_announcedocu' => "Semantic MediaWiki a l'ha un servissi an grija për nonsié ëd sit neuv ëd wiki semàntiche.
Sòn a l'é dovrà për manten-e na lista ëd sit pùblich che a deuvro Semantic MediaWiki, pi che d'àutr për giuté ël <a href=\"http://semantic-mediawiki.org/wiki/SMW_Project\">proget Semantic MediaWiki</a> a avèj na vision dj'usagi tìpich ëd Semantic MediaWiki.
Ch'a bèica la pàgina ëd Semantic MediaWiki për <a href=\"http://semantic-mediawiki.org/wiki/Registry\">d'àutre anformassion su 's servissi</a>.",
	'smw_smwadmin_announcebutton' => "Ch'a sgnaca ël boton sì-sota për mandé adrësse dl'aragnà wiki a col servissi là.
Ël servissi a registrërà pa le wiki ch'a son pa acessìbij pùblicament, e a memorisërà mach j'anformassion acessìbij publicament.",
	'smw_smwadmin_datarefresh' => 'Riparassion ëd dat e agiornament',
	'smw_smwadmin_datarefreshdocu' => "A l'é possìbil ripristiné tùit ij dat Semantic MediaWiki basà dzora al contnù corent ëd la wiki.
Sòn a peul ven-e a taj për riparé dat rot o për rinfrësché dat se ël formà antern a l'é cangià për chèich agiornament dël programa.
La modìfica a l'é fàita pàgina për pàgina e a sarà pa completa sùbit.
Lòn ch'a-i é sì-sota a mostra se na modìfica a l'é an cors e a-j përmët ëd fé parte o fërmé le modìfiche (gavà che sta possibilità a sia stàita disabilità da l'aministrator dël sit).",
	'smw_smwadmin_datarefreshprogress' => "<strong>na modìfica a l'é già an cors.</strong>
A l'é normal che la modìfica a von-a anans mach pian përchè a rinfrësca dat an cite partìe minca vira che n'utent a intra ant la wiki.
Për fé finì sta modìfica pi an pressa, a peul ciamé ël senari ëd manteniment MediaWiki <tt>runJobs.php</tt> (ch'a deuvra l'opsion <tt>--maxjobs 1000</tt> për strenze ël nùmer ëd modìfiche fàite ant un lòt).
Avansament stimà dla modìfica corenta:",
	'smw_smwadmin_datarefreshbutton' => 'Ancamin-a a agiorné ij dat',
	'smw_smwadmin_datarefreshstop' => 'Ferma sto agiornament-sì',
	'smw_smwadmin_datarefreshstopconfirm' => 'Bò, i son sicur.',
	'smw_smwadmin_support' => "Oteniment ëd n'agiut",
	'smw_smwadmin_supportdocu' => 'Vàire arsorse a peulo giutelo an cas ëd problema:',
	'smw_smwadmin_installfile' => "S'a treuva ëd problema con soa anstalassion, ch'a ancamin-a a controlé le linie guida ant l'<a href=\"https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD\">archivi INSTALL</a>.",
	'smw_smwadmin_smwhomepage' => 'La documentassion utent completa ëd Semantich WikiMedia a l\'é a <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Ij bigat a peulo esse arportà a <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => "S'a l'ha d'àutre chestion o sugeriment, ch'a vada a la discussion dzora a la <a href=\"http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user\">piassa dj'utent ëd Semantic MediaWiki</a>.",
	'smw_adminlinks_datastructure' => 'Strutura dij dat',
	'smw_adminlinks_displayingdata' => 'Visualisé ij dat',
	'smw_adminlinks_inlinequerieshelp' => "Agiut an sj'anterogassion an linia",
	'smw-createproperty-isproperty' => "Costa-sì a l'é na proprietà ëd sòrt $1.",
	'smw-createproperty-allowedvals' => "{{PLURAL:$1|Ël valor përmëttù për sta proprietà-sì a l'é|Ij valor përmëttù për sta proprietà-sì a son}}:",
	'smw_unknowntype' => "Un tipo ''$1'' pa mantnù a l'é definì për proprietà.", # Fuzzy
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'smw_finallistconjunct' => '، او',
	'smw_printername_list' => 'لړليک',
	'smw_printername_template' => 'کينډۍ',
	'smw_printername_category' => 'وېشنيزه',
	'validator-type-class-SMWParamSource' => 'متن',
	'smw_iq_moreresults' => 'نورې پايلې ...',
	'smw_true_words' => 'سم، س، هو، هـ',
	'smw_false_words' => 'ناسم، نا، نه، ن',
	'smw_nodatetime' => 'دا "$1" نېټه و نه پېژندل شوه.',
	'smw_exportrdf_submit' => 'صادرول',
	'properties' => 'ځانتياوې',
	'unusedproperties' => 'ناکارېدلې ځانتياوې',
	'wantedproperties' => 'غوښتل شوې ځانتياوې',
	'smw_ask_ascorder' => 'ختند',
	'smw_ask_defaultformat' => 'تلواليز',
	'smw-ask-delete' => '[ړنګول]',
	'smw_qc_default' => 'تلواليز:',
	'smw_qui_prop' => 'ځانتيا:',
	'smw_qui_limt' => 'بريد:',
	'smw_qui_ascorder' => 'ختند',
	'smw_qui_options' => 'خوښنې',
	'smw_qui_addcategory' => 'وېشنيزه ورګډول',
	'smw_qui_ok' => 'ښه',
	'smw_qui_cancel' => 'ناګارل',
	'smw_qui_dcategory' => 'وېشنيزه:',
	'smw_sbv_property' => 'ځانتيا:',
	'smw_sbv_value' => 'ارزښت:',
	'smw_sbv_submit' => 'پايلې موندل',
	'browse' => 'ويکي سپړل',
	'smw_browselink' => 'د سپړلو ځانتياوې',
	'smw_browse_go' => 'ورځه',
	'smw_pp_type' => 'ځانتيا',
	'smw_pp_submit' => 'پايلې موندل',
	'smw_result_prev' => 'پخواني',
	'smw_result_next' => 'راتلونکي',
	'smw_result_results' => 'پايلې',
	'smw_result_noresults' => 'بې پايلو.',
	'smw_smwadmin_return' => '$1 ته ورګرځېدل',
	'smw_smwadmin_datarefreshstopconfirm' => 'هو، زه ډاډه يم.',
	'smw-ui-tooltip-title-info' => 'مالومات',
	'smw-ui-tooltip-title-warning' => 'تېروتنه',
);

/** Portuguese (português)
 * @author Crazymadlover
 * @author Hamilton Abreu
 * @author Lijealso
 * @author Luckas Blade
 * @author Malafaya
 * @author SandroHc
 * @author Waldir
 * @author 555
 */
$messages['pt'] = array(
	'smw-desc' => "Tornar a sua wiki mais inteligível - para máquinas ''e'' seres humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentação ''online''])",
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => 'e',
	'smw_factbox_head' => 'Factos sobre $1',
	'smw_isspecprop' => 'Esta propriedade é uma propriedade especial nesta wiki.',
	'smw_concept_description' => 'Descrição do conceito "$1"',
	'smw_no_concept_namespace' => 'Os conceitos só podem ser definidos em páginas do espaço nominal Concept:.',
	'smw_multiple_concepts' => 'Cada página de conceito só pode conter a definição de um conceito.',
	'smw_concept_cache_miss' => "O conceito \"\$1\" não pode ser usado neste momento, porque a configuração da wiki requer que ele seja calculado ''off-line''. Caso o problema não seja resolvido dentro de algum tempo, peça a um administrador da wiki que disponibilize este conceito.",
	'smw_noinvannot' => 'Não podem ser atribuídos valores a propriedades inversas.',
	'version-semantic' => 'Extensões semânticas',
	'smw_baduri' => 'URIs da forma “$1” não são permitidos.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Contar resultados',
	'smw_printername_csv' => 'Exportação CSV',
	'smw_printername_dsv' => 'Exportação DSV',
	'smw_printername_debug' => 'Depurar a consulta (para peritos)',
	'smw_printername_embedded' => 'Incorporar o conteúdo da página',
	'smw_printername_json' => 'Exportação JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeração',
	'smw_printername_ul' => 'Discriminação',
	'smw_printername_rss' => 'Exportação RSS',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Tabela ampla',
	'smw_printername_template' => 'Predefinição',
	'smw_printername_rdf' => 'Exportação para RDF',
	'smw_printername_category' => 'Categoria',
	'smw-paramdesc-limit' => 'O número máximo de resultados a devolver',
	'smw-paramdesc-offset' => 'A posição do primeiro resultado',
	'smw-paramdesc-headers' => 'Apresentar os nomes dos cabeçalhos e propriedades',
	'smw-paramdesc-mainlabel' => 'A etiqueta a atribuir ao nome da página principal',
	'smw-paramdesc-link' => 'Apresentar os valores na forma de links',
	'smw-paramdesc-intro' => 'O texto a apresentar antes dos resultados da consulta, caso existam',
	'smw-paramdesc-outro' => 'O texto a apresentar após os resultados da consulta, caso existam',
	'smw-paramdesc-default' => 'O texto a apresentar se a consulta não produzir resultados',
	'smw-paramdesc-sep' => 'O separador de valores',
	'smw-paramdesc-template' => 'O nome da predefinição com a qual são apresentadas as impressões',
	'smw-paramdesc-columns' => 'O número de colunas em que os resultados serão apresentados (por omissão, $1)',
	'smw-paramdesc-userparam' => 'Um valor fornecido a cada chamada da predefinição, se for usada uma predefinição',
	'smw-paramdesc-introtemplate' => 'O nome de uma predefinição para apresentar antes dos resultados da consulta, se existirem',
	'smw-paramdesc-outrotemplate' => 'O nome de uma predefinição para apresentar após os resultados da consulta, se existirem',
	'smw-paramdesc-embedformat' => 'O elemento HTML usado para definir cabeçalhos',
	'smw-paramdesc-embedonly' => 'Não mostrar cabeçalhos',
	'smw-paramdesc-rsstitle' => "O texto que será usado como título do ''feed''",
	'smw-paramdesc-rssdescription' => "O texto que será usado como descrição do ''feed''",
	'smw-paramdesc-rdfsyntax' => 'A sintaxe RDF a utilizar',
	'smw-paramdesc-csv-sep' => 'O separador a usar',
	'smw-paramdesc-dsv-separator' => 'O separador a usar',
	'smw-paramdesc-dsv-filename' => 'O nome para o ficheiro DSV',
	'smw-smwdoc-description' => 'Apresenta uma tabela de todos os parâmetros que podem ser usados para o formato de resultados especificado, com os respectivos valores por omissão e descrições',
	'smw-smwdoc-par-format' => 'O formato de resultados para o qual será apresentada a documentação dos parâmetros.',
	'smw-paramdesc-searchlabel' => 'O texto no link dos resultados', # Fuzzy
	'smw_iq_disabled' => 'As consultas semânticas foram impossibilitadas nesta wiki.',
	'smw_iq_moreresults' => '… mais resultados',
	'smw_parseerror' => 'O valor fornecido não foi compreendido.',
	'smw_notitle' => '“$1” não pode ser usado como nome de uma página nesta wiki.',
	'smw_noproperty' => '“$1” não pode ser usado como nome de uma propriedade nesta wiki.',
	'smw_wrong_namespace' => 'Só são permitidas aqui páginas do espaço nominal "$1".',
	'smw_manytypes' => 'Foi definido mais de um tipo para a propriedade.',
	'smw_emptystring' => 'Não são aceites textos vazios.',
	'smw_maxstring' => 'A representação do texto $1 é demasiado longa.',
	'smw_notinenum' => '“$1” não está na lista dos valores possíveis ($2) para esta propriedade.',
	'smw_noboolean' => '“$1” não é reconhecido como um valor booleano (verdadeiro/falso).',
	'smw_true_words' => 'verdadeiro,v,sim,s',
	'smw_false_words' => 'falso,f,não,nao,n',
	'smw_nofloat' => '“$1” não é um número.',
	'smw_infinite' => 'Números da dimensão de “$1” não são suportados.',
	'smw_unitnotallowed' => '"$1" não está declarada como unidade de medida válida para esta propriedade.',
	'smw_nounitsdeclared' => 'Não foi declarada nenhuma unidade de medida para esta propriedade.',
	'smw_novalues' => 'Não foram especificados valores.',
	'smw_nodatetime' => 'A data “$1” não foi compreendida.',
	'smw_toomanyclosing' => 'Parece haver demasiadas ocorrências de "$1" na consulta.',
	'smw_noclosingbrackets' => 'Um uso de "<nowiki>[[</nowiki>" na sua consulta não foi fechado com o "]]" correspondente.',
	'smw_misplacedsymbol' => 'O símbolo “$1” foi usado num sítio onde não tem utilidade.',
	'smw_unexpectedpart' => 'A parte "$1" da consulta não foi compreendida.
Os resultados poderão não ser os esperados.',
	'smw_emptysubquery' => 'Há uma subconsulta que não tem nenhuma condição válida.',
	'smw_misplacedsubquery' => 'Foi usada uma subconsulta num local onde não são permitidas subconsultas.',
	'smw_valuesubquery' => 'Não são suportadas subconsultas para valores da propriedade "$1".',
	'smw_badqueryatom' => 'Uma parte "<nowiki>[[…]]</nowiki>" da consulta não foi compreendida.',
	'smw_propvalueproblem' => 'O valor da propriedade “$1” não foi compreendido.',
	'smw_noqueryfeature' => 'Uma característica da consulta não é suportada nesta wiki e parte da consulta foi descartada ($1).',
	'smw_noconjunctions' => 'Conjunções em consultas não são suportadas nesta wiki e parte da consulta foi descartada ($1).',
	'smw_nodisjunctions' => 'Disjunções em consultas não são suportadas nesta wiki e parte da consulta foi descartada ($1).',
	'smw_querytoolarge' => 'Não foi possível considerar as seguintes condições da consulta, devido às restrições da wiki para o tamanho e profundidade das consultas: $1.',
	'smw_notemplategiven' => 'Para este formato de consulta funcionar, forneça um valor para o parâmetro "template".',
	'smw_db_sparqlqueryproblem' => 'Não foi possível obter da base de dados SPARQL o resultado da consulta. Este erro pode ser temporário ou indicativo de um defeito no software da base de dados.',
	'smw_db_sparqlqueryincomplete' => 'A consulta revelou-se difícil e foi interrompida. Podem faltar alguns resultados. Se possível, tente usar uma consulta mais simples, por favor.',
	'smw_type_header' => 'Propriedades do tipo “$1”',
	'smw_typearticlecount' => 'A apresentar {{PLURAL:$1|uma propriedade que usa|$1 propriedades que usam}} este tipo.',
	'smw_attribute_header' => 'Páginas que usam a propriedade “$1”',
	'smw_attributearticlecount' => 'A apresentar {{PLURAL:$1|uma página que usa|$1 páginas que usam}} esta propriedade.',
	'smw_subproperty_header' => 'Subpropriedades',
	'smw_subpropertyarticlecount' => 'Esta propriedade tem {{PLURAL:$1|a seguinte subpropriedade|as seguintes $1 subpropriedades}}:',
	'smw_concept_header' => 'Páginas do conceito "$1"',
	'smw_conceptarticlecount' => 'A apresentar {{PLURAL:$1|uma página pertencente|$1 páginas pertencentes}} ao conceito.',
	'smw_rss_description' => 'Feed RSS de $1',
	'exportrdf' => 'Exportar páginas para RDF',
	'smw_exportrdf_docu' => 'Esta página permite-lhe obter dados de uma página com o formato RDF.
Para exportar páginas, introduza os seus títulos na caixa de texto abaixo, um título por linha.',
	'smw_exportrdf_recursive' => 'Exportar recursivamente todas as páginas relacionadas.
Note que o resultado pode ser volumoso!',
	'smw_exportrdf_backlinks' => 'Exportar também todas as páginas que referem as páginas exportadas.
Gera um RDF navegável.',
	'smw_exportrdf_lastdate' => 'Não exportar páginas que não tenham sido alteradas desde o dado ponto no tempo.',
	'smw_exportrdf_submit' => 'Exportar',
	'uriresolver' => 'Resolvedor de URIs',
	'properties' => 'Propriedades',
	'smw_properties_docu' => 'As seguintes propriedades são usadas nesta wiki.',
	'smw_property_template' => '$1 de tipo $2 ($3)',
	'smw_propertylackspage' => 'Todas as propriedades devem ser descritas por uma página!',
	'smw_propertylackstype' => 'Não foi especificado nenhum tipo para esta propriedade (a assumir o tipo $1 por agora).',
	'smw_propertyhardlyused' => 'Esta propriedade é muito pouco usada nesta wiki!',
	'unusedproperties' => 'Propriedades não usadas',
	'smw_unusedproperties_docu' => 'As seguintes propriedade existem apesar de nenhuma página as usar.',
	'smw_unusedproperty_template' => '$1 do tipo $2',
	'wantedproperties' => 'Propriedades em falta',
	'smw_wantedproperties_docu' => 'As seguintes propriedades são usadas na wiki mas ainda não têm uma página que as descreva.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'smw_purge' => 'Actualizar',
	'types' => 'Tipos',
	'smw_types_docu' => 'A seguinte lista contém todos os tipos de dados que podem ser atribuídos às propriedades.',
	'semanticstatistics' => 'Estatísticas de semântica',
	'smw_semstats_text' => "Esta wiki contém '''$1''' {{PLURAL:$1|valor de propriedade|valores de propriedades}}, num total de '''$2''' [[Special:Properties|{{PLURAL:$2|propriedade|propriedades diferentes}}]].
'''$3''' {{PLURAL:$3|propriedade tem|propriedades têm}} uma página própria e o tipo de dados pretendido está especificado para '''$4''' delas.
Algumas das propriedades existentes podem ser [[Special:UnusedProperties|propriedades não usadas]].
As propriedades que não têm uma página própria podem ser encontradas na [[Special:WantedProperties|lista de propriedades em falta]].",
	'smw_uri_doc' => 'O resolvedor de URIs implementa a <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">descoberta TAG da W3C sobre o httpRange-14</a>. Certifica-se de que os seres humanos não se tornem em sites da internet.',
	'ask' => 'Pesquisa semântica',
	'smw_ask_sortby' => 'Ordenar por coluna (opcional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Procurar resultados',
	'smw_ask_editquery' => '[Editar consulta]',
	'smw_add_sortcondition' => '[Adicionar condição de ordenação]',
	'smw_ask_hidequery' => 'Esconder consulta',
	'smw_ask_help' => 'Ajuda sobre consultas',
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Dados adicionais para apresentar',
	'smw_ask_printdesc' => '(adicionar um nome de propriedade por linha)',
	'smw_ask_format_as' => 'Formatar como:',
	'smw_ask_defaultformat' => 'padrão',
	'smw_ask_otheroptions' => 'Outras opções',
	'smw_ask_show_embed' => 'Mostrar código para incorporação',
	'smw_ask_hide_embed' => 'Ocultar código de incorporação',
	'smw_ask_embed_instr' => 'Para incorporar esta consulta numa página da wiki, use o código abaixo.',
	'querycreator' => 'Criador de Consultas',
	'smw_qc_show_addnal_opts' => 'Mostrar mais opções',
	'smw_qc_hide_addnal_opts' => 'Mostrar menos opções',
	'smw_qc_default' => 'Padrão:',
	'smw_qc_query_help' => 'Introduza uma consulta usando o formulário abaixo. Seleccione páginas da wiki com base em
Categorias (<strong><nowiki>ex. [[Categoria:Actor]]</nowiki></strong>),
Propriedades (<strong><nowiki>ex. [[Localizada em::Angola]]</nowiki></strong>), 
Nomes (<strong><nowiki>ex. [[Cabo Verde]]</nowiki></strong>) e
Espaços nominais (<strong><nowiki>ex. [[Ajuda:+]]</nowiki></strong>),',
	'smw_qui_property' => '<strong>Propriedade</strong>',
	'smw_qui_shownresults' => 'apresentar nos resultados',
	'smw_qui_noquery' => 'Não foi especificada nenhuma consulta',
	'smw_qui_invalidprop' => '"$1" pode não ser uma propriedade válida',
	'smw_qui_invalidformat' => 'O formato escolhido "$1" não existe nesta wiki',
	'smw_qui_nosort' => 'Sem ordenação',
	'smw_qui_ascorder' => 'Ascendente',
	'smw_qui_descorder' => 'Descendente',
	'smw_qui_randorder' => 'Aleatório',
	'smw_qui_addnprop' => 'Adicionar propriedade',
	'smw_qui_delete' => 'Remover',
	'smw_qui_options' => 'opções',
	'smw_qui_addcategory' => 'adicionar categoria',
	'smw_qui_ok' => 'Ok',
	'smw_qui_cancel' => 'Cancelar',
	'smw_qui_dcategory' => 'Categoria:',
	'searchbyproperty' => 'Pesquisa por propriedade',
	'smw_sbv_docu' => 'Procurar todas as páginas que têm uma determinada propriedade e valor.',
	'smw_sbv_novalue' => 'Introduza um valor válido para a propriedade, ou veja todos os valores válidos da propriedade “$1.”',
	'smw_sbv_displayresult' => 'Segue-se uma lista de todas as páginas que têm a propriedade “$1” com o valor “$2”',
	'smw_sbv_displayresultfuzzy' => 'Uma lista de todas as páginas que têm a propriedade "$1" com o valor "$2".
Como houve poucos resultados, também são apresentados valores próximos.',
	'smw_sbv_property' => 'Propriedade:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Procurar resultados',
	'browse' => 'Navegar pela wiki',
	'smw_browselink' => 'Navegar pelas propriedades',
	'smw_browse_article' => 'Introduza o nome da página a partir da qual deseja começar a navegar.',
	'smw_browse_go' => 'Prosseguir',
	'smw_browse_show_incoming' => 'mostrar propriedades que apontem para cá',
	'smw_browse_hide_incoming' => 'ocultar propriedades que apontem para cá',
	'smw_browse_no_outgoing' => 'Esta página não tem propriedades.',
	'smw_browse_no_incoming' => 'Nenhuma das propriedades aponta para esta página.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiqueta da propriedade inversa',
	'pageproperty' => 'Pesquisa das propriedades das páginas',
	'smw_pp_docu' => 'Pesquisar todos os valores de uma propriedade numa dada página.
Introduza a página e a propriedade.',
	'smw_pp_from' => 'Da página',
	'smw_pp_type' => 'Propriedade',
	'smw_pp_submit' => 'Procurar resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Seguinte',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Não há resultados.',
	'smwadmin' => 'Funções administrativas do MediaWiki Semântico',
	'smw_smwadmin_setupsuccess' => 'O motor de armazenamento foi configurado com sucesso.',
	'smw_smwadmin_return' => 'Voltar a $1',
	'smw_smwadmin_updatestarted' => 'Foi iniciado um novo processo de actualização para refrescar os dados semânticos.
Todos os dados armazenados serão reconstruídos ou reparados conforme for necessário.
Pode seguir o progresso de actualização nesta página especial.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Já existe um processo de actualização em curso.
Não foi criado outro.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Todos os processos de actualização existentes foram parados.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Para parar o processo de actualização em curso, deve marcar a caixa de selecção para indicar que tem realmente a certeza.', # Fuzzy
	'smw_smwadmin_docu' => 'Esta página especial auxilia-o durante a instalação ou actualização do <a href="http://semantic-mediawiki.org">MediaWiki Semântico</a>.
Lembre-se de efectuar cópias de segurança dos dados importantes antes de executar funções administrativas.',
	'smw_smwadmin_db' => 'Instalação e actualização da base de dados',
	'smw_smwadmin_dbdocu' => 'O MediaWiki Semântico requer algumas alterações da base de dados do MediaWiki, de forma a armazenar os dados semânticos.
A função abaixo assegura que a sua base de dados está devidamente preparada.
As alterações feitas neste passo não afectam o resto da base de dados do MediaWiki, e podem ser facilmente desfeitas se desejado.
Esta função de preparação pode ser executada várias vezes sem causar quaisquer danos, mas é necessária apenas uma vez na instalação ou actualização.',
	'smw_smwadmin_permissionswarn' => "Se a operação falhar com erros de SQL, é provável que o utilizador da base de dados usado pela sua wiki (consulte o seu LocalSettings.php) não tenha as permissões necessárias.
Conceda a este utilizador permissões adicionais para criar e eliminar tabelas, introduza temporariamente as credenciais do seu super-utilizador (<i>root</i>) da base de dados em LocalSettings.php, ou use o ''script'' de manutenção <tt>SMW_setup.php</tt>, o qual pode usar as credenciais presentes em AdminSettings.php.", # Fuzzy
	'smw_smwadmin_dbbutton' => 'Inicializar ou actualizar tabelas',
	'smw_smwadmin_announce' => 'Anuncie a sua wiki',
	'smw_smwadmin_announcedocu' => 'O MediaWiki Semântico tem um serviço na internet \'\'(web service)\'\' para anunciar novas wikis semânticas.
Este é usado para manter uma lista de sites públicos que usam o MediaWiki Semântico, principalmente para auxiliar o <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projecto MediaWiki Semântico</a> a obter uma ideia geral das utilizações típicas do MediaWiki Semântico.
Veja a página inicial do MediaWiki Semântico para <a href="http://semantic-mediawiki.org/wiki/Registry">mais informações sobre este serviço</a>.',
	'smw_smwadmin_announcebutton' => 'Clique o seguinte botão para enviar a URL da sua wiki ao serviço.
O serviço não registará wikis que não estejam publicamente acessíveis e apenas armazenará informação publicamente acessível.',
	'smw_smwadmin_datarefresh' => 'Reparação de dados e actualização',
	'smw_smwadmin_datarefreshdocu' => 'É possível restaurar todos os dados do MediaWiki Semântico baseado no conteúdo actual da wiki.
Isto pode ser útil para reparar dados corrompidos ou para refrescar os dados se o formato interno tiver sido alterado devido a alguma evolução do software.
A actualização é executada página a página e não ficará completa de imediato.
Abaixo é mostrado se uma actualização está a decorrer e permite-lhe iniciar ou parar actualizações (a menos que esta funcionalidade tenha sido desactivada por um administrador do site).',
	'smw_smwadmin_datarefreshprogress' => "<strong>Já se encontra a decorrer uma actualização.</strong>
É normal que a actualização progrida lentamente já que apenas refresca dados em pequenos blocos de cada vez que um utilizador acede à wiki.
Para terminar esta actualização mais rapidamente, pode executar o ''script'' de manutenção do MediaWiki <tt>runJobs.php</tt> (use a opção <tt>--maxjobs 1000</tt> para restringir o número de actualizações feitas em cada bloco).
Progresso estimado da actualização em curso:",
	'smw_smwadmin_datarefreshbutton' => 'Iniciar a actualização dos dados',
	'smw_smwadmin_datarefreshstop' => 'Parar esta actualização',
	'smw_smwadmin_datarefreshstopconfirm' => 'Sim, tenho a certeza.',
	'smw_smwadmin_support' => 'Obtendo suporte',
	'smw_smwadmin_supportdocu' => 'Vários recursos poderão ajudá-lo em caso de problemas:',
	'smw_smwadmin_installfile' => 'Se tiver problemas com a sua instalação, comece por rever as linhas orientadoras no <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">ficheiro INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'A documentação completa para o utilizador do MediaWiki Semântico está em <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Pode reportar defeitos no <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Se tem mais questões ou sugestões, junte-se à discussão no <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">fórum dos utilizadores do MediaWiki Semântico</a>.',
	'smw_adminlinks_datastructure' => 'Estrutura de dados',
	'smw_adminlinks_displayingdata' => 'A mostrar os dados',
	'smw_adminlinks_inlinequerieshelp' => "Ajuda para consultas dinâmicas ''(inline queries)''",
	'smw-createproperty-isproperty' => 'Esta é uma propriedade do tipo $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|O valor permitido para esta propriedade é|Os valores permitidos para esta propriedade são}}:',
	'smw_unknowntype' => 'Foi definido para a propriedade o tipo não suportado “$1”.', # Fuzzy
);

/** Brazilian Portuguese (português do Brasil)
 * @author Eduardo.mps
 * @author GKnedo
 * @author Giro720
 * @author Hamilton Abreu
 * @author Helder.wiki
 * @author Heldergeovane
 * @author Jaideraf
 * @author Luckas Blade
 * @author Rafael Vargas
 * @author Waldir
 * @author 555
 */
$messages['pt-br'] = array(
	'smw-desc' => "Tornando seu wiki mais acessível - para máquinas ''e'' humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentação ''online''])",
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => ' e',
	'smw_factbox_head' => 'Dados sobre $1',
	'smw_isspecprop' => 'Esta propriedade é uma propriedade especial neste wiki.',
	'smw_concept_description' => 'Descrição do conceito "$1"',
	'smw_no_concept_namespace' => 'Conceitos só podem ser definidos em páginas no domínio Conceito:.',
	'smw_multiple_concepts' => 'Cada página de conceito pode ter apenas uma definição de conceito.',
	'smw_concept_cache_miss' => 'O conceito "$1" não pode ser utilizado neste momento, uma vez que a configuração deste wiki necessita ser refeita off-line. 
Caso o problema não seja resolvido automaticamente dentro de algum tempo, peça a um administrador deste wiki que este conceito seja disponibilizado.',
	'smw_noinvannot' => 'Valores não podem ser atribuídos a propriedades inversas.',
	'version-semantic' => 'Extensões semânticas',
	'smw_baduri' => 'URIs na forma de "$1" não são permitidos.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Contar resultados',
	'smw_printername_csv' => 'Exportação em CSV',
	'smw_printername_dsv' => 'Exportação em DVS',
	'smw_printername_debug' => 'Depurar consulta (para especialistas)',
	'smw_printername_embedded' => 'Incorporar o conteúdo da página',
	'smw_printername_json' => 'Exportação em JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeração',
	'smw_printername_ul' => 'Discriminação',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Tabela ampla',
	'smw_printername_template' => 'Predefinição',
	'smw_printername_rdf' => 'Exportação em RDF',
	'smw_printername_category' => 'Categoria',
	'validator-type-class-SMWParamSource' => 'texto',
	'smw-paramdesc-limit' => 'Número máximo de resultados na exibição',
	'smw-paramdesc-offset' => 'Posição do primeiro resultado',
	'smw-paramdesc-headers' => 'Mostrar os nomes dos cabeçalhos/propriedades',
	'smw-paramdesc-mainlabel' => 'Nome dado a coluna das páginas principais',
	'smw-paramdesc-link' => 'Apresentar os valores na forma de links',
	'smw-paramdesc-intro' => 'Texto a apresentar antes dos resultados da consulta, caso existam',
	'smw-paramdesc-outro' => 'Texto a apresentar após os resultados da consulta, caso existam',
	'smw-paramdesc-default' => 'Texto a apresentar caso não haja resultados para a consulta',
	'smw-paramdesc-sep' => 'O separador para os valores',
	'smw-paramdesc-showsep' => 'Exibir separador no começo do arquivo CSV ("sep=<valor>")',
	'smw-paramdesc-distribution' => 'Ao invés de exibir todos os valores, conte suas ocorrências e mostre-as.',
	'smw-paramdesc-distributionsort' => 'Alfabete a distribuição do valor pela contagem de ocorrência.',
	'smw-paramdesc-distributionlimit' => 'Limite a distribuição do valor para a contagem de apenas alguns valores.',
	'smw-paramdesc-template' => 'Nome da predefinição com a qual são exibidos os resultados',
	'smw-paramdesc-columns' => 'Número de colunas em que os resultados serão apresentados (por padrão, $1)',
	'smw-paramdesc-userparam' => 'Valor fornecido a cada chamada da predefinição, se uma predefinição for utilizada',
	'smw-paramdesc-introtemplate' => 'Nome de uma predefinição para apresentar antes dos resultados da consulta, se existirem',
	'smw-paramdesc-outrotemplate' => 'Nome de uma predefinição para apresentar após os resultados da consulta, se existirem',
	'smw-paramdesc-embedformat' => 'Elemento HTML utilizado para definir cabeçalhos',
	'smw-paramdesc-embedonly' => 'Não exibir cabeçalhos',
	'smw-paramdesc-table-class' => 'Uma classe CSS adicional para colocar em uma tabela',
	'smw-paramdesc-rdfsyntax' => 'A sintaxe RDF a ser utilizada',
	'smw-paramdesc-csv-sep' => 'Separador a ser utilizado',
	'smw-paramdesc-dsv-separator' => 'Separado a ser utilizado',
	'smw-paramdesc-dsv-filename' => 'Nome para o arquivo DSV',
	'smw-smwdoc-description' => 'Mostra uma tabela com todos os parâmetros que podem ser utilizados para o formato de resultado específico junto aos valores padrão e as descrições.',
	'smw-smwdoc-par-format' => 'O formato de resultados para o qual será apresentada a documentação dos parâmetros.',
	'smw-smwdoc-par-parameters' => 'Quais parâmetros mostrar. "specific" para aqueles adicionados pelo formato, "base" para aqueles disponíveis em todos os formatos e "all" para ambos.',
	'smw-paramdesc-sort' => 'Propriedade para classificar a consulta',
	'smw-paramdesc-order' => 'Ordem da classificação da consulta',
	'smw-paramdesc-searchlabel' => 'Texto para continuar a busca',
	'smw-paramdesc-named_args' => 'Nomeie os argumentos passados para a predefinição',
	'smw-paramdesc-export' => 'Opção de exportação',
	'smw-paramdesc-prettyprint' => 'Uma saída de pretty-print que exibe indentações e novas linhas adicionais',
	'smw-paramdesc-source' => 'Fonte alternativa de consulta',
	'smw-paramdesc-jsonsyntax' => 'Sintaxe JSON para ser utilizada',
	'smw-printername-feed' => 'Feeds RSS e Atom',
	'smw-paramdesc-feedtype' => 'Tipo de feed',
	'smw-paramdesc-feedtitle' => 'Texto a ser utilizado como título do feed',
	'smw-paramdesc-feeddescription' => 'Texto a ser utilizado como descrição do feed',
	'smw-paramdesc-feedpagecontent' => 'Conteúdo da página a ser exibido com o feed',
	'smw-label-feed-description' => '$1 $2 feed',
	'smw_iq_disabled' => 'As consultas semânticas foram desativadas neste wiki',
	'smw_iq_moreresults' => '… mais resultados',
	'smw_parseerror' => 'O valor fornecido não foi compreendido.',
	'smw_notitle' => '"$1" não pode ser utilizado como nome de página neste wiki.',
	'smw_noproperty' => '"$1" não pode ser utilizado como um nome de propriedade neste wiki.',
	'smw_wrong_namespace' => 'Apenas páginas no domínio "$1" são permitidas aqui.',
	'smw_manytypes' => 'Mais de um tipo definido para a propriedade.',
	'smw_emptystring' => 'Cadeias de caracteres vazias não são aceitas.',
	'smw_maxstring' => 'A cadeia de caracteres $1 é longa demais.',
	'smw_notinenum' => '"$1" não está na lista de valores possíveis ($2) para esta propriedade.',
	'smw_noboolean' => '"$1" não é reconhecido como um valor Booleano (verdadeiro/falso).',
	'smw_true_words' => 'verdadeiro,v,sim,s',
	'smw_false_words' => 'falso,f,não,nao,n',
	'smw_nofloat' => '"$1" não é um número.',
	'smw_infinite' => 'Números tão grandes como "$1" não são suportados.',
	'smw_unitnotallowed' => '"$1" não está declarado como unidade de medida válida para esta propriedade.',
	'smw_nounitsdeclared' => 'Não foi declarada nenhuma unidade de medida para esta propriedade.',
	'smw_novalues' => 'Não foram especificados valores.',
	'smw_nodatetime' => 'A data “$1” não foi compreendida.',
	'smw_toomanyclosing' => 'Parece haver muitas ocorrências de "$1" na consulta.',
	'smw_noclosingbrackets' => 'Um uso de "<nowiki>[[</nowiki>" na sua consulta não foi fechada por um "]]" correspondente.',
	'smw_misplacedsymbol' => 'O símbolo "$1" foi usado num local onde não é útil.',
	'smw_unexpectedpart' => 'A parte "$1" da consulta não foi compreendida.
Os resultados podem não ser os esperados.',
	'smw_emptysubquery' => 'Alguma subconsulta não tem uma condição válida.',
	'smw_misplacedsubquery' => 'Uma subconsulta foi utilizada em um local onde não são permitidas subconsultas.',
	'smw_valuesubquery' => 'Subconsultas não suportadas para valores da propriedade "$1".',
	'smw_badqueryatom' => 'Alguma parte "<nowiki>[[…]]</nowiki>" da consulta não foi compreendida.',
	'smw_propvalueproblem' => 'O valor da propriedade "$1" não foi compreendido.',
	'smw_noqueryfeature' => 'Uma característica da consulta não foi suportada neste wiki e parte da consulta foi descartada ($1).',
	'smw_noconjunctions' => 'Conjunções em consultas não são suportadas neste wiki e parte da consulta foi descartada ($1).',
	'smw_nodisjunctions' => 'Disjunções em consultas não são suportadas neste wiki e parte da consulta foi descartada ($1).',
	'smw_querytoolarge' => 'Não foi possível considerar as seguintes condições da consulta, devido às restrições no tamanho e profundidade de consulta dos wikis: $1.',
	'smw_notemplategiven' => 'Providencie um valor para o parâmetro "predefinição" para o formato desta consulta funcionar.',
	'smw_db_sparqlqueryproblem' => 'O resultado da consulta não pôde ser obtido do banco de dados SPARQL. Este erro pode ser temporário ou indicar um defeito no software de banco de dados.',
	'smw_db_sparqlqueryincomplete' => 'A consulta revelou-se difícil e foi interrompida. Alguns resultados podem estar faltando. Se possível, tente utilizar uma consulta mais simples.',
	'smw_type_header' => 'Propriedades do tipo "$1"',
	'smw_typearticlecount' => 'Exibindo $1 {{PLURAL:$1|propriedade que utiliza|propriedades que utilizam}} este tipo.',
	'smw_attribute_header' => 'Páginas que utilizam a propriedade "$1"',
	'smw_attributearticlecount' => 'Exibindo $1 {{PLURAL:$1|página que utiliza|páginas que utilizam}} esta propriedade.',
	'smw_subproperty_header' => 'Subpropriedades',
	'smw_subpropertyarticlecount' => 'Esta propriedade possui {{PLURAL:$1|a seguinte subpropriedade|as seguintes $1 subpropriedades}}:',
	'smw_concept_header' => 'Páginas do conceito "$1"',
	'smw_conceptarticlecount' => 'Exibindo {{PLURAL:$1|uma página pertencente|$1 páginas pertencentes}} à este conceito.',
	'exportrdf' => 'Exportar páginas para RDF',
	'smw_exportrdf_docu' => 'Esta página permite que você obtenha dados de uma página no formato RDF.
Para exportar páginas, introduza os seus títulos na caixa de texto abaixo, um título por linha.',
	'smw_exportrdf_recursive' => 'Exportar recursivamente todas as páginas relacionadas.
Note que o resultado pode ser volumoso!',
	'smw_exportrdf_backlinks' => 'Também exporta todas as páginas que se referem as páginas exportadas.
Gera RDF navegável.',
	'smw_exportrdf_lastdate' => 'Não exporte páginas que não foram alteradas desde o tempo dado.',
	'smw_exportrdf_submit' => 'Exportar',
	'uriresolver' => 'Resolvedor de URIs',
	'properties' => 'Propriedades',
	'smw_properties_docu' => 'As seguintes propriedades são utilizadas neste wiki.',
	'smw_property_template' => '$1 do tipo $2 ($3 {{PLURAL:$3|uso|usos}})',
	'smw_propertylackspage' => 'Todas as propriedades devem ser descritas por uma página!',
	'smw_propertylackstype' => 'Nenhum tipo foi especificado para esta propriedade (assumindo tipo $1 por enquanto).',
	'smw_propertyhardlyused' => 'Esta propriedade é muito pouco utilizada neste wiki!',
	'unusedproperties' => 'Propriedades não utilizadas',
	'smw_unusedproperties_docu' => 'As seguintes propriedades existem apesar de nenhuma página fazer uso delas.',
	'smw_unusedproperty_template' => '$1 de tipo $2',
	'wantedproperties' => 'Propriedades pedidas',
	'smw_wantedproperties_docu' => 'As seguintes propriedades são utilizadas no wiki, mas ainda não têm uma página que as descreva.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'smw_purge' => 'Atualizar',
	'types' => 'Tipos',
	'smw_types_docu' => 'A seguinte lista contém todos os tipos de dados que podem ser atribuídos a propriedades.',
	'semanticstatistics' => 'Estatísticas de semântica',
	'smw_semstats_text' => "Este wiki contém '''$1''' {{PLURAL:$1|valor|valores}} de propriedades num total de '''$2''' [[Special:Properties|{{PLURAL:$2|propriedade diferente|propriedades diferentes}}]].
'''$3''' {{PLURAL:$3|propriedade tem|propriedades têm}} sua própria página, e o tipo de dados pretendido está especificado para '''$4''' delas.
Algumas das propriedades existentes podem estar [[Special:UnusedProperties|sem uso]].
As propriedades que não possuem uma página poderão ser encontradas na [[Special:WantedProperties|lista de propriedades em falta]].",
	'smw_uri_doc' => 'O resolvedor de URIs implementa a <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">descoberta TAG da W3C sobre o httpRange-14</a>. 
Ele certifica-se de que os seres humanos não se tornem em sites da internet.',
	'ask' => 'Busca semântica',
	'smw_ask_sortby' => 'Ordenar por coluna (opcional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Buscar resultados',
	'smw_ask_editquery' => '[Editar consulta]',
	'smw_add_sortcondition' => '[Adicionar condição de ordenação]',
	'smw_ask_hidequery' => 'Ocultar consulta',
	'smw_ask_help' => 'Ajuda sobre consultas',
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Dados adicionas para exibir',
	'smw_ask_printdesc' => '(adicionar um nome de propriedade por linha)',
	'smw_ask_format_as' => 'Formatar como:',
	'smw_ask_defaultformat' => 'padrão',
	'smw_ask_otheroptions' => 'Outras opções',
	'smw-ask-otheroptions-info' => 'Esta seção contém opções que alteram as declarações de exibição. As descrições dos parâmetros podem ser visualizadas posicionando o cursor sobre elas.',
	'smw-ask-otheroptions-collapsed-info' => 'Por favor, utilize o ícone de adição para visualizar todas as opções disponíveis',
	'smw_ask_show_embed' => 'Mostrar código embutido',
	'smw_ask_hide_embed' => 'Ocultar código embutido',
	'smw_ask_embed_instr' => 'Para embutir esta consulta em uma página wiki, utilize o código abaixo.',
	'smw-ask-delete' => '[Deletar]',
	'smw-ask-sorting' => 'Alfabetação',
	'smw-ask-format-selection-help' => 'Para uma descrição detalhada, por favor, visite a página de ajuda $1.',
	'querycreator' => 'Criador de Consultas',
	'smw_qc_addmainlabel' => 'Adicionar rótulo principal',
	'smw_qc_show_addnal_opts' => 'Mostrar mais opções',
	'smw_qc_hide_addnal_opts' => 'Mostrar menos opções',
	'smw_qc_otheropt' => 'Outras opções',
	'smw_qc_intro' => 'Intro:',
	'smw_qc_outro' => 'Outro:',
	'smw_qc_default' => 'Padrão:',
	'smw_qc_formatopt' => 'Opções de formato',
	'smw_qc_query_help' => 'Introduza uma consulta utilizando o formulário abaixo. Selecione páginas wiki com base em
Categorias (<strong><nowiki>por exemplo: [[Categoria:Ator]]</nowiki></strong>),
Propriedades (<strong><nowiki>por exemplo: [[Localizado em::Brasil]]</nowiki></strong>), 
Nomes (<strong><nowiki>por exemplo: [[Portugal]]</nowiki></strong>) e 
Domínios (<strong><nowiki>por exemplo: [[Ajuda:+]]</nowiki></strong>)',
	'smw_qui_property' => '<strong>Propriedade</strong>',
	'smw_qui_prop' => 'Propriedade:',
	'smw_qui_labl' => 'Rótulo:',
	'smw_qui_formt' => 'Formato:',
	'smw_qui_limt' => 'Limite:',
	'smw_qui_shownresults' => 'Exibir nos resultados',
	'smw_qui_noquery' => 'Nenhuma consulta foi especificada',
	'smw_qui_invalidprop' => '"$1" pode não ser uma propriedade válida',
	'smw_qui_invalidformat' => 'O formato escolhido "$1" não existe neste wiki',
	'smw_qui_nosort' => 'Sem ordenação',
	'smw_qui_ascorder' => 'Ascendente',
	'smw_qui_descorder' => 'Descendente',
	'smw_qui_randorder' => 'Aleatório',
	'smw_qui_addnprop' => 'adicionar propriedade',
	'smw_qui_delete' => 'Remover',
	'smw_qui_rescol' => 'Query-matches',
	'smw_qui_options' => 'opções',
	'smw_qui_addcategory' => 'adicionar categoria',
	'smw_qui_addrescol' => 'adicionar query-matches',
	'smw_qui_ok' => 'Ok',
	'smw_qui_cancel' => 'Cancelar',
	'smw_qui_category' => '<strong>Categoria</strong>',
	'smw_qui_label' => 'Rótulo',
	'smw_prp_options' => 'Opções de propriedade',
	'smw_qui_catopts' => 'Opções de categoria',
	'smw_qui_mainlabopts' => 'Opções de resultado',
	'smw_qui_dlabel' => 'Rótulo:',
	'smw_qui_dcategory' => 'Categoria:',
	'smw_qui_dcatyes' => 'Exibir texto quando a categoria é apresentada:',
	'smw_qui_dcatno' => 'Exibir texto quando a categoria está ausente:',
	'searchbyproperty' => 'Busca por propriedade',
	'smw_sbv_docu' => 'Busca por todas as páginas que possuem uma dada propriedade e um dado valor.',
	'smw_sbv_novalue' => 'Introduza um valor válido para a propriedade, ou veja todos os valores da propriedade "$1".',
	'smw_sbv_displayresult' => 'Segue-se uma lista de todas as páginas que possuem a propriedade "$1" com valor "$2"',
	'smw_sbv_displayresultfuzzy' => 'Uma lista de todas as páginas que têm a propriedade "$1" com valor "$2".
Uma vez que houve poucos resultados, também são apresentados valores aproximados.',
	'smw_sbv_property' => 'Propriedade:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Procurar resultados',
	'browse' => 'Navegar pelo wiki',
	'smw_browselink' => 'Navegar pelas propriedades',
	'smw_browse_article' => 'Introduza o nome da página a partir da qual deseja começar a navegar.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'exibir propriedades que apontem para cá',
	'smw_browse_hide_incoming' => 'ocultar propriedades que apontem para cá',
	'smw_browse_no_outgoing' => 'Esta página não possui propriedades.',
	'smw_browse_no_incoming' => 'Nenhuma propriedade aponta para esta página.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Nome de propriedade inversa',
	'pageproperty' => 'Busca por propriedade de página',
	'smw_pp_docu' => 'Busca por todos os valores de uma propriedade em uma dada página.
Por favor, inclua tanto a página quanto a propriedade.',
	'smw_pp_from' => 'Da página',
	'smw_pp_type' => 'Propriedade',
	'smw_pp_submit' => 'Buscar resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Próximo',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Sem resultados.',
	'smwadmin' => 'Funções administrativas do Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'O mecanismo de armazenamento foi configurado com sucesso.',
	'smw_smwadmin_return' => 'Voltar para $1',
	'smw_smwadmin_updatestarted' => 'Um novo processo de atualização para atualizar os dados semânticos foi iniciado.
Todos os dados armazenados serão reconstruídos ou reparados quando necessário.
Você pode acompanhar o progresso de atualização nesta página especial.

Retornar pata $1.',
	'smw_smwadmin_updatenotstarted' => 'Já existe um processo de atualização em execução.
Não foi criado outro.

Retornar para $1.',
	'smw_smwadmin_updatestopped' => 'Todos os processos de atualização existentes foram parados.

Retornar para $1.',
	'smw_smwadmin_updatenotstopped' => 'Para parar o processo de atualização em execução, você precisa ativar a caixa de seleção para indicar que realmente tem certeza.

Retornar para $1.',
	'smw_smwadmin_docu' => 'Esta página especial ajuda-o durante a instalação ou atualização do <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Lembre-se de efetuar cópias de segurança dos dados importantes antes de executar funções administrativas.',
	'smw_smwadmin_db' => 'Instalação e atualização da base de dados',
	'smw_smwadmin_dbdocu' => 'O Semantic MediaWiki requer algumas extensões à base de dados MediaWiki de forma a armazenar os dados semânticos.
A função abaixo assegura que a sua base de dados está devidamente preparada.
As alterações feitas neste passo não afetam o resto da base de dados MediaWiki e podem ser facilmente desfeitas se desejado.
Esta função de preparação pode ser executada várias vezes sem causar quaisquer danos, mas é necessária apenas uma vez na instalação ou atualização.',
	'smw_smwadmin_permissionswarn' => "Se a operação falhar com erros de SQL, provavelmente o usuário da base de dados utilizado pelo seu wiki (consulte o seu LocalSettings.php) não possui permissões suficientes.
Conceda a esse usuário permissões adicionais para criar e eliminar tabelas, introduza temporariamente as credenciais do seu superusuário (<i>root</i>) da base de dados em LocalSettings.php, ou use o ''script'' de manutenção <tt>SMW_setup.php</tt>, o qual pode usar as credenciais de um administrador.",
	'smw_smwadmin_dbbutton' => 'Inicializar ou atualizar tabelas',
	'smw_smwadmin_announce' => 'Anuncie seu wiki',
	'smw_smwadmin_announcedocu' => 'O Semantic MediaWiki tem um serviço na internet para anunciar novos wikis semânticos.
Este é usado para manter uma lista de sites públicos que usam o Semantic MediaWiki, principalmente para auxiliar o <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projeto Semantic MediaWiki</a> a obter uma ideia geral das utilizações típicas do software.
Veja a página inicial do Semantic MediaWiki para <a href="http://semantic-mediawiki.org/wiki/Registry">mais informações sobre este serviço</a>.',
	'smw_smwadmin_announcebutton' => 'Clique o seguinte botão para submeter a URL do seu wiki ao serviço.
O serviço não registará wikis que não estejam publicamente acessíveis e apenas armazenará informação publicamente acessível.',
	'smw_smwadmin_datarefresh' => 'Reparação de dados e atualização',
	'smw_smwadmin_datarefreshdocu' => 'É possível restaurar todos os dados do Semantic MediaWiki baseado no conteúdo atual do wiki.
Isto pode ser útil para reparar dados corrompidos ou para atualizar os dados se o formato interno tiver sido alterado devido a alguma atualização do software.
A atualização é executada página a página e não ficará completa de imediato.
Abaixo é mostrado se uma atualização está em processo e permite-lhe iniciar ou parar atualizações (a menos que esta funcionalidade tenha sido desativada por um administrador do site).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Uma atualização já se encontra em progresso.</strong>
É normal que a atualização progrida lentamente já que apenas atualiza dados em pequenos blocos de cada vez quando um utilizador acessa o wiki.
Para terminar esta atualização mais rapidamente, você pode executar o script de manutenção do MediaWiki <tt>runJobs.php</tt> (use a opção <tt>--maxjobs 1000</tt> para restringir o número de atualizações feitas em um bloco).
Progresso estimado da atualização corrente:',
	'smw_smwadmin_datarefreshbutton' => 'Iniciar a atualização dos dados',
	'smw_smwadmin_datarefreshstop' => 'Parar esta atualização',
	'smw_smwadmin_datarefreshstopconfirm' => 'Sim, eu tenho certeza.',
	'smw_smwadmin_support' => 'Obtendo suporte',
	'smw_smwadmin_supportdocu' => 'Vários recursos poderão ajudá-lo em caso de problemas:',
	'smw_smwadmin_installfile' => 'Se tiver problemas com a sua instalação, comece por rever as orientações no <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">arquivo INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'A documentação completa para o utilizador do Semantic MediaWiki está em <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Defeitos podem ser reportados no <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Se você tem mais questões ou sugestões, junte-se à discussão em <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Fórum de usuários do Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Estrutura de dados',
	'smw_adminlinks_displayingdata' => 'Exibição de dados',
	'smw_adminlinks_inlinequerieshelp' => 'Ajuda para consultas inline',
	'smw-createproperty-isproperty' => 'Esta é uma propriedade do tipo $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|O valor permitido para esta propriedade é|Os valores permitidos para esta propriedade são}}:',
	'smw-paramdesc-category-delim' => 'O delimitador',
	'smw-paramdesc-category-template' => 'Uma predefinição para formatar os itens com',
	'smw-paramdesc-category-userparam' => 'Um parâmetro para passar para a predefinição',
	'smw-info-par-message' => 'Mensagem a ser exibida.',
	'smw-info-par-icon' => 'Ícone para mostrar, "info" ou "aviso".',
	'prefs-smw' => 'Semantic MediaWiki',
	'prefs-ask-options' => 'Opções da busca semântica',
	'smw-prefs-intro-text' => 'As opções abaixo são fornecidas pelo [http://semantic-mediawiki.org/ Semantic MediaWiki] (ou extensões relativas) para permitir a personalização em funções selecionadas. Para obter mais informações, por favor, visite essa [http://semantic-mediawiki.org/wiki/Help:User_preferences seção de ajuda].',
	'smw-prefs-ask-options-tooltip-display' => 'Exibir o texto do parâmetro em forma de dica',
	'smw-prefs-ask-options-collapsed-default' => 'Habilitar a caixa de opção como recolhida por padrão',
	'smw-ui-tooltip-title-property' => 'Propriedade',
	'smw-ui-tooltip-title-quantity' => 'Quantidade',
	'smw-ui-tooltip-title-info' => 'Informação',
	'smw-ui-tooltip-title-service' => 'Links de serviço',
	'smw-ui-tooltip-title-warning' => 'Erro',
	'smw-ui-tooltip-title-parameter' => 'Parâmetro',
	'smw-ui-tooltip-title-event' => 'Evento',
	'smw_unknowntype' => 'O tipo dessa propriedade é invalido',
);

/** Tarifit (Tarifit)
 * @author Jose77
 */
$messages['rif'] = array(
	'smw_browse_go' => 'Raḥ ɣa',
);

/** Romanian (română)
 * @author AdiJapan
 * @author Firilacroco
 * @author KlaudiuMihaila
 * @author Minisarm
 */
$messages['ro'] = array(
	'smw-desc' => "Wikiul dumneavoastră devine mai accesibil — pentru mașini ''și'' oameni ([http://semantic-mediawiki.org/wiki/Help:User_manual documentație on-line])",
	'smw_viewasrdf' => 'Flux RDF',
	'smw_finallistconjunct' => 'și',
	'smw_factbox_head' => 'Informații despre „$1”',
	'smw_isspecprop' => 'Această proprietate este una specială pe acest wiki.',
	'smw_concept_description' => 'Descrierea conceptului „$1”',
	'version-semantic' => 'Extensii semantice',
	'smw_printername_count' => 'Numără rezultatele',
	'smw_printername_csv' => 'Export CSV',
	'smw_printername_dsv' => 'Export DSV',
	'smw_printername_debug' => 'Interogare de depanare (pentru experți)',
	'smw_printername_embedded' => 'Conținut de pagini încorporate',
	'smw_printername_json' => 'Export JSON',
	'smw_printername_list' => 'Listă',
	'smw_printername_ol' => 'Enumerare',
	'smw_printername_rss' => 'Export RSS',
	'smw_printername_table' => 'Tabel',
	'smw_printername_template' => 'Format',
	'smw_printername_rdf' => 'Export RDF',
	'smw_printername_category' => 'Categorie',
	'validator-type-class-SMWParamSource' => 'text',
	'smw_iq_disabled' => 'Interogările semantice au fost dezactivate pe acest wiki.',
	'smw_iq_moreresults' => '… mai multe rezultate',
	'smw_parseerror' => 'Valoarea oferită nu este înțeleasă.',
	'smw_notitle' => '„$1” nu poate fi folosit ca nume de pagină în acest wiki.',
	'smw_wrong_namespace' => 'Numai paginile din spațiul de nume "$1" sunt permise aici.',
	'smw_emptystring' => 'Șirurile vide nu sunt acceptate.',
	'smw_notinenum' => '„$1” nu este în lista de valori posibile ($2) pentru această proprietate.',
	'smw_noboolean' => '„$1” nu este recunoscut ca valoare booleană (adevărat/fals).',
	'smw_nofloat' => '„$1” nu este număr.',
	'smw_infinite' => 'Numerele mari precum „$1” nu sunt suportate.',
	'smw_nodatetime' => 'Data „$1” nu a fost înțeleasă.',
	'smw_unexpectedpart' => 'Partea „$1” a interogării nu a fost înțeleasă.
Rezultatele pot fi neașteptate.',
	'smw_propvalueproblem' => 'Valoarea proprietății „$1” nu a fost înțeleasă.',
	'smw_type_header' => 'Proprietăți de tipul „$1”',
	'smw_attribute_header' => 'Pagini care folosesc proprietatea „$1”',
	'smw_subproperty_header' => 'Subproprietăți',
	'smw_subpropertyarticlecount' => 'Această proprietate are {{PLURAL:$1|următoarea subproprietate|următoarele $1 subproprietăți}}:',
	'smw_concept_header' => 'Pagini ale conceptului „$1”',
	'exportrdf' => 'Exportă paginile în RDF',
	'smw_exportrdf_submit' => 'Export',
	'uriresolver' => 'Rezolvator URI',
	'properties' => 'Proprietăți',
	'smw_properties_docu' => 'Următoarele proprietăți sunt folosite în wiki.',
	'smw_property_template' => '$1 de tipul $2 ($3)',
	'smw_propertylackstype' => 'Nici un tip nu a fost specificat pentru această proprietate (presupunem deocamdată tipul $1).',
	'smw_propertyhardlyused' => 'Această proprietate este puțin folosită în wiki!',
	'unusedproperties' => 'Proprietăți neutilizate',
	'smw_unusedproperties_docu' => 'Următoarele proprietăți există, deși nici o altă pagină nu le folosește.',
	'smw_unusedproperty_template' => '$1 de tipul $2',
	'wantedproperties' => 'Proprietăți dorite',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|utilizare|utilizări}})',
	'smw_purge' => 'Reîncărcare',
	'types' => 'Tipuri',
	'semanticstatistics' => 'Statistici semantice',
	'ask' => 'Căutare semantică',
	'smw_ask_sortby' => 'Sortare după coloană (opțional)',
	'smw_ask_ascorder' => 'Crescător',
	'smw_ask_descorder' => 'Descrescător',
	'smw_ask_submit' => 'Găsește rezultate',
	'smw_ask_editquery' => '[Modifică interogarea]',
	'smw_add_sortcondition' => '[Adaugă o condiție de sortare]',
	'smw_ask_hidequery' => 'Ascunde interogarea',
	'smw_ask_help' => 'Ajutor despre interogare',
	'smw_ask_queryhead' => 'Interogare',
	'smw_ask_printhead' => 'Date suplimentare de afișat',
	'smw_ask_printdesc' => '(adăugați câte un nume de proprietate pe fiecare rând)',
	'smw_ask_format_as' => 'Formatare ca:',
	'smw_ask_defaultformat' => 'implicit',
	'smw_ask_otheroptions' => 'Alte opțiuni',
	'smw-ask-otheroptions-collapsed-info' => 'Utilizați pictograma „plus” pentru a vedea toate opțiunile disponibile',
	'smw_ask_show_embed' => 'Arată codul de încorporat',
	'smw_ask_hide_embed' => 'Ascunde codul de încorporat',
	'smw_ask_embed_instr' => 'Pentru a încorpora această interogare într-o pagină wiki, utilizați codul de mai jos.',
	'smw-ask-delete' => '[Șterge]',
	'smw-ask-sorting' => 'Sortare',
	'querycreator' => 'Creator de interogări',
	'smw_qc_show_addnal_opts' => 'Afișează mai multe opțiuni',
	'smw_qc_hide_addnal_opts' => 'Afișează mai puține opțiuni',
	'smw_qc_otheropt' => 'Alte opțiuni',
	'smw_qui_prop' => 'Proprietate:',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Limită:',
	'smw_qui_invalidprop' => '„$1” poate să nu fie o proprietate validă',
	'smw_qui_nosort' => 'Fără sortare',
	'smw_qui_ok' => 'Ok',
	'smw_qui_cancel' => 'Revocare',
	'smw_qui_category' => '<strong>Categorie</strong>',
	'smw_qui_dcategory' => 'Categorie:',
	'searchbyproperty' => 'Căutare după proprietate',
	'smw_sbv_docu' => 'Caută toate paginile care au anumite proprietăți și valori.',
	'smw_sbv_property' => 'Proprietate:',
	'smw_sbv_value' => 'Valoare:',
	'smw_sbv_submit' => 'Găsește rezultate',
	'browse' => 'Răsfoire wiki',
	'smw_browselink' => 'Răsfoire proprietăți',
	'smw_browse_article' => 'Introduceți numele paginii de la care să porniți navigarea.',
	'smw_browse_go' => 'Mergi',
	'smw_browse_show_incoming' => 'afișează proprietățile care trimit aici',
	'smw_browse_hide_incoming' => 'ascunde proprietățile care trimit aici',
	'smw_browse_no_outgoing' => 'Această pagină nu are proprietăți.',
	'smw_browse_no_incoming' => 'Nici o proprietate nu trimite la această pagină.',
	'smw_inverse_label_default' => '$1 din',
	'smw_pp_from' => 'De la pagina',
	'smw_pp_type' => 'Proprietate',
	'smw_pp_submit' => 'Găsește rezultate',
	'smw_result_prev' => 'Precedent',
	'smw_result_next' => 'Următor',
	'smw_result_results' => 'Rezultate',
	'smw_result_noresults' => 'Ne pare rău, niciun rezultat.',
	'smwadmin' => 'Funcții administrative pentru Semantic MediaWiki',
	'smw_smwadmin_return' => 'Înapoi la $1',
	'smw_smwadmin_datarefreshbutton' => 'Pornește actualizarea datelor',
	'smw_smwadmin_datarefreshstop' => 'Oprește această actualizare',
	'smw_smwadmin_datarefreshstopconfirm' => 'Da, sunt sigur.',
	'smw_smwadmin_support' => 'Obținere ajutor',
	'smw_adminlinks_datastructure' => 'Structura datelor',
	'smw_adminlinks_displayingdata' => 'Afișarea datelor',
	'smw-createproperty-isproperty' => 'Aceasta este o proprietate de tipul $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Valoarea admisă pentru această proprietate este|Valorile admise pentru această proprietate sunt}}:',
	'smw-ui-tooltip-title-property' => 'Proprietate',
	'smw-ui-tooltip-title-quantity' => 'Cantitate',
	'smw-ui-tooltip-title-info' => 'Informații',
	'smw-ui-tooltip-title-warning' => 'Eroare',
	'smw-ui-tooltip-title-parameter' => 'Parametru',
	'smw-ui-tooltip-title-event' => 'Eveniment',
	'smw_unknowntype' => 'Tipul acestei proprietăți este invalid',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => ', e',
	'smw_true_words' => 'vere,true,t,sine,si,yes,y',
	'smw_false_words' => 'fause,false,f,none,no,n',
	'properties' => 'Proprietà',
	'smw_property_template' => '$1 de tipe $2 ($3)',
	'smw_unusedproperty_template' => '$1 de tipe $2',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|ause|ausene}})',
	'types' => 'Tipe',
);

/** Russian (русский)
 * @author Eleferen
 * @author Ferrer
 * @author Innv
 * @author Kaganer
 * @author Lockal
 * @author QuestPC
 * @author Van de Bugger
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'smw-desc' => "Делает вашу вики более доступной — для машин ''и'' людей ([http://semantic-mediawiki.org/wiki/Help:User_manual документация в сети])",
	'smw_viewasrdf' => 'RDF источник',
	'smw_finallistconjunct' => ' и',
	'smw_factbox_head' => 'Факты: $1',
	'smw_isspecprop' => 'Это свойство является специальным для данного сайта.',
	'smw_concept_description' => 'Описание представления «$1»',
	'smw_no_concept_namespace' => 'Представления могут определяться только на страницах, принадлежащих пространству имён «Представление:» («Concept:»).',
	'smw_multiple_concepts' => 'Страница представления может содержать только одно определение представления.',
	'smw_concept_cache_miss' => 'Представление «$1» в настоящий момент не может быть использовано, так как настройка вики-сайта требует, чтобы его результат определялся в фоновом режиме. Если данное сообщение не исчезнет через некоторое время, обратитесь к администратору вики-сайта для включения данного представления.',
	'smw_noinvannot' => 'Обратным свойствам не могут быть присвоены значения.',
	'version-semantic' => 'Семантическое расширение (Semantic MediaWiki)',
	'smw_baduri' => 'Извините, но ссылки из диапазона "$1" не доступны отсюда.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Результаты подсчёта',
	'smw_printername_csv' => 'Экспорт CSV',
	'smw_printername_dsv' => 'Экспорт DSV',
	'smw_printername_debug' => 'Отладка запросов (для экспертов)',
	'smw_printername_embedded' => 'Включаемое содержимое страниц',
	'smw_printername_json' => 'Экспорт JSON',
	'smw_printername_list' => 'Список',
	'smw_printername_ol' => 'Перечисление',
	'smw_printername_ul' => 'Список',
	'smw_printername_table' => 'Таблица',
	'smw_printername_broadtable' => 'Широкая таблица',
	'smw_printername_template' => 'Шаблон',
	'smw_printername_rdf' => 'RDF-экспорт',
	'smw_printername_category' => 'Категория',
	'validator-type-class-SMWParamSource' => 'текст',
	'smw-paramdesc-limit' => 'Максимальное число возвращаемых результатов',
	'smw-paramdesc-offset' => 'Смещение первого результата',
	'smw-paramdesc-headers' => 'Показывать заголовки/названия свойств',
	'smw-paramdesc-mainlabel' => 'Обозначение, даваемое названию главной страницы',
	'smw-paramdesc-link' => 'Показывать значения как ссылки',
	'smw-paramdesc-intro' => 'Текст для отображения перед результатами запроса, если они есть',
	'smw-paramdesc-outro' => 'Текст для отображения после результатов запроса, если они есть',
	'smw-paramdesc-default' => 'Текст для отображения, если нет результатов запроса',
	'smw-paramdesc-sep' => 'Разделитель значений',
	'smw-paramdesc-template' => 'Название шаблона, с помощью которого будут выводиться данные',
	'smw-paramdesc-columns' => 'Количество столбцов для вывода результатов поиска (по умолчанию $1)',
	'smw-paramdesc-userparam' => 'Значение, передаваемое в каждый вызов шаблонов, если шаблон используется',
	'smw-paramdesc-introtemplate' => 'Название шаблона для отображения перед результатами запроса, если они есть',
	'smw-paramdesc-outrotemplate' => 'Название шаблона для отображения после результатов запроса, если они есть',
	'smw-paramdesc-embedformat' => 'HTML-тег, используемый для обозначения заголовков',
	'smw-paramdesc-embedonly' => 'Не отображать заголовки',
	'smw-paramdesc-table-class' => 'Дополнительный класс CSS для таблиц',
	'smw-paramdesc-rdfsyntax' => 'Какой синтаксис RDF использовать',
	'smw-paramdesc-csv-sep' => 'Использовать разделитель',
	'smw-paramdesc-dsv-separator' => 'Использовать разделитель',
	'smw-paramdesc-dsv-filename' => 'Имя файла DSV',
	'smw-paramdesc-searchlabel' => 'Текст для продолжения поиска',
	'smw_iq_disabled' => 'Извините, но встроенные запросы отключены для этого сайта.',
	'smw_iq_moreresults' => '… следующие результаты',
	'smw_parseerror' => 'Переданное значение не было понято.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '',
	'smw_notitle' => '“$1” не может быть использован как заголовок статьи на данном сайте.',
	'smw_noproperty' => '«$1» не может использоваться как имя свойства в вики.',
	'smw_wrong_namespace' => 'Здесь допустимы только страницы из пространства имён «$1».',
	'smw_manytypes' => 'Более одного типа определено для свойства.',
	'smw_emptystring' => 'Пустые строки недопустимы.',
	'smw_maxstring' => 'Строковое представление $1 слишком длинное.',
	'smw_notinenum' => '"$1" не входит в список допустимых значений ($2) для этого свойства.',
	'smw_noboolean' => '"$1" не является булевым значением (да/нет).',
	'smw_true_words' => 'да,t,yes,д,истина,и,true',
	'smw_false_words' => 'нет,f,no,n,н,ложь,л,false',
	'smw_nofloat' => '"$1" не является числом.',
	'smw_infinite' => 'Столь длинные числа как $1 не поддерживаются.',
	'smw_unitnotallowed' => '«$1» не объявлена ​​как допустимая единица измерения этого свойства.',
	'smw_nounitsdeclared' => 'Для данного свойства не объявлены единицы измерения.',
	'smw_novalues' => 'Не указаны значения.',
	'smw_nodatetime' => 'Дата «$1» не распознана.',
	'smw_toomanyclosing' => 'Ошибка: Слишком много вхождений “$1” в данном запросе.',
	'smw_noclosingbrackets' => 'Открывающаяся пара скобок «<nowiki>[[</nowiki>» не была закрыта парой соответствующих ей закрывающих скобок «]]» в данном запросе.',
	'smw_misplacedsymbol' => 'Ошибка: Использование символа “$1” в данном месте лишено смысла.',
	'smw_unexpectedpart' => 'Ошибка: Часть “$1” запроса не была распознана. Результаты могут отличаться от ожидаемых.',
	'smw_emptysubquery' => 'Ошибка: В одном из подзапросов не указано правильного знака условия.',
	'smw_misplacedsubquery' => 'Ошибка: Подзапрос используется в месте, где подзапросы не разрешены.',
	'smw_valuesubquery' => 'Подзапросы не поддерживаются для значений свойства «$1».',
	'smw_badqueryatom' => 'Часть запроса «<nowiki>[[…]]</nowiki>» не была разобрана.',
	'smw_propvalueproblem' => 'Ошибка: Значение свойства “$1” не разобрано.',
	'smw_noqueryfeature' => 'Часть запроса была опущена, так как некоторые из возможностей языка запросов не поддерживаются на этом вики-сайте ($1).',
	'smw_noconjunctions' => 'Часть запроса была опущена, так как операция «Логическое И» не поддерживается на этом вики-сайте ($1).',
	'smw_nodisjunctions' => 'Ошибка: Дизъюнкции (логическое ИЛИ) не поддерживаются данным сайтом, поэтому использующая их часть запроса была проигнорирована ($1).',
	'smw_querytoolarge' => 'Ошибка: Указанные условия запроса “$1” не могут быть выполнены из-за ограничения на глубину или размер запроса.',
	'smw_notemplategiven' => 'Чтобы данный запрос выполнялся, необходимо задать значение для параметра «template».',
	'smw_db_sparqlqueryproblem' => 'Не удалось получить результат запроса к базе данных SPARQL. Эта может быть временная ошибка или проблема в программном обеспечении базы данных.',
	'smw_db_sparqlqueryincomplete' => 'Поиск ответа на запрос оказался слишком сложным и был прерван. Некоторые результаты могут быть не показаны. По возможности попробуйте упростить запрос.',
	'smw_type_header' => 'Свойства типа “$1”',
	'smw_typearticlecount' => '{{PLURAL:$1|Отображается|Отображаются|Отображаются}} $1 {{PLURAL:$1|свойство|свойства|свойств}} этого типа.',
	'smw_attribute_header' => 'Страницы, использующие свойство “$1”',
	'smw_attributearticlecount' => '{{PLURAL:$1|Отображается|Отображаются|Отображаются}} $1 {{PLURAL:$1|страница, использующая|страницы, использующие|страниц, использующие}} это свойство.',
	'smw_subproperty_header' => 'Подсвойства',
	'smw_subpropertyarticlecount' => 'Это свойство имеет {{PLURAL:$1|следующее $1 подсвойство|следующие $1 подсвойства|следующие $1 подсвойств}}:',
	'smw_concept_header' => 'Страницы, использующие представление «$1»',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Показана|Показаны|Показаны}} $1 {{PLURAL:$1|страница|страницы|страниц}}, {{PLURAL:$1|принадлежащая|принадлежащие|принадлежащие}} данному представлению.',
	'exportrdf' => 'Экспорт страниц в RDF',
	'smw_exportrdf_docu' => 'Эта страница позволяет экспортировать части статьи в формате RDF. Наберите заголовки необходимых статей по одному на строку.',
	'smw_exportrdf_recursive' => 'Рекурсивный экспорт всех связанных страниц. Результат этой операции может быть очень большим!',
	'smw_exportrdf_backlinks' => 'Также экспортировать все страницы, которые ссылаются на экспортируемые страницы. Генерирует RDF с поддержкой полноценной навигации.',
	'smw_exportrdf_lastdate' => 'Не экспортировать страницы, которые не менялись с указанной даты.',
	'smw_exportrdf_submit' => 'Экспорт',
	'uriresolver' => 'Преобразователь URI',
	'properties' => 'Свойства',
	'smw_properties_docu' => 'Следующие свойства используются на данном сайте.',
	'smw_property_template' => '$1 имеет тип $2, количество использований ($3)', # Fuzzy
	'smw_propertylackspage' => 'Каждое свойство должно иметь свою страницу описания!',
	'smw_propertylackstype' => 'Данному свойству не сопоставлен тип данных (по умолчанию будет использоваться тип $1).',
	'smw_propertyhardlyused' => 'Это свойство почти не используется на сайте.',
	'unusedproperties' => 'Неиспользуемые свойства',
	'smw_unusedproperties_docu' => 'Следующие свойства определены, но не используются ни в одной из статей.',
	'smw_unusedproperty_template' => '$1 имеет тип $2',
	'wantedproperties' => 'Неописанные свойства',
	'smw_wantedproperties_docu' => 'Следующие свойства используются в статьях данного сайта, но не имеют соответствующих им страниц описаний.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|использование|использования|использований}})',
	'smw_purge' => 'Обновить',
	'types' => 'Типы',
	'smw_types_docu' => 'В нижеприведённом списке перечислены все типы данных, которые можно задавать для свойств.',
	'semanticstatistics' => 'Семантическая статистика',
	'smw_semstats_text' => "Данный сайт содержит '''$1''' {{PLURAL:$1|значение|значения|значений}} свойств, общее число которых составляет '''$2''' [[Special:Properties|{{PLURAL:$2|свойство|различных свойства|различных свойств}}]].
'''$3''' {{PLURAL:$3|свойство|свойства|свойств}} имеют страницу описания, а определённый тип данных задан для '''$4''' из них.
Некоторые из существующих свойств могут [[Special:UnusedProperties|не использоваться]].
Свойства, для которых не созданы страницы описания, перечислены в [[Special:WantedProperties|списке неописанных свойств]].",
	'smw_uri_doc' => 'Преобразователь URI осуществляет <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C поиск http тэгов с использованием Range-14</a>. Данная возможность упрощает поиск семантической информации.',
	'ask' => 'Семантический поиск',
	'smw_ask_sortby' => 'Сортировать по столбцу (необязательно)',
	'smw_ask_ascorder' => 'По возрастанию',
	'smw_ask_descorder' => 'По убыванию',
	'smw_ask_submit' => 'Найти',
	'smw_ask_editquery' => '[Редактировать запрос]',
	'smw_add_sortcondition' => '[Добавить условие сортировки]',
	'smw_ask_hidequery' => 'Скрыть запрос',
	'smw_ask_help' => 'Помощь по составлению запросов',
	'smw_ask_queryhead' => 'Запрос',
	'smw_ask_printhead' => 'Отображать дополнительные сведения',
	'smw_ask_printdesc' => '(добавляйте по одному названию свойства на строку)',
	'smw_ask_format_as' => 'Форматировать как:',
	'smw_ask_defaultformat' => 'по умолчанию',
	'smw_ask_otheroptions' => 'Другие настройки',
	'smw_ask_show_embed' => 'Показать встроенный код',
	'smw_ask_hide_embed' => 'Скрыть встроенный код',
	'smw_ask_embed_instr' => 'Для линейного встраивания этого запроса в вики-страницу, используйте приведённых ниже код.',
	'smw-ask-delete' => '[Удалить]',
	'searchbyproperty' => 'Искать по свойству',
	'smw_sbv_docu' => 'Искать все страницы, которые содержат указаннок свойство и значение.',
	'smw_sbv_novalue' => 'Укажите значение или просмотрите все значения свойства $1.',
	'smw_sbv_displayresult' => 'Список всех страниц, которые содержат свойство $1 со значением $2.',
	'smw_sbv_displayresultfuzzy' => 'Список всех страниц, содержащих свойство «$1» со значением «$2».
Так как количество точных результатов невелико, также показаны страницы, содержащие близкие значения данного свойства.',
	'smw_sbv_property' => 'Свойство:',
	'smw_sbv_value' => 'Значение:',
	'smw_sbv_submit' => 'Найти',
	'browse' => 'Просмотреть сайт',
	'smw_browselink' => 'Просмотреть свойства',
	'smw_browse_article' => 'Введите имя страницы для начала просмотра.',
	'smw_browse_go' => 'Перейти',
	'smw_browse_show_incoming' => 'показать свойства, ссылающиеся сюда',
	'smw_browse_hide_incoming' => 'скрыть свойства, ссылающиеся сюда',
	'smw_browse_no_outgoing' => 'Эта страница не содержит свойств.',
	'smw_browse_no_incoming' => 'Нет свойств, ссылающихся на эту страницу.',
	'smw_inverse_label_default' => '$1 из',
	'smw_inverse_label_property' => 'Метка обратного свойства',
	'pageproperty' => 'Страница поиска свойств',
	'smw_pp_docu' => 'Искать все значения свойства на указанной странице. Пожалуйста введите имя страницы и имя свойства.',
	'smw_pp_from' => 'Со страницы',
	'smw_pp_type' => 'Свойство',
	'smw_pp_submit' => 'Поиск результатов',
	'smw_result_prev' => 'Предыдущая',
	'smw_result_next' => 'Следующая',
	'smw_result_results' => 'Результаты',
	'smw_result_noresults' => 'Извините, но ничего не найдено.',
	'smwadmin' => 'Администрирование Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Система хранения была успешно установлена.',
	'smw_smwadmin_return' => 'Вернуться к $1',
	'smw_smwadmin_updatestarted' => 'Запущен новый процесс обновления семантических данных.
Все сохранённые данные будут перестроены и восстановлены, где это необходимо.
Вы можете следить за ходом обновления на этой служебной странице.

Возврат к $1.',
	'smw_smwadmin_updatenotstarted' => 'Уже запущен один процесс обновления.
Второй не создаётся.

Возврат к $1.',
	'smw_smwadmin_updatestopped' => 'Все существующие процессы обновления остановлены.

Возврат к $1.',
	'smw_smwadmin_updatenotstopped' => 'Чтобы остановить запущенный процесс обновления, вы должны поставить отметку, подтверждающую, что вы действительно уверены в этом решении.

Возврат к $1.',
	'smw_smwadmin_docu' => 'Эта служебная страница поможет вам в процессе установки и обновления <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Не забудьте произвести резервное копирование значимых данных перед выполнением административных действий.',
	'smw_smwadmin_db' => 'Установка и обновление базы данных',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki требует наличия некоторых расширений к базе данных MediaWiki, позволяющих хранить семантические данные.
Приведённая ниже функция гарантирует, что ваша база данных установлена корректно.
Изменения, сделанные на этом шаге, не влияют на основную часть базы данных MediaWiki и могут быть при желании легко отменены.
Хотя эта функция установки может быть выполнена несколько раз не причинив никакого, её запуск необходим только один раз во время установки или обновления.',
	'smw_smwadmin_permissionswarn' => 'Причиной сбоев при выполнении SQL-команд, может быть отсутствие необходимых прав у пользователя, от имени которого вы подключаетесь к базе данных вики (проверьте свой LocalSettings.php).
Предоставьте этому пользователю дополнительные права на создание и удаление таблиц, временно введите логин root в LocalSettings.php, или используйте обслуживающий скрипт <tt>SMW_setup.php</tt>, который может использовать настройки администратора.',
	'smw_smwadmin_dbbutton' => 'Инициализация или обновление таблиц',
	'smw_smwadmin_announce' => 'Объявление вашей вики',
	'smw_smwadmin_announcedocu' => 'У Semantic MediaWiki есть веб-сервис для объявлений новых семантических вики-сайтов.
Он используется для поддержки списка общественно доступных сайтов, использующих Semantic MediaWiki, это помогает проекту <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki project</a> получить представление о типовых использованиях Semantic MediaWiki.
<a href="http://semantic-mediawiki.org/wiki/Registry">Более подробную информацию</a> можно найти на домашней странице Semantic MediaWiki.',
	'smw_smwadmin_announcebutton' => 'Нажмите на следующую кнопку, чтобы отправить адрес вашей вики в этот сервис.
Сервис не будет регистрировать вики, не являются публично доступными, он будет хранить только публично доступную информацию.',
	'smw_smwadmin_datarefresh' => 'Восстановление и обновление данных',
	'smw_smwadmin_datarefreshdocu' => 'Можно восстановить все данные Semantic MediaWiki, основанные на текущем содержимом вики.
Это может быть полезно для восстановления сломанных данных, обновления данных в случае, если внутренний формат изменился в связи с некоторым обновлением программного обеспечения.
Обновление будет выполняться страница за страницей и займёт некоторое время.
Ниже показано как идёт процесс обновления, даётся возможность начать или прекратить обновление (если эта функция не была отключена на администратором сайте).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Обновление уже запущено.</strong>
Это нормально, что процесс обновления идёт достаточно медленно, поскольку он обновляет данные лишь небольшими порциями, когда пользователь обращается к вики.
Чтобы закончить данное обновление быстрее, вы можете вызвать скрипт обслуживания MediaWiki <tt>runJobs.php</tt> (используйте настройку <tt>- maxjobs 1000</tt>, чтобы ограничить количество обновлений в одной партии).
Ориентировочный ход выполнения текущего обновления:',
	'smw_smwadmin_datarefreshbutton' => 'Начать обновление данных',
	'smw_smwadmin_datarefreshstop' => 'Остановить это обновление',
	'smw_smwadmin_datarefreshstopconfirm' => 'Да, я уверен.',
	'smw_smwadmin_support' => 'Получить поддержку',
	'smw_smwadmin_supportdocu' => 'Различные ресурсы, которые могут помочь в случае проблем:',
	'smw_smwadmin_installfile' => 'Если вы испытываете затруднения при установке, прочтите руководство в <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">файле INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Полная документация пользователя Semantic MediaWiki на <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Ошибки могут быть сообщены в <a href="https://bugzilla.wikimedia.org/">Багзиллу</a>.',
	'smw_smwadmin_questions' => 'Если у вас есть дополнительные вопросы или предложения, присоединяйтесь к обсуждению на <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">форуме пользователей Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Структура данных',
	'smw_adminlinks_displayingdata' => 'Отображение данных',
	'smw_adminlinks_inlinequerieshelp' => 'Справка по встроенным запросам',
	'smw-createproperty-isproperty' => 'Это свойство типа $1.',
	'smw-createproperty-allowedvals' => 'Для данного свойства {{PLURAL:$1|допускается следующее значение|допускаются следующие значения}}:',
	'smw-paramdesc-category-delim' => 'Разделитель',
	'prefs-ask-options' => 'Параметры семантического поиска',
	'smw-prefs-ask-options-tooltip-display' => 'Отображать параметр «текст» в виде всплывающей подсказки',
	'smw-prefs-ask-options-collapsed-default' => 'Включить панель параметров свёрнутой по умолчанию',
	'smw-ui-tooltip-title-property' => 'Свойство',
	'smw-ui-tooltip-title-quantity' => 'Количество',
	'smw-ui-tooltip-title-info' => 'Информация',
	'smw-ui-tooltip-title-service' => 'Служебная ссылка',
	'smw-ui-tooltip-title-warning' => 'Ошибка',
	'smw-ui-tooltip-title-parameter' => 'Параметр',
	'smw-ui-tooltip-title-event' => 'Событие',
	'smw_unknowntype' => 'Для этого свойства задан некорректный тип',
);

/** Rusyn (русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'smw_browse_go' => 'Выконати',
	'smw_result_prev' => 'Попередня',
	'smw_result_next' => 'Далша',
	'smw_result_results' => 'Резултаты',
	'smw_result_noresults' => 'Жадны ресултаты',
	'smw_smwadmin_return' => 'Навернутя до  «$1».',
);

/** Sicilian (sicilianu)
 * @author Gmelfi
 */
$messages['scn'] = array(
	'smw_browselink' => 'Prupritati',
);

/** Serbo-Croatian (srpskohrvatski / српскохрватски)
 * @author OC Ripper
 */
$messages['sh'] = array(
	'smw_result_prev' => 'Prethodna',
);

/** Sinhala (සිංහල)
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'smw_finallistconjunct' => ', සහ',
	'smw_printername_list' => 'ලැයිස්තුව',
	'smw_printername_template' => 'සැකිල්ල',
	'smw_printername_category' => 'ප්‍රවර්ගය',
	'smw_true_words' => 'true,t,yes,y',
	'smw_false_words' => 'false,f,no,n',
	'smw_exportrdf_submit' => 'නිර්යාත කරන්න',
	'properties' => 'ගුණ',
	'types' => 'වර්ග',
	'smw_ask_queryhead' => 'ප්‍රශ්නය',
	'smw_ask_defaultformat' => 'සාමාන්‍ය',
	'smw_ask_otheroptions' => 'වෙනත් විකල්පයන්',
	'smw-ask-delete' => '[මකන්න]',
	'smw_qc_otheropt' => 'වෙනත් විකල්පයන්',
	'smw_qc_default' => 'සාමාන්‍ය:',
	'smw_qui_prop' => 'ගුණාංගය:',
	'smw_qui_labl' => 'ලේබලය:',
	'smw_qui_formt' => 'ආකෘතිය:',
	'smw_qui_limt' => 'සීමාව:',
	'smw_qui_randorder' => 'අහඹු',
	'smw_qui_delete' => 'ඉවත් කරන්න',
	'smw_qui_options' => 'විකල්පයන්',
	'smw_qui_ok' => 'හ‍රි',
	'smw_qui_cancel' => 'අත් හරින්න',
	'smw_qui_category' => '<strong>ප්‍රවර්ගය</strong>',
	'smw_qui_label' => 'ලේබලය',
	'smw_qui_dlabel' => 'ලේබලය:',
	'smw_qui_dcategory' => 'ප්‍රවර්ගය:',
	'smw_sbv_property' => 'ගුණාංගය:',
	'smw_sbv_value' => 'අගය:',
	'smw_sbv_submit' => 'ප්‍රතිඵල සොයන්න',
	'browse' => 'විකිය ගවේෂණය කරන්න',
	'smw_browselink' => 'ගුණ ගවේෂණය කරන්න',
	'smw_browse_go' => 'යන්න',
	'smw_pp_from' => 'පිටුව වෙතින්',
	'smw_pp_type' => 'ගුණාංගය',
	'smw_pp_submit' => 'ප්‍රතිඵල සොයන්න',
	'smw_result_prev' => 'පෙර',
	'smw_result_next' => 'මීළඟ',
	'smw_result_results' => 'ප්‍රතිඵල',
	'smw_result_noresults' => 'ප්‍රතිඵල නොමැත',
	'smw_smwadmin_datarefreshstopconfirm' => 'ඔව්, මට විශ්වාසයි.',
	'smw_smwadmin_support' => 'සහාය ලබා ගනිමින්',
	'smw_adminlinks_displayingdata' => 'දත්ත ප්‍රදර්ශනය',
);

/** Slovak (slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'smw-desc' => "Sprístupnenie vašej wiki pre stroje ''aj'' ľudí ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentácia])",
	'smw_viewasrdf' => 'RDF kanál',
	'smw_finallistconjunct' => ' a',
	'smw_factbox_head' => 'Skutočnosti o $1 &mdash; Kliknutím na <span class="smwsearchicon">+</span> vyhľadáte podobné stránky.',
	'smw_isspecprop' => 'Táto vlastnosť je špeciálna vlastnosť na tejto wiki.',
	'smw_concept_description' => 'Popis pojmu „$1”',
	'smw_no_concept_namespace' => 'Pojmy je možné definovať iba na stránkach v mennom priestore Concept:',
	'smw_multiple_concepts' => 'Každý pojem môže mať iba jednu definíciu pojmu.',
	'smw_concept_cache_miss' => 'Pojem „$1” nemožno momentálne použiť, pretože konfigurácia wiki vyžaduje, aby sa vypočítal, keď wiki nebude pripojená. Ak problém po určitej dobe nezmizne, požiadajte správcu, aby tento pojem sprístupnil.',
	'smw_noinvannot' => 'Hodnoty nemožno priradiť inverzným vlastnostiam.',
	'smw_baduri' => 'Prepáčte, URI z rozsahu "$1" na tomto mieste nie sú dostupné.',
	'smw_csv_link' => 'CSV',
	'smw_printername_count' => 'Výsledky počítania',
	'smw_printername_csv' => 'export CSV',
	'smw_printername_debug' => 'Ladiaca požiadavka (pre expertov)',
	'smw_printername_embedded' => 'Vložiť obsah stránky',
	'smw_printername_json' => 'export JSON',
	'smw_printername_list' => 'Zoznam',
	'smw_printername_ol' => 'Vymenovaný typ',
	'smw_printername_ul' => 'Rozpoložkovanie',
	'smw_printername_rss' => 'export RSS',
	'smw_printername_table' => 'Tabuľka',
	'smw_printername_broadtable' => 'Široká tabuľka',
	'smw_printername_template' => 'Šablóna',
	'smw-paramdesc-limit' => 'Maximálny počet vrátených výsledov',
	'smw-paramdesc-headers' => 'Zobrazovať hlavičky/názvy vlastností',
	'smw-paramdesc-mainlabel' => 'Označenie názvu hlavnej stránky',
	'smw-paramdesc-link' => 'Zobrazovať hodnoty ako odkazy',
	'smw-paramdesc-intro' => 'Text, ktorý sa má zobrazovať pred výsledkami požiadavky (nepovinnné)',
	'smw-paramdesc-outro' => 'Text, ktorý sa má zobrazovať po výsledkoch požiadavky (nepovinnné)',
	'smw-paramdesc-default' => 'Text, ktorý sa má zobrazovať ak požiadavka nevráti žiadne výsledky',
	'smw-paramdesc-sep' => 'Oddeľovač hodnôt',
	'smw-paramdesc-template' => 'Názov šablóny pomocou ktorej zobrazovať výtlačky',
	'smw-paramdesc-columns' => 'Počet stĺpcov v ktorých zobrazovať výsledky (predvolené $1)',
	'smw-paramdesc-embedformat' => 'Značka HTML na definíciu nadpisov',
	'smw-paramdesc-embedonly' => 'Nezobrazovať nadpisy',
	'smw-paramdesc-rsstitle' => 'Text, ktorý sa má použiť ako názov kanála',
	'smw-paramdesc-rssdescription' => 'Text, ktorý sa má použiť ako popis kanála',
	'smw-paramdesc-searchlabel' => 'Text v odkaze na výsledky', # Fuzzy
	'smw_iq_disabled' => 'Prepáčte. Inline queries have been disabled for this wiki.',
	'smw_iq_moreresults' => '&hellip; ďalšie výsledky',
	'smw_parseerror' => 'Zadaná hodnota nebola pochopená.',
	'smw_notitle' => '„$1“ nie je možné na tejto wiki použiť ako názov stránky.',
	'smw_wrong_namespace' => 'Sú tu povolené iba stránky v mennom priestore „$1”.',
	'smw_manytypes' => 'Pre atribút bol definovaný viac ako jeden typ.',
	'smw_emptystring' => 'Prázdne reťazcie nie sú akceptované.',
	'smw_maxstring' => 'Reprezentácia reťazca $1 je príliš dlhá.',
	'smw_notinenum' => '„$1“ nie je v zozname možných hodnôt ($2) tejto vlastnosti.',
	'smw_noboolean' => '"$1" nebolo rozpoznané ako platná hodnota typy boolean (áno/nie).',
	'smw_true_words' => 'áno,true',
	'smw_false_words' => 'nie,false',
	'smw_nofloat' => '"$1" nie je číslo s plávajúcou desatinnou čiarkou.',
	'smw_infinite' => 'Čísla také veľké ako „$1“ nie sú podporované.',
	'smw_nodatetime' => 'Nevedel som interpretovať dátum "$1".',
	'smw_toomanyclosing' => 'Zdá sa, že požiadavka obsahuje príliš mnoho výskytov „$1“.',
	'smw_noclosingbrackets' => 'Niektoré použitie „<nowiki>[[</nowiki>” vo vašej požiadavke nebolo ukončené zodpovedajúcim „]]”.',
	'smw_misplacedsymbol' => 'Symbol „$1“ bol použitý na mieste, kde nemá význam.',
	'smw_unexpectedpart' => 'Časť požiadavky „$1“ nebola pochopená.
Výsledky nemusia byť podľa očakávaní.',
	'smw_emptysubquery' => 'Niektorá subpožiadavka nemá platný stav.',
	'smw_misplacedsubquery' => 'Niektorá subpožiadavka bola použitá na mieste, kde nie sú povolené subpožiadavky.',
	'smw_valuesubquery' => 'Subpožiadavky nie sú podporované pre hodnoty vlastnosti „$1“.',
	'smw_badqueryatom' => 'Niektorá časť „<nowiki>[[…]]</nowiki>“ nebola pochopená.',
	'smw_propvalueproblem' => 'Hodnota vlastnosti „$1“ nebola pochopená.',
	'smw_noqueryfeature' => 'Táto wiki nepodporuje istú časť požiadavky a jej časť bola ignorovaná ($1).',
	'smw_noconjunctions' => 'Táto wiki nepodporuje konjunkcie v požiadavkách a časť požiadavky bola ignorovaná ($1).',
	'smw_nodisjunctions' => 'Disjunkcie nie sú v požiadavkách na tejto wiki podporované a časť požiadavky bola ignorovaná ($1).',
	'smw_querytoolarge' => 'Nasledovné podmienky požiadavky nebudú zohľadnené z dôvodu obmedzení tejto wiki na dĺžku alebo hĺbku požiadavky: $1.',
	'smw_notemplategiven' => 'Aby tento formát požiadavky fungoval, poskytnite prosím hodnotu parametra „template”.',
	'smw_type_header' => 'Vlastnosti typu „$1“',
	'smw_typearticlecount' => '{{PLURAL:$1|Zobrazuje sa $1 vlastnosť|Zobrazujú sa $1 vlastnosti|Zobrazuje sa $1 vlastností}} tohto typu.',
	'smw_attribute_header' => 'Stránky používajúce vlastnosť „$1“',
	'smw_attributearticlecount' => 'Zobrazuje sa $1 {{PLURAL:$1|stránka|stránky|stránok}}, ktoré používajú túto vlastnosť.',
	'smw_subproperty_header' => 'Podvlastnosti',
	'smw_subpropertyarticlecount' => 'Táto vlastnosť má {{PLURAL:|nasledovnú podvlastnosť|nasledovné $1 podvlastnosti|nasledovných $1 podvlastností}}:',
	'smw_concept_header' => 'Návrh „$1”',
	'smw_conceptarticlecount' => 'Zobrazuje sa $1 {{PLURAL:$1|stránka patriaca|stránky patriace|stránok patriacich}} tomuto návrhu.',
	'exportrdf' => 'Exportovať stránky do RDF',
	'smw_exportrdf_docu' => 'Táto stránka vám umožňuje exportovať časti stránok do formátu RDF. Po zadaní názvov stránok do spodného textového poľa, jeden názov na riadok, môžete exportovať stránky.',
	'smw_exportrdf_recursive' => 'Rekurzívne exportovať všetky súvisiace stránky. Pozor, výsledok môže byť veľmi veľký!',
	'smw_exportrdf_backlinks' => 'Tieť exportovať všetky stránky, ktoré odkazujú na exportované stránky. Vytvorí prehliadateľné RDF.',
	'smw_exportrdf_lastdate' => 'Neexportovať stránky, ktoré neboli zmenené od zadaného času.',
	'smw_exportrdf_submit' => 'Export',
	'uriresolver' => 'Prekladač URI',
	'properties' => 'Vlastnosti',
	'smw_properties_docu' => 'Na tejto wiki sa používajú nasledovné vlastnosti.',
	'smw_property_template' => '$1 typu $2 ($3)',
	'smw_propertylackspage' => 'Všetky vlastnosti by mali mať popisnú stránku!',
	'smw_propertylackstype' => 'Pre túto vlastnosť nebol uvedený žiadny typ (nateraz sa predpokladá typ $1).',
	'smw_propertyhardlyused' => 'Táto vlastnosť sa na wiki takmer nepoužíva!',
	'unusedproperties' => 'Nepoužité vlastnosti',
	'smw_unusedproperties_docu' => 'Nasledovné vlastnosti existujú napriek tomu, že ich nevyužíva žiadna iná stránka.',
	'smw_unusedproperty_template' => '$1 typu $2',
	'wantedproperties' => 'Žiadané vlastnosti',
	'smw_wantedproperties_docu' => 'Nasledovné vlastnosti, ktoré existujú na tejto wiki, zatiaľ nemajú popisnú stránku.',
	'smw_wantedproperty_template' => '$1 (použité {{PLURAL:$2|raz|$2-krát}})',
	'smw_purge' => 'Obnoviť',
	'types' => 'Typy',
	'smw_types_docu' => 'Nasleduje zoznam všetkých údajových typov, ktoré je možné priradiť atribútom. Každý údajový typ má stránku, kde je možné poskytnúť dodatočné informácie.', # Fuzzy
	'semanticstatistics' => 'Sémantická štatistika',
	'smw_semstats_text' => "Táto wiki obsahuje '''$1''' {{PLURAL:$1|hodnotu|hodnoty|hodnôt}} vlastností celkom {{PLURAL:$2|'''jednej''' vlastnosti|'''$2''' rozličných vlastností|'''$2''' rozličných vlastností}}. {{PLURAL:$3|'''Jedna''' vlastnosť má|'''$3''' vlastnosti majú|'''$3''' vlastností má}} vlastnú stránku a zamýšľaný údajový typ {{PLURAL:$4|má uvedený '''$4''' z nich|majú uvedené '''$4''' z nich|má uvedených '''$4''' z nich}}.
Niektoré z existujúcich vlastností môžu byť [[Special:UnusedProperties|nepoužité]].
Vlastnosti, ktorým stále chýba stránka sa nachádzajú na [[Special:WantedProperties|zozname žiadaných vlastností]].",
	'smw_uri_doc' => 'URI resolver sa stará o implementáciu <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG hľadanie na httpRange-14</a>. Stará sa o to, aby sa ľudia nestali webstránkami.',
	'ask' => 'Sémantické vyhľadávanie',
	'smw_ask_sortby' => 'Zoradiť podľa stĺpca',
	'smw_ask_ascorder' => 'Vzostupne',
	'smw_ask_descorder' => 'Zostupne',
	'smw_ask_submit' => 'Nájdi výsledky',
	'smw_ask_editquery' => '[Upraviť požiadavku]',
	'smw_add_sortcondition' => '[Pridať podmienku na zoradenie]',
	'smw_ask_hidequery' => 'Skryť požiadavku',
	'smw_ask_help' => 'Pomocník pre požiadavky',
	'smw_ask_queryhead' => 'Požiadavka',
	'smw_ask_printhead' => 'Ďalšie zobrazované údaje',
	'smw_ask_printdesc' => '(pridajte jednu vlastnosť na riadok)',
	'smw_ask_format_as' => 'Formátovať ako:',
	'smw_ask_defaultformat' => 'štandardne',
	'smw_ask_otheroptions' => 'Ďalšie možnosti',
	'smw_ask_show_embed' => 'Zobraziť kód embed',
	'smw_ask_hide_embed' => 'Skryť kód embed',
	'smw_ask_embed_instr' => 'Ak chcete vložiť túto požiadavku do wiki stránky, použite dolu uvedený kód.',
	'searchbyproperty' => 'Hľadať podľa hodnoty atribútu',
	'smw_sbv_docu' => 'Hľadať na wiki článok, ktorý má atribút s istou hodnotou.',
	'smw_sbv_novalue' => 'Nebola poskytnutá hodnota. Prosím, poskytnite ju vo formulári alebo zobrazte všetky atribúty typu $1',
	'smw_sbv_displayresult' => 'Zoznam všetkých článkov, ktoré majú atribút $1 $2.',
	'smw_sbv_displayresultfuzzy' => 'Zoznam všetkých stránok, ktoré majú vlastnosť „$1” s hodnotou „$2”.
Keďže výsledkov bolo len niekoľko, zobrazujú sa aj blízke hodnoty.',
	'smw_sbv_property' => 'Atribút:',
	'smw_sbv_value' => 'Hodnota:',
	'smw_sbv_submit' => 'Hľadať výsledky',
	'browse' => 'Prehliadať wiki',
	'smw_browselink' => 'Prehliadať vlastnosti',
	'smw_browse_article' => 'Zadajte názov stránky, od ktorej chcete začať prehliadať.',
	'smw_browse_go' => 'Vykonať',
	'smw_browse_show_incoming' => 'zobraziť vlastnosti, ktoré sem odkazujú',
	'smw_browse_hide_incoming' => 'skryť vlastnosti, ktoré sem odkazujú',
	'smw_browse_no_outgoing' => 'Táto stránka neobsahuje vlastnosti.',
	'smw_browse_no_incoming' => 'Žiadne vlastnosti neodkazujú na túto stránku.',
	'smw_inverse_label_default' => '$1 z',
	'smw_inverse_label_property' => 'Označenie inverznej vlastnosti',
	'pageproperty' => 'Hľadanie vlastností stránky',
	'smw_pp_docu' => 'Hľadanie všetkých výplní vlastnosti na zadanej stránke.
Prosím, zadajte stránku aj vlastnosť.',
	'smw_pp_from' => 'Od stránky',
	'smw_pp_type' => 'Vlastnosť',
	'smw_pp_submit' => 'Výsledky hľadania',
	'smw_result_prev' => 'Späť',
	'smw_result_next' => 'Ďalej',
	'smw_result_results' => 'Výsledky',
	'smw_result_noresults' => 'Prepáčte, žiadne výsledky.',
	'smwadmin' => 'Správcovské funkcie Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Úložisko bolo úspešne nastavené.',
	'smw_smwadmin_return' => 'Späť na $1',
	'smw_smwadmin_updatestarted' => 'Začal sa nový proces aktualizácie sémantických údajov.
Všetky uložené údaje budú znova zostavené alebo opravené tam, kde je to potrebné.
Na tejto špeciálnej stránke môžete sledovať priebeh aktualizácie.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Už beží proces aktualizácie.
Nespustí sa ďalší.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Všetky bežiace procesy aktualizácie boli zastavené.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Bežiaci proces aktualizácie môžete zastaviť označením zaškrtávacieho poľa, čím potvrdíte, že ste si naozaj istý.', # Fuzzy
	'smw_smwadmin_docu' => 'Táto špeciálna stránka vám pomôže počas inštalácie a aktualizácie <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Pamätajte na zálohovanie dôležitých údajov pred vykonávaním správcovských funkcií.',
	'smw_smwadmin_db' => 'Inštalácia a aktualizácia databázy',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki vyžaduje niektoré rozšírenia databázy MediaWiki, aby molo ukladať sémantické údaje.
Funkcia nižšie zabezpečuje správne nastavenie databázy.
Zmeny vykonané v tomto kroku neovplyvňujú zvyšok databázy MediaWiki a ak je to potrebné, je ich možno jednoducho vrátiť.
Túto funkcia nastavenia možno vykonať viacnásobne bez akejkoľvek ujmy, ale je potrebná iba raz počas inštalácie či aktualizácie.',
	'smw_smwadmin_permissionswarn' => 'Ak táto operácia zlyhá na chybách SQL, používateľ databázy, ktorého využíva vaša wiki (pozrite sa do LocalSettings.php) pravdepodobne nemá dostatočné privilégiá.
Buď udeľte tomuto používateľovi ďalšie privilégiá na vytváranie a mazanie tabuliek, dočasne zadajte prihlasovacie údaje používateľa root databázy do LocalSettings.php alebo použite skript na údržbu t>SMW_setup.php</tt>, ktorý dokáže využiť oprávnenia z AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Inicializovať alebo aktualizovať tabuľky',
	'smw_smwadmin_announce' => 'Oznámiť vašu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki má webovú službu na oznamovanie nových sémantických wiki lokalít.
Tým pomáha  udržiavať zoznam verejných lokalít používajúcich Semantic MediaWiki. najmä aby pomohla <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektu Semantic MediaWiki</a> získať prehľad typických využití Semantic MediaWiki.
ďalšie informácie o tejto službe nájdete na <a href="http://semantic-mediawiki.org/wiki/Registry">domovskej stránke Semantic MediaWiki</a>.',
	'smw_smwadmin_announcebutton' => 'Stlačením nasledovného tlačidla odošlete URL vašej wiki tejto službe.
Služba nebude registrovať wiki, ktoré nie sú verejne prístupné a bude ukladať iba verejne dostupné informácie.',
	'smw_smwadmin_datarefresh' => 'Oprava a aktualizácia dát',
	'smw_smwadmin_datarefreshdocu' => 'Je možné obnoviť všetky údaje Semantic MediaWiki na základe aktuálneho obsahu wiki.
To sa hodí na opravu poškodených údajov alebo obnovu údajov ak sa pri aktualizácii softvéru zmenil vnútorný formát ukladania údajov.
Aktualizáciu je možné spustiť na špeciálnej stránke a nebude dokočená okamžite.
Tu sa zobrazuje priebeh aktualizácie a môžete tu spustiť alebo zastaviť aktualizácie (ak túto funkciu správca nevypol).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Aktualizácia už prebieha.</strong>
Je normálne, že aktualizácie prebieha pomaly, pretože obnovuje údaje iba po malých kúskoch naraz, keď používateľ zobrazí stránku wiki.
Rýchlejšie dokončenie tejto aktualizácie môžete dosiahnuť vyvolaním údržbového skriptu MediaWiki <tt>runJobs.php</tt> (použite voľbu <tt>--maxjobs 1000</tt> na obmedzenie počtu aktualizácií v jednej dávke).
Odhadovaný priebeh aktualizácie:',
	'smw_smwadmin_datarefreshbutton' => 'Spustiť aktualizáciu údajov',
	'smw_smwadmin_datarefreshstop' => 'Zastaviť túto aktualizáciu',
	'smw_smwadmin_datarefreshstopconfirm' => 'Áno, som si istý.',
	'smw_smwadmin_support' => 'Ako získať podporu',
	'smw_smwadmin_supportdocu' => 'V prípade problémov vám môžu pomôcť rozličné zdroje:',
	'smw_smwadmin_installfile' => 'Ak budete mať s inštaláciou problém, začnite kontrolou smerníc <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">v súbore INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Úplná používateľská dokumentácia Semantic MediaWiki sa nachádza na <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Chyby môžete oznamovať v systéme <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Ak máte ďalšie otázky alebo návrhy, zapojte sa do diskusie <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">na používateľskom fóre Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Štruktúra údajov',
	'smw_adminlinks_displayingdata' => 'Zobrazenie údajov',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoc k inline požiadavkám',
	'smw-createproperty-isproperty' => 'Toto je vlastnosť typu $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Povolená hodnota|Povolené hodnoty}} tejto vlastnosti {{PLURAL:$1|je|sú}}:',
	'smw_unknowntype' => 'Pre atribút je definovaný nepodporovaný typ "$1".', # Fuzzy
);

/** Slovenian (slovenščina)
 * @author Dbc334
 * @author Lesko987
 */
$messages['sl'] = array(
	'smw-desc' => "Naredi vaš wiki dostopnejši – za stroje ''in'' ljudi ([http://semantic-mediawiki.org/wiki/Help:User_manual spletna dokumentacija])",
	'smw_viewasrdf' => 'Vir RDF',
	'smw_finallistconjunct' => 'in',
	'smw_factbox_head' => 'Dejstva o $1',
	'smw_isspecprop' => 'Ta lastnost je posebna lastnost za ta wiki.',
	'smw_concept_description' => 'Opis zasnove »$1«',
	'version-semantic' => 'Semantična razširitev',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Število',
	'smw_printername_csv' => 'Izvozi v CSV',
	'smw_printername_dsv' => 'Izvozi v DSV',
	'smw_printername_debug' => 'Debug poizvedba (za strokovnjake)',
	'smw_printername_embedded' => 'Vstavljena vsebina strani',
	'smw_printername_json' => 'Izvoz v JSON',
	'smw_printername_list' => 'Seznam',
	'smw_printername_ol' => 'Naštevanje',
	'smw_printername_ul' => 'Podroben seznam',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Široka tabela',
	'smw_printername_template' => 'Predloga',
	'smw_printername_rdf' => 'Izvozi v RDF',
	'smw_printername_category' => 'Kategorija',
	'smw-paramdesc-limit' => 'Največje število rezultatov',
	'smw-paramdesc-offset' => 'Index prvega rezultata',
	'smw-paramdesc-headers' => 'Prikaži glavo tabele',
	'smw-paramdesc-mainlabel' => 'Naslov glavne strani',
	'smw-paramdesc-link' => 'Priaži vrednosti kot povezave',
	'smw-paramdesc-intro' => 'Besedilo za prikaz pred rezultati poizvedbe, če obstajajo',
	'smw-paramdesc-outro' => 'Besedilo za prikaz po rezultatih poizvedbe, če obstajajo',
	'smw-paramdesc-default' => 'Besedilo za prikaz če ni rezultatov poizvedbe',
	'smw-paramdesc-sep' => 'Ločilo vrednosti',
	'smw-paramdesc-embedonly' => 'Ne prikaži naslovov',
	'smw-paramdesc-csv-sep' => 'Uporabljeno ločilo',
	'smw-paramdesc-dsv-separator' => 'Uporabljeno ločilo',
	'smw-paramdesc-dsv-filename' => 'Ime datoteke DSV',
	'smw_iq_moreresults' => '… nadaljnji rezultati',
	'smw_emptystring' => 'Prazni nizi niso sprejemljivi.',
	'smw_true_words' => 'true,t,yes,y,resnično,r,da,d',
	'smw_false_words' => 'false,f,no,n,neresnično,nr,ne',
	'smw_nofloat' => '»$1« ni število.',
	'smw_novalues' => 'Določenih ni nobenih vrednosti.',
	'smw_unexpectedpart' => 'Del poizvedbe "$1" ni bil razumljen.
Rezultati morda niso v pravilni.',
	'smw_type_header' => 'Lastnosti tipa "$1"',
	'smw_typearticlecount' => 'Prikazujem $1 {{PLURAL:$1|lastnost|lastnosti}} ki uporablja ta tip.',
	'smw_attribute_header' => 'Strani, ki uporabljajo ljastnost "$1"',
	'smw_attributearticlecount' => 'Prikazujem $1 {{PLURAL:$1|stran|strani}} ki uporabljajo to lastnost.',
	'smw_subproperty_header' => 'Podlastnosti',
	'smw_subpropertyarticlecount' => 'Ta lastnost ima {{PLURAL:$1|naslednjo $1 podlastnost|naslednji $1 podlastnosti|naslednje $1 podlastnosti|naslednjih $1 podlastnosti}}:',
	'smw_concept_header' => 'Strani zasnove »$1«',
	'exportrdf' => 'Izvoz strani v RDF',
	'smw_exportrdf_docu' => 'Ta stran vam omogoča, da dobite podatke iz strani v formatu RDF.
Za izvoz strani vpišite njihove naslove v spodnjem oknu, po en naslov na vrstico.',
	'smw_exportrdf_recursive' => 'Rekurzivno izvozite vse povezane strani.
Upoštevajte, da lahko velik rezultat!',
	'smw_exportrdf_backlinks' => 'Izvozi tudi vse strani ki se sklicujejo na strani izvoza.
Ustvari RDF za brskanje.',
	'smw_exportrdf_submit' => 'Izvozi',
	'properties' => 'Lastnosti',
	'smw_properties_docu' => 'Naslednje lastnosti se uporabljajo na tem wikiju.',
	'smw_property_template' => '$1 vrste $2 ($3 {{PLURAL:$3|uporaba|uporabi|uporabe|uporab}})',
	'smw_propertyhardlyused' => 'Ta lastnost je komaj uporabljena v wikiju!',
	'unusedproperties' => 'Neuporabljene lastnosti',
	'smw_unusedproperties_docu' => 'Naslednje lastnosti obstajajo, čeprav jih ne uporablja nobena druga stran.',
	'smw_unusedproperty_template' => '$1 tipa $2',
	'wantedproperties' => 'Želene lastnosti',
	'smw_wantedproperties_docu' => 'Naslednje lastnosti se uporabljajo v wikiju, vendar še nimajo strani, ki jih opisujejo.',
	'smw_wantedproperty_template' => '$1 ( $2 {{PLURAL:$2|uporaba|uporabi|uporabe|uporab}})',
	'smw_purge' => 'Osveži',
	'types' => 'Tipi',
	'smw_types_docu' => 'V nadaljevanju je seznam vseh podatkovnih tipov, ki so lahko določeni za lastnosti.',
	'semanticstatistics' => 'Semantična statistika',
	'smw_semstats_text' => "Ta wiki vsebuje '''$1''' {{PLURAL:$1| vrednost | vrednosti}} lastnosti za skupno '''$2''' [[Special:Properties|{{PLURAL:$2|lastnost|različnih lastnosti}}]].
'''$3''' {{PLURAL:$3|lastnost ima|lastnosti imata|lastnosti imajo|lastnosti ima}} lastno stran, in podatkovni tip je določen za '''$4''' od teh.
Nekatere od obstoječih lastnosti so lahko [[Special:UnusedProperties|neuporabljene lastnosti]].
Lastnosti, ki še vedno nimajo strani se nahajajo na [[Special:WantedProperties|seznamu želenih lastnosti]].",
	'ask' => 'Semantično iskanje',
	'smw_ask_sortby' => 'Razvrsti po stolpcu (neobvezno)',
	'smw_ask_ascorder' => 'Naraščajoče',
	'smw_ask_descorder' => 'Padajoče',
	'smw_ask_submit' => 'Poišči',
	'smw_ask_editquery' => '[Uredi poizvedbo]',
	'smw_add_sortcondition' => '[Dodaj pravilo razvrščanja]',
	'smw_ask_hidequery' => 'Skrij poizvedbo',
	'smw_ask_help' => 'Pomoč za poizvedbo',
	'smw_ask_queryhead' => 'Poizvedba',
	'smw_ask_printhead' => 'Dodatni podatki za prikaz',
	'smw_ask_printdesc' => '(dodaj po eno lastnost v vrstico)',
	'smw_ask_format_as' => 'Oblikuj kot:',
	'smw_ask_defaultformat' => 'privzeto',
	'smw_ask_otheroptions' => 'Ostale nastavitve',
	'smw_ask_show_embed' => 'Prikaži besedilo za vstavljanje',
	'smw_ask_hide_embed' => 'Skrij besedilo za vstavljanje',
	'smw_ask_embed_instr' => 'Za vstavljanje te poizvedbe na wiki stran uporabite sledeče besedilo.',
	'querycreator' => 'Ustvarjalec poizvedbe',
	'smw_qc_show_addnal_opts' => 'Prikaži več možnosti',
	'smw_qc_hide_addnal_opts' => 'Prikaži manj možnosti',
	'smw_qc_otheropt' => 'Druge možnosti',
	'smw_qc_default' => 'Privzeto:',
	'smw_qc_formatopt' => 'Možnosti oblike',
	'smw_qc_query_help' => 'Vnesite poizvedbo v spodnje okno. Izberite wikistrani, ki ustrezajo
kategorijam (<strong><nowiki>npr. [[Category:Igralec]]</nowiki></strong>),
lastnostim (<strong><nowiki>npr. [[Se nahaja v::Nemčija]]</nowiki></strong>),
imenom (<strong><nowiki>npr. [[Nemčija]]</nowiki></strong>) in
imenskim prostorom (<strong><nowiki>npr. [[Help:+]]</nowiki></strong>)',
	'smw_qui_property' => '<strong>Lastnost</strong>',
	'smw_qui_prop' => 'Lastnost:',
	'smw_qui_labl' => 'Oznaka:',
	'smw_qui_formt' => 'Oblika:',
	'smw_qui_limt' => 'Omejitev:',
	'smw_qui_shownresults' => 'prikaži v rezultatih',
	'smw_qui_noquery' => 'Navedenga ni bila nobena poizvedba',
	'smw_qui_invalidprop' => '»$1« ne sme biti veljavna lastnost',
	'smw_qui_invalidformat' => 'Izbrana oblika »$1« za ta wiki ne obstaja',
	'smw_qui_nosort' => 'Brez razvrščanja',
	'smw_qui_ascorder' => 'Naraščajoče',
	'smw_qui_descorder' => 'Padajoče',
	'smw_qui_randorder' => 'Naključno',
	'smw_qui_addnprop' => 'dodaj lastnost',
	'smw_qui_delete' => 'Odstrani',
	'smw_qui_options' => 'možnosti',
	'smw_qui_addcategory' => 'dodaj kategorijo',
	'smw_qui_ok' => 'V redu',
	'smw_qui_cancel' => 'Prekliči',
	'smw_qui_category' => '<strong>Kategorija</strong>',
	'smw_qui_label' => 'Oznaka',
	'smw_qui_catopts' => 'Možnosti kategorije',
	'smw_qui_dlabel' => 'Oznaka:',
	'smw_qui_dcategory' => 'Kategorija:',
	'searchbyproperty' => 'Iskanje po lastnosti',
	'smw_sbv_docu' => 'Išči vse strani, ki imajo določeno lastnost in vrednost.',
	'smw_sbv_novalue' => 'Vnesite pravilno vrednost za lastnost ali pa si oglejte vse vrednosti lastnosti "$1".',
	'smw_sbv_displayresult' => 'Seznam vseh strani, ki imajo lastnost "$1" z vrednostjo "$2"',
	'smw_sbv_displayresultfuzzy' => 'Seznam vseh strani, ki imajo lastnost "$1" z vrednostjo "$2".
Ker je bilo le malo rezultatov, so prikazane strani s približnim ujemanjem.',
	'smw_sbv_property' => 'Lastnost:',
	'smw_sbv_value' => 'Vrednost:',
	'smw_sbv_submit' => 'Poišči',
	'browse' => 'Raziskuj wiki',
	'smw_browselink' => 'Raziskuj lastnosti',
	'smw_browse_article' => 'Vpišite ime strani, za začntek raziskovanja.',
	'smw_browse_go' => 'Pojdi',
	'smw_browse_show_incoming' => 'prikaži lastnosti, ki se povezujejo sem',
	'smw_browse_hide_incoming' => 'skrij lastnosti, ki se povezujejo sem',
	'smw_browse_no_outgoing' => 'Ta stran nima lastnosti.',
	'smw_browse_no_incoming' => 'Nobenie lastnosti niso povezave na to stran.',
	'smw_inverse_label_default' => '$1 od',
	'smw_pp_from' => 'S strani',
	'smw_pp_type' => 'Lastnost',
	'smw_pp_submit' => 'Poišči',
	'smw_result_prev' => 'Nazaj',
	'smw_result_next' => 'Naprej',
	'smw_result_results' => 'Rezultati',
	'smw_result_noresults' => 'Ni zadetkov.',
	'smw_smwadmin_return' => 'Vrnitev na $1',
	'smw_smwadmin_datarefresh' => 'Nadgraditev in popravilo podatkov',
	'smw_smwadmin_datarefreshbutton' => 'Začni posodabljati podatke',
	'smw_smwadmin_datarefreshstop' => 'Ustavi to posodobitev',
	'smw_smwadmin_datarefreshstopconfirm' => 'Da, prepričan sem.',
	'smw_smwadmin_mediazilla' => 'Hrošče lahko prijavite na <a href="https://bugzilla.wikimedia.org/">Bugzilli</a>.',
	'smw_adminlinks_datastructure' => 'Zgradba podatkov',
	'smw_adminlinks_displayingdata' => 'Prikaz podatkov',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 * @author Sasa Stefanovic
 * @author Slaven Kosanovic
 * @author Жељко Тодоровић
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'smw_viewasrdf' => 'RDF довод',
	'smw_finallistconjunct' => ', и',
	'smw_factbox_head' => 'Чињенице о $1',
	'smw_isspecprop' => 'Ова особина је посебна особина на овом викију.',
	'smw_concept_description' => 'Опис концепта "$1"',
	'smw_no_concept_namespace' => 'Концепте је једино могуће дефинисати на страницама у именском простору Concept:',
	'smw_multiple_concepts' => 'Свака појединачна страница концепта, може садржати дефиницију само једног концепта.',
	'smw_concept_cache_miss' => 'Концепт "$1" се тренутно не може користити, пошто конфигурација викија захтева да буде компутован офлајн.
Ако проблем не нестане за неко време, затражите од администратора сајта да учини овај концепт доступним.',
	'smw_noinvannot' => 'На обртна својства не могу да се доделе вредности.',
	'smw_baduri' => 'Једнообразни идентификатори ресурса (URI) за облик „$1“ нису дозвољени.',
	'smw_rss_link' => 'RSS',
	'smw_csv_link' => 'CSV',
	'smw_json_link' => 'JSON',
	'smw_rdf_link' => 'RDF',
	'smw_printername_count' => 'Изброј резултате',
	'smw_printername_csv' => 'CSV извоз',
	'smw_printername_debug' => 'Упит за пречишћавање (само за експерте)',
	'smw_printername_embedded' => 'Угнезди садржај странице',
	'smw_printername_json' => 'JSON извоз',
	'smw_printername_list' => 'Списак',
	'smw_printername_ol' => 'Енумерација',
	'smw_printername_rss' => 'RSS извоз',
	'smw_printername_table' => 'Табела',
	'smw_printername_broadtable' => 'Широка табела',
	'smw_printername_template' => 'Шаблон',
	'smw-paramdesc-limit' => 'Максимални број резултата који ће бити враћени',
	'smw-paramdesc-mainlabel' => 'Етикета која ће се користити за име главне странице',
	'smw-paramdesc-link' => 'Прикажи вредности у облику веза',
	'smw-paramdesc-intro' => 'Текст који треба да се прикаже прије резултата упита (у случају потребе)',
	'smw-paramdesc-outro' => 'Текст који треба да се прикаже иза резултата упита (у случају потребе)',
	'smw-paramdesc-default' => 'Текст који треба да се прикаже у случају да упит није дао резултате',
	'smw-paramdesc-sep' => 'Раздвајач за вредности',
	'smw-paramdesc-columns' => 'Број колона у којима ће се приказати резултати (предодређено $1)',
	'smw-paramdesc-embedonly' => 'Не приказуј заглавља',
	'smw-paramdesc-rsstitle' => 'Текст који ће се користити као наслов у добављачу',
	'smw-paramdesc-rssdescription' => 'Текст који ће се користити као опис у добављачу',
	'smw-paramdesc-searchlabel' => 'Текст везе с резултатима', # Fuzzy
	'smw_iq_disabled' => 'Семантички упити су онемогућени на овом викију.',
	'smw_iq_moreresults' => '... више резултата',
	'smw_parseerror' => 'Дата вредност није схваћена.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" се не може користити за име странице на овом викију.',
	'smw_wrong_namespace' => 'Само странице из именског простора "$1" су дозвољене овде.',
	'smw_manytypes' => 'Више од једног типа је дефинисано за ову особину.',
	'smw_emptystring' => 'Празни стрингови нису прихватљиви.',
	'smw_maxstring' => 'Текстуална представа $1 је предугачка.',
	'smw_notinenum' => '"$1" није на списку могућих вредности ($2) за ову особину.',
	'smw_noboolean' => '"$1" није препознат као Болова вредност (истинито/неистинито).',
	'smw_true_words' => 'истинито, и, да, д',
	'smw_false_words' => 'неистинито, н, не, н',
	'smw_nofloat' => '"$1" није број.',
	'smw_infinite' => 'Бројеви дужине као "$1" нису подржани.',
	'smw_novalues' => 'Нема назначене вредности.',
	'smw_nodatetime' => 'Формат датума "$1" није разумљив.',
	'smw_toomanyclosing' => 'Изгледа да је превише случајева типа "$1" у упиту.',
	'smw_noclosingbrackets' => 'Неке угласте заграде "<nowiki>[[</nowiki>" у вашем упиту, нису затворене одговарајућим "]]".',
	'smw_misplacedsymbol' => 'Симбол "$1" је искоришћен на месту где није од користи.',
	'smw_unexpectedpart' => 'Део упита "$1" није схваћен.
Резултати могу бити неочекивани.',
	'smw_emptysubquery' => 'Неки подупити не садрже ваљане услове.',
	'smw_misplacedsubquery' => 'Неки подупити су коришћени на месту где подупити нису дозвољени.',
	'smw_valuesubquery' => 'За вредности особине "$1", подупити нису подржани.',
	'smw_badqueryatom' => 'Један део "<nowiki>[[…]]</nowiki>" упита није схваћен.',
	'smw_propvalueproblem' => 'Вредност за особину "$1" није схваћена.',
	'smw_noqueryfeature' => 'Неки делови овог упита нису подржани на овом викију, те је део упита изостављен ($1).',
	'smw_noconjunctions' => 'Конјукције у упитима нису подржане на овом викију, те је део упита изостављен ($1).',
	'smw_nodisjunctions' => 'Дисјункције у упитима нису подржане на овом викију, те је део упита изостављен ($1).',
	'smw_querytoolarge' => 'Следеће услове упита није могуће разматрати због рестрикција викија за дужину и обим упита: $1.',
	'smw_notemplategiven' => 'Понудите вредност за параметар ”шаблон”, како би овај формат упита дао резултат.',
	'smw_type_header' => 'Особине типа "$1"',
	'smw_typearticlecount' => 'Приказ $1 {{PLURAL:$1|особине|особина}} за овај тип.',
	'smw_attribute_header' => 'Странице које користе особину "$1"',
	'smw_attributearticlecount' => 'Приказ $1 {{PLURAL:$1|странице|страница}} које користе ову особину.',
	'smw_subproperty_header' => 'Подособине',
	'smw_subpropertyarticlecount' => 'Ова особина садржи следећу/е $1 {{PLURAL:$1|подособину|подособине}}:',
	'smw_concept_header' => 'Странице концепта "$1"',
	'smw_conceptarticlecount' => 'Приказ $1 {{PLURAL:$1|странице|страница}} које припадају том концепту.',
	'smw_rss_description' => '$1 RSS довод',
	'specialpages-group-smw_group' => 'Семантички Медијавики',
	'exportrdf' => 'Извези странице у RDF',
	'smw_exportrdf_docu' => 'Ова страница омогућава преузимање података с неке странице у формату RDF.
Да бисте извезли странице, унесите наслове у кућицу испод (по један наслов у сваком реду).',
	'smw_exportrdf_recursive' => 'Рекурзивно извези све повезане странице.
Обратите пажњу да резултат може бити веома обиман!',
	'smw_exportrdf_backlinks' => 'Такође извези све странице које вежу на већ извезене странице.
Генерише RDF који је могуће прегледати.',
	'smw_exportrdf_lastdate' => 'Не извози странице које нису мењане од датог момента.',
	'smw_exportrdf_submit' => 'Извоз',
	'uriresolver' => 'URI резолвер',
	'properties' => 'Особине',
	'smw_properties_docu' => 'Следеће особине се користе на викију.',
	'smw_property_template' => '$1 типа $2 ($3)',
	'smw_property_template_notype' => '$1 ($2)',
	'smw_propertylackspage' => 'Све особине требају имати описну страницу!',
	'smw_propertylackstype' => 'Нема дефинисаног типа за ову особину (за сада усвајам тип $1).',
	'smw_propertyhardlyused' => 'Ова особина једва да се користи на овом  викију!',
	'unusedproperties' => 'Неискоришћене особине',
	'smw_unusedproperties_docu' => 'Следеће особине постоје иако нема других страница које их користе.',
	'smw_unusedproperty_template' => '$1 типа $2',
	'wantedproperties' => 'Тражене особине',
	'smw_wantedproperties_docu' => 'Следеће особине се користе на викију, али још увек немају своју страницу са описом.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|употреба|употреба}})',
	'smw_purge' => 'Освежи',
	'types' => 'Типови',
	'smw_types_docu' => 'Ово је списак свих врста података који могу да се додељују својствима.',
	'semanticstatistics' => 'Семантичке статистике',
	'smw_semstats_text' => "Овај вики садржи '''$1''' {{PLURAL:$1|вредност|вредности|вредности}} својства од укупно '''$2''' [[Special:Properties|{{PLURAL:$2|својства|различита својства|различитих својстава}}]].
'''$3''' {{PLURAL:$3|својство има своју страницу|својства имају своје странице|својстава имају своје странице}}, а предвиђена врста података је назначена за '''$4''' од њих.
Неки од постојећих својстава могу бити [[Special:UnusedProperties|неискоришћени]].
Својства која још немају страницу налазе се на [[Special:WantedProperties|списку потребних својстава]].",
	'ask' => 'Семантичка претрага',
	'smw_ask_sortby' => 'Сортирај у колоне (опционо)',
	'smw_ask_ascorder' => 'Растући',
	'smw_ask_descorder' => 'Опадајући',
	'smw_ask_submit' => 'Пронађи резултате',
	'smw_ask_editquery' => '[Уреди упит]',
	'smw_add_sortcondition' => '[Додај услове сортирања]',
	'smw_ask_hidequery' => 'Сакриј упит',
	'smw_ask_help' => 'Упит у странице помоћи',
	'smw_ask_queryhead' => 'Упит',
	'smw_ask_printhead' => 'Додатни подаци за приказ',
	'smw_ask_printdesc' => '(додај једно име особине по линији)',
	'smw_ask_format_as' => 'Форматирај као:',
	'smw_ask_defaultformat' => 'подразумевано',
	'smw_ask_otheroptions' => 'Остале поставке',
	'smw_ask_show_embed' => 'Прикажи угнеждени код',
	'smw_ask_hide_embed' => 'Сакриј угнеждени код',
	'smw_ask_embed_instr' => 'За непосредно гнеждење овог упита у страницу викија, користи доњи код.',
	'searchbyproperty' => 'Претражи по особинама',
	'smw_sbv_docu' => 'Претражи све странице које поседују дату особину и вредност.',
	'smw_sbv_novalue' => 'Унесите ваљану вредност за ову особину, или погледајте све вредности особине за "$1".',
	'smw_sbv_displayresult' => 'Списак свих страница које садрже особину "$1" са вредношћу "$2"',
	'smw_sbv_displayresultfuzzy' => 'Списак свих страница које садрже особину "$1" са вредношћу "$2".
Пошто је пронађено само неколико резултата, такође су приказане приближне вредности.',
	'smw_sbv_property' => 'Особина:',
	'smw_sbv_value' => 'Вредност:',
	'smw_sbv_submit' => 'Пронађи резултате',
	'browse' => 'Прегледај вики',
	'smw_browselink' => 'Прегледај особине',
	'smw_browse_article' => 'Унесите име почетне странице за претрагу.',
	'smw_browse_go' => 'Иди',
	'smw_browse_more' => '…',
	'smw_browse_show_incoming' => 'прикажи особине које вежу овде',
	'smw_browse_hide_incoming' => 'сакриј особине које вежу овде',
	'smw_browse_no_outgoing' => 'Ова страница нема особина.',
	'smw_browse_no_incoming' => 'Нема особина које вежу на ову страницу.',
	'smw_inverse_label_default' => '$1 од',
	'smw_inverse_label_property' => 'Реципрочна етикета особине',
	'pageproperty' => 'Страница за претрагу особина',
	'smw_pp_docu' => 'Претражи све вредности особине на датој страници.
Унесите обоје, и страницу, и особину.',
	'smw_pp_from' => 'Од странице',
	'smw_pp_type' => 'Особина',
	'smw_pp_submit' => 'Пронађени резултати',
	'smw_result_prev' => 'Претходни',
	'smw_result_next' => 'Следеће',
	'smw_result_results' => 'Резултати',
	'smw_result_noresults' => 'Нема резултата.',
	'smwadmin' => 'Управљачке функције за Семантички медијавики',
	'smw_smwadmin_setupsuccess' => 'Машина за складиштење је успешно покренута.',
	'smw_smwadmin_return' => 'Назад на $1',
	'smw_smwadmin_updatestarted' => 'Започет је нови процес за обнављање семантичких података.
Сви сачувани подаци ће бити поново обновљени или поправљени по потреби.
Можете следити ток ажурирања на овој посебној страници.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Већ је у току један процес ажурирања.
Не покрећите други.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Сви постојећи процеси ажурирања су обустављени.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Како бисте обуставили покренути процес ажурирања, морате активирати контролни оквир да бисте потврдили да сте сигурни да желите да га обуставите.', # Fuzzy
	'smw_smwadmin_docu' => 'Ова посебна страница вам помаже приликом инсталирања и ажурирања <a href="http://semantic-mediawiki.org">Семантичког медијавикија</a>.
Не заборавите да направите копију вредних података пре него покренете функције администрације.',
	'smw_smwadmin_db' => 'Инсталирање и ажурирање базе података',
	'smw_smwadmin_dbdocu' => 'Семантички медијавики захтева неке додатке у бази података Медијавикија, како би се могли чувати семантички подаци.
Доња функција потврђује да је ваша база података исправно инсталирана.
Промене које ће се сада извести немају последица за остали део базе података Медијавикија, а по потреби се могу врло лако поништити.
Ова функција инсталирања се може покретати више пута без бојазни да ће нанети неку штету, али је неопходна само једном приликом инсталирања или ажурирања.',
	'smw_smwadmin_permissionswarn' => 'Ако се операција заврши са SQL грешкама, корисник базе података (погледајте ваш LocalSettings.php) вероватно нема довољно дозвола за извршавање неопходних операција.
Или дајте неопходне дозволе том кориснику како би могао да прави и брише табеле у бази, привремено се улогујте као root у LocalSettings.php, или користите скрипту за одржавање <tt>SMW_setup.php</tt>, која може користити акредитацију из скрипте AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Покретање или ажурирање табела базе података',
	'smw_smwadmin_announce' => 'Дојавите о постојању вашег викија',
	'smw_smwadmin_announcedocu' => 'Семантички медијавики има веб сервиз за дојаву о постојању нових викија.
Тај сајт се користи за одржавање списка јавно доступних сајтова који користе Семантички медијавики, углавном ради помоћи <a href="http://semantic-mediawiki.org/wiki/SMW_Project">пројекту Семантички медијавики</a> да прикупи информације о типичним коришћењима Семантичког медијавикија.
Погледајте главну страну Семаничког медијавикија за <a href="http://semantic-mediawiki.org/wiki/Registry">више информација о овом сервизу</a>.',
	'smw_smwadmin_announcebutton' => 'Кликните на следеће дугме за слање URL-а вашег викија том сервису.
Сервис неће регистровати викије који нису јавно доступни, а једино ће сачувати јавно доступне информације.',
	'smw_smwadmin_datarefresh' => 'Поправљање података и ажурирање',
	'smw_smwadmin_datarefreshdocu' => 'Постоји могућност за враћање свих података семантичког Медијавикија који су засновани на тренутном садржају викија.
Ово је корисно за исправку оштећених података или за обнову података ако је унутрашњи формат промењен као резултат доградње софтвера.
Ажурирање се врши за сваку страницу понаособ, и треба да прође неко време како би се све вратило у нормалу.
Испод је приказано да ли је ажурирање у току, а то вам омогућава да започнете или зауставите доградње (осим ако ту могућност није искључио администратор).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Једно ажурирање је већ у току.</strong>
Нормално је да ажурирање напредује споро, пошто се само освежавају мали делови података сваки пут када корисник приступи викију.
Да би се ово ажурирање брже завршило, можете покренути скрипту за одржавање Медијавикија <tt>runJobs.php</tt> (користите опцију <tt>--maxjobs 1000</tt> за рестрикцију броја ажурирања у једном пакету).
Процена напредовања тренутног ажурирања:',
	'smw_smwadmin_datarefreshbutton' => 'Почни ажурирање података',
	'smw_smwadmin_datarefreshstop' => 'Заустави ово ажурирање',
	'smw_smwadmin_datarefreshstopconfirm' => 'Да, сигуран/-на сам',
	'smw_smwadmin_support' => 'Добијање подршке',
	'smw_smwadmin_supportdocu' => 'Постоји више места која могу помоћи у случају проблема:',
	'smw_smwadmin_installfile' => 'Ако наиђете на проблем при инсталацији, најпре прочитајте смернице у <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">датотеци INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Потпуна корисничка документација за Семантички медијавики, налази се на сајту <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Багови се могу пријављивати на <a href="https://bugzilla.wikimedia.org/">Медијазилу</a>.',
	'smw_smwadmin_questions' => 'Ако имате даљих питања или сугестија, укључите се у дискусију на листи <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>.',
	'smw_adminlinks_datastructure' => 'Структура података',
	'smw_adminlinks_displayingdata' => 'Приказивање података',
	'smw_adminlinks_inlinequerieshelp' => 'Помоћ за непосредне упите',
	'smw_unknowntype' => 'Неподржан тип "$1" је дефинисан за особину.', # Fuzzy
);

/** Serbian (Latin script) (srpski (latinica)‎)
 * @author Liangent
 * @author Michaello
 * @author Rancher
 * @author Slaven Kosanovic
 */
$messages['sr-el'] = array(
	'smw_viewasrdf' => 'RDF dovod',
	'smw_finallistconjunct' => ', i',
	'smw_factbox_head' => 'Činjenice o $1',
	'smw_isspecprop' => 'Ova osobina je posebna osobina na ovom vikiju.',
	'smw_concept_description' => 'Opis koncepta "$1"',
	'smw_no_concept_namespace' => 'Koncepte je jedino moguće definisati na stranicama u imenskom prostoru Concept:',
	'smw_multiple_concepts' => 'Svaka pojedinačna stranica koncepta, može sadržati definiciju samo jednog koncepta.',
	'smw_concept_cache_miss' => 'Koncept "$1" se trenutno ne može koristiti, pošto konfiguracija vikija zahteva da bude komputovan oflajn.
Ako problem ne nestane za neko vreme, zatražite od administratora sajta da učini ovaj koncept dostupnim.',
	'smw_noinvannot' => 'Vrednosti nije moguće pripisati inverznim osobinama.',
	'smw_baduri' => 'URI-ji oblika "$1", nisu prihvatljivi.',
	'smw_rss_link' => 'RSS',
	'smw_csv_link' => 'CSV',
	'smw_json_link' => 'JSON',
	'smw_rdf_link' => 'RDF',
	'smw_printername_count' => 'Izbroj rezultate',
	'smw_printername_csv' => 'CSV izvoz',
	'smw_printername_debug' => 'Upit za prečišćavanje (samo za eksperte)',
	'smw_printername_embedded' => 'Ugnezdi sadržaj stranice',
	'smw_printername_json' => 'JSON izvoz',
	'smw_printername_list' => 'Spisak',
	'smw_printername_ol' => 'Enumeracija',
	'smw_printername_rss' => 'RSS izvoz',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Široka tabela',
	'smw_printername_template' => 'Šablon',
	'smw-paramdesc-limit' => 'Maksimalni broj rezultata koji će biti vraćeni',
	'smw-paramdesc-mainlabel' => 'Etiketa koja će se koristiti za ime glavne stranice',
	'smw-paramdesc-link' => 'Prikaži vrednosti u obliku veza',
	'smw-paramdesc-intro' => 'Tekst koji treba da se prikaže prije rezultata upita (u slučaju potrebe)',
	'smw-paramdesc-outro' => 'Tekst koji treba da se prikaže iza rezultata upita (u slučaju potrebe)',
	'smw-paramdesc-default' => 'Tekst koji treba da se prikaže u slučaju da upit nije dao rezultate',
	'smw-paramdesc-sep' => 'Razdvajač za vrednosti',
	'smw-paramdesc-columns' => 'Broj kolona u kojima će se prikazati rezultati (predodređeno $1)',
	'smw-paramdesc-embedonly' => 'Ne prikazuj zaglavlja',
	'smw-paramdesc-rsstitle' => 'Tekst koji će se koristiti kao naslov u dobavljaču',
	'smw-paramdesc-rssdescription' => 'Tekst koji će se koristiti kao opis u dobavljaču',
	'smw-paramdesc-searchlabel' => 'Tekst veze s rezultatima', # Fuzzy
	'smw_iq_disabled' => 'Semantički upiti su onemogućeni na ovom vikiju.',
	'smw_iq_moreresults' => '... više rezultata',
	'smw_parseerror' => 'Data vrednost nije shvaćena.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" se ne može koristiti za ime stranice na ovom vikiju.',
	'smw_wrong_namespace' => 'Samo stranice iz imenskog prostora "$1" su dozvoljene ovde.',
	'smw_manytypes' => 'Više od jednog tipa je definisano za ovu osobinu.',
	'smw_emptystring' => 'Prazni stringovi nisu prihvatljivi.',
	'smw_maxstring' => 'Tekstualna predstava $1 je predugačka.',
	'smw_notinenum' => '"$1" nije na spisku mogućih vrednosti ($2) za ovu osobinu.',
	'smw_noboolean' => '"$1" nije prepoznat kao Bolova vrednost (istinito/neistinito).',
	'smw_true_words' => 'istinito, i, da, d',
	'smw_false_words' => 'neistinito, n, ne, n',
	'smw_nofloat' => '"$1" nije broj.',
	'smw_infinite' => 'Brojevi dužine kao "$1" nisu podržani.',
	'smw_novalues' => 'Nema naznačene vrednosti.',
	'smw_nodatetime' => 'Format datuma "$1" nije razumljiv.',
	'smw_toomanyclosing' => 'Izgleda da je previše slučajeva tipa "$1" u upitu.',
	'smw_noclosingbrackets' => 'Neke uglaste zagrade "<nowiki>[[</nowiki>" u vašem upitu, nisu zatvorene odgovarajućim "]]".',
	'smw_misplacedsymbol' => 'Simbol "$1" je iskorišćen na mestu gde nije od koristi.',
	'smw_unexpectedpart' => 'Deo upita "$1" nije shvaćen.
Rezultati mogu biti neočekivani.',
	'smw_emptysubquery' => 'Neki podupiti ne sadrže valjane uslove.',
	'smw_misplacedsubquery' => 'Neki podupiti su korišćeni na mestu gde podupiti nisu dozvoljeni.',
	'smw_valuesubquery' => 'Za vrednosti osobine "$1", podupiti nisu podržani.',
	'smw_badqueryatom' => 'Jedan deo "<nowiki>[[…]]</nowiki>" upita nije shvaćen.',
	'smw_propvalueproblem' => 'Vrednost za osobinu "$1" nije shvaćena.',
	'smw_noqueryfeature' => 'Neki delovi ovog upita nisu podržani na ovom vikiju, te je deo upita izostavljen ($1).',
	'smw_noconjunctions' => 'Konjukcije u upitima nisu podržane na ovom vikiju, te je deo upita izostavljen ($1).',
	'smw_nodisjunctions' => 'Disjunkcije u upitima nisu podržane na ovom vikiju, te je deo upita izostavljen ($1).',
	'smw_querytoolarge' => 'Sledeće uslove upita nije moguće razmatrati zbog restrikcija vikija za dužinu i obim upita: $1.',
	'smw_notemplategiven' => 'Ponudite vrednost za parametar ”šablon”, kako bi ovaj format upita dao rezultat.',
	'smw_type_header' => 'Osobine tipa "$1"',
	'smw_typearticlecount' => 'Prikaz $1 {{PLURAL:$1|osobine|osobina}} za ovaj tip.',
	'smw_attribute_header' => 'Stranice koje koriste osobinu "$1"',
	'smw_attributearticlecount' => 'Prikaz $1 {{PLURAL:$1|stranice|stranica}} koje koriste ovu osobinu.',
	'smw_subproperty_header' => 'Podosobine',
	'smw_subpropertyarticlecount' => 'Ova osobina sadrži sledeću/e $1 {{PLURAL:$1|podosobinu|podosobine}}:',
	'smw_concept_header' => 'Stranice koncepta "$1"',
	'smw_conceptarticlecount' => 'Prikaz $1 {{PLURAL:$1|stranice|stranica}} koje pripadaju tom konceptu.',
	'smw_rss_description' => '$1 RSS dovod',
	'specialpages-group-smw_group' => 'Semantički Medijaviki',
	'exportrdf' => 'Izvezi stranice u RDF',
	'smw_exportrdf_docu' => 'Ova stranica omogućava preuzimanje podataka s neke stranice u formatu RDF.
Da biste izvezli stranice, unesite naslove u kućicu ispod (po jedan naslov u svakom redu).',
	'smw_exportrdf_recursive' => 'Rekurzivno izvezi sve povezane stranice.
Obratite pažnju da rezultat može biti veoma obiman!',
	'smw_exportrdf_backlinks' => 'Takođe izvezi sve stranice koje vežu na već izvezene stranice.
Generiše RDF koji je moguće pregledati.',
	'smw_exportrdf_lastdate' => 'Ne izvozi stranice koje nisu menjane od datog momenta.',
	'smw_exportrdf_submit' => 'Izvoz',
	'uriresolver' => 'URI rezolver',
	'properties' => 'Osobine',
	'smw_properties_docu' => 'Sledeće osobine se koriste na vikiju.',
	'smw_property_template' => '$1 tipa $2 ($3)',
	'smw_property_template_notype' => '$1 ($2)',
	'smw_propertylackspage' => 'Sve osobine trebaju imati opisnu stranicu!',
	'smw_propertylackstype' => 'Nema definisanog tipa za ovu osobinu (za sada usvajam tip $1).',
	'smw_propertyhardlyused' => 'Ova osobina jedva da se koristi na ovom  vikiju!',
	'unusedproperties' => 'Neiskorišćene osobine',
	'smw_unusedproperties_docu' => 'Sledeće osobine postoje iako nema drugih stranica koje ih koriste.',
	'smw_unusedproperty_template' => '$1 tipa $2',
	'wantedproperties' => 'Tražene osobine',
	'smw_wantedproperties_docu' => 'Sledeće osobine se koriste na vikiju, ali još uvek nemaju svoju stranicu sa opisom.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|upotreba|upotreba}})',
	'smw_purge' => 'Osveži',
	'types' => 'Tipovi',
	'smw_types_docu' => 'Ovo je spisak svih vrsta podataka koji mogu da se dodeljuju svojstvima.',
	'semanticstatistics' => 'Semantičke statistike',
	'smw_semstats_text' => "Ovaj viki sadrži '''$1''' {{PLURAL:$1|vrednost|vrednosti|vrednosti}} svojstva od ukupno '''$2''' [[Special:Properties|{{PLURAL:$2|svojstva|različita svojstva|različitih svojstava}}]].
'''$3''' {{PLURAL:$3|svojstvo ima svoju stranicu|svojstva imaju svoje stranice|svojstava imaju svoje stranice}}, a predviđena vrsta podataka je naznačena za '''$4''' od njih.
Neki od postojećih svojstava mogu biti [[Special:UnusedProperties|neiskorišćeni]].
Svojstva koja još nemaju stranicu nalaze se na [[Special:WantedProperties|spisku potrebnih svojstava]].",
	'ask' => 'Semantička pretraga',
	'smw_ask_sortby' => 'Sortiraj u kolone (opciono)',
	'smw_ask_ascorder' => 'Rastući',
	'smw_ask_descorder' => 'Opadajući',
	'smw_ask_submit' => 'Pronađi rezultate',
	'smw_ask_editquery' => '[Uredi upit]',
	'smw_add_sortcondition' => '[Dodaj uslove sortiranja]',
	'smw_ask_hidequery' => 'Sakrij upit',
	'smw_ask_help' => 'Upit u stranice pomoći',
	'smw_ask_queryhead' => 'Upit',
	'smw_ask_printhead' => 'Dodatni podaci za prikaz',
	'smw_ask_printdesc' => '(dodaj jedno ime osobine po liniji)',
	'smw_ask_format_as' => 'Formatiraj kao:',
	'smw_ask_defaultformat' => 'podrazumevano',
	'smw_ask_otheroptions' => 'Ostale postavke',
	'smw_ask_show_embed' => 'Prikaži ugneždeni kod',
	'smw_ask_hide_embed' => 'Sakrij ugneždeni kod',
	'smw_ask_embed_instr' => 'Za neposredno gneždenje ovog upita u stranicu vikija, koristi donji kod.',
	'searchbyproperty' => 'Pretraži po osobinama',
	'smw_sbv_docu' => 'Pretraži sve stranice koje poseduju datu osobinu i vrednost.',
	'smw_sbv_novalue' => 'Unesite valjanu vrednost za ovu osobinu, ili pogledajte sve vrednosti osobine za "$1".',
	'smw_sbv_displayresult' => 'Spisak svih stranica koje sadrže osobinu "$1" sa vrednošću "$2"',
	'smw_sbv_displayresultfuzzy' => 'Spisak svih stranica koje sadrže osobinu "$1" sa vrednošću "$2".
Pošto je pronađeno samo nekoliko rezultata, takođe su prikazane približne vrednosti.',
	'smw_sbv_property' => 'Osobina:',
	'smw_sbv_value' => 'Vrednost:',
	'smw_sbv_submit' => 'Pronađi rezultate',
	'browse' => 'Pregledaj viki',
	'smw_browselink' => 'Pregledaj osobine',
	'smw_browse_article' => 'Unesite ime početne stranice za pretragu.',
	'smw_browse_go' => 'Idi',
	'smw_browse_more' => '…',
	'smw_browse_show_incoming' => 'prikaži osobine koje vežu ovde',
	'smw_browse_hide_incoming' => 'sakrij osobine koje vežu ovde',
	'smw_browse_no_outgoing' => 'Ova stranica nema osobina.',
	'smw_browse_no_incoming' => 'Nema osobina koje vežu na ovu stranicu.',
	'smw_inverse_label_default' => '$1 od',
	'smw_inverse_label_property' => 'Recipročna etiketa osobine',
	'pageproperty' => 'Stranica za pretragu osobina',
	'smw_pp_docu' => 'Pretraži sve vrednosti osobine na datoj stranici.
Unesite oboje, i stranicu, i osobinu.',
	'smw_pp_from' => 'Od stranice',
	'smw_pp_type' => 'Osobina',
	'smw_pp_submit' => 'Pronađeni rezultati',
	'smw_result_prev' => 'Prethodni',
	'smw_result_next' => 'Sledeće',
	'smw_result_results' => 'Rezultati',
	'smw_result_noresults' => 'Nema rezultata.',
	'smwadmin' => 'Upravljačke funkcije za Semantički medijaviki',
	'smw_smwadmin_setupsuccess' => 'Mašina za skladištenje je uspešno pokrenuta.',
	'smw_smwadmin_return' => 'Nazad na $1',
	'smw_smwadmin_updatestarted' => 'Započet je novi proces za obnavljanje semantičkih podataka.
Svi sačuvani podaci će biti ponovo obnovljeni ili popravljeni po potrebi.
Možete slediti tok ažuriranja na ovoj posebnoj stranici.', # Fuzzy
	'smw_smwadmin_updatenotstarted' => 'Već je u toku jedan proces ažuriranja.
Ne pokrećite drugi.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Svi postojeći procesi ažuriranja su obustavljeni.', # Fuzzy
	'smw_smwadmin_updatenotstopped' => 'Kako biste obustavili pokrenuti proces ažuriranja, morate aktivirati kontrolni okvir da biste potvrdili da ste sigurni da želite da ga obustavite.', # Fuzzy
	'smw_smwadmin_docu' => 'Ova posebna stranica vam pomaže prilikom instaliranja i ažuriranja <a href="http://semantic-mediawiki.org">Semantičkog medijavikija</a>.
Ne zaboravite da napravite kopiju vrednih podataka pre nego pokrenete funkcije administracije.',
	'smw_smwadmin_db' => 'Instaliranje i ažuriranje baze podataka',
	'smw_smwadmin_dbdocu' => 'Semantički medijaviki zahteva neke dodatke u bazi podataka Medijavikija, kako bi se mogli čuvati semantički podaci.
Donja funkcija potvrđuje da je vaša baza podataka ispravno instalirana.
Promene koje će se sada izvesti nemaju posledica za ostali deo baze podataka Medijavikija, a po potrebi se mogu vrlo lako poništiti.
Ova funkcija instaliranja se može pokretati više puta bez bojazni da će naneti neku štetu, ali je neophodna samo jednom prilikom instaliranja ili ažuriranja.',
	'smw_smwadmin_permissionswarn' => 'Ako se operacija završi sa SQL greškama, korisnik baze podataka (pogledajte vaš LocalSettings.php) verovatno nema dovoljno dozvola za izvršavanje neophodnih operacija.
Ili dajte neophodne dozvole tom korisniku kako bi mogao da pravi i briše tabele u bazi, privremeno se ulogujte kao root u LocalSettings.php, ili koristite skriptu za održavanje <tt>SMW_setup.php</tt>, koja može koristiti akreditaciju iz skripte AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Pokretanje ili ažuriranje tabela baze podataka',
	'smw_smwadmin_announce' => 'Dojavite o postojanju vašeg vikija',
	'smw_smwadmin_announcedocu' => 'Semantički medijaviki ima veb serviz za dojavu o postojanju novih vikija.
Taj sajt se koristi za održavanje spiska javno dostupnih sajtova koji koriste Semantički medijaviki, uglavnom radi pomoći <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektu Semantički medijaviki</a> da prikupi informacije o tipičnim korišćenjima Semantičkog medijavikija.
Pogledajte glavnu stranu Semaničkog medijavikija za <a href="http://semantic-mediawiki.org/wiki/Registry">više informacija o ovom servizu</a>.',
	'smw_smwadmin_announcebutton' => 'Kliknite na sledeće dugme za slanje URL-a vašeg vikija tom servisu.
Servis neće registrovati vikije koji nisu javno dostupni, a jedino će sačuvati javno dostupne informacije.',
	'smw_smwadmin_datarefresh' => 'Popravljanje podataka i ažuriranje',
	'smw_smwadmin_datarefreshdocu' => 'Moguće je restaurirati sve podatke Semantičkog medijavikija, bazirajući se na sadržaju vikija.
To može biti korisno za reparaciju podataka ili obnavljanje podataka u slučaju da su se izvršile neke izmene u unutrašnjem formatu zbog nadogradnje softvera.
Ažuriranje će se obaviti stranicu po stranicu i neće se odmah završiti.
Sledeći prikaz služi za nadgledanje ažuriranja u progresu i omogućava vam da ih pokrenete ili obustavite (osim ako administrator sajta nije isključio ovu mogućnost).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Jedno ažuriranje je već u toku.</strong>
Normalno je da ažuriranje napreduje sporo, pošto se samo osvežavaju mali delovi podataka svaki put kada korisnik pristupi vikiju.
Da bi se ovo ažuriranje brže završilo, možete pokrenuti skriptu za održavanje Medijavikija <tt>runJobs.php</tt> (koristite opciju <tt>--maxjobs 1000</tt> za restrikciju broja ažuriranja u jednom paketu).
Procena napredovanja trenutnog ažuriranja:',
	'smw_smwadmin_datarefreshbutton' => 'Počni ažuriranje podataka',
	'smw_smwadmin_datarefreshstop' => 'Zaustavi ovo ažuriranje',
	'smw_smwadmin_datarefreshstopconfirm' => 'Da, siguran/-na sam',
	'smw_smwadmin_support' => 'Dobijanje podrške',
	'smw_smwadmin_supportdocu' => 'Postoji više mesta koja mogu pomoći u slučaju problema:',
	'smw_smwadmin_installfile' => 'Ako se nađete u problemima sa vašom instalacijom, pogledajte vodič u <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">fajlu INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Potpuna korisnička dokumentacija za Semantički medijaviki, nalazi se na sajtu <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Bagovi se mogu prijavljivati na <a href="https://bugzilla.wikimedia.org/">Medijazilu</a>.',
	'smw_smwadmin_questions' => 'Ako imate daljih pitanja ili sugestija, uključite se u diskusiju na listi <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>.',
	'smw_adminlinks_datastructure' => 'Struktura podataka',
	'smw_adminlinks_displayingdata' => 'Prikazivanje podataka',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoć za neposredne upite',
	'smw_unknowntype' => 'Nepodržan tip "$1" je definisan za osobinu.', # Fuzzy
);

/** Swedish (svenska)
 * @author Boivie
 * @author Eliasb
 * @author Flrn
 * @author Gabbe.g
 * @author Lejonel
 * @author Leo Johannes
 * @author M.M.S.
 * @author MagnusA
 * @author Martinwiss
 * @author Najami
 * @author Per
 * @author Rotsee
 * @author Sannab
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'smw-desc' => "Gör din wiki mer tillgänglig - för maskiner ''och'' människor ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentation online])",
	'smw_viewasrdf' => 'RDF-matning',
	'smw_finallistconjunct' => 'och',
	'smw_factbox_head' => 'Fakta om $1',
	'smw_isspecprop' => 'Den här egenskapen är en specialegenskap på den här wikin.',
	'smw_concept_description' => 'Beskrivning av konceptet "$1"',
	'smw_no_concept_namespace' => 'Koncept kan endast defineras på sidor i namnrymden Concept:',
	'smw_multiple_concepts' => 'Varje konceptsida kan endast ha en konceptdefinition.',
	'smw_concept_cache_miss' => 'Konceptet "$1" kan inte användas för tillfället, eftersom wiki-konfigurationen kräver att det beräknas off-line.
Om problemet inte försvinner efter någon tid, så be din administratör att göra konceptet tillgängligt.',
	'smw_noinvannot' => 'Värden kan inte tilldelas inverterade egenskaper.',
	'version-semantic' => 'semantiska tillägg',
	'smw_baduri' => 'Beklagar, URI:er på formen "$1" är inte tillåtna.',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Räkna resultat',
	'smw_printername_csv' => 'CSV-exportering',
	'smw_printername_dsv' => 'DSV-exportering',
	'smw_printername_debug' => 'Felsökningsfråga (för experter)',
	'smw_printername_embedded' => 'Bädda in sidinnehåll',
	'smw_printername_json' => 'JSON-exportering',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Numrering',
	'smw_printername_ul' => 'Objektisering',
	'smw_printername_rss' => 'RSS-exportering',
	'smw_printername_table' => 'Tabell',
	'smw_printername_broadtable' => 'Bred tabell',
	'smw_printername_template' => 'Mall',
	'smw_printername_rdf' => 'RDF-exportering',
	'smw_printername_category' => 'Kategori',
	'validator-type-class-SMWParamSource' => 'text',
	'smw-paramdesc-limit' => 'Maximalt antal resultat att visa',
	'smw-paramdesc-offset' => 'Vilket resultat i ordningen ska visas som det första?',
	'smw-paramdesc-headers' => 'Visa rubriker/egenskapsnamn',
	'smw-paramdesc-mainlabel' => 'Etiketten som ska ges till huvudsidans namn',
	'smw-paramdesc-link' => 'Visa värden som länkar',
	'smw-paramdesc-intro' => 'Text som ska visas före resultatet (om det finns något)',
	'smw-paramdesc-outro' => 'Text som ska visas efter resultatet (om det finns något)',
	'smw-paramdesc-default' => 'Text som ska visas om det inte finns något resultat',
	'smw-paramdesc-sep' => 'Tecken som avgränsar värden',
	'smw-paramdesc-showsep' => 'Visa det tecken som används för att avgränsa i topen på CSV-filen ("sep=<value>")',
	'smw-paramdesc-distribution' => 'Räkna och visa antalet förekomster istället för att visa alla värden.',
	'smw-paramdesc-distributionsort' => 'Sortera värdena efter hur ofta de förekommer.',
	'smw-paramdesc-distributionlimit' => 'Begränsa värdefördelningen till vissa värdens antal',
	'smw-paramdesc-template' => 'Namnet på den mall som visar utskriften',
	'smw-paramdesc-columns' => 'Antalet kolumner som ska visa resultat (förvalt är $1)',
	'smw-paramdesc-userparam' => 'Ett värde som ges varje efterfrågad mall, om en mall används',
	'smw-paramdesc-introtemplate' => 'Namnet på den mall som ska visas innan frågan besvaras, om det finns någon',
	'smw-paramdesc-outrotemplate' => 'Namnet på den mall som ska visa efter frågas besvaras, om det finns någon',
	'smw-paramdesc-embedformat' => 'HTML-element för rubriker',
	'smw-paramdesc-embedonly' => 'Visa inga rubriker',
	'smw-paramdesc-table-class' => 'Ytterligare en CSS-klass som ska användas för tabellen',
	'smw-paramdesc-rsstitle' => 'Texten som ska användas som titel för flödet',
	'smw-paramdesc-rssdescription' => 'Texten som ska beskriva flödet',
	'smw-paramdesc-rdfsyntax' => 'RDF-syntax som ska användas',
	'smw-paramdesc-csv-sep' => 'Skiljetecken att använda',
	'smw-paramdesc-dsv-separator' => 'Skiljetecken att använda',
	'smw-paramdesc-dsv-filename' => 'Namn på DSV-filen',
	'smw-smwdoc-description' => 'Visar en tabell med alla parametrar som kan användas för det angivna resultatformatet, samt standardvärden och beskrivningar.',
	'smw-smwdoc-par-format' => 'Resultatformatet som parameter-dokumentation ska visas för.',
	'smw-smwdoc-par-parameters' => 'Vilka parametrar som ska visas. Välj ”specific” för sådana som hör till det här formatet, ”base” för sådana som är tillgängliga för alla format, och ”all” för samtliga parametrar.',
	'smw-paramdesc-sort' => 'Egenskap som resultatet ska sorteras efter',
	'smw-paramdesc-order' => 'Sortering för frågan',
	'smw-paramdesc-searchlabel' => 'Text för att fortsätta sökningen',
	'smw-paramdesc-named_args' => 'Namnet på de argument som ska ges till mallen',
	'smw-paramdesc-export' => 'Export-alternativ',
	'smw-paramdesc-prettyprint' => 'Ett stilfullt utskiftsformat med indrag och radbrytningar',
	'smw-paramdesc-source' => 'Alternativ frågekälla',
	'smw-paramdesc-jsonsyntax' => 'JSON-syntax som ska användas',
	'smw_iq_disabled' => 'Beklagar. Semantiska efterfrågningar har slagits av på den här wikin.',
	'smw_iq_moreresults' => '… mer resultat',
	'smw_parseerror' => 'Det angivna värdet förstods inte.',
	'smw_notitle' => '"$1" kan inte användas som sidnamn på den här wikin.',
	'smw_noproperty' => '”$1” kan inte användas som namn på en egenskap på den här wikin.',
	'smw_wrong_namespace' => 'Endast sidor i namnrymden "$1" tillåts här.',
	'smw_manytypes' => 'Mer än en typ definierad för egenskapen.',
	'smw_emptystring' => 'Tomma stränger accepteras inte.',
	'smw_maxstring' => 'Strängrepresentationen $1 är för lång.',
	'smw_notinenum' => '"$1" är inte i listan över möjliga värden ($2) för den här egenskapen.',
	'smw_noboolean' => '"$1" är inte ett giltigt booleskt värde (sant/falskt).',
	'smw_true_words' => 'sant,s,ja,j',
	'smw_false_words' => 'falskt,f,nej,n',
	'smw_nofloat' => '"$1" är inte ett tal.',
	'smw_infinite' => 'Tal så stora som "$1" stödjs inte.',
	'smw_unitnotallowed' => '”$1” är ingen giltigt måttenhet för den här egenskapen.',
	'smw_nounitsdeclared' => 'Inga måttenheter har definierats för den här egenskapen.',
	'smw_novalues' => 'Inga värden angivna.',
	'smw_nodatetime' => 'Datumet "$1" förstods inte.',
	'smw_toomanyclosing' => '"$1" uppträder för många gånger i efterfrågningen.',
	'smw_noclosingbrackets' => 'Användningen av "<nowiki>[[</nowiki>" i din efterfrågning stängdes inte av "]]".',
	'smw_misplacedsymbol' => 'Symbolen "$1" användes på en plats där den inte är användbar.',
	'smw_unexpectedpart' => 'Delen "$1" av efterfrågningen förstods inte.
Vissa resultat kan bli oväntade.',
	'smw_emptysubquery' => 'Någon underfråga har inget giltigt villkor.',
	'smw_misplacedsubquery' => 'Någon underfråga användes på ett ställe där inga underfrågor tillåts.',
	'smw_valuesubquery' => 'Underfrågor stöds inte för värden på egenskapen “$1”.',
	'smw_badqueryatom' => 'Någon del “<nowiki>[[…]]</nowiki>” av frågan förstods inte.',
	'smw_propvalueproblem' => 'Värdet på egenskap “$1” förstods inte.',
	'smw_noqueryfeature' => 'För någon frågefunktion saknades det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_noconjunctions' => 'För konjunktioner i frågor saknas det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_nodisjunctions' => 'För disjunktioner i frågor saknas det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_querytoolarge' => 'Följande frågevillkor kunde inte tas hänsyn till på grund av wikins begränsningar i frågestorlek eller -djup: $1.',
	'smw_notemplategiven' => 'För att den här frågan ska fungera behöver du ange ett värde på parametern "template".',
	'smw_db_sparqlqueryproblem' => 'Svaren på frågan kunde inte fås från SPARQL-databasen. Det här felet kan vara tillfälligt eller också så kan det bero på ett permanent fel med databasen.',
	'smw_db_sparqlqueryincomplete' => 'Den här frågan visade sig vara för komplex, och har arbetet med att besvara den har avbrutits. En del resultat kan saknas. Försök om möjligt med en enklare fråga.',
	'smw_type_header' => 'Egenskaper av typen “$1”',
	'smw_typearticlecount' => 'Visar $1 {{PLURAL:$1|egenskap|egenskaper}} som använder den här typen.',
	'smw_attribute_header' => 'Sidor som använder egenskapen "$1"',
	'smw_attributearticlecount' => 'Visar $1 {{PLURAL:$1|sida|sidor}} som använder den här egenskapen.',
	'smw_subproperty_header' => 'Underegenskaper',
	'smw_subpropertyarticlecount' => 'Denna egenskap har följande $1 {{PLURAL:$1|underegenskap|underegenskaper}}:',
	'smw_concept_header' => 'Sidor av konceptet "$1"',
	'smw_conceptarticlecount' => 'Visar {{PLURAL:$1|en sida|$1 sidor}} som hör till det konceptet.',
	'exportrdf' => 'Exportera sidor till RDF',
	'smw_exportrdf_docu' => 'Den här sidan låter dig hämta data från en sida i RDF-format.
Skriv sidtitlar i textrutan härunder för att exportera sidor (en titel per rad).',
	'smw_exportrdf_recursive' => 'Exportera alla relaterade sidor rekursivt.
Observera att resultatet kan bli stort!',
	'smw_exportrdf_backlinks' => 'Exportera också alla sidor som refererar till de exporterade sidorna.
Skapar en RDF som kan gås igenom.',
	'smw_exportrdf_lastdate' => 'Exportera inte sidor som inte ändrats efter den uppgivna tidpunkten.',
	'smw_exportrdf_submit' => 'Exportera',
	'uriresolver' => 'URI-lösare',
	'properties' => 'Egenskaper',
	'smw_properties_docu' => 'Följande egenskaper används i wikin',
	'smw_property_template' => '$1 av typen $2 ($3)',
	'smw_propertylackspage' => 'Alla egenskaper ska beskrivas av en sida!',
	'smw_propertylackstype' => 'Ingen typ specificerades för denna egenskap (antar typ $1 tills vidare).',
	'smw_propertyhardlyused' => 'Denna egenskap används knappt i wikin!',
	'unusedproperties' => 'Oanvända egenskaper',
	'smw_unusedproperties_docu' => 'Följande egenskaper finns fastän ingen annan sida använder dem.',
	'smw_unusedproperty_template' => '$1 av typen $2',
	'wantedproperties' => 'Önskade egenskaper',
	'smw_wantedproperties_docu' => 'Följande egenskaper används i wikin men har ännu inte en sida som beskriver dem.',
	'smw_wantedproperty_template' => '$1 (använd $2 {{PLURAL:$2|gång|gånger}})',
	'smw_purge' => 'Uppdatera',
	'types' => 'Typer',
	'smw_types_docu' => 'Här följer en lista med de datatyper som egenskaper kan ha',
	'semanticstatistics' => 'Semantisk statistik',
	'smw_semstats_text' => "Denna wiki innehåller '''$1''' {{PLURAL:$1|egenskapsvärde|egenskapsvärden}} för totalt '''$2''' [[Special:Properties|{{PLURAL:$2|egenskap|olika egenskaper}}]].
'''$3''' {{PLURAL:$3|egenskap|egenskaper}} har en egen sida, och den avsedda datatypen är specificerad för '''$4''' av dessa.
Några av de existerande egenskaperna kan vara [[Special:UnusedProperties|oanvända egenskaper]].
Egenskaper som fortfarande saknar en egen sida finns på [[Special:WantedProperties|listan över önskade egenskaper]].",
	'smw_uri_doc' => "URI-lösaren implementerar ''<a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG fynden i httpRange-14</a>''. Den ser till så att människor inte blir webbsidor.",
	'ask' => 'Semantisk sökning',
	'smw_ask_sortby' => 'Sortera efter kolumn (valfritt)',
	'smw_ask_ascorder' => 'Stigande',
	'smw_ask_descorder' => 'Sjunkande',
	'smw_ask_submit' => 'Hitta resultat',
	'smw_ask_editquery' => '[Redigera fråga]',
	'smw_add_sortcondition' => '[Lägg till sorteringsvillkor]',
	'smw_ask_hidequery' => 'Dölj fråga',
	'smw_ask_help' => 'Frågehjälp',
	'smw_ask_queryhead' => 'Fråga',
	'smw_ask_printhead' => 'Ytterligare data som ska visas',
	'smw_ask_printdesc' => '(lägg till varje egenskap på en egen rad)',
	'smw_ask_format_as' => 'Formatera som:',
	'smw_ask_defaultformat' => 'standard',
	'smw_ask_otheroptions' => 'Andra alternativ',
	'smw-ask-otheroptions-info' => 'Den här delen innehåller alternativ som påverkar "printout statements". Beskrivningar av parametrarna visar när du för pekaren över dem.',
	'smw-ask-otheroptions-collapsed-info' => 'Var vänlig använd plus-tecknet för att visa alla tillgänliga alternativ.',
	'smw_ask_show_embed' => 'Visa inbäddad kod',
	'smw_ask_hide_embed' => 'Göm inbäddad kod',
	'smw_ask_embed_instr' => 'För att lägga in denna fråga i en wiki-sida, använda koden nedan.',
	'smw-ask-delete' => '[Ta bort]',
	'smw-ask-sorting' => 'Sortering',
	'smw-ask-format-selection-help' => 'För en detaljerad beskrivning, var vänlig besök hjälp-sidan för $1.',
	'querycreator' => 'Fråge-generator',
	'smw_qc_addmainlabel' => 'Lägg till rubrik-etikett',
	'smw_qc_show_addnal_opts' => 'Visa fler alternativ',
	'smw_qc_hide_addnal_opts' => 'Visa färre alternativ',
	'smw_qc_otheropt' => 'Andra alternativ',
	'smw_qc_intro' => 'Intro:',
	'smw_qc_outro' => 'Avslutningstext:',
	'smw_qc_default' => 'Förvalt:',
	'smw_qc_formatopt' => 'Format-alternativ',
	'smw_qc_query_help' => 'Ställ en fråga med hjälp av forumuläret här nedanför. Välj wiki-sidor utifrån
Kategorier (<strong><nowiki>t.ex. [[Kategori:Skådespelare]]</nowiki></strong>),
Egenskap (<strong><nowiki>t.ex. [[Kommer från::Umeå]]</nowiki></strong>),
Namn (<strong><nowiki>t.ex. [[Umeå]]</nowiki></strong>) och
Namnrymder (<strong><nowiki>t.ex. [[Hjälp:+]]</nowiki></strong>)',
	'smw_qui_property' => '<strong>Egenskap</strong>',
	'smw_qui_prop' => 'Egenskap:',
	'smw_qui_labl' => 'Etikett:',
	'smw_qui_formt' => 'Format:',
	'smw_qui_limt' => 'Gräns:',
	'smw_qui_shownresults' => 'visa i resultat',
	'smw_qui_noquery' => 'Ingen fråga har ställts',
	'smw_qui_invalidprop' => '"$1" är kanske inte en giltig egenskap',
	'smw_qui_invalidformat' => 'Det valda formatet "$1" är inte tillgängligt för denna wiki',
	'smw_qui_nosort' => 'Ingen sortering',
	'smw_qui_ascorder' => 'Stigande',
	'smw_qui_descorder' => 'Fallande',
	'smw_qui_randorder' => 'Slumpmässig',
	'smw_qui_addnprop' => 'lägg till egenskap',
	'smw_qui_delete' => 'Ta bort',
	'smw_qui_rescol' => 'Resultat',
	'smw_qui_options' => 'alternativ',
	'smw_qui_addcategory' => 'lägg till kategori',
	'smw_qui_addrescol' => 'lägg till träffar',
	'smw_qui_ok' => 'OK',
	'smw_qui_cancel' => 'Avbryt',
	'smw_qui_category' => '<strong>Kategori</strong>',
	'smw_qui_label' => 'Etikett',
	'smw_prp_options' => 'Alternativ för egenskap',
	'smw_qui_catopts' => 'Alternativ för kategori',
	'smw_qui_mainlabopts' => 'Alternativ för resultat',
	'smw_qui_dlabel' => 'Etikett:',
	'smw_qui_dcategory' => 'Kategori:',
	'smw_qui_dcatyes' => 'Visa text när det finns en kategori:',
	'smw_qui_dcatno' => 'Visa text när kategori saknas:',
	'searchbyproperty' => 'Sökning per egenskap',
	'smw_sbv_docu' => 'Sök efter alla sidor som har en given egenskap och värde.',
	'smw_sbv_novalue' => 'Skriv in ett giltigt värde för egenskapen, eller visa alla egenskapsvärden för “$1.”',
	'smw_sbv_displayresult' => 'En lista över alla sidor som har egenskapen “$1” med värdet “$2”',
	'smw_sbv_displayresultfuzzy' => 'En lista över alla sidor som har egenskapen "$1" med värdet "$2".
Eftersom det bara finns ett fåtal resultat, visas även näraliggande värden.',
	'smw_sbv_property' => 'Egenskap:',
	'smw_sbv_value' => 'Värde:',
	'smw_sbv_submit' => 'Hitta resultat',
	'browse' => 'Bläddra igenom wikin',
	'smw_browselink' => 'Bläddra genom egenskaper',
	'smw_browse_article' => 'Skriv namnet på sidan du vill börja bläddra från.',
	'smw_browse_go' => 'Visa',
	'smw_browse_show_incoming' => 'visa egenskaper som länkar hit',
	'smw_browse_hide_incoming' => 'göm egenskaper som länkar hit',
	'smw_browse_no_outgoing' => 'Denna sida har inga egenskaper.',
	'smw_browse_no_incoming' => 'Inga egenskaper länkar till den här sidan.',
	'smw_inverse_label_default' => '$1 av',
	'smw_inverse_label_property' => 'Benämning på inverterad egenskap',
	'pageproperty' => 'Sidegenskapssökning',
	'smw_pp_docu' => 'Sök efter allt innehåll för en egenskap på en given sida.
Skriv in både en sida och en egenskap.',
	'smw_pp_from' => 'Från sida',
	'smw_pp_type' => 'Egenskap',
	'smw_pp_submit' => 'Hitta resultat',
	'smw_result_prev' => 'Föregående',
	'smw_result_next' => 'Nästa',
	'smw_result_results' => 'Resultat',
	'smw_result_noresults' => 'Beklagar, inga resultat.',
	'smwadmin' => 'Administratörsfunktioner för Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Lagringsmotorn har satts upp.',
	'smw_smwadmin_return' => 'Gå tillbaka till $1',
	'smw_smwadmin_updatestarted' => 'Nu har en ny process för att uppdatera semantiska data påbörjats.
Alla semantiska data kommer att återuppbyggas och repareras där så behövs.
Du kan följa processen på den här specialsidan.

Återgå till $1.',
	'smw_smwadmin_updatenotstarted' => 'Process för att uppdatera pågår.
Startar ingen ny process.

Återgå till $1.',
	'smw_smwadmin_updatestopped' => 'Alla uppdateringsprocesser har avslutats.

Återgå till $1.',
	'smw_smwadmin_updatenotstopped' => 'För att avsluta uppdaterings-processen måste du aktivera kryss-rutan.

Återgå till $1.',
	'smw_smwadmin_docu' => 'Denna specialsida hjälper dig under installation och uppgradering av <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Kom ihåg att ta backup på värdefulla data innan du kör administrativa funktioner.',
	'smw_smwadmin_db' => 'Databasinstallation och -uppgradering',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki behöver några tillägg till MediaWiki-databasen för att kunna lagra semantiska data.
Funktionen nedan ser till att din databas konfigureras korrekt.
Ändringarna som görs i detta steg påverkar inte resten av MediaWiki-databasen, och kan lätt göras ogjorda om så önskas.
Denna installationsfunktion kan köras flera gånger utan att orsaka någon skada, men det är nödvändigt att köra den en gång vid installation eller uppgradering.',
	'smw_smwadmin_permissionswarn' => "Om operationen misslyckas och visar SQL-fel så har din användare för databasen (kolla inställningarna i filen LocalSettings.php) förmodligen inte tillräckliga rättigheter.
Det finns tre sätt att åtgärda detta: Ge rättigheter till användaren att skapa och radera tabeller, ändra temporärt användaren till ''root'' i LocalSettings.php, eller använd underhålls-scriptet <tt>SMW_setup.php</tt>, vilken kan använda rättigheterna för en administratör.",
	'smw_smwadmin_dbbutton' => 'Initialisera eller uppgradera tabeller',
	'smw_smwadmin_announce' => 'Meddela att din wiki finns',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki har en webbtjänst för tillkännagivande av nya semantiska wiki-webbplatser.
Den används för att upprätthålla en lista över publika webbplatser som använder Semantic MediaWiki, huvudsakligen för att hjälpa <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki-projektet</a> att få överblick över typiska användningsområden av Semantic MediaWiki.
Se hemsidan för Semantic MediaWiki för <a href="http://semantic-mediawiki.org/wiki/Registry">mer information om denna tjänst</a>.',
	'smw_smwadmin_announcebutton' => 'Tryck på följande knapp för att skicka din wikis URL till den tjänsten.
Tjänsten registrerar inte wiki:er som inte är publikt åtkomliga, och den lagrar endast publikt åtkomlig information.',
	'smw_smwadmin_datarefresh' => 'Datareparation och -uppgradering',
	'smw_smwadmin_datarefreshdocu' => 'Det är möjligt att återställa all Semantic MediaWiki-data baserat på det aktuella innehållet för din wiki.
Detta kan vara användbart för att reparera eller fräscha upp data om det interna formatet har ändrats på grund av programuppdateringar.
Uppdateringen utförs sida för sida och blir inte klar omedelbart.
Det följande visar om en uppdatering pågår och tillåter dig att starta eller stoppa uppdateringar (såvida inte denna finess har stängts av av administratören).',
	'smw_smwadmin_datarefreshprogress' => '<strong>En uppdatering pågår redan.</strong>
Det är normalt att uppdateringen fortskrider långsamt, eftersom den endast uppdaterar data i små bitar åt gången varje gång en användare använder wikin.
För att avsluta uppdateringen snabbare, kan du köra MediaWiki-scriptet <tt>runJobs.php</tt> (använd valet <tt>--maxjobs 1000</tt>  för att begränsa antalet uppdateringar per körning).
Uppskattning av hur långt uppdateringen har kommit:',
	'smw_smwadmin_datarefreshbutton' => 'Starta uppdatering av data',
	'smw_smwadmin_datarefreshstop' => 'Stoppa denna uppdatering',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, jag är säker.',
	'smw_smwadmin_support' => 'Få support',
	'smw_smwadmin_supportdocu' => 'Flera resurser kan hjälpa dig om du får problem:',
	'smw_smwadmin_installfile' => 'Om du upplever problem med din installation så börja med att studera anvisningarna i filen <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Den kompletta användardokumentationen till Semantic MediaWiki finns på <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Fel kan rapporteras till <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Om du har ytterligare frågor eller förslag, gå med i diskussionen på  <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki användarforum</a>.',
	'smw_adminlinks_datastructure' => 'Datastruktur',
	'smw_adminlinks_displayingdata' => 'Visar data',
	'smw_adminlinks_inlinequerieshelp' => 'Hjälp för inbäddade frågor',
	'smw-createproperty-isproperty' => 'Det här är en egenskap av typen $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Det tillåtna värdet|De tillåtna värdena}} för den här egenskapen är:',
	'smw-paramdesc-category-delim' => 'Skiljetecken',
	'smw-paramdesc-category-template' => 'Mall att formatera resultatet med',
	'smw-paramdesc-category-userparam' => 'Parameter till mallen',
	'smw-info-par-message' => 'Meddelande att skriva ut.',
	'smw-info-par-icon' => 'Ikon att visa, antingen "info" eller "warning".',
	'prefs-smw' => 'Semantisk MediaWiki',
	'prefs-ask-options' => 'Alternativ för semantisk sökning',
	'smw-prefs-intro-text' => 'Alternativen här nedanför är hämtade från [http://semantic-mediawiki.org/ Semantic MediaWiki] (eller andra semantiska tillägg) i syfte att möjliggöra inställningar för utvalda funktioner. Ytterligare information finns här: [http://semantic-mediawiki.org/wiki/Help:User_preferences help section].',
	'smw-prefs-ask-options-tooltip-display' => 'Visa parameterns text som informationsruta',
	'smw-prefs-ask-options-collapsed-default' => 'Gör så att alternativ-rutan är ihopfälld som standard',
	'smw-ui-tooltip-title-property' => 'Egenskap',
	'smw-ui-tooltip-title-quantity' => 'Mängd',
	'smw-ui-tooltip-title-info' => 'Information',
	'smw-ui-tooltip-title-service' => 'Service-länkar',
	'smw-ui-tooltip-title-warning' => 'Fel',
	'smw-ui-tooltip-title-parameter' => 'Parameter',
	'smw-ui-tooltip-title-event' => 'Händelse',
	'smw_unknowntype' => 'Felaktig parametertyp',
);

/** Tamil (தமிழ்)
 * @author Karthi.dr
 * @author Logicwiki
 * @author Shanmugamp7
 * @author TRYPPN
 */
$messages['ta'] = array(
	'smw_printername_list' => 'பட்டியல்',
	'smw_printername_table' => 'பட்டியல்',
	'smw_printername_template' => 'வார்ப்புரு',
	'smw_printername_category' => 'பகுப்பு',
	'properties' => 'பண்புகள்',
	'smw_ask_ascorder' => 'ஏறுவரிசை',
	'smw_ask_descorder' => 'இறங்குவரிசை',
	'smw_ask_submit' => 'முடிவுகளைத் தேடு',
	'smw_ask_defaultformat' => 'பொதுவானது',
	'smw_ask_otheroptions' => 'மற்ற விருப்பத்தேர்வுகள்',
	'smw_qui_ascorder' => 'ஏறுவரிசை',
	'smw_qui_descorder' => 'இறங்குவரிசை',
	'smw_qui_randorder' => 'ஏதாவதொன்று',
	'smw_qui_addnprop' => 'உடமையைச் சேர்',
	'smw_qui_delete' => 'நீக்குக',
	'smw_qui_options' => 'விருப்பத்தேர்வுகள்',
	'smw_qui_addcategory' => ' பகுப்பைச் சேர்க்கவும்',
	'smw_qui_ok' => 'சரி',
	'smw_qui_cancel' => 'ரத்து செய்',
	'smw_qui_category' => '<strong>பகுப்பு</strong>',
	'smw_qui_label' => 'சிட்டை',
	'smw_prp_options' => 'உடமை விருப்பத்தேர்வுகள்',
	'smw_qui_catopts' => 'பகுப்பு விருப்பத்தேர்வுகள்',
	'smw_qui_mainlabopts' => 'முடிவு விருப்பத்தேர்வுகள்',
	'smw_qui_dlabel' => 'சிட்டை:',
	'smw_qui_dcategory' => 'பகுப்பு:',
	'smw_sbv_property' => 'உடமை:',
	'smw_sbv_value' => 'மதிப்பு:',
	'smw_sbv_submit' => 'முடிவுகளைத் தேடு',
	'browse' => 'விக்கியில் உலாவு',
	'smw_browselink' => 'உடமைகளில் உலாவு',
	'smw_browse_article' => 'உலாவ ஆரம்பிக்க விரும்பும் பக்கத்தின் பெயரை உள்ளிடவும்.',
	'smw_browse_go' => 'செல்',
	'smw_browse_show_incoming' => 'இங்கு இணைக்கப்பட்டுள்ள உடமைகளைக் காண்பிக்கவும்',
	'smw_browse_hide_incoming' => 'இங்கு இணைக்கப்பட்டுள்ள உடமைகளைக் மறைக்கவும்',
	'smw_browse_no_outgoing' => 'இந்தப் பக்கத்திற்கு உடமைகள் ஏதுமில்லை.',
	'smw_browse_no_incoming' => 'இந்தப் பக்கத்திற்கு உடமைகள் ஏதும் இணைக்கப்படவில்லை.',
	'smw_pp_from' => 'பக்கத்திலிருந்து',
	'smw_pp_type' => 'உடமை',
	'smw_pp_submit' => 'முடிவுகளைத் தேடு',
	'smw_result_prev' => 'முந்தைய',
	'smw_result_next' => 'அடுத்து',
	'smw_result_results' => 'முடிவுகள்',
	'smw_result_noresults' => 'முடிவுகள் ஏதுமில்லை.',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'smw_finallistconjunct' => ', మరియు',
	'smw_factbox_head' => '$1 గురించి వాస్తవాలు',
	'smw_isspecprop' => 'ఈ లక్షణం ఈ వికీలో ప్రత్యేకం',
	'smw_concept_description' => '"$1" భావన యొక్క వివరణ',
	'smw_printername_list' => 'జాబితా',
	'smw_printername_table' => 'పట్టిక',
	'smw_printername_template' => 'మూస',
	'smw_printername_category' => 'వర్గం',
	'smw-paramdesc-embedonly' => 'శీర్షికలను చూపించకు',
	'smw_iq_moreresults' => '… మరిన్ని ఫలితాలు',
	'smw_parseerror' => 'ఇచ్చిన విలువ అర్థం కాలేదు.',
	'smw_notitle' => '"$1"ని ఈ వికీలో పేజీ పేరుగా ఉపయోగించలేరు.',
	'smw_wrong_namespace' => '"$1" అనే పేరుబరితో ఉన్న పేజీలను మాత్రమే ఇక్కడ అనుమతిస్తాం.',
	'smw_emptystring' => 'ఖాళీ పదాలను అనుమతించం.',
	'smw_true_words' => 'true,t,yes,y,అవును,సత్యం',
	'smw_false_words' => 'false,f,no,n,కాదు,అసత్యం',
	'smw_nofloat' => '“$1” అనేది సంఖ్య కాదు.',
	'smw_nodatetime' => '"$1" అనే తేదీ ఏమిటో అర్థంకాలేదు.',
	'smw_type_header' => '"$1" రకపు లక్షణాలు',
	'smw_typearticlecount' => 'ఈ రకాన్ని వాడుతున్న $1 {{PLURAL:$1|లక్షణాన్ని|లక్షణాలని}} చూపిస్తున్నాం.',
	'smw_attribute_header' => '"$1" లక్షణాన్ని వాడుతున్న పేజీలు',
	'smw_attributearticlecount' => 'ఈ లక్షణాన్ని వాడుతున్న $1 {{PLURAL:$1|పేజీని|పేజీలను}} చూపిస్తున్నాం.',
	'smw_subproperty_header' => 'ఉపలక్షణాలు',
	'smw_exportrdf_submit' => 'ఎగుమతించు',
	'properties' => 'లక్షణాలు',
	'smw_properties_docu' => 'ఈ వికీలో ఈ క్రింది లక్షణాలను ఉపయోగించారు.',
	'smw_property_template' => '$2 రకం యొక్క $1 ($3)',
	'unusedproperties' => 'ఉపయోగించని లక్షణాలు',
	'smw_unusedproperties_docu' => 'ఈ క్రింది లక్షణాలు ఉన్నా వాటిని పేజీలలోనూ వాడలేదు.',
	'smw_unusedproperty_template' => '$2 రకం యొక్క $1',
	'wantedproperties' => 'కావాల్సిన లక్షణాలు',
	'smw_wantedproperties_docu' => 'ఈ క్రింది లక్షణాలను ఈ వికీలో ఉపయోగించారు కానీ ఇంకా వాటి గురించి వివరించే పేజీలేమీ లేవు.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|వాడుక|వాడుకలు}})',
	'types' => 'రకాలు',
	'smw_ask_ascorder' => 'ఆరోహణ',
	'smw_ask_descorder' => 'అవరోహణ',
	'smw_ask_printhead' => 'చూపించాల్సిన అదనపు భోగట్టా',
	'smw_ask_defaultformat' => 'అప్రమేయం',
	'smw_ask_otheroptions' => 'ఇతర ఎంపికలు',
	'smw_qc_otheropt' => 'ఇతర ఎంపికలు',
	'smw_qc_default' => 'అప్రమేయం:',
	'smw_qui_ok' => 'సరే',
	'smw_qui_cancel' => 'రద్దుచేయి',
	'smw_qui_category' => '<strong>వర్గం</strong>',
	'smw_qui_catopts' => 'వర్గాల ఎంపికలు',
	'smw_qui_mainlabopts' => 'ఫలితాల ఎంపికలు',
	'smw_qui_dcategory' => 'వర్గం:',
	'smw_sbv_property' => 'లక్షణం:',
	'smw_sbv_value' => 'విలువ:',
	'smw_browse_go' => 'వెళ్ళు',
	'smw_browse_no_outgoing' => 'ఈ పేజీలో లక్షణాలేమీ లేవు.',
	'smw_browse_no_incoming' => 'ఈ పేజీకి లంకె వేస్తున్న లక్షణాలేమీ లేవు.',
	'smw_pp_from' => 'పేజీ నుండి',
	'smw_pp_type' => 'లక్షణం',
	'smw_result_prev' => 'గత',
	'smw_result_next' => 'తదుపరి',
	'smw_result_results' => 'ఫలితాలు',
	'smw_result_noresults' => 'ఫలితాలేమీ లేవు.',
	'smw_smwadmin_db' => 'డాటాబేసు స్థాపన మరియు నవీకరణ',
	'smw_smwadmin_announce' => 'మీ వికీని ప్రకటించండి',
	'smw_smwadmin_datarefreshbutton' => 'భోగట్టాని తాజాకరించడం ఆపివేయి',
	'smw_smwadmin_support' => 'తోడ్పాటుని పొందడం',
);

/** Tetum (tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'smw_true_words' => 'loos,l,sin,s',
	'smw_false_words' => 'sala,s,lae,la',
	'smw_result_prev' => 'Molok',
	'smw_result_next' => 'Oinmai',
);

/** Tajik (Cyrillic script) (тоҷикӣ)
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'smw_sbv_value' => 'Қимат', # Fuzzy
	'smw-createproperty-isproperty' => 'Ин як вижагӣ аз навъи $1 аст.',
);

/** Tajik (Latin script) (tojikī)
 */
$messages['tg-latn'] = array(
	'smw-createproperty-isproperty' => "In jak viƶagī az nav'i $1 ast.",
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'smw_browse_go' => 'Git',
	'smw_result_prev' => 'Öňki',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'smw-desc' => "Ginagawang mas napupuntahan ang wiki mo - para sa ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentasyon habang nasa Internet]) ng mga makina ''at'' mga tao",
	'smw_viewasrdf' => 'Pasubo/pakaing RDF',
	'smw_finallistconjunct' => ', at',
	'smw_factbox_head' => 'Totoong mga bagay hinggil sa $1',
	'smw_isspecprop' => 'Ang pag-aaring ito ay isang natatanging pag-aari sa wiking ito.',
	'smw_concept_description' => 'Paglalarawan ng diwa/konseptong "$1"',
	'smw_no_concept_namespace' => 'Mabibigyang kahulugan lamang ang mga diwa (konsepto) sa ibabaw ng mga pahinang nasa loob ng Diwa: espasyo ng pangalan.',
	'smw_multiple_concepts' => 'Magkakaroon lamang ng isang kahulugang pangkonsepto ang bawat isang pahina ng diwa.',
	'smw_concept_cache_miss' => 'Hindi magagamit sa sandaling ito ang diwang "$1", dahil sa kinakailangan ng pagkakaayos ng wiki na tuusin ito habang hindi nakaugnay sa internet.
Kapag hindi nawala/naalis ang suliranin makalipas ang ilang panahon, pakihiling sa iyong tagapangasiwa na gawing makukuha ang diwang ito.',
	'smw_noinvannot' => 'Ang mga halaga ay hindi maitatalaga sa mga katangiang pabaligtad.',
	'version-semantic' => 'Mga dugtong na semantiko',
	'smw_baduri' => 'Hindi pinapahintulutan ang mga URI ng pormularyong "$1".',
	'smw_rss_link' => 'RSS',
	'smw_csv_link' => 'CSV',
	'smw_dsv_link' => 'DSV',
	'smw_json_link' => 'JSON',
	'smw_rdf_link' => 'RDF',
	'smw_printername_count' => 'Bilangin ang mga kinalabasan',
	'smw_printername_csv' => 'Luwas ng CSV',
	'smw_printername_dsv' => 'Pagluluwas ng DSV',
	'smw_printername_debug' => 'Tanggalan ng depekto ang tanong (para sa mga dalubhasa)',
	'smw_printername_embedded' => 'Ibaon ang mga nilalaman ng pahina',
	'smw_printername_json' => 'Luwas ng JSON',
	'smw_printername_list' => 'Talaan',
	'smw_printername_ol' => 'Pagtatala',
	'smw_printername_ul' => 'Pag-iisa-isa',
	'smw_printername_rss' => 'Luwas ng RSS',
	'smw_printername_table' => 'Tabla',
	'smw_printername_broadtable' => 'Malawak na tabla',
	'smw_printername_template' => 'Suleras',
	'smw_printername_rdf' => 'Angkat ng RDF',
	'smw_printername_category' => 'Kategorya',
	'smw-paramdesc-limit' => 'Ang pinakamataas na bilang ng mga resultang ibabalik',
	'smw-paramdesc-offset' => 'Ang timbang na pambalanse ng unang resulta',
	'smw-paramdesc-headers' => 'Ipakita ang mga pangalan ng paulo/katangiang-ari',
	'smw-paramdesc-mainlabel' => 'Ang tatak na ibibigay sa pangalan ng pangunahing pahina',
	'smw-paramdesc-link' => 'Ipakita ang mga halaga bilang mga kawing',
	'smw-paramdesc-intro' => 'Ang tekstong ipapakita bago ang mga resulta ng pagtatanong, kung mayroon',
	'smw-paramdesc-outro' => 'Ang tekstong ipapakita pagkaraan ng mga resulta ng pagtatanong, kung mayroon',
	'smw-paramdesc-default' => 'Ang tekstong ipapakita kung walang mga resulta ng pagtatanong',
	'smw-paramdesc-sep' => 'Ang panghiwalay ng mga halaga',
	'smw-paramdesc-distribution' => 'Sa halip na ipakita ang lahat ng mga halaga, bilangin ang pagsipot ng mga ito, at ipakita ang mga ito.',
	'smw-paramdesc-distributionsort' => 'Iayos ang pamumudmod ng halaga ayon sa bilang ng pagsipot.',
	'smw-paramdesc-distributionlimit' => 'Hanggahan ang pamumudmod ng halaga sa bilang ng ilang mga halaga lamang.',
	'smw-paramdesc-template' => 'Ang pangalan ng isang suleras kung saan ipapakita ang mga inilimbag',
	'smw-paramdesc-columns' => 'Ang bilang ng mga haligi kung saan ipapakita ang mga resulta (likas na nakatakda ang $1)',
	'smw-paramdesc-userparam' => 'Isang halagang pinadaraan papasok sa bawat pagtawag ng suleras, kapag ginamit ang isang suleras',
	'smw-paramdesc-introtemplate' => 'Ang pangalan ng isang suleras na ipapakita bago ang mga resulta ng pagtatanong, kung mayroon',
	'smw-paramdesc-outrotemplate' => 'Ang suleras na ipapakita pagkaraan ng mga resulta ng pagtatanong, kung mayroon',
	'smw-paramdesc-embedformat' => 'Ang ginagamit na tatak ng HTML upang ilarawan ang mga paulo',
	'smw-paramdesc-embedonly' => 'Huwag magpakita ng mga paulo',
	'smw-paramdesc-table-class' => 'Isang karagdagang klase ng Mga Pilas ng Estilong Lumalagaslas na itatalaga para sa talahanayan',
	'smw-paramdesc-rsstitle' => 'Ang tekstong gagamitin bilang pamagat ng pakain',
	'smw-paramdesc-rssdescription' => 'Ang tekstong gagamitin bilang paglalarawan ng pakain',
	'smw-paramdesc-rdfsyntax' => 'Ang gagamiting palaugnayan ng RDF',
	'smw-paramdesc-csv-sep' => 'Ang panghiwalay na gagamitin',
	'smw-paramdesc-dsv-separator' => 'Ang panghiwalay na gagamitin',
	'smw-paramdesc-dsv-filename' => 'Ang pangalan para sa talaksan ng DSV',
	'smw-smwdoc-description' => 'Nagpapakita ng isang talahanayan ng lahat ng mga parametro na magagamit para sa tinukoy na kaanyuan ng resulta na kasama ang likas na nakatakdang mga halaga at mga paglalarawan.',
	'smw-smwdoc-par-format' => 'Ang kaanyuan ng resulta na pagpapakitaan ng kasulatan ng parametro.',
	'smw-smwdoc-par-parameters' => 'Kung aling mga parametro ang ipapakita. "specific" para sa mga idinagdag ayon sa kaanyuan, "base" para sa mga makukuha na nasa lahat ng mga kaanyuan, at "all" para sa dalawang mga ito.',
	'smw-paramdesc-sort' => 'Kaarian na pag-aayusan ng pag-uusisa',
	'smw-paramdesc-order' => 'Pagkakasunud-sunod ng pagkakaayos ng pag-uusisa',
	'smw-paramdesc-searchlabel' => 'Tekstong para sa pagpapatuloy ng paghahanap',
	'smw-paramdesc-named_args' => 'Pangalanan ang mga pangangatwiran na ipinasang papunta sa suleras',
	'smw-paramdesc-export' => 'Mapagpipilian ng pag-angkat',
	'smw-paramdesc-prettyprint' => 'Isang kalalabasang maganda ang pagkakalimbag na nagpapakita ng karagdagang mga pag-urong at bagong mga guhit',
	'smw-paramdesc-source' => 'Panghaliling pinagmulan ng pag-uusisa',
	'smw-paramdesc-jsonsyntax' => 'Gagamiting palaugnayan ng JSON',
	'smw_iq_disabled' => 'Hindi pinagana ang mga katanungang hinggil sa kahulugan ng salita (semantiko) para sa wiking ito.',
	'smw_iq_moreresults' => '… karagdagang mga resulta/kinalabasan',
	'smw_parseerror' => 'Hindi naunawaan ang ibinigay na halaga.',
	'smw_decseparator' => '.',
	'smw_kiloseparator' => ',',
	'smw_notitle' => 'Hindi magagamit sa loob ng wiking ito ang "$1" bilang isang pangalan ng pahina.',
	'smw_noproperty' => 'Hindi magagamit sa loob ng wiking ito ang "$1" bilang isang pangalan ng pag-aari.',
	'smw_wrong_namespace' => 'Tanging mga pahinang nasa espasyo ng pangalang "$1" ang pinapahintulutan dito.',
	'smw_manytypes' => 'Mahigit sa isang uri ang binigyang kahulugan para sa pag-aari.',
	'smw_emptystring' => 'Hindi tinatanggap ang mga bagting na walang laman.',
	'smw_maxstring' => 'Napakahaba ng kumakatawan para sa bagting na $1.',
	'smw_notinenum' => 'Ang "$1" ay wala sa loob ng talaan ng maaaring maging mga halaga ($2) para sa pag-aaring ito.',
	'smw_noboolean' => "Ang \"\$1\" ay hindi kinikilala bilang isang halaga ng ''Boolean'' (tama/mali).",
	'smw_true_words' => 'totoo,t,oo,o',
	'smw_false_words' => 'mali,m,hindi,h',
	'smw_nofloat' => 'Hindi isang bilang ang "$1".',
	'smw_infinite' => 'Hindi tinatangkilik ang mga bilang na kasinlaki ng "$1".',
	'smw_unitnotallowed' => 'Ang "$1" ay hindi ipinahayag bilang isang katanggap-tanggap na yunit ng pagsukat para sa pag-aaring ito.',
	'smw_nounitsdeclared' => 'Walang ipinahayag na mga yunit ng sukat para sa pag-aaring ito.',
	'smw_novalues' => 'Walang tinukoy na mga halaga.',
	'smw_nodatetime' => 'Hindi naunawaan ang petsang "$1".',
	'smw_toomanyclosing' => 'Tila mayroong napakaraming mga kaganapan ng "$1" sa loob ng katanungan.',
	'smw_noclosingbrackets' => 'Ilang mga paggamit ng "<nowiki>[[</nowiki>" sa loob ng iyong katanungan ang hindi naisara sa pamamagitan ng isang tumutugmang "]]".',
	'smw_misplacedsymbol' => 'Ginamit ang sagisag na "$1" sa loob ng isang pook na hindi naman ito magagamit (walang pakinabang).',
	'smw_unexpectedpart' => 'Hindi naunawaan ang bahaging "$1" ng katanungan.
Maaaring hindi inaasahan ang magiging mga kinalabasan.',
	'smw_emptysubquery' => 'Walang tanggap na kalagayan (kalakaran) ang kabahaging katanungan.',
	'smw_misplacedsubquery' => 'Hindi ginamit ang ilang kabahaging mga katanungan sa loob ng isang pook kung saan hindi pinapahintulutan ang mga kabahaging katanungan.',
	'smw_valuesubquery' => 'Hindi tinatangkilik ang kabahaging mga katanungan para sa mga halaga ng pag-aaring "$1".',
	'smw_badqueryatom' => 'Hindi naunawaan ang ilang bahaging "<nowiki>[[…]]</nowiki>" ng katanungan.',
	'smw_propvalueproblem' => 'Hindi naunawaan ang halaga ng pag-aaring "$1".',
	'smw_noqueryfeature' => 'Ilang katangiang-kasangkapan ng katanungan ay hindi tinatangkilik sa wiking ito at inilaglag na ang bahagi ng katanungan ($1).',
	'smw_noconjunctions' => 'Hindi tinatangkilik sa wiking ito ang mga pangatnig at inilaglag na ang bahagi ng katanungan ($1).',
	'smw_nodisjunctions' => 'Hindi tinatangkilik sa wiking ito ang pagkakakalas-kalas sa mga katanungan at inilaglag na ang bahgi ng katanungan ($1).',
	'smw_querytoolarge' => 'Hindi maisasaalang-alang ang sumusunod na mga kalagayan ng katanungan dahil sa mga hangganan ng mga wiki sa sukat o lalim ng katanungan: $1.',
	'smw_notemplategiven' => 'Magbigay ng isang halaga para sa parametrong "suleras" upang gumana/maganap ang ganitong anyo/pormat ng katanungan.',
	'smw_db_sparqlqueryproblem' => 'Ang resulta ng pagsisiyasat ay hindi makamtan mula sa kalipunan ng dato ng SPARQL. Ang kamaliang ito ay maaaring pansamantala o nagpapahiwatig ng isang depekto sa loob ng sopwer ng kalipunan ng dato.',
	'smw_db_sparqlqueryincomplete' => 'Ang pagsagot sa pagsisiyasat ay lumitaw na napakahirap at pinaglubay. Maaaring nawawala ang ilang mga resulta. Kung maaari, sa halip ay subukang gumamit ng isang mas payak na pagsisiyasat.',
	'smw_type_header' => 'Mga pag-aari ng uring "$1"',
	'smw_typearticlecount' => 'Nagpapakita ng $1 na {{PLURAL:$1|pag-aari|mga pag-aari}}ng ginagamitan ng ganitong uri.',
	'smw_attribute_header' => 'Mga pahinang gumagamit na pag-aaring "$1"',
	'smw_attributearticlecount' => 'Nagpapakita ng $1 {{PLURAL:$1|pahina|mga pahina}}ng ginagamitan ng ganitong ari-arian.',
	'smw_subproperty_header' => 'Kabahaging mga pag-aari',
	'smw_subpropertyarticlecount' => 'Ang pag-aaring ito ay mayroong sumusunod na $1 {{PLURAL:$1|kabahaging ari-arian|kabahaging mga ari-arian}}:',
	'smw_concept_header' => 'Mga pahina ng diwang "$1"',
	'smw_conceptarticlecount' => 'Nagpapakita ng $1 {{PLURAL:$1|pahina|mga pahina}}ng kasali sa ganyang diwa.',
	'smw_rss_description' => '$1 pakain na RSS',
	'specialpages-group-smw_group' => 'Semantikong MediaWiki',
	'exportrdf' => 'Iluwas/Ipadala ang mga pahina patungo sa RDF',
	'smw_exportrdf_docu' => 'Ipinapahintulot ng pahinang ito na makakuha ka ng dato mula sa isang pahinang nasa anyong RDF.
Upang makapagluwas ng mga pahina, ipasok ang mga pamagat sa loob ng kahong pangtekstong nasa ibaba, isang pamagat bawat guhit/hanay.',
	'smw_exportrdf_recursive' => 'Tumatawag sa sarili na angkatin ang lahat ng kaugnay na mga pahina.
Tandaan lamang na maaaring malaki ang kinalabasan/resulta!',
	'smw_exportrdf_backlinks' => 'Nagluluwas din ng lahat ng mga pahinang tumutukoy sa iniluwas na mga pahina.
Gumagawa ng matitingnan-tingnang RDF.',
	'smw_exportrdf_lastdate' => 'Huwag iluwas ang mga pahinang hindi nabago mula sa isang ibinigay na sandali sa loob ng panahon/oras.',
	'smw_exportrdf_submit' => 'Iluwas',
	'uriresolver' => 'tagalutas ng URI',
	'properties' => 'Mga pag-aari',
	'smw_properties_docu' => 'Ginagamit sa wiki ang sumusunod na mga pahina ng pag-aari.',
	'smw_property_template' => '$1 ng uring $2 ($3)',
	'smw_property_template_notype' => '$1 ($2)',
	'smw_propertylackspage' => 'Lahat ng mga pag-aari ay dapat na nilalarawan ng isang pahina!',
	'smw_propertylackstype' => 'Walang uring tinukoy para sa pag-aaring ito (ipapalagay na nasa uring $1 muna sa ngayon).',
	'smw_propertyhardlyused' => 'Madalang gamitin ang ganitong pag-aari sa loob ng wiking ito!',
	'unusedproperties' => 'Mga pag-aaring hindi pa nagagamit',
	'smw_unusedproperties_docu' => 'Umiiral ang sumusunod na mga pag-aari bagaman wala namang ibang pahinang gumagamit ng mga ito.',
	'smw_unusedproperty_template' => '$1 ng uring $2',
	'wantedproperties' => 'Ninanais na mga ari-arian',
	'smw_wantedproperties_docu' => 'Ginagamit sa loob ng wiki ang sumusunod na mga pag-aari ngunit wala pang isang pahinang naglalarawan sa kanila.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|gamit|mga gamit}})',
	'smw_purge' => 'Sariwain',
	'types' => 'Mga uri',
	'smw_types_docu' => 'Ang sumusunod ay isang talaan ng lahat ng mga uri ng dato na maaaring italaga sa mga pag-aari.',
	'semanticstatistics' => 'Mga estadistika ng Semantiko (hinggil sa kahulugan ng mga salita)',
	'smw_semstats_text' => "Naglalaman ang wiking ito ng '''$1''' {{PLURAL:$1|halaga|mga halaga}} ng ari-ariang may kabuoang '''$2''' [[Special:Properties|{{PLURAL:$2|ari-arian|iba't ibang ari-arian}}]].
'''$3''' {{PLURAL:$3|pag-aari ang may|mga pag-aari ang may mga}} sariling pahina na, at ang inilalaang uri ng dato ay tinukoy para sa '''$4''' ng mga iyon.
Ilan sa umiiral na mga ari-arian ay maaaring [[Special:UnusedProperties|hindi ginagamit na mga pag-aari]].
Ang mga ari-ariang wala pa ring isang pahina ay matatagpuan sa [[Special:WantedProperties|talaan ng ninanais na mga pag-aari]].",
	'smw_uri_doc' => 'Ipinatutupad ng tagapaglutas na URI ang <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">Paghahanap ng W3C TAG sa httpRange-14</a>.
Pinag-iingatan nitong huwag maging mga sityo ng web (websayt) ang mga tao.',
	'ask' => 'Paghahanap hinggil sa kahulugan ng mga salita (semantiko)',
	'smw_ask_sortby' => 'Pagpangkat-pangkating ayon sa pahabang kahanayan (maaaring wala nito)',
	'smw_ask_ascorder' => 'Tumataas',
	'smw_ask_descorder' => 'Bumababa',
	'smw_ask_submit' => 'Hanapin ang mga kinalabasan/resulta',
	'smw_ask_editquery' => '[Baguhin ang katanungan]',
	'smw_add_sortcondition' => '[Idagdag ang kalagayang pampagpapangkat-pangkat]',
	'smw_ask_hidequery' => 'Itago ang katanungan',
	'smw_ask_help' => 'Tulong sa pagtatanong',
	'smw_ask_queryhead' => 'Katanungan',
	'smw_ask_printhead' => 'Karagdagang mga datong ipapakita',
	'smw_ask_printdesc' => '(magdagdag ng isang pangalan ng ari-arian sa bawat guhit)',
	'smw_ask_format_as' => 'Iayos bilang:',
	'smw_ask_defaultformat' => 'likas na katakdaan',
	'smw_ask_otheroptions' => 'Iba pang mga mapagpipilian',
	'smw-ask-otheroptions-info' => 'Ang seksiyong ito ay naglalaman ng mga mapagpipilian na nakapagpapabago sa mga pahayag ng nakalimbag na kinalabasan. Ang mga paglalarawan ng paraemetro ay maaaring tingnan sa pamamagitan ng pag-aligid sa ibabaw ng mga ito.',
	'smw-ask-otheroptions-collapsed-info' => 'Paki gamitin ang kinatawang larawan ng pagdaragdag upang makita ang lahat ng makukuhang mga mapagpipilian',
	'smw_ask_show_embed' => 'Ipakita ang kodigong pambaon',
	'smw_ask_hide_embed' => 'Ibaong nakakubli ang kodigo',
	'smw_ask_embed_instr' => 'Upang maibaon ang katanungang ito sa loob ng guhit papasok sa isang pahina ng wiki, gamitin ang kodigong nasa ibaba.',
	'smw-ask-delete' => '[Burahin]',
	'smw-ask-sorting' => 'Pagbubukud-bukod',
	'querycreator' => 'Tagapaglikha ng Pagsisiyasat',
	'smw_qc_addmainlabel' => 'Idagdag ang pangunahing katatakan',
	'smw_qc_show_addnal_opts' => 'Magpakita ng mas marami pang mapagpipilian',
	'smw_qc_hide_addnal_opts' => 'Magpakita ng mas kakaunting mga mapagpipilian',
	'smw_qc_otheropt' => 'Iba pang mga mapagpipilian',
	'smw_qc_intro' => 'Pagpapakilala:',
	'smw_qc_outro' => 'Pagtatapos:',
	'smw_qc_default' => 'Likas na katakdaan:',
	'smw_qc_formatopt' => 'Mga mapagpipilian ng kaanyuan',
	'smw_qc_query_help' => 'Magpasok ng isang pagsisiyasat na ginagamit ang pormularyong nasa ibaba. Pumili ng mga pahina ng wiki na naaayon sa 
Mga kategorya (<strong><nowiki>halimbawa [[Kategorya:Aktor]]</nowiki></strong>),
Mga pag-aari (<strong><nowiki>halimbawa [[Nasa::Alemanya]]</nowiki></strong>),
Mga pangalan(<strong><nowiki>halimbawa [[Alemanya]]</nowiki></strong>) and
Mga puwang ng pangalan (<strong><nowiki>halimbawa [[Tulong:+]]</nowiki></strong>)',
	'smw_qui_property' => '<strong>Ari-arian</strong>',
	'smw_qui_prop' => 'Ari-arian:',
	'smw_qui_labl' => 'Katatakan:',
	'smw_qui_formt' => 'Kaanyuan:',
	'smw_qui_limt' => 'Hangganan:',
	'smw_qui_shownresults' => 'ipakita sa mga resulta',
	'smw_qui_noquery' => 'Walang tinukoy na pag-uusisa',
	'smw_qui_invalidprop' => 'Ang "$1" ay maaaring hindi isang katanggap-tanggap na pag-aari',
	'smw_qui_invalidformat' => 'Ang napiling kaanyuang "$1" ay hindi umiiral para sa wiking ito',
	'smw_qui_nosort' => 'Walang pag-uuri-uri',
	'smw_qui_ascorder' => 'Tumataas',
	'smw_qui_descorder' => 'Bumababa',
	'smw_qui_randorder' => 'Alin man',
	'smw_qui_addnprop' => 'idagdag ang pag-aari',
	'smw_qui_delete' => 'Tanggalin',
	'smw_qui_rescol' => 'Mga pagtutugma sa pagsisiyasat',
	'smw_qui_options' => 'mga mapagpipilian',
	'smw_qui_addcategory' => 'idagdag ang kategorya',
	'smw_qui_addrescol' => 'idagdag ang mga pagtutugma ng pagsisiyasat',
	'smw_qui_ok' => 'Sige',
	'smw_qui_cancel' => 'Huwag ituloy',
	'smw_qui_category' => '<strong>Kategorya</strong>',
	'smw_qui_label' => 'Katatakan',
	'smw_prp_options' => 'Mga Mapagpipilian ng Kaarian',
	'smw_qui_catopts' => 'Mga Mapagpipilian ng Kategorya',
	'smw_qui_mainlabopts' => 'Mga Mapagpipilian ng Resulta',
	'smw_qui_dlabel' => 'Katatakan:',
	'smw_qui_dcategory' => 'Kategorya:',
	'smw_qui_dcatyes' => 'Ipakita ang teksto kapag nariyan ang kategorya:',
	'smw_qui_dcatno' => 'Ipakita ang teksto kapag wala ang kategorya:',
	'searchbyproperty' => 'Maghanap ayon sa pag-aari',
	'smw_sbv_docu' => 'Hanapin ang lahat ng mga pahinang may isang ibinigay na pag-aari at halaga.',
	'smw_sbv_novalue' => 'Maglagay/magpasok ng isang tanggap na halaga para sa pag-aari, o tingnan ang lahat ng mga halaga ng ari-arian para sa "$1".',
	'smw_sbv_displayresult' => 'Isang talaan ng lahat ng mga pahinang may pag-aaring "$1" na may halagang "$2"',
	'smw_sbv_displayresultfuzzy' => 'Isang talaan ng lahat ng mga pahinang may pag-aaring "$1" na may halagang "$2".
Dahil mayroong mangilan-ngilang mga kinalabasan lamang, ipinakikita rin ang kalapit na mga halaga.',
	'smw_sbv_property' => 'Pag-aari:',
	'smw_sbv_value' => 'Halaga:',
	'smw_sbv_submit' => 'Hanapin ang mga kinalabasan',
	'browse' => 'Tumingin-tingin sa wiki',
	'smw_browselink' => 'Tumingin-tingin sa mga pag-aari',
	'smw_browse_article' => 'Ipasok/ilagay ang pangalan ng pahinang pagsisimulan ng pagtingin-tingin.',
	'smw_browse_go' => 'Gawin na',
	'smw_browse_more' => '…',
	'smw_browse_show_incoming' => 'ipakita ang mga pag-aaring kumakawing (umuugnay) dito',
	'smw_browse_hide_incoming' => 'itago ang mga pag-aaring kumakawing (umuugnay) dito',
	'smw_browse_no_outgoing' => 'Walang mga pag-aari ang pahinang ito.',
	'smw_browse_no_incoming' => 'Walang mga pag-aaring nakakawing (umuugnay) patungo sa pahinang ito.',
	'smw_inverse_label_default' => '$1 ng',
	'smw_inverse_label_property' => 'Ibinaligtad na tatak ng pag-aari',
	'pageproperty' => 'Paghahanap sa pag-aari ng pahina',
	'smw_pp_docu' => 'Hanapin ang lahat ng mga pampuno ng isang pag-aari sa isang ibinigay na pahina.
Kapwa ipasok ang isang pahina at isang pag-aari.',
	'smw_pp_from' => 'Mula sa pahina',
	'smw_pp_type' => 'Pag-aari',
	'smw_pp_submit' => 'Hanapin ang mga resulta',
	'smw_result_prev' => 'Sinundan',
	'smw_result_next' => 'Susunod',
	'smw_result_results' => 'Mga kinalabasan (resulta)',
	'smw_result_noresults' => 'Walang mga kinalabasan/resulta.',
	'smwadmin' => 'Mga tungkulin ng tagapangasiwa para sa Semantikong MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Matagumpay na naihanda ang makina ng pagtatago.',
	'smw_smwadmin_return' => 'Magbalik sa $1',
	'smw_smwadmin_updatestarted' => 'Sinimulan ang isang bagong proseso ng pagsasapanahon para sa pagsasariwa ng datong semantiko.
Lahat ng nakatabing mga dato ay muling bubuuin o kukumpunihin kung saan kailangan.
Masusundan mo ang pagsulong ng pagsasapanahon sa natatanging pahinang ito.

Bumalik sa $1.',
	'smw_smwadmin_updatenotstarted' => 'Mayroon nang isang tumatakbong proseso ng pagsasapanahon.
Hindi na lilikha ng isa pa.

Bumalik sa $1.',
	'smw_smwadmin_updatestopped' => 'Inihinto ang lahat ng umiiral na mga proseso ng pagsasapanahon.

Bumalik sa $1.',
	'smw_smwadmin_updatenotstopped' => 'Upang mapahinto ang tumatakbong proseso ng pagsasapanahon, dapat mong pasiglahin ang kahong lagayan ng tsek upang maipahiwatig na talagang nakatitiyak ka.

Bumalik sa $1.',
	'smw_smwadmin_docu' => 'Tumutulong ang natatanging pahinang ito sa iyo sa panahon ng pagluluklok at pagtataas ng uri ng <a href="http://semantic-mediawiki.org">Semantikong MediaWiki</a>.
Huwag kalimutang gumawa ng karagdagang sipi ng mahalagang dato bago isagawa ang mga tungkuling pangtagapangasiwa.',
	'smw_smwadmin_db' => 'Pagluluklok (instalasyon) at pagtataas ng uri (grado/klase) ng kalipunan ng dato',
	'smw_smwadmin_dbdocu' => 'Nangangailangan ang Semantikong Mediawiki ng ilang mga karugtong sa kalipunan ng dato ng MediaWiki upang maitabi ang datong hinggil sa kahulugan ng mga salita.
Tinitiyak ng tungkuling nasa ibaba na tama ang pagkakahanda ng kalipunan ng dato mo.
Hindi nakakaapekto ang mga pagbabagong ginawa sa hakbang na ito sa iba pang mga bahagi ng kalipunan ng dato ng MediaWiki, at madaling/maginhawang maibabalik kung nanaisin.
Maaaring isagawa ng maramihang ulit ang tungkulin ng paghahandang ito na hindi nakapagdurulot ng anumang pinsala, subalit isang ulit lamang itong kailangan sa pagluluklok/instalasyon o pagtataas ng uri/grado.',
	'smw_smwadmin_permissionswarn' => 'Kapag nabigo ang pagsasagawa na mayroong mga kamalian ng SQL, maaaring walang sapat na mga kapahintulutan ang tagagamit ng kalipunan ng dato na hinirang ng wiki mo (siyasatin ang iyong LocalSettings.php).
Maaaring pagkalooban ang tagagamit na ito ng karagdagang mga kapahintulutan upang makalikha at makapagbura ng mga talahanayan, pansamantalang ipasok ang panglagda ng iyong ugat ng kalipunan ng dato sa LocalSettings.php, o gamitin ang panitik ng pagpapanatili na <tt>SMW_setup.php</tt> na makakagamit ng mga kredensiyal ng isang tagapangasiwa.',
	'smw_smwadmin_dbbutton' => 'Umpisahan o itaas ang uri (klase) ng mga tabla',
	'smw_smwadmin_announce' => 'Ipahayag ang wiki mo',
	'smw_smwadmin_announcedocu' => 'Ang Semantikong Mediawiki ay mayroong isang palingkurang pangweb para sa pagpapahayag ng bagong mga sayt ng bagong wiking semantiko (hinggil sa kahulugan ng mga salita).
Ginagamit ito upang makapagpanatili ng isang talaan ng mga sityong pangmadala/pampublikong gumagamit ng Semantikong MediaWiki, pangunahin na upang tulungan ang <a href="http://semantic-mediawiki.org/wiki/SMW_Project">proyektong Semantikong MediaWiki</a> upang makakuha ng pang-ibabaw/pangunahing paglalarawan ng karaniwang mga paggamit ng Semantikong MediaWiki.
Tingnan ang tahanang pahina ng Semantikong MediaWiki para sa <a href="http://semantic-mediawiki.org/wiki/Registry">karagdagan pang kabatiran hinggil sa serbisyong ito</a>.',
	'smw_smwadmin_announcebutton' => 'Pindutin ang sumusunod na pindutan upang maipasa/maipadala ang URL mong pangwiki patungo sa palingkurang iyan.
Hindi itatala ng palingkuran ang mga wiki na hindi mapupuntahan ng madla, at itatago lamang nito ang kabatiran napupuntahan ng publiko.',
	'smw_smwadmin_datarefresh' => 'Pagkukumpuni at pagtataas ng uri (grado/klase) ng dato',
	'smw_smwadmin_datarefreshdocu' => 'Maaaring maibalik muli ang lahat ng dato ng Semantikong MediaWiki batay sa pangkasalukuyang mga nilalaman ng wiki.
Magiging gamitin ito sa pagaayos/pagkukumpuni ng nasirang dato o upang masariwa ang dato kung nabago ang panloob na kaanyuan/pormat dahil sa ilang mga pagtataas ng uri ng sopwer.
Isinasakatuparan ang pagsasapanahon ng pahina sa pahina at hindi agad-agarang mabubuo.
Ipinapakita ng sumusunod kung sumusulong na ang isang pagsasapanahon at magpapahintulot sa iyo upang simulan o pahintuin ang mga pagsasapanahon (maliban na lamang kung hindi pinagana/pinaandar ng tagapangasiwa ng sityo/sayt ang katangiang-kasangkapang ito).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Sumusulong na ang isang pagsasapanahon.</b>
Pangkaraniwan lamang na mabagal ang pagsulong ng pagsasapanahon dahil sinasariwa lamang nito ang maliliit na tipak ng dato sa bawat panahong pumupunta sa wiki ang isang tagagamit.
Upang mas mabilisang matapos ang pagsasapanahong ito, maaari mong tawagin ang panitik na pangpagpapanatiling <tt>runJobs.php</tt> (gamitin ang pagpipiliang <tt>--maxjobs 1000</tt> ng MediaWiki upang mabigyan ng hangganan ang bilang ng mga pagsasapanahong ginagawa sa bawat isang bungkos).
Tinatayang progreso ng pangkasalukuyang pagsasapanahon:',
	'smw_smwadmin_datarefreshbutton' => 'Umpisahang isapanahon ang dato',
	'smw_smwadmin_datarefreshstop' => 'Ihinto ang pagsasapanahong ito',
	'smw_smwadmin_datarefreshstopconfirm' => 'Oo, nakatitiyak ako.',
	'smw_smwadmin_support' => 'Pagkuha ng suporta',
	'smw_smwadmin_supportdocu' => 'Maaaring makatulong sa iyo ang sari-saring kapakipakinabang na mga bagay-bagay kung sakaling magkaroon ng mga suliranin:',
	'smw_smwadmin_installfile' => 'Kung sakaling makaranas ka ng mga suliranin sa pagluluklok mo, magsimula sa pamamagitan ng pagsusuri ng mga patnubay na nasa loob ng <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">ILUKLOK ang talaksan</a>.',
	'smw_smwadmin_smwhomepage' => 'Ang buong kasulatang pantagagamit ng Semantikong Mediawiki ay nasa <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => "Maaaring iulat ang mga depekto/sira (''bug'') sa <a href=\"https://bugzilla.wikimedia.org/\">Bugzilla</a>.",
	'smw_smwadmin_questions' => 'Kung mayroon ka pang karagdagang mga katanungan o mga mungkahi, makilahok sa usapang nasa <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Pangmadlang talakayan ng tagagamit ng MediaWiking Semantiko</a>.',
	'smw_adminlinks_datastructure' => 'Kayarian ng dato',
	'smw_adminlinks_displayingdata' => 'Pagpapakita ng dato',
	'smw_adminlinks_inlinequerieshelp' => 'Tulong sa mga katanungang nasa guhit',
	'smw-createproperty-isproperty' => 'Isa itong pag-aari ng uring $1.',
	'smw-createproperty-allowedvals' => 'Ang pinahihintulutang {{PLURAL:$1|halaga para sa pag-aaring ito ay|mga halaga para sa pag-aaring ito ay}}:',
	'smw-paramdesc-category-delim' => 'Ang pantakda ng hangganan',
	'smw-paramdesc-category-template' => 'Isang suleras na pangbigay ng kaanyuan sa mga bagay',
	'smw-paramdesc-category-userparam' => 'Isang parametro na ipapasa sa suleras',
	'smw-info-par-message' => 'Mensaheng ipapakita.',
	'smw-info-par-icon' => 'Kinatawang larawan na ipapakita, maaaring "kabatiran" o "babala".',
	'prefs-smw' => 'Semantikong MediaWiki',
	'prefs-ask-options' => 'Mga mapagpipilian ng semantikong paghahanap',
	'smw-prefs-ask-options-tooltip-display' => 'Ipakita ang teksto ng parametro bilang pangkabatiran na payo sa kasangkapan',
	'smw-prefs-ask-options-collapsed-default' => 'Paganahin ang kahon ng mapagpipilian na paguguhuin ayon sa likas na katakdaan',
	'smw_unknowntype' => 'Hindi katanggap-tanggap ang uri ng pag-aaring ito',
);

/** толышә зывон (толышә зывон)
 * @author Гусейн
 */
$messages['tly'] = array(
	'smw_finallistconjunct' => ', ијән',
	'smw_printername_list' => 'Сијоһи',
	'smw_printername_template' => 'Ғәлиб',
	'smw_printername_category' => 'Категоријә',
	'smw_purge' => 'Тожә кардеј',
);

/** Turkish (Türkçe)
 * @author Emperyan
 * @author Erdemaslancan
 * @author Karduelis
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'smw_viewasrdf' => 'RDF beslemesi',
	'smw_finallistconjunct' => ' ve',
	'smw_factbox_head' => '$1 hakkındaki gerçekler',
	'smw_isspecprop' => 'Bu özellik, bu vikideki özel bir özelliktir.',
	'smw_concept_description' => '"$1" kavramının tanımı',
	'smw_multiple_concepts' => 'Tüm kavram sayfaları sadece birer kavram tanımına sahip olabilir.',
	'smw_printername_count' => 'Sonuçları say',
	'smw_printername_csv' => 'CSV dışa aktarımı',
	'smw_printername_embedded' => 'Sayfa içeriklerini yerleştir',
	'smw_printername_list' => 'Liste',
	'smw_printername_rss' => 'RSS dışa aktarımı',
	'smw_printername_table' => 'Tablo',
	'smw_printername_broadtable' => 'Geniş tablo',
	'smw_printername_template' => 'Şablon',
	'smw-paramdesc-limit' => 'Verilecek azami sonuç sayısı',
	'smw-paramdesc-headers' => 'Başlıkları/özellik adlarını göster',
	'smw-paramdesc-link' => 'Değerleri bağlantı olarak gösterir',
	'smw-paramdesc-sep' => 'Değerler için ayraç',
	'smw-paramdesc-embedonly' => 'Başlık gösterme',
	'smw-paramdesc-rsstitle' => 'Beslemenin başlığı olarak kullanılacak metin',
	'smw-paramdesc-searchlabel' => 'Sonuçlara giden bağlantıdaki metin', # Fuzzy
	'smw_iq_moreresults' => '... ek sonuçlar',
	'smw_emptystring' => 'Boş dizgiler kabul edilmemektedir.',
	'smw_maxstring' => 'Dizgi temsili $1 çok uzun.',
	'smw_nofloat' => '"$1" bir sayı değil.',
	'smw_toomanyclosing' => 'Sorguda çok fazla "$1" kullanımı mevcut.',
	'smw_misplacedsymbol' => '"$1" sembolü, yararlı olmadığı bir noktada kullanıldı.',
	'smw_type_header' => '"$1" türünün özellikleri',
	'smw_attribute_header' => '"$1" özelliğini kullanan sayfalar',
	'smw_subproperty_header' => 'Alt özellikler',
	'exportrdf' => "Sayfaları RDF'ye aktar",
	'smw_exportrdf_lastdate' => 'Süre olarak belirtilen noktadan bu yana değiştirilmemiş sayfaları dışa aktarma.',
	'smw_exportrdf_submit' => 'Dışa aktar',
	'properties' => 'Özellikler',
	'smw_properties_docu' => 'Vikide aşağıdaki özellikler kullanılıyor.',
	'smw_property_template' => '$1 tipi $2 ($3)',
	'smw_propertylackspage' => 'Tüm özellikler bir sayfa tarafından açıklanmalıdır!',
	'smw_propertyhardlyused' => 'Bu özellik, viki dahilinde nadiren kullanılmaktadır!',
	'unusedproperties' => 'Kullanılmayan özellikler',
	'wantedproperties' => 'İstenen özellikler',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|kullanım|kullanım}})',
	'smw_purge' => 'Yenile',
	'types' => 'Türler',
	'semanticstatistics' => 'Anlamsal istatistikler',
	'ask' => 'Anlamsal arama',
	'smw_ask_ascorder' => 'Artan',
	'smw_ask_descorder' => 'Azalan',
	'smw_ask_submit' => 'Sonuçları bul',
	'smw_ask_editquery' => '[Sorguyu değiştir]',
	'smw_add_sortcondition' => '[Sıralama koşulu ekle]',
	'smw_ask_hidequery' => 'Sorguyu gizle',
	'smw_ask_help' => 'Sorgulama yardımı',
	'smw_ask_queryhead' => 'Sorgu',
	'smw_ask_printhead' => 'Görüntülenecek ek veriler',
	'smw_ask_printdesc' => '(satır başına bir özellik adı girin)',
	'smw_ask_defaultformat' => 'varsayılan',
	'smw_ask_otheroptions' => 'Diğer seçenekler',
	'smw_ask_show_embed' => 'Yerleştirme kodunu göster',
	'smw_ask_hide_embed' => 'Yerleştirme kodunu gizle',
	'searchbyproperty' => 'Özelliğe göre ara',
	'smw_sbv_docu' => 'Belirtilen özellik ve değere sahip tüm sayfaları ara.',
	'smw_sbv_novalue' => 'Özellik için geçerli bir değer girin ya da "$1" için tüm özellik değerlerini görün.',
	'smw_sbv_displayresult' => '"$2" değeri ile "$1" özelliğine sahip tüm sayfaların bir listesi',
	'smw_sbv_property' => 'Özellik:',
	'smw_sbv_value' => 'Değer:',
	'smw_sbv_submit' => 'Sonuç bul',
	'browse' => 'Vikiye gözat',
	'smw_browselink' => 'Özelliklere gözat',
	'smw_browse_go' => 'Git',
	'smw_browse_show_incoming' => 'buraya bağlantı veren özellikleri göster',
	'smw_browse_hide_incoming' => 'buraya bağlantı veren özellikleri gizle',
	'smw_browse_no_outgoing' => 'Bu sayfa özelliğe sahip değil.',
	'smw_browse_no_incoming' => 'Bu sayfaya bağlantı veren özellik yok.',
	'pageproperty' => 'Sayfa özelliği arama',
	'smw_pp_from' => 'Şu sayfadan:',
	'smw_pp_type' => 'Özellik',
	'smw_pp_submit' => 'Sonuçları bul',
	'smw_result_prev' => 'Önceki',
	'smw_result_next' => 'sonraki',
	'smw_result_results' => 'Sonuçlar',
	'smw_result_noresults' => 'Sonuç yok.',
	'smwadmin' => 'Anlamsal MediaWiki için hizmetlilik fonksiyonları',
	'smw_smwadmin_setupsuccess' => 'Saklama motoru başarıyla ayarlandı.',
	'smw_smwadmin_updatenotstarted' => 'Yürürlükte olan bir güncelleme işlemi mevcut.
Bir diğeri oluşturulmuyor.', # Fuzzy
	'smw_smwadmin_updatestopped' => 'Tüm mevcut güncelleme işlemleri durduruldu.', # Fuzzy
	'smw_smwadmin_announce' => 'Vikinizi duyurun',
	'smw_smwadmin_datarefresh' => 'Veri onarımı ve yükseltmesi',
	'smw_smwadmin_datarefreshbutton' => 'Veri güncellemesini başlat',
	'smw_smwadmin_datarefreshstop' => 'Bu güncellemeyi durdur',
	'smw_smwadmin_datarefreshstopconfirm' => 'Evet, eminim.',
	'smw_smwadmin_support' => 'Destek alınıyor',
	'smw_adminlinks_datastructure' => 'Veri yapısı',
	'smw_adminlinks_displayingdata' => 'Veriler görüntüleniyor',
	'smw_adminlinks_inlinequerieshelp' => 'Satıriçi sorgu yardımı',
	'smw_unknowntype' => 'Özellik için desteklenmeyen "$1" türü tanımlanmış.', # Fuzzy
);

/** Tatar (Cyrillic script) (татарча)
 * @author Ерней
 * @author Ильнар
 */
$messages['tt-cyrl'] = array(
	'smw_ask_defaultformat' => 'килешү буенча',
	'smw_sbv_property' => 'Халәте:',
	'smw_sbv_value' => 'Аңлатмасы:',
	'smw_sbv_submit' => 'Эзләү',
	'browse' => 'Сәхифәне карау',
);

/** Uyghur (Arabic script) (ئۇيغۇرچە)
 * @author Alfredie
 */
$messages['ug-arab'] = array(
	'smw_browse_go' => 'كۆچۈش',
);

/** Uyghur (Latin script) (Uyghurche)
 * @author Jose77
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['ug-latn'] = array(
	'smw_browse_go' => 'Köchüsh',
);

/** Ukrainian (українська)
 * @author Base
 * @author Olvin
 * @author Prima klasy4na
 * @author Тест
 * @author Юрій Булка
 */
$messages['uk'] = array(
	'smw-desc' => "Робить вашу вікі доступнішою — для машин ''та'' людей ([http://semantic-mediawiki.org/wiki/Help:User_manual довідка в мережі])",
	'smw_viewasrdf' => 'вивід RDF',
	'smw_finallistconjunct' => ' і',
	'smw_factbox_head' => 'Відомості про $1',
	'smw_isspecprop' => 'Ця властивість є спеціальною у цій вікі',
	'smw_concept_description' => 'Опис концепції «$1».',
	'smw_no_concept_namespace' => 'Концепції можна означувати лише у просторі назв «Концепція:».',
	'smw_multiple_concepts' => 'Кожна сторінка концепції може мати лише одне означення концепції.',
	'smw_concept_cache_miss' => 'Концепцію «$1» неможливо використати у цей момент, оскільки налаштування цієї вікі вимагає попередньої автономної обробки. Якщо проблема не вирішиться протягом певного часу, зверніться до адміністратора сайту.',
	'smw_noinvannot' => 'У зворотні властивості неможливо записати значення.',
	'version-semantic' => 'Розширення Semantic',
	'smw_baduri' => 'Використовувати адреси (URI), що мають форму «$1» не дозволяється.',
	'smw_printername_count' => 'Результати підрахунку',
	'smw_printername_csv' => 'Експорт у CSV',
	'smw_printername_dsv' => 'Експорт DSV',
	'smw_printername_debug' => 'Налагоджувальний запит (для фахівців)',
	'smw_printername_embedded' => 'Включити вміст сторінки',
	'smw_printername_json' => 'Експорт у JSON',
	'smw_printername_list' => 'Список',
	'smw_printername_ol' => 'Перерахування',
	'smw_printername_ul' => 'Список',
	'smw_printername_table' => 'Таблиця',
	'smw_printername_broadtable' => 'Широка таблиця',
	'smw_printername_template' => 'Шаблон',
	'smw_printername_rdf' => 'експорт у RDF',
	'smw_printername_category' => 'Категорія',
	'validator-type-class-SMWParamSource' => 'текст',
	'smw-paramdesc-limit' => 'Максимальне число результатів',
	'smw-paramdesc-offset' => 'Зміщення першого результату',
	'smw-paramdesc-headers' => 'Показувати заголовки (або назви властивостей)',
	'smw-paramdesc-mainlabel' => 'Заголовок стовпця із назвою сторінки',
	'smw-paramdesc-link' => 'Показувати значення у вигляді посилань',
	'smw-paramdesc-intro' => 'Текст, який показувати перед результатами запиту, якщо такі є',
	'smw-paramdesc-outro' => 'Текст, який показувати після результатів запиту, якщо такі є',
	'smw-paramdesc-default' => 'Текст, який показувати у випадку відсутності результатів запиту',
	'smw-paramdesc-sep' => 'Розділювач для значень',
	'smw-paramdesc-showsep' => 'Показувати роздільник у верхній частині CSV-файлу ("sep=<значення>")',
	'smw-paramdesc-distribution' => 'Замість показу усіх значень, підрахувати їх частоту і показати це',
	'smw-paramdesc-template' => 'Назва шаблону, який використовувати для виводу результатів запиту',
	'smw-paramdesc-columns' => 'Кількість стовпців для виводу результатів запиту (типове значення: $1)',
	'smw-paramdesc-userparam' => 'Значення, що передається у кожне звертання до шаблона при використанні шаблонів',
	'smw-paramdesc-introtemplate' => 'Назва шаблону, який показувати перед результатами запиту, якщо такі є',
	'smw-paramdesc-outrotemplate' => 'Назва шаблону, який показувати після результатів запиту, якщо такі є',
	'smw-paramdesc-embedformat' => 'Теґ HTML, який використовувати для означення заголовків',
	'smw-paramdesc-embedonly' => 'Не показувати заголовків',
	'smw-paramdesc-rdfsyntax' => 'Який синтаксис RDF вживати',
	'smw-paramdesc-csv-sep' => 'Використовувати роздільник',
	'smw-paramdesc-dsv-separator' => 'Використорувати роздільник',
	'smw-paramdesc-searchlabel' => 'Текст у посиланні на результати запиту', # Fuzzy
	'smw_iq_disabled' => 'Семантичні запити було вимкнено у цій вікі.',
	'smw_iq_moreresults' => '... подальші результати',
	'smw_parseerror' => 'Вказане значення — незрозуміле.',
	'smw_notitle' => '«$1» неможливо використати у якості назви сторінки у цій вікі.',
	'smw_wrong_namespace' => 'Тут дозволено лише сторінки в просторі назв «$1».',
	'smw_manytypes' => 'Для властивості означено більше одного типу даних.',
	'smw_emptystring' => 'Використовувати пусті рядки не дозволяється.',
	'smw_maxstring' => 'Рядок «$1» — занадто довгий.',
	'smw_notinenum' => '«$1» не є у списку дозволених значень ($2) для цієї властивості.',
	'smw_noboolean' => '«$1» не розпізнається як булове значення (значення «так/ні»).',
	'smw_true_words' => 'true,t,yes,y,так,т',
	'smw_false_words' => 'false,f,no,n,ні,н',
	'smw_nofloat' => '«$1» не є числом',
	'smw_infinite' => 'Такі довгі числа, як «$1» не підтримуються.',
	'smw_novalues' => 'Не вказано значень.',
	'smw_nodatetime' => 'Дата «$1» — незрозуміла.',
	'smw_toomanyclosing' => '«$1» зустрічається занадто багато разів.',
	'smw_noclosingbrackets' => 'Деякі з «<nowiki>[[</nowiki>» у запиті не було закрито відповідними «]]».',
	'smw_misplacedsymbol' => 'Символ «$1» використано у невідповідному місці.',
	'smw_unexpectedpart' => 'Фрагмент запиту «$1» — незрозумілий. Результати можуть відрізнятись від очікуваних.',
	'smw_emptysubquery' => 'Деякий підзапит не містить інформації про умову.',
	'smw_misplacedsubquery' => 'Деякий підзапит був використаний у невідповідному місці.',
	'smw_valuesubquery' => 'Підзапити не підтримуються для значень властивості «$1».',
	'smw_badqueryatom' => 'Певна частина «<nowiki>[[…]]</nowiki>» — незрозуміла.',
	'smw_propvalueproblem' => 'Значення властивості «$1» — незрозуміле.',
	'smw_noqueryfeature' => 'Певна функція запиту не підтримується у цій вікі, тому ця частина запиту була пропущена ($1).',
	'smw_noconjunctions' => 'Операція логічного «і» не підтримується у цій вікі, тому ця частина запиту була пропущена ($1).',
	'smw_nodisjunctions' => 'Операція логічного «або» не підтримується у цій вікі, тому ця частина запиту була пропущена ($1).',
	'smw_querytoolarge' => 'Наступні умови запиту не можуть бути опрацьовані в зв’язку з обмеженнями цього вікі в розмірі та/або глибині запиту: $1.',
	'smw_notemplategiven' => 'Щоб цей формат запиту спрацював, потрібно вказати значення параметра «template».',
	'smw_type_header' => 'Властивості типу даних «$1»',
	'smw_typearticlecount' => '{{PLURAL:$1|Показується|Показуються|Показується}} $1 {{PLURAL:$1|властивість|властивості|властивостей}} цього типу даних.',
	'smw_attribute_header' => 'Сторінки, що використовують властивість «$1»',
	'smw_attributearticlecount' => '{{PLURAL:$1|Показується|Показуються|Показується}} $1 {{PLURAL:$1|сторінка, що використовує|сторінки, що використовують|сторінок, що використовують}} цю властивість.',
	'smw_subproperty_header' => 'Підвластивості',
	'smw_subpropertyarticlecount' => 'Ця властивість має $1 {{PLURAL:$1|підвластивість|підвластивості|підвластивостей}}',
	'smw_concept_header' => 'Сторінки, що належать до концепції «$1»',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Показується|Показуються|Показується}} $1 {{PLURAL:$1|сторінка, що належить|сторінки, що належать|сторінок, що належать}} цій концепції.',
	'exportrdf' => 'Експорт сторінок у RDF',
	'smw_exportrdf_docu' => 'Ця сторінка дозволяє отримати дані із сторінки у форматі RDF. Введіть назви сторінок, по одній у рядку, в текстовому полі, що знаходиться нижче.',
	'smw_exportrdf_recursive' => 'Рекурсивно експортувати усі пов’язані сторінки. Зауважте: результат може бути об’ємним.',
	'smw_exportrdf_backlinks' => 'Також експортувати усі сторінки, що звертаються до експортованих. Генерує RDF з можливістю навігації.',
	'smw_exportrdf_lastdate' => 'Не експортувати сторінки, що не були змінені з часу заданого моменту в часі.',
	'smw_exportrdf_submit' => 'Експорт',
	'uriresolver' => 'Оброблювач URI',
	'properties' => 'Властивості',
	'smw_properties_docu' => 'Наступні властивості використовуються у цій вікі.',
	'smw_property_template' => '$1 із типом $2 ($3)', # Fuzzy
	'smw_propertylackspage' => 'Кожна властивість повинна мати сторінку, що її описує.',
	'smw_propertylackstype' => 'Для цієї властивості не було означено типу даних (поки що використовується $1).',
	'smw_propertyhardlyused' => 'Ця властивість використовується рушієм вікі.',
	'unusedproperties' => 'Властивості, що не використовуються',
	'smw_unusedproperties_docu' => 'Наступні властивості означені, проте жодна із сторінок їх не використовує.',
	'smw_unusedproperty_template' => '$1 із типом даних $2',
	'wantedproperties' => 'Потрібні властивості',
	'smw_wantedproperties_docu' => 'Наступні властивості використовуються у цій вікі, проте вони ще не мають сторінок, що б їх описували.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|звернення|звернення|звернень}})',
	'smw_purge' => 'Оновити',
	'types' => 'Типи',
	'smw_types_docu' => 'Список типів даних, які можуть бути призначені властивостям. Кожен тип даних має сторінку, де модна надати додаткову інформацію.', # Fuzzy
	'semanticstatistics' => 'Семантична статистика',
	'smw_semstats_text' => "Ця вікі містить '''$1''' {{PLURAL:$1|значення властивості|значення властивостей|значень властивостей}}, для '''$2''' [[Special:Properties|{{PLURAL:$2|властивості|властивостей|властивостей}}]]. '''$3''' {{PLURAL:$3|властивість має|властивості мають|властивостей мають}} відповідні їм сторінки, і відповідний тип даних вказано у '''$4''' із них. Деякі із наявних властивостей можуть бути [[Special:UnusedProperties|властивостями, що не використовуються]]. Властивості, котрі не мають відповідних їм сторінок, можна знайти в [[Special:WantedProperties|списку пропонованих властивостей]].",
	'smw_uri_doc' => 'Оброблювач URI виконує <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">«W3C TAG finding on httpRange-14»</a>. Ця функція спрощує пошук семантичної інформації.',
	'ask' => 'Семантичний пошук',
	'smw_ask_sortby' => 'Сортувати за стовпцем (необов’язково)',
	'smw_ask_ascorder' => 'За зростанням',
	'smw_ask_descorder' => 'За спаданням',
	'smw_ask_submit' => 'Знайти',
	'smw_ask_editquery' => '[Редагувати запит]',
	'smw_add_sortcondition' => '[Додати умову сортування]',
	'smw_ask_hidequery' => 'Приховати запит',
	'smw_ask_help' => 'Довідка про запити',
	'smw_ask_queryhead' => 'Запит',
	'smw_ask_printhead' => 'Додаткові дані для відображення',
	'smw_ask_printdesc' => '(одна назва властивості на рядок)',
	'smw_ask_format_as' => 'Форматувати як:',
	'smw_ask_defaultformat' => 'за умовчанням',
	'smw_ask_otheroptions' => 'Інші опції',
	'smw_ask_show_embed' => 'Показати включений код',
	'smw_ask_hide_embed' => 'Приховати включений код',
	'smw_ask_embed_instr' => 'Щоб вбудувати цей запит в вікісторінку, використовуйте поданий нижче код.',
	'smw_qui_ok' => 'Гаразд',
	'smw_qui_cancel' => 'Скасувати',
	'searchbyproperty' => 'Шукати за властивістю',
	'smw_sbv_docu' => 'Шукати всі сторінки, що мають вказану властивість і значення.',
	'smw_sbv_novalue' => 'Введіть правильне значення властивості або перегляньте всі значення властивості «$1».',
	'smw_sbv_displayresult' => 'Список всіх сторінок, що мають властивість «$1» із значенням «$2»',
	'smw_sbv_displayresultfuzzy' => 'Список всіх сторінок, що мають властивість «$1» із значенням «$2». Оскільки було лише кілька результатів, показано також сторінки, що містять близькі значення цієї властивості.',
	'smw_sbv_property' => 'Властивість:',
	'smw_sbv_value' => 'Значення:',
	'smw_sbv_submit' => 'Знайти',
	'browse' => 'Перегляд вікі',
	'smw_browselink' => 'Перегляд властивостей',
	'smw_browse_article' => 'Введіть назву сторінки, з якої почати перегляд.',
	'smw_browse_go' => 'Перейти',
	'smw_browse_show_incoming' => 'показати властивості, що посилаються сюди',
	'smw_browse_hide_incoming' => 'приховати властивості, що посилаються сюди',
	'smw_browse_no_outgoing' => 'Ця сторінка не містить властивостей.',
	'smw_browse_no_incoming' => 'На цю сторінку не посилається жодна властивість.',
	'smw_inverse_label_default' => '$1 з',
	'smw_inverse_label_property' => 'Назва зворотної властивості',
	'pageproperty' => 'Пошук властивостей сторінки',
	'smw_pp_docu' => 'Шукати всі значення властивостей на вказаній сторінці. Введіть сторінку та властивість.',
	'smw_pp_from' => 'З сторінки',
	'smw_pp_type' => 'Властивість',
	'smw_pp_submit' => 'Знайти',
	'smw_result_prev' => 'Попередня',
	'smw_result_next' => 'Наступна',
	'smw_result_results' => 'Результати',
	'smw_result_noresults' => 'Немає результатів.',
	'smwadmin' => 'Адміністративні функції Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'База даних успішно налаштована.',
	'smw_smwadmin_return' => 'Повернутись до $1',
	'smw_smwadmin_updatestarted' => 'Запущено новий процес оновлення семантичних даних. 
Усі збережені дані буде перебудовано чи відновлено за необхідності. 
За процесом оновлення можна стежити на цій сторінці.

Повернення до $1.',
	'smw_smwadmin_updatenotstarted' => 'Процес оновлення вже працює. 
Нового запущено не буде.

Поверніться до $1.',
	'smw_smwadmin_updatestopped' => 'Усі процеси оновлення було зупинено.

Поверніться до $1.',
	'smw_smwadmin_updatenotstopped' => 'Щоб зупинити запущений процес оновлення, Ви маєте поставити позначку, аби засвідчити, що ви справді впевнені в цьому.

Повернення до $1.',
	'smw_smwadmin_docu' => 'Ця сторінка допоможе при встановленні або оновленні <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>. Не забудьте зробити резервну копію всіх важливих даних перед запуском адміністративних функцій.',
	'smw_smwadmin_db' => 'Встановлення та оновлення бази даних',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki потребує розширити базу даних, щоб могти зберігати семантичну інформацію. Подана нижче функція забезпечує правильне налаштування бази даних. Зміни, котрі вона вносить, не зачіпають решти бази даних MediaWiki, та можуть бути легко скасовані. Хоча цю функцію безпечно запускати кілька разів, її використання потрібне лише один раз для встановлення чи оновлення.',
	'smw_smwadmin_permissionswarn' => 'Якщо ця операція буде зупинена через помилки SQL, вірогідною причиною може бути відсутність необхідних прав користувача, під іменем якого вікі під’єднується до бази даних (він вказується у LocalSettings.php). В такому випадку вам необхідно або дозволити цьому користувачу створювати та вилучати таблиці БД, або тимчасово ввести в LocalSettings.php логін БД «root», або використати сценарій обслуговування <tt>SMW_setup.php</tt>, який може використовувати облікові дані AdminSettings.php.', # Fuzzy
	'smw_smwadmin_dbbutton' => 'Ініціалізація або освіження таблиць',
	'smw_smwadmin_announce' => 'Заявити про вашу вікі',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki має вебсервіс для заявлення про нові семантичні вікі сайти. Головне призначення цього сервісу — зберігати список відкритих сайтів, що використовують Semantic MediaWiki з метою допомогти проектові <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki</a> мати інформацію про типові варіанти використання цього рушія. Більше інформації можна знайти на <a href="http://semantic-mediawiki.org/wiki/Registry">сайті Semantic MediaWiki</a>.',
	'smw_smwadmin_announcebutton' => 'Натисніть наступну кнопку, щоб відправити адресу цього вікі до нашого сервісу. Сервіс не буде реєструвати вікі, які не є публічно доступними, і буде зберігати інформацію, що є публічно доступною.',
	'smw_smwadmin_datarefresh' => 'Відновлення і оновлення даних',
	'smw_smwadmin_datarefreshdocu' => 'Можна відновити всі дані Semantic MediaWiki, базуючись на поточному стані вмісту вікі. Це можна використати при відновленні пошкоджених даних або при оновленні даних, якщо внутрішній формат змінився через оновлення програмного забезпечення. Оновлення буде виконувати сторінка за сторінкою, тому займе якийсь час. Нижче показано прогрес процесу оновлення, дається можливість запустити або зупинити оновлення (якщо ця функція не була заблокована адміністратором).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Процес оновлення вже запущено.</strong>
Процес оновлення відбувається маленькими порціям із кожним відкриттям сторінки користувачами, тому він проходить повільно. Щоб швидше закінчити оновлення, можна скористатись сценарієм обслуговування <tt>runJobs.php</tt> (використовуйте опцію <tt>--maxjobs 1000</tt> щоб обмежити число оновлень в одному пакеті).
Приблизний стан запущеного оновлення:',
	'smw_smwadmin_datarefreshbutton' => 'Почати оновлення даних',
	'smw_smwadmin_datarefreshstop' => 'Зупинити це оновлення',
	'smw_smwadmin_datarefreshstopconfirm' => 'Так, я впевнений.',
	'smw_smwadmin_support' => 'Отримання підтримки',
	'smw_smwadmin_supportdocu' => 'Є різні ресурси, що можуть стати в пригоді у разі виникнення проблем:',
	'smw_smwadmin_installfile' => 'Якщо у вас виникли проблеми із встановленням, насамперед подивіться поради в <a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">файлі INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Повна довідка із користування Semantic MediaWiki знаходиться на сайті <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Повідомлення про помилки відсилайте через <a href="https://bugzilla.wikimedia.org/">Баґзиллу</a>.',
	'smw_smwadmin_questions' => 'Якщо у вас є додаткові запитання чи побажання, приєднуйтесь до обговорень на <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">форумі з користування Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Структура даних',
	'smw_adminlinks_displayingdata' => 'Відображення даних',
	'smw_adminlinks_inlinequerieshelp' => 'Довідка із вбудованих запитів',
	'smw_unknowntype' => 'Для властивості означено тип даних «$1», який не підтримується.', # Fuzzy
);

/** Urdu (اردو)
 * @author පසිඳු කාවින්ද
 */
$messages['ur'] = array(
	'smw_printername_list' => 'فہرست',
	'smw_printername_table' => 'ٹیبل',
	'smw_printername_category' => 'زمرہ',
	'smw_exportrdf_submit' => 'برآمد',
	'properties' => 'کی خصوصیات',
	'smw_purge' => 'کی تازہ کاری کریں',
	'types' => 'اقسام',
	'smw_ask_queryhead' => 'استفہام',
	'smw_ask_defaultformat' => 'پہلے سے طے شدہ',
	'smw_ask_otheroptions' => 'دوسرے اختیارات',
	'smw-ask-delete' => '[حذف کریں]',
	'smw_qc_show_addnal_opts' => 'مزید اختیارات دکھائیں',
	'smw_qc_otheropt' => 'دوسرے اختیارات',
	'smw_qc_default' => 'پہلے سے طے شدہ:',
	'smw_qc_formatopt' => 'کی شکل کے اختیارات',
	'smw_qui_prop' => 'جائداد:',
	'smw_qui_labl' => 'لیبل:',
	'smw_qui_formt' => 'فارمیٹ:',
	'smw_qui_limt' => 'کی حد:',
	'smw_qui_shownresults' => 'شو کے نتائج میں',
	'smw_qui_randorder' => 'بے ترتيب',
	'smw_qui_delete' => 'حذف کریں',
	'smw_qui_options' => 'اختیارات',
	'smw_qui_addcategory' => 'زمرہ شامل کریں',
	'smw_qui_cancel' => 'منسوخ',
	'smw_qui_label' => 'لیبل',
	'smw_prp_options' => 'پراپرٹی کے اختیارات',
	'smw_qui_catopts' => 'زمرہ کے اختیارات',
	'smw_qui_mainlabopts' => 'نتیجہ کے اختیارات',
	'smw_qui_dlabel' => 'لیبل:',
	'smw_qui_dcategory' => 'زمرہ:',
	'smw_sbv_property' => 'جائداد:',
	'smw_sbv_value' => 'قیمت:',
	'smw_sbv_submit' => 'نتائج تلاش کریں',
	'smw_browselink' => 'کی خصوصیات کو براؤز کریں',
	'smw_browse_go' => 'جانا',
	'smw_pp_from' => 'صفحہ سے',
	'smw_pp_type' => 'پراپرٹی',
	'smw_pp_submit' => 'نتائج تلاش کریں',
	'smw_result_prev' => 'پچھلے',
	'smw_result_next' => 'اگلے',
	'smw_result_results' => 'نتائج',
	'smw_result_noresults' => 'کوئی نتائج.',
	'smw_smwadmin_datarefreshstopconfirm' => 'جی ہاں, میں اس بات کا یقین ہوں.',
	'smw_smwadmin_support' => 'ہو رہی ہے کی حمایت',
);

/** Uzbek (oʻzbekcha)
 * @author CoderSI
 */
$messages['uz'] = array(
	'specialpages-group-smw_group' => "Ma'noviy MediaWiki",
	'smw_purge' => 'Yangilash',
	'smw_browselink' => "Xossalarni ko'rish",
	'smw-info-par-message' => 'Tasvirlash uchun xabar',
	'prefs-smw' => "Ma'noviy MediaWiki",
	'prefs-ask-options' => "Ma'noviy qidiruv moslamalari",
	'smw-prefs-ask-options-tooltip-display' => "Ko'rsatkich matnni yo'l ko'rsatuvchi ma'lumot sifatida tasvirlash",
	'smw-prefs-ask-options-collapsed-default' => "Boshlang'ich holatga yig'ilgan turishi uchun tanlov maydoniga ruxsatlilikni yoqish",
	'smw_unknowntype' => "Ushbu xossaning tipi noto'g'ri",
);

/** Veps (vepsän kel’)
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'smw_viewasrdf' => 'RDF-purde',
	'smw_finallistconjunct' => ' da',
	'smw_factbox_head' => 'Faktad $1:n polhe',
	'smw_printername_count' => "Lugeda rezul'tatad",
	'smw_printername_list' => 'Nimikirjutez',
	'smw_printername_table' => 'Tablut',
	'smw_printername_broadtable' => 'Leved tablut',
	'smw_exportrdf_submit' => 'Eksport',
	'properties' => 'Ičendad',
	'semanticstatistics' => 'Semantine statistik',
	'ask' => 'Semantine ecind',
	'smw_ask_submit' => "Löuta rezul'tatad",
	'smw_ask_editquery' => '[Redaktiruida küzund]',
	'smw_browse_go' => 'Mäne',
	'smw_pp_from' => 'Lehtpolelpäi',
	'smw_pp_type' => 'Ičend',
	'smw_pp_submit' => "Löuta rezul'tatad",
	'smw_result_prev' => 'Edeline',
	'smw_result_next' => "Jäl'ghine",
	'smw_result_results' => "Rezul'tatad",
	'smw_result_noresults' => "Ei ole rezul'tatoid.",
	'smwadmin' => 'Redaktiruida Semantic MediaWiki',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'smw-desc' => "Làm cho wiki của bạn khả dụng hơn – đối với máy ''cũng như'' con người ([http://semantic-mediawiki.org/wiki/Help:User_manual tài liệu trực tuyến])",
	'smw_viewasrdf' => 'Tin RDF',
	'smw_finallistconjunct' => ', và',
	'smw_factbox_head' => 'Sự thật về $1',
	'smw_isspecprop' => 'Thuộc tính này là thuộc tính đặc biệt trong wiki này.',
	'smw_concept_description' => 'Miêu tả khái niệm “$1”',
	'version-semantic' => 'Phần mở rộng ngữ nghĩa',
	'smw_baduri' => 'Rất tiếc, không cho phép URI có dạng “$1”.',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => 'Đếm kết quả',
	'smw_printername_csv' => 'Xuất CSV',
	'smw_printername_dsv' => 'Xuất DSV',
	'smw_printername_debug' => 'Truy vấn gỡ lỗi (cho các chuyên gia)',
	'smw_printername_embedded' => 'Nhúng nội dung trang',
	'smw_printername_json' => 'Xuất JSON',
	'smw_printername_list' => 'Danh sách',
	'smw_printername_rss' => 'Xuất RSS',
	'smw_printername_table' => 'Bảng',
	'smw_printername_broadtable' => 'Bảng rộng',
	'smw_printername_template' => 'Bản mẫu',
	'smw_printername_rdf' => 'Xuất RDF',
	'smw_printername_category' => 'Thể loại',
	'smw-paramdesc-limit' => 'Đa số kết quả để cho ra',
	'smw-paramdesc-mainlabel' => 'Nhãn cho tên trang chính',
	'smw-paramdesc-link' => 'Hiển thị các giá trị là liên kết',
	'smw-paramdesc-sep' => 'Dấu phân cách các giá trị',
	'smw-paramdesc-embedonly' => 'Không hiển thị các tiêu đề',
	'smw-paramdesc-rdfsyntax' => 'Cú pháp RDF được sử dụng',
	'smw-paramdesc-csv-sep' => 'Dấu phân cách để sử dụng',
	'smw-paramdesc-dsv-separator' => 'Dấu phân cách để sử dụng',
	'smw-paramdesc-dsv-filename' => 'Tên của tập tin DSV',
	'smw-paramdesc-order' => 'Thứ tự xếp của truy vấn',
	'smw_iq_disabled' => 'Rất tiếc. Chức năng truy vấn ngữ nghĩa đã bị tắt tại wiki này.',
	'smw_iq_moreresults' => '… kết quả khác',
	'smw_parseerror' => 'Không hiểu giá trị cung cấp.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => 'Không thể dùng “$1” làm tên trang trên wiki này.',
	'smw_manytypes' => 'Thuộc tính này có nhiều hơn một kiểu',
	'smw_emptystring' => 'Không chấp nhận chuỗi trống.',
	'smw_maxstring' => 'Đại diện chuỗi $1 quá dài.',
	'smw_notinenum' => '“$1” không nằm trong danh sách các giá trị khả dĩ ($2) cho thuộc tính này.',
	'smw_noboolean' => '“$1” không phải là giá trị Boole (đúng/sai).',
	'smw_true_words' => 'true,t,yes,y,đúng,đ,có,c',
	'smw_false_words' => 'false,f,no,n,sai,s,không,k',
	'smw_nofloat' => '“$1” không phải là số.',
	'smw_infinite' => 'Không hỗ trợ các số lớn như “$1”.',
	'smw_novalues' => 'Không định rõ giá trị.',
	'smw_nodatetime' => 'Không hiểu ngày “$1”.',
	'smw_toomanyclosing' => 'Dường có quá nhiều lần xuất hiện “$1” trong câu truy vấn.',
	'smw_noclosingbrackets' => 'Lần sử dụng “<nowiki>[[</nowiki>” nào đó trong câu truy vấn của bạn không được đóng bằng “]]”.',
	'smw_misplacedsymbol' => 'Ký hiệu “$1” được dùng tại nơi nó không hữu ích.',
	'smw_unexpectedpart' => 'Phần “$1” của câu truy vấn không hiểu được.
Kết quả có thể không như mong đợi.',
	'smw_emptysubquery' => 'Một truy vấn con nào đó không có điều kiện hợp lệ.',
	'smw_misplacedsubquery' => 'Một truy vấn con nào đó được dùng tại nơi không cho phép dùng truy vấn con.',
	'smw_valuesubquery' => 'Truy vấn con không hỗ trợ các giá trị của tham số “$1”.',
	'smw_badqueryatom' => 'Phần “<nowiki>[[…]]</nowiki>” nào đó của câu truy vấn không hiểu được.',
	'smw_propvalueproblem' => 'Không hiểu giá trị của thuộc tính “$1”.',
	'smw_nodisjunctions' => 'Phân tách trong câu truy vấn không hỗ trợ trong wiki này và một phần câu truy vấn bị bỏ qua ($1).',
	'smw_querytoolarge' => 'Các điều kiện truy vấn sau đây không được xem xét do hạn chế của wiki trong độ dài hoặc độ sâu truy vấn: $1.',
	'smw_notemplategiven' => 'Xin hãy cung cấp giá trị cho tham số “template” để đinh dạng truy vấn này có thể hoạt động.',
	'smw_type_header' => 'Tính chất của loại “$1”',
	'smw_typearticlecount' => 'Hiển thị $1 thuộc tính sử dụng kiểu này.{{PLURAL:$1||}}',
	'smw_attribute_header' => 'Những trang dùng thuộc tính “$1”',
	'smw_attributearticlecount' => 'Hiển thị $1 trang dùng thuộc tính này.{{PLURAL:$1||}}',
	'smw_subproperty_header' => 'Thuộc tính con',
	'smw_concept_header' => 'Trang về khái niệm “$1”',
	'smw_rss_description' => 'Nguồn tin RSS của $1',
	'exportrdf' => 'Xuất trang ra RDF',
	'smw_exportrdf_docu' => 'Trang này cho phép bạn lấy dữ liệu từ trang theo dạng RDF.
Để xuất trang, gõ vào tựa đề trong khung dưới đây, một dòng một tựa đề.',
	'smw_exportrdf_recursive' => 'Xuất đệ quy tất cả các trang liên quan.
Chú ý rằng kết quả không thể quá lớn!',
	'smw_exportrdf_backlinks' => 'Cũng xuất tất cả các trang chỉ đến trang được xuất.
Tạo ra RDF có thể duyệt được.',
	'smw_exportrdf_lastdate' => 'Đừng xuất trang không thay đổi từ một thời điểm cho trước.',
	'smw_exportrdf_submit' => 'Xuất',
	'uriresolver' => 'Bộ giải URI',
	'properties' => 'Thuộc tính',
	'smw_properties_docu' => 'Các thuộc tính được dùng trong wiki.',
	'smw_property_template' => '$1 thuộc loại $2 ($3)',
	'smw_propertylackspage' => 'Tất cả các thuộc tính nên được mô tả bằng một trang!',
	'smw_propertylackstype' => 'Không có loại này được chỉ định cho thuộc tính này (từ giờ giả thiết loại $1).',
	'smw_propertyhardlyused' => 'Thuộc tính này khó sử dụng trong wiki!',
	'unusedproperties' => 'Thuộc tính không sử dụng',
	'smw_unusedproperties_docu' => 'Các thuộc tính sau tồn tại mặc dù không có trang nào dùng chúng.',
	'smw_unusedproperty_template' => '$1 thuộc loại $2',
	'wantedproperties' => 'Thuộc tính cần nhất',
	'smw_wantedproperties_docu' => 'Các thuộc tính sau được dùng trong wiki nhưng chưa có trang nào mô tả chúng.',
	'smw_wantedproperty_template' => '$1 ($2 lần sử dụng){{PLURAL:$1||}}',
	'smw_purge' => 'Làm tươi',
	'types' => 'Các dạng',
	'smw_types_docu' => 'Sau đây là danh sách tất cả các kiểu dữ liệu có thể gán vào thuộc tính.',
	'semanticstatistics' => 'Thống kê ngữ nghĩa',
	'smw_semstats_text' => "Wiki này có chứa '''$1''' giá trị thuộc tính cho tổng cộng '''$2''' [[Special:Properties|thuộc tính khác nhau]].
'''$3''' thuộc tính có trang riêng, và kiểu dữ liệu dự tính được chỉ định cho '''$4''' trong số đó.
Một số thuộc tính hiện có có thể [[Special:UnusedProperties|chưa được sử dụng]].
Có thể tìm thấy thuộc tính còn thiếu trang tại [[Special:WantedProperties|danh sách các thuộc tính cần có]].",
	'smw_uri_doc' => 'Bộ giải URI hiện thực <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">THẺ W3C tìm thấy tại httpRange-14</a>. Nó lo việc con người không quay lại trang web.',
	'ask' => 'Tìm kiếm ngữ nghĩa',
	'smw_ask_sortby' => 'Sắp xếp theo cột (tùy chọn)',
	'smw_ask_ascorder' => 'Tăng dần',
	'smw_ask_descorder' => 'Giảm dần',
	'smw_ask_submit' => 'Kết quả tìm kiếm',
	'smw_ask_editquery' => '[Sửa truy vấn]',
	'smw_add_sortcondition' => '[Thêm điều kiện sắp xếp]',
	'smw_ask_hidequery' => 'Ẩn truy vấn',
	'smw_ask_help' => 'Trợ giúp truy vấn',
	'smw_ask_queryhead' => 'Truy vấn',
	'smw_ask_printhead' => 'Dữ liệu bổ sung được hiển thị',
	'smw_ask_format_as' => 'Định dạng:',
	'smw_ask_defaultformat' => 'mặc định',
	'smw_ask_otheroptions' => 'Tùy chọn khác',
	'smw_ask_show_embed' => 'Hiện mã để nhúng',
	'smw_ask_hide_embed' => 'Ẩn mã để nhúng',
	'smw_qc_addmainlabel' => 'Thêm nhãn chính',
	'smw_qc_show_addnal_opts' => 'Hiện thêm tùy chọn',
	'smw_qc_hide_addnal_opts' => 'Hiện ít tùy chọn hơn',
	'smw_qc_otheropt' => 'Tùy chọn khác',
	'smw_qc_default' => 'Mặc định:',
	'smw_qc_formatopt' => 'Tùy chọn định dạng',
	'smw_qui_property' => '<strong>Thuộc tính</strong>',
	'smw_qui_prop' => 'Thuộc tính:',
	'smw_qui_labl' => 'Nhãn:',
	'smw_qui_formt' => 'Định dạng:',
	'smw_qui_limt' => 'Giới hạn:',
	'smw_qui_shownresults' => 'hiển thị trong kết quả',
	'smw_qui_nosort' => 'Không xếp',
	'smw_qui_ascorder' => 'Tăng dần',
	'smw_qui_descorder' => 'Giảm dần',
	'smw_qui_randorder' => 'Ngẫu nhiên',
	'smw_qui_addnprop' => 'thêm thuộc tính',
	'smw_qui_delete' => 'Dời',
	'smw_qui_options' => 'tùy chọn',
	'smw_qui_addcategory' => 'thêm thể loại',
	'smw_qui_ok' => 'OK',
	'smw_qui_cancel' => 'Hủy bỏ',
	'smw_qui_category' => '<strong>Thể loại</strong>',
	'smw_qui_label' => 'Nhãn',
	'smw_prp_options' => 'Tùy chọn thuộc tính',
	'smw_qui_catopts' => 'Tùy chọn thể loại',
	'smw_qui_mainlabopts' => 'Tùy chọn kết quả',
	'smw_qui_dlabel' => 'Nhãn:',
	'smw_qui_dcategory' => 'Thể loại:',
	'searchbyproperty' => 'Tìm theo thuộc tính',
	'smw_sbv_docu' => 'Tìm tất cả các trang có thuộc tính và giá trị cho trước.',
	'smw_sbv_novalue' => 'Xin nhập vào một giá trị hợp lệ cho thuộc tính, hoặc xem tất cả các giá trị thuộc tính của “$1.”',
	'smw_sbv_displayresult' => 'Danh sách tất cả các trang có thuộc tính “$1” có giá trị “$2”',
	'smw_sbv_property' => 'Thuộc tính:',
	'smw_sbv_value' => 'Giá trị:',
	'smw_sbv_submit' => 'Kết quả tìm kiếm',
	'browse' => 'Duyệt wiki',
	'smw_browselink' => 'Duyệt thuộc tính',
	'smw_browse_article' => 'Gõ vào tên trang để bắt đầu duyệt.',
	'smw_browse_go' => 'Xem',
	'smw_browse_show_incoming' => 'hiện các thuộc tính liên kết đến đây',
	'smw_browse_hide_incoming' => 'ẩn các thuộc tính liên kết đến đây',
	'smw_browse_no_outgoing' => 'Trang này không có thuộc tính.',
	'smw_browse_no_incoming' => 'Không có thuộc tính liên kết đến trang này.',
	'pageproperty' => 'Tìm kiếm thuộc tính trang',
	'smw_pp_docu' => 'Tìm tất cả các lấp chỗ trống của một thuộc tính tại một trang cho trước.
Xin nhập vào cả một trang và một thuộc tính.',
	'smw_pp_from' => 'Từ trang',
	'smw_pp_type' => 'Thuộc tính',
	'smw_pp_submit' => 'Kết quả tìm kiếm',
	'smw_result_prev' => 'Trước',
	'smw_result_next' => 'Sau',
	'smw_result_results' => 'Kết quả',
	'smw_result_noresults' => 'Không tìm thấy kết quả.',
	'smwadmin' => 'Chức năng quản lý MediaWiki Ngữ nghĩa',
	'smw_smwadmin_return' => 'Trở lại $1',
	'smw_smwadmin_announce' => 'Tuyên bố wiki của bạn',
	'smw_smwadmin_datarefreshbutton' => 'Bắt đầu nâng cấp dữ liệu',
	'smw_smwadmin_datarefreshstop' => 'Ngừng việc nâng cấp',
	'smw_smwadmin_datarefreshstopconfirm' => 'Có chắc',
	'smw_smwadmin_support' => 'Trợ giúp',
	'smw_smwadmin_smwhomepage' => 'Tài liệu sử dụng đầy đủ của MediaWiki Ngữ nghĩa có sẵn tại <b><a href="http://semantic-mediawiki.org/?uselang=vi">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Hãy báo cáo lỗi tại <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_adminlinks_datastructure' => 'Cấu trúc dữ liệu',
	'smw_adminlinks_displayingdata' => 'Hiển thị dữ liệu',
	'smw_adminlinks_inlinequerieshelp' => 'Trợ giúp truy vấn nội dòng',
	'smw-createproperty-isproperty' => 'Đây là tính chất thuộc kiểu $1.',
	'smw-createproperty-allowedvals' => '{{PLURAL:$1|Giá trị|Các giá trị}} cho phép của thuộc tính này là:',
	'prefs-smw' => 'MediaWiki Ngữ nghĩa',
	'smw_unknowntype' => 'Kiểu của thuộc tính này không hợp lệ.',
);

/** Volapük (Volapük)
 * @author Malafaya
 * @author Smeira
 */
$messages['vo'] = array(
	'smw_finallistconjunct' => ', e',
	'smw_factbox_head' => 'Jenöfots dö $1',
	'smw_isspecprop' => 'Patöf at binon patöf patik in vük at.',
	'smw_concept_description' => 'Bepenam suemoda: „$1“.',
	'smw_no_concept_namespace' => 'Suemods kanons pamiedetön te su pads nemadaspada: Miedet.',
	'smw_multiple_concepts' => 'Suemodapad alik dalon labön suemodimiedeti te bali.',
	'smw_baduri' => 'Els URI ön fom: „$1“ no padälons.',
	'smw_iq_moreresults' => '... seks pluik',
	'smw_parseerror' => 'Völad pegivöl no pesuemon.',
	'smw_notitle' => '„$1“ no dalon pagebön as padanem in vük at.',
	'smw_wrong_namespace' => 'Te pades se nemaspad: „$1“ padälons ad binön is.',
	'smw_manytypes' => 'Sots plu bals pemiedetons pro patöf.',
	'smw_emptystring' => 'Vödems vagik no pelasumons.',
	'smw_notinenum' => '„$1“ no komon in lised völadas mögik ($2) patöfa at.',
	'smw_true_words' => 'veratik,v,si,s',
	'smw_false_words' => 'dobik,d,no,n',
	'smw_nofloat' => '„$1“ no binon num.',
	'smw_infinite' => 'Nums so gretik äs „$1“ no kanons pagebön.',
	'smw_nodatetime' => 'Dät: „$1“ no pesuemon.',
	'smw_emptysubquery' => 'Donaseivid semik no labon stipi lonöföl.',
	'smw_misplacedsubquery' => 'Donaseivid semik pägebon uto, kö donaseivids no padälons.',
	'smw_badqueryatom' => 'Dil semik: „<nowiki>[[…]]</nowiki>“ seivida no pesuemon.',
	'smw_propvalueproblem' => 'Völad patöfa: „$1“ no pesuemon.',
	'smw_notemplategiven' => 'Gevolös völadi paramete: „samafomot“, dat seividafomät at ojäfidon.',
	'smw_type_header' => 'Patöfs sota: „$1“',
	'smw_typearticlecount' => '{{PLURAL:$1|Patöf $1 pajonon, kel labon|Patöfs $1 pajonons, kels labons}} soti at.',
	'smw_attribute_header' => 'Pads patöfi: „$1“ geböls',
	'smw_attributearticlecount' => '{{PLURAL:$1|Pad $1 pajonon, kel gebon|Pads $1 pajonons, kels gebons}} patöfi at.',
	'smw_subproperty_header' => 'Donapatöfs',
	'smw_subpropertyarticlecount' => 'Patöf at labon {{PLURAL:$1|donapatöfi|donapatöfis}} sököl $1.', # Fuzzy
	'smw_concept_header' => 'Pads suemoda: „$1“.',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Pajonon pad $1, kel duton|Pajonons pads $1, kels dutons}} lü suemod at.',
	'exportrdf' => 'Seveigön padis at RDF',
	'properties' => 'Patöfs',
	'smw_properties_docu' => 'Patöfs sököl pagebons in vük.',
	'smw_property_template' => '$1 sota: $2 ($3)',
	'smw_propertylackspage' => 'Patöfs valik sötons pabepenön su pad semik!',
	'smw_propertyhardlyused' => 'Patöf at pagebon vemo selediko in vük!',
	'unusedproperties' => 'Patöfs no pegeböls',
	'smw_unusedproperties_docu' => 'Patöfs sököl dabinons, do pad votik nonik gebon onis.',
	'smw_unusedproperty_template' => '$1 sota: $2',
	'wantedproperties' => 'Patöfs pavilöl',
	'smw_wantedproperties_docu' => 'Patöfs sököl pagebons in vük ab no nog labons bepenamapadis oksik.',
	'smw_wantedproperty_template' => '$1 (gebs $2)', # Fuzzy
	'types' => 'Sots',
	'smw_ask_submit' => 'Tuvön sekis',
	'smw_ask_editquery' => '[Bevobön seividi]',
	'smw_add_sortcondition' => '[Läükön leodükamastipi]',
	'smw_ask_hidequery' => 'Klänedön seividi',
	'smw_ask_queryhead' => 'Seivid',
	'searchbyproperty' => 'Sukön ma patöf',
	'smw_sbv_docu' => 'Sukön padis valik patöfi e völadi semikis labölis.',
	'smw_sbv_novalue' => 'Penolös völadi lonöfol patöfa, u logolös patöfavöladis valik tefü „$1“.',
	'smw_sbv_displayresult' => 'Lised padas valik labü völad: „$2“ patöfa: „$1“.',
	'smw_sbv_displayresultfuzzy' => 'Lised padas valik labü völad: „$1“ patöfa: „$1“.
Bi petuvons pads te aniks, i völads nilöfik palisedons.', # Fuzzy
	'smw_sbv_property' => 'Patöf', # Fuzzy
	'smw_sbv_value' => 'Völad:',
	'smw_sbv_submit' => 'Tuvön sekis',
	'browse' => 'Padön vüki',
	'smw_browselink' => 'Logön patöfis',
	'smw_browse_article' => 'Penolös nemi pada, de kel padam oprimon.',
	'smw_browse_go' => 'Ledunön',
	'smw_browse_show_incoming' => 'jonön patöfis isio peyümölis',
	'smw_browse_hide_incoming' => 'klänedön patöfis isio peyümölis',
	'smw_browse_no_outgoing' => 'Pad at no labon patöfis.',
	'smw_browse_no_incoming' => 'Patöfs nonik peyümons lü pad at.',
	'smw_inverse_label_default' => '$1 de',
	'pageproperty' => 'Suk padapatöfas',
	'smw_pp_from' => 'De pad',
	'smw_pp_type' => 'Patöf',
	'smw_pp_submit' => 'Tuvön sekis',
	'smw_result_prev' => 'Büik',
	'smw_result_next' => 'Sököl',
	'smw_result_results' => 'Seks.',
	'smw_result_noresults' => 'Seks nonik.',
	'smw_smwadmin_return' => 'Geikön lü pad: $1',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 * @author පසිඳු කාවින්ද
 */
$messages['yi'] = array(
	'smw_finallistconjunct' => 'און',
	'smw_printername_list' => 'ליסטע',
	'smw_printername_category' => 'קאַטעגאָריע',
	'smw_nodatetime' => 'די דאַטע "$1" איז נישט פֿארשטענדלעך.',
	'smw_exportrdf_submit' => 'עקספארטירן',
	'smw_qui_formt' => 'פֿאָרמאַט:',
	'smw_qui_limt' => 'לימיט:',
	'smw_qui_randorder' => 'צופֿעליג',
	'smw_qui_delete' => 'אַראָפּנעמען',
	'smw_qui_options' => 'ברירות',
	'smw_qui_ok' => 'יא',
	'smw_qui_dcategory' => 'קאטעגאריע:',
	'smw_sbv_value' => 'ווערט:',
	'smw_browse_go' => 'גיין',
	'smw_result_prev' => 'פֿריערדיקער',
	'smw_result_results' => 'רעזולטאט',
);

/** Chinese (China) (‪中文(中国大陆)‬)
 * @author Roc Michael
 */
$messages['zh-cn'] = array(
	'smw_finallistconjunct' => '， 和',
	'smw_factbox_head' => '关于$1 的小文件',
	'smw_isspecprop' => '在此wiki系统内，此一性质为一种特殊性质',
	'smw_isaliastype' => '此一型态系为资料型态“$1＂的别称',
	'smw_isnotype' => '在此wiki系统内，此一“$1＂型态并非是一项标准的资料型态，并且尚未被用户赋予其定义',
	'smw_baduri' => '抱歉，在此处无法取得从“$1＂范围的，URIs. (译注原文为：Sorry, URIs of the form “$1＂ are not allowed.)',
	'smw_iq_disabled' => '抱歉，联机查询在此wiki已被设置为无效',
	'smw_iq_moreresults' => '&hellip; 高级查询',
	'smw_notitle' => '在此wiki内，是无法用“$1＂来当作页面名称的',
	'smw_unknowntype' => '不支持为性质所定义的“$1＂形态。',
	'smw_manytypes' => '定义此性质的型态已超过了一种以上。',
	'smw_emptystring' => '不接受空白字串。',
	'smw_maxstring' => '对本站而言，$1所代表的字串太长了。',
	'smw_notinenum' => '“$1＂ 并非在此属性有可能的值 ($2)的列表之中',
	'smw_noboolean' => '“$1＂无法被视为布林值(true/false)。',
	'smw_true_words' => '是,t,yes,y,true',
	'smw_false_words' => '否,f,no,n,false',
	'smw_nofloat' => '“$1＂ 并非为是数字',
	'smw_infinite' => '在此站内并不支持像是“$1＂如此庞大的数目字。',
	'smw_nodatetime' => '日期值“$1＂无法被识别，对日期值的支持目前尚属实验性质。',
	'smw_toomanyclosing' => '在此查询中“$1＂显然出现太多次了',
	'smw_noclosingbrackets' => '在您的查询中“[&#x005B;＂ 并未以对应的“]]＂来予以封闭',
	'smw_misplacedsymbol' => '“$1＂此一符号用于某项无用之处',
	'smw_unexpectedpart' => '查询的“$1＂部份无法被识别，可能会出现预料之外的结果',
	'smw_emptysubquery' => '某些子查询并不具备有效的查询条件',
	'smw_misplacedsubquery' => '某些子查询被用在不宜于使用子查询之处',
	'smw_valuesubquery' => '“$1＂质性的值并不适用于子查询',
	'smw_badqueryatom' => '在此查询中，部份的“[#x005B;&hellip]]＂无法被识别。',
	'smw_propvalueproblem' => '质性“$1＂的值无法被识别',
	'smw_nodisjunctions' => '在此wiki系统内分开查询是不被支持的，并有部份查询已被遗漏 ($1)。(译注原文为：Disjunctions in queries are not supported in this wiki and part of the query was dropped ($1).)',
	'smw_querytoolarge' => '基于此wiki系统对查询的规模及在深度方面的限制，以下的查询条件无法被接受：$1',
	'smw_type_header' => '“$1＂型态的性质',
	'smw_typearticlecount' => '以此型态显示 $1 性质',
	'smw_attribute_header' => '使用性质“$1＂的页面',
	'smw_attributearticlecount' => '以此性质显示$1页面.',
	'exportrdf' => '输出页面至RDF 。',
	'smw_exportrdf_docu' => '此一页面可让您获取RDF格式页面的资料，要输出页面，请在下方的文字框内键入页面的抬头，一项一行。',
	'smw_exportrdf_recursive' => '逐项输出所有的相关的页面，请注意输出的结果可能颇为庞大。',
	'smw_exportrdf_backlinks' => '并且输出与输出页面有关的页面，产生可供人阅读的RDF。(browsable RDF)',
	'smw_exportrdf_lastdate' => '无须输出那些在所设之时间点以后就未再被更动过的页面',
	'properties' => '性质',
	'smw_properties_docu' => '以下的性质已被用于此wiki内',
	'smw_property_template' => ' $1 　型态为：$2　使用次数：($3)',
	'smw_propertylackspage' => '所有的性质应以某一页面加以描述。',
	'smw_propertylackstype' => '此一性质尚未被指定形态，先暂定为$1型态。',
	'smw_propertyhardlyused' => '此一性质难以用于此wiki内',
	'unusedproperties' => '未使用的性质',
	'smw_unusedproperties_docu' => '下方的性质虽已存在，但无其他的页面使用它们。',
	'smw_unusedproperty_template' => '$2型态的$1',
	'wantedproperties' => '待建立的性质',
	'smw_wantedproperties_docu' => '下方的性质虽已用于此wiki内，但却未事先以任何页面去定义它们。',
	'smw_wantedproperty_template' => '$1 (已用于$2处)',
	'smw_purge' => '更新',
	'types' => '型态',
	'smw_types_docu' => '以下为所有资料型态的列表，资料型态可用于指定性质，每项资料型态皆有提供附加信息的页面。',
	'smw_typeunits' => '“$1＂型态的量测单位：$2',
	'semanticstatistics' => '语意统计(Semantic Statistics)',
	'smw_semstats_text' => '此wiki含有<b>$1</b>性质的值以用于总计<b>$2</b> 不同于 <a href="$3">性质</a>。 <b>$4</b>性质有着专属的专面，且预期所需的资料型态因着<b>$5</b>，而已被指定了，有些现有的性质也许为<a href="$6">未使用的性质</a>。您可在 <a href="$7">待建立的性质列表</a>中，找到那些尚未建立专属页面的性质。(译注原文为：This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.)',
	'ask' => '语意搜寻',
	'smw_ask_sortby' => '依栏位排序',
	'smw_ask_ascorder' => '升幂',
	'smw_ask_descorder' => '降幂',
	'smw_ask_submit' => '搜自导引结果',
	'smw_ask_editquery' => '[编辑查询]',
	'smw_ask_hidequery' => '隐藏查询',
	'smw_ask_help' => '查询协助',
	'smw_ask_queryhead' => '查询',
	'smw_ask_printhead' => '其他查询(选择性的)',
	'searchbyproperty' => '依性质搜寻',
	'smw_sbv_docu' => '依所指定的性质及其值来搜寻页面',
	'smw_sbv_novalue' => '请为该性质输入一项有效值，或请查阅“$1.＂的全部的性质的值',
	'smw_sbv_displayresult' => '所有“$1＂性质项目中，皆带有“$2＂值的页面列表',
	'smw_sbv_property' => '性质',
	'smw_sbv_value' => '值',
	'smw_sbv_submit' => '搜自导引结果',
	'browse' => '浏览wiki',
	'smw_browse_article' => '在开始浏览的表单中输入页面名称',
	'smw_browse_go' => '前往',
	'pageproperty' => '页面性质搜寻',
	'smw_pp_docu' => '搜寻某一页面全部性质的过滤条件，请同时输入页面及性质',
	'smw_pp_from' => '开始页面(From page)',
	'smw_pp_type' => '性质',
	'smw_pp_submit' => '搜自导引结果',
	'smw_result_prev' => '前一页',
	'smw_result_next' => '下一页',
	'smw_result_results' => '结果',
	'smw_result_noresults' => '抱歉，无您所要的结果。',
	'smw-createproperty-isproperty' => '这是$1型态的性质。',
	'smw-createproperty-allowedvals' => '此属性的可用型态为：',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Anakmalaysia
 * @author Gzdavidwong
 * @author Liangent
 * @author Linforest
 * @author Onecountry
 * @author PhiLiP
 * @author Richarddong
 * @author Xiaomingyan
 * @author Yanmiao liu
 * @author Yfdyh000
 */
$messages['zh-hans'] = array(
	'smw-desc' => "让你的wiki更可及——对机器''与''人都是如此（[http://semantic-mediawiki.org/wiki/Help:User_manual 在线文档]）",
	'smw_viewasrdf' => 'RDF源',
	'smw_finallistconjunct' => '和',
	'smw_factbox_head' => '关于 $1 的信息',
	'smw_isspecprop' => '此属性为维基中特殊属性',
	'smw_concept_description' => '概念"$1"的描述',
	'smw_no_concept_namespace' => '概念只能在Concept:名字空间中定义。',
	'smw_multiple_concepts' => '一个概念页面只能有一个概念定义。',
	'smw_concept_cache_miss' => '因为维基设置需要概念"$1"在离线时计算，此概念现在无法使用。
如果这个问题在一段时间后仍未解决，请向网站管理员请求令该概念可用。',
	'smw_noinvannot' => '不能为逆属性指定值。',
	'version-semantic' => '语义扩展',
	'smw_baduri' => '不允许"$1"形式的URI',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => '计数结果',
	'smw_printername_csv' => '导出为CSV',
	'smw_printername_dsv' => '导出为DSV',
	'smw_printername_debug' => 'Debug信息（专家适用）',
	'smw_printername_embedded' => '嵌入页面内容',
	'smw_printername_json' => '导出为JSON',
	'smw_printername_list' => '列表',
	'smw_printername_ol' => '有序列表项目',
	'smw_printername_ul' => '无序列表项目',
	'smw_printername_rss' => '导出为RSS',
	'smw_printername_table' => '表格',
	'smw_printername_broadtable' => '宽表格',
	'smw_printername_template' => '模板',
	'smw_printername_rdf' => '导出为RDF',
	'smw_printername_category' => '类别',
	'smw-paramdesc-limit' => '返回结果最大数目',
	'smw-paramdesc-offset' => '第一个结果的偏移量',
	'smw-paramdesc-headers' => '显示头/属性名称',
	'smw-paramdesc-mainlabel' => '首页名称的标签',
	'smw-paramdesc-link' => '以链接形式显示值',
	'smw-paramdesc-intro' => '查询结果前显示的文字',
	'smw-paramdesc-outro' => '查询结果后显示的文字',
	'smw-paramdesc-default' => '查询结果为空时显示的文字',
	'smw-paramdesc-sep' => '值的分隔符',
	'smw-paramdesc-distribution' => '不是显示所有值，而是计算并显示出现的次数。',
	'smw-paramdesc-distributionsort' => '按出现次数排序值的分布。',
	'smw-paramdesc-distributionlimit' => '将值的分布限制在某些值的计数。',
	'smw-paramdesc-template' => '输出显示模板的名称',
	'smw-paramdesc-columns' => '结果显示列数（默认为$1）',
	'smw-paramdesc-userparam' => '使用模板时，向模板传递的值',
	'smw-paramdesc-introtemplate' => '用于在查询结果前显示内容的模板的名称',
	'smw-paramdesc-outrotemplate' => '用于在查询结果后显示内容的模板的名称',
	'smw-paramdesc-embedformat' => '定义标题的HTML标签',
	'smw-paramdesc-embedonly' => '不显示标题',
	'smw-paramdesc-table-class' => '添加的设置表的CSS类',
	'smw-paramdesc-rsstitle' => '源标题文字',
	'smw-paramdesc-rssdescription' => '源描述文字',
	'smw-paramdesc-rdfsyntax' => '需要用到的RDF语法',
	'smw-paramdesc-csv-sep' => '要使用的分隔符',
	'smw-paramdesc-dsv-separator' => '要使用的分隔符',
	'smw-paramdesc-dsv-filename' => 'DSV文件名称',
	'smw-smwdoc-description' => '显示所有参数的表，它们可以与默认值和描述一起用于指定的结果格式。',
	'smw-smwdoc-par-format' => '显示参数文档的结果格式。',
	'smw-smwdoc-par-parameters' => '要显示哪些参数。"specific"（专用）表示该格式所添加那些的，"base"（基础）表示所有格式当中可用的那些，而"all"（全部）表示两种情况具有。',
	'smw-paramdesc-sort' => '排序查询的属性',
	'smw-paramdesc-order' => '查询排序的顺序',
	'smw-paramdesc-searchlabel' => '继续搜索的文本（默认是 «… further results»）', # Fuzzy
	'smw-paramdesc-named_args' => '请指定传递给该模板的变量',
	'smw_iq_disabled' => '此维基的语义查询已禁用',
	'smw_iq_moreresults' => '更多结果',
	'smw_parseerror' => '输入的值无法理解。',
	'smw_notitle' => '"$1"不得被用做此维基的页面名称。',
	'smw_noproperty' => '"$1"不能用作此维基中的一个属性名称。',
	'smw_wrong_namespace' => '仅允许名字空间“$1”中的页面。',
	'smw_manytypes' => '此属性定义了一种以上类型。',
	'smw_emptystring' => '不接受空字符串。',
	'smw_maxstring' => '代表$1的字符串长度过大。',
	'smw_notinenum' => '"$1" 不在此属性允许值列表（$2）中。',
	'smw_noboolean' => '"$1"不是布尔（是非）值',
	'smw_true_words' => 'true,t,yes,y,是,真,对',
	'smw_false_words' => 'false,f,no,n,否,假,错',
	'smw_nofloat' => '"$1"不是数字。',
	'smw_infinite' => '"$1"数值过大，无法支持。',
	'smw_unitnotallowed' => '"$1"未被声明为此属性的一个有效的度量单位。',
	'smw_nounitsdeclared' => '此属性没有声明任何度量单位。',
	'smw_novalues' => '未设置数值。',
	'smw_nodatetime' => '无法理解日期"$1"',
	'smw_toomanyclosing' => '查询中"$1"过多。',
	'smw_noclosingbrackets' => '你的查询中有未匹配"]]"的"<nowiki>[[</nowiki>"。',
	'smw_misplacedsymbol' => '符号"$1"的位置无效。',
	'smw_unexpectedpart' => '查询的"$1"部分无法理解。
结果可能与预料的不同。',
	'smw_emptysubquery' => '一些子查询状态无效。',
	'smw_misplacedsubquery' => '一些子查询被用于禁止位置。',
	'smw_valuesubquery' => '不支持对属性"$1"值的子查询',
	'smw_badqueryatom' => '查询的一些部分"<nowiki>[[…]]</nowiki>" 无法理解。',
	'smw_propvalueproblem' => '属性"$1"的值无法理解。',
	'smw_noqueryfeature' => '此维基不支持一些查询功能，查询被部分停止（$1）。',
	'smw_noconjunctions' => '此维基不支持查询中的合取，查询被部分停止（$1）。',
	'smw_nodisjunctions' => '此维基不支持查询中的析取，查询被部分停止（$1）。',
	'smw_querytoolarge' => '由于维基对查询长度和深度的限制，以下查询状态无法包含：$1',
	'smw_notemplategiven' => '为使查询格式正常工作，请为参数“模板”赋值。',
	'smw_db_sparqlqueryproblem' => '无法从SPARQL数据库获得查询结果。这个错误可能是暂时的，也可能是数据库软件的错误造成的。',
	'smw_db_sparqlqueryincomplete' => '本查询太过复杂因而被中止，可能会因此丢失部分结果。如果可能，请尝试改用一个较简单的查询。',
	'smw_type_header' => '类型"$1"的属性',
	'smw_typearticlecount' => '使用此类型显示 $1 {{PLURAL:$1|property|属性}}',
	'smw_attribute_header' => '使用属性 "$1" 的页面',
	'smw_attributearticlecount' => '使用此属性显示 $1 {{PLURAL:$1|page|页面}}',
	'smw_subproperty_header' => '子属性',
	'smw_subpropertyarticlecount' => '此属性有以下 $1 {{PLURAL:$1|subproperty|子属性}}:',
	'smw_concept_header' => '概念"$1"的页面',
	'smw_conceptarticlecount' => '显示属于此概念的$1 {{PLURAL:$1|page|页面}}。',
	'exportrdf' => '输出页面至RDF',
	'smw_exportrdf_docu' => '这个页面用于以RDF格式获得页面数据。
在下方文本框中输入标题以导出页面，每行一个标题。',
	'smw_exportrdf_recursive' => '递归导出所有相关页面。
注意：结果文件会很大。',
	'smw_exportrdf_backlinks' => '同时导出与导出页面相关的所有页面。
生成可浏览的RDF。',
	'smw_exportrdf_lastdate' => '不要导出自给定时间后无更改的页面。',
	'smw_exportrdf_submit' => '导出',
	'uriresolver' => 'URI解析器',
	'properties' => '属性',
	'smw_properties_docu' => '本维基使用以下属性。',
	'smw_property_template' => '类型为$2的属性$1（出现$3次）',
	'smw_propertylackspage' => '所有属性均应有一个页面描述！',
	'smw_propertylackstype' => '此属性未指定类型（目前默认为类型$1）',
	'smw_propertyhardlyused' => '此属性在本维基中不常使用。',
	'unusedproperties' => '未使用特性',
	'smw_unusedproperties_docu' => '以下属性在本维基中存在但未被使用。',
	'smw_unusedproperty_template' => '类型为$2的属性$1',
	'wantedproperties' => '需要的属性',
	'smw_wantedproperties_docu' => '以下属性已在本维基中使用，但是尚未创建描述页面。',
	'smw_wantedproperty_template' => '$1（$2{{PLURAL:$2|次使用}}）',
	'smw_purge' => '更新',
	'types' => '类型',
	'smw_types_docu' => '以下列出了可被赋予属性的所有数据类型。',
	'semanticstatistics' => '语义统计',
	'smw_semstats_text' => "此维基包含 '''$1''' 个属性{{PLURAL:$1|值|值}}，源自 '''$2''' 个[[Special:Properties|{{PLURAL:$2|属性|不同属性}}]]。'''$3''' 个{{PLURAL:$3|属性有|属性有}}自己的页，并且预期的数据类型被指定为 '''$4'''。某些已经存在的属性也许是[[Special:UnusedProperties|无用属性]]。缺乏页的属性可以在[[Special:WantedProperties|需要的属性列表]]中找到。",
	'smw_uri_doc' => 'URI 分析器实现<a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C httpRange-14 标记查找</a>。它将处理那些没有网站内容的页。',
	'ask' => '语义搜索',
	'smw_ask_sortby' => '按列排序（可选）',
	'smw_ask_ascorder' => '升序',
	'smw_ask_descorder' => '降序',
	'smw_ask_submit' => '搜索结果',
	'smw_ask_editquery' => '[编辑查询]',
	'smw_add_sortcondition' => '[添加排序条件]',
	'smw_ask_hidequery' => '隐藏查询',
	'smw_ask_help' => '查询帮助',
	'smw_ask_queryhead' => '查询',
	'smw_ask_printhead' => '需要显示的附加信息',
	'smw_ask_printdesc' => '（每行添加一个查询名）',
	'smw_ask_format_as' => '格式：',
	'smw_ask_defaultformat' => '默认',
	'smw_ask_otheroptions' => '其他选项',
	'smw_ask_show_embed' => '显示嵌入代码',
	'smw_ask_hide_embed' => '隐藏嵌入的代码',
	'smw_ask_embed_instr' => '使用以下代码将查询嵌入维基页面。',
	'querycreator' => '问题创建器',
	'smw_qc_addmainlabel' => '添加主标签',
	'smw_qc_show_addnal_opts' => '显示更多选项',
	'smw_qc_hide_addnal_opts' => '显示少些选项',
	'smw_qc_otheropt' => '其他选项',
	'smw_qc_intro' => '前缀：',
	'smw_qc_outro' => '后缀：',
	'smw_qc_default' => '默认：',
	'smw_qc_formatopt' => '格式选项',
	'smw_qc_query_help' => '用下面的表单输入查询。选择基于类别（<strong>[[{{ns:category}}:Actor]]</strong>）、属性（<strong>[[Located in::Germany]]</strong>）、名称（<strong>[[Germany]]</strong>）和命名空间（<strong>[[{{ns:help}}:+]]</strong>）的维基页', # Fuzzy
	'smw_qui_property' => '<strong>属性</strong>',
	'smw_qui_prop' => '属性：',
	'smw_qui_labl' => '标签：',
	'smw_qui_formt' => '格式：',
	'smw_qui_limt' => '限制：',
	'smw_qui_shownresults' => '在结果中显示',
	'smw_qui_noquery' => '未指定查询',
	'smw_qui_invalidprop' => '"$1" 可能不是有效属性',
	'smw_qui_invalidformat' => '选定格式 "$1" 在此维基中不存在',
	'smw_qui_nosort' => '无排序',
	'smw_qui_ascorder' => '升序',
	'smw_qui_descorder' => '降序',
	'smw_qui_randorder' => '随机',
	'smw_qui_addnprop' => '添加属性',
	'smw_qui_delete' => '删除',
	'smw_qui_rescol' => '查询匹配',
	'smw_qui_options' => '选项',
	'smw_qui_addcategory' => '添加类别',
	'smw_qui_addrescol' => '添加查询匹配',
	'smw_qui_ok' => '确定',
	'smw_qui_cancel' => '取消',
	'smw_qui_category' => '<strong>类别</strong>',
	'smw_qui_label' => '标签',
	'smw_prp_options' => '属性选项',
	'smw_qui_catopts' => '类别选项',
	'smw_qui_mainlabopts' => '结果选项',
	'smw_qui_dlabel' => '标签：',
	'smw_qui_dcategory' => '分类：',
	'smw_qui_dcatyes' => '有类别时显示文本：',
	'smw_qui_dcatno' => '无类别时显示文本：',
	'searchbyproperty' => '按属性查询',
	'smw_sbv_docu' => '搜索所有已设定属性和值的页面。',
	'smw_sbv_novalue' => '为此属性输入一个有效值，或者显示所有"$1"的属性值。',
	'smw_sbv_displayresult' => '有值为"$2"的属性"$1"的所有页面列表',
	'smw_sbv_displayresultfuzzy' => '有值为"$2"的属性"$1"的所有页面列表。
由于精确相符的页面不多，同时列出了部分有相似值的页面。',
	'smw_sbv_property' => '属性：',
	'smw_sbv_value' => '值：',
	'smw_sbv_submit' => '搜索',
	'browse' => '浏览维基',
	'smw_browselink' => '浏览属性',
	'smw_browse_article' => '请输入开始浏览的页面名称。',
	'smw_browse_go' => '提交',
	'smw_browse_show_incoming' => '显示链接到此页的属性',
	'smw_browse_hide_incoming' => '隐藏链接到此页的属性',
	'smw_browse_no_outgoing' => '这个页面没有设置属性。',
	'smw_browse_no_incoming' => '没有属性连接到此页。',
	'smw_inverse_label_default' => '的$1',
	'smw_inverse_label_property' => '逆属性标签',
	'pageproperty' => '页面属性搜索',
	'smw_pp_docu' => '在指定页面搜索某属性的所有值。
输入页面和属性。',
	'smw_pp_from' => '从页面',
	'smw_pp_type' => '属性',
	'smw_pp_submit' => '搜索结果',
	'smw_result_prev' => '上一个',
	'smw_result_next' => '下一个',
	'smw_result_results' => '结果',
	'smw_result_noresults' => '没有结果。',
	'smwadmin' => 'Semantic MediaWiki管理功能',
	'smw_smwadmin_setupsuccess' => '存储引擎设置成功。',
	'smw_smwadmin_return' => '返回到$1。',
	'smw_smwadmin_updatestarted' => '更新语义数据过程开始。
所有已存储数据将被按需重建或修复。
你可以通过本特殊页面跟踪更新进程。', # Fuzzy
	'smw_smwadmin_updatenotstarted' => '已有更新进程正在运行，请勿新建另一个。', # Fuzzy
	'smw_smwadmin_updatestopped' => '已停止所有更新进程。', # Fuzzy
	'smw_smwadmin_updatenotstopped' => '请勾选复选框，以确认确实希望终止正在运行的升级进程。', # Fuzzy
	'smw_smwadmin_docu' => '这个特殊页面为您安装和升级<a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>提供帮助。
请在执行管理功能前备份好数据。',
	'smw_smwadmin_db' => '数据库安装和升级',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki将MediaWiki数据库做一些扩展，以存储语义数据。
以下功能可帮助你正确设置数据库。
这个步骤所做的修改不会影响MediaWiki数据库的其他部分，如果需要，可以方便地撤销所做的修改。
这个设置功能可多次执行，不会造成任何危害。但是只需在安装或升级时执行一次即可。',
	'smw_smwadmin_permissionswarn' => '如果操作因SQL错误而失败，可能是维基的数据库用户（检查LocalSettings.php）没有相应权限。
你可以向该用户赋予创建和删除表格的权限，或临时将数据库根用户的登录信息输入LocalSettings.php。你也可以使用维护脚本<tt>SMW_setup.php</tt>，这个脚本可以使用AdminSettings.php中的信息。', # Fuzzy
	'smw_smwadmin_dbbutton' => '初始化或升级表格',
	'smw_smwadmin_announce' => '发布维基',
	'smw_smwadmin_announcedocu' => 'Semantic Mediawiki提供一个网络服务，用于公告新的语义维基网站。
这个服务用于维护一个使用Semantic MediaWiki的公共网站列表，主要用于帮助<a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki 项目</a>了解Semantic MediaWiki的典型使用的概貌。
<a href="http://semantic-mediawiki.org/wiki/SMW_Project">关于此服务的更多信息</a>请查看Semantic MediaWiki主页。',
	'smw_smwadmin_announcebutton' => '按下以下按钮以将你的维基网址提交给该服务。
这个服务只储存公众访问信息，不对公众无法访问的维基进行注册，',
	'smw_smwadmin_datarefresh' => '数据修复和升级',
	'smw_smwadmin_datarefreshdocu' => '可以基于维基先有内容对所有Semantic MediaWki数据进行重置。
这个功能对修复损坏的数据，或者在软件升级，内部格式改变时更新数据非常有用。
更新时逐页面执行的，需要一段时间。
下方将显示更新是否正在进行，并允许你开始或终止更新。（此功能可以被网站管理员禁用）',
	'smw_smwadmin_datarefreshprogress' => '<strong>有一个更新正在进行。</strong>
更新进程可能会很慢，因为该进程仅在用户访问维基时小块地更新数据。
可以使用MediaWiki维护脚本<tt>runJobs.php</tt>（使用选项 <tt>--maxjobs 1000</tt> 限制每批更新数目）来加快更新完成速度。
目前更新的估计进度：',
	'smw_smwadmin_datarefreshbutton' => '开始更新数据',
	'smw_smwadmin_datarefreshstop' => '停止更新',
	'smw_smwadmin_datarefreshstopconfirm' => '是的，我确认。',
	'smw_smwadmin_support' => '获得协助',
	'smw_smwadmin_supportdocu' => '遇到问题时，可以使用以下资源获得帮助：',
	'smw_smwadmin_installfile' => '如果安装遇到问题，请先仔细阅读<a href="https://gerrit.wikimedia.org/r/gitweb?p=mediawiki/extensions/SemanticMediaWiki.git;a=blob_plain;f=INSTALL;hb=HEAD">INSTALL文件</a>中的指引。',
	'smw_smwadmin_smwhomepage' => 'Semantic MediaWiki的完整用户文档请查阅 <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>。',
	'smw_smwadmin_mediazilla' => '程序问题请到<a href="https://bugzilla.wikimedia.org/">Bugzilla</a>报告。',
	'smw_smwadmin_questions' => '如果有问题或建议，可加入<a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki用户论坛</a>参与讨论。',
	'smw_adminlinks_datastructure' => '数据结构',
	'smw_adminlinks_displayingdata' => '数据显示',
	'smw_adminlinks_inlinequerieshelp' => '直接插入式查询帮助',
	'smw-createproperty-isproperty' => '这是一个类型为$1的属性。',
	'smw-createproperty-allowedvals' => '允许的{{PLURAL:$1|属性值为|属性值为}}：',
	'smw-paramdesc-category-delim' => '分隔符',
	'smw-paramdesc-category-template' => '格式化这些条目的模板',
	'smw-paramdesc-category-userparam' => '传递给模板的参数',
	'smw-info-par-message' => '显示的信息。',
	'smw-info-par-icon' => '显示的图标，“信息”或“警告”。',
	'smw_unknowntype' => '定义的属性类型"$1"不被支持。', # Fuzzy
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Anakmalaysia
 * @author Frankou
 * @author Gzdavidwong
 * @author Mark85296341
 * @author Oapbtommy
 * @author Sheepy
 * @author Simon Shek
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'smw-desc' => '讓你的維基更可及——對機器與人都是如此（[http://semantic-mediawiki.org/wiki/Help:User_manual 網上文檔]）',
	'smw_viewasrdf' => 'RDF 源',
	'smw_finallistconjunct' => '和',
	'smw_factbox_head' => '關於 $1 的事實',
	'smw_isspecprop' => '此屬性為維基中特殊屬性',
	'smw_concept_description' => '概念「$1」的描述',
	'smw_no_concept_namespace' => '概念只能在命名空間 Concept（概念）：下的頁面中定義。',
	'smw_multiple_concepts' => '一個概念頁面只允許有一個概念定義',
	'smw_concept_cache_miss' => '因為維基設定需要概念「$1」在離線時計算，此概念現在無法使用。
如果這個問題在一段時間後仍未解決，請向網站管理員請求令該概念可用。',
	'smw_noinvannot' => '不能為逆屬性指定值。',
	'version-semantic' => '語義擴展',
	'smw_baduri' => '不允許「$1」形式的 URI',
	'smw_dsv_link' => 'DSV',
	'smw_printername_count' => '計數結果',
	'smw_printername_csv' => '匯出為 CSV',
	'smw_printername_dsv' => '導出為DSV',
	'smw_printername_debug' => 'Debug 查詢（專家適用）',
	'smw_printername_embedded' => '嵌入頁面內容',
	'smw_printername_json' => '匯出為 JSON',
	'smw_printername_list' => '列表',
	'smw_printername_ol' => '有序列表項目',
	'smw_printername_ul' => '無序列表項目',
	'smw_printername_table' => '表格',
	'smw_printername_broadtable' => '寬表格',
	'smw_printername_template' => '模板',
	'smw_printername_rdf' => '導出為RDF',
	'smw_printername_category' => '類別',
	'smw-paramdesc-limit' => '返回結果最大數目',
	'smw-paramdesc-offset' => '第一個結果的偏移量',
	'smw-paramdesc-headers' => '顯示頭/屬性名稱',
	'smw-paramdesc-mainlabel' => '首頁名稱的標籤',
	'smw-paramdesc-link' => '以連結形式顯示值',
	'smw-paramdesc-intro' => '查詢結果前顯示的文字',
	'smw-paramdesc-outro' => '查詢結果後顯示的文字',
	'smw-paramdesc-default' => '查詢結果為空時顯示的文字',
	'smw-paramdesc-sep' => '值的分隔符',
	'smw-paramdesc-distribution' => '不是顯示所有值，而是計算並顯示出現的次數。',
	'smw-paramdesc-distributionsort' => '按出現次數排序值的分布。',
	'smw-paramdesc-distributionlimit' => '將值的分布限制在某些值的計數。',
	'smw-paramdesc-template' => '輸出顯示模板的名稱',
	'smw-paramdesc-columns' => '結果顯示列數（預設為 $1）',
	'smw-paramdesc-userparam' => '使用模板時，向模板傳遞的值',
	'smw-paramdesc-introtemplate' => '用於在查詢結果前顯示內容的模板的名稱',
	'smw-paramdesc-outrotemplate' => '用於在查詢結果後顯示內容的模板的名稱',
	'smw-paramdesc-embedformat' => '定義標題的 HTML 標籤',
	'smw-paramdesc-embedonly' => '不顯示標題',
	'smw-paramdesc-table-class' => '添加的設置表的CSS類',
	'smw-paramdesc-rdfsyntax' => '需要用到的RDF語法',
	'smw-paramdesc-csv-sep' => '要使用的分隔符',
	'smw-paramdesc-dsv-separator' => '要使用的分隔符',
	'smw-paramdesc-dsv-filename' => 'DSV文件名稱',
	'smw-smwdoc-description' => '顯示所有參數的表，它們可以與默認值和描述一起用於指定的結果格式。',
	'smw-smwdoc-par-format' => '顯示參數文檔的結果格式。',
	'smw-smwdoc-par-parameters' => '要顯示哪些參數。"specific"（專用）表示該格式所添加那些的，"base"（基礎）表示所有格式當中可用的那些，而"all"（全部）表示兩種情況具有。',
	'smw-paramdesc-sort' => '排序查詢的屬性',
	'smw-paramdesc-order' => '查詢排序的順序',
	'smw-paramdesc-searchlabel' => '在指向結果的連結中顯示的文字', # Fuzzy
	'smw-paramdesc-named_args' => '請指定傳遞給該模板的變量',
	'smw_iq_disabled' => '此 wiki 的語義查詢已被停用',
	'smw_iq_moreresults' => '更多結果',
	'smw_parseerror' => '輸入的值無法理解。',
	'smw_notitle' => '「$1」不得被用做此 wiki 的頁面名稱。',
	'smw_noproperty' => '"$1"不能用作此維基中的一個屬性名稱。',
	'smw_wrong_namespace' => '此處只允許名子空間「$1」中的頁面。',
	'smw_manytypes' => '此屬性定義了一種以上類型。',
	'smw_emptystring' => '不接受空字符串。',
	'smw_maxstring' => '代表 $1 的字符串長度過大。',
	'smw_notinenum' => '「$1」不在此屬性允許值列表（$2）中。',
	'smw_noboolean' => '「$1」不是布爾（是非）值',
	'smw_true_words' => 'true,t,yes,y,是,真,對',
	'smw_false_words' => 'false,f,no,n,否,假,錯',
	'smw_nofloat' => '「$1」不是一個數字。',
	'smw_infinite' => '「$1」數值過大，無法支援。',
	'smw_unitnotallowed' => '"$1"未被聲明為此屬性的一個有效的度量單位。',
	'smw_nounitsdeclared' => '此屬性沒有聲明任何度量單位。',
	'smw_novalues' => '未設定數值。',
	'smw_nodatetime' => '無法理解日期「$1」',
	'smw_toomanyclosing' => '查詢中「$1」過多。',
	'smw_noclosingbrackets' => '你的查詢中有未匹配"]]"的"<nowiki>[[</nowiki>"。',
	'smw_misplacedsymbol' => '符號「$1」的位置無效。',
	'smw_unexpectedpart' => '查詢的「$1」部分無法理解。
結果可能與預料的不同。',
	'smw_emptysubquery' => '一些子查詢狀態無效。',
	'smw_misplacedsubquery' => '一些子查詢被用於禁止位置。',
	'smw_valuesubquery' => '不支持對屬性「$1」值的子查詢',
	'smw_badqueryatom' => '查詢的一些部分「<nowiki>[[…]]</nowiki>」無法理解。',
	'smw_propvalueproblem' => '屬性「$1」的值無法理解。',
	'smw_noqueryfeature' => '此 wiki 不支援一些查詢功能，查詢被部分停止（$1）。',
	'smw_noconjunctions' => '此 wiki 不支援查詢中的合取，查詢被部分停止（$1）。',
	'smw_nodisjunctions' => '此 wiki 不支援查詢中的析取，查詢被部分停止（$1）。',
	'smw_querytoolarge' => '由於 wiki 對查詢長度和深度的限制，以下查詢狀態無法包含：$1',
	'smw_notemplategiven' => '為使查詢格式正常工作，請為參數「模板」賦值。',
	'smw_db_sparqlqueryproblem' => '無法從SPARQL數據庫獲得查詢結果。這個錯誤可能是暫時的，也可能是數據庫軟件的錯誤造成的。',
	'smw_db_sparqlqueryincomplete' => '本查詢太過複雜因而被中止，可能會因此丟失部分結果。如果可能，請嘗試改用一個較簡單的查詢。',
	'smw_type_header' => '類型「$1」的屬性',
	'smw_typearticlecount' => '使用此類型顯示 $1 {{PLURAL:$1|property|屬性}}',
	'smw_attribute_header' => '使用屬性「$1」的頁面',
	'smw_attributearticlecount' => '使用此屬性顯示 $1 {{PLURAL:$1|page|頁面}}',
	'smw_subproperty_header' => '子屬性',
	'smw_subpropertyarticlecount' => '此屬性有以下 $1 {{PLURAL:$1|subproperty|子屬性}}:',
	'smw_concept_header' => '概念「$1」的頁面',
	'smw_conceptarticlecount' => '顯示屬於此概念的 $1 {{PLURAL:$1|page|頁面}}。',
	'exportrdf' => '輸出頁面到 RDF',
	'smw_exportrdf_docu' => '這個頁面用於以 RDF 格式獲得頁面數據。
在下方文字框中輸入標題以匯出頁面，每行一個標題。',
	'smw_exportrdf_recursive' => '遞歸匯出所有相關頁面。
注意：結果檔案會很大。',
	'smw_exportrdf_backlinks' => '同時匯出與匯出頁面相關的所有頁面。
生成可瀏覽的 RDF。',
	'smw_exportrdf_lastdate' => '不要匯出自給定時間後無更改的頁面。',
	'smw_exportrdf_submit' => '匯出',
	'uriresolver' => 'URI 解析器',
	'properties' => '屬性',
	'smw_properties_docu' => '本 wiki 使用以下屬性。',
	'smw_property_template' => '類型為 $2 的屬性 $1（出現 $3 次）', # Fuzzy
	'smw_propertylackspage' => '所有屬性均應有一個頁面描述！',
	'smw_propertylackstype' => '此屬性未指定類型（目前預設為類型 $1）',
	'smw_propertyhardlyused' => '此屬性在本 wiki 中不常使用。',
	'unusedproperties' => '未使用的屬性',
	'smw_unusedproperties_docu' => '以下屬性在本 wiki 中存在但未被使用。',
	'smw_unusedproperty_template' => '類型為 $2 的屬性 $1',
	'wantedproperties' => '需要的屬性',
	'smw_wantedproperties_docu' => '以下屬性已在本 wiki 中使用，但是尚未建立描述頁面。',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|use|使用}})',
	'smw_purge' => '重新整理',
	'types' => '類型',
	'smw_types_docu' => '以下列出了可被賦予屬性的所有數據類型。',
	'semanticstatistics' => '語意統計',
	'smw_semstats_text' => "此維基包含 '''$1''' 個屬性{{PLURAL:$1|值|值}}，源自 '''$2''' 個[[Special:Properties|{{PLURAL:$2|屬性|不同屬性}}]]。'''$3''' 個{{PLURAL:$3|屬性有|屬性有}}自己的頁，並且預期的數據類型被指定為 '''$4'''。某些已經存在的屬性也許是[[Special:UnusedProperties|無用屬性]]。缺乏頁的屬性可以在[[Special:WantedProperties|需要的屬性列表]]中找到。",
	'smw_uri_doc' => 'URI 分析器實現<a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C httpRange-14 標記查找</a>。它將處理那些沒有網站內容的頁。', # Fuzzy
	'ask' => '語意搜尋',
	'smw_ask_sortby' => '按列排序（可選）',
	'smw_ask_ascorder' => '升冪',
	'smw_ask_descorder' => '降冪',
	'smw_ask_submit' => '搜尋結果',
	'smw_ask_editquery' => '[編輯查詢]',
	'smw_add_sortcondition' => '[增加排序條件]',
	'smw_ask_hidequery' => '隱藏查詢',
	'smw_ask_help' => '查詢幫助',
	'smw_ask_queryhead' => '查詢',
	'smw_ask_printhead' => '需要顯示的附加資料',
	'smw_ask_printdesc' => '（每行增加一個查詢名）',
	'smw_ask_format_as' => '格式為：',
	'smw_ask_defaultformat' => '預設',
	'smw_ask_otheroptions' => '其他選項',
	'smw_ask_show_embed' => '顯示嵌入代碼',
	'smw_ask_hide_embed' => '隱藏嵌入的代碼',
	'smw_ask_embed_instr' => '使用以下代碼將查詢嵌入維基頁面。',
	'querycreator' => '問題創建器',
	'smw_qc_addmainlabel' => '添加主標籤',
	'smw_qc_show_addnal_opts' => '顯示更多選項',
	'smw_qc_hide_addnal_opts' => '顯示少些選項',
	'smw_qc_otheropt' => '其他選項',
	'smw_qc_intro' => '前綴：',
	'smw_qc_outro' => '後綴：',
	'smw_qc_default' => '默認：',
	'smw_qc_formatopt' => '格式選項',
	'smw_qui_property' => '<strong>屬性</strong>',
	'smw_qui_prop' => '屬性：',
	'smw_qui_labl' => '標籤：',
	'smw_qui_formt' => '格式：',
	'smw_qui_limt' => '限制：',
	'smw_qui_shownresults' => '在結果中顯示',
	'smw_qui_noquery' => '未指定查詢',
	'smw_qui_invalidprop' => '"$1" 可能不是有效屬性',
	'smw_qui_invalidformat' => '選定格式 "$1" 在此維基中不存在',
	'smw_qui_nosort' => '無排序',
	'smw_qui_ascorder' => '升序',
	'smw_qui_descorder' => '降序',
	'smw_qui_randorder' => '隨機',
	'smw_qui_addnprop' => '添加屬性',
	'smw_qui_delete' => '刪除',
	'smw_qui_rescol' => '查詢匹配',
	'smw_qui_options' => '選項',
	'smw_qui_addcategory' => '添加類別',
	'smw_qui_addrescol' => '添加查詢匹配',
	'smw_qui_ok' => '確定',
	'smw_qui_cancel' => '取消',
	'smw_qui_category' => '<strong>類別</strong>',
	'smw_qui_label' => '標籤',
	'smw_prp_options' => '屬性選項',
	'smw_qui_catopts' => '類別選項',
	'smw_qui_mainlabopts' => '結果選項',
	'smw_qui_dlabel' => '標籤：',
	'smw_qui_dcategory' => '分類：',
	'smw_qui_dcatyes' => '有類別時顯示文本：',
	'smw_qui_dcatno' => '無類別時顯示文本：',
	'searchbyproperty' => '按屬性查詢',
	'smw_sbv_docu' => '搜尋所有已設定屬性和值的頁面。',
	'smw_sbv_novalue' => '為此屬性輸入一個有效值，或者顯示所有「$1」的屬性值。',
	'smw_sbv_displayresult' => '有值為「$2」的屬性「$1」的所有頁面列表',
	'smw_sbv_displayresultfuzzy' => '有值為「$2」的屬性「$1」的所有頁面列表。
由於精確相符的頁面不多，同時列出了部分有相似值的頁面。',
	'smw_sbv_property' => '屬性：',
	'smw_sbv_value' => '值：',
	'smw_sbv_submit' => '搜尋結果',
	'browse' => '瀏覽維基',
	'smw_browselink' => '瀏覽屬性',
	'smw_browse_article' => '輸入瀏覽起始頁面名稱。',
	'smw_browse_go' => '進入',
	'smw_browse_show_incoming' => '顯示連結到此頁的屬性',
	'smw_browse_hide_incoming' => '隱藏連結到此頁的屬性',
	'smw_browse_no_outgoing' => '這個頁面沒有設定屬性。',
	'smw_browse_no_incoming' => '沒有屬性連結到此頁。',
	'smw_inverse_label_default' => '的 $1',
	'smw_inverse_label_property' => '逆屬性標籤',
	'pageproperty' => '頁面屬性搜尋',
	'smw_pp_docu' => '在指定頁面搜尋某屬性的所有值。
輸入頁面和屬性。',
	'sm