<?php
/**
 * Internationalization file for the Semantic Forms extension
 *
 * @file
 * @ingroup Extensions
 * @ingroup SF
 */

$messages = array();

/** English
 * @author Yaron Koren
 */
$messages['en'] = array(
	// user messages
	'semanticforms-desc'                 => 'Forms for adding and editing semantic data',
	'specialpages-group-sf_group'        => 'Semantic Forms',
	'createproperty'                     => 'Create a property',
	'sf-createproperty-with-name'        => 'Create property: $1',
	'sf_createproperty_linktoform'       => 'This property will link to pages that use the form:',
	'sf_createproperty_allowedvalsinput' => 'If you want this property to only be allowed to have certain values, enter the list of allowed values, separated by commas (if a value contains a comma, replace it with "\,"):',
	'sf_createproperty_propname'         => 'Property name:',
	'sf_createproperty_proptype'         => 'Type:',
	'templates'                          => 'Templates',
	'sf_templates_docu'                  => 'The following templates exist in the wiki.',
	'sf_templates_definescat'            => 'defines category: $1',
	'createtemplate'                     => 'Create a template',
	'sf-createtemplate-with-name'        => 'Create template: $1',
	'sf_createtemplate_namelabel'        => 'Template name:',
	'sf_createtemplate_multipleinstance' => 'This template can be included multiple times on the page.',
	'sf_createtemplate_categorylabel'    => 'Category defined by template (optional):',
	'sf_createtemplate_templatefields'   => 'Template fields',
	'sf_createtemplate_fieldsdesc'       => 'To have the fields in this template no longer require field names, simply enter the index of each field (e.g. 1, 2, 3, etc.) as the name, instead of an actual name.',
	'sf_createtemplate_fieldname'        => 'Field name:',
	'sf_createtemplate_displaylabel'     => 'Display label:',
	'sf_createtemplate_semanticproperty' => 'Semantic property:',
	'sf_createtemplate_fieldislist'      => 'This field can hold a list of values, separated by commas',
	'sf_createtemplate_aggregation'      => 'Aggregation',
	'sf_createtemplate_aggregationdesc'  => 'To list, on any page using this template, all of the pages that have a certain property pointing to that page, specify the appropriate property below:',
	'sf_createtemplate_aggregationlabel' => 'Title for list:',
	'sf_createtemplate_outputformat'     => 'Output format:',
	'sf_createtemplate_standardformat'   => 'Table',
	'sf_createtemplate_infoboxformat'    => 'Side infobox',
	'sf_createtemplate_plainformat'      => 'Plain text',
	'sf_createtemplate_sectionsformat'   => 'Sections',
	'sf_createtemplate_addfield'         => 'Add field',
	'sf_createtemplate_deletefield'      => 'Delete',
	'sf_createtemplate_addtemplatebeforesave' => 'You must add at least one template to this form before you can save it.',
	'forms'                              => 'Forms',
	'sf_forms_docu'                      => 'The following forms exist in the wiki.',
	'sf_forminputs_mandatory'            => 'A value must be entered for this input',
	'sf_forminputs_restricted'           => 'Only administrators can edit this input',
	'sf_forminputs_class'                => 'The HTML "class" attribute for this input',
	'sf_forminputs_default'              => 'The default value for this input',
	'sf_forminputs_preload'              => 'A wiki page whose contents will become this input\'s default value',
	'sf_forminputs_property'             => 'A semantic property that this field corresponds to',
	'sf_forminputs_size'                 => 'The size of this text field, in characters',
	'sf_forminputs_maxlength'            => 'The maximum allowed length of the text in this field',
	'sf_forminputs_placeholder'          => 'Help text that appears in the input until the user clicks on it',
	'sf_forminputs_uploadable'           => 'Place an "{{int:upload}}" link next to this input',
	'sf_forminputs_defaultfilename'      => 'The default filename for uploaded files',
	'sf_forminputs_rows'                 => 'The number of rows for this input',
	'sf_forminputs_cols'                 => 'The number of columns for this input',
	'sf_forminputs_autogrow'             => 'Set this input to grow in size if the text exceeds its boundaries',
	'sf_forminputs_valuesfromproperty'   => 'A property whose values in the wiki should be this input\'s set of values',
	'sf_forminputs_valuesfromcategory'   => 'A category whose pages should be this input\'s set of values',
	'sf_forminputs_valuesfromnamespace'  => 'A namespace whose pages should be this input\'s set of values',
	'sf_forminputs_valuesfromconcept'    => 'A Semantic MediaWiki "concept" page whose pages should be this input\'s set of values',
	'sf_forminputs_valuesfromurl'        => 'A URL holding structured data that should be this input\'s set of values',
	'sf_forminputs_values'               => 'The set of values for this input, separated by commas',
	'sf_forminputs_list'                 => 'Mark this input as holding a list of values',
	'sf_forminputs_delimiter'            => 'The delimiter between field values, if this input holds a list of them',
	'sf_forminputs_remoteautocompletion' => 'Use remote autocompletion',
	'sf_forminputs_existingvaluesonly'   => 'Allow only values already in the list',
	'sf_forminputs_showonselect'         => 'Page elements to display only if certain values are selected (example: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize'          => 'The height of this listbox, in rows',
	'sf_forminputs_includetimezone'      => 'Include an input for the time zone',
	'sf_forminputs_topcategory'          => 'The parent category of this set of categories (required)',
	'sf_forminputs_hideroot'             => 'Hide the parent category',
	'sf_forminputs_depth'                => 'The number of levels of categories to show initially',
	'sf_forminputs_height'               => 'The height of this input, in pixels',
	'sf_forminputs_width'                => 'The width of this input, in pixels',
	'createform'                         => 'Create a form',
	'sf-createform-with-name'            => 'Create form: $1',
	'sf_createform_nameinput'            => 'Form name',
	'sf_createform_nameinputdesc'        => '(the form is usually given the same name as its main template):',
	'sf_createform_template'             => 'Template:',
	'sf_createform_templatelabelinput'   => 'Template label (optional):',
	'sf_createform_allowmultiple'        => 'Allow for multiple (or zero) instances of this template in the created page',
	'sf_createform_field'                => 'Field:',
	'sf_createform_fieldprop'            => 'This field defines the property $1, of type $2.',
	'sf_createform_fieldproplist'        => 'This field defines a list of elements that have the property $1, of type $2.',
	'sf_createform_fieldpropunknowntype' => 'This field defines the property $1, of unspecified type.',
	'sf_createform_inputtype'            => 'Input type:',
	'sf_createform_inputtypedefault'     => '(default)',
	'sf_createform_formlabel'            => 'Form label:',
	'sf_createform_hidden'               => 'Hidden',
	'sf_createform_removetemplate'       => 'Remove template',
	'sf_createform_addtemplate'          => 'Add template:',
	'sf_createform_beforetemplate'       => 'Before template:',
	'sf_createform_atend'                => 'At end',
	'sf_createform_add'                  => 'Add',
	'sf_createform_choosefield'          => 'Choose a field to add',
	'createcategory'                     => 'Create a category',
	'sf-createcategory-with-name'        => 'Create category: $1',
	'sf_createcategory_name'             => 'Category name:',
	'sf_createcategory_defaultform'      => 'Default form:',
	'sf_createcategory_makesubcategory'  => 'Make this a subcategory of another category (optional):',
	'createclass'                        => 'Create a class',
	'sf_createclass_docu'                => 'Enter all the data here to create the properties, template, form and category for a single class. For more options, use the pages $1 instead.',
	'sf_createclass_allowedvalues'       => 'Allowed values:',
	'sf_createclass_listofvalues'        => 'List of values?',
	'sf_createclass_nameinput'           => 'Form name:',
	'sf_createclass_missingvalues'       => 'Not all required fields were filled out.',
	'sf_createclass_success'             => 'Properties, template, form and category will be created.',
	'sf_createclass_create'              => 'Create',
	'formstart'                          => 'Start of form',
	'sf_formstart_badform'               => 'Error: No form was found on page "$1".',
	'sf_formstart_badtitle'              => 'Error: "$1" is an invalid page title.',
	'sf_formstart_docu'                  => 'Enter the name of a page here, to be edited with the form "$1".
If this page already exists, you will be sent to the form for editing that page.
Otherwise, you will be sent to the form for adding the page.',
	'sf_formstart_noform_docu'           => 'Enter the name of a page here, and select the form to edit it with.
If this page already exists, you will be sent to the form for editing that page.
Otherwise, you will be sent to the form for adding the page.',
	'sf_formstart_createoredit'          => 'Create or edit',
	'formedit'                           => 'Edit with form',
	'sf_formedit_createtitle'            => 'Create $1: $2',
	'sf_formedit_createtitlenotarget'    => 'Create $1',
	'sf_formedit_badurl'                 => 'This is the page for editing with a form. You must specify both a form name and a target page in the URL;
it should look like "Special:FormEdit?form=<form name>&target=<target page>", or  "Special:FormEdit/<form name>/<target page>".',
	'sf_formedit_altforms'               => 'You can instead add this page with one of the following forms:',
	'sf_formedit_altformsonly'           => 'Please select from one of the following forms to add this page:',
	'sf_formcreate'                      => 'Create with form',
	'sf_viewform'                        => 'View form',
	'sf_editsource'                      => 'Edit source',
	'sf_formedit_edittitle'              => 'Edit $1: $2',
	'sf_formedit_morethanoneform'        => "'''Warning:''' More than one default form is defined for this page.",
	'sf_formedit_formwarning'            => 'Warning: This page <a href="$1">already exists</a>, but it does not use this form.',
	'sf_formedit_mismatchedbrackets'     => 'Warning: This page contains curly or square brackets that are not closed, so the page will not be handled correctly by the form. Please <a href="$1">fix the error in the source text</a> before proceeding.',
	'sf_formedit_remove'                 => 'Remove this instance',
	'sf_formedit_addanotherabove'        => 'Add another instance above this one',
	'sf_formedit_addanother'             => 'Add another',
	'sf_formedit_none'                   => 'None',
	'sf_formedit_emptytitle'             => 'Error: The inserted data results in an empty page title.',
	'sf_formedit_hookerror'              => 'Error: A MediaWiki extension prevented the modification of the target page.',
	'sf_formedit_saveandcontinueediting' => 'Save and continue',
	'sf_formedit_saveandcontinue_summary'=> 'Saved using "$1" button in form',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Save data and continue editing',
	'sf_formedit_accesskey_saveandcontinueediting' => 'a',
	'sf_autoedit_anoneditwarning'        => 'Warning: You are not logged in. Your IP address will be recorded in this page\'s edit history.',
	'sf_autoedit_success'                => 'Successfully modified [[$1]] using form $2.',
	'sf_autoedit_fail'                   => 'Modifying [[$1]] failed.',
	'sf_autoedit_notargetspecified'      => "No target page specified.",
	'sf_autoedit_invalidtargetspecified' => 'The specified target page $1 is invalid.',
	'sf_autoedit_invalidform'            => '$1 is not a valid form.',
	'sf_autoedit_redirectlimitexeeded'   => 'The maximum redirect limit for form $1 was exceeded.',
	'sf_autoedit_invalidredirecttarget'  => '$1 is an invalid redirect target for form $2.',
	'sf_autoedit_invalidpreloadspecified'=> 'The specified preload page $1 is invalid.',
	'sf_autoedit_redlinkexists'          => '$1 already exists.',
	'sf_autoedit_noformfound'            => "No form specified.",
	'sf_autoedit_toomanyformsfound'      => "More than one form available for page.",
	'sf_autoedit_readonly'               => "The database is currently locked to modifications. Reason: $1",
	'sf_autoedit_nosemanticform'         => "Could not get form $2 for page $1. See [[{{#special:FormEdit}}/$2/$1]] for details.",
	'sf_autoedit_summary'                => "Edited automatically from page $1.",
	'sf-autoedit-wait'                   => 'Wait...',
	'runquery'                           => 'Run query',
	'sf_runquery_badurl'                 => 'You must specify a form name in the URL;
the URL should look like "Special:RunQuery/<form name>".',
	'sf_runquery_title'                  => 'Run query: $1',
	'sf_runquery_additionalquery'        => 'Additional query',

	'sf_formerrors_header'               => 'There were errors with your form input; see below.',
	'sf_blank_error'                     => 'cannot be blank',
	'sf_bad_url_error'                   => 'must have the correct URL format, starting with "http"',
	'sf_bad_email_error'                 => 'must have a valid email address format',
	'sf_bad_number_error'                => 'must be a valid number',
	'sf_bad_date_error'                  => 'must be a valid date',
	'uploadwindow'                       => 'Upload window', // Description for Special:UploadWindow
	'sf_deletionlog'                     => 'Deletion log',
	'sf-preview-header'                  => 'Form preview',
	'sf-preview-note'                    => 'This is what the form will look like when it is in use:',
	'sf-pageschemas-pagenameformula'     => 'Page name formula:',
	'sf-pageschemas-createtitle'         => 'Title of form for new pages:',
	'sf-pageschemas-edittitle'           => 'Title of form for existing pages:',
	'sf-pageschemas-inputtype'           => 'Input type (leave blank to set to default):',

	// content messages
	'sf_property_isproperty'             => 'This is a property of type $1.',
	'sf_property_linkstoform'            => 'It links to pages that use the form $1.',
	'sf_property_allowedvals'            => 'The allowed {{PLURAL:$1|value for this property is|values for this property are}}:',
	'sf_template_docu'                   => 'This is the "$1" template.
It should be called in the following format:',
	'sf_template_docufooter'             => 'Edit the page to see the template text.',
	'sf_form_docu'                       => 'This is the "$1" form.
To create a page with this form, enter the page name below;
if a page with that name already exists, you will be sent to a form to edit that page.',
	'sf_form_freetextlabel'          => 'Free text',
	'sf_category_hasdefaultform'         => 'This category uses the form $1.',
	'sf_category_desc'                   => 'This is the $1 category.',
	'sf_blank_namespace'                 => 'Main',

	// user rights
	'right-viewedittab'          => 'View "{{int:edit}}" tab for pages editable by form',
	'right-editrestrictedfields' => 'Edit restricted form fields',
	'right-createclass'          => 'Create new semantic classes',

	'action-createclass' => 'create new semantic classes',
	'action-editrestrictedfields' => 'edit restricted form fields',
	'action-viewedittab' => 'view the "{{int:edit}}" tab for pages editable by form',
);

/** Message documentation (Message documentation)
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author Jon Harald Søby
 * @author Kghbln
 * @author McDutchie
 * @author Nemo bis
 * @author Protnet
 * @author Purodha
 * @author Raymond
 * @author Shirayuki
 * @author Siebrand
 * @author Umherirrender
 * @author 아라
 */
$messages['qqq'] = array(
	'semanticforms-desc' => '{{desc|name=Semantic Forms|url=http://www.mediawiki.org/wiki/Extension:Semantic Forms}}',
	'sf_createproperty_proptype' => '{{Identical|Type}}',
	'templates' => '{{Identical|Template}}',
	'sf_templates_definescat' => 'The message is shown on [[Special:Templates]], the list of templates in the wiki, after the name of each template, to describe it.
<code>$1</code> is the name of the category that this template adds pages to.',
	'sf_createtemplate_fieldname' => 'The name of the field used in the relevant template.',
	'sf_createtemplate_displaylabel' => 'The term for the text that shows up next to a field when it is displayed',
	'sf_createtemplate_standardformat' => '',
	'sf_createtemplate_infoboxformat' => 'For RTL languages this should be translated as "left-hand side".',
	'sf_createtemplate_deletefield' => '{{Identical|Delete}}',
	'sf_forminputs_uploadable' => 'This is a message describing a checkbox. The message included within this message is: {{msg-mw|upload}}',
	'sf_forminputs_listboxsize' => 'See [[wikipedia:list box|listbox]] for an listbox example',
	'createform' => 'Title below, create link. If you enter, include ".". and use special page name.',
	'sf_createform_template' => '{{Identical|Template}}',
	'sf_createform_allowmultiple' => 'This is the label for a checkbox on [[Special:CreateForm]]. If you tick it you will be able to use the template more than once within the form (one or more instances).',
	'sf_createform_field' => '{{Identical|Field}}',
	'sf_createform_inputtypedefault' => '{{Identical|Default}}',
	'sf_createform_hidden' => '{{Identical|Hidden}}',
	'sf_createform_add' => '{{Identical|Add}}',
	'sf_createcategory_name' => '{{Identical|Category name}}',
	'sf_createclass_docu' => '$1 will be filled with the following messages: {{msg-mw|Createproperty}}, {{msg-mw|Createtemplate}}, {{msg-mw|Createform}} and {{msg-mw|Createcategory}}',
	'sf_createclass_create' => '{{Identical|Create}}',
	'formstart' => 'Name of a special page.',
	'sf_formedit_createtitle' => '* $1 is the main part of the title of a semantic form
* $2 is the prefixed title, with spaces for the target page
{{Identical|Create}}',
	'sf_formedit_createtitlenotarget' => '{{Identical|Create}}',
	'sf_formedit_edittitle' => '* $1 is the main part of the title of a semantic form
* $2 is the prefixed title, with spaces for the target page',
	'sf_formedit_remove' => 'The text for a button that removes one row/"instance" in a form',
	'sf_formedit_addanotherabove' => 'The text for a button in a form that adds a row/"instance" above the current one',
	'sf_formedit_none' => '{{Identical|None}}',
	'sf_formedit_saveandcontinue_summary' => 'Summary logged in the page history for revisions that were created using the "Save and continue" button.

Parameters:
* $1 is replaced with {{msg-mw|sf_formedit_saveandcontinueediting}}.',
	'sf_formedit_accesskey_saveandcontinueediting' => '{{notranslate}}',
	'sf_autoedit_anoneditwarning' => 'This is a copy of the general MediaWiki "anoneditwarning" message, but without any markup.

See also:
* {{msg-mw|Anoneditwarning}}
* {{msg-mw|Wikibase-anonymouseditwarning-property}}
* {{msg-mw|Wikibase-anonymouseditwarning-item}}',
	'sf_autoedit_success' => 'Message sent upon successful operation.',
	'sf_autoedit_fail' => 'Message sent upon failed operation.',
	'sf_autoedit_notargetspecified' => 'An error message sent when no target page name was specified.',
	'sf_autoedit_invalidtargetspecified' => 'An error message sent when the specified target page name is invalid as a wiki page name.',
	'sf_autoedit_invalidform' => 'An error message sent when an invalid form was specified.',
	'sf_autoedit_redirectlimitexeeded' => 'An error message sent when the redirect limit was exeeded for the form page.',
	'sf_autoedit_invalidredirecttarget' => 'An error message sent when the form page redirects to an invalid target.',
	'sf_autoedit_invalidpreloadspecified' => 'An error message sent when an invalid preload page was specified.',
	'sf_autoedit_redlinkexists' => 'An error message sent when the page was started on a redlink but on submit already exists.',
	'sf_autoedit_noformfound' => 'An error message sent when no suitable form could be found to edit the given target page.',
	'sf_autoedit_toomanyformsfound' => 'An error message sent when too many forms were found for the given target page.',
	'sf_autoedit_readonly' => 'An error message sent when the wiki is in read-only mode',
	'sf_autoedit_nosemanticform' => 'An error message sent when no suitable form could be found to edit the given target page.',
	'sf_autoedit_summary' => 'Summary logged in the page history for revisions that were created using the autoedit parser function.',
	'sf-autoedit-wait' => 'Message displayed while an automatic edit is being made.',
	'sf_blank_error' => '{{Identical|Cannot be blank}}',
	'uploadwindow' => "Special page name for [[Special:UploadWindow]].

'''This is about a window for uploading files. The window is not the thing being uploaded.'''",
	'sf_deletionlog' => '{{Identical|Deletion log}}',
	'sf_template_docu' => 'This is an introductory message at the top of an autocreated template. The section following it displays the structure/format of the template itself.',
	'sf_form_freetextlabel' => '{{Identical|Free text}}',
	'right-viewedittab' => '{{doc-right|viewedittab}}',
	'right-editrestrictedfields' => '{{doc-right|editrestrictedfields}}',
	'right-createclass' => '{{doc-right|createclass}}',
	'action-createclass' => '{{doc-action|createclass}}',
	'action-editrestrictedfields' => '{{doc-action|editrestrictedfields}}',
	'action-viewedittab' => '{{doc-action|viewedittab}}',
);

/** Afrikaans (Afrikaans)
 * @author Arnobarnard
 * @author Naudefj
 * @author SPQRobin
 */
$messages['af'] = array(
	'sf_createproperty_propname' => 'Naam:', # Fuzzy
	'sf_createproperty_proptype' => 'Tipe:',
	'templates' => 'Sjablone',
	'sf_createtemplate_standardformat' => 'Standaard', # Fuzzy
	'sf_createtemplate_deletefield' => 'Skrap',
	'sf_createform_template' => 'Sjabloon:',
	'sf_createform_field' => 'Veld:',
	'sf_createform_inputtypedefault' => '(standaard)',
	'sf_createform_hidden' => 'Verborge',
	'sf_createform_add' => 'Voeg by',
	'sf_createcategory_name' => 'Naam:', # Fuzzy
	'sf_formedit_remove' => 'Skrap',
	'sf_formedit_none' => 'Geen',
	'sf_blank_error' => 'mag nie leeg wees nie',
	'sf_bad_date_error' => "moet 'n geldige datum wees",
	'sf_deletionlog' => 'Skraplogboek',
	'sf_form_freetextlabel' => 'Vrye teks',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'semanticforms-desc' => 'Formularët për shtimin dhe redaktimit të dhënat semantik',
	'specialpages-group-sf_group' => 'Semantik Format',
	'createproperty' => 'Krijo një pronë',
	'sf_createproperty_linktoform' => 'Kjo pronë do të lidhë për faqet që përdorin formën:',
	'sf_createproperty_allowedvalsinput' => 'Nëse dëshironi që kjo pronë të vetëm të lejohet të ketë vlera të caktuara, të hyjë në listën e vlerave të lejuara, të ndara me presje (nëse vlera përmban një presje, të zëvendësojë atë me ","):',
	'sf_createproperty_propname' => 'Emri i Pronës:',
	'sf_createproperty_proptype' => 'Tipi:',
	'templates' => 'Templates',
	'sf_templates_docu' => 'Në vijim templates ekzistojnë në wiki.',
	'sf_templates_definescat' => 'definon kategorinë: $1',
	'createtemplate' => 'Krijo një template',
	'sf_createtemplate_namelabel' => 'Emri Stampa:',
	'sf_createtemplate_categorylabel' => 'Kategoria përcaktuar nga template (opsional):',
	'sf_createtemplate_templatefields' => 'Fushat Template',
	'sf_createtemplate_fieldsdesc' => 'Për të kanë fushat në këtë shabllon nuk kërkojnë emra fushë, thjesht shkruani indeksi i çdo fushë (p.sh. 1, 2, 3, etj), si emri, në vend të një emri aktual.',
	'sf_createtemplate_fieldname' => 'Emri Fusha:',
	'sf_createtemplate_displaylabel' => 'etiketë Display:',
	'sf_createtemplate_semanticproperty' => 'pronës Semantic:',
	'sf_createtemplate_fieldislist' => 'Kjo fushë mund të mbajë një listë të vlerave, të ndara me presje',
	'sf_createtemplate_aggregation' => 'Grumbull',
	'sf_createtemplate_aggregationdesc' => 'Për të listës, në çdo faqe duke përdorur këtë template, të gjitha faqet që kanë një pronë të caktuar duke treguar atë faqe, specifikoni e pronës përkatëse më poshtë:',
	'sf_createtemplate_aggregationlabel' => 'Titulli për listën:',
	'sf_createtemplate_outputformat' => 'Formati Output:',
	'sf_createtemplate_standardformat' => 'Standard', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Djathtas-anën Infobox', # Fuzzy
	'sf_createtemplate_addfield' => 'fushë Shto',
	'sf_createtemplate_deletefield' => 'Fshij',
	'sf_createtemplate_addtemplatebeforesave' => 'Ju duhet të shtoni te pakten nje template për këtë formë para se të mund ta ruani atë.',
	'forms' => 'Formularët',
	'sf_forms_docu' => 'Format e mëposhtme ekzistojnë në wiki.',
	'createform' => 'Krijo një formë',
	'sf_createform_nameinput' => 'Emri Form',
	'sf_createform_nameinputdesc' => '(Konventë është që emri të formuar pas shabllonin kryesor ajo krijohet):', # Fuzzy
	'sf_createform_template' => 'Stampa:',
	'sf_createform_templatelabelinput' => 'Etiketa Template (opsional):',
	'sf_createform_allowmultiple' => 'Lejo për të shumta (ose zero) raste të këtij template në faqen e krijuar',
	'sf_createform_field' => 'Fusha:',
	'sf_createform_fieldprop' => 'Kjo fushë definon pronën $1, e llojit $2.',
	'sf_createform_fieldproplist' => 'Kjo fushë përcakton një listë të elementëve që kanë pronë $1, e llojit $2.',
	'sf_createform_fieldpropunknowntype' => 'Kjo fushë definon pronën $1, e llojit të pacaktuar.',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'sf_createproperty_propname' => 'ስም:', # Fuzzy
	'sf_createtemplate_standardformat' => 'መደበኛ', # Fuzzy
	'sf_createcategory_name' => 'ስም:', # Fuzzy
);

/** Aragonese (aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'sf_createproperty_propname' => "Nombre d'a propiedat:",
	'templates' => 'Plantillas',
	'sf_createtemplate_deletefield' => 'Borrar',
	'sf_createform_template' => 'Plantilla:',
	'sf_createcategory_name' => "Nombre d'a categoría:",
	'sf_formedit_createtitle' => 'Creyar $1: $2',
	'sf_bad_date_error' => "ha d'estar una calendata conforme",
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 */
$messages['ar'] = array(
	'semanticforms-desc' => 'نماذج لإضافة وتعديل بيانات سيمانتك',
	'specialpages-group-sf_group' => 'منتديات سيمانتيك',
	'createproperty' => 'أنشئ خاصية',
	'sf_createproperty_linktoform' => 'هذه الخاصية ستصل إلى الصفحات التي تستخدم النموذج:',
	'sf_createproperty_allowedvalsinput' => 'لو كنت تريد أن تحتوي هذه الخاصية فقط على قيم معينة، أدخل قائمة القيم المسموحة، مفصولة بفاصلات (لو أن قيمة ما تحتوي على فاصلة، استبدلها ب "\\,"):',
	'sf_createproperty_propname' => 'اسم الخاصية:',
	'sf_createproperty_proptype' => 'النوع:',
	'templates' => 'قوالب',
	'sf_templates_docu' => 'القوالب التالية موجودة في الويكي.',
	'sf_templates_definescat' => 'يعرف التصنيف: $1',
	'createtemplate' => 'أنشئ قالبا',
	'sf_createtemplate_namelabel' => 'اسم القالب:',
	'sf_createtemplate_categorylabel' => 'التصنيف معرف بواسطة قالب (اختياري):',
	'sf_createtemplate_templatefields' => 'حقول القالب',
	'sf_createtemplate_fieldsdesc' => 'لكي تجعل الحقول في هذا القالب لا تتطلب أسماء حقول، ببساطة أدخل فهرس كل حقل (مثل 1، 2، 3، إلى آخره.) كاسم، بدلا من اسم حقيقي.',
	'sf_createtemplate_fieldname' => 'اسم الحقل:',
	'sf_createtemplate_displaylabel' => 'علامة العرض:',
	'sf_createtemplate_semanticproperty' => 'خاصية سيمانتيك:',
	'sf_createtemplate_fieldislist' => 'هذا الحقل يمكنه أن يحتوي على قائمة من القيم، مفصولة بفاصلات',
	'sf_createtemplate_aggregation' => 'أجريجاشن',
	'sf_createtemplate_aggregationdesc' => 'لعرض، على أية صفحة تستخدم هذا القالب، كل الصفحات التي تمتلك خاصية معينة تشير إلى هذه الصفحة، حدد الخاصية المناسبة بالأسفل:',
	'sf_createtemplate_aggregationlabel' => 'العنوان للقائمة:',
	'sf_createtemplate_outputformat' => 'صيغة الخرج:',
	'sf_createtemplate_standardformat' => 'قياسي', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'صندوق معلومات على اليمين', # Fuzzy
	'sf_createtemplate_addfield' => 'أضف حقلًا',
	'sf_createtemplate_deletefield' => 'حذف',
	'sf_createtemplate_addtemplatebeforesave' => 'يجب أن تضيف على الأقل قالبا واحدا إلى هذا النموذج قبل حفظه.',
	'forms' => 'نماذج',
	'sf_forms_docu' => 'النماذج التالية موجودة في الويكي.',
	'sf_forminputs_mandatory' => 'إلزامي',
	'sf_forminputs_restricted' => 'فقط الإداريون يمكنهم تعديل هذا الإدخال',
	'createform' => 'أنشئ نموذجا',
	'sf_createform_nameinput' => 'اسم النموذج',
	'sf_createform_nameinputdesc' => '(النموذج تتم تسميته عادة مثل قالبه الرئيسي):',
	'sf_createform_template' => 'القالب:',
	'sf_createform_templatelabelinput' => 'علامة القالب (اختياري):',
	'sf_createform_allowmultiple' => 'السماح بوجود عدة (أو صفر) نسخة من هذا القالب في الصفحة المنشأة',
	'sf_createform_field' => 'الحقل:',
	'sf_createform_fieldprop' => 'هذا الحقل يعرف الخاصية $1، من نوع $2.',
	'sf_createform_fieldproplist' => 'هذا الحقل يعرف قائمة من العناصر التي تمتلك الخاصية $1، من نوع $2.',
	'sf_createform_fieldpropunknowntype' => 'هذا الحقل يعرف الخاصية $1، من نوع غير محدد.',
	'sf_createform_inputtype' => 'نوع الإدخال:',
	'sf_createform_inputtypedefault' => '(افتراضي)',
	'sf_createform_formlabel' => 'لصيقة النموذج:',
	'sf_createform_hidden' => 'مخفي',
	'sf_createform_removetemplate' => 'إزالة القالب',
	'sf_createform_addtemplate' => 'إضافة القالب:',
	'sf_createform_beforetemplate' => 'قبل القالب:',
	'sf_createform_atend' => 'في النهاية',
	'sf_createform_add' => 'أضف',
	'sf_createform_choosefield' => 'اختر حقلا للإضافة',
	'createcategory' => 'أنشئ تصنيفا',
	'sf_createcategory_name' => 'اسم التصنيف:',
	'sf_createcategory_defaultform' => 'النموذج المبدئي:',
	'sf_createcategory_makesubcategory' => 'اجعل هذا تصنيفا فرعيا لتصنيف آخر (اختياري):',
	'createclass' => 'أنشئ رتبة',
	'sf_createclass_docu' => 'أدخل كل البيانات هنا لإنشاء الخواص، القوالب، النماذج والتصنيفات لرتبة واحدة. لمزيد من الخيارات، استخدم الصفحات $1 كبديل.',
	'sf_createclass_allowedvalues' => 'القيم المسموح بها:',
	'sf_createclass_listofvalues' => 'قائمة القيم؟',
	'sf_createclass_missingvalues' => 'لم تملأ جميع الحقول.',
	'sf_createclass_success' => 'سوف تنشأ الخصائص والقالب والنموذج والتصنيف.',
	'sf_createclass_create' => 'أنشئ',
	'formstart' => 'إضافة صفحة مع نموذج',
	'sf_formstart_badform' => 'خطأ: لا صفحة نموذج تم العثور عليها في $1',
	'sf_formstart_badtitle' => 'خطأ: "$1" عنوان غير صحيح لصفحة.',
	'sf_formstart_docu' => "أدخل اسم الصفحة هنا، لكي يتم تعديلها بالنموذج '$1'.
إذا كانت هذه الصفحة موجودة بالفعل، سيتم إرسالك إلى النموذج لتعديل هذه الصفحة.
وإلا فسيتم إرسالك إلى النموذج لإضافة الصفحة.",
	'sf_formstart_noform_docu' => 'أدخل اسم الصفحة هنا، واختر النموذج لتعديلها به.
إذا كانت هذه الصفحة موجودة بالفعل، سيتم إرسالك إلى النموذج لتعديل هذه الصفحة.
وإلا فسيتم إرسالك إلى النموذج لإضافة الصفحة.',
	'sf_formstart_createoredit' => 'أنشئ أو عدل',
	'formedit' => 'عدل بالنموذج',
	'sf_formedit_createtitle' => 'أنشئ $1: $2',
	'sf_formedit_createtitlenotarget' => 'أنشئ $1',
	'sf_formedit_badurl' => "هذه هي الصفحة لإضافة البيانات. يجب عليك تحديد اسم صفحة وصفحة هدف في المسار؛ ينبغي أن تبدو ك 'Special:FormEdit?form=<form name>&target=<target page>' أو  'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'أو يمكنك إضافة هذه الصفحة بواحدة من النماذج التالية:',
	'sf_formedit_altformsonly' => 'من فضلك اختر إحدى النماذج التالية لإضافة هذه الصفحة:',
	'sf_formcreate' => 'أنشئ بنموذج',
	'sf_viewform' => 'عرض من',
	'sf_editsource' => 'مصدر التعديل',
	'sf_formedit_edittitle' => 'عدل $1: $2',
	'sf_formedit_morethanoneform' => "'''تحذير:''' أكثر من نموذج مبدئي معرّف لهذه الصفحة.",
	'sf_formedit_formwarning' => 'تحذير: هذه الصفحة <a href="$1">موجودة بالفعل</a>، لكنها لا تستخدم هذا النموذج.',
	'sf_formedit_remove' => 'إزالة',
	'sf_formedit_addanother' => 'إضافة آخر',
	'sf_formedit_none' => 'لا شيء',
	'runquery' => 'شغّل استعلامًا',
	'sf_runquery_badurl' => "يجب أن تحدد اسم نموذج في المسار;
المسار ينبغي أن يبدو ك 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'تشغيل الاستعلام: $1',
	'sf_runquery_additionalquery' => 'استعلام إضافي',
	'sf_formerrors_header' => 'هناك أخطاء في مدخلات نموذجك؛ انظر بالأسفل.',
	'sf_blank_error' => 'لا يمكن أن يكون فارغا',
	'sf_bad_url_error' => "يجب أن يحتوي صيغة المسار الصحيحة، بادئا ب 'http'",
	'sf_bad_email_error' => 'يجب أن يحتوي صيغة عنوان بريد إلكتروني صحيحة',
	'sf_bad_number_error' => 'يجب أن يكون عددا سليما',
	'sf_bad_date_error' => 'يجب أن يكون تاريخا سليما',
	'uploadwindow' => 'نافذة الرفع',
	'sf_deletionlog' => 'سجل الحذف',
	'sf_property_isproperty' => 'هذه خاصية من نوع $1.',
	'sf_property_linkstoform' => 'تصل بالصفحات التي تستخدم النموذج $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1||القيمة المسموح بها لهذه الخاصية هي|القيمتان المسموح بهما لهذه الخاصية هما|القيم المسموح بها لهذه الخاصية هي}}:',
	'sf_template_docu' => "هذا قالب '$1'.
ينبغي استدعاؤه بالصيغة التالية:",
	'sf_template_docufooter' => 'عدل الصفحة لرؤية نص القالب.',
	'sf_form_docu' => 'هذا هو نموذج "$1".
لإنشاء صفحة بهذا النموذج، أدخل اسم الصفحة بالأسفل؛
إذا وُجدت صفحة بهذا الاسم، فسيتم إرسالك إلى نموذج لتعديل تلك الصفحة.',
	'sf_form_freetextlabel' => 'نص حر',
	'sf_category_hasdefaultform' => 'هذا التصنيف يستخدم النموذج $1.',
	'sf_category_desc' => 'هذا $1 تصنيف.',
	'sf_blank_namespace' => 'رئيسي',
	'right-viewedittab' => 'أظهر لسان "عدّل" للصفحات التي يمكن تعديلها باستخدام نموذج.', # Fuzzy
	'right-editrestrictedfields' => 'حرّر حقول النموذج المقيّدة',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 * @author Michaelovic
 */
$messages['arc'] = array(
	'sf_createproperty_proptype' => 'ܐܕܫܐ:',
	'templates' => 'ܩܠܒ̈ܐ',
	'createtemplate' => 'ܒܪܝ ܩܠܒܐ',
	'sf_createtemplate_namelabel' => 'ܫܡܐ ܕܩܠܒܐ:',
	'sf_createtemplate_templatefields' => 'ܚܩܠ̈ܐ ܕܩܠܒ̈ܐ',
	'sf_createtemplate_fieldname' => 'ܫܡܐ ܕܚܩܠܐ:',
	'sf_createtemplate_aggregationlabel' => 'ܟܘܢܝܐ ܕܡܟܬܒܘܬܐ:',
	'sf_createtemplate_deletefield' => 'ܫܘܦ',
	'forms' => 'ܕ̈ܘܡܝܐ',
	'sf_createform_template' => 'ܩܠܒܐ:',
	'sf_createform_field' => 'ܚܩܠܐ:',
	'sf_createform_hidden' => 'ܛܘܫܝܐ',
	'sf_createform_removetemplate' => 'ܠܚܝ ܩܠܒܐ',
	'sf_createform_addtemplate' => 'ܐܘܣܦ ܩܠܒܐ:',
	'sf_createform_beforetemplate' => 'ܩܕܡ ܩܠܒܐ:',
	'sf_createform_add' => 'ܐܘܣܦ',
	'createcategory' => 'ܒܪܝ ܣܕܪܐ',
	'sf_createcategory_name' => 'ܫܡܐ ܕܣܕܪܐ:',
	'sf_formstart_createoredit' => 'ܒܪܝ ܐܘ ܫܚܠܦ',
	'sf_formedit_createtitle' => 'ܒܪܝ $1: $2',
	'sf_editsource' => 'ܫܚܠܦ ܡܒܘܥܐ',
	'sf_formedit_edittitle' => 'ܫܚܠܦ $1: $2',
	'sf_formedit_remove' => 'ܠܚܝ',
	'sf_formedit_addanother' => 'ܐܘܣܦ ܐܚܪܢܐ',
	'sf_formedit_none' => 'ܠܐ ܡܕܡ',
	'uploadwindow' => 'ܐܣܩ ܟܘܬܐ',
	'sf_deletionlog' => 'ܣܓܠܐ ܕܫܝܦܐ',
	'sf_form_freetextlabel' => 'ܟܬܒܬܐ ܚܐܪܬܐ',
	'sf_blank_namespace' => 'ܪܫܝܬܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 * @author Meno25
 */
$messages['arz'] = array(
	'semanticforms-desc' => 'نماذج لإضافة وتعديل بيانات سيمانتك',
	'specialpages-group-sf_group' => 'منتديات سيمانتيك',
	'createproperty' => 'إنشاء خاصية',
	'sf_createproperty_allowedvalsinput' => 'لو كنت تريد أن تحتوى هذه الخاصية فقط على قيم معينة، أدخل قائمة القيم المسموحة، مفصولة بفاصلات (لو أن قيمة ما تحتوى على فاصلة، استبدلها ب "\\,"):',
	'sf_createproperty_propname' => 'اسم الخاصية:',
	'sf_createproperty_proptype' => 'النوع:',
	'templates' => 'قوالب',
	'sf_templates_docu' => 'القوالب التالية موجودة فى الويكى.',
	'sf_templates_definescat' => 'يعرف التصنيف: $1',
	'createtemplate' => 'إنشاء قالب',
	'sf_createtemplate_namelabel' => 'اسم القالب:',
	'sf_createtemplate_categorylabel' => 'التصنيف معرف بواسطة قالب (اختياري):',
	'sf_createtemplate_templatefields' => 'حقول القالب',
	'sf_createtemplate_fieldsdesc' => 'لكى تجعل الحقول فى هذا القالب لا تتطلب أسماء حقول، ببساطة أدخل فهرس كل حقل (مثل 1، 2، 3، إلى آخره.) كاسم، بدلا من اسم حقيقى.',
	'sf_createtemplate_fieldname' => 'اسم الحقل:',
	'sf_createtemplate_displaylabel' => 'علامة العرض:',
	'sf_createtemplate_semanticproperty' => 'خاصية سيمانتيك:',
	'sf_createtemplate_fieldislist' => 'هذا الحقل يمكنه أن يحتوى على قائمة من القيم، مفصولة بفاصلات',
	'sf_createtemplate_aggregation' => 'أجريجاشن',
	'sf_createtemplate_aggregationdesc' => 'لعرض، على أية صفحة تستخدم هذا القالب، كل الصفحات التى تمتلك خاصية معينة تشير إلى هذه الصفحة، حدد الخاصية المناسبة بالأسفل:',
	'sf_createtemplate_aggregationlabel' => 'العنوان للقائمة:',
	'sf_createtemplate_outputformat' => 'صيغة الخرج:',
	'sf_createtemplate_standardformat' => 'قياسي', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'صندوق معلومات على اليمين', # Fuzzy
	'sf_createtemplate_addfield' => 'إضافة حقل',
	'sf_createtemplate_deletefield' => 'حذف',
	'sf_createtemplate_addtemplatebeforesave' => 'يجب أن تضيف على الأقل قالبا واحدا إلى هذه الاستمارة قبل حفظها.',
	'forms' => 'استمارات',
	'sf_forms_docu' => 'الاستمارات التالية موجودة فى الويكى.',
	'sf_forminputs_mandatory' => 'إلزامي',
	'sf_forminputs_restricted' => 'محدد (فقط المستخدمون مديرو النظام يمكنهم تعديله)', # Fuzzy
	'createform' => 'إنشاء استمارة',
	'sf_createform_nameinput' => 'اسم الاستمارة',
	'sf_createform_template' => 'القالب:',
	'sf_createform_templatelabelinput' => 'علامة القالب (اختياري):',
	'sf_createform_allowmultiple' => 'السماح بوجود عدة (أو صفر) نسخة من هذا القالب فى الصفحة المنشأة', 
	'sf_createform_field' => 'الحقل:',
	'sf_createform_fieldprop' => 'هذا الحقل يعرف الخاصية $1، من نوع $2.',
	'sf_createform_fieldproplist' => 'هذا الحقل يعرف قائمة من العناصر التى تمتلك الخاصية $1، من نوع $2.',
	'sf_createform_fieldpropunknowntype' => 'الحقل ده يعرف الخاصية $1، من نوع  مش متحدد.',
	'sf_createform_inputtype' => 'نوع الإدخال:',
	'sf_createform_inputtypedefault' => '(افتراضي)',
	'sf_createform_formlabel' => 'علامة الاستمارة:',
	'sf_createform_hidden' => 'مخفي',
	'sf_createform_removetemplate' => 'إزالة القالب',
	'sf_createform_addtemplate' => 'إضافة القالب:',
	'sf_createform_beforetemplate' => 'قبل القالب:',
	'sf_createform_atend' => 'فى النهاية',
	'sf_createform_add' => 'إضافة',
	'sf_createform_choosefield' => 'اختر حقلا للإضافة',
	'createcategory' => 'إنشاء تصنيف',
	'sf_createcategory_name' => 'اسم التصنيف:',
	'sf_createcategory_defaultform' => 'الاستمارة الافتراضية:',
	'sf_createcategory_makesubcategory' => 'اجعل هذا تصنيفا فرعيا لتصنيف آخر (اختياري):',
	'formstart' => 'إضافة صفحة مع نموذج',
	'sf_formstart_badform' => 'خطأ: لا صفحة استمارة تم العثور عليها فى $1',
	'sf_formstart_docu' => "أدخل اسم الصفحة هنا، لكى يتم تعديلها مع الاستمارة '$1'.
إذا كانت هذه الصفحة موجودة بالفعل، سيتم إرسالك إلى الاستمارة لتعديل هذه الصفحة.
أما غير ذلك، فسيتم إرسالك إلى الاستمارة لإضافة الصفحة.",
	'sf_formstart_noform_docu' => 'أدخل اسم الصفحة هنا، واختر الاستمارة لتعديلها معها.
إذا كانت هذه الصفحة موجودة بالفعل، سيتم إرسالك إلى الاستمارة لتعديل هذه الصفحة.
أما غير ذلك، فسيتم إرسالك إلى الاستمارة لإضافة الصفحة.',
	'sf_formstart_createoredit' => 'أضف أو عدل', # Fuzzy
	'formedit' => 'عدل مع الاستمارة',
	'sf_formedit_createtitle' => 'أضف $1: $2', # Fuzzy
	'sf_formedit_badurl' => "هذه هى الصفحة لإضافة البيانات. يجب عليك تحديد اسم صفحة وصفحة هدف فى المسار؛ ينبغى أن تبدو ك 'Special:FormEdit?form=<form name>&target=<target page>' أو  'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'يمكنك كبديل إضافة هذه الصفحة مع واحد من الاستمارات التالية:',
	'sf_formedit_altformsonly' => 'من فضلك اختر إحدى الاستمارات التالية لإضافة هذه الصفحة إليها:',
	'sf_viewform' => 'عرض من',
	'sf_editsource' => 'مصدر التعديل',
	'sf_formedit_edittitle' => 'عدل $1: $2',
	'sf_formedit_formwarning' => 'تحذير: هذه الصفحة <a href="$1">موجودة بالفعل</a>، لكنها لا تستخدم هذه الاستمارة.',
	'sf_formedit_remove' => 'إزالة',
	'sf_formedit_addanother' => 'إضافة آخر',
	'sf_formedit_none' => 'لا شيء',
	'sf_formerrors_header' => 'هناك أخطاء فى مدخلات استمارتك؛ انظر بالأسفل',
	'sf_blank_error' => 'لا يمكن أن يكون فارغا',
	'sf_bad_url_error' => "يجب أن يحتوى صيغة المسار الصحيحة، بادئا ب 'http'",
	'sf_bad_email_error' => 'يجب أن يحتوى صيغة عنوان بريد إلكترونى صحيحة',
	'sf_bad_number_error' => 'يجب أن يكون عددا سليما',
	'sf_bad_date_error' => 'يجب أن يكون تاريخا سليما',
	'uploadwindow' => 'نافذة الرفع',
	'sf_property_isproperty' => 'هذه خاصية من نوع $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1||القيمة المسموح بها لهذه الخاصية هي|القيمتان المسموح بهما لهذه الخاصية هما|القيم المسموح بها لهذه الخاصية هي}}:',
	'sf_template_docu' => "هذا قالب '$1'.
ينبغى استدعاؤه بالصيغة التالية:",
	'sf_template_docufooter' => 'عدل الصفحة لرؤية نص القالب.',
	'sf_form_docu' => "هذه استمارة '$1'.
لإضافة صفحة مع هذه الاستمارة، أدخل اسم الصفحة بالأسفل؛
إذا كانت هناك صفحة موجودة بهذا الاسم، سيتم إرسالك إلى استمارة لتعديل هذه الصفحة.", # Fuzzy
	'sf_form_freetextlabel' => 'نص حر',
	'sf_category_hasdefaultform' => 'هذا التصنيف يستخدم الاستمارة $1.',
	'sf_category_desc' => 'هذا $1 تصنيف.',
	'sf_blank_namespace' => 'رئيسي',
);

/** Kotava (Kotava)
 * @author Nkosi ya Cabinda
 * @author Wikimistusik
 */
$messages['avk'] = array(
	'createproperty' => 'Redura va pilkaca',
	'sf_createproperty_propname' => 'Yolt :', # Fuzzy
	'sf_createproperty_proptype' => 'Ord :',
	'templates' => 'Tezeem',
	'sf_templates_docu' => 'Bata teza yo koe wiki tid.',
	'sf_templates_definescat' => 'lomatentura : $1',
	'createtemplate' => 'Redura va teza',
	'sf_createtemplate_namelabel' => 'Tezayolt :',
	'sf_createtemplate_categorylabel' => 'Loma tezon tentuna (rotison) :',
	'sf_createtemplate_templatefields' => 'Tezarapteem',
	'sf_createtemplate_fieldname' => 'Raptayolt :',
	'sf_createtemplate_displaylabel' => 'Kralfintara :',
	'sf_createtemplate_semanticproperty' => 'Sugdalafa pilkaca :',
	'sf_createtemplate_aggregationdesc' => 'Moe betu bu favesu va bata teza, ta vexalara va kot teliz digis va man pilkot skedas va batu bu, va pilkotanh vleveon bazel :', # Fuzzy
	'sf_createtemplate_aggregationlabel' => 'Vexalavergumvelt :',
	'sf_createtemplate_outputformat' => 'Divaf breviz',
	'sf_createtemplate_standardformat' => 'Preksaf', # Fuzzy
	'sf_createtemplate_addfield' => 'Loplekura va rapta',
	'sf_createtemplate_deletefield' => 'Sulara',
	'sf_createtemplate_addtemplatebeforesave' => 'Va tanoya teza ko bata erurateza leon goloplekul abdi da rogiwal.',
	'forms' => 'Eruratezeem',
	'sf_forms_docu' => 'Bata erurateza yo koe wiki tid.',
	'sf_forminputs_restricted' => 'Irutan (anton ristusik vaon robetar)', # Fuzzy
	'createform' => 'Redura va erurateza',
	'sf_createform_template' => 'Teza :',
	'sf_createform_templatelabelinput' => 'Tezakral (rotir) :',
	'sf_createform_field' => 'Rapta :',
	'sf_createform_fieldprop' => 'Bata rapta va $1 pilkaca (dem $2 ord) tentur.',
	'sf_createform_fieldproplist' => 'Bata rapta va reem tentur lize kota ra va $1 pilkot (ke $2 ord) digir.',
	'sf_createform_fieldpropunknowntype' => 'Bata rapta va $1 pilkaca (ke meruidayan ord) tentur.',
	'sf_createform_inputtype' => 'Kof ord :',
	'sf_createform_inputtypedefault' => '(omavon)',
	'sf_createform_formlabel' => 'Eruratezakral :',
	'sf_createform_hidden' => 'Palsen',
	'sf_createform_removetemplate' => 'Tioltera va teza',
	'sf_createform_addtemplate' => 'Loplekura va teza :',
	'sf_createform_beforetemplate' => 'Abdi teza :',
	'sf_createform_atend' => 'Arton',
	'sf_createform_add' => 'Loplekura',
	'sf_createform_choosefield' => 'Va goloplekuna rapta kiblal !',
	'createcategory' => 'Redura va loma',
	'sf_createcategory_name' => 'Yolt :', # Fuzzy
	'sf_createcategory_defaultform' => 'Omavafa erurateza :',
	'sf_createcategory_makesubcategory' => 'Artazukara va bata loma ton volveyloma (rotison) :',
	'formstart' => 'Loplekura va bu',
	'sf_formstart_badform' => 'Rokla : meku eruratezabu trasinu koe $1',
	'sf_formstart_createoredit' => 'Loplekura ok betara', # Fuzzy
	'formedit' => 'Betara kan erurateza',
	'sf_formedit_createtitle' => 'Loplekura va $1 : $2', # Fuzzy
	'sf_formedit_altformsonly' => 'Va tanoya vlevefa erurateza goloplekuna ko batu bu vay rebal :',
	'sf_editsource' => 'Klitabetara',
	'sf_formedit_edittitle' => 'Betara va $1 : $2',
	'sf_formedit_formwarning' => 'Obral ! Batu bu (<a href="$1">) ixam tir</a>, vexe va bata erurateza me faver.',
	'sf_formedit_remove' => 'Dimplekura',
	'sf_formedit_addanother' => 'Loplekura va arcoba',
	'sf_blank_error' => 'Me rotir vlardaf',
	'sf_bad_url_error' => "Gotir URL brevizanh, tozus kan 'http'",
	'sf_bad_email_error' => 'Gotir e-mail mane brevizanh',
	'sf_bad_number_error' => 'gotir va enafa ota',
	'sf_bad_date_error' => 'gotir enafa evla',
	'sf_property_isproperty' => 'Tir pilkaca ke $1 ord.',
	'sf_property_allowedvals' => 'Rictana voda se ke bat pilkovoy tid :', # Fuzzy
	'sf_template_docu' => "Tir '$1' teza. Kan vlevef breviz zo gonerur :",
	'sf_template_docufooter' => 'Burupera ta wira va tezacek',
	'sf_form_docu' => "Tir '$1' erurateza. Ta koon buloplekura, va buyolt vleveon bazel ; ede milyoltafu bu ixam tir, ta bubetara erurateza zo fintatar.", # Fuzzy
	'sf_form_freetextlabel' => 'Nuyaf krent',
	'sf_category_hasdefaultform' => 'Bata loma va $1 erurateza faver.',
	'sf_category_desc' => 'Tir $1 loma.',
	'sf_blank_namespace' => 'Nelkaxo',
);

/** Azerbaijani (azərbaycanca)
 * @author Cekli829
 */
$messages['az'] = array(
	'sf_createproperty_proptype' => 'Tipi:',
	'sf_createtemplate_deletefield' => 'Sil',
	'sf_createform_template' => 'Şablon:',
	'sf_createform_hidden' => 'Gizlədilib',
	'sf_createform_add' => 'Əlavə et',
	'sf_formedit_none' => 'Heç biri',
);

/** South Azerbaijani (تورکجه)
 * @author Mousa
 */
$messages['azb'] = array(
	'formedit' => 'فورم ایله دَییشدیرمک',
);

/** Bavarian (Boarisch)
 * @author Mucalexx
 */
$messages['bar'] = array(
	'formedit' => 'Mid Formular beorweiten',
);

/** Belarusian (беларуская)
 * @author Тест
 */
$messages['be'] = array(
	'sf_createproperty_proptype' => 'Тып:',
	'templates' => 'Шаблоны',
	'sf_createform_template' => 'Шаблон:',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Red Winged Duck
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'semanticforms-desc' => 'Формы для даданьня і рэдагаваньня сэмантычных зьвестак',
	'specialpages-group-sf_group' => 'Сэмантычныя формы',
	'createproperty' => 'Стварыць уласьцівасьць',
	'sf_createproperty_linktoform' => 'Гэта ўласьцівасьць будзе спасылацца на старонкі, якія выкарыстоўваюць форму:',
	'sf_createproperty_allowedvalsinput' => 'Калі Вы жадаеце, каб гэта ўласьцівасьць мела толькі некаторыя значэньні, увядзіце сьпіс дазволеных значэньняў, падзелены коскамі (калі значэньне ўтрымлівае коску, замяніце яе на «\\,»):',
	'sf_createproperty_propname' => 'Назва ўласьцівасьці:',
	'sf_createproperty_proptype' => 'Тып:',
	'templates' => 'Шаблёны',
	'sf_templates_docu' => 'У {{GRAMMAR:месны|{{SITENAME}}}} існуюць наступныя шаблёны.',
	'sf_templates_definescat' => 'вызначае катэгорыю: $1',
	'createtemplate' => 'Стварыць шаблён',
	'sf_createtemplate_namelabel' => 'Назва шаблёну:',
	'sf_createtemplate_categorylabel' => 'Катэгорыя, якая вызначаецца шаблёнам (неабавязкова):',
	'sf_createtemplate_templatefields' => 'Палі шаблёну',
	'sf_createtemplate_fieldsdesc' => 'Палі гэтага шаблёну болей не патрабуюць назваў, проста ўвядзіце індэкс кожнага поля (напрыклад, 1, 2, 3 і г.д.) замест назваў.',
	'sf_createtemplate_fieldname' => 'Назва поля:',
	'sf_createtemplate_displaylabel' => 'Надпіс, які будзе паказвацца:',
	'sf_createtemplate_semanticproperty' => 'Сэмантычная ўласьцівасьць:',
	'sf_createtemplate_fieldislist' => 'Гэта поле можа ўтрымліваць сьпіс значэньняў, падзеленых коскамі',
	'sf_createtemplate_aggregation' => 'Злучэньне',
	'sf_createtemplate_aggregationdesc' => 'Каб выводзіць на любую старонку, якая выкарыстоўвае гэты шаблён, усе старонкі, у якіх гэтая ўласьцівасьць спасылаецца на гэтую старонку, пазначце адпаведную ўласьцівасьць ніжэй:',
	'sf_createtemplate_aggregationlabel' => 'Назва сьпісу:',
	'sf_createtemplate_outputformat' => 'Фармат вываду:',
	'sf_createtemplate_standardformat' => 'Стандартны', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Інфармацыйная панэль справа', # Fuzzy
	'sf_createtemplate_addfield' => 'Дадаць поле',
	'sf_createtemplate_deletefield' => 'Выдаліць',
	'sf_createtemplate_addtemplatebeforesave' => 'Вам трэба дадаць хаця бы адзін шаблён да гэтай формы для таго, каб яе можна было захаваць.',
	'forms' => 'Формы',
	'sf_forms_docu' => 'У {{GRAMMAR:месны|{{SITENAME}}}} існуюць наступныя формы.',
	'sf_forminputs_mandatory' => 'Абавязковая',
	'sf_forminputs_restricted' => 'Рэдагаваньне дазволенае толькі адміністратарам',
	'sf_forminputs_class' => 'HTML-атрыбут «class» для гэтага поля',
	'sf_forminputs_default' => 'Значэньне па змоўчваньні для гэтага ўводу',
	'sf_forminputs_preload' => 'Старонка {{GRAMMAR:родны|{{SITENAME}}}}, зьмест якой стане значэньнем па змоўчваньні для гэтага ўводу',
	'sf_forminputs_property' => 'Сэмантычная ўласьцівасьць, з якой зьвязанае гэтае поле',
	'sf_forminputs_size' => 'Памер гэтага тэкставага поля ў сымбалях',
	'sf_forminputs_maxlength' => 'Максымальна дазволеная даўжыня тэксту ў гэтым полі',
	'sf_forminputs_uploadable' => 'Разьмясьціць спасылку «Загрузіць файл» пасьля гэтага ўводу', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Назва па змоўчваньні для загружаемых файлаў',
	'sf_forminputs_rows' => 'Колькасьць радкоў для гэтага ўводу',
	'sf_forminputs_cols' => 'Колькасьць слупкоў для гэтага ўводу',
	'sf_forminputs_autogrow' => 'Павялічваць памер гэтага ўводу, калі тэкст перавысіць яго памеры',
	'sf_forminputs_valuesfromproperty' => 'Уласьцівасьць, значэньне якой у {{GRAMMAR:месны|{{SITENAME}}}} павінны быць уваходным для гэтага ўводу',
	'sf_forminputs_valuesfromcategory' => 'Катэгорыя, старонкі якой павінны быць уваходнымі для гэтага ўводу',
	'sf_forminputs_valuesfromnamespace' => 'Прастора назваў, старонкі якой павінны быць уваходнымі для гэтага ўводу',
	'sf_forminputs_valuesfromconcept' => '«Канцэптуальная» старонка Semantic MediaWiki, старонкі якой павінны быць уваходнымі для гэтага ўводу',
	'sf_forminputs_valuesfromurl' => 'URL-адрас, які ўтрымлівае структурныя зьвесткі, якія павінны быць уваходнымі для гэтага ўводу',
	'sf_forminputs_values' => 'Набор значэньняў для гэтага ўводу, падзеленых коскамі',
	'sf_forminputs_list' => 'Пазначыць гэты ўвод, як утрымліваючы сьпіс значэньняў',
	'sf_forminputs_delimiter' => 'Разьдзяляльнік паміж значэньнямі ў палі, калі гэты ўвод утрымлівае іх сьпіс',
	'sf_forminputs_remoteautocompletion' => 'Выкарыстоўваць аддаленае аўтаматычнае запаўненьне',
	'sf_forminputs_existingvaluesonly' => 'Дазваляе толькі значэньні існуючыя у сьпісе',
	'sf_forminputs_showonselect' => 'Элемэнты старонкі для паказу, толькі ў выпадку калі выбраныя некаторыя значэньні (напрыклад: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => 'Вышыня гэтага сьпісу, у радках',
	'sf_forminputs_includetimezone' => 'Уключае ўвод для часовага пасу',
	'sf_forminputs_topcategory' => 'Бацькоўская катэгорыя гэтага набору катэгорыяў (абавязкова)',
	'sf_forminputs_hideroot' => 'Схаваць бацькоўскую катэгорыю',
	'sf_forminputs_height' => 'Вышыня гэтага ўводу ў піксэлях',
	'sf_forminputs_width' => 'Шырыня гэтага ўводу ў піксэлях',
	'createform' => 'Стварыць форму',
	'sf_createform_nameinput' => 'Назва формы',
	'sf_createform_nameinputdesc' => '(форма звычайна атрымлівае тую ж назву, што і яе асноўны шаблён):',
	'sf_createform_template' => 'Шаблён:',
	'sf_createform_templatelabelinput' => 'Пазнака шаблёну (неабавязкова):',
	'sf_createform_allowmultiple' => 'Дазволіць некалькі (ці нуль) экзэмпляраў гэтага шаблёну ў ствараемай старонцы', 
	'sf_createform_field' => 'Поле:',
	'sf_createform_fieldprop' => 'Гэта поле вызначае ўласьцівасьць $1 тыпу $2.',
	'sf_createform_fieldproplist' => 'Гэта поле вызначае сьпіс элемэнтаў, якія маюць уласьцівасьць $1 тыпу $2.',
	'sf_createform_fieldpropunknowntype' => 'Гэта поле вызначае ўласьцівасьць $1 непазначанага тыпу.',
	'sf_createform_inputtype' => 'Уваходны тып:',
	'sf_createform_inputtypedefault' => '(па змоўчваньні)',
	'sf_createform_formlabel' => 'Пазнака формы:',
	'sf_createform_hidden' => 'Схаваная',
	'sf_createform_removetemplate' => 'Выдаліць шаблён',
	'sf_createform_addtemplate' => 'Дадаць шаблён:',
	'sf_createform_beforetemplate' => 'Перад шаблёнам:',
	'sf_createform_atend' => 'У канцы',
	'sf_createform_add' => 'Дадаць',
	'sf_createform_choosefield' => 'Выберыце поле для даданьня',
	'createcategory' => 'Стварыць катэгорыю',
	'sf_createcategory_name' => 'Назва катэгорыі:',
	'sf_createcategory_defaultform' => 'Форма па змоўчваньні:',
	'sf_createcategory_makesubcategory' => 'Зрабіць гэта падкатэгорыяй іншай катэгорыі (неабавязкова):',
	'createclass' => 'Стварыць кляс',
	'sf_createclass_docu' => 'Для стварэньня ўласьцівасьцяў, шаблёнаў, форм і катэгорый аднаго кляса, увядзіце тут ўсе зьвесткі. Для дадатковых магчымасьцяў, выкарыстоўвайце старонкі $1.',
	'sf_createclass_allowedvalues' => 'Дазволеныя значэньні:',
	'sf_createclass_listofvalues' => 'Сьпіс значэньняў?',
	'sf_createclass_nameinput' => 'Назва формы:',
	'sf_createclass_missingvalues' => 'Ня ўсе неабходныя палі былі запоўнены.',
	'sf_createclass_success' => 'Будуць створаны ўласьцівасьці, шаблёны, формы і катэгорыі.',
	'sf_createclass_create' => 'Стварыць',
	'formstart' => 'Дадаць старонку з формай',
	'sf_formstart_badform' => 'Памылка: ня знойдзена старонка формы на $1',
	'sf_formstart_badtitle' => 'Памылка: «$1» — няслушная назва для старонкі.',
	'sf_formstart_docu' => "Увядзіце тут назву старонкі, якую трэба рэдагаваць з дапамогай формы '$1'.
Калі гэта старонка ўжо існуе, Вы будзеце накіраваны на форму рэдагаваньня старонкі.
У адваротным выпадку, Вы будзеце накіраваны на форму даданьня старонкі.",
	'sf_formstart_noform_docu' => 'Увядзіце тут назву старонкі і выберыце форму, з дапамогай якой Вы будзеце рэдагаваць старонку.
Калі гэта старонка ўжо існуе, Вы будзеце накіраваны на форму рэдагаваньня старонкі.
У адваротным выпадку, Вы будзеце накіраваны на форму даданьня старонкі.',
	'sf_formstart_createoredit' => 'Стварыць альбо рэдагаваць',
	'formedit' => 'Рэдагаваць з дапамогай формы',
	'sf_formedit_createtitle' => 'Стварыць $1: $2',
	'sf_formedit_createtitlenotarget' => 'Стварыць $1',
	'sf_formedit_badurl' => "Гэтая старонка для рэдагаваньня праз форму. Вам неабходна пазначыць назву формы і мэтавую старонку ў URL-адрасе;
гэта павінна выглядаць наступным чынам: 'Special:FormEdit?form=<назва формы>&target=<мэтавая старонка>' альбо  'Special:FormEdit/<назва формы>/<мэтавая старонка>'.",
	'sf_formedit_altforms' => 'Замест гэтага Вы можаце дадаць старонку з дапамогай наступных формаў:',
	'sf_formedit_altformsonly' => 'Калі ласка, выберыце адну з наступных формаў для даданьня гэтай старонкі:',
	'sf_formcreate' => 'Стварыць з дапамогай формы',
	'sf_viewform' => 'Паказаць форму',
	'sf_editsource' => 'Рэдагаваць крыніцу',
	'sf_formedit_edittitle' => 'Рэдагаваньне $1: $2',
	'sf_formedit_morethanoneform' => 'Увага: для гэтай старонкі вызначана па змоўчваньні больш за адну форму.',
	'sf_formedit_formwarning' => 'Увага: старонка <a href="$1">ужо існуе</a>, але яна не выкарыстоўвае гэтую форму.',
	'sf_formedit_remove' => 'Выдаліць',
	'sf_formedit_addanother' => 'Дадаць іншую',
	'sf_formedit_none' => 'Нічога',
	'sf_formedit_emptytitle' => 'Памылка: уведзеныя выніковыя зьвесткі ў пустой назьве старонкі.',
	'sf_formedit_hookerror' => 'Памылка: пашырэньне MediaWiki не дазваляе зьмены мэтавай старонкі.',
	'sf_formedit_saveandcontinueediting' => 'Захаваць і працягваць',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Захаваць зьвесткі і працягваць рэдагаваньне',
	'sf_autoedit_anoneditwarning' => 'Папярэджаньне: Вы не ўвайшлі ў сыстэму. Ваш IP-адрас будзе запісаны ў гісторыі гэтай старонкі.',
	'sf_autoedit_success' => 'Пасьпяхова зьменены [[$1]] з дапамогай формы $2.',
	'sf_autoedit_notargetspecified' => 'Не пазначаная мэтавая старонка.',
	'sf_autoedit_noformfound' => 'Форма не пазначаная.',
	'sf_autoedit_toomanyformsfound' => 'Для старонкі даступна болей чым адна форма.',
	'sf_autoedit_readonly' => 'У цяперашні момант база зьвестак заблякаваная для зьменаў. Прычына: $1',
	'sf_autoedit_nosemanticform' => 'Немагчыма атрымаць форму $2 для старонкі $1. Глядзіце падрабязнасьці на [[{{#special:FormEdit}}/$2/$1]].',
	'runquery' => 'Выканаць запыт',
	'sf_runquery_badurl' => "Вам неабходна пазначыць назву формы ў URL-адрасе;
URL-адрас павінен мець выгляд 'Special:RunQuery/<назва формы>'.",
	'sf_runquery_title' => 'Выканаць запыт: $1',
	'sf_runquery_additionalquery' => 'Дадатковы запыт',
	'sf_formerrors_header' => 'Знойдзеныя памылкі ў Вашай форме ўводу; глядзіце ніжэй',
	'sf_blank_error' => 'ня можа быць пустым',
	'sf_bad_url_error' => "павінна мець слушны фармат URL, пачынацца з 'http'",
	'sf_bad_email_error' => 'павінна мець слушны фармат адрасу электроннай пошты',
	'sf_bad_number_error' => 'павінна быць слушным лікам',
	'sf_bad_date_error' => 'павінна быць слушнай датай',
	'uploadwindow' => 'Акно загрузкі',
	'sf_deletionlog' => 'Журнал выдаленьняў',
	'sf_property_isproperty' => 'Гэта ўласьцівасьць тыпу $1.',
	'sf_property_linkstoform' => 'Гэта ўласьцівасьць спасылаецца на старонкі, якія выкарыстоўваюць форму $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Дазволенае значэньне|Дазволеныя значэньні}} для гэтай уласьцівасьці:',
	'sf_template_docu' => "Гэта шаблён '$1', які павінен выклікацца наступным чынам:",
	'sf_template_docufooter' => 'Рэдагуйце старонку, каб убачыць тэкст шаблёну.',
	'sf_form_docu' => 'Гэта форма «$1».
Каб стварыць старонку з гэтай формай, увядзіце назву старонкі ніжэй;
калі старонка з такой назвай ужо існуе, Вы будзеце накіраваны на форму рэдагаваньня гэтай старонкі.',
	'sf_form_freetextlabel' => 'Свабодны тэкст',
	'sf_category_hasdefaultform' => 'Гэта катэгорыя выкарыстоўвае форму $1.',
	'sf_category_desc' => 'Гэта катэгорыя $1.',
	'sf_blank_namespace' => 'Галоўная',
	'right-viewedittab' => 'прагляд закладак «Рэдагаваць» для старонак, якія можна рэдагаваць праз форму', # Fuzzy
	'right-editrestrictedfields' => 'рэдагаваньне абмежаваных палёў форм',
	'right-createclass' => 'стварэньне новых сэмантычных клясаў',
);

/** Bulgarian (български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'specialpages-group-sf_group' => 'Семантични формуляри',
	'sf_createproperty_propname' => 'Име:', # Fuzzy
	'sf_createproperty_proptype' => 'Вид:',
	'templates' => 'Шаблони',
	'sf_templates_docu' => 'Следните шаблони съществуват в уикито.',
	'sf_templates_definescat' => 'дефинира категория: $1',
	'createtemplate' => 'Създаване на шаблон',
	'sf_createtemplate_namelabel' => 'Име на шаблон:',
	'sf_createtemplate_categorylabel' => 'Категория, дефинирана от шаблон (незадължително):',
	'sf_createtemplate_fieldname' => 'Име на полето:',
	'sf_createtemplate_semanticproperty' => 'Семантично свойство:',
	'sf_createtemplate_fieldislist' => 'Това поле може да съдържа само списък със стойности, разделени със запетаи',
	'sf_createtemplate_aggregationlabel' => 'Заглавие за списъка:',
	'sf_createtemplate_outputformat' => 'Изходен формат:',
	'sf_createtemplate_standardformat' => 'Стандартен', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Инфокутия в дясно', # Fuzzy
	'sf_createtemplate_addfield' => 'Добавяне на поле',
	'sf_createtemplate_deletefield' => 'Изтриване',
	'sf_createtemplate_addtemplatebeforesave' => 'Преди да бъде възможно съхраняването на формуляра е необходимо в него да бъде добавен поне един шаблон.',
	'forms' => 'Формуляри',
	'sf_forms_docu' => 'В уикито съществуват следните формуляри.',
	'createform' => 'Създаване на формуляр',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_field' => 'Поле:',
	'sf_createform_inputtypedefault' => '(по подразбиране)',
	'sf_createform_removetemplate' => 'Премахване на шаблон',
	'sf_createform_addtemplate' => 'Добавяне на шаблон:',
	'sf_createform_beforetemplate' => 'Преди шаблон:',
	'sf_createform_atend' => 'В края',
	'sf_createform_add' => 'Добавяне',
	'sf_createform_choosefield' => 'Избор на поле за добавяне',
	'createcategory' => 'Създаване на категория',
	'sf_createcategory_name' => 'Име:', # Fuzzy
	'sf_createcategory_defaultform' => 'Формуляр по подразбиране:',
	'formstart' => 'Добавяне на страница с формуляр',
	'sf_formstart_createoredit' => 'Добавяне или редактиране', # Fuzzy
	'formedit' => 'Редактиране с формуляр',
	'sf_formedit_createtitle' => 'Добавяне на $1: $2', # Fuzzy
	'sf_formedit_altformsonly' => 'Изберете един от следните формуляри за добавяне на страницата:',
	'sf_viewform' => 'Преглед на формуляра',
	'sf_editsource' => 'Редактиране на източника',
	'sf_formedit_edittitle' => 'Редактиране на $1: $2',
	'sf_formedit_formwarning' => 'Внимание: Тази страница <a href="$1">вече съществува</a>, но не използва този формуляр.',
	'sf_formedit_remove' => 'Премахване',
	'sf_formedit_none' => 'Няма',
	'sf_blank_error' => 'не може да бъде празно',
	'sf_bad_url_error' => "необходимо е да съдържа правилния URL формат, започващ с 'http'",
	'sf_bad_email_error' => 'необходимо е да съдържа валиден формат за е-поща',
	'sf_bad_number_error' => 'необходимо е да е валидно число',
	'sf_bad_date_error' => 'необходимо е да бъде валидна дата',
	'uploadwindow' => 'Прозорец за качване',
	'sf_template_docu' => "Това е шаблонът '$1'. Той следва да бъде извикван в следния формат:",
	'sf_template_docufooter' => 'Редактирането на страницата ще покаже текста на шаблона.',
	'sf_form_docu' => 'Това е формулярът \'$1".
За добавяне на страница с този формуляр, необходимо е да се въведе името на страницата по-долу;
ако страница с това име вече съществува, ще бъде отворен формуляр за редактиране на страницата.', # Fuzzy
	'sf_form_freetextlabel' => 'Свободен текст',
	'sf_category_hasdefaultform' => 'Тази категория използва формуляра $1.',
	'sf_category_desc' => 'Това е категорията $1.',
);

/** Banjar (Bahasa Banjar)
 * @author J Subhi
 */
$messages['bjn'] = array(
	'sf_formedit_createtitle' => 'Ma-ulah $1: $2',
	'sf_formedit_createtitlenotarget' => 'Ma-ulah $1',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Wikitanvir
 * @author Zaheen
 */
$messages['bn'] = array(
	'sf_createproperty_proptype' => 'ধরন:',
	'templates' => 'টেম্পলেটসমূহ',
	'sf_templates_docu' => 'উইকিটিতে নিচের টেমপ্লেটগুলো রয়েছে।',
	'sf_createtemplate_fieldname' => 'ফিল্ডের নাম:',
	'sf_createtemplate_aggregationlabel' => 'তালিকার শিরোনাম:',
	'sf_createtemplate_outputformat' => 'আউটপুটের বিন্যাস:',
	'sf_createtemplate_standardformat' => 'আদর্শ', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'ডান-হাতি তথ্যছক', # Fuzzy
	'sf_createtemplate_addfield' => 'ফিল্ড যোগ',
	'sf_createtemplate_deletefield' => 'অপসারণ',
	'forms' => 'ফরম',
	'sf_forms_docu' => 'উইকিটিতে নিচের ফর্মগুলো রয়েছে।',
	'createform' => 'ফর্ম তৈরি করুন',
	'sf_createform_nameinput' => 'ফর্মের নাম',
	'sf_createform_template' => 'টেম্পলেট:',
	'sf_createform_field' => 'ফিল্ড:',
	'sf_createform_hidden' => 'লুকায়িত',
	'sf_createform_removetemplate' => 'টেমপ্লেট অপসারণ',
	'sf_createform_addtemplate' => 'টেমপ্লেট যোগ:',
	'createcategory' => 'একটি বিষয়শ্রেণী যোগ করুন',
	'sf_createcategory_name' => 'বিষয়শ্রেণীর নাম:',
	'sf_createcategory_defaultform' => 'পূর্বনির্ধারিত ফর্ম:',
	'sf_formstart_createoredit' => 'তৈরি অথবা সম্পাদনা করুন',
	'formedit' => 'ফর্মসহ সম্পাদনা',
	'sf_formedit_createtitle' => 'তৈরি করুন $1: $2',
	'sf_formedit_createtitlenotarget' => 'তৈরি করুন $1',
	'sf_viewform' => 'ফর্ম দেখাও',
	'sf_editsource' => 'উৎস সম্পাদনা',
	'sf_formedit_edittitle' => 'সম্পাদনা $1: $2',
	'sf_formedit_remove' => 'অপসারণ',
	'sf_formedit_addanother' => 'অপর একটি যোগ করুন',
	'sf_formedit_none' => 'কোনটিই নয়',
	'sf_runquery_additionalquery' => 'অতিরিক্ত কোয়েরি',
	'sf_deletionlog' => 'অপসারণ লগ',
	'sf_form_freetextlabel' => 'মুক্ত লেখা',
	'sf_blank_namespace' => 'প্রধান',
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'semanticforms-desc' => 'Furmskrid evit ouzhpennañ hag aozañ roadennoù semantek',
	'specialpages-group-sf_group' => 'Furmskridoù semantek',
	'createproperty' => 'Krouiñ ur perzh',
	'sf_createproperty_linktoform' => 'Ar perzh-mañ a liammo ouzh ar pajennoù a implij ar furmskrid :',
	'sf_createproperty_propname' => 'Anv ar perzh :',
	'sf_createproperty_proptype' => 'Seurt :',
	'templates' => 'Patromoù',
	'sf_templates_docu' => 'Ar patromoù-mañ zo anezho dija er wiki.',
	'sf_templates_definescat' => 'termeniñ a ra ar rummad : $1',
	'createtemplate' => 'Sevel ur patrom',
	'sf_createtemplate_namelabel' => 'Anv ar patrom :',
	'sf_createtemplate_categorylabel' => 'Rummad termenet gant ar patrom-mañ (diret) :',
	'sf_createtemplate_templatefields' => 'Maeziennoù skouer',
	'sf_createtemplate_fieldname' => 'Anv ar vaezienn :',
	'sf_createtemplate_displaylabel' => 'Tikedenn diskwel :',
	'sf_createtemplate_semanticproperty' => 'Perzh semantek :',
	'sf_createtemplate_fieldislist' => "Er vaezienn-mañ e c'hall bezañ ur roll talvoudoù, dispartiet gant virgulennoù",
	'sf_createtemplate_aggregation' => 'Skolveuriadur',
	'sf_createtemplate_aggregationlabel' => 'Titl evit al listenn :',
	'sf_createtemplate_outputformat' => 'Furmad ezvont :',
	'sf_createtemplate_standardformat' => 'Standard', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Infobox dehou', # Fuzzy
	'sf_createtemplate_addfield' => 'Ouzhpennañ ur vaezienn',
	'sf_createtemplate_deletefield' => 'Diverkañ',
	'sf_createtemplate_addtemplatebeforesave' => "Ret eo deoc'h ouzhpennañ ur patrom da nebeutañ d'ar furmskrid-mañ a-raok gallout e enrollañ.",
	'forms' => 'Furmskridoù',
	'sf_forms_docu' => 'Ar furmskridoù-mañ zo anezho er wiki.',
	'sf_forminputs_mandatory' => 'Rekis',
	'sf_forminputs_restricted' => "N'hall an enmont-mañ bezañ kemmet nemet gant merourien",
	'sf_forminputs_size' => 'Ment ar vaezienn desten-mañ, en arouezennoù',
	'sf_forminputs_existingvaluesonly' => 'Aotren an talvoudoù zo war ar roll hepken',
	'createform' => 'Krouiñ ur furmskrid',
	'sf_createform_nameinput' => 'Anv ar furmskrid',
	'sf_createform_nameinputdesc' => '(ar boaz eo envel ar furmskrid diouzh anv e batrom pennañ) :',
	'sf_createform_template' => 'Patrom :',
	'sf_createform_templatelabelinput' => 'Tikedenn patrom (diret) :',
	'sf_createform_allowmultiple' => 'Aotren a ra eiladoù eus ar patrom-mañ (pe hini ebet) er bajenn grouet',
	'sf_createform_field' => 'Maezienn :',
	'sf_createform_fieldprop' => 'Ar vaezienn-mañ a dermen ar perzh $1, eus ar seurt $2.',
	'sf_createform_inputtype' => 'Doare moned :',
	'sf_createform_inputtypedefault' => '(dre ziouer)',
	'sf_createform_formlabel' => 'Label er furmskrid :',
	'sf_createform_hidden' => 'Kuzhet',
	'sf_createform_removetemplate' => 'Lemel ar skouer',
	'sf_createform_addtemplate' => 'Ouzhpennañ ur patrom :',
	'sf_createform_beforetemplate' => 'A-raok ar patrom :',
	'sf_createform_atend' => 'En dibenn',
	'sf_createform_add' => 'Ouzhpennañ',
	'sf_createform_choosefield' => 'Dibab ur vaezienn da ouzhpennañ',
	'createcategory' => 'Sevel ur rummad',
	'sf_createcategory_name' => 'Anv ar rummad :',
	'sf_createcategory_defaultform' => 'Furmskrid dre ziouer :',
	'sf_createcategory_makesubcategory' => 'Ober eus hemañ un isrummad eus ur rummad all (diret) :',
	'createclass' => "Krouiñ ur c'hlas",
	'sf_createclass_allowedvalues' => 'Talvoudennoù aotreet :',
	'sf_createclass_listofvalues' => 'Roll talvoudennoù ?',
	'sf_createclass_nameinput' => 'Anv ar furmskrid :',
	'sf_createclass_missingvalues' => "N'eo ket bet leuniet an holl vaeziennoù ret.",
	'sf_createclass_success' => 'Krouet e vo ar perzhioù, ar patrom ar furmskrid hag ar rummad.',
	'sf_createclass_create' => 'Krouiñ',
	'formstart' => 'Ouzhpennañ ur bajenn gant ur furmskrid',
	'sf_formstart_badform' => "Fazi : n'eus bet kavet pajenn furmskrid ebet en $1.",
	'sf_formstart_badtitle' => "Fazi : « $1 » n'eo ket un titl reizh evit ur bajenn.",
	'sf_formstart_createoredit' => 'Krouiñ pe kemmañ',
	'formedit' => 'Aozañ gant ur furmskrid',
	'sf_formedit_createtitle' => 'Krouiñ $1 : $2',
	'sf_formedit_createtitlenotarget' => 'Krouiñ $1',
	'sf_formedit_altforms' => "A-hend-all e c'hallit ouzhpennañ ar bajenn-mañ gant unan eus ar furmskridoù da-heul :",
	'sf_formedit_altformsonly' => 'Diuzit unan eus ar furmskridoù-mañ evit ouzhpennañ ar bajenn-mañ :',
	'sf_formcreate' => 'Krouiñ gant ur furmskrid',
	'sf_viewform' => 'Gwelet ar furmskrid',
	'sf_editsource' => 'Kemmañ ar vammenn',
	'sf_formedit_edittitle' => 'Aozañ $1: $2',
	'sf_formedit_morethanoneform' => "'''Evezh : ''' Ouzhpenn ur furmskrid dre ziouer zo termenet evit ar bajenn-mañ.",
	'sf_formedit_formwarning' => 'Evezh : Ar bajenn-mañ <a href="$1">zo anezhi dija</a>, met ne implij ket ar furmskrid-mañ.',
	'sf_formedit_remove' => 'Tennañ',
	'sf_formedit_addanother' => 'Ouzhpennañ unan all',
	'sf_formedit_none' => 'Hini ebet',
	'sf_formedit_saveandcontinueediting' => "Enrollañ ha kenderc'hel",
	'sf_formedit_tooltip_saveandcontinueediting' => "Enrollañ ar roadennoù ha kenderc'hel da zegas kemmoù",
	'sf_autoedit_anoneditwarning' => "'''Diwallit :''' N'oc'h ket kevreet. Ho chomlec'h IP eo a vo enrollet war istor kemmoù ar bajenn-mañ.",
	'sf_autoedit_success' => 'Kemmet ervat [[$1]] en ur ober gant furmskrid $2.',
	'runquery' => 'Seveniñ ar reked',
	'sf_runquery_badurl' => "Ret eo deoc'h diferañ un anv furmskrid en URL ;
Dleet e vefe d'an URL bezañ evel « Special:RunQuery/<anv ar furmskrid> ».",
	'sf_runquery_title' => 'Seveniñ ar reked : $1',
	'sf_runquery_additionalquery' => 'Reked ouzhpenn',
	'sf_formerrors_header' => 'Fazioù zo er furmskrid; gw. amañ dindan',
	'sf_blank_error' => "n'hall ket chom goullo",
	'sf_bad_url_error' => 'a rank kaout ur furmad URL reizh, o kregiñ gant "http"',
	'sf_bad_email_error' => "a rank kaout ur furmad chomlec'h postel reizh",
	'sf_bad_number_error' => 'a rank bezañ un niver reizh',
	'sf_bad_date_error' => 'a rank bezañ un deiziad reizh',
	'uploadwindow' => 'Kargañ ar prenestr',
	'sf_deletionlog' => 'Marilh an dilamadennoù',
	'sf-pageschemas-pagenameformula' => 'Formulenn anv ar bajenn :',
	'sf-pageschemas-createtitle' => 'Titl ar furmskrid evit ar pajennoù nevez :',
	'sf-pageschemas-edittitle' => "Titl ar furmskrid evit ar pajennoù zo anezho c'hoazh :",
	'sf-pageschemas-inputtype' => 'Seurt moned (lezel goullo evit an talvoud dre ziouer) :',
	'sf_property_isproperty' => 'Ar perzh-mañ zo eus ar seurt $1.',
	'sf_property_linkstoform' => 'Liammañ a ra ouzh ar pajennoù a implij ar furmskrid $1.',
	'sf_property_allowedvals' => 'An talvoudenn{{PLURAL:$1||où}} aotreet evit ar perzh-se a zo :',
	'sf_template_docu' => 'Hemañ eo ar patrom « $1 ».
Dleet e vefe bezañ galvet er furmad-mañ :',
	'sf_template_docufooter' => 'Aozañ ar bajenn evit gwelet testenn ar patrom.',
	'sf_form_docu' => "Setu amañ ar furmskrid « $1 ».
Evit krouiñ ur bajenn gant ar furmskrid-mañ, ebarzhit anv ar bajenn amañ dindan ;
Ma'z eus ur bajenn en anv-se dija, e viot kaset d'ur furmskrid a dalvez d'hec'h aozañ.",
	'sf_form_freetextlabel' => 'Testenn dieub',
	'sf_category_hasdefaultform' => 'Ar rummad-mañ a implij ar furmskrid $1.',
	'sf_category_desc' => 'Ar rummad $1 eo hemañ.',
	'sf_blank_namespace' => 'Pennañ',
	'right-viewedittab' => 'Gwelet an ivinell "kemmañ" evit ar pajennoù kemmus dre ur furmskrid', # Fuzzy
	'right-editrestrictedfields' => 'Aozañ maeziennoù strishaet ar furmskridoù',
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'semanticforms-desc' => 'Obrasci za dodavanje i uređivanje semantičkih podataka',
	'specialpages-group-sf_group' => 'Semantički obrasci',
	'createproperty' => 'Napravi osobinu',
	'sf_createproperty_linktoform' => 'Ovo svojstvo će voditi na stranice koje koriste obrazac:',
	'sf_createproperty_propname' => 'Naziv svojstva:',
	'sf_createproperty_proptype' => 'Vrsta:',
	'templates' => 'Šabloni',
	'sf_templates_docu' => 'Slijedeći šabloni postoje u wikiju.',
	'sf_templates_definescat' => 'definira kategoriju: $1',
	'createtemplate' => 'Napravi šablon',
	'sf_createtemplate_namelabel' => 'Ime šablona:',
	'sf_createtemplate_categorylabel' => 'Kategorija određena putem šablona (neobavezno):',
	'sf_createtemplate_templatefields' => 'Polja šablona',
	'sf_createtemplate_fieldname' => 'Ime polja:',
	'sf_createtemplate_displaylabel' => 'Prikaži naljepnicu:',
	'sf_createtemplate_semanticproperty' => 'Semantičko svojstvo:',
	'sf_createtemplate_fieldislist' => 'Ovo polje može sadržavati spisak vrijednosti, razdvojene zarezima',
	'sf_createtemplate_aggregationlabel' => 'Naslov za spisak:',
	'sf_createtemplate_outputformat' => 'Izlazni format:',
	'sf_createtemplate_standardformat' => 'Standardni', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Infokutija na desnoj strani', # Fuzzy
	'sf_createtemplate_addfield' => 'Dodaj polje',
	'sf_createtemplate_deletefield' => 'Obriši',
	'sf_createtemplate_addtemplatebeforesave' => 'Morate dodati najmanje jedan šablon u ovaj obrazac prije nego što ga sačuvate.',
	'forms' => 'Obrasci',
	'sf_forms_docu' => 'Slijedeći obrasci postoje u wikiju.',
	'sf_forminputs_mandatory' => 'Obavezno',
	'sf_forminputs_restricted' => 'Samo administratori mogu mijenjati ovaj unos',
	'createform' => 'Napravi obrazac',
	'sf_createform_nameinput' => 'Naziv obrasca',
	'sf_createform_template' => 'Šablon:',
	'sf_createform_templatelabelinput' => 'Naslov šablona (opcija):',
	'sf_createform_field' => 'Polje:',
	'sf_createform_fieldprop' => 'Ovo polje definira svojstvo $1 tipa $2.',
	'sf_createform_inputtype' => 'Tip unosa:',
	'sf_createform_inputtypedefault' => '(standardno)',
	'sf_createform_formlabel' => 'Naslov obrasca:',
	'sf_createform_hidden' => 'sakrivena',
	'sf_createform_removetemplate' => 'Ukloni šablon',
	'sf_createform_addtemplate' => 'Dodaj šablon:',
	'sf_createform_beforetemplate' => 'Prije šablona:',
	'sf_createform_atend' => 'Na kraju',
	'sf_createform_add' => 'Dodaj',
	'sf_createform_choosefield' => 'Izaberite polje za dodavanje',
	'createcategory' => 'Napravi kategoriju',
	'sf_createcategory_name' => 'Naziv kategorije:',
	'sf_createcategory_defaultform' => 'Pretpostavljeni obrazac:',
	'sf_createcategory_makesubcategory' => 'Učini ovo subkategorijom neke kategorije (neobavezno):',
	'createclass' => 'Napravi klasu',
	'sf_createclass_allowedvalues' => 'Dopuštene vrijednosti:',
	'sf_createclass_listofvalues' => 'Spisak vrijednosti?',
	'sf_createclass_missingvalues' => 'Nisu popunjena sva neophodna polja.',
	'formstart' => 'Dodaj stranicu putem obrasca',
	'sf_formstart_badform' => 'Greška: nije pronađena stranica obrasca na $1',
	'sf_formstart_createoredit' => 'Napravi ili uredi',
	'formedit' => 'Uredi sa obrascem',
	'sf_formedit_createtitle' => 'Napravi $1: $2',
	'sf_formedit_createtitlenotarget' => 'Napravi $1',
	'sf_formedit_altformsonly' => 'Molimo Vas da odaberete jedan od slijedećih obrazaca za dodavanje ovoj stranici:',
	'sf_formcreate' => 'Napravi sa obrascem',
	'sf_viewform' => 'Pogledaj obrazac',
	'sf_editsource' => 'Uredi izvor',
	'sf_formedit_edittitle' => 'Uređivanje $1: $2',
	'sf_formedit_remove' => 'Ukloni',
	'sf_formedit_addanother' => 'Dodaj slijedeći',
	'sf_formedit_none' => 'ništa',
	'runquery' => 'Pokreni upit',
	'sf_runquery_title' => 'Pokreni upit: $1',
	'sf_runquery_additionalquery' => 'Dodatni upiti',
	'sf_blank_error' => 'ne može biti prazno',
	'sf_bad_email_error' => 'mora se navesti valjan format e-mail adrese',
	'sf_bad_number_error' => 'mora biti validan broj',
	'sf_bad_date_error' => 'mora biti valjan datum',
	'uploadwindow' => 'Prozor za postavljanje',
	'sf_deletionlog' => 'Zapisnik brisanja',
	'sf_template_docu' => "Ovo je '$1' obrazac.
Trebao bi se nazvati u slijedećem formatu:",
	'sf_form_freetextlabel' => 'Slobodni tekst',
	'sf_category_hasdefaultform' => 'Ova kategorija koristi obrazac $1.',
	'sf_category_desc' => 'Ovo je $1 kategorija.',
	'sf_blank_namespace' => 'Glavno',
	'right-editrestrictedfields' => 'Uređivanje ograničenih polja obrazca',
);

/** Catalan (català)
 * @author Dvdgmz
 * @author Paucabot
 * @author SMP
 * @author Solde
 * @author Toniher
 */
$messages['ca'] = array(
	'semanticforms-desc' => 'Formularis per afegir i editar continguts semàntics.',
	'specialpages-group-sf_group' => 'Semantic Forms',
	'createproperty' => 'Crea una propietat',
	'sf-createproperty-with-name' => 'Crea la propietat: $1',
	'sf_createproperty_linktoform' => 'Aquesta propietat enllaçarà a pàgines que usin el formulari:',
	'sf_createproperty_allowedvalsinput' => 'Si voleu que aquest camp permeti només alguns valors específics, introduïu la llista dels valors permesos, separats per comes (si un valor conté una coma, substituïu-la per «\\,»):',
	'sf_createproperty_propname' => "Nom de l'atribut:",
	'sf_createproperty_proptype' => 'Tipus:',
	'templates' => 'Plantilles',
	'sf_templates_docu' => 'Les següents plantilles existeixen en el wiki.',
	'sf_templates_definescat' => 'Definir categoria: $1',
	'createtemplate' => 'Crea una plantilla',
	'sf-createtemplate-with-name' => 'Crea la plantilla: $1',
	'sf_createtemplate_namelabel' => 'Nom de la plantilla:',
	'sf_createtemplate_multipleinstance' => "Aquesta plantilla pot incloure's diverses vegades a la pàgina.",
	'sf_createtemplate_categorylabel' => 'Categoria definida mitjançant una plantilla (opcional):',
	'sf_createtemplate_templatefields' => 'Camps de la plantilla',
	'sf_createtemplate_fieldsdesc' => "Per disposar dels camps en aquesta plantilla no és necessari posar els noms dels camps, simplement introduïu l'índex de cada camp (per exemple: 1, 2, 3, etc.) com a denominació de cadascun d'ells, en lloc del seu nom real.",
	'sf_createtemplate_fieldname' => 'Nom del camp:',
	'sf_createtemplate_displaylabel' => 'Etiqueta per mostrar:',
	'sf_createtemplate_semanticproperty' => 'Propietat semàntica:',
	'sf_createtemplate_fieldislist' => 'Aquest camp pot suportar una llista de valors, separats per comes',
	'sf_createtemplate_aggregation' => 'Agregació',
	'sf_createtemplate_aggregationdesc' => 'Per crear una llista, a qualsevol pàgina que utilitzi aquesta plantilla, de tots els articles que tenen alguna propietat que apunta a aquesta pàgina, especifiqueu la propietat adequada a continuació:',
	'sf_createtemplate_aggregationlabel' => 'Títol del llistat:',
	'sf_createtemplate_outputformat' => 'Format de sortida:',
	'sf_createtemplate_standardformat' => 'Taula',
	'sf_createtemplate_infoboxformat' => 'Infocaixa lateral',
	'sf_createtemplate_plainformat' => 'Text net',
	'sf_createtemplate_sectionsformat' => 'Seccions',
	'sf_createtemplate_addfield' => 'Afegeix un camp',
	'sf_createtemplate_deletefield' => 'Elimina',
	'sf_createtemplate_addtemplatebeforesave' => "Per poder guardar-lo has d'afegir com a mínim una plantilla a aquest formulari.",
	'forms' => 'Formularis',
	'sf_forms_docu' => 'Els formularis següents ja existeixen al wiki.',
	'sf_forminputs_mandatory' => 'Obligatori',
	'sf_forminputs_restricted' => 'Només els administrador poden editar aquesta entrada',
	'sf_forminputs_class' => "L'atribut HTML «class» d'aquesta entrada",
	'sf_forminputs_default' => "El valor per defecte de l'entrada",
	'sf_forminputs_preload' => "Una pàgina wiki, els continguts de la qual seran el valor per defecte de l'entrada",
	'sf_forminputs_property' => 'Una propietat semàntica que correspon a aquest camp',
	'sf_forminputs_size' => 'La mida del camp de text, en caràcters',
	'sf_forminputs_maxlength' => "La longitud màxima permesa per al text d'aquest camp",
	'sf_forminputs_placeholder' => "Text d'ajuda que apareix a l'entrada fins que l'usuari hi fa clic",
	'sf_forminputs_uploadable' => "Col·loca un enllaç de «Puja un fitxer» al costat de l'entrada", # Fuzzy
	'sf_forminputs_defaultfilename' => 'El nom de fitxer per defecte dels fitxers carregats',
	'sf_forminputs_rows' => "El nombre de files de l'entrada",
	'sf_forminputs_cols' => "El nombre de columnes de l'entrada",
	'sf_forminputs_autogrow' => "Defineix que l'entrada pugui créixer en mida si el text supera els límits",
	'sf_forminputs_valuesfromproperty' => "Una propietat els valors de la qual en el wiki hauria de tenir un conjunt de valors d'aquesta entrada",
	'sf_forminputs_valuesfromcategory' => "Una categoria, les pàgines de la qual, hauria de tenir el conjunt de valors d'aquesta entrada",
	'sf_forminputs_valuesfromnamespace' => "Un espai de noms, les pàgines del qual seran el conjunt de valors d'aquesta entrada",
	'sf_forminputs_valuesfromconcept' => "Una pàgina «concepte» del Semantic MediaWiki, les pàgines del qual seran el conjunt de valors d'aquesta entrada",
	'sf_forminputs_valuesfromurl' => "Un URL que conté dades estructurades que seran el conjunt de valors d'aquesta entrada",
	'sf_forminputs_values' => "El conjunt de valors de l'entrada, separats per comes",
	'sf_forminputs_list' => "Marca que l'entrada contindrà una llista de valors",
	'sf_forminputs_delimiter' => "El delimitador entre els valors del camp, si l'entrada en conté una llista",
	'sf_forminputs_remoteautocompletion' => "Utilitza l'autocompleció remota",
	'sf_forminputs_existingvaluesonly' => 'Permet només valors que ja són a la llista',
	'sf_forminputs_showonselect' => 'Elements de pàgina per mostrar només si se seleccionen certs valors (p. ex.: «valor1=>div1;valor=>div2»)',
	'sf_forminputs_listboxsize' => "L'alçada d'aquesta caixa de llista, en files",
	'sf_forminputs_includetimezone' => 'Inclou una entrada per al fus horari',
	'sf_forminputs_topcategory' => "La categoria pare d'aquest conjunt de categories (obligatori)",
	'sf_forminputs_hideroot' => 'Amaga la categoria pare',
	'sf_forminputs_depth' => 'El nombre de nivells de categoria que es mostraran inicialment',
	'sf_forminputs_height' => "L'alçada de l'entrada, en píxels",
	'sf_forminputs_width' => "L'amplada de l'entrada, en píxels",
	'createform' => 'Crea un formulari',
	'sf-createform-with-name' => 'Crea el formulari: $1',
	'sf_createform_nameinput' => 'Nom del formulari',
	'sf_createform_nameinputdesc' => '(el formulari normalment rep el mateix nom com que la plantilla principal):',
	'sf_createform_template' => 'Plantilla:',
	'sf_createform_templatelabelinput' => 'Etiqueta de la plantilla (opcional):',
	'sf_createform_allowmultiple' => "Permet múltiples (o cap) instàncies d'aquesta plantilla en la pàgina a crear",
	'sf_createform_field' => 'Camp:',
	'sf_createform_fieldprop' => 'Aquest camp defineix la propietat $1, de tipus $2',
	'sf_createform_fieldproplist' => "Aquest camp defineix una llista d'elements que tenen la propietat $1, de tipus $2",
	'sf_createform_fieldpropunknowntype' => "Aquest camp defineix la propietat $1, de la qual no se n'ha especificat el tipus.",
	'sf_createform_inputtype' => "Tipus d'entrada:",
	'sf_createform_inputtypedefault' => '(per defecte)',
	'sf_createform_formlabel' => 'Etiqueta de formulari:',
	'sf_createform_hidden' => 'Amagat',
	'sf_createform_removetemplate' => 'Suprimeix la plantilla',
	'sf_createform_addtemplate' => 'Afegeix una plantilla:',
	'sf_createform_beforetemplate' => 'Plantilla anterior:',
	'sf_createform_atend' => 'Al final',
	'sf_createform_add' => 'Afegeix',
	'sf_createform_choosefield' => 'Trieu un camp per afegir',
	'createcategory' => 'Crea una categoria',
	'sf-createcategory-with-name' => 'Crea la categoria: $1',
	'sf_createcategory_name' => 'Nom de la categoria:',
	'sf_createcategory_defaultform' => 'Formulari per defecte:',
	'sf_createcategory_makesubcategory' => "Fes que aquesta sigui una subcategoria d'una altra categoria (opcional):",
	'createclass' => 'Crea una classe',
	'sf_createclass_docu' => "Introduïu totes les dades a continuació per crear les propietats, plantilla i categoria d'una única classe. Per a més opcions, feu servir millor les pàgines $1.",
	'sf_createclass_allowedvalues' => 'Valors permesos:',
	'sf_createclass_listofvalues' => 'Cap llista de valors?',
	'sf_createclass_nameinput' => 'Nom del formulari:',
	'sf_createclass_missingvalues' => "No s'han omplert tots els camps necessaris.",
	'sf_createclass_success' => 'Es crearan propietats, plantilla, formulari i categoria.',
	'sf_createclass_create' => 'Crea',
	'formstart' => 'Afegeix pàgina via formulari',
	'sf_formstart_badform' => "Error: no s'ha trobat una pàgina de formulari a $1",
	'sf_formstart_badtitle' => "Error: «$1» no és un títol vàlid d'una pàgina.",
	'sf_formstart_docu' => "Introduïu el nom de la pàgina a continuació, per ser editada amb el formulari «$1».
Si aquesta pàgina ja existeix, s'obrirà el formulari per editar-la.
Si no, s'obrirà el formulari per afegir una pàgina nova.",
	'sf_formstart_noform_docu' => "Introduïu a continuació el nom de la pàgina i seleccioneu un formulari per editar-la.
Si aquesta pàgina ja existeix, s'obrirà el formulari per editar-la.
Si no, s'obrirà el formulari per afegir una pàgina nova.",
	'sf_formstart_createoredit' => 'Crea o modifica',
	'formedit' => 'Modifica amb formulari',
	'sf_formedit_createtitle' => 'Crea $1: $2',
	'sf_formedit_createtitlenotarget' => 'Crea $1',
	'sf_formedit_badurl' => "Aquesta és la pàgina per editar amb un formulari. Cal que especifiqueu a l'URL tant un nom de formulari com una pàgina de destí;
ha de ser quelcom similar a 'Especial:FormEdit?form=<nom_formulari>&target=<pàgina_destí>', o bé 'Especial:FormEdit/<nom_formulari>/<pàgina_destí>'.",
	'sf_formedit_altforms' => 'Alternativament pots afegir aquesta pàgina amb un dels formularis següents:',
	'sf_formedit_altformsonly' => 'Seleccioneu un formulari entre els següents per afegir aquesta pàgina:',
	'sf_formcreate' => 'Crea amb formulari',
	'sf_viewform' => 'Visualitza el formulari',
	'sf_editsource' => 'Modifica el codi',
	'sf_formedit_edittitle' => 'Edita $1: $2',
	'sf_formedit_morethanoneform' => "'''Avís:''' s'ha definit més d'un formulari per defecte en aquesta pàgina.",
	'sf_formedit_formwarning' => 'Atenció: Aquesta pàgina <a href="$1">ja existeix</a>, però no fa servir aquest formulari.',
	'sf_formedit_mismatchedbrackets' => 'Avís: la pàgina conté claus o claudàtors que no s\'han tancat, per tant el formulari no podrà gestionar correctament la pàgina. <a href="$1">Arregleu-ne l\'error en el text del codi</a> abans de procedir.',
	'sf_formedit_remove' => 'Elimina',
	'sf_formedit_addanother' => 'Afegeix-ne un altre',
	'sf_formedit_none' => 'Cap',
	'sf_formedit_emptytitle' => 'Error: les dades inserides donen lloc a un títol de pàgina en blanc.',
	'sf_formedit_hookerror' => 'Error: una extensió de MediaWiki ha evitat que es modifiqui la pàgina objectiu.',
	'sf_formedit_saveandcontinueediting' => 'Desa i continua',
	'sf_formedit_saveandcontinue_summary' => 'Desat fent servir el botó «$1» al formulari',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Desa les dades i continua editant',
	'sf_autoedit_anoneditwarning' => "Avís: no heu iniciat una sessió. La vostra adreça IP s'enregistrarà en l'historial d'edició de la pàgina.",
	'sf_autoedit_success' => "S'ha modificat amb èxit [[$1]] fent servir el formulari $2.",
	'sf_autoedit_fail' => 'Ha fallat la modificació de [[$1]].',
	'sf_autoedit_notargetspecified' => "No s'ha especificat cap pàgina de destinació.",
	'sf_autoedit_invalidtargetspecified' => 'La pàgina de destinació especificada $1 no és vàlida.',
	'sf_autoedit_invalidform' => '$1 no és un formulari vàlid.',
	'sf_autoedit_redirectlimitexeeded' => "S'ha excedit el límit màxim de redireccions del formulari $1.",
	'sf_autoedit_invalidredirecttarget' => '$1 és una destinació de redirecció no vàlida per al formulari $2.',
	'sf_autoedit_invalidpreloadspecified' => 'La pàgina de precàrrega especificada $1 no és vàlida.',
	'sf_autoedit_redlinkexists' => '$1 ja existeix.',
	'sf_autoedit_noformfound' => "No s'ha especificat cap formulari.",
	'sf_autoedit_toomanyformsfound' => "Hi ha més d'un formulari disponible per pàgina.",
	'sf_autoedit_readonly' => 'La base de dades es troba actualment bloquejada a les modificacions. Motiu: $1',
	'sf_autoedit_nosemanticform' => "No s'ha pogut aconseguir el formulari $2 de la pàgina $1. Consulteu [[{{#special:FormEdit}}/$2/$1]] per a més detalls.",
	'sf_autoedit_summary' => 'Editat automàticament de la pàgina $1.',
	'sf-autoedit-wait' => 'Espereu…',
	'runquery' => 'Executa la consulta',
	'sf_runquery_badurl' => "Heu d'especificar un nom de formulari a l'URL;
l'URL hauria de ser com 'Especial:RunQuery/<nom_formulari>'.",
	'sf_runquery_title' => 'Executa consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta addicional',
	'sf_formerrors_header' => 'Hi ha hagut errors en les teves entrades al formulari; veure a continuació',
	'sf_blank_error' => 'no es pot deixar en blanc',
	'sf_bad_url_error' => "ha de tenir un format de URL correcte, començant per 'http'",
	'sf_bad_email_error' => "ha de tenir un format vàlid d'adreça de correu electrònic",
	'sf_bad_number_error' => 'ha de ser un nombre vàlid',
	'sf_bad_date_error' => 'ha de ser una data vàlida',
	'uploadwindow' => 'Finestra de càrrega',
	'sf_deletionlog' => "Registre d'eliminació",
	'sf-preview-header' => 'Previsualització del formulari',
	'sf-preview-note' => "Aquest és l'aspecte del formulari quan estigui en ús:",
	'sf-pageschemas-pagenameformula' => 'Fórmula del nom de la pàgina:',
	'sf-pageschemas-createtitle' => 'Títol de formulari de les pàgines noves:',
	'sf-pageschemas-edittitle' => 'Títol de formulari de les pàgines existents:',
	'sf-pageschemas-inputtype' => "Tipus d'entrada (deixeu-ho en blanc per definir-ho al valor per defecte):",
	'sf_property_isproperty' => 'Aquesta és una propietat del tipus $1.',
	'sf_property_linkstoform' => 'Enllaça a pàgines que usen el formulari $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|El valor permès per a aquesta propietat és|Els valors permesos per a aquestes propietats són}}:',
	'sf_template_docu' => "Aquesta és la plantilla '$1'.
Que ha de ser cridada en el format següent:",
	'sf_template_docufooter' => 'Edita la pàgina per veure el text de la plantilla.',
	'sf_form_docu' => "Aquest és el formulari '$1'.
Per crear una pàgina amb aquest formulari, entreu el nom de la pàgina a continuació;
si la pàgina amb aquest nom ja existeix, s'obrirà un formulari per editar-la.",
	'sf_form_freetextlabel' => 'Text lliure',
	'sf_category_hasdefaultform' => 'Aquesta categoria fa servir el formulari $1.',
	'sf_category_desc' => 'Aquesta és la categoria $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Mostra la pestanya «{{int:edit}}» a les pàgines que es poden editar amb un formulari',
	'right-editrestrictedfields' => 'Editar les caselles restringides del formulari',
	'right-createclass' => 'Crea noves classes semàntiques',
	'action-createclass' => 'crea classes semàntiques noves',
	'action-editrestrictedfields' => 'modifica els camps de formulari restringits',
	'action-viewedittab' => 'Mostra la pestanya «{{int:edit}}» a les pàgines que es poden editar amb un formulari',
);

/** Chechen (нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'templates' => 'Куцкепаш',
	'sf_createform_template' => 'Куцкеп:',
	'sf_createform_addtemplate' => 'Тlетоха куцкеп:',
	'sf_formedit_none' => 'Хlумма цаоьшу',
);

/** Sorani Kurdish (کوردی)
 */
$messages['ckb'] = array(
	'sf_createtemplate_deletefield' => 'سڕینەوە',
);

/** Czech (česky)
 * @author Juan de Vojníkov
 * @author Juandev
 * @author Matěj Grabovský
 * @author Mormegil
 * @author Reaperman
 * @author Vks
 */
$messages['cs'] = array(
	'createproperty' => 'Vytvořit vlastnost',
	'sf_createproperty_propname' => 'Název:', # Fuzzy
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Šablony',
	'createtemplate' => 'Vytvořit šablonu',
	'sf_createtemplate_namelabel' => 'Název šablony:',
	'sf_createtemplate_templatefields' => 'Pole šablony',
	'sf_createtemplate_fieldname' => 'Název pole:',
	'sf_createtemplate_displaylabel' => 'Zobrazované označení:',
	'sf_createtemplate_semanticproperty' => 'Sémantická vlastnost:',
	'sf_createtemplate_fieldislist' => 'Toto pole může obsahovat seznam hodnot oddělených čárkami',
	'sf_createtemplate_outputformat' => 'Výstupní formát:',
	'sf_createtemplate_standardformat' => 'Tabulka',
	'sf_createtemplate_plainformat' => 'Prostý text',
	'sf_createtemplate_addfield' => 'Přidat pole',
	'sf_createtemplate_deletefield' => 'Smazat',
	'forms' => 'Formuláře',
	'sf_createform_nameinput' => 'Název formuláře',
	'sf_createform_template' => 'Šablona:',
	'sf_createform_field' => 'Pole:',
	'sf_createform_inputtypedefault' => '(výchozí)',
	'sf_createform_hidden' => 'Skrytý',
	'sf_createform_add' => 'Přidat',
	'sf_createclass_create' => 'Založit',
	'sf_formstart_createoredit' => 'Vytvořit nebo upravit',
	'sf_formedit_remove' => 'Odstranit',
	'sf_formedit_none' => 'Nic',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Uložit a pokračovat v úpravách',
	'sf-autoedit-wait' => 'Čekejte...',
	'sf_deletionlog' => 'Kniha smazaných stránek',
	'sf_blank_namespace' => 'Hlavní',
	'right-viewedittab' => 'Zobrazování záložky „Editovat“ na stránkách editovatelných pomocí formuláře', # Fuzzy
	'right-editrestrictedfields' => 'Editování polí formulářů s omezeným přístupem',
	'right-createclass' => 'Zakládání nových sémantických tříd',
);

/** Church Slavic (словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'sf_createtemplate_deletefield' => 'поничьжє́ниѥ',
);

/** Danish (dansk)
 * @author Jon Harald Søby
 */
$messages['da'] = array(
	'sf_createproperty_propname' => 'Navn:', # Fuzzy
	'sf_createtemplate_standardformat' => 'Standard', # Fuzzy
	'sf_createtemplate_deletefield' => 'Slet',
	'sf_createform_template' => 'Skabelon:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createcategory_name' => 'Navn:', # Fuzzy
	'sf_formedit_none' => 'Ingen',
);

/** German (Deutsch)
 * @author Als-Holder
 * @author Cipher
 * @author DaSch
 * @author Dominik Rodler
 * @author F.trott
 * @author Goetz
 * @author Kghbln
 * @author Melancholie
 * @author Metalhead64
 * @author Pill
 * @author Purodha
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de'] = array(
	'semanticforms-desc' => 'Ermöglicht Formulare zum Hinzufügen und Bearbeiten semantischer Daten',
	'specialpages-group-sf_group' => 'Semantische Formulare',
	'createproperty' => 'Ein Attribut erstellen',
	'sf-createproperty-with-name' => 'Attribut erstellen: $1',
	'sf_createproperty_linktoform' => 'Dieses Attribut wird auf Seiten weisen, die nachfolgendes Formular nutzen:',
	'sf_createproperty_allowedvalsinput' => 'Sofern du für dieses Attribut nur bestimmte Werte zulassen möchtest, gib diese bitte in Form einer kommagetrennten Liste an (falls ein Wert ein Komma enthält, musst du es durch „\\,“ ersetzen):',
	'sf_createproperty_propname' => 'Attributname:',
	'sf_createproperty_proptype' => 'Datentyp:',
	'templates' => 'Vorlagen',
	'sf_templates_docu' => 'Die folgenden Vorlagen sind in diesem Wiki vorhanden:',
	'sf_templates_definescat' => 'definiert die Kategorie: $1',
	'createtemplate' => 'Eine Vorlage erstellen',
	'sf-createtemplate-with-name' => 'Vorlage erstellen: $1',
	'sf_createtemplate_namelabel' => 'Vorlagenname:',
	'sf_createtemplate_multipleinstance' => 'Diese Vorlage kann mehrfach in eine Seite eingebettet werden.',
	'sf_createtemplate_categorylabel' => 'Durch Vorlage definierte Kategorie (optional Angabe):',
	'sf_createtemplate_templatefields' => 'Vorlagenfelder',
	'sf_createtemplate_fieldsdesc' => 'Sofern die Felder dieser Vorlage keinen Feldnamen benötigen, ist es zur Unterscheidung ausreichend, sie aufsteigend mit Zahlen zu indexieren (z. B. 1, 2, 3, usw.).',
	'sf_createtemplate_fieldname' => 'Feldname:',
	'sf_createtemplate_displaylabel' => 'Anzuzeigender Feldname:',
	'sf_createtemplate_semanticproperty' => 'Semantisches Attribut:',
	'sf_createtemplate_fieldislist' => 'Dieses Feld kann eine Liste von Werten enthalten, die durch Kommata getrennt werden.',
	'sf_createtemplate_aggregation' => 'Zusammenfassung',
	'sf_createtemplate_aggregationdesc' => 'Es ist möglich auf allen Seiten, die diese Vorlage benutzen, alle Seiten aufzulisten, die über ein bestimmtes Attribut verfügen, das auf diese Seite verweist. Hierzu muss dass entsprechende Attribut angegeben werden:',
	'sf_createtemplate_aggregationlabel' => 'Name für die Liste:',
	'sf_createtemplate_outputformat' => 'Ausgabeformat:',
	'sf_createtemplate_standardformat' => 'Tabelle',
	'sf_createtemplate_infoboxformat' => 'Seitlicher Informationsbereich',
	'sf_createtemplate_plainformat' => 'Klartext',
	'sf_createtemplate_sectionsformat' => 'Abschnitte',
	'sf_createtemplate_addfield' => 'Weiteres Feld hinzufügen',
	'sf_createtemplate_deletefield' => 'Löschen',
	'sf_createtemplate_addtemplatebeforesave' => 'Hinweis: Du musst mindestens eine Vorlage zu diesem Formular hinzufügen, bevor du es speichern kannst.',
	'forms' => 'Formulare',
	'sf_forms_docu' => 'Die folgenden Formulare sind in diesem Wiki vorhanden:',
	'sf_forminputs_mandatory' => 'In dieses Eingabefeld muss ein Wert eingegeben werden',
	'sf_forminputs_restricted' => 'Nur Administratoren können dieses Eingabefeld bearbeiten',
	'sf_forminputs_class' => 'Das HTML-Attribut „class“ für dieses Eingabefeld',
	'sf_forminputs_default' => 'Der Standardwert für dieses Eingabefeld',
	'sf_forminputs_preload' => 'Eine Wikiseite dessen Inhalt der Standardwert dieses Eingabefelds werden wird',
	'sf_forminputs_property' => 'Ein semantisches Attribut, dass diesem Eingabefeld entspricht',
	'sf_forminputs_size' => 'Die Größe dieses Textfelds (in Zeichen)',
	'sf_forminputs_maxlength' => 'Die maximal zulässige Länge des Textes in diesem Eingabefeld',
	'sf_forminputs_placeholder' => 'Der Hilfetext, der angezeigt wird, bis der Benutzer ihn anklickt',
	'sf_forminputs_uploadable' => 'Einen Link zum Hochladen einer Datei („{{int:upload}}“) neben diesem Eingabefeld platzieren',
	'sf_forminputs_defaultfilename' => 'Der Standarddateiname für hochgeladene Dateien',
	'sf_forminputs_rows' => 'Die Anzahl der Zeilen für dieses Eingabefeld',
	'sf_forminputs_cols' => 'Die Anzahl der Spalten für dieses Eingabefeld',
	'sf_forminputs_autogrow' => 'Größenwachstum für dieses Eingabefeld erlauben, sofern der Eingabetext dessen Standardgröße überschreitet.',
	'sf_forminputs_valuesfromproperty' => 'Ein Attribut, dessen im Wiki vorhandenen Werte die Eingabewerte dieses Eingabefelds sein sollen',
	'sf_forminputs_valuesfromcategory' => 'Eine Kategorie, dessen im Wiki zugeordneten Seiten die Eingabewerte dieses Eingabefelds sein sollen',
	'sf_forminputs_valuesfromnamespace' => 'Ein Namensraum, dessen im Wiki vorhandenen Seiten die Eingabewerte dieses Eingabefelds sein sollen',
	'sf_forminputs_valuesfromconcept' => 'Eine dynamische Kategorie („Konzept“), dessen im Wiki zugeordneten Seiten die Eingabewerte dieses Eingabefelds sein sollen',
	'sf_forminputs_valuesfromurl' => 'Eine URL, die strukturierte Daten enthält, welche die Eingabewerte dieses Eingabefelds sein sollen',
	'sf_forminputs_values' => 'Eine Anzahl durch Kommata getrennter Werte, welche die Eingabewerte dieses Eingabefelds sein sollen',
	'sf_forminputs_list' => 'Dieses Eingabefeld als Eingabefeld mit einer Reihe von Eingabewerten markieren',
	'sf_forminputs_delimiter' => 'Das Trennzeichen zwischen den Eingabewerten, sofern dieses Eingabefeld über eine Reihe von Eingabewerten verfügt',
	'sf_forminputs_remoteautocompletion' => 'Autovervollständigung mit wikifremden (entfernten) Eingabewerten',
	'sf_forminputs_existingvaluesonly' => 'Nur Werte zulassen, die sich bereits in der Liste befinden',
	'sf_forminputs_showonselect' => 'Anzuzeigende Seitenelemente sofern bestimmte Eingabewerte ausgewählt wurden (Beispiel: „Wert1→Element1; Wert2→Element2“)',
	'sf_forminputs_listboxsize' => 'Die Höhe dieses Listenfelds in Zeilen',
	'sf_forminputs_includetimezone' => 'Ein Eingabefeld für die Zeitzone bereitstellen',
	'sf_forminputs_topcategory' => 'Die übergeordnete Kategorie dieser Reihe von Kategorien (erforderliche Angabe)',
	'sf_forminputs_hideroot' => 'Die übergeordnete Kategorie ausblenden',
	'sf_forminputs_depth' => 'Die Anzahl der Kategorieebenen, die zunächst angezeigt werden sollen',
	'sf_forminputs_height' => 'Die Höhe dieses Eingabefelds (in Pixeln)',
	'sf_forminputs_width' => 'Die Breite dieses Eingabefelds (in Pixeln)',
	'createform' => 'Ein Formular erstellen',
	'sf-createform-with-name' => 'Formular erstellen: $1',
	'sf_createform_nameinput' => 'Formularname',
	'sf_createform_nameinputdesc' => '(In der Regel wird das das Formular nach der Hauptvorlage benannt):',
	'sf_createform_template' => 'Vorlage:',
	'sf_createform_templatelabelinput' => 'Vorlagenbezeichnung (optional):',
	'sf_createform_allowmultiple' => 'Erlaube mehrere (oder keine) Instanzen dieser Vorlage auf der erstellten Seite',
	'sf_createform_field' => 'Feld:',
	'sf_createform_fieldprop' => 'Dieses Feld definiert das Attribut $1 vom Datentyp $2.',
	'sf_createform_fieldproplist' => 'Dieses Feld definiert eine Liste an Werten, die das Attribut $1 vom Datentyp $2 besitzen.',
	'sf_createform_fieldpropunknowntype' => 'Dieses Feld definiert das Attribut $1 eines nicht angegebenen Datentyps.',
	'sf_createform_inputtype' => 'Eingabetyp:',
	'sf_createform_inputtypedefault' => '(Standardwert)',
	'sf_createform_formlabel' => 'Formularbezeichnung:',
	'sf_createform_hidden' => 'Versteckt',
	'sf_createform_removetemplate' => 'Vorlage entfernen',
	'sf_createform_addtemplate' => 'Vorlage hinzufügen:',
	'sf_createform_beforetemplate' => 'Vor der Vorlage:',
	'sf_createform_atend' => 'am Ende',
	'sf_createform_add' => 'Hinzufügen',
	'sf_createform_choosefield' => 'Ein Feld auswählen, das hinzugefügt werden soll',
	'createcategory' => 'Eine Kategorie erstellen',
	'sf-createcategory-with-name' => 'Kategorie erstellen: $1',
	'sf_createcategory_name' => 'Kategoriename:',
	'sf_createcategory_defaultform' => 'Standardformular:',
	'sf_createcategory_makesubcategory' => 'Diese Kategorie zu einer Unterkategorie einer anderen Kategorie machen (optional):',
	'createclass' => 'Eine Klasse erstellen',
	'sf_createclass_docu' => 'Gib hier alle Daten ein, um die Attribute, die Vorlage, das Formular und die Kategorie für eine einzelne Klasse zu erstellen.
Bitte nutze eine der folgenden Seiten für weitere Optionen: $1.',
	'sf_createclass_allowedvalues' => 'Erlaubte Werte:',
	'sf_createclass_listofvalues' => 'Werteliste?',
	'sf_createclass_nameinput' => 'Formularname:',
	'sf_createclass_missingvalues' => 'Es wurden nicht alle benötigten Felder ausgefüllt.',
	'sf_createclass_success' => 'Die Attribute, die Vorlage, das Formular und die Kategorie werden erstellt.',
	'sf_createclass_create' => 'Erstellen',
	'formstart' => 'Mit Formular hinzufügen',
	'sf_formstart_badform' => 'Fehler: Das Formular $1 wurde nicht gefunden.',
	'sf_formstart_badtitle' => 'Fehler: „$1“ ist kein gültiger Seitenname.',
	'sf_formstart_docu' => 'Gib in dieses Textfeld den Namen der Seite ein, die mit dem Formular „$1“ bearbeitet werden soll.
Sofern bereits eine Seite dieses Namens vorhanden ist, wird das Formular aufgerufen, mit dem du sie bearbeiten kannst.
Andernfalls wird das Formular zum Erstellen der Seite aufgerufen.',
	'sf_formstart_noform_docu' => 'Gib in dieses Textfeld den Namen der Seite ein und wähle das Formular aus, mit dem sie bearbeitet werden soll.
Sofern bereits eine Seite dieses Namens vorhanden ist, wird das Formular aufgerufen, mit dem du sie bearbeiten kannst.
Andernfalls wird das Formular zum Erstellen der Seite aufgerufen.',
	'sf_formstart_createoredit' => 'Erstellen oder bearbeiten',
	'formedit' => 'Mit Formular bearbeiten',
	'sf_formedit_createtitle' => '$1 erstellen: $2',
	'sf_formedit_createtitlenotarget' => 'Erstelle $1',
	'sf_formedit_badurl' => 'Dies ist die Spezialseite zum Bearbeiten einer Seite mit einem Formular. Du musst den Namen eines Formulars und den Namen der zu bearbeitenden Seite in der URL angeben.
Die URL sollte wie folgt aussehen: „Spezial:Mit_Formular_bearbeiten?form=<Formularname>&target=<Seitenname>“ oder „Spezial:Mit_Formular_bearbeiten/<Formularname>/<Seitenname>“.',
	'sf_formedit_altforms' => 'Alternativ kann diese Seite mit einem der folgenden Formulare erstellt werden:',
	'sf_formedit_altformsonly' => 'Bitte eines der folgenden Formulare auswählen, um diese Seite zu erstellen:',
	'sf_formcreate' => 'Mit Formular erstellen',
	'sf_viewform' => 'Formular anzeigen',
	'sf_editsource' => 'Quelltext bearbeiten',
	'sf_formedit_edittitle' => 'Bearbeite $1: $2',
	'sf_formedit_morethanoneform' => "'''Warnung:''' Es ist mehr als ein Standardformular für diese Seite definiert.",
	'sf_formedit_formwarning' => 'Warnung: Diese Seite <a href="$1">ist bereits vorhanden</a>, nutzt aber nicht dieses Formular.',
	'sf_formedit_mismatchedbrackets' => 'Warnung: Diese Seite enthält geschweifte oder eckige Klammern, die nicht entsprechend geschlossen sind. Die Seite kann daher nicht richtig vom Formular verarbeitet werden. Bitte vor dem Weitermachen den <a href="$1">Fehler im Quellcode korrigieren</a>.',
	'sf_formedit_remove' => 'Diese Instanz entfernen',
	'sf_formedit_addanotherabove' => 'Eine weitere Instanz oberhalb dieser hinzufügen',
	'sf_formedit_addanother' => 'Weitere hinzufügen',
	'sf_formedit_none' => 'Keine Angabe',
	'sf_formedit_emptytitle' => 'Fehler: Die eingegebenen Daten ergeben einen leeren Seitentitel.',
	'sf_formedit_hookerror' => 'Fehler: Eine MediaWiki-Programmerweiterung hat die Änderung des Zielartikels verhindert.',
	'sf_formedit_saveandcontinueediting' => 'Zwischenspeichern',
	'sf_formedit_saveandcontinue_summary' => 'Wurde mit Schaltfläche „$1“ im Formular gespeichert',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Eingaben speichern und Bearbeitung fortsetzen',
	'sf_autoedit_anoneditwarning' => "Warnung: Diese Seite wird gerade unangemeldet bearbeitet. Beim Speichern wird die aktuelle IP-Adresse des Bearbeiters in der Versionsgeschichte aufgezeichnet und ist damit unwiderruflich '''öffentlich''' einsehbar.",
	'sf_autoedit_success' => '[[$1]] mittels Formular $2 erfolgreich geändert.',
	'sf_autoedit_fail' => 'Die Änderung von [[$1]] ist fehlgeschlagen.',
	'sf_autoedit_notargetspecified' => 'Es wurde keine Zielseite angegeben.',
	'sf_autoedit_invalidtargetspecified' => 'Die angegebene Zielseite $1 ist ungültig.',
	'sf_autoedit_invalidform' => '$1 ist kein gültiges Formular.',
	'sf_autoedit_redirectlimitexeeded' => 'Die maximale Anzahl zulässiger Weiterleitungen für Formular $1 wurde überschritten.',
	'sf_autoedit_invalidredirecttarget' => '$1 ist ein ungültiges Weiterleitungsziel für Formular $2.',
	'sf_autoedit_invalidpreloadspecified' => 'Die angegebene, vorab zu ladende, Seite $1 ist ungültig.',
	'sf_autoedit_redlinkexists' => 'Die Seite $1 ist bereits vorhanden.',
	'sf_autoedit_noformfound' => 'Es wurde kein Formular angegeben.',
	'sf_autoedit_toomanyformsfound' => 'Für diese Seite ist mehr als ein Formular verfügbar.',
	'sf_autoedit_readonly' => 'Die Datenbank ist derzeit für Bearbeitungen gesperrt. Grund: $1',
	'sf_autoedit_nosemanticform' => 'Das Formular $2 konnte nicht für Seite $1 abgerufen werden. Siehe [[{{#special:FormEdit}}/$2/$1]] für Informationen hierzu.',
	'sf_autoedit_summary' => 'Automatisch von Seite $1 bearbeitet.',
	'sf-autoedit-wait' => 'Verarbeite …',
	'runquery' => 'Abfrage ausführen',
	'sf_runquery_badurl' => 'In der URL wurde nicht der Name des Formulars angegeben.
Die URL sollte wie folgt aussehen: „Spezial:Abfrage_ausführen/<Formularname>”',
	'sf_runquery_title' => 'Ausgeführte Abfrage: $1',
	'sf_runquery_additionalquery' => 'Ergänzende Abfrage',
	'sf_formerrors_header' => 'Deine Eingabe ist fehlerhaft oder unvollständig. Siehe hierzu die Hinweise unten, neben dem jeweiligen Formularfeld.',
	'sf_blank_error' => 'Darf nicht leer sein',
	'sf_bad_url_error' => 'muss ein gültiges URL-Format haben, beginnend mit „http://“',
	'sf_bad_email_error' => 'muss ein gültiges E-Mail-Adressformat haben',
	'sf_bad_number_error' => 'muss eine gültige Zahl sein',
	'sf_bad_date_error' => 'muss ein gültiges Datum sein',
	'uploadwindow' => 'Formular zum Hochladen',
	'sf_deletionlog' => 'Lösch-Logbuch',
	'sf-preview-header' => 'Formularvorschau',
	'sf-preview-note' => 'So wird das Formular aussehen, wenn es in Gebrauch ist:',
	'sf-pageschemas-pagenameformula' => 'Seitennamenformel:',
	'sf-pageschemas-createtitle' => 'Name des Formulars für neue Seiten:',
	'sf-pageschemas-edittitle' => 'Name des Formulars für vorhandene Seiten:',
	'sf-pageschemas-inputtype' => 'Eingabetyp (leer lassen, um die Standardeinstellung zu nutzen):',
	'sf_property_isproperty' => 'Dies ist ein Attribut des Datentyps $1.',
	'sf_property_linkstoform' => 'Es verlinkt auf Seiten, die das Formular „$1“ nutzen.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Der mögliche Wert für dieses Attribut ist|Die möglichen Werte für dieses Attribut sind}}:',
	'sf_template_docu' => 'Dies ist die Vorlage „$1“.
Sie sollte im folgenden Format genutzt werden:',
	'sf_template_docufooter' => 'Klicke auf „Bearbeiten“, um den Vorlagentext anzusehen.',
	'sf_form_docu' => 'Dies ist das Formular „$1“.
Um eine Seite mit diesem Formular zu erstellen, gib den Seitennamen unten in das Eingabefeld ein.
Sofern bereits eine Seite mit diesem Namen vorhanden ist, wirst du automatisch zum Formular für das Bearbeiten der Seite weitergeleitet.',
	'sf_form_freetextlabel' => 'Freitext',
	'sf_category_hasdefaultform' => 'Diese Kategorie nutzt das Formular $1.',
	'sf_category_desc' => 'Dies ist die Kategorie $1.',
	'sf_blank_namespace' => 'Startseite',
	'right-viewedittab' => 'Den Reiter „{{int:edit}}“ auf Seiten sehen, die bearbeitet werden können',
	'right-editrestrictedfields' => 'Für die Bearbeitung beschränkte Formularfelder bearbeiten',
	'right-createclass' => 'Erstellen neuer semantischer Klassen',
	'action-createclass' => 'neue semantische Klassen zu erstellen',
	'action-editrestrictedfields' => 'für die Bearbeitung beschränkte Formularfelder zu bearbeiten',
	'action-viewedittab' => 'den Reiter „{{int:edit}}“ auf Seiten zu sehen, die bearbeitet werden können',
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author Dst
 * @author Imre
 * @author Kghbln
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de-formal'] = array(
	'sf_createproperty_allowedvalsinput' => 'Sofern Sie für dieses Attribut nur bestimmte Werte zulassen möchten, geben Sie diese bitte in Form einer kommagetrennten Liste an (falls ein Wert ein Komma enthält, müssen Sie es durch „\\,“ ersetzen):',
	'sf_createtemplate_addtemplatebeforesave' => 'Hinweis: Sie müssen mindestens eine Vorlage zu diesem Formular hinzufügen, bevor Sie es speichern können.',
	'sf_createform_allowmultiple' => 'Erlauben Sie mehrere (oder keine) Instanzen dieser Vorlage auf der erstellten Seite',
	'sf_createclass_docu' => 'Geben Sie hier alle Daten ein, um die Attribute, die Vorlage, das Formular und die Kategorie für eine einzelne Klasse zu erstellen.
Bitte nutzen Sie eine der folgenden Seiten für weitere Optionen: $1.',
	'sf_formstart_docu' => 'Geben Sie in dieses Textfeld den Namen der Seite ein, die mit dem Formular „$1“ bearbeitet werden soll.
Sofern bereits eine Seite dieses Namens vorhanden ist, wird das Formular aufgerufen, mit dem Sie sie bearbeiten können.
Andernfalls wird das Formular zum Erstellen der Seite aufgerufen.',
	'sf_formstart_noform_docu' => 'Geben Sie in dieses Textfeld den Namen der Seite ein und wählen Sie das Formular aus, mit dem sie bearbeitet werden soll.
Sofern bereits eine Seite dieses Namens vorhanden ist, wird das Formular aufgerufen, mit dem Sie sie bearbeiten können.
Andernfalls wird das Formular zum Erstellen der Seite aufgerufen.',
	'sf_formedit_createtitlenotarget' => 'Erstellen Sie $1',
	'sf_formedit_badurl' => 'Dies ist die Spezialseite zum Bearbeiten einer Seite mit einem Formular. Sie müssen den Namen eines Formulars und den Namen der zu bearbeitenden Seite in der URL angeben.
Die URL sollte wie folgt aussehen: „Spezial:Mit_Formular_bearbeiten?form=<Formularname>&target=<Seitenname>“ oder „Spezial:Mit_Formular_bearbeiten/<Formularname>/<Seitenname>“.',
	'sf_formerrors_header' => 'Ihre Eingabe ist fehlerhaft oder unvollständig. Siehe hierzu die Hinweise unten, neben dem jeweiligen Formularfeld.',
	'sf_template_docufooter' => 'Klicken Sie auf „Bearbeiten“, um den Vorlagentext anzusehen.',
	'sf_form_docu' => 'Dies ist das Formular „$1“.
Um eine Seite mit diesem Formular zu erstellen, geben Sie den Seitennamen unten in das Eingabefeld ein.
Sofern bereits eine Seite mit diesem Namen vorhanden ist, werden Sie automatisch zum Formular für das Bearbeiten der Seite weitergeleitet.',
);

/** Zazaki (Zazaki)
 * @author Belekvor
 * @author Erdemaslancan
 * @author Mirzali
 */
$messages['diq'] = array(
	'templates' => 'Şabloni',
	'sf_createtemplate_deletefield' => 'Bestere',
	'sf_createclass_create' => 'Vıraze',
	'formedit' => 'Na former bıvurne',
	'sf_formedit_remove' => 'Hewad',
	'sf_formedit_none' => 'Çıno',
	'sf_template_docu' => 'No şablonê "$1"yo.
Beno ke zey formatê cêrêni name bo:',
	'sf_template_docufooter' => 'Qandê Nusne na sabloner vinayışi na peler bıvurnê',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'semanticforms-desc' => 'Formulary za pśidawanje a wobźěłowanje semantiskich datow',
	'specialpages-group-sf_group' => 'Semantiske formulary',
	'createproperty' => 'Kakosć napóraś',
	'sf_createproperty_linktoform' => 'Toś ta kakosć buźo k bokam wótkazowaś, kótarež wužywaju formular:',
	'sf_createproperty_allowedvalsinput' => 'Jolic coš za toś ta kakosć jano wěste gódnoty dowóliś, zapódaj lisćinu dowólonych gódnotow, wótźělonych pśez komy (jolic gódnota wopśimujo komu, wuměń ju pśez "\\,"):',
	'sf_createproperty_propname' => 'Mě kakosći:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Pśedłogi',
	'sf_templates_docu' => 'Slědujuce pśedłogi eksistěruju we wikiju.',
	'sf_templates_definescat' => 'definěrujo kategoriju: $1',
	'createtemplate' => 'Pśedłogu napóraś',
	'sf_createtemplate_namelabel' => 'Mě pśedłogi:',
	'sf_createtemplate_categorylabel' => 'Pśez kategoriju definěrowana pśedłoga (opcionalny):',
	'sf_createtemplate_templatefields' => 'Póla pśedłogi',
	'sf_createtemplate_fieldsdesc' => 'Jolic póla w toś tej pśedłoze wěcej njamaju pólowe mjenja měś, zapódaj jadnorje indeks kuždego póla (na pś. 1, 2, 3 atd.) ako mě město aktualnego mjenja.',
	'sf_createtemplate_fieldname' => 'Mě póla:',
	'sf_createtemplate_displaylabel' => 'Etiket za zwobraznjenje:',
	'sf_createtemplate_semanticproperty' => 'Semantiska kakosć:',
	'sf_createtemplate_fieldislist' => 'Toś to pólo móžo lisćinu gódnotow wopśimjeś, wótźělonych pśez komy',
	'sf_createtemplate_aggregation' => 'Zrědowanje',
	'sf_createtemplate_aggregationdesc' => 'Aby nalicył na boku, kótaryž wužywa toś tu pśedłogu, wšykne boki, kótarež maju wěstu kakosć a kótaraž pokazujo na toś ten bok, pódaj dołojce góžecu se kakosć:',
	'sf_createtemplate_aggregationlabel' => 'Titel za lisćinu:',
	'sf_createtemplate_outputformat' => 'Wudawański format:',
	'sf_createtemplate_standardformat' => 'Tabela',
	'sf_createtemplate_infoboxformat' => 'Bocny infokašćik',
	'sf_createtemplate_addfield' => 'Pólo pśidaś',
	'sf_createtemplate_deletefield' => 'Wulašowaś',
	'sf_createtemplate_addtemplatebeforesave' => 'Musyš nanejmjenjej jadnu pśedłogu toś tomu formularoju pśidaś, nježli až móžoš jen składowaś.',
	'forms' => 'Formulary',
	'sf_forms_docu' => 'Slědujuce formulary eksistěeruju we wikiju.',
	'sf_forminputs_mandatory' => 'Obligatoriske pólo',
	'sf_forminputs_restricted' => 'Jano administratory mógu toś to zapódawańske pólo wobźěłaś',
	'createform' => 'Formular napóraś',
	'sf_createform_nameinput' => 'Mě formulara',
	'sf_createform_nameinputdesc' => '(formular dostanjo zwětšego samske mě ako jogo głowna pśedłoga):',
	'sf_createform_template' => 'Pśedłoga:',
	'sf_createform_templatelabelinput' => 'Pomjenjenje pśedłogi (opcionalny):',
	'sf_createform_allowmultiple' => 'Někotare (abo žedne) instance toś teje pśedłogi w napóranem boku dowóliś',
	'sf_createform_field' => 'Pólo:',
	'sf_createform_fieldprop' => 'Toś to pólo definěrujo kakosć $1 typa $2.',
	'sf_createform_fieldproplist' => 'Toś to pólo definěrujo lisćinu elementow, kótarež maju kakosć $1 typa $2.',
	'sf_createform_fieldpropunknowntype' => 'Toś to póla definěrujo kakosć $1 njepódanego typa.',
	'sf_createform_inputtype' => 'Typ zapódaś:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createform_formlabel' => 'Pomjenjenje formulara:',
	'sf_createform_hidden' => 'Schowany',
	'sf_createform_removetemplate' => 'Pśedłogu wótpóraś',
	'sf_createform_addtemplate' => 'Pśedłogu pśidaś:',
	'sf_createform_beforetemplate' => 'Pśed pśedłogu:',
	'sf_createform_atend' => 'Na kóńcu',
	'sf_createform_add' => 'Pśidaś',
	'sf_createform_choosefield' => 'Wubjeŕ pólo, kótarež coš pśidaś',
	'createcategory' => 'Kategoriju napóraś',
	'sf_createcategory_name' => 'Mě kategorije:',
	'sf_createcategory_defaultform' => 'Standardny formular:',
	'sf_createcategory_makesubcategory' => 'To k pódkategoriji drugeje kategorije cyniś (opcionalny):',
	'createclass' => 'Klasu napóraś',
	'sf_createclass_docu' => 'Zapódaj how wše daty, aby napórał kakosći, pśedłogu, formular a kategoriju za jadnotliwu klasu.
Za dalšne opcije wužyj boki $1 město togo.',
	'sf_createclass_allowedvalues' => 'Dowólone gódnoty:',
	'sf_createclass_listofvalues' => 'Lisćina gódnotow?',
	'sf_createclass_missingvalues' => 'Nic wše póla su se wupołnili.',
	'sf_createclass_success' => 'Kakosći, pśedłoga, formular a kategorija se napóraju',
	'formstart' => 'Bok z formularom pśidaś',
	'sf_formstart_badform' => 'Zmólka: žeden formular njejo se namakał pla $1',
	'sf_formstart_badtitle' => 'Zmólka: "$1" jo njepłaśiwy titel za bok.',
	'sf_formstart_docu' => "Zapódaj how mě boka, kótaryž ma se z formularom '$1' wobźěłaś.
Jolic toś ten bok južo eksistěrujo, buźoš se k formularoju za wobźěłowanje togo boka dalej pósrědnjaś.
Howac buźoš se k formularoju za pśidawanje boka dalej pósrědnjaś.",
	'sf_formstart_noform_docu' => 'Zapódaj how mě boka a wubjeŕ formular, z kótarymž coš jen wobźěłaś.
Jolic toś ten bok južo eksistěrujo, buźoš se k formularoju za wobźěłowanje togo boka dalej pósrědnjaś.
Howac buźoš se k formularoju za pśidawanje boka dalej pósrědnjaś.',
	'sf_formstart_createoredit' => 'Napóraś abo wobźěłaś',
	'formedit' => 'Z formularom wobźěłaś',
	'sf_formedit_createtitle' => '$1 napóraś: $2',
	'sf_formedit_badurl' => "To jo bok za wobźěłowanje z formularom. Musyš ako mě formulara tak teke celowy bok w URL pódaś; URL by měł kaž 'Special:FormEdit?form=<mě formulara>&target=<celowy bok>' abo  'Special:FormEdit/<mě formulara>/<celowy bok>' wuglědaś.",
	'sf_formedit_altforms' => 'Móžoš město togo toś ten bok z jadnym ze slědujucych formularow pśidaś:',
	'sf_formedit_altformsonly' => 'Pšosym wubjeŕ jaden ze slědujucych formularow, aby pśidał toś ten bok:',
	'sf_formcreate' => 'Z formularom napóraś',
	'sf_viewform' => 'Formular se woglědaś',
	'sf_editsource' => 'Žrědło wobźěłaś',
	'sf_formedit_edittitle' => '$1 wobźěłaś: $2',
	'sf_formedit_morethanoneform' => 'Warnowanje: Za toś ten bok jo se definěrował wěcej ako jaden standardny formular.',
	'sf_formedit_formwarning' => 'Warnowanje: Toś ten bok <a href="$1">južo eksistěrujo</a>, ale njewužywa toś ten formular.',
	'sf_formedit_remove' => 'Wótpóraś',
	'sf_formedit_addanother' => 'Drugi pśidaś',
	'sf_formedit_none' => 'Žeden',
	'runquery' => 'Wótpšašanje startowaś',
	'sf_runquery_badurl' => "Musyš formularne mě w URL pódaś;
URL měł wuglědaś ako 'Special:RunQuery/<formularne mě>'.",
	'sf_runquery_title' => 'Start wótpšašanja: $1',
	'sf_runquery_additionalquery' => 'Pśidatne wótpšašanje',
	'sf_formerrors_header' => 'Su zmólki w zapódaśu twójogo formulara; glědaj dołojce',
	'sf_blank_error' => 'njesmějo prozny byś',
	'sf_bad_url_error' => 'musy korektny format URL měś a se z "http://" zachopiś',
	'sf_bad_email_error' => 'musy płaśiwy format e-mailoweje adresy měś',
	'sf_bad_number_error' => 'musy płaśiwa licba byś',
	'sf_bad_date_error' => 'musy płaśiwy datum byś',
	'uploadwindow' => 'Wokno nagraśow',
	'sf_deletionlog' => 'protokol wulašowanjow',
	'sf_property_isproperty' => 'To jo kakosć typa $1.',
	'sf_property_linkstoform' => 'Wótkazujo k bokam, kótarež wužywaju formular $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dowólona gódnota za toś tu kakosć jo|Dowólonej gódnośe za toś tu kakosć stej|Dowólone gódnoty za toś tu kakosć su|Dowólone gódnoty za toś tu kakosć su}}:',
	'sf_template_docu' => "To jo pśedłof '$1'.
By se měł w slědujucem formaśe wuwołaś:",
	'sf_template_docufooter' => 'Wobźěłaj bok, aby wiźeł tekst pśedłogi.',
	'sf_form_docu' => 'To jo formular "$1".
Aby napórał bok z toś tym formularom, zapódaj dołojce mě boka;
jolic bok z tym mjenim južo eksistěrujo, buźoš se k formularoju dalej pósrědnjaś, aby ten bok wobźěłał.',
	'sf_form_freetextlabel' => 'Lichy tekst',
	'sf_category_hasdefaultform' => 'Toś ta kategorija wužywa formular $1.',
	'sf_category_desc' => 'To jo kategorija $1.',
	'sf_blank_namespace' => 'Głowny',
	'right-viewedittab' => 'Rejtark "Wobźěłaś" za boki, kótarež su wobźěłujobne pśez formular, se woglědaś', # Fuzzy
	'right-editrestrictedfields' => 'Wobgranicowane formularne póla wobźěłaś',
);

/** Ewe (eʋegbe)
 */
$messages['ee'] = array(
	'sf_createtemplate_deletefield' => 'Tutui',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Crazymadlover
 * @author Omnipaedista
 * @author Protnet
 * @author ZaDiak
 * @author Απεργός
 */
$messages['el'] = array(
	'semanticforms-desc' => 'Φόρμες για την προσθήκη και επεξεργασία σημασιολογικών δεδομένων',
	'specialpages-group-sf_group' => 'Σημασιολογικές Φόρμες',
	'createproperty' => 'Δημιουργία ιδιότητας',
	'sf-createproperty-with-name' => 'Δημιουργία ιδιότητας: $1',
	'sf_createproperty_linktoform' => 'Αυτή η ιδιότητα θα δημιουργήσει συνδέσμους προς σελίδες που χρησιμοποιούν τη φόρμα:',
	'sf_createproperty_allowedvalsinput' => 'Εάν θέλετε αυτή η ιδιότητα να μπορεί να πάρει μόνο συγκεκριμένες τιμές, εισαγάγετε μια λίστα με τις επιτρεπτές τιμές, διαχωρισμένες με κόμμα (αν μια τιμή περιέχει κόμμα, αντικαταστήστε το με "\\,"):',
	'sf_createproperty_propname' => 'Όνομα ιδιότητας:',
	'sf_createproperty_proptype' => 'Τύπος:',
	'templates' => 'Πρότυπα',
	'sf_templates_docu' => 'Τα παρακάτω πρότυπα υπάρχουν σε αυτό το wiki.',
	'sf_templates_definescat' => 'προσδιορίζει την κατηγορία: $1',
	'createtemplate' => 'Δημιουργία προτύπου',
	'sf-createtemplate-with-name' => 'Δημιουργία προτύπου: $1',
	'sf_createtemplate_namelabel' => 'Όνομα προτύπου:',
	'sf_createtemplate_multipleinstance' => 'Αυτό το πρότυπο μπορεί να συμπεριληφθεί πολλές φορές στη σελίδα.',
	'sf_createtemplate_categorylabel' => 'Κατηγορία οριζόμενη από πρότυπο (προαιρετικό):',
	'sf_createtemplate_templatefields' => 'Πεδία προτύπου',
	'sf_createtemplate_fieldsdesc' => 'Για να μην χρειάζονται ονόματα τα πεδία αυτού του προτύπου, απλά εισάγετε τον αύξοντα αριθμό κάθε πεδίου (π.χ. 1, 2, 3, κ.λ.π.) σαν όνομα, αντί για το κανονικό όνομα',
	'sf_createtemplate_fieldname' => 'Όνομα πεδίου:',
	'sf_createtemplate_displaylabel' => 'Εμφανιζόμενη ετικέτα:',
	'sf_createtemplate_semanticproperty' => 'Σημασιολογική ιδιότητα:',
	'sf_createtemplate_fieldislist' => 'Αυτό το πεδίο μπορεί να δεχτεί μια λίστα τιμών, διαχωρισμένων με κόμματα',
	'sf_createtemplate_aggregation' => 'Συνάθροιση',
	'sf_createtemplate_aggregationdesc' => 'Για να εμφανίσετε, σε οποιαδήποτε σελίδα χρησιμοποιεί αυτό το πρότυπο, μια λίστα όλων των σελίδων που έχουν μια ορισμένη ιδιότητα που οδηγεί σε αυτήν τη σελίδα, καθορίστε την κατάλληλη ιδιότητα παρακάτω:',
	'sf_createtemplate_aggregationlabel' => 'Τίτλος για τη λίστα:',
	'sf_createtemplate_outputformat' => 'Μορφή δεδομένων εξόδου:',
	'sf_createtemplate_standardformat' => 'Πίνακας',
	'sf_createtemplate_infoboxformat' => 'Πλευρικό κουτί πληροφοριών',
	'sf_createtemplate_plainformat' => 'Απλό κείμενο',
	'sf_createtemplate_sectionsformat' => 'Ενότητες',
	'sf_createtemplate_addfield' => 'Προσθήκη πεδίου',
	'sf_createtemplate_deletefield' => 'Διαγραφή',
	'sf_createtemplate_addtemplatebeforesave' => 'Πρέπει να προσθέσετε τουλάχιστον ένα πρότυπο σε αυτήν τη φόρμα για να μπορείτε να την αποθηκεύσετε.',
	'forms' => 'Φόρμες',
	'sf_forms_docu' => 'Στο wiki υπάρχουν οι παρακάτω φόρμες.',
	'sf_forminputs_mandatory' => 'Υποχρεωτικό',
	'sf_forminputs_restricted' => 'Μόνο οι διαχειριστές μπορούν να επεξεργαστούν αυτό το πλαίσιο εισόδου δεδομένων',
	'sf_forminputs_class' => 'Το χαρακτηριστικό «class» της HTML για αυτό το πλαίσιο εισόδου δεδομένων',
	'sf_forminputs_default' => 'Η προεπιλεγμένη τιμή για αυτό το πλαίσιο εισόδου δεδομένων',
	'sf_forminputs_preload' => 'Μια σελίδα wiki το περιεχόμενο της οποίας θα γίνει η προεπιλεγμένη τιμή αυτής της εισόδου δεδομένων',
	'sf_forminputs_property' => 'Σημασιολογική ιδιότητα στην οποία αντιστοιχεί αυτό το πεδίο',
	'sf_forminputs_size' => 'Το μέγεθος αυτού του πεδίο κειμένου, σε χαρακτήρες',
	'sf_forminputs_maxlength' => 'Το μέγιστο επιτρεπόμενο μήκος του κειμένου σε αυτό το πεδίο',
	'sf_forminputs_placeholder' => 'Κείμενο βοήθειας που εμφανίζεται εντός του πλαισίου εισόδου δεδομένων έως ότου ο χρήστης να κάνει κλικ πάνω σε αυτό',
	'sf_forminputs_uploadable' => 'Τοποθέτηση συνδέσμου «Ανέβασμα αρχείου» δίπλα σε αυτό το πλαίσιο εισόδου δεδομένων', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Το προεπιλεγμένο όνομα αρχείου για τα αρχεία που ανεβάζονται',
	'sf_forminputs_rows' => 'Ο αριθμός των γραμμών κειμένου για αυτό το πλαίσιο εισόδου δεδομένων',
	'sf_forminputs_cols' => 'Ο αριθμός των στηλών κειμένου για αυτό το πλαίσιο εισόδου δεδομένων',
	'sf_forminputs_autogrow' => 'Αυτό το πλαίσιο εισόδου δεδομένων να αυξάνει σε μέγεθος, εάν το κείμενο υπερβαίνει τα όριά του',
	'sf_forminputs_valuesfromproperty' => 'Μια ιδιότητα της οποίας οι τιμές σε αυτό το wiki να είναι το σύνολο τιμών αυτής της εισόδου δεδομένων',
	'sf_forminputs_valuesfromcategory' => 'Μια κατηγορία της οποίας οι σελίδες να είναι το σύνολο τιμών αυτής της εισόδου δεδομένων',
	'sf_forminputs_valuesfromnamespace' => 'Ένας χώρος ονομάτων του οποίου οι σελίδες να είναι το σύνολο τιμών αυτής της εισόδου δεδομένων',
	'sf_forminputs_valuesfromconcept' => 'Μια σελίδα «έννοιας» του Σημασιολογικού MediaWiki της οποίας οι σελίδες να είναι το σύνολο τιμών αυτής της εισόδου δεδομένων',
	'sf_forminputs_valuesfromurl' => 'Μια διεύθυνση URL που περιέχει δομημένα δεδομένα τα οποία να είναι το σύνολο τιμών αυτής της εισόδου δεδομένων',
	'sf_forminputs_values' => 'Το σύνολο τιμών αυτής της εισόδου δεδομένων, διαχωρισμένων με κόμματα',
	'sf_forminputs_list' => 'Αυτό το πλαίσιο εισόδου δεδομένων να δέχεται λίστα τιμών',
	'sf_forminputs_delimiter' => 'Το διαχωριστικό σύμβολο μεταξύ τιμών πεδίου, αν αυτό το πλαίσιο εισόδου δεδομένων δέχεται λίστα τιμών.',
	'sf_forminputs_remoteautocompletion' => 'Χρήση απομακρυσμένης αυτόματης συμπλήρωσης',
	'sf_forminputs_existingvaluesonly' => 'Να επιτρέπονται μόνο τιμές που υπάρχουν στη λίστα',
	'sf_forminputs_showonselect' => 'Στοιχεία σελίδας που να εμφανίζονται μόνο αν επιλέγονται συγκεκριμένες τιμές (παράδειγμα: «τιμή1=>div1,τιμή2=>div2»)',
	'sf_forminputs_listboxsize' => 'Το ύψος αυτού του πλαισίου λίστας, σε γραμμές κειμένου',
	'sf_forminputs_includetimezone' => 'Συμπερίληψη ενός πλαισίου εισόδου δεδομένων για τη ζώνη ώρας',
	'sf_forminputs_topcategory' => 'Η μητρική κατηγορία αυτού του συνόλου κατηγοριών (απαιτείται)',
	'sf_forminputs_hideroot' => 'Απόκρυψη της μητρικής κατηγορίας',
	'sf_forminputs_depth' => 'Ο αριθμός επιπέδων των κατηγοριών που να εμφανίζονται αρχικά',
	'sf_forminputs_height' => 'Το ύψος αυτού του πλαισίου εισόδου δεδομένων, σε εικονοστοιχεία',
	'sf_forminputs_width' => 'Το πλάτος αυτού του πλαισίου εισόδου δεδομένων, σε εικονοστοιχεία',
	'createform' => 'Δημιουργία φόρμας',
	'sf-createform-with-name' => 'Δημιουργία φόρμας: $1',
	'sf_createform_nameinput' => 'Όνομα φόρμας',
	'sf_createform_nameinputdesc' => '(στη φόρμα δίνεται συνήθως το ίδιο όνομα με το κύριό της πρότυπο):',
	'sf_createform_template' => 'Πρότυπο:',
	'sf_createform_templatelabelinput' => 'Ετικέτα προτύπου (προαιρετικό):',
	'sf_createform_allowmultiple' => 'Να επιτρέπονται πολλαπλές (ή μηδέν) παρουσίες αυτού του προτύπου στη δημιουργηθείσα σελίδα',
	'sf_createform_field' => 'Πεδίο:',
	'sf_createform_fieldprop' => 'Αυτό το πεδίο ορίζει την ιδιότητα $1, τύπου $2.',
	'sf_createform_fieldproplist' => 'Αυτό το πεδίο ορίζει μια λίστα στοιχείων που έχουν την ιδιότητα $1, τύπου $2.',
	'sf_createform_fieldpropunknowntype' => 'Αυτό το πεδίο ορίζει την ιδιότητα $1, απροσδιορίστου τύπου.',
	'sf_createform_inputtype' => 'Τύπος εισόδου:',
	'sf_createform_inputtypedefault' => '(προεπιλογή)',
	'sf_createform_formlabel' => 'Ετικέτα φόρμας:',
	'sf_createform_hidden' => 'Κρυμμένος',
	'sf_createform_removetemplate' => 'Αφαίρεση προτύπου',
	'sf_createform_addtemplate' => 'Προσθήκη προτύπου:',
	'sf_createform_beforetemplate' => 'Πριν το πρότυπο:',
	'sf_createform_atend' => 'Στο τέλος',
	'sf_createform_add' => 'Προσθήκη',
	'sf_createform_choosefield' => 'Επιλογή πεδίου για να προστεθεί',
	'createcategory' => 'Δημιουργία κατηγορίας',
	'sf-createcategory-with-name' => 'Δημιουργία κατηγορίας: $1',
	'sf_createcategory_name' => 'Όνομα κατηγορίας:',
	'sf_createcategory_defaultform' => 'Προεπιλεγμένη φόρμα:',
	'sf_createcategory_makesubcategory' => 'Να γίνει υποκατηγορία μιας άλλης κατηγορίας (προαιρετικό):',
	'createclass' => 'Δημιουργία κλάσης',
	'sf_createclass_docu' => "Εισαγάγετε όλα τα δεδομένα εδώ για να δημιουργήσετε ιδιότητες, πρότυπο, φόρμα και κατηγορία που ορίζουν μία κλάση. Για περισσότερες επιλογές, χρησιμοποιήστε αντ' αυτού τις σελίδες $1.",
	'sf_createclass_allowedvalues' => 'Επιτρεπτές τιμές:',
	'sf_createclass_listofvalues' => 'Κατάλογος τιμών;',
	'sf_createclass_nameinput' => 'Όνομα φόρμας:',
	'sf_createclass_missingvalues' => 'Δεν συμπληρώθηκαν όλα τα απαραίτητα πεδία.',
	'sf_createclass_success' => 'Οι ιδιότητες, το πρότυπο, η φόρμα και η κατηγορία θα δημιουργηθούν.',
	'sf_createclass_create' => 'Δημιουργία',
	'formstart' => 'Προσθέστε σελίδα με μορφή',
	'sf_formstart_badform' => 'Σφάλμα: Δεν βρέθηκε φόρμα στη σελίδα "$1".',
	'sf_formstart_badtitle' => 'Σφάλμα: Το "$1" είναι μη έγκυρος τίτλος σελίδας.',
	'sf_formstart_docu' => 'Εισαγάγετε το όνομα μιας σελίδας εδώ, για να την επεξεργαστείτε με τη φόρμα "$1".
Εάν υπάρχει ήδη αυτή η σελίδα, θα μεταφερθείτε στη φόρμα για την επεξεργασία της.
Σε αντίθετη περίπτωση, θα μεταφερθείτε στη φόρμα για την προσθήκη της σελίδας.',
	'sf_formstart_noform_docu' => 'Εισαγάγετε εδώ το όνομα μιας σελίδας και επιλέξτε τη φόρμα με την οποία θα την επεξεργαστείτε.
Εάν υπάρχει ήδη αυτή η σελίδα, θα μεταφερθείτε στη φόρμα για την επεξεργασία της.
Σε αντίθετη περίπτωση, θα μεταφερθείτε στη φόρμα για την προσθήκη της σελίδας.',
	'sf_formstart_createoredit' => 'Δημιουργία ή επεξεργασία',
	'formedit' => 'Επεξεργασία με φόρμα',
	'sf_formedit_createtitle' => 'Δημιουργία $1: $2',
	'sf_formedit_createtitlenotarget' => 'Δημιουργία $1',
	'sf_formedit_badurl' => "Αυτή είναι η σελίδα για επεξεργασία με φόρμα. Θα πρέπει να καθορίσετε ένα όνομα φόρμας καθώς και μια σελίδα προορισμού μέσα στη διεύθυνση URL.
Θα πρέπει να μοιάζει με 'Ειδικό:FormEdit?form=<όνομα φόρμας>&target=<σελίδα προορισμού>', ή  'Ειδικό:FormEdit/<όνομα φόρμας>/<σελίδα προορισμού>'.",
	'sf_formedit_altforms' => "Αντ' αυτού, μπορείτε να προσθέσετε αυτήν τη σελίδα με μία από τις ακόλουθες φόρμες:",
	'sf_formedit_altformsonly' => 'Παρακαλούμε επιλέξτε μία από τις ακόλουθες φόρμες για να την προσθέσετε σε αυτήν τη σελίδα:',
	'sf_formcreate' => 'Δημιουργία με φόρμα',
	'sf_viewform' => 'Εμφάνιση φόρμας',
	'sf_editsource' => 'Επεξεργασία κώδικα',
	'sf_formedit_edittitle' => 'Επεξεργασία $1: $2',
	'sf_formedit_morethanoneform' => "'''Προειδοποίηση:''' Έχουν οριστεί περισσότερες από μία προεπιλεγμένες φόρμες για αυτήν τη σελίδα.",
	'sf_formedit_formwarning' => 'Προειδοποίηση: Αυτή η σελίδα <a href="$1">υπάρχει ήδη</a>, αλλά δεν χρησιμοποιεί αυτή τη φόρμα.',
	'sf_formedit_mismatchedbrackets' => 'Προειδοποίηση: Αυτή η σελίδα περιέχει σγουρές ή τετράγωνες αγκύλες που δεν έχουν κλείσει, οπότε η φόρμα δεν θα τη χειριστεί σωστά. Παρακαλώ <a href="$1">διορθώστε το σφάλμα στον πηγαίο κώδικα</a> πριν συνεχίσετε.',
	'sf_formedit_remove' => 'Αφαίρεση',
	'sf_formedit_addanother' => 'Προσθήκη κι άλλου',
	'sf_formedit_none' => 'Κανένα',
	'sf_formedit_emptytitle' => 'Σφάλμα: Τα δεδομένα που εισαγάγατε έχουν ως αποτέλεσμα έναν κενό τίτλο σελίδας.',
	'sf_formedit_hookerror' => 'Σφάλμα: Μια επέκταση MediaWiki εμπόδισε την τροποποίηση της σελίδας προορισμού.',
	'sf_formedit_saveandcontinueediting' => 'Αποθήκευση και συνέχεια',
	'sf_formedit_saveandcontinue_summary' => 'Αποθήκευση με χρήση του κουμπιού "$1" στη φόρμα',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Αποθήκευση δεδομένων και συνέχεια επεξεργασίας',
	'sf_autoedit_anoneditwarning' => 'Προειδοποίηση: Δεν έχετε συνδεθεί. Η διεύθυνση IP σας θα καταγραφεί στο ιστορικό επεξεργασίας αυτής της σελίδας.',
	'sf_autoedit_success' => 'Το [[$1]] τροποποιήθηκε επιτυχώς μέσω της φόρμας $2.',
	'sf_autoedit_fail' => 'Η τροποποίηση του [[$1]] απέτυχε.',
	'sf_autoedit_notargetspecified' => 'Δεν έχει οριστεί σελίδα προορισμού.',
	'sf_autoedit_invalidtargetspecified' => 'Η σελίδα προορισμού $1 που καθορίζεται δεν είναι έγκυρη.',
	'sf_autoedit_invalidform' => 'Η $1 δεν είναι έγκυρη φόρμα.',
	'sf_autoedit_redirectlimitexeeded' => 'Έχετε υπερβεί το μέγιστο όριο ανακατευθύνσεων για τη φόρμα $1.',
	'sf_autoedit_invalidredirecttarget' => 'Η σελίδα $1 δεν αποτελεί έγκυρο προορισμό ανακατεύθυνσης για τη φόρμα $2.',
	'sf_autoedit_invalidpreloadspecified' => 'Η σελίδα προφόρτωσης $1 που καθορίζεται δεν είναι έγκυρη.',
	'sf_autoedit_redlinkexists' => 'Η σελίδα $1 υπάρχει ήδη.',
	'sf_autoedit_noformfound' => 'Δεν έχει οριστεί φόρμα.',
	'sf_autoedit_toomanyformsfound' => 'Περισσότερες από μία φόρμες διαθέσιμες για τη σελίδα.',
	'sf_autoedit_readonly' => 'Η βάση δεδομένων είναι κλειδωμένη απέναντι σε τροποποιήσεις αυτή τη στιγμή. Αιτία: $1',
	'sf_autoedit_nosemanticform' => 'Δεν ήταν δυνατή η χρήση της φόρμας $2 για τη σελίδα $1. Δείτε [[{{#special:FormEdit}}/$2/$1]] για λεπτομέρειες.',
	'sf_autoedit_summary' => 'Έγινε αυτόματη επεξεργασία από τη σελίδα $1.',
	'sf-autoedit-wait' => 'Περιμένετε...',
	'runquery' => 'Εκτέλεση αιτήματος',
	'sf_runquery_badurl' => "Πρέπει να καθορίσετε ένα όνομα φόρμας μέσα στη διεύθυνση URL.
Η διεύθυνση URL θα πρέπει να είναι της μορφής 'Special:RunQuery/<όνομα φόρμας>'.",
	'sf_runquery_title' => 'Εκτέλεση αιτήματος: $1',
	'sf_runquery_additionalquery' => 'Επιπρόσθετο αίτημα',
	'sf_formerrors_header' => 'Παρουσιάστηκαν σφάλματα με τα δεδομένα που εισαγάγατε στη φόρμα. Δείτε παρακάτω.',
	'sf_blank_error' => 'δεν μπορεί να είναι κενό',
	'sf_bad_url_error' => 'απαιτείται η σωστή μορφή διεύθυνσης URL, που ξεκινάει με "http"',
	'sf_bad_email_error' => 'απαιτείται μια έγκυρη μορφή διεύθυνσης email',
	'sf_bad_number_error' => 'πρέπει να είναι ένας έγκυρος αριθμός',
	'sf_bad_date_error' => 'πρέπει να είναι μια έγκυρη ημερομηνία',
	'uploadwindow' => 'Φόρτωση παραθύρου',
	'sf_deletionlog' => 'Αρχείο διαγραφών',
	'sf-preview-header' => 'Προεπισκόπηση φόρμας',
	'sf-preview-note' => 'Έτσι θα φαίνεται η φόρμα όταν θα είναι σε χρήση:',
	'sf-pageschemas-pagenameformula' => 'Μαθηματικός τύπος ονόματος σελίδας:',
	'sf-pageschemas-createtitle' => 'Τίτλος φόρμας για νέες σελίδες:',
	'sf-pageschemas-edittitle' => 'Τίτλος φόρμας για υπάρχουσες σελίδες:',
	'sf-pageschemas-inputtype' => 'Τύπος πλαισίου εισόδου δεδομένων (αφήστε το κενό για προεπιλογή)',
	'sf_property_isproperty' => 'Αυτή είναι μια ιδιότητα του τύπου $1.',
	'sf_property_linkstoform' => 'Συνδέει σε σελίδες για χρήση μιας φόρμας $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Η επιτρεπτή τιμή|Οι επιτρεπτές τιμές}} για αυτήν την ιδιότητα είναι:',
	'sf_template_docu' => 'Αυτό είναι το πρότυπο «$1».
Θα πρέπει να καλείται με την ακόλουθη μορφή:',
	'sf_template_docufooter' => 'Επεξεργαστείτε τη σελίδα για να δείτε τον κώδικα του προτύπου',
	'sf_form_docu' => 'Αυτή είναι η φόρμα «$1».
Για να δημιουργήσετε σελίδα με αυτήν τη φόρμα, εισαγάγετε το όνομα της σελίδας παρακάτω.
Αν υπάρχει ήδη σελίδα με αυτό το όνομα, θα μεταβείτε σε φόρμα για να επεξεργαστείτε αυτήν τη σελίδα.',
	'sf_form_freetextlabel' => 'Ελεύθερο κείμενο',
	'sf_category_hasdefaultform' => 'Αυτή η κατηγορία χρησιμοποιεί την φόρμα $1.',
	'sf_category_desc' => 'Αυτή είναι η κατηγορία $1.',
	'sf_blank_namespace' => 'Κύριος',
	'right-viewedittab' => 'Προβολή καρτέλας «Επεξεργασία» για σελίδες επεξεργάσιμες με φόρμα', # Fuzzy
	'right-editrestrictedfields' => 'Επεξεργασία περιορισμένων πεδίων φορμών',
	'right-createclass' => 'Δημιουργία νέων σημασιολογικών κλάσεων',
	'action-createclass' => 'δημιουργία νέων σημασιολογικών κλάσεων',
	'action-editrestrictedfields' => 'επεξεργασία μη επιτρεπτών πεδίων φόρμας',
	'action-viewedittab' => 'προβολή καρτέλας "Επεξεργασία" για σελίδες επεξεργάσιμες με φόρμα', # Fuzzy
);

/** Esperanto (Esperanto)
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'semanticforms-desc' => 'Formularoj por aldonado kaj redaktado de semantikaj datumoj',
	'specialpages-group-sf_group' => 'Semantikaj Kamparoj',
	'createproperty' => 'Kreu atributon',
	'sf_createproperty_propname' => 'Nomo de la atributo:',
	'sf_createproperty_proptype' => 'Speco:',
	'templates' => 'Ŝablonoj',
	'sf_templates_docu' => 'La jenaj ŝablonoj ekzistas en la vikio.',
	'sf_templates_definescat' => 'priskribas kategorion: $1',
	'createtemplate' => 'Kreu ŝablono',
	'sf_createtemplate_namelabel' => 'Nomo de ŝablono:',
	'sf_createtemplate_categorylabel' => 'Kategorio difinita de ŝablono (nedevige):',
	'sf_createtemplate_templatefields' => 'Kampoj de ŝablono',
	'sf_createtemplate_fieldname' => 'Nomo de kampo:',
	'sf_createtemplate_displaylabel' => 'Montri etikedon:',
	'sf_createtemplate_semanticproperty' => 'Semantika atributo:',
	'sf_createtemplate_fieldislist' => 'Ĉi kampo povas enhavi liston da valoroj, apartigitaj de komoj',
	'sf_createtemplate_aggregation' => 'Agregaĵo',
	'sf_createtemplate_aggregationlabel' => 'Titolo por listo:',
	'sf_createtemplate_outputformat' => 'Eliga formato:',
	'sf_createtemplate_standardformat' => 'Norma', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Dekstra informokesto', # Fuzzy
	'sf_createtemplate_addfield' => 'Aldonu kampon',
	'sf_createtemplate_deletefield' => 'Forigi',
	'sf_createtemplate_addtemplatebeforesave' => 'Vi devas aldoni almenaŭ unu ŝablonon al ĉi kamparo antaŭ vi povas konservi ĝin.',
	'forms' => 'Kamparoj',
	'sf_forms_docu' => 'La jenaj kampoj ekzistas en la vikio.',
	'sf_forminputs_mandatory' => 'Deviga',
	'sf_forminputs_restricted' => 'Limigita (nur administrantaj uzantoj povas ŝanĝi ĝin)', # Fuzzy
	'createform' => 'Kreu kamparon',
	'sf_createform_nameinput' => 'Nomo de la formularo',
	'sf_createform_template' => 'Ŝablono:',
	'sf_createform_templatelabelinput' => 'Etikedo de ŝablono (nedevige):',
	'sf_createform_allowmultiple' => 'Akomodi multajn (aŭ nul) ekzemplerojn de ĉi ŝablono en la kreita paĝo',
	'sf_createform_field' => 'Kampo:',
	'sf_createform_fieldprop' => 'Ĉi tiu kampo difinas la atributon $1, de speco $2.',
	'sf_createform_fieldproplist' => 'Ĉi tiu kampo difinas liston de elementoj kiu havas la atributon $1, de tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Ĉi tiu kampo difinas la atributon $1, de nespecifa tipo.',
	'sf_createform_inputtype' => 'Eniga speco:',
	'sf_createform_inputtypedefault' => '(defaŭlto)',
	'sf_createform_formlabel' => 'Etikedo de kamparo:',
	'sf_createform_hidden' => 'Kaŝita',
	'sf_createform_removetemplate' => 'Forigu ŝablonon',
	'sf_createform_addtemplate' => 'Aldonu ŝablonon:',
	'sf_createform_beforetemplate' => 'Antaŭ ŝablono:',
	'sf_createform_atend' => 'Ĉe fino',
	'sf_createform_add' => 'Aldoni',
	'sf_createform_choosefield' => 'Elektu kampon por aldoni',
	'createcategory' => 'Kreu kategorion',
	'sf_createcategory_name' => 'Kategoria nomo:',
	'sf_createcategory_defaultform' => 'Defaŭlta kamparo:',
	'sf_createcategory_makesubcategory' => 'Faru ĉi tiun kiel kategorion de alia kategorio (nedevige):',
	'createclass' => 'Krei klason',
	'sf_createclass_allowedvalues' => 'Permesitaj valoroj', # Fuzzy
	'sf_createclass_listofvalues' => 'Listo de valoroj', # Fuzzy
	'formstart' => 'Aldoni paĝon kun kamparo',
	'sf_formstart_badform' => 'Eraro: neniu kampara paĝo estis trovita ĉe $1',
	'sf_formstart_createoredit' => 'Krei aŭ redakti',
	'formedit' => 'Redaktu kun kamparo',
	'sf_formedit_createtitle' => 'Krei $1: $2',
	'sf_formedit_altformsonly' => 'Bonvolu elekti unu el la jenaj kamparoj aldoni ĉi paĝon:',
	'sf_formcreate' => 'Krei per formularo',
	'sf_viewform' => 'Rigardi kamparon',
	'sf_editsource' => 'Redaktu fonton',
	'sf_formedit_edittitle' => 'Redaktu $1: $2',
	'sf_formedit_formwarning' => 'Averto: Ĉi paĝo <a href="$1">jam ekzistas</a>, sed ĝi ne uzas ĉi kamparon.',
	'sf_formedit_remove' => 'Forigi',
	'sf_formedit_addanother' => 'Aldonu plu',
	'sf_formedit_none' => 'Neniu',
	'sf_runquery_additionalquery' => 'Aldona serĉomendo',
	'sf_formerrors_header' => 'Estis eraroj kun via kampara enigo, jene:',
	'sf_blank_error' => 'ne povas esti malplena',
	'sf_bad_url_error' => "nepre havas la korektan URL-formaton, komence kun 'http'",
	'sf_bad_email_error' => 'devas havi validan formaton de retpoŝta adreso',
	'sf_bad_number_error' => 'devas esti valida nombro',
	'sf_bad_date_error' => 'devas esti valida dato',
	'uploadwindow' => 'Alŝuta fenestro',
	'sf_deletionlog' => 'Protokolo pri forigado',
	'sf_property_isproperty' => 'Ĉi tiu estas atributo de speco $1.',
	'sf_property_allowedvals' => 'La {{PLURAL:$1|permesita valoro por ĉi tiu atributo|permesitaj valoroj por ĉi tiuj atributoj}} estas:',
	'sf_template_docu' => "Ĉi tiu estas la '$1' ŝablono. Ĝi estu vokita en la jena formato:",
	'sf_template_docufooter' => 'Redaktu la paĝo por vidi la ŝablonan tekston.',
	'sf_form_freetextlabel' => 'Libera teksto',
	'sf_category_hasdefaultform' => 'Ĉi kategorio uzas la kamparon $1.',
	'sf_category_desc' => 'Ĉi tiu estas la $1 kategorio.',
	'sf_blank_namespace' => 'Ĉefa',
);

/** Spanish (español)
 * @author Armando-Martin
 * @author Cmitnick
 * @author Crazymadlover
 * @author Dvdgmz
 * @author Fitoschido
 * @author Jatrobat
 * @author Jewbask
 * @author Maor X
 * @author Pertile
 * @author Peter17
 * @author Sanbec
 * @author Vivaelcelta
 */
$messages['es'] = array(
	'semanticforms-desc' => 'Formularios para añadir y editar datos semánticos',
	'specialpages-group-sf_group' => 'Formularios semánticos',
	'createproperty' => 'Crear una propiedad',
	'sf-createproperty-with-name' => 'Crear la propiedad: $1',
	'sf_createproperty_linktoform' => 'Esta propiedad vinculará a páginas que usen el formulario:',
	'sf_createproperty_allowedvalsinput' => 'Si usted desea que esta propiedad solo permita tener ciertos valores, ingrese la lista de valores permitidos, separados por comas (si un valor contiene una coma, reemplazelo con "\\,"):',
	'sf_createproperty_propname' => 'Nombre de propiedad:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Plantillas',
	'sf_templates_docu' => 'Las siguientes plantillas existen en el wiki.',
	'sf_templates_definescat' => 'Definir categoría: $1',
	'createtemplate' => 'Crear una plantilla',
	'sf-createtemplate-with-name' => 'Crear plantilla:$1',
	'sf_createtemplate_namelabel' => 'Nombre de la Plantilla:',
	'sf_createtemplate_multipleinstance' => 'Esta plantilla puede incluirse varias veces en la página.',
	'sf_createtemplate_categorylabel' => 'Categoría definida por la plantilla (opcional):',
	'sf_createtemplate_templatefields' => 'Campos de la Plantilla',
	'sf_createtemplate_fieldsdesc' => 'Para obtener los campos en esta plantilla ya no hace falta especificar los nombres de los campos, simplemente ingresa el índice de cada campo (por ejemplo 1, 2, 3, etc.) para referirte a él, en vez de su nombre real.',
	'sf_createtemplate_fieldname' => 'Nombre del Campo:',
	'sf_createtemplate_displaylabel' => 'Mostrar etiqueta:',
	'sf_createtemplate_semanticproperty' => 'Propiedad semántica:',
	'sf_createtemplate_fieldislist' => 'Este campo puede soportar una lista de valores, separados por comas',
	'sf_createtemplate_aggregation' => 'Agregación',
	'sf_createtemplate_aggregationdesc' => 'Para listar, en cualquier página usando esta plantilla, todas la páginas que tengan una cierta propiedad que apunte a esa página, especifica la propiedad adecuada a continuación:',
	'sf_createtemplate_aggregationlabel' => 'Título para la lista:',
	'sf_createtemplate_outputformat' => 'Formato de salida:',
	'sf_createtemplate_standardformat' => 'Tabla',
	'sf_createtemplate_infoboxformat' => 'Caja de información lateral',
	'sf_createtemplate_plainformat' => 'Texto sin formato',
	'sf_createtemplate_sectionsformat' => 'Secciones',
	'sf_createtemplate_addfield' => 'Agregar campo',
	'sf_createtemplate_deletefield' => 'Borrar',
	'sf_createtemplate_addtemplatebeforesave' => 'Debe agregar al menos una plantilla a este formulario antes de guardarlo.',
	'forms' => 'Formularios',
	'sf_forms_docu' => 'Los siguientes formularios existen en el wiki.',
	'sf_forminputs_mandatory' => 'Obligado',
	'sf_forminputs_restricted' => 'Sólo los administradores pueden editar esta entrada',
	'sf_forminputs_class' => 'El atributo "class" de HTML para esta entrada',
	'sf_forminputs_default' => 'El valor por defecto para esta entrada',
	'sf_forminputs_preload' => 'Una página wiki cuyos contenidos serán el valor por defecto de esta entrada',
	'sf_forminputs_property' => 'Una propiedad semántica a la que este campo hace referencia',
	'sf_forminputs_size' => 'El tamaño de este campo de texto, en caracteres',
	'sf_forminputs_maxlength' => 'La longitud de texto máxima permitida en este campo',
	'sf_forminputs_placeholder' => 'Texto de axuda que aparece en la entrada hasta que el usuario haga clic sobre él',
	'sf_forminputs_uploadable' => 'Coloque un enlace "Cargar archivo" junto a esta entrada', # Fuzzy
	'sf_forminputs_defaultfilename' => 'El nombre de archivo por defecto para los archivos cargados',
	'sf_forminputs_rows' => 'El número de líneas para esta entrada',
	'sf_forminputs_cols' => 'El número de columnas para esta entrada',
	'sf_forminputs_autogrow' => 'Configure esta entrada para que aumente de tamaño si el texto supera sus límites',
	'sf_forminputs_valuesfromproperty' => 'Una propiedad cuyos valores en el wiki deben ser el conjunto de valores de esta entrada',
	'sf_forminputs_valuesfromcategory' => 'Una categoría cuyas páginas deben ser el conjunto de valores de esta entrada',
	'sf_forminputs_valuesfromnamespace' => 'Un espacio de nombres cuyas páginas deben ser el conjunto de valores de esta entrada',
	'sf_forminputs_valuesfromconcept' => 'Una página "concept" de Semantic MediaWiki cuyas páginas deben ser el conjunto de valores de esta entrada',
	'sf_forminputs_valuesfromurl' => 'Una dirección URL que contiene datos estructurados que deben ser el conjunto de valores de esta entrada',
	'sf_forminputs_values' => 'El conjunto de valores para esta entrada, separados por comas',
	'sf_forminputs_list' => 'Marcar esta entrada indicando que tiene una lista de valores',
	'sf_forminputs_delimiter' => 'El delimitador entre los valores del campo, si esta entrada tiene una lista de ellos',
	'sf_forminputs_remoteautocompletion' => 'Usar el completado automático remoto',
	'sf_forminputs_existingvaluesonly' => 'Permitir solamente los valores que ya están en la lista',
	'sf_forminputs_showonselect' => 'Elementos de la página a mostrar si sólo se seleccionan algunos valores determinados (por ejemplo: "valor1=>div1; valor2=>div2")',
	'sf_forminputs_listboxsize' => 'La altura de esta caja de listas, en número de líneas',
	'sf_forminputs_includetimezone' => 'Incluir una entrada para la zona horaria',
	'sf_forminputs_topcategory' => 'La categoría madre de este conjunto de categorías (obligatorio)',
	'sf_forminputs_hideroot' => 'Ocultar la categoría madre',
	'sf_forminputs_depth' => 'El número de niveles de categorías a mostrar inicialmente',
	'sf_forminputs_height' => 'La altura de esta entrada, en píxeles',
	'sf_forminputs_width' => 'La anchura de esta entrada, en píxeles',
	'createform' => 'Crear un formulario',
	'sf-createform-with-name' => 'Crear formulario: $1',
	'sf_createform_nameinput' => 'Nombre del Formulario',
	'sf_createform_nameinputdesc' => '(normalmente, el formulario recibe el mismo nombre que su plantilla principal):',
	'sf_createform_template' => 'Plantilla:',
	'sf_createform_templatelabelinput' => 'Etiqueta de la plantilla (opcional):',
	'sf_createform_allowmultiple' => 'Permitir múltiples (o ninguna) instancias de esta plantilla en la página creada',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Este campo define la propiedad $1, de tipo $2.',
	'sf_createform_fieldproplist' => 'Este campo define una lista de elementos que tienen la propiedad $1, de tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Este campo define la propiedad $1, de tipo no especificado.',
	'sf_createform_inputtype' => 'Tipo de entrada:',
	'sf_createform_inputtypedefault' => '(predeterminado)',
	'sf_createform_formlabel' => 'Etiqueta del Formulario:',
	'sf_createform_hidden' => 'Oculto',
	'sf_createform_removetemplate' => 'Sacar plantilla',
	'sf_createform_addtemplate' => 'Agregar plantilla:',
	'sf_createform_beforetemplate' => 'Plantilla anterior:',
	'sf_createform_atend' => 'Al final',
	'sf_createform_add' => 'Agregar',
	'sf_createform_choosefield' => 'Escoger un campo para agregar',
	'createcategory' => 'Crear una categoría',
	'sf-createcategory-with-name' => 'Crear la categoría:$1',
	'sf_createcategory_name' => 'Nombre de categoría:',
	'sf_createcategory_defaultform' => 'Formulario predeterminado:',
	'sf_createcategory_makesubcategory' => 'Hacer esto una subcategoría de otra categoría (opcional):',
	'createclass' => 'Crear una clase',
	'sf_createclass_docu' => 'Ingresar todos los datos aquí para crear las propiedades, plantilla, formulario y categoría para una sóla clase. Para más opciones, usar las páginas $1 en su lugar.',
	'sf_createclass_allowedvalues' => 'Valores permitidos:',
	'sf_createclass_listofvalues' => '¿Lista de valores?',
	'sf_createclass_nameinput' => 'Nombre del formulario:',
	'sf_createclass_missingvalues' => 'No todos los campos requeridos fueron llenados.',
	'sf_createclass_success' => 'Propiedades, plantilla, formulario y categoría serán creadas.',
	'sf_createclass_create' => 'Crear',
	'formstart' => 'Agregar página con formulario',
	'sf_formstart_badform' => 'Error: no se encontró la página del formulario en $1',
	'sf_formstart_badtitle' => 'Error: "$1" es un título inválido para una página.',
	'sf_formstart_docu' => "Ingresar el nombre de la página aqui, para ser editado con el formulario '$1'. Si esta página ya existe, usted será enviado al formulario para editar esa página. De otra forma, usted será enviado al formulario para agregar la página.",
	'sf_formstart_noform_docu' => 'Ingresar el nombre de la página aqui, y seleccionar el formulario con el cual se editará. Si esta página ya existe, usted será enviado al formulario para editar esa página. De otra forma, usted será enviado al formulario para agregar la página.',
	'sf_formstart_createoredit' => 'Crear o editar',
	'formedit' => 'Editar con formulario',
	'sf_formedit_createtitle' => 'Crear $1: $2',
	'sf_formedit_createtitlenotarget' => 'Crear $1',
	'sf_formedit_badurl' => "Esta es la página para la edición con un formulario. Debe especificar tanto el nombre del formulario como la página de destino en la URL; el resultado se debería ver 'Especial:EditarFormulario?form=<nombre del formulario>&target=<página destino>' o 'Epecial:EditarFormulario/<nombre del formulario>/<página destino>'.",
	'sf_formedit_altforms' => 'Usted puede también agregar esta página con uno de los siguientes formularios:',
	'sf_formedit_altformsonly' => 'Porfavor seleccionar de uno de los siguientes formularios para agregar esta página:',
	'sf_formcreate' => 'Crear con formulario',
	'sf_viewform' => 'Ver formulario',
	'sf_editsource' => 'Editar fuente',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => 'Advertencia: Más de un formulario por defecto está definido para esta página.',
	'sf_formedit_formwarning' => 'Advertencia: Esta página <a href="$1">ya existe</a>, pero no usa este formulario.',
	'sf_formedit_mismatchedbrackets' => 'Aviso:  Esta página contiene paréntesis, corchetes o llaves sin cerrar, de modo que el formulario no manejará la página correctamente. <a href="$1">Corrija el error en el texto fuente</a> antes de continuar.',
	'sf_formedit_remove' => 'Sacar', # Fuzzy
	'sf_formedit_addanother' => 'Agregar otro',
	'sf_formedit_none' => 'Ninguno',
	'sf_formedit_emptytitle' => 'Error: Los datos insertados dieron como resultado un título de página en blanco.',
	'sf_formedit_hookerror' => 'Error: Una extensión de MediaWiki impidió la modificación de la página de destino.',
	'sf_formedit_saveandcontinueediting' => 'Guardar y continuar',
	'sf_formedit_saveandcontinue_summary' => 'Guardado mediante el botón "$1" del formulario',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Guardar datos y continuar editando',
	'sf_autoedit_anoneditwarning' => 'Aviso: No ha iniciado sesión en el sistema. Su dirección IP quedará registrada en el historial de revisiones de esta página.',
	'sf_autoedit_success' => 'Se modificó correctamente [[$1]] empleando el formulario $2.',
	'sf_autoedit_fail' => 'Error al modificar [[$1]].',
	'sf_autoedit_notargetspecified' => 'No se especificó ninguna página de destino.',
	'sf_autoedit_invalidtargetspecified' => 'La página de destino especificada, $1, no es válida.',
	'sf_autoedit_invalidform' => '$1 no es un formulario válido.',
	'sf_autoedit_redirectlimitexeeded' => 'Sue ha superado el límite máximo de redirecciones para el formulario $1.',
	'sf_autoedit_invalidredirecttarget' => '$1 no es un objetivo válido de redirección el formulario $2.',
	'sf_autoedit_invalidpreloadspecified' => 'La página de precarga especificada, $1, no es válida.',
	'sf_autoedit_redlinkexists' => '$1 ya existe.',
	'sf_autoedit_noformfound' => 'No se especificó ningún formulario.',
	'sf_autoedit_toomanyformsfound' => 'Hay más de un formulario disponible para la página.',
	'sf_autoedit_readonly' => 'La base de datos está actualmente bloqueada para modificaciones. Motivo: $1',
	'sf_autoedit_nosemanticform' => 'No se pudo obtener el formulario $2 para la página $1. Véase  [[{{#special:FormEdit}}/$2/$1]] para más detalles.',
	'sf_autoedit_summary' => 'Editado automáticamente a partir de la página $1.',
	'sf-autoedit-wait' => 'Espera...',
	'runquery' => 'Ejecutar consulta',
	'sf_runquery_badurl' => "Debes especificar un nombre de formulario en el URL;
el URL debería lucir como 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'Ejecutar consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta adicional',
	'sf_formerrors_header' => 'Hubo errores en los datos del formulario; vea más abajo',
	'sf_blank_error' => 'no puede estar en blanco',
	'sf_bad_url_error' => "debe tener el formato correcto de URL, comenzando con 'http'",
	'sf_bad_email_error' => 'debe tener una dirección de correo electrónico con un formato válido',
	'sf_bad_number_error' => 'debe ser un número válido',
	'sf_bad_date_error' => 'debe ser una fecha válida',
	'uploadwindow' => 'Ventana para subir archivos',
	'sf_deletionlog' => 'Registro de borrado',
	'sf-preview-header' => 'Vista previa del formulario',
	'sf-preview-note' => 'Este será el aspecto del formulario cuando esté en uso:',
	'sf-pageschemas-pagenameformula' => 'Fórmula del nombre de página:',
	'sf-pageschemas-createtitle' => 'Título del formulario para las páginas nuevas:',
	'sf-pageschemas-edittitle' => 'Título del formulario para las páginas existentes:',
	'sf-pageschemas-inputtype' => 'Tipo de entrada (déjelo en blanco para el valor predeterminado):',
	'sf_property_isproperty' => 'Esta es una propiedad de tipo $1.',
	'sf_property_linkstoform' => 'Vincula a páginas que usen el formulario $1.',
	'sf_property_allowedvals' => 'Los {{PLURAL:$1|valor permitido para esta propiedad es|valores permitidos para esta propiedad son}}:',
	'sf_template_docu' => "Este es la plantilla '$1'. Debe ser llamada en el siguiente formato:",
	'sf_template_docufooter' => 'Editar la página para ver el texto de la plantilla.',
	'sf_form_docu' => "Este es el formulario ''$1''.
Para crear una página con este formulario, ingrese el nombre de la página a continuación; si la página con ese nombre ya existe, será dirigido al formulario para editar esa página.",
	'sf_form_freetextlabel' => 'Texto libre',
	'sf_category_hasdefaultform' => 'Esta categoría usa el formulario $1.',
	'sf_category_desc' => 'Esta es la categoría $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Ver pestaña "Editar" para páginas editables por formulario', # Fuzzy
	'right-editrestrictedfields' => 'Editar campos de formulario restringidos',
	'right-createclass' => 'Crear nuevas clases semánticas',
	'action-createclass' => 'crear nuevas clases semánticas',
	'action-editrestrictedfields' => 'editar los campos restringidos de los formularios',
	'action-viewedittab' => 'ver la pestaña "Editar" en las páginas editables por formularios', # Fuzzy
);

/** Estonian (eesti)
 * @author Avjoska
 */
$messages['et'] = array(
	'sf_createproperty_proptype' => 'Tüüp:',
	'templates' => 'Mallid',
	'createtemplate' => 'Loo mall',
	'sf-createtemplate-with-name' => 'Loo mall: $1',
	'sf_createtemplate_namelabel' => 'Malli nimi:',
	'sf_createtemplate_templatefields' => 'Malli väljad',
	'sf_createtemplate_fieldname' => 'Välja nimi:',
	'sf_createtemplate_standardformat' => 'Tabel',
	'sf_createtemplate_plainformat' => 'Lihttekst',
	'sf_createtemplate_addfield' => 'Lisa väli',
	'sf_createtemplate_deletefield' => 'Kustuta',
	'createform' => 'Loo vorm',
	'sf_createform_template' => 'Mall:',
	'sf_createform_field' => 'Väli:',
	'sf_createform_hidden' => 'Peidetud',
	'sf_createform_removetemplate' => 'Eemalda mall',
	'sf_createform_addtemplate' => 'Lisa mall:',
	'sf_createform_beforetemplate' => 'Enne malli:',
	'sf_createform_atend' => 'Lõpus',
	'sf_createform_add' => 'Lisa',
	'sf_createform_choosefield' => 'Lisamiseks vali väli',
	'createcategory' => 'Loo kategooria',
	'sf-createcategory-with-name' => 'Loo kategooria: $1',
	'sf_createcategory_name' => 'Kategooria nimi:',
	'sf_createclass_listofvalues' => 'Väärtuste loend?',
	'sf_formstart_createoredit' => 'Loo või redigeeri',
	'sf_formedit_remove' => 'Eemalda',
	'sf_formedit_addanother' => 'Lisa teine',
	'sf_formedit_saveandcontinueediting' => 'Salvesta ja jätka',
	'sf-autoedit-wait' => 'Oota...',
	'runquery' => 'Käivita päring',
	'sf_blank_error' => 'ei tohi olla tühi',
	'sf_bad_email_error' => 'peab olema sobiv e-aadressi vorming',
	'sf_bad_number_error' => 'peab olema sobiv number',
	'sf_bad_date_error' => 'peab olema kehtiv kuupäev',
	'sf_deletionlog' => 'Kustutamislogi',
	'sf_form_freetextlabel' => 'Vaba tekst',
	'sf_category_desc' => 'See on $1 kategooria.',
	'sf_blank_namespace' => 'Põhinimeruum',
);

/** Basque (euskara)
 * @author An13sa
 * @author Kobazulo
 */
$messages['eu'] = array(
	'createproperty' => 'Propietatea sortu',
	'sf_createproperty_propname' => 'Ezaugarriaren izena:',
	'sf_createproperty_proptype' => 'Mota:',
	'templates' => 'Txantiloiak',
	'createtemplate' => 'Txantiloia sortu',
	'sf_createtemplate_namelabel' => 'Txantiloiaren izena:',
	'sf_createtemplate_displaylabel' => 'Etiketa erakutsi:',
	'sf_createtemplate_deletefield' => 'Ezabatu',
	'sf_createform_template' => 'Txantiloia:',
	'sf_createform_removetemplate' => 'Txantiloia kendu',
	'sf_createform_addtemplate' => 'Txantiloia gehitu:',
	'sf_createform_add' => 'Gehitu',
	'createcategory' => 'Kategoria sortu',
	'sf_createcategory_name' => 'Kategoriaren izena:',
	'sf_formstart_createoredit' => 'Sortu edo aldatu',
	'sf_formedit_createtitle' => '$1 aldatu: $2',
	'sf_editsource' => 'Iturria aldatu',
	'sf_formedit_edittitle' => '$1 aldatu: $2',
	'sf_formedit_remove' => 'Kendu',
	'sf_formedit_addanother' => 'Beste bat gehitu',
	'sf_deletionlog' => 'Ezabaketa erregistroa',
	'sf_form_freetextlabel' => 'Testu askea',
	'sf_blank_namespace' => 'Nagusia',
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Huji
 * @author Mjbmr
 * @author Momeni
 * @author Tofighi
 */
$messages['fa'] = array(
	'semanticforms-desc' => 'فرم‌هایی برای افزودن و ویرایش اطلاعات معنایی',
	'specialpages-group-sf_group' => 'فرم‌های معنایی',
	'createproperty' => 'ویژگی بسازید',
	'sf_createproperty_allowedvalsinput' => 'اگر می‌خواهید این ورودی تنها مقادیر مشخصی داشته باشد،سیاهه مقادیر را وارد کنید و آنها را با کاما جدا سازید (اگر در این مقادیر از کاما استفاده می‌کنید، آن‌را با "\\،" جایگزین نمایید):', # Fuzzy
	'sf_createproperty_propname' => 'نام:', # Fuzzy
	'sf_createproperty_proptype' => 'نوع:',
	'templates' => 'الگوها',
	'sf_templates_docu' => 'الگوهای زیر در این ویکی وجود دارند.',
	'sf_templates_definescat' => 'تعیین رده: $1',
	'createtemplate' => 'الگو بسازید',
	'sf_createtemplate_namelabel' => 'نام الگو:',
	'sf_createtemplate_categorylabel' => 'تعیین رده به‌وسیله الگو (دلخواه):',
	'sf_createtemplate_templatefields' => 'ورودی‌های الگو',
	'sf_createtemplate_fieldsdesc' => 'برای داشتن ورودی‌های بدون نام در الگوها،کافیست شماره ورودی را به جای نام واقعی ورودی وارد کنید (مثلا ۳،۲،۱ و ...).',
	'sf_createtemplate_fieldname' => 'نام ورودی:',
	'sf_createtemplate_displaylabel' => 'نمایش برچسب:',
	'sf_createtemplate_semanticproperty' => 'ویژگی معنایی:',
	'sf_createtemplate_fieldislist' => 'این ورودی می‌تواند یک سیاهه از مقادیر را که با کاما از هم جدا شده‌اند، در خود ذخیره کند',
	'sf_createtemplate_aggregation' => 'تراکم',
	'sf_createtemplate_aggregationdesc' => 'برای داشتن سیاهه همه صفحاتی که این الگو را به‌کار می‌برند، و همه آن مقالاتی که با ویژگی معینی با آن صفحه در ارتباط هستند، وِیژگی مناسب را مشخص کنید:', # Fuzzy
	'sf_createtemplate_aggregationlabel' => 'عنوان سیاهه',
	'sf_createtemplate_outputformat' => 'قالب خروجی:',
	'sf_createtemplate_standardformat' => 'استاندارد', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'جعبه اطلاعات سمت راست', # Fuzzy
	'sf_createtemplate_plainformat' => 'متن ساده',
	'sf_createtemplate_sectionsformat' => 'بخش‌ها',
	'sf_createtemplate_addfield' => 'افزودن ورودی',
	'sf_createtemplate_deletefield' => 'حذف',
	'sf_createtemplate_addtemplatebeforesave' => 'قبل از اینکه بتوانید فرم را ذخیره کنید، شما می‌بایست حداقل یک الگو به این فرم اضافه نمایید.',
	'forms' => 'فرم‌ها',
	'sf_forms_docu' => 'فرم‌های زیر در این ویکی وجود دارند.',
	'sf_forminputs_mandatory' => 'الزامی',
	'sf_forminputs_restricted' => 'فقط مدیران می‌توانند این ورودی را ویرایش کنند',
	'createform' => 'فرم بسازید',
	'sf_createform_nameinput' => 'نام فرم (بهتر است که بعد از پر شدن به‌وسیله یک الگو، فرم نام‌گذاری شود):', # Fuzzy
	'sf_createform_template' => 'الگو:',
	'sf_createform_templatelabelinput' => 'برچسب الگو (دلخواه):',
	'sf_createform_allowmultiple' => 'می‌توان چند (یا صفر) نمونه از این الگو را در ساختن صفحه‌ها استفاده کرد', # Fuzzy
	'sf_createform_field' => 'ورودی:',
	'sf_createform_fieldprop' => 'این ورودی ویژگی $1 از نوع $2 را تعیین می‌کند.',
	'sf_createform_fieldproplist' => 'این ورودی یک سیاهه از مواردی که ویژگی $1 از نوع $2 را دارند، تعیین می‌کند.',
	'sf_createform_fieldpropunknowntype' => 'این ورودی ویژگی $1 از نوع نامشخص را تعیین می‌کند.',
	'sf_createform_inputtype' => 'نوع ورودی:',
	'sf_createform_inputtypedefault' => '(پیش‌فرض)',
	'sf_createform_formlabel' => 'برچسب فرم:',
	'sf_createform_hidden' => 'مخفی',
	'sf_createform_removetemplate' => 'حذف الگو',
	'sf_createform_addtemplate' => 'افزودن الگو:',
	'sf_createform_beforetemplate' => 'قبل از الگوی:',
	'sf_createform_atend' => 'در آخر',
	'sf_createform_add' => 'افزودن',
	'sf_createform_choosefield' => 'یک ورودی برای افزودن انتخاب کنید',
	'createcategory' => 'رده بسازید',
	'sf_createcategory_name' => 'نام:', # Fuzzy
	'sf_createcategory_defaultform' => 'فرم پیش‌فرض:',
	'sf_createcategory_makesubcategory' => 'قرار دادن این رده به عنوان زیررده یک رده دیگر(دلخواه):',
	'sf_createclass_create' => 'ایجاد',
	'formstart' => 'افزودن صفحه',
	'sf_formstart_badform' => 'خطا: هیچ صفحه فرمی در $1 پیدا نشد',
	'sf_formstart_docu' => "برای ویرایش با فرم '$1'، نام صفحه را اینجا وارد کنید. اگر صفحه در حال حاضر موجود باشد، شما به فرم ویرایش صفحه هدایت می‌شوید. در غیر این‌صورت به فرم افزودن صفحه منتقل خواهید شد.",
	'sf_formstart_noform_docu' => 'نام صفحه را اینجا وارد کنید و فرمی را که می‌خواهید ویرایش با آن انجام شود انتخاب نمایید. اگر صفحه در حال حاضر موجود باشد، شما به صفحه ویرایش آن صفحه به‌وسیله فرم  هدایت می‌شوید. در غیر این‌صورت به فرم افزودن صفحه منتقل خواهید شد.',
	'sf_formstart_createoredit' => 'افزودن یا ویرایش',
	'formedit' => 'ویرایش با فرم',
	'sf_formedit_createtitle' => 'افزودن $1: $2',
	'sf_formedit_badurl' => 'این صفحه برای افزودن اطلاعات است. شما باید هم نام فرم هم صفحه مقصد را در URL وارد کنید. چیزی شبیه به این <br /><span dir="ltr"> \'ویژه:FormEdit?form=<نام فرم>&target=<صفحه مقصد>\' </span><br />یا<br /><span dir="ltr"> \'ویژه:FormEdit/<نام فرم>/<صفحه مقصد>\' </span>.',
	'sf_formedit_altforms' => 'می‌توانید این صفحه را به‌وسیله فرم‌های زیر نیز بسازید:',
	'sf_formedit_altformsonly' => 'لطفا برای افزودن صفحه از یکی از فرم‌های زیر استفاده کنید:',
	'sf_viewform' => 'نمایش فرم',
	'sf_editsource' => 'ویرایش مبدأ',
	'sf_formedit_edittitle' => 'ویرایش $1: $2',
	'sf_formedit_formwarning' => 'اخطار: این صفحه <a href="$1">هم‌اکنون وجود دارد</a>، ولی به‌وسیله این فرم ساخته نشده است.',
	'sf_formedit_remove' => 'حذف',
	'sf_formedit_addanother' => 'افزدون دیگری',
	'sf_formedit_none' => 'هیچکدام',
	'sf-autoedit-wait' => 'صبر کنید...',
	'runquery' => 'اجرای پرس و جو',
	'sf_runquery_additionalquery' => 'پرس و جوی اضافی',
	'sf_formerrors_header' => 'خطاهایی در ورودی فرمتان وجود دارد؛ قسمت پایین را ببینید',
	'sf_blank_error' => 'نمی‌تواند خالی باشد',
	'sf_bad_url_error' => "باید قالب URL درستی داشته باشد و با 'http' شروع شود",
	'sf_bad_email_error' => 'باید قالب صحیحی برای پست الکترونیک داشته باشد',
	'sf_bad_number_error' => 'باید یک عدد معتبر باشد',
	'sf_bad_date_error' => 'باید یک تاریخ معتبر باشد',
	'uploadwindow' => 'پنجره بارگذاری',
	'sf_deletionlog' => 'سیاههٔ حذف',
	'sf_property_isproperty' => 'این یک ویژگی از نوع $1 است.',
	'sf_property_allowedvals' => 'مقادیر مجاز برای این ویژگی یا صفت این‌ها هستند:', # Fuzzy
	'sf_template_docu' => "این الگوی '$1' است. باید با این قالب فراخوانی شود:",
	'sf_template_docufooter' => 'برای مشاهده متن الگو صفحه را ویرایش کنید.',
	'sf_form_docu' => "این فرم '$1' است. برای افزودن یک صفحه به‌وسیله این فرم،نام صفحه را وارد کنید، اگر صفحه‌ای با این نام وجود داشته باشد، به فرم ویرایش صفحه هدایت می‌شوید.", # Fuzzy
	'sf_form_freetextlabel' => 'متن دلخواه',
	'sf_category_hasdefaultform' => 'این رده از فرم $1 استفاده می‌کند.',
	'sf_category_desc' => 'این رده $1 است.',
	'sf_blank_namespace' => 'اصلی',
);

/** Finnish (suomi)
 * @author Beluga
 * @author Centerlink
 * @author Cimon Avaro
 * @author Crt
 * @author Mobe
 * @author Nedergard
 * @author Nike
 * @author Silvonen
 * @author Str4nd
 * @author ZeiP
 */
$messages['fi'] = array(
	'semanticforms-desc' => 'Semanttisen tiedon syöttö- ja muokkauslomakkeet',
	'specialpages-group-sf_group' => 'Semanttiset lomakkeet',
	'createproperty' => 'Luo ominaisuus',
	'sf-createproperty-with-name' => 'Luo ominaisuus: $1',
	'sf_createproperty_linktoform' => 'Tämä ominaisuus linkittää sivuille, jotka käyttävät lomaketta:',
	'sf_createproperty_allowedvalsinput' => 'Jos ominaisuudella saa olla vain tiettyjä arvoja, lisää pilkuin erotettu lista sallituista arvoista (jos arvo sisältää pilkun, korvaa pilkku kenoviivalla ja pilkulla: ”\\,”):',
	'sf_createproperty_propname' => 'Ominaisuuden nimi',
	'sf_createproperty_proptype' => 'Tyyppi',
	'templates' => 'Mallineet',
	'sf_templates_docu' => 'Tässä wikissä on seuraavat mallineet:',
	'sf_templates_definescat' => 'määrittelee luokan $1',
	'createtemplate' => 'Luo malline',
	'sf-createtemplate-with-name' => 'Luo malline: $1',
	'sf_createtemplate_namelabel' => 'Mallineen nimi',
	'sf_createtemplate_multipleinstance' => 'Tämä malline voi olla monta kertaa samalla sivulla.',
	'sf_createtemplate_categorylabel' => 'Mallineen määrittelemä luokka (valinnainen)',
	'sf_createtemplate_templatefields' => 'Mallineen kentät',
	'sf_createtemplate_fieldsdesc' => 'Kenttien määrittäminen tähän mallineeseen onnistuu nykyään käyttämällä numeroita (1, 2, 3…) kentän nimenä oikean nimen sijaan.',
	'sf_createtemplate_fieldname' => 'Kentän nimi',
	'sf_createtemplate_displaylabel' => 'Näyttönimi',
	'sf_createtemplate_semanticproperty' => 'Semanttinen ominaisuus',
	'sf_createtemplate_fieldislist' => 'Tämä kenttä voi sisältää pilkuin erotetun listan arvoista',
	'sf_createtemplate_aggregation' => 'Aggregaatio',
	'sf_createtemplate_aggregationdesc' => 'Jos haluat listan (millä tahansa mallinetta käyttävällä sivulla) sivuista, joilla on tietty ominaisuus, joka osoittaa sivuun, määrittele sopiva ominaisuus alle:',
	'sf_createtemplate_aggregationlabel' => 'Listan otsikko',
	'sf_createtemplate_outputformat' => 'Tulostemuoto',
	'sf_createtemplate_standardformat' => 'Taulukko',
	'sf_createtemplate_infoboxformat' => 'Reunassa oleva tietolaatikko',
	'sf_createtemplate_plainformat' => 'Muotoilematon teksti',
	'sf_createtemplate_sectionsformat' => 'Osiot',
	'sf_createtemplate_addfield' => 'Lisää kenttä',
	'sf_createtemplate_deletefield' => 'Poista',
	'sf_createtemplate_addtemplatebeforesave' => 'Sinun pitää lisätä ainakin yksi malline tähän lomakkeeseen, ennen kuin voit tallentaa sen.',
	'forms' => 'Lomakkeet',
	'sf_forms_docu' => 'Tässä wikissä on seuraavat lomakkeet:',
	'sf_forminputs_mandatory' => 'Pakollinen',
	'sf_forminputs_restricted' => 'Vain ylläpitäjät voivat muokata tätä',
	'sf_forminputs_class' => 'Tämän syötteen HTML-attribuutti "class"',
	'sf_forminputs_default' => 'Tämän syötteen oletusarvo',
	'sf_forminputs_preload' => 'Wikisivu, jonka sisällöstä tulee tämän syötteen oletusarvo',
	'sf_forminputs_property' => 'Semanttinen ominaisuus, jota tämä kenttä vastaa',
	'sf_forminputs_size' => 'Tämän tekstikentän koko merkkeinä',
	'sf_forminputs_maxlength' => 'Tekstin suurin sallittu pituus tässä kentässä',
	'sf_forminputs_placeholder' => 'Ohjeteksti, joka näkyy kentässä, kunnes käyttäjä napsauttaa sitä',
	'sf_forminputs_uploadable' => 'Lisää "Lataa tiedosto" -linkin tämän kentän viereen', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Ladattujen tiedostojen oletusnimi',
	'sf_forminputs_rows' => 'Syötteen rivimäärä',
	'sf_forminputs_cols' => 'Syötteen sarakemäärä',
	'sf_forminputs_autogrow' => 'Salli kentän koon suureneminen, jos teksti ylittää sen rajat',
	'sf_forminputs_valuesfromproperty' => 'Ominaisuus, jonka wikissä olevien arvojen tulisi olla tämän syöttökentän arvojoukkona.',
	'sf_forminputs_valuesfromcategory' => 'Luokka, jonka sivujen tulisi olla tämän syöttökentän arvojoukkona.',
	'sf_forminputs_valuesfromnamespace' => 'Nimiavaruus, jonka sivujen tulisi olla tämän syöttökentän arvojoukkona.',
	'sf_forminputs_valuesfromconcept' => 'Semantic MediaWikin konsepti, jonka sivujen tulisi olla tämän syöttökentän arvojoukkona.',
	'sf_forminputs_valuesfromurl' => 'Osoite, jonka jäsennellyn datan tulisi olla tämän syöttökentän arvojoukkona',
	'sf_forminputs_values' => 'Syötteen arvojoukko, erottimena pilkku',
	'sf_forminputs_list' => 'Merkitse tämä kentäksi, jolla on arvoluettelo',
	'sf_forminputs_delimiter' => 'Kentän arvojen erotin, jos kentällä on arvoluettelo',
	'sf_forminputs_remoteautocompletion' => 'Käytä automaattista etätäydennystä',
	'sf_forminputs_existingvaluesonly' => 'Salli vain luettelossa olevat arvot',
	'sf_forminputs_showonselect' => 'Sivun elementit, jotka näytetään vain, jos jokin tietty arvo on valittu (esim.: "arvo1=>div1;arvo2=>div2")',
	'sf_forminputs_listboxsize' => 'Luetteloruudun korkeus riveinä',
	'sf_forminputs_includetimezone' => 'Lisää aikavyöhykekenttä',
	'sf_forminputs_topcategory' => 'Tämän luokkajoukon ylätason luokka (pakollinen)',
	'sf_forminputs_hideroot' => 'Piilota ylätason luokka',
	'sf_forminputs_depth' => 'Alussa näytettävien luokkatasojen määrä',
	'sf_forminputs_height' => 'Tämän kentän korkeus pikseleinä',
	'sf_forminputs_width' => 'Tämän kentän leveys pikseleinä',
	'createform' => 'Luo lomake',
	'sf-createform-with-name' => 'Luo lomake: $1',
	'sf_createform_nameinput' => 'Lomakkeen nimi',
	'sf_createform_nameinputdesc' => '(lomakkeen nimi on tavallisesti sama kuin sen päämallineen nimi):',
	'sf_createform_template' => 'Malline',
	'sf_createform_templatelabelinput' => 'Mallineen otsikko (valinnainen)',
	'sf_createform_allowmultiple' => 'Tämä malline voi esiintyä luodulla sivulla useasti tai ei kertaakaan',
	'sf_createform_field' => 'Kenttä',
	'sf_createform_fieldprop' => 'Tämä kenttä määrittelee ominaisuuden $1, joka on tyyppiä $2.',
	'sf_createform_fieldproplist' => 'Tämä kenttä määrittelee listan elementeistä, joilla on ominaisuus $1, joka on tyyppiä $2.',
	'sf_createform_fieldpropunknowntype' => 'Tämä kenttä määrittelee ominaisuuden $1, jonka tyyppi on määrittelemätön.',
	'sf_createform_inputtype' => 'Syötetyyppi',
	'sf_createform_inputtypedefault' => '(oletus)',
	'sf_createform_formlabel' => 'Lomakkeen otsikko',
	'sf_createform_hidden' => 'Piilotettu',
	'sf_createform_removetemplate' => 'Poista malline',
	'sf_createform_addtemplate' => 'Lisää malline',
	'sf_createform_beforetemplate' => 'Ennen mallinetta',
	'sf_createform_atend' => 'Lopussa',
	'sf_createform_add' => 'Lisää',
	'sf_createform_choosefield' => 'Valitse lisättävä kenttä',
	'createcategory' => 'Luo luokka',
	'sf-createcategory-with-name' => 'Luo luokka: $1',
	'sf_createcategory_name' => 'Luokan nimi',
	'sf_createcategory_defaultform' => 'Oletuslomake',
	'sf_createcategory_makesubcategory' => 'Tee tästä toisen luokan alaluokka (valinnainen):',
	'createclass' => 'Luo luokka',
	'sf_createclass_docu' => 'Kirjoita kaikki tiedot tähän ominaisuuksien, mallineen, muodon ja luokan luomiseksi yksittäisluokkaan. Käytä lisäasetuksia varten sen sijaan sivuja $1.',
	'sf_createclass_allowedvalues' => 'Sallitut arvot',
	'sf_createclass_listofvalues' => 'Luettelo arvoista?',
	'sf_createclass_nameinput' => 'Lomakkeen nimi',
	'sf_createclass_missingvalues' => 'Kaikkia pakollisia kenttiä ei ole täytetty.',
	'sf_createclass_success' => 'Ominaisuudet, malline, lomake ja luokka luodaan.',
	'sf_createclass_create' => 'Luo',
	'formstart' => 'Lomakeluonti',
	'sf_formstart_badform' => 'Virhe: lomaketta ei löytynyt sivulta $1.',
	'sf_formstart_badtitle' => 'Virhe: ”$1” on virheellinen nimi sivulle.',
	'sf_formstart_docu' => 'Anna sivun nimi, jota muokataan lomakkeella $1. Jos sivu on jo olemassa, sinut ohjataan lomakkeelle, jolla voi muokata sitä sivua. Muussa tapauksessa sinut ohjataan sivunlisäyslomakkeelle.',
	'sf_formstart_noform_docu' => 'Anna sivun nimi ja valitse lomake, jolla haluat muokata sitä. Jos sivu on jo olemassa, sinut ohjataan lomakkeelle, jolla voit muokata sitä sivua. Muussa tapauksessa sinut ohjataan sivunlisäyslomakkeelle.',
	'sf_formstart_createoredit' => 'Luo tai muokkaa',
	'formedit' => 'Muokkaa lomakkeella',
	'sf_formedit_createtitle' => 'Luo $1: $2',
	'sf_formedit_createtitlenotarget' => 'Luo $1',
	'sf_formedit_badurl' => 'Tämä sivu on datan lisäämistä varten. Sinun täytyy määritellä sekä lomakkeen nimi että kohdesivu URL-osoitteessa. Osoitteen pitäisi olla muotoa ”Special:FormEdit?form=<lomakkeen nimi>&target=<kohdesivu>” tai ”Special:FormEdit/<lomakkeen nimi>/<kohdesivu>”.',
	'sf_formedit_altforms' => 'Voit sen sijaan lisätä tämän sivun ja jonkun seuraavista lomakkeista:',
	'sf_formedit_altformsonly' => 'Valitse jokin seuraavista lomakkeista, jonka haluat lisätä tällä sivulle:',
	'sf_formcreate' => 'Luo lomakkeella',
	'sf_viewform' => 'Näytä lomake',
	'sf_editsource' => 'Muokkaa lähdetekstiä',
	'sf_formedit_edittitle' => 'Muokkaa $1: $2',
	'sf_formedit_morethanoneform' => "'''Varoitus:''' Tällä sivulla on useita oletuslomakkeita.",
	'sf_formedit_formwarning' => 'Varoitus: sivu <a href="$1">on jo olemassa</a>, mutta se ei käytä tätä lomaketta.',
	'sf_formedit_mismatchedbrackets' => 'Varoitus: Sivulla ei ole lopettavia aalto- tai hakasulkeita, minkä takia lomake ei voi käsitellä sivua oikein. <a href="$1">Korjaa virhe alkutekstissä</a> ennen kuin jatkat.',
	'sf_formedit_remove' => 'Poista',
	'sf_formedit_addanother' => 'Lisää toinen',
	'sf_formedit_none' => 'ei mikään',
	'sf_formedit_emptytitle' => 'Virhe: Syötetyt tiedot aiheuttavat tyhjän sivun otsikon.',
	'sf_formedit_hookerror' => 'Virhe: MediaWiki-laajennus esti kohdesivun muokkauksen.',
	'sf_formedit_saveandcontinueediting' => 'Tallenna ja jatka',
	'sf_formedit_saveandcontinue_summary' => 'Tallennettu lomakkeen "$1" -painikkeen avulla',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Tallenna tiedot ja jatka muokkaamista',
	'sf_autoedit_anoneditwarning' => 'Varoitus: Et ole kirjautunut sisään. IP-osoitteesi kirjataan tämän sivun muokkaushistoriaan.',
	'sf_autoedit_success' => '[[$1]]: muokkaus lomakkeen $2 avulla onnistui.',
	'sf_autoedit_fail' => '[[$1]]: muokkaus epäonnistui.',
	'sf_autoedit_notargetspecified' => 'Kohdesivua ei ole määritetty.',
	'sf_autoedit_invalidtargetspecified' => 'Valitu kohdesivu $1 on väärä.',
	'sf_autoedit_invalidform' => '$1 ei ole kelvollinen lomake.',
	'sf_autoedit_redirectlimitexeeded' => 'Lomakkeen $1 ohjausten enimmäismäärä ylitettiin.',
	'sf_autoedit_invalidredirecttarget' => '$1 ei ole sallittu ohjauksen kohde lomakkeelle $2.',
	'sf_autoedit_invalidpreloadspecified' => 'Määritetty esilaattava sivu $1 ei ole sallittu.',
	'sf_autoedit_redlinkexists' => '$1 on jo olemassa.',
	'sf_autoedit_noformfound' => 'Lomaketta ei ole määritetty.',
	'sf_autoedit_toomanyformsfound' => 'Sivulla on lomaketta.',
	'sf_autoedit_readonly' => 'Tietokanta on lukittu eikä sitä voi muokata. Syy:$1',
	'sf_autoedit_nosemanticform' => 'Lomaketta $2 ei voitu noutaa sivulle $1. Lisätietoja antaa [[{{#special:FormEdit}}/$2/$1]].',
	'sf_autoedit_summary' => 'Muokata automaattisesti sivulta  $1 .',
	'sf-autoedit-wait' => 'Odota...',
	'runquery' => 'Suorita kysely',
	'sf_runquery_badurl' => 'Sinun tulee antaa lomakkeen nimi URL-osoitteessa;
osoitteen tulisi näyttää esimerkiksi tältä: ”Special:RunQuery/<form name>”.',
	'sf_runquery_title' => 'Suorita kysely: $1',
	'sf_runquery_additionalquery' => 'Lisähakukysely',
	'sf_formerrors_header' => 'Lomakkeen tiedoissa oli virheitä; katso alla.',
	'sf_blank_error' => 'ei voi olla tyhjä',
	'sf_bad_url_error' => 'pitää olla kelvollinen URL-osoite, jonka protokolla on http',
	'sf_bad_email_error' => 'pitää olla kelvollinen sähköpostiosoite',
	'sf_bad_number_error' => 'pitää olla kelvollinen numero',
	'sf_bad_date_error' => 'pitää olla kelvollinen päiväys',
	'uploadwindow' => 'Tallennusikkuna',
	'sf_deletionlog' => 'Poistoloki',
	'sf-preview-header' => 'Lomakkeen esikatselu',
	'sf-preview-note' => 'Lomake näyttää tällaiselta, kun sitä käytetään:',
	'sf-pageschemas-pagenameformula' => 'Sivun nimen muodostamistapa:',
	'sf-pageschemas-createtitle' => 'Lomakkeen otsikko uusilla sivuilla:',
	'sf-pageschemas-edittitle' => 'Lomakkeen otsikko nykyisillä sivuilla:',
	'sf-pageschemas-inputtype' => 'Syötetyyppi (jätä tyhjäksi asettaaksesi oletuksen):',
	'sf_property_isproperty' => 'Tämä on ominaisuus, jonka tyyppi on $1.',
	'sf_property_linkstoform' => 'Se linkittää sivuille, jotka käyttävät lomaketta $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Sallittu arvo tälle ominaisuudelle on|Sallitut arvot tälle ominaisuudelle ovat}}:',
	'sf_template_docu' => 'Tämä on malline $1. Sitä käytetään seuraavasti:',
	'sf_template_docufooter' => 'Muokkaa tätä sivua, jos haluat nähdä mallineen tekstin.',
	'sf_form_docu' => 'Tämä on lomake $1.
Jos haluat luoda sivun, jossa on tämä lomake, kirjoita sivun nimi alle.
Jos sivu on jo olemassa, sinut ohjataan lomakkeelle, jolla voi muokata kyseistä sivua.',
	'sf_form_freetextlabel' => 'Vapaamuotoinen teksti',
	'sf_category_hasdefaultform' => 'Tämä luokka käyttää lomaketta $1.',
	'sf_category_desc' => 'Tämä on luokka $1.',
	'sf_blank_namespace' => 'Päänimiavaruus',
	'right-viewedittab' => 'Nähdä ”Muokkaa”-välilehteä lomakkeella muokattavilla sivuilla', # Fuzzy
	'right-editrestrictedfields' => 'Muokata rajoitettuja lomakekenttiä',
	'right-createclass' => 'Luoda uusia semanttisia luokkia',
	'action-createclass' => 'luoda uusia semanttisia luokkia',
	'action-editrestrictedfields' => 'muokata rajoitettuja lomakekenttiä',
	'action-viewedittab' => 'nähdä ”Muokkaa”-välilehteä lomakkeella muokattavilla sivuilla', # Fuzzy
);

/** Faroese (føroyskt)
 * @author Diupwijk
 */
$messages['fo'] = array(
	'templates' => 'Fyrimyndir',
);

/** French (français)
 * @author Crochet.david
 * @author Dereckson
 * @author Erkethan
 * @author Gomoko
 * @author Grondin
 * @author Hashar
 * @author IAlex
 * @author McDutchie
 * @author Peter17
 * @author PieRRoMaN
 * @author Sherbrooke
 * @author Urhixidur
 * @author Verdy p
 * @author Wyz
 * @author Zebulon84
 */
$messages['fr'] = array(
	'semanticforms-desc' => 'Formulaires pour ajouter ou modifier des données sémantiques',
	'specialpages-group-sf_group' => 'Formulaires sémantiques',
	'createproperty' => 'Définir une propriété',
	'sf-createproperty-with-name' => 'Créer la propriété :$1',
	'sf_createproperty_linktoform' => 'Cette propriété liera vers les pages utilisant le formulaire :',
	'sf_createproperty_allowedvalsinput' => 'Si vous voulez restreindre ce champ à certaines valeurs, entrez la liste des valeurs permises séparées par des virgules (si une valeur contient une virgule, utilisez « \\, ») :',
	'sf_createproperty_propname' => 'Nom de la propriété :',
	'sf_createproperty_proptype' => 'Type :',
	'templates' => 'Modèles',
	'sf_templates_docu' => 'Les modèles suivants existent dans le wiki.',
	'sf_templates_definescat' => 'définit la catégorie : $1',
	'createtemplate' => 'Créer un modèle',
	'sf-createtemplate-with-name' => 'Créer le modèle :$1',
	'sf_createtemplate_namelabel' => 'Nom de modèle :',
	'sf_createtemplate_multipleinstance' => 'Ce modèle peut être inclus plusieurs fois dans la page.',
	'sf_createtemplate_categorylabel' => 'Catégorie définie par ce modèle (facultatif) :',
	'sf_createtemplate_templatefields' => 'Champs de modèle',
	'sf_createtemplate_fieldsdesc' => 'Pour un modèle qui n’utilise aucun nom pour les champs, remplacez simplement les noms de champs par leurs indices (exemples : 1, 2, 3, etc.).',
	'sf_createtemplate_fieldname' => 'Nom du champ :',
	'sf_createtemplate_displaylabel' => 'Étiquette pour l’affichage :',
	'sf_createtemplate_semanticproperty' => 'Propriété sémantique :',
	'sf_createtemplate_fieldislist' => 'Ce champ peut contenir une liste de valeurs séparées par des virgules.',
	'sf_createtemplate_aggregation' => 'Agrégation',
	'sf_createtemplate_aggregationdesc' => 'Pour lister, sur chaque page utilisant ce modèle, toutes celles qui ont une propriété pointant vers celle-ci, indiquez la propriété adéquate ci-dessous :',
	'sf_createtemplate_aggregationlabel' => 'Titre pour la liste :',
	'sf_createtemplate_outputformat' => 'Format de sortie :',
	'sf_createtemplate_standardformat' => 'Tableau',
	'sf_createtemplate_infoboxformat' => 'Infobox latérale',
	'sf_createtemplate_plainformat' => 'Texte brut',
	'sf_createtemplate_sectionsformat' => 'Sections',
	'sf_createtemplate_addfield' => 'Ajouter un champ',
	'sf_createtemplate_deletefield' => 'Supprimer',
	'sf_createtemplate_addtemplatebeforesave' => 'Vous devez ajouter au moins un modèle à ce formulaire avant de pouvoir le sauvegarder.',
	'forms' => 'Formulaires',
	'sf_forms_docu' => 'Les formulaires suivants existent dans le wiki.',
	'sf_forminputs_mandatory' => 'Obligatoire',
	'sf_forminputs_restricted' => 'Seuls les administrateurs peuvent modifier cette entrée',
	'sf_forminputs_class' => "L'attribut « classe » pour cette entrée",
	'sf_forminputs_default' => 'La valeur par défaut pour cette entrée',
	'sf_forminputs_preload' => 'Une page wiki dont le contenu sera la valeur par défaut de cette entrée',
	'sf_forminputs_property' => 'Une propriété sémantique à laquelle ce champ fait référence',
	'sf_forminputs_size' => 'La taille de ce champ de texte, en caractères',
	'sf_forminputs_maxlength' => 'La longueur de texte maximale autorisée pour ce champ',
	'sf_forminputs_placeholder' => "Texte d'aide qui apparaît dans l'entrée jusqu'à ce que l'utilisateur clique dessus",
	'sf_forminputs_uploadable' => 'Placer un lien "{{int:upload}}" à côté de cette entrée',
	'sf_forminputs_defaultfilename' => 'Le nom de fichier par défaut pour les fichiers téléchargés',
	'sf_forminputs_rows' => 'Le nombre de lignes pour cette entrée.',
	'sf_forminputs_cols' => 'Le nombre de colonnes pour cette entrée.',
	'sf_forminputs_autogrow' => "Autoriser cette entrée à s'agrandir si la longueur du texte dépasse les limites",
	'sf_forminputs_valuesfromproperty' => 'Une propriété dont les valeurs dans ce wiki devraient être l’ensemble des valeurs de cette entrée',
	'sf_forminputs_valuesfromcategory' => "Une catégorie dont les pages devraient être l'ensemble des valeurs de cette entrée",
	'sf_forminputs_valuesfromnamespace' => "Un espace de noms dont les pages devraient être l'ensemble des valeurs de cette entrée",
	'sf_forminputs_valuesfromconcept' => "Une page « concept » de Semantic MediaWiki dont les pages devraient êtres l'ensemble des valeurs de cette entrée",
	'sf_forminputs_valuesfromurl' => "Une URL contenant des données structurées qui devraient être l'ensemble des valeurs de cette entrée",
	'sf_forminputs_values' => "L'ensemble des valeurs pour cette entrée, séparées par des virgules",
	'sf_forminputs_list' => 'Marquer cette entrée comme tenant une liste de valeurs',
	'sf_forminputs_delimiter' => 'Le séparateur entre les valeurs du champ, si cette entrée tient une liste de valeurs',
	'sf_forminputs_remoteautocompletion' => 'Utiliser la complétion automatique à distance',
	'sf_forminputs_existingvaluesonly' => "N'autoriser que les valeurs déjà dans la liste",
	'sf_forminputs_showonselect' => 'Éléments de page à afficher uniquement si certaines valeurs sont sélectionnées (par exemple: « valeur1=>div1;valeur2=>div2 »)',
	'sf_forminputs_listboxsize' => 'La hauteur de cette zone de liste, en nombre de lignes',
	'sf_forminputs_includetimezone' => 'Ajouter un champ pour le fuseau horaire',
	'sf_forminputs_topcategory' => 'La catégorie parente de cet ensemble de catégories (obligatoire)',
	'sf_forminputs_hideroot' => 'Masquer la catégorie parente',
	'sf_forminputs_depth' => 'Le nombre de niveaux de catégorie à montrer au départ',
	'sf_forminputs_height' => 'La hauteur de cette entrée, en pixels',
	'sf_forminputs_width' => 'La largeur de cette entrée, en pixels',
	'createform' => 'Créer un formulaire',
	'sf-createform-with-name' => 'Créer le formulaire :$1',
	'sf_createform_nameinput' => 'Nom de formulaire',
	'sf_createform_nameinputdesc' => '(le nom du formulaire est généralement le même que son modèle principal) :',
	'sf_createform_template' => 'Modèle :',
	'sf_createform_templatelabelinput' => 'Étiquette de modèle (facultatif) :',
	'sf_createform_allowmultiple' => 'Permettre plusieurs (ou zéro) instances de ce modèle dans la page créée',
	'sf_createform_field' => 'Champ :',
	'sf_createform_fieldprop' => 'Ce champ définit la propriété $1, de type $2.',
	'sf_createform_fieldproplist' => 'Ce champ définit une liste des éléments qui ont la propriété $1, de type $2.',
	'sf_createform_fieldpropunknowntype' => 'Ce champ définit la propriété $1, de type indéterminé.',
	'sf_createform_inputtype' => 'Type d’entrée :',
	'sf_createform_inputtypedefault' => '(par défaut)',
	'sf_createform_formlabel' => 'Étiquette dans le formulaire :',
	'sf_createform_hidden' => 'Masqué',
	'sf_createform_removetemplate' => 'Enlever ce modèle',
	'sf_createform_addtemplate' => 'Ajouter un modèle :',
	'sf_createform_beforetemplate' => 'Avant le modèle :',
	'sf_createform_atend' => 'À la fin',
	'sf_createform_add' => 'Ajouter',
	'sf_createform_choosefield' => 'Choisissez un champ à ajouter',
	'createcategory' => 'Créer une catégorie',
	'sf-createcategory-with-name' => 'Créer la catégorie : $1',
	'sf_createcategory_name' => 'Nom de la catégorie :',
	'sf_createcategory_defaultform' => 'Formulaire par défaut :',
	'sf_createcategory_makesubcategory' => 'Crée une sous-catégorie d’une autre catégorie (facultatif) :',
	'createclass' => 'Créer une classe',
	'sf_createclass_docu' => 'Spécifiez ici les données servant à créer les propriétés, modèle, formulaire et catégorie d’une classe. Pour plus d’options, utilisez plutôt les pages $1.',
	'sf_createclass_allowedvalues' => 'Valeurs autorisées :',
	'sf_createclass_listofvalues' => 'Liste de valeurs ?',
	'sf_createclass_nameinput' => 'Nom du formulaire :',
	'sf_createclass_missingvalues' => 'Les champs obligatoires n’ont pas tous été remplis.',
	'sf_createclass_success' => 'Les propriétés, modèle, formulaire et catégorie seront créés.',
	'sf_createclass_create' => 'Créer',
	'formstart' => 'Ajouter une page avec un formulaire',
	'sf_formstart_badform' => 'Erreur : aucune page de formulaire n’a été trouvée sur $1.',
	'sf_formstart_badtitle' => 'Erreur : « $1 » est un titre de page invalide.',
	'sf_formstart_docu' => 'Entrez ici le nom de la page destinée à être modifiée avec le formulaire « $1 ». Si cette page existe déjà, vous serez dirigé vers le formulaire afin de le modifier. Dans le cas contraire, vous serez redirigé vers celui permettant de l’ajouter.',
	'sf_formstart_noform_docu' => 'Entrez ici le nom de la page, puis sélectionnez le formulaire qui servira à la modifier. Si cette page existe déjà, vous serez dirigé vers le formulaire afin de le modifier. Dans le cas contraire, vous serez redirigé vers celui permettant de l’ajouter.',
	'sf_formstart_createoredit' => 'Créer ou modifier',
	'formedit' => 'Modifier avec formulaire',
	'sf_formedit_createtitle' => 'Créer $1 : $2',
	'sf_formedit_createtitlenotarget' => 'Créer $1',
	'sf_formedit_badurl' => 'Ceci est la page pour modifier les données en utilisant un formulaire. Il faut indiquer un nom de formulaire et une page cible dans l’URL ;
l’URL doit ressembler à « Special:FormEdit?form=<nom de formulaire>&target=<nom de page cible> » ou « Special:FormEdit/<nom de formulaire>/<nom de page cible> ».',
	'sf_formedit_altforms' => 'Vous pouvez, à la place, ajouter cette page avec l’un des formulaires suivants :',
	'sf_formedit_altformsonly' => 'Vous êtes prié{{GENDER:||e|(e)}} de sélectionner l’un des formulaires suivants pour ajouter cette page :',
	'sf_formcreate' => 'Créer avec un formulaire',
	'sf_viewform' => 'Voir le formulaire',
	'sf_editsource' => 'Modifier la source',
	'sf_formedit_edittitle' => 'Modifier $1 : $2',
	'sf_formedit_morethanoneform' => 'Avertissement : Plus d’un formulaire par défaut est spécifié pour cette page.',
	'sf_formedit_formwarning' => 'Attention : cette page <a href="$1">existe déjà</a>, mais elle n’utilise pas ce formulaire.',
	'sf_formedit_mismatchedbrackets' => 'Attention: Cette page contient des crochets ou des accolades qui ne sont pas fermés; la page ne sera donc pas affichée correctement par le formulaire. Veuillez <a href="$1">corriger l\'erreur dans le texte de la source</a> avant de poursuivre.',
	'sf_formedit_remove' => 'Enlever cette instance',
	'sf_formedit_addanotherabove' => 'Ajouter une autre instance au-dessus de celle-ci',
	'sf_formedit_addanother' => 'Ajouter une autre',
	'sf_formedit_none' => 'Aucune',
	'sf_formedit_emptytitle' => 'Erreur : les données insérées entraînent un titre de page vide.',
	'sf_formedit_hookerror' => 'Erreur : Une extension de MediaWiki a empêché la modification de la page cible.',
	'sf_formedit_saveandcontinueediting' => 'Sauvegarder et continuer',
	'sf_formedit_saveandcontinue_summary' => 'Enregistré en utilisant le bouton "$1" du formulaire',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Sauvegarder les données et continuer la modification',
	'sf_autoedit_anoneditwarning' => 'Attention : vous n’êtes pas identifié(e). Votre adresse IP sera enregistrée dans l’historique des modifications de cette page.',
	'sf_autoedit_success' => '[[$1]] modifié avec succès en utilisant le formulaire $2.',
	'sf_autoedit_fail' => 'La modification de [[$1]] a échoué.',
	'sf_autoedit_notargetspecified' => 'Aucune page cible spécifiée.',
	'sf_autoedit_invalidtargetspecified' => "La page cible spécifiée $1 n'est pas valide.",
	'sf_autoedit_invalidform' => "$1 n'est pas un formulaire valide.",
	'sf_autoedit_redirectlimitexeeded' => 'La limite de redirections maximale pour le formulaire $1 a été dépassée.',
	'sf_autoedit_invalidredirecttarget' => '$1 est un lien de redirection non valide pour le formulaire $2.',
	'sf_autoedit_invalidpreloadspecified' => "La page de préchargement spécifiée $1 n'est pas valide.",
	'sf_autoedit_redlinkexists' => '$1 existe déjà.',
	'sf_autoedit_noformfound' => 'Pas de formulaire spécifié.',
	'sf_autoedit_toomanyformsfound' => "Plus d'un formulaire est disponible pour la page.",
	'sf_autoedit_readonly' => 'La base de données est actuellement verrouillé pour modifications. Motif: $1',
	'sf_autoedit_nosemanticform' => "Impossible d'obtenir le formulaire $2 pour la page $1. Voyez [[{{#special:FormEdit}}/$2/$1]] pour plus de détails.",
	'sf_autoedit_summary' => 'Modifié automatiquement depuis la page $1.',
	'sf-autoedit-wait' => 'Patientez...',
	'runquery' => 'Exécuter la requête',
	'sf_runquery_badurl' => 'Vous devez spécifier un nom de formulaire dans l’URL ;
quelque chose comme « Special:RunQuery/<nom du formulaire> ».',
	'sf_runquery_title' => 'Exécuter la requête : $1',
	'sf_runquery_additionalquery' => 'Requête additionnelle',
	'sf_formerrors_header' => 'Il y a certaines erreurs dans le formulaire. Cf. ci-dessous.',
	'sf_blank_error' => 'ne peut pas être blanc',
	'sf_bad_url_error' => 'doit avoir un format URL correct, commençant par « http »',
	'sf_bad_email_error' => 'doit avoir un format correct d’adresse courriel.',
	'sf_bad_number_error' => 'doit être un nombre valide',
	'sf_bad_date_error' => 'doit être une date valide',
	'uploadwindow' => 'Fenêtre de téléversement',
	'sf_deletionlog' => 'Historique des suppressions',
	'sf-preview-header' => 'Aperçu du formulaire',
	'sf-preview-note' => 'Voilà à qui ressemblera le formulaire une fois utilisé:',
	'sf-pageschemas-pagenameformula' => 'Formule du nom de page:',
	'sf-pageschemas-createtitle' => 'Titre du formulaire pour les nouvelles pages:',
	'sf-pageschemas-edittitle' => 'Titre du formulaire pour les pages existantes:',
	'sf-pageschemas-inputtype' => "Type d'entrée (laissez-le à blanc pour la valeur par défaut):",
	'sf_property_isproperty' => 'Cette propriété est de type $1.',
	'sf_property_linkstoform' => 'Elle pointe sur les pages utilisant le formulaire $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|La valeur autorisée pour cette propriété est|Les valeurs autorisées pour cette propriété sont}} :',
	'sf_template_docu' => 'Ceci est le modèle « $1 ». Il devrait être appelé selon le format suivant :',
	'sf_template_docufooter' => 'Modifier la page pour voir le texte du modèle.',
	'sf_form_docu' => 'Ceci est le formulaire « $1 ».
Pour créer une page avec ce formulaire, entrez le nom de la page ci-dessous ;
si une page avec ce nom existe déjà, vous serez dirigé vers un formulaire pour l’éditer.',
	'sf_form_freetextlabel' => 'Texte libre',
	'sf_category_hasdefaultform' => 'Cette catégorie utilise le formulaire « $1 ».',
	'sf_category_desc' => 'Ceci est la catégorie « $1 ».',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Voir l’onglet "{{int:edit}}" pour les pages modifiables via un formulaire',
	'right-editrestrictedfields' => 'Modifier les champs restreints des formulaires',
	'right-createclass' => 'Créer de nouvelles classes sémantiques',
	'action-createclass' => 'créer de nouvelles classes sémantiques',
	'action-editrestrictedfields' => 'Modifier les champs de formulaire protégés',
	'action-viewedittab' => 'voir l’onglet "{{int:edit}}" pour les pages modifiables via un formulaire',
);

/** Franco-Provençal (arpetan)
 * @author Cedric31
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'specialpages-group-sf_group' => 'Formulèros sèmanticos',
	'createproperty' => 'Fâre una propriètât',
	'sf-createproperty-with-name' => 'Fâre la propriètât : $1',
	'sf_createproperty_propname' => 'Nom de la propriètât :',
	'sf_createproperty_proptype' => 'Tipo :',
	'templates' => 'Modèlos',
	'sf_templates_docu' => 'Cetos modèlos ègzistont dens lo vouiqui.',
	'sf_templates_definescat' => 'dèfenét la catègorie : $1',
	'createtemplate' => 'Fâre un modèlo',
	'sf-createtemplate-with-name' => 'Fâre lo modèlo : $1',
	'sf_createtemplate_namelabel' => 'Nom du modèlo :',
	'sf_createtemplate_categorylabel' => 'Catègorie dèfenia per lo modèlo (u chouèx) :',
	'sf_createtemplate_templatefields' => 'Champs de modèlo',
	'sf_createtemplate_fieldname' => 'Nom du champ :',
	'sf_createtemplate_displaylabel' => 'Ètiquèta por la visualisacion :',
	'sf_createtemplate_semanticproperty' => 'Propriètât sèmantica :',
	'sf_createtemplate_aggregation' => 'Agrègacion',
	'sf_createtemplate_aggregationlabel' => 'Titro por la lista :',
	'sf_createtemplate_outputformat' => 'Format de sortia :',
	'sf_createtemplate_standardformat' => 'Grelye',
	'sf_createtemplate_infoboxformat' => 'Enfocajon de fllanc',
	'sf_createtemplate_plainformat' => 'Tèxto bruto',
	'sf_createtemplate_sectionsformat' => 'Sèccions',
	'sf_createtemplate_addfield' => 'Apondre un champ',
	'sf_createtemplate_deletefield' => 'Suprimar',
	'forms' => 'Formulèros',
	'sf_forms_docu' => 'Cetos formulèros ègzistont dens lo vouiqui.',
	'sf_forminputs_mandatory' => 'Oblegatouèro',
	'sf_forminputs_restricted' => 'Solament los administrators lo pôvont changiér',
	'sf_forminputs_rows' => 'Lo nombro de legnes por cela entrâ',
	'sf_forminputs_cols' => 'Lo nombro de colones por cela entrâ',
	'sf_forminputs_height' => 'La hôtior de cela entrâ, en pixèls',
	'sf_forminputs_width' => 'La largior de cela entrâ, en pixèls',
	'createform' => 'Fâre un formulèro',
	'sf-createform-with-name' => 'Fâre lo formulèro : $1',
	'sf_createform_nameinput' => 'Nom de formulèro',
	'sf_createform_template' => 'Modèlo :',
	'sf_createform_templatelabelinput' => 'Ètiquèta de modèlo (u chouèx) :',
	'sf_createform_field' => 'Champ :',
	'sf_createform_inputtype' => 'Tipo d’entrâ :',
	'sf_createform_inputtypedefault' => '(per dèfôt)',
	'sf_createform_formlabel' => 'Ètiquèta dens lo formulèro :',
	'sf_createform_hidden' => 'Cachiê',
	'sf_createform_removetemplate' => 'Enlevar lo modèlo',
	'sf_createform_addtemplate' => 'Apondre un modèlo :',
	'sf_createform_beforetemplate' => 'Devant lo modèlo :',
	'sf_createform_atend' => 'A la fin',
	'sf_createform_add' => 'Apondre',
	'sf_createform_choosefield' => 'Chouèsésséd un champ a apondre',
	'createcategory' => 'Fâre una catègorie',
	'sf-createcategory-with-name' => 'Fâre la catègorie : $1',
	'sf_createcategory_name' => 'Nom de la catègorie :',
	'sf_createcategory_defaultform' => 'Formulèro per dèfôt :',
	'createclass' => 'Fâre una cllâsse',
	'sf_createclass_allowedvalues' => 'Valors ôtorisâs :',
	'sf_createclass_listofvalues' => 'Lista de valors ?',
	'sf_createclass_nameinput' => 'Nom du formulèro :',
	'sf_createclass_create' => 'Fâre',
	'formstart' => 'Apondre una pâge avouéc un formulèro',
	'sf_formstart_createoredit' => 'Fâre ou ben changiér',
	'formedit' => 'Changiér avouéc un formulèro',
	'sf_formedit_createtitle' => 'Fâre $1 : $2',
	'sf_formedit_createtitlenotarget' => 'Fâre $1',
	'sf_formcreate' => 'Fâre avouéc un formulèro',
	'sf_viewform' => 'Vêre lo formulèro',
	'sf_editsource' => 'Changiér la sôrsa',
	'sf_formedit_edittitle' => 'Changiér $1 : $2',
	'sf_formedit_remove' => 'Enlevar',
	'sf_formedit_addanother' => 'Apondre una ôtra',
	'sf_formedit_none' => 'Niona',
	'sf_formedit_saveandcontinueediting' => 'Sôvar et pués continuar',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Sôvar les balyês et pués continuar lo changement',
	'sf_autoedit_success' => '[[$1]] changiê avouéc reusséta en utilisent lo formulèro $2.',
	'sf_autoedit_notargetspecified' => 'Gins de pâge ciba spècefiâ.',
	'sf_autoedit_noformfound' => 'Gins de formulèro spècefiâ.',
	'sf-autoedit-wait' => 'Pacientâd...',
	'runquery' => 'Ègzécutar la requéta',
	'sf_runquery_title' => 'Ègzécutar la requéta : $1',
	'sf_runquery_additionalquery' => 'Requéta de ples',
	'sf_blank_error' => 'pôt pas étre vouedo',
	'sf_bad_number_error' => 'dêt étre un nombro valido',
	'sf_bad_date_error' => 'dêt étre una dâta valida',
	'uploadwindow' => 'Fenétra de tèlèchargement',
	'sf_deletionlog' => 'Jornal de les suprèssions',
	'sf-pageschemas-pagenameformula' => 'Formula du nom de pâge :',
	'sf_property_isproperty' => 'Ceta propriètât est de tipo « $1 ».',
	'sf_form_freetextlabel' => 'Tèxto libro',
	'sf_category_hasdefaultform' => 'Ceta catègorie utilise lo formulèro « $1 ».',
	'sf_category_desc' => 'O est la catègorie « $1 ».',
	'sf_blank_namespace' => 'Principâl',
	'right-editrestrictedfields' => 'Changiér los champs rètrents des formulèros',
);

/** Western Frisian (Frysk)
 * @author Snakesteuben
 */
$messages['fy'] = array(
	'sf_createtemplate_standardformat' => 'Standert', # Fuzzy
	'sf_createtemplate_deletefield' => 'Wiskje',
	'sf_createform_inputtypedefault' => '(standert)',
	'sf_createform_add' => 'Tafoegje',
	'sf_formedit_none' => 'Gjin',
);

/** Irish (Gaeilge)
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'sf_createproperty_proptype' => 'Saghas:',
	'sf_createtemplate_deletefield' => 'Scrios',
	'sf_createform_template' => 'Teimpléad:',
	'sf_createclass_create' => 'Cruthaigh',
	'sf_formedit_none' => 'Tada',
);

/** Galician (galego)
 * @author Alma
 * @author McDutchie
 * @author Toliño
 * @author Xosé
 */
$messages['gl'] = array(
	'semanticforms-desc' => 'Formularios para engadir e editar datos semánticos',
	'specialpages-group-sf_group' => 'Formularios semánticos',
	'createproperty' => 'Crear unha propiedade',
	'sf-createproperty-with-name' => 'Crear a propiedade: $1',
	'sf_createproperty_linktoform' => 'Esta propiedade ligará ás páxinas que usan o formulario:',
	'sf_createproperty_allowedvalsinput' => 'Se quere que esta propiedade só teña permitidos determinados valores, introduza a lista de valores permitidos separados por comas (se un valor contén unha coma substitúaa por "\\,"):',
	'sf_createproperty_propname' => 'Nome da propiedade:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Modelos',
	'sf_templates_docu' => 'Os seguintes modelos existen neste wiki.',
	'sf_templates_definescat' => 'define a categoría: $1',
	'createtemplate' => 'Crear un modelo',
	'sf-createtemplate-with-name' => 'Crear o modelo: $1',
	'sf_createtemplate_namelabel' => 'Nome do modelo:',
	'sf_createtemplate_multipleinstance' => 'Este modelo pódese incluír varias veces na páxina.',
	'sf_createtemplate_categorylabel' => 'Categoría definida polo modelo (opcional):',
	'sf_createtemplate_templatefields' => 'Modelo dos campos',
	'sf_createtemplate_fieldsdesc' => 'Para facer que os campos deste modelo non requiran xa nomes de campo, simplemente introduza o índice de cada campo (p. ex. 1, 2, 3, etc.) como nome, no canto dun nome real.',
	'sf_createtemplate_fieldname' => 'Nome do campo:',
	'sf_createtemplate_displaylabel' => 'Mostrar a etiqueta:',
	'sf_createtemplate_semanticproperty' => 'Propiedade semántica:',
	'sf_createtemplate_fieldislist' => 'Este campo pode conter unha lista de valores separados por vírgulas',
	'sf_createtemplate_aggregation' => 'Agregación',
	'sf_createtemplate_aggregationdesc' => 'Para listar, en calquera páxina que use este modelo, todas as páxinas que teñen unha propiedade determinada que apunte cara a ela, especifique a propiedade apropiada a continuación:',
	'sf_createtemplate_aggregationlabel' => 'Título para a lista:',
	'sf_createtemplate_outputformat' => 'Formato de saída:',
	'sf_createtemplate_standardformat' => 'Táboa',
	'sf_createtemplate_infoboxformat' => 'Caixa de información lateral',
	'sf_createtemplate_plainformat' => 'Texto simple',
	'sf_createtemplate_sectionsformat' => 'Seccións',
	'sf_createtemplate_addfield' => 'Engadir un campo',
	'sf_createtemplate_deletefield' => 'Borrar',
	'sf_createtemplate_addtemplatebeforesave' => 'Ten que engadir un modelo polo menos a este formulario antes de podelo gardar.',
	'forms' => 'Formularios',
	'sf_forms_docu' => 'Os seguintes formularios existen neste wiki.',
	'sf_forminputs_mandatory' => 'Obrigatorio',
	'sf_forminputs_restricted' => 'Só os administradores poden modificar esta entrada',
	'sf_forminputs_class' => 'O atributo "class" HTML para esta entrada',
	'sf_forminputs_default' => 'O valor por defecto para esta entrada',
	'sf_forminputs_preload' => 'Unha páxina wiki cuxos contidos serán o valor por defecto desta entrada',
	'sf_forminputs_property' => 'Unha propiedade semántica á que este campo corresponde',
	'sf_forminputs_size' => 'O tamaño deste campo de texto, en caracteres',
	'sf_forminputs_maxlength' => 'A lonxitude de texto máxima permitida neste campo',
	'sf_forminputs_placeholder' => 'Texto de axuda que aparece na entrada ata que o usuario fai clic sobre el',
	'sf_forminputs_uploadable' => 'Colocar unha ligazón "{{int:upload}}" ao carón desta entrada',
	'sf_forminputs_defaultfilename' => 'O nome de ficheiro por defecto para os ficheiros cargados',
	'sf_forminputs_rows' => 'O número de liñas para esta entrada',
	'sf_forminputs_cols' => 'O número de columnas para esta entrada',
	'sf_forminputs_autogrow' => 'Defina esta entrada para que medre en tamaño se o texto supera os límites',
	'sf_forminputs_valuesfromproperty' => 'Unha propiedade cuxos valores no wiki deben ser o conxunto de valores desta entrada',
	'sf_forminputs_valuesfromcategory' => 'Unha categoría cuxas páxinas deben ser o conxunto de valores desta entrada',
	'sf_forminputs_valuesfromnamespace' => 'Un espazo de nomes cuxas páxinas deben ser o conxunto de valores desta entrada',
	'sf_forminputs_valuesfromconcept' => 'Unha páxina de "concepto" de Semantic MediaWiki cuxas páxinas deben ser o conxunto de valores desta entrada',
	'sf_forminputs_valuesfromurl' => 'Un enderezo URL que contén datos estruturados que deben ser o conxunto de valores desta entrada',
	'sf_forminputs_values' => 'O conxunto de valores para esta entrada, separados por comas',
	'sf_forminputs_list' => 'Marcar esta entrada como que ten unha lista de valores',
	'sf_forminputs_delimiter' => 'O delimitador entre os valores do campo, se esta entrada ten unha lista de valores',
	'sf_forminputs_remoteautocompletion' => 'Empregar o completado automático remoto',
	'sf_forminputs_existingvaluesonly' => 'Permitir soamente os valores que xa estean na lista',
	'sf_forminputs_showonselect' => 'Elementos da páxina que mostrar se só se seleccionan algúns valores determinados (por exemplo: "valor1=>div1;valor2=>div2")',
	'sf_forminputs_listboxsize' => 'A altura desta caixa de listas, en liñas',
	'sf_forminputs_includetimezone' => 'Incluír unha entrada para a zona horaria',
	'sf_forminputs_topcategory' => 'A categoría nai deste conxunto de categorías (obrigatorio)',
	'sf_forminputs_hideroot' => 'Agochar a categoría raíz',
	'sf_forminputs_depth' => 'O número de niveis de categorías que mostrar inicialmente',
	'sf_forminputs_height' => 'A altura desta entrada, en píxeles',
	'sf_forminputs_width' => 'O largo desta entrada, en píxeles',
	'createform' => 'Crear un formulario',
	'sf-createform-with-name' => 'Crear o formulario: $1',
	'sf_createform_nameinput' => 'Nome do formulario',
	'sf_createform_nameinputdesc' => '(normalmente, o formulario recibe o mesmo nome ca o seu modelo principal):',
	'sf_createform_template' => 'Modelo:',
	'sf_createform_templatelabelinput' => 'Etiqueta do modelo (opcional):',
	'sf_createform_allowmultiple' => 'Permitir varias instancias (ou cero) deste modelo na páxina creada',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Este campo define a propiedade $1, de clase $2.',
	'sf_createform_fieldproplist' => 'Este campo define unha lista dos elementos que teñen a propiedade $1, da clase $2.',
	'sf_createform_fieldpropunknowntype' => 'Este campo define a propiedade $1, de clase non especificada.',
	'sf_createform_inputtype' => 'Tipo de entrada:',
	'sf_createform_inputtypedefault' => '(por omisión)',
	'sf_createform_formlabel' => 'Etiqueta de formulario:',
	'sf_createform_hidden' => 'Agochado',
	'sf_createform_removetemplate' => 'Eliminar un modelo',
	'sf_createform_addtemplate' => 'Engadir o modelo:',
	'sf_createform_beforetemplate' => 'Antes do modelo:',
	'sf_createform_atend' => 'Ao final',
	'sf_createform_add' => 'Engadir',
	'sf_createform_choosefield' => 'Elixa un campo para engadir',
	'createcategory' => 'Crear unha categoría',
	'sf-createcategory-with-name' => 'Crear a categoría: $1',
	'sf_createcategory_name' => 'Nome da categoría:',
	'sf_createcategory_defaultform' => 'Formulario predefinido:',
	'sf_createcategory_makesubcategory' => 'Facer unha subcategoría doutra categoría (opcional):',
	'createclass' => 'Crear unha clase',
	'sf_createclass_docu' => 'Insira todos os datos aquí para crear as propiedades, o modelo, o formulario e a categoría para unha única clase. Para ollar máis opcións, use as páxinas $1 no canto desta.',
	'sf_createclass_allowedvalues' => 'Valores permitidos:',
	'sf_createclass_listofvalues' => 'Lista de valores?',
	'sf_createclass_nameinput' => 'Nome do formulario:',
	'sf_createclass_missingvalues' => 'Non todos os campos obrigatorios foron enchidos.',
	'sf_createclass_success' => 'As propiedades, o modelo, o formulario e a categoría serán creados.',
	'sf_createclass_create' => 'Crear',
	'formstart' => 'Engadir unha páxina con formulario',
	'sf_formstart_badform' => 'Erro: Non se atopou ningún formulario na páxina "$1".',
	'sf_formstart_badtitle' => 'Erro: "$1" é un título incorrecto para unha páxina.',
	'sf_formstart_docu' => 'Introduza aquí o nome da páxina que se editará co formulario "$1". Se esta páxina xa existise, enviaráselle ao formulario para editar esa páxina. De non ser así, enviaráselle ao formulario para engadir a páxina.',
	'sf_formstart_noform_docu' => 'Introduza aquí o nome da páxina e escolla o formulario co que a quere editar. Se esta páxina xa existise, enviaráselle ao formulario para editar esa páxina. De non ser así, enviaráselle ao formulario para engadir a páxina.',
	'sf_formstart_createoredit' => 'Crear ou editar',
	'formedit' => 'Editar con formulario',
	'sf_formedit_createtitle' => 'Crear $1: $2',
	'sf_formedit_createtitlenotarget' => 'Crear "$1"',
	'sf_formedit_badurl' => 'Esta é a páxina para editar cun formulario. Ten que especificar un nome de formulario e unha páxina de destino no URL;
debería ser algo así como "Special:FormEdit?form=<nome do formulario>&target=<páxina de destino>" ou  "Special:FormEdit/<nome do formulario>/<páxina de destino>".',
	'sf_formedit_altforms' => 'Vostede pode engadir esta páxina cun dos seguintes formularios:',
	'sf_formedit_altformsonly' => 'Seleccione un dos seguintes formularios para engadir esta páxina:',
	'sf_formcreate' => 'Crear cun formulario',
	'sf_viewform' => 'Ver o formulario',
	'sf_editsource' => 'Editar a fonte',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => "'''Aviso:''' Hai máis dun formulario definido por defecto para esta páxina.",
	'sf_formedit_formwarning' => 'Aviso: Esta páxina <a href="$1">xa existe</a>, pero non usa este formulario.',
	'sf_formedit_mismatchedbrackets' => 'Aviso: Esta páxina contén parénteses, corchetes ou chaves sen pechar, de modo que o formulario non manexará a páxina correctamente. <a href="$1">Arranxe o erro no texto fonte</a> antes de continuar.',
	'sf_formedit_remove' => 'Eliminar esta instancia',
	'sf_formedit_addanotherabove' => 'Engadir outra instancia por riba desta',
	'sf_formedit_addanother' => 'Engadir outro',
	'sf_formedit_none' => 'Ningún',
	'sf_formedit_emptytitle' => 'Erro: Os datos inseridos deron como resultado un título de páxina en branco.',
	'sf_formedit_hookerror' => 'Erro: Unha extensión de MediaWiki impediu a modificación da páxina de destino.',
	'sf_formedit_saveandcontinueediting' => 'Gardar e continuar',
	'sf_formedit_saveandcontinue_summary' => 'Gardado mediante o botón "$1" do formulario',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Gardar os datos e continuar a edición',
	'sf_autoedit_anoneditwarning' => 'Aviso: Non accedeu ao sistema. O seu enderezo IP quedará rexistrado no historial de revisións desta páxina.',
	'sf_autoedit_success' => 'Modificouse correctamente "[[$1]]" empregando $2.',
	'sf_autoedit_fail' => 'Erro ao modificar "[[$1]]".',
	'sf_autoedit_notargetspecified' => 'Non se especificou ningunha páxina de destino.',
	'sf_autoedit_invalidtargetspecified' => 'A páxina de destino especificada, "$1", non é válida.',
	'sf_autoedit_invalidform' => '"$1" non é un formulario válido.',
	'sf_autoedit_redirectlimitexeeded' => 'Superouse o límite máximo de redireccións para o formulario "$1".',
	'sf_autoedit_invalidredirecttarget' => '"$1" non é un destino de redirección válido para o formulario "$2".',
	'sf_autoedit_invalidpreloadspecified' => 'A páxina de precarga especificada, "$1", non é válida.',
	'sf_autoedit_redlinkexists' => '"$1" xa existe.',
	'sf_autoedit_noformfound' => 'Non se especificou ningún formulario.',
	'sf_autoedit_toomanyformsfound' => 'Hai máis dun formulario dispoñible para a páxina.',
	'sf_autoedit_readonly' => 'A base de datos está pechada ás modificacións. Motivo: $1',
	'sf_autoedit_nosemanticform' => 'Non se puido obter o formulario "$2" para a páxina "$1". Olle [[{{#special:FormEdit}}/$2/$1]] para coñecer máis detalles.',
	'sf_autoedit_summary' => 'Editado automaticamente a partir da páxina "$1".',
	'sf-autoedit-wait' => 'Agarde...',
	'runquery' => 'Executar a pescuda',
	'sf_runquery_badurl' => 'Debe especificar un nome de formulario no enderezo URL;
o URL debe ser do tipo "Special:RunQuery/<nome do formulario>".',
	'sf_runquery_title' => 'Executar a pescuda: $1',
	'sf_runquery_additionalquery' => 'Pescuda adicional',
	'sf_formerrors_header' => 'Producíronse erros na entrada do seu formulario; vexa máis abaixo',
	'sf_blank_error' => 'non poden estar en blanco',
	'sf_bad_url_error' => "debe ter un correcto formato URL, comezando con 'http'",
	'sf_bad_email_error' => 'debe ter un enderezo de correo electrónico cun formato válido',
	'sf_bad_number_error' => 'debe ser un número válido',
	'sf_bad_date_error' => 'debe ser unha data válida',
	'uploadwindow' => 'Ventá de carga',
	'sf_deletionlog' => 'Rexistro de borrados',
	'sf-preview-header' => 'Vista previa do formulario',
	'sf-preview-note' => 'Así será o formulario ao empregalo:',
	'sf-pageschemas-pagenameformula' => 'Fórmula do nome da páxina:',
	'sf-pageschemas-createtitle' => 'Título do formulario para as páxinas novas:',
	'sf-pageschemas-edittitle' => 'Título do formulario para as páxinas existentes:',
	'sf-pageschemas-inputtype' => 'Tipo de entrada (déixeo en branco para definir o predeterminado):',
	'sf_property_isproperty' => 'Esta é unha propiedade de clase $1.',
	'sf_property_linkstoform' => 'Liga con páxinas que usan o formulario $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|O valor permitido|Os valores permitidos}} para esta propiedade {{PLURAL:$1|é|son}}:',
	'sf_template_docu' => "Este é o modelo '$1'. Pode ser chamado no seguinte formato:",
	'sf_template_docufooter' => 'Editar a páxina para ver o modelo de texto.',
	'sf_form_docu' => 'Este é o formulario "$1".
Para crear unha páxina con este formulario, introduza o nome da páxina a continuación;
se xa existe unha páxina con ese nome enviaráselle a un formulario para editar esa páxina.',
	'sf_form_freetextlabel' => 'Texto libre',
	'sf_category_hasdefaultform' => 'Esta categoría usa o formulario $1.',
	'sf_category_desc' => 'Esta é a categoría $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Ver a lapela "{{int:edit}}" nas páxinas editables mediante formulario',
	'right-editrestrictedfields' => 'Editar os campos restrinxidos dos formularios',
	'right-createclass' => 'Crear novas clases semánticas',
	'action-createclass' => 'crear novas clases semánticas',
	'action-editrestrictedfields' => 'editar os campos restrinxidos dos formularios',
	'action-viewedittab' => 'ver a lapela "{{int:edit}}" nas páxinas editables mediante formulario',
);

/** Gothic (Gothic)
 * @author Crazymadlover
 * @author Jocke Pirat
 * @author Omnipaedista
 */
$messages['got'] = array(
	'sf_createtemplate_deletefield' => 'Taíran',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'specialpages-group-sf_group' => 'Σημασιολογικοὶ Τύποι',
	'createproperty' => 'Ποιεῖν ἰδιότητα τινά',
	'sf_createproperty_propname' => 'Ὄνομα ἰδιότητος:',
	'sf_createproperty_proptype' => 'Τύπος:',
	'templates' => 'Πρότυπα',
	'sf_templates_definescat' => 'ὁρίζει κατηγορίαν: $1',
	'createtemplate' => 'Ποιεῖν πρότυπόν τι',
	'sf_createtemplate_namelabel' => 'Ὄνομα προτύπου:',
	'sf_createtemplate_fieldname' => 'Ὄνομα πεδίου:',
	'sf_createtemplate_addfield' => 'Προστιθέναι πεδίον',
	'sf_createtemplate_deletefield' => 'Σβεννύναι',
	'forms' => 'Τύποι',
	'sf_forminputs_mandatory' => 'Ὑποχρεωτικόν',
	'createform' => 'Ποιεῖν τύπον τινά',
	'sf_createform_template' => 'Πρότυπον:',
	'sf_createform_field' => 'Πεδίον:',
	'sf_createform_inputtypedefault' => '(προκαθωρισμένη)',
	'sf_createform_hidden' => 'Κεκρυμμένη',
	'sf_createform_add' => 'Προστιθέναι',
	'sf_createcategory_name' => 'Ὄνομα κατηγορίας:',
	'sf_formstart_createoredit' => 'Ποιεῖν ἢ μεταγράφειν',
	'sf_formedit_createtitle' => 'Ποιεῖν $1: $2',
	'sf_viewform' => 'Ὁρᾶν τύπον',
	'sf_editsource' => 'Μεταγράφειν πηγήν',
	'sf_formedit_edittitle' => 'Μεταγράφειν $1: $2',
	'sf_formedit_remove' => 'Άφαιρεῖν',
	'sf_formedit_none' => 'Οὐδέν',
	'runquery' => 'Ἐκτελεῖν πεῦσιν',
	'sf_runquery_title' => 'Ἐκτελεῖν πεῦσιν: $1',
	'uploadwindow' => 'Ἐπιφορτίζειν θυρίδα',
	'sf_form_freetextlabel' => 'Ἐλεύθερον κείμενον',
	'sf_blank_namespace' => 'Κύριον',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'semanticforms-desc' => 'Formular fir s Yyfiege un Bearbeite vu semantische Date',
	'specialpages-group-sf_group' => 'Semantischi Formular',
	'createproperty' => 'E Attribut aalege',
	'sf_createproperty_linktoform' => 'Die Eigeschaft verwyyst uff Syte, wu des Format bruuche:',
	'sf_createproperty_allowedvalsinput' => 'Wänn Du fir des Fäld nume bstimmti Wärt witt megli mache, gib die bitte as kommatrännti Lischt yy (wänn s in eme Wärt e Komma het, ersetz des mit „\\,“):',
	'sf_createproperty_propname' => 'Eigeschaftsname:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Vorlage',
	'sf_templates_docu' => 'Die Vorlage git s uf {{SITENAME}}.',
	'sf_templates_definescat' => 'definiert Kategorii: $1',
	'createtemplate' => 'E Vorlag aalege',
	'sf_createtemplate_namelabel' => 'Vorlagename:',
	'sf_createtemplate_categorylabel' => 'Dur Vorlag definierti Kategorii (optional):',
	'sf_createtemplate_templatefields' => 'Vorlagefälder',
	'sf_createtemplate_fieldsdesc' => 'Wänn e Fäld vum ere Vorlag kei Feldname meh bruucht, gib eifach statt eme ächte Name d Indexnummere vum Fäld as Name yy (z. B. 1, 2, 3 usw.).',
	'sf_createtemplate_fieldname' => 'Fäldname:',
	'sf_createtemplate_displaylabel' => 'Fäldname aazeige:',
	'sf_createtemplate_semanticproperty' => 'Semantisch Attribut:',
	'sf_createtemplate_fieldislist' => 'In däm Fäld cha s e Lischt vu Wärt haa, wu dur Komma trännt wäre.',
	'sf_createtemplate_aggregation' => 'Zämmefassig',
	'sf_createtemplate_aggregationdesc' => 'Zum uf allene Syte, wu die Vorlag bruuche, alli Syte ufzlischte, wu ne bstimmt Attribut hän un uf die Syte verwyyse, gib s gwinscht Attribut do aa:',
	'sf_createtemplate_aggregationlabel' => 'Titel fir Lischt:',
	'sf_createtemplate_outputformat' => 'Uusgabformat:',
	'sf_createtemplate_standardformat' => 'Standard', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Infobox uf dr rächte Syte', # Fuzzy
	'sf_createtemplate_addfield' => 'Fieg Fäld yy',
	'sf_createtemplate_deletefield' => 'Lesche',
	'sf_createtemplate_addtemplatebeforesave' => 'Du muesch zmindescht ei Vorlag zue däm Formular zuefiege, voreb Du s cha spychere.',
	'forms' => 'Formular',
	'sf_forms_docu' => 'Die Formular git s in {{SITENAME}}:',
	'sf_forminputs_mandatory' => 'Pflichtfäld',
	'sf_forminputs_restricted' => 'Nume Ammanne chenne des Yygabefäld ändere',
	'sf_forminputs_class' => 'S HTML-Attribut „class“ für sell Yygabefäld',
	'sf_forminputs_default' => 'De Standardwärt für des Yygabefäld',
	'sf_forminputs_preload' => 'E Wiki-Syte, wo de Inhalt devo de Standardwärt vo däm Yygabefäld wird',
	'sf_forminputs_property' => 'E semantischs Attribut, wo des Yygabefäld entspricht',
	'sf_forminputs_size' => 'D Grössi vo däm Teggstfäld in Zeiche',
	'sf_forminputs_maxlength' => 'Di maximali Längi vo däm Teggst in däm Yygabefäld, wo zuelässig isch',
	'sf_forminputs_placeholder' => 'De Hilfeteggst, wo aazeigt wird, bis dass de Benutzer druff klickt',
	'sf_forminputs_uploadable' => 'En Link zum Uffelade vunere Datei näbe däm Yygabefäld platziere', # Fuzzy
	'sf_forminputs_defaultfilename' => 'De Standarddateiname für Dateie, wommer uffeglade het',
	'sf_forminputs_rows' => 'D Zyylezaal für des Yygabefäld',
	'sf_forminputs_cols' => 'D Spaltezaal für des Yygabefäld',
	'createform' => 'Leg e Formular aa',
	'sf_createform_nameinput' => 'Formularname',
	'sf_createform_nameinputdesc' => '(no dr Konvention wird e Formular no dr Hauptvorlag gnännt, wu s fillt):', # Fuzzy
	'sf_createform_template' => 'Vorlag:',
	'sf_createform_templatelabelinput' => 'Vorlagename (optional):',
	'sf_createform_allowmultiple' => 'Erlaub mehreri (oder null) Instanze vu däre Vorlag in dr aagleite Syte',
	'sf_createform_field' => 'Fäld:',
	'sf_createform_fieldprop' => 'Des Fäld definiert s Attribut $1 vum Typ $2.',
	'sf_createform_fieldproplist' => 'Des Fäld definiert e Lischt vu Elemänt, wu s Attribut $1 vum Typ $2 hän.',
	'sf_createform_fieldpropunknowntype' => 'Des Fäld definiert d Eigeschaft $1 mit eme nit spezifizierte Typ.',
	'sf_createform_inputtype' => 'Gib dr Typ yy:',
	'sf_createform_inputtypedefault' => '(Standardwärt)',
	'sf_createform_formlabel' => 'Formularname:',
	'sf_createform_hidden' => 'Versteckt',
	'sf_createform_removetemplate' => 'Vorlag useneh',
	'sf_createform_addtemplate' => 'Vorlag zuefiege:',
	'sf_createform_beforetemplate' => 'Vor Vorlag:',
	'sf_createform_atend' => 'Am Änd',
	'sf_createform_add' => 'Zuefiege',
	'sf_createform_choosefield' => 'Wehl e Fäld uus, wu Du iwtt zuefiege',
	'createcategory' => 'E Kategorii aalege',
	'sf_createcategory_name' => 'Kategoriename:',
	'sf_createcategory_defaultform' => 'Standardformular:',
	'sf_createcategory_makesubcategory' => 'Mach die Kategorii zuen ere Subkategorii vun ere andere Kategorii (optional):',
	'createclass' => 'E Klasse aalege',
	'sf_createclass_docu' => 'Gib do alli Date yy go d Eigeschafte, e Vorlag, e Formular un e Kategorii fir e einzelni Klasse aalege. Fir meh Megligkeite verwänd stattdem d Syte $1.',
	'sf_createclass_allowedvalues' => 'Erlaubti Wärt', # Fuzzy
	'sf_createclass_listofvalues' => 'Lischt vu Wärt', # Fuzzy
	'sf_createclass_missingvalues' => 'S sin nonig alli erforderlige Fälder uusgfillt.',
	'sf_createclass_success' => 'Eigeschafte, Vorlag, Formular und Kategorii wäre aagleit.',
	'formstart' => 'Syte mit Formular zuefiege',
	'sf_formstart_badform' => 'Fähler: s isch kei Syte gfunde wore bi $1',
	'sf_formstart_badtitle' => "Fähler: '$1' isch kei giltige Titel fir e Syte.",
	'sf_formstart_docu' => 'Gib in des Täxtfäld dr Name vu dr Syte yy, wu mit em Formular „$1“ soll bearbeitet wäre. Wänn s scho ne Syte mit däm Name het, wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch mit bearbeite. Suscht wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch mit aalege.',
	'sf_formstart_noform_docu' => 'Gib in des Täxtfäld dr Name vu dr Syte yy un wehl s Formular, wu d Syte mit soll bearbeitet wäre. Wänn s scho ne Syte mit däm Name het, wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch mit bearbeite. Suscht wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch mit aalege.',
	'sf_formstart_createoredit' => 'Aalege oder Bearbeite',
	'formedit' => 'mit Formular bearbeite',
	'sf_formedit_createtitle' => 'Leg $1: $2 aa',
	'sf_formedit_badurl' => 'Des isch d Syte zum Bearbeite mit eme Formular. Du muesch dr Name vun eme Formulars un d Ziilsyte, wu soll bearbeitet wäre, in dr URL aagee. S sott uussäh wie „Special:FormEdit?form=<Formularname>&target=<Ziilsyte>“ oder „Special:FormEdit/<Formularname>/<Ziilsyte>“.',
	'sf_formedit_altforms' => 'Du chasch die Syte au mit eim vu däne Formular aalege:',
	'sf_formedit_altformsonly' => 'Bitte wehl eis vu däne Formular uus go die Syte aalege:',
	'sf_formcreate' => 'Mit Formular aalege',
	'sf_viewform' => 'Formular aazeige',
	'sf_editsource' => 'Quälltäxt bearbeite',
	'sf_formedit_edittitle' => 'Bearbeit $1: $2',
	'sf_formedit_morethanoneform' => 'Warnig: s isch meh wie ei Standardformular definiert fir die Syte.',
	'sf_formedit_formwarning' => 'Warnig: Die Syte <a href="$1">git s scho</a>, aber si bruucht nit des Formular.',
	'sf_formedit_remove' => 'Useneh',
	'sf_formedit_addanother' => 'Wyteri zuefiege',
	'sf_formedit_none' => 'Keini',
	'runquery' => 'Abfrog starte',
	'sf_runquery_badurl' => "Du muesch e Formularname aagee in dr URL;
d URL sott eso ussäh 'Special:RunQuery/<Formularname>'.",
	'sf_runquery_title' => 'Abfrog starte: $1',
	'sf_runquery_additionalquery' => 'Zuesätzligi Abfrog',
	'sf_formerrors_header' => 'Dyy Yygab isch fählerhaft; fir meh lueg unte',
	'sf_blank_error' => 'derf nit läär syy',
	'sf_bad_url_error' => 'muess s richtig URL-Format haa, wu aafangt mit „http://“',
	'sf_bad_email_error' => 'muess e giltig E-Mail-Adrässformat haa',
	'sf_bad_number_error' => 'muess e giltigi Zahl syy',
	'sf_bad_date_error' => 'muess e giltig Datum syy',
	'uploadwindow' => 'Fänschter zum Uffelade',
	'sf_deletionlog' => 'Leschlogbuech',
	'sf_property_isproperty' => 'Des isch e Eigeschaft vum Typ $1.',
	'sf_property_linkstoform' => 'Verwyyst uff Syte, wu s Format $1 bruuche.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dr erlaubt Wärt fir die Eigeschaft isch|Di erlaubte Wärt fir die Eigeschaft sin}}:',
	'sf_template_docu' => 'Des isch d Vorlag fir „$1“. Si sott in däm Format ufgruefe wäre:',
	'sf_template_docufooter' => 'Die Syte bearbeite go dr Vorlagetäxt säh.',
	'sf_form_docu' => 'Des isch s „$1“-Formular.
Go ne Syte aalege mit däm Formular, gib dr Sytename unte yy.
Wänn s scho ne Syte mit däm Name het, wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch aalege mit.',
	'sf_form_freetextlabel' => 'Frejtäxt',
	'sf_category_hasdefaultform' => 'Die Kategorii bruucht s Formular $1.',
	'sf_category_desc' => 'Des isch d Kategorii $1.',
	'sf_blank_namespace' => 'Hauptsyte',
	'right-viewedittab' => 'D "Bearbeite"-Regischtercharte fir bearbeitbari Syte no Format aaluege', # Fuzzy
	'right-editrestrictedfields' => 'Yygschränkti Formatfälde bearbeite',
);

/** Gujarati (ગુજરાતી)
 * @author Dsvyas
 * @author KartikMistry
 */
$messages['gu'] = array(
	'sf_forminputs_mandatory' => 'ફરજિયાત',
	'sf_forminputs_restricted' => 'સંરક્ષિત (ફક્ત પ્રબંધકો જ ફેરફાર કરી શકે છે)', # Fuzzy
	'sf_createform_hidden' => 'છુપાયેલ',
	'sf_createform_removetemplate' => 'ઢાંચો દૂર કરો',
	'sf_createform_addtemplate' => 'ઢાંચો ઉમેરો:',
	'sf_createform_beforetemplate' => 'ઢાંચા પહેલા:',
	'sf_createform_atend' => 'અંતમાં',
	'sf_createform_add' => 'ઉમેરો',
	'createcategory' => 'શ્રેણીની રચના કરો',
	'sf_createcategory_name' => 'નામ', # Fuzzy
	'sf_createcategory_makesubcategory' => 'આને અન્ય શ્રેણીની ઉપશ્રેણી બનાવો (વૈકલ્પિક):',
	'formstart' => 'ફોર્મ વાળું પાનું ઉમેરો',
	'sf_blank_namespace' => 'મુખ્ય',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'sf_createproperty_propname' => 'Ennym tro:',
	'sf_createtemplate_deletefield' => 'Scryss',
	'createcategory' => 'Croo ronney',
	'sf_createcategory_name' => 'Ennym ronney:',
);

/** Hausa (Hausa)
 */
$messages['ha'] = array(
	'sf_createtemplate_deletefield' => 'Soke',
);

/** Hakka (Hak-kâ-fa)
 * @author Hakka
 */
$messages['hak'] = array(
	'sf_createtemplate_deletefield' => 'Chhù-thet',
);

/** Hawaiian (Hawai`i)
 * @author Kalani
 * @author Singularity
 */
$messages['haw'] = array(
	'sf_createproperty_propname' => 'Inoa:', # Fuzzy
	'sf_createform_inputtypedefault' => '(paʻamau)',
	'sf_createform_add' => 'Ho‘ohui',
	'sf_createcategory_name' => 'Inoa:', # Fuzzy
	'sf_formedit_remove' => 'Kāpae',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Inkbug
 * @author Rotemliss
 * @author Yaron Koren
 * @author YaronSh
 * @author חיים
 */
$messages['he'] = array(
	'semanticforms-desc' => 'טפסים להוספת ולעריכת נתונים סמנטיים',
	'specialpages-group-sf_group' => 'טפסים סמנטיים',
	'createproperty' => 'יצירת מאפיין',
	'sf_createproperty_linktoform' => 'מאפיין זה יקשר לדפים המשתמשים בטופס:',
	'sf_createproperty_allowedvalsinput' => 'אם ברצונכם שלמאפיין זה יהיו רק כמה ערכים מורשים, הזינו את רשימת הערכים המורשים, מופרדים בפסיקים (אם ערך כלשהו מכיל פסיק, החליפו אותו ב־"\\,"):',
	'sf_createproperty_propname' => 'שם המאפיין:',
	'sf_createproperty_proptype' => 'סוג:',
	'templates' => 'תבניות',
	'sf_templates_docu' => 'התבניות הבאות קיימות בוויקי הזה.',
	'sf_templates_definescat' => 'מגדיר את הקטגוריה: $1',
	'createtemplate' => 'צור תבנית',
	'sf_createtemplate_namelabel' => 'שם התבנית:',
	'sf_createtemplate_categorylabel' => 'קטגוריה מוגדרת על ידי תבנית ():',
	'sf_createtemplate_templatefields' => 'שדות התבנית',
	'sf_createtemplate_fieldsdesc' => 'כדי ששדות התבנית לא יצטרכו שמות, פשוט הכנס את האינדקס של השדה (1, 2, 3...) במקום שם אמיתי.',
	'sf_createtemplate_fieldname' => 'שם השדה:',
	'sf_createtemplate_displaylabel' => 'תוית תצוגה:',
	'sf_createtemplate_semanticproperty' => 'זה השדה הסמנטי:',
	'sf_createtemplate_fieldislist' => 'השדה יכול להכיל רשימת ערכים, המופרדים בפסיקים',
	'sf_createtemplate_aggregation' => 'מצבור',
	'sf_createtemplate_aggregationdesc' => 'כדי להציג בכל דף המשתמש בתבנית זו את כל הדפים המכילים מאפיין מסוים המצביע לדף זה, ציינו את המאפיין המתאים להלן:',
	'sf_createtemplate_aggregationlabel' => 'כותרת לרשימה:',
	'sf_createtemplate_outputformat' => 'מבנה הפלט:',
	'sf_createtemplate_standardformat' => 'טבלה',
	'sf_createtemplate_infoboxformat' => 'כיוון תיבת מידע',
	'sf_createtemplate_addfield' => 'הוספת שדה',
	'sf_createtemplate_deletefield' => 'מחיקה',
	'sf_createtemplate_addtemplatebeforesave' => 'עליכם להוסיף לפחות תבנית אחת לטופס זה לפני שתוכלו לשמור אותו.',
	'forms' => 'טפסים',
	'sf_forms_docu' => 'הטפסים הבאים קיימים בוויקי הזה.',
	'sf_forminputs_mandatory' => 'הכרחי',
	'sf_forminputs_restricted' => 'רק מפעילי מערכת יכולים לערוך את הקלט הזה',
	'sf_forminputs_class' => 'מאפיין class של HTML עבור הקלט הזה',
	'sf_forminputs_default' => 'ערך בררת מחדל עבור הקלט הזה',
	'sf_forminputs_preload' => 'דף ויקי שתוכנו יהיה ערך בררת המחדל עבור הקלט הזה',
	'sf_forminputs_property' => 'מאפיין סמנטי שהשדה הזה מתאים לו',
	'sf_forminputs_size' => 'גודל שדה הטקסט הזה, בתווים',
	'sf_forminputs_maxlength' => 'האורך המרבי של הטקסט בשדה הזה',
	'sf_forminputs_placeholder' => 'טקסט עזרה שמופיע בשדה קלט עד שהמשתמש לוחץ עליו',
	'sf_forminputs_uploadable' => 'לשים קישור "העלאת קובץ" ליד הקלט הזה', # Fuzzy
	'sf_forminputs_defaultfilename' => 'שם קובץ לפי בררת מחדל לקבצים מוּעלים',
	'sf_forminputs_rows' => 'מספר השורות עבור הקלט הזה',
	'sf_forminputs_cols' => 'מספר העמודות עבור הקלט הזה',
	'sf_forminputs_autogrow' => 'להגדיר שהקלט הזה יגדל אם הטקסט יֵצא מהגבולות שלו',
	'sf_forminputs_valuesfromproperty' => 'מאפיין שהערכים שלו בוויקי צריכים להיות קבוצת הערכים של הקלט הזה',
	'sf_forminputs_valuesfromcategory' => 'קטגוריה שהדפים שבה צריכים להיות קבוצת הערכים של הקלט הזה',
	'sf_forminputs_valuesfromnamespace' => 'מרחב שם שהדפים שבו צריכים להיות קבוצת הערכים של הקלט הזה',
	'sf_forminputs_valuesfromconcept' => '"מושג" של מדיה־ויקי סמנטית שהדפים שבו צריכים להיות קבוצת הערכים של הקלט הזה',
	'sf_forminputs_valuesfromurl' => 'כתובת שמחזיקה נתונים המובנים שצריכים להיות קבוצת הערכים של הקלט הזה',
	'sf_forminputs_values' => 'קבוצת הערכים לקלט הזה, מופרדים בפסיקים',
	'sf_forminputs_list' => 'לסמן את הקלט הזה כמחזיק רשימת ערכים',
	'sf_forminputs_delimiter' => 'המפריד בין ערכי השדה, אם השדה הזה מחזיק רשימה של כאלה',
	'sf_forminputs_remoteautocompletion' => 'להשתמש בהשלמה אוטומטית מרוחקת',
	'sf_forminputs_existingvaluesonly' => 'לאפשר רק ערכים שכבר נמצאים ברשימה',
	'sf_forminputs_showonselect' => 'מרכיבי דף שיוצגו רק אם ערכים מסוימים נבחרו (למשל: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => 'גובה תיבת הרשימה הזאת, בשורות',
	'sf_forminputs_includetimezone' => 'לכלול קלט עבור אותו אזור זמן',
	'sf_forminputs_topcategory' => 'הקטגוריה האם של קבוצת הקטגוריות האלו (נדרש)',
	'sf_forminputs_hideroot' => 'להסתיר את הקטגוריה',
	'sf_forminputs_depth' => 'מספר רמות הקטגוריות שיוצג תחילה',
	'sf_forminputs_height' => 'גובה הקלט הזה, בפיקסלים',
	'sf_forminputs_width' => 'רוחב הקלט הזה, בפיקסלים',
	'createform' => 'יצירת טופס',
	'sf_createform_nameinput' => 'שם הטופס',
	'sf_createform_nameinputdesc' => '(מקובל לתת לטופס שם בהתאם לשם התבנית העיקרית שהוא מגדיר):',
	'sf_createform_template' => 'תבנית:',
	'sf_createform_templatelabelinput' => 'תוית לתבנית (אופציונלי):',
	'sf_createform_allowmultiple' => ' הרשה כפילויות (או אפס) מהתבנית הזאת בדף המיוצר',
	'sf_createform_field' => 'שדה:',
	'sf_createform_fieldprop' => 'שדה זה מגדיר את המאפיין $1, מסוג $2.',
	'sf_createform_fieldproplist' => 'שדה זה מגדיר את רשימת הרכיבים שיש להם את המאפיין $1, מסוג $2.',
	'sf_createform_fieldpropunknowntype' => 'שדה זה מגדיר את המאפיין $1, מסוג לא מוגדר.',
	'sf_createform_inputtype' => 'סוג הקלט:',
	'sf_createform_inputtypedefault' => '(ברירת מחדל)',
	'sf_createform_formlabel' => 'תוית בטופס:',
	'sf_createform_hidden' => 'מוסתר',
	'sf_createform_removetemplate' => 'הסרת תבנית',
	'sf_createform_addtemplate' => 'הוספת תבנית:',
	'sf_createform_beforetemplate' => 'לפני התבנית:',
	'sf_createform_atend' => 'בסוף',
	'sf_createform_add' => 'הוספה',
	'sf_createform_choosefield' => 'בחרו שדה להוספה',
	'createcategory' => 'יצירת קטגוריה',
	'sf_createcategory_name' => 'שם הקטגוריה:',
	'sf_createcategory_defaultform' => 'טופס ברירת המחדל:',
	'sf_createcategory_makesubcategory' => 'הפיכת קטגוריה זו לקטגוריית משנה של קטגוריה אחרת (אופציונלי):',
	'createclass' => 'יצירת מחלקה',
	'sf_createclass_docu' => 'כתבו כאן את כל המידע ליצירת המאפיינים, התבנית, הטופס והקטגוריה עבור מחלקה בודדת. לאפשרויות נוספות, השתמשו בדפים $1 במקום זאת.',
	'sf_createclass_allowedvalues' => 'ערכים מורשים:',
	'sf_createclass_listofvalues' => 'רשימת ערכים?',
	'sf_createclass_nameinput' => 'שם הטופס:',
	'sf_createclass_missingvalues' => 'לא כל השדות הנדרשים מולאו.',
	'sf_createclass_success' => 'יווצרו מאפיינים, תבנית, טופס וקטגוריה.',
	'sf_createclass_create' => 'יצירה',
	'formstart' => 'הוספת דף עם טופס',
	'sf_formstart_badform' => 'שגיאה: לא נמצא דף טופס ב־$1',
	'sf_formstart_badtitle' => 'שגיאה: "$1" היא כותרת דף בלתי תקינה.',
	'sf_formstart_docu' => "כתבו כאן את שם הדף, שייערך באמצעות הטופס '$1'.
אם דף זה כבר קיים, תועברו אל הטופס לעריכת אותו הדף.
אחרת, תועברו אל הטופס להוספת הדף.",
	'sf_formstart_noform_docu' => 'כתבו כאן את שם הדף, ובחרו את הטופס באמצעותו תבוצע עריכת הדף.
אם דף זה כבר קיים, תועברו אל הטופס לעריכת אותו הדף.
אחרת, תועברו אל הטופס להוספת הדף.',
	'sf_formstart_createoredit' => 'יצירה או עריכה',
	'formedit' => 'עריכה באמצעות טופס',
	'sf_formedit_createtitle' => 'יצירת $1: $2',
	'sf_formedit_createtitlenotarget' => 'ליצור את $1',
	'sf_formedit_badurl' => "דף זה משמש לעריכה באמצעות טופס. עליך לפרט גם את שם הטופס וגם את כתובת דף היעד; התוצאה אמורה להיראות כך: 'Special:FormEdit?form=<form name>&target=<target page>', או כך - 'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'במקום זאת תוכלו להוסיף דף זה באמצעות אחד מהטפסים הבאים:',
	'sf_formedit_altformsonly' => 'אנא בחרו מאחד הטפסים הבאים להוספת דף זה:',
	'sf_formcreate' => 'יצירה עם טופס',
	'sf_viewform' => 'הצגת הטופס',
	'sf_editsource' => 'עריכת מקור',
	'sf_formedit_edittitle' => 'עריכת $1: $2',
	'sf_formedit_morethanoneform' => "'''אזהרה:''' יותר מטופס ברירת מחדל אחד מוגדר לדף זה.",
	'sf_formedit_formwarning' => 'אזהרה: דף זה <a href="$1">כבר קיים</a>, אך אינו משתמש בטופס זה.',
	'sf_formedit_mismatchedbrackets' => 'אזהרה: הדף הזה מכיל סוגריים מרובעים או מסולסלים שאינם סגורים כהלכה, אז הטופס לא יטפל נכון בדף. נא <a href="$1">לתקן את השגיאה בקוד המקור</a> לפני המשך.',
	'sf_formedit_remove' => 'הסרה',
	'sf_formedit_addanother' => 'הוספת עוד',
	'sf_formedit_none' => 'לא כלום',
	'sf_formedit_emptytitle' => 'שגיאה: המידע שהוכנס מייצר כותרת דף ריקה.',
	'sf_formedit_hookerror' => 'שגיאה: הרחבת מדיה־ויקי מעה את השינוי של דף היעד.',
	'sf_formedit_saveandcontinueediting' => 'לשמור ולהמשיך',
	'sf_formedit_saveandcontinue_summary' => 'נשמר באמצעות כפתור "$1" בטופס',
	'sf_formedit_tooltip_saveandcontinueediting' => 'לשמור את הנתונים והמשיך לערוך',
	'sf_autoedit_anoneditwarning' => 'אזהרה: לא נכנסתם לחשבון. כתובת ה־IP שלכם תירשם בהיסטוריית הדף הזה.',
	'sf_autoedit_success' => '[[$1]] שוּנה בהצלחה באמצעות הטופס $2.',
	'sf_autoedit_notargetspecified' => 'לא צוין דף יעד.',
	'sf_autoedit_noformfound' => 'לא צוין טופס.',
	'sf_autoedit_toomanyformsfound' => 'יש יותר מטופס אחד לדף.',
	'sf_autoedit_readonly' => 'מסד הנתונים נעול לשינויים. סיבה: $1',
	'sf_autoedit_nosemanticform' => 'לא הצליחה קבלת טופס $2 עבור דף $1. ר׳ [[{{#special:FormEdit}}/$2/$1]] לפרטים.',
	'sf_autoedit_summary' => 'נערך אוטומטית מהדף $1.',
	'sf-autoedit-wait' => 'נא להמתין...',
	'runquery' => 'הרצת שאילתה',
	'sf_runquery_badurl' => "יש לציין את שם הטופס בכתובת;
על הכתובת להיות מהצורה 'Special:RunQuery/<שם הטופס>'.",
	'sf_runquery_title' => 'הרצת שאילתה: $1',
	'sf_runquery_additionalquery' => 'שאילתה נוספת',
	'sf_formerrors_header' => 'אירעו שגיאות בקלט הטופס שלכם; עיינו להלן',
	'sf_blank_error' => 'אין להותיר ריק',
	'sf_bad_url_error' => "עליו להיות במבנה כתובת תקין, המתחיל ב־'http'",
	'sf_bad_email_error' => 'עליו להיות במבנה תקין של כתובת דוא"ל',
	'sf_bad_number_error' => 'עליו להיות מספר תקין',
	'sf_bad_date_error' => 'עליו להיות תאריך תקין',
	'uploadwindow' => 'חלון ההעלאה',
	'sf_deletionlog' => 'יומן מחיקות',
	'sf-preview-header' => 'תצוגה מקדימה טופס',
	'sf-preview-note' => 'כך ייראה הטופס כשהוא יהיה בשימוש:',
	'sf-pageschemas-pagenameformula' => 'נוסחה לשם הדף:',
	'sf-pageschemas-createtitle' => 'כותרת הטופס לדפים חדשים:',
	'sf-pageschemas-edittitle' => 'כותרת הטופס לדפים קיימים:',
	'sf-pageschemas-inputtype' => 'סוג שדה הקלט (השאירו ריק לערך בררת מחדל):',
	'sf_property_isproperty' => 'זהו מאפיין מסוג $1.',
	'sf_property_linkstoform' => 'מקשר לדפים המשתמשים בטופס $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|הערך האפשרי למאפיין זה הוא|הערכים האפשריים למאפיין זה הם}}:',
	'sf_template_docu' => "זוהי התבנית '$1'.
שמה צריך להיות במבנה הבא:",
	'sf_template_docufooter' => 'ערכו את הדף כדי לצפות בטקסט התבנית.',
	'sf_form_docu' => "זהו הטופס '$1'.
על מנת ליצור דף עם טופס זה, יש לכתוב את שם הדף להלן;
אם דף בשם זה כבר קיים, תועברו אל טופס לעריכת הדף.",
	'sf_form_freetextlabel' => 'טקסט חופשי',
	'sf_category_hasdefaultform' => 'קטגוריה זו משתמשת בטופס $1.',
	'sf_category_desc' => 'זוהי הקטגוריה $1.',
	'sf_blank_namespace' => 'ראשי',
	'right-viewedittab' => 'צפייה בלשונית "עריכה" של דפים הניתנים לעריכה על ידי טופס', # Fuzzy
	'right-editrestrictedfields' => 'עריכת שדות טופס מוגבלים',
	'right-createclass' => 'יצירת מחלקות סמנטיות חדשות',
	'action-createclass' => 'ליצור מחלקות סמנטיות חדשות',
	'action-editrestrictedfields' => 'לערוך שדות טופס מוגבלים',
	'action-viewedittab' => 'להציג את הלשונית "עריכה" לטפסים שאפשר לערוך', # Fuzzy
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 * @author Siddhartha Ghai
 */
$messages['hi'] = array(
	'createproperty' => 'एक गुणधर्म बनायें',
	'sf_createproperty_propname' => 'नाम:', # Fuzzy
	'sf_createproperty_proptype' => 'प्रकार:',
	'templates' => 'साँचे',
	'sf_templates_definescat' => 'श्रेणीकी व्याख्या: $1',
	'createtemplate' => 'साँचा बनायें',
	'sf_createtemplate_namelabel' => 'साँचा का नाम:',
	'sf_createtemplate_templatefields' => 'साँचा के फ़िल्ड',
	'sf_createtemplate_fieldname' => 'फ़िल्ड नाम:',
	'sf_createtemplate_displaylabel' => 'दर्शाने का लेबल:',
	'sf_createtemplate_semanticproperty' => 'सिमँटिक गुणधर्म:',
	'sf_createtemplate_aggregation' => 'एग्रिगेशन',
	'sf_createtemplate_aggregationlabel' => 'सूची शीर्षक:',
	'sf_createtemplate_outputformat' => 'आउटपुट रूपरेखा:',
	'sf_createtemplate_standardformat' => 'स्टँडर्ड', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'दाईं ओर ज्ञानसन्दूक', # Fuzzy
	'sf_createtemplate_addfield' => 'फ़िल्ड बढायें',
	'sf_createtemplate_deletefield' => 'हटायें',
	'forms' => 'फ़ार्म',
	'sf_forminputs_mandatory' => 'अत्यावश्यक',
	'sf_forminputs_restricted' => 'प्रतिबंधित (सिर्फ प्रबंधक बदल सकतें हैं)', # Fuzzy
	'createform' => 'फ़ार्म बनायें',
	'sf_createform_template' => 'साँचा:',
	'sf_createform_templatelabelinput' => 'साँचा लेबल (वैकल्पिक):',
	'sf_createform_field' => 'फ़ील्ड:',
	'sf_createform_inputtype' => 'इनपुट प्रकार:',
	'sf_createform_inputtypedefault' => '(डिफॉल्ट)',
	'sf_createform_formlabel' => 'फ़ार्म लेबल:',
	'sf_createform_hidden' => 'छुपाई हुई',
	'sf_createform_removetemplate' => 'साँचा हटायें',
	'sf_createform_addtemplate' => 'साँचा बढायें:',
	'sf_createform_beforetemplate' => 'साँचे के पहले:',
	'sf_createform_atend' => 'आखिरमें',
	'sf_createform_add' => 'बढायें',
	'sf_createform_choosefield' => 'बढाने के लिये फ़िल्ड चुनें',
	'createcategory' => 'श्रेणी बनायें',
	'sf_createcategory_name' => 'नाम:', # Fuzzy
	'sf_createcategory_defaultform' => 'डिफ़ाल्ट फ़ार्म:',
	'formstart' => 'पन्ना बढायें',
	'sf_formstart_createoredit' => 'बढायें या बदलें', # Fuzzy
	'formedit' => 'फ़ार्म के साथ बदलें',
	'sf_formedit_createtitle' => 'बढायें $1: $2', # Fuzzy
	'sf_editsource' => 'स्रोत बदलें',
	'sf_formedit_edittitle' => 'बदलें $1: $2',
	'sf_formedit_remove' => 'हटायें',
	'sf_formedit_addanother' => 'दूसरा बढायें',
	'sf_formedit_none' => 'बिल्कुल नहीं',
	'sf_blank_error' => 'खाली नहीं हो सकता',
	'sf_bad_number_error' => 'एक वैध संख्या होना आवश्यक हैं',
	'sf_bad_date_error' => 'एक वैध तारीख होना आवश्यक हैं',
	'sf_property_isproperty' => 'यह $1 प्रकार का गुणधर्म हैं।',
	'sf_form_freetextlabel' => 'मुक्त पाठ',
	'sf_category_hasdefaultform' => 'यह श्रेणी फ़ार्म $1 का इस्तेमाल करती हैं।',
	'sf_category_desc' => 'यह $1 श्रेणी हैं।',
	'sf_blank_namespace' => 'मुख्य',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'sf_createtemplate_deletefield' => 'Panason',
);

/** Croatian (hrvatski)
 * @author Dalibor Bosits
 */
$messages['hr'] = array(
	'sf_createtemplate_deletefield' => 'Izbriši',
	'sf_formedit_remove' => 'Ukloni',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'semanticforms-desc' => 'Formulary za přidawanje a wobdźěłowanje semantiskich datow',
	'specialpages-group-sf_group' => 'Semantiske formulary',
	'createproperty' => 'Wutwor kajkosć',
	'sf-createproperty-with-name' => 'Kajkosć wutworić: $1',
	'sf_createproperty_linktoform' => 'Tuta kajkosć budźe k stronam wotkazować, kotrež formular wužiwaja:',
	'sf_createproperty_allowedvalsinput' => 'Jeli chceš, zo su jenož wěste hódnoty za tute kajkosć dowolene, zapodaj lisćinu dowolenych hódnotow, wotdźělenych přez komy (jeli hódnota komu wobsahuje, narunaj ju přez "\\,"):',
	'sf_createproperty_propname' => 'Mjeno kajkosće:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Předłohi',
	'sf_templates_docu' => 'Slědowace předłohi su we {{GRAMMAR:Lokatiw|{{SITENAME}}}}',
	'sf_templates_definescat' => 'definuje kategoriju: $1',
	'createtemplate' => 'Wutwor předłohu',
	'sf-createtemplate-with-name' => 'Předłohu wutworić: $1',
	'sf_createtemplate_namelabel' => 'Mjeno předłohi:',
	'sf_createtemplate_multipleinstance' => 'Tuta předłoha da so wjackróć do strony zapřijeć.',
	'sf_createtemplate_categorylabel' => 'Kategorija definowana přez předłohu (opcionalny):',
	'sf_createtemplate_templatefields' => 'Pola předłohi',
	'sf_createtemplate_fieldsdesc' => 'Jeli pola w tutej předłoze hižo nimaja polowe mjena potrjebować, zapodaj prosće indeks kóždeho pola (na př. 1, 2, 3 atd.) jako mjeno město woprawdźiteho mjena.',
	'sf_createtemplate_fieldname' => 'Polowe mjeno:',
	'sf_createtemplate_displaylabel' => 'Polowe mjeno, kotrež ma so pokazać:',
	'sf_createtemplate_semanticproperty' => 'Semantiska kajkosć:',
	'sf_createtemplate_fieldislist' => 'Tute polo móže lisćinu hódnotow wobsahować, kotrež so přez komu wotdźěleja.',
	'sf_createtemplate_aggregation' => 'Agregacija',
	'sf_createtemplate_aggregationdesc' => 'Zo by na stronje, kotraž tutu předłohu wužiwa, wšě strony nalistował, kotrež wěstu kajkosć maja a na tu stronu wotkazuja, podaj tu wotpowědnu kajkosć:',
	'sf_createtemplate_aggregationlabel' => 'Titul za lisćinu:',
	'sf_createtemplate_outputformat' => 'Wudatny format:',
	'sf_createtemplate_standardformat' => 'Tabela',
	'sf_createtemplate_infoboxformat' => 'Bóčny infokašćik',
	'sf_createtemplate_plainformat' => 'Luty tekst',
	'sf_createtemplate_sectionsformat' => 'Wotrězki',
	'sf_createtemplate_addfield' => 'Polo přidać',
	'sf_createtemplate_deletefield' => 'Wušmórnyć',
	'sf_createtemplate_addtemplatebeforesave' => 'Dyrbiš znajmjeńša jednu předłohu k tutomu formularej přidać, prjedy hač móžeš jón składować.',
	'forms' => 'Formulary',
	'sf_forms_docu' => 'Slědowace formulary eksistuja w {{GRAMMAR:Lokatiw|{{SITENAME}}}}',
	'sf_forminputs_mandatory' => 'Hódnota dyrbi so do tutoho zapodawanskeho pola zapodać',
	'sf_forminputs_restricted' => 'Jenož administratorojo móža tute zapodawanske polo wobdźěłać',
	'sf_forminputs_class' => 'HTML-atribut "class" za tute zapodawanske polo',
	'sf_forminputs_default' => 'Standardna hódnota za tute zapodawanske polo',
	'sf_forminputs_preload' => 'Wikistrona, kotrejež wobsah budźe standardna hódnota tutoho zapodawanskeho pola',
	'sf_forminputs_property' => 'Semantiski atribut, kotryž tutomu polu wotpowěduje',
	'sf_forminputs_size' => 'Wulkosć tutoho tekstoweho pola w znamješkach',
	'sf_forminputs_maxlength' => 'Maksimalna dowolena dołhosć teksta w tutym zapodawanskim polu',
	'sf_forminputs_placeholder' => 'Tekst pomocy, kotryž so jewi, doniž wužiwar na njón njekliknje',
	'sf_forminputs_uploadable' => "Wotkaz ''{{int:upload}}'' pódla zapodawanskeho pola stajić",
	'sf_forminputs_defaultfilename' => 'Standardne datajowe mjeno za nahrate dataje',
	'sf_forminputs_rows' => 'Ličba rjadkow za tute zapodawanske polo',
	'sf_forminputs_cols' => 'Ličba špaltow za tute zapodawanske polo',
	'sf_forminputs_autogrow' => 'Awtomatiske změnjenje wulkosće zapodawanskeho pola, jeli tekst jeho mjezy přesaha',
	'sf_forminputs_valuesfromproperty' => 'Atribut, kotrehož hódnoty we wikiju maja hódnoty tutoho zapodawanskeho pola być',
	'sf_forminputs_valuesfromcategory' => 'Kategorija, kotrejež strony maja hódnoty tutoho zapodawanskeho pola być',
	'sf_forminputs_valuesfromnamespace' => 'Mjenowy rum, kotrehož strony maja hódnoty tutoho zapodawanskeho pola być',
	'sf_forminputs_valuesfromconcept' => '"Konceptowa" strona Semantic MediaWiki, kotrychž strony měli sadźba hódnotow tutoho zapodawanskeho pola być',
	'sf_forminputs_valuesfromurl' => 'URL, kotryž strukturowane daty wobsahuje, kotrež měli sadźba hódnotow tutoho zapodawanskeho pola być',
	'sf_forminputs_values' => 'Hódnoty za tute zapodawanske polo, rozdźělene přez komy',
	'sf_forminputs_list' => 'Tute zapodawanske polo jako lisćinu hódnotow markiěrować',
	'sf_forminputs_delimiter' => 'Dźěłatko mjez pólnymi hódnotami, jeli tute zapodawanske polo ma lisćinu hódnotow',
	'sf_forminputs_remoteautocompletion' => 'Zdalene awtomatiske wudospołnjenje wužiwać',
	'sf_forminputs_existingvaluesonly' => 'Jenož hódnoty dowolić, kotrež su hižo w lisćinje',
	'sf_forminputs_showonselect' => 'Elementy strony, kotrež maja so jenož zwobraznić, jeli wěste hódnoty su wubrane (na přikład: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => 'Wysokosć tutoho lisćinoweho pola w rjadkach',
	'sf_forminputs_includetimezone' => 'Zapodawanske polo za časowe pasmo dodać',
	'sf_forminputs_topcategory' => 'Nadrjadowana kategorija tuteje sadźby kategorijow (trěbna)',
	'sf_forminputs_hideroot' => 'Nadrjadowanu kategoriju schować',
	'sf_forminputs_depth' => 'Ličba kategorijowych runinow, kotrež maja so na spočatku pokazać',
	'sf_forminputs_height' => 'Wysokosć tutoho zapodawanskeho pola w pikselach',
	'sf_forminputs_width' => 'Šěrokosć tutoho zapodawanskeho pola w pikselach',
	'createform' => 'Formular wutworić',
	'sf-createform-with-name' => 'Formular wutworić: $1',
	'sf_createform_nameinput' => 'Formularne mjeno',
	'sf_createform_nameinputdesc' => '(formular dóstawa zwjetša samsne mjeno kaž jeho hłowna předłoha):',
	'sf_createform_template' => 'Předłoha:',
	'sf_createform_templatelabelinput' => 'Mjeno předłohi (opcionalny):',
	'sf_createform_allowmultiple' => 'Wjacore (abo žane) instancy tuteje předłohi we wutworjenej stronje dowolić',
	'sf_createform_field' => 'Polo:',
	'sf_createform_fieldprop' => 'Tute polo definuje kajkosć $1 typa $2.',
	'sf_createform_fieldproplist' => 'Tute polo definuje lisćinu elementow, kotrež maja kajkosć $1 typa $2.',
	'sf_createform_fieldpropunknowntype' => 'Tute polo definuje kajkosć $1 njepodateho typa.',
	'sf_createform_inputtype' => 'Zapodaj typ:',
	'sf_createform_inputtypedefault' => '(Standard)',
	'sf_createform_formlabel' => 'Formularne mjeno:',
	'sf_createform_hidden' => 'Schowany',
	'sf_createform_removetemplate' => 'Předłohu wotstronić',
	'sf_createform_addtemplate' => 'Předłohu přidać:',
	'sf_createform_beforetemplate' => 'Před předłohu:',
	'sf_createform_atend' => 'Na kóncu',
	'sf_createform_add' => 'Přidać',
	'sf_createform_choosefield' => 'Wubjer polo, kotrež chceš přidać',
	'createcategory' => 'Kategoriju wutworić',
	'sf-createcategory-with-name' => 'Kategoriju wutworić: $1',
	'sf_createcategory_name' => 'Mjeno kategorije:',
	'sf_createcategory_defaultform' => 'Standardny formular:',
	'sf_createcategory_makesubcategory' => 'Tutu kategoriju k podkategoriji druheje kategorije činić (opcionalny):',
	'createclass' => 'Klasu wutworić',
	'sf_createclass_docu' => 'Zapodajće tu wšě daty, zo by kajkosće, předłohu, formular a kategoriju za jednotliwu klasu wutworił.
Za dalše opcije wužij strony $1 město toho.',
	'sf_createclass_allowedvalues' => 'Dowolene hódnoty:',
	'sf_createclass_listofvalues' => 'Lisćina hódnotow?',
	'sf_createclass_nameinput' => 'Mjeno formulra:',
	'sf_createclass_missingvalues' => 'Nic wšě trěbne pola su wupjelnjene.',
	'sf_createclass_success' => 'Kajkosće, předłoha, formular a kategorija budu so wutworjeć.',
	'sf_createclass_create' => 'Wutworić',
	'formstart' => 'Stronu z formularom přidać',
	'sf_formstart_badform' => 'Zmylk: Žadyn formular na stronje "$1" namakany.',
	'sf_formstart_badtitle' => 'Zmylk: "$1" je njepłaćiwy titul za stronu.',
	'sf_formstart_docu' => "Zapodaj tu mjeno strony, kotraž so ma z formularom '$1' wobdźěłać. Jeli tuta strona hižo eksistuje, posrědkuješ k formularej, z kotrymž móžeš tut stronu wobdźěłać. Hewak posrědkuješ so k formularej, z kotrymž móžeš stronu přidać.",
	'sf_formstart_noform_docu' => 'Zapodaj tu mjeno strony a wubjer formular, z kotrymž chceš ju wobdźěłać. Jeli strona hižo eksistuje, posrědkuješ so k formularej, z kotrymž tutu stronu wobdźěłać. Hewak posrědkujes so k formularej, z kotrymž móžeš přidać.',
	'sf_formstart_createoredit' => 'Wutworić abo wobdźěłać',
	'formedit' => 'Z formularom wobdźěłać',
	'sf_formedit_createtitle' => '$1 wutworić: $2',
	'sf_formedit_createtitlenotarget' => '$1 wutworić',
	'sf_formedit_badurl' => "To je strona za wobdźěłowanje z formularom. Dyrbiš formularne mjeno kaž tež cilowu stronu w URL podać; měło kaž 'Special:FormEdit?form=<formularne mjeno>&target=<cilowa strona>' abo  'Special:FormEdit/<formularne mjeno>/<cilowa strona>' wupadać.",
	'sf_formedit_altforms' => 'Móžeš město toho tutu stronu z jednym ze slědowacych formularow přidać:',
	'sf_formedit_altformsonly' => 'Wubjer přošu jedyn ze slědowacych formularow, zo by tutu stronu přidał:',
	'sf_formcreate' => 'Z formularom wutworić',
	'sf_viewform' => 'Formular wobhladać',
	'sf_editsource' => 'Žórło wobdźěłać',
	'sf_formedit_edittitle' => '$1 wobdźěłać: $2',
	'sf_formedit_morethanoneform' => 'Warnowanje: Za tutu stronu bu wjace hač jedyn standardny formular definowany.',
	'sf_formedit_formwarning' => 'Warnowanje: Tuta strona <a href="$1">hižo eksistuje</a>, ale njewužiwa tutón formular.',
	'sf_formedit_mismatchedbrackets' => 'Warnowanje: Tuta strona wobsahuje zhibowane abo róžkate spinki, kotrež njejsu wotzamknjene, formular njebudźe korektnje ze stronu wobchadźeć. Prošu <a href="$1">porjedź zmylk w žórłowym teksće</a>. prjedy hač dale činiš.',
	'sf_formedit_remove' => 'Tutu instancu wotstronić',
	'sf_formedit_addanotherabove' => 'Dalšu instancu nad tutej přidać',
	'sf_formedit_addanother' => 'Dalše přidać',
	'sf_formedit_none' => 'Žadyn',
	'sf_formedit_emptytitle' => 'Zmylk: Zasunjene daty wjedu k prózdnemu titulej strony.',
	'sf_formedit_hookerror' => 'Zmylk: Rozšěrjenje MediaWiki je měnjenju ciloweje strony zadźěwało.',
	'sf_formedit_saveandcontinueediting' => 'Składować a pokročować',
	'sf_formedit_saveandcontinue_summary' => 'Je so z pomocu tłóčatka "$1" we formularje składował',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Składować a dale wobdźěłować',
	'sf_autoedit_anoneditwarning' => 'Kedźbu: Njejsy přizjewjeny. Twoja IP-adresa budźe so do wersijowych stawiznow strony přijimać.',
	'sf_autoedit_success' => '[[$1]] je so wuspěšnje z pomocu formulara $2 změnił.',
	'sf_autoedit_fail' => '[[$1]] njeda so změnić.',
	'sf_autoedit_notargetspecified' => 'Žana cilowa strona podata.',
	'sf_autoedit_invalidtargetspecified' => 'Podata cilowa strona $1 je njepłaćiwa.',
	'sf_autoedit_invalidform' => '$1 płaćiwy formular njeje.',
	'sf_autoedit_redlinkexists' => '$1 hižo eksistuje.',
	'sf_autoedit_noformfound' => 'Žadyn formular podaty.',
	'sf_autoedit_toomanyformsfound' => 'Za tutu stronu wjace hač jedyn formular k dispoziciji steji.',
	'sf_autoedit_readonly' => 'Datowa banka je tuchwilu přećiwo změnam zawrjena. Přičina: $1',
	'sf_autoedit_nosemanticform' => 'Formular $2 njeda so za stronu $1 wotwołać. Hlej [[{{#special:FormEdit}}/$2/$1]] za podrobnosće.',
	'sf_autoedit_summary' => 'Awtomatisce wot strony $1 wobdźěłany.',
	'sf-autoedit-wait' => 'Prošu čakać...',
	'runquery' => 'Naprašowanje startować',
	'sf_runquery_badurl' => "Dyrbiš formularne mjeno w URL podać;
URL měł wupadać kaž 'Special:RunQuery/<formularne mjeno>'.",
	'sf_runquery_title' => 'Start naprašowanja: $1',
	'sf_runquery_additionalquery' => 'Přidatne naprašowanje',
	'sf_formerrors_header' => 'Su zmylki z twojim formularnym zapodaćom wustupili, hlej deleka',
	'sf_blank_error' => 'Njesmě prózdny być!',
	'sf_bad_url_error' => "dyrbi korektny format URL měć, kotryž so z 'http://' započina",
	'sf_bad_email_error' => 'dyrbi płaćiwy format za e-mejlowe adresy měć',
	'sf_bad_number_error' => 'dyrbi płaćiwa ličba być',
	'sf_bad_date_error' => 'dyrbi płaćiwy datum być',
	'uploadwindow' => 'Wokno nahraćow',
	'sf_deletionlog' => 'protokol wušmórnjenjow',
	'sf-preview-header' => 'Formularny přehlad',
	'sf-preview-note' => 'Tak budźe formular wupadać, hdyž so wužiwa:',
	'sf-pageschemas-pagenameformula' => 'Formla mjena strony:',
	'sf-pageschemas-createtitle' => 'Titul formulara za nowe strony:',
	'sf-pageschemas-edittitle' => 'Titul formulara za eksistowace strony:',
	'sf-pageschemas-inputtype' => 'Zapodawanski typ (prózdny wostajić, zo by standard wužiwało):',
	'sf_property_isproperty' => 'To je kajkosć typa $1.',
	'sf_property_linkstoform' => 'Wotkazuje k stronam, kotrež formular $1 wužiwaja.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dowolena hódnota za tutu kajkosć je|Dowolenej hódnoće za tutu kajkosć stej|Dowolene hódnoty za tutu kajkosć su|Dowolene hódnoty za tutu kajkosć su}}:',
	'sf_template_docu' => "To je předłoha '$1'. Měła so w slědowacym formaće wołać:",
	'sf_template_docufooter' => 'Wobdźěłaj tutu stronu, zo by tekst předłohi widźał.',
	'sf_form_docu' => 'To je formular "$1".
Zo by stronu z tutym formularom wutworił, zapodaj deleka mjeno strony;
jeli strona z tutym mjenom hižo eksistuje, posrědkuješ so dale k formularej, z kotrymž móžeš tutu stronu wobdźěłać.',
	'sf_form_freetextlabel' => 'Swobodny tekst',
	'sf_category_hasdefaultform' => 'Tuta kategorija wužiwa formular $1.',
	'sf_category_desc' => 'To je kategorija $1.',
	'sf_blank_namespace' => 'Hłowny',
	'right-viewedittab' => 'Rajtark "{{int:edit}}" za strony sej wobhladać, kotrež su přez formular wobźěłujomne',
	'right-editrestrictedfields' => 'Wobmjezowane formularne pola wobdźěłać',
	'right-createclass' => 'Nowe semantiske klasy wutworić',
	'action-createclass' => 'nowe semantiske klasy wutworić',
	'action-editrestrictedfields' => 'wobmjezowane formularne pola wobdźěłać',
	'action-viewedittab' => 'Rajtark "{{int:edit}}" za strony pokazać, kotrež su přez formular wobźěłujomne',
);

/** Hungarian (magyar)
 * @author Dani
 * @author Dj
 * @author Dorgan
 * @author Glanthor Reviol
 * @author TK-999
 * @author Tgr
 */
$messages['hu'] = array(
	'semanticforms-desc' => 'Űrlapok szemantikus adatok hozzáadásához és szerkesztéséhez',
	'specialpages-group-sf_group' => 'Szemantikus űrlapok',
	'createproperty' => 'Tulajdonság létrehozása',
	'sf_createproperty_linktoform' => 'Ez a tulajdonság hivatkozni fog azokra a lapokra, amelyek használják az űrlapot:',
	'sf_createproperty_allowedvalsinput' => 'Ha azt szeretnéd, hogy ez a tulajdonság csak bizonyos értékeket vehessen fel, add meg az engedélyezett értékek listáját, vesszővel elválasztva (ha az érték tartalmaz vesszőt, használd a „\\,” alakot):',
	'sf_createproperty_propname' => 'Tulajdonságnév:',
	'sf_createproperty_proptype' => 'Típus:',
	'templates' => 'Sablonok',
	'sf_templates_docu' => 'A következő sablonok találhatóak meg a wikiben.',
	'sf_templates_definescat' => 'definiálja a kategóriát: $1',
	'createtemplate' => 'Sablon létrehozása',
	'sf_createtemplate_namelabel' => 'A sablon neve:',
	'sf_createtemplate_categorylabel' => 'A sablon által megadott kategória (nem kötelező):',
	'sf_createtemplate_templatefields' => 'A sablon mezői:',
	'sf_createtemplate_fieldsdesc' => 'Ha azt szeretnéd, hogy a sablonban lévő mezőknek ne kelljen mezőneveket adni, egyszerűen írd be a mező indexét (pl. 1, 2, 3 stb.) névként a valódi név helyett.',
	'sf_createtemplate_fieldname' => 'Mező neve:',
	'sf_createtemplate_displaylabel' => 'Megjelenített szöveg:',
	'sf_createtemplate_semanticproperty' => 'Szemantikus tulajdonság:',
	'sf_createtemplate_fieldislist' => 'Ez a mező értékek vesszővel elválasztott listáját tartalmazhatja.',
	'sf_createtemplate_aggregation' => 'Aggregáció',
	'sf_createtemplate_aggregationdesc' => 'A listázáshoz bármelyik lapon, ami ezt a sablont használja, az összes olyen lapnak, melynek van egy bizonyos tulajdonsága, ami arra a lapra mutat, add meg az alább látható tulajdonságot:',
	'sf_createtemplate_aggregationlabel' => 'Lista címe:',
	'sf_createtemplate_outputformat' => 'Kimeneti formátum:',
	'sf_createtemplate_standardformat' => 'Táblázat',
	'sf_createtemplate_infoboxformat' => 'Jobboldai infobox', # Fuzzy
	'sf_createtemplate_addfield' => 'Mező hozzáadása',
	'sf_createtemplate_deletefield' => 'Törlés',
	'sf_createtemplate_addtemplatebeforesave' => 'Legalább egy sablont hozzá kell rendelned az űrlaphoz a mentés előtt.',
	'forms' => 'Űrlapok',
	'sf_forms_docu' => 'A következő űrlapok találhatóak meg a wikiben.',
	'sf_forminputs_mandatory' => 'Kötelező',
	'sf_forminputs_restricted' => 'Csak adminisztrátorok módosíthatják ezt a bemenetet',
	'sf_forminputs_class' => 'Ezen bemenet HTML "osztály" tulajdonsága',
	'sf_forminputs_default' => 'Az alapértelmezett érték ehhez a bemenethez',
	'sf_forminputs_preload' => 'Egy lap a wikin, amelynek tartalma ezen bemenet alapértéke lesz',
	'sf_forminputs_property' => 'Egy szemantikai tulajdonság, amelynek ez a mező megfelel',
	'sf_forminputs_size' => 'Ezen szövegbeviteli mező mérete karakterekben',
	'createform' => 'Űrlap létrehozása',
	'sf_createform_nameinput' => 'Űrlap neve',
	'sf_createform_nameinputdesc' => '(az űrlapot szokás szerint a fő sablon után nevezzük el):',
	'sf_createform_template' => 'Sablon:',
	'sf_createform_templatelabelinput' => 'Sablon-címke (nem kötelező):',
	'sf_createform_allowmultiple' => 'A sablon többször is (vagy egyszer sem) szerepelhet az elkészült lapon',
	'sf_createform_field' => 'Mező:',
	'sf_createform_fieldprop' => 'Ez a mező definiálja a(z) $2 típusú $1 tulajdonságot.',
	'sf_createform_fieldproplist' => 'Ez a mező olyan elemek listáját definiálja, amelyeknek van $2 típusú $1 tulajdonságok.',
	'sf_createform_fieldpropunknowntype' => 'Ez a mező definiálja a nem megadott típusú $1 tulajdonságot.',
	'sf_createform_inputtype' => 'Bemenet típusa:',
	'sf_createform_inputtypedefault' => '(alapértelmezett)',
	'sf_createform_formlabel' => 'Az űrlap címkéje:',
	'sf_createform_hidden' => 'Rejtett',
	'sf_createform_removetemplate' => 'Sablon eltávolítása',
	'sf_createform_addtemplate' => 'Sablon hozzáadása:',
	'sf_createform_beforetemplate' => 'Sablon elé:',
	'sf_createform_atend' => 'A végén',
	'sf_createform_add' => 'Hozzáadás',
	'sf_createform_choosefield' => 'Válaszd ki azt a mezőt, amelyiket hozzá szeretnéd adni',
	'createcategory' => 'Kategória létrehozása',
	'sf_createcategory_name' => 'Kategórianév:',
	'sf_createcategory_defaultform' => 'Alapértelmezett űrlap:',
	'sf_createcategory_makesubcategory' => 'Legyen ez egy kategória alkategóriája (nem kötelező):',
	'createclass' => 'Osztály létrehozása',
	'sf_createclass_docu' => 'Add meg itt az összes adatot a tulajdonságok, a sablon és a kategória létrehozásához egyetlen osztályhoz. További beállításokat a(z) $1 lapon végezhetsz.',
	'sf_createclass_allowedvalues' => 'Megengedett értékek:',
	'sf_createclass_listofvalues' => 'Értékek listája?',
	'sf_createclass_nameinput' => 'Űrlap neve:',
	'sf_createclass_missingvalues' => 'Nem töltötted ki az összes kötelező mezőt.',
	'sf_createclass_success' => 'Tulajdonságok, sablon, űrlap és kategória lesz létrehozva.',
	'sf_createclass_create' => 'Létrehozás',
	'formstart' => 'Oldal hozzáadása űrlappal',
	'sf_formstart_badform' => 'Hiba: nem található űrlap a(z) $1 címen',
	'sf_formstart_badtitle' => 'Hiba: a(z) „$1” érvénytelen lapcím.',
	'sf_formstart_docu' => 'Add meg annak a lapnak a nevét, amit a(z) „$1” űrlap segítségével szeretnél szerkeszteni.
Ha ez a lap már létezik, ahhoz az űrlaphoz leszel irányítva a lap szerkesztéséhez.
Egyébként a lap hozzáadása űrlaphoz leszel küldve.',
	'sf_formstart_noform_docu' => 'Add meg annak a lapnak a nevét, majd válaszd ki az űrlapot, amivel szerkeszteni akarod.
Ha ez a lap már létezik, ahhoz az űrlaphoz leszel irányítva a lap szerkesztéséhez.
Egyébként a lap hozzáadása űrlaphoz leszel küldve.',
	'sf_formstart_createoredit' => 'Létrehozás vagy szerkesztés',
	'formedit' => 'Szerkesztés űrlappal',
	'sf_formedit_createtitle' => '$1 létrehozása: $2',
	'sf_formedit_badurl' => 'Ezen a lapon űrlap segítségével szerkeszthetsz. Meg kell adnod az űrlap nevét és a céllap URL-címét is;
a következőképpen kell kinéznie: „Special:FormEdit?form=<űrlap neve>&target=<céllap>”, vagy „Special:FormEdit/<űrlap neve>/<céllap>”.',
	'sf_formedit_altforms' => 'Helyette hozzáadhatod ezt a lapot a következő űrlapok egyikével:',
	'sf_formedit_altformsonly' => 'Válassz egyet a következő űrlapok közül, amit hozzá szeretnél adni ehhez a laphoz:',
	'sf_formcreate' => 'Létrehozás űrlappal',
	'sf_viewform' => 'Űrlap megtekintése',
	'sf_editsource' => 'Forrás szerkesztése',
	'sf_formedit_edittitle' => '$1: $2 szerkesztése',
	'sf_formedit_morethanoneform' => "'''Figyelmeztetés:''' több mint egy alapértelmezett űrlap van megadva ehhez a laphoz.",
	'sf_formedit_formwarning' => 'Figyelem: Ez a lap <a href="$1">már létezik</a>, de nem használja ezt az űrlapot.',
	'sf_formedit_remove' => 'Eltávolítás',
	'sf_formedit_addanother' => 'Másik hozzáadása',
	'sf_formedit_none' => 'Nincs',
	'runquery' => 'Lekérdezés futtatása',
	'sf_runquery_badurl' => "Meg kell adnod egy űrlap nevét az URL-ben;
az URL-nek így kell kinéznie: 'Special:RunQuery/<űrlap neve>'.",
	'sf_runquery_title' => 'Lekérdezés futtatása: $1',
	'sf_runquery_additionalquery' => 'További lekérdezés',
	'sf_formerrors_header' => 'Hibák voltak az űrlapon megadott adatokban; lásd lentebb',
	'sf_blank_error' => 'nem lehet üres',
	'sf_bad_url_error' => 'a helyes URL formátumban kell lennie, az elején „http://”-vel',
	'sf_bad_email_error' => 'helyes e-mail cím formátumban kell lennie',
	'sf_bad_number_error' => 'számnak kell lennie',
	'sf_bad_date_error' => 'érvényes dátumnak kell lennie',
	'uploadwindow' => 'Feltöltési ablak',
	'sf_deletionlog' => 'Törlési napló',
	'sf_property_isproperty' => 'Ez egy „$1” típusú tulajdonság.',
	'sf_property_linkstoform' => 'Hivatkozik azokra a lapokra, amelyek a(z) $1 űrlapot használják.',
	'sf_property_allowedvals' => 'A tulajdonság a következő {{PLURAL:$1|értéket|értékeket}} veheti fel:',
	'sf_template_docu' => 'Ez a(z) „$1” sablon.
A következő formátumban kell meghívni:',
	'sf_template_docufooter' => 'Szerkeszd a lapot, hogy láthasd a sablon szövegét.',
	'sf_form_docu' => 'Ez a(z) „$1” űrlap.
Ha új lapot szeretnél létrehozni ezzel az űrlappal, írd be alább a lap nevét.
Ha már létezik ilyen nevű lap, egy űrlaphoz leszel irányítva, ahol szerkesztheted a lapot.',
	'sf_form_freetextlabel' => 'Szabad szöveg',
	'sf_category_hasdefaultform' => 'Ez a kategória a(z) „$1” űrlapot használja.',
	'sf_category_desc' => 'Ez a(z) $1 kategória.',
	'sf_blank_namespace' => 'Fő',
	'right-viewedittab' => 'Nézd a „Szerkesztés” fület azokhoz a lapokhoz, melyek űrlappal szerkeszthetőek', # Fuzzy
	'right-editrestrictedfields' => 'korlátozott űrlap-mezők szerkesztése',
);

/** Armenian (Հայերեն)
 * @author Vadgt
 */
$messages['hy'] = array(
	'formedit' => 'Խմբագրել ձեւը',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'semanticforms-desc' => 'Formularios pro adder e modificar datos semantic',
	'specialpages-group-sf_group' => 'Formularios semantic',
	'createproperty' => 'Crear un proprietate',
	'sf_createproperty_linktoform' => 'Iste proprietate ligara verso paginas que usa le formulario:',
	'sf_createproperty_allowedvalsinput' => 'Si tu vole que iste proprietate sia permittite a haber solmente certe valores, entra le lista del valores permittite, separate per commas (si un valor contine un comma, reimplacia lo con "\\,"):',
	'sf_createproperty_propname' => 'Nomine del proprietate:',
	'sf_createproperty_proptype' => 'Typo:',
	'templates' => 'Patronos',
	'sf_templates_docu' => 'Le sequente patronos existe in le wiki.',
	'sf_templates_definescat' => 'defini categoria: $1',
	'createtemplate' => 'Crear un patrono',
	'sf_createtemplate_namelabel' => 'Nomine del patrono:',
	'sf_createtemplate_categorylabel' => 'Categoria definite per patrono (optional):',
	'sf_createtemplate_templatefields' => 'Campos de patrono',
	'sf_createtemplate_fieldsdesc' => 'Pro effectuar que le campos in iste patrono non require plus le nomines de campos, simplemente entra le indice de cata campo (p.ex. 1, 2, 3, etc.) como le nomine, in loco del nomine real.',
	'sf_createtemplate_fieldname' => 'Nomine del campo:',
	'sf_createtemplate_displaylabel' => 'Etiquetta pro monstrar:',
	'sf_createtemplate_semanticproperty' => 'Proprietate semantic:',
	'sf_createtemplate_fieldislist' => 'Iste campo pote tener un lista de valores, separate per commas',
	'sf_createtemplate_aggregation' => 'Aggregation',
	'sf_createtemplate_aggregationdesc' => 'Pro listar, in omne pagina que usa iste patrono, tote le paginas que ha un certe proprietate punctante verso ille pagina, specifica le proprietate in question ci infra:',
	'sf_createtemplate_aggregationlabel' => 'Titulo pro lista:',
	'sf_createtemplate_outputformat' => 'Formato de output:',
	'sf_createtemplate_standardformat' => 'Standard', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Quadro de information a dextra', # Fuzzy
	'sf_createtemplate_addfield' => 'Adder campo',
	'sf_createtemplate_deletefield' => 'Deler',
	'sf_createtemplate_addtemplatebeforesave' => 'Tu debe adder al minus un patrono a iste formulario ante que tu pote salveguardar lo.',
	'forms' => 'Formularios',
	'sf_forms_docu' => 'Le sequente formularios existe in le wiki.',
	'sf_forminputs_mandatory' => 'Es necessari mitter un valor pro iste entrata',
	'sf_forminputs_restricted' => 'Solmente administratores pote modificar iste campo de entrata',
	'sf_forminputs_class' => 'Le attributo HTML "class" pro iste entrata',
	'sf_forminputs_default' => 'Le valor predefinite pro iste entrata',
	'sf_forminputs_preload' => 'Un pagina wiki de que le contento devenira le valor predefinite de iste entrata',
	'sf_forminputs_property' => 'Un proprietate semantic a que iste campo corresponde',
	'sf_forminputs_size' => 'Le dimension de iste campo de texto, in characteres',
	'sf_forminputs_maxlength' => 'Le longitude maximal permittite del texto in iste campo',
	'sf_forminputs_placeholder' => 'Texto de adjuta que appare in le campo de entrata usque le usator clicca sur illo',
	'sf_forminputs_uploadable' => 'Placiar un ligamine "Incargar file" al latere de iste entrata', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Le nomine de file predefinite pro files incargate',
	'sf_forminputs_rows' => 'Le numero de lineas pro iste entrata',
	'sf_forminputs_cols' => 'Le numero de columnas pro iste entrata',
	'sf_forminputs_autogrow' => 'Facer iste entrata crescer in dimension si le texto excede su limite',
	'sf_forminputs_valuesfromproperty' => 'Un proprietate de que le valores in le wiki debe esser le insimul de valores de iste entrata',
	'sf_forminputs_valuesfromcategory' => 'Un categoria de que le paginas debe esser le insimul de valores de iste entrata',
	'sf_forminputs_valuesfromnamespace' => 'Un spatio de nomines de que le paginas debe esser le insimul de valores de iste entrata',
	'sf_forminputs_valuesfromconcept' => 'Un pagina de "concepto" de Semantic MediaWiki de que le paginas debe esser le insimul de valores de iste entrata',
	'sf_forminputs_valuesfromurl' => 'Un URL continente datos structurate que debe esser le insimul de valores de iste entrata',
	'sf_forminputs_values' => 'Le insimul de valores pro iste entrata, separate per commas',
	'sf_forminputs_list' => 'Marcar iste entrata como continente un lista de valores',
	'sf_forminputs_delimiter' => 'Le delimitator inter valores de campo, si iste entrata contine un lista de illos',
	'sf_forminputs_remoteautocompletion' => 'Usar autocompletion remote',
	'sf_forminputs_existingvaluesonly' => 'Permitter solmente valores ja presente in le lista',
	'sf_forminputs_showonselect' => 'Elementos de pagina a monstrar solmente si certe valores es seligite (exemplo: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => 'Le altitude de iste quadro de lista, in lineas',
	'sf_forminputs_includetimezone' => 'Includer un entrata pro le fuso horari',
	'sf_forminputs_topcategory' => 'Le categoria genitor de iste insimul de categorias (obligatori)',
	'sf_forminputs_hideroot' => 'Celar le categoria genitor',
	'sf_forminputs_depth' => 'Le numero de nivellos de categorias a monstrar initialmente',
	'sf_forminputs_height' => 'Le altitude de iste entrata, in pixeles',
	'sf_forminputs_width' => 'Le latitude de iste entrata, in pixeles',
	'createform' => 'Crear un formulario',
	'sf_createform_nameinput' => 'Nomine del formulario',
	'sf_createform_nameinputdesc' => '(es costumari dar al formulario le nomine de su patrono principal):',
	'sf_createform_template' => 'Patrono:',
	'sf_createform_templatelabelinput' => 'Etiquetta del patrono (optional):',
	'sf_createform_allowmultiple' => 'Permitter multiple (o zero) instantias de iste patrono in le pagina create',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Iste campo defini le proprietate $1, del typo $2.',
	'sf_createform_fieldproplist' => 'Iste campo defini un lista de elementos que ha le proprietate $1, del typo $2.',
	'sf_createform_fieldpropunknowntype' => 'Iste campo defini le proprietate $1, de un typo non specificate.',
	'sf_createform_inputtype' => 'Typo de entrata:',
	'sf_createform_inputtypedefault' => '(predefinition)',
	'sf_createform_formlabel' => 'Etiquetta de formulario:',
	'sf_createform_hidden' => 'Celate',
	'sf_createform_removetemplate' => 'Remover patrono',
	'sf_createform_addtemplate' => 'Adder patrono:',
	'sf_createform_beforetemplate' => 'Ante patrono:',
	'sf_createform_atend' => 'Al fin',
	'sf_createform_add' => 'Adder',
	'sf_createform_choosefield' => 'Selige un campo a adder',
	'createcategory' => 'Crear un categoria',
	'sf_createcategory_name' => 'Nomine del categoria:',
	'sf_createcategory_defaultform' => 'Formulario predefinite:',
	'sf_createcategory_makesubcategory' => 'Facer isto un subcategoria de un altere categoria (optional):',
	'createclass' => 'Crear un classe',
	'sf_createclass_docu' => 'Entra tote le datos hic pro crear le proprietates, patrono, formulario e categoria pro un singule classe. Pro plus optiones, usa le paginas $1 in loco de iste.',
	'sf_createclass_allowedvalues' => 'Valores permittite:',
	'sf_createclass_listofvalues' => 'Lista de valores?',
	'sf_createclass_nameinput' => 'Nomine del formulario:',
	'sf_createclass_missingvalues' => 'Non tote le campos requirite ha essite completate.',
	'sf_createclass_success' => 'Proprietates, patrono, formulario e categoria essera create.',
	'sf_createclass_create' => 'Crear',
	'formstart' => 'Adder pagina con formulario',
	'sf_formstart_badform' => 'Error: nulle pagina de formulario esseva trovate a $1',
	'sf_formstart_badtitle' => 'Error: "$1" es un titulo invalide pro un pagina.',
	'sf_formstart_docu' => "Entra le nomine de un pagina hic, pro esser modificate con le formulario '$1'.
Si iste pagina existe ja, tu essera inviate al formulario pro modificar ille pagina.
Alteremente, tu essera inviate al formulario pro adder le pagina.",
	'sf_formstart_noform_docu' => 'Entra hic le nomine del pagina, e selige le formulario con le qual modificar lo.
Si iste pagina ja existe, tu essera inviate al formulario pro modificar ille pagina.
Alteremente, tu esserea inviate al formulario pro modificar le pagina.',
	'sf_formstart_createoredit' => 'Crear o modificar',
	'formedit' => 'Modificar con formulario',
	'sf_formedit_createtitle' => 'Crear $1: $2',
	'sf_formedit_createtitlenotarget' => 'Crear $1',
	'sf_formedit_badurl' => "Isto es le pagina pro modificar con un formulario. Tu debe specificar e un nomine de formulario e un pagina de destination in le adresse URL; illo debe resimilar 'Special:FormEdit?form=<nomine del formulario>&target=<pagina de destination>', o  'Special:FormEdit/<nomine del formulario>/<pagina de destination>'.",
	'sf_formedit_altforms' => 'Tu pote, in loco de isto, adder iste pagina con un del sequente formularios:',
	'sf_formedit_altformsonly' => 'Per favor selige un del sequente formularios pro adder iste pagina:',
	'sf_formcreate' => 'Crear con formulario',
	'sf_viewform' => 'Vider formulario',
	'sf_editsource' => 'Modificar fonte',
	'sf_formedit_edittitle' => 'Modificar $1: $2',
	'sf_formedit_morethanoneform' => 'Attention: Plus de un formulario predefinite es definite pro iste pagina.',
	'sf_formedit_formwarning' => 'Attention: Iste pagina <a href="$1">jam existe</a>, ma illo non usa iste formulario.',
	'sf_formedit_mismatchedbrackets' => 'Attention: Iste pagina contine parentheses crispe o quadrate que non es claudite, de sorta que le pagina non essera maneate correctemente per le formulario. Per favor <a href="$1">repara le error in le texto fonte</a> ante de continuar.',
	'sf_formedit_remove' => 'Remover',
	'sf_formedit_addanother' => 'Adder un altere',
	'sf_formedit_none' => 'Nulle',
	'sf_formedit_emptytitle' => 'Error: Le datos inserite resulta in un titulo de pagina vacue.',
	'sf_formedit_hookerror' => 'Error: Un extension de MediaWiki impediva le modification del articulo de destination.',
	'sf_formedit_saveandcontinueediting' => 'Salveguardar e continuar',
	'sf_formedit_saveandcontinue_summary' => 'Salveguardate con button "$1" in formulario',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Salveguardar le datos e continuar le modification',
	'sf_autoedit_anoneditwarning' => 'Attention: Tu non ha aperite un session. Tu adresse IP essera registrate in le historia de modificationes de iste pagina.',
	'sf_autoedit_success' => '[[$1]] ha essite modificate usante le formulario $2.',
	'sf_autoedit_notargetspecified' => 'Nulle pagina de destination specificate.',
	'sf_autoedit_noformfound' => 'Nulle formulario specificate.',
	'sf_autoedit_toomanyformsfound' => 'Plus de un formulario es disponibile pro iste pagina.',
	'sf_autoedit_readonly' => 'Le base de datos es actualmente blocate contra modificationes. Motivo: $1',
	'sf_autoedit_nosemanticform' => 'Non poteva obtener le formulario $2 pro le pagina $1. Vide [[{{#special:FormEdit}}/$2/$1]] pro detalios.',
	'sf_autoedit_summary' => 'Modificate automaticamente ab le pagina $1.',
	'sf-autoedit-wait' => 'Un momento...',
	'runquery' => 'Executar consulta',
	'sf_runquery_badurl' => "Es necessari specificar le nomine de un formulario in le URL;
le URL debe esser in le forma 'Special:RunQuery/<nomine del formulario>'.",
	'sf_runquery_title' => 'Executar consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta additional',
	'sf_formerrors_header' => 'Il ha errores in lo que tu entrava in le formulario; vide infra',
	'sf_blank_error' => 'non pote esser vacue',
	'sf_bad_url_error' => "le adresse URL debe esser in formato correcte, comenciante con 'http'",
	'sf_bad_email_error' => 'le adresse de e-mail debe esser in formato correcte',
	'sf_bad_number_error' => 'debe esser un numero valide',
	'sf_bad_date_error' => 'debe esser un data valide',
	'uploadwindow' => 'Fenestra de incargamento',
	'sf_deletionlog' => 'registro de deletiones',
	'sf-preview-header' => 'Previsualisation de formulario',
	'sf-preview-note' => 'Ecce le aspecto del formulario in uso:',
	'sf-pageschemas-pagenameformula' => 'Formula pro nomines de pagina:',
	'sf-pageschemas-createtitle' => 'Titulo del formulario pro nove paginas:',
	'sf-pageschemas-edittitle' => 'Titulo del formulario pro paginas existente:',
	'sf-pageschemas-inputtype' => 'Typo de entrata (lassar vacue pro usar le predefinition):',
	'sf_property_isproperty' => 'Isto es un proprietate del typo $1.',
	'sf_property_linkstoform' => 'Illo liga verso paginas que usa le formulario $1.',
	'sf_property_allowedvals' => 'Le {{PLURAL:$1|valor|valores}} permittite pro iste proprietate es:',
	'sf_template_docu' => "Isto es le patrono '$1'.
Illo debe esser appellate in le formato sequente:",
	'sf_template_docufooter' => 'Modifica le pagina pro vider le texto del patrono.',
	'sf_form_docu' => 'Isto es le formulario "$1".
Pro crear un pagina con iste formulario, entra le nomine del pagina in basso;
si un pagina con iste nomine ja existe, tu essera inviate a un formulario pro modificar iste pagina.',
	'sf_form_freetextlabel' => 'Texto libere',
	'sf_category_hasdefaultform' => 'Iste categoria usa le formulario $1.',
	'sf_category_desc' => 'Isto es le categoria $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Vider le scheda "Modificar" pro paginas modificabile per formulario', # Fuzzy
	'right-editrestrictedfields' => 'Modificar le campos restringite de formularios',
	'right-createclass' => 'Crear nove classes semantic',
	'action-createclass' => 'crear nove classes semantic',
	'action-editrestrictedfields' => 'modificar le campos restringite de formularios',
	'action-viewedittab' => 'vider le scheda "Modificar" pro paginas modificabile per formulario', # Fuzzy
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Farras
 * @author Irwangatot
 * @author IvanLanin
 * @author Rex
 */
$messages['id'] = array(
	'semanticforms-desc' => 'Formulir untuk menambahkan dan menyunting data semantik',
	'specialpages-group-sf_group' => 'Semantic Forms',
	'createproperty' => 'Buat properti',
	'sf_createproperty_linktoform' => 'Properti ini akan tertaut ke halaman yang menggunakan formulir:',
	'sf_createproperty_allowedvalsinput' => 'Jika Anda ingin properti ini hanya diizinkan untuk memiliki suatu nilai tertentu, masukkan daftar nilai yang diizinkan, dipisahkan dengan koma (jika suatu nilai mengandung koma, ganti dengan "\\,"):',
	'sf_createproperty_propname' => 'Nama properti:',
	'sf_createproperty_proptype' => 'Tipe:',
	'templates' => 'Templat',
	'sf_templates_docu' => 'Templat berikut ada di wiki ini',
	'sf_templates_definescat' => 'mendefinisikan kategori: $1',
	'createtemplate' => 'Buat templat',
	'sf_createtemplate_namelabel' => 'Nama templat:',
	'sf_createtemplate_categorylabel' => 'Kategori yang didefinisikan oleh templat (opsional):',
	'sf_createtemplate_templatefields' => 'Kolom templat',
	'sf_createtemplate_fieldsdesc' => 'Untuk membuat kolom pada templat ini tidak lagi membutuhkan nama kolom, masukkan saja indeks masing-masing kolom (mis. 1, 2, 3, dll.) sebagai nama, dan bukan nama yang sebenarnya.',
	'sf_createtemplate_fieldname' => 'Nama kolom:',
	'sf_createtemplate_displaylabel' => 'Label tampilan:',
	'sf_createtemplate_semanticproperty' => 'Properti semantik:',
	'sf_createtemplate_fieldislist' => 'Kolom ini dapat menampung daftar nilai, dipisahkan oleh koma',
	'sf_createtemplate_aggregation' => 'Agregasi',
	'sf_createtemplate_aggregationdesc' => 'Untuk memberikan daftar, pada setiap halaman yang menggunakan templat ini, semua halaman yang memiliki properti tertentu yang merujuk ke halaman tersebut, tentukan properti yang sesuai di bawah ini:',
	'sf_createtemplate_aggregationlabel' => 'Judul daftar:',
	'sf_createtemplate_outputformat' => 'Format keluaran:',
	'sf_createtemplate_standardformat' => 'Standar', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Kotak info di sisi kanan', # Fuzzy
	'sf_createtemplate_addfield' => 'Tambahkan kolom',
	'sf_createtemplate_deletefield' => 'Hapus',
	'sf_createtemplate_addtemplatebeforesave' => 'Anda harus memberikan paling tidak satu templat untuk formulir ini sebelum dapat menyimpannya.',
	'forms' => 'Formulir',
	'sf_forms_docu' => 'Formulir berikut ada di wiki ini.',
	'sf_forminputs_mandatory' => 'Diwajibkan',
	'sf_forminputs_restricted' => 'Hanya administrator yang dapat menyunting masukan ini',
	'sf_forminputs_class' => 'Atribut HTML "class" untuk masukan ini',
	'sf_forminputs_default' => 'Nilai bawaan untuk masukan ini',
	'sf_forminputs_preload' => 'Halaman wiki yang isinya akan menjadi nilai bawaan masukan ini',
	'sf_forminputs_property' => 'Properti semantik yang berkaitan dengan bidang ini',
	'sf_forminputs_size' => 'Ukuran bidang teks ini (dalam karakter)',
	'sf_forminputs_maxlength' => 'Panjang teks maksimum yang diperbolehkan untuk bidang ini',
	'sf_forminputs_uploadable' => 'Tempatkan pranala "Unggah berkas" di samping masukan ini', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Nama berkas bawaan untuk pengunggahan berkas',
	'sf_forminputs_rows' => 'Jumlah baris untuk masukan ini',
	'sf_forminputs_cols' => 'Jumlah kolom untuk masukan ini',
	'sf_forminputs_autogrow' => 'Setel agar masukan ini dapat meluas ukurannya jika teks melebihi batas',
	'sf_forminputs_valuesfromproperty' => 'Properti wiki yang nilainya menjadi nilai untuk masukan ini',
	'sf_forminputs_valuesfromcategory' => 'Kategori yang halamannya menjadi nilai untuk masukan ini',
	'sf_forminputs_valuesfromnamespace' => 'Ruang nama yang halamannya menjadi nilai untuk masukan ini',
	'sf_forminputs_valuesfromconcept' => 'Halaman "konsep" Semantic MediaWiki yang halamannya menjadi nilai masukan ini',
	'sf_forminputs_valuesfromurl' => 'URL penyimpan data terstruktur yang harus menjadi set nilai masukan ini',
	'sf_forminputs_values' => 'Set nilai masukan ini, dipisahkan oleh koma',
	'sf_forminputs_list' => 'Tandai masukan ini menyimpan daftar nilai',
	'sf_forminputs_delimiter' => 'Pembatas antara nilai bidang, jika masukan ini menyimpan daftar nilai berbagai bidang',
	'sf_forminputs_remoteautocompletion' => 'Gunakan pelengkapan otomatis jarak jauh',
	'sf_forminputs_existingvaluesonly' => 'Hanya izinkan nilai yang sudah ada dalam daftar',
	'sf_forminputs_showonselect' => 'Elemen halaman yang ditampilkan hanya jika nilai tertentu dipilih (contoh: "nilai1=>div1;nilai2=>div2")',
	'sf_forminputs_listboxsize' => 'Tinggi kotak daftar ini, dalam baris',
	'sf_forminputs_includetimezone' => 'Sertakan masukan untuk zona waktu',
	'sf_forminputs_topcategory' => 'Kategori induk dari set kategori ini (wajib diisi)',
	'sf_forminputs_height' => 'Tinggi masukan, dalam piksel',
	'sf_forminputs_width' => 'Lebar masukan, dalam piksel',
	'createform' => 'Buat formulir',
	'sf_createform_nameinput' => 'Nama formulir',
	'sf_createform_nameinputdesc' => '(formulir ini biasanya diberi nama yang sama dengan templat utamanya):',
	'sf_createform_template' => 'Templat:',
	'sf_createform_templatelabelinput' => 'Label templat (opsional):',
	'sf_createform_allowmultiple' => 'Izinkan beberapa (atau nol) templat ini di halaman yang dibuat',
	'sf_createform_field' => 'Kolom:',
	'sf_createform_fieldprop' => 'Kolom ini menentukan properti $1 yang bertipe $2.',
	'sf_createform_fieldproplist' => 'Kolom ini menentukan beberapa elemen yang memiliki properti $1 bertipe $2.',
	'sf_createform_fieldpropunknowntype' => 'Kolom ini menentukan properti $1 yang tipenya tidak ditentukan.',
	'sf_createform_inputtype' => 'Tipe masukan:',
	'sf_createform_inputtypedefault' => '(baku)',
	'sf_createform_formlabel' => 'Label formulir:',
	'sf_createform_hidden' => 'Tersembunyi',
	'sf_createform_removetemplate' => 'Hapus templat',
	'sf_createform_addtemplate' => 'Tambah templat:',
	'sf_createform_beforetemplate' => 'Sebelum templat:',
	'sf_createform_atend' => 'Di akhir',
	'sf_createform_add' => 'Tambahkan',
	'sf_createform_choosefield' => 'Pilih kolom untuk ditambahkan',
	'createcategory' => 'Buat kategori',
	'sf_createcategory_name' => 'Nama kategori:',
	'sf_createcategory_defaultform' => 'Formulir baku:',
	'sf_createcategory_makesubcategory' => 'Jadikan sebagai subkategori dari kategori lain (opsional):',
	'createclass' => 'Buat kelas',
	'sf_createclass_docu' => 'Masukkan semua data di sini untuk membuat properti, tempat, formulir, dan kategori untuk suatu kelas tunggal. Untuk lebih banyak pilihan, gunakan halaman $1.',
	'sf_createclass_allowedvalues' => 'Nilai yang diizinkan', # Fuzzy
	'sf_createclass_listofvalues' => 'Daftar nilai', # Fuzzy
	'sf_createclass_missingvalues' => 'Tidak semua kolom yang diperlukan telah diisi.',
	'sf_createclass_success' => 'Properti, templat, formulir, dan kategori akan dibuat.',
	'formstart' => 'Buat halaman dengan formulir',
	'sf_formstart_badform' => 'Kesalahan: halaman formulir tak ditemukan di $1',
	'sf_formstart_badtitle' => 'Kesalahan: "$1" adalah judul yang tidak valid untuk suatu halaman.',
	'sf_formstart_docu' => 'Masukkan nama halaman untuk disunting dengan formulir "$1" di sini.
Jika halaman ini sudah ada, Anda akan diarahkan ke formulir untuk menyunting halaman itu.
Jika belum, Anda akan diarahkan ke formulir untuk menambahkan halaman.',
	'sf_formstart_noform_docu' => 'Masukkan nama halaman di sini dan pilih formulir untuk menyuntingnya.
Jika halaman ini sudah ada, Anda akan diarahkan ke formulir untuk menyunting halaman itu.
Jika belum, Anda akan diarahkan ke formulir untuk menambahkan halaman.',
	'sf_formstart_createoredit' => 'Buat atau sunting',
	'formedit' => 'Sunting dengan formulir',
	'sf_formedit_createtitle' => 'Buat $1: $2',
	'sf_formedit_createtitlenotarget' => 'Buat $1',
	'sf_formedit_badurl' => "Ini adalah halaman untuk menyunting menggunakan formulir. Anda harus memberikan baik nama formulir maupun nama halaman target di URL;
bentuknya harus seperti 'Special:FormEdit?form=<form name>&target=<target page>', atau 'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'Sebagai gantinya, Anda dapat menambahkan halaman ini dengan salah satu dari formulir berikut:',
	'sf_formedit_altformsonly' => 'Silakan pilih salah satu dari formulir berikut untuk menambah halaman ini:',
	'sf_formcreate' => 'Buat dengan formulir',
	'sf_viewform' => 'Lihat formulir',
	'sf_editsource' => 'Sunting sumber',
	'sf_formedit_edittitle' => 'Sunting $1: $2',
	'sf_formedit_morethanoneform' => "'''Peringatan:''' Lebih dari satu formulir baku ditentukan untuk halaman ini.",
	'sf_formedit_formwarning' => 'Peringatan: Halaman ini <a href="$1">telah ada</a> tapi tidak menggunakan formulir ini.',
	'sf_formedit_remove' => 'Hapus',
	'sf_formedit_addanother' => 'Tambah lagi',
	'sf_formedit_none' => 'Tidak ada',
	'sf_formedit_emptytitle' => 'Galat: Data yang disisipkan menghasilkan judul halaman kosong.',
	'sf_formedit_hookerror' => 'Galat: Ekstensi MediaWiki menghalangi modifikasi halaman sasaran.',
	'sf_formedit_saveandcontinueediting' => 'Simpan dan lanjutkan',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Simpan dan lanjutkan penyuntingan',
	'sf_autoedit_anoneditwarning' => 'Peringatan: Anda belum masuk. Alamat IP Anda akan tercatat dalam riwayat suntingan halaman ini.',
	'sf_autoedit_success' => 'Berhasil mengubah [[$1]] dengan menggunakan formulir $2.',
	'runquery' => 'Jalankan query',
	'sf_runquery_badurl' => "Anda harus menentukan suatu nama formulir di URL;
bentuknya harus seperti 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'Jalankan query: $1',
	'sf_runquery_additionalquery' => 'Query tambahan',
	'sf_formerrors_header' => 'Ada kesalahan pada masukan formulir Anda; lihat di bawah',
	'sf_blank_error' => 'tidak boleh kosong',
	'sf_bad_url_error' => "harus memiliki format URL yang benar, dimulai dengan 'http'",
	'sf_bad_email_error' => 'harus memiliki format alamat surel yang benar',
	'sf_bad_number_error' => 'harus berupa angka',
	'sf_bad_date_error' => 'harus berupa tanggal',
	'uploadwindow' => 'Jendela pengunggahan',
	'sf_deletionlog' => 'Log penghapusan',
	'sf_property_isproperty' => 'Ini adalah properti bertipe $1',
	'sf_property_linkstoform' => 'Ia terhubung dengan halaman yang menggunakan formulir $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Nilai|Nilai}} yang diizinkan untuk properti ini adalah:',
	'sf_template_docu' => 'Ini adalah templat "$1".
Ia harus dipanggil dengan format berikut:',
	'sf_template_docufooter' => 'Sunting halaman ini untuk melihat teks templat.',
	'sf_form_docu' => 'Ini adalah formulir "$1".
Untuk menambah halaman dengan menggunakan formulir ini, masukkan nama halaman di bawah ini;
jika halaman dengan nama tersebut sudah ada, Anda akan diarahkan ke formulir untuk menyunting halaman tersebut.',
	'sf_form_freetextlabel' => 'Teks bebas',
	'sf_category_hasdefaultform' => 'Kategori ini menggunakan formulir $1.',
	'sf_category_desc' => 'Ini adalah kategori $1.',
	'sf_blank_namespace' => 'Utama',
	'right-viewedittab' => 'Lihat tab "Sunting" untuk menyunting halaman dengan formulir', # Fuzzy
	'right-editrestrictedfields' => 'Sunting kolom formulir terbatas',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'sf_createtemplate_deletefield' => 'Kàcha',
	'sf_createform_template' => 'Àtụ:',
	'sf_createform_add' => 'Tinyé',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'templates' => 'Shabloni',
	'sf_createform_template' => 'Shablono:',
);

/** Icelandic (íslenska)
 * @author S.Örvarr.S
 */
$messages['is'] = array(
	'sf_createproperty_propname' => 'Nafn:', # Fuzzy
	'sf_createtemplate_standardformat' => 'Staðlað', # Fuzzy
	'sf_createcategory_name' => 'Nafn:', # Fuzzy
);

/** Italian (italiano)
 * @author Alessandro Rosà
 * @author Beta16
 * @author Civvì
 * @author Darth Kule
 * @author F. Cosoleto
 * @author Melos
 */
$messages['it'] = array(
	'semanticforms-desc' => 'Modulo per aggiungere e modificare dati semantici',
	'specialpages-group-sf_group' => 'Moduli semantici',
	'createproperty' => 'Crea una proprietà',
	'sf-createproperty-with-name' => 'Crea proprietà: $1',
	'sf_createproperty_linktoform' => 'Questa proprietà ti collegherà alla pagina che usa il seguente modulo:',
	'sf_createproperty_allowedvalsinput' => 'Se vuoi che questa proprietà possa ammettere solo determinati valori, inserisci una lista di valori ammessi, separati da virgole (se un valore presenta una virgola, sostituiscilo con mettendoci un backslash davanti in questo modo "\\,"):',
	'sf_createproperty_propname' => 'Nome proprietà:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Template',
	'sf_templates_docu' => 'Il seguente template già esiste nel wiki.',
	'sf_templates_definescat' => 'Definisci categorie: $1',
	'createtemplate' => 'Crea un nuovo template',
	'sf-createtemplate-with-name' => 'Crea template: $1',
	'sf_createtemplate_namelabel' => 'Nome template:',
	'sf_createtemplate_multipleinstance' => 'Questo template può essere incluso più volte nella pagina.',
	'sf_createtemplate_categorylabel' => 'Categorie definite attraverso template (opzionale):',
	'sf_createtemplate_templatefields' => 'Campi template',
	'sf_createtemplate_fieldsdesc' => "Per richiamare i campi di questo template non è necessario usare il loro nome, semplicemente inserisci il numero d'indice del campo (per esempio 1, 2, 3, etc) al posto del nome.",
	'sf_createtemplate_fieldname' => 'Nome campo:',
	'sf_createtemplate_displaylabel' => 'Etichetta da mostrare:',
	'sf_createtemplate_semanticproperty' => 'Proprietà semantiche:',
	'sf_createtemplate_fieldislist' => 'Questo campo può contenere una lista di valori, separati dalle virgole',
	'sf_createtemplate_aggregation' => 'Aggregazione',
	'sf_createtemplate_aggregationdesc' => 'Per vedere, fra le pagine che usano questo template, tutte le pagine che hanno una proprietà che punta a questa pagina, specifica la appropriata proprietà qui sotto:',
	'sf_createtemplate_aggregationlabel' => 'Titolo per la lista:',
	'sf_createtemplate_outputformat' => 'Formato di output:',
	'sf_createtemplate_standardformat' => 'Tabella',
	'sf_createtemplate_infoboxformat' => 'Infobox laterale',
	'sf_createtemplate_plainformat' => 'Testo normale',
	'sf_createtemplate_sectionsformat' => 'Sezioni',
	'sf_createtemplate_addfield' => 'Aggiungi campo',
	'sf_createtemplate_deletefield' => 'Cancella',
	'sf_createtemplate_addtemplatebeforesave' => 'Devi aggiungere almeno un template a questo modulo prima di poterlo salvare.',
	'forms' => 'Moduli',
	'sf_forms_docu' => 'I seguenti moduli già esistono nel wiki.',
	'sf_forminputs_mandatory' => 'Obbligatorio',
	'sf_forminputs_restricted' => 'Solo gli amministratori possono modificare questo input',
	'sf_forminputs_class' => 'L\'attributo HTML "class" per questo input',
	'sf_forminputs_default' => 'Il valore predefinito per questo input',
	'sf_forminputs_preload' => 'Una pagina wiki il cui contenuto diventerà il valore predefinito di questo input',
	'sf_forminputs_property' => 'Una proprietà semantica a cui questo campo corrisponde',
	'sf_forminputs_size' => 'La dimensione di questo campo di testo, in caratteri',
	'sf_forminputs_maxlength' => 'La lunghezza di testo massima permessa in questo campo',
	'sf_forminputs_placeholder' => "Testo d'aiuto mostrato nell'input fino a quando l'utente fa clic su di esso",
	'sf_forminputs_uploadable' => 'Inserisci un link "{{int:upload}}" vicino a questo input',
	'sf_forminputs_defaultfilename' => 'Il nome di file predefinito per i file caricati',
	'sf_forminputs_rows' => 'Il numero di righe per questo input',
	'sf_forminputs_cols' => 'Il numero di colonne per questo input',
	'sf_forminputs_valuesfromproperty' => "Una proprietà i cui valori nel wiki dovrebbero essere l'insieme di valori di questo input",
	'sf_forminputs_valuesfromcategory' => "Una categoria le cui pagine dovrebbero essere l'insieme di valori di questo input",
	'sf_forminputs_valuesfromnamespace' => "Un namespace le cui pagine dovrebbero essere l'insieme di valori di questo input",
	'sf_forminputs_valuesfromurl' => "Un URL contenente dati strutturati che dovrebbero essere l'insieme di valori di questo input",
	'sf_forminputs_values' => "L'insieme di valori di questo input, separati da virgole",
	'sf_forminputs_delimiter' => 'Il delimitatore tra i valori dei campi, se questo input contiene un elenco di essi',
	'sf_forminputs_remoteautocompletion' => 'Usa il completamento automatico remoto',
	'sf_forminputs_existingvaluesonly' => 'Consenti solo i valori già nella lista',
	'sf_forminputs_showonselect' => 'Elementi di pagina da visualizzare solo se sono selezionati certi valori (esempio: "valore1=>div1;valore2=>div2")',
	'sf_forminputs_listboxsize' => "L'altezza di questo controllo listbox, in righe",
	'sf_forminputs_includetimezone' => 'Includi un input per il fuso orario',
	'sf_forminputs_topcategory' => 'La categoria superiore di questo insieme di categorie (obbligatorio)',
	'sf_forminputs_depth' => 'Il numero di livelli di categorie da mostrare inizialmente',
	'sf_forminputs_height' => "L'altezza di questo input, in pixel",
	'sf_forminputs_width' => 'La larghezza di questo input, in pixel',
	'createform' => 'Crea un nuovo modulo',
	'sf-createform-with-name' => 'Crea modulo: $1',
	'sf_createform_nameinput' => 'Nome modulo',
	'sf_createform_nameinputdesc' => '(la convenzione vuole che il nome del modulo sia lo stesso del template principale):',
	'sf_createform_template' => 'Template:',
	'sf_createform_templatelabelinput' => 'Nome da visualizzare del template (opzionale):',
	'sf_createform_allowmultiple' => 'Permetti multiple (o nessuna) istanze di questo template nella pagina creata',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Questo campo definisce le proprietà  $1, di tipo $2.',
	'sf_createform_fieldproplist' => 'Questo campo definisce una lista di elementi che ha la proprietà $1, di tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Questo campo definisce la proprietà $1, di tipo non specificato.',
	'sf_createform_inputtype' => 'Tipo input:',
	'sf_createform_inputtypedefault' => '(predefinito)',
	'sf_createform_formlabel' => 'Etcihetta del modulo:',
	'sf_createform_hidden' => 'Nascosto',
	'sf_createform_removetemplate' => 'Rimuovi template',
	'sf_createform_addtemplate' => 'Aggiungi template:',
	'sf_createform_beforetemplate' => 'Template precedente:',
	'sf_createform_atend' => 'Alla fine:',
	'sf_createform_add' => 'Aggiungi',
	'sf_createform_choosefield' => 'Scegli campo da aggiungere',
	'createcategory' => 'Crea una categoria',
	'sf-createcategory-with-name' => 'Crea categoria: $1',
	'sf_createcategory_name' => 'Nome categoria:',
	'sf_createcategory_defaultform' => 'Modulo predefinito:',
	'sf_createcategory_makesubcategory' => 'Falla diventare una sottocategoria di una categoria già presente (opzionale):',
	'createclass' => 'Crea una classe',
	'sf_createclass_docu' => 'Aggiungi qui tutte le informazioni per creare le proprietà, i template, i moduli e le categoria per una singola classe. Per ulteriori opzioni invece vai alla pagina $1.',
	'sf_createclass_allowedvalues' => 'Valori consentiti:',
	'sf_createclass_listofvalues' => 'Lista di valori?',
	'sf_createclass_nameinput' => 'Nome modulo:',
	'sf_createclass_missingvalues' => 'Campi richiesti non completamente riempiti.',
	'sf_createclass_success' => 'Proprietà, template, moduli e categorie verranno create.',
	'sf_createclass_create' => 'Crea',
	'formstart' => 'Aggiungi pagina usando un modulo',
	'sf_formstart_badform' => 'Errore: nessun modulo è stato trovato alla pagina $1',
	'sf_formstart_badtitle' => 'Errore: "$1" non è un titolo valido per la pagina',
	'sf_formstart_docu' => "Inserisci il nome della pagina qui, per esser modificata con il modulo '$1'.
Se questa pagina esiste già, verrai indirizzato ad un modulo che ti permette di modificarla.
Altrimenti, verrai indirizzato ad un nuovo modulo che ti permetterà di aggiungere la nuova pagina.",
	'sf_formstart_noform_docu' => 'Inserisci il nome della pagina qui, e selezione il modulo con cui la vuoi modificare.
	Se questa pagina esiste già, verrai indirizzato ad un modulo che ti permette di modificarla.
	Altrimenti, verrai indirizzato ad un nuovo modulo che ti permetterà di aggiungere la nuova pagina.',
	'sf_formstart_createoredit' => 'Crea o modifica',
	'formedit' => 'Modifica tramite un modulo',
	'sf_formedit_createtitle' => 'Crea $1: $2',
	'sf_formedit_createtitlenotarget' => 'Crea $1',
	'sf_formedit_badurl' => "Questa è la pagina per modificare i dati inseriti tramite un modulo. Nell'URL devi specificare sia il nome del modulo e sia la pagina da modificare;
dovrebbe risultare una cosa di questo tipo 'Special:FormEdit?form=<form name>&target=<target page>', oppure 'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'Invece puoi aggiungere una pagina con uno dei seguenti moduli già creati:',
	'sf_formedit_altformsonly' => 'Per favore seleziona una dei seguenti moduli per aggiungere questa pagina:',
	'sf_formcreate' => 'Crea con un modulo',
	'sf_viewform' => 'Visualizza modulo',
	'sf_editsource' => 'Modifica sorgente',
	'sf_formedit_edittitle' => 'Modifica $1: $2',
	'sf_formedit_morethanoneform' => "'''Attenzione:''' Più di un modulo predefinito è stato definito per questa pagina.",
	'sf_formedit_formwarning' => 'Attenzione: Questa pagina <a href="$1">esiste già</a>, ma non usa questo form.',
	'sf_formedit_mismatchedbrackets' => 'Attenzione: questa pagina contiene parentesi quadre o graffe non chiuse, quindi la pagina non sarà gestita correttamente dal modulo. <a href="$1">Correggere l\'errore nel testo di origine</a> prima di procedere.',
	'sf_formedit_remove' => 'Rimuovi', # Fuzzy
	'sf_formedit_addanother' => 'Aggiungi un altro',
	'sf_formedit_none' => 'Nessuno',
	'sf_formedit_hookerror' => "Errore: un'estensione MediaWiki ha impedito la modifica della pagina di destinazione.",
	'sf_formedit_saveandcontinueediting' => 'Salva e continua',
	'sf_formedit_saveandcontinue_summary' => 'Salvato utilizzando il pulsante "$1" nel modulo',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Salva i dati e continua a modificare',
	'sf_autoedit_anoneditwarning' => 'Attenzione: non si sta accedendo al sito come utente, il proprio indirizzo IP sarà registrato nella cronologia di questa pagina.',
	'sf_autoedit_success' => '[[$1]] modificato correttamente utilizzando il modulo $2.',
	'sf_autoedit_notargetspecified' => 'Nessuna pagina di destinazione specificata.',
	'sf_autoedit_invalidtargetspecified' => 'La pagina di destinazione specificata $1 non è valida.',
	'sf_autoedit_invalidform' => '$1 non è un modulo valido.',
	'sf_autoedit_redirectlimitexeeded' => 'Il limite massimo redirect per il modulo $1 è stato superato.',
	'sf_autoedit_redlinkexists' => '$1 già esistente.',
	'sf_autoedit_noformfound' => 'Nessun modulo specificato.',
	'sf_autoedit_toomanyformsfound' => 'Più di un modulo disponibile per pagina.',
	'sf_autoedit_readonly' => 'Il database è attualmente bloccato per le modifiche. Motivo: $1',
	'sf_autoedit_nosemanticform' => 'Impossibile ottenere il modulo $2 per la pagina $1. Vedere [[{{#special:FormEdit}}/$2/$1]] per maggiori dettagli.',
	'sf_autoedit_summary' => 'Modificato automaticamente dalla pagina $1.',
	'sf-autoedit-wait' => 'Attendere prego...',
	'runquery' => 'Esegui query',
	'sf_runquery_badurl' => "Devi specificare il nome del form nell'\\ URL;
l'\\ URL dovrebbe risultare una cosa di questo tipo 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'Esegui query: $1',
	'sf_runquery_additionalquery' => 'Query aggiuntive',
	'sf_formerrors_header' => 'Ci sono stati degli errori nel form di input; vedi qui sotto',
	'sf_blank_error' => 'Non può esser vuoto',
	'sf_bad_url_error' => "Deve avere un formato dell'\\URL corretto, completo anche di 'http'",
	'sf_bad_email_error' => 'Deve avere un formato per di indirizzo email valido',
	'sf_bad_number_error' => "Dev'\\esser un numero valido",
	'sf_bad_date_error' => "Dev'\\esser una data valida",
	'uploadwindow' => 'Finestra di upload',
	'sf_deletionlog' => 'Log cancellazioni',
	'sf-preview-header' => 'Anteprima modulo',
	'sf-preview-note' => 'Il modulo apparirà così quando sarà usato:',
	'sf-pageschemas-createtitle' => 'Titolo del modulo per le nuove pagine:',
	'sf-pageschemas-edittitle' => 'Titolo del modulo per le pagine esistenti:',
	'sf-pageschemas-inputtype' => 'Tipo di input (lasciare vuoto per impostare al valore predefinito):',
	'sf_property_isproperty' => 'Questa è una proprietà di tipo $1.',
	'sf_property_linkstoform' => 'Ti collegherà alle pagine che usano il modulo $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Il valore permesso per questa proprità è|I valori permessi per questa proprietà sono}}:',
	'sf_template_docu' => "Questo è il template '$1'.
Dovrebbe esser chiamato con il seguente formato:",
	'sf_template_docufooter' => 'Modificare la pagine per vedere il testo del template.',
	'sf_form_docu' => 'Questo è il modulo "$1".
Per creare una pagina con questo modulo, inserire il nome della pagina qui sotto; se la pagina con il nome indicato esiste già, verrai inviato al modulo di modifica della pagina.',
	'sf_form_freetextlabel' => 'Testo libero',
	'sf_category_hasdefaultform' => 'Questa categoria usa il modulo $1.',
	'sf_category_desc' => 'Questa è la categoria $1.',
	'sf_blank_namespace' => 'Principale',
	'right-viewedittab' => 'Visualizza la scheda "{{int:edit}}" per le pagine modificabili tramite modulo',
	'right-editrestrictedfields' => 'Modifica campi riservati di moduli',
	'right-createclass' => 'Crea nuovi classi semantiche',
	'action-createclass' => 'creare nuove classi semantiche',
	'action-editrestrictedfields' => 'modificare i campi riservati dei moduli',
	'action-viewedittab' => 'visualizzare la scheda "{{int:edit}}" per le pagine modificabili tramite modulo',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Hosiryuhosi
 * @author Schu
 * @author Shirayuki
 * @author Whym
 * @author 青子守歌
 */
$messages['ja'] = array(
	'semanticforms-desc' => '意味的データを追加/編集するフォーム',
	'specialpages-group-sf_group' => '意味的フォーム',
	'createproperty' => 'プロパティの作成',
	'sf-createproperty-with-name' => '作成するプロパティ: $1',
	'sf_createproperty_linktoform' => 'このプロパティは、以下のフォームを使用するページにリンクします:',
	'sf_createproperty_allowedvalsinput' => 'このプロパティに一部の値のみを設定できるようにするには、許可する値をカンマで区切って列挙します (値がカンマを含む場合は「\\,」に置換):',
	'sf_createproperty_propname' => 'プロパティ名:',
	'sf_createproperty_proptype' => '型:',
	'templates' => 'テンプレート一覧',
	'sf_templates_docu' => '以下のテンプレートがウィキに存在します。',
	'sf_templates_definescat' => '定義するカテゴリ: $1',
	'createtemplate' => 'テンプレートの作成',
	'sf-createtemplate-with-name' => '作成するテンプレート: $1',
	'sf_createtemplate_namelabel' => 'テンプレート名:',
	'sf_createtemplate_multipleinstance' => 'このテンプレートは、ページで複数回呼び出される場合があります。',
	'sf_createtemplate_categorylabel' => 'テンプレートが定義するカテゴリ (省略可能):',
	'sf_createtemplate_templatefields' => 'テンプレートのフィールド',
	'sf_createtemplate_fieldsdesc' => 'このテンプレートにフィールドを持たせるのにフィールド名は不要です。実際の名前の代わりに、単に各フィールドの番号 (1、2、3、など) を名前として入力してください。',
	'sf_createtemplate_fieldname' => 'フィールド名:',
	'sf_createtemplate_displaylabel' => '表示ラベル:',
	'sf_createtemplate_semanticproperty' => '意味的プロパティ:',
	'sf_createtemplate_fieldislist' => 'このフィールドが複数の値をカンマで区切った列挙を保持できるようにする',
	'sf_createtemplate_aggregation' => '集約',
	'sf_createtemplate_aggregationdesc' => 'このテンプレートを使用しているページで、そのページを指すプロパティを持つすべての記事を列挙するには、該当プロパティを以下に指定してください:',
	'sf_createtemplate_aggregationlabel' => '一覧の名前:',
	'sf_createtemplate_outputformat' => '出力形式:',
	'sf_createtemplate_standardformat' => '表',
	'sf_createtemplate_infoboxformat' => '端の情報ボックス',
	'sf_createtemplate_plainformat' => 'プレーンテキスト',
	'sf_createtemplate_sectionsformat' => '節',
	'sf_createtemplate_addfield' => 'フィールドを追加',
	'sf_createtemplate_deletefield' => '削除',
	'sf_createtemplate_addtemplatebeforesave' => '保存する前に、このフォームにテンプレートを少なくとも1つ追加する必要があります。',
	'forms' => 'フォーム一覧',
	'sf_forms_docu' => '以下のフォームがウィキに存在します。',
	'sf_forminputs_mandatory' => 'この入力の必須入力の値',
	'sf_forminputs_restricted' => '管理者のみがこの入力を編集できます',
	'sf_forminputs_class' => 'この入力の HTML の "class" 属性',
	'sf_forminputs_default' => 'この入力の既定値',
	'sf_forminputs_preload' => 'その内容がこの入力の既定値になる、ウィキページ',
	'sf_forminputs_size' => 'このテキストフィールドの文字数でのサイズ',
	'sf_forminputs_maxlength' => 'このフィールド内の文字列の最大長',
	'sf_forminputs_uploadable' => 'この入力の隣に「{{int:upload}}」のリンクを配置',
	'sf_forminputs_defaultfilename' => 'アップロードされたファイルの既定のファイル名',
	'sf_forminputs_rows' => 'この入力の行数',
	'sf_forminputs_cols' => 'この入力の列数',
	'sf_forminputs_valuesfromproperty' => 'そのウィキ内の値のプロパティは、この値の入力のセットになります', # Fuzzy
	'sf_forminputs_valuesfromcategory' => 'ページの値のこの入力のセットがあるはずのカテゴリ', # Fuzzy
	'sf_forminputs_valuesfromnamespace' => 'そのページの名前空間は、この値の入力のセットになります', # Fuzzy
	'sf_forminputs_list' => 'この入力が複数の値の列挙を保持できるように印を付ける',
	'sf_forminputs_delimiter' => 'この入力が複数のフィールド値の列挙を保持する場合の、値の間の区切り文字',
	'sf_forminputs_remoteautocompletion' => 'リモート自動補完を使用',
	'sf_forminputs_existingvaluesonly' => '一覧に既にある値のみを許可',
	'sf_forminputs_listboxsize' => 'このリストボックスの高さ (行)',
	'sf_forminputs_includetimezone' => 'タイムゾーンの入力を含める',
	'sf_forminputs_topcategory' => 'カテゴリのこのセットの親カテゴリ (必須)',
	'sf_forminputs_hideroot' => '親カテゴリを非表示',
	'sf_forminputs_depth' => '最初に表示するカテゴリのレベルの数',
	'sf_forminputs_height' => 'この入力の高さ (ピクセル)',
	'sf_forminputs_width' => 'この入力の幅 (ピクセル)',
	'createform' => 'フォームの作成',
	'sf-createform-with-name' => '作成するフォーム: $1',
	'sf_createform_nameinput' => 'フォーム名',
	'sf_createform_nameinputdesc' => '(通常、フォームはメインテンプレートと同じ名前になります):',
	'sf_createform_template' => 'テンプレート:',
	'sf_createform_templatelabelinput' => 'テンプレートのラベル (省略可能):',
	'sf_createform_allowmultiple' => '作成したページでこのテンプレートを複数回使用できるようにする',
	'sf_createform_field' => 'フィールド:',
	'sf_createform_fieldprop' => 'このフィールドではプロパティ $1 (型 $2) を指定します。',
	'sf_createform_fieldproplist' => 'このフィールドは型 $2 のプロパティ $1 を持つ要素一覧を定義します。',
	'sf_createform_fieldpropunknowntype' => 'このフィールドではプロパティ $1 (型は未指定) を指定します。',
	'sf_createform_inputtype' => '入力型:',
	'sf_createform_inputtypedefault' => '(既定)',
	'sf_createform_formlabel' => 'フォームのラベル:',
	'sf_createform_hidden' => '非表示',
	'sf_createform_removetemplate' => 'テンプレートを除去',
	'sf_createform_addtemplate' => '追加するテンプレート:',
	'sf_createform_beforetemplate' => '以下のテンプレートの前:',
	'sf_createform_atend' => '末尾に',
	'sf_createform_add' => '追加',
	'sf_createform_choosefield' => '追加するフィールドを選択',
	'createcategory' => 'カテゴリの作成',
	'sf-createcategory-with-name' => '作成するカテゴリ: $1',
	'sf_createcategory_name' => 'カテゴリ名:',
	'sf_createcategory_defaultform' => '既定のフォーム:',
	'sf_createcategory_makesubcategory' => '以下のカテゴリの下位カテゴリにする (任意選択):',
	'createclass' => 'クラスの作成',
	'sf_createclass_docu' => '単一のクラスに対応するプロパティ群、テンプレート、フォーム、カテゴリの作成に必要なデータすべてをここに入力してください。詳細なオプションが必要であれば、$1 の各ページを使用してください。',
	'sf_createclass_allowedvalues' => '許可される値:',
	'sf_createclass_listofvalues' => '値の列挙?',
	'sf_createclass_nameinput' => 'フォーム名:',
	'sf_createclass_missingvalues' => '必須のフィールドに未入力のものがあります。',
	'sf_createclass_success' => 'プロパティ群、テンプレート、フォーム、カテゴリが作成されます。',
	'sf_createclass_create' => '作成',
	'formstart' => 'フォームによるページの追加',
	'sf_formstart_badform' => 'エラー: ページ「$1」にはフォームが見つかりませんでした。',
	'sf_formstart_badtitle' => 'エラー: 「$1」はページ名として無効です。',
	'sf_formstart_docu' => 'フォーム「$1」で編集するページの名前を入力してください。
そのページが既に存在する場合は、それを編集するフォームへ転送されます。
存在しない場合は、そのページを追加するフォームに転送されます。',
	'sf_formstart_noform_docu' => 'ページ名を入力して、編集に使用するフォームを選択してください。
そのページが既に存在する場合は、それを編集するフォームに転送されます。
存在しない場合は、そのページを追加するフォームに転送されます。',
	'sf_formstart_createoredit' => '作成または編集',
	'formedit' => 'フォームを使用して編集',
	'sf_formedit_createtitle' => '$1を作成: $2',
	'sf_formedit_createtitlenotarget' => '$1 を作成',
	'sf_formedit_badurl' => 'このページは、フォームでの編集に使用するものです。フォーム名と対象ページの両方を、URL に指定する必要があります。
「Special:FormEdit?form=<フォーム名>&target=<対象ページ>」または「Special:FormEdit/<フォーム名>/<対象ページ>」のような形式になります。',
	'sf_formedit_altforms' => '以下のいずれかのフォームを使用して、このページを代わりに追加できます:',
	'sf_formedit_altformsonly' => 'このページを追加するために、以下のいずれかのフォームを洗濯してください:',
	'sf_formcreate' => 'フォームを使用して作成',
	'sf_viewform' => 'フォームを表示',
	'sf_editsource' => 'ソースを編集',
	'sf_formedit_edittitle' => '$1 を編集: $2',
	'sf_formedit_morethanoneform' => "'''警告:''' このページに対する既定のフォームが複数定義されています。",
	'sf_formedit_formwarning' => '警告: このページは<a href="$1">既に存在します</a>が、このフォームを使用していません。',
	'sf_formedit_remove' => 'このインスタンスを除去',
	'sf_formedit_addanotherabove' => 'これの上に別のインスタンスを追加',
	'sf_formedit_addanother' => 'さらに追加',
	'sf_formedit_none' => 'なし',
	'sf_formedit_saveandcontinueediting' => '保存して続行',
	'sf_formedit_saveandcontinue_summary' => 'フォームの「$1」ボタンで保存済み',
	'sf_formedit_tooltip_saveandcontinueediting' => 'データを保存して編集を続行',
	'sf_autoedit_anoneditwarning' => "'''警告:''' ログインしていません。編集すると、IPアドレスがこのページの編集履歴に記録されます。",
	'sf_autoedit_success' => 'フォーム $2 を使用して [[$1]] を変更しました。',
	'sf_autoedit_fail' => '[[$1]] の変更に失敗しました。',
	'sf_autoedit_invalidform' => '$1 は有効なフォームではありません。',
	'sf_autoedit_redirectlimitexeeded' => 'フォーム $1 がリダイレクト回数の上限に達しました。',
	'sf_autoedit_invalidredirecttarget' => '$1 はフォーム $2 のリダイレクト先として無効です。',
	'sf_autoedit_invalidpreloadspecified' => '指定したプリロードページ $1 は無効です。',
	'sf_autoedit_redlinkexists' => '$1 は既に存在します。',
	'sf_autoedit_noformfound' => 'フォームが指定されていません。',
	'sf_autoedit_toomanyformsfound' => 'ページで利用できるフォームが複数あります。',
	'sf_autoedit_summary' => 'ページ $1 から自動的に編集されました。',
	'sf-autoedit-wait' => 'お待ちください...',
	'runquery' => 'クエリの実行',
	'sf_runquery_badurl' => 'URL 内にフォーム名を指定しなければなりません。
URL は「Special:RunQuery/<フォーム名>」のような形式になります。',
	'sf_runquery_title' => '実行するクエリ: $1',
	'sf_runquery_additionalquery' => '追加のクエリ',
	'sf_formerrors_header' => 'フォームへの入力内容に誤りがありました。以下をご覧ください',
	'sf_blank_error' => '空欄にはできません',
	'sf_bad_url_error' => 'URL を「http」から始まる正しい形式にする必要があります',
	'sf_bad_email_error' => 'メールアドレスを正しい形式にする必要があります',
	'sf_bad_number_error' => '有効な数値にする必要があります',
	'sf_bad_date_error' => '正しい日付にする必要があります',
	'uploadwindow' => 'アップロード ウィンドウ',
	'sf_deletionlog' => '削除記録',
	'sf-preview-header' => 'フォーム プレビュー',
	'sf-preview-note' => 'フォームが使用される際、このように表示されます:',
	'sf-pageschemas-createtitle' => '新しいページに使用するフォーム名:',
	'sf-pageschemas-edittitle' => '既存のページに使用するフォーム名:',
	'sf-pageschemas-inputtype' => '入力型 (既定値を使用する場合は空白):',
	'sf_property_isproperty' => 'これは型 $1 のプロパティです。',
	'sf_property_linkstoform' => 'フォーム $1 を利用するページにリンクする。',
	'sf_property_allowedvals' => 'このプロパティが取れる{{PLURAL:$1|値}}:',
	'sf_template_docu' => 'これはテンプレート「$1」です。
以下の書式で呼び出されます:',
	'sf_template_docufooter' => 'テンプレートの内容を見るにはページを編集してください。',
	'sf_form_docu' => 'これは「$1」フォームです。
このフォームを使用してページを作成するには、下にページ名を入力してください。
その名前のページが既に存在する場合は、そのページを編集するフォームに転送されます。',
	'sf_form_freetextlabel' => '自由形式テキスト',
	'sf_category_hasdefaultform' => 'このカテゴリはフォーム $1 を使用しています。',
	'sf_category_desc' => 'これはカテゴリ $1 です。',
	'sf_blank_namespace' => '標準',
	'right-viewedittab' => 'フォームで編集できるページに「{{int:edit}}」タブが表示される',
	'right-editrestrictedfields' => '制限されたフォームフィールドを編集',
	'right-createclass' => '新しい意味クラスを作成',
	'action-createclass' => '新しい意味クラスを作成',
	'action-editrestrictedfields' => '制限されたフォームフィールドの編集',
	'action-viewedittab' => 'フォームで編集できるページに「{{int:edit}}」タブを表示',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 * @author Pras
 */
$messages['jv'] = array(
	'sf_createproperty_propname' => 'Jeneng sifat/properti:',
	'sf_createproperty_proptype' => 'Jenis:',
	'templates' => 'Cithakan-cithakan',
	'sf_templates_docu' => 'Cithakan-cithakan iki ana ing wiki iki.',
	'sf_templates_definescat' => 'namtokaké kategori: $1',
	'createtemplate' => 'Nggawé cithakan',
	'sf_createtemplate_namelabel' => 'Jeneng cithakan:',
	'sf_createtemplate_fieldname' => 'Jeneng lapangan:',
	'sf_createtemplate_semanticproperty' => 'Sifat sémantik:',
	'sf_createtemplate_aggregationlabel' => 'Irah-irahan kanggo daftar:',
	'sf_createtemplate_standardformat' => 'Baku', # Fuzzy
	'sf_createtemplate_deletefield' => 'Busak',
	'forms' => 'Formulir-formulir',
	'sf_forminputs_restricted' => 'Diwatesi (namung para panganggo opsis sing bisa modifikasi)', # Fuzzy
	'createform' => 'Nggawé formulir',
	'sf_createform_template' => 'Cithakan:',
	'sf_createform_templatelabelinput' => 'Label cithakan (opsional):',
	'sf_createform_field' => 'Lapangan:',
	'sf_createform_inputtype' => 'Jenis input:',
	'sf_createform_inputtypedefault' => '(baku)',
	'sf_createform_formlabel' => 'Label formulir:',
	'sf_createform_hidden' => 'Kadelikaké',
	'sf_createform_removetemplate' => 'Ilangana cithakan',
	'sf_createform_add' => 'Tambah',
	'createcategory' => 'Gawé kategori',
	'sf_createcategory_name' => 'Jeneng kategori:',
	'sf_createcategory_defaultform' => 'Formulir baku:',
	'sf_editsource' => 'Sunting sumber',
	'sf_formedit_edittitle' => 'Sunting $1: $2',
	'sf_formedit_remove' => 'Busak',
	'sf_formedit_addanother' => 'Tambah liyané',
	'sf_formedit_none' => 'Ora ana',
	'sf_blank_error' => 'ora olèh kosong',
	'sf_bad_email_error' => 'kudu duwé format alamat e-mail sing absah',
	'sf_bad_number_error' => 'kudu angka sing absah',
	'sf_bad_date_error' => 'kudu tanggal sing absah',
	'sf_template_docufooter' => 'Suntingen kacané kanggo ndeleng tèks cithakan.',
	'sf_form_freetextlabel' => 'Tèks bébas',
	'sf_category_hasdefaultform' => 'Kategori iki nganggo formulir $1.',
	'sf_category_desc' => 'Iki kategori $1',
	'sf_blank_namespace' => 'Utama',
);

/** Georgian (ქართული)
 * @author David1010
 */
$messages['ka'] = array(
	'semanticforms-desc' => 'ფორმა სემანტიკური მონაცემების დასამატებლად და რედაქტირებისათვის',
	'specialpages-group-sf_group' => 'სემანტიკური ფორმები',
	'createproperty' => 'თვისების შექმნა',
	'sf-createproperty-with-name' => 'თვისების შექმნა: $1',
	'sf_createproperty_propname' => 'თვისების სახელი:',
	'sf_createproperty_proptype' => 'ტიპი:',
	'templates' => 'თარგები',
	'createtemplate' => 'თარგის შექმნა',
	'sf-createtemplate-with-name' => 'თარგის შექმნა: $1',
	'sf_createtemplate_namelabel' => 'თარგის სახელი:',
	'sf_createtemplate_categorylabel' => 'თარგის მიერ განსაზღვრადი კატეგორია (არასავალდებულო):',
	'sf_createtemplate_templatefields' => 'თარგის ველები',
	'sf_createtemplate_fieldname' => 'ველის სახელი:',
	'sf_createtemplate_displaylabel' => 'სახელი ეკრანზე:',
	'sf_createtemplate_semanticproperty' => 'სემანტიკური თვისება:',
	'sf_createtemplate_aggregation' => 'კავშირი',
	'sf_createtemplate_aggregationlabel' => 'სიის სათაური:',
	'sf_createtemplate_standardformat' => 'ცხრილი',
	'sf_createtemplate_infoboxformat' => 'ინფოდაფის მხარე',
	'sf_createtemplate_plainformat' => 'ჩვეულებრივი ტექსტი',
	'sf_createtemplate_sectionsformat' => 'სექციები',
	'sf_createtemplate_addfield' => 'ველის დამატება',
	'sf_createtemplate_deletefield' => 'წაშლა',
	'forms' => 'ფორმები',
	'createform' => 'ფორმის შექმნა',
	'sf-createform-with-name' => 'ფორმის შექმნა: $1',
	'sf_createform_nameinput' => 'ფორმის სახელი',
	'sf_createform_template' => 'თარგი:',
	'sf_createform_templatelabelinput' => 'თარგის აღნიშვნა (არასავალდებულო):',
	'sf_createform_field' => 'ველი:',
	'sf_createform_inputtype' => 'ველის ტიპი:',
	'sf_createform_inputtypedefault' => '(სტანდარტული)',
	'sf_createform_hidden' => 'დამალული',
	'sf_createform_removetemplate' => 'თარგის წაშლა',
	'sf_createform_addtemplate' => 'თარგის დამატება:',
	'sf_createform_beforetemplate' => 'თარგამდე:',
	'sf_createform_atend' => 'ბოლოს',
	'sf_createform_add' => 'დამატება',
	'sf_createform_choosefield' => 'დასამატებლად აირჩიეთ ველი',
	'createcategory' => 'კატეგორიის შექმნა',
	'sf-createcategory-with-name' => 'კატეგორიის შექმნა: $1',
	'sf_createcategory_name' => 'კატეგორიის სახელი:',
	'sf_createcategory_defaultform' => 'სტანდარტული ფორმა:',
	'createclass' => 'კლასის შექმნა',
	'sf_createclass_nameinput' => 'ფორმის სახელი:',
	'sf_createclass_create' => 'შექმნა',
	'sf_formstart_createoredit' => 'შექმნა ან რედაქტირება',
	'formedit' => 'ფორმით რედაქტირება',
	'sf_formedit_createtitle' => '$1 შექმნა: $2',
	'sf_formedit_createtitlenotarget' => '$1 შექმნა',
	'sf_formcreate' => 'ფორმით შექმნა',
	'sf_viewform' => 'ფორმის ხილვა',
	'sf_editsource' => 'წყაროს რედაქტირება',
	'sf_formedit_edittitle' => '$1 რედაქტირება: $2',
	'sf_formedit_remove' => 'წაშლა', # Fuzzy
	'sf_formedit_none' => 'არაფერი',
	'sf_formedit_saveandcontinueediting' => 'შენახვა და გაგრძელება',
	'sf_formedit_tooltip_saveandcontinueediting' => 'მონაცემების შენახვა და რედაქტირების გარძელება',
	'sf_autoedit_anoneditwarning' => 'გაფრთხილება: თქვენ არ ხართ რეგისტრირებული. თქვენი IP მისამართი ჩაიწერება ამ გვერდის რედაქტირების ისტორიაში.',
	'sf_autoedit_invalidform' => '$1 არ არის სწორი ფორმა.',
	'sf_autoedit_redlinkexists' => '$1 უკვე არსებობს.',
	'sf_autoedit_noformfound' => 'ფორმა არ არის გარკვეული.',
	'sf-autoedit-wait' => 'მოიცადეთ...',
	'runquery' => 'მოთხოვნის გაშვება',
	'sf_runquery_title' => 'მოთხოვნის გაშვება: $1',
	'sf_runquery_additionalquery' => 'დამატებითი მოთხოვნები',
	'sf_blank_error' => 'არ შეიძლება ცარიელი იყოს',
	'sf_bad_number_error' => 'უნდა იყოს სწორი რიცხვი',
	'sf_bad_date_error' => 'უნდა იყოს სწორი თარიღი',
	'uploadwindow' => 'ატვირთვის ფანჯარა',
	'sf_deletionlog' => 'წაშლების ჟურნალი',
	'sf-preview-header' => 'ფორმის წინასწარი გადახედვა',
	'sf-pageschemas-pagenameformula' => 'გვერდის სახელის ფორმულა:',
	'sf-pageschemas-createtitle' => 'ფორმის სათაური ახალი გვერდებისათვის:',
	'sf-pageschemas-edittitle' => 'ფორმის სათაური არსებული გვერდებისათვის:',
	'sf_form_freetextlabel' => 'თავისუფალი ტექსტი',
	'sf_blank_namespace' => 'მთავარი',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 * @author វ័ណថារិទ្ធ
 */
$messages['km'] = array(
	'specialpages-group-sf_group' => 'ទម្រង់​និឃណ្ដសាស្ត្រ',
	'createproperty' => 'បង្កើត​លក្ខណៈសម្បត្តិ',
	'sf_createproperty_propname' => 'ឈ្មោះលក្ខណៈសម្បត្តិ៖',
	'sf_createproperty_proptype' => 'ប្រភេទ៖',
	'templates' => 'ទំព័រគំរូ',
	'sf_templates_docu' => 'ខាងក្រោមនេះជាទំព័រគំរូដែលមានក្នុងវិគីនេះ។',
	'sf_templates_definescat' => 'ដាក់ឈ្មោះឱ្យចំណាត់ថ្នាក់ក្រុម៖ $1',
	'createtemplate' => 'បង្កើតទំព័រគំរូ',
	'sf_createtemplate_namelabel' => 'ឈ្មោះទំព័រគំរូ៖',
	'sf_createtemplate_displaylabel' => 'បង្ហាញ​ស្លាក:',
	'sf_createtemplate_aggregationlabel' => 'ចំណងជើង​សម្រាប់​បញ្ជី:',
	'sf_createtemplate_outputformat' => 'ទ្រ់ង់ទ្រាយ​ទិន្នផល:',
	'sf_createtemplate_standardformat' => 'តារាង',
	'sf_createtemplate_infoboxformat' => 'ប្រអប់​ព័ត៌មាន​ចំហៀង',
	'sf_createtemplate_addfield' => 'បន្ថែម​វាល',
	'sf_createtemplate_deletefield' => 'លុបចេញ',
	'sf_createtemplate_addtemplatebeforesave' => 'អ្នក​ត្រូវតែ​បន្ថែម​ទំព័រគំរូ​យ៉ាងតិចមួយ​ទៅក្នុង​ទម្រង់​នេះ មុនពេល​អ្នក​អាច​រក្សា​វា​ទុក​។',
	'forms' => 'បែបបទ',
	'sf_forms_docu' => 'ទម្រង់​ដូចតទៅនេះ មាន​នៅ​ក្នុង​វិគី​រួច​ហើយ​។',
	'sf_forminputs_restricted' => 'មានតែ​អភិបាលប៉ុណ្ណោះ​ទើប​មាន​សិទ្ធិ​កែប្រែ​បាន',
	'createform' => 'បង្កើត មួយបែបបទ',
	'sf_createform_template' => 'ទំព័រគំរូ៖',
	'sf_createform_templatelabelinput' => 'ប្លាកគំរូខ្នាត (ជំរើស):',
	'sf_createform_field' => 'វាល:',
	'sf_createform_inputtypedefault' => '(លំនាំដើម)',
	'sf_createform_formlabel' => 'ស្លាក​ទម្រង់:',
	'sf_createform_hidden' => 'ត្រូវបានលាក់',
	'sf_createform_removetemplate' => 'ដកទំព័រគំរូ​ចេញ',
	'sf_createform_addtemplate' => 'បន្ថែម​ទំព័រគំរូ:',
	'sf_createform_beforetemplate' => 'មុនទំព័រគំរូ:',
	'sf_createform_atend' => 'នៅ​ទីបញ្ចប់',
	'sf_createform_add' => 'បន្ថែម',
	'sf_createform_choosefield' => 'ជ្រើសរើស​វាល​ដើម្បី​បន្ថែម',
	'createcategory' => 'បង្កើតចំណាត់ថ្នាក់ក្រុម',
	'sf_createcategory_name' => 'ឈ្មោះចំណាត់ថ្នាក់ក្រុម៖',
	'sf_createcategory_defaultform' => 'បែបបទលំនាំដើម៖',
	'sf_createcategory_makesubcategory' => 'ដាក់​ចំណាត់ថ្នាក់ក្រុមរង​នេះ ទៅនឹង​ចំណាត់ថ្នាក់ក្រុម​ដទៃ (តាមបំណង):',
	'formstart' => 'បន្ថែមទំព័រ​ជាមួយ​ទម្រង់',
	'sf_formstart_badform' => 'កំហុស: គ្មាន​ទំព័រទម្រង់​ត្រូវ​បាន​រកឃើញ​នៅ $1 ទេ',
	'sf_formstart_createoredit' => 'បង្កើតឬកែប្រែ',
	'formedit' => 'កែប្រែបែបបទនេះ',
	'sf_formedit_createtitle' => 'បង្កើត $1៖ $2',
	'sf_viewform' => 'មើលបែបបទ',
	'sf_editsource' => 'កែប្រែកូដ',
	'sf_formedit_edittitle' => 'កែប្រែ $1: $2',
	'sf_formedit_formwarning' => 'ការព្រមាន: ទំព័រ​នេះ <a href="$1">មាន​រួចហើយ</a> ប៉ុន្តែ​វា​មិនអាច​ប្រើប្រាស់​ទម្រង់​នេះ​បាន​ទេ​។',
	'sf_formedit_remove' => 'ដកចេញ',
	'sf_formedit_addanother' => 'បន្ថែមមួយផ្សេងទៀត',
	'sf_formedit_none' => 'ទទេ',
	'sf_formerrors_header' => 'បាន​មាន​កំហុស​ជាមួយ​ការបញ្ចូល​ទម្រង់​របស់​អ្នក, សូម​មើល​ខាងក្រោម',
	'sf_blank_error' => 'មិនអាចទទេទេ',
	'sf_bad_url_error' => "ត្រូវតែ​មាន​ទ្រង់ទ្រាយ URL ត្រឹមត្រូវ ដែល​ផ្ដើមឡើង​ជាមួយ 'http'",
	'sf_bad_email_error' => 'ទម្រង់អាសយដ្ឋានអ៊ីមែល មិនត្រឹមត្រូវ',
	'sf_bad_number_error' => 'ត្រូវតែ​ជា​លេខ​ត្រឹមត្រូវ',
	'sf_bad_date_error' => 'ត្រូវតែ​ជា​កាលបរិច្ឆេទ​ត្រឹមត្រូវ',
	'uploadwindow' => 'ផ្ទុក​បង្អួច​ឡើង',
	'sf_deletionlog' => 'កំណត់ហេតុនៃការលុបចោល',
	'sf_property_isproperty' => 'នេះ​គឺជា​លក្ខណៈសម្បត្តិមួយ​នៃ​គំរូ $1 ។',
	'sf_property_allowedvals' => 'តម្លៃ​ចំនួន$1 ​សម្រាប់​លក្ខណៈសម្បត្តិ​នេះគឺ​៖',
	'sf_template_docu' => "នេះ​គឺជា​ទំព័រគំរូ '$1' ។
វា​នឹង​ត្រូវ​គេ​ហៅ​មកប្រើប្រាស់ នៅក្នុង​ទ្រង់ទ្រាយ​ដូចតទៅ៖",
	'sf_template_docufooter' => 'កែប្រែទំព័រ ដើម្បីឃើញអត្ថបទគំរូ ។',
	'sf_form_docu' => "នេះ​គឺ​ជាបែប​បទ​​ '$1'​។ ដើម្បី​បន្ថែម​ទំព័រ​មួយ​ជាមួយ​បែប​បទ​​នេះ​ សូមវាយ​បញ្ចូល​ឈ្មោះ​ទំព័រ​ខាង​ក្រោម​។​ ប្រសិន​បើ​មានទំព័រ​ដែល​មានឈ្មោះ​នោះ​រួច​ហើយ​ អ្នក​នឹង​ត្រូវ​បាន​ផ្ញើ​ទៅ​កាន់​បែប​បទ​​មួយ​ដើម្បី​កែប្រែ​ទំព័រ​នោះ​។​",
	'sf_form_freetextlabel' => 'អត្ថបទ​សេរី​',
	'sf_category_hasdefaultform' => 'ចំណាត់ក្រុមនេះ ប្រើប្រាស់បែបបទ $1 ។',
	'sf_category_desc' => 'នេះ​គឺជា​ចំណាត់ថ្នាក់ក្រុម $1 ។',
	'sf_blank_namespace' => 'ចម្បង​',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'templates' => 'ಟೆಂಪ್ಲೇಟು',
	'sf_createtemplate_deletefield' => 'ಅಳಿಸು',
	'sf_createform_add' => 'ಸೇರಿಸು',
);

/** Korean (한국어)
 * @author 아라
 */
$messages['ko'] = array(
	'semanticforms-desc' => '시맨틱 데이터 추가와 편집을 위한 양식',
	'specialpages-group-sf_group' => '시맨틱 양식',
	'createproperty' => '속성 만들기',
	'sf-createproperty-with-name' => '속성 만들기: $1',
	'sf_createproperty_linktoform' => '이 속성은 양식을 사용하는 문서로 연결합니다:',
	'sf_createproperty_allowedvalsinput' => '이 속성이 특정 값을 가질 수 있도록 허용하려면 쉼표로 구분하여 허용하는 값 목록을 입력하세요 (값이 쉼표로 포함되어 있으면 "\\,"로 바꾸세요):',
	'sf_createproperty_propname' => '속성 이름:',
	'sf_createproperty_proptype' => '유형:',
	'templates' => '틀 목록',
	'sf_templates_docu' => '다음 틀은 위키에 존재합니다.',
	'sf_templates_definescat' => '분류 정의: $1',
	'createtemplate' => '틀 만들기',
	'sf-createtemplate-with-name' => '틀 만들기: $1',
	'sf_createtemplate_namelabel' => '틀 이름:',
	'sf_createtemplate_multipleinstance' => '이 틀은 문서에 여러 번 포함할 수 있습니다.',
	'sf_createtemplate_categorylabel' => '틀에 의해 정의한 분류 (선택 사항):',
	'sf_createtemplate_templatefields' => '틀 필드',
	'sf_createtemplate_fieldsdesc' => '필드 이름이 더 이상 필요하지 않는 이 틀에 필드를 갖기 위해서는 단순히 실제 이름 대신 이름으로 각 필드의 인덱스(예를 들어 1, 2, 3, 그 외)를 입력하세요.',
	'sf_createtemplate_fieldname' => '입력란 이름:',
	'sf_createtemplate_displaylabel' => '보여줄 레이블:',
	'sf_createtemplate_semanticproperty' => '시맨틱 속성:',
	'sf_createtemplate_fieldislist' => '이 입력란은 쉼표로 구분하여 값 목록을 저장할 수 있습니다',
	'sf_createtemplate_aggregation' => '집합',
	'sf_createtemplate_aggregationdesc' => '이 틀을 사용하여 모든 문서에 나타내려면 해당 문서를 가리키는 특정 속성을 가진 모든 문서를 다음 해당 속성을 지정하세요:',
	'sf_createtemplate_aggregationlabel' => '목록 제목:',
	'sf_createtemplate_outputformat' => '출력 형식:',
	'sf_createtemplate_standardformat' => '표',
	'sf_createtemplate_infoboxformat' => '정보 상자 보기',
	'sf_createtemplate_plainformat' => '일반 텍스트',
	'sf_createtemplate_sectionsformat' => '부분',
	'sf_createtemplate_addfield' => '필드 추가',
	'sf_createtemplate_deletefield' => '삭제',
	'sf_createtemplate_addtemplatebeforesave' => '저장하기 전에 이 양식에 하나 이상의 틀을 추가해야 합니다.',
	'forms' => '양식 목록',
	'sf_forms_docu' => '다음 양식은 위키에 존재합니다.',
	'sf_forminputs_mandatory' => '이 입력에 대한 값을 입력해야 합니다',
	'sf_forminputs_restricted' => '관리자만 이 입력을 편집할 수 있습니다',
	'sf_forminputs_class' => '이 입력에 대한 HTML "클래스" 속성',
	'sf_forminputs_default' => '이 입력에 대한 기본값',
	'sf_forminputs_preload' => '이 입력의 기본값이 될 내용의 위키 문서',
	'sf_forminputs_property' => '이 필드에 해당하는 시맨틱 속성',
	'sf_forminputs_size' => '문자에서 텍스트 필드의 크기',
	'sf_forminputs_maxlength' => '이 필드의 텍스트의 최대 허용 길이',
	'sf_forminputs_placeholder' => '사용자가 클릭할 때까지 입력에 나타나는 도움말 텍스트',
	'sf_forminputs_uploadable' => '이 입력 옆에 "{{int:upload}}" 링크 놓기',
	'sf_forminputs_defaultfilename' => '올린 파일에 대한 기본 파일 이름',
	'sf_forminputs_rows' => '이 입력에 대한 행 수',
	'sf_forminputs_cols' => '이 입력에 대한 열 수',
	'sf_forminputs_autogrow' => '텍스트의 경계를 초과하면 크기가 늘어나도록 이 입력을 설정',
	'sf_forminputs_valuesfromproperty' => '위키에서 값 속성은 값의 이 입력의 설정이어야 합니다',
	'sf_forminputs_valuesfromcategory' => '문서 분류는 값의 이 입력의 설정이어야 합니다',
	'sf_forminputs_valuesfromnamespace' => '문서 이름공간은 값의 이 입력의 설정이어야 합니다',
	'sf_forminputs_valuesfromconcept' => '이 문서의 입력 집합이어야 하는 Semantic MediaWiki "컨셉" 문서',
	'sf_forminputs_valuesfromurl' => '구조화된 데이터를 유지하는 URL은 값의 이 입력의 설정이어야 합니다',
	'sf_forminputs_values' => '이 입력에 대한 값의 설정은 쉼표로 구분합니다',
	'sf_forminputs_list' => '이 입력이 값의 목록을 유지할 수 있도록 표시',
	'sf_forminputs_delimiter' => '이 입력이 값의 목록으로 유지하면 필드 값 사이의 구분자',
	'sf_forminputs_remoteautocompletion' => '원격 자동 완성 사용',
	'sf_forminputs_existingvaluesonly' => '이미 목록 값만 허용',
	'sf_forminputs_showonselect' => '특정 값을 선택했을 때에만 보여줄 문서 요소 (예: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => '이 목록 상자의 행 단위 높이',
	'sf_forminputs_includetimezone' => '시간대에 대한 입력을 포함',
	'sf_forminputs_topcategory' => '이 집합 분류의 상위 분류 (필수)',
	'sf_forminputs_hideroot' => '상위 분류 숨기기',
	'sf_forminputs_depth' => '처음 보여줄 분류의 수준 수',
	'sf_forminputs_height' => '이 입력에 대한 픽셀 단위 높이',
	'sf_forminputs_width' => '이 입력에 대한 픽셀 단위 너비',
	'createform' => '양식 만들기',
	'sf-createform-with-name' => '양식 만들기: $1',
	'sf_createform_nameinput' => '양식 이름',
	'sf_createform_nameinputdesc' => '(양식은 일반적으로 주요 틀로 같은 이름이 주어집니다):',
	'sf_createform_template' => '틀:',
	'sf_createform_templatelabelinput' => '틀 레이블 (선택 사항):',
	'sf_createform_allowmultiple' => '만든 문서에서 이 틀을 여러 번 사용하는 인스턴스를 허용',
	'sf_createform_field' => '입력란',
	'sf_createform_fieldprop' => '이 필드는 $2 유형의 $1 속성을 정의합니다.',
	'sf_createform_fieldproplist' => '이 필드는 $2 유형의 $1 속성을 가진 요소의 목록을 정의합니다.',
	'sf_createform_fieldpropunknowntype' => '이 필드는 지정하지 않은 유형의 $1 속성을 지정합니다.',
	'sf_createform_inputtype' => '입력 종류:',
	'sf_createform_inputtypedefault' => '(기본값)',
	'sf_createform_formlabel' => '양식 레이불:',
	'sf_createform_hidden' => '숨겨짐',
	'sf_createform_removetemplate' => '틀 제거',
	'sf_createform_addtemplate' => '틀 추가:',
	'sf_createform_beforetemplate' => '틀 이전:',
	'sf_createform_atend' => '끝으로',
	'sf_createform_add' => '추가',
	'sf_createform_choosefield' => '추가할 입력란 선택',
	'createcategory' => '분류 만들기',
	'sf-createcategory-with-name' => '분류 만들기: $1',
	'sf_createcategory_name' => '분류 이름:',
	'sf_createcategory_defaultform' => '기본 양식:',
	'sf_createcategory_makesubcategory' => '다른 분류의 이 하위 분류 만들기 (선택 사항):',
	'createclass' => '클래스 만들기',
	'sf_createclass_docu' => '단일 클래스에 대한 속성, 틀, 양식과 분류를 만드려면 여기에 데이터를 모두 입력하세요. 더 많은 옵션은 $1의 각 문서를 사용하세요.',
	'sf_createclass_allowedvalues' => '허용한 값:',
	'sf_createclass_listofvalues' => '값 목록입니까?',
	'sf_createclass_nameinput' => '양식 이름:',
	'sf_createclass_missingvalues' => '모든 필수 필드를 기입하지 않았습니다.',
	'sf_createclass_success' => '속성, 틀, 양식과 분류를 만들 것입니다.',
	'sf_createclass_create' => '만들기',
	'formstart' => '양식 시작',
	'sf_formstart_badform' => '오류: "$1" 문서에서 찾은 양식이 없습니다.',
	'sf_formstart_badtitle' => '오류: "$1"(은)는 잘못된 문서 제목입니다.',
	'sf_formstart_docu' => '여기에 "$1" 양식으로 편집할 문서 이름을 입력하세요.
이 문서가 이미 존재하면 해당 문서를 편집하는 양식에 보냅니다.
존재하지 않으면 문서를 추가하는 양식에 보냅니다.',
	'sf_formstart_noform_docu' => '여기에 문서 이름을 입력하고 문서를 편집할 양식을 선택하세요.
이 문서가 이미 존재하면 해당 문서를 편집하는 양식에 보냅니다.
존재하지 않으면 문서를 추가하는 양식에 보냅니다.',
	'sf_formstart_createoredit' => '만들거나 편집',
	'formedit' => '양식으로 편집',
	'sf_formedit_createtitle' => '$1: $2 만들기',
	'sf_formedit_createtitlenotarget' => '$1 만들기',
	'sf_formedit_badurl' => '양식으로 편집하는 문서입니다. URL에 양식 이름과 대상 문서 둘 다 지정해야 합니다.
"Special:FormEdit?form=<양식 이름>&target=<대상 문서>" 또는  "Special:FormEdit/<양식 이름>/<대상 문서>" 처럼 보여야 합니다.',
	'sf_formedit_altforms' => '다음 양식 중 하나로 이 문서를 대신 추가할 수 있습니다:',
	'sf_formedit_altformsonly' => '이 문서에 추가할 다음 양식 중 하나를 선택하세요:',
	'sf_formcreate' => '양식으로 만들기',
	'sf_viewform' => '양식 보기',
	'sf_editsource' => '내용 편집',
	'sf_formedit_edittitle' => '$1: $2 편집',
	'sf_formedit_morethanoneform' => "'''경고:''' 하나 이상의 기본 양식은 이 문서에 지정되어 있습니다.",
	'sf_formedit_formwarning' => '경고: 이 문서는 <a href="$1">이미 존재하지만</a> 이 양식을 사용하지 않습니다.',
	'sf_formedit_mismatchedbrackets' => '경고: 이 문서는 닫혀있지 않은 소괄호나 대괄호를 포함하기 때문에 문서가 양식에서 올바르게 처리되지 않습니다. 계속하기 전에 <a href="$1">원본 텍스트에서 오류를 고치세요</a>.',
	'sf_formedit_remove' => '이 인스턴스 제거',
	'sf_formedit_addanotherabove' => '이 인스턴스 위에 다른 인스턴스 추가',
	'sf_formedit_addanother' => '또 추가',
	'sf_formedit_none' => '없음',
	'sf_formedit_emptytitle' => '오류: 빈 문서 제목에 삽입한 데이터 결과입니다.',
	'sf_formedit_hookerror' => '오류: 미디어위키 확장 기능은 대상 문서를 수정할 수 없습니다.',
	'sf_formedit_saveandcontinueediting' => '저장하고 계속',
	'sf_formedit_saveandcontinue_summary' => '양식에서 "$1" 버튼을 사용하여 저장함',
	'sf_formedit_tooltip_saveandcontinueediting' => '데이터를 저장하고 편집을 계속하기',
	'sf_autoedit_anoneditwarning' => "'''주의''': 로그인하고 있지 않습니다. IP 주소가 문서 역사에 남게 됩니다.",
	'sf_autoedit_success' => '$2 양식을 사용하여 [[$1]] 문서를 성공적으로 수정했습니다.',
	'sf_autoedit_fail' => '[[$1]](을)를 수정하는 데 실패했습니다.',
	'sf_autoedit_notargetspecified' => '지정한 대상 문서가 없습니다.',
	'sf_autoedit_invalidtargetspecified' => '지정한 $1 대상 문서가 잘못되었습니다.',
	'sf_autoedit_invalidform' => '$1(은)는 올바른 양식이 아닙니다.',
	'sf_autoedit_redirectlimitexeeded' => '$1 양식에 대한 최대 넘겨주기 제한을 초과했습니다.',
	'sf_autoedit_invalidredirecttarget' => '$1(은)는 $2 양식에 대한 잘못된 넘겨주기 대상입니다.',
	'sf_autoedit_invalidpreloadspecified' => '지정한 $1 미리 불러온 문서가 잘못되었습니다.',
	'sf_autoedit_redlinkexists' => '$1(은)는 이미 존재합니다.',
	'sf_autoedit_noformfound' => '지정한 양식이 없습니다.',
	'sf_autoedit_toomanyformsfound' => '문서에 사용할 수 있는 하나 이상의 양식입니다.',
	'sf_autoedit_readonly' => '데이터베이스가 현재 수정이 잠겨있습니다. 이유: $1',
	'sf_autoedit_nosemanticform' => '$2 문서에 $2 양식을 가져올 수 없습니다. 자세한 사항에 대해서는 [[{{#special:FormEdit}}/$2/$1]](을)를 참고하십시오.',
	'sf_autoedit_summary' => '$1 문서에서 자동으로 편집합니다.',
	'sf-autoedit-wait' => '기다리세요...',
	'runquery' => '쿼리 실행',
	'sf_runquery_badurl' => 'URL에 양식 이름을 지정해야 합니다.
URL은 "Special:RunQuery/<양식 이름>"같이 보여야 합니다.',
	'sf_runquery_title' => '쿼리 실행: $1',
	'sf_runquery_additionalquery' => '추가 쿼리',
	'sf_formerrors_header' => '양식 입력에 오류가 났습니다. 아래를 참고하세요.',
	'sf_blank_error' => '비워둘 수 없습니다',
	'sf_bad_url_error' => '"http"로 시작하는 올바른 URL 형식이어야 합니다',
	'sf_bad_email_error' => '올바른 이메일 주소 형식이어야 합니다',
	'sf_bad_number_error' => '올바른 숫자여야 합니다',
	'sf_bad_date_error' => '올바른 날짜여야 합니다',
	'uploadwindow' => '올리기 창',
	'sf_deletionlog' => '삭제 기록',
	'sf-preview-header' => '양식 미리 보기',
	'sf-preview-note' => '양식을 사용할 때 이 같이 보입니다:',
	'sf-pageschemas-pagenameformula' => '문서 이름 공식:',
	'sf-pageschemas-createtitle' => '새 문서에 대한 양식 제목:',
	'sf-pageschemas-edittitle' => '기존 문서에 대한 양식 제목:',
	'sf-pageschemas-inputtype' => '입력 형식 (기본값으로 설정하려면 비워두세요):',
	'sf_property_isproperty' => '$1 유형의 속성입니다.',
	'sf_property_linkstoform' => '$1 양식을 사용하는 문서로 링크합니다.',
	'sf_property_allowedvals' => '{{PLURAL:$1|이 양식에 대해 허용하는 값}}:',
	'sf_template_docu' => '"$1" 틀입니다.
다음 형식으로 호출해야 합니다:',
	'sf_template_docufooter' => '틀 텍스트를 보려면 문서를 편집하세요.',
	'sf_form_docu' => '"$1" 양식입니다.
이 양식으로 문서를 만드려면 아래에 문서 이름을 입력하세요.
이름이 이미 존재하는 문서이면 해당 문서를 편집할 양식에 보냅니다.',
	'sf_form_freetextlabel' => '자유 텍스트',
	'sf_category_hasdefaultform' => '이 분류는 $1 양식을 사용합니다.',
	'sf_category_desc' => '$1 분류입니다.',
	'sf_blank_namespace' => '주요',
	'right-viewedittab' => '양식에서 편집할 문서에 "{{int:edit}}" 탭을 보여줍니다',
	'right-editrestrictedfields' => '제한된 양식 입력란 편집',
	'right-createclass' => '새 시맨틱 클래스 만들기',
	'action-createclass' => '새 시맨틱 클래스 만들기',
	'action-editrestrictedfields' => '제한된 양식 입력란 편집',
	'action-viewedittab' => '양식에서 편집할 문서에 "{{int:edit}}" 탭을 보이기',
);

/** Krio (Krio)
 * @author Jose77
 */
$messages['kri'] = array(
	'sf_createtemplate_deletefield' => 'Dilit',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'sf_createtemplate_deletefield' => 'Para',
	'sf_createform_template' => 'Template',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'semanticforms-desc' => 'Fommulaare för Semantesch Date dabei ze donn, un och ze ändere',
	'specialpages-group-sf_group' => 'Semantesch Fommulaare',
	'createproperty' => 'Donn en Eijeschaff aanlääje',
	'sf_createproperty_linktoform' => 'Die Eijeschaff deiht dann op Sigge lingke, di hee dat Fommullaa bruche:',
	'sf_createproperty_allowedvalsinput' => 'Wann för die Eijeschaff bloß janz beshtemmpte Wääte müjjelesch sin, dann donn die hee op_leste. Schriif jede Wäät einzel op, un maach e Komma dozwsche. Wann De ene Wäät häs, woh e Komma en däm Wäät sellver dren enthallde es, donn för dat Komma ene <code>\\</code> schriive, alsu esu jet wi „<code>Mätze\\, Läffelle\\, un Jaffelle</code>“:',
	'sf_createproperty_propname' => 'Dä Eijeschaff ier Name:',
	'sf_createproperty_proptype' => 'Zoot:',
	'templates' => 'Schablone',
	'sf_templates_docu' => 'Hee di Schablone jidd_et em Wiki:',
	'sf_templates_definescat' => 'beshtemmp de Saachjrop: $1',
	'createtemplate' => 'En Schabloon aanlääje',
	'sf_createtemplate_namelabel' => 'Dä Schabloon iere Name:',
	'sf_createtemplate_categorylabel' => 'Met dä Schabloon beschrevve Saachjropp, wann_er ein doh es:',
	'sf_createtemplate_templatefields' => 'Felder vun de Schablohn',
	'sf_createtemplate_fieldsdesc' => 'Öm Felder en dä Schabloon ze han, moß De kein Name för di Felder mieh aanjevve. Et es jenooch, dänne ier Nommere ze weße, donn eifach 1, 2, 3, un esu wigger aanjevve, aan däm Plaz för de Name.',
	'sf_createtemplate_fieldname' => 'Dä Name för dat Feld:',
	'sf_createtemplate_displaylabel' => 'För Aanzezeije, de Opschreff för dat Feld:',
	'sf_createtemplate_semanticproperty' => 'Semantesch Eijeschaff:',
	'sf_createtemplate_fieldislist' => 'En dämm Feld kann en Leß met Wääte shtonn, met Kommas dozwesche',
	'sf_createtemplate_aggregation' => 'Aansammlong',
	'sf_createtemplate_aggregationdesc' => 'Öm op jede Sigg, di di Schabloon he bruch, all de Sigge opzeleste, di_j_en beshtemmpte Eijeschaff han, di op hee di Sigg zeije deiht, donn jenou di Eijeschaff hee dronger aanjevve:',
	'sf_createtemplate_aggregationlabel' => 'De Överschreff för de Leß:',
	'sf_createtemplate_outputformat' => 'Dat Fommaat för et Ußjävve:',
	'sf_createtemplate_standardformat' => 'Shtanndat', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Ene Kaste op de rääschte Sigg', # Fuzzy
	'sf_createtemplate_addfield' => 'E Feld dobei donn',
	'sf_createtemplate_deletefield' => 'Fottschmiiße',
	'sf_createtemplate_addtemplatebeforesave' => 'Do moß ald winnishßdens ein Schabloon en dat Fommulaa enjedraare hann, ih dat De jet afspeishere kanns.',
	'forms' => 'Fommulaare',
	'sf_forms_docu' => 'Hee di Fommulaare ham_mer em Wiki.',
	'sf_forminputs_mandatory' => 'Nüüdesch',
	'sf_forminputs_restricted' => 'Bloß de Wiki-Köbesse künne hee jet draan ändere.', # Fuzzy
	'sf_forminputs_listboxsize' => 'De Aanzahl Reihje för de Hühde vun dä Leß',
	'sf_forminputs_includetimezone' => 'Donn e Feld dobei för de Zickzohn enzejävve',
	'sf_forminputs_topcategory' => 'De övverjeodente Saachjropp för heh dä Knubbel vun Saachjroppe (nüüdesch)',
	'sf_forminputs_height' => 'De Hühde vun heh däm Fäld en Pixelle',
	'sf_forminputs_width' => 'De Breedt vun heh däm Fäld en Pixelle',
	'createform' => 'Donn e Fommulaa aanlääje',
	'sf_createform_nameinput' => 'Dä Name för dat Fommulaa',
	'sf_createform_nameinputdesc' => '(För jewöhnlesch deiht mer dat Fommulaa noh dä Houp-Schabloon deufe, woh et Date erin brängk):', # Fuzzy
	'sf_createform_template' => 'Schabloon:',
	'sf_createform_templatelabelinput' => 'Dä Name vun dä Schablon, wann ein jebruch weed:',
	'sf_createform_allowmultiple' => 'Donn zwesche noll un jede Aanzahl Oproofe vun dä Schabloon hee, en dä neu aanjelaate Sigg zohlohße', 
	'sf_createform_field' => 'Feld:',
	'sf_createform_fieldprop' => 'Dat Feld beschrief de Eijeschaff „$1“. Se es vun dä Zoot „$2“.',
	'sf_createform_fieldproplist' => 'Dat Feld beschrief en Leß met Ellemänte met dä Eijeschaff „$1“, vun dä Zoot „$2“.',
	'sf_createform_fieldpropunknowntype' => 'Dat Feld beschrief de Eijeschaff „$1“, wat fö_n Zoot Eijeschaff dat dat es, es nit jesaat.',
	'sf_createform_inputtype' => 'De Zoot vun dä Date för enzejävve:',
	'sf_createform_inputtypedefault' => '(dä Schtandatt)',
	'sf_createform_formlabel' => 'Däm Fommulaa singe Name:',
	'sf_createform_hidden' => 'Verschtoche',
	'sf_createform_removetemplate' => 'Maach de Schabloon fott',
	'sf_createform_addtemplate' => 'Donn en Schabloon dobei:',
	'sf_createform_beforetemplate' => 'Vör dä Schabloon:',
	'sf_createform_atend' => 'Aam Engk',
	'sf_createform_add' => 'Donn dobei',
	'sf_createform_choosefield' => 'Donn a Feld ußwähle, wat dobei kumme sull',
	'createcategory' => 'Donn en {{ns:Category}} aanlääje',
	'sf_createcategory_name' => 'Dä Saachjropp iere Name:',
	'sf_createcategory_defaultform' => 'Dat Shtandatt-Fommulaa:',
	'sf_createcategory_makesubcategory' => 'Donn di Saachjropp als Ongerjropp endraare en dä Saachjropp (udder lohß leddisch):',
	'createclass' => 'Zoot ov Klass aanlääje.',
	'sf_createclass_docu' => 'Donn hee all de Date enjevve, öm de Eijeschaffte, de SChabloon, dat Fommulaa, un de Saachjropp för en einzel Zoot ov Klass aanzelääje. Wann de mieh Müjjeleschkeite wells, donn de Sigg $1 doför nämme.',
	'sf_createclass_allowedvalues' => 'Zohjelohße Wääte', # Fuzzy
	'sf_createclass_listofvalues' => 'Leß met Wääte', # Fuzzy
	'sf_createclass_missingvalues' => 'Nit alle vun de nüüdejje Felder sin ußjeföllt.',
	'sf_createclass_success' => 'De Eijeschaffte, en Schabloon, dat Fommulaa, un de Saachjrupp wäde aanjelaat.',
	'formstart' => 'Donn en Sigg dobei övver e Fommullaa',
	'sf_formstart_badform' => 'Ene Fähler es opjetrodde: Mer han kei Fommullaa „$1“ jefonge.',
	'sf_formstart_badtitle' => 'Fähler: „$1“ es ene onjöltige Sigggetittel.',
	'sf_formstart_docu' => 'Jiff hee dä Name vun dä Sigg en, di mem Fommulaa „$1“ beärbeidt wäde sull. Wann de Sigg ald doh es, küß De op dat Fommullaa, för di Sigg ze ändere. Söns küß De op dat Fommullaa för di Sigg aanzelääje.',
	'sf_formstart_noform_docu' => 'Jiff hee dä Name vun däm Sigg en, un donn dat Fommulaa ußsööke woh drövver di Sigg beärbeidt wäde sull. Wann di Sigg ald doh es, küß De op dat Fommullaa, för di Sigg ze ändere. Söns küß De op dat Fommullaa för di Sigg aanzelääje.',
	'sf_formstart_createoredit' => 'Dobei donn udder Ändere', # Fuzzy
	'formedit' => 'Date övver e Fommullaa änndere',
	'sf_formedit_createtitle' => 'Donn $1 dobei: $2', # Fuzzy
	'sf_formedit_createtitlenotarget' => 'Donn $1 aanlääje',
	'sf_formedit_badurl' => "Date es de Sigg för Date dobei ze donn. Do moß ene Name för e Fommulaa un för en Sigg an dä ierem <i lang=\"en\">URL</i> aanjevve. Dat sullt eu ähnlesch ußsinn, wieh: <code>{{#special:addData}}?form=''<Fomullaa_Name>''&target=''<Sigge_Name>''</code>, udder wi: <code>{{#special:addData}}/''<Fomullaa_Name >''/''<Sigge_Name>''</code>.",
	'sf_formedit_altforms' => 'Shtatt dämm kanns De di Sigg övver ein vun hee dä Fommulaare aanlääje:',
	'sf_formedit_altformsonly' => 'Donn ein vun dä Fommulaare ußwähle, öm di Sigg aanzelääje:',
	'sf_formcreate' => 'Övver e Fommulaa aanlääje',
	'sf_viewform' => 'Dat Fommullaa aanzeije',
	'sf_editsource' => 'Dä Quellkode Ändere',
	'sf_formedit_edittitle' => '$1 Ändere: $2',
	'sf_formedit_morethanoneform' => 'Opjepaß: Dör di Sigg hee es mieh wie ein Shtandadt-Fommulaa ennjeshtallt.',
	'sf_formedit_formwarning' => 'Opjepaß: Di Sigg <a href="$1">jidd_et aldt</a>, ävver se deiht hee dat Fommulaa nit bruche.',
	'sf_formedit_remove' => 'Fott nämme',
	'sf_formedit_addanother' => 'Donn noch mieh dobei',
	'sf_formedit_none' => 'Kei',
	'sf_formedit_emptytitle' => 'Fähler: De enjeföösh Daate sorrje för ene läddijje Tittel för di Sigg.',
	'sf_formedit_hookerror' => 'Fähler: En Zohsazprojramm vum MedijaWiki hät nit zohjelohße, di Ziel_Sigg ze ändere.',
	'sf_formedit_saveandcontinueediting' => 'Faßhallde un wigger maache',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Donn de Daate avshpeishere un dann wigger draan schrieve',
	'sf_autoedit_anoneditwarning' => 'Opjepaß: Weil De nit enjelogg bes, weed Ding <i lang="en">IP</i>-Adräß en dä Sigg ier Leß met de Versione faßjehallde wääde.',
	'sf_autoedit_success' => 'De Sigg [[$1]] es övver et Fommulaa $2 jeändert woode.',
	'runquery' => 'De Frooch loufe lohße',
	'sf_runquery_badurl' => "Do moß en däm <i lang=\"en\">URL</i> ene Nahme för e Fommulaa aanjävve.
Dat süüht dann esu us, wi <code>{{#special:RunQuery}}/''<Fomullaa_Name >''</code>.",
	'sf_runquery_title' => 'De Frooch „<code>$1</code>“ loufe lohße',
	'sf_runquery_additionalquery' => 'Zohsäzlejje Frooch',
	'sf_formerrors_header' => 'Mer han Fähler jefonge en däm, wat De enjejovve häß. Süsch doh:',
	'sf_blank_error' => 'kam_mer nit leddisch lohße',
	'sf_bad_url_error' => 'moß et reschteje Fomaat för en <i lang="en">URL</i> han un moß met <code>http</code> aanfange',
	'sf_bad_email_error' => 'moß et reschteje Fomaat för en <i lang="en">e-mail</i>-Adräß hann',
	'sf_bad_number_error' => 'moß en reschteje Zahl sin',
	'sf_bad_date_error' => 'moß e reschtesch Dattum sin',
	'uploadwindow' => 'Dat Finster för zem Huhlaade',
	'sf_deletionlog' => 'Logbooch vum Sigge Verschteische',
	'sf_property_isproperty' => 'Dat ess_en Eijeschaff vun dä Zoot $1.',
	'sf_property_linkstoform' => 'Et hät ene Lengk op Sigge, di dat Fommulaa „$1“ verwende donn.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dä einzijje müjjelesche Wäät för di Eijeschaff es:|De müjjelesche Wääte för di Eijeschaff sin:|Mer han kein müjjelesche Wääte för di Eijeschaff.}}',
	'sf_template_docu' => 'Dat es de Schabloon för „$1“, un dat Fommaat för se opzeroofe es:',
	'sf_template_docufooter' => 'Donn di Sigg zom Ändere oproofe, öm dä Schablone iere Enhalldt als Tex ze sinn ze krijje.',
	'sf_form_docu' => 'Dat hee de dat Fommullaa „$1“.
Öm hee met en Sigg aanzelääje, donn unge dä Name för di Sigg endraare. Sullt di Sigg ald doh sin, küß De op dat Fommullaa för di Sigg ze ändere.', # Fuzzy
	'sf_form_freetextlabel' => 'Freije Tex',
	'sf_category_hasdefaultform' => 'Hee di Saachjropp bruch dat Fommulaa „$1“.',
	'sf_category_desc' => 'Dat es de Saachjropp „$1“.',
	'sf_blank_namespace' => '{{int:blanknamespace}}',
	'right-viewedittab' => '„{{int:edit}}“-Lengk för Sigge, die mer övver Fommulaare ändere kann', # Fuzzy
	'right-editrestrictedfields' => 'Beschrängk zohjänglijje Felder en Fommulaare ändere',
);

/** Kurdish (Latin script) (Kurdî (latînî)‎)
 * @author George Animal
 */
$messages['ku-latn'] = array(
	'sf_createproperty_proptype' => 'Cure:',
	'createtemplate' => 'Şablonekî çêke',
	'sf_createtemplate_namelabel' => 'Navê şablonê:',
	'sf_createform_template' => 'Şablon:',
	'sf_createcategory_name' => 'Navê kategorîyê:',
);

/** Cornish (kernowek)
 * @author Kernoweger
 * @author Kw-Moon
 * @author Nrowe
 */
$messages['kw'] = array(
	'createtemplate' => 'Gwruthyl skantlyn',
	'sf_createform_template' => 'Skantlyn:',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'specialpages-group-sf_group' => 'Semantesch Formulairen',
	'sf_createproperty_propname' => 'Numm vun der Eegeschaft:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Schablounen',
	'sf_templates_docu' => 'Dës Schabloune gëtt et op dëser Wiki.',
	'sf_templates_definescat' => "definéiert d'Kategorie: $1",
	'createtemplate' => 'Eng nei Schabloun maachen',
	'sf_createtemplate_namelabel' => 'Numm vun der Schabloun:',
	'sf_createtemplate_categorylabel' => 'Kategorie déi duerch eng Schabloun definéiert ass (fakultativ):',
	'sf_createtemplate_templatefields' => 'Schablounefelder',
	'sf_createtemplate_fieldname' => 'Numm vum Feld:',
	'sf_createtemplate_displaylabel' => 'Etiquette weisen:',
	'sf_createtemplate_aggregation' => 'Resumé',
	'sf_createtemplate_aggregationlabel' => "Titel fir d'Lëscht:",
	'sf_createtemplate_standardformat' => 'Tabell',
	'sf_createtemplate_addfield' => 'Feld derbäisetzen',
	'sf_createtemplate_deletefield' => 'Läschen',
	'sf_createtemplate_addtemplatebeforesave' => 'Dir musst mindestens eng Schabloun an dëser Formulaire drasetzen ier Dir e späichere kënnt.',
	'forms' => 'Formulairen',
	'sf_forms_docu' => 'Dës Formulaire gëtt et op dëser Wiki.',
	'sf_forminputs_mandatory' => 'Obligatoresch',
	'sf_forminputs_restricted' => 'Nëmmen Administrateure kënnen dëst Feld änneren',
	'sf_forminputs_maxlength' => 'Déi maximal erlaabt Längt vum Text an dësem Feld',
	'sf_forminputs_existingvaluesonly' => 'Nëmme Wäerter zouloossen déi schonn an der Lëscht sinn',
	'createform' => 'E Formulaire uleeën',
	'sf_createform_nameinput' => 'Numm vum Formulaire',
	'sf_createform_template' => 'Schabloun:',
	'sf_createform_templatelabelinput' => 'Etiquette vun der Schabloun (fakultativ)',
	'sf_createform_field' => 'Feld:',
	'sf_createform_inputtypedefault' => '(Standardwert)',
	'sf_createform_formlabel' => 'Etikett vum Formulaire:',
	'sf_createform_hidden' => 'Verstoppt',
	'sf_createform_removetemplate' => 'Schablon ewechhuelen',
	'sf_createform_addtemplate' => 'Schabloun derbäisetzen:',
	'sf_createform_beforetemplate' => "Virun d'Schabloun:",
	'sf_createform_atend' => 'Um Enn',
	'sf_createform_add' => 'Derbäisetzen',
	'sf_createform_choosefield' => 'Sicht e Feld eraus fir derbäizesetzen',
	'createcategory' => 'Eng Kategorie maachen',
	'sf_createcategory_name' => 'Numm vun der Kategorie:',
	'sf_createcategory_defaultform' => 'Standard-Formulaire:',
	'sf_createcategory_makesubcategory' => 'Aus dëser Kategorie eng Ënnerkategorie vun enger anerer Kategorie maachen (optional):',
	'sf_createclass_allowedvalues' => 'Erlaabt Wäerter:',
	'sf_createclass_listofvalues' => 'Lëscht vun de Wäerter?',
	'sf_createclass_nameinput' => 'Numm vum Formulaire:',
	'sf_createclass_missingvalues' => 'Et goufen net all erfuederlech Felder ausgefëllt.',
	'sf_createclass_create' => 'Uleeën',
	'formstart' => 'Säit mat engem Formulaire derbäisetzen',
	'sf_formstart_badform' => 'Feeler: et gouf keng Formulaire-Säit op $1 fonnt.',
	'sf_formstart_badtitle' => 'Feeler: "$1" ass kee valaben Titel fir eng Säit',
	'sf_formstart_createoredit' => 'Uleeën oder änneren',
	'formedit' => 'Formulaire änneren',
	'sf_formedit_createtitle' => '$1: $2 uleeën',
	'sf_formedit_createtitlenotarget' => '$1 uleeën',
	'sf_formedit_altforms' => 'Dir kënnt dës Säit och mat engem vun dëse Formulairen derbäisetzen:',
	'sf_formedit_altformsonly' => 'Sicht w.e.g. e vun dëse Formulairen eraus fir dës Säit derbäizesetzen:',
	'sf_formcreate' => 'Mat engem Formulaire gemaach',
	'sf_viewform' => 'Formulaire weisen',
	'sf_editsource' => 'Quelltext änneren',
	'sf_formedit_edittitle' => 'Ännert $1: $2',
	'sf_formedit_formwarning' => 'Opgepasst: Dës Säit <a href="$1">gëtt et schonn</a>, awer si benotzt dëse Formulaire net.',
	'sf_formedit_remove' => 'Ewech huelen',
	'sf_formedit_addanother' => 'Nach een derbäisetzen',
	'sf_formedit_none' => 'Keen',
	'sf_formedit_saveandcontinueediting' => 'Späicheren a virufueren',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Date späicheren a mam Ännere virufueren',
	'sf_autoedit_anoneditwarning' => 'Opgepasst: Dir sidd net ageloggt. Dowéinst gëtt amplaz vun engem Benotzernumm Är IP Adress am Historique vun dëser Säit gespäichert.',
	'sf_autoedit_noformfound' => 'Kee Formulaire uginn.',
	'sf_autoedit_toomanyformsfound' => 'Fir dës Säit gëtt et méi wéi ee Formulaire.',
	'sf_autoedit_readonly' => "D'Datebank ass elo fir Ännerunge gespaart. Grond: $1",
	'sf-autoedit-wait' => 'Waart w.e.g. ...',
	'runquery' => 'Ufro ausféieren',
	'sf_runquery_title' => 'ausféiere vu der Ufro: $1',
	'sf_runquery_additionalquery' => 'Zousätzlech Ufro',
	'sf_formerrors_header' => 'Et ware Feeler andeem wat Dir an de Formulaire aginn hutt; kuckt hei ënnendrënner',
	'sf_blank_error' => 'Däerf net eidel sinn!',
	'sf_bad_url_error' => "muss de korrekten URL-format hunn, a mat 'http' ufänken",
	'sf_bad_email_error' => 'muss e valabelen E-Mailadresse-Format hunn',
	'sf_bad_number_error' => 'muss eng valabel Zuel sinn',
	'sf_bad_date_error' => 'muss e gëltegen Datum sinn',
	'uploadwindow' => 'Fënster fir eropzelueden',
	'sf_deletionlog' => 'Logbuch vum Läschen',
	'sf-pageschemas-createtitle' => 'Numm vum Formulaire fir nei Säiten:',
	'sf-pageschemas-edittitle' => 'Numm vum Formulaire fir Säiten déi et scho gëtt:',
	'sf_property_linkstoform' => 'Et ass mat Säite verlinkt déi de Formulaire $1 benotzen.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Den erlaabte Wäert fir dës Eegeschaft ass|Déi erlaabt Wäerter fir dës Eegeschaft sinn}}:',
	'sf_template_docu' => "Dëst ass d''$1'-Schabloun.
Si soll an dësem Format opgeruff ginn:",
	'sf_template_docufooter' => "Ännert d'Säit fir den Text vun der Schabloun ze gesinn",
	'sf_form_freetextlabel' => 'Fräien Text',
	'sf_category_hasdefaultform' => 'Dës Kategorie benotzt de Formelär $1.',
	'sf_category_desc' => "Dëst ass d'$1 Kategorie.",
	'sf_blank_namespace' => 'Haapt',
	'right-viewedittab' => '"Änneren"-Tab fir Säiten, déi duerch e Formlaire geännert kënne ginn, weisen', # Fuzzy
);

/** Limburgish (Limburgs)
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'createproperty' => 'Eigesjap aanmake',
	'sf_createproperty_propname' => 'Naam eigesjap:',
	'sf_createproperty_proptype' => 'Type:',
	'templates' => 'Sjablone',
	'createtemplate' => "'n Sjabloon aanmake",
	'forms' => 'Formelere',
	'createform' => 'Formeleer aanmake',
	'createcategory' => "'n Categorie aanmake",
	'formstart' => 'Pazjena toevoge',
	'sf_formstart_createoredit' => 'Maak aan of bewirk',
	'formedit' => 'Bewèrke mit dit formeleer',
	'sf_formedit_createtitle' => 'Maak $1 aan: $2',
	'sf_editsource' => 'Brón bewèrke',
	'sf_formedit_edittitle' => '$1 bewèrke: $2',
);

/** Lithuanian (lietuvių)
 * @author Domas
 */
$messages['lt'] = array(
	'createproperty' => 'Sukurti savybę',
	'sf_createproperty_allowedvalsinput' => 'Jeigu norite, kad šis laukas galėtų įgyti tik konkrečias reikšmes, surašykite visas leistinas reikšmes, atskirtas kableliais (jeigu reikšmė turi kablelį, pakeiskite jį į „\\,“):', # Fuzzy
	'sf_createproperty_propname' => 'Vardas:', # Fuzzy
	'sf_createproperty_proptype' => 'Tipas:',
	'templates' => 'Šablonai',
	'sf_templates_docu' => 'Šiame sąraše pateikiami visi šablonai.',
	'sf_templates_definescat' => 'apibrėžia kategoriją: $1',
	'createtemplate' => 'Sukurti šabloną',
	'sf_createtemplate_namelabel' => 'Šablono vardas:',
	'sf_createtemplate_categorylabel' => 'Kategorija apibrėžiama šiuo šablonu (nebūtina):',
	'sf_createtemplate_templatefields' => 'Šablono laukai',
	'sf_createtemplate_fieldsdesc' => 'Šablonui reikšmės gali būti nurodomos ir be laukų vardų. Tokiu atvėju šioje formoje vietoj konkrečių laukų vardų turėtų būti nurodomi indeksai (pvz. 1, 2, 3 ir t. t.).',
	'sf_createtemplate_fieldname' => 'Lauko vardas:',
	'sf_createtemplate_displaylabel' => 'Rodomas užrašas:',
	'sf_createtemplate_semanticproperty' => 'Semantinė savybė:',
	'sf_createtemplate_fieldislist' => 'Šis laukas gali turėti kelias kableliais atskirtas reikšmes.',
	'sf_createtemplate_aggregation' => 'Savybių surinkimas',
	'sf_createtemplate_aggregationdesc' => 'Užpildykite šiuos laukus, jeigu norite, kad kiekviename šį šabloną naudojančiame puslapyje būtų pateiktas straipsnių, kurie konkrečia savybe rodo į tą puslapį, sąrašas:', # Fuzzy
	'sf_createtemplate_aggregationlabel' => 'Sąrašo pavadinimas:',
	'sf_createtemplate_outputformat' => 'Išvedimo formatas:',
	'sf_createtemplate_standardformat' => 'Standartinis', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Informacinis langas dešinėje', # Fuzzy
	'sf_createtemplate_addfield' => 'Pridėti lauką',
	'sf_createtemplate_deletefield' => 'Pašalinti',
	'sf_createtemplate_addtemplatebeforesave' => 'Prieš išsaugant šią formą, būtina pridėti bent vieną lauką.',
	'forms' => 'Formos',
	'sf_forms_docu' => 'Šiame sąraše pateikiamos visos formos.',
	'sf_forminputs_mandatory' => 'Privalomas',
	'sf_forminputs_restricted' => 'Apribotas (jį redaguoti gali tik sysop naudotojai)', # Fuzzy
	'createform' => 'Sukurti formą',
	'sf_createform_nameinput' => 'Formos vardas (dažniausiai priimtina pavadinti pagrindinio formoje naudojamo šablono vardu):', # Fuzzy
	'sf_createform_template' => 'Šablonas:',
	'sf_createform_templatelabelinput' => 'Šablono kortelės užrašas (nebūtinas):',
	'sf_createform_allowmultiple' => 'Leisti kelis (arba nė vieno) šio šablono vienetus sukurtame puslapyje',
	'sf_createform_field' => 'Laukas:',
	'sf_createform_fieldprop' => 'Šis laukas apibrėžia „$2“ tipo savybę „$1“.',
	'sf_createform_fieldproplist' => 'Šis laukas apibrėžia elementų turinčių „$2“ tipo savybę „$1“.',
	'sf_createform_fieldpropunknowntype' => 'Šis laukas apibrėžia neapibrėžto tipo savybę „$1“.',
	'sf_createform_inputtype' => 'Įvedimo tipas:',
	'sf_createform_inputtypedefault' => '(pagrindinis)',
	'sf_createform_formlabel' => 'Formos užrašas:',
	'sf_createform_hidden' => 'Paslėptas',
	'sf_createform_removetemplate' => 'Pašalinti šabloną',
	'sf_createform_addtemplate' => 'Pridėti šabloną:',
	'sf_createform_beforetemplate' => 'Prieš šabloną:',
	'sf_createform_atend' => 'Pabaigoje',
	'sf_createform_add' => 'Pridėti',
	'sf_createform_choosefield' => 'Pasirinkite pridedama lauką',
	'createcategory' => 'Sukurti kategoriją',
	'sf_createcategory_name' => 'Vardas:', # Fuzzy
	'sf_createcategory_defaultform' => 'Pagrindinė forma:',
	'sf_createcategory_makesubcategory' => 'Padaryti kaip subkategoriją kitai kategorijai (nebūtina):',
	'formstart' => 'Sukurti puslapį naudojant formą',
	'sf_formstart_badform' => 'Klaida: nerastas naudojantis formą $1 puslapis',
	'sf_formstart_docu' => 'Įveskite puslapio vardą, kurį redaguosite su forma „$1“. Jeigu puslapis tokiu vardu egzistuoja, būsite nukreiptas į šio puslapio redagavimo formą. Kitu atveju, būsite nukreiptas į naujo puslapio kūrimo formą.',
	'sf_formstart_noform_docu' => 'Įveskite puslapio vardą ir pasirinkite formą kuria jį redaguosite. Jeigu puslapis tokiu vardu egzistuoja, būsite nukreiptas į šio puslapio redagavimo formą. Kitu atveju, būsite nukreiptas į naujo puslapio kūrimo formą.',
	'sf_formstart_createoredit' => 'Pridėti ar keisti', # Fuzzy
	'formedit' => 'Redaguoti su forma',
	'sf_formedit_createtitle' => 'Pridėti $1: $2', # Fuzzy
	'sf_formedit_badurl' => "Šis puslapis skirtas naujų duomenų įvedimui. Jūs turite adrese nurodyti formos vardą ir norimą redaguoti puslapį. Adresas turėtų atrodyti kaip „Specialus:FormEdit?form=<formos vardas>&target=<puslapis>“ arba „Specialus:FormEdit/<formos vardas>/<puslapis>'“.",
	'sf_formedit_altforms' => 'Sukurti puslapį galite naudodami vieną iš šių formų:',
	'sf_formedit_altformsonly' => 'Pasirinkite vieną iš šių formų puslapio sukūrimui:',
	'sf_viewform' => 'Rodyti formą',
	'sf_editsource' => 'Redaguoti kodą',
	'sf_formedit_edittitle' => 'Redaguoti $1: $2',
	'sf_formedit_formwarning' => 'Dėmesio: Šis puslapis <a href="$1">jau yra</a>, bet jis nenaudoja šios formos.',
	'sf_formedit_remove' => 'Pašalinti',
	'sf_formedit_addanother' => 'Pridėti kitą',
	'sf_formedit_none' => 'Nieko',
	'sf_formerrors_header' => 'Pildomoje formoje yra klaidų. Žiūrėkite žemiau',
	'sf_blank_error' => 'negali būti tuščias',
	'sf_bad_url_error' => 'turi būti taisyklinga nuoroda (URL), prasidedanti „http“',
	'sf_bad_email_error' => 'turi būti taisyklingas el. pašto adresas',
	'sf_bad_number_error' => 'turi būti skaičius',
	'sf_bad_date_error' => 'turi būti taisyklinga data',
	'uploadwindow' => 'Failo įkėlimo langas',
	'sf_property_isproperty' => 'Tai yra „$1“ tipo savybė.',
	'sf_property_allowedvals' => 'Šios savybės leidžiamos reikšmės yra:', # Fuzzy
	'sf_template_docu' => 'Tai yra „$1“ šablonas.
Jis turėtų būti kviečiamas šiuo formatu formatu:',
	'sf_template_docufooter' => 'Norėdami matyti šablono tekstą, turite redaguoti puslapį.',
	'sf_form_docu' => 'Tai yra „$1“ forma.
Norėdami sukurti puslapį naudojantis šia forma, įveskite to pulslapio vardą žemiau.
Jeigu puslapis tokiu vardu jau egzistuoja, šia forma galėsite jį redaguoti.', # Fuzzy
	'sf_form_freetextlabel' => 'Laisvas tekstas',
	'sf_category_hasdefaultform' => 'Ši kategorija naudoja „$1“ formą.',
	'sf_category_desc' => 'Tai yra „$1“ kategorija.',
	'sf_blank_namespace' => 'Pagrindinis',
);

/** Latvian (latviešu)
 * @author Ilmarmors
 * @author Papuass
 */
$messages['lv'] = array(
	'semanticforms-desc' => 'Formas semantisko datu pievienošanai un rediģēšanai',
	'specialpages-group-sf_group' => 'Semantiskās formas',
	'createproperty' => 'Izveidot īpašību',
	'sf_createproperty_linktoform' => 'Šī īpašība norādīs uz lapām, kas izmanto formu:',
	'sf_createproperty_allowedvalsinput' => 'Ja jūs gribiet, lai šī īpašība saturētu tikai noteiktas vērtības, ievadiet ar komatu atdalītu atļauto vērtību sarakstu (ja vērtība satur komatu, tad aizvietojiet to ar "\\,"):',
	'sf_createproperty_propname' => 'Īpašības nosaukums:',
	'sf_createproperty_proptype' => 'Tips:',
	'templates' => 'Veidnes',
	'sf_templates_docu' => 'Wiki pastāv sekojošas veidnes.',
	'sf_templates_definescat' => 'definē kategoriju: $1',
	'createtemplate' => 'Izveidot veidni',
	'sf_createtemplate_namelabel' => 'Veidnes nosaukums:',
	'sf_createtemplate_categorylabel' => 'Kategorija, ko definē veidne (neobligāta):',
	'sf_createtemplate_templatefields' => 'Veidnes lauki',
	'sf_createtemplate_fieldsdesc' => 'Definējot veidnes laukus, īstā nosaukuma vietā var vienkārši ievadīt katra lauka indeksu (piemēram, 1, 2, 3 utt.).',
	'sf_createtemplate_fieldname' => 'Lauka nosaukums:',
	'sf_createtemplate_displaylabel' => 'Rādāmā iezīme:',
	'sf_createtemplate_semanticproperty' => 'Semantiskā īpašība:',
	'sf_createtemplate_fieldislist' => 'Šajā laukā var būt ar komatiem atdalītu vērtību saraksts',
	'sf_createtemplate_aggregation' => 'Agregēšana',
	'sf_createtemplate_aggregationdesc' => 'Lai lapā, kas izmanto šo veidni, izveidotu sarakstu ar visām lapām, kuru noteikta īpašība norāda uz to lapu, norādiet atbilstošo īpašību zemāk:',
	'sf_createtemplate_aggregationlabel' => 'Saraksta virsraksts:',
	'sf_createtemplate_outputformat' => 'Izvades formāts:',
	'sf_createtemplate_standardformat' => 'standarta', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'infokaste labajā pusē', # Fuzzy
	'sf_createtemplate_addfield' => 'Pievienot lauku',
	'sf_createtemplate_deletefield' => 'Izdzēst',
	'sf_createtemplate_addtemplatebeforesave' => 'Jāpievieno vismaz viena veidne, lai varētu saglabāt formu.',
	'forms' => 'Formas',
	'sf_forms_docu' => 'Wiki ir sekojošas formas.',
	'sf_forminputs_mandatory' => 'Šim laukam obligāti jāievada vērtība',
	'sf_forminputs_restricted' => 'Šo lauku var rediģēt tikai administratori',
	'sf_forminputs_class' => 'Šī ievadlauka HTML "class" atribūts',
	'sf_forminputs_default' => 'Noklusējuma vērtība šim ievadlaukam',
	'sf_forminputs_preload' => 'Wiki lapa, kuras saturs kļūs par šī ievadlauka noklusējuma vērtību',
	'sf_forminputs_property' => 'Šim laukam atbilstošā semantiskā īpašība',
	'sf_forminputs_size' => 'Šī teksta lauka lielums rakstzīmēs',
	'sf_forminputs_maxlength' => 'Maksimālais atļautais teksta garums šajā laukā',
	'sf_forminputs_placeholder' => 'Palīdzības teksts, kas pārādās ievadlaukā līdz brīdim, kas lietotājs noklikšķina uz tā.',
	'sf_forminputs_uploadable' => 'Novietot saiti "Augšupielādēt failu" blakus šim ievadlaukam', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Noklusētais nosaukums augšupielādētiem failiem',
	'sf_forminputs_rows' => 'Rindu skaits šajā ievadlaukā',
	'sf_forminputs_cols' => 'Kolonnu skaits šajā ievadlaukā',
	'sf_forminputs_autogrow' => 'Iestatīt automātisku šī ievadlauka palielināšanu, ja teksts pārsniedz tā robežas',
	'sf_forminputs_valuesfromproperty' => 'Īpašība, kuras vērtības būs šī ievades lauka vērtību kopa',
	'sf_forminputs_valuesfromcategory' => 'Kategorijas, kurai piederošās lapas būs šī ievades lauka vērtību kopa',
	'sf_forminputs_valuesfromnamespace' => 'Vārdtelpa, kuras vērtības būs šī ievades lauka vērtību kopa',
	'sf_forminputs_valuesfromconcept' => 'Semantiskā MediaWiki jēdziens, kurai piederošās lapas būs šī ievades lauka vērtību kopa',
	'sf_forminputs_valuesfromurl' => 'Tīmekļa adrese, kas satur strukturētus datus, kas būs šī ievades lauka vērtību kopa',
	'sf_forminputs_values' => 'Ar komatu atdalīta vērtību kopa šim ievades laukam',
	'sf_forminputs_list' => 'Atzīmēt šo ievades lauku kā vērtību sarakstu',
	'sf_forminputs_delimiter' => 'Atdalītājs starp lauka vērtībām, ja šis ievades lauks satur vērtību sarakstu',
	'sf_forminputs_remoteautocompletion' => 'Izmantot attālo automātisko pabeigšanu',
	'sf_forminputs_existingvaluesonly' => 'Atļaut tikai vērtības, kas ir sarakstā',
	'sf_forminputs_showonselect' => 'Rādīt lapas elementus tikai, ja ir izvēlētas noteiktas vērtības (piemēram: "vērtība1 => div1; vērtība2 => div2")',
	'sf_forminputs_listboxsize' => 'Sarakstlodziņa augstums rindās',
	'sf_forminputs_includetimezone' => 'Ietvert ievades lauku laika joslai',
	'sf_forminputs_topcategory' => 'Šīs kategoriju kopas vecākkategorija (obligāta)',
	'sf_forminputs_hideroot' => 'Paslēpt vecākkategoriju',
	'sf_forminputs_height' => 'Šī ievades lauka augstums pikseļos',
	'sf_forminputs_width' => 'Šī ievades lauka platums pikseļos',
	'createform' => 'Izveidot formu',
	'sf_createform_nameinput' => 'Formas nosaukums',
	'sf_createform_nameinputdesc' => '(parasti formas nosaukums ir tāds pats kā galvenajai veidnei)',
	'sf_createform_template' => 'Veidne:',
	'sf_createform_templatelabelinput' => 'Veidnes iezīme (neobligāta)',
	'sf_createform_allowmultiple' => 'Atļaut vairākas (vai nevienu) šīs veidnes instances izveidojamajā lapā',
	'sf_createform_field' => 'Lauks:',
	'sf_createform_fieldprop' => 'Šis lauks definē īpašību $1 ar tipu $2',
	'sf_createform_fieldproplist' => 'Šis lauks definē sarakstu ar elementiem, kuriem ir īpašība $1 ar tipu $2',
	'sf_createform_fieldpropunknowntype' => 'Šis lauks definē īpašību $1 ar nenorādītu tipu.',
	'sf_createform_inputtype' => 'Ievadlauka tips:',
	'sf_createform_inputtypedefault' => '(pēc noklusējuma)',
	'sf_createform_formlabel' => 'Formas iezīme:',
	'sf_createform_hidden' => 'paslēpta',
	'sf_createform_removetemplate' => 'Noņemt veidni',
	'sf_createform_addtemplate' => 'Pievienot veidni:',
	'sf_createform_beforetemplate' => 'Pirms veidnes:',
	'sf_createform_atend' => 'Beigās',
	'sf_createform_add' => 'Pievienot',
	'sf_createform_choosefield' => 'Izvēlieties lauku, ko pievienot',
	'createcategory' => 'Izveidot kategoriju',
	'sf_createcategory_name' => 'Kategorijas nosaukums:',
	'sf_createcategory_defaultform' => 'Noklusējuma forma:',
	'sf_createcategory_makesubcategory' => 'Padarīt to kā apakškategoriju citai kategorijai (neobligāti)',
	'createclass' => 'Izveidot klasi',
	'sf_createclass_allowedvalues' => 'Atļautās vērtības:',
	'sf_createclass_listofvalues' => 'Vērtību saraksts?',
	'sf_createclass_nameinput' => 'Formas nosaukums',
	'sf_createclass_missingvalues' => 'Nav aizpildīti visi nepieciešamie lauki.',
	'sf_createclass_create' => 'Izveidot',
	'sf_formstart_badtitle' => 'Kļūda: "$1" nav derīgs lapas nosaukums.',
	'sf_formstart_createoredit' => 'Izveidot vai rediģēt',
	'formedit' => 'Labot ar formu',
	'sf_formedit_createtitlenotarget' => 'Izveidot $1',
	'sf_formedit_altformsonly' => 'Lūdzu, izvēlieties vienu no sekojošām formām, lai pievienotu šo lapu:',
	'sf_formcreate' => 'Izveidot ar formu',
	'sf_viewform' => 'Skatīt formu',
	'sf_formedit_saveandcontinueediting' => 'Saglabāt un turpināt',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Saglabāt datus un turpināt rediģēšanu',
	'sf_autoedit_notargetspecified' => 'Nav norādīta mērķlapa.',
	'sf_autoedit_noformfound' => 'Nav norādīta forma.',
	'sf_autoedit_toomanyformsfound' => 'Lapai pieejama vairāk kā viena forma.',
	'runquery' => 'Izpildildīt vaicājumu',
	'sf_runquery_title' => 'Izpildīt vaicājumu: $1',
	'sf_runquery_additionalquery' => 'Papildu vaicājums',
	'sf_formerrors_header' => 'Ievades formā ir atrastas kļūdas; skatīt zemāk.',
	'sf_blank_error' => 'nevar būt tukšs',
	'sf_bad_url_error' => 'jābūt derīgai tīmekļa adresei (URL), kas sākas ar "http"',
	'sf_bad_email_error' => 'jābūt derīgam e-pasta adreses formātam',
	'sf_bad_number_error' => 'jābūt derīgam skaitlim',
	'sf_bad_date_error' => 'jābūt derīgam datumam',
	'uploadwindow' => 'Augšupielādes logs',
	'sf_deletionlog' => 'Dzēšanas reģistrs',
	'sf-pageschemas-pagenameformula' => 'Lapas nosaukuma formula:',
	'sf-pageschemas-createtitle' => 'Formas nosaukums jaunām lapām:',
	'sf-pageschemas-edittitle' => 'Formas nosaukums esošām lapām:',
	'sf_template_docufooter' => 'Rediģējiet lapu, lai aplūkotu veidnes tekstu.',
	'sf_form_freetextlabel' => 'Brīvais teksts',
	'sf_category_hasdefaultform' => 'Šī kategorija lieto formu $1.',
	'sf_category_desc' => 'Šī ir kategorija $1',
	'right-editrestrictedfields' => 'Rediģēt ierobežotos formas laukus',
	'right-createclass' => 'Izveidot jaunas semantiskās klases',
	'action-createclass' => 'izveidot jaunas semantiskās klases',
	'action-editrestrictedfields' => 'rediģēt ierobežotos formas laukus',
);

/** Eastern Mari (олык марий)
 * @author Сай
 */
$messages['mhr'] = array(
	'sf_createtemplate_deletefield' => 'Шӧраш',
	'sf_createform_inputtypedefault' => '(ойлыде)',
);

/** Minangkabau (Baso Minangkabau)
 * @author Naval Scene
 */
$messages['min'] = array(
	'sf_viewform' => 'Caliak formulir',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 * @author Brest
 */
$messages['mk'] = array(
	'semanticforms-desc' => 'Обрасци за додавање и уредување на семантички податоци',
	'specialpages-group-sf_group' => 'Семантички обрасци',
	'createproperty' => 'Создај својство',
	'sf-createproperty-with-name' => 'Создај својство: $1',
	'sf_createproperty_linktoform' => 'Ова својство ќе дава врски до страници што го користат образецот:',
	'sf_createproperty_allowedvalsinput' => 'Ако сакате ова својство да може да има само извесни вредности, внесете го списокот на дозволени вредности, одделени со запирки (ако некоја вредност содржи запирка, тогаш заменете ја запирката со „\\,“):',
	'sf_createproperty_propname' => 'Име на својството:',
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблони',
	'sf_templates_docu' => 'Во викито постојат следниве шаблони.',
	'sf_templates_definescat' => 'дефинира категорија: $1',
	'createtemplate' => 'Создај шаблон',
	'sf-createtemplate-with-name' => 'Создај шаблон: $1',
	'sf_createtemplate_namelabel' => 'Име на шаблонот:',
	'sf_createtemplate_multipleinstance' => 'Овој шаблон може да се става повеќекратно на истата страница.',
	'sf_createtemplate_categorylabel' => 'Категорија определена од шаблон (незадолжително):',
	'sf_createtemplate_templatefields' => 'Полиња на шаблонот:',
	'sf_createtemplate_fieldsdesc' => 'Ако сакате полињата во шаблонов повеќе да не бараат имиња, едноставно внесете индекс за секое поле (на пр. 1, 2, 3, и тн.) наместо фактичко име.',
	'sf_createtemplate_fieldname' => 'Име на полето:',
	'sf_createtemplate_displaylabel' => 'Натпис за приказ:',
	'sf_createtemplate_semanticproperty' => 'Семантичко својство:',
	'sf_createtemplate_fieldislist' => 'Ова поле може да содржи список на вредности, одделени со запирки',
	'sf_createtemplate_aggregation' => 'Насобирање',
	'sf_createtemplate_aggregationdesc' => 'За да ги наведете сите страници што имаат извесно својство кое покажува кон таа страница на било која страница што го користи овој шаблон, назначете го соодветното својство подолу:',
	'sf_createtemplate_aggregationlabel' => 'Наслов за списокот:',
	'sf_createtemplate_outputformat' => 'Формат на изводот:',
	'sf_createtemplate_standardformat' => 'Табела',
	'sf_createtemplate_infoboxformat' => 'Странична инфокутија',
	'sf_createtemplate_plainformat' => 'Прост текст',
	'sf_createtemplate_sectionsformat' => 'Поднаслови',
	'sf_createtemplate_addfield' => 'Додај поле',
	'sf_createtemplate_deletefield' => 'Избриши',
	'sf_createtemplate_addtemplatebeforesave' => 'Пред да можете да го зачувате, во образецов мора да додадете барем еден шаблон.',
	'forms' => 'Обрасци',
	'sf_forms_docu' => 'Во викито постојат следниве обрасци.',
	'sf_forminputs_mandatory' => 'Мора да внесете вредност за овој внос',
	'sf_forminputs_restricted' => 'Овој внос може да го уредуваат само администратори',
	'sf_forminputs_class' => 'HTML-атрибутот „class“ за овој внос',
	'sf_forminputs_default' => 'Основната вредност за овој внос',
	'sf_forminputs_preload' => 'Вики-страница чијашто содржина ќе стане основната вредност на овој внос',
	'sf_forminputs_property' => 'Семантичко својство на кое соодветствува ова поле',
	'sf_forminputs_size' => 'Големината на ова поле за текст, во знаци',
	'sf_forminputs_maxlength' => 'Максималната допуштена должина на текстот во полево',
	'sf_forminputs_placeholder' => 'Текст со помош што се прикажува во полето за внесување текст сè додека корисникот не стисне на него.',
	'sf_forminputs_uploadable' => 'Ставете врскa „Подигни податотека“ веднаш до овој внос',
	'sf_forminputs_defaultfilename' => 'Основно-зададено име на подигнатите податотеки',
	'sf_forminputs_rows' => 'Број на редови за овој внос',
	'sf_forminputs_cols' => 'Број на колони за овој внос',
	'sf_forminputs_autogrow' => 'Поставете го овој внос да расте во големина ако текстот ги надминува неговите граници',
	'sf_forminputs_valuesfromproperty' => 'Својство чиишто вредности во викито треба да се збирот вредности на овој внос',
	'sf_forminputs_valuesfromcategory' => 'Категорија чиишто страници треба да се збирот вредности на овој внос',
	'sf_forminputs_valuesfromnamespace' => 'Именски простор чиишто страници треба да се збирот вредности на овој внос',
	'sf_forminputs_valuesfromconcept' => '„Концептна“ страница на Семантички МедијаВики чиишто страници треба да се збирот вредности на овој внос',
	'sf_forminputs_valuesfromurl' => 'URL-адреса што содржи структурирани податоци што треба да се збирот вредности на овој внос',
	'sf_forminputs_values' => 'Збирот вредности за овој внос, одделени со запирки',
	'sf_forminputs_list' => 'Означи го овој внос како содржател на список на вредности',
	'sf_forminputs_delimiter' => 'Раздвојник помеѓу вредностите на полето, ако овој внос содржи нивен список',
	'sf_forminputs_remoteautocompletion' => 'Користи далечинско автодовршување',
	'sf_forminputs_existingvaluesonly' => 'Допуштај само вредности што се веќе на списокот',
	'sf_forminputs_showonselect' => 'Елементи на страницата за приказ само ако се одбрани извесни вредности (пример: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => 'Висината на списочното поле, во редови',
	'sf_forminputs_includetimezone' => 'Вклучи внос за овој часовен појас',
	'sf_forminputs_topcategory' => 'Матичната категорија на овој збир категории (задолжително)',
	'sf_forminputs_hideroot' => 'Скриј ја матичната категорија',
	'sf_forminputs_depth' => 'Колку нивоа на категории да се прикажуваат првично',
	'sf_forminputs_height' => 'Висината на овој внос, во пиксели',
	'sf_forminputs_width' => 'Ширината на овој внос, во пиксели',
	'createform' => 'Создај образец',
	'sf-createform-with-name' => 'Создај образец: $1',
	'sf_createform_nameinput' => 'Име на образецот',
	'sf_createform_nameinputdesc' => '(обично образецот се именува по главниот шаблон што го содржи):',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_templatelabelinput' => 'Наслов на шаблонот (незадолжително):',
	'sf_createform_allowmultiple' => 'Овозможи повеќе (наспроти нула) јавувања на овој шаблон во создадената страница',
	'sf_createform_field' => 'Поле:',
	'sf_createform_fieldprop' => 'Ова поле го дефинира својството $1, од типот $2.',
	'sf_createform_fieldproplist' => 'Ова поле определува список на елементите што го имаат својството $1, од типот $2.',
	'sf_createform_fieldpropunknowntype' => 'Ова поле го определува својството $1, од неназначен тип.',
	'sf_createform_inputtype' => 'Вносен тип:',
	'sf_createform_inputtypedefault' => '(по основно)',
	'sf_createform_formlabel' => 'Наслов на образецот:',
	'sf_createform_hidden' => 'Скриена',
	'sf_createform_removetemplate' => 'Отстрани шаблон',
	'sf_createform_addtemplate' => 'Додај шаблон:',
	'sf_createform_beforetemplate' => 'Пред шаблонот:',
	'sf_createform_atend' => 'На крај',
	'sf_createform_add' => 'Додај',
	'sf_createform_choosefield' => 'Одберете поле за додавање',
	'createcategory' => 'Создај категорија',
	'sf-createcategory-with-name' => 'Создај катетгорија: $1',
	'sf_createcategory_name' => 'Име на категоријата:',
	'sf_createcategory_defaultform' => 'Основен образец:',
	'sf_createcategory_makesubcategory' => 'Направи ова да биде поткатегорија на друга категорија (незадолжително):',
	'createclass' => 'Создај класа',
	'sf_createclass_docu' => 'Тука внесете ги сите податоци за да ги создадете својствата, шаблонот, образецот и категоријата за една класа. За повеќе можности за нагодување, употребете ја страницата $1.',
	'sf_createclass_allowedvalues' => 'Дозволени вредности:',
	'sf_createclass_listofvalues' => 'Список на вредности?',
	'sf_createclass_nameinput' => 'Име на образецот:',
	'sf_createclass_missingvalues' => 'Не се пополнети сите потребни полиња.',
	'sf_createclass_success' => 'Ќе бидат создадени својства, шаблон, образец и категорија.',
	'sf_createclass_create' => 'Создај',
	'formstart' => 'Додај страница со образец',
	'sf_formstart_badform' => 'Грешка: на $1 не е пронајден образец',
	'sf_formstart_badtitle' => 'Грешка: „$1“ не претставува важечки наслов за страница.',
	'sf_formstart_docu' => 'Тука внесете го името на страницата која ќе се уредува со образецот „$1“.
Ако оваа страница веќе постои, ќе ви бидете пренасочени кон образецот за уредување на таа страница.
Ако не постои, ќе бидете пренасочени кон образецот за додавање на страницата.',
	'sf_formstart_noform_docu' => 'Тука внесете го името на страницата, и одберете го образецот со кој ќе уредувате.
Ако оваа страница веќе постои, ќе ви бидете пренасочени кон образецот за уредување.
Ако не постои, ќе бидете пренасочени кон образецот за додавање на страницата.',
	'sf_formstart_createoredit' => 'Создај или уреди',
	'formedit' => 'Уреди со образец',
	'sf_formedit_createtitle' => 'Создавање на $1: $2',
	'sf_formedit_createtitlenotarget' => 'Создај $1',
	'sf_formedit_badurl' => 'Оваа страница служи за уредување со помош на образец. Мора да назначите име на образецот и целна страница во URL-адресата;
тоа треба да изгледа како „Special:FormEdit?form=<form name>&target=<target page>“ или „Special:FormEdit/<form name>/<target page>“.',
	'sf_formedit_altforms' => 'Наместо тоа, можете да ја додадете оваа страница со еден од следниве обрасци:',
	'sf_formedit_altformsonly' => 'Одберете еден од следните обрасци за додавање на страницата:',
	'sf_formcreate' => 'Создај со образец',
	'sf_viewform' => 'Погл. образецот',
	'sf_editsource' => 'Уреди го изворот',
	'sf_formedit_edittitle' => 'Уреди $1: $2',
	'sf_formedit_morethanoneform' => "'''Предупредување:''' за оваа страница е определен повеќе од еден основен образец.",
	'sf_formedit_formwarning' => 'Предупредување: Оваа страница <a href="$1">веќе постои</a>, но не го користи овој образец.',
	'sf_formedit_mismatchedbrackets' => 'Предупредување: Оваа страница содржи кадрави и квадратни загради што не се затворени, па затоа образецот не може да ја обработи страницата. <a href="$1">Исправете ја грешката во изворниот текст</a> пред да продолжите.',
	'sf_formedit_remove' => 'Отстрани го примероков',
	'sf_formedit_addanotherabove' => 'Додај друг примерок над овој',
	'sf_formedit_addanother' => 'Додај уште',
	'sf_formedit_none' => 'Нема',
	'sf_formedit_emptytitle' => 'Грешка: Вметнатите податоци предизвикуваат празен наслов на статијата.',
	'sf_formedit_hookerror' => 'Грешка: Менувањето на целната статија е спречено од додаток на МедијаВики.',
	'sf_formedit_saveandcontinueediting' => 'Зачувај и продолжи',
	'sf_formedit_saveandcontinue_summary' => 'Зачувано со копчето „$1“ во образецот',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Зачувајте ги податоците и продолжите со уредување',
	'sf_autoedit_anoneditwarning' => 'Предупредување: Не сте најавени. Вашата IP-адреса ќе биде заведена во историјата на страницава.',
	'sf_autoedit_success' => 'Измените на [[$1]] се успешно извршени користејќи го образецот $2.',
	'sf_autoedit_fail' => 'Измената на [[$1]] не успеа.',
	'sf_autoedit_notargetspecified' => 'Нема наведено целна страница',
	'sf_autoedit_invalidtargetspecified' => 'Укажаната целна страница $1 е погрешна.',
	'sf_autoedit_invalidform' => '$1 не претставува важечки образец.',
	'sf_autoedit_redirectlimitexeeded' => 'Достигнат е максималниот дозволен број на пренасочувања за образецот $1.',
	'sf_autoedit_invalidredirecttarget' => '$1 е неважечка цел на пренасочување за образецот $2.',
	'sf_autoedit_invalidpreloadspecified' => 'Укажаната претвчитана страница $1 е погрешна.',
	'sf_autoedit_redlinkexists' => '$1 веќе постои.',
	'sf_autoedit_noformfound' => 'Нема наведено образец',
	'sf_autoedit_toomanyformsfound' => 'На располагање имате повеќе од еден образец за страницата.',
	'sf_autoedit_readonly' => 'Базата на податоци моментално е заклучена поради измени. Причина: $1',
	'sf_autoedit_nosemanticform' => 'Не можев да го добијам образецот $2 за страницата $1. Поподробно на [[{{#special:FormEdit}}/$2/$1]].',
	'sf_autoedit_summary' => 'Автоматски уредено од страницата $1.',
	'sf-autoedit-wait' => 'Почекајте...',
	'runquery' => 'Пушти барање',
	'sf_runquery_badurl' => 'Мора да назначите име на образецот во URL-адресата;
URL-адресата треба да изгледа вака: „Special:RunQuery/<form name>“.',
	'sf_runquery_title' => 'Постави прашање: $1',
	'sf_runquery_additionalquery' => 'Дополнително прашање',
	'sf_formerrors_header' => 'Најдени се грешки во вносот на образецот; погледајте подолу',
	'sf_blank_error' => 'не може да стои празно',
	'sf_bad_url_error' => 'мора да има правилен URL формат, кој почнува со „http“',
	'sf_bad_email_error' => 'мора да има важечки формат на е-поштенска адреса',
	'sf_bad_number_error' => 'мора да биде важечки број',
	'sf_bad_date_error' => 'мора да биде важечки датум',
	'uploadwindow' => 'Прозорец за подигање',
	'sf_deletionlog' => 'Дневник на бришења',
	'sf-preview-header' => 'Преглед на образецот',
	'sf-preview-note' => 'Вака ќе изгледа образецот кога ќе се користи:',
	'sf-pageschemas-pagenameformula' => 'Формула за името на страницата:',
	'sf-pageschemas-createtitle' => 'Наслов на образецот за нови страници:',
	'sf-pageschemas-edittitle' => 'Наслов на образецот за постоечки страници:',
	'sf-pageschemas-inputtype' => 'Тип на внос (оставете празно за да биде по основно):',
	'sf_property_isproperty' => 'Ова е својство од типот $1.',
	'sf_property_linkstoform' => 'Дава врски кон страниците кои го користат образецот $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Дозволената вредност за ова својство е|Дозволените вредности за ова својство се}}:',
	'sf_template_docu' => 'Ова е шаблонот „$1“.
Треба да се повикува во следниов формат:',
	'sf_template_docufooter' => 'Почнете со уредување на страницата за да го видите текстот на шаблонот.',
	'sf_form_docu' => 'Ова е образецот „$1“.
За да создадете страница со овој образец, внесете го името на страницата подолу;
ако веќе постои така именувана страница, ќе бидете пренасочени кон образец за уредување на таа страница.',
	'sf_form_freetextlabel' => 'Слободен текст',
	'sf_category_hasdefaultform' => 'Оваа категорија го користи образецот $1.',
	'sf_category_desc' => 'Ова е категоријата $1.',
	'sf_blank_namespace' => 'Главен',
	'right-viewedittab' => 'Приказ на јазиче „{{int:edit}}“ за страниците уредливи со образец',
	'right-editrestrictedfields' => 'Уредување на заштитени полиња на обрасци',
	'right-createclass' => 'Создавање на нови семантички класи',
	'action-createclass' => 'создавање на нови семантички класи',
	'action-editrestrictedfields' => 'уредување на заштитени полиња на обрасци',
	'action-viewedittab' => 'приказ на јазичето „{{int:edit}}“ кај страниците уредливи со образец',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'sf_createproperty_propname' => 'പേര്‌:', # Fuzzy
	'sf_createproperty_proptype' => 'തരം:',
	'templates' => 'ഫലകങ്ങൾ',
	'sf_templates_docu' => 'താഴെ പ്രദർശിപ്പിച്ചിരിക്കുന്ന ഫലകങ്ങൾ ഈ വിക്കിയിൽ നിലവിലുണ്ട്.',
	'sf_templates_definescat' => 'വർഗ്ഗം നിർ‌വചിക്കുന്നു: $1',
	'createtemplate' => 'ഫലകം നിർമ്മിക്കുക',
	'sf_createtemplate_namelabel' => 'ഫലകത്തിന്റെ പേര്‌:',
	'sf_createtemplate_categorylabel' => 'ഫലകം ഉപയോഗിച്ചു്‌ നിർ‌വചിച്ച വർഗ്ഗം (നിർബന്ധമില്ല):',
	'sf_createtemplate_aggregationlabel' => 'പട്ടികയ്ക്കുള്ള തലക്കെട്ട്:',
	'sf_createtemplate_outputformat' => 'ഔട്ട്പുട്ട് ഫോർമാറ്റ്:',
	'sf_createtemplate_standardformat' => 'മാനകം', # Fuzzy
	'sf_createtemplate_deletefield' => 'മായ്ക്കുക',
	'sf_forminputs_mandatory' => 'നിർബന്ധം',
	'sf_forminputs_restricted' => 'നിയന്ത്രിതം (സിസോപ്പുകൾക്ക് മാത്രമേ ഇതു തിരുത്താൻ സാധിക്കൂ)', # Fuzzy
	'createform' => 'ഫോം സൃഷ്ടിക്കുക',
	'sf_createform_template' => 'ഫലകം:',
	'sf_createform_field' => 'ഫീൽഡ്:',
	'sf_createform_inputtype' => 'ഇൻ‌പുട്ട് തരം:',
	'sf_createform_inputtypedefault' => '(സ്വതേ)',
	'sf_createform_hidden' => 'മറഞ്ഞിരിക്കുന്നത്',
	'sf_createform_removetemplate' => 'ഫലകം മാറ്റുക',
	'sf_createform_addtemplate' => 'ഫലകം ചേർക്കുക:',
	'sf_createform_beforetemplate' => 'ഫലകത്തിനു മുൻപ്:',
	'sf_createform_atend' => 'അവസാനത്തിൽ',
	'sf_createform_add' => 'ചേർക്കുക',
	'createcategory' => 'വർഗ്ഗം സൃഷ്ടിക്കുക',
	'sf_createcategory_name' => 'പേര്‌:', # Fuzzy
	'sf_createcategory_defaultform' => 'സ്വതവെയുള്ള ഫോം:',
	'sf_createcategory_makesubcategory' => 'ഇതു മറ്റൊരു വർഗ്ഗത്തിന്റെ ഉപവർഗ്ഗമാക്കുക (നിർബന്ധമില്ല):',
	'sf_formstart_badform' => 'പിഴവ്: $1ല്‍ ഫോം താള്‍ ഒന്നും കണ്ടില്ല',
	'sf_formstart_createoredit' => 'സൃഷ്ടിക്കുക അല്ലെങ്കിൽ തിരുത്തുക',
	'formedit' => 'ഫോം ഉപയോഗിച്ചു തിരുത്തുക',
	'sf_formedit_createtitle' => '$1 സൃഷ്ടിക്കുക: $2',
	'sf_formedit_altformsonly' => 'ഈ താള്‍ ചേര്‍ക്കുവാന്‍ താഴെ കൊടുത്തിട്ടുള്ള ഫോമുകളില്‍ ഒന്ന് തിരഞ്ഞെടുക്കുക:',
	'sf_viewform' => 'ഫോം കാണുക',
	'sf_editsource' => 'മൂലരൂപം തിരുത്തുക',
	'sf_formedit_edittitle' => '$1 തിരുത്തുക: $2',
	'sf_formedit_remove' => 'നീക്കം ചെയ്യുക',
	'sf_formedit_addanother' => 'മറ്റൊന്ന് ചേര്‍ക്കുക',
	'sf_formedit_none' => 'ഒന്നുമില്ല',
	'sf_formerrors_header' => 'താങ്കളുടെ ഇൻപുട്ട് ഫോമിൽ പിഴവുകൾ ഉണ്ട്; താഴെ കാണുക',
	'sf_blank_error' => 'ശൂന്യമാക്കിയിടുന്നത് അനുവദനീയമല്ല',
	'sf_bad_url_error' => "'http' എന്നു തുടങ്ങുന്ന ശരിയായ URL രൂപം ഉപയോഗിക്കണം",
	'sf_bad_email_error' => 'സാധുവായ ഇമെയിൽ വിലാസ ഫോർമാറ്റ് നിർബന്ധമാണ്‌',
	'sf_bad_number_error' => 'സാധുവായ സംഖ്യ നിർബന്ധമാണ്‌',
	'sf_bad_date_error' => 'സാധുവായ തീയതി നിർബന്ധമാണ്‌',
	'sf_template_docufooter' => 'ഫലകത്തിന്റെ ഉള്ളടക്കം കാണാൻ താൾ തിരുത്തുക.',
	'sf_category_hasdefaultform' => 'ഈ വർഗ്ഗം $1 എന്ന ഫോം ഉപയോഗിക്കുന്നു.',
	'sf_category_desc' => 'ഇതു $1 എന്ന വർഗ്ഗമാണ്‌.',
	'sf_blank_namespace' => 'മുഖ്യം',
);

/** Mongolian (монгол)
 * @author Chinneeb
 */
$messages['mn'] = array(
	'sf_createform_add' => 'Нэмэх',
	'sf_deletionlog' => 'Устгалын лог',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Mahitgar
 */
$messages['mr'] = array(
	'createproperty' => 'एक गुणधर्म तयार करा',
	'sf_createproperty_allowedvalsinput' => 'जर तुम्ही या रकान्यात फक्त काहीच किंमती भरू इच्छित असाल, तर त्यांची यादी बनवा, स्वल्पविरामाने किंमतींमध्ये फरक दाखवा (जर एखाद्या किंमतीतच स्वल्पविराम येत असेल, तर त्या जागी "\\," लिहा):', # Fuzzy
	'sf_createproperty_propname' => 'नाव:', # Fuzzy
	'sf_createproperty_proptype' => 'प्रकार:',
	'templates' => 'साचे',
	'sf_templates_docu' => 'या विकिवर खालील साचे उपलब्ध आहेत.',
	'sf_templates_definescat' => 'वर्गाची व्याख्या: $1',
	'createtemplate' => 'साचा तयार करा',
	'sf_createtemplate_namelabel' => 'साच्याचे नाव:',
	'sf_createtemplate_categorylabel' => 'साचा कुठल्या वर्गात आहे (वैकल्पिक):',
	'sf_createtemplate_templatefields' => 'साच्यातील रकाने',
	'sf_createtemplate_fieldsdesc' => 'जर या साच्यातील रकान्यांना नावे द्यायची नसतील, तर खर्‍या नावांऐवजी फक्त क्रमांक द्या (उदा. १, २, ३, इ.).',
	'sf_createtemplate_fieldname' => 'रकाना नाव:',
	'sf_createtemplate_displaylabel' => 'दाखविण्याचे लेबल:',
	'sf_createtemplate_semanticproperty' => 'सिमॅंटिक गुणधर्म:',
	'sf_createtemplate_fieldislist' => 'हा रकाना स्वल्पविरामाने वाटलेली किंमतींची यादी दर्शवितो',
	'sf_createtemplate_aggregation' => 'एकत्रीकरण',
	'sf_createtemplate_aggregationdesc' => 'एखाद्या पानावर असणार्‍या गुणधर्माला निर्देश करणारी पाने, ज्यांमध्ये हा साचा वापरण्यात आलेला आहे, अशा पानांची यादी करण्यासाठी तो गुणधर्म खाली लिहा:', # Fuzzy
	'sf_createtemplate_aggregationlabel' => 'यादी साठी शीर्षक:',
	'sf_createtemplate_outputformat' => 'आउटपुटची रूपरेषा:',
	'sf_createtemplate_standardformat' => 'स्टॅंडर्ड', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'उजवीकडील माहितीचौकट', # Fuzzy
	'sf_createtemplate_addfield' => 'रकाना वाढवा',
	'sf_createtemplate_deletefield' => 'वगळा',
	'sf_createtemplate_addtemplatebeforesave' => 'हा अर्ज जतन करण्यापूर्वी तुम्ही कमीत कमी एक साचा देणे आवश्यक आहे.',
	'forms' => 'अर्ज',
	'sf_forms_docu' => 'विकिवर खालील अर्ज उपलब्ध आहेत.',
	'sf_forminputs_mandatory' => 'अत्यावश्यक',
	'sf_forminputs_restricted' => 'प्रतिबंधित (फक्त प्रबंधकच बदलू शकतात)', # Fuzzy
	'createform' => 'नवीन अर्ज बनवा',
	'sf_createform_nameinput' => 'अर्जाचे नाव (सर्वसाधारणपणे अर्ज ज्या मुख्य साच्यासाठी आहे त्या साच्याच्या नावानंतर अर्जाचे नाव असे लिहावे):', # Fuzzy
	'sf_createform_template' => 'साचा:',
	'sf_createform_templatelabelinput' => 'साच्याचे लेबल (वैकल्पिक):',
	'sf_createform_allowmultiple' => 'तयार केलेल्या पानावर हा साचा अनेकवेळा (किंवा शून्यवेळा) वापरण्याची परवानगी द्या', # Fuzzy
	'sf_createform_field' => 'रकाना:',
	'sf_createform_fieldprop' => 'हा रकाना $2 या प्रकारचा $1 हा गुणधर्म सांगतो.',
	'sf_createform_fieldproplist' => 'हा रकाना $2 या प्रकारचे $1 गुणधर्म असणार्‍या एलेमेंट्स ची यादी देतो.',
	'sf_createform_fieldpropunknowntype' => 'हा रकाना अनोळखी प्रकारचा $1 हा गुणधर्म देतो.',
	'sf_createform_inputtype' => 'इनपुट प्रकार:',
	'sf_createform_inputtypedefault' => '(अविचल)',
	'sf_createform_formlabel' => 'अर्ज लेबल:',
	'sf_createform_hidden' => 'लपविलेले',
	'sf_createform_removetemplate' => 'साचा काढा',
	'sf_createform_addtemplate' => 'साचा वाढवा:',
	'sf_createform_beforetemplate' => 'या साच्याच्या आधी:',
	'sf_createform_atend' => 'शेवटी',
	'sf_createform_add' => 'वाढवा',
	'sf_createform_choosefield' => 'वाढविण्यासाठी एक रकाना निवडा',
	'createcategory' => 'वर्ग बनवा',
	'sf_createcategory_name' => 'नाव:', # Fuzzy
	'sf_createcategory_defaultform' => 'अविचल अर्ज:',
	'sf_createcategory_makesubcategory' => 'याला एका दुसर्‍या वर्गाचा उपवर्ग बनवा (वैकल्पिक):',
	'formstart' => 'पान वाढवा',
	'sf_formstart_badform' => 'त्रुटी: $1 वर कुठलेही अर्ज पान सापडलेले नाही',
	'sf_formstart_docu' => "'$1' अर्जाचा वापर करून बदलण्यात येणार्‍या पानाचे नाव इथे लिहा.
जर हे पान अगोदरच अस्तित्वात असेल, तर तुम्हांला ते पान बदलण्यासाठी लागणारा अर्ज देण्यात येईल.
नाहीतर, तुम्हांला ते पान वाढविण्याचा अर्ज देण्यात येईल.",
	'sf_formstart_noform_docu' => 'बदलण्यात येणार्‍या पानाचे नाव लिहा तसेच बदलण्यासाठी वापरण्यात येणारा अर्ज निवडा.
जर हे पान अगोदरच अस्तित्वात असेल, तर तुम्हांला ते पान बदलण्यासाठी लागणारा अर्ज देण्यात येईल.
नाहीतर, तुम्हांला ते पान वाढविण्याचा अर्ज देण्यात येईल.',
	'sf_formstart_createoredit' => 'वाढवा किंवा बदला', # Fuzzy
	'formedit' => 'अर्जासहित बदला',
	'sf_formedit_createtitle' => 'वाढवा $1: $2', # Fuzzy
	'sf_formedit_badurl' => "हे पान मजकूर वाढविण्यासाठी आहे. तुम्ही एक अर्जाचे नाव व लक्ष्य पान दोन्ही URL मध्ये देणे आवश्यक आहे. URL अशी दिसेल 'Special:FormEdit?form=<अर्जाचे नाव>&target=<लक्ष्य पान>', किंवा  'Special:FormEdit/<अर्जाचे नाव>/<लक्ष्य पान>'.",
	'sf_formedit_altforms' => 'हे पान तुम्ही या ऐवजी खालीलपैकी एक अर्ज वापरून वाढवू शकता:',
	'sf_formedit_altformsonly' => 'हे पान वाढविण्यासाठी कृपया खालील पैकी एक अर्ज निवडा:',
	'sf_viewform' => 'अर्ज पहा',
	'sf_editsource' => 'स्रोत संपादित करा',
	'sf_formedit_edittitle' => 'संपादित करा $1: $2',
	'sf_formedit_formwarning' => 'इशारा: हे पान <a href="$1">अस्तित्वात आहे</a>, पण ते पान ह्या अर्जाचा वापर करीत नाही.',
	'sf_formedit_remove' => 'काढा',
	'sf_formedit_addanother' => 'दुसरे वाढवा',
	'sf_formedit_none' => 'काहीही नाही',
	'sf_formerrors_header' => 'तुमच्या अर्जामध्ये त्रुटी आहेत; खाली पहा',
	'sf_blank_error' => 'रिकामे असू शकत नाही',
	'sf_bad_url_error' => "'http' ने सुरू होणारी बरोबर URL असणे आवश्यक आहे",
	'sf_bad_email_error' => 'बरोबल इ-मेल पत्ता असणे आवश्यक आहे',
	'sf_bad_number_error' => 'योग्य संख्या असणे आवश्यक आहे',
	'sf_bad_date_error' => 'योग्य दिनांक असणे आवश्यक आहे',
	'sf_property_isproperty' => 'हा $1 प्रकारचा गुणधर्म आहे.',
	'sf_property_allowedvals' => 'या गुणधर्माच्या योग्य किंमती पुढीलप्रमाणे आहेत:', # Fuzzy
	'sf_template_docu' => "हा '$1' साचा आहे.
हा खालीलप्रमाणे वापरला पाहिजे:",
	'sf_template_docufooter' => 'पानात साचा मजकूर पाहण्यासाठी योग्य असे बदल करा.',
	'sf_form_docu' => "हा '$1' अर्ज आहे.
हा अर्ज वापरून एखादे पान वाढविण्यासाठी, खाली पानाचे शीर्षक लिहा;
जर त्या नावाचे पान अगोदरच अस्तित्वात असेल, तर तुम्हांला ते पान बदलण्यासाठीचा अर्ज पाठविला जाईल.", # Fuzzy
	'sf_form_freetextlabel' => 'मुक्त मजकुर',
	'sf_category_hasdefaultform' => 'हे वर्गीकरण फॉर्म $1 वापरते.',
	'sf_category_desc' => 'हे $1 वर्गीकरण आहे.',
	'sf_blank_namespace' => 'मुख्य',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'semanticforms-desc' => 'Borang untuk menambahkan dan menyunting data semantik',
	'createproperty' => 'Wujudkan sifat',
	'sf_createproperty_linktoform' => 'Sifat ini akan dipautkan dengan laman-laman yang menggunakan borang ini:',
	'sf_createproperty_allowedvalsinput' => 'Jika anda mahu sifat ini hanya dibenarkan mempunyai nilai-nilai tertentu, isikan senarai nilai yang dibenarkan, diikuti oleh tanda koma (jika sesuatu nilai ada tanda koma, gantinya dengan "\\,".):',
	'sf_createproperty_propname' => 'Nama sifat:',
	'sf_createproperty_proptype' => 'Jenis:',
	'templates' => 'Templat',
	'sf_createtemplate_deletefield' => 'Hapuskan',
	'forms' => 'Borang',
	'sf_createform_template' => 'Templat:',
	'sf_createform_inputtype' => 'Jenis input:',
	'sf_createform_inputtypedefault' => '(azali)',
	'sf_createform_formlabel' => 'Label borang:',
	'sf_createform_add' => 'Tambahkan',
	'sf_createcategory_defaultform' => 'Borang sediaan:',
	'sf_createclass_listofvalues' => 'Senarai nilai?',
	'sf_createclass_create' => 'Cipta',
	'formedit' => 'Sunting dengan borang',
	'sf_formedit_createtitle' => 'Cipta $1: $2',
	'sf_formedit_createtitlenotarget' => 'Cipta $1',
	'sf_formcreate' => 'Buat dengan borang',
	'sf_viewform' => 'Lihat borang',
	'sf_editsource' => 'Sunting sumber',
	'sf_formedit_saveandcontinueediting' => 'Simpan dan sambung',
	'sf_blank_namespace' => 'Utama',
	'right-viewedittab' => 'Melihat tab "Sunting" untuk laman yang boleh disunting dengan borang', # Fuzzy
	'right-editrestrictedfields' => 'Menyunting ruangan borang yang terhad',
	'right-createclass' => 'Membuat kelas semantik baru',
	'action-createclass' => 'buat kelas semantik baru',
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'sf-createform-with-name' => 'Oħloq formola: $1',
	'sf_createform_nameinput' => 'Isem tal-formola',
	'sf_createform_nameinputdesc' => '(il-konvenzjoni hi l-formola tingħata l-istess isem bħall-mudell prinċipali):',
	'sf_createform_template' => 'Mudell:',
	'sf_createform_field' => 'Qasam:',
	'sf_createform_fieldprop' => 'Dan il-qasam jiddefinixxi l-proprjetà $1, tat-tip $2.',
	'sf_createform_fieldproplist' => "Dan il-qasam jiddefinixxi lista ta' elementi li għandhom il-proprjetà $1, tat-tip $2.",
	'sf_createform_fieldpropunknowntype' => 'Dan il-qasam jiddefinixxi l-proprjetà $1, tat-tip mhux speċifikat.',
	'sf_createform_inputtype' => "Tip ta' ''input'':",
	'sf_createform_formlabel' => 'Tikketta tal-formola:',
	'sf_createform_hidden' => 'Moħbi',
	'sf_createform_removetemplate' => 'Neħħi l-mudell',
	'sf_createform_addtemplate' => 'Żid mudell:',
	'sf_createform_beforetemplate' => 'Mudell preċedenti:',
	'sf_createform_add' => 'Żid',
	'sf_createform_choosefield' => 'Agħżel qasam xi żżid',
	'createcategory' => 'Oħloq kategorija',
	'sf-createcategory-with-name' => 'Oħloq kategorija: $1',
	'sf_createcategory_name' => 'Isem tal-kategorija:',
	'sf_createcategory_makesubcategory' => "Agħmel din sottokategorija ta' kategorija oħra (opzjonali):",
	'createclass' => 'Oħloq klassi',
	'sf_createclass_allowedvalues' => 'Valuri permessi:',
	'sf_createclass_listofvalues' => "Lista ta' valuri?",
	'sf_createclass_nameinput' => 'Isem tal-formola:',
	'sf_createclass_missingvalues' => 'Mhux kull qasam neċessarji ġew mimlijin.',
	'sf_createclass_create' => 'Oħloq',
	'formstart' => 'Bidu tal-formola',
	'sf_formstart_badform' => 'Żball: L-ebda formola ma nstabet fuq il-paġna "$1".',
	'sf_formstart_badtitle' => 'Żball: "$1" huwa titlu invalidu għall-paġna.',
	'sf_formstart_createoredit' => 'Oħloq jew immodifika',
	'formedit' => 'Immodifika bil-formola',
	'sf_formedit_createtitle' => 'Oħloq $1: $2',
	'sf_formedit_createtitlenotarget' => 'Oħloq $1',
	'sf_formedit_altforms' => "Minflok tista' żżid din il-paġna ma' waħda minn dawn il-formoli:",
	'sf_formedit_altformsonly' => 'Jekk jogħġbok agħżel waħda mill-formoli segwenti biex iżżid din il-paġna:',
	'sf_viewform' => 'Ara l-formola',
	'sf_editsource' => 'Immodifika s-sors',
	'sf_formedit_edittitle' => 'Modifika $1: $2',
	'sf_formedit_formwarning' => 'Attenzjoni: Din il-paġna <a href="$1">diġà teżisti</a>, imma ma tużax din il-formola.',
	'sf_formedit_remove' => 'Neħħi',
	'sf_formedit_addanother' => 'Żid oħra',
	'sf_formedit_none' => 'L-ebda',
	'sf_formedit_saveandcontinueediting' => 'Salva u kompli',
	'sf_form_freetextlabel' => 'Test ħieles',
);

/** Erzya (эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'sf_createproperty_propname' => 'Йонксонть лемезэ:',
	'sf_createproperty_proptype' => 'Типезэ:',
	'sf_createtemplate_deletefield' => 'Нардамс',
	'sf_createform_template' => 'Лопа парцунось:',
	'sf_createform_field' => 'Паксясь:',
	'sf_createform_hidden' => 'Кекшезь',
	'sf_createform_add' => 'Поладомс',
	'createcategory' => 'Шкамс категория',
	'sf_createcategory_name' => 'Кужонть лемезэ:',
	'sf_editsource' => 'Витнемс-петнемс лисьмапрянзо',
	'sf_formedit_remove' => 'Нардык',
);

/** Mazanderani (مازِرونی)
 * @author محک
 */
$messages['mzn'] = array(
	'sf_formedit_badurl' => 'این صفحه برای افزودن ایطیلاعات هسته. شما ونه هم ایسم فورم هم ولگی که خانی بوری ره در URL دله بیارین. چیزی شبیه اینتا <br /><span dir="ltr"> \'شاء:FormEdit?form=<نام فرم>&target=<ولگی که خانی بوری>\' </span><br />یا<br /><span dir="ltr"> \'شاء:FormEdit/<ایسم فرم>/<ولگی که خانی بوری>\' </span>.',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 * @author Ricardo gs
 * @author Teòtlalili
 */
$messages['nah'] = array(
	'sf_createproperty_propname' => 'Āxcāitl tōcāitl:',
	'templates' => 'Nemachiyōtīlli',
	'createtemplate' => 'Ticchīhuāz cē nemachiyōtīlli',
	'sf_createtemplate_namelabel' => 'Nemachiyōtīlli ītōca:',
	'sf_createtemplate_deletefield' => 'Ticpolōz',
	'sf_createform_inputtypedefault' => '(ic default)',
	'sf_createform_hidden' => 'Ichtac',
	'sf_createform_atend' => 'Tlamilizpan',
	'sf_createform_add' => 'Ticcētilīz',
	'sf_createcategory_name' => 'Tlaìxmatkàtlàlilòtokâtli:',
	'sf_formstart_createoredit' => 'Titlayōcoyāz ahnozo titlapatlāz',
	'sf_formedit_createtitle' => 'Ticyōcoyāz $1: $2',
	'sf_formedit_edittitle' => 'Ticpatlāz $1: $2',
	'sf_formedit_addanother' => 'Titlacēntilīz occē',
	'sf_formedit_none' => 'Ahtlein',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author EvenT
 * @author Event
 * @author Harald Khan
 * @author Laaknor
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'semanticforms-desc' => 'Skjema for å legge til og endre semantiske data',
	'specialpages-group-sf_group' => 'Semantiske skjemaer',
	'createproperty' => 'Opprett en egenskap',
	'sf-createproperty-with-name' => 'Opprett egenskap: $1',
	'sf_createproperty_linktoform' => 'Denne egenskapen vil lenke til sider som bruker skjemaet:',
	'sf_createproperty_allowedvalsinput' => 'Om du ønsker at dette feltet kun skal kunne ha visse verdier, skriv inn listen over tillatte verdier, adskilt med komma (om en verdi inneholder komma, erstatt det med «\\,»):',
	'sf_createproperty_propname' => 'Navn på egenskap:',
	'sf_createproperty_proptype' => 'Type:',
	'templates' => 'Maler',
	'sf_templates_docu' => 'Følgende maler finnes på wikien.',
	'sf_templates_definescat' => 'definerer kategori: $1',
	'createtemplate' => 'Opprett en mal',
	'sf-createtemplate-with-name' => 'Opprett mal: $1',
	'sf_createtemplate_namelabel' => 'Malnavn:',
	'sf_createtemplate_multipleinstance' => 'Denne malen kan tas inn flere ganger på siden.',
	'sf_createtemplate_categorylabel' => 'Kategori definert av mal (valgfri):',
	'sf_createtemplate_templatefields' => 'Malfelter',
	'sf_createtemplate_fieldsdesc' => 'For at feltene i denne malen ikke lenger skal kreve feltnavn, skriv inn indeksnummeret til hvert felt (altså 1, 2, 3, osv.) som navn, i stedet for et faktisk navn.',
	'sf_createtemplate_fieldname' => 'Feltnavn:',
	'sf_createtemplate_displaylabel' => 'Vis etikett:',
	'sf_createtemplate_semanticproperty' => 'Semantisk egenskap:',
	'sf_createtemplate_fieldislist' => 'Dette feltet kan inneholde en liste over verdier adskilt med komma',
	'sf_createtemplate_aggregation' => 'Aggregering',
	'sf_createtemplate_aggregationdesc' => 'For å liste opp alle artiklene som har en viss egenskap som peker til den siden på alle sider som bruker malen, angi denne egenskapen nedenfor:',
	'sf_createtemplate_aggregationlabel' => 'Tittel for liste:',
	'sf_createtemplate_outputformat' => 'Resultatformat:',
	'sf_createtemplate_standardformat' => 'Tabell',
	'sf_createtemplate_infoboxformat' => 'Infoboks på siden',
	'sf_createtemplate_plainformat' => 'Vanlig tekst',
	'sf_createtemplate_sectionsformat' => 'Avsnitt',
	'sf_createtemplate_addfield' => 'Legg til felt',
	'sf_createtemplate_deletefield' => 'Slett',
	'sf_createtemplate_addtemplatebeforesave' => 'Du må legge til minst én mal til dette skjemaet før du kan lagre det.',
	'forms' => 'Skjemaer',
	'sf_forms_docu' => 'Følgende skjemaer finnes på wikien.',
	'sf_forminputs_mandatory' => 'Obligatorisk',
	'sf_forminputs_restricted' => 'Kun administratorer kan endre disse inndataene',
	'sf_forminputs_class' => 'HTML-"class"-attributt for disse inndata',
	'sf_forminputs_default' => 'Standardverdi for disse inndataene',
	'sf_forminputs_preload' => 'Wikiside som blir standardinnholdet for denne typen inndata',
	'sf_forminputs_property' => 'Semantisk egenskap som dette feltet svarer til',
	'sf_forminputs_size' => 'Antall tegn for dette tekstfeltet',
	'sf_forminputs_maxlength' => 'Maksimalt antall tegn for dette feltet',
	'sf_forminputs_placeholder' => 'Hjelpetekst som vises i inndatafeltet helt til brukeren klikker i det',
	'sf_forminputs_uploadable' => 'Sett en "Last opp fil"-lenke ved siden av denne typen inndata', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Standard filnavn for opplastede filer',
	'sf_forminputs_rows' => 'Antall rader for denne typen inndata',
	'sf_forminputs_cols' => 'Antall kolonner for denne typen inndata',
	'sf_forminputs_autogrow' => 'Angi at denne typen inndata kan øke i størrelse hvis teksten overskrider sine grenser',
	'sf_forminputs_valuesfromproperty' => 'En egenskap der dennes verdier i wikien burde representere verdiene til denne typen inndata',
	'sf_forminputs_valuesfromcategory' => 'En kategori der sidene burde representere denne typen inndatas verdisett',
	'sf_forminputs_valuesfromnamespace' => 'Et navnerom der sidene burde representere denne typen inndatas verdisett',
	'sf_forminputs_valuesfromconcept' => 'En begrepsside for Semantic MediaWiki med sider som burde representere verdisettet til denne typen inndata',
	'sf_forminputs_valuesfromurl' => 'En URL som inneholder strukturerte data som burde representere verdisettet for denne typen inndata',
	'sf_forminputs_values' => 'Verdisettet for denne typen inndata, kommaseparert',
	'sf_forminputs_list' => 'Marker at denne typen inndata inneholder en verdiliste',
	'sf_forminputs_delimiter' => 'Skilletegnet mellom feltverdier, hvis denne typen inndata inneholder en liste av slike',
	'sf_forminputs_remoteautocompletion' => 'Bruke ekstern autofullføring',
	'sf_forminputs_existingvaluesonly' => 'Tillat bare verdier som allerede er i listen',
	'sf_forminputs_showonselect' => 'Sideelementer som bare vises, hvis bestemte verdier er valgt (eksempel "verdi1=>div1;verdi2=>div2")',
	'sf_forminputs_listboxsize' => 'Antall rader for denne listeboksen',
	'sf_forminputs_includetimezone' => 'Ta med angivelse av tidssone',
	'sf_forminputs_topcategory' => 'Foreldrekategorien for dette kategorisettet (påkrevet)',
	'sf_forminputs_hideroot' => 'Skjul foreldrekategorien',
	'sf_forminputs_depth' => 'Antall kategorinivåer som vises initialt',
	'sf_forminputs_height' => 'Høyden for denne typen inndata, i piksler',
	'sf_forminputs_width' => 'Bredden for denne typen inndata, i piksler',
	'createform' => 'Opprett et skjema',
	'sf-createform-with-name' => 'Opprett skjema: $1',
	'sf_createform_nameinput' => 'Skjemanavn',
	'sf_createform_nameinputdesc' => '(skjemaet får normalt samme navn som sin hovedmal):',
	'sf_createform_template' => 'Mal:',
	'sf_createform_templatelabelinput' => 'Malnavn (valgfritt):',
	'sf_createform_allowmultiple' => 'Tillat flere (eller ingen) instanser av denne malen på siden som opprettes',
	'sf_createform_field' => 'Felt:',
	'sf_createform_fieldprop' => 'Dette feltet definerer egenskapen $1, av type $2.',
	'sf_createform_fieldproplist' => 'Dette feltet definerer en liste over elementer som har egenskapen $1, av type $2.',
	'sf_createform_fieldpropunknowntype' => 'Dette feltet definerer egenskapen $1, av uspesifisert type.',
	'sf_createform_inputtype' => 'Innskrivningstype:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createform_formlabel' => 'Skjemaetikett:',
	'sf_createform_hidden' => 'Skjult',
	'sf_createform_removetemplate' => 'Fjern mal',
	'sf_createform_addtemplate' => 'Legg til mal:',
	'sf_createform_beforetemplate' => 'Før mal:',
	'sf_createform_atend' => 'Ved slutten',
	'sf_createform_add' => 'Legg til',
	'sf_createform_choosefield' => 'Velg et felt å legge til',
	'createcategory' => 'Opprett en kategori',
	'sf-createcategory-with-name' => 'Opprett kategori: $1',
	'sf_createcategory_name' => 'Kategorinavn:',
	'sf_createcategory_defaultform' => 'Standardskjema:',
	'sf_createcategory_makesubcategory' => 'Gjør dette til en underkategori av en annen kategori (valgfritt):',
	'createclass' => 'Opprett en klasse',
	'sf_createclass_docu' => 'Skriv inn alle data her for å opprette egenskaper, maler, skjemaer og kategorier for en enkelt klasse. For flere alternativer, bruk sidene $1 istedet.',
	'sf_createclass_allowedvalues' => 'Lovlige verdier:',
	'sf_createclass_listofvalues' => 'Verdiliste?',
	'sf_createclass_nameinput' => 'Skjemanavn:',
	'sf_createclass_missingvalues' => 'Noen obligatoriske felt ble ikke fylt ut.',
	'sf_createclass_success' => 'Egenskaper, maler, skjemaer og kategorier vil bli opprettet.',
	'sf_createclass_create' => 'Opprett',
	'formstart' => 'Legg til side gjennom et skjema',
	'sf_formstart_badform' => 'Feil: ingen skjemaside funnet på $1',
	'sf_formstart_badtitle' => 'Feil: «$1» er en ugyldig tittel for en side.',
	'sf_formstart_docu' => 'Skriv inn navnet på siden som skal redigeres med skjemaet «$1» her. Om siden finnes allerede vil du bli tatt med til skjemaet for redigering av den siden. Hvis ikke vil du bli tatt med til skjemaet for å opprette siden.',
	'sf_formstart_noform_docu' => 'Skriv inn navnet på siden her, og velg hvilket skjema du vil bruke til å redigere den. Om siden finnes allerede, vil du bli tatt med til skjemaet for redigering av den siden. Hvis ikke vil du bli tatt med til skjemaet for å opprette siden.',
	'sf_formstart_createoredit' => 'Opprett eller rediger',
	'formedit' => 'Rediger med skjema',
	'sf_formedit_createtitle' => 'Opprett $1: $2',
	'sf_formedit_createtitlenotarget' => 'Opprett $1',
	'sf_formedit_badurl' => 'Dette er siden for å redigere med et skjema. Du må angi både et skjemanavn og en målside i URL-en;
det burde se slik ut «Special:FormEdit?form=<skjemanavn>&target=<målside>», eller slik «Special:FormEdit/<skjemanavn>/<målside>».',
	'sf_formedit_altforms' => 'Du kan i stedet opprette siden ved å bruke et av følgende skjemaer:',
	'sf_formedit_altformsonly' => 'Velg blant disse skjemaene for å opprette siden:',
	'sf_formcreate' => 'Opprett med skjema',
	'sf_viewform' => 'Se skjema',
	'sf_editsource' => 'Rediger kilde',
	'sf_formedit_edittitle' => 'Rediger $1: $2',
	'sf_formedit_morethanoneform' => "'''Advarsel:''' Mer enn ett standard skjema er definert for denne siden.",
	'sf_formedit_formwarning' => 'Advarsel: Denne siden <a href="$1">finnes allerede</a>, men bruker ikke dette skjemaet.',
	'sf_formedit_mismatchedbrackets' => 'Advarsel: Denne siden har krøll- og/eller firkantparanteser som ikke er balanserte slik at den ikke blir korrekt håndtert av skjemaet. Vennligst <a href="$1">fjern feilen i kildeteksten</a> før du går videre.',
	'sf_formedit_remove' => 'Fjern',
	'sf_formedit_addanother' => 'Legg til en til:',
	'sf_formedit_none' => 'Ingen',
	'sf_formedit_emptytitle' => 'Feil: De innlagte data resulterer i en tom sidetittel.',
	'sf_formedit_hookerror' => 'Feil: En MediaWiki-utvidelse forhindret endring av målsiden.',
	'sf_formedit_saveandcontinueediting' => 'Lagre og fortsett',
	'sf_formedit_saveandcontinue_summary' => 'Lagret ved å bruke "$1"-knappen i et skjema',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Lagre data og fortsett redigering',
	'sf_autoedit_anoneditwarning' => 'Advarsel: Du er ikke innlogget. Din IP-adresse vil logges i denne sidens redigeringshistorikk.',
	'sf_autoedit_success' => 'Vellykket endring av [[$1]] med bruk av skjema $2.',
	'sf_autoedit_fail' => 'Endring av [[$1]] mislyktes.',
	'sf_autoedit_notargetspecified' => 'Ingen målside angitt.',
	'sf_autoedit_invalidtargetspecified' => 'Angitt målside $1 er ugyldig.',
	'sf_autoedit_invalidform' => '$1 er ikke et gyldig skjema.',
	'sf_autoedit_redirectlimitexeeded' => 'Øvre grense for omdirigeringer av skjema $1 ble overskredet.',
	'sf_autoedit_invalidredirecttarget' => '$1 er et ugyldig omdirigeringsmål for skjema $2.',
	'sf_autoedit_invalidpreloadspecified' => 'Angitt side $1 for preutfylling er ugyldig.',
	'sf_autoedit_redlinkexists' => '$1 finnes allerede.',
	'sf_autoedit_noformfound' => 'Intet skjema angitt.',
	'sf_autoedit_toomanyformsfound' => 'Flere enn et skjema tilgjengelig for siden.',
	'sf_autoedit_readonly' => 'Databasen er nå låst mot endringer. Årsak: $1',
	'sf_autoedit_nosemanticform' => 'Finner ikke skjema $2 for side $1. Sjekk [[{{#special:FormEdit}}/$2/$1]] for detaljer.',
	'sf_autoedit_summary' => 'Automatisk redigert fra side $1.',
	'sf-autoedit-wait' => 'Vent...',
	'runquery' => 'Utfør spørring',
	'sf_runquery_badurl' => "Du må angi et skjemanavn i nettadressen;
nettadressen burde være på formen 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'Utfør spørring: $1',
	'sf_runquery_additionalquery' => 'Tilleggsspørring',
	'sf_formerrors_header' => 'Det var feil i skjemaet ditt; se nedenfor',
	'sf_blank_error' => 'kan ikke være blank',
	'sf_bad_url_error' => "må ha korrekt URL-format, inkludert 'http'",
	'sf_bad_email_error' => 'må ha gyldig format på e-postadressen',
	'sf_bad_number_error' => 'må være et gyldig tall',
	'sf_bad_date_error' => 'må være en gyldig dato',
	'uploadwindow' => 'Opplastingsvindu',
	'sf_deletionlog' => 'Slettingslogg',
	'sf-preview-header' => 'Forhåndsvisning av skjemaet',
	'sf-preview-note' => 'Slik vil skjemaet se ut i bruk:',
	'sf-pageschemas-pagenameformula' => 'Sidenavnsformel:',
	'sf-pageschemas-createtitle' => 'Skjematittel for nye sider:',
	'sf-pageschemas-edittitle' => 'Skjematittel for eksisterende sider:',
	'sf-pageschemas-inputtype' => 'Inndatatype (bruk blanktegn for å indikere standardverdi):',
	'sf_property_isproperty' => 'Dette er en egenskap av type $1.',
	'sf_property_linkstoform' => 'Det lenker til sider som bruker skjemaet $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Den tillatte verdien|De tillatte verdiene}} for denne egenskapen er:',
	'sf_template_docu' => 'Dette er malen «$1». Den burde kalles opp med følgende format:',
	'sf_template_docufooter' => 'Rediger siden for å se malteksten.',
	'sf_form_docu' => 'Dette er skjemaet «$1».
For å opprette en side med dette skjemaet, skriv inn sidenavnet under;
om en side med det navnet finnes allerede vil du bli sendt til et skjema for redigering av den siden.',
	'sf_form_freetextlabel' => 'Fritekst',
	'sf_category_hasdefaultform' => 'Denne kategorien bruker skjemaet $1.',
	'sf_category_desc' => 'Dette er kategorien $1',
	'sf_blank_namespace' => 'Hoved',
	'right-viewedittab' => 'Vis «Rediger»-fanen for sider som kan redigeres via skjema', # Fuzzy
	'right-editrestrictedfields' => 'Rediger begrensede skjemafelt',
	'right-createclass' => 'Opprett nye semantiske klasser',
	'action-createclass' => 'opprett nye semantiske klasser',
	'action-editrestrictedfields' => 'rediger begrensede skjemafelter',
	'action-viewedittab' => 'vis «Rediger»-fanen for sider som kan redigeres via skjema', # Fuzzy
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'sf_createproperty_propname' => 'Naam:', # Fuzzy
	'sf_createcategory_name' => 'Naam:', # Fuzzy
);

/** Nedersaksies (Nedersaksies)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'sf_createform_add' => 'Derbie doon',
);

/** Niuean (ko e vagahau Niuē)
 * @author Jose77
 */
$messages['niu'] = array(
	'sf_createtemplate_deletefield' => 'Tamate',
);

/** Dutch (Nederlands)
 * @author McDutchie
 * @author Rcdeboer
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'semanticforms-desc' => 'Formulieren voor het toevoegen en bewerken van semantische gegevens',
	'specialpages-group-sf_group' => 'Semantische formulieren',
	'createproperty' => 'Eigenschap aanmaken',
	'sf-createproperty-with-name' => 'Eigenschap aanmaken: $1',
	'sf_createproperty_linktoform' => "Deze eigenschap verwijst naar pagina's die het volgende formulier gebruiken:",
	'sf_createproperty_allowedvalsinput' => 'Als u wilt dat deze eigenschap een beperkt aantal waarden mag hebben, geef dan een lijst met toegelaten waarden in, door komma\'s gescheiden. Als een waarde een komma bevat, vervang deze dan door "\\,":',
	'sf_createproperty_propname' => 'Naam eigenschap:',
	'sf_createproperty_proptype' => 'Type:',
	'templates' => 'Sjablonen',
	'sf_templates_docu' => 'De onderstaande sjablonen bestaan in de wiki.',
	'sf_templates_definescat' => 'bepaalt categorie: $1',
	'createtemplate' => 'Sjabloon aanmaken',
	'sf-createtemplate-with-name' => 'Sjabloon aanmaken: $1',
	'sf_createtemplate_namelabel' => 'Sjabloonnaam:',
	'sf_createtemplate_multipleinstance' => 'Deze sjabloon kan meerdere keren worden ingevoegd op de pagina.',
	'sf_createtemplate_categorylabel' => 'Categorie bepaald door sjabloon (optioneel):',
	'sf_createtemplate_templatefields' => 'Sjabloonvelden',
	'sf_createtemplate_fieldsdesc' => 'Om de velden van een sjabloon geen verplichte veldnamen te laten hebben, kunt u de index van dat veld (bijvoorbeeld 1, 2, 3, enzovoort) als naam opgeven in plaats van de eigenlijke naam.',
	'sf_createtemplate_fieldname' => 'Veldnaam:',
	'sf_createtemplate_displaylabel' => 'Beschrijving:',
	'sf_createtemplate_semanticproperty' => 'Semantische eigenschap:',
	'sf_createtemplate_fieldislist' => "Dit veld kan een lijst van waardes bevatten, gescheiden door komma's",
	'sf_createtemplate_aggregation' => 'Aggregatie',
	'sf_createtemplate_aggregationdesc' => "Om op iedere pagina die van deze sjabloon gebruik maakt een lijst weer te geven van alle pagina's met een naar die pagina verwijzende eigenschap, geeft u de betreffende eigenschap hieronder aan:",
	'sf_createtemplate_aggregationlabel' => 'Naam voor lijst:',
	'sf_createtemplate_outputformat' => 'Uitvoeropmaak:',
	'sf_createtemplate_standardformat' => 'Tabel',
	'sf_createtemplate_infoboxformat' => 'Infobox zijkant',
	'sf_createtemplate_plainformat' => 'Tekst zonder opmaak',
	'sf_createtemplate_sectionsformat' => 'Kopjes',
	'sf_createtemplate_addfield' => 'Veld toevoegen',
	'sf_createtemplate_deletefield' => 'Verwijderen',
	'sf_createtemplate_addtemplatebeforesave' => 'U moet ten minste één sjabloon toevoegen aan dit formulier voordat u het kunt opslaan.',
	'forms' => 'Formulieren',
	'sf_forms_docu' => 'De onderstaande formulieren bestaan in de wiki.',
	'sf_forminputs_mandatory' => 'Er moet een waarde ingevoerd worden voor deze invoer',
	'sf_forminputs_restricted' => 'Alleen beheerders kunnen deze invoer bewerken',
	'sf_forminputs_class' => 'Het HTML-"klasse"-attribuut voor deze invoer',
	'sf_forminputs_default' => 'De standaardwaarde voor deze invoer',
	'sf_forminputs_preload' => 'Eeen wikipagina waarvan de inhoud de standaardwaarde wordt',
	'sf_forminputs_property' => 'Een semantische eigenschap waar dit veld mee overeenkomt',
	'sf_forminputs_size' => 'De grootte van dit tekstveld, in tekens',
	'sf_forminputs_maxlength' => 'De maximale lengte van de tekst in dit veld',
	'sf_forminputs_placeholder' => 'Hulptekst die wordt weergegeven in het invoerveld totdat een gebruiker er op klikt',
	'sf_forminputs_uploadable' => 'Een koppeling "{{int:upload}}" toevoegen naast deze invoer',
	'sf_forminputs_defaultfilename' => 'De standaard bestandsnaam voor toegevoegde bestanden',
	'sf_forminputs_rows' => 'Het aantal rijen voor deze invoer',
	'sf_forminputs_cols' => 'Het aantal kolommen voor deze invoer',
	'sf_forminputs_autogrow' => 'Dit veld instellen om automatisch in grootte toe te nemen als de tekst buiten de randen dreigt te lopen',
	'sf_forminputs_valuesfromproperty' => 'Een eigenschap waarvan de waarden in de wiki de invoerwaarden voor dit veld zijn',
	'sf_forminputs_valuesfromcategory' => "Een categorie waarvan de pagina's de invoer voor dit veld zijn",
	'sf_forminputs_valuesfromnamespace' => "Een naamruimte waarvan de pagina's de invoer voor dit veld zijn",
	'sf_forminputs_valuesfromconcept' => "Een Semantic MediaWikiconceptpagina waarvan de pagina's de invoer voor dit veld zijn",
	'sf_forminputs_valuesfromurl' => 'Een URL die de gestructureerde gegevens bevat die de invoer voor dit veld zijn',
	'sf_forminputs_values' => 'De kommegescheiden lijst met waarden voor dit veld',
	'sf_forminputs_list' => 'Deze invoer bevat een lijst met waarden',
	'sf_forminputs_delimiter' => 'Het scheidingsteken tussen veldwaarden als dit veld een lijst kan bevatten',
	'sf_forminputs_remoteautocompletion' => 'Automatisch invullen via externe server gebruiken',
	'sf_forminputs_existingvaluesonly' => 'Alleen waarden die al in de lijst aanwezig zijn toestaan',
	'sf_forminputs_showonselect' => 'Paginaelementen die alleen weergegeven moeten worden als bepaalde waarden zijn geselecteerd (voorbeeld: "waarde1=>div1;waarde2=>div2")',
	'sf_forminputs_listboxsize' => 'De hoogte van dit lijstveld, in rijen',
	'sf_forminputs_includetimezone' => 'Invoer voor de tijdzone opnemen',
	'sf_forminputs_topcategory' => 'De bovenliggende categorie van deze verzameling categorieën (vereist)',
	'sf_forminputs_hideroot' => 'De bovenliggende categorie verbergen',
	'sf_forminputs_depth' => 'Het aantal categorieniveaus dat aanvankelijk weergegeven moet worden',
	'sf_forminputs_height' => 'De hoogte van deze invoer, in pixels',
	'sf_forminputs_width' => 'De breedte van deze invoer, in pixels',
	'createform' => 'Formulier aanmaken',
	'sf-createform-with-name' => 'Formulier aanmaken: $1',
	'sf_createform_nameinput' => 'Formuliernaam',
	'sf_createform_nameinputdesc' => '(het formulier krijgt meestal de naam van de hoofdsjabloon):',
	'sf_createform_template' => 'Sjabloon:',
	'sf_createform_templatelabelinput' => 'Sjabloonlabel (optioneel):',
	'sf_createform_allowmultiple' => 'Meerdere (of geen) instanties van deze sjabloon toestaan op de gemaakte pagina',
	'sf_createform_field' => 'Veld:',
	'sf_createform_fieldprop' => 'Dit veld bepaalt de eigenschap $1, van type $2.',
	'sf_createform_fieldproplist' => 'Dit veld bepaalt een lijst elementen die de eigenschap $1 hebben, van type $2.',
	'sf_createform_fieldpropunknowntype' => 'Dit veld bepaalt de eigenschap $1, van een onbepaald type.',
	'sf_createform_inputtype' => 'Invoertype:',
	'sf_createform_inputtypedefault' => '(standaard)',
	'sf_createform_formlabel' => 'Formulierlabel:',
	'sf_createform_hidden' => 'Verborgen',
	'sf_createform_removetemplate' => 'Sjabloon verwijderen',
	'sf_createform_addtemplate' => 'Sjabloon toevoegen:',
	'sf_createform_beforetemplate' => 'Voor sjabloon:',
	'sf_createform_atend' => 'Onderaan',
	'sf_createform_add' => 'Toevoegen',
	'sf_createform_choosefield' => 'Kies een veld om toe te voegen',
	'createcategory' => 'Categorie aanmaken',
	'sf-createcategory-with-name' => 'Categorie aanmaken: $1',
	'sf_createcategory_name' => 'Categorienaam:',
	'sf_createcategory_defaultform' => 'Standaard formulier:',
	'sf_createcategory_makesubcategory' => 'Deze categorie een ondercategorie van een andere categorie maken (optioneel):',
	'createclass' => 'Klasse aanmaken',
	'sf_createclass_docu' => "Voer hier alle gegevens in om de eigenschappen, de sjabloon, het formulier en de categorie voor één enkele klasse aan te maken.
Gebruik de pagina's $1 voor meer mogelijkheden.",
	'sf_createclass_allowedvalues' => 'Toegestane waarden:',
	'sf_createclass_listofvalues' => 'Lijst met waarden:',
	'sf_createclass_nameinput' => 'Formuliernaam:',
	'sf_createclass_missingvalues' => 'Niet alle verplichte velden zijn ingevuld.',
	'sf_createclass_success' => 'De eigenschappen, de sjabloon, het formulier en de categorie worden aangemaakt.',
	'sf_createclass_create' => 'Aanmaken',
	'formstart' => 'Pagina toevoegen met formulier',
	'sf_formstart_badform' => 'Fout: er is geen formulierpagina aangetroffen op "$1".',
	'sf_formstart_badtitle' => 'Fout: "$1" is een ongeldige paginanaam.',
	'sf_formstart_docu' => 'Voer hier de naam van de pagina in die bewerkt wordt met het formulier "$1".
Als deze pagina al bestaat, wordt u doorgestuurd naar het formulier om die pagina te bewerken.
Anders wordt u doorgestuurd naar het formulier om de pagina toe te voegen.',
	'sf_formstart_noform_docu' => 'Voer hier de naam van de pagina in en selecteer het formulier waarmee die bewerkt wordt.
Als deze pagina al bestaat, wordt u doorgestuurd naar het formulier om die pagina te bewerken.
Anders wordt u doorgestuurd naar het formulier om de pagina toe te voegen.',
	'sf_formstart_createoredit' => 'Aanmaken of bewerken',
	'formedit' => 'Bewerken met formulier',
	'sf_formedit_createtitle' => '$1 aanmaken: $2',
	'sf_formedit_createtitlenotarget' => '$1 aanmaken',
	'sf_formedit_badurl' => 'Op deze pagina kunt u bewerkingen uitvoeren met behulp van een formulier. Geef zowel een formuliernaam als een doelpagina op in de URL. Het hoort eruit te zien als "Special:FormEdit?form=<formuliernaam>&target=<doelpagina>" of  "Special:FormEdit/<formuliernaam>/<doelpagina>".',
	'sf_formedit_altforms' => 'U kunt in de plaats deze pagina toevoegen met een van de volgende formulieren:',
	'sf_formedit_altformsonly' => 'Selecteer een van de volgende formulieren om deze pagina toe te voegen:',
	'sf_formcreate' => 'Via formulier aanmaken',
	'sf_viewform' => 'Formulier bekijken',
	'sf_editsource' => 'Bron bewerken',
	'sf_formedit_edittitle' => '$1 bewerken: $2',
	'sf_formedit_morethanoneform' => "'''Waarschuwing:''' er is meer dan één standaard formulier ingesteld voor deze pagina.",
	'sf_formedit_formwarning' => 'Waarschuwing: deze pagina <a href="$1">bestaat al</a>, maar die gebruikt dit formulier niet.',
	'sf_formedit_mismatchedbrackets' => 'Waarschuwing: Deze pagina bevat accolades of blokhaken die niet worden gesloten, dus de pagina wordt niet juist afgehandeld door het formulier. <a href="$1">Corrigeer de fout</a> voordat u doorgaat.',
	'sf_formedit_remove' => 'Instantie verwijderen',
	'sf_formedit_addanotherabove' => 'Nog een instantie toevoegen boven deze',
	'sf_formedit_addanother' => 'Volgende toevoegen',
	'sf_formedit_none' => 'Geen',
	'sf_formedit_emptytitle' => 'Fout: De toegevoegde gegevens leveren een lege paginanaam op.',
	'sf_formedit_hookerror' => 'Fout: een MediaWiki-uitbreiding voorkomt het wijzigen van de doelpagina.',
	'sf_formedit_saveandcontinueediting' => 'Opslaan en doorgaan',
	'sf_formedit_saveandcontinue_summary' => 'Opgeslagen met de knop "$1" in het formulier',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Gegevens opslaan en doorgaan met bewerken',
	'sf_autoedit_anoneditwarning' => 'Waarschuwing: u bent niet aangemeld. Uw IP-adres wordt opgenomen in de bewerkingsgeschiedenis van deze pagina.',
	'sf_autoedit_success' => '[[$1]] is gewijzigd via het formulier $2.',
	'sf_autoedit_fail' => 'Het wijzigen van [[$1]] is mislukt.',
	'sf_autoedit_notargetspecified' => 'Geen doelpagina opgegeven.',
	'sf_autoedit_invalidtargetspecified' => 'De opgegeven doelpagina $1 is ongeldig.',
	'sf_autoedit_invalidform' => '$1 is geen geldig formulier.',
	'sf_autoedit_redirectlimitexeeded' => 'De drempelwaarde voor doorverwijzigen voor het formulier $1 is bereikt.',
	'sf_autoedit_invalidredirecttarget' => '$1 is een ongeldig doel voor doorverwijzing voor het formulier $2.',
	'sf_autoedit_invalidpreloadspecified' => 'De opgegevens vooraf te laden pagina $1 is ongeldig.',
	'sf_autoedit_redlinkexists' => '$1 bestaat al.',
	'sf_autoedit_noformfound' => 'Geen formulier opgegeven.',
	'sf_autoedit_toomanyformsfound' => 'Er is meer dan één formulier beschikbaar voor de pagina.',
	'sf_autoedit_readonly' => 'De database is momenteel afgesloten voor wijzigingen. Reden: $1',
	'sf_autoedit_nosemanticform' => 'Het formulier $2 voor pagina $1 kon niet geladen worden. Zie [[{{#special:FormEdit}}/$2/$1]] voor details.',
	'sf_autoedit_summary' => 'Automatisch bewerkt vanaf pagina $1.',
	'sf-autoedit-wait' => 'Een ogenblik geduld alstublieft...',
	'runquery' => 'Zoekopdracht uitvoeren',
	'sf_runquery_badurl' => 'U moet een formuliernaam aangeven in de URL.
De URL moet er als volgt uitzien: "Special:RunQuery/<formuliernaam>".',
	'sf_runquery_title' => 'Zoekopdracht: $1',
	'sf_runquery_additionalquery' => 'Additionele zoekopdracht',
	'sf_formerrors_header' => 'Er zaten fouten in uw formulierinvoer. Details staan hieronder.',
	'sf_blank_error' => 'mag niet leeg blijven',
	'sf_bad_url_error' => 'moet de juiste URL hebben, beginnend met "http"',
	'sf_bad_email_error' => 'moet een geldig e-mailadres zijn',
	'sf_bad_number_error' => 'moet een geldig nummer zijn',
	'sf_bad_date_error' => 'moet een geldige datum zijn',
	'uploadwindow' => 'Uploadscherm',
	'sf_deletionlog' => 'Verwijderlogboek',
	'sf-preview-header' => 'Voorvertoning van formulier',
	'sf-preview-note' => 'Zo ziet het formulier eruit wanneer het in gebruik is:',
	'sf-pageschemas-pagenameformula' => 'Paginanaamformule:',
	'sf-pageschemas-createtitle' => "Naam voor het formulier voor nieuwe pagina's:",
	'sf-pageschemas-edittitle' => "Naam voor het formulier voor bestaande pagina's:",
	'sf-pageschemas-inputtype' => 'Invoertype (laat leeg voor standaard instelling):',
	'sf_property_isproperty' => 'Dit is een eigenschap van type $1.',
	'sf_property_linkstoform' => "Deze verwijst naar pagina's die gebruikmaken van het formulier $1.",
	'sf_property_allowedvals' => 'De toegelaten {{PLURAL:$1|waarde voor deze eigenschap is|waarden voor deze eigenschap zijn}}:',
	'sf_template_docu' => 'Dit is de sjabloon "$1".
Gebruik het op de volgende wijze:',
	'sf_template_docufooter' => 'Bewerk de pagina om de sjabloontekst te bekijken.',
	'sf_form_docu' => 'Dit is het formulier "$1".
Om een pagina aan te maken via dit formulier typt u de paginanaam hieronder in;
als een pagina met die naam al bestaat, krijgt u het bewerkingsscherm te zien en kunt u die pagina via een formulier bewerken.',
	'sf_form_freetextlabel' => 'Vrije tekst',
	'sf_category_hasdefaultform' => 'Deze categorie gebruikt het formulier $1.',
	'sf_category_desc' => 'Dit is de categorie $1.',
	'sf_blank_namespace' => 'Hoofdnaamruimte',
	'right-viewedittab' => 'Tabblad "{{int:edit}}" zien op pagina\'s die via een formulier bewerkt kunnen worden',
	'right-editrestrictedfields' => 'Beperkte formuliervelden bewerken',
	'right-createclass' => 'Nieuwe semantische klassen aanmaken',
	'action-createclass' => 'nieuwe semantische klassen aan te maken',
	'action-editrestrictedfields' => 'beperkte formuliervelden te bewerken',
	'action-viewedittab' => 'het tabblad "{{int:edit}}" te zien voor pagina\'s die via een formulier te bewerken zijn',
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Gunnernett
 * @author Harald Khan
 * @author Jon Harald Søby
 * @author Nghtwlkr
 * @author Njardarlogar
 */
$messages['nn'] = array(
	'semanticforms-desc' => 'Skjema for å leggja til og endra semantiske data',
	'specialpages-group-sf_group' => 'Semantiske skjema',
	'createproperty' => 'Opprett ein eigenskap',
	'sf_createproperty_linktoform' => 'Denne eigenskapen vil lenke til sider som nyttar skjemaet:',
	'sf_createproperty_allowedvalsinput' => 'Om du ønskjer at denne eigenskapen berre skal kunna ha visse verdiar, skriv inn lista over tillatne verdiar med verdiane skilde med komma (om ein verdi inneheld eit komma, erstatt det med «\\,»):',
	'sf_createproperty_propname' => 'Namn på eigenskap:',
	'sf_createproperty_proptype' => 'Type:',
	'templates' => 'Malar',
	'sf_templates_docu' => 'Følgjande malar finst på wikien.',
	'sf_templates_definescat' => 'definerer kategori: $1',
	'createtemplate' => 'Opprett ein mal',
	'sf_createtemplate_namelabel' => 'Malnamn:',
	'sf_createtemplate_categorylabel' => 'Kategori definert av mal (valfri):',
	'sf_createtemplate_templatefields' => 'Malfelt',
	'sf_createtemplate_fieldsdesc' => 'For at felta i malen ikkje lenger skal krevja feltnamn, skriv inn indeksnummeret til kvart felt (til dømes 1, 2, 3, osb.) som namn, i staden for eit faktisk namn:',
	'sf_createtemplate_fieldname' => 'Feltnamn:',
	'sf_createtemplate_displaylabel' => 'Vis merke:',
	'sf_createtemplate_semanticproperty' => 'Semantisk eigenskap:',
	'sf_createtemplate_fieldislist' => 'Dette feltet kan innehalda ei lista over verdiar skilde med komma',
	'sf_createtemplate_aggregation' => 'Aggregering',
	'sf_createtemplate_aggregationdesc' => 'For på kvar ei sida som nyttar denne malen, å lista opp alle artiklane med ein viss eigenskap som lenkjar til sida, oppgje eigenskapen nedanfor:', # Fuzzy
	'sf_createtemplate_aggregationlabel' => 'Listetittel:',
	'sf_createtemplate_outputformat' => 'Resultatformat:',
	'sf_createtemplate_standardformat' => 'Standard', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Infoboks på høgre sida:', # Fuzzy
	'sf_createtemplate_addfield' => 'Legg til felt',
	'sf_createtemplate_deletefield' => 'Slett',
	'sf_createtemplate_addtemplatebeforesave' => 'Du må leggja til minst ein mal til skjemaet før du kan lagra det.',
	'forms' => 'Skjema',
	'sf_forms_docu' => 'Følgjande skjema finst på wikien.',
	'sf_forminputs_mandatory' => 'Obligatorisk',
	'sf_forminputs_restricted' => 'Avgrensa (berre administratorar kan endra det)', # Fuzzy
	'createform' => 'Opprett eit skjema',
	'sf_createform_nameinput' => 'Skjemanamn',
	'sf_createform_template' => 'Mal:',
	'sf_createform_templatelabelinput' => 'Malmerke (valfritt):',
	'sf_createform_allowmultiple' => 'Tillat fleire (eller ingen) instansar av denne malen på den oppretta sida',
	'sf_createform_field' => 'Felt:',
	'sf_createform_fieldprop' => 'Dette feltet definerer eigenskapen $1, av type $2.',
	'sf_createform_fieldproplist' => 'Dette feltet definerer ei lista over element som har eigenskapen $1, av type $2.',
	'sf_createform_fieldpropunknowntype' => 'Dette feltet definerer eigenskapen $1, av uspesifisert type.',
	'sf_createform_inputtype' => 'Innteksttype:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createform_formlabel' => 'Skjemamerke:',
	'sf_createform_hidden' => 'Løynd',
	'sf_createform_removetemplate' => 'Fjern mal',
	'sf_createform_addtemplate' => 'Legg til mal:',
	'sf_createform_beforetemplate' => 'Før mal:',
	'sf_createform_atend' => 'Ved slutten',
	'sf_createform_add' => 'Legg til',
	'sf_createform_choosefield' => 'Vel eit felt til å leggja til',
	'createcategory' => 'Opprett ein kategori',
	'sf_createcategory_name' => 'Kategorinamn:',
	'sf_createcategory_defaultform' => 'Standardskjema:',
	'sf_createcategory_makesubcategory' => 'Gjer dette til ein underkategori av ein annan kategori (valfritt):',
	'formstart' => 'Legg til ei sida gjennom eit skjema',
	'sf_formstart_badform' => 'Feil: fann ikkje noka skjemasida på $1',
	'sf_formstart_docu' => 'Skriv inn namnet på sida som skal bli endra med skjemaet «$1» her.
Om sida finst frå før, vil du bli teken med til skjemaet for endring av ho.
Viss ikkje vil du bli teken med til skjemaet for å oppretta sida.',
	'sf_formstart_noform_docu' => 'Skriv inn namnet på sida her, og vel kva skjema du vil nytta til å endra ho. Om sida finst frå før, vil du bli teken med til skjemaet for endring av ho. Viss ikkje vil du bli teken med til skjemaet for å oppretta sida.',
	'sf_formstart_createoredit' => 'Opprett eller endr',
	'formedit' => 'Endra med skjema',
	'sf_formedit_createtitle' => 'Opprett $1: $2',
	'sf_formedit_badurl' => 'Dette er sida for å leggja til data. Du må oppgje både eit skjemanamn og ei målsida i adressa; det burde sjå slik ut: «Special:FormEdit?form=<skjemanamn>&target=<målsida>» eller slik ut: «Special:FormEdit/<skjemanamn>/<målsida>».',
	'sf_formedit_altforms' => 'Du kan i staden oppretta sida ved å nytta eitt av dei følgande skjemaa:',
	'sf_formedit_altformsonly' => 'Vel mellom desse skjemaa for å oppretta sida:',
	'sf_formcreate' => 'Opprett med skjema',
	'sf_viewform' => 'Sjå skjema',
	'sf_editsource' => 'Endra kjelda',
	'sf_formedit_edittitle' => 'Endra $1: $2',
	'sf_formedit_formwarning' => 'Åtvaring: Sida <a href="$1">finst frå før</a>, men nyttar ikkje dette skjemaet.',
	'sf_formedit_remove' => 'Fjern',
	'sf_formedit_addanother' => 'Legg til enno ein',
	'sf_formedit_none' => 'Ingen',
	'sf_formerrors_header' => 'Det var feil i skjemaet ditt; sjå nedanfor',
	'sf_blank_error' => 'kan ikkje vera tom',
	'sf_bad_url_error' => "må ha korrekt adresseformat, inkludert 'http'",
	'sf_bad_email_error' => 'må ha gyldig format på e-postadressa',
	'sf_bad_number_error' => 'må vera eit gyldig tal',
	'sf_bad_date_error' => 'må vera ein gyldig dato',
	'uploadwindow' => 'Opplastingsvindauga',
	'sf_property_isproperty' => 'Dette er ein eigenskap av typen $1.',
	'sf_property_linkstoform' => 'Det lenker til sida som nyttar skjemaet $1.',
	'sf_property_allowedvals' => 'Dei tillatne verdiane for denne eigenskapen er:', # Fuzzy
	'sf_template_docu' => 'Dette er malen «$1».
Han burde bli kalla opp med følgjande format:',
	'sf_template_docufooter' => 'Endra sida for å sjå malteksten.',
	'sf_form_docu' => 'Dette er skjemaet «$1».
Skriv inn eit sidenamn nedanfor for å oppretta ei sida med dette skjemaet. Om ei sida med dette namnet finst frå før, vil du bli sendt til eit skjema for endring av ho.',
	'sf_form_freetextlabel' => 'Fritekst',
	'sf_category_hasdefaultform' => 'Denne kategorien nyttar skjemaet «$1».',
	'sf_category_desc' => 'Dett er kategorien $1.',
	'sf_blank_namespace' => 'Hovud',
);

/** Northern Sotho (Sesotho sa Leboa)
 * @author Mohau
 */
$messages['nso'] = array(
	'sf_createproperty_propname' => 'Leina:', # Fuzzy
	'sf_createproperty_proptype' => 'Mohuta:',
	'sf_createtemplate_deletefield' => 'Phumula',
	'sf_createform_add' => 'Lokela',
	'sf_createcategory_name' => 'Leina la sehlopha:',
	'sf_formedit_createtitle' => 'Hloma $1: $2',
	'sf_formedit_edittitle' => 'Fetola $1: $2',
);

/** Occitan (occitan)
 * @author Cedric31
 * @author McDutchie
 */
$messages['oc'] = array(
	'semanticforms-desc' => 'Formularis per apondre e modificar de donadas semanticas',
	'specialpages-group-sf_group' => 'Semantic Forms',
	'createproperty' => 'Definir una proprietat',
	'sf_createproperty_linktoform' => "Aquesta proprietat ligarà cap a las paginas qu'utilizan lo formulari :",
	'sf_createproperty_allowedvalsinput' => "Se decidètz qu'aqueste camp accèpta pas que d'unas valors, picatz la lista de las valors permesas, separadas per de virgulas. (Se una valor conten una virgula, remplaçat-la per « \\, ») :",
	'sf_createproperty_propname' => 'Nom de la proprietat :',
	'sf_createproperty_proptype' => 'Tipe :',
	'templates' => 'Modèls',
	'sf_templates_docu' => 'Los modèls seguents existisson dins lo wiki.',
	'sf_templates_definescat' => 'definís la categoria : $1',
	'createtemplate' => 'Crear un modèl',
	'sf_createtemplate_namelabel' => 'Nom de modèl :',
	'sf_createtemplate_categorylabel' => 'Categoria definida per aqueste modèl (facultatiu) :',
	'sf_createtemplate_templatefields' => 'Camps de modèl',
	'sf_createtemplate_fieldsdesc' => "Per un modèl qu'utiliza pas cap de nom pels camps, entratz simplament son indèx (exemples : 1, 2, 3, etc.) pel nom, al luòc del nom actual.",
	'sf_createtemplate_fieldname' => 'Nom del camp :',
	'sf_createtemplate_displaylabel' => "Etiqueta per l'afichatge :",
	'sf_createtemplate_semanticproperty' => 'Proprietat de la semantica :',
	'sf_createtemplate_fieldislist' => 'Aqueste camp pòt conténer una lista de valors separadas per de virgulas.',
	'sf_createtemplate_aggregation' => 'Agregacion',
	'sf_createtemplate_aggregationdesc' => "Per listar, sus cada pagina qu'utilizan aqueste modèl, totas las qu'an una proprietat que punta cap a aquesta pagina, indicatz la proprietat adeqüata çaijós :",
	'sf_createtemplate_aggregationlabel' => 'Títol per la lista :',
	'sf_createtemplate_outputformat' => 'Format de sortida :',
	'sf_createtemplate_standardformat' => 'Estandard', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Infobox de drecha', # Fuzzy
	'sf_createtemplate_addfield' => 'Apondre un camp',
	'sf_createtemplate_deletefield' => 'Escafa',
	'sf_createtemplate_addtemplatebeforesave' => 'Vos cal apondre almens un modèl a aqueste formulari abans de lo poder salvar.',
	'forms' => 'Formularis',
	'sf_forms_docu' => 'Los formularis seguents existisson dins lo wiki.',
	'sf_forminputs_mandatory' => 'Obligatòri',
	'sf_forminputs_restricted' => 'Restrench', # Fuzzy
	'createform' => 'Crear un formulari',
	'sf_createform_nameinput' => 'Nom de formulari',
	'sf_createform_nameinputdesc' => '(la convencion es de nomenar lo formulari aprèp lo modèl principal qu’emplena) :', # Fuzzy
	'sf_createform_template' => 'Modèl :',
	'sf_createform_templatelabelinput' => 'Etiqueta de modèl (facultatiu) :',
	'sf_createform_allowmultiple' => "Permetre mantuna (o zèro) instàncias d'aqueste modèl dins la pagina creada",
	'sf_createform_field' => 'Camp :',
	'sf_createform_fieldprop' => 'Aqueste camp definís la proprietat $1, del tipe $2.',
	'sf_createform_fieldproplist' => "Aqueste camp definís una lista dels elements qu'an la proprietat $1, del tipe $2.",
	'sf_createform_fieldpropunknowntype' => "Aqueste camp definís la proprietat $1, d'un tipe non indicat.",
	'sf_createform_inputtype' => "Tipe d'entrada :",
	'sf_createform_inputtypedefault' => '(per defaut)',
	'sf_createform_formlabel' => 'Etiqueta dins lo formulari:',
	'sf_createform_hidden' => 'Amagat',
	'sf_createform_removetemplate' => 'Levar aqueste modèl',
	'sf_createform_addtemplate' => 'Apondre un modèl :',
	'sf_createform_beforetemplate' => 'Abans lo modèl :',
	'sf_createform_atend' => 'A la fin',
	'sf_createform_add' => 'Apondre',
	'sf_createform_choosefield' => "Causissètz un camp d'ajustar",
	'createcategory' => 'Crear una categoria',
	'sf_createcategory_name' => 'Nom de la categoria :',
	'sf_createcategory_defaultform' => 'Formulari per defaut :',
	'sf_createcategory_makesubcategory' => "Crèa una soscategoria d'una autra categoria (facultatiu) :",
	'createclass' => 'Crear una classa',
	'sf_createclass_docu' => 'Especificatz aicí las donadas que servisson per crear las proprietats, modèl, formulari e categoria d’una classa. Per mai d’opcions, utilizatz puslèu las paginas $1.',
	'sf_createclass_allowedvalues' => 'Valors autorizadas', # Fuzzy
	'sf_createclass_listofvalues' => 'Lista de valors', # Fuzzy
	'sf_createclass_missingvalues' => 'Los camps obligatòris son pas estats emplenats totes.',
	'sf_createclass_success' => 'Las proprietats, modèl, formulari e categoria seràn creats.',
	'formstart' => 'Apondre una pagina amb un formulari',
	'sf_formstart_badform' => 'Error : cap de pagina de formulari es pas estada trobada sus $1.',
	'sf_formstart_badtitle' => 'Error : « $1 » es un títol de pagina invalid.',
	'sf_formstart_docu' => "Picatz aicí lo nom de la pagina destinada a èsser editada amb lo formulari « $1 ». Se aquesta pagina existís ja, seretz dirigit cap al formulari per l'editar. Dins lo cas contrari, seretz redirigit cap a lo que permet de l'apondre.",
	'sf_formstart_noform_docu' => "Picatz aicí lo nom de la pagina puèi seleccionatz lo formulari amb lo qual serà editada. S'aquesta pagina existís ja, seretz dirigit cap al formulari per l'editar. Dins lo cas contrari, seretz redirigit cap a lo que permet de l'apondre.",
	'sf_formstart_createoredit' => 'Modificar o apondre de donadas', # Fuzzy
	'formedit' => 'Modificar amb un formulari',
	'sf_formedit_createtitle' => 'Apondre $1 : $2', # Fuzzy
	'sf_formedit_badurl' => "Aquò es la pagina per apondre las donadas. Cal indicar un nom de formulari e una pagina cibla dins l'URL; l'URL se deu semblar a « Special:FormEdit?form=<nom de formulari>&target=<nom de pagina cibla> » o « Special:FormEdit/<nom de formulari>/<nom de pagina cibla> ».",
	'sf_formedit_altforms' => 'Podètz, a la plaça, apondre aquesta pagina amb un dels formularis seguents :',
	'sf_formedit_altformsonly' => 'Se vos plai, seleccionatz un dels formularis seguents per apondre aquesta pagina :',
	'sf_formcreate' => 'Crear amb un formulari',
	'sf_viewform' => 'Veire lo formulari',
	'sf_editsource' => 'Editar la font',
	'sf_formedit_edittitle' => 'Editar $1 : $2',
	'sf_formedit_morethanoneform' => 'Avertiment : Mai d’un formulari per defaut es especificat per aquesta pagina.',
	'sf_formedit_formwarning' => 'Atencion : aquesta pagina <a href="$1">existís ja</a>, mas utiliza pas aqueste formulari.',
	'sf_formedit_remove' => 'Levar',
	'sf_formedit_addanother' => 'Apondre un autre',
	'sf_formedit_none' => 'Cap',
	'runquery' => 'Executar la requèsta',
	'sf_runquery_badurl' => "Vos cal un nom de formulari dins l'URL ;
l'URL deuriá èsser coma « Special:RunQuery/<nom del formulari> ».",
	'sf_runquery_title' => 'Executar la requèsta : $1',
	'sf_runquery_additionalquery' => 'Requèsta adicionala',
	'sf_formerrors_header' => 'I a cèrtas errors dins lo formulari. Cf. çaijós.',
	'sf_blank_error' => 'pòt pas èsser blanc',
	'sf_bad_url_error' => 'deu aver un format URL corrècte, començant per « http »',
	'sf_bad_email_error' => "deu aver un format corrècte d'adreça de corrièr electronic.",
	'sf_bad_number_error' => 'deu èsser un nombre valid',
	'sf_bad_date_error' => 'deu èsser una data valida',
	'uploadwindow' => 'Importar la fenèstra', # Fuzzy
	'sf_deletionlog' => 'Istoric de las supressions',
	'sf_property_isproperty' => 'Aquò es una proprietat del tipe $1.',
	'sf_property_linkstoform' => "Liga cap a las paginas qu'utilizan lo formulari $1.",
	'sf_property_allowedvals' => '{{PLURAL:$1|La valor autorizada per aquesta proprietat es|Las valors autorizadas per aquesta proprietat son}} :',
	'sf_template_docu' => 'Aquò es lo modèl « $1 ». Deuriá èsser apelat segon lo format seguent :',
	'sf_template_docufooter' => 'Modificar la pagina per veire lo tèxte del modèl.',
	'sf_form_docu' => "Aquò es lo formulari « $1 ». Per apondre una pagina amb aqueste formulari, picatz son nom çaijós ; se existís ja, seretz dirigit cap a un formulari destinat a l'editar.", # Fuzzy
	'sf_form_freetextlabel' => 'Tèxte liure',
	'sf_category_hasdefaultform' => 'Aquesta categoria utiliza lo formulari « $1 ».',
	'sf_category_desc' => 'Aquò es la categoria « $1 ».',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => "Veire l'onglet « modificar » per las paginas modificablas via un formulari", # Fuzzy
	'right-editrestrictedfields' => 'Modificar los camps restrenches dels formularis',
);

/** Ossetic (Ирон)
 * @author Amikeco
 * @author Bouron
 */
$messages['os'] = array(
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблонтæ',
	'sf_createtemplate_deletefield' => 'Схафын',
	'sf_createform_template' => 'Шаблон:',
	'sf_formedit_none' => 'Нæй',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'templates' => 'Moddle',
	'sf_createtemplate_deletefield' => 'Verwische',
	'sf_createform_template' => 'Moddel:',
	'sf_createform_add' => 'Dezu duh',
	'sf_formstart_createoredit' => 'Dezu duh odder ennere',
	'sf_formedit_createtitle' => 'Duh $1: $2 dezu',
	'sf_formedit_edittitle' => '$1: $2 ennere',
	'sf_formedit_addanother' => 'Weidere dezu duh',
	'sf_formedit_none' => 'Ken',
	'sf_blank_namespace' => 'Blatt',
);

/** Pälzisch (Pälzisch)
 * @author Manuae
 */
$messages['pfl'] = array(
	'sf_createtemplate_deletefield' => 'Lesche',
	'sf_createform_hidden' => 'Vaschdegld',
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Jwitos
 * @author Maikking
 * @author McMonster
 * @author Odie2
 * @author Sp5uhe
 * @author ToSter
 * @author Woytecr
 */
$messages['pl'] = array(
	'semanticforms-desc' => 'Formularze do dodawania i edycji danych semantycznych',
	'specialpages-group-sf_group' => 'Semantyczne formularze',
	'createproperty' => 'Utwórz własność',
	'sf_createproperty_linktoform' => 'Ta własność linkuje do stron, które korzystają z formularza',
	'sf_createproperty_allowedvalsinput' => 'Jeśli chcesz, aby ta własność mogła zawierać tylko określone wartości, podaj listę dozwolonych wartości oddzielonych przecinkami (jeśli wartość zawiera przecinek, zastąp go „\\,”):',
	'sf_createproperty_propname' => 'Nazwa własności',
	'sf_createproperty_proptype' => 'Typ',
	'templates' => 'Szablony',
	'sf_templates_docu' => 'Następujące szablony istnieją w przestrzeni wiki.',
	'sf_templates_definescat' => 'definiuje kategorię $1',
	'createtemplate' => 'Utwórz szablon',
	'sf_createtemplate_namelabel' => 'Nazwa szablonu',
	'sf_createtemplate_categorylabel' => 'Kategoria zdefiniowana przez szablon (nieobowiązkowe)',
	'sf_createtemplate_templatefields' => 'Pola szablonu',
	'sf_createtemplate_fieldsdesc' => 'Aby pola szablonu nie wymagały nazw pól, wprowadź indeks dla każdego pola (np. 1, 2, 3 itd.) jako nazwę.',
	'sf_createtemplate_fieldname' => 'Nazwa pola',
	'sf_createtemplate_displaylabel' => 'Wyświetlana etykieta',
	'sf_createtemplate_semanticproperty' => 'Własność semantyczna',
	'sf_createtemplate_fieldislist' => 'Pole może zawierać listę wartości rozdzielonych przecinkami',
	'sf_createtemplate_aggregation' => 'Streszczenie',
	'sf_createtemplate_aggregationdesc' => 'Aby korzystając z tego szablonu wypisać na dowolnej stronie wszystkie strony, których pewna własność wskazuje na daną stronę, wybierz odpowiednią własność:',
	'sf_createtemplate_aggregationlabel' => 'Tytuł listy',
	'sf_createtemplate_outputformat' => 'Format wyjścia:',
	'sf_createtemplate_standardformat' => 'Standardowy', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Infoboks po prawej', # Fuzzy
	'sf_createtemplate_addfield' => 'Dodaj pole',
	'sf_createtemplate_deletefield' => 'Usuń',
	'sf_createtemplate_addtemplatebeforesave' => 'Musisz dodać przynajmniej jeden szablon do tego formularza, zanim go zapiszesz.',
	'forms' => 'Formularze',
	'sf_forms_docu' => 'Poniższe formularze są już zdefiniowane w przestrzeni wiki.',
	'sf_forminputs_mandatory' => 'Obowiązkowe',
	'sf_forminputs_restricted' => 'Te informacje wprowadzać mogą wyłącznie administratorzy',
	'sf_forminputs_class' => 'Atrybut HTML "class" dla tego pola wprowadzania danych',
	'sf_forminputs_default' => 'Wartość domyślna dla tego pola wprowadzania danych',
	'sf_forminputs_preload' => 'Strona wiki, której zawartość stanie się wartością domyślną tego pola',
	'sf_forminputs_property' => 'Cecha semantyczna, której odpowiada to pole',
	'sf_forminputs_size' => 'Rozmiar tego pola tekstowego, w znakach',
	'sf_forminputs_maxlength' => 'Maksymalna dozwolona długość tekstu w tym polu',
	'sf_forminputs_placeholder' => 'Tekst pomocy, który pojawia się wewnątrz pola, zanim użytkownik na nim kliknie',
	'sf_forminputs_uploadable' => 'Umieść łącze "Wyślij plik" obok tego pola', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Domyślna nazwa pliku dla wysyłanych plików',
	'sf_forminputs_rows' => 'Liczba wierszy dla tego wprowadzania',
	'sf_forminputs_cols' => 'Liczba kolumn dla tego wprowadzania',
	'createform' => 'Utwórz formularz',
	'sf_createform_nameinput' => 'Nazwa formularza',
	'sf_createform_nameinputdesc' => '(zwyczajowo nazwa formularza jest taka sama ja nazwa jego podstawowego szablonu)',
	'sf_createform_template' => 'Szablon',
	'sf_createform_templatelabelinput' => 'Etykieta szablonu (nieobowiązkowa)',
	'sf_createform_allowmultiple' => 'Zezwól na wielokrotne użycie lub nieużycie tego szablonu na tworzonej stronie',
	'sf_createform_field' => 'Pole:',
	'sf_createform_fieldprop' => 'To pole definiuje własność $1 typu $2.',
	'sf_createform_fieldproplist' => 'To pole definiuje listę elementów, które mają własność $1 typu $2.',
	'sf_createform_fieldpropunknowntype' => 'To pole definiuje własność $1 nieznanego typu.',
	'sf_createform_inputtype' => 'Podaj typ',
	'sf_createform_inputtypedefault' => '(wartość domyślna)',
	'sf_createform_formlabel' => 'Etykieta formularza',
	'sf_createform_hidden' => 'Ukryte',
	'sf_createform_removetemplate' => 'Usuń szablon',
	'sf_createform_addtemplate' => 'Dodaj szablon',
	'sf_createform_beforetemplate' => 'Przed szablonem',
	'sf_createform_atend' => 'Na końcu',
	'sf_createform_add' => 'Dodaj',
	'sf_createform_choosefield' => 'Wybierz pole do dodania',
	'createcategory' => 'Stwórz kategorię',
	'sf_createcategory_name' => 'Nazwa kategorii',
	'sf_createcategory_defaultform' => 'Domyślny formularz',
	'sf_createcategory_makesubcategory' => 'Uczyń tę kategorię podkategorią innej kategorii (nieobowiązkowe)',
	'createclass' => 'Utwórz klasę',
	'sf_createclass_docu' => 'Wpisz wszystkie informacje, aby utworzyć własności, szablon, formularz oraz kategorię dla pojedynczej klasy. Większa liczba opcji dostępna jest na stronie $1.',
	'sf_createclass_allowedvalues' => 'Dopuszczalne wartości:',
	'sf_createclass_listofvalues' => 'Lista wartości?',
	'sf_createclass_missingvalues' => 'Nie zostały wypełnione wszystkie wymagane pola.',
	'sf_createclass_success' => 'Zostaną utworzone: własności, szablon, formularz oraz kategoria.',
	'formstart' => 'Dodaj stronę z formularzem',
	'sf_formstart_badform' => 'Błąd – na $1 nie odnaleziono żadnego formularza',
	'sf_formstart_badtitle' => 'Błąd – „$1” nie jest prawidłową nazwą strony.',
	'sf_formstart_docu' => 'Wprowadź tutaj nazwę strony, która ma być edytowana z użyciem formularza „$1”.
Jeśli strona istnieje, zostanie otwarta do edycji w tym formularzu.
W przeciwnym wypadku będziesz mógł edytować z użyciem formularza nową stronę.',
	'sf_formstart_noform_docu' => 'Wprowadź tutaj nazwę strony, a następnie wybierz formularz z użyciem którego ma być edytowana.
Jeśli strona istnieje, zostanie otwarta do edycji w tym formularzu.
W przeciwnym wypadku będziesz mógł edytować z użyciem formularza nową stronę.',
	'sf_formstart_createoredit' => 'Utwórz lub edytuj',
	'formedit' => 'Edytuj korzystając z formularza',
	'sf_formedit_createtitle' => 'Utwórz $1: $2',
	'sf_formedit_badurl' => 'Tę stronę edytuje się przy użyciu formularza. Musisz określić w adresie URL nazwę formularza i stronę docelową. Powinno to wyglądać podobnie do „Special:FormEdit?form=<nazwa formularza>&target=<strona docelowa>” lub  „Special:FormEdit/<nazwa formularza>/<strona docelowa>”.',
	'sf_formedit_altforms' => 'Zamiast tego możesz dodać stronę z jednym z następujących formularzy:',
	'sf_formedit_altformsonly' => 'Wybierz jeden z poniższych formularzy, aby dodać tę stronę:',
	'sf_formcreate' => 'Utwórz korzystając z formularza',
	'sf_viewform' => 'Zobacz formularz',
	'sf_editsource' => 'Edytuj źródło',
	'sf_formedit_edittitle' => 'Edytuj $1: $2',
	'sf_formedit_morethanoneform' => "'''Uwaga''' – dla tej strony zdefiniowano więcej niż jeden domyślny formularz.",
	'sf_formedit_formwarning' => 'Uwaga – ta strona <a href="$1">już istnieje</a>, ale nie używa tego formularza.',
	'sf_formedit_remove' => 'Usuń',
	'sf_formedit_addanother' => 'Dodaj kolejny',
	'sf_formedit_none' => 'Brak',
	'sf_autoedit_fail' => 'Modyfikacja [[$1]] nie powiodła się.',
	'sf_autoedit_redlinkexists' => '$1 już istnieje.',
	'sf-autoedit-wait' => 'Czekaj...',
	'runquery' => 'Uruchom zapytanie',
	'sf_runquery_badurl' => 'Musisz podać nazwę formularza w adresie URL,
który powinien wyglądać podobnie do „Specjalna:RunQuery/<nazwa formularza>”.',
	'sf_runquery_title' => 'Uruchom zapytanie: $1',
	'sf_runquery_additionalquery' => 'Dodatkowe zapytanie',
	'sf_formerrors_header' => 'We wprowadzonych przez Ciebie danych wystąpiły błędy; zobacz poniżej',
	'sf_blank_error' => 'nie może pozostać puste',
	'sf_bad_url_error' => 'musi mieć poprawny format adresu URL, rozpoczynającego się od „http”',
	'sf_bad_email_error' => 'musi mieć poprawny format adresu e‐mail',
	'sf_bad_number_error' => 'musi być poprawną liczbą',
	'sf_bad_date_error' => 'musi być poprawną datą',
	'uploadwindow' => 'Okno przesyłania plików',
	'sf_deletionlog' => 'Rejestr usunięć',
	'sf_property_isproperty' => 'To jest własność typu $1.',
	'sf_property_linkstoform' => 'Linkuje do stron, używających formularza $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dopuszczalna wartość dla tej własności to|Dopuszczalne wartości dla tej własności to:}}',
	'sf_template_docu' => 'To jest szablon „$1”.
Powinien zostać wywołany w następującym formacie:',
	'sf_template_docufooter' => 'Edytuj stronę, aby zobaczyć tekst szablonu.',
	'sf_form_docu' => 'To jest formularz „$1”.
Aby dodać stronę za pomocą tego formularza, wpisz poniżej nazwę strony.
Jeśli strona o tej nazwie już istnieje, otwarty zostanie formularz edycji tej strony.',
	'sf_form_freetextlabel' => 'Dowolny tekst',
	'sf_category_hasdefaultform' => 'Ta kategoria używa formularza $1.',
	'sf_category_desc' => 'To jest kategoria $1.',
	'sf_blank_namespace' => 'Główna',
	'right-viewedittab' => 'Widoczność zakładki „Edytuj” dla stron, które można edytować korzystając z formularza', # Fuzzy
	'right-editrestrictedfields' => 'Edycja zabezpieczonych pól formularzy',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 * @author McDutchie
 */
$messages['pms'] = array(
	'semanticforms-desc' => 'Formolari për gionté e selessioné dat semàntich',
	'specialpages-group-sf_group' => 'Formolari Semàntich',
	'createproperty' => 'Crea na proprietà',
	'sf-createproperty-with-name' => 'Creé la propietà: $1',
	'sf_createproperty_linktoform' => "Sta proprietà-sì a mandrà a le pàgine ch'a deuvro ël formolari:",
	'sf_createproperty_allowedvalsinput' => "S'a veul che costa proprietà-sì a peussa mach avèj serti valor, ch'a anserissa la lista dij valor possìbij, separà da 'd vìrgole (se un valor a conten na vìrgola, rimpiassla con \"\\,\"):",
	'sf_createproperty_propname' => 'Nòm dla proprietà:',
	'sf_createproperty_proptype' => 'Sòrt:',
	'templates' => 'Stamp',
	'sf_templates_docu' => 'Ant la wiki a esisto jë stamp sì-sota.',
	'sf_templates_definescat' => 'a definiss la categorìa: $1',
	'createtemplate' => 'Crea në stamp',
	'sf-createtemplate-with-name' => 'Creé lë stamp: $1',
	'sf_createtemplate_namelabel' => 'Nòm ëd lë stamp:',
	'sf_createtemplate_multipleinstance' => 'Së stamp a peul esse anserì vàire vòte ant la pàgina.',
	'sf_createtemplate_categorylabel' => 'Categorìa definìa da stamp (opsional):',
	'sf_createtemplate_templatefields' => 'Camp dë stamp',
	'sf_createtemplate_fieldsdesc' => "Përché ij camp an sto stamp-sì a ciamo pa pi dij nòm ëd camp, ch'a anserissa mach l'ìndes ëd minca camp (për esempi 1, 2, 3, e via fòrt) për nòm, nopà dël nòm ver.",
	'sf_createtemplate_fieldname' => 'Nòm dël camp:',
	'sf_createtemplate_displaylabel' => 'Tichëtta për la visualisassion:',
	'sf_createtemplate_semanticproperty' => 'Proprietà semàntica:',
	'sf_createtemplate_fieldislist' => 'Sto camp-sì a peul ten-e na lista ëd valor, separà da vìrgole',
	'sf_createtemplate_aggregation' => 'Agregassion',
	'sf_createtemplate_aggregationdesc' => "Për listé, su minca pàgina ch'a deuvra sto stamp-sì, tute le pàgine ch'a l'han na serta proprietà ch'a ponta a cola pàgina, ch'a spessìfica sì-sota la proprietà ch'a-i va:",
	'sf_createtemplate_aggregationlabel' => 'Tìtol për lista:',
	'sf_createtemplate_outputformat' => 'Formà ëd surtìa:',
	'sf_createtemplate_standardformat' => 'Tàula',
	'sf_createtemplate_infoboxformat' => "Quàder d'anformassion lateral",
	'sf_createtemplate_plainformat' => 'Mach test',
	'sf_createtemplate_sectionsformat' => 'Session',
	'sf_createtemplate_addfield' => 'Gionté un camp',
	'sf_createtemplate_deletefield' => 'Scancelé',
	'sf_createtemplate_addtemplatebeforesave' => 'A deuv gionté almanch në stamp a cost formolari-sì prima ëd podèj salvelo.',
	'forms' => 'Formolari',
	'sf_forms_docu' => 'Ij formolari sì-sota a esisto ant la wiki.',
	'sf_forminputs_mandatory' => 'Obligatòri',
	'sf_forminputs_restricted' => "Mach j'aministradtor a peulo modifiché cost anseriment",
	'sf_forminputs_class' => 'L\'atribù "class" HTML për cost anseriment',
	'sf_forminputs_default' => 'Ël valor dë stàndard për cost anseriment',
	'sf_forminputs_preload' => 'Na pàgina wiki dont ël contnù a dventrà ël valor dë standard ëd cost anseriment',
	'sf_forminputs_property' => 'Na propietà semantica a la qual ës camp a corëspond',
	'sf_forminputs_size' => "La dimension d'ës camp ëd test, an caràter",
	'sf_forminputs_maxlength' => 'La màssima longheur possìbil dël test ant ës camp',
	'sf_forminputs_placeholder' => "Test d'agiut ch'as vëdd ant l'anseriment fin che l'utent a jë sgnaca dzora",
	'sf_forminputs_uploadable' => 'Ch\'a buta na liura "carié l\'archivi" da banda ëd cost anseriment', # Fuzzy
	'sf_forminputs_defaultfilename' => "Ël nòm d'archivi stàndard për j'archivi carià",
	'sf_forminputs_rows' => 'Ël nùmer ëd righe për cost anseriment',
	'sf_forminputs_cols' => 'Ël nùmer ëd colòne për cost anseriment',
	'sf_forminputs_autogrow' => 'Amposté cost anseriment për agrandisse an dimension se ël test a passa ij lìmit',
	'sf_forminputs_valuesfromproperty' => "Na propietà dont ij valor ant la wiki a dovrìo esse l'ansema dij valor ëd cost anseriment",
	'sf_forminputs_valuesfromcategory' => "Na categorìa dont le pàgine a dovrìo esse l'ansema dij calor ëd cost anseriment",
	'sf_forminputs_valuesfromnamespace' => "Në spassi nominal dont le pagine dovrìo esse l'ansema dij valor ëd cost anseriment",
	'sf_forminputs_valuesfromconcept' => 'Na pàgina "concet" ëd Semantic MediaWiki dont le pàgine a dovrìo esse l\'ansema dij valor ëd cost anseriment',
	'sf_forminputs_valuesfromurl' => "N'anliura ch'a ten dij dat struturà ch'a dovrìo esse l'ansema dij valor ëd cost anseriment",
	'sf_forminputs_values' => "L'ansema dij valor për cost anseriment, separà da 'd vìrgole",
	'sf_forminputs_list' => "Marché s'anseriment com tnisand na lista ëd valor",
	'sf_forminputs_delimiter' => 'Ël separator tra ij valor dël camp, se cost anseriment a na ten na lista',
	'sf_forminputs_remoteautocompletion' => 'Dovré ël completament automàtich da leugn',
	'sf_forminputs_existingvaluesonly' => 'Përmëtte mach ij valor già ant la lista',
	'sf_forminputs_showonselect' => 'Element ëd pàgina da mostré mach se serti valor a son selessionà (esempi: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => "L'autëssa ëd costa zòna ëd lista, an righe",
	'sf_forminputs_includetimezone' => 'Gionté un camp për ël fus orari',
	'sf_forminputs_topcategory' => "La categorìa pare dë st'ansema ëd categorìe (obligatòria)",
	'sf_forminputs_hideroot' => 'Stërmé la categorìa mare',
	'sf_forminputs_depth' => 'Ël nùmer ëd livej ëd categorìe da mostré inissialment',
	'sf_forminputs_height' => "L'autëssa ëd cost anseriment, an pontin",
	'sf_forminputs_width' => 'La larghëssa ëd cost anseriment, an pontin',
	'createform' => 'Creé un formolari',
	'sf-createform-with-name' => 'Creé ël formolari: $1',
	'sf_createform_nameinput' => 'Nòm dël formolari',
	'sf_createform_nameinputdesc' => "(al formolari a l'é dàit normalment ël midem nòm dël sò stamp prinsipal):",
	'sf_createform_template' => 'Stamp:',
	'sf_createform_templatelabelinput' => 'Etichëtta dlë stamp (opsional):',
	'sf_createform_allowmultiple' => "Përmëtte d'istanse mùltiple (o gnun-e) dë sto stamp-sì ant la pàgina creà",
	'sf_createform_field' => 'Camp:',
	'sf_createform_fieldprop' => 'Sto camp-sì a definiss la proprietà $1, ëd sòrt $2.',
	'sf_createform_fieldproplist' => "Sto camp-sì a definiss na lista d'element ch'a l'han la proprietà $1, ëd sòrt $2.",
	'sf_createform_fieldpropunknowntype' => 'Sto camp-sì a definiss la proprietà $1, ëd sòrt pa spessificà.',
	'sf_createform_inputtype' => "Tipo d'ingress:",
	'sf_createform_inputtypedefault' => '(stàndard)',
	'sf_createform_formlabel' => 'Etichëtta dël formolari:',
	'sf_createform_hidden' => 'Stërmà',
	'sf_createform_removetemplate' => 'Gavé lë stamp',
	'sf_createform_addtemplate' => 'Gionté në stamp:',
	'sf_createform_beforetemplate' => 'Prima dlë stamp:',
	'sf_createform_atend' => 'A la fin',
	'sf_createform_add' => 'Gionta',
	'sf_createform_choosefield' => 'Sern un camp da gionté',
	'createcategory' => 'Crea na categorìa',
	'sf-createcategory-with-name' => 'Creé la categorìa: $1',
	'sf_createcategory_name' => 'Nòm dla categorìa:',
	'sf_createcategory_defaultform' => 'Formolari dë stàndard:',
	'sf_createcategory_makesubcategory' => "Fé vnì sta categorìa-sì na sot-categorìa ëd n'àutra categorìa (opsional):",
	'createclass' => 'Crea na class',
	'sf_createclass_docu' => "Ch'a anseriss sì tùit ij dat për creé le proprietà, stamp, formolari e categorìa për na sìngola class. Për pi d'opsion, ch'a deuvra pitòst le pàgine $1.",
	'sf_createclass_allowedvalues' => 'Valor përmëttù:',
	'sf_createclass_listofvalues' => 'Lista ëd valor?',
	'sf_createclass_nameinput' => 'Nòm dël formolari:',
	'sf_createclass_missingvalues' => 'Pa tùit ij camp ciamà a son stàit ampinì.',
	'sf_createclass_success' => 'Proprietà, stamp, formolari e categorìa a saran creà.',
	'sf_createclass_create' => 'Crea',
	'formstart' => 'Gionté na pàgina con un formolari',
	'sf_formstart_badform' => "Eror: gnun-a pàgina ëd formolari a l'é stàita trovà a $1",
	'sf_formstart_badtitle' => 'Eror: "$1" a l\'é un tìtol pa bon për na pàgina.',
	'sf_formstart_docu' => 'Ch\'a anserissa ël nòm ëd la pàgina ambelessì, da modifiché con ël formolari "$1".
Se sta pàgina-sì a esist già, a sarà mandà al formolari për modifiché cola pàgina.
Dësnò, a sarà mandà al formolari për gionté la pàgina.',
	'sf_formstart_noform_docu' => "Ch'a anserissa ël nòm ëd la pàgina ambelessì, e ch'a selession-a ël formolari për modifichela.
Se sta pàgina-sì a esist già, a sarà mandà al formolari për modifiché cola pàgina.
Dësnò, a sarà mandà al formolari për gionté la pàgina.",
	'sf_formstart_createoredit' => 'Crea o modìfica',
	'formedit' => 'Modifiché con un formolari',
	'sf_formedit_createtitle' => 'Crea $1: $2',
	'sf_formedit_createtitlenotarget' => 'Crea $1',
	'sf_formedit_badurl' => "Costa-sì a l'é la pàgina për modifiché con un formolari. A dev spessifiché sia un nòm ëd formolari sia na pàgina obietiv ant l'adrëssa dl'aragnà;
a dovrìa smijé a 'Special:FormEdit?form=<form name>&target=<nòm dla pàgina>', or
'Special:FormEdit/<form name>/<nòm dla pàgina>'.",
	'sf_formedit_altforms' => 'A peul anvece gionté sta pàgina-sì con un dij formolari sì-sota:',
	'sf_formedit_altformsonly' => "Për piasì, ch'a selession-a un dij formolari sì-sota për gionté costa pàgina:",
	'sf_formcreate' => 'Creé con un formolari',
	'sf_viewform' => 'Visualisé ël formolari',
	'sf_editsource' => 'Modifiché la sorgiss',
	'sf_formedit_edittitle' => 'Modìfica $1: $2',
	'sf_formedit_morethanoneform' => "'''Atension:''' Pi che un formolari dë stàndard a l'é spessificà për costa pàgina.",
	'sf_formedit_formwarning' => 'Atension: Sta pàgina-sì <a href="$1">a esist già</a>, ma a deuvra pa cost formolari.',
	'sf_formedit_mismatchedbrackets' => "Avis: Costa pàgina a conten dle parèntes grafe o quadrà ch'a son nen sarà, parèj la pàgina a sarà pa gestìa coretament dal formolari. Për piasì, <a href=\"\$1\">ch'a coregia l'eror ant ël test ëd la sorgiss</a> prima d'andé anans.",
	'sf_formedit_remove' => 'Gava',
	'sf_formedit_addanother' => "Gionté n'àutr",
	'sf_formedit_none' => 'Gnun',
	'sf_formedit_emptytitle' => 'Eror: Ij dat anserì a dan un tìtol ëd pàgina veuid.',
	'sf_formedit_hookerror' => "Eror: N'estension ëd MediaWiki a l'ha vietà la modìfica dla pàgina destinassion.",
	'sf_formedit_saveandcontinueediting' => 'Salva e continua',
	'sf_formedit_saveandcontinue_summary' => 'Salva dovrand ël boton "$1" ant ël formolari',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Salva ij dat e continua a modifiché',
	'sf_autoedit_anoneditwarning' => "Atension: a l'é nen intrà ant ël sistema. Soa adrëssa IP a sarà memorisà ant la stòria dle modìfiche ëd sa pàgina.",
	'sf_autoedit_success' => '[[$1]] modificà për da bin an dovrand ël formolari $2.',
	'sf_autoedit_fail' => 'Modìfica [[$1]] falìa.',
	'sf_autoedit_notargetspecified' => 'Gnun-a pàgina ëd destinassion specificà.',
	'sf_autoedit_invalidtargetspecified' => "La pàgina ëd destinassion specificà $1 a l'é pa bon-a.",
	'sf_autoedit_invalidform' => "$1 a l'é un formolari pa bon.",
	'sf_autoedit_redirectlimitexeeded' => "Ël lìmit màssim ëd ridiression për ël formolari $1 a l'é stàit sorpassà.",
	'sf_autoedit_invalidredirecttarget' => "$1 a l'é na destinassion ëd ridiression ch'a va nen bin për ël formolari $2.",
	'sf_autoedit_invalidpreloadspecified' => "La pàgina ëd precariagi specificà $1 a l'é pa bon-a.",
	'sf_autoedit_redlinkexists' => '$1 a esist già.',
	'sf_autoedit_noformfound' => 'Gnun formolari specificà.',
	'sf_autoedit_toomanyformsfound' => 'Pi che un formolari disponìbil për la pàgina.',
	'sf_autoedit_readonly' => "La base ëd dàit a l'é al moment blocà për le modìfiche. Rason: $1",
	'sf_autoedit_nosemanticform' => "As peul pa oten-se ël formolari $2 për la pàgina $1. Ch'a vëdda [[{{#special:FormEdit}}/$2/$1]] për ij detaj.",
	'sf_autoedit_summary' => 'Modificà automaticament da la pàgina $1.',
	'sf-autoedit-wait' => 'Speté...',
	'runquery' => 'Consulté la base dat',
	'sf_runquery_badurl' => "A deuv spessifiché un nòm ëd formolari ant l'adrëssa dl'aragnà;
l'adrëssa a dovrìa esse com 'Special:RunQuery/<nom del formolari>'.",
	'sf_runquery_title' => "Fé andé l'arcesta: $1",
	'sf_runquery_additionalquery' => 'Arcesta adissional',
	'sf_formerrors_header' => "A-i son ëstaje d'eror con l'imission ëd sò formolari; beiché sì-sota",
	'sf_blank_error' => 'a peul pa esse veuid',
	'sf_bad_url_error' => "a deuv avèj ël formà d'adrëssa giust, partend con 'http'",
	'sf_bad_email_error' => "a deuv avèj un formà bon ëd l'adrëssa ëd pòsta eletrònica",
	'sf_bad_number_error' => 'a deuv esse un nùmer bon',
	'sf_bad_date_error' => 'a deuv esse na data bon-a',
	'uploadwindow' => 'Carié la fnestra',
	'sf_deletionlog' => 'Registr djë scancelament',
	'sf-preview-header' => 'Previsualisassion dël formolari',
	'sf-preview-note' => "Sòn a l'é lòn che ël formolari a smijerà quans as dovrerà:",
	'sf-pageschemas-pagenameformula' => 'Fórmola dël nòm ëd pàgina:',
	'sf-pageschemas-createtitle' => 'Tìtol dël formolari për le pàgine neuve:',
	'sf-pageschemas-edittitle' => 'Tìtol dël formolari për le pàgine esistente:',
	'sf-pageschemas-inputtype' => "Sòrt d'anseriment (lassé veuid për amposté a predefinì):",
	'sf_property_isproperty' => "Costa-sì a l'é na proprietà ëd sòrt $1.",
	'sf_property_linkstoform' => "A colega a le pàgine ch'a deuvro ël formolari $1.",
	'sf_property_allowedvals' => "{{PLURAL:$1|Ël valor përmëttù për sta proprietà-sì a l'é|Ij valor përmëttù për sta proprietà-sì a son}}:",
	'sf_template_docu' => 'Cost-sì a l\'é lë stamp "$1".
A dovrìa esse arciamà ant ël formà sì-sota:',
	'sf_template_docufooter' => 'Modìfica la pàgina për vëdde ël test ëd lë stamp.',
	'sf_form_docu' => 'Cost-sì a l\'é ël formolari "$1".
Për creé na pàgina con cost formolari, ch\'a anserissa ël nòm ëd la pàgina sì-sota;
se na pàgina con col nòm a esist già, a sarà mandà a \'n formolari për modifiché cola pàgina.',
	'sf_form_freetextlabel' => 'Test lìber.',
	'sf_category_hasdefaultform' => 'Sta categorìa-sì a deuvra ël formolari $1.',
	'sf_category_desc' => "Costa a l'é la categorìa $1.",
	'sf_blank_namespace' => 'Prinsipal',
	'right-viewedittab' => 'Visualisé la scheda "{{int:edit}}" për le pàgine modificàbij con un formolari',
	'right-editrestrictedfields' => 'Modìfiché ij camp ëd formolari arservà',
	'right-createclass' => 'Creé ëd neuve classe semàntiche',
	'action-createclass' => 'creé ëd neuve classe semàntiche',
	'action-editrestrictedfields' => 'modìfiché ij camp ëd formolari arservà',
	'action-viewedittab' => 'visualisé la scheda "{{int:edit}}" për le pàgine modificàbij da formolari',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'createproperty' => 'يوه ځانتيا ځانګړې کول',
	'sf_createproperty_propname' => 'د ځانتيا نوم:',
	'sf_createproperty_proptype' => 'ډول:',
	'templates' => 'کينډۍ',
	'sf_templates_definescat' => 'د وېشنيزې څرګندونه: $1',
	'createtemplate' => 'يوه کينډۍ جوړول',
	'sf_createtemplate_namelabel' => 'د کينډۍ نوم:',
	'sf_createtemplate_aggregationlabel' => 'د لړليک لپاره سرليک:',
	'sf_createtemplate_standardformat' => 'لښتيال',
	'sf_createtemplate_sectionsformat' => 'برخې',
	'sf_createtemplate_deletefield' => 'ړنګول',
	'sf_createform_template' => 'کينډۍ:',
	'sf_createform_inputtypedefault' => '(تلواليز)',
	'sf_createform_hidden' => 'پټ',
	'sf_createform_addtemplate' => 'کينډۍ ورګډول:',
	'sf_createform_atend' => 'په پای کې',
	'sf_createform_add' => 'ورګډول',
	'createcategory' => 'يوه وېشنيزه جوړول',
	'sf_createcategory_name' => 'د وېشنيزې نوم:',
	'sf_createclass_create' => 'جوړول',
	'formstart' => 'د فورمې سره يوځای يو مخ ګډول',
	'sf_formstart_createoredit' => 'جوړول يا سمول',
	'sf_formedit_createtitle' => '$1 جوړول: $2',
	'sf_formedit_createtitlenotarget' => 'جوړول $1',
	'sf_formedit_remove' => 'غورځول',
	'sf_formedit_addanother' => 'يو بل ورګډول',
	'sf_formedit_none' => 'هېڅ',
	'sf_bad_email_error' => 'بايد چې برېښليک پته يوه سمه بڼه ولري',
	'sf_bad_number_error' => 'بايد چې يوه سمه شمېره وي',
	'sf_bad_date_error' => 'بايد چې يوه سمه نېټه وي',
	'sf_deletionlog' => 'د ړنګولو يادښت',
	'sf_form_freetextlabel' => 'خپلواکه متن',
	'sf_category_desc' => 'همدا د $1 وېشنيزه ده.',
	'sf_blank_namespace' => 'آرنی',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 * @author Lijealso
 * @author Malafaya
 * @author SandroHc
 * @author Waldir
 * @author 555
 */
$messages['pt'] = array(
	'semanticforms-desc' => 'Formulários para adicionar e editar dados semânticos',
	'specialpages-group-sf_group' => 'Formulários Semânticos',
	'createproperty' => 'Criar uma propriedade',
	'sf_createproperty_linktoform' => 'Esta propriedade irá ligar às páginas que usem o formulário:',
	'sf_createproperty_allowedvalsinput' => 'Se pretende que esta propriedade apenas possa conter determinados valores, introduza a lista de valores permitidos, separados por vírgulas (se um valor contém uma vírgula, substitua-a por "\\,"):',
	'sf_createproperty_propname' => 'Nome da propriedade:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Predefinições',
	'sf_templates_docu' => 'As seguintes predefinições existem nesta wiki.',
	'sf_templates_definescat' => 'definir categoria: $1',
	'createtemplate' => 'Criar uma predefinição',
	'sf_createtemplate_namelabel' => 'Nome da predefinição:',
	'sf_createtemplate_categorylabel' => 'Categoria definida pela predefinição (opcional):',
	'sf_createtemplate_templatefields' => 'Campos da predefinição:',
	'sf_createtemplate_fieldsdesc' => 'Para fazer com que os campos deste modelo não requiram descrições, simplesmente introduza o índice de cada campo (p.ex. 1, 2, 3, etc.) como o nome do campo, em vez de um nome real.',
	'sf_createtemplate_fieldname' => 'Nome do campo:',
	'sf_createtemplate_displaylabel' => 'Mostrar etiqueta:',
	'sf_createtemplate_semanticproperty' => 'Propriedade semântica:',
	'sf_createtemplate_fieldislist' => 'Este campo permite uma lista de valores, separados por vírgulas',
	'sf_createtemplate_aggregation' => 'Agregação',
	'sf_createtemplate_aggregationdesc' => 'Para listar, em qualquer página usando esta predefinição, todos os artigos que têm uma certa propriedade a apontar para aquela página, especifique a propriedade adequada abaixo:',
	'sf_createtemplate_aggregationlabel' => 'Título para a lista:',
	'sf_createtemplate_outputformat' => 'Formato de saída:',
	'sf_createtemplate_standardformat' => 'Tabela',
	'sf_createtemplate_infoboxformat' => 'Caixa informativa lateral',
	'sf_createtemplate_addfield' => 'Adicionar campo',
	'sf_createtemplate_deletefield' => 'Apagar',
	'sf_createtemplate_addtemplatebeforesave' => 'Tem de adicionar pelo menos uma predefinição a este formulário antes de o poder gravar.',
	'forms' => 'Formulários',
	'sf_forms_docu' => 'Os seguintes formulários existem na wiki.',
	'sf_forminputs_mandatory' => 'Obrigatório',
	'sf_forminputs_restricted' => 'Esta entrada só pode ser editada por administradores',
	'sf_forminputs_class' => 'O atributo HTML "class" para esta entrada',
	'sf_forminputs_default' => 'O valor por omissão desta entrada',
	'sf_forminputs_preload' => 'Uma página da wiki, cujo conteúdo será o valor por omissão desta entrada',
	'sf_forminputs_property' => 'Uma propriedade semântica, a que este campo corresponde',
	'sf_forminputs_size' => 'O tamanho deste campo de texto, em caracteres',
	'sf_forminputs_maxlength' => 'O comprimento máximo permitido para o texto deste campo',
	'sf_forminputs_uploadable' => 'Colocar um link "Upload de ficheiro" ao lado desta entrada', # Fuzzy
	'sf_forminputs_defaultfilename' => 'O nome de ficheiro por omissão, dos ficheiros enviados',
	'sf_forminputs_rows' => 'O número de linhas desta entrada',
	'sf_forminputs_cols' => 'O número de colunas desta entrada',
	'sf_forminputs_autogrow' => 'Definir que esta entrada deve aumentar de tamanho se o texto exceder os seus limites',
	'sf_forminputs_valuesfromproperty' => 'Uma propriedade, cujos valores na wiki devem formar o conjunto de valores desta entrada',
	'sf_forminputs_valuesfromcategory' => 'Uma categoria, cujas páginas devem formar o conjunto de valores desta entrada',
	'sf_forminputs_valuesfromnamespace' => 'Um espaço nominal, cujas páginas devem formar o conjunto de valores desta entrada',
	'sf_forminputs_valuesfromconcept' => 'Uma página de "conceito" ("concept") do MediaWiki Semântico, cujas páginas devem formar o conjunto de valores desta entrada',
	'sf_forminputs_valuesfromurl' => 'Uma URL, que contém dados estruturados que devem formar o conjunto de valores desta entrada',
	'sf_forminputs_values' => 'O conjunto de valores desta entrada, separados por vírgulas',
	'sf_forminputs_list' => 'Marcar que esta entrada detém uma lista de valores',
	'sf_forminputs_delimiter' => 'O delimitador entre os valores do campo, se esta entrada contém uma lista de valores',
	'sf_forminputs_remoteautocompletion' => 'Usar o preenchimento automático remoto',
	'sf_forminputs_existingvaluesonly' => 'Só permitir valores que já existam na lista',
	'sf_forminputs_showonselect' => 'Elementos da página que só serão apresentados se certos valores forem seleccionados (exemplo: "valor1=>div1;valor2=>div2")',
	'sf_forminputs_listboxsize' => 'A altura desta caixa de listagem, em linhas',
	'sf_forminputs_includetimezone' => 'Incluir uma entrada para o fuso horário',
	'sf_forminputs_topcategory' => 'A category-mãe deste conjunto de categorias (obrigatória)',
	'sf_forminputs_hideroot' => 'Esconder a categoria mãe',
	'sf_forminputs_height' => 'A altura desta entrada, em pixels',
	'sf_forminputs_width' => 'A largura desta entrada, em pixels',
	'createform' => 'Criar um formulário',
	'sf_createform_nameinput' => 'Nome do formulário',
	'sf_createform_nameinputdesc' => '(normalmente dá-se ao formulário o mesmo nome da sua predefinição principal):',
	'sf_createform_template' => 'Predefinição:',
	'sf_createform_templatelabelinput' => 'Etiqueta da predefinição (opcional):',
	'sf_createform_allowmultiple' => 'Permitir várias instâncias (ou zero) desta predefinição na página criada',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Este campo define a propriedade $1, do tipo $2.',
	'sf_createform_fieldproplist' => 'Este campo define uma lista de elementos que têm a propriedade $1, do tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Este campo define uma propriedade $1, de tipo não especificado.',
	'sf_createform_inputtype' => 'Tipo de entrada:',
	'sf_createform_inputtypedefault' => '(padrão)',
	'sf_createform_formlabel' => 'Etiqueta do formulário:',
	'sf_createform_hidden' => 'Oculto',
	'sf_createform_removetemplate' => 'Remover predefinição',
	'sf_createform_addtemplate' => 'Adicionar predefinição:',
	'sf_createform_beforetemplate' => 'Antes da predefinição:',
	'sf_createform_atend' => 'Ao fim',
	'sf_createform_add' => 'Adicionar',
	'sf_createform_choosefield' => 'Escolha um campo a adicionar',
	'createcategory' => 'Criar uma categoria',
	'sf_createcategory_name' => 'Nome da categoria:',
	'sf_createcategory_defaultform' => 'Formulário padrão:',
	'sf_createcategory_makesubcategory' => 'Fazer desta categoria uma subcategoria de outra categoria (opcional):',
	'createclass' => 'Criar uma classe',
	'sf_createclass_docu' => 'Introduza todos os dados aqui para criar as propriedades, modelo, formulário e categoria para uma única classe. Para mais opções, utilize antes as páginas $1.',
	'sf_createclass_allowedvalues' => 'Valores permitidos:',
	'sf_createclass_listofvalues' => 'Lista de valores?',
	'sf_createclass_nameinput' => 'Nome do formulário:',
	'sf_createclass_missingvalues' => 'Os campos obrigatórios não foram todos preenchidos.',
	'sf_createclass_success' => 'Propriedades, modelo, formulário e categoria serão criados.',
	'sf_createclass_create' => 'Criar',
	'formstart' => 'Adicionar página com formulário',
	'sf_formstart_badform' => 'Erro: não foi encontrada nenhuma página de formulário em $1',
	'sf_formstart_badtitle' => 'Erro: "$1" é um título inválido para uma página.',
	'sf_formstart_docu' => "Introduza o nome da página aqui, para ser editada com o formulário '$1'.
Se a página já existir, será enviado para o formulário de edição dessa página.
Caso contrário, será enviado para o formulário de adição da página.",
	'sf_formstart_noform_docu' => 'Introduza o nome da página aqui, e selecione um formulário a usar na sua edição.
Se a página já existir, será enviado para o formulário de edição dessa página.
Caso contrário, será enviado para o formulário de adição da página.',
	'sf_formstart_createoredit' => 'Criar ou editar',
	'formedit' => 'Editar com formulário',
	'sf_formedit_createtitle' => 'Criar $1: $2',
	'sf_formedit_createtitlenotarget' => 'Criar $1',
	'sf_formedit_badurl' => "Esta é a página para editar com um formulário. Na URL deve especificar um nome de formulário e uma página alvo; deverá parecer-se com 'Special:FormEdit?form=<form name>&target=<target page>', ou 'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'Pode, em alternativa, adicionar esta página com um dos seguintes formulários:',
	'sf_formedit_altformsonly' => 'Por favor, seleccione um dos seguintes formulários para adicionar esta página:',
	'sf_formcreate' => 'Criar com formulário',
	'sf_viewform' => 'Ver formulário',
	'sf_editsource' => 'Editar a origem',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => 'Atenção: Mais de um formulário padrão está definido para esta página.',
	'sf_formedit_formwarning' => 'Aviso: Esta página <a href="$1">já existe</a>, mas não utiliza este formulário.',
	'sf_formedit_remove' => 'Remover',
	'sf_formedit_addanother' => 'Adicionar outro',
	'sf_formedit_none' => 'Nenhum',
	'sf_formedit_emptytitle' => 'Erro: Os dados inseridos resultam num título de página em branco.',
	'sf_formedit_hookerror' => 'Erro: Uma extensão do MediaWiki impediu a modificação da página de destino.',
	'sf_formedit_saveandcontinueediting' => 'Gravar e continuar',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Gravar os dados e continuar a editar',
	'sf_autoedit_anoneditwarning' => 'Aviso: Não está autenticado. O seu endereço IP será gravado no histórico de edições da página.',
	'sf_autoedit_success' => 'A página [[$1]] foi modificada usando o formulário $2.',
	'sf_autoedit_notargetspecified' => 'Não foi especificada uma página de destino.',
	'sf_autoedit_noformfound' => 'Não foi especificado um formulário.',
	'sf_autoedit_toomanyformsfound' => 'Há mais do que um formulário disponível para a página.',
	'sf_autoedit_readonly' => 'Não são permitidas alterações da base de dados. Motivo: $1',
	'sf_autoedit_nosemanticform' => 'Não foi possível obter o formulário $2 para a página $1. Para mais detalhes, consulte [[{{#special:FormEdit}}/$2/$1]].',
	'sf-autoedit-wait' => 'Aguarde...',
	'runquery' => 'Executar consulta',
	'sf_runquery_badurl' => "Tem de especificar um nome de formulário na URL;
a URL deve ser parecida com 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'Executar consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta adicional',
	'sf_formerrors_header' => 'Houve erros nas entradas do seu formulário; veja abaixo',
	'sf_blank_error' => 'não pode estar em branco',
	'sf_bad_url_error' => "Tem de ter o formato de URL correcto, começando com 'http'",
	'sf_bad_email_error' => 'deverá introduzir um endereço de correio electrónico com formato válido',
	'sf_bad_number_error' => 'deverá introduzir um número válido',
	'sf_bad_date_error' => 'deverá introduzir uma data válida',
	'uploadwindow' => 'Janela de carregamento',
	'sf_deletionlog' => 'Registo de eliminações',
	'sf_property_isproperty' => 'Esta é uma propriedade do tipo $1.',
	'sf_property_linkstoform' => 'Liga às páginas que usam o formulário $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|O valor permitido para esta propriedade é|Os valores permitidos para esta propriedade são}}:',
	'sf_template_docu' => "Esta é a predefinição '$1'.
Ela deverá ser chamada no seguinte formato:",
	'sf_template_docufooter' => 'Edite a página para ver o texto da predefinição',
	'sf_form_docu' => 'Este é o formulário "$1".
Para criar uma página com este formulário, introduza o nome da página abaixo;
se já existir uma página com o mesmo nome, será reencaminhado para um formulário para editar essa página.',
	'sf_form_freetextlabel' => 'Texto livre',
	'sf_category_hasdefaultform' => 'Esta categoria usa o formulário $1.',
	'sf_category_desc' => 'Esta é a categoria $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Ver o separador "Editar" para páginas editáveis por formulário', # Fuzzy
	'right-editrestrictedfields' => 'Editar os campos restritos dos formulários',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Crazymadlover
 * @author Eduardo.mps
 * @author Enqd
 * @author Jaideraf
 * @author Leonardo Costa
 * @author Luckas Blade
 * @author Rafael Vargas
 * @author Teles
 * @author 555
 */
$messages['pt-br'] = array(
	'semanticforms-desc' => 'Formulários para adição e edição de dados semânticos',
	'specialpages-group-sf_group' => 'Formulários Semânticos',
	'createproperty' => 'Criar uma propriedade',
	'sf-createproperty-with-name' => 'Criar propriedade: $1',
	'sf_createproperty_linktoform' => 'Essa propriedade irá ligar às páginas que utilizam o formulário:',
	'sf_createproperty_allowedvalsinput' => 'Se pretende que esta propriedade apenas possa conter determinados valores, introduza a lista de valores permitidos, separados por vírgulas (se um valor contém uma vírgula, substitua-a por "\\,"):',
	'sf_createproperty_propname' => 'Nome da propriedade:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Predefinições',
	'sf_templates_docu' => 'Existem as seguintes predefinições neste wiki.',
	'sf_templates_definescat' => 'define categoria: $1',
	'createtemplate' => 'Criar uma predefinição',
	'sf-createtemplate-with-name' => 'Criar predefinição: $1',
	'sf_createtemplate_namelabel' => 'Nome da predefinição:',
	'sf_createtemplate_multipleinstance' => 'Essa predefinição pode ser incluída várias vezes na página.',
	'sf_createtemplate_categorylabel' => 'Categoria definida pela predefinição (opcional):',
	'sf_createtemplate_templatefields' => 'Campos da predefinição',
	'sf_createtemplate_fieldsdesc' => 'Para ter os campos nessa predefinição não é necessário nomear os campos, simplesmente entre com o número de cada campo (por exemplo, 1, 2, 3, etc.) ao invés de um nome real.',
	'sf_createtemplate_fieldname' => 'Nome do campo:',
	'sf_createtemplate_displaylabel' => 'Nome a ser exibido:',
	'sf_createtemplate_semanticproperty' => 'Propriedade semântica:',
	'sf_createtemplate_fieldislist' => 'Esse campo pode conter uma lista de valores separados por vírgulas',
	'sf_createtemplate_aggregation' => 'Agregação',
	'sf_createtemplate_aggregationdesc' => 'Para listar, em qualquer página usando essa predefinição, todas as páginas que tem uma determinada propriedade apontando para aquela página, especifique a propriedade apropriada abaixo:',
	'sf_createtemplate_aggregationlabel' => 'Título para a lista:',
	'sf_createtemplate_outputformat' => 'Formato de saída:',
	'sf_createtemplate_standardformat' => 'Tabela',
	'sf_createtemplate_infoboxformat' => 'Infobox lateral',
	'sf_createtemplate_plainformat' => 'Textos simples',
	'sf_createtemplate_sectionsformat' => 'Seções',
	'sf_createtemplate_addfield' => 'Adicionar campo',
	'sf_createtemplate_deletefield' => 'Deletar',
	'sf_createtemplate_addtemplatebeforesave' => 'Você precisa adicionar pelo menos uma predefinição para este formulário antes de poder salvá-lo.',
	'forms' => 'Formulários',
	'sf_forms_docu' => 'Existem os seguintes formulários neste wiki.',
	'sf_forminputs_mandatory' => 'Um valor é obrigatório para este campo',
	'sf_forminputs_restricted' => 'Somente administradores podem editar esse campo',
	'sf_forminputs_class' => 'O atributo HTML "class" para esse campo',
	'sf_forminputs_default' => 'O valor padrão para esse campo',
	'sf_forminputs_preload' => 'Uma página wiki cujo conteúdo será o valor padrão para esse campo',
	'sf_forminputs_property' => 'Uma propriedade semântica correspondente a esse campo',
	'sf_forminputs_size' => 'O tamanho desse campo de texto, em caracteres',
	'sf_forminputs_maxlength' => 'O comprimento máximo permitido para o texto desse campo',
	'sf_forminputs_placeholder' => 'Texto de ajuda que aparece no campo até que o usuário clique nele',
	'sf_forminputs_uploadable' => 'Coloca um link "Upload de arquivo" ao lado desse campo', # Fuzzy
	'sf_forminputs_defaultfilename' => 'O nome padrão do arquivo para os arquivos enviados',
	'sf_forminputs_rows' => 'O número de linhas desse campo',
	'sf_forminputs_cols' => 'O número de colunas desse campo',
	'sf_forminputs_autogrow' => 'Define que esse campo deve aumentar de tamanho se o texto exceder seu limite',
	'sf_forminputs_valuesfromproperty' => 'Uma propriedade cujos valores no wiki devem formar o conjunto de valores desse campo',
	'sf_forminputs_valuesfromcategory' => 'Uma categoria cujas páginas pertencentes devem formar o conjunto de valores desse campo',
	'sf_forminputs_valuesfromnamespace' => 'Um namespace cujas páginas pertencentes devem formar o conjunto de valores desse campo',
	'sf_forminputs_valuesfromconcept' => 'Uma página de "conceito" do Semantic MediaWiki cujas páginas pertencentes devem formar o conjunto de valores desse campo',
	'sf_forminputs_valuesfromurl' => 'Um URL que contém dados estruturados que devem formar o conjunto de valores desse campo',
	'sf_forminputs_values' => 'O conjunto de valores desse campo, separados por vírgulas',
	'sf_forminputs_list' => 'Marca que esse campo contém uma lista de valores',
	'sf_forminputs_delimiter' => 'O delimitador entre os valores do campo, se esse campo contém uma lista de valores',
	'sf_forminputs_remoteautocompletion' => 'Usar o autocompletar remoto',
	'sf_forminputs_existingvaluesonly' => 'Permitir somente valores já presentes na lista',
	'sf_forminputs_showonselect' => 'Elementos da página que só serão exibidos se certos valores forem selecionados (exemplo: "valor1=>div1;valor2=>div2")',
	'sf_forminputs_listboxsize' => 'A altura dessa caixa de listagem, em linhas',
	'sf_forminputs_includetimezone' => 'Incluir uma entrada para o fuso horário',
	'sf_forminputs_topcategory' => 'A categoria-mãe desse conjunto de categorias (obrigatório)',
	'sf_forminputs_hideroot' => 'Esconder a categoria-mãe',
	'sf_forminputs_depth' => 'O número de níveis de categorias a serem exibidas inicialmente',
	'sf_forminputs_height' => 'A altura desse campo, em pixels',
	'sf_forminputs_width' => 'A largura desse campo, em pixels',
	'createform' => 'Criar um formulário',
	'sf-createform-with-name' => 'Criar formulário: $1',
	'sf_createform_nameinput' => 'Nome do formulário',
	'sf_createform_nameinputdesc' => '(normalmente é dado ao formulário o mesmo nome que a sua predefinição principal):',
	'sf_createform_template' => 'Predefinição:',
	'sf_createform_templatelabelinput' => 'Título da predefinição (opcional):',
	'sf_createform_allowmultiple' => 'Permitir várias instâncias (ou zero) dessa predefinição na página criada',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Este campo define a propriedade $1, do tipo $2.',
	'sf_createform_fieldproplist' => 'Este campo define uma lista de elementos que tem a propriedade $1, do tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Este campo define a propriedade $1, de um tipo não especificado.',
	'sf_createform_inputtype' => 'Tipo de entrada:',
	'sf_createform_inputtypedefault' => '(padrão)',
	'sf_createform_formlabel' => 'Título do formulário:',
	'sf_createform_hidden' => 'Escondido',
	'sf_createform_removetemplate' => 'Remover predefinição',
	'sf_createform_addtemplate' => 'Adicionar predefinição:',
	'sf_createform_beforetemplate' => 'Predefinição anterior:',
	'sf_createform_atend' => 'No final',
	'sf_createform_add' => 'Adicionar',
	'sf_createform_choosefield' => 'Escolha um campo para adicionar',
	'createcategory' => 'Criar uma categoria',
	'sf-createcategory-with-name' => 'Criar categoria: $1',
	'sf_createcategory_name' => 'Nome da categoria:',
	'sf_createcategory_defaultform' => 'Formulário padrão:',
	'sf_createcategory_makesubcategory' => 'Faz desta categoria uma subcategoria de outra (opcional):',
	'createclass' => 'Criar uma classe',
	'sf_createclass_docu' => 'Introduza todos os dados aqui para criar as propriedades, predefinições, formulários e categorias para uma única classe. Para mais opções, utilize as páginas $1.',
	'sf_createclass_allowedvalues' => 'Valores permitidos:',
	'sf_createclass_listofvalues' => 'Lista de valores?',
	'sf_createclass_nameinput' => 'Nome do formulário:',
	'sf_createclass_missingvalues' => 'Nem todos os campos obrigatórios foram preenchidos.',
	'sf_createclass_success' => 'As propriedades, as predefinições, os formulários e as categorias serão criados.',
	'sf_createclass_create' => 'Criar',
	'formstart' => 'Adicionar página',
	'sf_formstart_badform' => 'Erro: nenhum formulário foi encontrado na página "$1".',
	'sf_formstart_badtitle' => 'Erro: "$1" é um título inválido para uma página.',
	'sf_formstart_docu' => "Entre com o nome da página a ser editada com o formulário '$1'.
Se esta página já existir, você será direcionado para o formulário de edição da página.
Do contrário, você será direcionado para a criação da página com o formulário.",
	'sf_formstart_noform_docu' => 'Entre com o nome da página e selecione o formulário com que a página será editada.
Se esta página já existir, você será direcionado para a edição da página com o formulário.
Do contrário, você será direcionado para adicionar a página com o formulário.',
	'sf_formstart_createoredit' => 'Criar ou editar',
	'formedit' => 'Editar com formulário',
	'sf_formedit_createtitle' => 'Criar $1: $2',
	'sf_formedit_createtitlenotarget' => 'Criar $1',
	'sf_formedit_badurl' => "Esta é a página para edição com um formulário. É necessário especificar na URL tanto um nome de formulário quanto uma página alvo;
isto é, o URL deve ficar parecido com 'Special:FormEdit?form=<form name>&target=<target page>' ou 'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'Você também pode adicionar está página com um dos seguintes formulários:',
	'sf_formedit_altformsonly' => 'Por favor, selecione um dos seguintes formulários para adicionar esta página:',
	'sf_formcreate' => 'Criar com formulário',
	'sf_viewform' => 'Ver formulário',
	'sf_editsource' => 'Editar fonte',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => "'''Aviso''': mais de um formulário padrão está definido para esta página.",
	'sf_formedit_formwarning' => 'Aviso: esta página <a href="$1">já existe</a>, mas não utiliza este formulário.',
	'sf_formedit_mismatchedbrackets' => 'Aviso: a página contém parêntesis, colchetes ou chaves sem fechamento, desse modo, a página não renderizará corretamente o formulário. Por favor, <a href="$1">corrija o erro no texto fonte</a> antes de continuar.',
	'sf_formedit_remove' => 'Remover',
	'sf_formedit_addanother' => 'Adicionar outro',
	'sf_formedit_none' => 'Nenhum',
	'sf_formedit_emptytitle' => 'Erro: os dados inseridos resultam num título de página em branco.',
	'sf_formedit_hookerror' => 'Erro: uma extensão do MediaWiki impediu a modificação da página de destino.',
	'sf_formedit_saveandcontinueediting' => 'Salvar e continuar',
	'sf_formedit_saveandcontinue_summary' => 'Salvo utilizando o botão "$1" do formulário',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Salvar os dados e continuar editando',
	'sf_autoedit_anoneditwarning' => 'Aviso: você não está autenticado. O seu endereço IP será gravado no histórico de edições da página.',
	'sf_autoedit_success' => 'A página [[$1]] foi modificada utilizando o formulário $2.',
	'sf_autoedit_fail' => 'A modificação de [[$1]] falhou.',
	'sf_autoedit_notargetspecified' => 'Nenhuma página de destino foi especificada.',
	'sf_autoedit_invalidtargetspecified' => 'A página de destino especificada $1 é inválida.',
	'sf_autoedit_invalidform' => '$1 não é um formulário válido.',
	'sf_autoedit_redirectlimitexeeded' => 'O limite máximo de redirecionamento para o formulário $1 foi excedido.',
	'sf_autoedit_invalidredirecttarget' => '$1 é um destino de redirecionamento inválido para formulário $2.',
	'sf_autoedit_invalidpreloadspecified' => 'A página especificada de preload $1 é inválida.',
	'sf_autoedit_redlinkexists' => '$1 já existe.',
	'sf_autoedit_noformfound' => 'Nenhum formulário foi especificado.',
	'sf_autoedit_toomanyformsfound' => 'Há mais de um formulário disponível para essa página.',
	'sf_autoedit_readonly' => 'Atualmente a base de dados não está permitindo modificações. Motivo: $1',
	'sf_autoedit_nosemanticform' => 'Não foi possível obter o formulário $2 para a página $1. Para mais detalhes, consulte a página [[{{#special:FormEdit}}/$2/$1]].',
	'sf_autoedit_summary' => 'Editado automaticamente a partir da página $1.',
	'sf-autoedit-wait' => 'Aguarde...',
	'runquery' => 'Pesquisar',
	'sf_runquery_badurl' => "Você deve especificar um nome de formulário na URL;
a URL deve se parecer com 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'Pesquisar: $1',
	'sf_runquery_additionalquery' => 'Consulta adicional',
	'sf_formerrors_header' => 'Houve erros com suas entradas do formulário; veja abaixo.',
	'sf_blank_error' => 'não pode ficar em branco',
	'sf_bad_url_error' => "precisa ter o formato correto da URL, começando com 'http'",
	'sf_bad_email_error' => 'precisa ter um formato válido de endereço de e-mail',
	'sf_bad_number_error' => 'precisa ser um número válido',
	'sf_bad_date_error' => 'precisa ser uma data válida',
	'uploadwindow' => 'Janela de upload',
	'sf_deletionlog' => 'Registro de eliminações',
	'sf-preview-header' => 'Previsão do formulário',
	'sf-preview-note' => 'Este será o aspecto do formulário quando ele estiver em uso:',
	'sf-pageschemas-pagenameformula' => 'Fórmula para a criação do nome da página:',
	'sf-pageschemas-createtitle' => 'Título do formulário para páginas novas:',
	'sf-pageschemas-edittitle' => 'Título do formulário para páginas existentes:',
	'sf-pageschemas-inputtype' => 'Tipo de entrada (deixe em branco para definir como padrão):',
	'sf_property_isproperty' => 'Esta é uma propriedade do tipo $1.',
	'sf_property_linkstoform' => 'Liga às páginas que utilizam o formulário $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|O valor permitido para essa propriedade é|Os valores permitidos para essa propriedade são}}:',
	'sf_template_docu' => "Esta é a predefinição '$1'.
Ela deve ser chamada no seguinte formato:",
	'sf_template_docufooter' => 'Edite a página para ver o texto da predefinição.',
	'sf_form_docu' => 'Este é o formulário "$1".
Para criar uma página com este formulário, insira o nome da página abaixo;
se já existir uma página com o mesmo nome, você será encaminhado a edição dessa página com o formulário.',
	'sf_form_freetextlabel' => 'Texto livre',
	'sf_category_hasdefaultform' => 'Esta categoria utiliza o formulário $1.',
	'sf_category_desc' => 'Esta é a categoria $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Ver a aba "Editar" para páginas editáveis por formulário', # Fuzzy
	'right-editrestrictedfields' => 'Editar campos restritos de formulários',
	'right-createclass' => 'Criar novas classes semânticas',
	'action-createclass' => 'criar novas classes semânticas',
	'action-editrestrictedfields' => 'editar campos restritos dos formulários',
	'action-viewedittab' => 'visualizar a aba "Editar" para páginas editáveis pelo formulário', # Fuzzy
);

/** Tarifit (Tarifit)
 * @author Jose77
 */
$messages['rif'] = array(
	'sf_createtemplate_deletefield' => 'Sfaḍ',
);

/** Romanian (română)
 * @author Firilacroco
 * @author KlaudiuMihaila
 * @author Mihai
 * @author Minisarm
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'semanticforms-desc' => 'Formulare pentru adăugarea sau modificarea datelor semantice',
	'specialpages-group-sf_group' => 'Formulare semantice',
	'createproperty' => 'Creează o proprietate',
	'sf-createproperty-with-name' => 'Creează proprietatea: $1',
	'sf_createproperty_propname' => 'Numele proprietății:',
	'sf_createproperty_proptype' => 'Tip:',
	'templates' => 'Formate',
	'sf_templates_docu' => 'Următoarele formate există în wiki.',
	'sf_templates_definescat' => 'definește o categorie: $1',
	'createtemplate' => 'Creează un format',
	'sf-createtemplate-with-name' => 'Creează formatul: $1',
	'sf_createtemplate_namelabel' => 'Numele formatului:',
	'sf_createtemplate_multipleinstance' => 'Acest format poate fi inclus de mai multe ori pe pagină.',
	'sf_createtemplate_categorylabel' => 'Categorie definită de către format (opțional):',
	'sf_createtemplate_templatefields' => 'Câmpurile formatului',
	'sf_createtemplate_fieldname' => 'Numele câmpului:',
	'sf_createtemplate_semanticproperty' => 'Proprietate semnatică:',
	'sf_createtemplate_aggregation' => 'Agregare',
	'sf_createtemplate_aggregationlabel' => 'Titlu pentru listă:',
	'sf_createtemplate_outputformat' => 'Format ieșire:',
	'sf_createtemplate_standardformat' => 'Tabel',
	'sf_createtemplate_infoboxformat' => 'Infobox lateral',
	'sf_createtemplate_plainformat' => 'Text simplu',
	'sf_createtemplate_sectionsformat' => 'Secțiuni',
	'sf_createtemplate_addfield' => 'Adaugă un câmp',
	'sf_createtemplate_deletefield' => 'Șterge',
	'forms' => 'Formular',
	'sf_forminputs_mandatory' => 'Obligatoriu',
	'sf_forminputs_restricted' => 'Doar administratorii pot modifica această intrare',
	'createform' => 'Creează un formular',
	'sf_createform_nameinput' => 'Numele formularului',
	'sf_createform_template' => 'Format:',
	'sf_createform_field' => 'Câmp:',
	'sf_createform_fieldprop' => 'Acest câmp definește proprietatea $1, de tipul $2.',
	'sf_createform_inputtype' => 'Tip intrare:',
	'sf_createform_inputtypedefault' => '(implicit)',
	'sf_createform_formlabel' => 'Eticheta formularului',
	'sf_createform_hidden' => 'Ascunse',
	'sf_createform_removetemplate' => 'Ştergeți formatul',
	'sf_createform_addtemplate' => 'Introduceți format:',
	'sf_createform_beforetemplate' => 'Înainte de format:',
	'sf_createform_atend' => 'La sfârșit',
	'sf_createform_add' => 'Adaugă',
	'sf_createform_choosefield' => 'Alegeți un câmp de introdus',
	'createcategory' => 'Creează o categorie',
	'sf_createcategory_name' => 'Numele categoriei:',
	'sf_createcategory_defaultform' => 'Formular inițial:',
	'createclass' => 'Creează o clasă',
	'sf_createclass_allowedvalues' => 'Valori permise:',
	'sf_createclass_listofvalues' => 'Listă de valori?',
	'sf_createclass_nameinput' => 'Numele formularului:',
	'sf_createclass_missingvalues' => 'Nu toate câmpurile necesare au fost completate.',
	'sf_createclass_create' => 'Creare',
	'formstart' => 'Adaugă o pagină cu un formular',
	'sf_formstart_badform' => 'Eroare: niciun formular nu a fost găsit pe pagina „$1”.',
	'sf_formstart_createoredit' => 'Creați sau modificați',
	'formedit' => 'Modificare cu formular',
	'sf_formedit_createtitle' => 'Creare $1: $2',
	'sf_formcreate' => 'Creare cu formular',
	'sf_viewform' => 'Vedeți formular',
	'sf_editsource' => 'Modificare sursă',
	'sf_formedit_edittitle' => 'Modificare $1: $2',
	'sf_formedit_remove' => 'Elimină',
	'sf_formedit_addanother' => 'Adăugați altul',
	'sf_formedit_none' => 'Nimic',
	'sf_formedit_saveandcontinueediting' => 'Salvează și continuă',
	'sf-autoedit-wait' => 'Așteptați...',
	'runquery' => 'Executare interogare',
	'sf_blank_error' => 'nu poate fi gol',
	'sf_bad_number_error' => 'trebuie să fie un număr corect',
	'sf_bad_date_error' => 'trebuie să fie o dată corectă',
	'uploadwindow' => 'Fereastra de încărcare',
	'sf_deletionlog' => 'Jurnalul ștergerilor',
	'sf_property_isproperty' => 'Aceasta este o proprietate de tipul $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Valoarea admisă pentru această proprietate este|Valorile admise pentru această proprietate sunt}}:',
	'sf_form_freetextlabel' => 'Text liber',
	'sf_category_desc' => 'Aceasta este categoria $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Vizualizează fila „Modificare” pentru paginile ce pot fi modificate printr-un formular', # Fuzzy
	'action-viewedittab' => 'vizualizați fila „Modificare” pentru paginile ce pot fi modificate printr-un formular', # Fuzzy
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'sf_createproperty_proptype' => 'Tipe:',
	'sf_createtemplate_fieldname' => "Nome d'u cambe:",
	'sf_createtemplate_displaylabel' => 'Etichette de visualizzazzione:',
	'sf_createtemplate_semanticproperty' => 'Probbietà semandeche:',
	'sf_createtemplate_aggregation' => 'Aggregazione:',
	'sf_createtemplate_aggregationlabel' => "Titole pe l'elenghe:",
	'sf_createtemplate_standardformat' => 'Tabbelle',
	'sf_createtemplate_plainformat' => 'Teste semblice',
	'sf_createtemplate_addfield' => "Aggiunge 'u cambe",
	'sf_createtemplate_deletefield' => 'Scangìlle',
	'forms' => 'Module',
	'createform' => "Ccreje 'nu module",
	'sf-createform-with-name' => "Ccreje 'u module: $1",
	'sf_createform_nameinput' => "Nome d'u module",
	'sf_createform_template' => 'Template:',
	'sf_createform_field' => 'Cambe:',
	'sf_createform_inputtype' => 'Tipe de input:',
	'sf_createform_inputtypedefault' => '(de base)',
	'sf_createform_hidden' => 'Scunnute',
	'sf_createform_removetemplate' => "Live 'u template",
	'sf_createform_addtemplate' => "Aggiunge 'u template:",
	'sf_createform_beforetemplate' => "Apprime d'u template:",
	'sf_createform_atend' => 'A fine',
	'sf_createform_add' => 'Aggiunge',
	'sf_createform_choosefield' => "Scacchie 'nu cambe da aggiungere",
	'createcategory' => "Ccreje 'na categorije",
	'sf-createcategory-with-name' => "Ccreje 'a categorije: $1",
	'sf_createcategory_name' => "Nome d'a categorije:",
	'sf_createclass_listofvalues' => 'Elenghe de valore?',
	'sf_createclass_nameinput' => "Nome d'u module:",
	'sf_createclass_create' => 'Ccreje',
	'formstart' => "Inizie d'u module",
	'sf_formstart_createoredit' => 'Ccreje o cange',
	'formedit' => "Cange cu 'u module",
	'sf_formedit_createtitle' => 'Ccreje $1: $2',
	'sf_formedit_createtitlenotarget' => 'Ccreje $1',
	'sf_formcreate' => "Ccreje cu 'u module",
	'sf_viewform' => "Vide 'u module",
	'sf_editsource' => "Cange 'a sorgende",
	'sf_formedit_edittitle' => 'Cange $1: $2',
	'sf_formedit_remove' => 'Live ste istanze',
	'sf_formedit_addanother' => "Aggiunge 'n'otre",
	'sf_formedit_none' => 'Ninde',
	'sf_formedit_saveandcontinueediting' => 'Reggìstre e condinue',
	'sf-autoedit-wait' => 'Aspitte...',
	'sf_blank_namespace' => 'Prengepàle',
);

/** Russian (русский)
 * @author Ferrer
 * @author Haffman
 * @author Innv
 * @author Kaganer
 * @author Lockal
 * @author Pastakhov
 * @author QuestPC
 * @author Vlsergey
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'semanticforms-desc' => 'Формы для добавления и правки семантических данных',
	'specialpages-group-sf_group' => 'Semantic Forms',
	'createproperty' => 'Создать свойство',
	'sf-createproperty-with-name' => 'Создать свойство: $1',
	'sf_createproperty_linktoform' => 'Это свойство содержит ссылку на страницы, которые используют форму:',
	'sf_createproperty_allowedvalsinput' => 'Если вы хотите, чтобы данное свойство могло содержать только определённые значения, введите через запятую список допустимых значений (если значение содержит запятую, то замените её на «\\,»):',
	'sf_createproperty_propname' => 'Имя свойства:',
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблоны',
	'sf_templates_docu' => 'Следующие шаблоны существуют в вики.',
	'sf_templates_definescat' => 'определяет категорию: $1',
	'createtemplate' => 'Создать шаблон',
	'sf-createtemplate-with-name' => 'Создать шаблон: $1',
	'sf_createtemplate_namelabel' => 'Имя шаблона:',
	'sf_createtemplate_multipleinstance' => 'Этот шаблон может быть включен несколько раз на странице.',
	'sf_createtemplate_categorylabel' => 'Категория, определяемая шаблоном (необязательно):',
	'sf_createtemplate_templatefields' => 'Поля шаблона',
	'sf_createtemplate_fieldsdesc' => 'Для указания полей шаблона не требуется указывать их имена, просто введите индекс каждого поля (например, 1, 2, 3 и т. д.) вместо фактического имени.',
	'sf_createtemplate_fieldname' => 'Имя поля:',
	'sf_createtemplate_displaylabel' => 'Отображаемая надпись:',
	'sf_createtemplate_semanticproperty' => 'Семантическое свойство:',
	'sf_createtemplate_fieldislist' => 'Это поле может содержать список разделённых запятыми значений',
	'sf_createtemplate_aggregation' => 'Соединение',
	'sf_createtemplate_aggregationdesc' => 'Чтобы вывести на любую страницу, использующую этот шаблон, все страницы, у которых заданное свойство указывает на эту страницу, укажите соответствующее свойство ниже:',
	'sf_createtemplate_aggregationlabel' => 'Заголовок списка:',
	'sf_createtemplate_outputformat' => 'Формат вывода:',
	'sf_createtemplate_standardformat' => 'Таблица',
	'sf_createtemplate_infoboxformat' => 'Сторона информационной панели',
	'sf_createtemplate_plainformat' => 'Обычный текст',
	'sf_createtemplate_sectionsformat' => 'Разделы',
	'sf_createtemplate_addfield' => 'Добавить поле',
	'sf_createtemplate_deletefield' => 'Удалить',
	'sf_createtemplate_addtemplatebeforesave' => 'Вы должны добавить на эту форму хотя бы один шаблон, чтобы её можно было сохранить.',
	'forms' => 'Формы',
	'sf_forms_docu' => 'В вики существуют следующие формы.',
	'sf_forminputs_mandatory' => 'Обязательное',
	'sf_forminputs_restricted' => 'Только администраторы могут изменять это поле',
	'sf_forminputs_class' => 'HTML-атрибут "class" для данного поля',
	'sf_forminputs_default' => 'Значение по умолчанию для этого поля',
	'sf_forminputs_preload' => 'Вики-страница, содержимое которой будет использовано как значение по умолчанию для этого поля',
	'sf_forminputs_property' => 'Семантическое свойство, которое соответствует этому полю',
	'sf_forminputs_size' => 'Размер этого текстового поля в символах',
	'sf_forminputs_maxlength' => 'Максимально допустимая длина текста в этом поле',
	'sf_forminputs_placeholder' => 'Справочный текст, который появляется в поле ввода до тех пор, пока пользователь не перейдет на него',
	'sf_forminputs_uploadable' => 'Отображает ссылку «Загрузить файл» рядом с этим полем', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Имя файла по умолчанию для загруженных файлов',
	'sf_forminputs_rows' => 'Размер поля в строках',
	'sf_forminputs_cols' => 'Размер поля в столбцах',
	'sf_forminputs_autogrow' => 'Позволяет полю увеличивать свой размер в соответствии с количеством текста',
	'sf_forminputs_valuesfromproperty' => 'Свойство, набор значений которого используется для подстановки в это поле ввода',
	'sf_forminputs_valuesfromcategory' => 'Категория, названия страниц которой используются для подстановки в это поле ввода',
	'sf_forminputs_valuesfromnamespace' => 'Пространство имен, названия страниц которой используются для подстановки в это поле ввода',
	'sf_forminputs_valuesfromconcept' => 'Страница Semantic MediaWiki "concept", набор значений которой используется для подстановки в это поле ввода',
	'sf_forminputs_valuesfromurl' => 'URL-адрес хранилища структурированных данных, которые используются для подстановки в это поле ввода',
	'sf_forminputs_values' => 'Набор значений для подстановки в это поле ввода, разделенных запятыми',
	'sf_forminputs_list' => 'Отметить это поле ввода, как содержащее список значений',
	'sf_forminputs_delimiter' => 'Разделитель между значениями, если это поле ввода содержит список значений',
	'sf_forminputs_remoteautocompletion' => 'Использовать внешние данные для автозаполнения',
	'sf_forminputs_existingvaluesonly' => 'Разрешить только значения из списка',
	'sf_forminputs_showonselect' => 'Элементы страницы которые отображаются только в том случае, если выбраны определенные значения (пример: "value1=>div1;value2=>div2)',
	'sf_forminputs_listboxsize' => 'Высота этого listbox, в строках',
	'sf_forminputs_includetimezone' => 'Отображать поле для ввода часового пояса',
	'sf_forminputs_topcategory' => 'Родительская категория этого набора категорий (обязательно)',
	'sf_forminputs_hideroot' => 'Скрыть родительскую категорию',
	'sf_forminputs_depth' => 'Количество уровней категорий для первоначального показа',
	'sf_forminputs_height' => 'Высота этого поля, в пикселях',
	'sf_forminputs_width' => 'Ширина этого поля, в пикселях',
	'createform' => 'Создать форму',
	'sf-createform-with-name' => 'Создать форму: $1',
	'sf_createform_nameinput' => 'Название формы',
	'sf_createform_nameinputdesc' => '(форме, как правило, присваивается такое же имя, как и у основного шаблона):',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_templatelabelinput' => 'Заголовок шаблона (необязательно):',
	'sf_createform_allowmultiple' => 'Разрешить несколько (или ноль) экземпляров этого шаблона на создаваемой странице',
	'sf_createform_field' => 'Поле:',
	'sf_createform_fieldprop' => 'Это поле определяет свойство $1, которое имеет тип $2.',
	'sf_createform_fieldproplist' => 'Это поле определяет список элементов, имеющих свойство $1 типа $2.',
	'sf_createform_fieldpropunknowntype' => 'Это поле определяет свойство $1 неуказанного типа.',
	'sf_createform_inputtype' => 'Тип поля:',
	'sf_createform_inputtypedefault' => '(по умолчанию)',
	'sf_createform_formlabel' => 'Метка поля:',
	'sf_createform_hidden' => 'скрытая',
	'sf_createform_removetemplate' => 'Удалить шаблон',
	'sf_createform_addtemplate' => 'Добавить шаблон:',
	'sf_createform_beforetemplate' => 'Перед шаблоном:',
	'sf_createform_atend' => 'В конце',
	'sf_createform_add' => 'Добавить',
	'sf_createform_choosefield' => 'Выберите поле для добавления',
	'createcategory' => 'Создать категорию',
	'sf-createcategory-with-name' => 'Создать категорию: $1',
	'sf_createcategory_name' => 'Название категории:',
	'sf_createcategory_defaultform' => 'Форма по умолчанию:',
	'sf_createcategory_makesubcategory' => 'Сделать это подкатегорией другой категории (необязательно):',
	'createclass' => 'Создать класс',
	'sf_createclass_docu' => 'Введите здесь все данные для создание свойств, шаблона, формы и категории для одного класса. Для более подробных настроек, используйте страницу $1.',
	'sf_createclass_allowedvalues' => 'Допустимые значения:',
	'sf_createclass_listofvalues' => 'Список значений?',
	'sf_createclass_nameinput' => 'Название формы:',
	'sf_createclass_missingvalues' => 'Не все требуемые поля были заполнены.',
	'sf_createclass_success' => 'Будут созданы настройки, шаблоны, формы и категории.',
	'sf_createclass_create' => 'Создать',
	'formstart' => 'Добавить страницу с формой',
	'sf_formstart_badform' => 'Ошибка. Форма не найдена на $1',
	'sf_formstart_badtitle' => 'Ошибка. «$1» — недопустимое название страницы.',
	'sf_formstart_docu' => 'Введите здесь название страницы, которую нужно править с помощью формы «$1». Если страница уже существует, вы будите направлены на форму редактирования страницы, иначе вы будите направлены на форму добавления страницы.',
	'sf_formstart_noform_docu' => 'Введите здесь название страницы и выберите форму, с помощью которой ей следует редактировать. Если эта страница уже существует, вы будите направлены на форму редактирования страницы, иначе вы будите направлены на форму добавления страницы.',
	'sf_formstart_createoredit' => 'Создать или править',
	'formedit' => 'Редактировать с помощью формы',
	'sf_formedit_createtitle' => 'Создание $1: $2',
	'sf_formedit_createtitlenotarget' => 'Создать $1',
	'sf_formedit_badurl' => 'Это страница редактирования с помощью формы. Необходимо указать как имя формы, так и целевую страницу в URL;
это должно выглядеть как "Special:FormEdit?form=<form name>&target=<target page>", или  "Special:FormEdit/<form name>/<target page>".',
	'sf_formedit_altforms' => 'Вы можете вместо этого добавить эту страницу с помощью одной из следующих форм:',
	'sf_formedit_altformsonly' => 'Пожалуйста, выберите одну из следующих форм для добавления этой страницы:',
	'sf_formcreate' => 'Создать с формой',
	'sf_viewform' => 'Смотреть форму',
	'sf_editsource' => 'Править исходники',
	'sf_formedit_edittitle' => 'Редактирование $1: $2',
	'sf_formedit_morethanoneform' => 'Внимание. Для этой страницы была определена больше чем одна форма по умолчанию.',
	'sf_formedit_formwarning' => 'Предупреждение. Эта страница <a href="$1">уже существует</a>, но не использует эту форму.',
	'sf_formedit_remove' => 'Удалить',
	'sf_formedit_addanother' => 'Добавить ещё',
	'sf_formedit_none' => 'Ничего',
	'sf_formedit_saveandcontinueediting' => 'Сохранить и продолжить',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Сохранить и продолжить редактирование',
	'sf_autoedit_anoneditwarning' => "'''Внимание!''' Вы не авторизовались на сайте. В истории изменений этой страницы будет записан ваш IP-адрес.",
	'sf_autoedit_success' => 'Успешно изменено [[$1]] с помощью формы $2 .',
	'sf_autoedit_fail' => 'Изменение [[$1]] не удалось.',
	'sf_autoedit_notargetspecified' => 'Целевая страница не указана.',
	'sf_autoedit_invalidtargetspecified' => 'Указанная целевая страница $1 недействительна.',
	'sf_autoedit_invalidform' => '$1 не является допустимой формой.',
	'sf_autoedit_redirectlimitexeeded' => 'Превышен максимальный предел перенаправлений для формы  $1.',
	'sf_autoedit_redlinkexists' => '$1 уже существует.',
	'sf_autoedit_noformfound' => 'Форма не определена.',
	'sf_autoedit_toomanyformsfound' => 'Для страницы определено несколько форм.',
	'sf_autoedit_readonly' => 'В настоящее время база данных заблокирована для изменений. Причина:$1',
	'sf-autoedit-wait' => 'Подождите...',
	'runquery' => 'Запустить запрос',
	'sf_runquery_badurl' => 'Вы должны определить имя формы в URL;
URL должен выглядеть так: «Special:RunQuery/<form name>».',
	'sf_runquery_title' => 'Запустить запрос: $1',
	'sf_runquery_additionalquery' => 'Дополнительные запросы',
	'sf_formerrors_header' => 'Были обнаружены ошибки в вашей форме ввода, см. ниже',
	'sf_blank_error' => 'не может быть пустым',
	'sf_bad_url_error' => 'должно иметь правильный URL-формат, начинаться с «http»',
	'sf_bad_email_error' => 'должно содержать адрес почты соответствующего формата',
	'sf_bad_number_error' => 'должно быть числом',
	'sf_bad_date_error' => 'должно быть датой',
	'uploadwindow' => 'Окно загрузки',
	'sf_deletionlog' => 'Журнал удалений',
	'sf-preview-header' => 'Предварительный просмотр формы',
	'sf-pageschemas-pagenameformula' => 'Формула названия страницы:',
	'sf-pageschemas-createtitle' => 'Название формы для новых страниц:',
	'sf-pageschemas-edittitle' => 'Название формы для уже существующих страниц:',
	'sf-pageschemas-inputtype' => 'Тип входных данных (оставьте пустым, чтобы использовать значение по умолчанию):',
	'sf_property_isproperty' => 'Это свойство типа $1.',
	'sf_property_linkstoform' => 'Ссылки на страницы, использующие форму $1.',
	'sf_property_allowedvals' => 'Для данного свойства {{PLURAL:$1|допускается следующее значение|допускаются следующие значения}}:',
	'sf_template_docu' => 'Это шаблон «$1». Он должен вызываться следующим образом:',
	'sf_template_docufooter' => 'Начните редактировать эту страницу, чтобы увидеть текст шаблона.',
	'sf_form_docu' => 'Это форма «$1».
Чтобы создать страницу с помощью этой формы, введите ниже название страницы;
если страница с таким именем уже существует, вы будете направлены на форму редактирования этой страницы.',
	'sf_form_freetextlabel' => 'Текст',
	'sf_category_hasdefaultform' => 'Эта категория использует форму $1.',
	'sf_category_desc' => 'Это категория $1.',
	'sf_blank_namespace' => 'Основное',
	'right-viewedittab' => 'Вкладка "{{int:edit}}" для страниц, редактируемых формой',
	'right-editrestrictedfields' => 'правка защищённых полей формы',
	'right-createclass' => 'Создавать новые семантические классы',
	'action-createclass' => 'создать новый семантический класс',
	'action-editrestrictedfields' => 'правка защищённых полей формы',
	'action-viewedittab' => 'Вкладка "{{int:edit}}" для страниц, редактируемых формой',
);

/** Rusyn (русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'sf_createproperty_proptype' => 'Тіп:',
	'templates' => 'Шаблоны',
	'sf_createtemplate_deletefield' => 'Вымазати',
	'sf_createform_add' => 'Придати',
	'createcategory' => 'Створити катеґорію',
	'sf_createcategory_name' => 'Мено катеґорії:',
);

/** Sanskrit (संस्कृतम्)
 * @author Hemant wikikosh1
 * @author Mahitgar
 */
$messages['sa'] = array(
	'sf_blank_namespace' => 'प्रमुखम्',
);

/** Sinhala (සිංහල)
 * @author Singhalawap
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'specialpages-group-sf_group' => 'අර්ථ විචාර ආකෘතිපත්‍ර',
	'createproperty' => 'අයිතියක් තනන්න',
	'sf-createproperty-with-name' => 'අයිතිය තනන්න: $1',
	'sf_createproperty_propname' => 'ගුණ නාමය:',
	'sf_createproperty_proptype' => 'වර්ගය:',
	'templates' => 'සැකිලි',
	'sf_templates_docu' => 'පහත සැකිලි විකියේ පවතී.',
	'sf_templates_definescat' => 'ප්‍රවර්ගය අර්ථ දැක්වේ: $1',
	'createtemplate' => 'සැකිල්ලක් තනන්න',
	'sf-createtemplate-with-name' => 'සැකිල්ල තනන්න: $1',
	'sf_createtemplate_namelabel' => 'සැකිලි නාමය:',
	'sf_createtemplate_categorylabel' => 'සැකිල්ල විසින් නිර්වචනය කරන ප්‍රවර්ගය (අමතර):',
	'sf_createtemplate_templatefields' => 'සැකිලි ක්ෂේත්‍ර',
	'sf_createtemplate_fieldname' => 'ක්ෂේත්‍ර නාමය:',
	'sf_createtemplate_displaylabel' => 'ලේබලය පෙන්වන්න:',
	'sf_createtemplate_semanticproperty' => 'අර්ථ විචාර ගුණය:',
	'sf_createtemplate_aggregation' => 'සමූහනය',
	'sf_createtemplate_aggregationlabel' => 'ලැයිස්තුව සඳහා මාතෘකාව:',
	'sf_createtemplate_outputformat' => 'ප්‍රතිදාන ආකෘතිය:',
	'sf_createtemplate_standardformat' => 'වගුව',
	'sf_createtemplate_infoboxformat' => 'පැති තොරතුරුකොටුව',
	'sf_createtemplate_plainformat' => 'සාමාන්‍ය පෙළ',
	'sf_createtemplate_sectionsformat' => 'කොටස්',
	'sf_createtemplate_addfield' => 'ක්ෂේත්‍රය එක් කරන්න',
	'sf_createtemplate_deletefield' => 'මකන්න',
	'forms' => 'ෆෝරම',
	'sf_forms_docu' => 'පහත ෆොරමයන් විකියේ පවතී.',
	'sf_forminputs_mandatory' => 'මෙම ආදානය සඳහා අගයක් යෙදිය යුතු වේ',
	'sf_forminputs_default' => 'මෙම ආදානය සඳහා සාමාන්‍ය අගය',
	'sf_forminputs_rows' => 'මෙම ආදානය සඳහා පේළි ගණන',
	'sf_forminputs_cols' => 'මෙම ආදානය සඳහා තීර ගණන',
	'sf_forminputs_remoteautocompletion' => 'දුරස්ථ ස්වයංසම්පූර්ණවීම භාවිතා කරන්න',
	'sf_forminputs_existingvaluesonly' => 'දැනටමත් ලයිස්තුවේ තිබෙන අගයන්වලට පමණක් ඉඩ දේ',
	'sf_forminputs_hideroot' => 'මාපිය ප්‍රවර්ගය සඟවන්න',
	'sf_forminputs_height' => 'මෙම ආදානයේ උස, පික්සල් වලින්',
	'sf_forminputs_width' => 'මෙම ආදානයේ පළල, පික්සල් වලින්',
	'createform' => 'ෆෝරමයක් තනන්න',
	'sf-createform-with-name' => 'ෆෝරමය තනන්න: $1',
	'sf_createform_nameinput' => 'ෆෝරමයේ නම',
	'sf_createform_template' => 'සැකිල්ල',
	'sf_createform_templatelabelinput' => 'සැකිලි ලේබලය (වෛකල්පික):',
	'sf_createform_field' => 'ක්ෂේත්‍රය:',
	'sf_createform_inputtype' => 'ආදාන වර්ගය:',
	'sf_createform_inputtypedefault' => '(සාමාන්‍ය)',
	'sf_createform_formlabel' => 'ෆෝරමයේ ලේබලය:',
	'sf_createform_hidden' => 'සඟවනලද',
	'sf_createform_removetemplate' => 'සැකිල්ල ඉවත් කරන්න',
	'sf_createform_addtemplate' => 'සැකිල්ල එක් කරන්න:',
	'sf_createform_beforetemplate' => 'සැකිල්ලට පෙර:',
	'sf_createform_atend' => 'අවසානයේදී',
	'sf_createform_add' => 'එක් කරන්න',
	'sf_createform_choosefield' => 'එක් කිරීමට ක්ෂේත්‍රයක් තෝරාගන්න',
	'createcategory' => 'ප්‍රවර්ගයක් තනන්න',
	'sf-createcategory-with-name' => 'ප්‍රවර්ගය තනන්න: $1',
	'sf_createcategory_name' => 'ප්‍රවර්ග නාමය:',
	'sf_createcategory_defaultform' => 'සාමාන්‍ය ෆෝරමය:',
	'createclass' => 'වර්ගයක් තනන්න',
	'sf_createclass_allowedvalues' => 'ඉඩදෙන අගයන්:',
	'sf_createclass_listofvalues' => 'අගයන්වල ලැයිස්තුවක්?',
	'sf_createclass_nameinput' => 'ෆෝරමයේ නම:',
	'sf_createclass_missingvalues' => 'අවශ්‍ය ක්ෂේත්‍රයන් සියල්ලක්ම පුරවා නොමැත.',
	'sf_createclass_create' => 'තනන්න',
	'formstart' => 'ෆෝරමයේ ඇරඹුම',
	'sf_formstart_badform' => 'දෝෂය: "$1" පිටුවේ ෆෝරම කිසිවක් හමු නොවුනි.',
	'sf_formstart_badtitle' => 'දෝෂය: "$1" යනු වලංගු නොවන පිටු ශීර්ෂයකි.',
	'sf_formstart_createoredit' => 'තනන්න හෝ සංස්කරණය කරන්න',
	'formedit' => 'ෆෝරමය සමඟ සංස්කරණය කරන්න',
	'sf_formedit_createtitle' => 'තනන්න $1: $2',
	'sf_formedit_createtitlenotarget' => '$1 තනන්න',
	'sf_formcreate' => 'ෆෝරමය සමඟ තනන්න',
	'sf_viewform' => 'ෆෝරමය නරඹන්න',
	'sf_editsource' => 'මූලාශ්‍රය සංස්කරණය කරන්න',
	'sf_formedit_edittitle' => 'සංස්කරණය $1: $2',
	'sf_formedit_remove' => 'ඉවත් කරන්න',
	'sf_formedit_addanother' => 'අනෙකක් එක් කරන්න',
	'sf_formedit_none' => 'කිසිවක් නොමැත',
	'sf_formedit_saveandcontinueediting' => 'සුරකිමින් ඉදිරියට යන්න',
	'sf_formedit_saveandcontinue_summary' => 'ආකෘතිපත්‍රයේ "$1" බොත්තම භාවිතා කරමින් සුරකින ලදී',
	'sf_formedit_tooltip_saveandcontinueediting' => 'දත්ත සුරක්ෂිත කර සංස්කරණය කරගෙන යන්න',
	'sf_autoedit_fail' => '[[$1]] වෙනස් කිරීම අසාර්ථකයි.',
	'sf_autoedit_notargetspecified' => 'ඉලක්කගත පිටුවක් විශේෂණය කර නොමැත.',
	'sf_autoedit_invalidtargetspecified' => 'විශේෂණය කෙරූ ඉලක්කගත පිටුව $1 වලංගු නොවේ.',
	'sf_autoedit_invalidform' => '$1 යනු වලංගු ෆෝරමයක් නොවේ.',
	'sf_autoedit_invalidpreloadspecified' => 'විශේෂණය කරන ලද $1 පූර්වපැටවුම් පිටුව වලංගු නොවේ.',
	'sf_autoedit_redlinkexists' => '$1 දැනටමත් පවති.',
	'sf_autoedit_noformfound' => 'කිසිදු ෆෝරමයක් විශේෂණය කර නොමැත.',
	'sf_autoedit_toomanyformsfound' => 'පිටුව සඳහා ආකෘතිපත්‍ර එකකට වඩා ලබා ගත හැක.',
	'sf_autoedit_summary' => '$1 පිටුවෙන් ස්වයංක්‍රියව සංස්කරණය වුණි.',
	'sf-autoedit-wait' => 'රැදෙන්න...',
	'runquery' => 'ප්‍රශ්නය දුවවන්න',
	'sf_runquery_title' => 'ප්‍රශ්නය දුවවන්න: $1',
	'sf_runquery_additionalquery' => 'අමතර ප්‍රශ්නය',
	'sf_blank_error' => 'හිස් නොවිය යුතුය',
	'sf_bad_email_error' => 'වලංගු විද්‍යුත් තැපැල් ආකෘතියක් විය යුතුය',
	'sf_bad_number_error' => 'වලංගු අංකයක් විය යුතුය',
	'sf_bad_date_error' => 'වලංගු දිනයක් විය යුතුය',
	'uploadwindow' => 'උඩුගත කිරීම් කවුළුව',
	'sf_deletionlog' => 'මකාදැමුම් ලොග් සටහන',
	'sf-preview-header' => 'ෆෝරමයේ පෙරදසුන',
	'sf-pageschemas-pagenameformula' => 'පිටු නාම රීතිය:',
	'sf-pageschemas-createtitle' => 'නව පිටු සඳහා ආකෘතිපත්‍රයේ ශීර්ෂය:',
	'sf-pageschemas-edittitle' => 'පවත්නා පිටු සඳහා ආකෘතිපත්‍රයේ ශීර්ෂය:',
	'sf-pageschemas-inputtype' => 'ආදාන වර්ගය (පෙරනිමියට සැකසීමට හිස්ව තබන්න):',
	'sf_property_isproperty' => 'මෙය $1 වර්ගයේ වත්කමකි.',
	'sf_template_docufooter' => 'සැකිලි පාඨය නැරඹීම සඳහා පිටුව සංස්කරණය කරන්න.',
	'sf_form_freetextlabel' => 'නිදහස් පාඨය',
	'sf_category_hasdefaultform' => 'මෙම ප්‍රවර්ගය $1 ආකෘතිපත්‍රය භාවිතා කරයි.',
	'sf_category_desc' => 'මෙය $1 ප්‍රවර්ගයයි.',
	'sf_blank_namespace' => 'ප්‍රධාන',
	'right-editrestrictedfields' => 'සීමිත ආකෘතිපත්‍ර ක්ෂේත්‍ර සංස්කරණය කරන්න',
	'right-createclass' => 'නව අර්ථ විචාර සමූහ තනන්න',
	'action-createclass' => 'නව අර්ථ විචාර සමූහ තනන්න',
	'action-editrestrictedfields' => 'සීමිත ආකෘතිපත්‍ර ක්ෂේත්‍ර සංස්කරණය කරන්න',
);

/** Slovak (slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'semanticforms-desc' => 'Formuláre na pridávanie a úpravu sémantických údajov',
	'specialpages-group-sf_group' => 'Sémantické formuláre',
	'createproperty' => 'Vytvoriť vlastnosť',
	'sf_createproperty_linktoform' => 'Táto vlastnosť bude odkazovať na stránky, ktoré používajú formulár:',
	'sf_createproperty_allowedvalsinput' => 'Ak chcete povoliť tejto vlastnosti nadobúdať iba určité hodnoty, zadajte zoznam povolených hodnôt oddelených čiarkami (ak hodnota obsahuje čiarku, nahraďte ju „\\,“)',
	'sf_createproperty_propname' => 'Názov vlastnosti:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Šablóny',
	'sf_templates_docu' => 'Na wiki existujú nasledujúce šablóny.',
	'sf_templates_definescat' => 'definuje kategóriu: $1',
	'createtemplate' => 'Vytvoriť šablónu',
	'sf_createtemplate_namelabel' => 'Názov šablóny:',
	'sf_createtemplate_categorylabel' => 'Kategória definovaná šablónou (nepovinné):',
	'sf_createtemplate_templatefields' => 'Polia šablóny',
	'sf_createtemplate_fieldsdesc' => 'Aby už polia tejto šablóny nevyžadovali názvy polí, jednoducho zadajte ako názov index každého poľa (napr. 1, 2, 3 atď.) namiesto skutočného názvu.',
	'sf_createtemplate_fieldname' => 'Názov poľa:',
	'sf_createtemplate_displaylabel' => 'Zobrazovať označenie:',
	'sf_createtemplate_semanticproperty' => 'Sémantická vlastnosť:',
	'sf_createtemplate_fieldislist' => 'Toto pole môže uchovávať zoznam hodnôt oddelených čiarkami',
	'sf_createtemplate_aggregation' => 'Agregácia',
	'sf_createtemplate_aggregationdesc' => 'Na vypísanie všetkých stránok, ktorých určená vlastnosť odkazuje na danú stránku (na akejkoľvek stránke používajúcej túto šablónu), zadajte príslušnú vlastnosť:',
	'sf_createtemplate_aggregationlabel' => 'Názov zoznamu:',
	'sf_createtemplate_outputformat' => 'Výstupný formát:',
	'sf_createtemplate_standardformat' => 'Štandardný', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'Infobox na pravej strane', # Fuzzy
	'sf_createtemplate_addfield' => 'Pridať pole',
	'sf_createtemplate_deletefield' => 'Zmazať',
	'sf_createtemplate_addtemplatebeforesave' => 'Predtým, než budete môcť uložiť tento formulár mu musíte pridať aspoň jednu šablónu.',
	'forms' => 'Formuláre',
	'sf_forms_docu' => 'Na wiki existujú nasledové formuláre.',
	'sf_forminputs_mandatory' => 'Povinné',
	'sf_forminputs_restricted' => 'Obmedzené (môžu meniť iba správcovia)', # Fuzzy
	'createform' => 'Vytvoriť formulár',
	'sf_createform_nameinput' => 'Názov formulára',
	'sf_createform_nameinputdesc' => '(je zvykom pomenovať formulár podľa hlavnej šablóny, ktorú plní):', # Fuzzy
	'sf_createform_template' => 'Šablóna:',
	'sf_createform_templatelabelinput' => 'Označenie šablóny (nepovinné):',
	'sf_createform_allowmultiple' => 'Povoliť vo vytvorenej stránke viacero (alebo nula) inštancií tejto šablóny',
	'sf_createform_field' => 'Pole:',
	'sf_createform_fieldprop' => 'Toto pole definuje vlastnosť $1 typu $2.',
	'sf_createform_fieldproplist' => 'Toto pole definuje zoznam prvkov, ktoré majú vlastnosť $1 typu $2.',
	'sf_createform_fieldpropunknowntype' => 'Toto pole definuje vlastnosť $1 neuvedeného typu.',
	'sf_createform_inputtype' => 'Typ vstupu:',
	'sf_createform_inputtypedefault' => '(štandard)',
	'sf_createform_formlabel' => 'Označenie formulára:',
	'sf_createform_hidden' => 'Skrytý',
	'sf_createform_removetemplate' => 'Odstrániť šablónu',
	'sf_createform_addtemplate' => 'Pridať šablónu:',
	'sf_createform_beforetemplate' => 'Pred šablónou:',
	'sf_createform_atend' => 'Na konci',
	'sf_createform_add' => 'Pridať',
	'sf_createform_choosefield' => 'Zvoľte, ktoré pole pridať',
	'createcategory' => 'Vytvoriť kategóriu',
	'sf_createcategory_name' => 'Názov kategórie:',
	'sf_createcategory_defaultform' => 'Štandardný formulár:',
	'sf_createcategory_makesubcategory' => 'Táto kategória je podkategóriou inej kategórie (nepovinné):',
	'createclass' => 'Vytvoriť triedu',
	'sf_createclass_docu' => 'Sem zadajte všetky údaje na vytvorenie vlastností, šablóny, formulára a kategórie jednej triedy. Ak chcete zadať ďalšie voľby, použite stránku $1.',
	'sf_createclass_allowedvalues' => 'Povolené hodnoty', # Fuzzy
	'sf_createclass_listofvalues' => 'Zoznam hodnôt', # Fuzzy
	'sf_createclass_missingvalues' => 'Neboli vyplnené všetky požadované polia.',
	'sf_createclass_success' => 'Vytvoria sa vlastnosti, šablóna, formulár a kategória.',
	'formstart' => 'Pridať stránku s formulárom',
	'sf_formstart_badform' => 'Chyba: na $1 nebola nájdená žiadna stránka formulára',
	'sf_formstart_badtitle' => 'Chyba: „$1“ nie je platný názov stránky.',
	'sf_formstart_docu' => 'Sem zadajte názov stránky, ktorá sa má upravovať formulárom „$1“. Ak táto stránka už existuje, budete presmerovaný na formulár pre úpravu tejto stránky. Inak budete presmerovaný na formulár pre pridanie tejto stránky.',
	'sf_formstart_noform_docu' => 'Sem zadajte názov stránky a vyberte, ktorým formulárom sa má upravovať. Ak táto stránka už existuje, budete presmerovaný na formulár pre úpravu tejto stránky. Inak budete presmerovaný na formulár pre pridanie tejto stránky.',
	'sf_formstart_createoredit' => 'Pridať alebo upraviť', # Fuzzy
	'formedit' => 'Upraviť pomocou formulára',
	'sf_formedit_createtitle' => 'Pridať $1: $2', # Fuzzy
	'sf_formedit_badurl' => 'Toto je stránka na pridávanie údajov. Musíte v URL uviesť názov formulára aj cieľovú stránku. Mala by byť v tvare „Special:FormEdit?form=<názov formulára>&target=<cieľová stránka>“ alebo „Special:FormEdit/<názov formulára>/<cieľová stránka>“.',
	'sf_formedit_altforms' => 'Namiesto toho môžete pridať túto stránku jedným z nasledovných formulárov:',
	'sf_formedit_altformsonly' => 'Prosím, vyberte jeden z nasledovných formulárov, ktorým sa pridá táto stránka.',
	'sf_formcreate' => 'Vytvoriť s formulárom',
	'sf_viewform' => 'Zobraziť formulár',
	'sf_editsource' => 'Upraviť zdroj',
	'sf_formedit_edittitle' => 'Upraviť $1: $2',
	'sf_formedit_morethanoneform' => 'Upozornenie: Táto stránka má definovaný viac ako jeden štandardný formulár.',
	'sf_formedit_formwarning' => 'Upozornenie: Táto stránka <a href="$1">už existuje</a>, ale nepoužíva tento formulár.',
	'sf_formedit_remove' => 'Odstrániť',
	'sf_formedit_addanother' => 'Pridať ďalšiu',
	'sf_formedit_none' => 'Žiadne',
	'runquery' => 'Spustiť požiadavku',
	'sf_runquery_badurl' => 'Musíte v URL uviesť názov formulára;
URL by malo byť v tvare „Special:RunQuery/<názov formulára>“',
	'sf_runquery_title' => 'Spustiť požiadavku: $1',
	'sf_runquery_additionalquery' => 'Ďalšia požiadavka',
	'sf_formerrors_header' => 'Zaslanie formulára, ktorý ste vyplnili, spôsobilo nasledovné chyby:',
	'sf_blank_error' => 'nemôže byť nevyplnené',
	'sf_bad_url_error' => 'musí mať správny formát URL, začínajúci „http“',
	'sf_bad_email_error' => 'musí mať správny formát emailovej adresy',
	'sf_bad_number_error' => 'musí byť platné číslo',
	'sf_bad_date_error' => 'musí byť platný dátum',
	'uploadwindow' => 'Okno nahrávania',
	'sf_deletionlog' => 'Záznam mazaní',
	'sf_property_isproperty' => 'Toto je vlastnosť typu $1.',
	'sf_property_linkstoform' => 'Odkazuje na stránky používajúce formulár $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Povolená hodnota|Povolené hodnoty}} tejto vlastnosti {{PLURAL:$1|je|sú}}:',
	'sf_template_docu' => 'Toto je šablóna „$1“. Mala by byť volaná v nasledovnom tvare:',
	'sf_template_docufooter' => 'Text šablóny uvidíte, keď začnete upravovať stránku.',
	'sf_form_docu' => 'Toto je formulár „$1“. Novú stránku pomocou tohto formulára pridáte zadaním názvu stránky dolu; ak stránka s takým názvom už existuje, budete presmerovaný na formulár pre úpravu tejto stránky.', # Fuzzy
	'sf_form_freetextlabel' => 'Voľný text',
	'sf_category_hasdefaultform' => 'Táto kategória používa formulár $1.',
	'sf_category_desc' => 'Toto je kategória $1.',
	'sf_blank_namespace' => 'Hlavná',
	'right-viewedittab' => 'Zobraziť zíložku „Upraviť“ na stránkach, ktoré možno upraviť pomocou formulára', # Fuzzy
	'right-editrestrictedfields' => 'Upraviť polia formulára s obmedzeným prístupom',
);

/** Slovenian (slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'sf_createform_add' => 'Dodaj',
	'formedit' => 'Uredi z obrazcem',
	'right-viewedittab' => 'Ogled zavihka »Uredi« za strani, ki se urejajo prek obrazca', # Fuzzy
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 * @author Sasa Stefanovic
 * @author Жељко Тодоровић
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'specialpages-group-sf_group' => 'Семантички обрасци',
	'createproperty' => 'Направи особину',
	'sf_createproperty_linktoform' => 'Ова особина ће повезивати на стране, које користе форму:',
	'sf_createproperty_allowedvalsinput' => 'Ако желите да овој особини буде дозвољено да има само одређене вредности, унесите списак дозвољених вредност, одвојених зарезима (ако вредност садржи зарез, пишите га као „\\,“):',
	'sf_createproperty_propname' => 'Име особине:',
	'sf_createproperty_proptype' => 'Врста:',
	'templates' => 'Шаблони',
	'sf_templates_docu' => 'Следећи шаблони постоје у Викију.',
	'sf_templates_definescat' => 'дефинише категорију: $1',
	'createtemplate' => 'Направи шаблон',
	'sf_createtemplate_namelabel' => 'Име шаблона:',
	'sf_createtemplate_categorylabel' => 'Категорија дефинисана шаблоном (опционо):',
	'sf_createtemplate_templatefields' => 'Поља шаблона',
	'sf_createtemplate_fieldname' => 'Име поља:',
	'sf_createtemplate_displaylabel' => 'Натпис за приказ:',
	'sf_createtemplate_semanticproperty' => 'Семантичко својство:',
	'sf_createtemplate_fieldislist' => 'Ово поље може да садржи списак вредности, одвојених зарезима',
	'sf_createtemplate_aggregation' => 'Агрегација',
	'sf_createtemplate_aggregationlabel' => 'Наслов листе:',
	'sf_createtemplate_outputformat' => 'Излазни формат:',
	'sf_createtemplate_standardformat' => 'Стандард', # Fuzzy
	'sf_createtemplate_addfield' => 'Додај поље',
	'sf_createtemplate_deletefield' => 'Обриши',
	'forms' => 'Форме',
	'sf_forms_docu' => 'Следеће форме постоје на Викију.',
	'createform' => 'Направи форму',
	'sf_createform_nameinput' => 'Име форме',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_field' => 'Поље:',
	'sf_createform_fieldprop' => 'Ово поље дефинише особину $1, типа $2.',
	'sf_createform_inputtype' => 'Врста уноса:',
	'sf_createform_inputtypedefault' => '(подразумевано)',
	'sf_createform_formlabel' => 'Из лабеле:',
	'sf_createform_hidden' => 'Сакривено',
	'sf_createform_removetemplate' => 'Обриши шаблон',
	'sf_createform_addtemplate' => 'Додај шаблон:',
	'sf_createform_beforetemplate' => 'Пре шаблона:',
	'sf_createform_atend' => 'На крају',
	'sf_createform_add' => 'Додај',
	'sf_createform_choosefield' => 'Изабери поље за додавање',
	'createcategory' => 'Направи категорију',
	'sf_createcategory_name' => 'Име категорије:',
	'sf_createcategory_defaultform' => 'Подразумевана форма:',
	'createclass' => 'Направи класу',
	'sf_createclass_allowedvalues' => 'Дозвољене вредности:',
	'sf_createclass_listofvalues' => 'Списак вредности?',
	'formstart' => 'Почетак форме',
	'sf_formstart_createoredit' => 'Направи или измени',
	'formedit' => 'Измени формом',
	'sf_formedit_createtitle' => 'Направи $1: $2',
	'sf_editsource' => 'Уреди извор',
	'sf_formedit_edittitle' => 'Измени $1: $2',
	'sf_formedit_remove' => 'Уклони',
	'sf_formedit_none' => 'Нема',
	'sf_bad_number_error' => 'мора бити исправан број',
	'sf_bad_date_error' => 'мора бити исправан датум',
	'uploadwindow' => 'Прозор за слање',
	'sf_deletionlog' => 'Историја брисања',
	'sf_form_freetextlabel' => 'Слободан текст',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 * @author Michaello
 * @author Rancher
 * @author Жељко Тодоровић
 */
$messages['sr-el'] = array(
	'specialpages-group-sf_group' => 'Semantički obrasci',
	'createproperty' => 'Napravi osobinu',
	'sf_createproperty_linktoform' => 'Ova osobina će povezivati na strane, koje koriste formu:',
	'sf_createproperty_allowedvalsinput' => 'Ako želite da ovoj osobini bude dozvoljeno da ima samo određene vrednosti, unesite spisak dozvoljenih vrednost, odvojenih zarezima (ako vrednost sadrži zarez, pišite ga kao „\\,“):',
	'sf_createproperty_propname' => 'Ime osobine:',
	'sf_createproperty_proptype' => 'Vrsta:',
	'templates' => 'Šabloni',
	'sf_templates_docu' => 'Sledeći šabloni postoje u Vikiju.',
	'sf_templates_definescat' => 'definiše kategoriju: $1',
	'createtemplate' => 'Napravi šablon',
	'sf_createtemplate_namelabel' => 'Ime šablona:',
	'sf_createtemplate_categorylabel' => 'Kategorija definisana šablonom (opciono):',
	'sf_createtemplate_templatefields' => 'Polja šablona',
	'sf_createtemplate_fieldname' => 'Ime polja:',
	'sf_createtemplate_displaylabel' => 'Natpis za prikaz:',
	'sf_createtemplate_semanticproperty' => 'Semantičko svojstvo:',
	'sf_createtemplate_fieldislist' => 'Ovo polje može da sadrži spisak vrednosti, odvojenih zarezima',
	'sf_createtemplate_aggregation' => 'Agregacija',
	'sf_createtemplate_aggregationlabel' => 'Naslov liste:',
	'sf_createtemplate_outputformat' => 'Izlazni format:',
	'sf_createtemplate_standardformat' => 'Standard', # Fuzzy
	'sf_createtemplate_addfield' => 'Dodaj polje',
	'sf_createtemplate_deletefield' => 'Obriši',
	'forms' => 'Forme',
	'sf_forms_docu' => 'Sledeće forme postoje na Vikiju.',
	'createform' => 'Napravi formu',
	'sf_createform_nameinput' => 'Ime forme',
	'sf_createform_template' => 'Šablon:',
	'sf_createform_field' => 'Polje:',
	'sf_createform_fieldprop' => 'Ovo polje definiše osobinu $1, tipa $2.',
	'sf_createform_inputtype' => 'Vrsta unosa:',
	'sf_createform_inputtypedefault' => '(podrazumevano)',
	'sf_createform_formlabel' => 'Iz labele:',
	'sf_createform_hidden' => 'Sakriveno',
	'sf_createform_removetemplate' => 'Obriši šablon',
	'sf_createform_addtemplate' => 'Dodaj šablon:',
	'sf_createform_beforetemplate' => 'Pre šablona:',
	'sf_createform_atend' => 'Na kraju',
	'sf_createform_add' => 'Dodaj',
	'sf_createform_choosefield' => 'Izaberi polje za dodavanje',
	'createcategory' => 'Napravi kategoriju',
	'sf_createcategory_name' => 'Ime kategorije:',
	'sf_createcategory_defaultform' => 'Podrazumevana forma:',
	'createclass' => 'Napravi klasu',
	'sf_createclass_allowedvalues' => 'Dozvoljene vrednosti:',
	'sf_createclass_listofvalues' => 'Spisak vrednosti?',
	'formstart' => 'Početak forme',
	'sf_formstart_createoredit' => 'Napravi ili izmeni',
	'formedit' => 'Izmeni formom',
	'sf_formedit_createtitle' => 'Napravi $1: $2',
	'sf_editsource' => 'Uredi izvor',
	'sf_formedit_edittitle' => 'Izmeni $1: $2',
	'sf_formedit_remove' => 'Ukloni',
	'sf_formedit_none' => 'Nema',
	'sf_bad_number_error' => 'mora biti ispravan broj',
	'sf_bad_date_error' => 'mora biti ispravan datum',
	'uploadwindow' => 'Prozor za slanje',
	'sf_deletionlog' => 'Istorija brisanja',
	'sf_form_freetextlabel' => 'Slobodan tekst',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'createproperty' => 'Moak ne Oainskup',
	'sf_createproperty_allowedvalsinput' => 'Wan du foar dit Attribut bloot bestimde Wäide muugelk moakje wolt, reek do dan as kommatrände Lieste ien (wan n Wäid n Komma änthaalt, ärsät dit truch "\\," sunner Anfierengen):',
	'sf_createproperty_propname' => 'Attributnoome:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Foarloage',
	'sf_templates_docu' => 'Do foulgjende Foarloagen existierje in {{SITENAME}}.',
	'sf_templates_definescat' => 'definiert Kategorie: $1',
	'createtemplate' => 'Moak ne Foarloage',
	'sf_createtemplate_namelabel' => 'Foarloagenoome:',
	'sf_createtemplate_categorylabel' => 'Truch Foarloage definierde Kategorie (optionoal):',
	'sf_createtemplate_templatefields' => 'Foarloagenfäilde',
	'sf_createtemplate_fieldsdesc' => 'Wan n Fäild fon ne Foarloage naan Fäildnoome moor bruukt, reek eenfach insteede fon n wuudelken Noome ju Indexnummer fon dät Fäild as Noome ien (t.B. 1, 2, 3 usw.).',
	'sf_createtemplate_fieldname' => 'Fäildnoome:',
	'sf_createtemplate_displaylabel' => 'Antouwiesende Fäildbeteekenge:',
	'sf_createtemplate_semanticproperty' => 'Semantiske Oainskup:',
	'sf_createtemplate_fieldislist' => 'Dit Fäild kon ne Lieste fon Wäide änthoolde, do der truch Kommata tränd wäide.',
	'sf_createtemplate_addfield' => 'Föich Fäild bietou',
	'sf_createtemplate_deletefield' => 'Läskje',
	'sf_createtemplate_addtemplatebeforesave' => 'Du moast mindestens ne Foarloage an dit Formular bietouföigje, eer du dät spiekerje koast.',
	'forms' => 'Formulare',
	'sf_forms_docu' => 'Do foulgjende Formulare existierje in {{SITENAME}}:',
	'sf_forminputs_mandatory' => 'Plichtfäild',
	'sf_forminputs_restricted' => 'Speerd (bloot Sysops konnen annerje)', # Fuzzy
	'createform' => 'Moak n Formular',
	'sf_createform_nameinput' => 'Formularnoome',
	'sf_createform_template' => 'Foarloage:',
	'sf_createform_templatelabelinput' => 'Foarloagebeteekenge (optionoal)',
	'sf_createform_allowmultiple' => 'Ferlööwje moorere (of nul) Instanzen fon disse Foarloage in ju moakede Siede',
	'sf_createform_field' => 'Fäild:',
	'sf_createform_fieldprop' => 'Dit Fäild definiert ju Oainskup $1 fon dän Typ $2.',
	'sf_createform_fieldproplist' => 'Dit Fäild definiert ne Lieste fon Elemente, do ju Oainskup $1 fon dän Typ $2 hääbe.',
	'sf_createform_fieldpropunknowntype' => 'Dit Fäild definiert ju Oainskup $1 mäd n nit-spezifizierten Typ.',
	'sf_createform_inputtype' => 'Reek dän Typ ien:',
	'sf_createform_inputtypedefault' => '(Standoardwäid)',
	'sf_createform_formlabel' => 'Formularbeteekenge:',
	'sf_createform_hidden' => 'Ferstat',
	'sf_createform_removetemplate' => 'Foarloage wächhoalje',
	'sf_createform_addtemplate' => 'Föich Foarloage bietou',
	'sf_createform_beforetemplate' => 'foar Foarloage',
	'sf_createform_atend' => 'ap e Eend',
	'sf_createform_add' => 'Föich bietou',
	'sf_createform_choosefield' => 'Wääl n Fäild uut, dät du bietouföigje wolt.',
	'createcategory' => 'Moak ne Kategorie',
	'sf_createcategory_name' => 'Noome fon ju Kategorie:',
	'sf_createcategory_defaultform' => 'Standoardformular:',
	'sf_createcategory_makesubcategory' => 'Moak disse Kategorie tou ne Subkategorie fon n uur Kategorie (optional):',
	'formstart' => 'Föich Siede bietou',
	'sf_formstart_badform' => 'Failer: der wuude neen Siede fuunen bie $1',
	'sf_formstart_docu' => "Reek in dit Textfäild dän Noome fon ju Siede ien, ju der mäd Formular '$1' beoarbaided wäide skäl. Wan der al ne Siede mäd dissen Noome bestoant, wädst du tou n Formular fäärelat, wiermäd du disse Siede beoarbaidje koast. Uurs wädst du tou n Formular fäärelat, wiermäd du disse Siede moakje koast.",
	'sf_formstart_noform_docu' => 'Reek in dit Textfäild dän Noome fon ju Siede ien un wääl dät Formular, wiermäd ju Siede beoarbaided wäide skäl. Wan der al ne Siede mäd dissen Noome bestoant, wädst du tou n Formular fäärelät, wiermäd du disse Siede beoarbaidje koast. Uurs wädst du tou n Formular fäärelat, wiermäd du disse Siede moakje koast.',
	'sf_formstart_createoredit' => 'Bietouföigje of beoarbaidje', # Fuzzy
	'formedit' => 'Beoarbaidje mäd Formular',
	'sf_formedit_createtitle' => 'Föich $1: $2 bietou', # Fuzzy
	'sf_formedit_badurl' => "Dit is ju Siede toun Bietouföigjen fon Doaten. Du moast dän Noome fon n Formular UN ju tou beoarbaidjende Sielsiede in ju URL anreeke. Dät skuul uutsjo as 'Special:FormEdit?form=<Formularnoome>&target=<Sielsiede>' of 'Special:FormEdit/<Formularnoome>/<Sielsiede>'.",
	'sf_formedit_altforms' => 'Du koast insteede deerfon disse Siede mäd een fon do foulgjende Formulare moakje:',
	'sf_formedit_altformsonly' => 'Wääl een fon do foulgjende Formulare uut, uum disse Siede tou moakjen:',
	'sf_editsource' => 'Beoarbaidje Wältext',
	'sf_formedit_edittitle' => 'Beoarbaidje $1: $2',
	'sf_formedit_formwarning' => 'Woarskauenge: Disse Siede <a href="$1">bestoant al</a>, oawers ju benutset dit Formular nit.',
	'sf_formedit_remove' => 'Wächhoalje',
	'sf_formedit_addanother' => 'Wiedere bietouföigje',
	'sf_blank_error' => 'Duur nit loos weese!',
	'sf_bad_url_error' => "mout dät korrekte URL-Format hääbe, ounfangend mäd 'http://'",
	'sf_bad_email_error' => 'mout n gultich Email-Adresformoat hääbe',
	'sf_bad_number_error' => 'mout ne gultige Taal weese',
	'sf_bad_date_error' => 'mout n gultich Doatum weese',
	'sf_property_isproperty' => 'Dit is ne Oainskup fon dän Typ $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Die muugelke Wäid foar disse Oainskup is|Do muugelke Wäide foar disse Oainskup sunt}}:',
	'sf_template_docu' => "Dit is ju Foarloage foar '$1'. Ju skuul in dät foulgjende Formoat apruupen wäide:",
	'sf_template_docufooter' => 'Beoarbaidje disse Siede, uum dän Foarloagentext tou sjoon.',
	'sf_form_docu' => "Reek in dit Textfäild dän Noome fon ju Siede ien, ju der mäd Formular '$1' moaked wäide skäl. Wan der al ne Siede mäd dissen Noome bestoant, wädst du tou n Formular fäärelat, wiermäd du disse Siede beoarbaidje koast.", # Fuzzy
	'sf_form_freetextlabel' => 'Fräitext',
	'sf_category_hasdefaultform' => 'Disse Kategorie benutset dät Formular $1.',
	'sf_category_desc' => 'Dit is ju Kategorie $1.',
);

/** Swedish (svenska)
 * @author Jon Harald Søby
 * @author Lejonel
 * @author M.M.S.
 * @author Martinwiss
 * @author Najami
 * @author Per
 * @author Rotsee
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'semanticforms-desc' => 'Formulär för att lägga till och redigera semantisk data',
	'specialpages-group-sf_group' => 'Semantiska formulär',
	'createproperty' => 'Skapa en egenskap',
	'sf-createproperty-with-name' => 'Skapa egenskap: $1',
	'sf_createproperty_linktoform' => 'Denna egenskap kommer länka till sidor som använder formuläret:',
	'sf_createproperty_allowedvalsinput' => 'Om du önskar att detta fält endast ska kunna ha vissa värden, lista tillåtna värden, separerade med komma (om ett värde innehåller komma, ersätt det med "\\,"):',
	'sf_createproperty_propname' => 'Egenskapsnamn:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Mallar',
	'sf_templates_docu' => 'Följande mallar finns på wikin.',
	'sf_templates_definescat' => 'definierar kategori: $1',
	'createtemplate' => 'Skapa en mall',
	'sf-createtemplate-with-name' => 'Skapa mall: $1',
	'sf_createtemplate_namelabel' => 'Mallnamn:',
	'sf_createtemplate_multipleinstance' => 'Mallen kan användas flera gånger på sidan.',
	'sf_createtemplate_categorylabel' => 'Kategori definierad av mall (valfri):',
	'sf_createtemplate_templatefields' => 'Mallfält',
	'sf_createtemplate_fieldsdesc' => 'För att fälten i denna mall inte längre ska kräva fältnamn, skriv in indexnummret till varje fält (alltså 1, 2, 3, osv.) som namn, i stället för ett riktigt namn.',
	'sf_createtemplate_fieldname' => 'Fältnamn:',
	'sf_createtemplate_displaylabel' => 'Visa etikett:',
	'sf_createtemplate_semanticproperty' => 'Semantisk egenskap:',
	'sf_createtemplate_fieldislist' => 'Detta fält kan innehålla en lista över värden, separarat med komma',
	'sf_createtemplate_aggregation' => 'Aggregering',
	'sf_createtemplate_aggregationdesc' => 'Ange en egenskap här nedanför om du vill att den här mallen ska kunna användas för att lista alla sidor som har en särskild egenskap som pekar till den sidan:',
	'sf_createtemplate_aggregationlabel' => 'Titel för lista:',
	'sf_createtemplate_outputformat' => 'Resultatformatering:',
	'sf_createtemplate_standardformat' => 'Tabell',
	'sf_createtemplate_infoboxformat' => 'Faktaruta',
	'sf_createtemplate_plainformat' => 'Ren text',
	'sf_createtemplate_sectionsformat' => 'Avsnitt',
	'sf_createtemplate_addfield' => 'Lägg till fält',
	'sf_createtemplate_deletefield' => 'Radera',
	'sf_createtemplate_addtemplatebeforesave' => 'Du måste lägga till minst en mall till detta formulär innan du kan spara det.',
	'forms' => 'Formulär',
	'sf_forms_docu' => 'Följande formulär finns på wikin.',
	'sf_forminputs_mandatory' => 'Obligatorisk',
	'sf_forminputs_restricted' => 'Endast administratörer kan redigera detta fält',
	'sf_forminputs_class' => 'HTML-klass ("class") för det här fältet',
	'sf_forminputs_default' => 'Standardvärde för det här fältet',
	'sf_forminputs_preload' => 'Wikisida vars innehåll används som standardvärde för det här fältet',
	'sf_forminputs_property' => 'Semantisk egenskap som det här fältet motsvarar',
	'sf_forminputs_size' => 'Storlek på textfältet, i antal tecken',
	'sf_forminputs_maxlength' => 'Maximalt antal tecken i det här fältet',
	'sf_forminputs_placeholder' => 'Instruktion som visas i indatafältet till dess att användaren klickar på det',
	'sf_forminputs_uploadable' => 'Visa en ”ladda upp”-länk intill det här fältet', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Förvalt filnamn för uppladdade filer',
	'sf_forminputs_rows' => 'Antal rader för det här fältet',
	'sf_forminputs_cols' => 'Antal kolumner för det här fältet',
	'sf_forminputs_autogrow' => 'Låt det här fältet växa automatiskt, i takt med att det fylls på',
	'sf_forminputs_valuesfromproperty' => 'En egenskap vars värden i wikin ska användas som det här indatafältets möjliga värden',
	'sf_forminputs_valuesfromcategory' => 'En kategori vars sidor ska användas som det här indatafältets möjliga värden',
	'sf_forminputs_valuesfromnamespace' => 'En namnrymd vars sidor ska användas som det här indatafältets möjliga värden',
	'sf_forminputs_valuesfromconcept' => 'En begreppssida för Semantiska MediaWiki med sidor som ska utgöra möjliga värden att välja',
	'sf_forminputs_valuesfromurl' => 'En URL som innehåller data som ska utgöra möjliga värden att välja',
	'sf_forminputs_values' => 'Värdena som är möjliga att välja, separerade med komma',
	'sf_forminputs_list' => 'Ange att detta indatafält kan ha flera värden (i en lista)',
	'sf_forminputs_delimiter' => 'Tecken som avgränsar värdena i indatafältet (om indatafältet kan ha flera värden i en lista)',
	'sf_forminputs_remoteautocompletion' => 'Använd extern automatisk ifyllnad av fält',
	'sf_forminputs_existingvaluesonly' => 'Tillåt endast värden som redan finns i listan',
	'sf_forminputs_showonselect' => 'Sidobjekt som ska visas enbart om vissa värden är valda (t.ex: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => 'Höjden på den här listrutan, i textrader',
	'sf_forminputs_includetimezone' => 'Använd indatafält för tidszon',
	'sf_forminputs_topcategory' => 'Överordnad kategori (obligatiskt)',
	'sf_forminputs_hideroot' => 'Göm den överordnade kategorin',
	'sf_forminputs_depth' => 'Antal kategorinivåer att visa från början',
	'sf_forminputs_height' => 'Höjden på det här fältet, i pixlar',
	'sf_forminputs_width' => 'Bredden på det här fältet, i pixlar',
	'createform' => 'Skapa ett formulär',
	'sf-createform-with-name' => 'Skapa formulär: $1',
	'sf_createform_nameinput' => 'Formulärnamn',
	'sf_createform_nameinputdesc' => '(forumuläret brukar ofta ges samma namn som mallen den använder):',
	'sf_createform_template' => 'Mall:',
	'sf_createform_templatelabelinput' => 'Malletikett (valfritt):',
	'sf_createform_allowmultiple' => 'Tillåt flera (eller inga) instanser av denna mall på sidan som skapades', # Fuzzy
	'sf_createform_field' => 'Fält:',
	'sf_createform_fieldprop' => 'Det här fältet definierar egenskapen $1, av typen $2.',
	'sf_createform_fieldproplist' => 'Det här fältet definierar en lista över element som har egenskapen $1, av typen $2.',
	'sf_createform_fieldpropunknowntype' => 'Det här fältet definierar egenskapen $1, av ospecifierad typ.',
	'sf_createform_inputtype' => 'Inskrivningstyp:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createform_formlabel' => 'Formuläretikett:',
	'sf_createform_hidden' => 'Dolda',
	'sf_createform_removetemplate' => 'Ta bort mall',
	'sf_createform_addtemplate' => 'Lägg till mall:',
	'sf_createform_beforetemplate' => 'Före mall:',
	'sf_createform_atend' => 'Vid slutet',
	'sf_createform_add' => 'Lägg till',
	'sf_createform_choosefield' => 'Välj ett fält att lägga till',
	'createcategory' => 'Skapa en kategori',
	'sf-createcategory-with-name' => 'Skapa kategori: $1',
	'sf_createcategory_name' => 'Kategorinamn:',
	'sf_createcategory_defaultform' => 'Standardformulär:',
	'sf_createcategory_makesubcategory' => 'Gör detta till en underkategori av en annan kategori (valfritt):',
	'createclass' => 'Skapa en klass',
	'sf_createclass_docu' => 'Skriv in all data här för att skapa egenskaper, mallar, scheman och kategorier för en klass. För fler alternativ använd sidan $1 istället.',
	'sf_createclass_allowedvalues' => 'Tillåtna värden:',
	'sf_createclass_listofvalues' => 'Lista med flera värden?',
	'sf_createclass_nameinput' => 'Formulärnamn:',
	'sf_createclass_missingvalues' => 'Några obligatoriska fält blev inte ifyllda.',
	'sf_createclass_success' => 'Egenskaper, mallar, formulär och kategorier kommer att skapas.',
	'sf_createclass_create' => 'Skapa',
	'formstart' => 'Lägg till sida genom ett formulär',
	'sf_formstart_badform' => 'Fel: ingen formulärsida hittades på $1',
	'sf_formstart_badtitle' => 'Fel: "$1" är inte en giltig titel på en sida.',
	'sf_formstart_docu' => 'Skriv in namnet på sidan som ska redigeras med formuläret "$1" här.
Om sidan redan existerar kommer du skickas över till formulärt för redigering av den sidan.
Om du inte skickas över till formuläret för att skapa sidan.',
	'sf_formstart_noform_docu' => 'Skriv in namnet på sidan här, och välj vilket formulär du vill använda till att redigera den.
Om sidan redan existerar, kommer du skickas över till formuläret för redigering av den sidan.
Om du inte kommer skickas över till formuläret för att skapa sidan.',
	'sf_formstart_createoredit' => 'Skapa eller redigera',
	'formedit' => 'Redigera med formulär',
	'sf_formedit_createtitle' => 'Skapa $1: $2',
	'sf_formedit_createtitlenotarget' => 'Skapa $1',
	'sf_formedit_badurl' => 'Det här är sidan för att lägga till data. Du måste ange både ett formulärnamn och en målsida i URL-en;
det borde se ut som; "Special:FormEdit?form=<´formulärnamn>&target=<målsida>", eller som: "Special:FormEdit/<form name>/<target page>".',
	'sf_formedit_altforms' => 'Du kan istället skapa sidan genom att använda ett av följande formulär:',
	'sf_formedit_altformsonly' => 'Var god välj från en av de följande formulären för att lägga till den här sidan:',
	'sf_formcreate' => 'Skapa med formulär',
	'sf_viewform' => 'Visa formulär',
	'sf_editsource' => 'Redigera källa',
	'sf_formedit_edittitle' => 'Redigera $1: $2',
	'sf_formedit_morethanoneform' => "'''Varning:''' Mer än ett förvalt forumlär har angetts för denna sida.",
	'sf_formedit_formwarning' => 'Varning: Den här sidan <a href="$1">finns redan</a>, men använder inte det här formuläret.',
	'sf_formedit_mismatchedbrackets' => 'Varning: Den här sidan innehåller krull- eller hakparenteser som inte är balanserade. Sidan kommer därför inte att hanteras korrekt av formuläret. Var vänlig <a href="$1">rätta till felet i wikitexten/källtexten</a> innan du fortsätter.',
	'sf_formedit_remove' => 'Radera', # Fuzzy
	'sf_formedit_addanotherabove' => 'Lägg till ett nytt fält ovanför detta',
	'sf_formedit_addanother' => 'Lägg till en annan',
	'sf_formedit_none' => 'Ingen',
	'sf_formedit_emptytitle' => 'Fel: Angiven data resulterade i en tom sidtitel.',
	'sf_formedit_hookerror' => 'Fel: Ett tillägg till MediaWiki gör att det inte går att ändra målsidan',
	'sf_formedit_saveandcontinueediting' => 'Spara och fortsätt',
	'sf_formedit_saveandcontinue_summary' => 'Sparad med hjälp av "$1"-knappen i formuläret',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Spara data och fortsätt redigera',
	'sf_autoedit_anoneditwarning' => 'Varning: Du är inte inloggad. Din IP-adress kommer att sparas i historiken för den här sidan.',
	'sf_autoedit_success' => 'Har ändrat [[$1]] med hjälp av formulär $2.',
	'sf_autoedit_notargetspecified' => 'Ingen målsida angiven.',
	'sf_autoedit_invalidform' => '$1 är inte ett giltigt formulär',
	'sf_autoedit_redlinkexists' => '$1 finns redan.',
	'sf_autoedit_noformfound' => 'Inget formulär angivet.',
	'sf_autoedit_toomanyformsfound' => 'Inte mer än ett formulär är tillgängligt för sidan.',
	'sf_autoedit_readonly' => 'Databasen är för tillfället låst så att ändringar inte går att genomföra. Orsaken är: $1',
	'sf_autoedit_nosemanticform' => 'Kan inte få formulär $2 för sidan $1. Se [[{{#special:FormEdit}}/$2/$1]] för ytterligare information.',
	'sf_autoedit_summary' => 'Har redigerats automatiskt från sidan $1.',
	'sf-autoedit-wait' => 'Var vänlig vänta...',
	'runquery' => 'Kör sökning',
	'sf_runquery_badurl' => "Du måste ange ett namn på ett formulär i URL-en;
URL-en måste se ut som 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'Kör sökning: $1',
	'sf_runquery_additionalquery' => 'Ytterligare fråga',
	'sf_formerrors_header' => 'Det fanns fel i ditt formulär; se nedan',
	'sf_blank_error' => 'kan inte vara tom',
	'sf_bad_url_error' => 'måste ha korrekt URL-format, inkluderande "http"',
	'sf_bad_email_error' => 'måste ha ett giltigt format på e-postadressen',
	'sf_bad_number_error' => 'måste vara ett giltigt tal',
	'sf_bad_date_error' => 'måste vara ett giltigt datum',
	'uploadwindow' => 'Uppladdningsfönster',
	'sf_deletionlog' => 'Raderingslogg',
	'sf-preview-header' => 'Förgranska formulär',
	'sf-preview-note' => 'Så här kommer formuläret att se ut när det används:',
	'sf-pageschemas-pagenameformula' => 'Formel för sidnamn:',
	'sf-pageschemas-createtitle' => 'Titel på formulär för nya sidor:',
	'sf-pageschemas-edittitle' => 'Titel på formulär för befintliga sidor:',
	'sf-pageschemas-inputtype' => 'Typ av indatafält (lämna tom för förvald typ):',
	'sf_property_isproperty' => 'Det här är en egenskap av typen $1.',
	'sf_property_linkstoform' => 'Det länkar till sidor som använder formuläret $1',
	'sf_property_allowedvals' => '{{PLURAL:$1|Det tillåtna värdet för den här egenskapen är|De tillåtna värdena för den här egenskapen är}}:',
	'sf_template_docu' => 'Det här är mallen "$1".
Det borde namnges i följande format:',
	'sf_template_docufooter' => 'Redigera sidan för att se mall texten.',
	'sf_form_docu' => 'Det här är formuläret "$1".

För att lägga till en ny sida med hjälp av det här formuläret; skriv in namnet på sidan här nedanför.

Om en sida med det namnet redan finns, så kommer formuläret istället användas för att redigera befintliga data för den sidan.',
	'sf_form_freetextlabel' => 'Fritext',
	'sf_category_hasdefaultform' => 'Den här kategorin använder formuläret $1.',
	'sf_category_desc' => 'Detta är $1 kategorin.',
	'sf_blank_namespace' => 'Huvud',
	'right-viewedittab' => 'Visa "Redigera"-fliken för sidor som går att redigera med formulär', # Fuzzy
	'right-editrestrictedfields' => 'Redigera formulär som är begränsade',
	'right-createclass' => 'Skapa en ny semantisk klass',
	'action-createclass' => 'skapa nya semantiska klasser',
	'action-editrestrictedfields' => 'redigera begränsade formulär-fält',
	'action-viewedittab' => 'visa fliken "Redigera" för sidor som går att redigera med formulär', # Fuzzy
);

/** Swahili (Kiswahili)
 * @author Stephenwanjau
 */
$messages['sw'] = array(
	'sf_createproperty_proptype' => 'Aina:',
);

/** Silesian (ślůnski)
 * @author Herr Kriss
 */
$messages['szl'] = array(
	'sf_createproperty_propname' => 'Mjano:', # Fuzzy
	'sf_createform_add' => 'Dodej',
	'sf_createcategory_name' => 'Mjano:', # Fuzzy
);

/** Tamil (தமிழ்)
 * @author Shanmugamp7
 * @author TRYPPN
 */
$messages['ta'] = array(
	'sf_createproperty_proptype' => 'வகை:',
	'templates' => 'வார்ப்புருக்கள்',
	'createtemplate' => 'ஒரு வார்ப்புருவை உருவாக்கவும்',
	'sf_createtemplate_namelabel' => 'வார்ப்புரு பெயர்:',
	'sf_createtemplate_templatefields' => 'வார்ப்புரு புலங்கள்',
	'sf_createtemplate_fieldname' => 'புலப் பெயர்:',
	'sf_createtemplate_standardformat' => 'அட்டவணை',
	'sf_createtemplate_infoboxformat' => 'ஓர தகவற்பெட்டி',
	'sf_createtemplate_plainformat' => 'எளிய உரை',
	'sf_createtemplate_sectionsformat' => 'பிரிவுகள்',
	'sf_createtemplate_addfield' => 'Add field',
	'sf_createtemplate_deletefield' => 'நீக்கவும்',
	'forms' => 'படிவங்கள்',
	'createform' => 'ஒரு படிவத்தை உருவாக்கவும்',
	'sf-createform-with-name' => 'படவத்தை உருவாக்கு : $1',
	'sf_createform_nameinput' => 'படிவப் பெயர்',
	'sf_createform_template' => 'வார்ப்புரு:',
	'sf_createform_field' => 'புலம்',
	'sf_createform_inputtype' => 'உள்ளீட்டு வகை:',
	'sf_createform_inputtypedefault' => '(இயல்பிருப்பு)',
	'sf_createform_formlabel' => 'படிவ வில்லை:',
	'sf_createform_hidden' => 'மறைக்கப்பட்டது',
	'sf_createform_removetemplate' => 'வார்ப்புருவை நீக்கு',
	'sf_createform_addtemplate' => 'வார்ப்புருவைச் சேர்',
	'sf_createform_beforetemplate' => 'வார்ப்புருவிற்கு முன்:',
	'sf_createform_atend' => 'இறுதியில்',
	'sf_createform_add' => 'சேர்',
	'sf_createform_choosefield' => 'சேர்க்க ஒரு புலத்தை தேர்வு செய்யவும்',
	'createcategory' => 'ஒரு பகுப்பை உருவாக்கவும்',
	'sf-createcategory-with-name' => 'பகுப்பை உருவாக்கு: $1',
	'sf_createcategory_name' => 'பகுப்புப் பெயர்:',
	'sf_createcategory_defaultform' => 'இயல்புநிலை படிவம்:',
	'sf_createcategory_makesubcategory' => 'இதை மற்றொரு பகுப்பின் துணைப் பகுப்பாக்கு (விருப்பத்தேர்வு):',
	'createclass' => 'ஒரு படிநிலையை உருவாக்கவும்',
	'sf_createclass_allowedvalues' => 'அனுமதிக்கப்பட்ட மதிப்புகள்',
	'sf_createclass_listofvalues' => 'மதிப்புகளின் பட்டியல்?',
	'sf_createclass_nameinput' => 'படிவப் பெயர்:',
	'sf_createclass_missingvalues' => 'அனைத்து தேவைப்படும் புலங்களும் நிரப்பப்படவில்லை.',
	'sf_createclass_create' => 'உருவாக்கு',
	'sf_formstart_createoredit' => 'உருவாக்கு அல்லது தொகு',
	'formedit' => 'படிவத்துடன் தொகு',
	'sf_formedit_createtitle' => 'உருவாக்கு $1: $2',
	'sf_formedit_createtitlenotarget' => 'உருவாக்கு $1',
	'sf_formcreate' => 'படிவத்துடன் உருவாக்கு',
	'sf_viewform' => 'படிவத்தை காண்க',
	'sf_editsource' => 'மூலத்தை தொகு',
	'sf_formedit_edittitle' => 'தொகு $1: $2',
	'sf_formedit_remove' => 'நீக்குக',
	'sf_formedit_addanother' => 'மற்றொன்றை சேர்க்கவும்',
	'sf_formedit_none' => 'எதுவுமில்லை',
	'sf_formedit_saveandcontinueediting' => 'சேமித்து தொடரவும்',
	'sf_bad_email_error' => 'கண்டிப்பாக செல்லத்தக்க மின்னஞ்சல் முகவரி வடிவமைப்பைக் கொண்டிருக்க வேண்டும்',
	'sf_bad_number_error' => 'கண்டிப்பாக செல்லத்தக்க எண்ணாக இருக்க வேண்டும்',
	'sf_bad_date_error' => 'கண்டிப்பாக செல்லத்தக்க தேதியாக இருக்க வேண்டும்',
	'sf-preview-header' => 'படிவ முன்தோற்றம்',
	'sf_blank_namespace' => 'முதன்மையானது',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'sf_createproperty_propname' => 'లక్షణపు పేరు:',
	'sf_createproperty_proptype' => 'రకం:',
	'templates' => 'మూసలు',
	'sf_templates_definescat' => 'వర్గాన్ని నిర్వచిస్తుంది: $1',
	'createtemplate' => 'మూసని సృష్టించండి',
	'sf_createtemplate_namelabel' => 'మూస పేరు:',
	'sf_createtemplate_fieldislist' => 'ఈ ఖాళీలో కామాలతో వేరుపరచి బహుళ విలువలని ఇవ్వవచ్చు',
	'sf_createtemplate_aggregation' => 'సంకలనం',
	'sf_createtemplate_aggregationlabel' => 'జాబితాకి శీర్షిక:',
	'sf_createtemplate_standardformat' => 'ప్రామాణిక', # Fuzzy
	'sf_createtemplate_infoboxformat' => 'కుడివైపు సమాచారపెట్టె', # Fuzzy
	'sf_createtemplate_deletefield' => 'తొలగించు',
	'sf_forminputs_mandatory' => 'తప్పనిసరి',
	'sf_createform_nameinput' => 'ఫారం పేరు',
	'sf_createform_template' => 'మూస:',
	'sf_createform_templatelabelinput' => 'మూస పేరు (ఐచ్చికం):',
	'sf_createform_inputtypedefault' => '(అప్రమేయం)',
	'sf_createform_hidden' => 'దాచినది',
	'sf_createform_removetemplate' => 'మూసని తొలగించండి',
	'sf_createform_addtemplate' => 'మూసని చేర్చండి:',
	'sf_createform_beforetemplate' => 'మూసకి ముందు:',
	'sf_createform_atend' => 'చివరన',
	'sf_createform_add' => 'చేర్చు',
	'createcategory' => 'వర్గాన్ని సృష్టించండి',
	'sf_createcategory_name' => 'వర్గపు పేరు:',
	'sf_createcategory_makesubcategory' => 'దీన్ని మరో వర్గానికి ఉపవర్గం చెయ్యి (ఐచ్ఛికం):',
	'sf_createclass_allowedvalues' => 'అనుమతించే విలువలు:',
	'sf_createclass_listofvalues' => 'విలువల యొక్క జాబితా', # Fuzzy
	'formstart' => 'ఫారంతో పేజీని చేర్చండి',
	'sf_formstart_createoredit' => 'చేర్చు లేదా మార్చు', # Fuzzy
	'sf_formedit_formwarning' => 'హెచ్చరిక: ఈ పేజీ <a href="$1">ఇప్పటికే ఉంది</a>, కానీ దానిలో ఈ ఫారం లేదు.',
	'sf_formedit_remove' => 'తొలగించు',
	'sf_formedit_addanother' => 'మరోటి చేర్చండి',
	'sf_formedit_none' => 'ఏమీలేదు',
	'sf_blank_error' => 'ఖాళీగా ఉండకూడదు',
	'sf_bad_number_error' => 'ఖచ్చితంగా ఓ సంఖ్య అయివుండాలి',
	'sf_bad_date_error' => 'సరైన తేదీ అయివుండాలి',
	'uploadwindow' => 'ఎక్కింపు కిటికీ',
	'sf_deletionlog' => 'తొలగింపు చిట్టా',
	'sf_form_freetextlabel' => 'స్వేచ్ఛా పాఠ్యం',
	'sf_category_hasdefaultform' => 'ఈ వర్గం $1 అనే ఫారాన్ని వాడుతుంది.',
	'sf_category_desc' => 'ఇది $1 అనే వర్గం.',
	'sf_blank_namespace' => 'ప్రధాన',
);

/** Tetum (tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'sf_createproperty_propname' => 'Naran:', # Fuzzy
	'sf_createtemplate_deletefield' => 'Halakon',
	'sf_createform_add' => 'Tau tan',
	'sf_createcategory_name' => 'Naran kategoria nian:',
);

/** Tajik (Cyrillic script) (тоҷикӣ)
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'createproperty' => 'Вижагӣ бисозед',
	'sf_createproperty_allowedvalsinput' => 'Агар мехоҳед ин вуруди танҳои миқдорҳои мушаххаси миҷоз дошта бошад, феҳристи миқдорҳои миҷозро ворид кунед ва онҳоро бо вергул ҷудо созед (агар миқдор вергул дошта бошад, онро бо "\\," иваз кунед):', # Fuzzy
	'sf_createproperty_propname' => 'Ном:', # Fuzzy
	'sf_createproperty_proptype' => 'Навъ:',
	'templates' => 'Шаблонҳо',
	'sf_templates_docu' => 'Шаблонҳои зер дар ин вики вуҷуд доранд.',
	'sf_templates_definescat' => 'таъйиди гурӯҳ: $1',
	'createtemplate' => 'Шаблон бисозед',
	'sf_createtemplate_namelabel' => 'Номи шаблон:',
	'sf_createtemplate_categorylabel' => 'Таъйиди гурӯҳ бо воситаи шаблон (ихтиёрӣ):',
	'sf_createtemplate_templatefields' => 'Вурудиҳои шаблон',
	'sf_createtemplate_aggregationlabel' => 'Унвон барои феҳрист:',
	'sf_createtemplate_standardformat' => 'Стандарт', # Fuzzy
	'sf_createtemplate_deletefield' => 'Ҳафз',
	'sf_createtemplate_addtemplatebeforesave' => 'Шумо бояд ҳадди ақал як шаблон ба ин форм қабл аз захира кардани он илова кунед.',
	'sf_forms_docu' => 'Формҳои зерин дар вики вуҷуд доранд.',
	'createform' => 'Эҷоди як форм',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_inputtypedefault' => '(пешфарз)',
	'sf_createform_add' => 'Илова кардан',
	'sf_createcategory_name' => 'Ном:', # Fuzzy
	'sf_formedit_remove' => 'Ҳазф',
	'sf_formedit_addanother' => 'Иловаи дигаре',
	'sf_formedit_none' => 'Ҳеҷ кадом',
	'sf_formerrors_header' => 'Хатоҳое дар вуруди форматон вуҷуд дорад; ба зер нигаред',
	'sf_blank_error' => 'наметавон холӣ бошад',
	'sf_property_isproperty' => 'Ин як вижагӣ аз навъи $1 аст.',
	'sf_template_docu' => "Ин шаблони '$1' аст. Бояд бо қолаби зерин фарохонӣ шавад:",
	'sf_template_docufooter' => 'Барои мушоҳидаи матни шаблон саҳифаро вироиш кунед.',
	'sf_form_docu' => "Ин форми '$1' аст. Барои илова кардани як саҳифае бо ин форм, дар зер номи саҳифаро ворид кунед; агар саҳифае бо ин ном вуҷуд дошта бошад, ба форми вироиши саҳифа ҳидоят мешавед.", # Fuzzy
	'sf_form_freetextlabel' => 'Матни дилхоҳ',
	'sf_category_hasdefaultform' => 'Ин гурӯҳ аз форми $1 истифода мекунад.',
	'sf_category_desc' => 'Ин гурӯҳи $1 аст.',
	'sf_blank_namespace' => 'Аслӣ',
);

/** Tajik (Latin script) (tojikī)
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'createproperty' => 'Viƶagī bisozed',
	'sf_createproperty_proptype' => "Nav':",
	'templates' => 'Şablonho',
	'sf_templates_docu' => 'Şablonhoi zer dar in viki vuçud dorand.',
	'sf_templates_definescat' => "ta'jidi gurūh: $1",
	'createtemplate' => 'Şablon bisozed',
	'sf_createtemplate_namelabel' => 'Nomi şablon:',
	'sf_createtemplate_categorylabel' => "Ta'jidi gurūh bo vositai şablon (ixtijorī):",
	'sf_createtemplate_templatefields' => 'Vurudihoi şablon',
	'sf_createtemplate_aggregationlabel' => 'Unvon baroi fehrist:',
	'sf_createtemplate_standardformat' => 'Standart', # Fuzzy
	'sf_createtemplate_deletefield' => 'Hafz',
	'sf_createtemplate_addtemplatebeforesave' => 'Şumo bojad haddi aqal jak şablon ba in form qabl az zaxira kardani on ilova kuned.',
	'sf_forms_docu' => 'Formhoi zerin dar viki vuçud dorand.',
	'createform' => 'Eçodi jak form',
	'sf_createform_template' => 'Şablon:',
	'sf_createform_inputtypedefault' => '(peşfarz)',
	'sf_createform_add' => 'Ilova kardan',
	'sf_formedit_remove' => 'Hazf',
	'sf_formedit_addanother' => 'Ilovai digare',
	'sf_formedit_none' => 'Heç kadom',
	'sf_formerrors_header' => 'Xatohoe dar vurudi formaton vuçud dorad; ba zer nigared',
	'sf_blank_error' => 'nametavon xolī boşad',
	'sf_property_isproperty' => "In jak viƶagī az nav'i $1 ast.",
	'sf_template_docu' => "In şabloni '$1' ast. Bojad bo qolabi zerin faroxonī şavad:",
	'sf_template_docufooter' => 'Baroi muşohidai matni şablon sahifaro viroiş kuned.',
	'sf_form_docu' => "In formi '$1' ast. Baroi ilova kardani jak sahifae bo in form, dar zer nomi sahifaro vorid kuned; agar sahifae bo in nom vuçud doşta boşad, ba formi viroişi sahifa hidojat meşaved.", # Fuzzy
	'sf_form_freetextlabel' => 'Matni dilxoh',
	'sf_category_hasdefaultform' => 'In gurūh az formi $1 istifoda mekunad.',
	'sf_category_desc' => 'In gurūhi $1 ast.',
	'sf_blank_namespace' => 'Aslī',
);

/** Thai (ไทย)
 * @author Octahedron80
 * @author Passawuth
 */
$messages['th'] = array(
	'sf_createtemplate_deletefield' => 'ลบ',
	'sf_createform_add' => 'เพิ่ม',
	'sf_formedit_none' => 'ไม่มี',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'sf_createtemplate_deletefield' => 'Öçür',
	'sf_formedit_remove' => 'Aýyr',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'semanticforms-desc' => 'Mga pormularyo para sa paggawa ng mga dagdag at pagbabago sa dato hinggil sa kahulugan ng salita (semantiko)',
	'specialpages-group-sf_group' => 'Mga Pormularyo ng Semantiko (hinggil sa kahulugan ng salita)',
	'createproperty' => 'Lumikha ng pag-aari',
	'sf-createproperty-with-name' => 'Likhain ang ari-arian: $1',
	'sf_createproperty_linktoform' => 'Ang pag-aaring ito ay kakawing patungo sa mga pahinang gumagamit ng pormularyong:',
	'sf_createproperty_allowedvalsinput' => 'Kung nais mong pahintulutan ang pag-aaring ito na magkaroon lamang ng partikular na mga halaga, ipasok ang talaan ng pinahihintulutang mga halaga, na pinaghihiwalay-hiwalay ng mga kuwit (kapag naglalaman ang isang halaga ng isang kuwit, palitan ito ng "\\,"):',
	'sf_createproperty_propname' => 'Pangalan ng pag-aari:',
	'sf_createproperty_proptype' => 'Uri:',
	'templates' => 'Mga suleras',
	'sf_templates_docu' => 'Umiiral na sa wiki ang sumusunod na mga suleras.',
	'sf_templates_definescat' => 'nagbibigay ng kahulugan sa kaurian/kategorya: $1',
	'createtemplate' => 'Lumikha ng isang suleras',
	'sf-createtemplate-with-name' => 'Likhain ang suleras: $1',
	'sf_createtemplate_namelabel' => 'Pangalan ng suleras:',
	'sf_createtemplate_multipleinstance' => 'Ang suleras na ito ay maaaring isama nang maramihang ulit sa ibabaw ng pahina.',
	'sf_createtemplate_categorylabel' => 'Kauriang binibigyang kahulugan ng suleras (maaaring wala nito):',
	'sf_createtemplate_templatefields' => 'Mga kahanayan ng suleras',
	'sf_createtemplate_fieldsdesc' => 'Hindi na ngayon kailangan ang mga pangalan ng kahanayan upang magkaroon ng mga kahanayan sa suleras na ito, payak na ipasok/ilagay lamang ang paksaan (indeks) ng bawat kahanayan (halimbawa na ang 1, 2, 3, atbp.) bilang pangalan, sa halip na isang tunay na pangalan.',
	'sf_createtemplate_fieldname' => 'Pangalan ng kahanayan:',
	'sf_createtemplate_displaylabel' => 'Ipinakikitang tatak:',
	'sf_createtemplate_semanticproperty' => 'Pag-aaring semantiko (hinggil sa kahulugan ng salita):',
	'sf_createtemplate_fieldislist' => 'Makapaghahawak ng isang talaan ng mga halaga ang kahanayang ito, pinaghihiwa-hiwalay ng mga kuwit',
	'sf_createtemplate_aggregation' => 'Pagkakakumpul-kumpol',
	'sf_createtemplate_aggregationdesc' => 'Upang maitala, sa anumang pahinang gumagamit ng ganitong suleras ang lahat ng mga pahinang may isang tiyak na pag-aari na tumuturo patungo sa pahinang iyon, tukuyin ang naaangkop na ari-ariang nasa ibaba:',
	'sf_createtemplate_aggregationlabel' => 'Pamagat ng talaan:',
	'sf_createtemplate_outputformat' => 'Anyo/pormat ng kalalabasan:',
	'sf_createtemplate_standardformat' => 'Talahanayan',
	'sf_createtemplate_infoboxformat' => 'Nasa gilid na kahon ng kabatiran',
	'sf_createtemplate_plainformat' => 'Payak na teksto',
	'sf_createtemplate_sectionsformat' => 'Mga seksyon',
	'sf_createtemplate_addfield' => 'Magdagdag ng kahanayan',
	'sf_createtemplate_deletefield' => 'Burahin',
	'sf_createtemplate_addtemplatebeforesave' => 'Dapat kang magdagdag ng kahit na isang suleras sa pormularyong ito bago mo ito masagip.',
	'forms' => 'Mga pormularyo',
	'sf_forms_docu' => 'Umiiral na sa wiking ito ang sumusunod na mga pormularyo.',
	'sf_forminputs_mandatory' => 'Kailangang gawin talaga',
	'sf_forminputs_restricted' => 'Mga tagapangasiwa lamang ang makapagbabago ng ipinasok na ito.',
	'sf_forminputs_class' => 'Ang katangiang "klase" ng HTML para sa lahok na ito',
	'sf_forminputs_default' => 'Ang likas na nakatakdang halaga para sa pagpapasok na ito',
	'sf_forminputs_preload' => 'Isang pahina ng wiki na ang mga nilalaman ay magiging likas na nakatakdang halaga ng pagpapasok na ito',
	'sf_forminputs_property' => 'Isang pag-aaring semantiko na kinatutugmaan ng hanay na ito',
	'sf_forminputs_size' => 'Ang sukat ng hanay ng tekstong ito, na mga nakapanitik',
	'sf_forminputs_maxlength' => 'Ang pinakamataas na pinahihintulutang haba ng teksto sa patlang na ito',
	'sf_forminputs_placeholder' => 'Ang tekstong pantulong na lumilitaw sa loob ng lahok magpahanggang sa lagitikin ito ng tagagamit',
	'sf_forminputs_uploadable' => 'Maglagay ng isang kawing na "Ikarga ang talaksan" na kasunod ng pagpapasok na ito', # Fuzzy
	'sf_forminputs_defaultfilename' => 'Ang likas na nakatakdang pangalan ng talaksan para sa pagkakargang papaitaas ng mga talaksan',
	'sf_forminputs_rows' => 'Ang bilang ng mga hilerang ito para sa pagpapasok na ito',
	'sf_forminputs_cols' => 'Ang bilang ng mga haligi para sa pagpapasok na ito',
	'sf_forminputs_autogrow' => 'Itakda ang lahok na ito upang lumaki ang sukat kapag lumampas na ang teksto sa mga hangganan nito',
	'sf_forminputs_valuesfromproperty' => 'Isang ari-arian na ang mga halaga sa loob ng wiki ay dapat na maging pangkat ng mga halaga ng lahok na ito',
	'sf_forminputs_valuesfromcategory' => 'Isang kategorya na ang mga pahina ay dapat na maging pangkat ng mga halaga ng lahok na ito',
	'sf_forminputs_valuesfromnamespace' => 'Isang puwang ng pangalan na ang mga pahina ay dapat na maging pangkat ng mga halaga ng lahok na ito',
	'sf_forminputs_valuesfromconcept' => 'Isang pahina ng "diwa" ng Semantikong MediaWiki na ang mga pahina ay dapat na maging pangkat ng mga halaga ng lahok na ito',
	'sf_forminputs_valuesfromurl' => 'Isang datong may kayarian na humahawak ng URL na dapat na maging pangkat ng mga halaga ng lahok na ito',
	'sf_forminputs_values' => 'Ang pangkat ng mga halaga para sa lahok na ito, pinaghihiwalay-hiwalay ng mga kuwit',
	'sf_forminputs_list' => 'Markahan ang lahok na ito bilang naghahawak ng isang listahan ng mga halaga',
	'sf_forminputs_delimiter' => 'Ang panghangga na nasa pagitan ng mga halaga ng kahanayan, kung ang lahok na ito ay humahawak ng isang listahan ng mga ito',
	'sf_forminputs_remoteautocompletion' => 'Gamitin ang kusang pagkukumpleto',
	'sf_forminputs_existingvaluesonly' => 'Pahintulutan lamang ang mga halagang nasa loob na ng lista',
	'sf_forminputs_showonselect' => 'Mga elemento ng pahina na ipapakita lamang kung napili na ang partikular na mga halaga (halimbawa: "value1=>div1;value2=>div2")',
	'sf_forminputs_listboxsize' => 'Ang taas ng kahong listahan na ito, na nasa loob ng mga hilera',
	'sf_forminputs_includetimezone' => 'Magsali ng isang lahok para sa sona ng oras',
	'sf_forminputs_topcategory' => 'Ang magulang na kategorya ng pangkat na ito ng mga kategorya (kailangan)',
	'sf_forminputs_hideroot' => 'Itago ang magulang na kategorya',
	'sf_forminputs_depth' => 'Ang bilang ng mga kaantasan ng mga kategorya na paunang ipapakita',
	'sf_forminputs_height' => 'Ang taas ng lahok na ito, nasa mga piksel',
	'sf_forminputs_width' => 'Ang lapad ng lahok na ito, nasa mga piksel',
	'createform' => 'Lumikha ng isang pormularyo',
	'sf-createform-with-name' => 'Likhain ang pormularyo: $1',
	'sf_createform_nameinput' => 'Pangalan ng pormularyo',
	'sf_createform_nameinputdesc' => '(ang pormularyo ay nakagawiang binibigyan ng kaparehong pangalan na katulad ng pangunahing suleras):',
	'sf_createform_template' => 'Suleras:',
	'sf_createform_templatelabelinput' => 'Tatak ng suleras (maaaring wala nito):',
	'sf_createform_allowmultiple' => 'Nagpapahintulot para sa maramihang (o walang) mga halimbawa/huwaran ng ganitong suleras sa loob ng nalikhang pahina',
	'sf_createform_field' => 'Kahanayan:',
	'sf_createform_fieldprop' => 'Binibigyang kahulugan ng kahanayang ito ang pag-aaring $1, ng uring $2.',
	'sf_createform_fieldproplist' => 'Binibigyang kahulugan ng kahanayang ito ang isang talaan ng mga langkap na mayroong pag-aaring $1, ng uring $2.',
	'sf_createform_fieldpropunknowntype' => 'Binibigyang kahulugan ng kahanayang ito ang pag-aaring $1, na hindi tinutukoy ang uri.',
	'sf_createform_inputtype' => 'Uri ng ipinapasok:',
	'sf_createform_inputtypedefault' => '(likas na katakdaan)',
	'sf_createform_formlabel' => 'Tatak ng pormularyo:',
	'sf_createform_hidden' => 'Nakatago',
	'sf_createform_removetemplate' => 'Tanggalin ang suleras',
	'sf_createform_addtemplate' => 'Idagdag ang suleras:',
	'sf_createform_beforetemplate' => 'Bago dumating ang suleras:',
	'sf_createform_atend' => 'Sa hulihan',
	'sf_createform_add' => 'Idagdag/magdagdag',
	'sf_createform_choosefield' => 'Pumili ng kahanayang idaragdag',
	'createcategory' => 'Lumikha ng isang kaurian (kategorya)',
	'sf-createcategory-with-name' => 'Likhain ang kategorya: $1',
	'sf_createcategory_name' => 'Pangalan ng kategorya:',
	'sf_createcategory_defaultform' => 'Likas na nakatakdang pormularyo:',
	'sf_createcategory_makesubcategory' => 'Gawin itong isang kabahaging kaurian/kategorya ng iba pang kaurian (maaaring wala nito):',
	'createclass' => 'Gumawa ng isang klase',
	'sf_createclass_docu' => 'Ipasok dito ang lahat ng mga dato upang malikha ang lahat ng mga pag-aari, suleras, pormularyo at kategorya para sa isang nag-iisang klase.  Para sa mas marami pang mga mapagpipilian, gamitin sa halip ang mga pahinang $1.',
	'sf_createclass_allowedvalues' => 'Pinahihintulutang mga halaga:',
	'sf_createclass_listofvalues' => 'Talaan ng mga halaga?',
	'sf_createclass_nameinput' => 'Pangalan ng pormularyo:',
	'sf_createclass_missingvalues' => 'Hindi pa nalagyan ang lahat ng kinakailangang mga lugar.',
	'sf_createclass_success' => 'Lilikhain ang mga pag-aari, suleras, pormularyo at kategorya.',
	'sf_createclass_create' => 'Likhain',
	'formstart' => 'Magdagdag ng pahinang may pormularyo',
	'sf_formstart_badform' => 'Kamalian: walang natagpuang pahina ng pormularyong nasa $1',
	'sf_formstart_badtitle' => 'Kamalian: ang "$1" ay isang hindi tanggap na pamagat para sa isang pahina.',
	'sf_formstart_docu' => "Ipasok dito ang pangalan ng pahina, na babaguhin sa pamamagitan ng pormularyong '$1'.
Kung umiiral na ang pahinang ito, dadalhin ka patungo sa pormularyong para sa paggawa ng pagbabago sa pahinang iyon.
At kung hindi, dadalhin ka naman patungo sa pormularyo para sa pagdaragdag ng pahina.",
	'sf_formstart_noform_docu' => 'Dito ipasok/ilagay ang pangalan ng pahina, at piliin ang pormularyong gagamitin sa pagbago nito.
Kung umiiral na ang pahinang ito, dadalhin ka patungo sa pormularyo para sa paggawa ng pagbabago para sa pahinang iyan.
Kung hindi, dadalhin ka naman patungo sa pormularyo upang maidagdag ang pahina.',
	'sf_formstart_createoredit' => 'Likhain o baguhin',
	'formedit' => 'Baguhin na may pormularyo',
	'sf_formedit_createtitle' => 'Likhain ang $1: $2',
	'sf_formedit_createtitlenotarget' => 'Likhain ang $1',
	'sf_formedit_badurl' => "Ito ang pahina para sa pagdaragdag na may pormularyo.  Dapat mong tukuying kapwa ang isang pangalan ng pormularyo at isang pinupuntiryang pahinang nasa loob ng URL;
dapat itong magmukhang katulad ng 'Special:FormEdit?form=<form name>&target=<target page>', o  'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'Sa halip, maaari mong idagdag ang pahinang ito na may isa sa sumusunod na mga pormularyo:',
	'sf_formedit_altformsonly' => 'Pumili lamang po mula sa isa sa sumusunod na mga pormularyo upang maidagdag ang pahinang ito:',
	'sf_formcreate' => 'Likhaing may pormularyo',
	'sf_viewform' => 'Tingnan ang pormularyo',
	'sf_editsource' => 'Baguhin ang pinagmulan',
	'sf_formedit_edittitle' => 'Baguhin ang $1: $2',
	'sf_formedit_morethanoneform' => "'''Babala:''' Mahigit sa isang pormularyong likas na itinakda ang binigyang kahulugan para sa pahinang ito.",
	'sf_formedit_formwarning' => 'Babala: <a href="$1">Umiiral na</a> ang pahinang ito, ngunit hindi ito gumagamit ng ganitong pormularyo.',
	'sf_formedit_mismatchedbrackets' => 'Babala: Ang pahinang ito ay naglalaman ng mga puntal na kulot o braketang parisukat na hindi nakasara, kung kaya\'t ang pahina ay hindi mapapanghawakan nang tama ng pormularyo. Paki <a href="$1">kumpunihin ang kamalian na nasa loob ng teksto ng pinagmulan</a> bago magpatuloy.',
	'sf_formedit_remove' => 'Tanggalin',
	'sf_formedit_addanother' => 'Magdagdag ng isa pa',
	'sf_formedit_none' => 'Wala',
	'sf_formedit_emptytitle' => 'Kamalian: Ang isiningit na mga resulta ng dato sa loob ng isang walang laman na pamagat ng pahina.',
	'sf_formedit_hookerror' => 'Kamalian: Isang dugtong ng MediaWiki ang pumigil sa pagbago ng pinupukol na pahina.',
	'sf_formedit_saveandcontinueediting' => 'Sagipin at magpatuloy',
	'sf_formedit_saveandcontinue_summary' => 'Sinagip na ginagamit ang pindutang "$1" na nasa loob ng pormularyo',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Sagipin ang dato at magpatuloy sa pamamatnugot',
	'sf_autoedit_anoneditwarning' => 'Babala: Hindi ka nakalagda. Matatala ang iyong tirahan ng IP sa kasaysayan ng pagbabago ng pahinang ito.',
	'sf_autoedit_success' => 'Matagumpay na nabago ang [[$1]] na ginagamit ang pormularyong $2.',
	'sf_autoedit_notargetspecified' => 'Walang tinukoy na puntiryang pahina.',
	'sf_autoedit_noformfound' => 'Walang tinukoy na pormularyo.',
	'sf_autoedit_toomanyformsfound' => 'Mahigit sa isang pormularyo ang makukuha para sa pahina.',
	'sf_autoedit_readonly' => 'Kasalukuyang nakakandado ang kalipunan ng dato upang makapagbago. Dahilan: $1',
	'sf_autoedit_nosemanticform' => 'Hindi makuha ang pormularyong $2 para sa pahinang $1. Tingnan ang [[{{#special:FormEdit}}/$2/$1]] para sa mga detalye.',
	'sf_autoedit_summary' => 'Kusang pinatnugutan magmula sa pahinang $1.',
	'sf-autoedit-wait' => 'Hintay...',
	'runquery' => 'Patakbuhin ang tanong',
	'sf_runquery_badurl' => "Kailangan kang tumukoy ng isang pangalan ng pormularyo sa loob ng URL;
dapat magmukhang katulad ng 'Special:RunQuery/<form name>' ang URL.",
	'sf_runquery_title' => 'Patakbuhin ang tanong: $1',
	'sf_runquery_additionalquery' => 'Karagdagang tanong',
	'sf_formerrors_header' => 'Mayroong mga kamalian sa mga ipinasok mo sa pormularyo; tingnan sa ibaba',
	'sf_blank_error' => 'hindi maaaring walang laman',
	'sf_bad_url_error' => "dapat na mayroong tamang anyo/pormat ng URL, na nagsisimula sa 'http'",
	'sf_bad_email_error' => 'dapat na mayroong isang tanggap na anyo/pormat ng adres ng e-liham',
	'sf_bad_number_error' => 'dapat na isang tanggap na bilang',
	'sf_bad_date_error' => 'dapat na isang tanggap na petsa',
	'uploadwindow' => 'Dungawan ng pagkarga',
	'sf_deletionlog' => 'Talaan ng pagbubura',
	'sf-preview-header' => 'Paunang patingin sa pormularyo',
	'sf-preview-note' => 'Ganito ang magiging anyo ng pormularyo habang ginagamit ito:',
	'sf-pageschemas-pagenameformula' => 'Pormula ng pangalan ng pahina:',
	'sf-pageschemas-createtitle' => 'Pamagat ng pormularyo para sa bagong mga pahina:',
	'sf-pageschemas-edittitle' => 'Pamagat ng pormularyo para sa umiiral na mga pahina:',
	'sf-pageschemas-inputtype' => 'Uri ng pagpapasok (iwanang walang laman upang maitakda sa likas na katakdaan):',
	'sf_property_isproperty' => 'Isa itong pag-aari ng uring $1.',
	'sf_property_linkstoform' => 'Kumakawing ito sa mga pahinang gumagamit ng pormularyong $1.',
	'sf_property_allowedvals' => 'Ang pinahihintulutang {{PLURAL:$1|halaga para sa pag-aaring ito ay|mga halaga para sa pag-aaring ito ay}}:',
	'sf_template_docu' => "Ito ang suleras na '$1'.
Dapat na tawagin ito alinsunod sa sumusunod na anyo/pormat:",
	'sf_template_docufooter' => 'Baguhin ang pahina upang makita ang teksto ng suleras.',
	'sf_form_docu' => "Ito ang pormularyong '$1'.
Upang makalikha ng isang pahina na may ganitong pormularyo, ipasok ang pangalan ng pahina sa ibaba;
kung umiiral na ang isang pahinang may ganyang pangalan, dadalhin ka patungo sa isang pormularyo upang mabago ang pahinyang iyan.",
	'sf_form_freetextlabel' => 'Malayang teksto',
	'sf_category_hasdefaultform' => 'Ang kaurian/kategoryang ito ay gumagamit ng pormularyong $1.',
	'sf_category_desc' => 'Ito ang kauriang $1.',
	'sf_blank_namespace' => 'Pangunahin',
	'right-viewedittab' => 'Tingnan ang panglaylay na "Baguhin" para sa mga pahinang mababago na ginagamitan ng pormularyo', # Fuzzy
	'right-editrestrictedfields' => 'Baguhin ang mga lugar ng ipinagbabawal na pormularyo',
	'right-createclass' => 'Lumikha ng bagong mga klaseng semantiko',
	'action-createclass' => 'lumikha ng bagong mga klaseng semantiko',
	'action-editrestrictedfields' => 'baguhin ang mga kahanayan ng ipinagbabawal na pormularyo',
	'action-viewedittab' => 'tingnan ang panglaylay na "Baguhin" para sa mga pahinang mababago sa pamamagitan ng pormularyo', # Fuzzy
);

/** Turkish (Türkçe)
 * @author Joseph
 * @author Karduelis
 * @author Suelnur
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'specialpages-group-sf_group' => 'Anlamsal Formlar',
	'createproperty' => 'Bir özellik oluştur',
	'sf_createproperty_propname' => 'Özellik ismi:',
	'sf_createproperty_proptype' => 'Tip:',
	'templates' => 'Şablonlar',
	'createtemplate' => 'Şablon oluştur',
	'sf_createtemplate_namelabel' => 'Şablon adı:',
	'sf_createtemplate_templatefields' => 'Şablon alanları',
	'sf_createtemplate_fieldname' => 'Alan adı:',
	'sf_createtemplate_displaylabel' => 'Etiketi görüntüle:',
	'sf_createtemplate_semanticproperty' => 'Anlamsal özellik:',
	'sf_createtemplate_aggregationlabel' => 'Liste için başlık:',
	'sf_createtemplate_outputformat' => 'Çıktı biçimi:',
	'sf_createtemplate_standardformat' => 'Standart', # Fuzzy
	'sf_createtemplate_addfield' => 'Alan ekle',
	'sf_createtemplate_deletefield' => 'Sil',
	'forms' => 'Formlar',
	'sf_forminputs_mandatory' => 'Zorunlu',
	'createform' => 'Form oluştur',
	'sf_createform_nameinput' => 'Form adı',
	'sf_createform_template' => 'Şablon:',
	'sf_createform_templatelabelinput' => 'Şablon etiketi (isteğe bağlı):',
	'sf_createform_field' => 'Alan:',
	'sf_createform_inputtypedefault' => '(var sayılan)',
	'sf_createform_formlabel' => 'Form etiketi:',
	'sf_createform_hidden' => 'Gizli',
	'sf_createform_removetemplate' => 'Şablon kaldır',
	'sf_createform_addtemplate' => 'Şablon ekle:',
	'sf_createform_beforetemplate' => 'Şablondan önce:',
	'sf_createform_add' => 'Ekle',
	'sf_createform_choosefield' => 'Eklenecek bir alan seçin',
	'createcategory' => 'Bir kategori oluştur',
	'sf_createcategory_name' => 'Kategori ismi:',
	'sf_createcategory_defaultform' => 'Var sayılan form:',
	'sf_createclass_allowedvalues' => 'İzin verilen değerler', # Fuzzy
	'sf_createclass_listofvalues' => 'Değerlerin listesi', # Fuzzy
	'sf_createclass_create' => 'Oluştur',
	'formstart' => 'Form ile sayfa ekle',
	'sf_formstart_createoredit' => 'Oluştur veya düzelt',
	'sf_viewform' => 'Formu gör',
	'sf_editsource' => 'Kaynak düzelt',
	'sf_formedit_remove' => 'Kaldır',
	'sf_formedit_none' => 'Hiçbiri',
	'sf_runquery_additionalquery' => 'Ek sorgu',
	'sf_blank_error' => 'boş olamaz',
	'sf_bad_number_error' => 'geçerli bir sayı olmalı',
	'sf_bad_date_error' => 'geçerli bir tarih olmalı',
	'sf_form_freetextlabel' => 'Serbest metin',
	'sf_category_desc' => 'Bu $1 kategorisidir.',
	'sf_blank_namespace' => 'Ana',
	'right-editrestrictedfields' => 'Kısıtlanmış form alanlarını değiştirir',
);

/** Tatar (Cyrillic script) (татарча)
 * @author Ерней
 */
$messages['tt-cyrl'] = array(
	'sf_createform_inputtypedefault' => '(килешү буенча)',
);

/** Central Atlas Tamazight (ⵜⴰⵎⴰⵣⵉⵖⵜ)
 * @author Tifinaghes
 */
$messages['tzm'] = array(
	'sf_createproperty_proptype' => 'ⴰⵏⴰⵡ:',
	'sf_createform_atend' => 'ⴳ ⵓⵏⴳⴳⴰⵔⵓ',
);

/** Ukrainian (українська)
 * @author AS
 * @author Ahonc
 * @author Base
 * @author Microcell
 * @author Olvin
 * @author Prima klasy4na
 * @author Steve.rusyn
 * @author Тест
 */
$messages['uk'] = array(
	'semanticforms-desc' => 'Форми для додавання і редагування семантичних даних',
	'specialpages-group-sf_group' => 'Семантичні форми',
	'createproperty' => 'Створити властивість',
	'sf-createproperty-with-name' => 'Створити властивість: $1',
	'sf_createproperty_linktoform' => 'Ця властивість містить посилання на сторінки, які використовують форму:',
	'sf_createproperty_allowedvalsinput' => 'Якщо Ви хочете, щоб дана властивість могла мітити тільки певні значення, введіть список дозволених значень, розділених комами (якщо значення містить кому, замініть її на «\\,»):',
	'sf_createproperty_propname' => 'Назва властивості:',
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблони',
	'sf_templates_docu' => 'Наступні шаблони існують у вікі.',
	'sf_templates_definescat' => 'визначає категорію: $1',
	'createtemplate' => 'Створити шаблон',
	'sf-createtemplate-with-name' => 'Створити шаблон: $1',
	'sf_createtemplate_namelabel' => 'Назва шаблона:',
	'sf_createtemplate_multipleinstance' => 'Цей шаблон може бути включено декілька разів на сторінку.',
	'sf_createtemplate_categorylabel' => "Категорія, що визначається шаблоном (необов'язково):",
	'sf_createtemplate_templatefields' => 'Поля шаблону',
	'sf_createtemplate_fieldname' => 'Назва поля:',
	'sf_createtemplate_displaylabel' => 'Показувати підпис:',
	'sf_createtemplate_semanticproperty' => 'Семантична властивість:',
	'sf_createtemplate_aggregationlabel' => 'Заголовок списку:',
	'sf_createtemplate_outputformat' => 'Формат виводу:',
	'sf_createtemplate_standardformat' => 'Таблиця',
	'sf_createtemplate_infoboxformat' => 'Бокова картка',
	'sf_createtemplate_plainformat' => 'Простий текст',
	'sf_createtemplate_sectionsformat' => 'Розділи',
	'sf_createtemplate_addfield' => 'Додати поле',
	'sf_createtemplate_deletefield' => 'Вилучити',
	'forms' => 'Форми',
	'sf_forminputs_class' => 'HTML-атрибут «class» для цього поля вводу',
	'sf_forminputs_topcategory' => "Батьківська категорія для цього набору категорій (обов'язково)",
	'sf_forminputs_hideroot' => 'Приховати батьківську категорію',
	'sf_forminputs_depth' => 'Число рівнів категорій для показу початково',
	'sf_forminputs_height' => 'Висота цього вводу, у піселях',
	'sf_forminputs_width' => 'Ширина цього вводу, у пікселях',
	'createform' => 'Створити форму',
	'sf-createform-with-name' => 'Створити форму: $1',
	'sf_createform_nameinput' => 'Назва форми',
	'sf_createform_nameinputdesc' => '(форму зазвичай називають так само, як і її головний шаблон):',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_templatelabelinput' => "Позначка шаблону (необов'язково):",
	'sf_createform_allowmultiple' => 'Дозволити декілька (або нуль) включень цього шаблону на створюваній сторінці', # Fuzzy
	'sf_createform_field' => 'Поле:',
	'sf_createform_fieldprop' => 'Це поле визначає властивість $1 типу $2.',
	'sf_createform_fieldproplist' => 'Це поле визначає список елементів, що мають властивість $1 типу $2.',
	'sf_createform_fieldpropunknowntype' => 'Це поле визначає властивість $1 невказаного типу.',
	'sf_createform_inputtype' => 'Тип вводу:',
	'sf_createform_inputtypedefault' => '(стандартно)',
	'sf_createform_formlabel' => 'Ярлик форми:',
	'sf_createform_hidden' => 'Прихована',
	'sf_createform_removetemplate' => 'Вилучити шаблон',
	'sf_createform_addtemplate' => 'Додати шаблон:',
	'sf_createform_beforetemplate' => 'Перед шаблоном:',
	'sf_createform_atend' => 'У кінці',
	'sf_createform_add' => 'Додати',
	'sf_createform_choosefield' => 'Оберіть поле для додавання',
	'createcategory' => 'Створити категорію',
	'sf-createcategory-with-name' => 'Створити категорію: $1',
	'sf_createcategory_name' => 'Назва категорії:',
	'sf_createcategory_defaultform' => 'Форма за умовчанням:',
	'sf_createcategory_makesubcategory' => "Зробити це підкатегорією іншої категорії (необов'язково):",
	'createclass' => 'Створити клас',
	'sf_createclass_docu' => 'Введіть тут усі дані для створення властивостей, шаблону, форми і категорії для одного класу. Для більшого числа опцій, використовуйте сторінку $1.',
	'sf_createclass_allowedvalues' => 'Дозволені значення:',
	'sf_createclass_listofvalues' => 'Список значень?',
	'sf_createclass_nameinput' => 'Назва форми:',
	'sf_createclass_missingvalues' => 'Не всі необхідні поля було заповнено.',
	'sf_createclass_success' => 'Властивості, шаблони, форми і категорії буде створено.',
	'sf_createclass_create' => 'Створити',
	'formstart' => 'Додати сторінку з формою',
	'sf_formstart_badform' => 'Помилка: На сторінці «$1» не знайдено форм.',
	'sf_formstart_badtitle' => 'Помилка: «$1» — недопустима назва сторінки.',
	'sf_formstart_createoredit' => 'Створити або редагувати',
	'formedit' => 'Редагувати з формою',
	'sf_formedit_createtitle' => 'Створити $1: $2',
	'sf_formedit_createtitlenotarget' => 'Створити $1',
	'sf_formedit_altforms' => 'Ви можете замість цього додати цю сторінку за допомогою однієї із наступних форм:',
	'sf_formedit_altformsonly' => 'Будь ласка, оберіть одну із наступних форм для додання цієї сторінки:',
	'sf_formcreate' => 'Створити із формою',
	'sf_viewform' => 'Переглянути форму',
	'sf_editsource' => 'Редагувати вихідний код',
	'sf_formedit_edittitle' => 'Редагування $1: $2',
	'sf_formedit_morethanoneform' => "'''Увага:''' Визначено більше ніж одну форму за замовчуванням для цієї сторінки.",
	'sf_formedit_formwarning' => 'Попередження: Ця сторінка <a href="$1">вже існує</a>, але не використовує цю форму.',
	'sf_formedit_remove' => 'Вилучити', # Fuzzy
	'sf_formedit_addanother' => 'Додати іншу',
	'sf_formedit_none' => 'Нічого',
	'sf_formedit_saveandcontinueediting' => 'Зберегти і продовжити',
	'sf_formedit_saveandcontinue_summary' => 'Збережено використовуючи кнопку «$1» у формі',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Зберегти дані і продовжити редагування',
	'sf_autoedit_anoneditwarning' => 'Увага: Ви не увійшли до системи. Вашу IP-адресу буде записано у історії редагування цієї сторінки.',
	'sf_autoedit_success' => 'Успішно змінено [[$1]] використовуючи форму $2.',
	'sf_autoedit_fail' => 'Не вдалося змінити [[$1]].',
	'sf_autoedit_notargetspecified' => 'Не вказано цільової сторінки.',
	'sf_autoedit_invalidtargetspecified' => 'Вказано неправильну цільову сторінку $1.',
	'sf_autoedit_invalidform' => '$1 не є правильною формою.',
	'sf_autoedit_redirectlimitexeeded' => 'Перевищено максимальне число перенаправлень для форми $1.',
	'sf_autoedit_redlinkexists' => '$1 вже існує.',
	'sf_autoedit_noformfound' => 'Не вказано жодної форми.',
	'sf_autoedit_toomanyformsfound' => 'Для сторінки доступно більше ніж 1 форма.',
	'sf_autoedit_readonly' => 'Наразі базу даних захищено від змін. Причина: $1',
	'sf-autoedit-wait' => 'Зачекайте...',
	'runquery' => 'Запустити запит',
	'sf_runquery_title' => 'Виконати запит:$1',
	'sf_runquery_additionalquery' => 'Додатковий запит',
	'sf_blank_error' => 'не може бути порожнім',
	'sf_bad_url_error' => 'повинне мати правильний формат URL, розпочинатись із «http»',
	'sf_bad_email_error' => 'повинне мати правильний формат адреси електронної пошти',
	'sf_bad_number_error' => 'повинно бути числом',
	'sf_bad_date_error' => 'повинно бути датою',
	'uploadwindow' => 'Вікно завантаження',
	'sf_deletionlog' => 'Журнал вилучень',
	'sf-preview-header' => 'Попередній перегляд форми',
	'sf-pageschemas-createtitle' => 'Назва форми для нових сторінок:',
	'sf-pageschemas-edittitle' => 'Назва форми для існуючих сторінок:',
	'sf-pageschemas-inputtype' => 'Тип вводу (залиште порожнім для встановлення за замовчуванням):',
	'sf_property_isproperty' => 'Це властивість типу $1.',
	'sf_property_linkstoform' => 'Посилання на сторінки, що використовують форму $1.',
	'sf_category_hasdefaultform' => 'Ця категорія використовує фому $1.',
	'sf_category_desc' => 'Це категорія $1.',
	'sf_blank_namespace' => 'Головне',
	'right-viewedittab' => 'Вкладка «{{int:edit}}» для сторінок, які можна редагувати через форму',
	'right-editrestrictedfields' => 'Редагування захищених полів форми',
	'right-createclass' => 'Створювати нові семантичні класи',
	'action-createclass' => 'створення нових семантичних класів',
	'action-editrestrictedfields' => 'редагування захищених полів форми',
);

/** Urdu (اردو)
 * @author පසිඳු කාවින්ද
 */
$messages['ur'] = array(
	'sf_createproperty_proptype' => 'قسم:',
	'templates' => 'سانچے',
	'createtemplate' => 'ایک سانچے تخلیق کریں',
	'sf_createtemplate_namelabel' => 'سانچے کے نام:',
	'sf_createtemplate_fieldname' => 'میدان کا نام:',
	'sf_createtemplate_displaylabel' => 'ڈسپلے لیبل:',
	'sf_createtemplate_standardformat' => 'ٹیبل',
	'sf_createtemplate_sectionsformat' => 'حصوں',
	'sf_createtemplate_deletefield' => 'حذف کریں',
	'forms' => 'فارم',
	'createform' => 'ایک شکل تخلیق کریں',
	'sf_createform_nameinput' => 'فارم کے نام',
	'sf_createform_template' => 'سانچہ:',
	'sf_createform_field' => 'میدان:',
	'sf_createform_inputtype' => 'ان پٹ کی قسم:',
	'sf_createform_inputtypedefault' => '(طے شدہ)',
	'sf_createform_hidden' => 'پوشیدہ',
	'sf_createform_removetemplate' => 'سانچے کو حذف کریں',
	'sf_createform_addtemplate' => 'سانچے شامل کریں:',
	'sf_createform_beforetemplate' => 'سانچہ: سے پہلے',
	'sf_createform_add' => 'شامل کریں',
	'createcategory' => 'ایک قسم کی تخلیق',
	'sf_createcategory_name' => 'شعبے کا نام:',
	'sf_createcategory_defaultform' => 'پہلے سے طے شدہ فارم:',
	'createclass' => 'ایک کلاس کی تخلیق',
	'sf_createclass_nameinput' => 'فارم کے نام:',
	'sf_createclass_create' => 'تخلیق کریں',
);

/** Veps (vepsän kel’)
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'sf_createproperty_propname' => 'Ičendan nimi:',
	'sf_createproperty_proptype' => 'Tip:',
	'templates' => 'Šablonad',
	'sf_templates_docu' => 'Wikiš om ningoižid šablonoid:',
	'sf_templates_definescat' => 'märhapaneb kategorijan: $1',
	'createtemplate' => 'Säta šablon',
	'sf_createtemplate_namelabel' => 'Šablonan nimi:',
	'sf_createtemplate_categorylabel' => 'Kategorii, kudamban märhapaneb šablon (opcionaližikš):',
	'sf_createtemplate_templatefields' => 'Šablonan pöudod:',
	'sf_createtemplate_outputformat' => 'Lähtmižformat:',
	'sf_createtemplate_standardformat' => 'Standartine', # Fuzzy
	'sf_createtemplate_addfield' => 'Läžata pöud',
	'sf_createtemplate_deletefield' => 'Čuta poiš',
	'forms' => 'Formad',
	'createform' => 'Säta form',
	'sf_createform_nameinput' => 'Forman nimi',
	'sf_createform_template' => 'Šablon:',
	'sf_createform_field' => 'Pöud:',
	'sf_createform_hidden' => 'Peittud',
	'sf_createform_add' => 'Ližata',
	'createcategory' => 'Säta kategorii',
	'sf_createcategory_name' => 'Kategorijan nimi:',
	'sf_createcategory_defaultform' => 'Form augotižjärgendusen mödhe:',
	'sf_formstart_createoredit' => 'Ližada vai redaktirui', # Fuzzy
	'sf_editsource' => 'Redaktiruida purde',
	'sf_formedit_remove' => 'Čuta poiš',
	'sf_formedit_addanother' => 'Ližata völ',
	'sf_form_freetextlabel' => 'Joudai tekst',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'semanticforms-desc' => 'Mẫu để thêm và sửa đổi dữ liệu ngữ nghĩa',
	'specialpages-group-sf_group' => 'Mẫu Ngữ Nghĩa',
	'createproperty' => 'Tạo một thuộc tính',
	'sf_createproperty_linktoform' => 'Thuộc tính này sẽ liên kết đến các trang sử dụng mẫu:',
	'sf_createproperty_allowedvalsinput' => 'Nếu bạn muốn thuộc tính này chỉ cho phép một số giá trị nào đó, hãy nhập vào danh sách các giá trị cho phép, phân cách nhau bằng dấu phẩy (nếu một giá trị có chứa dấu phẩy, hãy thay nó bằng “\\,”):',
	'sf_createproperty_propname' => 'Tên thuộc tính:',
	'sf_createproperty_proptype' => 'Loại:',
	'templates' => 'Bản mẫu',
	'sf_templates_docu' => 'Các bản mẫu sau có trong wiki.',
	'sf_templates_definescat' => 'định nghĩa thể loại: $1',
	'createtemplate' => 'Tạo bản mẫu',
	'sf_createtemplate_namelabel' => 'Tên bản mẫu:',
	'sf_createtemplate_categorylabel' => 'Thể loại do bản mẫu định nghĩa (tùy chọn):',
	'sf_createtemplate_templatefields' => 'Các trường trong bản mẫu',
	'sf_createtemplate_fieldsdesc' => 'Để dùng các trường không cần tên trong bản mẫu, chỉ cần gõ vào thứ tự mỗi trường (như 1, 2, 3, v.v.) thay vì tên thật sự.',
	'sf_createtemplate_fieldname' => 'Tên trường:',
	'sf_createtemplate_displaylabel' => 'Hiển thị nhãn:',
	'sf_createtemplate_semanticproperty' => 'Thuộc tính ngữ nghĩa:',
	'sf_createtemplate_fieldislist' => 'Trường này có thể chứa nhiều giá trị, cách nhau bằng dấu phẩy',
	'sf_createtemplate_aggregation' => 'Tập hợp',
	'sf_createtemplate_aggregationdesc' => 'Để liệt kê tất cả các bài viết có thuộc tính nào đó tại trang dùng bản mẫu này, hãy chỉ định thuộc tính thích hợp ở dưới:',
	'sf_createtemplate_aggregationlabel' => 'Đề mục cho danh sách:',
	'sf_createtemplate_outputformat' => 'Định dạng xuất:',
	'sf_createtemplate_standardformat' => 'Bảng',
	'sf_createtemplate_infoboxformat' => 'Hộp thông tin bên',
	'sf_createtemplate_plainformat' => 'Văn bản thuần',
	'sf_createtemplate_addfield' => 'Thêm trường',
	'sf_createtemplate_deletefield' => 'Xóa',
	'sf_createtemplate_addtemplatebeforesave' => 'Bạn phải thêm vào ít nhất một bản mẫu vào mẫu trước khi bạn có lưu nó lại.',
	'forms' => 'Các biểu mẫu',
	'sf_forms_docu' => 'Các mẫu dưới đây có trong wiki.',
	'sf_forminputs_mandatory' => 'Bắt buộc',
	'sf_forminputs_restricted' => 'Chỉ có bảo quản viên mới được thay đổi đầu vào này',
	'createform' => 'Tạo ra biểu mẫu',
	'sf_createform_nameinput' => 'Tên biểu mẫu',
	'sf_createform_nameinputdesc' => '(quy ước là đặt tên biểu mẫu theo bản mẫu chính mà nó điền):',
	'sf_createform_template' => 'Bản mẫu:',
	'sf_createform_templatelabelinput' => 'Nhãn bản mẫu (tùy chọn):',
	'sf_createform_allowmultiple' => 'Cho phép nhiều (hoặc không) thực thể của bản mẫu này trong trang được tạo',
	'sf_createform_field' => 'Trường:',
	'sf_createform_fieldprop' => 'Trường này định nghĩa tính chất $1, thuộc kiểu $2.',
	'sf_createform_fieldproplist' => 'Trường này định nghĩa danh sách các phần tử có tính chất $1, thuộc kiểu $2.',
	'sf_createform_fieldpropunknowntype' => 'Trường này định nghĩa tính chất $1, thuộc kiểu không xác định.',
	'sf_createform_inputtype' => 'Kiểu nhập vào:',
	'sf_createform_inputtypedefault' => '(mặc định)',
	'sf_createform_formlabel' => 'Nhãn cho mẫu:',
	'sf_createform_hidden' => 'Ẩn',
	'sf_createform_removetemplate' => 'Xóa bỏ bản mẫu',
	'sf_createform_addtemplate' => 'Thêm bản mẫu:',
	'sf_createform_beforetemplate' => 'Trước bản mẫu:',
	'sf_createform_atend' => 'Vào cuối',
	'sf_createform_add' => 'Thêm',
	'sf_createform_choosefield' => 'Chọn một trường để thêm vào',
	'createcategory' => 'Tạo thể loại',
	'sf_createcategory_name' => 'Tên thể loại:',
	'sf_createcategory_defaultform' => 'Biểu mẫu mặc định:',
	'sf_createcategory_makesubcategory' => 'Chuyển cái này thành thể loại con của một thể loại khác (tùy chọn):',
	'createclass' => 'Tạo lớp',
	'sf_createclass_docu' => 'Nhập tất cả dữ liệu tại đây để khởi tạo thuộc tính, bản mẫu, mẫu đơn và thể loại dành cho một lớp đơn. Để có thêm tùy chọn, hãy dùng trang $1.',
	'sf_createclass_allowedvalues' => 'Giá trị cho phép:',
	'sf_createclass_listofvalues' => 'Danh sách giá trị?',
	'sf_createclass_nameinput' => 'Tên biểu mẫu:',
	'sf_createclass_missingvalues' => 'Các ô bắt buộc chưa được điền đầy đủ.',
	'sf_createclass_success' => 'Thuộc tính, bản mẫu, mẫu đơn và thể loại sẽ được khởi tạo.',
	'sf_createclass_create' => 'Tạo',
	'formstart' => 'Dùng mẫu để thêm trang',
	'sf_formstart_badform' => 'Lỗi: không có trang mẫu nào tìm thấy tại $1',
	'sf_formstart_docu' => 'Nhập vào tên trang ở đây, để có thể sửa đổi với mẫu ‘$1’. Nếu trang này đã tồn tại, bạn sẽ được chuyển đến mẫu để sửa đổi trang đó. Nếu không, bạn sẽ được chuyển đến mẫu để thêm trang.',
	'sf_formstart_noform_docu' => 'Nhập tên trang vào đây, và chọn mẫu để sửa đổi với nó. Nếu trang này đã tồn tại, bạn sẽ được chuyển tới mẫu sửa đổi trang. Nếu không, bạn sẽ được chuyển đến mẫu để thêm trang.',
	'sf_formstart_createoredit' => 'Tạo hay sửa đổi',
	'formedit' => 'Sửa bằng mẫu',
	'sf_formedit_createtitle' => 'Tạo $1: $2',
	'sf_formedit_createtitlenotarget' => 'Tạo $1',
	'sf_formedit_badurl' => 'Đây là trang để sửa đổi bằng biểu mẫu. Bạn phải xác định cả tên biểu mẫu và trang đích trong địa chỉ URL; nó sẽ có dạng là “{{ns:Special}}:FormEdit?form=<form name>&target=<target page>” hoặc “{{ns:Special}}:FormEdit/<form name>/<target page>”.',
	'sf_formedit_altforms' => 'Thay vào đó bạn có thể thêm trang này vào một trong những mẫu sau:',
	'sf_formedit_altformsonly' => 'Xin chọn một trong những mẫu dưới đây để thêm vào trang này:',
	'sf_formcreate' => 'Tạo bằng biểu mẫu',
	'sf_viewform' => 'Xem mẫu',
	'sf_editsource' => 'Sửa đổi mã nguồn',
	'sf_formedit_edittitle' => 'Sửa đổi $1: $2',
	'sf_formedit_morethanoneform' => 'Cảnh báo: Có nhiều hơn một mẫu đơn mặc định được định nghĩa cho trang này.',
	'sf_formedit_formwarning' => 'Cảnh báo: Trang này <a href="$1">đã tồn tại</a>, nhưng nó không dùng mẫu này.',
	'sf_formedit_remove' => 'Dời',
	'sf_formedit_addanother' => 'Thêm tiếp',
	'sf_formedit_none' => 'Không có',
	'sf_formedit_saveandcontinueediting' => 'Lưu và tiếp tục',
	'sf_formedit_tooltip_saveandcontinueediting' => 'Lưu dữ liệu và tiếp tục sửa đổi',
	'sf-autoedit-wait' => 'Xin chờ…',
	'runquery' => 'Chạy truy vấn',
	'sf_runquery_title' => 'Chạy truy vấn: $1',
	'sf_formerrors_header' => 'Có lỗi với dữ liệu nhập mẫu của bạn; xem ở dưới',
	'sf_blank_error' => 'không được để trống',
	'sf_bad_url_error' => 'phải có định dạng URL đúng, bắt đầu bằng ‘http’',
	'sf_bad_email_error' => 'phải có định dạng địa chỉ thư điện tử đúng',
	'sf_bad_number_error' => 'phải có số đúng',
	'sf_bad_date_error' => 'phải là ngày đúng',
	'uploadwindow' => 'Cửa sổ tải',
	'sf_deletionlog' => 'Nhật trình xóa',
	'sf_property_isproperty' => 'Đây là tính chất thuộc kiểu $1.',
	'sf_property_linkstoform' => 'Nó liên kết đến các trang sử dụng mẫu $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Giá trị|Các giá trị}} cho phép của thuộc tính này là:',
	'sf_template_docu' => 'Đây là bản mẫu “$1”. Nó nên được gọi theo định dạng sau:',
	'sf_template_docufooter' => 'Sửa trang để xem văn bản bản mẫu.',
	'sf_form_docu' => 'Đây là biểu mẫu “$1”. Để tạo trang bằng biểu mẫu này, nhập vào tên trang ở dưới. Nếu một trang với tên này đã tồn tại, bạn sẽ được chuyển đến biểu mẫu để sửa trang đó.',
	'sf_form_freetextlabel' => 'Văn bản tự do',
	'sf_category_hasdefaultform' => 'Thể loại này sử dụng mẫu $1.',
	'sf_category_desc' => 'Đây là thể loại $1.',
	'sf_blank_namespace' => 'Chính',
	'right-viewedittab' => 'Xem thẻ “Sửa đổi” tại các trang có thể sửa đổi dùng biểu mẫu', # Fuzzy
	'right-editrestrictedfields' => 'Sửa đổi các trường biểu mẫu hạn chế',
);

/** Volapük (Volapük)
 * @author Malafaya
 * @author Smeira
 */
$messages['vo'] = array(
	'sf_createproperty_propname' => 'Nem:', # Fuzzy
	'sf_createproperty_proptype' => 'Sot:',
	'templates' => 'Samafomots',
	'createtemplate' => 'Jafön samafomoti',
	'sf_createtemplate_namelabel' => 'Nem samafomota:',
	'sf_createtemplate_templatefields' => 'Fels samafomota',
	'sf_createtemplate_fieldname' => 'Felanem:',
	'sf_createtemplate_aggregationlabel' => 'Tiäd liseda:',
	'sf_createtemplate_addfield' => 'Läükön feli',
	'sf_createtemplate_deletefield' => 'Moükön',
	'sf_createtemplate_addtemplatebeforesave' => 'Mutol läükön samafomoti pu bali fomete at büä okanol dakipön oni.',
	'forms' => 'Fomets',
	'sf_forms_docu' => 'Fomets fovik dabinons in vük.',
	'createform' => 'Jafön fometi',
	'sf_createform_template' => 'Samafomot:',
	'sf_createform_field' => 'Fel:',
	'sf_createform_hidden' => 'Klänedik',
	'sf_createform_removetemplate' => 'Moükön samafomoti',
	'sf_createform_addtemplate' => 'Läükön samafomoti',
	'sf_createform_beforetemplate' => 'Bü samafomot:',
	'sf_createform_add' => 'Läükön',
	'sf_createform_choosefield' => 'Välön feli läükabik',
	'createcategory' => 'Jafön kladi',
	'sf_createcategory_name' => 'Kladanem:',
	'sf_createcategory_defaultform' => 'Fomet kösömik:',
	'sf_createcategory_makesubcategory' => 'Vedükön atosi donakladi klada votik (no peflagon):',
	'formstart' => 'Läükön padi me fomet',
	'sf_formstart_badform' => 'Pöl: fometapad nonik petuvon lä $1',
	'sf_formstart_docu' => 'Penolös is nemi pada, kel poredakon me fomet: „$1“.
If pad at ya dabinon, ologol fometi ad redakön padi dabinöl at.
Voto ologol fometi ad läükön padi.',
	'sf_formstart_noform_docu' => 'Penolös is padanemi e välolös fometi, me kel vilol redakön oni.
If pad at ya dabinons, ologol fometi ad redakön padi dabinöl at.
Voto ologol fometi ad läükön padi.',
	'sf_formstart_createoredit' => 'Jafön u votükön',
	'formedit' => 'Redakön me fomet',
	'sf_formedit_createtitle' => 'Jafön $1: $2-i',
	'sf_formedit_badurl' => 'Pad at pagebon ad läükön nünodis. Mutoy penön fometanemi e zeilapadi ini el URL, kel muton logotön so: „Special:FormEdit?form=<fometanem>&target=<zeilapad>“, u: „Special:FormEdit/<fometanem>/<zeilapad>“.',
	'sf_formedit_altforms' => 'Kanol plao läükön padi at me bal fometas fovik:',
	'sf_formedit_altformsonly' => 'Välolös bali fometas sököl ad läükön padi at:',
	'sf_viewform' => 'Logön fometi',
	'sf_editsource' => 'Redakön fonäti',
	'sf_formedit_edittitle' => 'Votükön $1: $2',
	'sf_formedit_formwarning' => 'Nuned: Pad at <a href="$1">ya dabinon</a>, ab no gebon fometi at.',
	'sf_formedit_remove' => 'Moükön',
	'sf_formedit_addanother' => 'Läükön votiki',
	'sf_formedit_none' => 'Nonik',
	'sf_blank_error' => 'no dalon vagön',
	'sf_bad_url_error' => 'muton labön fomäti verätik ela URL, primölo me el „http“.',
	'sf_bad_email_error' => 'muton labön fomäti ladeta leäktronik lonöföl',
	'sf_bad_number_error' => 'muton binön num lonöföl',
	'sf_bad_date_error' => 'muton binön dät lonöföl',
	'uploadwindow' => 'Löpükamafenät',
	'sf_template_docu' => 'Atos binon samafomot: „$1“.
Söton pavokön ma fomät fovik:',
	'sf_template_docufooter' => 'Redakön padi at logön samafomotavödemi.',
	'sf_form_docu' => 'Pad at binon fomet: „$1“.
Ad läükön padi me fomet at, penolös padanemi dono; if pad labü nem at ya dabinon, ologol fometi ad redakön padi dabinöl at.', # Fuzzy
	'sf_form_freetextlabel' => 'Vödem libik',
	'sf_category_hasdefaultform' => 'Klad at gebon fometi: $1.',
	'sf_category_desc' => 'Atos binon klad: $1.',
	'sf_blank_namespace' => 'Cifik',
);

/** Walloon (walon)
 * @author Srtxg
 */
$messages['wa'] = array(
	'sf_createproperty_proptype' => 'Sôre:',
	'templates' => 'Modeles',
	'sf_createtemplate_deletefield' => 'Disfacer',
	'sf_createform_template' => 'Modele:',
	'sf_createform_add' => 'Radjouter',
	'sf_createclass_create' => 'Ahiver',
	'sf_formstart_createoredit' => 'Ahiver ou candjî',
	'formedit' => 'Candjî avou formulrece',
	'sf_formedit_formwarning' => 'Asteme: cisse pådje ci <a href="$1">egzistêye dedja</a>, mins elle n\' eploye nén li formulrece.',
	'sf_formedit_remove' => 'Oister',
	'sf_formedit_addanother' => 'Radjouter ene ôte',
	'sf_formedit_none' => 'Nole',
	'sf_formedit_saveandcontinueediting' => 'Schaper et continouwer',
	'sf_autoedit_anoneditwarning' => "'''Asteme:''' Vos n' estoz nén elodjî.
Voste adresse IP serè rashiowe dins l' istwere di cisse pådje ci.",
	'sf_form_freetextlabel' => 'Tecse libe',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 * @author පසිඳු කාවින්ද
 */
$messages['yi'] = array(
	'sf_createproperty_propname' => 'אטריבוט נאמען:',
	'sf_createproperty_proptype' => 'טיפ:',
	'templates' => 'מוסטערן',
	'sf_templates_docu' => 'די פאלגנדע מוסטערן עקזיסטירן אין דער וויקי.',
	'sf_templates_definescat' => 'דעפינירט קאטעגאריע: $1',
	'createtemplate' => 'באשאפן א מוסטער',
	'sf_createtemplate_namelabel' => 'מוסטער נאמען:',
	'sf_createtemplate_templatefields' => 'מוסטער פֿעלדער',
	'sf_createtemplate_deletefield' => 'אויסמעקן',
	'sf_createform_hidden' => 'באַהאַלטן',
	'sf_createform_atend' => 'בײַם סוף',
	'sf_createform_add' => 'צולייגן',
	'createcategory' => 'שאפֿן א קאטעגאריע',
	'sf-createcategory-with-name' => 'שאפן  קאטעגאריע: $1',
	'sf_createcategory_name' => 'קאטעגאריע נאָמען:',
	'sf_createclass_create' => 'שאַפֿן',
	'sf_formedit_createtitlenotarget' => 'שאפן $1',
	'sf_viewform' => 'ווײַזן פארעם',
	'sf_editsource' => 'רעדאקטירן מקור',
	'sf_formedit_edittitle' => 'רעדאקטירן $1: $2',
	'sf_formedit_remove' => 'אַראָפּנעמען דעם אינסטאנץ',
	'sf_formedit_addanotherabove' => 'צולייגן נאך אן אינסטאנץ פאר דעם דאזיקן',
	'sf_formedit_addanother' => 'צוילייגן נאך איינס',
	'sf_formedit_none' => 'קיין',
	'sf_formedit_emptytitle' => 'גרײַז: די אימפארטירטע דאטן שאפט א ליידיגן בלאט טיטל.',
	'sf_formedit_saveandcontinueediting' => 'אויפהיטן און גיין ווײַטער',
	'sf_formedit_saveandcontinue_summary' => 'אויפגעהיט דורכן "$1" קנעפל אין פארעם',
	'sf_autoedit_redlinkexists' => '$1 עקזיסטירט שוין.',
	'sf_bad_date_error' => 'דארף זײַן א גילטיקע דאַטע',
	'sf_blank_namespace' => 'הויפט',
);

/** Chinese (China) (‪中文(中国大陆)‬)
 * @author Roc Michael <roc.no1@gmail.com>
 */
$messages['zh-cn'] = array(
	'createproperty' => '新增语意(semantic)性质',
	'sf_createproperty_allowedvalsinput' => '如果您希望此栏位只能输入特定的值,请将那些值输入此处，并以半型的逗号(,)分隔，万一您所指定的值中已包含了半型逗号，请在该逗号前加上一个反斜线(\\,)：',
	'sf_createproperty_propname' => '名称：',
	'sf_createproperty_proptype' => '型态:',
	'templates' => '样板',
	'sf_templates_docu' => '本wiki系统已含有下列的样板。',
	'sf_templates_definescat' => '定义分类(Category)： $1',
	'createtemplate' => '新增样板',
	'sf_createtemplate_namelabel' => '样板名称：',
	'sf_createtemplate_categorylabel' => '以样板定义分类(选用性的)',
	'sf_createtemplate_templatefields' => '样板栏位',
	'sf_createtemplate_fieldsdesc' => '于某个样板之内新增无须名称的栏位，仅需赋予索引值(例如： 1,2,3 等等)给这些栏位 而无须指定名称。',
	'sf_createtemplate_fieldname' => '栏位名称：',
	'sf_createtemplate_displaylabel' => '栏位标签：',
	'sf_createtemplate_semanticproperty' => '语意(Semantic)性质',
	'sf_createtemplate_fieldislist' => '本栏位能够以某些值来建立列表，那些值须以半型逗号「,」分隔。',
	'sf_createtemplate_aggregation' => '聚集(Aggregation)',
	'sf_createtemplate_aggregationdesc' => '列出所有使用本样版的页面，而那些带有特定性质指向那页面的文章，指定着如下性质：译注：To list, on any page using this template, all of the articles that have a certain property pointing to that page, specify the appropriate property below :',
	'sf_createtemplate_aggregationlabel' => '列表标题',
	'sf_createtemplate_outputformat' => '输出格式：',
	'sf_createtemplate_standardformat' => '标准型',
	'sf_createtemplate_infoboxformat' => '右置型信息招牌，广告牌',
	'sf_createtemplate_addfield' => '新增栏位',
	'sf_createtemplate_deletefield' => '删除',
	'sf_createtemplate_addtemplatebeforesave' => '在您存贮它之前，您必须为这个表单加入至少一项样板。',
	'forms' => '表单',
	'sf_forms_docu' => '本wiki系统已建有下列的表单。',
	'sf_forminputs_mandatory' => '强制性的',
	'sf_forminputs_restricted' => '受限制的页面(只有管理员可编辑)',
	'createform' => '新增表单',
	'sf_createform_nameinput' => '表单名称(大致上系以其主要的引用样板的名称来为其命名)：',
	'sf_createform_template' => '样板：',
	'sf_createform_templatelabelinput' => '样板标签(选用性的)',
	'sf_createform_allowmultiple' => '多重选项样板，此样板用于在新增页面上的多重(或无)选项。',
	'sf_createform_field' => '栏位：',
	'sf_createform_fieldprop' => '此栏定义$2型态的$1性质。',
	'sf_createform_fieldproplist' => '此栏定义一些采$2型态且带有$1质性的元件',
	'sf_createform_fieldpropunknowntype' => '此栏定义 $1性质，却未指定型态。译注原文为：This field defines the property $1, of unspecified type.',
	'sf_createform_inputtype' => '输入型态：',
	'sf_createform_inputtypedefault' => '(内定值)',
	'sf_createform_formlabel' => '表单标签。',
	'sf_createform_hidden' => '隐藏',
	'sf_createform_removetemplate' => '删除样板',
	'sf_createform_addtemplate' => '新增样板：',
	'sf_createform_beforetemplate' => '在样板之前：',
	'sf_createform_atend' => '在末端',
	'sf_createform_add' => '新增',
	'sf_createform_choosefield' => '选取欲新增的栏位',
	'createcategory' => '新增分类(Category)',
	'sf_createcategory_name' => '名称：',
	'sf_createcategory_defaultform' => '预设的表单',
	'sf_createcategory_makesubcategory' => '令此项分类(Category)成为某一分类项下的子分类(选择性使用)',
	'formstart' => '新增页面',
	'sf_formstart_badform' => '错误！在$1上并没有找到表单页面。',
	'sf_formstart_docu' => "输入页面名称以便以'$1'表单编辑。如果此页已存在的话，您便能以表单编辑该页，否则，您便能以表单新增此页面。",
	'sf_formstart_noform_docu' => '请于此处输入页面名称，再选取表单对其进行编辑，如果此页已存在的话，您便能以表单编辑该页，否则，您便能以表单新增此页面。',
	'sf_formstart_createoredit' => '新增或编辑',
	'formedit' => '以表单进行编辑',
	'sf_formedit_createtitle' => '增加 $1： $2',
	'sf_formedit_badurl' => "本页为新增资料之用，您必须在URL里同时指定表单及目标页面，它看起来应该像是'Special:FormEdit?form=<表单名称>&target=<目标页面>' 或是 'Special:FormEdit/<表单名称>/<目标页面>'。",
	'sf_formedit_altforms' => '您可选用下列其中一个的表单来新增此页',
	'sf_formedit_altformsonly' => '请从下列的表单中选出其中一个，并以该表单编辑此页：',
	'sf_editsource' => '编辑来源',
	'sf_formedit_edittitle' => '编辑 $1: $2',
	'sf_formedit_formwarning' => '警告：<a href="$1">此页</a>已经存在，只是尚未引用本表单。',
	'sf_formedit_remove' => '删除',
	'sf_formedit_addanother' => '新增其他',
	'sf_blank_error' => '不得为空白',
	'sf_bad_url_error' => "须有正确的URL格式（即以 'http'起头）",
	'sf_bad_email_error' => '必须是有效的电子邮件(Email)格式',
	'sf_bad_number_error' => '必须是有效的数字',
	'sf_bad_integer_error' => '必须是有效的整数',
	'sf_bad_date_error' => '必须是有效的日期',
	'sf_property_isproperty' => '这是$1型态的性质。',
	'sf_property_allowedvals' => '此属性的可用型态为：',
	'sf_template_docu' => "这是'$1'样板，它须以如下的格式引用：",
	'sf_template_docufooter' => '编辑此页以查看样板文字。',
	'sf_form_docu' => "这是'$1'表单，编辑此页以查看原始码，您能以此表单新增资料[[$2|这里]]。",
	'sf_form_freetextlabel' => '随意文字区(Free text)',
	'sf_category_hasdefaultform' => '此项分类(category)使用$1表单。',
	'sf_category_desc' => '这是$1分类(category)',
	'sf_blank_namespace' => '主',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Gzdavidwong
 * @author Hydra
 * @author Liangent
 * @author Linforest
 * @author PhiLiP
 * @author Shirayuki
 * @author Xiaomingyan
 * @author Yfdyh000
 */
$messages['zh-hans'] = array(
	'semanticforms-desc' => '用于添加和编辑语义数据的表单',
	'specialpages-group-sf_group' => '语义表单',
	'createproperty' => '创建一个属性',
	'sf-createproperty-with-name' => '创建属性：$1',
	'sf_createproperty_linktoform' => '这个属性将链接到使用表单的页面：',
	'sf_createproperty_allowedvalsinput' => '如果您希望此属性只允许含有特定的值，输入允许的值的列表，以逗号分隔（如果一个值包含逗号，使用“\\,”替换）：',
	'sf_createproperty_propname' => '属性名称：',
	'sf_createproperty_proptype' => '类型：',
	'templates' => '模板',
	'sf_templates_docu' => '下列模板存在于wiki中。',
	'sf_templates_definescat' => '定义分类： $1',
	'createtemplate' => '创建模板',
	'sf-createtemplate-with-name' => '创建模板：$1',
	'sf_createtemplate_namelabel' => '模板名称：',
	'sf_createtemplate_multipleinstance' => '此模板可以被多次包含在页面上。',
	'sf_createtemplate_categorylabel' => '由模板定义的分类（可选）：',
	'sf_createtemplate_templatefields' => '模板字段',
	'sf_createtemplate_fieldsdesc' => '为了让这个模板中的字段不需要字段名称，只需输入每个字段的索引（如1、2、3等）而不是实际名称作为名称。',
	'sf_createtemplate_fieldname' => '字段名：',
	'sf_createtemplate_displaylabel' => '显示标签：',
	'sf_createtemplate_semanticproperty' => '语义属性：',
	'sf_createtemplate_fieldislist' => '这个字段可以包含用逗号分隔的值的列表',
	'sf_createtemplate_aggregation' => '聚合',
	'sf_createtemplate_aggregationdesc' => '为了在使用这个模板的页面上列出所有包含指向此页面的属性的页面，在下面指定适当的属性：',
	'sf_createtemplate_aggregationlabel' => '用于列表的标题：',
	'sf_createtemplate_outputformat' => '输出格式：',
	'sf_createtemplate_standardformat' => '表格',
	'sf_createtemplate_infoboxformat' => '右侧信息框',
	'sf_createtemplate_plainformat' => '纯文本',
	'sf_createtemplate_sectionsformat' => '节',
	'sf_createtemplate_addfield' => '添加字段',
	'sf_createtemplate_deletefield' => '删除',
	'sf_createtemplate_addtemplatebeforesave' => '在您保存之前，您必须向表单添加至少一个模板。',
	'forms' => '表单',
	'sf_forms_docu' => '以下表单存在于wiki中。',
	'sf_forminputs_mandatory' => '必须为这个输入项输入值',
	'sf_forminputs_restricted' => '只有管理员才可以编辑这个输入项',
	'sf_forminputs_class' => '这个输入项的HTML“class”属性',
	'sf_forminputs_default' => '这个输入项的默认值',
	'sf_forminputs_preload' => '内容将成为此输入项默认值的wiki页面',
	'sf_forminputs_property' => '这个字段对应的语义属性',
	'sf_forminputs_size' => '以字符数表示的文本字段大小',
	'sf_forminputs_maxlength' => '在这个字段中允许的最大文本长度',
	'sf_forminputs_placeholder' => '用户单击输入框之前一直显示在其中的帮助文本',
	'sf_forminputs_uploadable' => '在这个输入项旁边放置一个“{{int:upload}}”链接',
	'sf_forminputs_defaultfilename' => '上传的文件的默认文件名',
	'sf_forminputs_rows' => '这个输入项的行数',
	'sf_forminputs_cols' => '这个输入项的列数',
	'sf_forminputs_autogrow' => '设置这个输入项增长尺寸如果文本超出了边界',
	'sf_forminputs_valuesfromproperty' => '为这个输入项提供值作为值列表的这个wiki中的属性',
	'sf_forminputs_valuesfromcategory' => '为这个输入项提供页面作为值列表的这个wiki中的分类',
	'sf_forminputs_valuesfromnamespace' => '为这个输入项提供页面作为值列表的这个wiki中的名字空间',
	'sf_forminputs_valuesfromconcept' => '为这个输入项提供页面作为值列表的这个wiki中的语义MediaWiki“概念”页面',
	'sf_forminputs_valuesfromurl' => '为这个输入项提供结构化数据作为值列表的URL',
	'sf_forminputs_values' => '这个输入项的值列表，以逗号分隔',
	'sf_forminputs_list' => '标记输入项以包含值的列表',
	'sf_forminputs_delimiter' => '两个字段值间的分隔符，如果这个输入项包含值列表',
	'sf_forminputs_remoteautocompletion' => '使用远程自动完成',
	'sf_forminputs_existingvaluesonly' => '只允许已经在列表中的值',
	'sf_forminputs_showonselect' => '如果只有特定值被选择时显示的页面元素（例如：“值1=>div1;值2=>div2”）',
	'sf_forminputs_listboxsize' => '以行数表示的列表框的高度',
	'sf_forminputs_includetimezone' => '包含用于时区的输入项',
	'sf_forminputs_topcategory' => '这些分类的上层分类（必填）',
	'sf_forminputs_hideroot' => '隐藏父类别',
	'sf_forminputs_depth' => '最初显示类别的层数',
	'sf_forminputs_height' => '以像素数表示的这个输入项的高度',
	'sf_forminputs_width' => '以像素数表示的这个输入项的宽度',
	'createform' => '创建表单',
	'sf_createform_nameinput' => '表单名称',
	'sf_createform_nameinputdesc' => '（表单通常以它的主模板命名）：',
	'sf_createform_template' => '模板:',
	'sf_createform_templatelabelinput' => '模板标签（可选）：',
	'sf_createform_allowmultiple' => '在创建的页面中允许多个（或零个）此模板的实例', # Fuzzy
	'sf_createform_field' => '事件:',
	'sf_createform_fieldprop' => '这个字段定义类型$2的属性$1。',
	'sf_createform_fieldproplist' => '这个字段定义含有类型$2的属性$1的元素列表。',
	'sf_createform_fieldpropunknowntype' => '这个字段定义未指定类型的属性$1。',
	'sf_createform_inputtype' => '输入项类型：',
	'sf_createform_inputtypedefault' => '(默认)',
	'sf_createform_formlabel' => '表单标签：',
	'sf_createform_hidden' => '隐藏',
	'sf_createform_removetemplate' => '移除模板',
	'sf_createform_addtemplate' => '添加模板：',
	'sf_createform_beforetemplate' => '在模板前：',
	'sf_createform_atend' => '在最后',
	'sf_createform_add' => '添加',
	'sf_createform_choosefield' => '选择要添加的字段',
	'createcategory' => '创造一个分类',
	'sf_createcategory_name' => '分类名：',
	'sf_createcategory_defaultform' => '默认表单：',
	'sf_createcategory_makesubcategory' => '将这个设置成另一分类的子分类（可选）：',
	'createclass' => '创建类',
	'sf_createclass_docu' => '在这里输入为一个类创建属性、模板、表单和分类的所有数据。使用页面$1代替以使用更多选项。',
	'sf_createclass_allowedvalues' => '允许取值：',
	'sf_createclass_listofvalues' => '取值列表？',
	'sf_createclass_nameinput' => '表单名称：',
	'sf_createclass_missingvalues' => '有必填字段没有填写。',
	'sf_createclass_success' => '属性、模板、表单和分类将被创建。',
	'sf_createclass_create' => '创建',
	'formstart' => '开始表单',
	'sf_formstart_badform' => '错误：在$1没有找到表单页面。',
	'sf_formstart_badtitle' => '错误：“$1”不是有效的页面标题。',
	'sf_formstart_docu' => '在这里输入页面名，以用表单“$1”编辑。
如果页面已经存在，您将被送到编辑页面的表单。
否则，您将被送到添加页面的表单。',
	'sf_formstart_noform_docu' => '在这里输入页面名，并选择用来编辑它的表单。
如果页面已经存在，您将被送到编辑页面的表单。
否则，您将被送到添加页面的表单。',
	'sf_formstart_createoredit' => '创建或编辑',
	'formedit' => '用表格编辑',
	'sf_formedit_createtitle' => '创建$1：$2',
	'sf_formedit_createtitlenotarget' => '创建$1',
	'sf_formedit_badurl' => '这是用表单编辑的页面。您必须同时在URL中指定表单名和目标页面；
它看起来应该像‘Special:FormEdit?form=<表单名>&target=<目标页面>’，或者‘Special:FormEdit/<表单名>/<目标页面>’。',
	'sf_formedit_altforms' => '您也可以用下列表单添加这个页面：',
	'sf_formedit_altformsonly' => '请从下面的表单中选择一项来添加这个页面：',
	'sf_formcreate' => '用表单创建',
	'sf_viewform' => '检视表格',
	'sf_editsource' => '编辑源码',
	'sf_formedit_edittitle' => '编辑$1：$2',
	'sf_formedit_morethanoneform' => "'''警告：'''这个页面定义了多于一个的默认表单。",
	'sf_formedit_formwarning' => '警告：这个页面<a href="$1">已存在</a>，但它不使用这个表单。',
	'sf_formedit_mismatchedbrackets' => '警告：此页面之中含有尚未结束的花括号或方括号，因而该页面将不会得到表单的正确处理。请在继续之前<a href="$1">修复源文本之中的这一错误</a>。',
	'sf_formedit_remove' => '移除',
	'sf_formedit_addanother' => '添加另一个',
	'sf_formedit_none' => '无',
	'sf_formedit_emptytitle' => '错误：输入的数据生成空白页面标题。',
	'sf_formedit_hookerror' => '错误：一个MediaWiki扩展阻止对目标页面的修改。',
	'sf_formedit_saveandcontinueediting' => '保存并继续',
	'sf_formedit_saveandcontinue_summary' => '已采用表单中的"$1"按钮进行了保存',
	'sf_formedit_tooltip_saveandcontinueediting' => '保存数据并且继续编辑',
	'sf_autoedit_anoneditwarning' => '警告：您没有登录。您的IP地址将记录在此页的编辑历史中。',
	'sf_autoedit_success' => '已成功使用表单$2修改[[$1]]。',
	'sf_autoedit_notargetspecified' => '未指定目标页面。',
	'sf_autoedit_redlinkexists' => '$1已存在。',
	'sf_autoedit_noformfound' => '未指定表单。',
	'sf_autoedit_toomanyformsfound' => '有不止一个可用于页面的表单。',
	'sf_autoedit_readonly' => '数据库当前正为修改操作而被锁定。原因：$1',
	'sf_autoedit_nosemanticform' => '无法获得页面$1的表单$2。详情请参见[[{{#special:FormEdit}}/$2/$1]]。',
	'sf_autoedit_summary' => '已从页面$1当中进行了自动编辑。',
	'sf-autoedit-wait' => '等待中...',
	'runquery' => '运行查询',
	'sf_runquery_badurl' => '您必须在URL中指定表单名称；
URL应该看起来像‘Special:RunQuery/<表单名>’。',
	'sf_runquery_title' => '运行查询：$1',
	'sf_runquery_additionalquery' => '附加查询',
	'sf_formerrors_header' => '在您的表单输入中存在错误；如下所示',
	'sf_blank_error' => '不可留空',
	'sf_bad_url_error' => '必须使用正确的URL格式，以“http”开头',
	'sf_bad_email_error' => '必须使用有效的电子邮件地址格式',
	'sf_bad_number_error' => '必须为有效数字',
	'sf_bad_date_error' => '必须为有效日期',
	'uploadwindow' => '上传窗口',
	'sf_deletionlog' => '删除记录',
	'sf-preview-header' => '表单预览',
	'sf-preview-note' => '这是该表单使用时的样子：',
	'sf-pageschemas-pagenameformula' => '页面名称公式：',
	'sf-pageschemas-createtitle' => '新页面表单标题：',
	'sf-pageschemas-edittitle' => '现有页面表单标题：',
	'sf-pageschemas-inputtype' => '输入类型（要设置为默认值，请保持空白）：',
	'sf_property_isproperty' => '这是一个类型为$1的属性。',
	'sf_property_linkstoform' => '它链接到使用表单$1的页面。',
	'sf_property_allowedvals' => '允许{{PLURAL:$1|value for this property is|该属性的取值为}}:',
	'sf_template_docu' => '这是“$1”模板。
它应该以以下格式被调用：',
	'sf_template_docufooter' => '编辑页面以阅读模板文本。',
	'sf_form_docu' => '这是“$1”表单。
要用这个表单创建一个页面，在下面输入页面名；
如果使用这个名称的页面已存在，您将被送到编辑那个页面的表单。',
	'sf_form_freetextlabel' => '自由文本',
	'sf_category_hasdefaultform' => '这个分类使用表单$1。',
	'sf_category_desc' => '这是$1分类。',
	'sf_blank_namespace' => '首页',
	'right-viewedittab' => '在可以通过表单编辑的页面上查看“编辑”标签。', # Fuzzy
	'right-editrestrictedfields' => '编辑受限制的表单字段',
	'right-createclass' => '创建新的语义类',
	'action-createclass' => '创建新的语义类',
	'action-editrestrictedfields' => '编辑受限制的表单域',
	'action-viewedittab' => '查看可采用表单编辑的页面的"编辑"选项卡', # Fuzzy
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Gzdavidwong
 * @author Liangent
 * @author Mark85296341
 * @author Oapbtommy
 * @author Shirayuki
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'semanticforms-desc' => '用於添加和編輯語義數據的表單',
	'specialpages-group-sf_group' => '語義表單',
	'createproperty' => '創建一個屬性',
	'sf_createproperty_linktoform' => '這個屬性將鏈接到使用表單的頁面：',
	'sf_createproperty_allowedvalsinput' => '如果您希望此屬性只允許含有特定的值，輸入允許的值的列表，以逗號分隔（如果一個值包含逗號，使用“\\,”替換）：',
	'sf_createproperty_propname' => '屬性名稱：',
	'sf_createproperty_proptype' => '類型：',
	'templates' => '模板',
	'sf_templates_docu' => '下列模板存在於wiki中。',
	'sf_templates_definescat' => '定義分類： $1',
	'createtemplate' => '建立一個模板',
	'sf_createtemplate_namelabel' => '模板名稱：',
	'sf_createtemplate_categorylabel' => '由模板定義的分類（可選）：',
	'sf_createtemplate_templatefields' => '模板字段',
	'sf_createtemplate_fieldsdesc' => '為了讓這個模板中的字段不需要字段名稱，只需輸入每個字段的索引（如1、2、3等）而不是實際名稱作為名稱。',
	'sf_createtemplate_fieldname' => '字段名：',
	'sf_createtemplate_displaylabel' => '顯示標籤：',
	'sf_createtemplate_semanticproperty' => '語義屬性：',
	'sf_createtemplate_fieldislist' => '這個字段可以包含用逗號分隔的值的列表',
	'sf_createtemplate_aggregation' => '聚合',
	'sf_createtemplate_aggregationdesc' => '為了在使用這個模板的頁面上列出所有包含指向此頁面的屬性的頁面，在下面指定適當的屬性：',
	'sf_createtemplate_aggregationlabel' => '用於列表的標題：',
	'sf_createtemplate_outputformat' => '輸出格式：',
	'sf_createtemplate_standardformat' => '表格',
	'sf_createtemplate_infoboxformat' => '右側信息框', # Fuzzy
	'sf_createtemplate_plainformat' => '純文字',
	'sf_createtemplate_sectionsformat' => '節',
	'sf_createtemplate_addfield' => '添加字段',
	'sf_createtemplate_deletefield' => '刪除',
	'sf_createtemplate_addtemplatebeforesave' => '在您保存之前，您必須向表單添加至少一個模板。',
	'forms' => '表單',
	'sf_forms_docu' => '以下表單存在於wiki中。',
	'sf_forminputs_mandatory' => '必須為這個輸入項輸入值',
	'sf_forminputs_restricted' => '只有管理員才可以編輯這個輸入項',
	'sf_forminputs_class' => '這個輸入項的HTML“class”屬性',
	'sf_forminputs_default' => '這個輸入項的默認值',
	'sf_forminputs_preload' => '內容將成為此輸入項默認值的wiki頁面',
	'sf_forminputs_property' => '這個字段對應的語義屬性',
	'sf_forminputs_size' => '以字符數表示的文本字段大小',
	'sf_forminputs_maxlength' => '在這個字段中允許的最大文本長度',
	'sf_forminputs_placeholder' => '用戶單擊輸入框之前一直顯示在其中的幫助文本',
	'sf_forminputs_uploadable' => '在這個輸入項旁邊放置一個“上傳文件”鏈接', # Fuzzy
	'sf_forminputs_defaultfilename' => '上傳的文件的默認文件名',
	'sf_forminputs_rows' => '這個輸入項的行數',
	'sf_forminputs_cols' => '這個輸入項的列數',
	'sf_forminputs_autogrow' => '設置這個輸入項增長尺寸如果文本超出了邊界',
	'sf_forminputs_valuesfromproperty' => '為這個輸入項提供值作為值列表的這個wiki中的屬性',
	'sf_forminputs_valuesfromcategory' => '為這個輸入項提供頁面作為值列表的這個wiki中的分類',
	'sf_forminputs_valuesfromnamespace' => '為這個輸入項提供頁面作為值列表的這個wiki中的名字空間',
	'sf_forminputs_valuesfromconcept' => '為這個輸入項提供頁面作為值列表的這個wiki中的語義MediaWiki“概念”頁面',
	'sf_forminputs_valuesfromurl' => '為這個輸入項提供結構化數據作為值列表的URL',
	'sf_forminputs_values' => '這個輸入項的值列表，以逗號分隔',
	'sf_forminputs_list' => '標記輸入項以包含值的列表',
	'sf_forminputs_delimiter' => '兩個字段值間的分隔符，如果這個輸入項包含值列表',
	'sf_forminputs_remoteautocompletion' => '使用遠程自動完成',
	'sf_forminputs_existingvaluesonly' => '只允許已經在列表中的值',
	'sf_forminputs_showonselect' => '如果只有特定值被選擇時顯示的頁面元素（例如：“值1=>div1;值2=>div2”）',
	'sf_forminputs_listboxsize' => '以行數表示的列表框的高度',
	'sf_forminputs_includetimezone' => '包含用於時區的輸入項',
	'sf_forminputs_topcategory' => '這些分類的上層分類（必填）',
	'sf_forminputs_hideroot' => '隱藏父類別',
	'sf_forminputs_depth' => '最初顯示類別的層數',
	'sf_forminputs_height' => '以像素數表示的這個輸入項的高度',
	'sf_forminputs_width' => '以像素數表示的這個輸入項的寬度',
	'createform' => '創建表單',
	'sf_createform_nameinput' => '表單名稱',
	'sf_createform_nameinputdesc' => '（表單通常以它的主模板命名）：',
	'sf_createform_template' => '模板：',
	'sf_createform_templatelabelinput' => '模板標籤（可選）：',
	'sf_createform_allowmultiple' => '在創建的頁面中允許多個（或零個）此模板的實例', # Fuzzy
	'sf_createform_field' => '事件:',
	'sf_createform_fieldprop' => '這個字段定義類型$2的屬性$1。',
	'sf_createform_fieldproplist' => '這個字段定義含有類型$2的屬性$1的元素列表。',
	'sf_createform_fieldpropunknowntype' => '這個字段定義未指定類型的屬性$1。',
	'sf_createform_inputtype' => '輸入項類型：',
	'sf_createform_inputtypedefault' => '(預設)',
	'sf_createform_formlabel' => '表單標籤：',
	'sf_createform_hidden' => '隱藏',
	'sf_createform_removetemplate' => '移除模板',
	'sf_createform_addtemplate' => '添加模板：',
	'sf_createform_beforetemplate' => '在模板前：',
	'sf_createform_atend' => '在最後',
	'sf_createform_add' => '新增',
	'sf_createform_choosefield' => '選擇要添加的字段',
	'createcategory' => '創造一個分類',
	'sf_createcategory_name' => '分類名：',
	'sf_createcategory_defaultform' => '默認表單：',
	'sf_createcategory_makesubcategory' => '將這個設置成另一分類的子分類（可選）：',
	'createclass' => '創建類',
	'sf_createclass_docu' => '在這裡輸入為一個類創建屬性、模板、表單和分類的所有數據。使用頁面$1代替以使用更多選項。',
	'sf_createclass_allowedvalues' => '允許取值：',
	'sf_createclass_listofvalues' => '取值列表？',
	'sf_createclass_nameinput' => '表單名稱：',
	'sf_createclass_missingvalues' => '有必填字段沒有填寫。',
	'sf_createclass_success' => '屬性、模板、表單和分類將被創建。',
	'sf_createclass_create' => '創建',
	'formstart' => '開始表單',
	'sf_formstart_badform' => '錯誤：在$1沒有找到表單頁面。',
	'sf_formstart_badtitle' => '錯誤：“$1”不是有效的頁面標題。',
	'sf_formstart_docu' => '在這裡輸入頁面名，以用表單“$1”編輯。
如果頁面已經存在，您將被送到編輯頁面的表單。
否則，您將被送到添加頁面的表單。',
	'sf_formstart_noform_docu' => '在這裡輸入頁面名，並選擇用來編輯它的表單。
如果頁面已經存在，您將被送到編輯頁面的表單。
否則，您將被送到添加頁面的表單。',
	'sf_formstart_createoredit' => '建立或編輯',
	'formedit' => '用表單編輯',
	'sf_formedit_createtitle' => '創建$1：$2',
	'sf_formedit_createtitlenotarget' => '創建$1',
	'sf_formedit_badurl' => '這是用表單編輯的頁面。您必須同時在URL中指定表單名和目標頁面；
它看起來應該像‘Special:FormEdit?form=<表單名>&target=<目標頁面>’，或者‘Special:FormEdit/<表單名>/<目標頁面>’。',
	'sf_formedit_altforms' => '您也可以用下列表單添加這個頁面：',
	'sf_formedit_altformsonly' => '請從下面的表單中選擇一項來添加這個頁面：',
	'sf_formcreate' => '用表單創建',
	'sf_viewform' => '檢視表格',
	'sf_editsource' => '編輯源碼',
	'sf_formedit_edittitle' => '編輯$1：$2',
	'sf_formedit_morethanoneform' => "'''警告：'''這個頁面定義了多於一個的默認表單。",
	'sf_formedit_formwarning' => '警告：這個頁面<a href="$1">已存在</a>，但它不使用這個表單。',
	'sf_formedit_mismatchedbrackets' => '警告：此頁面之中含有尚未結束的花括號或方括號，因而該頁面將不會得到表單的正確處理。請在繼續之前<a href="$1">修復源文本之中的這一錯誤</a>。',
	'sf_formedit_remove' => '移除',
	'sf_formedit_addanother' => '添加另一個',
	'sf_formedit_none' => '無',
	'sf_formedit_emptytitle' => '錯誤：輸入的數據生成空白頁面標題。',
	'sf_formedit_hookerror' => '錯誤：一個MediaWiki擴展阻止對目標頁面的修改。',
	'sf_formedit_saveandcontinueediting' => '保存並繼續',
	'sf_formedit_saveandcontinue_summary' => '已採用表單中的"$1"按鈕進行了保存',
	'sf_formedit_tooltip_saveandcontinueediting' => '保存數據並且繼續編輯',
	'sf_autoedit_anoneditwarning' => '警告：您沒有登錄。您的IP地址將記錄在此頁的編輯歷史中。',
	'sf_autoedit_success' => '已成功使用表單$2修改[[$1]]。',
	'sf_autoedit_notargetspecified' => '未指定目標頁面。',
	'sf_autoedit_redlinkexists' => '$1已存在。',
	'sf_autoedit_noformfound' => '未指定表單。',
	'sf_autoedit_toomanyformsfound' => '有不止一個可用於頁面的表單。',
	'sf_autoedit_readonly' => '數據庫當前正為修改操作而被鎖定。原因：$1',
	'sf_autoedit_nosemanticform' => '無法獲得頁面$1的表單$2。詳情請參見[[{{#special:FormEdit}}/$2/$1]]。',
	'sf_autoedit_summary' => '已從頁面$1當中進行了自動編輯。',
	'sf-autoedit-wait' => '等待...',
	'runquery' => '運行查詢',
	'sf_runquery_badurl' => '您必須在URL中指定表單名稱；
URL應該看起來像‘Special:RunQuery/<表單名>’。',
	'sf_runquery_title' => '運行查詢：$1',
	'sf_runquery_additionalquery' => '附加查詢',
	'sf_formerrors_header' => '在您的表單輸入中存在錯誤；如下所示',
	'sf_blank_error' => '不可留空',
	'sf_bad_url_error' => '必須使用正確的URL格式，以“http”開頭',
	'sf_bad_email_error' => '必須使用有效的電子郵件地址格式',
	'sf_bad_number_error' => '必須為有效數字',
	'sf_bad_date_error' => '必須為有效日期',
	'uploadwindow' => '上傳窗口',
	'sf_deletionlog' => '刪除紀錄',
	'sf-preview-header' => '表單預覽',
	'sf-preview-note' => '這是該表單使用時的樣子：',
	'sf-pageschemas-pagenameformula' => '頁面名稱公式：',
	'sf-pageschemas-createtitle' => '新頁面表單標題：',
	'sf-pageschemas-edittitle' => '現有頁面表單標題：',
	'sf-pageschemas-inputtype' => '輸入類型（要設置為默認值，請保持空白）：',
	'sf_property_isproperty' => '這是一個類型為$1的屬性。',
	'sf_property_linkstoform' => '它鏈接到使用表單$1的頁面。',
	'sf_property_allowedvals' => '允許{{PLURAL:$1|value for this property is|該屬性的取值為}}:',
	'sf_template_docu' => '這是“$1”模板。
它應該以以下格式被調用：',
	'sf_template_docufooter' => '編輯頁面以閱讀模板文本。',
	'sf_form_docu' => '這是“$1”表單。
要用這個表單創建一個頁面，在下面輸入頁面名；
如果使用這個名稱的頁面已存在，您將被送到編輯那個頁面的表單。',
	'sf_form_freetextlabel' => '自由文字',
	'sf_category_hasdefaultform' => '這個分類使用表單$1。',
	'sf_category_desc' => '這是$1分類。',
	'sf_blank_namespace' => '首頁',
	'right-viewedittab' => '在可以通過表單編輯的頁面上查看“編輯”標籤。', # Fuzzy
	'right-editrestrictedfields' => '編輯受限制的表單字段',
	'right-createclass' => '創建新的語義類',
	'action-createclass' => '創建新的語義類',
	'action-editrestrictedfields' => '編輯受限制的表單域',
	'action-viewedittab' => '查看可採用表單編輯的頁面的"編輯"選項卡', # Fuzzy
);

/** Chinese (Taiwan) (‪中文(台灣)‬)
 * @author Roc michael
 */
$messages['zh-tw'] = array(
	'semanticforms-desc' => '用來新增及編輯語意資料的表單',
	'specialpages-group-sf_group' => '語意表單',
	'createproperty' => '新增性質',
	'sf_createproperty_linktoform' => '此一性質將連結至使用此表單的頁面：<br />
This property will link to pages that use the form:',
	'sf_createproperty_allowedvalsinput' => '如果您希望此欄位只能輸入特定的值,請將那些值輸入此處，並以半型的逗號(,)分隔，萬一您所指定的值中已包含了半型逗號，請在該逗號前加上一個反斜線(\\,)：',
	'sf_createproperty_propname' => '名稱：',
	'sf_createproperty_proptype' => '型態:',
	'templates' => '樣板',
	'sf_templates_docu' => '本wiki系統已含有下列的樣板。',
	'sf_templates_definescat' => '定義分類： $1',
	'createtemplate' => '新增樣板',
	'sf_createtemplate_namelabel' => '樣板名稱：',
	'sf_createtemplate_categorylabel' => '以樣板定義分類(選用性的)',
	'sf_createtemplate_templatefields' => '樣板欄位',
	'sf_createtemplate_fieldsdesc' => '於某個樣板之內新增無須名稱的欄位，僅需賦予索引值(例如： 1,2,3 等等)給這些欄位 而無須指定名稱。',
	'sf_createtemplate_fieldname' => '欄位名稱：',
	'sf_createtemplate_displaylabel' => '欄位標籤：',
	'sf_createtemplate_semanticproperty' => '語意性質',
	'sf_createtemplate_fieldislist' => '本欄位能夠以某些值來建立清單，那些值須以半型逗號「,」分隔。',
	'sf_createtemplate_aggregation' => '聚集(Aggregation)',
	'sf_createtemplate_aggregationdesc' => '請指定一項性質，若在某些頁面中該性質的值與您正在瀏覽的頁面的名稱相同時，則這些頁面將會在您正在瀏覽的頁面中被列舉出來。',
	'sf_createtemplate_aggregationlabel' => '清單標題',
	'sf_createtemplate_outputformat' => '輸出格式：',
	'sf_createtemplate_standardformat' => '標準型',
	'sf_createtemplate_infoboxformat' => '右置型訊息看板',
	'sf_createtemplate_addfield' => '新增欄位',
	'sf_createtemplate_deletefield' => '刪除',
	'sf_createtemplate_addtemplatebeforesave' => '在您儲存它之前，您必須為這個表單加入至少一項樣板。',
	'forms' => '表單',
	'sf_forms_docu' => '本wiki系統已建有下列的表單。',
	'sf_forminputs_mandatory' => '強制性的',
	'sf_forminputs_restricted' => '受限制的頁面(只有管理員可編輯)',
	'createform' => '新增表單',
	'sf_createform_nameinput' => '表單名稱(大致上係以其主要的引用樣板的名稱來為其命名)：',
	'sf_createform_template' => '樣板：',
	'sf_createform_templatelabelinput' => '樣板標籤(選用性的)',
	'sf_createform_allowmultiple' => '多重選項樣板，此樣板用於在新增頁面上的多重(或無)選項。',
	'sf_createform_field' => '欄位：',
	'sf_createform_fieldprop' => '此欄定義$2型態的$1性質。',
	'sf_createform_fieldproplist' => '此欄定義一些採$2型態且帶有$1質性的元件',
	'sf_createform_fieldpropunknowntype' => '此欄定義 $1性質，卻未指定型態。譯注原文為：This field defines the property $1, of unspecified type.',
	'sf_createform_inputtype' => '輸入型態：',
	'sf_createform_inputtypedefault' => '(內定值)',
	'sf_createform_formlabel' => '表單標籤。',
	'sf_createform_hidden' => '隱藏',
	'sf_createform_removetemplate' => '刪除樣板',
	'sf_createform_addtemplate' => '新增樣板：',
	'sf_createform_beforetemplate' => '在樣板之前：',
	'sf_createform_atend' => '在末端',
	'sf_createform_add' => '新增',
	'sf_createform_choosefield' => '選取欲新增的欄位',
	'createcategory' => '新增分類',
	'sf_createcategory_name' => '名稱：',
	'sf_createcategory_defaultform' => '預設的表單',
	'sf_createcategory_makesubcategory' => '令此項分類成為某一分類項下的子分類(選擇性使用)',
	'createclass' => '建立類別(class)',
	'sf_createclass_docu' => '使用$1頁面，於此處輸入所有資料，以建立單一類別的性質、模板、表單和分類<br />
Enter all the data here to create the properties, template, form and category for a single class. For more options, use the pages $1 instead.',
	'sf_createclass_allowedvalues' => '允許值',
	'sf_createclass_listofvalues' => '列出值(List of values)',
	'sf_createclass_missingvalues' => '並非所有用來查詢的欄位值皆已被找到了。',
	'sf_createclass_success' => '性質、模板、表單及分類將要被建立。',
	'formstart' => '新增頁面',
	'sf_formstart_badform' => '錯誤！在$1上並沒有找到表單頁面。',
	'sf_formstart_docu' => "輸入頁面名稱以便以'$1'表單編輯。如果此頁已存在的話，您便能以表單編輯該頁，否則，您便能以表單新增此頁面。",
	'sf_formstart_noform_docu' => '請於此處輸入頁面名稱，再選取表單對其進行編輯，如果此頁已存在的話，您便能以表單編輯該頁，否則，您便能以表單新增此頁面。',
	'sf_formstart_createoredit' => '新增或編輯',
	'formedit' => '以表單進行編輯',
	'sf_formedit_createtitle' => '增加 $1： $2',
	'sf_formedit_badurl' => "本頁為新增資料之用，您必須在URL裡同時指定表單及目標頁面，它看起來應該像是'Special:FormEdit?form=<表單名稱>&target=<目標頁面>' 或是 'Special:FormEdit/<表單名稱>/<目標頁面>'。",
	'sf_formedit_altforms' => '您可選用下列其中一個的表單來新增此頁',
	'sf_formedit_altformsonly' => '請從下列的表單中選出其中一個，並以該表單編輯此頁：',
	'sf_formcreate' => '以表單建立',
	'sf_viewform' => '查看表單',
	'sf_editsource' => '編輯來源',
	'sf_formedit_edittitle' => '編輯 $1: $2',
	'sf_formedit_morethanoneform' => "'''警告：'''用來編輯此頁的表單已超過一個以上了。",
	'sf_formedit_formwarning' => '警告：<a href="$1">此頁</a>已經存在，只是尚未引用本表單。',
	'sf_formedit_remove' => '刪除',
	'sf_formedit_addanother' => '新增其他',
	'sf_formedit_none' => '無',
	'runquery' => '執行查詢',
	'sf_runquery_badurl' => "您必須在URL中指定某表單，該URL應該看起來像是'特殊:執行查詢/<表單名稱>'.<br />
You must specify a form name in the URL;
the URL should look like 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => '執行查詢: $1',
	'sf_runquery_additionalquery' => '條件式查詢(Additional query)',
	'sf_formerrors_header' => '您在表單的輸入項目中有錯誤；請參考下方',
	'sf_blank_error' => '不得為空白',
	'sf_bad_url_error' => "須有正確的URL格式（即以 'http'起頭）",
	'sf_bad_email_error' => '必須是有效的電子郵件(Email)格式',
	'sf_bad_number_error' => '必須是有效的數字',
	'sf_bad_integer_error' => '必須是有效的整數',
	'sf_bad_date_error' => '必須是有效的日期',
	'uploadwindow' => '上傳檔案視窗',
	'sf_property_isproperty' => '這是$1型態的性質。',
	'sf_property_linkstoform' => '連結至使用$1表單的頁面。(It links to pages that use the form $1.)',
	'sf_property_allowedvals' => '此屬性的可用型態為：',
	'sf_template_docu' => "這是'$1'樣板，它須以如下的格式引用：",
	'sf_template_docufooter' => '編輯此頁以查看樣板文字。',
	'sf_form_docu' => "這是'$1'表單，編輯此頁以查看原始碼，您能以此表單新增資料[[$2|這裡]]。",
	'sf_form_freetextlabel' => '隨意文字區(Free text)',
	'sf_category_hasdefaultform' => '此項分類使用$1表單。',
	'sf_category_desc' => '這是$1分類',
	'sf_blank_namespace' => '主',
	'right-viewedittab' => '查看頁面的「編輯」頁籤(該頁面皆可使用表單予以編輯)',
	'right-editrestrictedfields' => '編輯受限制的表單欄位(restricted form fields)',
);
