<?php

/**
 * Internationalization file for the 'Arrays' extension.
 *
 * @since 1.3.4
 *
 * @file
 * @ingroup Arrays
 *
 * @licence MIT License
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */

$messages = array();

/** English
 * @author Jeroen De Dauw
 */
$messages['en'] = array(
	'arrays-desc' => 'Store and compute named arrays',
);

/** Message documentation (Message documentation)
 * @author Purodha
 * @author Raymond
 * @author Shirayuki
 */
$messages['qqq'] = array(
	'arrays-desc' => '{{desc|name=Arrays|url=http://www.mediawiki.org/wiki/Extension:Arrays}}',
);

/** Arabic (العربية)
 * @author Ciphers
 */
$messages['ar'] = array(
	'arrays-desc' => 'تخزين وحساب مصفوفات مسماة',
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'arrays-desc' => 'Almacenar y calcular matrices con nome',
);

/** South Azerbaijani (تورکجه)
 * @author Mousa
 */
$messages['azb'] = array(
	'arrays-desc' => 'آدلاندیریلمیش آرایه‌لری قئید ائت و حسابلا',
);

/** Bashkir (башҡортса)
 * @author Assele
 */
$messages['ba'] = array(
	'arrays-desc' => 'Исемләнгән массивтарҙы һаҡлау һәм иҫәпләү',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 */
$messages['be-tarask'] = array(
	'arrays-desc' => 'Захаваньне і вылічэньне масіваў з назвамі',
);

/** Breton (brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'arrays-desc' => 'Enrollañ ha plediñ gant an taolennoù anvet',
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'arrays-desc' => 'Sačuvaj i izračunaj imenovane nizove',
);

/** Czech (česky)
 * @author Paxt
 */
$messages['cs'] = array(
	'arrays-desc' => 'Uložit a vypočítat pojmenovaná pole',
);

/** Welsh (Cymraeg)
 * @author Pwyll
 */
$messages['cy'] = array(
	'arrays-desc' => "Storio a chyfrifo trefnau wedi'u henwi",
);

/** Danish (dansk)
 * @author Hylle
 */
$messages['da'] = array(
	'arrays-desc' => 'Gem og beregn navngivne arrays',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'arrays-desc' => 'Ermöglicht das Speichern und Nutzen definierter Datenreihen (Arrays)',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 */
$messages['diq'] = array(
	'arrays-desc' => 'Ratnayışê ke name biyê ena bınımne u hesab ke',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'arrays-desc' => 'Zmóžnja składowanje a woblicenje pomjenjonych pólowych wariablow',
);

/** Greek (Ελληνικά)
 * @author Protnet
 */
$messages['el'] = array(
	'arrays-desc' => 'Αποθήκευση και υπολογισμοί σε ονοματισμένες μεταβλητές-πίνακες',
);

/** Esperanto (Esperanto)
 * @author Blahma
 */
$messages['eo'] = array(
	'arrays-desc' => 'Memori kaj komputi nomitajn arejojn',
);

/** Spanish (español)
 * @author Armando-Martin
 */
$messages['es'] = array(
	'arrays-desc' => 'Almacenar y calcular matrices con nombre',
);

/** Persian (فارسی)
 * @author ZxxZxxZ
 */
$messages['fa'] = array(
	'arrays-desc' => 'ذخیره و محاسبهٔ آرایه‌های نام‌گذاری‌شده',
);

/** French (français)
 * @author Wyz
 */
$messages['fr'] = array(
	'arrays-desc' => 'Enregistrer et traiter les tableaux nommés',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'arrays-desc' => 'Encartar et trètar los tablôs apelâs',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'arrays-desc' => 'Almacenar e calcular táboas con nomes',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'arrays-desc' => 'Macht s Spychere un Nutze vu definierte Datezylete megli',
);

/** Hebrew (עברית)
 * @author Amire80
 */
$messages['he'] = array(
	'arrays-desc' => 'אחסון וחישוב של מערכים בעלי שמות',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'arrays-desc' => 'Pomjenowane polowe wariable składować a wobličić',
);

/** Hungarian (magyar)
 * @author Dj
 */
$messages['hu'] = array(
	'arrays-desc' => 'Nevesített tömbök tárolása és számítása',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'arrays-desc' => 'Immagazinar e computar arrays nominate',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 */
$messages['id'] = array(
	'arrays-desc' => 'Menyimpan dan menghitung larik bernama',
);

/** Italian (italiano)
 * @author Beta16
 */
$messages['it'] = array(
	'arrays-desc' => 'Memorizza e calcola matrici di nomi',
);

/** Japanese (日本語)
 * @author Shirayuki
 */
$messages['ja'] = array(
	'arrays-desc' => '連想配列への格納と利用',
);

/** Korean (한국어)
 * @author 아라
 */
$messages['ko'] = array(
	'arrays-desc' => '배열이라는 이름에 저장하고 계산',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'arrays-desc' => 'Felder met Name berääschne un faßhallde.',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'arrays-desc' => 'Späicheren a Benotze vun definéierten Tabellen',
);

/** Limburgish (Limburgs)
 * @author Pahles
 */
$messages['li'] = array(
	'arrays-desc' => 'Beneumde verzamelinge opsjloon en berekene',
);

/** Lithuanian (lietuvių)
 * @author Ignas693
 */
$messages['lt'] = array(
	'arrays-desc' => 'Saugoti ir apskaičiuoti pavadintas masyvai',
);

/** Mizo (Mizo ţawng)
 * @author RMizo
 */
$messages['lus'] = array(
	'arrays-desc' => 'Inremna dahţhatna leh chhûtna',
);

/** Basa Banyumasan (Basa Banyumasan)
 * @author StefanusRA
 */
$messages['map-bms'] = array(
	'arrays-desc' => 'Nyimpen lan ngitung larik sing dijenengi',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'arrays-desc' => 'Складирај и пресметај именувани низи',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'arrays-desc' => 'Menyimpan dan mengira tatasusunan bernama',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'arrays-desc' => 'Lagre og beregne navngitte tabeller',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'arrays-desc' => 'Benoemde verzamelingen opslaan en berekenen',
);

/** Polish (polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'arrays-desc' => 'Przechowywanie i przeliczanie nazwanych tabel',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'arrays-desc' => 'Memorisé e calcolé le tàule nominà',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'arrays-desc' => 'Armazenar e calcular matrizes designadas',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Giro720
 */
$messages['pt-br'] = array(
	'arrays-desc' => 'Armazenar e calcular matrizes designadas',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'arrays-desc' => 'Stipe e calcole le array nomenate',
);

/** Russian (русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'arrays-desc' => 'Хранение и вычисление именованных массивов',
);

/** Sinhala (සිංහල)
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'arrays-desc' => 'නම්ගත ආයිත්තම් ගබඩා කරන්න සහ පරිගණක ගත කරන්න',
);

/** Slovak (slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'arrays-desc' => 'Ukladanie a počítanie pomenovaných polí',
);

/** Slovenian (slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'arrays-desc' => 'Shrani in izračuna imenovana polja',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 */
$messages['sr-ec'] = array(
	'arrays-desc' => 'Смешта и рачуна именоване низове',
);

/** Swedish (svenska)
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'arrays-desc' => 'Lagra och beräkna namngivna arrayer',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'arrays-desc' => 'Itabi at tuusin ang pinangalanang mga hanay',
);

/** Turkish (Türkçe)
 * @author Erdemaslancan
 * @author Khutuck
 */
$messages['tr'] = array(
	'arrays-desc' => 'İsimlendirilmiş dizileri sakla ve hesapla',
);

/** Ukrainian (українська)
 * @author Sodmy
 */
$messages['uk'] = array(
	'arrays-desc' => 'Зберігання та обчислення іменованих масивів',
);

/** Veps (vepsän kel’)
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'arrays-desc' => 'Varata da lugeda nimitadud massivad',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Hydra
 */
$messages['zh-hans'] = array(
	'arrays-desc' => '存储和计算指定的数组',
);

/** Traditional Chinese (中文（繁體）‎)
 */
$messages['zh-hant'] = array(
	'arrays-desc' => '存儲和計算指定的數組',
);
