<?php
/**
 * Internationalisation file for extension intersection.
 * Old version of DynamicPageList extension used for Wikinews projects
 *
 * @file
 * @ingroup Extensions
 */

$messages= array();

$messages['en'] = array(
	'intersection-desc'          => 'Outputs a bulleted list of the most recent items residing in a category, or an intersection of several categories',
	'intersection_toomanycats'   => 'Error: Too many categories!',
	'intersection_noresults'     => 'Error: No results!',
	'intersection_noincludecats' => 'Error: You need to include at least one category, or specify a namespace!',
);

/** Message documentation (Message documentation)
 * @author Purodha
 * @author The Evil IP address
 */
$messages['qqq'] = array(
	'intersection-desc' => '{{desc}}',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'intersection_toomanycats' => 'Fout: Te veel kategorieë!',
	'intersection_noresults' => 'Fout: Geen resultate!',
	'intersection_noincludecats' => "Fout: U moet ten minste een kategorie insluit, of spesifiseer 'n naamspasie!",
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'intersection-desc' => "Quita una lista d'os elementos más recients que bi ha en una categoría u a unión de quantas categorías",
	'intersection_toomanycats' => 'Error: Masiadas categorías!',
	'intersection_noresults' => 'Error: No bi ha garra resultau!',
	'intersection_noincludecats' => "Error: Ha d'encluyir a lo menos una categoría u endicar un espacio de nombres!",
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'intersection-desc' => 'يخرج قائمة معلمة بأحدث المدخلات الساكنة في تصنيف، أو اتحاد عدة تصنيفات',
	'intersection_toomanycats' => 'خطأ: تصنيفات كثيرة جدا!',
	'intersection_noresults' => 'خطأ: لا نتائج!',
	'intersection_noincludecats' => 'خطأ: ينبغي أن تضمن تصنيفا واحدا على الأقل، أو تحدد نطاقا!',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 * @author Ramsis II
 */
$messages['arz'] = array(
	'intersection-desc' => 'بيطلع لستة مترقمة لاحدث الحاجات الموجودة فى تصنيف,او اتحاد اكتر من تصنيف',
	'intersection_toomanycats' => 'غلط:تصانيف كتيرة خالص!',
	'intersection_noresults' => 'غلط:مافيش نتايج!',
	'intersection_noincludecats' => 'غلط: لازم تحط تصنيف واحد على الأقل، أو تحدد نطاق!',
);

/** Asturian (Asturianu)
 * @author Esbardu
 */
$messages['ast'] = array(
	'intersection-desc' => 'Amuesa una llista de los elementos más recién que tenga una categoría o una xuntanza de varies categoríes',
	'intersection_toomanycats' => 'Error: ¡Demasiaes categoríes!',
	'intersection_noresults' => 'Error: ¡Nun hai resultaos!',
	'intersection_noincludecats' => 'Error: ¡Necesites amiestar a lo menos una categoría, o especificar un espaciu de nomes!',
);

/** Azerbaijani (Azərbaycanca)
 * @author Wertuose
 */
$messages['az'] = array(
	'intersection_toomanycats' => 'Xəta: Kateqoriya sayı həddindən çoxdur!',
	'intersection_noresults' => 'Xəta: Nəticə yoxdur!',
	'intersection_noincludecats' => 'Xəta: Siz ən azı bir kateqoriya əlavə etməli və ya adlar fəzası müəyyənləşdirməlisiniz!',
);

/** Bashkir (Башҡортса)
 * @author Assele
 */
$messages['ba'] = array(
	'intersection-desc' => 'Категорияға һуңғы өҫтәүҙәрҙе, йәки бер нисә категорияның киҫешеүен тамғалы исемлек рәүешендә сығара',
	'intersection_toomanycats' => 'Хата: Бигерәк күп категориялар!',
	'intersection_noresults' => 'Хата: Бер һөҙөмтә лә юҡ!',
	'intersection_noincludecats' => 'Хата: Һеҙ кәмендә бер категория индерергә йәки исемдәр арауығын билдәләргә тейешһегеҙ!',
);

/** Southern Balochi (بلوچی مکرانی)
 * @author Mostafadaneshvar
 */
$messages['bcc'] = array(
	'intersection_toomanycats' => 'DynamicPageList: بازگین دسته جات!',
	'intersection_noresults' => 'DynamicPageList: هچ نتیجه ای',
	'intersection_noincludecats' => 'لیست صفحات دینامیکی: شما لازمنت حداقل یک دسته هور کنیت یا یک نام فضایی مشخص کنیت!',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'intersection-desc' => "Выводзіць у маркіраваны сьпіс апошнія дабаўленьні да катэгорыі альбо аб'ядноўвае некалькі катэгорыяў",
	'intersection_toomanycats' => 'Памылка: Зашмат катэгорыяў!',
	'intersection_noresults' => 'Памылка: Няма вынікаў!',
	'intersection_noincludecats' => 'Памылка: Вам неабходна ўключыць хаця б адну катэгорыю альбо ўказаць прастору назваў!',
);

/** Bulgarian (Български)
 * @author DCLXVI
 * @author Spiritia
 */
$messages['bg'] = array(
	'intersection-desc' => 'Извежда списък на най-скорошните записи в дадена категория или сечение на няколко категории',
	'intersection_toomanycats' => 'Грешка: Твърде много категории!',
	'intersection_noresults' => 'Грешка: Няма резултати!',
	'intersection_noincludecats' => 'Грешка: Необходимо е да се включи поне една категория или да се посочи именно пространство!',
);

/** Bengali (বাংলা)
 * @author Bellayet
 */
$messages['bn'] = array(
	'intersection_toomanycats' => 'Error: অনেক বেশি বিষয়শ্রেণী!',
	'intersection_noresults' => 'Error: ফলাফল নাই!',
	'intersection_noincludecats' => 'ত্রুটি:আপনার অন্তত একটি বিষয়শ্রেণী যুক্ত করতে, অথবা একটি নেমস্পেস দিতে হবে!',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'intersection-desc' => 'Diskwel a ra ur roll padelliget eus ar pennadoù nevesañ en ur rummad, pe en ur skourr a veur a rummad',
	'intersection_toomanycats' => 'Error: Re a rummadoù !',
	'intersection_noresults' => "Error: Disoc'h ebet !",
	'intersection_noincludecats' => "Fazi : Ret eo deoc'h merkañ ur rummad da nebeutañ, pe spisaat un esaouenn anv",
);

/** Bosnian (Bosanski)
 * @author CERminator
 * @author Seha
 */
$messages['bs'] = array(
	'intersection-desc' => 'Izbacuje listu najčešćih tačaka koje se nalaze u kategoriji ili u sekciji nekoliko kategorija.',
	'intersection_toomanycats' => 'Greška: Previše kategorija!',
	'intersection_noresults' => 'Greška: Nema rezultata!',
	'intersection_noincludecats' => 'Greška: Potrebno je da uključite najmanje jednu kategoriju ili odredite imenski prostor!',
);

/** Catalan (Català)
 * @author Paucabot
 * @author SMP
 */
$messages['ca'] = array(
	'intersection-desc' => "Genera una llista d'elements recents en una categoria o en la intersecció de diverses.",
	'intersection_toomanycats' => 'Error: Massa categories!',
	'intersection_noresults' => 'Error: Cap resultat!',
	'intersection_noincludecats' => "Error: Heu d'incloure almenys una categoria o especificar un espai de noms!",
);

/** Czech (Česky)
 * @author Li-sung
 * @author Matěj Grabovský
 */
$messages['cs'] = array(
	'intersection-desc' => 'Vypíše seznam nejnovějších položek v kategorii nebo sjednotí několik kategorií',
	'intersection_toomanycats' => 'Error: Příliš mnoho kategorií!',
	'intersection_noresults' => 'Error: Žádné výsledky!',
	'intersection_noincludecats' => 'Error: Musíte zahrnout alespoň jednu kategorii nebo určit jmenný prostor!',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'intersection-desc' => "Yn cynhyrchu rhestr o bwyntiau bwled, o'r eitemau diweddaraf i gael eu gosod mewn categori penodol, neu mewn cyfuniad o gategorïau",
	'intersection_toomanycats' => 'Gwall: Gormod o gategorïau!',
	'intersection_noresults' => 'Gwall: Dim canlyniadau!',
	'intersection_noincludecats' => 'Gwall: Mae angen cynnwys un categori o leiaf, neu bennu parth!',
);

/** Danish (Dansk)
 * @author Peter Alberti
 */
$messages['da'] = array(
	'intersection-desc' => 'Giver en punktopstilling af de nyeste elementer i en kategori eller i foreningen af flere kategorier',
	'intersection_toomanycats' => 'Fejl: For mange kategorier!',
	'intersection_noresults' => 'Fejl: Ingen resultater!',
	'intersection_noincludecats' => 'Fejl: Du skal medtage mindst én kategori eller angive et navnerum!',
);

/** German (Deutsch)
 * @author Pill
 * @author Purodha
 * @author Raimond Spekking
 * @author Umherirrender
 */
$messages['de'] = array(
	'intersection-desc' => 'Ausgabe einer Liste der aktuellsten Einträge in einer Kategorie, oder der Schnittmenge mehrerer Kategorien',
	'intersection_toomanycats' => 'Fehler: Zu viele Kategorien!',
	'intersection_noresults' => 'Fehler: Keine Ergebnisse!',
	'intersection_noincludecats' => 'Fehler: Du musst mindestens eine Kategorie einbinden oder gib einen Namensraum an!',
);

/** German (formal address) (‪Deutsch (Sie-Form)‬)
 * @author Imre
 */
$messages['de-formal'] = array(
	'intersection_noincludecats' => 'Fehler: Sie müssen mindestens eine Kategorie einbinden oder einen Namensraum angeben!',
);

/** Zazaki (Zazaki)
 * @author Aspar
 */
$messages['diq'] = array(
	'intersection-desc' => 'yew kategori de, ya zi unsurê ke yew ra zêd pêgınayişê kategoriyan de esti, listeya maddeya nişanbiyayeyanê ıney unsuran vırazeno',
	'intersection_toomanycats' => 'xeta: kategoriyi zaf zêd ê!',
	'intersection_noresults' => 'xeta: netice çina!',
	'intersection_noincludecats' => 'xeta: tewr tay yew kategori gani têarê bıbo ya zi yew mıntıqaya nameyi diyare bıkerê!',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'intersection-desc' => 'Wudawa lisćina nejaktualnjejšych zapiskow w kategoriji abo zgromadneje młogosći někotarych kategorijow',
	'intersection_toomanycats' => 'Zmólka: Pśewjele kategorijow!',
	'intersection_noresults' => 'Zmólka: Žedne wuslědki!',
	'intersection_noincludecats' => 'Zmólka: Musyš nanejmjenjej jadnu kategoriju zapśěgnuś abo mjenjowy rum pódaś!',
);

/** Greek (Ελληνικά)
 * @author Dead3y3
 */
$messages['el'] = array(
	'intersection-desc' => 'Έχει ως έξοδο μια μη αριθμημένη λίστα των πιο πρόσφατων στοιχείων σε μια κατηγορία, ή μια τομή μερικών κατηγοριών',
	'intersection_toomanycats' => 'Σφάλμα: Πάρα πολλές κατηγορίες!',
	'intersection_noresults' => 'Σφάλμα: Δεν υπάρχουν αποτελέσματα!',
	'intersection_noincludecats' => 'Σφάλμα: Πρέπει να περιλάβετε τουλάχιστον μία κατηγορία, ή να ορίσετε μια περιοχή ονομάτων!',
);

/** Esperanto (Esperanto)
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'intersection-desc' => 'Eligas bulpunktitan liston de la plej lastaj kategorianoj, aŭ unuigo de pluraj kategorioj',
	'intersection_toomanycats' => 'Eraro: Tro da kategorioj!',
	'intersection_noresults' => 'Eraro: Neniom da rezultoj!',
	'intersection_noincludecats' => 'Eraro: Vi devas inkluzivi almenaŭ unu kategorion, aŭ specifu nomspacon!',
);

/** Spanish (Español)
 * @author Aleator
 * @author Remember the dot
 * @author Sanbec
 */
$messages['es'] = array(
	'intersection-desc' => 'Devuelve una lista de los elementos más recientes que están en una categoría o en una intersección de varias categorías',
	'intersection_toomanycats' => '¡Error: Demasiadas categorías!',
	'intersection_noresults' => 'Error: ¡Sin resultados!',
	'intersection_noincludecats' => 'Error: ¡Necesita incluir al menos una categoría, o especificar un espacio de nombres!',
);

/** Estonian (Eesti)
 * @author Avjoska
 * @author Pikne
 */
$messages['et'] = array(
	'intersection_toomanycats' => 'Tõrge: Liiga palju kategooriaid!',
	'intersection_noresults' => 'Tõrge: Tulemusi pole!',
	'intersection_noincludecats' => 'Tõrge: Lisa vähemalt üks kategooria või täpsusta nimeruum!',
);

/** Basque (Euskara)
 * @author An13sa
 */
$messages['eu'] = array(
	'intersection_toomanycats' => 'Errorea: Kategoria gehiegi!',
	'intersection_noresults' => 'Errorea: Emaitzarik ez!',
	'intersection_noincludecats' => 'Errorea: Gutxienez kategoria bat gehitu edo izen bat zehaztu behar duzu!',
);

/** Persian (فارسی)
 * @author Huji
 * @author Mjbmr
 */
$messages['fa'] = array(
	'intersection-desc' => 'فهرست گلوله‌ای از صفحه‌هایی به نمایش در می‌آورد که به تازگی در یک یا چند رده وارد شده‌اند',
	'intersection_toomanycats' => 'خطا: تعداد رده‌ها زیاد است!',
	'intersection_noresults' => 'خطا: نتیجه‌ای وجود ندارد!',
	'intersection_noincludecats' => 'خطا: شما حداقل باید یک رده را وارد کنید، یا یک فضای نام را مشخص کنید!',
);

/** Finnish (Suomi)
 * @author Nike
 */
$messages['fi'] = array(
	'intersection-desc' => 'Tulostaa listan luokassa tai useamman luokan yhdisteessä olevista sivuista.',
	'intersection_toomanycats' => 'Error: Liian monta luokkaa.',
	'intersection_noresults' => 'Error: Ei tuloksia.',
	'intersection_noincludecats' => 'Error: Lisää vähintään yksi luokka tai määritä nimiavaruus.',
);

/** French (Français)
 * @author Grondin
 * @author IAlex
 * @author Urhixidur
 * @author Verdy p
 */
$messages['fr'] = array(
	'intersection-desc' => 'Affiche une liste, à puces, des articles les plus récents dans une catégorie, ou à partir d’une combinaison de plusieurs catégories.',
	'intersection_toomanycats' => 'Erreur : trop de catégories !',
	'intersection_noresults' => 'Erreur : aucun résultat !',
	'intersection_noincludecats' => 'Erreur : vous devez inclure au moins une catégorie, ou préciser un espace de noms !',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'intersection-desc' => 'Montre una lista, de puges, des èlèments los ples novéls dens una catègorie, ou ben dês una combinèson d’un mouél de catègories.',
	'intersection_toomanycats' => 'Èrror : trop de catègories !',
	'intersection_noresults' => 'Èrror : gins de rèsultat !',
	'intersection_noincludecats' => 'Èrror : vos dête encllure u muens yona catègorie, ou ben spècefiar un èspâço de noms !',
);

/** Galician (Galego)
 * @author Toliño
 * @author Xosé
 */
$messages['gl'] = array(
	'intersection-desc' => 'Devolve unha lista punteada dos elementos máis recentes que están nunha categoría ou nunha unión de varias categorías',
	'intersection_toomanycats' => 'Erro: demasiadas categorías!',
	'intersection_noresults' => 'Erro: ningún resultado!',
	'intersection_noincludecats' => 'Erro: ten que incluír unha categoría polo menos ou especificar un espazo de nomes!',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'intersection_noresults' => 'Σφάλμα: οὐδὲν ἀποτέλεσμα',
	'intersection_noincludecats' => 'Σφάλμα: Ἔξεστί σοι περιλαμβάνειν μίαν τοὐλάχιστον κατηγορίαν, ἢ καθορίζειν ὀνοματεῖον τι!',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'intersection-desc' => 'Usgabe vun ere Lischt vu dr aktuällschte Yyträg in ere Kategorii, oder vu dr Schnittmängi vu mehrere Kategorie',
	'intersection_toomanycats' => 'Fähler: Zvyyl Kategorie!',
	'intersection_noresults' => 'Fähler: Kei Ergebnis!',
	'intersection_noincludecats' => 'Fähler: S muess zmindescht ei Kategorii yybunde wäre oder gib e Namensruum aa!',
);

/** Gujarati (ગુજરાતી)
 * @author Ashok modhvadia
 */
$messages['gu'] = array(
	'intersection-desc' => 'શ્રેણીમાં અથવા વિવિધ શ્રેણીઓનાં છેદનબિંદુમાં મોજૂદ, હાલની તાજી બાબતોની વિગતવાર યાદી દર્શાવો.',
	'intersection_toomanycats' => 'ત્રુટી:વધુ પડતી શ્રેણીઓ!',
	'intersection_noresults' => 'ત્રુટી:પરીણામ નથી!',
	'intersection_noincludecats' => 'ત્રુટી:તમારે ઓછામાં ઓછી એક શ્રેણીનો સમાવેશ કરવો, કે નામસ્થળનો ઉલ્લેખ કરવો જરૂરી છે !',
);

/** Hebrew (עברית)
 * @author Rotem Liss
 */
$messages['he'] = array(
	'intersection-desc' => 'רשימה עם תבליטים של הפריטים האחרונים המצויים בקטגוריה, או במספר קטגוריות',
	'intersection_toomanycats' => 'DynamicPageList: קטגוריות רבות מדי!',
	'intersection_noresults' => 'DynamicPageList: אין תוצאות!',
	'intersection_noincludecats' => 'DynamicPageList: עליכם לכלול לפחות קטגוריה אחת, או לציין מרחב שם!',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'intersection-desc' => 'एक श्रेणी या श्रेणीसमूहमें उपलब्ध नवीनतम लेख दर्शायें।',
	'intersection_toomanycats' => 'Error: बहुत ज्यादा श्रेणीयां!',
	'intersection_noresults' => 'Error: रिज़ल्ट नहीं!',
	'intersection_noincludecats' => 'Error: कमसे कम एक श्रेणी या नामस्थान देना अनिवार्य हैं!',
);

/** Croatian (Hrvatski)
 * @author Dalibor Bosits
 * @author Dnik
 */
$messages['hr'] = array(
	'intersection-desc' => 'Omogućava popis najnovijih stranica ili datoteka iz kategorije, ili presjeka nekoliko kategorija',
	'intersection_toomanycats' => 'Error: Previše kategorija!',
	'intersection_noresults' => 'Error: Nema rezultata!',
	'intersection_noincludecats' => 'Error: Morate uključiti bar jednu kategoriju, ili odabrati imenski prostor!',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'intersection-desc' => 'Wudaće lisćiny najaktualnišich zapiskow w jednej kategoriji abo w skupinje kategorijow',
	'intersection_toomanycats' => 'Error: Přewjele kategorijow!',
	'intersection_noresults' => 'Error: Žane wuslědki!',
	'intersection_noincludecats' => 'Error: Dyrbiš znajmjeńša kednu kategoriju zapřijeć abo mjenowy rum podać!',
);

/** Hungarian (Magyar)
 * @author Dani
 * @author Gondnok
 * @author KossuthRad
 */
$messages['hu'] = array(
	'intersection-desc' => 'Megjeleníti egy adott kategóriában, vagy kategóriák uniójában lévő legújabb szócikkek listáját',
	'intersection_toomanycats' => 'Hiba: Túl sok kategória!',
	'intersection_noresults' => 'Hiba: Nincs eredmény!',
	'intersection_noincludecats' => 'Hiba: Legalább egy listázandó kategóriát meg kell adnod, vagy pedig egy névteret!',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'intersection-desc' => 'Face un lista a punctos del elementos le plus recente in un categoria, o un union de plure categorias',
	'intersection_toomanycats' => 'Error: Troppo de categorias!',
	'intersection_noresults' => 'Error: Nulle resultato!',
	'intersection_noincludecats' => 'Error: Tu debe includer al minus un categoria, o specificar un spatio de nomines!',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 */
$messages['id'] = array(
	'intersection-desc' => 'Menghasilkan suatu daftar item terbaru pada suatu kategori atau gabungan beberapa kategori',
	'intersection_toomanycats' => 'DynamicPageList: Terlalu banyak kategori!',
	'intersection_noresults' => 'DynamicPageList: Tak ada hasil yang sesuai!',
	'intersection_noincludecats' => 'DynamicPageList: Anda perlu mencantumkan paling tidak satu kategori, atau menyebutkan satu ruang nama!',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'intersection_toomanycats' => 'Eroro: Tro multa kategorii!',
	'intersection_noresults' => 'Eroro: Nula rezultaji!',
	'intersection_noincludecats' => 'Eroro: Vu mustas inkluzar adminime un kategorio, o specigez nomaro!',
);

/** Italian (Italiano)
 * @author BrokenArrow
 * @author Darth Kule
 */
$messages['it'] = array(
	'intersection-desc' => "Visualizza un elenco puntato con gli elementi più recenti inseriti in una categoria o nell'unione di più categorie",
	'intersection_toomanycats' => 'Errore: Numero di categorie eccessivo.',
	'intersection_noresults' => 'Errore: Nessun risultato.',
	'intersection_noincludecats' => 'Errore: È necessario includere almeno una categoria oppure specificare un namespace.',
);

/** Japanese (日本語)
 * @author Fryed-peach
 * @author JtFuruhata
 */
$messages['ja'] = array(
	'intersection-desc' => '単一カテゴリ内または複数カテゴリ内において最近更新された項目を箇条書きで表示する',
	'intersection_toomanycats' => 'エラー: カテゴリ指定が多すぎます！',
	'intersection_noresults' => 'エラー: 最近更新された項目はありません！',
	'intersection_noincludecats' => 'エラー: 1つ以上のカテゴリ、または名前空間を指定する必要があります！',
);

/** Jutish (Jysk)
 * @author Huslåke
 */
$messages['jut'] = array(
	'intersection-desc' => 'Outputs en bulleted liste der senestste itemer ræsidende i en klynge, æller æ unje der severæl klynger',
	'intersection_toomanycats' => 'Error: Åverføl klynger!',
	'intersection_noresults' => 'Error: Ekke ræsultåter!',
	'intersection_noincludecats' => 'Error: Du nødst til inkludær til mendst en klynge, æller spæsifiær en navnerum!',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'intersection-desc' => 'Ngasilaké sawijining daftar item paling anyar ing sawijining kategori utawa gabungan sawetara kategori',
	'intersection_toomanycats' => 'Error: Kakèhan kategori!',
	'intersection_noresults' => 'Error: Ora ana pituwasé (kasilé)!',
	'intersection_noincludecats' => 'Error: Panjenengan perlu minimal mènèhi kategori sawiji, utawa spésifikasi bilik nama sawiji!',
);

/** Georgian (ქართული)
 * @author BRUTE
 */
$messages['ka'] = array(
	'intersection_toomanycats' => 'შეცდომა: ძალიან ბევრი კატეგორიაა!',
	'intersection_noresults' => 'შეცდომა: შედეგები არ არის!',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Thearith
 */
$messages['km'] = array(
	'intersection_toomanycats' => 'កំហុស​៖ ចំណាត់ថ្នាក់ក្រុម​ច្រើនពេក​!',
	'intersection_noresults' => 'កំហុស​៖ គ្មាន​លទ្ធផល​!',
	'intersection_noincludecats' => 'កំហុស​៖ អ្នក​ត្រូវតែ​មាន​ចំណាត់ថ្នាក់ក្រុម​មួយយ៉ាងតិច ឬ សំដៅ​មួយ​លំហឈ្មោះ​!',
);

/** Korean (한국어)
 * @author Klutzy
 * @author Kwj2772
 * @author Yknok29
 */
$messages['ko'] = array(
	'intersection-desc' => '특정 분류나 여러 분류의 집합에 속한 가장 최근에 쓰인 문서의 목록을 출력',
	'intersection_toomanycats' => '오류: 분류가 너무 많습니다!',
	'intersection_noresults' => '오류: 결과가 없습니다!',
	'intersection_noincludecats' => '오류: 분류를 추가하거나 이름공간을 명시해야 합니다!',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'intersection-desc' => 'Zeij_en Liß met de neuste Enndrääsch en en Saachjrupp, udder de neuste Enndrääsch, die en alle Jruppe uss_enem Knubbel fun Saachjrupp dren sin.',
	'intersection_toomanycats' => '<i lang="en">DynamicPageList</i> hät ene Fääler jefonge: Dat sinn_er zo vill Saachjroppe!',
	'intersection_noresults' => '<i lang="en">DynamicPageList</i> hät ene Fääler jefonge: Do kohm nix bei erus!',
	'intersection_noincludecats' => '<i lang="en">DynamicPageList</i> hät ene Fääler jefonge: Mer bruch winnischßdens ein Saachjrupp. Söns jivv e Appachtemang aan!',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'intersection-desc' => 'Generéiert eng Lëscht mat de rezentesten Androungen an eng Kategorie, oder an eng Intersektioun vu méi Kategorien',
	'intersection_toomanycats' => 'Dynamesch Säite-Lëscht: Zevill Kategorien!',
	'intersection_noresults' => 'Dynamesch Säite-Lëscht: Kee Resultat!',
	'intersection_noincludecats' => 'Dynamesch Säite-Lëscht: Dir musst mindestens eng Kategorie abannen, oder de Nummraum uginn!',
);

/** Limburgish (Limburgs)
 * @author Aelske
 * @author Matthias
 */
$messages['li'] = array(
	'intersection-desc' => 'Geeft als uitvoer een ongenummerde lijst met de meest recent toegevoegde items in een categorie, of een combinatie van categorieë',
	'intersection_toomanycats' => 'Error: Te väöl categorieë!',
	'intersection_noresults' => 'Error: Gein resultate!',
	'intersection_noincludecats' => 'Error: Geer moet tenminste ein categorie of ein naamruumde opgeve!',
);

/** Lithuanian (Lietuvių)
 * @author Matasg
 */
$messages['lt'] = array(
	'intersection_toomanycats' => 'Error: Per daug kategorijų!',
	'intersection_noresults' => 'Error: Nėra rezultatų!',
	'intersection_noincludecats' => 'Error: Jums reikia įtraukti bent vieną kategoriją, arba nurodyti vardų sritį!',
);

/** Latvian (Latviešu)
 * @author Xil
 */
$messages['lv'] = array(
	'intersection_toomanycats' => 'Kļūda: pārāk daudz kategoriju!',
);

/** Malagasy (Malagasy)
 * @author Jagwar
 */
$messages['mg'] = array(
	'intersection_toomanycats' => 'DynamicPageList : Be loatra ny sokajy',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'intersection-desc' => 'Дава список со потточки на најскорешните содржини во една категорија, или пак вкрстување на неколку категории.',
	'intersection_toomanycats' => 'Грешка: Премногу категории!',
	'intersection_noresults' => 'Грешка: Нема резултати!',
	'intersection_noincludecats' => 'Грешка: Мора да вклучите барем една категорија, или пак да наведете именски простор!',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'intersection-desc' => 'ഒരു വർഗ്ഗത്തിൽ പുതിയതായി വന്ന ഇനങ്ങളുടെ ബുള്ളറ്റ് പട്ടികയോ, അല്ലെങ്കിൽ നിരവധി വർഗ്ഗങ്ങളുടെ കൂട്ടത്തെയോ ഔട്ട് പുട്ടായി കിട്ടുന്നു.',
	'intersection_toomanycats' => 'പിഴവ്: വളരെയധികം വർഗ്ഗങ്ങൾ!',
	'intersection_noresults' => 'പിഴവ്: ഫലങ്ങൾ ഒന്നുമില്ല!',
	'intersection_noincludecats' => 'പിഴവ്: ചുരുങ്ങിയത് ഒരു വർഗ്ഗമെങ്കിലും ഉൾപ്പെടുത്തുകയോ അല്ലെങ്കിൽ ഒരു നാമമേഖല എങ്കിലും നിഷ്കർഷിച്ചിരിക്കുകയോ വേണം!',
);

/** Marathi (मराठी)
 * @author Kaustubh
 */
$messages['mr'] = array(
	'intersection-desc' => 'एखाद्या वर्गातील अथवा वर्गसमूहातील नवीनतम लेख दर्शवितो.',
	'intersection_toomanycats' => 'Error: खूप जास्त वर्ग!',
	'intersection_noresults' => 'Error: निकाल नाहीत!',
	'intersection_noincludecats' => 'Error: कमीतकमी एक वर्ग अथवा नामविश्व देणे गरजेचे आहे!',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 * @author Aviator
 */
$messages['ms'] = array(
	'intersection-desc' => 'Mengoutput senarai item terkini dalam sesebuah kategori atau kesatuan beberapa buah kategori',
	'intersection_toomanycats' => 'Ralat: Kategori terlalu banyak!',
	'intersection_noresults' => 'Error: Tiada hasil!',
	'intersection_noincludecats' => 'Error: Anda hendaklah memasukkan sekurang-kurangnya sebuah kategori atau menyatakan sebuah ruang nama!',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'intersection-desc' => 'Wiest en List mit de aktuellsten Indrääg in en Kategorie, oder de Snittmengd vun mehr Kategorien',
	'intersection_toomanycats' => 'Fehler: Toveel Kategorien!',
	'intersection_noresults' => 'Fehler: Nix funnen!',
	'intersection_noincludecats' => 'Fehler: Dor mutt opminnst een Kategorie angeven warrn! ODer geev en Naamruum an.',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'intersection-desc' => 'Geeft als uitvoer een ongenummerde lijst met de meest recent toegevoegde items in een categorie, of een combinatie van categorieën',
	'intersection_toomanycats' => 'Fout: Te veel categorieën!',
	'intersection_noresults' => 'Fout: Geen resultaten!',
	'intersection_noincludecats' => 'Fout: U moet tenminste een categorie of een naamruimte opgeven!',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Harald Khan
 */
$messages['nn'] = array(
	'intersection-desc' => 'Gjev ei punktlista over dei nyaste elementa i ein kategori, eller element som er felles i fleire kategoriar',
	'intersection_toomanycats' => 'Feil: For mange kategoriar!',
	'intersection_noresults' => 'Feil: Ingen resultat!',
	'intersection_noincludecats' => 'Feil: Du må inkludera minst éin kategori, eller oppgje eit namnerom!',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'intersection-desc' => 'Gir en punktliste over de nyeste elementene i en kategori, eller elementer som er felles i flere kategorier',
	'intersection_toomanycats' => 'Dynamisk sideliste: For mange kategorier!',
	'intersection_noresults' => 'Dynamisk sideliste: Ingen resultater!',
	'intersection_noincludecats' => 'Dynamisk sideliste: Du må inkludere minst én kategori, eller oppgi et navnerom!',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'intersection-desc' => 'Aficha una lista, amb de piuses, dels articles mai recents dins una categoria, o a partir d’una combinason de mantuna categoria.',
	'intersection_toomanycats' => 'Error : Tròp de categorias !',
	'intersection_noresults' => 'Error : Pas cap de resultat !',
	'intersection_noincludecats' => 'Error : avètz besonh d’inclure almens una categoria, o de precisar un nom d’espaci !',
);

/** Ossetic (Иронау)
 * @author Amikeco
 */
$messages['os'] = array(
	'intersection_toomanycats' => 'Рæдыд: æгæр бирæ категоритæ!',
);

/** Polish (Polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'intersection-desc' => 'Zwraca listę wypunktowaną najnowszych elementów w jednej kategorii lub części wspólnej kilku kategorii',
	'intersection_toomanycats' => 'Błąd – zbyt wiele kategorii!',
	'intersection_noresults' => 'Błąd – brak wyników!',
	'intersection_noincludecats' => 'Błąd – musisz wybrać co najmniej jedną kategorię lub określić przestrzeń nazw!',
);

/** Piedmontese (Piemontèis)
 * @author Dragonòt
 */
$messages['pms'] = array(
	'intersection-desc' => "A visualisa na lista pontà dij pì ressent element anserì ant na categorìa, o ant l'antërsession ëd pì categorìe",
	'intersection_toomanycats' => 'Eror: tròpe categorìe!',
	'intersection_noresults' => 'Eror: Gnun arzultà!',
	'intersection_noincludecats' => 'Eror: It deuve anserì almanch na categorìa, o spessifié në spassi nominal!',
);

/** Portuguese (Português)
 * @author 555
 * @author Hamilton Abreu
 * @author Malafaya
 */
$messages['pt'] = array(
	'intersection-desc' => 'Produz uma lista com marcadores dos elementos mais recentes presentes numa categoria, ou uma intersecção de várias categorias',
	'intersection_toomanycats' => 'Erro: Demasiadas categorias!',
	'intersection_noresults' => 'Erro: Não há resultados!',
	'intersection_noincludecats' => 'Erro: Tem de incluir no mínimo uma categoria ou especificar um espaço nominal!',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 */
$messages['pt-br'] = array(
	'intersection-desc' => 'Exibe uma lista pontuada dos itens mais recentes presentes numa categoria, ou uma intersecção de várias categorias',
	'intersection_toomanycats' => 'Erro: Categorias demais!',
	'intersection_noresults' => 'Erro: Sem resultados!',
	'intersection_noincludecats' => 'Erro: É necessário incluir no mínimo uma categoria ou especificar um espaço nominal!',
);

/** Romanian (Română)
 * @author Mihai
 */
$messages['ro'] = array(
	'intersection-desc' => 'Întoarce o lista celor mai recenți itemi care fac parte dintr-o categorie, sau intersecția a mai multor categorii',
	'intersection_toomanycats' => 'Eroare: Prea multe categorii!',
	'intersection_noresults' => 'Eroare: Niciun rezultat!',
	'intersection_noincludecats' => 'Eroare: Trebuie să incluzi cel puțin o categorie, sau să specifici un spațiu de nume!',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'intersection-desc' => "Fa assè 'na liste cu le palle de le urteme urteme artichele ca stonne jndr'à 'na categorije, o 'n'interseziona de cchiù categorije",
	'intersection_toomanycats' => 'Errore: Troppe categorije!',
	'intersection_noresults' => 'Errore: Nisciune resultete!',
	'intersection_noincludecats' => "Errore: Tu è abbesogne de 'ngludere ninde ninde 'na categorije, o specificà 'nu namespace!",
);

/** Russian (Русский)
 * @author Putnik
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'intersection-desc' => 'Выводит в маркированный список последние добавления в категорию или объединение нескольких категорий',
	'intersection_toomanycats' => 'Ошибка. Слишком много категорий!',
	'intersection_noresults' => 'Ошибка. Нет результатов!',
	'intersection_noincludecats' => 'Ошибка. Вы должны включить хотя бы одну категорию или указать пространство имён!',
);

/** Rusyn (Русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'intersection-desc' => 'Выпише список найновшых положок в катеґорії або зъєднотить пару катеґорій',
	'intersection_toomanycats' => 'Error: дуже много катеґорій!',
	'intersection_noresults' => 'Error: жадны резултаты!',
	'intersection_noincludecats' => 'Хыба: Мусите включіти холем єдну катеґорію або задати простор назв!',
);

/** Yakut (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'intersection-desc' => 'Категорияларга бүтэһик эбиилэри эбэтэр категориялар холбонууларын бэлиэлээх (маркированнай) испииһэк курдук таһаарар',
	'intersection_toomanycats' => 'Error: категорийата наһаа элбэх!',
	'intersection_noresults' => 'Error: Түмүк суох!',
	'intersection_noincludecats' => 'Error: Биир эмит категорияны эбэтэр ааты (пространство имен) талыахтааххын!',
);

/** Sinhala (සිංහල)
 * @author Budhajeewa
 */
$messages['si'] = array(
	'intersection-desc' => 'මෙම ප්‍රවර්ගයේ හෝ ප්‍රවර්ග කිහිපයක ඡේදයක මෑත කාලීන අංග කිහිපයක බුලට් ලයිස්තුවක් නිකුත් කරයි',
	'intersection_toomanycats' => 'දෝෂය: ප්‍රවර්ග ගණන ඉතා වැඩිය!',
	'intersection_noresults' => 'දෝෂය: ප්‍රතිඵලයක් නැත!',
	'intersection_noincludecats' => 'දෝෂය: නාමාවකාශයක් සඳහන් කෙරුම හෝ අවම වශයෙන් එක් ප්‍රවර්ගයක් හෝ ඇතුලත් කිරීමට අවැසිය!',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'intersection-desc' => 'Vypíše zoznam najnovších položiek v kategórii alebo zjednotení niekoľkých kategórií',
	'intersection_toomanycats' => 'Error: Príliš veľa kategórií!',
	'intersection_noresults' => 'Error: Žiadne výsledky!',
	'intersection_noincludecats' => 'Error: Musíte uviesť aspoň jednu kategóriu alebo menný priestor!',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'intersection-desc' => 'Izpiše seznam zadnjih predmetov v kategoriji ali presek več kategorij',
	'intersection_toomanycats' => 'Napaka: Preveč kategorij!',
	'intersection_noresults' => 'Napaka: Ni zadetkov!',
	'intersection_noincludecats' => 'Napaka: Vključiti morate vsaj eno kategorijo ali določiti imenski prostor!',
);

/** Albanian (Shqip)
 * @author Olsi
 */
$messages['sq'] = array(
	'intersection-desc' => 'Rezultatet një listë bulleted nga pikat më të fundit që banojnë në një kategori, apo një ndërprerje të disa kategori',
	'intersection_toomanycats' => 'Gabim: Shumë kategori!',
	'intersection_noresults' => 'Gabim: Nuk ka rezultate!',
	'intersection_noincludecats' => 'Gabim: Ju duhet të përfshini të paktën një kategori, ose të specifikoni një hapësirë!',
);

/** Serbian Cyrillic ekavian (‪Српски (ћирилица)‬)
 * @author Millosh
 */
$messages['sr-ec'] = array(
	'intersection-desc' => 'Даје редни списак најскорије додатих чланака у једну или више категорија.',
	'intersection_toomanycats' => 'Грешка: Превише категорија!',
	'intersection_noresults' => 'Грешка: Нема резулатата!',
	'intersection_noincludecats' => 'Грешка: Потребно је укључити бар једну категорију или одредити именски простор!',
);

/** Serbian Latin ekavian (‪Srpski (latinica)‬)
 * @author Michaello
 */
$messages['sr-el'] = array(
	'intersection-desc' => 'Daje redni spisak najskorije dodatih članaka u jednu ili više kategorija.',
	'intersection_toomanycats' => 'Greška: Previše kategorija!',
	'intersection_noresults' => 'Greška: Nema rezulatata!',
	'intersection_noincludecats' => 'Greška: Potrebno je uključiti bar jednu kategoriju ili odrediti imenski prostor!',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'intersection-desc' => 'Uutgoawe fon ne Lieste fon do aktuälste Iendraage in ne Kategorie, of n Truchsnit fon moorere Kategorien.',
	'intersection_toomanycats' => 'Error: Toufuul Kategorien!',
	'intersection_noresults' => 'Error: Neen Resultoat!',
	'intersection_noincludecats' => 'Error: Der mout mindestens een Kategorie ienbuunen weese of reek n Noomensruum oun!',
);

/** Swedish (Svenska)
 * @author Lejonel
 */
$messages['sv'] = array(
	'intersection-desc' => 'Skapar punktlistor över de nyaste sidorna i en eller flera kategorier',
	'intersection_toomanycats' => 'Fel: För många kategorier!',
	'intersection_noresults' => 'Fel: Inga resultat!',
	'intersection_noincludecats' => 'Fel: Du måste inkludera minst en kategori eller ange en namnrymd!',
);

/** Tamil (தமிழ்)
 * @author TRYPPN
 */
$messages['ta'] = array(
	'intersection_toomanycats' => 'தவறு: மிக அதிகமான பகுப்புக்கள் !',
	'intersection_noresults' => 'தவறு:  எந்தவிதமான முடிவுகளும் இல்லை !',
	'intersection_noincludecats' => 'தவறு: தாங்கள் குறைந்தது ஒரு பகுப்பு அல்லது பெயர்வெளியை சேர்க்க வேண்டும் !',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'intersection_toomanycats' => 'Error: చాలా ఎక్కువ వర్గాలు!',
	'intersection_noresults' => 'Error: ఫలితాలు లేవు!',
	'intersection_noincludecats' => 'Error: మీరు కనీసం ఒక్క వర్గాన్నైనా చేర్చాలి, లేదా ఓ నేమ్&zwnj;స్పేసునైనా ఇవ్వాలి!',
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'intersection-desc' => 'Феҳристи гулулае аз саҳифаҳое ба намоиш дар меояд, ки ба тозагӣ дар як ё чанд гурӯҳ ворид шудаанд',
	'intersection_toomanycats' => 'Error: Теъдоди гурӯҳҳо зиёд аст!',
	'intersection_noresults' => 'Error: Натиҷае вуҷуд надорад!',
	'intersection_noincludecats' => 'Error: Шумо ҳадди ақал бояд як гурӯҳро ворид кунед, ё як фазои номро мушаххас кунед!',
);

/** Tajik (Latin) (Тоҷикӣ (Latin))
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'intersection-desc' => 'Fehristi gululae az sahifahoe ba namoiş dar meojad, ki ba tozagī dar jak jo cand gurūh vorid şudaand',
	'intersection_toomanycats' => "Error: Te'dodi gurūhho zijod ast!",
	'intersection_noresults' => 'Error: Natiçae vuçud nadorad!',
	'intersection_noincludecats' => 'Error: Şumo haddi aqal bojad jak gurūhro vorid kuned, jo jak fazoi nomro muşaxxas kuned!',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'intersection-desc' => 'Bir kategoriýada bar bolan iň soňky elemntleriň markirlenen sanawyny ýa-da birnäçe kategoriýanyň birleşmesini öndürýär',
	'intersection_toomanycats' => 'Säwlik: Aşa köp kategoriýa!',
	'intersection_noresults' => 'Säwlik: Netije ýok!',
	'intersection_noincludecats' => 'Säwlik: Iň bolmanda bir kategoriýa goşmaly ýa-da at giňişligi görkezmeli!',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'intersection-desc' => 'Naglalabas ng isang tinuldukang talaan ng pinakakamakailang mga bagay-bagay na naninirahan sa loob ng isang kaurian, o isang pinagsangahang daanan ng ilang mga kaurian',
	'intersection_toomanycats' => 'Kamalian: Napakaraming mga kaurian!',
	'intersection_noresults' => 'Kaurian: Walang mga kinalabasan/resulta!',
	'intersection_noincludecats' => 'Kamalian: Kinakailangan mong magsama ng kahit na isang kaurian, o tumukoy ng isang espasyo ng pangalan!',
);

/** Turkish (Türkçe)
 * @author Joseph
 */
$messages['tr'] = array(
	'intersection-desc' => 'Bir kategoride, yada birçok kategorinin kesişiminde bulunan en son öğelerin, madde işaretli listesini üretir',
	'intersection_toomanycats' => 'Hata: Çok fazla kategori!',
	'intersection_noresults' => 'Hata: Sonuç yok!',
	'intersection_noincludecats' => 'Hata: En az bir kategori eklemeli, ya da bir ad alanı belirtmelisiniz!',
);

/** Ukrainian (Українська)
 * @author Ahonc
 */
$messages['uk'] = array(
	'intersection-desc' => "Виводить у маркований список останні додавання до категорії або об'єднання кількох категорій",
	'intersection_toomanycats' => 'Error: дуже багато категорій!',
	'intersection_noresults' => 'Error: нема результатів!',
	'intersection_noincludecats' => 'Error: ви повинні включити хоча б одну категорію або зазначити простір назв!',
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'intersection-desc' => "Mostra un elenco puntato coi elementi piassè reçenti inserìi in te na categoria o ne l'union de più categorie",
	'intersection_toomanycats' => 'Error: Ghe xe massa categorie!',
	'intersection_noresults' => 'Error: Nissun risultato!',
	'intersection_noincludecats' => 'Error: Te ghè da inclùdar almanco na categoria opure specificar un namespace.',
);

/** Veps (Vepsan kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'intersection-desc' => "Ozutab markiruidud nimikirjutesen nägus jäl'gmäižed ližadused kategorijaha vai kategorijoiden ühtenzoituz",
	'intersection_toomanycats' => 'Error: äjahk kategorijoid!',
	'intersection_noresults' => "Error: Ei ole rezul'tatoid!",
	'intersection_noincludecats' => "Petuz: pidab mülütada hot' üks' kategorii vai märita nimiavaruz!",
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'intersection-desc' => 'Cho ra danh sách những khoản gần đây nhất được xếp vào một thể loại hay hợp của hơn một thể loại',
	'intersection_toomanycats' => 'Lỗi: Quá nhiều thể loại!',
	'intersection_noresults' => 'Lỗi: Không tìm thấy trang nào!',
	'intersection_noincludecats' => 'Lỗi: Cần phải bao gồm ít nhất một thể loại hay định rõ một không gian tên!',
);

/** Volapük (Volapük)
 * @author Smeira
 */
$messages['vo'] = array(
	'intersection_toomanycats' => 'Error: Klads tu mödiks!',
	'intersection_noresults' => 'Error: Seks nonik!',
	'intersection_noincludecats' => 'Error: Nedol välön kladi pu bali, u nemaspadi!',
);

/** Yoruba (Yorùbá)
 * @author Demmy
 */
$messages['yo'] = array(
	'intersection_toomanycats' => 'Àsìṣe: Àwọn ẹ̀ka ti pọ̀jù!',
	'intersection_noresults' => 'Àsìṣe: Kò sí àwọn èsì kankan!',
);

/** Cantonese (粵語)
 * @author Shinjiman
 */
$messages['yue'] = array(
	'intersection-desc' => '輸出一個點列最近響分類嘅項目，或者係幾個分類嘅一個聯繫',
	'intersection_toomanycats' => 'DynamicPageList: 太多分類!',
	'intersection_noresults' => 'DynamicPageList: 無結果!',
	'intersection_noincludecats' => 'DynamicPageList: 你需要去包含最少一個分類，或者指定一個空間名!',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Shinjiman
 */
$messages['zh-hans'] = array(
	'intersection-desc' => '输出一个点列最近在分类中的项目，或者系数个分类的一个联系',
	'intersection_toomanycats' => 'DynamicPageList: 太多分类!',
	'intersection_noresults' => 'DynamicPageList: 没有结果!',
	'intersection_noincludecats' => 'DynamicPageList: 您需要去包含最少一个分类，或者指定一个空间名!',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Mark85296341
 * @author Shinjiman
 */
$messages['zh-hant'] = array(
	'intersection-desc' => '輸出一個點列最近在分類中的項目，或者係數個分類的一個關聯',
	'intersection_toomanycats' => 'DynamicPageList：太多分類！',
	'intersection_noresults' => 'DynamicPageList：沒有結果！',
	'intersection_noincludecats' => 'DynamicPageList：您需要去包含最少一個分類，或者指定一個空間名！',
);

