<?php
class VisualMathConfirmCaptcha extends SimpleCaptcha {
    var $trigger = NULL;
    var $action = NULL;

    function getCaptcha() {
	return array(
	    'question' => $_SESSION['vmathCaptchaQuestion'],
	    'answer' => $_SESSION['vmathCaptchaAnswer']
	);
    }

    function getForm() {
	global $wgScript, $wgVisualMathCaptchaLength;

        if (!isset($wgVisualMathCaptchaLength)) {
          $wgVisualMathCaptchaLength = 7;
        }

	$title = Title::makeTitle( NS_SPECIAL, 'VisualMathCaptcha' );
	$url = $title->getLocalUrl();

	return "<span class=\"vmathCaptchaAnswerVisual\">" 
           . "<img src=\"$url\" alt=\"captcha\" /></span>"
           . "<span class=\"vmathCaptchaAnswerField\">"
           . "<input type=\"text\" name=\"wpCatcha\" "
	   . "maxlength=\"$wgVisualMathCaptchaLength\" id=\"wpCatcha\" />"
           . "</span>";
    }

    /**
     * Check captcha.
     */
    function passCaptcha() {
	global $wgRequest;

	$result = NULL;
	$answer = $wgRequest->getText('wpCatcha');

	if (isset($_SESSION['vmathCaptchaAnswer'])) {
	    $result = $_SESSION['vmathCaptchaAnswer'];
	}

	if ($answer == NULL && $result == NULL) {
	    return false;
	}

	return ($answer == $result);
    }

    /**
     * Check if the submitted form matches the captcha session data provided
     * by the plugin when the form was generated.
     *
     * @param string $answer
     * @param array $info
     * @return bool
     */
    function keyMatch( $answer, $info ) {
	return $answer == $info['answer'];
    }

    function addCaptchaAPI(&$resultArr) {
        $captcha = $this->getCaptcha();
        $index = $this->storeCaptcha( $captcha );
        $resultArr['captcha']['type'] = 'image';
        $resultArr['captcha']['mime'] = 'image/png';
        $resultArr['captcha']['id'] = $index;
        $resultArr['captcha']['question'] = $captcha['question'];
    }
}

// Settings
global $wgCaptcha;

$wgCaptcha = new VisualMathConfirmCaptcha();
?>
