<?php
/**
 * Special:VisualMathCaptcha, a piclens gallery display.
 * 
 * @addtogroup SpecialPage
 */
/**
 * Generate captcha
 */
class SpecialVisualMathCaptcha extends SpecialPage {
    
    /**
     * Constructor
     */
    function __construct() {
        SpecialPage::SpecialPage( 'VisualMathCaptcha', '', true );
    }
    
    /**
     * Main execution function
     * @param $par Parameters passed to the page
     */
    function execute( $par ) {
      global $wgOut;

      $wgOut->disable();

      // Settings
      global $wgVisualMathCaptchaItemMax, $wgVisualMathCaptchaItemNum, $wgVisualMathCaptchaOperators;

      if (!isset($wgVisualMathCaptchaItemMax)) {
        $wgVisualMathCaptchaItemMax = 9;
      }

      if (!isset($wgVisualMathCaptchaItemNum)) {
        $wgVisualMathCaptchaItemNum = 2;
      }

      if ($wgVisualMathCaptchaItemNum < 2) {
        echo '$wgVisualMathCaptchaItemNum is invalid: ' . $wgVisualMathCaptchaItemNum;
        return;
      }

      if (!isset($wgVisualMathCaptchaOperators)) {
        $wgVisualMathCaptchaOperators = array('+', '-');
      }

      // Generate
      $mexpr = "";

      $opi = -1;
      $opm = count($wgVisualMathCaptchaOperators)-1;
      for ($i = 0; $i < $wgVisualMathCaptchaItemNum; $i++) {
        if ($i > 0) { // add operator
          $opi = rand(0, $opm);

          $mexpr .= $wgVisualMathCaptchaOperators[$opi];
        }

        $mexpr .= rand(0, $wgVisualMathCaptchaItemMax);
      }

      // Store result
      $captchaRes = -1;

      eval("\$captchaRes = $mexpr;");
      $captchaLength = strlen($mexpr);
      $width = $captchaLength * 10+10;
      $height = 37;

      @session_start();
      $_SESSION['vmathCaptchaQuestion'] = $mexpr;
      $_SESSION['vmathCaptchaAnswer'] = $captchaRes;
 
      $image = imagecreatetruecolor($width, $height);
      $bgCol = imagecolorallocate($image, rand(128, 255), 
	rand(128, 255), rand(128, 255));

      imagefilledrectangle($image, 0, 0, $width, $height, $bgCol);
		
      for($c = 0; $c < $captchaLength * 2; $c++) {
	  $bgCol = imagecolorallocate($image, 
		rand(100,255), rand(100,255), rand(100,255));

	  $x = rand(0, $width);
	  $y = rand(0, $height);
	  $w = rand(5, $width/2);
	  $h = rand(5, $height/2);

	  imagefilledrectangle($image, $x, $y, $x+$w, $y+$h, $bgCol);
	  imagecolordeallocate($image, $bgCol);
      }

      for($c = 0; $c < $captchaLength; $c++) {
	  $txtCol = imagecolorallocate($image, rand(0,128), 
		rand(0,128), rand(0,128));

	  imagestring($image, 5, 5+10*$c, 
		rand(0,$height-15), substr($mexpr, $c, 1), $txtCol);

	  imagecolordeallocate($image, $txtCol);
      }

      $date = date("D, d M Y H:i:s e");

      header("Content-type: image/png");
      header("Date: $date");
      header("Last-Modified: $date");
      header("Expires: $date");
      header("Pragma: no-cache");
      header("Cache-Control: no-cache");
      header("ETag: $mexpr");

      imagepng($image);
      imagedestroy($image);
    }
}
?>
