<?php
/**
 * Internationalization file for the Semantic Result Formats extension
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English
 */
$messages['en'] = array(
	'srf-desc' => 'Additional formats for Semantic MediaWiki inline queries', // FIXME: descmsg in extension credits should allow for parameter(s) so that $formats_list can be added

	// user messages
	'srf-name' => 'Semantic Result Formats', // name of extension, can be translated or not; used by Admin Links

	// user preferences
	'prefs-srf' => 'Semantic Result Formats',
	'srf-prefs-intro-text' => 'You have installed the Semantic Result Formats extension which at moment has no customizable user options. For assistance, please visit the [http://www.semantic-mediawiki.org/wiki/Help:Result_formats result formats] help page.',

	// shared messages
	'srf-module-loading'   => 'Loading...',
	'srf-paramdesc-layout' => 'Available layout',
	'srf-paramdesc-height' => 'Height',
	'srf-paramdesc-width'  => 'Width',
	'srf-paramdesc-class'  => 'Specify an additional cascading style sheet class',
	'srf-module-nomatch' => 'No matches found',
	'srf-paramdesc-charttype' => 'Available chart type',

	// common ui elements
	'srf-navigation-previous' => 'Previous',
	'srf-ui-navigation-prev'  => 'Prev',
	'srf-ui-navigation-next'  => 'Next',
	'srf-ui-common-label-source' => 'Source',
	'srf-ui-common-label-datasource' => 'Data source',
	'srf-ui-common-label-ajax-error' => 'The server reported a failed communication for this $1. Please try to refresh the page or consult with this $2.',
	'srf-ui-common-label-request-object' => 'request object',
	'srf-ui-common-label-help-section' => 'help section',
	'srf-ui-tooltip-title-options' => 'Options',
	'srf-ui-tooltip-title-scope' => 'Scope',

	// error descriptions
	'srf-error-option-mix' => 'Option ($1) is not available',
	'srf-error-option-link-all' => 'Option ($1) requires parameter "link" to be set "all"',
	'srf-error-missing-layout' => 'Layout is missing',
	'srf-warn-empy-chart' => 'The chart or graph is empty due to missing data',

	// format "calendar"
	'srfc_previousmonth' => 'Previous month',
	'srfc_nextmonth'     => 'Next month',
	'srfc_today'         => 'Today',
	'srfc_gotomonth'     => 'Go to month',
	'srf_printername_calendar' => 'Monthly calendar',
	'srf_paramdesc_calendarlang' => 'The code for the language in which to display the calendar',
	'srf_paramdesc_calendarcolors' => 'The color to display for each date property (example: "Start date=>green,End date=>#09c")',

	// format "vcard"
	'srf_vcard_link'     => 'vCard',
	'srf_printername_vcard' => 'vCard export',

	// format "icalendar"
	'srf_icalendar_link' => 'iCalendar',
	'srf_printername_icalendar' => 'iCalendar export',
	'srf_paramdesc_icalendartitle' => 'The title of the calendar file',
	'srf_paramdesc_icalendardescription' => 'The description of the calendar file',

	// format "bibtex"
	'srf_bibtex_link'    => 'BibTeX',
	'srf_printername_bibtex' => 'BibTeX export',

	// format "outline"
	'srf_outline_novalue' => 'No value',
	'srf_printername_outline' => 'Outline',
	'srf_paramdesc_outlineproperties' => 'The list of properties to be displayed as outline headers, separated by commas',

	// format "math"
	'srf_printername_sum' => 'Sum of numbers',
	'srf_printername_average' => 'Average of numbers',
	'srf_printername_max' => 'Maximum number',
	'srf_printername_min' => 'Minimum number',
	'srf_paramdesc_limit' => 'The maximum number of pages to query',
	'srf_printername_product' => 'Product of numbers',
	'srf_printername_median' => 'Median of numbers',
	'srf-paramdesc-default' => 'Default value that will be displayed when there are no numerical results',

	// format "time"
	'srf_printername_earliest' => 'Earliest time',
	'srf_printername_latest' => 'Latest time',

	// formats "timeline" and "eventline"
	'srf_printername_timeline' => 'Timeline',
	'srf_printername_eventline' => 'Eventline',
	'srf_paramdesc_timelinebands' => 'Defines which bands are displayed in the result.',
	'srf_paramdesc_timelineposition' => 'Defines where the timeline initially focuses at.',
	'srf_paramdesc_timelinestart' => 'A property name used to define a first time point',
	'srf_paramdesc_timelineend' => 'A property name used to define a second time point',
	'srf_paramdesc_timelinesize' => 'The height of the timeline',
	'srf-timeline-allresults' => 'Further results for this query.',
	'srf-timeline-nojs' => 'You need to have JavaScript enabled to view the interactive timeline.',

	// format "exhibit"
	'srf_paramdesc_views' => 'The views to be displayed',
	'srf_paramdesc_facets' => 'The set of properties to be displayed for each page',
	'srf_paramdesc_lens' => 'The name of a template with which to display page properties',

	// formats "googlebar", "googlepie", "jqplotpie" and "jqplotbar"
	'srf_printername_googlebar' => 'Google bar chart',
	'srf_printername_googlepie' => 'Google pie chart',
	'srf-printername-jqplotchart' => 'jqPlot chart',
	'srf-printername-jqplotseries' => 'jqPlot series',
	'srf_paramdesc_chartheight' => 'Specify the height (in pixels) of a chart or graph',
	'srf_paramdesc_chartwidth' => 'Specify the width (in pixels or percent) of a chart or graph',
	'srf_paramdesc_charttitle'  => 'The title of the chart',
	'srf_paramdesc_barcolor'   =>   'Specify chart colors',
	'srf_paramdesc_bardirection'=>  'Specify the direction of a chart',
	'srf-paramdesc-direction' => 'Specify the direction of a chart or graph',
	'srf_paramdesc_barnumbersaxislabel' => 'The label for the numbers axis',
	'srf-paramdesc-labelaxislabel' => 'The label for the label axis',
	'srf-paramdesc-ticklabels' => 'Enable display of tick labels',
	'srf-paramdesc-minvalue' => 'The minimum value to show on the Y-axis',
	'srf-paramdesc-pointlabels' => 'Display in-chart data points',
	'srf-paramdesc-chartlegend' => 'Chart legend position',
	'srf-paramdesc-datalabels' => 'Chart/graph data labels',
	'srf-paramdesc-charttext' => 'Descriptive chart text',
	'srf-paramdesc-chartclass' => 'Additional CSS class',
	'srf-paramdesc-renderer' => 'Select a graph/chart renderer',
	'srf-paramdesc-filling' => 'Individual filling option',
	'srf-paramdesc-theme' => 'Select a grid theme',
	'srf-paramdesc-chartcolor' => 'Assign individual chart colors',
	'srf-paramdesc-colorscheme' => 'Select a color scheme',
	'srf-paramdesc-valueformat' => 'Specify formatting rule for values',
	'srf-paramdesc-highlighter' => 'Display a data point highlighter',
	'srf-paramdesc-smoothlines' => 'Apply a smoothing algorithm on line charts',
	'srf-paramdesc-stackseries' => 'Display chart as stacked series',
	'srf-paramdesc-seriesgroup' => 'Select series grouping',
	'srf-paramdesc-serieslabel' => 'Determine the series label',
	'srf-paramdesc-grouplabel' => 'Determine the group label',
	'srf-paramdesc-chartcursor' => 'Chart cursor display option',
	'srf-paramdesc-trendline' => 'Enable simultaneous display of a chart and its trendline',

	// srf gridview plugin
	'srf-paramdesc-gridview' => 'Display chart and data sets simultaneously',
	'srf-paramdesc-infotext' => 'Display additional information on a corresponding info tab',
	'srf-ui-gridview-label-item'  => 'Data item',
	'srf-ui-gridview-label-value' => 'Data value',
	'srf-ui-gridview-label-series' => 'Data series',
	'srf-ui-gridview-label-chart-tab' => 'Chart',
	'srf-ui-gridview-label-data-tab' => 'Data',
	'srf-ui-gridview-label-info-tab' => 'Info',

	// format "gallery"
	'srf_printername_gallery' => 'Gallery',
	'srf_paramdesc_perrow' => 'The amount of images per row',
	'srf_paramdesc_widths' => 'The width of the images',
	'srf_paramdesc_heights' => 'The height of the images',
	'srf_paramdesc_autocaptions' => 'Use file name as caption when none is provided',
	'srf_paramdesc_fileextensions' => 'When using the filename as caption, also display the file extension',
	'srf_paramdesc_captionproperty' => 'The name of a semantic property present on the queried pages to be used as caption',
	'srf_paramdesc_imageproperty' => 'Name of a semantic property on the queried pages that points to images to use. When set, the queried pages themselves will not be displayed as images',
	'srf-paramdesc-redirects' => 'The name of a semantic property present on the queried pages which contain the redirect target',
	'srf-paramdesc-navigation'    => 'Layout navigation control',
	'srf-paramdesc-overlay'       => 'Enable image overlay',
	'srf-gallery-navigation-previous' => 'Previous',
	'srf-gallery-navigation-next'     => 'Next',
	'srf-gallery-overlay-count' => 'Image $1 of $2',
	'srf-gallery-image-url-error' => 'The image was not found.',

	// format "tagcloud"
	'srf_printername_tagcloud' => 'Tag cloud',
	'srf_paramdesc_includesubject' => 'Subject names themselves should be included',
	'srf_paramdesc_increase' => 'How to increase the size of tags',
	'srf_paramdesc_tagorder' => 'The order of the tags',
	'srf_paramdesc_mincount' => 'The minimum amount of times a value needs to occur to be listed',
	'srf_paramdesc_minsize' => 'The size of the smallest tags in percent',
	'srf_paramdesc_maxsize' => 'The size of the biggest tags in percent',
	'srf_paramdesc_maxtags' => 'The maximum amount of tags in the cloud',
	'srf-paramdesc-excludetags' => 'Exclude tags (delimiter: ;)',

	// format "valuerank"
	'srf_printername_valuerank' => 'Value rank',

	// format "array" and "hash"
	'srf_printername_array' => 'Array',
	'srf_paramdesc_pagetitle' => 'Whether to show page titles as result entries or to leave them out',
	'srf_paramdesc_hidegaps' => 'Whether to print requested but unavailable property and record values separated by separators or leaving them out',
	'srf_paramdesc_arrayname' => 'If given and ArrayExtension is available this will create an array with the specified name (no visible output then)',
	'srf_paramdesc_propsep' => 'Separator between the requested properties',
	'srf_paramdesc_manysep' => 'Separator between many valued property values',
	'srf_paramdesc_recordsep' => 'Separator between values of record properties',
	'srf_paramdesc_headersep' => 'Separator between property name and value if "headers" is set to "show" or "plain"',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'If given and the HashTables extension is available this will create a hash with the specified name (no visible output then)',

	// format "graph"
	'srf-printername-graph' => 'Graph',
	'srf-paramdesc-graph-relation' => 'Are the subjects or nameproperties parents or childs?',
	'srf-paramdesc-graph-nameprop' => 'Allows setting a property that will be used as subject instead of the actual subject',
	'srf-paramdesc-graph-nodeshape' => 'The shape of each node on the graph',
	'srf_paramdesc_graphname' => 'Title',
	'srf_paramdesc_graphsize' => 'Graph size (in pixels)',
	'srf_paramdesc_graphlegend' => 'Show graph legend or not',
	'srf_paramdesc_graphlabel' => 'Graph label',
	'srf_paramdesc_rankdir' => 'Arrow direction',
	'srf_paramdesc_graphlink' => 'Graph link',
	'srf_paramdesc_graphcolor' => 'Graph color',
	'srf-paramdesc-graph-wwl' => 'Word wrap limit (in # characters)',

	// format "datatables"
	'srf_printername_datatables'  => 'DataTables',
	'srf-paramdesc-rowindex'      => 'Table row index',
	'srf-paramdesc-displaylength' => 'Initial display length',

	// format "tree", "ultree", "oltree"
	'srf_printername_tree'  => 'Tree',
	'srf_printername_ultree'  => 'Ultree',
	'srf_printername_oltree'  => 'Oltree',
	'srf-noparentprop' => 'No parent property given. The tree can not be built without a specified parent property.',
	'srf-paramdesc-parent' => 'The property containing the parent page',

	// format "slideshow"
	'srf-printername-slideshow' => 'SlideShow',
	'srf-paramdesc-delay' => 'The delay between slides in seconds',
	'srf-paramdesc-navigation-controls' => 'Show navigation controls or not',
	'srf-paramdesc-effect' => 'The effect to be used to switch from slide to slide',

	// format "filtered"
	'srf-printername-filtered' => 'Filtered',
	'srf-paramdesc-filtered-views' => 'The views that shall be available in the result display.',
	'srf-paramdesc-filtered-filter-position' => 'The position of the filters in relation to the views. Allowed values: top, bottom. Default: top.',
	'srf-paramdesc-filtered-list-type' => 'The type of the list. Allowed values: list, ul, ol. Default: list.',
	'srf-paramdesc-filtered-list-template' => 'The template that is to be used to format the list entries.',
	'srf-paramdesc-filtered-list-named-args' => 'Name the arguments passed to the template.',
	'srf-paramdesc-filtered-list-introtemplate' => 'The name of a template to display before the query results, if there are any.',
	'srf-paramdesc-filtered-list-outrotemplate' => 'The name of a template to display after the query results, if there are any.',
	'srf-paramdesc-filtered-calendar-start' => 'The printout containing the start date of an event',
	'srf-paramdesc-filtered-calendar-end' => 'The printout containing the end date of an event',
	'srf-paramdesc-filtered-calendar-title' => 'The printout containing the title of an event. Can not be used together with a title template.',
	'srf-paramdesc-filtered-calendar-title-template' => 'A template used to format the event\'s title in the calendar',
	'srf-filtered-selectorlabel-list' => 'List',
	'srf-filtered-selectorlabel-calendar' => 'Calendar',
	'srf-filtered-firstdayofweek' => '1', // 0 - sunday, 1 - monday...

	// format "d3chart"
	'srf-printername-d3chart' => 'D3 chart',

	// format "timeseries"
	'srf-printername-timeseries' => 'Timeseries chart',
	'srf-paramdesc-group' => 'Series grouped by',
	'srf-paramdesc-zoom' => 'Enable zoom',
	'srf-paramdesc-datatable' => 'Enable a datatable',
	'srf-timeseries-zoom-out-of-range' => 'The zoom range did not produce any sufficient data',

	// format "sparkline"
	'srf-printername-sparkline' => 'Sparkline chart',

	// format "listwidget"
	'srf-printername-listwidget' => 'Listwidget',
	'srf-paramdesc-listtype' => 'Specify the list type',
	'srf-paramdesc-widget' => 'Available widget',
	'srf-paramdesc-pageitems' => 'Items per page',


	// format "eventcalendar"
	'srf-printername-eventcalendar' => 'Event calendar',
	'srf-paramdesc-calendarfirstday' => 'The day that each week begins',
	'srf-paramdesc-calendardefaultview' => 'The initial view when the calendar loads',
	'srf-paramdesc-calendarstart' => 'The initial calendar start',
	'srf-paramdesc-dayview' => 'Enable the day view by clicking the day number',
	'srf-ui-eventcalendar-label-today' => 'Today',
	'srf-ui-eventcalendar-label-month' => 'Month',
	'srf-ui-eventcalendar-label-week' => 'Week',
	'srf-ui-eventcalendar-label-day' => 'Day',
	'srf-ui-eventcalendar-label-allday' => 'All day',
	'srf-ui-eventcalendar-format-time' => 'h(:mm)t',
	'srf-ui-eventcalendar-format-time-agenda' => 'H:mm( - H:mm)',
	'srf-ui-eventcalendar-format-axis' => 'H:mm',
	'srf-ui-eventcalendar-format-title-month' => 'MMMM yyyy',
	'srf-ui-eventcalendar-format-title-week' => 'd [ yyyy]{ \'&#8212;\'[ MMM] d MMM yyyy}',
	'srf-ui-eventcalendar-format-title-day' => 'dddd, d MMM, yyyy',
	'srf-ui-eventcalendar-format-column-month' => 'ddd',
	'srf-ui-eventcalendar-format-column-week' => 'ddd d/M',
	'srf-ui-eventcalendar-format-column-day' => 'dddd d/M',

	// format "dygraphs"
	'srf-printername-dygraphs' => 'Dygraphs chart',
	'srf-paramdesc-datasource' => 'Specify the source from where the data is accessible (file, url etc.)',
	'srf-paramdesc-errorbar' => 'Specify the error bar used (standard deviation (sigma), plot fractions, or custom bar as a range of low;middle;high values)',
	'srf-paramdesc-movingaverage' => 'Display the average over a number of days (zero will indicate no moving average)',
	'srf-paramdesc-yaxislabel' => 'Description that appears on the y-axis',
	'srf-paramdesc-xaxislabel' => 'Description that appears on the x-axis',
	'srf-paramdesc-unit' => 'Unit',

	// format "pagewidget"
	'srf-printername-pagewidget' => 'Pagewidget',

	// format "incoming"
	'srf-printername-incoming' => 'Incoming properties',
	'srf-paramdesc-min' => 'Minimum or threshold value',
	'srf-paramdesc-excludeproperty' => 'Exclude property from result set',

);

/** Message documentation (Message documentation)
 * @author EugeneZelenko
 * @author F.trott
 * @author Kghbln
 * @author Purodha
 * @author Raymond
 * @author Siebrand
 * @author Toliño
 * @author Umherirrender
 */
$messages['qqq'] = array(
	'srf-desc' => '{{desc}}',
	'srf-name' => 'This is the name of this extension (Used by the [[mw:Extension:Admin_Links|Admin Links]] extension).',
	'prefs-srf' => 'This is the text of a section header on [[Special:Preferences#mw-prefsection-smw|Special:Preferences]].',
	'srf-prefs-intro-text' => 'This is an user preference intro text on [[Special:Preferences#mw-prefsection-smw|Special:Preferences]].',
	'srf-module-loading' => 'This is an informatory message.',
	'srf-paramdesc-layout' => '{{doc-paramdesc|layout}}',
	'srf-paramdesc-height' => '{{doc-paramdesc|height}}',
	'srf-paramdesc-width' => '{{doc-paramdesc|width}}',
	'srf-paramdesc-class' => '{{doc-paramdesc|class}}',
	'srf-module-nomatch' => 'This is an informatory message.',
	'srf-paramdesc-charttype' => '{{doc-paramdesc|charttype}}',
	'srf-navigation-previous' => 'A label describing a navigation control component.',
	'srf-ui-navigation-prev' => 'A label describing a navigation control component.',
	'srf-ui-navigation-next' => 'A label describing a navigation control component.',
	'srf-ui-common-label-source' => 'A label pointing to a source. See also [http://semantic-mediawiki.org/wiki/Help:Result_formats result format].',
	'srf-ui-common-label-datasource' => 'A label pointing to a data source. See also [http//semantic-mediawiki.org/wiki/Help:Result_formats result format].',
	'srf-ui-common-label-ajax-error' => 'Information that is displayed during a failed ajax communication. See [http://www.semantic-mediawiki.org/wiki/Help:Ajax Help:Ajax].',
	'srf-ui-common-label-request-object' => 'A support label concatenate in a sentence structure and is therefore kept lower case.',
	'srf-ui-common-label-help-section' => 'A support label concatenate in a sentence structure and is therefore kept lower case.',
	'srf-ui-tooltip-title-options' => 'A label that is displayed within the tooltip. See [http://semantic-mediawiki.org/wiki/Help:Tooltip Help:Tooltip].',
	'srf-ui-tooltip-title-scope' => 'A label that is displayed within the tooltip. See [http://semantic-mediawiki.org/wiki/Help:Tooltip Help:Tooltip].',
	'srf-error-option-mix' => 'This is an error message. Parameters:
* $1 is a fixed entity name (name of the option) that cannot and should not be translated.',
	'srf-error-option-link-all' => '{{doc-important|Do not translate the parameter "link" and its possible value "all".}}
This is an error message. Parameters:
* $1 is a fixed entitity name that cannot and should not be translated.',
	'srf-error-missing-layout' => 'This is an error message.',
	'srf-warn-empy-chart' => 'This is an informatory message.',
	'srfc_previousmonth' => 'A label describing a navigation control component.',
	'srfc_nextmonth' => 'A label describing a navigation control component.',
	'srfc_today' => 'A label describing a navigation control component.',
	'srfc_gotomonth' => 'A label describing a navigation control component.',
	'srf_printername_calendar' => '{{doc-smwformat|calendar}}',
	'srf_paramdesc_calendarlang' => '{{doc-paramdesc|lang}}',
	'srf_paramdesc_calendarcolors' => '{{doc-smwformat|colors}}
{{doc-important|Hint for <code>"Start date=>green,End date=>#09c"</code>: "Start date" and "End date" should be translated, but not the other parts.}}',
	'srf_vcard_link' => '{{optional}}',
	'srf_printername_vcard' => '{{doc-smwformat|vcard}}',
	'srf_icalendar_link' => '{{optional}}',
	'srf_printername_icalendar' => '{{doc-smwformat|icalendar}}',
	'srf_paramdesc_icalendartitle' => '{{doc-paramdesc|title}}',
	'srf_paramdesc_icalendardescription' => '{{doc-paramdesc|description}}',
	'srf_bibtex_link' => '{{optional}}',
	'srf_printername_bibtex' => '{{doc-smwformat|Bibtex}}',
	'srf_outline_novalue' => 'This is an error message.',
	'srf_printername_outline' => '{{doc-smwformat|outline}}

It is basically a list, or nested list, of topics, subtopics, subsubtopics, etc., as deeply stacked as defined by page editors in an inline query.
There is an [http://discoursedb.org/wiki/Outline_example Outline example]',
	'srf_paramdesc_outlineproperties' => '{{doc-paramdesc|outlineproperties}}

"Outline" means the outline of text or document here.',
	'srf_printername_sum' => '{{doc-smwformat|sum}}',
	'srf_printername_average' => '{{doc-smwformat|average}}',
	'srf_printername_max' => '{{doc-smwformat|max}}',
	'srf_printername_min' => '{{doc-smwformat|min}}',
	'srf_paramdesc_limit' => '{{doc-paramdesc|limit}}',
	'srf_printername_product' => '{{doc-smwformat|product}}',
	'srf_printername_median' => '{{doc-smwformat|median}}',
	'srf-paramdesc-default' => '{{doc-paramdesc|default}}',
	'srf_printername_earliest' => '{{doc-smwformat|earliest}}',
	'srf_printername_latest' => '{{doc-smwformat|latest}}',
	'srf_printername_timeline' => '{{doc-smwformat|timeline}}',
	'srf_printername_eventline' => '{{doc-smwformat|eventline}}',
	'srf_paramdesc_timelinebands' => '{{doc-smwformat|timelinebands}}',
	'srf_paramdesc_timelineposition' => '{{doc-paramdesc|timelineposition}}',
	'srf_paramdesc_timelinestart' => '{{doc-paramdesc|timelinestart}}',
	'srf_paramdesc_timelineend' => '{{doc-paramdesc|timelineend}}',
	'srf_paramdesc_timelinesize' => '{{doc-paramdesc|timelinesize}}',
	'srf-timeline-allresults' => 'This is the text of an link pointing to further query results.',
	'srf-timeline-nojs' => 'This is an informatory and/or error message.',
	'srf_paramdesc_views' => '{{doc-paramdesc|views}}

The result format "filtered", part of the Semantic Result Formats extension, displays results in switchable \'\'\'views\'\'\', e.g. as map, as table, as calendar, etc.

This text is a description of the parameter "views" to the function that generates the "filtered" result format.

Synonyms might be representation, or maybe appearance, aspect, facet',
	'srf_paramdesc_facets' => '{{doc-paramdesc|facets}}',
	'srf_paramdesc_lens' => '{{doc-paramdesc|lens}}',
	'srf_printername_googlebar' => '{{doc-smwformat|googlebar}}',
	'srf_printername_googlepie' => '{{doc-smwformat|googlepie}}',
	'srf-printername-jqplotchart' => '{{doc-smwformat|Jqplotchart}}',
	'srf-printername-jqplotseries' => '{{doc-smwformat|Jqplotseries}}',
	'srf_paramdesc_chartheight' => '{{doc-paramdesc|chartheight}}',
	'srf_paramdesc_chartwidth' => '{{doc-paramdesc|chartwidth}}',
	'srf_paramdesc_charttitle' => '{{doc-paramdesc|charttitle}}',
	'srf_paramdesc_barcolor' => '{{doc-paramdesc|barcolor}}',
	'srf_paramdesc_bardirection' => '{{doc-paramdesc|bardirection}}',
	'srf-paramdesc-direction' => '{{doc-paramdesc|direction}}',
	'srf_paramdesc_barnumbersaxislabel' => '{{doc-paramdesc|barnumbersaxislabel}}',
	'srf-paramdesc-labelaxislabel' => '{{doc-paramdesc|labelaxislabel}}',
	'srf-paramdesc-ticklabels' => '{{doc-paramdesc|ticklabels}}',
	'srf-paramdesc-minvalue' => '{{doc-paramdesc|minvalue}}',
	'srf-paramdesc-pointlabels' => '{{doc-paramdesc|pointlabels}}',
	'srf-paramdesc-chartlegend' => '{{doc-paramdesc|chartlegend}}',
	'srf-paramdesc-datalabels' => '{{doc-paramdesc|datalabels}}',
	'srf-paramdesc-charttext' => '{{doc-paramdesc|charttext}}',
	'srf-paramdesc-chartclass' => '{{doc-paramdesc|class}}',
	'srf-paramdesc-renderer' => '{{doc-paramdesc|renderer}}',
	'srf-paramdesc-filling' => '{{doc-paramdesc|filling}}',
	'srf-paramdesc-theme' => '{{doc-paramdesc|theme}}',
	'srf-paramdesc-chartcolor' => '{{doc-paramdesc|chartcolor}}',
	'srf-paramdesc-colorscheme' => '{{doc-paramdesc|colorscheme}}',
	'srf-paramdesc-valueformat' => '{{doc-paramdesc|valueformat}}',
	'srf-paramdesc-highlighter' => '{{doc-paramdesc|highlighter}}',
	'srf-paramdesc-smoothlines' => '{{doc-paramdesc|smoothlines}}',
	'srf-paramdesc-stackseries' => '{{doc-paramdesc|stackseries}}',
	'srf-paramdesc-seriesgroup' => '{{doc-paramdesc|seriesgroup}}',
	'srf-paramdesc-serieslabel' => '{{doc-paramdesc|serieslabel}}',
	'srf-paramdesc-grouplabel' => '{{doc-paramdesc|grouplabel}}',
	'srf-paramdesc-chartcursor' => '{{doc-paramdesc|chartcursor}}',
	'srf-paramdesc-trendline' => '{{doc-paramdesc|trendline}}',
	'srf-paramdesc-gridview' => '{{doc-paramdesc|gridview}}',
	'srf-paramdesc-infotext' => '{{doc-paramdesc|infotext}}',
	'srf-ui-gridview-label-item' => 'This is a table header. See also [http://semantic-mediawiki.org/wiki/Help:Result_formats result format].',
	'srf-ui-gridview-label-value' => 'This is a table header See also [http://semantic-mediawiki.org/wiki/Help:Result_formats result format].',
	'srf-ui-gridview-label-series' => 'This is a table header. See also [http://semantic-mediawiki.org/wiki/Help:Result_formats result format].',
	'srf-ui-gridview-label-chart-tab' => 'This is a table header. See also [http://semantic-mediawiki.org/wiki/Help:Result_formats result format].',
	'srf-ui-gridview-label-data-tab' => 'This is a table header. See also [http://semantic-mediawiki.org/wiki/Help:Result_formats result format].',
	'srf-ui-gridview-label-info-tab' => 'This is a table header. See also [http://semantic-mediawiki.org/wiki/Help:Result_formats result format].',
	'srf_printername_gallery' => '{{doc-smwformat|gallery}}
{{Identical|Gallery}}',
	'srf_paramdesc_perrow' => '{{doc-paramdesc|perrow}}',
	'srf_paramdesc_widths' => '{{doc-paramdesc|width}}',
	'srf_paramdesc_heights' => '{{doc-paramdesc|height}}',
	'srf_paramdesc_autocaptions' => '{{doc-paramdesc|autocaptions}}',
	'srf_paramdesc_fileextensions' => '{{doc-paramdesc|fileextensions}}',
	'srf_paramdesc_captionproperty' => '{{doc-paramdesc|captionproperty}}',
	'srf_paramdesc_imageproperty' => '{{doc-paramdesc|imageproperty}}',
	'srf-paramdesc-redirects' => '{{doc-paramdesc|redirects}}',
	'srf-paramdesc-navigation' => '{{doc-paramdesc|navigation}}',
	'srf-paramdesc-overlay' => '{{doc-paramdesc|overlay}}',
	'srf-gallery-navigation-previous' => 'A label describing a navigation control component.',
	'srf-gallery-navigation-next' => 'A label describing a navigation control component.',
	'srf-gallery-overlay-count' => 'This is an informatory message. Parameters:
* $1 is a number
* $2 is a number',
	'srf-gallery-image-url-error' => 'This is an error message.',
	'srf_printername_tagcloud' => '{{doc-smwformat|tagcloud}}',
	'srf_paramdesc_includesubject' => '{{doc-paramdesc|includesubject}}',
	'srf_paramdesc_increase' => '{{doc-paramdesc|increase}}',
	'srf_paramdesc_tagorder' => '{{doc-paramdesc|tagorder}}',
	'srf_paramdesc_mincount' => '{{doc-paramdesc|mincount}}',
	'srf_paramdesc_minsize' => '{{doc-paramdesc|minsize}}',
	'srf_paramdesc_maxsize' => '{{doc-paramdesc|maxsize}}',
	'srf_paramdesc_maxtags' => '{{doc-paramdesc|maxtags}}',
	'srf-paramdesc-excludetags' => '{{doc-paramdesc|excludetags}}',
	'srf_printername_valuerank' => '{{doc-smwformat|valuerank}}',
	'srf_printername_array' => '{{doc-smwformat|array}}',
	'srf_paramdesc_pagetitle' => '{{doc-paramdesc|pagetitle}}',
	'srf_paramdesc_hidegaps' => '{{doc-paramdesc|hidegaps}}',
	'srf_paramdesc_arrayname' => '{{doc-paramdesc|name}}',
	'srf_paramdesc_propsep' => '{{doc-paramdesc|propsep}}',
	'srf_paramdesc_manysep' => '{{doc-paramdesc|manysep}}',
	'srf_paramdesc_recordsep' => '{{doc-paramdesc|recordsep}}',
	'srf_paramdesc_headersep' => '{{doc-smwformat|headersep}}
{{doc-important|Do not translate the parameter name "headers" and its possible values "show" or "plain".}}',
	'srf_printername_hash' => '{{doc-smwformat|hash}}',
	'srf_paramdesc_hashname' => '{{doc-paramdesc|name}}',
	'srf-printername-graph' => '{{doc-smwformat|graph}}',
	'srf-paramdesc-graph-relation' => '{{doc-paramdesc|graphrelation}}',
	'srf-paramdesc-graph-nameprop' => '{{doc-paramdesc|nameproperty}}',
	'srf-paramdesc-graph-nodeshape' => '{{doc-paramdesc|nodeshape}}',
	'srf_paramdesc_graphname' => '{{doc-smwformat|graphname}}
{{Identical|Title}}',
	'srf_paramdesc_graphsize' => '{{doc-paramdesc|graphsize}}',
	'srf_paramdesc_graphlegend' => '{{doc-paramdesc|graphlegend}}',
	'srf_paramdesc_graphlabel' => '{{doc-paramdesc|graphlabel}}',
	'srf_paramdesc_rankdir' => '{{doc-paramdesc|rankdir}}',
	'srf_paramdesc_graphlink' => '{{doc-paramdesc|graphlink}}',
	'srf_paramdesc_graphcolor' => '{{doc-paramdesc|graphcolor}}',
	'srf-paramdesc-graph-wwl' => '{{doc-paramdesc|wordwraplimit}}',
	'srf_printername_datatables' => '{{doc-smwformat|datatables}}',
	'srf-paramdesc-rowindex' => '{{doc-paramdesc|rowindex}}',
	'srf-paramdesc-displaylength' => '{{doc-paramdesc|displaylength}}',
	'srf_printername_tree' => '{{doc-smwformat|tree}}',
	'srf_printername_ultree' => '{{doc-smwformat|ultree}}
This is an alias of "tree" {{msg-mw|Srf printername tree}}.',
	'srf_printername_oltree' => '{{doc-smwformat|oltree}}',
	'srf-noparentprop' => 'This is an error message. See result format [http://semantic-mediawiki.org/wiki/Help:Tree_format tree] for further information.',
	'srf-paramdesc-parent' => '{{doc-paramdesc|parent}}',
	'srf-printername-slideshow' => '{{doc-smwformat|slideshow}}',
	'srf-paramdesc-delay' => '{{doc-paramdesc|delay}}',
	'srf-paramdesc-navigation-controls' => '{{doc-paramdesc|nav controls}}',
	'srf-paramdesc-effect' => '{{doc-paramdesc|effect}}',
	'srf-printername-filtered' => '{{doc-smwformat|filtered}}',
	'srf-paramdesc-filtered-views' => '{{doc-paramdesc|views}}',
	'srf-paramdesc-filtered-filter-position' => '{{doc-paramdesc|filter position}}',
	'srf-paramdesc-filtered-list-type' => '{{doc-paramdesc|list view type}}',
	'srf-paramdesc-filtered-list-template' => '{{doc-paramdesc|list view template}}',
	'srf-paramdesc-filtered-list-named-args' => '{{doc-paramdesc|list view named args}}',
	'srf-paramdesc-filtered-list-introtemplate' => '{{doc-paramdesc|list view introtemplate}}',
	'srf-paramdesc-filtered-list-outrotemplate' => '{{doc-paramdesc|list view outrotemplate}}',
	'srf-paramdesc-filtered-calendar-start' => '{{doc-paramdesc|calendar view start}}',
	'srf-paramdesc-filtered-calendar-end' => '{{doc-paramdesc|calendar view end}}',
	'srf-paramdesc-filtered-calendar-title' => '{{doc-paramdesc|calendar view title}}',
	'srf-paramdesc-filtered-calendar-title-template' => '{{doc-paramdesc|calendar view title template}}',
	'srf-filtered-selectorlabel-list' => 'The label for the tab that selects the "list" view',
	'srf-filtered-selectorlabel-calendar' => 'The label for the tab that selects the "calendar" view',
	'srf-filtered-firstdayofweek' => '{{optional}}
0 - sunday, 1 - monday...',
	'srf-printername-d3chart' => '{{doc-smwformat|d3chart}}
D3 is the name of the library used to generate the charts.',
	'srf-printername-timeseries' => '{{doc-smwformat|timeseries}}',
	'srf-paramdesc-group' => '{{doc-paramdesc|group}}',
	'srf-paramdesc-zoom' => '{{doc-paramdesc|zoom}}',
	'srf-paramdesc-datatable' => '{{doc-paramdesc|datatable}}',
	'srf-timeseries-zoom-out-of-range' => 'This is an informatory and/or error message.',
	'srf-printername-sparkline' => '{{doc-smwformat|sparkline}}',
	'srf-printername-listwidget' => '{{doc-smwformat|listwidget}}',
	'srf-paramdesc-listtype' => '{{doc-paramdesc|listtype}}',
	'srf-paramdesc-widget' => '{{doc-paramdesc|widget}}',
	'srf-paramdesc-pageitems' => '{{doc-paramdesc|pageitems}}',
	'srf-printername-eventcalendar' => '{{doc-smwformat|eventcalendar}}',
	'srf-paramdesc-calendarfirstday' => '{{doc-paramdesc|calendarfirstday}}',
	'srf-paramdesc-calendardefaultview' => '{{doc-paramdesc|calendardefaultview}}',
	'srf-paramdesc-calendarstart' => '{{doc-paramdesc|calendarstart}}',
	'srf-paramdesc-dayview' => '{{doc-paramdesc|dayview}}',
	'srf-ui-eventcalendar-label-today' => 'Text that will be displayed on buttons of the calendar header. See [http://www.semantic-mediawiki.org/wiki/Help:Event_calendar_format Event calendar format] and [http://arshaw.com/fullcalendar/docs/text/buttonText/ buttonText]',
	'srf-ui-eventcalendar-label-month' => 'Text that will be displayed on buttons of the calendar header. See [http://www.semantic-mediawiki.org/wiki/Help:Event_calendar_format Event calendar format] and [http://arshaw.com/fullcalendar/docs/text/buttonText/ buttonText]',
	'srf-ui-eventcalendar-label-week' => 'Text that will be displayed on buttons of the calendar header. See [http://www.semantic-mediawiki.org/wiki/Help:Event_calendar_format Event calendar format] and [http://arshaw.com/fullcalendar/docs/text/buttonText/ buttonText]',
	'srf-ui-eventcalendar-label-day' => 'Text that will be displayed on buttons of the calendar header. See [http://www.semantic-mediawiki.org/wiki/Help:Event_calendar_format Event calendar format] and [http://arshaw.com/fullcalendar/docs/text/buttonText/ buttonText]',
	'srf-ui-eventcalendar-label-allday' => 'Text that will be displayed on buttons of the calendar header. See [http://www.semantic-mediawiki.org/wiki/Help:Event_calendar_format Event calendar format] and [http://arshaw.com/fullcalendar/docs/text/buttonText/ buttonText]',
	'srf-ui-eventcalendar-format-time' => 'Determines the time-text that will be displayed on each event and is language dependent. For more see [http://arshaw.com/fullcalendar/docs/text/timeFormat/ here]',
	'srf-ui-eventcalendar-format-time-agenda' => 'Determines the time-text that will be displayed on each event and is language dependent. For more see [http://arshaw.com/fullcalendar/docs/text/timeFormat/ here]',
	'srf-ui-eventcalendar-format-axis' => 'Determines the time-text that will be displayed on the vertical axis of the agenda. See [http://arshaw.com/fullcalendar/docs/agenda/axisFormat/ axisFormat]',
	'srf-ui-eventcalendar-format-title-month' => "Determines the text that will be displayed in the header's title. See [http://arshaw.com/fullcalendar/docs/text/titleFormat/ titleFormat]",
	'srf-ui-eventcalendar-format-title-week' => "Determines the text that will be displayed in the header's title. See [http://arshaw.com/fullcalendar/docs/text/titleFormat/ titleFormat]",
	'srf-ui-eventcalendar-format-title-day' => "Determines the text that will be displayed in the header's title. See [http://arshaw.com/fullcalendar/docs/text/titleFormat/ titleFormat]",
	'srf-ui-eventcalendar-format-column-month' => "Determines the text that will be displayed on the calendar's column headings. See [http://arshaw.com/fullcalendar/docs/text/columnFormat/ columnFormat]",
	'srf-ui-eventcalendar-format-column-week' => "Determines the text that will be displayed on the calendar's column headings. See [http://arshaw.com/fullcalendar/docs/text/columnFormat/ columnFormat]",
	'srf-ui-eventcalendar-format-column-day' => "Determines the text that will be displayed on the calendar's column headings. See [http://arshaw.com/fullcalendar/docs/text/columnFormat/ columnFormat]",
	'srf-printername-dygraphs' => '{{doc-smwformat|dygraphs}}',
	'srf-paramdesc-datasource' => '{{doc-paramdesc|datasource}}',
	'srf-paramdesc-errorbar' => '{{doc-paramdesc|errorbar}}
{{doc-important|Do not translate <code>low;middle;high</code>}}',
	'srf-paramdesc-movingaverage' => '{{doc-paramdesc|movingaverage}}
{{doc-important|Do not translate <code>zero</code>}}',
	'srf-paramdesc-yaxislabel' => '{{doc-paramdesc|yaxislabel}}',
	'srf-paramdesc-xaxislabel' => '{{doc-paramdesc|xaxislabel}}',
	'srf-paramdesc-unit' => '{{doc-paramdesc|unit}}',
	'srf-printername-pagewidget' => '{{doc-smwformat|pagewidget}}',
	'srf-printername-incoming' => '{{doc-smwformat|incoming}}',
	'srf-paramdesc-min' => '{{doc-paramdesc|min}}',
	'srf-paramdesc-excludeproperty' => '{{doc-paramdesc|excludeproperty}}',
);

/** Afrikaans (Afrikaans)
 * @author SPQRobin
 */
$messages['af'] = array(
	'srfc_gotomonth' => 'Gaan na maand',
	'srf_icalendar_link' => 'iKalender',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'srfc_today' => 'ዛሬ',
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 * @author روخو
 */
$messages['ar'] = array(
	'srf-desc' => 'صيغ إضافية لاستعلامات ميدياويكي الداخلية',
	'srf-name' => 'صيغ النتائج الدلالية',
	'srfc_previousmonth' => 'الشهر السابق',
	'srfc_nextmonth' => 'الشهر التالي',
	'srfc_today' => 'اليوم',
	'srfc_gotomonth' => 'اذهب إلى شهر',
	'srf_printername_calendar' => 'نتيجة شهرية',
	'srf_vcard_link' => 'في كارد',
	'srf_printername_vcard' => 'تصدير vCard',
	'srf_icalendar_link' => 'آي كالندر',
	'srf_printername_icalendar' => 'تصدير iCalendar',
	'srf_paramdesc_icalendartitle' => 'عنوان ملف النتيجة',
	'srf_paramdesc_icalendardescription' => 'وصف ملف النتيجة',
	'srf_bibtex_link' => 'بب تكس',
	'srf_printername_bibtex' => 'تصدير BibTeX',
	'srf_outline_novalue' => 'لا قيم',
	'srf_printername_outline' => 'إطار',
	'srf_paramdesc_outlineproperties' => 'قائمة الخصائص ليتم عرضها كعناوين عامة، مفصولة بواسطة فاصلات',
	'srf_printername_sum' => 'مجموع الأرقام',
	'srf_printername_average' => 'متوسط الأرقام',
	'srf_printername_max' => 'الرقم الأقصى',
	'srf_printername_min' => 'الرقم الأدنى',
	'srf_paramdesc_limit' => 'أقصى عدد من الصفحات للاستعلام',
	'srf_printername_timeline' => 'خط زمني',
	'srf_printername_eventline' => 'خط الأحداث',
	'srf_paramdesc_timelinebands' => 'يعرف أي الفرق يتم عرضها في هذه النتيجة.',
	'srf_paramdesc_timelineposition' => 'يعرف أين يركز الخط الزمني ابتداء.',
	'srf_paramdesc_timelinestart' => 'اسم خاصية تستخدم لتعريف نقطة أول مرة',
	'srf_paramdesc_timelineend' => 'اسم خاصية تستخدم لتعريف نقطة ثاني مرة',
	'srf_paramdesc_timelinesize' => 'ارتفاع الخط الزمني',
	'srf_paramdesc_views' => 'عمليات الرؤية للعرض',
	'srf_paramdesc_facets' => 'مجموعة الخصائص للعرض لكل صفحة',
	'srf_paramdesc_lens' => 'اسم القالب لعرض خصائص الصفحة به',
	'srf_printername_googlebar' => 'رسم جوجل بالأعمدة',
	'srf_printername_googlepie' => 'رسم جوجل بالفطيرة',
	'srf_paramdesc_chartheight' => 'ارتفاع الخريطة/الرسم (بالبكسل)', # Fuzzy
	'srf_paramdesc_chartwidth' => 'عرض الرسم بالبكسل', # Fuzzy
	'srf_printername_tagcloud' => 'وسم سحابة',
	'srf_printername_array' => 'نسق',
	'srf_printername_hash' => 'تجزئة',
	'srf_paramdesc_graphname' => 'العنوان',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'srf-navigation-previous' => 'ܕܩܕܡ',
	'srf-ui-navigation-next' => 'ܕܒܬܪ',
	'srfc_previousmonth' => 'ܝܪܚܐ ܕܩܕܡ',
	'srfc_nextmonth' => 'ܝܪܚܐ ܕܒܬܪ',
	'srfc_today' => 'ܝܘܡܢܐ',
	'srfc_gotomonth' => 'ܙܠ ܠܝܪܚܐ',
	'srf_printername_calendar' => 'ܦܠܛܐ ܝܪܚܝܐ',
	'srf_printername_max' => 'ܡܬܚܐ ܥܠܝܐ ܕܡܢܝܢܐ',
	'srf_printername_min' => 'ܡܬܚܐ ܬܚܬܝܐ ܕܡܢܝܢܐ',
	'srf_printername_gallery' => 'ܒܝܬ ܓܠܚܐ',
	'srf-gallery-navigation-previous' => 'ܕܩܕܡ',
	'srf-gallery-navigation-next' => 'ܕܒܬܪ',
	'srf-gallery-overlay-count' => 'ܨܘܪܬܐ $1 ܡܢ $2',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 */
$messages['arz'] = array(
	'srf-desc' => 'صيغ إضافيه لاستعلامات ميدياويكى الداخلية',
	'srf-name' => 'صيغ النتائج الدلالية',
	'srfc_previousmonth' => 'الشهر السابق',
	'srfc_nextmonth' => 'الشهر التالي',
	'srfc_today' => 'اليوم',
	'srfc_gotomonth' => 'اذهب إلى شهر',
	'srf_printername_calendar' => 'نتيجه شهرية',
	'srf_vcard_link' => 'فى كارد',
	'srf_printername_vcard' => 'تصدير vCard',
	'srf_icalendar_link' => 'آى كالندر',
	'srf_printername_icalendar' => 'تصدير iCalendar',
	'srf_paramdesc_icalendartitle' => 'عنوان ملف النتيجة',
	'srf_paramdesc_icalendardescription' => 'وصف ملف النتيجة',
	'srf_printername_bibtex' => 'تصدير BibTeX',
	'srf_outline_novalue' => 'لا قيم',
	'srf_printername_outline' => 'إطار',
	'srf_paramdesc_outlineproperties' => 'قائمه الخصائص ليتم عرضها كعناوين عامه، مفصوله بواسطه فاصلات',
	'srf_printername_sum' => 'مجموع الأرقام',
	'srf_printername_average' => 'متوسط الأرقام',
	'srf_printername_max' => 'الرقم الأقصى',
	'srf_printername_min' => 'الرقم الأدنى',
	'srf_paramdesc_limit' => 'أقصى عدد من الصفحات للاستعلام', # Fuzzy
	'srf_printername_timeline' => 'خط زمني',
	'srf_printername_eventline' => 'خط الأحداث',
	'srf_paramdesc_timelinebands' => 'يعرف أى الفرق يتم عرضها فى هذه النتيجه.',
	'srf_paramdesc_timelineposition' => 'يعرف أين يركز الخط الزمنى ابتداء.',
	'srf_paramdesc_timelinestart' => 'اسم خاصيه تستخدم لتعريف نقطه أول مرة',
	'srf_paramdesc_timelineend' => 'اسم خاصيه تستخدم لتعريف نقطه ثانى مرة',
	'srf_paramdesc_timelinesize' => 'ارتفاع الخط الزمنى',
	'srf_paramdesc_views' => 'عمليات الرؤيه للعرض',
	'srf_paramdesc_facets' => 'مجموعه الخصائص للعرض لكل صفحة',
	'srf_paramdesc_lens' => 'اسم القالب لعرض خصائص الصفحه به',
	'srf_printername_googlebar' => 'رسم جوجل بالأعمدة',
	'srf_printername_googlepie' => 'رسم جوجل بالفطيرة',
	'srf_paramdesc_chartheight' => 'ارتفاع الرسم بالبكسل', # Fuzzy
	'srf_paramdesc_chartwidth' => 'عرض الرسم بالبكسل', # Fuzzy
);

/** Azerbaijani (azərbaycanca)
 * @author Cekli829
 */
$messages['az'] = array(
	'srfc_today' => 'Bu gün',
	'srf_printername_gallery' => 'Qalereya',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'srf-desc' => 'Дадатковыя фарматы для ўбудаваных запытаў Semantic MediaWiki', # Fuzzy
	'srf-name' => 'Фарматы сэмантычных вынікаў',
	'srfc_previousmonth' => 'Папярэдні месяц',
	'srfc_nextmonth' => 'Наступны месяц',
	'srfc_today' => 'Сёньня',
	'srfc_gotomonth' => 'Перайсьці да месяца',
	'srf_printername_calendar' => 'Каляндар на месяц',
	'srf_paramdesc_calendarlang' => 'Код мовы, на якой паказваць каляндар',
	'srf_printername_vcard' => 'экспарт у фармаце vCard',
	'srf_printername_icalendar' => 'экспарт у фармаце iCalendar',
	'srf_paramdesc_icalendartitle' => 'Назва файла календара',
	'srf_paramdesc_icalendardescription' => 'Апісаньне файла календара',
	'srf_printername_bibtex' => 'экспарт у фармаце BibTeX',
	'srf_outline_novalue' => 'Няма значэньня',
	'srf_printername_outline' => 'Табліца',
	'srf_paramdesc_outlineproperties' => 'Сьпіс уласьцівасьцяў для паказу ў якасьці загалоўкаў, падзеленых коскамі',
	'srf_printername_sum' => 'Сума лікаў',
	'srf_printername_average' => 'Сярэдняе значэньне лікаў',
	'srf_printername_max' => 'Максымальны лік',
	'srf_printername_min' => 'Мінімальны лік',
	'srf_paramdesc_limit' => 'Максымальная колькасьць старонак для запыту',
	'srf_printername_product' => 'Вынік лічбаў',
	'srf_printername_timeline' => 'Храналёгія',
	'srf_printername_eventline' => 'Храналёгія падзеяў',
	'srf_paramdesc_timelinebands' => 'Вызначае, якія дыяпазоны будуць паказаныя ў выніку.',
	'srf_paramdesc_timelineposition' => 'Вызначае, якое месца шкалы часу будзе паказвацца спачатку.',
	'srf_paramdesc_timelinestart' => 'Назва ўласьцівасьці, якая выкарыстоўваецца як першы пункт часу',
	'srf_paramdesc_timelineend' => 'Назва ўласьцівасьці, якая выкарыстоўваецца для вызначэньня другога пункту часу',
	'srf_paramdesc_timelinesize' => 'Вышыня шкалы часу',
	'srf-timeline-allresults' => 'Дадатковыя вынікі па гэтым запыце.',
	'srf-timeline-nojs' => 'Вам неабходна дазволіць JavaScript, каб праглядаць інтэрактыўную лінію часу.',
	'srf_paramdesc_views' => 'Прагляды для паказу',
	'srf_paramdesc_facets' => 'Набор ўласьцівасьцяў для паказу на кожнай старонцы',
	'srf_paramdesc_lens' => 'Назва шаблёну для паказу ўласьцівасьцяў старонкі',
	'srf_printername_googlebar' => 'Слупковая дыяграма Google',
	'srf_printername_googlepie' => 'Кругавая дыяграма Google',
	'srf_paramdesc_chartheight' => 'Вышыня дыяграмы ў піксэлях', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Шырыня дыяграмы ў піксэлях', # Fuzzy
	'srf_paramdesc_charttitle' => 'Назва дыяграмы',
	'srf_paramdesc_barcolor' => 'Колер слупкоў',
	'srf_paramdesc_bardirection' => 'Накіраваньне слупкоў дыяграмы', # Fuzzy
	'srf_paramdesc_barnumbersaxislabel' => 'Надпісы для лічбавых восяў',
	'srf_printername_gallery' => 'Галерэя',
	'srf_paramdesc_perrow' => 'Колькасьць выяваў у радку',
	'srf_paramdesc_widths' => 'Шырыня выяваў',
	'srf_paramdesc_heights' => 'Вышыня выяваў',
	'srf_paramdesc_autocaptions' => 'Выкарыстоўваць назву файла ў якасьці загалоўку, калі ён не пададзены',
	'srf_paramdesc_fileextensions' => 'Падчас выкарыстаньня назвы файла ў якасьці загалоўку, таксама паказваць пашырэньне файла',
	'srf_printername_tagcloud' => 'Воблака тэгаў',
	'srf_paramdesc_increase' => 'Як павялічыць памер тэгаў',
	'srf_paramdesc_tagorder' => 'Парадак тэгаў',
	'srf_paramdesc_minsize' => 'Памер самых малых тэгаў у адсотках',
	'srf_paramdesc_maxsize' => 'Памер самых вялікіх тэгаў у адсотках',
	'srf_paramdesc_maxtags' => 'Максымальная колькасьць тэгаў у воблаку',
	'srf_printername_array' => 'Масіў',
	'srf_paramdesc_pagetitle' => 'Ці паказваць назвы старонак як элемэнты вынікаў ці іх хаваць', # Fuzzy
	'srf_paramdesc_hidegaps' => 'Ці паказваць пустыя ўласьцівасьці і значэньні запісаў падзеленыя разьдзяляльнікамі ці іх хаваць', # Fuzzy
	'srf_paramdesc_propsep' => 'Разьдзяляльнік паміж запытанымі ўласьцівасьцямі',
	'srf_paramdesc_manysep' => 'Разьдзяляльнік паміж ўласьцівасьцямі з некалькімі значэньнямі', # Fuzzy
	'srf_paramdesc_recordsep' => 'Разьдзяляльнік паміж значэньнямі запісаных уласьцівасьцяў',
	'srf_printername_hash' => 'Рашотка',
	'srf-printername-graph' => 'Графік',
	'srf_paramdesc_graphname' => 'Назва',
	'srf_paramdesc_graphsize' => 'Памер дыяграмы (у піксэлях)',
);

/** Bulgarian (български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'srfc_previousmonth' => 'Предходен месец',
	'srfc_nextmonth' => 'Следващ месец',
	'srfc_today' => 'Днес',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'srfc_previousmonth' => 'পূর্ববর্তী মাস',
	'srfc_nextmonth' => 'পরবর্তী মাস',
	'srfc_today' => 'আজ',
	'srfc_gotomonth' => 'যে মাসে যাবেন',
	'srf_printername_calendar' => 'মাসিক ক্যালেন্ডার',
	'srf_outline_novalue' => 'কোনো মান নাই',
	'srf_printername_sum' => 'সমষ্টি',
	'srf_printername_average' => 'গড়',
	'srf_printername_max' => 'সর্বোচ্চ',
	'srf_printername_min' => 'সর্বোনিম্ন',
	'srf_printername_googlebar' => 'গুগল বার চার্ট',
	'srf_printername_gallery' => 'গ্যালারি',
	'srf_paramdesc_perrow' => 'প্রতি সারিতে ছবির সংখ্যা',
	'srf_paramdesc_widths' => 'ছবির প্রস্থ',
	'srf_paramdesc_heights' => 'ছবির উচ্চতা',
	'srf_printername_array' => 'অ্যারে',
	'srf_paramdesc_graphname' => 'শিরোনাম',
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Gwendal
 * @author Gwenn-Ael
 * @author Y-M D
 */
$messages['br'] = array(
	'srf-desc' => 'Furmadoù ouzhpenn evit ar rekedoù Semantic MediaWiki',
	'srf-name' => "Furmadoù an disoc'hoù semantek",
	'srfc_previousmonth' => 'Miz a-raok',
	'srfc_nextmonth' => 'Miz a zeu',
	'srfc_today' => 'Hiziv',
	'srfc_gotomonth' => "Mont d'ar miz",
	'srf_printername_calendar' => 'Deiziataer miziek',
	'srf_paramdesc_calendarlang' => 'Kod ar yezh a dalvez da ziskwel an deiziadur',
	'srf_printername_vcard' => 'Ezporzh e vCard',
	'srf_printername_icalendar' => 'Enporzh e iCalendar',
	'srf_paramdesc_icalendartitle' => 'Titl ar restr deiziataer',
	'srf_paramdesc_icalendardescription' => 'Deskrivadur restr an deiziataer',
	'srf_printername_bibtex' => 'Enporzh e BibTeX',
	'srf_outline_novalue' => 'Talvoud ebet',
	'srf_printername_outline' => 'Trolinenn',
	'srf_paramdesc_outlineproperties' => 'Roll ar perzhioù da ziskwel evel talbennoù, dispartiet gant skejoù.',
	'srf_printername_sum' => 'Sammad niveroù',
	'srf_printername_average' => 'Keitad an niveroù',
	'srf_printername_max' => 'Niver uhelañ',
	'srf_printername_min' => 'Niver izelañ',
	'srf_paramdesc_limit' => "Niver brasañ a bajennoù da gerc'hat",
	'srf_printername_timeline' => 'Kronologiezh',
	'srf_printername_eventline' => 'Kronologiezh an darvoudoù',
	'srf_paramdesc_timelinebands' => "a zielfenn peseurt strolladoù zo diskwelet en disoc'hoù.",
	'srf_paramdesc_timelineposition' => 'a zielfenn takad ar frizenn a oa kreizennet da gentañ.',
	'srf_paramdesc_timelinestart' => "Un anv perzh implijet da dermeniñ ur poent loc'hañ en amzer",
	'srf_paramdesc_timelineend' => 'Un anv perzh implijet da dermeniñ un eil poent en amzer',
	'srf_paramdesc_timelinesize' => 'Uhelder ar frizenn',
	'srf-timeline-allresults' => "Disoc'hoù ouzhpenn evit ar reked-mañ.",
	'srf_paramdesc_views' => 'Ar gweladennoù da ziskouez',
	'srf_paramdesc_facets' => 'An hollad perzhioù da ziskwel evit pep pajenn',
	'srf_paramdesc_lens' => 'Anv ar patrom implijet evit diskouez perzhioù ar bajenn',
	'srf_printername_googlebar' => 'Grafik barrennek Google',
	'srf_printername_googlepie' => 'Grafik dre lodennoù Google',
	'srf_paramdesc_chartheight' => 'Uhelder an diagramm, e piksel', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Ledander an diagramm, e piksel', # Fuzzy
	'srf_paramdesc_charttitle' => 'Titl ar grafik',
	'srf_paramdesc_barcolor' => 'Liv ar barrennoù',
	'srf_paramdesc_bardirection' => "Spisaat durc'hadur ur grafik",
	'srf_paramdesc_barnumbersaxislabel' => 'Tikedenn ahel an niveroù',
	'srf_printername_gallery' => 'Skeudennaoueg',
	'srf_paramdesc_perrow' => 'An niver a skeudennoù dre linenn',
	'srf_paramdesc_widths' => 'Ledander ar skeudennoù',
	'srf_paramdesc_heights' => 'Uhelder ar skeudennoù',
	'srf_paramdesc_autocaptions' => "Ober gant anv ar restr da alc'hwez ma n'eus ket bet resisaet hini",
	'srf_printername_tagcloud' => 'Nivlennad tikedennoù',
	'srf_paramdesc_includesubject' => 'Ma tlefer lakaat e-barzh anv an danvezioù o-unan',
	'srf_paramdesc_increase' => 'Penaos kreskiñ ment an tikedennoù',
	'srf_paramdesc_tagorder' => 'Urzh an tikedennoù',
	'srf_paramdesc_mincount' => 'Nizver izelañ a wezhioù e rank un dalvoudenn bezañ implijet evit bezañ rollet',
	'srf_paramdesc_minsize' => 'Ment an dikedenn vihanañ e dregantad',
	'srf_paramdesc_maxsize' => 'Ment an dikedenn vrasañ e dregantad',
	'srf_paramdesc_maxtags' => 'Niver brasañ a dikedennoù en nivlennad',
	'srf_printername_array' => 'Taolenn',
	'srf_printername_hash' => 'Hacherezh',
	'srf-printername-graph' => 'Grafik',
	'srf_paramdesc_graphname' => 'Titl',
	'srf_paramdesc_graphsize' => 'Ment ar grafik (e px)',
	'srf_paramdesc_graphlegend' => "Diskouez alc'hwez ar grafik pe get",
	'srf_paramdesc_graphlabel' => 'Tikedenn ar grafik',
	'srf_paramdesc_rankdir' => "Durc'hadur ar bir",
	'srf_paramdesc_graphlink' => 'Liamm war-zu ar grafik',
	'srf_paramdesc_graphcolor' => 'Liv ar grafik',
	'srf_printername_tree' => 'Gwezenn',
	'srf_printername_ultree' => 'Gwezenn Ul',
	'srf-printername-slideshow' => "Kinnig luc'hvannoù",
	'srf-printername-filtered' => 'Silet',
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'srf-desc' => 'Dodatni formati za linijske upite na Semantic MediaWiki',
	'srf-name' => 'Formati semantičkih rezultata',
	'srfc_previousmonth' => 'Prethodni mjesec',
	'srfc_nextmonth' => 'Slijedeći mjesec',
	'srfc_today' => 'Danas',
	'srfc_gotomonth' => 'Idi na mjesec',
	'srf_printername_calendar' => 'Mjesečni kalendar',
	'srf_printername_vcard' => 'Izvoz u vCard',
	'srf_printername_icalendar' => 'Izvoz u iCalendar',
	'srf_paramdesc_icalendartitle' => 'Naslov datoteke kalendara',
	'srf_printername_bibtex' => 'Izvoz u BibTeX',
	'srf_outline_novalue' => 'Nema vrijednosti',
	'srf_printername_outline' => 'Kontura',
	'srf_printername_sum' => 'Zbir brojeva',
	'srf_printername_average' => 'Prosjek brojeva',
	'srf_printername_max' => 'Najveći broj',
	'srf_printername_min' => 'Najmanji broj',
	'srf_paramdesc_limit' => 'Najveći broj stranica za upit',
	'srf_printername_timeline' => 'Vremenska linija',
	'srf_printername_eventline' => 'Linija događaja',
	'srf_paramdesc_timelinesize' => 'Visina vremenske linije',
);

/** Catalan (català)
 * @author Dvdgmz
 * @author Paucabot
 * @author Toniher
 */
$messages['ca'] = array(
	'srf-desc' => 'Formats addicionals per a les consultes en línia del Semantic MediaWiki.',
	'srf-name' => 'Semantic Result Formats',
	'srfc_previousmonth' => 'Mes anterior',
	'srfc_nextmonth' => 'Mes posterior',
	'srfc_today' => 'Avui',
	'srfc_gotomonth' => 'Vés al mes',
	'srf_printername_calendar' => 'Calendari mensual',
	'srf_paramdesc_calendarlang' => 'El codi de la llengua en què es mostrarà el calendari',
	'srf_printername_vcard' => 'Exportació vCard',
	'srf_printername_icalendar' => 'Exportació iCalendar',
	'srf_paramdesc_icalendartitle' => 'El títol del fitxer del calendari',
	'srf_paramdesc_icalendardescription' => 'La descripció del fitxer del calendari',
	'srf_printername_bibtex' => 'Exportació BibTeX',
	'srf_outline_novalue' => 'Sense valor',
	'srf_printername_sum' => 'Suma dels nombres',
	'srf_printername_average' => 'Mitjana dels nombres',
	'srf_printername_max' => 'Nombre màxim',
	'srf_printername_min' => 'Nombre mínim',
	'srf_paramdesc_limit' => 'El nombre màxim de pàgines per consultar',
	'srf_printername_product' => 'Producte de nombres',
	'srf_printername_median' => 'Mediana de nombres',
	'srf_printername_timeline' => 'Línia temporal',
	'srf_printername_eventline' => "Línia d'esdeveniments",
	'srf_paramdesc_timelinebands' => 'Defineix quines bandes es mostren en el resultat.',
	'srf_paramdesc_timelineposition' => "Defineix on s'enfoca inicialment la línia temporal.",
	'srf_paramdesc_timelinesize' => 'La llargada de la línia de temps',
	'srf-timeline-allresults' => "Més resultats d'aquesta consulta.",
	'srf_paramdesc_lens' => "El nom d'una plantilla amb què mostrar les propietats de la pàgina",
	'srf_paramdesc_barnumbersaxislabel' => "L'etiqueta de l'eix de nombres",
	'srf_printername_gallery' => 'Galeria',
	'srf_paramdesc_perrow' => "El nombre d'imatges per fila",
	'srf_paramdesc_widths' => "L'amplada de les imatges",
	'srf_paramdesc_heights' => "L'alçada de les imatges",
	'srf_paramdesc_autocaptions' => "Utilitza el nom de fitxer com a llegenda quan no se'n proporcioni cap",
	'srf_printername_tagcloud' => "Núvol d'etiquetes",
	'srf_paramdesc_increase' => 'Com augmentar la mida de les etiquetes',
	'srf_paramdesc_tagorder' => "L'ordre de les etiquetes",
	'srf_paramdesc_maxtags' => "El nombre màxim d'etiquetes en el núvol",
	'srf_paramdesc_propsep' => 'Separador entre les propietats sol·licitades',
	'srf_paramdesc_manysep' => 'Separador entre moltes propietats amb valor', # Fuzzy
	'srf_paramdesc_recordsep' => 'Separador entre els valors de les propietats de registre',
	'srf-printername-graph' => 'Gràfic',
	'srf-paramdesc-graph-nodeshape' => 'La forma de cada node en el gràfic',
	'srf_paramdesc_graphname' => 'Títol',
	'srf_paramdesc_graphsize' => 'Mida del gràfic (en px)',
	'srf_paramdesc_graphlabel' => 'Etiqueta del gràfic',
	'srf_paramdesc_rankdir' => 'Direcció de la fletxa',
	'srf_paramdesc_graphlink' => 'Enllaç del gràfic',
	'srf_paramdesc_graphcolor' => 'Color del gràfic',
);

/** Czech (česky)
 * @author Vks
 */
$messages['cs'] = array(
	'srfc_previousmonth' => 'Předchozí měsíc',
	'srfc_nextmonth' => 'Další měsíc',
	'srfc_today' => 'Dnes',
	'srfc_gotomonth' => 'Přejdi na měsíc',
	'srf_printername_calendar' => 'Měsíční kalendář',
	'srf_paramdesc_calendarlang' => 'Kód jazyka, ve kteréem bude zobrazován kalendář',
	'srf_printername_vcard' => 'export vCard',
	'srf_printername_icalendar' => 'export iCalendar',
	'srf_paramdesc_icalendartitle' => 'titulek souboru s kalendářem',
	'srf_paramdesc_icalendardescription' => 'Popisek souboru s kalendářem',
	'srf_printername_bibtex' => 'export BibTeX',
	'srf_outline_novalue' => 'Žádná hodnota',
	'srf_printername_outline' => 'Náčrtek',
	'srf-gallery-navigation-previous' => 'Předchozí',
	'srf-gallery-navigation-next' => 'Následujicí',
	'srf-gallery-overlay-count' => 'Obrázek $1 z $2',
	'srf_printername_tagcloud' => 'Oblak nálepek',
	'srf_printername_array' => 'Pole',
	'srf_printername_hash' => 'Asociativní pole (Haš)',
	'srf_paramdesc_graphname' => 'Název',
	'srf_paramdesc_graphsize' => 'Velikost grafu (v pixelech)',
	'srf_printername_tree' => 'Strom',
);

/** German (Deutsch)
 * @author DaSch
 * @author Imre
 * @author Kghbln
 * @author Krabina
 * @author Metalhead64
 * @author Nipsky
 * @author Purodha
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de'] = array(
	'srf-desc' => 'Ermöglicht zusätzliche Ausgabeformate für eingebettete Abfragen',
	'srf-name' => 'Semantische Ergebnisformate',
	'prefs-srf' => 'Semantische Ergebnisformate',
	'srf-prefs-intro-text' => 'Du hast die Programmerweiterung „Semantic Result Formats“ installiert, die derzeit keine anpassbaren Benutzeroptionen ermöglicht. Besuch bitte die [http://www.semantic-mediawiki.org/wiki/Help:Ergebnisformate Hilfeseite zu Ergebnisformaten], für weitere Informationen.',
	'srf-module-loading' => 'Lade …',
	'srf-paramdesc-layout' => 'Das verfügbare Layout',
	'srf-paramdesc-height' => 'Die Höhe (in Pixel)',
	'srf-paramdesc-width' => 'Die Breite',
	'srf-paramdesc-class' => 'Die CSS-Klasse angeben, die zusätzlich verwendet werden soll',
	'srf-module-nomatch' => 'Es wurden keine Übereinstimmungen gefunden.',
	'srf-paramdesc-charttype' => 'Den Diagrammtyp angeben',
	'srf-navigation-previous' => 'Vorherige',
	'srf-ui-navigation-prev' => 'Zurück',
	'srf-ui-navigation-next' => 'Vor',
	'srf-ui-common-label-source' => 'Quelle',
	'srf-ui-common-label-datasource' => 'Datenquelle',
	'srf-ui-common-label-ajax-error' => 'Der Server meldete eine fehlgeschlagene Kommunikation für diesen $1. Bitte versuche, die Seite neu zu laden oder wende dich an $2.',
	'srf-ui-common-label-request-object' => 'Objekt abfragen',
	'srf-ui-common-label-help-section' => 'Hilfeabschnitt',
	'srf-ui-tooltip-title-options' => 'Optionen',
	'srf-ui-tooltip-title-scope' => 'Bereich',
	'srf-error-option-mix' => 'Option ($1) ist nicht verfügbar',
	'srf-error-option-link-all' => 'Zur Option ($1) muss beim Paramenter „link“ der Wert „all“ gesetzt werden.',
	'srf-error-missing-layout' => 'Es wurde kein Layout angegeben.',
	'srf-warn-empy-chart' => 'Es konnte kein Diagramm / keine Grafik erstellt werden, da keine ausreichenden Daten zum Erstellen vorhanden waren.',
	'srfc_previousmonth' => 'Voriger Monat',
	'srfc_nextmonth' => 'Nächster Monat',
	'srfc_today' => 'Heute',
	'srfc_gotomonth' => 'Gehe zu Monat',
	'srf_printername_calendar' => 'Zeit (Kalender)',
	'srf_paramdesc_calendarlang' => 'Der Sprachcode der Sprache, in der der Kalender angezeigt werden soll',
	'srf_paramdesc_calendarcolors' => 'Die für das jeweilige Datumsattribut zur Darstellung zu verwendende Farbe (Beispiel: „Startdatum=>green,Enddatum=>#09C“)',
	'srf_printername_vcard' => 'Export (vCard)',
	'srf_printername_icalendar' => 'Export (iCalendar)',
	'srf_paramdesc_icalendartitle' => 'Der Name für die Kalenderdatei',
	'srf_paramdesc_icalendardescription' => 'Die Beschreibung der Kalenderdatei',
	'srf_printername_bibtex' => 'Export (BibTeX)',
	'srf_outline_novalue' => 'Kein Wert',
	'srf_printername_outline' => 'Gliederung',
	'srf_paramdesc_outlineproperties' => 'Die Liste der mit Kommata voneinander getrennten Attribute, die in der Kopfzeile der Gliederung angezeigt werden sollen',
	'srf_printername_sum' => 'Zahlen (Summe)',
	'srf_printername_average' => 'Zahlen (Durchschnitt)',
	'srf_printername_max' => 'Zahlen (höchste Zahl)',
	'srf_printername_min' => 'Zahlen (niedrigste Zahl)',
	'srf_paramdesc_limit' => 'Die maximale Anzahl der abzufragenden Seiten',
	'srf_printername_product' => 'Zahlen (Produkt)',
	'srf_printername_median' => 'Zahlen (Median)',
	'srf-paramdesc-default' => 'Der Standardwert, der angezeigt wird, sofern keine numerischen Ergebnisse vorhanden sind.',
	'srf_printername_earliest' => 'Zeit (frühester Zeitpunkt)',
	'srf_printername_latest' => 'Zeit (spätester Zeitpunkt)',
	'srf_printername_timeline' => 'Zeit (Zeitlinie)',
	'srf_printername_eventline' => 'Zeit (Ereignislinie)',
	'srf_paramdesc_timelinebands' => 'Die Zeitleisten, die angezeigt werden sollen',
	'srf_paramdesc_timelineposition' => 'Die Stelle, an der sich die Zeitleiste ausrichten soll',
	'srf_paramdesc_timelinestart' => 'Der Name des Attributs, mit dem der erste anzuzeigende Zeitpunkt festgelegt wird',
	'srf_paramdesc_timelineend' => 'Der Name des Attributs, mit dem der zweite anzuzeigende Zeitpunkt festgelegt wird',
	'srf_paramdesc_timelinesize' => 'Die Höhe der Zeitleiste(n)',
	'srf-timeline-allresults' => 'Weitere Ergebnisse dieser Abfrage.',
	'srf-timeline-nojs' => 'JavaScript muss aktiviert sein, damit man die interaktive Zeitleiste ansehen kann.',
	'srf_paramdesc_views' => 'Die anzuzeigenden Ansichten',
	'srf_paramdesc_facets' => 'Die Gruppe der Attribute, die für jede Seite angezeigt werden sollen',
	'srf_paramdesc_lens' => 'Der Name einer Vorlage zum Anzeigen der Seiteneigenschaften',
	'srf_printername_googlebar' => 'Diagramm (Säulendiagramm - Google)',
	'srf_printername_googlepie' => 'Diagramm (Tortendiagramm - Google)',
	'srf-printername-jqplotchart' => 'Diagramm (jqPlot)',
	'srf-printername-jqplotseries' => 'Diagramm (Datenreihe - jqPlot)',
	'srf_paramdesc_chartheight' => 'Die Höhe des Diagramms / der Grafik (in Pixeln) angeben',
	'srf_paramdesc_chartwidth' => 'Die Breite des Diagramms / der Grafik (in Pixeln) angeben',
	'srf_paramdesc_charttitle' => 'Der Titel des Diagramms',
	'srf_paramdesc_barcolor' => 'Die Farbe der Balken',
	'srf_paramdesc_bardirection' => 'Die Darstellung eines Diagramms bestimmen (entweder Balken oder Säulen)',
	'srf-paramdesc-direction' => 'Die Ausrichtung des Diagramms / der Grafik angeben',
	'srf_paramdesc_barnumbersaxislabel' => 'Die Beschriftung der y-Achse',
	'srf-paramdesc-labelaxislabel' => 'Die Beschriftung der y-Achse',
	'srf-paramdesc-ticklabels' => 'Die Anzeige von Teilstrichbeschriftungen aktivieren',
	'srf-paramdesc-minvalue' => 'Der niedrigste Wert, der auf der y-Achse angezeigt werden soll',
	'srf-paramdesc-pointlabels' => 'Die Anzeige der Diagrammdatenpunkte',
	'srf-paramdesc-chartlegend' => 'Die Position der Diagrammlegenden',
	'srf-paramdesc-datalabels' => 'Die Diagramm- und Grafikbeschriftungen',
	'srf-paramdesc-charttext' => 'Der beschreibende Diagrammtext',
	'srf-paramdesc-chartclass' => 'Die zusätzliche CSS-Klasse',
	'srf-paramdesc-renderer' => 'Das Programm zum Rendern des Diagramms / der Grafik auswählen',
	'srf-paramdesc-filling' => 'Die individuelle Fülloption',
	'srf-paramdesc-theme' => 'Die Anmutung für das Raster auswählen',
	'srf-paramdesc-chartcolor' => 'Die individuellen Diagrammfarben zuteilen',
	'srf-paramdesc-colorscheme' => 'Wähle ein Farbschema',
	'srf-paramdesc-valueformat' => 'Die Formatierungsregel für Werte bestimmen',
	'srf-paramdesc-highlighter' => 'Eine Hervorhebung zu Datenpunkten anzeigen',
	'srf-paramdesc-smoothlines' => 'Einen Algorithmus zum Glätten der Anzeige von Liniendiagrammen einsetzen',
	'srf-paramdesc-stackseries' => 'Diagramm als gestapelte Reihen anzeigen',
	'srf-paramdesc-seriesgroup' => 'Die Gruppierung von Datenreihen auswählen',
	'srf-paramdesc-serieslabel' => 'Die Reihenbeschriftung bestimmen',
	'srf-paramdesc-grouplabel' => 'Die Gruppenbeschriftung bestimmen',
	'srf-paramdesc-chartcursor' => 'Die Option zur Anzeige des Cursors in der Grafik',
	'srf-paramdesc-trendline' => 'Das gleichzeitige Anzeigen des Diagramms und der Trendlinie aktivieren',
	'srf-paramdesc-gridview' => 'Das Diagramm und die Datensätze simultan anzeigen',
	'srf-paramdesc-infotext' => 'Die zusätzlichen Informationen auf dem entsprechenden Inforeiter anzeigen',
	'srf-ui-gridview-label-item' => 'Datenelement',
	'srf-ui-gridview-label-value' => 'Datenwert',
	'srf-ui-gridview-label-series' => 'Datenreihen',
	'srf-ui-gridview-label-chart-tab' => 'Diagramm',
	'srf-ui-gridview-label-data-tab' => 'Daten',
	'srf-ui-gridview-label-info-tab' => 'Informationen',
	'srf_printername_gallery' => 'Bild (Galerie)',
	'srf_paramdesc_perrow' => 'Die Anzahl der Bilder pro Zeile',
	'srf_paramdesc_widths' => 'Die Breite der Bilder',
	'srf_paramdesc_heights' => 'Die Höhe der Bilder',
	'srf_paramdesc_autocaptions' => 'Den Dateinamen als Beschreibung verwenden, sofern keine angegeben wurde',
	'srf_paramdesc_fileextensions' => 'Sofern der Dateiname als Beschreibung verwendet wird, ebenso die Dateierweiterung anzeigen',
	'srf_paramdesc_captionproperty' => 'Der Name des Attributs auf abgefragten Seiten, der als Beschreibung verwendet werden soll',
	'srf_paramdesc_imageproperty' => 'Der Name des Attributs auf abgefragten Seiten, das auf das zu verwendende Bild hinweist. Sofern festgelegt, werden die abgefragten Seiten selbst, nicht als Bild angezeigt.',
	'srf-paramdesc-redirects' => 'Der Name des semantischen Attributs, welches das Ziel der Weiterleitung enthält',
	'srf-paramdesc-navigation' => 'Die Navigationssteuerung zum Layout',
	'srf-paramdesc-overlay' => 'Die Bildüberblendungen aktivieren',
	'srf-gallery-navigation-previous' => 'Zurück',
	'srf-gallery-navigation-next' => 'Weiter',
	'srf-gallery-overlay-count' => 'Bild $1 von $2',
	'srf-gallery-image-url-error' => 'Das Bild wurde nicht gefunden.',
	'srf_printername_tagcloud' => 'Stichwortwolke',
	'srf_paramdesc_includesubject' => 'Ob die Themenbezeichnungen selbst mit einbezogen werden sollen',
	'srf_paramdesc_increase' => 'Wie soll die Darstellungsgröße der Stichwörter verändert werden?',
	'srf_paramdesc_tagorder' => 'Die Reihenfolge der Stichwörter',
	'srf_paramdesc_mincount' => 'Das Mindestvorkommen eines Stichwortes, um aufgelistet zu werden',
	'srf_paramdesc_minsize' => 'Die Darstellungsgröße des kleinsten Stichwortes in Prozent',
	'srf_paramdesc_maxsize' => 'Die Darstellungsgröße des größten Stichwortes in Prozent',
	'srf_paramdesc_maxtags' => 'Die maximale Anzahl der Stichwörter in der Stichwortwolke',
	'srf-paramdesc-excludetags' => 'Die auszuschließenden Stichworte (Trennzeichen: ;)',
	'srf_printername_valuerank' => 'Liste (Rangfolge)',
	'srf_printername_array' => 'Datenfeld (Array)',
	'srf_paramdesc_pagetitle' => 'Legt fest ob Seitentitel in der Ergebnisliste angezeigt oder weggelassen werden sollen',
	'srf_paramdesc_hidegaps' => 'Legt fest, ob abgefragte, aber nicht vorhandene Attribut- und Datensatzwerte, durch Trennzeichen getrennt, angezeigt oder weggelassen werden sollen',
	'srf_paramdesc_arrayname' => 'Sofern die Erweiterung Arrays installiert ist, wird anstelle einer sichtbaren Ergebnisausgabe ein Datenfeld (Array) dieses Namens angelegt',
	'srf_paramdesc_propsep' => 'Das Trennzeichen zwischen gewünschten Attributen',
	'srf_paramdesc_manysep' => 'Das Trennzeichen zwischen mehreren Attributwerten eines Attributs',
	'srf_paramdesc_recordsep' => 'Das Trennzeichen zwischen den einzelnen Werten eines Attributs von Datentyp Verbund',
	'srf_paramdesc_headersep' => 'Das Trennzeichen zwischen Attributnamen und -wert, sofern für den Parameter „headers“ entweder „show“ oder „plain“ festgelegt wurde',
	'srf_printername_hash' => 'Assoziatives Datenfeld (Hash)',
	'srf_paramdesc_hashname' => 'Sofern die Erweiterung HashTables vorhanden ist, wird anstelle einer sichtbaren Ergebnisausgabe ein assoziatives Datenfeld (Hash) dieses Namens angelegt',
	'srf-printername-graph' => 'Grafik',
	'srf-paramdesc-graph-relation' => 'Sind die Betreffe oder Namensattribute Haupt- oder Unterobjekte?',
	'srf-paramdesc-graph-nameprop' => 'Das Attribut, dessen Wert als Betreff anstelle des eigentlichen Betreffs genutzt werden soll',
	'srf-paramdesc-graph-nodeshape' => 'Die Form der Datenpunkte in der Grafik',
	'srf_paramdesc_graphname' => 'Titel der Grafik',
	'srf_paramdesc_graphsize' => 'Größe der Grafik (in Pixeln)',
	'srf_paramdesc_graphlegend' => 'Legende zur Grafik anzeigen oder nicht',
	'srf_paramdesc_graphlabel' => 'Beschriftung der Grafik',
	'srf_paramdesc_rankdir' => 'Pfeilrichtung',
	'srf_paramdesc_graphlink' => 'Link zur Grafik',
	'srf_paramdesc_graphcolor' => 'Farbe der Grafik',
	'srf-paramdesc-graph-wwl' => 'Begrenzung des Textumbruchs (Anzahl der Zeichen)',
	'srf_printername_datatables' => 'Datentabellen',
	'srf-paramdesc-rowindex' => 'Zeilenindex der Tabelle',
	'srf-paramdesc-displaylength' => 'Ausgangsanzeigelänge',
	'srf_printername_tree' => 'Baumansicht (aufgezählt)',
	'srf_printername_ultree' => 'Baumansicht (aufgezählt)',
	'srf_printername_oltree' => 'Baumansicht (nummeriert)',
	'srf-noparentprop' => 'Es wurde kein übergeordnetes Attribut angegeben. Der Baum kann nicht ohne Angabe eines übergeordneten Attributs erstellt werden.',
	'srf-paramdesc-parent' => 'Das Attribut, das die übergeordnete Seite enthält',
	'srf-printername-slideshow' => 'Bild (Vorführung)',
	'srf-paramdesc-delay' => 'Die Verzögerung beim Wechseln zwischen den einzelnen Bildern in Sekunden',
	'srf-paramdesc-navigation-controls' => 'Die Navigationsschaltflächen anzeigen oder nicht',
	'srf-paramdesc-effect' => 'Der Effekt, der beim Wechseln zwischen den einzelnen Bildern angewendet werden soll',
	'srf-printername-filtered' => 'Filterung',
	'srf-paramdesc-filtered-views' => 'Die Ansichten, die für die Ergebnisanzeige verfügbar sein sollen',
	'srf-paramdesc-filtered-filter-position' => 'Die Position der Filter in Bezug auf die Ansichten. Mögliche Werte: „top“, „bottom“. Standardwert: „top“',
	'srf-paramdesc-filtered-list-type' => 'Der Typ der Liste. Mögliche Werte: „list“, „ul“ und „ol“. Standardwert: „list“',
	'srf-paramdesc-filtered-list-template' => 'Die Vorlage, die zur Formatierung der Listeneinträge verwendet werden soll',
	'srf-paramdesc-filtered-list-named-args' => 'Die Namen der Argumente, die an die Vorlage übergeben werden sollen',
	'srf-paramdesc-filtered-list-introtemplate' => 'Der Name der Vorlage, die vor den Abfrageergebnissen angezeigt werden soll, sofern welche vorhanden sind',
	'srf-paramdesc-filtered-list-outrotemplate' => 'Der Name der Vorlage, die nach den Abfrageergebnissen angezeigt werden soll, sofern welche vorhanden sind',
	'srf-paramdesc-filtered-calendar-start' => 'Die Ausgabe, die das Anfangsdatum einer Veranstaltung enthält',
	'srf-paramdesc-filtered-calendar-end' => 'Die Ausgabe, die das Enddatum einer Veranstaltung enthält',
	'srf-paramdesc-filtered-calendar-title' => 'Die Ausgabe, die den Titel einer Veranstaltung enthält. Kann nicht zusammen mit einer Vorlage zur Ausgabe des Titels verwendet werden',
	'srf-paramdesc-filtered-calendar-title-template' => 'Die Vorlage, die den Titel einer Veranstaltung enthält',
	'srf-filtered-selectorlabel-list' => 'Liste',
	'srf-filtered-selectorlabel-calendar' => 'Kalender',
	'srf-printername-d3chart' => 'Diagramm (D3)',
	'srf-printername-timeseries' => 'Diagramm (Zeitreihe)',
	'srf-paramdesc-group' => 'Die Datenreihen sortiert nach',
	'srf-paramdesc-zoom' => 'Den Zoom aktivieren oder nicht',
	'srf-paramdesc-datatable' => 'Eine Datentabelle anzeigen oder nicht',
	'srf-timeseries-zoom-out-of-range' => 'Der Zoombereich enthält nicht genug Daten.',
	'srf-printername-sparkline' => 'Diagramm (Wortgrafik)',
	'srf-printername-listwidget' => 'Widget (Listenwidget)',
	'srf-paramdesc-listtype' => 'Den Listentyp angeben',
	'srf-paramdesc-widget' => 'Das verfügbare Widget',
	'srf-paramdesc-pageitems' => 'Datenelemente pro Seite',
	'srf-printername-eventcalendar' => 'Zeit (Veranstaltungskalender)',
	'srf-paramdesc-calendarfirstday' => 'Der Tag, an dem jede Woche beginnt',
	'srf-paramdesc-calendardefaultview' => 'Die Ausgangsansicht beim Laden des Kalenders',
	'srf-paramdesc-calendarstart' => 'Das Anfangsdatum des Kalenders',
	'srf-paramdesc-dayview' => 'Die Tagesansicht beim Anklicken der Tagesnummer aktivieren oder nicht',
	'srf-ui-eventcalendar-label-today' => 'Heute',
	'srf-ui-eventcalendar-label-month' => 'Monat',
	'srf-ui-eventcalendar-label-week' => 'Woche',
	'srf-ui-eventcalendar-label-day' => 'Tag',
	'srf-ui-eventcalendar-label-allday' => 'Ganzer Tag',
	'srf-printername-dygraphs' => 'Diagramm (Digraph)',
	'srf-paramdesc-datasource' => 'Die Quelle, aus der auf die Daten zugegriffen werden kann (Datei, URL usw.)',
	'srf-paramdesc-errorbar' => 'Der zu verwendete Balken zur Anzeige der Fehler (Standardabweichung (Sigma), darzustellende Brüche oder ein benutzerdefinierter Balken als ein Bereich von Werten (<code>low;middle;high</code>))',
	'srf-paramdesc-movingaverage' => 'Die Anzeige des Durchschnitts zu einem Zeitraum bestimmter Tage (bei Angabe von <code>zero</code> (Null) wird kein gleitender Durchschnitt angezeigt)',
	'srf-paramdesc-yaxislabel' => 'Die Beschreibung, die auf der Y-Achse angezeigt wird',
	'srf-paramdesc-xaxislabel' => 'Die Beschreibung, die auf der X-Achse angezeigt wird',
	'srf-paramdesc-unit' => 'Die Einheit',
	'srf-printername-pagewidget' => 'Widget (Seitenwidget)',
	'srf-printername-incoming' => 'Eingehende Attribute',
	'srf-paramdesc-min' => 'Der maximale Wert oder Schwellenwert',
	'srf-paramdesc-excludeproperty' => 'Das Attribut vom Ergebnis ausschließen',
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author Kghbln
 */
$messages['de-formal'] = array(
	'srf-prefs-intro-text' => 'Sie haben die Programmerweiterung „Semantic Result Formats“ installiert, die derzeit keine anpassbaren Benutzeroptionen ermöglicht. Besuchen Sie bitte die [http://www.semantic-mediawiki.org/wiki/Help:Ergebnisformate Hilfeseite zu Ergebnisformaten], für weitere Informationen.',
	'srf-ui-common-label-ajax-error' => 'Der Server meldete eine fehlgeschlagene Kommunikation für diesen $1. Bitte versuchen Sie, die Seite neu zu laden oder wenden Sie sich an $2.',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 * @author Mirzali
 */
$messages['diq'] = array(
	'srf-module-loading' => 'Bar beno...',
	'srf-paramdesc-height' => 'Berziye',
	'srf-paramdesc-width' => 'Herayiye',
	'srf-navigation-previous' => 'Verên',
	'srf-ui-navigation-prev' => 'Ver',
	'srf-ui-navigation-next' => 'Bahdoyên',
	'srf-ui-common-label-source' => 'Çıme',
	'srf-ui-tooltip-title-options' => 'Weçinıteki',
	'srf-ui-tooltip-title-scope' => 'Şımul',
	'srfc_previousmonth' => 'Aşma verên',
	'srfc_nextmonth' => 'Aşma bahdoyên',
	'srfc_today' => 'Noroc',
	'srfc_gotomonth' => 'Şo aşmêr',
	'srf_printername_calendar' => 'Teqwimê Aşmekan',
	'srf_outline_novalue' => 'Erc çıno',
	'srf_printername_timeline' => 'Wareyê saete',
	'srf-ui-gridview-label-data-tab' => 'Melumat',
	'srf_printername_gallery' => 'Galeri',
	'srf-paramdesc-navigation' => 'Kontrolê cerbiney da pusula',
	'srf-gallery-navigation-previous' => 'Verên',
	'srf-gallery-navigation-next' => 'Bahdoyên',
	'srf_printername_tagcloud' => 'Etiket çıno',
	'srf_printername_array' => 'Nızam',
	'srf_printername_hash' => 'Xeşxaş',
	'srf-printername-graph' => 'Grafik',
	'srf_paramdesc_graphname' => 'Sername',
	'srf_printername_tree' => 'Dar',
	'srf_printername_ultree' => 'Ultree',
	'srf_printername_oltree' => 'Oltree',
	'srf-printername-slideshow' => 'Slaytşow',
	'srf-ui-eventcalendar-label-today' => 'Ewro',
	'srf-ui-eventcalendar-label-month' => 'Aşme',
	'srf-ui-eventcalendar-label-week' => 'Hefte',
	'srf-ui-eventcalendar-label-day' => 'Roce',
	'srf-paramdesc-unit' => 'Unita',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'srf-desc' => 'Pśidatne formaty za rědowe wótpšašanja Semantic MediaWiki',
	'srf-name' => 'Formaty semantiskich wuslědkow',
	'srf-module-loading' => 'Zacytujo se...',
	'srf-paramdesc-layout' => 'K dispoziciji stojecy layout',
	'srf-paramdesc-height' => 'Wusokosć (w pikselach)',
	'srf-paramdesc-width' => 'Šyrokosć',
	'srf-paramdesc-class' => 'Pódaj pśidatnu CSS-klasu',
	'srf-module-nomatch' => 'Žedne wótpowědniki namakane',
	'srf-paramdesc-charttype' => 'K dispoziciji stojecy diagramowy typ',
	'srf-error-option-mix' => 'Opcija ($1) njestoj k dispoziciji',
	'srf-error-option-link-all' => 'Opcija ($1) se pomina,, až parameter staji se "link" na "all"',
	'srf-error-missing-layout' => 'Layout felujo',
	'srf-warn-empy-chart' => 'Diagram/grafika njedajo se napóraś, dokulaž daty feluju',
	'srfc_previousmonth' => 'Slědny mjasec',
	'srfc_nextmonth' => 'Pśiducy mjasec',
	'srfc_today' => 'Źinsa',
	'srfc_gotomonth' => 'Źi k mjasecoju',
	'srf_printername_calendar' => 'Mjasecny kalendaŕ',
	'srf_paramdesc_calendarlang' => 'Kode za toś tu rěc, w kótarejž kalendaŕ ma se zwobrazniś',
	'srf_printername_vcard' => 'vCard eksportěrowaś',
	'srf_printername_icalendar' => 'iCalendar eksportěrowaś',
	'srf_paramdesc_icalendartitle' => 'Titel kalendroweje dataje',
	'srf_paramdesc_icalendardescription' => 'Wopisanje kalendroweje dataje',
	'srf_printername_bibtex' => 'BibTeX eksportěrowaś',
	'srf_outline_novalue' => 'Žedna gódnota',
	'srf_printername_outline' => 'Kontura',
	'srf_paramdesc_outlineproperties' => 'Lisćina atributow, kótarež maju se ako rozrědowańske nadpisma zwobrazniś, pśez komy źělone',
	'srf_printername_sum' => 'Suma licbow',
	'srf_printername_average' => 'Pśerězk licbow',
	'srf_printername_max' => 'Maksimalna licba',
	'srf_printername_min' => 'Minimalna licba',
	'srf_paramdesc_limit' => 'Maksimalna licba bokow za napšašowanje',
	'srf_printername_product' => 'Produkt licbow',
	'srf_printername_median' => 'Pśerězk licbow',
	'srf-paramdesc-default' => 'Standardna gódnota, kótaraž se zwobraznja, jolic numeriske wuslědki njejsu',
	'srf_printername_earliest' => 'Nejrańšy cas',
	'srf_printername_latest' => 'Njepóznjejšy cas',
	'srf_printername_timeline' => 'Casowy wótběg',
	'srf_printername_eventline' => 'Wótběg tšojenjow',
	'srf_paramdesc_timelinebands' => 'Definěruje, kótare smugi zwobraznjuju se we wuslědku.',
	'srf_paramdesc_timelineposition' => 'Definěruje, źož casowa linija ma fokus na zachopjeńku.',
	'srf_paramdesc_timelinestart' => 'Mě atributa, kótarež ma se wužywaś, aby definěrowało prědny casowy dypk',
	'srf_paramdesc_timelineend' => 'Mě atributa, kótarež ma se wužywaś, aby definěrowało drugi casowy dypk',
	'srf_paramdesc_timelinesize' => 'Wusokosć casoweje linije',
	'srf-timeline-allresults' => 'Dalšne wuslědki za toś to napšašowanje.',
	'srf_paramdesc_views' => 'Naglědy, kótarež maju se zwobrazniś',
	'srf_paramdesc_facets' => 'Sajźba atributow, kótarež maju se zwobrazniś za kuždy bok',
	'srf_paramdesc_lens' => 'Mě pśedłogi, z kótarejuž maju se bokowe atributy zwobrazniś',
	'srf_printername_googlebar' => 'Google słupowy diagram',
	'srf_printername_googlepie' => 'Google tortowy diagram',
	'srf_paramdesc_chartheight' => 'Pódaj wusokosć diagrama/grafiki (w pikselach)',
	'srf_paramdesc_chartwidth' => 'Pódaj šyrokosć diagrama/grafiki (w pikselach abo procentach)',
	'srf_paramdesc_charttitle' => 'Titel diagrama',
	'srf_paramdesc_barcolor' => 'Barwa słupow',
	'srf_paramdesc_bardirection' => 'Směr słupowego diagrama pódaś',
	'srf_paramdesc_barnumbersaxislabel' => 'Pópisanje za y-wósku',
	'srf-paramdesc-minvalue' => 'Minimalna gódnota, kótaraž ma se na Y-wósce pokazaś',
	'srf-paramdesc-chartlegend' => 'Pozicija diagramoweje legendy',
	'srf-paramdesc-charttext' => 'Wugroniwy diagramowy tekst',
	'srf-paramdesc-chartclass' => 'Pśidatna CSS-klasa',
	'srf-paramdesc-theme' => 'Drastwu za raster wubraś',
	'srf-paramdesc-chartcolor' => 'Jadnotliwe diagramowe barwy pśipokazaś',
	'srf-paramdesc-colorscheme' => 'Barwowu šemu wubraś',
	'srf-paramdesc-valueformat' => 'Formatěrowańske pšawidło za gódnoty pódaś',
	'srf-paramdesc-infotext' => 'Pśidatne informacije na wótpowědujucem rejtarku Info zwobrazniś',
	'srf-ui-gridview-label-item' => 'Datowy element',
	'srf-ui-gridview-label-value' => 'Datowa gódnota',
	'srf-ui-gridview-label-series' => 'Datowe rědy',
	'srf-ui-gridview-label-chart-tab' => 'Diagram',
	'srf-ui-gridview-label-data-tab' => 'Daty',
	'srf-ui-gridview-label-info-tab' => 'Info',
	'srf_printername_gallery' => 'Galerija',
	'srf_paramdesc_perrow' => 'Licba wobrazow na smužku',
	'srf_paramdesc_widths' => 'Šyrokosć wobrazow',
	'srf_paramdesc_heights' => 'Wusokosć wobrazow',
	'srf_paramdesc_autocaptions' => 'Datajowe mě ako wopisanje wužywaś, jolic žadno njeje pódane',
	'srf-gallery-navigation-previous' => 'Slědk',
	'srf-gallery-navigation-next' => 'Dalej',
	'srf-gallery-overlay-count' => 'Wobraz $1 z $2',
	'srf-gallery-image-url-error' => 'Wobraz njejo se namakał.',
	'srf_printername_tagcloud' => 'Tafličkowa mróčel',
	'srf_paramdesc_includesubject' => 'Lěc mjenja temow same maju se zapśimjeś',
	'srf_paramdesc_increase' => 'Kak ma se wjelikosć wobznamjenjow pówušyś',
	'srf_paramdesc_tagorder' => 'Pórěd wobznamjenjow',
	'srf_paramdesc_maxtags' => 'maksimalna licba wobznamjenjow w mrokawje',
	'srf_printername_valuerank' => 'Gódnota',
	'srf_printername_array' => 'Šypka',
	'srf_printername_hash' => 'Asociatiwne datowe pólo (hash)',
	'srf-printername-graph' => 'Grafika',
	'srf-paramdesc-graph-nodeshape' => 'Forma kuždego suka na grafice',
	'srf_paramdesc_graphname' => 'Titel',
	'srf_paramdesc_graphsize' => 'Wjelikosć grafiki (w pikselach)',
	'srf_paramdesc_graphlegend' => 'Legendu grafiki pokazaś abo nic',
	'srf_paramdesc_graphlabel' => 'Pópisanje grafiki',
	'srf_paramdesc_rankdir' => 'Směr šypki',
	'srf_paramdesc_graphlink' => 'Wotkaz grafiki',
	'srf_paramdesc_graphcolor' => 'Barwa grafiki',
	'srf_printername_datatables' => 'DataTables',
	'srf-paramdesc-rowindex' => 'Smužkowy indeks tabele',
	'srf-paramdesc-displaylength' => 'Zachopna zwobraznjeńska dłujkosć',
	'srf_printername_tree' => 'Bom',
	'srf_printername_ultree' => 'Bomowy naglěd (nalicenje)',
	'srf_printername_oltree' => 'Bomowy naglěd (numerěrowany)',
	'srf-paramdesc-parent' => 'Kakosć, kótaraž wopśimujo nadrědowany bok',
	'srf-printername-slideshow' => 'Wobrazowe pśedstajenje',
	'srf-paramdesc-delay' => 'Wokomuźenje mjazy wobrazami w sekudnach',
	'srf-printername-filtered' => 'Filtrowany',
	'srf-printername-d3chart' => 'D3-diagram',
	'srf-printername-timeseries' => 'Diagram casowych rědow',
	'srf-paramdesc-group' => 'Rědy zrědowane pó',
	'srf-paramdesc-zoom' => 'Skalěrowanje zmóžniś',
	'srf-paramdesc-datatable' => 'Datowu tabelu zmóžniś',
	'srf-printername-sparkline' => 'Diagram słownych grafikow',
	'srf-printername-listwidget' => 'Lisćinowy asistent',
	'srf-paramdesc-listtype' => 'Pódaj lisćinowy typ',
	'srf-paramdesc-widget' => 'K dispoziciji stojecy asistent',
	'srf-paramdesc-pageitems' => 'Elementy na bok',
	'srf-printername-eventcalendar' => 'Kalendaŕ zarědowanjow',
	'srf-paramdesc-calendarfirstday' => 'Źeń, gaž kuždy tyźeń se zachopina',
	'srf-paramdesc-calendardefaultview' => 'Zachopna gódnota, gaž kalendaŕ se zacytujo',
	'srf-paramdesc-datasource' => 'Pódaj žrědło, z kótaregož maju pśistup na daty (dataja, URL atd.)',
	'srf-paramdesc-yaxislabel' => 'Wopisanje, kótarež pokazujo se na y-wósce',
	'srf-paramdesc-xaxislabel' => 'Wopisanje, kótarež pokazujo se na x-wósce',
	'srf-paramdesc-unit' => 'Jadnotka',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Omnipaedista
 * @author ZaDiak
 */
$messages['el'] = array(
	'srf-desc' => 'Πρόσθετα φορμά για τα inline αιτήματα της Σημασιολογικής MediaWiki',
	'srf-name' => 'Σημασιολογικά Αποτελέσματα Φορμά',
	'srfc_previousmonth' => 'Προηγούμενος μήνας',
	'srfc_nextmonth' => 'Επόμενος μήνας',
	'srfc_today' => 'Σήμερα',
	'srfc_gotomonth' => 'Μετάβαση στον μήνα',
	'srf_printername_calendar' => 'Μηνιαίο ημερολόγιο',
	'srf_printername_vcard' => 'Εξαγωγή vCard',
	'srf_printername_icalendar' => 'Εξαγωγή iCalendar',
	'srf_printername_bibtex' => 'Εξαγωγή BibTeX',
	'srf_outline_novalue' => 'Καμία τιμή',
	'srf_printername_outline' => 'Περίγραμμα',
	'srf_printername_sum' => 'Σύνοψη αριθμών',
	'srf_printername_average' => 'Μέσος όρος αριθμών',
	'srf_printername_max' => 'Μέγιστος αριθμός',
	'srf_printername_min' => 'Ελάχιστος αριθμός',
	'srf_printername_timeline' => 'Ζώνη ώρας',
	'srf_printername_eventline' => 'Ζώνη γεγονότων',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'srfc_previousmonth' => 'Antaŭa monato',
	'srfc_nextmonth' => 'Posta monato',
	'srfc_today' => 'Hodiaŭ',
	'srfc_gotomonth' => 'Iru al monato',
	'srf_printername_calendar' => 'Monata kalendaro',
	'srf_icalendar_link' => 'iKalendaro',
	'srf_outline_novalue' => 'Sen valoro',
	'srf_printername_sum' => 'Sumo de nombroj',
	'srf_printername_average' => 'Averaĝo de nombroj',
	'srf_printername_max' => 'Maksimuma nombro',
	'srf_printername_min' => 'Minimuma nombro',
	'srf_printername_timeline' => 'Templinio',
	'srf_printername_eventline' => 'Eventlinio',
	'srf_printername_gallery' => 'Galerio',
);

/** Spanish (español)
 * @author Antur
 * @author Armando-Martin
 * @author Badon
 * @author Crazymadlover
 * @author Imre
 * @author Jewbask
 * @author Maor X
 * @author McDutchie
 * @author Ralgis
 * @author Sanbec
 * @author Translationista
 * @author VegaDark
 */
$messages['es'] = array(
	'srf-desc' => 'Formatos adicionales para consultas en línea de Semantic MediaWiki',
	'srf-name' => 'Formatos de resultado semántico',
	'prefs-srf' => 'Formatos de resultados semánticos',
	'srf-prefs-intro-text' => 'Tienes instalada la extensión para dar formato a los resultados semánticos pero en este momento no tienes opciones personalizables de usuario. Para obtener ayuda, visita la página de ayuda sobre los [http://www.semantic-mediawiki.org/wiki/Help:Result_formats formatos de los resultados].',
	'srf-module-loading' => 'Cargando...',
	'srf-paramdesc-layout' => 'Diseño disponible',
	'srf-paramdesc-height' => 'Altura (en píxeles)',
	'srf-paramdesc-width' => 'Anchura',
	'srf-paramdesc-class' => 'Especificar una clase adicional de hoja de estilos en cascada (CSS)',
	'srf-module-nomatch' => 'No se encontraron coincidencias',
	'srf-paramdesc-charttype' => 'Tipo de gráfico disponible',
	'srf-navigation-previous' => 'Anterior',
	'srf-ui-navigation-prev' => 'Anterior',
	'srf-ui-navigation-next' => 'Siguiente',
	'srf-ui-common-label-source' => 'Fuente',
	'srf-ui-common-label-datasource' => 'Fuente de datos',
	'srf-ui-common-label-ajax-error' => 'El servidor informó sobre una comunicación fallida del elemento $1. Intenta actualizar la página o consultar con $2.',
	'srf-ui-common-label-request-object' => 'objeto de la solicitud',
	'srf-ui-common-label-help-section' => 'sección de ayuda',
	'srf-ui-tooltip-title-options' => 'Opciones',
	'srf-ui-tooltip-title-scope' => 'Ámbito de aplicación',
	'srf-error-option-mix' => 'La opción ($1) no está disponible',
	'srf-error-option-link-all' => 'La opción ($1) necesita que el parámetro "link" esté definido como "all"',
	'srf-error-missing-layout' => 'Falta el diseño',
	'srf-warn-empy-chart' => 'La tabla/gráfica está vacía porque faltan datos',
	'srfc_previousmonth' => 'Mes anterior',
	'srfc_nextmonth' => 'Próximo mes',
	'srfc_today' => 'Hoy',
	'srfc_gotomonth' => 'Ir al mes',
	'srf_printername_calendar' => 'Calendario mensual',
	'srf_paramdesc_calendarlang' => 'El código del idioma en el que se muestra el calendario',
	'srf_paramdesc_calendarcolors' => 'El color a mostrar para cada propiedad de datos (ejemplo: "Fecha de inicio=>green, Fecha de fin=>#09c")',
	'srf_printername_vcard' => 'Exportar vCard',
	'srf_printername_icalendar' => 'Exportar iCalendar',
	'srf_paramdesc_icalendartitle' => 'El título del archivo de calendario',
	'srf_paramdesc_icalendardescription' => 'El descripción del archivo de calendario',
	'srf_printername_bibtex' => 'Exportar BibTeX',
	'srf_outline_novalue' => 'Sin valor',
	'srf_printername_outline' => 'Esquema',
	'srf_paramdesc_outlineproperties' => 'La lista de propiedades que se mostrará como encabezados de esquema, separadas por comas',
	'srf_printername_sum' => 'Suma de números',
	'srf_printername_average' => 'Promedio de números',
	'srf_printername_max' => 'Número máximo',
	'srf_printername_min' => 'Número mínimo',
	'srf_paramdesc_limit' => 'La cantidad máxima de páginas a consultar',
	'srf_printername_product' => 'Producto de números',
	'srf_printername_median' => 'Mediana de los números',
	'srf-paramdesc-default' => 'Valor por defecto que se mostrará cuando no haya resultados numéricos',
	'srf_printername_earliest' => 'Primera hora',
	'srf_printername_latest' => 'Última hora',
	'srf_printername_timeline' => 'Línea de tiempo',
	'srf_printername_eventline' => 'Línea de eventos',
	'srf_paramdesc_timelinebands' => 'PDF',
	'srf_paramdesc_timelineposition' => 'Define donde se fijará inicialmente la línea del tiempo.',
	'srf_paramdesc_timelinestart' => 'Un nombre de propiedad utilizado para definir un primer punto temporal',
	'srf_paramdesc_timelineend' => 'Un nombre de propiedad utilizado para definir un segundo punto temporal',
	'srf_paramdesc_timelinesize' => 'La altura de la línea de tiempo',
	'srf-timeline-allresults' => 'Resultados adicionales para esta consulta.',
	'srf-timeline-nojs' => 'Debe tener habilitado JavaScript para ver la línea de tiempo interactiva.',
	'srf_paramdesc_views' => 'Las vistas a mostrar',
	'srf_paramdesc_facets' => 'El grupo de propiedades a mostrar para cada página',
	'srf_paramdesc_lens' => 'El nombre de una plantilla con la que se muestra la propiedades de la página',
	'srf_printername_googlebar' => 'Gráfico de barras de Google',
	'srf_printername_googlepie' => 'Gráfica circular de Google',
	'srf-printername-jqplotchart' => 'Gráfica jqPlot',
	'srf-printername-jqplotseries' => 'Serie jqPlot',
	'srf_paramdesc_chartheight' => 'Especifica la altura (en píxeles) de una tabla o una gráfica',
	'srf_paramdesc_chartwidth' => 'Especificar la anchura (en píxeles o porcentaje) de la tabla o gráfica',
	'srf_paramdesc_charttitle' => 'El título del gráfico',
	'srf_paramdesc_barcolor' => 'El color de las barras',
	'srf_paramdesc_bardirection' => 'Especifique la dirección de un gráfico',
	'srf-paramdesc-direction' => 'Especificar la dirección de una tabla o una gráfica',
	'srf_paramdesc_barnumbersaxislabel' => 'La etiqueta del eje de los números',
	'srf-paramdesc-labelaxislabel' => 'La etiqueta para el eje de la etiqueta',
	'srf-paramdesc-ticklabels' => 'Activar la visualización de etiquetas de marca',
	'srf-paramdesc-minvalue' => 'El valor mínimo a mostrar en el eje de ordenadas',
	'srf-paramdesc-pointlabels' => 'Visualización de datos puntuales en la gráfica',
	'srf-paramdesc-chartlegend' => 'Posición de la leyenda de la gráfica',
	'srf-paramdesc-datalabels' => 'Rótulos de datos de la tabla/gráfica',
	'srf-paramdesc-charttext' => 'Texto descriptivo del gráfico',
	'srf-paramdesc-chartclass' => 'Clase CSS adicional',
	'srf-paramdesc-renderer' => 'Seleccione un representador tablas/gráficas',
	'srf-paramdesc-filling' => 'Opción de rellenado individual',
	'srf-paramdesc-theme' => 'Seleccione un tema de cuadrícula',
	'srf-paramdesc-chartcolor' => 'Asignar colores individuales al gráfico',
	'srf-paramdesc-colorscheme' => 'Seleccione una combinación de colores',
	'srf-paramdesc-valueformat' => 'Especifica una regla de formato para valores',
	'srf-paramdesc-highlighter' => 'Mostrar un marcador de punto de datos',
	'srf-paramdesc-smoothlines' => 'Aplicar un algoritmo de suavizado en los gráficos de líneas',
	'srf-paramdesc-stackseries' => 'Mostrar gráfico en forma de serie apilada',
	'srf-paramdesc-seriesgroup' => 'Seleccionar agrupamientos de series',
	'srf-paramdesc-serieslabel' => 'Determinar la etiqueta de serie',
	'srf-paramdesc-grouplabel' => 'Determinar la etiqueta de grupo',
	'srf-paramdesc-chartcursor' => 'Opción de visualización del cursor de tabla',
	'srf-paramdesc-trendline' => 'Activar la visualización simultánea de un gráfico y su línea de tendencia',
	'srf-paramdesc-gridview' => 'Mostrar simultáneamente gráfico y conjunto de datos',
	'srf-paramdesc-infotext' => 'Mostrar información adicional en una ficha de información correspondiente',
	'srf-ui-gridview-label-item' => 'Elemento de datos',
	'srf-ui-gridview-label-value' => 'Valor de los datos',
	'srf-ui-gridview-label-series' => 'Serie de datos',
	'srf-ui-gridview-label-chart-tab' => 'Gráfico',
	'srf-ui-gridview-label-data-tab' => 'Datos',
	'srf-ui-gridview-label-info-tab' => 'Información',
	'srf_printername_gallery' => 'Galería',
	'srf_paramdesc_perrow' => 'La cantidad de imágenes por línea',
	'srf_paramdesc_widths' => 'La anchura de las imágenes',
	'srf_paramdesc_heights' => 'La altura de las imágenes',
	'srf_paramdesc_autocaptions' => 'Usar el nombre del archivo como pie de imagen cuando no se indique ninguna otra',
	'srf_paramdesc_fileextensions' => 'Cuando se use el nombre del archivo como pie de imagen, mostrar también la extensión del archivo',
	'srf_paramdesc_captionproperty' => 'El nombre de una propiedad semántica presente en las páginas consultadas a usar como pie de imagen',
	'srf_paramdesc_imageproperty' => 'Nombre de una propiedad semántica en las páginas consultadas que apunta a las imágenes a usar. Cuando esté definido, las propias páginas consultadas no se mostrarán como imágenes',
	'srf-paramdesc-redirects' => 'El nombre de una propiedad semántica presente en las páginas consultadas que contienen el destino de la redirección',
	'srf-paramdesc-navigation' => 'Diseñar control de navegación',
	'srf-paramdesc-overlay' => 'Activar la superposición de imagenes',
	'srf-gallery-navigation-previous' => 'Anterior',
	'srf-gallery-navigation-next' => 'Siguiente',
	'srf-gallery-overlay-count' => 'Imagen  $1  de$2',
	'srf-gallery-image-url-error' => 'No se encontró la imagen.',
	'srf_printername_tagcloud' => 'Nube de etiquetas',
	'srf_paramdesc_includesubject' => 'Si los propios nombres de los temas deben incluirse',
	'srf_paramdesc_increase' => 'Como aumentar el tamaño de las etiquetas',
	'srf_paramdesc_tagorder' => 'El orden de las etiquetas',
	'srf_paramdesc_mincount' => 'La cantidad mínima de veces que un valor tiene que presentarse para estar en la lista',
	'srf_paramdesc_minsize' => 'El tamaño de las etiquetas más pequeñas, en porcentaje',
	'srf_paramdesc_maxsize' => 'El tamaño de las etiquetas más grandes en porcentaje',
	'srf_paramdesc_maxtags' => 'La cantidad máxima de etiquetas en la nube',
	'srf-paramdesc-excludetags' => 'Excluir etiquetas (delimitador: ;)',
	'srf_printername_valuerank' => 'Valor del rango',
	'srf_printername_array' => 'Tabla',
	'srf_paramdesc_pagetitle' => 'Mostrar los títulos de las páginas como entradas de resultados, o bien omitirlos',
	'srf_paramdesc_hidegaps' => 'Imprimir los valores de las propiedades y de los registros solicitados y no disponibles, separados por separadores,obien omitirlos',
	'srf_paramdesc_arrayname' => 'Si se da un ArrayExtension y está disponible, esto creará una tabla con el nombre indicado (sin salida visible, en ese caso)',
	'srf_paramdesc_propsep' => 'Separador entre las propiedades solicitadas',
	'srf_paramdesc_manysep' => 'Separador entre los valores de las propiedades con muchos valores',
	'srf_paramdesc_recordsep' => 'Separador entre los valores de las propiedades de registro',
	'srf_paramdesc_headersep' => 'Separador entre el nombre y el valor de la propiedad si "headers" está definido como "show" o "plain"',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'Si se da una extensión HashTables y está disponible, esto creará un "hash" con el nombre indicado (sin salida visible, en ese caso)',
	'srf-printername-graph' => 'Gráfico',
	'srf-paramdesc-graph-relation' => 'Los asuntos o las propiedades de los nombres ¿son padres o hijos?',
	'srf-paramdesc-graph-nameprop' => 'Permite definir una propiedad que se usará como asunto en vez del asunto real',
	'srf-paramdesc-graph-nodeshape' => 'La forma de cada nodo en la gráfica',
	'srf_paramdesc_graphname' => 'Título',
	'srf_paramdesc_graphsize' => 'Tamaño de la gráfica (en px)',
	'srf_paramdesc_graphlegend' => 'Mostrar o no la leyenda de la gráfica',
	'srf_paramdesc_graphlabel' => 'Etiqueta de la gráfica',
	'srf_paramdesc_rankdir' => 'Dirección de la flecha',
	'srf_paramdesc_graphlink' => 'Enlace de la gráfica',
	'srf_paramdesc_graphcolor' => 'Color de la gráfica',
	'srf-paramdesc-graph-wwl' => 'Ajuste automático de línea (en número de caracteres)',
	'srf_printername_datatables' => 'Tablas de datos',
	'srf-paramdesc-rowindex' => 'Índice de la fila de la tabla',
	'srf-paramdesc-displaylength' => 'Longitud de presentación inicial',
	'srf_printername_tree' => 'Árbol',
	'srf_printername_ultree' => 'Árbol UL',
	'srf_printername_oltree' => 'Árbol OL',
	'srf-noparentprop' => 'No se ha especificado ninguna propiedad padre. No se puede construir el árbol sin especificar una propiedad padre.',
	'srf-paramdesc-parent' => 'La propiedad que contiene la página padre',
	'srf-printername-slideshow' => 'Presentación de diapositivas',
	'srf-paramdesc-delay' => 'Tiempo entre diapositivas, en segundos',
	'srf-paramdesc-navigation-controls' => 'Mostrar controles de navegación o no mostrarlos',
	'srf-paramdesc-effect' => 'El efecto que se utilizará para cambiar de una diapositiva a la siguiente',
	'srf-printername-filtered' => 'Filtrado',
	'srf-paramdesc-filtered-views' => 'Las vistas que estarán disponibles en la pantalla de resultados.',
	'srf-paramdesc-filtered-filter-position' => 'La posición de los filtros en relación con las vistas. Valores permitidos: top, bottom. Predeterminado: top.',
	'srf-paramdesc-filtered-list-type' => 'El tipo de la lista. Valores permitidos: list, ul, ol. Predeterminado: list.',
	'srf-paramdesc-filtered-list-template' => 'La plantilla que se utiliza para dar formato a las entradas de la lista.',
	'srf-paramdesc-filtered-list-named-args' => 'Nombra los argumentos que se le pasan a la plantilla',
	'srf-paramdesc-filtered-list-introtemplate' => 'El nombre de una plantilla que se mostrará antes de los resultados de la consulta, si hay alguna.',
	'srf-paramdesc-filtered-list-outrotemplate' => 'El nombre de una plantilla que se mostrará después de los resultados de la consulta, si hay alguna.',
	'srf-paramdesc-filtered-calendar-start' => 'La impresión que contiene la fecha de inicio de un evento',
	'srf-paramdesc-filtered-calendar-end' => 'La impresión que contiene la fecha final de un evento',
	'srf-paramdesc-filtered-calendar-title' => 'La impresión que contiene el título de un evento. No puede utilizarse junto con una plantilla de título.',
	'srf-paramdesc-filtered-calendar-title-template' => 'Una plantilla que se utiliza para dar formato al título de un evento en el calendario',
	'srf-filtered-selectorlabel-list' => 'Lista',
	'srf-filtered-selectorlabel-calendar' => 'Calendario',
	'srf-printername-d3chart' => 'Gráfico D3',
	'srf-printername-timeseries' => 'Gráfico de series temporales',
	'srf-paramdesc-group' => 'Serie agrupada por',
	'srf-paramdesc-zoom' => 'Activar el zoom',
	'srf-paramdesc-datatable' => 'Activar una tabla de datos',
	'srf-timeseries-zoom-out-of-range' => 'El alcance del zoom no produjo datos suficientes',
	'srf-printername-sparkline' => 'Gráfico Sparkline',
	'srf-printername-listwidget' => 'Listwidget',
	'srf-paramdesc-listtype' => 'Especificar el tipo de lista',
	'srf-paramdesc-widget' => 'Widget disponible',
	'srf-paramdesc-pageitems' => 'Elementos por página',
	'srf-printername-eventcalendar' => 'Calendario de eventos',
	'srf-paramdesc-calendarfirstday' => 'El día en que comienza cada semana',
	'srf-paramdesc-calendardefaultview' => 'Vista inicial cuando se carga el calendario',
	'srf-paramdesc-calendarstart' => 'El comienzo del calendario inicial',
	'srf-paramdesc-dayview' => 'Habilitar la vista de día haciendo clic en el número del día',
	'srf-ui-eventcalendar-label-today' => 'Hoy',
	'srf-ui-eventcalendar-label-month' => 'Mes',
	'srf-ui-eventcalendar-label-week' => 'Semana',
	'srf-ui-eventcalendar-label-day' => 'Día',
	'srf-ui-eventcalendar-label-allday' => 'Todo el día',
	'srf-printername-dygraphs' => 'Gráfico Dygraphs',
	'srf-paramdesc-datasource' => 'Especificar la fuente en la que están accesibles los datos (archivo, dirección URL, etc.)',
	'srf-paramdesc-errorbar' => 'Especifique la barra de error utilizada (desviación estándar (sigma), fracciones de intervalo de confianza, o barras personalizadas como un rango de los valores bajo; medio; alto)',
	'srf-paramdesc-movingaverage' => 'Mostrar el valor promedio en un número de días (cero indicará que no hay media móvil)',
	'srf-paramdesc-yaxislabel' => 'Descripción que aparece en el eje y',
	'srf-paramdesc-xaxislabel' => 'Descripción que aparece en el eje x',
	'srf-paramdesc-unit' => 'Unidad',
	'srf-printername-pagewidget' => 'Pagewidget',
	'srf-printername-incoming' => 'Propiedades entrantes',
	'srf-paramdesc-min' => 'Valor mínimo o umbral',
	'srf-paramdesc-excludeproperty' => 'Excluir la propiedad del conjunto de resultados',
);

/** Estonian (eesti)
 * @author Avjoska
 */
$messages['et'] = array(
	'srfc_previousmonth' => 'Eelmine kuu',
	'srfc_nextmonth' => 'Järgmine kuu',
	'srfc_today' => 'Täna',
	'srfc_gotomonth' => 'Mine kalendrikuuni',
	'srf_printername_gallery' => 'Galerii',
	'srf-gallery-navigation-previous' => 'Eelmine',
	'srf-gallery-navigation-next' => 'Järgmine',
);

/** Basque (euskara)
 * @author An13sa
 */
$messages['eu'] = array(
	'srfc_previousmonth' => 'Aurreko hilabetea',
	'srfc_nextmonth' => 'Hurrengo hilabetea',
	'srfc_today' => 'Gaur',
	'srfc_gotomonth' => 'Hilabetera joan',
	'srf_printername_timeline' => 'Denbora-lerroa',
	'srf_printername_eventline' => 'Gertakari-lerroa',
);

/** Persian (فارسی)
 * @author Mjbmr
 * @author Tofighi
 */
$messages['fa'] = array(
	'srfc_previousmonth' => 'ماه گذشته',
	'srfc_nextmonth' => 'ماه آینده',
	'srfc_today' => 'امروز',
	'srfc_gotomonth' => 'برو به ماه',
	'srf_outline_novalue' => 'بدون مقدار',
	'srf-gallery-navigation-previous' => 'قبلی',
	'srf-gallery-navigation-next' => 'بعدی',
);

/** Finnish (suomi)
 * @author Nedergard
 * @author Nike
 * @author Silvonen
 * @author Str4nd
 */
$messages['fi'] = array(
	'srf-desc' => 'Muita muotoja Semantic MediaWikin upotetuille kyselyille',
	'srf-name' => 'Semanttisten tulosten muodot',
	'prefs-srf' => 'Semanttisten tulosten muodot',
	'srf-module-loading' => 'Ladataan...',
	'srf-paramdesc-layout' => 'Asetteluvaihtoehdot',
	'srf-paramdesc-height' => 'Korkeus',
	'srf-paramdesc-width' => 'Leveys',
	'srf-module-nomatch' => 'Ei hakutuloksia',
	'srf-paramdesc-charttype' => 'Mahdolliset kaaviotyypit',
	'srf-navigation-previous' => 'Edellinen',
	'srf-ui-navigation-prev' => 'Edellinen',
	'srf-ui-navigation-next' => 'Seuraava',
	'srf-ui-common-label-source' => 'Lähde',
	'srf-ui-common-label-datasource' => 'Tietolähde',
	'srf-ui-common-label-help-section' => 'ohje-osio',
	'srf-ui-tooltip-title-options' => 'Asetukset',
	'srf-error-missing-layout' => 'Asettelu puuttuu',
	'srf-warn-empy-chart' => 'Kaavio tai graafi on tyhjä, koska tietoja ei ole',
	'srfc_previousmonth' => 'Edellinen kuukausi',
	'srfc_nextmonth' => 'Seuraava kuukausi',
	'srfc_today' => 'Tänään',
	'srfc_gotomonth' => 'Siirry kuukauteen',
	'srf_printername_calendar' => 'Kuukausittainen kalenteri',
	'srf_paramdesc_calendarlang' => 'Kalenterin kielen tunnus',
	'srf_printername_vcard' => 'vCard-vienti',
	'srf_printername_icalendar' => 'iCalendar-vienti',
	'srf_paramdesc_icalendartitle' => 'Kalenteritiedoston otsikko',
	'srf_paramdesc_icalendardescription' => 'Kalenteritiedoston kuvaus',
	'srf_printername_bibtex' => 'BibTeX-vienti',
	'srf_outline_novalue' => 'Ei arvoa',
	'srf_printername_outline' => 'Jäsennys',
	'srf_printername_sum' => 'Lukujen summa',
	'srf_printername_average' => 'Lukujen keskiarvo',
	'srf_printername_max' => 'Korkein luku',
	'srf_printername_min' => 'Pienin luku',
	'srf_paramdesc_limit' => 'Kyselyn sivujen enimmäismäärä',
	'srf_printername_median' => 'Lukujen mediaani',
	'srf-paramdesc-default' => 'Oletusarvo, joka näytetään, kun numeerista tulosta ei saada',
	'srf_printername_timeline' => 'Aikajana',
	'srf_printername_eventline' => 'Tapahtumajana',
	'srf_paramdesc_timelineposition' => 'Määrittää, mikä on aikajanan ensimmäinen näytettävä kohta.',
	'srf_paramdesc_timelinestart' => 'Ominaisuuden nimi, joka määrittää ensimmäisen ajankohdan',
	'srf_paramdesc_timelineend' => 'Ominaisuuden nimi, joka määrittää toisen ajankohdan',
	'srf_paramdesc_timelinesize' => 'Aikajanan korkeus',
	'srf-timeline-allresults' => 'Lisää tuloksia tälle kyselylle.',
	'srf-timeline-nojs' => 'Interaktiivinen aikajana edellyttää JavaScriptin käyttöä.',
	'srf_paramdesc_views' => 'Näytettävät näkymät',
	'srf_paramdesc_facets' => 'Ominaisuusjoukko, joka näytetään jokaisella sivulla',
	'srf_printername_googlebar' => 'Googlen pylväskuvaaja',
	'srf_printername_googlepie' => 'Googlen piirakkakuvaaja',
	'srf-printername-jqplotchart' => 'jqPlot-kaavio',
	'srf-printername-jqplotseries' => 'jqPlot-sarja',
	'srf_paramdesc_chartheight' => 'Määritä kaavion tai graafin korkeus (pikseleinä)',
	'srf_paramdesc_chartwidth' => 'Määritä kaavion tai graafin leveys (pikseleinä)',
	'srf_paramdesc_charttitle' => 'Kaavion otsikko',
	'srf_paramdesc_barcolor' => 'Määritä kaavion värit',
	'srf_paramdesc_bardirection' => 'Määritä kaavion suunta',
	'srf-paramdesc-direction' => 'Määritä kaavion tai graafin suunta',
	'srf-paramdesc-valueformat' => 'Määritä arvojen muotoilusäännöt',
	'srf-paramdesc-stackseries' => 'Näytä kaavio pinottuna sarjana',
	'srf-paramdesc-seriesgroup' => 'Valitse sarjan ryhmittely',
	'srf-paramdesc-gridview' => 'Näytän kaavio ja datajoukot samanaikaisesti',
	'srf-ui-gridview-label-value' => 'Data-arvo',
	'srf-ui-gridview-label-series' => 'Datasarja',
	'srf-ui-gridview-label-chart-tab' => 'Kaavio',
	'srf-ui-gridview-label-data-tab' => 'Data',
	'srf-ui-gridview-label-info-tab' => 'Tiedot',
	'srf_printername_gallery' => 'Galleria',
	'srf_paramdesc_perrow' => 'Kuvien määrä rivillä',
	'srf_paramdesc_widths' => 'Kuvien leveys',
	'srf_paramdesc_heights' => 'Kuvien korkeus',
	'srf_paramdesc_autocaptions' => 'Käytä tiedoston nimeä otsikkoa, jos otsikkoa ei ole määritetty',
	'srf_paramdesc_fileextensions' => 'Jos tiedostonimi on otsikkona, näytä myös tiedostopääte',
	'srf-gallery-navigation-previous' => 'Edellinen',
	'srf-gallery-navigation-next' => 'Seuraava',
	'srf-gallery-overlay-count' => 'Kuva $1 / $2',
	'srf-gallery-image-url-error' => 'Kuvaa ei löytynyt.',
	'srf_printername_tagcloud' => 'Tunnistepilvi',
	'srf_paramdesc_increase' => 'Kuinka tunnisteiden kokoa suurennetaan',
	'srf_paramdesc_tagorder' => 'Tunnisteiden järjestys',
	'srf_paramdesc_minsize' => 'Pienimmän tunnisteen koko prosentteina',
	'srf_paramdesc_maxsize' => 'Suurimman tunnisteen koko prosentteina',
	'srf_paramdesc_maxtags' => 'Tunnisteiden enimmäismäärä pilvessä',
	'srf_paramdesc_propsep' => 'Erotin pyydettyjen ominaisuuksien välissä',
	'srf_paramdesc_manysep' => 'Erotin moniarvoisen ominaisuuden arvojen välillä',
	'srf_paramdesc_headersep' => 'Erotin ominaisuuden nimen ja arvon välissä, jos "headers" on "show" tai "plain"',
	'srf-printername-graph' => 'Graafi',
	'srf-paramdesc-graph-relation' => 'Ovatko kohteet tai nimiominaisuudet ylätasolla vai alatasolla?',
	'srf_paramdesc_graphname' => 'Otsikko',
	'srf_paramdesc_graphsize' => 'Graafin koko (pikseleinä)',
	'srf_paramdesc_rankdir' => 'Nuolen suunta',
	'srf_paramdesc_graphlink' => 'Graafin linkki',
	'srf_paramdesc_graphcolor' => 'Graafin väri',
	'srf_printername_datatables' => 'Datataulukot',
	'srf_printername_tree' => 'Puu',
	'srf_printername_ultree' => 'Puu (luettelo)',
	'srf_printername_oltree' => 'Puu (numeroitu)',
	'srf-noparentprop' => 'Ylätason ominaisuus puuttuu. Puuta ei voi rakentaa, jos ylätason ominaisuutta ei ole määritetty.',
	'srf-paramdesc-navigation-controls' => 'Näytä navigointiohjaimet tai ei',
	'srf-printername-filtered' => 'Suodatettu',
	'srf-paramdesc-filtered-list-type' => 'Luettelotyypit. Sallitut arvot: list, ul, ol. Oletusarvo: list.',
	'srf-paramdesc-filtered-list-template' => 'Malline, jolla luettelokohdat muotoillaan.',
	'srf-paramdesc-filtered-list-introtemplate' => 'Ennen kyselytuloksia näytettävä mallineen nimi, jos sellaista on.',
	'srf-paramdesc-filtered-list-outrotemplate' => 'Kyselytulosten jälkeen näytettävä mallineen nimi, jos sellaista on.',
	'srf-filtered-selectorlabel-list' => 'Luettelo',
	'srf-filtered-selectorlabel-calendar' => 'Kalenteri',
	'srf-printername-d3chart' => 'D3-kaavio',
	'srf-paramdesc-group' => 'Sarjan ryhmittelyavain',
	'srf-paramdesc-listtype' => 'Määritä luttelotyyppi',
	'srf-paramdesc-pageitems' => 'Kohteiden määrä sivulla',
	'srf-printername-eventcalendar' => 'Tapahtumakalenteri',
	'srf-paramdesc-calendarfirstday' => 'Viikon ensimmäinen päivä',
	'srf-paramdesc-calendardefaultview' => 'Aloitusnäkymä, kun kalenteria ladataan',
	'srf-paramdesc-calendarstart' => 'Kalenterin alkupäivämäärä',
	'srf-ui-eventcalendar-label-today' => 'Tänään',
	'srf-ui-eventcalendar-label-month' => 'Kuukausi',
	'srf-ui-eventcalendar-label-week' => 'Viikko',
	'srf-ui-eventcalendar-label-day' => 'Päivä',
	'srf-ui-eventcalendar-label-allday' => 'Koko päivä',
	'srf-printername-dygraphs' => 'Dygraphs-kaavio',
	'srf-paramdesc-datasource' => 'Määritä datan tiedonlähteen sijainti (tiedosto, URL jne.)',
	'srf-paramdesc-yaxislabel' => 'Y-akselin selite',
	'srf-paramdesc-xaxislabel' => 'X-akselin selite',
	'srf-paramdesc-unit' => 'Yksikkö',
	'srf-printername-incoming' => 'Saapuvat ominaisuudet',
	'srf-paramdesc-min' => 'Vähimmäis- tai kynnysarvo',
	'srf-paramdesc-excludeproperty' => 'Poista ominaisuus tulosten joukosta',
);

/** French (français)
 * @author Brunoperel
 * @author Crochet.david
 * @author DavidL
 * @author Erkethan
 * @author Gomoko
 * @author Grondin
 * @author Hashar
 * @author IAlex
 * @author Iluvalar
 * @author McDutchie
 * @author Nicolas NALLET
 * @author Peter17
 * @author PieRRoMaN
 * @author Tititou36
 * @author Urhixidur
 * @author Verdy p
 */
$messages['fr'] = array(
	'srf-desc' => "Formats additionnels d'affichage pour les requêtes de Semantic MediaWiki",
	'srf-name' => 'Formatage des résultats sémantiques',
	'prefs-srf' => 'Formats des résultats sémantiques',
	'srf-prefs-intro-text' => "Vous avez installé l'extension Formats de résultats sémantiques qui, pour l'instant, n'a pas d'option paramétrable par l'utilisateur. Pour une aide, veuillez regarder la page d'aide [http://www.semantic-mediawiki.org/wiki/Help:Result_formats formats de résultat].",
	'srf-module-loading' => 'Chargement...',
	'srf-paramdesc-layout' => 'Mise en page disponible',
	'srf-paramdesc-height' => 'Hauteur (en pixels)',
	'srf-paramdesc-width' => 'Largeur',
	'srf-paramdesc-class' => 'Spécifiez une classe CSS supplémentaire',
	'srf-module-nomatch' => 'Aucun résultat trouvé',
	'srf-paramdesc-charttype' => 'Type de graphique disponible',
	'srf-navigation-previous' => 'Précédent',
	'srf-ui-navigation-prev' => 'Précédent',
	'srf-ui-navigation-next' => 'Suivant',
	'srf-ui-common-label-source' => 'Source',
	'srf-ui-common-label-datasource' => 'Source de données',
	'srf-ui-common-label-ajax-error' => 'Le serveur a signalé un échec de communication pour ce $1. Veuillez rafraîchir la page ou la consulter avec ce $2.',
	'srf-ui-common-label-request-object' => 'objet requête',
	'srf-ui-common-label-help-section' => "section d'aide",
	'srf-ui-tooltip-title-options' => 'Options',
	'srf-ui-tooltip-title-scope' => 'Portée',
	'srf-error-option-mix' => "L'option ($1) n'est pas disponible",
	'srf-error-option-link-all' => 'L\'option ($1) nécessite le paramètre "link" pour être mise à "all"',
	'srf-error-missing-layout' => 'Mise en page manquante',
	'srf-warn-empy-chart' => 'Le graphique est vide en raison de données manquantes',
	'srfc_previousmonth' => 'Mois précédent',
	'srfc_nextmonth' => 'Mois suivant',
	'srfc_today' => 'Aujourd’hui',
	'srfc_gotomonth' => 'Aller vers le mois',
	'srf_printername_calendar' => 'Calendrier mensuel',
	'srf_paramdesc_calendarlang' => 'Le code de la langue dans laquelle afficher le calendrier',
	'srf_paramdesc_calendarcolors' => 'La couleur à afficher pour chaque propriété date (exemple: "Date de démarrage => green,Date de fin => #09c")',
	'srf_vcard_link' => 'vCarte',
	'srf_printername_vcard' => 'export en vCard',
	'srf_icalendar_link' => 'iCalendrier',
	'srf_printername_icalendar' => 'export en iCalendar',
	'srf_paramdesc_icalendartitle' => 'Le titre du fichier calendrier',
	'srf_paramdesc_icalendardescription' => 'La description du fichier calendrier',
	'srf_printername_bibtex' => 'export en BibTeX',
	'srf_outline_novalue' => 'Aucune valeur',
	'srf_printername_outline' => 'esquisse',
	'srf_paramdesc_outlineproperties' => 'La liste des propriétés à afficher comme en-têtes, séparées par des virgules',
	'srf_printername_sum' => 'Somme de nombres',
	'srf_printername_average' => 'Moyenne des nombres',
	'srf_printername_max' => 'Nombre maximal',
	'srf_printername_min' => 'Nombre minimal',
	'srf_paramdesc_limit' => 'Le nombre maximum de pages à rechercher',
	'srf_printername_product' => 'Produit de nombres',
	'srf_printername_median' => 'Moyenne des nombres',
	'srf-paramdesc-default' => "Valeur par défaut qui s'affichera lorsqu'il n'y a pas de résultats numériques",
	'srf_printername_earliest' => 'Première heure',
	'srf_printername_latest' => 'Dernière heure',
	'srf_printername_timeline' => 'Chronologie',
	'srf_printername_eventline' => 'Chronologie des événements',
	'srf_paramdesc_timelinebands' => 'Définit quels groupes sont affichées dans les résultats.',
	'srf_paramdesc_timelineposition' => 'Définit la zone de la frise initialement centrée.',
	'srf_paramdesc_timelinestart' => 'Un nom de propriété utilisé pour définir un point de démarrage',
	'srf_paramdesc_timelineend' => 'Un nom de propriété utilisé pour définir un point de seconde date',
	'srf_paramdesc_timelinesize' => 'La hauteur de la frise',
	'srf-timeline-allresults' => 'Autres résultats pour cette requête.',
	'srf-timeline-nojs' => 'JavaScript doit être activé pour voir la chronologie interactive.',
	'srf_paramdesc_views' => 'Les vues à afficher',
	'srf_paramdesc_facets' => 'L’ensemble des propriétés à afficher pour chaque page',
	'srf_paramdesc_lens' => 'Le nom du modèle utilisé pour afficher les propriétés de la page',
	'srf_printername_googlebar' => 'Diagramme à barres de Google',
	'srf_printername_googlepie' => 'Diagramme en camembert de Google',
	'srf-printername-jqplotchart' => 'graphique jqPlot',
	'srf-printername-jqplotseries' => 'série jqPlot',
	'srf_paramdesc_chartheight' => "Spécifiez la hauteur (en pixels) d'un diagramme ou d'un graphe",
	'srf_paramdesc_chartwidth' => "Indiquez la largeur (en pixels ou en pourcentage) d'un diagramme ou d'un graphique",
	'srf_paramdesc_charttitle' => 'Le titre du graphique',
	'srf_paramdesc_barcolor' => 'La couleur des barres',
	'srf_paramdesc_bardirection' => "Spécifier la direction d'un diagramme",
	'srf-paramdesc-direction' => "Indiquez l'orientation d'un diagramme ou d'un graphique",
	'srf_paramdesc_barnumbersaxislabel' => 'Étiquette pour l’axe numérique',
	'srf-paramdesc-labelaxislabel' => "La légende de l'axe des libellés",
	'srf-paramdesc-ticklabels' => "Activer l'affichage des libellés de graduation",
	'srf-paramdesc-minvalue' => "La valeur minimale à afficher sur l'axe des ordonnées",
	'srf-paramdesc-pointlabels' => 'Affichage des points de données dans le graphique',
	'srf-paramdesc-chartlegend' => 'Position de la légende du graphique',
	'srf-paramdesc-datalabels' => 'Afficher les étiquettes du graphique',
	'srf-paramdesc-charttext' => 'Texte descriptif du graphique',
	'srf-paramdesc-chartclass' => 'Classe CSS additionnelle',
	'srf-paramdesc-renderer' => 'Sélectionnez un moteur de rendu graphique/graphe',
	'srf-paramdesc-filling' => 'Option de remplissage individuel',
	'srf-paramdesc-theme' => 'Sélectionnez un thème pour la grille',
	'srf-paramdesc-chartcolor' => 'Attribuer des couleurs individuelles au graphique',
	'srf-paramdesc-colorscheme' => 'Sélectionnez un jeu de couleurs',
	'srf-paramdesc-valueformat' => 'Spécifiez la règle de mise en forme des valeurs',
	'srf-paramdesc-highlighter' => 'Afficher un surligneur de point de données',
	'srf-paramdesc-smoothlines' => 'Appliquer un algorithme de lissage sur les graphiques en lignes',
	'srf-paramdesc-stackseries' => 'Afficher le graphique sous forme de barres empilées',
	'srf-paramdesc-seriesgroup' => 'Sélectionner le regroupement par séries',
	'srf-paramdesc-serieslabel' => 'Déterminer le libellé des séries',
	'srf-paramdesc-grouplabel' => 'Déterminer le libellé de groupe',
	'srf-paramdesc-chartcursor' => "Option d'affichage du curseur de diagramme",
	'srf-paramdesc-trendline' => "Active l'affichage simultané d'un diagramme et de sa tendance",
	'srf-paramdesc-gridview' => 'Afficher le diagramme et les ensembles de données en même temps',
	'srf-paramdesc-infotext' => "Afficher les informations supplémentaires sur un tableau d'information correspondant",
	'srf-ui-gridview-label-item' => 'Élément de donnée',
	'srf-ui-gridview-label-value' => 'Valeur de donnée',
	'srf-ui-gridview-label-series' => 'Série de données',
	'srf-ui-gridview-label-chart-tab' => 'Graphique',
	'srf-ui-gridview-label-data-tab' => 'Données',
	'srf-ui-gridview-label-info-tab' => 'Info',
	'srf_printername_gallery' => 'Galerie',
	'srf_paramdesc_perrow' => "Le nombre d'images par ligne",
	'srf_paramdesc_widths' => 'La largeur des images',
	'srf_paramdesc_heights' => 'La hauteur des images',
	'srf_paramdesc_autocaptions' => "Utiliser le nom de fichier comme légende lorsqu'aucune n'est fournie",
	'srf_paramdesc_fileextensions' => "Quand le nom de fichier est utilisé comme titre, afficher aussi l'extension du fichier",
	'srf_paramdesc_captionproperty' => 'Le nom de la propriété sémantique présent sur les pages demandées doit être utilisé comme titre',
	'srf_paramdesc_imageproperty' => 'Le nom de la propriété sémantique sur les pages demandées qui pointent vers des images à utiliser. Quand il est positionné, les pages demandées elles-mêmes ne seront aps affichées comme des images',
	'srf-paramdesc-redirects' => "Le nom d'une propriété sémantique présente sur les pages demandées qui contient la cible de la redirection",
	'srf-paramdesc-navigation' => 'Contrôle de navigation de la mise en page',
	'srf-paramdesc-overlay' => "Activer la superposition d'image",
	'srf-gallery-navigation-previous' => 'Précédent',
	'srf-gallery-navigation-next' => 'Suivant',
	'srf-gallery-overlay-count' => 'Image $1 sur $2',
	'srf-gallery-image-url-error' => "L'image n'a pas été trouvée",
	'srf_printername_tagcloud' => 'Nuage de tags',
	'srf_paramdesc_includesubject' => 'Si les noms des sujets eux-mêmes devraient être inclus',
	'srf_paramdesc_increase' => 'Comment augmenter la taille des tags',
	'srf_paramdesc_tagorder' => "L'ordre des tags",
	'srf_paramdesc_mincount' => "Le nombre minimal de fois qu'une valeur doit être utilisée pour être listée",
	'srf_paramdesc_minsize' => 'La taille du plus petit tag en pourcent',
	'srf_paramdesc_maxsize' => 'La taille du plus grand des tags en pourcent',
	'srf_paramdesc_maxtags' => 'Le montant maximal des tags dans le nuage',
	'srf-paramdesc-excludetags' => 'Exclure les noms de balise (délimiteur : ;)',
	'srf_printername_valuerank' => 'Valeur du rang',
	'srf_printername_array' => 'Tableau',
	'srf_paramdesc_pagetitle' => "S'il faut afficher les titres de page comme entrées de résultat ou les omettre",
	'srf_paramdesc_hidegaps' => "S'il faut afficher les valeurs de propriété ou d'enregistrement non disponibles séparées par des séparateurs ou les omettre",
	'srf_paramdesc_arrayname' => 'Si un ArrayExtension donné est disponible, cela créera un tableau avec le nom spécifié (pas de sortie visible, dans ce cas)',
	'srf_paramdesc_propsep' => 'Séparateur entre les propriétés demandées',
	'srf_paramdesc_manysep' => 'Séparateur entre les valeurs de propriété multi-valuées',
	'srf_paramdesc_recordsep' => "Séparateur entre les valeurs les propriétés d'enregistrement",
	'srf_paramdesc_headersep' => 'Séparateur entre le nom de la propriété et la valeur si "<code>headers</code>" est positionné à "<code>show</code>" ou "<code>plain</code>"',
	'srf_printername_hash' => 'Hachage',
	'srf_paramdesc_hashname' => "Si l'extension HashTables est disponible et fournie, ceci créera un hachage avec le nom spécifié (pas de sortie visible dans ce cas)",
	'srf-printername-graph' => 'Graphe',
	'srf-paramdesc-graph-relation' => 'Est-ce que les sujets ou les propriétés de nom sont des parents ou des enfants ?',
	'srf-paramdesc-graph-nameprop' => "Permet de définir une propriété qui sera utilisée comme sujet au lieu de l'objet réel",
	'srf-paramdesc-graph-nodeshape' => 'La forme de chaque nœud sur le graphe.',
	'srf_paramdesc_graphname' => 'Titre',
	'srf_paramdesc_graphsize' => 'Taille du graphe (en px)',
	'srf_paramdesc_graphlegend' => 'Afficher la légende de graphe ou non',
	'srf_paramdesc_graphlabel' => 'Étiquette du graphe',
	'srf_paramdesc_rankdir' => 'Direction de la flèche',
	'srf_paramdesc_graphlink' => 'Lien vers le graphe',
	'srf_paramdesc_graphcolor' => 'Couleur du graphe',
	'srf-paramdesc-graph-wwl' => 'Limite de retour automatique (en nombre de caractères)',
	'srf_printername_datatables' => 'Tables de données',
	'srf-paramdesc-rowindex' => 'Index de la ligne de la table',
	'srf-paramdesc-displaylength' => "Longueur d'affichage initiale",
	'srf_printername_tree' => 'Arbre',
	'srf_printername_ultree' => 'Arbre Ul',
	'srf_printername_oltree' => 'Arbre Ol',
	'srf-noparentprop' => "Aucune propriété parente fournie. L'arbre ne peut pas être construit sans une propriété parente spécifiée.",
	'srf-paramdesc-parent' => 'La propriété contenant la page parent',
	'srf-printername-slideshow' => 'Diaporama',
	'srf-paramdesc-delay' => 'Le délai entre les diapositives en secondes',
	'srf-paramdesc-navigation-controls' => 'Afficher les contrôles de navigation ou non',
	'srf-paramdesc-effect' => "L'effet à utiliser pour passer d'une diapositive à l'autre",
	'srf-printername-filtered' => 'Filtré',
	'srf-paramdesc-filtered-views' => "Les vues qui devraient être disponibles dans l'affichage des résultats.",
	'srf-paramdesc-filtered-filter-position' => 'La position des filtres en lien avec ces vues. Valeurs permises: top, bottom. Par défaut: top.',
	'srf-paramdesc-filtered-list-type' => 'Le type de la liste. Valeurs permises: list, ul, ol. Par défaut: list.',
	'srf-paramdesc-filtered-list-template' => 'Le modèle qui doit être utilisé pour mettre en forme les entrées de la liste.',
	'srf-paramdesc-filtered-list-named-args' => 'Nommer les arguments passés au modèle.',
	'srf-paramdesc-filtered-list-introtemplate' => "Le nom du modèle à afficher avant les résultats de la requête, s'il y en a.",
	'srf-paramdesc-filtered-list-outrotemplate' => "Le nom d'un modèle à afficher après les résultats de la requête, s'il y en a.",
	'srf-paramdesc-filtered-calendar-start' => "L'imprimé contenant la date de début d'un événement",
	'srf-paramdesc-filtered-calendar-end' => "L'imprimé contenant la date de fin d'un événement",
	'srf-paramdesc-filtered-calendar-title' => "L'imprimé contenant le titre d'un événement. Ne peux pas être utilisé en même temps qu'un modèle de titre.",
	'srf-paramdesc-filtered-calendar-title-template' => "Un modèle utilisé pour mettre en forme le titre de l'événement dans le calendrier",
	'srf-filtered-selectorlabel-list' => 'Liste',
	'srf-filtered-selectorlabel-calendar' => 'Calendrier',
	'srf-printername-d3chart' => 'Graphique D3',
	'srf-printername-timeseries' => 'Graphique de séries chronologiques',
	'srf-paramdesc-group' => 'Séries groupées par',
	'srf-paramdesc-zoom' => 'Activer le zoom',
	'srf-paramdesc-datatable' => 'Activer une table de données',
	'srf-timeseries-zoom-out-of-range' => "La plage de zoom n'a pas produit de données suffisantes",
	'srf-printername-sparkline' => 'Graphique de lignes de tendance',
	'srf-printername-listwidget' => 'Widget liste',
	'srf-paramdesc-listtype' => 'Indiquez le type de liste',
	'srf-paramdesc-widget' => 'Widget disponible',
	'srf-paramdesc-pageitems' => 'Éléments par page',
	'srf-printername-eventcalendar' => 'Calendrier des événements',
	'srf-paramdesc-calendarfirstday' => 'Le jour de démarrage de la semaine',
	'srf-paramdesc-calendardefaultview' => 'La vue initiale quand le calendrier est chargé',
	'srf-paramdesc-calendarstart' => 'Le démarrage du calendrier initial',
	'srf-paramdesc-dayview' => 'Activer la vue journalière en cliquant sur le numéro du jour',
	'srf-ui-eventcalendar-label-today' => 'Aujourd’hui',
	'srf-ui-eventcalendar-label-month' => 'Mois',
	'srf-ui-eventcalendar-label-week' => 'Semaine',
	'srf-ui-eventcalendar-label-day' => 'Jour',
	'srf-ui-eventcalendar-label-allday' => 'Toute la journée',
	'srf-printername-dygraphs' => 'Diagramme Dygraph',
	'srf-paramdesc-datasource' => 'Spécifiez la source depuis laquelle les données est accessibles (fichier, URL, etc.)',
	'srf-paramdesc-errorbar' => "Spécifie la barre d'erreur utilisée (écart-type (sigma), fractions appliquées, ou barres personnalisées sous forme d'intervalle de valeurs basse;médiane;haute)",
	'srf-paramdesc-movingaverage' => 'Affiche la moyenne sur un nombre donné de jours (zéro indiquera aucune moyenne mobile)',
	'srf-paramdesc-yaxislabel' => "Légende apparaissant sur l'axe y",
	'srf-paramdesc-xaxislabel' => "Légende apparaissant sur l'axe y",
	'srf-paramdesc-unit' => 'Unité',
	'srf-printername-pagewidget' => 'Widget de page',
	'srf-printername-incoming' => 'Propriétés entrantes',
	'srf-paramdesc-min' => 'Valeur minimale ou seuil',
	'srf-paramdesc-excludeproperty' => "Exclure la propriété de l'ensemble des résultats",
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'srf-name' => 'Formatâjo des rèsultats sèmanticos',
	'srf-module-loading' => 'Chargement...',
	'srf-paramdesc-height' => 'Hôtior (en pixèls)',
	'srf-paramdesc-width' => 'Largior',
	'srf-paramdesc-class' => 'Cllâsse CSS de ples', # Fuzzy
	'srfc_previousmonth' => 'Mês devant',
	'srfc_nextmonth' => 'Mês aprés',
	'srfc_today' => 'Houé',
	'srfc_gotomonth' => 'Alar vers lo mês',
	'srf_printername_calendar' => 'Calendriér du mês',
	'srf_printername_vcard' => 'èxportacion en vCard',
	'srf_printername_icalendar' => 'èxportacion en iCalendar',
	'srf_paramdesc_icalendartitle' => 'Lo titro du fichiér calendriér',
	'srf_paramdesc_icalendardescription' => 'La dèscripcion du fichiér calendriér',
	'srf_printername_bibtex' => 'èxportacion en BibTeX',
	'srf_outline_novalue' => 'Gins de valor',
	'srf_printername_outline' => 'Començon',
	'srf_printername_sum' => 'Soma de nombros',
	'srf_printername_average' => 'Moyena des nombros',
	'srf_printername_max' => 'Nombro lo ples grant',
	'srf_printername_min' => 'Nombro lo ples petiôt',
	'srf_printername_product' => 'Fruit de nombros',
	'srf_printername_median' => 'Moyena des nombros',
	'srf_printername_earliest' => 'Premiére hora',
	'srf_printername_latest' => 'Dèrriére hora',
	'srf_printername_timeline' => 'Diagramo cronologico',
	'srf_printername_eventline' => 'Diagramo cronologico des èvènements',
	'srf_printername_googlebar' => 'Diagramo en bârres de Google',
	'srf_printername_googlepie' => 'Diagramo en torta de Google',
	'srf_paramdesc_chartheight' => 'La hôtior du diagramo, en pixèls', # Fuzzy
	'srf_paramdesc_chartwidth' => 'La largior du diagramo, en pixèls', # Fuzzy
	'srf_paramdesc_charttitle' => 'Lo titro du diagramo',
	'srf_paramdesc_barcolor' => 'La color de les bârres',
	'srf_paramdesc_bardirection' => 'La dirèccion du diagramo en bârres', # Fuzzy
	'srf_paramdesc_barnumbersaxislabel' => 'Lo lambél por l’axo numerico',
	'srf_printername_gallery' => 'Galerie',
	'srf_paramdesc_perrow' => 'Lo nombro d’émâges per legne',
	'srf_paramdesc_widths' => 'La largior de les émâges',
	'srf_paramdesc_heights' => 'La hôtior de les émâges',
	'srf-gallery-navigation-previous' => 'Devant',
	'srf-gallery-navigation-next' => 'Aprés',
	'srf-gallery-overlay-count' => 'Émâge $1 sur $2',
	'srf_printername_tagcloud' => 'Niola de tags',
	'srf_paramdesc_tagorder' => 'L’ôrdre des tags',
	'srf_printername_valuerank' => 'Valor du rang',
	'srf_printername_array' => 'Tablô',
	'srf_printername_hash' => 'Chaplâjo',
	'srf-printername-graph' => 'Diagramo',
	'srf_paramdesc_graphname' => 'Titro',
	'srf_paramdesc_graphsize' => 'Talye du diagramo (en px)',
	'srf_paramdesc_graphlegend' => 'Fâre vêre la lègenda du diagramo ou ben pas',
	'srf_paramdesc_graphlabel' => 'Lambél du diagramo',
	'srf_paramdesc_rankdir' => 'Dirèccion de la flèche',
	'srf_paramdesc_graphlink' => 'Lim de vers lo diagramo',
	'srf_paramdesc_graphcolor' => 'Color du diagramo',
	'srf-paramdesc-graph-wwl' => 'Limita de retôrn ôtomatico (en nombro de caractèros)',
	'srf_printername_datatables' => 'Grelyes de donâs',
	'srf_printername_tree' => 'Âbro',
	'srf_printername_ultree' => 'Âbro Ul',
	'srf_printername_oltree' => 'Âbro Ol',
	'srf-printername-filtered' => 'Filtrâ',
	'srf-printername-d3chart' => 'Diagramo D3',
	'srf-paramdesc-zoom' => 'Activar lo zoome',
	'srf-paramdesc-datatable' => 'Activar na grelye de donâs',
	'srf-paramdesc-listtype' => 'Tipo de lista', # Fuzzy
	'srf-paramdesc-pageitems' => 'Èlèments per pâge',
	'srf-printername-feed' => 'Flux RSS / Atom',
	'srf-paramdesc-feedtype' => 'Tipo de flux',
	'srf-paramdesc-feedtitle' => 'Titro du flux',
	'srf-paramdesc-feeddescription' => 'Dèscripcion du flux',
);

/** Irish (Gaeilge)
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'srf-module-loading' => 'Ag Lódáil...',
	'srf_paramdesc_graphname' => 'Teideal',
);

/** Galician (galego)
 * @author Alma
 * @author Toliño
 */
$messages['gl'] = array(
	'srf-desc' => 'Formatos adicionais para as pescudas interiores de Semantic MediaWiki',
	'srf-name' => 'Formatos dos resultados semánticos',
	'prefs-srf' => 'Formatos dos resultados semánticos',
	'srf-prefs-intro-text' => 'Ten instalada a extensión para dar formato aos resultados semánticos, pero nestes intres non ten opcións de personalización. Para obter axuda, visite a páxina de axuda sobre os [http://www.semantic-mediawiki.org/wiki/Help:Result_formats formatos dos rexultados].',
	'srf-module-loading' => 'Cargando...',
	'srf-paramdesc-layout' => 'Esquema dispoñible',
	'srf-paramdesc-height' => 'Altura (en píxeles)',
	'srf-paramdesc-width' => 'Largo',
	'srf-paramdesc-class' => 'Especificar unha clase CSS adicional',
	'srf-module-nomatch' => 'Non se atoparon coincidencias',
	'srf-paramdesc-charttype' => 'Tipo de gráficas dispoñible',
	'srf-navigation-previous' => 'Anterior',
	'srf-ui-navigation-prev' => 'Anterior',
	'srf-ui-navigation-next' => 'Seguinte',
	'srf-ui-common-label-source' => 'Fonte',
	'srf-ui-common-label-datasource' => 'Fonte de datos',
	'srf-ui-common-label-ajax-error' => 'O servidor informou dun fallo na comunicación con este $1. Intente recargar a páxina ou consulte a $2.',
	'srf-ui-common-label-request-object' => 'obxecto da solicitude',
	'srf-ui-common-label-help-section' => 'sección de axuda',
	'srf-ui-tooltip-title-options' => 'Opcións',
	'srf-ui-tooltip-title-scope' => 'Alcance',
	'srf-error-option-mix' => 'A opción ($1) non está dispoñible',
	'srf-error-option-link-all' => 'A opción ($1) necesita que o parámetro "link" estea definido como "all"',
	'srf-error-missing-layout' => 'Falta o esquema',
	'srf-warn-empy-chart' => 'A gráfica está baleira porque non hai datos suficientes',
	'srfc_previousmonth' => 'Mes anterior',
	'srfc_nextmonth' => 'Mes seguinte',
	'srfc_today' => 'Hoxe',
	'srfc_gotomonth' => 'Ir ao mes',
	'srf_printername_calendar' => 'Calendario mensual',
	'srf_paramdesc_calendarlang' => 'O código da lingua na que mostrar o calendario',
	'srf_paramdesc_calendarcolors' => 'A cor na que mostrar cada propiedade de data (exemplo: "Data de inicio=>green,Data de fin=>#09c")',
	'srf_vcard_link' => 'vTarxeta',
	'srf_printername_vcard' => 'Exportación en vCard',
	'srf_icalendar_link' => 'iCalendario',
	'srf_printername_icalendar' => 'Exportación en iCalendar',
	'srf_paramdesc_icalendartitle' => 'O título do ficheiro de calendario',
	'srf_paramdesc_icalendardescription' => 'A descrición do ficheiro de calendario',
	'srf_printername_bibtex' => 'Exportación en BibTeX',
	'srf_outline_novalue' => 'Sen valor',
	'srf_printername_outline' => 'Esquema',
	'srf_paramdesc_outlineproperties' => 'A lista de propiedades a mostrar como cabeceiras de contorno, separadas por comas',
	'srf_printername_sum' => 'Suma dos números',
	'srf_printername_average' => 'Media dos números',
	'srf_printername_max' => 'Número máximo',
	'srf_printername_min' => 'Número mínimo',
	'srf_paramdesc_limit' => 'O número máximo de páxinas a pescudar',
	'srf_printername_product' => 'Produto dos números',
	'srf_printername_median' => 'Media dos números',
	'srf-paramdesc-default' => 'O valor por defecto que se mostrará cando non haxa resultados numéricos',
	'srf_printername_earliest' => 'Primeira hora',
	'srf_printername_latest' => 'Última hora',
	'srf_printername_timeline' => 'Liña do tempo',
	'srf_printername_eventline' => 'Liña do evento',
	'srf_paramdesc_timelinebands' => 'Define as bandas que se mostrarán no resultado.',
	'srf_paramdesc_timelineposition' => 'Define onde se fixará inicialmente a liña do tempo.',
	'srf_paramdesc_timelinestart' => 'Un nome de propiedade usado para definir un primeiro punto de tempo',
	'srf_paramdesc_timelineend' => 'Un nome de propiedade usado para definir un segundo punto de tempo',
	'srf_paramdesc_timelinesize' => 'A altura da liña do tempo',
	'srf-timeline-allresults' => 'Máis resultados para esta pescuda.',
	'srf-timeline-nojs' => 'Debe ter o JavaScript activado para ollar a liña do tempo interactiva.',
	'srf_paramdesc_views' => 'As vistas a mostrar',
	'srf_paramdesc_facets' => 'O conxunto de propiedades a mostrar en cada páxina',
	'srf_paramdesc_lens' => 'O nome dun modelo co que mostrar as propiedades da páxina',
	'srf_printername_googlebar' => 'Gráfica de barras do Google',
	'srf_printername_googlepie' => 'Gráfica circular do Google',
	'srf-printername-jqplotchart' => 'Gráfica jqPlot',
	'srf-printername-jqplotseries' => 'Serie jqPlot',
	'srf_paramdesc_chartheight' => 'Especificar a altura da gráfica (en píxeles ou porcentaxe)',
	'srf_paramdesc_chartwidth' => 'Especificar o largo da gráfica (en píxeles ou porcentaxe)',
	'srf_paramdesc_charttitle' => 'O título da gráfica',
	'srf_paramdesc_barcolor' => 'A cor das barras',
	'srf_paramdesc_bardirection' => 'Especificar a dirección da gráfica',
	'srf-paramdesc-direction' => 'Especificar a dirección da gráfica',
	'srf_paramdesc_barnumbersaxislabel' => 'A etiqueta para o eixe numérico',
	'srf-paramdesc-labelaxislabel' => 'A etiqueta para o eixe da etiqueta',
	'srf-paramdesc-ticklabels' => 'Activar a visualización de etiquetas de marca',
	'srf-paramdesc-minvalue' => 'O valor mínimo que mostrar no eixe de ordenadas',
	'srf-paramdesc-pointlabels' => 'Mostra os puntos de datos na gráfica',
	'srf-paramdesc-chartlegend' => 'Posición da lenda da gráfica',
	'srf-paramdesc-datalabels' => 'Etiquetas de datos da gráfica',
	'srf-paramdesc-charttext' => 'Texto descritivo da gráfica',
	'srf-paramdesc-chartclass' => 'Clase CSS adicional',
	'srf-paramdesc-renderer' => 'Seleccione un procesador de gráficas',
	'srf-paramdesc-filling' => 'Opción de recheo individual',
	'srf-paramdesc-theme' => 'Seleccione un tema visual para a grella',
	'srf-paramdesc-chartcolor' => 'Asignar cores individuais á gráfica',
	'srf-paramdesc-colorscheme' => 'Seleccione un esquema de cores',
	'srf-paramdesc-valueformat' => 'Especifique a regra de formato para os valores',
	'srf-paramdesc-highlighter' => 'Mostrar un marcador de punto de datos',
	'srf-paramdesc-smoothlines' => 'Aplicar un algoritmo de suavizado nas liñas da gráfica',
	'srf-paramdesc-stackseries' => 'Mostrar a gráfica en forma de serie apilada',
	'srf-paramdesc-seriesgroup' => 'Seleccionar o agrupamento por series',
	'srf-paramdesc-serieslabel' => 'Determinar a etiqueta da serie',
	'srf-paramdesc-grouplabel' => 'Determinar a etiqueta do grupo',
	'srf-paramdesc-chartcursor' => 'Opción de visualización do cursor da gráfica',
	'srf-paramdesc-trendline' => 'Activar a visualización simultánea dunha gráfica e a súa liña de tencendia',
	'srf-paramdesc-gridview' => 'Mostrar a gráfica e os conxuntos de datos simultaneamente',
	'srf-paramdesc-infotext' => 'Mostrar información adicional na lapela de información correspondente',
	'srf-ui-gridview-label-item' => 'Elemento de datos',
	'srf-ui-gridview-label-value' => 'Valor dos datos',
	'srf-ui-gridview-label-series' => 'Serie de datos',
	'srf-ui-gridview-label-chart-tab' => 'Gráfica',
	'srf-ui-gridview-label-data-tab' => 'Datos',
	'srf-ui-gridview-label-info-tab' => 'Información',
	'srf_printername_gallery' => 'Galería',
	'srf_paramdesc_perrow' => 'A cantidade de imaxes por liña',
	'srf_paramdesc_widths' => 'O largo das imaxes',
	'srf_paramdesc_heights' => 'A altura das imaxes',
	'srf_paramdesc_autocaptions' => 'Usar o nome do ficheiro como pé de imaxe cando non se indica ningún',
	'srf_paramdesc_fileextensions' => 'Ao usar o nome do ficheiro como pé de imaxe, mostrar tamén a extensión do ficheiro',
	'srf_paramdesc_captionproperty' => 'O nome dunha propiedade semántica presente nas páxinas consultadas a usar como pé de imaxe',
	'srf_paramdesc_imageproperty' => 'Nome dunha propiedade semántica nas páxinas consultadas que apunta cara a imaxes a usar. Cando estea definido, as páxinas consultadas en si non se mostrarán como imaxes',
	'srf-paramdesc-redirects' => 'O nome dunha propiedade semántica presente nas páxinas consultadas que conteñen o destino da redirección',
	'srf-paramdesc-navigation' => 'Control de navegación do esquema',
	'srf-paramdesc-overlay' => 'Activar a sobreposición de imaxes',
	'srf-gallery-navigation-previous' => 'Anterior',
	'srf-gallery-navigation-next' => 'Seguinte',
	'srf-gallery-overlay-count' => 'Imaxe $1 de $2',
	'srf-gallery-image-url-error' => 'Non se atopou a imaxe.',
	'srf_printername_tagcloud' => 'Nube de etiquetas',
	'srf_paramdesc_includesubject' => 'Se os nomes dos temas deben incluírse',
	'srf_paramdesc_increase' => 'Como aumentar o tamaño das etiquetas',
	'srf_paramdesc_tagorder' => 'A orde das etiquetas',
	'srf_paramdesc_mincount' => 'A cantidade mínima de veces que un valor ten que producirse para estar na lista',
	'srf_paramdesc_minsize' => 'O tamaño das etiquetas máis pequenas en porcentaxe',
	'srf_paramdesc_maxsize' => 'O tamaño das etiquetas máis grandes en porcentaxe',
	'srf_paramdesc_maxtags' => 'A cantidade máxima de etiquetas na nube',
	'srf-paramdesc-excludetags' => 'Excluír as etiquetas (delimitador: ;)',
	'srf_printername_valuerank' => 'Valor do rango',
	'srf_printername_array' => 'Táboa',
	'srf_paramdesc_pagetitle' => 'Mostrar ou omitir os títulos das páxinas como entradas dos resultados',
	'srf_paramdesc_hidegaps' => 'Imprimir ou non os valores non dispoñibles das propiedades e dos rexistros baleiros solicitados, separados por separadores',
	'srf_paramdesc_arrayname' => 'En caso de que fose especificado e que a ArrayExtension estea dispoñible, isto creará unha táboa co nome indicado (sen saída visible)',
	'srf_paramdesc_propsep' => 'Separador entre as propiedades solicitadas',
	'srf_paramdesc_manysep' => 'Separador entre os valores das propiedades con moitos valores',
	'srf_paramdesc_recordsep' => 'Separador entre os valores das propiedades de rexistro',
	'srf_paramdesc_headersep' => 'Separador entre o nome e o valor da propiedade se "headers" está definido como "show" ou "plain"',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'En caso de que fose aclarado e que a extensión HashTables estea dispoñible, isto creará un hash co nome especificado (sen saída visible)',
	'srf-printername-graph' => 'Gráfica',
	'srf-paramdesc-graph-relation' => 'Son os asuntos ou as propiedades dos nomes pais ou fillos?',
	'srf-paramdesc-graph-nameprop' => 'Permite definir unha propiedade que se usará como asunto no canto do asunto real',
	'srf-paramdesc-graph-nodeshape' => 'A forma de cada nodo na gráfica',
	'srf_paramdesc_graphname' => 'Título',
	'srf_paramdesc_graphsize' => 'Tamaño da gráfica (en px)',
	'srf_paramdesc_graphlegend' => 'Mostrar ou non a lenga da gráfica',
	'srf_paramdesc_graphlabel' => 'Título da gráfica',
	'srf_paramdesc_rankdir' => 'Dirección da frecha',
	'srf_paramdesc_graphlink' => 'Ligazón da gráfica',
	'srf_paramdesc_graphcolor' => 'Cor da gráfica',
	'srf-paramdesc-graph-wwl' => 'Axuste automático de liña (en número de caracteres)',
	'srf_printername_datatables' => 'Táboas de datos',
	'srf-paramdesc-rowindex' => 'Índice da ringleira da táboa',
	'srf-paramdesc-displaylength' => 'Lonxitude inicial de presentación',
	'srf_printername_tree' => 'Árbore',
	'srf_printername_ultree' => 'Árbore UL',
	'srf_printername_oltree' => 'Árbore OL',
	'srf-noparentprop' => 'Non se especificou propiedade pai ningunha. Non se pode construír a árbore sen achegar unha propiedade pai.',
	'srf-paramdesc-parent' => 'A propiedade que contén a páxina pai',
	'srf-printername-slideshow' => 'Presentación de diapositivas',
	'srf-paramdesc-delay' => 'O tempo entre diapositivas, en segundos',
	'srf-paramdesc-navigation-controls' => 'Mostrar ou non os controis de navegación',
	'srf-paramdesc-effect' => 'O efecto que se usará ao cambiar dunha diapositiva a outra',
	'srf-printername-filtered' => 'Filtrado',
	'srf-paramdesc-filtered-views' => 'As vistas que deberan estar dispoñibles na presentación do resultado.',
	'srf-paramdesc-filtered-filter-position' => 'A posición dos filtros en relación coas visitas. Valores permitidos: top, bottom. Predeterminado: top.',
	'srf-paramdesc-filtered-list-type' => 'O tipo de lista. Valores permitidos: list, ul, ol. Predeterminado: list.',
	'srf-paramdesc-filtered-list-template' => 'O modelo empregado para dar formato ás entradas da lista.',
	'srf-paramdesc-filtered-list-named-args' => 'Dea nome aos argumentos que se lle pasan ao modelo.',
	'srf-paramdesc-filtered-list-introtemplate' => 'O nome dun modelo a mostrar antes dos resultados da pescuda, se houbese algún.',
	'srf-paramdesc-filtered-list-outrotemplate' => 'O nome dun modelo a mostrar despois dos resultados da pescuda, se houbese algún.',
	'srf-paramdesc-filtered-calendar-start' => 'A impresión que contén a data de inicio dun acontecemento',
	'srf-paramdesc-filtered-calendar-end' => 'A impresión que contén a data de fin dun acontecemento',
	'srf-paramdesc-filtered-calendar-title' => 'A impresión que contén o título dun acontecemento. Non se pode empregar á vez que un modelo de título.',
	'srf-paramdesc-filtered-calendar-title-template' => 'Un modelo utilizado para dar formato ao título dun acontecemento no calendario',
	'srf-filtered-selectorlabel-list' => 'Lista',
	'srf-filtered-selectorlabel-calendar' => 'Calendario',
	'srf-printername-d3chart' => 'Gráfica D3',
	'srf-printername-timeseries' => 'Gráfica de serie temporal',
	'srf-paramdesc-group' => 'Serie agrupada por',
	'srf-paramdesc-zoom' => 'Activar o zoom',
	'srf-paramdesc-datatable' => 'Activar unha táboa de datos',
	'srf-timeseries-zoom-out-of-range' => 'O rango do zoom non produciu datos suficientes',
	'srf-printername-sparkline' => 'Gráfica sparkline',
	'srf-printername-listwidget' => 'Listwidget',
	'srf-paramdesc-listtype' => 'Especificar o tipo de lista',
	'srf-paramdesc-widget' => 'Widget dispoñible',
	'srf-paramdesc-pageitems' => 'Elementos por páxina',
	'srf-printername-eventcalendar' => 'Calendario de eventos',
	'srf-paramdesc-calendarfirstday' => 'O día que comeza a semana',
	'srf-paramdesc-calendardefaultview' => 'A vista inicial cando carga o calendario',
	'srf-paramdesc-calendarstart' => 'O comezo do calendario inicial',
	'srf-paramdesc-dayview' => 'Activar a vista de día ao premer no número do día',
	'srf-ui-eventcalendar-label-today' => 'Hoxe',
	'srf-ui-eventcalendar-label-month' => 'Mes',
	'srf-ui-eventcalendar-label-week' => 'Semana',
	'srf-ui-eventcalendar-label-day' => 'Día',
	'srf-ui-eventcalendar-label-allday' => 'Todo o día',
	'srf-printername-dygraphs' => 'Gráfica dupla',
	'srf-paramdesc-datasource' => 'Especificar a fonte na que están accesibles os datos (ficheiro, enderezo URL etc.)',
	'srf-paramdesc-errorbar' => 'Especificar o erro que usou a barra (desviación típica (sigma), intervalo das fraccións ou unha barra personalizada como un rango de valores low;middle;high)',
	'srf-paramdesc-movingaverage' => 'Mostrar a media despois dun número de días ("zero" ha indicar que a media non se move)',
	'srf-paramdesc-yaxislabel' => 'Descrición do eixe Y',
	'srf-paramdesc-xaxislabel' => 'Descrición do eixe X',
	'srf-paramdesc-unit' => 'Unidade',
	'srf-printername-pagewidget' => 'Pagewidget',
	'srf-printername-incoming' => 'Propiedades entrantes',
	'srf-paramdesc-min' => 'Valor mínimo ou límite',
	'srf-paramdesc-excludeproperty' => 'Excluír a propiedade do conxunto de resultados',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'srfc_today' => 'Σήμερον',
	'srf_printername_outline' => 'Περίγραμμα',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'srf-desc' => 'Zuesätzligi Format fir Semantic MediaWiki inline-Abfroge',
	'srf-name' => 'Semantisch Ergebnis-Format',
	'srfc_previousmonth' => 'Vorige Monet',
	'srfc_nextmonth' => 'Negschte Monet',
	'srfc_today' => 'Hit',
	'srfc_gotomonth' => 'Gang zum Monet',
	'srf_printername_calendar' => 'Monetlige Kaländer',
	'srf_paramdesc_calendarlang' => 'Dr Sprochcode fir d Sproch, wu dr Kaländer soll din aazeigt wäre',
	'srf_printername_vcard' => 'vCard-Export',
	'srf_printername_icalendar' => 'iCalendar-Export',
	'srf_paramdesc_icalendartitle' => 'Dr Titel vu dr Kaländerdatei',
	'srf_paramdesc_icalendardescription' => 'D Bschryybig vu dr Kaländerdatei',
	'srf_printername_bibtex' => 'BibTeX-Export',
	'srf_outline_novalue' => 'Kei Wärt',
	'srf_printername_outline' => 'Entwurf',
	'srf_paramdesc_outlineproperties' => 'D Lischt vu dr Eigeschafte, wu as Ibersichts-Chopftext aazeigt wird, dur Komma trännt',
	'srf_printername_sum' => 'Zahl vu Nummere',
	'srf_printername_average' => 'Durschnitt vu Nummere',
	'srf_printername_max' => 'Hegschti Nummere',
	'srf_printername_min' => 'Niderschti Nummere',
	'srf_paramdesc_limit' => 'Di maximal Sytezahl, wu abgfrogt wird',
	'srf_printername_timeline' => 'Zytlyschte',
	'srf_printername_eventline' => 'Ereignislyschte',
	'srf_paramdesc_timelinebands' => 'Definiert d Skalierig, wu d Ergebnis aazeigt wäre.',
	'srf_paramdesc_timelineposition' => 'Definiert dr Schwärpunkt vu dr Zytachse.',
	'srf_paramdesc_timelinestart' => 'Dr Name vu dr Eigeschaft, wu dr erscht Zytpunkt definiert',
	'srf_paramdesc_timelineend' => 'Dr Name vu dr Eigenschaft, wu dr zwet Zytpunkt definiert',
	'srf_paramdesc_timelinesize' => 'D Hechi vu dr Zytachse',
	'srf_paramdesc_views' => 'D Ibersichte, wu aazeigt wäre',
	'srf_paramdesc_facets' => 'D Eigeschafte, wu uf jedere Syte solle aazeigt wäre',
	'srf_paramdesc_lens' => 'Dr Name vu dr Vorlag, wu Syteneigeschafte dermit aazeigt wäre',
	'srf_printername_googlebar' => 'Google-Syylediagramm',
	'srf_printername_googlepie' => 'Google-Kreisdiagramm',
	'srf_paramdesc_chartheight' => 'D Hechi vum Diagramm, in Pixel', # Fuzzy
	'srf_paramdesc_chartwidth' => 'D Breiti vum Diagramm, in Pixel', # Fuzzy
	'srf_paramdesc_charttitle' => 'Dr Titel vum Diagramm',
	'srf_paramdesc_barcolor' => 'D Farb vu dr Balke',
	'srf_paramdesc_bardirection' => 'E Syyle- (sänkrächti Uusrichtig) oder Balkediagramm (woogrächti Uusrichtig)', # Fuzzy
	'srf_paramdesc_barnumbersaxislabel' => 'D Bschryftig vu dr Zahle-Achs',
	'srf_printername_gallery' => 'Galeri',
	'srf_printername_tagcloud' => 'Schlagwortwulche',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'srfc_previousmonth' => 'Yn vee roish shen',
	'srfc_nextmonth' => 'Yn chied vee elley',
	'srfc_today' => 'Jiu',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author StuB
 * @author YaronSh
 * @author חיים
 */
$messages['he'] = array(
	'srf-desc' => 'תבניות נוספות לשאילתות מובנות של מדיה־ויקי סמנטית',
	'srf-name' => 'תבניות של תוצאות סמנטיות',
	'srfc_previousmonth' => 'החודש הקודם',
	'srfc_nextmonth' => 'החודש הבא',
	'srfc_today' => 'היום',
	'srfc_gotomonth' => 'מעבר לחודש',
	'srf_printername_calendar' => 'לוח חודשי',
	'srf_paramdesc_calendarlang' => 'קוד השפה שבה יוצג לוח השנה',
	'srf_printername_vcard' => 'ייצוא vCard',
	'srf_printername_icalendar' => 'ייצוא iCalendar',
	'srf_paramdesc_icalendartitle' => 'כותרת קובץ לוח השנה',
	'srf_paramdesc_icalendardescription' => 'תיאור קובץ לוח השנה',
	'srf_printername_bibtex' => 'ייצוא BibTeX',
	'srf_outline_novalue' => 'אין ערך',
	'srf_printername_outline' => 'מִתאר',
	'srf_paramdesc_outlineproperties' => 'רשימת מאפיינים להצגה ככותרות במִתאר, מופרדת בפסיקים',
	'srf_printername_sum' => 'סכום של מספרים',
	'srf_printername_average' => 'ממוצע של מספרים',
	'srf_printername_max' => 'המספר המרבי',
	'srf_printername_min' => 'מספר מינימלי',
	'srf_paramdesc_limit' => 'מספר הדפים המרבי לתשאול',
	'srf_printername_timeline' => 'ציר זמן',
	'srf_printername_eventline' => 'ציר אירועים',
	'srf_paramdesc_timelinebands' => 'מגדיר אילו פסים מוצגים בתוצאות.',
	'srf_paramdesc_timelineposition' => 'מגדיר איפה קו הזמן מתמקד בתחילה.',
	'srf_paramdesc_timelinestart' => 'שם המאפיין להגדרה בתור נקודת הזמן הראשונה',
	'srf_paramdesc_timelineend' => 'שם המאפיין להגדרת נקודת זמן שנייה',
	'srf_paramdesc_timelinesize' => 'גובה ציר הזמן',
	'srf_paramdesc_views' => 'התצוגות להצגה',
	'srf_paramdesc_facets' => 'קבוצת מאפיינים להצגה בראש כל דף',
	'srf_paramdesc_lens' => 'שם התבנית שבאמצעותה יוצגו מאפייני הדף',
	'srf_printername_googlebar' => 'תרשים עמודות של Google',
	'srf_printername_googlepie' => 'דיאגרמת עוגה של גוגל',
	'srf_paramdesc_chartheight' => 'ציין את הגובה (בפיקסלים) של תרשים או גרף',
	'srf_paramdesc_chartwidth' => 'ציין את הרוחב (פיקסלים או אחוזים) של תרשים או גרף',
	'srf_paramdesc_charttitle' => 'כותרת התרשים',
	'srf_paramdesc_barcolor' => 'צבע הפסים',
	'srf_paramdesc_bardirection' => 'כיוון התרשים',
	'srf_paramdesc_barnumbersaxislabel' => 'התווית לציר המספרים',
	'srf_printername_gallery' => 'גלריה',
	'srf_paramdesc_perrow' => 'מספר התמונות לשורה',
	'srf_paramdesc_widths' => 'רוחב התמונות',
	'srf_paramdesc_heights' => 'גובה התמונות',
	'srf_paramdesc_autocaptions' => 'להשתמש בקובץ בתור כותרת אם לא סופקה כותרת',
	'srf_printername_tagcloud' => 'ענן תגים',
	'srf_paramdesc_includesubject' => 'האם לכלול השמות של הנושאים עצמם',
	'srf_paramdesc_increase' => 'איך להגדיל את גודל התגים',
	'srf_paramdesc_tagorder' => 'סדר התגים',
	'srf_paramdesc_mincount' => 'המספר המזערי של הפעמים שהערך צריך להופיע כדי להיכנס לרשימה',
	'srf_paramdesc_minsize' => 'גודל התג הקטן ביותר באחוזים',
	'srf_paramdesc_maxsize' => 'גודל התגים הגדולים ביותר באחוזים',
	'srf_paramdesc_maxtags' => 'המספר המרבי של תגים בענן',
	'srf_printername_array' => 'מערך',
	'srf_paramdesc_pagetitle' => 'האם להציג כותרות דפים בתור עיולי תוצאה או להסתיר אותם',
	'srf_paramdesc_hidegaps' => 'האם להדפיס תכונה שהתבקשה אבל אינה זמינה מופרדים בתו מפריד או להסתיר אותם',
	'srf_paramdesc_arrayname' => 'אם ניתן וההרחבה ArrayExtension זמינה, זה ייצור מערך עם השם המוגדר (ואז לא יהיה פלט נראה לעין)',
	'srf_paramdesc_propsep' => 'מפריד בין רשומות מבוקשות',
	'srf_paramdesc_manysep' => 'מפריד בין ערכי מאפיינים מרובי־ערכים',
	'srf_paramdesc_recordsep' => 'מפריד בין ערכים של מאפייני רשומות',
	'srf_printername_hash' => 'גיבוב',
	'srf_paramdesc_hashname' => 'אם זה ניתן ואם ההרחבה HashTables זמינה, זה ייצור גיבוב עם עם השם המוגדר (ואז לא יהיה פלט נראה לעין)',
	'srf-printername-graph' => 'תרשים',
	'srf-paramdesc-graph-relation' => 'האם הנושאים או מאפייני שם (nameproperties) הורים או ילדים?',
	'srf-paramdesc-graph-nameprop' => 'מאפשר הגדרת מאפיין שישמש נושא במקום הנושא הנוכחי',
	'srf-paramdesc-graph-nodeshape' => 'הצורה של כל צומת בגרף',
	'srf_paramdesc_graphname' => 'כותרת',
	'srf_paramdesc_graphsize' => 'גודל הגרף (בפיקסלים)',
	'srf_paramdesc_graphlegend' => 'להציג את מקרא הגרף או לא',
	'srf_paramdesc_graphlabel' => 'תווית גרף',
	'srf_paramdesc_rankdir' => 'כיוון החץ',
	'srf_paramdesc_graphlink' => 'קישור גרף',
	'srf_paramdesc_graphcolor' => 'צבע הגרף',
	'srf-paramdesc-graph-wwl' => 'מגבלת גלישת מילים (מספר תווים)',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'srfc_previousmonth' => 'पिछला महिना',
	'srfc_nextmonth' => 'अगला महिना',
	'srfc_today' => 'आज़',
	'srfc_gotomonth' => 'महिनेपर चलें',
	'srf_icalendar_link' => 'आइकैलेंडर',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'srf-desc' => 'Přidatne formaty za rjadowe wotprašowanja Semantic MediaWiki',
	'srf-name' => 'Formaty semantiskich wuslědkow',
	'prefs-srf' => 'Formaty semantiskich wuslědkow',
	'srf-module-loading' => 'Začituje so...',
	'srf-paramdesc-layout' => 'K dispoziciji stejacy layout',
	'srf-paramdesc-height' => 'Wysokosć (w pikselach)',
	'srf-paramdesc-width' => 'Šěrokosć',
	'srf-paramdesc-class' => 'Podaj přidatnu CSS-klasu',
	'srf-module-nomatch' => 'Žane wotpowědniki namakane.',
	'srf-paramdesc-charttype' => 'K dispoziciji diagramowy typ',
	'srf-navigation-previous' => 'Předchadny',
	'srf-ui-navigation-prev' => 'Wróćo',
	'srf-ui-navigation-next' => 'Přichodny',
	'srf-ui-common-label-source' => 'Žórło',
	'srf-ui-common-label-datasource' => 'Datowe žórło',
	'srf-ui-common-label-request-object' => 'Objekt wotprašować',
	'srf-ui-common-label-help-section' => 'wotrězk pomocy',
	'srf-ui-tooltip-title-options' => 'Nastajenja',
	'srf-ui-tooltip-title-scope' => 'Wobłuk',
	'srf-error-option-mix' => 'Opcija ($1) k dispoziciji njesteji',
	'srf-error-option-link-all' => 'Opcija ($1) sej wužaduje, zo so parameter "link" na "all" staji',
	'srf-error-missing-layout' => 'Layout faluje',
	'srf-warn-empy-chart' => 'Diagram/grafika njeda so wutworić, dokelž daty faluja',
	'srfc_previousmonth' => 'Předchadny měsac',
	'srfc_nextmonth' => 'Přichodny měsac',
	'srfc_today' => 'Dźensa',
	'srfc_gotomonth' => 'Dźi k měsacej',
	'srf_printername_calendar' => 'Měsačna protyka',
	'srf_paramdesc_calendarlang' => 'Kod za rěč, w kotrejž protyka ma so zwobraznić',
	'srf_paramdesc_calendarcolors' => 'Barba, kotraž dyrbi so za kóždu datumowu kajkosć zwobraznić (na přikład: "Startowy datum=>green,Kónčny datum=>#09c")',
	'srf_printername_vcard' => 'vCard eksportować',
	'srf_printername_icalendar' => 'iCalendar eksportować',
	'srf_paramdesc_icalendartitle' => 'Titul protykoweje dataje',
	'srf_paramdesc_icalendardescription' => 'Wopisanje protykoweje dataje',
	'srf_printername_bibtex' => 'BibTeX eksportować',
	'srf_outline_novalue' => 'Žana hódnota',
	'srf_printername_outline' => 'Kontura',
	'srf_paramdesc_outlineproperties' => 'Lisćina kajkosćow, kotryž maja so jako rozrjadowanske nadpisma, přez komy dźělene',
	'srf_printername_sum' => 'Suma ličbow',
	'srf_printername_average' => 'Přerězk ličbow',
	'srf_printername_max' => 'Maksimalna ličba',
	'srf_printername_min' => 'Minimalna ličba',
	'srf_paramdesc_limit' => 'Maksimalna ličba stronow za naprašowanje',
	'srf_printername_product' => 'Produkt ličbow',
	'srf_printername_median' => 'Mediana hódnota ličbow',
	'srf-paramdesc-default' => 'Standardna hódnota, kotraž so zwobraznja, jeli numeriske wuslědki njejsu',
	'srf_printername_earliest' => 'Najzažniši časowy dypk',
	'srf_printername_latest' => 'Najpozdźiši časowy dypk',
	'srf_printername_timeline' => 'Časowa wotběh',
	'srf_printername_eventline' => 'Wotběh podawkow',
	'srf_paramdesc_timelinebands' => 'Definuje, kotre smuhi so we wuslědku zwobraznjeja.',
	'srf_paramdesc_timelineposition' => 'Definuje, hdźež časowa linija na spočatku ma swój fokus.',
	'srf_paramdesc_timelinestart' => 'Mjeno atributa, kotrež so wužiwa, zo by prěni časowy dypk definowało',
	'srf_paramdesc_timelineend' => 'Mjeno atributa, kotrež so wužiwa, zo by druhi časowy dypk definowało',
	'srf_paramdesc_timelinesize' => 'Wysokosć časoweje linije',
	'srf-timeline-allresults' => 'Dalše wuslědki za tute naprašowanje.',
	'srf-timeline-nojs' => 'Dyrbiš JavaScript aktiwizować, zo by sej interaktiwnu časowu wósku wobhladał.',
	'srf_paramdesc_views' => 'Napohlady, kotrež maja so zwobraznić',
	'srf_paramdesc_facets' => 'Sadźba atributow, kotrež maja so za kóždu stronu zwobraznić',
	'srf_paramdesc_lens' => 'Mjeno předłohi, z kotrejž atributy strony maja so zwobraznić',
	'srf_printername_googlebar' => 'Google hrjadowy diagram',
	'srf_printername_googlepie' => 'Google tortowy diagram',
	'srf-printername-jqplotchart' => 'jqPlot-diagram',
	'srf-printername-jqplotseries' => 'jqPlot-rjady',
	'srf_paramdesc_chartheight' => 'Podaj wysokosć diagrama abo grafiki (w pikselach)',
	'srf_paramdesc_chartwidth' => 'Podaj šěrokosć diagrama abo grafiki (w pikselach abo procentach)',
	'srf_paramdesc_charttitle' => 'Titul diagrama',
	'srf_paramdesc_barcolor' => 'Barba hrjadow/stołpow',
	'srf_paramdesc_bardirection' => 'Směr diagrama podać',
	'srf-paramdesc-direction' => 'Podaj směr diagrama abo grafiki',
	'srf_paramdesc_barnumbersaxislabel' => 'Popisanje y-wóski',
	'srf-paramdesc-minvalue' => 'Minimalna hódnota, kotraž ma so na Y-wósce pokazać',
	'srf-paramdesc-pointlabels' => 'Dypki diagramowych datow zwobraznić',
	'srf-paramdesc-chartlegend' => 'Pozicija diagramoweje legendy',
	'srf-paramdesc-datalabels' => 'Popisy za diagramy a grafiki',
	'srf-paramdesc-charttext' => 'Wopisowacy diagramowy tekst',
	'srf-paramdesc-chartclass' => 'Přidatna CSS-klasa',
	'srf-paramdesc-renderer' => 'Program za rysowanje grafiki/diagrama wubrać',
	'srf-paramdesc-filling' => 'Indiwiduelna pjelnjenska opcija',
	'srf-paramdesc-theme' => 'Lěsyčnu drastu wubrać',
	'srf-paramdesc-chartcolor' => 'Jednotliwe diagramowe barby připokazać',
	'srf-paramdesc-colorscheme' => 'Barbowu šemu wubrać',
	'srf-paramdesc-valueformat' => 'Formatowanske prawidło za hódnoty podać',
	'srf-paramdesc-highlighter' => 'Wuzběhnjenje datowych dypkow zwobraznić',
	'srf-paramdesc-smoothlines' => 'Algoritmus za wupłonjenje na linijowych diagramach nałožić',
	'srf-paramdesc-stackseries' => 'Diagram jako worštowane rjady zwobraznić',
	'srf-paramdesc-seriesgroup' => 'Grupěrowanje rjadow wubrać',
	'srf-paramdesc-serieslabel' => 'Popis rjadow zwěsćić',
	'srf-paramdesc-chartcursor' => 'Opcija za zwobraznjenje kursora w diagramje',
	'srf-paramdesc-gridview' => 'Diagram a datowe sadźby simultanje zwobraznić',
	'srf-paramdesc-infotext' => 'Přidatne informacije na wotpowědowacym rajtarku Info zwobraznić',
	'srf-ui-gridview-label-item' => 'Datowy element',
	'srf-ui-gridview-label-value' => 'Datowa hódnota',
	'srf-ui-gridview-label-series' => 'Datowe rjady',
	'srf-ui-gridview-label-chart-tab' => 'Diagram',
	'srf-ui-gridview-label-data-tab' => 'Daty',
	'srf-ui-gridview-label-info-tab' => 'Info',
	'srf_printername_gallery' => 'Galerija',
	'srf_paramdesc_perrow' => 'Ličba wobrazow na rjadku',
	'srf_paramdesc_widths' => 'Šěrokosć wobrazow',
	'srf_paramdesc_heights' => 'Wysokosć wobrazow',
	'srf_paramdesc_autocaptions' => 'Datajowe mjeno jako wobrazowe wopisanje wužiwać, jeli tajke njeje podate.',
	'srf_paramdesc_fileextensions' => 'Jeli so datajowe mjeno jako wopisanje wužiwa, tež datajowu kóncowku pokazać',
	'srf_paramdesc_captionproperty' => 'Mjeno semantiskeje kajkosće na naprašowanych stronach, kotrež ma so jako wopisanje wužiwać',
	'srf-paramdesc-navigation' => 'Nawigaciske wodźenje za layout',
	'srf-gallery-navigation-previous' => 'Předchadny',
	'srf-gallery-navigation-next' => 'Přichodny',
	'srf-gallery-overlay-count' => 'Wobraz $1 z $2',
	'srf-gallery-image-url-error' => 'Wobraz njeje so namakał.',
	'srf_printername_tagcloud' => 'Tafličkowa mróčel',
	'srf_paramdesc_includesubject' => 'Hač mjena temow same maja so zapřijeć',
	'srf_paramdesc_increase' => 'Kak woznamjenjace słowa powjetšić',
	'srf_paramdesc_tagorder' => 'Porjad woznamjenjacych słowow',
	'srf_paramdesc_mincount' => 'Maksimalna ličba razow, katraž hódnota dyrbi so jewić, zo by so nalistowała',
	'srf_paramdesc_minsize' => 'Wulkosć najmjeńšich woznamjenjacych słowow w procenće',
	'srf_paramdesc_maxsize' => 'Wulkosć najwjetšich woznamjenjacych słowow w procenće',
	'srf_paramdesc_maxtags' => 'Maksimalna ličba woznamjenjacych słowow w mróčeli',
	'srf_printername_valuerank' => 'Hódnota',
	'srf_printername_array' => 'Datowe polo',
	'srf_paramdesc_pagetitle' => 'Postaja, hač titule stronow maja so jako wuslědkowe zapiski pokazać abo so wuwostajić',
	'srf_paramdesc_propsep' => 'Dźělatko mjez požadanymi kajkosćemi',
	'srf_paramdesc_manysep' => 'Dźělatko mjez wjacorymi kajkostnymi hódnotami kajkosće',
	'srf_paramdesc_recordsep' => 'Dźělatko mjez hódnotami kajkosćow datoweje sadźby',
	'srf_paramdesc_headersep' => 'Dźělatko mjez kajkostnym mjenom a kajkostnej hódnotu, jeli parameter "header" je so na "show" abo "plain" stajił',
	'srf_printername_hash' => 'Asociatiwne datowe polo (hash)',
	'srf-printername-graph' => 'Grafika',
	'srf-paramdesc-graph-relation' => 'Su temy abo mjenowe kajkosće nadrjadowane abo podrjadowane elementy?',
	'srf-paramdesc-graph-nameprop' => 'Zmóžnja kajkosć stajić, kotraž so jako tema wužiwa, město poprawneje temy',
	'srf-paramdesc-graph-nodeshape' => 'Forma kóždeho suka na grafice',
	'srf_paramdesc_graphname' => 'Titul',
	'srf_paramdesc_graphsize' => 'Wulkosć grafiki (w pikselach)',
	'srf_paramdesc_graphlegend' => 'Legendu grafiki pokazać abo nic',
	'srf_paramdesc_graphlabel' => 'Popis grafiki',
	'srf_paramdesc_rankdir' => 'Šipowy směr',
	'srf_paramdesc_graphlink' => 'Wotkaz ke grafice',
	'srf_paramdesc_graphcolor' => 'Barba grafiki',
	'srf-paramdesc-graph-wwl' => 'Limit za tekstowe łamanje (ličba znamješkow)',
	'srf_printername_datatables' => 'Datowe tabele',
	'srf-paramdesc-rowindex' => 'Rjadkowy indeks tabele',
	'srf-paramdesc-displaylength' => 'Spočatna zwobraznjenska dołhosć',
	'srf_printername_tree' => 'Štom',
	'srf_printername_ultree' => 'Štomowy napohlad (naličeny)',
	'srf_printername_oltree' => 'Štomowy napohlad (čisłowany)',
	'srf-noparentprop' => 'Nadrjadowana kajkosć njeje podała. Štom njeda so bjez podateje nadrjadowaneje kajkosće twarić.',
	'srf-paramdesc-parent' => 'Kajkosć, kotraž nadrjadowanu stronu wobsahuje',
	'srf-printername-slideshow' => 'Wobrazowe předstajenje',
	'srf-paramdesc-delay' => 'Komdźenje mjez wobrazami w sekundach',
	'srf-paramdesc-navigation-controls' => 'Nawigaciske elementy pokazać abo nic',
	'srf-paramdesc-effect' => 'Efekt, kotryž ma so wužiwać, zo by wot wobraza do wobraza přešło',
	'srf-printername-filtered' => 'Filtrowany',
	'srf-paramdesc-views' => 'Napohlady, kotrež ma we wuslědkowym wozjewjenju k dispoziciji stać.',
	'srf-printername-d3chart' => 'D3-diagram',
	'srf-printername-timeseries' => 'Diagram časowych rjadow',
	'srf-paramdesc-group' => 'Rjady zeskupjene po',
	'srf-paramdesc-zoom' => 'Skalowanje zmóžnić',
	'srf-paramdesc-datatable' => 'Datowu tabelu zmóžnić',
	'srf-timeseries-zoom-out-of-range' => 'Skalowanski wobłuk dosć datow njepłodźi',
	'srf-printername-sparkline' => 'Diagram słownych grafikow',
	'srf-printername-listwidget' => 'Lisćinowy asistent',
	'srf-paramdesc-listtype' => 'Podaj lisćinowy typ',
	'srf-paramdesc-widget' => 'K dispoziciji stejacy asistent',
	'srf-paramdesc-pageitems' => 'Elementy na stronu',
	'srf-printername-feed' => 'RSS/Atom-kanal',
	'srf-paramdesc-feedtype' => 'Kanalowy typ',
	'srf-paramdesc-feedtitle' => 'Kanalowy titul',
	'srf-paramdesc-feeddescription' => 'Kanalowe wopisanje',
	'srf-printername-eventcalendar' => 'Zarjadowanska protyka',
	'srf-paramdesc-calendarfirstday' => 'Dźeń, hdyž kóždy tydźeń so započina',
	'srf-paramdesc-calendardefaultview' => 'Wuchadny napohlad, hdyž so protyka startuje',
	'srf-paramdesc-calendarstart' => 'Spočatny datum protyki',
	'srf-paramdesc-dayview' => 'Dnjowy napohlad přez kliknjenje na dnjowe čisło zmóžnić',
	'srf-ui-eventcalendar-label-today' => 'Dźensa',
	'srf-ui-eventcalendar-label-month' => 'Měsac',
	'srf-ui-eventcalendar-label-week' => 'Tydźeń',
	'srf-ui-eventcalendar-label-day' => 'Dźeń',
	'srf-ui-eventcalendar-label-allday' => 'Cyły dźeń',
	'srf-paramdesc-datasource' => 'Podaj žórło, z kotrehož maja přistup na daty (dataja, URL atd.)',
	'srf-paramdesc-yaxislabel' => 'Wopisanje, kotrež so na y-wósce jewi',
	'srf-paramdesc-xaxislabel' => 'Wopisanje, kotrež so na x-wósce jewi',
	'srf-paramdesc-unit' => 'Jednotka',
	'srf-printername-pagewidget' => 'Asistent strony',
	'srf-printername-incoming' => 'Dochadźace kajkosće',
	'srf-paramdesc-min' => 'Minimum abo ekstremna hódnota',
	'srf-paramdesc-excludeproperty' => 'Kajkosć z wuslědka wuzamknyć',
);

/** Haitian (Kreyòl ayisyen)
 * @author Jvm
 * @author Masterches
 */
$messages['ht'] = array(
	'srf_icalendar_link' => 'iKalandrye',
);

/** Hungarian (magyar)
 * @author Dani
 * @author Glanthor Reviol
 * @author TK-999
 */
$messages['hu'] = array(
	'srf-desc' => 'További formátumok a Szemantikus MediaWiki beépített lekérdezéseihez',
	'srf-name' => 'Szemantikus eredményformátumok',
	'srf-paramdesc-height' => 'A diavetítés-widget magassága', # Fuzzy
	'srf-paramdesc-width' => 'A diavetítés-widget szélessége', # Fuzzy
	'srf-paramdesc-class' => 'Extra CSS osztály', # Fuzzy
	'srfc_previousmonth' => 'Előző hónap',
	'srfc_nextmonth' => 'Következő hónap',
	'srfc_today' => 'Ma',
	'srfc_gotomonth' => 'Ugrás hónapra',
	'srf_printername_calendar' => 'Havi naptár',
	'srf_paramdesc_calendarlang' => 'A naptár megjelenítési nyelvének kódja',
	'srf_paramdesc_calendarcolors' => 'Az egyes dátumtulajdonságok megjelenítendő színe (például "Kezdő dátum=>green,Végpont=>#09c")',
	'srf_printername_vcard' => 'vCard exportálás',
	'srf_printername_icalendar' => 'iCalendar exportálás',
	'srf_paramdesc_icalendartitle' => 'A naptárfájl címe',
	'srf_paramdesc_icalendardescription' => 'A naptárfájl leírása',
	'srf_printername_bibtex' => 'BibTeX exportálás',
	'srf_outline_novalue' => 'Nincs érték',
	'srf_printername_outline' => 'Tagolt',
	'srf_printername_sum' => 'A számok összege',
	'srf_printername_average' => 'A számok átlaga',
	'srf_printername_max' => 'Legnagyobb szám',
	'srf_printername_min' => 'Legkisebb szám',
	'srf_paramdesc_limit' => 'A lekérdezendő oldalak maximális száma',
	'srf_printername_median' => 'Számhalmaz mediánja',
	'srf-paramdesc-default' => 'A numerikus eredmények hiánya esetén megjelenítendő alapérték',
	'srf_printername_earliest' => 'Legkorábbi időpont',
	'srf_printername_latest' => 'Legkésőbbi időpont',
	'srf_printername_timeline' => 'Idővonal',
	'srf_printername_eventline' => 'Eseményvonal',
	'srf_paramdesc_timelinesize' => 'Az idővonal magassága',
	'srf-timeline-allresults' => 'A lekérdezés további eredményei.',
	'srf-timeline-nojs' => 'Engedélyezned kell a Javascript használatát az interaktív idővonal megtekintéséhez.',
	'srf_paramdesc_views' => 'Megjelenített nézetek',
	'srf_paramdesc_facets' => 'Az oldalanként megjelenítendő tulajdonságok halmaza',
	'srf_paramdesc_lens' => 'Az oldal tulajdonságait megjelenítő sablon neve',
	'srf_printername_googlebar' => 'Google oszlopdiagram',
	'srf_printername_googlepie' => 'Google tortadiagram',
	'srf_paramdesc_chartheight' => 'A diagram magassága, pixelben', # Fuzzy
	'srf_paramdesc_chartwidth' => 'A diagram szélessége, pixelben', # Fuzzy
	'srf_paramdesc_charttitle' => 'A diagram címe',
	'srf_paramdesc_barcolor' => 'Az oszlopok színe',
	'srf_paramdesc_bardirection' => 'Add meg a diagram irányát',
	'srf_paramdesc_barnumbersaxislabel' => 'A számtengely felirata',
	'srf-paramdesc-minvalue' => 'Az y tengelyen megjelenítendő legkisebb érték',
	'srf-paramdesc-pointlabels' => 'Adatpontok megjelenítése a diagramban',
	'srf-paramdesc-chartlegend' => 'Diagram jelmagyarázatának helyzete',
	'srf-paramdesc-datalabels' => 'Diagramfeliratok megjelenítése', # Fuzzy
	'srf-paramdesc-charttext' => 'A diagramot leíró szöveg',
	'srf-paramdesc-chartclass' => 'Extra CSS osztály',
	'srf-paramdesc-renderer' => 'Válasszd ki a gradikon/diagram leképezőjét',
	'srf-paramdesc-filling' => 'Egyéni töltési beállítás',
	'srf-paramdesc-theme' => 'Válassz egy rácsstílust',
	'srf-paramdesc-chartcolor' => 'Egyéni grafikonszínek hozzárendelése',
	'srf-paramdesc-colorscheme' => 'Válassz egy színsémát',
	'srf-paramdesc-valueformat' => 'Add meg az értékek formázási szabályát',
	'srf-paramdesc-highlighter' => 'Adatpont-kiemelő megjelenítése',
	'srf-paramdesc-smoothlines' => 'Simító algoritmus alkalmazása a vonaldiagramokon',
	'srf-paramdesc-stackseries' => 'Diagram megjelenítése halmozott adatsorként',
	'srf-paramdesc-seriesgroup' => 'Válaszd ki az adatsor csoportosítását',
	'srf-paramdesc-serieslabel' => 'Add meg az adatsor feliratait', # Fuzzy
	'srf_printername_gallery' => 'Galéria',
	'srf_paramdesc_perrow' => 'A képek száma soronként',
	'srf_paramdesc_widths' => 'A képek szélessége',
	'srf_paramdesc_heights' => 'A képek magassága',
	'srf_paramdesc_autocaptions' => 'Fájlnév használata képaláírásként, ha az nincs megadva',
	'srf_paramdesc_fileextensions' => 'A kiterjesztés megjelenítése a fájlnév képaláírásként történő használatakor',
	'srf_paramdesc_captionproperty' => 'A képaláírásként használandó, a lekérdezett oldalakon megtalálható szemantikai tulajdonság neve',
	'srf_paramdesc_imageproperty' => 'A használandó képekre mutató, a lekérdezett oldalakon megtalálható szemantikai tulajdonság neve. Ha be van állítva, maguk a lekérdezett oldalak nem képekként fognak megjelenni',
	'srf-paramdesc-navigation' => 'Navigáció', # Fuzzy
	'srf-gallery-navigation-previous' => 'Előző',
	'srf-gallery-navigation-next' => 'Következő',
	'srf_printername_tagcloud' => 'Címkefelhő',
	'srf_paramdesc_increase' => 'A címkék méretének növeléséhez használandó mód',
	'srf_paramdesc_tagorder' => 'A címkék sorrendje',
	'srf_paramdesc_mincount' => 'Az érték megjelenítéshez szükséges előfordulások minimuma',
	'srf_paramdesc_minsize' => 'A legkisebb címkék mérete százalékban',
	'srf_paramdesc_maxsize' => 'A legnagyobb címkék mérete százalékban',
	'srf_paramdesc_maxtags' => 'A felhőben lévő címkék maximális mennyisége',
	'srf-paramdesc-excludetags' => 'Címkenevek kizárása (;)', # Fuzzy
	'srf_printername_array' => 'Tömb',
	'srf_paramdesc_pagetitle' => 'Megjelenítse-e az oldalcímeket eredményekként, vagy hagyja ki őket?',
	'srf_paramdesc_propsep' => 'A kért tulajdonságok közötti elválasztó',
	'srf_paramdesc_headersep' => 'A tulajdonság neve és értéke közti elválasztó, ha a "headers" paraméter "show" vagy "plain" értékű',
	'srf_printername_hash' => 'Hash',
	'srf-printername-graph' => 'Grafikon',
	'srf_paramdesc_graphname' => 'Cím',
	'srf_paramdesc_graphsize' => 'Grafikon mérete (pixelben)',
	'srf_paramdesc_graphlegend' => 'Jelmagyarázat megjelenítése vagy sem',
	'srf_paramdesc_graphlabel' => 'Grafikon címkéje',
	'srf_paramdesc_rankdir' => 'Nyíl iránya',
	'srf_paramdesc_graphlink' => 'Grafikon linkje',
	'srf_paramdesc_graphcolor' => 'Grafikon színe',
	'srf-paramdesc-graph-wwl' => 'Sortörési határ (karakterszám)',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'srf-desc' => 'Formatos additional pro incorporar consultas de Semantic MediaWiki',
	'srf-name' => 'Formatos de resultatos semantic',
	'srf-paramdesc-height' => 'Altitude del presentator de diapositivas', # Fuzzy
	'srf-paramdesc-width' => 'Le latitude del presentator de diapositivas', # Fuzzy
	'srf-paramdesc-class' => 'Classe CSS additional', # Fuzzy
	'srf-error-option-mix' => 'Le optiones ($1) non es disponibile', # Fuzzy
	'srf-error-option-link-all' => 'Le option ($1) require que le parametro [link] es definite como "all"', # Fuzzy
	'srf-warn-empy-chart' => 'Il non ha datos sufficiente pro facer un graphico.', # Fuzzy
	'srfc_previousmonth' => 'Mense precedente',
	'srfc_nextmonth' => 'Mense sequente',
	'srfc_today' => 'Hodie',
	'srfc_gotomonth' => 'Ir al mense',
	'srf_printername_calendar' => 'Calendario mensual',
	'srf_paramdesc_calendarlang' => 'Le codice del lingua in le qual monstrar le calendario',
	'srf_paramdesc_calendarcolors' => 'Le color pro cata proprietate de data (exemplo: "Data de initio=>green,Data de fin=>#09c")',
	'srf_printername_vcard' => 'Exportation in vCard',
	'srf_printername_icalendar' => 'Exportation in iCalendar',
	'srf_paramdesc_icalendartitle' => 'Le titulo del file del calendario',
	'srf_paramdesc_icalendardescription' => 'Le description del file del calendario',
	'srf_printername_bibtex' => 'Exportation in BibTeX',
	'srf_outline_novalue' => 'Nulle valor',
	'srf_printername_outline' => 'Schizzo',
	'srf_paramdesc_outlineproperties' => 'Le lista de proprietates a presentar como capites de structura, separate per commas',
	'srf_printername_sum' => 'Total del numeros',
	'srf_printername_average' => 'Media del numeros',
	'srf_printername_max' => 'Numero maxime',
	'srf_printername_min' => 'Numeros minime',
	'srf_paramdesc_limit' => 'Le numero maxime de paginas a consultar',
	'srf_printername_product' => 'Producto de numeros',
	'srf_printername_median' => 'Mediana de numeros',
	'srf-paramdesc-default' => 'Valor predefinite que es monstrate si il non ha resultatos numeric',
	'srf_printername_earliest' => 'Prime hora',
	'srf_printername_latest' => 'Ultime hora',
	'srf_printername_timeline' => 'Chronologia',
	'srf_printername_eventline' => 'Chronologia de eventos',
	'srf_paramdesc_timelinebands' => 'Defini qual bandas es monstrate in le resultato.',
	'srf_paramdesc_timelineposition' => 'Defini ubi le chronologia se concentra initialmente.',
	'srf_paramdesc_timelinestart' => 'Un nomine de proprietate usate pro definir un prime puncto de tempore',
	'srf_paramdesc_timelineend' => 'Un nomine de proprietate usate pro definir un secunde puncto de tempore',
	'srf_paramdesc_timelinesize' => 'Le altitude del chronologia',
	'srf-timeline-allresults' => 'Ulterior resultatos de iste consulta.',
	'srf-timeline-nojs' => 'Es necessari activar JavaScript pro vider le chronologia interactive.',
	'srf_paramdesc_views' => 'Le vistas a monstrar',
	'srf_paramdesc_facets' => 'Le insimul de proprietates a monstrar pro cata pagina',
	'srf_paramdesc_lens' => 'Le nomine de un patrono con le qual monstrar le proprietates de pagina',
	'srf_printername_googlebar' => 'Diagramma a barras de Google',
	'srf_printername_googlepie' => 'Diagramma circular de Google',
	'srf_paramdesc_chartheight' => 'Le altitude del diagramma, in pixeles', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Le latitude del diagramma, in pixeles', # Fuzzy
	'srf_paramdesc_charttitle' => 'Le titulo del diagramma',
	'srf_paramdesc_barcolor' => 'Le color del barras',
	'srf_paramdesc_bardirection' => 'Specifica le direction de un graphico',
	'srf_paramdesc_barnumbersaxislabel' => 'Le etiquetta pro le axe de numeros',
	'srf-paramdesc-minvalue' => 'Le valor minime a monstrar sur le axe Y',
	'srf-paramdesc-pointlabels' => 'Presentar punctos de datos in graphico',
	'srf-paramdesc-chartlegend' => 'Position del legenda del gaphico',
	'srf-paramdesc-datalabels' => 'Monstrar etiquettas del graphico', # Fuzzy
	'srf-paramdesc-charttext' => 'Texto descriptive del graphico',
	'srf-paramdesc-chartclass' => 'Classe CSS additional',
	'srf-paramdesc-renderer' => 'Selige un motor de rendition de graphicos',
	'srf-paramdesc-filling' => 'Option de plenamento individual',
	'srf-paramdesc-theme' => 'Selige un apparentia pro le grillia',
	'srf-paramdesc-chartcolor' => 'Assignar individual colores al graphico',
	'srf-paramdesc-colorscheme' => 'Selige un schema de colores',
	'srf-paramdesc-valueformat' => 'Specifica le regula de formatation pro le valores',
	'srf-paramdesc-highlighter' => 'Presentar un colorator de punctos de datos',
	'srf-paramdesc-smoothlines' => 'Applicar un algorithmo de lisiamento sur graphicos a lineas',
	'srf-paramdesc-stackseries' => 'Presentar graphico como serie accumulate',
	'srf-paramdesc-seriesgroup' => 'Selige aggruppamento de serie',
	'srf-paramdesc-serieslabel' => 'Specifica etiquettas de serie', # Fuzzy
	'srf_printername_gallery' => 'Galeria',
	'srf_paramdesc_perrow' => 'Le numero de imagines per linea',
	'srf_paramdesc_widths' => 'Le latitude del imagines',
	'srf_paramdesc_heights' => 'Le altitude del imagines',
	'srf_paramdesc_autocaptions' => 'Usar le nomine de file qua legenda si nulle es fornite',
	'srf_paramdesc_fileextensions' => 'Si le nomine de file es usate como legenda, monstrar tamben le extension',
	'srf_paramdesc_captionproperty' => 'Le nomine de un proprietate semantic presente in le paginas consultate, pro esser usate como legenda',
	'srf_paramdesc_imageproperty' => 'Le nomine de un proprietate semantic presente in le paginas consultate, que indica imagines a usar. Si definite, le paginas consultate illos mesme non essera monstrate como imagines.',
	'srf-paramdesc-navigation' => 'Navigation', # Fuzzy
	'srf-gallery-navigation-previous' => 'Precedente',
	'srf-gallery-navigation-next' => 'Sequente',
	'srf_printername_tagcloud' => 'Etiquettario',
	'srf_paramdesc_includesubject' => 'Si le nomines del subjectos mesme debe esser includite',
	'srf_paramdesc_increase' => 'Como augmentar le dimension de etiquettas',
	'srf_paramdesc_tagorder' => 'Le ordine del etiquettas',
	'srf_paramdesc_mincount' => 'Le numero minime de vices que un valor debe occurrer pro esser listate',
	'srf_paramdesc_minsize' => 'Le dimension del etiquettas le plus parve, como percentage',
	'srf_paramdesc_maxsize' => 'Le dimension del etiquettas le plus grande como percentage',
	'srf_paramdesc_maxtags' => 'Le numero maxime de etiquettas in le nube',
	'srf-paramdesc-excludetags' => 'Excluder nomines de etiquettas (;)', # Fuzzy
	'srf_printername_valuerank' => 'Valor del rango',
	'srf_printername_array' => 'Array',
	'srf_paramdesc_pagetitle' => 'Si monstrar titulos de pagina como lineas de resultato o omitter los',
	'srf_paramdesc_hidegaps' => 'Si monstrar, con separatores, le valores de proprietate e de registro requestate ma indisponibile, o omitter los',
	'srf_paramdesc_arrayname' => 'Si isto es specificate e ArrayExtension es disponibile, isto creara un array con le nomine specificate (sin producer un resultato visibile)',
	'srf_paramdesc_propsep' => 'Separator inter le proprietates requestate',
	'srf_paramdesc_manysep' => 'Separator inter valores de proprietate plurivalor',
	'srf_paramdesc_recordsep' => 'Separator inter valores de proprietates de registro',
	'srf_paramdesc_headersep' => 'Separator inter nomine e valor de proprietate si "headers" es mittite a "show" o "plain"',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'Si isto es specificate e le extension HashTables es disponibile, isto creara un hash con le nomine specificate (sin producer un resultato visibile)',
	'srf-printername-graph' => 'Graphico',
	'srf-paramdesc-graph-relation' => 'Le subjectos o proprietates de nomines es genitores o infantes?',
	'srf-paramdesc-graph-nameprop' => 'Permitte definir un proprietate que essera usate como subjecto in loco del ver subjecto',
	'srf-paramdesc-graph-nodeshape' => 'Le forma de cata nodo in le graphico',
	'srf_paramdesc_graphname' => 'Titulo',
	'srf_paramdesc_graphsize' => 'Dimension del graphico (in pixels)',
	'srf_paramdesc_graphlegend' => 'Monstrar le legenda del graphico o non',
	'srf_paramdesc_graphlabel' => 'Etiquetta del graphico',
	'srf_paramdesc_rankdir' => 'Direction del sagitta',
	'srf_paramdesc_graphlink' => 'Ligamine al graphico',
	'srf_paramdesc_graphcolor' => 'Color del graphico',
	'srf-paramdesc-graph-wwl' => 'Limite pro torno de parolas (in numero de characteres)',
	'srf_printername_datatables' => 'Tabellas de datos',
	'srf-paramdesc-rowindex' => 'Indice de lineas de tabella',
	'srf-paramdesc-displaylength' => 'Longitude initial del presentation',
	'srf_printername_tree' => 'Arbore',
	'srf_printername_ultree' => 'Arbore UL',
	'srf_printername_oltree' => 'Arbore OL',
	'srf-noparentprop' => 'Nulle proprietate genitor specificate. Le arbore non pote esser construite sin specification de un proprietate genitor.',
	'srf-paramdesc-parent' => 'Le proprietate que contine le pagina genitor',
	'srf-printername-slideshow' => 'Presentation de diapositivas',
	'srf-paramdesc-delay' => 'Tempore inter diapositivas in secundas',
	'srf-paramdesc-navigation-controls' => 'Monstrar controlos de navigation o non',
	'srf-paramdesc-effect' => 'Le effecto a usar pro cambiar inter diapositivas',
	'srf-printername-filtered' => 'Filtrate',
	'srf-paramdesc-views' => 'Le vistas que debe esser disponibile in le presentation de resultatos.',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Farras
 * @author IvanLanin
 * @author Kenrick95
 */
$messages['id'] = array(
	'srf-desc' => 'Format tambahan untuk kueri Semantik MediaWiki',
	'srf-name' => 'Format Hasil Semantik',
	'srfc_previousmonth' => 'Bulan lalu',
	'srfc_nextmonth' => 'Bulan depan',
	'srfc_today' => 'Hari ini',
	'srfc_gotomonth' => 'Pergi ke bulan',
	'srf_printername_calendar' => 'Kalender bulanan',
	'srf_paramdesc_calendarlang' => 'Kode untuk bahasa yang digunakan untuk menampilkan kalender',
	'srf_printername_vcard' => 'Ekspor vCard',
	'srf_printername_icalendar' => 'Ekspor iCalendar',
	'srf_paramdesc_icalendartitle' => 'Judul berkas kalender',
	'srf_paramdesc_icalendardescription' => 'Deskripsi berkas kalender',
	'srf_printername_bibtex' => 'Ekspor BibTeX',
	'srf_outline_novalue' => 'Tanpa nilai',
	'srf_printername_outline' => 'Ikhtisar',
	'srf_paramdesc_outlineproperties' => 'Daftar properti yang akan ditampilkan sebagai kepala luar, dipisah oleh koma',
	'srf_printername_sum' => 'Jumlah angka',
	'srf_printername_average' => 'Angka rata-rata',
	'srf_printername_max' => 'Angka maksimum',
	'srf_printername_min' => 'Angka minimum',
	'srf_paramdesc_limit' => 'Jumlah maksimal halaman yang dicari',
	'srf_printername_timeline' => 'Garis waktu',
	'srf_printername_eventline' => 'Garis kejadian',
	'srf_paramdesc_timelinebands' => 'Menetapkan tanda yang mana yang ditampilkan di hasil.',
	'srf_paramdesc_timelineposition' => 'Menetapkan tempat fokus awal garis waktu.',
	'srf_paramdesc_timelinestart' => 'Nama properti untuk menetapkan titik waktu pertama',
	'srf_paramdesc_timelineend' => 'Nama properti untuk menetapkan titik waktu kedua',
	'srf_paramdesc_timelinesize' => 'Tinggi garis waktu',
	'srf_paramdesc_views' => 'Pandangan yang akan ditampilkan',
	'srf_paramdesc_facets' => 'Rangkaian properti untuk ditampilkan di setiap halaman',
	'srf_paramdesc_lens' => 'Nama templat untuk menampilkan properti halaman',
	'srf_printername_googlebar' => 'Grafik batang Google',
	'srf_printername_googlepie' => 'Grafik pai Google',
	'srf_paramdesc_chartheight' => 'Tinggi grafik, dalam piksel', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Lebar grafik, dalam piksel', # Fuzzy
	'srf_paramdesc_charttitle' => 'Judul grafik',
	'srf_paramdesc_barcolor' => 'Warna batang',
	'srf_paramdesc_bardirection' => 'Arah grafik batang', # Fuzzy
	'srf_paramdesc_barnumbersaxislabel' => 'Label untuk poros nomor',
	'srf_printername_gallery' => 'Galeri',
	'srf_paramdesc_perrow' => 'Jumlah gambar per baris',
	'srf_paramdesc_widths' => 'Lebar gambar',
	'srf_paramdesc_heights' => 'Tinggi gambar',
	'srf_paramdesc_autocaptions' => 'Gunakan nama berkas sebagai judul jika judul tidak diberikan',
	'srf_printername_tagcloud' => 'Awan tag',
	'srf_paramdesc_includesubject' => 'Jika nama subjek sendiri harus dimasukkan',
	'srf_paramdesc_increase' => 'Bagaimana meningkatkan ukuran tag',
	'srf_paramdesc_tagorder' => 'Urutan tag',
	'srf_paramdesc_mincount' => 'Jumlah minimum kemunculan suatu nilai untuk dapat didaftarkan',
	'srf_paramdesc_minsize' => 'Ukuran tag terkecil dalam persen',
	'srf_paramdesc_maxsize' => 'Ukuran tag terbesar dalam persen',
	'srf_paramdesc_maxtags' => 'Jumlah maksimum tag di awan',
	'srf_printername_array' => 'Larik',
	'srf_paramdesc_pagetitle' => 'Tampilkan atau sembunyikan judul halaman sebagai entri hasil', # Fuzzy
	'srf_paramdesc_hidegaps' => 'Tampilkan atau sembunyikan nilai properti dan rekaman yang kosong, dipisahkan dengan pemisah', # Fuzzy
	'srf_paramdesc_arrayname' => 'Jika diberikan dan ArrayExtension tersedia, parameter ini akan membuat larik dengan nama yang diberikan', # Fuzzy
	'srf_paramdesc_propsep' => 'Pemisah antara properti yang diminta',
	'srf_paramdesc_manysep' => 'Pemisah antara banyak properti bernilai', # Fuzzy
	'srf_paramdesc_recordsep' => 'Pemisah antara nilai properti rekaman',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'Jika diberikan dan ekstensi HashTables tersedia, parameter ini akan membuat hash dengan nama yang diberikan', # Fuzzy
	'srf-printername-graph' => 'Grafik',
	'srf-paramdesc-graph-relation' => 'Apakah subjek atau properti nama merupakan induk atau turunan?',
	'srf-paramdesc-graph-nameprop' => 'Memungkinkan pengaturan properti yang akan digunakan sebagai subjek, alih-alih subjek yang sebenarnya',
	'srf-paramdesc-graph-nodeshape' => 'Bentuk masing-masing nodus (node) pada grafik',
	'srf_paramdesc_graphname' => 'Judul',
	'srf_paramdesc_graphsize' => 'Besar grafik (dalam px)',
	'srf_paramdesc_graphlegend' => 'Tampilkan legenda grafik',
	'srf_paramdesc_graphlabel' => 'Label grafik',
	'srf_paramdesc_rankdir' => 'Arah panah',
	'srf_paramdesc_graphlink' => 'Tautan grafik',
	'srf_paramdesc_graphcolor' => 'Warna grafik',
	'srf-paramdesc-graph-wwl' => 'Batas pemenggalan kata (dalam jumlah karakter)',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'srfc_gotomonth' => 'Ga na önwa',
	'srf_printername_timeline' => 'Ahiriogẹ',
	'srf_printername_eventline' => 'Ahiriomémé',
	'srf_printername_googlebar' => 'Ngwa nkuzie Google',
	'srf_printername_googlepie' => 'Orịrị nkuzie Google',
	'srf_paramdesc_chartheight' => 'Ógólógó ihü nkuzie, na ogụgụ pixel', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Íbụ ihü nkuzie, na ogụgụ pixel', # Fuzzy
);

/** Italian (italiano)
 * @author Beta16
 * @author Civvì
 * @author Darth Kule
 * @author F. Cosoleto
 */
$messages['it'] = array(
	'srf-desc' => 'Formati addizionali per le query di Semantic Mediawiki',
	'srf-name' => 'Formati di risultato semantici',
	'srf-module-loading' => 'Caricamento in corso...',
	'srf-paramdesc-layout' => 'Layout disponibili',
	'srf-paramdesc-height' => 'Altezza',
	'srf-paramdesc-width' => 'Larghezza',
	'srf-paramdesc-class' => "Specificare un'ulteriore classe di foglio di stile CSS",
	'srf-module-nomatch' => 'Nessun risultato trovato',
	'srf-navigation-previous' => 'Precedente',
	'srf-ui-navigation-prev' => 'Prec',
	'srf-ui-navigation-next' => 'Successivo',
	'srf-ui-tooltip-title-options' => 'Opzioni',
	'srf-error-option-mix' => 'Opzione ($1) non disponibile',
	'srf-error-option-link-all' => 'L\'opzione ($1) richiede che il parametro "link" sia impostato a "all"',
	'srf-error-missing-layout' => 'Layout mancante',
	'srfc_previousmonth' => 'Mese precedente',
	'srfc_nextmonth' => 'Mese successivo',
	'srfc_today' => 'Oggi',
	'srfc_gotomonth' => 'Vai al mese',
	'srf_printername_calendar' => 'Calendario mensile',
	'srf_paramdesc_calendarlang' => 'Il codice per la lingua in cui visualizzare il calendario',
	'srf_printername_vcard' => 'esportazione vCard',
	'srf_printername_icalendar' => 'esportazione iCalendar',
	'srf_paramdesc_icalendartitle' => 'Il titolo del file di calendario',
	'srf_paramdesc_icalendardescription' => 'La descrizione del file di calendario',
	'srf_printername_bibtex' => 'esportazione BibTeX',
	'srf_outline_novalue' => 'Nessun valore',
	'srf_printername_outline' => 'Contorno',
	'srf_paramdesc_outlineproperties' => "L'elenco delle proprietà, separate da virgola, da visualizzare come intestazioni di contorno",
	'srf_printername_sum' => 'Somma di numeri',
	'srf_printername_average' => 'Media dei numeri',
	'srf_printername_max' => 'Numero massimo',
	'srf_printername_min' => 'Numero minimo',
	'srf_paramdesc_limit' => 'Il numero massimo di pagine per eseguire una query',
	'srf_printername_product' => 'Prodotto di numeri',
	'srf_printername_median' => 'Mediana di numeri',
	'srf_printername_timeline' => 'Linea del tempo (timeline)',
	'srf_printername_eventline' => 'Linea degli eventi',
	'srf_paramdesc_timelinebands' => 'Definisce quali bande temporali vengono visualizzati nel risultato',
	'srf_paramdesc_timelineposition' => 'Definisce in quale punto inizia la linea del tempo',
	'srf_paramdesc_timelinestart' => 'Il nome della proprietà usata per definire il primo punto temporale',
	'srf_paramdesc_timelineend' => 'Il nome della proprietà usata per definire il secondo punto temporale',
	'srf_paramdesc_timelinesize' => "L'altezza della linea temporale",
	'srf_paramdesc_views' => 'Le visualizzazioni da mostrare',
	'srf_paramdesc_facets' => "L'insieme di proprietà da visualizzare per ogni pagina",
	'srf_paramdesc_lens' => 'Il nome di un template con cui mostrare le proprietà della pagina',
	'srf_printername_googlebar' => 'Google bar chart',
	'srf_printername_googlepie' => 'Google grafico a torta',
	'srf_paramdesc_chartheight' => "Specificare l'altezza (in pixel) della tabella o del grafico",
	'srf_paramdesc_chartwidth' => 'Specificare la larghezza (in pixel) della tabella o del grafico',
	'srf_paramdesc_charttitle' => 'Il titolo del grafico',
	'srf_paramdesc_barcolor' => 'Specificare i colori del grafico',
	'srf_paramdesc_bardirection' => 'Specificare la direzione del grafico',
	'srf-paramdesc-direction' => 'Specificare la direzione della tabella o del grafico',
	'srf_paramdesc_barnumbersaxislabel' => "L'etichetta per l'asse dei numeri",
	'srf-paramdesc-labelaxislabel' => "L'etichetta per l'asse delle etichetta",
	'srf-paramdesc-minvalue' => "Il valore minimo da mostrare sull'asse y",
	'srf-paramdesc-chartclass' => 'Classe CSS aggiuntiva',
	'srf-paramdesc-infotext' => 'Mostra informazioni aggiuntive sulla corrispondente scheda di informazioni',
	'srf-ui-gridview-label-item' => 'Elemento dati',
	'srf-ui-gridview-label-value' => 'Valore dati',
	'srf-ui-gridview-label-series' => 'Serie di dati',
	'srf-ui-gridview-label-chart-tab' => 'Grafico',
	'srf-ui-gridview-label-data-tab' => 'Dati',
	'srf-ui-gridview-label-info-tab' => 'Informazioni',
	'srf_printername_gallery' => 'Galleria',
	'srf_paramdesc_perrow' => 'Il numero di immagini per riga',
	'srf_paramdesc_widths' => 'La larghezza delle immagini',
	'srf_paramdesc_heights' => "L'altezza delle immagini",
	'srf-gallery-navigation-previous' => 'Precedente',
	'srf-gallery-navigation-next' => 'Successivo',
	'srf-gallery-overlay-count' => 'Immagine $1 di $2',
	'srf-gallery-image-url-error' => "L'immagine non è stato trovata.",
	'srf_printername_hash' => 'Hash',
	'srf-printername-graph' => 'Grafico',
	'srf_paramdesc_graphname' => 'Titolo',
	'srf_paramdesc_graphsize' => 'Dimensione del grafico (in px)',
	'srf_paramdesc_graphlegend' => 'Mostra la legenda del grafico o no',
	'srf_paramdesc_graphlabel' => 'Etichetta del grafico',
	'srf-paramdesc-zoom' => 'Abilita zoom',
	'srf-paramdesc-listtype' => 'Specificare il tipo di elenco',
	'srf-paramdesc-pageitems' => 'Elementi per pagina',
	'srf-printername-eventcalendar' => 'Calendario degli eventi',
	'srf-paramdesc-calendarfirstday' => 'Il giorno in cui inizia ogni settimana',
	'srf-ui-eventcalendar-label-today' => 'Oggi',
	'srf-ui-eventcalendar-label-month' => 'Mese',
	'srf-ui-eventcalendar-label-week' => 'Settimana',
	'srf-ui-eventcalendar-label-day' => 'Giorno',
	'srf-paramdesc-yaxislabel' => "Descrizione visualizzata sull'asse y",
	'srf-paramdesc-xaxislabel' => "Descrizione visualizzata sull'asse x",
);

/** Japanese (日本語)
 * @author Fryed-peach
 * @author Hosiryuhosi
 * @author JtFuruhata
 * @author Naohiro19
 * @author Schu
 * @author Shirayuki
 * @author Whym
 * @author 青子守歌
 */
$messages['ja'] = array(
	'srf-desc' => 'Semantic MediaWiki のインラインクエリーのための追加的な形式',
	'srf-name' => '意味的結果の形式',
	'prefs-srf' => '意味的結果の形式',
	'srf-module-loading' => '読み込み中...',
	'srf-paramdesc-layout' => '利用できるレイアウト',
	'srf-paramdesc-height' => '高さ',
	'srf-paramdesc-width' => '幅',
	'srf-paramdesc-class' => '追加的な CSS クラスを指定',
	'srf-module-nomatch' => '該当するものはありません',
	'srf-paramdesc-charttype' => '利用できるグラフの種類',
	'srf-navigation-previous' => '前へ',
	'srf-ui-navigation-prev' => '前へ',
	'srf-ui-navigation-next' => '次へ',
	'srf-ui-common-label-source' => 'ソース',
	'srf-ui-common-label-datasource' => 'データ ソース',
	'srf-ui-tooltip-title-options' => 'オプション',
	'srf-ui-tooltip-title-scope' => 'スコープ',
	'srf-error-option-mix' => 'オプション ($1) は利用できません',
	'srf-error-option-link-all' => 'オプション ($1) を使用するには、パラメーター「link」を「all」に設定する必要があります',
	'srf-error-missing-layout' => 'レイアウトがありません',
	'srf-warn-empy-chart' => 'データが足りないため、グラフは空です',
	'srfc_previousmonth' => '前の月',
	'srfc_nextmonth' => '次の月',
	'srfc_today' => '今日',
	'srfc_gotomonth' => 'この月を表示',
	'srf_printername_calendar' => '月毎のカレンダー',
	'srf_paramdesc_calendarlang' => 'カレンダーを表示するための言語コード',
	'srf_paramdesc_calendarcolors' => '各日付プロパティを表示する色 (例: "開始日=>green,終了日=>#09c")',
	'srf_printername_vcard' => 'vCard 形式で書き出し',
	'srf_printername_icalendar' => 'iCalender 形式で書き出し',
	'srf_paramdesc_icalendartitle' => 'カレンダーファイルのタイトル',
	'srf_paramdesc_icalendardescription' => 'カレンダーファイルの説明',
	'srf_printername_bibtex' => 'BibTeX 形式で書き出し',
	'srf_outline_novalue' => '値なし',
	'srf_printername_outline' => 'アウトライン',
	'srf_paramdesc_outlineproperties' => 'アウトラインの見出しとして表示されるプロパティのリスト（カンマ区切り）',
	'srf_printername_sum' => '数の合計',
	'srf_printername_average' => '数の平均',
	'srf_printername_max' => '最大数',
	'srf_printername_min' => '最小数',
	'srf_paramdesc_limit' => '問い合わせするページの最大数',
	'srf_printername_product' => '数値の積',
	'srf_printername_median' => '数値の平均',
	'srf-paramdesc-default' => '数値的データがない場合に表示する既定値',
	'srf_printername_earliest' => '最も古い時刻',
	'srf_printername_latest' => '最も新しい時刻',
	'srf_printername_timeline' => '時系列',
	'srf_printername_eventline' => '事象系列',
	'srf_paramdesc_timelinebands' => '出力結果にどの時間単位を表示するか定義する。',
	'srf_paramdesc_timelineposition' => '初期状態でタイムラインがどこにフォーカスしているか定義する。',
	'srf_paramdesc_timelinestart' => '最初の時点を定義するプロパティの名前',
	'srf_paramdesc_timelineend' => '2番目の時点を定義するプロパティの名前',
	'srf_paramdesc_timelinesize' => 'タイムラインの高さ',
	'srf-timeline-nojs' => '対話的なタイムラインを表示するために JavaScript を有効にする必要があります。',
	'srf_paramdesc_views' => '表示されるビュー',
	'srf_paramdesc_facets' => '各ページで表示するプロパティの集合',
	'srf_paramdesc_lens' => 'ページのプロパティと共に表示するテンプレートの名前',
	'srf_printername_googlebar' => 'Google 棒グラフ',
	'srf_printername_googlepie' => 'Google 円グラフ',
	'srf-printername-jqplotchart' => 'jqPlot チャート',
	'srf-printername-jqplotseries' => 'jqPlot 系列',
	'srf_paramdesc_chartheight' => 'グラフの高さを指定 (ピクセル)',
	'srf_paramdesc_chartwidth' => 'グラフの幅を指定 (ピクセルまたは %)',
	'srf_paramdesc_charttitle' => '図のタイトル',
	'srf_paramdesc_barcolor' => 'グラフの色を指定',
	'srf_paramdesc_bardirection' => 'グラフの方向を指定',
	'srf-paramdesc-direction' => 'グラフの方向を指定',
	'srf_paramdesc_barnumbersaxislabel' => '数値軸のラベル',
	'srf-paramdesc-labelaxislabel' => 'ラベル軸のラベル',
	'srf-paramdesc-ticklabels' => '目盛ラベルの表示を有効化',
	'srf-paramdesc-minvalue' => 'Y 軸に表示する最大値',
	'srf-paramdesc-chartlegend' => 'グラフの凡例の位置',
	'srf-paramdesc-datalabels' => 'グラフのデータ ラベル',
	'srf-paramdesc-chartclass' => '追加的な CSS クラス',
	'srf-paramdesc-theme' => 'グリッドのテーマを選択',
	'srf-paramdesc-colorscheme' => '色スキームを選択',
	'srf-paramdesc-valueformat' => '値の整形規則を指定',
	'srf-paramdesc-smoothlines' => '折れ線グラフに平滑化アルゴリズムを適用',
	'srf-paramdesc-stackseries' => 'グラフを積み重ね系列として表示',
	'srf-paramdesc-seriesgroup' => '系列のグループ化を選択',
	'srf-paramdesc-serieslabel' => '系列ラベルを指定',
	'srf-paramdesc-grouplabel' => 'グループ ラベルを指定',
	'srf-paramdesc-chartcursor' => 'グラフ カーソルの表示オプション',
	'srf-paramdesc-trendline' => 'グラフとその近似曲線の同時表示を有効化',
	'srf-paramdesc-infotext' => '対応する情報タブで追加的な情報を表示',
	'srf-ui-gridview-label-item' => 'データ項目',
	'srf-ui-gridview-label-value' => 'データの値',
	'srf-ui-gridview-label-series' => 'データ系列',
	'srf-ui-gridview-label-chart-tab' => 'グラフ',
	'srf-ui-gridview-label-data-tab' => 'データ',
	'srf-ui-gridview-label-info-tab' => '情報',
	'srf_printername_gallery' => 'ギャラリー',
	'srf_paramdesc_perrow' => '行あたりの画像の量',
	'srf_paramdesc_widths' => '画像の幅',
	'srf_paramdesc_heights' => '画像の高さ',
	'srf_paramdesc_autocaptions' => 'キャプションとして何も指定しなかった場合はファイル名を使用',
	'srf_paramdesc_fileextensions' => 'キャプションにファイル名を使用する際にそのファイルの拡張子も表示',
	'srf-paramdesc-redirects' => 'リダイレクト先を含むクエリー ページに表示する意味的プロパティの名前',
	'srf-paramdesc-overlay' => '画像オーバーレイを有効化',
	'srf-gallery-navigation-previous' => '前へ',
	'srf-gallery-navigation-next' => '次へ',
	'srf-gallery-overlay-count' => '画像 $1 / $2',
	'srf-gallery-image-url-error' => '画像が見つかりません。',
	'srf_printername_tagcloud' => 'タグ クラウド',
	'srf_paramdesc_increase' => 'タグのサイズの増やし方',
	'srf_paramdesc_tagorder' => 'タグの並び順',
	'srf_paramdesc_minsize' => '最小のタグのサイズ (%)',
	'srf_paramdesc_maxsize' => '最大のタグのサイズ (%)',
	'srf_paramdesc_maxtags' => 'クラウド内のタグの最大数',
	'srf-paramdesc-excludetags' => '除外するタグ (; で区切る)',
	'srf_printername_array' => '配列',
	'srf_printername_hash' => 'ハッシュ',
	'srf-printername-graph' => 'グラフ',
	'srf-paramdesc-graph-nodeshape' => 'グラフの各ノードの形状',
	'srf_paramdesc_graphname' => 'タイトル',
	'srf_paramdesc_graphsize' => 'グラフ サイズ (ピクセル単位)',
	'srf_paramdesc_graphlegend' => '反例の表示/非表示',
	'srf_paramdesc_graphlabel' => 'グラフ ラベル',
	'srf_paramdesc_rankdir' => '矢印の方向',
	'srf_paramdesc_graphlink' => 'グラフ リンク',
	'srf_paramdesc_graphcolor' => 'グラフの色',
	'srf_printername_datatables' => 'データテーブル',
	'srf-paramdesc-displaylength' => '表示する長さの初期値',
	'srf-paramdesc-parent' => '親ページを含むプロパティ',
	'srf-printername-slideshow' => 'スライドショー',
	'srf-paramdesc-delay' => 'スライド間の遅延 (秒)',
	'srf-paramdesc-navigation-controls' => 'ナビゲーション コントロールを表示するかどうか',
	'srf-paramdesc-filtered-list-type' => '一覧の種類。指定できる値: list、ul、ol。既定値: list。',
	'srf-paramdesc-filtered-list-template' => '一覧の項目の整形に使用するテンプレート。',
	'srf-paramdesc-filtered-list-named-args' => 'テンプレートに渡した引数に名前を付ける。',
	'srf-paramdesc-filtered-list-introtemplate' => '問い合わせ結果がある場合、その前に表示するテンプレートの名前。',
	'srf-paramdesc-filtered-list-outrotemplate' => '問い合わせ結果がある場合、その後に表示するテンプレートの名前。',
	'srf-paramdesc-filtered-calendar-title-template' => 'カレンダーでイベントのタイトルの整形に使用するテンプレート',
	'srf-filtered-selectorlabel-list' => '一覧',
	'srf-filtered-selectorlabel-calendar' => 'カレンダー',
	'srf-filtered-firstdayofweek' => '0',
	'srf-printername-d3chart' => 'D3 チャート',
	'srf-printername-timeseries' => '時系列グラフ',
	'srf-paramdesc-group' => '系列のグループ化',
	'srf-paramdesc-zoom' => '拡大/縮小を有効にする',
	'srf-paramdesc-datatable' => 'データテーブルを有効にする',
	'srf-printername-sparkline' => '折れ線グラフ',
	'srf-printername-listwidget' => '一覧ウィジェット',
	'srf-paramdesc-listtype' => '一覧の種類を指定',
	'srf-paramdesc-widget' => '利用できるウィジェット',
	'srf-paramdesc-pageitems' => 'ページあたりの項目数',
	'srf-printername-eventcalendar' => 'イベント カレンダー',
	'srf-paramdesc-calendarfirstday' => '週の開始日の曜日',
	'srf-paramdesc-calendardefaultview' => 'カレンダー読み込み時の初期の表示',
	'srf-paramdesc-dayview' => '日付をクリックすると日表示になるようにする',
	'srf-ui-eventcalendar-label-today' => '今日',
	'srf-ui-eventcalendar-label-month' => '月',
	'srf-ui-eventcalendar-label-week' => '週',
	'srf-ui-eventcalendar-label-day' => '日',
	'srf-ui-eventcalendar-label-allday' => '全日',
	'srf-ui-eventcalendar-format-time' => 'H(:mm)',
	'srf-ui-eventcalendar-format-time-agenda' => 'H:mm( - H:mm)',
	'srf-ui-eventcalendar-format-axis' => 'H:mm',
	'srf-ui-eventcalendar-format-title-month' => 'yyyy年M月',
	'srf-ui-eventcalendar-format-title-week' => "d [ yyyy]{ '&#8212;'[ MMM] yyyy年M月d日}",
	'srf-ui-eventcalendar-format-title-day' => 'yyyy年M月d日(ddd)',
	'srf-ui-eventcalendar-format-column-month' => 'ddd',
	'srf-ui-eventcalendar-format-column-week' => 'M月d日(ddd)',
	'srf-ui-eventcalendar-format-column-day' => 'M月d日(ddd)',
	'srf-printername-dygraphs' => 'Digraph チャート',
	'srf-paramdesc-yaxislabel' => 'Y 軸に表示する説明',
	'srf-paramdesc-xaxislabel' => 'X 軸に表示する説明',
	'srf-paramdesc-unit' => 'ユニット',
	'srf-printername-pagewidget' => 'ページウィジェット',
	'srf-paramdesc-min' => 'しきい値の最小値',
	'srf-paramdesc-excludeproperty' => '結果の集合からプロパティを除外',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'srfc_previousmonth' => 'Sasi sadurungé',
	'srfc_nextmonth' => 'Sasi sabanjuré',
	'srfc_today' => 'Dina iki',
	'srfc_gotomonth' => 'Tumuju menyang sasi',
	'srf_icalendar_link' => 'iKalèndher',
);

/** Georgian (ქართული)
 * @author David1010
 */
$messages['ka'] = array(
	'srf-module-loading' => 'იტვირთება…',
	'srf-paramdesc-height' => 'სიმაღლე',
	'srf-paramdesc-width' => 'სიგანე',
	'srfc_previousmonth' => 'წინა თვე',
	'srfc_nextmonth' => 'შემდეგი თვე',
	'srfc_today' => 'დღეს',
	'srfc_gotomonth' => 'თვეზე გადასვლა',
	'srf_printername_calendar' => 'ყოველთვიური კალენდარი',
	'srf_printername_max' => 'მაქსიმალური რაოდენობა',
	'srf_printername_min' => 'მინიმალური რაოდენობა',
	'srf-ui-gridview-label-data-tab' => 'მონაცემები',
	'srf-ui-gridview-label-info-tab' => 'ინფორმაცია',
	'srf_printername_gallery' => 'გალერეა',
	'srf-gallery-navigation-previous' => 'წინა',
	'srf-gallery-navigation-next' => 'შემდეგი',
	'srf-printername-graph' => 'გრაფიკი',
	'srf_paramdesc_graphname' => 'სათაური',
	'srf_paramdesc_graphsize' => 'გრაფიკის ზომა (პიქსელებში)',
	'srf_paramdesc_graphlink' => 'გრაფიკის ბმული',
	'srf_paramdesc_graphcolor' => 'გრაფიკის ფერი',
	'srf_printername_tree' => 'ხე',
	'srf-printername-slideshow' => 'სლაიდშოუ',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Lovekhmer
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'srfc_previousmonth' => 'ខែមុន',
	'srfc_nextmonth' => 'ខែបន្ទាប់',
	'srfc_today' => 'ថ្ងៃនេះ',
	'srfc_gotomonth' => 'ទៅកាន់ខែ',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'srf-desc' => 'Zohsäzlejje Fommaate för dem „Semantesch MediaWiki“ sing Froore em Täx vun Sigge.',
	'srf-name' => 'Fomaate för wat bei Semantesch Froore eruß kohm',
	'srfc_previousmonth' => 'Jangk nohm Moohnd dovör',
	'srfc_nextmonth' => 'Jangk nohm näkßte Moohnd',
	'srfc_today' => 'Hück',
	'srfc_gotomonth' => 'Jangk noh däm Moohnd',
	'srf_printername_calendar' => 'Dä Kaländer fum Mohnd',
	'srf_vcard_link' => '<i lang="en">vCard</i>',
	'srf_printername_vcard' => 'Expoot em <i lang="en">vCard</i>-Fommaat',
	'srf_icalendar_link' => '<i lang="en">iCalendar</i>',
	'srf_printername_icalendar' => 'Expoot em Fommaat vun <i lang="en">iCalendar</i>',
	'srf_paramdesc_icalendartitle' => 'Dä Tittel vun dä Datteij met däm Kalländer',
	'srf_paramdesc_icalendardescription' => 'Wi de Datteij met däm Kalländer beschrevve es',
	'srf_printername_bibtex' => 'Expoot em <i lang="en">BibTeX</i>-Fommaat',
	'srf_outline_novalue' => 'Keine Wäät',
	'srf_printername_outline' => 'Övverblecks_Leß',
	'srf_paramdesc_outlineproperties' => 'De Leß met Eijeschaffte, di als Övverschreffte för en Jlidderung aanjezeijsch wääde sulle, met Kommas dozwesche',
	'srf_printername_sum' => 'De Zahle zosammejetrocke',
	'srf_printername_average' => 'Der Schnett vun dä Zahle',
	'srf_printername_max' => 'De kleinßte Nommer',
	'srf_printername_min' => 'De jüüßte Nommer',
	'srf_paramdesc_limit' => 'De jrüüßte Zahl Sigge för dren ze söhke', # Fuzzy
	'srf_printername_timeline' => 'De Reih noh de Zigk',
	'srf_printername_eventline' => 'De Reih noh dämm, wat vörjekumme es',
	'srf_paramdesc_timelinebands' => 'Jitt aan, wat för en Zickraster aanjezeijsch wääde sulle.',
	'srf_paramdesc_timelineposition' => 'Läät faß, woh de Zicklinnesch et eetz drop ußjereschdt es.',
	'srf_paramdesc_timelinestart' => 'Ene Eijeschaff iere Name, di jebruch weed, öm ene eezte Zickpungk faßzelääje',
	'srf_paramdesc_timelineend' => 'Ene Eijeschaff iere Name, di jebruch weed, öm ene zweijte Zickpungk faßzelääje',
	'srf_paramdesc_timelinesize' => 'De Hühde vun dä Zick-Linnesch',
	'srf_paramdesc_views' => 'De Aansėschte för aanzezeije',
	'srf_paramdesc_facets' => 'De Eijeschaffte, di för jeede Sigg annjezeijsch wääde sulle',
	'srf_paramdesc_lens' => 'Ene Schabloon iere Name, woh mer de Eijeschaffte vun ene Sigg aanzeije lohße kann',
	'srf_printername_googlebar' => 'E Balleke-Dijajramm vun <i lang="en">Google</i>',
	'srf_printername_googlepie' => 'E Kreijß-Dijajramm vun <i lang="en">Google</i>',
	'srf_paramdesc_chartheight' => 'Dämm Dijajramm sing Hühde en Pixelle', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Dämm Dijajramm sing Breedt en Pixelle', # Fuzzy
	'srf_printername_ultree' => 'ene Boum met Leßte met Pongkte',
	'srf_printername_oltree' => 'ene Boum met Leßte met Nommere',
);

/** Kurdish (Latin script) (Kurdî (latînî)‎)
 * @author George Animal
 */
$messages['ku-latn'] = array(
	'srfc_today' => 'Îro',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'srf-name' => 'Formate vu semantesche Resultater',
	'srf-module-loading' => 'Lueden...',
	'srf-paramdesc-height' => 'Héicht',
	'srf-paramdesc-width' => 'Breet',
	'srf-navigation-previous' => 'Vireg',
	'srf-ui-navigation-prev' => 'Vireg',
	'srf-ui-navigation-next' => 'Nächst',
	'srf-ui-common-label-source' => 'Quell',
	'srf-ui-tooltip-title-options' => 'Optiounen',
	'srf-error-option-mix' => 'Optioun ($1) ass net disponibel',
	'srf-error-missing-layout' => 'De Layout feelt',
	'srfc_previousmonth' => 'Virege Mount',
	'srfc_nextmonth' => 'Nächste Mount',
	'srfc_today' => 'Haut',
	'srfc_gotomonth' => 'Géi op de Mount',
	'srf_printername_calendar' => 'Monatleche Kalenner',
	'srf_paramdesc_calendarlang' => 'De Code vun der Sprooch an där de Kalenner gewise gëtt',
	'srf_printername_vcard' => 'Export als vCard',
	'srf_icalendar_link' => 'iKalenner',
	'srf_printername_icalendar' => 'Export als iCalendar',
	'srf_paramdesc_icalendartitle' => 'Den Titel vum Kalenner-Fichier',
	'srf_paramdesc_icalendardescription' => "D'Beschreiwung vum Kalenner-Fichier",
	'srf_printername_bibtex' => 'Export als BibTeX',
	'srf_outline_novalue' => 'Kee Wäert',
	'srf_printername_sum' => 'Total vun den Zuelen',
	'srf_printername_average' => 'Duerchschnëtt vun den Zuelen',
	'srf_printername_max' => 'Maximal Zuel',
	'srf_printername_min' => 'Minimal Zuel',
	'srf_paramdesc_limit' => "D'Maximal Zuel vu Säite fir ofzefroen",
	'srf_printername_earliest' => 'Éischte Kéier',
	'srf_printername_latest' => 'Leschte Kéier',
	'srf_printername_timeline' => 'Chronologie',
	'srf_printername_eventline' => 'Chronologie vun den Evenementer',
	'srf_paramdesc_timelinesize' => "D'Héicht vun der Zäitläischt",
	'srf-timeline-allresults' => 'Méi Resultater fir dës Ufro.',
	'srf-timeline-nojs' => 'JavaScript muss aktivéiert si fir déi interaktiv Zäitläischt benotzen ze kënnen.',
	'srf_paramdesc_views' => 'Déi Usiichten déi gewise solle ginn',
	'srf_paramdesc_lens' => 'Den Numm vun enger Schabloun mat där Säiteneegeschafte gewise  ginn',
	'srf_printername_googlebar' => 'Google-Sailen-Diagramm',
	'srf_printername_googlepie' => 'Google-Taarten-Diagramm',
	'srf_paramdesc_chartheight' => "Gitt d'Héicht (a Pixel) vun der Grafik un",
	'srf_paramdesc_chartwidth' => "Gitt d'Breet (a Pixel) vun der Grafik un",
	'srf_paramdesc_charttitle' => 'Den Titel vum Diagramm',
	'srf_paramdesc_barcolor' => "D'Faarf vun de Balken",
	'srf_paramdesc_bardirection' => "Spezifizéiert d'Ausriichtung vum Balken-Diagramm",
	'srf_paramdesc_barnumbersaxislabel' => "D'Etiquette fir d'Achs vun den Zuelen",
	'srf-paramdesc-minvalue' => 'De klengste Wäert,deen op der Y-Achs gewise soll ginn',
	'srf-paramdesc-charttext' => 'Textbeschreiwung vum Diagramm',
	'srf-ui-gridview-label-chart-tab' => 'Diagramm',
	'srf-ui-gridview-label-data-tab' => 'Donnéeën',
	'srf-ui-gridview-label-info-tab' => 'Informatioun',
	'srf_printername_gallery' => 'Galerie',
	'srf_paramdesc_perrow' => "D'Zuel vu Biller pro Rei",
	'srf_paramdesc_widths' => "D'Breet vun de Biller",
	'srf_paramdesc_heights' => "D'Héicht vun de Biller",
	'srf_paramdesc_autocaptions' => 'Den NUmm vum Fichier als Beschreiwung benotzen, wa keng ugi gouf',
	'srf-gallery-navigation-previous' => 'Vireg',
	'srf-gallery-navigation-next' => 'Nächst',
	'srf-gallery-overlay-count' => 'Bild $1 vu(n) $2',
	'srf-gallery-image-url-error' => "D'Bild gouf net fonnt.",
	'srf_printername_array' => 'Tabell',
	'srf-printername-graph' => 'Grafik',
	'srf_paramdesc_graphname' => 'Titel',
	'srf_paramdesc_graphsize' => 'Gréisst vun der Grafik (a Pixel)',
	'srf_paramdesc_graphlegend' => "D'Erklärung (Legend) vum Grafik weisen oder net",
	'srf_paramdesc_graphlabel' => 'Etiquette vun der Grafik',
	'srf_paramdesc_rankdir' => 'Richtung vum Feil',
	'srf_paramdesc_graphlink' => 'Link op de Grafik',
	'srf_paramdesc_graphcolor' => 'Faarf vun der Grafik',
	'srf_printername_tree' => 'Bam',
	'srf-printername-slideshow' => 'SlideShow',
	'srf-paramdesc-delay' => 'Den zäitlechen Ofstand tëschent de Sliden a Sekonnen',
	'srf-paramdesc-effect' => 'Den Iwwergang de vun engem Slide op dee nächste slide benotzt gëtt',
	'srf-printername-filtered' => 'Gefiltert',
	'srf-filtered-selectorlabel-list' => 'Lëscht',
	'srf-filtered-selectorlabel-calendar' => 'Kalenner',
	'srf-printername-d3chart' => 'D3 Grafik',
	'srf-paramdesc-zoom' => 'Zoom aschalten',
	'srf-paramdesc-pageitems' => 'Objete pro Säit:',
	'srf-printername-eventcalendar' => 'Manifestatiounskalenner',
	'srf-paramdesc-calendarfirstday' => 'Den Dag mat deem all Woch ufänkt',
	'srf-ui-eventcalendar-label-today' => 'Haut',
	'srf-ui-eventcalendar-label-month' => 'Mount',
	'srf-ui-eventcalendar-label-week' => 'Woch',
	'srf-ui-eventcalendar-label-day' => 'Dag',
	'srf-ui-eventcalendar-label-allday' => 'Ganzen Dag',
	'srf-paramdesc-unit' => 'Eenheet',
);

/** Lithuanian (lietuvių)
 * @author Hugo.arg
 */
$messages['lt'] = array(
	'srfc_previousmonth' => 'Praeitas mėnuo',
	'srfc_nextmonth' => 'Ateinantis mėnuo',
	'srfc_today' => 'Šiandien',
	'srfc_gotomonth' => 'Eiti į mėnesį',
);

/** Latvian (latviešu)
 * @author GreenZeb
 */
$messages['lv'] = array(
	'srfc_previousmonth' => 'Iepriekšējais mēnesis',
	'srfc_nextmonth' => 'Nākamais mēnesis',
	'srfc_today' => 'Šodiena',
	'srfc_gotomonth' => 'Doties uz mēnesi',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'srf-desc' => 'Дополнителни формати за барања од Семантички МедијаВики',
	'srf-name' => 'Формати на семантички резултати',
	'prefs-srf' => 'Формати на семантички резултати',
	'srf-prefs-intro-text' => 'Го инсталиравте додатокот „Формати на семантички резултати“ кој, во моментов, не е прилагодлив за корисникот. Помош ќе добиете на страницата за [http://www.semantic-mediawiki.org/wiki/Help:Result_formats формати на резултатите].',
	'srf-module-loading' => 'Вчитувам...',
	'srf-paramdesc-layout' => 'Распоред на располагање',
	'srf-paramdesc-height' => 'Висина',
	'srf-paramdesc-width' => 'Ширина',
	'srf-paramdesc-class' => 'Укажување на дополнителна класа на каскадни стилски страници',
	'srf-module-nomatch' => 'Нема совпаѓања',
	'srf-paramdesc-charttype' => 'Расположив тип на дијаграм',
	'srf-navigation-previous' => 'Претходно',
	'srf-ui-navigation-prev' => 'Прет',
	'srf-ui-navigation-next' => 'След',
	'srf-ui-common-label-source' => 'Извор',
	'srf-ui-common-label-datasource' => 'Извор на податоци',
	'srf-ui-common-label-ajax-error' => 'Опслужувачот не успеа да се поврзе со овој $1. Превчитајте ја страницата или консултирајте се со овој $2.',
	'srf-ui-common-label-request-object' => 'објект за проверка',
	'srf-ui-common-label-help-section' => 'дел за помош',
	'srf-ui-tooltip-title-options' => 'Поставки',
	'srf-ui-tooltip-title-scope' => 'Делокруг',
	'srf-error-option-mix' => 'Можноста ($1) не е достапна',
	'srf-error-option-link-all' => 'Можноста ($1) бара параметарот „link“ да биде ставен на „all“',
	'srf-error-missing-layout' => 'Распоредот недостасува',
	'srf-warn-empy-chart' => 'Дијаграмот/графиконот е празен или недостасуваат податоци',
	'srfc_previousmonth' => 'Претходен месец',
	'srfc_nextmonth' => 'Следен месец',
	'srfc_today' => 'Денес',
	'srfc_gotomonth' => 'Оди на месецот',
	'srf_printername_calendar' => 'Месечен календар',
	'srf_paramdesc_calendarlang' => 'Кодот на јазикот на кој ќе се прикажува календарот',
	'srf_paramdesc_calendarcolors' => 'Бојата за приказ на секое датумско својство (пример: "Почетен датум=>green,Краен датум=>#09c")',
	'srf_printername_vcard' => 'Извоз на vCard',
	'srf_icalendar_link' => 'iКалендар',
	'srf_printername_icalendar' => 'Извоз на iCalendar',
	'srf_paramdesc_icalendartitle' => 'Насловот на податотеката на календарот',
	'srf_paramdesc_icalendardescription' => 'Описот на податотеката на календарот',
	'srf_printername_bibtex' => 'Извоз на BibTeX',
	'srf_outline_novalue' => 'Нема вредност',
	'srf_printername_outline' => 'Преглед',
	'srf_paramdesc_outlineproperties' => 'Список на својствата за прикажување како заглавија, одделени со запирки',
	'srf_printername_sum' => 'Збир од броевите',
	'srf_printername_average' => 'Просек од броевите',
	'srf_printername_max' => 'Максимален број',
	'srf_printername_min' => 'Минимален број',
	'srf_paramdesc_limit' => 'Максимален број на страници кои можат да се пребараат',
	'srf_printername_product' => 'Производ на броеви',
	'srf_printername_median' => 'Средна бројна вредност',
	'srf-paramdesc-default' => 'Основна вредност што ќе се прикажува кога нема бројчени резултати',
	'srf_printername_earliest' => 'Прва временска точка',
	'srf_printername_latest' => 'Последна временска точка',
	'srf_printername_timeline' => 'Хронологија',
	'srf_printername_eventline' => 'Преглед на настани',
	'srf_paramdesc_timelinebands' => 'Определува кои ленти ќе се прикажуваат во резултатот.',
	'srf_paramdesc_timelineposition' => 'Определува каде временската скала најпрвин ќе се фокусира.',
	'srf_paramdesc_timelinestart' => 'Име на својството кое се користи за определување на првата временска точка',
	'srf_paramdesc_timelineend' => 'Име на својството кое се користи за определување на втората временска точка',
	'srf_paramdesc_timelinesize' => 'Висината на временската скала',
	'srf-timeline-allresults' => 'Понатамошни резултати од ова барање.',
	'srf-timeline-nojs' => 'За да можете да ја гледате интерактивната хронологија, ќе треба да имате овозможено JavaScript.',
	'srf_paramdesc_views' => 'Погледите за прикажување',
	'srf_paramdesc_facets' => 'Збирот својства кои ќе се прикажуваат на секоја страница',
	'srf_paramdesc_lens' => 'Името на шаблонот со кој ќе се прикажат својствата на страницата',
	'srf_printername_googlebar' => 'Столбен дијаграм од Google',
	'srf_printername_googlepie' => 'Кружен дијаграм од Google',
	'srf-printername-jqplotchart' => 'jqPlot-графикон',
	'srf-printername-jqplotseries' => 'jqPlot-низа',
	'srf_paramdesc_chartheight' => 'Укажување на висината на дијаграмот/графикот (во пиксели)',
	'srf_paramdesc_chartwidth' => 'Укажување на ширината на дијаграмот/графикот (во пиксели)',
	'srf_paramdesc_charttitle' => 'Насловот на графиконот',
	'srf_paramdesc_barcolor' => 'Бојата на столбовите',
	'srf_paramdesc_bardirection' => 'Укажете насока на столбниот графикон',
	'srf-paramdesc-direction' => 'Укажување на правецот на дијаграмот/графиконот',
	'srf_paramdesc_barnumbersaxislabel' => 'Натпис за бројната оска',
	'srf-paramdesc-labelaxislabel' => 'Натпис за натписната оска',
	'srf-paramdesc-ticklabels' => 'Овозможување на натписи со штикли',
	'srf-paramdesc-minvalue' => 'Минимална вредност за приказ на Y-оската',
	'srf-paramdesc-pointlabels' => 'Прикажи податочни точки на графиконот',
	'srf-paramdesc-chartlegend' => 'Положба на легендата на графиконот',
	'srf-paramdesc-datalabels' => 'Прикажувај натписи за податоци на дијаграмот/графиконот',
	'srf-paramdesc-charttext' => 'Описен текст за графиконот',
	'srf-paramdesc-chartclass' => 'Дополнителна CSS класа',
	'srf-paramdesc-renderer' => 'Одберете исписник за графиконот',
	'srf-paramdesc-filling' => 'Избор на поединечно пополнување',
	'srf-paramdesc-theme' => 'Одберете стил на решетката',
	'srf-paramdesc-chartcolor' => 'Укажете поединечни бои на графиконот',
	'srf-paramdesc-colorscheme' => 'Одберете боен стил',
	'srf-paramdesc-valueformat' => 'Укажете правило за форматирање на вредностите',
	'srf-paramdesc-highlighter' => 'Истакнувај ги податочните точки',
	'srf-paramdesc-smoothlines' => 'Примени алгоритам за измазнување во графиконите со линии',
	'srf-paramdesc-stackseries' => 'Прикажи го графиконот како напластена низа',
	'srf-paramdesc-seriesgroup' => 'Одберете групирање на низата',
	'srf-paramdesc-serieslabel' => 'Определување на натпис за низата',
	'srf-paramdesc-grouplabel' => 'Определување на натписот на групата',
	'srf-paramdesc-chartcursor' => 'Можност за приказ на курсор во графиконот',
	'srf-paramdesc-trendline' => 'Овозможи едновремен приказ на графикон и неговата трендова линија',
	'srf-paramdesc-gridview' => 'Истовремено прикажувај графикон и податочни збирови',
	'srf-paramdesc-infotext' => 'Прикажување на дополнителни информации во соодветното инфојазиче',
	'srf-ui-gridview-label-item' => 'Податочна ставка',
	'srf-ui-gridview-label-value' => 'Податочна вредност',
	'srf-ui-gridview-label-series' => 'Податочна низа',
	'srf-ui-gridview-label-chart-tab' => 'Графикон',
	'srf-ui-gridview-label-data-tab' => 'Податоци',
	'srf-ui-gridview-label-info-tab' => 'Инфо',
	'srf_printername_gallery' => 'Галерија',
	'srf_paramdesc_perrow' => 'Број на слики по ред',
	'srf_paramdesc_widths' => 'Ширина на сликите',
	'srf_paramdesc_heights' => 'Висина на сликите',
	'srf_paramdesc_autocaptions' => 'Користи го името на податотеката за опис ако не е внесен друг',
	'srf_paramdesc_fileextensions' => 'При користење на податотечното име како опис, прикажувај ја и наставката',
	'srf_paramdesc_captionproperty' => 'Име на семантичкото својство присутно на побараните страници што ќе се користи како опис',
	'srf_paramdesc_imageproperty' => 'Име на семантичкото својство присутно на побараните страници што ќе посочува кои слики да се користат. Кога е зададено, самите побарани страници нема да се прикажуваат како слики',
	'srf-paramdesc-redirects' => 'Називот на семантичкото својство на бараните страници што содржат цел за пренасочување',
	'srf-paramdesc-navigation' => 'Навигација на распоредот',
	'srf-paramdesc-overlay' => 'Овозможи препокривање на сликите',
	'srf-gallery-navigation-previous' => 'Претходно',
	'srf-gallery-navigation-next' => 'Следно',
	'srf-gallery-overlay-count' => 'Слика $1 од $2',
	'srf-gallery-image-url-error' => 'Сликата не е најдена.',
	'srf_printername_tagcloud' => 'Облак со ознаки',
	'srf_paramdesc_includesubject' => 'Дали да се вклучат имињата на самите теми',
	'srf_paramdesc_increase' => 'Како да ги зголемите ознаките',
	'srf_paramdesc_tagorder' => 'Редоследот на ознаките',
	'srf_paramdesc_mincount' => 'Барем колку пати треба да се јави една вредност за да биде наведена',
	'srf_paramdesc_minsize' => 'Големина на најмалата ознака во проценти',
	'srf_paramdesc_maxsize' => 'Големина на најголемите ознаки во проценти',
	'srf_paramdesc_maxtags' => 'Најголемиот допуштен број на ознаки во облакот',
	'srf-paramdesc-excludetags' => 'Изземи ознаки (одделувач: ;)',
	'srf_printername_valuerank' => 'Ранг',
	'srf_printername_array' => 'Податочен строј',
	'srf_paramdesc_pagetitle' => 'Дали во резултатите да се прикажуваат наслови на страници или да се изоставуваат',
	'srf_paramdesc_hidegaps' => 'Дали се испишуваат побараните, но недостапни вредности на својства и записи одделени со одделувачи, или пак да се изоставуваат',
	'srf_paramdesc_arrayname' => 'Ако е зададено, и има додадок за податотечни строеви (ArrayExtension ), ова ќе создаде нов строј со наведеното име (тогаш нема да има видлив извод)',
	'srf_paramdesc_propsep' => 'Одделувач помеѓу бараните својства',
	'srf_paramdesc_manysep' => 'Одделувач на вредностите кај повеќевредносни својства',
	'srf_paramdesc_recordsep' => 'Одделувач помеѓу вредностите на записните својства',
	'srf_paramdesc_headersep' => 'Одделувач помеѓу името на својството и вредноста ако "headers" е наместено на „show“ или „plain“',
	'srf_printername_hash' => 'Тараба',
	'srf_paramdesc_hashname' => 'Ако е зададено, а на располагање е додатокот зе тарабни табели (HashTables), ова ќе создаде тараба со наведеното име (тогаш нема да има видлив извод)',
	'srf-printername-graph' => 'Графикон',
	'srf-paramdesc-graph-relation' => 'Дали предметите или именските својства се матични или зависни?',
	'srf-paramdesc-graph-nameprop' => 'Овозможува задавање на својство што ќе се користи како предмет наместо фактичкиот предмет',
	'srf-paramdesc-graph-nodeshape' => 'Обликот на секој јазол во графиконот',
	'srf_paramdesc_graphname' => 'Наслов',
	'srf_paramdesc_graphsize' => 'Големина на графиконот (во пиксели)',
	'srf_paramdesc_graphlegend' => 'Дали да се прикажува легенда за графиконот',
	'srf_paramdesc_graphlabel' => 'Натпис на графиконот',
	'srf_paramdesc_rankdir' => 'Правец на стрелката',
	'srf_paramdesc_graphlink' => 'Врска за графиконот',
	'srf_paramdesc_graphcolor' => 'Боја на графиконот',
	'srf-paramdesc-graph-wwl' => 'Граница за прелом (во бр. на знаци)',
	'srf_printername_datatables' => 'ПодаточниТабели',
	'srf-paramdesc-rowindex' => 'Индекс на табл. ред',
	'srf-paramdesc-displaylength' => 'Првична должина на приказот',
	'srf_printername_tree' => 'Дрво',
	'srf_printername_ultree' => 'Неподредено дрво',
	'srf_printername_oltree' => 'Подредено дрво',
	'srf-noparentprop' => 'Нема зададено матично својство. Дрвото не може да се оформи без наведено матично својство.',
	'srf-paramdesc-parent' => 'Својството што ја содржи матичната страница',
	'srf-printername-slideshow' => 'ПодвижнаГалерија',
	'srf-paramdesc-delay' => 'Временското растојание помеѓу сликите во секунди',
	'srf-paramdesc-navigation-controls' => 'Дали да се прикажат навигациските контроли',
	'srf-paramdesc-effect' => 'Ефектот што ќе се користи при префрлањето од слика на слика',
	'srf-printername-filtered' => 'Филтрирано',
	'srf-paramdesc-filtered-views' => 'Погледите на на располагање во приказот на резултатите',
	'srf-paramdesc-filtered-filter-position' => 'Положбата на филтрите во однос на погледите. Допуштени вредности: top, bottom. По основно: top.',
	'srf-paramdesc-filtered-list-type' => 'Тип на списокот. Допуштени вредности: list, ul, ol. По основно: list.',
	'srf-paramdesc-filtered-list-template' => 'Шаблонот што се користи за форматирање на ставките во списокот.',
	'srf-paramdesc-filtered-list-named-args' => 'Именувајте ги аргументите што му се предаваат на шаблонот.',
	'srf-paramdesc-filtered-list-introtemplate' => 'Име на шаблонот за приказ пред резултатите од пребарувањето, ако ги има',
	'srf-paramdesc-filtered-list-outrotemplate' => 'Име на шаблонот за приказ по резултатите од пребарувањето, ако ги има',
	'srf-paramdesc-filtered-calendar-start' => 'Исписот што го содржи датумот на почеток на настанот',
	'srf-paramdesc-filtered-calendar-end' => 'Исписот што го содржи датумот на завршување на настанот',
	'srf-paramdesc-filtered-calendar-title' => 'Исписот што го содржи насловот на настанот. Не може да се користи заедно со насловен шаблон.',
	'srf-paramdesc-filtered-calendar-title-template' => 'Шаблон со кој се форматира насловот на настанот во календарот',
	'srf-filtered-selectorlabel-list' => 'Список',
	'srf-filtered-selectorlabel-calendar' => 'Календар',
	'srf-printername-d3chart' => 'D3-графикон',
	'srf-printername-timeseries' => 'Графикон на временска низа',
	'srf-paramdesc-group' => 'Групирање на низата според',
	'srf-paramdesc-zoom' => 'Овозможи приближување',
	'srf-paramdesc-datatable' => 'Овозможи податочна табела',
	'srf-timeseries-zoom-out-of-range' => 'Опсегот на приближување не даде достатни податоци',
	'srf-printername-sparkline' => 'Графикон во текст',
	'srf-printername-listwidget' => 'Елемент за списоци',
	'srf-paramdesc-listtype' => 'Укажување на тип на списокот',
	'srf-paramdesc-widget' => 'Елемент на располагање',
	'srf-paramdesc-pageitems' => 'Ставки по страница',
	'srf-printername-eventcalendar' => 'Календар на настани',
	'srf-paramdesc-calendarfirstday' => 'Почетниот ден на седмиците',
	'srf-paramdesc-calendardefaultview' => 'Првичниот изглед со вчитувањето на календарот',
	'srf-paramdesc-calendarstart' => 'Првичен почеток на календарот',
	'srf-paramdesc-dayview' => 'Овозможува преглед на поедичени денови со стискање на бројот на денот',
	'srf-ui-eventcalendar-label-today' => 'Денес',
	'srf-ui-eventcalendar-label-month' => 'Месец',
	'srf-ui-eventcalendar-label-week' => 'Недела',
	'srf-ui-eventcalendar-label-day' => 'Ден',
	'srf-ui-eventcalendar-label-allday' => 'Цел ден',
	'srf-printername-dygraphs' => 'Двографен дијаграм',
	'srf-paramdesc-datasource' => 'Наведете го изворот на податоците (податотека, URL и тн.)',
	'srf-paramdesc-errorbar' => 'Укажете ја пругата за грешки што ќе се користи (стандардно отстапување (сигма), дропки или прилагодена како опсег на вредностите low;middle;high)',
	'srf-paramdesc-movingaverage' => 'Прикажи го просекот за извесен број денови (ако укажете <code>zero</code> (нула), тогаш ова ќе значи дека нема подвижен просек)',
	'srf-paramdesc-yaxislabel' => 'Опис што се прикажува на y-оската',
	'srf-paramdesc-xaxislabel' => 'Опис што се прикажува на x-оската',
	'srf-paramdesc-unit' => 'Единица',
	'srf-printername-pagewidget' => 'Елемент на страница',
	'srf-printername-incoming' => 'Дојдовни својства',
	'srf-paramdesc-min' => 'Минимална или гранична вредност',
	'srf-paramdesc-excludeproperty' => 'Исклучување на својството од резултатот',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'srfc_previousmonth' => 'കഴിഞ്ഞ മാസം',
	'srfc_nextmonth' => 'അടുത്ത മാസം',
	'srfc_today' => 'ഇന്ന്',
	'srfc_gotomonth' => 'മാസത്തിലേക്ക് പോവുക',
	'srf_icalendar_link' => 'iകലണ്ടർ',
);

/** Marathi (मराठी)
 * @author Mahitgar
 */
$messages['mr'] = array(
	'srfc_previousmonth' => 'मागचा महीना',
	'srfc_nextmonth' => 'पुढचा महीना',
	'srfc_today' => 'आज',
	'srfc_gotomonth' => 'महीन्याकडे चला',
	'srf_icalendar_link' => 'इ-कैलेंडर',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'srf_paramdesc_graphname' => 'Tajuk',
);

/** Erzya (эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'srfc_previousmonth' => 'Йутазь ковсто',
	'srfc_nextmonth' => 'Сы ковсто',
	'srfc_today' => 'Течи',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'srfc_previousmonth' => 'Achto mētztli',
	'srfc_nextmonth' => 'Niman mētztli',
	'srfc_today' => 'Āxcān',
	'srfc_gotomonth' => 'Yāuh mētzhuīc',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Event
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'srf-desc' => 'Tilleggsformater for Semantic MediaWiki «inline»-spørringer',
	'srf-name' => 'Semantisk resultatformat',
	'srf-warn-empy-chart' => 'Diagrammet vises ikke fordi det ikke finnes resultater som kan presenteres.', # Fuzzy
	'srfc_previousmonth' => 'Forrige måned',
	'srfc_nextmonth' => 'Neste måned',
	'srfc_today' => 'I dag',
	'srfc_gotomonth' => 'Gå til måned',
	'srf_printername_calendar' => 'Månedlig kalender',
	'srf_paramdesc_calendarlang' => 'Språkkoden for språket som kalenderen skal vises i',
	'srf_paramdesc_calendarcolors' => 'Fargen som vil brukes for hver datoegenskap (eksempel: "Start date=>green,End date=>#09c")',
	'srf_printername_vcard' => 'vCard-eksport',
	'srf_icalendar_link' => 'iKalender',
	'srf_printername_icalendar' => 'iCalendar-eksport',
	'srf_paramdesc_icalendartitle' => 'Tittelen på kalenderfilen',
	'srf_paramdesc_icalendardescription' => 'Beskrivelsen av kalenderfilen',
	'srf_printername_bibtex' => 'BibTeX-eksport',
	'srf_outline_novalue' => 'Ingen verdi',
	'srf_printername_outline' => 'Disposisjon',
	'srf_paramdesc_outlineproperties' => 'Listen over egenskaper som skal vises som disposisjonsoverskrifter, adskilt med komma',
	'srf_printername_sum' => 'Tallsum',
	'srf_printername_average' => 'Gjennomsnitt av tall',
	'srf_printername_max' => 'Største tall',
	'srf_printername_min' => 'Minste tall',
	'srf_paramdesc_limit' => 'Maks antall sider å etterspørre',
	'srf_printername_product' => 'Produktet av tallene',
	'srf_printername_median' => 'Median av tall',
	'srf-paramdesc-default' => 'Standardverdi som vises når det ikke er numeriske resultater',
	'srf_printername_earliest' => 'Tidligst tidspunkt',
	'srf_printername_latest' => 'Senest tidspunkt',
	'srf_printername_timeline' => 'Tidslinje',
	'srf_printername_eventline' => 'Hendelseslinje',
	'srf_paramdesc_timelinebands' => 'Definerer hvilke bånd som vises i resultatet.',
	'srf_paramdesc_timelineposition' => 'Definerer hvor tidslinjen først fokuseres rundt.',
	'srf_paramdesc_timelinestart' => 'Et egenskapsnavn brukt for å definere et første tidspunkt',
	'srf_paramdesc_timelineend' => 'Et egenskapsnavn brukt for å definere et andre tidspunkt',
	'srf_paramdesc_timelinesize' => 'Høyden på tidslinjen',
	'srf-timeline-allresults' => 'Flere resultater for denne spørringen',
	'srf-timeline-nojs' => 'Du må tillate JavaScript for å kunne se den interaktive tidslinjen.',
	'srf_paramdesc_views' => 'Visninger som skal sees',
	'srf_paramdesc_facets' => 'Egenskapssettet som skal vises for hver side',
	'srf_paramdesc_lens' => 'Navnet på malen som skal vise frem sideegenskapene',
	'srf_printername_googlebar' => 'Google stolpediagram',
	'srf_printername_googlepie' => 'Google kakediagram',
	'srf_paramdesc_chartheight' => 'Høyden til diagrammet, i piksler', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Bredden til diagrammet, i piksler', # Fuzzy
	'srf_paramdesc_charttitle' => 'Tittelen på diagrammet',
	'srf_paramdesc_barcolor' => 'Fargen på stolpene',
	'srf_paramdesc_bardirection' => 'Angi diagramretning',
	'srf_paramdesc_barnumbersaxislabel' => 'Etiketten for tallaksen',
	'srf-paramdesc-minvalue' => 'Minimumsverdi på Y-aksen',
	'srf-paramdesc-pointlabels' => 'Visning diagramspesifikke datapunkter',
	'srf-paramdesc-chartlegend' => 'Diagramforklaringsposisjon',
	'srf-paramdesc-datalabels' => 'Vis dataetiketter', # Fuzzy
	'srf-paramdesc-charttext' => 'Beskrivende diagramtekst',
	'srf-paramdesc-chartclass' => 'Ekstra CSS-klasse',
	'srf-paramdesc-renderer' => 'Velg en diagram-fremviser',
	'srf-paramdesc-filling' => 'Valg av enkeltutfylling',
	'srf-paramdesc-theme' => 'Velg et rutenett-tema',
	'srf-paramdesc-chartcolor' => 'Bruk individuelle diagramfarger',
	'srf-paramdesc-colorscheme' => 'Velg en fargepalett',
	'srf-paramdesc-valueformat' => 'Velg en formateringsregel for verdier',
	'srf-paramdesc-highlighter' => 'Vis en datapunktuthever',
	'srf-paramdesc-smoothlines' => 'Bruk glatting i linjediagrammer',
	'srf-paramdesc-stackseries' => 'Vis diagrammet som en stablet rekke',
	'srf-paramdesc-seriesgroup' => 'Velg rekkegruppering',
	'srf-paramdesc-serieslabel' => 'Angi rekke-etiketter', # Fuzzy
	'srf_printername_gallery' => 'Galleri',
	'srf_paramdesc_perrow' => 'Antall bilder per rad',
	'srf_paramdesc_widths' => 'Bredde på bildene',
	'srf_paramdesc_heights' => 'Høyde på bildene',
	'srf_paramdesc_autocaptions' => 'Bruk filnavn som bildetekst når denne mangler',
	'srf_paramdesc_fileextensions' => 'Hvis filnavn brukes som figurtekst, vis også filtypen',
	'srf_paramdesc_captionproperty' => 'Som figurtekst brukes navnet på den semantiske egenskapen tilgjengelig på sidene med spørringer',
	'srf_paramdesc_imageproperty' => 'Navnet på en semantisk egenskap for sidene med spørringer som peker to bilder som skal brukes. Hvis satt, blir sidene med spørringer ikke selv vist frem som bilder.',
	'srf_printername_tagcloud' => 'Tagg-sky',
	'srf_paramdesc_includesubject' => 'Hvis emnetekstene selv bør være med',
	'srf_paramdesc_increase' => 'Hvordan du øker størrelsen på taggene',
	'srf_paramdesc_tagorder' => 'Tagrekkefølgen',
	'srf_paramdesc_mincount' => 'Minste antall forekomster av en verdi for at den skal bli oppført',
	'srf_paramdesc_minsize' => 'Størrelsen på de minste taggene i prosent',
	'srf_paramdesc_maxsize' => 'Størrelsen på de største taggene i prosent',
	'srf_paramdesc_maxtags' => 'Minste antall tagger i skyen',
	'srf_printername_valuerank' => 'Verdirangering',
	'srf_printername_array' => 'Array',
	'srf_paramdesc_pagetitle' => 'Angi om sidetitlene skal vises eller skjules i resultatlisten',
	'srf_paramdesc_hidegaps' => 'Angi om utilgjengelige egenskaper eller record-verdier adskilt med skilletegn skal vises eller skjules',
	'srf_paramdesc_arrayname' => 'Hvis angitt samt at ArrayExtension er tilgjengelig, vil dette opprette et array med det angitte navnet',
	'srf_paramdesc_propsep' => 'Skilletegn mellom valgte egenskaper',
	'srf_paramdesc_manysep' => 'Skilletegn mellom flere verdier for samme egenskap',
	'srf_paramdesc_recordsep' => 'Skilletegn mellom flerverdi-recordegenskaper',
	'srf_paramdesc_headersep' => 'Skilletegn mellom egenskapsnavn og -verdi hvis "overskrifter" er satt til "vis" eller "vanlig"',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'Hvis angitt samt at HashTables-utvidelsen er tilgjengelig, vil dette opprette en hashkode med det angitte navnet',
	'srf-printername-graph' => 'Graf',
	'srf-paramdesc-graph-relation' => 'Er subjektene eller navnegenskapene foreldre eller barn?',
	'srf-paramdesc-graph-nameprop' => 'Tillater å sette en egenskap som vil brukes som subjekt istedenfor det egentlige subjektet',
	'srf-paramdesc-graph-nodeshape' => 'Formen på hver node i grafen',
	'srf_paramdesc_graphname' => 'Tittel',
	'srf_paramdesc_graphsize' => 'Grafstørrelse (i piksler)',
	'srf_paramdesc_graphlegend' => 'Vis eller skjul graf-beskrivelse',
	'srf_paramdesc_graphlabel' => 'Graf-etikett',
	'srf_paramdesc_rankdir' => 'Pilretning',
	'srf_paramdesc_graphlink' => 'Graf-lenke',
	'srf_paramdesc_graphcolor' => 'Graf-farge',
	'srf-paramdesc-graph-wwl' => 'Maksimal lengde av tekstlinje',
	'srf_printername_datatables' => 'Datatabeller',
	'srf-paramdesc-rowindex' => 'Tabellradnummer',
	'srf-paramdesc-displaylength' => 'Initial visningslengde',
	'srf_printername_tree' => 'Tre',
	'srf_printername_ultree' => 'Unummerert tre',
	'srf_printername_oltree' => 'Nummerert tre',
	'srf-noparentprop' => 'Ingen foreldreegenskap er oppgitt. Treet kan ikke bygges uten en slik.',
	'srf-paramdesc-parent' => 'Egenskapen som inneholder foreldresiden',
);

/** Dutch (Nederlands)
 * @author AvatarTeam
 * @author GerardM
 * @author McDutchie
 * @author Rcdeboer
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'srf-desc' => 'Aanvullende formaten voor inline zoekopdrachten via Semantic MediaWiki',
	'srf-name' => 'Semantische resultaatopmaken',
	'prefs-srf' => 'Semantische resultaatopmaken',
	'srf-prefs-intro-text' => 'U heeft de uitbreiding voor semantische resultaatopmaken geïnstalleerd, die op dit moment geen instelbare gebruikersopties heeft. Voor hulp bezoekt u de [http://www.semantic-mediawiki.org/wiki/Help:Result_formats resultaatopmaken] hulppagina.',
	'srf-module-loading' => 'Bezig met laden…',
	'srf-paramdesc-layout' => 'Beschikbare opmaak',
	'srf-paramdesc-height' => 'Hoogte',
	'srf-paramdesc-width' => 'Breedte',
	'srf-paramdesc-class' => 'Geef een extra CSS-klasse op',
	'srf-module-nomatch' => 'Geen overeenkomsten gevonden',
	'srf-paramdesc-charttype' => 'Beschikbaar grafiektype',
	'srf-navigation-previous' => 'Vorige',
	'srf-ui-navigation-prev' => 'Vorige',
	'srf-ui-navigation-next' => 'Volgende',
	'srf-ui-common-label-source' => 'Bron',
	'srf-ui-common-label-datasource' => 'Gegevensbron',
	'srf-ui-tooltip-title-options' => 'Opties',
	'srf-ui-tooltip-title-scope' => 'Scope',
	'srf-error-option-mix' => 'De optie ($1) is niet beschikbaar',
	'srf-error-option-link-all' => 'Voor optie ($1) moet de parameter "link" ingesteld worden op "all".',
	'srf-error-missing-layout' => 'Vormgeving ontbreekt',
	'srf-warn-empy-chart' => 'De grafiek of kaart is leeg omdat er gegevens missen',
	'srfc_previousmonth' => 'Vorige maand',
	'srfc_nextmonth' => 'Volgende maand',
	'srfc_today' => 'Vandaag',
	'srfc_gotomonth' => 'Ga naar maand',
	'srf_printername_calendar' => 'Maandkalender',
	'srf_paramdesc_calendarlang' => 'De taalcode voor de taal waarin de kalender wordt weergegeven',
	'srf_paramdesc_calendarcolors' => 'De kleur weer te geven voor elke datumeigenschap (voorbeeld: "Startdatum=>green,Einddatum=>#09c")',
	'srf_printername_vcard' => 'Naar vCard exporteren',
	'srf_printername_icalendar' => 'Naar iCalendar exporteren',
	'srf_paramdesc_icalendartitle' => 'De titel van het kalenderbestand',
	'srf_paramdesc_icalendardescription' => 'De beschrijving van het kalenderbestand',
	'srf_printername_bibtex' => 'Naar BibTeX exporteren',
	'srf_outline_novalue' => 'Geen waarde',
	'srf_printername_outline' => 'Outline',
	'srf_paramdesc_outlineproperties' => 'De koomagescheiden lijst met eigenschappen die weergegeven moet worden als overzichtskoptekst',
	'srf_printername_sum' => 'Som van getallen',
	'srf_printername_average' => 'Gemiddelde van getallen',
	'srf_printername_max' => 'Hoogste getal',
	'srf_printername_min' => 'Laagste getal',
	'srf_paramdesc_limit' => "Het maximaal aantal op te vragen pagina's",
	'srf_printername_product' => 'Product van getallen',
	'srf_printername_median' => 'Mediaan van getallen',
	'srf-paramdesc-default' => 'De standaard waarde die wordt weergegeven als er geen numerieke resultaten zijn',
	'srf_printername_earliest' => 'Vroegste tijd',
	'srf_printername_latest' => 'Meest recente tijd',
	'srf_printername_timeline' => 'Tijdlijn',
	'srf_printername_eventline' => 'Gebeurtenissenlijn',
	'srf_paramdesc_timelinebands' => 'Geeft aan welke banden in het resultaat weergegeven moeten worden.',
	'srf_paramdesc_timelineposition' => 'Geeft aan waar de tijdlijn zich aanvankelijk op richt.',
	'srf_paramdesc_timelinestart' => 'De naam van een eigenschap die wordt gebruikt om het eerst punt in de tijd te bepalen',
	'srf_paramdesc_timelineend' => 'De naam van een eigenschap die wordt gebruikt om het tweede punt in de tijd te bepalen',
	'srf_paramdesc_timelinesize' => 'De hoogte van de tijdlijn',
	'srf-timeline-allresults' => 'Meer resultaten voor deze zoekopdracht.',
	'srf-timeline-nojs' => 'U moet JavaScript ingeschakeld hebben om de interactieve tijdlijn te kunnen weergeven.',
	'srf_paramdesc_views' => 'De weer te geven overzichten',
	'srf_paramdesc_facets' => 'De op iedere pagina weer te geven eigenschappen',
	'srf_paramdesc_lens' => 'De naam van de sjabloon waarmee de paginaeigenschappen weergegeven moeten worden',
	'srf_printername_googlebar' => 'Google staafgrafiek',
	'srf_printername_googlepie' => 'Google taartgrafiek',
	'srf-printername-jqplotchart' => 'jqPlotgrafiek',
	'srf-printername-jqplotseries' => 'jqPlotserie',
	'srf_paramdesc_chartheight' => 'Geef de hoogte op (in pixels) van een kaart of grafiek',
	'srf_paramdesc_chartwidth' => 'Geef de breedte op (in pixels) van een kaart of grafiek',
	'srf_paramdesc_charttitle' => 'Grafiektitel',
	'srf_paramdesc_barcolor' => 'De kleur van de balken',
	'srf_paramdesc_bardirection' => 'Geeft de richting van een grafiek aan',
	'srf_paramdesc_barnumbersaxislabel' => 'Het label van de nummeras',
	'srf-paramdesc-minvalue' => 'De minimumwaarde om weer te geven op de Y-as',
	'srf-paramdesc-pointlabels' => 'Individuele waarden in de grafiek weergeven',
	'srf-paramdesc-chartlegend' => 'Positie van de grafieklegenda',
	'srf-paramdesc-datalabels' => 'Grafiek- of kaartlabels weergeven',
	'srf-paramdesc-charttext' => 'Beschrijvende grafiektekst',
	'srf-paramdesc-chartclass' => 'Extra CSS-klasse',
	'srf-paramdesc-renderer' => 'Selecteer een renderer voor een kaart of grafiek',
	'srf-paramdesc-filling' => 'Optie voor individuele vulling',
	'srf-paramdesc-theme' => 'Selecteer een vormgeving voor het raster',
	'srf-paramdesc-chartcolor' => 'Individuele grafiekkleuren toewijzen',
	'srf-paramdesc-colorscheme' => 'Selecteer een kleurschema',
	'srf-paramdesc-valueformat' => 'Geef een opmaakregel voor de waarden op',
	'srf-paramdesc-highlighter' => 'Een gegevenspuntmarkering opgeven',
	'srf-paramdesc-smoothlines' => 'Lijnen in lijngrafieken vloeiend maken',
	'srf-paramdesc-stackseries' => 'Grafiek weergeven als gestapelde series',
	'srf-paramdesc-seriesgroup' => 'Selecteer groeperen van series',
	'srf-paramdesc-serieslabel' => 'Label voor series bepalen',
	'srf-paramdesc-chartcursor' => 'Optie voor het weergeven van een cursor in de grafiek',
	'srf-ui-gridview-label-item' => 'Gegevensitem',
	'srf-ui-gridview-label-value' => 'Gegevenswaarde',
	'srf-ui-gridview-label-series' => 'Gegevensseries',
	'srf-ui-gridview-label-chart-tab' => 'Grafiek',
	'srf-ui-gridview-label-data-tab' => 'Gegevens',
	'srf-ui-gridview-label-info-tab' => 'Informatie',
	'srf_printername_gallery' => 'Galerij',
	'srf_paramdesc_perrow' => 'Het aantal afbeeldingen per rij',
	'srf_paramdesc_widths' => 'De breedte van de afbeeldingen',
	'srf_paramdesc_heights' => 'De hoogte van de afbeeldingen',
	'srf_paramdesc_autocaptions' => 'Bestandsnaam als beschrijving gebruiken als er geen is opgegeven',
	'srf_paramdesc_fileextensions' => 'Ook de extensie weergeven als bestandsnamen als bijschrift worden gebruikt',
	'srf_paramdesc_captionproperty' => "De naam van een semantische eigenschap die aanwezig is op de doorzochte pagina's die gebruikt moet worden als bijschrift",
	'srf_paramdesc_imageproperty' => "De naam van een semantische eigenschap die aanwezig is op de doorzochte pagina's die verwijst naar de te gebruiken afbeeldingen. Als deze instelling wordt gebruikt, worden de doorzochte pagina's zelf niet weergegeven als afbeeldingen",
	'srf-paramdesc-navigation' => 'Navigatie-instellingen',
	'srf-paramdesc-overlay' => 'Beeldoverlay inschakelen',
	'srf-gallery-navigation-previous' => 'Vorige',
	'srf-gallery-navigation-next' => 'Volgende',
	'srf-gallery-overlay-count' => 'Afbeelding $1 van $2',
	'srf-gallery-image-url-error' => 'Deze afbeelding is niet gevonden.',
	'srf_printername_tagcloud' => 'Woordwolk',
	'srf_paramdesc_includesubject' => 'Of de namen van de onderwerpen zelf opgenomen moeten worden',
	'srf_paramdesc_increase' => 'Hoe de grootte van de labels moet worden vergroot',
	'srf_paramdesc_tagorder' => 'De volgorde van de labels',
	'srf_paramdesc_mincount' => 'Het minimale aantal keren dat een waarde moet voorkomen om opgenomen te worden',
	'srf_paramdesc_minsize' => 'De grootte van de kleinste labels in percentage',
	'srf_paramdesc_maxsize' => 'De grootte van de grootste labels in percentage',
	'srf_paramdesc_maxtags' => 'Het maximale aantal labels in de wolk',
	'srf-paramdesc-excludetags' => 'Labels uitsluiten (scheidingsteken is ";")',
	'srf_printername_valuerank' => 'Rangwaarde',
	'srf_printername_array' => 'Array',
	'srf_paramdesc_pagetitle' => 'Of paginanamen moeten worden weergegeven of weggelaten in resultaatregels',
	'srf_paramdesc_hidegaps' => "Of lege eigenschap- en recordwaardes door komma's gescheiden moeten worden weergegeven of weggelaten",
	'srf_paramdesc_arrayname' => 'Als opgegeven en ArrayExtension is beschikbaar, wordt een array met de aangegeven naam gemaakt (er is dan geen zichtbare uitvoer)',
	'srf_paramdesc_propsep' => 'Scheidingsteken voor de opgevraagde eigenschappen',
	'srf_paramdesc_manysep' => 'Scheidingsteken voor eigenschappen met meerdere waarden',
	'srf_paramdesc_recordsep' => 'Scheidingsteken voor waarden van recordeigenschappen',
	'srf_paramdesc_headersep' => 'Scheidingsteken tussen de eigenschapnaam en de waarde als "headers" is ingesteld op "show" of "plain"',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'Als opgegeven en de uitbreiding HashTables is beschikbaar, dan wordt een hash met de aangegeven naam gemaakt (er is dan geen zichtbare uitvoer)',
	'srf-printername-graph' => 'Grafiek',
	'srf-paramdesc-graph-relation' => 'Zijn de onderwerpen of naameigenschappen ouders of kinderen?',
	'srf-paramdesc-graph-nameprop' => 'Maakt het mogelijk een eigenschap in te stellen die wordt gebruikt als onderwerp in plaats van het eigenlijke onderwerp',
	'srf-paramdesc-graph-nodeshape' => 'De vorm van de knooppunten in de grafiek.',
	'srf_paramdesc_graphname' => 'Naam',
	'srf_paramdesc_graphsize' => 'Grafiekgrootte (in pixels)',
	'srf_paramdesc_graphlegend' => 'Legenda weergeven of verbergen',
	'srf_paramdesc_graphlabel' => 'Grafieklabel',
	'srf_paramdesc_rankdir' => 'Pijlrichting',
	'srf_paramdesc_graphlink' => 'Grafiekverwijzing',
	'srf_paramdesc_graphcolor' => 'Grafiekkleur',
	'srf-paramdesc-graph-wwl' => 'Regellimiet (in aantal tekens)',
	'srf_printername_datatables' => 'Gegevenstabellen',
	'srf-paramdesc-rowindex' => 'Tabelrij-index',
	'srf-paramdesc-displaylength' => 'Eerste weergavelengte',
	'srf_printername_tree' => 'Boom',
	'srf_printername_ultree' => 'Ongenummerde lijst',
	'srf_printername_oltree' => 'Genummerde lijst',
	'srf-noparentprop' => 'Er is geen bovenliggende eigenschap opgegeven. De boom kan niet opgebouwd worden zonder een bovenliggende eigenschap.',
	'srf-paramdesc-parent' => 'De eigenschap die de bovenliggende pagina bevat',
	'srf-printername-slideshow' => 'Diapresentatie',
	'srf-paramdesc-delay' => "De vertraging tussen dia's in seconden",
	'srf-paramdesc-navigation-controls' => 'Of navigatieknoppen wel of niet weergegeven moeten worden',
	'srf-paramdesc-effect' => "Het effect om tussen dia's te wisselen",
	'srf-printername-filtered' => 'Gefilterd',
	'srf-filtered-selectorlabel-list' => 'Lijst',
	'srf-filtered-selectorlabel-calendar' => 'Kalender',
	'srf-printername-d3chart' => 'D3-grafiek',
	'srf-printername-timeseries' => 'Tijdseriegrafiek',
	'srf-paramdesc-group' => 'Series groepen op',
	'srf-paramdesc-zoom' => 'Zoom inschakelen',
	'srf-paramdesc-datatable' => 'Gegevenstabel inschakelen',
	'srf-timeseries-zoom-out-of-range' => 'Het zoombereik heeft onvoldoende gegevens opgeleverd',
	'srf-printername-sparkline' => 'Sparklinegrafief',
	'srf-printername-listwidget' => 'Lijstwidget',
	'srf-paramdesc-listtype' => 'Geef het lijsttype op',
	'srf-paramdesc-widget' => 'Beschikbaar widget',
	'srf-paramdesc-pageitems' => 'Items per pagina',
	'srf-printername-eventcalendar' => 'Evenementenkalender',
	'srf-paramdesc-calendarfirstday' => 'De dag waarop de week begint',
	'srf-paramdesc-calendardefaultview' => 'De weergave wanneer de kalender wordt geladen',
	'srf-paramdesc-dayview' => 'Dagweergave inschakelen door te klikken op het dagnummer',
	'srf-ui-eventcalendar-label-today' => 'Vandaag',
	'srf-ui-eventcalendar-label-month' => 'Maand',
	'srf-ui-eventcalendar-label-week' => 'Week',
	'srf-ui-eventcalendar-label-day' => 'Dag',
	'srf-ui-eventcalendar-label-allday' => 'Hele dag',
	'srf-printername-dygraphs' => 'Dygraphsgrafiek',
	'srf-paramdesc-unit' => 'Eenheid',
	'srf-printername-pagewidget' => 'Paginawidget',
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Eirik
 * @author Gunnernett
 */
$messages['nn'] = array(
	'srf-desc' => 'Fleire format for Semantic MediaWiki «inline»-spørjingar',
	'srf-name' => 'Semantisk resultatformat',
	'srfc_previousmonth' => 'Førre månad',
	'srfc_nextmonth' => 'Neste månad',
	'srfc_today' => 'I dag',
	'srfc_gotomonth' => 'Gå til månad',
	'srf_printername_calendar' => 'Månadleg kalender',
	'srf_printername_vcard' => 'vCard eksport',
	'srf_printername_icalendar' => 'iCalendar eksport',
	'srf_printername_bibtex' => 'BibTeX eksport',
	'srf_outline_novalue' => 'Ingen verdi',
	'srf_printername_sum' => 'Sum av tal',
	'srf_printername_average' => 'Gjennomsnitt av tal',
	'srf_printername_max' => 'Største tal',
	'srf_printername_min' => 'Minste tal',
	'srf_printername_timeline' => 'Tidsline',
	'srf_printername_eventline' => 'Tidsline for hendingar',
);

/** Occitan (occitan)
 * @author Boulaur
 * @author Cedric31
 */
$messages['oc'] = array(
	'srf-desc' => 'Formats adicionals per las requèstas de Semantic MediaWiki',
	'srf-name' => 'Formatatge dels resultats semantics',
	'srfc_previousmonth' => 'Mes precedent',
	'srfc_nextmonth' => 'Mes seguent',
	'srfc_today' => 'Uèi',
	'srfc_gotomonth' => 'Anar cap al mes',
	'srf_printername_calendar' => 'Calendièr mesadièr',
	'srf_vcard_link' => 'vCarta',
	'srf_printername_vcard' => 'expòrt en vCard',
	'srf_icalendar_link' => 'iCalendièr',
	'srf_printername_icalendar' => 'expòrt en iCalendar',
	'srf_printername_bibtex' => 'expòrt en BibTeX',
	'srf_outline_novalue' => 'Pas cap de valor',
	'srf_printername_outline' => 'Esbòs',
	'srf_printername_sum' => 'Soma de nombres',
	'srf_printername_average' => 'Mejana dels nombres',
	'srf_printername_max' => 'Nombre maximal',
	'srf_printername_min' => 'Nombre minimal',
	'srf_printername_timeline' => 'Cronologia',
	'srf_printername_eventline' => 'Cronologia dels eveniments',
	'srf_paramdesc_graphname' => 'Títol',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'srfc_previousmonth' => 'Letscht Munet',
	'srfc_nextmonth' => 'Neegscht Munet',
	'srfc_today' => 'Heit',
);

/** Pälzisch (Pälzisch)
 * @author Manuae
 */
$messages['pfl'] = array(
	'srfc_previousmonth' => 'Vorische Monad',
	'srfc_nextmonth' => 'Negschde Monad',
	'srfc_today' => 'Haid',
	'srf_printername_earliest' => 'De friehschde Zaidpungd',
	'srf_printername_latest' => 'De schbedschde Zaidpungd',
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Maire
 * @author Sp5uhe
 * @author ToSter
 */
$messages['pl'] = array(
	'srf-desc' => 'Dodatkowe formaty dla zapytań semantycznych MediaWiki z wiersza poleceń',
	'srf-name' => 'Formaty semantycznych wyników',
	'srfc_previousmonth' => 'Poprzedni miesiąc',
	'srfc_nextmonth' => 'Następny miesiąc',
	'srfc_today' => 'Dzisiaj',
	'srfc_gotomonth' => 'Idź do miesiąca',
	'srf_printername_calendar' => 'Kalendarz na miesiąc',
	'srf_paramdesc_calendarlang' => 'Kod języka, w którym jest wyświetlany kalendarz',
	'srf_printername_vcard' => 'eksport vCard',
	'srf_printername_icalendar' => 'eksport iCalendar',
	'srf_paramdesc_icalendartitle' => 'Nazwa pliku kalendarza',
	'srf_paramdesc_icalendardescription' => 'Opis pliku kalendarza',
	'srf_printername_bibtex' => 'eksport BibTeX',
	'srf_outline_novalue' => 'Brak wartości',
	'srf_printername_outline' => 'Szkic',
	'srf_paramdesc_outlineproperties' => 'Spis właściwości, które zostaną wyświetlone jako nagłówki konspektu, rozdzielone przecinkami',
	'srf_printername_sum' => 'Suma liczb',
	'srf_printername_average' => 'Średnia liczb',
	'srf_printername_max' => 'Maksymalna liczba',
	'srf_printername_min' => 'Minimalna liczba',
	'srf_paramdesc_limit' => 'Maksymalna liczba stron dla zapytania',
	'srf_printername_timeline' => 'Oś czasu',
	'srf_printername_eventline' => 'Oś wydarzeń',
	'srf_paramdesc_timelinebands' => 'Określa, które okresy są wyświetlane w wynikach.',
	'srf_paramdesc_timelineposition' => 'Określa, gdzie początkowo zaczyna się oś czasu.',
	'srf_paramdesc_timelinestart' => 'Nazwa własności używana do określenia pierwszego punktu w czasie.',
	'srf_paramdesc_timelineend' => 'Nazwa własności używana do określenia drugiego punktu w czasie.',
	'srf_paramdesc_timelinesize' => 'Wysokość osi czasu',
	'srf_paramdesc_views' => 'Widoki do wyświetlenia',
	'srf_paramdesc_facets' => 'Zestaw właściwości do wyświetlenia na każdej stronie',
	'srf_paramdesc_lens' => 'Nazwa szablonu, który zostanie użyty do wyświetlenia właściwości strony',
	'srf_printername_googlebar' => 'wykres słupkowy Google',
	'srf_printername_googlepie' => 'wykres kołowy Google',
	'srf_paramdesc_chartheight' => 'Wskaż wysokość wykresu (w pikselach)',
	'srf_paramdesc_chartwidth' => 'Wskaż szerokość wykresu (w pikselach)',
	'srf_paramdesc_charttitle' => 'Tytuł wykresu',
	'srf_paramdesc_barcolor' => 'Kolory słupków',
	'srf_paramdesc_bardirection' => 'Wskaż kierunek wykresu',
	'srf_paramdesc_barnumbersaxislabel' => 'Etykieta wartości osi',
	'srf_printername_gallery' => 'Galeria',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'srf-desc' => 'Formà adissionaj për anterogassion an linia ëd Semantic MediaWiki',
	'srf-name' => "Formà dj'Arzultà Semàntich",
	'srfc_previousmonth' => 'Meis prima',
	'srfc_nextmonth' => 'Meis apress',
	'srfc_today' => 'Ancheuj',
	'srfc_gotomonth' => 'Va al meis',
	'srf_printername_calendar' => 'Armanach dël meis',
	'srf_paramdesc_calendarlang' => 'Ël còdes për la lenga ant la qual visualisé ël calendari',
	'srf_printername_vcard' => 'esportassion ëd vCard',
	'srf_printername_icalendar' => "esportassion d'iCalendar",
	'srf_paramdesc_icalendartitle' => "Ël tìtol ëd l'archivi dël calendari",
	'srf_paramdesc_icalendardescription' => "La descrission ëd l'achivi dël calendari",
	'srf_printername_bibtex' => 'esportassion BibTeX',
	'srf_outline_novalue' => 'Pa gnun valor',
	'srf_printername_outline' => 'Fòra linia',
	'srf_paramdesc_outlineproperties' => 'La lista ëd proprietà da visualisé com antestassion, separà da vìrgole',
	'srf_printername_sum' => 'Total dij nùmer',
	'srf_printername_average' => 'Media dij nùmer',
	'srf_printername_max' => 'Nùmer pì gròss',
	'srf_printername_min' => 'Nùmer pì cit',
	'srf_paramdesc_limit' => 'Ël nùmer màssim ëd pàgine da ciamé',
	'srf_printername_timeline' => 'Cronologìa',
	'srf_printername_eventline' => "Cronologìa dj'event",
	'srf_paramdesc_timelinebands' => "A definiss che partìe a son visualisà ant l'arzultà.",
	'srf_paramdesc_timelineposition' => 'A definiss andoa la cronologìa a part inissialment.',
	'srf_paramdesc_timelinestart' => 'Ël nòm ëd na proprietà dovrà për definì un prim pont ëd temp',
	'srf_paramdesc_timelineend' => 'Ël nòm ëd na proprietà dovrà për definì un secont pont ëd temp',
	'srf_paramdesc_timelinesize' => "L'autëssa dla cronologìa",
	'srf_paramdesc_views' => 'Le viste da visualisé',
	'srf_paramdesc_facets' => "L'ansema ëd proprietà da visualisé për minca pàgina",
	'srf_paramdesc_lens' => 'Ël nòm ëd në stamp con ël qual visualisé le proprietà dle pàgine',
	'srf_printername_googlebar' => 'Ël diagrama a bare ëd Google',
	'srf_printername_googlepie' => 'Ël diagrama a torta ëd Google',
	'srf_paramdesc_chartheight' => "L'autëssa dël diagrama, an pontin", # Fuzzy
	'srf_paramdesc_chartwidth' => 'La larghëssa dël diagrama, an pontin', # Fuzzy
	'srf_paramdesc_charttitle' => 'Ël tìtol dël gràfich',
	'srf_paramdesc_barcolor' => 'Ël color ëd le bare',
	'srf_paramdesc_bardirection' => 'La diression dël gràfich a bare', # Fuzzy
	'srf_paramdesc_barnumbersaxislabel' => "La tichëtta për l'ass dij nùmer",
	'srf_printername_gallery' => 'Galarìa',
	'srf_paramdesc_perrow' => 'Ël total ëd figure për riga',
	'srf_paramdesc_widths' => 'La larghëssa dla figure',
	'srf_paramdesc_heights' => "L'autëssa dle figure",
	'srf_paramdesc_autocaptions' => "Dovré ël nòm d'archivi com descrission quand che gnun-a a l'é dàita",
	'srf_printername_tagcloud' => 'Ansema ëd tichëtte',
	'srf_paramdesc_includesubject' => 'Se ij nòm dël soget midem a dovrìo esse ancludù',
	'srf_paramdesc_increase' => 'Com aumenté la dimension dle tichëtte',
	'srf_paramdesc_tagorder' => "L'órdin dle tichëtte",
	'srf_paramdesc_mincount' => 'Ël nùmer mìnim ëd vire che un valor a dev ancapité për esse listà',
	'srf_paramdesc_minsize' => 'La dimension dle tichëtte pi cite an persentual',
	'srf_paramdesc_maxsize' => 'La dimension dle tichëtte pi gròsse an përsentual',
	'srf_paramdesc_maxtags' => "La quantità màssima ëd tichëtte ant l'ansema",
	'srf_printername_array' => 'Tàula',
	'srf_paramdesc_pagetitle' => "S'a venta smon-e ij tìtoj ëd pàgina com vos ëd l'arzultà o stërmeje", # Fuzzy
	'srf_paramdesc_hidegaps' => "S'a venta smon-e na propietà veuida e argistré ij valor separà da 'd separator o stërmeje", # Fuzzy
	'srf_paramdesc_arrayname' => "Se dàit e si ArrayEstension a l'é disponìbil sòn a creerà na tàula con ij nòm ëspessìfich", # Fuzzy
	'srf_paramdesc_propsep' => 'Separator tra le proprietà ciamà',
	'srf_paramdesc_manysep' => 'Separator tra tante propietà con valor', # Fuzzy
	'srf_paramdesc_recordsep' => "Separator tra ij valor ëd le propietà d'argistrassion",
	'srf_printername_hash' => 'Taj',
	'srf_paramdesc_hashname' => "Se dàit e l'estension HashTables a l'é disponìbil sòn a creerà un taj con ël nòm ëspessìfich", # Fuzzy
	'srf-printername-graph' => 'Gràfich',
	'srf-paramdesc-graph-relation' => 'Ij soget o le propietà ëd nòm son-ne dij pare o dij fieuj?',
	'srf-paramdesc-graph-nameprop' => "A përmët d'amposté na propietà che a sarà dovrà com soget al pòst dël soget atual",
	'srf-paramdesc-graph-nodeshape' => 'La forma ëd minca vértes ant ël gràf',
	'srf_paramdesc_graphname' => 'Tìtol',
	'srf_paramdesc_graphsize' => 'Dimension dël graf (an pontin)',
	'srf_paramdesc_graphlegend' => 'Mostré la legenda dël graf o nò',
	'srf_paramdesc_graphlabel' => 'Tichëtta dël gràfich',
	'srf_paramdesc_rankdir' => 'Diression dla flecia',
	'srf_paramdesc_graphlink' => 'Liura al graf',
	'srf_paramdesc_graphcolor' => 'Color dël gràfich',
	'srf-paramdesc-graph-wwl' => "Lìmit dl'a cap automàtich dla paròla (an nùmer ëd caràter)",
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'srf-module-loading' => 'برسېرېدنې کې دی...',
	'srf-ui-tooltip-title-options' => 'خوښنې',
	'srfc_previousmonth' => 'پخوانۍ مياشت',
	'srfc_nextmonth' => 'راتلونکې مياشت',
	'srfc_today' => 'نن',
	'srfc_gotomonth' => 'مياشت ته ورځه',
	'srf-ui-gridview-label-info-tab' => 'مالومات',
	'srf_printername_gallery' => 'انځورتون',
	'srf-gallery-navigation-previous' => 'پخوانی',
	'srf-gallery-navigation-next' => 'راتلونکی',
	'srf-ui-eventcalendar-label-today' => 'نن',
	'srf-ui-eventcalendar-label-month' => 'مياشت',
	'srf-ui-eventcalendar-label-week' => 'اونۍ',
	'srf-ui-eventcalendar-label-day' => 'ورځ',
	'srf-ui-eventcalendar-label-allday' => 'ټوله ورځ',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 * @author Malafaya
 * @author SandroHc
 * @author Waldir
 */
$messages['pt'] = array(
	'srf-desc' => "Formatos adicionais para consultas de incorporação dinâmica ''(inline queries)'' do MediaWiki Semântico",
	'srf-name' => 'Formatos dos Resultados Semânticos',
	'srfc_previousmonth' => 'Mês anterior',
	'srfc_nextmonth' => 'Mês seguinte',
	'srfc_today' => 'Hoje',
	'srfc_gotomonth' => 'Ir para mês',
	'srf_printername_calendar' => 'Calendário mensal',
	'srf_paramdesc_calendarlang' => 'O código da língua em que será apresentado o calendário',
	'srf_printername_vcard' => 'exportação vCard',
	'srf_icalendar_link' => 'iCalendário',
	'srf_printername_icalendar' => 'exportação iCalendar',
	'srf_paramdesc_icalendartitle' => 'O título do ficheiro do calendário',
	'srf_paramdesc_icalendardescription' => 'A descrição do ficheiro do calendário',
	'srf_printername_bibtex' => 'exportação BibTeX',
	'srf_outline_novalue' => 'Nenhum valor',
	'srf_printername_outline' => 'Lista estruturada',
	'srf_paramdesc_outlineproperties' => 'A lista das propriedades apresentadas como cabeçalhos das listas estruturadas, separadas por vírgulas',
	'srf_printername_sum' => 'Soma dos números',
	'srf_printername_average' => 'Média dos números',
	'srf_printername_max' => 'Número máximo',
	'srf_printername_min' => 'Número mínimo',
	'srf_paramdesc_limit' => 'O número máximo de páginas a consultar',
	'srf_printername_product' => 'Produto dos números',
	'srf_printername_timeline' => 'Cronograma',
	'srf_printername_eventline' => 'Cronograma de eventos',
	'srf_paramdesc_timelinebands' => 'Define que bandas são apresentadas no resultado.',
	'srf_paramdesc_timelineposition' => 'Define onde é que o cronograma inicialmente está focado.',
	'srf_paramdesc_timelinestart' => 'Um nome de propriedade, usado para definir um primeiro ponto no tempo',
	'srf_paramdesc_timelineend' => 'Um nome de propriedade, usado para definir um segundo ponto no tempo',
	'srf_paramdesc_timelinesize' => 'A altura do cronograma',
	'srf-timeline-allresults' => 'Mais resultados desta consulta.',
	'srf-timeline-nojs' => 'Para ver o cronograma interactivo tem de activar o JavaScript.',
	'srf_paramdesc_views' => 'As vistas que serão apresentadas',
	'srf_paramdesc_facets' => 'O conjunto de propriedades que serão apresentadas para cada página',
	'srf_paramdesc_lens' => 'O nome de uma predefinição usada para apresentar as propriedades das páginas',
	'srf_printername_googlebar' => 'Gráfico de barras Google',
	'srf_printername_googlepie' => 'Gráfico circular Google',
	'srf_paramdesc_chartheight' => 'Altura do gráfico (em pixels)', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Largura do gráfico (em pixels)', # Fuzzy
	'srf_paramdesc_charttitle' => 'O título do gráfico',
	'srf_paramdesc_barcolor' => 'A cor das barras',
	'srf_paramdesc_bardirection' => 'Especifica a orientação do gráfico',
	'srf_paramdesc_barnumbersaxislabel' => 'A legenda para o eixo dos números',
	'srf_printername_gallery' => 'Galeria',
	'srf_paramdesc_perrow' => 'A quantidade de imagens por linha',
	'srf_paramdesc_widths' => 'A largura das imagens',
	'srf_paramdesc_heights' => 'A altura das imagens',
	'srf_paramdesc_autocaptions' => 'Usar o nome do ficheiro como legenda se esta não for fornecida',
	'srf_paramdesc_fileextensions' => 'Ao usar o nome do ficheiro como legenda, mostrar também a extensão',
	'srf_paramdesc_captionproperty' => 'O nome de uma propriedade semântica presente nas páginas consultadas para ser usado como legenda',
	'srf_paramdesc_imageproperty' => 'O nome de uma propriedade semântica nas páginas consultadas que aponta para imagens a usar. Quando definido, as próprias páginas consultadas não serão mostradas como imagens',
	'srf_printername_tagcloud' => 'Nuvem de tags',
	'srf_paramdesc_includesubject' => 'Se os nomes dos próprios temas devem ser incluídos',
	'srf_paramdesc_increase' => 'Como aumentar o tamanho das tags',
	'srf_paramdesc_tagorder' => 'A ordem das tags',
	'srf_paramdesc_mincount' => 'O número mínimo de vezes que um valor deve ocorrer, para ser listado',
	'srf_paramdesc_minsize' => 'O tamanho das tags menores, em percentagem',
	'srf_paramdesc_maxsize' => 'O tamanho das tags maiores, em percentagem',
	'srf_paramdesc_maxtags' => 'A quantidade máxima de tags na nuvem',
	'srf_printername_array' => 'Matriz',
	'srf_paramdesc_pagetitle' => 'Se deseja apresentar como resultados os títulos das páginas, ou omiti-los',
	'srf_paramdesc_hidegaps' => 'Se deseja apresentar os valores das propriedades e registos vazios separados por separadores ou escondê-los', # Fuzzy
	'srf_paramdesc_arrayname' => 'Se especificado e a ArrayExtension estiver disponível, isto criará uma matriz com o nome especificado', # Fuzzy
	'srf_paramdesc_propsep' => 'Separador entre as propriedades solicitadas',
	'srf_paramdesc_manysep' => 'Separador entre propriedades com mais do que um valor', # Fuzzy
	'srf_paramdesc_recordsep' => 'Separador entre os valores das propriedades do registo',
	'srf_printername_hash' => 'Resumo criptográfico ("hash")',
	'srf_paramdesc_hashname' => 'Se especificado e a extensão HashTables estiver disponível, isto cria um resumo criptográfico ("hash") com o nome especificado (sem saída visível)',
	'srf-printername-graph' => 'Grafo',
	'srf-paramdesc-graph-relation' => 'Os assuntos ("subjects") ou propriedades dos nomes ("nameproperties"), são pais ou filhos?',
	'srf-paramdesc-graph-nameprop' => 'Permite definir uma propriedade que será usada como assunto ("subject") em vez do verdadeiro assunto',
	'srf-paramdesc-graph-nodeshape' => 'A forma de cada vértice no grafo',
	'srf_paramdesc_graphname' => 'Título',
	'srf_paramdesc_graphsize' => 'Tamanho do grafo (em px)',
	'srf_paramdesc_graphlegend' => 'Mostrar ou não a legenda do grafo',
	'srf_paramdesc_graphlabel' => 'Título do grafo',
	'srf_paramdesc_rankdir' => 'Direcção da seta',
	'srf_paramdesc_graphlink' => 'Link do grafo',
	'srf_paramdesc_graphcolor' => 'Cor do grafo',
	'srf-paramdesc-graph-wwl' => 'Limite para forçar nova linha (em nº de caracteres)',
	'srf-printername-filtered' => 'Filtrado',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Eduardo.mps
 * @author GKnedo
 * @author Giro720
 * @author Jaideraf
 * @author Luckas Blade
 */
$messages['pt-br'] = array(
	'srf-desc' => 'Formatos adicionais para consultas embutidas do Semantic MediaWiki',
	'srf-name' => 'Semantic Result Formats',
	'prefs-srf' => 'Formatos de resultado semântico',
	'srf-module-loading' => 'Carregando...',
	'srf-paramdesc-layout' => 'Layout disponível',
	'srf-paramdesc-height' => 'Altura',
	'srf-paramdesc-width' => 'Largura',
	'srf-paramdesc-class' => 'Especifique uma classe CSS adicional',
	'srf-module-nomatch' => 'Nenhuma correspondência encontrada',
	'srf-paramdesc-charttype' => 'Tipo de gráfico disponível',
	'srf-navigation-previous' => 'Anterior',
	'srf-ui-navigation-prev' => 'Anterior',
	'srf-ui-navigation-next' => 'Proximo',
	'srf-ui-common-label-source' => 'Fonte',
	'srf-ui-common-label-datasource' => 'Fontes de dados',
	'srf-ui-common-label-ajax-error' => 'O servidor relatou uma falha na comunicação para este $1. Por favor, tente atualizar a página ou consultar com esse $2.',
	'srf-ui-common-label-request-object' => 'objeto solicitado',
	'srf-ui-common-label-help-section' => 'seção de ajuda',
	'srf-ui-tooltip-title-options' => 'Opções',
	'srf-ui-tooltip-title-scope' => 'Contexto',
	'srf-error-option-mix' => 'A opção ($1) não está disponível',
	'srf-error-option-link-all' => 'A opção ($1) requer o parâmetro "link" definido como "all"',
	'srf-error-missing-layout' => 'O layout está faltando',
	'srf-warn-empy-chart' => 'O quadro ou gráfico está vazio devido à dados ausentes',
	'srfc_previousmonth' => 'Mês anterior',
	'srfc_nextmonth' => 'Mês seguinte',
	'srfc_today' => 'Hoje',
	'srfc_gotomonth' => 'Ir para o mês',
	'srf_printername_calendar' => 'Calendário mensal',
	'srf_paramdesc_calendarlang' => 'O código de idioma em que será apresentado o calendário',
	'srf_paramdesc_calendarcolors' => 'A cor a ser exibida para cada propriedade de data (exemplo: "Start date=>green,End date=>#09c")',
	'srf_printername_vcard' => 'Exportar vCard',
	'srf_printername_icalendar' => 'Exportar iCalendar',
	'srf_paramdesc_icalendartitle' => 'O título do arquivo do calendário',
	'srf_paramdesc_icalendardescription' => 'A descrição do arquivo do calendário',
	'srf_printername_bibtex' => 'Exportar BibTeX',
	'srf_outline_novalue' => 'Nenhum valor',
	'srf_printername_outline' => 'Lista estruturada',
	'srf_paramdesc_outlineproperties' => 'A lista das propriedades a serem apresentadas como cabeçalhos das listas estruturadas, separadas por vírgulas',
	'srf_printername_sum' => 'Soma dos números',
	'srf_printername_average' => 'Média dos números',
	'srf_printername_max' => 'Número máximo',
	'srf_printername_min' => 'Número mínimo',
	'srf_paramdesc_limit' => 'O número máximo de páginas a serem consultadas',
	'srf_printername_product' => 'Produto dos números',
	'srf_printername_median' => 'Mediana dos números',
	'srf-paramdesc-default' => 'O valor padrão que será exibido quando não houver qualquer resultado numérico',
	'srf_printername_earliest' => 'Tempo mais antigo',
	'srf_printername_latest' => 'Tempo mais recente',
	'srf_printername_timeline' => 'Linha do tempo',
	'srf_printername_eventline' => 'Cronograma de eventos',
	'srf_paramdesc_timelinebands' => 'Define quais grupos são apresentadas nos resultados.',
	'srf_paramdesc_timelineposition' => 'Define onde é que o cronograma inicialmente está focado.',
	'srf_paramdesc_timelinestart' => 'Um nome de propriedade usado para definir um primeiro ponto no tempo.',
	'srf_paramdesc_timelineend' => 'Um nome de propriedade usado para definir um segundo ponto no tempo',
	'srf_paramdesc_timelinesize' => 'A altura do cronograma',
	'srf-timeline-allresults' => 'Mais resultados para esta consulta.',
	'srf-timeline-nojs' => 'Você precisa ter o JavaScript habilitado para visualizar a linha do tempo interativa.',
	'srf_paramdesc_views' => 'As visualizações a serem apresentadas',
	'srf_paramdesc_facets' => 'O conjunto de propriedades a ser apresentado para cada página',
	'srf_paramdesc_lens' => 'O nome de uma predefinição usada para apresentar as propriedades das páginas',
	'srf_printername_googlebar' => 'Gráfico de barras do Google',
	'srf_printername_googlepie' => 'Gráfico de pizza do Google',
	'srf-printername-jqplotchart' => ' Gráfico jqPlot',
	'srf-printername-jqplotseries' => 'Série jqPlot',
	'srf_paramdesc_chartheight' => 'Especifique a altura do gráfico ou quadro (em pixels)',
	'srf_paramdesc_chartwidth' => 'Especifique a largura do gráfico ou quadro (em pixels ou porcentagem)',
	'srf_paramdesc_charttitle' => 'O título do gráfico',
	'srf_paramdesc_barcolor' => 'Especifique as cores do quadro',
	'srf_paramdesc_bardirection' => 'Especifique a orientação do gráfico',
	'srf-paramdesc-direction' => 'Especifica a direção de um quadro ou gráfico',
	'srf_paramdesc_barnumbersaxislabel' => 'A legenda para o eixo dos números',
	'srf-paramdesc-labelaxislabel' => 'A legenda para o nome do eixo',
	'srf-paramdesc-ticklabels' => 'Habilitar exibição dos rótulos de seleção',
	'srf-paramdesc-minvalue' => 'O valor mínimo a ser mostrado no eixo y',
	'srf-paramdesc-pointlabels' => 'Exibir pontos de dados no gráfico',
	'srf-paramdesc-chartlegend' => 'Posição da legenda do gráfico',
	'srf-paramdesc-datalabels' => 'Rótulos dos dados do quadro/gráfico',
	'srf-paramdesc-charttext' => 'Texto descritivo do gráfico',
	'srf-paramdesc-chartclass' => 'Clase CSS adicional',
	'srf-paramdesc-renderer' => 'Selecione um renderizador de gráficos/quadros',
	'srf-paramdesc-filling' => 'Opção de preenchimento individual',
	'srf-paramdesc-theme' => 'Selecione um tema de grade',
	'srf-paramdesc-chartcolor' => 'Atribuir cores individuais ao gráfico',
	'srf-paramdesc-colorscheme' => 'Selecione um esquema de cores',
	'srf-paramdesc-valueformat' => 'Especifica regras de formatação para valores',
	'srf-paramdesc-highlighter' => 'Exibe um destaque de ponto de dados',
	'srf-paramdesc-smoothlines' => 'Aplica um algorítmo de suavização nos gráficos de linhas',
	'srf-paramdesc-stackseries' => 'Exibir o gráfico como uma série empilhada',
	'srf-paramdesc-seriesgroup' => 'Selecione grupos de séries',
	'srf-paramdesc-serieslabel' => 'Determina o rótulo da série',
	'srf-paramdesc-grouplabel' => 'Determina o rótulo do grupo',
	'srf-paramdesc-chartcursor' => 'Opção de exibição do cursor gráfico',
	'srf-paramdesc-trendline' => 'Habilita a exibição simultânea de um gráfico e suas linhas de tendência',
	'srf-paramdesc-gridview' => 'Exibe simultaneamente o gráfico e seus conjuntos de dados',
	'srf-paramdesc-infotext' => 'Exibe informações adicionais em uma aba correspondente',
	'srf-ui-gridview-label-item' => 'Item dos dados',
	'srf-ui-gridview-label-value' => 'Valor dos dados',
	'srf-ui-gridview-label-series' => 'Série de dados',
	'srf-ui-gridview-label-chart-tab' => 'Gráfico',
	'srf-ui-gridview-label-data-tab' => 'Dados',
	'srf-ui-gridview-label-info-tab' => 'Informações',
	'srf_printername_gallery' => 'Galeria',
	'srf_paramdesc_perrow' => 'A quantidade de imagens por linha',
	'srf_paramdesc_widths' => 'A largura das imagens',
	'srf_paramdesc_heights' => 'A altura das imagens',
	'srf_paramdesc_autocaptions' => 'Usar o nome do arquivo como legenda quando nenhum for fornecido',
	'srf_paramdesc_fileextensions' => 'Ao usar o nome do arquivo como legenda, mostrar também a extensão do arquivo',
	'srf_paramdesc_captionproperty' => 'O nome de uma propriedade semântica presente nas páginas consultadas para ser usado como legenda',
	'srf_paramdesc_imageproperty' => 'O nome de uma propriedade semântica nas páginas consultadas que aponta para imagens a usar. Quando definido, as próprias páginas consultadas não serão mostradas como imagens',
	'srf-paramdesc-redirects' => 'O nome de uma propriedade semântica nas páginas consultadas que contém o alvo do redirecionamento',
	'srf-paramdesc-navigation' => 'Controle do layout de navegação',
	'srf-paramdesc-overlay' => 'Habilitar a sobreposição de imagens',
	'srf-gallery-navigation-previous' => 'Anterior',
	'srf-gallery-navigation-next' => 'Próximo',
	'srf-gallery-overlay-count' => 'Imagem $1 de $2',
	'srf-gallery-image-url-error' => 'A imagem não foi encontrada.',
	'srf_printername_tagcloud' => 'Nuvem de tags',
	'srf_paramdesc_includesubject' => 'Se os nomes dos próprios sujeitos devem ser incluídos',
	'srf_paramdesc_increase' => 'Como aumentar o tamanho das tags',
	'srf_paramdesc_tagorder' => 'A ordem das tags',
	'srf_paramdesc_mincount' => 'O número mínimo de vezes que um valor deve ocorrer, para ser listado',
	'srf_paramdesc_minsize' => 'O tamanho das tags menores, em porcentagem',
	'srf_paramdesc_maxsize' => 'O tamanho das tags maiores, em porcentagem',
	'srf_paramdesc_maxtags' => 'A quantidade máxima de tags na nuvem',
	'srf-paramdesc-excludetags' => 'Excluir tags (delimitador: ;)',
	'srf_printername_valuerank' => 'Ranking de valores',
	'srf_printername_array' => 'Array',
	'srf_paramdesc_pagetitle' => 'Se deseja apresentar os títulos das páginas como resultados ou omiti-los',
	'srf_paramdesc_hidegaps' => 'Se deseja exibir os valores das propriedades e registros vazios separados por separadores ou omiti-los',
	'srf_paramdesc_arrayname' => 'Se especificado e a ArrayExtension estiver disponível, isso criará uma array com o nome especificado (nesse caso, sem uma saída visível)',
	'srf_paramdesc_propsep' => 'Separador entre as propriedades solicitadas',
	'srf_paramdesc_manysep' => 'Separador entre propriedades com mais de um valor',
	'srf_paramdesc_recordsep' => 'Separador entre valores de propriedades de registro',
	'srf_paramdesc_headersep' => 'Separador entre o nome e o valor da propriedade se "headers" estiver definido como "show" ou "plain"',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'Se especificado e a extensão HashTables estiver disponível, isso criará um hash com o nome especificado (nesse caso, sem uma saída visível)',
	'srf-printername-graph' => 'Gráfico',
	'srf-paramdesc-graph-relation' => 'Os sujeitos ou as propriedades dos nomes são pais ou filhos?',
	'srf-paramdesc-graph-nameprop' => 'Permite definir uma propriedade que será utilizada como sujeito ao invés do verdadeiro sujeito',
	'srf-paramdesc-graph-nodeshape' => 'A forma de cada nó no gráfico',
	'srf_paramdesc_graphname' => 'Título',
	'srf_paramdesc_graphsize' => 'Tamanho do gráfico (em pixels)',
	'srf_paramdesc_graphlegend' => 'Exibir ou não a legenda do gráfico',
	'srf_paramdesc_graphlabel' => 'Título do gráfico',
	'srf_paramdesc_rankdir' => 'Direção da seta',
	'srf_paramdesc_graphlink' => 'Link do gráfico',
	'srf_paramdesc_graphcolor' => 'Cor do gráfico',
	'srf-paramdesc-graph-wwl' => 'Limite para a quebra de linha (em número de caracteres)',
	'srf_printername_datatables' => 'DataTables',
	'srf-paramdesc-rowindex' => 'Índice de linha da tabela',
	'srf-paramdesc-displaylength' => 'Comprimento da exibição inicial',
	'srf_printername_tree' => 'Árvore',
	'srf_printername_ultree' => 'Árvore (marcadores)',
	'srf_printername_oltree' => 'Árvore (números)',
	'srf-noparentprop' => 'Nenhuma propriedade pai dada. A árvore não pode ser construída sem uma propriedade pai especificada.',
	'srf-paramdesc-parent' => 'A propriedade que contém a página pai',
	'srf-printername-slideshow' => 'SlideShow',
	'srf-paramdesc-delay' => 'O tempo entre os slides, em segundos',
	'srf-paramdesc-navigation-controls' => 'Mostrar ou não os controles de navegação',
	'srf-paramdesc-effect' => 'O efeito a ser utilizado para a transição de slides',
	'srf-printername-filtered' => 'Filtrado',
	'srf-paramdesc-filtered-views' => 'As visualizações que deverão estar disponíveis na exibição do resultado.',
	'srf-paramdesc-filtered-filter-position' => 'A posição dos filtros em relação às visualizações. Valores permitidos: top, bottom. Padrão: top.',
	'srf-paramdesc-filtered-list-type' => 'O tipo de lista. Valores permitidos: list, ul, ol. Padrão: list.',
	'srf-paramdesc-filtered-list-template' => 'A predefinição a ser utilizada para formatar as entradas da lista.',
	'srf-paramdesc-filtered-list-named-args' => 'Nomeie os argumentos passados para a predefinição',
	'srf-paramdesc-filtered-list-introtemplate' => 'Nome da predefinição a ser exibida antes dos resultados da consulta, se existir algum resultado.',
	'srf-paramdesc-filtered-list-outrotemplate' => 'Nome da predefinição a ser exibida após os resultados da consulta, se existir algum resultado.',
	'srf-paramdesc-filtered-calendar-start' => 'A exibição que contém a data de início de um evento',
	'srf-paramdesc-filtered-calendar-end' => 'A exibição que contém a data final de um evento',
	'srf-paramdesc-filtered-calendar-title' => 'A exibição que contém o título de um evento. Não pode ser utilizado junto com um título de uma predefinição.',
	'srf-paramdesc-filtered-calendar-title-template' => 'Uma predefinição utilizada para formatar o título do evento no calendário',
	'srf-filtered-selectorlabel-list' => 'Lista',
	'srf-filtered-selectorlabel-calendar' => 'Calendário',
	'srf-printername-d3chart' => 'Gráfico D3',
	'srf-printername-timeseries' => 'Gráfico de séries temporais',
	'srf-paramdesc-group' => 'Séries agrupadas por',
	'srf-paramdesc-zoom' => 'Ativar zoom',
	'srf-paramdesc-datatable' => 'Ativar uma tabela de dados',
	'srf-timeseries-zoom-out-of-range' => 'O alcance do zoom não produziu dados suficientes',
	'srf-printername-sparkline' => 'Gráfico Sparkline',
	'srf-printername-listwidget' => 'Listwidget',
	'srf-paramdesc-listtype' => 'Especificar o tipo de lista',
	'srf-paramdesc-widget' => 'Widget disponível',
	'srf-paramdesc-pageitems' => 'Itens por página',
	'srf-printername-eventcalendar' => 'Calendário de eventos',
	'srf-paramdesc-calendarfirstday' => 'O dia em que cada semana começa',
	'srf-paramdesc-calendardefaultview' => 'A exibição inicial quando o calendário carrega',
	'srf-paramdesc-calendarstart' => 'O começo do primeiro calendário',
	'srf-paramdesc-dayview' => 'Habilitar o modo de exibição do dia clicando no número do dia',
	'srf-ui-eventcalendar-label-today' => 'Hoje',
	'srf-ui-eventcalendar-label-month' => 'Mês',
	'srf-ui-eventcalendar-label-week' => 'Semana',
	'srf-ui-eventcalendar-label-day' => 'Dia',
	'srf-ui-eventcalendar-label-allday' => 'O dia todo',
	'srf-printername-dygraphs' => 'Gráfico Dygraphs',
	'srf-paramdesc-datasource' => 'Especificar a fonte em que os dados estão acessíveis (arquivo, URL, etc.)',
	'srf-paramdesc-errorbar' => 'Especificar a barra de erro utilizada (desvio-padrão (sigma), frações em lote ou uma barra personalizada variando de valores low;middle;high)',
	'srf-paramdesc-movingaverage' => 'Exibir a média ao longo de vários dias (zero indicará nenhuma média móvel)',
	'srf-paramdesc-yaxislabel' => 'Descrição que aparece no eixo y',
	'srf-paramdesc-xaxislabel' => 'Descrição que aparece no eixo x',
	'srf-paramdesc-unit' => 'Unidade',
	'srf-printername-pagewidget' => 'Widget de página',
	'srf-printername-incoming' => 'Propriedades afluentes',
	'srf-paramdesc-min' => 'Mínimo ou valor limite',
	'srf-paramdesc-excludeproperty' => 'Excluir a propriedade do conjunto de resultados',
);

/** Romanian (română)
 * @author KlaudiuMihaila
 */
$messages['ro'] = array(
	'srfc_previousmonth' => 'Luna anterioară',
	'srfc_nextmonth' => 'Luna următoare',
	'srfc_today' => 'Astăzi',
	'srf_printername_calendar' => 'Calendar lunar',
	'srf_printername_bibtex' => 'Export BibTeX',
	'srf_outline_novalue' => 'Nici o valoare',
	'srf_printername_sum' => 'Suma numerelor',
	'srf_printername_average' => 'Media numerelor',
	'srf_printername_max' => 'Numărul maxim',
	'srf_printername_min' => 'Numărul minim',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'srfc_previousmonth' => 'Mese precedende',
	'srfc_nextmonth' => 'Mese successive',
	'srfc_today' => 'Osce',
	'srfc_gotomonth' => "Va a 'u mese",
);

/** Russian (русский)
 * @author Ferrer
 * @author Haffman
 * @author Innv
 * @author Kaganer
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'srf-desc' => 'Дополнительные форматы для запросов Semantic MediaWiki',
	'srf-name' => 'Форматы семантических результатов',
	'srfc_previousmonth' => 'Предыдущий месяц',
	'srfc_nextmonth' => 'Следующий месяц',
	'srfc_today' => 'Сегодня',
	'srfc_gotomonth' => 'Перейти к месяцу',
	'srf_printername_calendar' => 'Ежемесячный календарь',
	'srf_paramdesc_calendarlang' => 'Код языка, на котором отображать календарь',
	'srf_printername_vcard' => 'Экспорт vCard',
	'srf_icalendar_link' => 'iКалендарь',
	'srf_printername_icalendar' => 'Экспорт iCalendar',
	'srf_paramdesc_icalendartitle' => 'Название файла календаря',
	'srf_paramdesc_icalendardescription' => 'Описание файла календаря',
	'srf_printername_bibtex' => 'Экспорт BibTeX',
	'srf_outline_novalue' => 'Нет значений',
	'srf_printername_outline' => 'Наброски',
	'srf_paramdesc_outlineproperties' => 'Список свойств, отображающихся в виде заголовков, разделяется запятыми',
	'srf_printername_sum' => 'Сумма чисел',
	'srf_printername_average' => 'Среднее число',
	'srf_printername_max' => 'Максимальное число',
	'srf_printername_min' => 'Минимальное число',
	'srf_paramdesc_limit' => 'Максимальное количество страниц для выборки',
	'srf_printername_timeline' => 'Хронология',
	'srf_printername_eventline' => 'Список событий',
	'srf_paramdesc_timelinebands' => 'Определяет, какие полосы будут отображены.',
	'srf_paramdesc_timelineposition' => 'Определяет какое место временной шкалы будет отображаться первоначально',
	'srf_paramdesc_timelinestart' => 'Имя свойства, используемое для определения первой временной точки',
	'srf_paramdesc_timelineend' => 'Имя свойства, используемое для определения второй временной точки',
	'srf_paramdesc_timelinesize' => 'Высота временной шкалы',
	'srf_paramdesc_views' => 'Виды для отображения',
	'srf_paramdesc_facets' => 'Набор свойств, отображаемых на каждой странице',
	'srf_paramdesc_lens' => 'Название шаблона для отображения свойств страницы',
	'srf_printername_googlebar' => 'Столбчатая диаграмма Google',
	'srf_printername_googlepie' => 'Круговая диаграмма Google',
	'srf_paramdesc_chartheight' => 'Высота диаграммы в пикселях', # Fuzzy
	'srf_paramdesc_chartwidth' => 'Ширина диаграммы в пикселях', # Fuzzy
	'srf_paramdesc_charttitle' => 'Название диаграммы',
	'srf_paramdesc_barcolor' => 'Цвет столбцов',
	'srf_paramdesc_bardirection' => 'Направление столбцов', # Fuzzy
	'srf_paramdesc_barnumbersaxislabel' => 'Надпись для числовых осей',
	'srf_printername_gallery' => 'Галерея',
	'srf_paramdesc_perrow' => 'Количество изображений в строке',
	'srf_paramdesc_widths' => 'Ширина изображений',
	'srf_paramdesc_heights' => 'Высота изображений',
	'srf_printername_tagcloud' => 'Облако меток',
	'srf_paramdesc_tagorder' => 'Порядок тегов',
	'srf_printername_array' => 'Массив',
);

/** Rusyn (русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'srfc_previousmonth' => 'Минулый місяць',
	'srfc_nextmonth' => 'Далшый місяць',
	'srfc_today' => 'Днесь',
	'srf_printername_gallery' => 'Ґалерія',
);

/** Sinhala (සිංහල)
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'srf-module-loading' => 'ප්‍රවේශනය වෙමින්...',
	'srf-module-nomatch' => 'කිසිදු ගැලපුමක් හමු නොවුණි',
	'srfc_previousmonth' => 'පෙර මාසය',
	'srfc_nextmonth' => 'මීළඟ මාසය',
	'srfc_today' => 'අද',
	'srfc_gotomonth' => 'මාසයට යන්න',
	'srf_printername_calendar' => 'මාසික දින දසුන',
	'srf_outline_novalue' => 'අගයක් නොමැත',
	'srf_printername_max' => 'උපරිම අංකය',
	'srf_printername_min' => 'අවම අංකය',
	'srf_printername_gallery' => 'ගැලරිය',
	'srf-gallery-navigation-previous' => 'පෙර',
	'srf-gallery-navigation-next' => 'මීළඟ',
	'srf-printername-graph' => 'ප්‍රස්තාරය',
	'srf_paramdesc_graphname' => 'මාතෘකාව',
	'srf_printername_tree' => 'වෘක්ෂය',
);

/** Slovak (slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'srf-desc' => 'Ďalšie formáty inline požiadaviek Semantic MediaWiki',
	'srf-name' => 'Formáty sémantických výsledkov',
	'srfc_previousmonth' => 'Predošlý mesiac',
	'srfc_nextmonth' => 'Ďalší mesiac',
	'srfc_today' => 'Dnes',
	'srfc_gotomonth' => 'Prejsť na mesiac',
	'srf_printername_calendar' => 'Mesačný kalendár',
	'srf_printername_vcard' => 'export vCard',
	'srf_printername_icalendar' => 'export iCalendar',
	'srf_printername_bibtex' => 'export BibTeX',
	'srf_outline_novalue' => 'Žiadna hodnota',
	'srf_printername_outline' => 'Náčrt',
	'srf_printername_sum' => 'Suma čísiel',
	'srf_printername_average' => 'Priemer čísiel',
	'srf_printername_max' => 'Maximálne číslo',
	'srf_printername_min' => 'Minimálne číslo',
	'srf_printername_timeline' => 'Časová os',
	'srf_printername_eventline' => 'Os udalostí',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'srfc_previousmonth' => 'Претходни месец',
	'srfc_nextmonth' => 'Следећи месец',
	'srfc_today' => 'Данас',
	'srfc_gotomonth' => 'Пређи на месец',
	'srf_printername_calendar' => 'Месечни календар',
	'srf_vcard_link' => 'vCard',
	'srf_icalendar_link' => 'iCalendar',
	'srf_bibtex_link' => 'BibTeX',
	'srf_outline_novalue' => 'Нема вредности',
	'srf_printername_sum' => 'Сума бројева',
	'srf_printername_average' => 'Средња вредност бројева',
	'srf_printername_max' => 'Највећи број',
	'srf_printername_min' => 'Најмањи број',
	'srf_printername_gallery' => 'Галерија',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 * @author Michaello
 */
$messages['sr-el'] = array(
	'srfc_previousmonth' => 'Prethodni mesec',
	'srfc_nextmonth' => 'Sledeći mesec',
	'srfc_today' => 'Danas',
	'srfc_gotomonth' => 'Pređi na mesec',
	'srf_printername_calendar' => 'Mesečni kalendar',
	'srf_vcard_link' => 'vCard',
	'srf_icalendar_link' => 'iCalendar',
	'srf_bibtex_link' => 'BibTeX',
	'srf_outline_novalue' => 'Nema vrednosti',
	'srf_printername_sum' => 'Suma brojeva',
	'srf_printername_average' => 'Srednja vrednost brojeva',
	'srf_printername_max' => 'Najveći broj',
	'srf_printername_min' => 'Najmanji broj',
	'srf_printername_gallery' => 'Galerija',
);

/** Swedish (svenska)
 * @author Dafer45
 * @author M.M.S.
 * @author Martinwiss
 * @author Per
 * @author Rotsee
 */
$messages['sv'] = array(
	'srf-desc' => 'Extra utskriftsformat för Semantic MediaWiki',
	'srf-name' => 'Semantiska resultatformat',
	'srf-module-loading' => 'Laddar...',
	'srf-paramdesc-layout' => 'Tillgänglig layout',
	'srf-paramdesc-height' => 'Höjd',
	'srf-paramdesc-width' => 'Bredd',
	'srf-paramdesc-class' => 'Ange ytterligare en CSS-klass som ska gälla för formatet',
	'srf-module-nomatch' => 'Inga sökresultat hittades',
	'srf-paramdesc-charttype' => 'Vilken diagramtyp som ska användas',
	'srf-navigation-previous' => 'Föregående',
	'srf-ui-navigation-prev' => 'Föreg.',
	'srf-ui-navigation-next' => 'Nästa',
	'srf-ui-common-label-datasource' => 'Datakälla',
	'srf-error-option-mix' => 'Alternativ ( $1 ) är inte tillgängligt',
	'srf-error-option-link-all' => 'För alternativ ($1) måste parametern "link" ges värdet "all"',
	'srf-error-missing-layout' => 'Layouten saknas',
	'srf-warn-empy-chart' => 'Det finns inget diagram eftersom data saknas',
	'srfc_previousmonth' => 'Föregående månad',
	'srfc_nextmonth' => 'Nästa månad',
	'srfc_today' => 'Idag',
	'srfc_gotomonth' => 'Gå till månad',
	'srf_printername_calendar' => 'Månadskalender',
	'srf_paramdesc_calendarlang' => 'Språkkoden för det språk som kalendern skall visas med',
	'srf_paramdesc_calendarcolors' => 'Färgen som ska visas för varje datum-egenskap (t.ex: "Start date=>green,End date=>#09c")',
	'srf_printername_vcard' => 'vCard-export',
	'srf_icalendar_link' => 'iKalender',
	'srf_printername_icalendar' => 'iCalendar-export',
	'srf_paramdesc_icalendartitle' => 'Titeln på kalenderfilen',
	'srf_paramdesc_icalendardescription' => 'Beskrivningen av kalenderfilen',
	'srf_printername_bibtex' => 'BibTeX-export',
	'srf_outline_novalue' => 'Inget värde',
	'srf_printername_outline' => 'Outline',
	'srf_paramdesc_outlineproperties' => 'En kommaseparerad lista med de egenskaper som ska visas som rubriker',
	'srf_printername_sum' => 'Summa av tal',
	'srf_printername_average' => 'Genomsnitt av tal',
	'srf_printername_max' => 'Största nummer',
	'srf_printername_min' => 'Minsta nummer',
	'srf_paramdesc_limit' => 'Högsta antal sidor att fråga',
	'srf_printername_product' => 'Produkt (multiplikation)',
	'srf_printername_median' => 'Medianvärde',
	'srf-paramdesc-default' => 'Standardvärde att visa när resultat saknas',
	'srf_printername_earliest' => 'Earliest time',
	'srf_printername_latest' => 'Latest time',
	'srf_printername_timeline' => 'Tidslinje',
	'srf_printername_eventline' => 'Händelselinje',
	'srf_paramdesc_timelinebands' => 'Anger vilka tidslinjer (t.ex. för vecka, dag, eller månad) som ska visas i resultatet.',
	'srf_paramdesc_timelineposition' => 'Anger tidpunkt för tidslinjens mittpunkt.',
	'srf_paramdesc_timelinestart' => 'En egenskap för första tidpunkten.',
	'srf_paramdesc_timelineend' => 'En egenskap för en andra tidpunkt.',
	'srf_paramdesc_timelinesize' => 'Tidslinjens höjd',
	'srf-timeline-allresults' => 'Visa ytterligare sökresultat för den här frågan.',
	'srf-timeline-nojs' => 'Du måste använda JavaScript för att kunna se den interaktiva tidslinjen.',
	'srf_paramdesc_views' => 'Vyer som ska visas',
	'srf_paramdesc_facets' => 'De egenskaper som ska visas för varje sida',
	'srf_paramdesc_lens' => 'Namnet på den mall som ska visa egenskaper från en sida',
	'srf_printername_googlebar' => 'Google stapeldiagram',
	'srf_printername_googlepie' => 'Google tårtdiagram',
	'srf-printername-jqplotchart' => 'jqPlot diagram',
	'srf-printername-jqplotseries' => 'jqPlot serier',
	'srf_paramdesc_chartheight' => 'Ange höjden (i pixlar) för diagrammet',
	'srf_paramdesc_chartwidth' => 'Ange bredden (i pixlar) för diagrammet',
	'srf_paramdesc_charttitle' => 'Namnet på diagrammet (dess titel)',
	'srf_paramdesc_barcolor' => 'Ange diagramfärger',
	'srf_paramdesc_bardirection' => 'Ange riktning för diagrammet',
	'srf-paramdesc-direction' => 'Ange riktning för diagrammet',
	'srf_paramdesc_barnumbersaxislabel' => 'Etiketten för tal-axeln',
	'srf-paramdesc-labelaxislabel' => 'Etiketten för sak-axeln',
	'srf-paramdesc-ticklabels' => 'Visa stödlinjer',
	'srf-paramdesc-minvalue' => 'Minsta värdet för Y-axeln',
	'srf-paramdesc-pointlabels' => 'Visa datapunkter',
	'srf-paramdesc-chartlegend' => 'Position för teckenförklaring',
	'srf-paramdesc-datalabels' => 'Diagrametiketter',
	'srf-paramdesc-charttext' => 'Beskrivande diagramtext',
	'srf-paramdesc-chartclass' => 'Ytterligare CSS-klass',
	'srf-paramdesc-renderer' => 'Välj diagram-ritare',
	'srf-paramdesc-filling' => 'Särskild ifyllnad',
	'srf-paramdesc-theme' => 'Välj rutnät',
	'srf-paramdesc-chartcolor' => 'Använd särskilda diagramfärger',
	'srf-paramdesc-colorscheme' => 'Välj färgpalett',
	'srf-paramdesc-valueformat' => 'Ange format för värden',
	'srf-paramdesc-highlighter' => 'Visa en "datapunkts-framhävare"',
	'srf-paramdesc-smoothlines' => 'Ange en lijneutjämningsalgoritm för linjediagram',
	'srf-paramdesc-stackseries' => 'Visa diagram som serier ovanpå varandra',
	'srf-paramdesc-seriesgroup' => 'Visa seriegrupperingar',
	'srf-paramdesc-serieslabel' => 'Ta reda på serieetiketten',
	'srf-paramdesc-grouplabel' => 'Ta reda på gruppetiketten',
	'srf-paramdesc-chartcursor' => 'Visningsalternativ för diagram-pekare',
	'srf-paramdesc-trendline' => 'Gör så att man kan visa diagrammet och dess trendlinje samtidigt',
	'srf-paramdesc-infotext' => 'Visa ytterligare information på informations-fliken', # Fuzzy
	'srf-ui-gridview-label-item' => 'Dataobjekt',
	'srf-ui-gridview-label-value' => 'Datavärde',
	'srf-ui-gridview-label-series' => 'Dataserie',
	'srf-ui-gridview-label-chart-tab' => 'Diagram',
	'srf-ui-gridview-label-data-tab' => 'Data',
	'srf-ui-gridview-label-info-tab' => 'Information',
	'srf_printername_gallery' => 'Bildgalleri',
	'srf_paramdesc_perrow' => 'Antal bilder per rad',
	'srf_paramdesc_widths' => 'Bildbredd',
	'srf_paramdesc_heights' => 'Bildhöjd',
	'srf_paramdesc_autocaptions' => 'Använd filnamnet som bildtext, om ingen annan bildtext angetts',
	'srf_paramdesc_fileextensions' => 'Skriv ut filändelser när bildnamn används som bildtext',
	'srf_paramdesc_captionproperty' => 'Namnet på den semantiska egenskap (som är närvarande på de efterfrågade sidorna) som ska användas som figurtext',
	'srf_paramdesc_imageproperty' => 'Namnet på en semantisk egenskap på den efterfrågade sidan som pekar på bilder som ska användas. När den här parametern är angiven så kommer de efterfrågade sidorna själv inte att visas som bilder',
	'srf-paramdesc-redirects' => 'Namnet på den semantiska egenskap som är närvarande på de efterfrågade sidorna som innehåller förflyttningsmålet',
	'srf-paramdesc-navigation' => 'Specificera navigation för layout',
	'srf-paramdesc-overlay' => 'Möjliggör bilder ovanpå',
	'srf-gallery-navigation-previous' => 'Föregående',
	'srf-gallery-navigation-next' => 'Nästa',
	'srf-gallery-overlay-count' => 'Bild $1 av $2',
	'srf-gallery-image-url-error' => 'Bilden hittades inte',
	'srf_printername_tagcloud' => 'Tag cloud',
	'srf_paramdesc_includesubject' => 'Ämnestexterna inkluderas',
	'srf_paramdesc_increase' => 'Hur man ökar storleken på orden',
	'srf_paramdesc_tagorder' => 'Ordens ordning',
	'srf_paramdesc_mincount' => 'Hur många gånger ett ord måste förekomma för att visas',
	'srf_paramdesc_minsize' => 'Storleken på det minsta ordet (i procent)',
	'srf_paramdesc_maxsize' => 'Storleken på det största ordet (i procent)',
	'srf_paramdesc_maxtags' => 'Den största mängden ord i molnet',
	'srf-paramdesc-excludetags' => 'Ord som ska uteslutas (avgränsare: ;)',
	'srf_printername_valuerank' => 'Value rank',
	'srf_printername_array' => 'Array',
	'srf_paramdesc_pagetitle' => 'Om man ska visa sidtitlar i resultatet eller inte',
	'srf_paramdesc_hidegaps' => 'Om man ska visa efterfrågade egenskaper och datavärden som saknas eller om de ska utelämnas',
	'srf_paramdesc_arrayname' => 'Skapar en array med det specificerade namnet om tillägget ArrayExtension har installerats (inget syns då)',
	'srf_paramdesc_propsep' => 'Avgränsare mellan de efterfrågade egenskaperna',
	'srf_paramdesc_manysep' => 'Avgränsare mellan egenskaper med många värden',
	'srf_paramdesc_recordsep' => 'Avgränsare mellan värden för dataegenskaper',
	'srf_paramdesc_headersep' => 'Avgränsare mellan egenskapsnamn och egenskapsvärde om "headers" har värdet "show" eller "plain"',
	'srf_printername_hash' => 'Hash',
	'srf_paramdesc_hashname' => 'Skapar en "hash" med namnet om tillägget HashTables är installerat (inget syns då).',
	'srf-printername-graph' => 'Diagram',
	'srf-paramdesc-graph-relation' => 'Är objekten eller namnegenskaperna ärvda, eller ärvs de?',
	'srf-paramdesc-graph-nameprop' => 'Möjliggör att en egenskap används som objekt istället för den faktiska egenskapen',
	'srf-paramdesc-graph-nodeshape' => 'Formen på varje nod i diagrammet',
	'srf_paramdesc_graphname' => 'Titel',
	'srf_paramdesc_graphsize' => 'Diagramstorlek (i punkter)',
	'srf_paramdesc_graphlegend' => 'Visa diagramets teckenförklaring (eller inte)',
	'srf_paramdesc_graphlabel' => 'Diagrametikett',
	'srf_paramdesc_rankdir' => 'Pilriktning',
	'srf_paramdesc_graphlink' => 'Diagramlänk',
	'srf_paramdesc_graphcolor' => 'Diagramfärg',
	'srf-paramdesc-graph-wwl' => 'Maximal längd för textlinje (i # bokstäver)',
	'srf_printername_datatables' => 'Datatabeller',
	'srf-paramdesc-rowindex' => 'Tabellrad index',
	'srf-paramdesc-displaylength' => 'Hur långt man ska visa i början',
	'srf_printername_tree' => 'Tree',
	'srf_printername_ultree' => 'Ultree',
	'srf_printername_oltree' => 'Oltree',
	'srf-noparentprop' => 'Ingen ärv egenskap given. Trädet kan inte skapas utan att man anger en ärvd egenskap.',
	'srf-paramdesc-parent' => 'Egenskapen som innehåller den ärvda sidan',
	'srf-printername-slideshow' => 'Bildvisning',
	'srf-paramdesc-delay' => 'Stunden mellan bilder (i sekunder)',
	'srf-paramdesc-navigation-controls' => 'Visa navigeringsknappar eller inte',
	'srf-paramdesc-effect' => 'Vilken effekt som ska visas när bilden byts',
	'srf-printername-filtered' => 'Filtrerad',
	'srf-paramdesc-views' => 'Vyerna som ska visas i resultatet.',
	'srf-printername-d3chart' => 'D3 diagram',
	'srf-printername-timeseries' => 'Tidsserie diagram',
	'srf-paramdesc-group' => 'Serie grupperad efter',
	'srf-paramdesc-zoom' => 'Använd zoom',
	'srf-paramdesc-datatable' => 'Använd datatabell',
	'srf-timeseries-zoom-out-of-range' => 'Zoom inom den angivna upplösningen gav ingen (eller inte tillräckligt med) data',
	'srf-printername-sparkline' => 'Sparkline diagram',
	'srf-printername-listwidget' => 'Listwidget',
	'srf-paramdesc-listtype' => 'Ange listtyp',
	'srf-paramdesc-widget' => 'Tillgängliga manicker (widget)',
	'srf-paramdesc-pageitems' => 'Antal per sida',
	'srf-printername-feed' => 'RSS/Atom flöde',
	'srf-paramdesc-feedtype' => 'Flödestyp',
	'srf-paramdesc-feedtitle' => 'Flödestitel',
	'srf-paramdesc-feeddescription' => 'Beskrivning av flöde',
	'srf-printername-eventcalendar' => 'Event calendar',
	'srf-paramdesc-calendarfirstday' => 'Första dagen i veckan',
	'srf-paramdesc-calendardefaultview' => 'Första läget när kalendern visas',
	'srf-paramdesc-calendarstart' => 'Valt datum när kalendern laddas',
	'srf-paramdesc-dayview' => 'Visa "dags-vyn" genom att klicka på numret för den dagen',
	'srf-ui-eventcalendar-label-today' => 'Idag',
	'srf-ui-eventcalendar-label-month' => 'Månad',
	'srf-ui-eventcalendar-label-week' => 'Vecka',
	'srf-ui-eventcalendar-label-day' => 'Dag',
	'srf-ui-eventcalendar-label-allday' => 'Hela dagen',
	'srf-printername-dygraphs' => 'Dygraphs diagram',
	'srf-paramdesc-datasource' => 'Ange källan där data är tillgängligt (fil, URL o.s.v.)',
	'srf-paramdesc-errorbar' => 'Definiera den "fel-stapel" som ska användas (standardavvikelse (sigma), diagram-fraktioner, eller en egendefinierad stapel med värden low;middle;high)',
	'srf-paramdesc-movingaverage' => 'Visa medelvärdet för ett visst antal dagar (zero innebär inget medelvärde)',
	'srf-paramdesc-yaxislabel' => 'Beskrivning som visas på y-axeln',
	'srf-paramdesc-xaxislabel' => 'Beskrivning som visas på x-axeln',
	'srf-paramdesc-unit' => 'Enhet',
	'srf-printername-pagewidget' => 'Pagewidget (sidomanick)',
	'srf-printername-incoming' => 'Ingående egenskaper',
	'srf-paramdesc-min' => 'Minsta värde eller tröskelvärdet',
	'srf-paramdesc-excludeproperty' => 'Uteslut egenskap från resultatet',
);

/** Tamil (தமிழ்)
 * @author Karthi.dr
 * @author Shanmugamp7
 */
$messages['ta'] = array(
	'srfc_previousmonth' => 'கடந்த மாதம்',
	'srfc_nextmonth' => 'அடுத்த மாதம்',
	'srfc_today' => 'இன்று',
	'srf_printername_calendar' => 'மாதாந்திர நாட்காட்டி',
	'srf_printername_gallery' => 'காட்சியகம்',
	'srf-gallery-navigation-previous' => 'முந்தைய',
	'srf-gallery-navigation-next' => 'அடுத்தது',
	'srf_paramdesc_graphname' => 'தலைப்பு',
	'srf-paramdesc-listtype' => 'பட்டியல் வகை', # Fuzzy
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'srf-paramdesc-height' => 'ఎత్తు',
	'srf-paramdesc-width' => 'వెడల్పు',
	'srfc_previousmonth' => 'క్రితం నెల',
	'srfc_nextmonth' => 'తర్వాతి నెల',
	'srfc_today' => 'ఈరోజు',
	'srfc_gotomonth' => 'నెలకి వెళ్ళండి',
	'srf_outline_novalue' => 'విలువ లేదు',
	'srf_printername_sum' => 'సంఖ్యల మొత్తం',
	'srf_printername_average' => 'సంఖ్యల సగటు',
	'srf_printername_max' => 'గరిష్ఠ సంఖ్య',
	'srf_printername_min' => 'కనిష్ఠ సంఖ్య',
	'srf_printername_timeline' => 'కాలరేఖ',
	'srf_paramdesc_chartheight' => 'చార్టు యొక్క ఎత్తు, పిక్సెళ్ళలో', # Fuzzy
	'srf_paramdesc_chartwidth' => 'చార్టు యొక్క వెడల్పు, పిక్సెళ్ళలో', # Fuzzy
	'srf_paramdesc_graphname' => 'శీర్షిక',
);

/** Tajik (Cyrillic script) (тоҷикӣ)
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'srfc_previousmonth' => 'Моҳи қаблӣ',
	'srfc_nextmonth' => 'Моҳи баъдӣ',
	'srfc_today' => 'Имрӯз',
	'srfc_gotomonth' => 'Рафтан ба моҳ',
);

/** Tajik (Latin script) (tojikī)
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'srfc_previousmonth' => 'Mohi qablī',
	'srfc_nextmonth' => "Mohi ba'dī",
	'srfc_today' => 'Imrūz',
	'srfc_gotomonth' => 'Raftan ba moh',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 * @author Sky Harbor
 */
$messages['tl'] = array(
	'srf-desc' => 'Dagdag na mga anyo para sa nasa loob ng guhit na mga pagtatanong na pang-Semantikong MediaWiki',
	'srf-name' => 'Mga Anyo ng Resultang Semantiko',
	'srf-module-loading' => 'Ikinakarga...',
	'srf-paramdesc-layout' => 'Makukuhang kalatagan',
	'srf-paramdesc-height' => 'Taas',
	'srf-paramdesc-width' => 'Lapad',
	'srf-paramdesc-class' => 'Tumukoy ng isang karagdagang klase ng mga pilas ng lumalagaslas na estilo',
	'srf-module-nomatch' => 'Walang natagpuang mga pagtutugma',
	'srf-paramdesc-charttype' => 'Makukuhang uri ng talangguhit',
	'srf-error-option-mix' => 'Hindi makukuha ang napili ($1)',
	'srf-error-option-link-all' => 'Ang mapagpipilian ($1) ay nangangailangan ng parametrong "link" na maitakda bilang "all"',
	'srf-error-missing-layout' => 'Nawawala ang kalatagan',
	'srf-warn-empy-chart' => 'Ang talaguhitan/talangguhit ay walang laman dahil sa nawawalang dato',
	'srfc_previousmonth' => 'Nakaraang buwan',
	'srfc_nextmonth' => 'Susunod na buwan',
	'srfc_today' => 'Ngayong araw na ito',
	'srfc_gotomonth' => 'Pumunta sa buwan',
	'srf_printername_calendar' => 'Buwanang kalendaryo',
	'srf_paramdesc_calendarlang' => 'Ang kodigo para sa wika na pagpapakitaan ng kalendaryo',
	'srf_paramdesc_calendarcolors' => 'Ang kulay na ipapakita para sa bawat isang pag-aaring petsa (halimbawa: "Petsa ng simula=>green,Petsa ng wakas=>#09c")',
	'srf_vcard_link' => 'vCard',
	'srf_printername_vcard' => 'Luwas ng vCard',
	'srf_icalendar_link' => 'iCalendar',
	'srf_printername_icalendar' => 'Luwas ng iCalendar',
	'srf_paramdesc_icalendartitle' => 'Ang pamagat ng talaksan ng kalendaryo',
	'srf_paramdesc_icalendardescription' => 'Ang paglalarawan ng talaksan ng kalendaryo',
	'srf_bibtex_link' => 'BibTeX',
	'srf_printername_bibtex' => 'Luwas ng BibTeX',
	'srf_outline_novalue' => 'Walang halaga',
	'srf_printername_outline' => 'Banghay',
	'srf_paramdesc_outlineproperties' => 'Ang talaan ng mga pag-aaring ipapakita bilang mga paulong banghay, na pinaghihiwalay ng mga kuwit',
	'srf_printername_sum' => 'kabuuan ng mga bilang',
	'srf_printername_average' => 'Pinatakang halaga ng mga bilang',
	'srf_printername_max' => 'Pinakamataas na bilang',
	'srf_printername_min' => 'Pinakamababang bilang',
	'srf_paramdesc_limit' => 'Ang pinakamaraming bilang ng mga pahinang ipagtatanong',
	'srf_printername_product' => 'Produkto ng mga bilang',
	'srf_printername_median' => 'Panggitna ng mga bilang',
	'srf-paramdesc-default' => 'Ang likas na nakatakdang halaga na ipapakita kapag walang mga resultang pambilang',
	'srf_printername_earliest' => 'Pinaka maagang oras',
	'srf_printername_latest' => 'Pinaka huling oras',
	'srf_printername_timeline' => 'Guhit ng panahon',
	'srf_printername_eventline' => 'Guhit ng kaganapan',
	'srf_paramdesc_timelinebands' => 'Tumutukoy kung aling mga sintas ang ipapakita sa loob ng resulta.',
	'srf_paramdesc_timelineposition' => 'Tumutukoy kung saan unang tutuon ang guhit ng panahon.',
	'srf_paramdesc_timelinestart' => 'Isang pangalan ng pag-aaring ginamit upang tukuyin ang isang unang punto ng oras',
	'srf_paramdesc_timelineend' => 'Isang pangalan ng pag-aaring ginamit upang tukuyin ang isang pangalawang punto ng oras',
	'srf_paramdesc_timelinesize' => 'Ang taas ng guhit ng panahon',
	'srf-timeline-allresults' => 'Karagdagang mga resulta para sa pagsisiyasat na ito.',
	'srf-timeline-nojs' => 'Kailangan mong paganahin ang JavaScript upang makita ang masiglang guhit ng panahon.',
	'srf_paramdesc_views' => 'Mga tanawing ipapakita',
	'srf_paramdesc_facets' => 'Ang pangkat ng mga pag-aaring ipapakita para sa bawat pahina',
	'srf_paramdesc_lens' => 'Ang pangalan ng isang suleras na pagpapakitaan ng mga pag-aari ng pahina',
	'srf_printername_googlebar' => 'Baretang tsart ng Google',
	'srf_printername_googlepie' => 'Kakaning-tsart ng Google',
	'srf-printername-jqplotchart' => 'Talangguhit ng jqPlot',
	'srf-printername-jqplotseries' => 'Mga serye ng jqPlot',
	'srf_paramdesc_chartheight' => 'Tukuyin ang taas ng (na nasa mga piksel) ng isang talangguhit o talaguhitan',
	'srf_paramdesc_chartwidth' => 'Tukuyin ang lapad (na nasa mga piksel o bahagdan) ng isang talangguhit o talaguhitan',
	'srf_paramdesc_charttitle' => 'Ang pamagat ng talangguhit',
	'srf_paramdesc_barcolor' => 'Ang kulay ng mga bareta',
	'srf_paramdesc_bardirection' => 'Tukuyin ang kapupuntahan ng isang talangguhit',
	'srf-paramdesc-direction' => 'Tukuyin ang kapupuntahan ng isang talangguhit o talaguhitan',
	'srf_paramdesc_barnumbersaxislabel' => 'Ang tatak para sa painugan ng mga bilang',
	'srf-paramdesc-labelaxislabel' => 'Ang tatak para sa painugan ng mga tatak',
	'srf-paramdesc-ticklabels' => 'Paganahin ang pagpapakita ng mga tatak ng tsek',
	'srf-paramdesc-minvalue' => 'Ang pinaka mababang halaga na ipapakita sa ibabaw ng aksis na Y',
	'srf-paramdesc-pointlabels' => 'Ipakita ang mga tuldok ng dato na nasa loob ng talangguhit',
	'srf-paramdesc-chartlegend' => 'Puwesto ng paliwanag para sa talangguhit',
	'srf-paramdesc-datalabels' => 'Mga katatakan ng dato ng talangguhit/talaguhitan',
	'srf-paramdesc-charttext' => 'Mapaglarawang teksto ng talangguhit',
	'srf-paramdesc-chartclass' => 'Karagdagang klase ng Mga Pilas ng Lumalagaslas na Estilo',
	'srf-paramdesc-renderer' => 'Pumili ng isang tagapagharap ng talaguhitan/talangguhit',
	'srf-paramdesc-filling' => 'Indibiduwal na magpipilian ng pampuno',
	'srf-paramdesc-theme' => 'Pumili ng isang tema ng parilya',
	'srf-paramdesc-chartcolor' => 'Magtalaga ng mga kulay ng indibiduwal na talangguhit',
	'srf-paramdesc-colorscheme' => 'Pumili ng isang panukala ng kulay',
	'srf-paramdesc-valueformat' => 'Tukuyin ang patakaran ng pagsasaayos ng mga halaga',
	'srf-paramdesc-highlighter' => 'Magpakita ng isang pampaliwanag ng tuldok ng dato',
	'srf-paramdesc-smoothlines' => 'Maglapat ng isang algoritmong pampakinis sa ibabaw ng mga talangguhit na paguhit',
	'srf-paramdesc-stackseries' => 'Ipakita ang talangguhit bilang mga seryeng nakasalansan',
	'srf-paramdesc-seriesgroup' => 'Piliin ang pagkakapangkat ng mga serye',
	'srf-paramdesc-serieslabel' => 'Alamin ang katatakan ng serye',
	'srf-paramdesc-grouplabel' => 'Alamin ang tatak ng pangkat',
	'srf-paramdesc-chartcursor' => 'Mapipili na pangtanghal ng panturo ng talangguhit',
	'srf-paramdesc-trendline' => 'Paganahin ang sabay-sabay na pagpapakita ng isang talangguhit at ang guhit ng kalakaran nito',
	'srf-ui-gridview-label-item' => 'Bagay na pandatos',
	'srf-ui-gridview-label-value' => 'Halaga ng dato',
	'srf-ui-gridview-label-series' => 'Mga serye ng dato',
	'srf-ui-gridview-label-chart-tab' => 'Talangguhit',
	'srf-ui-gridview-label-data-tab' => 'Datos',
	'srf_printername_gallery' => 'Galerya',
	'srf_paramdesc_perrow' => 'Ang dami ng mga larawan bawat hilera',
	'srf_paramdesc_widths' => 'Ang lapad ng mga larawan',
	'srf_paramdesc_heights' => 'Ang taas ng mga larawan',
	'srf_paramdesc_autocaptions' => 'Gamitin ang pangalan ng talaksan bilang paliwag kapag walang ibinigay',
	'srf_paramdesc_fileextensions' => 'Kapag ginagamit ang pangalan ng talaksan bilang paliwanag, ipakita rin ang dugtong ng talaksan',
	'srf_paramdesc_captionproperty' => 'Ang pangalan ng isang kaariang semantiko naroroon sa ibabaw ng mga pahinang siniyasat na gagamitin bilang paliwanag',
	'srf_paramdesc_imageproperty' => 'Pangalan ng isang kaariang semantiko sa ibabaw ng mga pahina siniyasat na tumuturo sa mga imaheng gagamitin. Kapag nakatakda, ang mga pahina siniyasat mismo ay hindi ipapakita sa mga imahe',
	'srf-paramdesc-redirects' => 'Ang pangalan ng isang semantikong kaariang naroon sa inuusisang mga pahina na naglalaman ng pinupukol na pagpunta sa ibang lugar',
	'srf-paramdesc-navigation' => 'Pantaban sa kalatagan ng panglibot',
	'srf-paramdesc-overlay' => 'Paganahin ang kalupkop ng imahe',
	'srf-gallery-navigation-previous' => 'Nakaraan',
	'srf-gallery-navigation-next' => 'Susunod',
	'srf-gallery-overlay-count' => 'Imaheng $1 ng $2',
	'srf-gallery-image-url-error' => 'Hindi natagpuan ang larawan.',
	'srf_printername_tagcloud' => 'Ulap ng tatak',
	'srf_paramdesc_includesubject' => 'Kung dapat bang isama ang mga pangalan ng mga paksa mismo',
	'srf_paramdesc_increase' => 'Paano patataasin ang sukat ng mga tatak',
	'srf_paramdesc_tagorder' => 'Ang pagkakasunud-sunod ng mga tatak',
	'srf_paramdesc_mincount' => 'Ang pinaka mababang dami ng ulit na kailangang lumitaw ang isang halaga upang mailista',
	'srf_paramdesc_minsize' => 'Ang sukat ng pinaka maliit na mga tatak na nasa bahagdan',
	'srf_paramdesc_maxsize' => 'Ang sukat ng pinaka malaking mga tatak na nasa bahagdan',
	'srf_paramdesc_maxtags' => 'Ang pinaka mataas na dami ng mga tatak na nasa loob ng ulap',
	'srf-paramdesc-excludetags' => 'Huwag isali ang mga tatak (panghangga: ;)',
	'srf_printername_valuerank' => 'Ranggo ng halaga',
	'srf_printername_array' => 'Hanay',
	'srf_paramdesc_pagetitle' => 'Kung ipapakita ba ang mga pamagat ng pahina bilang resultang mga lahok o huwag isali ang mga ito',
	'srf_paramdesc_hidegaps' => 'Kung ililimbag ba ang hiniling ngunit hindi makukuhang kaarian at mga halaga ng pagtatala na pinaghihiwalay-hiwalay ng mga panghiwalay o hindi pagsasali ng mga ito',
	'srf_paramdesc_arrayname' => 'Kapag ibinigay at kung makukuha ang Dugtong ng Hanay, lilikha ito ng isang hanay na mayroong tinukoy na pangalan (wala pang makikitang kinalabasan noon)',
	'srf_paramdesc_propsep' => 'Panghiwalay sa pagitan ng hiniling na mga kaarian',
	'srf_paramdesc_manysep' => 'Panghiwalay sa pagitan ng maraming pinahahalagahang mga halaga ng ari-arian',
	'srf_paramdesc_recordsep' => 'Panghiwalay sa pagitan ng mga halaga ng mga pag-aari ng katalaan',
	'srf_paramdesc_headersep' => 'Panghiwalay sa pagitan ng pangalan ng kaarian at halaga kapag ang "headers" ay nakatakda sa "show" o "plain"',
	'srf_printername_hash' => 'Muling paghahayag',
	'srf_paramdesc_hashname' => 'Kapag ibinigay at kung makukuha ang Talahanayan ng Kahaluan, lilikha ito ng isang kahaluan na mayroong tinukoy na pangalan (wala pang makikitang kinalabasan noon)',
	'srf-printername-graph' => 'Talangguhit',
	'srf-paramdesc-graph-relation' => 'Mga magulang ba o mga anak ang mga paksa o mga kaarian ng pangalan?',
	'srf-paramdesc-graph-nameprop' => 'Nagpapahintulot ng pagtatakda ng isang pag-aari na gagamitin bilang paksa sa halip na ang talagang paksa',
	'srf-paramdesc-graph-nodeshape' => 'Ang hugis ng bawat buko sa ibabaw ng talangguhit',
	'srf_paramdesc_graphname' => 'Pamagat',
	'srf_paramdesc_graphsize' => 'Sukat ng talangguhit (nasa px)',
	'srf_paramdesc_graphlegend' => 'Ipakita ang alamat ng talangguhit o hindi',
	'srf_paramdesc_graphlabel' => 'Tatak ng talangguhit',
	'srf_paramdesc_rankdir' => 'Patutunguhan ng palaso',
	'srf_paramdesc_graphlink' => 'Kawing ng talangguhit',
	'srf_paramdesc_graphcolor' => 'Kulay ng talangguhit',
	'srf-paramdesc-graph-wwl' => 'Hangganan ng balot ng salita (sa loob ng # mga panitik)',
	'srf_printername_datatables' => 'Mga Talahanayan ng Dato',
	'srf-paramdesc-rowindex' => 'Talatuntunan ng hilera ng talahanayan',
	'srf-paramdesc-displaylength' => 'Paunang haba ng pagpapakita',
	'srf_printername_tree' => 'Puno',
	'srf_printername_ultree' => 'Puno na ang listahan ay walang pagkakasunud-sunod',
	'srf_printername_oltree' => 'Puno na ang listahan ay may pagkakasunud-sunod',
	'srf-noparentprop' => 'Walang ibinigay na magulang na kaarian. Ang puno ay hindi maaaring buuin na wala ang isang tinukoy na magulang na kaarian.',
	'srf-paramdesc-parent' => 'Ang pag-aari na naglalaman ng magulang na pahina',
	'srf-printername-slideshow' => 'Palabas na Dumudulas',
	'srf-paramdesc-delay' => 'Ang pag-antala sa pagitan ng mga padulas na nasa mga segundo',
	'srf-paramdesc-navigation-controls' => 'Ipakita o huwag ipakita ang mga pantaban ng paglilibot',
	'srf-paramdesc-effect' => 'Ang epektong gagamitin upang magpalipat-lipat mula sa bawat isang padulas',
	'srf-printername-filtered' => 'Nasala na',
	'srf-paramdesc-views' => 'Ang mga tanawin na magiging makukuha sa loob ng pakitaan ng resulta.',
	'srf-printername-d3chart' => 'Talangguhit ng D3',
	'srf-printername-timeseries' => 'Talangguhit ng pagkakasunud-sunod ng panahon',
	'srf-paramdesc-group' => 'Pinagpangkat-pangkat ang mga serye ayon sa',
	'srf-paramdesc-zoom' => 'Paganahin ang paglapit na nakatutok',
	'srf-paramdesc-datatable' => 'Paganahin ang isang talahanayan ng dato',
	'srf-timeseries-zoom-out-of-range' => 'Ang saklaw ng paglapit na nakatutok ay hindi nakagawa ng anumang sapat na dato',
	'srf-printername-sparkline' => 'Mga guhit ng pagkisap', # Fuzzy
	'srf-printername-listwidget' => 'Widyet ng lista',
	'srf-paramdesc-listtype' => 'Tukuyin ang uri ng tala',
	'srf-paramdesc-widget' => 'Makukuhang widyet',
	'srf-paramdesc-pageitems' => 'Mga bagay sa bawat pahina',
	'srf-printername-feed' => 'Pakain na RSS/Atom',
	'srf-paramdesc-feedtype' => 'Uri ng pakain',
	'srf-paramdesc-feedtitle' => 'Pamagat ng pakain',
	'srf-paramdesc-feeddescription' => 'Paglalarawan ng pakain',
	'srf-printername-eventcalendar' => 'Kalendaryo ng pangyayari',
	'srf-paramdesc-calendarfirstday' => 'Ang araw na pinagsisimulan ng bawat isang linggo',
	'srf-paramdesc-calendardefaultview' => 'Ang paunang pagpapatanaw kapag kumarga na ang kalendaryo',
	'srf-paramdesc-dayview' => 'Paganahin ang pagpapatanaw ng araw sa pamamagitan ng paglagitik sa bilang ng araw',
);

/** Turkish (Türkçe)
 * @author Joseph
 * @author Karduelis
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'srf-name' => 'Anlamsal Sonuç Bilimleri',
	'srfc_previousmonth' => 'Önceki ay',
	'srfc_nextmonth' => 'Sonraki ay',
	'srfc_today' => 'Bugün',
	'srfc_gotomonth' => 'Aya git',
	'srf_printername_calendar' => 'Aylık takvim',
	'srf_printername_vcard' => 'vCard dışa aktarımı',
	'srf_printername_icalendar' => 'iCalendar dışa aktarımı',
	'srf_paramdesc_icalendartitle' => 'Takvim dosyasının başlığı',
	'srf_paramdesc_icalendardescription' => 'Takvim dosyasının tanımı',
	'srf_outline_novalue' => 'Değer yok',
	'srf_printername_sum' => 'Sayıların toplamı',
	'srf_printername_average' => 'Sayılan ortalaması',
	'srf_printername_max' => 'Azami sayı',
	'srf_printername_min' => 'Asgari sayı',
	'srf_paramdesc_limit' => 'Sorgulanacak azami sayfa sayısı', # Fuzzy
	'srf_printername_timeline' => 'Zaman çizgisi',
	'srf_paramdesc_views' => 'Görüntülenecek görünümler',
	'srf_printername_googlebar' => 'Google çubuk çizelgesi',
	'srf_printername_googlepie' => 'Google dilim çizelgesi',
);

/** Central Atlas Tamazight (ⵜⴰⵎⴰⵣⵉⵖⵜ)
 * @author Tifinaghes
 */
$messages['tzm'] = array(
	'srf-filtered-selectorlabel-list' => 'ⵓⵎⵓⵖ',
);

/** Urdu (اردو)
 * @author පසිඳු කාවින්ද
 */
$messages['ur'] = array(
	'srf-module-loading' => 'لوڈ ہو رہا ہے...',
	'srfc_previousmonth' => 'پچھلے ماہ',
	'srfc_nextmonth' => 'اگلے ماہ',
	'srfc_today' => 'آج',
	'srfc_gotomonth' => 'مہینے پر جائیں',
	'srf_printername_calendar' => 'ماہانہ کیلنڈر',
	'srf-gallery-navigation-previous' => 'پچھلے',
	'srf-gallery-navigation-next' => 'اگلے',
	'srf_paramdesc_graphname' => 'عنوان',
);

/** Uzbek (oʻzbekcha)
 * @author CoderSI
 */
$messages['uz'] = array(
	'srf-ui-gridview-label-info-tab' => "Ma'lumot",
);

/** vèneto (vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'srfc_previousmonth' => 'Mese preçedente',
	'srfc_nextmonth' => 'Mese sucessivo',
	'srfc_today' => 'Ancuó',
	'srfc_gotomonth' => 'Và al mese',
);

/** Veps (vepsän kel’)
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'srfc_previousmonth' => 'Edeline ku',
	'srfc_nextmonth' => "Jäl'ghine ku",
	'srfc_today' => 'Tämbei',
	'srfc_gotomonth' => 'Mända kunnoks',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 * @author පසිඳු කාවින්ද
 */
$messages['vi'] = array(
	'srf-desc' => 'Các định dạng bổ sung cho các câu truy vấn trong dòng lệnh của MediaWiki Ngữ nghĩa',
	'srf-name' => 'Định dạng Kết quả Ngữ nghĩa',
	'srf-module-loading' => 'Đang tải…',
	'srfc_previousmonth' => 'Tháng trước',
	'srfc_nextmonth' => 'Tháng sau',
	'srfc_today' => 'Hôm nay',
	'srfc_gotomonth' => 'Đến tháng',
	'srf_printername_calendar' => 'Lịch tháng',
	'srf_printername_vcard' => 'Xuất vCard',
	'srf_printername_icalendar' => 'Xuất iCalendar',
	'srf_printername_bibtex' => 'Xuất BibTeX',
	'srf_outline_novalue' => 'Vô giá trị',
	'srf_printername_outline' => 'Khái quát',
	'srf_printername_sum' => 'Tổng số',
	'srf_printername_average' => 'Trung bình số',
	'srf_printername_max' => 'Số lớn nhất',
	'srf_printername_min' => 'Số nhỏ nhất',
	'srf_printername_timeline' => 'Thời gian biểu',
	'srf_printername_eventline' => 'Sự kiện biểu',
	'srf-gallery-navigation-previous' => 'Trước',
	'srf-gallery-navigation-next' => 'Tiếp theo',
	'srf_paramdesc_graphname' => 'Tựa đề',
);

/** Volapük (Volapük)
 * @author Malafaya
 * @author Smeira
 */
$messages['vo'] = array(
	'srfc_previousmonth' => 'Mul büik',
	'srfc_nextmonth' => 'Mul sököl',
	'srfc_today' => 'Adelo',
	'srfc_gotomonth' => 'Lü mul',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'srfc_previousmonth' => 'פֿאריגער חודש',
	'srfc_nextmonth' => 'נעקסטער חודש',
	'srfc_today' => 'הײַנט',
	'srf_paramdesc_graphname' => 'טיטל',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Gzdavidwong
 * @author Liangent
 * @author Linforest
 */
$messages['zh-hans'] = array(
	'srf-desc' => 'Semantic MediaWiki嵌入式查询的附加格式',
	'srf-name' => '语义结果格式',
	'srf-warn-empy-chart' => '该图表未被显示是因为其中没有可加以显示的结果。', # Fuzzy
	'srfc_previousmonth' => '上月',
	'srfc_nextmonth' => '下月',
	'srfc_today' => '今天',
	'srfc_gotomonth' => '跳至月份',
	'srf_printername_calendar' => '月历',
	'srf_paramdesc_calendarlang' => '显示日历的语言代码',
	'srf_paramdesc_calendarcolors' => '每个日期属性的显示颜色（示例："Start date=>green,End date=>#09c"）',
	'srf_printername_vcard' => 'vCard导出',
	'srf_printername_icalendar' => 'iCalendar导出',
	'srf_paramdesc_icalendartitle' => '日历文件的标题',
	'srf_paramdesc_icalendardescription' => '日历文件的说明',
	'srf_printername_bibtex' => 'BibTeX导出',
	'srf_outline_novalue' => '没有取值',
	'srf_printername_outline' => '大纲',
	'srf_paramdesc_outlineproperties' => '要显示为大纲标题的属性列表，以逗号分隔',
	'srf_printername_sum' => '数值之和',
	'srf_printername_average' => '数值的平均值',
	'srf_printername_max' => '最大数目',
	'srf_printername_min' => '最小数目',
	'srf_paramdesc_limit' => '所要查询页面的最大数量',
	'srf_printername_product' => '数值的乘积',
	'srf_printername_median' => '数值的中位数',
	'srf-paramdesc-default' => '没有数值型结果时将会显示的默认值',
	'srf_printername_timeline' => '时间轴',
	'srf_printername_eventline' => '事件轴',
	'srf_paramdesc_timelinebands' => '定义在结果当中显示哪些条带。',
	'srf_paramdesc_timelineposition' => '定义时间轴最初的焦点位于何处。',
	'srf_paramdesc_timelinestart' => '用来定义第一个时间点的属性名称',
	'srf_paramdesc_timelineend' => '用来定义第二个时间点的属性名称',
	'srf_paramdesc_timelinesize' => '时间轴高度',
	'srf-timeline-allresults' => '此查询的进一步结果。',
	'srf-timeline-nojs' => '要查看交互式的时间轴，您需要启用JavaScript。',
	'srf_paramdesc_views' => '所要显示的视图',
	'srf_paramdesc_facets' => '为每个页面所要显示的那套属性',
	'srf_paramdesc_lens' => '用于显示页面属性的模板名称',
	'srf_printername_googlebar' => 'Google条形图',
	'srf_printername_googlepie' => 'Google饼图',
	'srf_paramdesc_chartheight' => '以像素为单位的图表高度', # Fuzzy
	'srf_paramdesc_chartwidth' => '以像素为单位的图表宽度', # Fuzzy
	'srf_paramdesc_charttitle' => '图表标题',
	'srf_paramdesc_barcolor' => '条形的颜色',
	'srf_paramdesc_bardirection' => '条形图的方向', # Fuzzy
	'srf_paramdesc_barnumbersaxislabel' => '数字轴标签',
	'srf-paramdesc-minvalue' => 'Y-轴上所要显示的最小值',
	'srf-paramdesc-pointlabels' => '具体数据点的显示', # Fuzzy
	'srf-paramdesc-chartlegend' => '显示图表图例', # Fuzzy
	'srf-paramdesc-datalabels' => '显示饼图数据标签', # Fuzzy
	'srf_printername_gallery' => '图库',
	'srf_paramdesc_perrow' => '每行的图像个数',
	'srf_paramdesc_widths' => '图像宽度',
	'srf_paramdesc_heights' => '图像高度',
	'srf_paramdesc_autocaptions' => '不提供任何标题时使用文件名称作为标题',
	'srf_paramdesc_fileextensions' => '当使用文件名作为标题，同时也显示文件扩展名',
	'srf_paramdesc_captionproperty' => '存在于所查询页面上的某个语义属性的名称要用作标题',
	'srf_paramdesc_imageproperty' => '所查询页面上某一指向所要使用的图像的语义属性的名称。当设置时，所查询页面本身将不会显示为图像。',
	'srf_printername_tagcloud' => '标签云',
	'srf_paramdesc_includesubject' => '如果主题名称本身应当包括在内',
	'srf_paramdesc_increase' => '如何增加标签的大小',
	'srf_paramdesc_tagorder' => '标签的顺序',
	'srf_paramdesc_mincount' => '要列出某一取值所需出现的最少次数',
	'srf_paramdesc_minsize' => '以百分比计算的最小标签的大小',
	'srf_paramdesc_maxsize' => '以百分比计算的最大标签的大小',
	'srf_paramdesc_maxtags' => '云中标签的最大数量',
	'srf_printername_valuerank' => '取值排名',
	'srf_printername_array' => '数组',
	'srf_paramdesc_pagetitle' => '究竟是把页面标题显示为结果条目，还是略去它们',
	'srf_paramdesc_hidegaps' => '究竟是打印输出所请求的但不可用的属性以及采用分隔符分隔的记录取值，还是略去它们',
	'srf_paramdesc_arrayname' => '如果已经给出，且ArrayExtension可用，这将会创建一个带有指定名称的数组（没有任何可见的输出）',
	'srf_paramdesc_propsep' => '所请求属性之间的分隔符',
	'srf_paramdesc_manysep' => '许多已经赋值的属性取值之间的分隔符',
	'srf_paramdesc_recordsep' => '记录属性的取值之间的分隔符',
	'srf_paramdesc_headersep' => '当把"headers"设置为"show"或"plain"时，属性名称和取值之间的分隔符',
	'srf_printername_hash' => '哈希',
	'srf_paramdesc_hashname' => '如果已经给出，且HashTables可用，这将会创建一个带有指定名称的哈希表（没有任何可见的输出）',
	'srf-printername-graph' => '图形',
	'srf-paramdesc-graph-relation' => '这些主题或名称属性是父节点或子节点吗？',
	'srf-paramdesc-graph-nameprop' => '允许设置一个属性，并将其作为主题来使用，而不是实际的主题',
	'srf-paramdesc-graph-nodeshape' => '图形上每个节点的形状',
	'srf_paramdesc_graphname' => '标题',
	'srf_paramdesc_graphsize' => '图形尺寸（以像素计）',
	'srf_paramdesc_graphlegend' => '显示或不显示图形图例',
	'srf_paramdesc_graphlabel' => '图形标签',
	'srf_paramdesc_rankdir' => '箭头方向',
	'srf_paramdesc_graphlink' => '图形链接',
	'srf_paramdesc_graphcolor' => '图形颜色',
	'srf-paramdesc-graph-wwl' => 'Word自动换行限制（以字符计）',
	'srf_printername_datatables' => '数据表',
	'srf-paramdesc-rowindex' => '数据表行索引',
	'srf-paramdesc-displaylength' => '初始显示长度',
	'srf-noparentprop' => '未提供父属性。在没有指定父属性的情况下无法构建树种结构。',
	'srf-paramdesc-parent' => '包含父页面的属性',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'srf-desc' => 'Semantic MediaWiki嵌入式查詢的附加格式',
	'srf-name' => '語義結果格式',
	'srfc_previousmonth' => '上月',
	'srfc_nextmonth' => '下月',
	'srfc_today' => '今天',
	'srfc_gotomonth' => '跳至月份',
	'srf_printername_calendar' => '月曆',
	'srf_paramdesc_calendarlang' => '顯示日曆的語言代碼',
	'srf_paramdesc_calendarcolors' => '每個日期屬性的顯示顏色（示例："Start date=>green,End date=>#09c"）',
	'srf_printername_vcard' => 'vCard導出',
	'srf_printername_icalendar' => 'iCalendar導出',
	'srf_paramdesc_icalendartitle' => '日曆文件的標題',
	'srf_paramdesc_icalendardescription' => '日曆文件的說明',
	'srf_printername_bibtex' => 'BibTeX導出',
	'srf_outline_novalue' => '沒有取值',
	'srf_printername_outline' => '大綱',
	'srf_paramdesc_outlineproperties' => '要顯示為大綱標題的屬性列表，以逗號分隔',
	'srf_printername_sum' => '數值之和',
	'srf_printername_average' => '數值的平均值',
	'srf_printername_max' => '最大數目',
	'srf_printername_min' => '最小數目',
	'srf_paramdesc_limit' => '所要查詢頁面的最大數量',
	'srf_printername_product' => '數值的乘積',
	'srf_printername_median' => '數值的中位數',
	'srf-paramdesc-default' => '沒有數值型結果時將會顯示的默認值',
	'srf_printername_timeline' => '時間軸',
	'srf_printername_eventline' => '事件軸',
	'srf_paramdesc_timelinebands' => '定義在結果當中顯示哪些條帶。',
	'srf_paramdesc_timelineposition' => '定義時間軸最初的焦點位於何處。',
	'srf_paramdesc_timelinestart' => '用來定義第一個時間點的屬性名稱',
	'srf_paramdesc_timelineend' => '用來定義第二個時間點的屬性名稱',
	'srf_paramdesc_timelinesize' => '時間軸高度',
	'srf-timeline-allresults' => '此查詢的進一步結果。',
	'srf-timeline-nojs' => '要查看交互式的時間軸，您需要啟用JavaScript。',
	'srf_paramdesc_views' => '所要顯示的視圖',
	'srf_paramdesc_facets' => '為每個頁面所要顯示的那套屬性',
	'srf_paramdesc_lens' => '用於顯示頁面屬性的模板名稱',
	'srf_printername_googlebar' => 'Google條形圖',
	'srf_printername_googlepie' => 'Google餅圖',
	'srf_paramdesc_charttitle' => '圖表標題',
	'srf_paramdesc_barcolor' => '條形的顏色',
	'srf_paramdesc_barnumbersaxislabel' => '數字軸標籤',
	'srf-paramdesc-minvalue' => 'Y-軸上所要顯示的最小值',
	'srf_printername_gallery' => '圖庫',
	'srf_paramdesc_perrow' => '每行的圖像個數',
	'srf_paramdesc_widths' => '圖像寬度',
	'srf_paramdesc_heights' => '圖像高度',
	'srf_paramdesc_autocaptions' => '不提供任何標題時使用文件名稱作為標題',
	'srf_paramdesc_fileextensions' => '當使用文件名作為標題，同時也顯示文件擴展名',
	'srf_paramdesc_captionproperty' => '存在於所查詢頁面上的某個語義屬性的名稱要用作標題',
	'srf_paramdesc_imageproperty' => '所查詢頁面上某一指向所要使用的圖像的語義屬性的名稱。當設置時，所查詢頁面本身將不會顯示為圖像。',
	'srf_printername_tagcloud' => '標籤雲',
	'srf_paramdesc_includesubject' => '如果主題名稱本身應當包括在內',
	'srf_paramdesc_increase' => '如何增加標籤的大小',
	'srf_paramdesc_tagorder' => '標籤的順序',
	'srf_paramdesc_mincount' => '要列出某一取值所需出現的最少次數',
	'srf_paramdesc_minsize' => '以百分比計算的最小標籤的大小',
	'srf_paramdesc_maxsize' => '以百分比計算的最大標籤的大小',
	'srf_paramdesc_maxtags' => '雲中標籤的最大數量',
	'srf_printername_valuerank' => '取值排名',
	'srf_printername_array' => '數組',
	'srf_paramdesc_pagetitle' => '究竟是把頁面標題顯示為結果條目，還是略去它們',
	'srf_paramdesc_hidegaps' => '究竟是打印輸出所請求的但不可用的屬性以及採用分隔符分隔的記錄取值，還是略去它們',
	'srf_paramdesc_arrayname' => '如果已經給出，且ArrayExtension可用，這將會創建一個帶有指定名稱的數組（沒有任何可見的輸出）',
	'srf_paramdesc_propsep' => '所請求屬性之間的分隔符',
	'srf_paramdesc_manysep' => '許多已經賦值的屬性取值之間的分隔符',
	'srf_paramdesc_recordsep' => '記錄屬性的取值之間的分隔符',
	'srf_paramdesc_headersep' => '當把"headers"設置為"show"或"plain"時，屬性名稱和取值之間的分隔符',
	'srf_printername_hash' => '哈希',
	'srf_paramdesc_hashname' => '如果已經給出，且HashTables可用，這將會創建一個帶有指定名稱的哈希表（沒有任何可見的輸出）',
	'srf-printername-graph' => '圖形',
	'srf-paramdesc-graph-relation' => '這些主題或名稱屬性是父節點或子節點嗎？',
	'srf-paramdesc-graph-nameprop' => '允許設置一個屬性，並將其作為主題來使用，而不是實際的主題',
	'srf-paramdesc-graph-nodeshape' => '圖形上每個節點的形狀',
	'srf_paramdesc_graphname' => '標題',
	'srf_paramdesc_graphsize' => '圖形尺寸（以像素計）',
	'srf_paramdesc_graphlegend' => '顯示或不顯示圖形圖例',
	'srf_paramdesc_graphlabel' => '圖形標籤',
	'srf_paramdesc_rankdir' => '箭頭方向',
	'srf_paramdesc_graphlink' => '圖形鏈接',
	'srf_paramdesc_graphcolor' => '圖形顏色',
	'srf-paramdesc-graph-wwl' => 'Word自動換行限制（以字符計）',
	'srf_printername_datatables' => '數據表',
	'srf-paramdesc-rowindex' => '數據錶行索引',
	'srf-paramdesc-displaylength' => '初始顯示長度',
	'srf-noparentprop' => '未提供父屬性。在沒有指定父屬性的情況下無法構建樹種結構。',
	'srf-paramdesc-parent' => '包含父頁面的屬性',
);

/** Chinese (Taiwan) (‪中文(台灣)‬)
 * @author Roc michael
 */
$messages['zh-tw'] = array(
	'srfc_previousmonth' => '前一月',
	'srfc_nextmonth' => '次一月',
	'srfc_today' => '今日',
	'srfc_gotomonth' => '前往',
);
