<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 * @ingroup SMWLanguage
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'Ask' => array( 'Ask' ),
	'Browse' => array( 'Browse' ),
	'ExportRDF' => array( 'ExportRDF' ),
	'PageProperty' => array( 'PageProperty' ),
	'Properties' => array( 'Properties' ),
	'SMWAdmin' => array( 'SMWAdmin' ),
	'SearchByProperty' => array( 'SearchByProperty' ),
	'SemanticStatistics' => array( 'SemanticStatistics' ),
	'Types' => array( 'Types' ),
	'URIResolver' => array( 'URIResolver' ),
	'UnusedProperties' => array( 'UnusedProperties' ),
	'WantedProperties' => array( 'WantedProperties' ),
	'QueryCreator' => array( 'QueryCreator' ),
);

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = array(
	'Ask' => array( 'Vra' ),
	'Types' => array( 'Tipes' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'تصفح' ),
	'ExportRDF' => array( 'تصدير_آر_دي_إف' ),
	'PageProperty' => array( 'خاصية_الصفحة' ),
	'Properties' => array( 'خصائص' ),
	'SMWAdmin' => array( 'إداري_سمو' ),
	'SearchByProperty' => array( 'بحث_بواسطة_الخاصية' ),
	'SemanticStatistics' => array( 'إحصاءات_سيمانتيك' ),
	'Types' => array( 'أنواع' ),
	'URIResolver' => array( 'محلل_يو_آر_آي' ),
	'UnusedProperties' => array( 'خصائص_غير_مستخدمة' ),
	'WantedProperties' => array( 'خصائص_مطلوبة' ),
	'QueryCreator' => array( 'منشئ_الاستعلام' ),
);

/** Aramaic (ܐܪܡܝܐ) */
$specialPageAliases['arc'] = array(
	'Ask' => array( 'ܫܐܠ' ),
	'Browse' => array( 'ܦܐܬ' ),
	'PageProperty' => array( 'ܦܐܬܐ_ܕܕܝܠܝܘܬ̈ܐ' ),
	'Properties' => array( 'ܕܝܠܝܘܬ̈ܐ' ),
	'SearchByProperty' => array( 'ܒܨܝ_ܒܝܕ_ܕܝܠܝܘܬ̈ܐ' ),
	'Types' => array( 'ܐܕ̈ܫܐ' ),
	'UnusedProperties' => array( 'ܕܝܠܝܘܬ̈ܐ_ܠܐ_ܦܠܝܚܬ̈ܐ' ),
	'WantedProperties' => array( 'ܕܝܠܝܘܬ̈ܐ_ܣܢܝܩܬ̈ܐ' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'براوز' ),
	'ExportRDF' => array( 'تصدير_RDF' ),
	'PageProperty' => array( 'خاصية_الصفحه' ),
	'Properties' => array( 'خصايص' ),
	'SMWAdmin' => array( 'ادارى_SMW' ),
	'SearchByProperty' => array( 'دوّر_بالخاصيه' ),
	'SemanticStatistics' => array( 'إحصائيات_Semantic' ),
	'Types' => array( 'انواع' ),
	'URIResolver' => array( 'URI_Resolver' ),
	'UnusedProperties' => array( 'خصايص_مش_مستعمله' ),
	'WantedProperties' => array( 'خصايص_مطلوبه' ),
);

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = array(
	'Ask' => array( 'সোধক' ),
	'Browse' => array( 'ব্ৰাউজ' ),
	'ExportRDF' => array( 'RDF_ৰপ্তানি' ),
	'Types' => array( 'প্ৰকাৰসমূহ' ),
);

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = array(
	'Ask' => array( 'Takun' ),
	'Browse' => array( 'Ambahi' ),
	'Types' => array( 'Janis' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'Ask' => array( 'Goulenn' ),
	'Browse' => array( 'Furchal' ),
	'ExportRDF' => array( 'EzorzhiañRDF' ),
	'PageProperty' => array( 'PerzhioùPajenn' ),
	'Properties' => array( 'Perzhioù' ),
	'Types' => array( 'Seurtoù' ),
);

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = array(
	'Ask' => array( 'Upit' ),
	'Browse' => array( 'Pregledanje' ),
	'ExportRDF' => array( 'IzvozRDF' ),
	'Properties' => array( 'Svojstva' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'Ask' => array( 'Semantische_Suche' ),
	'Browse' => array( 'Durchsuchen', 'Browsen' ),
	'ExportRDF' => array( 'RDF_exportieren', 'Exportiere_RDF' ),
	'PageProperty' => array( 'Seitenattribut' ),
	'Properties' => array( 'Attribute' ),
	'SMWAdmin' => array( 'SMW-Administration', 'SMW-Einrichtung' ),
	'SearchByProperty' => array( 'Suche_mittels_Attribut' ),
	'SemanticStatistics' => array( 'Semantische_Statistik' ),
	'Types' => array( 'Datentypen' ),
	'URIResolver' => array( 'URI-Auflöser' ),
	'UnusedProperties' => array( 'Verwaiste_Attribute' ),
	'WantedProperties' => array( 'Gewünschte_Attribute' ),
	'QueryCreator' => array( 'Abfragenersteller' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'Ask' => array( 'Pers' ),
	'Browse' => array( 'Bıgeyrê' ),
	'ExportRDF' => array( 'RDFTeberde' ),
	'PageProperty' => array( 'XısusiyaPela' ),
	'Properties' => array( 'Xısusiyeti' ),
	'SMWAdmin' => array( 'SMWXızmetkar' ),
	'SearchByProperty' => array( 'XısusiyetkarCıgeyrayış' ),
	'SemanticStatistics' => array( 'İstatıstikêFahmkerdışi' ),
	'Types' => array( 'Babeti' ),
	'URIResolver' => array( 'URIAgozne' ),
	'UnusedProperties' => array( 'XısusiyetêNêkarênê' ),
	'WantedProperties' => array( 'XısusiyetêWaştênê' ),
	'QueryCreator' => array( 'PesinVıraşter' ),
);

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'Ask' => array( 'Semantiske pytanhje' ),
	'Browse' => array( 'Pśepytaś' ),
	'ExportRDF' => array( 'RDF eksportěrowaś' ),
	'PageProperty' => array( 'Bokowa kakosć' ),
	'Properties' => array( 'Kakosći' ),
	'SearchByProperty' => array( 'Z kakosću pytaś' ),
	'SemanticStatistics' => array( 'Semantiska statistika' ),
	'Types' => array( 'Datowe typy' ),
	'UnusedProperties' => array( 'Njewužywane kakosći' ),
	'WantedProperties' => array( 'Póžedane kakosći' ),
);

/** Divehi (ދިވެހިބަސް) */
$specialPageAliases['dv'] = array(
	'Ask' => array( 'އައްސަވާ' ),
);

/** Spanish (español) */
$specialPageAliases['es'] = array(
	'Types' => array( 'Tipos' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'Ask' => array( 'پرسش' ),
	'Browse' => array( 'مرور' ),
	'ExportRDF' => array( 'برونریزی_آردی‌اف' ),
	'PageProperty' => array( 'جزئیات_صفحه' ),
	'Properties' => array( 'جزئیات' ),
	'SMWAdmin' => array( 'مدیر_اس‌ام‌دبلیو' ),
	'SearchByProperty' => array( 'جستجو_بر_پایه_جزئیات' ),
	'SemanticStatistics' => array( 'آمار_سمانیک' ),
	'Types' => array( 'نوع‌ها' ),
	'URIResolver' => array( 'حل‌کننده_یو‌آر‌آی' ),
	'UnusedProperties' => array( 'جزئیات_استفاده_نشده' ),
	'WantedProperties' => array( 'جزئیات_درخواستی' ),
	'QueryCreator' => array( 'کوئری‌ساز' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'Ask' => array( 'Kysy' ),
	'Browse' => array( 'Selaa' ),
	'ExportRDF' => array( 'RDF-vienti' ),
	'Properties' => array( 'Ominaisuudet' ),
	'SMWAdmin' => array( 'Semanttisen_Mediawikin_ylläpito' ),
	'SemanticStatistics' => array( 'Semanttiset_tilastot' ),
	'Types' => array( 'Tyypit' ),
	'UnusedProperties' => array( 'Käyttämättömät_ominaisuudet' ),
	'WantedProperties' => array( 'Halutut_ominaisuudet' ),
	'QueryCreator' => array( 'Semanttisen_kyselyn_luonti' ),
);

/** French (français) */
$specialPageAliases['fr'] = array(
	'Properties' => array( 'Propriétés' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'Ask' => array( 'Preguntar' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'Exportar_RDF' ),
	'PageProperty' => array( 'Propiedades_da_páxina' ),
	'Properties' => array( 'Propiedades' ),
	'SearchByProperty' => array( 'Procurar_por_propiedades' ),
	'SemanticStatistics' => array( 'Estatísticas_semánticas' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'Propiedades_sen_uso' ),
	'WantedProperties' => array( 'Propiedades_requiridas' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'Ask' => array( 'Semantischi_Suech' ),
	'Browse' => array( 'Duresueche' ),
	'ExportRDF' => array( 'Exportier_ADF' ),
	'PageProperty' => array( 'Syteattribut' ),
	'Properties' => array( 'Attribut' ),
	'SMWAdmin' => array( 'SMW-Yyrichtig' ),
	'SearchByProperty' => array( 'Suech_no_Attribut' ),
	'SemanticStatistics' => array( 'Semantischi_Statischtik' ),
	'Types' => array( 'Datetype' ),
	'URIResolver' => array( 'URI-Ufflöser' ),
	'UnusedProperties' => array( 'Verwaisti_Attribut' ),
	'WantedProperties' => array( 'Gwinschti_Attribut' ),
	'QueryCreator' => array( 'Abfroogersteller' ),
);

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = array(
	'Ask' => array( 'पूछो' ),
);

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'Ask' => array( 'Semantiske pytanje' ),
	'Browse' => array( 'Přepytać' ),
	'ExportRDF' => array( 'RDF eksportować' ),
	'PageProperty' => array( 'Kajkosć strony' ),
	'Properties' => array( 'Kajkosće' ),
	'SearchByProperty' => array( 'Pytanje po kajkosći' ),
	'SemanticStatistics' => array( 'Semantiska statistika' ),
	'Types' => array( 'Datowe typy' ),
	'UnusedProperties' => array( 'Njewužiwane kajkosće' ),
	'WantedProperties' => array( 'Falowace kajkosće' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'Ask' => array( 'Mande' ),
	'Browse' => array( 'Navige' ),
	'ExportRDF' => array( 'EkspòteRDF' ),
	'PageProperty' => array( 'ProprietePaj' ),
	'Properties' => array( 'Propriete' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'ChachePaPropriete' ),
	'SemanticStatistics' => array( 'EstatistikSemantik' ),
	'Types' => array( 'Tip' ),
	'UnusedProperties' => array( 'ProprietePaSèvi' ),
	'WantedProperties' => array( 'ProprieteKiMande' ),
);

/** Hungarian (magyar) */
$specialPageAliases['hu'] = array(
	'Ask' => array( 'Kérdez' ),
	'Browse' => array( 'Böngészés' ),
	'Properties' => array( 'Tulajdonságok' ),
	'SemanticStatistics' => array( 'Szemantikus_statisztika' ),
	'Types' => array( 'Típusok' ),
	'URIResolver' => array( 'URI-feloldó' ),
	'UnusedProperties' => array( 'Nem_használt_tulajdonságok' ),
	'WantedProperties' => array( 'Keresett_tulajdonságok' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'Ask' => array( 'Consultar' ),
	'Browse' => array( 'Percurrer' ),
	'ExportRDF' => array( 'Exportar_RDF' ),
	'PageProperty' => array( 'Proprietate_de_pagina' ),
	'Properties' => array( 'Proprietates' ),
	'SMWAdmin' => array( 'Admin_SMW' ),
	'SearchByProperty' => array( 'Cercar_per_proprietate' ),
	'SemanticStatistics' => array( 'Statisticas_semantic' ),
	'Types' => array( 'Typos' ),
	'URIResolver' => array( 'Resolvitor_de_URIs' ),
	'UnusedProperties' => array( 'Proprietates_non_usate' ),
	'WantedProperties' => array( 'Proprietates_dsesirate' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'Ask' => array( 'Tanya' ),
	'Browse' => array( 'Jelajahi' ),
	'ExportRDF' => array( 'EksporRDF' ),
	'PageProperty' => array( 'PropertiHalaman' ),
	'Properties' => array( 'Properti' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'PencarianProperti' ),
	'SemanticStatistics' => array( 'StatistikSemantik' ),
	'Types' => array( 'Tipe' ),
	'URIResolver' => array( 'PenguraiURI' ),
	'UnusedProperties' => array( 'PropertiTakDigunakan' ),
	'WantedProperties' => array( 'PropertiDiinginkan' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'Ask' => array( 'Chiedi' ),
	'Browse' => array( 'Esplora' ),
	'ExportRDF' => array( 'EsportaRDF' ),
	'PageProperty' => array( 'ProprietàPagina' ),
	'Properties' => array( 'Proprietà' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'CercaPerProprietà' ),
	'SemanticStatistics' => array( 'StatisticheSemantiche' ),
	'Types' => array( 'Tipi' ),
	'URIResolver' => array( 'RisolutoreURI' ),
	'UnusedProperties' => array( 'ProprietàNonUtilizzate' ),
	'WantedProperties' => array( 'ProprietàRichieste' ),
	'QueryCreator' => array( 'CreatoreQuery' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'Ask' => array( '問い合わせ', '意味的検索' ),
	'Browse' => array( '閲覧' ),
	'ExportRDF' => array( 'RDFエクスポート', 'ＲＤＦエクスポート' ),
	'PageProperty' => array( 'ページプロパティ' ),
	'Properties' => array( 'プロパティ一覧' ),
	'SMWAdmin' => array( 'SMW管理' ),
	'SearchByProperty' => array( 'プロパティによる検索' ),
	'SemanticStatistics' => array( '意味的統計' ),
	'Types' => array( '型一覧' ),
	'URIResolver' => array( 'URIリゾルバー', 'ＵＲＩリゾルバー' ),
	'UnusedProperties' => array( '使われていないプロパティ' ),
	'WantedProperties' => array( '望まれているプロパティ' ),
	'QueryCreator' => array( 'クエリ作成' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'Types' => array( 'ტიპები' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'Browse' => array( 'រាវរក' ),
	'Properties' => array( 'លក្ខណៈ' ),
	'Types' => array( 'ប្រភេទ' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'Ask' => array( '묻기' ),
	'Browse' => array( '찾아보기' ),
	'ExportRDF' => array( 'RDF내보내기' ),
	'PageProperty' => array( '문서속성' ),
	'Properties' => array( '속성목록' ),
	'SMWAdmin' => array( 'SMW관리자' ),
	'SearchByProperty' => array( '속성찾기', '속성검색' ),
	'SemanticStatistics' => array( '시멘틱통계량' ),
	'Types' => array( '종류목록' ),
	'URIResolver' => array( 'URI해결' ),
	'UnusedProperties' => array( '안쓰는속성', '쓰이지않는속성' ),
	'WantedProperties' => array( '필요한속성' ),
	'QueryCreator' => array( '쿼리작성기' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'Ask' => array( 'Froore' ),
	'Browse' => array( 'Bläddere' ),
	'ExportRDF' => array( 'RDF', 'RDF Äxpotteere' ),
	'PageProperty' => array( 'Eijeschaffte vun Sigge' ),
	'Properties' => array( 'Eijeschaffte' ),
	'SMWAdmin' => array( 'Semantesch MediaWiki Ennreschte' ),
	'SearchByProperty' => array( 'Noh Eijeschaffte söke' ),
	'SemanticStatistics' => array( 'Semantesch Shtatistike' ),
	'Types' => array( 'Zoote vun Daate' ),
	'UnusedProperties' => array( 'Eijeschaffte di nit jebruch wääde' ),
	'WantedProperties' => array( 'Eijeschaffte di noch jebruch wääde' ),
);

/** Cornish (kernowek) */
$specialPageAliases['kw'] = array(
	'Ask' => array( 'Govyn' ),
	'Browse' => array( 'Peuri' ),
	'ExportRDF' => array( 'EsperthiRDF' ),
	'Properties' => array( 'Gnasow' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'Ask' => array( 'Froen' ),
	'Browse' => array( 'Browsen' ),
	'ExportRDF' => array( 'RDF_exportéieren' ),
	'PageProperty' => array( 'Säiten-Eegeschaften' ),
	'Properties' => array( 'Eegeschaften' ),
	'SearchByProperty' => array( 'No_Eegeschaft_sichen' ),
	'SemanticStatistics' => array( 'Semantesch_Statistiken' ),
	'Types' => array( 'Datentypen' ),
	'UnusedProperties' => array( 'Netbenotzten_Eegeschaften' ),
	'WantedProperties' => array( 'Gewënschten_Eegeschaften' ),
);

/** lumbaart (lumbaart) */
$specialPageAliases['lmo'] = array(
	'Ask' => array( 'Ciama' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'Ask' => array( 'Прашај' ),
	'Browse' => array( 'Прелистај' ),
	'ExportRDF' => array( 'ИзвезиRDF' ),
	'PageProperty' => array( 'СвојстваНаСтраница' ),
	'Properties' => array( 'Својства' ),
	'SMWAdmin' => array( 'СМВАдминистратор' ),
	'SearchByProperty' => array( 'ПребарајПоСвојство' ),
	'SemanticStatistics' => array( 'СемантичкиСтатистики' ),
	'Types' => array( 'Типови' ),
	'URIResolver' => array( 'URIРешавач' ),
	'UnusedProperties' => array( 'НекористениСвојства' ),
	'WantedProperties' => array( 'ПотребниСвојства' ),
	'QueryCreator' => array( 'СоздавачНаБарања' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'Ask' => array( 'ചോദിക്കുക' ),
	'Browse' => array( 'ബ്രൗസ്' ),
	'Types' => array( 'തരങ്ങൾ' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'Ask' => array( 'विचारा' ),
	'Browse' => array( 'न्याहाळा' ),
	'ExportRDF' => array( 'आरडीएफनिर्यात' ),
	'PageProperty' => array( 'पानवैशिष्ट्ये' ),
	'Properties' => array( 'वैशिष्ट्ये' ),
	'SMWAdmin' => array( 'एसएमडब्ल्यूप्रचालक' ),
	'SearchByProperty' => array( 'वैशिष्ट्येनुसारशोध' ),
	'SemanticStatistics' => array( 'सिमॅंटीकसांख्यिकी' ),
	'Types' => array( 'प्रकार' ),
	'URIResolver' => array( 'यूआरायरिझॉल्व्हर' ),
	'UnusedProperties' => array( 'नवापरलेलीवैशिष्ट्ये' ),
	'WantedProperties' => array( 'हवीअसलेलीवैशिष्ट्ये' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'Ask' => array( 'Staqsi' ),
	'Browse' => array( 'Esplora' ),
);

/** Norwegian Bokmål (norsk (bokmål)‎) */
$specialPageAliases['nb'] = array(
	'Ask' => array( 'Spør' ),
	'Browse' => array( 'Se_gjennom' ),
	'ExportRDF' => array( 'Eksporter_RDF' ),
	'PageProperty' => array( 'Sideegenskaper' ),
	'Properties' => array( 'Egenskaper' ),
	'SMWAdmin' => array( 'SMW-administrasjon' ),
	'SearchByProperty' => array( 'Søk_etter_egenskap' ),
	'SemanticStatistics' => array( 'Semantisk_statistikk' ),
	'Types' => array( 'Typer' ),
	'UnusedProperties' => array( 'Ubrukte_egenskaper' ),
	'WantedProperties' => array( 'Ønskede_egenskaper' ),
);

/** Nedersaksies (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'Ask' => array( 'Vragen' ),
	'Browse' => array( 'Bekieken' ),
	'ExportRDF' => array( 'RDF_uutvoeren' ),
	'PageProperty' => array( 'Pagina-eigenschap' ),
	'Properties' => array( 'Eigenschappen' ),
	'SMWAdmin' => array( 'SMW-beheer' ),
	'SearchByProperty' => array( 'Op_eigenschap_zeuken' ),
	'SemanticStatistics' => array( 'Semantiese_staotistieken' ),
	'Types' => array( 'Soorten' ),
	'URIResolver' => array( 'URI-oplosser' ),
	'UnusedProperties' => array( 'Ongebruukten_eigenschappen' ),
	'WantedProperties' => array( 'Gewunste_eigenschappen' ),
	'QueryCreator' => array( 'Wachtrie-anmaker' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'Ask' => array( 'Vragen' ),
	'Browse' => array( 'Bekijken' ),
	'ExportRDF' => array( 'RDFExporteren' ),
	'PageProperty' => array( 'Paginaeigenschap' ),
	'Properties' => array( 'Eigenschappen' ),
	'SMWAdmin' => array( 'SMWBeheer' ),
	'SearchByProperty' => array( 'OpEigenschapZoeken' ),
	'SemanticStatistics' => array( 'SemantischeStatistieken' ),
	'Types' => array( 'Typen' ),
	'UnusedProperties' => array( 'OngebruikteEigenschappen' ),
	'WantedProperties' => array( 'GewensteEigenschappen' ),
	'QueryCreator' => array( 'Zoekopdrachtenmaker' ),
);

/** Occitan (occitan) */
$specialPageAliases['oc'] = array(
	'Browse' => array( 'Percórrer' ),
	'Properties' => array( 'Proprietats' ),
	'Types' => array( 'Tipes' ),
	'UnusedProperties' => array( 'Proprietats inutilizadas', 'ProprietatsInutilizadas' ),
	'WantedProperties' => array( 'Proprietats demandadas', 'ProprietatsDemandadas' ),
);

/** Oriya (ଓଡ଼ିଆ) */
$specialPageAliases['or'] = array(
	'Ask' => array( 'ପଚାରନ୍ତୁ' ),
	'Browse' => array( 'ଖୋଜିବା' ),
	'PageProperty' => array( 'ପୃଷ୍ଠାର_ଗୁଣ' ),
	'Properties' => array( 'ଗୁଣ' ),
	'UnusedProperties' => array( 'ବ୍ୟବହାର_ହୋଇନଥିବା_ଗୁଣ' ),
	'WantedProperties' => array( 'ଦରକାରୀ_ଗୁଣ' ),
);

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = array(
	'Ask' => array( 'ਪੁੱਛੋ' ),
	'Browse' => array( 'ਬ੍ਰਾਊਜ਼' ),
	'Types' => array( 'ਕਿਸਮਾਂ' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'Ask' => array( 'Pytanie' ),
	'Browse' => array( 'Przegląd' ),
	'ExportRDF' => array( 'EksportRDF' ),
	'PageProperty' => array( 'WłasnośćStrony' ),
	'Properties' => array( 'Własności' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'SzukanieWgWłasności' ),
	'SemanticStatistics' => array( 'StatystykiSemantyczne' ),
	'Types' => array( 'Typy' ),
	'URIResolver' => array( 'ResolverURI' ),
	'UnusedProperties' => array( 'NieużywaneWłasności' ),
	'WantedProperties' => array( 'PotrzebneWłasności' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'Ask' => array( 'پوښتل' ),
	'Browse' => array( 'سپړل' ),
	'PageProperty' => array( 'د مخ ځانتياوې' ),
	'Properties' => array( 'ځانتياوې' ),
	'Types' => array( 'ډولونه' ),
	'UnusedProperties' => array( 'ناکارېدلې ځانتياوې' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'Ask' => array( 'Pedir' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'Exportar_RDF' ),
	'PageProperty' => array( 'Propriedade_de_página' ),
	'Properties' => array( 'Propriedades' ),
	'SearchByProperty' => array( 'Pesquisar_propriedade' ),
	'SemanticStatistics' => array( 'Estatísticas_de_semântica' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'Propriedades_não_utilizadas' ),
	'WantedProperties' => array( 'Propriedades_desejadas' ),
);

/** Romanian (română) */
$specialPageAliases['ro'] = array(
	'Browse' => array( 'Răsfoieşte' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'Ask' => array( 'Chiedi' ),
	'Browse' => array( 'Esplora' ),
	'ExportRDF' => array( 'EsportaRDF' ),
	'PageProperty' => array( 'ProprietàPagina' ),
	'Properties' => array( 'Proprietà' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'CercaPerProprietà' ),
	'SemanticStatistics' => array( 'StatisticheSemantiche' ),
	'Types' => array( 'Tipi' ),
	'URIResolver' => array( 'RisolutoreURI' ),
	'UnusedProperties' => array( 'ProprietàNonUtilizzate' ),
	'WantedProperties' => array( 'ProprietàRichieste' ),
	'QueryCreator' => array( 'CreatoreQuery' ),
);

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = array(
	'Ask' => array( 'SpýtaťSa' ),
	'Browse' => array( 'Prehliadať' ),
	'PageProperty' => array( 'VlastnostiStránky' ),
	'Properties' => array( 'Vlastnosti' ),
	'SMWAdmin' => array( 'SprávcaSMW' ),
	'SearchByProperty' => array( 'HľadaniePodľaVlastností' ),
	'SemanticStatistics' => array( 'SémantickéŠtatistiky' ),
	'Types' => array( 'Typy' ),
	'URIResolver' => array( 'PrekladURI' ),
	'UnusedProperties' => array( 'NepoužívanéVlastnosti' ),
	'WantedProperties' => array( 'ŽiadanéVlastnosti' ),
);

/** Albanian (shqip) */
$specialPageAliases['sq'] = array(
	'Ask' => array( 'Pyet' ),
	'Browse' => array( 'Sille' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = array(
	'Ask' => array( 'Питај' ),
	'Browse' => array( 'Потражи' ),
	'Properties' => array( 'Својства' ),
	'Types' => array( 'Врсте' ),
	'UnusedProperties' => array( 'Некоришћена_својства' ),
	'WantedProperties' => array( 'Тражена_својства' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'Ask' => array( 'Fråga' ),
	'Browse' => array( 'Bläddra' ),
	'ExportRDF' => array( 'Exportera_RDF' ),
	'Properties' => array( 'Egenskaper' ),
	'Types' => array( 'Typer' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'Ask' => array( 'Uliza' ),
	'Browse' => array( 'Fungua' ),
	'Types' => array( 'Aina' ),
);

/** Telugu (తెలుగు) */
$specialPageAliases['te'] = array(
	'Ask' => array( 'అడుగు' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'Ask' => array( 'Magtanong' ),
	'Browse' => array( 'Tumingin-tingin' ),
	'ExportRDF' => array( 'Iluwas_ang_RDF' ),
	'PageProperty' => array( 'Pag-aari_ng_pahina' ),
	'Properties' => array( 'Mga_pag-aari' ),
	'SMWAdmin' => array( 'Tagapangasiwa_ng_SMW' ),
	'SearchByProperty' => array( 'Maghanap_ayon_sa_pag-aari' ),
	'SemanticStatistics' => array( 'Mga_estadistika_ng_semantiko' ),
	'Types' => array( 'Mga_uri' ),
	'URIResolver' => array( 'Tagapaglutas_ng_URI' ),
	'UnusedProperties' => array( 'Mga_pag-aaring_hindi_ginagamit' ),
	'WantedProperties' => array( 'Mga_pag-aaring_ninanais' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'Ask' => array( 'Sor' ),
	'Browse' => array( 'Gezin' ),
	'ExportRDF' => array( 'RDFAktar' ),
	'PageProperty' => array( 'SayfaÖzelliği' ),
	'Properties' => array( 'Özellikler' ),
	'SMWAdmin' => array( 'SMWHizmetlisi', 'SMWYöneticisi' ),
	'SearchByProperty' => array( 'ÖzelliğeGöreAra' ),
	'SemanticStatistics' => array( 'Anlamİstatistikleri' ),
	'Types' => array( 'Türler', 'Tipler' ),
	'URIResolver' => array( 'URIÇözücü' ),
	'UnusedProperties' => array( 'KullanılmayanÖzellikler' ),
	'WantedProperties' => array( 'İstenenÖzellikler' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'Properties' => array( 'Властивості' ),
	'Types' => array( 'Типи' ),
);

/** vèneto (vèneto) */
$specialPageAliases['vec'] = array(
	'Browse' => array( 'Sfója' ),
	'Properties' => array( 'Proprietà' ),
	'Types' => array( 'Tipi' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'Ask' => array( 'Hỏi' ),
	'Browse' => array( 'Duyệt' ),
	'ExportRDF' => array( 'Xuất_RDF' ),
	'PageProperty' => array( 'Thuộc_tính_trang' ),
	'Properties' => array( 'Thuộc_tính' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'Ask' => array( '问' ),
	'Browse' => array( '浏览' ),
	'ExportRDF' => array( '导出RDF' ),
	'PageProperty' => array( '页面属性' ),
	'Properties' => array( '属性' ),
	'SMWAdmin' => array( 'MWA管理' ),
	'SearchByProperty' => array( '按属性搜索' ),
	'SemanticStatistics' => array( '语义统计' ),
	'Types' => array( '类型' ),
	'URIResolver' => array( 'URL分解器' ),
	'UnusedProperties' => array( '未使用属性' ),
	'WantedProperties' => array( '缺乏属性' ),
	'QueryCreator' => array( '查询创建者' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'Ask' => array( '問' ),
	'Browse' => array( '瀏覽' ),
);