<?php

/**
 * Internationalization file for the Semantic Image Input extension.
 *
 * @since 0.1
 *
 * @file SemanticImageInput.i18n.php
 * @ingroup SII
 *
 * @licence GNU GPL v3+
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */

$messages = array();

/** English
 * @author Jeroen De Dauw
 */
$messages['en'] = array(
	'sii-desc' => 'Adds an image input that pulls images from Wikipedia to [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',

	'sii-imageinput-loading' => 'Loading image...'
);

/** Message documentation (Message documentation)
 * @author Purodha
 */
$messages['qqq'] = array(
	'sii-desc' => '{{desc}}

The extension looks at Wikipedia articles and figures out which images are used there. These images are then pulled to the local wiki using MediaWikis native instant commons functionality. They are copied to the local server.',
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'sii-desc' => "Amiesta una entrada d'imaxes que baxa imaxes de la Wikipedia a [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]",
	'sii-imageinput-loading' => 'Cargando la imaxe...',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author Renessaince
 */
$messages['be-tarask'] = array(
	'sii-desc' => 'Дадае ўвод выявы, якая выштурхвае выявы зь Вікіпэдыі ў [https://www.mediawiki.org/wiki/Extension:Semantic_Forms сэмантычныя формы]',
	'sii-imageinput-loading' => 'Загрузка выявы…',
);

/** Breton (brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'sii-imageinput-loading' => 'O kargañ ar skeudenn...',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'sii-desc' => 'Ermöglicht für [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms] eine zusätzliche Eingabeart, die den Abruf von Bildern aus den Wikipedias und Wikimedia Commons erlaubt',
	'sii-imageinput-loading' => 'Das Bild wird gerade geladen …',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'sii-desc' => 'Zmóžnja zapódaśe wobrazow, kótarež śěgnjo wobraze z Wikipedije do [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Wobraz se zacytujo...',
);

/** Spanish (español)
 * @author Armando-Martin
 */
$messages['es'] = array(
	'sii-desc' => 'Añade una entrada de imágenes que transfiere las imágenes de Wikipedia a [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Cargando la imagen...',
);

/** Estonian (eesti)
 * @author Avjoska
 */
$messages['et'] = array(
	'sii-imageinput-loading' => 'Pildi laadimine...',
);

/** Finnish (suomi)
 * @author Nedergard
 */
$messages['fi'] = array(
	'sii-desc' => 'Lisää kuvien lataustavan, joka noutaa kuvan Wikipediasta [https://www.mediawiki.org/wiki/Extension:Semantic_Forms semanttisiin lomakkeisiin]',
	'sii-imageinput-loading' => 'Ladataan kuvaa...',
);

/** French (français)
 * @author Gomoko
 */
$messages['fr'] = array(
	'sii-desc' => "Ajoute une entrée d'image qui tire ses images de Wikipédia depuis [https://www.mediawiki.org/wiki/Extension:Semantic_Forms les formulaires sémantiques]",
	'sii-imageinput-loading' => "Chargement de l'image...",
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'sii-imageinput-loading' => 'Chargement de l’émâge...',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'sii-desc' => 'Engade unha entrada de imaxes que empurra as imaxes da Wikipedia a [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Cargando a imaxe...',
);

/** Hebrew (עברית)
 * @author Amire80
 */
$messages['he'] = array(
	'sii-desc' => 'הוספת קלט תמונות שמושך תמונות מוויקיפדיה ל[https://www.mediawiki.org/wiki/Extension:Semantic_Forms טפסים סמנטיים]',
	'sii-imageinput-loading' => 'התמונה נטענת...',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'sii-desc' => 'Zmóžnja zapodaće wobrazow, kotrež wobrazy z Wikipedije do [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms] ćaha',
	'sii-imageinput-loading' => 'Wobraz so začituje...',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'sii-desc' => 'Adde un modo de inserer imagines que extrahe imagines ex Wikipedia a [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Formularios Semantic]',
	'sii-imageinput-loading' => 'Carga imagine...',
);

/** Italian (italiano)
 * @author Beta16
 */
$messages['it'] = array(
	'sii-desc' => 'Aggiunge un input di immagine che recupera le immagini da Wikipedia verso [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Caricamento immagine...',
);

/** Japanese (日本語)
 * @author Shirayuki
 */
$messages['ja'] = array(
	'sii-desc' => 'ウィキペディアから[https://www.mediawiki.org/wiki/Extension:Semantic_Forms 意味的フォーム]に画像を引き出すための、画像入力を追加する',
	'sii-imageinput-loading' => '画像を読み込み中...',
);

/** Georgian (ქართული)
 * @author David1010
 */
$messages['ka'] = array(
	'sii-imageinput-loading' => 'სურათი იტვირთება...',
);

/** Korean (한국어)
 * @author 아라
 */
$messages['ko'] = array(
	'sii-desc' => '[https://www.mediawiki.org/wiki/Extension:Semantic_Forms 시맨틱 양식]에 위키백과에서 그림을 밀어서 그림 입력 추가',
	'sii-imageinput-loading' => '그림을 불러오는 중...',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'sii-desc' => 'Brängg en Müjjeleschkeit en et Wiki, öm Belder vun de Wikkipeedija udder MedijaWiki Commons en e [https://www.mediawiki.org/wiki/Extension:Semantic_Forms semantesch Fommulaa] ze holle un derbei op der eije ẞööver ze kopeere..',
	'sii-imageinput-loading' => 'Ben e Beld aam Laade&nbsp;&hellip;',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'sii-desc' => 'Setzt eng Method derbäi fir Biller op Wikipedia vun [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms] eriwwer ze huelen',
	'sii-imageinput-loading' => 'Bild gëtt gelueden...',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'sii-desc' => 'Во [https://www.mediawiki.org/wiki/Extension:Semantic_Forms?uselang=mk Семантичките обрасци] додава можност за внесување на слики што се извлекуваат од Википедија',
	'sii-imageinput-loading' => 'Ја вчитувам сликата...',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'sii-desc' => 'Menambahkan input imej yang menarik imej dari Wikipedia ke [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Imej sedang dimuatkan...',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Event
 */
$messages['nb'] = array(
	'sii-desc' => 'Legger til et element som henter bilder fra Wikipedia til [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Laster bilde...',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'sii-desc' => 'Voegt een invoerveld toe voor afbeeldingen zodat afbeeldingen van Wikipedia gebruikt kunnen worden in [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Bezig met het laden van de afbeelding...',
);

/** Polish (polski)
 * @author BeginaFelicysym
 */
$messages['pl'] = array(
	'sii-desc' => 'Dodaje pole wprowadzenia obrazka, pobierające obrazki z Wikipedii do [https://www.mediawiki.org/wiki/Extension:Semantic_Forms formularzy semantycznych]',
	'sii-imageinput-loading' => 'Ładowanie obrazka...',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'sii-desc' => "A gionta n'anseriment ëd figura che a pija soe figure da Wikipedia për ij [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Formolari Semàntich]",
	'sii-imageinput-loading' => 'Cariament ëd la figura...',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'sii-desc' => "Aggiunge 'u 'ngresse de le immaggine ca careche immaggine da Uicchipèdie sus a le [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Module Semandeche]",
	'sii-imageinput-loading' => "Stoche a careche l'immaggine...",
);

/** Russian (русский)
 * @author Pastakhov
 */
$messages['ru'] = array(
	'sii-desc' => 'Добавляет поле для загрузки изображений из Wikipedia в [https://www.mediawiki.org/wiki/Extension:Semantic_Forms cемантические формы]',
	'sii-imageinput-loading' => 'Идёт загрузка изображения…',
);

/** Sinhala (සිංහල)
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'sii-imageinput-loading' => 'පින්තූරය පූරණය වෙමින්...',
);

/** Swedish (svenska)
 * @author Martinwiss
 */
$messages['sv'] = array(
	'sii-desc' => 'Lägger till en bild hämtad från Wikipedia till [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Hämtar bild...',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'sii-imageinput-loading' => 'బొమ్మ లోడవతుతోంది...',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'sii-desc' => 'Nagdaragdag ng isang pagpapasok ng imahe na humihila ng mga imahe magmula sa Wikipedia papunta sa [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Pormularyong Semantiko]',
	'sii-imageinput-loading' => 'Ikinakarga ang imahe...',
);

/** Turkish (Türkçe)
 * @author Emperyan
 */
$messages['tr'] = array(
	'sii-imageinput-loading' => 'Resim yükleniyor...',
);

/** Ukrainian (українська)
 * @author Steve.rusyn
 * @author Ата
 */
$messages['uk'] = array(
	'sii-desc' => 'Додає введення зображень, що витягує зображення з Вікіпедії до [https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]',
	'sii-imageinput-loading' => 'Завантаження зображення...',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Linforest
 */
$messages['zh-hans'] = array(
	'sii-desc' => '为[https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]（语义表单）添加一个用于从Wikipedia获取图像的图像输入控件',
	'sii-imageinput-loading' => '加载图像...',
);

/** Traditional Chinese (中文（繁體）‎)
 */
$messages['zh-hant'] = array(
	'sii-desc' => '為[https://www.mediawiki.org/wiki/Extension:Semantic_Forms Semantic Forms]（語義表單）添加一個用於從Wikipedia獲取圖像的圖像輸入控件',
	'sii-imageinput-loading' => '加載圖像...',
);
