<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 * @ingroup SF
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'CreateCategory' => array( 'CreateCategory' ),
	'CreateClass' => array( 'CreateClass' ),
	'CreateForm' => array( 'CreateForm' ),
	'CreateProperty' => array( 'CreateProperty' ),
	'CreateTemplate' => array( 'CreateTemplate' ),
	'FormEdit' => array( 'FormEdit', 'AddData', 'EditData' ),
	'FormStart' => array( 'FormStart', 'AddPage' ),
	'Forms' => array( 'Forms' ),
	'RunQuery' => array( 'RunQuery' ),
	'Templates' => array( 'Templates' ),
	'UploadWindow' => array( 'UploadWindow' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'CreateCategory' => array( 'إنشاء_تصنيف' ),
	'CreateClass' => array( 'إنشاء_رتبة' ),
	'CreateForm' => array( 'إنشاء_استمارة' ),
	'CreateProperty' => array( 'إنشاء_خاصية' ),
	'CreateTemplate' => array( 'إنشاء_قالب' ),
	'FormEdit' => array( 'تعديل_البيانات' ),
	'FormStart' => array( 'إضافة_صفحة' ),
	'Forms' => array( 'استمارات' ),
	'RunQuery' => array( 'تنفيذ_الاستعلام' ),
	'Templates' => array( 'قوالب' ),
	'UploadWindow' => array( 'نافذة_الرفع' ),
);

/** Aramaic (ܐܪܡܝܐ) */
$specialPageAliases['arc'] = array(
	'CreateCategory' => array( 'ܒܪܝ_ܣܕܪܐ' ),
	'CreateProperty' => array( 'ܒܪܝ_ܕܝܠܝܘ̈ܬܐ' ),
	'CreateTemplate' => array( 'ܒܪܝ_ܩܠܒܐ' ),
	'Templates' => array( 'ܩܠܒ̈ܐ' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'CreateCategory' => array( 'اعمل_تصنيف' ),
	'CreateForm' => array( 'اعمل_استماره' ),
	'CreateProperty' => array( 'اعمل_ملكيه' ),
	'CreateTemplate' => array( 'إاعمل_قالب' ),
	'FormEdit' => array( 'تعديل_الداتا' ),
	'FormStart' => array( 'زود_صفحه' ),
	'Forms' => array( 'استمارات' ),
	'Templates' => array( 'قوالب' ),
	'UploadWindow' => array( 'ويندو_الأپلود' ),
);

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = array(
	'CreateCategory' => array( 'শ্ৰেণী_সৃষ্টি_কৰক' ),
	'Templates' => array( 'সাঁচসমূহ' ),
	'UploadWindow' => array( 'আপল’ড_ৱিন্দ' ),
);

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = array(
	'CreateCategory' => array( 'Ulah_tumbung' ),
	'CreateForm' => array( 'Ulah_purmulir' ),
	'CreateTemplate' => array( 'Ulah_citakan' ),
	'FormEdit' => array( 'Babak_data' ),
	'FormStart' => array( 'Tambah_tungkaran' ),
	'Templates' => array( 'Citakan' ),
	'UploadWindow' => array( 'Lalungkang_paunggahan' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'CreateCategory' => array( 'KrouiñRummad' ),
	'CreateTemplate' => array( 'KrouiñPatrom' ),
	'FormEdit' => array( 'OuzhpennañDanvez' ),
	'FormStart' => array( 'OuzhpennañPajenn' ),
	'Templates' => array( 'Patromoù' ),
);

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = array(
	'CreateCategory' => array( 'PravljenjeKategorije' ),
	'CreateForm' => array( 'PravljenjeObrasca' ),
	'CreateProperty' => array( 'PravljenjeSvojstva' ),
	'CreateTemplate' => array( 'PravljenjeSablon' ),
	'FormEdit' => array( 'DodavanjePodataka' ),
	'FormStart' => array( 'DodavanjeStranice' ),
	'Forms' => array( 'Obrasci' ),
	'Templates' => array( 'Sabloni' ),
	'UploadWindow' => array( 'ProzorPostavljanja' ),
);

/** буряад (буряад) */
$specialPageAliases['bxr'] = array(
	'CreateCategory' => array( 'Категори_үүсхэхэ' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'CreateCategory' => array( 'Kategorie_erstellen' ),
	'CreateClass' => array( 'Klasse_erstellen' ),
	'CreateForm' => array( 'Formular_erstellen' ),
	'CreateProperty' => array( 'Attribut_erstellen' ),
	'CreateTemplate' => array( 'Vorlage_erstellen' ),
	'FormEdit' => array( 'Mit_Formular_bearbeiten', 'Daten_hinzufügen', 'Daten_bearbeiten' ),
	'FormStart' => array( 'Mit_Formular_hinzufügen', 'Seite_hinzufügen' ),
	'Forms' => array( 'Formulare' ),
	'RunQuery' => array( 'Abfrage_ausführen' ),
	'Templates' => array( 'Vorlagen' ),
	'UploadWindow' => array( 'Hochladefenster' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'CreateCategory' => array( 'KategoriVıraze' ),
	'CreateClass' => array( 'SınıfeVıraze' ),
	'CreateForm' => array( 'FormVıraze' ),
	'CreateProperty' => array( 'XısusiyetiVıraze' ),
	'CreateTemplate' => array( 'ŞablonVıraze' ),
	'FormEdit' => array( 'FormiBıvurne', 'MelumatDeke', 'MelumatiBıvurne' ),
	'FormStart' => array( 'FormPêkerdış', 'PelaDeke' ),
	'Forms' => array( 'Formi' ),
	'RunQuery' => array( 'PersinBerdış' ),
	'Templates' => array( 'Şabloni' ),
	'UploadWindow' => array( 'TeqaBarkerdış' ),
);

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = array(
	'CreateCategory' => array( 'ΔημιουργίαΚατηγορίας' ),
	'CreateClass' => array( 'ΔημιουργίαΚλάσης' ),
	'CreateForm' => array( 'ΔημιουργίαΦόρμας' ),
	'CreateProperty' => array( 'ΔημιουργίαΙδιότητας' ),
	'CreateTemplate' => array( 'ΔημιουργίαΠροτύπου' ),
	'FormEdit' => array( 'ΕπεξεργασίαΦόρμας', 'ΠροσθήκηΔεδομένων', 'ΕπεξεργασίαΔεδομένων' ),
	'FormStart' => array( 'ΑρχήΦόρμας', 'ΠροσθήκηΣελίδας' ),
	'Forms' => array( 'Φόρμες' ),
	'RunQuery' => array( 'ΕκτέλεσηΕρωτήματος' ),
	'Templates' => array( 'Πρότυπα' ),
	'UploadWindow' => array( 'ΠαράθυροΑνεβάσματος' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'CreateCategory' => array( 'Krei_kategorion' ),
	'CreateClass' => array( 'Krei_klason' ),
	'CreateForm' => array( 'Krei_formularon' ),
	'Forms' => array( 'Formularoj' ),
);

/** Spanish (español) */
$specialPageAliases['es'] = array(
	'CreateCategory' => array( 'CrearCategoría', 'Crear_categoría' ),
	'Templates' => array( 'Plantillas' ),
);

/** Basque (euskara) */
$specialPageAliases['eu'] = array(
	'CreateCategory' => array( 'KategoriaSortu' ),
	'CreateTemplate' => array( 'TxantiloiaSortu' ),
	'Templates' => array( 'Txantiloiak' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'CreateCategory' => array( 'ایجاد_رده' ),
	'CreateClass' => array( 'ایجاد_کلاس' ),
	'CreateForm' => array( 'ایجاد_فرم' ),
	'CreateProperty' => array( 'ایجاد_صفت' ),
	'CreateTemplate' => array( 'ایجاد_الگو' ),
	'FormEdit' => array( 'ویرایش_داده' ),
	'FormStart' => array( 'افزودن_صفحه' ),
	'Forms' => array( 'فرم‌ها' ),
	'RunQuery' => array( 'اجرای_درخواست' ),
	'Templates' => array( 'الگوها' ),
	'UploadWindow' => array( 'پنجره_بارگذاری' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'CreateCategory' => array( 'Luo_luokka' ),
	'CreateClass' => array( 'Luo_semanttinen_tietotyyppi' ),
	'CreateForm' => array( 'Luo_lomake' ),
	'CreateProperty' => array( 'Luo_ominaisuus' ),
	'CreateTemplate' => array( 'Luo_malline' ),
	'FormEdit' => array( 'Lomakemuokkaus' ),
	'FormStart' => array( 'Lomakeluonti' ),
	'Forms' => array( 'Lomakkeet' ),
	'RunQuery' => array( 'Semanttinen_kysely' ),
	'Templates' => array( 'Mallineet' ),
);

/** French (français) */
$specialPageAliases['fr'] = array(
	'CreateCategory' => array( 'Créer_catégorie', 'CréerCatégorie' ),
	'CreateTemplate' => array( 'Créer_modèle', 'CréerModèle' ),
	'FormEdit' => array( 'AjouterDonnées', 'Ajouter_données' ),
	'FormStart' => array( 'AjouterPage', 'Ajouter_page' ),
	'Templates' => array( 'Modèles' ),
);

/** Franco-Provençal (arpetan) */
$specialPageAliases['frp'] = array(
	'CreateCategory' => array( 'Fâre_una_catègorie', 'FâreUnaCatègorie' ),
	'CreateForm' => array( 'Fâre_un_formulèro', 'FâreUnFormulèro' ),
	'CreateProperty' => array( 'Dèfenir_una_propriètât', 'DèfenirUnaPropriètât' ),
	'CreateTemplate' => array( 'Fâre_un_modèlo', 'FâreUnModèlo' ),
	'FormEdit' => array( 'Changiér_les_balyês', 'ChangiérLesBalyês' ),
	'FormStart' => array( 'Apondre_una_pâge', 'ApondreUnaPâge' ),
	'Forms' => array( 'Formulèros' ),
	'Templates' => array( 'Modèlos' ),
	'UploadWindow' => array( 'Fenétra_de_tèlèchargement', 'FenétraDeTèlèchargement' ),
);

/** Gagauz (Gagauz) */
$specialPageAliases['gag'] = array(
	'CreateCategory' => array( 'KategoriyaYarat' ),
	'Templates' => array( 'Şablonnar' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'Forms' => array( 'Formularios' ),
	'Templates' => array( 'Modelos' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'CreateCategory' => array( 'Kategori_aalege' ),
	'CreateClass' => array( 'Klass_erstelle' ),
	'CreateForm' => array( 'Form_aalege' ),
	'CreateProperty' => array( 'Eigeschaft_aalege' ),
	'CreateTemplate' => array( 'Template_aalege' ),
	'FormEdit' => array( 'Date_bearbeite' ),
	'FormStart' => array( 'Syte_zuegee' ),
	'Forms' => array( 'Form' ),
	'RunQuery' => array( 'Abfroog_ussfüere' ),
	'Templates' => array( 'Vorlage' ),
	'UploadWindow' => array( 'Fänschter_zum_Uffelade' ),
);

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'Forms' => array( 'Formulary' ),
	'Templates' => array( 'Předłohi' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'CreateCategory' => array( 'KreyeKategori' ),
	'CreateClass' => array( 'KreyeKlas' ),
	'CreateForm' => array( 'KreyeFòmilè' ),
	'CreateProperty' => array( 'KreyePropriete' ),
	'CreateTemplate' => array( 'KreyeModèl' ),
	'FormEdit' => array( 'ModifyeFòmilè', 'AjouteDòne', 'ModifyeDòne' ),
	'FormStart' => array( 'KòmanseFòmilè', 'AjoutePaj' ),
	'Forms' => array( 'FomilèYo' ),
	'RunQuery' => array( 'Enteroje' ),
	'Templates' => array( 'Modèl' ),
	'UploadWindow' => array( 'FenètChajman' ),
);

/** Hungarian (magyar) */
$specialPageAliases['hu'] = array(
	'CreateCategory' => array( 'Kategória_készítés' ),
	'CreateForm' => array( 'Űrlap_készítése' ),
	'CreateProperty' => array( 'Tulajdonság_készítése' ),
	'CreateTemplate' => array( 'Sablon_készítése' ),
	'FormEdit' => array( 'Adat_szerkesztése' ),
	'FormStart' => array( 'Lap_hozzáadása', 'Oldal_hozzáadása' ),
	'Forms' => array( 'Űrlapok' ),
	'Templates' => array( 'Sablonok' ),
	'UploadWindow' => array( 'Feltöltő_ablak' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'CreateCategory' => array( 'Crear_categoria' ),
	'CreateClass' => array( 'Crear_classe' ),
	'CreateForm' => array( 'Crear_formulario' ),
	'CreateProperty' => array( 'Crear_proprietate' ),
	'CreateTemplate' => array( 'Crear_patrono' ),
	'FormEdit' => array( 'Modificar_datos' ),
	'FormStart' => array( 'Adder_pagina' ),
	'Forms' => array( 'Formularios' ),
	'RunQuery' => array( 'Executar_consulta' ),
	'Templates' => array( 'Patronos' ),
	'UploadWindow' => array( 'Cargar_fenestra' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'CreateCategory' => array( 'Buat_kategori', 'BuatKategori' ),
	'CreateClass' => array( 'Buat_kelas', 'BuatKelas' ),
	'CreateForm' => array( 'Buat_formulir', 'BuatFormulir' ),
	'CreateProperty' => array( 'Buat_properti', 'BuatProperti' ),
	'CreateTemplate' => array( 'Buat_templat', 'BuatTemplat' ),
	'FormEdit' => array( 'Sunting_data', 'SuntingData' ),
	'FormStart' => array( 'Tambah_halaman', 'TambahHalaman' ),
	'Forms' => array( 'Formulir_semantik', 'FormulirSemantik' ),
	'RunQuery' => array( 'Jalankan_kueri', 'JalankanKueri' ),
	'Templates' => array( 'Templat' ),
	'UploadWindow' => array( 'Jendela_pengunggahan', 'JendelaPengunggahan' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'CreateCategory' => array( 'CreaCategoria' ),
	'CreateClass' => array( 'CreaClasse' ),
	'CreateForm' => array( 'CreaModulo' ),
	'CreateProperty' => array( 'CreaProprietà' ),
	'CreateTemplate' => array( 'CreaTemplate' ),
	'FormEdit' => array( 'ModificaDati' ),
	'FormStart' => array( 'AggiungiPagina' ),
	'Forms' => array( 'Moduli' ),
	'RunQuery' => array( 'EseguiRicerca' ),
	'Templates' => array( 'Template' ),
	'UploadWindow' => array( 'AggiornaFinestra' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'CreateCategory' => array( 'カテゴリ作成' ),
	'CreateClass' => array( 'クラス作成' ),
	'CreateForm' => array( 'フォーム作成' ),
	'CreateProperty' => array( 'プロパティ作成' ),
	'CreateTemplate' => array( 'テンプレート作成' ),
	'FormEdit' => array( 'データ編集' ),
	'FormStart' => array( 'ページ追加' ),
	'Forms' => array( 'フォーム一覧' ),
	'RunQuery' => array( 'クエリ実行' ),
	'Templates' => array( 'テンプレート一覧' ),
	'UploadWindow' => array( 'アップロードウィンドウ' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'CreateCategory' => array( 'კატეგორიის_შექმნა' ),
	'CreateClass' => array( 'კლასის_შექმნა' ),
	'CreateTemplate' => array( 'თარგის_შექმნა' ),
	'Templates' => array( 'თარგები' ),
	'UploadWindow' => array( 'ატვირთვის_ფანჯარა' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'CreateCategory' => array( 'បង្កើតចំណាត់ត់ថ្នាក់ក្រុម' ),
	'CreateForm' => array( 'បង្កើត​ទម្រង់' ),
	'CreateTemplate' => array( 'បង្កើតទំព័រគំរូ' ),
	'FormEdit' => array( 'កែប្រែទិន្នន័យ' ),
	'FormStart' => array( 'បន្ថែមទំព័រ' ),
	'Forms' => array( 'ទម្រង់​នានា' ),
	'Templates' => array( 'ទំព័រគំរូ' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'CreateCategory' => array( '분류추가' ),
	'CreateClass' => array( '클래스추가' ),
	'CreateForm' => array( '양식추가' ),
	'CreateProperty' => array( '속성추가' ),
	'CreateTemplate' => array( '틀추가' ),
	'FormEdit' => array( '데이터편집' ),
	'FormStart' => array( '양식시작', '문서추가' ),
	'Forms' => array( '양식목록' ),
	'RunQuery' => array( '쿼리실행' ),
	'Templates' => array( '틀목록' ),
	'UploadWindow' => array( '올리기창' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'CreateCategory' => array( 'Saachjropp aanlääje' ),
	'CreateForm' => array( 'Fommulaa aanlääje' ),
	'CreateProperty' => array( 'Eijeschaff aanlääje' ),
	'CreateTemplate' => array( 'Schabloon aanlääje' ),
	'FormEdit' => array( 'Date ändere' ),
	'FormStart' => array( 'Sigg dobei donn' ),
	'Forms' => array( 'Fommulaare' ),
	'Templates' => array( 'Schabloone' ),
	'UploadWindow' => array( 'Finster zum Huhlaade', 'Finster zom Huhlaade' ),
);

/** Cornish (kernowek) */
$specialPageAliases['kw'] = array(
	'CreateCategory' => array( 'FormyaClass' ),
	'CreateClass' => array( 'GwruthylClass' ),
	'CreateForm' => array( 'FormyaFurvlen' ),
	'CreateTemplate' => array( 'FormyaScantlyn' ),
	'Templates' => array( 'Scantlyns' ),
);

/** Ladino (Ladino) */
$specialPageAliases['lad'] = array(
	'Templates' => array( 'Xabblones' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'CreateCategory' => array( 'Kategorie_uleeën' ),
	'CreateForm' => array( 'Formulaire_uleeën' ),
	'CreateProperty' => array( 'Eegeschaften_uleeën' ),
	'CreateTemplate' => array( 'Schabloun_uleeën' ),
	'FormEdit' => array( 'Daten_änneren' ),
	'FormStart' => array( 'Säit_derbäisetzen' ),
	'Forms' => array( 'Formulairen' ),
	'RunQuery' => array( 'Ufro_ausféieren' ),
	'Templates' => array( 'Schablounen' ),
	'UploadWindow' => array( 'Fënster_eroplueden' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'CreateCategory' => array( 'СоздајКатегорија' ),
	'CreateClass' => array( 'СоздајКласа' ),
	'CreateForm' => array( 'СоздајФорум' ),
	'CreateProperty' => array( 'СоздајСвојство' ),
	'CreateTemplate' => array( 'СоздајШаблон' ),
	'FormEdit' => array( 'УредиПодаток' ),
	'FormStart' => array( 'ДодајСтраница' ),
	'Forms' => array( 'Форми' ),
	'RunQuery' => array( 'ПуштиБарање' ),
	'Templates' => array( 'Шаблони' ),
	'UploadWindow' => array( 'ПрозорецЗаПодигање' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'CreateCategory' => array( 'വർഗ്ഗസൃഷ്ടി' ),
	'CreateForm' => array( 'ഫോംസൃഷ്ടി' ),
	'CreateTemplate' => array( 'ഫലകസൃഷ്ടി' ),
	'FormEdit' => array( 'വിവരങ്ങൾതിരുത്തുക' ),
	'FormStart' => array( 'താൾചേർക്കുക' ),
	'Forms' => array( 'ഫോമുകൾ' ),
	'Templates' => array( 'ഫലകങ്ങൾ' ),
	'UploadWindow' => array( 'അപ്‌ലോഡ്ജാലകം' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'CreateCategory' => array( 'वर्गतयारकरा' ),
	'CreateForm' => array( 'फॉर्मतयारकरा' ),
	'CreateProperty' => array( 'वैशिष्ट्येतयारकरा' ),
	'CreateTemplate' => array( 'साचेतयारकरा' ),
	'FormEdit' => array( 'विदासंपादा' ),
	'FormStart' => array( 'पानजोडा' ),
	'Forms' => array( 'फॉर्म्स' ),
	'Templates' => array( 'साचे' ),
	'UploadWindow' => array( 'चढवाखिडकी' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'CreateCategory' => array( 'OħloqKategorija' ),
	'FormEdit' => array( 'ŻidDati' ),
	'FormStart' => array( 'ŻidPaġna' ),
	'Templates' => array( 'Mudelli' ),
);

/** Erzya (эрзянь) */
$specialPageAliases['myv'] = array(
	'Forms' => array( 'Парцунт' ),
	'Templates' => array( 'ЛопаПарцунт' ),
);

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = array(
	'CreateCategory' => array( 'Opprett_kategori' ),
	'CreateClass' => array( 'Opprett_klasse' ),
	'CreateForm' => array( 'Opprett_skjema' ),
	'CreateProperty' => array( 'Opprett_egenskap' ),
	'CreateTemplate' => array( 'Opprett_mal' ),
	'FormEdit' => array( 'Rediger_data', 'Legg_til_data' ),
	'FormStart' => array( 'Legg_til_side' ),
	'Forms' => array( 'Skjemaer' ),
	'RunQuery' => array( 'Kjør_spørring' ),
	'Templates' => array( 'Maler' ),
	'UploadWindow' => array( 'Opplastingsvindu' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'CreateCategory' => array( 'Kategorie_anmaken' ),
	'CreateClass' => array( 'Klasse_anmaken' ),
	'CreateForm' => array( 'Formulier_anmaken' ),
	'CreateProperty' => array( 'Eigenschap_anmaken' ),
	'CreateTemplate' => array( 'Mal_anmaken' ),
	'FormEdit' => array( 'Gegevens_bewarken' ),
	'FormStart' => array( 'Pagina_derbie_doon' ),
	'Forms' => array( 'Formulieren' ),
	'RunQuery' => array( 'Zeukopdrachte_uutvoeren' ),
	'Templates' => array( 'Mallen' ),
	'UploadWindow' => array( 'Bestaandenscharm' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'CreateCategory' => array( 'CategorieAanmaken' ),
	'CreateClass' => array( 'KlasseAanmaken' ),
	'CreateForm' => array( 'FormulierAanmaken' ),
	'CreateProperty' => array( 'EigenschapAanmaken' ),
	'CreateTemplate' => array( 'SjabloonAanmaken' ),
	'FormEdit' => array( 'GegevensBewerken', 'GegevensToevoegen' ),
	'FormStart' => array( 'PaginaToevoegen' ),
	'Forms' => array( 'Formulieren' ),
	'RunQuery' => array( 'ZoekopdrachtUitvoeren' ),
	'Templates' => array( 'Sjablonen' ),
	'UploadWindow' => array( 'Uploadscherm' ),
);

/** Occitan (occitan) */
$specialPageAliases['oc'] = array(
	'CreateCategory' => array( 'Crear una categoria', 'CrearCategoria' ),
	'CreateForm' => array( 'Crear un formulari', 'CrearFormulari' ),
	'CreateProperty' => array( 'Crear una proprietat', 'CrearProprietat' ),
	'CreateTemplate' => array( 'Crear un modèl', 'CrearModèl' ),
	'FormStart' => array( 'Apondre una pagina', 'ApondrePagina' ),
	'Forms' => array( 'Formularis' ),
	'Templates' => array( 'Modèls' ),
);

/** Oriya (ଓଡ଼ିଆ) */
$specialPageAliases['or'] = array(
	'CreateCategory' => array( 'ଶ୍ରେଣୀ_ତିଆରି_କରନ୍ତୁ' ),
	'CreateForm' => array( 'ଫରମ_ତିଆରି_କରନ୍ତୁ' ),
	'CreateTemplate' => array( 'ଛାଞ୍ଚ_ତିଆରି_କରନ୍ତୁ' ),
	'FormEdit' => array( 'ଫରମ_ବଦଳାନ୍ତୁ' ),
	'FormStart' => array( 'ଫରମ_ଆରମ୍ଭ_କରନ୍ତୁ' ),
	'Forms' => array( 'ଫରମ' ),
	'Templates' => array( 'ଛାଞ୍ଚ' ),
	'UploadWindow' => array( 'ଉଇଣ୍ଡୋ_ଅପଲୋଡ଼_କରନ୍ତୁ' ),
);

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = array(
	'CreateCategory' => array( 'ਸ਼੍ਰੇਣੀ_ਬਣਾਓ' ),
	'CreateTemplate' => array( 'ਸਾਂਚਾ_ਬਣਾਓ' ),
	'Templates' => array( 'ਸਾਂਚੇ' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'CreateCategory' => array( 'UtwórzKategorię' ),
	'CreateClass' => array( 'UtwórzKlasę' ),
	'CreateForm' => array( 'UtwórzFormularz' ),
	'CreateProperty' => array( 'UtwórzWłaściwość' ),
	'CreateTemplate' => array( 'UtwórzSzablon' ),
	'Forms' => array( 'Formularze' ),
	'Templates' => array( 'Szablony' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'CreateCategory' => array( 'وېشنيزه جوړول' ),
	'CreateProperty' => array( 'د جوړولو ځانتيا' ),
	'CreateTemplate' => array( 'کينډۍ جوړول' ),
	'FormStart' => array( 'مخ ګډول' ),
	'Templates' => array( 'کينډۍ' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'CreateCategory' => array( 'Criar_categoria' ),
	'CreateForm' => array( 'Criar_formulário' ),
	'CreateProperty' => array( 'Criar_propriedade' ),
	'CreateTemplate' => array( 'Criar_modelo' ),
	'FormEdit' => array( 'Editar_dados' ),
	'FormStart' => array( 'Adicionar_página' ),
	'Forms' => array( 'Formulários' ),
	'Templates' => array( 'Modelos' ),
	'UploadWindow' => array( 'Janela_de_carregamento' ),
);

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'Forms' => array( 'Formulários' ),
	'Templates' => array( 'Predefinições' ),
	'UploadWindow' => array( 'Tela_de_envio' ),
);

/** Romanian (română) */
$specialPageAliases['ro'] = array(
	'Templates' => array( 'Formate' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'CreateCategory' => array( 'CreaCategoria' ),
	'CreateClass' => array( 'CreaClasse' ),
	'CreateForm' => array( 'CreaModulo' ),
	'CreateProperty' => array( 'CreaProprietà' ),
	'CreateTemplate' => array( 'CreaTemplate' ),
	'FormEdit' => array( 'ModificaDati' ),
	'FormStart' => array( 'AggiungiPagina' ),
	'Forms' => array( 'Moduli' ),
	'RunQuery' => array( 'EseguiRicerca' ),
	'Templates' => array( 'Template' ),
	'UploadWindow' => array( 'AggiornaFinestra' ),
);

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = array(
	'CreateCategory' => array( 'VytvoriťKategóriu' ),
	'CreateForm' => array( 'VytvoriťFormulár' ),
	'CreateProperty' => array( 'VytvoriťVlastnosť' ),
	'CreateTemplate' => array( 'VytvoriťŠablónu' ),
	'FormEdit' => array( 'UpraviťDáta' ),
	'FormStart' => array( 'PridaťStránku' ),
	'Forms' => array( 'Formuláre' ),
	'Templates' => array( 'Šablóny' ),
	'UploadWindow' => array( 'NahrávacieOkno' ),
);

/** Albanian (shqip) */
$specialPageAliases['sq'] = array(
	'Forms' => array( 'Format' ),
	'Templates' => array( 'Stampat' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = array(
	'CreateCategory' => array( 'НаправиКатегорију' ),
	'CreateClass' => array( 'Направи_класу' ),
	'CreateForm' => array( 'Направи_образац' ),
	'CreateProperty' => array( 'Направи_својство' ),
	'CreateTemplate' => array( 'Направи_шаблон' ),
	'FormEdit' => array( 'Уреди_образац' ),
	'FormStart' => array( 'ДодајСтраницу', 'Додај_страницу' ),
	'Forms' => array( 'Обрасци' ),
	'Templates' => array( 'Шаблони' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'CreateCategory' => array( 'Skapa_kategori' ),
	'Templates' => array( 'Mallar' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'CreateCategory' => array( 'UndaJamii' ),
	'CreateForm' => array( 'UndaFomu' ),
	'CreateTemplate' => array( 'UndaKigezo' ),
	'FormEdit' => array( 'HaririData' ),
	'FormStart' => array( 'WekaKurasa' ),
	'Forms' => array( 'Fomu' ),
	'Templates' => array( 'Vigezo' ),
	'UploadWindow' => array( 'DirishalaKupakizia' ),
);

/** Thai (ไทย) */
$specialPageAliases['th'] = array(
	'CreateCategory' => array( 'สร้างหมวดหมู่' ),
	'CreateClass' => array( 'สร้างคลาส' ),
	'CreateForm' => array( 'สร้างแบบฟอร์ม' ),
	'CreateProperty' => array( 'สร้างคุณสมบัติ' ),
	'CreateTemplate' => array( 'สร้างแม่แบบ' ),
	'FormEdit' => array( 'แก้ไขแบบฟอร์ม' ),
	'FormStart' => array( 'เริ่มแบบฟอร์ม' ),
	'Forms' => array( 'แบบฟอร์ม' ),
	'Templates' => array( 'แม่แบบ' ),
	'UploadWindow' => array( 'หน้าต่างอัปโหลด' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'CreateCategory' => array( 'Likhain_ang_kaurian' ),
	'CreateForm' => array( 'Likhain_ang_pormularyo' ),
	'CreateProperty' => array( 'Likhain_ang_pag-aari' ),
	'CreateTemplate' => array( 'Likhain_ang_suleras' ),
	'FormEdit' => array( 'Baguhin_ang_dato' ),
	'FormStart' => array( 'Idagdag_ang_pahina' ),
	'Forms' => array( 'Mga_pormularyo' ),
	'Templates' => array( 'Mga_suleras' ),
	'UploadWindow' => array( 'Bintana_ng_pagkarga' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'CreateCategory' => array( 'KategoriOluştur', 'UlamOluştur' ),
	'CreateClass' => array( 'SınıfOluştur' ),
	'CreateForm' => array( 'FormOluştur' ),
	'CreateProperty' => array( 'ÖzellikOluştur' ),
	'CreateTemplate' => array( 'ŞablonOluştur' ),
	'FormEdit' => array( 'VeriDüzenle', 'VeriDeğiştir' ),
	'FormStart' => array( 'SayfaEkle' ),
	'Forms' => array( 'Formlar' ),
	'RunQuery' => array( 'SorguYürüt' ),
	'Templates' => array( 'Şablonlar' ),
	'UploadWindow' => array( 'YüklemePenceresi' ),
);

/** Tatar (Cyrillic script) (татарча) */
$specialPageAliases['tt-cyrl'] = array(
	'CreateTemplate' => array( 'Үрнәкне_үзгәртү' ),
	'Templates' => array( 'Үрнәкләр' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'CreateCategory' => array( 'Створити_категорію' ),
	'CreateClass' => array( 'Створити_клас' ),
	'CreateForm' => array( 'Створити_форму' ),
	'CreateProperty' => array( 'Створити_властивість' ),
	'CreateTemplate' => array( 'Створити_шаблон' ),
	'Forms' => array( 'Форми' ),
	'Templates' => array( 'Шаблони' ),
);

/** vèneto (vèneto) */
$specialPageAliases['vec'] = array(
	'CreateTemplate' => array( 'CreaModèl' ),
	'FormEdit' => array( 'ZontaDati' ),
	'FormStart' => array( 'ZontaPagina' ),
	'Templates' => array( 'Modèi' ),
	'UploadWindow' => array( 'AjornaFenestra' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'Forms' => array( 'Biểu_mẫu' ),
	'UploadWindow' => array( 'Cửa_sổ_tải_lên' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'CreateCategory' => array( '创建分类' ),
	'CreateClass' => array( '创建类' ),
	'CreateForm' => array( '创建表格' ),
	'CreateProperty' => array( '创建属性' ),
	'CreateTemplate' => array( '创建模板' ),
	'FormEdit' => array( '编辑表格', '添加数据', '编辑数据' ),
	'FormStart' => array( '表格起始', '添加页面' ),
	'Forms' => array( '表格' ),
	'RunQuery' => array( '执行查询' ),
	'Templates' => array( '模板' ),
	'UploadWindow' => array( '上传窗口' ),
);