<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'ReplaceText' => array( 'ReplaceText' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'ReplaceText' => array( 'استبدال_نص' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'ReplaceText' => array( 'تبديل_نص' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'ReplaceText' => array( 'Erlc\'hiañTestenn' ),
);

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = array(
	'ReplaceText' => array( 'ZamjenaTeksta' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'ReplaceText' => array( 'Text_ersetzen' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'ReplaceText' => array( 'MetinVurnayış' ),
);

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'ReplaceText' => array( 'Tekst wuměniś' ),
);

/** Divehi (ދިވެހިބަސް) */
$specialPageAliases['dv'] = array(
	'ReplaceText' => array( 'ލިޔުން ބަދަލުކުރައްވާ' ),
);

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = array(
	'ReplaceText' => array( 'ΑντικατάστασηΚειμένου' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'ReplaceText' => array( 'جایگزینی_متن' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'ReplaceText' => array( 'Korvaa' ),
);

/** French (français) */
$specialPageAliases['fr'] = array(
	'ReplaceText' => array( 'Remplacer_texte', 'RemplacerTexte' ),
);

/** Franco-Provençal (arpetan) */
$specialPageAliases['frp'] = array(
	'ReplaceText' => array( 'Remplaciér_lo_tèxto', 'RemplaciérLoTèxto' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'ReplaceText' => array( 'Substituír_o_texto' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'ReplaceText' => array( 'Täxt_ersetze' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'ReplaceText' => array( 'החלפת_טקסט' ),
);

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = array(
	'ReplaceText' => array( 'Zamjeni_tekst' ),
);

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'ReplaceText' => array( 'Tekst narunać' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'ReplaceText' => array( 'RanplaseTeks' ),
);

/** Hungarian (magyar) */
$specialPageAliases['hu'] = array(
	'ReplaceText' => array( 'Szöveg_csere' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'ReplaceText' => array( 'Reimplaciar_texto' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'ReplaceText' => array( 'Ganti_teks', 'GantiTeks' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'ReplaceText' => array( 'SostituisciTesto' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'ReplaceText' => array( '文字列置換', '文字列の置換' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'ReplaceText' => array( 'ជំនួសអត្ថបទ' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'ReplaceText' => array( '찾아바꾸기' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'ReplaceText' => array( 'Tex tuusche' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'ReplaceText' => array( 'Text_ersetzen' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'ReplaceText' => array( 'ЗамениТекст' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'ReplaceText' => array( 'പകരംഎഴുത്ത്' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'ReplaceText' => array( 'मजकुरबदला' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'ReplaceText' => array( 'BiddelTest' ),
);

/** Norwegian Bokmål (norsk (bokmål)‎) */
$specialPageAliases['nb'] = array(
	'ReplaceText' => array( 'Teksterstatning' ),
);

/** Nedersaksies (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'ReplaceText' => array( 'Tekste_vervangen' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'ReplaceText' => array( 'TekstVervangen' ),
);

/** Occitan (occitan) */
$specialPageAliases['oc'] = array(
	'ReplaceText' => array( 'Remplaçar tèxte', 'RemplaçarTèxte' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'ReplaceText' => array( 'Substituir_texto' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'ReplaceText' => array( 'SostituisciTesto' ),
);

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = array(
	'ReplaceText' => array( 'NahradiťText' ),
);

/** Albanian (shqip) */
$specialPageAliases['sq'] = array(
	'ReplaceText' => array( 'ZëvendësoTekstin' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = array(
	'ReplaceText' => array( 'ЗамениТекст', 'Замени_текст' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'ReplaceText' => array( 'Ersätt_text' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'ReplaceText' => array( 'PandikiziaMatini' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'ReplaceText' => array( 'Palitan_ang_teksto' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'ReplaceText' => array( 'MetniDeğiştir' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'ReplaceText' => array( 'Замінити_текст' ),
);

/** vèneto (vèneto) */
$specialPageAliases['vec'] = array(
	'ReplaceText' => array( 'SostuituissiTesto' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'ReplaceText' => array( 'Thay_văn_bản' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'ReplaceText' => array( '替换文本' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'ReplaceText' => array( '替換文本' ),
);