<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    const Err1 = "Security error: Call to private object member not allowed";
    const Err2 = "Security error: Call to dynamic object member not allowed";
    const Err3 = "PHP in template not allowed. Use SmartyBC to enable it";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;
    private $strip = false;

    function __construct($lex, $compiler) {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
        $this->compiler->prefix_code = array();
        $this->prefix_number = 0;
        $this->block_nesting_level = 0;
        if ($this->security = isset($this->smarty->security_policy)) {
            $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
            $this->php_handling = $this->smarty->php_handling;
        }
        $this->is_xml = false;
        $this->asp_tags = (ini_get('asp_tags') != '0');
        $this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }

    public static function escape_start_tag($tag_text) {
        $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
        return $tag;
    }

    public static function escape_end_tag($tag_text) {
        return '?<?php ?>>';
    }

    public function compileVariable($variable) {
        if (strpos($variable,'(') == 0) {
            // not a variable variable
            $var = trim($variable,'\'');
            $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable($var, null, true, false)->nocache;
            $this->template->properties['variables'][$var] = $this->compiler->tag_nocache|$this->compiler->nocache;
        }
//       return '(isset($_smarty_tpl->tpl_vars['. $variable .'])?$_smarty_tpl->tpl_vars['. $variable .']->value:$_smarty_tpl->getVariable('. $variable .')->value)';
        return '$_smarty_tpl->tpl_vars['. $variable .']->value';
    }
#line 132 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_TEXT                           = 10;
    const TP_STRIPON                        = 11;
    const TP_STRIPOFF                       = 12;
    const TP_LITERALSTART                   = 13;
    const TP_LITERALEND                     = 14;
    const TP_LITERAL                        = 15;
    const TP_LDEL                           = 16;
    const TP_RDEL                           = 17;
    const TP_DOLLAR                         = 18;
    const TP_ID                             = 19;
    const TP_EQUAL                          = 20;
    const TP_PTR                            = 21;
    const TP_LDELIF                         = 22;
    const TP_LDELFOR                        = 23;
    const TP_SEMICOLON                      = 24;
    const TP_INCDEC                         = 25;
    const TP_TO                             = 26;
    const TP_STEP                           = 27;
    const TP_LDELFOREACH                    = 28;
    const TP_SPACE                          = 29;
    const TP_AS                             = 30;
    const TP_APTR                           = 31;
    const TP_LDELSETFILTER                  = 32;
    const TP_SMARTYBLOCKCHILD               = 33;
    const TP_LDELSLASH                      = 34;
    const TP_INTEGER                        = 35;
    const TP_COMMA                          = 36;
    const TP_OPENP                          = 37;
    const TP_CLOSEP                         = 38;
    const TP_MATH                           = 39;
    const TP_UNIMATH                        = 40;
    const TP_ANDSYM                         = 41;
    const TP_ISIN                           = 42;
    const TP_ISDIVBY                        = 43;
    const TP_ISNOTDIVBY                     = 44;
    const TP_ISEVEN                         = 45;
    const TP_ISNOTEVEN                      = 46;
    const TP_ISEVENBY                       = 47;
    const TP_ISNOTEVENBY                    = 48;
    const TP_ISODD                          = 49;
    const TP_ISNOTODD                       = 50;
    const TP_ISODDBY                        = 51;
    const TP_ISNOTODDBY                     = 52;
    const TP_INSTANCEOF                     = 53;
    const TP_QMARK                          = 54;
    const TP_NOT                            = 55;
    const TP_TYPECAST                       = 56;
    const TP_HEX                            = 57;
    const TP_DOT                            = 58;
    const TP_SINGLEQUOTESTRING              = 59;
    const TP_DOUBLECOLON                    = 60;
    const TP_AT                             = 61;
    const TP_HATCH                          = 62;
    const TP_OPENB                          = 63;
    const TP_CLOSEB                         = 64;
    const TP_EQUALS                         = 65;
    const TP_NOTEQUALS                      = 66;
    const TP_GREATERTHAN                    = 67;
    const TP_LESSTHAN                       = 68;
    const TP_GREATEREQUAL                   = 69;
    const TP_LESSEQUAL                      = 70;
    const TP_IDENTITY                       = 71;
    const TP_NONEIDENTITY                   = 72;
    const TP_MOD                            = 73;
    const TP_LAND                           = 74;
    const TP_LOR                            = 75;
    const TP_LXOR                           = 76;
    const TP_QUOTE                          = 77;
    const TP_BACKTICK                       = 78;
    const TP_DOLLARID                       = 79;
    const YY_NO_ACTION = 592;
    const YY_ACCEPT_ACTION = 591;
    const YY_ERROR_ACTION = 590;

    const YY_SZ_ACTTAB = 2562;
static public $yy_action = array(
 /*     0 */   218,  317,  318,  320,  319,  316,  315,  311,  310,  312,
 /*    10 */   313,  314,  321,  322,  197,  193,  187,   43,  591,   95,
 /*    20 */   255,  318,  320,    6,  107,  292,   38,   11,   42,  154,
 /*    30 */   283,   13,  181,  245,  295,  241,  262,  284,   51,   50,
 /*    40 */    52,   44,   23,   28,  367,  374,   33,   32,  375,  383,
 /*    50 */    21,   31,  328,  323,  325,  326,  324,    9,   36,  353,
 /*    60 */   265,  197,  331,  329,  384,  385,  386,  382,  381,  377,
 /*    70 */   376,  378,  379,  282,  380,  362,  218,  344,    4,  106,
 /*    80 */   175,  120,    7,   11,   82,  129,  283,   12,  456,  292,
 /*    90 */   453,   27,  291,  301,  361,  109,  387,  236,  368,  365,
 /*   100 */   456,  343,  453,  243,   42,  136,  200,   37,    7,  267,
 /*   110 */     7,  219,  256,    7,   51,   50,   52,   44,   23,   28,
 /*   120 */   367,  374,   33,   32,  375,  383,   21,   31,  239,   99,
 /*   130 */   171,  136,   36,  136,  261,   26,  136,  123,  373,  292,
 /*   140 */   384,  385,  386,  382,  381,  377,  376,  378,  379,  282,
 /*   150 */   380,  362,  218,  344,  369,  218,  200,  132,  158,  184,
 /*   160 */    68,  119,  235,   11,   11,  153,  283,  283,  337,  301,
 /*   170 */   361,  458,  306,  236,  368,  365,   42,  343,  252,  284,
 /*   180 */    42,  191,  218,  458,  250,   11,  200,  287,  283,   12,
 /*   190 */    51,   50,   52,   44,   23,   28,  367,  374,   33,   32,
 /*   200 */   375,  383,   21,   31,  302,  108,  168,   49,  200,  232,
 /*   210 */    11,  218,   35,  283,  240,  292,  384,  385,  386,  382,
 /*   220 */   381,  377,  376,  378,  379,  282,  380,  362,  218,  344,
 /*   230 */   207,  218,  200,  132,   49,    8,   54,  119,  142,   11,
 /*   240 */    14,  158,  283,  110,  342,  301,  361,  455,  152,  236,
 /*   250 */   368,  365,   42,  343,  231,  239,   42,  350,  103,  455,
 /*   260 */   248,  199,  339,   49,  343,  345,   51,   50,   52,   44,
 /*   270 */    23,   28,  367,  374,   33,   32,  375,  383,   21,   31,
 /*   280 */   128,  183,  174,   49,  370,  163,  198,  339,   15,  158,
 /*   290 */   292,  292,  384,  385,  386,  382,  381,  377,  376,  378,
 /*   300 */   379,  282,  380,  362,  218,  344,  192,  218,  201,  120,
 /*   310 */   344,  272,   82,  129,  156,  164,  270,  218,  129,  158,
 /*   320 */   273,  301,  361,  458,  292,  236,  368,  365,  128,  343,
 /*   330 */   236,  368,  365,  296,  343,  458,  284,  244,  130,  227,
 /*   340 */   260,  330,   51,   50,   52,   44,   23,   28,  367,  374,
 /*   350 */    33,   32,  375,  383,   21,   31,  207,  196,  339,   49,
 /*   360 */    41,    8,  127,  162,  251,  229,  212,  242,  384,  385,
 /*   370 */   386,  382,  381,  377,  376,  378,  379,  282,  380,  362,
 /*   380 */   218,  344,  101,  218,  176,  132,  344,  140,   78,  129,
 /*   390 */   148,  166,  249,  292,  129,  186,  278,  301,  361,  327,
 /*   400 */   292,  236,  368,  365,  292,  343,  236,  368,  365,    5,
 /*   410 */   343,   42,  211,   36,  121,  281,  284,  201,   51,   50,
 /*   420 */    52,   44,   23,   28,  367,  374,   33,   32,  375,  383,
 /*   430 */    21,   31,  218,  178,    7,   49,  179,  275,  225,  185,
 /*   440 */    11,  284,  292,  283,  384,  385,  386,  382,  381,  377,
 /*   450 */   376,  378,  379,  282,  380,  362,   17,  136,   11,  201,
 /*   460 */   170,  226,  173,  200,  284,  141,  247,  223,  335,  292,
 /*   470 */    51,   50,   52,   44,   23,   28,  367,  374,   33,   32,
 /*   480 */   375,  383,   21,   31,  135,  218,  201,  359,   11,   11,
 /*   490 */    11,  238,  213,  234,  188,  302,  384,  385,  386,  382,
 /*   500 */   381,  377,  376,  378,  379,  282,  380,  362,  195,  351,
 /*   510 */   189,  366,  251,  235,  218,  251,  264,  333,  146,  332,
 /*   520 */   305,  200,  143,   51,   50,   52,   44,   23,   28,  367,
 /*   530 */   374,   33,   32,  375,  383,   21,   31,  218,  203,  137,
 /*   540 */    15,  297,   42,  271,  194,   19,   98,  116,  102,  384,
 /*   550 */   385,  386,  382,  381,  377,  376,  378,  379,  282,  380,
 /*   560 */   362,  372,  372,  372,  300,   34,  224,  138,   39,  139,
 /*   570 */   225,  146,  131,  133,  159,   51,   50,   52,   44,   23,
 /*   580 */    28,  367,  374,   33,   32,  375,  383,   21,   31,  372,
 /*   590 */   172,  334,   94,  299,  276,  302,    2,  371,    4,  292,
 /*   600 */   125,  384,  385,  386,  382,  381,  377,  376,  378,  379,
 /*   610 */   282,  380,  362,  218,  344,  372,  218,  308,  132,  344,
 /*   620 */   287,   78,  129,  150,  370,  201,  161,  129,  160,  204,
 /*   630 */   301,  361,  341,   29,  236,  368,  365,  292,  343,  236,
 /*   640 */   368,  365,  218,  343,  284,  216,   42,   20,  277,  284,
 /*   650 */   263,   51,   50,   52,   44,   23,   28,  367,  374,   33,
 /*   660 */    32,  375,  383,   21,   31,  218,  228,   45,   49,   16,
 /*   670 */   326,  249,  104,  326,  326,  118,  105,  384,  385,  386,
 /*   680 */   382,  381,  377,  376,  378,  379,  282,  380,  362,  340,
 /*   690 */   372,  372,  326,  326,  326,  326,  326,  326,  326,  326,
 /*   700 */   326,   42,  237,   51,   50,   52,   44,   23,   28,  367,
 /*   710 */   374,   33,   32,  375,  383,   21,   31,  218,  326,  326,
 /*   720 */   326,  326,  326,  326,  326,  326,  114,  326,  218,  384,
 /*   730 */   385,  386,  382,  381,  377,  376,  378,  379,  282,  380,
 /*   740 */   362,  372,  353,  326,  307,  326,  326,  326,  326,  326,
 /*   750 */   326,  326,  326,  326,  268,   51,   50,   52,   44,   23,
 /*   760 */    28,  367,  374,   33,   32,  375,  383,   21,   31,  218,
 /*   770 */   326,  326,  326,  326,  326,  326,  326,  326,   97,  355,
 /*   780 */   112,  384,  385,  386,  382,  381,  377,  376,  378,  379,
 /*   790 */   282,  380,  362,  372,  326,  372,  326,   42,  326,  326,
 /*   800 */   326,  326,  326,  326,  326,  326,  158,   51,   50,   52,
 /*   810 */    44,   23,   28,  367,  374,   33,   32,  375,  383,   21,
 /*   820 */    31,  218,  326,  326,  326,  326,  326,  326,  326,  326,
 /*   830 */   326,  326,  326,  384,  385,  386,  382,  381,  377,  376,
 /*   840 */   378,  379,  282,  380,  362,  128,  326,  326,  326,  326,
 /*   850 */   326,  326,  326,  326,  326,  326,  326,  326,  326,   51,
 /*   860 */    50,   52,   44,   23,   28,  367,  374,   33,   32,  375,
 /*   870 */   383,   21,   31,  326,  326,  326,  326,  326,  326,  326,
 /*   880 */   326,  326,  326,  326,  266,  384,  385,  386,  382,  381,
 /*   890 */   377,  376,  378,  379,  282,  380,  362,  218,  326,  326,
 /*   900 */   326,  326,  190,  344,  326,  326,   11,  145,  354,  283,
 /*   910 */   288,  129,  218,  202,   18,   24,   22,  218,   45,   42,
 /*   920 */     6,  107,   42,  236,  368,  365,  154,  343,  286,  200,
 /*   930 */   245,  295,  241,  285,  326,   51,   50,   52,   44,   23,
 /*   940 */    28,  367,  374,   33,   32,  375,  383,   21,   31,  218,
 /*   950 */    10,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*   960 */   326,  384,  385,  386,  382,  381,  377,  376,  378,  379,
 /*   970 */   282,  380,  362,  326,  326,  356,   40,  352,  326,  326,
 /*   980 */   326,  326,  326,  326,  326,  326,  326,   51,   50,   52,
 /*   990 */    44,   23,   28,  367,  374,   33,   32,  375,  383,   21,
 /*  1000 */    31,  218,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  1010 */   326,  326,  326,  384,  385,  386,  382,  381,  377,  376,
 /*  1020 */   378,  379,  282,  380,  362,  326,  326,  326,  326,  326,
 /*  1030 */   326,  326,  326,  326,  326,  326,  326,  326,  326,   51,
 /*  1040 */    50,   52,   44,   23,   28,  367,  374,   33,   32,  375,
 /*  1050 */   383,   21,   31,  326,  326,  326,  326,  326,  326,  326,
 /*  1060 */   326,  326,  326,  326,  326,  384,  385,  386,  382,  381,
 /*  1070 */   377,  376,  378,  379,  282,  380,  362,  218,  218,   51,
 /*  1080 */    50,   52,   44,   23,   28,  367,  374,   33,   32,  375,
 /*  1090 */   383,   21,   31,  303,  304,  326,  326,  326,  326,  326,
 /*  1100 */   326,  326,  326,  326,  326,  384,  385,  386,  382,  381,
 /*  1110 */   377,  376,  378,  379,  282,  380,  362,  218,  326,  218,
 /*  1120 */   326,  326,   43,  326,  134,  208,  326,  326,    6,  107,
 /*  1130 */   326,  326,  253,  348,  154,  452,  354,  230,  245,  295,
 /*  1140 */   241,  246,   18,   30,   42,   42,   48,   42,    6,  107,
 /*  1150 */   326,  326,  326,    7,  154,  326,  326,  326,  245,  295,
 /*  1160 */   241,   47,   46,  298,  233,  363,  326,  344,  101,    1,
 /*  1170 */   269,  155,  326,  326,  326,  129,  136,  326,   43,  326,
 /*  1180 */   134,  220,  326,   96,    6,  107,  358,  236,  368,  365,
 /*  1190 */   154,  343,  326,  326,  245,  295,  241,  246,   42,   30,
 /*  1200 */   326,  254,   48,  360,   40,  352,  326,  344,  326,  326,
 /*  1210 */   326,  151,  326,   42,  349,  129,  326,   47,   46,  298,
 /*  1220 */   233,  363,  326,  274,  101,    1,   42,  236,  368,  365,
 /*  1230 */   326,  343,  336,  357,   43,   42,  144,  220,  326,   96,
 /*  1240 */     6,  107,  289,  326,   42,   42,  154,  258,  326,  294,
 /*  1250 */   245,  295,  241,  246,   42,    3,  326,  338,   48,   42,
 /*  1260 */   259,   42,  326,  344,  326,  326,  326,  149,  326,   42,
 /*  1270 */   279,  129,   42,   47,   46,  298,  233,  363,  326,  293,
 /*  1280 */   101,    1,   42,  236,  368,  365,  326,  343,  309,  347,
 /*  1290 */    43,   42,  126,  220,  326,   96,    6,  107,  290,  326,
 /*  1300 */    42,   42,  154,  346,  326,  257,  245,  295,  241,  246,
 /*  1310 */    42,   30,  326,  326,   48,   42,  326,   42,  326,  326,
 /*  1320 */   326,  326,  326,  326,  326,  326,  326,  326,  326,   47,
 /*  1330 */    46,  298,  233,  363,  326,  326,  101,    1,  326,  326,
 /*  1340 */   326,  326,  326,  326,  326,  326,   43,  326,  130,  220,
 /*  1350 */   326,   96,    6,  107,  326,  326,  326,  326,  154,  326,
 /*  1360 */   326,  326,  245,  295,  241,  246,  326,   25,  326,  326,
 /*  1370 */    48,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  1380 */   326,  326,  326,  326,  326,   47,   46,  298,  233,  363,
 /*  1390 */   326,  326,  101,    1,  326,  326,  326,  326,  326,  326,
 /*  1400 */   326,  326,   43,  326,  134,  210,  326,   96,    6,  107,
 /*  1410 */   326,  326,  326,  326,  154,  326,  326,  326,  245,  295,
 /*  1420 */   241,  246,  326,   30,  326,  326,   48,  326,  326,  326,
 /*  1430 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  1440 */   326,   47,   46,  298,  233,  363,  326,  326,  101,    1,
 /*  1450 */   326,  326,  326,  326,  326,  326,  326,  326,   43,  326,
 /*  1460 */   124,   92,  326,   96,    6,  107,  326,  326,  326,  326,
 /*  1470 */   154,  326,  326,  326,  245,  295,  241,  246,  326,   30,
 /*  1480 */   326,  326,   48,  326,  326,  326,  326,  326,  326,  326,
 /*  1490 */   326,  326,  326,  326,  326,  326,  326,   47,   46,  298,
 /*  1500 */   233,  363,  326,  326,  101,    1,  326,  326,  326,  326,
 /*  1510 */   326,  326,  326,  326,   43,  326,  134,  206,  326,   96,
 /*  1520 */     6,  107,  326,  326,  326,  326,  154,  326,  326,  326,
 /*  1530 */   245,  295,  241,  222,  326,   30,  326,  326,   48,  326,
 /*  1540 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  1550 */   326,  326,  326,   47,   46,  298,  233,  363,  326,  326,
 /*  1560 */   101,    1,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  1570 */    43,  326,  134,  205,  326,   96,    6,  107,  326,  326,
 /*  1580 */   326,  326,  154,  326,  326,  326,  245,  295,  241,  246,
 /*  1590 */   326,   30,  326,  326,   48,  326,  326,  326,  326,  326,
 /*  1600 */   326,  326,  326,  326,  326,  326,  326,  326,  326,   47,
 /*  1610 */    46,  298,  233,  363,  326,  326,  101,    1,  326,  326,
 /*  1620 */   326,  326,  326,  326,  326,  326,   43,  326,  134,  209,
 /*  1630 */   326,   96,    6,  107,  326,  326,  326,  326,  154,  326,
 /*  1640 */   326,  326,  245,  295,  241,  246,  326,   30,  326,  326,
 /*  1650 */    48,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  1660 */   326,  326,  326,  326,  326,   47,   46,  298,  233,  363,
 /*  1670 */   326,  326,  101,    1,  326,  326,  326,  326,  326,  326,
 /*  1680 */   326,  326,   43,  326,  130,  220,  326,   96,    6,  107,
 /*  1690 */   326,  326,  326,  326,  154,  326,  326,  326,  245,  295,
 /*  1700 */   241,  246,  326,   25,  326,  326,   48,  326,  326,  326,
 /*  1710 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  190,
 /*  1720 */   165,   47,   46,  298,  233,  363,  326,  326,  101,  292,
 /*  1730 */   326,  326,   24,   22,  326,  326,  326,  326,   43,  326,
 /*  1740 */   130,  221,  326,   96,    6,  107,  200,  326,  326,  326,
 /*  1750 */   154,  326,  326,  326,  245,  295,  241,  246,  326,   25,
 /*  1760 */   326,  326,   48,  326,  326,  326,  326,  326,  326,  326,
 /*  1770 */   326,  326,  326,  326,  326,  326,  326,   47,   46,  298,
 /*  1780 */   233,  363,  326,  326,  101,  326,  326,  326,  326,  326,
 /*  1790 */   326,  326,  326,  326,  326,  501,  190,  180,  326,   96,
 /*  1800 */   326,  326,  501,  326,  501,  501,  292,  501,  501,   24,
 /*  1810 */    22,  326,  326,  344,  501,    7,  501,  132,  326,  326,
 /*  1820 */    78,  129,  326,  200,  326,  326,  326,  326,  326,  301,
 /*  1830 */   361,  501,  326,  236,  368,  365,  326,  343,  136,  326,
 /*  1840 */   326,  344,  501,  326,  217,   93,  326,  326,   59,  117,
 /*  1850 */   326,  326,  326,  326,  326,  326,  501,  301,  361,  326,
 /*  1860 */   326,  236,  368,  365,  344,  343,  326,  326,  132,  326,
 /*  1870 */   326,   77,  129,  326,  326,  326,  326,  326,  326,  326,
 /*  1880 */   301,  361,  326,  326,  236,  368,  365,  344,  343,  326,
 /*  1890 */   326,  132,  326,  326,   84,  129,  326,  326,  344,  326,
 /*  1900 */   326,  326,  115,  301,  361,   72,  129,  236,  368,  365,
 /*  1910 */   326,  343,  326,  326,  301,  361,  326,  326,  236,  368,
 /*  1920 */   365,  326,  343,  344,  326,  326,  326,  132,  326,  326,
 /*  1930 */    64,  129,  326,  326,  344,  326,  326,  326,  132,  301,
 /*  1940 */   361,   66,  129,  236,  368,  365,  326,  343,  326,  326,
 /*  1950 */   301,  361,  326,  344,  236,  368,  365,  132,  343,  326,
 /*  1960 */    68,  129,  326,  326,  326,  326,  326,  326,  326,  301,
 /*  1970 */   361,  326,  344,  236,  368,  365,  132,  343,  326,   76,
 /*  1980 */   129,  326,  326,  344,  326,  326,  326,  132,  301,  361,
 /*  1990 */    80,  129,  236,  368,  365,  326,  343,  326,  326,  301,
 /*  2000 */   361,  326,  326,  236,  368,  365,  326,  343,  344,  326,
 /*  2010 */   326,  326,  132,  326,  326,   60,  129,  326,  326,  344,
 /*  2020 */   326,  326,  326,  132,  301,  361,   73,  129,  236,  368,
 /*  2030 */   365,  326,  343,  326,  326,  301,  361,  326,  344,  236,
 /*  2040 */   368,  365,  132,  343,  326,   74,  129,  326,  326,  326,
 /*  2050 */   326,  326,  326,  326,  301,  361,  326,  344,  236,  368,
 /*  2060 */   365,  132,  343,  326,   90,  129,  326,  326,  344,  326,
 /*  2070 */   326,  326,  132,  301,  361,   65,  129,  236,  368,  365,
 /*  2080 */   326,  343,  326,  326,  301,  361,  326,  326,  236,  368,
 /*  2090 */   365,  326,  343,  344,  326,  326,  326,  132,  326,  326,
 /*  2100 */    83,  129,  326,  326,  344,  326,  326,  326,   93,  301,
 /*  2110 */   361,   53,  117,  236,  368,  365,  326,  343,  326,  326,
 /*  2120 */   301,  361,  326,  344,  215,  368,  365,  132,  343,  326,
 /*  2130 */    87,  129,  326,  326,  326,  326,  326,  326,  326,  301,
 /*  2140 */   361,  326,  344,  236,  368,  365,  132,  343,  326,   58,
 /*  2150 */   129,  326,  326,  344,  326,  326,  326,  122,  301,  361,
 /*  2160 */    55,  129,  236,  368,  365,  326,  343,  326,  326,  301,
 /*  2170 */   361,  326,  326,  236,  368,  365,  326,  343,  344,  326,
 /*  2180 */   326,  326,  132,  326,  326,   70,  129,  326,  326,  344,
 /*  2190 */   326,  326,  326,  132,  301,  361,   91,  129,  236,  368,
 /*  2200 */   365,  326,  343,  326,  326,  301,  361,  326,  344,  236,
 /*  2210 */   368,  365,  111,  343,  326,   63,  129,  326,  326,  326,
 /*  2220 */   326,  326,  326,  326,  301,  361,  326,  344,  236,  368,
 /*  2230 */   365,  132,  343,  326,   86,  129,  326,  326,  344,  326,
 /*  2240 */   326,  326,  132,  301,  361,   79,  129,  236,  368,  365,
 /*  2250 */   326,  343,  326,  326,  301,  361,  326,  326,  236,  368,
 /*  2260 */   365,  326,  343,  344,  326,  326,  326,  132,  326,  326,
 /*  2270 */    75,  129,  326,  326,  344,  326,  326,  326,  132,  301,
 /*  2280 */   361,   88,  129,  236,  368,  365,  326,  343,  326,  326,
 /*  2290 */   301,  361,  326,  344,  236,  368,  365,  132,  343,  326,
 /*  2300 */    62,  129,  326,  326,  326,  326,  326,  326,  326,  301,
 /*  2310 */   361,  326,  344,  236,  368,  365,  132,  343,  326,   61,
 /*  2320 */   129,  326,  326,  344,  326,  326,  326,  132,  301,  361,
 /*  2330 */    69,  129,  236,  368,  365,  326,  343,  326,  326,  301,
 /*  2340 */   361,  326,  326,  236,  368,  365,  326,  343,  344,  326,
 /*  2350 */   326,  326,  132,  326,  326,   57,  129,  326,  326,  344,
 /*  2360 */   326,  326,  326,  132,  301,  361,   89,  129,  236,  368,
 /*  2370 */   365,  326,  343,  326,  326,  301,  361,  326,  344,  236,
 /*  2380 */   368,  365,  132,  343,  326,   81,  129,  326,  326,  326,
 /*  2390 */   326,  326,  326,  326,  301,  361,  326,  344,  236,  368,
 /*  2400 */   365,  113,  343,  326,   85,  129,  326,  326,  344,  326,
 /*  2410 */   326,  326,  132,  301,  361,   71,  129,  236,  368,  365,
 /*  2420 */   326,  343,  326,  326,  301,  361,  326,  326,  236,  368,
 /*  2430 */   365,  326,  343,  344,  326,  326,  326,  132,  326,  326,
 /*  2440 */    67,  129,  326,  326,  344,  326,  326,  326,  132,  301,
 /*  2450 */   361,   56,  129,  214,  368,  365,  326,  343,  326,  326,
 /*  2460 */   301,  361,  326,  344,  236,  368,  365,  147,  343,  326,
 /*  2470 */   326,  129,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2480 */   364,  326,  344,  236,  368,  365,  157,  343,  326,  326,
 /*  2490 */   129,  326,  326,  326,  326,  100,  177,  326,  326,  280,
 /*  2500 */   326,  326,  236,  368,  365,  292,  343,  326,   24,   22,
 /*  2510 */   326,  190,  167,  326,  326,  326,  326,  326,  190,  182,
 /*  2520 */   326,  292,  200,  326,   24,   22,  326,  326,  292,  326,
 /*  2530 */   326,   24,   22,  326,  190,  169,  326,  326,  200,  326,
 /*  2540 */   326,  326,  326,  326,  292,  200,  326,   24,   22,  326,
 /*  2550 */   326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
 /*  2560 */   326,  200,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,   83,   84,   85,    3,    4,    5,    6,    7,    8,
 /*    10 */     9,   10,   11,   12,   13,   98,   90,   16,   81,   82,
 /*    20 */    83,   84,   85,   22,   23,   99,   27,   16,   29,   28,
 /*    30 */    19,   20,  109,   32,   33,   34,   25,  111,   39,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*    50 */    51,   52,    4,    5,    6,    7,    8,   16,   36,   84,
 /*    60 */    38,   13,   14,   15,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,   75,   76,    1,   84,   37,   89,
 /*    80 */    90,   88,   37,   16,   91,   92,   19,   20,   17,   99,
 /*    90 */    17,   20,   17,  100,  101,  120,  121,  104,  105,  106,
 /*   100 */    29,  108,   29,   58,   29,   60,  116,   31,   37,   64,
 /*   110 */    37,  118,  119,   37,   39,   40,   41,   42,   43,   44,
 /*   120 */    45,   46,   47,   48,   49,   50,   51,   52,   61,   89,
 /*   130 */    90,   60,   36,   60,   38,   16,   60,   18,   19,   99,
 /*   140 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   150 */    75,   76,    1,   84,   35,    1,  116,   88,   21,   89,
 /*   160 */    91,   92,   93,   16,   16,   97,   19,   19,   17,  100,
 /*   170 */   101,   17,   19,  104,  105,  106,   29,  108,   31,  111,
 /*   180 */    29,   89,    1,   29,   30,   16,  116,  117,   19,   20,
 /*   190 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   200 */    49,   50,   51,   52,   25,   89,   90,   53,  116,   61,
 /*   210 */    16,    1,   31,   19,   61,   99,   65,   66,   67,   68,
 /*   220 */    69,   70,   71,   72,   73,   74,   75,   76,    1,   84,
 /*   230 */    58,    1,  116,   88,   53,   63,   91,   92,   93,   16,
 /*   240 */    20,   21,   19,   86,   17,  100,  101,   17,   92,  104,
 /*   250 */   105,  106,   29,  108,   31,   61,   29,   78,   98,   29,
 /*   260 */   104,  112,  113,   53,  108,  113,   39,   40,   41,   42,
 /*   270 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
 /*   280 */    60,   90,   90,   53,  110,  109,  112,  113,   20,   21,
 /*   290 */    99,   99,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   300 */    73,   74,   75,   76,    1,   84,   98,    1,  116,   88,
 /*   310 */    84,   62,   91,   92,   88,   90,   64,    1,   92,   21,
 /*   320 */    17,  100,  101,   17,   99,  104,  105,  106,   60,  108,
 /*   330 */   104,  105,  106,   17,  108,   29,  111,   21,   18,   19,
 /*   340 */   119,   14,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   350 */    47,   48,   49,   50,   51,   52,   58,  112,  113,   53,
 /*   360 */    16,   63,   18,   19,   92,   93,   94,   19,   65,   66,
 /*   370 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   380 */     1,   84,   62,    1,   90,   88,   84,   19,   91,   92,
 /*   390 */    88,   90,   58,   99,   92,   90,   17,  100,  101,   17,
 /*   400 */    99,  104,  105,  106,   99,  108,  104,  105,  106,   36,
 /*   410 */   108,   29,  115,   36,   19,   38,  111,  116,   39,   40,
 /*   420 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   430 */    51,   52,    1,   90,   37,   53,   89,   64,    2,  109,
 /*   440 */    16,  111,   99,   19,   65,   66,   67,   68,   69,   70,
 /*   450 */    71,   72,   73,   74,   75,   76,   20,   60,   16,  116,
 /*   460 */    90,   19,  109,  116,  111,   18,   18,   19,   19,   99,
 /*   470 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   480 */    49,   50,   51,   52,   37,    1,  116,   17,   16,   16,
 /*   490 */    16,   19,   19,   19,   89,   25,   65,   66,   67,   68,
 /*   500 */    69,   70,   71,   72,   73,   74,   75,   76,   24,   78,
 /*   510 */    24,  107,   92,   93,    1,   92,   93,   85,  114,   87,
 /*   520 */    19,  116,   36,   39,   40,   41,   42,   43,   44,   45,
 /*   530 */    46,   47,   48,   49,   50,   51,   52,    1,   19,   18,
 /*   540 */    20,   35,   29,   62,   19,    2,   96,   96,   96,   65,
 /*   550 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   560 */    76,  111,  111,  111,  107,   54,   30,   18,   26,   18,
 /*   570 */     2,  114,   18,   18,   96,   39,   40,   41,   42,   43,
 /*   580 */    44,   45,   46,   47,   48,   49,   50,   51,   52,  111,
 /*   590 */    90,   19,   19,   35,   38,   25,   37,   19,   37,   99,
 /*   600 */    96,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   610 */    74,   75,   76,    1,   84,  111,    1,   99,   88,   84,
 /*   620 */   117,   91,   92,   88,  110,  116,  109,   92,   90,   17,
 /*   630 */   100,  101,   17,   20,  104,  105,  106,   99,  108,  104,
 /*   640 */   105,  106,    1,  108,  111,  115,   29,   29,  114,  111,
 /*   650 */    29,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   660 */    48,   49,   50,   51,   52,    1,   95,    2,   53,   95,
 /*   670 */   122,   58,  109,  122,  122,   96,   96,   65,   66,   67,
 /*   680 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   17,
 /*   690 */   111,  111,  122,  122,  122,  122,  122,  122,  122,  122,
 /*   700 */   122,   29,   38,   39,   40,   41,   42,   43,   44,   45,
 /*   710 */    46,   47,   48,   49,   50,   51,   52,    1,  122,  122,
 /*   720 */   122,  122,  122,  122,  122,  122,   96,  122,    1,   65,
 /*   730 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   740 */    76,  111,   84,  122,   17,  122,  122,  122,  122,  122,
 /*   750 */   122,  122,  122,  122,   38,   39,   40,   41,   42,   43,
 /*   760 */    44,   45,   46,   47,   48,   49,   50,   51,   52,    1,
 /*   770 */   122,  122,  122,  122,  122,  122,  122,  122,   96,  121,
 /*   780 */    96,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   790 */    74,   75,   76,  111,  122,  111,  122,   29,  122,  122,
 /*   800 */   122,  122,  122,  122,  122,  122,   21,   39,   40,   41,
 /*   810 */    42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /*   820 */    52,    1,  122,  122,  122,  122,  122,  122,  122,  122,
 /*   830 */   122,  122,  122,   65,   66,   67,   68,   69,   70,   71,
 /*   840 */    72,   73,   74,   75,   76,   60,  122,  122,  122,  122,
 /*   850 */   122,  122,  122,  122,  122,  122,  122,  122,  122,   39,
 /*   860 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*   870 */    50,   51,   52,  122,  122,  122,  122,  122,  122,  122,
 /*   880 */   122,  122,  122,  122,   64,   65,   66,   67,   68,   69,
 /*   890 */    70,   71,   72,   73,   74,   75,   76,    1,  122,  122,
 /*   900 */   122,  122,   89,   84,  122,  122,   16,   88,   10,   19,
 /*   910 */    17,   92,    1,   17,   16,  102,  103,    1,    2,   29,
 /*   920 */    22,   23,   29,  104,  105,  106,   28,  108,   17,  116,
 /*   930 */    32,   33,   34,   17,  122,   39,   40,   41,   42,   43,
 /*   940 */    44,   45,   46,   47,   48,   49,   50,   51,   52,    1,
 /*   950 */     2,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*   960 */   122,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   970 */    74,   75,   76,  122,  122,   77,   78,   79,  122,  122,
 /*   980 */   122,  122,  122,  122,  122,  122,  122,   39,   40,   41,
 /*   990 */    42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /*  1000 */    52,    1,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1010 */   122,  122,  122,   65,   66,   67,   68,   69,   70,   71,
 /*  1020 */    72,   73,   74,   75,   76,  122,  122,  122,  122,  122,
 /*  1030 */   122,  122,  122,  122,  122,  122,  122,  122,  122,   39,
 /*  1040 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*  1050 */    50,   51,   52,  122,  122,  122,  122,  122,  122,  122,
 /*  1060 */   122,  122,  122,  122,  122,   65,   66,   67,   68,   69,
 /*  1070 */    70,   71,   72,   73,   74,   75,   76,    1,    1,   39,
 /*  1080 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*  1090 */    50,   51,   52,   17,   17,  122,  122,  122,  122,  122,
 /*  1100 */   122,  122,  122,  122,  122,   65,   66,   67,   68,   69,
 /*  1110 */    70,   71,   72,   73,   74,   75,   76,    1,  122,    1,
 /*  1120 */   122,  122,   16,  122,   18,   19,  122,  122,   22,   23,
 /*  1130 */   122,  122,   17,   17,   28,   17,   10,   21,   32,   33,
 /*  1140 */    34,   35,   16,   37,   29,   29,   40,   29,   22,   23,
 /*  1150 */   122,  122,  122,   37,   28,  122,  122,  122,   32,   33,
 /*  1160 */    34,   55,   56,   57,   58,   59,  122,   84,   62,   63,
 /*  1170 */    64,   88,  122,  122,  122,   92,   60,  122,   16,  122,
 /*  1180 */    18,   19,  122,   77,   22,   23,   17,  104,  105,  106,
 /*  1190 */    28,  108,  122,  122,   32,   33,   34,   35,   29,   37,
 /*  1200 */   122,   17,   40,   77,   78,   79,  122,   84,  122,  122,
 /*  1210 */   122,   88,  122,   29,   17,   92,  122,   55,   56,   57,
 /*  1220 */    58,   59,  122,   17,   62,   63,   29,  104,  105,  106,
 /*  1230 */   122,  108,   17,   17,   16,   29,   18,   19,  122,   77,
 /*  1240 */    22,   23,   17,  122,   29,   29,   28,   17,  122,   17,
 /*  1250 */    32,   33,   34,   35,   29,   37,  122,   17,   40,   29,
 /*  1260 */    17,   29,  122,   84,  122,  122,  122,   88,  122,   29,
 /*  1270 */    17,   92,   29,   55,   56,   57,   58,   59,  122,   17,
 /*  1280 */    62,   63,   29,  104,  105,  106,  122,  108,   17,   17,
 /*  1290 */    16,   29,   18,   19,  122,   77,   22,   23,   17,  122,
 /*  1300 */    29,   29,   28,   17,  122,   17,   32,   33,   34,   35,
 /*  1310 */    29,   37,  122,  122,   40,   29,  122,   29,  122,  122,
 /*  1320 */   122,  122,  122,  122,  122,  122,  122,  122,  122,   55,
 /*  1330 */    56,   57,   58,   59,  122,  122,   62,   63,  122,  122,
 /*  1340 */   122,  122,  122,  122,  122,  122,   16,  122,   18,   19,
 /*  1350 */   122,   77,   22,   23,  122,  122,  122,  122,   28,  122,
 /*  1360 */   122,  122,   32,   33,   34,   35,  122,   37,  122,  122,
 /*  1370 */    40,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1380 */   122,  122,  122,  122,  122,   55,   56,   57,   58,   59,
 /*  1390 */   122,  122,   62,   63,  122,  122,  122,  122,  122,  122,
 /*  1400 */   122,  122,   16,  122,   18,   19,  122,   77,   22,   23,
 /*  1410 */   122,  122,  122,  122,   28,  122,  122,  122,   32,   33,
 /*  1420 */    34,   35,  122,   37,  122,  122,   40,  122,  122,  122,
 /*  1430 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1440 */   122,   55,   56,   57,   58,   59,  122,  122,   62,   63,
 /*  1450 */   122,  122,  122,  122,  122,  122,  122,  122,   16,  122,
 /*  1460 */    18,   19,  122,   77,   22,   23,  122,  122,  122,  122,
 /*  1470 */    28,  122,  122,  122,   32,   33,   34,   35,  122,   37,
 /*  1480 */   122,  122,   40,  122,  122,  122,  122,  122,  122,  122,
 /*  1490 */   122,  122,  122,  122,  122,  122,  122,   55,   56,   57,
 /*  1500 */    58,   59,  122,  122,   62,   63,  122,  122,  122,  122,
 /*  1510 */   122,  122,  122,  122,   16,  122,   18,   19,  122,   77,
 /*  1520 */    22,   23,  122,  122,  122,  122,   28,  122,  122,  122,
 /*  1530 */    32,   33,   34,   35,  122,   37,  122,  122,   40,  122,
 /*  1540 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1550 */   122,  122,  122,   55,   56,   57,   58,   59,  122,  122,
 /*  1560 */    62,   63,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1570 */    16,  122,   18,   19,  122,   77,   22,   23,  122,  122,
 /*  1580 */   122,  122,   28,  122,  122,  122,   32,   33,   34,   35,
 /*  1590 */   122,   37,  122,  122,   40,  122,  122,  122,  122,  122,
 /*  1600 */   122,  122,  122,  122,  122,  122,  122,  122,  122,   55,
 /*  1610 */    56,   57,   58,   59,  122,  122,   62,   63,  122,  122,
 /*  1620 */   122,  122,  122,  122,  122,  122,   16,  122,   18,   19,
 /*  1630 */   122,   77,   22,   23,  122,  122,  122,  122,   28,  122,
 /*  1640 */   122,  122,   32,   33,   34,   35,  122,   37,  122,  122,
 /*  1650 */    40,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1660 */   122,  122,  122,  122,  122,   55,   56,   57,   58,   59,
 /*  1670 */   122,  122,   62,   63,  122,  122,  122,  122,  122,  122,
 /*  1680 */   122,  122,   16,  122,   18,   19,  122,   77,   22,   23,
 /*  1690 */   122,  122,  122,  122,   28,  122,  122,  122,   32,   33,
 /*  1700 */    34,   35,  122,   37,  122,  122,   40,  122,  122,  122,
 /*  1710 */   122,  122,  122,  122,  122,  122,  122,  122,  122,   89,
 /*  1720 */    90,   55,   56,   57,   58,   59,  122,  122,   62,   99,
 /*  1730 */   122,  122,  102,  103,  122,  122,  122,  122,   16,  122,
 /*  1740 */    18,   19,  122,   77,   22,   23,  116,  122,  122,  122,
 /*  1750 */    28,  122,  122,  122,   32,   33,   34,   35,  122,   37,
 /*  1760 */   122,  122,   40,  122,  122,  122,  122,  122,  122,  122,
 /*  1770 */   122,  122,  122,  122,  122,  122,  122,   55,   56,   57,
 /*  1780 */    58,   59,  122,  122,   62,  122,  122,  122,  122,  122,
 /*  1790 */   122,  122,  122,  122,  122,   17,   89,   90,  122,   77,
 /*  1800 */   122,  122,   24,  122,   26,   27,   99,   29,   30,  102,
 /*  1810 */   103,  122,  122,   84,   36,   37,   38,   88,  122,  122,
 /*  1820 */    91,   92,  122,  116,  122,  122,  122,  122,  122,  100,
 /*  1830 */   101,   53,  122,  104,  105,  106,  122,  108,   60,  122,
 /*  1840 */   122,   84,   64,  122,  115,   88,  122,  122,   91,   92,
 /*  1850 */   122,  122,  122,  122,  122,  122,   78,  100,  101,  122,
 /*  1860 */   122,  104,  105,  106,   84,  108,  122,  122,   88,  122,
 /*  1870 */   122,   91,   92,  122,  122,  122,  122,  122,  122,  122,
 /*  1880 */   100,  101,  122,  122,  104,  105,  106,   84,  108,  122,
 /*  1890 */   122,   88,  122,  122,   91,   92,  122,  122,   84,  122,
 /*  1900 */   122,  122,   88,  100,  101,   91,   92,  104,  105,  106,
 /*  1910 */   122,  108,  122,  122,  100,  101,  122,  122,  104,  105,
 /*  1920 */   106,  122,  108,   84,  122,  122,  122,   88,  122,  122,
 /*  1930 */    91,   92,  122,  122,   84,  122,  122,  122,   88,  100,
 /*  1940 */   101,   91,   92,  104,  105,  106,  122,  108,  122,  122,
 /*  1950 */   100,  101,  122,   84,  104,  105,  106,   88,  108,  122,
 /*  1960 */    91,   92,  122,  122,  122,  122,  122,  122,  122,  100,
 /*  1970 */   101,  122,   84,  104,  105,  106,   88,  108,  122,   91,
 /*  1980 */    92,  122,  122,   84,  122,  122,  122,   88,  100,  101,
 /*  1990 */    91,   92,  104,  105,  106,  122,  108,  122,  122,  100,
 /*  2000 */   101,  122,  122,  104,  105,  106,  122,  108,   84,  122,
 /*  2010 */   122,  122,   88,  122,  122,   91,   92,  122,  122,   84,
 /*  2020 */   122,  122,  122,   88,  100,  101,   91,   92,  104,  105,
 /*  2030 */   106,  122,  108,  122,  122,  100,  101,  122,   84,  104,
 /*  2040 */   105,  106,   88,  108,  122,   91,   92,  122,  122,  122,
 /*  2050 */   122,  122,  122,  122,  100,  101,  122,   84,  104,  105,
 /*  2060 */   106,   88,  108,  122,   91,   92,  122,  122,   84,  122,
 /*  2070 */   122,  122,   88,  100,  101,   91,   92,  104,  105,  106,
 /*  2080 */   122,  108,  122,  122,  100,  101,  122,  122,  104,  105,
 /*  2090 */   106,  122,  108,   84,  122,  122,  122,   88,  122,  122,
 /*  2100 */    91,   92,  122,  122,   84,  122,  122,  122,   88,  100,
 /*  2110 */   101,   91,   92,  104,  105,  106,  122,  108,  122,  122,
 /*  2120 */   100,  101,  122,   84,  104,  105,  106,   88,  108,  122,
 /*  2130 */    91,   92,  122,  122,  122,  122,  122,  122,  122,  100,
 /*  2140 */   101,  122,   84,  104,  105,  106,   88,  108,  122,   91,
 /*  2150 */    92,  122,  122,   84,  122,  122,  122,   88,  100,  101,
 /*  2160 */    91,   92,  104,  105,  106,  122,  108,  122,  122,  100,
 /*  2170 */   101,  122,  122,  104,  105,  106,  122,  108,   84,  122,
 /*  2180 */   122,  122,   88,  122,  122,   91,   92,  122,  122,   84,
 /*  2190 */   122,  122,  122,   88,  100,  101,   91,   92,  104,  105,
 /*  2200 */   106,  122,  108,  122,  122,  100,  101,  122,   84,  104,
 /*  2210 */   105,  106,   88,  108,  122,   91,   92,  122,  122,  122,
 /*  2220 */   122,  122,  122,  122,  100,  101,  122,   84,  104,  105,
 /*  2230 */   106,   88,  108,  122,   91,   92,  122,  122,   84,  122,
 /*  2240 */   122,  122,   88,  100,  101,   91,   92,  104,  105,  106,
 /*  2250 */   122,  108,  122,  122,  100,  101,  122,  122,  104,  105,
 /*  2260 */   106,  122,  108,   84,  122,  122,  122,   88,  122,  122,
 /*  2270 */    91,   92,  122,  122,   84,  122,  122,  122,   88,  100,
 /*  2280 */   101,   91,   92,  104,  105,  106,  122,  108,  122,  122,
 /*  2290 */   100,  101,  122,   84,  104,  105,  106,   88,  108,  122,
 /*  2300 */    91,   92,  122,  122,  122,  122,  122,  122,  122,  100,
 /*  2310 */   101,  122,   84,  104,  105,  106,   88,  108,  122,   91,
 /*  2320 */    92,  122,  122,   84,  122,  122,  122,   88,  100,  101,
 /*  2330 */    91,   92,  104,  105,  106,  122,  108,  122,  122,  100,
 /*  2340 */   101,  122,  122,  104,  105,  106,  122,  108,   84,  122,
 /*  2350 */   122,  122,   88,  122,  122,   91,   92,  122,  122,   84,
 /*  2360 */   122,  122,  122,   88,  100,  101,   91,   92,  104,  105,
 /*  2370 */   106,  122,  108,  122,  122,  100,  101,  122,   84,  104,
 /*  2380 */   105,  106,   88,  108,  122,   91,   92,  122,  122,  122,
 /*  2390 */   122,  122,  122,  122,  100,  101,  122,   84,  104,  105,
 /*  2400 */   106,   88,  108,  122,   91,   92,  122,  122,   84,  122,
 /*  2410 */   122,  122,   88,  100,  101,   91,   92,  104,  105,  106,
 /*  2420 */   122,  108,  122,  122,  100,  101,  122,  122,  104,  105,
 /*  2430 */   106,  122,  108,   84,  122,  122,  122,   88,  122,  122,
 /*  2440 */    91,   92,  122,  122,   84,  122,  122,  122,   88,  100,
 /*  2450 */   101,   91,   92,  104,  105,  106,  122,  108,  122,  122,
 /*  2460 */   100,  101,  122,   84,  104,  105,  106,   88,  108,  122,
 /*  2470 */   122,   92,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  2480 */   101,  122,   84,  104,  105,  106,   88,  108,  122,  122,
 /*  2490 */    92,  122,  122,  122,  122,   89,   90,  122,  122,  101,
 /*  2500 */   122,  122,  104,  105,  106,   99,  108,  122,  102,  103,
 /*  2510 */   122,   89,   90,  122,  122,  122,  122,  122,   89,   90,
 /*  2520 */   122,   99,  116,  122,  102,  103,  122,  122,   99,  122,
 /*  2530 */   122,  102,  103,  122,   89,   90,  122,  122,  116,  122,
 /*  2540 */   122,  122,  122,  122,   99,  116,  122,  102,  103,  122,
 /*  2550 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  2560 */   122,  116,
);
    const YY_SHIFT_USE_DFLT = -2;
    const YY_SHIFT_MAX = 252;
    static public $yy_shift_ofst = array(
 /*     0 */     1, 1386, 1162, 1218, 1162, 1386, 1218, 1162, 1106, 1162,
 /*    10 */  1162, 1162, 1162, 1162, 1162, 1162, 1162, 1162, 1442, 1554,
 /*    20 */  1498, 1162, 1162, 1162, 1162, 1162, 1162, 1610, 1162, 1162,
 /*    30 */  1162, 1162, 1162, 1162, 1274, 1162, 1162, 1162, 1162, 1162,
 /*    40 */  1162, 1162, 1498, 1442, 1330, 1330, 1666, 1666, 1666, 1722,
 /*    50 */  1666, 1666, 1666,  227,   75,  151,   -1,  768,  768,  768,
 /*    60 */   948,  896,  820,  536,  379,  716,  303,  431,  664,  612,
 /*    70 */   484, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
 /*    80 */  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
 /*    90 */  1040, 1040, 1116,  382,  513,    1, 1126,  147,  223, 1118,
 /*   100 */  1118,  320,  890,  916,  298,  890,  513,  447,  513,  898,
 /*   110 */    48,  154,   11,  306,   67,  230,  194,  220,  169,  268,
 /*   120 */   181,  316,  615,  424,  473,  424,  472,  474,  448,  785,
 /*   130 */   424,  424,  210,  424,  442,  447,  448,  424,  424,  424,
 /*   140 */   727,  424, 1288,  447,  442,  641,  137,  641,  641,  641,
 /*   150 */   641,  641,  137,  617,  618,  641,  641,   -2,  344,  148,
 /*   160 */   893,  172,   41,  172, 1225, 1215, 1216, 1206, 1197, 1115,
 /*   170 */  1169, 1184, 1230,  172, 1271,  672, 1262, 1272, 1286, 1077,
 /*   180 */  1281,  172, 1240, 1232,  911,  172, 1253, 1243, 1076,  621,
 /*   190 */   641,  641,  665,  665,  559,  621,  137,  327,  137,  137,
 /*   200 */    -2,   -2,   -2,   -2,   -2, 1778,   71,  119,   45,   73,
 /*   210 */    76,   96,  486,  436,  179,  470,   22,  377,  153,  373,
 /*   220 */   397,  397,  613,  561,  554,  572,  568,  249,  549,  542,
 /*   230 */   573,  555,  578,  558,  559,  556,  570,  511,  543,  449,
 /*   240 */   501,  395,  252,  348,  368,  519,  334,  525,  481,  506,
 /*   250 */   521,  520,  551,
);
    const YY_REDUCE_USE_DFLT = -84;
    const YY_REDUCE_MAX = 204;
    static public $yy_reduce_ofst = array(
 /*     0 */   -63,   -7, 1729,   69,  297,  221,  145,  530, 2209, 2228,
 /*    10 */  1973, 1850, 2190, 2039, 2058, 1899, 2094, 2069, 2020, 2105,
 /*    20 */  2124, 2179, 2154, 2143, 2009, 1984, 1839, 1814, 1780, 1803,
 /*    30 */  1869, 1888, 1954, 1935, 1924, 2275, 2324, 2294, 2264, 2360,
 /*    40 */  2349, 2239, 2313, 1757, 2379, 2398,  226,  819,  302,  535,
 /*    50 */  1179, 1123, 1083, 2406, 1707, 1630, 2422, 2445, 2429, 2406,
 /*    60 */   813,  813,  813,  813,  813,  813,  813,  813,  813,  813,
 /*    70 */   813,  813,  813,  813,  813,  813,  813,  813,  813,  813,
 /*    80 */   813,  813,  813,  813,  813,  813,  813,  813,  813,  813,
 /*    90 */   813,  813,  -10,   40,  116,  -82,  -25,  225,  -74,  192,
 /*   100 */   343,  156,  305,   70,  174,  538,  370,  272,  301,  658,
 /*   110 */   432,   92,   68,   92,  330,   92,  330,  245,  330,  245,
 /*   120 */    92,  347,   92,  478,  451,  353,  451,  504,  404,  245,
 /*   130 */   451,  450,   92,  452,  451,  420,  457,  682,  684,  580,
 /*   140 */   405,  579,  500,  423,  630,   92,  149,   92,   92,   92,
 /*   150 */    92,   92,  245,  294,  191,   92,   92,   92,  534,  533,
 /*   160 */   518,  514,  517,  514,  518,  518,  518,  518,  518,  518,
 /*   170 */   518,  518,  518,  514,  518,  518,  518,  518,  518,  509,
 /*   180 */   518,  514,  518,  518,  509,  514,  518,  518,  509,  574,
 /*   190 */   509,  509,  503,  503,  563,  571,  152,  157,  152,  152,
 /*   200 */   -83,  208,  176,  160,  -77,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 22, 23, 28, 32, 33, 34, ),
        /* 1 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 2 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 3 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 4 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 5 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 6 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 7 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 8 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 64, 77, ),
        /* 9 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 10 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 11 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 12 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 13 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 14 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 15 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 16 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 17 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 18 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 19 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 20 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 21 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 22 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 23 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 24 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 25 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 26 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 27 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 28 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 29 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 30 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 31 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 32 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 33 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 34 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 35 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 36 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 37 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 38 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 39 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 40 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 41 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 42 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 43 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 44 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 45 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 63, 77, ),
        /* 46 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 77, ),
        /* 47 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 77, ),
        /* 48 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 77, ),
        /* 49 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 77, ),
        /* 50 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 77, ),
        /* 51 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 77, ),
        /* 52 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 35, 37, 40, 55, 56, 57, 58, 59, 62, 77, ),
        /* 53 */ array(1, 17, 29, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 54 */ array(1, 17, 29, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 55 */ array(1, 17, 29, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 56 */ array(1, 27, 29, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 57 */ array(1, 29, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 58 */ array(1, 29, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 59 */ array(1, 29, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 60 */ array(1, 2, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 61 */ array(1, 17, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 62 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 63 */ array(1, 30, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 64 */ array(1, 17, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 65 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 66 */ array(1, 17, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 67 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 78, ),
        /* 68 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 69 */ array(1, 17, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 70 */ array(1, 24, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 71 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 72 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 73 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 74 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 75 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 76 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 77 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 78 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 79 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 80 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 81 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 82 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 83 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 84 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 85 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 86 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 87 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 88 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 89 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 90 */ array(39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 91 */ array(39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, ),
        /* 92 */ array(1, 17, 21, 29, 37, 60, ),
        /* 93 */ array(1, 17, 29, 53, ),
        /* 94 */ array(1, 29, ),
        /* 95 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 22, 23, 28, 32, 33, 34, ),
        /* 96 */ array(10, 16, 22, 23, 28, 32, 33, 34, 77, 78, 79, ),
        /* 97 */ array(16, 19, 29, 31, ),
        /* 98 */ array(16, 19, 29, 31, ),
        /* 99 */ array(1, 17, 29, ),
        /* 100 */ array(1, 17, 29, ),
        /* 101 */ array(18, 19, 62, ),
        /* 102 */ array(16, 19, 29, ),
        /* 103 */ array(1, 2, 17, ),
        /* 104 */ array(21, 58, 63, ),
        /* 105 */ array(16, 19, 29, ),
        /* 106 */ array(1, 29, ),
        /* 107 */ array(18, 37, ),
        /* 108 */ array(1, 29, ),
        /* 109 */ array(10, 16, 22, 23, 28, 32, 33, 34, 77, 78, 79, ),
        /* 110 */ array(4, 5, 6, 7, 8, 13, 14, 15, ),
        /* 111 */ array(1, 17, 29, 30, 53, ),
        /* 112 */ array(16, 19, 20, 25, ),
        /* 113 */ array(1, 17, 29, 53, ),
        /* 114 */ array(16, 19, 20, 61, ),
        /* 115 */ array(1, 17, 29, 53, ),
        /* 116 */ array(16, 19, 61, ),
        /* 117 */ array(20, 21, 60, ),
        /* 118 */ array(16, 19, 20, ),
        /* 119 */ array(20, 21, 60, ),
        /* 120 */ array(1, 31, 53, ),
        /* 121 */ array(1, 17, 21, ),
        /* 122 */ array(1, 17, 53, ),
        /* 123 */ array(16, 19, ),
        /* 124 */ array(16, 19, ),
        /* 125 */ array(16, 19, ),
        /* 126 */ array(16, 19, ),
        /* 127 */ array(16, 19, ),
        /* 128 */ array(18, 19, ),
        /* 129 */ array(21, 60, ),
        /* 130 */ array(16, 19, ),
        /* 131 */ array(16, 19, ),
        /* 132 */ array(1, 53, ),
        /* 133 */ array(16, 19, ),
        /* 134 */ array(16, 19, ),
        /* 135 */ array(18, 37, ),
        /* 136 */ array(18, 19, ),
        /* 137 */ array(16, 19, ),
        /* 138 */ array(16, 19, ),
        /* 139 */ array(16, 19, ),
        /* 140 */ array(1, 17, ),
        /* 141 */ array(16, 19, ),
        /* 142 */ array(17, 29, ),
        /* 143 */ array(18, 37, ),
        /* 144 */ array(16, 19, ),
        /* 145 */ array(1, ),
        /* 146 */ array(21, ),
        /* 147 */ array(1, ),
        /* 148 */ array(1, ),
        /* 149 */ array(1, ),
        /* 150 */ array(1, ),
        /* 151 */ array(1, ),
        /* 152 */ array(21, ),
        /* 153 */ array(29, ),
        /* 154 */ array(29, ),
        /* 155 */ array(1, ),
        /* 156 */ array(1, ),
        /* 157 */ array(),
        /* 158 */ array(16, 18, 19, ),
        /* 159 */ array(16, 19, 61, ),
        /* 160 */ array(17, 29, ),
        /* 161 */ array(58, 63, ),
        /* 162 */ array(16, 37, ),
        /* 163 */ array(58, 63, ),
        /* 164 */ array(17, 29, ),
        /* 165 */ array(17, 29, ),
        /* 166 */ array(17, 29, ),
        /* 167 */ array(17, 29, ),
        /* 168 */ array(17, 29, ),
        /* 169 */ array(17, 29, ),
        /* 170 */ array(17, 29, ),
        /* 171 */ array(17, 29, ),
        /* 172 */ array(17, 29, ),
        /* 173 */ array(58, 63, ),
        /* 174 */ array(17, 29, ),
        /* 175 */ array(17, 29, ),
        /* 176 */ array(17, 29, ),
        /* 177 */ array(17, 29, ),
        /* 178 */ array(17, 29, ),
        /* 179 */ array(1, 17, ),
        /* 180 */ array(17, 29, ),
        /* 181 */ array(58, 63, ),
        /* 182 */ array(17, 29, ),
        /* 183 */ array(17, 29, ),
        /* 184 */ array(1, 17, ),
        /* 185 */ array(58, 63, ),
        /* 186 */ array(17, 29, ),
        /* 187 */ array(17, 29, ),
        /* 188 */ array(1, 17, ),
        /* 189 */ array(29, ),
        /* 190 */ array(1, ),
        /* 191 */ array(1, ),
        /* 192 */ array(2, ),
        /* 193 */ array(2, ),
        /* 194 */ array(37, ),
        /* 195 */ array(29, ),
        /* 196 */ array(21, ),
        /* 197 */ array(14, ),
        /* 198 */ array(21, ),
        /* 199 */ array(21, ),
        /* 200 */ array(),
        /* 201 */ array(),
        /* 202 */ array(),
        /* 203 */ array(),
        /* 204 */ array(),
        /* 205 */ array(17, 24, 26, 27, 29, 30, 36, 37, 38, 53, 60, 64, 78, ),
        /* 206 */ array(17, 20, 29, 37, 60, ),
        /* 207 */ array(16, 18, 19, 35, ),
        /* 208 */ array(37, 58, 60, 64, ),
        /* 209 */ array(17, 29, 37, 60, ),
        /* 210 */ array(31, 37, 60, ),
        /* 211 */ array(36, 38, ),
        /* 212 */ array(24, 36, ),
        /* 213 */ array(2, 20, ),
        /* 214 */ array(25, 78, ),
        /* 215 */ array(17, 25, ),
        /* 216 */ array(36, 38, ),
        /* 217 */ array(36, 38, ),
        /* 218 */ array(19, 61, ),
        /* 219 */ array(36, 64, ),
        /* 220 */ array(37, 60, ),
        /* 221 */ array(37, 60, ),
        /* 222 */ array(20, 58, ),
        /* 223 */ array(37, ),
        /* 224 */ array(18, ),
        /* 225 */ array(19, ),
        /* 226 */ array(2, ),
        /* 227 */ array(62, ),
        /* 228 */ array(18, ),
        /* 229 */ array(26, ),
        /* 230 */ array(19, ),
        /* 231 */ array(18, ),
        /* 232 */ array(19, ),
        /* 233 */ array(35, ),
        /* 234 */ array(37, ),
        /* 235 */ array(38, ),
        /* 236 */ array(25, ),
        /* 237 */ array(54, ),
        /* 238 */ array(2, ),
        /* 239 */ array(19, ),
        /* 240 */ array(19, ),
        /* 241 */ array(19, ),
        /* 242 */ array(64, ),
        /* 243 */ array(19, ),
        /* 244 */ array(19, ),
        /* 245 */ array(19, ),
        /* 246 */ array(58, ),
        /* 247 */ array(19, ),
        /* 248 */ array(62, ),
        /* 249 */ array(35, ),
        /* 250 */ array(18, ),
        /* 251 */ array(20, ),
        /* 252 */ array(18, ),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
        /* 375 */ array(),
        /* 376 */ array(),
        /* 377 */ array(),
        /* 378 */ array(),
        /* 379 */ array(),
        /* 380 */ array(),
        /* 381 */ array(),
        /* 382 */ array(),
        /* 383 */ array(),
        /* 384 */ array(),
        /* 385 */ array(),
        /* 386 */ array(),
        /* 387 */ array(),
);
    static public $yy_default = array(
 /*     0 */   391,  573,  544,  590,  544,  590,  590,  544,  590,  590,
 /*    10 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*    20 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*    30 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*    40 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*    50 */   590,  590,  590,  590,  590,  590,  452,  452,  452,  452,
 /*    60 */   590,  590,  590,  457,  590,  590,  590,  590,  590,  590,
 /*    70 */   590,  542,  454,  481,  482,  485,  486,  478,  543,  476,
 /*    80 */   463,  575,  576,  473,  459,  457,  477,  434,  462,  574,
 /*    90 */   490,  489,  501,  465,  452,  388,  590,  452,  452,  509,
 /*   100 */   472,  590,  452,  590,  556,  452,  452,  590,  452,  590,
 /*   110 */   590,  465,  590,  465,  517,  465,  517,  510,  517,  510,
 /*   120 */   465,  590,  465,  590,  590,  517,  590,  590,  590,  510,
 /*   130 */   590,  590,  465,  590,  590,  590,  590,  590,  590,  590,
 /*   140 */   590,  590,  590,  590,  590,  493,  553,  475,  492,  469,
 /*   150 */   488,  468,  510,  452,  452,  470,  494,  551,  590,  518,
 /*   160 */   590,  534,  517,  537,  590,  590,  590,  590,  590,  590,
 /*   170 */   590,  590,  590,  535,  590,  590,  590,  590,  590,  590,
 /*   180 */   590,  536,  590,  590,  590,  515,  590,  590,  590,  589,
 /*   190 */   472,  509,  545,  546,  517,  589,  531,  407,  557,  554,
 /*   200 */   550,  550,  517,  550,  517,  467,  501,  590,  501,  501,
 /*   210 */   501,  590,  590,  529,  491,  491,  590,  590,  590,  590,
 /*   220 */   501,  487,  497,  555,  590,  590,  529,  590,  590,  460,
 /*   230 */   590,  590,  590,  590,  529,  590,  491,  503,  529,  590,
 /*   240 */   590,  590,  590,  590,  590,  590,  497,  590,  590,  499,
 /*   250 */   590,  590,  590,  437,  417,  389,  571,  431,  432,  441,
 /*   260 */   572,  540,  435,  588,  461,  539,  525,  523,  503,  526,
 /*   270 */   524,  514,  513,  530,  436,  570,  464,  538,  522,  442,
 /*   280 */   552,  541,  567,  529,  528,  443,  444,  549,  440,  439,
 /*   290 */   430,  429,  451,  433,  438,  445,  446,  498,  496,  500,
 /*   300 */   506,  466,  495,  449,  447,  547,  548,  448,  450,  416,
 /*   310 */   398,  397,  399,  400,  401,  396,  395,  390,  392,  393,
 /*   320 */   394,  402,  403,  412,  411,  413,  414,  415,  410,  409,
 /*   330 */   404,  405,  406,  408,  467,  511,  422,  421,  423,  532,
 /*   340 */   424,  420,  585,  512,  508,  533,  418,  419,  425,  426,
 /*   350 */   581,  582,  583,  586,  587,  579,  578,  428,  427,  584,
 /*   360 */   577,  471,  569,  504,  474,  505,  507,  479,  502,  521,
 /*   370 */   516,  519,  527,  520,  480,  483,  564,  563,  565,  566,
 /*   380 */   568,  562,  561,  484,  558,  559,  560,  580,
);
    const YYNOCODE = 123;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 388;
    const YYNRULE = 202;
    const YYERRORSYMBOL = 80;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'VERT',          'COLON',         'COMMENT',
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',
  'FAKEPHPSTARTTAG',  'XMLTAG',        'TEXT',          'STRIPON',
  'STRIPOFF',      'LITERALSTART',  'LITERALEND',    'LITERAL',
  'LDEL',          'RDEL',          'DOLLAR',        'ID',
  'EQUAL',         'PTR',           'LDELIF',        'LDELFOR',
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',
  'LDELFOREACH',   'SPACE',         'AS',            'APTR',
  'LDELSETFILTER',  'SMARTYBLOCKCHILD',  'LDELSLASH',     'INTEGER',
  'COMMA',         'OPENP',         'CLOSEP',        'MATH',
  'UNIMATH',       'ANDSYM',        'ISIN',          'ISDIVBY',
  'ISNOTDIVBY',    'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',
  'ISNOTEVENBY',   'ISODD',         'ISNOTODD',      'ISODDBY',
  'ISNOTODDBY',    'INSTANCEOF',    'QMARK',         'NOT',
  'TYPECAST',      'HEX',           'DOT',           'SINGLEQUOTESTRING',
  'DOUBLECOLON',   'AT',            'HATCH',         'OPENB',
  'CLOSEB',        'EQUALS',        'NOTEQUALS',     'GREATERTHAN',
  'LESSTHAN',      'GREATEREQUAL',  'LESSEQUAL',     'IDENTITY',
  'NONEIDENTITY',  'MOD',           'LAND',          'LOR',
  'LXOR',          'QUOTE',         'BACKTICK',      'DOLLARID',
  'error',         'start',         'template',      'template_element',
  'smartytag',     'literal',       'literal_elements',  'literal_element',
  'value',         'modifierlist',  'attributes',    'expr',
  'varindexed',    'statement',     'statements',    'optspace',
  'varvar',        'foraction',     'modparameters',  'attribute',
  'ternary',       'array',         'ifcond',        'lop',
  'variable',      'function',      'doublequoted_with_quotes',  'static_class_access',
  'object',        'arrayindex',    'indexdef',      'varvarele',
  'objectchain',   'objectelement',  'method',        'params',
  'modifier',      'modparameter',  'arrayelements',  'arrayelement',
  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= TEXT",
 /*  14 */ "template_element ::= STRIPON",
 /*  15 */ "template_element ::= STRIPOFF",
 /*  16 */ "literal ::= LITERALSTART LITERALEND",
 /*  17 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  18 */ "literal_elements ::= literal_elements literal_element",
 /*  19 */ "literal_elements ::=",
 /*  20 */ "literal_element ::= literal",
 /*  21 */ "literal_element ::= LITERAL",
 /*  22 */ "literal_element ::= PHPSTARTTAG",
 /*  23 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  24 */ "literal_element ::= PHPENDTAG",
 /*  25 */ "literal_element ::= ASPSTARTTAG",
 /*  26 */ "literal_element ::= ASPENDTAG",
 /*  27 */ "smartytag ::= LDEL value RDEL",
 /*  28 */ "smartytag ::= LDEL value modifierlist attributes RDEL",
 /*  29 */ "smartytag ::= LDEL value attributes RDEL",
 /*  30 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  31 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  32 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  34 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  35 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  36 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  37 */ "smartytag ::= LDEL ID RDEL",
 /*  38 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  39 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  40 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  41 */ "smartytag ::= LDELIF expr RDEL",
 /*  42 */ "smartytag ::= LDELIF expr attributes RDEL",
 /*  43 */ "smartytag ::= LDELIF statement RDEL",
 /*  44 */ "smartytag ::= LDELIF statement attributes RDEL",
 /*  45 */ "smartytag ::= LDELFOR statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes RDEL",
 /*  46 */ "foraction ::= EQUAL expr",
 /*  47 */ "foraction ::= INCDEC",
 /*  48 */ "smartytag ::= LDELFOR statement TO expr attributes RDEL",
 /*  49 */ "smartytag ::= LDELFOR statement TO expr STEP expr attributes RDEL",
 /*  50 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes RDEL",
 /*  54 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  55 */ "smartytag ::= LDELSETFILTER ID modparameters RDEL",
 /*  56 */ "smartytag ::= LDELSETFILTER ID modparameters modifierlist RDEL",
 /*  57 */ "smartytag ::= SMARTYBLOCKCHILD",
 /*  58 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  59 */ "smartytag ::= LDELSLASH ID modifierlist RDEL",
 /*  60 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  61 */ "smartytag ::= LDELSLASH ID PTR ID modifierlist RDEL",
 /*  62 */ "attributes ::= attributes attribute",
 /*  63 */ "attributes ::= attribute",
 /*  64 */ "attributes ::=",
 /*  65 */ "attribute ::= SPACE ID EQUAL ID",
 /*  66 */ "attribute ::= SPACE ID EQUAL expr",
 /*  67 */ "attribute ::= SPACE ID EQUAL value",
 /*  68 */ "attribute ::= SPACE ID",
 /*  69 */ "attribute ::= SPACE expr",
 /*  70 */ "attribute ::= SPACE value",
 /*  71 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  72 */ "statements ::= statement",
 /*  73 */ "statements ::= statements COMMA statement",
 /*  74 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  75 */ "statement ::= varindexed EQUAL expr",
 /*  76 */ "statement ::= OPENP statement CLOSEP",
 /*  77 */ "expr ::= value",
 /*  78 */ "expr ::= ternary",
 /*  79 */ "expr ::= DOLLAR ID COLON ID",
 /*  80 */ "expr ::= expr MATH value",
 /*  81 */ "expr ::= expr UNIMATH value",
 /*  82 */ "expr ::= expr ANDSYM value",
 /*  83 */ "expr ::= array",
 /*  84 */ "expr ::= expr modifierlist",
 /*  85 */ "expr ::= expr ifcond expr",
 /*  86 */ "expr ::= expr ISIN array",
 /*  87 */ "expr ::= expr ISIN value",
 /*  88 */ "expr ::= expr lop expr",
 /*  89 */ "expr ::= expr ISDIVBY expr",
 /*  90 */ "expr ::= expr ISNOTDIVBY expr",
 /*  91 */ "expr ::= expr ISEVEN",
 /*  92 */ "expr ::= expr ISNOTEVEN",
 /*  93 */ "expr ::= expr ISEVENBY expr",
 /*  94 */ "expr ::= expr ISNOTEVENBY expr",
 /*  95 */ "expr ::= expr ISODD",
 /*  96 */ "expr ::= expr ISNOTODD",
 /*  97 */ "expr ::= expr ISODDBY expr",
 /*  98 */ "expr ::= expr ISNOTODDBY expr",
 /*  99 */ "expr ::= value INSTANCEOF ID",
 /* 100 */ "expr ::= value INSTANCEOF value",
 /* 101 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /* 102 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /* 103 */ "value ::= variable",
 /* 104 */ "value ::= UNIMATH value",
 /* 105 */ "value ::= NOT value",
 /* 106 */ "value ::= TYPECAST value",
 /* 107 */ "value ::= variable INCDEC",
 /* 108 */ "value ::= HEX",
 /* 109 */ "value ::= INTEGER",
 /* 110 */ "value ::= INTEGER DOT INTEGER",
 /* 111 */ "value ::= INTEGER DOT",
 /* 112 */ "value ::= DOT INTEGER",
 /* 113 */ "value ::= ID",
 /* 114 */ "value ::= function",
 /* 115 */ "value ::= OPENP expr CLOSEP",
 /* 116 */ "value ::= SINGLEQUOTESTRING",
 /* 117 */ "value ::= doublequoted_with_quotes",
 /* 118 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 119 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 120 */ "value ::= smartytag",
 /* 121 */ "value ::= value modifierlist",
 /* 122 */ "variable ::= varindexed",
 /* 123 */ "variable ::= DOLLAR varvar AT ID",
 /* 124 */ "variable ::= object",
 /* 125 */ "variable ::= HATCH ID HATCH",
 /* 126 */ "variable ::= HATCH variable HATCH",
 /* 127 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 128 */ "arrayindex ::= arrayindex indexdef",
 /* 129 */ "arrayindex ::=",
 /* 130 */ "indexdef ::= DOT DOLLAR varvar",
 /* 131 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 132 */ "indexdef ::= DOT ID",
 /* 133 */ "indexdef ::= DOT INTEGER",
 /* 134 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 135 */ "indexdef ::= OPENB ID CLOSEB",
 /* 136 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 137 */ "indexdef ::= OPENB expr CLOSEB",
 /* 138 */ "indexdef ::= OPENB CLOSEB",
 /* 139 */ "varvar ::= varvarele",
 /* 140 */ "varvar ::= varvar varvarele",
 /* 141 */ "varvarele ::= ID",
 /* 142 */ "varvarele ::= LDEL expr RDEL",
 /* 143 */ "object ::= varindexed objectchain",
 /* 144 */ "objectchain ::= objectelement",
 /* 145 */ "objectchain ::= objectchain objectelement",
 /* 146 */ "objectelement ::= PTR ID arrayindex",
 /* 147 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 148 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 149 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 150 */ "objectelement ::= PTR method",
 /* 151 */ "function ::= ID OPENP params CLOSEP",
 /* 152 */ "method ::= ID OPENP params CLOSEP",
 /* 153 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 154 */ "params ::= params COMMA expr",
 /* 155 */ "params ::= expr",
 /* 156 */ "params ::=",
 /* 157 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 158 */ "modifierlist ::= modifier modparameters",
 /* 159 */ "modifier ::= VERT AT ID",
 /* 160 */ "modifier ::= VERT ID",
 /* 161 */ "modparameters ::= modparameters modparameter",
 /* 162 */ "modparameters ::=",
 /* 163 */ "modparameter ::= COLON value",
 /* 164 */ "modparameter ::= COLON array",
 /* 165 */ "static_class_access ::= method",
 /* 166 */ "static_class_access ::= method objectchain",
 /* 167 */ "static_class_access ::= ID",
 /* 168 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 169 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 170 */ "ifcond ::= EQUALS",
 /* 171 */ "ifcond ::= NOTEQUALS",
 /* 172 */ "ifcond ::= GREATERTHAN",
 /* 173 */ "ifcond ::= LESSTHAN",
 /* 174 */ "ifcond ::= GREATEREQUAL",
 /* 175 */ "ifcond ::= LESSEQUAL",
 /* 176 */ "ifcond ::= IDENTITY",
 /* 177 */ "ifcond ::= NONEIDENTITY",
 /* 178 */ "ifcond ::= MOD",
 /* 179 */ "lop ::= LAND",
 /* 180 */ "lop ::= LOR",
 /* 181 */ "lop ::= LXOR",
 /* 182 */ "array ::= OPENB arrayelements CLOSEB",
 /* 183 */ "arrayelements ::= arrayelement",
 /* 184 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 185 */ "arrayelements ::=",
 /* 186 */ "arrayelement ::= value APTR expr",
 /* 187 */ "arrayelement ::= ID APTR expr",
 /* 188 */ "arrayelement ::= expr",
 /* 189 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 190 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 191 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 192 */ "doublequoted ::= doublequotedcontent",
 /* 193 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 194 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 195 */ "doublequotedcontent ::= DOLLARID",
 /* 196 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 197 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 198 */ "doublequotedcontent ::= smartytag",
 /* 199 */ "doublequotedcontent ::= TEXT",
 /* 200 */ "optspace ::= SPACE",
 /* 201 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 84 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1753 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 0 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 0 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 5 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 5 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 6 ),
  array( 'lhs' => 84, 'rhs' => 6 ),
  array( 'lhs' => 84, 'rhs' => 7 ),
  array( 'lhs' => 84, 'rhs' => 6 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 6 ),
  array( 'lhs' => 84, 'rhs' => 5 ),
  array( 'lhs' => 84, 'rhs' => 7 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 12 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 6 ),
  array( 'lhs' => 84, 'rhs' => 8 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 8 ),
  array( 'lhs' => 84, 'rhs' => 11 ),
  array( 'lhs' => 84, 'rhs' => 8 ),
  array( 'lhs' => 84, 'rhs' => 11 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 5 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 5 ),
  array( 'lhs' => 84, 'rhs' => 6 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 0 ),
  array( 'lhs' => 99, 'rhs' => 4 ),
  array( 'lhs' => 99, 'rhs' => 4 ),
  array( 'lhs' => 99, 'rhs' => 4 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 4 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 4 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 8 ),
  array( 'lhs' => 100, 'rhs' => 7 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 0 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 5 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 4 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 5 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 3 ),
  array( 'lhs' => 113, 'rhs' => 4 ),
  array( 'lhs' => 113, 'rhs' => 5 ),
  array( 'lhs' => 113, 'rhs' => 6 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 4 ),
  array( 'lhs' => 114, 'rhs' => 4 ),
  array( 'lhs' => 114, 'rhs' => 5 ),
  array( 'lhs' => 115, 'rhs' => 3 ),
  array( 'lhs' => 115, 'rhs' => 1 ),
  array( 'lhs' => 115, 'rhs' => 0 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 0 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 0 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 1 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        16 => 16,
        19 => 16,
        201 => 16,
        17 => 17,
        76 => 17,
        18 => 18,
        104 => 18,
        106 => 18,
        107 => 18,
        128 => 18,
        166 => 18,
        20 => 20,
        21 => 20,
        47 => 20,
        69 => 20,
        70 => 20,
        77 => 20,
        78 => 20,
        83 => 20,
        103 => 20,
        108 => 20,
        109 => 20,
        114 => 20,
        116 => 20,
        117 => 20,
        124 => 20,
        139 => 20,
        165 => 20,
        167 => 20,
        183 => 20,
        188 => 20,
        200 => 20,
        22 => 22,
        23 => 22,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 28,
        29 => 29,
        31 => 29,
        30 => 30,
        32 => 32,
        33 => 32,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        44 => 42,
        43 => 43,
        45 => 45,
        46 => 46,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        61 => 61,
        62 => 62,
        63 => 63,
        72 => 63,
        155 => 63,
        159 => 63,
        163 => 63,
        164 => 63,
        64 => 64,
        156 => 64,
        162 => 64,
        65 => 65,
        66 => 66,
        67 => 66,
        71 => 66,
        68 => 68,
        73 => 73,
        74 => 74,
        75 => 74,
        79 => 79,
        80 => 80,
        81 => 80,
        82 => 80,
        84 => 84,
        121 => 84,
        85 => 85,
        88 => 85,
        99 => 85,
        86 => 86,
        87 => 87,
        89 => 89,
        90 => 90,
        91 => 91,
        96 => 91,
        92 => 92,
        95 => 92,
        93 => 93,
        98 => 93,
        94 => 94,
        97 => 94,
        100 => 100,
        101 => 101,
        102 => 102,
        105 => 105,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        115 => 115,
        118 => 118,
        119 => 119,
        120 => 120,
        122 => 122,
        123 => 123,
        125 => 125,
        126 => 126,
        127 => 127,
        129 => 129,
        185 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        137 => 134,
        135 => 135,
        136 => 136,
        138 => 138,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        153 => 153,
        154 => 154,
        157 => 157,
        158 => 158,
        160 => 160,
        161 => 161,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        182 => 182,
        184 => 184,
        186 => 186,
        187 => 187,
        189 => 189,
        190 => 190,
        191 => 191,
        192 => 192,
        193 => 193,
        194 => 193,
        196 => 193,
        195 => 195,
        197 => 197,
        198 => 198,
        199 => 199,
    );
#line 95 "smarty_internal_templateparser.y"
    function yy_r0(){
    $this->_retvalue = $this->root_buffer->to_smarty_php();
    }
#line 2185 "smarty_internal_templateparser.php"
#line 103 "smarty_internal_templateparser.y"
    function yy_r1(){
    $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2190 "smarty_internal_templateparser.php"
#line 119 "smarty_internal_templateparser.y"
    function yy_r4(){
    if ($this->compiler->has_code) {
        $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
        $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
    } else {
        $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
    $this->compiler->has_variable_string = false;
    $this->block_nesting_level = count($this->compiler->_tag_stack);
    }
#line 2202 "smarty_internal_templateparser.php"
#line 131 "smarty_internal_templateparser.y"
    function yy_r5(){
    $this->_retvalue = new _smarty_tag($this, '');
    }
#line 2207 "smarty_internal_templateparser.php"
#line 136 "smarty_internal_templateparser.y"
    function yy_r6(){
    $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 2212 "smarty_internal_templateparser.php"
#line 141 "smarty_internal_templateparser.y"
    function yy_r7(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if (!($this->smarty instanceof SmartyBC)) {
            $this->compiler->trigger_template_error (self::Err3);
        }
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        $this->_retvalue = new _smarty_text($this, '');
    }
    }
#line 2228 "smarty_internal_templateparser.php"
#line 157 "smarty_internal_templateparser.y"
    function yy_r8(){
    if ($this->is_xml) {
        $this->compiler->tag_nocache = true;
        $this->is_xml = false;
        $save = $this->template->has_nocache_code;
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>", $this->compiler, true));
        $this->template->has_nocache_code = $save;
    } elseif ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        $this->_retvalue = new _smarty_text($this, '');
    }
    }
#line 2247 "smarty_internal_templateparser.php"
#line 176 "smarty_internal_templateparser.y"
    function yy_r9(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if ($this->asp_tags) {
            if (!($this->smarty instanceof SmartyBC)) {
                $this->compiler->trigger_template_error (self::Err3);
            }
            $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
        } else {
            $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
        }
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, '');
        } else {
            $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
        }
    }
    }
#line 2271 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r10(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
        } else {
            $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
        }
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, '');
        } else {
            $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
        }
    }
    }
#line 2292 "smarty_internal_templateparser.php"
#line 220 "smarty_internal_templateparser.y"
    function yy_r11(){
    if ($this->strip) {
        $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor)));
    } else {
        $this->_retvalue = new _smarty_text($this, self::escape_start_tag());
    }
    }
#line 2301 "smarty_internal_templateparser.php"
#line 229 "smarty_internal_templateparser.y"
    function yy_r12(){
    $this->compiler->tag_nocache = true;
    $this->is_xml = true;
    $save = $this->template->has_nocache_code;
    $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));
    $this->template->has_nocache_code = $save;
    }
#line 2310 "smarty_internal_templateparser.php"
#line 238 "smarty_internal_templateparser.y"
    function yy_r13(){
    if ($this->strip) {
        $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));
    } else {
        $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
    }
    }
#line 2319 "smarty_internal_templateparser.php"
#line 247 "smarty_internal_templateparser.y"
    function yy_r14(){
    $this->strip = true;
    $this->_retvalue = new _smarty_text($this, '');
    }
#line 2325 "smarty_internal_templateparser.php"
#line 252 "smarty_internal_templateparser.y"
    function yy_r15(){
    $this->strip = false;
    $this->_retvalue = new _smarty_text($this, '');
    }
#line 2331 "smarty_internal_templateparser.php"
#line 258 "smarty_internal_templateparser.y"
    function yy_r16(){
    $this->_retvalue = '';
    }
#line 2336 "smarty_internal_templateparser.php"
#line 262 "smarty_internal_templateparser.y"
    function yy_r17(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 2341 "smarty_internal_templateparser.php"
#line 266 "smarty_internal_templateparser.y"
    function yy_r18(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2346 "smarty_internal_templateparser.php"
#line 274 "smarty_internal_templateparser.y"
    function yy_r20(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2351 "smarty_internal_templateparser.php"
#line 282 "smarty_internal_templateparser.y"
    function yy_r22(){
    $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2356 "smarty_internal_templateparser.php"
#line 290 "smarty_internal_templateparser.y"
    function yy_r24(){
    $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2361 "smarty_internal_templateparser.php"
#line 294 "smarty_internal_templateparser.y"
    function yy_r25(){
    $this->_retvalue = '<<?php ?>%';
    }
#line 2366 "smarty_internal_templateparser.php"
#line 298 "smarty_internal_templateparser.y"
    function yy_r26(){
    $this->_retvalue = '%<?php ?>>';
    }
#line 2371 "smarty_internal_templateparser.php"
#line 307 "smarty_internal_templateparser.y"
    function yy_r27(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2376 "smarty_internal_templateparser.php"
#line 311 "smarty_internal_templateparser.y"
    function yy_r28(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor, 'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2381 "smarty_internal_templateparser.php"
#line 315 "smarty_internal_templateparser.y"
    function yy_r29(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2386 "smarty_internal_templateparser.php"
#line 319 "smarty_internal_templateparser.y"
    function yy_r30(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2391 "smarty_internal_templateparser.php"
#line 332 "smarty_internal_templateparser.y"
    function yy_r32(){
    $this->_retvalue = $this->compiler->compileTag('assign',array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'")));
    }
#line 2396 "smarty_internal_templateparser.php"
#line 340 "smarty_internal_templateparser.y"
    function yy_r34(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'")),$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2401 "smarty_internal_templateparser.php"
#line 344 "smarty_internal_templateparser.y"
    function yy_r35(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>$this->yystack[$this->yyidx + -4]->minor['var'])),$this->yystack[$this->yyidx + -1]->minor),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -4]->minor['smarty_internal_index']));
    }
#line 2406 "smarty_internal_templateparser.php"
#line 349 "smarty_internal_templateparser.y"
    function yy_r36(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);
    }
#line 2411 "smarty_internal_templateparser.php"
#line 353 "smarty_internal_templateparser.y"
    function yy_r37(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());
    }
#line 2416 "smarty_internal_templateparser.php"
#line 358 "smarty_internal_templateparser.y"
    function yy_r38(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2421 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r39(){
    $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
    }
#line 2427 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r40(){
    $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -3]->minor)).'<?php echo ';
    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
    }
#line 2433 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r41(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2439 "smarty_internal_templateparser.php"
#line 380 "smarty_internal_templateparser.y"
    function yy_r42(){
    $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + -1]->minor,array('if condition'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2445 "smarty_internal_templateparser.php"
#line 385 "smarty_internal_templateparser.y"
    function yy_r43(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2451 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r45(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -10]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -7]->minor),array('var'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),1);
    }
#line 2456 "smarty_internal_templateparser.php"
#line 400 "smarty_internal_templateparser.y"
    function yy_r46(){
    $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2461 "smarty_internal_templateparser.php"
#line 408 "smarty_internal_templateparser.y"
    function yy_r48(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -4]->minor),array('to'=>$this->yystack[$this->yyidx + -2]->minor))),0);
    }
#line 2466 "smarty_internal_templateparser.php"
#line 412 "smarty_internal_templateparser.y"
    function yy_r49(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('to'=>$this->yystack[$this->yyidx + -4]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),0);
    }
#line 2471 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r50(){
    $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);
    }
#line 2476 "smarty_internal_templateparser.php"
#line 422 "smarty_internal_templateparser.y"
    function yy_r51(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));
    }
#line 2481 "smarty_internal_templateparser.php"
#line 426 "smarty_internal_templateparser.y"
    function yy_r52(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));
    }
#line 2486 "smarty_internal_templateparser.php"
#line 430 "smarty_internal_templateparser.y"
    function yy_r53(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));
    }
#line 2491 "smarty_internal_templateparser.php"
#line 434 "smarty_internal_templateparser.y"
    function yy_r54(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));
    }
#line 2496 "smarty_internal_templateparser.php"
#line 439 "smarty_internal_templateparser.y"
    function yy_r55(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array(array_merge(array($this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor))));
    }
#line 2501 "smarty_internal_templateparser.php"
#line 443 "smarty_internal_templateparser.y"
    function yy_r56(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array_merge(array(array_merge(array($this->yystack[$this->yyidx + -3]->minor),$this->yystack[$this->yyidx + -2]->minor)),$this->yystack[$this->yyidx + -1]->minor)));
    }
#line 2506 "smarty_internal_templateparser.php"
#line 448 "smarty_internal_templateparser.y"
    function yy_r57(){
    $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);
    }
#line 2511 "smarty_internal_templateparser.php"
#line 454 "smarty_internal_templateparser.y"
    function yy_r58(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());
    }
#line 2516 "smarty_internal_templateparser.php"
#line 458 "smarty_internal_templateparser.y"
    function yy_r59(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2521 "smarty_internal_templateparser.php"
#line 463 "smarty_internal_templateparser.y"
    function yy_r60(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2526 "smarty_internal_templateparser.php"
#line 467 "smarty_internal_templateparser.y"
    function yy_r61(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2531 "smarty_internal_templateparser.php"
#line 475 "smarty_internal_templateparser.y"
    function yy_r62(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2537 "smarty_internal_templateparser.php"
#line 481 "smarty_internal_templateparser.y"
    function yy_r63(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2542 "smarty_internal_templateparser.php"
#line 486 "smarty_internal_templateparser.y"
    function yy_r64(){
    $this->_retvalue = array();
    }
#line 2547 "smarty_internal_templateparser.php"
#line 491 "smarty_internal_templateparser.y"
    function yy_r65(){
    if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
    } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
    } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
    } else {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");
    }
    }
#line 2560 "smarty_internal_templateparser.php"
#line 503 "smarty_internal_templateparser.y"
    function yy_r66(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2565 "smarty_internal_templateparser.php"
#line 511 "smarty_internal_templateparser.y"
    function yy_r68(){
    $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";
    }
#line 2570 "smarty_internal_templateparser.php"
#line 536 "smarty_internal_templateparser.y"
    function yy_r73(){
    $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor;
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 2576 "smarty_internal_templateparser.php"
#line 541 "smarty_internal_templateparser.y"
    function yy_r74(){
    $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2581 "smarty_internal_templateparser.php"
#line 569 "smarty_internal_templateparser.y"
    function yy_r79(){
    $this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';
    }
#line 2586 "smarty_internal_templateparser.php"
#line 574 "smarty_internal_templateparser.y"
    function yy_r80(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2591 "smarty_internal_templateparser.php"
#line 593 "smarty_internal_templateparser.y"
    function yy_r84(){
    $this->_retvalue = $this->compiler->compileTag('private_modifier',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2596 "smarty_internal_templateparser.php"
#line 599 "smarty_internal_templateparser.y"
    function yy_r85(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2601 "smarty_internal_templateparser.php"
#line 603 "smarty_internal_templateparser.y"
    function yy_r86(){
    $this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2606 "smarty_internal_templateparser.php"
#line 607 "smarty_internal_templateparser.y"
    function yy_r87(){
    $this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2611 "smarty_internal_templateparser.php"
#line 615 "smarty_internal_templateparser.y"
    function yy_r89(){
    $this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2616 "smarty_internal_templateparser.php"
#line 619 "smarty_internal_templateparser.y"
    function yy_r90(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2621 "smarty_internal_templateparser.php"
#line 623 "smarty_internal_templateparser.y"
    function yy_r91(){
    $this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2626 "smarty_internal_templateparser.php"
#line 627 "smarty_internal_templateparser.y"
    function yy_r92(){
    $this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2631 "smarty_internal_templateparser.php"
#line 631 "smarty_internal_templateparser.y"
    function yy_r93(){
    $this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2636 "smarty_internal_templateparser.php"
#line 635 "smarty_internal_templateparser.y"
    function yy_r94(){
    $this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2641 "smarty_internal_templateparser.php"
#line 659 "smarty_internal_templateparser.y"
    function yy_r100(){
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>';
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;
    }
#line 2648 "smarty_internal_templateparser.php"
#line 668 "smarty_internal_templateparser.y"
    function yy_r101(){
    $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.' ? '. $this->compileVariable("'".$this->yystack[$this->yyidx + -2]->minor."'") . ' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2653 "smarty_internal_templateparser.php"
#line 672 "smarty_internal_templateparser.y"
    function yy_r102(){
    $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2658 "smarty_internal_templateparser.php"
#line 687 "smarty_internal_templateparser.y"
    function yy_r105(){
    $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2663 "smarty_internal_templateparser.php"
#line 708 "smarty_internal_templateparser.y"
    function yy_r110(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2668 "smarty_internal_templateparser.php"
#line 712 "smarty_internal_templateparser.y"
    function yy_r111(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';
    }
#line 2673 "smarty_internal_templateparser.php"
#line 716 "smarty_internal_templateparser.y"
    function yy_r112(){
    $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2678 "smarty_internal_templateparser.php"
#line 721 "smarty_internal_templateparser.y"
    function yy_r113(){
    if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'true';
    } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'false';
    } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'null';
    } else {
        $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";
    }
    }
#line 2691 "smarty_internal_templateparser.php"
#line 739 "smarty_internal_templateparser.y"
    function yy_r115(){
    $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";
    }
#line 2696 "smarty_internal_templateparser.php"
#line 754 "smarty_internal_templateparser.y"
    function yy_r118(){
    if (!$this->security || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor]) || $this->smarty->security_policy->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
        if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
            $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
        } else {
            $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
        }
    } else {
        $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
    }
    }
#line 2709 "smarty_internal_templateparser.php"
#line 766 "smarty_internal_templateparser.y"
    function yy_r119(){
    if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') {
        $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + -2]->minor['var']).$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 2718 "smarty_internal_templateparser.php"
#line 775 "smarty_internal_templateparser.y"
    function yy_r120(){
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>';
    $this->_retvalue = '$_tmp'.$this->prefix_number;
    }
#line 2725 "smarty_internal_templateparser.php"
#line 790 "smarty_internal_templateparser.y"
    function yy_r122(){
    if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') {
        $smarty_var = $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
        $this->_retvalue = $smarty_var;
    } else {
        // used for array reset,next,prev,end,current
        $this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
        $this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + 0]->minor['var']).$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
    }
    }
#line 2738 "smarty_internal_templateparser.php"
#line 803 "smarty_internal_templateparser.y"
    function yy_r123(){
    $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2743 "smarty_internal_templateparser.php"
#line 813 "smarty_internal_templateparser.y"
    function yy_r125(){
    $this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';
    }
#line 2748 "smarty_internal_templateparser.php"
#line 817 "smarty_internal_templateparser.y"
    function yy_r126(){
    $this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';
    }
#line 2753 "smarty_internal_templateparser.php"
#line 821 "smarty_internal_templateparser.y"
    function yy_r127(){
    $this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2758 "smarty_internal_templateparser.php"
#line 834 "smarty_internal_templateparser.y"
    function yy_r129(){
    return;
    }
#line 2763 "smarty_internal_templateparser.php"
#line 840 "smarty_internal_templateparser.y"
    function yy_r130(){
    $this->_retvalue = '['.$this->compileVariable($this->yystack[$this->yyidx + 0]->minor).']';
    }
#line 2768 "smarty_internal_templateparser.php"
#line 844 "smarty_internal_templateparser.y"
    function yy_r131(){
    $this->_retvalue = '['.$this->compileVariable($this->yystack[$this->yyidx + -2]->minor).'->'.$this->yystack[$this->yyidx + 0]->minor.']';
    }
#line 2773 "smarty_internal_templateparser.php"
#line 848 "smarty_internal_templateparser.y"
    function yy_r132(){
    $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";
    }
#line 2778 "smarty_internal_templateparser.php"
#line 852 "smarty_internal_templateparser.y"
    function yy_r133(){
    $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";
    }
#line 2783 "smarty_internal_templateparser.php"
#line 856 "smarty_internal_templateparser.y"
    function yy_r134(){
    $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";
    }
#line 2788 "smarty_internal_templateparser.php"
#line 861 "smarty_internal_templateparser.y"
    function yy_r135(){
    $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';
    }
#line 2793 "smarty_internal_templateparser.php"
#line 865 "smarty_internal_templateparser.y"
    function yy_r136(){
    $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';
    }
#line 2798 "smarty_internal_templateparser.php"
#line 875 "smarty_internal_templateparser.y"
    function yy_r138(){
    $this->_retvalue = '[]';
    }
#line 2803 "smarty_internal_templateparser.php"
#line 888 "smarty_internal_templateparser.y"
    function yy_r140(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2808 "smarty_internal_templateparser.php"
#line 893 "smarty_internal_templateparser.y"
    function yy_r141(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';
    }
#line 2813 "smarty_internal_templateparser.php"
#line 898 "smarty_internal_templateparser.y"
    function yy_r142(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2818 "smarty_internal_templateparser.php"
#line 905 "smarty_internal_templateparser.y"
    function yy_r143(){
    if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') {
        $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + -1]->minor['var']).$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 2827 "smarty_internal_templateparser.php"
#line 914 "smarty_internal_templateparser.y"
    function yy_r144(){
    $this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2832 "smarty_internal_templateparser.php"
#line 919 "smarty_internal_templateparser.y"
    function yy_r145(){
    $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2837 "smarty_internal_templateparser.php"
#line 924 "smarty_internal_templateparser.y"
    function yy_r146(){
    if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '_') {
        $this->compiler->trigger_template_error (self::Err1);
    }
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2845 "smarty_internal_templateparser.php"
#line 931 "smarty_internal_templateparser.y"
    function yy_r147(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{'.$this->compileVariable($this->yystack[$this->yyidx + -1]->minor).$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2853 "smarty_internal_templateparser.php"
#line 938 "smarty_internal_templateparser.y"
    function yy_r148(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2861 "smarty_internal_templateparser.php"
#line 945 "smarty_internal_templateparser.y"
    function yy_r149(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2869 "smarty_internal_templateparser.php"
#line 953 "smarty_internal_templateparser.y"
    function yy_r150(){
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2874 "smarty_internal_templateparser.php"
#line 961 "smarty_internal_templateparser.y"
    function yy_r151(){
    if (!$this->security || $this->smarty->security_policy->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
        if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'array') === 0 || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
            $func_name = strtolower($this->yystack[$this->yyidx + -3]->minor);
            if ($func_name == 'isset') {
                if (count($this->yystack[$this->yyidx + -1]->minor) == 0) {
                    $this->compiler->trigger_template_error ('Illegal number of paramer in "isset()"');
                }
                $par = implode(',',$this->yystack[$this->yyidx + -1]->minor);
                if (strncasecmp($par,'$_smarty_tpl->getConfigVariable',strlen('$_smarty_tpl->getConfigVariable')) === 0) {
                    $this->prefix_number++;
                    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.str_replace(')',', false)',$par).';?>';
                    $isset_par = '$_tmp'.$this->prefix_number;
                } else {
                    $isset_par=str_replace("')->value","',null,true,false)->value",$par);
                }
                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $isset_par .")";
            } elseif (in_array($func_name,array('empty','reset','current','end','prev','next'))){
                if (count($this->yystack[$this->yyidx + -1]->minor) != 1) {
                    $this->compiler->trigger_template_error ('Illegal number of paramer in "empty()"');
                }
                if ($func_name == 'empty') {
                    $this->_retvalue = $func_name.'('.str_replace("')->value","',null,true,false)->value",$this->yystack[$this->yyidx + -1]->minor[0]).')';
                } else {
                    $this->_retvalue = $func_name.'('.$this->yystack[$this->yyidx + -1]->minor[0].')';
                }
            } else {
                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
            }
        } else {
            $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
        }
    }
    }
#line 2910 "smarty_internal_templateparser.php"
#line 999 "smarty_internal_templateparser.y"
    function yy_r152(){
    if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) == '_') {
        $this->compiler->trigger_template_error (self::Err1);
    }
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
    }
#line 2918 "smarty_internal_templateparser.php"
#line 1006 "smarty_internal_templateparser.y"
    function yy_r153(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->compileVariable("'".$this->yystack[$this->yyidx + -3]->minor."'").';?>';
    $this->_retvalue = '$_tmp'.$this->prefix_number.'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
    }
#line 2928 "smarty_internal_templateparser.php"
#line 1017 "smarty_internal_templateparser.y"
    function yy_r154(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));
    }
#line 2933 "smarty_internal_templateparser.php"
#line 1034 "smarty_internal_templateparser.y"
    function yy_r157(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));
    }
#line 2938 "smarty_internal_templateparser.php"
#line 1038 "smarty_internal_templateparser.y"
    function yy_r158(){
    $this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2943 "smarty_internal_templateparser.php"
#line 1046 "smarty_internal_templateparser.y"
    function yy_r160(){
    $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2948 "smarty_internal_templateparser.php"
#line 1054 "smarty_internal_templateparser.y"
    function yy_r161(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2953 "smarty_internal_templateparser.php"
#line 1088 "smarty_internal_templateparser.y"
    function yy_r168(){
    $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2958 "smarty_internal_templateparser.php"
#line 1093 "smarty_internal_templateparser.y"
    function yy_r169(){
    $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2963 "smarty_internal_templateparser.php"
#line 1099 "smarty_internal_templateparser.y"
    function yy_r170(){
    $this->_retvalue = '==';
    }
#line 2968 "smarty_internal_templateparser.php"
#line 1103 "smarty_internal_templateparser.y"
    function yy_r171(){
    $this->_retvalue = '!=';
    }
#line 2973 "smarty_internal_templateparser.php"
#line 1107 "smarty_internal_templateparser.y"
    function yy_r172(){
    $this->_retvalue = '>';
    }
#line 2978 "smarty_internal_templateparser.php"
#line 1111 "smarty_internal_templateparser.y"
    function yy_r173(){
    $this->_retvalue = '<';
    }
#line 2983 "smarty_internal_templateparser.php"
#line 1115 "smarty_internal_templateparser.y"
    function yy_r174(){
    $this->_retvalue = '>=';
    }
#line 2988 "smarty_internal_templateparser.php"
#line 1119 "smarty_internal_templateparser.y"
    function yy_r175(){
    $this->_retvalue = '<=';
    }
#line 2993 "smarty_internal_templateparser.php"
#line 1123 "smarty_internal_templateparser.y"
    function yy_r176(){
    $this->_retvalue = '===';
    }
#line 2998 "smarty_internal_templateparser.php"
#line 1127 "smarty_internal_templateparser.y"
    function yy_r177(){
    $this->_retvalue = '!==';
    }
#line 3003 "smarty_internal_templateparser.php"
#line 1131 "smarty_internal_templateparser.y"
    function yy_r178(){
    $this->_retvalue = '%';
    }
#line 3008 "smarty_internal_templateparser.php"
#line 1135 "smarty_internal_templateparser.y"
    function yy_r179(){
    $this->_retvalue = '&&';
    }
#line 3013 "smarty_internal_templateparser.php"
#line 1139 "smarty_internal_templateparser.y"
    function yy_r180(){
    $this->_retvalue = '||';
    }
#line 3018 "smarty_internal_templateparser.php"
#line 1143 "smarty_internal_templateparser.y"
    function yy_r181(){
    $this->_retvalue = ' XOR ';
    }
#line 3023 "smarty_internal_templateparser.php"
#line 1150 "smarty_internal_templateparser.y"
    function yy_r182(){
    $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 3028 "smarty_internal_templateparser.php"
#line 1158 "smarty_internal_templateparser.y"
    function yy_r184(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3033 "smarty_internal_templateparser.php"
#line 1166 "smarty_internal_templateparser.y"
    function yy_r186(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3038 "smarty_internal_templateparser.php"
#line 1170 "smarty_internal_templateparser.y"
    function yy_r187(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3043 "smarty_internal_templateparser.php"
#line 1182 "smarty_internal_templateparser.y"
    function yy_r189(){
    $this->_retvalue = "''";
    }
#line 3048 "smarty_internal_templateparser.php"
#line 1186 "smarty_internal_templateparser.y"
    function yy_r190(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();
    }
#line 3053 "smarty_internal_templateparser.php"
#line 1191 "smarty_internal_templateparser.y"
    function yy_r191(){
    $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 3059 "smarty_internal_templateparser.php"
#line 1196 "smarty_internal_templateparser.y"
    function yy_r192(){
    $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3064 "smarty_internal_templateparser.php"
#line 1200 "smarty_internal_templateparser.y"
    function yy_r193(){
    $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 3069 "smarty_internal_templateparser.php"
#line 1208 "smarty_internal_templateparser.y"
    function yy_r195(){
    $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
    }
#line 3074 "smarty_internal_templateparser.php"
#line 1216 "smarty_internal_templateparser.y"
    function yy_r197(){
    $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');
    }
#line 3079 "smarty_internal_templateparser.php"
#line 1220 "smarty_internal_templateparser.y"
    function yy_r198(){
    $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3084 "smarty_internal_templateparser.php"
#line 1224 "smarty_internal_templateparser.y"
    function yy_r199(){
    $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3089 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 77 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 3152 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 69 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 3170 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);

        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>