<?php
/**
 * Internationalisation file for Widgets extension.
 *
 */

$messages = array();

$messages['en'] = array(
	'widgets-desc' => 'Allows wiki administrators to add free-form widgets to the wiki by editing pages within the {{ns:widget}} namespace.
Community-contributed widgets can be found on [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Error in [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Widget editors',
	'group-widgeteditor-member' => '{{GENDER:$1|widget editor}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Widget editors',
	'right-editwidgets' => 'Create and edit [http://www.mediawiki.org/wiki/Extension:Widgets widgets] in the <tt>{{ns:widget}}</tt> namespace',

	'group-widgeteditor.css' => '/* CSS placed here will affect widget editors only */', # only translate this message to other languages if you have to change it
	'group-widgeteditor.js'  => '/* JS placed here will affect widget editors only */', # only translate this message to other languages if you have to change it
);

/** Message documentation (Message documentation)
 * @author Fryed-peach
 * @author Khaledelmansoury
 * @author Purodha
 * @author Shirayuki
 * @author Siebrand
 * @author Umherirrender
 * @author 아라
 */
$messages['qqq'] = array(
	'widgets-desc' => '{{desc|name=Widgets|url=http://www.mediawiki.org/wiki/Extension:Widgets}}',
	'group-widgeteditor' => '{{doc-group|widgeteditor}}',
	'group-widgeteditor-member' => '{{doc-group|widgeteditor|member}}',
	'grouppage-widgeteditor' => '{{doc-group|widgeteditor|page}}',
	'right-editwidgets' => '{{doc-right|editwidgets}}',
	'group-widgeteditor.css' => '{{doc-group|widgeteditor|css}}',
	'group-widgeteditor.js' => '{{doc-group|widgeteditor|js}}',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'widgets-desc' => 'Wiki jep mundësin administratorëve të shtoni pa-formë Widgets në wiki nga faqet redaktimi brenda {{ns:widget}} hapësira. Zhvilluar Fillimisht për [http://www.ardorado.com Ardorado.com]', # Fuzzy
	'widgets-error' => 'Gabim në [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'redaktorët widget',
	'group-widgeteditor-member' => 'editor widget', # Fuzzy
	'grouppage-widgeteditor' => 'Projekti: redaktorët widget', # Fuzzy
	'right-editwidgets' => 'Krijo dhe ndrysho http://www.mediawiki.org/wiki/Extension:Widgets [Widgets] në <tt>{{ns:widget}}</tt> namespace',
);

/** Arabic (العربية)
 * @author ;Hiba;1
 * @author DRIHEM
 * @author OsamaK
 * @author زكريا
 */
$messages['ar'] = array(
	'widgets-desc' => 'يتيح لإداريي الويكي إضافة ودجات حرة الشكل إلى الويكي عن طريق تعديل صفحات نطاق {{ns:widget}}.
الودجات التي يساهم بها المجتمع توجد في [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'خطأ في [[{{ns:widget}}:$1|الودجة $1]]',
	'group-widgeteditor' => 'محررو الودجات',
	'group-widgeteditor-member' => '{{GENDER:$1|محرر ودجات}}',
	'grouppage-widgeteditor' => '{{ns:project}}:محررو الودجات',
	'right-editwidgets' => 'إنشاء وتحرير [http://www.mediawiki.org/wiki/Extension:Widgets widgets] في الــ <tt>{{ns:widget}}</tt> مكان الاسم',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'widgets-desc' => 'Дазваляе адміністратарам {{GRAMMAR:родны|{{SITENAME}}}} дадаваць віджэты вольных формаў у {{GRAMMAR:вінавальны|{{SITENAME}}}} праз рэдагаваньне старонак у прасторы назваў {{ns:widget}}. 
Віджэты, якія падтрымліваюцца супольнасьцю, можна знайсьці на [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Памылка ў [[{{ns:widget}}:$1|віджэце $1]]',
	'group-widgeteditor' => 'Рэдактар віджэтаў',
	'group-widgeteditor-member' => '{{GENDER:$1|Рэдактар|Рэдактарка}} віджэтаў',
	'grouppage-widgeteditor' => '{{ns:project}}:Рэдактары віджэтаў',
	'right-editwidgets' => 'стварэньне і рэдагаваньне [http://www.mediawiki.org/wiki/Extension:Widgets дапаўненьняў] у прасторы назваў <tt>{{ns:widget}}</tt>',
);

/** Breton (brezhoneg)
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'widgets-desc' => "Talvezout a ra d'ar verourien da ouzhpennañ widgetoù d'ar wiki en ur gemmañ pajennoù en esaouenn anv {{ns:widget}}.
Ar widgetoù kinniget gant ar gumuniezh a gaver war [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Fazi e [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Aozerien widget',
	'group-widgeteditor-member' => '{{GENDER:$1|Aozer|Aozerez}} Widget',
	'grouppage-widgeteditor' => '{{ns:project}}:Aozerien widget',
	'right-editwidgets' => 'Krouiñ ha kemmañ ar [http://www.mediawiki.org/wiki/Extension:Widgets widgetoù] en esaouenn anv <tt>{{ns:widget}}<tt>',
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'widgets-desc' => 'Omogućuje wiki administratorima da dodaju dodatke u slobodnoj formi na wiki putem uređivanja stranica unutar imenskog prostora {{ns:widget}}.
Prvobitno razvijeni dodaci se mogu naći na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Greška u [[{{ns:widget}}:$1|widgetu $1]]',
	'group-widgeteditor' => 'Uređivači dodataka',
	'group-widgeteditor-member' => 'Uređivač dodataka', # Fuzzy
	'grouppage-widgeteditor' => '{{ns:project}}:Uređivač dodataka',
	'right-editwidgets' => 'Pravljenje i uređivanje [http://www.mediawiki.org/wiki/Extension:Widgets widgeta] u imenskom prostoru <tt>{{ns:widget}}</tt>',
);

/** Catalan (català)
 * @author Paucabot
 * @author SMP
 */
$messages['ca'] = array(
	'right-editwidgets' => "Crear i editar [http://www.mediawiki.org/wiki/Extension:Widgets ginys] a l'espai de noms <tt>{{ns:widget}}</tt>",
);

/** Czech (česky)
 * @author Kuvaly
 * @author Matěj Grabovský
 * @author Mormegil
 * @author Reaperman
 */
$messages['cs'] = array(
	'widgets-desc' => 'Umožňuje správcům wiki přidávat na wiki ovládací prvky úpravou stránek ve jmenném prostoru {{ns:widget}}.
Prvky vytvořené komunitou lze nalézt na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Chyba ve [[{{ns:widget}}:$1|widgetu $1]]',
	'group-widgeteditor' => 'Editoři ovládacích prvků',
	'group-widgeteditor-member' => '{{GENDER:$1|editor ovládacích prvků|editorka ovládacích prvků}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Editoři ovládacích prvků',
	'right-editwidgets' => 'Tvorba a úprava stránek [http://www.mediawiki.org/wiki/Extension:Widgets ovládacích prvků] ve jmenném prostoru <tt>{{ns:widget}}</tt>',
	'group-widgeteditor.css' => '/* Zde uvedené CSS bude ovlivňovat pouze editory ovládacích prvků */',
	'group-widgeteditor.js' => '/* Zde uvedený JavaScript bude použit pouze pro editory ovládacích prvků */',
);

/** German (Deutsch)
 * @author Jan Luca
 * @author Kghbln
 * @author Pill
 * @author Sebastian Wallroth
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de'] = array(
	'widgets-desc' => 'Ermöglicht das Hinzufügen von Freiformat-Widgets durch das Bearbeiten von Seiten im Namensraum {{ns:widget}}.
Vorhandene Widgets werden auf der Website [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] gesammelt',
	'widgets-error' => 'Fehler beim [[{{ns:widget}}:$1|Widget $1]]',
	'group-widgeteditor' => 'Widget-Bearbeiter',
	'group-widgeteditor-member' => '{{GENDER:$1|Widget-Bearbeiter|Widget-Bearbeiterin}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Widget-Bearbeiter',
	'right-editwidgets' => '[https://www.mediawiki.org/wiki/Extension:Widgets Widgets] im <code>{{ns:widget}}</code>-Namensraum bearbeiten und erstellen',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'widgets-desc' => 'Dowólujo wikijowym administratoram wikijeju pśez wobźěłowanje w mjenjowem rumje {{ns:widget}} swójske miniprogramy pśidaś.
Miniprogramy, kótarež su se napórali wót zromaźeństwa, móžoš na  [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] namakaś.',
	'widgets-error' => 'Zmólka w [[{{ns:widget}}:$1|miniprogramje $1]]',
	'group-widgeteditor' => 'Wobźěłowarje miniprogramow',
	'group-widgeteditor-member' => '{{GENDER:$1|Wobźěłaŕ miniprogramow|Wobźěłarka miniprogramow}}',
	'grouppage-widgeteditor' => '{{ns:project}}: Wobźěłowarje miniprogramow',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Woknowe elementy] w mjenjowem rumje <tt>{{ns:widget}}</tt> napóraś a wobźěłaś',
);

/** Greek (Ελληνικά)
 * @author Geraki
 * @author Lou
 * @author Omnipaedista
 * @author Protnet
 * @author ZaDiak
 */
$messages['el'] = array(
	'widgets-desc' => 'Επιτρέπει στους διαχειριστές του wiki να προσθέτουν ελεύθερης μορφής widget στο wiki μέσω επεξεργασίας σελίδων στο χώρο ονομάτων {{ns:widget}}.
Widget φτιαγμένα από την κοινότητα μπορούν να βρεθούν στο [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Σφάλμα στο [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Επεξεργαστές widget',
	'group-widgeteditor-member' => 'Επεξεργαστής widget',
	'grouppage-widgeteditor' => '{{ns:project}}:Επεξεργαστές widget',
	'right-editwidgets' => 'Δημιουργία και επεξεργασία [http://www.mediawiki.org/wiki/Extension:Widgets widget] στο χώρο ονομάτων <tt>{{ns:widget}}</tt>',
);

/** Esperanto (Esperanto)
 * @author Airon90
 */
$messages['eo'] = array(
	'widgets-error' => 'Eraro en [[{{ns:widget}}:$1|fenestraĵo $1]]',
	'group-widgeteditor' => 'Fenestraĵaj eldonistoj',
	'group-widgeteditor-member' => 'Fenestraĵa eldonist{{GENDER:$1||in}}o',
	'grouppage-widgeteditor' => '{{ns:project}}:Fenestraĵaj eldonistoj',
	'right-editwidgets' => 'Krei kaj redakti [http://www.mediawiki.org/vikia/Extension:Widgets fenestraĵojn] en la nomspaco <tt>{{ns:widget}}</tt>',
);

/** Spanish (español)
 * @author Antur
 * @author Armando-Martin
 * @author Crazymadlover
 * @author Diego Grez
 * @author Peter17
 */
$messages['es'] = array(
	'widgets-desc' => 'Permite a los administradores agregar widgets a la wiki editando páginas dentro del espacio de nombres {{ns:widget}}.
Widgets desarrollados comunitariamente pueden ser encontrados en [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Error en [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Editores de widget',
	'group-widgeteditor-member' => '{{GENDER:$1|editor|editora}} de widgets',
	'grouppage-widgeteditor' => '{{ns:project}}:Editores de widget',
	'right-editwidgets' => 'Crear y editar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] en el espacio de nombre "{{ns:widget}}"',
);

/** Persian (فارسی)
 * @author ZxxZxxZ
 */
$messages['fa'] = array(
	'widgets-error' => 'خطا در [[{{ns:widget}}:$1|ابزار $1]]',
	'group-widgeteditor' => 'ویرایشگران ابزار',
	'group-widgeteditor-member' => '{{GENDER:$1|ویرایشگر ابزار}}',
	'grouppage-widgeteditor' => '{{ns:project}}:ویرایشگران ابزار',
	'right-editwidgets' => 'ایجاد و ویرایش [http://www.mediawiki.org/wiki/Extension:Widgets ابزارها] در فضای‌نام <tt>{{ns:widget}}</tt>',
);

/** Finnish (suomi)
 * @author Cimon Avaro
 * @author Crt
 * @author Nike
 */
$messages['fi'] = array(
	'widgets-desc' => 'Mahdollistaa wikin ylläpitäjille vapaamuotoisten pienoisohjelmien lisäämisen sivua nimiavaruudessa {{ns:widget}} muokkaamalla.
Yhteisön tekemiä pienoisohjelmia löytyy osoitteesta [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Virhe [[{{ns:widget}}:$1|pienoisohjelmassa $1]]',
	'group-widgeteditor' => 'pienoisohjelmien muokkaajat',
	'group-widgeteditor-member' => '{{GENDER:$1|pienoisohjelman muokkaaja}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Pienoisohjelmien muokkaajat',
	'right-editwidgets' => 'Luoda ja muokata [http://www.mediawiki.org/wiki/Extension:Widgets pienoisohjelmia] nimiavaruudessa <tt>{{ns:widget}}</tt>',
);

/** French (français)
 * @author Gomoko
 * @author IAlex
 * @author Jean-Frédéric
 * @author Urhixidur
 */
$messages['fr'] = array(
	'widgets-desc' => "Permet aux administrateurs du wiki d’ajouter des ''widgets'' (gadgets logiciels) au wiki en modifiant des pages dans l’espace de noms {{ns:widget}}. Les ''widgets'' proposés par la communauté sont disponibles sur [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Erreur dans le [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Modificateurs de widgets',
	'group-widgeteditor-member' => '{{GENDER:$1|Modificateur de widget}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Modificateurs de widgets',
	'right-editwidgets' => 'Créer et modifier les [http://www.mediawiki.org/wiki/Extension:Widgets widgets] dans l’espace de noms « {{ns:widget}} »',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'widgets-error' => 'Èrror dens lo [[{{ns:widget}}:$1|vouidgèt $1]]',
	'group-widgeteditor' => 'Changiors de vouidgèts',
	'group-widgeteditor-member' => 'changio{{GENDER:$1|r|sa}} de vouidgèts',
	'grouppage-widgeteditor' => '{{ns:project}}:Changiors de vouidgèts',
	'right-editwidgets' => 'Fâre et changiér los [http://www.mediawiki.org/wiki/Extension:Widgets vouidgèts] dens l’èspâço de noms « {{ns:widget}} »',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'widgets-desc' => 'Permite aos administradores do wiki engadir widgets ao editar páxinas no espazo de nomes "{{ns:widget}}".
Pódense atopar os widgets desenvolvidos para a comunidade en [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Erro no [[{{ns:widget}}:$1|widget "$1"]]',
	'group-widgeteditor' => 'Editores de widgets',
	'group-widgeteditor-member' => '{{GENDER:$1|editor|editora}} de widgets',
	'grouppage-widgeteditor' => '{{ns:project}}:Editores de widgets',
	'right-editwidgets' => 'Crear e editar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] no espazo de nomes <tt>{{ns:widget}}</tt>',
	'group-widgeteditor.css' => '/* O CSS que se coloque aquí afectará soamente aos editores de widgets */',
	'group-widgeteditor.js' => '/* O JS que se coloque aquí afectará soamente aos editores de widgets */',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'widgets-desc' => 'Erlaubt Wikiadministratore Frej-Form-Widgets zum Wiki zuezfiege dur d Bearbeitig vu Syte im {{ns:widget}}-Namensruum.
Vu dr Gmeinschaft aagleiti Widgets chenne unter [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] gfunde wäre.',
	'widgets-error' => 'Fähler im [[{{ns:widget}}:$1|Widget $1]]',
	'group-widgeteditor' => 'Widget-Editore',
	'group-widgeteditor-member' => '{{GENDER:$1|Widget-Bearbeiter|Widget-Bearbeiteri}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Widget-Editore',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Widgets] im <tt>{{ns:widget}}</tt>-Namensruum aalege un bearbeite',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'widgets-desc' => 'מתן האפשרות למנהלי אתר הוויקי להוסיף וידג׳טים הבנויים בצורה חופשית לאתר הוויקי באמצעות עריכת הדפים שבמרחב השם {{ns:widget}}.
ניתן למצוא וידג׳טים שנתרמו על ידי הקהילה ב־[http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => "שגיאה ב[[{{ns:widget}}:$1|ווידג'ט $1]]",
	'group-widgeteditor' => "עורכי וידג'טים",
	'group-widgeteditor-member' => "{{GENDER:$1|עורך|עורכת}} וידג'טים",
	'grouppage-widgeteditor' => "{{ns:project}}:עורכי וידג'טים",
	'right-editwidgets' => 'יצירה ועריכה של [http://www.mediawiki.org/wiki/Extension:Widgets וידג׳טים] במרחב השם <tt>{{ns:widget}}</tt>',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'widgets-desc' => 'Dowola wikijowym administratoram wikijej přez wobdźěłowanje stronow znutřka mjenjoweho ruma {{ns:widget}} swójske miniprogramy přidać.
Wot zhromadźenstwa wutowrjene miniprogramy móžeš na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] namakać.',
	'widgets-error' => 'Zmylk w [[{{ns:widget}}:$1|miniprogramje $1]]',
	'group-widgeteditor' => 'Wobdźěłowarjo miniprogramow',
	'group-widgeteditor-member' => '{{GENDER:$1|Wobdźěłar miniprogramow|Wobdźěłarka miniprogramow}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Wobdźěłowarjo miniprogramow',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Woknowe elementy] w mjenowym rumje <tt>{{ns:widget}}</tt> wutworić a wobdźěłać',
);

/** Hungarian (magyar)
 * @author Dj
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'widgets-desc' => 'Lehetővé teszi a wiki adminisztrátorainak, hogy kötetlen alakú minialkalmazásokat adjanak a wikihez lapok szerkesztésével a(z) {{ns:widget}} névtérben. Közösség által fejlesztett minialkalmazások a [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] oldalon találhatók.',
	'widgets-error' => 'Hiba a(z) [[{{ns:widget}}:$1|$1 minialkalmazásban]]',
	'group-widgeteditor' => 'Minialkalmazás szerkesztői',
	'group-widgeteditor-member' => 'Minialkalmazás-szerkesztő',
	'grouppage-widgeteditor' => '{{ns:project}}:Minialkalmazás-szerkesztők',
	'right-editwidgets' => 'widgetek létrehozása és szerkesztése a <tt>{{ns:widget}}</tt> névtérben',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'widgets-desc' => 'Permitte al administratores del wiki inserer widgets qualcunque in le wiki, per modificar paginas intra le spatio de nomines {{ns:widget}}.
Le widgets contribuite per le communitate se trova a [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Error in [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Modificatores de widgets',
	'group-widgeteditor-member' => '{{GENDER:$1|modificator|modificatrice}} de widgets',
	'grouppage-widgeteditor' => '{{ns:project}}:Modificatores de widgets',
	'right-editwidgets' => 'Crear e modificar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] in le spatio de nomines <tt>{{ns:widget}}</tt>',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Irwangatot
 */
$messages['id'] = array(
	'widgets-desc' => 'Mengijinkan pengurus wiki untuk menambahkan formulir bebas widget ke wiki dengan menyunting halaman di ruang nama {{ns:widget}}.
komunitas kontribusi widgets dapat di temuai pada [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Kesalahan pada [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Penyunting widget',
	'group-widgeteditor-member' => 'Penyunting widget', # Fuzzy
	'grouppage-widgeteditor' => '{{ns:project}}:Penyunting widget',
	'right-editwidgets' => 'Buat dan Sunting halaman [http://www.mediawiki.org/wiki/Extension:Widgets widgets]  di <tt>{{ns:widget}}</tt> ruang nama',
);

/** Italian (italiano)
 * @author Beta16
 * @author Civvì
 * @author Darth Kule
 */
$messages['it'] = array(
	'widgets-desc' => 'Permette agli amministratori del sito di aggiungere widget liberi al sito modificando pagine nel namespace {{ns:widget}}.
Widget creati dalla comunità possono essere trovati su [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Errore nel [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Editori widget',
	'group-widgeteditor-member' => '{{GENDER:$1|Editore widget|Editrice widget|Editore\\trice widget}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Editori widget',
	'right-editwidgets' => 'Crea e modifica [http://www.mediawiki.org/wiki/Extension:Widgets widget] nel namespace <tt>{{ns:widget}}</tt>',
);

/** Japanese (日本語)
 * @author Fryed-peach
 * @author Iwai.masaharu
 * @author Shirayuki
 * @author Whym
 * @author 青子守歌
 */
$messages['ja'] = array(
	'widgets-desc' => '管理者が「{{ns:widget}}」名前空間内のページを編集し、ウィキに自由な形式のウィジェットを追加できるようにする。
コミュニティが提供しているウィジェットは [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] にある',
	'widgets-error' => '[[{{ns:widget}}:$1|ウィジェット $1]] でのエラー',
	'group-widgeteditor' => 'ウィジェット編集者',
	'group-widgeteditor-member' => '{{GENDER:$1|ウィジェット編集者}}',
	'grouppage-widgeteditor' => '{{ns:project}}:ウィジェット編集者',
	'right-editwidgets' => '<tt>{{ns:widget}}</tt>名前空間で[http://www.mediawiki.org/wiki/Extension:Widgets ウィジェット]を作成/編集',
	'group-widgeteditor.css' => '/* ここに記述したCSSはウィジェット編集者のみに影響します */',
	'group-widgeteditor.js' => '/* ここに記述したJSはウィジェット編集者のみに影響します */',
);

/** Korean (한국어)
 * @author 아라
 */
$messages['ko'] = array(
	'widgets-desc' => '위키 관리자는 {{ns:widget}} 이름공간에서 문서를 편집해 자유로운 형태의 위젯을 더할 수 있습니다.
커뮤니티 기여 위젯은 [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]에서 찾을 수 있습니다',
	'widgets-error' => '[[{{ns:widget}}:$1|$1 위젯]] 오류',
	'group-widgeteditor' => '위젯 편집자',
	'group-widgeteditor-member' => '{{GENDER:$1|위젯 편집자}}',
	'grouppage-widgeteditor' => '{{ns:project}}:위젯 편집자',
	'right-editwidgets' => '<tt>{{ns:widget}}</tt> 이름공간에서 [http://www.mediawiki.org/wiki/Extension:Widgets 위젯]을 만들고 편집',
	'group-widgeteditor.css' => '/* 이 CSS 설정은 위젯 편집자에만 적용됩니다 */',
	'group-widgeteditor.js' => '/* 이 자바스크립트 설정은 위젯 편집자에만 적용됩니다 */',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'widgets-desc' => 'Määt et müjjelesch, dat Wiki-Köbeße <i lang="en">Widgets</i> en ene freie Forrem en däm Appachtemang „{{ns:widget}}“ enndraare. 
Divärse Lück han ehr <i lang="en">Widgets</i> op <i lang="en">[http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]</i> öffentlesch jemaat.',
	'widgets-error' => 'Doh es ene Fähler em [[{{ns:widget}}:$1|<i lang="en">Widget</i> $1]]',
	'group-widgeteditor' => 'Schriiver för <i lang="en">Widgets</i>',
	'group-widgeteditor-member' => '{{GENDER:$1|<i lang="en">Widget</i>-Schriiver}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Widget-Schriiver',
	'right-editwidgets' => 'Sigge, alsu <i lang="en">[http://www.mediawiki.org/wiki/Extension:Widgets Widgets]</i>, em Appachemang „{{ns:widget}}“ ändere udder aanlääje',
	'group-widgeteditor.css' => '/* Dat CSS heh aan dä Stell wirrek bloß beim Ändere vun Widgets */',
	'group-widgeteditor.js' => '/* Dat JavaSkrep heh aan dä Stell wirrek bloß beim Ändere vun Widgets */',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'widgets-error' => 'Feeler an [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Widget-Editeuren',
	'group-widgeteditor-member' => '{{GENDER:$1|Widget-Editeur}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Widget Editeuren',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets widgets] am <tt>{{ns:widget}}</tt> Nummraum uleeën an  änneren',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'widgets-desc' => 'Им овозможува на администраторите да додаваат посреднички елементи со уредување на страници во именскиот простор {{ns:widget}}.
Елементи изработени од учесници од заедницата можете да најдете на  [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Грешка во [[{{ns:widget}}:$1|посредничкиот елемент $1]]',
	'group-widgeteditor' => 'Уредници на посреднички елементи',
	'group-widgeteditor-member' => '{{GENDER:$1|уредник на посреднички елементи}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Уредници на посреднички елементи',
	'right-editwidgets' => 'Создавање и уредување на [http://www.mediawiki.org/wiki/Extension:Widgets направи] во именскиот простор <tt>{{ns:widget}}</tt>',
	'group-widgeteditor.css' => '/* Тука поставениот CSS ќе се применува само врз уредниците на посреднички елементи (помагала) */',
	'group-widgeteditor.js' => '/* Тука поставениот JS ќе се применува само врз уредниците на посреднички елементи (помагала) */',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'widgets-desc' => 'Membolehkan pentadbir wiki untuk menambahkan widget berbentuk bebas pada wiki dengan menyunting laman di dalam ruang nama {{ns:widget}}.
Widget sumbangan komuniti boleh didapati di [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Ralat pada [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Penyunting widget',
	'group-widgeteditor-member' => '{{GENDER:$1|Penyunting widget}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Penyunting widget',
	'right-editwidgets' => 'Mencipta dan menyunting [http://www.mediawiki.org/wiki/Extension:Widgets widget] dalam ruang nama <tt>{{ns:widget}}</tt>',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Danmichaelo
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'widgets-desc' => 'Tillater wikiadministratorer å legge til fri-form skjermelement til wikien ved å redigere siden innen {{ns:widget}}-navnerommet.
Fellesskaps-bidratte skjermelement kan finnes på [http://mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Feil i [[{{ns:widget}}:$1|skjermelement $1]]',
	'group-widgeteditor' => 'Bidragsytere for skjermelement',
	'group-widgeteditor-member' => '{{GENDER:$1|Bidragsyter for skjermelement}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Bidragsytere for skjermelement',
	'right-editwidgets' => 'Lag og rediger [http://www.mediawiki.org/wiki/Extension:Widgets skjermelement] i <tt>{{ns:widget}}</tt>-navnerommet',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'widgets-desc' => "Stelt wikibeheerders in staat naar eigen inzicht widgets aan de wiki toe te voegen door het bewerken van pagina's in de naamruimte {{ns:widget}}.
Door de gemeenschap ontwikkelde widgets zijn te vinden op [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Fout in [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Widgetbewerkers',
	'group-widgeteditor-member' => '{{GENDER:$1|widgetbewerker}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Widgetbewerkers',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Widgets] aanmaken en bewerken in de naamruimte <tt>{{ns:widget}}</tt>',
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Harald Khan
 */
$messages['nn'] = array(
	'right-editwidgets' => 'Endra sider i «{{ns:widget}}»-namnerommet', # Fuzzy
);

/** Occitan (occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'widgets-desc' => "Permet als administrators del wiki d'apondre de widgets al wiki en modificant de paginas dins l'espac de noms {{ns:widget}}. Desvolopat a la basa per [http://www.ardorado.com Ardorado.com]", # Fuzzy
	'widgets-error' => 'Error dins lo [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Modificators de widgets',
	'group-widgeteditor-member' => 'modificator de widgets', # Fuzzy
	'grouppage-widgeteditor' => '{{ns:project}}:Modificators de widgets',
	'right-editwidgets' => "Crear e modificar las [http://www.mediawiki.org/wiki/Extension:Widgets widgets] dins l'espaci de noms « {{ns:widget}} »",
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Sp5uhe
 * @author ToSter
 * @author Woytecr
 */
$messages['pl'] = array(
	'widgets-desc' => 'Pozwala administratorom wiki na dodawanie widżetów w dowolnej formie do wiki poprzez edycję stron w przestrzeni nazw {{ns:widget}}.
Widżety stworzone przez społeczność można odnaleźć na stronie [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Błąd w [[{{ns:widget}}:$1|widżecie $1]]',
	'group-widgeteditor' => 'Redaktorzy widżetów',
	'group-widgeteditor-member' => '{{GENDER:$1|Redaktor widżetów|Redaktorka widżetów}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Redaktorzy widżetów',
	'right-editwidgets' => 'Tworzenie i edycja [http://www.mediawiki.org/wiki/Extension:Widgets widżetów] w przestrzeni nazw <tt>{{ns:widget}}</tt>',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'widgets-desc' => "A përmët a j'aministrator dla wiki ëd gionté ëd widget a forma lìbera a la wiki an modificand dle pàgine ant lë spassi nominal {{ns:widget}}.
Dij widget creà da la comunità a peulo esse trovà su [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Eror an [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Editor ëd widget',
	'group-widgeteditor-member' => '{{GENDER:$1|Editor ëd widget}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Editor ëd widget',
	'right-editwidgets' => 'Crea e modìfica [http://www.mediawiki.org/wiki/Extension:Widgets widgets] ant lë spassi nominal <tt>{{ns:widget}}</tt>',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 * @author SandroHc
 */
$messages['pt'] = array(
	'widgets-desc' => "Permite que os administradores da wiki adicionem ''widgets free-form'' à wiki, editando páginas no espaço nominal {{ns:widget}}.
Widgets fornecidos pela comunidade podem ser encontrados na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => "Erro no [[{{ns:widget}}:$1|''widget'' $1]]",
	'group-widgeteditor' => "Editores de ''widgets''",
	'group-widgeteditor-member' => "{{GENDER:$1|editor|editora}} de ''widgets''",
	'grouppage-widgeteditor' => "{{ns:project}}:Editores de ''widgets''",
	'right-editwidgets' => 'Criar e editar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] no espaço nominal <tt>{{ns:widget}}</tt>',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Eduardo.mps
 * @author Giro720
 * @author Helder.wiki
 * @author Heldergeovane
 */
$messages['pt-br'] = array(
	'widgets-desc' => "Permite que os administradores da wiki adicionem ''widgets free-form'' à wiki, editando páginas no espaço nominal {{ns:widget}}.
Widgets fornecidos pela comunidade podem ser encontrados na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Erro em [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Editores de widget',
	'group-widgeteditor-member' => 'Editor de widget', # Fuzzy
	'grouppage-widgeteditor' => '{{ns:project}}:Editores de widget',
	'right-editwidgets' => 'Criar e editar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] no espaço nominal <tt>{{ns:widget}}</tt>',
);

/** Romanian (română)
 * @author Minisarm
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'group-widgeteditor' => 'Editori de widgeturi',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'widgets-error' => "Errore jndr'à [[{{ns:widget}}:$1|widget $1]]",
);

/** Russian (русский)
 * @author G0rn
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'widgets-desc' => 'Позволяет администраторам вики добавлять различные виджеты, посредством редактирования страниц пространства имён {{ns:widget}}. Поддерживаемые сообществом виджеты можно найти на [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Ошибка в [[{{ns:widget}}:$1|виджете $1]]',
	'group-widgeteditor' => 'Редакторы виджетов',
	'group-widgeteditor-member' => 'Редактор виджетов', # Fuzzy
	'grouppage-widgeteditor' => '{{ns:project}}:Редакторы виджетов',
	'right-editwidgets' => 'создавать и редактировать [http://www.mediawiki.org/wiki/Extension:Widgets виджеты] страницы в пространстве имён <tt>{{ns:widget}}</tt>',
);

/** Sinhala (සිංහල)
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'group-widgeteditor' => 'ගැජට්ටු සංස්කාරකවරු',
	'group-widgeteditor-member' => '{{GENDER:$1|ගැජට්ටු සංස්කාරක}}',
	'grouppage-widgeteditor' => '{{ns:project}}:ගැජට්ටු සංස්කාරකවරු',
);

/** Slovak (slovenčina)
 * @author Helix84
 * @author Teslaton
 */
$messages['sk'] = array(
	'widgets-desc' => 'Umožňuje správcom wiki pridávať ovládacie prvky na wiki úpravou stránky v mennom priestore {{ns:widget}}.
Prvky vytvorené komunitou možno nájsť na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Chyba v [[{{ns:widget}}:$1|ovládacom prvku $1]]',
	'group-widgeteditor' => 'Editori ovládacích prvkov',
	'group-widgeteditor-member' => '{{GENDER:$1|Redaktor|Redaktorka}} ovládacích prvkov',
	'grouppage-widgeteditor' => '{{ns:project}}:Editori ovládacích prvkov',
	'right-editwidgets' => 'Tvorba a úprava stránok [http://www.mediawiki.org/wiki/Extension:Widgets ovládacích prvkov] v mennom priestore <tt>{{ns:widget}}</tt>',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 */
$messages['sr-ec'] = array(
	'widgets-desc' => 'Омогућава администраторима да додају елементе на викију уређивањем страница унутар именског простора {{ns:widget}}.
Елементи које је направила заједница могу се наћи на [http://www.mediawikiwidgets.org/Main_Page?setlang=sr-ec MediaWikiWidgets.org]',
	'widgets-error' => 'Грешка у [[{{ns:widget}}:$1|$1 елементу]]',
	'group-widgeteditor' => 'Уредници елемената',
	'group-widgeteditor-member' => '{{GENDER:$1|Уредник елемената|Уредница елемената|Уредник елемената}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Уредници елемената',
	'right-editwidgets' => 'прављење и уређивање [http://www.mediawiki.org/wiki/Extension:Widgets елемената] у именском простору <tt>{{ns:widget}}</tt>',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 */
$messages['sr-el'] = array(
	'widgets-desc' => 'Omogućava administratorima da dodaju vidžete na vikiju uređivanjem stranica unutar {{ns:widget}} imenskog prostora.
Vidžeti napravljeni od strane zajednice mogu se naći na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Greška u [[{{ns:widget}}:$1|$1 vidžetu]]',
	'group-widgeteditor' => 'Urednici elemenata',
	'group-widgeteditor-member' => '{{GENDER:$1|Urednik elemenata|Urednica elemenata|Urednik elemenata}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Urednici elemenata',
	'right-editwidgets' => 'pravljenje i uređivanje [http://www.mediawiki.org/wiki/Extension:Widgets vidžeta] u <tt>{{ns:widget}}</tt> imenskom prostoru',
);

/** Swedish (svenska)
 * @author Martinwiss
 * @author Ozp
 * @author Per
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'widgets-desc' => 'Gör så att administratörer kan lägga till egna manicker (widgets) till wikin genom att skapa sidor i namnrymden {{ns:widget}}. Manicker som andra har skapat finn på [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Fel i [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Widget-redigerare',
	'group-widgeteditor-member' => '{{GENDER:$1|widget-redigerare}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Widget-redigerare',
	'right-editwidgets' => 'Skapa och redigera [http://www.mediawiki.org/wiki/Extension:Widgets widgets] i namnrymden<tt>{{ns:widget}}</tt>',
);

/** Telugu (తెలుగు)
 * @author Ravichandra
 */
$messages['te'] = array(
	'group-widgeteditor' => 'విడ్జెట్ ఎడిటర్లు',
	'group-widgeteditor-member' => 'విడ్జెట్ ఎడిటర్', # Fuzzy
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'widgets-desc' => 'Nagpapahintulot sa mga tagapangasiwa ng wiki na makapagdagdag ng may malayang anyong mga widyet sa wiki sa pamamagitan ng pagbago sa mga pahinang nasa loob ng puwang pampangalan na {{ns:widget}}.
Ang mga widyet na inambag ng pamayan ay matatagpuan sa [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Kamalian sa loob ng [[{{ns:widget}}:$1|widyet na $1]]',
	'group-widgeteditor' => 'Mga patnugot ng widyet',
	'group-widgeteditor-member' => '{{GENDER:$1|patnugot ng widyet}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Mga patnugot ng widyet',
	'right-editwidgets' => 'Lumikha at baguhin ang [http://www.mediawiki.org/wiki/Extension:Widgets mga widyet] sa loob ng puwang na pampangalan ng <tt>{{ns:widget}}</tt>',
	'group-widgeteditor.css' => '/* Ang inilagay na Mga Pilas ng Estilong Lumalagaslas (Cascading Style Sheets o CSS) dito ay makakaapekto lamang sa mga patnugot ng widyet */',
	'group-widgeteditor.js' => '/* Ang JavaScript o JS na inilagay dito ay makakaapekto lamang sa mga patnugot ng widyet */',
);

/** Central Atlas Tamazight (ⵜⴰⵎⴰⵣⵉⵖⵜ)
 * @author Tifinaghes
 */
$messages['tzm'] = array(
	'right-editwidgets' => 'ⴰⵔⴰ ⵏⵖ ⴱⴷⴷⴻⵍ [http://www.mediawiki.org/wiki/Extension:Widgets widgets] ⴷⵉ <tt>{{ns:widget}}</tt> ⴰⵏⵙⴰ ⵏ ⵡⴰⵙⵙⴰⵖ',
);

/** Ukrainian (українська)
 * @author Base
 * @author Prima klasy4na
 * @author Тест
 */
$messages['uk'] = array(
	'widgets-desc' => 'Дозволяє адміністраторам вікі додавати різноманітні віджети шляхом редагування сторінок простору назв {{ns:widget}}.
Підтримувані спільнотою віджети можна знайти на [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Помилка [[{{ns:widget}}:$1|віджету $1]]',
	'group-widgeteditor' => 'Редактори віджетів',
	'group-widgeteditor-member' => '{{GENDER:$1|Редактор віджетів|Редакторка віджетів}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Редактори віджетів',
	'right-editwidgets' => 'Створювати і редагувати [http://www.mediawiki.org/wiki/Extension:Widgets віджети] у просторі назв <tt>{{ns:widget}}</tt>',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'widgets-desc' => 'Cho phép các bảo quản viên wiki thêm công cụ đa năng vào wiki bằng cách sửa đổi trang trong không gian tên {{ns:widget}}.
Có thể lấy thêm công cụ đa năng do cộng đồng đóng góp tại [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Lỗi trong [[{{ns:widget}}:$1|công cụ đa năng $1]]',
	'group-widgeteditor' => 'Người sửa công cụ đa năng',
	'group-widgeteditor-member' => 'người sửa công cụ đa năng',
	'grouppage-widgeteditor' => '{{ns:project}}:Người sửa công cụ đa năng',
	'right-editwidgets' => 'Tạo và sửa [http://www.mediawiki.org/wiki/Extension:Widgets?uselang=vi công cụ đa năng] trong không gian tên <tt>{{ns:widget}}</tt>',
	'group-widgeteditor.css' => '/* Mã CSS tại đây sẽ chỉ ảnh hưởng đến những người sửa công cụ đa năng */',
	'group-widgeteditor.js' => '/* Mã JS tại đây sẽ chỉ ảnh hưởng đến những người sửa công cụ đa năng */',
);

/** Cantonese (粵語)
 */
$messages['yue'] = array(
	'widgets-desc' => '容許wiki管理員響{{ns:widget}}空間名度加入自由形式嘅widget響個wiki度。
原先為[http://www.ardorado.com Ardorado.com]而設計嘅', # Fuzzy
	'widgets-error' => '響[[{{ns:widget}}:$1|widget $1]]出錯',
	'group-widgeteditor' => 'Widget編輯器',
	'group-widgeteditor-member' => 'Widget編輯器', # Fuzzy
	'grouppage-widgeteditor' => '{{ns:project}}:Widget編輯器',
	'right-editwidgets' => '響"{{ns:widget}}"空間名度編輯頁', # Fuzzy
);

/** Simplified Chinese (中文（简体）‎)
 * @author Anakmalaysia
 * @author PhiLiP
 * @author Xiaomingyan
 * @author Yfdyh000
 */
$messages['zh-hans'] = array(
	'widgets-desc' => '允许wiki的管理员编辑{{ns:widget}}名字空间页面以添加各种形式的小工具。您可以在[http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]中找到社区贡献的小工具',
	'widgets-error' => '[[{{ns:widget}}:$1|小工具$1]]出错',
	'group-widgeteditor' => '小工具编辑者',
	'group-widgeteditor-member' => '{{GENDER:$1|小工具编辑者}}',
	'grouppage-widgeteditor' => '{{ns:project}}:小工具编辑者',
	'right-editwidgets' => '在<tt>{{ns:widget}}</tt>名字空间中创建和编辑[http://www.mediawiki.org/wiki/Extension:Widgets 小工具]',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Anakmalaysia
 * @author Mark85296341
 * @author Yfdyh000
 */
$messages['zh-hant'] = array(
	'widgets-desc' => '容許 wiki 管理員通過編輯 {{ns:widget}} 名子空間中加入自由形式的 widget 至 wiki 中。
[http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] 提供社群貢獻的 widget',
	'widgets-error' => '在 [[{{ns:widget}}:$1|widget $1]] 發生錯誤',
	'group-widgeteditor' => 'Widget 編輯者',
	'group-widgeteditor-member' => '{{GENDER:$1|Widget 編輯者}}',
	'grouppage-widgeteditor' => '{{ns:project}}:Widget 編輯者',
	'right-editwidgets' => '建立並編輯 <tt>{{ns:widget}}</tt> 名子空間中的 [http://www.mediawiki.org/wiki/Extension:Widgets Widgets]',
);
