

/* map-view.js */
Exhibit.MapView=function(C,B){Exhibit.MapView._initialize();
this._div=C;
this._uiContext=B;
this._settings={};
this._accessors={getProxy:function(F,E,D){D(F);
},getColorKey:null,getSizeKey:null,getIconKey:null,getIcon:null};
this._colorCoder=null;
this._sizeCoder=null;
this._iconCoder=null;
this._selectListener=null;
this._itemIDToMarker={};
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
};
Exhibit.MapView._settingSpecs={"latlngOrder":{type:"enum",defaultValue:"latlng",choices:["latlng","lnglat"]},"latlngPairSeparator":{type:"text",defaultValue:";"},"center":{type:"float",defaultValue:[20,0],dimensions:2},"zoom":{type:"float",defaultValue:2},"scrollWheelZoom":{type:"boolean",defaultValue:true},"size":{type:"text",defaultValue:"small"},"scaleControl":{type:"boolean",defaultValue:true},"overviewControl":{type:"boolean",defaultValue:false},"type":{type:"enum",defaultValue:"normal",choices:["normal","satellite","hybrid"]},"bubbleTip":{type:"enum",defaultValue:"top",choices:["top","bottom"]},"mapHeight":{type:"int",defaultValue:400},"mapConstructor":{type:"function",defaultValue:null},"color":{type:"text",defaultValue:"#FF9000"},"colorCoder":{type:"text",defaultValue:null},"sizeCoder":{type:"text",defaultValue:null},"iconCoder":{type:"text",defaultValue:null},"selectCoordinator":{type:"text",defaultValue:null},"iconSize":{type:"int",defaultValue:0},"iconFit":{type:"text",defaultValue:"smaller"},"iconScale":{type:"float",defaultValue:1},"iconOffsetX":{type:"float",defaultValue:0},"iconOffsetY":{type:"float",defaultValue:0},"shape":{type:"text",defaultValue:"circle"},"shapeWidth":{type:"int",defaultValue:24},"shapeHeight":{type:"int",defaultValue:24},"shapeAlpha":{type:"float",defaultValue:0.7},"pin":{type:"boolean",defaultValue:true},"pinHeight":{type:"int",defaultValue:6},"pinWidth":{type:"int",defaultValue:6},"borderOpacity":{type:"float",defaultValue:0.5},"borderWidth":{type:"int",defaultValue:1},"borderColor":{type:"text",defaultValue:null},"opacity":{type:"float",defaultValue:0.7},"sizeLegendLabel":{type:"text",defaultValue:null},"colorLegendLabel":{type:"text",defaultValue:null},"iconLegendLabel":{type:"text",defaultValue:null},"markerScale":{type:"text",defaultValue:null},"showHeader":{type:"boolean",defaultValue:true},"showSummary":{type:"boolean",defaultValue:true},"showFooter":{type:"boolean",defaultValue:true},"showToolbox":{type:"boolean",defaultValue:true}};
Exhibit.MapView._accessorSpecs=[{accessorName:"getProxy",attributeName:"proxy"},{accessorName:"getLatlng",alternatives:[{bindings:[{attributeName:"latlng",types:["float","float"],bindingNames:["lat","lng"]},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]},{bindings:[{attributeName:"lat",type:"float",bindingName:"lat"},{attributeName:"lng",type:"float",bindingName:"lng"},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]}]},{accessorName:"getPolygon",attributeName:"polygon",type:"text"},{accessorName:"getPolyline",attributeName:"polyline",type:"text"},{accessorName:"getColorKey",attributeName:"marker",type:"text"},{accessorName:"getColorKey",attributeName:"colorKey",type:"text"},{accessorName:"getSizeKey",attributeName:"sizeKey",type:"text"},{accessorName:"getIconKey",attributeName:"iconKey",type:"text"},{accessorName:"getIcon",attributeName:"icon",type:"url"}];
Exhibit.MapView._initialize=function(){var B=[];
var F=document.documentElement.getElementsByTagName("head");
for(var C=0;
C<F.length;
C++){var E=F[C].getElementsByTagName("link");
for(var A=0;
A<E.length;
A++){var D=E[A];
if(D.rel.match(/\bexhibit\/map-painter\b/)){Exhibit.MapView._markerUrlPrefix=D.href+"?";
}}}Exhibit.MapView._initialize=function(){};
};
Exhibit.MapView.create=function(D,C,B){var A=new Exhibit.MapView(C,Exhibit.UIContext.create(D,B));
Exhibit.MapView._configure(A,D);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.MapView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.MapView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B));
Exhibit.SettingsUtilities.createAccessorsFromDOM(D,Exhibit.MapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.MapView._settingSpecs,A._settings);
Exhibit.MapView._configure(A,E);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.MapView._configure=function(A,C){Exhibit.SettingsUtilities.createAccessors(C,Exhibit.MapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettings(C,Exhibit.MapView._settingSpecs,A._settings);
var B=A._accessors;
A._getLatlng=B.getLatlng!=null?function(F,E,D){B.getProxy(F,E,function(G){B.getLatlng(G,E,D);
});
}:null;
};
Exhibit.MapView.lookupLatLng=function(H,J,A,F,I,B){if(B==undefined){B=4;
}var G=Exhibit.ExpressionParser.parse(J);
var D=[];
H.visit(function(M){var L=G.evaluateSingle({"value":M},{"value":"item"},"value",I).value;
if(L!=null){D.push({item:M,address:L});
}});
var E=[];
var C=new GClientGeocoder();
var K=function(){if(D.length>0){var L=D.shift();
C.getLocations(L.address,function(O){if("Placemark" in O){O.Placemark.sort(function(S,R){return R.AddressDetails.Accuracy-S.AddressDetails.Accuracy;
});
}if("Placemark" in O&&O.Placemark.length>0&&O.Placemark[0].AddressDetails.Accuracy>=B){var P=O.Placemark[0].Point.coordinates;
var Q=P[1];
var N=P[0];
E.push("\t{ id: '"+L.item+"', "+A+": '"+Q+","+N+"' }");
}else{var M=L.address.split(",");
if(M.length==1){E.push("\t{ id: '"+L.item+"' }");
}else{L.address=M.slice(1).join(",").replace(/^\s+/,"");
D.unshift(L);
}}K();
});
}else{F.value=E.join(",\n");
}};
K();
};
Exhibit.MapView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
this._map=null;
if(this._selectListener!=null){this._selectListener.dispose();
this._selectListener=null;
}this._itemIDToMarker={};
if(this._settings.showToolbox){this._toolboxWidget.dispose();
this._toolboxWidget=null;
}this._dom.dispose();
this._dom=null;
this._uiContext.dispose();
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
GUnload();
};
Exhibit.MapView.prototype._internalValidate=function(){var B=this._uiContext.getExhibit();
if(this._accessors.getColorKey!=null){if(this._settings.colorCoder!=null){this._colorCoder=B.getComponent(this._settings.colorCoder);
}if(this._colorCoder==null){this._colorCoder=new Exhibit.DefaultColorCoder(this._uiContext);
}}if(this._accessors.getSizeKey!=null){if(this._settings.sizeCoder!=null){this._sizeCoder=B.getComponent(this._settings.sizeCoder);
if("markerScale" in this._settings){this._sizeCoder._settings.markerScale=this._settings.markerScale;
}}}if(this._accessors.getIconKey!=null){if(this._settings.iconCoder!=null){this._iconCoder=B.getComponent(this._settings.iconCoder);
}}if("selectCoordinator" in this._settings){var C=B.getComponent(this._settings.selectCoordinator);
if(C!=null){var A=this;
this._selectListener=C.addListener(function(D){A._select(D);
});
}}};
Exhibit.MapView.prototype._initializeUI=function(){var B=this;
var C={};
C.colorGradient=(this._colorCoder!=null&&"_gradientPoints" in this._colorCoder);
C.colorMarkerGenerator=this._createColorMarkerGenerator();
C.sizeMarkerGenerator=this._createSizeMarkerGenerator();
C.iconMarkerGenerator=this._createIconMarkerGenerator();
this._div.innerHTML="";
this._dom=Exhibit.ViewUtilities.constructPlottingViewDom(this._div,this._uiContext,this._settings.showSummary&&this._settings.showHeader,{onResize:function(){B._map.checkResize();
}},C);
if(this._settings.showToolbox){this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
}var A=this._dom.plotContainer;
A.style.height=this._settings.mapHeight+"px";
A.className="exhibit-mapView-map";
this._map=this._constructGMap(A);
this._reconstruct();
};
Exhibit.MapView.prototype._constructGMap=function(A){var B=this._settings;
if(B.mapConstructor!=null){return B.mapConstructor(A);
}else{var C=new GMap2(A);
C.setCenter(new GLatLng(B.center[0],B.center[1]),B.zoom);
C.addControl(B.size=="small"?new GSmallMapControl():new GLargeMapControl());
if(B.overviewControl){C.addControl(new GOverviewMapControl);
}if(B.scaleControl){C.addControl(new GScaleControl());
}C.enableDoubleClickZoom();
C.enableContinuousZoom();
if(B.scrollWheelZoom){C.enableScrollWheelZoom();
}C.addControl(new GMapTypeControl());
switch(B.type){case"normal":C.setMapType(G_NORMAL_MAP);
break;
case"satellite":C.setMapType(G_SATELLITE_MAP);
break;
case"hybrid":C.setMapType(G_HYBRID_MAP);
break;
}GEvent.addListener(C,"click",function(){SimileAjax.WindowManager.cancelPopups();
});
return C;
}};
Exhibit.MapView.prototype._createColorMarkerGenerator=function(){var A=this._settings.shape;
return function(B){return SimileAjax.Graphics.createTranslucentImage(Exhibit.MapView._markerUrlPrefix+"?renderer=map-marker&shape="+A+"&width=20&height=20&pinHeight=5&background="+B.substr(1),"middle");
};
};
Exhibit.MapView.prototype._createSizeMarkerGenerator=function(){var A=this._settings.shape;
return function(B){return SimileAjax.Graphics.createTranslucentImage(Exhibit.MapView._markerUrlPrefix+"?renderer=map-marker&shape="+A+"&width="+B+"&height="+B+"&pinHeight=0","middle");
};
};
Exhibit.MapView.prototype._createIconMarkerGenerator=function(){return function(A){elmt=document.createElement("img");
elmt.src=A;
elmt.style.verticalAlign="middle";
elmt.style.height="40px";
return elmt;
};
};
Exhibit.MapView.prototype._reconstruct=function(){this._map.clearOverlays();
this._dom.legendWidget.clear();
this._itemIDToMarker={};
var B=this._uiContext.getCollection().countRestrictedItems();
var A=[];
if(B>0){this._rePlotItems(A);
}this._dom.setUnplottableMessage(B,A);
};
Exhibit.MapView.prototype._rePlotItems=function(J){var I=this;
var Y=this._uiContext.getCollection();
var b=this._uiContext.getDatabase();
var l=this._settings;
var m=this._accessors;
var S=Y.getRestrictedItems();
var c={};
var M=(m.getColorKey!=null);
var Q=(m.getSizeKey!=null);
var D=(m.getIconKey!=null);
var n=(m.getIcon!=null);
var O=(this._getLatlng!=null);
var B=(m.getPolygon!=null);
var P=(m.getPolyline!=null);
var E=l.latlngOrder=="latlng"?function(k,i){return new GLatLng(k,i);
}:function(k,i){return new GLatLng(i,k);
};
S.visit(function(o){var i=[];
var x=[];
var t=[];
if(O){I._getLatlng(o,b,function(p){if(p!=null&&"lat" in p&&"lng" in p){i.push(p);
}});
}if(B){m.getPolygon(o,b,function(p){if(p!=null){x.push(p);
}});
}if(P){m.getPolyline(o,b,function(p){if(p!=null){t.push(p);
}});
}if(i.length>0||x.length>0||t.length>0){var u=I._settings.color;
var y=null;
if(M){y=new Exhibit.Set();
m.getColorKey(o,b,function(p){y.add(p);
});
u=I._colorCoder.translateSet(y,Z);
}if(i.length>0){var s=null;
if(Q){s=new Exhibit.Set();
m.getSizeKey(o,b,function(p){s.add(p);
});
}var w=null;
if(D){w=new Exhibit.Set();
m.getIconKey(o,b,function(p){w.add(p);
});
}for(var r=0;
r<i.length;
r++){var q=i[r];
var z=q.lat+","+q.lng;
if(z in c){var v=c[z];
v.items.push(o);
if(M){v.colorKeys.addSet(y);
}if(Q){v.sizeKeys.addSet(s);
}if(D){v.iconKeys.addSet(w);
}}else{var v={latlng:q,items:[o]};
if(M){v.colorKeys=y;
}if(Q){v.sizeKeys=s;
}if(D){v.iconKeys=w;
}c[z]=v;
}}}for(var k=0;
k<x.length;
k++){I._plotPolygon(o,x[k],u,E);
}for(var k=0;
k<t.length;
k++){I._plotPolyline(o,t[k],u,E);
}}else{J.push(o);
}});
var Z={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var V={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var H={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var W,R=Infinity;
var C=function(p){var i=p.items.length;
if(!W){W=new GLatLngBounds();
}var q=I._settings.shape;
var k=I._settings.color;
if(M){k=I._colorCoder.translateSet(p.colorKeys,Z);
}var r=I._settings.iconSize;
if(Q){r=I._sizeCoder.translateSet(p.sizeKeys,V);
}var s=null;
if(i==1){if(n){m.getIcon(p.items[0],b,function(w){s=w;
});
}}if(D){s=I._iconCoder.translateSet(p.iconKeys,H);
}var s=Exhibit.MapView._makeIcon(q,k,r,i==1?"":i.toString(),s,I._settings);
var u=new GLatLng(p.latlng.lat,p.latlng.lng);
var o=new GMarker(u,s);
if(R>p.latlng.maxAutoZoom){R=p.latlng.maxAutoZoom;
}W.extend(u);
GEvent.addListener(o,"click",function(){o.openInfoWindow(I._createInfoWindow(p.items));
if(I._selectListener!=null){I._selectListener.fire({itemIDs:p.items});
}});
I._map.addOverlay(o);
for(var t=0;
t<p.items.length;
t++){I._itemIDToMarker[p.items[t]]=o;
}};
for(var j in c){C(c[j]);
}if(M){var X=this._dom.legendWidget;
var h=this._colorCoder;
var T=Z.keys.toArray().sort();
if(l.colorLegendLabel!==null){X.addLegendLabel(l.colorLegendLabel,"color");
}if(h._gradientPoints!=null){var L=this._dom.legendWidget;
L.addGradient(this._colorCoder._gradientPoints);
}else{for(var e=0;
e<T.length;
e++){var N=T[e];
var U=h.translate(N);
X.addEntry(U,N);
}}if(Z.others){X.addEntry(h.getOthersColor(),h.getOthersLabel());
}if(Z.mixed){X.addEntry(h.getMixedColor(),h.getMixedLabel());
}if(Z.missing){X.addEntry(h.getMissingColor(),h.getMissingLabel());
}}if(Q){var X=this._dom.legendWidget;
var F=this._sizeCoder;
var T=V.keys.toArray().sort();
if(l.sizeLegendLabel!==null){X.addLegendLabel(l.sizeLegendLabel,"size");
}if(F._gradientPoints!=null){var a=F._gradientPoints;
var g=(a[a.length-1].value-a[0].value)/5;
T=[];
for(var f=0;
f<6;
f++){T.push(Math.floor(a[0].value+g*f));
}for(var e=0;
e<T.length;
e++){var N=T[e];
var G=F.translate(N);
X.addEntry(G,N,"size");
}}else{for(var e=0;
e<T.length;
e++){var N=T[e];
var G=F.translate(N);
X.addEntry(G,N,"size");
}if(V.others){X.addEntry(F.getOthersSize(),F.getOthersLabel(),"size");
}if(V.mixed){X.addEntry(F.getMixedSize(),F.getMixedLabel(),"size");
}if(V.missing){X.addEntry(F.getMissingSize(),F.getMissingLabel(),"size");
}}}if(D){var X=this._dom.legendWidget;
var A=this._iconCoder;
var T=H.keys.toArray().sort();
if(l.iconLegendLabel!=null){X.addLegendLabel(l.iconLegendLabel,"icon");
}for(var e=0;
e<T.length;
e++){var N=T[e];
var K=A.translate(N);
X.addEntry(K,N,"icon");
}if(H.others){X.addEntry(A.getOthersIcon(),A.getOthersLabel(),"icon");
}if(H.mixed){X.addEntry(A.getMixedIcon(),A.getMixedLabel(),"icon");
}if(H.missing){X.addEntry(A.getMissingIcon(),A.getMissingLabel(),"icon");
}}if(W&&typeof l.zoom=="undefined"){var d=Math.max(0,I._map.getBoundsZoomLevel(W)-1);
d=Math.min(d,R,l.maxAutoZoom);
I._map.setZoom(d);
}if(W&&typeof l.center=="undefined"){I._map.setCenter(W.getCenter());
}};
Exhibit.MapView.prototype._plotPolygon=function(E,G,A,F){var D=this._parsePolygonOrPolyline(G,F);
if(D.length>1){var C=this._settings;
var H=C.borderColor!=null?C.borderColor:A;
var B=new GPolygon(D,H,C.borderWidth,C.borderOpacity,A,C.opacity);
return this._addPolygonOrPolyline(E,B);
}return null;
};
Exhibit.MapView.prototype._plotPolyline=function(E,H,B,F){var D=this._parsePolygonOrPolyline(H,F);
if(D.length>1){var C=this._settings;
var G=C.borderColor!=null?C.borderColor:B;
var A=new GPolyline(D,G,C.borderWidth,C.borderOpacity);
return this._addPolygonOrPolyline(E,A);
}return null;
};
Exhibit.MapView.prototype._addPolygonOrPolyline=function(D,C){this._map.addOverlay(C);
var A=this;
var B=function(E){A._map.openInfoWindow(E,A._createInfoWindow([D]));
if(A._selectListener!=null){A._selectListener.fire({itemIDs:[D]});
}};
GEvent.addListener(C,"click",B);
this._itemIDToMarker[D]=C;
return C;
};
Exhibit.MapView.prototype._parsePolygonOrPolyline=function(C,F){var D=[];
var A=C.split(this._settings.latlngPairSeparator);
for(var B=0;
B<A.length;
B++){var E=A[B].split(",");
D.push(F(parseFloat(E[0]),parseFloat(E[1])));
}return D;
};
Exhibit.MapView.prototype._select=function(B){var C=B.itemIDs[0];
var A=this._itemIDToMarker[C];
if(A){A.openInfoWindow(this._createInfoWindow([C]));
}};
Exhibit.MapView.prototype._createInfoWindow=function(A){return Exhibit.ViewUtilities.fillBubbleWithItems(null,A,this._uiContext);
};
Exhibit.MapView._iconData=null;
Exhibit.MapView._markerUrlPrefix="http://service.simile-widgets.org/painter/painter?";
Exhibit.MapView._defaultMarkerShape="circle";
Exhibit.MapView._makeIcon=function(L,G,M,O,K,E){var D=O.length*3;
var I=Math.ceil(E.shapeWidth/2)+D;
var Q=E.shapeHeight;
var B=I*2;
var P=Q;
if(M>0){B=M;
I=Math.ceil(M/2);
P=M;
Q=M;
E.pin=false;
}var N=new GIcon();
var H=["renderer=map-marker","shape="+L,"alpha="+E.shapeAlpha,"width="+B,"height="+Q,"background="+G.substr(1),"label="+O];
var A=["renderer=map-marker-shadow","shape="+L,"width="+B,"height="+Q];
var J=[];
if(K!=null){H.push("icon="+K);
if(E.iconFit!="smaller"){H.push("iconFit="+E.iconFit);
}if(E.iconScale!=1){H.push("iconScale="+E.iconScale);
}if(E.iconOffsetX!=1){H.push("iconX="+E.iconOffsetX);
}if(E.iconOffsetY!=1){H.push("iconY="+E.iconOffsetY);
}}if(E.pin){var F=E.pinHeight;
var C=Math.ceil(E.pinWidth/2);
P+=F;
J.push("pinHeight="+F);
J.push("pinWidth="+(C*2));
N.iconAnchor=new GPoint(I,P);
N.imageMap=[0,0,0,Q,I-C,Q,I,P,I+C,Q,B,Q,B,0];
N.shadowSize=new GSize(B*1.5,P-2);
N.infoWindowAnchor=(E.bubbleTip=="bottom")?new GPoint(I,P):new GPoint(I,0);
}else{J.push("pin=false");
N.iconAnchor=new GPoint(I,Math.ceil(P/2));
N.imageMap=[0,0,0,Q,B,Q,B,0];
N.infoWindowAnchor=new GPoint(I,0);
}N.image=Exhibit.MapView._markerUrlPrefix+H.concat(J).join("&")+"&.png";
if(M==0){N.shadow=Exhibit.MapView._markerUrlPrefix+A.concat(J).join("&")+"&.png";
}N.iconSize=new GSize(B,P);
N.shadowSize=new GSize(B*1.5,P-2);
return N;
};


/* olmap-view.js */
Exhibit.OLMapView=function(C,B){Exhibit.OLMapView._initialize();
this._div=C;
this._uiContext=B;
this._settings={};
this._accessors={getProxy:function(F,E,D){D(F);
},getColorKey:null,getSizeKey:null,getIconKey:null,getIcon:null};
this._colorCoder=null;
this._sizeCoder=null;
this._iconCoder=null;
this._selectListener=null;
this._itemIDToMarker={};
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
};
Exhibit.OLMapView.contexts={};
Exhibit.OLMapView._settingSpecs={"latlngOrder":{type:"enum",defaultValue:"latlng",choices:["latlng","lnglat"]},"latlngPairSeparator":{type:"text",defaultValue:";"},"center":{type:"float",defaultValue:null,dimensions:2},"zoom":{type:"float",defaultValue:null},"scrollWheelZoom":{type:"boolean",defaultValue:true},"scaleControl":{type:"boolean",defaultValue:true},"overviewControl":{type:"boolean",defaultValue:false},"type":{type:"enum",defaultValue:"osm",choices:["osm","wms","gmap","gsat","ghyb","gter","vmap","vsat","vhyb","ymap","ysat","yhyb"]},"bubbleTip":{type:"enum",defaultValue:"top",choices:["top","bottom"]},"mapHeight":{type:"int",defaultValue:400},"mapConstructor":{type:"function",defaultValue:null},"projection":{type:"function",defaultValue:null},"color":{type:"text",defaultValue:"#FF9000"},"colorCoder":{type:"text",defaultValue:null},"sizeCoder":{type:"text",defaultValue:null},"iconCoder":{type:"text",defaultValue:null},"selectCoordinator":{type:"text",defaultValue:null},"iconSize":{type:"int",defaultValue:0},"iconFit":{type:"text",defaultValue:"smaller"},"iconScale":{type:"float",defaultValue:1},"iconOffsetX":{type:"float",defaultValue:0},"iconOffsetY":{type:"float",defaultValue:0},"shape":{type:"text",defaultValue:"circle"},"shapeWidth":{type:"int",defaultValue:24},"shapeHeight":{type:"int",defaultValue:24},"shapeAlpha":{type:"float",defaultValue:0.7},"pin":{type:"boolean",defaultValue:true},"pinHeight":{type:"int",defaultValue:6},"pinWidth":{type:"int",defaultValue:6},"borderOpacity":{type:"float",defaultValue:0.5},"borderWidth":{type:"int",defaultValue:1},"borderColor":{type:"text",defaultValue:null},"opacity":{type:"float",defaultValue:0.7},"sizeLegendLabel":{type:"text",defaultValue:null},"colorLegendLabel":{type:"text",defaultValue:null},"iconLegendLabel":{type:"text",defaultValue:null},"markerScale":{type:"text",defaultValue:null},"showHeader":{type:"boolean",defaultValue:true},"showSummary":{type:"boolean",defaultValue:true},"showFooter":{type:"boolean",defaultValue:true},"showToolbox":{type:"boolean",defaultValue:true},"osmURL":{type:"text",defaultValue:"http://tah.openstreetmap.org/Tiles/tile/${z}/${x}/${y}.png"},"wmsURL":{type:"text",defaultValue:"http://labs.metacarta.com/wms/vmap0"}};
Exhibit.OLMapView._accessorSpecs=[{accessorName:"getProxy",attributeName:"proxy"},{accessorName:"getLatlng",alternatives:[{bindings:[{attributeName:"latlng",types:["float","float"],bindingNames:["lat","lng"]},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]},{bindings:[{attributeName:"lat",type:"float",bindingName:"lat"},{attributeName:"lng",type:"float",bindingName:"lng"},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]}]},{accessorName:"getPolygon",attributeName:"polygon",type:"text"},{accessorName:"getPolyline",attributeName:"polyline",type:"text"},{accessorName:"getColorKey",attributeName:"marker",type:"text"},{accessorName:"getColorKey",attributeName:"colorKey",type:"text"},{accessorName:"getSizeKey",attributeName:"sizeKey",type:"text"},{accessorName:"getIconKey",attributeName:"iconKey",type:"text"},{accessorName:"getIcon",attributeName:"icon",type:"url"}];
Exhibit.OLMapView._initialize=function(){var B=[];
var F=document.documentElement.getElementsByTagName("head");
for(var C=0;
C<F.length;
C++){var E=F[C].getElementsByTagName("link");
for(var A=0;
A<E.length;
A++){var D=E[A];
if(D.rel.match(/\bexhibit\/map-painter\b/)){Exhibit.OLMapView._markerUrlPrefix=D.href+"?";
}}}Exhibit.OLMapView._initialize=function(){};
};
Exhibit.OLMapView.create=function(D,C,B){var A=new Exhibit.OLMapView(C,Exhibit.UIContext.create(D,B));
Exhibit.OLMapView._configure(A,D);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.OLMapView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.OLMapView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B));
Exhibit.SettingsUtilities.createAccessorsFromDOM(D,Exhibit.OLMapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.OLMapView._settingSpecs,A._settings);
Exhibit.OLMapView._configure(A,E);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.OLMapView._configure=function(A,C){Exhibit.SettingsUtilities.createAccessors(C,Exhibit.OLMapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettings(C,Exhibit.OLMapView._settingSpecs,A._settings);
var B=A._accessors;
A._getLatlng=B.getLatlng!=null?function(F,E,D){B.getProxy(F,E,function(G){B.getLatlng(G,E,D);
});
}:null;
};
Exhibit.OLMapView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
this._map.destroy();
this._map=null;
if(this._selectListener!=null){this._selectListener.dispose();
this._selectListener=null;
}this._itemIDToMarker={};
if(this._settings.showToolbox){this._toolboxWidget.dispose();
this._toolboxWidget=null;
}this._dom.dispose();
this._dom=null;
this._uiContext.dispose();
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
};
Exhibit.OLMapView.prototype._internalValidate=function(){var B=this._uiContext.getExhibit();
if(this._accessors.getColorKey!=null){if(this._settings.colorCoder!=null){this._colorCoder=B.getComponent(this._settings.colorCoder);
}if(this._colorCoder==null){this._colorCoder=new Exhibit.DefaultColorCoder(this._uiContext);
}}if(this._accessors.getSizeKey!=null){if(this._settings.sizeCoder!=null){this._sizeCoder=B.getComponent(this._settings.sizeCoder);
if("markerScale" in this._settings){this._sizeCoder._settings.markerScale=this._settings.markerScale;
}}}if(this._accessors.getIconKey!=null){if(this._settings.iconCoder!=null){this._iconCoder=B.getComponent(this._settings.iconCoder);
}}if("selectCoordinator" in this._settings){var C=B.getComponent(this._settings.selectCoordinator);
if(C!=null){var A=this;
this._selectListener=C.addListener(function(D){A._select(D);
});
}}};
Exhibit.OLMapView.prototype._initializeUI=function(){var B=this;
var C={};
C.colorGradient=(this._colorCoder!=null&&"_gradientPoints" in this._colorCoder);
C.colorMarkerGenerator=this._createColorMarkerGenerator();
C.sizeMarkerGenerator=this._createSizeMarkerGenerator();
C.iconMarkerGenerator=this._createIconMarkerGenerator();
this._div.innerHTML="";
this._dom=Exhibit.ViewUtilities.constructPlottingViewDom(this._div,this._uiContext,this._settings.showSummary&&this._settings.showHeader,{onResize:function(){B._map.checkResize();
}},C);
if(this._settings.showToolbox){this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
}var A=this._dom.plotContainer;
A.style.height=this._settings.mapHeight+"px";
A.className="exhibit-mapView-map";
this._map=this._constructMap(A);
this._reconstruct();
};
Exhibit.OLMapView.prototype._constructMap=function(M){var O=this._settings;
if(O.projection!=null){this._projection=O.projection();
}else{this._projection=new OpenLayers.Projection("EPSG:4326");
}if(O.mapConstructor!=null){return O.mapConstructor(M);
}else{var R=new OpenLayers.Map({"div":M,"controls":[],"projection":new OpenLayers.Projection("EPSG:900913"),"displayProjection":this._projection,"units":"m","numZoomLevels":18,"maxResolution":156543.0339,"maxExtent":new OpenLayers.Bounds(-20037508.34,-20037508.34,20037508.34,20037508.34)});
var C=new OpenLayers.Layer.OSM("Street",O.osmURL,{"wrapDateLine":true});
C.setVisibility(false);
var G=new OpenLayers.Layer.WMS("World Map",O.wmsURL,{"layers":"basic"},{"wrapDateLine":true});
G.setVisibility(false);
var P=[C,G];
var H={"osm":C,"wms":G};
if(typeof G_HYBRID_MAP!="undefined"){var D=new OpenLayers.Layer.Google("Street (Google)",{"sphericalMercator":true});
D.setVisibility(false);
var I=new OpenLayers.Layer.Google("Satellite (Google)",{"type":G_SATELLITE_MAP,"sphericalMercator":true});
I.setVisibility(false);
var T=new OpenLayers.Layer.Google("Street (Google)",{"type":G_HYBRID_MAP,"sphericalMercator":true});
T.setVisibility(false);
var F=new OpenLayers.Layer.Google("Terrain (Google)",{"type":G_PHYSICAL_MAP,"sphericalMercator":true});
F.setVisibility(false);
P.push(D,I,T,F);
H["gmap"]=D;
H["gsat"]=I;
H["ghyb"]=T;
H["gter"]=F;
}if(typeof VEMapStyle!="undefined"){var J=new OpenLayers.Layer.VirtualEarth("Street (Virtual Earth)",{"type":VEMapStyle.Road,"sphericalMercator":true});
J.setVisibility(false);
var N=new OpenLayers.Layer.VirtualEarth("Satellite (Virtual Earth)",{"type":VEMapStyle.Aerial,"sphericalMercator":true});
N.setVisibility(false);
var B=new OpenLayers.Layer.VirtualEarth("Street (Virtual Earth)",{"type":VEMapStyle.Hybrid,"sphericalMercator":true});
B.setVisibility(false);
P.push(J,N,B);
H["vmap"]=J;
H["vsat"]=N;
H["vhyb"]=B;
}if(typeof YAHOO_MAP_SAT!="undefined"){var S=new OpenLayers.Layer.Yahoo("Street (Yahoo)",{"sphericalMercator":true});
S.setVisibility(false);
var A=new OpenLayers.Layer.Yahoo("Satellite (Yahoo)",{"type":YAHOO_MAP_SAT,"sphericalMercator":true});
A.setVisibility(false);
var L=new OpenLayers.Layer.Yahoo("Yahoo Hybrid",{"type":YAHOO_MAP_HYB,"sphericalMercator":true});
L.setVisibility(false);
P.push(S,A,L);
H["ymap"]=S;
H["ysat"]=A;
H["yhyb"]=L;
}var E=new OpenLayers.Layer.Vector("Features",{"wrapDateLine":true});
P.push(E);
if(typeof H[O.type]!="undefined"){H[O.type].setVisibility(true);
}else{C.setVisibility(true);
}R.addLayers(P);
H=null;
P=null;
if(O.center!=null&&typeof O.center[0]!="undefined"&&typeof O.center[1]!="undefined"){if(O.zoom!=null){R.setCenter(new OpenLayers.LonLat(O.center[1],O.center[0]).transform(this._projection,R.getProjectionObject()),O.zoom);
}else{R.setCenter(new OpenLayers.LonLat(O.center[1],O.center[0]).transform(this._projection,R.getProjectionObject()));
}}R.addControl(new OpenLayers.Control.PanPanel());
if(O.overviewControl){R.addControl(new OpenLayers.Control.OverviewMap());
}if(O.scaleControl){R.addControl(new OpenLayers.Control.ZoomPanel());
}var K=this;
var Q=new OpenLayers.Control.SelectFeature(E,{onSelect:function(U){K._onFeatureSelect(K,U);
},onUnselect:function(U){K._onFeatureUnselect(K,U);
}});
R.addControl(Q);
Q.activate();
R.addControl(new OpenLayers.Control.Navigation(O.scrollWheelZoom,true,OpenLayers.Handler.MOD_SHIFT,true));
R.addControl(new OpenLayers.Control.LayerSwitcher());
R.events.register("click",null,SimileAjax.WindowManager.cancelPopups);
return R;
}};
Exhibit.OLMapView.prototype._createColorMarkerGenerator=function(){var A=this._settings.shape;
return function(B){return SimileAjax.Graphics.createTranslucentImage(Exhibit.OLMapView._markerUrlPrefix+"?renderer=map-marker&shape="+A+"&width=20&height=20&pinHeight=5&background="+B.substr(1),"middle");
};
};
Exhibit.OLMapView.prototype._createSizeMarkerGenerator=function(){var A=this._settings.shape;
return function(B){return SimileAjax.Graphics.createTranslucentImage(Exhibit.OLMapView._markerUrlPrefix+"?renderer=map-marker&shape="+A+"&width="+B+"&height="+B+"&pinHeight=0","middle");
};
};
Exhibit.OLMapView.prototype._createIconMarkerGenerator=function(){return function(A){elmt=document.createElement("img");
elmt.src=A;
elmt.style.verticalAlign="middle";
elmt.style.height="40px";
return elmt;
};
};
Exhibit.OLMapView.prototype._clearOverlays=function(){var A=this._map.getLayersByClass("OpenLayers.Layer.Vector");
if(A.length==1){A[0].destroyFeatures();
}while(this._map.popups.length>0){this._map.removePopup(this._map.popups[0]);
}};
Exhibit.OLMapView.prototype._reconstruct=function(){this._clearOverlays();
this._dom.legendWidget.clear();
this._itemIDToMarker={};
var B=this._uiContext.getCollection().countRestrictedItems();
var A=[];
if(B>0){this._rePlotItems(A);
}this._dom.setUnplottableMessage(B,A);
};
Exhibit.OLMapView.prototype._rePlotItems=function(J){var I=this;
var Y=this._uiContext.getCollection();
var b=this._uiContext.getDatabase();
var l=this._settings;
var m=this._accessors;
var S=Y.getRestrictedItems();
var c={};
var M=(m.getColorKey!=null);
var Q=(m.getSizeKey!=null);
var D=(m.getIconKey!=null);
var n=(m.getIcon!=null);
var O=(this._getLatlng!=null);
var B=(m.getPolygon!=null);
var P=(m.getPolyline!=null);
var Z={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var V={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var H={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var E=l.latlngOrder=="latlng"?function(k,i){return new OpenLayers.Geometry.Point(i,k);
}:function(k,i){return new OpenLayers.Geometry.Point(k,i);
};
S.visit(function(o){var i=[];
var x=[];
var t=[];
if(O){I._getLatlng(o,b,function(p){if(p!=null&&"lat" in p&&"lng" in p){i.push(p);
}});
}if(B){m.getPolygon(o,b,function(p){if(p!=null){x.push(p);
}});
}if(P){m.getPolyline(o,b,function(p){if(p!=null){t.push(p);
}});
}if(i.length>0||x.length>0||t.length>0){var u=I._settings.color;
var y=null;
if(M){y=new Exhibit.Set();
m.getColorKey(o,b,function(p){y.add(p);
});
u=I._colorCoder.translateSet(y,Z);
}if(i.length>0){var s=null;
if(Q){s=new Exhibit.Set();
m.getSizeKey(o,b,function(p){s.add(p);
});
}var w=null;
if(D){w=new Exhibit.Set();
m.getIconKey(o,b,function(p){w.add(p);
});
}for(var r=0;
r<i.length;
r++){var q=i[r];
var z=q.lat+","+q.lng;
if(z in c){var v=c[z];
v.items.push(o);
if(M){v.colorKeys.addSet(y);
}if(Q){v.sizeKeys.addSet(s);
}if(D){v.iconKeys.addSet(w);
}}else{var v={latlng:q,items:[o]};
if(M){v.colorKeys=y;
}if(Q){v.sizeKeys=s;
}if(D){v.iconKeys=w;
}c[z]=v;
}}}for(var k=0;
k<x.length;
k++){I._plotPolygon(o,x[k],u,E);
}for(var k=0;
k<t.length;
k++){I._plotPolyline(o,t[k],u,E);
}}else{J.push(o);
}});
var W,R=Infinity;
var C=function(q){var i=q.items.length;
if(!W){W=new OpenLayers.Bounds();
}var s=I._settings.shape;
var o=I._settings.color;
if(M){o=I._colorCoder.translateSet(q.colorKeys,Z);
}var t=I._settings.iconSize;
if(Q){t=I._sizeCoder.translateSet(q.sizeKeys,V);
}var u=null;
if(i==1){if(n){m.getIcon(q.items[0],b,function(x){u=x;
});
}}if(D){u=I._iconCoder.translateSet(q.iconKeys,H);
}var u=Exhibit.OLMapView._makeIcon(s,o,t,i==1?"":i.toString(),u,I._settings);
var w=new OpenLayers.Geometry.Point(q.latlng.lng,q.latlng.lat).transform(I._projection,I._map.getProjectionObject());
var r=I._map.getLayersByClass("OpenLayers.Layer.Vector")[0];
var p=new OpenLayers.Feature.Vector(w,{locationData:q},{"externalGraphic":u.url,"graphicWidth":u.size.w,"graphicHeight":u.size.h,"graphicXOffset":u.offset.x,"graphicYOffset":u.offset.y,"fillColor":"white","fillOpacity":1,"strokeWidth":0});
var k=new OpenLayers.Popup.FramedCloud("markerPoup"+Math.floor(Math.random()*10000),new OpenLayers.LonLat(q.latlng.lng,q.latlng.lat).transform(I._projection,I._map.getProjectionObject()),null,I._createInfoWindow(q.items).innerHTML,u,true,function(){SimileAjax.WindowManager.cancelPopups();
I._map.removePopup(this);
});
p.popup=k;
k.feature=p;
r.addFeatures([p]);
if(R>q.latlng.maxAutoZoom){R=q.latlng.maxAutoZoom;
}W.extend(w);
for(var v=0;
v<q.items.length;
v++){I._itemIDToMarker[q.items[v]]=p;
}};
for(var j in c){C(c[j]);
}if(M){var X=this._dom.legendWidget;
var h=this._colorCoder;
var T=Z.keys.toArray().sort();
if(l.colorLegendLabel!==null){X.addLegendLabel(l.colorLegendLabel,"color");
}if(h._gradientPoints!=null){var L=this._dom.legendWidget;
L.addGradient(this._colorCoder._gradientPoints);
}else{for(var e=0;
e<T.length;
e++){var N=T[e];
var U=h.translate(N);
X.addEntry(U,N);
}}if(Z.others){X.addEntry(h.getOthersColor(),h.getOthersLabel());
}if(Z.mixed){X.addEntry(h.getMixedColor(),h.getMixedLabel());
}if(Z.missing){X.addEntry(h.getMissingColor(),h.getMissingLabel());
}}if(Q){var X=this._dom.legendWidget;
var F=this._sizeCoder;
var T=V.keys.toArray().sort();
if(l.sizeLegendLabel!==null){X.addLegendLabel(l.sizeLegendLabel,"size");
}if(F._gradientPoints!=null){var a=F._gradientPoints;
var g=(a[a.length-1].value-a[0].value)/5;
T=[];
for(var f=0;
f<6;
f++){T.push(Math.floor(a[0].value+g*f));
}for(var e=0;
e<T.length;
e++){var N=T[e];
var G=F.translate(N);
X.addEntry(G,N,"size");
}}else{for(var e=0;
e<T.length;
e++){var N=T[e];
var G=F.translate(N);
X.addEntry(G,N,"size");
}if(V.others){X.addEntry(F.getOthersSize(),F.getOthersLabel(),"size");
}if(V.mixed){X.addEntry(F.getMixedSize(),F.getMixedLabel(),"size");
}if(V.missing){X.addEntry(F.getMissingSize(),F.getMissingLabel(),"size");
}}}if(D){var X=this._dom.legendWidget;
var A=this._iconCoder;
var T=H.keys.toArray().sort();
if(l.iconLegendLabel!=null){X.addLegendLabel(l.iconLegendLabel,"icon");
}for(var e=0;
e<T.length;
e++){var N=T[e];
var K=A.translate(N);
X.addEntry(K,N,"icon");
}if(H.others){X.addEntry(A.getOthersIcon(),A.getOthersLabel(),"icon");
}if(H.mixed){X.addEntry(A.getMixedIcon(),A.getMixedLabel(),"icon");
}if(H.missing){X.addEntry(A.getMissingIcon(),A.getMissingLabel(),"icon");
}}if(W&&l.zoom==null){if(R>12){R=12;
}var d=Math.max(0,I._map.getZoomForExtent(W)-1);
d=Math.min(d,R);
I._map.zoomTo(d);
}else{I._map.zoomTo(l.zoom);
}if(W&&l.center==null){I._map.setCenter(W.getCenterLonLat());
}};
Exhibit.OLMapView.prototype._plotPolygon=function(B,C,G,J){var H=this._parsePolygonOrPolyline(C,J);
if(H.length>1){var F=this._settings;
var E=F.borderColor!=null?F.borderColor:G;
var I=new OpenLayers.Geometry.LinearRing(H).transform(this._projection,this._map.getProjectionObject());
var D={"strokeColor":E,"strokeWidth":F.borderWidth,"strokeOpacity":F.borderOpacity,"fillColor":G,"fillOpacity":F.opacity};
var A=new OpenLayers.Feature.Vector(I,null,D);
return this._addPolygonOrPolyline(B,A);
}return null;
};
Exhibit.OLMapView.prototype._plotPolyline=function(A,D,E,I){var G=this._parsePolygonOrPolyline(D,I);
if(G.length>1){var C=this._settings;
var B=C.borderColor!=null?C.borderColor:E;
var H=new OpenLayers.Geometry.LineString(G).transform(this._projection,this._map.getProjectionObject());
var F={"strokeColor":B,"strokeWidth":C.borderWidth,"strokeOpacity":C.borderOpacity};
var J=new OpenLayers.Feature.Vector(H,null,F);
return this._addPolygonOrPolyline(A,J);
}return null;
};
Exhibit.OLMapView.prototype._addPolygonOrPolyline=function(G,F){var E=this._map.getLayersByClass("OpenLayers.Layer.Vector");
if(E.length>0){var C=E[0];
C.addFeatures([F]);
}else{return null;
}var B=this;
var D=F.geometry.getCentroid();
var A=new OpenLayers.Popup.FramedCloud("vectorPopup"+Math.floor(Math.random()*10000),new OpenLayers.LonLat(D.x,D.y),null,B._createInfoWindow([G]).innerHTML,null,true,function(){SimileAjax.WindowManager.cancelPopups();
B._map.removePopup(this);
});
F.popup=A;
A.feature=F;
this._itemIDToMarker[G]=F;
return F;
};
Exhibit.OLMapView.prototype._parsePolygonOrPolyline=function(C,F){var D=[];
var A=C.split(this._settings.latlngPairSeparator);
for(var B=0;
B<A.length;
B++){var E=A[B].split(",");
D.push(F(parseFloat(E[0]),parseFloat(E[1])));
}return D;
};
Exhibit.OLMapView.prototype._onFeatureSelect=function(A,B){A._map.addPopup(B.popup,true);
if(A._selectListener!=null){A._selectListener.fire({itemIDs:B.attributes.locationData.items});
}};
Exhibit.OLMapView.prototype._onFeatureUnselect=function(A,B){SimileAjax.WindowManager.cancelPopups();
A._map.removePopup(B.popup);
};
Exhibit.OLMapView.prototype._select=function(C){var B=this;
var D=C.itemIDs[0];
var A=this._itemIDToMarker[D];
if(A){B._map.addPopup(A.popup,true);
}};
Exhibit.OLMapView.prototype._createInfoWindow=function(D){var C="context"+Math.random()*1000;
var B=this._uiContext;
var E=this._uiContext.getDatabase();
var A=this._uiContext.getLensRegistry();
var F={};
F.getSetting=function(G){return B.getSetting(G);
};
F.getDatabase=function(){return E;
};
F.getLensRegistry=function(){return A;
};
F.isBeingEdited=function(G){return false;
};
F.formatList=function(H,I,J,G){return B.formatList(H,I,J,G);
};
F.format=function(I,J,G){var H=new Exhibit.Formatter._ItemFormatter(F);
H.format=function(L,K){var N=this.formatText(L);
Exhibit.OLMapView.contexts[C]=B;
var M=SimileAjax.DOM.createElementFromString('<a href="'+Exhibit.Persistence.getItemLink(L)+"\" class='exhibit-item' onclick='Exhibit.UI.showItemInPopup(\""+L+'", this, Exhibit.OLMapView.contexts["'+C+"\"]); return false;'>"+N+"</a>");
K(M);
};
H.format(I,G);
};
return Exhibit.ViewUtilities.fillBubbleWithItems(null,D,F);
};
Exhibit.OLMapView._iconData=null;
Exhibit.OLMapView._markerUrlPrefix="http://service.simile-widgets.org/painter/painter?";
Exhibit.OLMapView._defaultMarkerShape="circle";
Exhibit.OLMapView._makeIcon=function(L,F,M,O,K,D){var C=O.length*3;
var I=Math.ceil(D.shapeWidth/2)+C;
var Q=D.shapeHeight;
var A=I*2;
var P=Q;
if(M>0){A=M;
I=Math.ceil(M/2);
P=M;
Q=M;
D.pin=false;
}var N=new Object();
var H=["renderer=map-marker","shape="+L,"alpha="+D.shapeAlpha,"width="+A,"height="+Q,"background="+F.substr(1),"label="+O];
var J=[];
if(K!=null){H.push("icon="+K);
if(D.iconFit!="smaller"){H.push("iconFit="+D.iconFit);
}if(D.iconScale!=1){H.push("iconScale="+D.iconScale);
}if(D.iconOffsetX!=1){H.push("iconX="+D.iconOffsetX);
}if(D.iconOffsetY!=1){H.push("iconY="+D.iconOffsetY);
}}if(D.pin){var E=D.pinHeight;
var B=Math.ceil(D.pinWidth/2);
P+=E;
J.push("pinHeight="+E);
J.push("pinWidth="+(B*2));
N.iconAnchor=new OpenLayers.Pixel(-I,-P);
N.imageMap=[0,0,0,Q,I-B,Q,I,P,I+B,Q,A,Q,A,0];
N.shadowSize=new OpenLayers.Size(A*1.5,P-2);
N.infoWindowAnchor=(D.bubbleTip=="bottom")?new OpenLayers.Pixel(I,P):new OpenLayers.Pixel(I,0);
}else{J.push("pin=false");
N.iconAnchor=new OpenLayers.Pixel(-I,-Math.ceil(P/2));
N.imageMap=[0,0,0,Q,A,Q,A,0];
N.infoWindowAnchor=new OpenLayers.Pixel(I,0);
}N.image=Exhibit.OLMapView._markerUrlPrefix+H.concat(J).join("&")+"&.png";
N.iconSize=new OpenLayers.Size(A,P);
var G=new OpenLayers.Icon(N.image,N.iconSize,N.iconAnchor);
return G;
};


/* vemap-view.js */
Exhibit.VEMapView=function(C,B){this._div=C;
this._uiContext=B;
this._settings={};
this._accessors={getProxy:function(F,E,D){D(F);
},getColorKey:null,getIcon:null};
this._colorCoder=null;
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
};
Exhibit.VEMapView._id=1;
Exhibit.VEMapView._settingSpecs={"center":{type:"float",defaultValue:[20,0],dimensions:2},"zoom":{type:"float",defaultValue:2},"size":{type:"text",defaultValue:"small"},"scaleControl":{type:"boolean",defaultValue:true},"overviewControl":{type:"boolean",defaultValue:false},"type":{type:"enum",defaultValue:"normal",choices:["normal","satellite","hybrid"]},"bubbleTip":{type:"enum",defaultValue:"top",choices:["top","bottom"]},"mapHeight":{type:"int",defaultValue:400},"mapConstructor":{type:"function",defaultValue:null},"color":{type:"text",defaultValue:"#FF9000"},"colorCoder":{type:"text",defaultValue:null},"iconScale":{type:"float",defaultValue:1},"iconOffsetX":{type:"float",defaultValue:0},"iconOffsetY":{type:"float",defaultValue:0},"shape":{type:"text",defaultValue:"circle"},"bodyWidth":{type:"int",defaultValue:24},"bodyHeight":{type:"int",defaultValue:24},"pin":{type:"boolean",defaultValue:true},"pinHeight":{type:"int",defaultValue:6},"pinWidth":{type:"int",defaultValue:6}};
Exhibit.VEMapView._accessorSpecs=[{accessorName:"getProxy",attributeName:"proxy"},{accessorName:"getLatlng",alternatives:[{bindings:[{attributeName:"latlng",types:["float","float"],bindingNames:["lat","lng"]},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]},{bindings:[{attributeName:"lat",type:"float",bindingName:"lat"},{attributeName:"lng",type:"float",bindingName:"lng"},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]}]},{accessorName:"getColorKey",attributeName:"marker",type:"text"},{accessorName:"getColorKey",attributeName:"colorKey",type:"text"},{accessorName:"getIcon",attributeName:"icon",type:"url"}];
Exhibit.VEMapView.create=function(D,C,B){var A=new Exhibit.VEMapView(C,Exhibit.UIContext.create(D,B));
Exhibit.VEMapView._configure(A,D);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.VEMapView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.VEMapView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B));
Exhibit.SettingsUtilities.createAccessorsFromDOM(D,Exhibit.VEMapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.VEMapView._settingSpecs,A._settings);
Exhibit.VEMapView._configure(A,E);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.VEMapView._configure=function(A,C){Exhibit.SettingsUtilities.createAccessors(C,Exhibit.VEMapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettings(C,Exhibit.VEMapView._settingSpecs,A._settings);
var B=A._accessors;
A._getLatlng=function(F,E,D){B.getProxy(F,E,function(G){B.getLatlng(G,E,D);
});
};
};
Exhibit.VEMapView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
this._map=null;
this._toolboxWidget.dispose();
this._toolboxWidget=null;
this._dom.dispose();
this._dom=null;
this._uiContext.dispose();
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
};
Exhibit.VEMapView.prototype._internalValidate=function(){if("getColorKey" in this._accessors){if("colorCoder" in this._settings){this._colorCoder=this._uiContext.getExhibit().getComponent(this._settings.colorCoder);
}if(this._colorCoder==null){this._colorCoder=new Exhibit.DefaultColorCoder(this._uiContext);
}}};
Exhibit.VEMapView.prototype._initializeUI=function(){var B=this;
var C=this._settings;
var D="_gradientPoints" in this._colorCoder?"gradient":{markerGenerator:function(F){var E="square";
return SimileAjax.Graphics.createTranslucentImage(Exhibit.MapView._markerUrlPrefix+"?renderer=map-marker&shape="+Exhibit.MapView._defaultMarkerShape+"&width=20&height=20&pinHeight=0&background="+F.substr(1),"middle");
}};
this._div.innerHTML="";
this._dom=Exhibit.ViewUtilities.constructPlottingViewDom(this._div,this._uiContext,true,{},D);
this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
var A=this._dom.plotContainer;
A.style.height=C.mapHeight+"px";
A.className="exhibit-mapView-map";
A.style.position="relative";
A.id="map-"+Exhibit.VEMapView._id++;
var C=this._settings;
if(C._mapConstructor!=null){this._map=C._mapConstructor(A);
}else{this._map=new VEMap(A.id);
this._map.LoadMap(new VELatLong(C.center[0],C.center[1]),C.zoom);
}this._reconstruct();
};
Exhibit.VEMapView.prototype._reconstruct=function(){var L=this;
var K=this._uiContext.getCollection();
var J=this._uiContext.getDatabase();
var T=this._settings;
var V=this._accessors;
var A=K.countAllItems();
var B=K.countRestrictedItems();
var M=[];
this._map.DeleteAllShapeLayers();
this._dom.legendWidget.clear();
if(B>0){var D=K.getRestrictedItems();
var U={};
var F=(this._accessors.getColorKey!=null);
var N=(this._accessors.getIcon!=null);
D.visit(function(b){var X=[];
L._getLatlng(b,J,function(e){if(e!=null&&"lat" in e&&"lng" in e){X.push(e);
}});
if(X.length>0){var Z=null;
if(F){Z=new Exhibit.Set();
V.getColorKey(b,J,function(e){Z.add(e);
});
}for(var d=0;
d<X.length;
d++){var c=X[d];
var Y=c.lat+","+c.lng;
if(Y in U){var a=U[Y];
a.items.push(b);
if(F){a.colorKeys.addSet(Z);
}}else{var a={latlng:c,items:[b]};
if(F){a.colorKeys=Z;
}U[Y]=a;
}}}else{M.push(b);
}});
var H={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var G,E=Infinity;
var O=function(a){var X=a.items.length;
var c=L._settings.shape;
var Y=L._settings.color;
if(F){Y=L._colorCoder.translateSet(a.colorKeys,H);
}var d=null;
if(X==1){if(N){V.getIcon(a.items[0],J,function(h){d=h;
});
}}var d=Exhibit.VEMapView._makeIcon(c,Y,X==1?"":X.toString(),d,L._settings);
var b=new VEShapeLayer();
var f=new VELatLong(a.latlng.lat,a.latlng.lng);
var Z=new VEShape(VEShapeType.Pushpin,f);
var e=a.items[0];
var g=L._createDescription(a.items);
Z.SetCustomIcon(d);
Z.SetTitle(e);
Z.SetDescription(g);
Z.SetIconAnchor(f);
L._map.AddShapeLayer(b);
b.AddShape(Z);
};
for(var C in U){O(U[C]);
}if(F){var S=this._dom.legendWidget;
var R=this._colorCoder;
var I=H.keys.toArray().sort();
if(this._colorCoder._gradientPoints!=null){S.addGradient(this._colorCoder._gradientPoints);
}else{for(var Q=0;
Q<I.length;
Q++){var W=I[Q];
var P=R.translate(W);
S.addEntry(P,W);
}}if(H.others){S.addEntry(R.getOthersColor(),R.getOthersLabel());
}if(H.mixed){S.addEntry(R.getMixedColor(),R.getMixedLabel());
}if(H.missing){S.addEntry(R.getMissingColor(),R.getMissingLabel());
}}}this._dom.setUnplottableMessage(B,M);
};
Exhibit.VEMapView.prototype._createDescription=function(B){var C=Exhibit.ViewUtilities.fillBubbleWithItems(null,B,this._uiContext);
var A=document.createElement("div");
A.appendChild(C);
return A.innerHTML;
};
Exhibit.VEMapView._iconData=null;
Exhibit.VEMapView._markerUrlPrefix="http://simile.mit.edu/painter/painter?";
Exhibit.VEMapView._defaultMarkerShape="circle";
Exhibit.VEMapView._makeIcon=function(K,F,M,J,D){var C=M.length*3;
var H=Math.ceil(D.bodyWidth/2)+C;
var O=D.bodyHeight;
var A=H*2;
var N=O;
var L=new VECustomIconSpecification;
var G=["renderer=map-marker","shape="+K,"width="+A,"height="+O,"background="+F.substr(1),"label="+M];
var I=[];
if(J!=null){G.push("icon="+J);
if(D.iconScale!=1){G.push("iconScale="+D.iconScale);
}if(D.iconOffsetX!=1){G.push("iconX="+D.iconOffsetX);
}if(D.iconOffsetY!=1){G.push("iconY="+D.iconOffsetY);
}}if(D.pin){var E=D.pinHeight;
var B=Math.ceil(D.pinWidth/4);
N+=E;
I.push("pinHeight="+E);
I.push("pinWidth="+(B*2));
}else{I.push("pin=false");
}L.TextContent=" ";
L.Image=Exhibit.MapView._markerUrlPrefix+G.concat(I).join("&");
L.ImageHeight=N;
L.ImageWidth=A;
return L;
};
