

/* calendar-view.js */
Exhibit.CalendarView=function(C,B){this._div=C;
this._uiContext=B;
this._settings={};
this._accessors={getEventLabel:function(F,E,D){D(E.getObject(F,"label"));
},getProxy:function(F,E,D){D(F);
},getColorKey:null,getIconKey:null};
this._currentDate=new Date();
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
};
Exhibit.CalendarView._settingSpecs={"showToolbox":{type:"boolean",defaultValue:true}};
Exhibit.CalendarView._accessorSpecs=[{accessorName:"getProxy",attributeName:"proxy"},{accessorName:"getDuration",bindings:[{attributeName:"start",type:"date",bindingName:"start"},{attributeName:"end",type:"date",bindingName:"end",optional:true}]},{accessorName:"getColorKey",type:"text"},{accessorName:"getColorKey",attributeName:"colorKey",type:"text"},{accessorName:"getIconKey",attributeName:"iconKey",type:"text"},{accessorName:"getEventLabel",attributeName:"eventLabel",type:"text"},{accessorName:"getHoverText",attributeName:"hoverText",type:"text"}];
Exhibit.CalendarView.create=function(D,C,B){var A=new Exhibit.CalendarView(C,Exhibit.UIContext.create(D,B));
Exhibit.SettingsUtilities.createAccessors(D,Exhibit.CalendarView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettings(D,Exhibit.CalendarView._settingSpecs,A._settings);
Exhibit.CalendarView._configure(A,D);
A._initializeUI();
return A;
};
Exhibit.CalendarView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.CalendarView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B));
Exhibit.SettingsUtilities.createAccessorsFromDOM(D,Exhibit.CalendarView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.CalendarView._settingSpecs,A._settings);
Exhibit.SettingsUtilities.collectSettings(E,Exhibit.CalendarView._settingSpecs,A._settings);
Exhibit.CalendarView._configure(A,E);
A._initializeUI();
return A;
};
Exhibit.CalendarView._configure=function(A,C){Exhibit.SettingsUtilities.createAccessors(C,Exhibit.CalendarView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettings(C,Exhibit.CalendarView._settingSpecs,A._settings);
var B=A._accessors;
A._getDuration=function(F,E,D){B.getProxy(F,E,function(G){B.getDuration(G,E,D);
});
};
};
Exhibit.CalendarView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
this._div.innerHTML="";
if(this._toolboxWidget){this._toolboxWidget.dispose();
this._toolboxWidget=null;
}this._dom=null;
this._div=null;
this._uiContext=null;
};
Exhibit.CalendarView.prototype._initializeUI=function(){var A=this;
var B={elmt:this._div,className:"exhibit-collectionView-header",children:[{tag:"div",field:"collectionSummaryDiv"},{tag:"div",field:"bodyDiv"}]};
this._dom=SimileAjax.DOM.createDOMFromTemplate(B);
this._collectionSummaryWidget=Exhibit.CollectionSummaryWidget.create({},this._dom.collectionSummaryDiv,this._uiContext);
if(this._settings.showToolbox){this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
this._toolboxWidget.getGeneratedHTML=function(){return A._dom.bodyDiv.innerHTML;
};
}this._reconstruct();
};
Exhibit.CalendarView.prototype.browse=function(A){if(A!==undefined){this._currentDate=Exhibit.DateUtil.parseDate(A);
}this._reconstruct();
};
Exhibit.CalendarView.prototype._reconstruct=function(){var C=this._dom.bodyDiv;
C.innerHTML="";
var O=this;
var I=this._uiContext.getCollection();
var L=this._uiContext.getDatabase();
var D=this._settings;
var G=this._accessors;
var M=I.countRestrictedItems();
var N={};
if(M>0){var K=I.getRestrictedItems();
var E=(this._accessors.getColorKey!=null);
var H=(this._accessors.getIconKey!=null&&this._iconCoder!=null);
var J=(this._accessors.getHoverText!=null);
var B={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var A={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var F=function(V,U,Q,S,T){var R;
G.getEventLabel(V,L,function(W){R=W;
return true;
});
var P={itemID:V,start:U.start,end:U.end,label:R,icon:S,color:Q,hoverText:T,getProperty:function(W){return L.getObject(this._itemID,W);
},fillInfoBubble:function(W,X,Y){O._fillInfoBubble(V,W,X,Y);
}};
N[V]=P;
};
K.visit(function(P){var Q=[];
O._getDuration(P,L,function(Y){if("start" in Y){Q.push(Y);
}});
if(Q.length>0){var S=null;
var W=null;
var R=null;
if(E){var X=new Exhibit.Set();
G.getColorKey(P,L,function(Y){X.add(Y);
});
S=O._colorCoder.translateSet(X,B);
}var W=null;
if(H){var V=new Exhibit.Set();
G.getIconKey(P,L,function(Y){V.add(Y);
});
W=O._iconCoder.translateSet(V,A);
}if(J){var T=new Exhibit.Set();
G.getHoverText(P,L,function(Y){T.add(Y);
});
for(var U in T._hash){R=U;
}}for(var U=0;
U<Q.length;
U++){F(P,Q[U],S,W,R);
}}});
}this._div.style.display="none";
this.buildCal(C,N);
this._div.style.display="block";
};
Exhibit.CalendarView.daysInMonth=[31,0,31,30,31,30,31,31,30,31,30,31];
Exhibit.CalendarView.prototype.dateToIndex=function(A){return Exhibit.DateUtil.formatDate(A,"yyyyMMdd");
};
Exhibit.CalendarView.prototype.buildCal=function(F,R){F.className="exhibit-calendar";
var Q=this;
var L=this._currentDate.getFullYear();
var V=this._currentDate.getMonth()+1;
var U=new Date(L,V-1,1);
U.start_dow=U.getDay()+1;
var T=new Date();
var P=(L==T.getFullYear()&&V==T.getMonth()+1)?T.getDate():0;
Exhibit.CalendarView.daysInMonth[1]=(((U.getFullYear()%100!==0)&&(U.getFullYear()%4===0))||(U.getFullYear()%400===0))?29:28;
base=new Date(L,V-1,1);
var b=new Date(base.setDate(base.getDate()-1));
base=new Date(L,V-1,1);
var E=new Date(base.setDate(base.getDate()+Exhibit.CalendarView.daysInMonth[V-1]+1));
var A=document.createElement("table");
A.setAttribute("cellpadding",0);
A.setAttribute("cellspacing",0);
A.className="exhibit-view-month-header";
var H=document.createElement("tbody");
A.appendChild(H);
var Y=document.createElement("tr");
H.appendChild(Y);
var O=document.createElement("td");
O.className="previous-month";
var X=document.createElement("a");
X.innerHTML=Exhibit.DateUtil.MONTH_NAMES[b.getMonth()+12];
X.setAttribute("href","javascript:void");
O.appendChild(X);
Y.appendChild(O);
var I=document.createElement("td");
I.innerHTML=Exhibit.DateUtil.MONTH_NAMES[V-1]+", "+L;
I.className="current-month";
I.setAttribute("allign","center");
I.setAttribute("width","100%");
Y.appendChild(I);
var C=document.createElement("td");
C.className="next-month";
var K=document.createElement("a");
K.innerHTML=Exhibit.DateUtil.MONTH_NAMES[E.getMonth()+12];
K.setAttribute("href","javascript:void");
C.appendChild(K);
Y.appendChild(C);
F.appendChild(A);
SimileAjax.WindowManager.registerEvent(X,"click",function(f,e,g){Q.browse(Exhibit.DateUtil.formatDate(b,"y-MM-dd"));
});
SimileAjax.WindowManager.registerEvent(K,"click",function(f,e,g){Q.browse(Exhibit.DateUtil.formatDate(E,"y-MM-dd"));
});
var Z=document.createElement("table");
Z.setAttribute("cellpadding","0");
Z.setAttribute("cellspacing","0");
Z.className="exhibit-view-month";
var S=document.createElement("tbody");
Z.appendChild(S);
var c=document.createElement("tr");
c.setAttribute("align","center");
S.appendChild(c);
for(s=0;
s<7;
s++){var G=document.createElement("td");
G.innerHTML=Exhibit.DateUtil.DAY_NAMES[s];
G.className="day-header";
G.setAttribute("align","center");
c.appendChild(G);
}var D=function(h){var j={};
for(itemID in h){var g=h[itemID];
if(g.end==null){var k=Q.dateToIndex(g.start);
if(j[k]==undefined){j[k]=[itemID];
}else{j[k].push(itemID);
}}else{var l=new Date(g.start.getFullYear(),g.start.getMonth(),g.start.getDate());
var f=new Date(g.end.getFullYear(),g.start.getMonth(),g.start.getDate());
for(var e=l.valueOf();
e<=f.valueOf();
e+=86400000){var k=Q.dateToIndex(new Date(e));
if(j[k]==undefined){j[k]=[itemID];
}else{j[k].push(itemID);
}}}}return j;
};
var a=D(R);
var B=null;
var M,W,d,J;
for(i=1;
i<=42;
i++){M=i-U.start_dow;
if(M<0){W=Exhibit.CalendarView.daysInMonth[b.getMonth()]+M+1;
d=new Date(b.getFullYear(),b.getMonth(),W);
J="previous-month";
}if((M>=0)&&(M<Exhibit.CalendarView.daysInMonth[V-1])){W=i-U.start_dow+1;
d=new Date(U.getFullYear(),V-1,W);
J=(M==P?"current-month today":"current-month");
}if(M>=Exhibit.CalendarView.daysInMonth[V-1]){W=M-Exhibit.CalendarView.daysInMonth[V-1]+1;
d=new Date(E.getFullYear(),E.getMonth(),W);
J="next-month";
}var N=this.dateToIndex(d);
td=this.buildCell(d,J,R,a[N]);
if(i==1||i%7==1){if(B!==null){S.appendChild(B);
}B=this.buildRow(d);
}B.appendChild(td);
}S.appendChild(B);
F.appendChild(Z);
return F;
};
Exhibit.CalendarView.prototype.buildRow=function(C){try{var B=this;
var A=new Date(C.getFullYear(),C.getMonth(),C.getDate());
A=new Date(A.setDate(A.getDate()+6));
var E=SimileAjax.DOM.createDOMFromString("tr","");
E.elmt.align="center";
return E.elmt;
}catch(D){alert("buildRow: "+D.message);
}};
Exhibit.CalendarView.prototype.buildCell=function(B,N,G,A){try{var M=this;
var D=document.createElement("td");
var H=document.createElement("span");
H.innerHTML=B.getDate();
H.className="calendar-date-title";
D.appendChild(H);
if(A&&A.length){for(var I=0;
I<A.length&&I<4;
I++){var L=G[A[I]];
var K=document.createElement("span");
K.className="event-title";
var J=document.createElement("a");
J.href=Exhibit.Persistence.getItemLink(L.itemID);
J.setAttribute("ex:itemID",L.itemID);
J.innerHTML=L.label;
K.appendChild(J);
D.appendChild(K);
SimileAjax.WindowManager.registerEvent(J,"click",function(P,O,Q){Exhibit.ViewUtilities.openBubbleForItems(P,[P.getAttribute("ex:itemID")],M._uiContext);
});
}if(A.length>4){var C=document.createElement("span");
var E=document.createElement("a");
E.innerHTML="View More +";
E.href="javascript:void";
E.className="view-more";
C.appendChild(E);
SimileAjax.WindowManager.registerEvent(E,"click",function(P,O,Q){Exhibit.ViewUtilities.openBubbleForItems(P,A,M._uiContext);
});
D.appendChild(C);
}}D.className=[N,"day",((B.getDay()===0||B.getDay()==6)?"weekend":"")].join(" ");
return D;
}catch(F){alert("buildCell: "+F.message);
}};


/* date-picker-facet.js */
Exhibit.DatePickerFacet=function(B,A){this._div=B;
this._uiContext=A;
this._beginDate=null;
this._endDate=null;
this._settings={};
this._dom=null;
this._datePicker=null;
this._datePickerTimerLimit=null;
this._datePickerTimer=null;
this._enableDragSelection=null;
this._range={min:null,max:null};
this._dateFormat="y-MM-dd";
};
Exhibit.DatePickerFacet._settingsSpecs={"facetLabel":{type:"text"},"dateFormat":{type:"text"}};
Exhibit.DatePickerFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.DatePickerFacet(B,A);
Exhibit.DatePickerFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.DatePickerFacet.createFromDOM=function(A,D,G){var C=Exhibit.getConfigurationFromDOM(A);
var G=Exhibit.UIContext.createFromDOM(A,G);
var B=new Exhibit.DatePickerFacet((D!==null?D:A),G);
Exhibit.SettingsUtilities.collectSettingsFromDOM(A,Exhibit.DatePickerFacet._settingsSpecs,B._settings);
try{var I=Exhibit.getAttribute(A,"beginDate");
if(I!==null&&I.length>0){B._beginDate=Exhibit.ExpressionParser.parse(I);
}var F=Exhibit.getAttribute(A,"endDate");
if(F!==null&&F.length>0){B._endDate=Exhibit.ExpressionParser.parse(F);
}if(B._endDate===null){B._endDate=B.beginDate;
}var E=Exhibit.getAttribute(A,"timerLimit");
if(E!==null&&E.length>0){B._datePickerTimerLimit=E;
}var J=Exhibit.getAttribute(A,"dragSelection");
if(J!==null&&J.length>0){B._enableDragSelection=(J=="true");
}}catch(H){SimileAjax.Debug.exception(H,"DatePickerFacet: Error processing configuration of date range facet");
}Exhibit.DatePickerFacet._configure(B,C);
B._initializeUI();
G.getCollection().addFacet(B);
return B;
};
Exhibit.DatePickerFacet._configure=function(D,C){Exhibit.SettingsUtilities.collectSettings(C,Exhibit.DatePickerFacet._settingsSpecs,D._settings);
if("expression" in C){D._beginDate=Exhibit.ExpressionParser.parse(C.expression);
}if(!("facetLabel" in D._settings)){D._settings.facetLabel="missing ex:facetLabel";
if(D._beginDate!==null&&D._beginDate.isPath()){var A=D._beginDate.getPath().getLastSegment();
var B=D._uiContext.getDatabase().getProperty(A.property);
if(B!==null){D._settings.facetLabel=A.forward?B.getLabel():B.getReverseLabel();
}}}};
Exhibit.DatePickerFacet.prototype._initializeUI=function(){var A=this;
this._dom=this.constructFacetFrame(this._div,this._settings.facetLabel);
if(this._range.min!==null&&this._range.max!==null){this._dom.range_min.value=this._range.min;
this._dom.range_max.value=this._range.max;
}this._datePicker=Exhibit.DatePickerFacet.DatePicker.create(this._dom.DatePicker,this,new Date());
SimileAjax.WindowManager.registerEvent(this._dom.range_min,"keyup",function(C,B,D){A._onDateFieldChange(C,B);
});
SimileAjax.WindowManager.registerEvent(this._dom.range_max,"keyup",function(C,B,D){A._onDateFieldChange(C,B);
});
};
Exhibit.DatePickerFacet.prototype.constructFacetFrame=function(E,C){var B=this;
var A=["<div class='exhibit-facet-header'>","<div class='exhibit-facet-header-filterControl' id='clearSelectionsDiv' title='",Exhibit.FacetUtilities.l10n.clearSelectionsTooltip,"'>","<span id='filterCountSpan'></span>","<img id='checkImage' />","</div>","<span class='exhibit-facet-header-title'>",C,"</span>","</div>","<div class='exhibit-date-picker' id='DatePicker'></div>","<div class='exhibit-date-picker-text'><input type='text' id='range_min' size='10' style='width:auto;'> - ","<input type='text' id='range_max' size='10' style='width:auto;'></div>"].join("");
var D=SimileAjax.DOM.createDOMFromString(E,A,{checkImage:Exhibit.UI.createTranslucentImage("images/black-check.png")});
D.setSelectionCount=function(G,F){this.filterCountSpan.innerHTML=F;
this.clearSelectionsDiv.style.display=G?"block":"none";
};
SimileAjax.WindowManager.registerEvent(D.clearSelectionsDiv,"click",function(G,F,H){B._clearSelections();
});
return D;
};
Exhibit.DatePickerFacet.prototype.hasRestrictions=function(){return(this._range.min!==null&&this._range.max!==null);
};
Exhibit.DatePickerFacet.prototype.clearAllRestrictions=function(){var A=this._range;
if(this.hasRestrictions){this._range={min:null,max:null};
this._notifyCollection();
}this._dom.range_min.value="";
this._dom.range_max.value="";
this._datePicker.update();
this._dom.setSelectionCount(this.hasRestrictions(),0);
return A;
};
Exhibit.DatePickerFacet.prototype.applyRestrictions=function(A){this.setRange(A);
};
Exhibit.DatePickerFacet.prototype.restrict=function(D){if(!this.hasRestrictions()){this._dom.setSelectionCount(this.hasRestrictions(),0);
return D;
}else{var B=SimileAjax.DateTime.parseIso8601DateTime(this._range.min);
var E=SimileAjax.DateTime.parseIso8601DateTime(this._range.max);
this._dom.setSelectionCount(this.hasRestrictions(),Math.floor((E-B)/(24*60*60*1000)));
var G=this._uiContext.getDatabase();
if(this._beginDate!==null&&this._endDate!==null){var A=this._beginDate;
var H=this._endDate;
var F=new Exhibit.Set();
var C=this._uiContext.getCollection().getAllItems();
SimileAjax.DateTime.incrementByInterval(E,SimileAjax.DateTime.DAY);
C.visit(function(M){var K=false;
var N=A.evaluateOnItem(M,G);
var J=H.evaluateOnItem(M,G);
if(N.size>0){var L=SimileAjax.DateTime.parseIso8601DateTime(N.values.toArray()[0]);
if(L>=B&&L<=E){F.add(M);
K=true;
}}if(J.size>0){var O=SimileAjax.DateTime.parseIso8601DateTime(J.values.toArray()[0]);
if(O>=B&&O<=E&&!K){F.add(M);
K=true;
}}if(L&&O&&!K){if((B>=L&&B<=O)||(E>=L&&E<=O)){F.add(M);
}}});
return F;
}else{var I=this._beginDate.getPath();
var F=new Exhibit.Set();
F.addSet(I.rangeBackward(B,E.setUTCDate(E.getUTCDate()+1),false,D,G).values);
return F;
}}};
Exhibit.DatePickerFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.DatePickerFacet.prototype._clearSelections=function(){this.clearAllRestrictions();
};
Exhibit.DatePickerFacet.prototype.update=function(A){};
Exhibit.DatePickerFacet.prototype._onDateFieldChange=function(D,A){if(this._dom.range_min.value&&Exhibit.DateUtil.parseDate(this._dom.range_min.value)&&this._dom.range_max.value&&Exhibit.DateUtil.parseDate(this._dom.range_max.value)){min_date=Exhibit.DateUtil.parseDate(this._dom.range_min.value);
max_date=Exhibit.DateUtil.parseDate(this._dom.range_max.value);
if(min_date&&max_date){var B=this;
if(max_date<min_date){old_min=this._dom.range_min.value;
this._dom.range_min.value=this._dom.range_max.value;
this._dom.range_max.value=old_min;
}var C={min:this._dom.range_min.value,max:this._dom.range_max.value};
if(C.min!=this._range.min||C.max!=this._range.max){var E=this._range;
SimileAjax.History.addLengthyAction(function(){B.setRange(C);
B._datePicker.update();
},function(){B.setRange(E);
B._datePicker.update();
},"Clear date range search");
}}}};
Exhibit.DatePickerFacet.prototype.setRange=function(A){if(A.min!==null&&A.max!==null){min_date=Exhibit.DateUtil.parseDate(A.min);
max_date=Exhibit.DateUtil.parseDate(A.max);
this._dom.range_min.value=Exhibit.DateUtil.formatDate(min_date,this._dateFormat);
this._dom.range_max.value=Exhibit.DateUtil.formatDate(max_date,this._dateFormat);
}if(A.min!=this._range.min||A.max!=this._range.max){this._range=A;
this._notifyCollection();
}};
Exhibit.DatePickerFacet.prototype.dateInCurrentRange=function(A){if(this._range.min!==null&&this._range.max!==null){min_date=Exhibit.DateUtil.parseDate(this._range.min);
max_date=Exhibit.DateUtil.parseDate(this._range.max);
return(A>=(min_date-24*60*60*1000))&&(A<=max_date);
}else{return false;
}};
Exhibit.DatePickerFacet.prototype.dateRangeInCurrentRange=function(A){return this.dateInCurrentRange(A.min)&&this.dateInCurrentRange(A.max);
};
Exhibit.DatePickerFacet.prototype.changeDate=function(A){this._datePicker.update(Exhibit.DateUtil.parseDate(A));
};
Exhibit.DatePickerFacet.prototype.selectDate=function(B){var A=this;
if(this._datePickerTimer){clearTimeout(this._datePickerTimer);
}if(this._dom.range_min.value.trim()!==""&&this._dom.range_max.value.trim()!==""){this._dom.range_min.value="";
this._dom.range_max.value="";
}if(this._dom.range_min.value.trim()===""&&this._dom.range_max.value.trim()===""){this._datePicker.startHighlighting(B);
if(this._datePickerTimerLimit&&!this._enableDragSelection){this._datePickerTimer=setTimeout(function(){A.selectDate(A._dom.range_min.value);
},this._datePickerTimerLimit);
}}if(this._dom.range_min.value.trim()===""){this._dom.range_min.value=B;
}else{this._dom.range_max.value=B;
this._datePicker.stopHighlighting();
}this._onDateFieldChange();
};
Exhibit.DatePickerFacet.prototype.selectRange=function(B,A){this._dom.range_min.value=B;
this._dom.range_max.value=A;
this._onDateFieldChange();
};
Exhibit.DatePickerFacet.prototype.dateHasItems=function(E){var F=this._uiContext.getDatabase();
var B=F.getAllItems();
var A=new Date(E.getFullYear(),E.getMonth(),E.getDate());
SimileAjax.DateTime.incrementByInterval(A,SimileAjax.DateTime.DAY);
if(this._beginDate!==null&&this._endDate!==null){var D=this._beginDate;
var C=this._endDate;
itemsFound=false;
B.visit(function(J){if(itemsFound){return ;
}var K=D.evaluateOnItem(J,F);
var H=C.evaluateOnItem(J,F);
if(K.size>0){var I=SimileAjax.DateTime.parseIso8601DateTime(K.values.toArray()[0]);
if(I>=E&&I<=A){itemsFound=true;
}}if(H.size>0){var L=SimileAjax.DateTime.parseIso8601DateTime(H.values.toArray()[0]);
if(L>=E&&L<=A&&!itemsFound){itemsFound=true;
}}if(I&&L&&!itemsFound){if((E>=I&&E<=L)||(A>=I&&A<=L)){itemsFound=true;
}}});
return itemsFound;
}else{var G=this._beginDate.getPath();
return G.rangeBackward(E,A,false,B,F).count>0;
}};
Exhibit.DatePickerFacet.prototype.exportFacetSelection=function(){if(this._range.min&&this._range.max){return this._range.min+","+this._range.max;
}};
Exhibit.DatePickerFacet.prototype.importFacetSelection=function(B){var A=B.split(",");
if(A.length>1){this.setRange({min:A[0],max:A[1]});
this._datePicker.update();
}};


/* date-picker.js */
Exhibit.DatePickerFacet.DatePicker=function(C,B,A){this._div=C;
this._facet=B;
this._currentDate=A;
this._highlight=false;
};
Exhibit.DatePickerFacet.DatePicker.create=function(C,B,A){DatePicker=new Exhibit.DatePickerFacet.DatePicker(C,B,A);
DatePicker._div.appendChild(DatePicker.buildCal());
return DatePicker;
};
Exhibit.DatePickerFacet.DatePicker.prototype.update=function(A){if(typeof A=="undefined"){A=this._currentDate;
}while(this._div.hasChildNodes()){this._div.removeChild(this._div.lastChild);
}this._currentDate=A;
this._div.appendChild(DatePicker.buildCal());
};
Exhibit.DatePickerFacet.DatePicker.daysInMonth=[31,0,31,30,31,30,31,31,30,31,30,31];
Exhibit.DatePickerFacet.DatePicker.prototype.buildCal=function(){var L=this._currentDate.getFullYear();
var U=this._currentDate.getMonth()+1;
var Q=this;
var T=new Date(L,U-1,1);
T.start_dow=T.getDay()+1;
var S=new Date();
var P=(L==S.getFullYear()&&U==S.getMonth()+1)?S.getDate():0;
Exhibit.DatePickerFacet.DatePicker.daysInMonth[1]=(((T.getFullYear()%100!==0)&&(T.getFullYear()%4===0))||(T.getFullYear()%400===0))?29:28;
base=new Date(L,U-1,1);
var a=new Date(base.setDate(base.getDate()-1));
base=new Date(L,U-1,1);
var D=new Date(base.setDate(base.getDate()+Exhibit.DatePickerFacet.DatePicker.daysInMonth[U-1]+1));
var E=document.createElement("div");
var A=document.createElement("table");
A.cellpadding=0;
A.cellspacing=0;
A.className="exhibit-month-header";
E.appendChild(A);
var G=document.createElement("tbody");
A.appendChild(G);
var X=document.createElement("tr");
G.appendChild(X);
var O=document.createElement("td");
O.className="previous-month";
var W=document.createElement("a");
W.innerHTML=Exhibit.DateUtil.MONTH_NAMES[a.getMonth()+12];
W.setAttribute("href","javascript:{}");
O.appendChild(W);
X.appendChild(O);
var I=document.createElement("td");
I.innerHTML=Exhibit.DateUtil.MONTH_NAMES[U-1]+", "+L;
I.className="current-month";
I.setAttribute("allign","center");
I.setAttribute("width","100%");
X.appendChild(I);
var C=document.createElement("td");
C.className="next-month";
var M=document.createElement("a");
M.innerHTML=Exhibit.DateUtil.MONTH_NAMES[D.getMonth()+12];
M.setAttribute("href","javascript:{}");
C.appendChild(M);
X.appendChild(C);
var Y=document.createElement("table");
E.appendChild(Y);
var R=document.createElement("tbody");
Y.appendChild(R);
var b=document.createElement("tr");
b.setAttribute("align","center");
R.appendChild(b);
var H=document.createElement("td");
H.setAttribute("align","center");
b.appendChild(H);
var J=document.createElement("tr");
R.appendChild(J);
var Z=document.createElement("td");
Z.innerHTML="&nbsp;";
Z.className="day-header exhibit-week-selector";
J.appendChild(Z);
for(s=0;
s<7;
s++){var F=document.createElement("td");
F.innerHTML="SMTWTFS".substr(s,1);
F.className="day-header";
J.appendChild(F);
}Y.className="exhibit-date-picker";
Y.setAttribute("cellpadding","0");
Y.setAttribute("cellspacing","0");
SimileAjax.WindowManager.registerEvent(W,"click",function(e,d,f){Q._facet.changeDate(Exhibit.DateUtil.formatDate(a,Q._facet._dateFormat));
SimileAjax.DOM.cancelEvent(d);
return false;
},SimileAjax.WindowManager.getBaseLayer());
SimileAjax.WindowManager.registerEvent(M,"click",function(e,d,f){Q._facet.changeDate(Exhibit.DateUtil.formatDate(D,Q._facet._dateFormat));
SimileAjax.DOM.cancelEvent(d);
return false;
},SimileAjax.WindowManager.getBaseLayer());
var B=null;
var N,V,c,K;
for(i=1;
i<=42;
i++){N=i-T.start_dow;
if(N<0){V=Exhibit.DatePickerFacet.DatePicker.daysInMonth[a.getMonth()]+N+1;
c=new Date(a.getFullYear(),a.getMonth(),V);
K="previousMonth";
}if((N>=0)&&(N<Exhibit.DatePickerFacet.DatePicker.daysInMonth[U-1])){V=i-T.start_dow+1;
c=new Date(T.getFullYear(),U-1,V);
K=(N==P?"currentMonth today":"currentMonth");
}if(N>=Exhibit.DatePickerFacet.DatePicker.daysInMonth[U-1]){V=N-Exhibit.DatePickerFacet.DatePicker.daysInMonth[U-1]+1;
c=new Date(D.getFullYear(),D.getMonth(),V);
K="nextMonth";
}td=this.buildCell(c,K);
if(i==1||i%7==1){if(B!==null){R.appendChild(B);
}B=this.buildRow(c);
}B.appendChild(td);
}R.appendChild(B);
return E;
};
Exhibit.DatePickerFacet.DatePicker.prototype.buildRow=function(D){try{var B=this;
var A=new Date(D.getFullYear(),D.getMonth(),D.getDate());
A=new Date(A.setDate(A.getDate()+6));
var F=SimileAjax.DOM.createDOMFromString("tr","");
var C=SimileAjax.DOM.createDOMFromString("td",'<a href="javascript:{}" id="link"><span>></span></a>');
C.elmt.className="exhibit-week-selector";
C.link.className=(this._facet.dateRangeInCurrentRange({min:D,max:A})?"selected":"");
SimileAjax.WindowManager.registerEvent(C.link,"click",function(H,G,I){B._facet.selectRange(Exhibit.DateUtil.formatDate(D,B._facet._dateFormat),Exhibit.DateUtil.formatDate(A,B._facet._dateFormat));
SimileAjax.DOM.cancelEvent(G);
return false;
},SimileAjax.WindowManager.getBaseLayer());
F.elmt.align="center";
F.elmt.appendChild(C.elmt);
return F.elmt;
}catch(E){alert("buildRow: "+E.message);
}};
Exhibit.DatePickerFacet.DatePicker.prototype.buildCell=function(C,A){try{var B=this;
var E=SimileAjax.DOM.createDOMFromString("td",C.getDate());
E.elmt.className=[A,"day",(this._facet.dateInCurrentRange(C)?"selected":""),((C.getDay()===0||C.getDay()==6)?"weekend":""),(this._facet.dateHasItems(C)?"has-items":"")].join(" ");
E.elmt.id=Exhibit.DateUtil.formatDate(C,B._facet._dateFormat).replace(/[^a-zA-Z 0-9]+/g,"");
E.elmt.setAttribute("ex:date",Exhibit.DateUtil.formatDate(C,B._facet._dateFormat));
if(B._facet._enableDragSelection){SimileAjax.WindowManager.registerEvent(E.elmt,"mousedown",function(G,F,H){B._facet.selectDate(Exhibit.DateUtil.formatDate(C,B._facet._dateFormat));
SimileAjax.DOM.cancelEvent(F);
return false;
},SimileAjax.WindowManager.getBaseLayer());
SimileAjax.WindowManager.registerEvent(E.elmt,"mouseup",function(G,F,H){B._facet.selectDate(Exhibit.DateUtil.formatDate(C,B._facet._dateFormat));
SimileAjax.DOM.cancelEvent(F);
return false;
},SimileAjax.WindowManager.getBaseLayer());
}else{SimileAjax.WindowManager.registerEvent(E.elmt,"click",function(G,F,H){B._facet.selectDate(Exhibit.DateUtil.formatDate(C,B._facet._dateFormat));
SimileAjax.DOM.cancelEvent(F);
return false;
},SimileAjax.WindowManager.getBaseLayer());
}SimileAjax.WindowManager.registerEvent(E.elmt,"mouseover",function(G,F,H){B.highlight(G);
SimileAjax.DOM.cancelEvent(F);
return false;
},SimileAjax.WindowManager.getBaseLayer());
return E.elmt;
}catch(D){alert("buildCell: "+D.message);
}};
Exhibit.DatePickerFacet.DatePicker.prototype.highlight=function(A){if(this._highlight){$("td.day").each(function(B){$("#"+this.id).removeClass("highlight");
});
center=Exhibit.DateUtil.parseDate(this._highlight);
end=Exhibit.DateUtil.parseDate(Exhibit.getAttribute(A,"ex:date"));
if(end<center){old_end=end;
end=center;
center=old_end;
}while(center<=end){$("#"+Exhibit.DateUtil.formatDate(center,this._facet._dateFormat).replace(/[^a-zA-Z 0-9]+/g,"")).addClass("highlight");
center.setDate(center.getDate()+1);
}}};
Exhibit.DatePickerFacet.DatePicker.prototype.startHighlighting=function(A){this._highlight=A;
dateObj=Exhibit.DateUtil.parseDate(A);
elmtId=Exhibit.DateUtil.formatDate(dateObj,this._facet._dateFormat).replace(/[^a-zA-Z 0-9]+/g,"");
elmt=$("#"+elmtId).addClass("highlight");
};
Exhibit.DatePickerFacet.DatePicker.prototype.stopHighlighting=function(A){this._highlight=false;
};


/* date-util.js */
Exhibit.DateUtil=new Object();
Exhibit.DateUtil.MONTH_NAMES=new Array("January","February","March","April","May","June","July","August","September","October","November","December","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
Exhibit.DateUtil.DAY_NAMES=new Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sun","Mon","Tue","Wed","Thu","Fri","Sat");
Exhibit.DateUtil.LZ=function(A){return(A<0||A>9?"":"0")+A;
};
Exhibit.DateUtil.isDate=function(C,B){var A=Exhibit.DateUtil.getDateFromFormat(C,B);
if(A==0){return false;
}return true;
};
Exhibit.DateUtil.compareDates=function(E,F,C,D){var B=Exhibit.DateUtil.getDateFromFormat(E,F);
var A=Exhibit.DateUtil.getDateFromFormat(C,D);
if(B==0||A==0){return -1;
}else{if(B>A){return 1;
}}return 0;
};
Exhibit.DateUtil.formatDate=function(f,a){a=a+"";
var J="";
var T=0;
var e="";
var D="";
var I=f.getYear()+"";
var F=f.getMonth()+1;
var b=f.getDate();
var N=f.getDay();
var L=f.getHours();
var V=f.getMinutes();
var P=f.getSeconds();
var R,S,B,Q,g,C,Z,Y,W,O,j,L,i,G,A,X;
var U=new Object();
if(I.length<4){I=""+(I-0+1900);
}U["y"]=""+I;
U["yyyy"]=I;
U["yy"]=I.substring(2,4);
U["M"]=F;
U["MM"]=Exhibit.DateUtil.LZ(F);
U["MMM"]=Exhibit.DateUtil.MONTH_NAMES[F-1];
U["NNN"]=Exhibit.DateUtil.MONTH_NAMES[F+11];
U["d"]=b;
U["dd"]=Exhibit.DateUtil.LZ(b);
U["E"]=Exhibit.DateUtil.DAY_NAMES[N+7];
U["EE"]=Exhibit.DateUtil.DAY_NAMES[N];
U["H"]=L;
U["HH"]=Exhibit.DateUtil.LZ(L);
if(L==0){U["h"]=12;
}else{if(L>12){U["h"]=L-12;
}else{U["h"]=L;
}}U["hh"]=Exhibit.DateUtil.LZ(U["h"]);
if(L>11){U["K"]=L-12;
}else{U["K"]=L;
}U["k"]=L+1;
U["KK"]=Exhibit.DateUtil.LZ(U["K"]);
U["kk"]=Exhibit.DateUtil.LZ(U["k"]);
if(L>11){U["a"]="PM";
}else{U["a"]="AM";
}U["m"]=V;
U["mm"]=Exhibit.DateUtil.LZ(V);
U["s"]=P;
U["ss"]=Exhibit.DateUtil.LZ(P);
while(T<a.length){e=a.charAt(T);
D="";
while((a.charAt(T)==e)&&(T<a.length)){D+=a.charAt(T++);
}if(U[D]!=null){J=J+U[D];
}else{J=J+D;
}}return J;
};
Exhibit.DateUtil._isInteger=function(C){var B="1234567890";
for(var A=0;
A<C.length;
A++){if(B.indexOf(C.charAt(A))==-1){return false;
}}return true;
};
Exhibit.DateUtil._getInt=function(F,D,E,C){for(var A=C;
A>=E;
A--){var B=F.substring(D,D+A);
if(B.length<E){return null;
}if(Exhibit.DateUtil._isInteger(B)){return B;
}}return null;
};
Exhibit.DateUtil.getDateFromFormat=function(U,N){U=U+"";
N=N+"";
var T=0;
var J=0;
var P="";
var E="";
var S="";
var G,F;
var B=new Date();
var H=B.getYear();
var R=B.getMonth()+1;
var Q=1;
var C=B.getHours();
var O=B.getMinutes();
var L=B.getSeconds();
var I="";
while(J<N.length){P=N.charAt(J);
E="";
while((N.charAt(J)==P)&&(J<N.length)){E+=N.charAt(J++);
}if(E=="yyyy"||E=="yy"||E=="y"){if(E=="yyyy"){G=4;
F=4;
}if(E=="yy"){G=2;
F=2;
}if(E=="y"){G=2;
F=4;
}H=Exhibit.DateUtil._getInt(U,T,G,F);
if(H==null){return 0;
}T+=H.length;
if(H.length==2){if(H>70){H=1900+(H-0);
}else{H=2000+(H-0);
}}}else{if(E=="MMM"||E=="NNN"){R=0;
for(var M=0;
M<Exhibit.DateUtil.MONTH_NAMES.length;
M++){var D=Exhibit.DateUtil.MONTH_NAMES[M];
if(U.substring(T,T+D.length).toLowerCase()==D.toLowerCase()){if(E=="MMM"||(E=="NNN"&&M>11)){R=M+1;
if(R>12){R-=12;
}T+=D.length;
break;
}}}if((R<1)||(R>12)){return 0;
}}else{if(E=="EE"||E=="E"){for(var M=0;
M<Exhibit.DateUtil.DAY_NAMES.length;
M++){var K=Exhibit.DateUtil.DAY_NAMES[M];
if(U.substring(T,T+K.length).toLowerCase()==K.toLowerCase()){T+=K.length;
break;
}}}else{if(E=="MM"||E=="M"){R=Exhibit.DateUtil._getInt(U,T,E.length,2);
if(R==null||(R<1)||(R>12)){return 0;
}T+=R.length;
}else{if(E=="dd"||E=="d"){Q=Exhibit.DateUtil._getInt(U,T,E.length,2);
if(Q==null||(Q<1)||(Q>31)){return 0;
}T+=Q.length;
}else{if(E=="hh"||E=="h"){C=Exhibit.DateUtil._getInt(U,T,E.length,2);
if(C==null||(C<1)||(C>12)){return 0;
}T+=C.length;
}else{if(E=="HH"||E=="H"){C=Exhibit.DateUtil._getInt(U,T,E.length,2);
if(C==null||(C<0)||(C>23)){return 0;
}T+=C.length;
}else{if(E=="KK"||E=="K"){C=Exhibit.DateUtil._getInt(U,T,E.length,2);
if(C==null||(C<0)||(C>11)){return 0;
}T+=C.length;
}else{if(E=="kk"||E=="k"){C=Exhibit.DateUtil._getInt(U,T,E.length,2);
if(C==null||(C<1)||(C>24)){return 0;
}T+=C.length;
C--;
}else{if(E=="mm"||E=="m"){O=Exhibit.DateUtil._getInt(U,T,E.length,2);
if(O==null||(O<0)||(O>59)){return 0;
}T+=O.length;
}else{if(E=="ss"||E=="s"){L=Exhibit.DateUtil._getInt(U,T,E.length,2);
if(L==null||(L<0)||(L>59)){return 0;
}T+=L.length;
}else{if(E=="a"){if(U.substring(T,T+2).toLowerCase()=="am"){I="AM";
}else{if(U.substring(T,T+2).toLowerCase()=="pm"){I="PM";
}else{return 0;
}}T+=2;
}else{if(U.substring(T,T+E.length)!=E){return 0;
}else{T+=E.length;
}}}}}}}}}}}}}}if(T!=U.length){return 0;
}if(R==2){if(((H%4==0)&&(H%100!=0))||(H%400==0)){if(Q>29){return 0;
}}else{if(Q>28){return 0;
}}}if((R==4)||(R==6)||(R==9)||(R==11)){if(Q>30){return 0;
}}if(C<12&&I=="PM"){C=C-0+12;
}else{if(C>11&&I=="AM"){C-=12;
}}var A=new Date(H,R-1,Q,C,O,L);
return A.getTime();
};
Exhibit.DateUtil.parseDate=function(G){var E=(arguments.length==2)?arguments[1]:false;
generalFormats=new Array("y-M-d","MMM d, y","MMM d,y","y-MMM-d","d-MMM-y","MMM d");
monthFirst=new Array("M/d/y","M-d-y","M.d.y","MMM-d","M/d","M-d");
dateFirst=new Array("d/M/y","d-M-y","d.M.y","d-MMM","d/M","d-M");
var B=new Array("generalFormats",E?"dateFirst":"monthFirst",E?"monthFirst":"dateFirst");
var F=null;
for(var D=0;
D<B.length;
D++){var A=window[B[D]];
for(var C=0;
C<A.length;
C++){F=Exhibit.DateUtil.getDateFromFormat(G,A[C]);
if(F!=0){return new Date(F);
}}}return null;
};
