<?php
/**
 * File holding the SFCategoryInput class
 *
 * @file
 * @ingroup SF
 */

/**
 * The SFCategoryInput class.
 *
 * @ingroup SFFormInput
 */
class SFCategoryInput extends SFFormInput {
	public static function getName() {
		return 'category';
	}

	public static function getOtherPropTypesHandled() {
		return array( '_wpg' );
	}

	public static function getHTMLForDropdown( $tree, $input_name, $cur_value ) {
		global $sfgTabIndex;

		// @HACK! Go through the HTML generated by the CategoryTree
		// extension, getting the category names and the "indicators"
		// of depth within the HTML, use that to figure out the depth
		// of each category, and then make a dropdown with that
		// information.
		$locations = array();
		$pos = 0;
$i = 0;
		while ( ( $pos = strpos( $tree, 'CategoryTreeChildren', $pos + 1 ) ) != false ) {
			$locations[$pos] = '+';
		}
		$pos = 0;
		while ( ( $pos = strpos( $tree, '</div></div>', $pos + 1 ) ) !== false ) {
			$locations[$pos] = '-';
		}
		$matches = array();
		$pos = 0;
		while ( ( $num_matches = preg_match( '/href=".*"\>([^<]*)/', $tree, $matches, 0, $pos + 1 ) ) > 0 ) {
			$pos = strpos( $tree, $matches[0] );
			$locations[$pos] = $matches[1];
		}
		ksort( $locations );
		$depthPerCategory = array();
		$depth = 0;
		// Hopefully there aren't any categories named "+" or "-"!
		foreach( $locations as $string ) {
			if ( $string == '+' ) {
				$depth++;
			} elseif ( $string == '-' ) {
				$depth--;
			} else {
				$depthPerCategory[$string] = $depth;
			}
		}
		$text = "<select tabindex=\"$sfgTabIndex\" name=\"$input_name\">\n";
		$text .= "<option></option>\n";
		foreach ( $depthPerCategory as $categoryName => $depth ) {
			$text .= "<option value=\"$categoryName\"";
			if ( $categoryName == $cur_value ) {
				$text .= " selected";
			}
			$text .= ">";
			for ( $i = 0; $i < $depth; $i++ ) {
				$text .= "&nbsp;&nbsp;&nbsp;";
			}
			$text .= "$categoryName</option>\n";
		}
		$text .= "</select>\n";
		return $text;
	}

	public static function getHTML( $cur_value, $input_name, $is_mandatory, $is_disabled, $other_args ) {
		// escape if CategoryTree extension isn't included
		if ( !function_exists( 'efCategoryTreeParserHook' ) ) {
			return null;
		}

		global $sfgTabIndex;

		if ( array_key_exists( 'top category', $other_args ) ) {
			$top_category = $other_args['top category'];
		} else {
			// escape - we can't do anything
			return null;
		}
		$hideroot = array_key_exists( 'hideroot', $other_args );
		if ( array_key_exists( 'depth', $other_args ) ) {
			$depth = $other_args['depth'];
		} else {
			$depth = '10';
		}
		if ( array_key_exists( 'height', $other_args ) ) {
			$height = $other_args['height'];
		} else {
			$height = '100';
		}
		if ( array_key_exists( 'width', $other_args ) ) {
			$width = $other_args['width'];
		} else {
			$width = '500';
		}

		$text = '<div style="overflow: auto; padding: 5px; border: 1px #aaaaaa solid; max-height: ' . $height . 'px; width: ' . $width . 'px;">';

		// Start with an initial "None" value, unless this is a
		// mandatory field and there's a current value in place
		// (either through a default value or because we're editing
		// an existing page)
		if ( !$is_mandatory || $cur_value === '' ) {
			$text .= '	<input type="radio" tabindex="' . $sfgTabIndex . '" name="' . $input_name . '" value=""';
			if ( !$cur_value ) {
				$text .= ' checked="checked"';
			}
			$disabled_text = ( $is_disabled ) ? 'disabled' : '';
			$text .= " $disabled_text/> <em>" . wfMessage( 'sf_formedit_none' )->escaped() . "</em>\n";
		}

		global $wgCategoryTreeMaxDepth;
		$wgCategoryTreeMaxDepth = 10;
		$tree = efCategoryTreeParserHook( $top_category,
			array(
				'mode' => 'categories',
				'namespaces' => array( NS_CATEGORY ),
				'depth' => $depth,
				'hideroot' => $hideroot,
			)
		);

		// Capitalize the first letter, if first letters always get
		// capitalized.
		global $wgCapitalLinks;
		if ( $wgCapitalLinks ) {
			global $wgContLang;
			$cur_value = $wgContLang->ucfirst( $cur_value );
		}

		if ( array_key_exists( 'use dropdown', $other_args ) ) {
			return self::getHTMLForDropdown( $tree, $input_name, $cur_value );
		}

		$tree = preg_replace(
			'/(<a class="CategoryTreeLabel.*>)(.*)(<\/a>)/',
			'<input tabindex="' . $sfgTabIndex . '" name="' . $input_name .
				'" value="$2" type="radio"> $1$2$3',
			$tree
		);
		$tree = str_replace( "value=\"$cur_value\"", "value=\"$cur_value\" checked=\"checked\"", $tree );
		// if it's disabled, set all to disabled
		if ( $is_disabled ) {
			$tree = str_replace( 'type="radio"', 'type="radio" disabled', $tree );
		}

		// Get rid of all the 'no subcategories' messages.
		$tree = str_replace(
			'<div class="CategoryTreeChildren" style="display:block"><i class="CategoryTreeNotice">' .
				wfMessage( 'categorytree-no-subcategories' )->escaped() . '</i></div>',
			'',
			$tree
		);

		$text .= $tree . '</div>';

		$spanClass = 'radioButtonSpan';
		if ( $is_mandatory ) {
			$spanClass .= ' mandatoryFieldSpan';
		}
		$text = Html::rawElement( 'span', array( 'class' => $spanClass ), $text );

		return $text;
	}

	public static function getParameters() {
		$params = parent::getParameters();
		$params[] = array(
			'name' => 'top category',
			'type' => 'string',
			'description' => wfMessage( 'sf_forminputs_topcategory' )->text()
		);
		$params[] = array(
			'name' => 'hideroot',
			'type' => 'boolean',
			'description' => wfMessage( 'sf_forminputs_hideroot' )->text()
		);
		$params[] = array(
			'name' => 'depth',
			'type' => 'int',
			'description' => wfMessage( 'sf_forminputs_depth' )->text()
		);
		$params[] = array(
			'name' => 'height',
			'type' => 'int',
			'description' => wfMessage( 'sf_forminputs_height' )->text()
		);
		$params[] = array(
			'name' => 'width',
			'type' => 'int',
			'description' => wfMessage( 'sf_forminputs_width' )->text()
		);
		return $params;
	}

	/**
	 * Returns the HTML code to be included in the output page for this input.
	 */
	public function getHtmlText() {
		return self::getHTML(
			$this->mCurrentValue,
			$this->mInputName,
			$this->mIsMandatory,
			$this->mIsDisabled,
			$this->mOtherArgs
		);
	}
}
