<?php

/**
 * Magic words
 * 
 * @file
 * @ingroup Extensions
 * @ingroup SMWLanguage
 */

$magicWords = array();

/** English (English) */
$magicWords['en'] = array(
	'ask' => array( 0, 'ask' ),
	'show' => array( 0, 'show' ),
	'info' => array( 0, 'info' ),
	'concept' => array( 0, 'concept' ),
	'subobject' => array( 0, 'subobject' ),
	'smwdoc' => array( 0, 'smwdoc' ),
	'set' => array( 0, 'set' ),
	'set_recurring_event' => array( 0, 'set_recurring_event' ),
	'declare' => array( 0, 'declare' ),
	'SMW_NOFACTBOX' => array( 0, '__NOFACTBOX__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__SHOWFACTBOX__' ),
);

/** Afrikaans (Afrikaans) */
$magicWords['af'] = array(
	'ask' => array( 0, 'vra', 'ask' ),
	'show' => array( 0, 'wys', 'show' ),
	'concept' => array( 0, 'konsep', 'concept' ),
	'set' => array( 0, 'stel', 'set' ),
	'declare' => array( 0, 'verklaar', 'declare' ),
);

/** Arabic (العربية) */
$magicWords['ar'] = array(
	'ask' => array( 0, 'سؤال' ),
	'show' => array( 0, 'عرض' ),
	'info' => array( 0, 'معلومات' ),
	'concept' => array( 0, 'مبدأ' ),
	'subobject' => array( 0, 'كائن_فرعي' ),
	'smwdoc' => array( 0, 'توثيق_سمو' ),
	'set' => array( 0, 'مجموعة' ),
	'set_recurring_event' => array( 0, 'ضبط_حدث_متكرر' ),
	'declare' => array( 0, 'إعلان' ),
	'SMW_NOFACTBOX' => array( 0, '__لا_صندوق_حقيقة__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__عرض_صندوق_الحقيقة__' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$magicWords['arz'] = array(
	'ask' => array( 0, 'سؤال', 'ask' ),
	'show' => array( 0, 'عرض', 'show' ),
	'info' => array( 0, 'معلومات', 'info' ),
	'concept' => array( 0, 'مبدأ', 'concept' ),
	'set' => array( 0, 'مجموعة', 'set' ),
	'set_recurring_event' => array( 0, 'ضبط_حدث_جاري', 'set_recurring_event' ),
	'declare' => array( 0, 'إعلان', 'declare' ),
	'SMW_NOFACTBOX' => array( 0, '__لا_صندوق_حقيقة__', '__NOFACTBOX__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__عرض_صندوق_الحقيقة__', '__SHOWFACTBOX__' ),
);

/** Assamese (অসমীয়া) */
$magicWords['as'] = array(
	'ask' => array( 0, 'সোধক' ),
	'show' => array( 0, 'দেখুৱাওক' ),
	'info' => array( 0, 'তথ্য' ),
);

/** Breton (brezhoneg) */
$magicWords['br'] = array(
	'ask' => array( 0, 'goulenn' ),
	'show' => array( 0, 'diskouez' ),
	'info' => array( 0, 'keloù' ),
	'concept' => array( 0, 'meizad' ),
	'declare' => array( 0, 'disklêriañ' ),
);

/** German (Deutsch) */
$magicWords['de'] = array(
	'ask' => array( 0, 'frage' ),
	'show' => array( 0, 'zeige' ),
	'info' => array( 0, 'informiere' ),
	'concept' => array( 0, 'konzept' ),
	'subobject' => array( 0, 'unterobjekt' ),
	'smwdoc' => array( 0, 'smwdok' ),
	'set' => array( 0, 'setze' ),
	'set_recurring_event' => array( 0, 'setze_wiederholung' ),
	'declare' => array( 0, 'deklariere' ),
	'SMW_NOFACTBOX' => array( 0, '__KEINE_FAKTENANZEIGE__', '__KEINEFAKTENANZEIGE__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__FAKTENANZEIGE__' ),
);

/** Zazaki (Zazaki) */
$magicWords['diq'] = array(
	'ask' => array( 0, 'perske' ),
	'show' => array( 0, 'bımocne' ),
	'info' => array( 0, 'zanışe' ),
	'concept' => array( 0, 'konsept' ),
	'subobject' => array( 0, 'bınobce' ),
	'set' => array( 0, 'saz' ),
	'declare' => array( 0, 'ilaniye' ),
	'SMW_NOFACTBOX' => array( 0, '__DORARAŞTAYÇINİYA__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__DORARAŞTAYBIMOCNE__' ),
);

/** Spanish (español) */
$magicWords['es'] = array(
	'ask' => array( 0, 'preguntar', 'pregunta' ),
	'show' => array( 0, 'muestra', 'mostrar' ),
	'info' => array( 0, 'informacion', 'información' ),
	'concept' => array( 0, 'concepto' ),
	'set' => array( 0, 'establecer', 'determinar' ),
	'set_recurring_event' => array( 0, 'establecer_evento_recurrente', 'determinar_evento_recurrente' ),
	'declare' => array( 0, 'declarar', 'declara' ),
);

/** Indonesian (Bahasa Indonesia) */
$magicWords['id'] = array(
	'ask' => array( 0, 'tanya' ),
	'show' => array( 0, 'tampilkan' ),
	'info' => array( 0, 'info' ),
	'concept' => array( 0, 'konsep' ),
	'set' => array( 0, 'tetapkan' ),
	'declare' => array( 0, 'deklarasi' ),
);

/** Igbo (Igbo) */
$magicWords['ig'] = array(
	'ask' => array( 0, 'jüo', 'ask' ),
);

/** Georgian (ქართული) */
$magicWords['ka'] = array(
	'ask' => array( 0, 'კითხვა' ),
	'show' => array( 0, 'ჩვენება' ),
	'info' => array( 0, 'ინფო' ),
);

/** Korean (한국어) */
$magicWords['ko'] = array(
	'ask' => array( 0, '묻기' ),
	'show' => array( 0, '보이기' ),
	'info' => array( 0, '정보' ),
	'concept' => array( 0, '생각' ),
	'subobject' => array( 0, '하위객체' ),
	'smwdoc' => array( 0, 'smw문서' ),
	'set' => array( 0, '설정' ),
	'set_recurring_event' => array( 0, '반복_일정_설정' ),
	'declare' => array( 0, '선언' ),
	'SMW_NOFACTBOX' => array( 0, '__사실상자숨김__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__사실상자보이기__', '__사실상자표시__' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$magicWords['lb'] = array(
	'ask' => array( 0, 'froen' ),
	'show' => array( 0, 'weisen' ),
);

/** Macedonian (македонски) */
$magicWords['mk'] = array(
	'ask' => array( 0, 'прашај' ),
	'show' => array( 0, 'прикажи' ),
	'info' => array( 0, 'инфо' ),
	'concept' => array( 0, 'поим' ),
	'set' => array( 0, 'постави' ),
	'set_recurring_event' => array( 0, 'постави_повторлив_настан' ),
	'declare' => array( 0, 'изјави' ),
	'SMW_NOFACTBOX' => array( 0, '__БЕЗФАКТКУТИЈА__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__ПРИКАЖИФАКТКУТИЈА__' ),
);

/** Malayalam (മലയാളം) */
$magicWords['ml'] = array(
	'ask' => array( 0, 'ചോദിക്കുക' ),
	'show' => array( 0, 'പ്രദർശിപ്പിക്കുക' ),
	'info' => array( 0, 'വിവരം' ),
	'concept' => array( 0, 'ആശയം' ),
	'set' => array( 0, 'ഗണം' ),
	'declare' => array( 0, 'പ്രഖ്യാപിക്കുക' ),
);

/** Marathi (मराठी) */
$magicWords['mr'] = array(
	'ask' => array( 0, 'विचारा', 'ask' ),
	'show' => array( 0, 'दाखवा', 'show' ),
	'info' => array( 0, 'माहिती', 'info' ),
	'concept' => array( 0, 'कंसेप्ट', 'कल्पना', 'concept' ),
	'set' => array( 0, 'प्रयुक्त', 'सेट', 'स्थापित', 'set' ),
	'set_recurring_event' => array( 0, 'प्रयुक्त_पुर्न_कार्य', 'set_recurring_event' ),
	'declare' => array( 0, 'प्रकटकरा', 'declare' ),
	'SMW_NOFACTBOX' => array( 0, '__फॅक्टबॉक्सनाही__', '__NOFACTBOX__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__फॅक्टबॉक्सदाखवा__', '__SHOWFACTBOX__' ),
);

/** Nedersaksies (Nedersaksies) */
$magicWords['nds-nl'] = array(
	'concept' => array( 0, 'konsept' ),
	'set_recurring_event' => array( 0, 'herhaolende_gebeurtenisse_instellen', 'herhalende_gebeurtenis_instellen' ),
	'declare' => array( 0, 'deklareren' ),
	'SMW_NOFACTBOX' => array( 0, '__GIENFEITENKAODER__', '__GEENFEITENKADER__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__FEITENKAODERWEERGEVEN__', '__FEITENKADERWEERGEVEN__' ),
);

/** Dutch (Nederlands) */
$magicWords['nl'] = array(
	'ask' => array( 0, 'vragen' ),
	'show' => array( 0, 'weergeven' ),
	'subobject' => array( 0, 'onderobject' ),
	'set' => array( 0, 'instellen' ),
	'set_recurring_event' => array( 0, 'herhalende_gebeurtenis_instellen' ),
	'declare' => array( 0, 'declareren' ),
	'SMW_NOFACTBOX' => array( 0, '__GEENFEITENKADER__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__FEITENKADERWEERGEVEN__' ),
);

/** Punjabi (ਪੰਜਾਬੀ) */
$magicWords['pa'] = array(
	'ask' => array( 0, 'ਪੁੱਛੋ' ),
	'show' => array( 0, 'ਵਿਖਾਓ' ),
	'info' => array( 0, 'ਜਾਣਕਾਰੀ' ),
);

/** Polish (polski) */
$magicWords['pl'] = array(
	'ask' => array( 0, 'pytanie' ),
	'show' => array( 0, 'pokaż' ),
	'info' => array( 0, 'informacja' ),
	'set' => array( 0, 'ustaw' ),
	'declare' => array( 0, 'zadeklaruj' ),
);

/** Pashto (پښتو) */
$magicWords['ps'] = array(
	'ask' => array( 0, 'پوښتل', 'ask' ),
	'show' => array( 0, 'ښکاره_کول', 'show' ),
	'info' => array( 0, 'مالومات', 'info' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$magicWords['sr-ec'] = array(
	'ask' => array( 0, 'питај' ),
	'show' => array( 0, 'прикажи' ),
	'info' => array( 0, 'подаци' ),
	'concept' => array( 0, 'концепт' ),
	'set' => array( 0, 'постави' ),
	'set_recurring_event' => array( 0, 'постави_периодични_догађај' ),
	'declare' => array( 0, 'одреди' ),
);

/** Serbian (Latin script) (srpski (latinica)‎) */
$magicWords['sr-el'] = array(
	'ask' => array( 0, 'pitaj' ),
	'show' => array( 0, 'prikaži' ),
	'info' => array( 0, 'podaci' ),
	'concept' => array( 0, 'koncept' ),
	'set' => array( 0, 'postavi' ),
	'set_recurring_event' => array( 0, 'postavi_periodični_događaj' ),
	'declare' => array( 0, 'odredi' ),
	'SMW_NOFACTBOX' => array( 0, '__BEZČINJENICA__', '__BEZ_ČINJENICA__' ),
	'SMW_SHOWFACTBOX' => array( 0, '__PRIKAŽIČINJENICE__', '__PRIKAŽI_ČINJENICE__' ),
);

/** Swedish (svenska) */
$magicWords['sv'] = array(
	'ask' => array( 0, 'fråga', 'ask' ),
	'show' => array( 0, 'visa', 'show' ),
	'concept' => array( 0, 'koncept', 'concept' ),
);

/** Tatar (Cyrillic script) (татарча) */
$magicWords['tt-cyrl'] = array(
	'ask' => array( 0, 'сорау' ),
	'show' => array( 0, 'күрсәт' ),
	'info' => array( 0, 'мәгълүмат' ),
);