<?php
/**
 * Internationalization file for Semantic Internal Objects
 *
 * @file
 * @ingroup Language
 * @ingroup I18n
 * @ingroup SemanticInternalObjects
 */

$messages = array();

/** English
 *  @author Yaron Koren
 */
$messages['en'] = array(
	'semanticinternalobjects-desc' => 'Setting of internal objects in Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Internal property',
	'semanticinternalobjects-mainpropertyname' => 'Name of property to connect this template\'s fields to the rest of the page:',
	'semanticinternalobjects-propnamewarning' => '(should only be used if this template can have multiple instances)',
);

/** Message documentation (Message documentation)
 * @author Yaron Koren
 */
$messages['qqq'] = array(
	'semanticinternalobjects-desc' => '{{desc}}',
	'semanticinternalobjects-internalproperty' => 'A semantic property stored internally in the page',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'semanticinternalobjects-desc' => 'Vendosja e objekteve të brendshëm në Semantic MediaWiki',
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'semanticinternalobjects-desc' => 'ضبط الأشياء الداخلية في ميدياويكي الدلالي',
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'semanticinternalobjects-desc' => "Definición d'oxetos internos en Semantic MediaWiki",
	'semanticinternalobjects-internalproperty' => 'Propiedá interna',
	'semanticinternalobjects-mainpropertyname' => "Nome de la propiedá pa conectar los campos d'esta plantía col restu de la páxina:",
	'semanticinternalobjects-propnamewarning' => "(namái tendría d'emplegase si esta plantía pue tener múltiples instancies)",
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Zedlik
 */
$messages['be-tarask'] = array(
	'semanticinternalobjects-desc' => "Налады ўнутраных аб'ектаў у Semantic MediaWiki",
);

/** Breton (brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'semanticinternalobjects-desc' => 'Kefluniadur traezoù diabarzh e Semanctic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Perzh diabarzh',
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'semanticinternalobjects-desc' => 'Postavljanje unutrašnjih objekata u Semantic MediaWiki',
);

/** Catalan (català)
 * @author Toniher
 */
$messages['ca'] = array(
	'semanticinternalobjects-desc' => "Definició d'objectes interns en el Semantic MediaWiki",
	'semanticinternalobjects-internalproperty' => 'Propietat interna',
);

/** German (Deutsch)
 * @author Imre
 * @author Kghbln
 * @author Metalhead64
 */
$messages['de'] = array(
	'semanticinternalobjects-desc' => 'Ermöglicht das Definieren interner semantischer Datenobjekte',
	'semanticinternalobjects-internalproperty' => 'Internes Attribut',
	'semanticinternalobjects-mainpropertyname' => 'Name des Attributs, mit dem die Felder dieser Vorlage mit dem Rest der Seite verbunden werden:',
	'semanticinternalobjects-propnamewarning' => '(sollte nur verwendet werden, sofern diese Vorlage mehrere Instanzen haben kann)',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'semanticinternalobjects-desc' => 'Nastajenje internych objektow w Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Interna kakosć',
	'semanticinternalobjects-mainpropertyname' => 'Mě kakosći, aby póla toś teje pśedłogi ze zbytkom boka zwězało:',
	'semanticinternalobjects-propnamewarning' => '(měł se jano wužywaś, jolic toś ta pśedłoga móžo někotare instance měś)',
);

/** Greek (Ελληνικά)
 * @author Omnipaedista
 */
$messages['el'] = array(
	'semanticinternalobjects-desc' => 'Ρυθμίσεις εσωτερικών αντικειμένων στη Σημασιολογική MediaWiki',
);

/** Spanish (español)
 * @author Armando-Martin
 * @author Crazymadlover
 */
$messages['es'] = array(
	'semanticinternalobjects-desc' => 'Configuración de objetos internos en Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Propiedad interna',
	'semanticinternalobjects-mainpropertyname' => 'Nombre de la propiedad para conectar los campos de esta plantilla con el resto de la página:',
	'semanticinternalobjects-propnamewarning' => '(debe ser utilizado únicamente si esta plantilla puede tener varias instancias)',
);

/** Finnish (suomi)
 * @author Centerlink
 * @author Crt
 */
$messages['fi'] = array(
	'semanticinternalobjects-desc' => 'Sisäisten objektien asetukset semanttisessa MediaWikissä.',
);

/** French (français)
 * @author Brunoperel
 * @author Crochet.david
 * @author Gomoko
 */
$messages['fr'] = array(
	'semanticinternalobjects-desc' => 'Réglage des objets internes dans Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Propriété interne',
	'semanticinternalobjects-mainpropertyname' => 'Nom de propriété pour connecter les champs de ce modèle pour le reste de la page :',
	'semanticinternalobjects-propnamewarning' => '(doit être utilisé uniquement si ce modèle peut avoir plusieurs instances)',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'semanticinternalobjects-internalproperty' => 'Propriètât de dedens',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'semanticinternalobjects-desc' => 'Configuracións de obxectos internos en Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Propiedade interna',
	'semanticinternalobjects-mainpropertyname' => 'Nome da propiedade para conectar os campos deste modelo co resto da páxina:',
	'semanticinternalobjects-propnamewarning' => '(debería empregarse unicamente se este modelo pode ter numerosas instancias)',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'semanticinternalobjects-desc' => 'Intärni Objäkt in Semantic MediaWiki yysetze',
	'semanticinternalobjects-internalproperty' => 'Interns Attribut',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'semanticinternalobjects-desc' => 'הגדרות העצמים הפנימיים במדיה־ויקי הסמנטי',
	'semanticinternalobjects-internalproperty' => 'מאפיין פנימי',
);

/** Hiligaynon (Ilonggo)
 * @author Tagimata
 */
$messages['hil'] = array(
	'semanticinternalobjects-desc' => 'Pagplastar sang internal na mga bagay sa Semantik MedyaWiki',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'semanticinternalobjects-desc' => 'Nastajenje internych objektow w Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Interna kajkosć',
	'semanticinternalobjects-mainpropertyname' => 'Mjeno kajkosće, zo by pola tuteje předłohi ze zbytkom strony zwjazało:',
	'semanticinternalobjects-propnamewarning' => '(měł so jenož wužiwać, jeli tuta předłoha móže wjacore instancy měć)',
);

/** Hungarian (magyar)
 * @author Dj
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'semanticinternalobjects-desc' => 'Belső objektumok beállítása a szemantikus MediaWikiben',
	'semanticinternalobjects-internalproperty' => 'Belső tulajdonság',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'semanticinternalobjects-desc' => 'Configuration de objectos interne in Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Proprietate interne',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 */
$messages['id'] = array(
	'semanticinternalobjects-desc' => 'Seting untuk objek internal pada Semantic MediaWiki',
);

/** Italian (italiano)
 * @author Beta16
 * @author Darth Kule
 * @author Gianfranco
 */
$messages['it'] = array(
	'semanticinternalobjects-desc' => 'Configurazione degli oggetti interni in Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Proprietà interna',
	'semanticinternalobjects-mainpropertyname' => 'Nome della proprietà per collegare i campi di questo modello al resto della pagina:',
	'semanticinternalobjects-propnamewarning' => '(deve essere utilizzato solo se questo modello può avere più istanze)',
);

/** Japanese (日本語)
 * @author Fryed-peach
 * @author Shirayuki
 */
$messages['ja'] = array(
	'semanticinternalobjects-desc' => 'Semantic MediaWiki の内部オブジェクトの設定',
	'semanticinternalobjects-internalproperty' => '内部プロパティ',
	'semanticinternalobjects-propnamewarning' => '(このテンプレートが複数の実体を持つ可能性がある場合のみ使用すべきです)',
);

/** Korean (한국어)
 * @author 아라
 */
$messages['ko'] = array(
	'semanticinternalobjects-desc' => 'Semantic MediaWiki에 내부 개체 설정',
	'semanticinternalobjects-internalproperty' => '내부 속성',
	'semanticinternalobjects-mainpropertyname' => '문서의 나머지 부분에 틀의 필드를 연결하는 속성 이름:',
	'semanticinternalobjects-propnamewarning' => '(이 틀이 여러 인스턴스를 가질 수 있을 때에만 사용해야 합니다)',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'semanticinternalobjects-desc' => 'De ennere Objäkte vum Semantesch MedijaWiki enschtälle.',
	'semanticinternalobjects-internalproperty' => 'Enner Eijeschaff',
	'semanticinternalobjects-mainpropertyname' => 'Dä Name vun dä Eijeschaff, öm de Fälder vun heh dä SChablohn mem Räß vun dä Sigg ze verbenge:',
	'semanticinternalobjects-propnamewarning' => '(Dat sullt bloß jebruch wääde, wann di Schablohn öfters opjeroofe wääde kann)',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'semanticinternalobjects-desc' => 'Astellung vun internen Objeten a Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Intern Eegeschaft',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'semanticinternalobjects-desc' => 'Задавање на внатрешни објекти во Семантички МедијаВики',
	'semanticinternalobjects-internalproperty' => 'Внатрешно својство',
	'semanticinternalobjects-mainpropertyname' => 'Име на својството што треба да ги поврзе полињата на овој шаблон со остатокот од страницата:',
	'semanticinternalobjects-propnamewarning' => '(треба да се користи само ако шаблонов може да има повеќе примероци)',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'semanticinternalobjects-desc' => 'Penetapan objek dalaman di Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Sifat dalaman',
	'semanticinternalobjects-mainpropertyname' => 'Nama sifat untuk menyambungkan medan-medan templat ini dengan seluruh halaman:',
	'semanticinternalobjects-propnamewarning' => '(hanya boleh digunakan jika templat ini boleh mempunyai berbilang tika)',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Event
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'semanticinternalobjects-desc' => 'Innstilling for interne objekter i Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Intern egenskap',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'semanticinternalobjects-desc' => 'Interne objecten in Semantic MediaWiki instellen',
	'semanticinternalobjects-internalproperty' => 'Interne eigenschap',
	'semanticinternalobjects-mainpropertyname' => 'Naam van de eigenschap om de velden van dit sjabloon te koppelen met de rest van de pagina:',
	'semanticinternalobjects-propnamewarning' => '(hoort alleen gebruikt te worden als dit sjabloon meerdere instanties kan hebben)',
);

/** Occitan (occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'semanticinternalobjects-desc' => 'Reglatge dels objèctes intèrnes dins Semantic MediaWiki',
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'semanticinternalobjects-desc' => 'Ustawianie wewnętrznych obiektów Semantic MediaWiki.',
	'semanticinternalobjects-internalproperty' => 'Atrybut wewnętrzny',
	'semanticinternalobjects-mainpropertyname' => 'Nazwa atrybutu łączącego pola szablonu z resztą strony:',
	'semanticinternalobjects-propnamewarning' => '(należy używać tylko jeśli ten szablon może mieć wiele wystąpień)',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'semanticinternalobjects-desc' => "Ampostassion d'oget intern an drinta a Semantic MediaWiki",
	'semanticinternalobjects-internalproperty' => 'Proprietà anterna',
	'semanticinternalobjects-mainpropertyname' => 'Nòm ëd la propietà për coleghé ij camp ëd së stamp për ël rest ëd la pàgina:',
	'semanticinternalobjects-propnamewarning' => '(a dovrìa esse dovrà mach se së stamp a peul avèj vàire istanse)',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 * @author Indech
 */
$messages['pt'] = array(
	'semanticinternalobjects-desc' => 'Configuração de objetos internos no MediaWiki Semântico',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Eduardo.mps
 * @author Jaideraf
 */
$messages['pt-br'] = array(
	'semanticinternalobjects-desc' => 'Definição de objetos internos no Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Propriedade interna',
	'semanticinternalobjects-mainpropertyname' => 'Nome da propriedade utilizada para conectar os campos dessa predefinição com o resto da página:',
	'semanticinternalobjects-propnamewarning' => '(só deve ser utilizado se essa predefinição puder ter várias instâncias na mesma página)',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'semanticinternalobjects-desc' => "'Mboste le oggette inderne jndr'à MediaUicchi Semandiche",
);

/** Russian (русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'semanticinternalobjects-desc' => 'Установка внутренних объектов в Semantic MediaWiki',
);

/** Slovak (slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'semanticinternalobjects-desc' => 'Nastavenie vnútorných objektov v Semantic MediaWiki',
);

/** Slovenian (slovenščina)
 * @author Dbc334
 * @author Lesko987
 */
$messages['sl'] = array(
	'semanticinternalobjects-desc' => 'Nastavitev notranjih predmetov v semantičnem MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Notranja lastnina',
);

/** Swedish (svenska)
 * @author Martinwiss
 * @author Per
 * @author Rotsee
 */
$messages['sv'] = array(
	'semanticinternalobjects-desc' => 'Inställning för interna objekt i Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Intern egenskap',
	'semanticinternalobjects-mainpropertyname' => 'Namnet på egenskapen som ansluter den här mallen indata-fält till resten av sidan:',
	'semanticinternalobjects-propnamewarning' => '(ska endast användas om den här mallen kan ha flera versioner)',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'semanticinternalobjects-desc' => 'Pagtatakda ng panloob na mga bagay sa Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Panloob ng ari-arian',
	'semanticinternalobjects-mainpropertyname' => 'Pangalan ng ari-arian na pagkakabitan ng mga kahanayan ng suleras na ito papunta sa iba pang mga bahagi ng pahina:',
	'semanticinternalobjects-propnamewarning' => '(dapat na gamitin lamang kung ang suleras na ito ay maaaring magkaroon ng maramihang mga pagkakataon)',
);

/** Turkish (Türkçe)
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'semanticinternalobjects-desc' => "Anlamsal MediaWiki'deki iç nesnelerin ayarlanması",
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'semanticinternalobjects-desc' => 'Thiết kế các đối tượng nội bộ trong MediaWiki Ngữ nghĩa',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Liangent
 * @author Linforest
 */
$messages['zh-hans'] = array(
	'semanticinternalobjects-desc' => '在语义MediaWiki中设置内部对象',
	'semanticinternalobjects-internalproperty' => '内部属性',
);

/** Traditional Chinese (中文（繁體）‎)
 */
$messages['zh-hant'] = array(
	'semanticinternalobjects-desc' => '在語義MediaWiki中設置內部對象',
	'semanticinternalobjects-internalproperty' => '內部屬性',
);
