<?php
/**
 * Internationalisation for Header Tabs extension
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English */
$messages['en'] = array(
	'headertabs-desc' => 'Adds tabs to the page separating top-level sections',
	'headertabs-edittab' => 'edit',
	'headertabs-edittab-hint' => 'Edit tab',
	'headertabs-edittab-key' => 't',
);

/** Message documentation (Message documentation)
 * @author EugeneZelenko
 * @author Purodha
 */
$messages['qqq'] = array(
	'headertabs-desc' => '{{desc}}',
	'headertabs-edittab' => '{{Identical|Edit}}',
	'headertabs-edittab-hint' => 'This is about a tab being edited.',
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'headertabs-desc' => 'Amiesta llingüetes a la páxina pa separar les seiciones de primer nivel',
	'headertabs-edittab' => 'editar',
	'headertabs-edittab-hint' => 'Llingüeta editar',
);

/** Belarusian (Taraškievica orthography) (‪беларуская (тарашкевіца)‬)
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'headertabs-desc' => 'Дадае на старонку закладкі, якія падзяляюць разьдзелы верхняга ўзроўню',
	'headertabs-edittab' => 'рэдагаваць',
	'headertabs-edittab-hint' => 'Рэдагаваць закладку',
);

/** Breton (brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'headertabs-edittab' => 'kemmañ',
	'headertabs-edittab-hint' => 'Kemmañ an ivinell',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'headertabs-desc' => 'Ermöglicht Reiter zur alternativen Darstellung der obersten Gliederungsebene von Inhaltsverzeichnissen',
	'headertabs-edittab' => 'bearbeiten',
	'headertabs-edittab-hint' => 'Inhalt des Reiters bearbeiten',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 * @author Mirzali
 */
$messages['diq'] = array(
	'headertabs-edittab' => 'bıvurne',
	'headertabs-edittab-hint' => 'Taber bıvurne',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'headertabs-desc' => 'Zmóžnja rejtarki k bokoju, kótarež wótźěluju nejwuše wótrězki',
	'headertabs-edittab' => 'wobźěłaś',
	'headertabs-edittab-hint' => 'Rejtark wobźěłaś',
);

/** Spanish (español)
 * @author Armando-Martin
 */
$messages['es'] = array(
	'headertabs-desc' => 'Añade pestañas a la página para separar las secciones de nivel superior',
	'headertabs-edittab' => 'editar',
	'headertabs-edittab-hint' => 'Editar pestaña',
);

/** Persian (فارسی)
 * @author ZxxZxxZ
 */
$messages['fa'] = array(
	'headertabs-edittab' => 'ویرایش',
	'headertabs-edittab-hint' => 'زبانهٔ ویرایش',
);

/** French (français)
 * @author Gomoko
 */
$messages['fr'] = array(
	'headertabs-desc' => 'Ajoute des onglets à la page qui sépare les sections de niveau supérieur',
	'headertabs-edittab' => 'modifier',
	'headertabs-edittab-hint' => "Modifier l'onglet",
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'headertabs-desc' => 'Engade lapelas á páxina para separar as seccións de nivel superior',
	'headertabs-edittab' => 'editar',
	'headertabs-edittab-hint' => 'Editar a lapela',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Nirofir
 * @author Ofekalef
 */
$messages['he'] = array(
	'headertabs-desc' => 'הוספה לדף של לשוניות שמפרידות פסקאות ראשיות',
	'headertabs-edittab' => 'עריכה',
	'headertabs-edittab-hint' => 'עריכת לשונית',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'headertabs-desc' => 'Zmóžnja rajtarki k stronje, kotrež najwyše wotrězki wotdźěleja',
	'headertabs-edittab' => 'wobdźěłać',
	'headertabs-edittab-hint' => 'Rajtark wobdźěłać',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'headertabs-desc' => 'Adde schedas al pagina, separante le sectiones de prime nivello',
	'headertabs-edittab' => 'modificar',
	'headertabs-edittab-hint' => 'Modificar scheda',
);

/** Italian (italiano)
 * @author Beta16
 */
$messages['it'] = array(
	'headertabs-desc' => 'Aggiunge schede alla pagina separando le sezioni di primo livello',
	'headertabs-edittab' => 'modifica',
	'headertabs-edittab-hint' => 'Modifica scheda',
);

/** Japanese (日本語)
 * @author Shirayuki
 * @author Whym
 */
$messages['ja'] = array(
	'headertabs-desc' => '最上位の節ごとに分けたタブをページに追加する',
	'headertabs-edittab' => '編集',
	'headertabs-edittab-hint' => 'タブを編集',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'headertabs-edittab' => 'ändere',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'headertabs-desc' => "Setzt Tabs op d'Säiten derbäi als alternativ Manéier fir den Ieweschten Niveau vun den Abschnitter vun engem Artikel duerzestellen",
	'headertabs-edittab' => 'änneren',
	'headertabs-edittab-hint' => 'Tab änneren',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'headertabs-desc' => 'Во страницата додава јазичиња што ги одделуваат првостепените поднаслови',
	'headertabs-edittab' => 'уреди',
	'headertabs-edittab-hint' => 'Јазиче за уредување',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'headertabs-desc' => 'Menambahkan tab pada laman untuk memisahkan bahagian-bahagian aras teratas',
	'headertabs-edittab' => 'sunting',
	'headertabs-edittab-hint' => 'Sunting tab',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'headertabs-desc' => 'Voegt tabbladen toe aan een pagina om de hoogste niveaus te scheiden',
	'headertabs-edittab' => 'bewerken',
	'headertabs-edittab-hint' => 'Tabblad bewerken',
);

/** Polish (polski)
 * @author BeginaFelicysym
 */
$messages['pl'] = array(
	'headertabs-desc' => 'Dodaje do strony zakładki oddzielające sekcje najwyższego poziomu',
	'headertabs-edittab' => 'edytuj',
	'headertabs-edittab-hint' => 'Edytuj zakładkę',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'headertabs-desc' => "A gionta dij feuij a la pàgina ch'a separo le session ëd livel pì àut",
	'headertabs-edittab' => 'modìfica',
	'headertabs-edittab-hint' => 'Modìfiché la lenghëtta',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Jaideraf
 */
$messages['pt-br'] = array(
	'headertabs-desc' => 'Adiciona guias à página separando seções de primeiro nível',
	'headertabs-edittab' => 'editar',
	'headertabs-edittab-hint' => 'Editar guia',
);

/** Russian (русский)
 * @author Eleferen
 */
$messages['ru'] = array(
	'headertabs-desc' => 'Добавляет вкладки на странице, разделяющие разделы верхнего уровня',
	'headertabs-edittab' => 'править',
	'headertabs-edittab-hint' => 'Редактировать вкладку',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'headertabs-desc' => 'Nagdaragdag ng mga laylayan sa pahina na naghihiwalay ng mga seksiyon na pangmataas na antas',
	'headertabs-edittab' => 'baguhin',
	'headertabs-edittab-hint' => 'Baguhin ang laylayan',
);

