<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'ImportCSV' => array( 'ImportCSV' ),
	'ImportXML' => array( 'ImportXML' ),
	'ViewXML' => array( 'ViewXML' ),
);

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = array(
	'ViewXML' => array( 'WysXML' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'ImportCSV' => array( 'استيراد_سي_إس_في' ),
	'ImportXML' => array( 'استيراد_إكس_إم_إل' ),
	'ViewXML' => array( 'عرض_إكس_إم_إل' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'ViewXML' => array( 'عرض_XML' ),
);

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = array(
	'ImportCSV' => array( 'CSV_আমদানি' ),
	'ImportXML' => array( 'XML_আমদানি' ),
	'ViewXML' => array( 'XML_পৰিদৰ্শন' ),
);

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = array(
	'ViewXML' => array( 'Itihi_XML' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'ImportCSV' => array( 'EnporzhiañCSV' ),
	'ImportXML' => array( 'EnporzhiañXML' ),
	'ViewXML' => array( 'GweletXML' ),
);

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = array(
	'ViewXML' => array( 'VidiXML' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'ImportCSV' => array( 'CSV_importieren' ),
	'ImportXML' => array( 'XML_importieren' ),
	'ViewXML' => array( 'XML_anzeigen' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'ImportCSV' => array( 'CSVDeke' ),
	'ImportXML' => array( 'XMLDeke' ),
	'ViewXML' => array( 'XMLBivin' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'ViewXML' => array( 'Montri_XML' ),
);

/** Spanish (español) */
$specialPageAliases['es'] = array(
	'ViewXML' => array( 'Ver_XML', 'VerXML' ),
);

/** Basque (euskara) */
$specialPageAliases['eu'] = array(
	'ViewXML' => array( 'XMLIkusi' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'ImportCSV' => array( 'درون‌ریزی_سی‌اس‌وی' ),
	'ImportXML' => array( 'درون‌ریزی_اکس‌ام‌ال' ),
	'ViewXML' => array( 'مشاهده_اکس‌ام‌ال' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'ImportCSV' => array( 'Tuo_CSV' ),
	'ImportXML' => array( 'Tuo_XML' ),
	'ViewXML' => array( 'Näytä_XML' ),
);

/** French (français) */
$specialPageAliases['fr'] = array(
	'ImportCSV' => array( 'Importer_CVS', 'ImporterCVS' ),
	'ImportXML' => array( 'Importer_XML', 'ImporterXML' ),
	'ViewXML' => array( 'Voir_le_XML', 'Voir_XML', 'VoirXML' ),
);

/** Franco-Provençal (arpetan) */
$specialPageAliases['frp'] = array(
	'ViewXML' => array( 'Vêre_lo_XML', 'VêreLoXML' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'ImportCSV' => array( 'Importar_o_CSV' ),
	'ImportXML' => array( 'Importar_o_XML' ),
	'ViewXML' => array( 'Ver_o_XML' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'ViewXML' => array( 'Lueg_XML' ),
);

/** Gujarati (ગુજરાતી) */
$specialPageAliases['gu'] = array(
	'ViewXML' => array( 'XMLજુઓ' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'ImportCSV' => array( 'EnpòteCSV' ),
	'ImportXML' => array( 'EnpòteXML' ),
	'ViewXML' => array( 'WèXML' ),
);

/** Hungarian (magyar) */
$specialPageAliases['hu'] = array(
	'ViewXML' => array( 'XML_megtekintése' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'ImportCSV' => array( 'Importar_CSV' ),
	'ImportXML' => array( 'Importar_XML' ),
	'ViewXML' => array( 'Visualisar_XML' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'ViewXML' => array( 'Lihat_XML', 'LihatXML' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'ImportCSV' => array( 'ImportaCSV' ),
	'ImportXML' => array( 'ImportaXML' ),
	'ViewXML' => array( 'VediXML' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'ImportCSV' => array( 'CSV取り込み', 'CSVインポート' ),
	'ImportXML' => array( 'XML取り込み', 'XMLインポート' ),
	'ViewXML' => array( 'XML表示', 'ＸＭＬ表示' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'ViewXML' => array( 'មើលXML' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'ImportCSV' => array( 'CSV가져오기' ),
	'ImportXML' => array( 'XML가져오기' ),
	'ViewXML' => array( 'XML보기' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'ImportCSV' => array( 'CSV_Empotteere' ),
	'ImportXML' => array( 'XML_Empoteere' ),
	'ViewXML' => array( 'XML_beloore' ),
);

/** Cornish (kernowek) */
$specialPageAliases['kw'] = array(
	'ImportCSV' => array( 'YmperthiCSV' ),
	'ImportXML' => array( 'YmperthiXML' ),
	'ViewXML' => array( 'GwelesXML' ),
);

/** Ladino (Ladino) */
$specialPageAliases['lad'] = array(
	'ImportCSV' => array( 'Aktarear_CSV_Ariento' ),
	'ImportXML' => array( 'Aktarear_XML_Ariento' ),
	'ViewXML' => array( 'Ver_XML' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'ImportCSV' => array( 'CSV_importéieren' ),
	'ImportXML' => array( 'XML_importéieren' ),
	'ViewXML' => array( 'XML_weisen' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'ImportCSV' => array( 'УвезиCSV' ),
	'ImportXML' => array( 'УвезиXML' ),
	'ViewXML' => array( 'ВидиXML' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'ImportCSV' => array( 'സി.എസ്.വി.ഇറക്കുമതി' ),
	'ImportXML' => array( 'എക്സ്.എം.എൽ.ഇറക്കുമതി' ),
	'ViewXML' => array( 'എക്സ്.എം.എൽ.കാണുക' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'ViewXML' => array( 'XMLपहा' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'ViewXML' => array( 'UriXML' ),
);

/** Norwegian Bokmål (norsk (bokmål)‎) */
$specialPageAliases['nb'] = array(
	'ImportCSV' => array( 'Importer_CSV' ),
	'ImportXML' => array( 'Importer_XML' ),
	'ViewXML' => array( 'Vis_XML' ),
);

/** Nedersaksisch (Nedersaksisch) */
$specialPageAliases['nds-nl'] = array(
	'ImportCSV' => array( 'CSV_invoeren' ),
	'ImportXML' => array( 'XML_invoeren' ),
	'ViewXML' => array( 'XML_bekieken' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'ImportCSV' => array( 'CSVImporteren' ),
	'ImportXML' => array( 'XMLImporteren' ),
	'ViewXML' => array( 'XMLBekijken' ),
);

/** Occitan (occitan) */
$specialPageAliases['oc'] = array(
	'ViewXML' => array( 'Veire_XML', 'VeireXML' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'ViewXML' => array( 'XML' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'ViewXML' => array( 'Ver_XML' ),
);

/** Romanian (română) */
$specialPageAliases['ro'] = array(
	'ImportCSV' => array( 'Import_CSV' ),
	'ImportXML' => array( 'Import_XML' ),
	'ViewXML' => array( 'Vizualizare_XML' ),
);

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = array(
	'ViewXML' => array( 'XMLपश्यति' ),
);

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = array(
	'ViewXML' => array( 'ZobraziťXML' ),
);

/** Albanian (shqip) */
$specialPageAliases['sq'] = array(
	'ViewXML' => array( 'ShihXML' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'ImportCSV' => array( 'Importera_CSV' ),
	'ImportXML' => array( 'Importera_XML' ),
	'ViewXML' => array( 'Visa_XML' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'ViewXML' => array( 'OnyeshaXML' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'ViewXML' => array( 'Tingnan_ang_XML' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'ImportCSV' => array( 'CSVAktar', 'CSVİçeAktar' ),
	'ImportXML' => array( 'XMLAktar', 'XMLİçeAktar' ),
	'ViewXML' => array( 'XMLGör' ),
);

/** Tatar (Cyrillic script) (татарча) */
$specialPageAliases['tt-cyrl'] = array(
	'ImportCSV' => array( 'CSV_импорт' ),
	'ImportXML' => array( 'XML_импорт' ),
	'ViewXML' => array( 'XML_иттереп_ачу' ),
);

/** vèneto (vèneto) */
$specialPageAliases['vec'] = array(
	'ViewXML' => array( 'VardaXML' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'ImportCSV' => array( 'Nhập_CSV' ),
	'ImportXML' => array( 'Nhập_XML' ),
	'ViewXML' => array( 'Xem_XML' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'ImportCSV' => array( '导入CSV' ),
	'ImportXML' => array( '导入XML' ),
	'ViewXML' => array( '查看XML' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'ImportCSV' => array( '導入CSV' ),
	'ImportXML' => array( '導入XML' ),
	'ViewXML' => array( '查看XML' ),
);