<?php
/**
 * Internationalization messages file for SemanticTasks extension
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English (English)
 * @author Steren Giannini
 */
$messages['en'] = array(
	'semantictasks-desc' => 'E-mail notifications for assigned or updated tasks',
	'semantictasks-newtask' => 'New task:',
	'semantictasks-taskassigned' => 'Task assigned:',
	'semantictasks-taskupdated' => 'Task updated:',
	'semantictasks-taskclosed' => 'Task closed:',
	'semantictasks-newtask-msg' => 'The task "$1" has just been created.',
	'semantictasks-taskclosed-msg' => 'The task "$1" has just been closed.',
	'semantictasks-assignedtoyou-msg2' => 'The task "$1" has just been assigned to you.',
	'semantictasks-updatedtoyou-msg2' => 'The task "$1" has just been updated.',
	'semantictasks-reminder' => 'Reminder:',
	'semantictasks-reminder-message2' => "Just to remind you that the task \"$1\" ends in $2 {{PLURAL:$2|day|days}}.

$3",
	'semantictasks-text-message' => 'Here is the task description:',
	'semantictasks-diff-message' => 'Here are the differences:',
);

/** Message documentation (Message documentation)
 * @author Fryed-peach
 * @author Purodha
 */
$messages['qqq'] = array(
	'semantictasks-desc' => '{{desc}}',
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 */
$messages['ar'] = array(
	'semantictasks-desc' => 'إخطارات بالبريد الإلكتروني للمهام الموكولة أو المحدثة',
	'semantictasks-newtask' => 'مهمة جديدة:',
	'semantictasks-taskupdated' => 'المهمة تم تحديثها:',
	'semantictasks-assignedtoyou-msg2' => 'المهمة "$1" تم إيكالها حالا إليك',
	'semantictasks-updatedtoyou-msg2' => 'المهمة "$1" تم تحديثها حالا.',
	'semantictasks-reminder' => 'تذكرة:',
	'semantictasks-reminder-message2' => 'فقط أذكرك أن المهمة "$1" تنتهي في غضون {{PLURAL:$2||يوم واحد|يومين|$2 أيام|$2 يومًا|$2 يوم}}.

$3',
	'semantictasks-text-message' => 'هنا وصف المهمة:',
	'semantictasks-diff-message' => 'هنا الفروقات:',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'semantictasks-desc' => 'Паведамленьне па электроннай пошце пра даданьне альбо абнаўленьне заданьняў',
	'semantictasks-newtask' => 'Новае заданьне:',
	'semantictasks-taskassigned' => 'Прызначанае заданьне:',
	'semantictasks-taskupdated' => 'Заданьне абноўлена:',
	'semantictasks-taskclosed' => 'Заданьне скончанае:',
	'semantictasks-newtask-msg' => 'Заданьне «$1» было толькі што створана.',
	'semantictasks-taskclosed-msg' => 'Заданьне «$1» было толькі што скончанае.',
	'semantictasks-assignedtoyou-msg2' => 'Вам толькі што было прызначана заданьне «$1»',
	'semantictasks-updatedtoyou-msg2' => 'Заданьне «$1» толькі што было абноўлена.',
	'semantictasks-reminder' => 'Напамін:',
	'semantictasks-reminder-message2' => 'Нагадваем Вам, што тэрмін выкананьня заданьня «$1» скончыцца праз $2 {{PLURAL:$2|дзень|дні|дзён}}.

$3',
	'semantictasks-text-message' => 'Апісаньне заданьня:',
	'semantictasks-diff-message' => 'Розьніца:',
);

/** Bengali (বাংলা)
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'semantictasks-newtask' => 'নতুন কাজ:',
);

/** Breton (Brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'semantictasks-desc' => 'Kemennadenn dre bostel evit an trevelloù deverket pe hizivaet',
	'semantictasks-newtask' => 'Trevell nevez :',
	'semantictasks-taskassigned' => 'Trevell roet :',
	'semantictasks-taskupdated' => 'Hizivaet an trevell :',
	'semantictasks-taskclosed' => 'Trevell serret :',
	'semantictasks-newtask-msg' => 'O paouez bezañ krouet eo an trevell "$1".',
	'semantictasks-taskclosed-msg' => 'O paouez bezañ serret eo an trevell "$1".',
	'semantictasks-assignedtoyou-msg2' => 'Deverket eo bet an trevell "$1" deoc\'h.',
	'semantictasks-updatedtoyou-msg2' => 'Hizivaet eo bet an trevell "$1".',
	'semantictasks-reminder' => "Derc'hel soñj :",
	'semantictasks-reminder-message2' => 'Un tamm gerig da zegas da soñj deoc\'h e vo echuet an trevell "$1" a-benn $2 {{PLURAL:$2|deiz|deiz}}.


$3',
	'semantictasks-text-message' => 'Setu aze deskrivadenn an trevell :',
	'semantictasks-diff-message' => "Setu amañ ar c'hemmoù :",
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'semantictasks-desc' => 'E-mail obavještenja za dodijeljene ili ažurirane zadatke',
	'semantictasks-newtask' => 'Novi zadatak:',
	'semantictasks-taskassigned' => 'Zadatak dodijeljen:',
	'semantictasks-taskupdated' => 'Zadatak ažuriran:',
	'semantictasks-taskclosed' => 'Zadatak zatvoren:',
	'semantictasks-newtask-msg' => 'Zadatak "$1" je upravo napravljen.',
	'semantictasks-taskclosed-msg' => 'Zadatak "$1" je upravo zatvoren.',
	'semantictasks-assignedtoyou-msg2' => 'Zadatak "$1" je upravo dodijeljen Vama',
	'semantictasks-updatedtoyou-msg2' => 'Zadatak "$1" je upravo ažuriran.',
	'semantictasks-reminder' => 'Podsjetnik:',
	'semantictasks-reminder-message2' => 'Da Vas podsjetimo da zadatak "$1" završava za $2 {{PLURAL:$2|dan|dana}}.

$3',
	'semantictasks-text-message' => 'Ovdje je opis zadatka:',
	'semantictasks-diff-message' => 'Ovdje su razlike:',
);

/** Catalan (Català)
 * @author Paucabot
 * @author Toniher
 */
$messages['ca'] = array(
	'semantictasks-desc' => 'Notificacions de correu electrònic de les tasques assignades o actualitzades',
	'semantictasks-newtask' => 'Nova tasca:',
	'semantictasks-taskassigned' => 'Tasca assignada:',
	'semantictasks-taskupdated' => 'Tasca actualitzada:',
	'semantictasks-taskclosed' => 'Tasca tancada:',
	'semantictasks-newtask-msg' => "S'acaba de crear la tasca «$1».",
	'semantictasks-taskclosed-msg' => "S'acaba de tancar la tasca «$1».",
	'semantictasks-assignedtoyou-msg2' => "Se us acaba d'assignar la tasca «$1».",
	'semantictasks-updatedtoyou-msg2' => "S'acaba d'actualitzar la tasca «$1».",
	'semantictasks-reminder' => 'Recordatori:',
	'semantictasks-reminder-message2' => 'Només recordar-vos que la tasca «$1» acaba en $2 {{PLURAL:$2|dia|dies}}.

$3',
	'semantictasks-text-message' => 'Aquí hi ha una descripció de la tasca:',
	'semantictasks-diff-message' => 'Aquí hi ha les diferències:',
);

/** Czech (Česky) */
$messages['cs'] = array(
	'semantictasks-reminder' => 'Upozornění:',
);

/** German (Deutsch)
 * @author Als-Holder
 * @author Kghbln
 * @author Purodha
 */
$messages['de'] = array(
	'semantictasks-desc' => 'Ermöglicht E-Mail-Benachrichtigungen für neu zugewiesene oder geänderte Aufgaben',
	'semantictasks-newtask' => 'Neue Aufgabe:',
	'semantictasks-taskassigned' => 'Aufgabe zugewiesen:',
	'semantictasks-taskupdated' => 'Aufgabe aktualisiert:',
	'semantictasks-taskclosed' => 'Aufgabe geschlossen:',
	'semantictasks-newtask-msg' => 'Die Aufgabe „$1“ wurde soeben erstellt.',
	'semantictasks-taskclosed-msg' => 'Die Aufgabe „$1“ wurde soeben abgeschlossen.',
	'semantictasks-assignedtoyou-msg2' => 'die Aufgabe „$1“ wurde dir soeben zugewiesen.',
	'semantictasks-updatedtoyou-msg2' => 'Die Aufgabe „$1“ wurde soeben aktualisiert.',
	'semantictasks-reminder' => 'Erinnerung:',
	'semantictasks-reminder-message2' => 'Dies ist nur eine Erinnerung, dass die Aufgabe „$1“ in {{PLURAL:$2|einem Tag|$2 Tagen}} endet.

$3',
	'semantictasks-text-message' => 'Dies ist die Aufgabenbeschreibung:',
	'semantictasks-diff-message' => 'Die Unterschiede oder Änderungen sind:',
);

/** German (formal address) (‪Deutsch (Sie-Form)‬)
 * @author Imre
 */
$messages['de-formal'] = array(
	'semantictasks-assignedtoyou-msg2' => 'Die Aufgabe „$1“ wurde Ihnen soeben zugewiesen.',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'semantictasks-desc' => 'E-mailowe zdźělenja za pśipokazane abo zaktualizěrowane nadawki',
	'semantictasks-newtask' => 'Nowy nadawk:',
	'semantictasks-taskassigned' => 'Nadawk pśipokazany:',
	'semantictasks-taskupdated' => 'Nadawk zaktualizěrowany:',
	'semantictasks-taskclosed' => 'Nadawk dokóńcony:',
	'semantictasks-newtask-msg' => 'Nadawk "$1" jo se rowno napórał.',
	'semantictasks-taskclosed-msg' => 'Nadawk "$1" jo se rowno dokóńcył.',
	'semantictasks-assignedtoyou-msg2' => 'Nadawk "$1" jo se śi rowno pśipokazał',
	'semantictasks-updatedtoyou-msg2' => 'Nadawk "$1" jo se rowno zaktualizěrował',
	'semantictasks-reminder' => 'Dopomnjeśe:',
	'semantictasks-reminder-message2' => 'To jo jano dopomnjeśe, až nadawk "$1" skóńcyjo se za $2 {{PLURAL:$2|źeń|dnja|dny|dnjow}}.

$3',
	'semantictasks-text-message' => 'How jo wopisanje nadawka:',
	'semantictasks-diff-message' => 'How su rozdźěle:',
);

/** Greek (Ελληνικά)
 * @author ZaDiak
 */
$messages['el'] = array(
	'semantictasks-newtask' => 'Νέα εργασία:',
	'semantictasks-taskupdated' => 'Η εργασία ενημερώθηκε:',
	'semantictasks-reminder' => 'Υπενθύμιση:',
	'semantictasks-text-message' => 'Εδώ είναι η περιγραφή της εργασίας:',
	'semantictasks-diff-message' => 'Εδώ είναι οι διαφορές:',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'semantictasks-newtask' => 'Nova tasko:',
	'semantictasks-taskassigned' => 'Tasko donita al:',
	'semantictasks-taskupdated' => 'Takso ĝisdatigita:',
	'semantictasks-reminder' => 'Memorigilo:',
	'semantictasks-diff-message' => 'Jen la malsamaĵoj:',
);

/** Spanish (Español)
 * @author Crazymadlover
 * @author Translationista
 */
$messages['es'] = array(
	'semantictasks-desc' => 'Notificaciones por correo electrónico para tareas asignadas o actualizadas',
	'semantictasks-newtask' => 'Nueva tarea:',
	'semantictasks-taskassigned' => 'Tarea asignada:',
	'semantictasks-taskupdated' => 'Tarea actualizada:',
	'semantictasks-taskclosed' => 'Tarea cerrada:',
	'semantictasks-newtask-msg' => 'La tarea "$1" acaba de ser creada.',
	'semantictasks-taskclosed-msg' => 'La tarea "$1" acaba de ser cerrada.',
	'semantictasks-assignedtoyou-msg2' => 'La tarea "$1" acaba de haberte sido asignada',
	'semantictasks-updatedtoyou-msg2' => 'La tarea "$1" acaba de haber sido actualizada.',
	'semantictasks-reminder' => 'Recordador:',
	'semantictasks-reminder-message2' => 'Sólo para recordarte que la tarea "$1" finaliza en $2 {{PLURAL:$2|día|días}}.

$3',
	'semantictasks-text-message' => 'Aquí está la descripción de la tarea:',
	'semantictasks-diff-message' => 'Aquí están las diferencias:',
);

/** Finnish (Suomi)
 * @author Cimon Avaro
 * @author Crt
 * @author Str4nd
 */
$messages['fi'] = array(
	'semantictasks-desc' => 'Sähköposti-ilmoitukset osoitetuista tai päivitetyistä tehtävistä',
	'semantictasks-newtask' => 'Uusi tehtävä',
	'semantictasks-taskupdated' => 'Tehtävä päivitetty:',
	'semantictasks-assignedtoyou-msg2' => 'Tehtävä ”$1” on juuri osoitettu sinulle.',
	'semantictasks-updatedtoyou-msg2' => 'Tehtävä ”$1” on juuri päivitetty.',
	'semantictasks-reminder' => 'Muistutus:',
	'semantictasks-text-message' => 'Tehtävän kuvaus:',
	'semantictasks-diff-message' => 'Tässä ovat eroavaisuudet:',
);

/** French (Français)
 * @author Crochet.david
 * @author IAlex
 * @author Urhixidur
 */
$messages['fr'] = array(
	'semantictasks-desc' => 'Notifications par courriel pour les tâches assignées ou mises à jour',
	'semantictasks-newtask' => 'Nouvelle tâche :',
	'semantictasks-taskassigned' => 'Tâche assignée :',
	'semantictasks-taskupdated' => 'Tâche mise à jour :',
	'semantictasks-taskclosed' => 'Tâche fermée :',
	'semantictasks-newtask-msg' => 'La tâche « $1 » vient d’être créée.',
	'semantictasks-taskclosed-msg' => 'La tâche « $1 » vient d’être fermée.',
	'semantictasks-assignedtoyou-msg2' => 'La tâche « $1 » vous a été assignée.',
	'semantictasks-updatedtoyou-msg2' => 'La tâche « $1 » a été mise à jour.',
	'semantictasks-reminder' => 'Rappel :',
	'semantictasks-reminder-message2' => 'Nous vous rappelons que la tâche « $1 » se termine dans $2 jour{{PLURAL:$2||s}}.

$3',
	'semantictasks-text-message' => 'Voici la description de la tâche :',
	'semantictasks-diff-message' => 'Les différences sont listées ci-dessous :',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'semantictasks-newtask' => 'Travâly novél :',
	'semantictasks-taskassigned' => 'Travâly assignê :',
	'semantictasks-taskupdated' => 'Travâly betâ a jorn :',
	'semantictasks-taskclosed' => 'Travâly cllôs :',
	'semantictasks-newtask-msg' => 'Lo travâly « $1 » vint d’étre fêt.',
	'semantictasks-taskclosed-msg' => 'Lo travâly « $1 » vint d’étre cllôs.',
	'semantictasks-assignedtoyou-msg2' => 'Lo travâly « $1 » vos at étâ assignê.',
	'semantictasks-updatedtoyou-msg2' => 'Lo travâly « $1 » at étâ betâ a jorn.',
	'semantictasks-reminder' => 'Rapèl :',
	'semantictasks-text-message' => 'Vê-que la dèscripcion du travâly :',
	'semantictasks-diff-message' => 'Les difèrences sont listâs ce-desot :',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'semantictasks-desc' => 'Notificacións por correo electrónico para as tarefas asignadas ou actualizadas',
	'semantictasks-newtask' => 'Nova tarefa:',
	'semantictasks-taskassigned' => 'Tarefa asignada:',
	'semantictasks-taskupdated' => 'Tarefa actualizada:',
	'semantictasks-taskclosed' => 'Tarefa pechada:',
	'semantictasks-newtask-msg' => 'A tarefa "$1" acaba de ser creada.',
	'semantictasks-taskclosed-msg' => 'A tarefa "$1" acaba de ser pechada.',
	'semantictasks-assignedtoyou-msg2' => 'A tarefa "$1" acaba de serlle asignada.',
	'semantictasks-updatedtoyou-msg2' => 'A tarefa "$1" acaba de ser actualizada.',
	'semantictasks-reminder' => 'Recordatorio:',
	'semantictasks-reminder-message2' => 'Só é para lembrarlle que a tarefa "$1" remata {{PLURAL:$2|nun día|en $2 días}}.

$3',
	'semantictasks-text-message' => 'Aquí está a descrición da tarefa:',
	'semantictasks-diff-message' => 'Aquí están as diferenzas:',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'semantictasks-desc' => 'Benochrichtigunge per E-Mail bi veränderte oder nej zuegwisene Ufgabe',
	'semantictasks-newtask' => 'Neji Ufgab:',
	'semantictasks-taskassigned' => 'Ufgab zuegwise:',
	'semantictasks-taskupdated' => 'Ufgab aktualisiert:',
	'semantictasks-taskclosed' => 'Ufgab zuegmacht:',
	'semantictasks-newtask-msg' => 'D Ufgab „$1“ isch grad erscht aagleit wore.',
	'semantictasks-taskclosed-msg' => 'D Ufgab „$1“ isch grad zuegmcht woe.',
	'semantictasks-assignedtoyou-msg2' => 'D Ufgab „$1“ isch Dir grad zuegwise wore.',
	'semantictasks-updatedtoyou-msg2' => 'D Ufgab „$1“ isch grad aktualisiert wore.',
	'semantictasks-reminder' => 'Erinnerig:',
	'semantictasks-reminder-message2' => 'Des isch nume ne Erinnerig, ass d Ufgab „$1“ in {{PLURAL:$2|eim Tag|$2 Täg}} ufhert.

$3',
	'semantictasks-text-message' => 'Do isch d Ufgabebschryybig:',
	'semantictasks-diff-message' => 'Do sin d Unterschid:',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'semantictasks-desc' => 'שליחת הודעות דוא"ל על משימות שהוקצו או שעודכנו',
	'semantictasks-newtask' => 'משימה חדשה:',
	'semantictasks-taskassigned' => 'המשימה הוקצתה:',
	'semantictasks-taskupdated' => 'משימה עודכנה:',
	'semantictasks-taskclosed' => 'המשימה נסגרה:',
	'semantictasks-newtask-msg' => 'המשימה "$1" נוצרה זה עתה.',
	'semantictasks-taskclosed-msg' => 'המשימה "$1" נסגרה זה עתה.',
	'semantictasks-assignedtoyou-msg2' => 'המשימה "$1" הוקצתה לך הרגע',
	'semantictasks-updatedtoyou-msg2' => 'המשימה "$1" עודכנה הרגע.',
	'semantictasks-reminder' => 'תזכורת:',
	'semantictasks-reminder-message2' => 'רק רצינו להזכיר לך שהמשימה "$1" מסתיימת בעוד {{PLURAL:$2|יום|$2 ימים|יומיים}}.

$3',
	'semantictasks-text-message' => 'להלן תיאור המשימה:',
	'semantictasks-diff-message' => 'להלן ההבדלים:',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'semantictasks-desc' => 'E-mejlowe zdźělenja za připokazane abo zaktualizowane nadawki',
	'semantictasks-newtask' => 'Nowy nadawk:',
	'semantictasks-taskassigned' => 'Nadawk připokazany:',
	'semantictasks-taskupdated' => 'Nadawk zaktualizowany:',
	'semantictasks-taskclosed' => 'Nadawk zakónčeny:',
	'semantictasks-newtask-msg' => 'Nadawk "$1" je so runje wutworił.',
	'semantictasks-taskclosed-msg' => 'Nadawk "$1" je so runje zakónčił.',
	'semantictasks-assignedtoyou-msg2' => 'Nadawk "$1" bu ći runje připokazany',
	'semantictasks-updatedtoyou-msg2' => 'Nadawk "$1" bu runje zaktualizowany',
	'semantictasks-reminder' => 'Dopomnjeće:',
	'semantictasks-reminder-message2' => 'Je to jenož dopomnjeće, zo nadawk "$1" so za $2 {{PLURAL:|dźeń|dnjej|dny|dnjow}} skónči.

$3',
	'semantictasks-text-message' => 'Tu je wopisanje nadawka:',
	'semantictasks-diff-message' => 'Tu su rozdźěle:',
);

/** Hungarian (Magyar)
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'semantictasks-desc' => 'E-mail figyelmeztetések a kijelölt és frissített feladatokhoz',
	'semantictasks-newtask' => 'Új feladat:',
	'semantictasks-taskassigned' => 'Feladat kiosztva:',
	'semantictasks-taskupdated' => 'Frissített feladat:',
	'semantictasks-taskclosed' => 'Feladat lezárva:',
	'semantictasks-newtask-msg' => 'A(z) „$1” feladat éppen létrehozva.',
	'semantictasks-taskclosed-msg' => 'A(z) „$1” feladat éppen le lett zárva.',
	'semantictasks-assignedtoyou-msg2' => 'Megkaptad a(z) „$1” feladatot.',
	'semantictasks-updatedtoyou-msg2' => 'A „$1” feladat frissítve lett.',
	'semantictasks-reminder' => 'Emlékeztető:',
	'semantictasks-reminder-message2' => 'Ez egy emlékeztető, hogy a „$1” feladat határideje {{PLURAL:$2|egy|$2}} nap múlva lejár.

$3',
	'semantictasks-text-message' => 'A feladat leírása:',
	'semantictasks-diff-message' => 'Ez a felhasználó korábban blokkot kapott, és a naplóbejegyzés el lett rejtve. Az elrejtési napló alább látható tájékoztatásként:',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'semantictasks-desc' => 'Notificationes per e-mail pro cargas assignate o actualisate',
	'semantictasks-newtask' => 'Nove carga:',
	'semantictasks-taskassigned' => 'Carga assignate:',
	'semantictasks-taskupdated' => 'Carga actualisate:',
	'semantictasks-taskclosed' => 'Carga claudite:',
	'semantictasks-newtask-msg' => 'Le carga "$1" ha justo essite create.',
	'semantictasks-taskclosed-msg' => 'Le carga "$1" ha justo essite claudite.',
	'semantictasks-assignedtoyou-msg2' => 'Le carga "$1" ha justo essite assignate a te.',
	'semantictasks-updatedtoyou-msg2' => 'Le carga "$1" ha justo essite actualisate.',
	'semantictasks-reminder' => 'Rememoration:',
	'semantictasks-reminder-message2' => 'Isto es pro rememorar te que le carga "$1" essera terminate in $2 {{PLURAL:$2|die|dies}}.

$3',
	'semantictasks-text-message' => 'Ecce le description del carga:',
	'semantictasks-diff-message' => 'Ecce le differentias:',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Farras
 */
$messages['id'] = array(
	'semantictasks-desc' => 'Pemberitahuan lewat surel untuk tugas yang diberikan atau yang dimutakhirkan',
	'semantictasks-newtask' => 'Tugas baru:',
	'semantictasks-taskassigned' => 'Tugas diberikan:',
	'semantictasks-taskupdated' => 'Tugas yang dimutakhirkan:',
	'semantictasks-taskclosed' => 'Tugas ditutup:',
	'semantictasks-newtask-msg' => 'Tugas "$1" baru saja dibuat.',
	'semantictasks-taskclosed-msg' => 'Tugas "$1" baru saja ditutup.',
	'semantictasks-assignedtoyou-msg2' => 'Tugas "$1" baru saja diberikan kepada Anda',
	'semantictasks-updatedtoyou-msg2' => 'Tugas "$1" baru saja dimutakhirkan.',
	'semantictasks-reminder' => 'Pengingat:',
	'semantictasks-reminder-message2' => 'Hanya mengingatkan Anda bahwa tugas "$1" berakhir dalam $2 {{PLURAL:$2|hari|hari}}.

$3',
	'semantictasks-text-message' => 'Berikut ini keterangan tugas tersebut:',
	'semantictasks-diff-message' => 'Berikut ini adalah perubahannya:',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'semantictasks-assignedtoyou-msg2' => "Ozí ''$1'' a gbakutala gi",
	'semantictasks-reminder' => 'Ihe eji chetá:',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Hosiryuhosi
 * @author Naohiro19
 */
$messages['ja'] = array(
	'semantictasks-desc' => '課題の割り当てや更新を電子メールで通知する',
	'semantictasks-newtask' => '新規課題:',
	'semantictasks-taskassigned' => 'タスクを割り当てる',
	'semantictasks-taskupdated' => '課題の更新:',
	'semantictasks-taskclosed' => '終了したタスク:',
	'semantictasks-newtask-msg' => '課題 "$1" が作成されました。',
	'semantictasks-taskclosed-msg' => '課題「$1」が閉じられました。',
	'semantictasks-assignedtoyou-msg2' => '課題「$1」があなたに割り当てられました。',
	'semantictasks-updatedtoyou-msg2' => '課題「$1」が更新されました。',
	'semantictasks-reminder' => 'リマインダー:',
	'semantictasks-reminder-message2' => '課題「$1」は $2{{PLURAL:$2|日|日間}}で締め切りを迎えることをお知らせします。

$3',
	'semantictasks-text-message' => '課題の説明:',
	'semantictasks-diff-message' => '変更:',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'semantictasks-desc' => 'Donn <i lang="en">e-mails</i> verschecke för zohjedeilte udder veränderte Aufjabe.',
	'semantictasks-newtask' => 'Neu Aufjab:',
	'semantictasks-taskassigned' => 'Aufjab zohjedeijlt:',
	'semantictasks-taskupdated' => 'Aufjab op ene neue Shtand jebraat:',
	'semantictasks-taskclosed' => 'Aufjab afjeschloße:',
	'semantictasks-newtask-msg' => 'De Aufjab „$1“ es jraad neu enjereschdt woode.',
	'semantictasks-taskclosed-msg' => 'De Aufjab „$1“ es jraad afjeschloße woode.',
	'semantictasks-assignedtoyou-msg2' => 'Do häs äävens de Aufjab „$1“
zojedeilt krääje. Et es jez de Dinge, alsu maach jet domet!',
	'semantictasks-updatedtoyou-msg2' => 'De Aufjab „$1“ es jraad op ene neue Shtand jebraat woode.',
	'semantictasks-reminder' => 'Ä-ennerung:',
	'semantictasks-reminder-message2' => 'Bloß ens drop Opjemerk: De Aufjab „$1“ es en {{PLURAL:$2|enem Daach|$2 Dääsh|winnijer wi enem Daach}} eröm.

$3',
	'semantictasks-text-message' => 'Esu es de Aufjab beschrevve:',
	'semantictasks-diff-message' => 'Hee sin de Ungerscheide:',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'semantictasks-desc' => 'E-Mail Message fir geännert oder nei zougedeelten Aufgaben',
	'semantictasks-newtask' => 'Nei Aufgab:',
	'semantictasks-taskassigned' => 'Aufgab zougedeelt:',
	'semantictasks-taskupdated' => 'Aufgab aktualiséiert:',
	'semantictasks-taskclosed' => 'Aufgab ofgeschloss:',
	'semantictasks-newtask-msg' => 'D\'Aufgab "$1" gouf elo grad ugeluecht.',
	'semantictasks-taskclosed-msg' => 'D\'Aufgab "$1" gouf elo grad ofgeschloss.',
	'semantictasks-assignedtoyou-msg2' => 'D\'Aufgab "$1" gouf Iech elo grad zougedeelt.',
	'semantictasks-updatedtoyou-msg2' => 'D\'Aufgab "$1" gouf elo grad aktualiséiert.',
	'semantictasks-reminder' => 'Erënnerung:',
	'semantictasks-reminder-message2' => 'Dëst ass fir Iech drun ze erënneren datt d\'Aufgab "$1" an $2 {{PLURAL:$2|Dag|Deeg}} eriwwer ass.

$3',
	'semantictasks-text-message' => "Hei ass d'Beschreiwung vun der Aufgab:",
	'semantictasks-diff-message' => "Hei sinn d'Ënnerscheeder:",
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'semantictasks-desc' => 'Известувања по е-пошта за доделени или обновени задачи',
	'semantictasks-newtask' => 'Нова задача:',
	'semantictasks-taskassigned' => 'Доделена задача:',
	'semantictasks-taskupdated' => 'Задачата е обновена:',
	'semantictasks-taskclosed' => 'Затворена задача:',
	'semantictasks-newtask-msg' => 'Штотуку е создадена задачата „$1“.',
	'semantictasks-taskclosed-msg' => 'Задачата „$1“ штотуку се затвори.',
	'semantictasks-assignedtoyou-msg2' => 'Штотуку ви беше доделена задачата „$1“',
	'semantictasks-updatedtoyou-msg2' => 'Задачата „$1“ штотуку беше обновена.',
	'semantictasks-reminder' => 'Потсетување:',
	'semantictasks-reminder-message2' => 'Би сакале да ве потсетиме дека задачата „$1“ завршува за $2 {{PLURAL:$2|ден|дена}}.

$3',
	'semantictasks-text-message' => 'Еве опис на задачата:',
	'semantictasks-diff-message' => 'Еве ги разликите:',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'semantictasks-desc' => 'E-mailberichten voor toegewezen of bijgewerkte taken',
	'semantictasks-newtask' => 'Nieuwe taak:',
	'semantictasks-taskassigned' => 'Taak toegewezen:',
	'semantictasks-taskupdated' => 'Taak bijgewerkt:',
	'semantictasks-taskclosed' => 'Taak gesloten:',
	'semantictasks-newtask-msg' => 'De taak "$1" is aangemaakt.',
	'semantictasks-taskclosed-msg' => 'De taak "$1" is zojuist gesloten.',
	'semantictasks-assignedtoyou-msg2' => 'De taak "$1" is aan u toegewezen.',
	'semantictasks-updatedtoyou-msg2' => 'De taak "$1" is bijgewerkt.',
	'semantictasks-reminder' => 'Herinnering:',
	'semantictasks-reminder-message2' => 'Dit is een herinnering aan de taak "$1" die een eindddatum heeft over $2 {{PLURAL:$2|dag|dagen}}.

$3',
	'semantictasks-text-message' => 'Hieronder staat een beschrijving van de taak:',
	'semantictasks-diff-message' => 'Hieronder worden de verschillen weergegeven:',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Gunnernett
 */
$messages['nn'] = array(
	'semantictasks-desc' => 'Meldingar via e-post om tildelte eller oppdaterte oppgåver',
	'semantictasks-newtask' => 'Ny oppgåve:',
	'semantictasks-taskupdated' => 'Oppgåva oppdatert:',
	'semantictasks-assignedtoyou-msg2' => 'Oppgåva «$1» har nett vorten gjeve til deg',
	'semantictasks-updatedtoyou-msg2' => 'Oppgåva «$1» har nett vorte oppdatert.',
	'semantictasks-reminder' => 'Påminning:',
	'semantictasks-text-message' => 'Her er ei skildring av oppgåva:',
	'semantictasks-diff-message' => 'Her er skilnadane:',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Event
 * @author Nghtwlkr
 */
$messages['no'] = array(
	'semantictasks-desc' => 'Meldinger via e-post om tildelte eller oppdaterte oppgaver',
	'semantictasks-newtask' => 'Ny oppgave:',
	'semantictasks-taskassigned' => 'Oppgave tildelt:',
	'semantictasks-taskupdated' => 'Oppgave oppdatert:',
	'semantictasks-taskclosed' => 'Oppgave lukket:',
	'semantictasks-newtask-msg' => 'Oppgaven «$1» har nettopp blitt opprettet.',
	'semantictasks-taskclosed-msg' => 'Oppgaven «$1» har nettopp blitt lukket.',
	'semantictasks-assignedtoyou-msg2' => 'Oppgaven «$1» har nettopp blitt tildelt deg',
	'semantictasks-updatedtoyou-msg2' => 'Oppgaven «$1» har nettopp blitt oppdatert.',
	'semantictasks-reminder' => 'Påminnelse:',
	'semantictasks-reminder-message2' => 'Minner deg bare på at oppgaven «$1» avsluttes om {{PLURAL:$2|én dag|$2 dager}}.

$3',
	'semantictasks-text-message' => 'Her er oppgavebeskrivelsen:',
	'semantictasks-diff-message' => 'Her er forskjellene:',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'semantictasks-desc' => 'Notificacions per corrièr electronic pels prètzfaches assignats o meses a jorn',
	'semantictasks-newtask' => 'Prètzfach novèl :',
	'semantictasks-taskassigned' => 'Prètzfach assignat :',
	'semantictasks-taskupdated' => 'Prètzfach mes a jorn :',
	'semantictasks-taskclosed' => 'Prètzfach tampat :',
	'semantictasks-newtask-msg' => "Lo prètzfach « $1 » ven d'èsser creat.",
	'semantictasks-taskclosed-msg' => "Lo prètzfach « $1 » ven d'èsser tampat.",
	'semantictasks-assignedtoyou-msg2' => 'Lo prètzfach "$1" vos es estat assignat.',
	'semantictasks-updatedtoyou-msg2' => 'Lo prètzfach "$1" es estat mes a jorn.',
	'semantictasks-reminder' => 'Rampèl :',
	'semantictasks-reminder-message2' => "Vos rapelam que lo prètzfach « $1 » s'acaba dins $2 {{PLURAL:$2|jorn|jorns}}.

$3",
	'semantictasks-text-message' => 'Vaquí la descripcion del prètzfach :',
	'semantictasks-diff-message' => 'Las diferéncias son listadas çaijós :',
);

/** Polish (Polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'semantictasks-desc' => 'Powiadomienie e‐mailem o przypisaniu lub aktualizacji zadań',
	'semantictasks-newtask' => 'Nowe zadanie',
	'semantictasks-taskassigned' => 'Zadanie przydzielone',
	'semantictasks-taskupdated' => 'Zadanie zaktualizowane',
	'semantictasks-taskclosed' => 'Zadanie zamknięte',
	'semantictasks-newtask-msg' => 'Zadanie „$1” zostało utworzone.',
	'semantictasks-taskclosed-msg' => 'Zadanie „$1” zostało usunięte.',
	'semantictasks-assignedtoyou-msg2' => 'Przydzielono Ci zadanie „$1”',
	'semantictasks-updatedtoyou-msg2' => 'Zadanie „$1” zostało zaktualizowane.',
	'semantictasks-reminder' => 'Przypomnienie',
	'semantictasks-reminder-message2' => 'Przypominamy, że na realizację zadania „$1” {{PLURAL:$2|pozostał|pozostało}} $2 {{PLURAL:$2|dzień|dni}}.

$3',
	'semantictasks-text-message' => 'Poniżej znajduje się opis zadania.',
	'semantictasks-diff-message' => 'Różnice:',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'semantictasks-desc' => 'Notìfiche e-mail për travaj assignà o modificà',
	'semantictasks-newtask' => 'Neuv travaj:',
	'semantictasks-taskassigned' => 'Atività assignà:',
	'semantictasks-taskupdated' => 'Travaj modificà:',
	'semantictasks-taskclosed' => 'Travaj livrà:',
	'semantictasks-newtask-msg' => 'L\'atività "$1" a l\'é pen-e stàita creà.',
	'semantictasks-taskclosed-msg' => 'Ël travaj "$1" a l\'é pen-a stàit livrà.',
	'semantictasks-assignedtoyou-msg2' => 'Ël travaj "$1" a l\'é stàit pen-e asignà a ti',
	'semantictasks-updatedtoyou-msg2' => 'Ël travaj "$1" a l\'é pen-e stàit modificà.',
	'semantictasks-reminder' => 'Da arcordé:',
	'semantictasks-reminder-message2' => 'Mach për arcordete che ël travaj "$1" a finiss an $2 {{PLURAL:$2|di|di}}.

$3',
	'semantictasks-text-message' => 'Sì a-i é na descrission dël travaj:',
	'semantictasks-diff-message' => 'Sì a-i son le diferense:',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'semantictasks-newtask' => 'نوې دنده:',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 * @author Waldir
 */
$messages['pt'] = array(
	'semantictasks-desc' => 'Notificações por correio electrónico das tarefas atribuídas ou actualizadas',
	'semantictasks-newtask' => 'Nova tarefa:',
	'semantictasks-taskassigned' => 'Tarefa atribuída:',
	'semantictasks-taskupdated' => 'Tarefa actualizada:',
	'semantictasks-taskclosed' => 'Tarefa fechada:',
	'semantictasks-newtask-msg' => 'A tarefa "$1" acaba de ser criada.',
	'semantictasks-taskclosed-msg' => 'A tarefa "$1" acaba de ser fechada.',
	'semantictasks-assignedtoyou-msg2' => 'A tarefa "$1" acaba de lhe ser atribuída',
	'semantictasks-updatedtoyou-msg2' => 'A tarefa "$1" acaba de ser actualizada.',
	'semantictasks-reminder' => 'Nota:',
	'semantictasks-reminder-message2' => 'Só para lembrar que a tarefa "$1" acaba em $2 {{PLURAL:$2|dia|dias}}.

$3',
	'semantictasks-text-message' => 'Aqui está a descrição da tarefa:',
	'semantictasks-diff-message' => 'Aqui estão as diferenças:',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Giro720
 * @author Waldir
 */
$messages['pt-br'] = array(
	'semantictasks-desc' => 'Notificações por email de tarefas atribuídas ou atualizadas',
	'semantictasks-newtask' => 'Nova tarefa:',
	'semantictasks-taskassigned' => 'Tarefa atribuída:',
	'semantictasks-taskupdated' => 'Tarefa atualizada:',
	'semantictasks-taskclosed' => 'Tarefa fechada:',
	'semantictasks-newtask-msg' => 'A tarefa "$1" acaba de ser criada.',
	'semantictasks-taskclosed-msg' => 'A tarefa "$1" acaba de ser fechada.',
	'semantictasks-assignedtoyou-msg2' => 'A tarefa "$1" acaba de lhe ser atribuída',
	'semantictasks-updatedtoyou-msg2' => 'A tarefa "$1" acaba de ser atualizada.',
	'semantictasks-reminder' => 'Lembrete:',
	'semantictasks-reminder-message2' => 'Só para lembrar que a tarefa "$1" acaba em $2 {{PLURAL:$2|dia|dias}}.

$3',
	'semantictasks-text-message' => 'Aqui está a descrição da tarefa:',
	'semantictasks-diff-message' => 'Aqui estão as diferenças:',
);

/** Romanian (Română)
 * @author Firilacroco
 * @author KlaudiuMihaila
 */
$messages['ro'] = array(
	'semantictasks-newtask' => 'Sarcină nouă:',
	'semantictasks-taskupdated' => 'Sarcină actualizată:',
	'semantictasks-assignedtoyou-msg2' => 'Sarcina "$1" tocmai ți-a fost atribuită',
	'semantictasks-updatedtoyou-msg2' => 'Sarcina "$1" tocmai a fost actualizată.',
	'semantictasks-reminder-message2' => 'Doar reamintim faptul că sarcina "$1" se termină peste $2 {{PLURAL:$2|zi|zile}}.

$3',
	'semantictasks-text-message' => 'Aceasta este descrierea sarcinii:',
	'semantictasks-diff-message' => 'Acestea sunt diferențele:',
);

/** Russian (Русский)
 * @author Ferrer
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'semantictasks-desc' => 'Уведомления по электронной почте о принятых или обновлённых задачах',
	'semantictasks-newtask' => 'Новая задача:',
	'semantictasks-taskassigned' => 'Установленная задача:',
	'semantictasks-taskupdated' => 'Задача обновлена:',
	'semantictasks-taskclosed' => 'Задача закрыта:',
	'semantictasks-newtask-msg' => 'Задача «$1» была только что создана.',
	'semantictasks-taskclosed-msg' => 'Задача «$1» только что была закрыта.',
	'semantictasks-assignedtoyou-msg2' => 'Вам была только что определена задача «$1»',
	'semantictasks-updatedtoyou-msg2' => 'Задача «$1» только что была обновлена.',
	'semantictasks-reminder' => 'Напоминание:',
	'semantictasks-reminder-message2' => 'Напоминаем, что задача «$1» завершается через $2 {{PLURAL:$2|день|дня|дней}}.

$3',
	'semantictasks-text-message' => 'Здесь описание задачи:',
	'semantictasks-diff-message' => 'Здесь различия:',
);

/** Rusyn (Русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'semantictasks-newtask' => 'Нова задача:',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'semantictasks-desc' => 'Upozornenia emailom na pridelené a aktualizované úlohy',
	'semantictasks-newtask' => 'Nová úloha:',
	'semantictasks-taskupdated' => 'Aktualizovaná úloha:',
	'semantictasks-assignedtoyou-msg2' => 'Práve vám bola pridelená úloha „$1“.',
	'semantictasks-updatedtoyou-msg2' => 'Práve bola aktualizovaná úloha „$1“.',
	'semantictasks-reminder' => 'Pripomienka:',
	'semantictasks-reminder-message2' => 'Toto je iba pripomenutie, že úloha „$1“ končí o $2 {{PLURAL:$2|deň|dni|dní}}.

$3',
	'semantictasks-text-message' => 'Toto je popis úlohy:',
	'semantictasks-diff-message' => 'Toto sú rozdiely:',
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬)
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'semantictasks-newtask' => 'Нови задатак:',
	'semantictasks-taskassigned' => 'Задатак додељен:',
	'semantictasks-taskupdated' => 'Задатак ажуриран:',
	'semantictasks-taskclosed' => 'Задатак затворен:',
	'semantictasks-text-message' => 'Овде је опис задатка:',
	'semantictasks-diff-message' => 'Овде су разлике:',
);

/** Serbian (Latin script) (‪Srpski (latinica)‬)
 * @author Michaello
 */
$messages['sr-el'] = array(
	'semantictasks-newtask' => 'Novi zadatak:',
	'semantictasks-taskassigned' => 'Zadatak dodeljen:',
	'semantictasks-taskupdated' => 'Zadatak ažuriran:',
	'semantictasks-taskclosed' => 'Zadatak zatvoren:',
	'semantictasks-text-message' => 'Ovde je opis zadatka:',
	'semantictasks-diff-message' => 'Ovde su razlike:',
);

/** Swedish (Svenska)
 * @author Fluff
 * @author Per
 */
$messages['sv'] = array(
	'semantictasks-desc' => 'E-postmeddelanden för tilldelade eller uppdaterade uppgifter',
	'semantictasks-newtask' => 'Ny uppgift:',
	'semantictasks-taskupdated' => 'Uppgiften uppdaterad:',
	'semantictasks-taskclosed' => 'Uppgiften avslutad:',
	'semantictasks-newtask-msg' => 'Uppgiften "$1" har just skapats.',
	'semantictasks-assignedtoyou-msg2' => 'Uppgiften "$1" har just tilldelats till dig',
	'semantictasks-updatedtoyou-msg2' => 'Uppgiften "$1" har precis uppdaterats.',
	'semantictasks-reminder' => 'Påminnelse:',
	'semantictasks-reminder-message2' => 'Ett meddelande för att påminna dig om uppgiften "$1" som slutar om {{PLURAL:$2|en dag|$2 dagar}}.

$3',
	'semantictasks-text-message' => 'Här är uppgiftsbeskrivningen:',
	'semantictasks-diff-message' => 'Här är skillnaden:',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'semantictasks-desc' => 'అప్పగించిన లేదా తాజాకరించిన పనుల యొక్క ఈ-మెయిలు గమనింపులు',
	'semantictasks-newtask' => 'కొత్త పని:',
	'semantictasks-taskupdated' => 'పనిని తాజాకరించారు:',
	'semantictasks-assignedtoyou-msg2' => '"$1" పనిని ఇప్పుడే మీకు అప్పగించారు',
	'semantictasks-updatedtoyou-msg2' => '"$1" పనిని ఇప్పుడే తాజాకరించారు.',
	'semantictasks-text-message' => 'పని వివరణ ఇదిగో:',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'semantictasks-desc' => 'Patalastas sa pamamagitan ng e-liham para sa mga gawaing itinalaga o isinapanahon',
	'semantictasks-newtask' => 'Bagong gawain:',
	'semantictasks-taskassigned' => 'Itinalagang gawain:',
	'semantictasks-taskupdated' => 'Isinapanahong gawain:',
	'semantictasks-taskclosed' => 'Naisarang gawain:',
	'semantictasks-newtask-msg' => 'Kalilikha pa lamang ng gawaing "$1".',
	'semantictasks-taskclosed-msg' => 'Naisara na ang gawaing "$1".',
	'semantictasks-assignedtoyou-msg2' => 'Katatalaga pa lamang sa iyo ng gawaing "$1".',
	'semantictasks-updatedtoyou-msg2' => 'Kasasapanahon lamang ng gawaing "$1".',
	'semantictasks-reminder' => 'Paalala:',
	'semantictasks-reminder-message2' => 'Paalala lamang sa iyo na ang gawaing "$1" ay magtatapos na sa loob ng $2 {{PLURAL:$2|araw|mga araw}}.

$3',
	'semantictasks-text-message' => 'Narito ang paglalarawan ng gawain:',
	'semantictasks-diff-message' => 'Narito ang mga pagkakaiba:',
);

/** Turkish (Türkçe)
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'semantictasks-newtask' => 'Yeni görev:',
	'semantictasks-taskupdated' => 'Görev güncellendi:',
	'semantictasks-reminder' => 'Hatırlatma:',
	'semantictasks-text-message' => 'Görev tanımı şu şekildedir:',
	'semantictasks-diff-message' => 'Farklılıklar şu şekildedir:',
);

/** Ukrainian (Українська)
 * @author Тест
 */
$messages['uk'] = array(
	'semantictasks-newtask' => 'Нова завдання:',
	'semantictasks-taskupdated' => 'Завдання оновлено:',
	'semantictasks-taskclosed' => 'Завдання закрито:',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'semantictasks-desc' => 'Thông báo qua thư điện tử khi có nhiệm vụ được giao hoặc cập nhật',
	'semantictasks-newtask' => 'Công việc mới:',
	'semantictasks-taskupdated' => 'Công việc được cập nhật:',
	'semantictasks-assignedtoyou-msg2' => 'Nhiệm vụ “$1” vừa được giao cho bạn',
	'semantictasks-updatedtoyou-msg2' => 'Nhiệm vụ “$1” vừa mới được cập nhật.',
	'semantictasks-reminder' => 'Lời nhắc:',
	'semantictasks-reminder-message2' => 'Thư này chỉ để nhắc bạn rằng nhiệm vụ “$1” sẽ kết thúc trong $2 {{PLURAL:$2|ngày|ngày}} nữa.

$3',
	'semantictasks-text-message' => 'Miêu tả công việc:',
	'semantictasks-diff-message' => 'Các khác biệt:',
);

