<?php
/**
 * Internationalization file for Semantic Internal Objects
 *
 * @file
 * @ingroup Language
 * @ingroup I18n
 * @ingroup SemanticInternalObjects
 */

$messages = array();

/** English
 *  @author Yaron Koren
 */
$messages['en'] = array(
	'semanticinternalobjects-desc' => 'Setting of internal objects in Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Internal property',
);

/** Message documentation (Message documentation)
 * @author Yaron Koren
 */
$messages['qqq'] = array(
	'semanticinternalobjects-desc' => '{{desc}}',
	'semanticinternalobjects-internalproperty' => 'A semantic property stored internally in the page',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'semanticinternalobjects-desc' => 'Vendosja e objekteve të brendshëm në Semantic MediaWiki',
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'semanticinternalobjects-desc' => 'ضبط الأشياء الداخلية في ميدياويكي الدلالي',
);

/** Asturian (Asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'semanticinternalobjects-desc' => "Definición d'oxetos internos en Semantic MediaWiki",
	'semanticinternalobjects-internalproperty' => 'Propiedá interna',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Zedlik
 */
$messages['be-tarask'] = array(
	'semanticinternalobjects-desc' => "Налады ўнутраных аб'ектаў у Semantic MediaWiki",
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'semanticinternalobjects-desc' => 'Kefluniadur traezoù diabarzh e Semanctic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Perzh diabarzh',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'semanticinternalobjects-desc' => 'Postavljanje unutrašnjih objekata u Semantic MediaWiki',
);

/** Catalan (Català)
 * @author Toniher
 */
$messages['ca'] = array(
	'semanticinternalobjects-desc' => "Definició d'objectes interns en el Semantic MediaWiki",
	'semanticinternalobjects-internalproperty' => 'Propietat interna',
);

/** German (Deutsch)
 * @author Imre
 * @author Kghbln
 */
$messages['de'] = array(
	'semanticinternalobjects-desc' => 'Ermöglicht das Definieren interner semantischer Datenobjekte',
	'semanticinternalobjects-internalproperty' => 'Internes Attribut',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'semanticinternalobjects-desc' => 'Nastajenje internych objektow w Semantic MediaWiki',
);

/** Greek (Ελληνικά)
 * @author Omnipaedista
 */
$messages['el'] = array(
	'semanticinternalobjects-desc' => 'Ρυθμίσεις εσωτερικών αντικειμένων στη Σημασιολογική MediaWiki',
);

/** Spanish (Español)
 * @author Crazymadlover
 */
$messages['es'] = array(
	'semanticinternalobjects-desc' => 'Configuración de objetos internos en Semantic MediaWiki',
);

/** Finnish (Suomi)
 * @author Centerlink
 * @author Crt
 */
$messages['fi'] = array(
	'semanticinternalobjects-desc' => 'Sisäisten objektien asetukset semanttisessa MediaWikissä.',
);

/** French (Français)
 * @author Crochet.david
 * @author Gomoko
 */
$messages['fr'] = array(
	'semanticinternalobjects-desc' => 'Réglage des objets internes dans Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Propriété interne',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'semanticinternalobjects-internalproperty' => 'Propriètât de dedens',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'semanticinternalobjects-desc' => 'Configuracións de obxectos internos en Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Propiedade interna',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'semanticinternalobjects-desc' => 'Intärni Objäkt in Semantic MediaWiki yysetze',
	'semanticinternalobjects-internalproperty' => 'Interns Attribut',
);

/** Hebrew (עברית)
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'semanticinternalobjects-desc' => 'הגדרות העצמים הפנימיים במדיה־ויקי הסמנטי',
);

/** Hiligaynon (Ilonggo)
 * @author Tagimata
 */
$messages['hil'] = array(
	'semanticinternalobjects-desc' => 'Pagplastar sang internal na mga bagay sa Semantik MedyaWiki',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'semanticinternalobjects-desc' => 'Nastajenje internych objektow w Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Interna kajkosć',
);

/** Hungarian (Magyar)
 * @author Dj
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'semanticinternalobjects-desc' => 'Belső objektumok beállítása a szemantikus MediaWikiben',
	'semanticinternalobjects-internalproperty' => 'Belső tulajdonság',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'semanticinternalobjects-desc' => 'Configuration de objectos interne in Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Proprietate interne',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 */
$messages['id'] = array(
	'semanticinternalobjects-desc' => 'Seting untuk objek internal pada Semantic MediaWiki',
);

/** Italian (Italiano)
 * @author Gianfranco
 */
$messages['it'] = array(
	'semanticinternalobjects-desc' => 'Configurazione degli oggetti interni in Semantic MediaWiki',
);

/** Japanese (日本語)
 * @author Fryed-peach
 */
$messages['ja'] = array(
	'semanticinternalobjects-desc' => 'Semantic MediaWiki の内部オブジェクトの設定',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'semanticinternalobjects-desc' => 'De ennere Objäkte vum Semantesch MedijaWiki enschtälle.',
	'semanticinternalobjects-internalproperty' => 'Enner Eijeschaff',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'semanticinternalobjects-desc' => 'Astellung vun internen Objeten a Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Intern Eegeschaft',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'semanticinternalobjects-desc' => 'Задавање на внатрешни објекти во Семантички МедијаВики',
	'semanticinternalobjects-internalproperty' => 'Внатрешно својство',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'semanticinternalobjects-desc' => 'Penetapan objek dalaman di Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Harta dalaman',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Event
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'semanticinternalobjects-desc' => 'Innstilling for interne objekter i Semantic MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Intern egenskap',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'semanticinternalobjects-desc' => 'Interne objecten in Semantic MediaWiki instellen',
	'semanticinternalobjects-internalproperty' => 'Interne eigenschap',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'semanticinternalobjects-desc' => 'Reglatge dels objèctes intèrnes dins Semantic MediaWiki',
);

/** Polish (Polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'semanticinternalobjects-desc' => 'Ustawianie wewnętrznych obiektów Semantic MediaWiki.',
);

/** Piedmontese (Piemontèis)
 * @author Dragonòt
 */
$messages['pms'] = array(
	'semanticinternalobjects-desc' => "Ampostassion d'oget intern an drinta a Semantic MediaWiki",
	'semanticinternalobjects-internalproperty' => 'Proprietà anterna',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 * @author Indech
 */
$messages['pt'] = array(
	'semanticinternalobjects-desc' => 'Configuração de objetos internos no MediaWiki Semântico',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 */
$messages['pt-br'] = array(
	'semanticinternalobjects-desc' => 'Definição de objetos internos no Semantic MediaWiki',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'semanticinternalobjects-desc' => "'Mboste le oggette inderne jndr'à MediaUicchi Semandiche",
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'semanticinternalobjects-desc' => 'Установка внутренних объектов в Semantic MediaWiki',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'semanticinternalobjects-desc' => 'Nastavenie vnútorných objektov v Semantic MediaWiki',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 * @author Lesko987
 */
$messages['sl'] = array(
	'semanticinternalobjects-desc' => 'Nastavitev notranjih predmetov v semantičnem MediaWiki',
	'semanticinternalobjects-internalproperty' => 'Notranja lastnina',
);

/** Swedish (Svenska)
 * @author Per
 */
$messages['sv'] = array(
	'semanticinternalobjects-desc' => 'Inställning för interna objekt i Semantic MediaWiki',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'semanticinternalobjects-desc' => 'Pagtatakda ng panloob na mga bagay sa Semantic MediaWiki',
);

/** Turkish (Türkçe)
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'semanticinternalobjects-desc' => "Anlamsal MediaWiki'deki iç nesnelerin ayarlanması",
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'semanticinternalobjects-desc' => 'Thiết kế các đối tượng nội bộ trong Semantic MediaWiki',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Liangent
 */
$messages['zh-hans'] = array(
	'semanticinternalobjects-desc' => '在语义MediaWiki中设置内部对象',
);

/** Traditional Chinese (‪中文(繁體)‬) */
$messages['zh-hant'] = array(
	'semanticinternalobjects-desc' => '在語義MediaWiki中設置內部對象',
);

