<?php

/**
 * Internationalization file for the 'Arrays' extension.
 *
 * @since 1.3.4
 *
 * @file Arrays.i18n.php
 * @ingroup Arrays
 *
 * @licence MIT License
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */

$messages = array();

/** English
 * @author Jeroen De Dauw
 */
$messages['en'] = array(
	'arrays-desc' => 'Store and compute named arrays',
);

/** Message documentation (Message documentation)
 * @author Purodha
 * @author Raymond
 */
$messages['qqq'] = array(
	'arrays-desc' => '{{desc}}',
);

/** Arabic (العربية)
 * @author Ciphers
 */
$messages['ar'] = array(
	'arrays-desc' => 'تخزين وحساب مصفوفات مسماة',
);

/** Asturian (Asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'arrays-desc' => 'Almacenar y calcular matrices con nome',
);

/** Bashkir (Башҡортса)
 * @author Assele
 */
$messages['ba'] = array(
	'arrays-desc' => 'Исемләнгән массивтарҙы һаҡлау һәм иҫәпләү',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 */
$messages['be-tarask'] = array(
	'arrays-desc' => 'Захаваньне і вылічэньне масіваў з назвамі',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'arrays-desc' => 'Enrollañ ha plediñ gant an taolennoù anvet',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'arrays-desc' => 'Sačuvaj i izračunaj imenovane nizove',
);

/** Welsh (Cymraeg)
 * @author Pwyll
 */
$messages['cy'] = array(
	'arrays-desc' => "Storio a chyfrifo trefnau wedi'u henwi",
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'arrays-desc' => 'Ermöglicht das Speichern und Nutzen definierter Datenreihen (Arrays)',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'arrays-desc' => 'Zmóžnja składowanje a woblicenje pomjenjonych pólowych wariablow',
);

/** French (Français)
 * @author Wyz
 */
$messages['fr'] = array(
	'arrays-desc' => 'Enregistrer et traiter les tableaux nommés',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'arrays-desc' => 'Encartar et trètar los tablôs apelâs',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'arrays-desc' => 'Almacenar e calcular táboas con nomes',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'arrays-desc' => 'Macht s Spychere un Nutze vu definierte Datezylete megli',
);

/** Hebrew (עברית)
 * @author Amire80
 */
$messages['he'] = array(
	'arrays-desc' => 'אחסון וחישוב של מערכים בעלי שמות',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'arrays-desc' => 'Pomjenowane polowe wariable składować a wobličić',
);

/** Hungarian (Magyar)
 * @author Dj
 */
$messages['hu'] = array(
	'arrays-desc' => 'Nevesített tömbök tárolása és számítása',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'arrays-desc' => 'Immagazinar e computar arrays nominate',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 */
$messages['id'] = array(
	'arrays-desc' => 'Menyimpan dan menghitung larik bernama',
);

/** Italian (Italiano)
 * @author Beta16
 */
$messages['it'] = array(
	'arrays-desc' => 'Memorizza e calcola matrici di nomi',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'arrays-desc' => 'Felder met Name berääschne un faßhallde.',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'arrays-desc' => 'Späicheren a Benotze vun definéierten Tabellen',
);

/** Lithuanian (Lietuvių)
 * @author Ignas693
 */
$messages['lt'] = array(
	'arrays-desc' => 'Saugoti ir apskaičiuoti pavadintas masyvai',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'arrays-desc' => 'Складирај и пресметај именувани низи',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'arrays-desc' => 'Menyimpan dan mengira tatasusunan bernama',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'arrays-desc' => 'Benoemde verzamelingen opslaan en berekenen',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Nghtwlkr
 */
$messages['no'] = array(
	'arrays-desc' => 'Lagre og beregne navngitte tabeller',
);

/** Polish (Polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'arrays-desc' => 'Przechowywanie i przeliczanie nazwanych tabel',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'arrays-desc' => 'Memorisé e calcolé le tàule nominà',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'arrays-desc' => 'Armazenar e calcular matrizes designadas',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Giro720
 */
$messages['pt-br'] = array(
	'arrays-desc' => 'Armazenar e calcular matrizes designadas',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'arrays-desc' => 'Stipe e calcole le array nomenate',
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'arrays-desc' => 'Хранение и вычисление именованных массивов',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'arrays-desc' => 'Shrani in izračuna imenovana polja',
);

/** Swedish (Svenska)
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'arrays-desc' => 'Lagra och beräkna namngivna arrayer',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'arrays-desc' => 'Itabi at tuusin ang pinangalanang mga hanay',
);

/** Turkish (Türkçe)
 * @author Khutuck
 */
$messages['tr'] = array(
	'arrays-desc' => 'İsimlendirilmiş dizileri sakla ve hsapla',
);

/** Ukrainian (Українська)
 * @author Sodmy
 */
$messages['uk'] = array(
	'arrays-desc' => 'Зберігання та обчислення іменованих масивів',
);

/** Veps (Vepsan kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'arrays-desc' => 'Varata da lugeda nimitadud massivad',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Hydra
 */
$messages['zh-hans'] = array(
	'arrays-desc' => '存储和计算指定的数组',
);

