<?php
/**
 * Internationalization file for Admin Links
 *
 * @file
 * @ingroup Language
 * @ingroup I18n
 */

$messages = array();

/** English
 * @author Yaron Koren
 */
$messages['en'] = array(
	'adminlinks' => 'Admin links',
	'adminlinks-desc' => 'Adds a [[Special:AdminLinks|special page]] that holds helpful links for administrators',
	'adminlinks_documentation' => '$1 documentation', // NOTE: this is not used by the extension itself, but is used by many of the extensions that hook into it
	'adminlinks_general' => 'General',
	'adminlinks_editsidebar' => 'Edit sidebar',
	'adminlinks_editcss' => 'Edit CSS file',
	'adminlinks_editmainpagename' => 'Edit name of main page',
	'adminlinks_users' => 'Users',
	'adminlinks_createuser' => 'Create a user',
	'adminlinks_browsesearch' => 'Browse and search',
	'adminlinks_importexport' => 'Import and export',
	'right-adminlinks' => 'See the link to [[Special:AdminLinks|Admin links]]',
);

/** Message documentation (Message documentation)
 * @author Bennylin
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author Purodha
 * @author Umherirrender
 */
$messages['qqq'] = array(
	'adminlinks-desc' => '{{desc}}',
	'adminlinks_documentation' => 'The label for a link to documentation for a certain extension, whose name is passed in.
{{Identical|Documentation}}',
	'adminlinks_general' => '{{Identical|General}}',
	'adminlinks_users' => '{{Identical|User}}',
	'right-adminlinks' => '{{doc-right|adminlinks}}',
);

/** толышә зывон (толышә зывон)
 * @author Гусейн
 */
$messages['tly'] = array(
	'adminlinks' => 'Сургунон бо администраторон',
	'adminlinks-desc' => 'Зијод кардејдә [[Special:AdminLinks|хыдмәтә сәһифә]], дыләдә һестыше фәрә сургунон бо администраторон',
	'adminlinks_documentation' => 'Сәнәдон $1',
	'adminlinks_general' => 'Умуми',
	'adminlinks_editsidebar' => 'Јанә сәку сәрост кардеј',
	'adminlinks_editcss' => 'CSS фајли сәрост кардеј',
	'adminlinks_editmainpagename' => 'Јолә сәһифә номи сәрост кардеј',
	'adminlinks_users' => 'Иштирок кардәкәсон',
	'adminlinks_createuser' => 'Иштирок кардәкәси офәјеј',
	'adminlinks_browsesearch' => 'Сәкыштә ијән нәве',
	'adminlinks_importexport' => 'Идхол ијән ихроҹ',
	'right-adminlinks' => 'Виндеј [[Special:AdminLinks|Сургунон бо администраторон]]',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'adminlinks' => 'Skakels vir administrateurs',
	'adminlinks-desc' => "Voeg 'n [[Special:AdminLinks|spesiale bladsy]] met nuttige skakels vir administrateurs by",
	'adminlinks_documentation' => 'Dokumentasie vir $1',
	'adminlinks_general' => 'Algemeen',
	'adminlinks_editsidebar' => 'Wysig kantbalk',
	'adminlinks_editcss' => 'Wysig CSS-lêer',
	'adminlinks_editmainpagename' => 'Wysig naam van die hoofblad',
	'adminlinks_users' => 'Gebruikers',
	'adminlinks_createuser' => "Skep 'n gebruiker",
	'adminlinks_browsesearch' => 'Blaai en deursoek',
	'adminlinks_importexport' => 'Invoer en uitvoer',
	'right-adminlinks' => 'Sien die skakel na die [[Special:AdminLinks|skakels vir administrateurs]]',
);

/** Gheg Albanian (Gegë)
 * @author Bresta
 */
$messages['aln'] = array(
	'adminlinks' => 'Vegzat e administrimit',
	'adminlinks-desc' => 'Shton nji [[Special:AdminLinks|faqe speciale]] që i mban vegzat e nevojshme për administrues',
	'adminlinks_documentation' => '$1 dokumentimi',
	'adminlinks_general' => 'Të përgjithshme',
	'adminlinks_editsidebar' => 'Redakto shtyllën anësore',
	'adminlinks_editcss' => 'Redakto CSSin',
	'adminlinks_editmainpagename' => 'Redakto emnin e faqes kryesore',
	'adminlinks_users' => 'Përdoruesit',
	'adminlinks_createuser' => 'Krijo përdorues',
	'adminlinks_browsesearch' => 'Shfletimi dhe kërkimi',
	'adminlinks_importexport' => 'Importimi dhe eksportimi',
	'right-adminlinks' => 'Shih vegzën te [[Special:AdminLinks|Vegzat e administrimit]]',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'adminlinks' => "Vinclos d'administración",
	'adminlinks-desc' => 'Adhibir una [[Special:AdminLinks|pachina especial]] que mantien vinclos útils ta os administradors',
	'adminlinks_documentation' => 'Documentación $1',
	'adminlinks_general' => 'Cheneral',
	'adminlinks_editsidebar' => 'Editar a barra lateral',
	'adminlinks_editcss' => 'Editar o fichero CSS',
	'adminlinks_editmainpagename' => "Editar o nombre d'a pachina prencipal",
	'adminlinks_users' => 'Usuarios',
	'adminlinks_createuser' => 'Creyar un usuario',
	'adminlinks_browsesearch' => 'Navegar y mirar',
	'adminlinks_importexport' => 'Importar y exportar',
	'right-adminlinks' => 'Se veiga o vinclo ta [[Special:AdminLinks|Admin links]]',
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 */
$messages['ar'] = array(
	'adminlinks' => 'وصلات الإداريين',
	'adminlinks-desc' => 'يضيف [[Special:AdminLinks|صفحة خاصة]] تحتوي وصلات مفيدة للإداريين.',
	'adminlinks_documentation' => 'توثيق $1',
	'adminlinks_general' => 'عام',
	'adminlinks_editsidebar' => 'حرّر الشريط الجانبي',
	'adminlinks_editcss' => 'حرّر ملف CSS',
	'adminlinks_editmainpagename' => 'عدّل اسم الصفحة الرئيسية',
	'adminlinks_users' => 'مستخدمون',
	'adminlinks_createuser' => 'أنشئ مستخدمًا',
	'adminlinks_browsesearch' => 'التصفح والبحث',
	'adminlinks_importexport' => 'الاستيراد والتصدير',
	'right-adminlinks' => 'انظر الوصلة إلى [[Special:AdminLinks|وصلات الإدارة]]',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'adminlinks' => 'ܐܣܘܪ̈ܐ ܕܡܕܒܪ̈ܢܐ',
	'adminlinks_documentation' => '$1 ܐܫܛܪܘܬܐ',
	'adminlinks_general' => 'ܓܘܢܝܐ',
	'adminlinks_users' => 'ܡܦܠܚܢ̈ܐ',
	'adminlinks_importexport' => 'ܡܥܠܢܘܬܐ ܘܡܦܩܢܘܬܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 */
$messages['arz'] = array(
	'adminlinks' => 'وصلات الاداريين',
	'adminlinks-desc' => 'يضيف [[Special:AdminLinks|صفحة خاصة]] وصلات الاداريين',
	'adminlinks_documentation' => 'توثيق $1',
	'adminlinks_general' => 'عام',
	'adminlinks_editcss' => 'عدل ملف CSS',
	'adminlinks_users' => 'يوزرز',
	'adminlinks_createuser' => 'ابتدى يوزر',
);

/** Assamese (অসমীয়া)
 * @author Chaipau
 */
$messages['as'] = array(
	'adminlinks_users' => 'সদস্যসকল',
);

/** Asturian (Asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'adminlinks' => "Enllaces d'alministrador",
	'adminlinks-desc' => 'Amiesta una [[Special:AdminLinks|páxina especial]] que contién enllaces útiles para los alministradores',
	'adminlinks_documentation' => 'Documentación de $1',
	'adminlinks_general' => 'Xeneral',
	'adminlinks_editsidebar' => 'Editar la barra llateral',
	'adminlinks_editcss' => 'Editar el ficheru CSS',
	'adminlinks_editmainpagename' => 'Editar el nome de la páxina principal',
	'adminlinks_users' => 'Usuarios',
	'adminlinks_createuser' => 'Crear un usuariu',
	'adminlinks_browsesearch' => 'Navegación y gueta',
	'adminlinks_importexport' => 'Importación y esportación',
	'right-adminlinks' => "Ver l'enllaz a [[Special:AdminLinks|enllaces d'alministrador]]",
);

/** Azerbaijani (Azərbaycanca)
 * @author Cekli829
 * @author Vago
 */
$messages['az'] = array(
	'adminlinks' => 'İdarəçilər üçün istinadlar',
	'adminlinks_documentation' => '$1 sənədləşməsi',
	'adminlinks_general' => 'Ümumi',
	'adminlinks_editsidebar' => 'Yan paneli redaktə et',
	'adminlinks_editcss' => 'CSS faylını redaktə et',
	'adminlinks_editmainpagename' => 'Baş səhifənin adını dəyişdir',
	'adminlinks_users' => 'İstifadəçilər',
	'adminlinks_importexport' => 'İdxal və ixrac',
);

/** Bashkir (Башҡортса)
 * @author Comp1089
 */
$messages['ba'] = array(
	'adminlinks' => 'Хәкимдәр өсөн һылтанмалар',
	'adminlinks-desc' => 'Хәкимдәр өсөн һылтанмалар индергән [[Special:AdminLinks|ярҙамсы бит]] булдыра',
	'adminlinks_documentation' => '$1 өсөн документация',
	'adminlinks_general' => 'Дөйөм',
	'adminlinks_editsidebar' => 'Ҡабырғалағы меню (Sidebar)-ҙы үҙгәртергә',
	'adminlinks_editcss' => 'CSS-файлды үҙгәртергә',
	'adminlinks_editmainpagename' => 'Баш бит исемен үҙгәртергә',
	'adminlinks_users' => 'Ҡулланыусылар',
	'adminlinks_createuser' => 'Яңы иҫәп яҙыуын булдырырға',
	'adminlinks_browsesearch' => 'Ҡарау һәм әҙләү',
	'adminlinks_importexport' => 'Импорт һәм экспорт',
	'right-adminlinks' => '[[Special:AdminLinks|Хәкимдәр өсөн һылтанмаларҙы]] ҡарарға',
);

/** Bavarian (Boarisch)
 * @author Man77
 * @author Mucalexx
 */
$messages['bar'] = array(
	'adminlinks' => 'Links fyr Administraatorn',
	'adminlinks-desc' => 'Ergänzd a [[Special:AdminLinks|Speziaalseiten]] mid hüfreiche Links fyr Administraatorn',
	'adminlinks_documentation' => 'Dókumentazión voh „$1“',
	'adminlinks_general' => 'Oigmoah',
	'adminlinks_editsidebar' => 'dé Sidebar beorweiten',
	'adminlinks_editcss' => 'CSS-Daatein beorweiten',
	'adminlinks_editmainpagename' => 'an Nåm voh da Hauptseiten beorweiten',
	'adminlinks_users' => 'Benutzer',
	'adminlinks_createuser' => 'Benutzerkóntó erstön',
	'adminlinks_browsesearch' => 'Durchschauh und suacher',
	'adminlinks_importexport' => 'Importiern und Exportiern',
	'right-adminlinks' => '[[Special:AdminLinks|Links für Administraatoren]] hernemmer',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'adminlinks' => 'Спасылкі для адміністратараў',
	'adminlinks-desc' => 'Дадае [[Special:AdminLinks|спэцыяльную старонку]], якая ўтрымлівае спасылкі карысныя для адміністратараў',
	'adminlinks_documentation' => 'Дакумэнтацыя $1',
	'adminlinks_general' => 'Агульныя',
	'adminlinks_editsidebar' => 'Рэдагаваць бакавую панэль',
	'adminlinks_editcss' => 'Рэдагаваць CSS-файл',
	'adminlinks_editmainpagename' => 'Рэдагаваць назву галоўнай старонкі',
	'adminlinks_users' => 'Удзельнікі',
	'adminlinks_createuser' => 'Стварыць рахунак',
	'adminlinks_browsesearch' => 'Агляд і пошук',
	'adminlinks_importexport' => 'Імпартаваньне і экспартаваньне',
	'right-adminlinks' => 'бачыць спасылку на [[Special:AdminLinks|спасылкі для адміністратараў]]',
);

/** Bulgarian (Български)
 * @author DCLXVI
 * @author Stanqo
 */
$messages['bg'] = array(
	'adminlinks' => 'административни препратки',
	'adminlinks-desc' => 'Добавя [[Special:AdminLinks|специална страница]], която съдържа полезни препратки за администраторите',
	'adminlinks_documentation' => '$1 документация',
	'adminlinks_general' => 'Основни',
	'adminlinks_editsidebar' => 'Редактиране на страничната лента',
	'adminlinks_editcss' => 'Редактиране на CSS файл',
	'adminlinks_editmainpagename' => 'Редактиране името на началната страница',
	'adminlinks_users' => 'Потребители',
	'adminlinks_createuser' => 'Създаване на потребител',
	'adminlinks_browsesearch' => 'Разглеждане и търсене',
	'adminlinks_importexport' => 'Внасяне и изнасяне',
	'right-adminlinks' => 'Показване на препратката към [[Special:AdminLinks|Административни препратки]]',
);

/** Banjar (Bahasa Banjar)
 * @author Ezagren
 */
$messages['bjn'] = array(
	'adminlinks_users' => 'Pamuruk',
	'adminlinks_createuser' => 'Ulah pamuruk',
);

/** Bengali (বাংলা)
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'adminlinks' => 'প্রশাসকের সংযোগ',
	'adminlinks-desc' => 'একটি [[Special:AdminLinks|বিশেষ পাতার]] লিংক যোগ করুন, যেখানে প্রশাসকদের জন্য কিছু সাহায্য পাতার লিংক রয়েছে',
	'adminlinks_documentation' => '$1 কার্যকৌশল বিবরণী',
	'adminlinks_general' => 'সাধারণ',
	'adminlinks_editsidebar' => 'সাইডবার সম্পাদনা',
	'adminlinks_editcss' => 'সিএসএস ফাইল সম্পাদনা',
	'adminlinks_editmainpagename' => 'প্রধান পাতার নাম সম্পাদনা করুন',
	'adminlinks_users' => 'ব্যবহারকারী',
	'adminlinks_createuser' => 'ব্যবহারকারী সৃষ্টি',
	'adminlinks_browsesearch' => 'ব্রাউজ ও অনুসন্ধান',
	'adminlinks_importexport' => 'আমদানি ও রপ্তানি',
	'right-adminlinks' => 'সংযোগটি [[Special:AdminLinks|প্রশাসক লিংকে]] দেখুন',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'adminlinks' => 'Liammoù merañ',
	'adminlinks-desc' => 'Ouzhpennañ a ra ur [[Special:AdminLinks|bajenn dibar]] enni liammoù talvoudus evit ar verourien',
	'adminlinks_documentation' => 'teuliadur $1',
	'adminlinks_general' => 'Hollek',
	'adminlinks_editsidebar' => 'Kemmañ ar varrenn gostez',
	'adminlinks_editcss' => 'Kemmañ ar restr CSS',
	'adminlinks_editmainpagename' => 'Kemmañ anv ar bajenn bennañ',
	'adminlinks_users' => 'Implijerien',
	'adminlinks_createuser' => 'Krouiñ un implijer',
	'adminlinks_browsesearch' => 'Furchal ha klask',
	'adminlinks_importexport' => 'Enporzhiañ hag ezporzhiañ',
	'right-adminlinks' => 'Gwelet al liamm war-du [[Special:AdminLinks|liammoù merañ]]',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'adminlinks' => 'Linkovi za admine',
	'adminlinks-desc' => 'Dodaje [[Special:AdminLinks|posebnu stranicu]] koja sadrži korisne linkove za administratore',
	'adminlinks_documentation' => '$1 dokumentacija',
	'adminlinks_general' => 'Općenito',
	'adminlinks_editsidebar' => 'Uredi bočnu alatnu traku',
	'adminlinks_editcss' => 'Uređivanje CSS datoteke',
	'adminlinks_editmainpagename' => 'Uredi naziv početne stranice',
	'adminlinks_users' => 'Korisnici',
	'adminlinks_createuser' => 'Napravi korisnika',
	'adminlinks_browsesearch' => 'Pregledanje i pretraga',
	'adminlinks_importexport' => 'Uvoz i izvoz',
	'right-adminlinks' => 'Pregledavanje linkova u [[Special:AdminLinks|linkovima administratora]]',
);

/** Catalan (Català)
 * @author SMP
 * @author Solde
 */
$messages['ca'] = array(
	'adminlinks' => "Enllaços d'administració",
	'adminlinks-desc' => 'Afegeix una [[Special:AdminLinks|pàgina especial]] que manté enllaços útils per als administradors',
	'adminlinks_documentation' => 'documentació $1',
	'adminlinks_general' => 'General',
	'adminlinks_editsidebar' => 'Edita la barra lateral',
	'adminlinks_editcss' => 'Edita el fitxer CSS',
	'adminlinks_editmainpagename' => 'Edita el nom de la pàgina principal',
	'adminlinks_users' => 'Usuaris',
	'adminlinks_createuser' => 'Crea un usuari',
	'adminlinks_browsesearch' => "S'està navegant i buscant",
	'adminlinks_importexport' => "S'està important i exportant",
	'right-adminlinks' => "Veure l'enllaç a [[Special:AdminLinks|enllaços d'administrador]]",
);

/** Chechen (Нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'adminlinks' => 'Хьажоригаш адманкуьйгалхошна',
	'adminlinks-desc' => 'Тlе туху [[Special:AdminLinks|белхан агlо]], йолуш пайде хьажоригаш адманкуьйгалхошна',
	'adminlinks_documentation' => 'хааманбаххаш $1',
	'adminlinks_general' => 'Еригге',
	'adminlinks_editsidebar' => 'Нисйе агlон тlийра чоь',
	'adminlinks_editcss' => 'Нисйе CSS хlум',
	'adminlinks_editmainpagename' => 'Нисйе коьрта агlон цlе',
	'adminlinks_users' => 'Декъашхой',
	'adminlinks_createuser' => 'Кхолла дlавазвалар',
	'adminlinks_browsesearch' => 'Гуш а лахар',
	'adminlinks_importexport' => 'Чуйахар а арайахар',
	'right-adminlinks' => 'гарна [[Special:AdminLinks|хьажоригаш адманкуьйгалхошна]]',
);

/** Czech (Česky)
 * @author Kuvaly
 * @author Reaperman
 */
$messages['cs'] = array(
	'adminlinks' => 'Odkazy pro správce',
	'adminlinks-desc' => 'Přidává [[Special:AdminLinks|speciální stránku]] s užitečnými odkazy pro správce',
	'adminlinks_documentation' => 'Dokumentace pro $1',
	'adminlinks_general' => 'Obecné',
	'adminlinks_editsidebar' => 'Upravit postranní panel',
	'adminlinks_editcss' => 'Upravit globální CSS',
	'adminlinks_editmainpagename' => 'Upravit název hlavní stránky',
	'adminlinks_users' => 'Uživatelé',
	'adminlinks_createuser' => 'Vytvořit uživatelský účet',
	'adminlinks_browsesearch' => 'Prohlížení a vyhledávání',
	'adminlinks_importexport' => 'Import a export stránek',
	'right-adminlinks' => 'Viditelný odkaz na stránku [[Special:AdminLinks|Odkazy pro správce]]',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'adminlinks' => "Cysylltau'r gweinyddwyr",
	'adminlinks-desc' => "Yn ychwanegu [[Special:AdminLinks|tudalen arbennig]] ar gyfer gweinyddwyr sy'n dangos cysylltiadau defnyddiol iddynt",
	'adminlinks_documentation' => 'gwybodaeth am $1',
	'adminlinks_general' => 'Cyffredinol',
	'adminlinks_editsidebar' => "Golygu'r panel llywio",
	'adminlinks_editcss' => "Golygu'r ffeil CSS",
	'adminlinks_editmainpagename' => "Golygu enw'r hafan",
	'adminlinks_users' => 'Defnyddwyr',
	'adminlinks_createuser' => 'Creu cyfrif defnyddiwr',
	'adminlinks_browsesearch' => 'Pori a chwilio',
	'adminlinks_importexport' => 'Mewnforio ac allforio',
	'right-adminlinks' => "Gallu gweld y cyswllt at [[Special:AdminLinks|Cysylltau'r gweinyddwyr]]",
);

/** Danish (Dansk)
 * @author Masz
 */
$messages['da'] = array(
	'adminlinks' => 'Administrationslinks',
	'adminlinks-desc' => 'Tilføjer en [[Special:AdminLinks|specialside]], som indeholder nyttige links for administratorer.',
	'adminlinks_documentation' => 'dokumentation for $1',
	'adminlinks_general' => 'Generelt',
	'adminlinks_editsidebar' => 'Redigér sidemenuen',
	'adminlinks_editcss' => 'Redigér CSS-fil',
	'adminlinks_editmainpagename' => 'Ændre navnet på forsiden',
	'adminlinks_users' => 'Brugere',
	'adminlinks_createuser' => 'Opret en bruger',
	'adminlinks_browsesearch' => 'Navigering og søgning',
	'adminlinks_importexport' => 'Importering og eksportering',
	'right-adminlinks' => 'Se linket til [[Special:AdminLinks|administrationslinkene]]',
);

/** German (Deutsch)
 * @author Kghbln
 * @author Purodha
 * @author Umherirrender
 */
$messages['de'] = array(
	'adminlinks' => 'Links für Administratoren',
	'adminlinks-desc' => 'Ergänzt eine [[Special:AdminLinks|Spezialseite]] mit hilfreichen Links für Administratoren',
	'adminlinks_documentation' => 'Dokumentation zu „$1“',
	'adminlinks_general' => 'Allgemein',
	'adminlinks_editsidebar' => 'Seitenleiste bearbeiten',
	'adminlinks_editcss' => 'CSS bearbeiten',
	'adminlinks_editmainpagename' => 'Namen der Hauptseite bearbeiten',
	'adminlinks_users' => 'Benutzer',
	'adminlinks_createuser' => 'Benutzerkonto anlegen',
	'adminlinks_browsesearch' => 'Durchsehen und Suchen',
	'adminlinks_importexport' => 'Importieren und Exportieren',
	'right-adminlinks' => '[[Special:AdminLinks|Links für Administratoren]] nutzen',
);

/** Zazaki (Zazaki)
 * @author Mirzali
 */
$messages['diq'] = array(
	'adminlinks_users' => 'Karberi',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'adminlinks' => 'Wótkaze za administratorow',
	'adminlinks-desc' => 'Pśidawa [[Special:AdminLinks|specialny bok]] z pomocniwymi wótkazami za administratorow',
	'adminlinks_documentation' => '$1 dokumentacija',
	'adminlinks_general' => 'Powšykny',
	'adminlinks_editsidebar' => 'Bocnu kšomu wobźěłaś',
	'adminlinks_editcss' => 'Dataju CSS wobźěłaś',
	'adminlinks_editmainpagename' => 'Mě głownego boka wobźěłaś',
	'adminlinks_users' => 'Wužywarje',
	'adminlinks_createuser' => 'Wužywarja napóraś',
	'adminlinks_browsesearch' => 'Pśeglědowanje a pytanje',
	'adminlinks_importexport' => 'Importěrowanje a eksportěrowanje',
	'right-adminlinks' => 'Glědaj wótkaz k [[Special:AdminLinks|wótkazam za administratorow]]',
);

/** Central Dusun (Dusun Bundu-liwan)
 * @author FRANCIS5091
 */
$messages['dtp'] = array(
	'adminlinks' => 'Toput mongu-ngulud',
	'adminlinks-desc' => 'Poruhango [[Special:AdminLinks|bolikon suaikowokon]] it minongigit toput kiguno montok momumuruan',
	'adminlinks_documentation' => '$1 gogompipail',
	'adminlinks_general' => 'Gumuan',
	'adminlinks_editsidebar' => 'Idito bardisan',
	'adminlinks_editcss' => 'Idito pail CSS',
	'adminlinks_editmainpagename' => 'Idito ngaran do bolikon tagayo',
	'adminlinks_users' => 'Momomoguno',
	'adminlinks_createuser' => 'Pomonsoi momoguno',
	'adminlinks_browsesearch' => 'Ansahai om ihumo',
	'adminlinks_importexport' => 'Pingonuon om popingatodo',
	'right-adminlinks' => 'Intaai nopotan [[Special:AdminLinks|Tongotoput Mongu-ngulud]]',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Omnipaedista
 * @author ZaDiak
 */
$messages['el'] = array(
	'adminlinks' => 'Σύνδεσμοι διαχειριστών',
	'adminlinks-desc' => 'Προσθέτει μία [[Special:AdminLinks|ειδική σελίδα]] η οποία περιέχει χρήσιμους συνδέσμους για τους διαχειριστές',
	'adminlinks_documentation' => '$1 τεκμηρίωση',
	'adminlinks_general' => 'Γενικά',
	'adminlinks_editsidebar' => 'Επεξεργασία πλαϊνής μπάρας',
	'adminlinks_editcss' => 'Επεξεργασία αρχείου CSS',
	'adminlinks_editmainpagename' => 'Επεξεργασία ονόματος της κύριας σελίδας',
	'adminlinks_users' => 'Χρήστες',
	'adminlinks_createuser' => 'Δημιουργία χρήστη',
	'adminlinks_browsesearch' => 'Πλοήγηση και αναζήτηση',
	'adminlinks_importexport' => 'Εισαγωγή και εξαγωγή',
	'right-adminlinks' => 'Δείτε τον σύνδεσμο στους [[Special:AdminLinks|Διαχειριστικούς Συνδέσμους]]',
);

/** Esperanto (Esperanto)
 * @author Jagwar
 * @author Yekrats
 */
$messages['eo'] = array(
	'adminlinks' => 'Ligiloj por administrantoj',
	'adminlinks-desc' => 'Aldonos [[Special:AdminLinks|specialan paĝon]] kiu enhavas helpemajn ligilojn por administrantoj',
	'adminlinks_documentation' => '$1 dokumentaro',
	'adminlinks_general' => 'Ĝenerala',
	'adminlinks_editsidebar' => 'eldoni iltrabon',
	'adminlinks_editcss' => 'eldoni dosieron CSS',
	'adminlinks_editmainpagename' => 'Redakti nomon de ĉefpaĝo',
	'adminlinks_users' => 'uzantoj',
	'adminlinks_createuser' => 'krei uzanton',
	'adminlinks_browsesearch' => 'Tralego kaj Serĉo',
	'adminlinks_importexport' => 'Importi kaj Eksporti',
	'right-adminlinks' => 'Vidi ligilon al [[Special:AdminLinks|Administranto-ligilojn]]',
);

/** Spanish (Español)
 * @author Crazymadlover
 * @author Locos epraix
 */
$messages['es'] = array(
	'adminlinks' => 'Administrar vínculos',
	'adminlinks-desc' => 'Añade una [[Special:AdminLinks|página especial]] con enlaces útiles para administradores',
	'adminlinks_documentation' => 'documentación de $1',
	'adminlinks_general' => 'General',
	'adminlinks_editsidebar' => 'Editar barra lateral',
	'adminlinks_editcss' => 'Editar archivo CSS',
	'adminlinks_editmainpagename' => 'Editar nombre de página principal',
	'adminlinks_users' => 'Usuarios',
	'adminlinks_createuser' => 'Crear un usuario',
	'adminlinks_browsesearch' => 'Exploración y búsqueda',
	'adminlinks_importexport' => 'Importación y exportación',
	'right-adminlinks' => 'Ver el vínculo a [[Special:AdminLinks|Administrar vínculos]]',
);

/** Estonian (Eesti)
 * @author Avjoska
 * @author Pikne
 */
$messages['et'] = array(
	'adminlinks' => 'Administraatori lingid',
	'adminlinks-desc' => 'Lisab [[Special:AdminLinks|erilehekülje]] administraatoritele kasulike linkidega.',
	'adminlinks_users' => 'Kasutajad',
	'adminlinks_createuser' => 'Loo uus kasutaja',
	'right-adminlinks' => 'Näha linki leheküljele [[Special:AdminLinks|administraatori lingid]]',
);

/** Basque (Euskara)
 * @author An13sa
 */
$messages['eu'] = array(
	'adminlinks' => 'Administratzaile loturak',
	'adminlinks_documentation' => '$1 dokumentazioa',
	'adminlinks_general' => 'Orokorra',
	'adminlinks_editsidebar' => 'Ezkerreko barra aldatu',
	'adminlinks_editcss' => 'CSS fitxategia aldatu',
	'adminlinks_editmainpagename' => 'Azalaren izena aldatu',
	'adminlinks_users' => 'Erabiltzaileak',
	'adminlinks_createuser' => 'Lankidea sortu',
	'adminlinks_importexport' => 'Inportatu eta esportatu',
);

/** Persian (فارسی)
 * @author Sahim
 * @author ZxxZxxZ
 */
$messages['fa'] = array(
	'adminlinks' => 'لینک‌های مدیران',
	'adminlinks-desc' => 'اضافه کردن یک [[Special:AdminLinks|صفحه ویژه]] که دارای لینک‌های مفید برای مدیران است',
	'adminlinks_documentation' => '$1 مستند شده',
	'adminlinks_general' => 'عمومی',
	'adminlinks_editsidebar' => 'نوار ویرایش',
	'adminlinks_editcss' => 'ویرایش فایل CSS',
	'adminlinks_editmainpagename' => 'ویرایش نام از طریق صفحه اصلی',
	'adminlinks_users' => 'کاربران',
	'adminlinks_createuser' => 'ساخت یک کاربر',
	'adminlinks_browsesearch' => 'مرور و جستجو',
	'adminlinks_importexport' => 'ورودی و خروجی',
	'right-adminlinks' => 'لینک به [[Special:AdminLinks|لینک‌های مدیران]] را ببینید',
);

/** Finnish (Suomi)
 * @author Crt
 * @author Nike
 * @author Str4nd
 * @author Varusmies
 * @author ZeiP
 */
$messages['fi'] = array(
	'adminlinks' => 'Ylläpidon linkit',
	'adminlinks-desc' => 'Lisää [[Special:AdminLinks|toimintosivun]], joka sisältää hyödyllisiä linkkejä ylläpitäjille.',
	'adminlinks_documentation' => '$1 dokumentaatio',
	'adminlinks_general' => 'Yleinen',
	'adminlinks_editsidebar' => 'Muokkaa sivupalkkia',
	'adminlinks_editcss' => 'Muokkaa CSS-tiedostoa',
	'adminlinks_editmainpagename' => 'Muokkaa etusivun nimeä',
	'adminlinks_users' => 'Käyttäjät',
	'adminlinks_createuser' => 'Luo uusi käyttäjä',
	'adminlinks_browsesearch' => 'Selaaminen ja hakeminen',
	'adminlinks_importexport' => 'Tuonti ja vienti',
	'right-adminlinks' => 'Nähdä linkki sivulle [[Special:AdminLinks|ylläpitäjien linkit]]',
);

/** French (Français)
 * @author IAlex
 */
$messages['fr'] = array(
	'adminlinks' => "Liens d'administration",
	'adminlinks-desc' => 'Ajoute une [[Special:AdminLinks|page spéciale]] qui contient des liens utiles pour les administrateurs',
	'adminlinks_documentation' => 'documentation de $1',
	'adminlinks_general' => 'Général',
	'adminlinks_editsidebar' => 'Modifier la barre latérale',
	'adminlinks_editcss' => 'Modifier le fichier CSS',
	'adminlinks_editmainpagename' => "Modifier le nom de la page d'accueil",
	'adminlinks_users' => 'Utilisateurs',
	'adminlinks_createuser' => 'Créer un utilisateur',
	'adminlinks_browsesearch' => 'Navigation et recherche',
	'adminlinks_importexport' => 'Importer et exporter',
	'right-adminlinks' => "Voir le lien vers [[Special:AdminLinks|liens d'administration]]",
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'adminlinks' => 'Lims d’administracion',
	'adminlinks-desc' => 'Apond una [[Special:AdminLinks|pâge spèciâla]] que contint des lims utilos por los administrators.',
	'adminlinks_documentation' => 'documentacion de $1',
	'adminlinks_general' => 'G·ènèral',
	'adminlinks_editsidebar' => 'Changiér la bârra de fllanc',
	'adminlinks_editcss' => 'Changiér lo fichiér CSS',
	'adminlinks_editmainpagename' => 'Changiér lo nom de la pâge de reçua',
	'adminlinks_users' => 'Usanciérs',
	'adminlinks_createuser' => 'Fâre un usanciér',
	'adminlinks_browsesearch' => 'Navigacion et rechèrche',
	'adminlinks_importexport' => 'Importar et èxportar',
	'right-adminlinks' => 'Vêre lo lim de vers los [[Special:AdminLinks|lims d’administracion]]',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'adminlinks' => 'Ligazóns de administrador',
	'adminlinks-desc' => 'Engade unha [[Special:AdminLinks|páxina especial]] que contén ligazóns útiles para os administradores',
	'adminlinks_documentation' => 'Documentación de $1',
	'adminlinks_general' => 'Xeral',
	'adminlinks_editsidebar' => 'Editar a barra lateral',
	'adminlinks_editcss' => 'Editar o ficheiro CSS',
	'adminlinks_editmainpagename' => 'Editar o nome da páxina principal',
	'adminlinks_users' => 'Usuarios',
	'adminlinks_createuser' => 'Crear un usuario',
	'adminlinks_browsesearch' => 'Navegación e procura',
	'adminlinks_importexport' => 'Importación e exportación',
	'right-adminlinks' => 'Ver a ligazón cara á páxina especial [[Special:AdminLinks|Ligazóns de administrador]]',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'adminlinks_general' => 'Γενικά',
	'adminlinks_users' => 'Χρώμενοι',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'adminlinks' => 'Adminlinks',
	'adminlinks-desc' => 'Fiegt e [[Special:AdminLinks|Spezialsyte]] yy mit hilfryyche Gleicher (Links) fir Ammanne (Adminischtratore).',
	'adminlinks_documentation' => '$1 Dokumäntation',
	'adminlinks_general' => 'Allgmein',
	'adminlinks_editsidebar' => 'Syteleischte bearbeite',
	'adminlinks_editcss' => 'CSS-Datei bearbeite',
	'adminlinks_editmainpagename' => 'Name vu dr Hauptsyte bearbeite',
	'adminlinks_users' => 'Benutzer',
	'adminlinks_createuser' => 'E Benutzer aalege',
	'adminlinks_browsesearch' => 'Browse un Sueche',
	'adminlinks_importexport' => 'Importiere un Exportiere',
	'right-adminlinks' => 'Lueg s Gleich (Link) zue [[Special:AdminLinks|Adminlinks]]',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'adminlinks' => 'Kianglaghyn reirey',
	'adminlinks-desc' => 'Cur [[Special:AdminLinks|duillag er lheh]] rish as ee goaill kianglaghyn coonee da reireyderyn stiagh',
	'adminlinks_documentation' => 'Docamadys $1',
	'adminlinks_general' => 'Cadjin',
	'adminlinks_editsidebar' => 'Reaghey yn çheu-vaidjey',
	'adminlinks_editcss' => 'Reaghey yn coadan CSS',
	'adminlinks_editmainpagename' => 'Reaghey ennym ny preeu-duillag',
	'adminlinks_users' => 'Ymmydeyryn',
	'adminlinks_createuser' => 'Croo ymmydeyr',
	'adminlinks_browsesearch' => 'Femblal as ronsaghey',
	'adminlinks_importexport' => 'Ymmyrkey stiagh as assphurtal',
	'right-adminlinks' => 'Jeeagh er y chiangley dys [[Special:AdminLinks|kianglaghyn reirey]]',
);

/** Hebrew (עברית)
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'adminlinks' => 'קישורים למפעילי מערכת',
	'adminlinks-desc' => 'הוספת [[Special:AdminLinks|דף מיוחד]] המכיל קישורים שימושיים למפעילי מערכת',
	'adminlinks_documentation' => 'התיעוד של $1',
	'adminlinks_general' => 'כללי',
	'adminlinks_editsidebar' => 'עריכת סרגל הצד',
	'adminlinks_editcss' => 'עריכת קובץ CSS',
	'adminlinks_editmainpagename' => 'עריכת שם הדף הראשי',
	'adminlinks_users' => 'משתמשים',
	'adminlinks_createuser' => 'יצירת משתמש',
	'adminlinks_browsesearch' => 'עיון וחיפוש',
	'adminlinks_importexport' => 'ייבוא וייצוא',
	'right-adminlinks' => 'הצגת הקישור לדף [[Special:AdminLinks|קישורים למפעילי מערכת]]',
);

/** Hindi (हिन्दी)
 * @author Kumar
 */
$messages['hi'] = array(
	'adminlinks_general' => 'सामान्य',
	'adminlinks_editsidebar' => 'साइडबार संपादित करें',
	'adminlinks_editcss' => 'सीएसएस फ़ाइल संपादित करें',
	'adminlinks_editmainpagename' => 'मुख्य पृष्ठ का नाम संपादित करें',
	'adminlinks_users' => 'सदस्य',
);

/** Croatian (Hrvatski)
 * @author Ex13
 */
$messages['hr'] = array(
	'adminlinks' => 'Administratorske poveznice',
	'adminlinks-desc' => 'Dodaje [[Special:AdminLinks|posebnu stranicu]] koja sadrži korisne poveznice za administratore',
	'adminlinks_documentation' => '$1 dokumentacija',
	'adminlinks_general' => 'Općenito',
	'adminlinks_editsidebar' => 'Uredi izbornik sastrane',
	'adminlinks_editcss' => 'Uredi CSS datoteku',
	'adminlinks_editmainpagename' => 'Uredi ime glavne stranice',
	'adminlinks_users' => 'Suradnici',
	'adminlinks_createuser' => 'Stvori suradnika',
	'adminlinks_browsesearch' => 'Pregledavanje i pretraživanje',
	'adminlinks_importexport' => 'Uvoz i izvoz',
	'right-adminlinks' => 'Pogledajte poveznicu na [[Special:AdminLinks|administratorske poveznice]]',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'adminlinks' => 'Wotkazy za administratorow',
	'adminlinks-desc' => 'Přidawa [[Special:AdminLinks|specialnu stronu]] z pomocliwymi wotkazami za administratorow',
	'adminlinks_documentation' => '$1 dokumentacija',
	'adminlinks_general' => 'Powšitkowny',
	'adminlinks_editsidebar' => 'Pobóčnu lajstu wobdźěłać',
	'adminlinks_editcss' => 'Dataju CSS wobdźěłać',
	'adminlinks_editmainpagename' => 'Mjeno hłowneje strony wobdźěłać',
	'adminlinks_users' => 'Wužiwarjo',
	'adminlinks_createuser' => 'Wužiwarja wutworić',
	'adminlinks_browsesearch' => 'Přehladowanje a pytanje',
	'adminlinks_importexport' => 'Importowanje a eksportowanje',
	'right-adminlinks' => 'Hlej wotkaz k [[Special:AdminLinks|wotkazam za administratorow]]',
);

/** Hungarian (Magyar)
 * @author Tgr
 */
$messages['hu'] = array(
	'adminlinks' => 'Adminlinkek',
	'adminlinks-desc' => 'Létrehoz egy [[Special:AdminLinks|speciális lapot]], ami az adminisztrátorok számára hasznos linkeket tartalmaz',
	'adminlinks_documentation' => '$1 dokumentáció',
	'adminlinks_general' => 'Általános',
	'adminlinks_editsidebar' => 'Oldalsó menü szerkesztése',
	'adminlinks_editcss' => 'CSS fájl szerkesztése',
	'adminlinks_editmainpagename' => 'Főoldal nevének szerkesztése',
	'adminlinks_users' => 'Felhasználók',
	'adminlinks_createuser' => 'Felhasználó létrehozása',
	'adminlinks_browsesearch' => 'Böngészés és keresés',
	'adminlinks_importexport' => 'Importálás és exportálás',
	'right-adminlinks' => 'látja az [[Special:AdminLinks|adminlinkeket]]',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'adminlinks' => 'Ligamines pro administratores',
	'adminlinks-desc' => 'Adde un [[Special:AdminLinks|pagina special]] con ligamines utile pro administratores',
	'adminlinks_documentation' => 'Documentation de $1',
	'adminlinks_general' => 'General',
	'adminlinks_editsidebar' => 'Modificar barra lateral',
	'adminlinks_editcss' => 'Modificar file CSS',
	'adminlinks_editmainpagename' => 'Modificar le nomine del pagina principal',
	'adminlinks_users' => 'Usatores',
	'adminlinks_createuser' => 'Crear un usator',
	'adminlinks_browsesearch' => 'Navigation e recerca',
	'adminlinks_importexport' => 'Importation e exportation',
	'right-adminlinks' => 'Vider le ligamine verso [[Special:AdminLinks|Ligamines pro administratores]]',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 */
$messages['id'] = array(
	'adminlinks' => 'Pranala admin',
	'adminlinks-desc' => 'Menambahkan sebuah [[Special:AdminLinks|halaman istimewa]] yang berisi pranala-pranala yang berguna untuk admin',
	'adminlinks_documentation' => 'Dokumentasi $1',
	'adminlinks_general' => 'Umum',
	'adminlinks_editsidebar' => 'Sunting kotak samping',
	'adminlinks_editcss' => 'Sunting berkas CSS',
	'adminlinks_editmainpagename' => 'Sunting nama halaman utama',
	'adminlinks_users' => 'Pengguna',
	'adminlinks_createuser' => 'Buat pengguna',
	'adminlinks_browsesearch' => 'Menjelajah dan mencari',
	'adminlinks_importexport' => 'Mengimpor dan ekspor',
	'right-adminlinks' => 'Lihat pranala ke [[Special:AdminLinks|Pranala admin]]',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'adminlinks' => 'Jikodo ndi íshí',
	'adminlinks-desc' => 'Né tinyé [[Special:AdminLinks|ihü mkpa]] né jidé jikodo nke ne nyé nkwado maka ndi íshí',
	'adminlinks_documentation' => 'akwukwo $1',
	'adminlinks_general' => 'Nke níle',
	'adminlinks_editsidebar' => 'Rüwá na ngwa di na ákùkù',
	'adminlinks_editcss' => 'Rüwá na akwukwo orúnotu nke CSS',
	'adminlinks_editmainpagename' => 'Rüwá na áhà ihü íshí',
	'adminlinks_users' => "Ọ'bànifé",
	'adminlinks_createuser' => 'Ké onye na banife',
	'adminlinks_browsesearch' => 'Nlearia na Í tú',
	'adminlinks_importexport' => 'I tinyé na Í kpata',
	'right-adminlinks' => 'Zi jikodo na ga [[Special:AdminLinks|Jikodo ndi íshí]]',
);

/** Italian (Italiano)
 * @author Darth Kule
 * @author Marco 27
 */
$messages['it'] = array(
	'adminlinks' => 'Pannello admin',
	'adminlinks-desc' => 'Aggiunge una [[Special:AdminLinks|pagina speciale]] che contiene link utili per gli amministratori',
	'adminlinks_documentation' => 'documentazione di $1',
	'adminlinks_general' => 'Generale',
	'adminlinks_editsidebar' => 'Modifica sidebar',
	'adminlinks_editcss' => 'Modifica file CSS',
	'adminlinks_editmainpagename' => 'Modifica il nome della pagina principale',
	'adminlinks_users' => 'Utenti',
	'adminlinks_createuser' => 'Crea un account',
	'adminlinks_browsesearch' => 'Visualizza e ricerca',
	'adminlinks_importexport' => 'Importa ed esporta',
	'right-adminlinks' => 'Vede il collegamento al [[Special:AdminLinks|Pannello Admin]]',
);

/** Japanese (日本語)
 * @author Fryed-peach
 */
$messages['ja'] = array(
	'adminlinks' => '管理者用リンク集',
	'adminlinks-desc' => '管理者に有用なリンクを集めた[[Special:AdminLinks|特別ページ]]を追加する',
	'adminlinks_documentation' => '$1 の説明書',
	'adminlinks_general' => '一般',
	'adminlinks_editsidebar' => 'サイドバーの編集',
	'adminlinks_editcss' => 'CSSファイルの編集',
	'adminlinks_editmainpagename' => 'メインページの名前の編集',
	'adminlinks_users' => '利用者',
	'adminlinks_createuser' => '利用者の作成',
	'adminlinks_browsesearch' => '閲覧と検索',
	'adminlinks_importexport' => '取り込みと書き出し',
	'right-adminlinks' => '[[Special:AdminLinks|管理者用リンク集]]へのリンクが表示される',
);

/** Georgian (ქართული)
 * @author BRUTE
 */
$messages['ka'] = array(
	'adminlinks_users' => 'მომხმარებლები',
	'adminlinks_createuser' => 'ანგარიშის შექმნა',
);

/** Khmer (ភាសាខ្មែរ)
 * @author វ័ណថារិទ្ធ
 */
$messages['km'] = array(
	'adminlinks' => 'តំណភ្ជាប់ រដ្ឋបាល​',
	'adminlinks_general' => 'ទូទៅ​',
	'adminlinks_editsidebar' => 'កែសម្រួល​របារ​ចំហៀង​',
	'adminlinks_editcss' => 'កែសម្រួល​ឯកសារ CSS',
	'adminlinks_editmainpagename' => 'កែសម្រួល​ឈ្មោះ​នៃ​ទំព័រ​ដើម​',
	'adminlinks_users' => 'អ្នកប្រើប្រាស់',
	'adminlinks_createuser' => 'បង្កើតអ្នកប្រើប្រាស់',
	'adminlinks_importexport' => 'កំពុង​នាំ​ចូល ​និងកំពុង​នាំ​ចេញ​',
);

/** Korean (한국어)
 * @author Devunt
 * @author Kwj2772
 */
$messages['ko'] = array(
	'adminlinks' => '괸리용 링크 모음',
	'adminlinks-desc' => '관리자들에게 유용한 링크들이 있는 [[Special:AdminLinks|특수 문서]]를 추가합니다',
	'adminlinks_documentation' => '$1 설명문서',
	'adminlinks_general' => '일반',
	'adminlinks_editsidebar' => '사이드바 편집',
	'adminlinks_editcss' => 'CSS 파일 편집',
	'adminlinks_editmainpagename' => '대문 이름 편집',
	'adminlinks_users' => '사용자',
	'adminlinks_createuser' => '계정 만들기',
	'adminlinks_browsesearch' => '둘러보기 및 찾기',
	'adminlinks_importexport' => '가져오기 및 내보내기',
	'right-adminlinks' => '[[Special:AdminLinks|관리자용 링크]]를 보기',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'adminlinks' => 'Lengks för Wiki-Köbesse',
	'adminlinks-desc' => 'Deiht en [[Special:AdminLinks|Söndersigg]] en et Wiki met extra Lengks för Wiki-Köbesse.',
	'adminlinks_documentation' => '$1 Dokkemäntazjuhn',
	'adminlinks_general' => 'Alljemein',
	'adminlinks_editsidebar' => '<code lang="en">sidebar</code> Ändere',
	'adminlinks_editcss' => '<i lang="en">CSS</i>-Datei ändere',
	'adminlinks_editmainpagename' => 'Dä Houpsigk iere Name ändere',
	'adminlinks_users' => 'Metmaacher',
	'adminlinks_createuser' => 'Ene neuje Metmaacher aanlääje',
	'adminlinks_browsesearch' => 'Bläddere un Söhke',
	'adminlinks_importexport' => 'Empoteere un Äxpoteere',
	'right-adminlinks' => 'Dä Lengk op de Sigg met [[Special:AdminLinks|Lengks för Köbeße]] jezeijsch krijje',
);

/** Kurdish (Latin script) (‪Kurdî (latînî)‬)
 * @author George Animal
 */
$messages['ku-latn'] = array(
	'adminlinks_users' => 'Bikarhêneran',
	'adminlinks_createuser' => 'Bikarhênerekî çêke',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'adminlinks' => 'Linke fir Administrateuren',
	'adminlinks-desc' => 'Setzt eng [[Special:AdminLinks|Spezialsäit]] derbäi mat nëtzleche Linke fir Administrateuren',
	'adminlinks_documentation' => '$1 Dokumentatioun',
	'adminlinks_general' => 'Allgemeng',
	'adminlinks_editsidebar' => 'De säitleche Menu änneren',
	'adminlinks_editcss' => 'CSS-Fichier änneren',
	'adminlinks_editmainpagename' => 'Den Numm vun der Haaptsäit änneren',
	'adminlinks_users' => 'Benotzer',
	'adminlinks_createuser' => 'E Benotzer uleeën',
	'adminlinks_browsesearch' => 'Bliederen a sichen',
	'adminlinks_importexport' => 'Importéieren an exportéieren',
	'right-adminlinks' => 'Kuckt the Link op [[Special:AdminLinks|Like fir Administrateuren]]',
);

/** Lezghian (Лезги)
 * @author Namik
 */
$messages['lez'] = array(
	'adminlinks' => 'Кавхаяр алукьнин чарчин',
	'adminlinks_general' => 'Чlехидин',
	'adminlinks_editcss' => 'Дегишарун CSS шикил',
	'adminlinks_users' => 'Иштиракчияр',
	'adminlinks_createuser' => 'Чар туькIуьрун',
	'adminlinks_browsesearch' => 'Килигун ва жагъурун',
	'adminlinks_importexport' => 'Кьабулун ва Ракъурун',
);

/** Limburgish (Limburgs)
 * @author Pahles
 */
$messages['li'] = array(
	'adminlinks' => 'Verwiezinge veur systeemwèrkers',
	'adminlinks-desc' => "Deit 'n [[Special:AdminLinks|speciaal pagina]] bie mèt handige verwiezinge veur systeemwèrkers",
	'adminlinks_documentation' => 'Dokkementatie veur $1',
	'adminlinks_general' => 'Algemein',
	'adminlinks_editsidebar' => 'Ziebalk bewirke',
	'adminlinks_editcss' => 'CSS bewirke',
	'adminlinks_editmainpagename' => 'Naam van de huidpagina bewirke',
	'adminlinks_users' => 'Gebroekers',
	'adminlinks_createuser' => 'Gebroeker aanmake',
	'adminlinks_browsesearch' => 'Betrachte en zeuke',
	'adminlinks_importexport' => 'Importere en exportere',
	'right-adminlinks' => 'De verwiezing nao [[Special:AdminLinks|verwiezinge veur systeemwèrkers]] betrachte',
);

/** Lithuanian (Lietuvių)
 * @author Eitvys200
 * @author Ignas693
 * @author Perkunas
 */
$messages['lt'] = array(
	'adminlinks' => 'Administravimo saitai',
	'adminlinks-desc' => 'Prideda [[Special:AdminLinks|Specialu puslapį]] kuriame yra naudingos nuorodos administretoriams',
	'adminlinks_documentation' => '$1 dokumentacija',
	'adminlinks_general' => 'Bendrosios',
	'adminlinks_editsidebar' => 'Redaguoti šoninės juostos',
	'adminlinks_editcss' => 'Redaguoti CSS failą',
	'adminlinks_editmainpagename' => 'Redaguoti pagrindinio puslapio pavadinimą',
	'adminlinks_users' => 'Vartotojai',
	'adminlinks_createuser' => 'Sukurti naudotoją',
	'adminlinks_browsesearch' => 'Naršyti ir ieškoti',
	'adminlinks_importexport' => 'Importas ir eksportas',
	'right-adminlinks' => 'Žr. nuorodą į [[specialus: AdminLinks|Administravimo saitai]]',
);

/** Latgalian (Latgaļu)
 * @author Dark Eagle
 */
$messages['ltg'] = array(
	'adminlinks_users' => 'Lītuotuoji',
	'adminlinks_createuser' => 'Sataiseit jaunu lītuotuoju',
);

/** Latvian (Latviešu)
 * @author Papuass
 */
$messages['lv'] = array(
	'adminlinks' => 'Administrācijas saites',
	'adminlinks-desc' => 'Pievieno [[Special:AdminLinks|īpašo lapu]], kura satur administratoriem noderīgas saites',
	'adminlinks_documentation' => '$1 dokumentācija',
	'adminlinks_general' => 'Vispārīgi',
	'adminlinks_editsidebar' => 'Labot sānjoslu',
	'adminlinks_editcss' => 'Labot CSS failu',
	'adminlinks_editmainpagename' => 'Labot galvenās lapas nosaukumu',
	'adminlinks_users' => 'Lietotāji',
	'adminlinks_createuser' => 'Izveidot lietotāju',
	'adminlinks_browsesearch' => 'Pārlūkot un meklēt',
	'adminlinks_importexport' => 'Imports un eksports',
	'right-adminlinks' => 'Redzēt saiti uz [[Special:AdminLinks|Administrācijas saitēm]]',
);

/** Lazuri (Lazuri)
 * @author Bombola
 */
$messages['lzz'] = array(
	'adminlinks_users' => "K'oçepe",
);

/** Maithili (मैथिली)
 * @author Vinitutpal
 */
$messages['mai'] = array(
	'adminlinks' => 'एडमिन लिंक',
);

/** Malagasy (Malagasy)
 * @author Jagwar
 */
$messages['mg'] = array(
	'adminlinks' => 'rohy ny fandrindràna',
	'adminlinks-desc' => "Manampy [[Special:AdminLinks|special page]] misy ny rohy ilain'ny mpandrindra",
	'adminlinks_documentation' => "fanoroan'ny $1",
	'adminlinks_general' => 'ankabiazany/jeneraly',
	'adminlinks_editsidebar' => 'ovay ny bara sisiny',
	'adminlinks_editcss' => 'Hanova ny rakitra CSS',
	'adminlinks_editmainpagename' => "ovay ny anaran'ny pejy fandraisana",
	'adminlinks_users' => 'mpikambana',
	'adminlinks_createuser' => 'hamorona mpikambana',
	'adminlinks_browsesearch' => 'Fikarohana sy fitadiavina',
	'adminlinks_importexport' => 'hampiditra sy hamoaka',
	'right-adminlinks' => "Hijery ny rohy any amin'ny [[Special:AdminLinks|rohy ampiasain'ny mpandrindra]]",
);

/** Eastern Mari (Олык Марий)
 * @author Azim
 */
$messages['mhr'] = array(
	'adminlinks' => 'Сайтвиктарыше кылвер-влак',
	'adminlinks-desc' => 'Сайтвиктарышышлан пайдале кылверым кучышо [[Special:AdminLinks|лӱмын ыштыме лаштыкым]] ешара',
	'adminlinks_documentation' => '$1 документаций',
	'adminlinks_general' => 'Тӱшкале',
	'adminlinks_editsidebar' => 'Ӧрдыж аҥам тӧрлаташ',
	'adminlinks_editcss' => 'CSS файлым тӧрлаташ',
	'adminlinks_editmainpagename' => 'Тӱҥ лаштыкын лӱмжым тӧрлаташ',
	'adminlinks_users' => 'Пайдаланыше-влак',
	'adminlinks_createuser' => 'Пайдаланыше лияш',
	'adminlinks_browsesearch' => 'Ончен налмаш да кычалмаш',
	'adminlinks_importexport' => 'Импорт ден экспорт',
	'right-adminlinks' => '[[Special:AdminLinks|Сайтвиктарыше кылвер-влакым]] ужаш',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'adminlinks' => 'Администраторски врски',
	'adminlinks-desc' => 'Додава [[Special:AdminLinks|специјална страница]] која содржи корисни врски за администратори.',
	'adminlinks_documentation' => 'Документација за $1',
	'adminlinks_general' => 'Општо',
	'adminlinks_editsidebar' => 'Уреди странична лента',
	'adminlinks_editcss' => 'Уреди ја CSS податотеката',
	'adminlinks_editmainpagename' => 'Уредување на името на главната страница',
	'adminlinks_users' => 'Корисници',
	'adminlinks_createuser' => 'Создај корисник',
	'adminlinks_browsesearch' => 'Прелистување и пребарување',
	'adminlinks_importexport' => 'Увоз и извоз',
	'right-adminlinks' => 'Приказ на врската до [[Special:AdminLinks|Администраторските врски]]',
);

/** Malayalam (മലയാളം)
 * @author Sadik Khalid
 */
$messages['ml'] = array(
	'adminlinks' => 'കാര്യനിർവാഹക കണ്ണികൾ',
	'adminlinks-desc' => 'കാര്യനിർവാഹകർക്ക് സഹായകരമായ കണ്ണികളോടു കൂടിയ ഒരു [[Special:AdminLinks|പ്രത്യേക താൾ]] ചേർക്കുന്നു',
	'adminlinks_documentation' => '$1 വിവരണം',
	'adminlinks_general' => 'സാർവത്രികം',
	'adminlinks_editsidebar' => 'സൈഡ്ബാർ തിരുത്തുക',
	'adminlinks_editcss' => 'CSS പ്രമാണം തിരുത്തുക',
	'adminlinks_editmainpagename' => 'പ്രധാനതാളിന്റെ പേര് തിരുത്തുക',
	'adminlinks_users' => 'ഉപയോക്താക്കൾ',
	'adminlinks_createuser' => 'ഒരു ഉപയോക്താവിനെ സൃഷ്ടിക്കുക',
	'adminlinks_browsesearch' => 'തിരച്ചിലും മേച്ചിലും',
	'adminlinks_importexport' => 'കയറ്റുമതിയും ഇറക്കുമതിയും',
	'right-adminlinks' => '[[Special:AdminLinks|കാര്യനിവാഹക കണ്ണികളിലേക്കുള്ള]] കണ്ണികൾ കാണുക',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 * @author Zamwan
 */
$messages['ms'] = array(
	'adminlinks' => 'Pautan pentadbir',
	'adminlinks-desc' => 'Menambahkan [[Special:AdminLinks|laman khas]] yang menyimpan pautan-pautan yang berguna untuk pentadbir',
	'adminlinks_documentation' => 'Dokumentasi $1',
	'adminlinks_general' => 'Umum',
	'adminlinks_editsidebar' => 'Sunting bar sisi',
	'adminlinks_editcss' => 'Sunting fail CSS',
	'adminlinks_editmainpagename' => 'Sunting nama laman utama',
	'adminlinks_users' => 'Pengguna',
	'adminlinks_createuser' => 'Cipta pengguna',
	'adminlinks_browsesearch' => 'Layari dan cari',
	'adminlinks_importexport' => 'Import dan eksport',
	'right-adminlinks' => 'Melihat pautan ke [[Special:AdminLinks|Pautan pentadbir]]',
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'adminlinks' => 'Администраторонь сюлмавома пенеть',
	'adminlinks-desc' => 'Полады [[Special:AdminLinks|башка лопа]], конасонть администраторонь туртов лезэв сюлмавома пенеть',
	'adminlinks_documentation' => '$1 документациясь',
	'adminlinks_general' => 'Овсекс',
	'adminlinks_editsidebar' => 'Витнемс-петнемс бокасо лазнэнть',
	'adminlinks_editcss' => 'Витнемс-петнемс CSS файла',
	'adminlinks_editmainpagename' => 'Витнемс-петнемс прякс лопанть лемензэ',
	'adminlinks_users' => 'Совицят',
	'adminlinks_createuser' => 'Шкамс совиця',
	'adminlinks_browsesearch' => 'Якавтомат-пакавтомат ды вешнэма',
	'adminlinks_importexport' => 'Совавтомат-ливтемат',
	'right-adminlinks' => 'Ваномс [[Special:AdminLinks|администраторонь сюлмавома пенетнень]]',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'adminlinks' => 'Adminlenker',
	'adminlinks-desc' => 'Legger til en [[Special:AdminLinks|spesialside]] som inneholder nyttige lenker for administratorer',
	'adminlinks_documentation' => 'dokumentasjon for $1',
	'adminlinks_general' => 'Generelt',
	'adminlinks_editsidebar' => 'Endre sidespalten',
	'adminlinks_editcss' => 'Rediger CSS-filen',
	'adminlinks_editmainpagename' => 'Endre navnet på hovedsiden',
	'adminlinks_users' => 'Brukere',
	'adminlinks_createuser' => 'Opprett en bruker',
	'adminlinks_browsesearch' => 'Lesing og søking',
	'adminlinks_importexport' => 'Importering og eksportering',
	'right-adminlinks' => 'Se lenken til [[Special:AdminLinks|admin-lenker]]',
);

/** Nedersaksisch (Nedersaksisch)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'adminlinks' => 'Verwiezingen veur beheerders',
	'adminlinks-desc' => 'Zet der n [[Special:AdminLinks|spesiale pagina]] bie mit hendige verwiezingen veur beheerders',
	'adminlinks_documentation' => 'Dokumentasie veur $1',
	'adminlinks_general' => 'Algemeen',
	'adminlinks_editsidebar' => 'Ziedbalke bewarken',
	'adminlinks_editcss' => 'CSS bewarken',
	'adminlinks_editmainpagename' => 'Naam van t veurblad bewarken',
	'adminlinks_users' => 'Gebrukers',
	'adminlinks_createuser' => 'Gebruker anmaken',
	'adminlinks_browsesearch' => 'Bekieken en zeuken',
	'adminlinks_importexport' => 'Invoeren en uutvoeren',
	'right-adminlinks' => 'De verwiezing naor [[Special:AdminLinks|verwiezingen veur beheerders]] zien',
);

/** Nepali (नेपाली)
 * @author Bhawani Gautam
 * @author Bhawani Gautam Rhk
 * @author सरोज कुमार ढकाल
 */
$messages['ne'] = array(
	'adminlinks' => 'प्रवन्धक लिङ्कहरु',
	'adminlinks-desc' => 'एउटा [[Special:AdminLinks|विशेष पृष्ठ]] थप्छ जसले प्रबन्धककर्ताहरुको  लागि सहयोगी लिङ्कहरु समेटेको छ।',
	'adminlinks_documentation' => '$1 दस्तावेज़ीकरण',
	'adminlinks_general' => 'साधारण',
	'adminlinks_editsidebar' => 'साइडबार सम्पादन गर्ने',
	'adminlinks_editcss' => ' CSS फाइल सम्पादन गर्ने',
	'adminlinks_editmainpagename' => 'मूख्य पृष्ठको नाम सम्पादन गर्ने',
	'adminlinks_users' => 'प्रयोगकर्ताहरु',
	'adminlinks_createuser' => 'प्रयोगकर्ता सृजना गर्ने',
	'adminlinks_browsesearch' => 'ब्राउजिङ्ग र खोजी',
	'adminlinks_importexport' => 'आयात तथा निर्यात',
	'right-adminlinks' => 'यो लिङ्क हेर्नुहोस [[Special:AdminLinks|प्रबन्धक लिङ्क]]',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'adminlinks' => 'Verwijzingen voor beheerders',
	'adminlinks-desc' => 'Voegt een [[Special:AdminLinks|speciale pagina]] toe met handige verwijzingen voor beheerders',
	'adminlinks_documentation' => 'Documentatie voor $1',
	'adminlinks_general' => 'Algemeen',
	'adminlinks_editsidebar' => 'Zijbalk bewerken',
	'adminlinks_editcss' => 'CSS bewerken',
	'adminlinks_editmainpagename' => 'Naam van de hoofdpagina bewerken',
	'adminlinks_users' => 'Gebruikers',
	'adminlinks_createuser' => 'Gebruiker aanmaken',
	'adminlinks_browsesearch' => 'Bekijken en zoeken',
	'adminlinks_importexport' => 'Importeren en exporteren',
	'right-adminlinks' => 'De verwijzing naar [[Special:AdminLinks|verwijzingen voor beheerders]] zien',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Gunnernett
 */
$messages['nn'] = array(
	'adminlinks' => 'Lenker for administratorar',
	'adminlinks-desc' => 'Legg til ei [[Special:AdminLinks|spesialside]] som inneheld nyttige lenker for administratorar',
	'adminlinks_documentation' => 'dokumentasjon for $1',
	'adminlinks_general' => 'Generelt',
	'adminlinks_editsidebar' => 'Endre sidespalta',
	'adminlinks_editcss' => 'Endre CSS-fila',
	'adminlinks_editmainpagename' => 'Endre namn på hovudsida',
	'adminlinks_users' => 'Brukarar',
	'adminlinks_createuser' => 'Opprett ein brukar',
	'adminlinks_browsesearch' => 'Lesing og søking',
	'adminlinks_importexport' => 'Importering og eksportering',
	'right-adminlinks' => 'Sjå lenka til [[Special:AdminLinks|admin-lenker]]',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'adminlinks' => "Ligams d'administracion",
	'adminlinks-desc' => 'Apond una [[Special:AdminLinks|pagina especiala]] que conten de ligams utils pels administrators',
	'adminlinks_documentation' => 'documentacion de $1',
	'adminlinks_general' => 'General',
	'adminlinks_editsidebar' => 'Modificar la barra laterala',
	'adminlinks_editcss' => 'Modificar lo fichièr CSS',
	'adminlinks_editmainpagename' => "Modificar lo nom de la pagina d'acuèlh",
	'adminlinks_users' => 'Utilizaires',
	'adminlinks_createuser' => 'Crear un utilizaire',
	'adminlinks_browsesearch' => 'Navigacion e recèrca',
	'adminlinks_importexport' => 'Importar e exportar',
	'right-adminlinks' => "Vejatz lo ligam cap als [[Special:AdminLinks|ligams d'administracion]]",
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Ansumang
 * @author Odisha1
 */
$messages['or'] = array(
	'adminlinks_general' => 'ସାଧାରଣ',
	'adminlinks_editmainpagename' => 'ପ୍ରଧାନ ପୃଷ୍ଠାର ନାମ ବଦଳାଇବେ',
	'adminlinks_users' => 'ବ୍ୟବହାରକାରୀଗଣ',
);

/** Ossetic (Ирон)
 * @author Amikeco
 */
$messages['os'] = array(
	'adminlinks_editcss' => 'CSS файл баив',
	'adminlinks_users' => 'Архайджытæ',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'adminlinks' => 'Gleecher fer Verwalter',
	'adminlinks_users' => 'Yuuser',
);

/** Polish (Polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'adminlinks' => 'Linki dla administratorów',
	'adminlinks-desc' => 'Dodaje [[Special:AdminLinks|stronę specjalną]] z linkami użytecznymi dla administratorów',
	'adminlinks_documentation' => 'Dokumentacja $1',
	'adminlinks_general' => 'Ogólne',
	'adminlinks_editsidebar' => 'Edycja menu bocznego',
	'adminlinks_editcss' => 'Edycja pliku CSS',
	'adminlinks_editmainpagename' => 'Zmiana nazwy strony głównej',
	'adminlinks_users' => 'Użytkownicy',
	'adminlinks_createuser' => 'Utwórz użytkownika',
	'adminlinks_browsesearch' => 'Przeglądanie i wyszukiwanie',
	'adminlinks_importexport' => 'Importowanie i eksportowanie',
	'right-adminlinks' => 'Podgląd zawartości strony [[Special:AdminLinks|Linki dla administratorów]]',
);

/** Piedmontese (Piemontèis)
 * @author Dragonòt
 */
$messages['pms'] = array(
	'adminlinks' => "Anliure d'aministrador",
	'adminlinks-desc' => "A gionta na [[Special:AdminLinks|pàgina special]] che a conten dij colegament ùtij për j'aministrador",
	'adminlinks_documentation' => 'documentassion ëd $1',
	'adminlinks_general' => 'General',
	'adminlinks_editsidebar' => 'Modìfica la sidebar',
	'adminlinks_editcss' => 'Modìfica file CSS',
	'adminlinks_editmainpagename' => 'Modìfica ël nòm dla pàgina prinsipal',
	'adminlinks_users' => 'Utent',
	'adminlinks_createuser' => "Crea n'utent",
	'adminlinks_browsesearch' => 'Visualisassion e arserca',
	'adminlinks_importexport' => 'Amportassion e esportassion',
	'right-adminlinks' => "Varda ël colegament a [[Special:AdminLinks|colegament ëd j'Admin]]",
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'adminlinks' => 'د پازوال تړنې',
	'adminlinks_documentation' => '$1 لاسوند',
	'adminlinks_general' => 'ټولګړی',
	'adminlinks_editsidebar' => 'څنګپټه سمول',
	'adminlinks_editcss' => 'د CSS دوتنه سمول',
	'adminlinks_editmainpagename' => 'د اصلي مخ نوم سمول',
	'adminlinks_users' => 'کارنان',
	'adminlinks_createuser' => 'يو کارن جوړول',
	'adminlinks_browsesearch' => 'سپړنه او پلټنه',
	'adminlinks_importexport' => 'واردول او صادرول',
	'right-adminlinks' => 'د [[Special:AdminLinks|پازوال تړنو]] ته ورسيخه شوې تړنه کتل',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 * @author Malafaya
 * @author Waldir
 */
$messages['pt'] = array(
	'adminlinks' => 'Links para administradores',
	'adminlinks-desc' => 'Adiciona uma [[Special:AdminLinks|página especial]] que contém links úteis para administradores',
	'adminlinks_documentation' => 'Documentação sobre $1',
	'adminlinks_general' => 'Geral',
	'adminlinks_editsidebar' => 'Editar barra lateral',
	'adminlinks_editcss' => 'Editar ficheiro CSS',
	'adminlinks_editmainpagename' => 'Editar nome da página principal',
	'adminlinks_users' => 'Utilizadores',
	'adminlinks_createuser' => 'Criar um utilizador',
	'adminlinks_browsesearch' => 'Navegação e pesquisa',
	'adminlinks_importexport' => 'Importação e exportação',
	'right-adminlinks' => 'Ver o link para a página [[Special:AdminLinks|Links para administradores]]',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 */
$messages['pt-br'] = array(
	'adminlinks' => 'Ligações para administradores',
	'adminlinks-desc' => 'Adiciona uma [[Special:AdminLinks|página especial]] que possui ligações úteis para administradores',
	'adminlinks_documentation' => 'Documentação sobre $1',
	'adminlinks_general' => 'Geral',
	'adminlinks_editsidebar' => 'Editar barra lateral',
	'adminlinks_editcss' => 'Editar arquivo CSS',
	'adminlinks_editmainpagename' => 'Editar nome da página principal',
	'adminlinks_users' => 'Utilizadores',
	'adminlinks_createuser' => 'Criar um utilizador',
	'adminlinks_browsesearch' => 'Navegação e pesquisa',
	'adminlinks_importexport' => 'Importação e exportação',
	'right-adminlinks' => 'Ver a ligação para [[Special:AdminLinks|ligações Admin]]',
);

/** Romanian (Română)
 * @author Firilacroco
 * @author KlaudiuMihaila
 * @author Minisarm
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'adminlinks' => 'Legături administrator',
	'adminlinks_documentation' => 'Documentație pentru $1',
	'adminlinks_general' => 'General',
	'adminlinks_editsidebar' => 'Editează bara laterală',
	'adminlinks_editcss' => 'Editează fişierul CSS',
	'adminlinks_editmainpagename' => 'Editează numele paginii principale',
	'adminlinks_users' => 'Utilizatori',
	'adminlinks_createuser' => 'Creează un utilizator',
	'adminlinks_browsesearch' => 'Răsfoiește și caută',
	'adminlinks_importexport' => 'Importare și exportare',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'adminlinks' => "Collegaminde de l'amministratore",
	'adminlinks_documentation' => 'documendazione de $1',
	'adminlinks_general' => 'Generale',
	'adminlinks_editsidebar' => "Cange 'a barre laterale",
	'adminlinks_editcss' => "Cange 'u file CSS",
	'adminlinks_editmainpagename' => "Cange 'u nome d'a pàgene prengepàle",
	'adminlinks_users' => 'Utinde',
	'adminlinks_createuser' => "Ccreje 'n'utende",
	'adminlinks_browsesearch' => 'Sfoglie e cirche',
	'adminlinks_importexport' => "'Mborte e esporte",
);

/** Russian (Русский)
 * @author Ferrer
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'adminlinks' => 'Ссылки для администраторов',
	'adminlinks-desc' => 'Добавляет [[Special:AdminLinks|служебную страницу]], содержащую полезные ссылки для администраторов',
	'adminlinks_documentation' => 'документация $1',
	'adminlinks_general' => 'Общие',
	'adminlinks_editsidebar' => 'Править боковую панель',
	'adminlinks_editcss' => 'Править файл CSS',
	'adminlinks_editmainpagename' => 'Править имя заглавной страницы',
	'adminlinks_users' => 'Участники',
	'adminlinks_createuser' => 'Создать учётную запись',
	'adminlinks_browsesearch' => 'Обзор и поиск',
	'adminlinks_importexport' => 'Импорт и экспорт',
	'right-adminlinks' => 'видеть [[Special:AdminLinks|ссылки для администраторов]]',
);

/** Rusyn (Русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'adminlinks' => 'Одказы про адміністратора',
	'adminlinks-desc' => 'Додасть [[Special:AdminLinks|шпеціалну сторінку]], яка обсягує хосновны одказы про адміністраторів',
	'adminlinks_documentation' => 'документація $1',
	'adminlinks_general' => 'Обще',
	'adminlinks_editsidebar' => 'Едітовати бочный панел',
	'adminlinks_editcss' => 'Едітовати CSS-файл',
	'adminlinks_editmainpagename' => 'Змінити назву головной сторінкы',
	'adminlinks_users' => 'Хоснователї',
	'adminlinks_createuser' => 'Створити конто хоснователя',
	'adminlinks_browsesearch' => 'Перегляд і гляданя',
	'adminlinks_importexport' => 'Імпорт і експорт',
	'right-adminlinks' => 'Відїти [[Special:AdminLinks|Одказы про адміністраторів]]',
);

/** Sakha (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'adminlinks' => 'Дьаһабыллар сигэлэрэ',
	'adminlinks-desc' => 'Дьаһабылларга туһалаах сигэлэрдээх [[Special:AdminLinks|анал сирэйи]] эбэр',
	'adminlinks_documentation' => '$1 дөкүмүөннэрэ',
	'adminlinks_general' => 'Сүрүн (барытыгар сыһыаннаах)',
	'adminlinks_editsidebar' => 'Хаҥас холуоҥканы уларытыы',
	'adminlinks_editcss' => 'CSS билэни уларытыы',
	'adminlinks_editmainpagename' => 'Сүрүн сирэй аатын уларытыы',
	'adminlinks_users' => 'Кыттааччылар',
	'adminlinks_createuser' => 'Саҥа ааты оҥоруу',
	'adminlinks_browsesearch' => 'Көрүү уонна көрдөөһүн',
	'adminlinks_importexport' => 'Импорт уонна экспорт',
	'right-adminlinks' => '[[Special:AdminLinks|Дьаһабылларга анаммыт сигэлэри]] көрүү',
);

/** Sicilian (Sicilianu)
 * @author Aushulz
 */
$messages['scn'] = array(
	'adminlinks_users' => 'Utenti',
);

/** Tachelhit (Tašlḥiyt/ⵜⴰⵛⵍⵃⵉⵜ)
 * @author Dalinanir
 */
$messages['shi'] = array(
	'adminlinks' => 'Izdayn imsfttutn',
	'adminlinks-desc' => 'Zaydn i [[Special:AdminLinks|tasna tamzlayt]] izdayn li ra yaws imɣarn',
	'adminlinks_documentation' => '$1 assultm  (documentation)',
	'adminlinks_general' => 'Ikka kullu',
	'adminlinks_editsidebar' => 'Ara tannalt n tasga (colonne= tannalt)',
	'adminlinks_editcss' => 'Ara asdaw CSS',
	'adminlinks_editmainpagename' => 'Sbadl assaɣ n tasna tamuqqrant',
	'adminlinks_users' => 'Imsxdamn',
	'adminlinks_createuser' => 'Skr amsxdam',
	'adminlinks_browsesearch' => 'Asglb du ucnubc',
	'adminlinks_importexport' => 'Askcm d Attḥay',
	'right-adminlinks' => 'Ẓr izdayn s [[Special:AdminLinks|Izdayn nu umsfttu]]',
);

/** Sinhala (සිංහල)
 * @author බිඟුවා
 */
$messages['si'] = array(
	'adminlinks' => 'පරිපාලක සබැඳුම්',
	'adminlinks_general' => 'සාමාන්‍ය',
	'adminlinks_users' => 'පරිශීලකයෝ',
	'adminlinks_createuser' => 'පරිශීලකයෙක් තනන්න',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'adminlinks' => 'Odkazy správcu',
	'adminlinks-desc' => 'Pridáva [[Special:AdminLinks|špeciálnu stránku]] s užitočnými odkazmi pre správcov',
	'adminlinks_documentation' => 'Dokumentácia $1',
	'adminlinks_general' => 'Všeobecné',
	'adminlinks_editsidebar' => 'Upraviť bočný panel',
	'adminlinks_editcss' => 'Upraviť CSS súbor',
	'adminlinks_editmainpagename' => 'Upraviť názov hlavnej stránky',
	'adminlinks_users' => 'Používatelia',
	'adminlinks_createuser' => 'Vytvoriť používateľa',
	'adminlinks_browsesearch' => 'Prehliadanie a vyhľadávanie',
	'adminlinks_importexport' => 'Import a export',
	'right-adminlinks' => 'Pozri odkaz na [[Special:AdminLinks|Odkazy správcu]]',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'adminlinks' => 'Skrbniške povezave',
	'adminlinks-desc' => 'Doda [[Special:AdminLinks|posebno stran]], ki vsebuje uporabne povezave za administratorje',
	'adminlinks_documentation' => 'Dokumentacija $1',
	'adminlinks_general' => 'Splošno',
	'adminlinks_editsidebar' => 'Uredi stransko vrstico',
	'adminlinks_editcss' => 'Uredi datoteko CSS',
	'adminlinks_editmainpagename' => 'Uredi ime glavne strani',
	'adminlinks_users' => 'Uporabniki',
	'adminlinks_createuser' => 'Ustvari uporabnika',
	'adminlinks_browsesearch' => 'Brskanje in iskanje',
	'adminlinks_importexport' => 'Uvoz in izvoz',
	'right-adminlinks' => 'Ogled povezav na [[Special:AdminLinks|Skrbniških povezavah]]',
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬)
 * @author Charmed94
 * @author Rancher
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'adminlinks' => 'Административне везе',
	'adminlinks-desc' => 'Додаје [[Special:AdminLinks|посебну страницу]] која садржи корисне везе за администраторе',
	'adminlinks_documentation' => '$1 документација',
	'adminlinks_general' => 'Опште',
	'adminlinks_editsidebar' => 'Уреди бочну траку',
	'adminlinks_editcss' => 'Уреди CSS датотеку',
	'adminlinks_editmainpagename' => 'Измени назив главне странице',
	'adminlinks_users' => 'Корисници',
	'adminlinks_createuser' => 'Направи корисника',
	'adminlinks_browsesearch' => 'Претраживање',
	'adminlinks_importexport' => 'Увоз и извоз',
	'right-adminlinks' => 'прегледање везе до [[Special:AdminLinks|администраторских веза]]',
);

/** Serbian (Latin script) (‪Srpski (latinica)‬)
 * @author Rancher
 */
$messages['sr-el'] = array(
	'adminlinks' => 'Administrativne veze',
	'adminlinks-desc' => 'Dodaje [[Special:AdminLinks|posebnu stranicu]] koja sadrži korisne veze za administratore',
	'adminlinks_documentation' => '$1 dokumentacija',
	'adminlinks_general' => 'Opšte',
	'adminlinks_editsidebar' => 'Uredi bočnu traku',
	'adminlinks_editcss' => 'Uredi CSS datoteku',
	'adminlinks_editmainpagename' => 'Izmeni naziv glavne stranice',
	'adminlinks_users' => 'Korisnici',
	'adminlinks_createuser' => 'Napravi korisnika',
	'adminlinks_browsesearch' => 'Pretraživanje',
	'adminlinks_importexport' => 'Uvoz i izvoz',
	'right-adminlinks' => 'pregledanje veze do [[Special:AdminLinks|administratorskih veza]]',
);

/** Swedish (Svenska)
 * @author Gabbe.g
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'adminlinks' => 'Administrationslänkar',
	'adminlinks-desc' => 'Lägger till en [[Special:AdminLinks|specialsida]] som innehåller hjälpfulla länkar för administratörer',
	'adminlinks_documentation' => 'dokumentation dör $1',
	'adminlinks_general' => 'Generell',
	'adminlinks_editsidebar' => 'Ändra sidpanelen',
	'adminlinks_editcss' => 'Ändra CSS-fil',
	'adminlinks_editmainpagename' => 'Ändra namnet på huvudsidan',
	'adminlinks_users' => 'Användare',
	'adminlinks_createuser' => 'Skapa en användare',
	'adminlinks_browsesearch' => 'Bläddring och sökning',
	'adminlinks_importexport' => 'Importering och exportering',
	'right-adminlinks' => 'Se länken till [[Special:AdminLinks|Administrationslänkarna]]',
);

/** Tamil (தமிழ்)
 * @author TRYPPN
 * @author செல்வா
 */
$messages['ta'] = array(
	'adminlinks' => 'செயலாட்சியர் தொடுப்புகள்',
	'adminlinks-desc' => 'செயலாட்சியர்களுக்கு உதவும் தொடுப்புகளைக் கொண்டிருக்கும் [[Special:AdminLinks|special page]] ஐ சேர்க்கின்றது',
	'adminlinks_documentation' => '$1 உக்கான விளக்கவுரை',
	'adminlinks_general' => 'பொதுவான',
	'adminlinks_editsidebar' => 'பக்கப் பட்டியைத் தொகு',
	'adminlinks_editcss' => 'CSS கோப்பைத் தொகு',
	'adminlinks_editmainpagename' => 'முதற்பக்கத்தைத் தொகுக்கும் பெயர்',
	'adminlinks_users' => 'பயனர்கள்',
	'adminlinks_createuser' => 'பயனர் உருவாக்கு',
	'adminlinks_browsesearch' => 'உலவு தேடு',
	'adminlinks_importexport' => 'உள்ளிறக்கு வெளிச்செலுத்து',
	'right-adminlinks' => '[[Special:AdminLinks|Admin links]] உக்கான தொடுப்புகளைப் பார்',
);

/** Telugu (తెలుగు)
 * @author Ravichandra
 * @author Veeven
 */
$messages['te'] = array(
	'adminlinks' => 'నిర్వహణా లింకులు',
	'adminlinks-desc' => 'నిర్వాహకులకు ఉపయుక్తమైన లంకెలతో ఒక [[Special:AdminLinks|ప్రత్యేక పుట]]ని చేరుస్తుంది',
	'adminlinks_documentation' => '$1 పత్రావళి',
	'adminlinks_general' => 'సాధారణ',
	'adminlinks_editsidebar' => 'సైడ్‌బార్ ను మార్చు',
	'adminlinks_editcss' => 'స్టైల్ షీట్ ను మార్చు',
	'adminlinks_editmainpagename' => 'ప్రధాన పేజీ పేరు మార్చు',
	'adminlinks_users' => 'వాడుకరులు',
	'adminlinks_createuser' => 'వాడుకరిని సృష్టించు',
	'adminlinks_browsesearch' => 'విహరించడం, మరియు వెతకడం',
	'adminlinks_importexport' => 'ఎగుమతులు, దిగుమతులు',
	'right-adminlinks' => '[[Special:AdminLinks|నిర్వహణా లింకుల]]కు లింకుని చూడగలగడం',
);

/** Thai (ไทย)
 * @author Horus
 */
$messages['th'] = array(
	'adminlinks' => 'ลิงก์ผู้ดูแลระบบ',
	'adminlinks_browsesearch' => 'เรียกดูและค้นหา',
	'adminlinks_importexport' => 'นำเข้าและส่งออก',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'adminlinks_users' => 'Ulanyjylar',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 * @author Sky Harbor
 */
$messages['tl'] = array(
	'adminlinks' => 'Mga kawing pantagapangasiwa',
	'adminlinks-desc' => 'Nagdaragdag ng isang [[Special:AdminLinks|natatanging pahina]]ng humahawak ng makakatulong na mga kawing para sa mga tagapangasiwa',
	'adminlinks_documentation' => 'Dokumentasyon ng $1',
	'adminlinks_general' => 'Pangkalahatan',
	'adminlinks_editsidebar' => 'Baguhin ang baretang panggilid',
	'adminlinks_editcss' => 'Baguhin ang talaksan ng CSS',
	'adminlinks_editmainpagename' => 'Baguhin ang pangalan ng unang pahina',
	'adminlinks_users' => 'Mga tagagamit',
	'adminlinks_createuser' => 'Lumikha ng tagagamit',
	'adminlinks_browsesearch' => 'Pagbabasa-basa at paghahanap',
	'adminlinks_importexport' => 'Pag-aangkat at pagluluwas',
	'right-adminlinks' => 'Tingnan ang kawing sa [[Special:AdminLinks|mga kawing pantagapangasiwa]]',
);

/** Turkish (Türkçe)
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'adminlinks' => 'Hizmetli bağlantıları',
	'adminlinks-desc' => 'Hizmetliler için yararlı bağlantıları bulunduran bir [[Special:AdminLinks|özel sayfa]] ekler',
	'adminlinks_documentation' => '$1 dokümantasyonu',
	'adminlinks_general' => 'Genel',
	'adminlinks_editsidebar' => 'Kenar çubuğunu düzenle',
	'adminlinks_editcss' => 'CSS dosyasını düzenle',
	'adminlinks_editmainpagename' => 'Ana sayfanın adını düzenle',
	'adminlinks_users' => 'Kullanıcılar',
	'adminlinks_createuser' => 'Kullanıcı oluştur',
	'adminlinks_browsesearch' => 'Gezinme ve arama',
	'adminlinks_importexport' => 'İçe ve dışa aktarma',
	'right-adminlinks' => '[[Special:AdminLinks|Hizmetli bağlantılarına]] giden bağlantıyı gör',
);

/** Tatar (Cyrillic script) (Татарча)
 * @author Рашат Якупов
 */
$messages['tt-cyrl'] = array(
	'adminlinks' => 'Идарәчеләр өчен сылтамалар',
	'adminlinks_users' => 'Катнашучылар',
	'adminlinks_createuser' => 'Катнашучы хисабын төзү',
);

/** Uyghur (Arabic script) (ئۇيغۇرچە)
 * @author Sahran
 */
$messages['ug-arab'] = array(
	'adminlinks' => 'باشقۇرغۇچى ئۇلانمىسى',
	'adminlinks_documentation' => '$1 پۈتۈك',
	'adminlinks_general' => 'ئادەتتىكى',
	'adminlinks_editsidebar' => 'يان ستون تەھرىر',
	'adminlinks_editcss' => 'CSS ھۆججەت تەھرىر',
	'adminlinks_editmainpagename' => 'باش بەت ئاتىنى تەھرىرلەش',
	'adminlinks_users' => 'ئىشلەتكۈچىلەر',
	'adminlinks_createuser' => 'ئىشلەتكۈچىدىن بىرنى قۇر',
	'adminlinks_browsesearch' => 'تور زىيارىتى ۋە ئىزدەش',
	'adminlinks_importexport' => 'ئەكىرىش ۋە چىقىرىش',
	'right-adminlinks' => '[[Special:AdminLinks|باشقۇرغۇچى ئۇلاىمىسى]]نى كۆرۈڭ',
);

/** Ukrainian (Українська)
 * @author NickK
 * @author Prima klasy4na
 */
$messages['uk'] = array(
	'adminlinks' => 'Посилання для адміністраторів',
	'adminlinks-desc' => 'Додає [[Special:AdminLinks|спеціальну сторінку]], яка містить корисні посилання для адміністраторів',
	'adminlinks_documentation' => 'документація $1',
	'adminlinks_general' => 'Загальні',
	'adminlinks_editsidebar' => 'Редагувати бічну панелель',
	'adminlinks_editcss' => 'Редагувати CSS-файл',
	'adminlinks_editmainpagename' => 'Змінити назву головної сторінки',
	'adminlinks_users' => 'Користувачі',
	'adminlinks_createuser' => 'Створити обліковий запис',
	'adminlinks_browsesearch' => 'Перегляд і пошук',
	'adminlinks_importexport' => 'Імпорт та експорт',
	'right-adminlinks' => 'Бачити [[Special:AdminLinks|посилання для адміністраторів]]',
);

/** Vèneto (Vèneto)
 * @author Candalua
 * @author Vajotwo
 */
$messages['vec'] = array(
	'adminlinks' => 'Paneło admin',
	'adminlinks_documentation' => '$1 documentasion',
	'adminlinks_general' => 'Xenerałe',
	'adminlinks_editsidebar' => 'Modifega sidebar',
	'adminlinks_editcss' => 'Modifega file CSS',
	'adminlinks_editmainpagename' => 'Modifega el nome deła pajina prinsipałe',
	'adminlinks_users' => 'Utenti',
	'adminlinks_createuser' => 'Crea na utensa',
	'adminlinks_browsesearch' => 'Visuałisa e riserca',
	'adminlinks_importexport' => 'Inporta ed esporta',
	'right-adminlinks' => 'Vede el cołegamento al [[Special:AdminLinks|Paneło Admin]]',
);

/** Veps (Vepsan kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'adminlinks_general' => 'Ühthine',
	'adminlinks_editsidebar' => "Redaktiruida laptpanel'",
	'adminlinks_editcss' => 'Redaktiruida CSS-fail',
	'adminlinks_editmainpagename' => 'Redaktiruida pälehtpolen pälkirjutez',
	'adminlinks_users' => 'Kävutajad',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'adminlinks' => 'Liên kết quản lý',
	'adminlinks-desc' => 'Thêm [[Special:AdminLinks|trang đặc biệt]] liệt kê các liên kết có ích cho bảo quản viên',
	'adminlinks_documentation' => 'Tài liệu $1',
	'adminlinks_general' => 'Tổng quát',
	'adminlinks_editsidebar' => 'Thanh bên sửa đổi',
	'adminlinks_editcss' => 'Sửa đổi tập tin CSS',
	'adminlinks_editmainpagename' => 'Sửa đổi tên trang đầu',
	'adminlinks_users' => 'Người dùng',
	'adminlinks_createuser' => 'Mở tài khoản',
	'adminlinks_browsesearch' => 'Duyệt và tìm kiếm',
	'adminlinks_importexport' => 'Nhập và xuất',
	'right-adminlinks' => 'Xem [[Special:AdminLinks|các liên kết quản lý]]',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'adminlinks' => 'סיסאפ לינקען',
	'adminlinks_general' => 'אַלגעמיין',
	'adminlinks_editsidebar' => 'רעדאַקטירן זײַטפאַס',
	'adminlinks_editcss' => 'רעדאַקטירן CSS טעקע',
	'adminlinks_editmainpagename' => 'רעדאַקטירן נאָמען פֿון הויפּט בלאַט',
	'adminlinks_users' => 'באַניצער',
	'adminlinks_createuser' => 'שאַפֿן אַ באַניצער',
	'adminlinks_browsesearch' => 'בלעטערן און זוכן',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Franklsf95
 */
$messages['zh-hans'] = array(
	'adminlinks' => '管理员链接',
	'adminlinks-desc' => '添加一个[[Special:AdminLinks|特殊页面]]为管理员提供有用的链接',
	'adminlinks_documentation' => '$1 文档',
	'adminlinks_general' => '一般',
	'adminlinks_editsidebar' => '编辑侧边栏',
	'adminlinks_editcss' => '编辑 CSS 文件',
	'adminlinks_editmainpagename' => '编辑首页名称',
	'adminlinks_users' => '用户',
	'adminlinks_createuser' => '创建新用户',
	'adminlinks_browsesearch' => '浏览与搜索',
	'adminlinks_importexport' => '导入和导出',
	'right-adminlinks' => '查看[[Special:AdminLinks|管理员链接]]',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Horacewai2
 * @author Mark85296341
 * @author Waihorace
 */
$messages['zh-hant'] = array(
	'adminlinks' => '管理連結',
	'adminlinks-desc' => '新增一個[[Special:AdminLinks|特殊頁面]]為管理員提供有用的連結',
	'adminlinks_documentation' => '$1說明文件',
	'adminlinks_general' => '一般',
	'adminlinks_editsidebar' => '編輯導航欄',
	'adminlinks_editcss' => '編輯 CSS 檔案',
	'adminlinks_editmainpagename' => '編輯首頁名稱',
	'adminlinks_users' => '用戶',
	'adminlinks_createuser' => '建立一個新帳號',
	'adminlinks_browsesearch' => '瀏覽和搜尋',
	'adminlinks_importexport' => '匯入和匯出',
	'right-adminlinks' => '檢視[[Special:AdminLinks|管理連結]]',
);

/** Chinese (Hong Kong) (‪中文(香港)‬)
 * @author Mark85296341
 * @author Oapbtommy
 */
$messages['zh-hk'] = array(
	'adminlinks' => '管理員連結',
	'adminlinks_general' => '一般',
	'adminlinks_editcss' => '編輯 CSS 檔案',
	'adminlinks_editmainpagename' => '編輯主頁名稱',
	'adminlinks_users' => '用戶',
	'adminlinks_createuser' => '建立一名用戶',
	'adminlinks_browsesearch' => '瀏覽和搜尋',
	'adminlinks_importexport' => '匯入和匯出',
	'right-adminlinks' => '看看連結至[[Special:AdminLinks|管理員連結]]',
);

