<?php
/**
 * Internationalisation file for Widgets extension.
 *
 */

$messages = array();

$messages['en'] = array(
	'widgets-desc' => 'Allows wiki administrators to add free-form widgets to the wiki by editing pages within the {{ns:widget}} namespace.
Community-contributed widgets can be found on [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Error in [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Widget editors',
	'group-widgeteditor-member' => 'Widget editor',
	'grouppage-widgeteditor' => 'Project:Widget editors',
	'right-editwidgets' => 'Create and edit [http://www.mediawiki.org/wiki/Extension:Widgets widgets] in the <tt>{{ns:widget}}</tt> namespace',
);

/** Message documentation (Message documentation)
 * @author Fryed-peach
 * @author Khaledelmansoury
 * @author Purodha
 * @author Siebrand
 * @author Umherirrender
 */
$messages['qqq'] = array(
	'widgets-desc' => '{{desc}}',
	'grouppage-widgeteditor' => '{{doc-important|Leave "Project:" untranslated}}',
	'right-editwidgets' => '{{doc-right}}',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'widgets-desc' => 'Wiki jep mundësin administratorëve të shtoni pa-formë Widgets në wiki nga faqet redaktimi brenda {{ns:widget}} hapësira. Zhvilluar Fillimisht për [http://www.ardorado.com Ardorado.com]',
	'widgets-error' => 'Gabim në [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'redaktorët widget',
	'group-widgeteditor-member' => 'editor widget',
	'grouppage-widgeteditor' => 'Projekti: redaktorët widget',
	'right-editwidgets' => 'Krijo dhe ndrysho http://www.mediawiki.org/wiki/Extension:Widgets [Widgets] në <tt>{{ns:widget}}</tt> namespace',
);

/** Arabic (العربية)
 * @author ;Hiba;1
 * @author OsamaK
 */
$messages['ar'] = array(
	'widgets-desc' => 'يسمح لإداري الويكي بإضافة ودجات حرة الشكل إلى الويكي بتحرير صفحات النطاق {{ns:widget}}.
طُور أصلًا ب[http://www.ardorado.com Ardorado.com]',
	'widgets-error' => 'خطأ في [[{{ns:widget}}:$1|الودجة $1]]',
	'group-widgeteditor' => 'محررو الودجات',
	'group-widgeteditor-member' => 'محرر ودجات',
	'grouppage-widgeteditor' => 'Project:محررو الودجات',
	'right-editwidgets' => 'إنشاء وتحرير [http://www.mediawiki.org/wiki/Extension:Widgets widgets] في الــ <tt>{{ns:widget}}</tt> مكان الاسم',
);

/** Belarusian (Taraškievica orthography) (Беларуская (тарашкевіца))
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'widgets-desc' => 'Дазваляе адміністратарам {{GRAMMAR:родны|{{SITENAME}}}} дадаваць віджэты вольных формаў у {{GRAMMAR:вінавальны|{{SITENAME}}}} праз рэдагаваньне старонак у прасторы назваў {{ns:widget}}. 
Віджэты, якія падтрымліваюцца супольнасьцю, можна знайсьці на [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Памылка ў [[{{ns:widget}}:$1|віджэце $1]]',
	'group-widgeteditor' => 'Рэдактар віджэтаў',
	'group-widgeteditor-member' => 'Рэдактар віджэта',
	'grouppage-widgeteditor' => 'Project:Рэдактары віджэтаў',
	'right-editwidgets' => 'стварэньне і рэдагаваньне [http://www.mediawiki.org/wiki/Extension:Widgets дапаўненьняў] у прасторы назваў <tt>{{ns:widget}}</tt>',
);

/** Breton (Brezhoneg)
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'widgets-desc' => "Talvezout a ra d'ar verourien da ouzhpennañ widgetoù d'ar wiki en ur gemmañ pajennoù en esaouenn anv {{ns:widget}}.
Ar widgetoù kinniget gant ar gumuniezh a gaver war [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Fazi e [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Aozerien widget',
	'group-widgeteditor-member' => 'Aozer widget',
	'grouppage-widgeteditor' => 'Project:Aozerien widget',
	'right-editwidgets' => 'Krouiñ ha kemmañ ar [http://www.mediawiki.org/wiki/Extension:Widgets widgetoù] en esaouenn anv <tt>{{ns:widget}}<tt>',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'widgets-desc' => 'Omogućuje wiki administratorima da dodaju dodatke u slobodnoj formi na wiki putem uređivanja stranica unutar imenskog prostora {{ns:widget}}.
Prvobitno razvijeni dodaci se mogu naći na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Greška u [[{{ns:widget}}:$1|widgetu $1]]',
	'group-widgeteditor' => 'Uređivači dodataka',
	'group-widgeteditor-member' => 'Uređivač dodataka',
	'grouppage-widgeteditor' => 'Project:Uređivač dodataka',
	'right-editwidgets' => 'Pravljenje i uređivanje [http://www.mediawiki.org/wiki/Extension:Widgets widgeta] u imenskom prostoru <tt>{{ns:widget}}</tt>',
);

/** Catalan (Català)
 * @author Paucabot
 */
$messages['ca'] = array(
	'right-editwidgets' => "Creeu i editeu [http://www.mediawiki.org/wiki/Extension:Widgets ginys] a l'espai de noms <tt>{{ns:widget}}</tt>",
);

/** Czech (Česky)
 * @author Kuvaly
 * @author Matěj Grabovský
 * @author Mormegil
 * @author Reaperman
 */
$messages['cs'] = array(
	'widgets-desc' => 'Umožňuje správcům wiki přidávat na wiki ovládací prvky úpravou stránek ve jmenném prostoru {{ns:widget}}.
Prvky vytvořené komunitou lze nalézt na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Chyba ve [[{{ns:widget}}:$1|widgetu $1]]',
	'group-widgeteditor' => 'Editoři ovládacích prvků',
	'group-widgeteditor-member' => 'editor ovládacích prvků',
	'grouppage-widgeteditor' => 'Project:Editoři ovládacích prvků',
	'right-editwidgets' => 'Tvorba a úprava stránek [http://www.mediawiki.org/wiki/Extension:Widgets ovládacích prvků] ve jmenném prostoru <tt>{{ns:widget}}</tt>',
);

/** German (Deutsch)
 * @author Jan Luca
 * @author Kghbln
 * @author Pill
 * @author Sebastian Wallroth
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de'] = array(
	'widgets-desc' => 'Ermöglicht Administratoren das Hinzufügen von Freiformat-Widgets durch das Bearbeiten von Seiten im {{ns:widget}}-Namensraum.
Von der Gemeinschaft erstellte Widgets können unter [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] gefunden werden',
	'widgets-error' => 'Fehler im [[{{ns:widget}}:$1|Widget $1]]',
	'group-widgeteditor' => 'Widget-Bearbeiter',
	'group-widgeteditor-member' => 'Widget-Bearbeiter',
	'grouppage-widgeteditor' => 'Project:Widget-Bearbeiter',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Widgets] im <tt>{{ns:widget}}</tt>-Namensraum bearbeiten und erstellen',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'widgets-desc' => 'Dowólujo wikijowym administratoram wikijeju pśez wobźěłowanje w mjenjowem rumje {{ns:widget}} swójske miniprogramy pśidaś.
Miniprogramy, kótarež su se napórali wót zromaźeństwa, móžoš na  [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] namakaś.',
	'widgets-error' => 'Zmólka w [[{{ns:widget}}:$1|miniprogramje $1]]',
	'group-widgeteditor' => 'Wobźěłowarje miniprogramow',
	'group-widgeteditor-member' => 'Wobźěłowaŕ miniprogramow',
	'grouppage-widgeteditor' => 'Project: Wobźěłowarje miniprogramow',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Woknowe elementy] w mjenjowem rumje <tt>{{ns:widget}}</tt> napóraś a wobźěłaś',
);

/** Greek (Ελληνικά)
 * @author Lou
 * @author Omnipaedista
 * @author ZaDiak
 */
$messages['el'] = array(
	'widgets-desc' => 'Επιτρέπει στους βικι-διαχειριστές να προσθέσουν ελεύθερης μορφής γουίτζετ στο βίκι μέσω της επεξεργασίας σελίδων μέσα στον ονοματικό χώρο {{ns:widget}}.
Ανεπτυγμένο αρχικά για το [http://www.ardorado.com Ardorado.com]',
	'widgets-error' => 'Σφάλμα στο [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Επεξεργαστές Widget',
	'group-widgeteditor-member' => 'Επεξεργαστής Widget',
	'grouppage-widgeteditor' => 'Project:Επεξεργαστές Widget',
	'right-editwidgets' => 'Δημιουργία και επεξεργασία [http://www.mediawiki.org/wiki/Extension:Widgets widgets] στην περιοχή ονομάτων <tt>{{ns:widget}}</tt>',
);

/** Esperanto (Esperanto)
 * @author Airon90
 */
$messages['eo'] = array(
	'widgets-error' => 'Eraro en [[{{ns:widget}}:$1|fenestraĵo $1]]',
	'group-widgeteditor' => 'Fenestraĵaj eldonistoj',
	'group-widgeteditor-member' => 'Fenestraĵa eldonisto',
	'grouppage-widgeteditor' => 'Project:Fenestraĵaj eldonistoj',
	'right-editwidgets' => 'Krei kaj redakti [http://www.mediawiki.org/vikia/Extension:Widgets fenestraĵojn] en la nomspaco <tt>{{ns:widget}}</tt>',
);

/** Spanish (Español)
 * @author Antur
 * @author Crazymadlover
 * @author Diego Grez
 * @author Peter17
 */
$messages['es'] = array(
	'widgets-desc' => 'Permite a los administradores agregar widgets a la wiki editando páginas dentro del espacio de nombres {{ns:widget}}.
Widgets desarrollados comunitariamente pueden ser encontrados en [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Error en [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Editores de widget',
	'group-widgeteditor-member' => 'Editor de widget',
	'grouppage-widgeteditor' => 'Project:Editores de widget',
	'right-editwidgets' => 'Crear y editar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] en el espacio de nombre "{{ns:widget}}"',
);

/** Finnish (Suomi)
 * @author Cimon Avaro
 * @author Crt
 * @author Nike
 */
$messages['fi'] = array(
	'widgets-desc' => 'Mahdollistaa wikin ylläpitäjille vapaamuotoisten pienoisohjelmien lisäämisen sivua nimiavaruudessa {{ns:widget}} muokkaamalla.
Yhteisön tekemiä pienoisohjelmia löytyy osoitteesta [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Virhe [[{{ns:widget}}:$1|pienoisohjelmassa $1]]',
	'group-widgeteditor' => 'pienoisohjelmien muokkaajat',
	'group-widgeteditor-member' => 'pienoisohjelman muokkaaja',
	'grouppage-widgeteditor' => 'Project:Pienoisohjelmien muokkaajat',
	'right-editwidgets' => 'Luoda ja muokata [http://www.mediawiki.org/wiki/Extension:Widgets pienoisohjelmia] nimiavaruudessa <tt>{{ns:widget}}</tt>',
);

/** French (Français)
 * @author IAlex
 * @author Jean-Frédéric
 * @author Urhixidur
 */
$messages['fr'] = array(
	'widgets-desc' => "Permet aux administrateurs du wiki d'ajouter des ''widgets'' (gadgets logiciels) au wiki en modifiant des pages dans l’espace de noms {{ns:widget}}. Les ''widgets'' proposés par la communauté sont disponibles sur [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Erreur dans le [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Modificateurs de widgets',
	'group-widgeteditor-member' => 'modificateur de widgets',
	'grouppage-widgeteditor' => 'Project:Modificateurs de widgets',
	'right-editwidgets' => 'Créer et modifier les [http://www.mediawiki.org/wiki/Extension:Widgets widgets] dans l’espace de noms « {{ns:widget}} »',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'widgets-error' => 'Èrror dens lo [[{{ns:widget}}:$1|vouidgèt $1]]',
	'group-widgeteditor' => 'Changiors de vouidgèts',
	'group-widgeteditor-member' => 'Changior de vouidgèts',
	'grouppage-widgeteditor' => 'Project:Changiors de vouidgèts',
	'right-editwidgets' => 'Fâre et changiér los [http://www.mediawiki.org/wiki/Extension:Widgets vouidgèts] dens l’èspâço de noms « {{ns:widget}} »',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'widgets-desc' => 'Permite aos administradores do wiki engadir widgets ao editar páxinas no espazo de nomes "{{ns:widget}}".
Pódense atopar os widgets desenvolvidos para a comunidade en [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Erro no [[{{ns:widget}}:$1|widget "$1"]]',
	'group-widgeteditor' => 'Editores de widgets',
	'group-widgeteditor-member' => 'Editor de widgets',
	'grouppage-widgeteditor' => 'Project:Editores de widgets',
	'right-editwidgets' => 'Crear e editar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] no espazo de nomes <tt>{{ns:widget}}</tt>',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'widgets-desc' => 'Erlaubt Wikiadministratore Frej-Form-Widgets zum Wiki zuezfiege dur d Bearbeitig vu Syte im {{ns:widget}}-Namensruum.
Vu dr Gmeinschaft aagleiti Widgets chenne unter [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] gfunde wäre.',
	'widgets-error' => 'Fähler im [[{{ns:widget}}:$1|Widget $1]]',
	'group-widgeteditor' => 'Widget-Editore',
	'group-widgeteditor-member' => 'Widget-Editor',
	'grouppage-widgeteditor' => 'Project:Widget-Editore',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Widgets] im <tt>{{ns:widget}}</tt>-Namensruum aalege un bearbeite',
);

/** Hebrew (עברית)
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'widgets-desc' => 'מתן האפשרות למנהלי אתר הוויקי להוסיף וידג׳טים הבנויים בצורה חופשית לאתר הוויקי באמצעות עריכת הדפים שבמרחב השם {{ns:widget}}.
ניתן למצוא וידג׳טים שנתרמו על ידי הקהילה ב־[http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => "שגיאה ב[[{{ns:widget}}:$1|ווידג'ט $1]]",
	'group-widgeteditor' => "עורכי וידג'טים",
	'group-widgeteditor-member' => "עורך וידג'טים",
	'grouppage-widgeteditor' => "Project:עורכי וידג'טים",
	'right-editwidgets' => 'יצירה ועריכה של [http://www.mediawiki.org/wiki/Extension:Widgets וידג׳טים] במרחב השם <tt>{{ns:widget}}</tt>',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'widgets-desc' => '↓ Dowola wikijowym administratoram wikijej přez wobdźěłowanje stronow znutřka mjenjoweho ruma {{ns:widget}} swójske miniprogramy přidać.
Wot zhromadźenstwa wutowrjene miniprogramy móžeš na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] namakać.',
	'widgets-error' => 'Zmylk w [[{{ns:widget}}:$1|miniprogramje $1]]',
	'group-widgeteditor' => 'Wobdźěłowarjo miniprogramow',
	'group-widgeteditor-member' => 'Wobdźěłowar miniprogramow',
	'grouppage-widgeteditor' => 'Project:Wobdźěłowarjo miniprogramow',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Woknowe elementy] w mjenowym rumje <tt>{{ns:widget}}</tt> wutworić a wobdźěłać',
);

/** Hungarian (Magyar)
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'widgets-desc' => 'Lehetővé teszi a wiki adminisztrátorainak, hogy kötetlen alakú minialkalmazásokat adjanak a wikihez lapok szerkesztésével a(z) {{ns:widget}} névtérben. Eredetileg az [http://www.ardorado.com Ardorado.com] számára kifejlesztve',
	'widgets-error' => 'Hiba a(z) [[{{ns:widget}}:$1|$1 minialkalmazásban]]',
	'group-widgeteditor' => 'Minialkalmazás szerkesztői',
	'group-widgeteditor-member' => 'Minialkalmazás-szerkesztő',
	'grouppage-widgeteditor' => 'Project:Minialkalmazás-szerkesztők',
	'right-editwidgets' => 'widgetek létrehozása és szerkesztése a <tt>{{ns:widget}}</tt> névtérben',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'widgets-desc' => 'Permitte al administratores del wiki inserer widgets qualcunque in le wiki, per modificar paginas intra le spatio de nomines {{ns:widget}}.
Le widgets contribuite per le communitate se trova a [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Error in [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Modificatores de widgets',
	'group-widgeteditor-member' => 'Modificator de widgets',
	'grouppage-widgeteditor' => 'Project:Modificatores de widgets',
	'right-editwidgets' => 'Crear e modificar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] in le spatio de nomines <tt>{{ns:widget}}</tt>',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Irwangatot
 */
$messages['id'] = array(
	'widgets-desc' => 'Mengijinkan pengurus wiki untuk menambahkan formulir bebas widget ke wiki dengan menyunting halaman di ruang nama {{ns:widget}}.
komunitas kontribusi widgets dapat di temuai pada [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Kesalahan pada [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Penyunting widget',
	'group-widgeteditor-member' => 'Penyunting widget',
	'grouppage-widgeteditor' => 'Project:Penyunting widget',
	'right-editwidgets' => 'Buat dan Sunting halaman [http://www.mediawiki.org/wiki/Extension:Widgets widgets]  di <tt>{{ns:widget}}</tt> ruang nama',
);

/** Italian (Italiano)
 * @author Beta16
 * @author Civvì
 * @author Darth Kule
 */
$messages['it'] = array(
	'widgets-desc' => 'Permette agli amministratori del sito di aggiungere widget liberi al sito modificando pagine nel namespace {{ns:widget}}.
Widget creati dalla comunità possono essere trovati su [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Errore nel [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Editori widget',
	'group-widgeteditor-member' => 'Editore widget',
	'grouppage-widgeteditor' => 'Project:Editori widget',
	'right-editwidgets' => 'Crea e modifica [http://www.mediawiki.org/wiki/Extension:Widgets widget] nel namespace <tt>{{ns:widget}}</tt>',
);

/** Japanese (日本語)
 * @author Fryed-peach
 * @author Iwai.masaharu
 * @author 青子守歌
 */
$messages['ja'] = array(
	'widgets-desc' => '管理者が「{{ns:widget}}」名前空間内のページを編集し、ウィキに自由な形式のウィジェットを追加できるようにする。
コミュニティから提供されているウィジェットは [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org] にあります。',
	'widgets-error' => '[[{{ns:widget}}:$1|ウィジェット $1]]にエラー',
	'group-widgeteditor' => 'ウィジェット編集者',
	'group-widgeteditor-member' => 'ウィジェット編集者',
	'grouppage-widgeteditor' => 'Project:ウィジェット編集者',
	'right-editwidgets' => '<tt>{{ns:widget}}</tt>名前空間で[http://www.mediawiki.org/wiki/Extension:Widgets ウィジット]を作成または編集する',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'widgets-desc' => 'Määt et müjjelesch, dat Wiki-Köbeße <i lang="en">Widgets</i> en ene freie Forrem en däm Appachtemang „{{ns:widget}}“ enndraare.
Divärse Lück han ehr <i lang="en">Widgets</i> op <i lang="en">[http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]</i> öffentlesch jemaat.',
	'widgets-error' => 'Doh es ene Fähler em [[{{ns:widget}}:$1|<i lang="en">Widget</i> $1]]',
	'group-widgeteditor' => 'Schriiver för <i lang="en">Widgets</i>',
	'group-widgeteditor-member' => '<i lang="en">Widget</i>-Schriiver',
	'grouppage-widgeteditor' => 'Project:Widget-Schriiver',
	'right-editwidgets' => 'Sigge, alsu <i lang="en">[http://www.mediawiki.org/wiki/Extension:Widgets Widgets]</i>, em Appachemang „{{ns:widget}}“ ändere udder aanlääje',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'widgets-error' => 'Feeler an [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Widget-Editeuren',
	'group-widgeteditor-member' => 'Widget-Editeur',
	'grouppage-widgeteditor' => 'Project:Widget Editeuren',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets widgets] am <tt>{{ns:widget}}</tt> Nummraum uleeën an  änneren',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'widgets-desc' => 'Им овозможува на администраторите да додаваат посреднички елементи со уредување на страници во именскиот простор {{ns:widget}}.
Елементи изработени од учесници од заедницата можете да најдете на  [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Грешка во [[{{ns:widget}}:$1|посредничкиот елемент $1]]',
	'group-widgeteditor' => 'Уредници на посреднички елементи',
	'group-widgeteditor-member' => 'Уредник на посреднички елементи',
	'grouppage-widgeteditor' => 'Project:Уредници на посреднички елементи',
	'right-editwidgets' => 'Создавање и уредување на [http://www.mediawiki.org/wiki/Extension:Widgets направи] во именскиот простор <tt>{{ns:widget}}</tt>',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'widgets-desc' => "Stelt wikibeheerders in staat naar eigen inzicht widgets aan de wiki toe te voegen door het bewerken van pagina's in de naamruimte {{ns:widget}}.
Door de gemeenschap ontwikkelde widgets zijn te vinden op [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Fout in [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Widgetbewerkers',
	'group-widgeteditor-member' => 'Widgetbewerker',
	'grouppage-widgeteditor' => 'Project:Widgetbewerkers',
	'right-editwidgets' => '[http://www.mediawiki.org/wiki/Extension:Widgets Widgets] aanmaken en bewerken in de naamruimte <tt>{{ns:widget}}</tt>',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Harald Khan
 */
$messages['nn'] = array(
	'right-editwidgets' => 'Endra sider i «{{ns:widget}}»-namnerommet',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Nghtwlkr
 */
$messages['no'] = array(
	'widgets-desc' => 'Tillater wikiadministratorer å legge til fri-form skjermelement til wikien ved å redigere siden innen {{ns:widget}}-navnerommet.
Fellesskaps-bidratte skjermelement kan finnes på [http://mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Feil i [[{{ns:widget}}:$1|skjermelement $1]]',
	'group-widgeteditor' => 'Bidragsytere for skjermelement',
	'group-widgeteditor-member' => 'Bidragsyter for skjermelement',
	'grouppage-widgeteditor' => 'Project:Bidragsytere for skjermelement',
	'right-editwidgets' => 'Lag og rediger [http://www.mediawiki.org/wiki/Extension:Widgets skjermelement] i <tt>{{ns:widget}}</tt>-navnerommet',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'widgets-desc' => "Permet als administrators del wiki d'apondre de widgets al wiki en modificant de paginas dins l'espac de noms {{ns:widget}}. Desvolopat a la basa per [http://www.ardorado.com Ardorado.com]",
	'widgets-error' => 'Error dins lo [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Modificators de widgets',
	'group-widgeteditor-member' => 'modificator de widgets',
	'grouppage-widgeteditor' => 'Project:Modificators de widgets',
	'right-editwidgets' => "Crear e modificar las [http://www.mediawiki.org/wiki/Extension:Widgets widgets] dins l'espaci de noms « {{ns:widget}} »",
);

/** Polish (Polski)
 * @author Sp5uhe
 * @author ToSter
 */
$messages['pl'] = array(
	'widgets-desc' => 'Pozwala administratorom wiki na dodawanie widżetów w dowolnej formie do wiki poprzez edycję stron w przestrzeni nazw {{ns:widget}}.
Widżety stworzone przez społeczność można odnaleźć na stronie [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Błąd w [[{{ns:widget}}:$1|widżecie $1]]',
	'group-widgeteditor' => 'Edytorzy widżetów',
	'group-widgeteditor-member' => 'Edytor widżetów',
	'grouppage-widgeteditor' => 'Project:Edytorzy widżetów',
	'right-editwidgets' => 'Tworzenie i edycja [http://www.mediawiki.org/wiki/Extension:Widgets widżetów] w przestrzeni nazw <tt>{{ns:widget}}</tt>',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'widgets-desc' => "A përmët a j'aministrator dla wiki ëd gionté ëd widget a forma lìbera a la wiki an modificand dle pàgine ant lë spassi nominal {{ns:widget}}.
Dij widget creà da la comunità a peulo esse trovà su [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Eror an [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Editor ëd widget',
	'group-widgeteditor-member' => 'Editor ëd widget',
	'grouppage-widgeteditor' => 'Project:Editor ëd widget',
	'right-editwidgets' => 'Crea e modìfica [http://www.mediawiki.org/wiki/Extension:Widgets widgets] ant lë spassi nominal <tt>{{ns:widget}}</tt>',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'widgets-desc' => "Permite que os administradores da wiki adicionem ''widgets free-form'' à wiki, editando páginas no espaço nominal {{ns:widget}}.
Widgets fornecidos pela comunidade podem ser encontrados na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => "Erro no [[{{ns:widget}}:$1|''widget'' $1]]",
	'group-widgeteditor' => "Editores de ''widgets''",
	'group-widgeteditor-member' => "Editor de ''widgets''",
	'grouppage-widgeteditor' => "Project:Editores de ''widgets''",
	'right-editwidgets' => 'Criar e editar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] no espaço nominal <tt>{{ns:widget}}</tt>',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 * @author Giro720
 * @author Heldergeovane
 */
$messages['pt-br'] = array(
	'widgets-desc' => "Permite que os administradores da wiki adicionem ''widgets free-form'' à wiki, editando páginas no espaço nominal {{ns:widget}}.
Widgets fornecidos pela comunidade podem ser encontrados na [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]",
	'widgets-error' => 'Erro em [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Editores de widget',
	'group-widgeteditor-member' => 'Editor de widget',
	'grouppage-widgeteditor' => 'Project:Editores de widget',
	'right-editwidgets' => 'Criar e editar [http://www.mediawiki.org/wiki/Extension:Widgets widgets] no espaço nominal <tt>{{ns:widget}}</tt>',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'widgets-error' => "Errore jndr'à [[{{ns:widget}}:$1|widget $1]]",
);

/** Russian (Русский)
 * @author G0rn
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'widgets-desc' => 'Позволяет администраторам вики добавлять различные виджеты, посредством редактирования страниц пространства имён {{ns:widget}}. Поддерживаемые сообществом виджеты можно найти на [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Ошибка в [[{{ns:widget}}:$1|виджете $1]]',
	'group-widgeteditor' => 'Редакторы виджетов',
	'group-widgeteditor-member' => 'Редактор виджетов',
	'grouppage-widgeteditor' => 'Project:Редакторы виджетов',
	'right-editwidgets' => 'создавать и редактировать [http://www.mediawiki.org/wiki/Extension:Widgets виджеты] страницы в пространстве имён <tt>{{ns:widget}}</tt>',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'widgets-desc' => 'Umožňuje správcom wiki pridávať ovládacie prvky na wiki úpravou stránky v mennom priestore {{ns:widget}}.
Pôvodne vyvinuté pre [http://www.ardorado.com Ardorado.com]',
	'widgets-error' => 'Chyba v [[{{ns:widget}}:$1|ovládacom prvku $1]]',
	'group-widgeteditor' => 'Editori ovládacích prvkov',
	'group-widgeteditor-member' => 'Editor ovládacích prvkov',
	'grouppage-widgeteditor' => 'Project:Editori ovládacích prvkov',
	'right-editwidgets' => 'upravovať stránky v mennom priestore „{{ns:widget}}“',
);

/** Swedish (Svenska)
 * @author Ozp
 * @author Per
 */
$messages['sv'] = array(
	'widgets-error' => 'Fel i [[{{ns:widget}}:$1|widget $1]]',
	'group-widgeteditor' => 'Widgeteditorer',
);

/** Telugu (తెలుగు)
 * @author Ravichandra
 */
$messages['te'] = array(
	'group-widgeteditor' => 'విడ్జెట్ ఎడిటర్లు',
	'group-widgeteditor-member' => 'విడ్జెట్ ఎడిటర్',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'widgets-desc' => 'Nagpapahintulot sa mga tagapangasiwa ng wiki na makapagdagdag ng may malayang anyong mga widyet sa wiki sa pamamagitan ng pagbago sa mga pahinang nasa loob ng puwang pampangalan na {{ns:widget}}.
Ang mga widyet na inambag ng pamayan ay matatagpuan sa [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Kamalian sa loob ng [[{{ns:widget}}:$1|widyet na $1]]',
	'group-widgeteditor' => 'Mga patnugot ng widyet',
	'group-widgeteditor-member' => 'Patnugot ng widyet',
	'grouppage-widgeteditor' => 'Project:Mga patnugot ng widyet',
	'right-editwidgets' => 'Lumikha at baguhin ang [http://www.mediawiki.org/wiki/Extension:Widgets mga widyet] sa loob ng puwang na pampangalan ng <tt>{{ns:widget}}</tt>',
);

/** Ukrainian (Українська)
 * @author Prima klasy4na
 * @author Тест
 */
$messages['uk'] = array(
	'widgets-desc' => 'Дозволяє адміністраторам вікі додавати різноманітні віджети шляхом редагування сторінок простору назв {{ns:widget}}.
Підтримувані спільнотою віджети можна знайти на [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]',
	'widgets-error' => 'Помилка [[{{ns:widget}}:$1|віджету $1]]',
	'group-widgeteditor' => 'Редактори віджетів',
	'group-widgeteditor-member' => 'Редактор віджетів',
	'grouppage-widgeteditor' => 'Project:Редактори віджетів',
	'right-editwidgets' => 'Створювати і редагувати [http://www.mediawiki.org/wiki/Extension:Widgets віджети] у просторі назв <tt>{{ns:widget}}</tt>',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'widgets-desc' => 'Cho phép các quản lý viên wiki thêm công cụ đa năng vào wiki bằng cách sửa đổi trang trong không gian tên {{ns:widget}}.
Có thể lấy thêm công cụ đa năng do cộng đồng đóng góp tại [http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org].',
	'widgets-error' => 'Lỗi trong [[{{ns:widget}}:$1|công cụ đa năng $1]]',
	'group-widgeteditor' => 'Người sửa công cụ đa năng',
	'group-widgeteditor-member' => 'Người sửa công cụ đa năng',
	'grouppage-widgeteditor' => 'Project:Người sửa công cụ đa năng',
	'right-editwidgets' => 'Tạo và sửa [http://www.mediawiki.org/wiki/Extension:Widgets?uselang=vi công cụ đa năng] trong không gian tên <tt>{{ns:widget}}</tt>',
);

/** Cantonese (粵語) */
$messages['yue'] = array(
	'widgets-desc' => '容許wiki管理員響{{ns:widget}}空間名度加入自由形式嘅widget響個wiki度。
原先為[http://www.ardorado.com Ardorado.com]而設計嘅',
	'widgets-error' => '響[[{{ns:widget}}:$1|widget $1]]出錯',
	'group-widgeteditor' => 'Widget編輯器',
	'group-widgeteditor-member' => 'Widget編輯器',
	'grouppage-widgeteditor' => 'Project:Widget編輯器',
	'right-editwidgets' => '響"{{ns:widget}}"空間名度編輯頁',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Xiaomingyan
 */
$messages['zh-hans'] = array(
	'widgets-desc' => '允许wiki管理员通过编辑{{ns:widget}}名称空间中的页面以添加自由形式的小工具至wiki。
[http://www.mediawikiwidgets.org/Main_Page MediaWikiWidgets.org]提供社区贡献的小工具',
	'widgets-error' => '[[{{ns:widget}}:$1|小工具$1]]出错',
	'group-widgeteditor' => '小工具编辑器',
	'group-widgeteditor-member' => '小工具编辑器',
	'grouppage-widgeteditor' => 'Project:小工具编辑器',
	'right-editwidgets' => '创建并编辑<tt>{{ns:widget}}</tt>名称空间中的[http://www.mediawiki.org/wiki/Extension:Widgets 小工具]',
);

/** Traditional Chinese (‪中文(繁體)‬) */
$messages['zh-hant'] = array(
	'widgets-desc' => '容許wiki管理員在{{ns:widget}}名字空間中加入自由形式的widget至wiki中。
原先為[http://www.ardorado.com Ardorado.com]設計',
	'widgets-error' => '在[[{{ns:widget}}:$1|widget $1]]發生錯誤',
	'group-widgeteditor' => 'Widget編輯器',
	'group-widgeteditor-member' => 'Widget編輯器',
	'grouppage-widgeteditor' => 'Project:Widget編輯器',
	'right-editwidgets' => '在"{{ns:widget}}"名字空間中編輯頁面',
);

