﻿

/* change-list.js */
Exhibit.ChangeList=function(B,A,C){this._div=SimileAjax.jQuery(B);
this._uiContext=A;
this._settings=C;
A.getDatabase().addListener(this);
this._initializeUI();
};
Exhibit.ChangeList._settingSpecs={submissionText:{type:"text",defaultValue:"Thanks for your submission! It has been sent to the exhibit author for approval."},placeholderText:{type:"text",defaultValue:"To begin editing this exhibit, click the 'edit' links on the exhibit items."},maxValueLength:{type:"int",defaultValue:50},trunctationString:{type:"text",defaultValue:"..."}};
Exhibit.UI.generateCreationMethods(Exhibit.ChangeList);
Exhibit.UI.registerComponent("change-list",Exhibit.ChangeList);
Exhibit.ChangeList.showSubmissionText=false;
Exhibit.ChangeList.prototype.dispose=function(){this._uiContext.getDatabase().removeListener(this);
this._div.innerHTML="";
this._div=null;
this._uiContext=null;
this._settings=null;
};
Exhibit.ChangeList.prototype.onAfterLoadingItems=function(){this._initializeUI();
};
Exhibit.ChangeList.prototype.addMockData=function(A){this._uiContext.getDatabase().addItem({label:"Gone With The Wind",type:"book",author:"Margaret Mitchell",year:"1936",availability:"available",owner:"Sarah",description:"Goin' down south"});
this._uiContext.getDatabase().editItem("White Noise","year","1990");
this._uiContext.getDatabase().editItem("White Noise","label","White Noice");
};
Exhibit.ChangeList.defaultMaxValueLength=50;
Exhibit.ChangeList.defaultTrunctationString="...";
Exhibit.ChangeList.prototype.makePlaceholder=function(){var A=SimileAjax.jQuery("<span>").addClass("placeholderMessage");
if(Exhibit.ChangeList.showSubmissionText){Exhibit.ChangeList.showSubmissionText=false;
A.text(this._settings.submissionText);
}else{A.text(this._settings.placeholderText);
}return A;
};
Exhibit.ChangeList.prototype.renderPropChange=function(G,A,B){var D=function(H,J,I){if(I){return SimileAjax.jQuery("<span>").text(H).addClass(J).attr("title",I);
}else{return SimileAjax.jQuery("<span>").text(H).addClass(J);
}};
var F=SimileAjax.jQuery("<div>").addClass("property-change");
var E;
var C=this._settings.trunctationString.length;
if(B.length-C>this._settings.maxValueLength){E=B;
B=B.slice(0,this._settings.maxValueLength-C)+"...";
}if(A){F.append(D(G,"property-name")," was changed from ",D(A,"old-value")," to ",D(B,"new-value",E));
}else{F.append(D(G,"property-name")," was set to ",D(B,"new-value",E));
}return F;
};
Exhibit.ChangeList.prototype.renderItem=function(C){var B=C.label+" was "+C.changeType;
var E=SimileAjax.jQuery("<div>").append(SimileAjax.jQuery("<div>").text(B).addClass("change-label"));
for(var D in C.vals){var A=C.vals[D];
E.append(this.renderPropChange(D,A.oldVal,A.newVal));
}return E;
};
Exhibit.ChangeList.prototype._initializeUI=function(){this._div.empty();
var A=this;
var B=this._uiContext.getDatabase().collectAllChanges();
B.sort(function(D,C){return D.label>C.label;
});
if(B.length==0){this._div.append(this.makePlaceholder());
if(Exhibit.Submission){Exhibit.Submission.disableWidgets();
}}else{if(Exhibit.Submission){Exhibit.Submission.enableWidgets();
}B.forEach(function(C){A._div.append(A.renderItem(C));
});
}};


/* curate-view.js */
(function(){var F=SimileAjax.jQuery;
Exhibit.CurateView=function(L,K){this._div=F(L).addClass("CurateView");
this._uiContext=K;
this._settings={};
this._accessors={};
this._submissions=null;
K.getCollection().addListener(this);
};
Exhibit.CurateView._settingSpecs={adminURL:{type:"text",defaultValue:"admin.py"}};
Exhibit.CurateView.create=function(N,M,L){var K=new Exhibit.CurateView(M,Exhibit.UIContext.create(N,L));
Exhibit.SettingsUtilities.collectSettings(N,Exhibit.CurateView._settingSpecs,K._settings);
K._initializeUI();
return K;
};
Exhibit.CurateView.createFromDOM=function(N,M,L){var O=Exhibit.getConfigurationFromDOM(N);
var K=new Exhibit.CurateView(M!=null?M:N,Exhibit.UIContext.createFromDOM(N,L));
Exhibit.SettingsUtilities.collectSettingsFromDOM(N,Exhibit.CurateView._settingSpecs,K._settings);
Exhibit.SettingsUtilities.collectSettings(O,Exhibit.CurateView._settingSpecs,K._settings);
K._initializeUI();
return K;
};
Exhibit.CurateView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this);
this._div.innerHTML="";
this._div=null;
this._uiContext=null;
this._settings=null;
this._accessors=null;
this._submissions=null;
};
Exhibit.CurateView.prototype.adminURL=function(){return this._settings.adminURL;
};
function J(K){return SimileAjax.JSON.toJSONString(K);
}function H(K,L){return F('<input type="button">').val(K).click(L);
}function A(K){return exhibit.getDatabase().getProperty(K).getLabel();
}function C(L,K){return function(){L.find(".buttonDiv").attr("disabled",true);
var M=confirm("Are you sure you want to remove this submission? This action cannot be undone!");
if(M){var N={"command":"dismiss","sub_id":K.sub_id};
F.get(view.adminURL(),"message="+J(N),function(){L.remove();
});
}};
}function G(M,L){var K=M.find(".edit").map(function(){var N={label:F(this).attr("label"),values:{}};
F(this).find("input[property]").each(function(){var P=F(this).attr("property");
var O=F(this).val();
N.values[P]=O;
});
return N;
});
return{sub_id:L.sub_id,edits:K};
}function E(K,M,L){return function(){J(G(M,L));
};
}function D(K,P,O,M){var P=F("<div>").addClass("edit").attr("label",M.label);
var N=M.type=="modified"?"Changes to "+M.label:"New Item ("+M.label+")";
P.append(F("<div>").addClass("header").append(N));
var L=F("<table>").appendTo(P);
M.values.forEach(function(R){var Q=F("<input>").val(R.value).attr("property",R.property);
L.append(F("<tr>").addClass("value").append(F("<td>").append(A(R.property)),F("<td>").append(Q),F("<td>").append(F('<input type="checkbox">'))));
});
return P;
}function I(K,N,L){var N=F("<div>").addClass("submission").attr("sub_id",L.sub_id);
if(L.comment){N.append(F("<p>").text("Submittor's comment: "+L.comment));
}L.edits.forEach(function(O){N.append(D(K,N,L,O));
});
var M=F("<div>").addClass("buttonDiv").append(H("Dismiss",C(K,N,L)),H("Approve",E(K,N,L)));
N.append(M);
return N;
}function B(K){return function(L){Exhibit.CurateView._submissions=L;
K._div.empty();
K._div.append(F("<h1>").text("Submissions"));
L.forEach(function(M){K._div.append(I(K,K._div,M));
});
};
}Exhibit.CurateView.prototype._initializeUI=function(){var L=F("head link[rel=exhibit/submissions]");
if(L.length>0){var K=L.attr("href");
F.getJSON(K,B(this));
this._div.append(F("<h1>").text("Loading..."));
}else{this._div.append(F("<h1>").text("No submission link was provided!"));
}};
})();


/* item-creator.js */
Exhibit.ItemCreator=function(C,B,D){var A=B.getDatabase();
if(C.nodeName.toLowerCase()=="a"){C.href="javascript:";
}SimileAjax.jQuery(C).click(function(){if(Exhibit.ItemCreator.ItemBoxPresent){return ;
}var E={type:D.itemType};
Exhibit.ItemCreator.makeNewItemBox(B,E,D);
});
SimileAjax.jQuery(C).addClass("exhibit-itemCreator");
return C;
};
Exhibit.ItemCreator._settingSpecs={"itemType":{type:"text",defaultValue:"Item"},"automaticallySubmit":{type:"boolean",defaultValue:false},"submissionMessage":{type:"text"},"cancelButtonText":{type:"text",defaultValue:"Cancel"},"createButtonText":{type:"text",defaultValue:"Add Item"}};
Exhibit.UI.generateCreationMethods(Exhibit.ItemCreator);
Exhibit.UI.registerComponent("item-creator",Exhibit.ItemCreator);
Exhibit.ItemCreator.ItemBoxPresent=false;
Exhibit.ItemCreator.makeNewItemID=function(B,E){var D=B.getType(E).getLabel();
var A="Untitled "+D;
var F="";
var C=A;
while(B.containsItem(C)){F++;
C=A+" "+F;
}return C;
};
Exhibit.ItemCreator.makeNewItemBox=function(B,F,E){Exhibit.ItemCreator.ItemBoxPresent=true;
SimileAjax.jQuery(".exhibit-itemCreator").css("color","AAA");
var A=B.getDatabase();
E=E||{};
var D=$("<div><h1 class='exhibit-focusDialog-header' id='boxHeader'></h1><div class='exhibit-focusDialog-viewContainer' id='itemContainer'></div><div class='exhibit-focusDialog-controls'><button id='cancelButton' style='margin-right: 2em'>Cancel</button><button id='createButton' style='margin-left: 2em'>Add Item</button></div></div>");
if(E.title){D.find("#boxHeader").text(E.title);
}else{D.find("#boxHeader").remove();
}if(E.cancelButtonText){D.find("#cancelButton").text(E.cancelButtonText);
}if(E.createButtonText){D.find("#createButton").text(E.createButtonText);
}D.addClass("exhibit-focusDialog").addClass("exhibit-ui-protection");
D.css({top:document.body.scrollTop+100+"px",background:"#EEE repeat",paddingBottom:"0px"});
F.type=F.type||"item";
F.id=F.id||Exhibit.ItemCreator.makeNewItemID(A,F.type);
F.label=F.label||F.id;
A.addItem(F);
var C=D.find("#itemContainer").get(0);
B.getLensRegistry().createEditLens(F.id,C,B,{disableEditWidgets:true});
var G=function(){D.remove();
Exhibit.ItemCreator.ItemBoxPresent=false;
SimileAjax.jQuery(".exhibit-itemCreator").css("color","");
};
D.find("#cancelButton").click(function(){G();
database.removeItem(F.id);
});
D.find("#createButton").click(function(){if(E.automaticallySubmit){D.find(".exhibit-focusDialog-controls button").attr("disabled","disabled");
var H=function(){database.fixChangesForItem(F.id);
G();
if(E.submissionMessage){alert(E.submissionMessage);
}};
var I=function(K,L,J){alert("Error saving new item to server!\n\n"+L);
D.find(".exhibit-focusDialog-controls button").removeAttr("disabled");
};
Exhibit.SubmissionBackend.submitItemChanges(B,F.id,H,I);
}else{G();
}});
D.appendTo(document.body);
};


/* scraper.js */
Exhibit.Scraper=function(C,B,D){if(!D.scraperInput){SimileAjax.Debug.warn("Scraper not given an input element!");
return ;
}var A=this._input=SimileAjax.jQuery("#"+D.scraperInput);
A.val("");
A.attr("disabled",false);
var C=this._elmt=SimileAjax.jQuery(C);
this._uiContext=B;
this._settings=D;
C.attr("href","javascript:");
var E=this;
C.click(function(){E.activate();
});
};
Exhibit.Scraper._settingSpecs={"scraperInput":{type:"text"},"itemType":{type:"text",defaultValue:"item"},"inputType":{type:"text",defaultValue:"auto"},"scraperService":{type:"text",defaultValue:"http://valinor.mit.edu/sostler/scraper.cgi"}};
Exhibit.UI.generateCreationMethods(Exhibit.Scraper);
Exhibit.UI.registerComponent("scraper",Exhibit.Scraper);
Exhibit.Scraper.prototype.activate=function(){var A=this._input.val();
if(this._settings.inputType=="auto"){if(A.startsWith("http://")){this.scrapeURL(A);
}else{this.scrapeText(A);
}}else{if(this._settings.inputType=="text"){this.scrapeText(A);
}else{if(this._settings.inputType.toLowerCase()=="url"){this.scrapeURL(A);
}else{SimileAjax.Debug.warn("Unknown scraper input type "+this._settings.inputType);
}}}};
Exhibit.Scraper.prototype.disableUI=function(){this._input.attr("disabled",true);
this._elmt.removeAttr("href");
this._elmt.css("color","AAA");
this._elmt.unbind();
};
Exhibit.Scraper.prototype.enableUI=function(){var A=this;
this._input.attr("disabled",false);
this._elmt.attr("href","javascript:");
this._elmt.css("color","");
SimileAjax.jQuery(this._elmt).click(function(){A.activate();
});
};
Exhibit.Scraper.prototype.scrapeURL=function(A){this.disableUI();
var B=this;
var C=function(E){var D=E.status;
if(D=="ok"){B.scrapePageSource(E.obj);
}else{if(D=="error"){alert("Error using scraper service!\n\n"+E.obj);
}else{alert("Unknown response from scraper service:\n\n"+D);
}}B.enableUI();
};
this.disableUI();
SimileAjax.jQuery.ajax({url:this._settings.scraperService,dataType:"jsonp",jsonp:"callback",data:{url:A},success:C});
};
Exhibit.Scraper.prototype.scrapeText=function(C){var B=null;
var A=Exhibit.ScraperBackend.extractItemFromText(C,this._settings.itemType,this._uiContext.getDatabase());
Exhibit.ItemCreator.makeNewItemBox(this._uiContext,A);
};
Exhibit.Scraper.prototype.scrapePageSource=function(A){var D=Exhibit.ScraperBackend.getTextFromPageSource(A);
var C=Exhibit.ScraperBackend.getTitleFromPageSource(A);
var B=Exhibit.ScraperBackend.extractItemFromText(D,this._settings.itemType,this._uiContext.getDatabase());
Exhibit.ItemCreator.makeNewItemBox(this._uiContext,B,{title:C});
};
Exhibit.ScraperBackend={};
Exhibit.ScraperBackend.getTitleFromPageSource=function(A){var D=document.createElement("div");
D.innerHTML=A.replace(/\s+/g," ");
var C=SimileAjax.jQuery(D);
var B=C.find("title").text();
return B;
};
Exhibit.ScraperBackend.getTextContents=function(C){function B(F,E){if(F.nodeType==3){E.push(F.data);
}else{if(F.nodeType==1){for(var D=F.firstChild;
D!=null;
D=D.nextSibling){B(D,E);
}}}}var A=[];
B(C,A);
return A.join("");
};
Exhibit.ScraperBackend.getTextFromPageSource=function(A){var D=document.createElement("div");
D.innerHTML=A.replace(/\s+/g," ");
var B=D.childNodes;
for(i=0;
i<B.length;
i++){var C=B[i];
if(C.nodeName.toLowerCase()=="style"||C.nodeName.toLowerCase()=="script"){D.removeChild(C);
}}return Exhibit.ScraperBackend.getTextContents(D);
};
Exhibit.ScraperBackend.findMostCommon=function(H,G){var F=0;
var C=null;
function A(L,K){L=L.toLowerCase();
var J=0;
var I=null;
while((I=K.indexOf(L,I))!=-1){J++;
I+=1;
}return J;
}for(var B=0;
B<H.length;
B++){var D=H[B];
var E=A(D,G);
if(E>F){F=E;
C=D;
}}return C;
};
Exhibit.ScraperBackend.extractItemFromText=function(F,E,B){var D={type:E};
var A=new Exhibit.Set();
A.add(E);
var C=B.getSubjectsUnion(A,"type");
F=F.toLowerCase();
B.getAllProperties().forEach(function(I){var G=B.getObjectsUnion(C,I).toArray();
var H=Exhibit.ScraperBackend.findMostCommon(G,F);
if(H){D[I]=H;
}});
return D;
};


/* submission-backend.js */
Exhibit.SubmissionBackend={};
Exhibit.SubmissionBackend.formatChanges=function(B,A){return B.map(function(D){var C={id:D.id,label:D.label||D.id};
SimileAjax.jQuery.each(D.vals||{},function(F,E){F=F.toLowerCase();
C[F]=E.newVal;
});
SimileAjax.jQuery.each(A,function(F,E){F=F.toLowerCase();
if(F in C){throw"Collision between change property and submission property "+F+": "+C[F]+", "+E;
}else{C[F]=E;
}});
return C;
});
};
Exhibit.SubmissionBackend.SubmissionDefaults={"gdoc":{"url":"http://valinor.mit.edu/sostler/gdocbackend.cgi",}};
Exhibit.SubmissionBackend.getOutputOptions=function(){var A=$('head link[rel="exhibit/output"]');
if(A.length==0){throw"No output link provided";
}else{if(A.length>1){SimileAjax.Debug.warn("Multiple output links provided; ignoring all but the first");
}}var B={url:null,data:{}};
B.url=A.attr("ex:url")||Exhibit.SubmissionBackend.SubmissionDefaults.gdoc.url;
if(A.attr("ex:spreadsheetKey")){B.data.spreadsheetkey=A.attr("ex:spreadsheetKey");
}if(A.attr("ex:worksheetIndex")){B.data.worksheetindex=A.attr("ex:worksheetIndex");
}else{if(A.attr("ex:worksheetName")){B.data.worksheetname=A.attr("ex:worksheetName");
}else{B.data.worksheetindex="0";
}}return B;
};
Exhibit.SubmissionBackend.googleAuthSuccessWrapper=function(A){return function(B){SimileAjax.Debug.log("wrapped");
SimileAjax.Debug.log(B);
if(B.session){Exhibit.Authentication.GoogleSessionToken=B.session;
}A(B);
};
};
Exhibit.SubmissionBackend._submitChanges=function(C,B,A,D){B.data.json=SimileAjax.JSON.toJSONString(C);
if(Exhibit.Authentication.Enabled){if(Exhibit.Authentication.GoogleSessionToken){B.data.session=Exhibit.Authentication.GoogleSessionToken;
}else{if(Exhibit.Authentication.GoogleToken){B.data.token=Exhibit.Authentication.GoogleToken;
A=Exhibit.SubmissionBackend.googleAuthSuccessWrapper(A);
}else{SimileAjax.Debug.warn("Authentication is enabled, but no tokens are present");
}}}$.ajax({url:B.url,data:B.data,dataType:"jsonp",jsonp:"callback",success:A,error:D});
};
Exhibit.SubmissionBackend.submitAllChanges=function(B,A,F){var E=Exhibit.SubmissionBackend.getOutputOptions();
var D=B.getDatabase().collectAllChanges();
var C=Exhibit.SubmissionBackend.formatChanges(D,Exhibit.Submission.Properties);
Exhibit.SubmissionBackend._submitChanges(C,E,A,F);
};
Exhibit.SubmissionBackend.submitItemChanges=function(B,G,A,F){var E=Exhibit.SubmissionBackend.getOutputOptions();
var D=B.getDatabase().collectChangesForItem(G);
var C=Exhibit.SubmissionBackend.formatChanges([D],Exhibit.Submission.Properties);
Exhibit.SubmissionBackend._submitChanges(C,E,A,F);
};


/* submission-widgets.js */
Exhibit.Submission={};
Exhibit.Submission.submissionWidgets=["submission-property","submission-button"];
Exhibit.Submission.enableWidgets=function(){Exhibit.UI.findAttribute("ex:role",Exhibit.Submission.submissionWidgets).removeAttr("disabled");
};
Exhibit.Submission.disableWidgets=function(){Exhibit.UI.findAttribute("ex:role",Exhibit.Submission.submissionWidgets).attr("disabled",true);
};
Exhibit.Submission.resetAfterSubmission=function(A){Exhibit.UI.findAttribute("ex:role","submission-property").val("");
Exhibit.Submission.Properties={};
A.getDatabase().fixAllChanges();
Exhibit.Submission.enableWidgets();
Exhibit.ChangeList.showSubmissionText=true;
A.getDatabase()._listeners.fire("onAfterLoadingItems",[]);
};
Exhibit.Submission.Properties={};
Exhibit.SubmissionProperty=function(B,A,C){B.value="";
if(!C.propertyName){SimileAjax.Debug.warn("No propertyName given for SubmissionProperty");
}else{SimileAjax.jQuery(B).change(function(){Exhibit.Submission.Properties[C.propertyName]=B.value;
});
}};
Exhibit.SubmissionProperty._settingSpecs={propertyName:{type:"text"}};
Exhibit.UI.generateCreationMethods(Exhibit.SubmissionProperty);
Exhibit.UI.registerComponent("submission-property",Exhibit.SubmissionProperty);
Exhibit.SubmissionButton=function(B,A,C){var D=function(){Exhibit.Submission.disableWidgets();
var E=function(){alert("Changes successfully made!");
Exhibit.Submission.resetAfterSubmission(A);
};
var F=function(){alert("Error submitting data!");
Exhibit.Submission.enableWidgets();
};
Exhibit.SubmissionBackend.submitAllChanges(A,E,F);
};
SimileAjax.jQuery(B).click(D);
};
Exhibit.SubmissionButton._settingSpecs={};
Exhibit.UI.generateCreationMethods(Exhibit.SubmissionButton);
Exhibit.UI.registerComponent("submission-button",Exhibit.SubmissionButton);
