<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 * @ingroup SMWLanguage
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'Ask' => array( 'Ask' ),
	'Browse' => array( 'Browse' ),
	'ExportRDF' => array( 'ExportRDF' ),
	'PageProperty' => array( 'PageProperty' ),
	'Properties' => array( 'Properties' ),
	'SMWAdmin' => array( 'SMWAdmin' ),
	'SearchByProperty' => array( 'SearchByProperty' ),
	'SemanticStatistics' => array( 'SemanticStatistics' ),
	'Types' => array( 'Types' ),
	'URIResolver' => array( 'URIResolver' ),
	'UnusedProperties' => array( 'UnusedProperties' ),
	'WantedProperties' => array( 'WantedProperties' ),
	'QueryCreator' => array( 'QueryCreator' ),
);

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = array(
	'Ask' => array( 'Vra' ),
	'Types' => array( 'Tipes' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'تصفح' ),
	'ExportRDF' => array( 'تصدير_آر_دي_إف' ),
	'PageProperty' => array( 'خاصية_الصفحة' ),
	'Properties' => array( 'خصائص' ),
	'SMWAdmin' => array( 'إداري_سمو' ),
	'SearchByProperty' => array( 'بحث_بواسطة_الخاصية' ),
	'SemanticStatistics' => array( 'إحصاءات_سيمانتيك' ),
	'Types' => array( 'أنواع' ),
	'URIResolver' => array( 'محلل_يو_آر_آي' ),
	'UnusedProperties' => array( 'خصائص_غير_مستخدمة' ),
	'WantedProperties' => array( 'خصائص_مطلوبة' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'براوز' ),
	'ExportRDF' => array( 'تصدير_RDF' ),
	'PageProperty' => array( 'خاصية_الصفحه' ),
	'Properties' => array( 'خصايص' ),
	'SMWAdmin' => array( 'ادارى_SMW' ),
	'SearchByProperty' => array( 'دوّر_بالخاصيه' ),
	'SemanticStatistics' => array( 'إحصائيات_Semantic' ),
	'Types' => array( 'انواع' ),
	'URIResolver' => array( 'URI_Resolver' ),
	'UnusedProperties' => array( 'خصايص_مش_مستعمله' ),
	'WantedProperties' => array( 'خصايص_مطلوبه' ),
);

/** Breton (Brezhoneg) */
$specialPageAliases['br'] = array(
	'Ask' => array( 'Goulenn' ),
	'Browse' => array( 'Furchal' ),
	'ExportRDF' => array( 'EzorzhiañRDF' ),
	'PageProperty' => array( 'PerzhioùPajenn' ),
	'Properties' => array( 'Perzhioù' ),
	'Types' => array( 'Seurtoù' ),
);

/** Bosnian (Bosanski) */
$specialPageAliases['bs'] = array(
	'Ask' => array( 'Upit' ),
	'Browse' => array( 'Pregledanje' ),
	'ExportRDF' => array( 'IzvozRDF' ),
	'Properties' => array( 'Svojstva' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'Ask' => array( 'Semantische_Suche' ),
	'Browse' => array( 'Browsen' ),
	'ExportRDF' => array( 'RDF_exportieren', 'Exportiere_RDF' ),
	'PageProperty' => array( 'Seitenattribut' ),
	'Properties' => array( 'Attribute' ),
	'SMWAdmin' => array( 'SMW-Administration', 'SMW-Einrichtung' ),
	'SearchByProperty' => array( 'Suche_mittels_Attribut' ),
	'SemanticStatistics' => array( 'Semantische_Statistik' ),
	'Types' => array( 'Datentypen' ),
	'URIResolver' => array( 'URI-Auflöser' ),
	'UnusedProperties' => array( 'Verwaiste_Attribute' ),
	'WantedProperties' => array( 'Gewünschte_Attribute' ),
	'QueryCreator' => array( 'Abfragenersteller' ),
);

/** Lower Sorbian (Dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'Ask' => array( 'Semantiske pytanhje' ),
	'Browse' => array( 'Pśepytaś' ),
	'ExportRDF' => array( 'RDF eksportěrowaś' ),
	'PageProperty' => array( 'Bokowa kakosć' ),
	'Properties' => array( 'Kakosći' ),
	'SearchByProperty' => array( 'Z kakosću pytaś' ),
	'SemanticStatistics' => array( 'Semantiska statistika' ),
	'Types' => array( 'Datowe typy' ),
	'UnusedProperties' => array( 'Njewužywane kakosći' ),
	'WantedProperties' => array( 'Póžedane kakosći' ),
);

/** Divehi (ދިވެހިބަސް) */
$specialPageAliases['dv'] = array(
	'Ask' => array( 'އައްސަވާ' ),
);

/** Spanish (Español) */
$specialPageAliases['es'] = array(
	'Types' => array( 'Tipos' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'Ask' => array( 'پرسش' ),
	'Browse' => array( 'مرور' ),
	'ExportRDF' => array( 'برونریزی_آردی‌اف' ),
	'PageProperty' => array( 'جزئیات_صفحه' ),
	'Properties' => array( 'جزئیات' ),
	'SMWAdmin' => array( 'مدیر_اس‌ام‌دبلیو' ),
	'SearchByProperty' => array( 'جستجو_بر_پایه_جزئیات' ),
	'SemanticStatistics' => array( 'آمار_سمانیک' ),
	'Types' => array( 'نوع‌ها' ),
	'URIResolver' => array( 'حل‌کننده_یو‌آر‌آی' ),
	'UnusedProperties' => array( 'جزئیات_استفاده_نشده' ),
	'WantedProperties' => array( 'جزئیات_درخواستی' ),
	'QueryCreator' => array( 'کوئری‌ساز' ),
);

/** Finnish (Suomi) */
$specialPageAliases['fi'] = array(
	'Ask' => array( 'Kysy' ),
	'Browse' => array( 'Selaa' ),
	'ExportRDF' => array( 'RDF-vienti' ),
	'Properties' => array( 'Ominaisuudet' ),
	'SMWAdmin' => array( 'Semanttisen_Mediawikin_ylläpito' ),
	'SemanticStatistics' => array( 'Semanttiset_tilastot' ),
	'Types' => array( 'Tyypit' ),
	'UnusedProperties' => array( 'Käyttämättömät_ominaisuudet' ),
	'WantedProperties' => array( 'Halutut_ominaisuudet' ),
	'QueryCreator' => array( 'Semanttisen_kyselyn_luonti' ),
);

/** Galician (Galego) */
$specialPageAliases['gl'] = array(
	'Ask' => array( 'Preguntar' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'Exportar_RDF' ),
	'PageProperty' => array( 'Propiedades_da_páxina' ),
	'Properties' => array( 'Propiedades' ),
	'SearchByProperty' => array( 'Procurar_por_propiedades' ),
	'SemanticStatistics' => array( 'Estatísticas_semánticas' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'Propiedades_sen_uso' ),
	'WantedProperties' => array( 'Propiedades_requiridas' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'Ask' => array( 'Semantischi Suech' ),
	'ExportRDF' => array( 'Exportier ADF' ),
	'PageProperty' => array( 'Syteattribut' ),
	'Properties' => array( 'Attribut' ),
	'SMWAdmin' => array( 'SMW-Yyrichtig' ),
	'SearchByProperty' => array( 'Suech no Attribut' ),
	'SemanticStatistics' => array( 'Semantischi Statischtik' ),
	'Types' => array( 'Datetype' ),
	'UnusedProperties' => array( 'Verwaisti Attribut' ),
	'WantedProperties' => array( 'Gwinschti Attribut' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'Ask' => array( 'Semantiske pytanje' ),
	'Browse' => array( 'Přepytać' ),
	'ExportRDF' => array( 'RDF eksportować' ),
	'PageProperty' => array( 'Kajkosć strony' ),
	'Properties' => array( 'Kajkosće' ),
	'SearchByProperty' => array( 'Pytanje po kajkosći' ),
	'SemanticStatistics' => array( 'Semantiska statistika' ),
	'Types' => array( 'Datowe typy' ),
	'UnusedProperties' => array( 'Njewužiwane kajkosće' ),
	'WantedProperties' => array( 'Falowace kajkosće' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'Ask' => array( 'Mande' ),
	'Browse' => array( 'Navige' ),
	'ExportRDF' => array( 'EkspòteRDF' ),
	'PageProperty' => array( 'ProprietePaj' ),
	'Properties' => array( 'Propriete' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'ChachePaPropriete' ),
	'SemanticStatistics' => array( 'EstatistikSemantik' ),
	'Types' => array( 'Tip' ),
	'UnusedProperties' => array( 'ProprietePaSèvi' ),
	'WantedProperties' => array( 'ProprieteKiMande' ),
);

/** Hungarian (Magyar) */
$specialPageAliases['hu'] = array(
	'Ask' => array( 'Kérdez' ),
	'Browse' => array( 'Böngészés' ),
	'Properties' => array( 'Tulajdonságok' ),
	'SemanticStatistics' => array( 'Szemantikus_statisztika' ),
	'Types' => array( 'Típusok' ),
	'URIResolver' => array( 'URI-feloldó' ),
	'UnusedProperties' => array( 'Nem_használt_tulajdonságok' ),
	'WantedProperties' => array( 'Keresett_tulajdonságok' ),
);

/** Interlingua (Interlingua) */
$specialPageAliases['ia'] = array(
	'Ask' => array( 'Consultar' ),
	'Browse' => array( 'Percurrer' ),
	'ExportRDF' => array( 'Exportar_RDF' ),
	'PageProperty' => array( 'Proprietate_de_pagina' ),
	'Properties' => array( 'Proprietates' ),
	'SMWAdmin' => array( 'Admin_SMW' ),
	'SearchByProperty' => array( 'Cercar_per_proprietate' ),
	'SemanticStatistics' => array( 'Statisticas_semantic' ),
	'Types' => array( 'Typos' ),
	'URIResolver' => array( 'Resolvitor_de_URIs' ),
	'UnusedProperties' => array( 'Proprietates_non_usate' ),
	'WantedProperties' => array( 'Proprietates_dsesirate' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'Ask' => array( 'Tanya' ),
	'Browse' => array( 'Jelajahi' ),
	'ExportRDF' => array( 'EksporRDF' ),
	'PageProperty' => array( 'PropertiHalaman' ),
	'Properties' => array( 'Properti' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'PencarianProperti' ),
	'SemanticStatistics' => array( 'StatistikSemantik' ),
	'Types' => array( 'Tipe' ),
	'URIResolver' => array( 'PenguraiURI' ),
	'UnusedProperties' => array( 'PropertiTakDigunakan' ),
	'WantedProperties' => array( 'PropertiDiinginkan' ),
);

/** Italian (Italiano) */
$specialPageAliases['it'] = array(
	'Ask' => array( 'Chiedi' ),
	'Browse' => array( 'Esplora' ),
	'ExportRDF' => array( 'EsportaRDF' ),
	'PageProperty' => array( 'ProprietàPagina' ),
	'Properties' => array( 'Proprietà' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'CercaPerProprietà' ),
	'SemanticStatistics' => array( 'StatisticheSemantiche' ),
	'Types' => array( 'Tipi' ),
	'UnusedProperties' => array( 'ProprietàNonUtilizzate' ),
	'WantedProperties' => array( 'ProprietàRichieste' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'Ask' => array( '問い合わせ', '意味的検索' ),
	'Browse' => array( '閲覧' ),
	'ExportRDF' => array( 'RDFエクスポート', 'ＲＤＦエクスポート' ),
	'PageProperty' => array( 'ページプロパティ' ),
	'Properties' => array( 'プロパティ一覧' ),
	'SMWAdmin' => array( 'SMW管理' ),
	'SearchByProperty' => array( 'プロパティによる検索' ),
	'SemanticStatistics' => array( '意味的統計' ),
	'Types' => array( '型一覧' ),
	'URIResolver' => array( 'URIリゾルバー', 'ＵＲＩリゾルバー' ),
	'UnusedProperties' => array( '使われていないプロパティ' ),
	'WantedProperties' => array( '望まれているプロパティ' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'Types' => array( 'ტიპები' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'Browse' => array( 'រាវរក' ),
	'Properties' => array( 'លក្ខណៈ' ),
	'Types' => array( 'ប្រភេទ' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'Ask' => array( 'Froore' ),
	'Browse' => array( 'Bläddere' ),
	'ExportRDF' => array( 'RDF', 'RDF Äxpotteere' ),
	'PageProperty' => array( 'Eijeschaffte vun Sigge' ),
	'Properties' => array( 'Eijeschaffte' ),
	'SMWAdmin' => array( 'Semantesch MediaWiki Ennreschte' ),
	'SearchByProperty' => array( 'Noh Eijeschaffte söke' ),
	'SemanticStatistics' => array( 'Semantesch Shtatistike' ),
	'Types' => array( 'Zoote vun Daate' ),
	'UnusedProperties' => array( 'Eijeschaffte di nit jebruch wääde' ),
	'WantedProperties' => array( 'Eijeschaffte di noch jebruch wääde' ),
);

/** Cornish (Kernowek) */
$specialPageAliases['kw'] = array(
	'Ask' => array( 'Govyn' ),
	'Browse' => array( 'Peury' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'Ask' => array( 'Froen' ),
	'ExportRDF' => array( 'RDF_exportéieren' ),
	'PageProperty' => array( 'Säiten-Eegeschaften' ),
	'Properties' => array( 'Eegeschaften' ),
	'SearchByProperty' => array( 'No_Eegeschaft_sichen' ),
	'SemanticStatistics' => array( 'Semantesch_Statistiken' ),
	'Types' => array( 'Datentypen' ),
	'UnusedProperties' => array( 'Netbenotzten_Eegeschaften' ),
	'WantedProperties' => array( 'Gewënschten_Eegeschaften' ),
);

/** Lumbaart (Lumbaart) */
$specialPageAliases['lmo'] = array(
	'Ask' => array( 'Ciama' ),
);

/** Macedonian (Македонски) */
$specialPageAliases['mk'] = array(
	'Ask' => array( 'Прашај' ),
	'Browse' => array( 'Прелистај' ),
	'ExportRDF' => array( 'ИзвезиRDF' ),
	'PageProperty' => array( 'СвојстваНаСтраница' ),
	'Properties' => array( 'Својства' ),
	'SMWAdmin' => array( 'СМВАдминистратор' ),
	'SearchByProperty' => array( 'ПребарајПоСвојство' ),
	'SemanticStatistics' => array( 'СемантичкиСтатистики' ),
	'Types' => array( 'Типови' ),
	'URIResolver' => array( 'URIРешавач' ),
	'UnusedProperties' => array( 'НекористениСвојства' ),
	'WantedProperties' => array( 'ПотребниСвојства' ),
	'QueryCreator' => array( 'СоздавачНаБарања' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'Ask' => array( 'ചോദിക്കുക' ),
	'Browse' => array( 'ബ്രൗസ്' ),
	'Types' => array( 'തരങ്ങൾ' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'Ask' => array( 'विचारा' ),
	'Browse' => array( 'न्याहाळा' ),
	'ExportRDF' => array( 'आरडीएफनिर्यात' ),
	'PageProperty' => array( 'पानवैशिष्ट्ये' ),
	'Properties' => array( 'वैशिष्ट्ये' ),
	'SMWAdmin' => array( 'एसएमडब्ल्यूप्रचालक' ),
	'SearchByProperty' => array( 'वैशिष्ट्येनुसारशोध' ),
	'SemanticStatistics' => array( 'सिमॅंटीकसांख्यिकी' ),
	'Types' => array( 'प्रकार' ),
	'URIResolver' => array( 'यूआरायरिझॉल्व्हर' ),
	'UnusedProperties' => array( 'नवापरलेलीवैशिष्ट्ये' ),
	'WantedProperties' => array( 'हवीअसलेलीवैशिष्ट्ये' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'Ask' => array( 'Staqsi' ),
	'Browse' => array( 'Esplora' ),
);

/** Norwegian Bokmål (‪Norsk (bokmål)‬) */
$specialPageAliases['nb'] = array(
	'Ask' => array( 'Spør' ),
	'Browse' => array( 'Se_gjennom' ),
	'ExportRDF' => array( 'Eksporter_RDF' ),
	'PageProperty' => array( 'Sideegenskaper' ),
	'Properties' => array( 'Egenskaper' ),
	'SMWAdmin' => array( 'SMW-administrasjon' ),
	'SearchByProperty' => array( 'Søk_etter_egenskap' ),
	'SemanticStatistics' => array( 'Semantisk_statistikk' ),
	'Types' => array( 'Typer' ),
	'UnusedProperties' => array( 'Ubrukte_egenskaper' ),
	'WantedProperties' => array( 'Ønskede_egenskaper' ),
);

/** Nedersaksisch (Nedersaksisch) */
$specialPageAliases['nds-nl'] = array(
	'Ask' => array( 'Vragen' ),
	'Browse' => array( 'Bekieken' ),
	'ExportRDF' => array( 'RDF_uutvoeren' ),
	'PageProperty' => array( 'Pagina-eigenschap' ),
	'Properties' => array( 'Eigenschappen' ),
	'SMWAdmin' => array( 'SMW-beheer' ),
	'SearchByProperty' => array( 'Op_eigenschap_zeuken' ),
	'SemanticStatistics' => array( 'Semantiese_staotistieken' ),
	'Types' => array( 'Soorten' ),
	'URIResolver' => array( 'URI-oplosser' ),
	'UnusedProperties' => array( 'Ongebruukten_eigenschappen' ),
	'WantedProperties' => array( 'Gewunste_eigenschappen' ),
	'QueryCreator' => array( 'Wachtrie-anmaker' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'Ask' => array( 'Vragen' ),
	'Browse' => array( 'Bekijken' ),
	'ExportRDF' => array( 'RDFExporteren' ),
	'PageProperty' => array( 'Paginaeigenschap' ),
	'Properties' => array( 'Eigenschappen' ),
	'SMWAdmin' => array( 'SMWBeheer' ),
	'SearchByProperty' => array( 'OpEigenschapZoeken' ),
	'SemanticStatistics' => array( 'SemantischeStatistieken' ),
	'Types' => array( 'Typen' ),
	'UnusedProperties' => array( 'OngebruikteEigenschappen' ),
	'WantedProperties' => array( 'GewensteEigenschappen' ),
	'QueryCreator' => array( 'Zoekopdrachtenmaker' ),
);

/** Occitan (Occitan) */
$specialPageAliases['oc'] = array(
	'Browse' => array( 'Percórrer' ),
	'Properties' => array( 'Proprietats' ),
	'Types' => array( 'Tipes' ),
	'UnusedProperties' => array( 'Proprietats inutilizadas', 'ProprietatsInutilizadas' ),
	'WantedProperties' => array( 'Proprietats demandadas', 'ProprietatsDemandadas' ),
);

/** Oriya (ଓଡ଼ିଆ) */
$specialPageAliases['or'] = array(
	'Ask' => array( 'ପଚାରନ୍ତୁ' ),
	'Browse' => array( 'ଖୋଜିବା' ),
	'PageProperty' => array( 'ପୃଷ୍ଠାର_ଗୁଣ' ),
	'Properties' => array( 'ଗୁଣ' ),
	'UnusedProperties' => array( 'ବ୍ୟବହାର_ହୋଇନଥିବା_ଗୁଣ' ),
	'WantedProperties' => array( 'ଦରକାରୀ_ଗୁଣ' ),
);

/** Polish (Polski) */
$specialPageAliases['pl'] = array(
	'Ask' => array( 'Pytanie' ),
	'Browse' => array( 'Przegląd' ),
	'ExportRDF' => array( 'EksportRDF' ),
	'PageProperty' => array( 'WłasnośćStrony' ),
	'Properties' => array( 'Własności' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'SzukanieWgWłasności' ),
	'SemanticStatistics' => array( 'StatystykiSemantyczne' ),
	'Types' => array( 'Typy' ),
	'URIResolver' => array( 'ResolverURI' ),
	'UnusedProperties' => array( 'NieużywaneWłasności' ),
	'WantedProperties' => array( 'PotrzebneWłasności' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'Ask' => array( 'پوښتل' ),
	'Browse' => array( 'سپړل' ),
	'PageProperty' => array( 'د مخ ځانتياوې' ),
	'Properties' => array( 'ځانتياوې' ),
	'Types' => array( 'ډولونه' ),
	'UnusedProperties' => array( 'ناکارېدلې ځانتياوې' ),
);

/** Portuguese (Português) */
$specialPageAliases['pt'] = array(
	'Ask' => array( 'Pedir' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'Exportar_RDF' ),
	'PageProperty' => array( 'Propriedade_de_página' ),
	'Properties' => array( 'Propriedades' ),
	'SearchByProperty' => array( 'Pesquisar_propriedade' ),
	'SemanticStatistics' => array( 'Estatísticas_de_semântica' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'Propriedades_não_utilizadas' ),
	'WantedProperties' => array( 'Propriedades_desejadas' ),
);

/** Romanian (Română) */
$specialPageAliases['ro'] = array(
	'Browse' => array( 'Răsfoieşte' ),
);

/** Slovak (Slovenčina) */
$specialPageAliases['sk'] = array(
	'Ask' => array( 'SpýtaťSa' ),
	'Browse' => array( 'Prehliadať' ),
	'PageProperty' => array( 'VlastnostiStránky' ),
	'Properties' => array( 'Vlastnosti' ),
	'SMWAdmin' => array( 'SprávcaSMW' ),
	'SearchByProperty' => array( 'HľadaniePodľaVlastností' ),
	'SemanticStatistics' => array( 'SémantickéŠtatistiky' ),
	'Types' => array( 'Typy' ),
	'URIResolver' => array( 'PrekladURI' ),
	'UnusedProperties' => array( 'NepoužívanéVlastnosti' ),
	'WantedProperties' => array( 'ŽiadanéVlastnosti' ),
);

/** Albanian (Shqip) */
$specialPageAliases['sq'] = array(
	'Ask' => array( 'Pyet' ),
	'Browse' => array( 'Sille' ),
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬) */
$specialPageAliases['sr-ec'] = array(
	'Ask' => array( 'Питај' ),
	'Browse' => array( 'Потражи' ),
	'Properties' => array( 'Својства' ),
	'Types' => array( 'Врсте' ),
	'UnusedProperties' => array( 'Некоришћена_својства' ),
	'WantedProperties' => array( 'Тражена_својства' ),
);

/** Swedish (Svenska) */
$specialPageAliases['sv'] = array(
	'Ask' => array( 'Fråga' ),
	'Browse' => array( 'Bläddra' ),
	'ExportRDF' => array( 'Exportera_RDF' ),
	'Properties' => array( 'Egenskaper' ),
	'Types' => array( 'Typer' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'Ask' => array( 'Uliza' ),
	'Browse' => array( 'Fungua' ),
	'Types' => array( 'Aina' ),
);

/** Telugu (తెలుగు) */
$specialPageAliases['te'] = array(
	'Ask' => array( 'అడుగు' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'Ask' => array( 'Magtanong' ),
	'Browse' => array( 'Tumingin-tingin' ),
	'ExportRDF' => array( 'Iluwas ang RDF' ),
	'PageProperty' => array( 'Pag-aari ng pahina' ),
	'Properties' => array( 'Mga pag-aari' ),
	'SMWAdmin' => array( 'Tagapangasiwa ng SMW' ),
	'SearchByProperty' => array( 'Maghanap ayon sa pag-aari' ),
	'SemanticStatistics' => array( 'Mga estadistika ng semantiko' ),
	'Types' => array( 'Mga uri' ),
	'URIResolver' => array( 'Tagapaglutas ng URI' ),
	'UnusedProperties' => array( 'Mga pag-aaring hindi ginagamit' ),
	'WantedProperties' => array( 'Mga pag-aaring ninanais' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'Ask' => array( 'Sor' ),
	'Browse' => array( 'Gezin' ),
	'ExportRDF' => array( 'RDFAktar' ),
	'PageProperty' => array( 'SayfaÖzelliği' ),
	'Properties' => array( 'Özellikler' ),
	'SMWAdmin' => array( 'SMWHizmetlisi', 'SMWYöneticisi' ),
	'SearchByProperty' => array( 'ÖzelliğeGöreAra' ),
	'SemanticStatistics' => array( 'Anlamİstatistikleri' ),
	'Types' => array( 'Türler', 'Tipler' ),
	'URIResolver' => array( 'URIÇözücü' ),
	'UnusedProperties' => array( 'KullanılmayanÖzellikler' ),
	'WantedProperties' => array( 'İstenenÖzellikler' ),
);

/** Vèneto (Vèneto) */
$specialPageAliases['vec'] = array(
	'Browse' => array( 'Sfója' ),
	'Properties' => array( 'Proprietà' ),
	'Types' => array( 'Tipi' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'Ask' => array( 'Hỏi' ),
	'ExportRDF' => array( 'Xuất_RDF' ),
	'PageProperty' => array( 'Thuộc_tính_trang' ),
	'Properties' => array( 'Thuộc_tính' ),
);

/** Simplified Chinese (‪中文(简体)‬) */
$specialPageAliases['zh-hans'] = array(
	'Ask' => array( '问' ),
	'Browse' => array( '浏览' ),
);

/** Traditional Chinese (‪中文(繁體)‬) */
$specialPageAliases['zh-hant'] = array(
	'Ask' => array( '問' ),
	'Browse' => array( '瀏覽' ),
);