<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 * @ingroup SF
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'CreateCategory' => array( 'CreateCategory' ),
	'CreateClass' => array( 'CreateClass' ),
	'CreateForm' => array( 'CreateForm' ),
	'CreateProperty' => array( 'CreateProperty' ),
	'CreateTemplate' => array( 'CreateTemplate' ),
	'FormEdit' => array( 'FormEdit', 'AddData', 'EditData' ),
	'FormStart' => array( 'FormStart', 'AddPage' ),
	'Forms' => array( 'Forms' ),
	'RunQuery' => array( 'RunQuery' ),
	'Templates' => array( 'Templates' ),
	'UploadWindow' => array( 'UploadWindow' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'CreateCategory' => array( 'إنشاء_تصنيف' ),
	'CreateClass' => array( 'إنشاء_رتبة' ),
	'CreateForm' => array( 'إنشاء_استمارة' ),
	'CreateProperty' => array( 'إنشاء_خاصية' ),
	'CreateTemplate' => array( 'إنشاء_قالب' ),
	'FormEdit' => array( 'تعديل_البيانات' ),
	'FormStart' => array( 'إضافة_صفحة' ),
	'Forms' => array( 'استمارات' ),
	'RunQuery' => array( 'تنفيذ_الاستعلام' ),
	'Templates' => array( 'قوالب' ),
	'UploadWindow' => array( 'نافذة_الرفع' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'CreateCategory' => array( 'اعمل_تصنيف' ),
	'CreateForm' => array( 'اعمل_استماره' ),
	'CreateProperty' => array( 'اعمل_ملكيه' ),
	'CreateTemplate' => array( 'إاعمل_قالب' ),
	'FormEdit' => array( 'تعديل_الداتا' ),
	'FormStart' => array( 'زود_صفحه' ),
	'Forms' => array( 'استمارات' ),
	'Templates' => array( 'قوالب' ),
	'UploadWindow' => array( 'ويندو_الأپلود' ),
);

/** Breton (Brezhoneg) */
$specialPageAliases['br'] = array(
	'CreateCategory' => array( 'KrouiñRummad' ),
	'CreateTemplate' => array( 'KrouiñPatrom' ),
	'FormEdit' => array( 'OuzhpennañDanvez' ),
	'FormStart' => array( 'OuzhpennañPajenn' ),
	'Templates' => array( 'Patromoù' ),
);

/** Bosnian (Bosanski) */
$specialPageAliases['bs'] = array(
	'CreateCategory' => array( 'PravljenjeKategorije' ),
	'CreateForm' => array( 'PravljenjeObrasca' ),
	'CreateProperty' => array( 'PravljenjeSvojstva' ),
	'CreateTemplate' => array( 'PravljenjeSablon' ),
	'FormEdit' => array( 'DodavanjePodataka' ),
	'FormStart' => array( 'DodavanjeStranice' ),
	'Forms' => array( 'Obrasci' ),
	'Templates' => array( 'Sabloni' ),
	'UploadWindow' => array( 'ProzorPostavljanja' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'CreateCategory' => array( 'Kategorie_erstellen' ),
	'CreateClass' => array( 'Klasse_erstellen' ),
	'CreateForm' => array( 'Formular_erstellen' ),
	'CreateProperty' => array( 'Attribut_erstellen' ),
	'CreateTemplate' => array( 'Vorlage_erstellen' ),
	'FormEdit' => array( 'Mit_Formular_bearbeiten' ),
	'FormStart' => array( 'Mit_Formular_hinzufügen' ),
	'Forms' => array( 'Formulare' ),
	'RunQuery' => array( 'Abfrage_ausführen' ),
	'Templates' => array( 'Vorlagen' ),
	'UploadWindow' => array( 'Hochladefenster' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'CreateCategory' => array( 'Krei_kategorion' ),
	'CreateClass' => array( 'Krei_klason' ),
	'CreateForm' => array( 'Krei_formularon' ),
	'Forms' => array( 'Formularoj' ),
);

/** Spanish (Español) */
$specialPageAliases['es'] = array(
	'CreateCategory' => array( 'CrearCategoría', 'Crear_categoría' ),
	'Templates' => array( 'Plantillas' ),
);

/** Basque (Euskara) */
$specialPageAliases['eu'] = array(
	'CreateCategory' => array( 'KategoriaSortu' ),
	'CreateTemplate' => array( 'TxantiloiaSortu' ),
	'Templates' => array( 'Txantiloiak' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'CreateCategory' => array( 'ایجاد_رده' ),
	'CreateClass' => array( 'ایجاد_کلاس' ),
	'CreateForm' => array( 'ایجاد_فرم' ),
	'CreateProperty' => array( 'ایجاد_صفت' ),
	'CreateTemplate' => array( 'ایجاد_الگو' ),
	'FormEdit' => array( 'ویرایش_داده' ),
	'FormStart' => array( 'افزودن_صفحه' ),
	'Forms' => array( 'فرم‌ها' ),
	'RunQuery' => array( 'اجرای_درخواست' ),
	'Templates' => array( 'الگوها' ),
	'UploadWindow' => array( 'پنجره_بارگذاری' ),
);

/** Finnish (Suomi) */
$specialPageAliases['fi'] = array(
	'CreateCategory' => array( 'Luo_luokka' ),
	'CreateClass' => array( 'Luo_semanttinen_tietotyyppi' ),
	'CreateForm' => array( 'Luo_lomake' ),
	'CreateProperty' => array( 'Luo_ominaisuus' ),
	'CreateTemplate' => array( 'Luo_malline' ),
	'FormEdit' => array( 'Lomakemuokkaus' ),
	'FormStart' => array( 'Lomakeluonti' ),
	'Forms' => array( 'Lomakkeet' ),
	'RunQuery' => array( 'Semanttinen_kysely' ),
	'Templates' => array( 'Mallineet' ),
);

/** French (Français) */
$specialPageAliases['fr'] = array(
	'CreateCategory' => array( 'Créer_catégorie', 'CréerCatégorie' ),
	'CreateTemplate' => array( 'Créer_modèle', 'CréerModèle' ),
	'FormEdit' => array( 'AjouterDonnées', 'Ajouter_données' ),
	'FormStart' => array( 'AjouterPage', 'Ajouter_page' ),
	'Templates' => array( 'Modèles' ),
);

/** Franco-Provençal (Arpetan) */
$specialPageAliases['frp'] = array(
	'CreateCategory' => array( 'Fâre_una_catègorie', 'FâreUnaCatègorie' ),
	'CreateForm' => array( 'Fâre_un_formulèro', 'FâreUnFormulèro' ),
	'CreateProperty' => array( 'Dèfenir_una_propriètât', 'DèfenirUnaPropriètât' ),
	'CreateTemplate' => array( 'Fâre_un_modèlo', 'FâreUnModèlo' ),
	'FormEdit' => array( 'Changiér_les_balyês', 'ChangiérLesBalyês' ),
	'FormStart' => array( 'Apondre_una_pâge', 'ApondreUnaPâge' ),
	'Forms' => array( 'Formulèros' ),
	'Templates' => array( 'Modèlos' ),
	'UploadWindow' => array( 'Fenétra_de_tèlèchargement', 'FenétraDeTèlèchargement' ),
);

/** Gagauz (Gagauz) */
$specialPageAliases['gag'] = array(
	'CreateCategory' => array( 'KategoriyaYarat' ),
	'Templates' => array( 'Şablonnar' ),
);

/** Galician (Galego) */
$specialPageAliases['gl'] = array(
	'Forms' => array( 'Formularios' ),
	'Templates' => array( 'Modelos' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'CreateCategory' => array( 'Kategori aalege' ),
	'CreateForm' => array( 'Form aalege' ),
	'CreateProperty' => array( 'Eigeschaft aalege' ),
	'CreateTemplate' => array( 'Template aalege' ),
	'FormEdit' => array( 'Date bearbeite' ),
	'FormStart' => array( 'Syte zuegee' ),
	'Forms' => array( 'Form' ),
	'UploadWindow' => array( 'Fänschter zum Uffelade' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'Forms' => array( 'Formulary' ),
	'Templates' => array( 'Předłohi' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'CreateCategory' => array( 'KreyeKategori' ),
	'CreateClass' => array( 'KreyeKlas' ),
	'CreateForm' => array( 'KreyeFòmilè' ),
	'CreateProperty' => array( 'KreyePropriete' ),
	'CreateTemplate' => array( 'KreyeModèl' ),
	'FormEdit' => array( 'ModifyeFòmilè', 'AjouteDòne', 'ModifyeDòne' ),
	'FormStart' => array( 'KòmanseFòmilè', 'AjoutePaj' ),
	'Forms' => array( 'FomilèYo' ),
	'RunQuery' => array( 'Enteroje' ),
	'Templates' => array( 'Modèl' ),
	'UploadWindow' => array( 'FenètChajman' ),
);

/** Hungarian (Magyar) */
$specialPageAliases['hu'] = array(
	'CreateCategory' => array( 'Kategória_készítés' ),
	'CreateForm' => array( 'Űrlap_készítése' ),
	'CreateProperty' => array( 'Tulajdonság_készítése' ),
	'CreateTemplate' => array( 'Sablon_készítése' ),
	'FormEdit' => array( 'Adat_szerkesztése' ),
	'FormStart' => array( 'Lap_hozzáadása', 'Oldal_hozzáadása' ),
	'Forms' => array( 'Űrlapok' ),
	'Templates' => array( 'Sablonok' ),
	'UploadWindow' => array( 'Feltöltő_ablak' ),
);

/** Interlingua (Interlingua) */
$specialPageAliases['ia'] = array(
	'CreateCategory' => array( 'Crear_categoria' ),
	'CreateClass' => array( 'Crear_classe' ),
	'CreateForm' => array( 'Crear_formulario' ),
	'CreateProperty' => array( 'Crear_proprietate' ),
	'CreateTemplate' => array( 'Crear_patrono' ),
	'FormEdit' => array( 'Modificar_datos' ),
	'FormStart' => array( 'Adder_pagina' ),
	'Forms' => array( 'Formularios' ),
	'RunQuery' => array( 'Executar_consulta' ),
	'Templates' => array( 'Patronos' ),
	'UploadWindow' => array( 'Cargar_fenestra' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'CreateCategory' => array( 'Buat_kategori', 'BuatKategori' ),
	'CreateForm' => array( 'Buat_formulir', 'BuatFormulir' ),
	'CreateProperty' => array( 'Buat_properti', 'BuatProperti' ),
	'CreateTemplate' => array( 'Buat_templat', 'BuatTemplat' ),
	'FormEdit' => array( 'Sunting_data', 'SuntingData' ),
	'FormStart' => array( 'Tambah_halaman', 'TambahHalaman' ),
	'Forms' => array( 'Formulir_semantik', 'FormulirSemantik' ),
	'Templates' => array( 'Templat' ),
	'UploadWindow' => array( 'Jendela_pengunggahan', 'JendelaPengunggahan' ),
);

/** Italian (Italiano) */
$specialPageAliases['it'] = array(
	'CreateCategory' => array( 'CreaCategoria' ),
	'CreateClass' => array( 'CreaClasse' ),
	'CreateForm' => array( 'CreaModulo' ),
	'CreateProperty' => array( 'CreaProprietà' ),
	'CreateTemplate' => array( 'CreaTemplate' ),
	'FormEdit' => array( 'ModificaDati' ),
	'FormStart' => array( 'AggiungiPagina' ),
	'Forms' => array( 'Moduli' ),
	'RunQuery' => array( 'EseguiRicerca' ),
	'Templates' => array( 'Template' ),
	'UploadWindow' => array( 'AggiornaFinestra' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'CreateCategory' => array( 'カテゴリ作成' ),
	'CreateClass' => array( 'クラス作成' ),
	'CreateForm' => array( 'フォーム作成' ),
	'CreateProperty' => array( 'プロパティ作成' ),
	'CreateTemplate' => array( 'テンプレート作成' ),
	'FormEdit' => array( 'データ編集' ),
	'FormStart' => array( 'ページ追加' ),
	'Forms' => array( 'フォーム一覧' ),
	'RunQuery' => array( 'クエリ実行' ),
	'Templates' => array( 'テンプレート一覧' ),
	'UploadWindow' => array( 'アップロードウィンドウ' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'CreateCategory' => array( 'კატეგორიის_შექმნა' ),
	'CreateClass' => array( 'კლასის_შექმნა' ),
	'CreateTemplate' => array( 'თარგის_შექმნა' ),
	'Templates' => array( 'თარგები' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'CreateCategory' => array( 'បង្កើតចំណាត់ត់ថ្នាក់ក្រុម' ),
	'CreateForm' => array( 'បង្កើត​ទម្រង់' ),
	'CreateTemplate' => array( 'បង្កើតទំព័រគំរូ' ),
	'FormEdit' => array( 'កែប្រែទិន្នន័យ' ),
	'FormStart' => array( 'បន្ថែមទំព័រ' ),
	'Forms' => array( 'ទម្រង់​នានា' ),
	'Templates' => array( 'ទំព័រគំរូ' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'CreateCategory' => array( '카테고리추가' ),
	'CreateForm' => array( '양식추가' ),
	'CreateTemplate' => array( '틀추가' ),
	'FormEdit' => array( '데이터편집' ),
	'FormStart' => array( '페이지추가' ),
	'Templates' => array( '틀' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'CreateCategory' => array( 'Saachjropp aanlääje' ),
	'CreateForm' => array( 'Fommulaa aanlääje' ),
	'CreateProperty' => array( 'Eijeschaff aanlääje' ),
	'CreateTemplate' => array( 'Schabloon aanlääje' ),
	'FormEdit' => array( 'Date ändere' ),
	'FormStart' => array( 'Sigg dobei donn' ),
	'Forms' => array( 'Fommulaare' ),
	'Templates' => array( 'Schabloone' ),
	'UploadWindow' => array( 'Finster zum Huhlaade', 'Finster zom Huhlaade' ),
);

/** Cornish (Kernowek) */
$specialPageAliases['kw'] = array(
	'CreateCategory' => array( 'GwruthylClass' ),
	'CreateTemplate' => array( 'GwruthylScantlyn' ),
	'Templates' => array( 'Scantlyns' ),
);

/** Ladino (Ladino) */
$specialPageAliases['lad'] = array(
	'Templates' => array( 'Xabblones' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'CreateCategory' => array( 'Kategorie_uleeën' ),
	'CreateForm' => array( 'Formulaire_uleeën' ),
	'CreateProperty' => array( 'Eegeschaften_uleeën' ),
	'CreateTemplate' => array( 'Schabloun_uleeën' ),
	'FormEdit' => array( 'Daten_änneren' ),
	'FormStart' => array( 'Säit_derbäisetzen' ),
	'Forms' => array( 'Formulairen' ),
	'RunQuery' => array( 'Ufro_ausféieren' ),
	'Templates' => array( 'Schablounen' ),
	'UploadWindow' => array( 'Fënster_eroplueden' ),
);

/** Macedonian (Македонски) */
$specialPageAliases['mk'] = array(
	'CreateCategory' => array( 'СоздајКатегорија' ),
	'CreateClass' => array( 'СоздајКласа' ),
	'CreateForm' => array( 'СоздајФорум' ),
	'CreateProperty' => array( 'СоздајСвојство' ),
	'CreateTemplate' => array( 'СоздајШаблон' ),
	'FormEdit' => array( 'УредиПодаток' ),
	'FormStart' => array( 'ДодајСтраница' ),
	'Forms' => array( 'Форми' ),
	'RunQuery' => array( 'ПуштиБарање' ),
	'Templates' => array( 'Шаблони' ),
	'UploadWindow' => array( 'ПрозорецЗаПодигање' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'CreateCategory' => array( 'വർഗ്ഗസൃഷ്ടി' ),
	'CreateForm' => array( 'ഫോംസൃഷ്ടി' ),
	'CreateTemplate' => array( 'ഫലകസൃഷ്ടി' ),
	'FormEdit' => array( 'വിവരങ്ങൾതിരുത്തുക' ),
	'FormStart' => array( 'താൾചേർക്കുക' ),
	'Forms' => array( 'ഫോമുകൾ' ),
	'Templates' => array( 'ഫലകങ്ങൾ' ),
	'UploadWindow' => array( 'അപ്‌ലോഡ്ജാലകം' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'CreateCategory' => array( 'वर्गतयारकरा' ),
	'CreateForm' => array( 'फॉर्मतयारकरा' ),
	'CreateProperty' => array( 'वैशिष्ट्येतयारकरा' ),
	'CreateTemplate' => array( 'साचेतयारकरा' ),
	'FormEdit' => array( 'विदासंपादा' ),
	'FormStart' => array( 'पानजोडा' ),
	'Forms' => array( 'फॉर्म्स' ),
	'Templates' => array( 'साचे' ),
	'UploadWindow' => array( 'चढवाखिडकी' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'CreateCategory' => array( 'OħloqKategorija' ),
	'FormEdit' => array( 'ŻidDati' ),
	'FormStart' => array( 'ŻidPaġna' ),
	'Templates' => array( 'Mudelli' ),
);

/** Erzya (Эрзянь) */
$specialPageAliases['myv'] = array(
	'Forms' => array( 'Парцунт' ),
	'Templates' => array( 'ЛопаПарцунт' ),
);

/** Norwegian Bokmål (‪Norsk (bokmål)‬) */
$specialPageAliases['nb'] = array(
	'CreateCategory' => array( 'Opprett_kategori' ),
	'CreateClass' => array( 'Opprett_klasse' ),
	'CreateForm' => array( 'Opprett_skjema' ),
	'CreateProperty' => array( 'Opprett_egenskap' ),
	'CreateTemplate' => array( 'Opprett_mal' ),
	'FormEdit' => array( 'Rediger_data', 'Legg_til_data' ),
	'FormStart' => array( 'Legg_til_side' ),
	'Forms' => array( 'Skjemaer' ),
	'RunQuery' => array( 'Kjør_spørring' ),
	'Templates' => array( 'Maler' ),
	'UploadWindow' => array( 'Opplastingsvindu' ),
);

/** Nedersaksisch (Nedersaksisch) */
$specialPageAliases['nds-nl'] = array(
	'CreateCategory' => array( 'Kategorie_anmaken' ),
	'CreateClass' => array( 'Klasse_anmaken' ),
	'CreateForm' => array( 'Formulier_anmaken' ),
	'CreateProperty' => array( 'Eigenschap_anmaken' ),
	'CreateTemplate' => array( 'Mal_anmaken' ),
	'FormEdit' => array( 'Gegevens_bewarken' ),
	'FormStart' => array( 'Pagina_derbie_doon' ),
	'Forms' => array( 'Formulieren' ),
	'RunQuery' => array( 'Zeukopdrachte_uutvoeren' ),
	'Templates' => array( 'Mallen' ),
	'UploadWindow' => array( 'Bestaandenscharm' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'CreateCategory' => array( 'CategorieAanmaken' ),
	'CreateClass' => array( 'KlasseAanmaken' ),
	'CreateForm' => array( 'FormulierAanmaken' ),
	'CreateProperty' => array( 'EigenschapAanmaken' ),
	'CreateTemplate' => array( 'SjabloonAanmaken' ),
	'FormEdit' => array( 'GegevensBewerken', 'GegevensToevoegen' ),
	'FormStart' => array( 'PaginaToevoegen' ),
	'Forms' => array( 'Formulieren' ),
	'RunQuery' => array( 'ZoekopdrachtUitvoeren' ),
	'Templates' => array( 'Sjablonen' ),
	'UploadWindow' => array( 'Uploadscherm' ),
);

/** Occitan (Occitan) */
$specialPageAliases['oc'] = array(
	'CreateCategory' => array( 'Crear una categoria', 'CrearCategoria' ),
	'CreateForm' => array( 'Crear un formulari', 'CrearFormulari' ),
	'CreateProperty' => array( 'Crear una proprietat', 'CrearProprietat' ),
	'CreateTemplate' => array( 'Crear un modèl', 'CrearModèl' ),
	'FormStart' => array( 'Apondre una pagina', 'ApondrePagina' ),
	'Forms' => array( 'Formularis' ),
	'Templates' => array( 'Modèls' ),
);

/** Oriya (ଓଡ଼ିଆ) */
$specialPageAliases['or'] = array(
	'CreateCategory' => array( 'ଶ୍ରେଣୀ_ତିଆରି_କରନ୍ତୁ' ),
	'CreateForm' => array( 'ଫରମ_ତିଆରି_କରନ୍ତୁ' ),
	'CreateTemplate' => array( 'ଛାଞ୍ଚ_ତିଆରି_କରନ୍ତୁ' ),
	'FormEdit' => array( 'ଫରମ_ବଦଳାନ୍ତୁ' ),
	'FormStart' => array( 'ଫରମ_ଆରମ୍ଭ_କରନ୍ତୁ' ),
	'Forms' => array( 'ଫରମ' ),
	'Templates' => array( 'ଛାଞ୍ଚ' ),
	'UploadWindow' => array( 'ଉଇଣ୍ଡୋ_ଅପଲୋଡ଼_କରନ୍ତୁ' ),
);

/** Polish (Polski) */
$specialPageAliases['pl'] = array(
	'CreateCategory' => array( 'UtwórzKategorię' ),
	'CreateClass' => array( 'UtwórzKlasę' ),
	'CreateForm' => array( 'UtwórzFormularz' ),
	'CreateProperty' => array( 'UtwórzWłaściwość' ),
	'CreateTemplate' => array( 'UtwórzSzablon' ),
	'Forms' => array( 'Formularze' ),
	'Templates' => array( 'Szablony' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'CreateCategory' => array( 'وېشنيزه جوړول' ),
	'CreateProperty' => array( 'د جوړولو ځانتيا' ),
	'CreateTemplate' => array( 'کينډۍ جوړول' ),
	'FormStart' => array( 'مخ ګډول' ),
	'Templates' => array( 'کينډۍ' ),
);

/** Portuguese (Português) */
$specialPageAliases['pt'] = array(
	'CreateCategory' => array( 'Criar_categoria' ),
	'CreateForm' => array( 'Criar_formulário' ),
	'CreateProperty' => array( 'Criar_propriedade' ),
	'CreateTemplate' => array( 'Criar_modelo' ),
	'FormEdit' => array( 'Editar_dados' ),
	'FormStart' => array( 'Adicionar_página' ),
	'Forms' => array( 'Formulários' ),
	'Templates' => array( 'Modelos' ),
	'UploadWindow' => array( 'Janela_de_carregamento' ),
);

/** Brazilian Portuguese (Português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'Forms' => array( 'Formulários' ),
	'Templates' => array( 'Predefinições' ),
);

/** Romanian (Română) */
$specialPageAliases['ro'] = array(
	'Templates' => array( 'Formate' ),
);

/** Slovak (Slovenčina) */
$specialPageAliases['sk'] = array(
	'CreateCategory' => array( 'VytvoriťKategóriu' ),
	'CreateForm' => array( 'VytvoriťFormulár' ),
	'CreateProperty' => array( 'VytvoriťVlastnosť' ),
	'CreateTemplate' => array( 'VytvoriťŠablónu' ),
	'FormEdit' => array( 'UpraviťDáta' ),
	'FormStart' => array( 'PridaťStránku' ),
	'Forms' => array( 'Formuláre' ),
	'Templates' => array( 'Šablóny' ),
	'UploadWindow' => array( 'NahrávacieOkno' ),
);

/** Albanian (Shqip) */
$specialPageAliases['sq'] = array(
	'Forms' => array( 'Format' ),
	'Templates' => array( 'Stampat' ),
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬) */
$specialPageAliases['sr-ec'] = array(
	'CreateCategory' => array( 'НаправиКатегорију' ),
	'CreateClass' => array( 'Направи_класу' ),
	'CreateForm' => array( 'Направи_образац' ),
	'CreateProperty' => array( 'Направи_својство' ),
	'CreateTemplate' => array( 'Направи_шаблон' ),
	'FormEdit' => array( 'Уреди_образац' ),
	'FormStart' => array( 'ДодајСтраницу', 'Додај_страницу' ),
	'Forms' => array( 'Обрасци' ),
	'Templates' => array( 'Шаблони' ),
);

/** Swedish (Svenska) */
$specialPageAliases['sv'] = array(
	'CreateCategory' => array( 'Skapa_kategori' ),
	'Templates' => array( 'Mallar' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'CreateCategory' => array( 'UndaJamii' ),
	'CreateForm' => array( 'UndaFomu' ),
	'CreateTemplate' => array( 'UndaKigezo' ),
	'FormEdit' => array( 'HaririData' ),
	'FormStart' => array( 'WekaKurasa' ),
	'Forms' => array( 'Fomu' ),
	'Templates' => array( 'Vigezo' ),
	'UploadWindow' => array( 'DirishalaKupakizia' ),
);

/** Thai (ไทย) */
$specialPageAliases['th'] = array(
	'CreateCategory' => array( 'สร้างหมวดหมู่' ),
	'CreateForm' => array( 'สร้างฟอร์ม' ),
	'CreateTemplate' => array( 'สร้างแม่แบบ' ),
	'Forms' => array( 'แบบฟอร์ม' ),
	'Templates' => array( 'แม่แบบ' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'CreateCategory' => array( 'Likhain ang kaurian' ),
	'CreateForm' => array( 'Likhain ang pormularyo' ),
	'CreateProperty' => array( 'Likhain ang pag-aari' ),
	'CreateTemplate' => array( 'Likhain ang suleras' ),
	'FormEdit' => array( 'Baguhin ang dato' ),
	'FormStart' => array( 'Idagdag ang pahina' ),
	'Forms' => array( 'Mga pormularyo' ),
	'Templates' => array( 'Mga suleras' ),
	'UploadWindow' => array( 'Bintana ng pagkarga' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'CreateCategory' => array( 'KategoriOluştur', 'UlamOluştur' ),
	'CreateClass' => array( 'SınıfOluştur' ),
	'CreateForm' => array( 'FormOluştur' ),
	'CreateProperty' => array( 'ÖzellikOluştur' ),
	'CreateTemplate' => array( 'ŞablonOluştur' ),
	'FormEdit' => array( 'VeriDüzenle', 'VeriDeğiştir' ),
	'FormStart' => array( 'SayfaEkle' ),
	'Forms' => array( 'Formlar' ),
	'RunQuery' => array( 'SorguYürüt' ),
	'Templates' => array( 'Şablonlar' ),
	'UploadWindow' => array( 'YüklemePenceresi' ),
);

/** Tatar (Cyrillic script) (Татарча) */
$specialPageAliases['tt-cyrl'] = array(
	'CreateTemplate' => array( 'Үрнәкне_үзгәртү' ),
	'Templates' => array( 'Үрнәкләр' ),
);

/** Vèneto (Vèneto) */
$specialPageAliases['vec'] = array(
	'CreateTemplate' => array( 'CreaModèl' ),
	'FormEdit' => array( 'ZontaDati' ),
	'FormStart' => array( 'ZontaPagina' ),
	'Templates' => array( 'Modèi' ),
	'UploadWindow' => array( 'AjornaFenestra' ),
);