<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'BrowseData' => array( 'BrowseData' ),
	'CreateFilter' => array( 'CreateFilter' ),
	'Filters' => array( 'Filters' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'BrowseData' => array( 'تصفح_بيانات' ),
	'CreateFilter' => array( 'إنشاء_فلتر' ),
	'Filters' => array( 'فلاتر' ),
);

/** Aramaic (ܐܪܡܝܐ) */
$specialPageAliases['arc'] = array(
	'Filters' => array( 'ܡܨܦܝܢܝܬ̈ܐ' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'BrowseData' => array( 'براوز_للداتا' ),
	'CreateFilter' => array( 'اعمل_فيلتر' ),
	'Filters' => array( 'فلاتر' ),
);

/** Breton (Brezhoneg) */
$specialPageAliases['br'] = array(
	'CreateFilter' => array( 'KrouiñSil' ),
	'Filters' => array( 'Siloù' ),
);

/** Bosnian (Bosanski) */
$specialPageAliases['bs'] = array(
	'BrowseData' => array( 'PregledPodataka' ),
	'CreateFilter' => array( 'PravljenjeFiltera' ),
	'Filters' => array( 'Filteri' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'BrowseData' => array( 'Daten_browsen' ),
	'CreateFilter' => array( 'Filter_erstellen' ),
	'Filters' => array( 'Filter' ),
);

/** Lower Sorbian (Dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'BrowseData' => array( 'Daty pśepytaś' ),
	'CreateFilter' => array( 'Filter napóraś' ),
	'Filters' => array( 'Filtry' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'CreateFilter' => array( 'Krei_filtrilon' ),
	'Filters' => array( 'Filtriloj' ),
);

/** Spanish (Español) */
$specialPageAliases['es'] = array(
	'BrowseData' => array( 'Buscar_datos' ),
	'CreateFilter' => array( 'Crear_filtro' ),
	'Filters' => array( 'Filtros' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'BrowseData' => array( 'مرور_داده' ),
	'CreateFilter' => array( 'ایجاد_پالایه' ),
	'Filters' => array( 'پالایه‌ها' ),
);

/** Finnish (Suomi) */
$specialPageAliases['fi'] = array(
	'CreateFilter' => array( 'Luo_suodin' ),
	'Filters' => array( 'Suotimet' ),
);

/** French (Français) */
$specialPageAliases['fr'] = array(
	'CreateFilter' => array( 'Créer_filtre', 'CréerFiltre' ),
	'Filters' => array( 'Filtres' ),
);

/** Franco-Provençal (Arpetan) */
$specialPageAliases['frp'] = array(
	'BrowseData' => array( 'Chèrchiér_les_balyês', 'ChèrchiérLesBalyês' ),
	'CreateFilter' => array( 'Fâre_un_filtro', 'FâreUnFiltro' ),
	'Filters' => array( 'Filtros' ),
);

/** Galician (Galego) */
$specialPageAliases['gl'] = array(
	'CreateFilter' => array( 'Crear_un_filtro' ),
	'Filters' => array( 'Filtros' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'CreateFilter' => array( 'Filter aalege' ),
	'Filters' => array( 'Filter' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'Filters' => array( 'מסננים' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'BrowseData' => array( 'Daty přepytać' ),
	'CreateFilter' => array( 'Filter wutworić' ),
	'Filters' => array( 'Filtry' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'BrowseData' => array( 'NavigeDòne' ),
	'CreateFilter' => array( 'KreyeFilt' ),
	'Filters' => array( 'Filt' ),
);

/** Hungarian (Magyar) */
$specialPageAliases['hu'] = array(
	'BrowseData' => array( 'Adatok_böngészése' ),
	'CreateFilter' => array( 'Szűrőkészítés' ),
	'Filters' => array( 'Szűrők' ),
);

/** Interlingua (Interlingua) */
$specialPageAliases['ia'] = array(
	'BrowseData' => array( 'Percurrer_datos' ),
	'CreateFilter' => array( 'Crear_filtro' ),
	'Filters' => array( 'Filtros' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'BrowseData' => array( 'Jelajahi_data', 'JelajahiData' ),
	'CreateFilter' => array( 'Buat_filter', 'BuatFilter' ),
	'Filters' => array( 'Filter' ),
);

/** Italian (Italiano) */
$specialPageAliases['it'] = array(
	'BrowseData' => array( 'EsploraDati' ),
	'CreateFilter' => array( 'CreaFiltro' ),
	'Filters' => array( 'Filtri' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'BrowseData' => array( 'データ閲覧' ),
	'CreateFilter' => array( 'フィルター作成', 'フィルタ作成' ),
	'Filters' => array( 'フィルター一覧', 'フィルタ一覧' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'CreateFilter' => array( 'ფილტრის_შექმნა' ),
	'Filters' => array( 'ფილტრები' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'BrowseData' => array( 'រាវរកទិន្នន័យ' ),
	'CreateFilter' => array( 'បង្កើត​តម្រង' ),
	'Filters' => array( 'តម្រង' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'BrowseData' => array( 'Bläddere en de' ),
	'CreateFilter' => array( 'Felter opsäze', 'Söke opsäze' ),
	'Filters' => array( 'Feltere', 'Fenge' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'CreateFilter' => array( 'Filter_uleeën' ),
	'Filters' => array( 'Filteren' ),
);

/** Macedonian (Македонски) */
$specialPageAliases['mk'] = array(
	'BrowseData' => array( 'ПрелистајПодатоци' ),
	'CreateFilter' => array( 'СоздајФилтер' ),
	'Filters' => array( 'Филтри' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'BrowseData' => array( 'വിവരങ്ങൾബ്രൗസ്‌‌ചെയ്യുക' ),
	'CreateFilter' => array( 'അരിപ്പസൃഷ്ടിക്കുക' ),
	'Filters' => array( 'അരിപ്പകൾ' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'BrowseData' => array( 'विदान्याहाळा' ),
	'CreateFilter' => array( 'चाळणीनिर्मितकरा' ),
	'Filters' => array( 'चाळण्या' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'Filters' => array( 'Filtri' ),
);

/** Erzya (Эрзянь) */
$specialPageAliases['myv'] = array(
	'Filters' => array( 'Сувтеметь' ),
);

/** Nedersaksisch (Nedersaksisch) */
$specialPageAliases['nds-nl'] = array(
	'BrowseData' => array( 'Gegevens_bekieken' ),
	'CreateFilter' => array( 'Filter_anmaken' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'BrowseData' => array( 'GegevensBekijken' ),
	'CreateFilter' => array( 'FilterAanmaken' ),
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬) */
$specialPageAliases['no'] = array(
	'BrowseData' => array( 'Naviger_data' ),
	'CreateFilter' => array( 'Opprett_filter' ),
	'Filters' => array( 'Filtere' ),
);

/** Occitan (Occitan) */
$specialPageAliases['oc'] = array(
	'CreateFilter' => array( 'CrearFiltre', 'Crear filtre' ),
	'Filters' => array( 'Filtres' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'CreateFilter' => array( 'چاڼګر جوړول' ),
	'Filters' => array( 'چاڼګرونه' ),
);

/** Brazilian Portuguese (Português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'CreateFilter' => array( 'Criar filtro' ),
	'Filters' => array( 'Filtros' ),
);

/** Romanian (Română) */
$specialPageAliases['ro'] = array(
	'Filters' => array( 'Filtre' ),
);

/** Slovak (Slovenčina) */
$specialPageAliases['sk'] = array(
	'BrowseData' => array( 'PrehliadaťDáta' ),
	'CreateFilter' => array( 'VytvoriťFilter' ),
	'Filters' => array( 'Filtre' ),
);

/** Albanian (Shqip) */
$specialPageAliases['sq'] = array(
	'CreateFilter' => array( 'KrijoFiltrues' ),
	'Filters' => array( 'Filtruesit' ),
);

/** Swedish (Svenska) */
$specialPageAliases['sv'] = array(
	'Filters' => array( 'Filter' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'BrowseData' => array( 'FunguaData' ),
	'CreateFilter' => array( 'UndaChujio' ),
	'Filters' => array( 'Machujio' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'BrowseData' => array( 'Tumingin-tingin sa dato' ),
	'CreateFilter' => array( 'Likhain ang pansala' ),
	'Filters' => array( 'Mga pansala' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'BrowseData' => array( 'VeriGezintisi' ),
	'CreateFilter' => array( 'SüzgeçOluştur', 'FiltreOluştur' ),
	'Filters' => array( 'Süzgeçler', 'Filtreler' ),
);

/** Vèneto (Vèneto) */
$specialPageAliases['vec'] = array(
	'CreateFilter' => array( 'CreaFiltro' ),
	'Filters' => array( 'Filtri' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'BrowseData' => array( 'Duyệt_dữ_liệu' ),
	'CreateFilter' => array( 'Tạo_bộ_lọc' ),
	'Filters' => array( 'Bộ_lọc' ),
);

/** Yiddish (ייִדיש) */
$specialPageAliases['yi'] = array(
	'Filters' => array( 'פֿילטערס' ),
);

/**
 * For backwards compatibility with MediaWiki 1.15 and earlier.
 */
$aliases =& $specialPageAliases;