<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'ReplaceText' => array( 'ReplaceText' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'ReplaceText' => array( 'استبدال_نص' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'ReplaceText' => array( 'تبديل_نص' ),
);

/** Breton (Brezhoneg) */
$specialPageAliases['br'] = array(
	'ReplaceText' => array( 'Erlc\'hiañTestenn' ),
);

/** Bosnian (Bosanski) */
$specialPageAliases['bs'] = array(
	'ReplaceText' => array( 'ZamjenaTeksta' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'ReplaceText' => array( 'Text_ersetzen' ),
);

/** Lower Sorbian (Dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'ReplaceText' => array( 'Tekst wuměniś' ),
);

/** Divehi (ދިވެހިބަސް) */
$specialPageAliases['dv'] = array(
	'ReplaceText' => array( 'ލިޔުން ބަދަލުކުރައްވާ' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'ReplaceText' => array( 'جایگزینی_متن' ),
);

/** Finnish (Suomi) */
$specialPageAliases['fi'] = array(
	'ReplaceText' => array( 'Korvaa' ),
);

/** French (Français) */
$specialPageAliases['fr'] = array(
	'ReplaceText' => array( 'Remplacer_texte', 'RemplacerTexte' ),
);

/** Franco-Provençal (Arpetan) */
$specialPageAliases['frp'] = array(
	'ReplaceText' => array( 'Remplaciér_lo_tèxto', 'RemplaciérLoTèxto' ),
);

/** Galician (Galego) */
$specialPageAliases['gl'] = array(
	'ReplaceText' => array( 'Substituír_o_texto' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'ReplaceText' => array( 'Täxt ersetze' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'ReplaceText' => array( 'החלפת_טקסט' ),
);

/** Croatian (Hrvatski) */
$specialPageAliases['hr'] = array(
	'ReplaceText' => array( 'Zamjeni_tekst' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'ReplaceText' => array( 'Tekst narunać' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'ReplaceText' => array( 'RanplaseTeks' ),
);

/** Hungarian (Magyar) */
$specialPageAliases['hu'] = array(
	'ReplaceText' => array( 'Szöveg_csere' ),
);

/** Interlingua (Interlingua) */
$specialPageAliases['ia'] = array(
	'ReplaceText' => array( 'Reimplaciar_texto' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'ReplaceText' => array( 'Ganti_teks', 'GantiTeks' ),
);

/** Italian (Italiano) */
$specialPageAliases['it'] = array(
	'ReplaceText' => array( 'SostituisciTesto' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'ReplaceText' => array( '文字列置換', '文字列の置換' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'ReplaceText' => array( 'ជំនួសអត្ថបទ' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'ReplaceText' => array( 'Tex tuusche' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'ReplaceText' => array( 'Text_ersetzen' ),
);

/** Macedonian (Македонски) */
$specialPageAliases['mk'] = array(
	'ReplaceText' => array( 'ЗамениТекст' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'ReplaceText' => array( 'പകരംഎഴുത്ത്' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'ReplaceText' => array( 'मजकुरबदला' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'ReplaceText' => array( 'BiddelTest' ),
);

/** Norwegian Bokmål (‪Norsk (bokmål)‬) */
$specialPageAliases['nb'] = array(
	'ReplaceText' => array( 'Teksterstatning' ),
);

/** Nedersaksisch (Nedersaksisch) */
$specialPageAliases['nds-nl'] = array(
	'ReplaceText' => array( 'Tekste_vervangen' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'ReplaceText' => array( 'TekstVervangen' ),
);

/** Occitan (Occitan) */
$specialPageAliases['oc'] = array(
	'ReplaceText' => array( 'Remplaçar tèxte', 'RemplaçarTèxte' ),
);

/** Portuguese (Português) */
$specialPageAliases['pt'] = array(
	'ReplaceText' => array( 'Substituir_texto' ),
);

/** Slovak (Slovenčina) */
$specialPageAliases['sk'] = array(
	'ReplaceText' => array( 'NahradiťText' ),
);

/** Albanian (Shqip) */
$specialPageAliases['sq'] = array(
	'ReplaceText' => array( 'ZëvendësoTekstin' ),
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬) */
$specialPageAliases['sr-ec'] = array(
	'ReplaceText' => array( 'ЗамениТекст', 'Замени_текст' ),
);

/** Swedish (Svenska) */
$specialPageAliases['sv'] = array(
	'ReplaceText' => array( 'Ersätt_text' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'ReplaceText' => array( 'PandikiziaMatini' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'ReplaceText' => array( 'Palitan ang teksto' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'ReplaceText' => array( 'MetniDeğiştir' ),
);

/** Vèneto (Vèneto) */
$specialPageAliases['vec'] = array(
	'ReplaceText' => array( 'SostuituissiTesto' ),
);