<?php
/**
 * Internationalisation file for Maps extension.
 *
 * @file
 * @ingroup Extensions
 */

$magicWords = array();

/** English (English) */
$magicWords['en'] = array(
	'display_map' => array( 0, 'display_map' ),
	'display_point' => array( 0, 'display_point', 'display_points' ),
	'geocode' => array( 0, 'geocode' ),
	'geodistance' => array( 0, 'geodistance' ),
	'finddestination' => array( 0, 'finddestination' ),
	'coordinates' => array( 0, 'coordinates' ),
	'distance' => array( 0, 'distance' ),
);

/** Afrikaans (Afrikaans) */
$magicWords['af'] = array(
	'geocode' => array( 0, 'geokode', 'geocode' ),
	'coordinates' => array( 0, 'koördinate', 'coordinates' ),
);

/** Arabic (العربية) */
$magicWords['ar'] = array(
	'display_map' => array( 0, 'عرض_الخريطة' ),
	'display_point' => array( 0, 'نقطة_العرض', 'نقاط_العرض' ),
	'geocode' => array( 0, 'كود_جغرافي' ),
	'geodistance' => array( 0, 'مسافة_جغرافية' ),
	'finddestination' => array( 0, 'إيجاد_الوجهة' ),
	'coordinates' => array( 0, 'إحداثيات' ),
	'distance' => array( 0, 'مسافة' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$magicWords['arz'] = array(
	'display_map' => array( 0, 'عرض_الخريطه', 'عرض_الخريطة', 'display_map' ),
	'display_point' => array( 0, 'نقطة_العرض', 'نقاط_العرض', 'display_point', 'display_points' ),
	'geocode' => array( 0, 'كود_جغرافي', 'geocode' ),
	'geodistance' => array( 0, 'مسافه_جغرافيه', 'مسافة_جغرافية', 'geodistance' ),
	'finddestination' => array( 0, 'إيجاد_الوجهه', 'إيجاد_الوجهة', 'finddestination' ),
	'coordinates' => array( 0, 'إحداثيات', 'coordinates' ),
);

/** Breton (Brezhoneg) */
$magicWords['br'] = array(
	'coordinates' => array( 0, 'daveennoù' ),
	'distance' => array( 0, 'hed' ),
);

/** Chechen (Нохчийн) */
$magicWords['ce'] = array(
	'display_point' => array( 0, 'гайта_тlадам', 'показать_точку', 'display_point', 'display_points' ),
	'geocode' => array( 0, 'геагишар', 'геокод', 'geocode' ),
);

/** Esperanto (Esperanto) */
$magicWords['eo'] = array(
	'coordinates' => array( 0, 'koordinatoj' ),
	'distance' => array( 0, 'distanco' ),
);

/** Spanish (Español) */
$magicWords['es'] = array(
	'display_point' => array( 0, 'mostrar_punto', 'display_point', 'display_points' ),
	'geocode' => array( 0, 'geocodificar', 'geocode' ),
);

/** French (Français) */
$magicWords['fr'] = array(
	'finddestination' => array( 0, 'trouverdestination' ),
);

/** Igbo (Igbo) */
$magicWords['ig'] = array(
	'display_map' => array( 0, 'zí_otúzọr', 'display_map' ),
);

/** Italian (Italiano) */
$magicWords['it'] = array(
	'display_map' => array( 0, 'mostra_mappa' ),
	'display_point' => array( 0, 'mostra_punto', 'mostra_punti' ),
	'coordinates' => array( 0, 'coordinate' ),
	'distance' => array( 0, 'distanza' ),
);

/** Japanese (日本語) */
$magicWords['ja'] = array(
	'display_map' => array( 0, '地図表示' ),
	'display_point' => array( 0, '地図点' ),
	'geocode' => array( 0, '地理的コード' ),
	'geodistance' => array( 0, '地理的距離' ),
	'finddestination' => array( 0, '目的地検索' ),
	'coordinates' => array( 0, '座標' ),
	'distance' => array( 0, '距離' ),
);

/** Georgian (ქართული) */
$magicWords['ka'] = array(
	'coordinates' => array( 0, 'კოორდინატები' ),
);

/** Ladino (Ladino) */
$magicWords['lad'] = array(
	'distance' => array( 0, 'distancia', 'distance' ),
);

/** Macedonian (Македонски) */
$magicWords['mk'] = array(
	'display_map' => array( 0, 'прикажи_карта' ),
	'display_point' => array( 0, 'прикажи_точка', 'прикажи_точки' ),
	'geocode' => array( 0, 'геокод' ),
	'geodistance' => array( 0, 'георастојание' ),
	'finddestination' => array( 0, 'најдиодредница' ),
	'coordinates' => array( 0, 'координати' ),
	'distance' => array( 0, 'растојание' ),
);

/** Malayalam (മലയാളം) */
$magicWords['ml'] = array(
	'display_map' => array( 0, 'ഭൂപടം_പ്രദർശിപ്പിക്കുക' ),
	'display_point' => array( 0, 'ബിന്ദു_പ്രദർശിപ്പിക്കുക', 'ബിന്ദുക്കൾ_പ്രദർശിപ്പിക്കുക' ),
	'geodistance' => array( 0, 'ഭൗമദൂരം' ),
	'finddestination' => array( 0, 'ലക്ഷ്യംതിരയുക' ),
	'coordinates' => array( 0, 'നിർദ്ദേശാങ്കങ്ങൾ' ),
	'distance' => array( 0, 'ദൂരം' ),
);

/** Nedersaksisch (Nedersaksisch) */
$magicWords['nds-nl'] = array(
	'display_map' => array( 0, 'kaorte_weergeven' ),
	'geocode' => array( 0, 'geokoderen' ),
	'geodistance' => array( 0, 'geo-aofstaand' ),
	'finddestination' => array( 0, 'bestemmingzeuken' ),
	'coordinates' => array( 0, 'koordinaoten' ),
	'distance' => array( 0, 'aofstaand' ),
);

/** Dutch (Nederlands) */
$magicWords['nl'] = array(
	'display_map' => array( 0, 'kaart_weergeven' ),
	'display_point' => array( 0, 'punt_weergeven' ),
	'geocode' => array( 0, 'geocoderen' ),
	'geodistance' => array( 0, 'geoafstand' ),
	'finddestination' => array( 0, 'bestemmingzoeken' ),
	'coordinates' => array( 0, 'coordinaten' ),
	'distance' => array( 0, 'afstand' ),
);

/** Polish (Polski) */
$magicWords['pl'] = array(
	'display_map' => array( 0, 'wyświetl_mapę' ),
	'coordinates' => array( 0, 'współrzędne' ),
	'distance' => array( 0, 'odległość' ),
);

/** Pashto (پښتو) */
$magicWords['ps'] = array(
	'distance' => array( 0, 'واټن', 'distance' ),
);

/** Portuguese (Português) */
$magicWords['pt'] = array(
	'display_map' => array( 0, 'mostrar_mapa', 'display_map' ),
	'display_point' => array( 0, 'mostrar_ponto', 'mostrar_pontos', 'display_point', 'display_points' ),
	'geocode' => array( 0, 'geocódigo', 'geocode' ),
	'geodistance' => array( 0, 'geodistância', 'geodistance' ),
	'finddestination' => array( 0, 'encontrardestino', 'finddestination' ),
	'coordinates' => array( 0, 'coordenadas', 'coordinates' ),
	'distance' => array( 0, 'distância', 'distance' ),
);

/** Russian (Русский) */
$magicWords['ru'] = array(
	'display_map' => array( 0, 'показать_карту' ),
	'display_point' => array( 0, 'показать_точку' ),
	'geocode' => array( 0, 'геокод' ),
	'geodistance' => array( 0, 'георасстояние' ),
	'finddestination' => array( 0, 'найти_местоположение' ),
	'coordinates' => array( 0, 'координаты' ),
	'distance' => array( 0, 'расстояние' ),
);

/** Sinhala (සිංහල) */
$magicWords['si'] = array(
	'finddestination' => array( 0, 'ගමනාන්තය_සෙවීම', 'finddestination' ),
	'coordinates' => array( 0, 'ඛණ්ඩාංක', 'coordinates' ),
	'distance' => array( 0, 'දුර', 'distance' ),
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬) */
$magicWords['sr-ec'] = array(
	'display_map' => array( 0, 'прикажи_мапу' ),
	'display_point' => array( 0, 'прикажи_тачку', 'прикажи_тачке' ),
	'finddestination' => array( 0, 'пронађиодредиште', 'пронађи_одредиште' ),
	'coordinates' => array( 0, 'координате' ),
	'distance' => array( 0, 'раздаљина' ),
);

/** Vietnamese (Tiếng Việt) */
$magicWords['vi'] = array(
	'coordinates' => array( 0, 'tọađộ' ),
);