<?php
/**
 * Internationalisation file for Maps extension.
 *
 * @file
 * @ingroup Extensions
 */

$magicWords = array();

/** English (English) */
$magicWords['en'] = array(
	'display_map' => array( 0, 'display_map' ),
	'display_point' => array( 0, 'display_point' ),
	'display_points' => array( 0, 'display_points' ),
	'display_line' => array( 0, 'display_line' ),
	'geocode' => array( 0, 'geocode' ),
	'geodistance' => array( 0, 'geodistance' ),
	'finddestination' => array( 0, 'finddestination' ),
	'coordinates' => array( 0, 'coordinates' ),
	'distance' => array( 0, 'distance' ),
	'mapsdoc' => array( 0, 'mapsdoc' ),
);

/** Afrikaans (Afrikaans) */
$magicWords['af'] = array(
	'geocode' => array( 0, 'geokode', 'geocode' ),
	'coordinates' => array( 0, 'koördinate', 'coordinates' ),
);

/** Arabic (العربية) */
$magicWords['ar'] = array(
	'display_map' => array( 0, 'عرض_الخريطة' ),
	'display_point' => array( 0, 'نقطة_العرض' ),
	'display_points' => array( 0, 'نقاط_العرض' ),
	'display_line' => array( 0, 'خط_العرض' ),
	'geocode' => array( 0, 'كود_جغرافي' ),
	'geodistance' => array( 0, 'مسافة_جغرافية' ),
	'finddestination' => array( 0, 'إيجاد_الوجهة' ),
	'coordinates' => array( 0, 'إحداثيات' ),
	'distance' => array( 0, 'مسافة' ),
	'mapsdoc' => array( 0, 'توثيق_الخرائط' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$magicWords['arz'] = array(
	'display_map' => array( 0, 'عرض_الخريطه', 'عرض_الخريطة', 'display_map' ),
	'geocode' => array( 0, 'كود_جغرافي', 'geocode' ),
	'geodistance' => array( 0, 'مسافه_جغرافيه', 'مسافة_جغرافية', 'geodistance' ),
	'finddestination' => array( 0, 'إيجاد_الوجهه', 'إيجاد_الوجهة', 'finddestination' ),
	'coordinates' => array( 0, 'إحداثيات', 'coordinates' ),
);

/** Assamese (অসমীয়া) */
$magicWords['as'] = array(
	'display_point' => array( 0, 'মানচিত্ৰ_প্ৰদৰ্শন' ),
);

/** Breton (brezhoneg) */
$magicWords['br'] = array(
	'coordinates' => array( 0, 'daveennoù' ),
	'distance' => array( 0, 'hed' ),
);

/** Chechen (нохчийн) */
$magicWords['ce'] = array(
	'geocode' => array( 0, 'геагишар', 'геокод', 'geocode' ),
);

/** German (Deutsch) */
$magicWords['de'] = array(
	'display_map' => array( 0, 'zeige_karte' ),
	'display_point' => array( 0, 'zeige_punkt' ),
	'display_points' => array( 0, 'zeige_punkte' ),
	'display_line' => array( 0, 'zeige_linie' ),
	'geocode' => array( 0, 'geokodiere' ),
	'geodistance' => array( 0, 'geoentfernung' ),
	'finddestination' => array( 0, 'finde_ziel' ),
	'coordinates' => array( 0, 'koordinaten' ),
	'distance' => array( 0, 'entfernung' ),
	'mapsdoc' => array( 0, 'mapsdok' ),
);

/** Zazaki (Zazaki) */
$magicWords['diq'] = array(
	'display_map' => array( 0, 'aseniya_xerita' ),
	'display_point' => array( 0, 'aseniya_dewti' ),
	'display_points' => array( 0, 'aseniya_dawıtan' ),
	'display_line' => array( 0, 'aseniya_xeter' ),
	'geocode' => array( 0, 'herunkodi' ),
	'geodistance' => array( 0, 'heruna_mesafi' ),
	'finddestination' => array( 0, 'menzilvinayış' ),
	'coordinates' => array( 0, 'koordinati' ),
	'distance' => array( 0, 'mesafe' ),
	'mapsdoc' => array( 0, 'dokumanêxerita' ),
);

/** Esperanto (Esperanto) */
$magicWords['eo'] = array(
	'coordinates' => array( 0, 'koordinatoj' ),
	'distance' => array( 0, 'distanco' ),
);

/** Spanish (español) */
$magicWords['es'] = array(
	'display_point' => array( 0, 'mostrar_punto' ),
	'geocode' => array( 0, 'geocodificar' ),
);

/** French (français) */
$magicWords['fr'] = array(
	'finddestination' => array( 0, 'trouverdestination' ),
	'coordinates' => array( 0, 'coordonnées' ),
);

/** Igbo (Igbo) */
$magicWords['ig'] = array(
	'display_map' => array( 0, 'zí_otúzọr', 'display_map' ),
);

/** Italian (italiano) */
$magicWords['it'] = array(
	'display_map' => array( 0, 'mostra_mappa' ),
	'display_point' => array( 0, 'mostra_punto' ),
	'display_points' => array( 0, 'mostra_punti' ),
	'coordinates' => array( 0, 'coordinate' ),
	'distance' => array( 0, 'distanza' ),
);

/** Japanese (日本語) */
$magicWords['ja'] = array(
	'display_map' => array( 0, '地図表示' ),
	'display_point' => array( 0, '地図点' ),
	'geocode' => array( 0, '地理的コード' ),
	'geodistance' => array( 0, '地理的距離' ),
	'finddestination' => array( 0, '目的地検索' ),
	'coordinates' => array( 0, '座標' ),
	'distance' => array( 0, '距離' ),
);

/** Georgian (ქართული) */
$magicWords['ka'] = array(
	'coordinates' => array( 0, 'კოორდინატები' ),
	'distance' => array( 0, 'მანძილი' ),
);

/** Korean (한국어) */
$magicWords['ko'] = array(
	'display_map' => array( 0, '지도_표시' ),
	'display_point' => array( 0, '포인트_표시' ),
	'display_points' => array( 0, '포인트목록_표시' ),
	'display_line' => array( 0, '선_표시' ),
	'geocode' => array( 0, '지리코드' ),
	'geodistance' => array( 0, '지리거리' ),
	'finddestination' => array( 0, '목적지찾기' ),
	'coordinates' => array( 0, '좌표' ),
	'distance' => array( 0, '거리' ),
	'mapsdoc' => array( 0, '지도문서' ),
);

/** Ladino (Ladino) */
$magicWords['lad'] = array(
	'distance' => array( 0, 'distancia', 'distance' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$magicWords['lb'] = array(
	'coordinates' => array( 0, 'Koordinaten' ),
	'distance' => array( 0, 'Distanz' ),
);

/** Macedonian (македонски) */
$magicWords['mk'] = array(
	'display_map' => array( 0, 'прикажи_карта' ),
	'display_point' => array( 0, 'прикажи_точка' ),
	'display_points' => array( 0, 'прикажи_точки' ),
	'display_line' => array( 0, 'прикажи_линија' ),
	'geocode' => array( 0, 'геокод' ),
	'geodistance' => array( 0, 'георастојание' ),
	'finddestination' => array( 0, 'најдиодредница' ),
	'coordinates' => array( 0, 'координати' ),
	'distance' => array( 0, 'растојание' ),
	'mapsdoc' => array( 0, 'докумкарти' ),
);

/** Malayalam (മലയാളം) */
$magicWords['ml'] = array(
	'display_map' => array( 0, 'ഭൂപടം_പ്രദർശിപ്പിക്കുക' ),
	'display_point' => array( 0, 'ബിന്ദു_പ്രദർശിപ്പിക്കുക' ),
	'display_points' => array( 0, 'ബിന്ദുക്കൾ_പ്രദർശിപ്പിക്കുക' ),
	'display_line' => array( 0, 'രേഖ_പ്രദർശിപ്പിക്കുക' ),
	'geocode' => array( 0, 'ജിയോകോഡ്' ),
	'geodistance' => array( 0, 'ഭൗമദൂരം' ),
	'finddestination' => array( 0, 'ലക്ഷ്യംതിരയുക' ),
	'coordinates' => array( 0, 'നിർദ്ദേശാങ്കങ്ങൾ' ),
	'distance' => array( 0, 'ദൂരം' ),
);

/** Nedersaksisch (Nedersaksisch) */
$magicWords['nds-nl'] = array(
	'display_map' => array( 0, 'kaorte_weergeven' ),
	'geocode' => array( 0, 'geokoderen' ),
	'geodistance' => array( 0, 'geo-aofstaand' ),
	'finddestination' => array( 0, 'bestemmingzeuken' ),
	'coordinates' => array( 0, 'koordinaoten' ),
	'distance' => array( 0, 'aofstaand' ),
);

/** Dutch (Nederlands) */
$magicWords['nl'] = array(
	'display_map' => array( 0, 'kaart_weergeven' ),
	'display_point' => array( 0, 'punt_weergeven' ),
	'display_points' => array( 0, 'punten_weergeven' ),
	'display_line' => array( 0, 'lijn_weergeven' ),
	'geocode' => array( 0, 'geocoderen' ),
	'geodistance' => array( 0, 'geoafstand' ),
	'finddestination' => array( 0, 'bestemmingzoeken' ),
	'coordinates' => array( 0, 'coordinaten' ),
	'distance' => array( 0, 'afstand' ),
	'mapsdoc' => array( 0, 'kaartdoc' ),
);

/** Polish (polski) */
$magicWords['pl'] = array(
	'display_map' => array( 0, 'wyświetl_mapę' ),
	'coordinates' => array( 0, 'współrzędne' ),
	'distance' => array( 0, 'odległość' ),
);

/** Pashto (پښتو) */
$magicWords['ps'] = array(
	'distance' => array( 0, 'واټن', 'distance' ),
);

/** Portuguese (português) */
$magicWords['pt'] = array(
	'display_map' => array( 0, 'mostrar_mapa', 'display_map' ),
	'display_point' => array( 0, 'mostrar_ponto', 'mostrar_pontos' ),
	'display_points' => array( 0, 'mostrar_pontos' ),
	'geocode' => array( 0, 'geocódigo', 'geocode' ),
	'geodistance' => array( 0, 'geodistância', 'geodistance' ),
	'finddestination' => array( 0, 'encontrardestino', 'finddestination' ),
	'coordinates' => array( 0, 'coordenadas', 'coordinates' ),
	'distance' => array( 0, 'distância', 'distance' ),
);

/** Russian (русский) */
$magicWords['ru'] = array(
	'display_map' => array( 0, 'показать_карту' ),
	'display_point' => array( 0, 'показать_точку' ),
	'geocode' => array( 0, 'геокод' ),
	'geodistance' => array( 0, 'георасстояние' ),
	'finddestination' => array( 0, 'найти_местоположение' ),
	'coordinates' => array( 0, 'координаты' ),
	'distance' => array( 0, 'расстояние' ),
);

/** Sinhala (සිංහල) */
$magicWords['si'] = array(
	'finddestination' => array( 0, 'ගමනාන්තය_සෙවීම', 'finddestination' ),
	'coordinates' => array( 0, 'ඛණ්ඩාංක', 'coordinates' ),
	'distance' => array( 0, 'දුර', 'distance' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$magicWords['sr-ec'] = array(
	'display_map' => array( 0, 'прикажи_мапу' ),
	'display_point' => array( 0, 'прикажи_тачку', 'прикажи_тачке' ),
	'finddestination' => array( 0, 'пронађиодредиште', 'пронађи_одредиште' ),
	'coordinates' => array( 0, 'координате' ),
	'distance' => array( 0, 'раздаљина' ),
);

/** Serbian (Latin script) (srpski (latinica)‎) */
$magicWords['sr-el'] = array(
	'display_map' => array( 0, 'prikaži_mapu' ),
	'display_point' => array( 0, 'prikaži_tačku', 'prikaži_tačke' ),
	'geocode' => array( 0, 'geografski_kod' ),
	'geodistance' => array( 0, 'geografska_razdaljina' ),
	'finddestination' => array( 0, 'pronađi_odredište' ),
	'coordinates' => array( 0, 'koordinate' ),
	'distance' => array( 0, 'razdaljina' ),
);

/** толышә зывон (толышә зывон) */
$magicWords['tly'] = array(
	'display_map' => array( 0, 'хәритә_нишо_дој' ),
);

/** Ukrainian (українська) */
$magicWords['uk'] = array(
	'display_map' => array( 0, 'показати_карту' ),
	'display_point' => array( 0, 'показати_точку' ),
	'display_points' => array( 0, 'показати_точки' ),
	'geodistance' => array( 0, 'геовідстань' ),
	'finddestination' => array( 0, 'знайти_місцезнаходження' ),
	'coordinates' => array( 0, 'координати' ),
	'distance' => array( 0, 'відстань' ),
);

/** Vietnamese (Tiếng Việt) */
$magicWords['vi'] = array(
	'coordinates' => array( 0, 'tọađộ' ),
);