<?php
/**
 * Internationalisation file for Liquid Threads extension.
 *
 * @file
 * @ingroup Extensions
 * @author David McCabe <davemccabe@gmail.com> / i18n file by Erik Moeller and Siebrand Mazeland
 * @licence GPL2
 */

$messages = array();

$messages['en'] = array(
	'lqt-desc' => 'Add threading discussions to talk pages',
	'lqt_movethread' => 'Move thread to another page',
	'lqt_deletethread' => 'Delete or undelete thread',
	'lqt_contents_title' => 'Contents',
	'lqt_toc_thread_title' => 'Thread title',
	'lqt_toc_thread_author' => 'Started by',
	'lqt_toc_thread_replycount' => 'Replies',
	'lqt_toc_thread_modified' => 'Last modified',
	'lqt_add_header' => 'Add header',
	'lqt_new_thread' => 'Start a new discussion',
	'lqt_invalid_subject' => 'The subject you entered is invalid.
It may:
* Be too long, or
* Conflict with interwiki prefixes or namespace names.',
	'lqt_empty_subject' => 'You must enter a subject.',
	'lqt_reply' => 'Reply',
	'lqt-parent' => 'Parent',
	'lqt_delete' => 'Delete',
	'lqt_undelete' => 'Undelete',
	'lqt_permalink' => 'Link to',
	'lqt_fragment' => 'Fragment of a $1 from $2',
	'lqt_discussion_link' => 'discussion', // substituted above
	'lqt_from_talk' => 'From $1',

	'lqt-history-title' => 'Thread history',
	'lqt_hist_comment_edited' => 'Comment text [$2 edited]',
	'lqt_hist_summary_changed' => 'Summary changed',
	'lqt_hist_reply_created' => '[[$1|New reply]] created',
	'lqt_hist_thread_created' => 'New thread created',
	'lqt_hist_deleted' => 'Deleted',
	'lqt_hist_undeleted' => 'Undeleted',
	'lqt_hist_moved_talkpage' => 'Moved',
	'lqt_hist_listing_subtitle' => 'Viewing a history listing',
	'lqt_hist_view_whole_thread' => 'View history for the entire thread',
	'lqt_hist_no_revisions_error' => 'This thread does not have any history revisions.',
	'lqt_hist_past_last_page_error' => 'You are beyond the number of pages of history that exist.',
	'lqt_hist_tooltip_newer_disabled' => 'This link is disabled because you are on the first page.',
	'lqt_hist_tooltip_older_disabled' => 'This link is disabled because you are on the last page.',
	'lqt_hist_split' => 'Reply split to a new thread',
	'lqt_hist_edited_subject' => 'Changed subject from "$2" to "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Changed subject',
	'lqt_hist_merged_from' => '[[$1|Reply]] moved to another thread',
	'lqt_hist_merged_to' => '[[$1|Reply]] moved from another thread',
	'lqt_hist_split_from' => 'Split to a new thread',
	'lqt_hist_root_blanked' => 'Removed comment text',
	'lqt_hist_adjusted_sortkey' => 'Adjusted thread position',

	'lqt_revision_as_of' => "Revision as of $2 at $3.",

	'lqt_change_new_thread' => 'This is the thread\'s initial revision.',
	'lqt_change_reply_created' => 'The [$1 highlighted comment] was created in this revision.',
	'lqt_change_edited_root' => 'The [$1 highlighted comment] was edited in this revision.',
	'lqt_change_edited_summary' => "The thread's summary was edited",
	'lqt_change_deleted' => '[$1 This thread] or its parent was deleted',
	'lqt_change_undeleted' => 'The [$1 highlighted post] was undeleted',
	'lqt_change_moved' => '[$1 This thread] was moved to another discussion page',
	'lqt_change_split' => '[$1 This thread] was split from another thread',
	'lqt_change_edited_subject' => 'The subject of this thread was changed from "$2" to "$3"',
	'lqt_change_merged_from' => 'A [$1 reply] to this thread was moved to another thread',
	'lqt_change_merged_to' => 'The [$1 highlighted reply] was moved from another thread',
	'lqt_change_split_from' => 'A [$1 subthread] of this thread was split into its own thread',
	'lqt_change_root_blanked' => 'The text of [$1 a comment] was removed.',

	'lqt_youhavenewmessages' => 'You have [[$1|new messages]].',
	'lqt_protectedfromreply' => 'This thread has been $1 from being replied to.',
	'lqt_protectedfromreply_link' => 'protected',
	'lqt_subject' => 'Subject:',
	'lqt_noreason' => 'No reason given.',
	'lqt_move_placeholder' => 'A thread, $1, was moved from here to $5.
This move was made by $2 on $3 at $4.',
	'lqt_thread_deleted_for_sysops' => 'This thread has been \'\'\'deleted\'\'\' and is only visible to administrators.',
	'lqt_thread_deleted' => 'This thread has been deleted.',
	'lqt_summary_notice' => 'There have been no changes to this discussion for at least $2 {{PLURAL:$2|day|days}}.
If it is concluded, you may want to $1.',
	'lqt_summary_notice_link' => 'write a summary',
	'lqt_summary_label' => 'Thread summary:',
	'lqt_summary_subtitle' => 'Summary of "$1"',
	'lqt_nosuchrevision' => 'There is no such revision of this thread.',
	'lqt_nosuchthread' => 'The thread you specified does not exist.',
	'lqt_nosuchthread_title' => 'No such thread',
	'lqt_threadrequired' => 'You must specify a thread in the URL.',
	'lqt_move_movingthread' => 'Moving $1.
This thread is part of $2.',
	'lqt_move_torename' => 'To rename this thread, $1 and change the \'Subject\' field.',
	'lqt_move_torename_edit' => 'edit it', // substituted above as a link
	'lqt_move_destinationtitle' => 'Title of destination talk page:',
	'lqt_move_move' => 'Move',
	'lqt_move_nodestination' => 'You must specify a destination.',
	'lqt_move_thread_bad_destination' => 'The destination page is not a discussion page.',
	'lqt_move_samedestination' => 'The thread is already on this page!',
	'lqt_move_noreason' => 'No reason given.',
	'lqt_move_success' => 'The thread was moved to $1.',
	'lqt_delete_undeletethread' => 'Undelete thread',
	'lqt_delete_partof' => 'This thread is part of \'\'\'$1\'\'\'.',
	'lqt_delete_deleting' => 'Deleting \'\'\'$1\'\'\' and \'\'\'all replies\'\'\' to it.',
	'lqt_delete_deletethread' => 'Delete thread and replies',
	'lqt_delete_deleted' => 'The thread was deleted.',
	'lqt_delete_undeleted' => 'The thread was undeleted.',
	'lqt_delete_return' => 'Return to $1.',
	'lqt_delete_return_link' => 'the talk page', // subst above
	'lqt_delete_unallowed' => 'You are not allowed to delete threads.',
	'lqt_delete_show_checkbox' => 'Show deleted threads',
	'lqt_talkpage_autocreate_summary' => 'Talk page autocreated when first thread was posted',
	'lqt_header_warning_before_big' => '',
	'lqt_header_warning_big' => 'You are editing a $1.',
	'lqt_header_warning_after_big' => 'Headers are for announcements and prefaces.
You might instead want to $2.',
	'lqt_header_warning_bold' => 'discussion page header',
	'lqt_header_warning_new_discussion' => 'start a new discussion',
	'lqt_sorting_order' => 'Sorting order:',
	'lqt_sort_newest_changes' => 'last modified first',
	'lqt_sort_newest_threads' => 'newest threads first',
	'lqt_sort_oldest_threads' => 'oldest threads first',
	'lqt-title' => 'Title',
	'lqt-summary' => 'Summary',
	'lqt-searching' => 'Searching for threads',
	'lqt-read-message' => 'Mark as read',
	'lqt-read-message-tooltip' => 'Remove this thread from new messages.
It will still be visible on its original talk page.',
	'lqt-read-all' => 'Mark all as read',
	'lqt-read-all-tooltip' => 'Remove all threads from new messages.
They will still be visible on their original talk pages.
This operation is undoable.',
	'lqt-marked-read' => 'Thread \'\'\'$1\'\'\' marked as read.',
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|message|messages}} marked as read.',
	'lqt-email-undo' => 'Undo',
	'lqt-no-new-messages' => 'There are no new messages for you.',
	'lqt-new-messages' => '✒ There are new messages for you.',
	'lqt-email-info-undo' => 'Bring back the thread you just dismissed.',
	'lqt-date-info' => 'This link is disabled because you are viewing threads from all dates.',
	'lqt-newmessages-context' => 'Full thread',
	'lqt-thread-created'	 => 'Created',
	'lqt-history-time' => 'Time',
	'lqt-history-user' => 'User',
	'lqt-history-action' => 'Activity',
	'lqt-history-comment' => 'Comment',
	'lqt-history-thread' => 'Thread',
	'lqt-thread-edited-author' => "Edited by author.<br />\nLast edit: $1",
	'lqt-thread-edited-others' => "Edited by {{PLURAL:$2|another user|$2 users}}.<br />\nLast edit: $1",
	'lqt-header-actions' => 'Actions',
	'lqt_summarize_link' => 'Summarize',
	'lqt-summarize-intro' => 'Please summarize the below thread in the editing box.
You may use any wikitext in your summary.
When you finish, click "{{int:savearticle}}".',
	'lqt-thread-split' => 'Split to new thread',
	'lqt-split-success' => 'You have successfully split off the thread $1.',
	'lqt_split_thread' => 'Split a thread',
	'lqt-thread-split-subject' => 'New thread subject:',
	'lqt-thread-split-thread' => 'Thread:',
	'lqt-split-submit' => 'Split',
	'lqt_split_badsubject' => 'The subject you entered is invalid.',
	'lqt-no-threads' => 'There are no threads on this page yet.',
	'lqt-delete-parent-warning' => 'This is a top-level thread with replies.
Its replies will also be deleted automatically.
To avoid this, split them from this thread before deleting it.',
	'lqt-delete-parent-deleted' => 'Parent thread deleted ($1)',
	'lqt-delete-replies-done' => 'All replies to this thread have also been deleted.',
	'lqt-movethread' => 'Move',
	'lqt-menu-trigger' => 'More',
	'lqt-newmessages-from' => 'From $1',
	'lqt-hot-topics' => 'Hot topics',
	'lqt-add-reply' => 'Add a reply',

	// Recent changes display
	'lqt_rc_new_discussion' => "posted a new thread, \"$1\"",
	'lqt_rc_new_reply' => "posted a reply to \"$1\"",

	// Rights
	'right-lqt-split' => 'Split threads',
	'right-lqt-merge' => 'Merge threads',
	'right-lqt-react' => 'Reply to threads',

	// Merging
	'lqt-thread-merge' => 'Merge into another thread',
	'lqt-thread-merge-to' => 'Merge into this thread',
	'lqt_merge_thread' => 'Merge thread',
	'lqt-thread-merge-source' => 'Source thread:',
	'lqt-thread-merge-dest' => 'Destination thread:',
	'lqt-merge-submit' => 'Merge',
	'lqt-merge-success' => 'You have successfully merged the thread $1 to underneath $2.',

	// Logging
	'lqt-log-name' => 'Threaded discussion log',
	'lqt-log-header' => 'This log details actions taken on discussion threads.',
	'lqt-log-action-move' => 'moved [[$1]] from [[$2]] to [[$3]]',
	'lqt-log-action-split' => 'split [[$1]] from under [[$3]], with the new subject "$2"',
	'lqt-log-action-merge-across' => 'moved [[$1]] from under [[$2]] to under [[$3]]',
	'lqt-log-action-merge-down' => 'merged [[$1]] to underneath [[$3]]',
	'lqt-log-action-subjectedit' => 'changed the subject of [[$1]] from "$2" to "$3"',
	'lqt-log-action-resort' => 'modified the sort order of [[$1]]. Changed sort key from $2 to $3',

	// Preferences
	'lqt-preference-notify-talk' => 'E-mail me on replies to a thread I am watching',
	'lqt-preference-watch-threads' => 'Watch threads that I create or reply to',
	'prefs-lqt' => 'Threaded discussion',
	'lqt-preference-display-depth' => 'Maximum reply depth to show:',
	'lqt-preference-display-count' => 'Maximum number of replies to show:',
	'lqt-preference-custom-signatures' => 'Show custom user signatures',

	// E-mail notification
	'lqt-enotif-subject-reply' => '{{SITENAME}} discussion - Reply: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} discussion - New thread: $1',
	'lqt-enotif-newthread' => "Hi $1,
	
this is a notification from {{SITENAME}} that a new thread on $5, '$2',
was created on $3 at $4 by $8

You can see it at <$6>

The text is:
$7",
	'lqt-enotif-reply' => "Hi $1,

this is a notification from {{SITENAME}} that a new reply to '$2' on $5,
was created on $3 at $4 by $8

You can see it at <$6>

The text of the reply is:
$7",

	// Quoting functionality
	'lqt-quote-intro' => 'On $2 at $3, [[User:$1|$1]] wrote:',
	'lqt-quote' => 'Quote',

	// Search
	'lqt-search-legend' => 'Search discussions on this page',
	'lqt-search-label' => 'Search terms:',
	'lqt-search-button' => 'Search',
	'searchprofile-threads' => 'Discussions',
	'searchprofile-threads-tooltip' => 'Search threaded discussions and talk pages',

	// Some AJAX stuff
	'lqt-ajax-updated' => 'This thread has new posts.',
	'lqt-ajax-update-link' => 'Update',
	'lqt-thread-show-replies' => 'Show $1 {{PLURAL:$1|reply|replies}}',
	'lqt-thread-show-more' => 'Show more replies',
	'lqt-thread-link-url' => 'Link URL:',
	'lqt-thread-link-title' => 'Wikitext link:',
	'lqt-thread-link-copy' => 'Copy to clipboard',
	'lqt-sign-not-necessary' => 'It is not necessary to sign your post with four tildes.
The signature is shown automatically.',
	'lqt-marked-as-read-placeholder' => 'The thread $1 was marked as read.',
	'lqt-change-subject' => 'Change subject',
	'lqt-save-subject' => 'Save',
	'lqt-save-subject-failed' => 'The following error occurred while attempting to change the subject of this thread: $1',
	'lqt-ajax-invalid-subject' => 'The subject you specified was invalid, probably because it was too long.',
	'lqt-ajax-no-subject' => 'You must specify a subject for the new thread.',
	'lqt-save-subject-error-unknown' => 'An unknown error occurred when attempting to set the subject of this thread. Please try to do this by clicking "edit" on the top post.',
	'lqt-cancel-subject-edit' => 'Cancel',
	'lqt-drag-activate' => 'Drag to new location',
	'lqt-drag-drop-zone' => 'Drop here',
	'lqt-drag-confirm' => 'To complete the following actions, please fill in a reason and click "Confirm".',
	'lqt-drag-reparent' => 'Move post to underneath a new parent.',
	'lqt-drag-split' => 'Move post to its own thread',
	'lqt-drag-setsortkey' => "Adjust post's position on the page",
	'lqt-drag-bump' => 'Move post to top of discussion page',
	'lqt-drag-save' => 'Confirm',
	'lqt-drag-title' => 'Confirm drag',
	'lqt-drag-reason' => 'Reason:',
	'lqt-drag-subject' => 'Subject for new thread (mandatory):',
	'lqt-edit-signature' => '(edit signature)',
	'lqt-preview-signature' => '(preview)',

	// Feeds
	'lqt-feed-title-all' => '{{SITENAME}} — New posts',
	'lqt-feed-title-all-from' => '{{SITENAME}} — New posts from $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — New threads',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — New threads from $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Replies',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Replies from $1',
	'lqt-feed-new-thread-intro' => 'New thread on $1 posted by $2',
	'lqt-feed-reply-intro' => 'Reply to $3 (on $1) posted by $2',

	// Personal tool links
	'tooltip-pt-newmessages' => 'Shows new posts to threads or on threaded talk pages you are watching',
	'lqt-newmessages-n' => 'My new messages ($1)',
	'lqt_newmessages' => 'My new messages (None)',
	'lqt_newmessages-title' => 'New messages',

	// Automatic summaries
	'lqt-newpost-summary' => 'New thread: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => "Please enter your text for this thread. You should delete this line then.",
	'lqt-reply-summary' => 'Reply to [[$2|$1]]',

	// Talk page history
	'lqt-talkpage-history-title' => 'Discussion page history',
	'lqt-talkpage-history-subtitle' => 'For $1',
	'lqt-talkpage-history-tab' => 'Header',

	// Protection
	'restriction-reply' => 'Post replies',
	'restriction-newthread' => 'Post new threads',
	'lqt-protected-reply-thread' => 'You cannot post in this thread because it has been protected from new posts.',
	'lqt-protected-reply-talkpage' => 'You cannot post in this thread because this discussion page has been protected from replies to its threads.',
	'lqt-protected-newthread' => 'You cannot post new threads to this discussion page because it has been protected from new threads.',

	'lqt-edit-bump' => 'Bump this thread',
	'lqt-edit-bump-tooltip' => 'Move this thread to the top of its discussion page',

	'lqt-historicalrevision-error' => 'The revision you have selected is corrupt, and cannot be viewed.',

	// Reply subpage name
	'lqt-reply-subpage' => 'reply',

	// Tabs in skins
	'nstab-thread' => 'Thread',
	'nstab-summary' => 'Summary',
);

/** Message documentation (Message documentation)
 * @author Amire80
 * @author Aotake
 * @author Bennylin
 * @author Blaisorblade
 * @author Crt
 * @author Dani
 * @author Darth Kule
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author Hamilton Abreu
 * @author Helix84
 * @author IAlex
 * @author Jon Harald Søby
 * @author Lejonel
 * @author Lloffiwr
 * @author Malafaya
 * @author Minh Nguyen
 * @author Mormegil
 * @author Nike
 * @author Purodha
 * @author Rancher
 * @author Raymond
 * @author SPQRobin
 * @author Siebrand
 * @author Spiritia
 * @author The Evil IP address
 * @author Wikinaut
 */
$messages['qqq'] = array(
	'lqt-desc' => '{{desc}}',
	'lqt_movethread' => 'Title and header at [[Special:MoveThread]].',
	'lqt_contents_title' => 'The title of a list of threads at the top of the page.
{{Identical|Contents}}',
	'lqt_toc_thread_title' => 'Column header on the list of threaded discussions at the top of a discussion page; [[Support|example]].',
	'lqt_toc_thread_replycount' => 'Column header on the list of threaded discussions at the top of a discussion page; [[Support|example]].

{{Identical|Reply}}',
	'lqt_toc_thread_modified' => 'Column header on the list of threaded discussions at the top of a discussion page; [[Support|example]].',
	'lqt_new_thread' => '{{Identical|Start a new discussion}}',
	'lqt_reply' => 'is this noun or verb?

:A verb; see also {{msg-mw|Lqt delete}} and {{msg-mw|Lqt undelete}}.

This is the link in the bottom right-hand corner of a post, which you click to write a reply to that post - see [[Support|examples]].',
	'lqt-parent' => 'Link to the parent reply.',
	'lqt_delete' => '{{Identical|Delete}}',
	'lqt_undelete' => '{{Identical|Undelete}}',
	'lqt_permalink' => "{{doc-important|This message is not followed by a parameter. The English version is short for '''Link to this post'''. It could also be translated as \"Perma[nent ]link\".}} Text for a link to the specific object (e.g. thread summary or discussion fragment).",
	'lqt_fragment' => 'Parameters:
* $1 is a link with {{msg-mw|lqt_discussion_link}} as text
* $2 is a link to the talk page
<!-- as used in /pages/ThreadPermalinkView.php -->',
	'lqt_discussion_link' => 'Link text inserted into {{msg-mw|lqt_fragment}} as $1

{{Identical|Discussion}}',
	'lqt_from_talk' => 'Used as page subtitle. Parameters:
* $1 is a link to a talk page (for example "User talk:Foo")',
	'lqt-history-title' => 'Title of thread history page, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount&lqt_method=thread_history example]',
	'lqt_hist_comment_edited' => 'Parameters:
* $2 is the URL to the comment',
	'lqt_hist_summary_changed' => "Summary for 'activity' in thread history, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount&lqt_method=thread_history example]",
	'lqt_hist_reply_created' => "Summary for 'activity' in thread history, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount&lqt_method=thread_history example]

Parameters:
* $1 is the text for a wiki link to the new reply",
	'lqt_hist_thread_created' => "Summary for 'activity' in thread history, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount&lqt_method=thread_history example]",
	'lqt_hist_deleted' => '{{Identical|Deleted}}',
	'lqt_hist_listing_subtitle' => "Subtitle for 'thread history' page, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount&lqt_method=thread_history example]",
	'lqt_hist_view_whole_thread' => 'Link to history page for an entire thread, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount/reply&action=history example]',
	'lqt_hist_edited_subject' => 'Parameters:
* $2 is the old subject text
* $3 is the new subject text',
	'lqt_hist_merged_from' => 'Parameters:
* $1 is text for a wiki link to the reply',
	'lqt_hist_merged_to' => 'Parameters:
* $1 is the text for a wiki link to the reply',
	'lqt_revision_as_of' => '* $1 is a timestamp (for backward compatibility)
* $2 is a date
* $3 is a time',
	'lqt_change_edited_root' => 'Parameters:
* $1 is a web link to the referenced comment. It must remain immediately after the opening bracket.',
	'lqt_change_deleted' => 'Action results from button {{msg-mw|lqt_delete}}',
	'lqt_change_undeleted' => 'Parameters:
* $1 is a web link to the referenced post. It must remain immediately after the opening bracket.
Action results from button {{msg-mw|lqt_undelete}}',
	'lqt_change_edited_subject' => 'Parameters:
* $2 is the old subject
* $3 is the new subject',
	'lqt_change_merged_from' => 'Parameters:
* $1 is a web link to the referenced reply. It must remain immediately after the opening bracket.',
	'lqt_change_root_blanked' => 'Parameters:
* $1 is a web link to the referenced comment. It must remain immediately after the opening bracket.',
	'lqt_youhavenewmessages' => '* $1 is a link to the new message or messages.

{{doc-important|No PLURAL here! (The number of new messages is unknown.)}}',
	'lqt_protectedfromreply' => '$1 is replaced with {{msg-mw|Lqt protectedfromreply link}}',
	'lqt_protectedfromreply_link' => '{{Identical|Protected}}',
	'lqt_subject' => '{{Identical|Subject}}',
	'lqt_noreason' => '{{Identical|No reason given}}',
	'lqt_thread_deleted_for_sysops' => '',
	'lqt_summary_notice' => '* $1 is a link with {{msg-mw|lqt_summary_notice_link}} as display text
* $2 is a number of days',
	'lqt_summary_notice_link' => 'This fragment is situated in the following context: [[MediaWiki:Lqt summary notice]]',
	'lqt_summary_subtitle' => 'Used as a page subtitle. Parameters:
* $1 is the thread that is being summarised',
	'lqt_move_torename' => '$1 is replaced with {{msg-mw|Lqt move torename edit}}',
	'lqt_move_torename_edit' => 'This message is used inside {{msg-mw|Lqt move torename}}.
{{Identical|Edit}}',
	'lqt_move_move' => '{{Identical|Move}}',
	'lqt_move_noreason' => '{{Identical|No reason given}}',
	'lqt_delete_return' => '$1 is a link back to the talk page, link text from {{msg-mw|lqt_delete_return_link}}.
{{Identical|Return to $1}}',
	'lqt_delete_return_link' => 'This message is $1 in {{msg-mw|lqt_delete_return}}.',
	'lqt_header_warning_big' => '$1 is a bold text, from {{msg-mw|lqt_header_warning_bold}}',
	'lqt_header_warning_after_big' => '$2 is {{msg-mw|Lqt header warning new discussion}}',
	'lqt_header_warning_bold' => 'Bolded text in {{msg-mw|lqt_header_warning_big}}, followed by {{msg-mw|lqt_header_warning_after_big}} + {{msg-mw|lqt_header_warning_new_discussion}}.',
	'lqt_header_warning_new_discussion' => 'This message is $2 in {{msg-mw|Lqt header warning after big}}
{{Identical|Start a new discussion}}',
	'lqt_sorting_order' => 'Legend for drop-down box, at the top of a page using liquid threads, for example [[Support]].

The drop-down box contains the following messages:
*[[MediaWiki:Lqt_sort_newest_changes/{{SUBPAGENAME}}]]
*[[MediaWiki:Lqt_sort_newest_threads/{{SUBPAGENAME}}]]
*[[MediaWiki:Lqt_sort_oldest_threads/{{SUBPAGENAME}}]]',
	'lqt_sort_newest_changes' => 'Option in drop-down box, at the top of a page using liquid threads, for example [[Support]]. The legend for the drop-down box is [[MediaWiki:Lqt_sorting_order/{{SUBPAGENAME}}]].',
	'lqt_sort_newest_threads' => 'Option in drop-down box, at the top of a page using liquid threads, for example [[Support]]. The legend for the drop-down box is [[MediaWiki:Lqt_sorting_order/{{SUBPAGENAME}}]].',
	'lqt_sort_oldest_threads' => 'Option in drop-down box, at the top of a page using liquid threads, for example [[Support]]. The legend for the drop-down box is [[MediaWiki:Lqt_sorting_order/{{SUBPAGENAME}}]].',
	'lqt-title' => '{{Identical|Title}}',
	'lqt-summary' => '{{Identical|Summary}}',
	'lqt-read-message' => '"Read" is past tense.',
	'lqt-email-undo' => '{{Identical|Undo}}',
	'lqt-history-time' => 'Column header on thread history

{{Identical|Time}}',
	'lqt-history-user' => 'Column header for table of thread history, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount&lqt_method=thread_history example]

{{identical|User}}',
	'lqt-history-action' => 'Column header for table of thread history, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount&lqt_method=thread_history example]',
	'lqt-history-comment' => 'Column header for table of thread history, see [http://translatewiki.net/w/i.php?title=Thread:Support/Payflowpro_gateway-select-dollar-amount&lqt_method=thread_history example]

{{Identical|Comment}}',
	'lqt-thread-edited-author' => '* $1: date/time of the last edit
* $2: Unused (Number of users who edited the thread but not useful in this context. Used by [[MediaWiki:Lqt-thread-edited-others]])
* $3: time of the last edit (optional, instead of using $1)
* $4: date of the last edit (optional, instead of using $1)

This is a note which appears alongside an edited post - see [[Thread:Support/Payflowpro gateway-month/reply (4)|example]].',
	'lqt-thread-edited-others' => '* $1: date/time of the last edit
* $2: Number of users who edited the thread
* $3: time of the last edit (optional, instead of using $1)
* $4: date of the last edit (optional, instead of using $1)

This is a note which appears alongside an edited post - see [[Thread:Translating talk:Wikia/Typo in MediaWiki:Feed-title-leaderboard|example]].',
	'lqt-header-actions' => '{{Identical|Action}}',
	'lqt-no-threads' => '[http://translatewiki.net/wiki/Project_talk:MediaWiki_localisation_in_the_50_most_spoken_languages Example]',
	'lqt-delete-parent-deleted' => '$1 is the reason for deletion of the parent.',
	'lqt-movethread' => '{{Identical|Move}}',
	'lqt-menu-trigger' => '{{Identical|More}}',
	'lqt-newmessages-from' => 'Used as page subtitle. Parameters:
* $1 is a link to a talk page (for example "User talk:Foo")',
	'lqt-hot-topics' => 'A page title, used for a special page with "hot" (most-commented-on)
threads on a wiki',
	'lqt_rc_new_discussion' => 'Parameters:
* $1 is a link to a thread with the thread subject as link description',
	'lqt_rc_new_reply' => 'Parameters:
* $1 is a link to a thread with the thread subject as link description',
	'right-lqt-split' => '{{doc-right}}',
	'right-lqt-merge' => '{{doc-right}}',
	'right-lqt-react' => '{{doc-right}}',
	'lqt-log-action-move' => 'Parameteres:
* $1 is the link text to the topic
* $2 is the link text to the source page the topic was moved from
* $3 is the link text to the target page the topic was moved to',
	'lqt-preference-notify-talk' => 'This appears in [[Special:Preferences]]. The wording should be similar to {{msg-mw|tog-enotifwatchlistpages}}.',
	'lqt-preference-watch-threads' => 'The wording of this message should be similar to {{msg-mw|tog-watchdefault}}.',
	'lqt-preference-display-depth' => "Used in Special:Preferences, tab Threaded Discussion (where Liquid Thread extension is installed).
Depth refers to the nesting of replies that were given to replies to replies, etc. which is shown on-screen as indents in the discussion threads.

In other words, 'depth' is the number of idents that will be displayed for a thread (''reply (5) to reply (4) to reply (3) to reply (2) of original post (1)'').
<pre>
-- ORIGINAL (depth 1)
 |-- reply 1 (depth 2)
   |-- reply 2 (reply to reply 1) (depth 3)
 |-- reply 3 (reply to reply 1) (depth 2)
</pre>",
	'lqt-preference-display-count' => 'Used in [[Special:Preferences]], tab “{{int:prefs-lqt}}” (where Liquid Thread extension is installed).',
	'lqt-preference-custom-signatures' => "Checkbox in [[Special:Preferences]], tab ''{{int:prefs-lqt}}''",
	'lqt-enotif-subject-reply' => 'This is the subject header of an e-mail notification.
Parameters are:
* $1 is a thread name or title',
	'lqt-enotif-subject-newthread' => 'This is the subject header of an e-mail notification. Parameters are:
* $1 is a thread name or title',
	'lqt-enotif-newthread' => "This is the text of an e-mail notification. Parameters are:
* $1 is the watching user's (= enotif recipient's) user name
* $2 is a thread name or title
* $3 is a date
* $4 is a time
* $5 is the title of a talk page with the thread $2
* $6 is a permalink URL
* $7 is a reply text
* $8 is the reply author's user name",
	'lqt-enotif-reply' => "This is the text of an e-mail notification. Parameters are:
* $1 is the watching user's (= enotif recipient's) user name
* $2 is a thread name or title
* $3 is a date
* $4 is a time
* $5 is the title of a talk page with the thread $2
* $6 is a permalink URL
* $7 is a reply text
* $8 is the reply author's user name",
	'lqt-quote-intro' => 'Used as a header in thread entries.
* $1 is a user name
* $2 is a date
* $3 is a time',
	'lqt-quote' => 'Verb or a noun?

{{Identical|Quote}}',
	'lqt-search-button' => '{{Identical|Search}}',
	'searchprofile-threads' => '{{Identical|Discussion}}',
	'lqt-ajax-update-link' => '{{Identical|Update}}',
	'lqt-thread-show-replies' => 'Parameters:
* $1 is the number of replies. This can be used for PLURAL:$1',
	'lqt-thread-link-url' => 'A form label, for the URL to a thread',
	'lqt-thread-link-title' => 'A form label, for the wikitext link to a thread',
	'lqt-save-subject' => '{{Identical|Save}}',
	'lqt-cancel-subject-edit' => '{{Identical|Cancel}}',
	'lqt-drag-reparent' => 'Description of the action of moving a thread underneath another, existing parent thread.
Displayed in a list of actions to confirm in a confirmation dialog.',
	'lqt-drag-save' => '{{Identical|Confirm}}',
	'lqt-drag-reason' => '{{Identical|Reason}}',
	'lqt-preview-signature' => '{{Identical|Preview}}',
	'lqt-feed-title-all-from' => 'Parameters:
* $1 is a comma separated list of all pages with new posts mentioned in the feed
* $2 is the number of referenced pages in the feed (optional - can be used for PLURAL)',
	'lqt-feed-title-new-threads-from' => 'Parameters:
* $1 is comma separated list of all pages with new threads mentioned in the feed
* $2 is the number of referenced pages in the feed (optional - can be used for PLURAL)',
	'lqt-feed-title-replies-from' => 'Parameters:
* $1 is comma separated list of all pages mentioned in the feed
* $2 is the number of referenced pages in the feed (optional, can be used for PLURAL)',
	'lqt-feed-new-thread-intro' => 'Parameters:
* $1 is a link to the talk page with the thread
* $2 is a link to the user posting in the thread
* $3 -not used-.',
	'lqt-feed-reply-intro' => 'Parameters:
* $1 is a link to the talk page with the thread
* $2 is a link to the user posting in the thread
* $3 is a link to the super thread',
	'lqt-newmessages-n' => '{{Identical|New messages}}

Link at the top of the page for logged-in users. $1 is the number of new messages.',
	'lqt_newmessages' => '{{Identical|New messages}}',
	'lqt_newmessages-title' => '{{Identical|New messages}}',
	'lqt-reply-summary' => 'Used on history page of message and thread. $2 is the message to which this message is a reply. $1 is the title of the thread.',
	'lqt-talkpage-history-subtitle' => 'Parameters:
* $1 is a link to a talk page, with the talk page title as link label',
	'lqt-talkpage-history-tab' => 'The text for the tab pointing to a discussion page header',
	'lqt-edit-bump' => 'See {{msg-mw|Lqt-edit-bump-tooltip}} for the explanation of this feature.',
	'lqt-reply-subpage' => 'Part of the page title when a LiquidThread answer is given. Should probably be translated as a noun and not as a verb.

{{Identical|Reply}}',
	'nstab-thread' => 'Used as tab title of the Thread namespace.',
	'nstab-summary' => 'Used as tab title for the Summary namespace.
{{Identical|Summary}}',
);

/** Faeag Rotuma (Faeag Rotuma)
 * @author Jose77
 */
$messages['rtm'] = array(
	'lqt_discussion_link' => 'hạifäega',
	'lqt_newmessages' => "Fäeag fo'ou",
);

/** Karelian (Karjala)
 * @author Flrn
 */
$messages['krl'] = array(
	'lqt_discussion_link' => 'keskustelu',
);

/** Niuean (ko e vagahau Niuē)
 * @author Jose77
 */
$messages['niu'] = array(
	'lqt_delete' => 'Tamate',
	'lqt_discussion_link' => 'fakatutala',
	'lqt_move_move' => 'Une',
	'lqt_newmessages' => 'Tau tohi foou',
);

/** Goanese Konkani (Latin) (कोंकणी/Konknni  (Latin))
 * @author Deepak D'Souza
 */
$messages['gom-latn'] = array(
	'lqt_delete_return' => '$1 ak patim vos',
	'lqt_newmessages' => 'Noveo sondes',
);

/** Abkhazian (Аҧсуа)
 * @author Temuri rajavi
 */
$messages['ab'] = array(
	'lqt_youhavenewmessages' => 'Уара [[$1|адырра ҿыцқәа]] уауит.',
	'lqt_newmessages' => 'Адырра ҿыцқәа',
);

/** Afrikaans (Afrikaans)
 * @author Arnobarnard
 * @author Naudefj
 */
$messages['af'] = array(
	'lqt-desc' => 'Voeg besprekings in onderwerpe op besprekingsblaaie by',
	'lqt_movethread' => "Skuif onderwerp na 'n ander bladsy",
	'lqt_deletethread' => 'Onderwerp verwyder of terugplaas',
	'lqt_contents_title' => 'Inhoud',
	'lqt_toc_thread_title' => 'Onderwerp',
	'lqt_toc_thread_author' => 'Begin deur',
	'lqt_toc_thread_replycount' => 'Antwoorde',
	'lqt_toc_thread_modified' => 'Laaste wysiging',
	'lqt_add_header' => 'Voeg opskrif by',
	'lqt_new_thread' => "Begin 'n nuwe onderwerp",
	'lqt_invalid_subject' => 'Die onderwerp wat u verskaf het is ongeldig. Dit kan:
* te lang wees, of
* bots met interwiki-voorvoegsels of naamruimtes se name.',
	'lqt_empty_subject' => "U moet 'n onderwerp verskaf.",
	'lqt_reply' => 'Antwoord',
	'lqt-parent' => 'Ouer',
	'lqt_delete' => 'Skrap',
	'lqt_undelete' => 'Terugplaas',
	'lqt_permalink' => 'Permanente skakel',
	'lqt_fragment' => "Fragment van 'n $1 vanaf $2",
	'lqt_discussion_link' => 'bespreking',
	'lqt_from_talk' => 'Vanaf $1',
	'lqt-history-title' => 'Onderwerp se geskiedenis',
	'lqt_hist_comment_edited' => 'Opmerking [$2 gewysig]',
	'lqt_hist_summary_changed' => 'Opsomming is verander',
	'lqt_hist_reply_created' => '[[$1|Nuwe antwoord]] geplaas',
	'lqt_hist_thread_created' => 'Nuwe onderwerp begin',
	'lqt_hist_deleted' => 'Geskrap',
	'lqt_hist_undeleted' => 'Teruggeplaas',
	'lqt_hist_moved_talkpage' => 'Geskuif',
	'lqt_hist_listing_subtitle' => 'Wys bespreking se geskiedenis',
	'lqt_hist_view_whole_thread' => 'Wys geskiedenis vir die hele onderwerp',
	'lqt_hist_no_revisions_error' => 'Die onderwerp het geen ouder weergawes nie.',
	'lqt_hist_past_last_page_error' => "U het 'n hoër bladsynommer gekies as wat in die geskiedenis bestaan.",
	'lqt_hist_tooltip_newer_disabled' => 'Hierdie skakel is nie aktief nie omdat u op die eerste bladsy is.',
	'lqt_hist_tooltip_older_disabled' => 'Hierdie skakel is nie aktief nie omdat u op die laaste bladsy is.',
	'lqt_hist_split' => "Antwoord na 'n nuwe onderwerp afsplits",
	'lqt_hist_edited_subject' => 'Onderwerp verander van "$2" na "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Veranderde onderwerp',
	'lqt_hist_merged_from' => "Die [[$1|antwoord]] is na 'n ander onderwerp geskuif",
	'lqt_hist_merged_to' => "Die [[$1|antwoord]] is vanuit 'n ander onderwerp geskuif",
	'lqt_hist_split_from' => "Split af na 'n nuwe onderwerp",
	'lqt_hist_root_blanked' => 'Teks van opmerking is verwyder',
	'lqt_hist_adjusted_sortkey' => 'Verander onderwerp se posisie',
	'lqt_revision_as_of' => 'Weergawe op $2 om $3.',
	'lqt_change_new_thread' => 'Hierdie is die eerste weergawe van die onderwerp.',
	'lqt_change_edited_summary' => 'Die onderwerp se opsomming is gewysig',
	'lqt_change_moved' => "[$1 Die onderwerp] is na 'n ander besprekinsblad geskuif",
	'lqt_change_edited_subject' => 'Die onderwerp is van "$2" na "$3" gewysig',
	'lqt_change_root_blanked' => "Die teks van 'n [$1 opmerking] is verwyder.",
	'lqt_youhavenewmessages' => 'U het [[$1|nuwe boodskappe]]',
	'lqt_protectedfromreply' => 'Die onderwerp is $1 en kan die beantwoord word nie.',
	'lqt_protectedfromreply_link' => 'beskermd',
	'lqt_subject' => 'Onderwerp:',
	'lqt_noreason' => 'Geen rede verskaf nie.',
	'lqt_thread_deleted_for_sysops' => "Die onderwerp is '''verwyder''' en kan slegs deur administrateurs gesien word.",
	'lqt_thread_deleted' => 'Hierdie onderwerp is verwyder.',
	'lqt_summary_notice_link' => "skryf 'n opsomming",
	'lqt_summary_label' => 'Opsomming van onderwerp:',
	'lqt_summary_subtitle' => 'Samevatting van "$1"',
	'lqt_nosuchthread' => 'Die onderwerp wat u verskaf het bestaan nie.',
	'lqt_nosuchthread_title' => 'Die onderwerp bestaan nie',
	'lqt_move_movingthread' => 'Besig om $1 te skuif.
Die onderwerp is deel van $2.',
	'lqt_move_torename' => "Om die onderwerp te skuif, $1 en verander die 'Onderwerp'-veld.",
	'lqt_move_torename_edit' => 'wysig dit',
	'lqt_move_destinationtitle' => 'Na besprekingsblad:',
	'lqt_move_move' => 'Skuif',
	'lqt_move_nodestination' => "U moet 'n bestemming verskaf.",
	'lqt_move_samedestination' => 'Die onderwerp is al reeds op hierdie bladsy!',
	'lqt_move_noreason' => 'Geen rede verskaf nie.',
	'lqt_move_success' => 'Die onderwerp is na $1 geskuif.',
	'lqt_delete_undeletethread' => 'Onderwerp terugplaas',
	'lqt_delete_partof' => "Die onderwerp is deel van '''$1'''.",
	'lqt_delete_deleting' => "Besig met die verwydering van '''$1''' en '''alle antwoorde''' daarop.",
	'lqt_delete_deletethread' => 'Skrap onderwerp',
	'lqt_delete_deleted' => 'Die onderwerp is geskrap.',
	'lqt_delete_undeleted' => 'Die onderwerp is teruggeplaas.',
	'lqt_delete_return' => 'Keer terug na $1.',
	'lqt_delete_return_link' => 'die besprekingsblad',
	'lqt_delete_unallowed' => 'U mag nie onderwerpe verwyder nie.',
	'lqt_delete_show_checkbox' => 'Wys geskrapte onderwerpe',
	'lqt_header_warning_big' => "U is besig om 'n $1 te wysig.",
	'lqt_header_warning_bold' => "inleiding van 'n besprekingsblad",
	'lqt_header_warning_new_discussion' => "begin 'n nuwe bespreking",
	'lqt_sorting_order' => 'Sorteervolgorde:',
	'lqt_sort_newest_changes' => 'laaste gewysig bo',
	'lqt_sort_newest_threads' => 'nuutste onderwerpe bo',
	'lqt_sort_oldest_threads' => 'oudste onderwerpe bo',
	'lqt-title' => 'Naam',
	'lqt-summary' => 'Samevatting',
	'lqt-searching' => 'Besig om te soek na onderwerpe…',
	'lqt-read-message' => 'Merk as gelees',
	'lqt-read-all' => 'Merk alles as gelees',
	'lqt-marked-read' => "Onderwerp '''$1''' is as gelees gemerk.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|boodskap|boodskappe}} is as gelees gemerk.',
	'lqt-email-undo' => 'Maak ongedaan',
	'lqt-no-new-messages' => 'U het geen nuwe boodskappe nie.',
	'lqt-new-messages' => '✒ U het nuwe boodskappe.',
	'lqt-email-info-undo' => 'Terug na die onderwerp dat u sopas verlaat het.',
	'lqt-date-info' => 'Hierdie skakel is nie aktief nie omdat u onderwerpe van alle datums bekyk.',
	'lqt-newmessages-context' => 'Volledige onderwerp',
	'lqt-thread-created' => 'Geskep',
	'lqt-history-time' => 'Tyd',
	'lqt-history-user' => 'Gebruiker',
	'lqt-history-action' => 'Aktiwiteit',
	'lqt-history-comment' => 'Opmerking',
	'lqt-history-thread' => 'Onderwerp',
	'lqt-thread-edited-author' => 'Gewysig deur outeur<br />
Laaste wysiging $1',
	'lqt-thread-edited-others' => "Deur {{PLURAL:$2|'n ander gebruiker|$2 ander gebruikers}} gewysig.<br />
Laaste wysiging: $1",
	'lqt-header-actions' => 'Aksies',
	'lqt_summarize_link' => 'Som op',
	'lqt-thread-split' => "Split af na 'n  nuwe onderwerp",
	'lqt-split-success' => 'U het die onderwerp "$1" suksesvol afgesplit.',
	'lqt_split_thread' => "Split 'n onderwerp",
	'lqt-thread-split-subject' => 'Opskrif van nuwe onderwerp:',
	'lqt-thread-split-thread' => 'Bespreking:',
	'lqt-split-submit' => 'Split',
	'lqt_split_badsubject' => 'Die onderwerp wat u verskaf het is ongeldig.',
	'lqt-no-threads' => 'Daar is nog geen onderwerpe op hierdie bladsy nie.',
	'lqt-delete-parent-deleted' => 'Boliggende bespreking is geskrap ($1)',
	'lqt-delete-replies-done' => 'Al die antwoorde op hierdie draad is ook verwyder.',
	'lqt-movethread' => 'Skuif',
	'lqt-menu-trigger' => 'Meer',
	'lqt-newmessages-from' => 'Van $1',
	'lqt-hot-topics' => 'Populêre onderwerpe',
	'lqt-add-reply' => 'Antwoord',
	'lqt_rc_new_discussion' => 'het \'n nuwe onderwerp "$1" begin',
	'lqt_rc_new_reply' => 'het "$1" geantwoord',
	'right-lqt-split' => 'Split onderwerpe',
	'right-lqt-merge' => 'Versmelt onderwerpe',
	'lqt-thread-merge' => 'Versmelt met ander onderwerp',
	'lqt-thread-merge-to' => 'Met die onderwerp versmelt',
	'lqt_merge_thread' => 'Versmelt onderwerp',
	'lqt-thread-merge-source' => 'Brononderwerp:',
	'lqt-thread-merge-dest' => 'Doelonderwerp:',
	'lqt-merge-submit' => 'Versmelt',
	'lqt-log-name' => 'Onderwerplogboek',
	'lqt-log-action-move' => 'het [[$1]] geskuif van [[$2]] na [[$3]].',
	'lqt-log-action-split' => 'het [[$1]] afgesplit van [[$3]] met nuwe onderwerp "$2".',
	'lqt-log-action-merge-across' => 'is van [[$1]] uit [[$2]] na [[$3]] geskuif.',
	'lqt-log-action-merge-down' => 'het [[$1]] na onder [[$3]] versmelt',
	'lqt-log-action-subjectedit' => 'het die onderwerp vir [[$1]] van "$2" na "$3" verander',
	'lqt-preference-notify-talk' => 'Stuur vir my e-pos as besprekings wat ek dophou beantwoord word',
	'lqt-preference-watch-threads' => 'Hou besprekings wat ek begin of waaraan ek deelneem dop',
	'prefs-lqt' => 'Gestruktureerde besprekings',
	'lqt-preference-display-depth' => 'Maksimum diepte om te wys:',
	'lqt-preference-display-count' => 'Maksimum aantal antwoorde om te wys:',
	'lqt-preference-custom-signatures' => 'Wys gebruikers se persoonlike handtekeninge',
	'lqt-enotif-subject-reply' => 'Bespreking op {{SITENAME}} - Antwoord: $1',
	'lqt-enotif-subject-newthread' => 'Bespreking op {{SITENAME}} - Nuwe gesprek: $1',
	'lqt-enotif-newthread' => "Hallo $1,

Hierdie is 'n kennisgewing vanaf {{SITENAME}}. Daar is 'n nuwe onderwerp '$2' op $5 geplaas op $3 om $4 deur $8.

U kan dit sien by <$6>.

Die teks is:
$7",
	'lqt-enotif-reply' => "Hallo $1,

Hierdie is 'n kennisgewing vanaf {{SITENAME}}. Daar is 'n nuwe antwoord '$2' op $5
wat op $3 om $4 deur $8 geplaas is.

U kan dit sien by <$6>.

Die teks van die antwoord is:
$7",
	'lqt-quote-intro' => 'Op $2 om $3 skryf [[User:$1|$1]]:',
	'lqt-quote' => 'Aanhaal',
	'lqt-search-legend' => 'Deursoek besprekings op hierdie bladsy',
	'lqt-search-label' => 'Soekterme:',
	'lqt-search-button' => 'Soek',
	'searchprofile-threads' => 'Besprekings',
	'lqt-ajax-updated' => 'Die onderwerp het nuwe antwoorde.',
	'lqt-ajax-update-link' => 'Bywerk',
	'lqt-thread-show-replies' => 'Wys $1 {{PLURAL:$1|antwoord|antwoorde}}',
	'lqt-thread-show-more' => 'Wys meer antworde',
	'lqt-thread-link-url' => 'URL-skakel:',
	'lqt-thread-link-title' => 'Wikiteks-skakel:',
	'lqt-thread-link-copy' => 'Kopieer na klipbord',
	'lqt-marked-as-read-placeholder' => 'Onderwerp $1 is as gelees gemerk.',
	'lqt-change-subject' => 'Wysig onderwerp',
	'lqt-save-subject' => 'Stoor',
	'lqt-ajax-no-subject' => "U moet 'n onderwerp verskaf.",
	'lqt-cancel-subject-edit' => 'Kanselleer',
	'lqt-drag-activate' => 'Sleep na nuwe posisie',
	'lqt-drag-drop-zone' => 'Plaas hier',
	'lqt-drag-split' => 'Skuif na sy eie draad',
	'lqt-drag-setsortkey' => 'Skuif boodskap na ander posisie op die bladsy',
	'lqt-drag-bump' => 'Skuif boodskap tot bo aan besprekingsblad',
	'lqt-drag-save' => 'Bevestig',
	'lqt-drag-title' => 'Bevestig sleep',
	'lqt-drag-reason' => 'Rede:',
	'lqt-drag-subject' => 'Onderwerp:',
	'lqt-edit-signature' => '(wysig handtekening)',
	'lqt-preview-signature' => '(voorskou)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nuwe boodskappe',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nuwe boodskappe vanaf $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nuwe onderwerpe',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nuwe onderwerppe van $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Antwoorde',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Antwoorde van $1',
	'lqt-feed-new-thread-intro' => 'Nuwe onderwerp deur $2 op $1',
	'lqt-feed-reply-intro' => 'Antwoord op $3 (op $1) deur $2',
	'lqt-newmessages-n' => 'Nuwe boodskappe ($1)',
	'lqt_newmessages' => 'My nuwe boodskappe (Geen)',
	'lqt_newmessages-title' => 'Nuwe boodskappe',
	'lqt-newpost-summary' => 'Nuwe onderwerp: $1',
	'lqt-reply-summary' => 'Reaksie op [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Geskiedenis van die besprekingsblad',
	'lqt-talkpage-history-subtitle' => 'Vir $1',
	'lqt-talkpage-history-tab' => 'Opskrif',
	'restriction-reply' => 'Antwoorde',
	'restriction-newthread' => 'Skep nuwe onderwerpe',
	'lqt-protected-reply-thread' => 'U kan nie pos nie omdat die onderwerp sluit is.',
	'lqt-edit-bump' => 'Aktiveer die bespreking',
	'lqt-edit-bump-tooltip' => 'Skuif die onderwerp tot bo aan die besprekingsblad',
	'lqt-reply-subpage' => 'antwoord',
	'nstab-thread' => 'Onderwerp',
	'nstab-summary' => 'Samevatting',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'lqt-history-title' => 'histori Thread',
	'lqt_hist_comment_edited' => 'text Komenti [$2] redaktuar',
	'lqt_hist_summary_changed' => 'Përmbledhje ndryshuar',
	'lqt_hist_reply_created' => '[[$1|përgjigje të reja]] krijuar',
	'lqt_hist_thread_created' => 'fije e re e krijuar',
	'lqt_hist_deleted' => 'Deleted',
	'lqt_hist_undeleted' => 'Undeleted',
	'lqt_hist_moved_talkpage' => 'Moved',
	'lqt_hist_listing_subtitle' => 'Duke parë një listë të histori',
	'lqt_hist_view_whole_thread' => 'Shihni historik për gjithë thread',
	'lqt_hist_no_revisions_error' => 'Ky thread nuk ka ndonjë histori shqyrtime.',
	'lqt_hist_past_last_page_error' => 'Ju jeni përtej numrit të faqeve të historisë që ekzistojnë.',
	'lqt_hist_tooltip_newer_disabled' => 'Kjo lidhje është me aftësi të kufizuara për shkak se ju jeni në faqen e parë.',
	'lqt_hist_tooltip_older_disabled' => 'Kjo lidhje është me aftësi të kufizuara për shkak se ju jeni në faqen e fundit.',
	'lqt_hist_split' => 'Përgjigju ndarë në një fije të re',
	'lqt_hist_edited_subject' => 'subjekt Changed nga "$2" tek "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Changed subjekt',
	'lqt_hist_merged_from' => '[[$1|Përgjigjuni]] u zhvendos në një tjetër fije',
	'lqt_hist_merged_to' => '[[$1|Përgjigjuni]] u zhvendos nga një tjetër fije',
	'lqt_hist_split_from' => 'Split të një fije të re',
	'lqt_hist_root_blanked' => 'tekstit Removed koment',
	'lqt_hist_adjusted_sortkey' => 'pozicion axhustuara thread',
	'lqt_revision_as_of' => 'Versioni i $2 në $3.',
	'lqt_change_new_thread' => "Kjo është rishikim fillestar thread's.",
	'lqt_change_reply_created' => '[$1 theksuar koment ishte krijuar në këtë version.]',
	'lqt_change_edited_root' => '[$1 theksuar koment është redaktuar në këtë version.]',
	'lqt_change_edited_summary' => 'përmbledhje thread ishte redaktuar',
	'lqt_change_deleted' => '[$1 Ky] thread ose prindërit e tij u fshi',
	'lqt_change_undeleted' => '[$1 theksuar post u undeleted]',
	'lqt_change_moved' => '[$1 Ky] thread u zhvendos në një tjetër faqe diskutimi',
	'lqt_change_split' => '[$1 Ky] thread ishte ndarë nga një tjetër fije',
	'lqt_change_edited_subject' => 'Subjekt i këtij thread është ndryshuar nga "$2" tek "$3"',
	'lqt_change_merged_from' => 'Një përgjigje [$1] të this thread u zhvendos në një tjetër fije',
	'lqt_change_merged_to' => '[$1 u zhvendos në pah përgjigje nga një tjetër fije]',
	'lqt_change_split_from' => 'A [$1 subthread] të this thread u nda në fije e vet',
	'lqt_change_root_blanked' => 'Teksti i [$1 koment], u hoq.',
	'lqt_youhavenewmessages' => 'Ju keni [[$1|Mesazhet e reja]].',
	'lqt_protectedfromreply' => 'Kjo thread ka qenë i $1 nga u përgjigjur për të.',
	'lqt_protectedfromreply_link' => 'mbrojtur',
	'lqt_subject' => 'Subject:',
	'lqt_noreason' => 'Nuk ka arsye të dhënë.',
	'lqt_move_placeholder' => 'Kjo fije është një placeholder duke treguar se një fije, 1 $, u zhvendos nga kjo faqe. Kjo masë është bërë nga $2 në $3 më $4. Fije tani është e vendosur në 5 $.',
	'lqt_thread_deleted_for_sysops' => "Kjo thread ka qenë'''''fshihen' dhe është e dukshme vetem per administratorin.",
	'lqt_thread_deleted' => 'Kjo thread është grisur.',
	'lqt_summary_notice' => 'Nuk ka pasur ndryshime në këtë diskutim, të paktën për $2 {{PLURAL:$2|ditë|ditëve}}. Qoftë se kjo është e përfunduar, ju mund të dëshironi të $1.',
	'lqt_summary_notice_link' => 'shkruaj një përmbledhje të',
	'lqt_summary_label' => 'përmbledhje Thread:',
	'lqt_summary_subtitle' => 'Përmbledhje e "$1"',
	'lqt_nosuchrevision' => 'Nuk ka asnjë rishikim të tillë të this thread.',
	'lqt_newmessages' => 'Mesazhe të reja',
	'lqt_newmessages-title' => 'Mesazhe të reja',
	'lqt-newpost-summary' => 'fije e re: $1',
	'lqt-reply-summary' => 'Përgjigju [[$2 | $1]]',
	'lqt-talkpage-history-title' => 'histori Diskutim faqe',
	'lqt-talkpage-history-subtitle' => 'Për $1',
	'lqt-talkpage-history-tab' => 'Header',
	'restriction-reply' => 'Postoni përgjigje',
	'restriction-newthread' => 'temat temë të re',
	'lqt-protected-reply-thread' => 'Ju nuk mund të postoni në këtë thread sepse ajo ka qenë mbrojtur nga postet e reja.',
	'lqt-protected-reply-talkpage' => 'Ju nuk mund të postoni në këtë thread sepse kjo faqe diskutimi ka qenë i mbrojtur nga përgjigjet në temat e saj.',
	'lqt-protected-newthread' => 'Ju nuk mund të postoni tema të reja në këtë faqe diskutimi për shkak se ajo ka qenë e mbrojtur nga tema të reja.',
	'lqt-edit-bump' => 'Përplasem this thread',
	'lqt-edit-bump-tooltip' => 'Move this thread në krye të faqes e diskutimit',
	'lqt-historicalrevision-error' => 'Rishikim të keni zgjedhur është e korruptuar, dhe nuk mund të shikohet.',
	'lqt-reply-subpage' => 'përgjigje',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'lqt_subject' => 'ርዕሰ ጉዳይ:',
	'lqt_noreason' => 'ምንም ምክንያት አልተሰጠም።',
	'lqt_move_noreason' => 'ምንም ምክንያት አልተሰጠም።',
	'lqt-title' => 'አርዕስት',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'lqt_delete' => 'Borrar',
	'lqt_discussion_link' => 'discusión',
	'lqt_move_torename_edit' => 'editar-lo',
	'lqt-email-undo' => 'Desfer',
	'lqt-header-actions' => 'Accions',
	'searchprofile-threads' => 'Discusions',
	'lqt-cancel-subject-edit' => 'Cancelar',
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 * @author Ouda
 */
$messages['ar'] = array(
	'lqt-desc' => 'يضيف نقاشات في مجموعات إلى صفحات النقاش',
	'lqt_movethread' => 'انقل النقاش إلى صفحة أخرى',
	'lqt_deletethread' => 'احذف أو استرجع النقاش',
	'lqt_contents_title' => 'المحتويات',
	'lqt_toc_thread_title' => 'عنوان النقاش',
	'lqt_toc_thread_author' => 'بدأه',
	'lqt_toc_thread_replycount' => 'الردود',
	'lqt_toc_thread_modified' => 'آخر تعديل',
	'lqt_add_header' => 'أضف عنوانا',
	'lqt_new_thread' => 'ابدأ نقاشا جديدا',
	'lqt_invalid_subject' => 'الموضوع الذي أدخلته غير صحيح.
ربما:
* يكون طويلا جدا، أو
* يتعارض مع بادئات الإنترويكي أو أسماء النطاقات.',
	'lqt_empty_subject' => 'يجب أن تدخل موضوعًا.',
	'lqt_reply' => 'رُد',
	'lqt-parent' => 'والد',
	'lqt_delete' => 'احذف',
	'lqt_undelete' => 'استرجع',
	'lqt_permalink' => 'صِل إليه',
	'lqt_fragment' => 'جزء $1 من $2',
	'lqt_discussion_link' => 'نقاش',
	'lqt_from_talk' => 'من $1',
	'lqt-history-title' => 'تاريخ النقاش',
	'lqt_hist_comment_edited' => '[$2 عدّل] نص التعليق',
	'lqt_hist_summary_changed' => 'غُيّر الملخص',
	'lqt_hist_reply_created' => 'أنشأ [[$1|ردا جديدا]]',
	'lqt_hist_thread_created' => 'أنشأ نقاشًا جديدًا',
	'lqt_hist_deleted' => 'محذوف',
	'lqt_hist_undeleted' => 'مسترجع',
	'lqt_hist_moved_talkpage' => 'منقول',
	'lqt_hist_listing_subtitle' => 'عرض قائمة تاريخ',
	'lqt_hist_view_whole_thread' => 'عرض تاريخ النقاش كاملًا',
	'lqt_hist_no_revisions_error' => 'ليس لهذا النقاش أي مراجعات في التاريخ.',
	'lqt_hist_past_last_page_error' => 'أنت تجاوزت عدد صفحات التاريخ الموجودة.',
	'lqt_hist_tooltip_newer_disabled' => 'هذه الوصلة معطلة لأنك على الصفحة الأولى.',
	'lqt_hist_tooltip_older_disabled' => 'هذه الوصلة معطلة لأنك على الصفحة الأخيرة.',
	'lqt_hist_split' => 'الرد فصل إلى خيط جديد',
	'lqt_hist_edited_subject' => 'غيّر الموضوع من "$2" إلى "$3"',
	'lqt_hist_edited_subject_corrupt' => 'غير الموضوع',
	'lqt_hist_merged_from' => 'نقل [[$1|الرد]] إلى نقاش آخر',
	'lqt_hist_merged_to' => 'نقل [[$1|الرد]] من نقاش آخر',
	'lqt_hist_split_from' => 'افصل إلى نقاش جديد',
	'lqt_hist_root_blanked' => 'نص تعليق مُزال',
	'lqt_hist_adjusted_sortkey' => 'عدل موضع الخيط',
	'lqt_revision_as_of' => 'المراجعة بتاريخ $2 الساعة $3.',
	'lqt_change_new_thread' => 'هذه هي المراجعة الابتدائية للنقاش.',
	'lqt_change_reply_created' => 'أُنشئ [$1 التعليق المظلل] في هذه المراجعة.',
	'lqt_change_edited_root' => 'عُدل [$1 التعليق المظلل] في هذه المراجعة.',
	'lqt_change_edited_summary' => 'عُدّل ملخص النقاش',
	'lqt_change_deleted' => '[$1 هذا الخيط] أو أبوه تم حذفه',
	'lqt_change_undeleted' => '[$1 الرسالة المعلمة] تم استرجاعها',
	'lqt_change_moved' => '[$1 هذا الخيط] تم نقله إلى صفحة نقاش أخرى',
	'lqt_change_split' => '[$1 هذا الخيط] تم فصله من خيط آخر',
	'lqt_change_edited_subject' => 'موضوع هذا الخيط تم تغييره من "$2" إلى "$3"',
	'lqt_change_merged_from' => '[$1 رد] لهذا الخيط تم نقله لخيط آخر',
	'lqt_change_merged_to' => '[$1 الرد المعلم] تم نقله من خيط آخر',
	'lqt_change_split_from' => '[$1 خيط فرعي] لهذا الخيط تم فصله إلى خيطه الخاص',
	'lqt_change_root_blanked' => 'نص [$1 تعليق] تمت إزالته.',
	'lqt_youhavenewmessages' => 'لديك [[$1|رسائل جديدة]].',
	'lqt_protectedfromreply' => 'تمت $1 النقاش من الرد عليه.',
	'lqt_protectedfromreply_link' => 'حماية',
	'lqt_subject' => 'موضوع:',
	'lqt_noreason' => 'لا سبب معطى.',
	'lqt_move_placeholder' => 'هذا النقاش لحجز المكان ويعني أن النقاش $1 نُقل من هذه الصفحة.
قام بالنقل $2 في $3 $4. النقاش موجود حاليا في $5.',
	'lqt_thread_deleted_for_sysops' => "تم '''حذف''' هذا النقاش وهو مرئية فقط للإداريين.",
	'lqt_thread_deleted' => 'تم حذف هذا النقاش.',
	'lqt_summary_notice' => 'لا توجد تغييرات لهذا النقاش لفترة $2 {{PLURAL:$2|يوم|يوم}}. على الأقل.
لو كان النقاش قد انتهى، فربما ترغب في $1.',
	'lqt_summary_notice_link' => 'اكتب ملخصا',
	'lqt_summary_label' => 'ملخص النقاش:',
	'lqt_summary_subtitle' => 'ملخص "$1"',
	'lqt_nosuchrevision' => 'لا توجد مراجعة كهذه لهذا النقاش.',
	'lqt_nosuchthread' => 'لا يوجد موضوع كهذا الذي حدّدت.',
	'lqt_nosuchthread_title' => 'لا نقاش كهذا',
	'lqt_threadrequired' => 'يجب عليك تحديد نقاش في المسار.',
	'lqt_move_movingthread' => 'نقل $1.
هذا النقاش جزء من $2.',
	'lqt_move_torename' => "لإعادة تسمية هذا النقاش، $1 وغيّر حقل 'الموضوع'.",
	'lqt_move_torename_edit' => 'عدله',
	'lqt_move_destinationtitle' => 'عنوان صفحة النقاش الهدف:',
	'lqt_move_move' => 'انقل',
	'lqt_move_nodestination' => 'يجب عليك تحديد وجهة.',
	'lqt_move_thread_bad_destination' => 'الصفحة الهدف ليست صفحة نقاش.',
	'lqt_move_samedestination' => 'الموضوع أصلًا على هذه الصفحة!',
	'lqt_move_noreason' => 'لا سبب معطى.',
	'lqt_move_success' => 'تم نقل النقاش إلى $1.',
	'lqt_delete_undeletethread' => 'استرجع النقاش',
	'lqt_delete_partof' => "هذا النقاش جزء من '''$1'''.",
	'lqt_delete_deleting' => "حذف '''$1''' و '''كل الردود''' له.",
	'lqt_delete_deletethread' => 'احذف النقاش والردود',
	'lqt_delete_deleted' => 'تم حذف النقاش.',
	'lqt_delete_undeleted' => 'تم استرجاع النقاش.',
	'lqt_delete_return' => 'ارجع إلى $1.',
	'lqt_delete_return_link' => 'صفحة النقاش',
	'lqt_delete_unallowed' => 'أنت غير مسموح لك بحذف مجموعات الرسائل.',
	'lqt_delete_show_checkbox' => 'اعرض مجموعات الرسائل المحذوفة',
	'lqt_talkpage_autocreate_summary' => 'صفحة النقاش تم إنشاؤها تلقائيا عندما تم إرسال أول نقاش.',
	'lqt_header_warning_big' => 'أنت تعدل $1.',
	'lqt_header_warning_after_big' => 'العناوين للإعلانات والمقدمات.
ربما ترغب كبديل في $2.',
	'lqt_header_warning_bold' => 'عنوان صفحة نقاش',
	'lqt_header_warning_new_discussion' => 'بدء نقاش جديد',
	'lqt_sorting_order' => 'طريقة الترتيب:',
	'lqt_sort_newest_changes' => 'المعدل أخيرا أولا',
	'lqt_sort_newest_threads' => 'النقاشات الأجدد أولا',
	'lqt_sort_oldest_threads' => 'النقاشات الأقدم أولا',
	'lqt-title' => 'العنوان',
	'lqt-summary' => 'ملخص',
	'lqt-searching' => 'بحث عن مجموعات الرسائل',
	'lqt-read-message' => 'علّم مقروءة',
	'lqt-read-message-tooltip' => 'أزل هذا النقاش من الرسائل الجديدة.
ستظل مرئية على صفحة نقاشها الأصلية.',
	'lqt-read-all' => 'علّم الكل مقروءًا',
	'lqt-read-all-tooltip' => 'إزالة كل مجموعات الرسائل من الرسائل الجديدة.
ستظل مرئية على صفحات نقاشها الأصلية.
هذه العملية لا يمكن الرجوع عنها.',
	'lqt-marked-read' => "تم تعليم النقاش '''$1''' مقروءًا.",
	'lqt-count-marked-read' => 'تم تعليم {{PLURAL:$1||رسالة واحدة مقروءة|رسالتين مقروأتين|$1 رسائل مقروءة|$1 رسالة مقروءة}}.',
	'lqt-email-undo' => 'تراجَع',
	'lqt-no-new-messages' => 'لا توجد رسائل جديدة لك.',
	'lqt-new-messages' => '✒ توجد رسائل جديدة لك.',
	'lqt-email-info-undo' => 'أعد النقاش التي صرفته منذ قليل.',
	'lqt-date-info' => 'هذه الوصلة معطلة لأنك ترى مجموعات الرسائل من كل التواريخ.',
	'lqt-newmessages-context' => 'موضوع كامل',
	'lqt-thread-created' => 'تم إنشاؤه',
	'lqt-history-time' => 'الوقت',
	'lqt-history-user' => 'المستخدم',
	'lqt-history-action' => 'النشاط',
	'lqt-history-comment' => 'تعليق',
	'lqt-history-thread' => 'نقاش',
	'lqt-thread-edited-author' => 'عدّلها المؤلف.<br />
كان آخر تعديل في: $1',
	'lqt-thread-edited-others' => 'عدّلها {{PLURAL:$2||مستخدم آخر|مستخدمان آخران|$2 مستخدمين آخرين|$2 مستخدمًا آخرًا|$2 مستخدم آخر}}.<br />
كان آخر تعديل في: $1',
	'lqt-header-actions' => 'الإجراءات',
	'lqt_summarize_link' => 'الملخص',
	'lqt-summarize-intro' => 'من فضلك لخّص الموضوع أدناه في صندوق التحرير.
تستطيع استخدام أي نص ويكي في ملخّصك. انقر "{{int:savearticle}}" عندما تنتهي.',
	'lqt-thread-split' => 'افصل إلى موضوع جديد',
	'lqt-split-success' => 'لقد فصلت بنجاح الموضوع $1.',
	'lqt_split_thread' => 'فصل موضوع',
	'lqt-thread-split-subject' => 'عنوان الموضوع الجديد:',
	'lqt-thread-split-thread' => 'الموضوع:',
	'lqt-split-submit' => 'افصل',
	'lqt_split_badsubject' => 'العنوان الذي أدخلته غير صحيح.',
	'lqt-no-threads' => 'لا توجد أي مواضيع في هذه الصفحة إلى الآن.',
	'lqt-delete-parent-warning' => 'هذا خيط عالي المستوى بردود.
رددوده سيتم أيضا حذفها تلقائيا.
لتجنب هذا، افصلهم من هذا الخيط قبل حذفه.',
	'lqt-delete-parent-deleted' => 'الخيط الأب تم حذفه ($1)',
	'lqt-delete-replies-done' => 'تم حذف جميع الردود على هذا الموضوع أيضًا.',
	'lqt-movethread' => 'انقل',
	'lqt-menu-trigger' => 'مزيد',
	'lqt-newmessages-from' => 'من $1',
	'lqt-hot-topics' => 'مواضيع ساخنة',
	'lqt-add-reply' => 'أضف ردا',
	'lqt_rc_new_discussion' => 'أرسل نقاشًا جديدًا، "$1"',
	'lqt_rc_new_reply' => 'أرسل ردًا على "$1"',
	'right-lqt-split' => 'فصل الخيوط',
	'right-lqt-merge' => 'دمج الخيوط',
	'lqt-thread-merge' => 'ادمج مع نقاش آخر',
	'lqt-thread-merge-to' => 'ادمج مع هذا النقاش',
	'lqt_merge_thread' => 'ادمج النقاش',
	'lqt-thread-merge-source' => 'الموضوع المصدر:',
	'lqt-thread-merge-dest' => 'الموضوع الهدف:',
	'lqt-merge-submit' => 'دمج',
	'lqt-merge-success' => 'أنت دمجت بنجاح الخيط $1 إلى تحت $2.',
	'lqt-log-name' => 'سجل النقاش ذي الموضوعات',
	'lqt-log-header' => 'يعرض هذا السجل إجراءات تم اتخاذها في مواضيع النقاش.',
	'lqt-log-action-move' => 'نقل [[$1]] من [[$2]] إلى [[$3]].',
	'lqt-log-action-split' => 'فصل [[$1]] من [[$3]]، بالعنوان الجديد "$2"',
	'lqt-log-action-merge-across' => 'نقل [[$1]] من تحت [[$2]] إلى تحت [[$3]]',
	'lqt-log-action-merge-down' => 'دمج [[$1]] تحت [[$3]]',
	'lqt-log-action-subjectedit' => 'غيّر عنوان [[$1]] من "$2" إلى "$3"',
	'lqt-log-action-resort' => 'غيّر ترتيب [[$1]]. غيّر مفتاح الترتيب من $2 إلى $3',
	'lqt-preference-notify-talk' => 'أرسل لي رسالة بريد إلكتروني عن الردود التي تضاف إلى موضوع أراقبه',
	'lqt-preference-watch-threads' => 'راقب النقاشات التي أنشئها أو أرد عليها',
	'prefs-lqt' => 'نقاشات مُجمّعة',
	'lqt-preference-display-depth' => 'عمق الردود الأقصى للعرض:',
	'lqt-preference-display-count' => 'عدد الردود الأقصى للعرض:',
	'lqt-preference-custom-signatures' => 'أظهر توقيعات المستخدمين المُخصّصة',
	'lqt-enotif-subject-reply' => 'نقاش {{SITENAME}} - رد: $1',
	'lqt-enotif-subject-newthread' => 'نقاش {{SITENAME}} - موضوع جديد: $1',
	'lqt-enotif-newthread' => "مرحبًا $1.

هذا إخطار من {{SITENAME}} بأن موضوعًا جديدًا في $5 ('$2')
قد أنشئ في يوم $3 عند $4.

بإمكانك مراجعته عبر <$6>",
	'lqt-enotif-reply' => "مرحبًا $1.

هذا إخطار من {{SITENAME}} بأن ردًا جديدًا على '$2' في $5
قد وُضع في يوم $3 عند $4.

بإمكانك مراجعته عبر <$6>",
	'lqt-quote-intro' => 'في $2 عند $3، كتب [[User:$1|$1]]:',
	'lqt-quote' => 'اقتبس',
	'lqt-search-legend' => 'ابحث في نقاشات هذه الصفحة',
	'lqt-search-label' => 'عبارة البحث:',
	'lqt-search-button' => 'ابحث',
	'searchprofile-threads' => 'نقاشات',
	'searchprofile-threads-tooltip' => 'ابحث في النقاشات وصفحات النقاش ذات الخيوط',
	'lqt-ajax-updated' => 'يحوي هذا النقاش مرسلات جديدة.',
	'lqt-ajax-update-link' => 'حدّث',
	'lqt-thread-show-replies' => 'أظهر {{PLURAL:$1||ردًا واحدًا|ردّين|$1 ردود|$1 ردًا|$1 رد}}',
	'lqt-thread-show-more' => 'أظهر مزيدًا من الردود',
	'lqt-thread-link-url' => 'مسار الوصلة:',
	'lqt-thread-link-title' => 'وصلة ويكي:',
	'lqt-thread-link-copy' => 'انسخ إلى الحافظة',
	'lqt-sign-not-necessary' => 'من غير الضروري التوقيع على تعليقك باستخدام أربع مدات.
التوقيع يتم عرضه أوتوماتيكيا.',
	'lqt-marked-as-read-placeholder' => 'عُلّم النقاش $1 مقروءًا.',
	'lqt-change-subject' => 'غير الموضوع',
	'lqt-save-subject' => 'احفظ',
	'lqt-save-subject-failed' => 'الخطأ التالي حدث أثناء محاولة تغيير موضوع هذا الخيط: $1',
	'lqt-ajax-invalid-subject' => 'الموضوع الذي حددته كان غير صحيح، على الأرجح لأنه كان طويلا جدا.',
	'lqt-ajax-no-subject' => 'يجب أن تحدد موضوعا.',
	'lqt-save-subject-error-unknown' => 'خطأ غير معروف حدث أثناء محاولة ضبط موضوع هذا الخيط. من فضلك حاول فعل هذا بواسطة الضغط على "عدل" على التعليق الاعلى.',
	'lqt-cancel-subject-edit' => 'ألغِ',
	'lqt-drag-activate' => 'اسحب إلى الموقع الجديد',
	'lqt-drag-drop-zone' => 'أسقط هنا',
	'lqt-drag-confirm' => 'لإكمال الأفعال التالية، من فضلك املأ السبب واضغط "أكد".',
	'lqt-drag-reparent' => 'انقل الرسالة تحت أب جديد.',
	'lqt-drag-split' => 'انقل الرسالة إلى خيطها الخاص',
	'lqt-drag-setsortkey' => 'عدل موضع الرسالة في الصفحة',
	'lqt-drag-bump' => 'انقل الرسالة أعلى صفحة النقاش',
	'lqt-drag-save' => 'تأكيد',
	'lqt-drag-reason' => 'السبب:',
	'lqt-drag-subject' => 'العنوان للخيط الجديد:',
	'lqt-edit-signature' => '(عدل التوقيع)',
	'lqt-preview-signature' => '(معاينة)',
	'lqt-feed-title-all' => '{{SITENAME}} — مرسلات جديدة',
	'lqt-feed-title-all-from' => '{{SITENAME}} — رسائل جديدة من $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — نقاشات جديدة',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — {{PLURAL:$2||نقاش جديد|نقاشان جديدان|نقاشات جديدة}} من $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — ردود',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — ردود من $1',
	'lqt-newmessages-n' => 'الرسائل الجديدة ($1)',
	'lqt_newmessages' => 'رسائلي الجديدة (لا شيء)',
	'lqt_newmessages-title' => 'رسائل جديدة',
	'lqt-newpost-summary' => 'نقاش جديد: $1',
	'lqt-reply-summary' => 'رد على [[$2|$1]]',
	'lqt-talkpage-history-title' => 'تاريخ صفحة النقاش',
	'lqt-talkpage-history-subtitle' => 'ل$1',
	'lqt-talkpage-history-tab' => 'عنوان',
	'restriction-reply' => 'أرسل ردودًا',
	'restriction-newthread' => 'أرسل نقاشات جديدة',
	'lqt-protected-reply-thread' => 'أنت لا يمكنك التعليق في هذا الخيط لأنه تمت حمايته من التعليقات الجديدة.',
	'lqt-protected-reply-talkpage' => 'أنت لا يمكنك التعليق في هذا الخيط لأن صفحة النقاش هذه تمت حمايتها من الردود على خيوطها.',
	'lqt-protected-newthread' => 'أنت لا يمكنك إرسال خيوط جديدة إلى صفحة النقاش هذه لأنه تمت حمايتها من الخيوط الجديدة.',
	'lqt-edit-bump' => 'اضغط على هذا الخيط',
	'lqt-edit-bump-tooltip' => 'انقل هذا النقاش إلى أعلى صفحة النقاش',
	'lqt-historicalrevision-error' => 'المراجعة التي اخترتها معطوبة، ولا يمكن رؤيتها.',
	'lqt-reply-subpage' => 'رد',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author 334a
 * @author Basharh
 */
$messages['arc'] = array(
	'lqt_from_talk' => 'ܡܢ $1',
	'lqt_hist_deleted' => 'ܫܝܦܬ',
	'lqt_hist_undeleted' => 'ܠܐ ܫܝܦܬ',
	'lqt_hist_moved_talkpage' => 'ܫܢܝܬ',
	'lqt_protectedfromreply_link' => 'ܢܛܝܪܐ',
	'lqt_subject' => 'ܡܠܘܐܐ:',
	'lqt_noreason' => 'ܠܐ ܥܠܬܐ ܝܗܝܒܬܐ',
	'lqt_summary_subtitle' => 'ܦܣܝܩܬ̈ܐ ܕ"$1"',
	'lqt_move_move' => 'ܫܢܝ',
	'lqt-title' => 'ܟܘܢܝܐ',
	'lqt-summary' => 'ܦܣܝܩܬ̈ܐ',
	'lqt-email-undo' => 'ܠܐ ܬܥܒܕ',
	'lqt-no-new-messages' => 'ܠܝܬ ܠܟ ܐܓܪ̈ܬܐ ܚܕ̈ܬܬܐ',
	'lqt-new-messages' => '✒ ܐܝܬ ܠܟ ܐܓܪ̈ܬܐ ܚܕ̈ܬܬܐ.',
	'lqt-history-time' => 'ܙܒܢܐ',
	'lqt-history-user' => 'ܡܦܠܚܢܐ',
	'lqt-header-actions' => 'ܥܒܕ̈ܐ',
	'lqt-movethread' => 'ܫܢܝ',
	'lqt-menu-trigger' => 'ܝܬܝܪ',
	'lqt-newmessages-from' => 'ܡܢ $1',
	'lqt-add-reply' => 'ܐܘܣܦ ܦܘܢܝܐ',
	'lqt-search-button' => 'ܒܨܝ',
	'searchprofile-threads' => 'ܕܘܪ̈ܫܐ',
	'lqt-ajax-update-link' => 'ܚܕܬ',
	'lqt-change-subject' => 'ܫܚܠܦ ܡܠܘܐܐ',
	'lqt-save-subject' => 'ܠܒܘܟ',
	'lqt-cancel-subject-edit' => 'ܒܛܘܠ',
	'lqt-drag-save' => 'ܚܬܬ',
	'lqt-drag-reason' => 'ܥܠܬܐ:',
	'lqt-edit-signature' => '(ܫܚܠܦ ܪܡܝ ܐܝܕܐ)',
	'lqt-preview-signature' => '(ܚܝܪܐ ܩܕܡܝܐ)',
	'lqt-newmessages-n' => 'ܐܓܪ̈ܬܐ ܚܕ̈ܬܬܐ ($1)',
	'lqt_newmessages' => 'ܐܓܪ̈ܬܐ ܚܕ̈ܬܬܐ ܕܝܠܝ (ܠܝܬ)',
	'lqt_newmessages-title' => 'ܐܓܪ̈ܬܐ ܚܕ̈ܬܬܐ',
	'lqt-talkpage-history-subtitle' => 'ܠ $1',
	'nstab-summary' => 'ܦܣܝܩܬ̈ܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 * @author Ouda
 */
$messages['arz'] = array(
	'lqt-desc' => 'يضيف نقاشات فى مجموعات إلى صفحات النقاش',
	'lqt_movethread' => 'انقل النقاش إلى صفحه أخرى',
	'lqt_deletethread' => 'احذف أو استرجع النقاش',
	'lqt_contents_title' => 'المحتويات',
	'lqt_toc_thread_title' => 'عنوان النقاش',
	'lqt_toc_thread_author' => 'بدأه',
	'lqt_toc_thread_replycount' => 'الردود',
	'lqt_toc_thread_modified' => 'آخر تعديل',
	'lqt_add_header' => 'أضف عنوانا',
	'lqt_new_thread' => 'ابدأ نقاشا جديدا',
	'lqt_invalid_subject' => 'الموضوع الذى أدخلته غير صحيح.
ربما:
* يكون طويلا جدا، أو
* يتعارض مع بادئات الإنترويكى أو أسماء النطاقات.',
	'lqt_empty_subject' => 'يجب أن تدخل موضوعًا.',
	'lqt_reply' => 'رُد',
	'lqt_delete' => 'احذف',
	'lqt_undelete' => 'استرجع',
	'lqt_permalink' => 'صِل إليه',
	'lqt_fragment' => 'جزء $1 من $2',
	'lqt_discussion_link' => 'نقاش',
	'lqt_from_talk' => 'من $1',
	'lqt-history-title' => 'تاريخ النقاش',
	'lqt_hist_comment_edited' => '[$2 عدّل] نص التعليق',
	'lqt_hist_summary_changed' => 'غُيّر الملخص',
	'lqt_hist_reply_created' => 'أنشأ [[$1|ردا جديدا]]',
	'lqt_hist_thread_created' => 'أنشأ نقاشًا جديدًا',
	'lqt_hist_deleted' => 'محذوف',
	'lqt_hist_undeleted' => 'مسترجع',
	'lqt_hist_moved_talkpage' => 'منقول',
	'lqt_hist_listing_subtitle' => 'عرض قائمه تاريخ',
	'lqt_hist_view_whole_thread' => 'عرض تاريخ النقاش كاملًا',
	'lqt_hist_no_revisions_error' => 'ليس لهذا النقاش أى مراجعات فى التاريخ.',
	'lqt_hist_past_last_page_error' => 'أنت تجاوزت عدد صفحات التاريخ الموجوده.',
	'lqt_hist_tooltip_newer_disabled' => 'هذه الوصله معطله لأنك على الصفحه الأولى.',
	'lqt_hist_tooltip_older_disabled' => 'هذه الوصله معطله لأنك على الصفحه الأخيره.',
	'lqt_hist_split' => 'الرد فصل إلى خيط جديد',
	'lqt_hist_edited_subject' => 'غيّر الموضوع من "$2" إلى "$3"',
	'lqt_hist_edited_subject_corrupt' => 'غير الموضوع',
	'lqt_hist_merged_from' => 'نقل [[$1|الرد]] إلى نقاش آخر',
	'lqt_hist_merged_to' => 'نقل [[$1|الرد]] من نقاش آخر',
	'lqt_hist_split_from' => 'افصل إلى نقاش جديد',
	'lqt_hist_root_blanked' => 'نص تعليق مُزال',
	'lqt_hist_adjusted_sortkey' => 'عدل موضع الخيط',
	'lqt_revision_as_of' => 'المراجعه بتاريخ $2 الساعه $3.',
	'lqt_change_new_thread' => 'هذه هى المراجعه الابتدائيه للنقاش.',
	'lqt_change_reply_created' => 'أُنشئ [$1 التعليق المظلل] فى هذه المراجعه.',
	'lqt_change_edited_root' => 'عُدل [$1 التعليق المظلل] فى هذه المراجعه.',
	'lqt_change_edited_summary' => 'عُدّل ملخص النقاش',
	'lqt_change_deleted' => '[$1 هذا الخيط] أو أبوه تم حذفه',
	'lqt_change_undeleted' => '[$1 الرساله المعلمة] تم استرجاعها',
	'lqt_change_moved' => '[$1 هذا الخيط] تم نقله إلى صفحه نقاش أخرى',
	'lqt_change_split' => '[$1 هذا الخيط] تم فصله من خيط آخر',
	'lqt_change_edited_subject' => 'موضوع هذا الخيط تم تغييره من "$2" إلى "$3"',
	'lqt_change_merged_from' => '[$1 رد] لهذا الخيط تم نقله لخيط آخر',
	'lqt_change_merged_to' => '[$1 الرد المعلم] تم نقله من خيط آخر',
	'lqt_change_split_from' => '[$1 خيط فرعي] لهذا الخيط تم فصله إلى خيطه الخاص',
	'lqt_change_root_blanked' => 'نص [$1 تعليق] تمت إزالته.',
	'lqt_youhavenewmessages' => 'لديك [[$1|رسائل جديدة]].',
	'lqt_protectedfromreply' => 'تمت $1 النقاش من الرد عليه.',
	'lqt_protectedfromreply_link' => 'حماية',
	'lqt_subject' => 'موضوع:',
	'lqt_noreason' => 'لا سبب معطى.',
	'lqt_move_placeholder' => 'هذا النقاش لحجز المكان ويعنى أن النقاش $1 نُقل من هذه الصفحه.
قام بالنقل $2 فى $3 $4. النقاش موجود حاليا فى $5.',
	'lqt_thread_deleted_for_sysops' => "تم '''حذف''' هذا النقاش وهو مرئيه فقط للإداريين.",
	'lqt_thread_deleted' => 'تم حذف هذا النقاش.',
	'lqt_summary_notice' => 'لا توجد تغييرات لهذا النقاش لفتره $2 {{PLURAL:$2|يوم|يوم}}. على الأقل.
لو كان النقاش قد انتهى، فربما ترغب فى $1.',
	'lqt_summary_notice_link' => 'اكتب ملخصا',
	'lqt_summary_label' => 'لُخص هذا النقاش بالتالي:',
	'lqt_summary_subtitle' => 'ملخص "$1"',
	'lqt_nosuchrevision' => 'لا توجد مراجعه كهذه لهذا النقاش.',
	'lqt_nosuchthread' => 'لا يوجد موضوع كهذا الذى حدّدت.',
	'lqt_nosuchthread_title' => 'لا نقاش كهذا',
	'lqt_threadrequired' => 'يجب عليك تحديد نقاش فى المسار.',
	'lqt_move_movingthread' => 'نقل $1.
هذا النقاش جزء من $2.',
	'lqt_move_torename' => "لإعاده تسميه هذا النقاش، $1 وغيّر حقل 'الموضوع'.",
	'lqt_move_torename_edit' => 'عدله',
	'lqt_move_destinationtitle' => 'عنوان صفحه النقاش الهدف:',
	'lqt_move_move' => 'انقل',
	'lqt_move_nodestination' => 'يجب عليك تحديد وجهه.',
	'lqt_move_thread_bad_destination' => 'الصفحه الهدف ليست صفحه نقاش.',
	'lqt_move_samedestination' => 'الموضوع أصلًا على هذه الصفحة!',
	'lqt_move_noreason' => 'لا سبب معطى.',
	'lqt_move_success' => 'تم نقل النقاش إلى $1.',
	'lqt_delete_undeletethread' => 'استرجع النقاش',
	'lqt_delete_partof' => "هذا النقاش جزء من '''$1'''.",
	'lqt_delete_deleting' => "حذف '''$1''' و '''كل الردود''' له.",
	'lqt_delete_deletethread' => 'احذف النقاش والردود',
	'lqt_delete_deleted' => 'تم حذف النقاش.',
	'lqt_delete_undeleted' => 'تم استرجاع النقاش.',
	'lqt_delete_return' => 'ارجع إلى $1.',
	'lqt_delete_return_link' => 'صفحه النقاش',
	'lqt_delete_unallowed' => 'أنت غير مسموح لك بحذف مجموعات الرسائل.',
	'lqt_delete_show_checkbox' => 'اعرض مجموعات الرسائل المحذوفة',
	'lqt_talkpage_autocreate_summary' => 'صفحه النقاش تم إنشاؤها تلقائيا عندما تم إرسال أول نقاش.',
	'lqt_header_warning_big' => 'أنت تعدل $1.',
	'lqt_header_warning_after_big' => 'العناوين للإعلانات والمقدمات.
ربما ترغب كبديل فى $2.',
	'lqt_header_warning_bold' => 'عنوان صفحه نقاش',
	'lqt_header_warning_new_discussion' => 'بدء نقاش جديد',
	'lqt_sorting_order' => 'طريقه الترتيب:',
	'lqt_sort_newest_changes' => 'المعدل أخيرا أولا',
	'lqt_sort_newest_threads' => 'النقاشات الأجدد أولا',
	'lqt_sort_oldest_threads' => 'النقاشات الأقدم أولا',
	'lqt-title' => 'العنوان',
	'lqt-summary' => 'ملخص',
	'lqt-searching' => 'بحث عن مجموعات الرسائل',
	'lqt-read-message' => 'علّم مقروءة',
	'lqt-read-message-tooltip' => 'أزل هذا النقاش من الرسائل الجديده.
ستظل مرئيه على صفحه نقاشها الأصليه.',
	'lqt-read-all' => 'علّم الكل مقروءًا',
	'lqt-read-all-tooltip' => 'إزاله كل مجموعات الرسائل من الرسائل الجديده.
ستظل مرئيه على صفحات نقاشها الأصليه.
هذه العمليه لا يمكن الرجوع عنها.',
	'lqt-marked-read' => "تم تعليم النقاش '''$1''' مقروءًا.",
	'lqt-count-marked-read' => 'تم تعليم {{PLURAL:$1||رساله واحده مقروءة|رسالتين مقروأتين|$1 رسائل مقروءة|$1 رساله مقروءة}}.',
	'lqt-email-undo' => 'تراجَع',
	'lqt-no-new-messages' => 'لا توجد رسائل جديده لك.',
	'lqt-new-messages' => '✒ توجد رسائل جديده لك.',
	'lqt-email-info-undo' => 'أعد النقاش التى صرفته منذ قليل.',
	'lqt-date-info' => 'هذه الوصله معطله لأنك ترى مجموعات الرسائل من كل التواريخ.',
	'lqt-newmessages-context' => 'موضوع كامل',
	'lqt-thread-created' => 'تم إنشاؤه',
	'lqt-history-time' => 'الوقت',
	'lqt-history-user' => 'المستخدم',
	'lqt-history-action' => 'النشاط',
	'lqt-history-comment' => 'تعليق',
	'lqt-history-thread' => 'نقاش',
	'lqt-thread-edited-author' => 'حرّرها المؤلف',
	'lqt-thread-edited-others' => 'حرّرها مستخدمون آخرون',
	'lqt-header-actions' => 'الإجراءات',
	'lqt_summarize_link' => 'الملخص',
	'lqt-summarize-intro' => 'من فضلك لخّص الموضوع أدناه فى صندوق التحرير.
تستطيع استخدام أى نص ويكى فى ملخّصك. انقر "{{int:savearticle}}" عندما تنتهى.',
	'lqt-thread-split' => 'افصل إلى موضوع جديد',
	'lqt-split-success' => 'لقد فصلت بنجاح الموضوع $1.',
	'lqt_split_thread' => 'فصل موضوع',
	'lqt-thread-split-subject' => 'عنوان الموضوع الجديد:',
	'lqt-thread-split-thread' => 'الموضوع:',
	'lqt-split-submit' => 'افصل',
	'lqt_split_badsubject' => 'العنوان الذى أدخلته غير صحيح.',
	'lqt-no-threads' => 'لا توجد أى مواضيع فى هذه الصفحه إلى الآن.',
	'lqt-delete-parent-warning' => 'هذا خيط عالى المستوى بردود.
رددوده سيتم أيضا حذفها تلقائيا.
لتجنب هذا، افصلهم من هذا الخيط قبل حذفه.',
	'lqt-delete-parent-deleted' => 'الخيط الأب تم حذفه ($1)',
	'lqt-delete-replies-done' => 'تم حذف جميع الردود على هذا الموضوع أيضًا.',
	'lqt-movethread' => 'انقل',
	'lqt-menu-trigger' => 'مزيد',
	'lqt-newmessages-from' => 'من $1',
	'lqt-hot-topics' => 'مواضيع ساخنة',
	'lqt-add-reply' => 'أضف ردا',
	'lqt_rc_new_discussion' => 'نقاش جديد، $1، فى $2. • $3 يكتب:',
	'lqt_rc_new_reply' => 'رد على $1، فى $2. • $3 يكتب:',
	'right-lqt-split' => 'فصل الخيوط',
	'right-lqt-merge' => 'دمج الخيوط',
	'lqt-thread-merge' => 'ادمج مع نقاش آخر',
	'lqt-thread-merge-to' => 'ادمج مع هذا النقاش',
	'lqt_merge_thread' => 'دمج الخيط',
	'lqt-thread-merge-source' => 'الموضوع المصدر:',
	'lqt-thread-merge-dest' => 'الموضوع الهدف:',
	'lqt-merge-submit' => 'دمج',
	'lqt-merge-success' => 'أنت دمجت بنجاح الخيط $1 إلى تحت $2.',
	'lqt-log-name' => 'سجل النقاش ذى الموضوعات',
	'lqt-log-header' => 'يعرض هذا السجل إجراءات تم اتخاذها فى مواضيع النقاش.',
	'lqt-log-action-move' => 'نقل [[$1]] من [[$2]] إلى [[$3]].',
	'lqt-preference-notify-talk' => 'أرسل لى رساله بريد إلكترونى عن الردود التى تضاف إلى موضوع أراقبه',
	'lqt-preference-watch-threads' => 'راقب النقاشات التى أنشئها أو أرد عليها',
	'prefs-lqt' => 'نقاشات مُجمّعة',
	'lqt-preference-display-depth' => 'عمق الردود الأقصى للعرض:',
	'lqt-preference-display-count' => 'عدد الردود الأقصى للعرض:',
	'lqt-preference-custom-signatures' => 'أظهر توقيعات المستخدمين المُخصّصة',
	'lqt-enotif-subject-reply' => 'نقاش {{SITENAME}} - رد: $1',
	'lqt-enotif-subject-newthread' => 'نقاش {{SITENAME}} - موضوع جديد: $1',
	'lqt-enotif-newthread' => "مرحبًا $1.

هذا إخطار من {{SITENAME}} بأن موضوعًا جديدًا فى $5 ('$2')
قد أنشئ فى يوم $3 عند $4.

بإمكانك مراجعته عبر <$6>",
	'lqt-enotif-reply' => "مرحبًا $1.

هذا إخطار من {{SITENAME}} بأن ردًا جديدًا على '$2' فى $5
قد وُضع فى يوم $3 عند $4.

بإمكانك مراجعته عبر <$6>",
	'lqt-quote-intro' => 'فى $2 عند $3، كتب [[User:$1|$1]]:',
	'lqt-quote' => 'اقتبس',
	'lqt-search-legend' => 'ابحث فى نقاشات هذه الصفحة',
	'lqt-search-label' => 'عباره البحث:',
	'lqt-search-button' => 'ابحث',
	'searchprofile-threads' => 'نقاشات',
	'searchprofile-threads-tooltip' => 'ابحث فى النقاشات وصفحات النقاش ذات الخيوط',
	'lqt-ajax-updated' => 'يحوى هذا النقاش مرسلات جديده.',
	'lqt-ajax-update-link' => 'حدّث',
	'lqt-thread-show-replies' => 'أظهر {{PLURAL:$1||ردًا واحدًا|ردّين|$1 ردود|$1 ردًا|$1 رد}}',
	'lqt-thread-show-more' => 'أظهر مزيدًا من الردود',
	'lqt-thread-link-url' => 'مسار الوصلة:',
	'lqt-thread-link-title' => 'وصله ويكي:',
	'lqt-thread-link-copy' => 'انسخ إلى الحافظة',
	'lqt-sign-not-necessary' => 'من غير الضرورى التوقيع على تعليقك باستخدام أربع مدات.
التوقيع يتم عرضه أوتوماتيكيا.',
	'lqt-marked-as-read-placeholder' => 'الخيط $1 تم التعليم عليه كمقروء.',
	'lqt-change-subject' => 'غير الموضوع',
	'lqt-save-subject' => 'احفظ',
	'lqt-save-subject-failed' => 'الخطأ التالى حدث أثناء محاوله تغيير موضوع هذا الخيط: $1',
	'lqt-ajax-invalid-subject' => 'الموضوع الذى حددته كان غير صحيح، على الأرجح لأنه كان طويلا جدا.',
	'lqt-ajax-no-subject' => 'يجب أن تحدد موضوعا.',
	'lqt-save-subject-error-unknown' => 'خطأ غير معروف حدث أثناء محاوله ضبط موضوع هذا الخيط. من فضلك حاول فعل هذا بواسطه الضغط على "عدل" على التعليق الاعلى.',
	'lqt-cancel-subject-edit' => 'ألغ',
	'lqt-drag-activate' => 'جر إلى الموقع الجديد',
	'lqt-drag-drop-zone' => 'أسقط هنا',
	'lqt-drag-confirm' => 'لإكمال الأفعال التاليه، من فضلك املأ السبب واضغط "أكد".',
	'lqt-drag-reparent' => 'انقل الرساله تحت أب جديد.',
	'lqt-drag-split' => 'انقل الرساله إلى خيطها الخاص',
	'lqt-drag-setsortkey' => 'عدل موضع الرساله فى الصفحة',
	'lqt-drag-bump' => 'انقل الرساله أعلى صفحه النقاش',
	'lqt-drag-save' => 'تأكيد',
	'lqt-drag-reason' => 'السبب:',
	'lqt-drag-subject' => 'العنوان للخيط الجديد:',
	'lqt-edit-signature' => '(عدل التوقيع)',
	'lqt-preview-signature' => '(معاينة)',
	'lqt-feed-title-all' => '{{SITENAME}} — مرسلات جديدة',
	'lqt-feed-title-all-from' => '{{SITENAME}} — رسائل جديده من $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — نقاشات جديدة',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — {{PLURAL:$2||نقاش جديد|نقاشان جديدان|نقاشات جديدة}} من $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — ردود',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — ردود من $1',
	'lqt-newmessages-n' => 'الرسائل الجديده ($1)',
	'lqt_newmessages' => 'رسائل جديدة',
	'lqt_newmessages-title' => 'رسائل جديدة',
	'lqt-newpost-summary' => 'نقاش جديد: $1',
	'lqt-reply-summary' => 'رد على [[$2|$1]]',
	'lqt-talkpage-history-title' => 'تاريخ صفحه النقاش',
	'lqt-talkpage-history-subtitle' => 'ل$1',
	'lqt-talkpage-history-tab' => 'عنوان',
	'restriction-reply' => 'أرسل ردودًا',
	'restriction-newthread' => 'أرسل نقاشات جديدة',
	'lqt-protected-reply-thread' => 'أنت لا يمكنك التعليق فى هذا الخيط لأنه تمت حمايته من التعليقات الجديده.',
	'lqt-protected-reply-talkpage' => 'أنت لا يمكنك التعليق فى هذا الخيط لأن صفحه النقاش هذه تمت حمايتها من الردود على خيوطها.',
	'lqt-protected-newthread' => 'أنت لا يمكنك إرسال خيوط جديده إلى صفحه النقاش هذه لأنه تمت حمايتها من الخيوط الجديده.',
	'lqt-edit-bump' => 'اضغط على هذا الخيط',
	'lqt-edit-bump-tooltip' => 'انقل هذا الخيط إلى أعلى صفحه نقاشه',
	'lqt-historicalrevision-error' => 'المراجعه التى اخترتها معطوبه، ولا يمكن رؤيتها.',
	'lqt-reply-subpage' => 'رد',
);

/** Asturian (Asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'lqt_delete_return' => 'Tornar a $1.',
	'lqt-preview-signature' => '(entever)',
);

/** Azerbaijani (Azərbaycanca)
 * @author Cekli829
 * @author PPerviz
 */
$messages['az'] = array(
	'lqt_reply' => 'Yenidən',
	'lqt_delete' => 'Sil',
	'lqt_subject' => 'Mövzu:',
	'lqt-title' => 'Başlıq',
	'lqt-summary' => 'Xülasə',
	'lqt-history-time' => 'Zaman',
	'lqt-history-user' => 'İstifadəçi',
	'lqt-history-comment' => 'Şərh',
	'lqt-search-button' => 'Axtar',
	'lqt-thread-link-url' => 'URL linki:',
	'lqt-save-subject' => 'Qeyd et',
	'lqt-cancel-subject-edit' => '
İmtina',
	'lqt-drag-save' => 'Təsdiq et',
	'lqt-drag-reason' => 'Səbəb:',
	'lqt-newmessages-n' => 'Yeni mesajlarım ($1)',
	'lqt_newmessages' => 'Yeni mesajlarım (Yoxdur)',
	'lqt_newmessages-title' => 'Yeni mesajlar',
	'lqt-reply-subpage' => 'yenidən',
	'nstab-summary' => 'Xülasə',
);

/** Bashkir (Башҡортса)
 * @author Assele
 * @author Haqmar
 */
$messages['ba'] = array(
	'lqt-desc' => 'Фекер алышыу биттәренә фекер алышыу тармаҡтарын өҫтәй',
	'lqt_movethread' => 'Тармаҡты икенсе биткә күсереү',
	'lqt_deletethread' => 'Тармаҡты юйыу йәки тергеҙеү',
	'lqt_contents_title' => 'Эстәлек',
	'lqt_toc_thread_title' => 'Тармаҡтың исеме',
	'lqt_toc_thread_author' => 'Башлаған',
	'lqt_toc_thread_replycount' => 'Яуаптар',
	'lqt_toc_thread_modified' => 'Аҙаҡҡы үҙгәртеү',
	'lqt_add_header' => 'Башлыҡ өҫтәргә',
	'lqt_new_thread' => 'Яңы фекер алышыу башларға',
	'lqt_invalid_subject' => 'Һеҙ кереткән исем дөрөҫ түгел, түбәндәге хаталар булыуы мөмкин:
* бигерәк оҙон
*  интерфики-префикстар йәки исемдәр арауығы исемдәре менән тап килә',
	'lqt_empty_subject' => 'Һеҙ исемде керетергә тейешһегеҙ.',
	'lqt_reply' => 'Яуап бирергә',
	'lqt-parent' => 'Башланғыс хәбәр',
	'lqt_delete' => 'Юйырға',
	'lqt_undelete' => 'Тергеҙергә',
	'lqt_permalink' => 'Бында һылтанма',
	'lqt_fragment' => '$2 битенең $1 өлөшө',
	'lqt_discussion_link' => 'фекер алышыу',
	'lqt_from_talk' => '$1 битенән',
	'lqt-history-title' => 'Тармаҡтың тарихы',
	'lqt_hist_comment_edited' => 'Аңлатма [$2 үҙгәртелгән]',
	'lqt_hist_summary_changed' => 'Һөҙөмтә үҙгәртелгән',
	'lqt_hist_reply_created' => '[[$1|Яңы яуап]] булдырылған',
	'lqt_hist_thread_created' => 'Яңы тармаҡ булдырылған',
	'lqt_hist_deleted' => 'Юйылған',
	'lqt_hist_undeleted' => 'Тергеҙелгән',
	'lqt_hist_moved_talkpage' => 'Күсерелгән',
	'lqt_hist_listing_subtitle' => 'Тарихты ҡарау',
	'lqt_hist_view_whole_thread' => 'Бөтә тармаҡ өсөн тарихты ҡарарға',
	'lqt_hist_no_revisions_error' => 'Был тармаҡтың тарихы юҡ.',
	'lqt_hist_past_last_page_error' => 'Һеҙ тарихтың булған биттәренең сигенән сыҡҡанһығыҙ.',
	'lqt_hist_tooltip_newer_disabled' => 'Был һылтанма һүндерелгән, сөнки һеҙ беренсе биттә.',
	'lqt_hist_tooltip_older_disabled' => 'Был һылтанма һүндерелгән, сөнки һеҙ аҙаҡҡы биттә.',
	'lqt_hist_split' => 'Яуап яңы тармаҡҡа айырылған.',
	'lqt_hist_edited_subject' => 'Исем үҙгәргән. Элекке исеме: "$2". Яңы исеме: "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Исем үҙгәргән',
	'lqt_hist_merged_from' => '[[$1|Яуап]] икенсе тармаҡҡа күсерелгән.',
	'lqt_hist_merged_to' => '[[$1|Яуап]] икенсе тармаҡтан күсерелгән.',
	'lqt_hist_split_from' => 'Яңы тармаҡҡа айырырға',
	'lqt_hist_root_blanked' => 'Аңлатма юйылған',
	'lqt_hist_adjusted_sortkey' => 'Тармаҡтың урынлашҡан урыны үҙгәргән',
	'lqt_revision_as_of' => 'Версия: $2; $3',
	'lqt_change_new_thread' => 'Был - тармаҡтың башланғыс версияһы.',
	'lqt_change_reply_created' => '[$1 Яҡтыртылған аңлатма] был версияла булдырылған.',
	'lqt_change_edited_root' => '[$1 Яҡтыртылған аңлатма] был версияла үҙгәртелгән.',
	'lqt_change_edited_summary' => 'Тармаҡтың һөҙөмтәһе үҙгәртелгән.',
	'lqt_change_deleted' => '[$1 Был тармаҡ] йәки уның башланғыс тармағы юйылған',
	'lqt_change_undeleted' => '[$1 Яҡтыртылған хәбәр] тергеҙелгән',
	'lqt_change_moved' => '[$1 Был тармаҡ] икенсе фекер алышыу битенә күсерелгән',
	'lqt_change_split' => '[$1 Был тармаҡ] икенсе тармаҡтан айырылған',
	'lqt_change_edited_subject' => 'Был тармаҡтың исеме үҙгәртелгән. Элекке исеме: "$2". Яңы исеме: "$3"',
	'lqt_change_merged_from' => 'Был тармаҡтың [$1 яуабы] икенсе тармаҡҡа күсерелгән',
	'lqt_change_merged_to' => '[$1 Яҡтыртылған яуап] икенсе тармаҡтан күсерелгән',
	'lqt_change_split_from' => 'Был тармаҡ эсендәге [$1 тармаҡ] үҙ тармағына айырылған',
	'lqt_change_root_blanked' => '[$1 Аңлатма] юйылған.',
	'lqt_youhavenewmessages' => 'Һеҙгә [[$1|яңы хәбәрҙәр]] бар.',
	'lqt_protectedfromreply' => 'Был тармаҡ уға яуап биреүҙән $1',
	'lqt_protectedfromreply_link' => 'һаҡланған',
	'lqt_subject' => 'Исем:',
	'lqt_noreason' => 'Сәбәп белдерелмәгән.',
	'lqt_move_placeholder' => '$1 тармағы был биттән $5 битенә күсерелгән.
$3 $4 уны $2 күсергән.',
	'lqt_thread_deleted_for_sysops' => "Был тармаҡ '''юйылған''' һәм хәкимдәргә генә күренә.",
	'lqt_thread_deleted' => 'Был тармаҡ юйылған.',
	'lqt_summary_notice' => 'Был фекер алышыу кәмендә $2 {{PLURAL:$2|көн}} үҙгәртелмәгән.
Әгәр ул тамамланһа, һеҙгә $1 мөмкин.',
	'lqt_summary_notice_link' => 'һөҙөмтә яһарға',
	'lqt_summary_label' => 'Тармаҡтың тасуирламаһы:',
	'lqt_summary_subtitle' => '"$1" тармағының һөҙөмтәһе',
	'lqt_nosuchrevision' => 'Был тармаҡтың ундай версияһы юҡ.',
	'lqt_nosuchthread' => 'Һеҙ күрһәткән тармаҡ юҡ.',
	'lqt_nosuchthread_title' => 'Ундай тармаҡ юҡ.',
	'lqt_threadrequired' => 'Һеҙгә URL адреста тармаҡты күрһәтергә кәрәк.',
	'lqt_move_movingthread' => '$1 тармағын күсереү.
Был тармаҡ — $2 тармағының өлөшө.',
	'lqt_move_torename' => "Был тармаҡҡа икенсе исем биреү өсөн, $1 һәм 'Исем' юлын үҙгәртегеҙ.",
	'lqt_move_torename_edit' => 'уны үҙгәртегеҙ',
	'lqt_move_destinationtitle' => 'Кәрәкле фекер алышыу битенең исеме:',
	'lqt_move_move' => 'Күсерергә',
	'lqt_move_nodestination' => 'Һеҙ кәрәкле фекер алышыу битен күрһәтергә тейешһегеҙ.',
	'lqt_move_thread_bad_destination' => 'Күрһәтелгән бит — фекер алышыу бите түгел.',
	'lqt_move_samedestination' => 'Тармаҡ был биттә инде!',
	'lqt_move_noreason' => 'Сәбәп белдерелмәгән.',
	'lqt_move_success' => 'Был тармаҡ $1 битенә күсерелгән.',
	'lqt_delete_undeletethread' => 'Тармаҡты тергеҙеү',
	'lqt_delete_partof' => "Был тармаҡ — '''$1''' тармағының өлөшө.",
	'lqt_delete_deleting' => "'''$1''' һәм уға булған '''бөтә яуаптарҙы''' юйыу.",
	'lqt_delete_deletethread' => 'Тармаҡты һәм яуаптарҙы юйырға',
	'lqt_delete_deleted' => 'Тармаҡ юйылды.',
	'lqt_delete_undeleted' => 'Тармаҡ тергеҙелде.',
	'lqt_delete_return' => '$1 битенә ҡайтырға.',
	'lqt_delete_return_link' => 'Фекер алышыу',
	'lqt_delete_unallowed' => 'Һеҙ тармаҡтарҙы юя алмайһығыҙ.',
	'lqt_delete_show_checkbox' => 'Юйылған тармаҡтарҙы күрһәтергә',
	'lqt_talkpage_autocreate_summary' => 'Беренсе хәбәр ебәрелеү менән, фекер алышыу бите үҙенән-үҙе барлыҡҡа килә',
	'lqt_header_warning_big' => 'Һеҙ $1 мөхәррирләйһегеҙ.',
	'lqt_header_warning_after_big' => 'Исемдәр иғлан һәм инеш булараҡ хеҙмәт итә.
Һеҙ $2 алаһығыҙ.',
	'lqt_header_warning_bold' => 'фекер алышыу битенең исемен',
	'lqt_header_warning_new_discussion' => 'яңы фекер алышыу башлай',
	'lqt_sorting_order' => 'Тәртипкә килтереү йүнәлеше:',
	'lqt_sort_newest_changes' => 'башта һуңғы үҙгәртелгәндәр',
	'lqt_sort_newest_threads' => 'башта яңы тармаҡтар',
	'lqt_sort_oldest_threads' => 'башта иҫке тармаҡтар',
	'lqt-title' => 'Исем',
	'lqt-summary' => 'Һөҙөмтә',
	'lqt-searching' => 'Тармаҡтар араһында эҙләү',
	'lqt-read-message' => 'Уҡылған тип билдәләргә',
	'lqt-read-message-tooltip' => 'Был тармаҡты яңы хәбәрҙәр исемлегенән юйыу.
Ул фекер алышыу битендә тороп ҡаласаҡ.',
	'lqt-read-all' => 'Барыһын да уҡылған тип билдәләргә',
	'lqt-read-all-tooltip' => 'Бөтә тармаҡтарҙы яңы хәбәрҙәр исемлегенән юйыу.
Улар үҙҙәренең фекер алышыу битендә тороп ҡаласаҡ.
Был үҙгәртеүҙе кире алыу мөмкин түгел.',
	'lqt-marked-read' => "'''$1''' тармағы уҡылған тип билдәләнде.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|хәбәр}} уҡылған тип билдәләнде.',
	'lqt-email-undo' => 'Кире алырға',
	'lqt-no-new-messages' => 'Һеҙҙең өсөн яңы хәбәрҙәр юҡ.',
	'lqt-new-messages' => '✒ Һеҙҙең өсөн яңы хәбәрҙәр бар.',
	'lqt-email-info-undo' => 'Әле алып ташланған тармаҡты кире ҡайтарырға.',
	'lqt-date-info' => 'Был һылтанма һүндерелгән, сөнки һеҙ бөтә көндәр өсөн тармаҡтарҙы ҡарайһығыҙ.',
	'lqt-newmessages-context' => 'Тулы тармаҡ',
	'lqt-thread-created' => 'Булдырылған',
	'lqt-history-time' => 'Ваҡыт',
	'lqt-history-user' => 'Ҡатнашыусы',
	'lqt-history-action' => 'Ваҡиғалар',
	'lqt-history-comment' => 'Аңлатма',
	'lqt-history-thread' => 'Тармаҡ',
	'lqt-thread-edited-author' => 'Автор тарафынан үҙгәртелгән.<br />
Һуңғы үҙгәртеү: $1',
	'lqt-thread-edited-others' => 'Башҡа {{PLURAL:$2|ҡатнашыусы|$2 ҡатнашыусылар}} тарафынан үҙгәртелгән.
Һуңғы үҙгәртеү:',
	'lqt-header-actions' => 'Ваҡиғалар',
	'lqt_summarize_link' => 'Һөҙөмтә яһарға',
	'lqt-summarize-intro' => 'Зинһар, мөхәррирләү юлында түбәндәге фекер алышыу тармағының һөҙөмтәһен килтерегеҙ.
Һеҙ һөҙөмтәгеҙҙә үҙегеҙ теләгән викитекст ҡуллана алаһығыҙ.
Тамамлағас, "{{int:savearticle}}" төймәһенә баҫығыҙ.',
	'lqt-thread-split' => 'Яңы тармаҡҡа айырырға',
	'lqt-split-success' => 'Һеҙ $1 тармағын уңышлы айырҙығыҙ.',
	'lqt_split_thread' => 'Тармаҡты айырыу',
	'lqt-thread-split-subject' => 'Яңы тармаҡтың исеме:',
	'lqt-thread-split-thread' => 'Тармаҡ:',
	'lqt-split-submit' => 'Айырырға',
	'lqt_split_badsubject' => 'Һеҙ кереткән исем дөрөҫ түгел.',
	'lqt-no-threads' => 'Был биттә әлегә тармаҡтар юҡ.',
	'lqt-delete-parent-warning' => 'Был — яуаптары булған беренсе быуын тармағы.
Уның яуаптары ла юйыласаҡ.
Быға ул ҡуймаҫ өсөн, юйыр алдын уларҙы айырым тармаҡҡа сығарығыҙ.',
	'lqt-delete-parent-deleted' => 'Башланғыс тармаҡ юйылған ($1)',
	'lqt-delete-replies-done' => 'Шулай уҡ был тармаҡтың яуаптары юйылды.',
	'lqt-movethread' => 'Күсерергә',
	'lqt-menu-trigger' => 'Тағы',
	'lqt-newmessages-from' => '$1 битенән',
	'lqt-hot-topics' => 'Ҡыҙыу фекер алышыуҙар',
	'lqt-add-reply' => 'Яуап өҫтәргә',
	'lqt_rc_new_discussion' => 'яңы тармаҡ өҫтәне, «$1»',
	'lqt_rc_new_reply' => '«$1» тармағына яуап яҙҙы',
	'right-lqt-split' => 'тармаҡтарҙы айырыу',
	'right-lqt-merge' => 'тармаҡтарҙы берләштереү',
	'lqt-thread-merge' => 'Икенсе тармаҡҡа ҡушырға',
	'lqt-thread-merge-to' => 'Ошо тармаҡҡа ҡушырға',
	'lqt_merge_thread' => 'Тармаҡтарҙы берләштереү',
	'lqt-thread-merge-source' => 'Ҡуша торған тармаҡ:',
	'lqt-thread-merge-dest' => 'Ошо тармаҡҡа ҡушырға:',
	'lqt-merge-submit' => 'Ҡушырға',
	'lqt-merge-success' => 'Һеҙ $1 тармағын $2 тармағына уңышлы ҡуштығыҙ.',
	'lqt-log-name' => 'Фекер алышыу тармаҡтарының яҙмалары журналы',
	'lqt-log-header' => 'Был журналға фекер алышыу тармаҡтарында булған ваҡиғалар яҙыла.',
	'lqt-log-action-move' => '[[$1]] тармағын [[$2]] битенән [[$3]] битенә күсергән',
	'lqt-log-action-split' => '[[$1]] тармағын [[$3]] тармағынан яңы "$2" исемле тармаҡҡа айырған',
	'lqt-log-action-merge-across' => '[[$1]] тармағын [[$2]] тармағынан [[$3]] тармағына күсергән',
	'lqt-log-action-merge-down' => '[[$1]] тармағын [[$3]] тармағына ҡушҡан',
	'lqt-log-action-subjectedit' => '[[$1]] тармағының исемен үҙгәрткән. Элекке исеме: "$2". Яңы исеме: "$3"',
	'lqt-log-action-resort' => '[[$1]] тармағын тәртипкә килтереү йүнәлешен үҙгәрткән. Элекке тәртипкә килтереү асҡысы: $2. Яңы тәртипкә килтереү асҡысы: $3',
	'lqt-preference-notify-talk' => 'Мин күҙәткән тармаҡтарға яуаптар тураһында минең электрон почтаға хәбәр ебәрергә',
	'lqt-preference-watch-threads' => 'Мин булдырған йәки мин яуап биргән тармаҡтарҙы күҙәтергә',
	'prefs-lqt' => 'Фекер алышыу тармаҡтары',
	'lqt-preference-display-depth' => '* Күрһәтелә торған яуаптарҙың тәрәнлеге сиге:',
	'lqt-preference-display-count' => '* Күрһәтелә торған яуаптар һаны сиге:',
	'lqt-preference-custom-signatures' => 'Ҡатнашыусыларҙың көйләнә торған имзаларын күрһәтергә',
	'lqt-enotif-subject-reply' => '{{SITENAME}} фекер алышыуы — Яуап: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} фекер алышыуы — Яңы тармаҡ: $1',
	'lqt-enotif-newthread' => 'Һаумыһығыҙ, $1!

Был {{SITENAME}} сайтынан $3 $4 $5 битендә $8 тарафынан яңы «$2» тармағы булдырылыуы тураһында хәбәр.

Һеҙ уны <$6> адресы буйынса күрә алаһығыҙ.

Тармаҡтың тексы:
$7',
	'lqt-enotif-reply' => 'Һаумыһығыҙ, $1!

Был {{SITENAME}} сайтынан $3 $4 $5 битендә $8 тарафынан «$2» тармағына яңы яуап өҫтәлеүе тураһында хәбәр.

Һеҙ уны <$6> адресы буйынса күрә алаһығыҙ.

Яуап:
$7',
	'lqt-quote-intro' => '$2 $3 [[User:$1|$1]] яҙған:',
	'lqt-quote' => 'Цитата итеп алырға',
	'lqt-search-legend' => 'Был биттәге фекер алышыуҙарҙы эҙләү',
	'lqt-search-label' => 'Эҙләү шарттары:',
	'lqt-search-button' => 'Табырға',
	'searchprofile-threads' => 'Фекер алышыуҙар',
	'searchprofile-threads-tooltip' => 'Фекер алышыу тармаҡтарында һәм биттәрендә эҙләү',
	'lqt-ajax-updated' => 'Был тармаҡта яңы хәбәрҙәр бар.',
	'lqt-ajax-update-link' => 'Яңыртырға',
	'lqt-thread-show-replies' => '$1 {{PLURAL:$1|яуап}} күрһәтергә',
	'lqt-thread-show-more' => 'Күберәк яуап күрһәтергә',
	'lqt-thread-link-url' => 'Һылтанманың URL адресы:',
	'lqt-thread-link-title' => 'Вики-һылтанма:',
	'lqt-thread-link-copy' => 'Ваҡытлы һаҡлағысҡа яҙҙырырға',
	'lqt-sign-not-necessary' => 'Хәбәргә дүрт тильда менән имза ҡуйыу кәрәкмәй.
Имза үҙенән-үҙе күренә.',
	'lqt-marked-as-read-placeholder' => '$1 тармағы уҡылған тип билдәләнде.',
	'lqt-change-subject' => 'Исемен үҙгәртергә',
	'lqt-save-subject' => 'Һаҡларға',
	'lqt-save-subject-failed' => 'Был тармаҡтың исемен үҙгәртергә тырышҡан ваҡытта түбәндәге хаталар булды: $1',
	'lqt-ajax-invalid-subject' => 'Һеҙ күрһәткән исем дөрөҫ түгел, уның бигерәк оҙон булыуы мөмкин.',
	'lqt-ajax-no-subject' => 'Һеҙ исем керетергә тейешһегеҙ.',
	'lqt-save-subject-error-unknown' => 'Был тармаҡтың исемен үҙгәртергә тырышҡан ваҡытта билдәһеҙ хата булды. Зинһар, хәбәрҙең өҫкө өлөшөндәге "үҙгәртергә" төймәһенә баҫып үҙгәртеп ҡарағыҙ.',
	'lqt-cancel-subject-edit' => 'Кире алырға',
	'lqt-drag-activate' => 'Күсерергә',
	'lqt-drag-drop-zone' => 'Ошонда күсерергә',
	'lqt-drag-confirm' => 'Тамамлау өсөн, сәбәбен керетегеҙ һәм "Раҫларға" төймәһенә баҫығыҙ.',
	'lqt-drag-reparent' => 'Хәбәрҙе икенсе башланғыс хәбәргә күсерергә.',
	'lqt-drag-split' => 'Хәбәрҙе үҙенең тармағына күсерергә',
	'lqt-drag-setsortkey' => 'Хәбәрҙең биттәге урынын үҙгәртергә',
	'lqt-drag-bump' => 'Хәбәрҙе фекер алышыу битенең башына күсерергә',
	'lqt-drag-save' => 'Раҫларға',
	'lqt-drag-title' => 'Күсереүҙе раҫларға',
	'lqt-drag-reason' => 'Сәбәп:',
	'lqt-drag-subject' => 'Яңы тармаҡ исеме:',
	'lqt-edit-signature' => '(имзаны үҙгәртергә)',
	'lqt-preview-signature' => '(ҡарап сығыу)',
	'lqt-feed-title-all' => '{{SITENAME}} — Яңы хәбәрҙәр',
	'lqt-feed-title-all-from' => '{{SITENAME}} — $1 биттәренән яңы хәбәрҙәр',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Яңы тармаҡтар',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — $1 биттәренән яңы тармаҡтар',
	'lqt-feed-title-replies' => '{{SITENAME}} — Яуаптар',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — $1 биттәренән яңы яуаптар',
	'lqt-feed-new-thread-intro' => '$1 битендә яңы хәбәр, $2 тарафынан өҫтәлгән',
	'lqt-feed-reply-intro' => '$1 битендә $3 тармағына яңы яуап, $2 тарафынан өҫтәлгән',
	'tooltip-pt-newmessages' => 'Һеҙ күҙәткән тармаҡтарҙың яңы хәбәрҙәрен күрһәтә',
	'lqt-newmessages-n' => 'Яңы хәбәрҙәр ($1)',
	'lqt_newmessages' => 'Яңы хәбәрҙәр (Юҡ)',
	'lqt_newmessages-title' => 'Яңы хәбәрҙәр',
	'lqt-newpost-summary' => 'Яңы тармаҡ: $1',
	'lqt-reply-summary' => '[[$2|$1]] хәбәренә яуап',
	'lqt-talkpage-history-title' => 'Фекер алышыу битенең тарихы',
	'lqt-talkpage-history-subtitle' => '«$1» өсөн',
	'lqt-talkpage-history-tab' => 'Исеме',
	'restriction-reply' => 'Яуаптар яҙыу',
	'restriction-newthread' => 'Яңы тармаҡтар булдырыу',
	'lqt-protected-reply-thread' => 'Һеҙ был тармаҡҡа яҙа алмайһығыҙ, сөнки ул яңы хәбәрҙәр яҙыуҙан һаҡланған.',
	'lqt-protected-reply-talkpage' => 'Һеҙ был тармаҡҡа яҙа алмайһығыҙ, сөнки был фекер алышыу бите уның тармаҡтарында яуап яҙыуҙан һаҡланған.',
	'lqt-protected-newthread' => 'Һеҙ был тармаҡҡа яҙа алмайһығыҙ, сөнки был фекер алышыу бите уның тармаҡтарында яуап яҙыуҙан һаҡланған.',
	'lqt-edit-bump' => 'Был тармаҡты күтәрергә',
	'lqt-edit-bump-tooltip' => 'Был тармаҡты уның фекер алышыу битенең башына күсерергә',
	'lqt-historicalrevision-error' => 'Һайланған өлгө боҙолған, уны ҡарап булмай.',
	'lqt-reply-subpage' => 'яуап бирергә',
	'nstab-thread' => 'Тармаҡ',
	'nstab-summary' => 'Тасуирлама',
);

/** Bavarian (Boarisch)
 * @author Mucalexx
 */
$messages['bar'] = array(
	'lqt-new-messages' => 'Du host neiche Noochrichten',
	'searchprofile-threads' => 'Diskussionen',
	'tooltip-pt-newmessages' => "Zoagt neiche Noochrichten zua d' voh dir beówochteten Thémen óder d' zuaghering Dischkrirseiten",
	'lqt-newmessages-n' => 'Neiche Noochrichten ($1)',
	'lqt_newmessages' => 'Neiche Noochrichten',
	'lqt_newmessages-title' => 'Neiche Noochrichten',
	'lqt-newpost-summary' => 'Neicher Diskussionsstrång: $1',
);

/** Southern Balochi (بلوچی مکرانی)
 * @author Mostafadaneshvar
 */
$messages['bcc'] = array(
	'lqt_youhavenewmessages' => 'شما را هست $1.',
);

/** Belarusian (Беларуская)
 * @author Тест
 */
$messages['be'] = array(
	'lqt-drag-save' => 'Пацвердзіць',
	'lqt-drag-reason' => 'Прычына:',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Mormegil
 * @author Wizardist
 * @author Александр Сигачёв
 */
$messages['be-tarask'] = array(
	'lqt-desc' => 'Дадае галіны абмеркаваньняў у старонкі абмеркаваньняў',
	'lqt_movethread' => 'Перанесьці галіну на іншую старонку',
	'lqt_deletethread' => 'Выдаліць ці аднавіць галіну',
	'lqt_contents_title' => 'Зьмест',
	'lqt_toc_thread_title' => 'Назва галіны',
	'lqt_toc_thread_author' => 'Пачынаючы з',
	'lqt_toc_thread_replycount' => 'Адказаў',
	'lqt_toc_thread_modified' => 'Апошняя зьмена',
	'lqt_add_header' => 'Дадаць загаловак',
	'lqt_new_thread' => 'Пачаць новае абмеркаваньне',
	'lqt_invalid_subject' => 'Вы ўвялі няслушную назву тэмы. Верагодна яна:
* Занадта доўгая, альбо
* Канфліктуе з прэфіксамі інтэрвікі альбо прасторамі назваў.',
	'lqt_empty_subject' => 'Вам неабходна ўвесьці тэму.',
	'lqt_reply' => 'Адказаць',
	'lqt-parent' => 'Бацькоўская',
	'lqt_delete' => 'Выдаліць',
	'lqt_undelete' => 'Аднавіць',
	'lqt_permalink' => 'Спасылка сюды',
	'lqt_fragment' => 'Фрагмэнт $1 з $2',
	'lqt_discussion_link' => 'абмеркаваньне',
	'lqt_from_talk' => 'З $1',
	'lqt-history-title' => 'Гісторыя галіны',
	'lqt_hist_comment_edited' => 'Тэкст камэнтара [$2 адрэдагаваны]',
	'lqt_hist_summary_changed' => 'Вынік зьменены',
	'lqt_hist_reply_created' => 'Створаны [[$1|новы адказ]]',
	'lqt_hist_thread_created' => 'Створана новая галіна',
	'lqt_hist_deleted' => 'Выдалена',
	'lqt_hist_undeleted' => 'Адноўлена',
	'lqt_hist_moved_talkpage' => 'Перанесена',
	'lqt_hist_listing_subtitle' => 'Прагляд гісторыі',
	'lqt_hist_view_whole_thread' => 'Паказаць гісторыю для ўсёй галіны',
	'lqt_hist_no_revisions_error' => 'Гэта галіна ня мае ніякай гісторыі.',
	'lqt_hist_past_last_page_error' => 'Вы выйшлі за межы колькасьці старонак гісторыі, якія існуюць.',
	'lqt_hist_tooltip_newer_disabled' => 'Гэтая спасылка адключаная, таму што Вы знаходзіцеся на першай старонцы.',
	'lqt_hist_tooltip_older_disabled' => 'Гэта спасылка адключаная, таму што Вы знаходзіцеся на апошняй старонцы.',
	'lqt_hist_split' => 'Падзел адказу ў новую галіну',
	'lqt_hist_edited_subject' => 'Тэма зьмененая з «$2» на «$3»',
	'lqt_hist_edited_subject_corrupt' => 'Зьмененая тэма',
	'lqt_hist_merged_from' => '[[$1|Адказ]] перанесены ў іншую галіну',
	'lqt_hist_merged_to' => '[[$1|Адказ]] перанесены з іншай галіны',
	'lqt_hist_split_from' => 'Выдзелены ў новую галіну',
	'lqt_hist_root_blanked' => 'Выдалены тэкст камэнтара',
	'lqt_hist_adjusted_sortkey' => 'Удакладненая пазыцыя галіны',
	'lqt_revision_as_of' => 'Вэрсія ад $2, $3.',
	'lqt_change_new_thread' => 'Гэта пачатковая вэрсія галіны.',
	'lqt_change_reply_created' => '[$1 Пазначаны камэнтар] быў створаны ў гэтай вэрсіі.',
	'lqt_change_edited_root' => '[$1 Пазначаны камэнтар] рэдагаваўся ў гэтай вэрсіі.',
	'lqt_change_edited_summary' => 'Кароткае апісаньне галіны зьмененае',
	'lqt_change_deleted' => '[$1 Гэтая галіна] альбо адказ на яе быў выдалены',
	'lqt_change_undeleted' => '[$1 Пазначанае паведамленьне] было адноўленае',
	'lqt_change_moved' => '[$1 Гэта галіна] была перанесеная на іншую старонку абмеркаваньня',
	'lqt_change_split' => '[$1 Гэта галіна] была выдзеленая зь іншай галіны',
	'lqt_change_edited_subject' => 'Тэма гэтай галіны быў зьмененая з «$2» на «$3»',
	'lqt_change_merged_from' => '[$1 Адказ] на гэтую галіну быў перанесены ў іншую галіну',
	'lqt_change_merged_to' => '[$1 Пазначаны адказ] быў перанесены зь іншай галіны',
	'lqt_change_split_from' => '[$1 Падгаліна] гэтай галіны была выдзеленая ў асобную галіну',
	'lqt_change_root_blanked' => 'Тэкст [$1 камэнтара] быў выдалены.',
	'lqt_youhavenewmessages' => 'Вы атрымалі [[$1|новыя паведамленьні]].',
	'lqt_protectedfromreply' => 'Гэта галіна была $1 ад адказаў на яе.',
	'lqt_protectedfromreply_link' => 'абаронена',
	'lqt_subject' => 'Тэма:',
	'lqt_noreason' => 'Прычына не пазначана.',
	'lqt_move_placeholder' => 'Гэта галіна паказвае, што галіна $1 была перанесена з гэтай старонкі на іншую старонку абмеркаваньня.
Гэты перанос быў зроблены $3 $4 {{GENDER:$2|удзельнікам|удзельніцай}} $2. Галіна цяпер знаходзіцца на $5.',
	'lqt_thread_deleted_for_sysops' => "Гэта галіна была '''выдалена''' і бачна толькі адміністратарам.",
	'lqt_thread_deleted' => 'Гэта галіна была выдалена.',
	'lqt_summary_notice' => 'У гэтым абмеркаваньні не было зьменаў ужо $2 {{PLURAL:$2|дзень|дні|дзён}}.
Калі яно скончанае, Вы можаце $1.',
	'lqt_summary_notice_link' => 'падвесьці вынік',
	'lqt_summary_label' => 'Апісаньне галіны:',
	'lqt_summary_subtitle' => 'Вынік «$1»',
	'lqt_nosuchrevision' => 'У гэтай галіне няма такой вэрсіі.',
	'lqt_nosuchthread' => 'Галіна, якую Вы ўказалі, не існуе.',
	'lqt_nosuchthread_title' => 'Няма такога галіны',
	'lqt_threadrequired' => 'Вам неабходна пазначыць галіну ў URL-адрасе.',
	'lqt_move_movingthread' => 'Перанос $1.
Гэтая галіна зьяўляецца часткай $2.',
	'lqt_move_torename' => 'Каб зьмяніць назву гэтай галіны Вам неабходна $1 і зьмяніць поле «Тэма».',
	'lqt_move_torename_edit' => 'адрэдагаваць яе',
	'lqt_move_destinationtitle' => 'Назва мэтавай старонкі абмеркаваньня:',
	'lqt_move_move' => 'Перанесьці',
	'lqt_move_nodestination' => 'Вам неабходна пазначыць мэтавую старонку.',
	'lqt_move_thread_bad_destination' => 'Мэтавая старонка не зьяўляецца старонкай абмеркаваньня.',
	'lqt_move_samedestination' => 'Гэта галіна ўжо ёсьць на гэтай старонцы!',
	'lqt_move_noreason' => 'Прычына не пазначана.',
	'lqt_move_success' => 'Галіна была перанесена ў $1.',
	'lqt_delete_undeletethread' => 'Аднаўленьне галіны',
	'lqt_delete_partof' => "Гэтая галіна зьяўляецца часткай '''$1'''.",
	'lqt_delete_deleting' => "Выдаленьне '''$1''' і '''усіх адказаў''' на яе.",
	'lqt_delete_deletethread' => 'Выдаліць галіну і адказы',
	'lqt_delete_deleted' => 'Галіна была выдалена.',
	'lqt_delete_undeleted' => 'Галіна была адноўлена.',
	'lqt_delete_return' => 'Вярнуцца да $1.',
	'lqt_delete_return_link' => 'старонка абмеркаваньня',
	'lqt_delete_unallowed' => 'Вам не дазволена выдаляць галіны.',
	'lqt_delete_show_checkbox' => 'Паказаць выдаленыя галіны',
	'lqt_talkpage_autocreate_summary' => 'Старонка абмеркаваньня была створана аўтаматычна, калі было створаная першая галіна.',
	'lqt_header_warning_big' => 'Вы рэдагуеце $1.',
	'lqt_header_warning_after_big' => "Загалоўкі ўжываюцца для аб'яваў і ўводных частак.
Замест гэтага Вы можаце $2.",
	'lqt_header_warning_bold' => 'загаловак старонкі абмеркаваньня',
	'lqt_header_warning_new_discussion' => 'пачаць новае абмеркаваньне',
	'lqt_sorting_order' => 'Парадак сартыроўкі:',
	'lqt_sort_newest_changes' => 'апошнія зьмененыя спачатку',
	'lqt_sort_newest_threads' => 'найноўшыя галіны спачатку',
	'lqt_sort_oldest_threads' => 'найстарэйшыя галіны спачатку',
	'lqt-title' => 'Назва',
	'lqt-summary' => 'Вынік',
	'lqt-searching' => 'Пошук па галінах',
	'lqt-read-message' => 'Пазначанае як прачытанае',
	'lqt-read-message-tooltip' => 'Выдаліць гэтую галіну з новых паведамленьняў.
Яна ўсё яшчэ будзе бачна ў пачатковай старонцы абмеркаваньня.',
	'lqt-read-all' => 'Пазначыць усе як прачытаныя',
	'lqt-read-all-tooltip' => 'Выдаліць усе галіны з новых паведамленьняў.
Яны ўсё яшчэ будуць бачныя ў пачатковай старонцы абмеркаваньня.
Гэтае дзеяньне немагчыма адмяніць.',
	'lqt-marked-read' => "Галіна '''$1''' пазначана як прачытаная.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|паведамленьне пазначанае як прачытанае|паведамленьні пазначаныя як прачынаныя|паведамленьняў пазначаныя як прачынаныя}}.',
	'lqt-email-undo' => 'Адмяніць',
	'lqt-no-new-messages' => 'Для Вас няма новых паведамленьняў.',
	'lqt-new-messages' => '✒ Для Вас ёсьць новыя паведамленьні.',
	'lqt-email-info-undo' => 'Вярнуць галіну якую Вы толькі што прапусьцілі.',
	'lqt-date-info' => 'Спасылка была адключана, таму што Вы праглядаеце галіны з любымі датамі.',
	'lqt-newmessages-context' => 'Поўная галіна',
	'lqt-thread-created' => 'Створаная',
	'lqt-history-time' => 'Час',
	'lqt-history-user' => 'Удзельнік',
	'lqt-history-action' => 'Актыўнасьць',
	'lqt-history-comment' => 'Камэнтар',
	'lqt-history-thread' => 'Галіна',
	'lqt-thread-edited-author' => 'Рэдагаваная аўтарам.<br />
Апошняе рэдагаваньне: $1',
	'lqt-thread-edited-others' => 'Рэдагаваная $2  {{PLURAL:$2|іншым удзельнікам|іншымі ўдзельнікамі|іншымі ўдзельнікамі}}.<br />
Апошняе рэдагаваньне: $1',
	'lqt-header-actions' => 'Дзеяньні',
	'lqt_summarize_link' => 'Падвесьці вынік',
	'lqt-summarize-intro' => 'Калі ласка, падвядзіце вынікі галіны ў полі рэдагаваньня.
Вы можаце выкарыстоўваць любы вікі-тэкст пры падвядзеньні вынікаў. Калі Вы скончыце, націсьніце «{{int:savearticle}}».',
	'lqt-thread-split' => 'Выдзеліць у новую галіну',
	'lqt-split-success' => 'Вы пасьпяхова падзялілі галіну $1.',
	'lqt_split_thread' => 'Падзяліць галіну',
	'lqt-thread-split-subject' => 'Тэма новай галіны:',
	'lqt-thread-split-thread' => 'Галіна:',
	'lqt-split-submit' => 'Падзяліць',
	'lqt_split_badsubject' => 'Уведзеная Вамі назва — няслушная.',
	'lqt-no-threads' => 'На гэтай старонцы пакуль няма галінаў.',
	'lqt-delete-parent-warning' => 'Гэта верхняя галіна з адказамі.
Усе адказы будуць аўтаматычна выдаленыя.
Каб пазьбегнуць гэтага, вынесіце іх з гэтай галіны перад выдаленьнем.',
	'lqt-delete-parent-deleted' => 'Бацькоўская галіна выдаленая ($1)',
	'lqt-delete-replies-done' => 'Усе адказы гэтай галіны былі так сама выдаленыя.',
	'lqt-movethread' => 'Перанесьці',
	'lqt-menu-trigger' => 'Болей',
	'lqt-newmessages-from' => 'Ад $1',
	'lqt-hot-topics' => 'Папулярныя тэмы',
	'lqt-add-reply' => 'Дадаць адказ',
	'lqt_rc_new_discussion' => 'створаная новая галіна «$1»',
	'lqt_rc_new_reply' => 'напісаны адказ на «$1»',
	'right-lqt-split' => 'падзел галінаў',
	'right-lqt-merge' => "аб'яднаньне галінаў",
	'lqt-thread-merge' => "Аб'яднаць у іншую галіну",
	'lqt-thread-merge-to' => "Аб'яднаць у гэту галіну",
	'lqt_merge_thread' => "Аб'яднаць галіну",
	'lqt-thread-merge-source' => 'Крынічная галіна:',
	'lqt-thread-merge-dest' => 'Мэтавая галіна:',
	'lqt-merge-submit' => "Аб'яднаць",
	'lqt-merge-success' => "Вы пасьпяхова аб'ядналі галіну $1 з $2.",
	'lqt-log-name' => 'Журнал галінаў абмеркаваньняў',
	'lqt-log-header' => 'Гэты журнал утрымлівае дэталі дзеяньняў, якія адбываюцца ў галінах абмеркаваньняў.',
	'lqt-log-action-move' => 'перанесеная [[$1]] з [[$2]] у [[$3]].',
	'lqt-log-action-split' => 'выдзеленая [[$1]] з [[$3]], з новай тэмай «$2».',
	'lqt-log-action-merge-across' => 'перанесеная [[$1]] з [[$2]] у [[$3]].',
	'lqt-log-action-merge-down' => "аб'яднаная [[$1]] у [[$3]]",
	'lqt-log-action-subjectedit' => 'зьмененая тэма [[$1]] з «$2» на «$3»',
	'lqt-log-action-resort' => 'зьмененая сартаваньне [[$1]]. Зьменены ключа сартаваньня з $2 на $3.',
	'lqt-preference-notify-talk' => 'Дасылаць мне электронныя лісты ў выпадках адказаў у галіне, за якой я назіраю',
	'lqt-preference-watch-threads' => 'Дадаваць у мой сьпіс назіраньня галіны, якія я буду ствараць альбо на якія я буду адказваць',
	'prefs-lqt' => 'Галіны абмеркаваньняў',
	'lqt-preference-display-depth' => 'Максымальная глыбіня адказаў для паказу:',
	'lqt-preference-display-count' => 'Максымальная колькасьць адказаў для паказу:',
	'lqt-preference-custom-signatures' => 'Паказваць нестандартныя подпісы ўдзельнікаў',
	'lqt-enotif-subject-reply' => 'Абмеркаваньне {{GRAMMAR:родны|{{SITENAME}}}} — Адказ: $1',
	'lqt-enotif-subject-newthread' => 'Абмеркаваньне {{GRAMMAR:родны|{{SITENAME}}}} — Новая галіна: $1',
	'lqt-enotif-newthread' => "Вітаем $1,

Гэта паведамленьне з {{GRAMMAR:родны|{{SITENAME}}}} пра новую галіну $5, '$2', 
створаную $3 $4 удзельнікам $8.

Вы можаце паглядзець яе на <$6>

Тэкст паведамленьня:
$7",
	'lqt-enotif-reply' => "Вітаем, $1!

Гэта паведамленьне з {{GRAMMAR:родны|{{SITENAME}}}} пра новы адказ '$2' на старонцы $5, 
створаны ў $4 $3 удзельнікам $8.

Вы можаце паглядзець яго на <$6>.

Тэкст адказу:
$7",
	'lqt-quote-intro' => '$2 $3 [[User:$1|$1]] {{GENDER:$1|напісаў|напісала}}:',
	'lqt-quote' => 'Цытаваць',
	'lqt-search-legend' => 'Пошук абмеркаваньняў на гэтай старонцы',
	'lqt-search-label' => 'Умовы пошуку:',
	'lqt-search-button' => 'Знайсьці',
	'searchprofile-threads' => 'Абмеркаваньні',
	'searchprofile-threads-tooltip' => 'Пошук у абмеркаваньнях па галінам і на старонках абмеркаваньняў',
	'lqt-ajax-updated' => 'У гэтай галіне ёсьць новыя паведамленьні.',
	'lqt-ajax-update-link' => 'Абнавіць',
	'lqt-thread-show-replies' => 'Паказаць $1 {{PLURAL:$1|адказ|адказы|адказаў}}',
	'lqt-thread-show-more' => 'Паказаць болей адказаў',
	'lqt-thread-link-url' => 'URL-спасылка:',
	'lqt-thread-link-title' => 'Вікі-спасылка:',
	'lqt-thread-link-copy' => 'Капіяваць у буфэр абмену',
	'lqt-sign-not-necessary' => 'Няма неабходнасьці падпісваць Ваша паведамленьне чатырма тыльдамі.
Подпіс паказваецца аўтаматычна.',
	'lqt-marked-as-read-placeholder' => 'Галіна $1 была пазначаная як прачытаная.',
	'lqt-change-subject' => 'Зьмяніць тэму',
	'lqt-save-subject' => 'Захаваць',
	'lqt-save-subject-failed' => 'Адбылася наступная памылка пад час спробы зьмяніць тэму гэтай галіны: $1',
	'lqt-ajax-invalid-subject' => 'Пададзеная тэма зьяўляецца няслушнай, верагодна таму, што занадта даўгая.',
	'lqt-ajax-no-subject' => 'Неабходна пазначыць тэму новай галіны.',
	'lqt-save-subject-error-unknown' => 'Адбылася невядомая памылка пад час спробы ўстанавіць тэму гэтай галіны. Калі ласка, паспрабуйце зрабіць гэта націснуўшы «рэдагаваць» у верхняй частцы паведамленьня.',
	'lqt-cancel-subject-edit' => 'Скасаваць',
	'lqt-drag-activate' => 'Перанесьці ў новае месца',
	'lqt-drag-drop-zone' => 'Пакінуць тут',
	'lqt-drag-confirm' => 'Для сканчэньня новага дзеяньня, калі ласка пазначце прычыну і націсьніце «Пацьвердзіць».',
	'lqt-drag-reparent' => 'Перанесьці паведамленьне ў ніз новага бацькоўскага элемэнту.',
	'lqt-drag-split' => 'Перанесьці паведамленьне ў асобную галіну',
	'lqt-drag-setsortkey' => 'Устанавіць пазыцыю паведамленьня на старонцы',
	'lqt-drag-bump' => 'Перанесьці паведамленьне ўверх старонкі абмеркаваньня',
	'lqt-drag-save' => 'Пацьвердзіць',
	'lqt-drag-title' => 'Пацьвердзіць перанос',
	'lqt-drag-reason' => 'Прычына:',
	'lqt-drag-subject' => 'Тэма новай галіны (абавязкова):',
	'lqt-edit-signature' => '(рэдагаваць подпіс)',
	'lqt-preview-signature' => '(папярэдні прагляд)',
	'lqt-feed-title-all' => '{{SITENAME}} — Новыя запісы',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Новыя запісы $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Новыя галіны',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Новыя галіны $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Адказы',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Адказы $1',
	'lqt-feed-new-thread-intro' => 'Новая галіна на $1 разьмешчаная $2',
	'lqt-feed-reply-intro' => 'Адказ на $3 (на $1) разьмешчаны $2',
	'tooltip-pt-newmessages' => 'Паказвае новыя паведамленьні ў галінах альбо на старонках абмеркаваньня, за якімі Вы назіраеце',
	'lqt-newmessages-n' => 'Новыя паведамленьні ($1)',
	'lqt_newmessages' => 'Мае новыя паведамленьні (Няма)',
	'lqt_newmessages-title' => 'Новыя паведамленьні',
	'lqt-newpost-summary' => 'Новая галіна: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Калі ласка, увядзіце Ваш тэкст для гэтай галіны. Потым Вы павінны выдаліць гэты радок.',
	'lqt-reply-summary' => 'Адказаць на [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Гісторыя старонкі абмеркаваньня',
	'lqt-talkpage-history-subtitle' => 'Для $1',
	'lqt-talkpage-history-tab' => 'Загаловак',
	'restriction-reply' => 'Напісаць адказы',
	'restriction-newthread' => 'Стварыць новыя галіны',
	'lqt-protected-reply-thread' => 'Вы ня можаце пісаць у гэтай галіне, таму што яна была абароненая ад новых запісаў.',
	'lqt-protected-reply-talkpage' => 'Вы ня можаце пісаць у гэтай галіне, таму што гэта старонка абмеркаваньня была абароненая ад адказаў у яе галінах.',
	'lqt-protected-newthread' => 'Вы ня можаце ствараць новыя галіны на гэтай старонцы абмеркаваньня, таму што яна была абароненая ад стварэньня новых галінаў.',
	'lqt-edit-bump' => 'Узьняць гэту галіну',
	'lqt-edit-bump-tooltip' => 'Перанесьці гэту галіну ў верхнюю частку старонкі абмеркаваньня',
	'lqt-historicalrevision-error' => 'Вэрсія, якую Вы выбралі, пашкоджаная і ня можа быць паказаная.',
	'lqt-reply-subpage' => 'адказаць',
	'nstab-thread' => 'Галіна',
	'nstab-summary' => 'Апісаньне',
);

/** Bulgarian (Български)
 * @author DCLXVI
 * @author Rancher
 * @author Spiritia
 * @author Turin
 */
$messages['bg'] = array(
	'lqt-desc' => 'Добавяне към беседите на разклонени дискусии',
	'lqt_movethread' => 'Преместване на нишка към друга страница',
	'lqt_deletethread' => 'Изтриване или възстановяване на нишка',
	'lqt_contents_title' => 'Съдържание',
	'lqt_toc_thread_title' => 'Заглавие на нишката',
	'lqt_toc_thread_author' => 'Започнато от',
	'lqt_toc_thread_replycount' => 'Отговори',
	'lqt_toc_thread_modified' => 'Последна промяна',
	'lqt_new_thread' => 'Започване на нова дискусия.',
	'lqt_invalid_subject' => 'Заглавието на тема, което въведохте, е неприемливо.
Може би е:
* твърде дълго или
* е в конфликт с представките за интеруики или запазените области с имена.',
	'lqt_empty_subject' => 'Трябва да въведете тема',
	'lqt_reply' => 'Отговор',
	'lqt_delete' => 'Изтриване',
	'lqt_undelete' => 'Възстановяване',
	'lqt_permalink' => 'Постоянна препратка',
	'lqt_discussion_link' => 'обсъждане',
	'lqt_from_talk' => 'От $1',
	'lqt-history-title' => 'История на нишката',
	'lqt_hist_comment_edited' => 'Текст на коментара [$2 редактиран]',
	'lqt_hist_summary_changed' => 'Променено резюме',
	'lqt_hist_reply_created' => 'Добавен е [[$1|нов отговор]]',
	'lqt_hist_thread_created' => 'Започната нова нишка',
	'lqt_hist_deleted' => 'Изтрито',
	'lqt_hist_undeleted' => 'Възстановено',
	'lqt_hist_moved_talkpage' => 'Преместено',
	'lqt_hist_listing_subtitle' => 'Преглед на историята',
	'lqt_hist_view_whole_thread' => 'Преглед на историята на цялата нишка',
	'lqt_hist_no_revisions_error' => 'Тази нишка няма промени в историята си.',
	'lqt_hist_past_last_page_error' => 'Отвъд броя на страниците в историята сте.',
	'lqt_hist_tooltip_newer_disabled' => 'Препратката е неактивна, тъй като сте на първата страница.',
	'lqt_hist_tooltip_older_disabled' => 'Препратката е неактивна, тъй като сте на последната страница.',
	'lqt_hist_split' => 'Отговорът е отделен в нова нишка',
	'lqt_hist_edited_subject' => 'Темата е променена от "$2" на "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Темата е променена',
	'lqt_hist_merged_from' => '[[$1|Този отговор]] е преместен в друга тема',
	'lqt_hist_merged_to' => '[[$1|Този отговор]] е преместен тук от друга тема',
	'lqt_hist_split_from' => 'Отделяне в нова нишка',
	'lqt_hist_root_blanked' => 'Премахнат текст на коментар',
	'lqt_revision_as_of' => 'Версия от $3 на $2.',
	'lqt_change_new_thread' => 'Това е първоначалната версия на темата.',
	'lqt_change_reply_created' => '[$1 Осветеният коментар] е въведен с тази версия на страницата.',
	'lqt_change_edited_root' => '[$1 Осветеният коментар] е променен в тази версия на страницата.',
	'lqt_change_edited_summary' => 'Резюмето на темата беше редактирано',
	'lqt_change_deleted' => '[$1 Тази тема] или нейна родителска тема е била изтрита',
	'lqt_change_undeleted' => '[$1 Осветената реплика] беше възстановена',
	'lqt_change_moved' => '[$1 Тази тема] беше преместена на друга дискусионна страница',
	'lqt_change_split' => '[$1 Тази тема] беше отделена от друга тема и обособена като самостоятелна',
	'lqt_change_edited_subject' => 'Заглавието на тази тема беше променено от "$2" на "$3"',
	'lqt_change_merged_from' => '[$1 Отговор] по тази тема беше преместен към друга тема',
	'lqt_change_merged_to' => '[$1 Осветеният отговор] беше преместен тук от друга тема',
	'lqt_change_split_from' => '[$1 Част] от тази тема беше обособена като самостоятелна тема',
	'lqt_change_root_blanked' => 'Текстът на [$1 този коментар] беше премахнат.',
	'lqt_youhavenewmessages' => 'Имате [[$1|ново/нови съобщение/съобщения]].',
	'lqt_protectedfromreply' => 'Тази нишка е била $1 за следващи коментари.',
	'lqt_protectedfromreply_link' => 'защитена',
	'lqt_subject' => 'Тема:',
	'lqt_noreason' => 'Не е указана причина.',
	'lqt_thread_deleted_for_sysops' => "Тази тема е била '''изтрита''' и е видима само за администратори.",
	'lqt_thread_deleted' => 'Нишката е била изтрита.',
	'lqt_summary_notice' => 'Не са правени промени по тази дискусия от поне $2 {{PLURAL:$2|ден|дни}}.
Ако обсъждането е приключило, може би искате да го $1.',
	'lqt_summary_notice_link' => 'резюмирате',
	'lqt_summary_label' => 'Резюме на нишката:',
	'lqt_summary_subtitle' => 'Резюме на "$1".',
	'lqt_nosuchrevision' => 'Не съществува такава версия на тази нишка.',
	'lqt_nosuchthread' => 'Посочената тема не съществува.',
	'lqt_nosuchthread_title' => 'Няма такава тема',
	'lqt_threadrequired' => 'Трябва да се укаже нишка в URL.',
	'lqt_move_movingthread' => 'Преместване на $1. Тази нишка е част от $2.',
	'lqt_move_torename' => 'За преименуване на тази нишка е необходимо да $1 и променете полето „Тема“.',
	'lqt_move_torename_edit' => 'редактиране',
	'lqt_move_destinationtitle' => 'Заглавие на целевата дискусионна страница:',
	'lqt_move_move' => 'Преместване',
	'lqt_move_nodestination' => 'Необходимо е да се посочи цел.',
	'lqt_move_thread_bad_destination' => 'Целевата страница на предприетото преместване не е дискусионна страница.',
	'lqt_move_samedestination' => 'На страницата вече има такава тема!',
	'lqt_move_noreason' => 'Не е указана причина.',
	'lqt_move_success' => 'Нишката беше преместена като $1.',
	'lqt_delete_undeletethread' => 'Възстановяване на нишка',
	'lqt_delete_partof' => "Тази тема е част от '''$1'''.",
	'lqt_delete_deleting' => "Изтриване на темата '''$1''' и всички отговори по нея.",
	'lqt_delete_deletethread' => 'Изтриване на нишката и отговорите',
	'lqt_delete_deleted' => 'Нишката беше изтрита.',
	'lqt_delete_undeleted' => 'Нишката беше възстановена.',
	'lqt_delete_return' => 'Връщане към $1.',
	'lqt_delete_return_link' => 'беседата',
	'lqt_delete_unallowed' => 'Нямате права да изтривате нишки.',
	'lqt_delete_show_checkbox' => 'Показване на изтритите нишки',
	'lqt_talkpage_autocreate_summary' => 'Дискусионната страница е създадена автоматично със започването на първата нишка.',
	'lqt_header_warning_big' => 'Редактирате $1.',
	'lqt_header_warning_new_discussion' => 'започване на ново обсъждане',
	'lqt_sorting_order' => 'Ред за сортиране:',
	'lqt_sort_newest_changes' => 'първо последно променените',
	'lqt_sort_newest_threads' => 'първо най-новите нишки',
	'lqt_sort_oldest_threads' => 'първо най-старите нишки',
	'lqt-title' => 'Заглавие',
	'lqt-summary' => 'Резюме',
	'lqt-searching' => 'Търсене за нишки',
	'lqt-read-message' => 'Отбелязване като прочетено',
	'lqt-read-message-tooltip' => 'Премахване на тази нишка от новите съобщения.
Тя ще продължи да се вижда на оригиналната дискусионна страница.',
	'lqt-read-all' => 'Отбелязване на всички като прочетени',
	'lqt-marked-read' => "Нишка '''$1''' е отбелязана като прочетена.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|съобщение, отбелязано като прочетено|съобщения, отбелязани като прочетени}}.',
	'lqt-email-undo' => 'Отмяна',
	'lqt-no-new-messages' => 'Нямате нови съобщения.',
	'lqt-new-messages' => '✒ Имате нови съобщения.',
	'lqt-date-info' => 'Тази връзка е деактивирана, тъй като преглеждате нишките от всички дати.',
	'lqt-newmessages-context' => 'Цяла нишка',
	'lqt-thread-created' => 'Създадено',
	'lqt-history-time' => 'Време',
	'lqt-history-user' => 'Потребител',
	'lqt-history-action' => 'Активност',
	'lqt-history-comment' => 'Коментар',
	'lqt-history-thread' => 'Нишка',
	'lqt-thread-edited-author' => 'Редактирано от автора.<br />
Последна редакция: $1',
	'lqt-thread-edited-others' => 'редактирано от {{PLURAL:$2|друг потребител|други $2 потребители}}.<br />
Последна редакция: $1',
	'lqt-header-actions' => 'Действия',
	'lqt_summarize_link' => 'Обобщение',
	'lqt-thread-split' => 'Обособяване в нова тема',
	'lqt-split-success' => 'Успешно обособихте в нова нишка темата $1.',
	'lqt_split_thread' => 'Разделяне на нишка',
	'lqt-thread-split-subject' => 'Заглавие на новата нишка',
	'lqt-thread-split-thread' => 'Нишка:',
	'lqt-split-submit' => 'Разделяне',
	'lqt_split_badsubject' => 'Въведеното от вас заглавие е невалидно.',
	'lqt-no-threads' => 'На тази страници все още няма нишки',
	'lqt-delete-parent-deleted' => 'Родителската тема ($1) е изтита',
	'lqt-delete-replies-done' => 'Всички отговори по тази тема също са били изтрити.',
	'lqt-movethread' => 'Преместване',
	'lqt-menu-trigger' => 'Още',
	'lqt-newmessages-from' => 'От $1',
	'lqt-hot-topics' => 'Горещи теми',
	'lqt-add-reply' => 'Добавяне на отговор',
	'lqt_rc_new_discussion' => 'публикува нова нишка, "$1"',
	'lqt_rc_new_reply' => 'публикува отговор на "$1"',
	'right-lqt-split' => 'Разделяне на нишки',
	'right-lqt-merge' => 'Сливане на нишки',
	'lqt-thread-merge' => 'Сливане с друга нишка',
	'lqt-thread-merge-to' => 'Сливане с тази нишка',
	'lqt_merge_thread' => 'Сливане на нишка',
	'lqt-thread-merge-source' => 'Начална нишка:',
	'lqt-thread-merge-dest' => 'Крайна нишка:',
	'lqt-merge-submit' => 'Сливане',
	'lqt-merge-success' => 'Успешно сляхте нишката $1 с $2.',
	'lqt-preference-notify-talk' => 'Получаване на писма за отговорите по темите, които наблюдавам',
	'lqt-preference-watch-threads' => 'Наблюдение на темите, които отварям и по които отговарям',
	'lqt-preference-display-depth' => 'Максимална дълбочина на отговорите за показване:',
	'lqt-preference-display-count' => 'Максимален брой на отговорите за показване:',
	'lqt-preference-custom-signatures' => 'Показване на настройваемите потребителски подписи',
	'lqt-enotif-subject-reply' => '{{SITENAME}} обсъждане - Отговор: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} обсъждане - Нова нишка: $1',
	'lqt-quote-intro' => 'На $2 в $3 [[User:$1|$1]] написа:',
	'lqt-quote' => 'Цитат',
	'lqt-search-legend' => 'Търсене на обсъжданията в тази страница',
	'lqt-search-label' => 'Условия на търсенето:',
	'lqt-search-button' => 'Търсене',
	'searchprofile-threads' => 'Дискусии',
	'searchprofile-threads-tooltip' => 'Търсене на нишките обсъждания и страниците с беседи',
	'lqt-ajax-updated' => 'Тази нишка има нови публикации.',
	'lqt-ajax-update-link' => 'Актуализиране',
	'lqt-thread-show-replies' => 'Показване на $1 {{PLURAL:$1|отговор|отговора}}',
	'lqt-thread-show-more' => 'Показване на още отговори',
	'lqt-thread-link-url' => 'URL на препратката:',
	'lqt-thread-link-title' => 'Уикитекст на препратката:',
	'lqt-thread-link-copy' => 'Копиране в системния буфер',
	'lqt-sign-not-necessary' => 'Не е нужно да подписвате коментара си с четири вълнички. 
Подписът ви ще се покаже автоматично.',
	'lqt-marked-as-read-placeholder' => 'Тема $1 беше отбелязана като прочетена.',
	'lqt-change-subject' => 'Смяна на темата',
	'lqt-save-subject' => 'Съхраняване',
	'lqt-save-subject-failed' => 'Следната грешка възникна при опита за промяна на темата на нишката:  $1',
	'lqt-ajax-invalid-subject' => 'Указаното от вас име на тема е невалидно, вероятно защото е твърде дълго.',
	'lqt-ajax-no-subject' => 'Трябва да зададете тема.',
	'lqt-cancel-subject-edit' => 'Отказване',
	'lqt-drag-activate' => 'Завлачете до новото място',
	'lqt-drag-drop-zone' => 'Пуснете тук',
	'lqt-drag-split' => 'Преместване на публикацията в нейната си нишка',
	'lqt-drag-setsortkey' => 'Нагласяне разположението на публикацията в страницата',
	'lqt-drag-save' => 'Потвърждение',
	'lqt-drag-reason' => 'Причина:',
	'lqt-drag-subject' => 'Заглавие на новата нишка:',
	'lqt-edit-signature' => '(редактиране на подписа)',
	'lqt-preview-signature' => '(преглед)',
	'lqt-feed-title-all' => '{{SITENAME}} — Нови публикации',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Нови публикации от $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Нови нишки',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Нови нишки от $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Отговори',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Отговори от $1',
	'lqt-feed-new-thread-intro' => 'Нова нишка в $1, публикувана от $2',
	'lqt-newmessages-n' => 'Нови съобщения ($1)',
	'lqt_newmessages' => 'Моите нови съобщения (няма)',
	'lqt_newmessages-title' => 'Нови съобщения',
	'lqt-newpost-summary' => 'Нова нишка: $1',
	'lqt-reply-summary' => 'Отговор на [[$2|$1]]',
	'lqt-talkpage-history-title' => 'История на страницата за беседа',
	'lqt-talkpage-history-subtitle' => 'За $1',
	'restriction-reply' => 'Публикуване на отговори',
	'restriction-newthread' => 'Публикуване на нови дискусии',
	'lqt-protected-reply-thread' => 'Не можете да публикувате по тази тема, защото дискусионната страница е била защитена срещу нови публикации.',
	'lqt-protected-reply-talkpage' => 'Не можете да публикувате по тази тема, защото дискусионната страница е била защитена срещу отговори.',
	'lqt-edit-bump' => 'Побутване на тази нишка',
	'lqt-edit-bump-tooltip' => 'Преместване на нишката в началото на страницата за обсъждане',
	'lqt-reply-subpage' => 'отговор',
	'nstab-thread' => 'Нишка',
	'nstab-summary' => 'Обобщение',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Ehsanulhb
 * @author Wikitanvir
 * @author Zaheen
 */
$messages['bn'] = array(
	'lqt-desc' => 'আলাপের পাতায় থ্রেডিং আলোচনা ব্যবস্থা যোগ হবে।',
	'lqt_movethread' => 'থ্রেড অন্য পাতায় সরিয়ে নাও',
	'lqt_deletethread' => 'থ্রেড অপসারণ অথবা পুনরুদ্ধার করুন',
	'lqt_contents_title' => 'বিষয়বস্তু',
	'lqt_toc_thread_title' => 'থ্রেড শিরোনাম',
	'lqt_toc_thread_author' => 'সূচনাকারী',
	'lqt_toc_thread_replycount' => 'উত্তর',
	'lqt_toc_thread_modified' => 'সর্বশেষ পরিবর্তন',
	'lqt_add_header' => 'শীর্ষচরণ যোগ',
	'lqt_new_thread' => 'একটি নতুন আলোচনা শুরু করো',
	'lqt_empty_subject' => 'আপনাকে অবশ্যই একটি বিষয় লিখতে হবে।',
	'lqt_reply' => 'উত্তর',
	'lqt_delete' => 'মুছে ফেলা হোক',
	'lqt_undelete' => 'পুনরুদ্ধার',
	'lqt_permalink' => 'সংযোগ',
	'lqt_discussion_link' => 'আলোচনা',
	'lqt_from_talk' => '$1 হতে',
	'lqt-history-title' => 'থ্রেড ইতিহাস',
	'lqt_hist_comment_edited' => 'মন্তব্য লেখা [$2 সম্পাদিত]',
	'lqt_hist_summary_changed' => 'সারাংশ পরিবর্তন হয়েছে',
	'lqt_hist_reply_created' => '[[$1|নতুন উত্তর]] তৈরি করা হয়েছে',
	'lqt_hist_thread_created' => 'নতুন থ্রেড তৈরি করা হয়েছে',
	'lqt_hist_deleted' => 'অপসারিত',
	'lqt_hist_undeleted' => 'পুনরুদ্ধার করা হয়েছে',
	'lqt_hist_moved_talkpage' => 'সরিয়ে নেওয়া হয়েছে',
	'lqt_hist_view_whole_thread' => 'থ্রেডের সম্পূর্ণ ইতিহাস দেখাও',
	'lqt_hist_split' => 'উত্তরটি নতুন থ্রেডে পৃথক করো',
	'lqt_hist_edited_subject' => '"$2" থেকে "$3" -এ বিষয় পরিবর্তন করা হয়েছে',
	'lqt_hist_edited_subject_corrupt' => 'পরিবর্তিত বিষয়',
	'lqt_hist_merged_from' => '[[$1|উত্তরটি]] অন্য থ্রেডে স্থানান্তর করো',
	'lqt_hist_merged_to' => '[[$1|উত্তরটি]] অন্য থ্রেড হতে এখানে স্থানান্তর করো',
	'lqt_hist_split_from' => 'নতুন থ্রেডে পৃথক করো',
	'lqt_hist_root_blanked' => 'মন্তব্যের লেখা অপসারিত হয়েছে',
	'lqt_youhavenewmessages' => 'আপনার [[$1|নতুন বার্তা]] রয়েছে।',
	'lqt_protectedfromreply_link' => 'সুরক্ষিত',
	'lqt_subject' => 'বিষয়:',
	'lqt_noreason' => 'কোনো কারণ দেওয়া হয়নি।',
	'lqt_thread_deleted' => 'থ্রেডটি মুছে ফেলা হয়েছে।',
	'lqt_summary_notice_link' => 'একটি সারাংশ লিখুন',
	'lqt_summary_label' => 'থ্রেড সারাংশ:',
	'lqt_summary_subtitle' => '"$1" এর সারাংশ',
	'lqt_nosuchthread_title' => 'এমন কোনো থ্রেড নাই',
	'lqt_move_torename_edit' => 'এটি সম্পাদনা করুন',
	'lqt_move_move' => 'স্থানান্তর',
	'lqt_move_thread_bad_destination' => 'গন্তব্য পাতাটি কোনো আলোচনা পাতা নয়।',
	'lqt_move_noreason' => 'কোনো কারণ দেওয়া হয়নি।',
	'lqt_delete_undeletethread' => 'থ্রেড পুনরুদ্ধার',
	'lqt_delete_partof' => "এই থ্রেডটি '''$1''' এর একটি অংশ।",
	'lqt_delete_deletethread' => 'থ্রেড এবং উত্তরসমূহ অপসারণ',
	'lqt_delete_deleted' => 'থ্রেড অপসারণ করা হয়েছে।',
	'lqt_delete_undeleted' => 'থ্রেড পুনরুদ্ধার করা হয়েছে।',
	'lqt_delete_return' => '$1 এ ফিরে যান।',
	'lqt_delete_return_link' => 'আলাপের পাতা',
	'lqt_delete_show_checkbox' => 'অপসারিত থ্রেডগুলো দেখাও',
	'lqt_header_warning_big' => 'আপনি একটি $1 সম্পাদনা করছেন।',
	'lqt_header_warning_bold' => 'আলোচনা পাতার শীর্ষচরণ',
	'lqt_header_warning_new_discussion' => 'একটি নতুন আলোচনা শুরু করো',
	'lqt_sorting_order' => 'ক্রমায়ন বিন্যাস:',
	'lqt_sort_newest_changes' => 'সর্বোশেষ পরিবর্তনটি প্রথমে',
	'lqt_sort_newest_threads' => 'নতুন থ্রেড প্রথমে',
	'lqt_sort_oldest_threads' => 'পুরাতন থ্রেড প্রথমে',
	'lqt-title' => 'শিরোনাম',
	'lqt-summary' => 'সারাংশ',
	'lqt-searching' => 'থ্রেড অনুসন্ধান করা হচ্ছে',
	'lqt-read-message' => 'পঠিত বলে চিহ্নিত',
	'lqt-read-all' => 'সব পঠিত বলে চিহ্নিত',
	'lqt-marked-read' => "থ্রেড '''$1''' পঠিত বলে চিহ্নিত হয়েছে।",
	'lqt-email-undo' => 'পূর্বাবস্থায় ফেরাও',
	'lqt-no-new-messages' => 'আপনার জন্য নতুন কোনো বার্তা নেই।',
	'lqt-new-messages' => '✒ আপনার জন্য নতুন বার্তা রয়েছে।',
	'lqt-newmessages-context' => 'সম্পূর্ণ থ্রেড',
	'lqt-thread-created' => 'তৈরি হয়েছে',
	'lqt-history-time' => 'সময়',
	'lqt-history-user' => 'ব্যবহারকারী',
	'lqt-history-action' => 'কর্মকান্ড',
	'lqt-history-comment' => 'মন্তব্য',
	'lqt-history-thread' => 'থ্রেড',
	'lqt-thread-edited-author' => 'লেখক দ্বারা সম্পাদিত<br />
শেষ সম্পাদনা: $1',
	'lqt-thread-edited-others' => 'অন্য {{PLURAL:$2|অন্য ব্যবহারকারী|$2 জন ব্যবহারকারী}} দ্বারা সম্পাদিত<br />
শেষ সম্পাদনা: $1',
	'lqt-header-actions' => 'কার্য',
	'lqt_summarize_link' => 'সারসংক্ষেপ',
	'lqt-thread-split' => 'নতুন থ্রেডে আলাদা করো',
	'lqt_split_thread' => 'একটি থ্রেড পৃথক করো',
	'lqt-thread-split-subject' => 'নতুন থ্রেডের বিষয়:',
	'lqt-thread-split-thread' => 'থ্রেড:',
	'lqt-split-submit' => 'পৃথক',
	'lqt_split_badsubject' => 'আপনার দেওয়া বিষয়টি সঠিক নয়।',
	'lqt-delete-parent-deleted' => 'মূল থ্রেড অপসারণ করা হয়েছে ($1)',
	'lqt-movethread' => 'স্থানান্তর',
	'lqt-menu-trigger' => 'আরও',
	'lqt-newmessages-from' => '$1 হতে',
	'lqt-hot-topics' => 'অতি আলোচিত বিষয়সমূহ',
	'lqt-add-reply' => 'উত্তর যোগ করুন',
	'right-lqt-split' => 'থ্রেড পৃথক',
	'right-lqt-merge' => 'থ্রেড একত্রীকরণ',
	'lqt-thread-merge' => 'অন্য থ্রেডে একত্রীত করো',
	'lqt-thread-merge-to' => 'এই থ্রেডে একত্রীত করো',
	'lqt_merge_thread' => 'থ্রেড একত্রীকরণ',
	'lqt-thread-merge-source' => 'উৎস থ্রেড:',
	'lqt-thread-merge-dest' => 'গন্তব্য থ্রেড:',
	'lqt-merge-submit' => 'একত্রীকরণ',
	'prefs-lqt' => 'থ্রেডেড আলোচনা',
	'lqt-preference-display-count' => 'সর্বোচ্চ যে সংখ্যক উত্তর দেখাবে:',
	'lqt-preference-custom-signatures' => 'ব্যবহারকারী নির্ধারিত স্বাক্ষর দেখাও',
	'lqt-enotif-subject-reply' => '{{SITENAME}} আলোচনা - উত্তর: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} আলোচনা - নতুন থ্রেড: $1',
	'lqt-quote' => 'উক্তি',
	'lqt-search-legend' => 'এই পাতার আলোচনায় অনুসন্ধান করো',
	'lqt-search-label' => 'অনুসন্ধানকৃত শব্দসমূহ:',
	'lqt-search-button' => 'অনুসন্ধান',
	'searchprofile-threads' => 'আলোচনাসমূহ',
	'lqt-ajax-updated' => 'এই থ্রেডের নতুন পোষ্ট রয়েছে।',
	'lqt-ajax-update-link' => 'হালনাগাদ',
	'lqt-thread-show-replies' => '$1 টি উত্তর দেখাও',
	'lqt-thread-show-more' => 'আরও উত্তর দেখাও',
	'lqt-thread-link-url' => 'সংযুক্ত URL:',
	'lqt-thread-link-copy' => 'ক্লিপবোর্ডে কপি করো',
	'lqt-change-subject' => 'বিষয় পরিবর্তন',
	'lqt-save-subject' => 'সংরক্ষণ',
	'lqt-cancel-subject-edit' => 'বাতিল',
	'lqt-drag-save' => 'নিশ্চিত করুন',
	'lqt-drag-reason' => 'কারণ:',
	'lqt-drag-subject' => 'নতুন থ্রেডের জন্য বিষয়:',
	'lqt-edit-signature' => '(স্বাক্ষর সম্পাদনা)',
	'lqt-preview-signature' => '(প্রাকদর্শন)',
	'lqt-feed-title-all' => '{{SITENAME}} — নতুন পোষ্ট',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — নতুন থ্রেড',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — $1 হতে নতুন থ্রেড',
	'lqt-feed-title-replies' => '{{SITENAME}} — উত্তর',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — $1 হতে উত্তর',
	'lqt-newmessages-n' => 'নতুন বার্তা ($1)',
	'lqt_newmessages' => 'নতুন বার্তা',
	'lqt_newmessages-title' => 'নতুন বার্তা',
	'lqt-newpost-summary' => 'নতুন থ্রেড: $1',
	'lqt-reply-summary' => '[[$2|$1]] এর উত্তর',
	'lqt-talkpage-history-title' => 'আলোচনার পাতার ইতিহাস',
	'lqt-talkpage-history-subtitle' => '$1 এর জন্য',
	'lqt-talkpage-history-tab' => 'শীর্ষচরণ',
	'restriction-reply' => 'উত্তর পোষ্ট করুন',
	'restriction-newthread' => 'নতুন থ্রেড পোষ্ট করুন',
	'lqt-reply-subpage' => 'উত্তর',
	'nstab-thread' => 'থ্রেড',
	'nstab-summary' => 'সারাংশ',
);

/** Breton (Brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Gwendal
 * @author Y-M D
 */
$messages['br'] = array(
	'lqt-desc' => 'Ouzhpennañ a ra neudennadoù kaozioù er pajennoù kaozeal',
	'lqt_movethread' => 'Kas an neudennad kaozioù war ur bajenn all',
	'lqt_deletethread' => 'Diverkañ pe adtapout an neudennad',
	'lqt_contents_title' => 'Kaozeadennoù',
	'lqt_toc_thread_title' => 'Anv ar gaoz',
	'lqt_toc_thread_author' => "Boulc'het gant",
	'lqt_toc_thread_replycount' => 'Respontoù',
	'lqt_toc_thread_modified' => 'Kemmet da ziwezhañ',
	'lqt_add_header' => 'Ouzhpennañ un talbenn',
	'lqt_new_thread' => 'Digeriñ ur gaoz nevez',
	'lqt_invalid_subject' => "Direizh eo ar gaoz merket ganeoc'h.
Marteze :
* ez eo re hir
* e sav tabut gant ur rakger etrewiki pe un esaouenn anvioù.",
	'lqt_empty_subject' => "Ret eo deoc'h merkañ un tem.",
	'lqt_reply' => 'Respont',
	'lqt-parent' => 'Usrummad',
	'lqt_delete' => 'Diverkañ',
	'lqt_undelete' => 'Diziverkañ',
	'lqt_permalink' => 'Peurliamm',
	'lqt_fragment' => 'Darn eus ur $1 digant $2',
	'lqt_discussion_link' => 'gaoz',
	'lqt_from_talk' => 'Diwar $1',
	'lqt-history-title' => 'Istor ar gaoz',
	'lqt_hist_comment_edited' => 'Testenn evezhiadennoù [$2 kemmet]',
	'lqt_hist_summary_changed' => 'Diverrañ kemmet',
	'lqt_hist_reply_created' => '[[$1|Respont nevez]] krouet',
	'lqt_hist_thread_created' => 'Krouet ar gaoz nevez',
	'lqt_hist_deleted' => 'Diverket',
	'lqt_hist_undeleted' => 'Diziverket',
	'lqt_hist_moved_talkpage' => "Dilec'hiet",
	'lqt_hist_listing_subtitle' => 'Gwelet ur roll istor',
	'lqt_hist_view_whole_thread' => 'Gwelet istor klok ar gaoz',
	'lqt_hist_no_revisions_error' => "N'eo ket bet adwelet an neudennad-mañ gwezh ebet",
	'lqt_hist_past_last_page_error' => "Aet oc'h dreist d'an niver a bajennoù istor zo.",
	'lqt_hist_tooltip_newer_disabled' => "Ne'z a ket al liamm-mañ en-dro rak war ar bajenn gentañ emaoc'h.",
	'lqt_hist_tooltip_older_disabled' => "Ne'z a ket al liamm-mañ en-dro rak war ar bajenn ziwezhañ emaoc'h.",
	'lqt_hist_split' => "Respont a-ziforc'h en un neudennad kaozioù nevez",
	'lqt_hist_edited_subject' => 'Kemmet kaoz eus "$2" da "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Kaoz cheñchet',
	'lqt_hist_merged_from' => 'Kaset eo bet ar [[$1|respont]] war-du un neudennad kaozioù all',
	'lqt_hist_merged_to' => '[[$1|respont]] degaset eus un neudennad kaozioù all',
	'lqt_hist_split_from' => 'Rannañ war-du un neudennad kaozioù all',
	'lqt_hist_root_blanked' => 'Testenn an notenn diverket',
	'lqt_hist_adjusted_sortkey' => "Reizhet eo bet lec'hiadur an neudennad kaozeal",
	'lqt_revision_as_of' => 'Adweladenn eus an $2 da $3.',
	'lqt_change_new_thread' => 'Homañ eo adweladenn gentañ an neudennad.',
	'lqt_change_reply_created' => "Savet eo bet an [notenn oc'h usskediñ $1] en adweladenn-mañ.",
	'lqt_change_edited_root' => "Kemmet eo bet [an notenn oc'h usskediñ $1] en adweladenn-mañ.",
	'lqt_change_edited_summary' => 'Kemmet eo bet diverradenn ar gaoz',
	'lqt_change_deleted' => 'Diverket eo bet [$1 an neudennad-mañ] pe ar wrizienn anezhi.',
	'lqt_change_undeleted' => "Diziverket eo bet ar [$1bomm oc'h usskediñ]",
	'lqt_change_moved' => "Kaset eo bet ar [gaoz-mañ $1] d'ur bajenn gaozeal all",
	'lqt_change_split' => 'Dispartiet eo bet ar [gaoz-mañ $1] diouzh ur gaoz all',
	'lqt_change_edited_subject' => 'Eus "$2" eo deuet danvez ar gaoz-mañ da vezañ "$3"',
	'lqt_change_merged_from' => "Kaset ez eus bet unan eus ar [respontoù $1] d'ar gaoz-mañ d'ur gaoz all",
	'lqt_change_merged_to' => "Degaset eo bet ar [$1 respont oc'h usskediñ] adalek ur gaoz all.",
	'lqt_change_split_from' => 'Dispartiet ez eus bet un [iskaoz $1] eus ar gaoz-mañ e diabarzh an neudennad end-eeun',
	'lqt_change_root_blanked' => 'Diverket eo bet testenn [$1 un evezhiadenn].',
	'lqt_youhavenewmessages' => "[[$1|Kemennadennoù nevez]] zo ganeoc'h.",
	'lqt_protectedfromreply' => "$1 eo bet ar gaoz-mañ. N'hallit ket respont dezhi.",
	'lqt_protectedfromreply_link' => 'gwarezet',
	'lqt_subject' => 'Kaoz :',
	'lqt_noreason' => "N'eus bet roet abeg ebet.",
	'lqt_move_placeholder' => "N'eo an neudennad-mañ nemet ur merk erlec'hiañ a verk ez eus bet kaset ur gaoz, $1, eus ar bajenn-mañ d'ur bajenn all.
Graet eo bet an dilec'hiañ gant $2 d'an $3 da $4.
E $5 emañ an neudennad bremañ.",
	'lqt_thread_deleted_for_sysops' => "'''Diverket''' eo bet ar gaoz-mañ ha n'hall bezañ gwelet nemet gant ar verourien.",
	'lqt_thread_deleted' => 'Diverket eo bet an neudennad-mañ',
	'lqt_summary_notice' => "N'eus bet degaset tamm kemm ebet er gaoz abaoe $2 {{PLURAL:$2|deiz}} da nebeutañ.
Mard eo kloz ar gaoz e c'hallit kaout c'hoant da $1 marteze.",
	'lqt_summary_notice_link' => 'skrivañ un tamm diverrañ',
	'lqt_summary_label' => 'Diverradenn ar gaoz :',
	'lqt_summary_subtitle' => 'Diverrañ eus "$1"',
	'lqt_nosuchrevision' => "N'eus bet kavet adweladenn o klotañ gant ar gaoz-mañ.",
	'lqt_nosuchthread' => "N'eus ket eus ar gaoz spisaet ganeoc'h.",
	'lqt_nosuchthread_title' => "N'eus ket eus ar gaoz-mañ",
	'lqt_threadrequired' => "Ret eo deoc'h spisaat ur gaoz en URL",
	'lqt_move_movingthread' => "O tilec'hiañ $1.
Ul lodenn eus $2 eo an neudennad-mañ.",
	'lqt_move_torename' => "A-benn adenvel an neudennad-mañ, $1 ha kemmañ ar vaezienn 'Kaoz'.",
	'lqt_move_torename_edit' => 'Kemmañ anezhi',
	'lqt_move_destinationtitle' => 'Titl ar bajenn gaozeal tal :',
	'lqt_move_move' => "Dilec'hiañ",
	'lqt_move_nodestination' => 'Rankout a rit merkañ ur pal.',
	'lqt_move_thread_bad_destination' => "Ar bajenn dal-mañ n'eo ket ur bajenn gaozeal.",
	'lqt_move_samedestination' => 'Emañ ar gaoz war ar bajenn-mañ dija !',
	'lqt_move_noreason' => "N'eus bet roet abeg ebet.",
	'lqt_move_success' => 'Kaset eo bet an neudennad da $1',
	'lqt_delete_undeletethread' => 'Diziverkañ an neudennad',
	'lqt_delete_partof' => "Ul lodenn eus '''$1''' eo ar gaoz-mañ.",
	'lqt_delete_deleting' => "O tiverkañ '''$1''' hag an '''holl respontoù''' stag outi.",
	'lqt_delete_deletethread' => 'Diverkañ ar gaoz hag ar respontoù stag outi',
	'lqt_delete_deleted' => 'Diverket eo bet ar gaoz.',
	'lqt_delete_undeleted' => 'Diziverket eo bet ar gaoz.',
	'lqt_delete_return' => 'Distreiñ da $1.',
	'lqt_delete_return_link' => 'ar bajenn gaozeal',
	'lqt_delete_unallowed' => "N'oc'h ket aotreet da ziverkañ kaozeadennoù.",
	'lqt_delete_show_checkbox' => "Diskouez ar c'haozeadennoù diverket",
	'lqt_talkpage_autocreate_summary' => "Pajenn gaozeal krouet ent emgefre p'eo bet kaset an neudennad kaozioù kentañ",
	'lqt_header_warning_big' => "Emaoc'h o kemmañ ur $1",
	'lqt_header_warning_after_big' => "Evit ar c'hemennoù hag ar rakgerioù eo an talbennoù. 
Marteze e fell deoc'h $2 kentoc'h.",
	'lqt_header_warning_bold' => 'Talbenn ur bajenn gaozeal',
	'lqt_header_warning_new_discussion' => "boulc'hañ gant ur gaoz nevez",
	'lqt_sorting_order' => 'Urzh renkañ :',
	'lqt_sort_newest_changes' => 'ar re kemmet da ziwezhañ da gentañ',
	'lqt_sort_newest_threads' => 'an re nevesañ da gentañ',
	'lqt_sort_oldest_threads' => 'ar re goshañ da gentañ',
	'lqt-title' => 'Titl',
	'lqt-summary' => 'Diverrañ',
	'lqt-searching' => 'O klask kaozeadennoù',
	'lqt-read-message' => 'Merkañ evel lennet',
	'lqt-read-message-tooltip' => "Lemel kuit an neudennad-mañ a-ziwar ar c'hemennadennoù nevez.
Posupl e vo he gweled c'hoazh war ar bajenn gaozeal orin.",
	'lqt-read-all' => 'Merkañ an holl evel lennet',
	'lqt-read-all-tooltip' => "Lemel kuit an holl neudennadoù a-ziwar ar c'hemennadennoù nevez.
Posupl e vo o gweled c'hoazh war ar pajennoù kaozeal orin.
N'haller ket dizober an oberiadenn-mañ ur wezh kaset da bet.",
	'lqt-marked-read' => "Kaoz '''$1''' merket evel lennet.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|gemennadenn}} merket evel lennet.',
	'lqt-email-undo' => 'Dizober',
	'lqt-no-new-messages' => "N'hoc'h eus kemennadenn nevez ebet.",
	'lqt-new-messages' => "✒ Kemennadennoù nevez zo evidoc'h.",
	'lqt-email-info-undo' => "Addegas ar gaoz emaoc'h o paouez lemel kuit",
	'lqt-date-info' => "Diweredekaet eo al liamm-mañ peogwir emaoc'h o sellet ouzh ar c'haozeadennoù evit an holl zeiziadoù",
	'lqt-newmessages-context' => 'Kaozeadenn glok',
	'lqt-thread-created' => 'Krouet',
	'lqt-history-time' => 'Deiziad',
	'lqt-history-user' => 'Implijer',
	'lqt-history-action' => 'Obererezh',
	'lqt-history-comment' => 'Notenn',
	'lqt-history-thread' => 'Neudennad',
	'lqt-thread-edited-author' => 'Kemmet gant an aozer.<br />
Kemm diwezhañ : $1',
	'lqt-thread-edited-others' => 'Kemmet gant $2 implijer{{PLURAL:$2||}} all.<br />
Kemm diwezhañ : $1',
	'lqt-header-actions' => 'Obererezhioù',
	'lqt_summarize_link' => 'Diverrañ',
	'lqt-summarize-intro' => 'Savit un tamm diverrañ a-us er prenestr skridaozañ.
Gallout a rit ober gant ne vern pe testenn wiki en ho tiverrrañ. Ur wech echu klikit war  "{{int:savearticle}}".',
	'lqt-thread-split' => 'Rannañ war-du ur gaoz nevez',
	'lqt-split-success' => "Deuet oc'h a-benn da rannañ an neudennad $1.",
	'lqt_split_thread' => 'Rannañ ur gaoz',
	'lqt-thread-split-subject' => 'Danvez ar gaoz nevez :',
	'lqt-thread-split-thread' => 'Kaoz :',
	'lqt-split-submit' => 'Rannañ',
	'lqt_split_badsubject' => "Direizh eo ar gaoz merket ganeoc'h",
	'lqt-no-threads' => "N'eus tamm neudennad kaozioù ebet war bajenn-mañ evit c'hoazh.",
	'lqt-delete-parent-warning' => "Homañ zo un neudennad a renk uhel enni respontoù.
Diverket e vo ar respontoù ent emgefre ivez.
Kuit na c'hoarvezfe, rannit an neudenndaoù kaozioù a-raok diverkañ homañ.",
	'lqt-delete-parent-deleted' => 'Neudennad kaozioù kar diverket ($1)',
	'lqt-delete-replies-done' => "Diverket eo bet ivez an holl respontoù d'an neudennad-mañ",
	'lqt-movethread' => "Dilec'hiañ",
	'lqt-menu-trigger' => "Muioc'h",
	'lqt-newmessages-from' => 'Diwar $1',
	'lqt-hot-topics' => "Kaozeadennoù eus ar c'hiz",
	'lqt-add-reply' => 'Ouzhpennañ ur respont',
	'lqt_rc_new_discussion' => 'en deus embannet un neudennad nevez, "$1"',
	'lqt_rc_new_reply' => 'en deus embannet ur respont da "$1"',
	'right-lqt-split' => 'Rannañ an neudennadoù',
	'right-lqt-merge' => 'Kendeuziñ an neudennadoù',
	'lqt-thread-merge' => 'Kendeuziñ en un neudennad all',
	'lqt-thread-merge-to' => 'Kendeuziñ en neudennad-mañ',
	'lqt_merge_thread' => 'Kendeuziñ an neudennadoù',
	'lqt-thread-merge-source' => 'Mammenn an neudennad :',
	'lqt-thread-merge-dest' => 'Neudennad tal :',
	'lqt-merge-submit' => 'Kendeuziñ',
	'lqt-merge-success' => "Deuet oc'h a-benn da gendeuziñ an neudennad kaozioù $1 e $2",
	'lqt-log-name' => 'Marilh an neudennadoù kaozioù',
	'lqt-log-header' => 'Renabliñ a ra ar marilh-mañ an oberoù graet war an neudennadoù kaozioù',
	'lqt-log-action-move' => 'kaset [[$1]] eus  [[$2]] da [[$3]].',
	'lqt-log-action-split' => 'en deus daouhanteret [[$1]] dindan [[$3]], gant ar sujed nevez "$2".',
	'lqt-log-action-merge-across' => "en deus dilerc'hiet [[$1]] eus dindan [[$2]] da zindan [[$3]].",
	'lqt-log-action-merge-down' => 'en deus kendeuzet [[$1]] a-us da [[$3]]',
	'lqt-log-action-subjectedit' => 'en deus kemmet sujed [[$1]] eus "$2" da "$3"',
	'lqt-log-action-resort' => "en deus kemmet urzh rummañ [[$1]]. Kemmet eo bet an alc'hwez rummañ eus $2 da $3",
	'lqt-preference-notify-talk' => 'Kas ur postel din pa vez maget ur gaoz evezhiet ganin',
	'lqt-preference-watch-threads' => 'Evezhiañ an neudennadoù a grouan pe a respontant dezho',
	'prefs-lqt' => 'Kaozeadennoù dre neudennadoù',
	'lqt-preference-display-depth' => 'Donder brasañ a respontoù da ziskouez :',
	'lqt-preference-display-count' => 'Niver brasañ a respontoù da ziskouez :',
	'lqt-preference-custom-signatures' => 'Diskouez sinadurioù personelaet an implijerien',
	'lqt-enotif-subject-reply' => 'Kaoz war {{SITENAME}} - Respont : $1',
	'lqt-enotif-subject-newthread' => 'Kaoz war {{SITENAME}} - Neudennad nevez : $1',
	'lqt-enotif-newthread' => "Demat $1,
Hemañ zo ur c'hemenn a-berzh {{SITENAME}} a embann ez eus un neudennad nevez war $5, '$2',
zo bet savet d'an $3 da $4 gant $8.

E lenn a c'hallit war <$6>
$7",
	'lqt-enotif-reply' => "Demat $1,

Setu aze ur c'hemenn a-berzh {{SITENAME}} a embann ez eus ur respont nevez da '$2' war $5,
bet savet d'an $3 da $4 gant $8.

E lenn a c'hallit ober war <$6>

Setu testenn ar respont :
$7",
	'lqt-quote-intro' => "D'an $2 da $3, eo bet skrivet gant [[User:$1|$1]] :",
	'lqt-quote' => 'Menegiñ',
	'lqt-search-legend' => 'Klask kaozeadennoù war ar bajenn-mañ',
	'lqt-search-label' => 'Termenoù enklask',
	'lqt-search-button' => 'Klask',
	'searchprofile-threads' => 'Kaozeadennoù',
	'searchprofile-threads-tooltip' => 'Klask en neudennadoù kaozioù har er pajennoù kaozeal',
	'lqt-ajax-updated' => "Kemennoù nevez zo d'an neudennad-mañ",
	'lqt-ajax-update-link' => 'Hizivaat',
	'lqt-thread-show-replies' => 'Diskouez $1 respont',
	'lqt-thread-show-more' => 'Diskouez respontoù all',
	'lqt-thread-link-url' => 'URL al liamm :',
	'lqt-thread-link-title' => 'Liamm wikitestenn :',
	'lqt-thread-link-copy' => 'Eilañ er golver',
	'lqt-sign-not-necessary' => "N'eo ket ret deoc'h sinañ ho notenn gant peder zildenn.
Dont a raio ar sinadur war wel e-unan",
	'lqt-marked-as-read-placeholder' => 'Merket eo bet an neudennad $1 evel lennet.',
	'lqt-change-subject' => 'Cheñch anv ar gaoz',
	'lqt-save-subject' => 'Enrollañ',
	'lqt-save-subject-failed' => "Ar fazi da-heul a zo bet e-kerzh ur c'hlask cheñch sujed an neudennad : $1",
	'lqt-ajax-invalid-subject' => "Fall eo ar sujed ho peus lakaet dibabet, sur a-walc'h peogwir e oa re hir.",
	'lqt-ajax-no-subject' => 'Rankout a rit spisaat danvez kaoz an neudennad nevez.',
	'lqt-save-subject-error-unknown' => 'C\'hoarvezet ez eus ur fazi dianav e-ser termeniñ danvez ar gaoz-mañ. Klaskit en ober en ur glikañ war "kemmañ" er gaoz uhelañ.',
	'lqt-cancel-subject-edit' => 'Nullañ',
	'lqt-drag-activate' => "Ruzañ betek al lec'h nevez",
	'lqt-drag-drop-zone' => 'Lakaat amañ',
	'lqt-drag-confirm' => 'Evit echuiñ an oberezhioù da heul, mar plij  roit un abeg ha klikit war "Kadarnaat".',
	'lqt-drag-reparent' => "Dilerc'hiañ ar gemenadenn dindan ur c'herent nevez.",
	'lqt-drag-split' => "Dilerc'hiañ ar gaozeadenn davet e steudad dezhañ",
	'lqt-drag-setsortkey' => "Kemmañ lec'hiadur ar gemennadenn er bajenn",
	'lqt-drag-bump' => "Dilec'hiañ ar gemmadenn davet penn uhelañ ar bajenn kaozeal",
	'lqt-drag-save' => 'Kadarnaat',
	'lqt-drag-title' => 'Kadarnaat ar ruzadenn',
	'lqt-drag-reason' => 'Abeg :',
	'lqt-drag-subject' => 'Danvez evit ar gaoz nevez (rekis) :',
	'lqt-edit-signature' => '(kemmañ ar sinadur)',
	'lqt-preview-signature' => '(rakwelet)',
	'lqt-feed-title-all' => '{{SITENAME}} — Kemennadennoù nevez',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Kemennadennoù nevez a-berzh $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Neudennadoù kaoz nevez',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Neudennadoù kaoz nevez a-berzh $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Respontoù',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Respontoù digant $1',
	'lqt-feed-new-thread-intro' => 'Neudennadoù nevez war $1 postet gant $2',
	'lqt-feed-reply-intro' => 'Respontoù da $3 (war $1) postet gant $2',
	'tooltip-pt-newmessages' => "Diskouez a ra ar c'hemennadennoù nevez diwar-benn an danvezioù pa ar pajennoù kaozeal evezhiet ganeoc'h",
	'lqt-newmessages-n' => 'Kemennadennoù nevez ($1)',
	'lqt_newmessages' => "Ma c'hemennadennoù nevez (hini ebet)",
	'lqt_newmessages-title' => 'Kemennadennoù nevez',
	'lqt-newpost-summary' => 'Neudennad nevez : $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => "Merkit ho testenn evit ar gaozeadenn-mañ. Dleout a rafec'h diverkañ al linenn-mañ goude.",
	'lqt-reply-summary' => 'Respont da [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Istor ar bajenn gaozeal',
	'lqt-talkpage-history-subtitle' => 'Evit $1',
	'lqt-talkpage-history-tab' => 'Talbenn',
	'restriction-reply' => 'Postañ respontoù',
	'restriction-newthread' => 'Ouzhpennañ neudennadoù kaozeal nevez',
	'lqt-protected-reply-thread' => "Ne c'helloc'h ket postañ en neudennad-mañ dre ma 'z eo bet gwarezet a-enep ar gemennadennoù nevez.",
	'lqt-protected-reply-talkpage' => "Ne c'helloc'h ket postañ en neudennad-mañ dre ma 'z eo bet gwarezet an neudennad a-enep ar respontoù.",
	'lqt-protected-newthread' => "Ne c'hellit ket postañ neudennadoù nevez er bajenn kaozeal-mañ dre ma 'z eo bet gwarezet a-enep an neudennadoù nevez.",
	'lqt-edit-bump' => 'Adgweredekaat an neudennad-mañ',
	'lqt-edit-bump-tooltip' => 'Kas an neudennad-mañ e laez ar bajenn gaozeal',
	'lqt-historicalrevision-error' => "An adweladenn ho peus dibabet a zo fall, dre-se ne c'hell ket bezañ diskouezet.",
	'lqt-reply-subpage' => 'respont',
	'nstab-thread' => 'Neudennad',
	'nstab-summary' => 'Diverradur',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'lqt-desc' => 'Dodaj nizane diskusije stranicama za razgovor',
	'lqt_movethread' => 'Premjesti niz na drugu stranicu',
	'lqt_deletethread' => 'Obriši ili vrati niz',
	'lqt_contents_title' => 'Sadržaj',
	'lqt_toc_thread_title' => 'Naslov niza',
	'lqt_toc_thread_author' => 'Započeo',
	'lqt_toc_thread_replycount' => 'Odgovori',
	'lqt_toc_thread_modified' => 'Posljednji put izmjenjeno',
	'lqt_add_header' => 'Dodaj zaglavlje',
	'lqt_new_thread' => 'Počni novu diskusiju',
	'lqt_invalid_subject' => 'Tema koju ste unijeli nije validna.
Možda:
*Je predugačka ili
*Postoji konflikt sa interwiki prefiksima ili imenskim prostorima.',
	'lqt_empty_subject' => 'Morate unijeti temu.',
	'lqt_reply' => 'Odgovoriti',
	'lqt-parent' => 'Roditelj',
	'lqt_delete' => 'Obriši',
	'lqt_undelete' => 'Vrati obrisano',
	'lqt_permalink' => 'Link prema',
	'lqt_fragment' => 'Fragment od $1 sa $2',
	'lqt_discussion_link' => 'razgovor',
	'lqt_from_talk' => 'Od $1',
	'lqt-history-title' => 'Historija niza',
	'lqt_hist_comment_edited' => 'Komentirani tekst [$2 uređen]',
	'lqt_hist_summary_changed' => 'Sažetak izmijenjen',
	'lqt_hist_reply_created' => '[[$1|Novi odgovor]] napravljen',
	'lqt_hist_thread_created' => 'Napravljen novi niz',
	'lqt_hist_deleted' => 'Obrisano',
	'lqt_hist_undeleted' => 'Vraćeno',
	'lqt_hist_moved_talkpage' => 'Premješteno',
	'lqt_hist_listing_subtitle' => 'Pregledavanje izlistavanja historije',
	'lqt_hist_view_whole_thread' => 'Pogledajte historiju za cijeli niz',
	'lqt_hist_no_revisions_error' => 'Ova niz nema ni jednu reviziju u historiji.',
	'lqt_hist_past_last_page_error' => 'Vi ste iznad broja stranica historije koje postoje.',
	'lqt_hist_tooltip_newer_disabled' => 'Ovaj link je onemogućen jer ste na prvoj stranici.',
	'lqt_hist_tooltip_older_disabled' => 'Ovaj link je onemogućen jer ste na posljednjoj stranici.',
	'lqt_hist_split' => 'Odgovor podijeljen na novi niz',
	'lqt_hist_edited_subject' => 'Promijenjena tema sa "$2" na "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Izmijenjena tema',
	'lqt_hist_merged_from' => '[[$1|Odgovor]] premješten na drugi niz',
	'lqt_hist_merged_to' => '[[$1|Odgovor]] premješten na drugi niz',
	'lqt_hist_split_from' => 'Podijeli u novi niz',
	'lqt_hist_root_blanked' => 'Uklonjen tekst komentara',
	'lqt_hist_adjusted_sortkey' => 'Podešena pozicija niza',
	'lqt_revision_as_of' => 'Revizija od dana $2 u $3 sati.',
	'lqt_change_new_thread' => 'Ovo je početna revizija niza.',
	'lqt_change_reply_created' => '[$1 Označeni komentar] je napravljen u ovoj reviziji.',
	'lqt_change_edited_root' => '[$1 Označeni komentar] je uređen u ovoj reviziji.',
	'lqt_change_edited_summary' => 'Sažetak niza je uređivan',
	'lqt_change_deleted' => '[$1 Ovaj niz] ili odgovor na njega je obrisan',
	'lqt_change_undeleted' => '[$1 Označeni post] je vraćen',
	'lqt_change_moved' => '[$1 Ovaj niz] je premješten na drugu stranicu za razgovor',
	'lqt_change_split' => '[$1 Ovaj niz] je podijeljeni dio iz drugog niza',
	'lqt_change_edited_subject' => 'Tema ovog niza je promijenjena sa "$2" na "$3"',
	'lqt_change_merged_from' => '[$1 Odgovor] na ovaj niz je premješten u drugi niz',
	'lqt_change_merged_to' => '[$1 Označeni odgovor] je premješten sa drugog niza',
	'lqt_change_split_from' => '[$1 Podniz] ovog niza je podijeljen na vlastiti niz',
	'lqt_change_root_blanked' => 'Tekst [$1 komentara] je uklonjen.',
	'lqt_youhavenewmessages' => 'Imate [[$1|novih poruka]].',
	'lqt_protectedfromreply' => 'Ovaj niz je $1 od odgovaranja na njega.',
	'lqt_protectedfromreply_link' => 'zaštićen',
	'lqt_subject' => 'Tema:',
	'lqt_noreason' => 'Nije naveden razlog.',
	'lqt_move_placeholder' => 'Ovaj niz je međuspremnik koji označava da je niz, $1, premješten sa ove stranice.
Ovo premještanje je načinio $2 dana $3 u $4.
Niz se sad nalazi na $5.',
	'lqt_thread_deleted_for_sysops' => "Ovaj niz je '''obrisan''' i vidljiv je samo administratorima.",
	'lqt_thread_deleted' => 'Ovaj niz je obrisan.',
	'lqt_summary_notice' => 'Nije bilo izmjena na ovoj diskusiji već $2 {{PLURAL:$2|dan|dana}}.
Ako je zaključena, možete $1.',
	'lqt_summary_notice_link' => 'napisati sažetak',
	'lqt_summary_label' => 'Sažetak niza:',
	'lqt_summary_subtitle' => 'Sažetak od $1',
	'lqt_nosuchrevision' => 'Nema takve revizije ovog niza.',
	'lqt_nosuchthread' => 'Niz koji ste naveli ne postoji.',
	'lqt_nosuchthread_title' => 'Nema takvog niza',
	'lqt_threadrequired' => 'Morate odrediti niz u URL.',
	'lqt_move_movingthread' => 'Premještam $1.
Ovaj niz je dio $2.',
	'lqt_move_torename' => "Da bi ste promijenili ime niza, $1 i promijenite polje 'Subject'.",
	'lqt_move_torename_edit' => 'uredite ga',
	'lqt_move_destinationtitle' => 'Naslov odredišne stranice za razgovor:',
	'lqt_move_move' => 'Premjesti',
	'lqt_move_nodestination' => 'Morate navesti odredište.',
	'lqt_move_thread_bad_destination' => 'Odredišna stranica nije stranica za razgovor.',
	'lqt_move_samedestination' => 'Niz je već na ovoj stranici!',
	'lqt_move_noreason' => 'Nije naveden razlog.',
	'lqt_move_success' => 'Niz je premješten na $1.',
	'lqt_delete_undeletethread' => 'Vrati niz',
	'lqt_delete_partof' => "Ovaj niz je dio '''$1'''.",
	'lqt_delete_deleting' => "Brišem '''$1''' i '''sve odgovore''' na njega.",
	'lqt_delete_deletethread' => 'Obriši niz i odgovore',
	'lqt_delete_deleted' => 'Niz je bio obrisan.',
	'lqt_delete_undeleted' => 'Niz je vraćen.',
	'lqt_delete_return' => 'Nazad na $1',
	'lqt_delete_return_link' => 'stranica za razgovor',
	'lqt_delete_unallowed' => 'Nije Vam dopušteno da brišete nizove.',
	'lqt_delete_show_checkbox' => 'Pokaži obrisane nizove',
	'lqt_talkpage_autocreate_summary' => 'Stranica za razgovor je napravljena automatski pri slanju prvog niza.',
	'lqt_header_warning_big' => 'Uređujete $1.',
	'lqt_header_warning_after_big' => 'Naslovi su za obavještenja i predgovore.
Možda umjesto toga želite $2.',
	'lqt_header_warning_bold' => 'zaglavlje stranice za razgovor',
	'lqt_header_warning_new_discussion' => 'započeti novu diskusiju',
	'lqt_sorting_order' => 'Način redanja:',
	'lqt_sort_newest_changes' => 'zadnje izmijenjeno naprijed',
	'lqt_sort_newest_threads' => 'novije nizove naprijed',
	'lqt_sort_oldest_threads' => 'starije nizove naprijed',
	'lqt-title' => 'Naslov',
	'lqt-summary' => 'Sažetak',
	'lqt-searching' => 'Pretraga za nizovima',
	'lqt-read-message' => 'Označi kao pročitano',
	'lqt-read-message-tooltip' => 'Ukloni ovaj niz iz novih poruka.
I dalje će biti vidljiv na svojoj originalnoj stranici za razgovor.',
	'lqt-read-all' => 'Označi sve kao pročitano',
	'lqt-read-all-tooltip' => 'Ukloni sve nizove iz novih poruka.
Oni će još biti vidljivi na svojim originalnim stranicama za razgovor.
Ova operacija se ne može vratiti.',
	'lqt-marked-read' => "Niz '''$1''' je označen kao pročitan.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|poruka|poruke|poruka}} je označeno kao pročitano.',
	'lqt-email-undo' => 'Povrati',
	'lqt-no-new-messages' => 'Nemate novih poruka.',
	'lqt-new-messages' => '✒ Imate nove poruke.',
	'lqt-email-info-undo' => 'Vrati natrag niz koji ste upravo propustili.',
	'lqt-date-info' => 'Ovaj link je onemogućen jer pregledate nizove od svih datuma.',
	'lqt-newmessages-context' => 'Puni niz',
	'lqt-thread-created' => 'Napravljeno',
	'lqt-history-time' => 'Vrijeme',
	'lqt-history-user' => 'Korisnik',
	'lqt-history-action' => 'Aktivnost',
	'lqt-history-comment' => 'Komentar',
	'lqt-history-thread' => 'Niz',
	'lqt-thread-edited-author' => 'Uređeno od strane autora. <br />
Posljednja izmjena: $1',
	'lqt-thread-edited-others' => 'Uređeno od strane {{PLURAL:$2|drugog korisnika|ostalih $2 korisnika}}.<br />
Posljednja izmjena: $1',
	'lqt-header-actions' => 'Akcije',
	'lqt_summarize_link' => 'Napravi sažetak',
	'lqt-summarize-intro' => 'Molimo napravite sažetak ispod niza u kutiju za uređivanje.
Možete koristiti i wikitekst u Vašem sažetku.
Kada završite, kliknite "{{int:savearticle}}".',
	'lqt-thread-split' => 'Podijeli na novi niz',
	'lqt-split-success' => 'Uspješno ste podijelili niz $1.',
	'lqt_split_thread' => 'Podijeli niz',
	'lqt-thread-split-subject' => 'Nova tema niza:',
	'lqt-thread-split-thread' => 'Niz:',
	'lqt-split-submit' => 'Podijeli',
	'lqt_split_badsubject' => 'Tema koju ste unijeli nije valjana.',
	'lqt-no-threads' => 'Još nema nizova na ovoj stranici.',
	'lqt-delete-parent-warning' => 'Ovo je niz najvišeg nivoa sa odgovorima.
Njegovi odgovori će se također obrisati.
Da to spriječite, odvojite ih sa ovog niza prije nego što ga obrišete.',
	'lqt-delete-parent-deleted' => 'Nadređeni niz je obrisan ($1)',
	'lqt-delete-replies-done' => 'Svi odgovori na ovaj niz su također obrisani.',
	'lqt-movethread' => 'Premjesti',
	'lqt-menu-trigger' => 'Više',
	'lqt-newmessages-from' => 'Od $1',
	'lqt-hot-topics' => 'Vruće teme',
	'lqt-add-reply' => 'Dodaj odgovor',
	'lqt_rc_new_discussion' => 'poslan novi niz,  "$1"',
	'lqt_rc_new_reply' => 'poslan odgovor na "$1"',
	'right-lqt-split' => 'Dijeljenje niza',
	'right-lqt-merge' => 'Spajanje niza',
	'lqt-thread-merge' => 'Spoji na drugi niz',
	'lqt-thread-merge-to' => 'Spoji u ovaj niz',
	'lqt_merge_thread' => 'Spoji nizove',
	'lqt-thread-merge-source' => 'Izvor niza:',
	'lqt-thread-merge-dest' => 'Odredišni niz:',
	'lqt-merge-submit' => 'Spoji',
	'lqt-merge-success' => 'Uspješno ste spojili niz $1 u podniz $2.',
	'lqt-log-name' => 'Zapisnik nizanih razgovora',
	'lqt-log-header' => 'Ovaj zapisnik sadrži detalje akcija koje su poduzete na nizovima razgovora.',
	'lqt-log-action-move' => 'premješteno [[$1]] iz [[$2]] u [[$3]].',
	'lqt-log-action-split' => 'podlijeli [[$1]] ispod [[$3]], sa novom temom "$2"',
	'lqt-log-action-merge-across' => 'premješteno [[$1]] od ispod [[$2]] na ispod [[$3]]',
	'lqt-log-action-merge-down' => 'spojeno [[$1]] na iznad [[$3]]',
	'lqt-log-action-subjectedit' => 'promijenjena tema za [[$1]] sa "$2" na "$3"',
	'lqt-log-action-resort' => 'promijenjen je način sortiranja za [[$1]]. Promijenjen je ključ sortiranja sa $2 na $3',
	'lqt-preference-notify-talk' => 'Pošalji mi e-mail za sve odgovore na niz koji pratim',
	'lqt-preference-watch-threads' => 'Prati nizove koje sam napravio ili odgovorio na njih',
	'prefs-lqt' => 'Nizana diskusija',
	'lqt-preference-display-depth' => 'Najveća dubina odgovora za prikaz:',
	'lqt-preference-display-count' => 'Najveći broj odgovora za prikazivanje:',
	'lqt-preference-custom-signatures' => 'Prikaži prilagođene korisničke potpise',
	'lqt-enotif-subject-reply' => '{{SITENAME}} razgovor - Odgovor: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} razgovor - Novi niz: $1',
	'lqt-enotif-newthread' => "Zdravo $1,
ovo je obavještenje sa {{SITENAME}} da je kreiran novi niz na $5, '$2', dana $3 u $4 od strane $8

Možete ga vidjeti na <$6>

Tekst je:
$7",
	'lqt-enotif-reply' => "Zdravo $1,
ovo je obavještenje sa {{SITENAME}} da je napravljen novi odgovor na '$2' sa $5, dana $3 u $4 od strane $8

Možete ga vidjeti na <$6>

Tekst odgovora je:
$7",
	'lqt-quote-intro' => 'Dana $2 u $3, [[User:$1|korisnik $1]] je napisao:',
	'lqt-quote' => 'Citat',
	'lqt-search-legend' => 'Pretraži razgovore na ovoj stranici',
	'lqt-search-label' => 'Traženi pojmovi:',
	'lqt-search-button' => 'Traži',
	'searchprofile-threads' => 'Razgovori',
	'searchprofile-threads-tooltip' => 'Pretraga nizanih razgovora i stranica za razgovor',
	'lqt-ajax-updated' => 'Ovaj niz ima nove postove.',
	'lqt-ajax-update-link' => 'Ažuriranje',
	'lqt-thread-show-replies' => 'Prikaži $1 {{PLURAL:$1|odgovor|odgovora}}',
	'lqt-thread-show-more' => 'Prikaži više odgovora',
	'lqt-thread-link-url' => 'URL linka:',
	'lqt-thread-link-title' => 'Link wikiteksta:',
	'lqt-thread-link-copy' => 'Kopiraj u međuspremnik',
	'lqt-sign-not-necessary' => 'Nije neophodno da potpisujete Vaš post sa četiri tilde.
Potpis će se prikazati automatski.',
	'lqt-marked-as-read-placeholder' => 'Niz $1 je označen kao pročitan.',
	'lqt-change-subject' => 'Promijeni temu',
	'lqt-save-subject' => 'Sačuvaj',
	'lqt-save-subject-failed' => 'Slijedeća greška se desila pri pokušaju promjene teme ovog niza: $1',
	'lqt-ajax-invalid-subject' => 'Tema koju ste unijeli je nevaljana, možda zato što je predugačka.',
	'lqt-ajax-no-subject' => 'Morate navesti temu za novi niz.',
	'lqt-save-subject-error-unknown' => "Desila se nepoznata greška pri pokušaja postavljanja teme ovog niza. Molimo pokušajte ovo učiniti klikanjem na ''uredi'' na vrhu poruke.",
	'lqt-cancel-subject-edit' => 'Odustani',
	'lqt-drag-activate' => 'Prenesi na novo mjesto',
	'lqt-drag-drop-zone' => 'Ubaci ovdje',
	'lqt-drag-confirm' => 'Da biste dovršili slijedeće akcije, molimo popunite razlog i kliknite "Potvrdi".',
	'lqt-drag-reparent' => 'Premjesti poruku ispod nove nadređene teme.',
	'lqt-drag-split' => 'Premjestite poruku na vlastiti niz',
	'lqt-drag-setsortkey' => 'Podesi mjesto poruke na stranici',
	'lqt-drag-bump' => 'Premjesti poruku na vrh stranice za razgovor',
	'lqt-drag-save' => 'Potvrdi',
	'lqt-drag-title' => 'Potvrdi premještanje',
	'lqt-drag-reason' => 'Razlog:',
	'lqt-drag-subject' => 'Tema za novi niz (obavezno):',
	'lqt-edit-signature' => '(uredi potpis)',
	'lqt-preview-signature' => '(pregled)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nove poruke',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nove poruke od $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Novi nizovi',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Novi nizovi iz $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Odgovori',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Odgovori iz $1',
	'lqt-feed-new-thread-intro' => 'Novi niz na $1 poslano od strane $2',
	'lqt-feed-reply-intro' => 'Odgovor na $3 (na $1) poslan od strane $2',
	'tooltip-pt-newmessages' => 'Pokaži nove vijesti na niz ili na nizane stranice za razgovor koje vi pratite',
	'lqt-newmessages-n' => 'Nove poruke ($1)',
	'lqt_newmessages' => 'Moje nove poruke (nema)',
	'lqt_newmessages-title' => 'Nove poruke',
	'lqt-newpost-summary' => 'Novi niz: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Molimo unesite vaš tekst za ovaj niz. Zatim trebate obrisati ovaj red.',
	'lqt-reply-summary' => 'Odgovor na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historija stranice za razgovor',
	'lqt-talkpage-history-subtitle' => 'Za $1',
	'lqt-talkpage-history-tab' => 'Zaglavlje',
	'restriction-reply' => 'Slanje odgovora',
	'restriction-newthread' => 'Slanje novih nizova',
	'lqt-protected-reply-thread' => 'Ne možete slati poruke na ovaj niz jer je on zaštićen za nove poruke.',
	'lqt-protected-reply-talkpage' => 'Ne možete poslati poruki na ovaj niz jer je ova stranica za razgovor zaštićena za odgovore na ove nizove.',
	'lqt-protected-newthread' => 'Ne možete poslati poruku na novi niz na ovoj stranici za razgovor jer je zaštićena za pravljenje novih nizova.',
	'lqt-edit-bump' => 'Naglasi ovaj niz',
	'lqt-edit-bump-tooltip' => 'Premjesti ovaj niz na vrh njegove stranice za razgovor',
	'lqt-historicalrevision-error' => 'Revizija koju ste odabrali je oštećena i ne može se pogledati.',
	'lqt-reply-subpage' => 'odgovor',
	'nstab-thread' => 'Niz',
	'nstab-summary' => 'Sažetak',
);

/** Буряад (Буряад)
 * @author Bjargal
 */
$messages['bxr'] = array(
	'lqt_newmessages' => 'Минии шэнэ бэшэг (нэгэшье үгы)',
);

/** Catalan (Català)
 * @author Aleator
 * @author Jordi Roqué
 * @author Loupeter
 * @author Paucabot
 * @author Qllach
 * @author SMP
 * @author Solde
 * @author Ssola
 * @author Toniher
 */
$messages['ca'] = array(
	'lqt-desc' => 'Afegeix fils de discussió a les pàgines de discussió',
	'lqt_movethread' => 'Moure el fil a una altra pàgina',
	'lqt_deletethread' => 'Esborrar o recuperar fil',
	'lqt_contents_title' => 'Contingut',
	'lqt_toc_thread_title' => 'Títol del fil',
	'lqt_toc_thread_author' => 'Iniciat per',
	'lqt_toc_thread_replycount' => 'Respostes',
	'lqt_toc_thread_modified' => 'Darrera modificació',
	'lqt_add_header' => 'Afegeix capçalera',
	'lqt_new_thread' => 'Comença una nova discussió',
	'lqt_invalid_subject' => 'El tema que heu introduït no és vàlid.
Pot:
* ser massa llarg, o 
* entrar en conflicte amb prefixos interwiki o altres espai de noms.',
	'lqt_empty_subject' => "Heu d'introduir un tema.",
	'lqt_reply' => 'Respon',
	'lqt-parent' => 'Pare',
	'lqt_delete' => 'Elimina',
	'lqt_undelete' => 'Restaura',
	'lqt_permalink' => 'Enllaç a',
	'lqt_fragment' => "Fragment d'una $1 de $2",
	'lqt_discussion_link' => 'discussió',
	'lqt_from_talk' => 'Des de $1',
	'lqt-history-title' => 'Historial del fil',
	'lqt_hist_comment_edited' => 'Comentari [$2 editat]',
	'lqt_hist_summary_changed' => 'Resum canviat',
	'lqt_hist_reply_created' => '[[$1|Nova resposta]] creada',
	'lqt_hist_thread_created' => 'Nou fil creat',
	'lqt_hist_deleted' => 'Suprimit',
	'lqt_hist_undeleted' => 'Restaurat',
	'lqt_hist_moved_talkpage' => 'Traslladat',
	'lqt_hist_listing_subtitle' => "Visualització d'una llista de l'historial",
	'lqt_hist_view_whole_thread' => "Visualitza l'historial de tot el fil",
	'lqt_hist_no_revisions_error' => "Aquest fil no té cap revisió a l'historial.",
	'lqt_hist_past_last_page_error' => "Heu sobrepassat el nombre de pàgines de l'historial que existeixen.",
	'lqt_hist_tooltip_newer_disabled' => 'Aquest enllaç està desactivat perquè esteu en la primera pàgina.',
	'lqt_hist_tooltip_older_disabled' => 'Aquest enllaç està desactivat perquè esteu a la darrera pàgina.',
	'lqt_hist_split' => 'Resposta separada a un altre fil',
	'lqt_hist_edited_subject' => 'Tema canviat de "$2" a "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Ha canviat el tema',
	'lqt_hist_merged_from' => '[[$1|Resposta]] desplaçada a un altre fil',
	'lqt_hist_merged_to' => "[[$1|Resposta]] moguda des d'un altre fil",
	'lqt_hist_split_from' => 'Separa-ho a un nou fil',
	'lqt_hist_root_blanked' => "S'ha suprimit el text del comentari",
	'lqt_hist_adjusted_sortkey' => 'Posició del fil ajustada',
	'lqt_revision_as_of' => 'Revisió del dia $2 a $3.',
	'lqt_change_new_thread' => 'Aquesta és la versió inicial del fil.',
	'lqt_change_reply_created' => 'El [$1 comentari destacat] ha estat creat en aquesta revisió.',
	'lqt_change_edited_root' => 'El [$1 comentari destacat] ha estat editat en aquesta revisió.',
	'lqt_change_edited_summary' => 'El tema del fil ha estat modificat',
	'lqt_change_deleted' => '[$1 Aquest fil] o el seu originari ha estat esborrat.',
	'lqt_change_undeleted' => 'El [$1 comentari destacat] ha estat restaurat',
	'lqt_change_moved' => '[$1 Aquest fil] ha estat traslladat a una altra pàgina de discussió',
	'lqt_change_split' => "[$1 Aquest fil] prové de la divisió d'un altre fil",
	'lqt_change_edited_subject' => "S'ha canviat el tema del fil de «$2» a «$3»",
	'lqt_change_merged_from' => 'Una [$1 resposta] a aquest fil va ser moguda a un altre fil',
	'lqt_change_merged_to' => "La [$1 resposta destacada] va ser traslladada des d'un altre fil",
	'lqt_change_split_from' => "Un [$1 subfil] d'aquest fil s'ha separat per esdevenir un fil independent",
	'lqt_change_root_blanked' => "S'ha eliminat el text de [$1 un comentari].",
	'lqt_youhavenewmessages' => 'Teniu [[$1|missatges nous]].',
	'lqt_protectedfromreply' => 'Aquest fil ha estat $1 de poder ser respost.',
	'lqt_protectedfromreply_link' => 'protegit',
	'lqt_subject' => 'Assumpte:',
	'lqt_noreason' => "No s'ha donat cap motiu.",
	'lqt_move_placeholder' => "Aquest fil és un marcador que indica que un fil, $1, va ser desplaçat d'aquesta pàgina cap a una altra pàgina de discussió. Aquest trasllat va ser fet per $2 el $3 a les $4. El fil es troba ara a $5.",
	'lqt_thread_deleted_for_sysops' => "Aquest fil ha estat '''esborrat''' i només és visible pels administradors.",
	'lqt_thread_deleted' => 'Aquest fil ha estat esborrat.',
	'lqt_summary_notice' => 'No hi ha hagut canvis en aquesta discussió en $2 {{PLURAL:$2|dia|dies}}. Si es conclou potser voldreu $1.',
	'lqt_summary_notice_link' => 'escriure un resum',
	'lqt_summary_label' => 'Resum del fil:',
	'lqt_summary_subtitle' => 'Resum de «$1»',
	'lqt_nosuchrevision' => "No existeix tal revisió d'aquest fil.",
	'lqt_nosuchthread' => 'El fil que heu especificat no existeix.',
	'lqt_nosuchthread_title' => 'No hi ha tal fil',
	'lqt_threadrequired' => "Heu d'especificar un fil a la URL.",
	'lqt_move_movingthread' => 'Trasllat de $1.
Aquest fil és part de $2.',
	'lqt_move_torename' => "Per a canviar el nom d'aquest fil, $1 i canvieu l'apartat «Assumpte».",
	'lqt_move_torename_edit' => 'modifiqueu-lo',
	'lqt_move_destinationtitle' => 'Títol destí de la pàgina de discussió:',
	'lqt_move_move' => 'Mou',
	'lqt_move_nodestination' => "Heu d'especificar una destinació.",
	'lqt_move_thread_bad_destination' => 'La pàgina de destinació no és una pàgina de discussió.',
	'lqt_move_samedestination' => 'El fil ja està en aquesta pàgina!',
	'lqt_move_noreason' => "No s'ha donat cap motiu.",
	'lqt_move_success' => "S'ha traslladat el fil a $1.",
	'lqt_delete_undeletethread' => 'Restauració de fil',
	'lqt_delete_partof' => "Aquest fil és part de '''$1'''.",
	'lqt_delete_deleting' => "Suprimeix '''$1''' i '''totes les seves respostes'''.",
	'lqt_delete_deletethread' => 'Elimina el fil i les respostes',
	'lqt_delete_deleted' => 'El fil ha estat esborrat.',
	'lqt_delete_undeleted' => 'El fil ha estat restaurat.',
	'lqt_delete_return' => 'Torna cap a $1.',
	'lqt_delete_return_link' => 'la pàgina de discussió',
	'lqt_delete_unallowed' => 'No esteu autoritzat per eliminar fils.',
	'lqt_delete_show_checkbox' => 'Mostra els fils eliminats',
	'lqt_talkpage_autocreate_summary' => 'Pàgina de discussió creada automàticament quan es va crear el primer fil.',
	'lqt_header_warning_big' => 'Esteu editant un $1.',
	'lqt_header_warning_after_big' => 'Les capçaleres són per anuncis i prefacis.
Potser preferiu $2.',
	'lqt_header_warning_bold' => 'encapçalament de pàgina de discussió',
	'lqt_header_warning_new_discussion' => 'començar una nova discussió',
	'lqt_sorting_order' => 'Ordenació:',
	'lqt_sort_newest_changes' => 'primer els modificats recentment',
	'lqt_sort_newest_threads' => 'primer els fils nous',
	'lqt_sort_oldest_threads' => 'primer els fils antics',
	'lqt-title' => 'Títol',
	'lqt-summary' => 'Resum',
	'lqt-searching' => 'Cerca de fils',
	'lqt-read-message' => 'Marca com a llegit',
	'lqt-read-message-tooltip' => 'Treu aquest fil dels missatges nous.
Encara serà visible en la seva pàgina de discussió original.',
	'lqt-read-all' => "Marca'ls tots com a llegits",
	'lqt-read-all-tooltip' => 'Treu tots els fils dels missatges nous.
Encara estaran visibles en llurs pàgines de discussió originals.
Aquesta operació no es pot desfer.',
	'lqt-marked-read' => "Fil '''$1''' marcat com a llegit.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|missatge marcat com a llegit.|missatges marcats com a llegits.}}',
	'lqt-email-undo' => 'Desfés',
	'lqt-no-new-messages' => 'No teniu missatges nous.',
	'lqt-new-messages' => '✒ Teniu missatges nous.',
	'lqt-email-info-undo' => 'Retorna el fil que acabeu de treure.',
	'lqt-date-info' => 'Aquest enllaç està desactivat perquè esteu veient els fils de totes les dates.',
	'lqt-newmessages-context' => 'Fil complet',
	'lqt-thread-created' => 'Creat',
	'lqt-history-time' => 'Hora',
	'lqt-history-user' => 'Usuari',
	'lqt-history-action' => 'Activitat',
	'lqt-history-comment' => 'Comentari',
	'lqt-history-thread' => 'Fil',
	'lqt-thread-edited-author' => "Editat per l'autor.<br />
Darrera edició: $1",
	'lqt-thread-edited-others' => 'Editat per {{PLURAL:$2|un altre usuari|$2 usuaris}}.<br />
Darrera edició: $1',
	'lqt-header-actions' => 'Accions',
	'lqt_summarize_link' => 'Resum',
	'lqt-summarize-intro' => "Si us plau, feu un resum del fil següent a la caixa d'edició.
Podeu usar sintaxi wiki. Quan acabeu, feu clic a «{{int: Savearticle}}».",
	'lqt-thread-split' => 'Separa-ho a un nou fil',
	'lqt-split-success' => 'Heu dividit el fil $1.',
	'lqt_split_thread' => 'Divideix un fil',
	'lqt-thread-split-subject' => 'Nou tema del fil:',
	'lqt-thread-split-thread' => 'Fil:',
	'lqt-split-submit' => 'Divideix',
	'lqt_split_badsubject' => 'El tema no és vàlid.',
	'lqt-no-threads' => 'En aquesta pàgina encara no hi ha cap fil.',
	'lqt-delete-parent-warning' => "Açò és el nivell superior d'un fil amb respostes.
Les seves respostes també s'eliminaran automàticament.
Si ho voleu evitar, cal que les separeu d'aquest fil abans d'eliminar-lo.",
	'lqt-delete-parent-deleted' => 'Fil pare esborrat ($1)',
	'lqt-delete-replies-done' => "Totes les respostes d'aquest fil també s'han suprimit.",
	'lqt-movethread' => 'Mou',
	'lqt-menu-trigger' => 'Més',
	'lqt-newmessages-from' => 'De $1',
	'lqt-hot-topics' => 'Temes populars',
	'lqt-add-reply' => 'Respon',
	'lqt_rc_new_discussion' => 'publicat un nou fil, "$1"',
	'lqt_rc_new_reply' => 'publicada una resposta a "$1"',
	'right-lqt-split' => 'Separar fils',
	'right-lqt-merge' => 'Fusionar fils',
	'lqt-thread-merge' => 'Fusiona-ho amb un altre fil',
	'lqt-thread-merge-to' => 'Fusiona en aquest fil',
	'lqt_merge_thread' => 'Fusiona fils',
	'lqt-thread-merge-source' => "Fil d'origen:",
	'lqt-thread-merge-dest' => 'Fil de destinació:',
	'lqt-merge-submit' => 'Fusiona',
	'lqt-merge-success' => 'Heu fusionat el fil $1 per sota de $2.',
	'lqt-log-name' => 'Registre de fils de discussió',
	'lqt-log-header' => 'Aquest registre detalla les accions realitzades en fils de discussió.',
	'lqt-log-action-move' => 'desplaçat [[$1]] de [[$2]] a [[$3]].',
	'lqt-log-action-split' => 'divideix [[$1]] per sota de [[$3]], amb el tema nou «$2»',
	'lqt-log-action-merge-across' => "s'ha mogut [[$1]] per sota de [[$2]] a sota de [[$3]]",
	'lqt-log-action-merge-down' => "s'ha fusionat [[$1]] a sota de [[$3]]",
	'lqt-log-action-subjectedit' => "s'ha canviat el tema de [[$1]] de «$2» a «$3»",
	'lqt-log-action-resort' => "s'ha modificat el criteri d'ordenació de [[$1]]. S'ha canviat la clau d'ordenació de $2 a $3",
	'lqt-preference-notify-talk' => "Envia'm un missatge de correu electrònic per les respostes dels temes que vigilo",
	'lqt-preference-watch-threads' => 'Vigila les discussions on hagi participat',
	'prefs-lqt' => 'Discussió en fils',
	'lqt-preference-display-depth' => 'Profunditat màxima de respostes a mostrar:',
	'lqt-preference-display-count' => 'Nombre màxim de respostes a mostrar:',
	'lqt-preference-custom-signatures' => "Mostra les signatures d'usuari personalitzades",
	'lqt-enotif-subject-reply' => 'Discussió a {{SITENAME}} - Resposta: $1',
	'lqt-enotif-subject-newthread' => 'Discussió a {{SITENAME}} - Nou tema: $1',
	'lqt-enotif-newthread' => 'Hola $1,
Açò és una notificació des del projecte {{SITENAME}} per a avisar-vos que un nou fil de de discussió «$2» a $5, ha estat creat el dia $3 a les $4.

El podeu veure a <$6>',
	'lqt-enotif-reply' => 'Hola $1,
Açò és una notificació des del projecte {{SITENAME}} per a avisar-vos que ha aparegut una resposta al fil «$2» a $5, 
creada el dia $3 a les $4.

El podeu veure a <$6>

El text de la resposta és:
$7',
	'lqt-quote-intro' => 'El dia $2 a les $3, [[User:$1|$1]] va escriure:',
	'lqt-quote' => 'Cita-ho',
	'lqt-search-legend' => 'Cerca discussions en aquesta pàgina',
	'lqt-search-label' => 'Termes de cerca:',
	'lqt-search-button' => 'Cerca',
	'searchprofile-threads' => 'Discussions',
	'searchprofile-threads-tooltip' => 'Cerca fils i pàgines de discussió',
	'lqt-ajax-updated' => 'Aquest fil té nous missatges.',
	'lqt-ajax-update-link' => 'Actualitza',
	'lqt-thread-show-replies' => 'Mostra {{PLURAL:$1|una resposta|$1 respostes}}',
	'lqt-thread-show-more' => 'Mostra més respostes',
	'lqt-thread-link-url' => "URL de l'enllaç:",
	'lqt-thread-link-title' => 'Enllaç del text wiki:',
	'lqt-thread-link-copy' => 'Copia-ho al portaretalls',
	'lqt-sign-not-necessary' => 'Es necessari que signeu el vostre apunt amb quatre titlles.
La signatura es mostrarà automàticament.',
	'lqt-marked-as-read-placeholder' => "S'ha marcat el fil $1 com a llegit",
	'lqt-change-subject' => 'Canvia el tema',
	'lqt-save-subject' => 'Desa',
	'lqt-save-subject-failed' => "S'ha produït l'error següent mentre es provava de canviar el tema del fil: $1",
	'lqt-ajax-invalid-subject' => 'El tema que heu especificat no era vàlid, probablement perquè era massa llarg.',
	'lqt-ajax-no-subject' => "Heu d'especificar un tema.",
	'lqt-save-subject-error-unknown' => "S'ha produït un error desconegut que es provava de definir el tema del fil. Torneu-ho a provar fent clic a «edita» a l'apunt superior.",
	'lqt-cancel-subject-edit' => 'Cancel·la',
	'lqt-drag-activate' => 'Arrossega una ubicació nova',
	'lqt-drag-drop-zone' => 'Deixa-ho anar ací',
	'lqt-drag-confirm' => 'Per completar les accions següents, indiqueu-ne un motiu i feu clic a «Confirma».',
	'lqt-drag-reparent' => "Mou l'apunt sota un pare nou.",
	'lqt-drag-split' => "Mou l'apunt al seu propi fil",
	'lqt-drag-setsortkey' => "Ajusta la posició de l'apunt a la pàgina",
	'lqt-drag-bump' => "Mou l'apunt a dalt de la pàgina de discussió",
	'lqt-drag-save' => 'Confirma',
	'lqt-drag-title' => "Confirmeu l'arrossegament",
	'lqt-drag-reason' => 'Motiu:',
	'lqt-drag-subject' => 'Tema del nou fil:',
	'lqt-edit-signature' => '(edita la signatura)',
	'lqt-preview-signature' => '(previsualització)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nous missatges',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nous missatges de $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nous fils',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nous fils de $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Respostes',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Respostes de $1',
	'lqt-feed-new-thread-intro' => 'Nou fil a $1 publicat per $2',
	'lqt-feed-reply-intro' => 'Resposta al fil $3 (dins $1) publicada per $2',
	'lqt-newmessages-n' => 'Missatges nous ($1)',
	'lqt_newmessages' => 'Els meus missatges nous (Cap)',
	'lqt_newmessages-title' => 'Missatges nous',
	'lqt-newpost-summary' => 'Nou fil: $1',
	'lqt-reply-summary' => 'Respon a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historial de la pàgina de discussió',
	'lqt-talkpage-history-subtitle' => 'Per a $1',
	'lqt-talkpage-history-tab' => 'Capçalera',
	'restriction-reply' => 'Envia respostes',
	'restriction-newthread' => 'Envia fils nous',
	'lqt-protected-reply-thread' => "No podeu enviar en aquest fil perquè s'ha protegit perquè no hi hagi nous apunts.",
	'lqt-protected-reply-talkpage' => "No podeu enviar en aquest fil perquè s'ha protegit la pàgina de discussió de respostes als seus fils.",
	'lqt-protected-newthread' => "No podeu enviar fils nous a la pàgina de discussió perquè s'ha protegit de nous fils.",
	'lqt-edit-bump' => 'Abaixa aquest fil',
	'lqt-edit-bump-tooltip' => 'Mou el fil a la part superior de la pàgina de discussió',
	'lqt-historicalrevision-error' => 'La revisió que heu seleccionat és corrupte, i no pot visualitzar-se.',
	'lqt-reply-subpage' => 'contesta',
	'nstab-thread' => 'Fil',
	'nstab-summary' => 'Resum',
);

/** Chechen (Нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'lqt_contents_title' => 'Чулацам',
	'lqt_toc_thread_title' => 'Гаьний коьрте',
	'lqt_toc_thread_replycount' => 'Жоьпаш',
	'lqt_toc_thread_modified' => 'Тlаьххьара хийцамаш',
	'lqt_new_thread' => 'Керла дийцаре долор',
	'lqt_reply' => 'Жоп ло',
	'lqt-parent' => 'Кхоьлнарг',
	'lqt_delete' => 'Дlадайá',
	'lqt_permalink' => 'Хьажориг кхузе',
	'lqt_hist_summary_changed' => 'Жамl хийцна',
	'lqt_youhavenewmessages' => 'Хьуна кхаьчна [[$1|керла хаамаш]].',
	'lqt_subject' => 'Корта:',
	'lqt_summary_notice_link' => 'жамl дан',
	'lqt_delete_return' => 'Юхагlо оцу $1.',
	'lqt_delete_unallowed' => 'Хьуна цамагдо дlадайа яззамаш.',
	'lqt_header_warning_new_discussion' => 'керла дийцаре долор',
	'lqt_sorting_order' => 'Къепе листар:',
	'lqt_sort_newest_changes' => 'хийцам бинарш хьалха',
	'lqt_sort_newest_threads' => 'керла гаьннаш хьалха',
	'lqt_sort_oldest_threads' => 'къена гаьннаш хьалха',
	'lqt-title' => 'Корта',
	'lqt-searching' => 'Гаьнашца лахар',
	'lqt-email-undo' => 'Цаоьшу',
	'lqt-new-messages' => '✒ Хьуна кхаьчна керла хаамаш.',
	'lqt-history-user' => 'Декъашхо',
	'lqt-thread-edited-others' => 'Нисдина {{PLURAL:$2|1 кхечу декъашхочо|$2 кхечу декъашхош|$2 кхечу декъашхош}}.<br />
Тlяххьара нисдинарг: $1',
	'lqt_summarize_link' => 'Жамl дан',
	'lqt-movethread' => 'Кхечухьа йаккха',
	'lqt-menu-trigger' => 'Кхин',
	'prefs-lqt' => 'Дийцарш оцу гéнашца',
	'lqt-search-label' => 'Лахаран хьал:',
	'lqt-search-button' => 'Лаха',
	'searchprofile-threads' => 'Дийцаре',
	'searchprofile-threads-tooltip' => 'Лаха оцу дийцаре гаьнашкахь а дийцаре агlонашкахь',
	'lqt-ajax-updated' => 'Хlокху га чохь керла хаам бу.',
	'lqt-ajax-update-link' => 'Карлаяккха',
	'lqt-thread-show-replies' => '* Гайта $1 жоьпаш',
	'lqt-thread-show-more' => 'Гайта шорта жоьпаш',
	'lqt-change-subject' => 'Нисбе коьрта могlа',
	'lqt-save-subject' => 'lалашдан',
	'lqt-cancel-subject-edit' => 'Цаоьшу',
	'lqt-drag-activate' => 'Дехьа йаккха',
	'lqt-drag-drop-zone' => 'Дехьа йаккха кхузе',
	'lqt-preview-signature' => '(хьалха муха ю хьажар)',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Керла хаамаш $1',
	'lqt-newmessages-n' => 'Керла хаамаш ($1)',
	'lqt_newmessages' => 'Керла хаамаш',
	'lqt_newmessages-title' => 'Керла хаамаш',
	'lqt-talkpage-history-tab' => 'Корта',
	'lqt-reply-subpage' => 'жоп ло',
);

/** Chamorro (Chamoru)
 * @author Gadao01
 * @author Jatrobat
 */
$messages['ch'] = array(
	'lqt_discussion_link' => 'kombetsasion',
);

/** Sorani (کوردی) */
$messages['ckb'] = array(
	'lqt_delete' => 'سڕینەوە',
	'lqt_undelete' => 'گەڕاندنەوەی سڕین',
	'lqt_move_move' => 'گواستنەوە',
	'lqt-summary' => 'پوختە',
	'lqt-history-user' => 'بەکارهێنەر',
	'lqt-movethread' => 'گواستنەوە',
	'lqt-search-button' => 'گەڕان',
	'lqt-save-subject' => 'پاشەکەوت',
	'lqt-drag-save' => 'پشتدار بکەرەوە',
	'lqt-drag-reason' => 'هۆکار:',
);

/** Czech (Česky)
 * @author Kuvaly
 * @author Matěj Grabovský
 * @author Mormegil
 */
$messages['cs'] = array(
	'lqt-desc' => 'Umožňuje uspořádávat diskusní stránky do vláken',
	'lqt_movethread' => 'Přesunout vlákno na jinou stránku',
	'lqt_deletethread' => 'Smazat nebo obnovit vlákno',
	'lqt_contents_title' => 'Obsah',
	'lqt_toc_thread_title' => 'Název vlákna',
	'lqt_toc_thread_author' => 'Zakladatel',
	'lqt_toc_thread_replycount' => 'Odpovědí',
	'lqt_toc_thread_modified' => 'Poslední změna',
	'lqt_add_header' => 'Přidat záhlaví',
	'lqt_new_thread' => 'Začít novou diskusi',
	'lqt_invalid_subject' => 'Zadaný předmět není platný.
Možná, že:
* je příliš dlouhý,
* koliduje s prefixem interwiki nebo názvem jmenného prostoru.',
	'lqt_empty_subject' => 'Musíte vyplnit předmět.',
	'lqt_reply' => 'Odpovědět',
	'lqt-parent' => 'Předchozí',
	'lqt_delete' => 'Smazat',
	'lqt_undelete' => 'Obnovit',
	'lqt_permalink' => 'Odkaz',
	'lqt_fragment' => 'Fragment $1 z $2',
	'lqt_discussion_link' => 'diskuse',
	'lqt_from_talk' => 'Z $1',
	'lqt-history-title' => 'Historie vlákna',
	'lqt_hist_comment_edited' => 'Byl [$2 editován] text komentáře',
	'lqt_hist_summary_changed' => 'Upraveno shrnutí',
	'lqt_hist_reply_created' => 'Přidána [[$1|nová odpověď]]',
	'lqt_hist_thread_created' => 'Založeno nové vlákno',
	'lqt_hist_deleted' => 'Smazáno',
	'lqt_hist_undeleted' => 'Obnoveno',
	'lqt_hist_moved_talkpage' => 'Přesunuto',
	'lqt_hist_listing_subtitle' => 'Prohlížení výpisu historie',
	'lqt_hist_view_whole_thread' => 'Zobrazit historii celého vlákna',
	'lqt_hist_no_revisions_error' => 'Toto vlákno nemá v historii zaznamenané žádné revize.',
	'lqt_hist_past_last_page_error' => 'Překročili jste počet stránek historie.',
	'lqt_hist_tooltip_newer_disabled' => 'Tento odkaz je nefunkční, protože jste na první stránce.',
	'lqt_hist_tooltip_older_disabled' => 'Tento odkaz je nefunkční, protože jste na poslední stránce.',
	'lqt_hist_split' => 'Odpověď oddělena do nového vlákna',
	'lqt_hist_edited_subject' => 'Změněn předmět z „$2“ na „$3“',
	'lqt_hist_edited_subject_corrupt' => 'Změněn předmět',
	'lqt_hist_merged_from' => '[[$1|Odpověď]] přesunuta do jiného vlákna',
	'lqt_hist_merged_to' => '[[$1|Odpověď]] přesunuta z jiného vlákna',
	'lqt_hist_split_from' => 'Odděleno do nového vlákna',
	'lqt_hist_root_blanked' => 'Odstraněn text komentáře',
	'lqt_hist_adjusted_sortkey' => 'Upravena pozice vlákna',
	'lqt_revision_as_of' => 'Verze z $2, $3.',
	'lqt_change_new_thread' => 'Toto je počáteční verze vlákna.',
	'lqt_change_reply_created' => 'V této verzi byl vytvořen [$1 zvýrazněný komentář].',
	'lqt_change_edited_root' => 'V této verzi byl změněn [$1 zvýrazněný komentář].',
	'lqt_change_edited_summary' => 'Bylo změněno shrnutí vlákna',
	'lqt_change_deleted' => 'Bylo smazáno [$1 toto] nebo nadřazené vlákno',
	'lqt_change_undeleted' => '[$1 Zvýrazněný příspěvek] byl obnoven',
	'lqt_change_moved' => '[$1 Toto vlákno] bylo přesunuto na jinou diskusní stránku',
	'lqt_change_split' => '[$1 Toto vlákno] bylo odděleno z jiného',
	'lqt_change_edited_subject' => 'Předmět tohoto vlákna byl změněn z „$2“ na „$3“',
	'lqt_change_merged_from' => '[$1 Odpověď] v tomto vlákně byla přesunuta do jiného vlákna',
	'lqt_change_merged_to' => '[$1 Zvýrazněná odpověď] byla přesunuta z jiného vlákna',
	'lqt_change_split_from' => '[$1 Část tohoto vlákna] byla oddělena do samostatného vlákna',
	'lqt_change_root_blanked' => 'Byl odstraněn text [$1 komentáře].',
	'lqt_youhavenewmessages' => 'Máte [[$1|nové zprávy]].',
	'lqt_protectedfromreply' => 'Toto vlákno je $1, takže na něj nelze odpovídat.',
	'lqt_protectedfromreply_link' => 'zamčeno',
	'lqt_subject' => 'Předmět:',
	'lqt_noreason' => 'Nebyl udán důvod.',
	'lqt_move_placeholder' => 'Toto je pozůstatek vlákna $1, které bylo přesunuto z této stránky do jiné diskuse.
Přesun {{GENDER:$2|provedl|provedla|provedl}} $2 v $4, $3. Vlákno je nyní umístěno na $5.',
	'lqt_thread_deleted_for_sysops' => "Vlákno bylo '''smazáno''' a mohou ho vidět pouze správci.",
	'lqt_thread_deleted' => 'Toto vlákno bylo smazáno.',
	'lqt_summary_notice' => 'Tato diskuse nebyla změněna už nejméně $2 {{PLURAL:$2|den|dny|dní}}.
Pokud byla diskuse ukončena, můžete k ní $1.',
	'lqt_summary_notice_link' => 'napsat shrnutí',
	'lqt_summary_label' => 'Shrnutí vlákna:',
	'lqt_summary_subtitle' => 'Shrnutí „$1“',
	'lqt_nosuchrevision' => 'Tato revize v tomto vlákně neexistuje.',
	'lqt_nosuchthread' => 'Uvedené vlákno neexistuje.',
	'lqt_nosuchthread_title' => 'Neexistující vlákno',
	'lqt_threadrequired' => 'Musíte v URL určit vlákno.',
	'lqt_move_movingthread' => 'Přesouvá se $1.
Toto vlákno je částí $2.',
	'lqt_move_torename' => 'Pro přejmenování vlákna ho $1 a změňte obsah pole „Předmět“.',
	'lqt_move_torename_edit' => 'editujte',
	'lqt_move_destinationtitle' => 'Název cílové diskusní stránky:',
	'lqt_move_move' => 'Přesunout',
	'lqt_move_nodestination' => 'Musíte zadat cíl.',
	'lqt_move_thread_bad_destination' => 'Cílová stránka není diskuse.',
	'lqt_move_samedestination' => 'Vlákno už na této stránce je!',
	'lqt_move_noreason' => 'Důvod nebyl zadán.',
	'lqt_move_success' => 'Vlákno bylo přesunuto na $1.',
	'lqt_delete_undeletethread' => 'Obnovit vlákno',
	'lqt_delete_partof' => "Toto vlákno je součástí '''$1'''.",
	'lqt_delete_deleting' => "Maže se '''$1''' a '''všechny odpovědi''' na něj.",
	'lqt_delete_deletethread' => 'Smazat vlákno a odpovědi',
	'lqt_delete_deleted' => 'Vlákno bylo smazáno.',
	'lqt_delete_undeleted' => 'Vlákno bylo obnoveno.',
	'lqt_delete_return' => 'Vrátit se na $1.',
	'lqt_delete_return_link' => 'diskusní stránku',
	'lqt_delete_unallowed' => 'Nemůžete mazat vlákna.',
	'lqt_delete_show_checkbox' => 'Zobrazit smazaná vlákna.',
	'lqt_talkpage_autocreate_summary' => 'Diskusní stránka vytvořena automaticky při založení prvního vlákna.',
	'lqt_header_warning_big' => 'Editujete $1.',
	'lqt_header_warning_after_big' => 'Záhlaví jsou určena pro oznámení a úvody.
Možná chcete spíše $2.',
	'lqt_header_warning_bold' => 'záhlaví diskusní stránky',
	'lqt_header_warning_new_discussion' => 'začít novou diskusi',
	'lqt_sorting_order' => 'Řazení:',
	'lqt_sort_newest_changes' => 'naposledy změněné nahoře',
	'lqt_sort_newest_threads' => 'nejnovější vlákna nahoře',
	'lqt_sort_oldest_threads' => 'nejstarší vlákna nahoře',
	'lqt-title' => 'Nadpis',
	'lqt-summary' => 'Shrnutí',
	'lqt-searching' => 'Hledají se vlákna',
	'lqt-read-message' => 'Označit jako přečtené',
	'lqt-read-message-tooltip' => 'Odstraní toto vlákno z nových zpráv.
I nadále bude zobrazeno na původní diskusní stránce.',
	'lqt-read-all' => 'Označit vše jako přečtené',
	'lqt-read-all-tooltip' => 'Odstraní všechna vlákna z nových zpráv.
I nadále budou zobrazena na původních diskusních stránkách.
Tuto operaci lze vrátit zpět.',
	'lqt-marked-read' => "Vlákno '''$1''' bylo označeno jako přečtené.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|zpráva označena jako přečtená|zprávy označeny jako přečtené|zpráv označeno jako přečtené}}',
	'lqt-email-undo' => 'Vrátit',
	'lqt-no-new-messages' => 'Nemáte žádné nové zprávy.',
	'lqt-new-messages' => '✒ Máte nové zprávy.',
	'lqt-email-info-undo' => 'Vrátí zpět vlákno, které jste právě {{GENDER:|odbyl|odbyla|odbyli}}.',
	'lqt-date-info' => 'Tento odkaz je nedostupný, protože zobrazujete vlákna bez ohledu na datum.',
	'lqt-newmessages-context' => 'Celé vlákno',
	'lqt-thread-created' => 'Vytvořeno',
	'lqt-history-time' => 'Čas',
	'lqt-history-user' => 'Uživatel',
	'lqt-history-action' => 'Událost',
	'lqt-history-comment' => 'Komentář',
	'lqt-history-thread' => 'Vlákno',
	'lqt-thread-edited-author' => 'Upraveno autorem.<br />
Poslední editace: $1',
	'lqt-thread-edited-others' => 'Upraveno {{PLURAL:$2|jiným uživatelem|jinými uživateli}}.<br />
Poslední editace: $1',
	'lqt-header-actions' => 'Akce',
	'lqt_summarize_link' => 'Shrnout',
	'lqt-summarize-intro' => 'Napište shrnutí níže zobrazeného vlákna do editačního okna.
Ve shrnutí můžete používat libovolný wikitext. Až budete {{GENDER:|hotov|hotova|hotovi}}, klikněte na „{{int:savearticle}}“.',
	'lqt-thread-split' => 'Oddělit do nového vlákna',
	'lqt-split-success' => 'Úspěšně jste {{GENDER:|oddělil|oddělila|oddělili}} vlákno $1.',
	'lqt_split_thread' => 'Oddělit vlákno',
	'lqt-thread-split-subject' => 'Předmět nového vlákna:',
	'lqt-thread-split-thread' => 'Vlákno:',
	'lqt-split-submit' => 'Oddělit',
	'lqt_split_badsubject' => 'Zadaný předmět není platný.',
	'lqt-no-threads' => 'Na této stránce zatím nejsou žádná diskusní vlákna.',
	'lqt-delete-parent-warning' => 'Toto je kořenové diskusní vlákno, ve kterém jsou i odpovědi.
Tyto odpovědi budou také automaticky smazány.
Pokud tomu chcete zabránit, tak je před smazáním nejprve oddělte z tohoto vlákna.',
	'lqt-delete-parent-deleted' => 'Rodičovské vlákno smazáno ($1)',
	'lqt-delete-replies-done' => 'Všechny odpovědi v tomto vlákně byly také smazány.',
	'lqt-movethread' => 'Přesunout',
	'lqt-menu-trigger' => 'Další',
	'lqt-newmessages-from' => 'Z $1',
	'lqt-hot-topics' => 'Horká témata',
	'lqt-add-reply' => 'Přidat odpověď',
	'lqt_rc_new_discussion' => 'založil nové vlákno „$1“',
	'lqt_rc_new_reply' => 'přidal odpověď do „$1“',
	'right-lqt-split' => 'Oddělování vláken',
	'right-lqt-merge' => 'Slučování vláken',
	'lqt-thread-merge' => 'Sloučit do jiného vlákna',
	'lqt-thread-merge-to' => 'Sloučit do tohoto vlákna',
	'lqt_merge_thread' => 'Sloučit vlákna',
	'lqt-thread-merge-source' => 'Zdrojové vlákno:',
	'lqt-thread-merge-dest' => 'Cílové vlákno:',
	'lqt-merge-submit' => 'Sloučit',
	'lqt-merge-success' => 'Úspěšně jste {{GENDER:|sloučil|sloučila|sloučili}} vlákno $1 pod $2.',
	'lqt-log-name' => 'Kniha diskusí ve vláknech',
	'lqt-log-header' => 'Toto je záznam operací s diskusními vlákny.',
	'lqt-log-action-move' => 'přesunuje [[$1]] z [[$2]] do [[$3]].',
	'lqt-log-action-split' => 'vydělil [[$1]] z [[$3]] pod nový předmět „$2“',
	'lqt-log-action-merge-across' => 'přesunul [[$1]] z [[$2]] pod [[$3]]',
	'lqt-log-action-merge-down' => 'sloučil [[$1]] pod [[$3]]',
	'lqt-log-action-subjectedit' => 'změnil předmět [[$1]] z „$2“ na „$3“',
	'lqt-log-action-resort' => 'upravil pořadí [[$1]]. Klíč řazení byl změněn z $2 na $3',
	'lqt-preference-notify-talk' => 'Poslat e-mail při reakcích ve sledovaných vláknech',
	'lqt-preference-watch-threads' => 'Přidávat vlákna, která založím nebo do kterých odpovím, ke sledovaným',
	'prefs-lqt' => 'Diskuse ve vláknech',
	'lqt-preference-display-depth' => 'Zobrazovat odpovědi do úrovně:',
	'lqt-preference-display-count' => 'Maximální počet zobrazovaných odpovědí:',
	'lqt-preference-custom-signatures' => 'Zobrazovat přizpůsobené uživatelské podpisy',
	'lqt-enotif-subject-reply' => 'Diskuse k {{grammar:3sg|{{SITENAME}}}} – Odpověď: $1',
	'lqt-enotif-subject-newthread' => 'Diskuse k {{grammar:3sg|{{SITENAME}}}} – Nové vlákno: $1',
	'lqt-enotif-newthread' => 'Vážený uživateli $1,

toto je oznámení z {{grammar:2sg|{{SITENAME}}}}, že $3 v $4
{{GENDER:$8|založil|založila|založil(a)}} $8 v $5 nové vlákno „$2“.

Můžete si ho prohlédnout na <$6>.

Jeho text:
$7',
	'lqt-enotif-reply' => 'Vážený uživateli $1,

Toto je oznámení z {{grammar:2sg|{{SITENAME}}}}, že $3 v $4
{{GENDER:$8|přidal|přidala|přidal(a)}} $8 v $5 novou odpověď na „$2“.

Můžete si ji prohlédnout na <$6>.

Text odpovědi:
$7',
	'lqt-quote-intro' => '$2 v $3 {{GENDER:$1|napsal|napsala|napsal}} [[User:$1|$1]]:',
	'lqt-quote' => 'Citovat',
	'lqt-search-legend' => 'Hledat v diskusích na této stránce',
	'lqt-search-label' => 'Hledané výrazy:',
	'lqt-search-button' => 'Hledat',
	'searchprofile-threads' => 'Diskuse',
	'searchprofile-threads-tooltip' => 'Prohledávat diskuse a diskusní vlákna',
	'lqt-ajax-updated' => 'V tomto vlákně jsou nové příspěvky.',
	'lqt-ajax-update-link' => 'Aktualizovat',
	'lqt-thread-show-replies' => 'Zobrazit $1 {{PLURAL:$1|odpověď|odpovědi|odpovědí}}',
	'lqt-thread-show-more' => 'Zobrazit další odpovědi',
	'lqt-thread-link-url' => 'URL odkazu:',
	'lqt-thread-link-title' => 'Odkaz ve wikitextu:',
	'lqt-thread-link-copy' => 'Kopírovat do schránky',
	'lqt-sign-not-necessary' => 'Svůj příspěvek nemusíte podepisovat čtyřmi vlnovkami.
Podpis se zobrazuje automaticky.',
	'lqt-marked-as-read-placeholder' => 'Vlákno „$1“ bylo označeno jako přečtené.',
	'lqt-change-subject' => 'Změnit předmět',
	'lqt-save-subject' => 'Uložit',
	'lqt-save-subject-failed' => 'Při pokusu o změnu předmětu tohoto vlákna došlo k následující chybě: $1',
	'lqt-ajax-invalid-subject' => 'Vámi zadaný předmět není platný, pravděpodobně je příliš dlouhý',
	'lqt-ajax-no-subject' => 'Musíte zadat předmět.',
	'lqt-save-subject-error-unknown' => 'Při pokusu o změnu předmětu tohoto vlákna došlo k chybě. Zkuste změnu provést kliknutím na „editovat“ v horním příspěvku.',
	'lqt-cancel-subject-edit' => 'Storno',
	'lqt-drag-activate' => 'Přetáhnout jinam',
	'lqt-drag-drop-zone' => 'Zde pustit',
	'lqt-drag-confirm' => 'Pro dokončení následujících akcí vyplňte důvod a klikněte na „Potvrdit“.',
	'lqt-drag-reparent' => 'Přesunutí příspěvku pod jiný nadřazený příspěvek.',
	'lqt-drag-split' => 'Přesunutí příspěvku do vlastního vlákna',
	'lqt-drag-setsortkey' => 'Změna pozice příspěvku na stránce',
	'lqt-drag-bump' => 'Přesunutí příspěvku navrch diskusní stránky',
	'lqt-drag-save' => 'Potvrdit',
	'lqt-drag-title' => 'Potvrdit přetažení',
	'lqt-drag-reason' => 'Důvod:',
	'lqt-drag-subject' => 'Předmět nového vlákna:',
	'lqt-edit-signature' => '(upravit podpis)',
	'lqt-preview-signature' => '(náhled)',
	'lqt-feed-title-all' => '{{SITENAME}} – Nové příspěvky',
	'lqt-feed-title-all-from' => '{{SITENAME}} – Nové příspěvky z $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – Nová vlákna',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – Nová vlákna z $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – Odpovědi',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – Odpovědi z $1',
	'tooltip-pt-newmessages' => 'Zobrazí nové zprávy ve vláknech nebo na diskusních stránkách, které sledujete',
	'lqt-newmessages-n' => 'Nové zprávy ($1)',
	'lqt_newmessages' => 'Mé nové zprávy (žádné)',
	'lqt_newmessages-title' => 'Nové zprávy',
	'lqt-newpost-summary' => 'Nové vlákno: $1',
	'lqt-reply-summary' => 'Odpověď na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historie diskusní stránky',
	'lqt-talkpage-history-subtitle' => 'Pro stránku $1',
	'lqt-talkpage-history-tab' => 'Hlavička',
	'restriction-reply' => 'Přidávání odpovědí',
	'restriction-newthread' => 'Zakládání nových vláken',
	'lqt-protected-reply-thread' => 'Do tohoto vlákna nemůžete psát, protože bylo zamčeno proti novým příspěvkům.',
	'lqt-protected-reply-talkpage' => 'Do tohoto vlákna nemůžete psát, protože tato diskuse byla zamčena proti přidávání odpovědí do jejích vláken.',
	'lqt-protected-newthread' => 'V této diskusi nemůžete zakládat nová vlákna, protože byla proti nim zamčena.',
	'lqt-edit-bump' => 'Oživit vlákno',
	'lqt-edit-bump-tooltip' => 'Posunout toto vlákno navrch diskusní stránky',
	'lqt-historicalrevision-error' => 'Zvolená revize je poškozena a nelze ji zobrazit.',
	'lqt-reply-subpage' => 'odpověď',
	'nstab-thread' => 'Vlákno',
	'nstab-summary' => 'Shrnutí',
);

/** Kashubian (Kaszëbsczi)
 * @author Kaszeba
 */
$messages['csb'] = array(
	'lqt-newmessages-n' => 'Nowé wiadła ($1)',
	'lqt_newmessages' => 'Nowé wiadła',
	'lqt_newmessages-title' => 'Nowé wiadła',
);

/** Church Slavic (Словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'lqt_delete' => 'поничьжє́ниѥ',
	'lqt_protectedfromreply_link' => 'ꙁабранєно ѥ́стъ',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 * @author Malafaya
 */
$messages['cy'] = array(
	'lqt-desc' => 'Ychwanegu trafodaethau trywydd i dudalennau sgwrs',
	'lqt_movethread' => 'Symud y trywydd i dudalen arall',
	'lqt_deletethread' => 'Dileu neu adfer y trywydd',
	'lqt_contents_title' => 'Cynnwys',
	'lqt_toc_thread_title' => 'Teitl y trywydd',
	'lqt_toc_thread_author' => 'Dechreuwyd gan',
	'lqt_toc_thread_replycount' => 'Atebion',
	'lqt_toc_thread_modified' => 'Newidiwyd ddiwethaf',
	'lqt_add_header' => 'Ychwanegu pennawd',
	'lqt_new_thread' => 'Dechrau trafodaeth newydd',
	'lqt_invalid_subject' => "Mae'r pwnc a roddoch yn annilys. 
Efallai: 
* ei fod yn rhy hir, neu
* bod gwrthdaro yn codi rhyngddo a rhagddodiaid rhyngwici neu ag enwau parthau'r wici.",
	'lqt_empty_subject' => "Mae'n rhaid gosod pwnc.",
	'lqt_reply' => 'Ateb',
	'lqt-parent' => 'Y neges gynt',
	'lqt_delete' => 'Dileu',
	'lqt_undelete' => 'Adfer',
	'lqt_permalink' => 'Cysylltu i hwn',
	'lqt_fragment' => 'Darn o $1 ar $2',
	'lqt_discussion_link' => 'drafodaeth',
	'lqt_from_talk' => 'O $1',
	'lqt-history-title' => 'Hanes y trywydd',
	'lqt_hist_comment_edited' => 'Cynnwys y sylw [$2 a olygwyd]',
	'lqt_hist_summary_changed' => 'Newidiwyd y crynodeb',
	'lqt_hist_reply_created' => 'Gosodwyd [[$1|ateb newydd]]',
	'lqt_hist_thread_created' => 'Dechreuwyd trywydd newydd',
	'lqt_hist_deleted' => 'Dilëwyd',
	'lqt_hist_undeleted' => 'Adferwyd',
	'lqt_hist_moved_talkpage' => 'Symudwyd',
	'lqt_hist_listing_subtitle' => 'Yn dangos yr hanes ar restr',
	'lqt_hist_view_whole_thread' => 'Gweld hanes y trywydd cyfan',
	'lqt_hist_no_revisions_error' => 'Nid oes gan y trywydd hwn unrhyw hanes diwygio.',
	'lqt_youhavenewmessages' => 'Mae [[$1|negeseuon newydd]] gennych.',
	'lqt_subject' => 'Pwnc:',
	'lqt_noreason' => 'Dim rheswm wedi ei grybwyll.',
	'lqt_summary_notice_link' => 'ysgrifennu crynodeb',
	'lqt_summary_label' => 'Crynodeb y trywydd:',
	'lqt_summary_subtitle' => 'Crynodeb "$1"',
	'lqt_nosuchthread' => "Nid yw'r trywydd a enwyd ar gael.",
	'lqt_nosuchthread_title' => 'Y trywydd ddim ar gael',
	'lqt_threadrequired' => "Rhaid enwi'r trywydd yn yr URL.",
	'lqt_move_move' => 'Symud',
	'lqt_move_noreason' => 'Dim rheswm wedi ei roi',
	'lqt_move_success' => 'Symudwyd y trywydd i $1.',
	'lqt_delete_deleted' => 'Dilëwyd y trywydd.',
	'lqt_delete_undeleted' => 'Dad-ddilëwyd y trywydd.',
	'lqt_delete_return' => 'Dychwelyd i $1.',
	'lqt_sorting_order' => 'Gosod y trywyddau yn nhrefn:',
	'lqt_sort_newest_changes' => "y diweddaraf i'w addasu",
	'lqt_sort_newest_threads' => 'y diweddaraf',
	'lqt_sort_oldest_threads' => 'yr hynaf',
	'lqt-title' => 'Teitl',
	'lqt-summary' => 'Crynodeb',
	'lqt-email-undo' => 'Dadwneud',
	'lqt-no-new-messages' => 'Nid oes unrhyw negeseuon newydd i chi.',
	'lqt-new-messages' => '✒ Mae negeseuon newydd ar gael i chi.',
	'lqt-history-time' => 'Amser',
	'lqt-history-user' => 'Defnyddiwr',
	'lqt-history-action' => 'Gweithred',
	'lqt-history-comment' => 'Sylw',
	'lqt-history-thread' => 'Trywydd',
	'lqt-movethread' => 'Symud',
	'lqt-menu-trigger' => 'Mwy',
	'lqt-preview-signature' => '(rhagolwg)',
	'lqt-newmessages-n' => 'Negeseuon newydd ($1)',
	'lqt_newmessages' => 'Negeseuon newydd (Dim)',
	'lqt_newmessages-title' => 'Negeseuon newydd',
);

/** Danish (Dansk)
 * @author Jon Harald Søby
 * @author Peter Alberti
 */
$messages['da'] = array(
	'lqt-desc' => 'Tilføjer trådbaserede diskussioner til diskussionssider',
	'lqt_movethread' => 'Flyt tråd til en anden side',
	'lqt_deletethread' => 'Slet eller gendan tråd',
	'lqt_contents_title' => 'Indhold',
	'lqt_toc_thread_title' => 'Trådnavn',
	'lqt_toc_thread_author' => 'Startet af',
	'lqt_toc_thread_replycount' => 'Svar',
	'lqt_toc_thread_modified' => 'Senest ændret',
	'lqt_add_header' => 'Tilføj overskrift',
	'lqt_new_thread' => 'Begynd en ny diskussion',
	'lqt_invalid_subject' => 'Emnet, du angav, er ugyldigt.
Det kan være fordi det er
* for langt eller
* i konflikt med interwikipræfikser eller navne på navnerum.',
	'lqt_empty_subject' => 'Du skal angive et emne.',
	'lqt_reply' => 'Besvar',
	'lqt-parent' => 'Forælder',
	'lqt_delete' => 'Slet',
	'lqt_undelete' => 'Gendan',
	'lqt_permalink' => 'Link hertil',
	'lqt_fragment' => 'Fragment af en $1 fra $2',
	'lqt_discussion_link' => 'diskussion',
	'lqt_from_talk' => 'Fra $1',
	'lqt-history-title' => 'Trådhistorik',
	'lqt_hist_comment_edited' => 'Kommentartekst [$2 redigeret]',
	'lqt_hist_summary_changed' => 'Sammenfatning ændret',
	'lqt_hist_reply_created' => '[[$1|Nyt svar]] oprettet',
	'lqt_hist_thread_created' => 'Ny tråd oprettet',
	'lqt_hist_deleted' => 'Slettet',
	'lqt_hist_undeleted' => 'Gendannet',
	'lqt_hist_moved_talkpage' => 'Flyttet',
	'lqt_hist_view_whole_thread' => 'Se historik for hele tråden',
	'lqt_hist_edited_subject' => 'Emne ændret fra "$2" til "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Ændret emne',
	'lqt_revision_as_of' => 'Version fra $2 kl. $3.',
	'lqt_change_new_thread' => 'Dette er trådens første revision.',
	'lqt_change_edited_summary' => 'Trådens sammenfatning blev redigeret',
	'lqt_change_root_blanked' => 'Teksten til [$1 en kommentar] blev fjernet.',
	'lqt_youhavenewmessages' => 'Du har [[$1|nye beskeder]].',
	'lqt_protectedfromreply_link' => 'beskyttet',
	'lqt_subject' => 'Emne:',
	'lqt_noreason' => 'Ingen begrundelse angivet.',
	'lqt_thread_deleted_for_sysops' => "Denne tråd er blevet '''slettet''' og kan kun ses af administratorer.",
	'lqt_thread_deleted' => 'Denne tråd er blevet slettet.',
	'lqt_summary_notice' => 'Der har ikke været nogen ændringer til denne diskussion i mindst $2 {{PLURAL:$2|dag|dage}}.
Hvis den er afsluttet, vil du måske $1.',
	'lqt_summary_notice_link' => 'skrive en sammenfatning',
	'lqt_summary_label' => 'Sammenfatning af tråden:',
	'lqt_summary_subtitle' => 'Sammenfatning af "$1"',
	'lqt_nosuchthread' => 'Den angivne tråd findes ikke.',
	'lqt_move_movingthread' => 'Flytter $1.
Denne tråd er en del af $2.',
	'lqt_move_torename_edit' => 'rediger den',
	'lqt_move_move' => 'Flyt',
	'lqt_move_nodestination' => 'Du skal angive en destination.',
	'lqt_move_samedestination' => 'Tråden er allerede på denne side!',
	'lqt_move_noreason' => 'Ingen begrundelse angivet.',
	'lqt_move_success' => 'Tråden blev flyttet til $1.',
	'lqt_delete_undeletethread' => 'Gendan tråd',
	'lqt_delete_partof' => "Denne tråd er en del af '''$1'''.",
	'lqt_delete_deleting' => "Sletter '''$1''' og '''alle tilhørende svar'''.",
	'lqt_delete_deletethread' => 'Slet tråd og svar',
	'lqt_delete_deleted' => 'Tråden blev slettet.',
	'lqt_delete_undeleted' => 'Tråden blev gendannet.',
	'lqt_delete_return' => 'Tilbage til $1.',
	'lqt_delete_return_link' => 'diskussionssiden',
	'lqt_delete_unallowed' => 'Du har ikke tilladelse til at slette tråde.',
	'lqt_delete_show_checkbox' => 'Vis slettede tråde',
	'lqt_header_warning_big' => 'Du er ved at redigere en $1.',
	'lqt_header_warning_new_discussion' => 'begynde en ny diskussion',
	'lqt_sorting_order' => 'Sorteringsrækkefølge:',
	'lqt_sort_newest_changes' => 'sidst ændrede først',
	'lqt_sort_newest_threads' => 'nyeste tråde først',
	'lqt_sort_oldest_threads' => 'ældste tråde først',
	'lqt-title' => 'Titel',
	'lqt-summary' => 'Sammenfatning',
	'lqt-searching' => 'Søger efter tråde',
	'lqt-read-message' => 'Marker som læst',
	'lqt-read-all' => 'Marker alle som læste',
	'lqt-marked-read' => "Tråden '''$1''' er markeret som læst.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|besked er markeret som læst|beskeder er markeret som læste}}.',
	'lqt-email-undo' => 'Fortryd',
	'lqt-no-new-messages' => 'Du har ingen nye beskeder.',
	'lqt-new-messages' => '✒ Du har nye beskeder.',
	'lqt-newmessages-context' => 'Hele tråden',
	'lqt-thread-created' => 'Oprettet',
	'lqt-history-time' => 'Tidspunkt',
	'lqt-history-user' => 'Bruger',
	'lqt-history-action' => 'Handling',
	'lqt-history-comment' => 'Kommentar',
	'lqt-history-thread' => 'Tråd',
	'lqt-thread-edited-author' => 'Redigeret af forfatteren.<br />
Seneste redigering: $1',
	'lqt-thread-edited-others' => 'Redigeret af {{PLURAL:$2|en anden bruger|$2 andre brugere}}.<br />
Seneste redigering: $1',
	'lqt-header-actions' => 'Handlinger',
	'lqt_summarize_link' => 'Sammenfat',
	'lqt-thread-split-thread' => 'Tråd:',
	'lqt-no-threads' => 'Der er endnu ingen tråde på denne side.',
	'lqt-delete-replies-done' => 'Alle svar til denne tråd er også blevet slettet.',
	'lqt-movethread' => 'Flyt',
	'lqt-menu-trigger' => 'Mere',
	'lqt-newmessages-from' => 'Fra $1',
	'lqt-hot-topics' => 'Populære emner',
	'lqt-add-reply' => 'Tilføj et svar',
	'right-lqt-split' => 'Adskille tråde',
	'right-lqt-merge' => 'Sammenflette tråde',
	'right-lqt-react' => 'Besvare tråde',
	'lqt-thread-merge' => 'Sammenflet med en anden tråd',
	'lqt-thread-merge-to' => 'Sammenflet med denne tråd',
	'lqt_merge_thread' => 'Sammenflet tråd',
	'lqt-thread-merge-source' => 'Kildetråd:',
	'lqt-thread-merge-dest' => 'Destinationstråd:',
	'lqt-merge-submit' => 'Sammenflet',
	'lqt-merge-success' => 'Du har med held flettet tråden $1 ind under $2.',
	'lqt-log-name' => 'Log for trådbaserede diskussioner',
	'lqt-log-header' => 'Denne log oplister handlinger foretaget på diskussionstråde.',
	'lqt-log-action-move' => 'flyttede [[$1]] fra [[$2]] til [[$3]]',
	'lqt-log-action-split' => 'adskilte [[$1]] fra under [[$3]] med det nye emne "$2"',
	'lqt-log-action-merge-across' => 'flyttede [[$1]] fra under [[$2]] til under [[$3]]',
	'lqt-log-action-merge-down' => 'flettede [[$1]] ind under [[$3]]',
	'lqt-log-action-subjectedit' => 'ændrede emnet af [[$1]] fra "$2" til "$3"',
	'lqt-preference-watch-threads' => 'Overvåg tråde, jeg opretter eller svarer på',
	'prefs-lqt' => 'Trådbaseret diskussion',
	'lqt-preference-display-depth' => 'Maksimal svardybde, der skal vises:',
	'lqt-preference-display-count' => 'Maksimalt antal svar, der skal vises:',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-diskussion - Svar: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-diskussion - Ny tråd: $1',
	'lqt-quote-intro' => 'Den $2 kl. $3, skrev [[User:$1|$1]]:',
	'lqt-quote' => 'Citér',
	'lqt-search-legend' => 'Søg i diskussioner på denne side',
	'lqt-search-label' => 'Søgeord:',
	'lqt-search-button' => 'Søg',
	'searchprofile-threads' => 'Diskussioner',
	'searchprofile-threads-tooltip' => 'Søg i trådbaserede diskussioner og diskussionssider',
	'lqt-ajax-updated' => 'Denne tråd har nye indlæg.',
	'lqt-ajax-update-link' => 'Opdater',
	'lqt-thread-show-replies' => 'Vis $1 {{PLURAL:$1|svar|svar}}',
	'lqt-thread-show-more' => 'Vis flere svar',
	'lqt-thread-link-title' => 'Wikitekstlink:',
	'lqt-thread-link-copy' => 'Kopier til udklipsholder',
	'lqt-sign-not-necessary' => 'Det er ikke nødvendigt at underskrive dit indlæg med fire tilder.
Signaturen vises automatisk.',
	'lqt-marked-as-read-placeholder' => 'Tråden $1 blev markeret som læst.',
	'lqt-change-subject' => 'Skift emne',
	'lqt-save-subject' => 'Gem',
	'lqt-ajax-no-subject' => 'Du skal angive et emne for den nye tråd.',
	'lqt-cancel-subject-edit' => 'Afbryd',
	'lqt-drag-activate' => 'Træk til ny placering',
	'lqt-drag-split' => 'Flyt indlæg til sin egen tråd',
	'lqt-drag-save' => 'Bekræft',
	'lqt-drag-reason' => 'Begrundelse:',
	'lqt-drag-subject' => 'Emne for ny tråd (påkrævet):',
	'lqt-edit-signature' => '(rediger signatur)',
	'lqt-feed-title-all' => '{{SITENAME}} – Nye indlæg',
	'lqt-feed-title-all-from' => '{{SITENAME}} – Nye indlæg fra $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – Nye tråde',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – Nye tråde fra $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – Svar',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – Svar fra $1',
	'lqt-newmessages-n' => 'Mine nye beskeder ($1)',
	'lqt_newmessages' => 'Mine nye beskeder (ingen)',
	'lqt_newmessages-title' => 'Nye beskeder',
	'lqt-newpost-summary' => 'Ny tråd: $1',
	'lqt-reply-summary' => 'Svar på [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Diskussionssidehistorik',
	'lqt-talkpage-history-subtitle' => 'For $1',
	'lqt-talkpage-history-tab' => 'Overskrift',
	'lqt-edit-bump-tooltip' => 'Flyt denne tråd til toppen af ​​sin diskussionsside',
	'lqt-historicalrevision-error' => 'Versionen, du har valgt, er korrupt og kan ikke vises.',
	'lqt-reply-subpage' => 'svar',
	'nstab-thread' => 'Tråd',
	'nstab-summary' => 'Sammenfatning',
);

/** German (Deutsch)
 * @author Als-Holder
 * @author ChrisiPK
 * @author DaSch
 * @author Giftpflanze
 * @author Goran Maric
 * @author Imre
 * @author JakobVoss
 * @author Kghbln
 * @author MF-Warburg
 * @author McDutchie
 * @author Merlissimo
 * @author Metalhead64
 * @author Michawiki
 * @author Pill
 * @author Purodha
 * @author Raimond Spekking
 * @author Revolus
 * @author Salasar
 * @author Tbleher
 * @author The Evil IP address
 * @author Umherirrender
 * @author Wikinaut
 */
$messages['de'] = array(
	'lqt-desc' => 'Ermöglicht Themen auf Diskussionsseiten',
	'lqt_movethread' => 'Verschiebe Thema auf eine andere Seite',
	'lqt_deletethread' => 'Lösche oder stelle Thema wieder her',
	'lqt_contents_title' => 'Inhalt',
	'lqt_toc_thread_title' => 'Betreff',
	'lqt_toc_thread_author' => 'Eröffnet von',
	'lqt_toc_thread_replycount' => 'Antworten',
	'lqt_toc_thread_modified' => 'Zuletzt geändert',
	'lqt_add_header' => 'Kopfbereich ergänzen',
	'lqt_new_thread' => 'Neues Thema beginnen',
	'lqt_invalid_subject' => 'Der Betreff, den du eingegeben hast, ist ungültig.
Es ist möglich, dass er
* zu lang ist oder
* im Konflikt mit Interwikipräfixen oder Namensraumbezeichnern steht.',
	'lqt_empty_subject' => 'Du musst einen Betreff eingeben.',
	'lqt_reply' => 'Antworten',
	'lqt-parent' => 'übergeordnete Antwort',
	'lqt_delete' => 'Löschen',
	'lqt_undelete' => 'wiederherstellen',
	'lqt_permalink' => 'Permanentlink',
	'lqt_fragment' => 'Teil einer $1 von $2',
	'lqt_discussion_link' => 'Diskussion',
	'lqt_from_talk' => 'Von $1',
	'lqt-history-title' => 'Diskussionsverlauf',
	'lqt_hist_comment_edited' => 'Kommentartext [$2 bearbeitet]',
	'lqt_hist_summary_changed' => 'Zusammenfassung geändert',
	'lqt_hist_reply_created' => '[[$1|Neue Antwort]] gegeben',
	'lqt_hist_thread_created' => 'Neues Thema begonnen',
	'lqt_hist_deleted' => 'gelöscht',
	'lqt_hist_undeleted' => 'wiederhergestellt',
	'lqt_hist_moved_talkpage' => 'verschoben',
	'lqt_hist_listing_subtitle' => 'Ansehen einer Versionsgeschichte',
	'lqt_hist_view_whole_thread' => 'Versionsgeschichte eines ganzen Themas ansehen',
	'lqt_hist_no_revisions_error' => 'Dieses Thema hat keine Versionsgeschichte.',
	'lqt_hist_past_last_page_error' => 'Du bist außerhalb des Seitenbereichs der Versionsgeschichte.',
	'lqt_hist_tooltip_newer_disabled' => 'Der Link ist deaktiviert, da du dich auf der ersten Seite befindest.',
	'lqt_hist_tooltip_older_disabled' => 'Der Link ist deaktiviert, da du dich auf der letzten Seite befindest.',
	'lqt_hist_split' => 'Antwort wurde auf ein neues Thema aufgeteilt',
	'lqt_hist_edited_subject' => 'Der Betreff wurde von „$2“ auf „$3“ geändert',
	'lqt_hist_edited_subject_corrupt' => 'Betreff geändert',
	'lqt_hist_merged_from' => 'Die [[$1|Antwort]] wurde zu einem anderen Thema verschoben',
	'lqt_hist_merged_to' => 'Die [[$1|Antwort]] wurde von einem anderen Thema verschoben',
	'lqt_hist_split_from' => 'In neues Thema aufteilen',
	'lqt_hist_root_blanked' => 'Kommentar wurde entfernt',
	'lqt_hist_adjusted_sortkey' => 'Position des Themas angepasst',
	'lqt_revision_as_of' => 'Version vom $2 um $3 Uhr.',
	'lqt_change_new_thread' => 'Dies ist die erste Version des Themas.',
	'lqt_change_reply_created' => 'Der [$1 hervorgehobene Kommentar] wurde in dieser Version erstellt.',
	'lqt_change_edited_root' => 'Der [$1 hervorgehobene Kommentar] wurde in dieser Version bearbeitet.',
	'lqt_change_edited_summary' => 'Die Zusammenfassung dieses Themas wurde bearbeitet',
	'lqt_change_deleted' => '[$1 Dieser] oder ein übergeordneter Beitrag wurden gelöscht',
	'lqt_change_undeleted' => 'Der [$1 hervorgehobene Beitrag] wurde wiederhergestellt',
	'lqt_change_moved' => '[$1 Dieses Thema] wurde auf eine andere Diskussionsseite verschoben',
	'lqt_change_split' => '[$1 Dieses Thema] wurde aus einem anderen Thema abgetrennt',
	'lqt_change_edited_subject' => 'Der Betreff dieses Themas wurde von „$2“ zu „$3“ geändert',
	'lqt_change_merged_from' => 'Eine [$1 Antwort] auf diesen Beitrag wurde zu einem anderen Thema verschoben',
	'lqt_change_merged_to' => 'Die [$1 hervorgehobene Antwort] wurde von einem anderen Thema hierhin verschoben',
	'lqt_change_split_from' => 'Ein [$1 Teil] dieses Themas wurde als eigenes Thema ausgelagert',
	'lqt_change_root_blanked' => 'Der Text [$1 eines Kommentars] wurde entfernt.',
	'lqt_youhavenewmessages' => 'Du hast [[$1|neue Nachrichten]].',
	'lqt_protectedfromreply' => 'Dieses Thema wurde $1. Eine Antwort ist nicht möglich.',
	'lqt_protectedfromreply_link' => 'geschützt',
	'lqt_subject' => 'Betreff:',
	'lqt_noreason' => 'Es wurde kein Grund angegeben.',
	'lqt_move_placeholder' => 'Dieser Beitrag ist ein Platzhalter um anzuzeigen, dass das Thema $1 auf eine andere Diskussionsseite verschoben wurde. Die Verschiebung erfolgte durch $2 am $3 um $4 Uhr. Das Thema befindet sich jetzt auf der Seite $5.',
	'lqt_thread_deleted_for_sysops' => "Dieses Thema wurde '''gelöscht''' und ist nur für Administratoren sichtbar.",
	'lqt_thread_deleted' => 'Dieses Thema wurde gelöscht.',
	'lqt_summary_notice' => 'Zu diesem Thema gibt es seit $2 {{PLURAL:$2|Tag|Tagen}} keine neuen Beiträge.
Sofern die Diskussion beendet ist, möchtest du vielleicht eine $1.',
	'lqt_summary_notice_link' => 'Zusammenfassung schreiben',
	'lqt_summary_label' => 'Zusammenfassung:',
	'lqt_summary_subtitle' => 'Zusammenfassung von „$1“',
	'lqt_nosuchrevision' => 'Eine solche Version des Themas gibt es nicht.',
	'lqt_nosuchthread' => 'Das angegebene Thema ist nicht vorhanden.',
	'lqt_nosuchthread_title' => 'Thema nicht gefunden',
	'lqt_threadrequired' => 'In der URL muss ein Thema angegeben werden.',
	'lqt_move_movingthread' => 'Verschiebe $1.
Dieses Thema ist Teil der Seite „$2“.',
	'lqt_move_torename' => 'Um das Thema umzubenennen, $1 und ändere das Feld „Betreff“.',
	'lqt_move_torename_edit' => 'bearbeite es',
	'lqt_move_destinationtitle' => 'Name der Diskussionsseite:',
	'lqt_move_move' => 'Verschieben',
	'lqt_move_nodestination' => 'Es muss eine Zielseite angegeben werden.',
	'lqt_move_thread_bad_destination' => 'Die Zielseite ist keine Diskussionsseite.',
	'lqt_move_samedestination' => 'Dieses Thema ist bereits auf dieser Seite vorhanden!',
	'lqt_move_noreason' => 'kein Grund angegeben.',
	'lqt_move_success' => 'Das Thema wurde nach $1 verschoben.',
	'lqt_delete_undeletethread' => 'Thema wiederherstellen',
	'lqt_delete_partof' => "Das Thema ist Teil von '''$1.'''",
	'lqt_delete_deleting' => "Löschung von '''$1''' und '''aller zugehörigen Antworten.'''",
	'lqt_delete_deletethread' => 'Das Thema mitsamt allen Beiträgen löschen.',
	'lqt_delete_deleted' => 'Das Thema wurde gelöscht.',
	'lqt_delete_undeleted' => 'Das Thema wurde wiederhergestellt.',
	'lqt_delete_return' => 'Zurück zu $1.',
	'lqt_delete_return_link' => 'der Diskussionsseite',
	'lqt_delete_unallowed' => 'Du hast nicht die Berechtigung Themen zu löschen.',
	'lqt_delete_show_checkbox' => 'Zeige gelöschte Themen',
	'lqt_talkpage_autocreate_summary' => 'Die Diskussionsseite wurde automatisch mit dem ersten Thema angelegt',
	'lqt_header_warning_big' => 'Du bearbeitest gerade den $1.',
	'lqt_header_warning_after_big' => 'Dieser Bereich ist für Ankündigungen, Einleitungen und Hinweise vorgesehen.
Möglicherweise möchtest du stattdessen ein $2.',
	'lqt_header_warning_bold' => 'Kopfbereich einer Diskussionsseite',
	'lqt_header_warning_new_discussion' => 'neues Thema beginnen',
	'lqt_sorting_order' => 'Sortierung:',
	'lqt_sort_newest_changes' => 'zuletzt geänderte Themen zuerst',
	'lqt_sort_newest_threads' => 'neueste Themen zuerst',
	'lqt_sort_oldest_threads' => 'älteste Themen zuerst',
	'lqt-title' => 'Titel',
	'lqt-summary' => 'Inhaltsangabe',
	'lqt-searching' => 'Suche nach Themen',
	'lqt-read-message' => 'Als gelesen markieren',
	'lqt-read-message-tooltip' => 'Entferne dieses Thema aus den neuen Nachrichten.
Er wird weiterhin auf der ursprünglichen Diskussionsseite zu sehen sein.',
	'lqt-read-all' => 'Alle als gelesen markieren',
	'lqt-read-all-tooltip' => 'Entferne alle Themen aus neuen Nachrichten.
Sie sind weiterhin auf den ursprünglichen Diskussionsseiten sichtbar.
Diese Operation kann rückgängig gemacht werden.',
	'lqt-marked-read' => "Thema '''$1''' wurde als gelesen markiert.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|Nachricht|Nachrichten}} als gelesen markiert.',
	'lqt-email-undo' => 'Rückgängig',
	'lqt-no-new-messages' => 'Du hast keine neuen Nachrichten.',
	'lqt-new-messages' => '→ Du hast neue Nachrichten.',
	'lqt-email-info-undo' => 'Hole das Thema zurück, das du gerade weggeklickt hast.',
	'lqt-date-info' => 'Dieser Link ist nicht aktiv, da du Themen von allen Daten ansiehst.',
	'lqt-newmessages-context' => 'Gesamtes Thema',
	'lqt-thread-created' => 'Erstellt',
	'lqt-history-time' => 'Zeit',
	'lqt-history-user' => 'Benutzer',
	'lqt-history-action' => 'Aktivität',
	'lqt-history-comment' => 'Kommentar',
	'lqt-history-thread' => 'Thema',
	'lqt-thread-edited-author' => 'Vom Autor bearbeitet.<br />
Letzte Bearbeitung: $4, $3 Uhr',
	'lqt-thread-edited-others' => 'Von {{PLURAL:$2|einem anderen Benutzer|$2 Benutzern}} geändert.<br />
Letzte Bearbeitung: $4, $3 Uhr',
	'lqt-header-actions' => 'Aktionen',
	'lqt_summarize_link' => 'zusammenfassen',
	'lqt-summarize-intro' => 'Bitte fasse das untenstehende Thema im Bearbeitungsfenster zusammen.
Du kannst Wikitext in deiner Zusammenfassung verwenden. Sobald du fertig bist, klicke auf „{{int:savearticle}}“.',
	'lqt-thread-split' => 'In neues Thema aufteilen',
	'lqt-split-success' => 'Du hast das Thema $1 erfolgreich geteilt.',
	'lqt_split_thread' => 'Thema teilen',
	'lqt-thread-split-subject' => 'Betreff des neuen Themas:',
	'lqt-thread-split-thread' => 'Thema:',
	'lqt-split-submit' => 'Teilen',
	'lqt_split_badsubject' => 'Der eingegebene Betreff ist ungültig.',
	'lqt-no-threads' => 'Diese Seite enthält noch keine Themen.',
	'lqt-delete-parent-warning' => 'Dies ist ein Thema auf höchster Ebene mit Antworten.
Auch seine Antworten werden automatisch gelöscht.
Um dies zu vermeiden, teile sie von diesem Thema ab, bevor du es löscht.',
	'lqt-delete-parent-deleted' => 'Der übergeordnete Themenbeitrag wurde gelöscht ($1)',
	'lqt-delete-replies-done' => 'Sämtliche Antworten zu dieser Diskussion wurden ebenfalls gelöscht.',
	'lqt-movethread' => 'Verschieben',
	'lqt-menu-trigger' => 'Mehr',
	'lqt-newmessages-from' => 'Von $1',
	'lqt-hot-topics' => 'Populäre Themen',
	'lqt-add-reply' => 'Antwort hinzufügen',
	'lqt_rc_new_discussion' => 'Neue Diskussion „$1“',
	'lqt_rc_new_reply' => 'Antwort auf „$1“',
	'right-lqt-split' => 'Thema teilen',
	'right-lqt-merge' => 'Themen zusammenführen',
	'right-lqt-react' => 'Antworte auf Themen',
	'lqt-thread-merge' => 'Mit einem anderen Thema zusammenführen',
	'lqt-thread-merge-to' => 'Mit diesem Thema zusammenführen',
	'lqt_merge_thread' => 'Thema zusammenführen',
	'lqt-thread-merge-source' => 'Ursprungsdiskussion:',
	'lqt-thread-merge-dest' => 'Zieldiskussion:',
	'lqt-merge-submit' => 'Zusammenführen',
	'lqt-merge-success' => 'Das Thema $1 wurde erfolgreich mit $2 zusammengeführt.',
	'lqt-log-name' => 'Themen-Logbuch',
	'lqt-log-header' => 'Dieses Logbuch enthält Details zu Aktionen, die bezüglich Themen ausgeführt wurden.',
	'lqt-log-action-move' => 'hat [[$1]] von [[$2]] nach [[$3]] verschoben',
	'lqt-log-action-split' => 'trennte [[$1]] von [[$3]] ab, neuer Betreff ist „$2“',
	'lqt-log-action-merge-across' => 'veschob [[$1]] von [[$2]] nach [[$3]]',
	'lqt-log-action-merge-down' => 'führte [[$1]] nach [[$3]] zusammen',
	'lqt-log-action-subjectedit' => 'änderte den Betreff von [[$1]] von „$2“ auf „$3“',
	'lqt-log-action-resort' => 'veränderte den Sortierschlüssel von [[$1]]. Sortierschlüssel geändert von $2 nach $3',
	'lqt-preference-notify-talk' => 'Bei Antworten zu beobachteten Themen E-Mails senden',
	'lqt-preference-watch-threads' => 'Selbst erstellte oder von mir bearbeitete Themen beobachten',
	'prefs-lqt' => 'Thema',
	'lqt-preference-display-depth' => 'Maximale Antworttiefe:',
	'lqt-preference-display-count' => 'Maximale Anzahl anzuzeigender Antworten:',
	'lqt-preference-custom-signatures' => 'Benutzersignaturen zeigen',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-Diskussion – Antwort: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-Diskussion – Neues Thema: $1',
	'lqt-enotif-newthread' => 'Hallo $1,

dies ist eine Benachrichtigung von {{SITENAME}}. Von Benutzer $8 wurde am $3 um $4 Uhr auf der Seite „$5“ das neue Thema „$2“ begonnen.

Du kannst es unter diesem Link einsehen: <$6>

Die Nachricht lautet:
$7',
	'lqt-enotif-reply' => 'Hallo $1,

dies ist eine Benachrichtigung von {{SITENAME}}. Von Benutzer $8 wurde am $3 um $4 Uhr auf der Seite „$5“ zum Thema „$2“ eine neue Nachricht verfasst.

Du kannst sie unter diesem Link einsehen: <$6>

Die Nachricht lautet:
$7',
	'lqt-quote-intro' => 'Am $2 um $3 Uhr schrieb [[User:$1|$1]]:',
	'lqt-quote' => 'Zitieren',
	'lqt-search-legend' => 'Durchsuche die Themenbeiträge auf dieser Seite',
	'lqt-search-label' => 'Suchbegriffe:',
	'lqt-search-button' => 'Suche',
	'searchprofile-threads' => 'Diskussionen',
	'searchprofile-threads-tooltip' => 'Themen und Diskussionsseiten durchsuchen',
	'lqt-ajax-updated' => 'Zu diesem Thema gibt es neue Beiträge.',
	'lqt-ajax-update-link' => 'Aktualisieren',
	'lqt-thread-show-replies' => '$1 {{PLURAL:$1|Antwort anzeigen|Antworten anzeigen}}',
	'lqt-thread-show-more' => 'Mehr Antworten anzeigen',
	'lqt-thread-link-url' => 'URL des Links:',
	'lqt-thread-link-title' => 'Wikitext-Link:',
	'lqt-thread-link-copy' => 'In die Zwischenablage kopieren',
	'lqt-sign-not-necessary' => 'Es ist nicht notwendig, deine Antwort mit vier Tilden zu signieren.
Die Signatur wird automatisch ergänzt.',
	'lqt-marked-as-read-placeholder' => 'Das Thema „$1“ wurde als gelesen markiert.',
	'lqt-change-subject' => 'Betreff ändern',
	'lqt-save-subject' => 'Speichern',
	'lqt-save-subject-failed' => 'Während der Betreffänderung ist der folgende Fehler aufgetreten: $1',
	'lqt-ajax-invalid-subject' => 'Der angegebene Betreff ist ungültig, da er vermutlich zu lang ist.',
	'lqt-ajax-no-subject' => 'Du musst einen Betreff für das neuen Thema angeben.',
	'lqt-save-subject-error-unknown' => 'Beim Festlegen des Betreffs ist ein unbekannter Fehler aufgetreten. Bitte versuche es über „bearbeiten“ beim obersten Beitrag.',
	'lqt-cancel-subject-edit' => 'Abbrechen',
	'lqt-drag-activate' => 'An einem neuen Ort ablegen',
	'lqt-drag-drop-zone' => 'Hier ablegen',
	'lqt-drag-confirm' => 'Um die folgenden Aktionen abzuschließen, gib bitte einen Grund an und klicke auf „Bestätigen“.',
	'lqt-drag-reparent' => 'Beitrag unter neuen Ursprung schieben.',
	'lqt-drag-split' => 'Beitrag in sein eigenes Thema verschieben',
	'lqt-drag-setsortkey' => 'Position des Beitrags auf der Seite festlegen',
	'lqt-drag-bump' => 'Beitrag an den Seitenanfang verschieben',
	'lqt-drag-save' => 'Bestätigen',
	'lqt-drag-title' => 'Ziehen bestätigen',
	'lqt-drag-reason' => 'Grund:',
	'lqt-drag-subject' => 'Betreff zum neuen Thema (erforderliche Angabe):',
	'lqt-edit-signature' => '(Signatur bearbeiten)',
	'lqt-preview-signature' => '(Vorschau)',
	'lqt-feed-title-all' => '{{SITENAME}} – Neue Beiträge',
	'lqt-feed-title-all-from' => '{{SITENAME}} – Neue Beiträge von $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – Neue Themen',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – Neue Themen von $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – Antworten',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – Antworten von $1',
	'lqt-feed-new-thread-intro' => 'Neues Thema auf $1 von $2',
	'lqt-feed-reply-intro' => 'Antwort auf $3 (auf $1) von $2',
	'tooltip-pt-newmessages' => 'Zeigt neue Nachrichten zu den von dir beobachteten Themen oder deren zugehörigen Diskussionsseiten',
	'lqt-newmessages-n' => 'Neue Nachrichten ($1)',
	'lqt_newmessages' => 'Neue Nachrichten (keine)',
	'lqt_newmessages-title' => 'Neue Nachrichten',
	'lqt-newpost-summary' => 'Neues Thema: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Bitte gebe deinen Text für dieses Thema an. Du solltest danach diese Zeile löschen.',
	'lqt-reply-summary' => 'Antwort auf [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Diskussionsseiten-Versionsgeschichte',
	'lqt-talkpage-history-subtitle' => 'Für $1',
	'lqt-talkpage-history-tab' => 'Kopfbereich',
	'restriction-reply' => 'Antworten',
	'restriction-newthread' => 'Neues Thema beginnen',
	'lqt-protected-reply-thread' => 'Da dieses Thema geschützt ist, kannst du hierauf nicht antworten.',
	'lqt-protected-reply-talkpage' => 'Diese Diskussionsseite wurde geschützt, sodass du zu den enthaltenen Themen nicht antworten kannst.',
	'lqt-protected-newthread' => 'Diese Diskussionsseite wurde geschützt, sodass du keine neuen Themen erstellen kannst.',
	'lqt-edit-bump' => 'Auf dieses Thema aufmerksam machen',
	'lqt-edit-bump-tooltip' => 'Diesen Diskussionsstrang an den Seitenanfang verschieben',
	'lqt-historicalrevision-error' => 'Die ausgewählte Version ist beschädigt und kann nicht angezeigt werden.',
	'lqt-reply-subpage' => 'Antwort',
	'nstab-thread' => 'Thema',
	'nstab-summary' => 'Themazusammenfassung',
);

/** German (formal address) (‪Deutsch (Sie-Form)‬)
 * @author ChrisiPK
 * @author Giftpflanze
 * @author Imre
 * @author Kghbln
 * @author Umherirrender
 */
$messages['de-formal'] = array(
	'lqt_invalid_subject' => 'Der Betreff, den Sie eingegeben haben, ist ungültig.
Es ist möglich, dass er
* zu lang ist oder
* im Konflikt mit Interwikipräfixen oder Namensraumbezeichnern steht.',
	'lqt_empty_subject' => 'Sie müssen einen Betreff eingeben.',
	'lqt_hist_past_last_page_error' => 'Sie sind außerhalb des Seitenbereichs der Versionsgeschichte.',
	'lqt_hist_tooltip_newer_disabled' => 'Der Link ist deaktiviert, da Sie sich auf der ersten Seite befinden.',
	'lqt_hist_tooltip_older_disabled' => 'Der Link ist deaktiviert, da Sie sich auf der letzten Seite befinden.',
	'lqt_youhavenewmessages' => 'Sie haben [[$1|neue Nachrichten]].',
	'lqt_summary_notice' => 'Zu diesem Thema gibt es seit $2 {{PLURAL:$2|Tag|Tagen}} keine neuen Beiträge.
Sofern die Diskussion beendet ist, möchten Sie vielleicht eine $1.',
	'lqt_delete_unallowed' => 'Sie haben nicht die Berechtigung Themen zu löschen.',
	'lqt_header_warning_big' => 'Sie bearbeiten gerade den $1.',
	'lqt_header_warning_after_big' => 'Dieser Bereich ist für Ankündigungen, Einleitungen und Hinweise vorgesehen.
Möglicherweise möchten Sie stattdessen ein $2.',
	'lqt-no-new-messages' => 'Sie haben keine neuen Nachrichten.',
	'lqt-new-messages' => '→ Sie haben neue Nachrichten.',
	'lqt-email-info-undo' => 'Holen Sie das Thema zurück, das Sie gerade weggeklickt haben.',
	'lqt-date-info' => 'Dieser Link ist nicht aktiv, da Sie Themen von allen Daten ansehen.',
	'lqt-summarize-intro' => 'Bitte fassen Sie das untenstehende Thema im Bearbeitungsfenster zusammen.
Sie können Wikitext in Ihrer Zusammenfassung verwenden. Sobald Sie fertig sind, klicken Sie auf „{{int:savearticle}}“.',
	'lqt-split-success' => 'Sie haben den Diskussionsstrang $1 erfolgreich abgetrennt.',
	'lqt-delete-parent-warning' => 'Dies ist ein Thema auf höchster Ebene mit Antworten.
Auch seine Antworten werden automatisch gelöscht.
Um dies zu vermeiden, teilen Sie sie von diesem Thema ab, bevor Sie es löschen.',
	'lqt-enotif-newthread' => 'Hallo $1,

dies ist eine Benachrichtigung von {{SITENAME}}. Von Benutzer $8 wurde am $3 um $4 Uhr auf der Seite „$5“ das neue Thema „$2“ begonnen.

Sie können es unter diesem Link einsehen: <$6>

Die Nachricht lautet:
$7',
	'lqt-enotif-reply' => 'Hallo $1,

dies ist eine Benachrichtigung von {{SITENAME}}. Von Benutzer $8 wurde am $3 um $4 Uhr auf der Seite „$5“ zum Thema „$2“ eine neue Nachricht verfasst.

Sie können sie unter diesem Link einsehen: <$6>

Die Nachricht lautet:
$7',
	'lqt-sign-not-necessary' => 'Es ist nicht notwendig, Ihre Antwort mit vier Tilden zu signieren.
Die Signatur wird automatisch ergänzt.',
	'lqt-ajax-no-subject' => 'Sie müssen einen Betreff für das neuen Thema angeben.',
	'lqt-save-subject-error-unknown' => 'Beim Festlegen des Betreffs ist ein unbekannter Fehler aufgetreten. Bitte versuchen Sie es über „bearbeiten“ beim obersten Beitrag.',
	'lqt-drag-confirm' => 'Um die folgenden Aktionen abzuschließen, geben Sie bitte einen Grund an und klicken Sie auf „Bestätigen“.',
	'tooltip-pt-newmessages' => 'Zeigt neue Nachrichten zu den von Ihnen beobachteten Themen oder deren zugehörigen Diskussionsseiten',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Bitte geben Sie Ihren Text für dieses Thema an. Sie sollten danach diese Zeile löschen.',
	'lqt-protected-reply-thread' => 'Da dieses Thema geschützt ist, können Sie hierauf nicht antworten.',
	'lqt-protected-reply-talkpage' => 'Diese Diskussionsseite wurde geschützt, sodass Sie zu den enthaltenen Themen nicht antworten können.',
	'lqt-protected-newthread' => 'Diese Diskussionsseite wurde geschützt, sodass Sie keine neuen Themen erstellen können.',
);

/** Zazaki (Zazaki)
 * @author Aspar
 * @author Mirzali
 * @author Xoser
 */
$messages['diq'] = array(
	'lqt-desc' => 'werêameyişê ke gırediyayê pelê mesajan, têarê keno',
	'lqt_movethread' => 'gıre bıheweln yewna pel',
	'lqt_deletethread' => 'gıre hewna ker ya zi hewnakerdış tepiya bıger',
	'lqt_contents_title' => 'muhtewayi',
	'lqt_toc_thread_title' => 'sernameyê gıreyi',
	'lqt_toc_thread_author' => 'o yo ke dano destpêkerdış',
	'lqt_toc_thread_replycount' => 'cewabi',
	'lqt_toc_thread_modified' => 'vurnayoxo peyın',
	'lqt_add_header' => 'sername bıerz cı',
	'lqt_new_thread' => 'newe yew werîameyiş kewe',
	'lqt_invalid_subject' => 'sernameyo ke şıma pê kewti cı nemeqbulo..
Sebebê ey:
* ya zaf dergo, ya zi
* cayê nameyan u gıreyê benatewikiyan de pêverdiyayo.',
	'lqt_empty_subject' => 'gani şıma yew muhtewa bınusi',
	'lqt_reply' => 'Cewab bıde',
	'lqt-parent' => 'Piye',
	'lqt_delete' => 'hewna ker',
	'lqt_undelete' => 'tepiya bıger',
	'lqt_permalink' => 'gıre bıde ıney',
	'lqt_fragment' => 'pelê $2i ra yew parçeyê $1i',
	'lqt_discussion_link' => 'werêameyiş',
	'lqt_from_talk' => 'pelê $1i ra',
	'lqt-history-title' => 'hal-verinê gıreyi',
	'lqt_hist_comment_edited' => 'Metnê mışewrey [$2 vuriya]',
	'lqt_hist_summary_changed' => 'xulasa vuriya',
	'lqt_hist_reply_created' => '[[$1|Cewabo newe]] bi hazır',
	'lqt_hist_thread_created' => 'gıreyo newe bı hazır',
	'lqt_hist_deleted' => 'hewna bı',
	'lqt_hist_undeleted' => 'esterıtış tepiya geriya',
	'lqt_hist_moved_talkpage' => 'kırışiya',
	'lqt_hist_listing_subtitle' => 'listeya halê verin ramociyeno',
	'lqt_hist_view_whole_thread' => 'qey ın gıre halê verin bıvin',
	'lqt_hist_no_revisions_error' => 'hal-verinê revizyonê no gıreyi çı çino',
	'lqt_hist_past_last_page_error' => 'şıma amarê pelê hal-verino mewcudi ra zaf dur î.',
	'lqt_hist_tooltip_newer_disabled' => 'no gıre (link) battal bı çunke şıma pelo ewwil de yi.',
	'lqt_hist_tooltip_older_disabled' => 'no gıre (link) battal bı çunke şıma pelo peyin de yi.',
	'lqt_hist_split' => 'qey newe yew gıre re cewab ciya bıker',
	'lqt_hist_edited_subject' => 'Mewzu "$2" ra vurna be "$3"i',
	'lqt_hist_edited_subject_corrupt' => 'Mewzuyo vurnae',
	'lqt_hist_merged_from' => '[[$1|Cewab]] kırışiya be yewna destêki',
	'lqt_hist_merged_to' => '[[$1|Cewab]] yewna destêki ra kırışiya',
	'lqt_hist_split_from' => 'qey newe yew gıre re ciya ker',
	'lqt_hist_root_blanked' => 'metnê mışoreyi wedariya/weradiya',
	'lqt_hist_adjusted_sortkey' => 'Pozisyonê mewzuy eyar biyo',
	'lqt_revision_as_of' => 'revizyonê ke $2 $3 ra pê biyê.',
	'lqt_change_new_thread' => 'revizyonê gıreyi yo ewwil',
	'lqt_change_reply_created' => '[$1 mışoreyo servınderte] no revizyon de vıraziye.',
	'lqt_change_edited_root' => '[$1 mışoreyo servınderte] no revizyon de vuriya',
	'lqt_change_edited_summary' => 'xulasaya gıreyi vuriya',
	'lqt_change_deleted' => '[$1 no gıre] ya zi gıreyê ey o serin hewna biyo',
	'lqt_change_undeleted' => 'hewna biyayişê [$1 postaya servınderteyi] tepiya geriyayo',
	'lqt_change_moved' => '[$1 no gıre]kırışiya pelê yewna werêameyişi',
	'lqt_change_split' => '[$1 no gıre] yewna gıre ra bı ciya',
	'lqt_change_edited_subject' => 'Mewzuyê ena destêki "$2" ra vuriya be "$3"i',
	'lqt_change_merged_from' => '[$1 cevab]o ke no gıre re ameyo kırışiya yewna gıre',
	'lqt_change_merged_to' => '[$1 cevabo servınderte] yewna gıre ra kırışiya',
	'lqt_change_split_from' => '[$1 yew bıngıreyê] no gıreyi no gıre ra bı ciya',
	'lqt_change_root_blanked' => 'metnê [$1 yew mışoreyi] erziya.',
	'lqt_youhavenewmessages' => ' [[$1|Mesacê tuyê newey]] estê.',
	'lqt_protectedfromreply' => 'no gıre, cewabdayiş nêwazeno $1.',
	'lqt_protectedfromreply_link' => 'pawıteyo',
	'lqt_subject' => 'muhtewa:',
	'lqt_noreason' => 'sebeb nêvaciyayo',
	'lqt_move_placeholder' => 'Bu düğüm, bir düğümün, $1, bu sayfadan başka bir tartışma sayfasına çıkarıldığını belirten bir yertutucudur.
Bu taşıma $3 $4 tarihinde $2 tarafından yapılmıştır. Düğüm şu anda $5 adresinde bulunuyor.',
	'lqt_thread_deleted_for_sysops' => "no gıre '''hewna biyo''' u têna serkari eşkêni bıvini.",
	'lqt_thread_deleted' => 'no gıre hewna biyo',
	'lqt_summary_notice' => 'no werêameyiş de tewr tay $2 {{PLURAL:$2|roc o|roc o}} çıyek o newe nêbı.
eke safi biyo, şıma eşkêni $1 bıwazi.',
	'lqt_summary_notice_link' => 'yew xulasa nuştış',
	'lqt_summary_label' => 'Xulasaya gıre:',
	'lqt_summary_subtitle' => 'qey "$1"i xulasa',
	'lqt_nosuchrevision' => 'wina yew revizyonê gıreyi çino.',
	'lqt_nosuchthread' => 'gıreyo ke şıma nişan kerdo çino',
	'lqt_nosuchthread_title' => 'wina yew gıre çino',
	'lqt_threadrequired' => 'gani şıma URL de yew gıre nişan bıkeri.',
	'lqt_move_movingthread' => "$1 kırışiyeno.
no gıre parçeyê $2'i yo.",
	'lqt_move_torename' => "qey newe ra namedayişê no gıreyi, $1 u mıntıqayê 'muhtewayi' bıvurnê.",
	'lqt_move_torename_edit' => 'Bıvurnê',
	'lqt_move_destinationtitle' => 'sernameyê pelê werêameyişi yo hedefi:',
	'lqt_move_move' => 'Bıkırış',
	'lqt_move_nodestination' => 'şıma gani yew hedef nişan bıkeri.',
	'lqt_move_thread_bad_destination' => 'pelê hedefi pelê yew werêameyiş niyo.',
	'lqt_move_samedestination' => 'gıre ca ra no pel de yo',
	'lqt_move_noreason' => 'sebeb nêvaciyayo nişan nêbiyo',
	'lqt_move_success' => 'gıre kırışiya $1.',
	'lqt_delete_undeletethread' => 'esterıtışê gıreyi tepiya bıger',
	'lqt_delete_partof' => "no gıre yew parçeyê no '''$1''' gıreyo.",
	'lqt_delete_deleting' => "'''$1''' u '''heme cewabi''' esteriyeni.",
	'lqt_delete_deletethread' => 'gıre u cewaban bıester',
	'lqt_delete_deleted' => 'gıre esteriya',
	'lqt_delete_undeleted' => 'esterıtışê gıreyi tepiya geriya',
	'lqt_delete_return' => "agêr pelê $1'i.",
	'lqt_delete_return_link' => 'pelê werêameyiş',
	'lqt_delete_unallowed' => 'desturê şıma çino şıma gıreyan bıesteri',
	'lqt_delete_show_checkbox' => 'gıreyê ke esteriye ramocın',
	'lqt_talkpage_autocreate_summary' => 'wexta gıreyo ewwil şawiya bı otomatik pelê werêamyişi zi vıraziya.',
	'lqt_header_warning_big' => 'şıma $1 vurneni.',
	'lqt_header_warning_after_big' => 'Qey sername, ilan (pêhesnayiş) u vervateyano.
Şıma eşkêni $2 bıwazi.',
	'lqt_header_warning_bold' => 'sernameyê pelê werêameyişi',
	'lqt_header_warning_new_discussion' => 'yew behso newe akerdış',
	'lqt_sorting_order' => 'nizamê rêzkerdışi',
	'lqt_sort_newest_changes' => 'ewwil vurnayeyo peyin',
	'lqt_sort_newest_threads' => 'ewwil gıreyo tewr newe',
	'lqt_sort_oldest_threads' => 'ewwil gıreyo tewr verin',
	'lqt-title' => 'sername',
	'lqt-summary' => 'xulasa',
	'lqt-searching' => 'gıreyi gêriyene',
	'lqt-read-message' => 'bı wende nişane bıker',
	'lqt-read-message-tooltip' => 'mesajanê neweyan ra no gıre vec.
pelê werêameyişi yo orijinal de anciya zi aseno.',
	'lqt-read-all' => 'pêroyin têde wende nişane bıker',
	'lqt-read-all-tooltip' => 'mesajanê neweyan ra heme gıreyan vec.
pelê werêameyişi yo orijinal de anciya zi aseno.
no operasyon tepiya geriyeno.',
	'lqt-marked-read' => "gıreyê '''$1'''i bı wende nişane bı:",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mesaj|mesaj}} wende nişane bı.',
	'lqt-email-undo' => 'tepiya bıger',
	'lqt-no-new-messages' => 'şıma re mesajeko newe çino.',
	'lqt-new-messages' => '✒ şıma re mesajê neweyi esti.',
	'lqt-email-info-undo' => 'gıreyo ke şıma cıwa ver eşto tepiya biyar',
	'lqt-date-info' => 'no gıre (link)  battal verdiya çunke şıma heme tarixan ra gıreyan mocneni ra.',
	'lqt-newmessages-context' => 'gıreyo tam',
	'lqt-thread-created' => 'vıraziya',
	'lqt-history-time' => 'zeman',
	'lqt-history-user' => 'karber',
	'lqt-history-action' => 'kar/şuxul',
	'lqt-history-comment' => 'mışore',
	'lqt-history-thread' => 'gıre',
	'lqt-thread-edited-author' => 'Hetê nuştoxi ra vuriya.<br />
Vurnayisa peyine: $1',
	'lqt-thread-edited-others' => 'Hetê {{PLURAL:$2|karberanê binan|$2 karberan}} ra vuriya.<br />
Vurnayisa peyine: $1',
	'lqt-header-actions' => 'kari/şuxuli',
	'lqt_summarize_link' => 'xulasa bıker',
	'lqt-summarize-intro' => 'kerem kerê gıreyo cêrın qutiya vurnayişi de xulasa bıkerê.
şıma xulasaya xo de eşkêni yew metnê wikiyi bışuxulni.Özetinizde herhangi bir vikimetnini kullanabilirsiniz. wexta ke şıma qedna "{{int:savearticle}}" bıtıknê.',
	'lqt-thread-split' => 'gıreyo newe tera ker',
	'lqt-split-success' => 'şıma gıreyo $1i bı serkewte kerd ciya.',
	'lqt_split_thread' => 'yew gıre ciya ker',
	'lqt-thread-split-subject' => 'muhtewaya gıreyo newe:',
	'lqt-thread-split-thread' => 'gıre:',
	'lqt-split-submit' => 'ciya ker/tera ker',
	'lqt_split_badsubject' => 'muhetwaya ke şıma erzeni cı, nemeqbulo',
	'lqt-no-threads' => 'no pel hema/hona gıre çino.',
	'lqt-delete-parent-warning' => 'yew gıreyo seviya-berzo ke wayirê no cewab o.
cewabi zi bı otomatik esteriyeni.
eke şıma qayili tera xo bıkeri (qayil niyê), cewaban verê esterıtışê gıreyan ra gıre ra ciya ker.',
	'lqt-delete-parent-deleted' => 'gıreyo bıngeyın esteriya ($1)',
	'lqt-delete-replies-done' => 'cewabê ke no gıre re ameyi, esteriyê',
	'lqt-movethread' => 'bıkırış',
	'lqt-menu-trigger' => 'hema/hona zêd',
	'lqt-newmessages-from' => 'şawıtox $1',
	'lqt-hot-topics' => 'sernameyê neweyi',
	'lqt-add-reply' => 'Yew cewab cı ke',
	'lqt_rc_new_discussion' => 'Yew werêameyişo newe nuşto, "$1"',
	'lqt_rc_new_reply' => '"$1"i re cewab nusiya',
	'right-lqt-split' => 'gıreyan ciya ker',
	'right-lqt-merge' => 'gıreyan piyawan (bıbesn)',
	'lqt-thread-merge' => 'piyawan (bıbesn) gıreyo bin',
	'lqt-thread-merge-to' => 'no gıre re piyawan (bıbesn)',
	'lqt_merge_thread' => 'gıre piyawan (bıbesn)',
	'lqt-thread-merge-source' => 'gıreyo ke biyo çıme',
	'lqt-thread-merge-dest' => 'gıreyo ke biyo hedef',
	'lqt-merge-submit' => 'piyawan (bıbesn)',
	'lqt-merge-success' => "gıreyê $1'i bı serkewte şıma eşt bınê gıreyê $2'i.",
	'lqt-log-name' => 'roceyê werêameyişi yo gıre biyaye',
	'lqt-log-header' => 'no, karê ke gıreyê werêameyişê roceyi de biyê, detay keno.',
	'lqt-log-action-move' => "gıreyê [[$1]]'i pelê [[$2]]'i ra kırışt no [[$3]] pel.",
	'lqt-log-action-split' => '[[$1]], [[$3]] bibirne, pê yew sernameyo newe "$2"',
	'lqt-log-action-merge-across' => '[[$1]], [[$2]] ra berd [[$3]]',
	'lqt-log-action-merge-down' => '[[$1]] yew kerd binê [[$3]]',
	'lqt-log-action-subjectedit' => 'Sernameyê [[$1]]i, "$2" ra "$3" vurne',
	'lqt-log-action-resort' => 'rezayê [[$1]]i vurne. Rezayê kerdise tusi $2 ra $3 vurne',
	'lqt-preference-notify-talk' => 'gıreyo ke mi seyr kerdo wexta cı re mesaj ame mire e-posta bışaw.',
	'lqt-preference-watch-threads' => 'gıreyo ke mı vıraşti ya zi mi cewab dayi seyr bıker',
	'prefs-lqt' => 'werêameyişo gıreyın',
	'lqt-preference-display-depth' => 'Gösterilecek azami cevap derinliği:',
	'lqt-preference-display-count' => 'amarê cewabi yo azami ramociyeno:',
	'lqt-preference-custom-signatures' => 'imzayê karberani yê xusûsiyan ramocın',
	'lqt-enotif-subject-reply' => "werêameyişê {{SITENAME}}'i  - Cevab: $1",
	'lqt-enotif-subject-newthread' => "werêameyişê {{SITENAME}}'i - gıreyo newe: $1",
	'lqt-enotif-newthread' => "Merheba $1,
no, keyepelê {{SITENAME}}'i ra yew ilan o (pêhesnayişo): pelê $5'i de no name de '$2' yew gıreyo newe, no $3 $4 tarix de vıraziya.

ti ney, adresa <$6>'i de eşkêni bıvini.",
	'lqt-enotif-reply' => "Merheba $1,
no, keyepelê {{SITENAME}}'i ra yew ilan o (pêhesnayişo): pelê $5'i de gıreyê '$2'i re yew cewabo newe no $3 $4 tarix de vıraziya.

ti ney, adresa <$6>'i de eşkêni bıvini.",
	'lqt-quote-intro' => '$2 $3 tarix de, [[User:$1|$1]] nuşt:',
	'lqt-quote' => 'gırewte',
	'lqt-search-legend' => 'werêameyişê no peli bıgêr',
	'lqt-search-label' => 'termê cıgêrayişi:',
	'lqt-search-button' => 'cıgêr',
	'searchprofile-threads' => 'werêameyişi',
	'searchprofile-threads-tooltip' => 'Düğümlü tartışmaları ve tartışma sayfalarını ara',
	'lqt-ajax-updated' => 'no gıre re postayê neweyi esti',
	'lqt-ajax-update-link' => 'rocane ker',
	'lqt-thread-show-replies' => '$1 cevab ramocın',
	'lqt-thread-show-more' => 'hema zaf cewaban ramocın',
	'lqt-thread-link-url' => "URL'yê gıreyi:",
	'lqt-thread-link-title' => 'gıreyê wikimetn',
	'lqt-thread-link-copy' => 'pano re kopya ker',
	'lqt-sign-not-necessary' => 'Luzım nêkeno ke tı nuştey xo be çehar tildan imza kerê.
İmza otomatikman mocniyena.',
	'lqt-marked-as-read-placeholder' => 'Destêkia $1i zey wendiye nişan biya.',
	'lqt-change-subject' => 'Mewzuy bıvurne',
	'lqt-save-subject' => 'Qeyd ke',
	'lqt-save-subject-failed' => 'Eno ğelet teşebbusê vurnayışê destêkia mewzuy de ame meydan: $1',
	'lqt-ajax-invalid-subject' => 'Mewzuyo ke to name kerd nêvêrd, çıke o belkia zaf derg bi.',
	'lqt-ajax-no-subject' => 'Tı gani yew mewzu name kerê.',
	'lqt-save-subject-error-unknown' => 'Yew ğeleto nêzanaoğ teşebbusê ronayışê mewzuyê ena destêki de ame meydan. Kerem ke, ney be tıknayışê "bıvurne" ra iştırakê serêni de bıcerrebne.',
	'lqt-cancel-subject-edit' => 'İptal ke',
	'lqt-drag-activate' => 'Bıance be caê newey',
	'lqt-drag-drop-zone' => 'Tiya de verde',
	'lqt-drag-confirm' => 'Kerem ke, seba qedenayışê nê karan yew sebeb cı de u "Confirm"i bıtıkne.',
	'lqt-drag-reparent' => 'Mesaci bere bınê yew çımeyê newey.',
	'lqt-drag-split' => 'Mesaci bere be mewzuyê cı',
	'lqt-drag-setsortkey' => 'Pozisyonê mesaci pele de eyar ke',
	'lqt-drag-bump' => 'Mesaci bere serê pela werênayışi',
	'lqt-drag-save' => 'Testiq ke',
	'lqt-drag-reason' => 'Sebeb:',
	'lqt-drag-subject' => 'Mewzuyê newey rê madde:',
	'lqt-edit-signature' => '(imza bıvurne)',
	'lqt-preview-signature' => '(verqayt)',
	'lqt-feed-title-all' => '{{SITENAME}} — postayê neweyi',
	'lqt-feed-title-all-from' => "{{SITENAME}} —  qey pelê $1'i postayê neweyi",
	'lqt-feed-title-new-threads' => '{{SITENAME}} — gıreyê neweyi',
	'lqt-feed-title-new-threads-from' => "{{SITENAME}} — qey pelê $1'i gıreyê neweyi",
	'lqt-feed-title-replies' => '{{SITENAME}} — Cewabi',
	'lqt-feed-title-replies-from' => "{{SITENAME}} — qey pelê $1'i cewabi",
	'lqt-feed-new-thread-intro' => "pelê $1'i de gıreyo newe hetê $2 ra erşawiya",
	'lqt-feed-reply-intro' => "gıreyê $3'i re cewab (pelê $1'i de) hetê $2'i ra erşawiya",
	'lqt-newmessages-n' => 'mesajo newe ($1)',
	'lqt_newmessages' => 'mesajo newe',
	'lqt_newmessages-title' => 'Mesacê newey',
	'lqt-newpost-summary' => 'gıreyo newe: $1',
	'lqt-reply-summary' => "gıreyê [[$2|$1]]'i re cewab bıd'",
	'lqt-talkpage-history-title' => 'hal-verinê pelê werêameyişi',
	'lqt-talkpage-history-subtitle' => 'seba $1',
	'lqt-talkpage-history-tab' => 'Ser',
	'restriction-reply' => 'Cewaban darde bike',
	'restriction-newthread' => 'Sernameyanê neweyan darde bike',
	'lqt-protected-reply-thread' => 'Ti nişkenê itiya de binuse cunki ena pele kilit biyo.',
	'lqt-protected-reply-talkpage' => 'Ti nişkenê itiya de binuse cunki ena pele kilit biyo.',
	'lqt-protected-newthread' => 'Ti nişkenê itiya de binuse cunki ena pele kilit biyo.',
	'lqt-edit-bump' => 'Ena thread berz bike',
	'lqt-edit-bump-tooltip' => 'Ena deştêki bere be pela werênayışiê dae',
	'lqt-historicalrevision-error' => 'Çımraviyarnayışo ke to çinıto we xırabeo, u nêşeno bıvêniyo.',
	'lqt-reply-subpage' => 'cewab bıde',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'lqt-desc' => 'Nitkowe diskusije k diskusijnym bokam pśidaś',
	'lqt_movethread' => 'Nitku k drugemu bokoju pśesunuś',
	'lqt_deletethread' => 'Nitku wulašowaś abo wótnowiś',
	'lqt_contents_title' => 'Wopśimjeśe',
	'lqt_toc_thread_title' => 'Titel nitki',
	'lqt_toc_thread_author' => 'Zachopjony wót',
	'lqt_toc_thread_replycount' => 'Wótegrona',
	'lqt_toc_thread_modified' => 'Slědny raz změnjony',
	'lqt_add_header' => 'Głowu pśidaś',
	'lqt_new_thread' => 'Nowu diskusiju zachopiś',
	'lqt_invalid_subject' => 'Tema, kótaruž sy zapódał, jo njepłaśiwa. Snaź:
* jo pśedłujko abo
* jo konfilikt z interwikijowymi prefiksami abo mjenja mjenjowych rumow.',
	'lqt_empty_subject' => 'Musyš temowe nadpismo zapódaś.',
	'lqt_reply' => 'Wótegroniś',
	'lqt-parent' => 'Nadrědowany',
	'lqt_delete' => 'Wulašowaś',
	'lqt_undelete' => 'Wótnowiś',
	'lqt_permalink' => 'Trajny wótkaz',
	'lqt_fragment' => 'Fragment $1 wót $2',
	'lqt_discussion_link' => 'diskusija',
	'lqt_from_talk' => 'z $1',
	'lqt-history-title' => 'Stawizny nitki',
	'lqt_hist_comment_edited' => 'Komentarowy tekst [$2 wobźěłany]',
	'lqt_hist_summary_changed' => 'Zespominanje změnjone',
	'lqt_hist_reply_created' => '[[$1|Nowe wótegrono]] napórane',
	'lqt_hist_thread_created' => 'Nowa nitka napórana',
	'lqt_hist_deleted' => 'Wulašowany',
	'lqt_hist_undeleted' => 'Wótnowjony',
	'lqt_hist_moved_talkpage' => 'Pśesunjony',
	'lqt_hist_listing_subtitle' => 'Zwobraznjenje stawiznow',
	'lqt_hist_view_whole_thread' => 'Stawizny za cełu nitku se woglědaś',
	'lqt_hist_no_revisions_error' => 'Toś ta nitka njama stawizny.',
	'lqt_hist_past_last_page_error' => 'Sy zwenka licby bokow ekistěrujucych stawiznow.',
	'lqt_hist_tooltip_newer_disabled' => 'Wótkaz jo znjemóžnjony, dokulaž sy na prědnem boku.',
	'lqt_hist_tooltip_older_disabled' => 'Wótkaz jo znjemóžnjony, dokulaž sy na slědnem boku.',
	'lqt_hist_split' => 'Wótegrono do noweje nitki rozdźěliś',
	'lqt_hist_edited_subject' => 'Tema wót "$2" do "$3" změnjona',
	'lqt_hist_edited_subject_corrupt' => 'Tema změnjona',
	'lqt_hist_merged_from' => '[[$1|Wótegrono]] do drugeje nitki pśesunjone',
	'lqt_hist_merged_to' => '[[$1|Wótegrono]] z drugeje nitki pśesunjone',
	'lqt_hist_split_from' => 'Do noweje nitki rozdźěliś',
	'lqt_hist_root_blanked' => 'Komentarowy tekst wótpórany',
	'lqt_hist_adjusted_sortkey' => 'Skorigěrowana pozicija nitki',
	'lqt_revision_as_of' => 'Wersija wót $2 $3.',
	'lqt_change_new_thread' => 'To jo zachopna wersija nitki.',
	'lqt_change_reply_created' => '[$1 Wuzwignjony komentar] jo se napórał w toś tej wersiji.',
	'lqt_change_edited_root' => '[$1 Wuzwignjony komentar] jo se wobźěłał w toś tej wersiji.',
	'lqt_change_edited_summary' => 'Zespominanje nitki jo se wobźěłało',
	'lqt_change_deleted' => '[$1 Toś ta nitka] jo se wulašowała abo wótegrono na nju',
	'lqt_change_undeleted' => '[$1 Wuzwignjona powěsć] jo se wótnowiła',
	'lqt_change_moved' => '[$1 Toś ta nitka] jo se do drugego diskusijnego boka pśesunuł',
	'lqt_change_split' => '[$1 Toś ta nitka] jo se wót drugeje nitki wótźěliła',
	'lqt_change_edited_subject' => 'Tema toś teje nitki jo se změniła wót "$2" do "$3"',
	'lqt_change_merged_from' => '[$1 Wótegrono] w toś tej nitce jo se do drugeje nitki pśesunuło',
	'lqt_change_merged_to' => '[$1 Wuzwignjone wótegrono] jo se z drugeje nitki pśesunuło',
	'lqt_change_split_from' => '[$1 Pódnitka] toś teje nitki jo se do swójeje nitki wótźěliła',
	'lqt_change_root_blanked' => 'Tekst [$1 komentara] jo se wótpórał.',
	'lqt_youhavenewmessages' => 'Maš [[$1|nowe powěsći]].',
	'lqt_protectedfromreply' => 'Toś ta nitka jo była $1 pśeśiwo wótegrono na nju.',
	'lqt_protectedfromreply_link' => 'šćitany',
	'lqt_subject' => 'Tema:',
	'lqt_noreason' => 'Žedna pśicyna pódana.',
	'lqt_move_placeholder' => 'Toś ta nitka jo zastupnik, kótaryž pódawa, až nitka, $1, jo se pśesunuła z toś togo boka.
Toś to pśesunjenje jo se pśewjadło wót $2 $3 $4. Nitka jo něnto pśi $5.',
	'lqt_thread_deleted_for_sysops' => "Toś ta nitka jo se '''wulašowała''' a jo jano widobna za administratorow.",
	'lqt_thread_deleted' => 'Toś ta nitka jo se wulašowała.',
	'lqt_summary_notice' => 'W toś tej diskusiji njejsu byli nanejmjenjej $2 {{PLURAL:$2|źeń|dnja|dny|dnjow}} žedne změny.
Jolic jo skóńcona, coš snaź $1.',
	'lqt_summary_notice_link' => 'zespominanje pisaś',
	'lqt_summary_label' => 'Zespominanje nitki:',
	'lqt_summary_subtitle' => 'Zespominanje wót "$1"',
	'lqt_nosuchrevision' => 'Taka wersija toś teje nitki njejo.',
	'lqt_nosuchthread' => 'Nitka, kótaruž sy pódał, njeeksistěrujo.',
	'lqt_nosuchthread_title' => 'Taka nitka njejo',
	'lqt_threadrequired' => 'Musyš nitku w URL pódaś.',
	'lqt_move_movingthread' => '$1 se pśesuwa.
Toś ta nitka jo źěl z $2.',
	'lqt_move_torename' => "Aby pśemjenił toś tu nitku, $1 a změń pólo 'Tema'.",
	'lqt_move_torename_edit' => 'ju wobźěłaś',
	'lqt_move_destinationtitle' => 'Titel celowego diskusijnego boka:',
	'lqt_move_move' => 'Pśesunuś',
	'lqt_move_nodestination' => 'Musyš cel pódaś.',
	'lqt_move_thread_bad_destination' => 'Celowy bok njejo diskusijny bok.',
	'lqt_move_samedestination' => 'Nitka jo južo na toś tom boku!',
	'lqt_move_noreason' => 'Žedna pśicyna pódana.',
	'lqt_move_success' => 'Nitka jo se pśesunuła do $1.',
	'lqt_delete_undeletethread' => 'Nitku wótnowiś',
	'lqt_delete_partof' => "Toś ta nitka jo źěl z '''$1'''.",
	'lqt_delete_deleting' => "'''$1''' a '''wše wótegrona''' na nju se lašuju.",
	'lqt_delete_deletethread' => 'Nitki a wótegrona wulašowaś',
	'lqt_delete_deleted' => 'Nitka jo se wulašowała.',
	'lqt_delete_undeleted' => 'Nitka jo se wótnowiła.',
	'lqt_delete_return' => 'Slědk k $1.',
	'lqt_delete_return_link' => 'diskusijny bok',
	'lqt_delete_unallowed' => 'Njesmějoš nitki lašowaś.',
	'lqt_delete_show_checkbox' => 'Wulašowane nitki pokazaś',
	'lqt_talkpage_autocreate_summary' => 'Diskusijny bok awtomatiski napórany, gaž prědna nitka jo se napórała.',
	'lqt_header_warning_big' => 'Wobźěłujoš $1.',
	'lqt_header_warning_after_big' => 'Głowowe smužki su za pśipowěźenja a zawjeźenja.
Snaź coš město togo $2.',
	'lqt_header_warning_bold' => 'Głowowa smužka diskusijnego boka',
	'lqt_header_warning_new_discussion' => 'nowu diskusiju zachopiś',
	'lqt_sorting_order' => 'Sortěrowański rěd:',
	'lqt_sort_newest_changes' => 'ako slědne změnjone ako prědne',
	'lqt_sort_newest_threads' => 'nejnowše nitki ako prědne',
	'lqt_sort_oldest_threads' => 'nejstarše nitki ako prědne',
	'lqt-title' => 'Titel',
	'lqt-summary' => 'Zespominanje',
	'lqt-searching' => 'Pytanje za nitkami',
	'lqt-read-message' => 'Ako pśecytany markěrowaś',
	'lqt-read-message-tooltip' => 'Wótpóraj toś tu nitku z nowych powěsćow.
Buźo jano hyšći na swójem originalnem diskusijnem boku widobne.',
	'lqt-read-all' => 'Wšykne ako pśecytane markěrowaś',
	'lqt-read-all-tooltip' => 'Wše nitki z nowych powěsćow wótpóraś.
Budu hyšći na swojich originalnych diskusijnych bokach widobne.
Toś ta operacija njedajo se anulěrowaś.',
	'lqt-marked-read' => "Nitka '''$1''' jo se markěrowała ako pśecytana.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|powěsć|powěsći|powěsći|powěsćow}} ako {{PLURAL:$1|pśecytana markěrowana|pśecytanej markěrowanej|pśecytane markěrowane|pśecytane markěrowane}}.',
	'lqt-email-undo' => 'Anulěrowaś',
	'lqt-no-new-messages' => 'Njamaš nowe powěsći.',
	'lqt-new-messages' => '✒ Maš nowe powěsći.',
	'lqt-email-info-undo' => 'Spóraj nitku slědk, kótaruž sy rowno wótpósłał.',
	'lqt-date-info' => 'Toś ten wótkaz jo znjemóžnjony, dokulaž woglědujoš se nitki wšych datumow.',
	'lqt-newmessages-context' => 'Dopołna nitka',
	'lqt-thread-created' => 'Napórany',
	'lqt-history-time' => 'Cas',
	'lqt-history-user' => 'Wužywaŕ',
	'lqt-history-action' => 'Aktiwita',
	'lqt-history-comment' => 'Komentar',
	'lqt-history-thread' => 'Nitka',
	'lqt-thread-edited-author' => 'Wót awtora wobźěłany.<br />
Slědna změna: $1',
	'lqt-thread-edited-others' => 'Wót {{PLURAL:$2|drugego wužywarja|$2 wužywarjowu|$2 wužywarjow|$2 wužywarjow}} wobźěłany.<br />
Slědna změna: $1',
	'lqt-header-actions' => 'Akcije',
	'lqt_summarize_link' => 'Zespominaś',
	'lqt-summarize-intro' => 'Pšosym zespominaj slědujucu nitku we wobźěłowańskem kašćiku.
Móžoš wikitekst w swójom zespominanju wužywaś. Gaž kóńcyš, klikni na "{{int:savearticle}}".',
	'lqt-thread-split' => 'Do noweje nitki rozšćěpiś',
	'lqt-split-success' => 'Sy nitku $1 wuspěšnje wótšćěpił.',
	'lqt_split_thread' => 'Nitku rozšćěpiś',
	'lqt-thread-split-subject' => 'Tema noweje nitki:',
	'lqt-thread-split-thread' => 'Nitka:',
	'lqt-split-submit' => 'Rozšćěpiś',
	'lqt_split_badsubject' => 'Tema, kótaruž sy zapódał, jo njepłaśiwa.',
	'lqt-no-threads' => 'Hyšći na toś tom boku žedne nitki njejsu.',
	'lqt-delete-parent-warning' => 'To je głowna nitka z wótegronami.
Jogo wótegrona budu se teke awtomatiski lašowaś.
Aby se to wobinuło, wótźěl je wót toś teje nitki, nježli až ju lašujoš.',
	'lqt-delete-parent-deleted' => 'Nadrědowana nitka wulašowana ($1)',
	'lqt-delete-replies-done' => 'Wše wótegrona k toś tej nitce su teke južo wulašowane.',
	'lqt-movethread' => 'Pśesunuś',
	'lqt-menu-trigger' => 'Wěcej',
	'lqt-newmessages-from' => 'z $1',
	'lqt-hot-topics' => 'Nejcesćej cytane temy',
	'lqt-add-reply' => 'Wótegrono pśidaś',
	'lqt_rc_new_discussion' => 'jo pósłał nowu nitku, "$1"',
	'lqt_rc_new_reply' => 'jo pósłał wótegrono na "$1"',
	'right-lqt-split' => 'Nitki rozdźěliś',
	'right-lqt-merge' => 'Nitki zjadnośiś',
	'lqt-thread-merge' => 'Z drugeju nitku zjadnośiś',
	'lqt-thread-merge-to' => 'Z toś teju nitku zjadnośiś',
	'lqt_merge_thread' => 'Nitku zjadnośiś',
	'lqt-thread-merge-source' => 'Žrědłowa nitka:',
	'lqt-thread-merge-dest' => 'Celowa nitka:',
	'lqt-merge-submit' => 'Zjadnośiś',
	'lqt-merge-success' => 'Sy nitku $1 wuspěšnje pód nitku $2 pśesunuł.',
	'lqt-log-name' => 'Protokol nitkoweje diskusije',
	'lqt-log-header' => 'Toś ten protokol nalicujo akcije, kótarež su se na diskusijnych nitkach pśewjadli.',
	'lqt-log-action-move' => 'jo [[$1]] wót [[$2]] do [[$3]] pśesunuł.',
	'lqt-log-action-split' => 'jo wótźělił [[$1]] wót [[$3]], nowa tema je "$2"',
	'lqt-log-action-merge-across' => 'jo pśesunuł [[$1]] z [[$2]] do [[$3]]',
	'lqt-log-action-merge-down' => 'jo zjadnośił [[$1]] do [[$3]]',
	'lqt-log-action-subjectedit' => 'jo změnił [[$1]] wót "$2" do "$3"',
	'lqt-log-action-resort' => 'jo změnił sortěrowański pórěd [[$1]]. Sortěrowański kluc jo se změnił wót $2 do $3',
	'lqt-preference-notify-talk' => 'E-mail wó wótegronach k nitce, kótaraž se wobglědujo, pósłaś',
	'lqt-preference-watch-threads' => 'Nitki wobglědowaś, kótarež napórajom abo na kótarež wótegranjam',
	'prefs-lqt' => 'Diskusija w nitkach',
	'lqt-preference-display-depth' => 'Maksimalny dłym wótegronow, kótaraž ma se pokazaś:',
	'lqt-preference-display-count' => 'Maksimalna licba wótegronow, kótaraž ma se pokazaś:',
	'lqt-preference-custom-signatures' => 'Swójske wužywarske signatury pokazaś',
	'lqt-enotif-subject-reply' => '{{SITENAME}} diskusija - wótegrono: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} diskusija - nowa nitka: $1',
	'lqt-enotif-newthread' => "Witaj $1,
to jo zdźělenje wót {{GRAMMAR:genitiw|{{SITENAME}}}}, až jo se nowa nitka na $5, '$2' $3 $4 napórała.

Móžoš jo na <$6> wiźeś",
	'lqt-enotif-reply' => "Witaj $1,
to jo zdźělenje wót {{GRAMMAR:genitiw|{{SITENAME}}}}, až jo se nowe wótegrono k '$2' na $5 $3 $4 napórało.

Móžoš jo na <$6> wiźeś

Tekst wótegrona jo:
$7",
	'lqt-quote-intro' => '$2 $3 jo [[User:$1|$1]] {{GENDER:$1|napisał|napisała|napisał}}:',
	'lqt-quote' => 'Citěrowaś',
	'lqt-search-legend' => 'Diskusije na toś tom boku pśepytaś',
	'lqt-search-label' => 'Pytańske wuraze:',
	'lqt-search-button' => 'Pytaś',
	'searchprofile-threads' => 'Diskusije',
	'searchprofile-threads-tooltip' => 'Diskusije w nitkach a diskusijne boki pśepytaś',
	'lqt-ajax-updated' => 'Toś ta nitka ma nowe powěsći.',
	'lqt-ajax-update-link' => 'Aktualizěrowaś',
	'lqt-thread-show-replies' => '$1 {{PLURAL:$1|wótegrono|wótegronje|wótegrona|wótegronow}} pokazaś',
	'lqt-thread-show-more' => 'Dalšne wótegrona pokazaś',
	'lqt-thread-link-url' => 'URL wótkaza:',
	'lqt-thread-link-title' => 'Wikitekstowy wótkaz:',
	'lqt-thread-link-copy' => 'Do mjazywótkładowaka kopěrowaś',
	'lqt-sign-not-necessary' => 'Njetrjebaš swóju powěsć ze styrimi tildami pódpisaś.
Pódpis pokazujo se awtomatiski.',
	'lqt-marked-as-read-placeholder' => 'Nitka $1 jo se markěrowała ako pśecytana.',
	'lqt-change-subject' => 'Temu změniś',
	'lqt-save-subject' => 'Składowaś',
	'lqt-save-subject-failed' => 'Pśi wopyśe temu toś teje nitki změniś, jo slědujuca zmólka nastała: $1',
	'lqt-ajax-invalid-subject' => 'Tema, kótaruž sy pódał, jo njepłaśiwa była, nejskerjej, dokulaž jo pśedłujko była.',
	'lqt-ajax-no-subject' => 'Musyš temu pódaś.',
	'lqt-save-subject-error-unknown' => 'Pśi wopyśe temu toś teje nitki pódaś, jo njeznata zmólka nastała. Klikni na "wobźěłaś", aby to cynił.',
	'lqt-cancel-subject-edit' => 'Pśetergnuś',
	'lqt-drag-activate' => 'Do nowego městna śěgnuś',
	'lqt-drag-drop-zone' => 'How wótpołožyś',
	'lqt-drag-confirm' => 'Aby wuwjadł slědujuce akcije, zapiš pšosym pśicynu a klikni na "Wobkšuśiś".',
	'lqt-drag-reparent' => 'Powěsć pód nowe nadpismo pśesunuś.',
	'lqt-drag-split' => 'Powěsć do swójeje nitki pśesunuś',
	'lqt-drag-setsortkey' => 'Poziciju powěsći na boku korigěrowaś',
	'lqt-drag-bump' => 'Powěsć na zachopjeńk diskusijnego boka pśesunuś',
	'lqt-drag-save' => 'Wobkšuśiś',
	'lqt-drag-title' => 'Śěgnjenje wobkšuśiś',
	'lqt-drag-reason' => 'Pśicyna:',
	'lqt-drag-subject' => 'Nadpismo za nowu nitku:',
	'lqt-edit-signature' => '(pódpis wobźěłaś)',
	'lqt-preview-signature' => '(pśeglěd)',
	'lqt-feed-title-all' => '{{SITENAME}} - nowe powěsći',
	'lqt-feed-title-all-from' => '{{SITENAME}} - nowe powěsći z $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} - nowe nitki',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} - nowe nitki z $1',
	'lqt-feed-title-replies' => '{{SITENAME}} - wótegrona',
	'lqt-feed-title-replies-from' => '{{SITENAME}} - wótegrona z $1',
	'lqt-feed-new-thread-intro' => 'Nowa nitka na $1 pósłana wót $2',
	'lqt-feed-reply-intro' => 'Wótegrono na $3 (na $1) pósłane wót $2',
	'tooltip-pt-newmessages' => 'Pokazujo nowe powěsći k nitkam abo na diskusijnych bokach nitkow, kótarež wobglědujoš',
	'lqt-newmessages-n' => 'nowe powěsći ($1)',
	'lqt_newmessages' => 'nowe powěsći',
	'lqt_newmessages-title' => 'Nowe powěsći',
	'lqt-newpost-summary' => 'Nowa nitka: $1',
	'lqt-reply-summary' => 'Wótegrono na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historija diskusijnego boka',
	'lqt-talkpage-history-subtitle' => 'Za $1',
	'lqt-talkpage-history-tab' => 'Głowa',
	'restriction-reply' => 'Wótegrona pósłaś',
	'restriction-newthread' => 'Nowe nitki pósłaś',
	'lqt-protected-reply-thread' => 'Njamóžoš w toś tej nitce powěsć pósłaś, dokulaž jo se šćitała pśeśiwo nowym powěsćam.',
	'lqt-protected-reply-talkpage' => 'Njamóžoš w toś tej nitce powěsć pósłaś, dokulaž toś ten diskusijny bok jo se šćitał pśeśiwo wótegronam do jogo nitkow.',
	'lqt-protected-newthread' => 'Njamóžoš nowe nitki do toś togo diskusijnego boka pósłaś, dokulaž jo se šćitał pśeśiwo nowym nitkam.',
	'lqt-edit-bump' => 'Toś tu nitku aktiwěrowaś',
	'lqt-edit-bump-tooltip' => 'Toś tu nitku do zachopjeńka jeje diskusijnego boka pśesunuś',
	'lqt-historicalrevision-error' => 'Wersija, kótaruž sy wubrał, jo wobškóźona, a njedajo se zwobrazniś.',
	'lqt-reply-subpage' => 'Wótegroniś',
	'nstab-thread' => 'Nitka',
	'nstab-summary' => 'Zespominanje',
);

/** Ewe (Eʋegbe)
 * @author Natsubee
 */
$messages['ee'] = array(
	'lqt_contents_title' => 'Emenyawo',
	'lqt_delete' => 'Tutui',
	'lqt_move_move' => 'Ɖɔli eƒe nɔƒe',
	'lqt_delete_return' => 'Gbugbɔ yi $1.',
	'lqt-movethread' => 'Ɖɔli eƒe nɔƒe',
	'lqt-search-button' => 'Dii',
	'lqt_newmessages' => 'Du yeyewo',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Crazymadlover
 * @author Geraki
 * @author Omnipaedista
 * @author ZaDiak
 * @author Απεργός
 */
$messages['el'] = array(
	'lqt-desc' => 'Προσθήκη θεματικών συζητήσεων στις σελίδες συζήτησης',
	'lqt_movethread' => 'Μετακίνηση θέματος σε άλλη σελίδα',
	'lqt_deletethread' => 'Διαγραφή η επαναφορά θέματος',
	'lqt_contents_title' => 'Περιεχόμενα',
	'lqt_toc_thread_title' => 'Τίτλος θέματος',
	'lqt_toc_thread_author' => 'Άρχισε από',
	'lqt_toc_thread_replycount' => 'Απαντήσεις',
	'lqt_toc_thread_modified' => 'Τελευταία επεξεργάστηκε',
	'lqt_add_header' => 'Προσθήκη επικεφαλίδας',
	'lqt_new_thread' => 'Ξεκινήστε μια νέα συζήτηση',
	'lqt_empty_subject' => 'Πρέπει να εισάγετε ένα υποκείμενο.',
	'lqt_reply' => 'Απάντηση',
	'lqt_delete' => 'Διαγράψτε',
	'lqt_undelete' => 'Επαναφορά',
	'lqt_permalink' => 'Σύνδεση με',
	'lqt_fragment' => 'Τμήμα ενός $1 στη $2',
	'lqt_discussion_link' => 'συζήτηση',
	'lqt_from_talk' => 'Από $1',
	'lqt-history-title' => 'Ιστορία θέματος',
	'lqt_hist_comment_edited' => '[$2 Επεξεργάστηκε] το κείμενο σχολίων',
	'lqt_hist_summary_changed' => 'Η σύνοψη άλλαξε',
	'lqt_hist_reply_created' => 'Δημιουργήθηκε [[$1|νέα απάντηση]]',
	'lqt_hist_thread_created' => 'Δημιουργήθηκε νέο θέμα',
	'lqt_hist_deleted' => 'Διαγραμμένος',
	'lqt_hist_undeleted' => 'Επαναφέρθηκε',
	'lqt_hist_moved_talkpage' => 'Μετακινήθηκε',
	'lqt_hist_listing_subtitle' => 'Εμφάνιση της καταγραφής ιστορικού',
	'lqt_hist_view_whole_thread' => 'Εμφάνιση ιστορικού για όλο το θέμα',
	'lqt_hist_no_revisions_error' => 'Αυτό το θέμα δεν έχει κάποιες εκδόσεις ιστορικού.',
	'lqt_hist_split' => 'Διαχωρισμός απάντησης σε ένα νέο θέμα',
	'lqt_hist_edited_subject' => 'Αλλαγή θέματος από "$2" σε "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Επεξεργασμένο θέμα',
	'lqt_hist_merged_from' => 'Η [[$1|απάντηση]] μεταφέρθηκε σε νέο θέμα',
	'lqt_hist_merged_to' => '[[$1|Απάντηση]] που μεταφέρθηκε από άλλο θέμα',
	'lqt_hist_split_from' => 'Διαχωρισμός σε ένα νέο θέμα',
	'lqt_hist_root_blanked' => 'Διαγραμμένο κείμενο σχολίων',
	'lqt_revision_as_of' => 'Έκδοση όπως στις $2 στις $3.',
	'lqt_youhavenewmessages' => 'Έχετε [[$1|νέα μηνύματα]].',
	'lqt_protectedfromreply_link' => 'προστατευμένο',
	'lqt_subject' => 'Θέμα:',
	'lqt_noreason' => 'Δεν δίνετε λόγος.',
	'lqt_thread_deleted' => 'Το θέμα έχει διαγραφεί.',
	'lqt_summary_notice_link' => 'γράψτε μια περίληψη',
	'lqt_summary_label' => 'Περίληψη του θέματος:',
	'lqt_summary_subtitle' => 'Σύνοψη του $1.',
	'lqt_nosuchrevision' => 'Δεν υπάρχει τέτοια έκδοση αυτού του θέματος.',
	'lqt_nosuchthread' => 'Το θέμα που δώσατε δεν υπάρχει.',
	'lqt_nosuchthread_title' => 'Κανένα τέτοιο θέμα',
	'lqt_move_movingthread' => 'Μετακινείται το $1.
Αυτό το τμήμα είναι μέρος του $2.',
	'lqt_move_torename_edit' => 'επεξεργαστείτε το',
	'lqt_move_destinationtitle' => 'Τίτλος του προορισμού σελίδας συζήτησης:',
	'lqt_move_move' => 'Μετακίνηση',
	'lqt_move_nodestination' => 'Πρέπει να δώσετε ένα προορισμό.',
	'lqt_move_samedestination' => 'Το θέμα είναι ήδη σε αυτή τη σελίδα!',
	'lqt_move_noreason' => 'Δεν δίνεται λόγος.',
	'lqt_move_success' => 'Το θέμα μεταφέρθηκε στο $1.',
	'lqt_delete_undeletethread' => 'Επαναφορά θέματος',
	'lqt_delete_partof' => "Αυτό το θέμα είναι μέρος του '''$1'''.",
	'lqt_delete_deletethread' => 'Διαγραφή θέματος και απαντήσεων',
	'lqt_delete_deleted' => 'Το θέμα διαγράφηκε.',
	'lqt_delete_undeleted' => 'Το θέμα επαναφέρθηκε.',
	'lqt_delete_return' => 'Επιστρέψτε στο $1',
	'lqt_delete_return_link' => 'Η σελίδα συζήτησης',
	'lqt_delete_show_checkbox' => 'Εμφάνιση διαγραμμένων θεμάτων',
	'lqt_header_warning_big' => 'Επεξεργάζεστε το $1.',
	'lqt_header_warning_bold' => 'επικεφαλίδα σελίδας συζήτησης',
	'lqt_header_warning_new_discussion' => 'ξεκινήστε μια νέα συζήτηση',
	'lqt_sorting_order' => 'Σειρά κατάταξης:',
	'lqt_sort_newest_changes' => 'οι τελευταίες επεξεργασίες πρώτα',
	'lqt_sort_newest_threads' => 'τα νεότερα θέματα πρώτα',
	'lqt_sort_oldest_threads' => 'τα παλαιότερα θέματα πρώτα',
	'lqt-title' => 'Τίτλος',
	'lqt-summary' => 'Σύνοψη',
	'lqt-searching' => 'Αναζήτηση για θέματα',
	'lqt-read-message' => 'Σήμανση ως διαβασμένο',
	'lqt-read-all' => 'Σήμανση όλων ως διαβασμένα',
	'lqt-marked-read' => "Το θέμα '''$1''' σημάνθηκε ως διαβασμένο.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|μήνυμα έχει|μηνύματα έχουν}} σημανθεί ως διαβασμένα.',
	'lqt-email-undo' => 'Ακύρωση',
	'lqt-no-new-messages' => 'Δεν υπάρχουν νέα μηνύματα για σας.',
	'lqt-new-messages' => '✒ Υπάρχουν νέα μηνύματα για σας.',
	'lqt-newmessages-context' => 'Πλήρες θέμα',
	'lqt-thread-created' => 'Δημιουργήθηκε',
	'lqt-history-time' => 'Ώρα',
	'lqt-history-user' => 'Χρήστης',
	'lqt-history-action' => 'Δραστηριότητα',
	'lqt-history-comment' => 'Σχόλιο',
	'lqt-history-thread' => 'Θέμα',
	'lqt-thread-edited-author' => 'Επεξεργάστηκε από τον συγγραφέα.<br />
Τελευταία επεξεργασία: $1',
	'lqt-thread-edited-others' => 'Επεξεργάστηκε από {{PLURAL:$2|άλλο χρήστη|$2 χρήστες}}.<br />
Τελευταία επεξεργασία: $1',
	'lqt-header-actions' => 'Ενέργειες',
	'lqt_summarize_link' => 'Συνοψίστε',
	'lqt-thread-split' => 'Διαχωρισμός σε νέο θέμα',
	'lqt_split_thread' => 'Διαχωρισμός ενός θέματος',
	'lqt-thread-split-subject' => 'Αντικείμενο νέου τμήματος:',
	'lqt-thread-split-thread' => 'Νήμα συζήτησης:',
	'lqt-split-submit' => 'Διαχωρισμός',
	'lqt-movethread' => 'Μετακίνηση',
	'lqt-menu-trigger' => 'Περισσότερα',
	'lqt-newmessages-from' => 'Από $1',
	'lqt-hot-topics' => 'Φλέγοντα θέματα',
	'lqt-add-reply' => 'Προσθήκη απάντησης',
	'right-lqt-split' => 'Διαχωρισμός θεμάτων',
	'right-lqt-merge' => 'Συγχώνευση θεμάτων',
	'lqt-thread-merge' => 'Συγχώνευση σε ένα άλλο θέμα',
	'lqt-thread-merge-to' => 'Συγχώνευση αυτού του θέματος',
	'lqt_merge_thread' => 'Συγχώνευση θέματος',
	'lqt-thread-merge-source' => 'Πηγαία θέμα:',
	'lqt-thread-merge-dest' => 'Προορισμός θέματος:',
	'lqt-merge-submit' => 'Συγχώνευση',
	'lqt-log-name' => 'Αρχείο συζητήσεων χωρισμένο κατά τμήματα',
	'lqt-log-action-move' => 'μετακίνησε το [[$1]] από [[$2]] σε [[$3]].',
	'prefs-lqt' => 'Συζήτηση σε νήματα',
	'lqt-enotif-subject-reply' => '{{SITENAME}} συζήτηση - Απάντηση: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} συζήτηση - Νέο θέμα: $1',
	'lqt-quote-intro' => 'Την $2 στις $3, ο [[User:$1|$1]] έγραψε:',
	'lqt-quote' => 'Απόσπασμα',
	'lqt-search-legend' => 'Αναζήτηση συζητήσεων σε αυτή τη σελίδα',
	'lqt-search-label' => 'Αναζήτηση όρων:',
	'lqt-search-button' => 'Αναζήτηση',
	'searchprofile-threads' => 'Συζητήσεις',
	'lqt-ajax-updated' => 'Αυτό το θέμα έχει νέες δημοσιεύσεις.',
	'lqt-ajax-update-link' => 'Ενημέρωση',
	'lqt-thread-show-replies' => 'Εμφάνιση $1 απαντἠσεων',
	'lqt-thread-show-more' => 'Προβολή περισσότερων απαντήσεων',
	'lqt-thread-link-url' => 'Σύνδεσμος URL:',
	'lqt-thread-link-title' => 'Σύνδεσμος Βικικειμένου:',
	'lqt-change-subject' => 'Αλλαγή θέματος',
	'lqt-save-subject' => 'Αποθήκευση',
	'lqt-ajax-no-subject' => 'Πρέπει ναι προσδιορίσετε ένα υποκείμενο.',
	'lqt-cancel-subject-edit' => 'Άκυρο',
	'lqt-drag-save' => 'Επιβεβαίωση',
	'lqt-drag-reason' => 'Αιτία:',
	'lqt-drag-subject' => 'Υποκείμενο για νέο θέμα:',
	'lqt-edit-signature' => '(επεξεργασία υπογραφής)',
	'lqt-preview-signature' => '(προεπισκόπηση)',
	'lqt-feed-title-all' => '{{SITENAME}} — Νέες δημοσιεύσεις',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Νέες δημοσιεύσεις από $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Νέα θέματα',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Νέα θέματα από $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Απαντήσεις',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Απαντήσεις από $1',
	'lqt-newmessages-n' => 'Νέα μηνύματα ($1)',
	'lqt_newmessages' => 'Νέα Μηνύματα μου (Κανένα)',
	'lqt_newmessages-title' => 'Νέα μηνύματα',
	'lqt-newpost-summary' => 'Νέο θέμα: $1',
	'lqt-reply-summary' => 'Απάντηση σε [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Ιστορικό σελίδας συζήτησης',
	'lqt-talkpage-history-subtitle' => 'Για $1',
	'lqt-talkpage-history-tab' => 'Επικεφαλίδα',
	'restriction-reply' => 'Δημοσίευση απαντήσεων',
	'restriction-newthread' => 'Δημοσίευση νέων θεμάτων',
	'lqt-edit-bump' => 'Προσκρούστε αυτό το θέμα',
	'lqt-reply-subpage' => 'απάντηση',
);

/** British English (British English)
 * @author Reedy
 */
$messages['en-gb'] = array(
	'lqt_summarize_link' => 'Summarise',
	'lqt-summarize-intro' => 'Please summarise the below thread in the editing box.
You may use any wikitext in your summary.
When you finish, click "{{int:savearticle}}".',
);

/** Esperanto (Esperanto)
 * @author AVRS
 * @author ArnoLagrange
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'lqt-desc' => 'Aldonas fadenajn diskutojn al diskuto-paĝoj',
	'lqt_movethread' => 'Movu fadenon al alia paĝo',
	'lqt_deletethread' => 'Forigi aŭ restarigi fadenon',
	'lqt_contents_title' => 'Enhavo',
	'lqt_toc_thread_title' => 'Fadena titolo',
	'lqt_toc_thread_author' => 'Komencis de',
	'lqt_toc_thread_replycount' => 'Respondoj',
	'lqt_toc_thread_modified' => 'Laste ŝanĝita',
	'lqt_add_header' => 'Aldonu titolon',
	'lqt_new_thread' => 'Kreu novan diskuton',
	'lqt_invalid_subject' => 'La tempo kiun vi enigis estas malvalida.
Eble ĝi estas:
*Tro longa, aŭ
*Konflikta kun intervikiaj prefiksoj aŭ nomspacaj nomoj.',
	'lqt_empty_subject' => 'Vi devas enigi temon.',
	'lqt_reply' => 'Respondu',
	'lqt-parent' => 'Patra',
	'lqt_delete' => 'Forigi',
	'lqt_undelete' => 'Restarigu',
	'lqt_permalink' => 'Ligu al',
	'lqt_fragment' => 'Ero de $1 de $2',
	'lqt_discussion_link' => 'diskuto',
	'lqt_from_talk' => 'De $1',
	'lqt-history-title' => 'Fadena historio',
	'lqt_hist_comment_edited' => 'Teksto de komento [$2 redaktita]',
	'lqt_hist_summary_changed' => 'Resumo ŝanĝita',
	'lqt_hist_reply_created' => '[[$1|Nova respondo]] kreita',
	'lqt_hist_thread_created' => 'Nova fadeno kreita',
	'lqt_hist_deleted' => 'Forigita',
	'lqt_hist_undeleted' => 'Restarigita',
	'lqt_hist_moved_talkpage' => 'Movita',
	'lqt_hist_listing_subtitle' => 'Rigardante historian liston',
	'lqt_hist_view_whole_thread' => 'Rigardu historion por la tuta fadeno',
	'lqt_hist_no_revisions_error' => 'Ĉi tiu fadeno ne havas ĉiujn historiajn versiojn.',
	'lqt_hist_past_last_page_error' => 'Vi estas preter la nombro de paĝoj da historio kiu povas ekzisti.',
	'lqt_hist_tooltip_newer_disabled' => 'Ĉi tiu ligilo estas malŝalta ĉar vi estas en la unua paĝo.',
	'lqt_hist_tooltip_older_disabled' => 'Ĉi tiu ligilo estas malŝalta ĉar vi estas en la lasta paĝo.',
	'lqt_hist_split' => 'Respondo dividiĝis al nova fadeno',
	'lqt_hist_edited_subject' => 'Ŝanĝis temon de "$2" al "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Ŝanĝis temon',
	'lqt_hist_merged_from' => '[[$1|Respondo]] moviĝis al alia fadeno',
	'lqt_hist_merged_to' => '[[$1|Respondo]] moviĝis de alia fadeno',
	'lqt_hist_split_from' => 'Dividi al nova fadeno',
	'lqt_hist_root_blanked' => 'Forigis tekston de komento',
	'lqt_hist_adjusted_sortkey' => 'Modifis pozicion de fadeno',
	'lqt_revision_as_of' => 'Revizio ekde $2, $3.',
	'lqt_change_new_thread' => 'Jen la unua versio de la fadeno.',
	'lqt_change_reply_created' => 'La [$1 kolorigita komento] estis kreita en ĉi tiu versio.',
	'lqt_change_edited_root' => 'La [$1 kolorigita komento] estis redaktita en ĉi tiu versio.',
	'lqt_change_edited_summary' => 'La fadena resumo estis redaktita',
	'lqt_change_deleted' => '[$1 Ĉi tiu fadeno] aŭ ties superaĵo estis forigita',
	'lqt_change_undeleted' => 'La [$1 kolorigita afiŝo] estis restarigita',
	'lqt_change_moved' => '[$1 Ĉi tiu fadeno] estis movita al alia diskuto-paĝo',
	'lqt_change_split' => '[$1 Ĉi tiu fadeno] estis dividita de alia fadeno',
	'lqt_change_edited_subject' => 'La temo de ĉi tiu fadeno estis ŝanĝita de "$2" al "$3"',
	'lqt_change_merged_from' => '[$1 Respondo] al ĉi tiu fadeno estis movita al alia fadeno',
	'lqt_change_merged_to' => 'La [$1 kolorigita respondo] estis movita de alia fadeno',
	'lqt_change_split_from' => '[$1 Subfadeno] de ĉi tiu fadeno estis dividita en ĝia propra fadeno',
	'lqt_change_root_blanked' => 'La teksto de [$1 komento] estis forigita.',
	'lqt_youhavenewmessages' => 'Vi havas [[$1|novajn mesaĝojn]].',
	'lqt_protectedfromreply' => 'Ĉi tiu fadeno estis $1 de respondado.',
	'lqt_protectedfromreply_link' => 'protektita',
	'lqt_subject' => 'Subjekto:',
	'lqt_noreason' => 'Nenia kialo donata',
	'lqt_move_placeholder' => 'Diskutfadeno, $1, estis movita de ĉi tie al $5.
La movon faris $2 je $3, $4.',
	'lqt_thread_deleted_for_sysops' => "Ĉi tiu fadeno estis '''forigita''' kaj nur estas videbla al administrantoj.",
	'lqt_thread_deleted' => 'Ĉi tiu fadeno estis forigita.',
	'lqt_summary_notice' => 'Estis neniu ŝanĝo al ĉi tiu diskuto por almenaŭ $2 {{PLURAL:$2|tago|tagoj}}.
Se ĝi estas fermita, eble vi volus $1.',
	'lqt_summary_notice_link' => 'verki resumon',
	'lqt_summary_label' => 'Resumo de fadeno:',
	'lqt_summary_subtitle' => 'Resumo de $1.',
	'lqt_nosuchrevision' => 'Ne estas tia versio de ĉi tiu fadeno.',
	'lqt_nosuchthread' => 'La fadeno, kiun vi specifis, ne ekzistas.',
	'lqt_nosuchthread_title' => 'Nenia fadeno',
	'lqt_threadrequired' => 'Vi devas enigi fadenon en la URL-o.',
	'lqt_move_movingthread' => 'Movante $1. Ĉi tiu fadeno estas parto de $2.',
	'lqt_move_torename' => "Por renomigi ĉi tiun fadenon, $1 kaj ŝanĝu la kampon 'Temo'.",
	'lqt_move_torename_edit' => 'redaktu ĝin',
	'lqt_move_destinationtitle' => 'Titolo de destina diskuto-paĝo:',
	'lqt_move_move' => 'Alinomigi',
	'lqt_move_nodestination' => 'Vi nepre specifu destinon.',
	'lqt_move_thread_bad_destination' => 'La celo-paĝo ne estas diskuto paĝo.',
	'lqt_move_samedestination' => 'La fadeno estas jam en ĉi tiu paĝo!',
	'lqt_move_noreason' => 'Nenia kialo donata',
	'lqt_move_success' => 'Ĉi tiu fadeno estis movita al $1.',
	'lqt_delete_undeletethread' => 'Restarigu fadenon',
	'lqt_delete_partof' => "Ĉi tiu fadeno estas parto de '''$1'''.",
	'lqt_delete_deleting' => "Forigante '''$1''' kaj ''ĉiuj respondoj''' al ĝi.",
	'lqt_delete_deletethread' => 'Forigu fadenon kaj respondojn',
	'lqt_delete_deleted' => 'La fadeno estis forigita.',
	'lqt_delete_undeleted' => 'La fadeno estis restarigita.',
	'lqt_delete_return' => 'Reiri al $1.',
	'lqt_delete_return_link' => 'la diskuto-paĝo',
	'lqt_delete_unallowed' => 'Vi ne estas permesita forigi fadenojn.',
	'lqt_delete_show_checkbox' => 'Montri forigitajn fadenojn',
	'lqt_talkpage_autocreate_summary' => 'Diskuto-paĝo aŭtomate kreiĝis kiam unu fadeno estis afiŝita.',
	'lqt_header_warning_big' => 'Vi redaktas $1.',
	'lqt_header_warning_after_big' => 'Titoloj estas por anoncoj kaj antaŭlegaĵoj.
Eble anstataŭe vi volus $2.',
	'lqt_header_warning_bold' => 'diskuto-paĝa kaptitolo',
	'lqt_header_warning_new_discussion' => 'krei novan diskuton',
	'lqt_sorting_order' => 'Ordigo:',
	'lqt_sort_newest_changes' => 'laste modifitaj unue',
	'lqt_sort_newest_threads' => 'Plej novaj fadenoj unue',
	'lqt_sort_oldest_threads' => 'plej malnovaj fadenoj unue',
	'lqt-title' => 'Titolo',
	'lqt-summary' => 'Resumo',
	'lqt-searching' => 'Serĉante fadenojn',
	'lqt-read-message' => 'Marki kiel legitan',
	'lqt-read-message-tooltip' => 'Forigi ĉi tiun fadenon de novaj mesaĝoj.
Ĝi videblos en ĝia originala diskuto-paĝo.',
	'lqt-read-all' => 'Marki ĉion kiel legitan',
	'lqt-read-all-tooltip' => 'Forigi ĉiujn fadenojn de novaj mesaĝoj.
Ili ankoraŭ estos videbla en ties originalaj diskuto-paĝoj.
Ĉi tiu operacio ne estas farebla.',
	'lqt-marked-read' => "Fadeno '''$1''' estis markita kiel legita.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mesaĝo|mesaĝoj}} estis markitaj kiel legitaj.',
	'lqt-email-undo' => 'Malfari',
	'lqt-no-new-messages' => 'Estas neniuj novaj mesaĝoj por vi.',
	'lqt-new-messages' => '✒ Jen novaj mesaĝoj por vi.',
	'lqt-email-info-undo' => 'Renovigi la fadenon kiun vi ĵus formetis.',
	'lqt-date-info' => 'Ĉi tiu ligilo estas malŝaltita ĉar vi estas vidante fadenojn de ĉiuj datoj.',
	'lqt-newmessages-context' => 'Plena fadeno',
	'lqt-thread-created' => 'Kreita',
	'lqt-history-time' => 'Tempo',
	'lqt-history-user' => 'Uzanto',
	'lqt-history-action' => 'Aktiveco',
	'lqt-history-comment' => 'Komento',
	'lqt-history-thread' => 'Fadeno',
	'lqt-thread-edited-author' => 'Redaktita de aŭtoro.<br />
Lasta redakto: $1',
	'lqt-thread-edited-others' => 'Redaktita de {{PLURAL:$2|alia uzanto|$2 aliaj uzantoj}}.<br />
Lasta redakto: $1',
	'lqt-header-actions' => 'Agoj',
	'lqt_summarize_link' => 'Resumigi',
	'lqt-summarize-intro' => 'Bonvolu resumi la jenan fadenon en la redaktujo.
Vi povas utiligi iun vikitekston en via resumo.
Kiam vi finiĝas, klaku "{{int:savearticle}}".',
	'lqt-thread-split' => 'Dividigi al nova fadeno',
	'lqt-split-success' => 'Vi sukcese dividis la fadenon $1.',
	'lqt_split_thread' => 'Dividi fadenon',
	'lqt-thread-split-subject' => 'Nova fadena temo:',
	'lqt-thread-split-thread' => 'Fadeno:',
	'lqt-split-submit' => 'Dividi',
	'lqt_split_badsubject' => 'La fadeno kiun vi enigis estas malvalida.',
	'lqt-no-threads' => 'Estas ankoraŭ neniuj fadenoj en ĉi tiu paĝo.',
	'lqt-delete-parent-warning' => 'Ĉi tiu estas supren-nivela fadeno kun respondoj.
Ĝiaj respondoj ankaŭ estos forigita aŭtomate.
Eviti ĉi tion, dividigu ilin de ĉi tiu fadeno antaŭ forigante ĝin.',
	'lqt-delete-parent-deleted' => 'Supera fadeno estis forigita ($1)',
	'lqt-delete-replies-done' => 'Ĉiuj respondoj al ĉi tiu fadeno estis ankaŭ forigita.',
	'lqt-movethread' => 'Movi',
	'lqt-menu-trigger' => 'Pli',
	'lqt-newmessages-from' => 'De $1',
	'lqt-hot-topics' => 'Furoraj temoj',
	'lqt-add-reply' => 'Aldoni respondon',
	'lqt_rc_new_discussion' => 'faris novan fadenon, "$1"',
	'lqt_rc_new_reply' => 'afiŝis respondon al "$1"',
	'right-lqt-split' => 'Dividi fadenojn',
	'right-lqt-merge' => 'Kunigi fadenojn',
	'lqt-thread-merge' => 'Kunigi en alia fadeno',
	'lqt-thread-merge-to' => 'Kunigi en ĉi tiu fadeno',
	'lqt_merge_thread' => 'Kunigi fadenon',
	'lqt-thread-merge-source' => 'Fonta fadeno:',
	'lqt-thread-merge-dest' => 'Cela fadeno:',
	'lqt-merge-submit' => 'Kunigi',
	'lqt-merge-success' => 'Vi sukcese kunigis la fadeno $1 al sub $2.',
	'lqt-log-name' => 'Fadeneca diskuto-protokolo',
	'lqt-log-header' => 'Ĉi tiu protoko detalas agojn faritajn en diskuto-fadenoj.',
	'lqt-log-action-move' => 'movis [[$1]] de [[$2]] al [[$3]].',
	'lqt-log-action-split' => 'apartigi [[$1]] de sub [[$3]], kun la nova temo "$2"',
	'lqt-log-action-merge-across' => 'movis [[$1]] de sub [[$2]] al sub [[$3]]',
	'lqt-log-action-merge-down' => 'kunigis [[$1]] al sub [[$3]]',
	'lqt-log-action-subjectedit' => 'ŝanĝis la temon de [[$1]] de "$2" al "$3"',
	'lqt-log-action-resort' => ' modifis la ordigon de [[$1]]. La ordiga ŝlosilo ŝanĝiĝis de $2 al $3',
	'lqt-preference-notify-talk' => 'Retpoŝti al mi pri respondoj en fadeno kiun mi atentas',
	'lqt-preference-watch-threads' => 'Atenti fadenojn kiun mi kreas aŭ respondas',
	'prefs-lqt' => 'Fadeneca diskuto',
	'lqt-preference-display-depth' => 'Maksimuma respondan profundecon por montri:',
	'lqt-preference-display-count' => 'Maksimuma nombro de respondoj por montri:',
	'lqt-preference-custom-signatures' => 'Montri proprajn uzulajn subskribojn',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-diskuto - Respondo: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-fadeno - Nova fadeno: $1',
	'lqt-enotif-newthread' => "Saluton $1,
Jen sciigo de {{SITENAME}} ke nova fadeno en $5, '$2',
estis kreita je $3, $4 de $8.

Vi povas vidi ĝin ĉe <$6>

La teksto estas:
$7",
	'lqt-enotif-reply' => "Saluton $1,
Jen sciigo de {{SITENAME}} pri nova respondo al '$2' en $5,
estis kreita je $3, $4 de $8.

Vi povas vidi ĝin ĉe <$6>

La teksto de la respondo estas:
$7",
	'lqt-quote-intro' => 'Je $2, $3, [[User:$1|$1]] skribis:',
	'lqt-quote' => 'Citi',
	'lqt-search-legend' => 'Serĉi diskutojn en ĉi tiu paĝo',
	'lqt-search-label' => 'Serĉaj parametroj:',
	'lqt-search-button' => 'Serĉi',
	'searchprofile-threads' => 'Diskutoj',
	'searchprofile-threads-tooltip' => 'Serĉi fadencajn disĝkutojn kaj diskuto-paĝojn',
	'lqt-ajax-updated' => 'Ĉi tiu fadeno havas novajn afiŝojn.',
	'lqt-ajax-update-link' => 'Ĝisdatigi',
	'lqt-thread-show-replies' => 'Montri $1 {{PLURAL:$1|respondon|respondojn}}',
	'lqt-thread-show-more' => 'Montri pliajn respondojn',
	'lqt-thread-link-url' => 'Ligilo-URL:',
	'lqt-thread-link-title' => 'Vikiteksta ligilo:',
	'lqt-thread-link-copy' => 'Kopii al tondujo',
	'lqt-sign-not-necessary' => 'Ne necesas subskribi vian afiŝon per kvar tildoj.
La subskribo estas aŭtomate montrita.',
	'lqt-marked-as-read-placeholder' => 'La fadeno $1 estis markita kiel legita.',
	'lqt-change-subject' => 'Ŝanĝi temon',
	'lqt-save-subject' => 'Konservi',
	'lqt-save-subject-failed' => 'La jena eraro okazis dum provante ŝanĝi la temon de ĉi tiu fadeno: $1',
	'lqt-ajax-invalid-subject' => 'La temo kiun vi enigis estis malvalida, verŝajne ĉar ĝi estis tro longa.',
	'lqt-ajax-no-subject' => 'Vi devas specifigi temon.',
	'lqt-save-subject-error-unknown' => 'Nekonata eraro okazis kiam provante farigi la temon de ĉi tiu fadeno. Bonvolu provi fari ĉi tiel klakante "redakti" en la plej alta afiŝo.',
	'lqt-cancel-subject-edit' => 'Nuligi',
	'lqt-drag-activate' => 'Ŝovu al nova loko',
	'lqt-drag-drop-zone' => 'Demeti ĉi tien',
	'lqt-drag-confirm' => 'Por fari la jenajn agojn, bonvolu plenumi kialon kaj klaki "Konfirmi".',
	'lqt-drag-reparent' => 'Movi poŝton al alia supera fadeno.',
	'lqt-drag-split' => 'Movi afiŝon al ties propra fadeno',
	'lqt-drag-setsortkey' => 'Modifi la pozicio de afiŝo en la paĝo',
	'lqt-drag-bump' => 'Movi afiŝon al supero de diskuto-paĝo',
	'lqt-drag-save' => 'Konfirmi',
	'lqt-drag-title' => 'Konfirmi trenadon',
	'lqt-drag-reason' => 'Kialo:',
	'lqt-drag-subject' => 'Temo por nova fadeno:',
	'lqt-edit-signature' => '(redakti subskribon)',
	'lqt-preview-signature' => '(antaŭvido)',
	'lqt-feed-title-all' => '{{SITENAME}} — Novaj afiŝoj',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Novaj afiŝoj de $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Novaj fadenoj',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Novaj fadenoj de $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Respndoj',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Respondoj de $1',
	'lqt-feed-new-thread-intro' => 'Nova fadeno en $1 afiŝita de $2',
	'lqt-feed-reply-intro' => 'Respondo al $3 (en $1) afiŝita de $2',
	'lqt-newmessages-n' => 'Novaj mesaĝoj ($1)',
	'lqt_newmessages' => 'Neniuj novaj mesaĝoj por mi',
	'lqt_newmessages-title' => 'Novaj mesaĝoj',
	'lqt-newpost-summary' => 'Nova fadeno: $1',
	'lqt-reply-summary' => 'Respondi al [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historio de diskuto-paĝo',
	'lqt-talkpage-history-subtitle' => 'Por $1',
	'lqt-talkpage-history-tab' => 'Titolo',
	'restriction-reply' => 'Afiŝi respondojn',
	'restriction-newthread' => 'Afiŝi novajn fadenojn',
	'lqt-protected-reply-thread' => 'Vi ne povas afiŝi en ĉi tiu fadeno ĉar ĝi estas protektita de novaj poŝtoj.',
	'lqt-protected-reply-talkpage' => 'Vi ne povas afiŝi en ĉi tiu fadeno ĉar ĉi tiu diskuto-paĝo estis protektita de respondoj al ĝiaj fadenoj.',
	'lqt-protected-newthread' => 'Vi ne povas afiŝi novajn fadenojn al ĉi tiu diskuto-paĝo ĉar ĝi estis protektita de novaj fadenoj.',
	'lqt-edit-bump' => 'Levigi ĉi tiun fadenon',
	'lqt-edit-bump-tooltip' => 'Movi ĉi tiun fadenon al la supero de ĝia diskuto-paĝo',
	'lqt-historicalrevision-error' => 'La revizio kiun vi elektis estas fuŝa, kaj ne estas rigardebla.',
	'lqt-reply-subpage' => 'respondi',
	'nstab-thread' => 'Fadeno',
	'nstab-summary' => 'Resumo',
);

/** Spanish (Español)
 * @author Crazymadlover
 * @author Dferg
 * @author Fitoschido
 * @author Heldergeovane
 * @author Imre
 * @author Locos epraix
 * @author Manuelt15
 * @author McDutchie
 * @author Pertile
 * @author Piolinfax
 * @author Sanbec
 * @author Toliño
 * @author Translationista
 */
$messages['es'] = array(
	'lqt-desc' => 'Agregar discusiones en hilos a páginas de discusión',
	'lqt_movethread' => 'Mover hilo a otra página',
	'lqt_deletethread' => 'Borrar o reestablecer hilo',
	'lqt_contents_title' => 'Contenidos',
	'lqt_toc_thread_title' => 'Título de hilo',
	'lqt_toc_thread_author' => 'Comenzado por',
	'lqt_toc_thread_replycount' => 'Respuestas',
	'lqt_toc_thread_modified' => 'Última modificación',
	'lqt_add_header' => 'Agregar encabezado',
	'lqt_new_thread' => 'Comenzar una nueva discusión',
	'lqt_invalid_subject' => 'El tema que has ingresado es inválido.
Puede:
* Ser demasiado largo, o
* Estar en conflicto con prefijos interwiki o nombres de espacio de nombre.',
	'lqt_empty_subject' => 'Debes escribir un tema.',
	'lqt_reply' => 'Responder',
	'lqt-parent' => 'Padre',
	'lqt_delete' => 'Borrar',
	'lqt_undelete' => 'Restaurar',
	'lqt_permalink' => 'Vínculo a',
	'lqt_fragment' => 'Fragmento de una $1 de $2',
	'lqt_discussion_link' => 'discusión',
	'lqt_from_talk' => 'De $1',
	'lqt-history-title' => 'Historial de hilo',
	'lqt_hist_comment_edited' => 'Texto de comentario [$2 editado]',
	'lqt_hist_summary_changed' => 'Resumen cambió',
	'lqt_hist_reply_created' => '[[$1|Nueva respuesta]] creada',
	'lqt_hist_thread_created' => 'Nuevo hilo creado',
	'lqt_hist_deleted' => 'Borrado',
	'lqt_hist_undeleted' => 'Restaurado',
	'lqt_hist_moved_talkpage' => 'Trasladado',
	'lqt_hist_listing_subtitle' => 'Viendo un listado de historiales',
	'lqt_hist_view_whole_thread' => 'Ver historial del todo el hilo',
	'lqt_hist_no_revisions_error' => 'Este hilo no tiene revisiones de historial.',
	'lqt_hist_past_last_page_error' => 'Estás más alla del número de páginas del hisorial que existen',
	'lqt_hist_tooltip_newer_disabled' => 'Este vínculo está deshabilitado porque estás en la primera página.',
	'lqt_hist_tooltip_older_disabled' => 'Este vínculo está deshabilitado porque estás en la última página.',
	'lqt_hist_split' => 'Respuesta separado en un nuevo hilo',
	'lqt_hist_edited_subject' => 'Tema cambiado de "$2" a "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Tema cambiado',
	'lqt_hist_merged_from' => '[[$1|Respuesta]] movida a otro hilo',
	'lqt_hist_merged_to' => '[[$1|Respuesta]] movida de otro hilo',
	'lqt_hist_split_from' => 'Separar en un nuevo hilo',
	'lqt_hist_root_blanked' => 'Texto de comentario eliminado',
	'lqt_hist_adjusted_sortkey' => 'Posición de hilo ajustada',
	'lqt_revision_as_of' => 'Revisión del $2 a las $3.',
	'lqt_change_new_thread' => 'Esta es la revisión inicial del hilo.',
	'lqt_change_reply_created' => 'El [comentario resaltado $1] fue creado en esta revisión.',
	'lqt_change_edited_root' => 'El [comentario resaltado $1] fue editado en esta revisión.',
	'lqt_change_edited_summary' => 'El resumen del hilo fue editado',
	'lqt_change_deleted' => '[Este hilo $1] o su raíz fue borrada',
	'lqt_change_undeleted' => 'El [mensaje remarcado $1] fue reestablecido',
	'lqt_change_moved' => '[Este hilo $1] fue movido a otra página de discusión',
	'lqt_change_split' => '[Este hilo $1] fue separado de otro hilo',
	'lqt_change_edited_subject' => 'El tema de este hilo fue cambiado de "$2" a "$3".',
	'lqt_change_merged_from' => 'Una [respuesta $1] a este hilo fue movida a otro hilo',
	'lqt_change_merged_to' => 'La [respuesta remarcada $1] fue movida de otro hilo',
	'lqt_change_split_from' => 'Un [subhilo $1] de este hilo fue separada en su propio hilo',
	'lqt_change_root_blanked' => 'El texto de [$1 un comentario] ha sido borrado.',
	'lqt_youhavenewmessages' => 'Tienes [[$1|nuevos mensajes]].',
	'lqt_protectedfromreply' => 'Este hilo ha sido $1. No es posible responder en él.',
	'lqt_protectedfromreply_link' => 'protegido',
	'lqt_subject' => 'Tema:',
	'lqt_noreason' => 'No se da ninguna razón',
	'lqt_move_placeholder' => 'Este hilo es un marcador que indica que el tema $1 ha sido movido de esta página.
El cambio ha sido realizado por $2 el $3 a las $4.
El nuevo tema se encuentra ahora en $5.',
	'lqt_thread_deleted_for_sysops' => "Este hilo ha sido '''borrado''' y es solamente visible para los administradores.",
	'lqt_thread_deleted' => 'Este hilo ha sido borrado.',
	'lqt_summary_notice' => 'No hubo cambios a esta discusión por al menos $2 {{PLURAL:$2|día|días}}.
Si está concluída, talvez quieras $1.',
	'lqt_summary_notice_link' => 'escribir un resumen',
	'lqt_summary_label' => 'Resumen del hilo:',
	'lqt_summary_subtitle' => 'Resumen de "$1"',
	'lqt_nosuchrevision' => 'No hay tal revisión de este hilo.',
	'lqt_nosuchthread' => 'El hilo que has especificado no existe.',
	'lqt_nosuchthread_title' => 'No hay al hilo',
	'lqt_threadrequired' => 'Debes especificar un hilo en el URL.',
	'lqt_move_movingthread' => 'Moviendo $1
Este hilo es parte de $2.',
	'lqt_move_torename' => 'Para renombrar este hilo, $1 y cambia el campo "Tema".',
	'lqt_move_torename_edit' => 'edítalo',
	'lqt_move_destinationtitle' => 'Título de la página de discusión de destino:',
	'lqt_move_move' => 'Trasladar',
	'lqt_move_nodestination' => 'Debes especificar un destino.',
	'lqt_move_thread_bad_destination' => 'La página de destino no es una página de discusión.',
	'lqt_move_samedestination' => 'El hilo ya está en esta página!',
	'lqt_move_noreason' => 'No se da ninguna razón',
	'lqt_move_success' => 'El hilo fue movido a $1',
	'lqt_delete_undeletethread' => 'Hilo reestablecido',
	'lqt_delete_partof' => "Este hilo es parte de '''$1'''.",
	'lqt_delete_deleting' => "Borrando '''$1''' y '''todas las respuestas''' a él.",
	'lqt_delete_deletethread' => 'Borrar hilo y respuestas',
	'lqt_delete_deleted' => 'El hilo fue borrado.',
	'lqt_delete_undeleted' => 'El hilo fue reestablecido.',
	'lqt_delete_return' => 'Volver a $1.',
	'lqt_delete_return_link' => 'la página de discusión',
	'lqt_delete_unallowed' => 'No se te permite borrar hilos',
	'lqt_delete_show_checkbox' => 'Mostrar hilos borrados',
	'lqt_talkpage_autocreate_summary' => 'Página de discusión cuando el primer hilo fue creado.',
	'lqt_header_warning_big' => 'Estás editando un $1.',
	'lqt_header_warning_after_big' => 'Encabezados son para anuncios y prefacios.
Tal vez quieras en su lugar $2.',
	'lqt_header_warning_bold' => 'encabezado de página de discusión',
	'lqt_header_warning_new_discussion' => 'comenzar una nueva discusión',
	'lqt_sorting_order' => 'Orden:',
	'lqt_sort_newest_changes' => 'últimos modificados primero',
	'lqt_sort_newest_threads' => 'Hilos más nuevos primero',
	'lqt_sort_oldest_threads' => 'Hilos más antiguos primero',
	'lqt-title' => 'Título',
	'lqt-summary' => 'Resumen',
	'lqt-searching' => 'Buscar hilos',
	'lqt-read-message' => 'Marcar como leído',
	'lqt-read-message-tooltip' => 'Eliminar este hilo de mensajes nuevos. Aún seguirá estando visible en su página original de discusión.',
	'lqt-read-all' => 'Marcar todos como leídos',
	'lqt-read-all-tooltip' => 'Eliminar todos los hilos de los nuevos mensajes.
Los mismos permanecerán visibles en sus páginas de discusión originales.
Esta operación no se puede deshacer',
	'lqt-marked-read' => "Hilo '''$1''' marcado como leído.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mensaje|mensajes}} marcados como leídos.',
	'lqt-email-undo' => 'Deshacer',
	'lqt-no-new-messages' => 'No hay nuevos mensajes para ti.',
	'lqt-new-messages' => '✒ Hay nuevos mensajes para ti.',
	'lqt-email-info-undo' => 'Restablece el hilo que acaba de descartar.',
	'lqt-date-info' => 'Este enlace está deshabilitado porque estás viendo hilos de todas las fechas.',
	'lqt-newmessages-context' => 'Hilo completo',
	'lqt-thread-created' => 'Creado',
	'lqt-history-time' => 'Tiempo',
	'lqt-history-user' => 'Usuario',
	'lqt-history-action' => 'Actividad',
	'lqt-history-comment' => 'Comentario',
	'lqt-history-thread' => 'Hilo',
	'lqt-thread-edited-author' => 'Editado por el autor<br />
Ultima edición: $1',
	'lqt-thread-edited-others' => 'Editado por {{PLURAL:$2|otro usuario|$2 usuarios}}.<br />
Última edición: $1',
	'lqt-header-actions' => 'Acciones',
	'lqt_summarize_link' => 'Resumir',
	'lqt-summarize-intro' => "Por favor haga un resumen del hilo en el cuadro de edición que aparece debajo.
Puede utilizar cualquier texto wiki en su resumen.
Cuando finalice, haga clic en ''{{int:savearticle}}''.",
	'lqt-thread-split' => 'Separar a un nuevo hilo',
	'lqt-split-success' => 'Has dividido el hilo $1 exitosamente.',
	'lqt_split_thread' => 'Dividir un hilo',
	'lqt-thread-split-subject' => 'Nuevo tema en hilo:',
	'lqt-thread-split-thread' => 'Hilo:',
	'lqt-split-submit' => 'Dividir',
	'lqt_split_badsubject' => 'El tema que has ingresado es inválido.',
	'lqt-no-threads' => 'No hay hilos en esta página aún.',
	'lqt-delete-parent-warning' => 'Este es un hilo de alto nivel con respuestas.
Sus respuestas también serán automáticamente eliminadas.
Para evitarlo, divídalas a partir de este hilo antes de eliminarlas.',
	'lqt-delete-parent-deleted' => 'Hilo padre eliminado ($1)',
	'lqt-delete-replies-done' => 'Todas las respuestas a este hilo han sido también borradas.',
	'lqt-movethread' => 'Mover',
	'lqt-menu-trigger' => 'Más',
	'lqt-newmessages-from' => 'De $1',
	'lqt-hot-topics' => 'Temas populares',
	'lqt-add-reply' => 'Agregar una respuesta',
	'lqt_rc_new_discussion' => 'ha publicado un nuevo hilo: "$1"',
	'lqt_rc_new_reply' => 'Publicada una respuesta para "$1"',
	'right-lqt-split' => 'Separar hilos',
	'right-lqt-merge' => 'Fusionar hilos',
	'lqt-thread-merge' => 'Fusionar dentro de otro hilo',
	'lqt-thread-merge-to' => 'Fusionar dentro de este hilo',
	'lqt_merge_thread' => 'Fusionar hilo',
	'lqt-thread-merge-source' => 'Hilo de origen:',
	'lqt-thread-merge-dest' => 'Hilo de destino:',
	'lqt-merge-submit' => 'Juntar',
	'lqt-merge-success' => 'Usted ha incluido el hilo $1 en el hilo inferior $2 exitosamente.',
	'lqt-log-name' => 'Registro de discusión en hilo',
	'lqt-log-header' => 'Este registro detalla acciones tomadas en hilos de discusión',
	'lqt-log-action-move' => 'movido [[$1]] de [[$2]] a [[$3]].',
	'lqt-log-action-split' => "Dividir [[$1]] a partir de [[$3]], con el nuevo asunto ''$2''",
	'lqt-log-action-merge-across' => 'se movió [[$1]] desde [[$2]] a [[$3]]',
	'lqt-log-action-merge-down' => 'fusionado [[$1]] con lo que está debajo de [[$3]]',
	'lqt-log-action-subjectedit' => 'se ha cambiado el asunto de [[$1]] de "$2" a "$3"',
	'lqt-log-action-resort' => 'se modificó el orden de [[$1]]. La clave de ordenamiento cambió de $2 a $3',
	'lqt-preference-notify-talk' => 'Enviarme un correo electrónico cuando haya respuestas a un hilo que estoy vigilando',
	'lqt-preference-watch-threads' => 'Vigilar hilos que he creado o respondido',
	'prefs-lqt' => 'Discusión en hilo',
	'lqt-preference-display-depth' => 'Profundidad de respuesta máxima a mostrar:',
	'lqt-preference-display-count' => 'Número máximo de respuestas a mostrar:',
	'lqt-preference-custom-signatures' => 'Mostrar firmas de usuario personalizadas',
	'lqt-enotif-subject-reply' => '{{SITENAME}} discusión - Respuesta: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} discusión - Nuevo hilo: $1',
	'lqt-enotif-newthread' => "Hola $1, 

esta es una notificación de {{SITENAME}} de que un nuevo hilo en $5, '$2',
ha sido creado el $3 a las $4 por $8.

Puede verlo en <$6>

El texto es:
$7",
	'lqt-enotif-reply' => "Hola $1,

Esta es una notificación de {{SITENAME}}. Se ha creado una nueva respuesta a '$2' en $5,
 el $3 a las $4 por $8.

Puedes verla en <$6>

El texto de la respuesta es:
$7",
	'lqt-quote-intro' => 'El día $2 a las $3, [[User:$1|$1]] escribió:',
	'lqt-quote' => 'Citar',
	'lqt-search-legend' => 'Discusiones de búsqueda en esta página',
	'lqt-search-label' => 'Términos de búsqueda:',
	'lqt-search-button' => 'Buscar',
	'searchprofile-threads' => 'Discusiones',
	'searchprofile-threads-tooltip' => 'Buscar discusiones en hilo y páginas de discusión',
	'lqt-ajax-updated' => 'Este hilo tiene nuevos mensajes.',
	'lqt-ajax-update-link' => 'Actualizar',
	'lqt-thread-show-replies' => 'Mostrar $1 respuestas',
	'lqt-thread-show-more' => 'Mostrar más respuestas',
	'lqt-thread-link-url' => 'Enlazar URL:',
	'lqt-thread-link-title' => 'Enlace Wikitexto:',
	'lqt-thread-link-copy' => 'Copiar al portapapeles',
	'lqt-sign-not-necessary' => 'No es necesario firmar tu mensaje con cuatro tildes.
La firma es mostrada automaticamente.',
	'lqt-marked-as-read-placeholder' => 'El hilo $1 se ha marcado como leído.',
	'lqt-change-subject' => 'Cambiar tema',
	'lqt-save-subject' => 'Guardar',
	'lqt-save-subject-failed' => 'Ha ocurrido el siguiente error al intentar cambiar el asunto de este hilo: $1',
	'lqt-ajax-invalid-subject' => 'El asunto que ha especificado era inválido, probablemente debido a que era demasiado largo.',
	'lqt-ajax-no-subject' => 'Debes especificar un tema para el nuevo hilo.',
	'lqt-save-subject-error-unknown' => 'Un error desconocido ocurrió cuando se intentó establecer el asunto de este hilo. Por favor intenta nuevamente haciendo clic en «editar» en el mensaje superior.',
	'lqt-cancel-subject-edit' => 'Cancelar',
	'lqt-drag-activate' => 'Arrastrar a nueva ubicación',
	'lqt-drag-drop-zone' => 'Soltar aquí',
	'lqt-drag-confirm' => 'Para completar las siguientes acciones, introduce un motivo y haz clic en «Confirmar».',
	'lqt-drag-reparent' => 'Mover el mensaje hasta debajo de un nuevo padre.',
	'lqt-drag-split' => 'Mover este mensaje a su propio hilo',
	'lqt-drag-setsortkey' => 'Ajustar la posición del mensaje en la página',
	'lqt-drag-bump' => 'Subir el mensaje al primer lugar de la página de discusión',
	'lqt-drag-save' => 'Confirmar',
	'lqt-drag-title' => 'Confirmar arrastre',
	'lqt-drag-reason' => 'Razón:',
	'lqt-drag-subject' => 'Asunto para el nuevo hilo (obligatorio):',
	'lqt-edit-signature' => '(editar firma)',
	'lqt-preview-signature' => '(previsualizar)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nuevos mensajes',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nuevos mensajes de $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nuevos hilos',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nuevos hilos de $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Respuestas',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Respuestas de $1',
	'lqt-feed-new-thread-intro' => 'Nuevo hilo en $1 enviado por $2',
	'lqt-feed-reply-intro' => 'Respuesta a $3 (en $1) enviado por $2',
	'tooltip-pt-newmessages' => 'Muestra los mensajes nuevos publicados en hilos o en páginas de discusión que estás vigilando',
	'lqt-newmessages-n' => 'Nuevos mensajes ($1)',
	'lqt_newmessages' => 'Mis mensajes nuevos (ninguno)',
	'lqt_newmessages-title' => 'Nuevos mensajes',
	'lqt-newpost-summary' => 'Nuevo hilo: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Introduzca el texto para este hilo. A continuación, elimina esta línea.',
	'lqt-reply-summary' => 'Respuesta a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historial de la página de discusión',
	'lqt-talkpage-history-subtitle' => 'Para $1',
	'lqt-talkpage-history-tab' => 'Encabezado',
	'restriction-reply' => 'Añadir respuestas',
	'restriction-newthread' => 'Añadir nuevos hilos',
	'lqt-protected-reply-thread' => 'No puedes publicar en este hilo porque está protegido contra nuevos mensajes.',
	'lqt-protected-reply-talkpage' => 'No puedes publicar en este hilo poruqe la página de discusión ha sido protegida de respuestas a sus hilos.',
	'lqt-protected-newthread' => 'No puedes publicar nuevos hilos en esta página de discusión porque ha sido protegida de nuevos hilos.',
	'lqt-edit-bump' => 'Obviar este hilo',
	'lqt-edit-bump-tooltip' => 'Mover este hilo hasta la parte superior de su página de discusión',
	'lqt-historicalrevision-error' => 'La revisión que ha solicitado está dañada y no puede ser vista.',
	'lqt-reply-subpage' => 'responder',
	'nstab-thread' => 'Hilo',
	'nstab-summary' => 'Resumen',
);

/** Estonian (Eesti)
 * @author Avjoska
 * @author Pikne
 */
$messages['et'] = array(
	'lqt-desc' => 'Võimaldab aruteluleheküljele lõimarutelu lisada.',
	'lqt_movethread' => 'Teisalda lõim teisele leheküljele',
	'lqt_deletethread' => 'Kustuta või taasta lõim',
	'lqt_contents_title' => 'Sisukord',
	'lqt_toc_thread_title' => 'Lõime pealkiri',
	'lqt_toc_thread_replycount' => 'Vastuseid',
	'lqt_toc_thread_modified' => 'Viimati muudetud',
	'lqt_add_header' => 'Lisa päis',
	'lqt_new_thread' => 'Alusta uut arutelu',
	'lqt_invalid_subject' => 'Sisestatud teema on vigane.
See võib olla:
* Liiga pikk
* Vastuolus interviki eesliidetega või nimeruuminimedega',
	'lqt_empty_subject' => 'Pead teema sisestama.',
	'lqt_reply' => 'Vasta',
	'lqt-parent' => 'Emalõim',
	'lqt_delete' => 'Kustuta',
	'lqt_undelete' => 'Taasta',
	'lqt_permalink' => 'Link',
	'lqt_fragment' => '{{ucfirst:$1}} katke leheküljelt $2',
	'lqt_discussion_link' => 'Arutelu',
	'lqt_from_talk' => 'Leheküljelt $1',
	'lqt-history-title' => 'Lõime ajalugu',
	'lqt_hist_comment_edited' => 'Kommentaar [$2 muudetud]',
	'lqt_hist_summary_changed' => 'Kokkuvõte muudetud',
	'lqt_hist_reply_created' => 'Loodud [[$1|uus vastus]]',
	'lqt_hist_thread_created' => 'Loodud uus lõim',
	'lqt_hist_deleted' => 'Kustutatud',
	'lqt_hist_undeleted' => 'Taastatud',
	'lqt_hist_moved_talkpage' => 'Teisaldatud',
	'lqt_hist_listing_subtitle' => 'Ajaloo loetelu vaatamine',
	'lqt_hist_view_whole_thread' => 'Vaata kogu lõime ajalugu',
	'lqt_hist_no_revisions_error' => 'Lõimel puudub redaktsiooniajalugu.',
	'lqt_hist_tooltip_newer_disabled' => 'See link on keelatud, sest oled esimesel leheküljel.',
	'lqt_hist_tooltip_older_disabled' => 'See link on keelatud, sest oled viimasel leheküljel.',
	'lqt_hist_edited_subject' => 'Teema "$2" muudetud kujule "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Muudetud teema',
	'lqt_revision_as_of' => 'Redaktsioon seisuga $2, kell $3.',
	'lqt_change_new_thread' => 'See on lõime esimene redaktsioon.',
	'lqt_change_reply_created' => '[$1 Esiletõstetud kommentaar] loodi selle redaktsiooniga.',
	'lqt_change_edited_root' => '[$1 Esiletõstetud kommentaar] muudeti selle redaktsiooniga.',
	'lqt_change_edited_summary' => 'Lõime kokkuvõtet muudeti.',
	'lqt_change_deleted' => '[$1 See lõim] või selle ülemlõim kustutati.',
	'lqt_change_undeleted' => '[$1 Esiletõstetud postitus] taastati.',
	'lqt_change_moved' => '[$1 See lõim] teisaldati teisele aruteluleheküljele.',
	'lqt_change_split' => '[$1 See lõim] lahutati teisest lõimest.',
	'lqt_change_edited_subject' => 'Lõime teema "$2" muudeti kujule "$3"',
	'lqt_change_merged_from' => 'Selle lõime [$1 vastus] teisaldati teise lõime.',
	'lqt_change_merged_to' => '[$1 Esiletõstetud vastus] teisaldati teisest lõimest.',
	'lqt_change_split_from' => 'Selle lõime [$1 alamlõim] lahutati omaette lõimeks.',
	'lqt_change_root_blanked' => '[$1 Kommentaari] tekst eemaldati.',
	'lqt_youhavenewmessages' => 'Sul on [[$1|uusi sõnumeid]].',
	'lqt_protectedfromreply' => 'See lõim on vastamise eest $1.',
	'lqt_protectedfromreply_link' => 'kaitstud',
	'lqt_subject' => 'Teema:',
	'lqt_noreason' => 'Põhjust pole antud.',
	'lqt_move_placeholder' => 'See lõim on kohatäide, mis viitab sellele, et lõim $1 teisaldati sellelt leheküljelt. Teisaldas $2 kuupäeval $3, kell $4. Lõim asub nüüd leheküljel $5.',
	'lqt_thread_deleted_for_sysops' => "See lõim on '''kustutatud''' ja on nähtav ainult ülematele.",
	'lqt_thread_deleted' => 'See lõim on kustutatud.',
	'lqt_summary_notice' => 'Seda arutelu pole vähemalt {{PLURAL:$2|päeva|$2 päeva}} jooksul muudetud.
Kui see on lõpule jõudnud, võid tahta $1.',
	'lqt_summary_notice_link' => 'kokkuvõtte kirjutada',
	'lqt_summary_label' => 'Lõime kokkuvõte:',
	'lqt_summary_subtitle' => 'Lõime "$1" kokkuvõte',
	'lqt_nosuchrevision' => 'Lõime sellist redaktsiooni pole.',
	'lqt_nosuchthread' => 'Määratud lõime pole.',
	'lqt_nosuchthread_title' => 'Lõime ei leidu',
	'lqt_threadrequired' => 'Pead internetiaadressis lõime määrama.',
	'lqt_move_movingthread' => 'Lõime $1 teisaldamine.
See lõim on osa leheküljest $2.',
	'lqt_move_torename' => "Lõime ümbernimetamiseks $1 ja muuda väli 'Teema'.",
	'lqt_move_torename_edit' => 'redigeeri seda',
	'lqt_move_destinationtitle' => 'Arutelulehekülje pealkiri:',
	'lqt_move_move' => 'Teisalda',
	'lqt_move_nodestination' => 'Pead sihtkoha määrama.',
	'lqt_move_thread_bad_destination' => 'Sihtlehekülg pole arutelulehekülg.',
	'lqt_move_samedestination' => 'Lõim on juba sellel leheküljel!',
	'lqt_move_noreason' => 'Põhjust pole antud.',
	'lqt_move_success' => 'Lõim teisaldati asukohta $1.',
	'lqt_delete_partof' => "See lõim on osa leheküljest '''$1'''.",
	'lqt_delete_deleted' => 'Lõim kustutati.',
	'lqt_delete_undeleted' => 'Lõim taastati.',
	'lqt_delete_return' => 'Naase $1.',
	'lqt_delete_return_link' => 'aruteluleheküljele',
	'lqt_delete_unallowed' => 'Sul pole lubatud lõimi kustutada.',
	'lqt_delete_show_checkbox' => 'Näita kustutatud lõimi',
	'lqt_talkpage_autocreate_summary' => 'Arutelulehekülg loodi automaatselt esimese lõime postitamisega.',
	'lqt_header_warning_big' => 'Muudad $1.',
	'lqt_header_warning_after_big' => 'Päised on teadaannete ja saatesõnade jaoks. Võid tahta hoopis $2.',
	'lqt_header_warning_bold' => 'arutelulehekülje päist',
	'lqt_header_warning_new_discussion' => 'uut arutelu alustada',
	'lqt_sorting_order' => 'Järjestusalus:',
	'lqt_sort_newest_changes' => 'kõigepealt viimati muudetu',
	'lqt_sort_newest_threads' => 'kõigepealt uuemad lõimed',
	'lqt_sort_oldest_threads' => 'kõigepealt vanemad lõimed',
	'lqt-title' => 'Pealkiri',
	'lqt-summary' => 'Kokkuvõte',
	'lqt-searching' => 'Lõimede otsimine',
	'lqt-read-message' => 'Märgi loetuks',
	'lqt-read-message-tooltip' => 'Eemalda see lõim uutest sõnumitest.
Oma algupärasel aruteluleheküljel on ta endiselt nähtav.',
	'lqt-read-all' => 'Märgi kõik loetuks',
	'lqt-read-all-tooltip' => 'Eemalda kõik lõimed uutest sõnumitest.
Oma algupärastel arutelulehekülgedel on nad endiselt nähtavad.
Seda toimingut ei saa tagasi võtta.',
	'lqt-marked-read' => "Lõim '''$1''' on loetuks märgitud.",
	'lqt-count-marked-read' => '{{PLURAL:$1|Üks sõnum|$1 sõnumit}} on loetuks märgitud.',
	'lqt-email-undo' => 'Võta tagasi',
	'lqt-no-new-messages' => 'Sulle pole uusi sõnumeid.',
	'lqt-new-messages' => '✒ Sulle on uusi sõnumeid.',
	'lqt-email-info-undo' => 'Too eemaldatud lõim tagasi.',
	'lqt-newmessages-context' => 'Kogu lõim',
	'lqt-thread-created' => 'Loodud',
	'lqt-history-time' => 'Aeg',
	'lqt-history-user' => 'Kasutaja',
	'lqt-history-action' => 'Tegevus',
	'lqt-history-comment' => 'Märkus',
	'lqt-history-thread' => 'Lõim',
	'lqt-thread-edited-author' => 'Autori muudetud.<br />
Viimane muudatus: $1',
	'lqt-thread-edited-others' => '{{PLURAL:$2|Teise|$2 teise}} kasutaja muudetud.<br />
Viimane muudatus: $1',
	'lqt_summarize_link' => 'Võta kokku',
	'lqt-summarize-intro' => 'Palun võta allpool toodud lõim toimetamiskastis kokku.
Võid oma kokkuvõttes vikiteksti kasutada. Kui oled lõpetanud, klõpsa nuppu "{{int:savearticle}}".',
	'lqt-thread-split' => 'Lahuta uueks lõimeks',
	'lqt-split-success' => 'Oled edukalt lahutanud lõime $1.',
	'lqt_split_thread' => 'Lõime jagamine',
	'lqt-thread-split-subject' => 'Uue lõime teema:',
	'lqt-thread-split-thread' => 'Lõim:',
	'lqt-split-submit' => 'Lahuta',
	'lqt_split_badsubject' => 'Sisestatud teema on vigane.',
	'lqt-no-threads' => 'Leheküljel pole veel lõimi.',
	'lqt-delete-parent-warning' => 'Selle kõrgema tasema lõime juurde kuuluvad ka vastused.
Vastused kustutatakse samuti automaatselt.
Selle vältimiseks lahuta vastused enne kustutamist sellest lõimest.',
	'lqt-delete-parent-deleted' => 'Ülemlõim kustutatud ($1)',
	'lqt-delete-replies-done' => 'Kõik vastused sellele lõimele on samuti kustutatud.',
	'lqt-movethread' => 'Teisalda',
	'lqt-menu-trigger' => 'Veel',
	'lqt-newmessages-from' => 'Leheküljelt $1',
	'lqt-hot-topics' => 'Kuumad teemad',
	'lqt-add-reply' => 'Lisa vastus',
	'lqt_rc_new_discussion' => 'postitas uue lõime "$1"',
	'lqt_rc_new_reply' => 'postitas vastuse lõimele "$1"',
	'right-lqt-split' => 'Lahutada lõimi',
	'right-lqt-merge' => 'Liita lõimi',
	'lqt-thread-merge' => 'Liida teise lõimega',
	'lqt-thread-merge-to' => 'Liida selle lõimega',
	'lqt-thread-merge-source' => 'Lähtelõim:',
	'lqt-thread-merge-dest' => 'Sihtlõim:',
	'lqt-merge-submit' => 'Liida',
	'lqt-merge-success' => 'Oled lõime $1 edukalt lõimega $2 liitnud.',
	'lqt-log-name' => 'Lõimarutelulogi',
	'lqt-log-header' => 'See logi toob üksikasjalikult ära lõimaruteludes sooritatud toiminguid.',
	'lqt-log-action-move' => 'teisaldas lõime [[$1]] leheküljelt [[$2]] leheküljele [[$3]].',
	'lqt-log-action-subjectedit' => 'muutis lõime [[$1]] pealkirja "$2" kujule "$3"',
	'lqt-preference-notify-talk' => 'Teata e-posti teel vastusest minu jälgitavale lõimele',
	'lqt-preference-watch-threads' => 'Jälgi minu loodud või minu vastusega lõimi',
	'prefs-lqt' => 'Lõimarutelu',
	'lqt-preference-display-count' => 'Näidatavate vastuste ülemmäär:',
	'lqt-preference-custom-signatures' => 'Näita kasutajate kohandatud allkirju',
	'lqt-enotif-subject-reply' => '{{SITENAME}} – Vastus lõimele $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} – Uus lõim: $1',
	'lqt-enotif-newthread' => 'Tere, $1!

Selle kirjaga teatatakse võrgukohast {{SITENAME}}, et kasutaja $8 lõi kuupäeval $3, kell $4 aruteluleheküljel „$5“ lõime „$2“.

See on leitav asukohast <$6>.

Sõnum on järgmine:
$7',
	'lqt-enotif-reply' => 'Tere, $1!

Selle kirjaga teatatakse {{GRAMMAR:elative|{{SITENAME}}}}, et kasutaja $8 lisas kuupäeval $3, kell $4 aruteluleheküljel „$5“ lõimele „$2“ uue vastuse.

See on leitav asukohast <$6>.

Vastus on järgmine:
$7',
	'lqt-quote-intro' => 'Kuupäeval $2, kell $3 kirjutas [[User:$1|$1]]:',
	'lqt-quote' => 'Tsiteeri',
	'lqt-search-label' => 'Otsitav:',
	'lqt-search-button' => 'Otsi',
	'searchprofile-threads' => 'Arutelud',
	'searchprofile-threads-tooltip' => 'Otsi lõimaruteludest ja arutelulehekülgedelt',
	'lqt-ajax-updated' => 'Selles lõimes on uued postitused.',
	'lqt-ajax-update-link' => 'Värskenda',
	'lqt-thread-show-replies' => 'Näita {{PLURAL:$1|ühte vastust|$1 vastust}}',
	'lqt-thread-show-more' => 'Näita veel vastuseid',
	'lqt-thread-link-url' => 'Internetiaadress:',
	'lqt-thread-link-title' => 'Vikilink:',
	'lqt-thread-link-copy' => 'Kopeeri lõikelauale',
	'lqt-sign-not-necessary' => 'Postitusele nelja tildega allakirjutamine pole vajalik.
Allkiri kuvatakse iseenesest.',
	'lqt-marked-as-read-placeholder' => 'Lõim $1 märgiti loetuks.',
	'lqt-change-subject' => 'Muuda teemat',
	'lqt-save-subject' => 'Salvesta',
	'lqt-save-subject-failed' => 'Selle lõime teema muutmisel ilmnes järgnev tõrge: $1',
	'lqt-ajax-invalid-subject' => 'Soovitud teema oli vigane. Oletatavasti oli see liiga pikk.',
	'lqt-ajax-no-subject' => 'Pead uue lõime teema määrama.',
	'lqt-save-subject-error-unknown' => 'Selle lõime teema muutmisel ilmnes tundmatu tõrge. Võimalik, et saad teemat muuta, kui klõpsad esimese postituse juures "Redigeeri".',
	'lqt-cancel-subject-edit' => 'Loobu',
	'lqt-drag-activate' => 'Lohista uude asukohta',
	'lqt-drag-drop-zone' => 'Lohista siia',
	'lqt-drag-confirm' => 'Järgmiste toimingute lõpuleviimiseks täida põhjuse väli ja klõpsa "Kinnita".',
	'lqt-drag-reparent' => 'Postituse teisaldamine uue emalõime alla.',
	'lqt-drag-split' => 'Postituse teisaldamine eraldi lõime.',
	'lqt-drag-setsortkey' => 'Postituse asukoha muutmine leheküljel.',
	'lqt-drag-bump' => 'Postituse teisaldamine arutelulehekülje algusesse.',
	'lqt-drag-save' => 'Kinnita',
	'lqt-drag-reason' => 'Põhjus:',
	'lqt-drag-subject' => 'Uue lõime teema:',
	'lqt-edit-signature' => '(redigeeri allkirja)',
	'lqt-preview-signature' => '(eelvaade)',
	'lqt-feed-title-all' => '{{SITENAME}} – Uued postitused',
	'lqt-feed-title-all-from' => '{{SITENAME}} – Uued postitused {{PLURAL:$2|leheküljel|lehekülgedel}} $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – Uued lõimed',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – Uued lõimed {{PLURAL:$2|leheküljel|lehekülgedel}} $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – Vastused',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – Uued vastused {{PLURAL:$2|leheküljel|lehekülgedel}} $1',
	'lqt-feed-new-thread-intro' => 'Uus lõim leheküljel $1, mille postitas $2',
	'lqt-feed-reply-intro' => 'Vastus lõimele „$3“ (leheküljel „$1“). Postitaja: $2',
	'lqt-newmessages-n' => 'Uued sõnumid ($1)',
	'lqt_newmessages' => 'Uued sõnumid (0)',
	'lqt_newmessages-title' => 'Uued sõnumid',
	'lqt-newpost-summary' => 'Uus lõim: $1',
	'lqt-reply-summary' => 'Vastus lõimele [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Arutelulehekülje ajalugu',
	'lqt-talkpage-history-subtitle' => 'Leheküljele $1',
	'lqt-talkpage-history-tab' => 'Päis',
	'lqt-protected-reply-thread' => 'Sellesse lõime ei saa postitada, sest see on uute postituste eest kaitstud.',
	'lqt-protected-reply-talkpage' => 'Sellesse lõime ei saa postitada, sest selle arutelulehekülje lõimed on vastuste eest kaitstud.',
	'lqt-protected-newthread' => 'Sellele aruteluleheküljele ei saa uusi lõimi postitada, sest see on uute lõimede eest kaitstud.',
	'lqt-edit-bump' => 'Too lõim ette',
	'lqt-edit-bump-tooltip' => 'Liiguta see lõim arutelulehekülje algusesse',
	'lqt-historicalrevision-error' => 'Sinu valitud redaktsioon rikutud ja seda ei saa vaadata.',
	'lqt-reply-subpage' => 'vasta',
	'nstab-thread' => 'Lõim',
	'nstab-summary' => 'Kokkuvõte',
);

/** Basque (Euskara)
 * @author An13sa
 * @author Joxemai
 * @author Kobazulo
 */
$messages['eu'] = array(
	'lqt_movethread' => 'Mintzagaia beste orrialde batera mugitu',
	'lqt_contents_title' => 'Edukiak',
	'lqt_toc_thread_title' => 'Eztabaidaren izenburua',
	'lqt_toc_thread_author' => 'Nork hasi duen',
	'lqt_toc_thread_replycount' => 'Erantzunak',
	'lqt_toc_thread_modified' => 'Azken aldaketa',
	'lqt_add_header' => 'Goiburua gehitu',
	'lqt_new_thread' => 'Eztabaida berria hasi',
	'lqt_reply' => 'Erantzun',
	'lqt-parent' => 'Gurasoa',
	'lqt_delete' => 'Ezabatu',
	'lqt_undelete' => 'Berreskuratu',
	'lqt_permalink' => 'Lotu',
	'lqt_discussion_link' => 'eztabaida',
	'lqt-history-title' => 'Eztabaidaren historia',
	'lqt_hist_summary_changed' => 'Laburpena aldatua',
	'lqt_hist_thread_created' => 'Mintzagai berria sortua',
	'lqt_hist_deleted' => 'Ezabatua',
	'lqt_hist_undeleted' => 'Ezabatu gabea',
	'lqt_hist_moved_talkpage' => 'Mugitua',
	'lqt_hist_edited_subject_corrupt' => 'Gaia aldatua',
	'lqt_youhavenewmessages' => '[[$1|Mezu berriak]] dituzu.',
	'lqt_protectedfromreply_link' => 'babestua',
	'lqt_subject' => 'Gaia:',
	'lqt_noreason' => 'Arrazoirik eman gabe.',
	'lqt_summary_notice_link' => 'laburpena idatzi',
	'lqt_summary_label' => 'Mintzagaiaren laburpena:',
	'lqt_move_movingthread' => '$1 mugitzen.
Eztabaida hau $2-(e)ko zati da.',
	'lqt_move_torename_edit' => 'editatu',
	'lqt_move_move' => 'Mugitu',
	'lqt_move_noreason' => 'Ez da arrazoirik zehaztu.',
	'lqt_delete_return' => '$1-(e)ra itzuli.',
	'lqt_delete_return_link' => 'eztabaida orria',
	'lqt_header_warning_big' => '$1 editatzen ari zara.',
	'lqt_header_warning_new_discussion' => 'Eztabaida berria hasi',
	'lqt_sorting_order' => 'Sailkapenerako irizpidea:',
	'lqt_sort_newest_changes' => 'azken aldaketa lehendabizi',
	'lqt_sort_newest_threads' => 'mintzagai berrienak lehenik',
	'lqt_sort_oldest_threads' => 'mintzagai zaharrenak lehenik',
	'lqt-title' => 'Izenburua',
	'lqt-summary' => 'Laburpena',
	'lqt-read-message' => 'Irakurrita moduan adierazi',
	'lqt-read-all' => 'Markatu irakurrita gisa',
	'lqt-count-marked-read' => '{{PLURAL:$1|mezu bat|$1 mezu}} markatuak irakurrita gisa.',
	'lqt-email-undo' => 'Desegin',
	'lqt-no-new-messages' => 'Ez dago zuretzako mezu berririk.',
	'lqt-new-messages' => '✒ Zuretzako mezu berriak daude.',
	'lqt-newmessages-context' => 'Mintzagai osoa',
	'lqt-thread-created' => 'Sortua',
	'lqt-history-time' => 'Ordua',
	'lqt-history-user' => 'Erabiltzailea',
	'lqt-history-action' => 'Jarduera',
	'lqt-history-comment' => 'Iruzkina',
	'lqt-history-thread' => 'Mintzagaia',
	'lqt-header-actions' => 'Ekintzak',
	'lqt_summarize_link' => 'Laburtu',
	'lqt-thread-split-thread' => 'Eztabaida:',
	'lqt-no-threads' => 'Ez dago eztabaidarik oraingoz orri honetan.',
	'lqt-movethread' => 'Mugitu',
	'lqt-menu-trigger' => 'Gehiago',
	'lqt-hot-topics' => 'Gai garrantzitsuak',
	'lqt-add-reply' => 'Erantzuna gehitu',
	'lqt-merge-submit' => 'Merge',
	'lqt-enotif-subject-reply' => '{{SITENAME}} eztabaida - Erantzuna: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} eztabaida - Mintzagai berria: $1',
	'lqt-quote' => 'Aipu',
	'lqt-search-button' => 'Bilatu',
	'searchprofile-threads' => 'Eztabaidak',
	'lqt-ajax-update-link' => 'Eguneratu',
	'lqt-thread-show-replies' => 'Erakutsi {{PLURAL:$1|erantzun bat|$1 erantzun}}',
	'lqt-thread-link-url' => 'URL lotura:',
	'lqt-thread-link-title' => 'Wikitestu lotura:',
	'lqt-change-subject' => 'Gaia aldatua',
	'lqt-save-subject' => 'Gorde',
	'lqt-cancel-subject-edit' => 'Utzi',
	'lqt-drag-save' => 'Baieztatu',
	'lqt-drag-reason' => 'Arrazoia:',
	'lqt-edit-signature' => '(sinadura aldatu)',
	'lqt-preview-signature' => '(aurrikuspena)',
	'lqt-feed-title-all' => '{{SITENAME}} — Mezu berriak',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Mezu beriak $1- (r)engandik',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Eztabaida berriak',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Eztabaida berriak $1 - (r)engandik',
	'lqt-feed-title-replies' => '{{SITENAME}} — Erantzunak',
	'lqt-newmessages-n' => 'Mezu berriak ($1)',
	'lqt_newmessages' => 'Mezu berriak',
	'lqt_newmessages-title' => 'Mezu berriak',
	'lqt-newpost-summary' => 'Mintzagai berria: $1',
	'lqt-talkpage-history-tab' => 'Goiburua',
	'lqt-reply-subpage' => 'erantzun',
	'nstab-summary' => 'Laburpena',
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Huji
 * @author Ladsgroup
 * @author Mjbmr
 * @author Sahim
 * @author Wayiran
 */
$messages['fa'] = array(
	'lqt-desc' => 'افزودن بحث‌های تاپیکی به صفحات بحث',
	'lqt_movethread' => 'انتقال مبحث به صفحه‌ای دیگر',
	'lqt_deletethread' => 'حذف یا احیای مبحث',
	'lqt_contents_title' => 'محتویات',
	'lqt_toc_thread_title' => 'عنوان موضوع',
	'lqt_toc_thread_author' => 'شروع توسط',
	'lqt_toc_thread_replycount' => 'پاسخ‌ها',
	'lqt_toc_thread_modified' => 'آخرین تغییر',
	'lqt_add_header' => 'افزودن هدر',
	'lqt_new_thread' => 'آغاز یک بحث جدید',
	'lqt_invalid_subject' => 'عنوانی که وارد کردید نامعتبر است.
ممکن است:
*خیلی طولانی باشد، یا
*با پیشوندهای میان‌ویکی یا نام‌های فضای نام ناسازگار باشد.',
	'lqt_empty_subject' => 'باید یک عنوان وارد کنید.',
	'lqt_reply' => 'پاسخ',
	'lqt-parent' => 'ریشه',
	'lqt_delete' => 'حذف',
	'lqt_undelete' => 'احیا',
	'lqt_permalink' => 'پیوند به',
	'lqt_fragment' => 'قطعه‌ای از یک $1 از $2',
	'lqt_discussion_link' => 'بحث',
	'lqt_from_talk' => 'از $1',
	'lqt-history-title' => 'تاریخچهٔ موضوع',
	'lqt_hist_comment_edited' => 'متن نظر [$2 ویرایش شد]',
	'lqt_hist_summary_changed' => 'خلاصه تغییر کرد',
	'lqt_hist_reply_created' => '[[$1|پاسخ جدید]] ایجاد شد',
	'lqt_hist_thread_created' => 'مبحث جدید ایجاد شد',
	'lqt_hist_deleted' => 'حذف شده',
	'lqt_hist_undeleted' => 'حذف نشده',
	'lqt_hist_moved_talkpage' => 'منتقل شده',
	'lqt_hist_listing_subtitle' => 'مشاهده یک فهرست تاریخچه',
	'lqt_hist_view_whole_thread' => 'مشاهدهٔ تاریخچهٔ کل مبحث',
	'lqt_hist_no_revisions_error' => 'این مبحث هیچ نسخه‌ای در تاریخچه ندارد.',
	'lqt_hist_past_last_page_error' => 'شما فراتر از تعداد صفحات تاریخچه که وجود دارند هستید.',
	'lqt_hist_tooltip_newer_disabled' => 'به این دلیل که شما در صفحهٔ اول هستید این پیوند غیرفعال شده است.',
	'lqt_hist_tooltip_older_disabled' => 'به این دلیل که شما در صفحهٔ آخر هستید این پیوند غیرفعال شده است.',
	'lqt_hist_split' => 'تقسیم پاسخ به یک مبحث جدید',
	'lqt_hist_edited_subject' => 'موضوع تغییریافته از «$2» به «$3»',
	'lqt_hist_edited_subject_corrupt' => 'موضوع تغییریافته',
	'lqt_hist_merged_from' => '[[$1|پاسخ]] به مبحث دیگری منتقل شد',
	'lqt_hist_merged_to' => '[[$1|پاسخ]] از مبحث دیگری منتقل شد',
	'lqt_hist_split_from' => 'تقسیم به یک موضوع جدید',
	'lqt_hist_root_blanked' => 'متن نظر حذف‌شده',
	'lqt_hist_adjusted_sortkey' => 'تنظیم موقعیت مبحث',
	'lqt_revision_as_of' => 'نسخهٔ تاریخ $2 در زمان $3',
	'lqt_change_new_thread' => 'این نسخهٔ اولیهٔ مبحث است.',
	'lqt_change_reply_created' => '[$1 این نظر پررنگ‌شده] در این نسخه ایجاد شده است.',
	'lqt_change_edited_root' => '[$1 این نظر پررنگ‌شده] در این نسخه ویرایش شده است.',
	'lqt_change_edited_summary' => 'خلاصهٔ مبحث ویرایش شد.',
	'lqt_change_deleted' => '[$1 این مبحث] یا مبحث مادرش حذف شدند',
	'lqt_change_undeleted' => '[$1 این پست پررنگ‌شده] احیا شد.',
	'lqt_change_moved' => '[$1 این مبحث] به صفحهٔ بحث دیگری منتقل شد',
	'lqt_change_split' => '[$1 این مبحث] از مبحث دیگری تقسیم و جدا شد',
	'lqt_change_edited_subject' => 'موضوع این مبحث از «$2» به «$3» تغییر یافته است',
	'lqt_change_merged_from' => '[$1 پاسخی] از این مبحث به مبحث دیگری منتقل شد',
	'lqt_change_merged_to' => '[$1 این پاسخ پررنگ‌شده] از مبحث دیگری منتقل شده است',
	'lqt_change_split_from' => 'یک [$1 زیرمبحث] از این مبحث، به مبحث مجزایی تقسیم شد',
	'lqt_change_root_blanked' => 'متن [$1 یک نظر] حذف شد.',
	'lqt_youhavenewmessages' => 'شما [[$1|پیام‌های جدیدی]] دارید.',
	'lqt_protectedfromreply' => 'این مبحث از پاسخ‌داده شدن $1 شده است.',
	'lqt_protectedfromreply_link' => 'محافظت‌شده',
	'lqt_subject' => 'موضوع:',
	'lqt_noreason' => 'دلیلی مشخص نشده‌است.',
	'lqt_move_placeholder' => 'یک تاپیک، $1، از اینجا به $5 منتقل شد.
این انتقال توسط $2 در تاریخ $3 در ساعت $4 صورت گرفت.',
	'lqt_thread_deleted_for_sysops' => "این مبحث '''حذف''' شده‌است و تنها برای مدیران قابل مشاهده هستند.",
	'lqt_thread_deleted' => 'این مبحث حذف شده است.',
	'lqt_summary_notice' => 'برای حداقل $2 روز، هیچ تغییری در این بحث صورت نگرفته است.
اگر اینطور نتیجه‌گیری شده، شاید بخواهید $1.',
	'lqt_summary_notice_link' => 'یک خلاصه بنویس',
	'lqt_summary_label' => 'خلاصهٔ مبحث:',
	'lqt_summary_subtitle' => 'خلاصهٔ «$1»',
	'lqt_nosuchrevision' => 'اینچنین نسخه‌ای از این مبحث وجود ندارد.',
	'lqt_nosuchthread' => 'تاپیکی که مشخص کردید وجود ندارد.',
	'lqt_nosuchthread_title' => 'اینچنین تاپیکی نه',
	'lqt_threadrequired' => 'باید یک مبحث را در نشانی مشخص کنید.',
	'lqt_move_movingthread' => 'انتقال $1.
این مبحث بخشی از $2 است.',
	'lqt_move_torename' => "برای تغییر نام این تاپیک، $1 و تغییر 'عنوان'.",
	'lqt_move_torename_edit' => 'ویرایشش کنید',
	'lqt_move_destinationtitle' => 'عنوان صفحهٔ بحث مقصد',
	'lqt_move_move' => 'انتقال',
	'lqt_move_nodestination' => 'شما باید یک مقصد را مشخص کنید.',
	'lqt_move_thread_bad_destination' => 'صفحهٔ مقصد یک صفحهٔ بحث نیست.',
	'lqt_move_samedestination' => 'در حال حاضر مبحث در این صفحه است!',
	'lqt_move_noreason' => 'دلیلی ذکر نشده است.',
	'lqt_move_success' => 'مبحث به $1 انتقال یافته است.',
	'lqt_delete_undeletethread' => 'احیای مبحث',
	'lqt_delete_partof' => "این مبحث بخشی از '''$1''' است.",
	'lqt_delete_deleting' => "حذف '''$1''' و '''تمام پاسخ‌ها''' به آن.",
	'lqt_delete_deletethread' => 'حذف مبحث و پاسخ‌ها',
	'lqt_delete_deleted' => 'مبحث حذف شده است.',
	'lqt_delete_undeleted' => 'مبحث احیا شده است.',
	'lqt_delete_return' => 'بازگشت به $1.',
	'lqt_delete_return_link' => 'صفحهٔ بحث',
	'lqt_delete_unallowed' => 'شما مجاز به حذف تاپیک‌ها نیستید.',
	'lqt_delete_show_checkbox' => 'نمایش تاپیک‌های حذف‌شده',
	'lqt_talkpage_autocreate_summary' => 'هنگامی که اولین مبحث فرستاده شد، صفحهٔ بحث به شکلی خودکار ایجاد شد.',
	'lqt_header_warning_big' => 'شما یک $1 را ویرایش می‌کنید.',
	'lqt_header_warning_after_big' => 'سربرگ‌ها برای اطلاعیه‌ها و دیباچه‌ها هستند.
به جای آن شاید بخواهید $2.',
	'lqt_header_warning_bold' => 'سربرگ صفحهٔ بحث',
	'lqt_header_warning_new_discussion' => 'یک بحث جدید را آغاز کنید',
	'lqt_sorting_order' => 'ترتیب مرتب‌سازی:',
	'lqt_sort_newest_changes' => 'آخرین، اول تغییر کرد',
	'lqt_sort_newest_threads' => 'نخست جدیدترین تاپیک‌ها',
	'lqt_sort_oldest_threads' => 'نخست قدیمی‌ترین تاپیک‌ها',
	'lqt-title' => 'عنوان',
	'lqt-summary' => 'خلاصه',
	'lqt-searching' => 'جستجوی موضوع‌ها',
	'lqt-read-message' => 'علامت‌گذاری به عنوان خوانده‌شده',
	'lqt-read-message-tooltip' => 'این مبحث را از پیام‌های جدید حذف کن.
اما همچنان در صفحهٔ بحث اصلی قابل مشاهده است.',
	'lqt-read-all' => 'همه را به‌عنوان خوانده‌شده نشانه‌گذاری کن',
	'lqt-read-all-tooltip' => 'همهٔ تاپیک‌ها را از پیغام‌های جدید حذف کن.
اما همچنان از صفحات بحث اصلی قابل مشاهده هستند.
این عمل انجام‌ناپذیر است.',
	'lqt-marked-read' => "مبحث '''$1''' به عنوان خوانده‌شده نشانه‌گذاری شد.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|message|messages}} به‌عنوان خوانده‌شده نشانه‌گذاری شده است.',
	'lqt-email-undo' => 'خنثی‌سازی',
	'lqt-no-new-messages' => 'هیچ پیام جدیدی برای شما وجود ندارد.',
	'lqt-new-messages' => '✒ پیام‌های جدیدی برای شما وجود دارند.',
	'lqt-email-info-undo' => 'بازگرداندن تاپیکی که هم‌اکنون مختومه کردید.',
	'lqt-date-info' => 'این پیوند غیرفعال شده است، چرا که شما تاپیک‌های همهٔ تاریخ‌ها را مشاهده می‌کنید.',
	'lqt-newmessages-context' => 'موضوع کامل',
	'lqt-thread-created' => 'ساخته شد',
	'lqt-history-time' => 'زمان',
	'lqt-history-user' => 'کاربر',
	'lqt-history-action' => 'فعالیت',
	'lqt-history-comment' => 'توضیح',
	'lqt-history-thread' => 'موضوع',
	'lqt-thread-edited-author' => 'ویرایش‌شده توسط نویسنده.<br />
آخرین ویرایش: $1',
	'lqt-thread-edited-others' => 'ویرایش‌شده توسط $2 کاربر.<br />
آخرین ویرایش: $1',
	'lqt-header-actions' => 'اقدامات',
	'lqt_summarize_link' => 'خلاصه‌سازی',
	'lqt-summarize-intro' => 'لطفاً مبحث زیر را در جعبهٔ ویرایش خلاصه کنید.
در خلاصهٔ خود می‌توانید از هر متن ویکی‌ای استفاده کنید.
وقتی تمام شد، روی «{{int:savearticle}}» کلیک کنید.',
	'lqt-thread-split' => 'تقسیم به مبحث جدید',
	'lqt-split-success' => 'شما با موفقیت مبحث $1 را تقسیم کردید.',
	'lqt_split_thread' => 'تقسیم یک مبحث',
	'lqt-thread-split-subject' => 'موضوع مبحث جدید:',
	'lqt-thread-split-thread' => 'موضوع:',
	'lqt-split-submit' => 'تقسیم',
	'lqt_split_badsubject' => 'موضوعی که وارد کردید نامعتبر است.',
	'lqt-no-threads' => 'هنوز هیچ تاپیکی در این صفحه وجود ندارد.',
	'lqt-delete-parent-warning' => 'این یک مبحث سطح بالا با پاسخ‌ها می‌باشد.
پاسخ‌هایش نیز به صورت خودکار پاک می‌شوند.
برای جلوگیزی از این، تا پیش از آنکه پاک شوند آن‌ها را از این مبحث تقسیم کنید.',
	'lqt-delete-parent-deleted' => 'مبحث مادر حذف شد ($1)',
	'lqt-delete-replies-done' => 'همهٔ پاسخ‌ها به این مبحث نیز حذف شده‌اند.',
	'lqt-movethread' => 'انتقال',
	'lqt-menu-trigger' => 'انتقال',
	'lqt-newmessages-from' => 'از $1',
	'lqt-hot-topics' => 'موضوعات داغ',
	'lqt-add-reply' => 'افزودن یک پاسخ',
	'lqt_rc_new_discussion' => 'یک مبحث جدید فرستاده شد، «$1»',
	'lqt_rc_new_reply' => 'یک پاسخ به "$1" فرستاده شد',
	'right-lqt-split' => 'تقسیم تاپیک‌ها',
	'right-lqt-merge' => 'ادغام تاپیک‌ها',
	'lqt-thread-merge' => 'ادغام در یک مبحث دیگر',
	'lqt-thread-merge-to' => 'ادغام در این مبحث',
	'lqt_merge_thread' => 'ادغام مبحث',
	'lqt-thread-merge-source' => 'مبحث منبع:',
	'lqt-thread-merge-dest' => 'مبحث مقصد:',
	'lqt-merge-submit' => 'ادغام',
	'lqt-merge-success' => 'شما با موفقیت مبحث $1 را در مبحث زیرین $2 ادغام کردید.',
	'lqt-log-name' => 'سیاههٔ انتقال مبحث',
	'lqt-log-header' => 'این گزارش، جزئیات اقدامات صورت گرفته در بحث تاپیک‌ها را نمایش می‌دهد.',
	'lqt-log-action-move' => '[[$1]] را از [[$2]] به [[$3]] انتقال داد',
	'lqt-log-action-split' => '[[$1]] را از تحت [[$3]]، با عنوان جدید «$2» جدا کن',
	'lqt-log-action-merge-across' => '[[$1]] را از تحت [[$2]] به تحت [[$3]] انتقال داد',
	'lqt-log-action-merge-down' => '[[$1]] به تحت [[$3]] ادغام شد',
	'lqt-log-action-subjectedit' => 'عنوان [[$1]] از «$2» به «$3» تغییر یافت',
	'lqt-log-action-resort' => 'ترتیب مرتب‌سازی [[$1]] تغییر کرد. کلید مرتب‌سازی از $2 به $3 تغییر یافت.',
	'lqt-preference-notify-talk' => 'پاسخ مبحث‌هایی که من پی‌گیری می‌کنم را به من پست الکترونیکی بفرست',
	'lqt-preference-watch-threads' => 'تاپیک‌هایی که من می‌سازم یا پاسخ می‌دهم را دنبال کن',
	'prefs-lqt' => 'بحث تاپیک‌شده',
	'lqt-preference-display-depth' => 'حداکثر عمق پاسخ برای نمایش:',
	'lqt-preference-display-count' => 'حداکثر تعداد پاسخ برای نمایش:',
	'lqt-preference-custom-signatures' => 'امضاهای سفارشی کاربر را نمایش بده',
	'lqt-enotif-subject-reply' => 'بحث {{SITENAME}} - پاسخ: $1',
	'lqt-enotif-subject-newthread' => 'بحث {{SITENAME}} - مبحث جدید: $1',
	'lqt-enotif-newthread' => "سلام $1،

این یک اطلاعیه از {{SITENAME}} است که یک مبحث جدید در $5، '$2'، در تاریخ $3 در ساعت $4 توسط $8 ایجاد شد.

شما می‌توانید آن را در <$6> ببینید.

متن پاسخ بدین شرح است:
$7",
	'lqt-enotif-reply' => "سلام $1،
این یک اطلاعیه از سوی {{SITENAME}} است که در تاریخ $3 در ساعت $4 توسط $8، پاسخی جدید به '$2' در $5 ایجاد شده است.

شما می‌توانید آن را در <$6> ببینید.

متن پاسخ بدین شرح است:
$7",
	'lqt-quote-intro' => '[[User:$1|$1]] در تاریخ $2 در زمان $3 نوشت:',
	'lqt-quote' => 'نقل قول',
	'lqt-search-legend' => 'جستجوی بحث‌های این صفحه',
	'lqt-search-label' => 'عبارات جستجو:',
	'lqt-search-button' => 'جستجو',
	'searchprofile-threads' => 'بحث‌ها',
	'searchprofile-threads-tooltip' => 'جستجوی بحث‌های تاپیکی و صفحات بحث',
	'lqt-ajax-updated' => 'این مبحث پست‌های جدیدی دارد.',
	'lqt-ajax-update-link' => 'به‌روزرسانی',
	'lqt-thread-show-replies' => 'نمایش $1 پاسخ',
	'lqt-thread-show-more' => 'نمایش پاسخ‌های بیش‌تر',
	'lqt-thread-link-url' => 'نشانی اینترنتی پیوند:',
	'lqt-thread-link-title' => 'پیوند کد ویکی:',
	'lqt-thread-link-copy' => 'کپی به کلیپ‌بورد:',
	'lqt-sign-not-necessary' => 'لازم نیست تا پست‌های خود را با چهار علامت مدک امضا کنید.
امضا به صورت خودکار نشان داده می‌شود.',
	'lqt-marked-as-read-placeholder' => 'مبحث $1 به عنوان خوانده‌شده نشانه‌گذاری شده است.',
	'lqt-change-subject' => 'تغییر عنوان',
	'lqt-save-subject' => 'ذخیره',
	'lqt-save-subject-failed' => 'هنگامی که قصد تغییر عنوان این مبحث را داشتید خطای زیر رخ داد: 
$1',
	'lqt-ajax-invalid-subject' => 'عنوانی که مشخص کردید نامعتبر بود، احتمالاً به خاطر طولانی‌بودن بیش از حد.',
	'lqt-ajax-no-subject' => 'شما باید یک عنوان مشخص کنید.',
	'lqt-save-subject-error-unknown' => 'هنگامی که قصد تعیین عنوان این مبحث را داشتید، خطای ناشناخته‌ای رخ داد. لطفاً با کلیک بر روی «ویرایش» در بالای پست، سعی کنید انجامش دهید.',
	'lqt-cancel-subject-edit' => 'انصراف',
	'lqt-drag-activate' => 'به محل جدید بکشید',
	'lqt-drag-drop-zone' => 'اینجا ولش کنید',
	'lqt-drag-confirm' => 'برای تکمیل اقدامات زیر، لطفاً یک دلیل پر کنید و روی «تایید» کلیک کنید.',
	'lqt-drag-reparent' => 'پست را به زیر یک مادر جدید انتقال بده.',
	'lqt-drag-split' => 'پست را به مبحث خودش انتقال بده',
	'lqt-drag-setsortkey' => 'جایگاه پست در صفحه را تنظیم کنید',
	'lqt-drag-bump' => 'انتقال پست به بالای صفحهٔ بحث',
	'lqt-drag-save' => 'تأئید',
	'lqt-drag-title' => 'تأئید کشیدن',
	'lqt-drag-reason' => 'دلیل:',
	'lqt-drag-subject' => 'عنوان برای مبحث جدید (اجباری):',
	'lqt-edit-signature' => '(ویرایش امضا)',
	'lqt-preview-signature' => '(پیش‌نمایش)',
	'lqt-feed-title-all' => '{{SITENAME}} — پست‌های جدید',
	'lqt-feed-title-all-from' => '{{SITENAME}} — پست‌های جدید از $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — تاپیک‌های جدید',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — تاپیک‌های جدید از $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — پاسخ‌ها',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — پاسخ‌ها از $1',
	'lqt-feed-new-thread-intro' => 'مبحث جدید در $1 فرستاده شده توسط $2',
	'lqt-feed-reply-intro' => 'پاسخ به $3 (در $1) فرستاده شده توسط $2',
	'lqt-newmessages-n' => 'پیام‌های جدید ($1)',
	'lqt_newmessages' => 'پیام‌های جدید من (هیچ)',
	'lqt_newmessages-title' => 'پیام‌های جدید',
	'lqt-newpost-summary' => 'مبحث جدید: $1',
	'lqt-reply-summary' => 'پاسخ به [[$2|$1]]',
	'lqt-talkpage-history-title' => 'تاریخچهٔ صفحهٔ بحث',
	'lqt-talkpage-history-subtitle' => 'برای $1',
	'lqt-talkpage-history-tab' => 'سربرگ',
	'restriction-reply' => 'فرستادن پاسخ‌ها',
	'restriction-newthread' => 'فرستادن تاپیک‌های جدید',
	'lqt-protected-reply-thread' => 'شما نمی‌توانید در این مبحث پیام بفرستید، چون از پست‌های جدید محافظت شده است.',
	'lqt-protected-reply-talkpage' => 'شما نمی‌توانید در این مبحث پیام بفرستید، چراکه این صفحهٔ بحث از پاسخ به مبحث‌هایش محافظت شده است.',
	'lqt-protected-newthread' => 'شما نمی‌توانید تاپیک‌های جدیدی به این صفحهٔ بحث بفرستید، چراکه از تاپیک‌های جدید محافظت شده است.',
	'lqt-edit-bump' => 'مشکلی سخت برای این موضوع.',
	'lqt-edit-bump-tooltip' => 'این مبحث را به بالای صفحهٔ بحثش منتقل کن',
	'lqt-historicalrevision-error' => 'نسخه‌ای که انتخاب کرده‌اید خراب است، و قابل مشاهده نیست.',
	'lqt-reply-subpage' => 'پاسخ',
	'nstab-thread' => 'موضوع',
	'nstab-summary' => 'خلاصه',
);

/** Finnish (Suomi)
 * @author Cimon Avaro
 * @author Crt
 * @author Nike
 * @author Olli
 * @author Silvonen
 * @author Str4nd
 * @author ZeiP
 */
$messages['fi'] = array(
	'lqt-desc' => 'Lisää keskustelusivuille viestiketjut.',
	'lqt_movethread' => 'Siirrä ketju toiselle sivulle',
	'lqt_deletethread' => 'Poista tai palauta ketju',
	'lqt_contents_title' => 'Sisältö',
	'lqt_toc_thread_title' => 'Ketjun otsikko',
	'lqt_toc_thread_author' => 'Aloittanut',
	'lqt_toc_thread_replycount' => 'Vastauksia',
	'lqt_toc_thread_modified' => 'Viimeksi muokattu',
	'lqt_add_header' => 'Lisää otsikko',
	'lqt_new_thread' => 'Aloita uusi keskustelu',
	'lqt_invalid_subject' => 'Antamasi aihe on epäkelpo.
Syy voi olla:
* Se on liian pitkä
* Ristiriita interwiki-etuliitteiden tai nimiavaruuksien nimien kanssa.',
	'lqt_empty_subject' => 'Sinun täytyy antaa aihe.',
	'lqt_reply' => 'Vastaa',
	'lqt-parent' => 'Vastine',
	'lqt_delete' => 'Poista',
	'lqt_undelete' => 'Palauta',
	'lqt_permalink' => 'Linkki tähän viestiin',
	'lqt_fragment' => 'Osa $1 sivulta $2',
	'lqt_discussion_link' => 'keskustelusta',
	'lqt_from_talk' => 'Sivulta $1',
	'lqt-history-title' => 'Ketjun historia',
	'lqt_hist_comment_edited' => 'Kommenttitekstiä [$2 muokattu]',
	'lqt_hist_summary_changed' => 'Yhteenveto muutettu',
	'lqt_hist_reply_created' => '[[$1|Uusi viesti]]',
	'lqt_hist_thread_created' => 'Ketju luotiin',
	'lqt_hist_deleted' => 'Poistettu',
	'lqt_hist_undeleted' => 'Palautettu',
	'lqt_hist_moved_talkpage' => 'Siirretty',
	'lqt_hist_listing_subtitle' => 'Tarkastellaan historialistausta',
	'lqt_hist_view_whole_thread' => 'Näytä koko ketjun historia',
	'lqt_hist_no_revisions_error' => 'Tällä ketjulla ei ole yhtään muutoshistoriaversioita.',
	'lqt_hist_past_last_page_error' => 'Ylitit historiassa olevan sivumäärän.',
	'lqt_hist_tooltip_newer_disabled' => 'Tämä linkki on poistettu käytöstä, koska olet ensimmäisellä sivulla.',
	'lqt_hist_tooltip_older_disabled' => 'Tämä linkki on poistettu käytöstä, koska olet viimeisellä sivulla.',
	'lqt_hist_split' => 'Vastaus ohjattu uuteen ketjuun',
	'lqt_hist_edited_subject' => 'Muutettu aihe ”$2” aiheeksi ”$3”',
	'lqt_hist_edited_subject_corrupt' => 'Muutettu aihetta',
	'lqt_hist_merged_from' => '[[$1|Vastaus]] siirretty toiseen ketjuun',
	'lqt_hist_merged_to' => '[[$1|Vastaus]] siirretty toisesta ketjusta',
	'lqt_hist_split_from' => 'Jaa uudeksi ketjuksi',
	'lqt_hist_root_blanked' => 'Kommenttiteksti poistettu',
	'lqt_hist_adjusted_sortkey' => 'Säädetty ketjusijainti',
	'lqt_revision_as_of' => 'Versio, joka on päivätty $2 kello $3.',
	'lqt_change_new_thread' => 'Tämä on ketjun alustava versio.',
	'lqt_change_reply_created' => '[$1 Korostettu kommentti] luotiin tässä versiossa.',
	'lqt_change_edited_root' => '[$1 Korostettua kommenttia] muokattiin tässä versiossa.',
	'lqt_change_edited_summary' => 'Ketjun yhteenvetoa on muokattu',
	'lqt_change_deleted' => '[$1 Tämän ketju] tai vastaus sille poistettiin',
	'lqt_change_undeleted' => '[$1 Korostettu viesti] palautettiin',
	'lqt_change_moved' => '[$1 Tämä ketju] on siirretty toiselle keskustelusivulle',
	'lqt_change_split' => '[$1 Tämä ketju] jaettiin toisesta ketjusta',
	'lqt_change_edited_subject' => 'Tämän ketjun vanha aihe ”$2” muutettiin muotoon ”$3”',
	'lqt_change_merged_from' => '[$1 Vastaus] tähän ketjuun oli siirretty toiseen ketjuun',
	'lqt_change_merged_to' => '[$1 Korostettu vastaus] siirrettiin toiseen ketjuun',
	'lqt_change_split_from' => 'Tämän ketjun [$1 alaketju] jaettiin omaksi ketjukseen',
	'lqt_change_root_blanked' => '[$1 Kommentin] teksti poistettiin.',
	'lqt_youhavenewmessages' => 'Sinulle on [[$1|uusia viestejä]].',
	'lqt_protectedfromreply' => 'Tämä ketju on $1 vastauksilta.',
	'lqt_protectedfromreply_link' => 'suojattu',
	'lqt_subject' => 'Otsikko',
	'lqt_noreason' => 'Ei annettua syytä.',
	'lqt_move_placeholder' => 'Tämä ketju on paikanvaraaja, joka osoittaa ketjun $1 olevan siirretty tältä sivulta.
Siirron teki $2 – $3 kello $4. Ketju sijaitsee nyt sivulla $5.',
	'lqt_thread_deleted_for_sysops' => "Tämä ketju on '''poistettu''' ja se näkyy vain ylläpitäjille.",
	'lqt_thread_deleted' => 'Tämä ketju on poistettu.',
	'lqt_summary_notice' => 'Tähän keskusteluun ei ole tehty muutoksia ainakaan $2 {{PLURAL:$2|päivänä}}.
Jos se on päättynyt, voi olla että haluat $1.',
	'lqt_summary_notice_link' => 'kirjoittaa yhteenvedon',
	'lqt_summary_label' => 'Ketjun yhteenveto:',
	'lqt_summary_subtitle' => 'Yhteenveto kohteelle $1',
	'lqt_nosuchrevision' => 'Tässä ketjussa ei ole kyseistä versiota.',
	'lqt_nosuchthread' => 'Määrittämääsi viestiketjua ei ole.',
	'lqt_nosuchthread_title' => 'Ketjua ei löydy',
	'lqt_threadrequired' => 'Sinun tulee antaa ketju URL-osoitteessa.',
	'lqt_move_movingthread' => 'Siirretään $1. 
Tämä ketju on osa sivua $2.',
	'lqt_move_torename' => 'Nimetäksesi uudelleen tämän ketjun – $1 ja muuta Aihe-kenttää.',
	'lqt_move_torename_edit' => 'muokkaa sitä',
	'lqt_move_destinationtitle' => 'Kohdekeskustelusivun otsikko:',
	'lqt_move_move' => 'Siirrä',
	'lqt_move_nodestination' => 'Sinun tulee määrittää kohde.',
	'lqt_move_thread_bad_destination' => 'Kohdesivu ei ole keskustelusivu.',
	'lqt_move_samedestination' => 'Ketju on jo tällä sivulla.',
	'lqt_move_noreason' => 'Syytä ei annettu.',
	'lqt_move_success' => 'Ketju siirrettiin kohteeseen $1.',
	'lqt_delete_undeletethread' => 'Palauta viestiketju',
	'lqt_delete_partof' => "Tämä ketju on osa sivua '''$1'''.",
	'lqt_delete_deleting' => "Poistetaan '''$1''' ja '''kaikki vastaukset''' siihen.",
	'lqt_delete_deletethread' => 'Poista ketju ja vastaukset',
	'lqt_delete_deleted' => 'Ketju on poistettu.',
	'lqt_delete_undeleted' => 'Ketju on palautettu.',
	'lqt_delete_return' => 'Palaa sivulle $1.',
	'lqt_delete_return_link' => 'keskustelusivu',
	'lqt_delete_unallowed' => 'Et ole oikeutettu poistamaan ketjuja.',
	'lqt_delete_show_checkbox' => 'Näytä poistetut ketjut',
	'lqt_talkpage_autocreate_summary' => 'Keskustelusivu luotiin automaattisesti kun ensimmäinen ketju lähettiin.',
	'lqt_header_warning_big' => 'Muokkaat $1.',
	'lqt_header_warning_after_big' => 'Otsakkeet ovat ilmoituksille ja johdannoille. 
Saatat etsiä sivua $2 sen sijaan.',
	'lqt_header_warning_bold' => 'keskustelusivun otsikkoa',
	'lqt_header_warning_new_discussion' => 'aloita uusi keskustelu',
	'lqt_sorting_order' => 'Luettelointijärjestys:',
	'lqt_sort_newest_changes' => 'viimeksi muokattu ensimmäiseksi',
	'lqt_sort_newest_threads' => 'uusimmat ketjut ensimmäiseksi',
	'lqt_sort_oldest_threads' => 'vanhimmat ketjut ensimmäiseksi',
	'lqt-title' => 'Otsikko',
	'lqt-summary' => 'Yhteenveto',
	'lqt-searching' => 'Ketjujen haku',
	'lqt-read-message' => 'Merkitse luetuksi',
	'lqt-read-message-tooltip' => 'Poista tämä ketju uusista viesteistä.
Se näkyy edelleen alkuperäisellä keskustelusivullaan.',
	'lqt-read-all' => 'Merkitse kaikki luetuiksi',
	'lqt-read-all-tooltip' => 'Poista kaikki ketjut uusista viesteistä.
Ne näkyvät silti alkuperäisillä keskustelusivuillaan.
Tätä toimintoa ei voi perua.',
	'lqt-marked-read' => "Viestiketju '''$1''' merkitty luetuksi.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|viesti|viestiä}} merkitty luetuksi.',
	'lqt-email-undo' => 'Kumoa',
	'lqt-no-new-messages' => 'Sinulle ei ole uusia viestejä.',
	'lqt-new-messages' => '✒ Sinulle on uusia viestejä.',
	'lqt-email-info-undo' => 'Palauta juuri poistamasi ketju.',
	'lqt-date-info' => 'Tämä linkki ei ole käytössä koska sinulla on näkyvissä ketjut kaikilta ajankohdilta.',
	'lqt-newmessages-context' => 'Koko viestiketju',
	'lqt-thread-created' => 'Luotu',
	'lqt-history-time' => 'Päiväys',
	'lqt-history-user' => 'Käyttäjä',
	'lqt-history-action' => 'Toiminto',
	'lqt-history-comment' => 'Kommentti',
	'lqt-history-thread' => 'Ketju',
	'lqt-thread-edited-author' => 'Aloittajan muokkaama.<br />
Viimeisin muokkaus: $1',
	'lqt-thread-edited-others' => '{{PLURAL:$2|Muun käyttäjän|$2 muun käyttäjän}} muokkaama.<br />
Viimeisin muokkaus: $1',
	'lqt-header-actions' => 'Toiminnot',
	'lqt_summarize_link' => 'Tiivistä',
	'lqt-summarize-intro' => 'Tee yhteenveto alla olevasta ketjusta muokkauskenttään.
Voit käyttää mitä tahansa wikitekstiä yhteenvedossa.
Kun olet valmis, napsauta ”{{int:savearticle}}”.',
	'lqt-thread-split' => 'Jaa uudeksi ketjuksi',
	'lqt-split-success' => 'Olet jakanut onnistuneesti ketjun $1.',
	'lqt_split_thread' => 'Jaa viestiketju',
	'lqt-thread-split-subject' => 'Uuden viestiketjun otsikko:',
	'lqt-thread-split-thread' => 'Ketju:',
	'lqt-split-submit' => 'Jaa',
	'lqt_split_badsubject' => 'Antamasi aihe ei ole kelvollinen.',
	'lqt-no-threads' => 'Tällä sivulla ei ole vielä ketjuja.',
	'lqt-delete-parent-warning' => 'Tämä on ylimmän tason ketju vastauksineen.
Sen vastaukset poistetaan myös automaattisesti.
Välttääksesi tämän, jaa ne tästä ketjusta erilleen ennen sen poistamista.',
	'lqt-delete-parent-deleted' => 'Isäketju poistettu ($1)',
	'lqt-delete-replies-done' => 'Kaikki vastaukset tähän ketjuun on myös poistettu.',
	'lqt-movethread' => 'Siirrä',
	'lqt-menu-trigger' => 'Lisää',
	'lqt-newmessages-from' => 'Sivulta $1',
	'lqt-hot-topics' => 'Kuumat aiheet',
	'lqt-add-reply' => 'Lisää vastaus',
	'lqt_rc_new_discussion' => 'aloitti uuden ketjun ”$1”',
	'lqt_rc_new_reply' => 'vastasi ketjuun ”$1”',
	'right-lqt-split' => 'Jakaa viestiketjuja',
	'right-lqt-merge' => 'Yhdistää viestiketjuja',
	'lqt-thread-merge' => 'Yhdistä toiseen viestiketjuun',
	'lqt-thread-merge-to' => 'Yhdistä tähän viestiketjuun',
	'lqt_merge_thread' => 'Yhdistä ketju',
	'lqt-thread-merge-source' => 'Lähdeketju:',
	'lqt-thread-merge-dest' => 'Määränpääketju:',
	'lqt-merge-submit' => 'Yhdistä',
	'lqt-merge-success' => 'Olet onnistuneesti yhdistänyt ketjun $1 ketjun $2 alaiseksi.',
	'lqt-log-name' => 'Viestiketjuloki',
	'lqt-log-header' => 'Tämä loki kertoo keskusteluketjuille tehdyistä toiminteista.',
	'lqt-log-action-move' => 'siirsi aiheen [[$1]] sivulta [[$2]] sivulle [[$3]].',
	'lqt-log-action-split' => 'pilkkoi vastauksen [[$1]] keskustelusta [[$3]] uudelle otsikolle ”$2”',
	'lqt-log-action-merge-across' => '[[$1]] siirretty kohdan [[$2]] alta kohdan [[$3]] alle',
	'lqt-log-action-merge-down' => 'liitetty [[$1]] kohdan [[$3]] alle',
	'lqt-log-action-subjectedit' => 'muutti keskustelun [[$1]] otsikon ”$2” otsikoksi ”$3”',
	'lqt-log-action-resort' => 'vaihdettiin kohdan [[$1]] järjestystä. Järjestysavain vaihdettiin $2 avaimeksi $3',
	'lqt-preference-notify-talk' => 'Lähetä sähköpostia viestiketjun vastauksista, joita tarkkailen',
	'lqt-preference-watch-threads' => 'Tarkkaile viestiketjuja, jotka olen luonnut tai joihin olen vastannut',
	'prefs-lqt' => 'Viestiketjut',
	'lqt-preference-display-depth' => 'Sisäkkäisiä vastauksia oletusnäkymässä:',
	'lqt-preference-display-count' => 'Enimmäismäärä vastauksia näytettäväksi:',
	'lqt-preference-custom-signatures' => 'Näytä käyttäjien mukautetut allekirjoitukset',
	'lqt-enotif-subject-reply' => '{{SITENAME}} – Vastaus keskusteluun $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} – Uusi viestiketju: $1',
	'lqt-enotif-newthread' => 'Hei $1,

Tämä on ilmoitus sivustolta {{SITENAME}}, että sivulle $5 on luotu uusi ketju, ”$2”, 
$3 $4.

Näet sen osoitteessa <$6>.',
	'lqt-enotif-reply' => 'Hei $1,
Tämä on ilmoitus {{GRAMMAR:elative|{{SITENAME}}}}, että sivun $5 ketjuun ”$2” on tullut uusi vastaus $3 kello $4.

Näet sen osoitteessa <$6>.

Vastauksen teksti on:
$7',
	'lqt-quote-intro' => '[[User:$1|$1]] kirjoitti $2 kello $3:',
	'lqt-quote' => 'Lainaa',
	'lqt-search-legend' => 'Hae keskusteluja tältä sivulta',
	'lqt-search-label' => 'Hakuehdot',
	'lqt-search-button' => 'Etsi',
	'searchprofile-threads' => 'Keskustelut',
	'searchprofile-threads-tooltip' => 'Hae ketjutetuista keskusteluista ja keskustelusivuilta',
	'lqt-ajax-updated' => 'Tässä ketjussa on uusia viestejä.',
	'lqt-ajax-update-link' => 'Päivitä',
	'lqt-thread-show-replies' => 'Näytä {{PLURAL:$1|vastaus|$1 vastausta}}',
	'lqt-thread-show-more' => 'Näytä lisää vastauksia',
	'lqt-thread-link-url' => 'Osoite:',
	'lqt-thread-link-title' => 'Wikitekstin linkki:',
	'lqt-thread-link-copy' => 'Kopioi leikepöydälle',
	'lqt-sign-not-necessary' => 'Viestisi allekirjoittaminen neljällä tildellä (~) ei ole välttämätöntä.
Allekirjoitus näytetään automaattisesti.',
	'lqt-marked-as-read-placeholder' => 'Ketju $1 merkittiin luetuksi.',
	'lqt-change-subject' => 'Muuta aihe',
	'lqt-save-subject' => 'Tallenna',
	'lqt-save-subject-failed' => 'Seuraava virhe tapahtui yrittäessä muuttaa tämän ketjun aihetta: $1',
	'lqt-ajax-invalid-subject' => 'Antamasi otsikko ei ollut kelvollinen, todennäköisesti koska se oli liian pitkä.',
	'lqt-ajax-no-subject' => 'Sinun tulee antaa otsikko.',
	'lqt-save-subject-error-unknown' => 'Tuntematon virhe tapahtui asetettaessa tämän ketjun otsikkoa. Kokeile tämän tekemistä napsauttamalla ”Muokkaa” ylimmästä viestistä.',
	'lqt-cancel-subject-edit' => 'Peruuta',
	'lqt-drag-activate' => 'Raahaa uuteen sijaintiin',
	'lqt-drag-drop-zone' => 'Pudota tähän',
	'lqt-drag-confirm' => 'Saattaaksesi seuraavat toiminnot valmiiksi, kirjoita syy ja napsauta ”Vahvista.”',
	'lqt-drag-reparent' => 'Siirrä viesti uuden vanhemman alle.',
	'lqt-drag-split' => 'Siirrä viesti omaksi ketjukseen',
	'lqt-drag-setsortkey' => 'Säädä viestin sijaintia sivulla',
	'lqt-drag-bump' => 'Siirrä viesti keskustelusivun ylälaitaan',
	'lqt-drag-save' => 'Vahvista',
	'lqt-drag-title' => 'Vahvista siirtäminen',
	'lqt-drag-reason' => 'Syy',
	'lqt-drag-subject' => 'Aihe uudelle ketjulle:',
	'lqt-edit-signature' => '(muokkaa allekirjoitusta)',
	'lqt-preview-signature' => '(esikatselu)',
	'lqt-feed-title-all' => '{{SITENAME}} – Uudet viestit',
	'lqt-feed-title-all-from' => '{{SITENAME}} – Uudet viestit sivuilla $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – Uudet viestiketjut',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – Uudet ketjut sivuilla $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – Vastaukset',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – Vastaukset sivuilla $1',
	'lqt-feed-new-thread-intro' => 'Uusi ketju sivulla $1, jonka on lähettänyt $2',
	'lqt-feed-reply-intro' => 'Vastaa ketjuun $3 (sivulla $1), jonka on lähettänyt $2',
	'lqt-newmessages-n' => 'Uudet viestit ($1)',
	'lqt_newmessages' => 'Ei uusia viestejä',
	'lqt_newmessages-title' => 'Uudet viestit',
	'lqt-newpost-summary' => 'Uusi ketju: $1',
	'lqt-reply-summary' => 'Vastaa [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Keskustelun muutoshistoria',
	'lqt-talkpage-history-subtitle' => 'Sivulle $1',
	'lqt-talkpage-history-tab' => 'Otsake',
	'restriction-reply' => 'Lähetä vastauksia',
	'restriction-newthread' => 'Aloita uusia ketjuja',
	'lqt-protected-reply-thread' => 'Et voi vastata tähän ketjuun, koska se on suojattu uusilta vastauksilta.',
	'lqt-protected-reply-talkpage' => 'Et voi vastata tähän ketjuun, koska tämä keskustelusivu on suojattu vastauksilta sen ketjuihin.',
	'lqt-protected-newthread' => 'Et voi luoda uusia ketjuja tälle keskustelusivulle, koska se on suojattu uusilta ketjuilta.',
	'lqt-edit-bump' => 'Tökkää tätä ketjua',
	'lqt-edit-bump-tooltip' => 'Siirrä tämä ketju keskustelusivun ylimmäksi',
	'lqt-historicalrevision-error' => 'Valitsemasi versio on korruptoitunut – eikä sitä voida näyttää.',
	'lqt-reply-subpage' => 'vastaa',
	'nstab-thread' => 'Säie',
	'nstab-summary' => 'Yhteenveto',
);

/** French (Français)
 * @author Crochet.david
 * @author Dereckson
 * @author Grondin
 * @author Hercule
 * @author IAlex
 * @author Jean-Frédéric
 * @author McDutchie
 * @author Mormegil
 * @author Peter17
 * @author PieRRoMaN
 * @author Sherbrooke
 * @author Urhixidur
 * @author Verdy p
 * @author Zetud
 */
$messages['fr'] = array(
	'lqt-desc' => 'Ajoute des fils de discussion dans les pages de discussion',
	'lqt_movethread' => 'Déplacer le fil vers une autre page',
	'lqt_deletethread' => 'Effacer ou récupérer le fil',
	'lqt_contents_title' => 'Sujets',
	'lqt_toc_thread_title' => 'Titre du fil',
	'lqt_toc_thread_author' => 'Lancé par',
	'lqt_toc_thread_replycount' => 'Réponses',
	'lqt_toc_thread_modified' => 'Dernière modification',
	'lqt_add_header' => 'Ajouter en-tête',
	'lqt_new_thread' => 'Lancer une nouvelle discussion',
	'lqt_invalid_subject' => 'Le sujet que vous avez entré est invalide. Il peut :
* être trop long ;
* entrer en conflit avec un préfixe interwiki, ou un espace de noms.',
	'lqt_empty_subject' => 'Vous devez entrer un objet.',
	'lqt_reply' => 'Répondre',
	'lqt-parent' => 'Parent',
	'lqt_delete' => 'Supprimer',
	'lqt_undelete' => 'Récupérer',
	'lqt_permalink' => 'Lien vers',
	'lqt_fragment' => "Fragment d'une $1 sur $2",
	'lqt_discussion_link' => 'discussion',
	'lqt_from_talk' => 'De $1',
	'lqt-history-title' => 'Historique du fil',
	'lqt_hist_comment_edited' => 'Texte de commentaire [$2 modifié]',
	'lqt_hist_summary_changed' => 'Sommaire modifié',
	'lqt_hist_reply_created' => '[[$1|Nouvelle réponse]] créée',
	'lqt_hist_thread_created' => 'Nouveau fil créé',
	'lqt_hist_deleted' => 'Effacé',
	'lqt_hist_undeleted' => 'Récupéré',
	'lqt_hist_moved_talkpage' => 'Déplacé',
	'lqt_hist_listing_subtitle' => 'Visualiser un historique',
	'lqt_hist_view_whole_thread' => 'Voir l’historique de tout le fil',
	'lqt_hist_no_revisions_error' => 'Ce fil n’a pas d’historique de révisions.',
	'lqt_hist_past_last_page_error' => 'Vous avez dépassé le nombre de pages de l’historique.',
	'lqt_hist_tooltip_newer_disabled' => 'Ce lien est inactif car vous êtes sur la première page.',
	'lqt_hist_tooltip_older_disabled' => 'Ce lien est inactif car vous êtes sur la dernière page.',
	'lqt_hist_split' => 'Réponse séparée dans un nouveau fil de discussion',
	'lqt_hist_edited_subject' => 'Sujet modifié de « $2 » à « $3 »',
	'lqt_hist_edited_subject_corrupt' => 'Sujet modifié',
	'lqt_hist_merged_from' => '[[$1|Réponse]] déplacée dans un autre fil de discussion',
	'lqt_hist_merged_to' => '[[$1|Réponse]] déplacée depuis un autre fil de discussion',
	'lqt_hist_split_from' => 'Séparer vers un nouveau fil de discussion',
	'lqt_hist_root_blanked' => 'Texte de commentaire supprimé',
	'lqt_hist_adjusted_sortkey' => 'Position du file de discussion modifiée',
	'lqt_revision_as_of' => 'Révision en date du $2 à $3.',
	'lqt_change_new_thread' => 'C’est la première révision du fil.',
	'lqt_change_reply_created' => 'Le [$1 commentaire en surbrillance] a été créé dans cette révision.',
	'lqt_change_edited_root' => 'Le [$1 commentaire en surbrillance] a été modifié dans cette révision.',
	'lqt_change_edited_summary' => 'Le résumé du fil de discussion a été modifié',
	'lqt_change_deleted' => '[$1 Ce fil de discussion] ou son parent a été supprimé',
	'lqt_change_undeleted' => 'L’[$1 article mis en surbrillance] a été restauré',
	'lqt_change_moved' => '[$1 Ce fil de discussion] a été déplacé vers une autre page de discussion',
	'lqt_change_split' => "[$1 Ce fil de discussion] a été séparé d'un autre fil de discussion",
	'lqt_change_edited_subject' => 'Le sujet de ce fil de discussion a été changé de « $2 » en « $3 »',
	'lqt_change_merged_from' => 'Une [$1 réponse] à ce fil de discussion a été déplacée vers un autre fil de discussion',
	'lqt_change_merged_to' => 'La [$1 réponse mise en surbrillance] a été déplacée depuis un autre fil de discussion',
	'lqt_change_split_from' => 'Une [$1 sous-branche] de ce fil de discussion a été séparée dans son propre fil de discussion',
	'lqt_change_root_blanked' => "Le texte d'[$1 un commentaire] a été supprimé.",
	'lqt_youhavenewmessages' => 'Vous avez [[$1|nouveaux messages]].',
	'lqt_protectedfromreply' => 'Ce fil a été $1. Vous ne pouvez y répondre.',
	'lqt_protectedfromreply_link' => 'protégé',
	'lqt_subject' => 'Sujet :',
	'lqt_noreason' => 'Aucun raison donnée',
	'lqt_move_placeholder' => 'Ce fil est une marque substitutive indiquant qu’un fil, $1, a été déplacé de cette page.
Ce déplacement a été fait par $2 à $3 $4. Le fil se trouve maintenant à $5.',
	'lqt_thread_deleted_for_sysops' => "Ce fil a été '''supprimé''' et seuls les administrateurs peuvent le voir.",
	'lqt_thread_deleted' => 'Ce fil a été effacé.',
	'lqt_summary_notice' => 'Il n’y a eu aucun changement dans cette discussion depuis au moins $2 jour{{PLURAL:$2||s}}.
Si elle a été conclue, vous pouvez avoir besoin de $1.',
	'lqt_summary_notice_link' => 'écrire un résumé',
	'lqt_summary_label' => 'Résumé du fil :',
	'lqt_summary_subtitle' => 'Résumé de $1.',
	'lqt_nosuchrevision' => 'Aucune révision pour ce fil ne correspond.',
	'lqt_nosuchthread' => "Le fil que vous avez spécifié n'existe pas.",
	'lqt_nosuchthread_title' => 'Le fil est introuvable',
	'lqt_threadrequired' => "Vous devez indiquer un fil dans l'URL.",
	'lqt_move_movingthread' => '$1 en déplacement. Ce fil fait partie de $2.',
	'lqt_move_torename' => "Pour renommer ce fil, $1 et modifier le champ ''Sujet''.",
	'lqt_move_torename_edit' => 'le modifier',
	'lqt_move_destinationtitle' => 'Titre de la page de discussion finale :',
	'lqt_move_move' => 'Déplacer',
	'lqt_move_nodestination' => 'Vous devez indiquer une destination.',
	'lqt_move_thread_bad_destination' => "La page de destination n'est pas une page de discussion.",
	'lqt_move_samedestination' => 'Le fil est déjà sur cette page !',
	'lqt_move_noreason' => 'Aucune raison donnée',
	'lqt_move_success' => 'Le fil a été déplacé dans $1.',
	'lqt_delete_undeletethread' => 'Récupérer ce fil',
	'lqt_delete_partof' => "Ce fil fait partie de '''$1'''.",
	'lqt_delete_deleting' => "Suppression du fil '''$1''' et de '''toutes les réponses''' associées.",
	'lqt_delete_deletethread' => 'Effacer le fil et ses réponses',
	'lqt_delete_deleted' => 'Le fil a été effacé.',
	'lqt_delete_undeleted' => 'Le fil a été récupéré.',
	'lqt_delete_return' => 'Revenir à $1',
	'lqt_delete_return_link' => 'la page de discussion',
	'lqt_delete_unallowed' => "Vous n'avez pas les droits pour effacer des fils.",
	'lqt_delete_show_checkbox' => 'Afficher les fils supprimés',
	'lqt_talkpage_autocreate_summary' => 'Page de discussion créée automatiquement quand le premier fil de discussion a été envoyé.',
	'lqt_header_warning_big' => 'Vous modifiez un $1.',
	'lqt_header_warning_after_big' => 'Les en-têtes sont pour les annonces et les préfaces.
Vous pourriez préférer $2.',
	'lqt_header_warning_bold' => 'En-tête d’une page de discussion',
	'lqt_header_warning_new_discussion' => 'lancer un nouveau fil de discussion',
	'lqt_sorting_order' => 'Ordre de tri :',
	'lqt_sort_newest_changes' => 'en commençant par les derniers modifiés',
	'lqt_sort_newest_threads' => 'en commençant par les fils de discussion les plus récents',
	'lqt_sort_oldest_threads' => 'en commençant par les fils de discussion les plus anciens',
	'lqt-title' => 'Titre',
	'lqt-summary' => 'Sommaire',
	'lqt-searching' => 'Recherche des fils de discussion',
	'lqt-read-message' => 'Marquer comme lu',
	'lqt-read-message-tooltip' => 'Retirer ce fil des nouveaux messages.
Il sera encore visible dans sa page de discussion originale.',
	'lqt-read-all' => 'Tout marquer comme lu',
	'lqt-read-all-tooltip' => 'Enlever tous les fils des nouveaux messages.
Ils seront encore visibles sur leur page de discussion originale.
Cette opération est réversible.',
	'lqt-marked-read' => "Fil de discussion '''$1''' marqué comme lu.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|message marqué comme lu|messages marqués comme lus}}',
	'lqt-email-undo' => 'Défaire',
	'lqt-no-new-messages' => 'Il n’y a aucun message pour vous.',
	'lqt-new-messages' => '✒ Vous avez de nouveaux messages.',
	'lqt-email-info-undo' => 'Rétablir le fil que vous venez juste d’enlever.',
	'lqt-date-info' => 'Ce lien est désactivé parce que vous êtes en train de voir les fils à partir de toutes les dates.',
	'lqt-newmessages-context' => 'Fil complet',
	'lqt-thread-created' => 'Créé',
	'lqt-history-time' => 'Date',
	'lqt-history-user' => 'Utilisateur',
	'lqt-history-action' => 'Activité',
	'lqt-history-comment' => 'Commentaire',
	'lqt-history-thread' => 'Fil de discussion',
	'lqt-thread-edited-author' => 'Modifié par l’auteur<br />
Dernière modification : $1',
	'lqt-thread-edited-others' => 'Modifié $2 utilisateurs<br />
Dernière modification : $1',
	'lqt-header-actions' => 'Actions',
	'lqt_summarize_link' => 'Résumé',
	'lqt-summarize-intro' => 'Résumer le sujet ci-dessus dans la boite d’édition
Vous pouvez utiliser n’importe quel texte wiki dans votre résumé. Lorsque vous avez terminé, cliquez sur « {{int: Savearticle}}» .',
	'lqt-thread-split' => 'Scinder vers un nouveau fil',
	'lqt-split-success' => 'Vous avez scindé avec succès le fil $1.',
	'lqt_split_thread' => 'Scinder un fil',
	'lqt-thread-split-subject' => 'Sujet du nouveau fil :',
	'lqt-thread-split-thread' => 'Fil :',
	'lqt-split-submit' => 'Scinder',
	'lqt_split_badsubject' => 'Le sujet que vous avez entré est invalide.',
	'lqt-no-threads' => 'Il n’y a pas encore de fil de discussion sur cette page.',
	'lqt-delete-parent-warning' => 'Ceci est un fil de discussion de haut niveau contenant des réponses.
Ses réponses seront aussi supprimées automatiquement.
Pour éviter cela, séparez les de ce fil de discussion avant de supprimer celui-ci.',
	'lqt-delete-parent-deleted' => 'Fil de discussion parent supprimé ($1)',
	'lqt-delete-replies-done' => 'Toutes les réponses à ce fil de discussion ont aussi été supprimées.',
	'lqt-movethread' => 'Déplacer',
	'lqt-menu-trigger' => 'Plus',
	'lqt-newmessages-from' => 'Depuis $1',
	'lqt-hot-topics' => 'Sujets brûlants',
	'lqt-add-reply' => 'Ajouter une réponse',
	'lqt_rc_new_discussion' => 'a posté un nouveau fil « $1 »',
	'lqt_rc_new_reply' => 'posté une réponse à « $1 »',
	'right-lqt-split' => 'Scinder les fils de discussion',
	'right-lqt-merge' => 'Fusionner les fils de discussion',
	'lqt-thread-merge' => 'Fusionner dans un autre fil',
	'lqt-thread-merge-to' => 'Fusionner dans ce fil',
	'lqt_merge_thread' => 'Fusionner le fil',
	'lqt-thread-merge-source' => 'Fil source :',
	'lqt-thread-merge-dest' => 'Fil de destination :',
	'lqt-merge-submit' => 'Fusionner',
	'lqt-merge-success' => 'Vous avez fusionné le fil de discussion $1 dans $2.',
	'lqt-log-name' => 'Journal des fils de discussion',
	'lqt-log-header' => 'Ce journal détaille les actions faites sur les fils de discussion.',
	'lqt-log-action-move' => 'a déplacé [[$1]] de [[$2]] vers [[$3]].',
	'lqt-log-action-split' => 'a scindé [[$1]] sous [[$3]], avec le nouveau sujet « $2 ».',
	'lqt-log-action-merge-across' => 'a déplacé [[$1]] depuis sous [[$2]] à sous [[$3]].',
	'lqt-log-action-merge-down' => 'a fusionné [[$1]] au dessous de [[$3]]',
	'lqt-log-action-subjectedit' => 'a modifié le sujet de [[$1]] de « $2 » à « $3 »',
	'lqt-log-action-resort' => "a modifié l'ordre de tri de [[$1]]. La clé de tri a été changée de « $2 » à « $3 ».",
	'lqt-preference-notify-talk' => "M’avertir par couriel lors d'une réponse sur un sujet que je suis",
	'lqt-preference-watch-threads' => 'Suivre les fils de discussion que je crée ou auxquels je participe',
	'prefs-lqt' => 'Discussions en fil',
	'lqt-preference-display-depth' => 'Profondeur maximale des réponses à afficher :',
	'lqt-preference-display-count' => 'Nombre maximal de réponses à afficher :',
	'lqt-preference-custom-signatures' => 'Montrer les signatures personnalisées des utilisateurs',
	'lqt-enotif-subject-reply' => 'Discussion sur {{SITENAME}} - Réponse : $1',
	'lqt-enotif-subject-newthread' => 'Discussion sur {{SITENAME}}  - Nouveau sujet : $1',
	'lqt-enotif-newthread' => 'Bonjour $1,
Ceci est une notification de {{SITENAME}}, indiquant qu’un nouveau sujet sur $5, « $2 »,
a été créé le $3 à $4 par $8.

Vous pouvez le consulter à <$6>

Le texte est :
$7',
	'lqt-enotif-reply' => "Bonjour $1,
Ceci est une notification de {{SITENAME}}, qu'une nouvelle réponse à « $2 » sur $5
a été créée le $3 à $4 par $8

Vous pouvez la consulter sur « $6 »

Le texte de la réponse est :
$7",
	'lqt-quote-intro' => 'Le $2 à $3, [[User:$1|$1]] a écrit :',
	'lqt-quote' => 'Citer',
	'lqt-search-legend' => 'Rechercher des discussions sur cette page',
	'lqt-search-label' => 'Termes de recherche :',
	'lqt-search-button' => 'Rechercher',
	'searchprofile-threads' => 'Discussions',
	'searchprofile-threads-tooltip' => 'Rechercher dans les fils de discussion et les pages de discussion',
	'lqt-ajax-updated' => 'Ce fil a de nouveaux messages.',
	'lqt-ajax-update-link' => 'Mettre à jour',
	'lqt-thread-show-replies' => 'Montrer $1 réponses',
	'lqt-thread-show-more' => 'Montrer plus de réponses',
	'lqt-thread-link-url' => 'URL du lien :',
	'lqt-thread-link-title' => 'Lien wikitexte :',
	'lqt-thread-link-copy' => 'Copier dans le presse-papiers',
	'lqt-sign-not-necessary' => 'Il n’est pas nécessaire de signer votre article avec quatre tildes.
La signature est affichée automatiquement.',
	'lqt-marked-as-read-placeholder' => 'Le fil $1 a été marqué comme lu.',
	'lqt-change-subject' => 'Changer le sujet',
	'lqt-save-subject' => 'Sauvegarder',
	'lqt-save-subject-failed' => 'L’erreur suivant s’est produite lors de la tentative de changement de sujet de ce fil : $1',
	'lqt-ajax-invalid-subject' => 'Le sujet que vous avez indiqué est invalide, probablement car trop long.',
	'lqt-ajax-no-subject' => 'Vous devez indiquer un sujet pour le nouveau fil de discussion.',
	'lqt-save-subject-error-unknown' => 'Une erreur inconnue s’est produite lors de la définition du sujet de ce fil. Veuillez essayer en cliquant « modifier » sur le message du haut.',
	'lqt-cancel-subject-edit' => 'Annuler',
	'lqt-drag-activate' => 'Déplacer vers la nouvelle position',
	'lqt-drag-drop-zone' => 'Déposer ici',
	'lqt-drag-confirm' => 'Pour finir les actions suivantes, merci de fournir une raison et de cliquer sur « Confirmer ».',
	'lqt-drag-reparent' => 'Déplacer le message sous un nouveau parent.',
	'lqt-drag-split' => 'Déplacer le message vers son propre fil de discussion',
	'lqt-drag-setsortkey' => 'Modifier la position du message dans la page',
	'lqt-drag-bump' => 'Déplacer le message vers le haut de la page de discussion',
	'lqt-drag-save' => 'Confirmer',
	'lqt-drag-title' => 'Confirmer le glissement',
	'lqt-drag-reason' => 'Motif :',
	'lqt-drag-subject' => 'Sujet du nouveau fil de discussion (obligatoire) :',
	'lqt-edit-signature' => '(modifier la signature)',
	'lqt-preview-signature' => '(prévisualiser)',
	'lqt-feed-title-all' => '{{SITENAME}} - Nouveaux messages',
	'lqt-feed-title-all-from' => '{{SITENAME}} - Nouveaux messages de $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} - Nouveaux fils de discussion',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} - Nouveaux fils de discussion de $1',
	'lqt-feed-title-replies' => '{{SITENAME}} - Réponses',
	'lqt-feed-title-replies-from' => '{{SITENAME}} - Réponses de $1',
	'lqt-feed-new-thread-intro' => 'Nouveau fil de discussion sur $1 posté par $2',
	'lqt-feed-reply-intro' => 'Réponse à $3 (sur $1) postée par $2',
	'tooltip-pt-newmessages' => 'Montre les nouveaux messages sur les sujets ou sur les pages de discussions que vous suivez',
	'lqt-newmessages-n' => 'Nouveaux messages ($1)',
	'lqt_newmessages' => 'Nouveaux messages (aucun)',
	'lqt_newmessages-title' => 'Nouveaux messages',
	'lqt-newpost-summary' => 'Nouveau fil : $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => "S'il vous plaît entrez votre texte pour ce fil de discussion. Vous devriez supprimer cette ligne-là.",
	'lqt-reply-summary' => 'Répondre à [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historique de la page de discussion',
	'lqt-talkpage-history-subtitle' => 'Pour $1',
	'lqt-talkpage-history-tab' => 'En-tête',
	'restriction-reply' => 'Poster des réponses',
	'restriction-newthread' => 'Poster des nouveaux fils de discussion',
	'lqt-protected-reply-thread' => 'Vous ne pouvez pas poster dans ce fil de discussion car il a été protégé contre les nouveaux messages.',
	'lqt-protected-reply-talkpage' => 'Vous ne pouvez pas poster dans ce fil car cette page de discussion a été protégée contre les réponses à ses fils.',
	'lqt-protected-newthread' => 'Vous ne pouvez pas poster de nouveaux fils dans cette page de discussion car elle a été protégée contre les nouveaux fils.',
	'lqt-edit-bump' => 'Réactiver ce fil',
	'lqt-edit-bump-tooltip' => 'Déplacer ce fil en haut de la page de discussion.',
	'lqt-historicalrevision-error' => 'La révision que vous avez sélectionné est corrompue et ne peut pas être affichée.',
	'lqt-reply-subpage' => 'répondre',
	'nstab-thread' => 'Fil de discussion',
	'nstab-summary' => 'Résumé',
);

/** Franco-Provençal (Arpetan)
 * @author Cedric31
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'lqt-desc' => 'Apond des fils de discussion dens les pâges de discussion.',
	'lqt_movethread' => 'Dèplaciér lo fil vers una ôtra pâge',
	'lqt_deletethread' => 'Suprimar ou ben refâre lo fil',
	'lqt_contents_title' => 'Sujèts',
	'lqt_toc_thread_title' => 'Titro du fil',
	'lqt_toc_thread_author' => 'Lanciê per',
	'lqt_toc_thread_replycount' => 'Rèponses',
	'lqt_toc_thread_modified' => 'Dèrriér changement',
	'lqt_add_header' => 'Apondre un en-téta',
	'lqt_new_thread' => 'Lanciér una novèla discussion',
	'lqt_invalid_subject' => 'Lo sujèt que vos éd buchiê est envalido.
Pôt :
* étre trop long, ou ben
* entrar en conflit avouéc un prèfixo entèrvouiqui ou ben un èspâço de noms.',
	'lqt_empty_subject' => 'Vos dête buchiér un sujèt.',
	'lqt_reply' => 'Rèpondre',
	'lqt-parent' => 'Parent',
	'lqt_delete' => 'Suprimar',
	'lqt_undelete' => 'Refâre',
	'lqt_permalink' => 'Lim de vers',
	'lqt_fragment' => 'Bocon d’una $1 dessus $2',
	'lqt_discussion_link' => 'discussion',
	'lqt_from_talk' => 'De $1',
	'lqt-history-title' => 'Historico du fil',
	'lqt_hist_comment_edited' => 'Tèxto de comentèro [$2 changiê]',
	'lqt_hist_summary_changed' => 'Rèsumâ changiê',
	'lqt_hist_reply_created' => '[[$1|Rèponsa novèla]] fêta',
	'lqt_hist_thread_created' => 'Fil novél fêt',
	'lqt_hist_deleted' => 'Suprimâ',
	'lqt_hist_undeleted' => 'Refêt',
	'lqt_hist_moved_talkpage' => 'Dèplaciê',
	'lqt_hist_listing_subtitle' => 'Visualisacion d’un historico',
	'lqt_hist_view_whole_thread' => 'Vêre l’historico de tot lo fil',
	'lqt_hist_no_revisions_error' => 'Ceti fil at gins d’historico de vèrsions.',
	'lqt_hist_past_last_page_error' => 'Vos éd dèpassâ lo nombro de pâges de l’historico.',
	'lqt_hist_tooltip_newer_disabled' => 'Ceti lim est inactif perce que vos éte sur la premiére pâge.',
	'lqt_hist_tooltip_older_disabled' => 'Ceti lim est inactif perce que vos éte sur la dèrriére pâge.',
	'lqt_hist_split' => 'Rèponsa dèpondua dens un fil de discussion novél',
	'lqt_hist_edited_subject' => 'Sujèt changiê de « $2 » a « $3 »',
	'lqt_hist_edited_subject_corrupt' => 'Sujèt changiê',
	'lqt_hist_merged_from' => '[[$1|Rèponsa]] dèplaciê dens un ôtro fil de discussion',
	'lqt_hist_merged_to' => '[[$1|Rèponsa]] dèplaciê dês un ôtro fil de discussion',
	'lqt_hist_split_from' => 'Dèpondre vers un fil de discussion novél',
	'lqt_hist_root_blanked' => 'Tèxto de comentèro suprimâ',
	'lqt_hist_adjusted_sortkey' => 'Posicion du fil de discussion changiê',
	'lqt_revision_as_of' => 'Vèrsion en dâta du $2 a $3.',
	'lqt_change_new_thread' => 'O est la premiére vèrsion du fil.',
	'lqt_change_reply_created' => 'Lo [$1 comentèro en surbrilyence] at étâ fêt dens ceta vèrsion.',
	'lqt_change_edited_root' => 'Lo [$1 comentèro en surbrilyence] at étâ changiê dens ceta vèrsion.',
	'lqt_change_edited_summary' => 'Lo rèsumâ du fil de discussion at étâ changiê',
	'lqt_change_deleted' => '[$1 Ceti fil de discussion] ou ben son parent at étâ suprimâ',
	'lqt_change_undeleted' => 'Lo [$1 pôste en surbrilyence] at étâ refêt',
	'lqt_change_moved' => '[$1 Ceti fil de discussion] at étâ dèplaciê vers una ôtra pâge de discussion',
	'lqt_change_split' => '[$1 Ceti fil de discussion] at étâ dèpondu d’un ôtro fil de discussion',
	'lqt_change_edited_subject' => 'Lo sujèt de ceti fil de discussion at étâ changiê de « $2 » en « $3 »',
	'lqt_change_merged_from' => 'Una [$1 rèponsa] a ceti fil de discussion at étâ dèplaciê vers un ôtro fil de discussion',
	'lqt_change_merged_to' => 'La [$1 rèponsa en surbrilyence] at étâ dèplaciê dês un ôtro fil de discussion',
	'lqt_change_split_from' => 'Una [$1 sot-branche] de ceti fil de discussion at étâ dèpondua dens son prôpro fil de discussion',
	'lqt_change_root_blanked' => 'Lo tèxto d’un [$1 comentèro] at étâ suprimâ.',
	'lqt_youhavenewmessages' => 'Vos avéd [[$1|mèssâjos novéls]].',
	'lqt_protectedfromreply' => 'Ceti fil at étâ $1. Vos y pouede pas rèpondre.',
	'lqt_protectedfromreply_link' => 'protègiê',
	'lqt_subject' => 'Sujèt :',
	'lqt_noreason' => 'Gins de rêson balyê.',
	'lqt_thread_deleted_for_sysops' => "Ceti fil at étâ '''suprimâ''' et pués solament los administrators lo pôvont vêre.",
	'lqt_thread_deleted' => 'Ceti fil at étâ suprimâ.',
	'lqt_summary_notice' => 'Y at avu gins de changement dens ceta discussion dês u muens $2 jorn{{PLURAL:$2||s}}.
S’el at étâ concllua, vos pouede avêr fôta de $1.',
	'lqt_summary_notice_link' => 'ècrire un rèsumâ',
	'lqt_summary_label' => 'Rèsumâ du fil :',
	'lqt_summary_subtitle' => 'Rèsumâ de « $1 »',
	'lqt_nosuchrevision' => 'Niona vèrsion por ceti fil corrèspond.',
	'lqt_nosuchthread' => 'Lo fil que vos éd spècefiâ ègziste pas.',
	'lqt_nosuchthread_title' => 'Lo fil est entrovâblo',
	'lqt_threadrequired' => 'Vos dête spècefiar un fil dens l’URL.',
	'lqt_move_movingthread' => '$1 en dèplacement.
Ceti fil est avouéc $2.',
	'lqt_move_torename' => 'Por renomar ceti fil, $1 et pués changiér lo champ « Sujèt ».',
	'lqt_move_torename_edit' => 'lo changiér',
	'lqt_move_destinationtitle' => 'Titro de la pâge de discussion finala :',
	'lqt_move_move' => 'Dèplaciér',
	'lqt_move_nodestination' => 'Vos dête spècefiar una dèstinacion.',
	'lqt_move_thread_bad_destination' => 'La pâge de dèstinacion est pas una pâge de discussion.',
	'lqt_move_samedestination' => 'Lo fil est ja sur ceta pâge !',
	'lqt_move_noreason' => 'Gins de rêson balyê.',
	'lqt_move_success' => 'Lo fil at étâ dèplaciê dens $1.',
	'lqt_delete_undeletethread' => 'Refâre ceti fil',
	'lqt_delete_partof' => "Ceti fil est avouéc '''$1'''.",
	'lqt_delete_deleting' => "Suprèssion du fil '''$1''' et de '''totes les rèponses''' associyês.",
	'lqt_delete_deletethread' => 'Suprimar lo fil et ses rèponses',
	'lqt_delete_deleted' => 'Lo fil at étâ suprimâ.',
	'lqt_delete_undeleted' => 'Lo fil at étâ refêt.',
	'lqt_delete_return' => 'Tornar a $1.',
	'lqt_delete_return_link' => 'la pâge de discussion',
	'lqt_delete_unallowed' => 'Vos avéd pas los drêts por suprimar des fils.',
	'lqt_delete_show_checkbox' => 'Fâre vêre los fils suprimâs',
	'lqt_talkpage_autocreate_summary' => 'Pâge de discussion fêta ôtomaticament quand lo premiér fil de discussion at étâ mandâ.',
	'lqt_header_warning_big' => 'Vos changiéd un $1.',
	'lqt_header_warning_after_big' => 'Los en-tétes sont por les anonces et les prèfaces.
Vos devriâd a la place $2.',
	'lqt_header_warning_bold' => 'en-téta d’una pâge de discussion',
	'lqt_header_warning_new_discussion' => 'lanciér un fil de discussion novél',
	'lqt_sorting_order' => 'Ôrdre de tri :',
	'lqt_sort_newest_changes' => 'en comencient per los dèrriérs changiês',
	'lqt_sort_newest_threads' => 'en comencient per los fils de discussion los ples novéls',
	'lqt_sort_oldest_threads' => 'en comencient per los fils de discussion los ples vielys',
	'lqt-title' => 'Titro',
	'lqt-summary' => 'Rèsumâ',
	'lqt-searching' => 'Rechèrche des fils de discussion',
	'lqt-read-message' => 'Marcar coment liesu',
	'lqt-read-message-tooltip' => 'Enlevar ceti fil des mèssâjos novéls.
Serat adés visiblo dens sa pâge de discussion originâla.',
	'lqt-read-all' => 'Marcar tot coment liesu',
	'lqt-read-all-tooltip' => 'Enlevar tôs los fils des mèssâjos novéls.
Seront adés visiblos sur lor pâge de discussion originâla.
Ceta opèracion est revèrsibla.',
	'lqt-marked-read' => "Fil de discussion '''$1''' marcâ coment liesu.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mèssâjo marcâ coment liesu|mèssâjos marcâs coment liesus}}.',
	'lqt-email-undo' => 'Dèfâre',
	'lqt-no-new-messages' => 'Y at gins de mèssâjo por vos.',
	'lqt-new-messages' => '✒ Vos avéd de mèssâjos novéls.',
	'lqt-email-info-undo' => 'Rètablir lo fil que vos vegnéd justo d’enlevar.',
	'lqt-date-info' => 'Ceti lim est dèsactivâ perce que vos éte aprés vêre los fils dês totes les dâtes.',
	'lqt-newmessages-context' => 'Fil complèt',
	'lqt-thread-created' => 'Fêt',
	'lqt-history-time' => 'Hora',
	'lqt-history-user' => 'Utilisator',
	'lqt-history-action' => 'Activitât',
	'lqt-history-comment' => 'Comentèro',
	'lqt-history-thread' => 'Fil de discussion',
	'lqt-thread-edited-author' => 'Changiê per l’ôtor.<br />
Dèrriér changement : $1',
	'lqt-thread-edited-others' => 'Changiê per {{PLURAL:$2|un ôtro utilisator|$2 utilisators}}.<br />
Dèrriér changement : $1',
	'lqt-header-actions' => 'Accions',
	'lqt_summarize_link' => 'Rèsumar',
	'lqt-summarize-intro' => 'Rèsumar lo sujèt ce-dessus dens la bouèta d’èdicion.
Vos pouede utilisar un vouiquitèxto quint que seye dens voutron rèsumâ.
Quand vos éd chavonâ, clicâd dessus « {{int:savearticle}} ».',
	'lqt-thread-split' => 'Dèpondre vers un fil novél',
	'lqt-split-success' => 'Vos éd dèpondu avouéc reusséta lo fil $1.',
	'lqt_split_thread' => 'Dèpondre un fil',
	'lqt-thread-split-subject' => 'Sujèt du fil novél :',
	'lqt-thread-split-thread' => 'Fil :',
	'lqt-split-submit' => 'Dèpondre',
	'lqt_split_badsubject' => 'Lo sujèt que vos éd buchiê est envalido.',
	'lqt-no-threads' => 'Y at p’oncor de fil de discussion sur ceta pâge.',
	'lqt-delete-parent-warning' => 'O est un fil de discussion d’hôt nivél que contint des rèponses.
Ses rèponses seront asse-ben suprimâs ôtomaticament.
Por èvitar cen, dèpondéd-les de ceti fil de discussion devant que suprimar ceti.',
	'lqt-delete-parent-deleted' => 'Fil de discussion parent suprimâ ($1)',
	'lqt-delete-replies-done' => 'Totes les rèponses a ceti fil de discussion ont asse-ben étâ suprimâs.',
	'lqt-movethread' => 'Dèplaciér',
	'lqt-menu-trigger' => 'Més',
	'lqt-newmessages-from' => 'Dês $1',
	'lqt-hot-topics' => 'Sujèts broulants',
	'lqt-add-reply' => 'Apondre una rèponsa',
	'lqt_rc_new_discussion' => 'at pôstâ un fil novél « $1 »',
	'lqt_rc_new_reply' => 'at pôstâ una rèponsa a « $1 »',
	'right-lqt-split' => 'Dèpondre los fils de discussion',
	'right-lqt-merge' => 'Fusionar los fils de discussion',
	'lqt-thread-merge' => 'Fusionar dens un ôtro fil',
	'lqt-thread-merge-to' => 'Fusionar dens ceti fil',
	'lqt_merge_thread' => 'Fusionar lo fil',
	'lqt-thread-merge-source' => 'Fil sôrsa :',
	'lqt-thread-merge-dest' => 'Fil de dèstinacion :',
	'lqt-merge-submit' => 'Fusionar',
	'lqt-merge-success' => 'Vos éd fusionâ avouéc reusséta lo fil de discussion $1 dedens $2.',
	'lqt-log-name' => 'Jornal des fils de discussion',
	'lqt-log-header' => 'Ceti jornal dètalye les accions fêtes sur los fils de discussion.',
	'lqt-log-action-move' => 'at dèplaciê [[$1]] de [[$2]] vers [[$3]].',
	'lqt-log-action-split' => 'at dèpondu [[$1]] desot [[$3]], avouéc lo sujèt novél « $2 »',
	'lqt-log-action-merge-across' => 'at dèplaciê [[$1]] dês desot [[$2]] a desot [[$3]]',
	'lqt-log-action-merge-down' => 'at fusionâ [[$1]] en-desot de [[$3]]',
	'lqt-log-action-subjectedit' => 'at changiê lo sujèt de [[$1]] de « $2 » a « $3 »',
	'lqt-log-action-resort' => 'at changiê l’ôrdre de tri de [[$1]]. La cllâf de tri at étâ changiê de « $2 » a « $3 »',
	'lqt-preference-notify-talk' => 'M’avèrtir per mèssageria èlèctronica quand una rèponsa sur un sujèt que siuvo',
	'lqt-preference-watch-threads' => 'Siuvre los fils de discussion que fé ou ben uxquints participo',
	'prefs-lqt' => 'Discussions en fil',
	'lqt-preference-display-depth' => 'Provondior la ples granta de les rèponses a fâre vêre :',
	'lqt-preference-display-count' => 'Nombro lo ples grant de rèponses a fâre vêre :',
	'lqt-preference-custom-signatures' => 'Montrar les signatures pèrsonalisâs ux utilisators',
	'lqt-enotif-subject-reply' => 'Discussion dessus {{SITENAME}} - Rèponsa : $1',
	'lqt-enotif-subject-newthread' => 'Discussion dessus {{SITENAME}} - Sujèt novél : $1',
	'lqt-enotif-newthread' => 'Bonjorn $1,

O est una notificacion de {{SITENAME}}, qu’endique qu’un sujèt novél sur $5, « $2 »,
at étâ fêt lo $3 a $4 per $8.

Vos lo pouede vêre a <$6>

Lo tèxto est :
$7',
	'lqt-enotif-reply' => 'Bonjorn $1,

O est una notificacion de {{SITENAME}}, qu’una rèponsa novèla a « $2 » sur $5
at étâ fêta lo $3 a $4 per $8.

Vos la pouede vêre sur <$6>

Lo tèxto de la rèponsa est :
$7',
	'lqt-quote-intro' => 'Lo $2 a $3, [[User:$1|$1]] at ècrit :',
	'lqt-quote' => 'Citar',
	'lqt-search-legend' => 'Rechèrchiér des discussions sur ceta pâge',
	'lqt-search-label' => 'Tèrmos de rechèrche :',
	'lqt-search-button' => 'Rechèrchiér',
	'searchprofile-threads' => 'Discussions',
	'searchprofile-threads-tooltip' => 'Rechèrchiér dens los fils de discussion et les pâges de discussion',
	'lqt-ajax-updated' => 'Ceti fil at de mèssâjos novéls.',
	'lqt-ajax-update-link' => 'Betar a jorn',
	'lqt-thread-show-replies' => 'Montrar $1 rèpons{{PLURAL:$1|a|es}}',
	'lqt-thread-show-more' => 'Montrar més de rèponses',
	'lqt-thread-link-url' => 'URL du lim :',
	'lqt-thread-link-title' => 'Lim vouiquitèxto :',
	'lqt-thread-link-copy' => 'Copiyér dens lo prèssa-papiérs',
	'lqt-sign-not-necessary' => 'O est pas nècèssèro de signér voutron pôste avouéc quatro tildes.
La signatura est montrâ ôtomaticament.',
	'lqt-marked-as-read-placeholder' => 'Lo fil $1 at étâ marcâ coment liesu.',
	'lqt-change-subject' => 'Changiér lo sujèt',
	'lqt-save-subject' => 'Sôvar',
	'lqt-save-subject-failed' => 'Ceta èrror est arrevâ pendent la tentativa de changement de sujèt de ceti fil : $1',
	'lqt-ajax-invalid-subject' => 'Lo sujèt que vos éd spècefiâ est envalido, probâblament perce que trop long.',
	'lqt-ajax-no-subject' => 'Vos dête spècefiar un sujèt por lo fil de discussion novél.',
	'lqt-save-subject-error-unknown' => 'Una èrror encognua est arrevâ pendent la dèfinicion du sujèt de ceti fil. Volyéd èprovar en cliquent « changiér » sur lo mèssâjo du d’amont.',
	'lqt-cancel-subject-edit' => 'Anular',
	'lqt-drag-activate' => 'Dèplaciér vers la novèla posicion',
	'lqt-drag-drop-zone' => 'Dèposar ique',
	'lqt-drag-confirm' => 'Por chavonar cetes accions, volyéd balyér una rêson et pués clicar dessus « Confirmar ».',
	'lqt-drag-reparent' => 'Dèplaciér lo mèssâjo desot un parent novél.',
	'lqt-drag-split' => 'Dèplaciér lo mèssâjo vers son prôpro fil de discussion',
	'lqt-drag-setsortkey' => 'Changiér la posicion du mèssâjo dens la pâge',
	'lqt-drag-bump' => 'Dèplaciér lo mèssâjo vers lo d’amont de la pâge de discussion',
	'lqt-drag-save' => 'Confirmar',
	'lqt-drag-title' => 'Confirmar la glissâda',
	'lqt-drag-reason' => 'Rêson :',
	'lqt-drag-subject' => 'Sujèt du fil de discussion novél (oblegatouèro) :',
	'lqt-edit-signature' => '(changiér la signatura)',
	'lqt-preview-signature' => '(prèvisualisar)',
	'lqt-feed-title-all' => '{{SITENAME}} — Mèssâjos novéls',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Mèssâjos novéls de $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Fils de discussion novéls',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Fils de discussion novéls de $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Rèponses',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Rèponses de $1',
	'lqt-feed-new-thread-intro' => 'Fil de discussion novél dessus $1 postâ per $2',
	'lqt-feed-reply-intro' => 'Rèponsa a $3 (dessus $1) postâ per $2',
	'lqt-newmessages-n' => 'Mèssâjos novéls ($1)',
	'lqt_newmessages' => 'Mèssâjos novéls (nion)',
	'lqt_newmessages-title' => 'Mèssâjos novéls',
	'lqt-newpost-summary' => 'Fil de discussion novél : $1',
	'lqt-reply-summary' => 'Rèpondre a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historico de la pâge de discussion',
	'lqt-talkpage-history-subtitle' => 'Por $1',
	'lqt-talkpage-history-tab' => 'En-téta',
	'restriction-reply' => 'Postar des rèponses',
	'restriction-newthread' => 'Postar des fils de discussion novéls',
	'lqt-protected-reply-thread' => 'Vos pouede pas postar dens ceti fil de discussion perce qu’il at étâ protègiê contre los mèssâjos novéls.',
	'lqt-protected-reply-talkpage' => 'Vos pouede pas postar dens ceti fil de discussion perce que ceta pâge de discussion at étâ protègiê contre les rèponses a sos fils.',
	'lqt-protected-newthread' => 'Vos pouede pas postar des fils de discussion novéls dens ceta pâge de discussion perce qu’el at étâ protègiê contre los fils novéls.',
	'lqt-edit-bump' => 'Reactivar ceti fil',
	'lqt-edit-bump-tooltip' => 'Dèplaciér ceti fil d’amont la pâge de discussion',
	'lqt-historicalrevision-error' => 'La vèrsion que vos éd chouèsia est corrompua et pôt pas étre montrâ.',
	'lqt-reply-subpage' => 'rèpondre',
	'nstab-thread' => 'Fil de discussion',
	'nstab-summary' => 'Rèsumâ',
);

/** Friulian (Furlan)
 * @author Klenje
 */
$messages['fur'] = array(
	'lqt_contents_title' => 'Contignûts',
	'lqt_toc_thread_author' => 'Scomençât di',
	'lqt_toc_thread_replycount' => 'Rispuestis',
	'lqt_toc_thread_modified' => 'Ultin cambiament',
	'lqt_new_thread' => 'Scomence une gnove discussion',
	'lqt_empty_subject' => 'Tu scugnis zontâ un sogjet.',
	'lqt_reply' => 'Rispuint',
	'lqt_delete' => 'Elimine',
	'lqt_permalink' => 'Leam permanent',
	'lqt_discussion_link' => 'discussion',
	'lqt_from_talk' => 'Di $1',
	'lqt_hist_deleted' => 'Eliminât',
	'lqt_revision_as_of' => 'Version dal $2 a lis $3.',
	'lqt_youhavenewmessages' => 'Tu âs [[$1|gnûfs messaçs]].',
	'lqt_subject' => 'Sogjet:',
	'lqt_summary_notice_link' => 'scrîf un somari',
	'lqt_summary_subtitle' => 'Somari di "$1"',
	'lqt_move_move' => 'Môf',
	'lqt_delete_return' => 'Torne a $1.',
	'lqt_header_warning_new_discussion' => 'scomence une gnove discussion',
	'lqt_sorting_order' => 'Met in ordin par:',
	'lqt_sort_newest_changes' => 'prime chei cambiâts par ultins',
	'lqt-title' => 'Titul',
	'lqt-summary' => 'Somari',
	'lqt-read-message' => 'Segne come let',
	'lqt-read-all' => 'Segne dut come let',
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|messaç segnât come let|messaçs segnâts come lets}}.',
	'lqt-email-undo' => 'Anule',
	'lqt-no-new-messages' => 'Nissun gnûf messaç par te.',
	'lqt-new-messages' => '✒ Tu âs gnûfs messaçs.',
	'lqt-thread-created' => 'Creât',
	'lqt-history-time' => 'Date e ore',
	'lqt-history-user' => 'Utent',
	'lqt-history-action' => 'Ativitât',
	'lqt-history-comment' => 'Coment',
	'lqt-thread-edited-author' => 'Cambiât dal autôr<br />
Ultin cambiament: $1',
	'lqt-thread-edited-others' => 'Cambiât di {{PLURAL:$2|un altri utent|$2 utents}}.<br />
Ultin cambiament: $1',
	'lqt-header-actions' => 'Azions',
	'lqt_summarize_link' => 'Sunte',
	'lqt-movethread' => 'Môf',
	'lqt-menu-trigger' => 'Plui',
	'lqt-newmessages-from' => 'Di $1',
	'lqt-hot-topics' => 'Argoments popolârs',
	'lqt-add-reply' => 'Zonte une rispueste',
	'lqt-search-button' => 'Cîr',
	'lqt-ajax-update-link' => 'Inzorne',
	'lqt-thread-show-replies' => 'Mostre {{PLURAL:$1|une rispueste|$1 rispuestis}}',
	'lqt-thread-show-more' => 'Mostre plui rispuestis',
	'lqt-thread-link-url' => 'URL dal leam:',
	'lqt-thread-link-copy' => 'Copie tai aponts',
	'lqt-change-subject' => 'Cambie il sogjet',
	'lqt-save-subject' => 'Salve',
	'lqt-cancel-subject-edit' => 'Scancele',
	'lqt-drag-save' => 'Conferme',
	'lqt-drag-reason' => 'Reson:',
	'lqt-edit-signature' => '(cambie la firme)',
	'lqt-preview-signature' => '(anteprime)',
	'lqt-feed-title-replies' => '{{SITENAME}} — Rispuestis',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Rispuestis di $1',
	'lqt-newmessages-n' => 'Gnûfs messaçs ($1)',
	'lqt_newmessages' => 'I miei messaçs gnûfs',
	'lqt_newmessages-title' => 'Gnûfs messaçs',
	'lqt-reply-summary' => 'Rispueste a [[$2|$1]]',
	'lqt-talkpage-history-subtitle' => 'PAr $1',
	'lqt-reply-subpage' => 'rispuint',
	'nstab-summary' => 'Somari',
);

/** Western Frisian (Frysk)
 * @author Snakesteuben
 */
$messages['fy'] = array(
	'lqt_delete' => 'Wiskje',
	'lqt_move_move' => 'Werneam',
);

/** Traditional Gan script (‪贛語(繁體)‬)
 * @author Symane
 */
$messages['gan-hant'] = array(
	'lqt-search-button' => '尋吖',
);

/** Galician (Galego)
 * @author Alma
 * @author Toliño
 * @author Xosé
 */
$messages['gl'] = array(
	'lqt-desc' => 'Engadir fíos de discusión a páxinas de conversa',
	'lqt_movethread' => 'Mover o fío a outra páxina',
	'lqt_deletethread' => 'Borrar ou restaurar o fío',
	'lqt_contents_title' => 'Contidos',
	'lqt_toc_thread_title' => 'Título do fío',
	'lqt_toc_thread_author' => 'Iniciado por',
	'lqt_toc_thread_replycount' => 'Respostas',
	'lqt_toc_thread_modified' => 'Última modificación',
	'lqt_add_header' => 'Engadir unha cabeceira',
	'lqt_new_thread' => 'Comezar un novo debate',
	'lqt_invalid_subject' => 'O asunto que introduciu non é válido. Pode:
* ser demasiado longo ou
* haber un conflito cos prefixos interwiki ou os nomes dos espazos de nomes.',
	'lqt_empty_subject' => 'Debe inserir un asunto.',
	'lqt_reply' => 'Responder',
	'lqt-parent' => 'Pai',
	'lqt_delete' => 'Eliminar',
	'lqt_undelete' => 'Recuperar',
	'lqt_permalink' => 'Ligazón a',
	'lqt_fragment' => 'Fragmento dunha $1 de $2',
	'lqt_discussion_link' => 'conversa',
	'lqt_from_talk' => 'De $1',
	'lqt-history-title' => 'Historial do fío',
	'lqt_hist_comment_edited' => '[$2 Editouse] o texto do comentario',
	'lqt_hist_summary_changed' => 'Modificouse o resumo',
	'lqt_hist_reply_created' => 'Creouse unha [[$1|nova resposta]]',
	'lqt_hist_thread_created' => 'Creouse un novo fío',
	'lqt_hist_deleted' => 'Eliminado',
	'lqt_hist_undeleted' => 'Recuperado',
	'lqt_hist_moved_talkpage' => 'Trasladado',
	'lqt_hist_listing_subtitle' => 'Ollando unha lista de historiais',
	'lqt_hist_view_whole_thread' => 'Ver o historial do fío completo',
	'lqt_hist_no_revisions_error' => 'Este fío non conta con revisións do historial.',
	'lqt_hist_past_last_page_error' => 'Está alén do número de páxinas de historial existentes.',
	'lqt_hist_tooltip_newer_disabled' => 'Esta ligazón está desactivada porque vostede está na primeira páxina.',
	'lqt_hist_tooltip_older_disabled' => 'Esta ligazón está desactivada porque vostede está na derradeira páxina.',
	'lqt_hist_split' => 'Resposta separada nun novo fío',
	'lqt_hist_edited_subject' => 'Modificouse o asunto de "$2" a "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Modificou o asunto',
	'lqt_hist_merged_from' => 'Moveuse a [[$1|resposta]] a outro fío',
	'lqt_hist_merged_to' => 'Moveuse a [[$1|resposta]] desde outro fío',
	'lqt_hist_split_from' => 'Separar nun novo fío',
	'lqt_hist_root_blanked' => 'Eliminou o texto do comentario',
	'lqt_hist_adjusted_sortkey' => 'Axustou a posición do fío',
	'lqt_revision_as_of' => 'Revisión como estaba o $2 ás $3.',
	'lqt_change_new_thread' => 'Esta é a revisión inicial do fío.',
	'lqt_change_reply_created' => 'O [$1 comentario destacado] foi creado nesta revisión.',
	'lqt_change_edited_root' => 'O [$1 comentario destacado] foi editado nesta revisión.',
	'lqt_change_edited_summary' => 'Modificouse o resumo do fío',
	'lqt_change_deleted' => '[$1 Este fío] ou unha resposta a el foi borrado',
	'lqt_change_undeleted' => 'Restaurouse o [$1 comentario destacado]',
	'lqt_change_moved' => '[$1 Este fío] moveuse a outra páxina de conversa',
	'lqt_change_split' => '[$1 Este fío] separouse doutro fío',
	'lqt_change_edited_subject' => 'O asunto deste fío modificouse de "$2" a "$3"',
	'lqt_change_merged_from' => 'Moveuse a outro fío unha [$1 resposta] a este',
	'lqt_change_merged_to' => 'A [$1 resposta destacada] moveuse desde outro fío',
	'lqt_change_split_from' => 'Un [$1 subfío] deste fío separouse nun fío de seu',
	'lqt_change_root_blanked' => 'O texto [$1 dun comentario] foi eliminado.',
	'lqt_youhavenewmessages' => 'Ten [[$1|mensaxes novas]].',
	'lqt_protectedfromreply' => 'Este fío de conversa foi de $1 desde que se respondeu a.',
	'lqt_protectedfromreply_link' => 'protexido',
	'lqt_subject' => 'Asunto:',
	'lqt_noreason' => 'Non se deu ningunha razón.',
	'lqt_move_placeholder' => 'Este fío é un substituto que indica que outro fío, $1, foi movido desta páxina.
Este traslado realizouno $2 o $3 ás $4. Agora o fío está en $5.',
	'lqt_thread_deleted_for_sysops' => "Este fío foi '''borrado''' e só pode ser visto polos administradores.",
	'lqt_thread_deleted' => 'Este fío foi eliminado.',
	'lqt_summary_notice' => 'Non houbo modificacións nesta conversa en, polo menos, {{PLURAL:$2|un día|$2 días}}.
Se xa foi rematada, ao mellor quere $1.',
	'lqt_summary_notice_link' => 'escribir un resumo',
	'lqt_summary_label' => 'Resumo do fío:',
	'lqt_summary_subtitle' => 'Resumo de "$1"',
	'lqt_nosuchrevision' => 'Non existe tal revisión neste fío.',
	'lqt_nosuchthread' => 'O fío que especificou non existe.',
	'lqt_nosuchthread_title' => 'Non existe tal fío',
	'lqt_threadrequired' => 'Ten que especificar un fío no URL.',
	'lqt_move_movingthread' => 'Está a piques de mover "$1".
Este fío forma parte de "$2".',
	'lqt_move_torename' => 'Para mudarlle o nome a este fío, $1 e cambie o campo "Asunto".',
	'lqt_move_torename_edit' => 'edíteo',
	'lqt_move_destinationtitle' => 'Título da páxina de conversa de destino:',
	'lqt_move_move' => 'Mover',
	'lqt_move_nodestination' => 'Ten que indicar un destino.',
	'lqt_move_thread_bad_destination' => 'A páxina de destino non é unha páxina de conversa.',
	'lqt_move_samedestination' => 'O fío xa está nesta páxina!',
	'lqt_move_noreason' => 'Non se deu ningunha razón.',
	'lqt_move_success' => 'O fío moveuse a $1.',
	'lqt_delete_undeletethread' => 'Restaurar o fío',
	'lqt_delete_partof' => "Este fío forma parte de '''$1'''.",
	'lqt_delete_deleting' => "Borrando '''$1''' e '''todas as respostas''' asociadas.",
	'lqt_delete_deletethread' => 'Eliminar o fío e as súas respostas',
	'lqt_delete_deleted' => 'Eliminouse o fío.',
	'lqt_delete_undeleted' => 'Recuperouse o fío.',
	'lqt_delete_return' => 'Volver $1.',
	'lqt_delete_return_link' => 'á páxina de conversa',
	'lqt_delete_unallowed' => 'Non lle está permitido eliminar fíos.',
	'lqt_delete_show_checkbox' => 'Amosar os fíos borrados',
	'lqt_talkpage_autocreate_summary' => 'Páxina de conversa creada automaticametne cando se publicou o primeiro fío.',
	'lqt_header_warning_big' => 'Está editando a $1.',
	'lqt_header_warning_after_big' => 'As cabeceiras son para a introdución e os avisos.
É posíbel que no canto disto queira $2.',
	'lqt_header_warning_bold' => 'cabeceira dunha páxina de conversa',
	'lqt_header_warning_new_discussion' => 'comezar unha nova conversa',
	'lqt_sorting_order' => 'Organizar:',
	'lqt_sort_newest_changes' => 'os últimos modificados primeiro',
	'lqt_sort_newest_threads' => 'os novos fíos primeiro',
	'lqt_sort_oldest_threads' => 'os fíos máis vellos primeiro',
	'lqt-title' => 'Título',
	'lqt-summary' => 'Resumo',
	'lqt-searching' => 'Procurando fíos de conversa',
	'lqt-read-message' => 'Marcar como lido',
	'lqt-read-message-tooltip' => 'Eliminar este fío das mensaxes novas.
Poderá seguir sendo visible na súa páxina de conversa orixinal.',
	'lqt-read-all' => 'Marcar todo como lido',
	'lqt-read-all-tooltip' => 'Eliminar todos os fíos das mensaxes novas.
Poderán seguir sendo visibles nas súas páxinas de conversa orixinais.
Esta operación non se pode desfacer.',
	'lqt-marked-read' => "O fío \"'''\$1'''\" foi marcado como lido.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mensaxe marcada|mensaxes marcadas}} como {{PLURAL:$1|lida|lidas}}.',
	'lqt-email-undo' => 'Desfacer',
	'lqt-no-new-messages' => 'Non ten ningunha mensaxe nova.',
	'lqt-new-messages' => '✒ Hai mensaxes novas para vostede.',
	'lqt-email-info-undo' => 'Traer de volta o fío que acaba de rexeitar.',
	'lqt-date-info' => 'Esta ligazón está deshabilitada porque está a ver fíos de todas as datas.',
	'lqt-newmessages-context' => 'Fío completo',
	'lqt-thread-created' => 'Creado',
	'lqt-history-time' => 'Hora',
	'lqt-history-user' => 'Usuario',
	'lqt-history-action' => 'Actividade',
	'lqt-history-comment' => 'Comentario',
	'lqt-history-thread' => 'Fío',
	'lqt-thread-edited-author' => 'Editado polo autor<br />
Última edición: $1',
	'lqt-thread-edited-others' => 'Editado por {{PLURAL:$2|outro usuario|$2 usuarios}}.<br />
Última edición: o $4 ás $3',
	'lqt-header-actions' => 'Accións',
	'lqt_summarize_link' => 'Resumir',
	'lqt-summarize-intro' => 'Por favor, resuma o seguinte fío na caixa de edición.
Pode empregar calquera texto wiki no seu resumo. Ao rematar, prema en "{{int:savearticle}}".',
	'lqt-thread-split' => 'Separar nun novo fío de conversa',
	'lqt-split-success' => 'Separou con éxito o fío de conversa "$1".',
	'lqt_split_thread' => 'Separar un fío',
	'lqt-thread-split-subject' => 'Asunto do novo fío:',
	'lqt-thread-split-thread' => 'Fío:',
	'lqt-split-submit' => 'Separar',
	'lqt_split_badsubject' => 'O asunto que inseriu non é válido.',
	'lqt-no-threads' => 'Aínda non hai fíos nesta páxina.',
	'lqt-delete-parent-warning' => 'Este é un fío de alto nivel con respostas.
As súas respostas borraranse tamén automaticamente.
Para evitar isto, sepáreas deste fío antes de borralo.',
	'lqt-delete-parent-deleted' => 'Fío pai borrado ($1)',
	'lqt-delete-replies-done' => 'Todas as respostas a este fío foron tamén borradas.',
	'lqt-movethread' => 'Mover',
	'lqt-menu-trigger' => 'Máis',
	'lqt-newmessages-from' => 'De $1',
	'lqt-hot-topics' => 'Temas máis vistos',
	'lqt-add-reply' => 'Engadir unha resposta',
	'lqt_rc_new_discussion' => 'publicou un novo fío, "$1"',
	'lqt_rc_new_reply' => 'publicou unha resposta a "$1"',
	'right-lqt-split' => 'Separar fíos',
	'right-lqt-merge' => 'Fusionar fíos',
	'lqt-thread-merge' => 'Fusionar noutro fío',
	'lqt-thread-merge-to' => 'Fusionar neste fío',
	'lqt_merge_thread' => 'Fusionar o fío',
	'lqt-thread-merge-source' => 'Fío de orixe:',
	'lqt-thread-merge-dest' => 'Fío de destino:',
	'lqt-merge-submit' => 'Fusionar',
	'lqt-merge-success' => 'Fusionou con éxito o fío $1 con $2.',
	'lqt-log-name' => 'Rexistro de fíos de conversa',
	'lqt-log-header' => 'Este rexistro detalla as accións feitas nos fíos de conversa.',
	'lqt-log-action-move' => 'moveu "[[$1]]" de "[[$2]]" a "[[$3]]".',
	'lqt-log-action-split' => 'separou "[[$1]]" de debaixo de "[[$3]]", co novo asunto "$2"',
	'lqt-log-action-merge-across' => 'moveu "[[$1]]" de debaixo de "[[$2]]" a debaixo de "[[$3]]"',
	'lqt-log-action-merge-down' => 'fusionou "[[$1]]" co final de "[[$3]]"',
	'lqt-log-action-subjectedit' => 'cambiou o asunto de "[[$1]]" de "$2" a "$3"',
	'lqt-log-action-resort' => 'modificou o tipo de orde de "[[$1]]". Cambiou o tipo de clave de "$2" a "$3"',
	'lqt-preference-notify-talk' => 'Enviádeme un correo electrónico cando haxa respostas nunha conversa que estea vixiando',
	'lqt-preference-watch-threads' => 'Vixiar os fíos que creei ou aqueloutros nos que participei',
	'prefs-lqt' => 'Fíos de conversa',
	'lqt-preference-display-depth' => 'Profundidade máxima de respostas a mostrar:',
	'lqt-preference-display-count' => 'Número máximo de respostas a mostrar:',
	'lqt-preference-custom-signatures' => 'Mostrar as sinaturas personalizadas de usuario',
	'lqt-enotif-subject-reply' => 'Conversa {{SITENAME}} - Resposta: $1',
	'lqt-enotif-subject-newthread' => 'Conversa {{SITENAME}} - Novo fío: $1',
	'lqt-enotif-newthread' => 'Ola $1:

Esta é unha notificación de {{SITENAME}} que informa de que $8 creou un novo fío en $5, "$2",
o $3 ás $4.

Pode velo en <$6>

O texto é:
$7',
	'lqt-enotif-reply' => 'Ola $1:

Esta é unha notificación de {{SITENAME}} que informa de que $8 creou unha nova resposta a "$2" en $5
o $3 ás $4.

Pode vela en <$6>

O texto da resposta é:
$7',
	'lqt-quote-intro' => 'O $2 ás $3, o [[User:$1|usuario $1]] escribiu:',
	'lqt-quote' => 'Citar',
	'lqt-search-legend' => 'Procurar conversas nesta páxina',
	'lqt-search-label' => 'Procurar os termos:',
	'lqt-search-button' => 'Procurar',
	'searchprofile-threads' => 'Conversas',
	'searchprofile-threads-tooltip' => 'Procurar nos fíos e páxinas de conversa',
	'lqt-ajax-updated' => 'Este fío ten novas mensaxes.',
	'lqt-ajax-update-link' => 'Actualizar',
	'lqt-thread-show-replies' => 'Mostrar $1 {{PLURAL:$1|resposta|respostas}}',
	'lqt-thread-show-more' => 'Mostrar máis respostas',
	'lqt-thread-link-url' => 'Enderezo URL:',
	'lqt-thread-link-title' => 'Ligazón de texto wiki:',
	'lqt-thread-link-copy' => 'Copiar no portapapeis',
	'lqt-sign-not-necessary' => 'Non é necesario asinar as mensaxes con catro tiles, o software mostra automaticamente a súa sinatura.',
	'lqt-marked-as-read-placeholder' => 'O fío "$1" marcouse como lido.',
	'lqt-change-subject' => 'Cambiar o asunto',
	'lqt-save-subject' => 'Gardar',
	'lqt-save-subject-failed' => 'Ocorreu o seguinte erro ao intentar modificar o asunto deste fío: $1',
	'lqt-ajax-invalid-subject' => 'O asunto que especificou non é válido, probablemente por ser demasiado longo.',
	'lqt-ajax-no-subject' => 'Debe especificar un asunto para o novo fío.',
	'lqt-save-subject-error-unknown' => 'Produciuse un erro descoñecido ao intentar definir o asunto deste fío. Por favor, intente facelo premendo sobre "editar" no canto superior da mensaxe.',
	'lqt-cancel-subject-edit' => 'Cancelar',
	'lqt-drag-activate' => 'Arrastrar a unha nova localización',
	'lqt-drag-drop-zone' => 'Arrastrar aquí',
	'lqt-drag-confirm' => 'Para completar as seguintes accións, por favor, encha o motivo e prema en "Confirmar".',
	'lqt-drag-reparent' => 'Situar a mensaxe por debaixo dun novo pai.',
	'lqt-drag-split' => 'Mover a mensaxe a un fío de seu',
	'lqt-drag-setsortkey' => 'Axustar a posición da mensaxe na páxina',
	'lqt-drag-bump' => 'Mover a mensaxe ao comezo da páxina de conversa',
	'lqt-drag-save' => 'Confirmar',
	'lqt-drag-title' => 'Confirmar o arrastre',
	'lqt-drag-reason' => 'Motivo:',
	'lqt-drag-subject' => 'Asunto para o novo fío (obrigatorio):',
	'lqt-edit-signature' => '(editar a sinatura)',
	'lqt-preview-signature' => '(vista previa)',
	'lqt-feed-title-all' => '{{SITENAME}} — Novas mensaxes',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Novas mensaxes en $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Novos fíos',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Novos fíos en $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Respostas',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Respostas en $1',
	'lqt-feed-new-thread-intro' => 'Novo fío de conversa en "$1" publicado por $2',
	'lqt-feed-reply-intro' => 'Resposta a "$3" (en "$1") publicada por $2',
	'tooltip-pt-newmessages' => 'Mostra as mensaxes novas nos fíos ou nas páxinas de conversa que está a vixiar',
	'lqt-newmessages-n' => 'Mensaxes novas ($1)',
	'lqt_newmessages' => 'As miñas mensaxes novas (ningunha)',
	'lqt_newmessages-title' => 'Mensaxes novas',
	'lqt-newpost-summary' => 'Novo fío: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Escriba o texto do fío. Logo debería borrar esta liña.',
	'lqt-reply-summary' => 'Responder a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historial da páxina de conversa',
	'lqt-talkpage-history-subtitle' => 'De $1',
	'lqt-talkpage-history-tab' => 'Cabeceira',
	'restriction-reply' => 'Publicar respostas',
	'restriction-newthread' => 'Publicar novos fíos',
	'lqt-protected-reply-thread' => 'Non pode publicar neste fío porque foi protexido fronte a novas mensaxes.',
	'lqt-protected-reply-talkpage' => 'Non pode publicar neste fío porque esta páxina de conversa foi protexida fronte a novas respostas aos seus fíos.',
	'lqt-protected-newthread' => 'Non pode publicar novos fíos nesta páxina de conversa porque foi protexida fronte a novos fíos.',
	'lqt-edit-bump' => 'Impor este fío',
	'lqt-edit-bump-tooltip' => 'Mover este fío ao inicio da páxina de conversa',
	'lqt-historicalrevision-error' => 'A revisión que seleccionou está corrompida e non se pode ver.',
	'lqt-reply-subpage' => 'resposta',
	'nstab-thread' => 'Fío',
	'nstab-summary' => 'Resumo',
);

/** Gothic (Gothic)
 * @author Crazymadlover
 * @author Jocke Pirat
 * @author Omnipaedista
 */
$messages['got'] = array(
	'lqt_delete' => 'Taíran',
	'lqt_move_move' => 'Skiuban',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'lqt_contents_title' => 'Περιεχόμενα',
	'lqt_delete' => 'Σβεννύναι',
	'lqt_discussion_link' => 'διάλεξις',
	'lqt_hist_deleted' => 'Διεγραμμένη',
	'lqt_subject' => 'Χρῆμα:',
	'lqt_move_move' => 'Κινεῖν',
	'lqt_delete_return' => 'Ἐπανιέναι εἰς $1.',
	'lqt-title' => 'Ἐπιγραφή',
	'lqt-summary' => 'Σύνοψις',
	'lqt-thread-created' => 'Ποιηθέν',
	'lqt-history-time' => 'Χρόνος',
	'lqt-history-user' => 'Χρώμενος',
	'lqt-history-comment' => 'Σχόλιον',
	'lqt-header-actions' => 'Δράσεις',
	'lqt-thread-split-thread' => 'Νῆμα διαλέξεως:',
	'lqt-search-button' => 'Ζητεῖν',
	'lqt-ajax-update-link' => 'Ἐνημεροῦν',
	'lqt_newmessages' => 'Νέαι ἀγγέλιαι',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 * @author Purodha
 */
$messages['gsw'] = array(
	'lqt-desc' => 'Diskussionssträng uf Diskussionssyte bruuche',
	'lqt_movethread' => 'Diskussionsstrang uf e anderi Syte verschiebe',
	'lqt_deletethread' => 'Diskussionsstrang lesche oder widerhärstelle',
	'lqt_contents_title' => 'Inhalt',
	'lqt_toc_thread_title' => 'Diskussionsstrangtitel',
	'lqt_toc_thread_author' => 'Aagfange vu',
	'lqt_toc_thread_replycount' => 'Antworte',
	'lqt_toc_thread_modified' => 'Zletscht gänderet',
	'lqt_add_header' => 'Iberschrift ergänze',
	'lqt_new_thread' => 'E neji Diskussion aafange',
	'lqt_invalid_subject' => 'Dr Diskussionsgegestand, wu du yygee hesch, isch nit giltig. S cha syy, ass es:
* ass er z lang isch oder
* ass es e Konflikt git mit Interwiki-Präfix oder Namensryym',
	'lqt_empty_subject' => 'Du muesch e Beträff yygee.',
	'lqt_reply' => 'Antwort gee',
	'lqt-parent' => 'Byytrag, wu des d Antwort druf isch',
	'lqt_delete' => 'Lesche',
	'lqt_undelete' => 'Widerhärstelle',
	'lqt_permalink' => 'Gleich (Link) uf',
	'lqt_fragment' => 'Fragmänt vun ere $1 vu $2',
	'lqt_discussion_link' => 'Diskussion',
	'lqt_from_talk' => 'Vu $1',
	'lqt-history-title' => 'Stranggschicht',
	'lqt_hist_comment_edited' => 'Kommentartäxt [$2 bearbeitet]',
	'lqt_hist_summary_changed' => 'Zämmefassig gänderet',
	'lqt_hist_reply_created' => '[[$1|Neji Antwort]] aagleit',
	'lqt_hist_thread_created' => 'Neje Diskussionsstrang aagleit',
	'lqt_hist_deleted' => 'Glescht',
	'lqt_hist_undeleted' => 'Widerhärgstellt',
	'lqt_hist_moved_talkpage' => 'Verschobe',
	'lqt_hist_listing_subtitle' => 'E Versionsgschicht aaluege',
	'lqt_hist_view_whole_thread' => 'Versionsgschicht vun eme ganze Diskussionsstrang aaluege',
	'lqt_hist_no_revisions_error' => 'Dää Diskussionsstrang het kei Versionsgschicht.',
	'lqt_hist_past_last_page_error' => 'Du bisch usserhalb vu dr Sytezahl, wu s git vu dr vu dr Versionsgeschichte.',
	'lqt_hist_tooltip_newer_disabled' => 'Des Gleich isch deaktiviert, weil Du uf dr erschte Syte bisch.',
	'lqt_hist_tooltip_older_disabled' => 'Des Gleich Link isch deaktiviert, weil Du uf dr letschte Syte bisch.',
	'lqt_hist_split' => 'Antwort abteile in e neje Strang',
	'lqt_hist_edited_subject' => 'S Thema isch vu „$2“ uf „$3“ gänderet wore',
	'lqt_hist_edited_subject_corrupt' => 'Diskussionsgegestand gänderet',
	'lqt_hist_merged_from' => '[[$1|Antwort]] in e andere Strang verschobe',
	'lqt_hist_merged_to' => '[[$1|Antwort]] us eme andere Strang dohär verschobe',
	'lqt_hist_split_from' => 'In e neje Strang ufteile',
	'lqt_hist_root_blanked' => 'Kommentar uusegnuu',
	'lqt_hist_adjusted_sortkey' => 'Platz vum Diskussionsstrang aapasst',
	'lqt_revision_as_of' => 'Versionsgschicht vum $2 am $3.',
	'lqt_change_new_thread' => 'Des isch di erscht Version vum Diskussionsstrang.',
	'lqt_change_reply_created' => 'Dr [$1 Kommentar], wu firighoben isch, isch in däre Version aagleit wore.',
	'lqt_change_edited_root' => 'Dr [$1 Kommentar], wu firighoben isch, isch in däre Version bearbeitet wore.',
	'lqt_change_edited_summary' => 'D Zämmefassig vum Strang isch bearbeitet wore',
	'lqt_change_deleted' => 'Dää [$1 Strang] oder e Antwort derzue isch glescht wore',
	'lqt_change_undeleted' => 'D [$1 firighobe Nochricht] isch wider härgstellt wore',
	'lqt_change_moved' => '[$1 Dää Strang] isch uf e anderi Diskussionssyte verschobe wore',
	'lqt_change_split' => '[$1 Dää Strang] isch abteilt wore us eme andere Strang',
	'lqt_change_edited_subject' => 'S Thema vu däm Strang isch vu „$2“ uf „$3“ gänderet wore',
	'lqt_change_merged_from' => 'E [$1 Antwort] zue däm Strang isch verschobe wore zuen eme andere Strang',
	'lqt_change_merged_to' => 'D [$1 firighobe Antwort] isch dohär verschobe wore vun eme andere Strang',
	'lqt_change_split_from' => 'E [$1 Unterstrang] vu däm Strang isch as eigene Strang abteilt wore',
	'lqt_change_root_blanked' => 'Dr Täxt vun [$1 eme Kommentar] isch uusegnuu wore.',
	'lqt_youhavenewmessages' => 'Du hesch [[$1|neji Nochrichte]].',
	'lqt_protectedfromreply' => 'Dää Diskussionsstrang isch $1 wore. E Antwort isch nit megli.',
	'lqt_protectedfromreply_link' => 'gschitzt',
	'lqt_subject' => 'Thema:',
	'lqt_noreason' => 'kei Grund aagee.',
	'lqt_move_placeholder' => 'Dää Diskussionsstrang isch e Platzhalter zum aazeige, ass e Diskussionsstrang, $1, vu däre Syte uf e anderi Diskussionssyte verschobe woren isch.
D Verschiebig isch gmacht wore dur $2 am $3 $4. Dr Diskussionsstrang isch jetz uf $5.',
	'lqt_thread_deleted_for_sysops' => "Dää Diskussionsstrang isch '''glescht''' woren un isch nume fir Adminischtratore sichtbar.",
	'lqt_thread_deleted' => 'Diskussionsstrang isch glescht wore.',
	'lqt_summary_notice' => 'Zue däre Diskussion git s syter $2 {{PLURAL:$2|Tag|Täg}} kei neji Byyträg.
Wänn mit dr Diskussion ufghert woren isch, mechtscht si villicht $1.',
	'lqt_summary_notice_link' => 'Zämmefassig schryybe',
	'lqt_summary_label' => 'Zämmefassig:',
	'lqt_summary_subtitle' => 'Zämmefassig vu „$1“',
	'lqt_nosuchrevision' => 'Version vum Diskussionsstrang isch nit gfunde wore.',
	'lqt_nosuchthread' => 'Dr Diskussionsstrang, wu Du aagee hesch, git s nit.',
	'lqt_nosuchthread_title' => 'Kei sonige Diskussionsstrang',
	'lqt_threadrequired' => 'In dr URL muess e Diskussionsstrang aagee wäre.',
	'lqt_move_movingthread' => '$1 verschiebe. Dää Diskussionsstrang isch e Teil vu $2.',
	'lqt_move_torename' => "Go dr Diskussionsstrang umznänne, $1 un ändere s 'Thema'.",
	'lqt_move_torename_edit' => 'bearbeit e',
	'lqt_move_destinationtitle' => 'Name vu dr Diskussionssyte:',
	'lqt_move_move' => 'Verschiebe',
	'lqt_move_nodestination' => 'S muess e Ziilsyte aagee wäre.',
	'lqt_move_thread_bad_destination' => 'D Ziilsyte isch kei Diskussionssyte.',
	'lqt_move_samedestination' => 'Dr Diskussionsstrang git s scho uf däre Syte.',
	'lqt_move_noreason' => 'kei Grund aagee.',
	'lqt_move_success' => 'Diskussionsstrang verschobe no $1.',
	'lqt_delete_undeletethread' => 'Widerhärgstellte Diskussionsstrang',
	'lqt_delete_partof' => "Dää Diskussionsstrang isch e Teil vu '''$1'''.",
	'lqt_delete_deleting' => "Leschig vu '''$1''' un '''allene Antworte''' druf.",
	'lqt_delete_deletethread' => 'Diskussionsstrang un Antworte lesche',
	'lqt_delete_deleted' => 'Dr Diskussionsstrang isch glescht wore.',
	'lqt_delete_undeleted' => 'Dr Diskussionsstrang isch widerhärgstellt wore.',
	'lqt_delete_return' => 'Zrugg zue $1.',
	'lqt_delete_return_link' => 'd Diskussionssyte',
	'lqt_delete_unallowed' => 'Du derfsch kei Diskussionssträng lesche.',
	'lqt_delete_show_checkbox' => 'Zeig gleschti Diskussionssträng',
	'lqt_talkpage_autocreate_summary' => 'Diskussionssyte automatisch mit em erschte Diskussionsstrang aagleit.',
	'lqt_header_warning_big' => 'Du bearbeitsch e $1.',
	'lqt_header_warning_after_big' => 'Kopfzyyle sin fir Aachindigen un Yyleitige.
Megligerwyys witt statt däm e $2.',
	'lqt_header_warning_bold' => 'Diskussionssyte Chopfzyyle',
	'lqt_header_warning_new_discussion' => 'neji Diskussion aafange',
	'lqt_sorting_order' => 'Sortierig:',
	'lqt_sort_newest_changes' => 'zletscht gänderete zerscht',
	'lqt_sort_newest_threads' => 'nejschte Diskussionsstrang zerscht',
	'lqt_sort_oldest_threads' => 'eltschte Diskussionsstrang zerscht',
	'lqt-title' => 'Titel',
	'lqt-summary' => 'Zämmefassig',
	'lqt-searching' => 'No Diskussionsstrang sueche',
	'lqt-read-message' => 'As gläse markiere',
	'lqt-read-message-tooltip' => 'Nimm dää Diskussionsstrang us dr neje Nochrichten use.
Är isch wyter uf dr Original-Diskussionssyte z säh.',
	'lqt-read-all' => 'Alli as gläse markiere',
	'lqt-read-all-tooltip' => 'Nimm alli Diskussionssträng vu neje Nochrichten use.
Si sin wyter uf dr Original-Diskussionssyte sichtbar.
Die Operation cha rugggängig gmacht wäre.',
	'lqt-marked-read' => "Diskussionsstrang '''$1''' isch as gläse markiert wore.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|Nochricht|Nochrichten}} as gläse markiert.',
	'lqt-email-undo' => 'Rugggängig',
	'lqt-no-new-messages' => 'Du hesch kei neji Nochrichte.',
	'lqt-new-messages' => '✒ Du hesch neji Nochrichte.',
	'lqt-email-info-undo' => 'Hol dr Diskussionsstrang zrugg, wu Du grad furtgschickt hesch.',
	'lqt-date-info' => 'Des Gleich isch nit aktiv, wel du Diskussionssträng vu allene Date aaluege.',
	'lqt-newmessages-context' => 'Ganze Strang',
	'lqt-thread-created' => 'Aagleit',
	'lqt-history-time' => 'Zyt',
	'lqt-history-user' => 'Benutzer',
	'lqt-history-action' => 'Aktivitet',
	'lqt-history-comment' => 'Kommentar',
	'lqt-history-thread' => 'Strang',
	'lqt-thread-edited-author' => 'Bearbeitet dur dr Autor<br />
Letschti Bearbeitig : $1',
	'lqt-thread-edited-others' => 'Bearbeitet dur $2 Benutzer<br />
Letschti Bearbeitig : $1',
	'lqt-header-actions' => 'Aktione',
	'lqt_summarize_link' => 'Zämmefasse',
	'lqt-summarize-intro' => 'Bitte fass dr Diskussionsstrang unte im Bearbeitigs-Chaschte zämme.
du chasch irged e Wikitekscht fir Dyy Zämmefassig bruche. Wänn Du fertig bisch, druck "{{int:savearticle}}".',
	'lqt-thread-split' => 'In e neje Diskussionstrang ufteile',
	'lqt-split-success' => 'Du hesch dr Diskussionstrang $1 erfolgrych ufteilt.',
	'lqt_split_thread' => 'E Diskussionstrang ufteile',
	'lqt-thread-split-subject' => 'Nej Diskussionsstrang-Thema:',
	'lqt-thread-split-thread' => 'Diskussionsstrang:',
	'lqt-split-submit' => 'Ufteile',
	'lqt_split_badsubject' => 'S Thema, wu du aagee hesch, isch nit giltig.',
	'lqt-no-threads' => 'S git no kei Diskussionssträng uf däre Syte.',
	'lqt-delete-parent-warning' => 'Des isch e Diskussionsstarng uf dr hegschte Ebeni mit Antworte.
D Antworte, wu derzue ghere, wäre au automatisch glescht.
Wänn du des witt verhindere, no teil si ab vum Strang, voreb du ne leschesch.',
	'lqt-delete-parent-deleted' => 'Dr ibergordnet Strang isch glescht wore ($1)',
	'lqt-delete-replies-done' => 'Alli Antworte uf dää Strang sin au glescht wore.',
	'lqt-movethread' => 'Verschiebe',
	'lqt-menu-trigger' => 'Meh',
	'lqt-newmessages-from' => 'Vu $1',
	'lqt-hot-topics' => 'Heißi Themene',
	'lqt-add-reply' => 'Antwort zuefiege',
	'lqt_rc_new_discussion' => 'het e neji Diskussion „$1“ aagfange',
	'lqt_rc_new_reply' => 'het e Antwort gee uf „$1“',
	'right-lqt-split' => 'Strang ufteile',
	'right-lqt-merge' => 'Strang zämmefiere',
	'lqt-thread-merge' => 'In e andere Strang yyfiege',
	'lqt-thread-merge-to' => 'In dää Strang yyfiege',
	'lqt_merge_thread' => 'Strang zämmefiere',
	'lqt-thread-merge-source' => 'Ursprungsstrang:',
	'lqt-thread-merge-dest' => 'Ziilstrang:',
	'lqt-merge-submit' => 'Zämefiere',
	'lqt-merge-success' => 'Du hesch dr Strang $1 erfolgrych unter $2 yygfiegt.',
	'lqt-log-name' => 'Logbuech vu dr Diskussionssträng',
	'lqt-log-header' => 'Des Logbuech lischtet Aktione uf, wu an Diskussionsträng vorgnuu wore sin.',
	'lqt-log-action-move' => 'het [[$1]] vu [[$2]] no [[$3]] verschobe.',
	'lqt-log-action-split' => 'het [[$1]] vu [[$3]] ufteilt, mit em neje Thema „$2“',
	'lqt-log-action-merge-across' => 'het [[$1]] us [[$2]] no [[$3]] verschobe',
	'lqt-log-action-merge-down' => 'het [[$1]] zäämegfiegt in [[$3]]',
	'lqt-log-action-subjectedit' => 'het s Thema vu [[$1]] gänderet vu „$2“ uf „$3“',
	'lqt-log-action-resort' => 'het d Sortierigsreihefolg vu [[$1]] gänderet vu $2 uf $3',
	'lqt-preference-notify-talk' => 'Schick mer e Mail iber Antowrte zue Diskussionssträng, wun i beobachte tue',
	'lqt-preference-watch-threads' => 'Sträng beobachte, wu ich aaleg oder e Antwort druf gib',
	'prefs-lqt' => 'Diskussionsstrang',
	'lqt-preference-display-depth' => 'Maximali Antworte-Tiefi, wu soll aazeigt wäre:',
	'lqt-preference-display-count' => 'Hegschtzahl vu Antworte, wu soll aazeigt wäre:',
	'lqt-preference-custom-signatures' => 'Signature fir fortgschritteni Benutzer aazeige',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-Diskussion - Antwort: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-Diskussion - Neje Diskussionstrang: $1',
	'lqt-enotif-newthread' => "Sali $1,
Des isch e Nochricht vu {{SITENAME}}, ass e neje Diskussionsstrang iber $5, '$2',
aagleit woren isch uf $3 am $4.
Du chasch e säh uf <$6>",
	'lqt-enotif-reply' => "Sali $1,
Des isch e Nochricht vu {{SITENAME}}, ass e neji Antwort uf '$2' iber $5,
aagleit woren isch uf $3 am $4.

Du chasch si säh uf <$6>

D Antwort isch:
$7",
	'lqt-quote-intro' => 'Am $2 am $3, het [[User:$1|$1]] gschribe:',
	'lqt-quote' => 'Zitiere',
	'lqt-search-legend' => 'Dursuech d Diskussionsbyytreg uf däre Syte',
	'lqt-search-label' => 'Suechuusdruck:',
	'lqt-search-button' => 'Sueche',
	'searchprofile-threads' => 'Diskussione',
	'searchprofile-threads-tooltip' => 'Diskussionssträng un Diskussionssyte sueche',
	'lqt-ajax-updated' => 'In däm Diskussionsstrang het s neji Byytreg.',
	'lqt-ajax-update-link' => 'Aktualisiere',
	'lqt-thread-show-replies' => '$1 Antworte zeige',
	'lqt-thread-show-more' => 'Meh Antworte zeige',
	'lqt-thread-link-url' => 'URL-Link:',
	'lqt-thread-link-title' => 'Wikitext-Link:',
	'lqt-thread-link-copy' => 'In d Zwischenablag kopiere',
	'lqt-sign-not-necessary' => 'S isch nit notwändig Dyy Byytrag mit vier Tilde z signiere.
D Signatur wird automatisch aazeigt.',
	'lqt-marked-as-read-placeholder' => 'Dr Strang $1 isch as gläse markiert wore.',
	'lqt-change-subject' => 'Thema ändere',
	'lqt-save-subject' => 'Spychere',
	'lqt-save-subject-failed' => 'Bim Versuech s Thema vu däm Strang z ändere isch dää Fähler ufträtte: $1',
	'lqt-ajax-invalid-subject' => 'S Thema, wu du yygee hesch, isch nit giltig, villicht isch s z lang.',
	'lqt-ajax-no-subject' => 'Du muesch e Thema aagee.',
	'lqt-save-subject-error-unknown' => 'Bim Versuech s Thema vu däm Strang z setze, isch e nit bekannte Fähler ufträtte. Bitte versuech des, indäm du bim oberschte Byytrag uf „Ändere“ drucksch.',
	'lqt-cancel-subject-edit' => 'Abbräche',
	'lqt-drag-activate' => 'Uf e neje Platz setze',
	'lqt-drag-drop-zone' => 'Dohär setze',
	'lqt-drag-confirm' => 'Go die Aktione abschließe gib bitte ne Grund aa un druck uf „Bstetige“.',
	'lqt-drag-reparent' => 'Byytrag unter e andre ibergordnete Strang setze',
	'lqt-drag-split' => 'Byytrag in dr eige Diskussionsstrang schiebe1',
	'lqt-drag-setsortkey' => 'Dr Platz vum Byytrag uf dr Syte aapasse',
	'lqt-drag-bump' => 'Byytrag an dr Aafang vu dr Diskussionssyte setze',
	'lqt-drag-save' => 'Bstetige',
	'lqt-drag-title' => 'Zie bstetige',
	'lqt-drag-reason' => 'Grund:',
	'lqt-drag-subject' => 'Thema vum neje Diskussionsstrang:',
	'lqt-edit-signature' => '(Unterschrift bearbeite)',
	'lqt-preview-signature' => '(Vorschau)',
	'lqt-feed-title-all' => '{{SITENAME}} — Neji Byytreg',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Neji Byytreg vu $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Neji Diskussionssträng',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Neji Diskussionssträng vu $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Antworte',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Antworte vu $1',
	'lqt-feed-new-thread-intro' => 'E neje Diskussionsstrang uf $1, aagleit vu $2',
	'lqt-feed-reply-intro' => 'Antworte uf $3 (uf $1) vu $2',
	'lqt-newmessages-n' => 'Neji Nochrichte ($1)',
	'lqt_newmessages' => 'Neji Nochrichte',
	'lqt_newmessages-title' => 'Neji Nochrichte',
	'lqt-newpost-summary' => 'Neje Diskussionstrang: $1',
	'lqt-reply-summary' => 'Anwort uf [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Diskussionssyte-Versionsgschicht',
	'lqt-talkpage-history-subtitle' => 'Fir $1',
	'lqt-talkpage-history-tab' => 'Chopfzyyle',
	'restriction-reply' => 'Antworte abschicke',
	'restriction-newthread' => 'Neji Diskussionssträng abschicke',
	'lqt-protected-reply-thread' => 'Du chasch nyt zue däm Strang byytrage, wel er gschitzt woren isch vor neje Byytreg.',
	'lqt-protected-reply-talkpage' => 'Du chasch nyt zue däm Strang byytrage, wel die Diskussionssyte gschitzt woren isch vor Antworte uf dr Sträng, wu s din het.',
	'lqt-protected-newthread' => 'Du chasch keini neji Sträng zue däre Diskussionssyte byytrage, wel si gschitzt woren isch vor neje Sträng.',
	'lqt-edit-bump' => 'Dää Strang aktiviere',
	'lqt-edit-bump-tooltip' => 'Dää Strang obe uf d Diskussionssyte derzue verschiebe',
	'lqt-historicalrevision-error' => 'D Version, wu Du uusgwehlt hesch, isch hii, un cha nit aagluegt wäre',
	'lqt-reply-subpage' => 'Antwort gee',
	'nstab-thread' => 'Diskussionsstrang',
	'nstab-summary' => 'Zämmefassig',
);

/** Gujarati (ગુજરાતી)
 * @author Dineshjk
 * @author Dsvyas
 */
$messages['gu'] = array(
	'lqt_contents_title' => 'સૂચિ',
	'lqt_add_header' => 'મથાળુ ઉમેરો',
	'lqt_new_thread' => 'નવી ચર્ચા શરૂ કરો',
	'lqt_reply' => 'પ્રત્યુત્તર',
	'lqt_delete' => 'રદ કરો',
	'lqt_undelete' => 'રદ કરેલું પાછુ લાવો',
	'lqt_permalink' => 'સ્થાયી કડી',
	'lqt_fragment' => '$2થી $1નો થોડો ભાગ',
	'lqt_discussion_link' => 'ચર્ચા',
	'lqt_from_talk' => '$1 થી',
	'lqt_hist_comment_edited' => 'ટીપ્પણીમાં ફેરફાર કર્યો છે',
	'lqt_hist_summary_changed' => 'સારાંશ બદલ્યો છે',
	'lqt_hist_deleted' => 'રદ કરવામાં આવ્યું છે',
	'lqt_hist_undeleted' => 'રદ કરેલું પાછું વાળ્યું છે',
	'lqt_hist_moved_talkpage' => 'ખસેડવામાં આવ્યું છે',
	'lqt_hist_listing_subtitle' => 'ઐતિહાસિક સૂચીકરણ જોઇ રહ્યા છો',
	'lqt_hist_past_last_page_error' => 'આપ ઈતિહાસના પ્રવર્તમાન પાનાની સંખ્યા વટાવી ચુક્યા છો',
	'lqt_hist_tooltip_newer_disabled' => 'આ લિંક કામ નહી કરે, કેમકે આપ પ્રથમ પાના પર છો',
	'lqt_hist_tooltip_older_disabled' => 'આ લિંક કામ નહી કરે, કેમકે આપ અંતિમ પાના પર છો',
	'lqt_revision_as_of' => '$2એ $3 વાગ્યા સુધીમાં થયેલાં પુનરાવર્તન.',
	'lqt_change_reply_created' => 'હાઇલાઇટ કરેલી ટિપ્પણીની રચના વર્તમાન સુધારા દરમ્યાન કરવામાં આવી છે',
	'lqt_change_edited_root' => 'હાઇલાઇટ કરેલી ટિપ્પણીમાં ફેરફાર વર્તમાન સુધારા દરમ્યાન કરવામાં આવ્યો  છે',
	'lqt_protectedfromreply_link' => 'સુરક્ષિત',
	'lqt_subject' => 'વિષય',
	'lqt_noreason' => 'કોઇ કારણ દર્શાવવામાં આવ્યું નથી',
	'lqt_summary_notice' => 'અહીં છેલ્લા {{PLURAL:$2|દિવસ|દિવસ}} દિવસથી કોઇ ફેરફાર થયા નથી. જો આ ચર્ચા પૂરી થઇ ગયેલી લાગે તો, તમે $1 શકો છો.',
	'lqt_summary_notice_link' => 'સારાંશ લખો',
	'lqt_summary_subtitle' => '$1નો સારાંશ',
	'lqt_move_torename_edit' => 'ફેરફાર કરો',
	'lqt_move_move' => 'ખસેડો',
	'lqt_move_noreason' => 'કોઇ કારણ દર્શાવવામાં આવ્યું નથી',
	'lqt_newmessages' => 'નવા સંદેશા',
);

/** Manx (Gaelg)
 * @author MacTire02
 * @author Shimmin Beg
 */
$messages['gv'] = array(
	'lqt_discussion_link' => 'resoonaght',
	'lqt_hist_deleted' => 'Scryssit',
	'lqt_summary_notice_link' => 'screeu giare-choontey',
	'lqt-drag-reason' => 'Fa:',
	'lqt_newmessages' => 'Çhaghteraghtyn noa (gyn)',
);

/** Hausa (هَوُسَ) */
$messages['ha'] = array(
	'lqt_delete' => 'Soke',
	'lqt_move_move' => 'Gusarwa',
	'lqt-summary' => 'Taƙaici',
	'lqt-movethread' => 'Gusarwa',
	'lqt-search-button' => 'Nema',
	'lqt-save-subject' => 'Nema',
	'lqt-cancel-subject-edit' => 'Soke',
	'lqt-drag-reason' => 'Dalili:',
);

/** Hakka (Hak-kâ-fa)
 * @author Hakka
 */
$messages['hak'] = array(
	'lqt_delete' => 'Chhù-thet',
);

/** Hawaiian (Hawai`i)
 * @author Kalani
 * @author Singularity
 */
$messages['haw'] = array(
	'lqt_contents_title' => 'Papa kuhikuhi',
	'lqt_discussion_link' => 'kūkākūkā',
	'lqt-summary' => 'Hōʻuluʻulu manaʻo',
	'lqt-email-undo' => 'Hoʻihoʻi mai',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'lqt-desc' => 'הוספת דיונים משורשרים לדפי השיחה',
	'lqt_movethread' => 'העברת השרשור לדף אחר',
	'lqt_deletethread' => 'מחיקת או שחזור שרשור',
	'lqt_contents_title' => 'רשימת דיונים',
	'lqt_toc_thread_title' => 'כותרת השרשור',
	'lqt_toc_thread_author' => 'נפתח על ידי',
	'lqt_toc_thread_replycount' => 'תגובות',
	'lqt_toc_thread_modified' => 'שינוי אחרון',
	'lqt_add_header' => 'הוספת כותרת',
	'lqt_new_thread' => 'התחלת דיון חדש',
	'lqt_invalid_subject' => 'הנושא שהזנתם אינו תקין.
ייתכן שהוא:
* ארוך מדי, או
* מתנגש עם קידומות בינוויקי או שמות של מרחבי שם.',
	'lqt_empty_subject' => 'יש להקליד נושא.',
	'lqt_reply' => 'תגובה',
	'lqt-parent' => 'קישור להורה',
	'lqt_delete' => 'מחיקה',
	'lqt_undelete' => 'שחזור',
	'lqt_permalink' => 'קישור קבוע',
	'lqt_fragment' => 'מקטע של $1 מתוך $2',
	'lqt_discussion_link' => 'דיון',
	'lqt_from_talk' => 'מתוך $1',
	'lqt-history-title' => 'היסטוריית השרשור',
	'lqt_hist_comment_edited' => 'טקסט ההערה [$2 נערך]',
	'lqt_hist_summary_changed' => 'התקציר שוּנה',
	'lqt_hist_reply_created' => 'נוצרה [[$1|תגובה חדשה]]',
	'lqt_hist_thread_created' => 'נוצר שרשור חדש',
	'lqt_hist_deleted' => 'נמחקה',
	'lqt_hist_undeleted' => 'שוחזרה',
	'lqt_hist_moved_talkpage' => 'הועברה',
	'lqt_hist_listing_subtitle' => 'הצגת רישום ההיסטוריה',
	'lqt_hist_view_whole_thread' => 'צפייה בהיסטוריה עבור השרשור כולו',
	'lqt_hist_no_revisions_error' => 'לשרשור זה אין גרסאות בהיסטוריה.',
	'lqt_hist_past_last_page_error' => 'אתם חורגים ממספר דפי ההיסטוריה הקיימים.',
	'lqt_hist_tooltip_newer_disabled' => 'קישור זה מבוטל כיוון שאתם בדף הראשון.',
	'lqt_hist_tooltip_older_disabled' => 'קישור זה מבוטל כיוון שאתם בדף האחרון.',
	'lqt_hist_split' => 'פיצול התגובה לשרשור חדש',
	'lqt_hist_edited_subject' => 'הנושא "$2" שוּנה אל "$3"',
	'lqt_hist_edited_subject_corrupt' => 'הנושא שוּנה',
	'lqt_hist_merged_from' => '[[$1|תגובה]] הועברה לשרשור אחר',
	'lqt_hist_merged_to' => '[[$1|תגובה]] הועברה משרשור אחר',
	'lqt_hist_split_from' => 'פיצול לשרשור חדש',
	'lqt_hist_root_blanked' => 'טקסט ההערה הוסר',
	'lqt_hist_adjusted_sortkey' => 'מיקום השרשור שונה',
	'lqt_revision_as_of' => 'גרסה מ־$3&rlm;, $2.',
	'lqt_change_new_thread' => 'זוהי הגרסה הראשונית של השרשור.',
	'lqt_change_reply_created' => '[$1 ההערה המודגשת] נוצרה בגרסה זו.',
	'lqt_change_edited_root' => '[$1 ההערה המודגשת] נערכה בגרסה זו.',
	'lqt_change_edited_summary' => 'תקציר השרשור נערך',
	'lqt_change_deleted' => '[$1 שרשור זה] או תגובה אליו נמחקו',
	'lqt_change_undeleted' => '[$1 ההודעה המודגשת] שוחזרה',
	'lqt_change_moved' => '[$1 שרשור זה] הועבר לדף שיחה אחר',
	'lqt_change_split' => '[$1 שרשור] זה פוצל משרשור אחר',
	'lqt_change_edited_subject' => 'נושא השרשור "$2" שוּנה אל "$3"',
	'lqt_change_merged_from' => '[$1 תגובה] לשרשור זה הועברה לשרשור אחר',
	'lqt_change_merged_to' => 'ה[$1 תגובה המודגשת] הועברה משרשור אחר',
	'lqt_change_split_from' => '[$1 שרשור משנה] של שרשור זה פוצל לשרשור עצמאי',
	'lqt_change_root_blanked' => 'הטקסט של [$1 התגובה] הוסר.',
	'lqt_youhavenewmessages' => 'יש לכם [[$1|הודעות חדשות]].',
	'lqt_protectedfromreply' => 'שרשור זה $1 תגובות.',
	'lqt_protectedfromreply_link' => 'מוגן מפני',
	'lqt_subject' => 'נושא:',
	'lqt_noreason' => 'לא צוינה סיבה.',
	'lqt_move_placeholder' => 'השרשור $1 הועבר מדף זה אל $5.
ההעברה בוצעה על ידי $2 ב־$4, $3.',
	'lqt_thread_deleted_for_sysops' => "שרשור זה '''נמחק''' ורק מפעילי מערכת יכולים לצפות בו.",
	'lqt_thread_deleted' => 'שרשור זה נמחק.',
	'lqt_summary_notice' => 'לא חלו שינויים בדיון זה לפחות במשך {{PLURAL:$2|היום האחרון|$2 הימים האחרונים|היומיים האחרונים}}.
אם הוא הסתיים, אולי תרצו לבצע $1.',
	'lqt_summary_notice_link' => 'כתיבת תקציר',
	'lqt_summary_label' => 'תקציר שרשור:',
	'lqt_summary_subtitle' => 'תקציר של "$1"',
	'lqt_nosuchrevision' => 'אין גרסה כזו עבור שרשור זה.',
	'lqt_nosuchthread' => 'השרשור שצוין אינו קיים.',
	'lqt_nosuchthread_title' => 'אין שרשור כזה',
	'lqt_threadrequired' => 'עליכם לציין שרשור בכתובת ה־URL.',
	'lqt_move_movingthread' => 'העברת $1.
שרשור זה הוא חלק מ־$2.',
	'lqt_move_torename' => "כדי לשנות שרשור זה, $1 ושנו את השדה 'נושא'.",
	'lqt_move_torename_edit' => 'ערכו אותו',
	'lqt_move_destinationtitle' => 'כותרת דף השיחה המיועד:',
	'lqt_move_move' => 'העברה',
	'lqt_move_nodestination' => 'עליכם לציין יעד.',
	'lqt_move_thread_bad_destination' => 'דף היעד אינו דף דיון.',
	'lqt_move_samedestination' => 'השרשור נמצא כבר בדף זה!',
	'lqt_move_noreason' => 'לא צוינה סיבה.',
	'lqt_move_success' => 'השרשור הועבר אל $1.',
	'lqt_delete_undeletethread' => 'שחזור השרשור',
	'lqt_delete_partof' => "שרשור זה הוא חלק מתוך '''$1'''.",
	'lqt_delete_deleting' => "מחיקת '''$1''' על '''כל תגובותיו'''.",
	'lqt_delete_deletethread' => 'מחיקת השרשור והתגובות',
	'lqt_delete_deleted' => 'השרשור נמחק.',
	'lqt_delete_undeleted' => 'השרשור שוחזר.',
	'lqt_delete_return' => 'חזרה אל $1.',
	'lqt_delete_return_link' => 'דף השיחה',
	'lqt_delete_unallowed' => 'אינכם מורשים למחוק שרשורים.',
	'lqt_delete_show_checkbox' => 'הצגת שרשורים שנמחקו',
	'lqt_talkpage_autocreate_summary' => 'דף השיחה נוצר אוטומטית בעת פרסום השרשור הראשון.',
	'lqt_header_warning_big' => 'אתם עורכים את $1',
	'lqt_header_warning_after_big' => 'כותרות מיועדות להכרזות ולדברי מבוא.
אולי תרצו ל$2.',
	'lqt_header_warning_bold' => 'כותרת דף הדיון',
	'lqt_header_warning_new_discussion' => 'התחיל בדיון חדש',
	'lqt_sorting_order' => 'סדר המיון:',
	'lqt_sort_newest_changes' => 'קודם אלה ששונו לאחרונה',
	'lqt_sort_newest_threads' => 'קודם החדשים ביותר',
	'lqt_sort_oldest_threads' => 'קודם הישנים ביותר',
	'lqt-title' => 'כותרת',
	'lqt-summary' => 'תקציר',
	'lqt-searching' => 'בחיפוש אחר שרשורים',
	'lqt-read-message' => 'סימון השרשור כנקרא',
	'lqt-read-message-tooltip' => 'הסרת שרשור זה מרשימת ההודעות החדשות.
השרשור עדיין יופיע בדף השיחה המקורי שלו.',
	'lqt-read-all' => 'לסמן הכול כנקרא',
	'lqt-read-all-tooltip' => 'הסרת כל השישורים מהודעות חדשות.
הם עדיין יופיעו בדפי השיחה המקוריים שלהם.
פעולה זו ניתנת לביטול.',
	'lqt-marked-read' => "השרשור '''$1''' סומן כ'נקרא'.",
	'lqt-count-marked-read' => "{{PLURAL:$1|הודעה אחת סומנה כ'נקראה'|$1 הודעות סומנו כ'נקראו'}}.",
	'lqt-email-undo' => 'ביטול',
	'lqt-no-new-messages' => 'אין הודעות חדשות עבורכם.',
	'lqt-new-messages' => 'יש לכם הודעות חדשות ✒',
	'lqt-email-info-undo' => 'החזרת השרשור שהתעלמתם ממנו זה עתה.',
	'lqt-date-info' => 'קישור זה מבוטל כיוון שאתם צופים בשרשורים מכל התאריכים.',
	'lqt-newmessages-context' => 'שרשור מלא',
	'lqt-thread-created' => 'נוצר',
	'lqt-history-time' => 'שעה',
	'lqt-history-user' => 'משתמש',
	'lqt-history-action' => 'פעילות',
	'lqt-history-comment' => 'הערה',
	'lqt-history-thread' => 'שרשור',
	'lqt-thread-edited-author' => 'נערך על ידי המחבר.<br />
עריכה אחרונה: $1',
	'lqt-thread-edited-others' => 'נערך על ידי {{PLURAL:$2|משתמש אחר|$2 משתמשים}}.<br />
עריכה אחרונה: $1',
	'lqt-header-actions' => 'פעולות',
	'lqt_summarize_link' => 'סיכום',
	'lqt-summarize-intro' => 'אנא כתבו את סיכום השרשור שלהלן בתיבת העריכה.
באפשרותכם להשתמש בסיכום בכל האפשרויות בתחביר הוויקי. לאחר שתסיימו, לחצו על "{{int:savearticle}}".',
	'lqt-thread-split' => 'פיצול לשרשור חדש',
	'lqt-split-success' => 'השרשור $1 פוצל בהצלחה.',
	'lqt_split_thread' => 'פיצול שרשור',
	'lqt-thread-split-subject' => 'נושא השרשור החדש:',
	'lqt-thread-split-thread' => 'שרשור:',
	'lqt-split-submit' => 'פיצול',
	'lqt_split_badsubject' => 'הנושא שהקלדתם אינו תקין.',
	'lqt-no-threads' => 'אין עדיין שרשורים בדף זה.',
	'lqt-delete-parent-warning' => 'זהו שרשור ברמה העליונה עם תגובות.
תגובותיו תימחקנה גם הן באופן אוטומטי.
כדי להימנע מכך, פצלו אותן משרשור זה לפני מחיקתו.',
	'lqt-delete-parent-deleted' => 'שרשור ההורה נמחק ($1)',
	'lqt-delete-replies-done' => 'כל התגובות לשרשור זה נמחקו גם הן.',
	'lqt-movethread' => 'העברה',
	'lqt-menu-trigger' => 'עוד',
	'lqt-newmessages-from' => 'מתוך $1',
	'lqt-hot-topics' => 'נושאים חמים',
	'lqt-add-reply' => 'הוספת תגובה',
	'lqt_rc_new_discussion' => 'שלח שרשור חדש, "$1"',
	'lqt_rc_new_reply' => 'שלח תגובה ל"$1"',
	'right-lqt-split' => 'פיצול שרשורים',
	'right-lqt-merge' => 'מיזוג שרשורים',
	'right-lqt-react' => 'מענה לשרשורים',
	'lqt-thread-merge' => 'מיזוג לשרשור אחר',
	'lqt-thread-merge-to' => 'מיזוג לשרשור זה',
	'lqt_merge_thread' => 'מיזוג שרשור',
	'lqt-thread-merge-source' => 'שרשור המקור:',
	'lqt-thread-merge-dest' => 'שרשור היעד:',
	'lqt-merge-submit' => 'מיזוג',
	'lqt-merge-success' => 'מיזגתם בהצלחה את השרשור $1 לתוך $2.',
	'lqt-log-name' => 'יומן השיחות בשרשורים',
	'lqt-log-header' => 'יומן זה מפרט את הפעולות שבוצעו על שרשורים של שיחות.',
	'lqt-log-action-move' => 'העביר את [[$1]] מ[[$2]] ל[[$3]].',
	'lqt-log-action-split' => 'פיצל את [[$1]] מתוך [[$3]] עם הנושא החדש "$2"',
	'lqt-log-action-merge-across' => 'העביר את [[$1]] שהיה ב[[$2]] אל [[$3]]',
	'lqt-log-action-merge-down' => 'איחד את [[$1]] לתוך [[$3]]',
	'lqt-log-action-subjectedit' => 'שינה את הנושא של [[$1]] מ"$2" ל"$3"',
	'lqt-log-action-resort' => 'שינה את סדר המיון של [[$1]]. מפתח המיון שונה מ־$2 ל־$3',
	'lqt-preference-notify-talk' => 'שליחת דוא"ל אליך כאשר מתקבלות תגובות בשרשור ברשימת המעקב שלך',
	'lqt-preference-watch-threads' => 'מעקב אחרי שרשורים שיצרתי או הגבתי להם',
	'prefs-lqt' => 'שיחות בשרשורים',
	'lqt-preference-display-depth' => 'עומק התגובות המרבי להצגה:',
	'lqt-preference-display-count' => 'מספר התגובות המרבי להצגה:',
	'lqt-preference-custom-signatures' => 'הצגת חתימות משתמשים מותאמות אישית',
	'lqt-enotif-subject-reply' => 'דיון באתר {{SITENAME}} – תגובה: $1',
	'lqt-enotif-subject-newthread' => 'דיון באתר {{SITENAME}} – שרשור חדש: $1',
	'lqt-enotif-newthread' => "שלום $1,

זוהי הודעה מ{{grammar:תחילית|{{SITENAME}}}} על כך ששרשור חדש ב{{GRAMMAR:תחילית|$5}}, '$2',
נוצר בתאריך $3 בשעה $4 על־ידי $8

באפשרותכם לראותו בכתובת <$6>

הטקסט הוא:
$7",
	'lqt-enotif-reply' => "שלום $1,

זוהי הודעה מ{{grammar:תחילית|{{SITENAME}}}} על כך שתגובה חדשה לשרשור '$2' בדף $5
נוצרה ב־$3 בשעה $4 על־ידי $8

אפשר לראותה בכתובת <$6>

תוכן ההודעה:
$7",
	'lqt-quote-intro' => 'ב־$3, $2, נכתב על ידי [[User:$1|$1]]:',
	'lqt-quote' => 'ציטוט',
	'lqt-search-legend' => 'חיפוש דיונים בדף זה',
	'lqt-search-label' => 'ביטויים לחיפוש:',
	'lqt-search-button' => 'חיפוש',
	'searchprofile-threads' => 'שיחות',
	'searchprofile-threads-tooltip' => 'חיפוש שיחות בשרשורים ודפי שיחה',
	'lqt-ajax-updated' => 'בשרשור זה יש הודעות חדשות.',
	'lqt-ajax-update-link' => 'עדכון',
	'lqt-thread-show-replies' => 'הצגת $1 תגובות',
	'lqt-thread-show-more' => 'הצגת תגובות נוספות',
	'lqt-thread-link-url' => 'כתובת הקישור:',
	'lqt-thread-link-title' => 'טקסט הוויקי של הקישור:',
	'lqt-thread-link-copy' => 'העתקה ללוח',
	'lqt-sign-not-necessary' => 'אין צורך לחתום על ההודעה בארבע טילדות.
החתימה מוצגת אוטומטית.',
	'lqt-marked-as-read-placeholder' => 'האשכול $1 סומן כנקרא.',
	'lqt-change-subject' => 'שינוי הנושא',
	'lqt-save-subject' => 'שמירה',
	'lqt-save-subject-failed' => 'השגיאה הבאה אירעה בעת ניסיון לשינוי כותרת השרשור הבא: $1',
	'lqt-ajax-invalid-subject' => 'הנושא שצוין אינו תקין, כנראה כי הוא ארוך מדי.',
	'lqt-ajax-no-subject' => 'יש לציין נושא לשרשור החדש.',
	'lqt-save-subject-error-unknown' => 'אירעה שגיאה בלתי ידועה בעת הניסיון להגדיר נושא לשרשור הזה. יש לנסות לעשות זאת על ידי לחיצה על "עריכה" בהודעה העליונה.',
	'lqt-cancel-subject-edit' => 'ביטול',
	'lqt-drag-activate' => 'גרירה למיקום חדש',
	'lqt-drag-drop-zone' => 'שחרור לכאן',
	'lqt-drag-confirm' => 'כדי להשלים את הפעולות הבאות, נא מלאו את הסיבה ולחצו על "אישור".',
	'lqt-drag-reparent' => 'העברת ההודעה תחת הורה חדש.',
	'lqt-drag-split' => 'העברת ההודעה לשרשור משלה',
	'lqt-drag-setsortkey' => 'הגדרת מיקום ההודעה בדף',
	'lqt-drag-bump' => 'העברה לראש דף הדיון',
	'lqt-drag-save' => 'אישור',
	'lqt-drag-title' => 'אישור גרירה',
	'lqt-drag-reason' => 'סיבה:',
	'lqt-drag-subject' => 'כותרת לשרשור חדש (חובה):',
	'lqt-edit-signature' => '(עריכת החתימה)',
	'lqt-preview-signature' => '(תצוגה מקדימה)',
	'lqt-feed-title-all' => '{{SITENAME}} — הודעות חדשות',
	'lqt-feed-title-all-from' => '{{SITENAME}} — הודעות חדשות מתוך $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — שרשורים חדשים',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — שרשורים חדשים מתוך $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — תגובות',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — תגובות מתוך $1',
	'lqt-feed-new-thread-intro' => 'שרשור חדש ב$1 שנוצר על־ידי $2',
	'lqt-feed-reply-intro' => 'תגובה לשרשור $3 (ב$1) שנוצר על־ידי $2',
	'tooltip-pt-newmessages' => 'הצגת הודעות חדשות בשרשורים או בדפי שיחה בשרשורים שרשימת המעקב שלך',
	'lqt-newmessages-n' => 'הודעות חדשות ($1)',
	'lqt_newmessages' => 'ההודעות החדשות שלי (אין)',
	'lqt_newmessages-title' => 'הודעות חדשות',
	'lqt-newpost-summary' => 'שרשור חדש: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'נא להזין את הטקסט שלך לשרשור הזה. אחרי־כן יש למחוק את השורה הזאת.',
	'lqt-reply-summary' => 'תגובה אל [[$2|$1]]',
	'lqt-talkpage-history-title' => 'היסטוריית דף השיחה',
	'lqt-talkpage-history-subtitle' => 'עבור $1',
	'lqt-talkpage-history-tab' => 'כותרת',
	'restriction-reply' => 'פרסום תגובות',
	'restriction-newthread' => 'פרסום שרשורים חדשים',
	'lqt-protected-reply-thread' => 'אינכם יכולים לשלוח הודעה לשרשור הזה, כי הוא ננעל.',
	'lqt-protected-reply-talkpage' => 'אינכם יכולים לשלוח הודעה לשרשור הזה, כי דף השיחה הזה ננעל לתגובות לשרשורים שבו.',
	'lqt-protected-newthread' => 'אינכם יכולים ליצור שרשורים חדשים בדף השיחה הזה, כי הוא ננעל ליצירת שרשורים חדשים.',
	'lqt-edit-bump' => 'הקפצת שרשור זה',
	'lqt-edit-bump-tooltip' => 'העברת שרשור זה לראש דף הדיון בו הוא מופיע',
	'lqt-historicalrevision-error' => 'הגרסה שבחרת פגומה ולא ניתן להציג אותה.',
	'lqt-reply-subpage' => 'תגובה',
	'nstab-thread' => 'שרשור',
	'nstab-summary' => 'תקציר',
);

/** Hindi (हिन्दी)
 * @author Bhawani Gautam Rhk
 * @author Kaustubh
 * @author Kiranmayee
 */
$messages['hi'] = array(
	'lqt-desc' => 'वार्ता पृष्ठ पर वार्ता के थ्रेड्स बढायें',
	'lqt_movethread' => 'थ्रेड दुसरे पन्ने पर डालें',
	'lqt_deletethread' => 'थ्रेड हटायें या पुनर्स्थापित करें',
	'lqt_contents_title' => 'अनुक्रम',
	'lqt_add_header' => 'हेडर लिखे',
	'lqt_new_thread' => 'नई वार्ता शुरू करें',
	'lqt_reply' => 'जवाब',
	'lqt_delete' => 'हटायें',
	'lqt_undelete' => 'पुनर्स्थापित करें',
	'lqt_permalink' => 'इस के कड़ी',
	'lqt_fragment' => '$2 से $1 का एक टुकड़ा',
	'lqt_discussion_link' => 'वार्ता',
	'lqt_from_talk' => '$1 से',
	'lqt_hist_comment_edited' => 'टिप्पणी बदली',
	'lqt_hist_summary_changed' => 'संक्षिप्त ज़ानकारी बदली',
	'lqt_hist_reply_created' => 'नया जवाब बनाया',
	'lqt_hist_thread_created' => 'नया थ्रेड बनाया',
	'lqt_hist_deleted' => 'हटाया',
	'lqt_hist_undeleted' => 'पुनर्स्थापित किया',
	'lqt_hist_moved_talkpage' => 'स्थानांतरित',
	'lqt_hist_listing_subtitle' => 'इतिहास सूची देख रहें हैं',
	'lqt_hist_view_whole_thread' => 'पूरे थ्रेड का इतिहास देखें',
	'lqt_hist_no_revisions_error' => 'इस थ्रेड के इतिहास अवतरण नहीं हैं।',
	'lqt_hist_past_last_page_error' => 'आप अस्तित्वमें होने वाले इतिहास पन्नोंकी संख्याको पार कर गये हैं।',
	'lqt_hist_tooltip_newer_disabled' => 'आप पहले पन्नेपर होने के कारण यह कड़ी इस्तेमाल नहीं कर सकतें हैं।',
	'lqt_hist_tooltip_older_disabled' => 'आप आखिरी पन्नेपर होने के कारण इस कड़ीका इस्तेमाल नहीं कर सकतें हैं।',
	'lqt_revision_as_of' => '$1 का अवतरण।',
	'lqt_change_new_thread' => 'यह इस थ्रेडका शुरुवातका अवतरण हैं।',
	'lqt_change_reply_created' => 'हाइलाइट की हुई टिप्पणी इस अवतरण में दी गई थी।',
	'lqt_change_edited_root' => 'हाइलाइट की हुई टिप्पणी इस अवतरण में बदली गई थी।',
	'lqt_youhavenewmessages' => 'आपके पास $1 हैं।',
	'lqt_protectedfromreply' => 'यह थ्रेड जवाब देने से $1 हैं।',
	'lqt_protectedfromreply_link' => 'सुरक्षित',
	'lqt_subject' => 'विषय:',
	'lqt_noreason' => 'कारण दिया नहीं।',
	'lqt_thread_deleted_for_sysops' => 'यह थ्रेड $1 हैं और सिर्फ प्रबंधकोंको ही दिख सकता हैं।',
	'lqt_thread_deleted' => 'यह थ्रेड हटाया गया हैं।',
	'lqt_summary_notice_link' => 'संक्षिप्त ज़ानकारी लिखें',
	'lqt_summary_label' => 'इस थ्रेड को निम्नलिखित संक्षिप्त ज़ानकारी दी हुई हैं:',
	'lqt_summary_subtitle' => '$1 की संक्षिप्त ज़ानकारी।',
	'lqt_nosuchrevision' => 'इस थ्रेडका ऐसा अवतरण नहीं हैं।',
	'lqt_nosuchthread' => 'ऐसा थ्रेड नहीं हैं।',
	'lqt_threadrequired' => 'URL में थ्रेड देना आवश्यक हैं।',
	'lqt_move_movingthread' => '$1 का स्थानांतरण चल रहा हैं। यह $2 का एक घटक हैं।',
	'lqt_move_torename' => "इस थ्रेड का नाम बदलने के लिये, $1 और 'विषय' बदलें।",
	'lqt_move_torename_edit' => 'संपादित करें',
	'lqt_move_destinationtitle' => 'लक्ष्य वार्ता पृष्ठ का शीर्षक:',
	'lqt_move_move' => 'स्थानांतरण करें',
	'lqt_move_nodestination' => 'आपको लक्ष्य देना आवश्यक हैं।',
	'lqt_move_noreason' => 'कारण दिया नही॥',
	'lqt_move_success' => 'यह थ्रेड $1 पर स्थानांतरीत कर दिया गया हैं।',
	'lqt_delete_undeletethread' => 'थ्रेड पुनर्स्थापित करें',
	'lqt_delete_partof' => 'यह थ्रेड $1 का घटक हैं।',
	'lqt_delete_deleting' => '$1 हटा रहें हैं और उसमें $2 कर रहें हैं।',
	'lqt_delete_deletethread' => 'थ्रेड और जवाब हटायें',
	'lqt_delete_deleted' => 'थ्रेड को हटाया गया हैं।',
	'lqt_delete_undeleted' => 'थ्रेड पुनर्स्थापित कर दिया गया हैं।',
	'lqt_delete_return' => '$1 की ओर वापस जायें।',
	'lqt_delete_return_link' => 'वार्ता पॄष्ठ',
	'lqt_delete_unallowed' => 'आपको थ्रेड हटाने की अनुमति नहीं हैं।',
	'lqt_talkpage_autocreate_summary' => 'पहला थ्रेड लिखने के बाद वार्ता पृष्ठ अपने आप बन गया था।',
	'lqt_header_warning_big' => 'आप एक $1 संपादित कर रहें हैं।',
	'lqt_header_warning_after_big' => 'हेडर सिर्फ घोषणा या प्रिफेस के लिये इस्तेमाल किया जाता हैं।
आप उसके बदलेमें $2 का इस्तेमाल कर सकतें हैं।',
	'lqt_header_warning_bold' => 'वार्ता पृष्ठ का हेडर',
	'lqt_header_warning_new_discussion' => 'नई वार्ता शुरू करें',
	'lqt_sorting_order' => 'अनुक्रम दें:',
	'lqt_sort_newest_changes' => 'आखिर में बदले गये पहले',
	'lqt_sort_newest_threads' => 'नये थ्रेड पहले',
	'lqt_sort_oldest_threads' => 'पुराने थ्रेड पहले',
	'lqt-newmessages-n' => 'नये सन्देश ($1)',
	'lqt_newmessages' => 'नये संदेश',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'lqt_delete' => 'Panason',
	'lqt_discussion_link' => 'Paghisayranay',
	'lqt_move_move' => 'Saylohon',
);

/** Croatian (Hrvatski)
 * @author Dalibor Bosits
 * @author Ex13
 * @author Herr Mlinka
 * @author Roberta F.
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'lqt-desc' => 'Dodaj rasprave na stranice za razgovor',
	'lqt_movethread' => 'Premjesti raspravu na drugu stranicu',
	'lqt_deletethread' => 'Izbriši ili vrati izbrisanu raspravu',
	'lqt_contents_title' => 'Sadržaj',
	'lqt_toc_thread_title' => 'Naslov rasprave',
	'lqt_toc_thread_author' => 'Započeto od',
	'lqt_toc_thread_replycount' => 'Odgovori',
	'lqt_toc_thread_modified' => 'Zadnje izmjenjeno',
	'lqt_add_header' => 'Dodaj zaglavlje',
	'lqt_new_thread' => 'Započnite novu raspravu',
	'lqt_invalid_subject' => 'Naziv teme koji ste unijeli nije ispravan. 
Može biti: 
* predug je, ili 
* naziv je isti kao međuwiki prefiks ili ime imenskog prostora.',
	'lqt_empty_subject' => 'Morate upisati temu/sažetak.',
	'lqt_reply' => 'Odgovori',
	'lqt-parent' => '"Roditelj"',
	'lqt_delete' => 'Izbriši',
	'lqt_undelete' => 'Vrati izbrisano',
	'lqt_permalink' => 'Poveži na',
	'lqt_fragment' => 'Dio od $1 sa $2',
	'lqt_discussion_link' => 'rasprava',
	'lqt_from_talk' => 'Iz $1',
	'lqt-history-title' => 'Povijest dretve',
	'lqt_hist_comment_edited' => 'Komentiraj uređivanje [autor - $2]',
	'lqt_hist_summary_changed' => 'Sažetak promjena',
	'lqt_hist_reply_created' => '[[$1|Novi odgovor]] dodan',
	'lqt_hist_thread_created' => 'Nova rasprava započeta',
	'lqt_hist_deleted' => 'Izbrisano',
	'lqt_hist_undeleted' => 'Neobrisano',
	'lqt_hist_moved_talkpage' => 'Premješteno',
	'lqt_hist_listing_subtitle' => 'Pregled povijesti stranice',
	'lqt_hist_view_whole_thread' => 'Pregled povijesti za cijelu temu',
	'lqt_hist_no_revisions_error' => 'Ova tema nema povijest izmjena.',
	'lqt_hist_past_last_page_error' => 'Prešli ste postojeći broj stranica povijesti.',
	'lqt_hist_tooltip_newer_disabled' => 'Poveznica je onemogućena jer ste na prvoj stranici.',
	'lqt_hist_tooltip_older_disabled' => 'Poveznica je onemogućena jer ste na zadnjoj stranici.',
	'lqt_hist_split' => 'Podijeli temu tako da odgovor započne novu temu',
	'lqt_hist_edited_subject' => 'Promijenjen naslov iz "$2" u "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Promijenjen naslov teme',
	'lqt_hist_merged_from' => '[[$1|Odgovor]] premješten u drugu temu',
	'lqt_hist_merged_to' => '[[$1|Odgovor]] premješten iz druge teme',
	'lqt_hist_split_from' => 'Razdvoji u novu raspravu',
	'lqt_hist_root_blanked' => 'Uklonjen komentar',
	'lqt_hist_adjusted_sortkey' => 'Prilagođen položaj u temi',
	'lqt_revision_as_of' => 'Inačica od $2 u $3.',
	'lqt_change_new_thread' => 'Ovo je prva inačica teme.',
	'lqt_change_reply_created' => '[$1 istaknut komentar] je napisan u ovoj inačici.',
	'lqt_change_edited_root' => '[$1 istaknut komentar] je uređen u ovoj inačici.',
	'lqt_change_edited_summary' => 'Uređen je sažetak teme',
	'lqt_change_deleted' => '[$1 Ova tema] ili njezin "roditelj" je obrisan',
	'lqt_change_undeleted' => '[$1 istaknuta poruka] je vraćena',
	'lqt_change_moved' => '[$1 Ova tema] premještena je na drugu stranicu za razgovor',
	'lqt_change_split' => '[$1 Ova tema] nastala je podjelom druge teme',
	'lqt_change_edited_subject' => 'Naziv ove teme promijenjen je iz "$2" u "$3"',
	'lqt_change_merged_from' => '[$1 Odgovor] na ovu temu premješten je u drugu temu',
	'lqt_change_merged_to' => '[$1 Označeni odgovor] premješten je iz druge teme',
	'lqt_change_split_from' => '[$1 Podtema] ove teme podijeljena je u zasebnu temu (dretvu)',
	'lqt_change_root_blanked' => 'Tekst [$1 komentara] je uklonjen.',
	'lqt_youhavenewmessages' => 'Imate [[$1|nove poruke]].',
	'lqt_protectedfromreply' => 'Tema je $1 od odgovora.',
	'lqt_protectedfromreply_link' => 'zaštićen',
	'lqt_subject' => 'Tema:',
	'lqt_noreason' => 'bez obrazloženja',
	'lqt_move_placeholder' => 'Tema $1 premještena je odavdje na $5. 
Premještaj je napravio suradnik $2 dana $3 u $4.',
	'lqt_thread_deleted_for_sysops' => "Tema je '''obrisana''' te je vidljiva samo administratorima.",
	'lqt_thread_deleted' => 'Tema je obrisana.',
	'lqt_summary_notice' => 'Nije bilo uređivanja ove rasprave najmanje $2 {{PLURAL:$2|dan|dana|dana}}. 
Ukoliko je tema zaključena, možda želite urediti sažetak $1.',
	'lqt_summary_notice_link' => 'napiši sažetak',
	'lqt_summary_label' => 'Sažetak teme:',
	'lqt_summary_subtitle' => 'Sažetak "$1"',
	'lqt_nosuchrevision' => 'Tražena inačica ove teme ne postoji.',
	'lqt_nosuchthread' => 'Tema koju ste naveli ne postoji.',
	'lqt_nosuchthread_title' => 'Ne postoji tema s tim nazivom',
	'lqt_threadrequired' => 'Morate navesti temu u URL-u.',
	'lqt_move_movingthread' => 'Premještam $1. 
Ova tema je dio $2.',
	'lqt_move_torename' => "Za promjenu naslova ove teme, $1 i promijenite polje 'Subject'.",
	'lqt_move_torename_edit' => 'uredi',
	'lqt_move_destinationtitle' => 'Naziv odredišne stranice za razgovor:',
	'lqt_move_move' => 'Premjesti',
	'lqt_move_nodestination' => 'Morate navesti odredište.',
	'lqt_move_thread_bad_destination' => 'Odredišna stranica nije stranica za razgovor.',
	'lqt_move_samedestination' => 'Tema se već nalazi na ovoj stranici!',
	'lqt_move_noreason' => 'bez obrazloženja',
	'lqt_move_success' => 'Tema je premještena na stranicu $1.',
	'lqt_delete_undeletethread' => 'Vrati temu',
	'lqt_delete_partof' => "Ova tema je dio '''$1'''.",
	'lqt_delete_deleting' => "Brišem '''$1''' i '''sve odgovore''' na tu temu.",
	'lqt_delete_deletethread' => 'Obriši temu i odgovore',
	'lqt_delete_deleted' => 'Tema je obrisana.',
	'lqt_delete_undeleted' => 'Tema je vraćena.',
	'lqt_delete_return' => 'Vrati se na $1.',
	'lqt_delete_return_link' => 'stranica za razgovor',
	'lqt_delete_unallowed' => 'Ne možete brisati teme.',
	'lqt_delete_show_checkbox' => 'Pokaži obrisane teme',
	'lqt_talkpage_autocreate_summary' => 'Stranica za razgovor automatski je stvorena kad je započeta prva tema',
	'lqt_header_warning_big' => 'Uređujete $1.',
	'lqt_header_warning_after_big' => 'Zaglavlja služe za obavijesti i predgovore. 
Možda želite $2.',
	'lqt_header_warning_bold' => 'zaglavlje stranice za razgovor',
	'lqt_header_warning_new_discussion' => 'započnite novu temu',
	'lqt_sorting_order' => 'Sortiranje:',
	'lqt_sort_newest_changes' => 'prvo zadnja izmjena',
	'lqt_sort_newest_threads' => 'najnovije teme prvo',
	'lqt_sort_oldest_threads' => 'najstarije teme prvo',
	'lqt-title' => 'Naslov',
	'lqt-summary' => 'Sažetak',
	'lqt-searching' => 'Pretražujem teme',
	'lqt-read-message' => 'Označi kao pročitano',
	'lqt-read-message-tooltip' => 'Ukloni ovu temu iz novih poruka. 
Ona će još uvijek biti vidljiva na njenoj stranici za razgovor.',
	'lqt-read-all' => 'Označi sve pročitanim',
	'lqt-read-all-tooltip' => 'Uklonite sve teme iz novih poruke. 
One će još uvijek biti vidljive na njihove izvornim stranicama za razgovor. 
Ovu operaciju je moguće povratiti.',
	'lqt-marked-read' => "Tema '''$1''' označena je pročitanom.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|poruka označena je pročitanom|poruke označene su pročitanima|poruka označene su pročitanima}}.',
	'lqt-email-undo' => 'Vrati',
	'lqt-no-new-messages' => 'Nemate novih poruka.',
	'lqt-new-messages' => '✒ Imate novih poruka.',
	'lqt-email-info-undo' => 'Vrati temu koju ste upravo odbacili.',
	'lqt-date-info' => 'Poveznica je onemogućeno jer gledate teme za sve datume.',
	'lqt-newmessages-context' => 'Cijela rasprava',
	'lqt-thread-created' => 'Započeto',
	'lqt-history-time' => 'Vrijeme',
	'lqt-history-user' => 'Suradnik',
	'lqt-history-action' => 'Aktivnost',
	'lqt-history-comment' => 'Komentar',
	'lqt-history-thread' => 'Tema',
	'lqt-thread-edited-author' => 'Izmijenio autor. <br />
Posljednja izmjena: $1',
	'lqt-thread-edited-others' => 'Izmijenjeno od strane {{PLURAL:$2|drugog|$2|$2}} suradnika. <br />
Posljednja izmjena: $1',
	'lqt-header-actions' => 'Radnje',
	'lqt_summarize_link' => 'Sažimanje',
	'lqt-summarize-intro' => 'Molimo sažmite donju raspravu u okvir za uređivanje.
Možete rabiti bilo koji wikitekst. Kada završite, kliknite "{{int:savearticle}}".',
	'lqt-thread-split' => 'Razdvoji u novu raspravu',
	'lqt-split-success' => 'Uspješno ste razdvojili raspravu $1.',
	'lqt_split_thread' => 'Razdvoji raspravu',
	'lqt-thread-split-subject' => 'Nova tema rasprave:',
	'lqt-thread-split-thread' => 'Rasprava:',
	'lqt-split-submit' => 'Razdvoji',
	'lqt_split_badsubject' => 'Tema koju ste unijeli nije ispravna.',
	'lqt-no-threads' => 'Na ovoj stranici još uvijek ne postoji rasprava.',
	'lqt-delete-parent-warning' => 'Ovo je najviši-nivo teme s njenim odgovorima. 
Odgovori će također biti automatski obrisani. 
Kako bi to izbjegli, podijelite ih iz ove teme prije nego ju obrišete.',
	'lqt-delete-parent-deleted' => 'Tema "roditelj" je obrisana ($1)',
	'lqt-delete-replies-done' => 'Svi odgovori ove teme također su obrisani.',
	'lqt-movethread' => 'Premjesti',
	'lqt-menu-trigger' => 'Više',
	'lqt-newmessages-from' => 'Iz projekta $1',
	'lqt-hot-topics' => 'Posljednje komentirane teme',
	'lqt-add-reply' => 'Dodaj poruku',
	'lqt_rc_new_discussion' => 'pokrenuta je nova tema, "$1"',
	'lqt_rc_new_reply' => 'napisan je odgovori na "$1"',
	'right-lqt-split' => 'Podijeli temu',
	'right-lqt-merge' => 'Spajanje rasprava',
	'lqt-thread-merge' => 'Spoji s drugim nizom rasprava',
	'lqt-thread-merge-to' => 'Spoji s ovim nizom',
	'lqt_merge_thread' => 'Spoji niz',
	'lqt-thread-merge-source' => 'Izvorni niz:',
	'lqt-thread-merge-dest' => 'Odredišni niz rasprave:',
	'lqt-merge-submit' => 'Spoji',
	'lqt-merge-success' => 'Uspješno ste spojili niz rasprave $1 u podniz $2.',
	'lqt-log-name' => 'Evidencija rasprava',
	'lqt-log-header' => 'Ova evidenicija prikazuje radnje poduzete na stranicama za raspravu',
	'lqt-log-action-move' => 'premješteno [[$1]] s [[$2]] na [[$3]].',
	'lqt-log-action-split' => 'Podijeli [[$1]] ispod [[$3]], s novim naslovom "$2"',
	'lqt-log-action-merge-across' => 'premjesti [[$1]] od ispod [[$2]] da bude ispod [[$3]]',
	'lqt-log-action-merge-down' => 'spojena tema [[$1]] ispod [[$3]]',
	'lqt-log-action-subjectedit' => 'promijenjen naziv teme [[$1]] iz "$2" u "$3"',
	'lqt-log-action-resort' => 'promjena sortiranja teme [[$1]]. Promijenjen ključ sortiranja iz $2 u $3',
	'lqt-preference-notify-talk' => 'Pošalji mi e-mail prilikom odgovora na raspravi koju pratim',
	'lqt-preference-watch-threads' => 'Prati teme koje sam stvorio ili na koje sam odgovorio',
	'prefs-lqt' => 'Stranice za razgovor',
	'lqt-preference-display-depth' => 'Najveća dubina odgovora koja će biti prikazana:',
	'lqt-preference-display-count' => 'Najveći broj odgovora koji će biti prikazani:',
	'lqt-preference-custom-signatures' => 'Prikaži modificirane potpise suradnika',
	'lqt-enotif-subject-reply' => '{{SITENAME}} rasprava - Odgovor: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} rasprava - Nova rasprava: $1',
	'lqt-enotif-newthread' => "Pozdrav $1,

ovo je obavijest s {{SITENAME}} da je nova rasprava na $5, '$2',
započeta $3 u $4 od strane $8

Možete je vidjeti na <$6>

Tekst glasi:
$7",
	'lqt-enotif-reply' => "Pozdrav $1,

ovo je obavijest s {{SITENAME}} o novom odgovoru na '$2' na $5, 
dan $3 u $4 od strane $8

Odgovor možete vidjeti ovdje <$6>

Odgovor glasi: 
$7",
	'lqt-quote-intro' => '$2 u $3, [[User:$1|$1]] je napisao:',
	'lqt-quote' => 'Citiraj',
	'lqt-search-legend' => 'Pretraži raspravu na ovoj stranici',
	'lqt-search-label' => 'Pojmovi pretrage:',
	'lqt-search-button' => 'Traži',
	'searchprofile-threads' => 'Rasprave',
	'searchprofile-threads-tooltip' => 'Pretraži dretve rasprava i stranice za razgovor',
	'lqt-ajax-updated' => 'Napisane su nove poruke u ovoj temi.',
	'lqt-ajax-update-link' => 'Osvježi',
	'lqt-thread-show-replies' => 'Prikaži $1 {{plural:$1|odgovor|odgovora|odgovora}}',
	'lqt-thread-show-more' => 'Prikaži više odgovora',
	'lqt-thread-link-url' => 'URL poveznice:',
	'lqt-thread-link-title' => 'Wikitekst poveznica:',
	'lqt-thread-link-copy' => 'Kopiraj u međuspremnik',
	'lqt-sign-not-necessary' => 'Nije nužno potpisivati se s četiri tilde.
Potpis se prikazuje automatski.',
	'lqt-marked-as-read-placeholder' => 'Tema $1 označena je pročitanom.',
	'lqt-change-subject' => 'Promjeni naziv teme',
	'lqt-save-subject' => 'Snimi',
	'lqt-save-subject-failed' => 'Sljedeća pogreška se dogodila prilikom pokušaja promjene naziva ove teme: $1',
	'lqt-ajax-invalid-subject' => 'Naslov koji ste naveli nije valjan, vjerojatno zato što je predugačak.',
	'lqt-ajax-no-subject' => 'Morate navesti naziv teme.',
	'lqt-save-subject-error-unknown' => 'Nepoznata pogreška se pojavljuju kad je pokušano snimanje naziva ove teme. Pokušajte to učiniti klikom na "Uredi" na prvoj poruci teme.',
	'lqt-cancel-subject-edit' => 'Odustani',
	'lqt-drag-activate' => 'Odvucite na novu lokaciju',
	'lqt-drag-drop-zone' => 'Stavi ovdje',
	'lqt-drag-confirm' => 'Da biste dovršili sljedeće akcije, molimo Vas da ispunite razlog i kliknite na "Potvrdi".',
	'lqt-drag-reparent' => 'Premjesti odgovor ispod novog "roditelja".',
	'lqt-drag-split' => 'Premjesti odgovor u svoju vlastitu temu',
	'lqt-drag-setsortkey' => 'Promijeni mjesto odgovora na stranici',
	'lqt-drag-bump' => 'Premjesti odgovor na vrhu stranice za razgovor',
	'lqt-drag-save' => 'Potvrdi',
	'lqt-drag-title' => 'Potvrdi premještaj',
	'lqt-drag-reason' => 'Razlog:',
	'lqt-drag-subject' => 'Naziv nove teme:',
	'lqt-edit-signature' => '(uredi potpis)',
	'lqt-preview-signature' => '(pregled)',
	'lqt-feed-title-all' => '{{SITENAME}} — Novi komentari',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Novi komentari suradnika $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nove teme',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nove teme suradnika $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Odgovori',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Odgovori suradnika $1',
	'lqt-feed-new-thread-intro' => 'Suradnik $2 započeo je nova tema o $1',
	'lqt-feed-reply-intro' => 'Odgovor $3 (na $1) napisao je suradnik $2',
	'tooltip-pt-newmessages' => 'Pokazuje nove postove na teme ili na stranicama za razgovor koje pratite',
	'lqt-newmessages-n' => 'Nove poruke ($1)',
	'lqt_newmessages' => 'Moje nove poruke (nema)',
	'lqt_newmessages-title' => 'Nove poruke',
	'lqt-newpost-summary' => 'Nova dretva: $1',
	'lqt-reply-summary' => 'Odgovori na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Povijest stranice za razgovor',
	'lqt-talkpage-history-subtitle' => 'Za $1',
	'lqt-talkpage-history-tab' => 'Zaglavlje',
	'restriction-reply' => 'Pošalji odgovore',
	'restriction-newthread' => 'Pošalji nove teme',
	'lqt-protected-reply-thread' => 'Ne možete odgovoriti na ovu temu jer je zaključana za nove odgovore.',
	'lqt-protected-reply-talkpage' => 'Ne možete odgovoriti na ovu temu jer je ova stranica za razgovor zaključana za odgovore na teme.',
	'lqt-protected-newthread' => 'Ne možete otvoriti novu temu na ovoj stranici za razgovor jer je zaključana za otvaranje novih tema.',
	'lqt-edit-bump' => 'Označi temu nepregledanom',
	'lqt-edit-bump-tooltip' => 'Premjesti ovu temu na vrh njene stranice za razgovor',
	'lqt-historicalrevision-error' => 'Inačica koju ste odabrali je oštećena, i ne može biti pregledana.',
	'lqt-reply-subpage' => 'odgovor',
	'nstab-thread' => 'Tema',
	'nstab-summary' => 'Sažetak',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'lqt-desc' => 'Nitkowe diskusije k diskusijnym stronam přidać',
	'lqt_movethread' => 'Nitku na druhu stronu přesunyć',
	'lqt_deletethread' => 'Nitku wušmórnyć abo wobnowić',
	'lqt_contents_title' => 'Wobsah',
	'lqt_toc_thread_title' => 'Titul nitki',
	'lqt_toc_thread_author' => 'Započaty wot',
	'lqt_toc_thread_replycount' => 'Wotmołwy',
	'lqt_toc_thread_modified' => 'Posledni raz změnjeny',
	'lqt_add_header' => 'Hłowu přidać',
	'lqt_new_thread' => 'Nowu diskusiju započeć',
	'lqt_invalid_subject' => 'Tema, kotryž sy zapodał, je njepłaćiwa. Snano:
* je předołho abo
* je konflikt z interwikijowymi prefiksami abo mjenami mjenowych rumow.',
	'lqt_empty_subject' => 'Dyrbiš temowe nadpismo zapodać.',
	'lqt_reply' => 'Wotmołwić',
	'lqt-parent' => 'Nadrjadowany',
	'lqt_delete' => 'Wušmórnyć',
	'lqt_undelete' => 'Wobnowić',
	'lqt_permalink' => 'Trajny wotkaz',
	'lqt_fragment' => 'Fragment wot $1 z $2',
	'lqt_discussion_link' => 'diskusija',
	'lqt_from_talk' => 'z $1',
	'lqt-history-title' => 'Stawizny nitki',
	'lqt_hist_comment_edited' => 'Tekst komentara [$2 wobdźěłany]',
	'lqt_hist_summary_changed' => 'Zjeće změnjene',
	'lqt_hist_reply_created' => '[[$1|Nowa wotmołwa]] wutworjena',
	'lqt_hist_thread_created' => 'Nowa nitka wutworjena',
	'lqt_hist_deleted' => 'Wušmórnjeny',
	'lqt_hist_undeleted' => 'Wobnowjeny',
	'lqt_hist_moved_talkpage' => 'Přesunjeny',
	'lqt_hist_listing_subtitle' => 'Lisćinu stawiznow wobhladać',
	'lqt_hist_view_whole_thread' => 'Stawizny za cyłu nitku wobhladać',
	'lqt_hist_no_revisions_error' => 'Tuta nitka nima stawizniske wersije.',
	'lqt_hist_past_last_page_error' => 'Sy wyše ličby stronow stawiznow.',
	'lqt_hist_tooltip_newer_disabled' => 'Tutón wotkaz je znjemóžnjeny, dokelž sy na prěnjej stronje.',
	'lqt_hist_tooltip_older_disabled' => 'Tutón wotkaz je znjemóžnjeny, dokelž sy na poslednjej stronje.',
	'lqt_hist_split' => 'Wotmołwu do noweje nitki rozdźělić',
	'lqt_hist_edited_subject' => 'Tema změnjena wot "$2" do "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Změnjena tema',
	'lqt_hist_merged_from' => '[[$1|Wotmołwa]] do druheje nitki přesunjena',
	'lqt_hist_merged_to' => '[[$1|Wotmołwa]] z druheje nitki přesunjena',
	'lqt_hist_split_from' => 'Do noweje nitki rozdźělić',
	'lqt_hist_root_blanked' => 'Komentarowy tekst wotstronjeny',
	'lqt_hist_adjusted_sortkey' => 'Skorigowana pozicija nitki',
	'lqt_revision_as_of' => 'Wersija wot $2 $3.',
	'lqt_change_new_thread' => 'To je spočatna wersija nitki.',
	'lqt_change_reply_created' => '[$1 wuzběhnjeny komentar] bu w tutej wersiji wutworjeny.',
	'lqt_change_edited_root' => '[$1 wuzběhnjeny komentar] bu w tutej wersiji změnjeny.',
	'lqt_change_edited_summary' => 'Zjeće nitki bu wobdźěłane',
	'lqt_change_deleted' => '[$1 Tuta nitka] abo wotmołwa na nju bu wušmórnjena',
	'lqt_change_undeleted' => '[$1 wuzběhnjena powěsć] bu wobnowjena',
	'lqt_change_moved' => '[$1 Tuta nitka] bu do druheje diskusijneje strony přesunjena',
	'lqt_change_split' => '[$1 Tuta nitka] bu z druheje nitki wotdźělena',
	'lqt_change_edited_subject' => 'Tema tuteje nitki bu wot "$2" do "$3" změnjena',
	'lqt_change_merged_from' => '[$1 Wotmołwa] w tutej nitce bu do druheje nitki přesunjena',
	'lqt_change_merged_to' => '[$1 Wuzběhnjena wotmołwa] bu z druheje nitki přesunjena',
	'lqt_change_split_from' => '[$1 Podnitka] tuteje nitki bu do swojeje nitki wotdźělena',
	'lqt_change_root_blanked' => 'Tekst [$1 komentara] bu wotstronjeny.',
	'lqt_youhavenewmessages' => 'Maš [[$1|nowe powěsće]].',
	'lqt_protectedfromreply' => 'Z tuteje nitki je $1 wotmołwił.',
	'lqt_protectedfromreply_link' => 'škitany',
	'lqt_subject' => 'Tema:',
	'lqt_noreason' => 'Žana pričina podata.',
	'lqt_move_placeholder' => 'Tuta nitka je naměstnik, kotryž podawa, zo nitka, $1, je so z tuteje strony přesunyła. Tute přesunjenje je $2 $3 $4 činił. Nitka je nětko při $5.',
	'lqt_thread_deleted_for_sysops' => "Tuta nitka je so '''wušmórnyła''' a je jenož za administratorow widźomna.",
	'lqt_thread_deleted' => 'Tuta nitka je so wušmórnyła.',
	'lqt_summary_notice' => 'Wot znajmjeńša $2 {{PLURAL:$2|dnja|dnjow|dnjow|dnjow}} na tutej diskusijnej stronje žane změny njeběchu. Jeli je zakónčena, chceš snano $1.',
	'lqt_summary_notice_link' => 'zjeće pisać',
	'lqt_summary_label' => 'Zjeće nitki:',
	'lqt_summary_subtitle' => 'Zjeće wot "$1"',
	'lqt_nosuchrevision' => 'Njeje tajka wersija tuteje nitki.',
	'lqt_nosuchthread' => 'Nitka, kotruž sy podał, njeeksistuje.',
	'lqt_nosuchthread_title' => 'Tajka nitka njeje',
	'lqt_threadrequired' => 'Dyrbiš w URL nitku podać.',
	'lqt_move_movingthread' => '$1 přesunje so. Tuta nitka je dźěl wot $2.',
	'lqt_move_torename' => "Zo by tutu nitku přemjenował, $1 a změń polo 'Tema'.",
	'lqt_move_torename_edit' => 'změnić',
	'lqt_move_destinationtitle' => 'Titul ciloweje diskusijneje strony:',
	'lqt_move_move' => 'Přesunyć',
	'lqt_move_nodestination' => 'Dyrbiš cil podać.',
	'lqt_move_thread_bad_destination' => 'Cilowa strona diskusijna strona njeje.',
	'lqt_move_samedestination' => 'Nitka je hižo na tutej stronje!',
	'lqt_move_noreason' => 'Žana přičina podata.',
	'lqt_move_success' => 'Tuta nitka je so do $1 přesunyła.',
	'lqt_delete_undeletethread' => 'Nitku wobnowić',
	'lqt_delete_partof' => "Tuta nitka je dźěl wot '''$1'''.",
	'lqt_delete_deleting' => "Wušmórnjeja so '''$1''' a '''wšě wotmołwy''' na nju.",
	'lqt_delete_deletethread' => 'Nitku a wotmołwy wušmórnyć.',
	'lqt_delete_deleted' => 'Nitka je so wušmórnyła.',
	'lqt_delete_undeleted' => 'Nitka je so wobnowiła.',
	'lqt_delete_return' => 'Wróć so k $1.',
	'lqt_delete_return_link' => 'diskusijna strona',
	'lqt_delete_unallowed' => 'Njesměš nitki wušmórować.',
	'lqt_delete_show_checkbox' => 'Wušmórnjene nitki pokazać',
	'lqt_talkpage_autocreate_summary' => 'Diskusijna strona je so awtomatisce wutworiła, hdyž bě so prěnja nitka wotesłała.',
	'lqt_header_warning_big' => 'Wobdźěłuješ $1.',
	'lqt_header_warning_after_big' => 'Hłowowe linki su za wozjewjenja a předsłowa. Chceš snano město toho $2.',
	'lqt_header_warning_bold' => 'Hłowowa linka diskusijneje strony',
	'lqt_header_warning_new_discussion' => 'nowu diskusiju započeć',
	'lqt_sorting_order' => 'Sortěrowanski porjad:',
	'lqt_sort_newest_changes' => 'Poslednje změnjene jako prěnje',
	'lqt_sort_newest_threads' => 'najnowše nitki jako přenje',
	'lqt_sort_oldest_threads' => 'najstarše nitki jako prěnje',
	'lqt-title' => 'Titul',
	'lqt-summary' => 'Zjeće',
	'lqt-searching' => 'Pytanje za nitkami',
	'lqt-read-message' => 'Jako přečitany markěrować',
	'lqt-read-message-tooltip' => 'Wotstroń tutu nitku z nowych powěsćow.
Budźe dale widźomna na prěnjotnej diskusijnej stronje.',
	'lqt-read-all' => 'Wšě jako přečitane markěrować',
	'lqt-read-all-tooltip' => 'Wotstroń wšě nitki z nowych powěsćow.
Budu dale widźomne na jich prěnjotnych diskusijnych stronach.
Tuta akcija da so cofnyć.',
	'lqt-marked-read' => "Nitka '''$1''' bu jako přečitana markěrowana.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|powěsć jako přečitana markěrowana|powěsći jako přečitanej markěrowanej|powěsće jako přečitane markěrowane|powěsćow jako přečitane markěrowane}}',
	'lqt-email-undo' => 'Cofnyć',
	'lqt-no-new-messages' => 'Nimaš nowe powěsće.',
	'lqt-new-messages' => '✒ Maš nowe powěsće.',
	'lqt-email-info-undo' => 'Wróć nitku, kotruž sy runje zaćisnył.',
	'lqt-date-info' => 'tutón wotkaz je znjemóžnjeny, dokelž sej nitki ze wšěch datumow wobhladuješ.',
	'lqt-newmessages-context' => 'Dospołna nitka',
	'lqt-thread-created' => 'Wutworjeny',
	'lqt-history-time' => 'Čas',
	'lqt-history-user' => 'Wužiwar',
	'lqt-history-action' => 'Aktiwita',
	'lqt-history-comment' => 'Komentar',
	'lqt-history-thread' => 'Nitka',
	'lqt-thread-edited-author' => 'Wot awtora wobdźěłany.<br />
Poslednja změna: $1',
	'lqt-thread-edited-others' => 'Wot {{PLURAL:$2|druheho wužiwarja|druheju wužiwarjow|druhich wužiwarjow|druhich wužiwarjow}} wobdźěłany.<br />
Poslednja změna: $1',
	'lqt-header-actions' => 'Akcije',
	'lqt_summarize_link' => 'zjeć',
	'lqt-summarize-intro' => 'Prošu zhorń slědowacu nitku we wobdźěłanskim kašćiku.
Móžeš někajki wikitekst w swojim zjeću wužiwać. Hdyž skónčiš, klikń na "{{int:savearticle}}".',
	'lqt-thread-split' => 'Do noweje nitki rozšćěpić',
	'lqt-split-success' => 'Sy wuspěšnje nitku $1 wotšćěpił.',
	'lqt_split_thread' => 'Nitku šćěpić',
	'lqt-thread-split-subject' => 'Tema noweje nitki:',
	'lqt-thread-split-thread' => 'Nitka:',
	'lqt-split-submit' => 'Šćěpić',
	'lqt_split_badsubject' => 'Tema, kotruž sy zapodał, je njepłaćiwa.',
	'lqt-no-threads' => 'Na tutej stronje hišće nitki njejsu.',
	'lqt-delete-parent-warning' => 'To je hłowna nitka z wotmołwami.
Jeje wotmołwy so tež awtomatisce wušmóruja.
Zo by to wobešoł, wotdźěl je wot tuteje nitki, prjedy hač ju wušmóruješ.',
	'lqt-delete-parent-deleted' => 'Nadrjadowana nitka wušmórnjena ($1)',
	'lqt-delete-replies-done' => 'Wšě wotmołwy k tutej nitce su tež hižo wušmórnjene.',
	'lqt-movethread' => 'přesunyć',
	'lqt-menu-trigger' => 'Wjac',
	'lqt-newmessages-from' => 'z $1',
	'lqt-hot-topics' => 'Najčasćišo čitane temy',
	'lqt-add-reply' => 'Wotmołwu přidać',
	'lqt_rc_new_discussion' => 'pósła nowu nitku, "$1"',
	'lqt_rc_new_reply' => 'pósła wotmołwu na "$1"',
	'right-lqt-split' => 'Nitki rozdźělić',
	'right-lqt-merge' => 'Nitki zjednoćić',
	'lqt-thread-merge' => 'z druhej nitku zjednoćić',
	'lqt-thread-merge-to' => 'Z tutej nitku zjednoćić',
	'lqt_merge_thread' => 'Nitku zjednoćić',
	'lqt-thread-merge-source' => 'Žórłowa nitka:',
	'lqt-thread-merge-dest' => 'Cilowa nitka:',
	'lqt-merge-submit' => 'Zjednoćić',
	'lqt-merge-success' => 'Sy nitku $1 wuspěšnje pod nitku $2 přesunył.',
	'lqt-log-name' => 'Protokol nitkoweje diskusije',
	'lqt-log-header' => 'Tutón protokol nalistuje akcije, kotrež su so na diskusijnych nitkach přewjedli.',
	'lqt-log-action-move' => 'přesuny [[$1]] wot [[$2]] do [[$3]].',
	'lqt-log-action-split' => 'wotdźěli [[$1]] z [[$3]] z nowej temu "$2"',
	'lqt-log-action-merge-across' => 'přesuny [[$1]] z [[$2]] do [[$3]]',
	'lqt-log-action-merge-down' => 'zapřija [[$1]] pod [[$3]]',
	'lqt-log-action-subjectedit' => 'změni temu wot [[$1]] z "$2" to "$3"',
	'lqt-log-action-resort' => 'změni sortěrowanski porjad wot [[$1]]. Změni sortěrowanski kluč wot $2 do $3',
	'lqt-preference-notify-talk' => 'E-mejl wo wotmołwach k nitce, kotraž so wobkedźbuje, pósłać',
	'lqt-preference-watch-threads' => 'Nitki wobkedźbować, kotrež tworju abo na kotrež wotmołwjam',
	'prefs-lqt' => 'Diskusija w nitkach',
	'lqt-preference-display-depth' => 'Maksimalna hłubokosć wotmołwow, kotraž ma so pokazać:',
	'lqt-preference-display-count' => 'Maksimalna ličba wotmołwow, kotraž ma so pokazać:',
	'lqt-preference-custom-signatures' => 'Swójske wužiwarske signatury pokazać',
	'lqt-enotif-subject-reply' => '{{SITENAME}} diskusija - wotmołwa: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} diskusija - nowa nitka: $1',
	'lqt-enotif-newthread' => "Witaj $1,

to je zdźělenka wot {{GRAMMAR:genitiw|{{SITENAME}}}}, zo je so nowa nitka na $5, '$2', $3 $4 wot $8 wutworiła.

Móžeš ju na <$6> widźeć.

Tekst je:
$7",
	'lqt-enotif-reply' => "Witaj $1,

to je zdźělenka z {{GRAMMAR:genitiw|{{SITENAME}}}}, zo je so nowa wotmołwa k '$2' na $5 $3 $4 wot $8 wutworiła.

Móžeš ju na <$6> widźeć

Tekst wotmołwy je:
$7",
	'lqt-quote-intro' => 'Dnja $2 $3 je [[User:$1|$1]] {{GENDER:$1|napisał|napisała|napisał}}:',
	'lqt-quote' => 'Citować',
	'lqt-search-legend' => 'Diskusije na tutej stronje přepytać',
	'lqt-search-label' => 'Pytanske zapřijeća:',
	'lqt-search-button' => 'Pytać',
	'searchprofile-threads' => 'Diskusije',
	'searchprofile-threads-tooltip' => 'Diskusije w nitkach a diskusijne strony přepytać',
	'lqt-ajax-updated' => 'Tuta nitka ma nowe powěsće.',
	'lqt-ajax-update-link' => 'Aktualizować',
	'lqt-thread-show-replies' => '$1 {{PLURAL:$1|wotmołwu|wotmołwje|wotmołwy|wotmołwow}} pokazać',
	'lqt-thread-show-more' => 'Dalše wotmołwy pokazać',
	'lqt-thread-link-url' => 'URL wotkaza:',
	'lqt-thread-link-title' => 'Wikitekstowy wotkaz:',
	'lqt-thread-link-copy' => 'Do mjezyskłada kopěrować',
	'lqt-sign-not-necessary' => 'Njetrjebaš swoju powěsć ze štyrjomi tildami podpisać.
Podpis pokazuje so awtomatisce.',
	'lqt-marked-as-read-placeholder' => 'Nitka $1 je so markěrowała jako přečitana.',
	'lqt-change-subject' => 'Temu změnić',
	'lqt-save-subject' => 'Składować',
	'lqt-save-subject-failed' => 'Při pospyće temu tuteje nitki změnić je zmylk wustupił: $1',
	'lqt-ajax-invalid-subject' => 'Tema, kotruž sy podał, bě njepłaćiwa, najskerje dokelž je předołha była.',
	'lqt-ajax-no-subject' => 'Dyrbiš temu podać.',
	'lqt-save-subject-error-unknown' => 'Při pospyće temu tuteje nitki podać, je njeznaty zmylk wustupił. Prošu klikń na "wobdźěłać", zo by to činił.',
	'lqt-cancel-subject-edit' => 'Přetorhnyć',
	'lqt-drag-activate' => 'Do noweho městna ćahnyć',
	'lqt-drag-drop-zone' => 'Tu wotkłasć',
	'lqt-drag-confirm' => 'Zo by slědowace akcije wuwjedł, zapisaj prošu přičinu a klikń na "Wobkrućić".',
	'lqt-drag-reparent' => 'Powěsć pod nowe nadpismo přesunyć.',
	'lqt-drag-split' => 'Powěsć do swojeje nitki přesunyć',
	'lqt-drag-setsortkey' => 'Poziciju powěsće na stronje skorigować',
	'lqt-drag-bump' => 'Powěsć na spočatk diskusijneje strony přesunyć',
	'lqt-drag-save' => 'Wobkrućić',
	'lqt-drag-title' => 'Ćehnjenje wobkrućić',
	'lqt-drag-reason' => 'Přičina:',
	'lqt-drag-subject' => 'Nadpismo za nowu nitku:',
	'lqt-edit-signature' => '(podpis wobdźěłać)',
	'lqt-preview-signature' => '(přehlad)',
	'lqt-feed-title-all' => '{{SITENAME}} - nowe powěsće',
	'lqt-feed-title-all-from' => '{{SITENAME}} - nowe powěsće z $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} - nowe nitki',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} - nowe nitki z $1',
	'lqt-feed-title-replies' => '{{SITENAME}} - wotmołwy',
	'lqt-feed-title-replies-from' => '{{SITENAME}} - wotmołwy z $1',
	'lqt-feed-new-thread-intro' => 'Nowa nitka na $1 pósłana wot $2',
	'lqt-feed-reply-intro' => 'Wotmołwa na $3 (na $1) pósłana wot $2',
	'tooltip-pt-newmessages' => 'Pokazuje nowe powěsće k nitkam abo na diskusijnych stronach nitkow, kotrež wobkedźbuješ',
	'lqt-newmessages-n' => 'nowe powěsće ($1)',
	'lqt_newmessages' => 'Nowe powěsće (žane)',
	'lqt_newmessages-title' => 'Nowe powěsće',
	'lqt-newpost-summary' => 'Nowa nitka: $1',
	'lqt-reply-summary' => 'Wotmołwa na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historija diskusijneje strony',
	'lqt-talkpage-history-subtitle' => 'Za $1',
	'lqt-talkpage-history-tab' => 'Hłowa',
	'restriction-reply' => 'Wotmołwy pósłać',
	'restriction-newthread' => 'Nowe nitki pósłać',
	'lqt-protected-reply-thread' => 'Njemóžeš w tutej nitce powěsć słać, dokelž so přećiwo nowym powěsćam škituje.',
	'lqt-protected-reply-talkpage' => 'Njemóžeš w tutej nitce powěsć słać, dokelž je so diskusijna strona přećiwo wotmołwam do jeje nitki škitała.',
	'lqt-protected-newthread' => 'Njemóžeš nowe nitki do diskusijneje strony słać, dokelž je so přećiwo nowym nitkam škitała.',
	'lqt-edit-bump' => 'Tutu nitku aktiwizować',
	'lqt-edit-bump-tooltip' => 'Tutu nitku do spočatka jeje diskusijneje strony přesunyć',
	'lqt-historicalrevision-error' => 'Wersija, kotruž sy wubrał, je wobškodźena a njeda so pokazać.',
	'lqt-reply-subpage' => 'wotmołwić',
	'nstab-thread' => 'Nitka',
	'nstab-summary' => 'Zjeće',
);

/** Haitian (Kreyòl ayisyen)
 * @author Boukman
 * @author Internoob
 */
$messages['ht'] = array(
	'lqt-no-new-messages' => 'Pa gen nouvo mesaj pou ou.',
	'lqt_newmessages' => 'Nouvo mesaj',
);

/** Hungarian (Magyar)
 * @author BáthoryPéter
 * @author Dani
 * @author Enbéká
 * @author Glanthor Reviol
 * @author Hunyadym
 * @author Tgr
 */
$messages['hu'] = array(
	'lqt-desc' => 'Beszélgetésfolyam alapú megbeszélések a vitalapokon',
	'lqt_movethread' => 'Téma áthelyezése egy másik lapra',
	'lqt_deletethread' => 'Téma törlése vagy helyreállítása',
	'lqt_contents_title' => 'Tartalomjegyzék',
	'lqt_toc_thread_title' => 'Téma címe',
	'lqt_toc_thread_author' => 'Indította',
	'lqt_toc_thread_replycount' => 'Hozzászólások',
	'lqt_toc_thread_modified' => 'Utolsó módosítás',
	'lqt_add_header' => 'Fejléc hozzáadása',
	'lqt_new_thread' => 'Új téma indítása',
	'lqt_invalid_subject' => 'A megadott tárgy érvénytelen, mert:
* túl hosszú, vagy
* ütközik névtérközi hivatkozások előtagjával vagy névterek nevével.',
	'lqt_empty_subject' => 'Meg kell adnod a tárgyat.',
	'lqt_reply' => 'válasz',
	'lqt-parent' => 'Szülő',
	'lqt_delete' => 'törlés',
	'lqt_undelete' => 'visszaállítás',
	'lqt_permalink' => 'hivatkozás',
	'lqt_fragment' => 'Egy $1 részlete a(z) $2 lapról',
	'lqt_discussion_link' => 'beszélgetésfolyam',
	'lqt_from_talk' => 'A(z) $1 lapról',
	'lqt-history-title' => 'A téma előzményei',
	'lqt_hist_comment_edited' => '[$2 Szerkesztette] a megjegyzést',
	'lqt_hist_summary_changed' => 'Megváltoztatta az összefoglalót',
	'lqt_hist_reply_created' => '[[$1|Új hozzászólást]] írt',
	'lqt_hist_thread_created' => 'Új témát indított',
	'lqt_hist_deleted' => 'törölve',
	'lqt_hist_undeleted' => 'visszaállítva',
	'lqt_hist_moved_talkpage' => 'áthelyezve',
	'lqt_hist_listing_subtitle' => 'Előzmények megtekintése',
	'lqt_hist_view_whole_thread' => 'Az egész téma előzményeinek megtekintése',
	'lqt_hist_no_revisions_error' => 'Ennek a témának nincsenek előzményei.',
	'lqt_hist_past_last_page_error' => 'Túl vagy az előzmény oldalainak számán.',
	'lqt_hist_tooltip_newer_disabled' => 'Ez a hivatkozás le van tiltva, mert az első lapon vagy.',
	'lqt_hist_tooltip_older_disabled' => 'Ez a hivatkozás le van tiltva, mert az utolsó lapon vagy.',
	'lqt_hist_split' => 'Válasz áthelyezve új témába',
	'lqt_hist_edited_subject' => 'Szerkesztette a tárgyat: „$2” → „$3”',
	'lqt_hist_edited_subject_corrupt' => 'Módosította a tárgyat',
	'lqt_hist_merged_from' => '[[$1|Hozzászólás]] áthelyezve egy másik témába',
	'lqt_hist_merged_to' => '[[$1|Hozzászólás]] áthelyezve ide egy másik témából',
	'lqt_hist_split_from' => 'Áthelyezés új témába',
	'lqt_hist_root_blanked' => 'Eltávolította a megjegyzést',
	'lqt_hist_adjusted_sortkey' => 'Módosította a téma helyét',
	'lqt_revision_as_of' => '$2 $3-kori változat',
	'lqt_change_new_thread' => 'Ez a téma első változata',
	'lqt_change_reply_created' => 'A [$1 kiemelt megjegyzés] ennél a változatnál készült.',
	'lqt_change_edited_root' => 'A [$1 kiemelt megjegyzés] ennél a változatnál volt szerkesztve.',
	'lqt_change_edited_summary' => 'Szerkesztette a téma összefoglalóját',
	'lqt_change_deleted' => '[$1 Ez] (vagy az ezt tartalmazó) téma törölve lett',
	'lqt_change_undeleted' => 'A [$1 kiemelt hozzászólás] helyre lett állítva',
	'lqt_change_moved' => '[$1 A téma] át lett helyezve egy másik vitalapra',
	'lqt_change_split' => '[$1 A téma] egy másik témából lett kivéve',
	'lqt_change_edited_subject' => 'Megváltozott a téma tárgya: „$2” → „$3”',
	'lqt_change_merged_from' => 'Egy [$1 válasz] át lett helyezve egy másik témába',
	'lqt_change_merged_to' => 'A [$1 kiemelt válasz] egy másik témából lett áthelyezve',
	'lqt_change_split_from' => 'A téma egyik [$1 beszélgetés]e önálló témává lett alakítva',
	'lqt_change_root_blanked' => '[$1 Egy megjegyzés] szövege el lett távolítva.',
	'lqt_youhavenewmessages' => '[[$1|Új üzeneted]] érkezett.',
	'lqt_protectedfromreply' => 'Ehhez a témához nem lehet választ fűzni, mert $1.',
	'lqt_protectedfromreply_link' => 'le van védve',
	'lqt_subject' => 'Tárgy:',
	'lqt_noreason' => 'Nincs ok megadva.',
	'lqt_move_placeholder' => 'Ez a beszélgetésfolyam csupán jelzésként maradt itt, hogy jelezze, a(z) $1 beszélgetésfolyamot áthelyezték erről a lapról.
A műveletet $2 hajtotta végre $3 $4-kor. A beszélgetésfolyam most a következő helyen található: $5.',
	'lqt_thread_deleted_for_sysops' => "A témát '''törölték''', és csak adminisztrátorok számára látható.",
	'lqt_thread_deleted' => 'A témát törölték.',
	'lqt_summary_notice' => 'Nem történt változás az utolsó {{PLURAL:$2||$2}} nap során.
Ha a beszélgetés befejeződött, $1.',
	'lqt_summary_notice_link' => 'írhatsz összefoglalót',
	'lqt_summary_label' => 'Téma összefoglalása:',
	'lqt_summary_subtitle' => 'A(z) „$1” összefoglalója',
	'lqt_nosuchrevision' => 'A témának nincs ilyen előzménye.',
	'lqt_nosuchthread' => 'A megadott téma nem létezik.',
	'lqt_nosuchthread_title' => 'Nincs ilyen téma',
	'lqt_threadrequired' => 'Meg kell adnod a téma URL-címét',
	'lqt_move_movingthread' => 'A következő téma áthelyezése: $1
Jelenleg a(z) $2 című lap része.',
	'lqt_move_torename' => 'A téma átnevezéséhez a $1 változtasd meg a „Tárgy” mezőt.',
	'lqt_move_torename_edit' => 'szerkesztés során',
	'lqt_move_destinationtitle' => 'Cél vitalap neve',
	'lqt_move_move' => 'Átmozgatás',
	'lqt_move_nodestination' => 'Meg kell adnod a célt.',
	'lqt_move_thread_bad_destination' => 'A céllap nem vitalap.',
	'lqt_move_samedestination' => 'A téma már ezen a lapon van!',
	'lqt_move_noreason' => 'Nincs ok megadva.',
	'lqt_move_success' => 'A téma át lett helyezve a(z) $1 című lapra.',
	'lqt_delete_undeletethread' => 'Téma visszaállítása',
	'lqt_delete_partof' => "Ez a téma a(z) '''$1''' című lap része.",
	'lqt_delete_deleting' => "'''$1''' és a hozzá tartozó '''összes válasz''' törlése.",
	'lqt_delete_deletethread' => 'A téma és a hozzá tartozó válaszok törlése',
	'lqt_delete_deleted' => 'Téma törölve.',
	'lqt_delete_undeleted' => 'Téma helyreállítva.',
	'lqt_delete_return' => 'Visszatérés a $1.',
	'lqt_delete_return_link' => 'vitalapra',
	'lqt_delete_unallowed' => 'Nincs jogosultságod témákat törölni.',
	'lqt_delete_show_checkbox' => 'Törölt témák megjelenítése',
	'lqt_talkpage_autocreate_summary' => 'A vitalap automatikusan létrejött az első téma elküldésekor',
	'lqt_header_warning_big' => 'Te most egy $1 szerkesztesz.',
	'lqt_header_warning_after_big' => 'A fejlécek bejelentések és előszavak számára vannak. Nem $2 akarsz indítani?',
	'lqt_header_warning_bold' => 'vitalap-fejlécet',
	'lqt_header_warning_new_discussion' => 'új beszélgetést',
	'lqt_sorting_order' => 'Rendezés:',
	'lqt_sort_newest_changes' => 'legutóbb módosítottak előre',
	'lqt_sort_newest_threads' => 'legújabb témák előre',
	'lqt_sort_oldest_threads' => 'legrégebbi témák előre',
	'lqt-title' => 'Cím',
	'lqt-summary' => 'Összefoglaló',
	'lqt-searching' => 'Témák keresése',
	'lqt-read-message' => 'Elolvastam',
	'lqt-read-message-tooltip' => 'Az üzenet eltávolítása az új üzenetek közül.
Az őt tartalmazó vitalapon továbbra is megtekinthető lesz.',
	'lqt-read-all' => 'Az összes megjelölése olvasottként',
	'lqt-read-all-tooltip' => 'Az összes téma eltávolítása az új üzenetek közül
Az őket tartalmazó vitalapokon továbbra is megtekinthetőek lesznek.
A művelet nem vonható vissza.',
	'lqt-marked-read' => "A következő téma olvasottnak lett jelölve: '''$1'''.",
	'lqt-count-marked-read' => '$1 üzenet olvasottnak lett jelölve.',
	'lqt-email-undo' => 'Visszavonás',
	'lqt-no-new-messages' => 'Nincsenek új üzeneteid.',
	'lqt-new-messages' => '✒ Új üzeneteid vannak.',
	'lqt-email-info-undo' => 'A most eltüntetett téma visszaállítása.',
	'lqt-date-info' => 'Ez a hivatkozás le van tiltva, mert az összes dátumhoz tartozó témákat nézed.',
	'lqt-newmessages-context' => 'Az egész téma',
	'lqt-thread-created' => 'Létrehozás ideje',
	'lqt-history-time' => 'Időpont',
	'lqt-history-user' => 'Szerkesztő',
	'lqt-history-action' => 'Tevékenység',
	'lqt-history-comment' => 'Megjegyzés',
	'lqt-history-thread' => 'Téma',
	'lqt-thread-edited-author' => 'A szerző módosította a hozzászólást.<br />
Utolsó szerkesztés: $1',
	'lqt-thread-edited-others' => '{{PLURAL:$2|Egy|$2}} szerkesztő módosította a hozzászólást.<br />
Utolsó szerkesztés: $1',
	'lqt-header-actions' => 'Műveletek',
	'lqt_summarize_link' => 'Összefoglalás',
	'lqt-summarize-intro' => 'Összegezd az alábbi témát.
A szövegben használhatod a wiki jelölőnyelvét.
Ha befejezted, kattints a „{{int:savearticle}}” gombra.',
	'lqt-thread-split' => 'Átalakítás önálló témává',
	'lqt-split-success' => 'Sikeresen szétválasztottad a(z) $1 témát.',
	'lqt_split_thread' => 'Téma szétválasztása',
	'lqt-thread-split-subject' => 'Az új téma tárgya:',
	'lqt-thread-split-thread' => 'Téma:',
	'lqt-split-submit' => 'Szétválasztás',
	'lqt_split_badsubject' => 'A megadott tárgy érvénytelen.',
	'lqt-no-threads' => 'Ezen a lapon még nincsenek témák.',
	'lqt-delete-parent-warning' => 'Ez egy legfelsőbb szintű téma válaszokkal.
A hozzá tartozó válaszok automatikusan törölve lesznek.
Ha ezt meg szeretnéd akadályozni, válaszd szét a témát, mielőtt törölnéd.',
	'lqt-delete-parent-deleted' => 'Az őt tartalmazó téma törölve lett ($1)',
	'lqt-delete-replies-done' => 'A témahoz tartozó összes válasz is törölve lett.',
	'lqt-movethread' => 'Áthelyezés',
	'lqt-menu-trigger' => 'több',
	'lqt-newmessages-from' => 'Helye: $1',
	'lqt-hot-topics' => 'Aktuális témák',
	'lqt-add-reply' => 'Válasz írása',
	'lqt_rc_new_discussion' => 'új témát indított „$1” címmel',
	'lqt_rc_new_reply' => 'Válasz erre: „$1”',
	'right-lqt-split' => 'témák szétválasztása',
	'right-lqt-merge' => 'témák összevonása',
	'lqt-thread-merge' => 'Összevonás egy másik témával',
	'lqt-thread-merge-to' => 'Összevonás ezzel a témával',
	'lqt_merge_thread' => 'Témák összevonása',
	'lqt-thread-merge-source' => 'Forrás téma:',
	'lqt-thread-merge-dest' => 'Cél téma:',
	'lqt-merge-submit' => 'Összevonás',
	'lqt-merge-success' => 'Sikeresen beolvasztottad a(z) $1 témát a(z) $2 alá',
	'lqt-log-name' => 'Témanapló',
	'lqt-log-header' => 'Ez a napló a témákon elvégzett műveleteket listázza.',
	'lqt-log-action-move' => 'áthelyezte a(z) [[$1]] témátt a(z) [[$2]] lapról a(z) [[$3]] lapra.',
	'lqt-log-action-split' => '[[$1]] leválasztása [[$3]] alól. Új tárgy: „$2“',
	'lqt-log-action-merge-across' => '[[$1]] mozgatása [[$2]] alól [[$3]] alá',
	'lqt-log-action-merge-down' => '[[$1]] összevonva [[$3]] alá',
	'lqt-log-action-subjectedit' => '[[$1]] tárgyának megváltoztatása erről "$2" erre "$3"',
	'lqt-log-action-resort' => '[[$1]] sorrendje módosult. A rendezési kulcs erről "$2" erre "$3" változott',
	'lqt-preference-notify-talk' => 'Értesítés e-mailben, ha az általam figyelt témákhoz válasz érkezik',
	'lqt-preference-watch-threads' => 'Az általam létrehozott és a válaszaimat tartalmazó témák felvétele a figyelőlistára',
	'prefs-lqt' => 'Témák',
	'lqt-preference-display-depth' => 'A megjelenített válaszok mélysége, legfeljebb:',
	'lqt-preference-display-count' => 'A megjelenített válaszok száma, legfeljebb:',
	'lqt-preference-custom-signatures' => 'Felhasználók egyéni aláírásainak megjelenítése',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-megbeszélés – Válasz: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-megbeszélés – Új téma: $1',
	'lqt-enotif-newthread' => 'Szia, $1!
Ez egy értesítés a(z) {{SITENAME}} wikiről. Új témát indítottak a(z) $5 lapon „$2” címmel, $3 $4-kor.

A következő címen tekintheted meg: <$6>',
	'lqt-enotif-reply' => '!Szia, $1!
Ez egy {{SITENAME}}-értesítés. Új válasz érkezett a(z) „$2” című témához a(z) $5 lapon, $3 $4-kor.

A következő címen tekintheted meg: <$6>

A válasz szövege:
$7',
	'lqt-quote-intro' => '[[User:$1|$1]] írta, $2 $3-kor:',
	'lqt-quote' => 'idéz',
	'lqt-search-legend' => 'Beszélgetések keresése ezen a lapon',
	'lqt-search-label' => 'Keresett kifejezés:',
	'lqt-search-button' => 'Keresés',
	'searchprofile-threads' => 'Beszélgetések',
	'searchprofile-threads-tooltip' => 'Keresés a témákban és a vitalapokon',
	'lqt-ajax-updated' => 'Új hozzászólások érkeztek a témához.',
	'lqt-ajax-update-link' => 'Frissítés',
	'lqt-thread-show-replies' => '$1 hozzászólás megjelenítése',
	'lqt-thread-show-more' => 'További hozzászólások megjelenítése',
	'lqt-thread-link-url' => 'Hivatkozás URL-címe:',
	'lqt-thread-link-title' => 'Wikiszöveg-hivatkozás:',
	'lqt-thread-link-copy' => 'Másolás a vágólapra',
	'lqt-sign-not-necessary' => 'Nem szükséges aláírnod a hozzászólásodat négy hullámvonallal.
Az aláírásod automatikusan meg fog jelenni.',
	'lqt-marked-as-read-placeholder' => 'A következő téma olvasottnak lett jelölve: $1.',
	'lqt-change-subject' => 'Tárgy megváltoztatása',
	'lqt-save-subject' => 'Mentés',
	'lqt-save-subject-failed' => 'A téma tárgyának megváltoztatása közben a következő hiba történt: $1',
	'lqt-ajax-invalid-subject' => 'A megadott tárgy érvénytelen, valószínűleg mert túl hosszú volt.',
	'lqt-ajax-no-subject' => 'Meg kell adnod a tárgyat.',
	'lqt-save-subject-error-unknown' => 'Ismeretlen hiba történt a téma tárgyának megváltoztatása közben. Próbálkozz újra a legfelső hozzászólás mellett található „szerkesztés” linkre való kattintással.',
	'lqt-cancel-subject-edit' => 'Mégse',
	'lqt-drag-activate' => 'Húzd az új helyre',
	'lqt-drag-drop-zone' => 'Helyezd ide',
	'lqt-drag-confirm' => 'A művelet befejezéseként kérlek töltsd ki az indoklást, majd kattints a „Megerősítés” gombra.',
	'lqt-drag-reparent' => 'Hozzászólás áthelyezése másik hozzászólás alá.',
	'lqt-drag-split' => 'Hozzászólás áthelyezése új témába',
	'lqt-drag-setsortkey' => 'Beszélgetés áthelyezése a lapon belül',
	'lqt-drag-bump' => 'Téma áthelyezése a vitalap tetejére',
	'lqt-drag-save' => 'Megerősítés',
	'lqt-drag-title' => 'Áthelyezés megerősítése',
	'lqt-drag-reason' => 'Indoklás:',
	'lqt-drag-subject' => 'Az új téma tárgya:',
	'lqt-edit-signature' => '(aláírás szerkesztése)',
	'lqt-preview-signature' => '(előnézet)',
	'lqt-feed-title-all' => '{{SITENAME}} – új hozzászólások',
	'lqt-feed-title-all-from' => '{{SITENAME}} – új hozzászólások a(z) $1 {{PLURAL:$2|lapról|lapokról}}',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – új témák',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – új témák a következő {{PLURAL:$2|lapról|lapokról}}: $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – válaszok',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – válaszok a(z) $1 {{PLURAL:$2|lapról|lapokról}}',
	'lqt-feed-new-thread-intro' => '$2 új témát indított a(z) $1 lapon',
	'lqt-feed-reply-intro' => '$2 új hozzászólást írt a(z) $3 témához a(z) $1 lapon',
	'lqt-newmessages-n' => 'Új üzenetek ($1)',
	'lqt_newmessages' => 'Új üzenetek (nincs)',
	'lqt_newmessages-title' => 'Új üzenetek',
	'lqt-newpost-summary' => 'Új téma: $1',
	'lqt-reply-summary' => 'Válasz a következő témára: [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Beszélgetés laptörténete',
	'lqt-talkpage-history-subtitle' => 'A(z) $1 lapról',
	'lqt-talkpage-history-tab' => 'Fejléc',
	'restriction-reply' => 'hozzászólások küldése',
	'restriction-newthread' => 'új témák indítása',
	'lqt-protected-reply-thread' => 'Nem szólhatsz hozzá ehhez a témához, mert le van védve az új hozzászólások ellen.',
	'lqt-protected-reply-talkpage' => 'Nem szólhatsz hozzá ehhez a témához, mert a lap le van védve a hozzászólások ellen.',
	'lqt-protected-newthread' => 'Nem indíthatsz új témát ezen a lapon, mert le van védve az újak létrehozása ellen.',
	'lqt-edit-bump' => 'Téma előrehozása',
	'lqt-edit-bump-tooltip' => 'Téma áthelyezése a vitalap tetejére',
	'lqt-historicalrevision-error' => 'A kiválasztott változat hibás, nem lehet megnézni.',
	'lqt-reply-subpage' => 'válasz',
	'nstab-thread' => 'Téma',
	'nstab-summary' => 'Összefoglaló',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'lqt-desc' => 'Adde discussiones in filos al paginas de discussion',
	'lqt_movethread' => 'Displaciar le filo verso un altere pagina',
	'lqt_deletethread' => 'Deler o restaurar filo',
	'lqt_contents_title' => 'Contento',
	'lqt_toc_thread_title' => 'Titulo del filo',
	'lqt_toc_thread_author' => 'Comenciate per',
	'lqt_toc_thread_replycount' => 'Responsas',
	'lqt_toc_thread_modified' => 'Ultime modification',
	'lqt_add_header' => 'Adder capite',
	'lqt_new_thread' => 'Initiar un nove discussion',
	'lqt_invalid_subject' => 'Le subjecto que tu entrava es invalide. Illo pote:
* esser troppo longe, o
* confliger con prefixos interwiki o nomines de spatios de nomines.',
	'lqt_empty_subject' => 'Tu debe entrar un subjecto.',
	'lqt_reply' => 'Responder',
	'lqt-parent' => 'Genitor',
	'lqt_delete' => 'Deler',
	'lqt_undelete' => 'Restaurar',
	'lqt_permalink' => 'Ligamine permanente',
	'lqt_fragment' => 'Fragmento de un $1 ex $2',
	'lqt_discussion_link' => 'discussion',
	'lqt_from_talk' => 'De $1',
	'lqt-history-title' => 'Historia del filo',
	'lqt_hist_comment_edited' => 'Texto del commento [$2 modificate]',
	'lqt_hist_summary_changed' => 'Summario modificate',
	'lqt_hist_reply_created' => '[[$1|Nove responsa]] create',
	'lqt_hist_thread_created' => 'Nove filo create',
	'lqt_hist_deleted' => 'Delite',
	'lqt_hist_undeleted' => 'Restaurate',
	'lqt_hist_moved_talkpage' => 'Displaciate',
	'lqt_hist_listing_subtitle' => 'Visualisation de un lista historic',
	'lqt_hist_view_whole_thread' => 'Vider le historia de tote le filo',
	'lqt_hist_no_revisions_error' => 'Iste filo non ha alcun versiones historic.',
	'lqt_hist_past_last_page_error' => 'Tu ha excedite le numero de paginas de historia existente.',
	'lqt_hist_tooltip_newer_disabled' => 'Iste ligamine non es active post que tu es in le prime pagina.',
	'lqt_hist_tooltip_older_disabled' => 'Iste ligamine non es active post que tu es in le ultime pagina.',
	'lqt_hist_split' => 'Responsa separate in un nove filo',
	'lqt_hist_edited_subject' => 'Subjecto cambiate de "$2" a "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Subjecto cambiate',
	'lqt_hist_merged_from' => '[[$1|Responsa]] transferite in un altere filo',
	'lqt_hist_merged_to' => '[[$1|Responsa]] transferite ex un altere filo',
	'lqt_hist_split_from' => 'Separar in un nove filo',
	'lqt_hist_root_blanked' => 'Texto del commento removite',
	'lqt_hist_adjusted_sortkey' => 'Position del filo adjustate',
	'lqt_revision_as_of' => 'Version del $2 a $3.',
	'lqt_change_new_thread' => 'Isto es le version initial del filo.',
	'lqt_change_reply_created' => 'Le [$1 commento mittite in evidentia] esseva create in iste version.',
	'lqt_change_edited_root' => 'Le [$1 commento mittite in evidentia] esseva modificate in iste version.',
	'lqt_change_edited_summary' => 'Le summario del filo esseva modificate',
	'lqt_change_deleted' => '[$1 Iste filo] o su genitor esseva delite',
	'lqt_change_undeleted' => 'Le [$1 message mittite in evidentia] esseva restaurate',
	'lqt_change_moved' => '[$1 Iste filo] esseva transferite a un altere pagina de discussion',
	'lqt_change_split' => '[$1 Iste filo] ha essite separate de un altere filo',
	'lqt_change_edited_subject' => 'Le subjecto de iste filo ha essite cambiate de "$2" a "$3"',
	'lqt_change_merged_from' => 'Un [$1 responsa] a iste filo ha essite transferite a un altere filo',
	'lqt_change_merged_to' => 'Le [$1 responsa mittite in evidentia] ha essite transferite ex un altere filo',
	'lqt_change_split_from' => 'Un [$1 subfilo] de iste filo ha essite separate in su proprie filo',
	'lqt_change_root_blanked' => 'Le texto de [$1 un commento] esseva removite.',
	'lqt_youhavenewmessages' => 'Tu ha [[$1|nove messages]].',
	'lqt_protectedfromreply' => 'Iste filo ha essite $1 contra responsas.',
	'lqt_protectedfromreply_link' => 'protegite',
	'lqt_subject' => 'Subjecto:',
	'lqt_noreason' => 'Nulle motivo specificate.',
	'lqt_move_placeholder' => 'Iste filo es un substituto indicante que un filo, $1, ha essite displaciate ab iste pagina.
Iste displaciamento ha essite facite per $2 le $3 a $4. Le filo se trova ora a $5.',
	'lqt_thread_deleted_for_sysops' => "Iste filo ha essite '''delite''' e es solmente visibile al administratores.",
	'lqt_thread_deleted' => 'Iste filo ha essite delite.',
	'lqt_summary_notice' => 'Nihil ha essite modificate in iste discussion depost al minus $2 {{PLURAL:$2|die|dies}}.
Si illo ha concludite, tu pote considerar $1.',
	'lqt_summary_notice_link' => 'scriber un summario',
	'lqt_summary_label' => 'Summario del filo:',
	'lqt_summary_subtitle' => 'Summario de "$1"',
	'lqt_nosuchrevision' => 'Iste version del filo non existe.',
	'lqt_nosuchthread' => 'Le filo que tu specificava non existe.',
	'lqt_nosuchthread_title' => 'Filo non existe',
	'lqt_threadrequired' => 'Tu debe specificar un filo in le adresse URL.',
	'lqt_move_movingthread' => 'Displaciamento de $1.
Iste filo face parte de $2.',
	'lqt_move_torename' => "Pro renominar iste filo, $1 e cambia le campo 'Subjecto'.",
	'lqt_move_torename_edit' => 'modifica lo',
	'lqt_move_destinationtitle' => 'Titulo del pagina de discussion de destination:',
	'lqt_move_move' => 'Displaciar',
	'lqt_move_nodestination' => 'Tu debe specificar un destination.',
	'lqt_move_thread_bad_destination' => 'Le pagina de destination non es un pagina de discussion.',
	'lqt_move_samedestination' => 'Le filo es jam presente in iste pagina!',
	'lqt_move_noreason' => 'Nulle ration date.',
	'lqt_move_success' => 'Le filo ha essite displaciate verso $1.',
	'lqt_delete_undeletethread' => 'Restaurar filo',
	'lqt_delete_partof' => "Iste filo face parte de '''$1'''.",
	'lqt_delete_deleting' => "Deletion de '''$1''' e de '''tote le responsas''' a illo.",
	'lqt_delete_deletethread' => 'Deler filo e responsas',
	'lqt_delete_deleted' => 'Le filo ha essite delite.',
	'lqt_delete_undeleted' => 'Le filo ha essite restaurate.',
	'lqt_delete_return' => 'Retornar a $1.',
	'lqt_delete_return_link' => 'le pagina de discussion',
	'lqt_delete_unallowed' => 'Tu non ha le permission de deler filos.',
	'lqt_delete_show_checkbox' => 'Revelar filos delite',
	'lqt_talkpage_autocreate_summary' => 'Pagina de discussion create automaticamente al invio del prime filo.',
	'lqt_header_warning_big' => 'Tu modifica un $1.',
	'lqt_header_warning_after_big' => 'Le capites es pro annuncios e prefacios.
In altere caso es preferite $2.',
	'lqt_header_warning_bold' => 'capite de pagina de discussion',
	'lqt_header_warning_new_discussion' => 'initiar un nove discussion',
	'lqt_sorting_order' => 'Ordination:',
	'lqt_sort_newest_changes' => 'ultime modificates primo',
	'lqt_sort_newest_threads' => 'nove filos primo',
	'lqt_sort_oldest_threads' => 'le filos le plus ancian primo',
	'lqt-title' => 'Titulo',
	'lqt-summary' => 'Summario',
	'lqt-searching' => 'Recerca de filos',
	'lqt-read-message' => 'Marcar como legite',
	'lqt-read-message-tooltip' => 'Remover iste filo del nove messages.
Illo resta visibile in su pagina de discussion original.',
	'lqt-read-all' => 'Marcar toto como legite',
	'lqt-read-all-tooltip' => 'remover tote le filos de nove messages.
Illos essera ancora visibile in lor paginas de discussion original.
Iste operation es reversibile.',
	'lqt-marked-read' => "Filo '''$1''' marcate como legite.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|message|messages}} marcate como legite.',
	'lqt-email-undo' => 'Disfacer',
	'lqt-no-new-messages' => 'Il non ha nove messages pro te.',
	'lqt-new-messages' => '✒ Tu ha recipite nove messages.',
	'lqt-email-info-undo' => 'Restabilir le filo que tu justo dimitteva.',
	'lqt-date-info' => 'Iste ligamine es disactivate proque tu reguarda le filos de tote le datas.',
	'lqt-newmessages-context' => 'Filo complete',
	'lqt-thread-created' => 'Create',
	'lqt-history-time' => 'Hora',
	'lqt-history-user' => 'Usator',
	'lqt-history-action' => 'Activitate',
	'lqt-history-comment' => 'Commento',
	'lqt-history-thread' => 'Filo',
	'lqt-thread-edited-author' => 'Modificate per le autor<br />
Ultime modification: $1',
	'lqt-thread-edited-others' => 'Modificate per {{PLURAL:$2|un altere usator|$2 usatores}}.<br />
Ultime modification: $1',
	'lqt-header-actions' => 'Actiones',
	'lqt_summarize_link' => 'Summarisar',
	'lqt-summarize-intro' => 'Per favor summarisa le filo ci infra in le quadro de modification.
Tu pote usar qualcunque wikitexto in tu summario. Quando tu fini, clicca super "{{int:savearticle}}".',
	'lqt-thread-split' => 'Separar in un nove filo',
	'lqt-split-success' => 'Tu ha separate le nove filo $1 con successo.',
	'lqt_split_thread' => 'Separar un filo',
	'lqt-thread-split-subject' => 'Subjecto del nove filo:',
	'lqt-thread-split-thread' => 'Filo:',
	'lqt-split-submit' => 'Separar',
	'lqt_split_badsubject' => 'Le subjecto que tu ha entrate es invalide.',
	'lqt-no-threads' => 'Il non ha ancora filos in iste pagina.',
	'lqt-delete-parent-warning' => 'Isto es un filo de alte nivello con responsas.
Su responsas essera tamben delite automaticamente.
Pro evitar isto, separa los de iste filo ante de deler lo.',
	'lqt-delete-parent-deleted' => 'Discussion genitor delite ($1)',
	'lqt-delete-replies-done' => 'Tote le responsas a iste filo ha tamben essite delite.',
	'lqt-movethread' => 'Displaciar',
	'lqt-menu-trigger' => 'Plus',
	'lqt-newmessages-from' => 'De $1',
	'lqt-hot-topics' => 'Topicos popular',
	'lqt-add-reply' => 'Adder un responsa',
	'lqt_rc_new_discussion' => 'comenciava un nove discussion "$1"',
	'lqt_rc_new_reply' => 'publicava un responsa a "$1"',
	'right-lqt-split' => 'Separar filos',
	'right-lqt-merge' => 'Fusionar filos',
	'right-lqt-react' => 'Responder a filos de discussion',
	'lqt-thread-merge' => 'Fusionar in un altere filo',
	'lqt-thread-merge-to' => 'Fusionar in iste filo',
	'lqt_merge_thread' => 'Fusionar filo',
	'lqt-thread-merge-source' => 'Filo de origine:',
	'lqt-thread-merge-dest' => 'Filo de destination:',
	'lqt-merge-submit' => 'Fusionar',
	'lqt-merge-success' => 'Tu ha fusionate le filo $1 in $2 con successo.',
	'lqt-log-name' => 'Registro de filos de discussion',
	'lqt-log-header' => 'Iste registro detalia le actiones prendite in le filos de discussion.',
	'lqt-log-action-move' => 'displaciava [[$1]] de [[$2]] a [[$3]]',
	'lqt-log-action-split' => 'separava [[$1]] de sub [[$3]], con le nove subjecto "$2".',
	'lqt-log-action-merge-across' => 'displaciava [[$1]] de sub [[$2]] a sub [[$3]].',
	'lqt-log-action-merge-down' => 'fusionava [[$1]] sub [[$3]]',
	'lqt-log-action-subjectedit' => 'cambiava le subjecto de [[$1]] de "$2" a "$3"',
	'lqt-log-action-resort' => 'modificava le ordine de assortimento de [[$1]]. Cambiava le clave de assortimento de $2 a $3.',
	'lqt-preference-notify-talk' => 'Inviar me un e-mail quando il ha responsas in un filo que io observa',
	'lqt-preference-watch-threads' => 'Observar filos que io crea o al quales io responde',
	'prefs-lqt' => 'Discussion in filos',
	'lqt-preference-display-depth' => 'Profunditate maximal de responsas a monstrar:',
	'lqt-preference-display-count' => 'Numero maxime de responsas a monstrar:',
	'lqt-preference-custom-signatures' => 'Monstrar signaturas personalisate de usatores',
	'lqt-enotif-subject-reply' => 'Discussion {{SITENAME}}  - Responsa: $1',
	'lqt-enotif-subject-newthread' => 'Discussion {{SITENAME}} - Nove filo: $1',
	'lqt-enotif-newthread' => "Salute $1,

Isto es un notification ab {{SITENAME}} signalante que un nove filo in $5, '$2',
esseva create le $3 a $4 per $8.

Tu pote vider lo a <$6>

Le texto es:
$7",
	'lqt-enotif-reply' => "Salute $1,

Isto es un notification ab {{SITENAME}} signalante que un nove responsa a '$2' in $5,
esseva create le $3 a $4 per $8.

Tu pote vider lo a <$6>

Le texto del responsa es:
$7",
	'lqt-quote-intro' => 'Le $2 a $3, [[User:$1|$1]] scribeva:',
	'lqt-quote' => 'Citar',
	'lqt-search-legend' => 'Cercar in discussiones in iste pagina',
	'lqt-search-label' => 'Terminos de recerca:',
	'lqt-search-button' => 'Cercar',
	'searchprofile-threads' => 'Discussiones',
	'searchprofile-threads-tooltip' => 'Cercar in discussiones in filo e paginas de discussion',
	'lqt-ajax-updated' => 'Iste filo ha nove messages.',
	'lqt-ajax-update-link' => 'Actualisar',
	'lqt-thread-show-replies' => 'Monstrar $1 responsas',
	'lqt-thread-show-more' => 'Monstrar plus responsas',
	'lqt-thread-link-url' => 'URL pro ligamine:',
	'lqt-thread-link-title' => 'Wikitexto pro ligamine:',
	'lqt-thread-link-copy' => 'Copiar al area de transferentia',
	'lqt-sign-not-necessary' => 'Non es necessari signar tu message con quatro tildes.
Le signatura es adjungite automaticamente.',
	'lqt-marked-as-read-placeholder' => 'Le filo $1 ha essite marcate como legite.',
	'lqt-change-subject' => 'Cambiar subjecto',
	'lqt-save-subject' => 'Salveguardar',
	'lqt-save-subject-failed' => 'Le sequente error occurreva durante le tentativa de cambiar le subjecto de iste filo: $1',
	'lqt-ajax-invalid-subject' => 'Le subjecto que tu specificava es invalide, probabilemente proque illo esseva troppo longe.',
	'lqt-ajax-no-subject' => 'Es necessari specificar un subjecto pro le nove filo de discussion.',
	'lqt-save-subject-error-unknown' => 'Un error incognite occurreva al tentativa de definir le subjecto de iste filo. Per favor tenta facer lo per cliccar "modificar" in le prime message.',
	'lqt-cancel-subject-edit' => 'Cancellar',
	'lqt-drag-activate' => 'Traher a altere loco',
	'lqt-drag-drop-zone' => 'Deponer hic',
	'lqt-drag-confirm' => 'Pro completar le sequente actiones, entra un motivo e clicca super "Confirmar".',
	'lqt-drag-reparent' => 'Displaciar le message sub un altere genitor.',
	'lqt-drag-split' => 'Displaciar le message a su proprie filo',
	'lqt-drag-setsortkey' => 'Adjustar le position del message in le pagina',
	'lqt-drag-bump' => 'Displaciar le message verso le alto del pagina',
	'lqt-drag-save' => 'Confirmar',
	'lqt-drag-title' => 'Confirmar displaciamento',
	'lqt-drag-reason' => 'Motivo:',
	'lqt-drag-subject' => 'Subjecto del nove filo (obligatori):',
	'lqt-edit-signature' => '(modificar signatura)',
	'lqt-preview-signature' => '(previsualisation)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nove messages',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nove messages de $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nove filos',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nove filos de $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Responsas',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Responsas de $1',
	'lqt-feed-new-thread-intro' => 'Nove filo in $1 publicate per $2',
	'lqt-feed-reply-intro' => 'Responsa a $3 (super $1) publicate per $2',
	'tooltip-pt-newmessages' => 'Monstra nove messages in filos o paginas de discussion arborescente que tu observa',
	'lqt-newmessages-n' => 'Nove messages ($1)',
	'lqt_newmessages' => 'Mi nove messages (nulle)',
	'lqt_newmessages-title' => 'Nove messages',
	'lqt-newpost-summary' => 'Nove filo: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Per favor entra tu texto pro iste filo, delente iste linea.',
	'lqt-reply-summary' => 'Responder a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historia del pagina de discussion',
	'lqt-talkpage-history-subtitle' => 'Pro $1',
	'lqt-talkpage-history-tab' => 'Titulo',
	'restriction-reply' => 'Publicar responsas',
	'restriction-newthread' => 'Publicar nove filos',
	'lqt-protected-reply-thread' => 'Tu non pote participar in iste filo proque illo ha essite protegite contra nove messages.',
	'lqt-protected-reply-talkpage' => 'Tu non pote participar in iste filo proque iste pagina de discussion ha essite protegite contra responsas a su filos.',
	'lqt-protected-newthread' => 'Tu non pote initiar nove filos in iste pagina de discussion proque illo ha essite protegite contra nove filos.',
	'lqt-edit-bump' => 'Reactivar iste filo',
	'lqt-edit-bump-tooltip' => 'Repositionar iste filo in alto del pagina de discussion',
	'lqt-historicalrevision-error' => 'Le version que tu ha seligite es defectuose e non pote esser visualisate.',
	'lqt-reply-subpage' => 'responsa',
	'nstab-thread' => 'Filo',
	'nstab-summary' => 'Summary',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Farras
 * @author Irwangatot
 * @author IvanLanin
 * @author Rex
 */
$messages['id'] = array(
	'lqt-desc' => 'Menambahkan diskusi bertopik pada halaman pembicaraan',
	'lqt_movethread' => 'Pindahkan topik pembicaraan ke halaman lain',
	'lqt_deletethread' => 'Hapus atau batalkan penghapusan topik pembicaraan',
	'lqt_contents_title' => 'Daftar isi',
	'lqt_toc_thread_title' => 'Judul topik',
	'lqt_toc_thread_author' => 'Diprakarsai oleh',
	'lqt_toc_thread_replycount' => 'Balasan',
	'lqt_toc_thread_modified' => 'Terakhir diubah',
	'lqt_add_header' => 'Tambahkan kepala halaman',
	'lqt_new_thread' => 'Mulai diskusi baru',
	'lqt_invalid_subject' => 'Subjek yang Anda masukkan tidak valid.
Mungkin:
* Terlalu panjang, atau
* Konflik dengan awalan interwiki atau nama ruang nama.',
	'lqt_empty_subject' => 'Anda harus memasukkan subjek.',
	'lqt_reply' => 'Balas',
	'lqt-parent' => 'Induk',
	'lqt_delete' => 'Hapus',
	'lqt_undelete' => 'Batalkan penghapusan',
	'lqt_permalink' => 'Pranala',
	'lqt_fragment' => 'Bagian $1 dari $2',
	'lqt_discussion_link' => 'diskusi',
	'lqt_from_talk' => 'Dari $1',
	'lqt-history-title' => 'Riwayat utas',
	'lqt_hist_comment_edited' => 'Teks komentar [$2 disunting]',
	'lqt_hist_summary_changed' => 'Ringkasan diubah',
	'lqt_hist_reply_created' => '[[$1|Balasan baru]]telah dibuat',
	'lqt_hist_thread_created' => 'Topik baru telah dibuat',
	'lqt_hist_deleted' => 'Dihapus',
	'lqt_hist_undeleted' => 'Batalkan penghapusan',
	'lqt_hist_moved_talkpage' => 'Dipindahkan',
	'lqt_hist_listing_subtitle' => 'Melihat daftar sejarah',
	'lqt_hist_view_whole_thread' => 'Lihat sejarah seluruh topik',
	'lqt_hist_no_revisions_error' => 'Topik ini tidak memiliki sejarah revisi.',
	'lqt_hist_past_last_page_error' => 'Anda telah melebihi angka sejarah halaman yang ada',
	'lqt_hist_tooltip_newer_disabled' => 'Pranala ini dimatikan karena Anda berada pada halaman pertama.',
	'lqt_hist_tooltip_older_disabled' => 'Pranala ini dimatikan karena Anda berada pada halaman terakhir.',
	'lqt_hist_split' => 'Balasan dipisah ke utas baru',
	'lqt_hist_edited_subject' => 'Mengganti subjek dari "$2" menjadi "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Subjek berubah',
	'lqt_hist_merged_from' => '[[$1|Balasan]] dipindah ke utas lain',
	'lqt_hist_merged_to' => '[[$1|Balasan]] dipindah dari utas lain',
	'lqt_hist_split_from' => 'Pisahkan ke utas baru',
	'lqt_hist_root_blanked' => 'Teks komentar yang dihapus',
	'lqt_hist_adjusted_sortkey' => 'Posisi utas tersesuaikan',
	'lqt_revision_as_of' => 'Revisi pada $2 di $3.',
	'lqt_change_new_thread' => 'Ini adalah revisi awal topik.',
	'lqt_change_reply_created' => '[$1 Komentar yang diberi warna] ditambahkan pada revisi ini',
	'lqt_change_edited_root' => '[$1 Komentar yang diberi warna] disunting pada revisi ini',
	'lqt_change_edited_summary' => 'Ringkasan utas telah disunting',
	'lqt_change_deleted' => '[$1 Utas ini] atau induknya telah dihapus',
	'lqt_change_undeleted' => '[$1 Tulisan yang disorot] telah dibatalkan penghapusannya',
	'lqt_change_moved' => '[$1 Utas ini] dipindahkan ke halaman pembicaraan lain',
	'lqt_change_split' => '[$1 Utas ini] dipisakan dari utas lain',
	'lqt_change_edited_subject' => 'Subjek utas ini telah diganti dari "$2" menjadi "$3"',
	'lqt_change_merged_from' => '[$1 Balasan] untuk utas ini dipindahkan ke utas lain',
	'lqt_change_merged_to' => '[$1 Balasan yang disorot] telah dipindahkan dari utas lain',
	'lqt_change_split_from' => '[$1 Subutas] dari utas ini telah dipisahkan ke utasnya sendiri',
	'lqt_change_root_blanked' => 'Teks [$1 suatu komentar] telah dihapus.',
	'lqt_youhavenewmessages' => 'Anda memiliki [[$1|pesan baru]].',
	'lqt_protectedfromreply' => 'Topik ini telah $1 dari mengirim balasan',
	'lqt_protectedfromreply_link' => 'dilindungi',
	'lqt_subject' => 'Perihal:',
	'lqt_noreason' => 'Tidak ada alasan yang diberikan.',
	'lqt_move_placeholder' => 'Utas ini adalah penanda bahwa suatu utas, $1, telah dipindahkan dari halaman ini.
Pemindahan ini dilakukan oleh $2 pada $3 pukul $4. Utas tersebut kini terdapat pada $5.',
	'lqt_thread_deleted_for_sysops' => "Topik ini telah '''dihapus''' dan hanya bisa dilihat oleh pengurus.",
	'lqt_thread_deleted' => 'Topik ini telah dihapus.',
	'lqt_summary_notice' => 'Tidak ada perubahan pada diskusi ini selama paling tidak $2 {{PLURAL:$2|hari|hari}}
Jika telah berakhir, Anda mungkin ingin untuk $1.',
	'lqt_summary_notice_link' => 'tulis ringkasan',
	'lqt_summary_label' => 'Ringkasan topik:',
	'lqt_summary_subtitle' => 'Ringkasan dari $1.',
	'lqt_nosuchrevision' => 'Tidak ada revisi seperti itu pada topik ini.',
	'lqt_nosuchthread' => 'Topik yang Anda cari tidak ada.',
	'lqt_nosuchthread_title' => 'Tidak ada topik seperti itu',
	'lqt_threadrequired' => 'Anda harus memasukkan sebuah nama topik di URL.',
	'lqt_move_movingthread' => 'Memindahkan $1.
Topik ini adalah bagian dari $2.',
	'lqt_move_torename' => "Untuk mengganti nama topik ini, $1 dan ganti nama 'Subyek'",
	'lqt_move_torename_edit' => 'sunting',
	'lqt_move_destinationtitle' => 'Judul untuk halaman pembicaraan tujuan:',
	'lqt_move_move' => 'Pindahkan',
	'lqt_move_nodestination' => 'Anda harus menentukan sebuah tujuan.',
	'lqt_move_thread_bad_destination' => 'Halaman tujuan bukan merupakan halaman diskusi.',
	'lqt_move_samedestination' => 'Topik ini sudah ada pada halaman ini!',
	'lqt_move_noreason' => 'Tidak ada alasan yang diberikan.',
	'lqt_move_success' => 'Topik dipindahkan ke $1.',
	'lqt_delete_undeletethread' => 'Batalkan penghapusan topik',
	'lqt_delete_partof' => "Topik ini adalah bagian dari '''$1'''.",
	'lqt_delete_deleting' => "Membatalkan penghapusan '''$1''' dan '''semua balasan''' yang ada.",
	'lqt_delete_deletethread' => 'Hapus topik dan semua balasan',
	'lqt_delete_deleted' => 'Topik ini telah dihapus.',
	'lqt_delete_undeleted' => 'Topik telah dibatalkan penghapusannya.',
	'lqt_delete_return' => 'Kembali ke $1.',
	'lqt_delete_return_link' => 'halaman pembicaraan',
	'lqt_delete_unallowed' => 'Anda tidak diizinkan untuk menghapus topik.',
	'lqt_delete_show_checkbox' => 'Tunjukkan topik yang dihapus',
	'lqt_talkpage_autocreate_summary' => 'Halaman pembicaraan dibuat secara otomatis ketika topik pertama dikirimkan.',
	'lqt_header_warning_big' => 'Anda menyunting sebuah $1.',
	'lqt_header_warning_after_big' => 'Kepala halaman adalah untuk pengumuman dan pembukaan.
Anda mungkin ingin $2.',
	'lqt_header_warning_bold' => 'kepala halaman pembicaraan',
	'lqt_header_warning_new_discussion' => 'mulai diskusi baru',
	'lqt_sorting_order' => 'Pengurutan:',
	'lqt_sort_newest_changes' => 'yang terakhir diubah terlebih dulu',
	'lqt_sort_newest_threads' => 'topik terbaru terlebih dulu',
	'lqt_sort_oldest_threads' => 'topik terlama terlebih dulu',
	'lqt-title' => 'Judul',
	'lqt-summary' => 'Ringkasan',
	'lqt-searching' => 'Mencari topik',
	'lqt-read-message' => 'Tandai sudah dibaca',
	'lqt-read-message-tooltip' => 'Singkirkan topik ini dari pesan-pesan baru.
Ini masih dapat dilihat pada halaman pembicaraan aslinya.',
	'lqt-read-all' => 'Tandai semua sudah dibaca',
	'lqt-read-all-tooltip' => 'Singkirkan semua topik dari pesan-pesan baru.
Ini masih dapat dilihat pada halaman pembicaraan aslinya.
Hal ini tidak dapat dibatalkan.',
	'lqt-marked-read' => "Topik '''$1''' ditandai sudah dibaca.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|pesan|pesan}} ditandai sudah dibaca.',
	'lqt-email-undo' => 'Batalkan',
	'lqt-no-new-messages' => 'Tidak ada pesan baru untuk Anda.',
	'lqt-new-messages' => '✒ Ada pesan baru untuk Anda.',
	'lqt-email-info-undo' => 'Kembalikan topik yang baru Anda singkirkan.',
	'lqt-date-info' => 'Pranala ini dimatikan karena Anda sedang melihat semua topik dari awal hingga sekarang.',
	'lqt-newmessages-context' => 'Topik lengkap',
	'lqt-thread-created' => 'Dibuat',
	'lqt-history-time' => 'Waktu',
	'lqt-history-user' => 'Pengguna',
	'lqt-history-action' => 'Aktivitas',
	'lqt-history-comment' => 'Komentar',
	'lqt-history-thread' => 'Utas',
	'lqt-thread-edited-author' => 'Disunting oleh penulis.<br />
Suntingan terakhir: $1',
	'lqt-thread-edited-others' => 'Disunting oleh {{PLURAL:$2|pengguna lain|$2 pengguna}}.<br />
Suntingan terakhir: $1',
	'lqt-header-actions' => 'Tindakan',
	'lqt_summarize_link' => 'Ringkasan',
	'lqt-summarize-intro' => 'Silakan meringkas utas di bawah ini pada kotak suntingan.
Anda dapat menggunakan semua teks wiki dalam ringkasan Anda. Setelah selesai, klik "{{int:savearticle}}".',
	'lqt-thread-split' => 'Pisahkan menjadi dua topik',
	'lqt-split-success' => 'Anda telah berhasil memisahkan topik $1.',
	'lqt_split_thread' => 'Pisahkan topik',
	'lqt-thread-split-subject' => 'Topik baru tentang:',
	'lqt-thread-split-thread' => 'Utas:',
	'lqt-split-submit' => 'Pisahkan',
	'lqt_split_badsubject' => 'Judul yang Anda masukkan tidak valid.',
	'lqt-no-threads' => 'Di halaman ini belum ada topik.',
	'lqt-delete-parent-warning' => 'Ini adalah suatu utas tingkat atas yang memiliki balasan.
Balasan-balasannya juga akan terhapus secara otomatis.
Untuk menghindarinya, pisahkan mereka dari utas ini sebelum menghapusnya.',
	'lqt-delete-parent-deleted' => 'Utas induk telah dihapus ($1)',
	'lqt-delete-replies-done' => 'Semua balasan terhadap utas ini juga telah dihapus.',
	'lqt-movethread' => 'Pindahkan',
	'lqt-menu-trigger' => 'Lainnya',
	'lqt-newmessages-from' => 'Dari $1',
	'lqt-hot-topics' => 'Topik hangat',
	'lqt-add-reply' => 'Tambahkan balasan',
	'lqt_rc_new_discussion' => 'mengirimkan topik baru, "$1"',
	'lqt_rc_new_reply' => 'mengirimkan balasan ke "$1"',
	'right-lqt-split' => 'Memisahkan utas',
	'right-lqt-merge' => 'Menggabungkan utas',
	'lqt-thread-merge' => 'Gabung ke utas lain',
	'lqt-thread-merge-to' => 'Gabungkan ke utas ini',
	'lqt_merge_thread' => 'Gabungkan utas',
	'lqt-thread-merge-source' => 'Utas sumber:',
	'lqt-thread-merge-dest' => 'Utas tujuan:',
	'lqt-merge-submit' => 'Gabungkan',
	'lqt-merge-success' => 'Anda telah menggabungkan utas $1 ke bawah $2 dengan sukses.',
	'lqt-log-name' => 'Log diskusi bertingkat',
	'lqt-log-header' => 'Log ini menjelaskan seluruh tindakan yang dilakukan pada topik diskusi.',
	'lqt-log-action-move' => 'memindahkan [[$1]] dari [[$2]] ke [[$3]].',
	'lqt-log-action-split' => 'memisahkan [[$1]] dari bawah [[$3]], dengan subyek baru "$2"',
	'lqt-log-action-merge-across' => 'memindahkan [[$1]] dari bawah [[$2]] ke bawah [[$3]]',
	'lqt-log-action-merge-down' => 'menggabungkan [[$1]] ke bawah [[$3]]',
	'lqt-log-action-subjectedit' => 'mengubah subyek [[$1]] dari "$2" ke "$3"',
	'lqt-log-action-resort' => 'mengubah aturan urutan [[$1]]. Mengganti kunci urut dari $2 ke $3',
	'lqt-preference-notify-talk' => 'Kirimkan saya surel jika ada balasan pada topik yang saya pantau',
	'lqt-preference-watch-threads' => 'Pantau utas yang saya buat atau balas',
	'prefs-lqt' => 'Diskusi berutas',
	'lqt-preference-display-depth' => 'Kedalaman balasan maksimum yang ditampilkan:',
	'lqt-preference-display-count' => 'Jumlah maksimum balasan yang ditampilkan:',
	'lqt-preference-custom-signatures' => 'Tampilkan tanda tangan buatan pengguna',
	'lqt-enotif-subject-reply' => 'Diskusi {{SITENAME}} - Balasan: $1',
	'lqt-enotif-subject-newthread' => 'Diskusi {{SITENAME}} - Topik baru: $1',
	'lqt-enotif-newthread' => "Hai $1,
Ini adalah pemberitahuan dari {{SITENAME}} bahwa suatu utas baru pada $5, '$2',
telah dibuat pada $3 pukul $4 oleh $8

Anda dapat melihatnya di <$6>

Isinya adalah:
$7",
	'lqt-enotif-reply' => "Hai $1,
Ini adalah pemberitahuan dari {{SITENAME}} bahwa balasan baru untuk '$2' di $5,
dibuat tanggal $3 pukul $4 oleh $8

Anda dapat melihatnya di <$6>

Teks balasan berisi:
$7",
	'lqt-quote-intro' => 'Pada $2 pukul $3, [[User:$1|$1]] menulis:',
	'lqt-quote' => 'Kutip',
	'lqt-search-legend' => 'Cari diskusi pada halaman ini',
	'lqt-search-label' => 'Kata kunci pencarian:',
	'lqt-search-button' => 'Cari',
	'searchprofile-threads' => 'Diskusi',
	'searchprofile-threads-tooltip' => 'Cari diskusi berutas dan halaman pembicaraan',
	'lqt-ajax-updated' => 'Utas ini memiliki kiriman baru.',
	'lqt-ajax-update-link' => 'Pemutahiran',
	'lqt-thread-show-replies' => 'Lihat $1 balasan',
	'lqt-thread-show-more' => 'Lihat balasan lain',
	'lqt-thread-link-url' => 'Pranala URL:',
	'lqt-thread-link-title' => 'Pranala tekswiki',
	'lqt-thread-link-copy' => 'Salin ke papan klip',
	'lqt-sign-not-necessary' => 'Tidak perlu menandatangani kiriman Anda dengan empat tilde.
Tanda tangan akan dimunculkan secara otomatis.',
	'lqt-marked-as-read-placeholder' => 'Utas $1 ditandai sudah dibaca',
	'lqt-change-subject' => 'Ganti judul',
	'lqt-save-subject' => 'Simpan',
	'lqt-save-subject-failed' => 'Kesalahan ini terjadi ketika mengganti judul pesan ini: $1',
	'lqt-ajax-invalid-subject' => 'Judul yang Anda tulis salah, mungkin karena terlalu panjang.',
	'lqt-ajax-no-subject' => 'Anda harus menuliskan judul.',
	'lqt-save-subject-error-unknown' => 'Kesalahan tak diketahui terjadi ketika menuliskan judul pesan ini. Coba lakukan lagi dengan mengklik "sunting" di bagian atas.',
	'lqt-cancel-subject-edit' => 'Batal',
	'lqt-drag-activate' => 'Seret ke lokasi baru',
	'lqt-drag-drop-zone' => 'Letakkan di sini',
	'lqt-drag-confirm' => 'Untuk menyelesaikan tindakan berikut ini, silakan mengisi alasan dan klik tombol konfirmasi.',
	'lqt-drag-reparent' => 'Pindahkan kiriman ke bawah induk baru',
	'lqt-drag-split' => 'Pindahkan kiriman ke utas sendiri',
	'lqt-drag-setsortkey' => 'Sesuaikan posisi kiriman pada halaman',
	'lqt-drag-bump' => 'Pindahkan kiriman ke atas halaman diskusi',
	'lqt-drag-save' => 'Konfirmasikan',
	'lqt-drag-title' => 'Konfirmasi pemindahan',
	'lqt-drag-reason' => 'Alasan:',
	'lqt-drag-subject' => 'Subjek utas baru:',
	'lqt-edit-signature' => '(sunting tanda tangan)',
	'lqt-preview-signature' => '(pratayang)',
	'lqt-feed-title-all' => '{{SITENAME}} — Kiriman baru',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Kiriman baru dari  $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Topik baru',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Topik baru dari $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Balasan',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Balasan dari $1',
	'lqt-feed-new-thread-intro' => 'Utas baru pada $1 dikirim oleh $2',
	'lqt-feed-reply-intro' => 'Balasan untuk $3 (pada $1) dikirim oleh $2',
	'tooltip-pt-newmessages' => 'Menunjukkan kiriman baru pada utas atau halaman pembicaraan berutas yang Anda pantau',
	'lqt-newmessages-n' => 'Pesan baru ($1)',
	'lqt_newmessages' => 'Pesan baru saya (Tidak ada)',
	'lqt_newmessages-title' => 'Pesan baru',
	'lqt-newpost-summary' => 'Utas baru: $1',
	'lqt-reply-summary' => 'Balas ke [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Riwayat halaman pembicaraan',
	'lqt-talkpage-history-subtitle' => 'Untuk $1',
	'lqt-talkpage-history-tab' => 'Kepala',
	'restriction-reply' => 'Kirim balasan',
	'restriction-newthread' => 'Kirim topik baru',
	'lqt-protected-reply-thread' => 'Anda tidak dapat mengirim di topik ini karena telah dilindungi dari pengiriman baru.',
	'lqt-protected-reply-talkpage' => 'Anda tidak dapat mengirim ke topik ini karena halaman diskusi ini telah dilindungi dari balasan ke dalam topik ini.',
	'lqt-protected-newthread' => 'Anda tidak dapat mengirim topik baru ke halaman diskuisi ini karena telah dilindungi dari topik baru.',
	'lqt-edit-bump' => 'Sundul utas ini',
	'lqt-edit-bump-tooltip' => 'Pindahkan utas ini ke atas halaman pembicaraannya',
	'lqt-historicalrevision-error' => 'Revisi yang Anda pilih korup dan tidak dapat dilihat.',
	'lqt-reply-subpage' => 'balas',
	'nstab-thread' => 'Utas',
	'nstab-summary' => 'Ringkasan',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'lqt_contents_title' => 'Ihe dị ime',
	'lqt_delete' => 'Gbakashia',
	'lqt_undelete' => 'Á gbàkashikwà',
	'lqt_permalink' => 'Jikodo na',
	'lqt_hist_deleted' => 'Gbakashịrị',
	'lqt_hist_undeleted' => 'Ọ gbákashikwà',
	'lqt_hist_moved_talkpage' => 'Páfụrụ',
	'lqt_youhavenewmessages' => 'I nwere [[$1|ozi ohúrù]].',
	'lqt_subject' => 'Gbàsịrị:',
	'lqt_move_torename_edit' => 'rüo ya',
	'lqt_move_move' => 'Páfụ',
	'lqt-read-message-tooltip' => 'Wéfu ahiri nka na ozi ohúrù.
Madu nwere I ki hü ya na ihü akíkó nke sinambu.',
	'lqt-history-user' => "Ọ'bànifé",
	'lqt-split-submit' => 'Wa',
	'lqt-movethread' => 'Páfụ',
	'lqt-menu-trigger' => 'Nà nké ozór',
	'lqt-quote' => 'Kȯpùtà',
	'lqt-search-button' => 'Chöwá',
	'searchprofile-threads' => 'Akíkó',
	'lqt-ajax-update-link' => 'Dịnwanye mmā',
	'lqt-thread-link-url' => 'Jikodo URL:',
	'lqt-save-subject' => 'Donyéré',
	'lqt-cancel-subject-edit' => 'Kàchá',
	'lqt-drag-drop-zone' => 'Dòsé nga',
	'lqt-drag-save' => 'Sị Í kwèrè',
	'lqt-drag-reason' => 'Mgbághapụtà:',
	'lqt-preview-signature' => '(lètú)',
	'lqt-newmessages-n' => 'Ozi ohúrù ($1)',
	'lqt_newmessages' => 'Ozi ohúrù',
	'lqt_newmessages-title' => 'Ozi ohúrù',
	'lqt-talkpage-history-subtitle' => 'Màkà $1',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'lqt_undelete' => 'Rekuperar',
	'lqt_from_talk' => 'De $1',
	'lqt_youhavenewmessages' => 'Vu havas [[$1|nova messaji]].',
	'lqt_move_move' => 'Movar',
	'lqt-title' => 'Titulo',
	'lqt-summary' => 'Rezumo',
	'lqt-email-undo' => 'Desfacar',
	'lqt-no-new-messages' => 'Ne existas nova messaji por vu.',
	'lqt-new-messages' => '✒ Existas nova mesaji por vu',
	'lqt-history-time' => 'Tempo',
	'lqt-history-user' => 'Uzanto',
	'lqt-history-comment' => 'Komento',
	'lqt-newmessages-from' => 'De $1',
	'lqt-save-subject' => 'Registragar',
	'lqt-drag-save' => 'Konfirmar',
	'lqt-drag-reason' => 'Motivo:',
	'lqt-newmessages-n' => 'Nova mesaji ($1)',
	'lqt_newmessages' => 'Nova mesaji',
	'lqt_newmessages-title' => 'Nova mesaji',
	'lqt-talkpage-history-subtitle' => 'Por $1',
);

/** Icelandic (Íslenska)
 * @author S.Örvarr.S
 * @author Spacebirdy
 * @author Ævar Arnfjörð Bjarmason
 */
$messages['is'] = array(
	'lqt_movethread' => 'Færði þráð á aðra síðu',
	'lqt_contents_title' => 'Efnisyfirlit',
	'lqt_toc_thread_title' => 'Þráður',
	'lqt_toc_thread_replycount' => 'Svör',
	'lqt_toc_thread_modified' => 'Síðast breytt',
	'lqt_add_header' => 'Bæta við haus',
	'lqt_new_thread' => 'Nýr þráður',
	'lqt_reply' => 'Svara',
	'lqt-parent' => 'Yfirþráður',
	'lqt_permalink' => 'Varanlegur&nbsp;tengill',
	'lqt_from_talk' => 'Af $1',
	'lqt-history-title' => 'Breytingarskrá þráðs',
	'lqt_hist_reply_created' => 'Bjó til [[$1|nýtt svar]]',
	'lqt_hist_thread_created' => 'Bjó til nýjan þráð',
	'lqt_hist_listing_subtitle' => 'Skoða breytingarsögu',
	'lqt_hist_view_whole_thread' => 'Sýna breytingarskrá fyrir þráðinn í heild sinni',
	'lqt_subject' => 'Titill:',
	'lqt_noreason' => 'Engin ástæða gefin.',
	'lqt_move_placeholder' => 'Þessi þráður er stubbur til að gefa til kynna að þráðurinn „$1“ var færður á „$5“. Færslan var framkvæmd $3 klukkan $4 af $2.',
	'lqt_summary_label' => 'Samantekt:',
	'lqt_move_movingthread' => 'Færi þráðinn „$1“ sem er núna á spjallborðinu „$2“.',
	'lqt_move_move' => 'Færa',
	'lqt_move_noreason' => 'Engin ástæða gefin.',
	'lqt_move_success' => 'Þráðurinn var færður á $1.',
	'lqt_header_warning_big' => 'Þú ert að breyta $1.',
	'lqt_header_warning_after_big' => 'Spjallsíðuhausar eru fyrir tilkynningar og kynningar. Kannski viltu frekar $2.',
	'lqt_header_warning_bold' => 'spjallsíðuhaus',
	'lqt_header_warning_new_discussion' => 'hefja nýja umræðu',
	'lqt_sorting_order' => 'Röðun:',
	'lqt_sort_newest_changes' => 'síðast breyttir fyrst',
	'lqt_sort_newest_threads' => 'nýjustu þræðir fyrst',
	'lqt_sort_oldest_threads' => 'elstu þræði fyrst',
	'lqt-summary' => 'Samantekt',
	'lqt-read-message' => 'Merkja sem lesin',
	'lqt-read-all' => 'Merkja allt sem lesið',
	'lqt-email-undo' => 'Taka aðgerðina aftur',
	'lqt-no-new-messages' => 'Það eru engin ný skilaboð til þín.',
	'lqt-newmessages-context' => 'Sjá allan þráðinn í samhengi',
	'lqt-history-time' => 'Dags',
	'lqt-history-user' => 'Notandi',
	'lqt-history-action' => 'Virkni',
	'lqt-history-comment' => 'Athugasemd',
	'lqt-history-thread' => 'Þráður',
	'lqt-thread-edited-author' => 'Breytt af höfundinum.<br />
Síðast breytt: $1',
	'lqt-thread-edited-others' => 'Breytt af {{PLURAL:$2|öðrum notanda|$2 notendum}}.<br />
Síðast breytt: $1',
	'lqt_summarize_link' => 'Skrifa samantekt',
	'lqt-summarize-intro' => 'Hérna getur þú skrifað samantekt á þræðinum hér fyrir neðan. Ýttu á „{{int:savearticle}}“ til að vista samantekina.',
	'lqt-no-threads' => 'Það eru engir þræðir á þessari síðu ennþá.',
	'lqt-movethread' => 'Færa',
	'lqt-menu-trigger' => 'Meira',
	'lqt-newmessages-from' => 'Á $1',
	'lqt_rc_new_discussion' => 'bjó til þráðinn „$1“',
	'lqt_rc_new_reply' => 'svaraði „$1“',
	'lqt-search-label' => 'Leitarorð:',
	'lqt-search-button' => 'Leita',
	'searchprofile-threads' => 'Spjöll',
	'lqt-thread-link-url' => 'Tengill:',
	'lqt-thread-link-title' => 'Wikitexti:',
	'lqt-thread-link-copy' => 'Afrita á klemmuspjald',
	'lqt-marked-as-read-placeholder' => 'Þráðurinn „$1“ var merktur sem lesinn.',
	'lqt-change-subject' => 'Breyta titli',
	'lqt-save-subject' => 'Vista',
	'lqt-cancel-subject-edit' => 'Hætta við',
	'lqt-drag-activate' => 'Færa innleggið',
	'lqt-drag-drop-zone' => 'Færðu innleggið hingað',
	'lqt-edit-signature' => '(breyta undirskrift)',
	'lqt-preview-signature' => '(forskoða)',
	'lqt-newmessages-n' => 'Ný skilaboð ($1)',
	'lqt_newmessages' => 'Ný skilaboð',
	'lqt_newmessages-title' => 'Ný skilaboð',
	'lqt-edit-bump' => 'Stjaka þessum þræði',
);

/** Italian (Italiano)
 * @author Aushulz
 * @author Beta16
 * @author Blaisorblade
 * @author Civvì
 * @author Darth Kule
 * @author F. Cosoleto
 * @author Gianfranco
 * @author Marco 27
 * @author Melos
 * @author PaoloRomano
 * @author Una giornata uggiosa '94
 * @author VittGam
 */
$messages['it'] = array(
	'lqt-desc' => 'Aggiunge discussioni in stile thread alle pagine di discussione',
	'lqt_movethread' => "Sposta discussione in un'altra pagina",
	'lqt_deletethread' => 'Cancellare o recuperare discussione',
	'lqt_contents_title' => 'Indice',
	'lqt_toc_thread_title' => 'Titolo thread',
	'lqt_toc_thread_author' => 'Iniziato da',
	'lqt_toc_thread_replycount' => 'Risposte',
	'lqt_toc_thread_modified' => 'Ultima modifica',
	'lqt_add_header' => 'Aggiungi intestazione',
	'lqt_new_thread' => 'Inizia una nuova discussione',
	'lqt_invalid_subject' => "L'oggetto inserito non è valido.
Potrebbe:
* Essere troppo lungo, oppure
* Essere in conflitto con prefissi interwiki o nomi di namespace.",
	'lqt_empty_subject' => 'È necessario inserire un oggetto.',
	'lqt_reply' => 'Rispondi',
	'lqt-parent' => 'Padre',
	'lqt_delete' => 'Cancella',
	'lqt_undelete' => 'Recupera',
	'lqt_permalink' => 'Link permanente',
	'lqt_fragment' => 'Frammento di una $1 da $2',
	'lqt_discussion_link' => 'discussione',
	'lqt_from_talk' => 'Da $1',
	'lqt-history-title' => 'Cronologia thread',
	'lqt_hist_comment_edited' => 'Commento [$2 modificato]',
	'lqt_hist_summary_changed' => 'Sommario cambiato',
	'lqt_hist_reply_created' => '[[$1|Nuova risposta]] creata',
	'lqt_hist_thread_created' => 'Nuovo thread creato',
	'lqt_hist_deleted' => 'Cancellato',
	'lqt_hist_undeleted' => 'Ripristinato',
	'lqt_hist_moved_talkpage' => 'Spostato',
	'lqt_hist_listing_subtitle' => 'Visualizzazione di un elenco della cronologia',
	'lqt_hist_view_whole_thread' => "Visualizza la cronologia dell'intero thread",
	'lqt_hist_no_revisions_error' => 'Questo thread non ha alcuna versione di cronologia.',
	'lqt_hist_past_last_page_error' => 'Hai superato il numero di pagine della cronologia.',
	'lqt_hist_tooltip_newer_disabled' => 'Questo collegamento è disattivato perché si è sulla prima pagina.',
	'lqt_hist_tooltip_older_disabled' => "Questo collegamento è disattivato perché si è sull'ultima pagina.",
	'lqt_hist_split' => 'Risposta suddivisa in un nuovo thread',
	'lqt_hist_edited_subject' => 'Oggetto modificato da "$2" in "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Oggetto cambiato',
	'lqt_hist_merged_from' => "[[$1|Risposta]] trasferita in un'altra discussione",
	'lqt_hist_merged_to' => "[[$1|Risposta]] trasferita da un'altra discussione",
	'lqt_hist_split_from' => 'Dividi in una nuova discussione',
	'lqt_hist_root_blanked' => 'Commento rimosso',
	'lqt_hist_adjusted_sortkey' => 'Rettificata la posizione del thread',
	'lqt_revision_as_of' => 'Versione del $2 alle $3.',
	'lqt_change_new_thread' => 'Questa è la versione iniziale della discussione.',
	'lqt_change_reply_created' => 'Il [$1 commento evidenziato] è stato aggiunto in questa revisione.',
	'lqt_change_edited_root' => 'Il [$1 commento evidenziato] è stato modificato in questa revisione.',
	'lqt_change_edited_summary' => "L'oggetto della discussione è stato modificato",
	'lqt_change_deleted' => '[$1 Questo thread] o il suo livello superiore è stato cancellato',
	'lqt_change_undeleted' => 'Il [$1 commento evidenziato] è stato recuperato',
	'lqt_change_moved' => "[$1 Questa discussione] è stata spostata ad un'altra pagina di discussione",
	'lqt_change_split' => "[$1 Questa discussione] è stata scorporata da un'altra.",
	'lqt_change_edited_subject' => 'L\'oggetto di questa discussione è stato cambiato da "$2" a "$3"',
	'lqt_change_merged_from' => "Una [$1 risposta] a questa discussione è stata trasferita ad un'altro thread",
	'lqt_change_merged_to' => "La [$1 risposta evidenziata] è stata trasferita qui da un'altra discussione.",
	'lqt_change_split_from' => 'Un [$1 sottothread] di questo thread è stato suddiviso in un thread dedicato',
	'lqt_change_root_blanked' => 'Il testo di [$1 un commento] è stato rimosso.',
	'lqt_youhavenewmessages' => 'Hai [[$1|nuovi messaggi]].',
	'lqt_protectedfromreply' => 'Questo thread è stato $1 dalle risposte',
	'lqt_protectedfromreply_link' => 'protetto',
	'lqt_subject' => 'Oggetto:',
	'lqt_noreason' => 'Nessuna motivazione indicata.',
	'lqt_move_placeholder' => 'Questo è un segnaposto che indica che un thread, $1, è stato spostato da questa pagina.
Lo spostamento è stato eseguito da $2 il $3 alle $4. Il thread si trova ora in $5.',
	'lqt_thread_deleted_for_sysops' => "Questa discussione è stata '''cancellata''' ed è visibile solamente dagli amministratori.",
	'lqt_thread_deleted' => 'Questa discussione è stata cancellata.',
	'lqt_summary_notice' => 'Non ci sono stati cambiamenti a questa discussione per almeno $2 {{PLURAL:$2|giorno|giorni}}.
Se è conclusa, $1.',
	'lqt_summary_notice_link' => 'scrivi un riassunto',
	'lqt_summary_label' => 'Riassunto della discussione:',
	'lqt_summary_subtitle' => 'Oggetto di "$1"',
	'lqt_nosuchrevision' => 'La versione di questo thread non esiste.',
	'lqt_nosuchthread' => 'La discussione specificata non esiste.',
	'lqt_nosuchthread_title' => 'Il thread non esiste',
	'lqt_threadrequired' => "È necessario specificare una discussione nell'URL.",
	'lqt_move_movingthread' => 'Spostamento di $1. Questo thread fa parte di $2.',
	'lqt_move_torename' => "Per rinominare questa discussione, $1 e cambia il campo 'Oggetto'.",
	'lqt_move_torename_edit' => 'modificala',
	'lqt_move_destinationtitle' => 'Titolo della pagina di discussione di destinazione:',
	'lqt_move_move' => 'Sposta',
	'lqt_move_nodestination' => 'È necessario specificare una destinazione.',
	'lqt_move_thread_bad_destination' => 'La pagina di destinazione non è una pagina di discussione.',
	'lqt_move_samedestination' => 'La discussione è già in questa pagina!',
	'lqt_move_noreason' => 'Nessuna motivazione indicata.',
	'lqt_move_success' => 'Il thread è stato spostato a $1.',
	'lqt_delete_undeletethread' => 'Ripristina discussione',
	'lqt_delete_partof' => "Questa discussione è una parte di '''$1'''.",
	'lqt_delete_deleting' => "Eliminazione di '''$1''' e '''tutte le risposte''' ad esso",
	'lqt_delete_deletethread' => 'Cancella la discussione e le risposte',
	'lqt_delete_deleted' => 'La discussione è stata cancellata.',
	'lqt_delete_undeleted' => 'La discussione è stata ripristinata.',
	'lqt_delete_return' => 'Ritorna a $1.',
	'lqt_delete_return_link' => 'la pagina di discussione',
	'lqt_delete_unallowed' => 'Non sei autorizzato a cancellare argomenti.',
	'lqt_delete_show_checkbox' => 'Mostra le discussioni cancellate',
	'lqt_talkpage_autocreate_summary' => "Pagina di discussione creata automaticamente all'inserimento del primo thread",
	'lqt_header_warning_big' => 'Si sta modificando una $1.',
	'lqt_header_warning_after_big' => 'Le intestazioni sono per annunci e introduzioni.
Potresti invece voler $2.',
	'lqt_header_warning_bold' => 'intestazione della pagina di discussione',
	'lqt_header_warning_new_discussion' => 'iniziare una nuova discussione',
	'lqt_sorting_order' => 'Criterio di ordinamento:',
	'lqt_sort_newest_changes' => 'ultime modificate per prime',
	'lqt_sort_newest_threads' => 'discussioni più recenti per prime',
	'lqt_sort_oldest_threads' => 'discussioni meno recenti per prime',
	'lqt-title' => 'Titolo',
	'lqt-summary' => 'Oggetto',
	'lqt-searching' => 'Ricerca di thread',
	'lqt-read-message' => 'Segna come letta',
	'lqt-read-message-tooltip' => 'Rimuovi questa discussione dai nuovi messaggi.
Sarà ancora visibile nella sua pagina di discussione originale.',
	'lqt-read-all' => 'Segna tutti come letti',
	'lqt-read-all-tooltip' => 'Rimuovi tutte le discussioni dai nuovi messaggi.
Saranno ancora visibili nelle loro originali pagine di discussione.
Questa operazione non è annullabile.',
	'lqt-marked-read' => "Discussione '''$1''' contrassegnata come letta.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|messaggio è stato segnato come letto|messaggi sono stati segnati come letti}}.',
	'lqt-email-undo' => 'Annulla',
	'lqt-no-new-messages' => 'Non ci sono nuovi messaggi per te.',
	'lqt-new-messages' => '✒ Ci sono nuovi messaggi per te.',
	'lqt-email-info-undo' => 'Riapri il thread che hai appena chiuso.',
	'lqt-date-info' => 'Questo link è disabilitato perché stai vedendo i thread di tutte le date.',
	'lqt-newmessages-context' => 'Thread intero',
	'lqt-thread-created' => 'Creato',
	'lqt-history-time' => 'Data e ora',
	'lqt-history-user' => 'Utente',
	'lqt-history-action' => 'Attività',
	'lqt-history-comment' => 'Commento',
	'lqt-history-thread' => 'Thread',
	'lqt-thread-edited-author' => "Modificato dall'autore.<br />
Ultima modifica: $1",
	'lqt-thread-edited-others' => 'Modificato da {{PLURAL:$2|un altro utente|$2 altri utenti}}.<br />
Ultima modifica: $1',
	'lqt-header-actions' => 'Azioni',
	'lqt_summarize_link' => 'Riassumi',
	'lqt-summarize-intro' => 'Si prega di riassumere il thread nella casella di edizione. Può essere usato qualsiasi wikitesto. Terminata l\'operazione, fare clic su "{{int:savearticle}}".',
	'lqt-thread-split' => 'Suddiviso in un nuovo thread',
	'lqt-split-success' => 'Hai diviso con successo la discussione $1.',
	'lqt_split_thread' => 'Dividi un thread',
	'lqt-thread-split-subject' => 'Oggetto della nuova discussione:',
	'lqt-thread-split-thread' => 'Thread:',
	'lqt-split-submit' => 'Dividi',
	'lqt_split_badsubject' => "L'oggetto inserito non è valido.",
	'lqt-no-threads' => 'Non ci sono ancora discussioni in questa pagina.',
	'lqt-delete-parent-warning' => 'Questo è un thread padre in cui sono presenti delle risposte.
Le sue risposte verranno cancellate automaticamente.
Per evitarlo, dividi le risposte dal thread prima di cancellarlo.',
	'lqt-delete-parent-deleted' => 'Thread padre cancellato ($1)',
	'lqt-delete-replies-done' => 'Tutte le risposte a questo thread sono state cancellate.',
	'lqt-movethread' => 'Sposta',
	'lqt-menu-trigger' => 'Altro',
	'lqt-newmessages-from' => 'Da $1',
	'lqt-hot-topics' => 'Discussioni calde',
	'lqt-add-reply' => 'Aggiungi una risposta',
	'lqt_rc_new_discussion' => 'ha iniziato una nuova discussione, "$1"',
	'lqt_rc_new_reply' => 'ha inviato una risposta a "$1"',
	'right-lqt-split' => 'Divide discussioni',
	'right-lqt-merge' => 'Unisce discussioni',
	'lqt-thread-merge' => "Unisci ad un'altra discussione",
	'lqt-thread-merge-to' => 'Unisci a questa discussione',
	'lqt_merge_thread' => 'Unisci discussione',
	'lqt-thread-merge-source' => 'Discussione originaria:',
	'lqt-thread-merge-dest' => 'Discussione di destinazione:',
	'lqt-merge-submit' => 'Unisci',
	'lqt-merge-success' => 'Hai unito con successo la discussione $1 sotto $2.',
	'lqt-log-name' => 'Log delle discussioni in stile thread',
	'lqt-log-header' => 'Questo registro contiene i dettagli delle azioni eseguite sulle discussioni.',
	'lqt-log-action-move' => 'ha spostato [[$1]] da [[$2]] a [[$3]].',
	'lqt-log-action-split' => 'dividi [[$1]] da sotto [[$3]], con il nuovo oggetto "$2"',
	'lqt-log-action-merge-across' => 'spostato [[$1]] da [[$2]] a [[$3]]',
	'lqt-log-action-merge-down' => 'unito [[$1]] a [[$3]]',
	'lqt-log-action-subjectedit' => 'modificato l\'oggetto di [[$1]] da "$2" a "$3"',
	'lqt-log-action-resort' => "modificato l'ordinamento di [[$1]]. Cambiato criterio di ordinamento da $2 a $3",
	'lqt-preference-notify-talk' => 'Segnalami via e-mail le risposte a un thread che sto seguendo',
	'lqt-preference-watch-threads' => 'Guarda le discussioni che ho creato o a cui ho risposto',
	'prefs-lqt' => 'Discussioni in stile thread',
	'lqt-preference-display-depth' => 'Profondità massima delle risposte da mostrare:',
	'lqt-preference-display-count' => 'Numero massimo di risposte da mostrare:',
	'lqt-preference-custom-signatures' => 'Mostra le firme personalizzate degli utenti',
	'lqt-enotif-subject-reply' => 'Discussione su {{SITENAME}} - Risposta: $1',
	'lqt-enotif-subject-newthread' => 'Discussione su {{SITENAME}} - Nuovo thread: $1',
	'lqt-enotif-newthread' => "Ciao $1,
questo messaggio ti è stato inviato da {{SITENAME}} per segnalarti che un nuovo thread su $5, '$2',
è stato creato il $3 alle $4 da $8.

Puoi leggerlo a <$6>

Il testo è:
$7",
	'lqt-enotif-reply' => "Ciao $1,
questo messaggio ti è stato inviato da {{SITENAME}} per segnalarti che una nuova risposta a '$2' su $5
è stata creato il $3 alle $4 da $8.

Puoi leggerlo a <$6>

Il testo è:
$7",
	'lqt-quote-intro' => 'Il $2 alle $3, [[User:$1|$1]] ha scritto:',
	'lqt-quote' => 'Cita',
	'lqt-search-legend' => 'Cerca discussioni in questa pagina',
	'lqt-search-label' => 'Termini di ricerca:',
	'lqt-search-button' => 'Ricerca',
	'searchprofile-threads' => 'Discussioni',
	'searchprofile-threads-tooltip' => 'Cerca nelle discussioni in stile thread e nelle pagine di discussione',
	'lqt-ajax-updated' => 'Questa discussione ha nuovi messaggi.',
	'lqt-ajax-update-link' => 'Aggiorna',
	'lqt-thread-show-replies' => 'Mostra $1 {{PLURAL:$1|risposta|risposte}}',
	'lqt-thread-show-more' => 'Mostra più risposte',
	'lqt-thread-link-url' => 'Indirizzo del thread:',
	'lqt-thread-link-title' => 'Wikilink del thread:',
	'lqt-thread-link-copy' => 'Copia negli appunti',
	'lqt-sign-not-necessary' => 'Non è necessario firmare il vostro messaggio con quattro tilde.
La firma è mostrata automaticamente.',
	'lqt-marked-as-read-placeholder' => 'Il thread $1 è stato contrassegnato come già letto.',
	'lqt-change-subject' => "Cambia l'oggetto",
	'lqt-save-subject' => 'Salva',
	'lqt-save-subject-failed' => "Nella modifica dell'oggetto del presente thread si è verificato il seguente errore: $1",
	'lqt-ajax-invalid-subject' => "L'oggetto specificato non è valido, probabilmente perché era troppo lungo.",
	'lqt-ajax-no-subject' => 'È necessario specificare un oggetto.',
	'lqt-save-subject-error-unknown' => "In seguito al tentativo di impostare l'oggetto di questo thread si è verificato un errore sconosciuto. Provare a ripetere l'operazione attivando l'opzione \"modifica\" sul post superiore",
	'lqt-cancel-subject-edit' => 'Annulla',
	'lqt-drag-activate' => 'Trascina in una nuova posizione',
	'lqt-drag-drop-zone' => 'Rilascia qui',
	'lqt-drag-confirm' => 'Per completare le seguenti azioni si prega di inserire un motivo e fare clic su "Conferma".',
	'lqt-drag-reparent' => 'Muovi il post sotto un nuovo padre.',
	'lqt-drag-split' => 'Muovi il messaggio in un thread dedicato',
	'lqt-drag-setsortkey' => 'Sistema la posizione del messaggio nella pagina',
	'lqt-drag-bump' => 'Sposta il messaggio in cima alla pagina di discussione',
	'lqt-drag-save' => 'Conferma',
	'lqt-drag-reason' => 'Motivo:',
	'lqt-drag-subject' => 'Oggetto per la nuova discussione:',
	'lqt-edit-signature' => '(modifica firma)',
	'lqt-preview-signature' => '(anteprima)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nuovi messaggi',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nuovi messaggi da $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nuove discussioni',
	'lqt-feed-title-new-threads-from' => '((SITENAME)) - Nuovi thread da $ 1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Risposte',
	'lqt-feed-title-replies-from' => '((SITENAME)) - Risposte da $ 1',
	'lqt-feed-new-thread-intro' => 'Nuovo thread su $1 inserito da $2',
	'lqt-feed-reply-intro' => 'Risposta a $3 (su $1) inserita da $2',
	'lqt-newmessages-n' => 'nuovi messaggi ($1)',
	'lqt_newmessages' => 'nuovi messaggi (nessuno)',
	'lqt_newmessages-title' => 'Nuovi messaggi',
	'lqt-newpost-summary' => 'Nuova discussione: $1',
	'lqt-reply-summary' => 'Risposta a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Cronologia della pagina di discussione',
	'lqt-talkpage-history-subtitle' => 'Per $1',
	'lqt-talkpage-history-tab' => 'Introduzione',
	'restriction-reply' => 'Invia risposte',
	'restriction-newthread' => 'Invia nuove discussioni',
	'lqt-protected-reply-thread' => 'Non puoi scrivere in questo thread perché è stato protetto dai nuovi inserimenti',
	'lqt-protected-reply-talkpage' => 'Non puoi scrivere in questo thread perché questa pagina di discussione è stata protetta dalle risposte ai thread',
	'lqt-protected-newthread' => 'Non puoi inserire nuovi messaggi in questa pagina di discussione perché è stata protetta dai nuovi inserimenti',
	'lqt-edit-bump' => 'Evidenzia questo thread',
	'lqt-edit-bump-tooltip' => 'Sposta questo thread in cima alla sua pagina di discussione',
	'lqt-historicalrevision-error' => 'La revisione che hai selezionato è corrotta, e non può essere visualizzata.',
	'lqt-reply-subpage' => 'rispondi',
	'nstab-thread' => 'Thread',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Hosiryuhosi
 * @author JtFuruhata
 * @author Ohgi
 * @author Whym
 * @author 青子守歌
 */
$messages['ja'] = array(
	'lqt-desc' => 'トークページにスレッド形式の議論を追加する',
	'lqt_movethread' => 'スレッドを別のページに移動',
	'lqt_deletethread' => 'スレッドの削除と復帰',
	'lqt_contents_title' => '目次',
	'lqt_toc_thread_title' => 'スレッド表題',
	'lqt_toc_thread_author' => '開始者',
	'lqt_toc_thread_replycount' => '返信',
	'lqt_toc_thread_modified' => '最終更新',
	'lqt_add_header' => 'ヘッダの追加',
	'lqt_new_thread' => '新しい議論を始める',
	'lqt_invalid_subject' => 'あなたが入力した表題は不正です。以下の可能性があります。
* 長すぎる
* インターウィキ用接頭辞や名前空間名と衝突している',
	'lqt_empty_subject' => '表題を入力する必要があります。',
	'lqt_reply' => '返答',
	'lqt-parent' => '上位メッセージ',
	'lqt_delete' => '削除',
	'lqt_undelete' => '復帰',
	'lqt_permalink' => 'この発言へのリンク',
	'lqt_fragment' => '$2における$1の一部',
	'lqt_discussion_link' => '議論',
	'lqt_from_talk' => '$1 より',
	'lqt-history-title' => 'スレッド履歴',
	'lqt_hist_comment_edited' => 'コメントの[$2 編集]',
	'lqt_hist_summary_changed' => '要約の変更',
	'lqt_hist_reply_created' => '[[$1|返答]]の新規作成',
	'lqt_hist_thread_created' => 'スレッドの新規作成',
	'lqt_hist_deleted' => '削除',
	'lqt_hist_undeleted' => '復帰',
	'lqt_hist_moved_talkpage' => '移動',
	'lqt_hist_listing_subtitle' => '履歴一覧を表示中',
	'lqt_hist_view_whole_thread' => 'このスレッド全体の履歴を見る',
	'lqt_hist_no_revisions_error' => 'このスレッドには変更履歴がありません。',
	'lqt_hist_past_last_page_error' => '存在する履歴ページ番号を超えた指定が行われました。',
	'lqt_hist_tooltip_newer_disabled' => '最初のページにつき、このリンクは動作しません。',
	'lqt_hist_tooltip_older_disabled' => '最後のページにつき、このリンクは動作しません。',
	'lqt_hist_split' => '新しいスレッドに分割された返信',
	'lqt_hist_edited_subject' => '表題の「$2」から「$3」への変更',
	'lqt_hist_edited_subject_corrupt' => '話題が変更されています',
	'lqt_hist_merged_from' => '[[$1|返信]]の別のスレッドへの移動',
	'lqt_hist_merged_to' => '[[$1|返信]]の別のスレッドからの移動',
	'lqt_hist_split_from' => '新しいスレッドに分割',
	'lqt_hist_root_blanked' => 'コメント文の削除',
	'lqt_hist_adjusted_sortkey' => '修正されたスレッド位置',
	'lqt_revision_as_of' => '$2 $3 時点の版',
	'lqt_change_new_thread' => 'このスレッドの最初の版です。',
	'lqt_change_reply_created' => '[$1 ハイライトされているコメント]がこの版で作成されました。',
	'lqt_change_edited_root' => '[$1 ハイライトされているコメント]がこの版で変更されました。',
	'lqt_change_edited_summary' => 'スレッドの要約が編集されました',
	'lqt_change_deleted' => '[$1 このスレッド]またはその親が削除されました',
	'lqt_change_undeleted' => '[$1 ハイライトされている投稿]が復帰されました',
	'lqt_change_moved' => '[$1 このスレッド]が別の議論ページに移動されました',
	'lqt_change_split' => '[$1 このスレッド]が別のスレッドから分割されました',
	'lqt_change_edited_subject' => 'このスレッドの表題が「$2」から「$3」へと変更されました',
	'lqt_change_merged_from' => 'このスレッドへの[$1 返信]が別のスレッドに移動されました',
	'lqt_change_merged_to' => '[$1 ハイライトされている返信]が別のスレッドから移動されました',
	'lqt_change_split_from' => 'このスレッドの[$1 下位スレッド]が独立したスレッドへと分割されました',
	'lqt_change_root_blanked' => '[$1 コメント]の文章が削除されました。',
	'lqt_youhavenewmessages' => '[[$1|新しいメッセージ]]があります。',
	'lqt_protectedfromreply' => 'このスレッドは$1されているため返答できません。',
	'lqt_protectedfromreply_link' => '保護',
	'lqt_subject' => '表題:',
	'lqt_noreason' => '理由は付記されていません。',
	'lqt_move_placeholder' => 'スレッド「$1」は、ここから、$5へ移動されました。
この移動は$3$4に、$2によって行われました。',
	'lqt_thread_deleted_for_sysops' => "このスレッドは'''削除'''されており、{{int:group-sysop}}だけが内容を見ることができます。",
	'lqt_thread_deleted' => 'このスレッドは削除されました。',
	'lqt_summary_notice' => 'この議論は少なくとも$2{{PLURAL:$2|日間}}進展がありません。議論が終結しているなら、$1のも良いでしょう。',
	'lqt_summary_notice_link' => '要約を記述する',
	'lqt_summary_label' => 'スレッドの要約:',
	'lqt_summary_subtitle' => '「$1」の要約',
	'lqt_nosuchrevision' => '指定された版はこのスレッドに存在しません。',
	'lqt_nosuchthread' => '指定されたスレッドは存在しません。',
	'lqt_nosuchthread_title' => '指定スレッドなし',
	'lqt_threadrequired' => 'このURLにはスレッド名を記述する必要があります。',
	'lqt_move_movingthread' => '$1 を移動します。これは $2 にあるスレッドの一部です。',
	'lqt_move_torename' => 'スレッド名を変更する場合、表題欄を$1。',
	'lqt_move_torename_edit' => '編集してください',
	'lqt_move_destinationtitle' => '移動先{{int:talk}}ページ名',
	'lqt_move_move' => '移動',
	'lqt_move_nodestination' => '移動先を指定してください。',
	'lqt_move_thread_bad_destination' => '移動先が議論ページではありません。',
	'lqt_move_samedestination' => 'そのスレッドは既にこのページ上にあります！',
	'lqt_move_noreason' => '理由が付記されていません。',
	'lqt_move_success' => 'このスレッドは $1 に移動しました。',
	'lqt_delete_undeletethread' => 'スレッドの復帰',
	'lqt_delete_partof' => "これは '''$1''' にあるスレッドの一部です。",
	'lqt_delete_deleting' => "'''$1''' および、それに対する'''すべての返信'''を削除します。",
	'lqt_delete_deletethread' => 'スレッドと返答の削除',
	'lqt_delete_deleted' => 'スレッドが削除されました。',
	'lqt_delete_undeleted' => 'スレッドが復帰しました。',
	'lqt_delete_return' => '$1に戻る。',
	'lqt_delete_return_link' => '{{int:talk}}ページ',
	'lqt_delete_unallowed' => 'あなたはスレッドの削除処理を許可されていません。',
	'lqt_delete_show_checkbox' => '削除されたスレッドを表示',
	'lqt_talkpage_autocreate_summary' => '最初のスレッドが始まる際、{{int:talk}}ページは自動的に作成されます。',
	'lqt_header_warning_big' => 'あなたは$1を編集しようとしています。',
	'lqt_header_warning_after_big' => '見出しは、告知や序文のためにあります。代わりに$2べきでしょう。',
	'lqt_header_warning_bold' => '議論ページの見出し',
	'lqt_header_warning_new_discussion' => '新しい議論を始める',
	'lqt_sorting_order' => '並び替え順:',
	'lqt_sort_newest_changes' => '最終更新を上に',
	'lqt_sort_newest_threads' => '新しいスレッドを上に',
	'lqt_sort_oldest_threads' => '古いスレッドを上に',
	'lqt-title' => 'タイトル',
	'lqt-summary' => '要約',
	'lqt-searching' => 'スレッドの検索',
	'lqt-read-message' => '既読とする',
	'lqt-read-message-tooltip' => 'このスレッドを新しいメッセージから除きます。元のトークページでは表示され続けます。',
	'lqt-read-all' => 'すべてを既読とする',
	'lqt-read-all-tooltip' => 'すべてのスレッドを新しいメッセージから除きます。元のトークページでは表示され続けます。この操作は取り消しができます。',
	'lqt-marked-read' => "スレッド '''$1''' を既読としました。",
	'lqt-count-marked-read' => '$1件の{{PLURAL:$1|メッセージ}}を既読としました。',
	'lqt-email-undo' => '取り消し',
	'lqt-no-new-messages' => 'あなたへの新しいメッセージはありません。',
	'lqt-new-messages' => '✒ あなたへの新しいメッセージがあります。',
	'lqt-email-info-undo' => 'あなたが片付けたばかりのスレッドを復元する。',
	'lqt-date-info' => 'すべての日付のスレッドを閲覧しているため、このリンクは無効になっています。',
	'lqt-newmessages-context' => 'スレッド全体',
	'lqt-thread-created' => '作成',
	'lqt-history-time' => '時刻',
	'lqt-history-user' => '利用者',
	'lqt-history-action' => '活動',
	'lqt-history-comment' => 'コメント',
	'lqt-history-thread' => 'スレッド',
	'lqt-thread-edited-author' => '著者による編集。<br />
最後の編集: $1',
	'lqt-thread-edited-others' => '{{PLURAL:$2|他の利用者|$2 利用者}}による編集。<br />
最後の編集: $1',
	'lqt-header-actions' => '操作',
	'lqt_summarize_link' => '要約',
	'lqt-summarize-intro' => '以下のスレッドを編集ボックス内に要約してください。要約中ではウィキテキストが使用できます。完了したら「{{int:savearticle}}」をクリックします。',
	'lqt-thread-split' => '新しいスレッドに分割する',
	'lqt-split-success' => 'スレッド「$1」の分割に成功しました。',
	'lqt_split_thread' => 'スレッドを分割',
	'lqt-thread-split-subject' => '新しいスレッドの表題:',
	'lqt-thread-split-thread' => 'スレッド:',
	'lqt-split-submit' => '分割',
	'lqt_split_badsubject' => 'あなたが入力した表題は不正です。',
	'lqt-no-threads' => 'このページにはまだスレッドがありません。',
	'lqt-delete-parent-warning' => 'これは返信がある最上位のスレッドです。その返信もまた自動的に削除されます。これを避けるには、削除する前にそれらをこのスレッドから分割してください。',
	'lqt-delete-parent-deleted' => '親スレッド削除済み ($1)',
	'lqt-delete-replies-done' => 'このスレッドへの返信もすべて削除されました。',
	'lqt-movethread' => '移動',
	'lqt-menu-trigger' => 'その他',
	'lqt-newmessages-from' => '$1 より',
	'lqt-hot-topics' => 'ホットな話題',
	'lqt-add-reply' => '返信',
	'lqt_rc_new_discussion' => '新しいスレッドが投稿されました。"$1"',
	'lqt_rc_new_reply' => '"$1"への返信を投稿',
	'right-lqt-split' => 'スレッドを分割する',
	'right-lqt-merge' => 'スレッドを統合する',
	'lqt-thread-merge' => '別のスレッドに統合する',
	'lqt-thread-merge-to' => 'このスレッドに統合する',
	'lqt_merge_thread' => 'スレッドの統合',
	'lqt-thread-merge-source' => '統合元スレッド:',
	'lqt-thread-merge-dest' => '統合先スレッド:',
	'lqt-merge-submit' => '統合',
	'lqt-merge-success' => 'スレッド「$1」の「$2」の下への統合に成功しました。',
	'lqt-log-name' => 'スレッド形式議論の記録',
	'lqt-log-header' => 'これは議論スレッドで行われた操作の詳細を記録しています。',
	'lqt-log-action-move' => '[[$1]]を[[$2]]から[[$3]]へ移動しました。',
	'lqt-log-action-split' => '[[$1]]を[[$3]]から分割し、新しい題目 "$2" をつける',
	'lqt-log-action-merge-across' => '[[$1]]を[[$2]]から[[$3]]へ移動',
	'lqt-log-action-merge-down' => '[[$1]]を[[$3]]の下に統合',
	'lqt-log-action-subjectedit' => '[[$1]]の題目を"$2"から"$3"へ変更',
	'lqt-log-action-resort' => '[[$1]]の並び順を変更。ソートキーを$2から$3へ変更',
	'lqt-preference-notify-talk' => '監視しているスレッドへ返答があった時にメールで知らせる',
	'lqt-preference-watch-threads' => '自分が作成または返答したスレッドの変更を追跡する',
	'prefs-lqt' => 'スレッド型議論',
	'lqt-preference-display-depth' => '表示する最大の返信の深さ:',
	'lqt-preference-display-count' => '表示する返信の最大数:',
	'lqt-preference-custom-signatures' => 'カスタムの利用者署名を表示する',
	'lqt-enotif-subject-reply' => '{{SITENAME}} の討論 - 返信: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} の討論 - 新スレッド: $1',
	'lqt-enotif-newthread' => 'こんにちは、$1 さん。
これは {{SITENAME}} からの、$5 でスレッド「$2」が
$8 によって $3 $4 に作成されたことのお知らせです。

<$6> で確認できます。

内容は、次のとおりです:
$7',
	'lqt-enotif-reply' => 'こんにちは、$1 さん。

これは {{SITENAME}} の $5 でスレッド「$2」への新しい返信が、
$8 によって $3 $4 にあったことのお知らせです。

<$6> で確認できます。

返信内容は次のとおりです：
$7',
	'lqt-quote-intro' => '$2 $3に[[User:$1|$1]]が書きました:',
	'lqt-quote' => '引用',
	'lqt-search-legend' => 'このページ上の議論を検索する',
	'lqt-search-label' => '検索語句:',
	'lqt-search-button' => '検索',
	'searchprofile-threads' => '議論',
	'searchprofile-threads-tooltip' => 'スレッド型議論とトークページを検索',
	'lqt-ajax-updated' => 'このスレッドには新しい投稿があります。',
	'lqt-ajax-update-link' => '更新',
	'lqt-thread-show-replies' => '$1個の返信を表示',
	'lqt-thread-show-more' => 'より多くの返信を表示',
	'lqt-thread-link-url' => 'リンクの URL:',
	'lqt-thread-link-title' => 'ウィキテキストのリンク:',
	'lqt-thread-link-copy' => 'クリップボードへコピー',
	'lqt-sign-not-necessary' => '投稿に4つのチルダを付けて署名する必要はありません。署名は自動的に表示されます。',
	'lqt-marked-as-read-placeholder' => 'スレッド $1 は既読とされました。',
	'lqt-change-subject' => '表題の変更',
	'lqt-save-subject' => '保存',
	'lqt-save-subject-failed' => 'このスレッドの表題を変更しようとした際に次のエラーが発生しました: $1',
	'lqt-ajax-invalid-subject' => '指定された表題は無効です。おそらく長すぎるのが理由です。',
	'lqt-ajax-no-subject' => '表題を指定してください。',
	'lqt-save-subject-error-unknown' => 'このスレッドの表題を設定しようとした際に原因不明のエラーが発生しました。スレッドの先頭にある投稿の「編集」をクリックして表題の変更を行ってください。',
	'lqt-cancel-subject-edit' => '中止',
	'lqt-drag-activate' => '新しい位置にドラッグしてください',
	'lqt-drag-drop-zone' => 'ここにドロップ',
	'lqt-drag-confirm' => '以下の操作を完了するには、理由を記入し「確定」をクリックしてください。',
	'lqt-drag-reparent' => '投稿を新しい親の下に移動',
	'lqt-drag-split' => '投稿を独立したスレッドに移動',
	'lqt-drag-setsortkey' => '投稿のページ上の位置を修正',
	'lqt-drag-bump' => '投稿を議論ページの先頭に移動',
	'lqt-drag-save' => '確定',
	'lqt-drag-title' => 'ドラッグを確認',
	'lqt-drag-reason' => '理由：',
	'lqt-drag-subject' => '新しいスレッドの表題:',
	'lqt-edit-signature' => '(署名の編集)',
	'lqt-preview-signature' => '(プレビュー)',
	'lqt-feed-title-all' => '{{SITENAME}} — 新規投稿',
	'lqt-feed-title-all-from' => '{{SITENAME}} — $1からの新規投稿',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — 新規スレッド',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — $1からの新規スレッド',
	'lqt-feed-title-replies' => '{{SITENAME}} — 返信',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — $1からの返信',
	'lqt-feed-new-thread-intro' => '$1に$2が投稿した新規スレッド',
	'lqt-feed-reply-intro' => '$2が$1に投稿した$3への返信',
	'tooltip-pt-newmessages' => 'ご覧のスレッドもしくはスレッドのトークページにおける新たな投稿を表示',
	'lqt-newmessages-n' => '新しいメッセージ ($1)',
	'lqt_newmessages' => '新しいメッセージ(なし)',
	'lqt_newmessages-title' => '新しいメッセージ',
	'lqt-newpost-summary' => '新規スレッド: $1',
	'lqt-reply-summary' => '[[$2|$1]] への返信',
	'lqt-talkpage-history-title' => '議論ページ履歴',
	'lqt-talkpage-history-subtitle' => 'ページ: $1',
	'lqt-talkpage-history-tab' => 'ヘッダー',
	'restriction-reply' => '返信の投稿',
	'restriction-newthread' => '新規スレッドの投稿',
	'lqt-protected-reply-thread' => 'このスレッドは新規投稿から保護されているため、投稿できません。',
	'lqt-protected-reply-talkpage' => 'この議論ページのスレッドへの返信は保護されているため、このスレッドには投稿できません。',
	'lqt-protected-newthread' => 'この議論ページは新規スレッド作成から保護されているため、新規スレッドの投稿はできません。',
	'lqt-edit-bump' => 'このスレッドをページ先頭に移動する',
	'lqt-edit-bump-tooltip' => 'このスレッドを議論ページの先頭に移動する',
	'lqt-historicalrevision-error' => '選択した版は壊れているため表示できません。',
	'lqt-reply-subpage' => '返信',
	'nstab-thread' => 'スレッド',
	'nstab-summary' => '要約',
);

/** Lojban (Lojban)
 * @author (vinny)
 */
$messages['jbo'] = array(
	'lqt_delete' => 'daspo',
	'lqt_move_move' => 'stika lo cmene',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 * @author Pras
 */
$messages['jv'] = array(
	'lqt_contents_title' => 'Isi',
	'lqt_new_thread' => 'Miwiti dhiskusi anyar',
	'lqt_reply' => 'Wangsulana',
	'lqt_delete' => 'Busak',
	'lqt_undelete' => 'Batalna pambusakan',
	'lqt_permalink' => 'Pranala permanèn',
	'lqt_discussion_link' => 'dhiskusi',
	'lqt_from_talk' => 'Saka $1',
	'lqt_hist_comment_edited' => 'Tèks komentar disunting',
	'lqt_hist_summary_changed' => 'Ringkesané diganti',
	'lqt_hist_reply_created' => 'Nggawé wangsulan anyar',
	'lqt_hist_deleted' => 'Dibusak',
	'lqt_hist_undeleted' => 'Batal busak',
	'lqt_hist_moved_talkpage' => 'Dipindhah',
	'lqt_revision_as_of' => 'Révisi per $2 ing $3.',
	'lqt_youhavenewmessages' => 'Panjenengan duwé [[$1|pesen anyar]].',
	'lqt_protectedfromreply_link' => 'direksa',
	'lqt_subject' => 'Subyèk:',
	'lqt_noreason' => 'Ora mènèhi alesan.',
	'lqt_summary_notice_link' => 'nulis ringkesan',
	'lqt_summary_subtitle' => 'Ringkesan saka $1.',
	'lqt_move_torename_edit' => 'sunting iku',
	'lqt_move_move' => 'Pindhah',
	'lqt_move_nodestination' => 'Panjenengan kudu spésifikasi tujuan.',
	'lqt_move_noreason' => 'Ora mènèhi alesan.',
	'lqt_delete_return' => 'Bali menyang $1.',
	'lqt_header_warning_big' => 'Panjenengan nyunting sawijining $1.',
	'lqt_header_warning_new_discussion' => 'miwiti dhiskusi anyar',
	'lqt_sorting_order' => 'Urutan sortir:',
	'lqt_newmessages' => 'Pesen anyar',
);

/** Georgian (ქართული)
 * @author BRUTE
 * @author Dawid Deutschland
 * @author ITshnik
 * @author გიორგიმელა
 */
$messages['ka'] = array(
	'lqt-desc' => 'ამატებს გვერდზე განხილვის დინებას',
	'lqt_movethread' => 'გადაიტანეთ ტოტი',
	'lqt_deletethread' => 'წაშალეთ/აღადგინეთ ტოტი',
	'lqt_contents_title' => 'შინაარსი',
	'lqt_toc_thread_title' => 'ტოტის სათაური',
	'lqt_toc_thread_author' => 'ინიციატორი',
	'lqt_toc_thread_replycount' => 'პასუხები',
	'lqt_toc_thread_modified' => 'ბოლოს შეიცვალა',
	'lqt_add_header' => 'სათაურის ჩამატება',
	'lqt_new_thread' => 'ახალი განხილვის დაწყება',
	'lqt_invalid_subject' => 'სათაური, რომელიც თქვენ მიუთითეთ, არასწორია.
შეიძლება:
* ის ძალიან დიდია, ან
* შეცდომაა საერთაშორისუ ბმულების ინდექსებში ან სახელთა სივრცის სახელებში.',
	'lqt_empty_subject' => 'თქვენ უნდა მიუთითოთ თემა.',
	'lqt_reply' => 'პასუხი',
	'lqt-parent' => 'მშობელი',
	'lqt_delete' => 'წაშლა',
	'lqt_undelete' => 'აღდგენა',
	'lqt_permalink' => 'ბმული ამ გვერდზე',
	'lqt_fragment' => 'ფრაგმენტი  $1-ზე $2-დან',
	'lqt_discussion_link' => 'განხილვა',
	'lqt_from_talk' => '$1-დან',
	'lqt-history-title' => 'ტოტის ისტორია',
	'lqt_hist_comment_edited' => ' [$2 რედაქტირებული] კომენტარის ტექსტი',
	'lqt_hist_summary_changed' => 'შედეგი შეიცვალა',
	'lqt_hist_reply_created' => 'შექმნილია [[$1|ახალი პასუხი]]',
	'lqt_hist_thread_created' => 'ახალი თემა გახსნილია',
	'lqt_hist_deleted' => 'წაშლილია',
	'lqt_hist_undeleted' => 'აღდგენილია',
	'lqt_hist_moved_talkpage' => 'გადატანილია',
	'lqt_hist_listing_subtitle' => 'ისტორიის ნახვა',
	'lqt_hist_view_whole_thread' => 'იხილეთ მთელი ტოტის ისტორია',
	'lqt_hist_no_revisions_error' => 'ამ ტოტს არა აქვს ისტორია',
	'lqt_hist_past_last_page_error' => 'თქვენ გახვედით ნებადართული გვერდების რაოდენობიდან.',
	'lqt_hist_tooltip_newer_disabled' => 'ეს ბმული გამორთულია, ვინაიდან თქვენ იმყოფებით პირველ გვერდზე.',
	'lqt_hist_tooltip_older_disabled' => 'ეს ბმული გამორთულია, ვინაიდან თქვენ იმყოფებით ბოლო გვერდზე.',
	'lqt_hist_edited_subject' => 'შეცვლილია სათაური "$2-დან" "$3-ზე"',
	'lqt_hist_edited_subject_corrupt' => 'თემა შეცვლილია',
	'lqt_hist_merged_from' => '[[$1|პასუხი]] გადატანილია სხვა ტოტში',
	'lqt_hist_merged_to' => '[[$1|პასუხი]] გადმოტანილია სხვა ტოტიდან',
	'lqt_hist_split_from' => 'ახალ ტოტში გადატანა',
	'lqt_hist_root_blanked' => 'კომენტარი წაშლილია',
	'lqt_hist_adjusted_sortkey' => 'დაზუსტებული თემის პოზიცია',
	'lqt_change_edited_summary' => 'შესწორდა ტოტის რეზიუმე',
	'lqt_change_deleted' => '[$1 ეს ტოტი] ან მისი მშობლიური ტოტი წაიშალა',
	'lqt_change_moved' => '[$ 1 ეს თემა] გადატანილია სხვა განხილვის გვერდზე',
	'lqt_change_root_blanked' => 'ტექსტი [$1 კომენტარის] წაშლილია.',
	'lqt_youhavenewmessages' => 'თქვენ გაქვთ [[$1|ახალი შეტყობინება]].',
	'lqt_protectedfromreply_link' => 'დაცულია',
	'lqt_subject' => 'თემა:',
	'lqt_noreason' => 'მიზეზი ნაჩვენები არაა.',
	'lqt_summary_notice_link' => 'რეზიუმეს დაწერა',
	'lqt_summary_label' => 'თემის რეზიუმე:',
	'lqt_summary_subtitle' => '"$1-ის" რეზიუმე',
	'lqt_nosuchthread' => 'თქვენს მიერ მითითებული ტოტი არ არსებობს.',
	'lqt_nosuchthread_title' => 'არ არის ასეთი ტოტი',
	'lqt_move_movingthread' => 'გადადის  $1.
ეს ტორი არის $2-ის ნაწილი.',
	'lqt_move_torename' => "ამ ტოტის სახელის შესაცვლელად, $1 და შეცვალეთ 'სათაური' ველი.",
	'lqt_move_torename_edit' => 'მისი რედაქტირება',
	'lqt_move_destinationtitle' => 'განხილვის გვერდის სათაური:',
	'lqt_move_move' => 'გადატანა',
	'lqt_move_nodestination' => 'თქვენ უნდა მიუთითოთ დანიშნულების ადგილი.',
	'lqt_move_samedestination' => 'ტოტი უკვე არის ამ გვერდზე!',
	'lqt_move_noreason' => 'მიზეზი ნაჩვენები არაა.',
	'lqt_delete_undeletethread' => 'თემის აღდგენა',
	'lqt_delete_partof' => "ეს თემა არის '''$1-ის''' ნაწილი.",
	'lqt_delete_deleting' => "'''$1'''-ისა და '''ყველა დაკავშირებული პასუხის''' წაშლა.",
	'lqt_delete_deletethread' => 'თემებისა და პასუხების წაშლა',
	'lqt_delete_deleted' => 'თემა წაიშალა.',
	'lqt_delete_undeleted' => 'თემა აღდგა.',
	'lqt_delete_return' => 'დაბრუნება $1-ზე.',
	'lqt_delete_return_link' => 'განხილვის გვერდი',
	'lqt_delete_unallowed' => 'თქვენ არ შეგიძლიათ სტატიების წაშლა.',
	'lqt_delete_show_checkbox' => 'აჩვენე წაშლილი ტოტები',
	'lqt_header_warning_big' => 'თქვენ არედაქტირებთ $1-ს.',
	'lqt_header_warning_bold' => 'განხილვის გვერდის თავი',
	'lqt_header_warning_new_discussion' => 'ახალი დისკუსიის დაწყება',
	'lqt_sorting_order' => 'სორტირების წესი:',
	'lqt_sort_newest_changes' => 'ბოლოს შეცვლილი თავში',
	'lqt_sort_newest_threads' => 'უახლოესი ტოტები თავში',
	'lqt_sort_oldest_threads' => 'ძველი ტოტები თავში',
	'lqt-title' => 'სათაური',
	'lqt-summary' => 'რეზიუმე',
	'lqt-searching' => 'ძიება ტოტებში',
	'lqt-read-message' => 'მონიშნეთ როგორც წაკითხული',
	'lqt-read-message-tooltip' => 'წაშალეთ ეს ტოტი თქვენი კონტროლის სიიდან.
იგი მაინც დარჩება განხილვის თავდაპირველ გვერდზე.',
	'lqt-read-all' => 'მონიშნეთ ყველა, როგორც წაკითხული',
	'lqt-read-all-tooltip' => 'წაშალეთ ყველა ტოტი ახალი შეტყობინებების სიიდან. 
ისინი ისევ დარჩებიან შესაბამის გვერდებზე. 
ამ მოქმედების გაუქმება შეუძლებელია.',
	'lqt-marked-read' => "ტოტი '''$1''' მონიშნულია როგორც წაკითხული.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|შეტყობინება მონიშნულია|შეტყობინებები მონიშნულია}} როგორც წაკითხული.',
	'lqt-email-undo' => 'გაუქმება',
	'lqt-no-new-messages' => 'თქვენ არ გაქვთ ახალი შეტყობინებები.',
	'lqt-new-messages' => 'თქვენ გაქვთ ახალი შეტყობინებები.',
	'lqt-email-info-undo' => 'დააბრუნეთ უკან უკვე წაშლილი ტოტი',
	'lqt-date-info' => 'ეს ბმული გათიშულია, რადგანაც თქვენ ათვალიერებთ ყველა ტოტს.',
	'lqt-newmessages-context' => 'სრული ტოტი',
	'lqt-thread-created' => 'შექმნილია',
	'lqt-history-time' => 'დრო',
	'lqt-history-user' => 'მომხმარებელი',
	'lqt-history-action' => 'მოქმედებები',
	'lqt-history-comment' => 'კომენტარი',
	'lqt-history-thread' => 'ტოტი',
	'lqt-thread-edited-author' => 'რედაქტირებული ავტორის მიერ
<br />
ბოლო რედაქტირება: $1',
	'lqt-thread-edited-others' => 'შეასწორა {{PLURAL:$2|სხვა მომხმარებელმა|$2 მომხმარებლებმა}}.<br />
ბოლო რედაქტირება: $1',
	'lqt-header-actions' => 'მოქმედება',
	'lqt_summarize_link' => 'შეჯამება',
	'lqt-summarize-intro' => 'გთხოვთ დაურთოთ კომენტარი კომენტარი ქვემოთ წარმოდგენილ ყუთში.
თქვენ შეგიძლიათ გამოიყენოთ ნებისმიერ ვიკიტექსტი.
როდესაც დაასრულებთ, დააჭირეთ "{{int:savearticle}}".',
	'lqt-thread-split' => 'ახალ ტოტში გადატანა',
	'lqt-split-success' => 'თქვენ წარმატებით გაყავით ტოტი $1.',
	'lqt_split_thread' => 'ტოტის გაყოფა',
	'lqt-thread-split-subject' => 'ახალი ტოტის სათაური:',
	'lqt-thread-split-thread' => 'ტოტი:',
	'lqt-split-submit' => 'გაყოფა',
	'lqt_split_badsubject' => 'თქვენს მიერ მითითებული სათაური ვერ გამოიყენება.',
	'lqt-no-threads' => 'ამ გვერდზე ჯერ არ არის ტოტი.',
	'lqt-delete-parent-warning' => 'ეს არის უმაღლესი დონი ტოტი, რომელსაც აქვს პასუხები.
მისი პასუხების ავტომატურად წაიშლება.
ამის თავიდან ასაშორებლად, ტოტის წაშლამდე გთხოვთ გამოიტანოთ პასუხები.',
	'lqt-delete-parent-deleted' => 'ზემოთ ხსენებული ტოტი წაიშალა ($1)',
	'lqt-delete-replies-done' => 'ყველა პასუხი ამ ტოტზე ასევე წაიშალა.',
	'lqt-movethread' => 'გადატანა',
	'lqt-menu-trigger' => 'მეტი',
	'lqt-newmessages-from' => '$1-დან',
	'lqt-hot-topics' => 'ცხელი თემები',
	'lqt-add-reply' => 'პასუხის ჩამატება',
	'lqt_rc_new_discussion' => 'შექმნა ახალი ტოტი, "$1"',
	'lqt_rc_new_reply' => 'დატოვა პასუხი "$1"-ს',
	'right-lqt-split' => 'გაყავით ტოტები',
	'right-lqt-merge' => 'გააერთიანეთ ტოტები',
	'lqt-thread-merge' => 'დაუკავშირდით სხვა ტოტს',
	'lqt-thread-merge-to' => 'გაუერთიანეთ ამ ტოტს',
	'lqt_merge_thread' => 'ტოტების გაერთიანება',
	'lqt-thread-merge-source' => 'გასაერთიანებელი:',
	'lqt-thread-merge-dest' => 'მისამართი:',
	'lqt-merge-submit' => 'მიერთება',
	'lqt-merge-success' => 'თქვენ წარმატებით მიუერთეთ $1 ტოტი $2 ტოტს.',
	'lqt-log-name' => 'ყველა განხილვის ტოტების ჟურნალი',
	'lqt-log-header' => 'ამ ჟურნალში იწერება მოქმედებები, რომლებიც განხორციელდა განხილვის ტოტებში.',
	'lqt-log-action-move' => 'გადატანილია [[$1]] [[$2]]-დან [[$3]]-ზე.',
	'lqt-log-action-split' => 'გამოყო [[$1]] [[$3]]-დან, ახალი თემით «$2»',
	'lqt-log-action-merge-across' => 'გადაიტანა [[$1]]  [[$2]]-დან [[$3]]-ში',
	'lqt-log-action-merge-down' => 'გააერთიანა [[$1]] [[$3]]-ში',
	'lqt-log-action-subjectedit' => 'შეცვალა თემა [[$1]]  «$2»-დან «$3»-ზე',
	'lqt-log-action-resort' => 'შეცვალა სორტირების წესი [[$1]]-დან. სორტირების გასაღების შეცვლა $2-დან $3-ზე',
	'lqt-preference-notify-talk' => 'ელ-ფოსტის მეშვეობით შემატყობინეთ ტოტზე ახალი შეტყობინებების შესახებ.',
	'lqt-preference-watch-threads' => 'თვალი ადევნეთ ტოტებზე, რომლებიც შევქმენი, ან ვუპასუხე.',
	'prefs-lqt' => 'განხილვა ტოტების მიხედვით',
	'lqt-preference-display-depth' => '*პასუხების მაქსიმალური სიღრმის ჩვენება',
	'lqt-preference-display-count' => 'პასუხების მაქსიმალური სიღრმის ჩვენება',
	'lqt-preference-custom-signatures' => 'აჩვენეთ მომხმარებლების კონფიგურირებადი ხელმოწერები',
	'lqt-enotif-subject-reply' => '{{SITENAME}} განხილვა - პასუხი: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} განხილვა - ახალი თემა: $1',
	'lqt-quote' => 'ციტირება',
	'lqt-search-legend' => 'განხილვის ძიება ამ გვერდზე',
	'lqt-search-label' => 'ტერმინების ძიება:',
	'lqt-search-button' => 'ძიება',
	'searchprofile-threads' => 'განხილვები',
	'lqt-ajax-updated' => 'ტოტს აქვს ახალი თემები.',
	'lqt-ajax-update-link' => 'განახლება',
	'lqt-thread-show-replies' => 'აჩვენე $1 {{PLURAL:$1|პასუხი|პასუხი}}',
	'lqt-thread-show-more' => 'მეტი პასუხის ჩვენება',
	'lqt-thread-link-url' => 'URL ბმული:',
	'lqt-thread-link-title' => 'ვიკიტექსტის ბმული:',
	'lqt-thread-link-copy' => 'დაკოპირება გაცვლის ბუფერში',
	'lqt-sign-not-necessary' => 'აუცილებელი არაა, ხელი მოაწერეთ თქვენს პოსტს ოთხი ტილდით. ხელმოწერა ნაჩვენებია ავტომატურად.',
	'lqt-change-subject' => 'სათაურის შეცვლა',
	'lqt-save-subject' => 'შენახვა',
	'lqt-save-subject-failed' => 'წარმოიშვა შეცდომა თემის სათაურის შეცვლისას: $1',
	'lqt-ajax-invalid-subject' => 'თქვენს მიერ მითითებული სათაური არასწორი აღმოჩნდა, შეიძლება ის ძალიან გრძელია.',
	'lqt-ajax-no-subject' => 'თქვენ უნდა მიუთითოთ სათაური.',
	'lqt-save-subject-error-unknown' => 'წარმოიშვა შეცდომა თემის სათაურის შექმნისას. გთხოვთ სცადეთ კვლავ ღილაკის "რედაქტირება" დაჭერით.',
	'lqt-cancel-subject-edit' => 'გაუქმება',
	'lqt-drag-activate' => 'ახალ ადგილას გადატანა',
	'lqt-drag-drop-zone' => 'ჩააგდეთ აქ',
	'lqt-drag-confirm' => 'ამ მოქმედების შესასრულებლად, გთხოვთ შეავსეთ მიზეზის ველი და დააჭირეთ "დადასტურება".',
	'lqt-drag-split' => 'გადაიტანეთ თემა მის საკუთარ ტოტში',
	'lqt-drag-setsortkey' => 'პოსტის პოზიციის მორგება ამ გვერდზე',
	'lqt-drag-bump' => 'თემის გადატანა განხილვის გვერდის თავში',
	'lqt-drag-save' => 'დადასტურება',
	'lqt-drag-reason' => 'მიზეზი:',
	'lqt-drag-subject' => 'სათაური ახალი ტოტისათვის:',
	'lqt-edit-signature' => '(რედაქტირების ხელმოწერა)',
	'lqt-preview-signature' => '(წინა)',
	'lqt-feed-title-all' => '{{SITENAME}} — ახალი თემები',
	'lqt-feed-title-all-from' => '{{SITENAME}} — ახალი თემები $1-დან',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — ახალი თემები',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — ახალი თემები $1-დან',
	'lqt-feed-title-replies' => '{{SITENAME}} — პასუხები',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — პასუხები $1-დან',
	'lqt-feed-new-thread-intro' => 'ახალი თემა $1-ზე, დადებული $2-ის მიერ',
	'lqt-feed-reply-intro' => 'პასუხი $3-ს ($1-ზე), დადებული $2-ის მიერ',
	'lqt-newmessages-n' => 'ახალი შეტყობინებები ($1)',
	'lqt_newmessages' => 'ახალი შეტყობინებები',
	'lqt_newmessages-title' => 'ახალი შეტყობინებები',
	'lqt-newpost-summary' => 'ახალი თემა: $1',
	'lqt-reply-summary' => 'პასუხი [[$2|$1]]-ზე',
	'lqt-talkpage-history-title' => 'განხილვის გვერდის ისტორია',
	'lqt-talkpage-history-subtitle' => '$1-სთვის',
	'lqt-talkpage-history-tab' => 'თავი',
	'restriction-reply' => 'პასუხების დადება',
	'restriction-newthread' => 'ახალი ტოტების დადება',
	'lqt-protected-reply-thread' => 'თქვენ არ შეგიძლიათ თემის დადება ამ ტოტში, ვინაიდან ის დაცულია ახალი თემებისაგან.',
	'lqt-protected-reply-talkpage' => 'თქვენ არ შეგიძლიათ თემის დადება ამ ტოტში, ვინაიდან ეს განხილვის გვერდი დაცულია პასუხებისაგან მის ტოტში.',
	'lqt-protected-newthread' => 'თქვენ არ შეგიძლიათ ახალი ტოტების დადება ამ განხილვის გვერდზე, ვინაიდან ის დაცულია ახალი ტოტებისაგან.',
	'lqt-edit-bump-tooltip' => 'ამ ტოტის მისი განხილვის გვერდის თავში გადატანა',
	'lqt-reply-subpage' => 'პასუხი',
	'nstab-thread' => 'დისკუსიის თემა',
	'nstab-summary' => 'დისკუსიის რეზიუმე',
);

/** Kalaallisut (Kalaallisut)
 * @author Qaqqalik
 */
$messages['kl'] = array(
	'lqt-history-user' => 'Atuisoq',
	'lqt-search-button' => 'Ujarlerit',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 * @author វ័ណថារិទ្ធ
 */
$messages['km'] = array(
	'lqt_contents_title' => 'មាតិកា',
	'lqt_toc_thread_author' => 'ចាប់ផ្ដើមដោយ',
	'lqt_toc_thread_replycount' => 'ចំលើយតប',
	'lqt_toc_thread_modified' => 'ត្រូវបានកែប្រែលើកចុងក្រោយ',
	'lqt_add_header' => 'បន្ថែមក្បាលទំព័រ',
	'lqt_new_thread' => 'បើកការពិភាក្សាថ្មីមួយ',
	'lqt_empty_subject' => 'អ្នកត្រូវតែដាក់ប្រធានបទ។',
	'lqt_reply' => 'ឆ្លើយតប',
	'lqt-parent' => 'មេ',
	'lqt_delete' => 'លុបចេញ',
	'lqt_undelete' => 'ឈប់លុបចេញ',
	'lqt_permalink' => 'តភ្ជាប់ទៅ',
	'lqt_fragment' => 'បំណែកមួយរបស់ $1 ពី $2',
	'lqt_discussion_link' => 'ការពិភាក្សា',
	'lqt_from_talk' => 'ពី $1',
	'lqt_hist_comment_edited' => 'ចារ[$2 ត្រូវបានកែប្រែ]',
	'lqt_hist_summary_changed' => 'ចំណារពន្យល់ត្រូវបានផ្លាស់ប្តូរ',
	'lqt_hist_reply_created' => '[[$1|ការឆ្លើយតបថ្មី ]] ត្រូវបានបង្កើត',
	'lqt_hist_deleted' => 'ត្រូវបានលុបចោល',
	'lqt_hist_undeleted' => 'លែងបានត្រូវលុបចេញ',
	'lqt_hist_moved_talkpage' => 'បានប្តូរទីតាំង',
	'lqt_hist_listing_subtitle' => 'មើលបញ្ជីប្រវត្តិ',
	'lqt_hist_past_last_page_error' => 'អ្នកបានហួស ចំនួនទំព័រ នៃប្រវត្តិ ដែលមាន',
	'lqt_hist_tooltip_newer_disabled' => 'តំណភ្ជាប់នេះ អសកម្ម ព្រោះ អ្នកស្ថិតលើ ទំព័រដំបូង ។',
	'lqt_hist_tooltip_older_disabled' => 'តំណភ្ជាប់នេះ អសកម្ម ព្រោះ អ្នកស្ថិតលើ ទំព័រចុងក្រោយ ។',
	'lqt_youhavenewmessages' => 'អ្នកមាន [[$1|សារថ្មីៗ]]​។',
	'lqt_protectedfromreply_link' => 'បានការពារ',
	'lqt_subject' => 'ប្រធានបទ ៖',
	'lqt_noreason' => 'គ្មានហេតុផល ត្រូវបានផ្តល់ឱ្យ ។',
	'lqt_thread_deleted' => 'ខ្សែស្រឡាយ​នេះ​ត្រូវ​បាន​លុប​។',
	'lqt_summary_notice' => 'គ្មានបំលាស់ប្តូរ​ក្នុងការពិភាក្សានេះ តាំងពី​យ៉ាងតិច $2 ថ្ងៃ​។ បើចង់ផ្លាស់ប្តូរវា, អ្នកអាចនឹង​ត្រូវការ $1 ។',
	'lqt_summary_notice_link' => 'សរសេរ​មួយ​សេចក្តីសង្ខេប',
	'lqt_summary_subtitle' => "សេចក្ដីសង្ខេបរបស់ ''$1''",
	'lqt_nosuchrevision' => 'គ្មាន​ការពិនិត្យឡើងវិញ​នៃ​ខ្សែស្រឡាយ​នេះ​ទេ​។',
	'lqt_nosuchthread' => 'មិនមាន​ខ្សែស្រឡាយ​ណាមួយ​ទេ។',
	'lqt_threadrequired' => 'អ្នក​ត្រូវតែ​បញ្ជាក់​ខ្សែស្រឡាយ​មួយ​នីក្នុង URL ។',
	'lqt_move_movingthread' => 'ប្ដូរទីតាំង $1​។
ខ្សែស្រឡាយ​នេះ​ជា​ផ្នែក​នៃ $2​។',
	'lqt_move_torename_edit' => 'កែប្រែវា',
	'lqt_move_destinationtitle' => 'ចំណងជើង​នៃ​ទំព័រពិភាក្សា​​គោលដៅ​៖',
	'lqt_move_move' => 'ប្តូរទីតាំង',
	'lqt_move_nodestination' => 'អ្នកត្រូវតែ​សំដៅ​មួយគោលដៅ​។',
	'lqt_move_noreason' => 'គ្មានហេតុផល ត្រូវបានផ្តល់ឱ្យ ។',
	'lqt_delete_undeletethread' => 'មិនលុប​ខ្សែស្រឡាយ',
	'lqt_delete_partof' => 'ខ្សែស្រឡាយ​នេះ​ជា​ផ្នែក​នៃ $1 ។',
	'lqt_delete_deleting' => "លុប '''$1''' និង '''ការ​ឆ្លើយតប​ទាំងអស់''' ចំពោះ​វា​។",
	'lqt_delete_deleted' => 'ខ្សែស្រឡាយ​ដែល​បាន​លុប​។',
	'lqt_delete_undeleted' => 'ខ្សែស្រឡាយ​ដែល​មិន​ត្រូវ​បាន​លុប​។',
	'lqt_delete_return' => 'ត្រលប់ទៅកាន់ $1 វិញ។',
	'lqt_delete_return_link' => 'ទំព័រពិភាក្សា',
	'lqt_delete_unallowed' => 'អ្នក​មិន​ត្រូវ​បាន​អនុញ្ញាត​ឱ្យ​លុប​ខ្សែស្រឡាយ​ទេ​។',
	'lqt_delete_show_checkbox' => 'បង្ហាញ​ខ្សែស្រឡាយ​ដេល​បាន​លុប',
	'lqt_header_warning_big' => 'អ្នកកំពុង​កែប្រែ $1 ។',
	'lqt_header_warning_bold' => 'បឋមកថានៃទំព័រពិភាក្សា',
	'lqt_header_warning_new_discussion' => 'ចាប់ផ្តើមការពិភាក្សាថ្មី',
	'lqt_sorting_order' => 'លំដាប់​រៀប​៖',
	'lqt_sort_newest_changes' => 'កែប្រែចុងក្រោយដាក់មុន',
	'lqt_sort_newest_threads' => 'ខ្សែស្រឡាយ​ថ្មីជាងគេបំផុត',
	'lqt_sort_oldest_threads' => 'ខ្សែស្រឡាយ​ចាស់​ជាងគេ​បំផុត',
	'lqt-title' => 'ចំណងជើង',
	'lqt-summary' => 'ចំណារពន្យល់',
	'lqt-searching' => 'ស្វែងរក​ខ្សែស្រឡាយ',
	'lqt-read-message' => 'កត់ចំណាំថាបានអានហើយ',
	'lqt-read-all' => 'ដាក់សម្គាល់​ទាំងអស់​ថា​បាន​អាន',
	'lqt-email-undo' => 'មិនធ្វើវិញ',
	'lqt-no-new-messages' => 'មិនមាន​សារ​សម្រាប់​អ្នក​ទេ​។',
	'lqt-new-messages' => '✒ មានសារថ្មីៗសម្រាប់អ្នក។',
	'lqt-thread-created' => 'បាន​បង្កើត​',
	'lqt-history-time' => 'ពេល​វេលា​',
	'lqt-history-user' => 'អ្នកប្រើប្រាស់​',
	'lqt-history-action' => 'សកម្មភាព​',
	'lqt-history-comment' => 'យោបល់',
	'lqt-thread-edited-author' => 'កែប្រែ​ដោយ​អ្នក​និពន្ធ​<br />
កែប្រែចុងក្រោយនៅ៖ $1',
	'lqt-thread-edited-others' => 'កែប្រែ​ដោយ​អ្នក​ប្រើប្រាស់​ដទៃ​ទៀត​<br />
កែប្រែចុងក្រោយនៅ៖ $1',
	'lqt-header-actions' => 'សកម្មភាព​',
	'lqt_summarize_link' => 'សង្ខេប​',
	'lqt-search-button' => 'ស្វែង​រក​',
	'lqt-newmessages-n' => 'សារថ្មីៗ ($1)',
	'lqt_newmessages' => 'សារថ្មីៗ (គ្មាន)',
	'lqt_newmessages-title' => 'សារថ្មីៗ',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'lqt_delete' => 'ಅಳಿಸು',
	'lqt-title' => 'ಶೀರ್ಷಿಕೆ',
	'lqt-summary' => 'ಸಾರಾಂಶ',
	'lqt-search-button' => 'ಹುಡುಕು',
	'lqt-cancel-subject-edit' => 'ರದ್ದು ಮಾಡು',
	'lqt-drag-reason' => 'ಕಾರಣ:',
	'lqt-preview-signature' => '(ಮುನ್ನೋಟ)',
);

/** Korean (한국어)
 * @author Albamhandae
 * @author Changwoo
 * @author FriedC
 * @author Gapo
 * @author Klutzy
 * @author Kwj2772
 * @author Ryuch
 */
$messages['ko'] = array(
	'lqt-desc' => '토론 문서의 스레드 토론 확장기능을 추가',
	'lqt_movethread' => '스레드를 다른 문서로 이동',
	'lqt_deletethread' => '스레드 삭제/복구',
	'lqt_contents_title' => '목차',
	'lqt_toc_thread_title' => '스레드 제목',
	'lqt_toc_thread_author' => '토론을 시작한 사용자',
	'lqt_toc_thread_replycount' => '답글',
	'lqt_toc_thread_modified' => '마지막으로 수정된 시각',
	'lqt_add_header' => '머리말 추가',
	'lqt_new_thread' => '새 토론 시작하기',
	'lqt_invalid_subject' => '주제가 잘못되었습니다.
* 주제가 너무 길거나,
* 인터위키나 다른 네임스페이스와의 충돌이 발생했을 수 있습니다.',
	'lqt_empty_subject' => '주제를 반드시 입력해야 합니다.',
	'lqt_reply' => '답변',
	'lqt-parent' => '상위 스레드',
	'lqt_delete' => '삭제',
	'lqt_undelete' => '복구',
	'lqt_permalink' => '링크',
	'lqt_fragment' => '$2 문서에서의 $1의 일부',
	'lqt_discussion_link' => '토론',
	'lqt_from_talk' => '$1에서의 토론',
	'lqt-history-title' => '스레드 역사',
	'lqt_hist_comment_edited' => '의견 글을 [$2 수정함]',
	'lqt_hist_summary_changed' => '요약문을 변경함',
	'lqt_hist_reply_created' => '[[$1|답글]]을 남김',
	'lqt_hist_thread_created' => '새 스레드 생성',
	'lqt_hist_deleted' => '삭제함',
	'lqt_hist_undeleted' => '복구됨',
	'lqt_hist_moved_talkpage' => '이동함',
	'lqt_hist_listing_subtitle' => '스레드 역사 보기',
	'lqt_hist_view_whole_thread' => '전체 스레드의 역사 보기',
	'lqt_hist_no_revisions_error' => '이 스레드는 변경 내역이 없습니다.',
	'lqt_hist_past_last_page_error' => '변경 내력이 있는 페이지 수를 넘어섰습니다.',
	'lqt_hist_tooltip_newer_disabled' => '이 페이지가 첫 페이지이기 때문에 링크가 비활성화되었습니다.',
	'lqt_hist_tooltip_older_disabled' => '이 페이지가 마지막 페이지이기 때문에 링크가 비활성화되었습니다.',
	'lqt_hist_split' => '답글이 새 스레드로 분할됨',
	'lqt_hist_edited_subject' => '제목을 "$2"에서 "$3"으로 바꿈',
	'lqt_hist_edited_subject_corrupt' => '제목을 바꿈',
	'lqt_hist_merged_from' => '[[$1|답글]]이 다른 스레드로 옮겨짐',
	'lqt_hist_merged_to' => '[[$1|답글]]이 다른 스레드에서 옮겨옴',
	'lqt_hist_split_from' => '새 스레드로 분할함',
	'lqt_hist_root_blanked' => '의견 글을 지움',
	'lqt_hist_adjusted_sortkey' => '스레드 위치를 조정함',
	'lqt_revision_as_of' => '$2 $3 판',
	'lqt_change_new_thread' => '이 스레드의 첫 판입니다.',
	'lqt_change_reply_created' => '이 판에서 [$1 강조 처리된 의견]이 추가되었습니다.',
	'lqt_change_edited_root' => '이 판에서 [$1 강조 처리된 의견]이 편집되었습니다.',
	'lqt_change_edited_summary' => '이 스레드의 요약문이 편집되었습니다.',
	'lqt_change_deleted' => '[$1 이 스레드] 혹은 상위 스레드가 삭제되었습니다.',
	'lqt_change_undeleted' => '[$1 강조 처리된 글]이 복구되었습니다.',
	'lqt_change_moved' => '[$1 이 스레드]는 다른 토론 문서로 옮겨졌습니다.',
	'lqt_change_split' => '[$1 이 스레드]는 다른 스레드에서 분할되었습니다.',
	'lqt_change_edited_subject' => '이 스레드의 주제가 "$2"에서 "$3"으로 바뀌었습니다.',
	'lqt_change_merged_from' => '이 스레드의 [$1 답글]이 다른 스레드로 옮겨졌습니다.',
	'lqt_change_merged_to' => '[$1 강조 처리된 답글]이 다른 스레드에서 옮겨졌습니다.',
	'lqt_change_split_from' => '이 스레드의 [$1 하위 스레드]가 독립적인 스레드로 분할되었습니다.',
	'lqt_change_root_blanked' => '[$1 의견]을 지웠습니다.',
	'lqt_youhavenewmessages' => '[[$1|새 메시지]]가 있습니다.',
	'lqt_protectedfromreply' => '이 스레드는 답변을 달지 못하도록 $1되어 있습니다.',
	'lqt_protectedfromreply_link' => '보호',
	'lqt_subject' => '주제:',
	'lqt_noreason' => '이유를 입력하지 않았습니다.',
	'lqt_move_placeholder' => '이 스레드는 $1 스레드가 이 문서에서 옮겨졌음을 알리는 스레드입니다.
스레드는 $3 $4에 $2에 의해 옮겨졌습니다.
해당 스레드는 지금은 $5에 위치하고 있습니다.',
	'lqt_thread_deleted_for_sysops' => "이 스레드는 '''삭제'''되어 관리자만이 볼 수 있습니다.",
	'lqt_thread_deleted' => '이 스레드는 삭제되었습니다.',
	'lqt_summary_notice' => '이 토론에 최소 $2일간 아무런 변화가 없었습니다.
결론이 내려지면 $1할 수 있습니다.',
	'lqt_summary_notice_link' => '요약문을 작성',
	'lqt_summary_label' => '스레드 요약:',
	'lqt_summary_subtitle' => '‘$1’ 요약',
	'lqt_nosuchrevision' => '이 스레드에 해당하는 판이 없습니다.',
	'lqt_nosuchthread' => '당신이 제시한 스레드가 존재하지 않습니다.',
	'lqt_nosuchthread_title' => '해당되는 스레드가 없습니다.',
	'lqt_threadrequired' => '당신은 스레드를 URL로 제시하여야 합니다.',
	'lqt_move_movingthread' => '$1을(를) 옮깁니다.
이 스레드는 $2 문서에 속해 있습니다.',
	'lqt_move_torename' => '이 스레드의 이름을 바꾸려면, $1하여 주제를 바꾸십시오.',
	'lqt_move_torename_edit' => '편집',
	'lqt_move_destinationtitle' => '이동할 새 토론 문서의 제목',
	'lqt_move_move' => '이동',
	'lqt_move_nodestination' => '이동할 문서를 반드시 지정하여야 합니다.',
	'lqt_move_thread_bad_destination' => '이동할 문서가 토론 문서가 아닙니다.',
	'lqt_move_samedestination' => '이 스레드가 이미 이 문서에 있습니다!',
	'lqt_move_noreason' => '이유를 입력하지 않았습니다.',
	'lqt_move_success' => '스레드가 $1(으)로 옮겨졌습니다.',
	'lqt_delete_undeletethread' => '스레드 되살리기',
	'lqt_delete_partof' => "이 스레드는 '''$1'''에 속해 있습니다.",
	'lqt_delete_deleting' => "'''$1''' 스레드와 관련된 '''모든 답변'''을 삭제합니다.",
	'lqt_delete_deletethread' => '스레드와 답글을 삭제하기',
	'lqt_delete_deleted' => '스레드가 삭제되었습니다.',
	'lqt_delete_undeleted' => '스레드가 복구되었습니다.',
	'lqt_delete_return' => '$1(으)로 돌아갑니다.',
	'lqt_delete_return_link' => '토론 문서',
	'lqt_delete_unallowed' => '스레드를 삭제할 권한이 없습니다.',
	'lqt_delete_show_checkbox' => '삭제된 스레드를 보기',
	'lqt_talkpage_autocreate_summary' => '스레드가 처음 게시되었을 때 토론 문서를 자동으로 생성함',
	'lqt_header_warning_big' => '당신은 $1을 편집하고 있습니다.',
	'lqt_header_warning_after_big' => '머리말은 안내 사항을 알리는 용도로 사용됩니다.
$2를 누르면 새 토론을 시작할 수 있습니다.',
	'lqt_header_warning_bold' => '토론 문서의 머리말',
	'lqt_header_warning_new_discussion' => '새 토론 시작하기',
	'lqt_sorting_order' => '정렬 순서:',
	'lqt_sort_newest_changes' => '최근에 바뀐 스레드를 먼저 배치하기',
	'lqt_sort_newest_threads' => '새 스레드를 먼저 배치하기',
	'lqt_sort_oldest_threads' => '오래 된 스레드를 먼저 배치하기',
	'lqt-title' => '제목',
	'lqt-summary' => '요약',
	'lqt-searching' => '스레드 검색',
	'lqt-read-message' => '읽은 것으로 표시',
	'lqt-read-message-tooltip' => '새 메시지 목록에서 이 스레드를 지웁니다.
하지만 토론 문서에서는 계속 보여질 것입니다.',
	'lqt-read-all' => '모두 읽은 것으로 표시',
	'lqt-read-all-tooltip' => '새 메시지 목록에서 모든 스레드를 지웁니다.
이 스레드는 토론 문서 자체에는 계속 보여질 것입니다.
이 동작은 되돌릴 수 없습니다.',
	'lqt-marked-read' => "'''$1''' 스레드를 읽은 것으로 표시했습니다.",
	'lqt-count-marked-read' => '메시지 $1개를 읽은 것으로 표시했습니다.',
	'lqt-email-undo' => '취소',
	'lqt-no-new-messages' => '새로운 메시지가 없습니다.',
	'lqt-new-messages' => '✒ 새 메시지가 도착했습니다.',
	'lqt-email-info-undo' => '방금 없앤 스레드를 되돌립니다.',
	'lqt-date-info' => '모든 날짜의 스레드를 보고 있기 때문에 이 링크는 비활성화되어있습니다.',
	'lqt-newmessages-context' => '전체 스레드',
	'lqt-thread-created' => '생성됨',
	'lqt-history-time' => '시간',
	'lqt-history-user' => '사용자',
	'lqt-history-action' => '활동 내역',
	'lqt-history-comment' => '편집 요약',
	'lqt-history-thread' => '스레드',
	'lqt-thread-edited-author' => '작성자가 수정함<br />
마지막 편집: $1',
	'lqt-thread-edited-others' => '다른 {{PLURAL:$2|사용자|$2명의 사용자}}가 편집하였음.<br />
마지막 편집: $1',
	'lqt-header-actions' => '동작',
	'lqt_summarize_link' => '요약',
	'lqt-summarize-intro' => '편집 상자에 아래 스레드의 내용을 요약해주세요.
요약할 때 모든 위키문법을 사용할 수 있습니다.
작성을 마치셨다면 "{{int:savearticle}}" 버튼을 클릭해주세요.',
	'lqt-thread-split' => '새 스레드로 분할',
	'lqt-split-success' => "'$1' 스레드를 성공적으로 분할하였습니다.",
	'lqt_split_thread' => '스레드 분할하기',
	'lqt-thread-split-subject' => '새 스레드의 제목:',
	'lqt-thread-split-thread' => '스레드:',
	'lqt-split-submit' => '분할',
	'lqt_split_badsubject' => '당신이 입력한 제목이 잘못되었습니다.',
	'lqt-no-threads' => '이 문서에는 스레드가 없습니다.',
	'lqt-delete-parent-warning' => '이 스레드는 답글이 있는 최상위 스레드입니다.
답글 역시 자동적으로 삭제될 것입니다.
이런 불상사를 피하려면, 이 스레드를 삭제하기 전에 답글을 이 스레드에서 분할하십시오.',
	'lqt-delete-parent-deleted' => '상위 스레드를 삭제하였습니다 ($1)',
	'lqt-delete-replies-done' => '이 스레드에 달린 모든 답글도 함께 삭제되었습니다.',
	'lqt-movethread' => '이동',
	'lqt-menu-trigger' => '메뉴',
	'lqt-newmessages-from' => '$1 문서에서의 토론',
	'lqt-hot-topics' => '인기 주제',
	'lqt-add-reply' => '답변하기',
	'lqt_rc_new_discussion' => '새 스레드 "$1"을 게시함',
	'lqt_rc_new_reply' => '"$1"에 대한 답글을 남겼습니다.',
	'right-lqt-split' => '스레드 분할하기',
	'right-lqt-merge' => '스레드 합치기',
	'lqt-thread-merge' => '다른 스레드로 합치기',
	'lqt-thread-merge-to' => '이 스레드에 합치기',
	'lqt_merge_thread' => '스레드 합치기',
	'lqt-thread-merge-source' => '합치기 전 스레드:',
	'lqt-thread-merge-dest' => '합친 뒤의 스레드:',
	'lqt-merge-submit' => '합치기',
	'lqt-merge-success' => '스레드 $1을 $2에 성공적으로 병합했습니다.',
	'lqt-log-name' => '스레드식 토론 기록',
	'lqt-log-header' => '이 기록은 스레드 토론에 관한 동작에 대한 기록입니다.',
	'lqt-log-action-move' => '[[$1]]을 [[$2]]에서 [[$3]]으로 옮김',
	'lqt-log-action-split' => '[[$3]]에서 [[$1]]을 분리하여 "$2"라는 새 제목을 붙임',
	'lqt-log-action-merge-across' => '[[$1]]을 [[$2]]에서 [[$3]]으로 옮김',
	'lqt-log-action-merge-down' => '[[$1]]을 [[$3]]에 합침',
	'lqt-log-action-subjectedit' => '[[$1]]의 주제를 "$2"에서 "$3"으로 바꿈',
	'lqt-log-action-resort' => '[[$1]]의 정렬 순서를 변경. 정렬 키를 $2에서 $3으로 바꿈',
	'lqt-preference-notify-talk' => '내가 주시하고 있는 스레드에 답글이 올라오면 이메일 보내기',
	'lqt-preference-watch-threads' => '내가 생성하거나 답변한 스레드를 주시하기',
	'prefs-lqt' => '스레드식 토론',
	'lqt-preference-display-depth' => '보여 줄 답글의 최대 깊이:',
	'lqt-preference-display-count' => '보여 줄 답글의 최대 개수:',
	'lqt-preference-custom-signatures' => '사용자 지정 서명을 보이기',
	'lqt-enotif-subject-reply' => '{{SITENAME}} 토론 - 답변: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} 토론 - 새 스레드: $1',
	'lqt-enotif-newthread' => "$1님 안녕하세요.
{{SITENAME}}의 $5에서 새 스레드 '$2'(이)가 $3 $4에 생성되었습니다.

해당 스레드를 <$6>에서 볼 수 있습니다.",
	'lqt-enotif-reply' => "$1님 안녕하세요.
{{SITENAME}}에서 $5 문서의 '$2' 스레드에 $3 $4에 새 답변이 올라왔습니다.

해당하는 글을 <$6>에서 볼 수 있습니다.

답변의 내용은 다음과 같습니다:
$7",
	'lqt-quote-intro' => '[[User:$1|$1]] 사용자가 $2 $3에 남긴 글:',
	'lqt-quote' => '인용',
	'lqt-search-legend' => '이 문서에 있는 토론 검색하기',
	'lqt-search-label' => '찾기:',
	'lqt-search-button' => '찾기',
	'searchprofile-threads' => '토론',
	'searchprofile-threads-tooltip' => '스레드 토론과 토론 문서 찾기',
	'lqt-ajax-updated' => '이 스레드에 새 게시물이 있습니다.',
	'lqt-ajax-update-link' => '업데이트',
	'lqt-thread-show-replies' => '답변 $1개 보기',
	'lqt-thread-show-more' => '더 많은 답글 보기',
	'lqt-thread-link-url' => '링크 URL:',
	'lqt-thread-link-title' => '위키문법 링크:',
	'lqt-thread-link-copy' => '클립보드에 복사하기',
	'lqt-sign-not-necessary' => '물결표 4개로 서명할 필요가 없습니다.
서명은 자동으로 표시됩니다.',
	'lqt-marked-as-read-placeholder' => '$1 스레드를 읽은 것으로 표시했습니다.',
	'lqt-change-subject' => '제목 바꾸기',
	'lqt-save-subject' => '저장',
	'lqt-save-subject-failed' => '이 스레드의 제목을 바꾸는 중 다음 오류가 발생했습니다: $1',
	'lqt-ajax-invalid-subject' => '당신이 입력한 제목이 잘못되었습니다. 제목이 너무 길기 때문일 수 있습니다.',
	'lqt-ajax-no-subject' => '제목을 반드시 입력해야 합니다.',
	'lqt-save-subject-error-unknown' => '이 스레드의 제목을 정하는 중 알 수 없는 오류가 발생했습니다. 맨 윗글의 "편집" 버튼을 눌러 시도해 보십시오.',
	'lqt-cancel-subject-edit' => '취소',
	'lqt-drag-activate' => '다른 위치로 옮기기',
	'lqt-drag-drop-zone' => '이곳으로 드래그하세요.',
	'lqt-drag-confirm' => '다음 동작을 수행하려면 이유를 작성한 후 "확인"을 클릭하십시오.',
	'lqt-drag-reparent' => '글을 다른 스레드 안으로 옮기기',
	'lqt-drag-split' => '글을 새 스레드로 분할하기',
	'lqt-drag-setsortkey' => '이 문서에서 글의 위치를 조정하기',
	'lqt-drag-bump' => '토론 문서의 맨 위로 옮기기',
	'lqt-drag-save' => '확인',
	'lqt-drag-title' => '드래그 확인',
	'lqt-drag-reason' => '이유:',
	'lqt-drag-subject' => '새 스레드의 주제:',
	'lqt-edit-signature' => '(서명 편집하기)',
	'lqt-preview-signature' => '(미리 보기)',
	'lqt-feed-title-all' => '{{SITENAME}} — 새 게시물',
	'lqt-feed-title-all-from' => '{{SITENAME}} — $1에서의 새 게시물',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — 새 스레드',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — $1에서의 새 스레드',
	'lqt-feed-title-replies' => '{{SITENAME}} — 답글',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — $1에서의 답글',
	'lqt-feed-new-thread-intro' => '$1에서 $2가 작성한 새 스레드',
	'lqt-feed-reply-intro' => '$1 문서의 $3 스레드에 대한 $2 사용자의 답글',
	'lqt-newmessages-n' => '새 메시지 ($1)',
	'lqt_newmessages' => '새 메시지 (없음)',
	'lqt_newmessages-title' => '새 메시지',
	'lqt-newpost-summary' => '새 스레드: $1',
	'lqt-reply-summary' => '[[$2|$1]]에 대한 답변',
	'lqt-talkpage-history-title' => '토론 문서 역사',
	'lqt-talkpage-history-subtitle' => '$1에서의 토론 기록',
	'lqt-talkpage-history-tab' => '머리말',
	'restriction-reply' => '답변하기',
	'restriction-newthread' => '새 토론 시작하기',
	'lqt-protected-reply-thread' => '이 스레드가 새 게시물을 올릴 수 없도록 보호되어 있기 때문에 이 스레드에 글을 남길 수 없습니다.',
	'lqt-protected-reply-talkpage' => '이 토론 문서가 스레드에 답글을 달 수 없도록 보호되어 있기 때문에 이 스레드에 답글을 남길 수 없습니다.',
	'lqt-protected-newthread' => '이 토론 문서가 새 스레드를 생성하지 못하게 잠겨 있기 때문에 이 토론 문서에 새 스레드를 올릴 수 없습니다.',
	'lqt-edit-bump' => '이 스레드를 맨 위로 옮기기',
	'lqt-edit-bump-tooltip' => '이 스레드를 토론 문서의 맨 위로 옮깁니다.',
	'lqt-historicalrevision-error' => '당신이 선택한 판에 문제가 있어서 볼 수 없습니다.',
	'lqt-reply-subpage' => '답글',
	'nstab-thread' => '스레드',
	'nstab-summary' => '편집 요약',
);

/** Krio (Krio)
 * @author Jose77
 */
$messages['kri'] = array(
	'lqt_delete' => 'Dilit',
	'lqt_discussion_link' => 'diskohshohn',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'lqt_contents_title' => 'Manga Sulud',
	'lqt_delete' => 'Para',
	'lqt_discussion_link' => 'sogdanunay',
	'lqt_delete_return' => 'Balik sa $1.',
);

/** Colognian (Ripoarisch)
 * @author Als-Holder
 * @author Purodha
 */
$messages['ksh'] = array(
	'lqt-desc' => 'Määt {{int:lqt-history-thread}}e en Klaaf-Sigge müjjelesch.',
	'lqt_movethread' => 'Donn dä {{int:lqt-history-thread}} op en ander Sigg ömträke',
	'lqt_deletethread' => 'Ene {{int:lqt-history-thread}} fottschmiiße odder zeröckholle',
	'lqt_contents_title' => 'Enhallt',
	'lqt_toc_thread_title' => 'Däm {{int:lqt-history-thread}} sing Övverschreff',
	'lqt_toc_thread_author' => 'Aanjevange vum',
	'lqt_toc_thread_replycount' => 'Beidrähsch',
	'lqt_toc_thread_modified' => 'Zoläz jeändert',
	'lqt_add_header' => 'En Övvershreff dobei donn',
	'lqt_new_thread' => 'Fang ene neue {{int:lqt-history-thread}} aan',
	'lqt_invalid_subject' => 'Dat Teema, wat De enjejovve häs, jeiht esu nit.
* Et künnt ze lang sinn.
* Et künnt sesch met enem Vörsaz för Engewiki_Lengks biiße.
* Et künnt sesch met enem Nahme för_e Appachtemang biiße.',
	'lqt_empty_subject' => 'Do moß ene Beträf aanjävve.',
	'lqt_reply' => 'Antwoote',
	'lqt-parent' => 'Dä Beidraach, wo dat heh en Antwoot drop es',
	'lqt_delete' => 'Fottschmieße',
	'lqt_undelete' => 'Wider zerök holle',
	'lqt_permalink' => 'Permalengk noh heh',
	'lqt_fragment' => 'E Shtöckelsche vun enem $1 op dä Sigg „$2“',
	'lqt_discussion_link' => '{{int:lqt-history-thread}}',
	'lqt_from_talk' => 'Fun dä Sigg „$1“',
	'lqt-history-title' => 'Dem Jeshprääschßfäddem sing Verjangeheit un Versione',
	'lqt_hist_comment_edited' => 'Dä Täx vun dä [$2 Aanmärkung wood jeändert]',
	'lqt_hist_summary_changed' => 'Zosammefassung jeändert',
	'lqt_hist_reply_created' => 'En [[$1|neu Antwoot]] woodt aanjelaat',
	'lqt_hist_thread_created' => 'Ene neue {{int:lqt-history-thread}} es aanjelaat woode',
	'lqt_hist_deleted' => 'Fottjeschmeße',
	'lqt_hist_undeleted' => 'Wider zerök jehollt',
	'lqt_hist_moved_talkpage' => 'Ömjenannt',
	'lqt_hist_listing_subtitle' => 'En Leß met Versione beloore',
	'lqt_hist_view_whole_thread' => 'Donn de Verjangeheit för dä janze {{int:lqt-history-thread}} aanloore',
	'lqt_hist_no_revisions_error' => 'Dä {{int:lqt-history-thread}} hät kein Verjangeheit.',
	'lqt_hist_past_last_page_error' => 'Mer sin henger de läzde Sigg en de Verjangeheit hee.',
	'lqt_hist_tooltip_newer_disabled' => 'Dä Lenk es affjeschalldt, mer sin op de eetßte Sigg hee.',
	'lqt_hist_tooltip_older_disabled' => 'Dä Lenk es affjeschalldt, mer sin op de läzde Sigg hee.',
	'lqt_hist_split' => 'De Antwoot es en ene neue {{int:lqt-history-thread}} afjespalte woode',
	'lqt_hist_edited_subject' => 'Et Teema udder de Övverschreff wood vun „$2“ op „$3“ jeändert',
	'lqt_hist_edited_subject_corrupt' => 'Övverschref jeändert',
	'lqt_hist_merged_from' => 'Di [[$1|Antwoot]] es en ene andere {{int:lqt-history-thread}} jeschuve woode',
	'lqt_hist_merged_to' => 'Di [[$1|Antwoot]] es vun enem andere {{int:lqt-history-thread}} noh heh jeschuve woode',
	'lqt_hist_split_from' => 'Opschpallde en ene neue {{int:lqt-history-thread}}',
	'lqt_hist_root_blanked' => 'Dä Täx vun dä Aanmärkung es fottjenumme',
	'lqt_hist_adjusted_sortkey' => 'Dä Jeschprääschßfäddem es op enem neue Plaz',
	'lqt_revision_as_of' => 'Version vum $2 öm $3 Uhr.',
	'lqt_change_new_thread' => 'Dat hee es däm {{int:lqt-history-thread}} sing eezte Version.',
	'lqt_change_reply_created' => 'Di [$1 makeete Aanmärkung] wood en hee dä Version dobei jeschrevve.',
	'lqt_change_edited_root' => 'Di [$1 makeete Aanmärkung] wood en hee dä Version jeändert.',
	'lqt_change_edited_summary' => 'Däm {{int:lqt-history-thread}} sing Övverschreff es jeändert woode',
	'lqt_change_deleted' => '[$1 Dä {{int:lqt-history-thread}} heh] udder singe Vörjänger es fottjeschmeße woode',
	'lqt_change_undeleted' => 'Dä [$1 makeete Beidraach] es zeröck jehollt',
	'lqt_change_moved' => '[$1 Dä {{int:lqt-history-thread}} heh] es op en ander Klaafsigg jeschuve woode',
	'lqt_change_split' => '[$1 Dä {{int:lqt-history-thread}} heh] es vun enem andere {{int:lqt-history-thread}} afjespallde woode',
	'lqt_change_edited_subject' => 'Et Teema udder de Övverschreff wood vun „$2“ op „$3“ jeändert',
	'lqt_change_merged_from' => 'En [$1 Antwoot] us heh dämm {{int:lqt-history-thread}} es en ene andere {{int:lqt-history-thread}} jeschuve woode',
	'lqt_change_merged_to' => 'Di [$1 makeete Antwoot] es vun enem andere {{int:lqt-history-thread}} noh heh jeschuve woode',
	'lqt_change_split_from' => 'Ene [$1 Ongerfäddem] vun heh däm {{int:lqt-history-thread}} wood en ene eije {{int:lqt-history-thread}} ömjewandelt',
	'lqt_change_root_blanked' => 'Dä Täx vun en [$1 Aanmärkung] wood fottjenumme.',
	'lqt_youhavenewmessages' => 'Do häs [[$1|neu Nohreschte]].',
	'lqt_protectedfromreply' => 'Dä {{int:lqt-history-thread}} es $1, un dröm kam_mer nix dobei donn.',
	'lqt_protectedfromreply_link' => 'jeschöz',
	'lqt_subject' => 'Övver:',
	'lqt_noreason' => 'Keine Aanlass aanjejovve.',
	'lqt_move_placeholder' => 'Dat hee es ene Plazhallder. Hä shteiht för dä {{int:lqt-history-thread}} „$1“, dä {{GENDER:$2|dä|dat|dä Metmaacher|dat|de}} $2 aam $3 öm $4 Uhr op di Klaafsigg „$5“ ömjetrocke hät.',
	'lqt_thread_deleted_for_sysops' => "Dä {{int:lqt-history-thread}} es '''fottjeschmeße''', un kann bloß noch vun de Wiki-Köbeße aanjesinn wääde.",
	'lqt_thread_deleted' => 'Dä {{int:lqt-history-thread}} es fottjeschmeße.',
	'lqt_summary_notice' => 'Aan däm {{int:lqt-history-thread}} hee es zick winnischßdens {{PLURAL:$2|einem Daach|$2 Dääsch|unger einem Daach}} nix mieh jeändert woode. Wann dä afjeschloße es, wells De velleijsch $1.',
	'lqt_summary_notice_link' => 'en Zosammefassung schriive',
	'lqt_summary_label' => 'Dä {{int:lqt-history-thread}} es esu zosamme jevaß woode:',
	'lqt_summary_subtitle' => 'De Zosammefassung vun „$1“',
	'lqt_nosuchrevision' => 'Dä {{int:lqt-history-thread}} hät kein esu en Version.',
	'lqt_nosuchthread' => 'Esu ene {{int:lqt-history-thread}} wood nit jefonge.',
	'lqt_nosuchthread_title' => 'Esu ene {{int:lqt-history-thread}} ham_mer nit',
	'lqt_threadrequired' => 'Do moß ene {{int:lqt-history-thread}} en däm <i lang="en">URL</i> aanjävve.',
	'lqt_move_movingthread' => 'Donn $1 ömtrecke. Dä {{int:lqt-history-thread}} es ene Deil vun $2.',
	'lqt_move_torename' => 'Öm dä {{int:lqt-history-thread}} ömzenänne, $1, un tuusch et Teema uß.',
	'lqt_move_torename_edit' => 'donn dä ändere',
	'lqt_move_destinationtitle' => 'Dä Tittel vun dä Ziel-Klaafsigg:',
	'lqt_move_move' => 'Ömnenne',
	'lqt_move_nodestination' => 'Do moß e Ziel aanjevve.',
	'lqt_move_thread_bad_destination' => 'De Sigg woh dat hen sull, es kein Klaafsigg.',
	'lqt_move_samedestination' => 'Dä {{int:lqt-history-thread}} es alld op dä Sigg!',
	'lqt_move_noreason' => 'Keine Aanlass aanjejovve.',
	'lqt_move_success' => 'Dä {{int:lqt-history-thread}} es noh $1 ömjtrocke woode.',
	'lqt_delete_undeletethread' => 'Donn dä {{int:lqt-history-thread}} zeröck holle',
	'lqt_delete_partof' => 'Dä {{int:lqt-history-thread}} es ene Deijl vun „$1“.',
	'lqt_delete_deleting' => "'''$1''' un '''all de Antwoote drop''' fottschmiiße.",
	'lqt_delete_deletethread' => 'Donn dä {{int:lqt-history-thread}} un sing Antwoote fott schmiiße',
	'lqt_delete_deleted' => 'Dä {{int:lqt-history-thread}} es fottjeschmeße.',
	'lqt_delete_undeleted' => 'Dä {{int:lqt-history-thread}} es wider zerök jehollt.',
	'lqt_delete_return' => 'Jangk retuur noh $1.',
	'lqt_delete_return_link' => 'de Klaafsigg',
	'lqt_delete_unallowed' => 'Do häß nit dat Rääsch, {{int:lqt-history-thread}}e fottzeschmiiße.',
	'lqt_delete_show_checkbox' => 'Donn de fottjeschmeße {{int:lqt-history-thread}} zeije.',
	'lqt_talkpage_autocreate_summary' => 'Di Klaafsigg es automattesch aanjelaat woode, wi dä eetßte {{int:lqt-history-thread}} jeschrvve wood.',
	'lqt_header_warning_big' => 'Do bes en $1 aam ändere.',
	'lqt_header_warning_after_big' => 'Kopp_Reije sin för Aankündijunge un Aanfäng.
Künnt sin, De wells en $2 han.',
	'lqt_header_warning_bold' => 'Der Siggekopp op Klaafsigge',
	'lqt_header_warning_new_discussion' => 'fang ene neue {{int:lqt-history-thread}} aan',
	'lqt_sorting_order' => 'Reijefollesch zom Zoteere:',
	'lqt_sort_newest_changes' => 'de zoläz Jeänderte et eez',
	'lqt_sort_newest_threads' => 'dä neuste {{int:lqt-history-thread}} et eez',
	'lqt_sort_oldest_threads' => 'dä ählste {{int:lqt-history-thread}} et eez',
	'lqt-title' => 'Tittel',
	'lqt-summary' => 'Zosammefassung',
	'lqt-searching' => 'Noh {{int:lqt-history-thread}}e söhke',
	'lqt-read-message' => 'Als „jelesse“ makeere',
	'lqt-read-message-tooltip' => 'Donn dä {{int:lqt-history-thread}} vun de neuje Nohreeschte fott nämme. Dä weed ävver emmer noch op singe ojinaale Klaafsigg ze sinn sin.',
	'lqt-read-all' => 'Alles als jelesse makeere',
	'lqt-read-all-tooltip' => 'Donn all de {{int:lqt-history-thread}}e vun neue Nohreeschte fottnämme. Se bliive ävver op iere ojinaale Klaafsigge, woh mer se beloore kann. Wann De dat deihßt, kanns De et och wider retuur maache.',
	'lqt-marked-read' => 'Dä {{int:lqt-history-thread}} „$1“ es als „jelässe“ makeet.',
	'lqt-count-marked-read' => '{{PLURAL:$1|Ei Nohreesch|$1 Nohreeschte|kei Nohreesch}} als jelesse makeet.',
	'lqt-email-undo' => 'Zeröcknämme',
	'lqt-no-new-messages' => 'Mer hann kei neu Nohreschte för Desch.',
	'lqt-new-messages' => '✒ Mer hann neu Nohreschte för Desch.',
	'lqt-email-info-undo' => 'Donn dä {{int:lqt-history-thread}} zeröckholle, dä De jraad fottjeschemeße häs.',
	'lqt-date-info' => 'Dä Lengk es afjeschaldt. De bes ene {{int:lqt-history-thread}} vun alle Daate am beloore.',
	'lqt-newmessages-context' => 'Dä janze {{int:lqt-history-thread}}',
	'lqt-thread-created' => 'Neu aanjelaat',
	'lqt-history-time' => 'Zick',
	'lqt-history-user' => '{{ns:User}}',
	'lqt-history-action' => 'Aktivitäht',
	'lqt-history-comment' => 'Koot Zosammejefass, Aanlaß, Quell:',
	'lqt-history-thread' => 'Jeschprääschßfäddem',
	'lqt-thread-edited-author' => 'Vum Schriiver sellver jeändert,<br />
et läz aam $4 öm $3',
	'lqt-thread-edited-others' => 'Vun {{PLURAL:$2|enem|$2|keinem}} ander Metmaacher jeändert,<br />
et läz aam $4 öm $3',
	'lqt-header-actions' => 'Akßjuhne',
	'lqt_summarize_link' => 'Zosammefaße',
	'lqt-summarize-intro' => 'Donn dä {{int:lqt-history-thread}} heh dronge zosammefaße, un don dat en dat Vält för et Ändere erenn schriive. Dobei kanns De jeede Wikitäx bruche. Wann De domet fäädesc beß, donn op dä Knopp „{{int:savearticle}}“ klecke.',
	'lqt-thread-split' => 'Afdeijle en ene neue {{int:lqt-history-thread}}',
	'lqt-split-success' => 'Do häs jäz dä {{int:lqt-history-thread}} „$1“ afjedeilt.',
	'lqt_split_thread' => 'Ene {{int:lqt-history-thread}} opdeijle',
	'lqt-thread-split-subject' => 'Neu Övverschreff för dä {{int:lqt-history-thread}}:',
	'lqt-thread-split-thread' => '{{int:lqt-history-thread}}:',
	'lqt-split-submit' => 'Opdeijle',
	'lqt_split_badsubject' => 'Di Övverschreff es Kappes, di De doh enjejovve häs.',
	'lqt-no-threads' => 'Mer han noch kei {{int:lqt-history-thread}}e op heh dä Sigg.',
	'lqt-delete-parent-warning' => 'Dat es ene {{int:lqt-history-thread}} om bövverschte Nivoh, met Antwoote dobei. Däm sing Antwoote wääde automattesch met fott jeschmeße. Öm dat ze ömjonn, donn dä {{int:lqt-history-thread}} opdeile, ih dat De dä fott schmiiß.',
	'lqt-delete-parent-deleted' => 'Dä övverjeoodnete {{int:lqt-history-thread}} eß fottjeschmeße ($1)',
	'lqt-delete-replies-done' => 'All di Antwoote uß heh däm {{int:lqt-history-thread}} sen met fottjeschmeße woode.',
	'lqt-movethread' => 'Ömträke',
	'lqt-menu-trigger' => 'Söns',
	'lqt-newmessages-from' => 'Vun dä Klaafsigg „$1“',
	'lqt-hot-topics' => '{{int:lqt-history-thread}}e met de miehtßte Beidrääsch',
	'lqt-add-reply' => 'Donn en Antwoot derbei',
	'lqt_rc_new_discussion' => 'hät ene neue {{int:lqt-history-thread}} över „$1“ aanjefange.',
	'lqt_rc_new_reply' => 'als Antwoot op „$1“ jeschrevve.',
	'right-lqt-split' => '{{int:lqt-history-thread}}e  opdeile',
	'right-lqt-merge' => '{{int:lqt-history-thread}}e zosammelääje',
	'lqt-thread-merge' => 'Met enem andere {{int:lqt-history-thread}} zosamme donn',
	'lqt-thread-merge-to' => 'Met heh dämm {{int:lqt-history-thread}} zosamme donn',
	'lqt_merge_thread' => '{{int:lqt-history-thread}} zosammelääje',
	'lqt-thread-merge-source' => 'Quell{{lcfirst:{{int:lqt-history-thread}}}}:',
	'lqt-thread-merge-dest' => 'Ziel{{lcfirst:{{int:lqt-history-thread}}}}:',
	'lqt-merge-submit' => 'Lohß Jonn!',
	'lqt-merge-success' => 'Do häß jäz der {{int:lqt-history-thread}} „$1“ onger däm {{int:lqt-history-thread}} „$2“ enjehane.',
	'lqt-log-name' => 'Logboch övver {{int:lqt-history-thread}}e',
	'lqt-log-header' => 'En däm Logbooch heh sin de Einzelheite faßjehallde övver wat met de {{int:lqt-history-thread}}e jedonn woodt.',
	'lqt-log-action-move' => 'hät [[$1]] vun [[$2]] noh [[$3]] ömjetroke.',
	'lqt-log-action-split' => 'hät [[$1]] onger dä Övverschreff [[$3]] eruß jenumme un onger de neue Övverschreff „$2“ jeschtallt.',
	'lqt-log-action-merge-across' => 'hät [[$1]] onger dä Övverschreff [[$2]] eruß jenumme un onger [[$3]] jedonn.',
	'lqt-log-action-merge-down' => 'hät [[$1]] noh onger de Övverschreff [[$3]] ömjetrocke un dobei di {{int:lqt-history-thread}}e zosamme jelaat.',
	'lqt-log-action-subjectedit' => 'hät de Övverschreff fun [[$1]] fun „$2“ op „$3“ omjenannt.',
	'lqt-log-action-resort' => 'hät de Reijefolsch vum Zotteere för [[$1]] fun „$2“ op „$3“ ömjeschtallt.',
	'lqt-preference-notify-talk' => 'Donn mer en <i lang="en">e-mail</i> schecke, wann ene {{int:lqt-history-thread}} op minge Oppaßleß jeändert weet',
	'lqt-preference-watch-threads' => 'Donn de {{int:lqt-history-thread}}e för op ming Oppassles ze donn vörschlonn, woh esch drop antwooden udder di esch aanfangen',
	'prefs-lqt' => 'Klaaf met {{int:lqt-history-thread}}e',
	'lqt-preference-display-depth' => 'Wi deef Antwoote op Antwoote aanjezeisch wääde sulle:',
	'lqt-preference-display-count' => 'De hühßte Aanzahl Antwoote zom Zeije',
	'lqt-preference-custom-signatures' => 'Donn de selfßjemaate „Ongerschreffte“ vun de Metmaacher anzeije',
	'lqt-enotif-subject-reply' => 'Klaaf {{GRAMMAR:em|{{SITENAME}}}} - ene neue Beijdraach zom Teema: $1',
	'lqt-enotif-subject-newthread' => 'Klaaf {{GRAMMAR:em|{{SITENAME}}}} - ene neue {{int:lqt-history-thread}}: $1',
	'lqt-enotif-newthread' => 'Leeven $1,
dat hee es en Nohreesch {{GRAMMAR:Genitiv vun|{{SITENAME}}}},
dat ene neue {{int:lqt-history-thread}} zom Teema
„$2“
öm $4 Uhr aam $3 op dä Sigg $5
dobei jekumme es. Jeschrwevve häd_en {{GENDER:$8|dä|dat|dä Metmaacher|de|et}} $8

Beloore kanns de dä op
<$6>

Der Täx es:
$7

Ene schööne Jrohß!',
	'lqt-enotif-reply' => 'Leeven $1,
dat hee es en Nohreesch {{GRAMMAR:Genitiv vun|{{SITENAME}}}},
dat ene neue Beijdraach zom {{int:lqt-history-thread}} zom Teema
„$2“
öm $4 Uhr aam $3 op dä Sigg $5
dobei jekumme es. Jeschrwevve häd_en {{GENDER:$8|dä|dat|dä Metmaacher|de|et}} $8

Beloore kanns de dä op
<$6>

Dä Beidraach es:

$7

Ene schööne Jrohß!',
	'lqt-quote-intro' => 'Aam $2 hät {{GENDER:$1|dä|dat|dä Metmaacher|dat|de}} [[User:$1|$1]] öm $3 Uhr jeschrevve:',
	'lqt-quote' => 'Donn dat zitteere',
	'lqt-search-legend' => 'En dä {{int:lqt-history-thread}}e op heh dä Sigg söhke',
	'lqt-search-label' => 'Söhk noh:',
	'lqt-search-button' => 'Söhke',
	'searchprofile-threads' => 'Klaaf un {{int:lqt-history-thread}}e',
	'searchprofile-threads-tooltip' => 'Donn en de {{int:lqt-history-thread}}e un op Klaafsigge söhke',
	'lqt-ajax-updated' => 'Dä {{int:lqt-history-thread}} hät neu Beidrääsch.',
	'lqt-ajax-update-link' => 'De neuste Beidrääsch laade.',
	'lqt-thread-show-replies' => 'Zeisch {{PLURAL:$1|ein Antwoot|$1 Antwoote|kei Antwoot}}',
	'lqt-thread-show-more' => 'Zeisch mieh Antwoote',
	'lqt-thread-link-url' => 'Als ene <i lang="en">URL</i>:',
	'lqt-thread-link-title' => 'Als Wikitex:',
	'lqt-thread-link-copy' => 'Em Zwesche_Schpeijscher faßhallde',
	'lqt-sign-not-necessary' => 'Et es nit nüüdesch, Dinge Beidraach met „<nowiki>~~~~</nowiki>“ ze „ongerschriive“.
De „Ongerschreff“ weed automattesch jezeijsch.',
	'lqt-marked-as-read-placeholder' => 'Dä Jeschprääschßfäddem „$1“ es als „Jelässe“ makeert.',
	'lqt-change-subject' => 'Övverschreff ändere',
	'lqt-save-subject' => 'Lohß Jonn!',
	'lqt-save-subject-failed' => 'Heh dä Fähler es opjetrodde, wi mer däm Jeschprääschßfäddem „$1“ sing Övverschreff ändere wullte:',
	'lqt-ajax-invalid-subject' => 'De Övverschreff, di De aanjejovve häs, wohr nit ze bruche. Se künnt zoh lang jewääse sin.',
	'lqt-ajax-no-subject' => 'Do moss_en Övverschreff aanjävve.',
	'lqt-save-subject-error-unknown' => 'Ene onbikannte Fähler es opjetrodde, wi mer de Övverschreff vun heh däm Jeschprääschßfäddem ändere wullte. Bes esu joot, un versöhk et ens domet, der allereezte, bövverschte Beidraach ze ändere.',
	'lqt-cancel-subject-edit' => '{{int:cancel}}',
	'lqt-drag-activate' => 'Op ene neue Plaz träcke',
	'lqt-drag-drop-zone' => 'Heh hen donn',
	'lqt-drag-confirm' => 'Öm dat fäädesch ze maache, wat heh dronger opjelėß es, donn jät bei „Jrond“ enfölle, un dann op „{{int:lqt-drag-save}}“ klecke.',
	'lqt-drag-reparent' => 'Donn dä Beidraach en ene andere Jesprächsfäddem träcke.',
	'lqt-drag-split' => 'Donn dä Beidraach en ene eije Jeschprääschßfäddem',
	'lqt-drag-setsortkey' => 'Donn dä Plaz för dä beidraach op dä Sigg ändere',
	'lqt-drag-bump' => 'Donn dä Beidraach aan der Aanfang vun dä Klaafsigg',
	'lqt-drag-save' => 'Beschtäätejje',
	'lqt-drag-title' => 'Donn dat Römtrecke beschtääteje',
	'lqt-drag-reason' => 'Jrond:',
	'lqt-drag-subject' => 'Övverschreff för dä neue Jeschprääschßfäddem:',
	'lqt-edit-signature' => 'Ongerschreff ändere',
	'lqt-preview-signature' => 'Vör-Ansich',
	'lqt-feed-title-all' => '{{SITENAME}} — Neu Beidrääsch',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Neu Beidrääsch vun dä {{PLURAL:$2|Sigg|Sigge}}: $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Neu Jeshprääschßfäddemme',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Neu {{int:lqt-history-thread}}e vun dä {{PLURAL:$2|Sigg|Sigge}}: $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Antwoote',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Antwoote vun dä {{PLURAL:$2|Sigg|Sigge}}: $1',
	'tooltip-pt-newmessages' => 'Donn de neue Nohreeschte aanzeije, di en {{int:lqt-history-thread}}e enjedraare woodte, wo De draan bedeilesch bes udder drop aam oppaßße bes.',
	'lqt-newmessages-n' => 'ming {{PLURAL:$1|Nohreesch (ein neu)|Nohreeschte ($1 neu)|Nohreeschte (kein neue)}}',
	'lqt_newmessages' => 'ming Nohreeschte (keine)',
	'lqt_newmessages-title' => 'Neu Nohreeschte',
	'lqt-newpost-summary' => 'Ene neue {{int:lqt-history-thread}}:$1',
	'lqt-reply-summary' => 'Antwoot op [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Dä Klaafsigg ier ällder Versione',
	'lqt-talkpage-history-subtitle' => 'För $1',
	'lqt-talkpage-history-tab' => 'Kopp',
	'restriction-reply' => 'Antwoote',
	'restriction-newthread' => 'Neu {{int:lqt-history-thread}}e bejenne',
	'lqt-protected-reply-thread' => 'Do kanns nit en dämm {{int:lqt-history-thread}} schriive. Dä es jäje Veränderunge jeschöz.',
	'lqt-protected-reply-talkpage' => 'Do kanns nit en dämm {{int:lqt-history-thread}} schriive. Heh di Klaafsigg es jäje Antwoote en {{int:lqt-history-thread}}e jeschöz.',
	'lqt-protected-newthread' => 'Do kanns heh keine neue {{int:lqt-history-thread}} opmaache. Heh di Klaafsigg es jäje neu {{int:lqt-history-thread}}e jeschöz.',
	'lqt-edit-bump' => 'Jeschprääschßfäddem noh bovve',
	'lqt-edit-bump-tooltip' => 'Donn heh dä Jeschprääschßfäddem op singe Klaafsigg noh janz bovve.',
	'lqt-historicalrevision-error' => 'Do häss_en kapodde Version ußjesöhk, di mer nit aankike kann.',
	'lqt-reply-subpage' => 'Antwoot',
	'nstab-thread' => '{{int:lqt-history-thread}}',
	'nstab-summary' => 'Zosammefaßung',
);

/** Cornish (Kernowek)
 * @author Kw-Moon
 * @author Nicky.ker
 */
$messages['kw'] = array(
	'lqt_newmessages' => 'Ow messajys noweth (nagonen)',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'lqt-desc' => "Setz Diskussiouns -Rubriken  op d'Diskussiounssäiten derbäi",
	'lqt_movethread' => 'Rubrik op eng aner Säit réckelen',
	'lqt_deletethread' => 'Rubrik läschen oder restauréieren',
	'lqt_contents_title' => 'Inhalter',
	'lqt_toc_thread_title' => 'Titel vun der Rubrik',
	'lqt_toc_thread_author' => 'Ugefaang vum',
	'lqt_toc_thread_replycount' => 'Äntwerten',
	'lqt_toc_thread_modified' => "Fir d'lescht geännert",
	'lqt_add_header' => 'Iwwerschrëft derbäisetzen',
	'lqt_new_thread' => 'Eng nei Diskussioun ufänken',
	'lqt_invalid_subject' => 'De Sujet deen Dir aginn hutt ass net valabel.
Et ass méiglech, datt:
*en ze laang ass, oder
* en am Konflikt mat Interwiki-Prefixen oder Nimm vun Nummraim ass.',
	'lqt_empty_subject' => 'Dir musst e Sujet uginn.',
	'lqt_reply' => 'Äntwert',
	'lqt-parent' => 'Haapt',
	'lqt_delete' => 'Läschen',
	'lqt_undelete' => 'Restauréieren',
	'lqt_permalink' => 'Link op',
	'lqt_fragment' => 'Deel vun enger $1 vu(n) $2',
	'lqt_discussion_link' => 'Diskussioun',
	'lqt_from_talk' => 'Vum $1',
	'lqt-history-title' => 'Historique vun der Rubrik',
	'lqt_hist_comment_edited' => 'Text vun der Bemierkung [$2 geännert]',
	'lqt_hist_summary_changed' => 'Résumé geännert',
	'lqt_hist_reply_created' => '[[$1|Nei Äntwert]] ginn',
	'lqt_hist_thread_created' => 'Nei Rubrik ugeluecht',
	'lqt_hist_deleted' => 'Geläscht',
	'lqt_hist_undeleted' => 'Restauréiert',
	'lqt_hist_moved_talkpage' => 'Geréckelt',
	'lqt_hist_listing_subtitle' => 'De Versiounshistorique weisen',
	'lqt_hist_view_whole_thread' => "All d'Versioune vun der ganzer Rubrik weisen",
	'lqt_hist_no_revisions_error' => 'Dës Rubrik huet keen Historique vun de Versiounen.',
	'lqt_hist_past_last_page_error' => 'Dir sidd ausserhalb vun derZuel vu Säiten vum Historique déi et gëtt.',
	'lqt_hist_tooltip_newer_disabled' => 'Dëse Link ass ausgeschalt well dir op der éischter Säit sidd.',
	'lqt_hist_tooltip_older_disabled' => 'Dës Link ass ausgeschalt well Dir op der läschter Säit sidd',
	'lqt_hist_split' => 'Separat Äntwert an enger neier Rubrik',
	'lqt_hist_edited_subject' => 'De sujet gouf vun "$2" op "$3" geännert',
	'lqt_hist_edited_subject_corrupt' => 'Sujet geännert',
	'lqt_hist_merged_from' => '[[$1|Äntwert]] gouf an eng aner Rubrik geréckelt',
	'lqt_hist_merged_to' => '[[$1|Äntwert]] déi vun enger anerer Rubrik geréckelt gouf',
	'lqt_hist_split_from' => 'An eng nei Rubrik opdeelen',
	'lqt_hist_root_blanked' => 'Bemierkungstext ewechgeholl',
	'lqt_hist_adjusted_sortkey' => 'Positioun vun der Rubrik gouf geännnert',
	'lqt_revision_as_of' => 'Versioun vum $2 ëm $3 Auer.',
	'lqt_change_new_thread' => 'Dëst ass déi initial Versioun vun der Rubrik.',
	'lqt_change_reply_created' => 'Déi [$1 markéiert Bemierkung] gouf an dëser Versioun ugeluecht.',
	'lqt_change_edited_root' => 'Déi [$1 markéiert Bemierkung] gouf an dëser Versioun geännert.',
	'lqt_change_edited_summary' => 'De Resumé vun der Rubrik gouf geännert',
	'lqt_change_deleted' => '[$1 Dës Rubrik] oder eng Äntwert dorop gouf geläscht',
	'lqt_change_undeleted' => 'De [$1 markéierte Message] gouf restauréiert.',
	'lqt_change_moved' => '[$1 Dës Rubrik] gouf op eng aner Diskussiounssäit geréckelt',
	'lqt_change_split' => '[$1 Dës Rubrik] gouf vun enger anerer Rubrik opgedeelt',
	'lqt_change_edited_subject' => 'De Sujet vun dëser Rubrik gouf vun "$2" op "$3" geännert',
	'lqt_change_merged_from' => 'Eng [$1 Äntwert] op dës Rubrik gouf an eng aner Rubrik geréckelt',
	'lqt_change_merged_to' => 'Déi [$1 markéiert] Äntwert gouf vun enger anerer Rubrik geréckelt',
	'lqt_change_split_from' => 'Eng [$1 Ënnerrubrik] vun dëser Rubrik gouf an eng eege Rubrik ofgedeelt',
	'lqt_change_root_blanked' => 'Den Text vun [$1 enger Bemierkung] gouf ewechgeholl.',
	'lqt_youhavenewmessages' => 'Dir hutt [[$1|nei Messagen]]',
	'lqt_protectedfromreply' => 'Dës Rubrik gouf $1 vir datt net drop geäntwert ka ginn.',
	'lqt_protectedfromreply_link' => 'protegéiert',
	'lqt_subject' => 'Sujet:',
	'lqt_noreason' => 'Kee Grond uginn.',
	'lqt_move_placeholder' => "Dës Rubrik ass en Ersatz fir ze weisen datt eng Rubrik, $1, vun dëser Säit geréckelt gouf.

Dëst Réckele gouf vum $2 den $3 ëm $4 Auer gemaacht. D'Rubrik ass elo op $5 lokaliséiert.",
	'lqt_thread_deleted_for_sysops' => "Dës Rubrik gouf 'geläscht''' an ass nëmme fir Administrateuren ze gesinn.",
	'lqt_thread_deleted' => 'Dës Rubrik gouf geläscht.',
	'lqt_summary_notice' => 'Et gouf keng Ännerungen un dëser Diskussioun fir mindestens $2 {{PLURAL:$2|Dag|Deeg}}.
Wann se eriwwer ass wëllt dir vläicht $1.',
	'lqt_summary_notice_link' => 'e Résumé schreiwen',
	'lqt_summary_label' => 'Resumé vun der Rubrik:',
	'lqt_summary_subtitle' => 'Résumé vu(n) $1',
	'lqt_nosuchrevision' => 'Et gëtt déi Versioun vun deser Rubrik net.',
	'lqt_nosuchthread' => 'Déi Rubrik déi Dir uginn hutt gëtt et net.',
	'lqt_nosuchthread_title' => 'Keng esou Rubrik',
	'lqt_threadrequired' => 'Dir musst eng Rubrik an der URL uginn.',
	'lqt_move_movingthread' => '$1 gëtt geréckelt.
Dës Rubrik ghéiert zu $2.',
	'lqt_move_torename' => "Fir dës Rubrik z'änneren, $1 an ännert de 'Sujet'.",
	'lqt_move_torename_edit' => 'et änneren',
	'lqt_move_destinationtitle' => 'Titel vun der Zil-Diskussiounssäit:',
	'lqt_move_move' => 'Réckelen',
	'lqt_move_nodestination' => 'Dir musst en Zil uginn.',
	'lqt_move_thread_bad_destination' => "D'Zilsäit ass keng Diskussiounssäit.",
	'lqt_move_samedestination' => "D'Rubrik ass schonn op dëser Säit!",
	'lqt_move_noreason' => 'Kee Grond uginn',
	'lqt_move_success' => "D'Rubrik gouf op $1 geréckelt.",
	'lqt_delete_undeletethread' => 'Rubrik restauréieren',
	'lqt_delete_partof' => "Dës Rubrik ass en Deel vu(n) '''$1'''.",
	'lqt_delete_deleting' => "Läsche vun $1 an '''allen Äntwerten''' dorop.",
	'lqt_delete_deletethread' => "D'Rubrik an d'Äntwerte läschen",
	'lqt_delete_deleted' => "D'Rubrik gouf geläscht.",
	'lqt_delete_undeleted' => "D'Rubrik gouf restauréiert.",
	'lqt_delete_return' => 'Zréck op $1',
	'lqt_delete_return_link' => "d'Diskussiounssäit",
	'lqt_delete_unallowed' => 'Dir hutt net déi néideg Rechter fir Rubriken ze läschen.',
	'lqt_delete_show_checkbox' => 'Déi geläschte Rubrike weisen',
	'lqt_talkpage_autocreate_summary' => "D'Diskussiounssäit gouf automatesch ugeluecht wéi di éischt Rubrik geschéckt gouf.",
	'lqt_header_warning_big' => 'Dir ännert een/eng $1',
	'lqt_header_warning_after_big' => 'Entête si fir Ukënnegungen an Aféierungen.
Dir wëllt méiglerweis $2',
	'lqt_header_warning_bold' => 'Iwwerschrëft vun enger Diskussiounssäit',
	'lqt_header_warning_new_discussion' => 'eng nei Diskussioun ufänken.',
	'lqt_sorting_order' => 'Zortéierung:',
	'lqt_sort_newest_changes' => "Fir d'läscht geännerte fir d'éischt",
	'lqt_sort_newest_threads' => 'neiste Rubrik als éischt',
	'lqt_sort_oldest_threads' => "déi eelst Rubriken d'éischt",
	'lqt-title' => 'Titel',
	'lqt-summary' => 'Resumé',
	'lqt-searching' => 'No Rubrike sichen',
	'lqt-read-message' => 'Als geliest markéieren',
	'lqt-read-message-tooltip' => 'Dës Rubrik aus den neie Messagen ewechhuelen.
Si bleiwt op der Original-Diskussiounssäit ze gesinn.',
	'lqt-read-all' => 'All uwesien wéi wa se geliest gi wieren',
	'lqt-read-all-tooltip' => 'All Rubriken aus neie Messagen eraushuelen.
Si si weiderhinn op hirer Original-Diskussiounssäit ze gesinn.
Dës Operatioun kann net réckgängeg gemaach ginn.',
	'lqt-marked-read' => "Ribrik '''$1''' als geliest markéieren.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|Message|Messagen}} als geliest markéieren.',
	'lqt-email-undo' => 'Zréck setzen',
	'lqt-no-new-messages' => 'Et gëtt keng nei Message fir Iech.',
	'lqt-new-messages' => '✒ Dir hutt nei Messagen.',
	'lqt-email-info-undo' => 'Déi Rubrik nees weisen déi Dir elo grad ewechgeholl hutt.',
	'lqt-date-info' => 'Dëse Link ass ausgeschalt wëll Dir Rubriken vun allen Datume kuckt.',
	'lqt-newmessages-context' => 'Ganz Rubrik',
	'lqt-thread-created' => 'Ugeluecht',
	'lqt-history-time' => 'Zäit',
	'lqt-history-user' => 'Benotzer',
	'lqt-history-action' => 'Aktivitéit',
	'lqt-history-comment' => 'Bemierkung',
	'lqt-history-thread' => 'Rubrik',
	'lqt-thread-edited-author' => 'Geännert vum Auteur<br />
Lescht Ännerung: $1',
	'lqt-thread-edited-others' => 'Vum Benotzer $2 geännert<br />
Lescht Ännerung: $1',
	'lqt-header-actions' => 'Aktiounen',
	'lqt_summarize_link' => 'Resuméieren',
	'lqt-summarize-intro' => 'Resuméiert d\'Rubrik ënnendrënner an der Ännerungskëscht.
Dir kënnt jidfer Wikitext an Ärem Resumé benotzen. Wann Dir fäerdeg sidd, klickt "{{int:savearticle}}".',
	'lqt-thread-split' => 'An eng nei Rubrik opdeelen',
	'lqt-split-success' => "Dir hutt d'Rubrik $1 opgedeelt.",
	'lqt_split_thread' => 'Eng Rubrik opdeelen',
	'lqt-thread-split-subject' => 'Nei Rubrik Sujet:',
	'lqt-thread-split-thread' => 'Rubrik:',
	'lqt-split-submit' => 'Opdeelen',
	'lqt_split_badsubject' => 'The sujet deen Dir aginn hutt ass net valabel.',
	'lqt-no-threads' => 'Et get nach keng Rubriken op dëser Säit.',
	'lqt-delete-parent-warning' => 'Dëst ass eng Rubrik vum ieweschte Niveau mat den Äntwerten.
Hir Äntwerten ginn och automatesch mat geläscht.
Fir dëst ze verhënneren, trennt se vun dëser Rubrik ier Dir se läscht.',
	'lqt-delete-parent-deleted' => 'Iwwerrubrik geläscht ($1)',
	'lqt-delete-replies-done' => 'All Antwerten op dës Rubrik goufen och geläscht.',
	'lqt-movethread' => 'Réckelen',
	'lqt-menu-trigger' => 'Méi',
	'lqt-newmessages-from' => 'Vu(n) $1',
	'lqt-hot-topics' => 'Waarm Sujeten',
	'lqt-add-reply' => 'Eng Äntwert derbäisetzen',
	'lqt_rc_new_discussion' => 'huet eng nei Diskussioun, "$1" geschriwwen',
	'lqt_rc_new_reply' => 'huet eng Äntwert op "$1" geschriwwen',
	'right-lqt-split' => 'Rubriken opdeelen',
	'right-lqt-merge' => 'Rubriken zesummeleeën',
	'right-lqt-react' => "Äntwert op d'Rubriken",
	'lqt-thread-merge' => 'Mat enger anerer Rubrik zesummeleeën',
	'lqt-thread-merge-to' => 'Mat dëser Rubrik zesummeleeën',
	'lqt_merge_thread' => 'Rubrik zesummeleeën',
	'lqt-thread-merge-source' => 'Quellrubrik:',
	'lqt-thread-merge-dest' => 'Zilrubrik:',
	'lqt-merge-submit' => 'Zesummeleeën',
	'lqt-merge-success' => "Dir hutt d'Rubrik $1 mat $2 zesummegeluecht.",
	'lqt-log-name' => 'Logbuch vun den Diskussiouns-Rubriken',
	'lqt-log-header' => 'An dësem Logbuch sinn Detailer vun den Aktioune vun den Diskusssiouns-Rubriken.',
	'lqt-log-action-move' => 'huet [[$1]] vu(n) [[$2]] op [[$3]] geréckelt.',
	'lqt-log-action-split' => 'huet [[$1]] vun ënnert [[$3]] opgedeelt, mat dem neie Sujct "$2".',
	'lqt-log-action-merge-across' => 'huet [[$1]] vun ënnert [[$2]] op ënnert [[$3]] geréckelt.',
	'lqt-log-action-merge-down' => 'huet [[$1]] zesummelgeluecht op [[$3]]',
	'lqt-log-action-subjectedit' => 'huet de Sujet vu(n) [[$1]] vun "$2" op "$3" geännert',
	'lqt-log-action-resort' => 'huet de Reiefolleg vum Zortéiere vu(n) [[$1]] gännert. De Zortéierschlësel giuf vun $2 op $3 geännert.',
	'lqt-preference-notify-talk' => 'Mir eng E-Mail schécke wann op eng Rubrik geäntwert gëtt déi ech iwwerwaachen',
	'lqt-preference-watch-threads' => 'Rubriken déi ech uleeën oder an deenen ech äntwerten iwwerwaachen',
	'prefs-lqt' => 'Diskussioun mat Rubriken',
	'lqt-preference-display-depth' => 'Maximal Déift vun den Äntwerten déi gewise gëtt:',
	'lqt-preference-display-count' => 'Maximal Zuel vun Äntwerten déi gewise ginn:',
	'lqt-preference-custom-signatures' => 'Déi personaliséiert Ënnerschrëfte vun de Benotzer weisen',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-Diskussioun - Äntwert: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-Diskussioun - Nei Rubrik: $1',
	'lqt-enotif-newthread' => "Salut $1,
Dëst ass eng Notifikatioun vu(n) {{SITENAME}} datt eng nei Rubrik op $5, '$2',
den $3 ëm $4 ugeluecht gouf.

Dir kënnt se op <$6> gesinn.

Den Text ass:
$7",
	'lqt-enotif-reply' => "Salut $1,
Dëst ass eng Notifikatioun vu(n) {{SITENAME}} datt eng nei Äntwert op '$2' op $5,
den $3 ëm $4 vum $8 ugeluecht gouf.

Dir kënnt se op <$6> gesinn.

Den Text vun der Äntwert ass:
$7",
	'lqt-quote-intro' => 'De(n) $2 ëm $3 Auer, huet de(n) [[User:$1|$1]] geschriwwen:',
	'lqt-quote' => 'Zitéieren',
	'lqt-search-legend' => 'Diskussiounen zu dëser Säit sichen',
	'lqt-search-label' => 'Sichbegrëffer:',
	'lqt-search-button' => 'Sichen',
	'searchprofile-threads' => 'Diskussiounen',
	'searchprofile-threads-tooltip' => 'An den Diskussiouns-Rubriken an op den Diskussiounssäite sichen',
	'lqt-ajax-updated' => 'An dëser Rubrik gëtt et nei Messagen.',
	'lqt-ajax-update-link' => 'Aktualiséieren',
	'lqt-thread-show-replies' => 'Weis $1 Äntwerten',
	'lqt-thread-show-more' => 'Méi Äntwerte weisen',
	'lqt-thread-link-url' => 'URL vum Link:',
	'lqt-thread-link-title' => 'Wikitext-Link:',
	'lqt-thread-link-copy' => 'An den Tëschespäicher kopéieren',
	'lqt-sign-not-necessary' => "Et ass net néideg fir Är Beiträg mat véier Tilden (~) z'ënnerschreiwen.
Är Ënnerschrëft gëtt automatesch gewisen.",
	'lqt-marked-as-read-placeholder' => "D'Rubrik $1 gouf als geliest markéiert.",
	'lqt-change-subject' => 'Sujet änneren',
	'lqt-save-subject' => 'Späicheren',
	'lqt-save-subject-failed' => 'Wéi Dir de Sujet vun dëser Rubrik ännere wollt ass dëse Feeler geschitt: $1',
	'lqt-ajax-invalid-subject' => 'De Sujet deen Dir uginn hutt as ne valabel, wahrscheinlech ass en ze laang.',
	'lqt-ajax-no-subject' => 'Dir musst e Sujet fir déi nei Rubrik uginn.',
	'lqt-save-subject-error-unknown' => 'Wéi Dir de Sujet vun dëser Rubrik festleeë wollt ass en onbekannte Feeler geschitt. Versicht et w.e.g. an deems Dir op "Änneren" um ieweschte Beitrag klickt.',
	'lqt-cancel-subject-edit' => 'Ofbriechen',
	'lqt-drag-activate' => 'Op déi nei Plaz zéien',
	'lqt-drag-drop-zone' => 'Heihinner setzen',
	'lqt-drag-confirm' => 'fir déis Aktiounen ofzeschléissen, fëllt w.e.g de Grond aus a klickt op "Confirméieren".',
	'lqt-drag-reparent' => 'De Message op en aneren Niveau réckelen',
	'lqt-drag-split' => 'De Message a seng eege Rubrik réckelen',
	'lqt-drag-setsortkey' => "D'Positioun vum Message op der Säit änneren",
	'lqt-drag-bump' => "De Message uewen op d'Diskussiounssäit réckelen",
	'lqt-drag-save' => 'Confirméieren',
	'lqt-drag-title' => 'Réckele confirméieren',
	'lqt-drag-reason' => 'Grond:',
	'lqt-drag-subject' => 'Sujet fir déi nei Rubrik (obligatoresch):',
	'lqt-edit-signature' => '(Ënnerschrëft änneren)',
	'lqt-preview-signature' => '(kucken ouni ze späicheren)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nei Messagen',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nei Message vum $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nei Rubriken',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nei Rubrike vum $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Äntwerten',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Äntwerte vum $1',
	'lqt-feed-new-thread-intro' => 'Nei Rubrik iwwer $1 geschriwwe vum $2',
	'lqt-feed-reply-intro' => 'Äntwert vum $2 op $3 (op $1)',
	'tooltip-pt-newmessages' => 'Weist nei Noriichten a Rubriken oder op Diskussiounssäiten déi Dir iwwerwaacht',
	'lqt-newmessages-n' => 'Nei Messagen ($1)',
	'lqt_newmessages' => 'Meng nei Messagen (Keen)',
	'lqt_newmessages-title' => 'Nei Messagen',
	'lqt-newpost-summary' => 'Nei Rubrik: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Gitt w.e.g. den Text fir dës Rubrik an. Duerno sollt Dir dann dës Linn läschen.',
	'lqt-reply-summary' => 'Äntwert op [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Versioune vun der Diskussiounssäit',
	'lqt-talkpage-history-subtitle' => 'Fir $1',
	'lqt-talkpage-history-tab' => 'Iwwerschrëft',
	'restriction-reply' => 'Äntwerte schreiwen',
	'restriction-newthread' => 'Nei Rubriken opmaachen',
	'lqt-protected-reply-thread' => 'Dir kënnt näischt an dës Rubrik schreiwe well se fir all nei Message gespaart ass.',
	'lqt-protected-reply-talkpage' => 'Dir kënnt näischt an dës Rubrik schreiwen well dës Diskussiounssäit fir Äntwerten an hir rubrike gespaart ass.',
	'lqt-protected-newthread' => 'Dir kënnt keng nei Rubriken op dëser Diskusiounssäit opmaache well se fir nei Rubrike gespaart ass.',
	'lqt-edit-bump' => 'Dës Rubrik reaktivéieren',
	'lqt-edit-bump-tooltip' => 'Dës Rubrik uewen op hir Diskusiounssäit réckelen',
	'lqt-historicalrevision-error' => 'Déi Versioun déi Dir erausgesicht hutt ass futti a kann net gewise ginn.',
	'lqt-reply-subpage' => 'äntwerten',
	'nstab-thread' => 'Rubrik',
	'nstab-summary' => 'Resumé',
);

/** Ganda (Luganda)
 * @author Kizito
 */
$messages['lg'] = array(
	'lqt_youhavenewmessages' => 'Ofunyeyo [[$1|obubaka bupya]]',
	'lqt_move_move' => 'Simbuliza',
	'lqt-no-new-messages' => 'Tewali bubaka bupya',
	'lqt-new-messages' => '✒ Ofunyeyo obubaka bupya.',
	'lqt-movethread' => 'Simbuliza',
	'lqt-newmessages-n' => 'Obubaka ($1)',
	'lqt_newmessages' => 'Obubaka (Tewali bupya)',
	'lqt_newmessages-title' => 'Obubaka',
);

/** Limburgish (Limburgs)
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'lqt-desc' => 'Voog euverlègk in ongerwerpe op euverlikpazjenas toe',
	'lqt_movethread' => 'Verplaats ongerwerp nao anger paasj',
	'lqt_deletethread' => 'Wis of plaats ongerwerp truk',
	'lqt_contents_title' => 'Inhaad',
	'lqt_toc_thread_title' => 'Ongerwerp',
	'lqt_toc_thread_author' => 'Begos door',
	'lqt_toc_thread_replycount' => 'Antjweurd',
	'lqt_toc_thread_modified' => 'Lèste angering',
	'lqt_add_header' => 'Voog kop toe',
	'lqt_new_thread' => 'Begin nuuj ongerwerp',
	'lqt_invalid_subject' => "Ongerwerp is óngeldig:
* 't is mesjiens te lank
* of 't conflicteert mit interwikiveurvoogsele of naamruumdje.",
	'lqt_empty_subject' => "Doe mos 'm pngerwerp ingaeve",
	'lqt_reply' => 'Antjwaorje',
	'lqt-parent' => 'Beaveligkendj berich',
	'lqt_delete' => 'Sjaf eweg',
	'lqt_undelete' => 'Plaats trök',
	'lqt_permalink' => 'Link nao',
	'lqt_fragment' => "Fragment van 'ne $1 van $2",
	'lqt_discussion_link' => 'euverlègk',
	'lqt_from_talk' => 'Ven $1',
	'lqt-history-title' => 'Ongerwerpgesjiedenès',
	'lqt_hist_comment_edited' => 'Opmerking [$2 bewerk]',
	'lqt_hist_summary_changed' => 'Samevatting aangepas',
	'lqt_hist_reply_created' => '[[$1|Nuuj antjwaord]] gegaeve',
	'lqt_hist_thread_created' => 'Nuuj ongerwerp gemaak',
	'lqt_hist_deleted' => 'Gewösj',
	'lqt_hist_undeleted' => 'Trögkgezadj',
	'lqt_hist_moved_talkpage' => 'Verplaats',
	'lqt_hist_listing_subtitle' => 'Euverlègkhistoire bekiekendj',
	'lqt_hist_view_whole_thread' => 'Bekiek ongerwerpshistorie',
	'lqt_hist_no_revisions_error' => 'Dit ongerwerp haet gein ajer versies.',
	'lqt_hist_past_last_page_error' => "Doe höbs 'n hoger paginanummer gekaoze es besteit in de gesjiedenis.",
	'lqt_hist_tooltip_newer_disabled' => 'Dees verwiezing is neet actief omdet se op de ierste pagina bös.',
	'lqt_hist_tooltip_older_disabled' => 'Dees verwiezing is neet actief omdet se op de letste pagina bös.',
	'lqt_hist_split' => 'Splits antjwaord nao e nuuj onherwerp aaf',
	'lqt_hist_edited_subject' => 'Ongerwerp gewiezig van "$2" nao "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Veranger ongerwerp',
	'lqt_hist_merged_from' => "'t [[$1|Antjwaord]] is verplaats nao 'n anger ongerwerp",
	'lqt_hist_merged_to' => "'t [[$1|Antjwaord]] is verplaats vanoet 'n anger ongerwerp",
	'lqt_hist_split_from' => 'Splits nao e nuuj ongerwerp aaf',
	'lqt_hist_root_blanked' => 'Teks van opmerking verwiederd',
	'lqt_hist_adjusted_sortkey' => 'Pas plaats ongerwerp aan',
	'lqt_revision_as_of' => 'Versie op $2 óm $3.',
	'lqt_change_new_thread' => 'Dit is de ierste versie van t ongerwerp.',
	'lqt_change_reply_created' => 'De [$1 gemarkeerde opmerking] is in dees versie toegevoeg.',
	'lqt_change_edited_root' => 'De [$1 gemarkeerde opmerking] is in dees versie bewerk.',
	'lqt_change_edited_summary' => "De samevatting van 't ongerwerp is bewerk",
	'lqt_change_deleted' => '[$1 Dit ongerwerp] of e baoveligkend ongerwerp is verwiederd',
	'lqt_change_undeleted' => "'t [$1 Oetgelich berich] is trökgeplaats naodet 't waas verwiederd",
	'lqt_change_moved' => "[$1 Dit ongerwerp] is verplaats vanaaf 'n anger euverlègkpagina",
	'lqt_change_split' => "[$1 Dit ongerwerp] is aafgesplits oet 'n anger ongerwerp",
	'lqt_change_edited_subject' => '\'t Ongerwerp is gewiezig van "$2" nao "$3"',
	'lqt_change_merged_from' => "'n [$1 Antjwaord] in dit ongerwerp is verplaats oet 'n anger ongerwerp",
	'lqt_change_merged_to' => "'t [$1 Oetgelich antjwaord] is hiehaer verplaats vanoet 'n anger ongerwerp",
	'lqt_change_split_from' => 'E [$1 subongerwerp] van dit ongerwerp is aafgesplits in zien eigen ongerwerp',
	'lqt_change_root_blanked' => "De teks van 'n [$1 opmerking] is verwiederd.",
	'lqt_youhavenewmessages' => 'Doe haes [[$1|nuuj berichter]].',
	'lqt_protectedfromreply' => 'Dit óngerwerp is $1 van te waere beantjwoordj.',
	'lqt_protectedfromreply_link' => 'besjörmp',
	'lqt_subject' => 'Óngerwerp:',
	'lqt_noreason' => 'Geine ree opgegaeve.',
	'lqt_move_placeholder' => "Dit is 'n markering die aangeuf det 'n ongerwerp $1 verplaats is van dees pagina nao 'n anger euverlègkpagina ($5).
Dees verplaatsing is oetgeveurd door $2 óp $3 $4.",
	'lqt_thread_deleted_for_sysops' => "Dit ongerwerp is '''gewös''' en is allein zichbaar veur beheirders.",
	'lqt_thread_deleted' => 'Ongerwerp is gewös.',
	'lqt_summary_notice' => "d'r Zeen gein wieziginge gewaes in de aafgeloupe {{PLURAL:$2|daag|$2 daag}}.
Es 't euverlik is aafgerondj, weurs se aangemodig óm $1.",
	'lqt_summary_notice_link' => "sjrief 'n samevatting",
	'lqt_summary_label' => 'Óngerwerp samevatting:',
	'lqt_summary_subtitle' => 'Samevatting van "$1"',
	'lqt_nosuchrevision' => 'Dees óngerwerpsversie besteit neet.',
	'lqt_nosuchthread' => "'t Aangegaeve ógerwerp besteit neet.",
	'lqt_nosuchthread_title' => 'Dit óngerwerp besteit neet',
	'lqt_threadrequired' => "Doe mós 'nen ongerwerpspaasj opgaeve inne URL.",
	'lqt_move_movingthread' => '$1 verplaatsend.
Dit óngerwerp is e deil van $2.',
	'lqt_move_torename' => 'Óm dit óngerwèrp te herneume, $1 en bewirk \'t veldj "Ongerwirp".',
	'lqt_move_torename_edit' => "bewèrk 't",
	'lqt_move_destinationtitle' => 'Bestömmingseuverlègkpaasj:',
	'lqt_move_move' => 'Verplaats',
	'lqt_move_nodestination' => 'Doe mós de bestömming ópgaeve.',
	'lqt_move_thread_bad_destination' => 'De doelpaasj is gein euverlèkpaasj.',
	'lqt_move_samedestination' => "'d Óngerwèrp steit al op dees paasj!",
	'lqt_move_noreason' => 'Gein reje ópgegaeve.',
	'lqt_move_success' => "'t Óngerwerp is verplaats nao $1.",
	'lqt_delete_undeletethread' => 'Plaats óngerwèrp trök',
	'lqt_delete_partof' => "Dit óngerwerp is e deil van '''$1'''.",
	'lqt_delete_deleting' => "'''$1''' en '''alle antjwäörd''' ewegsjaffendje.",
	'lqt_delete_deletethread' => 'Wis ongerwerp.',
	'lqt_delete_deleted' => 'Ongerwerp is gewis.',
	'lqt_delete_undeleted' => 'Ongerwerp is trukgeplaats.',
	'lqt_delete_return' => 'Trögk nao $1.',
	'lqt_delete_return_link' => 'de euverlègkpaasj',
	'lqt_delete_unallowed' => 'De moogs gein ongerwerp wisse.',
	'lqt_delete_show_checkbox' => 'Tuin eweggesjafde óngerwerpe',
	'lqt_talkpage_autocreate_summary' => "Euverlègksziej venzich aangemaak bie g'm aanmake dès ieës óngerwèrps.",
	'lqt_header_warning_big' => 'Doe bewirks $1.',
	'lqt_header_warning_after_big' => 'Köp zeen veur aankonjiginge en inleidinge. Waalleech kèns se baeter $2 gebroeke.',
	'lqt_header_warning_bold' => "inleiding van 'n euverlègkpagina",
	'lqt_header_warning_new_discussion' => 'begin e nuuj euverlègk',
	'lqt_sorting_order' => 'Sorteervolgorde:',
	'lqt_sort_newest_changes' => 'les gewiezig baovenaan',
	'lqt_sort_newest_threads' => 'nuujs ongerwerpe baovenaan',
	'lqt_sort_oldest_threads' => 'aads ongerwerpe baovenaan',
	'lqt-title' => 'Titel',
	'lqt-summary' => 'Samevatting',
	'lqt-searching' => 'Nao ongerwerp zeukendje',
	'lqt-read-message' => 'Markeer es gelaeze',
	'lqt-read-message-tooltip' => "Wös dit óngerwerpe oete nuuj berichte. 't Óngerwerp is nag ömmer zichbaar óppe oearsprónkelike euverlèkpagina.",
	'lqt-read-all' => 'Markeer alles es gelaeze',
	'lqt-read-all-tooltip' => "Wös alle óngerwerpe oete nuuj berichter.
't Óngerwerp is nag ömmer zichbaar oppe oearsprónkelike euverligkpagina.
Dees hanjeling kins se neet trökdreie.",
	'lqt-marked-read' => '\'t Óngerwerp "$1" steit es gelaeze.',
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|berich steit|berichter staont}} es gelaeze.',
	'lqt-email-undo' => 'Maak óngedaon',
	'lqt-no-new-messages' => 'Doe haes gein nuuj berichter.',
	'lqt-new-messages' => '✒ Doe haes nuuj berichter.',
	'lqt-email-info-undo' => "Trök nao 't óngerwerp det se zezjuus verlaoten haes.",
	'lqt-date-info' => 'Dees verwiezing is neet actief ómdet se óngerwèrpe van alle datums bekieks.',
	'lqt-newmessages-context' => 'Gans óngerwèrp',
	'lqt-thread-created' => 'Aangenmaak',
	'lqt-history-time' => 'Tied',
	'lqt-history-user' => 'Gebroeker',
	'lqt-history-action' => 'Activiteit',
	'lqt-history-comment' => 'Opmirking',
	'lqt-history-thread' => 'Óngerwèrp',
	'lqt-thread-edited-author' => 'Bewirk door auteur<br />
Letste bewirking: $1',
	'lqt-thread-edited-others' => "Bewerk door {{PLURAL:$2|'nen angere gebroeker|$2 anger gebroekers}}.<br />
Letste bewerking: $1",
	'lqt-header-actions' => 'Henjeling',
	'lqt_summarize_link' => 'Vat same',
	'lqt-summarize-intro' => 'Vat \'t óngerwerp hieónger same.
De maags wikiteks gebroeken in dien samevatting.
Klik óp "{{int:savearticle}}" wen se klaor bös.',
	'lqt-thread-split' => 'Splits nao e nuuj ongerwerp aaf',
	'lqt-split-success' => "Doe haes 't nuu óngerwèrp $1 aangemaak.",
	'lqt_split_thread' => 'Splits ongerwerpe',
	'lqt-thread-split-subject' => 'Kop nuuj ongerwerp:',
	'lqt-thread-split-thread' => 'Euverlègk:',
	'lqt-split-submit' => 'Spliet',
	'lqt_split_badsubject' => 'Ingegaeve óngerwerp is óngeljig.',
	'lqt-no-threads' => 'Nag gein óngerwerpe óp dees pagina.',
	'lqt-delete-parent-warning' => "Dit is 'n euverlègk op 't hoeagste niveau in 'nen boumstructuur mit antjwäörd.
De antjwäörd waeren ouch automatisch gewösj.
Splits dit euverlègk veur 't wösjen óm dit te verkómme.",
	'lqt-delete-parent-deleted' => 'Baoveligkendj euverlègk gewösj ($1)',
	'lqt-delete-replies-done' => 'Alle antjwäörd in dit euverlègk zeen ouch gewösj.',
	'lqt-movethread' => 'Verplaats',
	'lqt-menu-trigger' => 'Mieë',
	'lqt-newmessages-from' => 'Ven $1',
	'lqt-hot-topics' => 'Populair ongerwerpe',
	'lqt-add-reply' => 'Antjwaorde',
	'lqt_rc_new_discussion' => 'haet e nuuj ongerwerp "$1" geplaats',
	'lqt_rc_new_reply' => 'haet \'n antjwaord op "$1" geplaats',
	'right-lqt-split' => 'Splits ongerwerpe',
	'right-lqt-merge' => 'Voog ongerwerpe same',
	'lqt-thread-merge' => "Voog aan 'n anger ongerwerp toe",
	'lqt-thread-merge-to' => 'Voog in dit ongerwerp',
	'lqt_merge_thread' => 'Voog ongerwerp same',
	'lqt-thread-merge-source' => 'Bronongerwerp:',
	'lqt-thread-merge-dest' => 'Doelongerwerp:',
	'lqt-merge-submit' => 'Voog zaam',
	'lqt-merge-success' => "'t Óngerwèrp $1 is samegevoog ónger $2.",
	'lqt-log-name' => 'Óngerwerpelogbook',
	'lqt-log-header' => 'Dit logbook haet informatie euver hanjelinge mit óngerwerpe.',
	'lqt-log-action-move' => 'haet [[$1]] verplaats van [[$2]] nao [[$3]].',
	'lqt-log-action-split' => 'haet [[$1]] aafgesplits van [[$3]] mit "$2" es nuuj óngerwerp.',
	'lqt-log-action-merge-across' => 'haet [[$1]] verplaats oet [[$2]] nao [[$3]].',
	'lqt-log-action-merge-down' => 'haet [[$1]] samegevoog nao [[$3]].',
	'lqt-log-action-subjectedit' => 'haet \'t óngerwerp veur [[$1]] van "$2" nao "$3" verangerdj',
	'lqt-log-action-resort' => 'haet de sorteervolgorde veur [[$1]] van $2 nao $3 verangerdj',
	'lqt-preference-notify-talk' => "E-mail mich wen d'r antjwäörd zeen bie 'n óngerwerp det ich volg",
	'lqt-preference-watch-threads' => "Volg óngerwerpe die ich aanmake of woróp ich 'n antjwaord gaef",
	'prefs-lqt' => 'Gestructureerd euverlik',
	'lqt-preference-display-depth' => 'Maximaak aan te gaeve deepdje:',
	'lqt-preference-display-count' => 'Maximaal aan te gaeve antjwäörd:',
	'lqt-preference-custom-signatures' => 'Tuin aangepasde gebroekershandjteikeninge',
	'lqt-enotif-subject-reply' => 'Euverligk óp {{SITENAME}} - Antjwaord: $1',
	'lqt-enotif-subject-newthread' => 'Euverlègk óp {{SITENAME}} - Nuuj euverlègk: $1',
	'lqt-enotif-newthread' => "Haj $1,

Dit is 'n kinnisgaeving van {{SITENAME}}. d'r Is e nuuj óngerwerp '$2' óp $5 geplaats gewaoren óp $3 óm $4.

Doe kins 't bekieke: <$6>.",
	'lqt-enotif-reply' => 'Haj $1,

Dit is \'n kinnisgaeving van {{SITENAME}}. d\'r Is e nuuj antjwaord óp "$2" óp $5 gekómmen óp $3 óm $4.

Doe kins \'t bekieke: <$6>.

Hieónger steit \'t:
$7',
	'lqt-quote-intro' => '[[User:$1|$1]] sjreef óm $3 óp $2:',
	'lqt-quote' => 'Citeer',
	'lqt-search-legend' => 'Zeuk óp euverlègk óp dees paasj',
	'lqt-search-label' => 'Zeukterme:',
	'lqt-search-button' => 'Zeuk',
	'searchprofile-threads' => 'Euverlègk',
	'searchprofile-threads-tooltip' => 'Zeuk euverlègk èn -paazjes',
	'lqt-ajax-updated' => "d'r Zeen nuuj berichter.",
	'lqt-ajax-update-link' => 'Wèrk bie',
	'lqt-thread-show-replies' => 'Toean $1 {{PLURAL:$1|reactie|reacties}}',
	'lqt-thread-show-more' => 'Toean mieë reacties',
	'lqt-thread-link-url' => 'URL:',
	'lqt-thread-link-title' => 'Wikitekslink:',
	'lqt-thread-link-copy' => "Kopieër nao 't klembórd",
	'lqt-sign-not-necessary' => 'Ónherteiken die berich neet mit veer krönkelkes.
Dien handjteikening kömp zoea al venzelf.',
	'lqt-marked-as-read-placeholder' => '\'d Óngerwèrp "$1" markeerdj zich es gelaeze.',
	'lqt-change-subject' => 'Anger óngerwèrp',
	'lqt-save-subject' => 'Slaon óp',
	'lqt-save-subject-failed' => "Bie 't óngerwèrp angere is 'n fout ópgetraoje: $1",
	'lqt-ajax-invalid-subject' => "Ingegaeve óngerwerp is óngeljig, wersjienlik is 't te lank.",
	'lqt-ajax-no-subject' => "Doe mós 'n óngerwerp ópgaeve.",
	'lqt-save-subject-error-unknown' => "Onbekinde fout bie 't instelle van 't ongerwerp.
Wiezig 't ongerwerp door op \"Bewirk\" te klikke in t baoveste berich.",
	'lqt-cancel-subject-edit' => 'Braek aaf',
	'lqt-drag-activate' => 'Sleip nao nuuj plaats',
	'lqt-drag-drop-zone' => 'Plaats hie',
	'lqt-drag-confirm' => 'Óm \'t volgende te doon mós se \'n reje inveuren en op "Bevestig" klikke.',
	'lqt-drag-reparent' => "Bring brich ónger 'n anger óngerwerp.",
	'lqt-drag-split' => 'Plaats berich in eige ongerwerp.',
	'lqt-drag-setsortkey' => 'Pas berichpositie oppe pagina aan',
	'lqt-drag-bump' => 'Plaats baovenaan de euverlègkpagina',
	'lqt-drag-save' => 'Bevèstig',
	'lqt-drag-title' => 'Bevèstig sleip',
	'lqt-drag-reason' => 'Raeje:',
	'lqt-drag-subject' => 'Nuuj óngerwèrp:',
	'lqt-edit-signature' => '(bewèrk handjteikening)',
	'lqt-preview-signature' => '(betrachting)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nuuj berichte',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nuuj berichte van $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nuuj ongerwerpe',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nuuj ongerwerpe van $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Reacties',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Reacties van $1',
	'lqt-feed-new-thread-intro' => 'Nuuj ongerwerp op $1 door $2',
	'lqt-feed-reply-intro' => 'Reactie op $3 (op $1) door $2',
	'lqt-newmessages-n' => 'Nuuj berichter ($1)',
	'lqt_newmessages' => 'nuuj berichte',
	'lqt_newmessages-title' => 'nuuj berichte',
	'lqt-newpost-summary' => 'Nuuj ongerwerp: $1',
	'lqt-reply-summary' => 'Reactie op [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Gesjiedenis van de euverlègkpagina',
	'lqt-talkpage-history-subtitle' => 'Veur $1',
	'lqt-talkpage-history-tab' => 'Kópteks',
	'restriction-reply' => 'Antjwaord',
	'restriction-newthread' => 'Maak nuuj ongerwerp',
	'lqt-protected-reply-thread' => "Doe kins neet deilnömme aan dit ongerwerp went 't is toe.",
	'lqt-protected-reply-talkpage' => 'Doe kins hie neet aan middoon, went de ongerwerpe hie zeen geslaote.',
	'lqt-protected-newthread' => 'Doe kins gein nuuj ongerwerpe aanmake op dees pagina, went dees is gesalote daoveur.',
	'lqt-edit-bump' => 'Activeer euverlègk',
	'lqt-edit-bump-tooltip' => "Activeer dit euverlègk door 't baovenaan de pagina te plaatse",
	'lqt-historicalrevision-error' => 'Geselcteerde versie is besjajig en ónbekiekbaar.',
	'lqt-reply-subpage' => 'antjwaord',
);

/** Lumbaart (Lumbaart)
 * @author Dakrismeno
 */
$messages['lmo'] = array(
	'lqt-no-new-messages' => "Te gh'heet mía de messagg növ.",
	'lqt_newmessages' => 'Messagg növ',
);

/** Lozi (Silozi)
 * @author Ooswesthoesbes
 */
$messages['loz'] = array(
	'lqt_revision_as_of' => 'Selt di $1.',
	'lqt_youhavenewmessages' => 'A sa $1.',
	'lqt_protectedfromreply_link' => 'sa bukelezi',
	'lqt_newmessages' => 'Nca Mulumiwa',
);

/** Lithuanian (Lietuvių)
 * @author Pėstininkas
 * @author Tomasdd
 * @author Vpovilaitis
 */
$messages['lt'] = array(
	'lqt-desc' => 'Pridėti diskusijų temas į aptarimų puslapius',
	'lqt_movethread' => 'Perkelti temą į kitą puslapį',
	'lqt_deletethread' => 'Ištrinti arba atstatyti temą',
	'lqt_contents_title' => 'Turinys',
	'lqt_toc_thread_title' => 'Temos antraštė',
	'lqt_toc_thread_author' => 'Pradėjo',
	'lqt_toc_thread_replycount' => 'Atsakymai',
	'lqt_toc_thread_modified' => 'Paskutinis pakeitimas',
	'lqt_add_header' => 'Pridėti antraštę',
	'lqt_new_thread' => 'Pradėti naują diskusiją',
	'lqt_delete' => 'Ištrinti',
	'lqt-no-new-messages' => 'Jūs negavote naujų žinučių.',
	'lqt_newmessages' => 'Naujos žinutės',
);

/** Latgalian (Latgaļu)
 * @author Dark Eagle
 */
$messages['ltg'] = array(
	'lqt_protectedfromreply_link' => 'aizsorguota',
	'lqt-ajax-update-link' => 'Atjaunynuot',
);

/** Latvian (Latviešu)
 * @author GreenZeb
 * @author Papuass
 */
$messages['lv'] = array(
	'lqt_contents_title' => 'Saturs',
	'lqt_toc_thread_title' => 'Tēmas nosaukums',
	'lqt_toc_thread_replycount' => 'Atbildes',
	'lqt_subject' => 'Temats:',
	'lqt_delete_show_checkbox' => 'Rādīt dzēstās tēmas',
	'lqt-search-button' => 'Meklēt',
	'lqt-save-subject' => 'Saglabāt',
	'lqt-cancel-subject-edit' => 'Atcelt',
);

/** Malagasy (Malagasy)
 * @author Jagwar
 */
$messages['mg'] = array(
	'lqt_move_move' => 'Hanolo anarana',
	'lqt-movethread' => 'Hanolo anarana',
	'right-lqt-split' => 'Mizara ny resaka',
);

/** Eastern Mari (Олык Марий)
 * @author Сай
 */
$messages['mhr'] = array(
	'lqt_contents_title' => 'Вуйлымаш',
	'lqt_delete' => 'Шӧраш',
	'lqt_protectedfromreply_link' => 'тӧрлаташ чарыме',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'lqt-desc' => 'Додава нанижани разговори на страници за разговор',
	'lqt_movethread' => 'Премести ја нишката на друга страница',
	'lqt_deletethread' => 'Избриши или врати нишка',
	'lqt_contents_title' => 'Содржина',
	'lqt_toc_thread_title' => 'Наслов на нишката',
	'lqt_toc_thread_author' => 'Започнал',
	'lqt_toc_thread_replycount' => 'Одговори',
	'lqt_toc_thread_modified' => 'Последна промена',
	'lqt_add_header' => 'Додај наслов',
	'lqt_new_thread' => 'Започни нов разговор',
	'lqt_invalid_subject' => 'Насловот кој го внесовте е неважечки.
Можни причини:
* Предолга е, или
* Се коси со интервики префикси или називи на именски простори.',
	'lqt_empty_subject' => 'Мора да внесете наслов.',
	'lqt_reply' => 'Одговори',
	'lqt-parent' => 'Матична',
	'lqt_delete' => 'Избриши',
	'lqt_undelete' => 'Врати',
	'lqt_permalink' => 'Врска до поракава',
	'lqt_fragment' => 'Фрагмент од $1 од $2',
	'lqt_discussion_link' => 'разговор',
	'lqt_from_talk' => 'Од $1',
	'lqt-history-title' => 'Историја на нишката',
	'lqt_hist_comment_edited' => 'Текстот на коментарот е [$2 уреден]',
	'lqt_hist_summary_changed' => 'Описот е променет',
	'lqt_hist_reply_created' => 'Создаден е [[$1|нов одговор]]',
	'lqt_hist_thread_created' => 'Создадена е нова нишка',
	'lqt_hist_deleted' => 'Избришано',
	'lqt_hist_undeleted' => 'Вратено',
	'lqt_hist_moved_talkpage' => 'Преместена',
	'lqt_hist_listing_subtitle' => 'Преглед на историја',
	'lqt_hist_view_whole_thread' => 'Погледајте историја за целата нишка',
	'lqt_hist_no_revisions_error' => 'Оваа нишка нема ревизии во историјата',
	'lqt_hist_past_last_page_error' => 'Го преминавте бројот на страници кои постојат во историјата.',
	'lqt_hist_tooltip_newer_disabled' => 'Оваа врска е оневозможена бидејќи се наоѓате на првата страница.',
	'lqt_hist_tooltip_older_disabled' => 'Оваа врска е оневозможена бидејќи се наоѓате на последната страница.',
	'lqt_hist_split' => 'Одговорот е разделен во нова нишка',
	'lqt_hist_edited_subject' => 'Промени го насловот од „$2“ на „$3“',
	'lqt_hist_edited_subject_corrupt' => 'Променет наслов',
	'lqt_hist_merged_from' => '[[$1|Одговорот]] е преместен на друга нишка',
	'lqt_hist_merged_to' => '[[$1|Одговорот]] е преместен од друга нишка',
	'lqt_hist_split_from' => 'Раздели во нова нишка',
	'lqt_hist_root_blanked' => 'Текстот од коментарот е избришан',
	'lqt_hist_adjusted_sortkey' => 'Прилагодена положбата на нишката',
	'lqt_revision_as_of' => 'Ревизија од $2 во $3 ч.',
	'lqt_change_new_thread' => 'Ова е првичната ревизија на нишката',
	'lqt_change_reply_created' => '[$1 Одбележаниот коментар] беше создаден во оваа ревизија.',
	'lqt_change_edited_root' => '[$1 Одбележаниот коментар] беше уреден во оваа ревизија.',
	'lqt_change_edited_summary' => 'Описот на нишката беше уреден',
	'lqt_change_deleted' => '[$1 Оваа нишка] или нејзината матична нишка беше избришана',
	'lqt_change_undeleted' => '[$1 Означената порака] беше повратена',
	'lqt_change_moved' => '[$1 Оваа нишка] е преместена на друга страница за разговор',
	'lqt_change_split' => '[$1 Оваа нишка] беше одделена од друга нишка',
	'lqt_change_edited_subject' => 'Насловот на оваа нишка е променет од „$2“ на „$3“',
	'lqt_change_merged_from' => '[$1 Одговор] на оваа нишка беше преместен од друга нишка',
	'lqt_change_merged_to' => '[$1 Одбележаниот одговор] беше преместен од друга нишка',
	'lqt_change_split_from' => '[$1 Поднишка] на оваа нишка беше одделена во сопствена нишка',
	'lqt_change_root_blanked' => 'Текстот на [$1 коментарот] е отстранет.',
	'lqt_youhavenewmessages' => 'Имате [[$1|нови пораки]].',
	'lqt_protectedfromreply' => 'Оваа нишка беше $1 од одговори на неа.',
	'lqt_protectedfromreply_link' => 'заштитена',
	'lqt_subject' => 'Тема:',
	'lqt_noreason' => 'Нема наведено причина.',
	'lqt_move_placeholder' => 'Оваа нишка е показател кој означува дека нишката $1 била преместена од оваа страница.
Преместувањето го извршил корисникот $2 на $3 во $4 ч. Нишката сега се наоѓа на $5.',
	'lqt_thread_deleted_for_sysops' => "Оваа нишка е '''избришана''' и е видлива само за администратори.",
	'lqt_thread_deleted' => 'Оваа ниншка била избришана.',
	'lqt_summary_notice' => 'Овој разговор не е изменет барем $2 {{PLURAL:$2|ден|дена}}.
Ако е завршен, препорачуваме да $1.',
	'lqt_summary_notice_link' => 'внесете опис',
	'lqt_summary_label' => 'Опис на нишката:',
	'lqt_summary_subtitle' => 'Опис на „$1“',
	'lqt_nosuchrevision' => 'Нема таква ревизија на оваа нишка.',
	'lqt_nosuchthread' => 'Назначената нишка не постои.',
	'lqt_nosuchthread_title' => 'Нема таква нишка',
	'lqt_threadrequired' => 'Морате да наведете нишка во URL-адресата.',
	'lqt_move_movingthread' => 'Преместување на $1.
Оваа нишка е дел од $2.',
	'lqt_move_torename' => 'За да ја преименувате нишкава,  $1 и сменете го полето „Наслов“.',
	'lqt_move_torename_edit' => 'уредете ја',
	'lqt_move_destinationtitle' => 'Наслов на целната страна за разговор:',
	'lqt_move_move' => 'Премести',
	'lqt_move_nodestination' => 'Мора да наведете целна страница.',
	'lqt_move_thread_bad_destination' => 'Целната страница не е страница за разговор.',
	'lqt_move_samedestination' => 'Нишката веќе е на оваа страница!',
	'lqt_move_noreason' => 'Нема наведено причина.',
	'lqt_move_success' => 'Нишката е преместена на $1.',
	'lqt_delete_undeletethread' => 'Врати ја нишката',
	'lqt_delete_partof' => "Оваа нишка е дел од '''$1'''.",
	'lqt_delete_deleting' => "Бришење на '''$1''' и '''сите одговори''' на неа.",
	'lqt_delete_deletethread' => 'Избриши нишка и одговори',
	'lqt_delete_deleted' => 'Нишката е избришана.',
	'lqt_delete_undeleted' => 'Нишката е вратена.',
	'lqt_delete_return' => 'Назад на $1.',
	'lqt_delete_return_link' => 'страницата за разговор',
	'lqt_delete_unallowed' => 'Не ви е дозволено да бришете нишки.',
	'lqt_delete_show_checkbox' => 'Прикажи избришани нишки',
	'lqt_talkpage_autocreate_summary' => 'Страницата за разговор е автоматски создадена при поставувањето на првата нишка.',
	'lqt_header_warning_big' => 'Уредувате $1.',
	'lqt_header_warning_after_big' => 'Насловите се за известувања и воведи.
Наместо ова, можете да $2.',
	'lqt_header_warning_bold' => 'наслов на страницата за разговор',
	'lqt_header_warning_new_discussion' => 'започнете нов разговор',
	'lqt_sorting_order' => 'Редослед на подредување:',
	'lqt_sort_newest_changes' => 'прво најскоро променети',
	'lqt_sort_newest_threads' => 'прво најнови нишки',
	'lqt_sort_oldest_threads' => 'прво најстари нишки',
	'lqt-title' => 'Наслов',
	'lqt-summary' => 'Опис',
	'lqt-searching' => 'Пребарување на нишки',
	'lqt-read-message' => 'Означи како прочитано',
	'lqt-read-message-tooltip' => 'Отстрани ја оваа нишка од новите пораки.
Сепак ќе биде видлива на изворната страница за разговор',
	'lqt-read-all' => 'Означи ги сите како прочитани',
	'lqt-read-all-tooltip' => 'Острани ги сите нишки од новите пораки.
Тие сепак ќе бидат видливи на нивните изворни страници за разговор.
Оваа операција е неповратна.',
	'lqt-marked-read' => "Нишката '''$1'''  е означена како причитана.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|порака означена како прочитана|пораки означени како прочитани}}.',
	'lqt-email-undo' => 'Врати',
	'lqt-no-new-messages' => 'Немате нови пораки.',
	'lqt-new-messages' => '✒ Имате нови пораки.',
	'lqt-email-info-undo' => 'Врати ја штотуку отфрлената нишка.',
	'lqt-date-info' => 'Оваа врска е оневозможена бидејќи прегледувате нишки од сите датуми.',
	'lqt-newmessages-context' => 'Цела нишка',
	'lqt-thread-created' => 'Создадено',
	'lqt-history-time' => 'Време',
	'lqt-history-user' => 'Корисник',
	'lqt-history-action' => 'Активност',
	'lqt-history-comment' => 'Коментар',
	'lqt-history-thread' => 'Нишка',
	'lqt-thread-edited-author' => 'Уредено од авторот<br />
Последно уредување: $1',
	'lqt-thread-edited-others' => 'Уредено од $2 корисници<br />
Последно уредување: $1',
	'lqt-header-actions' => 'Дејства',
	'lqt_summarize_link' => 'Краток опис',
	'lqt-summarize-intro' => 'Подолу накратко опишете ја долунаведената нишка во квадратот за уредување.
Во описот можете да користите било каков викитекст. Кога сте готови, кликнете на „{{int:savearticle}}“.',
	'lqt-thread-split' => 'Одвој во нова нишка',
	'lqt-split-success' => 'Успешно ја одвоивте нишката $1.',
	'lqt_split_thread' => 'Раздели нишка',
	'lqt-thread-split-subject' => 'Наслов на новата нишка:',
	'lqt-thread-split-thread' => 'Нишка:',
	'lqt-split-submit' => 'Раздели',
	'lqt_split_badsubject' => 'Внесениот наслов е неважечки.',
	'lqt-no-threads' => 'Сè уште нема низи на оваа страница.',
	'lqt-delete-parent-warning' => 'Ова е првостепена нишка со одговори.
Нејзините одговори исто така ќе бидат избришени автоматски.
За да го избегнете ова, разделете ги од оваа нишка пред да се избрише.',
	'lqt-delete-parent-deleted' => 'Матичната нишка е избришана ($1)',
	'lqt-delete-replies-done' => 'Сите одговори на оваа нишка се исто така избришани.',
	'lqt-movethread' => 'Премести',
	'lqt-menu-trigger' => 'Повеќе',
	'lqt-newmessages-from' => 'Од $1',
	'lqt-hot-topics' => 'Актуелни теми',
	'lqt-add-reply' => 'Додај одговор',
	'lqt_rc_new_discussion' => 'објави нова нишка, „$1“',
	'lqt_rc_new_reply' => 'одговори на „$1“',
	'right-lqt-split' => 'Раздели нишки',
	'right-lqt-merge' => 'Спојување нишки',
	'right-lqt-react' => 'Одговарање на нишки',
	'lqt-thread-merge' => 'Спој со друга нишка',
	'lqt-thread-merge-to' => 'Спои во оваа нишка',
	'lqt_merge_thread' => 'Спои ја нишката',
	'lqt-thread-merge-source' => 'Изворна нишка:',
	'lqt-thread-merge-dest' => 'Целна нишка:',
	'lqt-merge-submit' => 'Спои',
	'lqt-merge-success' => 'Успешно ја споивте нишката $1 со нишката $2.',
	'lqt-log-name' => 'Дневник на нанижани разговори',
	'lqt-log-header' => 'Во овој дневник се запишуваат дејствата направени во разговорните нишки.',
	'lqt-log-action-move' => '[[$1]] е преместен од [[$2]] на [[$3]].',
	'lqt-log-action-split' => 'раздвоена [[$1]] од под [[$3]], со нов наслов „$2“.',
	'lqt-log-action-merge-across' => 'преместена [[$1]] од под [[$2]]. Сега е под [[$3]].',
	'lqt-log-action-merge-down' => '[[$1]] ставена (споена) под [[$3]]',
	'lqt-log-action-subjectedit' => 'изменет насловот на [[$1]] од „$2“ на „$3“',
	'lqt-log-action-resort' => 'изменет редоследот на подредување на [[$1]]. Клучот за подредување изменет од $2 на $3.',
	'lqt-preference-notify-talk' => 'Испрати ми е-пошта кога некој ќе одговори на нишка што ја набљудувам',
	'lqt-preference-watch-threads' => 'Набљудувај ги нишките кои ги создавам или на кои одговарам',
	'prefs-lqt' => 'Нанижан разговор',
	'lqt-preference-display-depth' => 'Максимална длабочина на одговорите за прикажување:',
	'lqt-preference-display-count' => 'Максималнен број на одговори за прикажување:',
	'lqt-preference-custom-signatures' => 'Прикажувај прилагодени кориснички потписи',
	'lqt-enotif-subject-reply' => '{{SITENAME}} разговор - Одговор: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} разговор - Нова нишка: $1',
	'lqt-enotif-newthread' => '
Здраво $1,

ова е известување од {{SITENAME}} дека на страницата $5 на $3 во $4 ч. е создадена нова нишка „$2“,
од страна на корисникот $8

Можете да ја погледате на <$6>

Текстот гласи:
$7',
	'lqt-enotif-reply' => 'Здраво $1,

ова е известување од {{SITENAME}} дека на страницата $5 на $3 во $4 ч. 
е објавен одговор на „$2“ од страна на корисникот $8

Можете да го погледате на <$6>
Текстот на одговорот гласи:
$7',
	'lqt-quote-intro' => 'На $2 во $3, [[User:$1|$1]] напиша:',
	'lqt-quote' => 'Цитирај',
	'lqt-search-legend' => 'Пребарување разговори на страницава',
	'lqt-search-label' => 'Услови за пребарување:',
	'lqt-search-button' => 'Пребарај',
	'searchprofile-threads' => 'Разговори',
	'searchprofile-threads-tooltip' => 'Пребарување на нанижани разговори и страници за разговор',
	'lqt-ajax-updated' => 'Оваа нишка има нови пораки.',
	'lqt-ajax-update-link' => 'Поднови',
	'lqt-thread-show-replies' => 'Прикажи $1 одговори',
	'lqt-thread-show-more' => 'Прикажи повеќе одговори',
	'lqt-thread-link-url' => 'Врска за URL адресата:',
	'lqt-thread-link-title' => 'Викитекст-врска:',
	'lqt-thread-link-copy' => 'Копирај на оставата за копии',
	'lqt-sign-not-necessary' => 'Нема потреба да се потпишувате со четири тилди.
Потписот ќе се прикаже автоматски.',
	'lqt-marked-as-read-placeholder' => 'Нишката $1 е обележана како прочитана.',
	'lqt-change-subject' => 'Смени го насловот',
	'lqt-save-subject' => 'Зачувај',
	'lqt-save-subject-failed' => 'Во обидот за менување на насловот на оваа нишка настана следнава грешка: $1',
	'lqt-ajax-invalid-subject' => 'Насловот кој го назначивте е неважечки, веројатно бидејќи е предолг.',
	'lqt-ajax-no-subject' => 'Мора да наведете наслов на новата нишка.',
	'lqt-save-subject-error-unknown' => 'Се појави непозната грешка при обидот за поставување на наслов за оваа нишка. Обидете се да го направите ова со кликнување на „уреди“ на најгорната порака.',
	'lqt-cancel-subject-edit' => 'Откажи',
	'lqt-drag-activate' => 'Довлечи на ново место',
	'lqt-drag-drop-zone' => 'Пуштете овде',
	'lqt-drag-confirm' => 'За да ги извршите следните дејства, наведете причина и кликнете на „Потврди“.',
	'lqt-drag-reparent' => 'Ставија ја пораката под нова матична нишка.',
	'lqt-drag-split' => 'Премести ја пораката во своја нишка',
	'lqt-drag-setsortkey' => 'Прилагодување на положбата на пораката во страницата',
	'lqt-drag-bump' => 'Качи ја пораката најгоре на страницата',
	'lqt-drag-save' => 'Потврди',
	'lqt-drag-title' => 'Потврди повлекување',
	'lqt-drag-reason' => 'Причина:',
	'lqt-drag-subject' => 'Наслов на новата нишка (задолжително):',
	'lqt-edit-signature' => '(уреди потпис)',
	'lqt-preview-signature' => '(преглед)',
	'lqt-feed-title-all' => '{{SITENAME}} — Нови пораки',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Нови пораки од $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Нови нишки',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Нови нишки од $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Одговори',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Одговори од $1',
	'lqt-feed-new-thread-intro' => 'Нова нишка на $1, поставена од $2',
	'lqt-feed-reply-intro' => 'Одговор на $3 (за $1), поставен од $2',
	'tooltip-pt-newmessages' => 'Ги прикажува новообјавените пораки во нишки или нанижани страници за разговор што ги набљудувате',
	'lqt-newmessages-n' => 'Нови пораки ($1)',
	'lqt_newmessages' => 'Мои нови пораки (нема)',
	'lqt_newmessages-title' => 'Нови пораки.',
	'lqt-newpost-summary' => 'Нова нишка: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Внесете го саканиот текст за ова нишка. Потоа избришете го редов.',
	'lqt-reply-summary' => 'Одговор за [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Историја на страницата за разговор',
	'lqt-talkpage-history-subtitle' => 'За $1',
	'lqt-talkpage-history-tab' => 'Наслов',
	'restriction-reply' => 'Испрати одговори',
	'restriction-newthread' => 'Испрати нови нишки',
	'lqt-protected-reply-thread' => 'Не можете да ја испратите оваа нишка бидејќи е заштитена од нови пораки.',
	'lqt-protected-reply-talkpage' => 'Не можете да ја испратите оваа нишка бидејќи оваа страница за разговор е заштитена од одговори на нејзините нишки.',
	'lqt-protected-newthread' => 'Не можете да испраќате нови нишки на оваа страница за разговор бидејќи таа е заштитена од нови нишки.',
	'lqt-edit-bump' => 'Постави ја нишката на врвот од страницата',
	'lqt-edit-bump-tooltip' => 'Премести ја нишкава на врвот од нејзината страницата за разговор',
	'lqt-historicalrevision-error' => 'Ревизијата која ја одбравте има грешки, и не може да се прегледа.',
	'lqt-reply-subpage' => 'одговори',
	'nstab-thread' => 'Нишка',
	'nstab-summary' => 'Опис',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'lqt-desc' => 'ചരടിൽ കോർത്തപോലുള്ള ചർച്ചകൾ സംവാദംതാളുകളിൽ തുടങ്ങുക',
	'lqt_movethread' => 'ചരട് മറ്റൊരു താളിലേക്കു മാറ്റുക',
	'lqt_deletethread' => 'ചരട് മായ്ക്കുക അല്ലെങ്കിൽ പുനഃസ്ഥാപിക്കുക',
	'lqt_contents_title' => 'ഉള്ളടക്കം',
	'lqt_toc_thread_title' => 'ചരടിന്റെ തലക്കെട്ട്',
	'lqt_toc_thread_author' => 'തുടക്കമിട്ടത്',
	'lqt_toc_thread_replycount' => 'മറുപടികൾ',
	'lqt_toc_thread_modified' => 'ഒടുവിലെ പുതുക്കൽ',
	'lqt_add_header' => 'തലക്കുറി ചേർക്കുക',
	'lqt_new_thread' => 'പുതിയൊരു സം‌വാദം ആരംഭിക്കുക',
	'lqt_invalid_subject' => 'താങ്കൾ നൽകിയ വിഷയം അസാധുവാണ്.
അത്:
*വളരെ നീളമുള്ളതാണ്, അല്ലെങ്കിൽ
*അന്തർവിക്കി പൂർവ്വപദങ്ങളുമായോ നാമമേഖലകളുടെ പേരുകളുമായോ ആശയക്കുഴപ്പം സൃഷ്ടിക്കുന്നതാണ്.',
	'lqt_empty_subject' => 'താങ്കൾ ഒരു വിഷയം നൽകിയിരിക്കണം.',
	'lqt_reply' => 'മറുപടി',
	'lqt-parent' => 'താവഴി',
	'lqt_delete' => 'മായ്ക്കുക',
	'lqt_undelete' => 'പുനഃസ്ഥാപിക്കുക',
	'lqt_permalink' => 'സ്ഥിരംകണ്ണി',
	'lqt_fragment' => '$2 താളിൽ നിന്നുള്ള ഭാഗിക $1',
	'lqt_discussion_link' => 'സം‌വാദം',
	'lqt_from_talk' => '$1 എന്ന സംവാദം താളിൽ നിന്ന്',
	'lqt-history-title' => 'ചരടിന്റെ നാൾവഴി',
	'lqt_hist_comment_edited' => 'കുറിപ്പിന്റെ എഴുത്ത് [$2 തിരുത്തി]',
	'lqt_hist_summary_changed' => 'ചുരുക്കം മാറ്റി',
	'lqt_hist_reply_created' => '[[$1|പുതിയ മറുപടി]] നൽകിയിരിക്കുന്നു',
	'lqt_hist_thread_created' => 'പുതിയ ചരട് സൃഷ്ടിച്ചിരിക്കുന്നു',
	'lqt_hist_deleted' => 'മായ്ച്ചു',
	'lqt_hist_undeleted' => 'മായ്ച്ചതു പുനഃസ്ഥാപിച്ചു',
	'lqt_hist_moved_talkpage' => 'തലക്കെട്ട് മാറ്റി',
	'lqt_hist_listing_subtitle' => 'നാൾവഴി പട്ടിക കാണുന്നു',
	'lqt_hist_view_whole_thread' => 'ചരടിന്റെ പൂർണ്ണരൂപത്തിന്റെ നാൾവഴി കാണുക',
	'lqt_hist_no_revisions_error' => 'ഈ ചരടിന് പഴയ നാൾപ്പതിപ്പുകൾ ഇല്ല.',
	'lqt_hist_past_last_page_error' => 'താളുകളുടെ നിലനിൽക്കുന്ന ചരിത്രത്തിനപ്പുറമാണ് താങ്കൾ.',
	'lqt_hist_tooltip_newer_disabled' => 'താങ്കൾ ആദ്യത്തെ താളിലായതിനാൽ ഈ കണ്ണി നിർവീര്യമാക്കി.',
	'lqt_hist_tooltip_older_disabled' => 'താങ്കൾ അവസാനത്തെ താളിലായതിനാൽ ഈ കണ്ണി നിർവീര്യമാക്കി.',
	'lqt_hist_split' => 'പുതിയൊരു ചരടായി വിഘടിപ്പിച്ച് മറുപടി നൽകുക',
	'lqt_hist_edited_subject' => 'വിഷയം "$2" എന്നതിൽ നിന്ന് "$3" എന്നാക്കി മാറ്റി',
	'lqt_hist_edited_subject_corrupt' => 'വിഷയം മാറ്റിയിരിക്കുന്നു',
	'lqt_hist_merged_from' => '[[$1|മറുപടി]] മറ്റൊരു ചരടിലേയ്ക്ക് മാറ്റിയിരിക്കുന്നു',
	'lqt_hist_merged_to' => '[[$1|മറുപടി]] മറ്റൊരു ചരടിൽ നിന്ന് മാറ്റിയിരിക്കുന്നു',
	'lqt_hist_split_from' => 'പുതിയൊരു ചരടായി വിഘടിപ്പിക്കുക',
	'lqt_hist_root_blanked' => 'കുറിപ്പായി ഇട്ട എഴുത്ത് നീക്കം ചെയ്തു',
	'lqt_hist_adjusted_sortkey' => 'ചരടിന്റെ സ്ഥാനം ക്രമീകരിക്കുക',
	'lqt_revision_as_of' => '$2 തീയതിയിൽ $3 സമയത്തുണ്ടായിരുന്ന പതിപ്പ്.',
	'lqt_change_new_thread' => 'ചരടിന്റെ ആദ്യ നാൾപ്പതിപ്പാണിത്.',
	'lqt_change_reply_created' => '[$1 അടയാളപ്പെടുത്തി കാണിച്ചിരിക്കുന്ന അഭിപ്രായം] ഈ പതിപ്പിൽ ചേർക്കപ്പെട്ടതാണ്‌.',
	'lqt_change_edited_root' => '[$1 അടയാളപ്പെടുത്തി കാണിച്ചിരിക്കുന്ന അഭിപ്രായം] ഈ പതിപ്പിൽ തിരുത്തപ്പെട്ടിട്ടുണ്ട്.',
	'lqt_change_edited_summary' => 'ചരടിന്റെ ചുരുക്കം തിരുത്തപ്പെട്ടിരിക്കുന്നു',
	'lqt_change_deleted' => '[$1 ഈ ചരടോ] അതിന്റെ മാതൃ ചരടോ മായ്ക്കപ്പെട്ടിരിക്കുന്നു',
	'lqt_change_undeleted' => '[$1 പ്രമുഖമാക്കിക്കൊടുത്തിരിക്കുന്ന പ്രസിദ്ധപ്പെടുത്തൽ] മായ്ക്കലിൽ നിന്നും പുനസ്ഥാപിക്കപ്പെട്ടിരിക്കുന്നു',
	'lqt_change_moved' => '[$1 ഈ ചരട്] മറ്റൊരു സംവാദം താളിലേയ്ക്ക് മാറ്റപ്പെട്ടിരിക്കുന്നു',
	'lqt_change_split' => '[$1 ഈ ചരട്] മറ്റൊരു ചരടിൽ നിന്നും വിഘടിപ്പിച്ചതാണ്',
	'lqt_change_edited_subject' => 'ഈ ചരടിന്റെ വിഷയം "$2" എന്നതിൽ നിന്ന് "$3" എന്നാക്കി മാറ്റിയിരിക്കുന്നു',
	'lqt_change_merged_from' => 'ഈ ചരടിനുള്ള [$1 മറുപടി] മറ്റൊരു ചരടിലേയ്ക്ക് മാറ്റിയിരിക്കുന്നു',
	'lqt_change_merged_to' => '[$1 പ്രമുഖമാക്കിക്കാട്ടിയിരിക്കുന്ന മറുപടി] മറ്റൊരു ചരടിൽ നിന്നും മാറ്റിയതാണ്.',
	'lqt_change_split_from' => 'ഈ ചരടിന്റെ [$1 ഒരു ഉപചരട്] ഒരു സ്വതന്ത്ര ചരടായി വിഘടിപ്പിച്ചിരിക്കുന്നു',
	'lqt_change_root_blanked' => '[$1 ഒരു കുറിപ്പിലെ] എഴുത്ത് നീക്കം ചെയ്തിരിക്കുന്നു.',
	'lqt_youhavenewmessages' => 'താങ്കൾക്ക് [[$1|പുതിയ സന്ദേശങ്ങൾ]] ഉണ്ട്.',
	'lqt_protectedfromreply' => 'ഈ ചരട് മറുപടി നൽകുന്നതിൽ നിന്നും $1.',
	'lqt_protectedfromreply_link' => 'സം‌രക്ഷിക്കപ്പെട്ടിരിക്കുന്നു',
	'lqt_subject' => 'വിഷയം:',
	'lqt_noreason' => 'കാരണമൊന്നും സൂചിപ്പിച്ചിട്ടില്ല',
	'lqt_move_placeholder' => '$1 എന്ന ചരട് ഈ താളിൽ നിന്നും മാറ്റിയിരിക്കുന്നു എന്നു കാണിക്കാനുള്ള മാർഗ്ഗം മാത്രമാണ് ഈ ചരട്.
ഈമാറ്റം $3-യിൽ $4-ന് $2 ആണ് ചെയ്തത്.
ചരട് ഇപ്പോൾ $5-ൽ സ്ഥിതി ചെയ്യുന്നു.',
	'lqt_thread_deleted_for_sysops' => "ഈ ചരട് '''മായ്ച്ചിരിക്കുന്നു''', സിസോപ്പുകൾക്ക് മാത്രമേ ഇതു ദൃശ്യമാവൂ.",
	'lqt_thread_deleted' => 'ഈ ചരട് ഒഴിവാക്കി.',
	'lqt_summary_notice' => 'ഈ ചർച്ചയിൽ കഴിഞ്ഞ {{PLURAL:$2|ദിവസം|$2 ദിവസങ്ങളിൽ}} യാതൊരു മാറ്റവും ഉണ്ടായിട്ടില്ല.
അത് പരിസമാപ്തിയിലെത്തിയെങ്കിൽ, താങ്കൾക്ക് $1 ഉപയോഗിക്കാവുന്നതാണ്.',
	'lqt_summary_notice_link' => 'ചുരുക്കം എഴുതുക',
	'lqt_summary_label' => 'ചരടിന്റെ ചുരുക്കം:',
	'lqt_summary_subtitle' => '"$1" എന്നതിന്റെ ചുരുക്കം.',
	'lqt_nosuchrevision' => 'ഈ ചരടിനു അങ്ങനെയൊരു പതിപ്പില്ല.',
	'lqt_nosuchthread' => 'താങ്കൾ ആവശ്യപ്പെട്ട ചരട് നിലവിലില്ല.',
	'lqt_nosuchthread_title' => 'അങ്ങനെ ചരടില്ല',
	'lqt_threadrequired' => 'URL-ൽ ഒരു ചരട് ചേർത്തിരിക്കണം',
	'lqt_move_movingthread' => '$1 മാറ്റുന്നു.
ഈ ചരട് $2 എന്നതിന്റെ ഭാഗമാണ്‌.',
	'lqt_move_torename' => "ഈ ചരട് പുനർനാമകരണം ചെയ്യാൻ, $1 എന്ന കണ്ണി ഞെക്കിയ ശേഷം 'വിഷയം' മാറ്റുക",
	'lqt_move_torename_edit' => 'തിരുത്തുക',
	'lqt_move_destinationtitle' => 'ലക്ഷ്യ സം‌വാദം താളിന്റെ തലക്കെട്ട്:',
	'lqt_move_move' => 'തലക്കെട്ടു്‌ മാറ്റുക',
	'lqt_move_nodestination' => 'ഒരു ലക്ഷ്യം നിർബന്ധമായും ചേർത്തിരിക്കണം.',
	'lqt_move_thread_bad_destination' => 'ലക്ഷ്യം വെച്ച താൾ സംവാദം താൾ അല്ല.',
	'lqt_move_samedestination' => 'ചരട് ഈ താളിലുണ്ട്!',
	'lqt_move_noreason' => 'കാരണമൊന്നും സൂചിപ്പിച്ചിട്ടില്ല',
	'lqt_move_success' => 'ചരട് $1 എന്നതിലേയ്ക്ക് മാറ്റി.',
	'lqt_delete_undeletethread' => 'മായ്ക്കപ്പെട്ട ചരട് പുനഃസ്ഥാപിക്കുക',
	'lqt_delete_partof' => "ഈ ചരട് '''$1''' എന്നതിന്റെ ഭാഗമാണ്.",
	'lqt_delete_deleting' => "'''$1''' കൂടെ അതിനുള്ള '''എല്ലാ മറുപടികളും''' മായ്ക്കുന്നു.",
	'lqt_delete_deletethread' => 'ചരടും മറുപടികളും മായ്ക്കുക',
	'lqt_delete_deleted' => 'ചരട് മായ്ക്കപ്പെട്ടിരിക്കുന്നു.',
	'lqt_delete_undeleted' => 'ഈ ചരട് പുനഃസ്ഥാപിക്കപ്പെട്ടില്ല.',
	'lqt_delete_return' => '$1 എന്ന താളിലേക്ക് തിരിച്ചുപോവുക.',
	'lqt_delete_return_link' => 'സം‌വാദം താൾ',
	'lqt_delete_unallowed' => 'ചരടുകൾ മായ്ക്കാൻ താങ്കൾക്ക് അനുമതിയില്ല.',
	'lqt_delete_show_checkbox' => 'മായ്ക്കപ്പെട്ട ചരടുകൾ പ്രദർശിപ്പിക്കുക',
	'lqt_talkpage_autocreate_summary' => 'ആദ്യ ചരട് പ്രസിദ്ധീകരിക്കുമ്പോൾ സംവാദം താൾ സ്വയം സൃഷ്ടിക്കപ്പെടുന്നതാണ്.',
	'lqt_header_warning_big' => 'താങ്കൾ തിരുത്തി കൊണ്ടിരിക്കുന്നത് ഒരു $1 ആണ്‌.',
	'lqt_header_warning_after_big' => 'തലക്കുറിപ്പുകൾ അറിയിപ്പുകൾക്കും ആമുഖങ്ങൾക്കുമുള്ളതാണ്.
താങ്കൾക്ക് $2 ആയിരിക്കാം ആവശ്യം.',
	'lqt_header_warning_bold' => 'സംവാദം താളിന്റെ തലക്കെട്ട്',
	'lqt_header_warning_new_discussion' => 'പുതിയൊരു സം‌വാദം ആരംഭിക്കുക',
	'lqt_sorting_order' => 'ക്രമപ്പെടുത്തൽ രീതി:',
	'lqt_sort_newest_changes' => 'അവസാനം തിരുത്തിയത് ആദ്യം പ്രദർശിപ്പിക്കുക',
	'lqt_sort_newest_threads' => 'ആദ്യം ഏറ്റവും പുതിയ ചരടുകൾ',
	'lqt_sort_oldest_threads' => 'ആദ്യം ഏറ്റവും പഴയ ചരടുകൾ',
	'lqt-title' => 'തലക്കെട്ട്',
	'lqt-summary' => 'ചുരുക്കം',
	'lqt-searching' => 'ചരടുകൾക്കായി തിരയുന്നു',
	'lqt-read-message' => 'വായിച്ചതായി അടയാളപ്പെടുത്തുക',
	'lqt-read-message-tooltip' => 'ഈ ചരട് പുതിയ സന്ദേശങ്ങളിൽ നിന്നും നീക്കുക.
യഥാർത്ഥ സംവാദംതാളിൽ അത് പ്രത്യക്ഷമായിരിക്കും.',
	'lqt-read-all' => 'എല്ലാം വായിച്ചതായി അടയാളപ്പെടുത്തുക',
	'lqt-read-all-tooltip' => 'പുതിയ സന്ദേശങ്ങളിൽ നിന്നും എല്ലാ ചരടുകളും നീക്കുക.
അവ അവയുടെ യഥാർത്ഥ സംവാദംതാളിൽ പ്രത്യക്ഷമായിരിക്കും.
ഒരിക്കൽ ചെയ്താൽ പിന്നെ ഈ പ്രവൃത്തി പുനഃസ്ഥാപിക്കാനാവില്ല.',
	'lqt-marked-read' => "'''$1''' എന്ന ചരട് വായിച്ചതായി അടയാളപ്പെടുത്തി.",
	'lqt-count-marked-read' => '{{PLURAL:$1|ഒരു സന്ദേശം|$1 സന്ദേശങ്ങൾ}} വായിച്ചതായി അടയാളപ്പെടുത്തി.',
	'lqt-email-undo' => 'പ്രവൃത്തി തിരസ്കരിക്കുക',
	'lqt-no-new-messages' => 'താങ്കൾക്ക് പുതിയ സന്ദേശങ്ങളൊന്നുമില്ല.',
	'lqt-new-messages' => '✒ താങ്കൾക്ക് പുതിയ സന്ദേശങ്ങൾ ഉണ്ട്',
	'lqt-email-info-undo' => 'താങ്കൾ പുറംതള്ളിയ ചരട് തിരിച്ചു കൊണ്ടുവരിക.',
	'lqt-date-info' => 'എല്ലാ തീയതികളിലുമുള്ള ചരടുകൾ താങ്കൾ കാണുന്നതിനാൽ ഈ കണ്ണി നിർജ്ജീവമാക്കിയിരിക്കുന്നു.',
	'lqt-newmessages-context' => 'പൂർണ്ണരൂപം',
	'lqt-thread-created' => 'സൃഷ്ടിച്ചിരിക്കുന്നു',
	'lqt-history-time' => 'സമയം',
	'lqt-history-user' => 'ഉപയോക്താവ്',
	'lqt-history-action' => 'പ്രവൃത്തി',
	'lqt-history-comment' => 'കുറിപ്പ്',
	'lqt-history-thread' => 'ചരട്',
	'lqt-thread-edited-author' => 'മാറ്റം വരുത്തിയത് രചയിതാവ് ആണ്.<br />
അവസാന തിരുത്തൽ: $1',
	'lqt-thread-edited-others' => '{{PLURAL:$2|മറ്റൊരുപയോക്താവ്|മറ്റ് $2 ഉപയോക്താക്കൾ}} തിരുത്തിയിരിക്കുന്നു.<br />
അവസാന തിരുത്തൽ: $1',
	'lqt-header-actions' => 'പ്രവർത്തനങ്ങൾ',
	'lqt_summarize_link' => 'ചുരുക്കിയെഴുതുക',
	'lqt-summarize-intro' => 'ചരടിനു താഴെ തിരുത്തുവാനുള്ള പെട്ടിയിൽ ദയവായി ചുരുക്കരൂപം നൽകുക.
താങ്കൾ നൽകുന്ന ചുരുക്കത്തിൽ വിക്കിഎഴുത്തുകൾ ഉപയോഗിക്കാവുന്നതാണ്.
പൂർണ്ണമായാൽ, "{{int:savearticle}}" ഞെക്കുക.',
	'lqt-thread-split' => 'പുതിയൊരു ചരടായി വിഘടിപ്പിക്കുക',
	'lqt-split-success' => 'താങ്കൾ വിജയകരമായി $1 എന്ന ചരട് വിഘടിപ്പിച്ചിരിക്കുന്നു.',
	'lqt_split_thread' => 'ചരട് വിഘടിപ്പിക്കുക',
	'lqt-thread-split-subject' => 'പുതിയ ചരടിന്റെ വിഷയം:',
	'lqt-thread-split-thread' => 'ചരട്:',
	'lqt-split-submit' => 'വിഘടിപ്പിക്കുക',
	'lqt_split_badsubject' => 'താങ്കൾ ചേർത്ത വിഷയം അസാധുവാണ്.',
	'lqt-no-threads' => 'ഈ താളിൽ ഇതുവരെ ചരടുകൾ ഒന്നുമില്ല.',
	'lqt-delete-parent-warning' => 'ഇത് മറുപടികളോടു കൂടിയ ഉന്നതതല ചരടാണ്.
ഇതിനുള്ള മറുപടികൾ സ്വയം മായ്ക്കപ്പെടുന്നതാണ്.
ഇതൊഴിവാക്കാൻ, മായ്ക്കുന്നതിനു മുമ്പ് അവയെ ഈ ചരടിൽ നിന്നും വിഘടിപ്പിക്കുക.',
	'lqt-delete-parent-deleted' => 'താവഴി ചരട് മായ്ച്ചു ($1)',
	'lqt-delete-replies-done' => 'ഈ ചരടിലേയ്ക്കുള്ള എല്ലാ മറുപടികളും ഒപ്പം മായ്ക്കപ്പെട്ടിരിക്കുന്നു.',
	'lqt-movethread' => 'മാറ്റുക',
	'lqt-menu-trigger' => 'കൂടുതൽ',
	'lqt-newmessages-from' => 'സന്ദേശമിട്ട താൾ: $1',
	'lqt-hot-topics' => 'ചൂടുപിടിച്ച വിഷയങ്ങൾ',
	'lqt-add-reply' => 'മറുപടി നൽകുക',
	'lqt_rc_new_discussion' => 'പുതിയ ചരട് പ്രസിദ്ധപ്പെടുത്തിയിരിക്കുന്നു, "$1"',
	'lqt_rc_new_reply' => '"$1" എന്നതിനു മറുപടി നൽകിയിരിക്കുന്നു.',
	'right-lqt-split' => 'ചരടുകൾ വിഘടിപ്പിക്കുക',
	'right-lqt-merge' => 'ചരടുകൾ സംയോജിപ്പിക്കുക',
	'right-lqt-react' => 'ചരടുകൾക്ക് മറുപടി നൽകൽ',
	'lqt-thread-merge' => 'മറ്റൊരു ചരടിലേയ്ക്ക് സംയോജിപ്പിക്കുക',
	'lqt-thread-merge-to' => 'ഈ ചരടിലേയ്ക്ക് സംയോജിപ്പിക്കുക',
	'lqt_merge_thread' => 'ചരട് സംയോജിപ്പിക്കുക',
	'lqt-thread-merge-source' => 'സ്രോതസ്സ് ചരട്:',
	'lqt-thread-merge-dest' => 'ലക്ഷ്യ ചരട്:',
	'lqt-merge-submit' => 'ലയിപ്പിക്കുക',
	'lqt-merge-success' => 'താങ്കൾ $1 എന്ന ചരട് താഴെ കിടക്കുന്ന $2 എന്ന ചരടുമായി വിജയകരമായി സംയോജിപ്പിച്ചിരിക്കുന്നു.',
	'lqt-log-name' => 'ചരടിൽ കോർത്തപോലുള്ള സംവാദങ്ങളുടെ രേഖ',
	'lqt-log-header' => 'സംവാദങ്ങളുടെ ചരടുകളിൽ വരുത്തിയ മാറ്റങ്ങളുടെ വിവരങ്ങൾ ഈ രേഖയിൽ കാണാം.',
	'lqt-log-action-move' => '[[$1]]- [[$2]] എന്നതിൽ നിന്നു  [[$3]] എന്നതിലേയ്ക്കു മാറ്റിയിരിക്കുന്നു.',
	'lqt-log-action-split' => '[[$3]] എന്നതിൽ നിന്നും [[$1]] "$2" എന്ന തലക്കെട്ടിലുള്ള വിഘടനം.',
	'lqt-log-action-merge-across' => '[[$2]] എന്നതിൽ നിന്നും  [[$3]] എന്നതിനു കീഴിലേയ്ക്ക് [[$1]] മാറ്റിയിരിക്കുന്നു.',
	'lqt-log-action-merge-down' => '[[$3]] എന്നതിനു കീഴിലേയ്ക്ക് [[$1]] ലയിപ്പിച്ചിരിക്കുന്നു',
	'lqt-log-action-subjectedit' => '[[$1]] എന്നതിന്റെ വിഷയം "$2" എന്നതിൽ നിന്നും "$3" എന്നാക്കി മാറ്റിയിരിക്കുന്നു.',
	'lqt-log-action-resort' => '[[$1]] പ്രത്യക്ഷപ്പെടുന്ന ക്രമം വ്യത്യാസപ്പെടുത്തിയിരിക്കുന്നു. ക്രമപ്പെടുത്തൽ ചാവി $2 എന്നതിൽ നിന്ന് $3 എന്നാക്കി മാറ്റിയിരിക്കുന്നു.',
	'lqt-preference-notify-talk' => 'ഞാൻ ശ്രദ്ധിക്കുന്ന ചരടുകൾക്ക് മറുപടികളുണ്ടായാൽ ഇമെയിൽ അയയ്ക്കുക',
	'lqt-preference-watch-threads' => 'ഞാൻ സൃഷ്ടിച്ചതോ മറുപടി നൽകിയതോ ആയ ചരടുകൾ ശ്രദ്ധിക്കുന്നവയുടെ കൂട്ടത്തിൽ ചേർക്കുക',
	'prefs-lqt' => 'ചരടിൽ കോർത്ത സംവാദം',
	'lqt-preference-display-depth' => 'മറുപടി പ്രദർശിപ്പിക്കേണ്ട പരമാവധി ആഴം:',
	'lqt-preference-display-count' => 'പ്രദർശിപ്പിക്കേണ്ട മറുപടികളുടെ പരമാവധി എണ്ണം:',
	'lqt-preference-custom-signatures' => 'മാറ്റിയെടുത്ത ഉപയോക്തൃ ഒപ്പുകൾ കാട്ടുക',
	'lqt-enotif-subject-reply' => '{{SITENAME}} സംവാദം - മറുപടി: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} സംവാദം - പുതിയ ചരട്: $1',
	'lqt-enotif-newthread' => "പ്രിയ $1,

$5 താളിൽ, '$2' എന്നൊരു ചരട് $4, $3-യിൽ $8 എന്ന ഉപയോക്താവ് സൃഷ്ടിച്ചിരിക്കുന്നു എന്നറിയിക്കാൻ, {{SITENAME}} സംരംഭത്തിൽ നിന്നും അയയ്ക്കുന്ന അറിയിപ്പാണ് ഇത്.

താങ്കൾക്ക് അത് <$6> എന്ന കണ്ണിയിൽ കാണാവുന്നതാണ്.

എഴുത്ത്:
$7",
	'lqt-enotif-reply' => "പ്രിയ $1,

$5 താളിലെ '$2' എന്നതിനു പുതിയൊരു മറുപടി $4 $3-യിൽ $8 എന്ന ഉപയോക്താവ് ഇട്ടിരിക്കുന്നു എന്നറിയിക്കാൻ {{SITENAME}} അയയ്ക്കുന്ന അറിയിപ്പാണിത്.

താങ്കൾക്ക് അത് <$6> എന്ന കണ്ണിയിൽ കാണാം.

മറുപടിയെഴുത്ത്: $7",
	'lqt-quote-intro' => '$2 $3-ൽ [[User:$1|$1]] എഴുതി:',
	'lqt-quote' => 'ഉദ്ധരണി',
	'lqt-search-legend' => 'ഈ താളിലെ സംവാദങ്ങൾ തിരയുക',
	'lqt-search-label' => 'പദങ്ങൾ തിരയുക:',
	'lqt-search-button' => 'തിരയുക',
	'searchprofile-threads' => 'സം‌‌വാദങ്ങൾ',
	'searchprofile-threads-tooltip' => 'സംവാദം താളുകളും ചരടിൽ കോർത്തപോലുള്ള ചർച്ചകളും തിരയുക',
	'lqt-ajax-updated' => 'ഈ ചരടിൽ പുതിയ പ്രസിദ്ധപ്പെടുത്തലുകൾ ഉണ്ട്.',
	'lqt-ajax-update-link' => 'പുതുക്കുക',
	'lqt-thread-show-replies' => '$1 മറുപടികൾ പ്രദർശിപ്പിക്കുക',
	'lqt-thread-show-more' => 'കൂടുതൽ മറുപടികൾ പ്രദർശിപ്പിക്കുക',
	'lqt-thread-link-url' => 'കണ്ണിയുടെ യു.ആർ.എൽ.:',
	'lqt-thread-link-title' => 'വിക്കിയെഴുത്തിന്റെ കണ്ണി:',
	'lqt-thread-link-copy' => 'ക്ലിപ്‌‌ബോഡിലേയ്ക്ക് പകർത്തുക',
	'lqt-sign-not-necessary' => 'നാലു റ്റിൽഡ് ചിഹ്നങ്ങൾ ഉപയോഗിച്ച് താങ്കളുടെ എഴുത്തിൽ ഒപ്പുവെയ്ക്കേണ്ട ആവശ്യമില്ല.
ഒപ്പ് സ്വയം വന്നുകൊള്ളുന്നതാണ്.',
	'lqt-marked-as-read-placeholder' => '$1 എന്ന ചരട് വായിച്ചതായി അടയാളപ്പെടുത്തിയിരിക്കുന്നു.',
	'lqt-change-subject' => 'വിഷയം മാറ്റുക',
	'lqt-save-subject' => 'സേവ് ചെയ്യുക',
	'lqt-save-subject-failed' => 'ഈ ചരടിന്റെ വിഷയം മാറ്റാനുള്ള ശ്രമത്തിനിടയിൽ താഴെ കൊടുത്തിരിക്കുന്ന പിഴവു സംഭവിച്ചു: $1',
	'lqt-ajax-invalid-subject' => 'താങ്കൾ നൽകിയ വിഷയം അസാധുവാണ്, മിക്കവാടും അതിന്റെ നീളക്കൂടുതൽ കൊണ്ടാവാം.',
	'lqt-ajax-no-subject' => 'പുതിയ ചരടിന്റെ വിഷയം നിർബന്ധമായും നൽകിയിരിക്കണം.',
	'lqt-save-subject-error-unknown' => 'ഈ ചരടിന്റെ വിഷയം മാറ്റാനുള്ള ശ്രമത്തിനിടയിൽ അപരിചിതമായ പിഴവു സംഭവിച്ചിരിക്കുന്നു. ദയവായി പ്രധാന എഴുത്തിൽ ഏറ്റവും മുകളിലുള്ള "തിരുത്തുക" എന്നതു ഞെക്കി ശ്രമിച്ചു നോക്കുക.',
	'lqt-cancel-subject-edit' => 'റദ്ദാക്കുക',
	'lqt-drag-activate' => 'പുതിയ സ്ഥാനത്തേയ്ക്ക് വലിച്ചിടുക',
	'lqt-drag-drop-zone' => 'ഇവിടെ ഇടുക',
	'lqt-drag-confirm' => 'താഴെ കൊടുത്തിരിക്കുന്ന പ്രവൃത്തികൾ പൂർണ്ണമാകാൻ, ദയവായി ഒരു കാരണം നൽകിയ ശേഷം "{{int:lqt-drag-save}}" ഞെക്കുക.',
	'lqt-drag-reparent' => 'പുതിയ താവഴിയിൽ അടിയിലേക്ക് പ്രസിദ്ധപ്പെടുത്തൽ മാറ്റുക.',
	'lqt-drag-split' => 'പ്രസിദ്ധപ്പെടുത്തൽ അതിന്റെ സ്വന്തം ചരടിലേയ്ക്ക് മാറ്റുക',
	'lqt-drag-setsortkey' => 'പ്രസിദ്ധപ്പെടുത്തലിന്റെ സ്ഥാനം താളിൽ ക്രമീകരിക്കുക',
	'lqt-drag-bump' => 'സംവാദം താളിന്റെ മുകളിലേയ്ക്ക് പ്രസിദ്ധപ്പെടുത്തൽ മാറ്റുക',
	'lqt-drag-save' => 'സ്ഥിരീകരിക്കുക',
	'lqt-drag-title' => 'വലിച്ചിടൽ സ്ഥിരീകരിക്കുക',
	'lqt-drag-reason' => 'കാരണം:',
	'lqt-drag-subject' => 'പുതിയ ചരടിന്റെ വിഷയം (നിർബന്ധമാണ്):',
	'lqt-edit-signature' => '(ഒപ്പ് തിരുത്തുക)',
	'lqt-preview-signature' => '(എങ്ങനെയുണ്ടെന്നു കാണുക)',
	'lqt-feed-title-all' => '{{SITENAME}} - പുതിയ പ്രസിദ്ധപ്പെടുത്തലുകൾ',
	'lqt-feed-title-all-from' => '{{SITENAME}} - $1 എണ്ണത്തിലെ പുതിയ പ്രസിദ്ധപ്പെടുത്തലുകൾ',
	'lqt-feed-title-new-threads' => '{{SITENAME}} - പുതിയ ചരടുകൾ',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} - $1 {{PLURAL:$2|എന്ന താളിൽ|എന്നീ താളുകളിൽ}} നിന്നുള്ള ചരടുകൾ',
	'lqt-feed-title-replies' => '{{SITENAME}} — മറുപടികൾ',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — {{PLURAL:$2|$1 എന്ന താളിലുള്ള|$1 എന്ന താളുകളിലുള്ള}} മറുപടികൾ',
	'lqt-feed-new-thread-intro' => '$1 താളിൽ $2 പ്രസിദ്ധപ്പെടുത്തിയ പുതിയ ചരട്',
	'lqt-feed-reply-intro' => '$2 ($1 താളിൽ) പ്രസിദ്ധപ്പെടുത്തിയ $3 ചരടിനു മറുപടി നൽകുക ($1 താളിൽ)',
	'tooltip-pt-newmessages' => 'താങ്കൾ ശ്രദ്ധിക്കുന്ന ചരട് ചേർത്ത സംവാദം താളുകളിലെ പുതിയ ചേർക്കലുകൾ പ്രദർശിപ്പിക്കുക',
	'lqt-newmessages-n' => 'പുതിയ സന്ദേശങ്ങൾ($1)',
	'lqt_newmessages' => 'എനിക്കുള്ള പുതിയ സന്ദേശങ്ങൾ (ഒന്നുമില്ല)',
	'lqt_newmessages-title' => 'പുതിയ സന്ദേശങ്ങൾ',
	'lqt-newpost-summary' => 'പുതിയ ചരട്: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'ഈ ചരടിലേയ്ക്ക് താങ്കളുടെ എഴുത്ത് കൂട്ടിച്ചേർക്കുക. പിന്നീട് ഈ വരി മായ്ക്കുക.',
	'lqt-reply-summary' => '[[$2|$1]] എന്നതിനുള്ള മറുപടി',
	'lqt-talkpage-history-title' => 'സംവാദം താളിന്റെ നാൾവഴി',
	'lqt-talkpage-history-subtitle' => 'താൾ $1',
	'lqt-talkpage-history-tab' => 'തലക്കുറി',
	'restriction-reply' => 'മറുപടികൾ പ്രസിദ്ധപ്പെടുത്തുക',
	'restriction-newthread' => 'പുതിയ ചരടുകൾ പ്രസിദ്ധപ്പെടുത്തുക',
	'lqt-protected-reply-thread' => 'പുതിയ പ്രസിദ്ധപ്പെടുത്തലുകളിൽ നിന്ന് സംരക്ഷിക്കപ്പെട്ടിരിക്കുന്നതിനാൽ ഈ ചരടിൽ പ്രസിദ്ധപ്പെടുത്താൻ താങ്കൾക്ക് കഴിയില്ല.',
	'lqt-protected-reply-talkpage' => 'ഈ സംവാദം താൾ അതിലെ ചരടുകൾക്കുള്ള മറുപടികളിൽ നിന്നും സംരക്ഷിക്കപ്പെട്ടിരിക്കുന്നതിനാൽ താങ്കൾക്ക് ഈ ചരടിൽ ഇടാൻ സാധിക്കില്ല.',
	'lqt-protected-newthread' => 'ഈ സംവാദം താൾ പുതിയ ചരടുകളിൽ നിന്നും സംരക്ഷിക്കപ്പെട്ടിരിക്കുന്നതിനാൽ താങ്കൾക്ക് പുതിയ ചരട് ഇവിടെ പ്രസിദ്ധപ്പെടുത്താൻ കഴിയില്ല.',
	'lqt-edit-bump' => 'ഈ ചരട് ഉയർത്തിക്കാട്ടുക',
	'lqt-edit-bump-tooltip' => 'ഈ ചരട് അതിന്റെ സംവാദം താളിന്റെ ഏറ്റവും മുകളിലേയ്ക്ക് മാറ്റുക',
	'lqt-historicalrevision-error' => 'താങ്കൾ തിരഞ്ഞെടുത്ത നാൾപ്പതിപ്പിൽ പിഴവുണ്ട്, അത് കാണാൻ സാധ്യമല്ല.',
	'lqt-reply-subpage' => 'മറുപടി',
	'nstab-thread' => 'ചരട്',
	'nstab-summary' => 'ചുരുക്കം',
);

/** Mongolian (Монгол)
 * @author Chinneeb
 */
$messages['mn'] = array(
	'lqt-summary' => 'Товч агуулга',
	'lqt-email-undo' => 'Цуцлах',
	'lqt-history-comment' => 'Тайлбар',
	'lqt-search-button' => 'Хайх',
	'lqt-cancel-subject-edit' => 'Цуцлах',
	'lqt-drag-reason' => 'Шалтгаан:',
);

/** Marathi (मराठी)
 * @author Htt
 * @author Kaustubh
 * @author Mahitgar
 */
$messages['mr'] = array(
	'lqt-desc' => 'चर्चा पानावर चर्चेचे मुद्दे वाढवा',
	'lqt_movethread' => 'थ्रेड दुसर्‍या पानावर हलवा',
	'lqt_deletethread' => 'थ्रेड वगळा किंवा पुनर्स्थापित करा',
	'lqt_contents_title' => 'अनुक्रमणिका',
	'lqt_add_header' => 'हेडर लिहा',
	'lqt_new_thread' => 'नवीन चर्चा चालू करा',
	'lqt_reply' => 'उत्तर',
	'lqt_delete' => 'वगळा',
	'lqt_undelete' => 'पुनर्स्थापित करा',
	'lqt_permalink' => 'शाश्वत दुवा',
	'lqt_fragment' => '$2 कडून $1 चा एक हिस्सा',
	'lqt_discussion_link' => 'चर्चा',
	'lqt_from_talk' => '$1 पासून',
	'lqt_hist_comment_edited' => 'शेरा संपादला',
	'lqt_hist_summary_changed' => 'संक्षिप्त माहिती बदलली',
	'lqt_hist_reply_created' => 'नवीन उत्तर तयार केले',
	'lqt_hist_thread_created' => 'नवीन थ्रेड बनविला',
	'lqt_hist_deleted' => 'वगळलेले',
	'lqt_hist_undeleted' => 'पुनर्स्थापित केले',
	'lqt_hist_moved_talkpage' => 'स्थानांतरीत',
	'lqt_hist_listing_subtitle' => 'इतिहास नोंद पाहत आहे',
	'lqt_hist_view_whole_thread' => 'संपूर्ण थ्रेडसाठीचा इतिहास पहा',
	'lqt_hist_no_revisions_error' => 'या थ्रेडला इतिहास नाही.',
	'lqt_hist_past_last_page_error' => 'तुम्ही अस्तित्वात असणार्‍या इतिहास पानांच्या संख्येच्या पलीकडे गेलेला आहात.',
	'lqt_hist_tooltip_newer_disabled' => 'तुम्ही पहिल्या पानावर असल्याने हा दुवा वापरू शकत नाही.',
	'lqt_hist_tooltip_older_disabled' => 'तुम्ही शेवटच्या पानावर असल्याने हा दुवा वापरू शकत नाही.',
	'lqt_revision_as_of' => '$1 ची आवृत्ती.',
	'lqt_change_new_thread' => 'ही या थ्रेडची सुरुवातीची आवृत्ती आहे.',
	'lqt_change_reply_created' => 'रंगविलेली (highlighted) सूचना या आवृत्तीमध्ये देण्यात आली होती.',
	'lqt_change_edited_root' => 'रंगविलेली सूचना या आवृत्तीमध्ये संपादित करण्यात आली होती.',
	'lqt_youhavenewmessages' => 'तुमच्यासाठी [[$1|नवीन संदेश]] आहेत.',
	'lqt_protectedfromreply' => 'ह्या थ्रेडला उत्तर देणे $1 आहे.',
	'lqt_protectedfromreply_link' => 'सुरक्षीत',
	'lqt_subject' => 'विषय:',
	'lqt_noreason' => 'कारण दिलेले नाही.',
	'lqt_move_placeholder' => 'हा थ्रेड $1 थ्रेडची जागा दर्शवितो, जो दुसर्‍या चर्चा पानावर हलविण्यात आलेला होता. हे स्थानांतरण $2 ने $3 $4 ला केले.',
	'lqt_thread_deleted_for_sysops' => 'हा थ्रेड $1 आहे व फक्त प्रबंधकांनाच दिसू शकतो.',
	'lqt_thread_deleted' => 'हा थ्रेड वगळला आहे.',
	'lqt_summary_notice' => 'मागील $2 दिवसांमध्ये या चर्चेमध्ये काहीही बदल झालेले नाहीत. जर ती पूर्ण झालेली असेल, तर तुम्ही ती $1 करू शकता.',
	'lqt_summary_notice_link' => 'संक्षिप्त माहिती लिहा',
	'lqt_summary_label' => 'ह्या थ्रेडला खालील संक्षिप्त माहिती दिलेली आहे:',
	'lqt_summary_subtitle' => '$1 ची संक्षिप्त माहिती.',
	'lqt_nosuchrevision' => 'या थ्रेडची अशी आवृत्ती नाही.',
	'lqt_nosuchthread' => 'असा थ्रेड नाही.',
	'lqt_threadrequired' => 'URL मध्ये थ्रेड देणे आवश्यक आहे.',
	'lqt_move_movingthread' => '$1 चे स्थानांतरण चालू आहे. हा $2 चाच भाग आहे.',
	'lqt_move_torename' => "ह्या थ्रेड चे नाव बदलण्यासाठी, $1 आणि 'विषय' बदला.",
	'lqt_move_torename_edit' => 'संपादन करा',
	'lqt_move_destinationtitle' => 'लक्ष्य चर्चा पानाचे शीर्षक:',
	'lqt_move_move' => 'हलवा',
	'lqt_move_nodestination' => 'तुम्ही लक्ष्य देणे आवश्यक आहे.',
	'lqt_move_noreason' => 'कारण दिलेले नाही.',
	'lqt_move_success' => 'हा थ्रेड $1 वर हलविण्यात आलेला आहे.',
	'lqt_delete_undeletethread' => 'थ्रेड पुनर्स्थापित करा',
	'lqt_delete_partof' => 'हा थ्रेड $1 चा भाग आहे.',
	'lqt_delete_deleting' => '$1 वगळीत आहे व त्यामध्ये $2 करीत आहे.',
	'lqt_delete_deletethread' => 'थ्रेड व उत्तरे वगळा',
	'lqt_delete_deleted' => 'थ्रेड वगळण्यात आलेला आहे.',
	'lqt_delete_undeleted' => 'थ्रेड पुनर्स्थापित करण्यात आलेला आहे.',
	'lqt_delete_return' => '$1 कडे परत जा.',
	'lqt_delete_return_link' => 'चर्चा पान',
	'lqt_delete_unallowed' => 'तुम्हाला थ्रेड वगळण्याची परवानगी नाही.',
	'lqt_talkpage_autocreate_summary' => 'पहिला थ्रेड लिहिल्यानंतर चर्चा पान आपोआप तयार झाले होते.',
	'lqt_header_warning_big' => 'तुम्ही एक $1 संपादित आहात.',
	'lqt_header_warning_after_big' => 'हेडर फक्त घोषणा व प्रिफेस करीता वापरावेत. तुम्ही त्याऐवजी $2 वापरू शकता.',
	'lqt_header_warning_bold' => 'चर्चा पानाचे हेडर',
	'lqt_header_warning_new_discussion' => 'नवीन चर्चा सुरु करा',
	'lqt_sorting_order' => 'अनुक्रम ठरवा:',
	'lqt_sort_newest_changes' => 'शेवटी बदललेले पहिल्यांदा',
	'lqt_sort_newest_threads' => 'नवीन थ्रेड पहिल्यांदा',
	'lqt_sort_oldest_threads' => 'जुने थ्रेड पहिल्यांदा',
	'lqt_newmessages' => 'माझे नवीन संदेश',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 * @author Aurora
 */
$messages['ms'] = array(
	'lqt-desc' => 'Tambahkan tred perbincangan kepada laman perbincangan',
	'lqt_movethread' => 'Alihkan tred ke laman lain',
	'lqt_deletethread' => 'Hapus/nyahhapus tred',
	'lqt_contents_title' => 'Kandungan',
	'lqt_toc_thread_title' => 'Tajuk tred',
	'lqt_toc_thread_author' => 'Dibuka oleh',
	'lqt_toc_thread_replycount' => 'Balasan',
	'lqt_toc_thread_modified' => 'Kali terakhir diubah',
	'lqt_add_header' => 'Bubuh pengatas',
	'lqt_new_thread' => 'Mulakan perbincangan baru',
	'lqt_invalid_subject' => 'Subjek yang anda isikan itu tidak sah.
Mungkin ia:
* Terlalu panjang, atau
* Bercanggah dengan awalan antara wiki atau nama ruang nama.',
	'lqt_empty_subject' => 'Anda mesti mengisikan subjek.',
	'lqt_reply' => 'Balas',
	'lqt-parent' => 'Induk',
	'lqt_delete' => 'Hapuskan',
	'lqt_undelete' => 'Batalkan penghapusan',
	'lqt_permalink' => 'Pautan ke',
	'lqt_fragment' => 'Cebisan $1 dari $2',
	'lqt_discussion_link' => 'perbincangan',
	'lqt_from_talk' => 'Dari $1',
	'lqt-history-title' => 'Sejarah tred',
	'lqt_hist_comment_edited' => 'Teks ulasan [$2 disunting]',
	'lqt_hist_summary_changed' => 'Ringkasan diubah',
	'lqt_hist_reply_created' => 'Ada [[$1|balasan baru]]',
	'lqt_hist_thread_created' => 'Tred baru dibuka',
	'lqt_hist_deleted' => 'Dihapuskan',
	'lqt_hist_undeleted' => 'Penghapusan dibatalkan',
	'lqt_hist_moved_talkpage' => 'Dipindahkan',
	'lqt_hist_listing_subtitle' => 'Melihat senarai sejarah',
	'lqt_hist_view_whole_thread' => 'Lihat sejarah seluruh tred',
	'lqt_hist_no_revisions_error' => 'Tred ini langsung tiada semakan sejarah.',
	'lqt_hist_past_last_page_error' => 'Anda telah melebihi bilangan mukasurat sejarah yang ada.',
	'lqt_hist_tooltip_newer_disabled' => 'Pautan ini mati kerana anda berada di mukasurat pertama.',
	'lqt_hist_tooltip_older_disabled' => 'Pautan ini mati kerana anda berada di mukasurat terakhir.',
	'lqt_hist_split' => 'Balasan dipecahkan ke tred baru',
	'lqt_hist_edited_subject' => 'Subjek "$2" diubah menjadi "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Subjek diubah',
	'lqt_hist_merged_from' => '[[$1|Balasan]] dipindahkan ke tred lain',
	'lqt_hist_merged_to' => '[[$1|Balasan]] dipindahkan dari tred lain',
	'lqt_hist_split_from' => 'Pecahkan ke tred baru',
	'lqt_hist_root_blanked' => 'Teks ulasan digugurkan',
	'lqt_hist_adjusted_sortkey' => 'Kedudukan tred dilaraskan',
	'lqt_revision_as_of' => 'Semakan pada $2, $3.',
	'lqt_change_new_thread' => 'Inilah semakan awal tred ini.',
	'lqt_change_reply_created' => '[$1 Ulasan yang disoroti] ini dicipta dalam semakan ini.',
	'lqt_change_edited_root' => '[$1 Ulasan yang disoroti] ini disunting dalam semakan ini.',
	'lqt_change_edited_summary' => 'Ringkasan tred ini disunting',
	'lqt_change_deleted' => '[$1 Tred ini] atau induknya telah dihapuskan',
	'lqt_change_undeleted' => '[$1 kiriman yang disoroti] ini telah dinyahhapuskan',
	'lqt_change_moved' => '[$1 Tred ini] dipindahkan ke laman perbincangan yang lain',
	'lqt_change_split' => '[$1 Tred ini] dipecahkan daripada tred lain',
	'lqt_change_edited_subject' => 'Subjek tred ini bertukar dari "$2" menjadi "$3"',
	'lqt_change_merged_from' => '[$1 Balasan] kepada tred ini dipindahkan ke tred lain',
	'lqt_change_merged_to' => '[$1 Balasan yang disoroti] ini dipindahkan dari tred lain',
	'lqt_change_split_from' => 'Satu [$1 subtred] dalam tred ini dipecahkan kepada tred sendiri',
	'lqt_change_root_blanked' => 'Teks dalam satu [$1 ulasan] telah dipadamkan.',
	'lqt_youhavenewmessages' => 'Anda mempunyai [[$1|pesanan baru]].',
	'lqt_protectedfromreply' => 'Tredn ini telah $1 daripada dibalas.',
	'lqt_protectedfromreply_link' => 'dilindungi',
	'lqt_subject' => 'Subjek:',
	'lqt_noreason' => 'Tiada sebab diberikan.',
	'lqt_move_placeholder' => 'Tred $1 telah dipindahkan dari sini ke $5.
Pemindahan ini dilakukan oleh $2 pada $3, $4.',
	'lqt_thread_deleted_for_sysops' => "Tred ini telah '''dihapuskan''' dan hanya boleh dilihat oleh pentadbir.",
	'lqt_thread_deleted' => 'Tred ini telah dihapuskan.',
	'lqt_summary_notice' => 'Tiada perubahan pada perbincangan ini selama $2 hari lebih.
Jika sudah berakhir, rasanya anda ingin $1.',
	'lqt_summary_notice_link' => 'menulis ringkasan',
	'lqt_summary_label' => 'Ringkasan tred:',
	'lqt_summary_subtitle' => 'Ringkasan "$1"',
	'lqt_nosuchrevision' => 'Semakan tred ini tidak wujud.',
	'lqt_nosuchthread' => 'Tred yang anda nyatakan tidak wujud.',
	'lqt_nosuchthread_title' => 'Tred tidak wujud',
	'lqt_threadrequired' => 'Anda mesti menyatakan tred dalam URL.',
	'lqt_move_movingthread' => '$1 sedang dialihkan.
Tred ini ialah sebahagian $2.',
	'lqt_move_torename' => "Untuk menukar nama tred ini, $1 dan tukar ruangan 'Subjek'.",
	'lqt_move_torename_edit' => 'sunting',
	'lqt_move_destinationtitle' => 'Tajuk laman perbincangan yang ditujui:',
	'lqt_move_move' => 'Pindahkan',
	'lqt_move_nodestination' => 'Anda mesti nyatakan laman yang ditujui.',
	'lqt_move_thread_bad_destination' => 'Laman yang ditujui ini bukan laman perbincangan.',
	'lqt_move_samedestination' => 'Tred ini sudah ada di laman ini!',
	'lqt_move_noreason' => 'Tiada sebab diberikan.',
	'lqt_move_success' => 'Tred ini dipindahkan ke $1.',
	'lqt_delete_undeletethread' => 'Kembalikan tred',
	'lqt_delete_partof' => "Tred ini ialah sebahagian '''$1'''.",
	'lqt_delete_deleting' => "'''$1''' dan '''semua balasan''' kepadanya sedang dipadamkan.",
	'lqt_delete_deletethread' => 'Padamkan tred dan balasan sekali',
	'lqt_delete_deleted' => 'Tred ini telah dipadamkan.',
	'lqt_delete_undeleted' => 'Tred ini telah dikembalikan.',
	'lqt_delete_return' => 'Kembali ke $1.',
	'lqt_delete_return_link' => 'laman perbincangan',
	'lqt_delete_unallowed' => 'Anda tidak dibenarkan menghapuskan tred.',
	'lqt_delete_show_checkbox' => 'Tunjukkan tred yang dihapuskan',
	'lqt_talkpage_autocreate_summary' => 'Laman perbincangan dicipta secara automatik ketika tred pertama dikirim',
	'lqt_header_warning_big' => 'Anda sedang menyunting $1.',
	'lqt_header_warning_after_big' => 'Pengatas adalah untuk pengumuman dan kata pengantar.
Mungkin anda ingin $2.',
	'lqt_header_warning_bold' => 'pengatas laman perbincangan',
	'lqt_header_warning_new_discussion' => 'memulakan perbincangan baru',
	'lqt_sorting_order' => 'Turutan:',
	'lqt_sort_newest_changes' => 'perubahan terkini dahulu',
	'lqt_sort_newest_threads' => 'tred terbaru dahulu',
	'lqt_sort_oldest_threads' => 'tred terlama dahulu',
	'lqt-title' => 'Tajuk',
	'lqt-summary' => 'Ringkasan',
	'lqt-searching' => 'Mencari tred',
	'lqt-read-message' => 'Tandai sebagai sudah dibaca',
	'lqt-read-message-tooltip' => 'Gugurkan semua tred daripada pesanan baru.
Tred-tred itu akan masih boleh dilihat di laman perbincangan asalnya.',
	'lqt-read-all' => 'Tandai semua sebagai sudah dibaca',
	'lqt-read-all-tooltip' => 'Gugurkan semua tred daripada pesanan baru.
Tred-tred itu akan masih boleh dilihat di laman perbincangan asalnya.
Selepas ini dilakukan, tred-tred itu tidak boleh dikembalikan.',
	'lqt-marked-read' => "Tred '''$1''' ditandai sebagai sudah dibaca.",
	'lqt-count-marked-read' => '$1 pesanan ditandai sebagai sudah dibaca.',
	'lqt-email-undo' => 'Buat asal',
	'lqt-no-new-messages' => 'Anda tiada pesanan baru.',
	'lqt-new-messages' => '✒ Anda ada pesanan baru.',
	'lqt-email-info-undo' => 'Kembalikan tred yang baru anda singkirkan.',
	'lqt-date-info' => 'Pautan ini mati kerana anda sedang melihat tred-tred dari semua tarikh.',
	'lqt-newmessages-context' => 'Tred penuh',
	'lqt-thread-created' => 'Dicipta',
	'lqt-history-time' => 'Waktu',
	'lqt-history-user' => 'Pengguna',
	'lqt-history-action' => 'Kegiatan',
	'lqt-history-comment' => 'Ulasan',
	'lqt-history-thread' => 'Tred',
	'lqt-thread-edited-author' => 'Disunting oleh pengarang.<br />
Suntingan terakhir: $1',
	'lqt-thread-edited-others' => 'Disunting oleh {{PLURAL:$2|seorang lagi pengguna|$2 orang pengguna}}.<br />
Suntingan terakhir: $1',
	'lqt-header-actions' => 'Tindakan',
	'lqt_summarize_link' => 'Buat ringkasan',
	'lqt-summarize-intro' => 'Sila buat ringkasan tred di bawah dalam ruangan penyuntingan.
Anda boleh menggunakan mana-mana teks wiki dalam ringkasan anda.
Selepas siap, klik "{{int:savearticle}}".',
	'lqt-thread-split' => 'Pecahkan ke tred baru',
	'lqt-split-success' => 'Anda berjaya memecahkan tred $1.',
	'lqt_split_thread' => 'Pecahkan tred',
	'lqt-thread-split-subject' => 'Subjek tred baru:',
	'lqt-thread-split-thread' => 'Tred:',
	'lqt-split-submit' => 'Pecahkan',
	'lqt_split_badsubject' => 'Subjek yang anda isikan itu tidak sah.',
	'lqt-no-threads' => 'Laman ini tiada tred lagi.',
	'lqt-delete-parent-warning' => 'Inilah tred peringkat tinggi dengan balasan.
Balasan-balasannya juga akan dihapuskan secara automatik.
Untuk mengelakkan ini daripada berlaku, pecahkannya dari tred ini sebelum menghapuskan tred ini.',
	'lqt-delete-parent-deleted' => 'Tred induk dihapuskan ($1)',
	'lqt-delete-replies-done' => 'Semua balasan kepada tred ini turut dipadamkan.',
	'lqt-movethread' => 'Pindahkan',
	'lqt-menu-trigger' => 'Lagi',
	'lqt-newmessages-from' => 'Dari $1',
	'lqt-hot-topics' => 'Topik hangat',
	'lqt-add-reply' => 'Balas',
	'lqt_rc_new_discussion' => 'tred baru, "$1" dikirim',
	'lqt_rc_new_reply' => 'balasan dikirim kepada "$1"',
	'right-lqt-split' => 'Memecahkan tred',
	'right-lqt-merge' => 'Menggabungkan tred',
	'right-lqt-react' => 'Membalas tred',
	'lqt-thread-merge' => 'Gabungkan ke tred lain',
	'lqt-thread-merge-to' => 'Gabungkan ke tred ini',
	'lqt_merge_thread' => 'Gabungkan tred',
	'lqt-thread-merge-source' => 'Tred sumber:',
	'lqt-thread-merge-dest' => 'Tred tujuan:',
	'lqt-merge-submit' => 'Gabungkan',
	'lqt-merge-success' => 'Anda berjaya menggabungkan tred $1 ke bawah $2.',
	'lqt-log-name' => 'Log perbincangan bertred',
	'lqt-log-header' => 'Log ini membutirkan tindakan yang diambil ke atas tred perbincangan.',
	'lqt-log-action-move' => '[[$1]] dipindahkan dari [[$2]] ke [[$3]]',
	'lqt-log-action-split' => '[[$1]] dipecahkan dari bawah [[$3]], dengan subjek baru "$2"',
	'lqt-log-action-merge-across' => '[[$1]] dipindahkan dari bawah [[$2]] ke bawah [[$3]]',
	'lqt-log-action-merge-down' => '[[$1]] digabungkan ke bawah [[$3]]',
	'lqt-log-action-subjectedit' => 'subjek [[$1]] ditukar dari "$2" menjadi "$3"',
	'lqt-log-action-resort' => 'turutan [[$1]] diubah. Kunci turutan diubah dari $2 kepada $3',
	'lqt-preference-notify-talk' => 'E-mel kepada saya tentang balasan pada tred yang saya pantau',
	'lqt-preference-watch-threads' => 'Pantau tred-tred yang saya cipta atau balas',
	'prefs-lqt' => 'Perbincangan bertred',
	'lqt-preference-display-depth' => 'Kedalaman balasan maksimum untuk ditunjukkan:',
	'lqt-preference-display-count' => 'Bilangan balasan maksimum untuk ditunjukkan:',
	'lqt-preference-custom-signatures' => 'Tunjukkan tandatangan tempahan pengguna',
	'lqt-enotif-subject-reply' => 'Perbincangan {{SITENAME}} - Balas: $1',
	'lqt-enotif-subject-newthread' => 'Perbincangan {{SITENAME}} - Tred baru: $1',
	'lqt-enotif-newthread' => "$1,

Ini ialah makluman dari {{SITENAME}} bahawa ada satu tred baru bertajuk '$2' yang dibuka oleh $8 di $5 pada $3, $4.

Anda boleh membacanya di <$6>

Teksnya adalah seperti berikut:
$7",
	'lqt-enotif-reply' => "$1,

Ini ialah makluman dari {{SITENAME}} bahawa ada satu balasan kepada '$2' yang dikirim oleh $8 di $5 pada $3, $4.

Anda boleh membacanya di <$6>

Teksnya adalah seperti berikut:
$7",
	'lqt-quote-intro' => 'Pada $2, $3, [[User:$1|$1]] menulis:',
	'lqt-quote' => 'Petikan',
	'lqt-search-legend' => 'Cari perbincangan di laman ini',
	'lqt-search-label' => 'Kata yang dicari:',
	'lqt-search-button' => 'Cari',
	'searchprofile-threads' => 'Perbincangan',
	'searchprofile-threads-tooltip' => 'Cari perbincangan tred dan laman perbincangan',
	'lqt-ajax-updated' => 'Tred ini mempunyai kiriman baru.',
	'lqt-ajax-update-link' => 'Kemas kini',
	'lqt-thread-show-replies' => 'Tunjukkan $1 balasan',
	'lqt-thread-show-more' => 'Tunjukkan banyak lagi balasan',
	'lqt-thread-link-url' => 'URL pautan:',
	'lqt-thread-link-title' => 'Pautan teks wiki:',
	'lqt-thread-link-copy' => "Salin ke papan keratan (''clipboard''):",
	'lqt-sign-not-necessary' => 'Anda tidak perlu menandatangani kiriman anda dengan empat tanda tilde.
Tandatangan diisikan secara automatik.',
	'lqt-marked-as-read-placeholder' => 'Tred $1 ditandai sebagai sudah dibaca.',
	'lqt-change-subject' => 'Tukar subjek',
	'lqt-save-subject' => 'Simpan',
	'lqt-save-subject-failed' => 'Ralat yang berikut terjadi dalam cubaan mengubah subjek tred ini: $1',
	'lqt-ajax-invalid-subject' => 'Subjek yang anda nyatakan tidak sah, mungkin kerana terlalu panjang.',
	'lqt-ajax-no-subject' => 'Anda mesti menyatakan subjek untuk tred baru.',
	'lqt-save-subject-error-unknown' => 'Berlakunya ralat yang tidak dikenali dalam cubaan menetapkan subjek tred ini. Sila cuba yang ini lagi dengan mengklik "sunting" di kiriman teratas.',
	'lqt-cancel-subject-edit' => 'Batalkan',
	'lqt-drag-activate' => 'Seret ke lokasi baru',
	'lqt-drag-drop-zone' => 'Lepaskan di sini',
	'lqt-drag-confirm' => 'Untuk melengkapkan tindakan berikut, sila isikan sebab, kemudian klik "Sahkan".',
	'lqt-drag-reparent' => 'Alihkan kiriman ke bawah induk yang baru.',
	'lqt-drag-split' => 'Alihkan kiriman ke tred sendiri',
	'lqt-drag-setsortkey' => 'Laraskan kedudukan kiriman di laman',
	'lqt-drag-bump' => 'Alihkan kiriman ke atas laman perbincangan',
	'lqt-drag-save' => 'Sahkan',
	'lqt-drag-title' => 'Sahkan seretan',
	'lqt-drag-reason' => 'Sebab:',
	'lqt-drag-subject' => 'Subjek tred baru (wajib):',
	'lqt-edit-signature' => '(tandatangan suntingan)',
	'lqt-preview-signature' => '(pratonton)',
	'lqt-feed-title-all' => '{{SITENAME}} — Kiriman baru',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Kiriman baru dari $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Tred baru',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Tred baru dari $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Balasan',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Balasan dari $1',
	'lqt-feed-new-thread-intro' => 'Tred baru di $1 dikirim oleh $2',
	'lqt-feed-reply-intro' => 'Balasan kepada $3 (di $1) dikirim oleh $2',
	'tooltip-pt-newmessages' => 'Menunjukkan kiriman baru pada tred atau laman perbincangan bertred yang anda pantau',
	'lqt-newmessages-n' => 'Pesanan baru saya ($1)',
	'lqt_newmessages' => 'Pesanan baru saya (Tiada)',
	'lqt_newmessages-title' => 'Pesanan baru',
	'lqt-newpost-summary' => 'Tred baru: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Sila isikan teks anda untuk tred ini. Anda patut memadamkan baris ini kemudian.',
	'lqt-reply-summary' => 'Balas [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Sejarah laman perbincangan',
	'lqt-talkpage-history-subtitle' => 'Untuk $1',
	'lqt-talkpage-history-tab' => 'Pengatas',
	'restriction-reply' => 'Kirim balasan',
	'restriction-newthread' => 'Kirim tred baru',
	'lqt-protected-reply-thread' => 'Anda tidak boleh mengirim dalam tred ini kerana ia telah dilindungi daripada kiriman baru.',
	'lqt-protected-reply-talkpage' => 'Anda tidak boleh mengirim dalam tred ini kerana laman perbincangan ini telah dilindungi daripada balasan pada tred-trednya.',
	'lqt-protected-newthread' => 'Anda tidak boleh mengirim tred baru di laman perbincangan ini kerana ia telah dilindungi daripada tred baru.',
	'lqt-edit-bump' => 'Naikkan tred ini',
	'lqt-edit-bump-tooltip' => 'Alihkan tred ini ke atas laman perbincangan',
	'lqt-historicalrevision-error' => 'Semakan yang anda pilih itu tercemar dan tidak boleh dipaparkan.',
	'lqt-reply-subpage' => 'balas',
	'nstab-thread' => 'Tred',
	'nstab-summary' => 'Ringkasan',
);

/** Maltese (Malti)
 * @author Chrisportelli
 * @author Roderick Mallia
 */
$messages['mt'] = array(
	'lqt_delete' => 'Ħassar',
	'lqt_discussion_link' => 'diskussjoni',
	'lqt_hist_moved_talkpage' => 'Immexxi',
	'lqt_hist_edited_subject_corrupt' => 'Suġġett mibdul',
	'lqt_subject' => 'Suġġett:',
	'lqt_noreason' => 'Ma ngħatat ebda raġuni.',
	'lqt_move_torename_edit' => 'immodifikaha',
	'lqt_move_move' => 'Mexxi',
	'lqt-title' => 'Titlu',
	'lqt-summary' => 'Taqsira',
	'lqt-read-all' => 'Immarkahom kollha bħala moqrija',
	'lqt-no-new-messages' => "M'hemm l-ebda messaġġ ġdid għalik.",
	'lqt-new-messages' => "✒ M'hemm l-ebda messaġġ ġdid għalik.",
	'lqt-history-time' => 'Ħin',
	'lqt-history-user' => 'Utent',
	'lqt-history-action' => 'Attività',
	'lqt-history-comment' => 'Kumment',
	'lqt-movethread' => 'Mexxi',
	'lqt-menu-trigger' => 'Iktar',
	'lqt-preference-notify-talk' => "Ibgħatli b'permezz tal-ittra-e risposti fuq suġġetti li qiegħed insegwi",
	'lqt-search-button' => 'Fittex',
	'searchprofile-threads' => 'Diskussjonijiet',
	'lqt-ajax-update-link' => 'Aġġorna',
	'lqt-thread-show-more' => 'Uri iktar risposti',
	'lqt-change-subject' => 'Biddel is-suġġett',
	'lqt-save-subject' => 'Salva',
	'lqt-cancel-subject-edit' => 'Annulla',
	'lqt-drag-save' => 'Ikkonferma',
	'lqt-drag-reason' => 'Raġuni:',
	'lqt-newmessages-n' => 'Messaġġi ġodda ($1)',
	'lqt_newmessages' => 'il-messaġġi ġodda tiegħi (xejn)',
	'lqt_newmessages-title' => 'Messaġġi ġodda',
	'lqt-talkpage-history-title' => "Kronoloġija tal-paġna ta' diskussjoni",
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'lqt_reply' => 'Пандомс',
	'lqt_delete' => 'Нардамс',
	'lqt-history-title' => 'Суренть молемазо',
	'lqt_hist_deleted' => 'Нардазь',
	'lqt_hist_moved_talkpage' => 'Печтевтезь',
	'lqt_move_move' => 'Печтевтемс',
	'lqt-title' => 'Конякс',
	'lqt-thread-split-thread' => 'Суресь:',
	'lqt-split-submit' => 'Кавонзамс',
	'lqt-movethread' => 'Печтевтемс',
	'lqt-merge-submit' => 'Пельдямс',
	'lqt-drag-save' => 'Кемекстамс',
	'lqt-drag-reason' => 'Тувталось:',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 * @author Ricardo gs
 * @author Teòtlalili
 */
$messages['nah'] = array(
	'lqt_delete' => 'Mìxpôpolòs',
	'lqt_hist_deleted' => 'Òmìxpôpolo',
	'lqt_hist_moved_talkpage' => 'Ōmozacac',
	'lqt_protectedfromreply_link' => 'ōmoquīxti',
	'lqt_noreason' => 'Ahmo cah īxtlamatiliztli.',
	'lqt_move_torename_edit' => 'xicpatla',
	'lqt_move_move' => 'Ticzacāz',
	'lqt_move_noreason' => 'Ahmo cah īxtlamatiliztli.',
	'lqt_delete_return' => 'Timocuepāz īhuīc $1.',
	'lqt-title' => 'Tōcāitl',
	'lqt-read-message' => 'Quimachiyōtīz iuh tāmapōuh',
	'lqt_newmessages' => 'Yancuīc notētītlaniliz (ayāc)',
);

/** Nedersaksisch (Nedersaksisch)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'lqt_move_move' => 'Herneum',
);

/** Nepali (नेपाली)
 * @author Bhawani Gautam
 * @author Bhawani Gautam Rhk
 */
$messages['ne'] = array(
	'lqt_toc_thread_author' => 'आरम्भ कर्ता',
	'lqt_toc_thread_replycount' => 'उत्तरहरु',
	'lqt_toc_thread_modified' => 'पछिल्लो संशोधन',
	'lqt_add_header' => 'शीर्षक जोड़ने',
	'lqt_new_thread' => 'नयाँ चर्चा सुरु गर्ने',
	'lqt_invalid_subject' => 'The subject you entered is invalid.
It may:
* Be too long, or
* Conflict with interwiki prefixes or namespace names.

तापाईंले हालेको विषय अमान्य छ।
यो:
* अति लामो भएको   अथवा
* अन्तर विकि उपसर्ग अथवा नेमस्पेस (नामस्थान)सित अन्तर विरोधि भएकोछ।',
	'lqt_empty_subject' => 'तपाईंले एउटा विषय दिनुपर्छ।',
	'lqt_reply' => 'जवाब दिने',
	'lqt-parent' => 'जनक',
	'lqt_delete' => 'मेट्ने',
	'lqt_undelete' => 'मेटेको रद्द गर्ने',
	'lqt_permalink' => 'यो सित लिंक गर्ने',
	'lqt_discussion_link' => 'चर्चा',
	'lqt_from_talk' => ' $1बाट',
	'lqt_hist_moved_talkpage' => 'सारियो',
	'lqt_hist_edited_subject' => '"$3"बाट "$2"मा विषय सारिएको',
	'lqt_hist_edited_subject_corrupt' => 'विषय सारियो',
	'lqt_revision_as_of' => '$2को संशोधन समय $3मा',
	'lqt_youhavenewmessages' => ' तपाईंलाई [[$1|नयाँ सन्देशहरु छन्]]।',
	'lqt_protectedfromreply_link' => 'सुरक्षित',
	'lqt_subject' => 'विषय:',
	'lqt_noreason' => 'कारण दिइएको छैन',
	'lqt_summary_subtitle' => '"$1"को सारांश',
	'lqt_move_move' => 'सार्ने',
	'lqt_delete_return' => '$1मा फर्कने',
	'lqt_header_warning_big' => 'तपाईं एउटा $1 संपादन गर्नुहुँदैछ।',
	'lqt-title' => 'शीर्षक',
	'lqt-read-message' => 'पढेकोमा चिह्नित गर्ने',
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|सन्देश|सन्देशहरु}}लाई पढिएकोमा चिह्नित गर्ने',
	'lqt-no-new-messages' => 'तपाईंलाई नयाँ सन्देशहरु छैनन्।',
	'lqt-new-messages' => '✒ तपाईकोनिम्ति नयाँ सन्देशहरु छन्।',
	'lqt-history-time' => 'समय',
	'lqt-history-user' => 'प्रयोगकर्ता',
	'lqt-history-action' => 'क्रियाकलाप',
	'lqt-history-comment' => 'टिप्पणी',
	'lqt-header-actions' => 'कार्यहरु',
	'lqt-menu-trigger' => 'थप',
	'lqt-newmessages-from' => '$1बाट',
	'lqt-hot-topics' => 'जल्दोबल्दो विषय',
	'lqt-add-reply' => 'जवाब जोड़ने',
	'lqt_rc_new_reply' => '"$1"लाई जवाब पठाइयो',
	'lqt-merge-submit' => 'मिसाउने',
	'lqt-enotif-newthread' => "$1जी,
{{SITENAME}}बाट यो सूचना दिइन्छ कि $5माथि एउटा नयाँ सूत्र(thread) '$2',
$8द्वारा $3 कोदिन $4मा सृजना गरिएको थियो

तपाईंले यसलाई <$6>मा हेर्न सक्नुहुनेछ

जसको पाठ थियो:
$7",
	'lqt-enotif-reply' => "$1जी,
{{SITENAME}}बाट यो सूचना दिइन्छ कि $5माथि एउटा नयाँ उत्तर '$2'लाई,
$8द्वारा $3 कोदिन $4मा सृजना गरिएको थियो

तपाईंले यसलाई <$6>मा हेर्न सक्नुहुनेछ

उत्तरको पाठ थियो:
$7",
	'lqt-ajax-update-link' => 'अद्यतन गर्ने',
	'lqt-thread-link-copy' => 'क्लिपबोर्डमा कपी गर्ने',
	'lqt-change-subject' => 'विषय सार्ने',
	'lqt-ajax-no-subject' => 'तपाईंले विषय निर्दिष्ट गर्नै पर्छ',
	'lqt-cancel-subject-edit' => 'रद्द गर्ने',
	'lqt-feed-title-all' => '{{SITENAME}} — नयाँ पोस्ट',
	'lqt-newmessages-n' => 'नयाँ सन्देशहरु ($1)',
	'lqt_newmessages' => 'मेरा नयाँ सन्देशहरु (छैनन्)',
	'lqt_newmessages-title' => 'नयाँ सन्देशहरू',
);

/** Dutch (Nederlands)
 * @author Annabel
 * @author McDutchie
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'lqt-desc' => "Voegt overleg in onderwerpen op overlegpagina's toe",
	'lqt_movethread' => 'Onderwerp naar andere pagina verplaatsen',
	'lqt_deletethread' => 'Onderwerp verwijderen of terugplaatsen',
	'lqt_contents_title' => 'Inhoud',
	'lqt_toc_thread_title' => 'Onderwerp',
	'lqt_toc_thread_author' => 'Gestart door',
	'lqt_toc_thread_replycount' => 'Antwoorden',
	'lqt_toc_thread_modified' => 'Laatste wijziging',
	'lqt_add_header' => 'Introductietekst toevoegen',
	'lqt_new_thread' => 'Nieuw onderwerp starten',
	'lqt_invalid_subject' => 'Het onderwerp dat u heeft opgegeven is ongeldig. Het kan:
* te lang zijn, of
* conflicteren met interwikivoorvoegsels of naamruimtenamen.',
	'lqt_empty_subject' => 'U moet een onderwerp ingeven.',
	'lqt_reply' => 'Antwoorden',
	'lqt-parent' => 'Bovenliggend bericht',
	'lqt_delete' => 'Verwijderen',
	'lqt_undelete' => 'Terugplaatsen',
	'lqt_permalink' => 'Permanente verwijzing',
	'lqt_fragment' => 'Fragment van een $1 van $2',
	'lqt_discussion_link' => 'overleg',
	'lqt_from_talk' => 'Van $1',
	'lqt-history-title' => 'Geschiedenis onderwerp',
	'lqt_hist_comment_edited' => 'Opmerking [$2 bewerkt]',
	'lqt_hist_summary_changed' => 'Samenvatting aangepast',
	'lqt_hist_reply_created' => '[[$1|Nieuw antwoord]] gegeven',
	'lqt_hist_thread_created' => 'Nieuw onderwerp gemaakt',
	'lqt_hist_deleted' => 'Verwijderd',
	'lqt_hist_undeleted' => 'Teruggeplaatst',
	'lqt_hist_moved_talkpage' => 'Verplaatst',
	'lqt_hist_listing_subtitle' => 'Overleggeschiedenis aan het bekijken',
	'lqt_hist_view_whole_thread' => 'Geschiedenis voor het hele onderwerp bekijken',
	'lqt_hist_no_revisions_error' => 'Dit onderwerp heeft geen oudere versies.',
	'lqt_hist_past_last_page_error' => 'U hebt een hoger paginanummer gekozen dan bestaat in de geschiedenis.',
	'lqt_hist_tooltip_newer_disabled' => 'Deze verwijzing is niet actief omdat u op de eerste pagina bent.',
	'lqt_hist_tooltip_older_disabled' => 'Deze verwijzing is niet actief omdat u op de laatste pagina bent.',
	'lqt_hist_split' => 'Antwoord naar een nieuw onderwerp afsplitsen',
	'lqt_hist_edited_subject' => 'Onderwerp gewijzigd van "$2" naar "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Onderwerp gewijzigd',
	'lqt_hist_merged_from' => 'Het [[$1|antwoord]] is verplaatst naar een ander onderwerp',
	'lqt_hist_merged_to' => 'Het [[$1|antwoord]] is verplaatst vanuit een ander onderwerp',
	'lqt_hist_split_from' => 'Naar een nieuw onderwerp afsplitsen',
	'lqt_hist_root_blanked' => 'Tekst van opmerking verwijderd',
	'lqt_hist_adjusted_sortkey' => 'Plaats van het onderwerp aanpassen',
	'lqt_revision_as_of' => 'Versie op $2 om $3.',
	'lqt_change_new_thread' => 'Dit is de eerste versie van het onderwerp.',
	'lqt_change_reply_created' => 'De [$1 gemarkeerde opmerking] is in deze versie toegevoegd.',
	'lqt_change_edited_root' => 'De [$1 gemarkeerde opmerking] is in deze versie bewerkt.',
	'lqt_change_edited_summary' => 'De samenvatting van het onderwerp is bewerkt',
	'lqt_change_deleted' => '[$1 Dit onderwerp] of een bovenliggend onderwerp is verwijderd',
	'lqt_change_undeleted' => 'Het [$1 uitgelichte bericht] is teruggeplaatst nadat het was verwijderd',
	'lqt_change_moved' => '[$1 Dit onderwerp] is verplaatst vanaf een andere overlegpagina',
	'lqt_change_split' => '[$1 Dit onderwerp] is afgesplitst uit een ander onderwerp',
	'lqt_change_edited_subject' => 'Het onderwerp is gewijzigd van "$2" naar "$3"',
	'lqt_change_merged_from' => 'Een [$1 antwoord] in dit onderwerp is verplaatst uit een ander onderwerp',
	'lqt_change_merged_to' => 'Het [$1 uitgelichte antwoord] is hierheen verplaatst vanuit een ander onderwerp',
	'lqt_change_split_from' => 'Een [$1 subonderwerp] van dit onderwerp is afgesplitst in zijn eigen onderwerp',
	'lqt_change_root_blanked' => 'De tekst van een [$1 opmerking] is verwijderd.',
	'lqt_youhavenewmessages' => 'U hebt [[$1|nieuwe berichten]].',
	'lqt_protectedfromreply' => 'Dit onderwerp is $1 van te worden beantwoord.',
	'lqt_protectedfromreply_link' => 'beveiligd',
	'lqt_subject' => 'Onderwerp:',
	'lqt_noreason' => 'Geen reden gegeven.',
	'lqt_move_placeholder' => 'Dit is een markering die aangeeft dat een onderwerp $1 verplaatst is van deze pagina naar een andere overlegpagina ($5).
Deze verplaatsing is uitgevoerd door $2 op $3 $4.',
	'lqt_thread_deleted_for_sysops' => "Dit onderwerp is '''verwijderd''' en is alleen zichtbaar voor beheerders.",
	'lqt_thread_deleted' => 'Dit onderwerp is verwijderd.',
	'lqt_summary_notice' => 'Er zijn geen wijzigingen geweest in de afgelopen {{PLURAL:$2|dag|$2 dagen}}.
Als het overleg is afgerond, wordt u aangemoedigd om $1.',
	'lqt_summary_notice_link' => 'een samenvatting te schrijven',
	'lqt_summary_label' => 'Samenvatting onderwerp:',
	'lqt_summary_subtitle' => 'Samenvatting van "$1"',
	'lqt_nosuchrevision' => 'Deze versie van dit onderwerp bestaat niet.',
	'lqt_nosuchthread' => 'Het aangegeven onderwerp bestaat niet.',
	'lqt_nosuchthread_title' => 'Dit onderwerp bestaat niet',
	'lqt_threadrequired' => 'U moet een onderwerspagina opgeven in de URL.',
	'lqt_move_movingthread' => 'Verplaatsen van $1.
Dit onderwerp is onderdeel van $2.',
	'lqt_move_torename' => "Om dit onderwerp te hernoemen, $1 en wijzig het veld 'Onderwerp'.",
	'lqt_move_torename_edit' => 'bewerk het',
	'lqt_move_destinationtitle' => 'Bestemmingsoverlegpagina:',
	'lqt_move_move' => 'Hernoemen',
	'lqt_move_nodestination' => 'U moet een bestemming opgeven.',
	'lqt_move_thread_bad_destination' => 'De doelpagina is geen overlegpagina.',
	'lqt_move_samedestination' => 'Het onderwerp staat al op deze pagina!',
	'lqt_move_noreason' => 'Geen reden gegeven.',
	'lqt_move_success' => 'Het onderwerp is verplaatst naar $1.',
	'lqt_delete_undeletethread' => 'Onderwerp terugplaatsen',
	'lqt_delete_partof' => "Dit onderwerp maakt onderdeel uit van '''$1'''.",
	'lqt_delete_deleting' => "Bezig met het verwijderen van '''$1''' en '''alle antwoorden''' daarop.",
	'lqt_delete_deletethread' => 'Onderwerp verwijderen',
	'lqt_delete_deleted' => 'Het onderwerp is verwijderd.',
	'lqt_delete_undeleted' => 'Het onderwerp is teruggeplaatst.',
	'lqt_delete_return' => 'Terugkeren naar $1.',
	'lqt_delete_return_link' => 'de overlegpagina',
	'lqt_delete_unallowed' => 'U mag geen onderwerpen verwijderen.',
	'lqt_delete_show_checkbox' => 'Verwijderde onderwerpen weergeven',
	'lqt_talkpage_autocreate_summary' => 'Overlegpagina automatisch aangemaakt bij aanmaken eerste onderwerp.',
	'lqt_header_warning_big' => 'U bent een $1 aan het bewerken.',
	'lqt_header_warning_after_big' => 'Koppen zijn voor aankondigingen en inleidingen. Wellicht kunt u beter gebruik maken van $2.',
	'lqt_header_warning_bold' => 'inleiding van een overlegpagina',
	'lqt_header_warning_new_discussion' => 'begin een nieuw overleg',
	'lqt_sorting_order' => 'Sorteervolgorde:',
	'lqt_sort_newest_changes' => 'laatst gewijzigd bovenaan',
	'lqt_sort_newest_threads' => 'nieuwste onderwerpen bovenaan',
	'lqt_sort_oldest_threads' => 'oudste onderwerpen bovenaan',
	'lqt-title' => 'Naam',
	'lqt-summary' => 'Samenvatting',
	'lqt-searching' => 'Bezig met zoeken naar onderwerpen…',
	'lqt-read-message' => 'Als gelezen markeren',
	'lqt-read-message-tooltip' => 'Dit onderwerp verwijderen uit nieuwe berichten.
Het onderwerp is nog steeds zichtbaar op de oorspronkelijke overlegpagina.',
	'lqt-read-all' => 'Alles als gelezen markeren',
	'lqt-read-all-tooltip' => 'Alle onderwerpen uit nieuwe berichten verwijderen.
Het onderwerp is nog steeds zichtbaar op de oorspronkelijke overlegpagina.
Deze handeling is onomkeerbaar.',
	'lqt-marked-read' => "Onderwerp '''$1''' is gemarkeerd als gelezen.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|bericht|berichten}} gemarkeerd als gelezen.',
	'lqt-email-undo' => 'Ongedaan maken',
	'lqt-no-new-messages' => 'U hebt geen nieuwe berichten.',
	'lqt-new-messages' => '✒ U hebt nieuwe berichten.',
	'lqt-email-info-undo' => 'Terug naar het onderwerp dat u zojuist hebt verlaten.',
	'lqt-date-info' => 'Deze verwijzing is niet actief omdat u onderwerpen van alle datums bekijkt.',
	'lqt-newmessages-context' => 'Volledig onderwerp',
	'lqt-thread-created' => 'Aangemaakt',
	'lqt-history-time' => 'Tijd',
	'lqt-history-user' => 'Gebruiker',
	'lqt-history-action' => 'Activiteit',
	'lqt-history-comment' => 'Opmerking',
	'lqt-history-thread' => 'Onderwerp',
	'lqt-thread-edited-author' => 'Bewerkt door auteur<br />
Laatste bewerking: $1',
	'lqt-thread-edited-others' => 'Bewerkt door {{PLURAL:$2|een andere gebruiker|$2 andere gebruikers}}.<br />
Laatste bewerking: $1',
	'lqt-header-actions' => 'Handelingen',
	'lqt_summarize_link' => 'Samenvatten',
	'lqt-summarize-intro' => 'Vat het onderwerp hieronder samen.
U mag wikitekst gebruiken in uw samenvatting.
Klik op "{{int:savearticle}}" als u klaar bent.',
	'lqt-thread-split' => 'Naar nieuw onderwerp afsplitsen',
	'lqt-split-success' => 'U hebt het nieuwe onderwerp $1 aangemaakt.',
	'lqt_split_thread' => 'Onderwerp opsplitsen',
	'lqt-thread-split-subject' => 'Kop nieuwe onderwerp:',
	'lqt-thread-split-thread' => 'Overleg:',
	'lqt-split-submit' => 'Splitsen',
	'lqt_split_badsubject' => 'Het onderwerp dat u hebt opgegeven is ongeldig.',
	'lqt-no-threads' => 'Er staan nog geen onderwerpen op deze pagina.',
	'lqt-delete-parent-warning' => 'Dit is een overleg op het hoogste niveau in een boomstructuur met antwoorden.
De antwoorden worden worden ook automatisch verwijderd.
Splits dit overleg alvorens het te verwijderen om dit te voorkomen.',
	'lqt-delete-parent-deleted' => 'Bovenliggend overleg verwijderd ($1)',
	'lqt-delete-replies-done' => 'Alle antwoorden in dit overleg zijn ook verwijderd.',
	'lqt-movethread' => 'Verplaatsen',
	'lqt-menu-trigger' => 'Meer',
	'lqt-newmessages-from' => 'Van $1',
	'lqt-hot-topics' => 'Populaire onderwerpen',
	'lqt-add-reply' => 'Antwoorden',
	'lqt_rc_new_discussion' => 'heeft een nieuw onderwerp "$1" geplaatst',
	'lqt_rc_new_reply' => 'heeft een antwoord op "$1" geplaatst',
	'right-lqt-split' => 'Onderwerpen splitsen',
	'right-lqt-merge' => 'Onderwerpen samenvoegen',
	'right-lqt-react' => 'Onderwerpen beantwoorden',
	'lqt-thread-merge' => 'Aan ander onderwerp toevoegen',
	'lqt-thread-merge-to' => 'In dit onderwerp samenvoegen',
	'lqt_merge_thread' => 'Onderwerp samenvoegen',
	'lqt-thread-merge-source' => 'Brononderwerp:',
	'lqt-thread-merge-dest' => 'Doelonderwerp:',
	'lqt-merge-submit' => 'Samenvoegen',
	'lqt-merge-success' => 'Het onderwerp $1 is samengevoegd onder $2.',
	'lqt-log-name' => 'Onderwerpenlogboek',
	'lqt-log-header' => 'Dit logboek bevat details over handelingen ten aanzien van onderwerpen.',
	'lqt-log-action-move' => 'heeft [[$1]] verplaatst van [[$2]] naar [[$3]].',
	'lqt-log-action-split' => 'heeft [[$1]] afgesplitst van [[$3]] met als nieuw onderwerp "$2".',
	'lqt-log-action-merge-across' => 'heeft [[$1]] verplaatst uit [[$2]] naar [[$3]].',
	'lqt-log-action-merge-down' => 'heeft [[$1]] samengevoegd naar [[$3]].',
	'lqt-log-action-subjectedit' => 'heeft het onderwerp voor [[$1]] van "$2" naar "$3" gewijzigd',
	'lqt-log-action-resort' => 'heeft de sorteervolgorde voor [[$1]] gewijzigd van $2 naar $3',
	'lqt-preference-notify-talk' => 'Mij e-mailen bij antwoorden op een onderwerp dat ik volg',
	'lqt-preference-watch-threads' => 'Onderwerpen volgen die ik aanmaak of waar ik op antwoord',
	'prefs-lqt' => 'Gestructureerd overleg',
	'lqt-preference-display-depth' => 'Maximaal weer te geven diepte:',
	'lqt-preference-display-count' => 'Maximaal aantal weer te geven reacties:',
	'lqt-preference-custom-signatures' => 'Aangepaste gebruikersondertekeningen weergeven',
	'lqt-enotif-subject-reply' => 'Overleg op {{SITENAME}} - Antwoord: $1',
	'lqt-enotif-subject-newthread' => 'Overleg op {{SITENAME}} - Nieuw overleg: $1',
	'lqt-enotif-newthread' => 'Hallo $1,

Dit is een kennisgeving van {{SITENAME}}. Er is een nieuw onderwerp "$2" op $5 geplaatst door $8 op $3 om $4.

U kunt het bekijken op <$6>.

De inhoud is:
$7',
	'lqt-enotif-reply' => 'Hallo $1,

Dit is een kennisgeving van {{SITENAME}}. Er is een nieuwe reactie op "$2" op $5 gekomen van $8 op $3 om $4.

U kunt het bekijken op <$6>.

De inhoud is:
$7',
	'lqt-quote-intro' => 'Op $2 om $3 schreef [[User:$1|$1]]:',
	'lqt-quote' => 'Citeren',
	'lqt-search-legend' => 'Overleg op deze pagina doorzoeken',
	'lqt-search-label' => 'Zoektermen:',
	'lqt-search-button' => 'Zoeken',
	'searchprofile-threads' => 'Overleggen',
	'searchprofile-threads-tooltip' => "Overleggen en overlegpagina's doorzoeken",
	'lqt-ajax-updated' => 'Er zijn nieuwe berichten in dit onderwerp.',
	'lqt-ajax-update-link' => 'Bijwerken',
	'lqt-thread-show-replies' => '$1 {{PLURAL:$1|reactie|reacties}} weergeven',
	'lqt-thread-show-more' => 'Meer reacties weergeven',
	'lqt-thread-link-url' => 'URL-verwijzing',
	'lqt-thread-link-title' => 'Wikitekstverwijzing:',
	'lqt-thread-link-copy' => 'Naar klembord kopiëren',
	'lqt-sign-not-necessary' => 'Het is niet nodig uw berichten te ondertekenen met vier tildes. De ondertekening wordt automatisch toegevoegd.',
	'lqt-marked-as-read-placeholder' => 'Het onderwerp "$1" is gemarkeerd als gelezen.',
	'lqt-change-subject' => 'Onderwerp wijzigen',
	'lqt-save-subject' => 'Opslaan',
	'lqt-save-subject-failed' => 'Bij het wijzigen van het onderwerp is de volgende fout opgetreden: $1',
	'lqt-ajax-invalid-subject' => 'Het door u opgegeven onderwerp is ongeldig, waarschijnlijk omdat het te lang is.',
	'lqt-ajax-no-subject' => 'U moet een onderwerp opgeven.',
	'lqt-save-subject-error-unknown' => 'Er is een onbekende fout opgetreden bij het instellen van het onderwerp van dit onderwerp.
Wijzig het onderwerp door op "Bewerken" te klikken in de bovenste bijdrage.',
	'lqt-cancel-subject-edit' => 'Annuleren',
	'lqt-drag-activate' => 'Naar nieuwe plaats slepen',
	'lqt-drag-drop-zone' => 'Hier plaatsen',
	'lqt-drag-confirm' => 'Om de volgende handelingen uit te kunnen voeren moet u een reden invoeren en op "Bevestigen" klikken.',
	'lqt-drag-reparent' => 'Bericht onder een ander onderwerp onderbrengen',
	'lqt-drag-split' => 'Bericht in eigen onderwerp plaatsen',
	'lqt-drag-setsortkey' => 'Positie van bericht op de pagina aanpassen',
	'lqt-drag-bump' => 'Bovenaan de overlegpagina plaatsen',
	'lqt-drag-save' => 'Bevestigen',
	'lqt-drag-title' => 'Slepen bevestigen',
	'lqt-drag-reason' => 'Reden:',
	'lqt-drag-subject' => 'Onderwerp (verplicht):',
	'lqt-edit-signature' => '(ondertekening bewerken)',
	'lqt-preview-signature' => '(voorvertoning)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nieuwe berichten',
	'lqt-feed-title-all-from' => '{{SITENAME}} — {{PLURAL:$2|Nieuw bericht|Nieuwe berichten}} van $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nieuwe onderwerpen',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — {{PLURAL:$2|Nieuw onderwerp|Nieuwe onderwerpen}} van $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Reacties',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — {{PLURAL:$2|Reactie|Reacties}} van $1',
	'lqt-feed-new-thread-intro' => 'Nieuw onderwerp op $1 door $2',
	'lqt-feed-reply-intro' => 'Reactie op $3 (op $1) door $2',
	'tooltip-pt-newmessages' => "Nieuwe berichten weergeven in onderwerpen en pagina's die u volgt",
	'lqt-newmessages-n' => 'Nieuwe berichten ($1)',
	'lqt_newmessages' => 'Nieuwe berichten (0)',
	'lqt_newmessages-title' => 'Nieuwe berichten',
	'lqt-newpost-summary' => 'Nieuw onderwerp: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Geef uw tekst op voor dit onderwerp. Dan moet u deze regel verwijderen.',
	'lqt-reply-summary' => 'Reactie op [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Geschiedenis van de overlegpagina',
	'lqt-talkpage-history-subtitle' => 'Voor $1',
	'lqt-talkpage-history-tab' => 'Koptekst',
	'restriction-reply' => 'Antwoorden',
	'restriction-newthread' => 'Nieuwe onderwerpen maken',
	'lqt-protected-reply-thread' => 'U kunt niet deelnemen aan dit onderwerp omdat het gesloten is.',
	'lqt-protected-reply-talkpage' => 'U kunt niet deelnemen aan dit onderwerp omdat de onderwerpen op deze pagina gesloten zijn.',
	'lqt-protected-newthread' => 'U kunt geen nieuwe onderwerpen aanmaken op deze overlegpagina omdat deze pagina gesloten is voor nieuwe onderwerpen.',
	'lqt-edit-bump' => 'Overleg activeren',
	'lqt-edit-bump-tooltip' => 'Dit overleg activeren door het bovenaan de overlegpagina te plaatsen',
	'lqt-historicalrevision-error' => 'De door u geselecteerde versie is beschadigd en kan niet bekeken worden.',
	'lqt-reply-subpage' => 'antwoord',
	'nstab-thread' => 'Onderwerp',
	'nstab-summary' => 'Samenvatting',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Gunnernett
 * @author Harald Khan
 * @author Jon Harald Søby
 * @author Nghtwlkr
 */
$messages['nn'] = array(
	'lqt-desc' => 'Legg til tråda diskusjonar til diskusjonssider',
	'lqt_movethread' => 'Flytt tråd til ei anna sida',
	'lqt_deletethread' => 'Slett ein eller omgjer slettinga av ein tråd',
	'lqt_contents_title' => 'Innhald',
	'lqt_toc_thread_title' => 'Trådtittel',
	'lqt_toc_thread_author' => 'Starta av',
	'lqt_toc_thread_replycount' => 'Svar',
	'lqt_toc_thread_modified' => 'Sist endra',
	'lqt_add_header' => 'Legg til hovudavsnitt',
	'lqt_new_thread' => 'Start ein ny diskusjon',
	'lqt_invalid_subject' => 'Emnet du skreiv inn er ugyldig.
Kan henda er det:
* For langt
* I konflikt med interwiki-forstavingar eller namn på namnerom',
	'lqt_empty_subject' => 'Du lyt skriva inn eit emne.',
	'lqt_reply' => 'Svar',
	'lqt-parent' => 'Forelder',
	'lqt_delete' => 'Slett',
	'lqt_undelete' => 'Gjer om sletting',
	'lqt_permalink' => 'Permalenkja',
	'lqt_fragment' => 'Ein bit av $1 frå $2',
	'lqt_discussion_link' => 'diskusjon',
	'lqt_from_talk' => 'Frå $1',
	'lqt-history-title' => 'Trådhistorikk',
	'lqt_hist_comment_edited' => 'Kommentartekst [$2 endra]',
	'lqt_hist_summary_changed' => 'Samandrag endra',
	'lqt_hist_reply_created' => '[[$1|Nytt svar]] oppretta',
	'lqt_hist_thread_created' => 'Ny tråd oppretta',
	'lqt_hist_deleted' => 'Sletta',
	'lqt_hist_undeleted' => 'Sletting gjort om',
	'lqt_hist_moved_talkpage' => 'Flytta',
	'lqt_hist_listing_subtitle' => 'Syner ei historikklista',
	'lqt_hist_view_whole_thread' => 'Syn historikken for heile tråden',
	'lqt_hist_no_revisions_error' => 'Denne tråden har ingen versjonar.',
	'lqt_hist_past_last_page_error' => 'Det finst ikkje fleire sider med historikk.',
	'lqt_hist_tooltip_newer_disabled' => 'Denne lenkja er deaktivert av di du er på den første sida.',
	'lqt_hist_tooltip_older_disabled' => 'Denne lenkja er deaktivert av di du er på den siste sida.',
	'lqt_hist_split' => 'Svar kløyvd til ein ny tråd',
	'lqt_hist_edited_subject' => 'Endra emnet frå «$2» til «$3»',
	'lqt_hist_edited_subject_corrupt' => 'Endra emne',
	'lqt_hist_merged_from' => '[[$1|Svar]] flytta til ein annan tråd',
	'lqt_hist_merged_to' => '[[$1|Svar]] flytta frå ein annan tråd',
	'lqt_hist_split_from' => 'Kløyv av til ein ny tråd',
	'lqt_hist_root_blanked' => 'Fjerna kommentartekst',
	'lqt_hist_adjusted_sortkey' => 'Endra trådposisjon',
	'lqt_revision_as_of' => 'Versjon frå $2 ved $3.',
	'lqt_change_new_thread' => 'Dette er den første versjonen av tråden.',
	'lqt_change_reply_created' => 'Den [$1 utheva kommentaren] vart oppretta i denne versjonen.',
	'lqt_change_edited_root' => 'Den [$1 utheva kommentaren] vart endra i denne versjonen.',
	'lqt_change_edited_summary' => 'Samandraget til tråden vart endra',
	'lqt_change_deleted' => '[$1 Denne tråden] eller opphavet hans vart sletta',
	'lqt_change_undeleted' => 'Det [$1 merkte] innlegget vart attoppretta',
	'lqt_change_moved' => '[$1 Denne tråden] vart flytta til ei anna diskusjonssida',
	'lqt_change_split' => '[$1 Denne tråden] vart kløyvd frå ein annan tråd.',
	'lqt_change_edited_subject' => 'Emnet til denne tråden vart endra frå «$2» til «$3»',
	'lqt_change_merged_from' => 'Eit [$1 svar] til denne tråden vart flytta til ein annan tråd',
	'lqt_change_merged_to' => 'Det [$1 merkte svaret] vart flytta frå ein annan tråd',
	'lqt_change_split_from' => 'Ein [$1 undertråd] av denne tråden vart kløyvd av til ein eigen tråd.',
	'lqt_change_root_blanked' => 'Teksten til [$1 ein kommentar] vart fjerna.',
	'lqt_youhavenewmessages' => 'Du har [[$1|nye meldingar]].',
	'lqt_protectedfromreply' => 'Denne tråden er vorten $1 for svar.',
	'lqt_protectedfromreply_link' => 'låst',
	'lqt_subject' => 'Emne:',
	'lqt_noreason' => 'Inga grunngjeving.',
	'lqt_move_placeholder' => 'Denne tråden finst berre for å syna at tråden $1 vart flytt frå denne sida til ei anna diskusjonssida.
Flyttinga vart gjort av $2 $3 $4.',
	'lqt_thread_deleted_for_sysops' => "Denne tråden har vorten '''sletta''' og er berre synleg for administratorar.",
	'lqt_thread_deleted' => 'Denne tråden har vorten sletta.',
	'lqt_summary_notice' => 'Det har ikkje vore endringar i denne diskusjonen på minst {{PLURAL:$2|éin dag|$2 dagar}}.
Om han er slutt, vil du kanskje $1.',
	'lqt_summary_notice_link' => 'skriva eit samandrag',
	'lqt_summary_label' => 'Trådsamandrag:',
	'lqt_summary_subtitle' => 'Samandrag av «$1»',
	'lqt_nosuchrevision' => 'Det finst ikkje nokon slik versjon av denne tråden.',
	'lqt_nosuchthread' => 'Tråden du oppgav finst ikkje.',
	'lqt_nosuchthread_title' => 'Tråden finst ikkje',
	'lqt_threadrequired' => 'Du må oppgje ein tråd i adressa.',
	'lqt_move_movingthread' => 'Flyttar $1.
Denne tråden er del av $2.',
	'lqt_move_torename' => 'For å gje nytt namn til tråden, $1 og endra «Emne»-feltet.',
	'lqt_move_torename_edit' => 'endra han',
	'lqt_move_destinationtitle' => 'Tittel på måldiskusjonssida:',
	'lqt_move_move' => 'Flytt',
	'lqt_move_nodestination' => 'Du må oppgje eit mål.',
	'lqt_move_thread_bad_destination' => 'Målsida er ikkje ei diskusjonssida.',
	'lqt_move_samedestination' => 'Tråden er alt på denne sida.',
	'lqt_move_noreason' => 'Inga grunngjeving.',
	'lqt_move_success' => 'Tråden vart flytta til $1.',
	'lqt_delete_undeletethread' => 'Gjer om sletting av tråd',
	'lqt_delete_partof' => "Denne tråden er del av '''$1'''.",
	'lqt_delete_deleting' => "Slettar '''$1''' og '''alle svar''' på denne.",
	'lqt_delete_deletethread' => 'Slett tråd og svar',
	'lqt_delete_deleted' => 'Tråden vart sletta',
	'lqt_delete_undeleted' => 'Slettinga av tråden vart gjort om',
	'lqt_delete_return' => 'Attende til $1.',
	'lqt_delete_return_link' => 'diskusjonssida',
	'lqt_delete_unallowed' => 'Du kan ikkje sletta trådar.',
	'lqt_delete_show_checkbox' => 'Syn sletta trådar',
	'lqt_talkpage_autocreate_summary' => 'Diskusjonssida oppretta automatisk då fyrste tråd blei lagt inn.',
	'lqt_header_warning_big' => 'Du endrar ei $1.',
	'lqt_header_warning_after_big' => 'Hovudavsnitt er for kunngjeringar og inleiingar.
I staden vil du kanskje $2.',
	'lqt_header_warning_bold' => 'diskusjonssideinnleiing',
	'lqt_header_warning_new_discussion' => 'byrja ein ny diskusjon',
	'lqt_sorting_order' => 'Sortert etter:',
	'lqt_sort_newest_changes' => 'dei sist endra fyrst',
	'lqt_sort_newest_threads' => 'nyaste trådar fyrst',
	'lqt_sort_oldest_threads' => 'eldste trådar fyrst',
	'lqt-title' => 'Tittel',
	'lqt-summary' => 'Samandrag',
	'lqt-searching' => 'Søkjer etter trådar',
	'lqt-read-message' => 'Merk som lesen',
	'lqt-read-message-tooltip' => 'Fjern denne tråden frå nye meldingar.
Han vil halda fram med å vera synleg på den opphavlege diskusjonssida.',
	'lqt-read-all' => 'Merk alle som lesne',
	'lqt-read-all-tooltip' => 'Fjern alle trådane frå nye meldingar.
Dei vil halda fram med å vera synlege på dei opphavlege diskusjonssidene.
Denne handlinga kan ikkje verta gjort om.',
	'lqt-marked-read' => "Tråden '''$1''' er merkt som lesen.",
	'lqt-count-marked-read' => '{{PLURAL:$1|Éi melding|$1 meldingar}} er merkte som lesne.',
	'lqt-email-undo' => 'Angra',
	'lqt-no-new-messages' => 'Du har ingen nye meldingar.',
	'lqt-new-messages' => '✒ Du har nye meldingar.',
	'lqt-email-info-undo' => 'Hent attende tråden du nett fjerna.',
	'lqt-date-info' => 'Denne lenkja er deaktivert av di du ser trådar frå alle datoar.',
	'lqt-newmessages-context' => 'Heile tråden',
	'lqt-thread-created' => 'Oppretta',
	'lqt-history-time' => 'Tid',
	'lqt-history-user' => 'Brukar',
	'lqt-history-action' => 'Aktivitet',
	'lqt-history-comment' => 'Kommentar',
	'lqt-history-thread' => 'Tråd',
	'lqt-thread-edited-author' => 'Endra av forfattaren.<br />
Førre endringa: $1',
	'lqt-thread-edited-others' => 'Endra av andre brukarar',
	'lqt-header-actions' => 'Handlingar',
	'lqt_summarize_link' => 'Lag samandrag',
	'lqt-summarize-intro' => 'Du kan laga eit samandrag av tråden med wikitekst i redigeringsboksen under. Trykk på  «{{int:savearticle}}» når du er ferdig.',
	'lqt-thread-split' => 'Kløyv til ein ny tråd',
	'lqt-split-success' => 'Du har kløyvd av tråden $1.',
	'lqt_split_thread' => 'Kløyv ein tråd',
	'lqt-thread-split-subject' => 'Nytt trådemne:',
	'lqt-thread-split-thread' => 'Tråd:',
	'lqt-split-submit' => 'Kløyv',
	'lqt_split_badsubject' => 'Emnet du skreiv inn er ugyldig.',
	'lqt-no-threads' => 'Det finst ingen trådar på denne sida enno.',
	'lqt-delete-parent-warning' => 'Dette er ein toppnivå-tråd med svar.
Svara vil automatisk verta sletta med tråden.
For å unngå dette, kan du kløyva av svara før du slettar tråden.',
	'lqt-delete-parent-deleted' => 'Foreldretråd sletta ($1)',
	'lqt-delete-replies-done' => 'Alle svara i denne tråden vart òg sletta.',
	'lqt-movethread' => 'Flytt',
	'lqt-menu-trigger' => 'Meir',
	'lqt-newmessages-from' => 'Frå $1',
	'lqt-hot-topics' => 'Populære emne',
	'lqt-add-reply' => 'Skriv svar',
	'lqt_rc_new_discussion' => 'starta den nye tråden «$1»',
	'lqt_rc_new_reply' => 'skreiv eit svar til «$1»',
	'right-lqt-split' => 'Kløyva trådar',
	'right-lqt-merge' => 'Fletta trådar',
	'lqt-thread-merge' => 'Flett saman med ein annan tråd',
	'lqt-thread-merge-to' => 'Flett inn i denne tråden',
	'lqt_merge_thread' => 'Flett saman tråd',
	'lqt-thread-merge-source' => 'Kjeldetråd:',
	'lqt-thread-merge-dest' => 'Måltråd:',
	'lqt-merge-submit' => 'Flett',
	'lqt-log-name' => 'Tråda diskusjonslogg',
	'lqt-log-header' => 'Denne loggen innheld handlingar gjorde på diskusjonstrådar.',
	'lqt-log-action-move' => 'flytta [[$1]] frå [[$2]] til [[$3]].',
	'lqt-log-action-split' => 'kløyvde av [[$1]] frå under [[$3]] med det nye emnet «$2»',
	'lqt-log-action-merge-across' => 'flytta [[$1]] frå under [[$2]] til under [[$3]]',
	'lqt-log-action-merge-down' => 'fletta [[$1]] til under [[$3]]',
	'lqt-log-action-subjectedit' => 'endra emnet til [[$1]] frå «$2» til «$3»',
	'lqt-log-action-resort' => 'endra sorteringsrekkefylgja til [[$1]]. Endra sorteringsnøkkel frå $2 til $3',
	'lqt-preference-notify-talk' => 'Send meg e-post når det vert lagt til svar i trådar som eg overvakar',
	'lqt-preference-watch-threads' => 'Overvak trådar som eg opprettar eller svarar på',
	'prefs-lqt' => 'Tråda diskusjon',
	'lqt-preference-display-depth' => 'Vis ei maksimal svardjupn på:',
	'lqt-preference-display-count' => 'Høgaste talet på meldingar som vert viste:',
	'lqt-preference-custom-signatures' => 'Vis eigendefinerte brukarsignaturar',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-diskusjon - Svar: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-diskusjon - Ny tråd: $1',
	'lqt-enotif-reply' => 'Hei $1,
dette er eit varsel frå {{SITENAME}} om at det vart oppretta eit svar til «$2» på $5 den $3 kl. $4.

Du kan lesa svaret på <$6>',
	'lqt-quote-intro' => 'Den $2 kl. $3 skreiv [[User:$1|$1]]:',
	'lqt-search-legend' => 'Søk i diskusjonar på denne sida',
	'lqt-search-label' => 'Søkjeord:',
	'lqt-search-button' => 'Søk',
	'searchprofile-threads' => 'Diskusjonar',
	'searchprofile-threads-tooltip' => 'Søk i tråda diskusjonar og diskusjonssider',
	'lqt-ajax-updated' => 'Denne tråden har nye innlegg.',
	'lqt-ajax-update-link' => 'Oppdater',
	'lqt-thread-show-replies' => 'Vis {{PLURAL:$1|eitt svar|$1 svar}}',
	'lqt-thread-show-more' => 'Vis fleire svar',
	'lqt-thread-link-url' => 'Lenkje-URL:',
	'lqt-thread-link-copy' => 'Kopier til utklipsstavla',
	'lqt-sign-not-necessary' => 'Det ikkje turvande at du signerer innlegget ditt med fire tildar. Signaturen kjem av seg sjølv.',
	'lqt-marked-as-read-placeholder' => 'Tråden «$1» vart merkt som lesen.',
	'lqt-change-subject' => 'Endra emne',
	'lqt-save-subject' => 'Lagra',
	'lqt-save-subject-failed' => 'Den fylgjande feilen oppsto under endringa av trådemnet: $1',
	'lqt-ajax-invalid-subject' => 'Du oppgav eit ugyldig emne. Sannsynlegvis var det for langt.',
	'lqt-ajax-no-subject' => 'Du er nøydd til å oppgje eit emne.',
	'lqt-cancel-subject-edit' => 'Avbryt',
	'lqt-drag-activate' => 'Dra til ny plassering',
	'lqt-drag-drop-zone' => 'Slepp her',
	'lqt-drag-save' => 'Stadfest',
	'lqt-drag-reason' => 'Årsak:',
	'lqt-drag-subject' => 'Emne for ny tråd:',
	'lqt-edit-signature' => '(endra signatur)',
	'lqt-preview-signature' => '(førehandsvis)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nye innlegg',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nye innlegg frå $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nye trådar',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nye trådar frå $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Svar',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Svar frå $1',
	'lqt-feed-new-thread-intro' => 'Ny tråd på $1 oppretta av $2',
	'lqt-newmessages-n' => 'Nye meldingar ($1)',
	'lqt_newmessages' => 'Nye meldingar (ingen)',
	'lqt_newmessages-title' => 'Nye meldingar',
	'lqt-newpost-summary' => 'Ny tråd: $1',
	'lqt-reply-summary' => 'Svar på [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Diskusjonssidehistorikk',
	'lqt-talkpage-history-subtitle' => 'For $1',
	'restriction-reply' => 'Skriva svar',
	'restriction-newthread' => 'Oppretta nye trådar',
	'lqt-edit-bump' => 'Flytt denne tråden opp',
	'lqt-edit-bump-tooltip' => 'Flytt tråden til toppen av diskusjonssida hans',
	'lqt-reply-subpage' => 'svar',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Harald Khan
 * @author Jon Harald Søby
 * @author Laaknor
 * @author Nghtwlkr
 */
$messages['no'] = array(
	'lqt-desc' => 'Legger til trådede diskusjoner til diskusjonssider',
	'lqt_movethread' => 'Flytt tråd til en annen side',
	'lqt_deletethread' => 'Slett eller gjenopprett tråd',
	'lqt_contents_title' => 'Innhold',
	'lqt_toc_thread_title' => 'Tittel på tråd',
	'lqt_toc_thread_author' => 'Startet av',
	'lqt_toc_thread_replycount' => 'Svar',
	'lqt_toc_thread_modified' => 'Sist endret',
	'lqt_add_header' => 'Legg til hodeseksjon',
	'lqt_new_thread' => 'Start en ny diskusjon',
	'lqt_invalid_subject' => 'Emnet du skrev inn er ugyldig.
Det kan:
* Være for langt, eller
* Være i konflikt med andre interwikiprefiks eller navneromnavn.',
	'lqt_empty_subject' => 'Du må oppgi et emne.',
	'lqt_reply' => 'Svar',
	'lqt-parent' => 'Forelder',
	'lqt_delete' => 'Slett',
	'lqt_undelete' => 'Gjenopprett',
	'lqt_permalink' => 'Lenk til dette',
	'lqt_fragment' => 'Fragment av $1 fra $2',
	'lqt_discussion_link' => 'diskusjon',
	'lqt_from_talk' => 'Fra $1',
	'lqt-history-title' => 'Trådhistorikk',
	'lqt_hist_comment_edited' => 'Kommentartekst [$2 endret]',
	'lqt_hist_summary_changed' => 'Sammendrag endret',
	'lqt_hist_reply_created' => '[[$1|Nytt svar]] opprettet',
	'lqt_hist_thread_created' => 'Ny tråd opprettet',
	'lqt_hist_deleted' => 'Slettet',
	'lqt_hist_undeleted' => 'Gjenopprettet',
	'lqt_hist_moved_talkpage' => 'Flyttet',
	'lqt_hist_listing_subtitle' => 'Ser på en historikkliste',
	'lqt_hist_view_whole_thread' => 'Se historikken for hele tråden',
	'lqt_hist_no_revisions_error' => 'Denne tråden har ingen revisjoner.',
	'lqt_hist_past_last_page_error' => 'Det finnes ingen flere sider med historikk.',
	'lqt_hist_tooltip_newer_disabled' => 'Denne lenken er slått av fordi du er på den første siden.',
	'lqt_hist_tooltip_older_disabled' => 'Denne lenken er slått av fordi du er på den siste siden.',
	'lqt_hist_split' => 'Svar delt til en ny tråd',
	'lqt_hist_edited_subject' => 'Endret tittel fra «$2» til «$3»',
	'lqt_hist_edited_subject_corrupt' => 'Endret tittel',
	'lqt_hist_merged_from' => '[[$1|Svar]] flyttet til en annen tråd',
	'lqt_hist_merged_to' => '[[$1|Svar]] flyttet fra en annen tråd',
	'lqt_hist_split_from' => 'Del til en ny tråd',
	'lqt_hist_root_blanked' => 'Fjernet kommentartekst',
	'lqt_hist_adjusted_sortkey' => 'Justerte trådposisjon',
	'lqt_revision_as_of' => 'Versjon fra $2, klokka $3',
	'lqt_change_new_thread' => 'Dette er trådens første revisjon.',
	'lqt_change_reply_created' => 'Den [$1 markerte kommentaren] ble opprettet i denne revisjonen.',
	'lqt_change_edited_root' => 'Den [$1 markerte kommentaren] ble redigert i denne revisjonen.',
	'lqt_change_edited_summary' => 'Trådens sammendrag ble endret',
	'lqt_change_deleted' => '[$1 Denne tråden] eller dens opphav ble slettet',
	'lqt_change_undeleted' => 'Det [$1 merkede innlegget] ble gjenopprettet',
	'lqt_change_moved' => '[$1 Denne tråden] ble flyttet til en annen diskusjonsside',
	'lqt_change_split' => '[$1 Denne tråden] ble splittet fra en annen tråd',
	'lqt_change_edited_subject' => 'Tittelen på tråden ble endret fra «$2» til «$3»',
	'lqt_change_merged_from' => 'Et [$1 svar] på denne tråden ble flyttet til en annen tråd',
	'lqt_change_merged_to' => 'Det [$1 merkede svaret] ble flyttet fra en annen tråd',
	'lqt_change_split_from' => 'En [$1 undertråd] av denne tråden ble splittet ut til sin egen tråd',
	'lqt_change_root_blanked' => 'Teksten til [$1 en kommentar] ble fjernet.',
	'lqt_youhavenewmessages' => 'Du har [[$1|nye beskjeder]].',
	'lqt_protectedfromreply' => 'Denne tråden har blitt $1 for svar.',
	'lqt_protectedfromreply_link' => 'låst',
	'lqt_subject' => 'Emne:',
	'lqt_noreason' => 'Ingen grunn gitt.',
	'lqt_move_placeholder' => 'Denne tråden eksisterer kun for å vise at tråden $1 ble flyttet fra denne siden til en annen diskusjonsside. 
Denne flyttingen ble foretatt av $2 $3 $4.
Denne tråden ligger nå på $5',
	'lqt_thread_deleted_for_sysops' => "Denne tråden har blitt '''slettet''' og er kun synlig for administratorer.",
	'lqt_thread_deleted' => 'Denne tråden har blitt slettet.',
	'lqt_summary_notice' => 'Det har ikke vært noen endringer på denne diskusjonssiden på minst {{PLURAL:$2|én dag|$2 dager}}.
Om den er avsluttet vil du kanskje $1.',
	'lqt_summary_notice_link' => 'skrive et sammendrag',
	'lqt_summary_label' => 'Sammendrag av tråd:',
	'lqt_summary_subtitle' => 'Sammendrag av «$1»',
	'lqt_nosuchrevision' => 'Det er ingen slik revisjon av denne tråden.',
	'lqt_nosuchthread' => 'Tråden du spesifiserte finnes ikke.',
	'lqt_nosuchthread_title' => 'Ingen slik tråd',
	'lqt_threadrequired' => 'Du må angi en tråd i URL-en.',
	'lqt_move_movingthread' => 'Flytter $1. Denne tråden er del av $2.',
	'lqt_move_torename' => 'For å omdøpe denne tråden, $1 og endre «Emne»-feltet.',
	'lqt_move_torename_edit' => 'rediger den',
	'lqt_move_destinationtitle' => 'Tittel på måldiskusjonsside:',
	'lqt_move_move' => 'Flytt',
	'lqt_move_nodestination' => 'Du må angi et mål.',
	'lqt_move_thread_bad_destination' => 'Målsiden er ikke en diskusjonsside.',
	'lqt_move_samedestination' => 'Tråden er allerede på denne siden!',
	'lqt_move_noreason' => 'Ingen grunn gitt.',
	'lqt_move_success' => 'Denne tråden ble flyttet til $1.',
	'lqt_delete_undeletethread' => 'Gjenopprett tråd',
	'lqt_delete_partof' => "Denne tråden er del av '''$1'''.",
	'lqt_delete_deleting' => "Sletter '''$1''' og '''alle svar''' på den.",
	'lqt_delete_deletethread' => 'Slett tråd og svar',
	'lqt_delete_deleted' => 'Tråden ble slettet.',
	'lqt_delete_undeleted' => 'Tråden ble gjenopprettet.',
	'lqt_delete_return' => 'Tilbake til $1.',
	'lqt_delete_return_link' => 'diskusjonssiden',
	'lqt_delete_unallowed' => 'Du kan ikke slette tråder.',
	'lqt_delete_show_checkbox' => 'Vis slettede tråder',
	'lqt_talkpage_autocreate_summary' => 'Diskusjonsside opprettet automatisk da første tråd ble postet.',
	'lqt_header_warning_big' => 'Du redigerer en $1.',
	'lqt_header_warning_after_big' => 'Hodeseksjoner er for annonseringer og innledninger. Du vil muligens i stedet $2.',
	'lqt_header_warning_bold' => 'diskusjonssideinnledning',
	'lqt_header_warning_new_discussion' => 'start en ny diskusjon',
	'lqt_sorting_order' => 'Sorteringsrekkefølge:',
	'lqt_sort_newest_changes' => 'de sist endrede først',
	'lqt_sort_newest_threads' => 'nyeste tråder først',
	'lqt_sort_oldest_threads' => 'eldste tråder først',
	'lqt-title' => 'Tittel',
	'lqt-summary' => 'Sammendrag',
	'lqt-searching' => 'Søk etter tråder',
	'lqt-read-message' => 'Marker som lest',
	'lqt-read-message-tooltip' => 'Fjern denne tråden fra nye beskjeder.
Den vil fortsatt være synlig fra dens opprinnelige diskusjonsside.',
	'lqt-read-all' => 'Merk alle som leste',
	'lqt-read-all-tooltip' => 'Fjern alle trådene fra nye meldinger.
De vil fortsatt være synlige fra deres opprinnelige diskusjonssider.
Denne handlingen kan ikke gjøres om.',
	'lqt-marked-read' => "Tråden '''$1''' markert lest.",
	'lqt-count-marked-read' => '{{PLURAL:$1|Én beskjed|$1 beskjeder}} markert lest.',
	'lqt-email-undo' => 'Angre',
	'lqt-no-new-messages' => 'Du har ingen nye meldinger.',
	'lqt-new-messages' => '✒ Du har nye beskjeder.',
	'lqt-email-info-undo' => 'Hent igjen tråden du nettopp fjernet.',
	'lqt-date-info' => 'Denne lenken er slått av fordi du ser tråder fra alle datoer.',
	'lqt-newmessages-context' => 'Hele tråden',
	'lqt-thread-created' => 'Opprettet',
	'lqt-history-time' => 'Tid',
	'lqt-history-user' => 'Bruker',
	'lqt-history-action' => 'Aktivitet',
	'lqt-history-comment' => 'Kommentar',
	'lqt-history-thread' => 'Tråd',
	'lqt-thread-edited-author' => 'Redigert av opphavsperson.<br />
Forrige endring: $1',
	'lqt-thread-edited-others' => 'Redigert av {{PLURAL:$2|en annen bruker|$2 andre brukere}}.<br />
Siste endring: $1',
	'lqt-header-actions' => 'Handlinger',
	'lqt_summarize_link' => 'Lag sammendrag',
	'lqt-summarize-intro' => 'Du kan oppsummere denne tråden i redigeringsboksen.
Du kan bruke all wikitekst i oppsummeringen din.
Når du er ferdig, trykk «{{int:savearticle}}».',
	'lqt-thread-split' => 'Del opp til en ny tråd',
	'lqt-split-success' => 'Du har delt opp tråden $1.',
	'lqt_split_thread' => 'Del en tråd i to',
	'lqt-thread-split-subject' => 'Ny trådtittel:',
	'lqt-thread-split-thread' => 'Tråd:',
	'lqt-split-submit' => 'Del',
	'lqt_split_badsubject' => 'Tittelen du skrev inn er ugyldig',
	'lqt-no-threads' => 'Det er ingen tråder på denne siden ennå.',
	'lqt-delete-parent-warning' => 'Dette er en toppnivå-tråd med svar.
Svarene vil også bli slettet automatisk.
For å unngå dette, del svarene fra denne tråden før du sletter den.',
	'lqt-delete-parent-deleted' => 'Foreldretråd slettet ($1)',
	'lqt-delete-replies-done' => 'Alle svar på denne tråden ble også slettet.',
	'lqt-movethread' => 'Flytt',
	'lqt-menu-trigger' => 'Mer',
	'lqt-newmessages-from' => 'Fra $1',
	'lqt-hot-topics' => 'Populære emner',
	'lqt-add-reply' => 'Legg til svar',
	'lqt_rc_new_discussion' => 'postet en ny tråd, «$1»',
	'lqt_rc_new_reply' => 'postet et svar til «$1»',
	'right-lqt-split' => 'Del tråder',
	'right-lqt-merge' => 'Slå sammen tråder',
	'lqt-thread-merge' => 'Slå sammen med annen tråd',
	'lqt-thread-merge-to' => 'Slå sammen med denne tråden',
	'lqt_merge_thread' => 'Slå sammen tråd',
	'lqt-thread-merge-source' => 'Kildetråd:',
	'lqt-thread-merge-dest' => 'Måltråd:',
	'lqt-merge-submit' => 'Slå sammen',
	'lqt-merge-success' => 'Du har slått sammen tråden $1 til $2',
	'lqt-log-name' => 'Trådet diskusjonslogg',
	'lqt-log-header' => 'Denne loggen detaljerer hendelser foretatt på diskusjonstråder.',
	'lqt-log-action-move' => 'flyttet [[$1]] fra [[$2]] til [[$3]].',
	'lqt-log-action-split' => 'delte [[$1]] fra under [[$3]] med det nye emnet «$2»',
	'lqt-log-action-merge-across' => 'flyttet [[$1]] fra under [[$2]] til under [[$3]]',
	'lqt-log-action-merge-down' => 'flettet [[$1]] til under [[$3]]',
	'lqt-log-action-subjectedit' => 'endret emnet til [[$1]] fra «$2» til «$3»',
	'lqt-log-action-resort' => 'endret sorteringsrekkefølgen av [[$1]]. Endret sorteringsnøkkel fra $2 til $3',
	'lqt-preference-notify-talk' => 'Varsle meg på e-post når noen svarer på en tråd jeg overvåker',
	'lqt-preference-watch-threads' => 'Overvåk tråder jeg oppretter eller svarer på',
	'prefs-lqt' => 'Trådet diskusjon',
	'lqt-preference-display-depth' => 'Maksimal svardybde å vise:',
	'lqt-preference-display-count' => 'Maksmalt antall svar å vise:',
	'lqt-preference-custom-signatures' => 'Vis egendefinerte signaturer',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-diskusjon - Svar: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-diskusjon - Ny tråd: $1',
	'lqt-enotif-newthread' => "Hei $1,

Dette er et varsel fra {{SITENAME}} om at en ny tråd på $5, '$2',
ble opprettet den $3 klokka $4 av $8

Du kan se den på <$6>

Teksten er:
$7",
	'lqt-enotif-reply' => "Hei $1.

Dette er et varsel fra {{SITENAME}} om at et nytt svar til '$2' på $5,
ble opprettet den $3 klokka $4 av $8

Du kan se den på <$6>

Teksten i svaret er:
$7",
	'lqt-quote-intro' => 'Den $2 klokka $3 skrev [[User:$1|$1]]:',
	'lqt-quote' => 'Siter',
	'lqt-search-legend' => 'Søk i diskusjoner på denne siden',
	'lqt-search-label' => 'Søkeord:',
	'lqt-search-button' => 'Søk',
	'searchprofile-threads' => 'Diskusjoner',
	'searchprofile-threads-tooltip' => 'Søk trådede diskusjoner og diskusjonssider',
	'lqt-ajax-updated' => 'Denne tråden har nye innlegg.',
	'lqt-ajax-update-link' => 'Oppdater',
	'lqt-thread-show-replies' => 'Vis $1 {{PLURAL:$1|svar}}',
	'lqt-thread-show-more' => 'Vis flere svar',
	'lqt-thread-link-url' => 'URL:',
	'lqt-thread-link-title' => 'Wikitekstlenke:',
	'lqt-thread-link-copy' => 'Kopier til utklippstavle',
	'lqt-sign-not-necessary' => 'Det er ikke nødvendig å signere innleggene dine med fire tilder.
Signaturen vises automatisk.',
	'lqt-marked-as-read-placeholder' => 'Tråden $1 er markert som lest.',
	'lqt-change-subject' => 'Endre tittel',
	'lqt-save-subject' => 'Lagre',
	'lqt-save-subject-failed' => 'Følgende feil oppsto ved endring av emnet på tråden: $1',
	'lqt-ajax-invalid-subject' => 'Emnet du oppga var ugyldig, sannsynligvis fordi det var for langt.',
	'lqt-ajax-no-subject' => 'Du må spesifisere et emne.',
	'lqt-save-subject-error-unknown' => 'En ukjent feil oppsto mens man forsøkte å sette emne på denne tråden. Forsøk igjen ved å trykke på «rediger» på toppen av innlegget.',
	'lqt-cancel-subject-edit' => 'Avbryt',
	'lqt-drag-activate' => 'Dra til ny plassering',
	'lqt-drag-drop-zone' => 'Slipp her',
	'lqt-drag-confirm' => 'For å gjøre disse handlingene, fyll inn en grunn og trykk «Bekreft».',
	'lqt-drag-reparent' => 'Flytt posten til under en ny foresatt.',
	'lqt-drag-split' => 'Flytt innlegg til sin egen tråd',
	'lqt-drag-setsortkey' => 'Juster postens posisjon på siden',
	'lqt-drag-bump' => 'Flytt innlegg til toppen av diskusjonssiden',
	'lqt-drag-save' => 'Bekreft',
	'lqt-drag-title' => 'Bekreft draget',
	'lqt-drag-reason' => 'Årsak:',
	'lqt-drag-subject' => 'Emne for ny tråd:',
	'lqt-edit-signature' => '(endre signatur)',
	'lqt-preview-signature' => '(forhåndsvis)',
	'lqt-feed-title-all' => '{{SITENAME}} – Nye innlegg',
	'lqt-feed-title-all-from' => '{{SITENAME}} – Nye innlegg fra $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – Nye tråder',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – Nye tråder fra $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – Svar',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – Svar fra $1',
	'lqt-feed-new-thread-intro' => 'Ny tråd på $1 postet av $2',
	'lqt-feed-reply-intro' => 'Svar til $3 (på $1) postet av $2',
	'tooltip-pt-newmessages' => 'Viser nye innlegg i tråder eller i trådete diskusjonssider som du overvåker',
	'lqt-newmessages-n' => 'Nye meldinger ($1)',
	'lqt_newmessages' => 'Nye meldinger (Ingen)',
	'lqt_newmessages-title' => 'Nye meldinger',
	'lqt-newpost-summary' => 'Ny tråd: $1',
	'lqt-reply-summary' => 'Svar på [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Diskusjonssidehistorikk',
	'lqt-talkpage-history-subtitle' => 'For $1',
	'lqt-talkpage-history-tab' => 'Emne',
	'restriction-reply' => 'Skrive svar',
	'restriction-newthread' => 'Skrive nye tråder',
	'lqt-protected-reply-thread' => 'Du kan ikke skrive i denne tråden fordi den har blitt beskyttet mot nye innlegg.',
	'lqt-protected-reply-talkpage' => 'Du kan ikke skrive i denne tråden, fordi denne diskusjonssiden har blitt låst mot flere svar til innleggene.',
	'lqt-protected-newthread' => 'Du kan ikke skrive nye tråder på denne diskusjonssiden, fordi den har blitt låst mot nye innlegg.',
	'lqt-edit-bump' => 'Knuff denne tråden',
	'lqt-edit-bump-tooltip' => 'Flytt denne tråden til toppen av dens diskusjonsside',
	'lqt-historicalrevision-error' => 'Revisjonen du har valgt er korrupt, og kan ikke vises.',
	'lqt-reply-subpage' => 'svar',
	'nstab-thread' => 'Tråd',
	'nstab-summary' => 'Sammendrag',
);

/** Northern Sotho (Sesotho sa Leboa)
 * @author Mohau
 */
$messages['nso'] = array(
	'lqt_delete' => 'Phumula',
	'lqt_youhavenewmessages' => 'O nale $1.',
	'lqt_subject' => 'Tabataba:',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'lqt-desc' => 'Apond de fials de discussion dins las paginas de discussion',
	'lqt_movethread' => 'Desplaçar lo fial cap a una autra pagina',
	'lqt_deletethread' => 'Escafar o recuperar lo fial',
	'lqt_contents_title' => 'Taula dels subjèctes',
	'lqt_toc_thread_title' => 'Títol del fial',
	'lqt_toc_thread_author' => 'Aviat per',
	'lqt_toc_thread_replycount' => 'Responsas',
	'lqt_toc_thread_modified' => 'Darrièra modificacion',
	'lqt_add_header' => 'Apondre una entèsta',
	'lqt_new_thread' => 'Amodar una discussion novèla',
	'lqt_invalid_subject' => "Lo subjècte qu'avètz picat es invalid. Es possible :
* que siá tròp long o
* siá en conflicte amb un prefix interwiki, o un espaci de noms.",
	'lqt_empty_subject' => 'Vos cal entrar un objècte.',
	'lqt_reply' => 'Respondre',
	'lqt_delete' => 'Escafar',
	'lqt_undelete' => 'Recuperar',
	'lqt_permalink' => 'Ligam cap a',
	'lqt_fragment' => "Fragment d'una $1 sus $2",
	'lqt_discussion_link' => 'discussion',
	'lqt_from_talk' => 'De $1',
	'lqt-history-title' => 'Istoric del fial',
	'lqt_hist_comment_edited' => 'Comentari modificat',
	'lqt_hist_summary_changed' => 'Somari modificat',
	'lqt_hist_reply_created' => 'Responsa novèla creada',
	'lqt_hist_thread_created' => 'Fial novèl creat',
	'lqt_hist_deleted' => 'Escafat',
	'lqt_hist_undeleted' => 'Recuperat',
	'lqt_hist_moved_talkpage' => 'Desplaçat',
	'lqt_hist_listing_subtitle' => 'Visualizar un istoric',
	'lqt_hist_view_whole_thread' => "Veire l'istoric de tot lo fial",
	'lqt_hist_no_revisions_error' => "Aqueste fial a pas d'istoric de revisions.",
	'lqt_hist_past_last_page_error' => "Avètz depassat lo nombre de paginas de l'istoric.",
	'lqt_hist_tooltip_newer_disabled' => 'Aqueste ligam es inactiu perque sètz sus la primièra pagina.',
	'lqt_hist_tooltip_older_disabled' => 'Aqueste ligam es inactiu perque sètz sus la darrièra pagina.',
	'lqt_hist_split' => 'Responsa separada dins un fial de discussion novèl',
	'lqt_hist_edited_subject' => 'Subjècte modificat',
	'lqt_hist_merged_from' => 'Responsa desplaçada dins un autre fial de discussion',
	'lqt_hist_merged_to' => 'Responsa desplaçada dempuèi un autre fial de discussion',
	'lqt_hist_split_from' => 'Separar cap a un fial de discussion novèl',
	'lqt_hist_root_blanked' => 'Tèxte de comentari suprimit',
	'lqt_revision_as_of' => 'Revision en data del $2 a $3.',
	'lqt_change_new_thread' => 'Es la primièra revision del fial.',
	'lqt_change_reply_created' => 'Lo [$1 comentari en susbrilhança] es estat creat dins aquesta revision.',
	'lqt_change_edited_root' => 'Lo [$1 comentari en susbrilhança] es estat modificat dins aquesta revision.',
	'lqt_change_edited_summary' => 'Lo resumit del fial de discussion es estat modificat',
	'lqt_change_deleted' => '[$1 Aqueste fial de discussion] o una responsa a aqueste es estat suprimit',
	'lqt_change_undeleted' => 'Lo [$1 post mes en susbrilhança] es estat restablit',
	'lqt_change_moved' => '[$1 Aqueste fial de discussion] es estat desplaçat cap a una autra pagina de discussion',
	'lqt_change_split' => "[$1 Aqueste fial de discussion] es estat separat d'un autre fial de discussion",
	'lqt_change_merged_from' => 'Una [$1 responsa] a aqueste fial de discussion es estada desplaçada cap a un autre fial de discussion',
	'lqt_change_merged_to' => 'La [$1 responsa mesa en susbrilhança] es estada desplaçada dempuèi un autre fial de discussion',
	'lqt_change_split_from' => "Una [$1 sosbranca] d'aqueste fial de discussion es estada separada dins son pròpri fial de discussion",
	'lqt_change_root_blanked' => "Lo tèxte d'[$1 un comentari] es estat suprimit.",
	'lqt_youhavenewmessages' => 'Avètz [[$1|messatges novèls]].',
	'lqt_protectedfromreply' => 'Aqueste fial es estat $1. I podètz pas respondre.',
	'lqt_protectedfromreply_link' => 'protegit',
	'lqt_subject' => 'Subjècte :',
	'lqt_noreason' => 'Cap de motiu balhat',
	'lqt_move_placeholder' => "Aqueste fial es una marca substitutiva qu'indica qu'un fial, $1, es estat desplaçat d'aquesta pagina.
Aqueste desplaçament es estat fach per $2 a $3 $4. Lo fial se tròba ara a $5.",
	'lqt_thread_deleted_for_sysops' => "Aqueste fial es estat '''suprimit''' e sols los administrators o pòdon veire.",
	'lqt_thread_deleted' => 'Aqueste fial es estat escafat.',
	'lqt_summary_notice' => 'I a pas agut cap de cambiament dins aquesta discussion dempuèi almens $2 {{PLURAL:$2|jorn|jorns}}. Se es estada concluïda, podètz aver besonh de $1.',
	'lqt_summary_notice_link' => 'escriure un resumit',
	'lqt_summary_label' => 'Aqueste fial es estat resumit per :',
	'lqt_summary_subtitle' => 'Resumit de $1.',
	'lqt_nosuchrevision' => 'Cap de revision per aqueste fial correspond pas.',
	'lqt_nosuchthread' => "Lo fial qu'avètz especificat existís pas.",
	'lqt_nosuchthread_title' => 'Lo fial es introbable',
	'lqt_threadrequired' => "Vos cal indicar un fial dins l'URL.",
	'lqt_move_movingthread' => '$1 en deplaçament. Aqueste fial fa partida de $2.',
	'lqt_move_torename' => "Per tornar nomenar aqueste fial, $1 e modificar lo camp ''Subjècte''.",
	'lqt_move_torename_edit' => 'lo modificar',
	'lqt_move_destinationtitle' => 'Títol de la pagina de discussion finala :',
	'lqt_move_move' => 'Desplaçar',
	'lqt_move_nodestination' => 'Vos cal indicar una destinacion.',
	'lqt_move_thread_bad_destination' => 'La pagina de destinacion es pas una pagina de discussion.',
	'lqt_move_samedestination' => 'Lo fial ja es sus aquesta pagina !',
	'lqt_move_noreason' => 'Cap de rason balhada',
	'lqt_move_success' => 'Lo fial es estat desplaçat dins $1.',
	'lqt_delete_undeletethread' => 'Fial recuperat',
	'lqt_delete_partof' => "Aqueste fial fa partida de '''$1'''.",
	'lqt_delete_deleting' => "Supression del fial '''$1''' e de '''totas las responsas''' associadas.",
	'lqt_delete_deletethread' => 'Escafar lo fial e respondre',
	'lqt_delete_deleted' => 'Lo fial es estat escafat.',
	'lqt_delete_undeleted' => 'Lo fial es estat recuperat.',
	'lqt_delete_return' => 'Tornar a $1',
	'lqt_delete_return_link' => 'la pagina de discussion',
	'lqt_delete_unallowed' => 'Avètz pas los dreches per escafar de fials.',
	'lqt_delete_show_checkbox' => 'Afichar los fials suprimits',
	'lqt_talkpage_autocreate_summary' => 'Pagina de discussion creada automaticament quand lo primièr fial de discussion es estat mandat.',
	'lqt_header_warning_big' => 'Modificatz un $1.',
	'lqt_header_warning_after_big' => 'Las entèstas son pels anoncis e las prefàcias. Deuriatz a la plaça $2.',
	'lqt_header_warning_bold' => "Entèsta d'una pagina de discussion",
	'lqt_header_warning_new_discussion' => 'amodar un fial de discussion novèl',
	'lqt_sorting_order' => 'Òrdre de triada :',
	'lqt_sort_newest_changes' => 'darrièr modificat en primièr',
	'lqt_sort_newest_threads' => 'Los fials de discussion mai recents en primièr',
	'lqt_sort_oldest_threads' => 'Los fials de discussion mai ancians en primièr',
	'lqt-title' => 'Títol',
	'lqt-summary' => 'Resumit',
	'lqt-searching' => 'Recèrca dels fials de discussion',
	'lqt-read-message' => 'Marcar coma legit',
	'lqt-read-message-tooltip' => 'Levar aqueste fial dels messatges novèls.
Serà encara visible dins sa pagina de discussion originala.',
	'lqt-read-all' => 'Marcar tot coma legit',
	'lqt-read-all-tooltip' => 'Levar totes los fials dels messatges novèls.
Seràn encara visibles sus lor pagina de discussion originala.
Aquesta operacion es irreversibla.',
	'lqt-marked-read' => "Fial de discussion '''$1''' marcat coma legit.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|messatge marcat coma legit|messatges marcats coma legits}}',
	'lqt-email-undo' => 'Desfar',
	'lqt-no-new-messages' => 'I a pas cap de messatge per vos.',
	'lqt-new-messages' => '✒ Avètz de messatges novèls.',
	'lqt-email-info-undo' => 'Restablir lo fial que venètz de levar.',
	'lqt-date-info' => 'Aqueste ligam es desactivat perque sètz a veire los fials a partir de totas las datas.',
	'lqt-newmessages-context' => 'Fial complet',
	'lqt-thread-created' => 'Creat',
	'lqt-history-time' => 'Data',
	'lqt-history-user' => 'Utilizaire',
	'lqt-history-action' => 'Activitat',
	'lqt-history-comment' => 'Comentari',
	'lqt-history-thread' => 'Fial de discussion',
	'lqt-thread-edited-author' => 'Editat per l’autor',
	'lqt-thread-edited-others' => 'Editat per d’autres utilizaires',
	'lqt-header-actions' => 'Accions',
	'lqt_summarize_link' => 'Resumit',
	'lqt-summarize-intro' => 'Resumir lo subjècte çaisús dins la bóstia d’edicion
Podètz utilizar un tèxte wiki quin que siá dins vòstre resumit. Quand avètz acabat, clicatz sus « {{int: Savearticle}}» .',
	'lqt-thread-split' => 'Separar cap a un fial novèl',
	'lqt-split-success' => 'Avètz separat amb succès lo fial $1.',
	'lqt_split_thread' => 'Separar un fial',
	'lqt-thread-split-subject' => 'Subjècte del fial novèl :',
	'lqt-thread-split-thread' => 'Fial :',
	'lqt-split-submit' => 'Separar',
	'lqt_split_badsubject' => "Lo subjècte qu'avètz picat es invalid.",
	'lqt-no-threads' => 'I a pas encara de fial de discussion sus aquesta pagina.',
	'lqt-delete-parent-warning' => "Aquò es un fial de discussion de naut nivèl que conten de responsas.
Sas responsas seràn tanben suprimidas automaticament.
Per evitar aquò, separatz-los d'aqueste fial de discussion abans de suprimir aqueste.",
	'lqt-delete-parent-deleted' => 'Fial de discussion parent suprimit ($1)',
	'lqt-delete-replies-done' => 'Totas las responsas a aqueste fial de discussion tanben son estadas suprimidas.',
	'lqt-movethread' => 'Desplaçar',
	'lqt-menu-trigger' => 'Mai',
	'lqt-newmessages-from' => 'Dempuèi $1',
	'lqt-hot-topics' => 'Subjèctes brutlants',
	'lqt_rc_new_discussion' => 'Discussion novèla « $1 » sus $2. • $3 escriu :',
	'lqt_rc_new_reply' => 'Respondre a « $1 » sus $2 • $3 escriu :',
	'right-lqt-split' => 'Separar los fials de discussion',
	'right-lqt-merge' => 'Fusionar los fials de discussion',
	'lqt-thread-merge' => 'Fusionar dins un autre fial',
	'lqt-thread-merge-to' => 'Fusionar dins aqueste fial',
	'lqt_merge_thread' => 'Fusionar lo fial',
	'lqt-thread-merge-source' => 'Fial font :',
	'lqt-thread-merge-dest' => 'Fial de destinacion :',
	'lqt-merge-submit' => 'Fusionar',
	'lqt-merge-success' => 'Avètz fusionat lo fial de discussion $1 dins $2.',
	'lqt-log-name' => 'Jornal dels fials de discussion',
	'lqt-log-header' => 'Aqueste jornal detalha las accions fachas suls fials de discussion.',
	'lqt-log-action-move' => 'a desplaçat [[$1]] de [[$2]] cap a [[$3]].',
	'lqt-preference-notify-talk' => "M’avisar per corrièr electronic al moment d'una responsa sus un subjècte que segueissi",
	'lqt-preference-watch-threads' => 'Seguir los fials de discussion que crèi o als quals participi',
	'prefs-lqt' => 'Discussions en fial',
	'lqt-preference-display-depth' => "Prigondor maximala de las responsas d'afichar :",
	'lqt-preference-display-count' => "Nombre maximal de responsas d'afichar :",
	'lqt-preference-custom-signatures' => 'Far veire las signaturas personalizadas dels utilizaires',
	'lqt-enotif-subject-reply' => 'Discussion sus {{SITENAME}} - Responsa : $1',
	'lqt-enotif-subject-newthread' => 'Discussion sus {{SITENAME}}  - Subjècte novèl : $1',
	'lqt-enotif-newthread' => "Bonjorn $1,
Aquò es una notificacion de {{SITENAME}}, qu'indica un subjècte novèl de $5, « $2 »,
es estada creada lo $3 a $4.

O podètz veire a « $6 »",
	'lqt-enotif-reply' => "Bonjorn $1,
Aquò es una notificacion de {{SITENAME}}, qu'una responsa novèla a « $2 » sus $5,
es estada creada lo $3 a $4.

O podètz veire a « $6 »",
	'lqt-quote-intro' => 'Lo $2 a $3, [[User:$1|$1]] a escrich :',
	'lqt-quote' => 'Citar',
	'lqt-search-legend' => 'Recercar de discussions sus aquesta pagina',
	'lqt-search-label' => 'Tèrmes de recèrca :',
	'lqt-search-button' => 'Recercar',
	'searchprofile-threads' => 'Discussions',
	'searchprofile-threads-tooltip' => 'Recercar dins los fials de discussion e las paginas de discussion',
	'lqt-ajax-updated' => 'Aqueste fial a de messatges novèls.',
	'lqt-ajax-update-link' => 'Metre a jorn',
	'lqt-thread-show-replies' => 'Far veire $1 responsas',
	'lqt-thread-show-more' => 'Far veire mai de responsas',
	'lqt-thread-link-url' => 'URL del ligam :',
	'lqt-thread-link-title' => 'Ligam wikitèxte :',
	'lqt-thread-link-copy' => 'Copiar dins lo quichapapièrs',
	'lqt-feed-title-all' => '{{SITENAME}} - Messatges novèls',
	'lqt-feed-title-all-from' => '{{SITENAME}} - Messatges novèls de $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} - Fials de discussion novèls',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} - Fials de discussion novèls de $1',
	'lqt-feed-title-replies' => '{{SITENAME}} - Responsas',
	'lqt-feed-title-replies-from' => '{{SITENAME}} - Responsas de $1',
	'lqt-feed-new-thread-intro' => 'Fial de discussion novèl sus $1 postat per $2',
	'lqt-feed-reply-intro' => 'Responsa a $3 (sus $1) postada per $2',
	'lqt-newmessages-n' => 'Messatges novèls ($1)',
	'lqt_newmessages' => 'Messatges Novèls',
	'lqt-newpost-summary' => 'Fial novèl : $1',
	'lqt-reply-summary' => 'Respondre a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Istoric de la pagina de discussion',
	'lqt-talkpage-history-subtitle' => 'Per $1',
	'lqt-talkpage-history-tab' => 'Entèsta',
	'restriction-reply' => 'Postar de responsas',
	'restriction-newthread' => 'Postar de fials de discussion novèls',
	'lqt-protected-reply-thread' => 'Podètz pas postar dins aqueste fial de discussion perque es estat protegit contra los messatges novèls.',
	'lqt-protected-reply-talkpage' => 'Podètz pas postar dins aqueste fial perque aquesta pagina de discussion es estada protegida contra las responsas a sos fials.',
	'lqt-protected-newthread' => 'Podètz pas postar de fials novèls dins aquesta pagina de discussion perque es estada protegida contra los fials novèls.',
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Jose77
 * @author Psubhashish
 */
$messages['or'] = array(
	'lqt_discussion_link' => 'ଆଲୋଚନା',
	'lqt_hist_deleted' => 'ଲିଭାଇ ଦିଆଯାଇଥିବା',
	'lqt-summary' => 'ସାରକଥା',
);

/** Ossetic (Иронау)
 * @author Amikeco
 */
$messages['os'] = array(
	'lqt_delete' => 'Аппар',
	'lqt_hist_deleted' => 'Аппæрст',
	'lqt_protectedfromreply_link' => 'æхгæд',
	'lqt-title' => 'Сæргонд',
);

/** Pampanga (Kapampangan)
 * @author Katimawan2005
 */
$messages['pam'] = array(
	'lqt_movethread' => 'Iyalis ya ing tema (thread) king aliwang bulung',
	'lqt_deletethread' => 'Buran ya o iurung ya pangabura ing sinulad (thread)',
	'lqt_contents_title' => 'Kalamnan',
	'lqt_add_header' => 'Mangibiling pamagat (header)',
	'lqt_new_thread' => 'Magumpisang bayung discusiun/pamisabi-sabi',
	'lqt_reply' => 'Pakibat',
	'lqt_move_torename_edit' => 'i-edit ya',
	'lqt_delete_return' => 'Mibalik king $1.',
	'lqt_sorting_order' => 'Basi ning pamituki-tuki (sorting order)',
	'lqt_newmessages' => 'Bayung mensahi',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'lqt_toc_thread_author' => 'Gschterdt vun',
	'lqt_add_header' => 'Iwwerschrift dezu duh',
	'lqt_delete' => 'Lösche',
	'lqt_discussion_link' => 'Dischbedutt',
	'lqt_from_talk' => 'Vun $1',
	'lqt_protectedfromreply_link' => 'geschitzt',
	'lqt_move_move' => 'Ziehe',
	'lqt_delete_return' => 'Zerick zu $1.',
	'lqt-title' => 'Titel',
	'lqt-history-time' => 'Zeit',
	'lqt-history-user' => 'Yuuser',
	'lqt-history-comment' => 'Aamaericking',
	'lqt-movethread' => 'Ziehe',
	'lqt-menu-trigger' => 'Mehner',
	'lqt-newmessages-from' => 'Vun $1',
	'lqt-log-action-move' => 'hot [[$1]] vun [[$2]] nooch [[$3]] gezoge',
	'lqt-log-action-merge-across' => 'hot [[$1]] vun [[$2]] nooch [[$3]] gezoge',
	'lqt-search-button' => 'Guck uff',
	'searchprofile-threads' => 'Dischbedutte',
	'lqt-thread-link-url' => 'Gleecher-URL:',
	'lqt-thread-link-title' => 'Wikitext-Gleecher:',
	'lqt-drag-reason' => 'Grund:',
	'lqt-preview-signature' => '(Aagucke)',
	'lqt-newmessages-n' => 'Neiichkeede ($1)',
	'lqt_newmessages' => 'Neiichkeede (ken)',
	'lqt-talkpage-history-subtitle' => 'Fer $1',
	'lqt-talkpage-history-tab' => 'Iwwerschrift',
);

/** Pälzisch (Pälzisch)
 * @author Xqt
 */
$messages['pfl'] = array(
	'lqt_delete' => 'Lesche',
	'lqt_move_move' => 'Verschiewe',
	'lqt-movethread' => 'Verschiewe',
);

/** Polish (Polski)
 * @author Airwolf
 * @author Holek
 * @author Leinad
 * @author Maikking
 * @author Masti
 * @author McMonster
 * @author Odder
 * @author Sp5uhe
 * @author ToSter
 * @author Wpedzich
 */
$messages['pl'] = array(
	'lqt-desc' => 'Umożliwia prowadzenie na stronach dyskusji korespondencji podzielonej na wątki',
	'lqt_movethread' => 'Przenieś wątek na inną stronę',
	'lqt_deletethread' => 'Usuń lub odtwórz wątek',
	'lqt_contents_title' => 'Zawartość',
	'lqt_toc_thread_title' => 'Temat wątku',
	'lqt_toc_thread_author' => 'Rozpoczęty przez',
	'lqt_toc_thread_replycount' => 'Odpowiedzi',
	'lqt_toc_thread_modified' => 'Ostatnia zmiana',
	'lqt_add_header' => 'Dodaj nagłówek',
	'lqt_new_thread' => 'Rozpocznij nową dyskusję',
	'lqt_invalid_subject' => 'Wprowadzony temat jest nieprawidłowy. Możliwe, że:
* jest za długi,
* koliduje z prefiksami interwiki lub przestrzeniami nazw.',
	'lqt_empty_subject' => 'Musisz wpisać temat.',
	'lqt_reply' => 'Odpowiedz',
	'lqt-parent' => 'Do góry',
	'lqt_delete' => 'Usuń',
	'lqt_undelete' => 'Odkasuj',
	'lqt_permalink' => 'Link do',
	'lqt_fragment' => 'Fragment $1 z $2',
	'lqt_discussion_link' => 'dyskusji',
	'lqt_from_talk' => 'Ze strony $1',
	'lqt-history-title' => 'Historia wątku',
	'lqt_hist_comment_edited' => 'Komentarz został [$2 zmieniony]',
	'lqt_hist_summary_changed' => 'Podsumowanie zostało zmienione',
	'lqt_hist_reply_created' => 'Napisano [[$1|odpowiedź]]',
	'lqt_hist_thread_created' => 'Utworzono wątek',
	'lqt_hist_deleted' => 'Usunięto',
	'lqt_hist_undeleted' => 'Odtworzono',
	'lqt_hist_moved_talkpage' => 'Przeniesiony',
	'lqt_hist_listing_subtitle' => 'Widok historii',
	'lqt_hist_view_whole_thread' => 'Historia dla całego wątku',
	'lqt_hist_no_revisions_error' => 'Brak zmian w historii dla tego wątku.',
	'lqt_hist_past_last_page_error' => 'Numer strony jest spoza zakresu istniejącej historii.',
	'lqt_hist_tooltip_newer_disabled' => 'Link jest niedostępny, ponieważ jesteś na pierwszej stronie.',
	'lqt_hist_tooltip_older_disabled' => 'Link jest niedostępny, ponieważ jesteś na ostatniej stronie.',
	'lqt_hist_split' => 'Odpowiedz rozgałęziając wątek – utwórz nowy wątek',
	'lqt_hist_edited_subject' => 'Zmieniono temat wątku z „$2” na „$3”',
	'lqt_hist_edited_subject_corrupt' => 'Zmieniony temat',
	'lqt_hist_merged_from' => '[[$1|Odpowiedź]] przeniesiona do innego wątku',
	'lqt_hist_merged_to' => '[[$1|Odpowiedź]] przeniesiona z innego wątku',
	'lqt_hist_split_from' => 'Utworzono odgałęzienie – nowy wątek',
	'lqt_hist_root_blanked' => 'Usunięto treść komentarza',
	'lqt_hist_adjusted_sortkey' => 'Poprawione położenie wątku',
	'lqt_revision_as_of' => 'Wersja z dnia $2 o $3.',
	'lqt_change_new_thread' => 'To jest pierwsza wersja wątku.',
	'lqt_change_reply_created' => '[$1 Wyróżniony opis] został utworzony w tej edycji.',
	'lqt_change_edited_root' => '[$1 Wyróżniony opis] został zmieniony w tej edycji.',
	'lqt_change_edited_summary' => 'Podsumowanie wątku zostało zmienione.',
	'lqt_change_deleted' => '[$1 Ten wątek] lub jego ojciec zostały usunięte',
	'lqt_change_undeleted' => '[$1 Wyróżniona wiadomość] została odtworzona',
	'lqt_change_moved' => '[$1 Wątek] został przeniesiony na inną stronę dyskusji',
	'lqt_change_split' => '[$1 Ten wątek] jest odgałęzieniem innego wątku',
	'lqt_change_edited_subject' => 'Temat wątku został zmieniony z „$2” na „$3”',
	'lqt_change_merged_from' => '[$1 Odpowiedź] na ten wątek została przeniesiona do innego wątku',
	'lqt_change_merged_to' => '[$1 Wyróżniona odpowiedź] została przeniesiona z innego wątku',
	'lqt_change_split_from' => '[$1 Podrzędny wątek] tego wątku został odgałęziony do własnego wątku.',
	'lqt_change_root_blanked' => 'Treść [$1 komentarza] została usunięta.',
	'lqt_youhavenewmessages' => 'Masz [[$1|nowe wiadomości]].',
	'lqt_protectedfromreply' => 'Ten wątek został $1 przed zamieszczaniem odpowiedzi.',
	'lqt_protectedfromreply_link' => 'zabezpieczony',
	'lqt_subject' => 'Temat',
	'lqt_noreason' => 'Nie podano powodu.',
	'lqt_move_placeholder' => 'Ten wątek jest wyłącznie znacznikiem, że właściwy wątek $1 został z tej strony przeniesiony.
$2 {{GENDER:$2|przeniósł|przeniosła|przeniósł(‐ła)}} go dnia $3 o $4 na stronę $5.',
	'lqt_thread_deleted_for_sysops' => "Ten wątek został '''usunięty''' i jest dostępny jedynie dla administratorów.",
	'lqt_thread_deleted' => 'Wątek został usunięty.',
	'lqt_summary_notice' => '{{PLURAL:$2|Od wczoraj|W ciągu ostatnich $2 dni}} nie było zmian w dyskusji.
Jeżeli dyskusja została zakończona, możesz $1.',
	'lqt_summary_notice_link' => 'napisać podsumowanie',
	'lqt_summary_label' => 'Podsumowanie wątku',
	'lqt_summary_subtitle' => 'Podsumowanie wątku „$1”',
	'lqt_nosuchrevision' => 'Nie ma takiej wersji w tym wątku.',
	'lqt_nosuchthread' => 'Wybrany przez Ciebie wątek nie istnieje.',
	'lqt_nosuchthread_title' => 'Nie ma takiego wątku',
	'lqt_threadrequired' => 'Musisz podać adres URL wątku.',
	'lqt_move_movingthread' => 'Przenoszenie $1.
Ten wątek jest częścią $2.',
	'lqt_move_torename' => 'Aby zmienić nazwę wątku, kliknij „$1” i zmień zawartość pola „Temat”.',
	'lqt_move_torename_edit' => 'edytuj',
	'lqt_move_destinationtitle' => 'Nazwa docelowej strony dyskusji',
	'lqt_move_move' => 'Przenieś',
	'lqt_move_nodestination' => 'Musisz określić przeznaczenie.',
	'lqt_move_thread_bad_destination' => 'Strona docelowa nie jest stroną dyskusji.',
	'lqt_move_samedestination' => 'Ten wątek jest już na tej stronie!',
	'lqt_move_noreason' => 'Nie podano powodu.',
	'lqt_move_success' => 'Wątek został przeniesiony do $1',
	'lqt_delete_undeletethread' => 'Odtwórz wątek',
	'lqt_delete_partof' => "Ten wątek jest fragmentem '''$1'''.",
	'lqt_delete_deleting' => "Usuwanie '''$1''' oraz '''wszystkich odpowiedzi''' udzielonych na niego.",
	'lqt_delete_deletethread' => 'Usuń wątek oraz odpowiedzi',
	'lqt_delete_deleted' => 'Wątek został usunięty.',
	'lqt_delete_undeleted' => 'Wątek został odtworzony.',
	'lqt_delete_return' => 'Wróć do $1.',
	'lqt_delete_return_link' => 'strona dyskusji',
	'lqt_delete_unallowed' => 'Nie masz uprawnień do usuwania wątków.',
	'lqt_delete_show_checkbox' => 'Pokaż usunięte wątki',
	'lqt_talkpage_autocreate_summary' => 'Strona dyskusji została automatycznie utworzona, gdy utworzono nowy wątek.',
	'lqt_header_warning_big' => 'Edytujesz $1.',
	'lqt_header_warning_after_big' => 'Nagłówki służą do zamieszczania ogłoszeń lub przedmowy. Zamiast tego możesz $2.',
	'lqt_header_warning_bold' => 'nagłówek strony dyskusji',
	'lqt_header_warning_new_discussion' => 'rozpocząć nowy wątek w dyskusji',
	'lqt_sorting_order' => 'Sortowanie',
	'lqt_sort_newest_changes' => 'najpierw ostatnio modyfikowane',
	'lqt_sort_newest_threads' => 'najpierw najnowsze wątki',
	'lqt_sort_oldest_threads' => 'najpierw najstarsze wątki',
	'lqt-title' => 'Tytuł',
	'lqt-summary' => 'Podsumowanie',
	'lqt-searching' => 'Wyszukiwanie wątków',
	'lqt-read-message' => 'Oznacz jako przeczytane',
	'lqt-read-message-tooltip' => 'Usuń ten wątek dla nowych wiadomości.
Wątek pozostanie widoczny na pierwotnej stronie dyskusji.',
	'lqt-read-all' => 'Oznacz wszystko jako przeczytane',
	'lqt-read-all-tooltip' => 'Usuń wszystkie wątki dla nowych wiadomości.
Wątki pozostaną widoczne na pierwotnych stronach dyskusji.
Ta operacja jest odwracalna.',
	'lqt-marked-read' => "Wątek '''$1''' jest oznaczony jako przeczytany.",
	'lqt-count-marked-read' => 'Oznaczono jako {{PLURAL:$1|przeczytaną|przeczytane}} $1 {{PLURAL:$1|wiadomość|wiadomości}}.',
	'lqt-email-undo' => 'Cofnij',
	'lqt-no-new-messages' => 'Nie ma do Ciebie nowych wiadomości.',
	'lqt-new-messages' => '✒ Nie ma do Ciebie nowych wiadomości.',
	'lqt-email-info-undo' => 'Przywróć wątek, który właśnie kazałem odrzucić.',
	'lqt-date-info' => 'Ten link jest wyłączony, ponieważ przeglądasz wątki ze wszystkich terminów.',
	'lqt-newmessages-context' => 'Wątek wyczerpany',
	'lqt-thread-created' => 'Utworzony',
	'lqt-history-time' => 'Data',
	'lqt-history-user' => 'Użytkownik',
	'lqt-history-action' => 'Działanie',
	'lqt-history-comment' => 'Komentarz',
	'lqt-history-thread' => 'Wątek',
	'lqt-thread-edited-author' => 'Edytowane przez autora.<br />
Ostatnia zmiana: $1',
	'lqt-thread-edited-others' => 'Edytowany przez {{PLURAL:$2|innego użytkownika|innych użytkowników}}.<br />
Ostatnia zmiana $1',
	'lqt-header-actions' => 'Działania',
	'lqt_summarize_link' => 'Podsumuj',
	'lqt-summarize-intro' => 'Podsumuj poniższy wątek w okienku edycji.
Możesz korzystać w podsumowaniu ze składni wiki. Gdy skończysz, kliknij przycisk „{{int:savearticle}}”.',
	'lqt-thread-split' => 'Utwórz odgałęzienie – nowy wątek',
	'lqt-split-success' => 'Rozgałęziono wątek $1.',
	'lqt_split_thread' => 'Rozgałęź wątek',
	'lqt-thread-split-subject' => 'Temat nowego wątku',
	'lqt-thread-split-thread' => 'Wątek',
	'lqt-split-submit' => 'Rozgałęź',
	'lqt_split_badsubject' => 'Podany przez Ciebie temat jest nieprawidłowy.',
	'lqt-no-threads' => 'Na tej stronie nie ma jeszcze wątków dyskusji.',
	'lqt-delete-parent-warning' => 'Na tę wiadomość odpowiadano.
Jej usunięcie spowoduje automatyczne usunięcie wszystkich odpowiedzi.
Aby tego uniknąć, rozgałęź wątki odpowiedzi przed jej usunięciem.',
	'lqt-delete-parent-deleted' => 'Wątek został usunięty ($1)',
	'lqt-delete-replies-done' => 'Wszystkie odpowiedzi w tym wątku zostały również usunięte.',
	'lqt-movethread' => 'Przenieś',
	'lqt-menu-trigger' => 'Więcej',
	'lqt-newmessages-from' => 'Od $1',
	'lqt-hot-topics' => 'Gorące tematy',
	'lqt-add-reply' => 'Dodaj odpowiedź',
	'lqt_rc_new_discussion' => 'utworzył nowy wątek „$1”',
	'lqt_rc_new_reply' => 'odpowiedział w wątku „$1”',
	'right-lqt-split' => 'Rozgałęzianie wątków',
	'right-lqt-merge' => 'Łączenie wątków',
	'right-lqt-react' => 'Odpowiadanie w wątkach',
	'lqt-thread-merge' => 'Połącz z innym wątkiem',
	'lqt-thread-merge-to' => 'Połącz z tym wątkiem',
	'lqt_merge_thread' => 'Przyłącz wątek',
	'lqt-thread-merge-source' => 'Wątek źródłowy',
	'lqt-thread-merge-dest' => 'Wątek docelowy',
	'lqt-merge-submit' => 'Połącz',
	'lqt-merge-success' => 'Przyłączono wątek $1 na koniec wątku $2.',
	'lqt-log-name' => 'Rejestr wątków dyskusji',
	'lqt-log-header' => 'Rejestr zawiera informacje o czynnościach podejmowanych na wątkach dyskusji.',
	'lqt-log-action-move' => 'przeniósł [[$1]] z [[$2]] do [[$3]].',
	'lqt-log-action-split' => 'wydzielił [[$1]] z [[$3]] tworząc nowy temat „$2”',
	'lqt-log-action-merge-across' => 'przeniósł [[$1]] z [[$2]] do [[$3]]',
	'lqt-log-action-merge-down' => 'przyłączył [[$1]] do [[$3]]',
	'lqt-log-action-subjectedit' => 'zmienił temat [[$1]] z „$2” na „$3”',
	'lqt-log-action-resort' => 'zmienił sposób sortowania [[$1]] z $2 na $3',
	'lqt-preference-notify-talk' => 'Wyślij do mnie e‐mail, jeśli któryś z obserwowanych przeze mnie wątków zostanie zmodyfikowany',
	'lqt-preference-watch-threads' => 'Dodaj do obserwowanych wątki, w których biorę udział',
	'prefs-lqt' => 'Wątki w dyskusjach',
	'lqt-preference-display-depth' => 'Maksymalna wyświetlana głębokość odpowiedzi',
	'lqt-preference-display-count' => 'Maksymalna wyświetlana liczba odpowiedzi',
	'lqt-preference-custom-signatures' => 'Pokaż niestandardowe podpisy użytkowników',
	'lqt-enotif-subject-reply' => 'Dyskusja w {{GRAMMAR:MS.lp|{{SITENAME}}}}. Odpowiedź w wątku $1',
	'lqt-enotif-subject-newthread' => 'Dyskusja w {{GRAMMAR:MS.lp|{{SITENAME}}}}. Nowy wątek – $1',
	'lqt-enotif-newthread' => 'Witaj $1!

To jest powiadomienie z {{GRAMMAR:D.lp|{{SITENAME}}}} o tym, że $3 o $4 na stronie dyskusji $5, $8 utworzył nowy wątek „$2”.

Możesz go zobaczyć pod adresem <$6>

Treść to:
$7',
	'lqt-enotif-reply' => 'Witaj $1!

To jest powiadomienie z {{GRAMMAR:D.lp|{{SITENAME}}}} o tym, że $3 o $4 na stronie dyskusji $5, $8 odpowiedział w wątku „$2”.

Możesz ją zobaczyć pod adresem <$6>

Treść odpowiedzi to:
$7',
	'lqt-quote-intro' => 'Dnia $2 o $3 [[User:$1|$1]] napisał(a):',
	'lqt-quote' => 'Cytuj',
	'lqt-search-legend' => 'Szukaj dyskusji na tej stronie',
	'lqt-search-label' => 'Szukaj frazy',
	'lqt-search-button' => 'Szukaj',
	'searchprofile-threads' => 'Dyskusje',
	'searchprofile-threads-tooltip' => 'Szukaj wątków dyskusji i stron dyskusji',
	'lqt-ajax-updated' => 'W tym wątku pojawiły się nowe wpisy.',
	'lqt-ajax-update-link' => 'Aktualizuj',
	'lqt-thread-show-replies' => 'Wyświetl $1 {{PLURAL:$1|odpowiedź|odpowiedzi}}',
	'lqt-thread-show-more' => 'Wyświetl więcej odpowiedzi',
	'lqt-thread-link-url' => 'Link URL:',
	'lqt-thread-link-title' => 'Link wikitekstowy',
	'lqt-thread-link-copy' => 'Kopiuj do schowka',
	'lqt-sign-not-necessary' => 'Podpisywanie tyldami nie jest konieczne.
Podpis jest wyświetlany automatycznie.',
	'lqt-marked-as-read-placeholder' => 'Wątek $1 został oznaczony jako przeczytany.',
	'lqt-change-subject' => 'Zmień temat',
	'lqt-save-subject' => 'Zapisz',
	'lqt-save-subject-failed' => 'Podczas zmiany tematu w wątku wystąpił błąd – $1',
	'lqt-ajax-invalid-subject' => 'Podano nieprawidłowy temat – możliwe, że jest zbyt długi.',
	'lqt-ajax-no-subject' => 'Musisz podać temat nowego wątku.',
	'lqt-save-subject-error-unknown' => 'Podczas próby ustalenia tematu dla tego wątku wystąpił nieznany błąd. Ponów próbę edycji po wciśnięciu przycisku „Edytuj“ na górze strony.',
	'lqt-cancel-subject-edit' => 'Anuluj',
	'lqt-drag-activate' => 'Przeciągnij na nowe miejsce',
	'lqt-drag-drop-zone' => 'Upuść tutaj',
	'lqt-drag-confirm' => 'Aby zakończyć następujące działania, podaj powód, a następnie kliknij przycisk „Zatwierdzam“.',
	'lqt-drag-reparent' => 'Przenieś wiadomość jako odpowiedź na nową.',
	'lqt-drag-split' => 'Przenieś wiadomość do jej własnego wątku',
	'lqt-drag-setsortkey' => 'Zmień kolejność wiadomości na stronie',
	'lqt-drag-bump' => 'Przenieś wiadomość na samą górę strony dyskusji',
	'lqt-drag-save' => 'Potwierdź',
	'lqt-drag-title' => 'Zatwierdzenie przeciągnięcia',
	'lqt-drag-reason' => 'Powód',
	'lqt-drag-subject' => 'Temat nowego wątku (obowiązkowo)',
	'lqt-edit-signature' => '(edytuj podpis)',
	'lqt-preview-signature' => '(podgląd)',
	'lqt-feed-title-all' => '{{SITENAME}} – nowe wpisy',
	'lqt-feed-title-all-from' => '{{SITENAME}} – nowe wpisy na {{PLURAL:$2|stronie|stronach:}} $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – nowe wątki',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – nowe wątki na {{PLURAL:$2|stronie|stronach:}} $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – odpowiedzi',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – odpowiedzi na {{PLURAL:$2|stronie|stronach:}} $1',
	'lqt-feed-new-thread-intro' => 'Nowy wątek na stronie $1 utworzony przez $2',
	'lqt-feed-reply-intro' => 'Odpowiedź w wątku $3 (na stronie $1) napisana przez $2',
	'tooltip-pt-newmessages' => 'Pokazuje nowe wiadomości w obserwowanych wątkach lub na ich stronach dyskusji',
	'lqt-newmessages-n' => 'Nowe wiadomości ($1)',
	'lqt_newmessages' => 'Nowe wiadomości (brak)',
	'lqt_newmessages-title' => 'Nowe wiadomości',
	'lqt-newpost-summary' => 'Nowy wątek – $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Wpisz treść do tego wątku. Tę linię tekstu należy usunąć.',
	'lqt-reply-summary' => 'Odpowiedz na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historia strony dyskusji',
	'lqt-talkpage-history-subtitle' => 'Do $1',
	'lqt-talkpage-history-tab' => 'Nagłówek',
	'restriction-reply' => 'Odpisywanie',
	'restriction-newthread' => 'Tworzenie nowych wątków',
	'lqt-protected-reply-thread' => 'Nie możesz pisać w tym wątku, ponieważ został on zabezpieczony przed tworzeniem nowych wiadomości.',
	'lqt-protected-reply-talkpage' => 'Nie możesz pisać w tym wątku, ponieważ ta strona dyskusji została zabezpieczona przed odpowiadaniem w znajdujących się na niej wątkach.',
	'lqt-protected-newthread' => 'Nie możesz tworzyć nowych wątków na tej stronie dyskusji, ponieważ została ona zabezpieczona przed tworzeniem nowych wątków.',
	'lqt-edit-bump' => 'Przesuń wątek w górę',
	'lqt-edit-bump-tooltip' => 'Przesuń wątek na początek strony dyskusji',
	'lqt-historicalrevision-error' => 'Wybrana wersja jest uszkodzona i nie można jej wyświetlić.',
	'lqt-reply-subpage' => 'odpowiedź',
	'nstab-thread' => 'Wątek',
	'nstab-summary' => 'Podsumowanie',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'lqt-desc' => 'Gionté dle discussion për argoment a le pàgine ëd discussion',
	'lqt_movethread' => "Tramudé la discussion a n'àutra pàgina",
	'lqt_deletethread' => 'Scancelé o arcuperé la discussion',
	'lqt_contents_title' => 'Contnù',
	'lqt_toc_thread_title' => 'Tìtol ëd la discussion',
	'lqt_toc_thread_author' => 'Ancaminà da',
	'lqt_toc_thread_replycount' => 'Répliche',
	'lqt_toc_thread_modified' => 'Ùltima modìfica',
	'lqt_add_header' => "Gionté n'antestassion",
	'lqt_new_thread' => 'Ancamin-a na discussion neuva',
	'lqt_invalid_subject' => "L'oget ch'a l'ha anserì a l'é pa bon.
A podrìa:
* esse tròp longh, o
* esse an conflit con dij prefiss antërwiki o nòm dë spassi nominal.",
	'lqt_empty_subject' => "A deuv anserì n'oget.",
	'lqt_reply' => 'Arspond',
	'lqt-parent' => 'Cé',
	'lqt_delete' => 'Scancela',
	'lqt_undelete' => 'Arcùpera',
	'lqt_permalink' => 'Colega a',
	'lqt_fragment' => 'Frament ëd na $1 da $2',
	'lqt_discussion_link' => 'discussion',
	'lqt_from_talk' => 'da $1',
	'lqt-history-title' => 'Stòria dla discussion',
	'lqt_hist_comment_edited' => 'Test dël coment [$2 modificà]',
	'lqt_hist_summary_changed' => 'Somari cangià',
	'lqt_hist_reply_created' => '[[$1|Arspòsta neuva]] creà',
	'lqt_hist_thread_created' => 'Discussion neuva creà',
	'lqt_hist_deleted' => 'Scancelà',
	'lqt_hist_undeleted' => 'Arcuperà',
	'lqt_hist_moved_talkpage' => 'Tramudà',
	'lqt_hist_listing_subtitle' => 'Vardé un listà dla stòria',
	'lqt_hist_view_whole_thread' => 'Vëdde la stòria dla discussion antrega',
	'lqt_hist_no_revisions_error' => "Sta discussion-sì a l'ha gnun-e revision dë stòria",
	'lqt_hist_past_last_page_error' => "A l'ha sorpassà ël nùmer ëd pàgine dë stòria ch'a-i son.",
	'lqt_hist_tooltip_newer_disabled' => "Ël colegament a l'é disabilità përchè it ses an sla prima pàgina.",
	'lqt_hist_tooltip_older_disabled' => "Ël colegament a l'é disabilità përchè it ses an sl'ùltima pàgina.",
	'lqt_hist_split' => 'Arspòsta dividùa an na neuva discussion',
	'lqt_hist_edited_subject' => 'Soget cangià da "$2" a "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Soget cangià',
	'lqt_hist_merged_from' => "[[$1|Arspòsta]] tramudà an n'àutra discussion",
	'lqt_hist_merged_to' => "[[$1|Arspòsta]] tramudà da n'àutra discussion",
	'lqt_hist_split_from' => 'Divid ant na discussion neuva',
	'lqt_hist_root_blanked' => 'Test ëd coment gavà',
	'lqt_hist_adjusted_sortkey' => 'Posission ëd la discussion rangià',
	'lqt_revision_as_of' => 'Revision dël $2 a $3.',
	'lqt_change_new_thread' => "Costa a l'é la revision inissial ëd la discussion.",
	'lqt_change_reply_created' => "Ël [coment $1 evidensià] a l'é stàit creà an sta revision-sì.",
	'lqt_change_edited_root' => "Ël [coment $1 a evidensià] a l'é stàit modificà an sta revision-sì.",
	'lqt_change_edited_summary' => "Ël somari dla discussion a l'é stàit modificà",
	'lqt_change_deleted' => "[$1 Sta discussion-sì] o soa genitris a l'é stàita scancelà",
	'lqt_change_undeleted' => "Ël [coment evidensià $1] a l'é stàit arcuperà",
	'lqt_change_moved' => "[$1 Sta discussion-sì] a l'é stàita tramudà a n'àutra pàgina ëd discussion",
	'lqt_change_split' => "[$1 Sta discussion-sì] a l'é stàita tramudà da n'àutra discussion.",
	'lqt_change_edited_subject' => 'Ël soget dë sta discussion-sì a l\'é stàit cangià da "$2" a "$3"',
	'lqt_change_merged_from' => "Na [$1 réplica] a sta discussion-sì a l'é stàita tramudà a n'àutra discussion",
	'lqt_change_merged_to' => "La [$1 réplica evidensià] a l'é stàita tramudà da n'àutra discussion.",
	'lqt_change_split_from' => "Na [$1 sot-discussion] dë sta discussion-sì a l'é stàita separà an na discussion soa pròpia",
	'lqt_change_root_blanked' => "Ël test d'[$1 un coment] a l'é stàit ëscancelà.",
	'lqt_youhavenewmessages' => "It l'has [[$1|mëssagi neuv]].",
	'lqt_protectedfromreply' => "Sta discussion-sì a l'é stàita $1 da avèj ëd rispòste.",
	'lqt_protectedfromreply_link' => 'protet',
	'lqt_subject' => 'Soget:',
	'lqt_noreason' => 'Pa gnun-e rason dàite.',
	'lqt_move_placeholder' => "Sta discussion-sì a l'é un marcapòst ch'a ìndica che na discussion, $1, a l'é stàita tramudà da sta pàgina-sì.
Ës tramud a l'é stàit fàit da $2 ël $3 a $4.
La discussion a l'é adess piassà a $5.",
	'lqt_thread_deleted_for_sysops' => "Sta discussion-sì a l'é stàita '''scancelà''' e a l'é mach visìbil a j'aministrator.",
	'lqt_thread_deleted' => "Sta discussion-sì a l'é stàita scancelà.",
	'lqt_summary_notice' => "A-i é stàje gnun cambiament a sta discussion-sì për almanch $2 {{PLURAL:$2|di|di}}.
S'a l'é finìa, a peule vorèj $1.",
	'lqt_summary_notice_link' => 'scriv un somari',
	'lqt_summary_label' => 'Somari dla discussion:',
	'lqt_summary_subtitle' => 'Somari ëd "$1"',
	'lqt_nosuchrevision' => 'A-i é gnun-a revision dë sta discussion-sì.',
	'lqt_nosuchthread' => "La discussion che it l'has spessificà a esist pa.",
	'lqt_nosuchthread_title' => 'La discussion a-i é pa',
	'lqt_threadrequired' => "A deuv specifiché na discussion ant l'adrëssa dl'aragnà.",
	'lqt_move_movingthread' => "Tramudé $1.
Sta discussion-sì a l'é part ëd $2.",
	'lqt_move_torename' => "Për arnominé sta discussion-sì, $1 e cangé ël camp 'Soget'.",
	'lqt_move_torename_edit' => 'modifichelo',
	'lqt_move_destinationtitle' => 'Tìtol ëd la pàgina ëd discussion ëd destinassion:',
	'lqt_move_move' => 'Tramuda',
	'lqt_move_nodestination' => 'A deuv specifiché na destinassion.',
	'lqt_move_thread_bad_destination' => "La pàgina ëd destinassion a l'é pa na pàgina ëd discussion.",
	'lqt_move_samedestination' => "La discussion a l'é già dzora a sta pàgina-sì!",
	'lqt_move_noreason' => 'Pa gnun-e rason dàite.',
	'lqt_move_success' => "La discussion a l'é stàita tramudà a $1.",
	'lqt_delete_undeletethread' => 'Arcuperé la discussion',
	'lqt_delete_partof' => "Sta discussion-sì a l'é part ëd '''$1'''.",
	'lqt_delete_deleting' => "Scancelassion ëd '''$1''' e ëd '''tute soe arspòste'''.",
	'lqt_delete_deletethread' => 'Scancelé la discussion e le répliche',
	'lqt_delete_deleted' => "La discussion a l'é stàita scancelà.",
	'lqt_delete_undeleted' => "La discussion a l'é stàita arcuperà.",
	'lqt_delete_return' => 'Torna andré a $1.',
	'lqt_delete_return_link' => 'la pàgina ëd discussion',
	'lqt_delete_unallowed' => "A l'ha nen ël drit dë scancelé dle discussion.",
	'lqt_delete_show_checkbox' => 'Smon-e le discussion ëscancelà',
	'lqt_talkpage_autocreate_summary' => "Pàgina ëd discussion creà an automàtich quand la prima discussion a l'é stàita mandà.",
	'lqt_header_warning_big' => "A l'é an camin ch'a modìfica un $1.",
	'lqt_header_warning_after_big' => "J'antestassion a son për j'anonsi e le prefassion.
Nopà a peul vorèj $2.",
	'lqt_header_warning_bold' => 'antestassion ëd na pàgina ëd discussion',
	'lqt_header_warning_new_discussion' => 'ancamin-a na discussion neuva',
	'lqt_sorting_order' => "Criteri d'ordinament:",
	'lqt_sort_newest_changes' => "prima j'ùltim modificà",
	'lqt_sort_newest_threads' => 'prima le discussion pi neuve',
	'lqt_sort_oldest_threads' => 'prima le discussion pi veje',
	'lqt-title' => 'Tìtol',
	'lqt-summary' => 'Resumé',
	'lqt-searching' => 'Sërché dle discussion',
	'lqt-read-message' => 'Marca com lesù',
	'lqt-read-message-tooltip' => 'Gava sta discussion dai mëssagi neuv.
A sarà ancó visìbil an sla soa pàgina ëd discussion original.',
	'lqt-read-all' => 'Marca tut com lesù.',
	'lqt-read-all-tooltip' => "Gava tute le discussion dai mëssagi neuv.
A saran ancó visìbij an sle soe pàgine ëd discussion originaj.
Costa operassion a l'é pa reversìbil.",
	'lqt-marked-read' => "Discussion '''$1''' marcà com lesùa.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mëssagi|mëssagi}} marcà com lesù.',
	'lqt-email-undo' => "buta 'me ch'a l'era",
	'lqt-no-new-messages' => 'A-i é gnun mëssagi neuv për chiel.',
	'lqt-new-messages' => '✒ A-i é ëd mëssagi neuv për ti.',
	'lqt-email-info-undo' => "Ristabilì la discussion ch'a l'ha pen-a gavà.",
	'lqt-date-info' => "Costa anliura a l'é disabilità përchè a l'é an camin ch'a vëd le discussion da tute le date.",
	'lqt-newmessages-context' => 'Discussion antrega',
	'lqt-thread-created' => 'Creà',
	'lqt-history-time' => 'Ora',
	'lqt-history-user' => 'Utent',
	'lqt-history-action' => 'Atività',
	'lqt-history-comment' => 'Coment',
	'lqt-history-thread' => 'Discussion',
	'lqt-thread-edited-author' => "Modificà da l'autor.<br />
Ùltima modìfica: $1",
	'lqt-thread-edited-others' => "Modificà da {{PLURAL:$2|n'àutr utent|$2 utent}}.<br />
Ùltima modìfica: $1",
	'lqt-header-actions' => 'Assion',
	'lqt_summarize_link' => 'Fé un resumé',
	'lqt-summarize-intro' => "Për piasì ch'a fasa un resumé dla discussion sota ant la casela ëd modìfica.
A peul dovré qualsëssìa test wiki an sò resumé.
Quand ch'a finisse, ch'a sgnaca \"{{int:savearticle}}\".",
	'lqt-thread-split' => 'Dividé an na discussion neuva',
	'lqt-split-success' => "It l'has dividù da bin la discussion $1.",
	'lqt_split_thread' => 'Divid na discussion',
	'lqt-thread-split-subject' => 'Soget dla discussion neuva:',
	'lqt-thread-split-thread' => 'Discussion:',
	'lqt-split-submit' => 'Divid',
	'lqt_split_badsubject' => "Ël soget ch'it l'has anserì a l'é pa bon.",
	'lqt-no-threads' => 'A-i é pa ancó gnun-e discussion dzora a sta pagina-sì.',
	'lqt-delete-parent-warning' => "Costa-sì a l'é na discussion d'àut livel con d'arspòste.
Soe arspòste a saran ëdcò scancelà automaticament.
Për evité sòn, ch'a-j separa da costa discussion prima dë scancelela.",
	'lqt-delete-parent-deleted' => 'Scancelà la discussion genitris ($1)',
	'lqt-delete-replies-done' => "Tute j'arspòste a sta discussion-sì a son ëdcò stàite scancelà.",
	'lqt-movethread' => 'Tramuda',
	'lqt-menu-trigger' => 'Pi',
	'lqt-newmessages-from' => 'Da $1',
	'lqt-hot-topics' => 'Argoment càud',
	'lqt-add-reply' => 'Gionté na réplica',
	'lqt_rc_new_discussion' => 'manda na discussion neuva, "$1"',
	'lqt_rc_new_reply' => 'mandà na réplica a "$1"',
	'right-lqt-split' => 'Divide le discussion',
	'right-lqt-merge' => 'Unì le discussion',
	'lqt-thread-merge' => "Uniss ant n'àutra discussion",
	'lqt-thread-merge-to' => 'Uniss a sta discussion-sì',
	'lqt_merge_thread' => 'Unì la discussion',
	'lqt-thread-merge-source' => 'Discussion sorgiss:',
	'lqt-thread-merge-dest' => 'Discussion destinassion:',
	'lqt-merge-submit' => 'Uniss',
	'lqt-merge-success' => "It l'has unì da bin la discussion $1 sota a $2.",
	'lqt-log-name' => 'Registr ëd le discussion',
	'lqt-log-header' => "Sto registr-sì a detaja j'assion fàite dzora a la discussion.",
	'lqt-log-action-move' => 'tramudà [[$1]] da [[$2]] a [[$3]]',
	'lqt-log-action-split' => 'dividù [[$1]] da sota [[$3]], con ël soget neuv "$2"',
	'lqt-log-action-merge-across' => 'tramudà [[$1]] da sota [[$2]] a sota [[$3]]',
	'lqt-log-action-merge-down' => 'unì [[$1]] sota a [[$3]]',
	'lqt-log-action-subjectedit' => 'cangià ël soget ëd [[$1]] da "$2" a "$3"',
	'lqt-log-action-resort' => "modificà l'ordinament ëd [[$1]]. Cangià la ciav d'ordinament da $2 a $3",
	'lqt-preference-notify-talk' => "Mandeme un mëssagi an pòsta eletrònica cand ch'a-i rivo 'd répliche a na discussion ch'i ten-o sot euj",
	'lqt-preference-watch-threads' => 'Steje dapress a le discussion che i creo o a le quaj i réplico',
	'prefs-lqt' => 'Discussion',
	'lqt-preference-display-depth' => 'Profondeur màssima ëd répliche da mostré:',
	'lqt-preference-display-count' => 'Nùmer màssim ëd répliche da mostré:',
	'lqt-preference-custom-signatures' => "Smon-e le firme përsonalisà dj'utent",
	'lqt-enotif-subject-reply' => 'Discussion ëd {{SITENAME}} - Arspòsta: $1',
	'lqt-enotif-subject-newthread' => 'Discussion ëd {{SITENAME}} - Discussion neuva: $1',
	'lqt-enotif-newthread' => "Cerea $1,
Costa a l'é na notìfica da {{SITENAME}} che na discussion neuva su $5, '$2',
a l'é stàita creà ël $3 a $4 su $8.

A peul vëddla su <$6>

Ël test a l'é:
$7",
	'lqt-enotif-reply' => "Cerea $1,

Costa a l'é na notìfica da {{SITENAME}} che n'arspòsta neuva a '$2' su $5,
a l'é stàita creà ël $3 a $4 da $8.

A peul vëddla su <$6>

Ël test ëd l'arspòsta a l'é:
$7",
	'lqt-quote-intro' => "Ël $2 a $3, [[User:$1|$1]] a l'ha scrivù:",
	'lqt-quote' => 'Sité',
	'lqt-search-legend' => 'Sërché dle discussion dzora a sta pàgina-sì',
	'lqt-search-label' => "Element d'arserca:",
	'lqt-search-button' => 'Sërca',
	'searchprofile-threads' => 'Discussion',
	'searchprofile-threads-tooltip' => 'Sërché ant le discussion e le pàgine ëd discussion',
	'lqt-ajax-updated' => "Sta discussion-sì a l'ha ëd mëssagi neuv.",
	'lqt-ajax-update-link' => 'Agiorna',
	'lqt-thread-show-replies' => 'Mostré $1 {{PLURAL:$1|arspòsta|arspòste}}',
	'lqt-thread-show-more' => "Smon-e pi 'd répliche",
	'lqt-thread-link-url' => "Adrëssa dl'anliura:",
	'lqt-thread-link-title' => 'Colegament ëd test wiki:',
	'lqt-thread-link-copy' => "Còpia ant j'anotassion",
	'lqt-sign-not-necessary' => "A-i é pa dabzògn ëd firmé sò mëssagi con quatr tilde.
La firma a l'é mostrà automaticament.",
	'lqt-marked-as-read-placeholder' => "La discussion $1 a l'é stàita marcà com lesùa.",
	'lqt-change-subject' => "Cangé 'l soget",
	'lqt-save-subject' => 'Salva',
	'lqt-save-subject-failed' => "L'eror sota a l'é capità antramentre ch'as provava a cangé ël soget dë sta discussion-sì: $1",
	'lqt-ajax-invalid-subject' => "Ël soget ch'it l'has specificà a l'é pa bon, miraco përchè a l'é tròp longh.",
	'lqt-ajax-no-subject' => 'A deuv specifiché un soget.',
	'lqt-save-subject-error-unknown' => "N'eror pa conossù a l'é capità an provand a amposté ël soget dë sta discussion-sì. Për piasì ch'a preuva a fé sòn an sgnacand \"modifiché\" dzora al prim mëssagi.",
	'lqt-cancel-subject-edit' => 'Scancela',
	'lqt-drag-activate' => 'Tira a la locassion neuva',
	'lqt-drag-drop-zone' => 'Sàuta sì',
	'lqt-drag-confirm' => "Për completé j'assion sì-sota, për piasì ch'a buta na rason e ch'a sgnaca \"Confirmé\".",
	'lqt-drag-reparent' => 'Tramudé ël mëssagi sota un pare neuv.',
	'lqt-drag-split' => 'Tramudé ël mëssagi a soa discussion',
	'lqt-drag-setsortkey' => 'Rangé la posission dël mëssagi ant la pàgina',
	'lqt-drag-bump' => 'Tramudé ël mëssagi an cò dla pàgina ëd discussion',
	'lqt-drag-save' => 'Conferma',
	'lqt-drag-title' => 'Confermé ël rabasté',
	'lqt-drag-reason' => 'Rason:',
	'lqt-drag-subject' => 'Soget ëd la neuva discussion:',
	'lqt-edit-signature' => '(modifiché la firma)',
	'lqt-preview-signature' => '(preuva)',
	'lqt-feed-title-all' => '{{SITENAME}} — Mëssagi neuv',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Mëssagi neuv da $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Discussion neuva',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Discussion neuva da $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Arspòste',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Arspòste da $1',
	'lqt-feed-new-thread-intro' => 'Discussion neuva ancaminà da $2',
	'lqt-feed-reply-intro' => 'Arspòsta a $3 (ël $1) mandà da $2',
	'tooltip-pt-newmessages' => "A mostra ij mëssagi neuv për soget o su pàgine ëd discussion an sël soget ch'a ten sot-euj",
	'lqt-newmessages-n' => 'Mëssagi neuv ($1)',
	'lqt_newmessages' => 'Mè mëssagi neuv (Gnun)',
	'lqt_newmessages-title' => 'Mëssagi neuv',
	'lqt-newpost-summary' => 'Discussion neuva: $1',
	'lqt-reply-summary' => 'Arspòsta a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Stòria dla pàgina ëd discussion',
	'lqt-talkpage-history-subtitle' => 'Për $1',
	'lqt-talkpage-history-tab' => 'Antestassion',
	'restriction-reply' => 'Repliché',
	'restriction-newthread' => 'Mandé dle discussion neuve',
	'lqt-protected-reply-thread' => "A peul pa scrive an costa discussion-sì përchè a l'é stàita protegiùa dai mëssagi neuv.",
	'lqt-protected-reply-talkpage' => "A peul pa scrive su costa discussion përchè sta pàgina ëd discussion-sì a l'é stàita proteta da le répliche ai sò argoment.",
	'lqt-protected-newthread' => "A peul pa anandié dj'argoment neuv su sta pàgina ëd discussion-sì përchè a l'é stàita protegiùa dai neuv argoment.",
	'lqt-edit-bump' => 'Riativé cost argoment',
	'lqt-edit-bump-tooltip' => 'Tramudé cost argoment an cò ëd soa pàgina ëd discussion',
	'lqt-historicalrevision-error' => "La revision ch'it l'has selessionà a l'é delabrà, e a peul pa esse mostrà.",
	'lqt-reply-subpage' => 'arspond',
	'nstab-thread' => 'Discussion',
	'nstab-summary' => 'Resumé',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'lqt_contents_title' => 'منځپانګه',
	'lqt_toc_thread_replycount' => 'ځوابونه',
	'lqt_reply' => 'ځوابول',
	'lqt_delete' => 'ړنګول',
	'lqt_undelete' => 'ناړنګول',
	'lqt_discussion_link' => 'خبرې اترې',
	'lqt_from_talk' => 'د $1 لخوا',
	'lqt_hist_reply_created' => '[[$1|نوی ځواب]] جوړ شو',
	'lqt_hist_deleted' => 'ړنګ شو',
	'lqt_hist_undeleted' => 'ناړنګ شو',
	'lqt_youhavenewmessages' => 'تاسې [[$1|نوي پيغامونه]] لری.',
	'lqt_protectedfromreply_link' => 'ژغورلی',
	'lqt_subject' => 'سکالو:',
	'lqt_noreason' => 'هېڅ سبب نه دی ورکړ شوی.',
	'lqt_move_torename_edit' => 'دا سمول',
	'lqt_move_move' => 'لېږدول',
	'lqt_move_noreason' => 'هېڅ سبب نه دی ورکړ شوی.',
	'lqt_delete_return_link' => 'د خبرو اترو مخ',
	'lqt-title' => 'سرليک',
	'lqt-summary' => 'لنډيز',
	'lqt-email-undo' => 'ناکړل',
	'lqt-new-messages' => '✒ تاسې نوي پيغامونه لرۍ.',
	'lqt-thread-created' => 'جوړ شو',
	'lqt-history-time' => 'وخت',
	'lqt-history-user' => 'کارن',
	'lqt-history-comment' => 'تبصره',
	'lqt-movethread' => 'لېږدول',
	'lqt-menu-trigger' => 'نور',
	'lqt-add-reply' => 'يو ځواب ورګډول',
	'lqt-enotif-subject-reply' => 'د {{SITENAME}} خبرې اترې - ځوابول: $1',
	'lqt-search-button' => 'پلټل',
	'searchprofile-threads' => 'خبرې اترې',
	'lqt-ajax-update-link' => 'اوسمهالول',
	'lqt-thread-show-replies' => '$1 {{PLURAL:$1|ځواب|ځوابونه}} ښکاره کول',
	'lqt-thread-show-more' => 'نور ځوابونه ښکاره کول',
	'lqt-save-subject' => 'خوندي کول',
	'lqt-cancel-subject-edit' => 'ناګارل',
	'lqt-drag-reason' => 'سبب:',
	'lqt-edit-signature' => '(لاسليک سمول)',
	'lqt-feed-title-replies' => '{{SITENAME}} — ځوابونه',
	'lqt-newmessages-n' => 'نوي پيغامونه ($1)',
	'lqt_newmessages' => 'زما نوي پيغامونه (هېڅ)',
	'lqt_newmessages-title' => 'نوي پيغامونه',
	'lqt-reply-summary' => '[[$2|$1]] ته ځواب وييل',
	'lqt-talkpage-history-title' => 'د خبرو اترو د مخ پېښليک',
	'lqt-reply-subpage' => 'ځوابول',
	'nstab-summary' => 'لنډيز',
);

/** Portuguese (Português)
 * @author 555
 * @author Crazymadlover
 * @author Giro720
 * @author Hamilton Abreu
 * @author Helder.wiki
 * @author Heldergeovane
 * @author Lijealso
 * @author Malafaya
 */
$messages['pt'] = array(
	'lqt-desc' => 'Adiciona discussões em formato de tópicos às páginas de discussão',
	'lqt_movethread' => 'Mover tópico para outra página',
	'lqt_deletethread' => 'Apagar ou recuperar tópico',
	'lqt_contents_title' => 'Conteúdo',
	'lqt_toc_thread_title' => 'Assunto do tópico',
	'lqt_toc_thread_author' => 'Iniciado por',
	'lqt_toc_thread_replycount' => 'Respostas',
	'lqt_toc_thread_modified' => 'Última alteração',
	'lqt_add_header' => 'Adicionar cabeçalho',
	'lqt_new_thread' => 'Iniciar uma discussão nova',
	'lqt_invalid_subject' => 'O assunto do tópico é inválido.
Pode:
* Ser demasiado longo, ou
* Entrar em conflito com os prefixos dos links interwikis ou com os nomes dos espaços nominais.',
	'lqt_empty_subject' => 'Deve inserir um assunto.',
	'lqt_reply' => 'Responder',
	'lqt-parent' => 'Tópico de raiz',
	'lqt_delete' => 'Apagar',
	'lqt_undelete' => 'Restaurar',
	'lqt_permalink' => 'Link permanente',
	'lqt_fragment' => 'Fragmento de uma $1 de $2',
	'lqt_discussion_link' => 'discussão',
	'lqt_from_talk' => 'Da página $1',
	'lqt-history-title' => 'Histórico do tópico',
	'lqt_hist_comment_edited' => 'Texto do comentário [$2 editado]',
	'lqt_hist_summary_changed' => 'Resumo alterado',
	'lqt_hist_reply_created' => 'Criada [[$1|resposta nova]]',
	'lqt_hist_thread_created' => 'Criado tópico novo',
	'lqt_hist_deleted' => 'Apagado',
	'lqt_hist_undeleted' => 'Recuperado',
	'lqt_hist_moved_talkpage' => 'Movido',
	'lqt_hist_listing_subtitle' => 'A ver uma listagem do histórico',
	'lqt_hist_view_whole_thread' => 'Ver histórico do tópico completo',
	'lqt_hist_no_revisions_error' => 'Este tópico não tem quaisquer revisões de histórico.',
	'lqt_hist_past_last_page_error' => 'Encontra-se para além do número de páginas de histórico existentes.',
	'lqt_hist_tooltip_newer_disabled' => 'Este link está desactivado porque você está na primeira página.',
	'lqt_hist_tooltip_older_disabled' => 'Este link está desactivado porque você está na última página.',
	'lqt_hist_split' => 'Resposta separada num tópico novo',
	'lqt_hist_edited_subject' => 'Assunto alterado de "$2" para "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Assunto alterado',
	'lqt_hist_merged_from' => '[[$1|Resposta]] movida para outro tópico',
	'lqt_hist_merged_to' => '[[$1|Resposta]] movida de outro tópico',
	'lqt_hist_split_from' => 'Separar para um tópico novo',
	'lqt_hist_root_blanked' => 'Texto do comentário eliminado',
	'lqt_hist_adjusted_sortkey' => 'Posição do tópico ajustada',
	'lqt_revision_as_of' => 'Revisão de $2 às $3.',
	'lqt_change_new_thread' => 'Esta é a revisão inicial deste tópico.',
	'lqt_change_reply_created' => 'O [$1 comentário assinalado] foi criado nesta revisão.',
	'lqt_change_edited_root' => 'O [$1 comentário assinalado] foi editado nesta revisão.',
	'lqt_change_edited_summary' => 'O resumo deste tópico foi editado',
	'lqt_change_deleted' => '[$1 Este tópico] ou o seu tópico de raiz foram apagados',
	'lqt_change_undeleted' => 'O [$1 tópico assinalado] foi recuperado',
	'lqt_change_moved' => '[$1 Este tópico] foi movido para outra página de discussão',
	'lqt_change_split' => '[$1 Este tópico] foi separado de outro tópico',
	'lqt_change_edited_subject' => 'O assunto deste tópico foi alterado de "$2" para "$3"',
	'lqt_change_merged_from' => 'Uma [$1 resposta] deste tópico foi movida para outro tópico',
	'lqt_change_merged_to' => 'A [$1 resposta assinalada] foi movida de outro tópico',
	'lqt_change_split_from' => 'Um [$1 sub-tópico] deste tópico foi separado para um tópico próprio',
	'lqt_change_root_blanked' => 'O texto de [$1 um comentário] foi apagado.',
	'lqt_youhavenewmessages' => 'Tem [[$1|mensagens novas]].',
	'lqt_protectedfromreply' => 'Este tópico foi $1 contra respostas.',
	'lqt_protectedfromreply_link' => 'protegido',
	'lqt_subject' => 'Assunto:',
	'lqt_noreason' => 'Não foi especificado nenhum motivo.',
	'lqt_move_placeholder' => 'Este tópico representa outro tópico, $1, que foi movido desta página.
A movimentação foi feita por $2 em $3 às $4.
Está agora em $5.',
	'lqt_thread_deleted_for_sysops' => "Este tópico foi '''eliminado''' e está visível apenas para administradores.",
	'lqt_thread_deleted' => 'Este tópico foi eliminado',
	'lqt_summary_notice' => 'Não houve alterações a esta discussão há pelo menos {{PLURAL:$2|um dia|dias}}.
Se está terminada, talvez queira $1.',
	'lqt_summary_notice_link' => 'escrever um resumo',
	'lqt_summary_label' => 'Resumo do tópico:',
	'lqt_summary_subtitle' => 'o resumo de "$1"',
	'lqt_nosuchrevision' => 'Essa revisão deste tópico não existe.',
	'lqt_nosuchthread' => 'O tópico que especificou não existe.',
	'lqt_nosuchthread_title' => 'Esse tópico não existe',
	'lqt_threadrequired' => 'Deve especificar um tópico na URL.',
	'lqt_move_movingthread' => 'Movendo $1, pertencente ao tópico $2.',
	'lqt_move_torename' => "Para alterar o nome deste tópico, $1 e altere o campo 'Assunto'.",
	'lqt_move_torename_edit' => 'edite-o',
	'lqt_move_destinationtitle' => 'Título da página de discussão de destino:',
	'lqt_move_move' => 'Mover',
	'lqt_move_nodestination' => 'Tem de especificar um destino.',
	'lqt_move_thread_bad_destination' => 'A página de destino não é uma página de discussão.',
	'lqt_move_samedestination' => 'Esse tópico já existe nesta página!',
	'lqt_move_noreason' => 'Não foi especificado um motivo.',
	'lqt_move_success' => 'O tópico foi movido para $1.',
	'lqt_delete_undeletethread' => 'Recuperar tópico',
	'lqt_delete_partof' => "Este tópico é parte de '''$1'''.",
	'lqt_delete_deleting' => "Apagando '''$1''' e '''todas as respostas''' relacionadas.",
	'lqt_delete_deletethread' => 'Apagar tópico e respostas',
	'lqt_delete_deleted' => 'Este tópico foi apagado.',
	'lqt_delete_undeleted' => 'Este tópico foi recuperado.',
	'lqt_delete_return' => 'Voltar para $1.',
	'lqt_delete_return_link' => 'a página de discussão',
	'lqt_delete_unallowed' => 'Não está autorizado a apagar tópicos.',
	'lqt_delete_show_checkbox' => 'Mostrar tópicos apagados',
	'lqt_talkpage_autocreate_summary' => 'Página de discussão criada automaticamente quando o primeiro tópico foi criado.',
	'lqt_header_warning_big' => 'Está a editar um $1.',
	'lqt_header_warning_after_big' => 'Os cabeçalhos são para anúncios e prefácios.
Em alternativa, talvez queira $2.',
	'lqt_header_warning_bold' => 'cabeçalho da página de discussão',
	'lqt_header_warning_new_discussion' => 'iniciar uma discussão nova',
	'lqt_sorting_order' => 'Ordenação:',
	'lqt_sort_newest_changes' => 'últimos modificados primeiro',
	'lqt_sort_newest_threads' => 'tópicos novos primeiro',
	'lqt_sort_oldest_threads' => 'tópicos mais antigos primeiro',
	'lqt-title' => 'Título',
	'lqt-summary' => 'Resumo',
	'lqt-searching' => 'A procurar tópicos',
	'lqt-read-message' => 'Marcar lido',
	'lqt-read-message-tooltip' => 'Remover este tópico das mensagens novas.
Ainda estará visível na página de discussão original.',
	'lqt-read-all' => 'Marcar todas as mensagens como lidas',
	'lqt-read-all-tooltip' => 'Remover todos os tópicos das mensagens novas.
Ainda estarão visíveis nas páginas de discussão originais.
Esta operação é irreversível.',
	'lqt-marked-read' => "Tópico '''$1''' marcado como lido.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mensagem marcada como lida|mensagens marcadas como lidas}}.',
	'lqt-email-undo' => 'Desfazer',
	'lqt-no-new-messages' => 'Não tem mensagens novas.',
	'lqt-new-messages' => '✒ Tem mensagens novas.',
	'lqt-email-info-undo' => 'Recuperar o tópico que acabou de descartar.',
	'lqt-date-info' => 'Este link está desactivado porque está a ver tópicos de todas as datas.',
	'lqt-newmessages-context' => 'Tópico completo',
	'lqt-thread-created' => 'Criado',
	'lqt-history-time' => 'Data',
	'lqt-history-user' => 'Utilizador',
	'lqt-history-action' => 'Acção',
	'lqt-history-comment' => 'Comentário',
	'lqt-history-thread' => 'Tópico',
	'lqt-thread-edited-author' => 'Editado pelo autor.<br />
Última edição: $1',
	'lqt-thread-edited-others' => 'Editado por {{PLURAL:$2|outro utilizador|$2 outros utilizadores}}.<br />
Última edição: $1',
	'lqt-header-actions' => 'Acções',
	'lqt_summarize_link' => 'Resumir',
	'lqt-summarize-intro' => 'Por favor, resuma o tópico na caixa de edição.
Pode usar texto wiki no resumo. Quando terminar, clique "{{int:savearticle}}".',
	'lqt-thread-split' => 'Separar para tópico novo',
	'lqt-split-success' => 'Separou o tópico $1 com sucesso.',
	'lqt_split_thread' => 'Separar um tópico',
	'lqt-thread-split-subject' => 'Assunto do tópico novo:',
	'lqt-thread-split-thread' => 'Tópico:',
	'lqt-split-submit' => 'Separar',
	'lqt_split_badsubject' => 'O assunto é inválido.',
	'lqt-no-threads' => 'Esta página ainda não contém tópicos.',
	'lqt-delete-parent-warning' => 'Este tópico está no nível de topo e tem respostas.
As respostas também serão automaticamente apagadas.
Para evitá-lo, separe-as antes de apagar o tópico.',
	'lqt-delete-parent-deleted' => 'Tópico de origem apagado ($1)',
	'lqt-delete-replies-done' => 'Todas as respostas a este tópico foram também apagadas.',
	'lqt-movethread' => 'Mover',
	'lqt-menu-trigger' => 'Mais',
	'lqt-newmessages-from' => 'Página: $1',
	'lqt-hot-topics' => 'Tópicos populares',
	'lqt-add-reply' => 'Adicionar resposta',
	'lqt_rc_new_discussion' => 'criou um tópico novo, "$1"',
	'lqt_rc_new_reply' => 'criou uma resposta no tópico "$1"',
	'right-lqt-split' => 'Separar tópicos',
	'right-lqt-merge' => 'Juntar tópicos',
	'right-lqt-react' => 'Responder a tópicos',
	'lqt-thread-merge' => 'Juntar a outro tópico',
	'lqt-thread-merge-to' => 'Juntar a este tópico',
	'lqt_merge_thread' => 'Juntar tópico',
	'lqt-thread-merge-source' => 'Tópico de origem:',
	'lqt-thread-merge-dest' => 'Tópico de destino:',
	'lqt-merge-submit' => 'Juntar',
	'lqt-merge-success' => 'Juntou o tópico $1 ao tópico $2 com sucesso.',
	'lqt-log-name' => 'Registo de discussões em tópicos',
	'lqt-log-header' => 'Este registo detalha as acções tomadas nos tópicos de discussão.',
	'lqt-log-action-move' => 'movido [[$1]] de [[$2]] para [[$3]].',
	'lqt-log-action-split' => 'separou [[$1]] do tópico [[$3]], e deu-lhe o novo assunto "$2"',
	'lqt-log-action-merge-across' => 'moveu [[$1]] do tópico [[$2]] para o tópico [[$3]]',
	'lqt-log-action-merge-down' => 'moveu [[$1]] para o tópico [[$3]]',
	'lqt-log-action-subjectedit' => 'alterou o assunto de [[$1]], de "$2" para "$3"',
	'lqt-log-action-resort' => 'modificou a ordenação de [[$1]]. Alterou a chave de ordenação, de $2 para $3',
	'lqt-preference-notify-talk' => 'Notificar-me por correio electrónico das respostas a um tópico que eu esteja a vigiar',
	'lqt-preference-watch-threads' => 'Vigiar tópicos que eu criar ou aos quais responda',
	'prefs-lqt' => 'Discussão em tópicos',
	'lqt-preference-display-depth' => 'Profundidade máxima de respostas a mostrar:',
	'lqt-preference-display-count' => 'Número máximo de respostas a mostrar:',
	'lqt-preference-custom-signatures' => 'Mostrar assinaturas personalizadas',
	'lqt-enotif-subject-reply' => 'Discussão na {{SITENAME}} - Resposta: $1',
	'lqt-enotif-subject-newthread' => 'Discussão na {{SITENAME}} - Tópico novo: $1',
	'lqt-enotif-newthread' => "Olá $1,

Esta é uma notificação da {{SITENAME}}, de que foi criado um tópico novo na página $5, com o assunto '$2', às $4 de $3, por $8.

Pode vê-lo em <$6>

O texto é:
$7",
	'lqt-enotif-reply' => "Olá $1,

Esta é uma notificação da {{SITENAME}}, de que foi criada uma resposta nova ao tópico '$2', na página $5, às $4
de $3, por $8.

Pode vê-la em <$6>

O texto da resposta é:
$7",
	'lqt-quote-intro' => 'A $2 às $3, [[User:$1|$1]] escreveu:',
	'lqt-quote' => 'Citar',
	'lqt-search-legend' => 'Pesquise as discussões nesta página',
	'lqt-search-label' => 'Termos a pesquisar:',
	'lqt-search-button' => 'Pesquisar',
	'searchprofile-threads' => 'Discussões',
	'searchprofile-threads-tooltip' => 'Pesquisar discussões por tópicos e páginas de discussão',
	'lqt-ajax-updated' => 'Este tópico tem respostas novas.',
	'lqt-ajax-update-link' => 'Actualizar',
	'lqt-thread-show-replies' => 'Mostrar $1 {{PLURAL:$1|resposta|respostas}}',
	'lqt-thread-show-more' => 'Mostrar mais respostas',
	'lqt-thread-link-url' => 'URL do link:',
	'lqt-thread-link-title' => 'Link de texto wiki:',
	'lqt-thread-link-copy' => 'Copiar',
	'lqt-sign-not-necessary' => 'Não é necessário assinar as suas mensagens com quatro tiles.
A assinatura é apresentada automaticamente.',
	'lqt-marked-as-read-placeholder' => 'O tópico $1 foi marcado como lido.',
	'lqt-change-subject' => 'Alterar assunto',
	'lqt-save-subject' => 'Gravar',
	'lqt-save-subject-failed' => 'Ocorreu o seguinte erro ao tentar alterar o assunto deste tópico: $1',
	'lqt-ajax-invalid-subject' => 'O assunto que introduziu era inválido, provavelmente por ser demasiado longo.',
	'lqt-ajax-no-subject' => 'Tem de especificar o assunto do tópico novo.',
	'lqt-save-subject-error-unknown' => 'Ocorreu um erro desconhecido ao tentar definir o assunto deste tópico. Por favor, tente fazê-lo clicando "editar" na mensagem do topo.',
	'lqt-cancel-subject-edit' => 'Cancelar',
	'lqt-drag-activate' => 'Arrastar para outro local',
	'lqt-drag-drop-zone' => 'Largar aqui',
	'lqt-drag-confirm' => 'Para concluir as seguintes operações, por favor, preencha o motivo e clique "Confirmar".',
	'lqt-drag-reparent' => 'Mover mensagem para outro tópico de origem.',
	'lqt-drag-split' => 'Mover mensagem para um tópico próprio',
	'lqt-drag-setsortkey' => 'Ajustar posição da mensagem na página',
	'lqt-drag-bump' => 'Mover o tópico para o topo da página',
	'lqt-drag-save' => 'Confirmar',
	'lqt-drag-title' => 'Confirmar arrastamento',
	'lqt-drag-reason' => 'Motivo:',
	'lqt-drag-subject' => 'Assunto do tópico novo (obrigatório):',
	'lqt-edit-signature' => '(editar assinatura)',
	'lqt-preview-signature' => '(antever)',
	'lqt-feed-title-all' => '{{SITENAME}} - Mensagens novas',
	'lqt-feed-title-all-from' => '{{SITENAME}} - Mensagens novas {{PLURAL:$2|na página $1|nas páginas $1}}',
	'lqt-feed-title-new-threads' => '{{SITENAME}} - Tópicos novos',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} - Tópicos novos {{PLURAL:$2|na página $1|nas páginas $1}}',
	'lqt-feed-title-replies' => '{{SITENAME}} - Respostas',
	'lqt-feed-title-replies-from' => '{{SITENAME}} - Respostas {{PLURAL:$2|na página $1|nas páginas $1}}',
	'lqt-feed-new-thread-intro' => 'Tópico novo em $1 colocado por $2',
	'lqt-feed-reply-intro' => 'Resposta a $3 (em $1) colocada por $2',
	'tooltip-pt-newmessages' => 'Mostra as mensagens novas nos tópicos, ou nas páginas de discussão por tópicos, que está a vigiar',
	'lqt-newmessages-n' => 'Mensagens novas ($1)',
	'lqt_newmessages' => 'Mensagens (Nenhuma)',
	'lqt_newmessages-title' => 'Mensagens',
	'lqt-newpost-summary' => 'Tópico novo: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Introduza o texto deste tópico e apague esta linha, por favor.',
	'lqt-reply-summary' => 'Resposta a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Histórico da página de discussão',
	'lqt-talkpage-history-subtitle' => 'Da página $1',
	'lqt-talkpage-history-tab' => 'Cabeçalho',
	'restriction-reply' => 'Enviar respostas',
	'restriction-newthread' => 'Enviar tópicos novos',
	'lqt-protected-reply-thread' => 'Não pode responder porque este tópico foi protegido contra mensagens novas.',
	'lqt-protected-reply-talkpage' => 'Não pode responder porque esta página de discussão foi protegida contra respostas aos tópicos.',
	'lqt-protected-newthread' => 'Não pode criar tópicos porque esta página de discussão foi protegida contra tópicos novos.',
	'lqt-edit-bump' => 'Puxar este tópico',
	'lqt-edit-bump-tooltip' => 'Mover este tópico para o topo da página de discussão',
	'lqt-historicalrevision-error' => 'A revisão que seleccionou está corrompida e não pode ser vista.',
	'lqt-reply-subpage' => 'resposta',
	'nstab-thread' => 'Tópico',
	'nstab-summary' => 'Resumo',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author 555
 * @author Crazymadlover
 * @author Eduardo.mps
 * @author Giro720
 * @author Helder.wiki
 * @author Heldergeovane
 * @author Luckas Blade
 */
$messages['pt-br'] = array(
	'lqt-desc' => 'Adiciona discussões em tópicos a páginas de discussão',
	'lqt_movethread' => 'Mover tópico para outra página',
	'lqt_deletethread' => 'Apagar ou recuperar tópico',
	'lqt_contents_title' => 'Conteúdo',
	'lqt_toc_thread_title' => 'Título do tópico',
	'lqt_toc_thread_author' => 'Iniciado por',
	'lqt_toc_thread_replycount' => 'Respostas',
	'lqt_toc_thread_modified' => 'Última modificação',
	'lqt_add_header' => 'Adicionar cabeçalho',
	'lqt_new_thread' => 'Iniciar um novo tópico',
	'lqt_invalid_subject' => 'O assunto fornecido é inválido.
Ele pode:
* Ser logo de mais, ou
* Estar em conflito com os prefixos das ligações interprojeto ou nomes dos espaços nominais.',
	'lqt_empty_subject' => 'Você deve fornecer um assunto.',
	'lqt_reply' => 'Responder',
	'lqt-parent' => 'Tópico de raiz',
	'lqt_delete' => 'Apagar',
	'lqt_undelete' => 'Restaurar',
	'lqt_permalink' => 'Ligação permanente',
	'lqt_fragment' => 'Fragmento de uma $1 de $2',
	'lqt_discussion_link' => 'discussão',
	'lqt_from_talk' => 'De $1',
	'lqt-history-title' => 'Histórico do tópico',
	'lqt_hist_comment_edited' => 'Texto do comentário [$2 editado]',
	'lqt_hist_summary_changed' => 'Resumo alterado',
	'lqt_hist_reply_created' => '[[$1|Nova resposta]] criada',
	'lqt_hist_thread_created' => 'Novo tópico criado',
	'lqt_hist_deleted' => 'Apagado',
	'lqt_hist_undeleted' => 'Recuperado',
	'lqt_hist_moved_talkpage' => 'Movido',
	'lqt_hist_listing_subtitle' => 'Visualizando uma listagem de histórico',
	'lqt_hist_view_whole_thread' => 'Ver histórico do tópico completo',
	'lqt_hist_no_revisions_error' => 'Este tópico não tem quaisquer revisões de histórico.',
	'lqt_hist_past_last_page_error' => 'Você está além do número de páginas de histórico existentes.',
	'lqt_hist_tooltip_newer_disabled' => 'Esta ligação está desativada porque você está na primeira página.',
	'lqt_hist_tooltip_older_disabled' => 'Esta ligação está desativada porque se você está na última página.',
	'lqt_hist_split' => 'Resposta separada em um novo tópico',
	'lqt_hist_edited_subject' => 'Assunto alterado de "$2" para "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Assunto alterado',
	'lqt_hist_merged_from' => '[[$1|Resposta]] movida para outro tópico',
	'lqt_hist_merged_to' => '[[$1|Resposta]] movida a partir de outro tópico',
	'lqt_hist_split_from' => 'Separar em um novo tópico',
	'lqt_hist_root_blanked' => 'Texto do comentário eliminado',
	'lqt_hist_adjusted_sortkey' => 'Posição do tópico ajustada',
	'lqt_revision_as_of' => 'Revisão em $2 às $3.',
	'lqt_change_new_thread' => 'Esta é a revisão inicial deste tópico.',
	'lqt_change_reply_created' => 'O [$1 comentário destacado] foi criado nesta revisão.',
	'lqt_change_edited_root' => 'O [$1 comentário destacado] foi editado nesta revisão.',
	'lqt_change_edited_summary' => 'O resumo do tópico foi editado',
	'lqt_change_deleted' => '[$1 Este tópico] ou o seu tópico de raiz foram apagados',
	'lqt_change_undeleted' => 'O [$1 tópico assinalado] foi recuperado',
	'lqt_change_moved' => '[$1 Este tópico] foi movido para outra página de discussão',
	'lqt_change_split' => '[$1 Este tópico] foi separado de outro tópico',
	'lqt_change_edited_subject' => 'O assunto deste tópico foi alterado de "$2" para "$3"',
	'lqt_change_merged_from' => 'Uma [$1 resposta] a este tópico foi movida para outro tópico',
	'lqt_change_merged_to' => 'A [$1 resposta destacada] foi movida a partir de outro tópico',
	'lqt_change_split_from' => 'Um [$1 subtópico] deste tópico foi separado para um tópico próprio',
	'lqt_change_root_blanked' => 'O texto de [$1 um comentário] foi apagado.',
	'lqt_youhavenewmessages' => 'Você tem [[$1|novas mensagens]].',
	'lqt_protectedfromreply' => 'Este tópico foi $1 contra respostas.',
	'lqt_protectedfromreply_link' => 'protegido',
	'lqt_subject' => 'Assunto:',
	'lqt_noreason' => 'Nenhum motivo foi especificado.',
	'lqt_move_placeholder' => 'Este tópico é uma representação que indica que um tópico, $1, foi movido desta página.
Esta movimentação foi feita por $2 em $3 $4. Agora o tópico está em $5.',
	'lqt_thread_deleted_for_sysops' => "Este tópico foi '''eliminado''' e está visível apenas para administradores.",
	'lqt_thread_deleted' => 'Este tópico foi eliminado',
	'lqt_summary_notice' => 'Não houve alterações a esta discussão há pelo menos $2 {{PLURAL:$2|dia|dias}}.
Se ela se encontra terminada, talvez queira $1.',
	'lqt_summary_notice_link' => 'escrever um resumo',
	'lqt_summary_label' => 'Resumo do tópico:',
	'lqt_summary_subtitle' => 'o resumo de "$1"',
	'lqt_nosuchrevision' => 'Não existe essa revisão deste tópico.',
	'lqt_nosuchthread' => 'O tópico que você especificou não existe',
	'lqt_nosuchthread_title' => 'Não existe este tópico',
	'lqt_threadrequired' => 'Deverá especificar um tópico no URL.',
	'lqt_move_movingthread' => 'Movendo $1.
Este tópico é parte de $2.',
	'lqt_move_torename' => "Para renomear este tópico, $1 e altere o campo 'Assunto'.",
	'lqt_move_torename_edit' => 'edite-o',
	'lqt_move_destinationtitle' => 'Título da página de discussão destino:',
	'lqt_move_move' => 'Mover',
	'lqt_move_nodestination' => 'Você tem que especificar um destino.',
	'lqt_move_thread_bad_destination' => 'A página de destino não é uma página de discussão.',
	'lqt_move_samedestination' => 'Esse tópico já existe nesta página!',
	'lqt_move_noreason' => 'Nenhum motivo foi especificado.',
	'lqt_move_success' => 'O tópico foi movido para $1.',
	'lqt_delete_undeletethread' => 'Restaurar Tópico',
	'lqt_delete_partof' => "Este tópico é parte de '''$1'''.",
	'lqt_delete_deleting' => "Apagando '''$1''' e '''todas as respostas''' relacionadas.",
	'lqt_delete_deletethread' => 'Apagar tópico e respostas',
	'lqt_delete_deleted' => 'Este tópico foi eliminado.',
	'lqt_delete_undeleted' => 'Este tópico foi restaurado.',
	'lqt_delete_return' => 'Voltar para $1.',
	'lqt_delete_return_link' => 'a página de discussão',
	'lqt_delete_unallowed' => 'Você não está autorizado a eliminar tópicos.',
	'lqt_delete_show_checkbox' => 'Mostrar tópicos eliminados',
	'lqt_talkpage_autocreate_summary' => 'Página de discussão criada automaticamente após o primeiro tópico ter sido colocado.',
	'lqt_header_warning_big' => 'Você está a editar um $1.',
	'lqt_header_warning_after_big' => 'Os cabeçalhos são para anúncios e prefácios.
Talvez queira em alternativa $2.',
	'lqt_header_warning_bold' => 'cabeçalho da página de discussão',
	'lqt_header_warning_new_discussion' => 'iniciar uma nova discussão',
	'lqt_sorting_order' => 'Ordenação:',
	'lqt_sort_newest_changes' => 'primeiro os modificados por último',
	'lqt_sort_newest_threads' => 'primeiro os tópicos mais recentes',
	'lqt_sort_oldest_threads' => 'primeiro os tópicos mais antigos',
	'lqt-title' => 'Título',
	'lqt-summary' => 'Resumo',
	'lqt-searching' => 'Procurando tópicos',
	'lqt-read-message' => 'Lido',
	'lqt-read-message-tooltip' => 'Remover este tópico das novas mensagens.
Ainda estará visível na sua página de discussão original.',
	'lqt-read-all' => 'Marcar todos como lidos',
	'lqt-read-all-tooltip' => 'Remover todos os tópicos de novas mensagens.
Ainda estarão visíveis nas suas páginas de discussão originais.
Esta operação é reversível.',
	'lqt-marked-read' => "Tópico '''$1''' marcado como lido.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mensagem marcada como lida|mensagens marcadas como lidas}}.',
	'lqt-email-undo' => 'Desfazer',
	'lqt-no-new-messages' => 'Não há novas mensagens para você.',
	'lqt-new-messages' => '✒ Há novas mensagens para você.',
	'lqt-email-info-undo' => 'Trazer de volta o tópico que você acabou de descartar.',
	'lqt-date-info' => 'Esta ligação está inativa porque você está a visualizando tópicos de todas as datas.',
	'lqt-newmessages-context' => 'Tópico completo',
	'lqt-thread-created' => 'Criado',
	'lqt-history-time' => 'Data',
	'lqt-history-user' => 'Usuário',
	'lqt-history-action' => 'Atividade',
	'lqt-history-comment' => 'Comentário',
	'lqt-history-thread' => 'Tópico',
	'lqt-thread-edited-author' => 'Editado pelo autor.<br />
Última edição: $1',
	'lqt-thread-edited-others' => 'Editado por {{PLURAL:$2|outro usuário|$2 outros usuários}}.<br />
Última edição: $1',
	'lqt-header-actions' => 'Ações',
	'lqt_summarize_link' => 'Resumir',
	'lqt-summarize-intro' => 'Por favor, resuma o tópico abaixo na caixa de edição.
Você pode usar qualquer wikitexto em seu resumo. Quando terminar, clique em "{{int:savearticle}}".',
	'lqt-thread-split' => 'Separar em um novo tópico',
	'lqt-split-success' => 'Você separou o tópico $1 com sucesso.',
	'lqt_split_thread' => 'Separar um tópico',
	'lqt-thread-split-subject' => 'Assunto do tópico novo:',
	'lqt-thread-split-thread' => 'Tópico:',
	'lqt-split-submit' => 'Separar',
	'lqt_split_badsubject' => 'O assunto que você forneceu é inválido.',
	'lqt-no-threads' => 'Esta página ainda não contém tópicos.',
	'lqt-delete-parent-warning' => 'Este é tópico de alto nível com respostas.
As respostas também serão automaticamente apagadas.
Para evitá-lo, separe-as antes de apagar o tópico.',
	'lqt-delete-parent-deleted' => 'Tópico de origem apagado ($1)',
	'lqt-delete-replies-done' => 'Todas as respostas deste tópico foram também apagadas.',
	'lqt-movethread' => 'Mover',
	'lqt-menu-trigger' => 'Mais',
	'lqt-newmessages-from' => 'Página: $1',
	'lqt-hot-topics' => 'Tópicos quentes',
	'lqt-add-reply' => 'Adicionar resposta',
	'lqt_rc_new_discussion' => 'criou um novo tópico: "$1"',
	'lqt_rc_new_reply' => 'respondeu "$1"',
	'right-lqt-split' => 'Separar tópicos',
	'right-lqt-merge' => 'Mesclar tópicos',
	'lqt-thread-merge' => 'Mesclar em outro tópico',
	'lqt-thread-merge-to' => 'Mesclar neste tópico',
	'lqt_merge_thread' => 'Mesclar tópico',
	'lqt-thread-merge-source' => 'Tópico de origem:',
	'lqt-thread-merge-dest' => 'Tópico de destino:',
	'lqt-merge-submit' => 'Mesclar',
	'lqt-merge-success' => 'Você mesclou com sucesso o tópico $1 abaixo de $2',
	'lqt-log-name' => 'Registro de discussões em tópicos',
	'lqt-log-header' => 'Este registro detalha as ações tomadas nos tópicos de discussão',
	'lqt-log-action-move' => 'movido [[$1]] de [[$2]] para [[$3]].',
	'lqt-log-action-split' => 'separou [[$1]] do tópico [[$3]], e deu-lhe o novo assunto "$2"',
	'lqt-log-action-merge-across' => 'moveu [[$1]] do tópico [[$2]] para o tópico [[$3]]',
	'lqt-log-action-merge-down' => 'moveu [[$1]] para o tópico [[$3]]',
	'lqt-log-action-subjectedit' => 'alterou o assunto de [[$1]], de "$2" para "$3"',
	'lqt-log-action-resort' => 'modificou a ordenação de [[$1]]. Alterou a chave de ordenação, de $2 para $3',
	'lqt-preference-notify-talk' => 'Notificar-me por e-mail sobre as respostas de tópicos que eu estou vigiando',
	'lqt-preference-watch-threads' => 'Vigiar tópicos que eu venha a criar ou responder',
	'prefs-lqt' => 'Discussão em tópicos',
	'lqt-preference-display-depth' => 'Profundidade máxima de respostas a serem mostradas:',
	'lqt-preference-display-count' => 'Número máximo de respostas a mostrar:',
	'lqt-preference-custom-signatures' => 'Mostrar assinaturas personalizadas',
	'lqt-enotif-subject-reply' => 'Discussão na {{SITENAME}} - Resposta: $1',
	'lqt-enotif-subject-newthread' => 'Discussão na {{SITENAME}} - Tópico novo: $1',
	'lqt-enotif-newthread' => "Olá $1,
Esta é uma notificação da {{SITENAME}} de que foi criado um tópico novo na página $5, com o assunto '$2', em $3 às $4 por $8.

Você pode vê-lo em <$6>

O texto é o seguinte:
$7",
	'lqt-enotif-reply' => "Olá $1,
Esta é uma notificação da {{SITENAME}} de que há uma nova resposta ao tópico '$2', na página $5,
em $3 às $4 por $8.

Você pode vê-la em <$6>

O texto da resposta é:
$7",
	'lqt-quote-intro' => 'Em $2 às $3, [[User:$1|$1]] escreveu:',
	'lqt-quote' => 'Citar',
	'lqt-search-legend' => 'Pesquise as discussões nesta página',
	'lqt-search-label' => 'Termos a pesquisar:',
	'lqt-search-button' => 'Pesquisar',
	'searchprofile-threads' => 'Discussões',
	'searchprofile-threads-tooltip' => 'Pesquisar discussões por tópicos e páginas de discussão',
	'lqt-ajax-updated' => 'Este tópico tem respostas novas',
	'lqt-ajax-update-link' => 'Atualizar',
	'lqt-thread-show-replies' => 'Mostrar $1 {{PLURAL:$1|resposta|respostas}}',
	'lqt-thread-show-more' => 'Mostrar mais respostas',
	'lqt-thread-link-url' => 'Link URL:',
	'lqt-thread-link-title' => 'Link do texto wiki:',
	'lqt-thread-link-copy' => 'Copiar',
	'lqt-sign-not-necessary' => 'Não é necessário assinar as suas mensagens com quatro tiles.
A assinatura é apresentada automaticamente.',
	'lqt-marked-as-read-placeholder' => 'O tópico $1 foi marcado como lido.',
	'lqt-change-subject' => 'Alterar assunto',
	'lqt-save-subject' => 'Salvar',
	'lqt-save-subject-failed' => 'Ocorreu o seguinte erro ao tentar alterar o assunto deste tópico: $1',
	'lqt-ajax-invalid-subject' => 'O assunto que introduziu era inválido, provavelmente por ser demasiado longo.',
	'lqt-ajax-no-subject' => 'Você deve especificar o assunto do novo tópico.',
	'lqt-save-subject-error-unknown' => 'Ocorreu um erro desconhecido ao tentar definir o assunto deste tópico. Por favor, tente fazê-lo clicando "editar" na mensagem do superior.',
	'lqt-cancel-subject-edit' => 'Cancelar',
	'lqt-drag-activate' => 'Arrastar para outro local',
	'lqt-drag-drop-zone' => 'Soltar aqui',
	'lqt-drag-confirm' => 'Para concluir as seguintes operações, por favor, preencha o motivo e clique "Confirmar".',
	'lqt-drag-reparent' => 'Mover mensagem para outro tópico de origem.',
	'lqt-drag-split' => 'Mover mensagem para um tópico próprio',
	'lqt-drag-setsortkey' => 'Ajustar posição da mensagem na página',
	'lqt-drag-bump' => 'Mover o tópico para o topo da página',
	'lqt-drag-save' => 'Confirmar',
	'lqt-drag-title' => 'Confirmar arraste',
	'lqt-drag-reason' => 'Motivo:',
	'lqt-drag-subject' => 'Assunto do tópico novo:',
	'lqt-edit-signature' => '(editar assinatura)',
	'lqt-preview-signature' => '(previsualizar)',
	'lqt-feed-title-all' => '{{SITENAME}} - Mensagens novas',
	'lqt-feed-title-all-from' => '{{SITENAME}} - Mensagens novas {{PLURAL:$2|na página $1|nas páginas $1}}',
	'lqt-feed-title-new-threads' => '{{SITENAME}} - Tópicos novos',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} - Tópicos novos {{PLURAL:$2|na página $1|nas páginas $1}}',
	'lqt-feed-title-replies' => '{{SITENAME}} - Respostas',
	'lqt-feed-title-replies-from' => '{{SITENAME}} - Respostas {{PLURAL:$2|na página $1|nas páginas $1}}',
	'lqt-feed-new-thread-intro' => 'Tópico novo em $1 colocado por $2',
	'lqt-feed-reply-intro' => 'Resposta a $3 (em $1) enviada por $2',
	'tooltip-pt-newmessages' => 'Mostra, nas páginas que estiver vigiando, mensagens novas nos tópicos ou páginas de discussão por tópicos',
	'lqt-newmessages-n' => 'Novas mensagens ($1)',
	'lqt_newmessages' => 'Mensagens novas (nenhuma)',
	'lqt_newmessages-title' => 'Novas mensagens',
	'lqt-newpost-summary' => 'Tópico novo: $1',
	'lqt-reply-summary' => 'Resposta a [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Histórico da página de discussão',
	'lqt-talkpage-history-subtitle' => 'Da página $1',
	'lqt-talkpage-history-tab' => 'Cabeçalho',
	'restriction-reply' => 'Enviar respostas',
	'restriction-newthread' => 'Enviar tópicos novos',
	'lqt-protected-reply-thread' => 'Você não pode responder porque este tópico foi protegido contra mensagens novas.',
	'lqt-protected-reply-talkpage' => 'Você não pode responder porque esta página de discussão foi protegida contra respostas aos tópicos.',
	'lqt-protected-newthread' => 'Você não pode criar tópicos porque esta página de discussão foi protegida contra tópicos novos.',
	'lqt-edit-bump' => 'Puxar este tópico',
	'lqt-edit-bump-tooltip' => 'Mover este tópico para o topo da página de discussão',
	'lqt-historicalrevision-error' => 'A revisão que você selecionou está corrompida e não pode ser visualizada.',
	'lqt-reply-subpage' => 'responder',
	'nstab-thread' => 'Tópico',
	'nstab-summary' => 'Sumário',
);

/** Tarifit (Tarifit)
 * @author Jose77
 */
$messages['rif'] = array(
	'lqt_delete' => 'Sfaḍ',
	'lqt_protectedfromreply_link' => 'twaḥḍa',
	'lqt_newmessages' => 'Tibratin timaynutin',
);

/** Romanian (Română)
 * @author AdiJapan
 * @author Cin
 * @author Danutz
 * @author Firilacroco
 * @author KlaudiuMihaila
 * @author Minisarm
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'lqt-desc' => 'Adaugă discuțiile de thread în paginile de discuție',
	'lqt_movethread' => 'Mutați thread la o altă pagină',
	'lqt_deletethread' => 'Şterge sau nu șterge thread',
	'lqt_contents_title' => 'Cuprins',
	'lqt_toc_thread_title' => 'Titlu discuție',
	'lqt_toc_thread_author' => 'Început de',
	'lqt_toc_thread_replycount' => 'Răspunsuri',
	'lqt_toc_thread_modified' => 'Ultima modificare',
	'lqt_add_header' => 'Adaugă antet',
	'lqt_new_thread' => 'Începe o nouă discuție',
	'lqt_invalid_subject' => 'Subiectul care l-ați introdus este invalid.
Acesta poate fi:
* Prea lung, sau
* Întâmpină conflicte cu prefixele interwiki sau nume de spațiu de nume.',
	'lqt_empty_subject' => 'Trebuie să introduceți un subiect.',
	'lqt_reply' => 'Răspunde',
	'lqt-parent' => 'Părinte',
	'lqt_delete' => 'Şterge',
	'lqt_undelete' => 'Recuperare',
	'lqt_permalink' => 'Legătură către',
	'lqt_fragment' => 'Fragment dintr-o $1 de la $2',
	'lqt_discussion_link' => 'discuție',
	'lqt_from_talk' => 'De la $1',
	'lqt-history-title' => 'Istoric discuție',
	'lqt_hist_comment_edited' => 'Text comentariu [$2 modificat]',
	'lqt_hist_summary_changed' => 'Rezumat schimbat',
	'lqt_hist_reply_created' => '[[$1|Răspuns nou]] creat',
	'lqt_hist_thread_created' => 'Discuție nouă creată',
	'lqt_hist_deleted' => 'Şters',
	'lqt_hist_undeleted' => 'Restaurat',
	'lqt_hist_moved_talkpage' => 'Mutat',
	'lqt_hist_listing_subtitle' => 'Vizualizarea unei liste cu istoric',
	'lqt_hist_view_whole_thread' => 'Vedeți istoricul pentru întregul thread',
	'lqt_hist_no_revisions_error' => 'Acest thread nu are nicio revizie în istoric.',
	'lqt_hist_past_last_page_error' => 'Sunteți peste numărul de pagini din istoric care există.',
	'lqt_hist_tooltip_newer_disabled' => 'Această legătură este dezactivată deoarece sunteți pe prima pagină.',
	'lqt_hist_tooltip_older_disabled' => 'Această legătură este dezactivată deoarece sunteți pe prima pagină.',
	'lqt_hist_split' => 'Răspundeți separat într-un nou thread',
	'lqt_hist_edited_subject' => 'Subiect schimbat de la „$2” la „$3”',
	'lqt_hist_edited_subject_corrupt' => 'Subiect schimbat',
	'lqt_hist_merged_from' => '[[$1|Răspuns]] mutat în alt thread',
	'lqt_hist_merged_to' => '[[$1|Răspuns]] mutat din alt thread',
	'lqt_hist_root_blanked' => 'A fost eliminat comentariul',
	'lqt_hist_adjusted_sortkey' => 'Poziția threadului este ajustată',
	'lqt_revision_as_of' => 'Revizia ca de $2 la $3.',
	'lqt_change_new_thread' => 'Aceasta este revizia inițială a threadului.',
	'lqt_change_reply_created' => '[Comentariul evidențiat $1] a fost creat în această revizie.',
	'lqt_change_edited_root' => '[Comentariul evidențiat $1] a fost modificat în această revizie.',
	'lqt_change_edited_summary' => 'Rezumatul threadului a fost editat',
	'lqt_change_undeleted' => '[Comentariul evidențiat $1] nu a fost șters',
	'lqt_change_moved' => '[Acest thread $1] a fost mutat în altă pagină de discuție',
	'lqt_change_split' => '[Acest thread $1] a fost separat de la un alt thread',
	'lqt_change_edited_subject' => 'Subiectul acestui thread a fost schimbat de la „$2” la „$3”',
	'lqt_change_merged_from' => 'Un [răspuns $1]  la acest thread a fost mutat în alt thread',
	'lqt_change_merged_to' => '[Răspunsul evidențiat $1] a fost mutat de la alt thread',
	'lqt_change_split_from' => 'Un [subthread $1] al acestui thread a fost separat în propriul său thread',
	'lqt_change_root_blanked' => 'Textul de la [un comentariu $1] a fost eliminat.',
	'lqt_youhavenewmessages' => 'Aveți [[$1|noi mesaje]].',
	'lqt_protectedfromreply_link' => 'protejat',
	'lqt_subject' => 'Subiect:',
	'lqt_noreason' => 'Niciun motiv oferit.',
	'lqt_move_placeholder' => 'Un subiect, $1, a fost mutat de aici la $5.
Mutarea a fost efectuată de $2 la $3 $4.',
	'lqt_thread_deleted_for_sysops' => "Acest thread a fost '''șters''' și este vizibil doar administratorilor.",
	'lqt_thread_deleted' => 'Acest thread a fost șters.',
	'lqt_summary_notice_link' => 'scrieți un rezumat',
	'lqt_summary_label' => 'Rezumatul discuției:',
	'lqt_summary_subtitle' => 'Rezumatul lui „$1”',
	'lqt_nosuchrevision' => 'Nu există nicio astfel de revizie a acestui thread.',
	'lqt_nosuchthread_title' => 'Niciun astfel de fir',
	'lqt_threadrequired' => 'Trebuie să specificați un thread în URL.',
	'lqt_move_movingthread' => 'Se mută $1.
Acest thread este parte a $2.',
	'lqt_move_torename' => "Pentru a redenumi acest thread, $1 și schimbați câmpul 'Subiect'.",
	'lqt_move_torename_edit' => 'modificare',
	'lqt_move_destinationtitle' => 'Titlul paginii de destinație - discuție:',
	'lqt_move_move' => 'Redenumire',
	'lqt_move_nodestination' => 'Trebuie să specificați o destinație.',
	'lqt_move_thread_bad_destination' => 'Destinația de discuție nu este o pagină de discuție.',
	'lqt_move_samedestination' => 'Threadul este deja pe această pagină !',
	'lqt_move_noreason' => 'Niciun motiv oferit.',
	'lqt_move_success' => 'Threadul a fost mutat la $1.',
	'lqt_delete_undeletethread' => 'Anulează ștergerea threadului',
	'lqt_delete_deletethread' => 'Ştergeți thread și răspunsuri',
	'lqt_delete_deleted' => 'Threadul a fost șters.',
	'lqt_delete_return' => 'Înapoi la $1.',
	'lqt_delete_return_link' => 'pagina de discuții',
	'lqt_delete_unallowed' => 'Nu vă este permis să ștergeți threaduri.',
	'lqt_delete_show_checkbox' => 'Arată discuțiile șterse',
	'lqt_talkpage_autocreate_summary' => 'Pagina de discuții a fost creată automat când primul thread a fost postat.',
	'lqt_header_warning_big' => 'Modificați un/o $1.',
	'lqt_header_warning_bold' => 'antetul paginii de discuție',
	'lqt_header_warning_new_discussion' => 'începe o nouă discuție',
	'lqt_sorting_order' => 'Ordine de sortare:',
	'lqt_sort_newest_changes' => 'ultimul modificat întâi',
	'lqt_sort_newest_threads' => 'cea mai nouă dicuție întâi',
	'lqt_sort_oldest_threads' => 'cea mai veche discuție întâi',
	'lqt-title' => 'Titlu',
	'lqt-summary' => 'Rezumat',
	'lqt-searching' => 'Căutare discuții',
	'lqt-read-message' => 'Marchează ca citit',
	'lqt-read-message-tooltip' => 'Elimină acest fir de la mesaje noi.
Aceasta va fi încă vizibilă pe pagina sa de discuţie originală.',
	'lqt-read-all' => 'Marchează toate ca citite',
	'lqt-marked-read' => "Discuția '''$1''' a fost marcată ca citită.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|mesaj marcat ca citit|mesaje marcate ca citite}}.',
	'lqt-email-undo' => 'Anulare',
	'lqt-no-new-messages' => 'Nu sunt mesaje noi pentru dumneavoastră.',
	'lqt-new-messages' => '✒ Sunt mesaje noi pentru dumneavoastră.',
	'lqt-date-info' => 'Această legătură este dezactivată deoarece vizualizaţi fire de la toate datele.',
	'lqt-newmessages-context' => 'Discuțiile complete',
	'lqt-thread-created' => 'Creat',
	'lqt-history-time' => 'Timp',
	'lqt-history-user' => 'Utilizator',
	'lqt-history-action' => 'Activitate',
	'lqt-history-comment' => 'Comentariu',
	'lqt-history-thread' => 'Subiect',
	'lqt-thread-edited-author' => 'Modificat de autor. <br />
Ultima modificare: $ 1',
	'lqt-thread-edited-others' => 'Modificat de {{PLURAL: $ 2 |un alt utilizator |$2 utilizatori}}. <br />
Ultima modificare: $ 1',
	'lqt-header-actions' => 'Acțiuni',
	'lqt_summarize_link' => 'Rezumați',
	'lqt-thread-split' => 'Desparte într-o nouă discuție',
	'lqt-split-success' => 'Aţi desprins cu succes firul $1.',
	'lqt_split_thread' => 'Desparte o discuție',
	'lqt-thread-split-subject' => 'Subiectul noii discuții:',
	'lqt-thread-split-thread' => 'Subiect:',
	'lqt-split-submit' => 'Împarte',
	'lqt_split_badsubject' => 'Subiectul introdus este invalid.',
	'lqt-no-threads' => 'Încă nu există discuții pe această pagină.',
	'lqt-delete-parent-deleted' => 'Discuția părinte a fost ștearsă ($1)',
	'lqt-delete-replies-done' => 'Toate răspunsurile la acest fir au fost şterse.',
	'lqt-movethread' => 'Mutare',
	'lqt-menu-trigger' => 'Adiț.',
	'lqt-newmessages-from' => 'De la $1',
	'lqt-hot-topics' => 'Subiecte calde',
	'lqt-add-reply' => 'Adaugă un răspuns',
	'lqt_rc_new_discussion' => 'postat un nou fir, „$1”',
	'lqt_rc_new_reply' => 'postat un răspuns la „$1”',
	'right-lqt-split' => 'Desparte subiecte',
	'right-lqt-merge' => 'Unește subiecte',
	'lqt-thread-merge' => 'Unește în alt subiect',
	'lqt-thread-merge-to' => 'Unește în acest subiect',
	'lqt_merge_thread' => 'Unește subiecte',
	'lqt-thread-merge-source' => 'Subiect sursă:',
	'lqt-thread-merge-dest' => 'Subiect destinație:',
	'lqt-merge-submit' => 'Unește',
	'lqt-preference-notify-talk' => 'Trimite-mi e-mail la răspunsurile discuțiilor pe care le urmăresc',
	'lqt-preference-display-count' => 'Numărul maxim de răspunsuri de arătat:',
	'lqt-enotif-subject-reply' => 'Discuție {{SITENAME}} - Răspuns: $1',
	'lqt-enotif-subject-newthread' => 'Discuție {{SITENAME}} - Subiect nou: $1',
	'lqt-quote-intro' => 'Pe $2 la $3, [[User:$1|$1]] a scris:',
	'lqt-quote' => 'Citare',
	'lqt-search-legend' => 'Caută discuţii pe această pagină',
	'lqt-search-label' => 'Termeni căutaţi:',
	'lqt-search-button' => 'Căutare',
	'searchprofile-threads' => 'Discuții',
	'searchprofile-threads-tooltip' => 'Caută firele de discuţie şi paginile de discuţii',
	'lqt-ajax-updated' => 'Acest thread are noi posturi.',
	'lqt-ajax-update-link' => 'Actualizare',
	'lqt-thread-show-replies' => 'Arată $1 {{PLURAL:$1|răspuns|răspunsuri}}',
	'lqt-thread-show-more' => 'Arată mai multe răspunsuri',
	'lqt-thread-link-url' => 'Legătură URL:',
	'lqt-thread-link-title' => 'Legătură wikitext:',
	'lqt-thread-link-copy' => 'Copiere în clipboard',
	'lqt-marked-as-read-placeholder' => 'Threadul $1 a fost marcat ca citit.',
	'lqt-change-subject' => 'Schimbă subiectul',
	'lqt-save-subject' => 'Salvare',
	'lqt-save-subject-failed' => 'S-a produs următoarea eroare în timp ce se încerca să se schimbe subiectul acestui thread: $1',
	'lqt-ajax-invalid-subject' => 'Subiectul care l-ați specificat a fost invalid, probabil pentru că a fost prea lung.',
	'lqt-ajax-no-subject' => 'Trebuie să specificați un subiect pentru noua discuție.',
	'lqt-cancel-subject-edit' => 'Revocare',
	'lqt-drag-activate' => 'Trageți către nouă locație',
	'lqt-drag-drop-zone' => 'Lasă aici',
	'lqt-drag-split' => 'Mută postarea la firul propriu',
	'lqt-drag-save' => 'Confirmare',
	'lqt-drag-title' => 'Confirmați mutarea',
	'lqt-drag-reason' => 'Motiv:',
	'lqt-drag-subject' => 'Subiect pentru noua discuție (obligatoriu):',
	'lqt-edit-signature' => '(editează semnătura)',
	'lqt-preview-signature' => '(previzualizare)',
	'lqt-feed-title-all' => '{{SITENAME}} — Mesaje noi',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Mesaje noi de la $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Subecte noi',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Discuții noi de la $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Răspunsuri',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Răspunsuri de la $1',
	'lqt-feed-new-thread-intro' => 'Discuție nouă la $1 postată de $2',
	'lqt-feed-reply-intro' => 'Răspunde la $3 (la $1) postat de $2',
	'tooltip-pt-newmessages' => 'Afișează comentarii noi la discuții existente sau comentarii pe paginile de discuții urmărite',
	'lqt-newmessages-n' => 'Mesaje noi ($1)',
	'lqt_newmessages' => 'Mesajele mele noi (niciunul)',
	'lqt_newmessages-title' => 'Mesaje noi',
	'lqt-newpost-summary' => 'Discuție nouă: $1',
	'lqt-reply-summary' => 'Răspunde la [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Istoricul paginii de discuție',
	'lqt-talkpage-history-subtitle' => 'Pentru $1',
	'lqt-talkpage-history-tab' => 'Antet',
	'restriction-reply' => 'Postați răspunsuri',
	'restriction-newthread' => 'Postați subiecte noi',
	'lqt-protected-reply-thread' => 'Nu puteți posta în acest thread deoarece a fost protejat de noi posturi.',
	'lqt-protected-reply-talkpage' => 'Nu puteți posta în acest thread deoarece această pagină de discuție a fost protejată de răspunsuri la threadurile sale.',
	'lqt-protected-newthread' => 'Nu puteți posta noi threaduri la această pagină de discuție deoarece a fost protejată de noi threaduri.',
	'lqt-historicalrevision-error' => 'Versiunea pe care ați selectat-o este coruptă și nu poate fi vizualizată.',
	'lqt-reply-subpage' => 'răspuns',
	'nstab-thread' => 'Subiect',
	'nstab-summary' => 'Rezumat',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'lqt-desc' => "Aggiunge le 'ngazzaminde pe argomende a lepàggene de le 'ngazzaminde",
	'lqt_movethread' => "Spuèste l'argomende jndr'à 'n'otra pàgene",
	'lqt_deletethread' => "Scangille o repristine l'argomende",
	'lqt_contents_title' => 'Condenute',
	'lqt_toc_thread_title' => "Titele de l'argomende",
	'lqt_toc_thread_author' => 'Accumenzate da',
	'lqt_toc_thread_replycount' => 'Risposte',
	'lqt_toc_thread_modified' => 'Urteme cangiamende',
	'lqt_add_header' => "Aggiunge 'na testate",
	'lqt_new_thread' => "Accuminze 'n'ingazzamende nuève",
	'lqt_invalid_subject' => "'U suggette ca tu è mise jè invalide.
Pò essere:
* Troppe luènghe, o
* Vè in conflitte cu le prefisse inderuicchi o 'u nome de le namespace.",
	'lqt_empty_subject' => "Tu à mettere 'nu suggette.",
	'lqt_reply' => 'Respunne',
	'lqt-parent' => 'Attane',
	'lqt_delete' => 'Scangille',
	'lqt_undelete' => 'Repristine',
	'lqt_permalink' => 'Apponde a',
	'lqt_fragment' => 'Frammende de $1 da $2',
	'lqt_discussion_link' => "'ngazzamende",
	'lqt_from_talk' => 'Da $1',
	'lqt-history-title' => "Cunde de l'argomende",
	'lqt_hist_comment_edited' => "Teste d'u commende [$2 cangiate]",
	'lqt_hist_summary_changed' => 'Riepileghe cangiate',
	'lqt_hist_reply_created' => '[[$1|Resposta nove]] ccrejate',
	'lqt_hist_thread_created' => 'Argomende nuève ccrejate',
	'lqt_hist_deleted' => 'Scangillete',
	'lqt_hist_undeleted' => 'Ripristinete',
	'lqt_hist_moved_talkpage' => 'Spustete',
	'lqt_hist_listing_subtitle' => "Visualizzazzione de 'n'elenghe d'u cunde",
	'lqt_hist_view_whole_thread' => "Vide 'a sotrie pe tutte l'argomende",
	'lqt_hist_no_revisions_error' => "St'argomende non ge tène nisciuna storie de le revisiune.",
	'lqt_hist_past_last_page_error' => "Tu è subranate 'u numere de le pàggene d'u cunde ca esistene.",
	'lqt_hist_tooltip_newer_disabled' => 'Stu collegamende ha state disabilitate purcé tu stè sus a prima pàgene.',
	'lqt_hist_tooltip_older_disabled' => "Stu collegamende ha state disabilitate purcé tu stè sus l'urtema pàgene.",
	'lqt_hist_split' => "'A resposte jè divise jndr'à 'nu nuève argomende",
	'lqt_hist_edited_subject' => 'Cangiate \'u suggette da "$2" a "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Suggette cangiate',
	'lqt_hist_merged_from' => "[[$1|Resposte]] spustate sus a 'n'otre argomende",
	'lqt_hist_merged_to' => "[[$1|Resposte]] spustate da 'n'otre argomende",
	'lqt_hist_split_from' => "Divide jndr'à 'n'argomende nuève",
	'lqt_hist_root_blanked' => "Teste d'u commende luate",
	'lqt_hist_adjusted_sortkey' => "Posizione de l'argomende conzigliate",
	'lqt_revision_as_of' => "Revisione d'u $2 a le $3.",
	'lqt_change_new_thread' => "Queste jè 'a versione inziale d'u 'ngazzamende.",
	'lqt_change_reply_created' => "'U [$1 commende evidenziate] ha state ccrejate jndr'à sta revisione.",
	'lqt_change_edited_root' => "'U [$1 commende evidenziate] ha state cangiate jndr'à sta revisione.",
	'lqt_change_edited_summary' => "'U riepileghe de l'argomende ha state cangiate",
	'lqt_change_deleted' => "[$1 St'argomende] o le parinde sue onne state scangellate.",
	'lqt_change_undeleted' => "'U [$1 messagge evidenziate] ha state repristinate",
	'lqt_change_moved' => "[$1 St'argomende] ha state spustate sus a 'n'otra pàgene de le 'ngazzaminde",
	'lqt_change_split' => "[$1 St'argomende] ha state divise jndr'à 'n'otre argomende",
	'lqt_change_edited_subject' => '\'U suggette de st\'argomende ha state cangiate da "$2" a "$3"',
	'lqt_change_merged_from' => "'Na [$1 rsposte] a st'argomende ha state spustate sus a 'n'otre argomende",
	'lqt_change_merged_to' => "'A [$1 resposta evidenziate] ha state spustate da 'n'otre argomende",
	'lqt_change_split_from' => "'Nu [$1 sotteargomende] de st'argomende ha state divise jndr'à 'n'otre argomende sue",
	'lqt_change_root_blanked' => "'U teste d'u [$1 commende] ha state luate.",
	'lqt_youhavenewmessages' => 'Tu è [[$1|messagge nuève]].',
	'lqt_protectedfromreply' => "St'argomende ha state $1 da quanne ha state resposte.",
	'lqt_protectedfromreply_link' => 'prutette',
	'lqt_subject' => 'Oggette:',
	'lqt_noreason' => 'Nisciune mutive lassate.',
	'lqt_move_placeholder' => "St'argomende jè 'nu sione ca indichesce 'n'otre argomende, $1, ha state spustate da sta pàgene.<br />
Stu spustamende ha state fatte da $2 'u $3 a le $4.<br />
L'argomende mo se iacchie a $5.",
	'lqt_thread_deleted_for_sysops' => "St'argomende ha state '''scangellate''' e jè visibbele sulamende a l'amministrature.",
	'lqt_thread_deleted' => "St'argomende ha state scangellate.",
	'lqt_summary_notice' => "Non g'onne state fatte cangiaminde sus a stu 'ngazzamende jndr'à l'urteme $2 {{PLURAL:$2|sciurne|sciurne}}.<br />
Ce ha state congluse, tu puè vulè a $1.",
	'lqt_summary_notice_link' => "scrive 'nu riepileghe",
	'lqt_summary_label' => "Riepiloghe de l'argomende:",
	'lqt_summary_subtitle' => 'Riepileghe de "$1".',
	'lqt_nosuchrevision' => "Non ge stè 'na revisione de st'argomende.",
	'lqt_nosuchthread' => "L'argomende ca tu è specificate non g'esiste.",
	'lqt_nosuchthread_title' => 'Nisciune argomende',
	'lqt_threadrequired' => "Tu a specificà 'n'argomende jndr'à l'URL.",
	'lqt_move_movingthread' => "Spustamende de $1.<br />
St'argomende jè 'nu stuèzze de $2.",
	'lqt_move_torename' => "Pe renomenà st'argomende, $1 e cange 'u cambe 'Suggette'.",
	'lqt_move_torename_edit' => 'cangiale',
	'lqt_move_destinationtitle' => "Titele d'a pàgene de le 'ngazzaminde de destinazione:",
	'lqt_move_move' => 'Spueste',
	'lqt_move_nodestination' => "Tu a specificà 'na destinazione.",
	'lqt_move_thread_bad_destination' => "'A pàgene de destinazione non g'è 'na pàgene de le 'ngazzaminde.",
	'lqt_move_samedestination' => "L'argomende se iacchie già sus a sta pàgene!",
	'lqt_move_noreason' => 'Nisciune mutive date.',
	'lqt_move_success' => "L'argomende ha state spustate sus a $1.",
	'lqt_delete_undeletethread' => "Repristine de l'argomende",
	'lqt_delete_partof' => "St'argomedne jè 'nu stuèzze de '''$1'''.",
	'lqt_delete_deleting' => "Scangellamende de '''$1''' e '''tutte le resposte''' de jidde.",
	'lqt_delete_deletethread' => 'Scangille argomende e resposte',
	'lqt_delete_deleted' => "L'argomende ha state scangellate.",
	'lqt_delete_undeleted' => "L'argomende ha state repristinate.",
	'lqt_delete_return' => 'Retuèrne a $1.',
	'lqt_delete_return_link' => "'a pàgene de le 'ngazzaminde",
	'lqt_delete_unallowed' => "Non ge puè scangellà l'argomende.",
	'lqt_delete_show_checkbox' => 'Fà vedè le argomende scangellate.',
	'lqt_talkpage_autocreate_summary' => "'A pàgene de le 'ngazzaminde ha state ccrejate automaticamende quanne 'u prime argomende ha state inzerite.",
	'lqt_header_warning_big' => "Tu stè cange 'nu $1.",
	'lqt_header_warning_after_big' => "Testate pe l'annunge e le prefaziune.<br />
Tu putisse invece vuè $2.",
	'lqt_header_warning_bold' => "testate d'a pàgene de le 'ngazzaminde",
	'lqt_header_warning_new_discussion' => "accuminze 'nu'ngazzamende nuève",
	'lqt_sorting_order' => "Ordene de l'arrengamende:",
	'lqt_sort_newest_changes' => 'urteme cangiaminde pe prime',
	'lqt_sort_newest_threads' => 'le argumende cchiù nuève pe prime',
	'lqt_sort_oldest_threads' => 'Le argumende cchiù vicchie pe prime',
	'lqt-title' => 'Titele',
	'lqt-summary' => 'Riepileghe',
	'lqt-searching' => "Cirche 'mbrà le argumende",
	'lqt-read-message' => 'Signe cumme lette',
	'lqt-read-message-tooltip' => "Live st'argomende 'mbrà le messagge nuève.<br />
Jidde jè angore visibbele sus a pàgena de le 'ngazzaminde origgenale.",
	'lqt-read-all' => 'Signe tutte cumme litte',
	'lqt-read-all-tooltip' => "Live st'argomende 'mbrà le messagge nuève.<br />
Jidde jè angore visibbele sus a pàgena de le 'ngazzaminde origgenale.<br />
Queste operazione no se pò annullà.",
	'lqt-marked-read' => "Argomende '''$1''' signate cumme lette.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|messagge|messagge}} signate cumme lette.',
	'lqt-email-undo' => 'Annulle',
	'lqt-no-new-messages' => 'Non ge stonne messagge nuève pe te.',
	'lqt-new-messages' => '✒ Stonne messagge nuève pe te.',
	'lqt-email-info-undo' => "Puèrte rrete l'argomende ca è appene dismesse.",
	'lqt-date-info' => 'Stu collegamende jè disabbeletate purcé tu ste vide le argumende da tutte le date.',
	'lqt-newmessages-context' => 'Argomende comblete',
	'lqt-thread-created' => 'Ccrejate',
	'lqt-history-time' => 'Orarie',
	'lqt-history-user' => 'Utende',
	'lqt-history-action' => 'Attività',
	'lqt-history-comment' => 'Commende',
	'lqt-history-thread' => 'Argomende',
	'lqt-thread-edited-author' => "Cangiate da l'autore<br />
Urteme cangiamende: $1",
	'lqt-thread-edited-others' => 'Cangiate da $2 utinde<br />
Urteme cangiamende: $1',
	'lqt-header-actions' => 'Aziune',
	'lqt_summarize_link' => 'Riepileghe',
	'lqt-summarize-intro' => "Pe piacere riepileghe l'argomende d'aqquà sotte jndr'à sckatele de le cangiaminde.<br />
Tu puè ausà qualungue uicchiteste jndr'à 'u riepileghe tune.<br />
Quanne è spicciate, cazze \"{{int:savearticle}}\".",
	'lqt-thread-split' => "Divide jndr'à doje argumende",
	'lqt-split-success' => "E' riuscite a dividere jndr'à doje argumende, l'argomende $1.",
	'lqt_split_thread' => "Divide 'n'argomende",
	'lqt-thread-split-subject' => "Nuève suggette de l'argomende:",
	'lqt-thread-split-thread' => 'Argomende:',
	'lqt-split-submit' => 'Divide',
	'lqt_split_badsubject' => "'U suggette ca è mise non g'è valide.",
	'lqt-no-threads' => 'Non ge stonne argumende sus a sta pàgene.',
	'lqt-delete-parent-warning' => "Quiste jè 'nu levèlle ierte de argomende cu le resposte.<br />
Le resposte sue avenene scangellate automaticamende. <br />
Pe evità stu fatte, apprime de scangellà divide l'argomende.",
	'lqt-delete-parent-deleted' => 'Argomende attane scangellate ($1)',
	'lqt-delete-replies-done' => "Tutte le resposte a st'argomende onne state pure scangellate.",
	'lqt-movethread' => 'Spuèste',
	'lqt-menu-trigger' => 'De cchiù',
	'lqt-newmessages-from' => 'Da $1',
	'lqt-hot-topics' => 'Argumende cavede',
	'lqt-add-reply' => "Aggiunge 'na resposte",
	'lqt_rc_new_discussion' => 'Postate \'n\'argomende nuève, "$1"',
	'lqt_rc_new_reply' => 'Postate \'na resposte a "$1"',
	'right-lqt-split' => "Divide l'argumende",
	'right-lqt-merge' => 'Funne le argumende',
	'lqt-thread-merge' => "Funne jndr'à 'n'otre argomende",
	'lqt-thread-merge-to' => "Funne jndr'à 'u stesse argomende",
	'lqt_merge_thread' => "Funne l'argomende",
	'lqt-thread-merge-source' => 'Argomende sorgende:',
	'lqt-thread-merge-dest' => 'Argomende de destinazione:',
	'lqt-merge-submit' => 'Funne',
	'lqt-merge-success' => "Tu è riuscite a fonnere l'argomende $1 cu 'u $2.",
	'lqt-log-name' => "Archivije de le 'ngazzaminde argomendate",
	'lqt-log-header' => "St'archivije dettaglie le aziune fatte sus a le argumende de le 'ngazzaminde.",
	'lqt-log-action-move' => 'spustate [[$1]] da [[$2]] a [[$3]].',
	'lqt-log-action-split' => 'devide [[$1]] da sotte a [[$3]], cu \'u suggette nuève "$2"',
	'lqt-log-action-merge-across' => 'spustate [[$1]] da sotte a [[$2]], sotte a [[$3]]',
	'lqt-log-action-merge-down' => 'scuagghiate [[$1]] sotte a [[$3]]',
	'lqt-log-action-subjectedit' => 'cangiate \'u suggette de [[$1]] da "$2" a "$3"',
	'lqt-log-action-resort' => "cangiate l'ordenamende de [[$1]]. Cangiate chiave d'ordinamende da $2 a $3",
	'lqt-preference-notify-talk' => "Manname 'na mail sus a le resposte a 'n'argomende ca ije stoche a condrolle",
	'lqt-preference-watch-threads' => 'Condrolle le argumende ca ije ccreje o responne',
	'prefs-lqt' => "'Ngazzamende argomendate",
	'lqt-preference-display-depth' => 'Massime profonnetà de le resposte da fà vedè:',
	'lqt-preference-display-count' => 'Massime numere de le resposte da fà vedè:',
	'lqt-preference-custom-signatures' => "Fà vedè le firme personalizzate de l'utinde",
	'lqt-enotif-subject-reply' => "'Ngazzamende de {{SITENAME}} - Resposte: $1",
	'lqt-enotif-subject-newthread' => "'Ngazzamende de {{SITENAME}} - Argomende nuève: $1",
	'lqt-enotif-newthread' => "Cià $1,

Queste jè 'na notifiche da {{SITENAME}} ca 'n'argomende nuève sus a $5, '$2', ha state ccrejate 'u $3 a le $4 da $8


Tu 'u puè vedè a <$6>

'U teste jè:
$7",
	'lqt-enotif-reply' => "Cià $1,

Queste jè 'na notifiche da {{SITENAME}} ca 'na resposta nova a '$2' sus a $5, ha state ccrejate 'u $3 a le $4 da $8

Tu 'a puè vedè a <$6>

'U teste d'a resposte jè:
$7",
	'lqt-quote-intro' => "'U $2 a le $3, [[User:$1|$1]] ha scritte:",
	'lqt-quote' => 'Cite',
	'lqt-search-legend' => "Cirche le 'ngazzaminde sus a sta pàgene",
	'lqt-search-label' => 'Cirche le termine:',
	'lqt-search-button' => 'Cirche',
	'searchprofile-threads' => "'Ngazzaminde",
	'searchprofile-threads-tooltip' => "Cirche 'ngazzaminde argomendate e le pàggene de le 'ngazzaminde",
	'lqt-ajax-updated' => "St'argomende tène messagge nuève.",
	'lqt-ajax-update-link' => 'Aggiorne',
	'lqt-thread-show-replies' => 'Fà vedè $1 {{PLURAL:$1|resposte|resposte}}',
	'lqt-thread-show-more' => 'Fà vedè cchiù resposte',
	'lqt-thread-link-url' => "URL d'u collegamende:",
	'lqt-thread-link-title' => 'Collegamende a Uicchiteste:',
	'lqt-thread-link-copy' => "Copie jndr'à l'appunde",
	'lqt-sign-not-necessary' => "Non g'è necessarie firmà 'u messagge tune cu quattre tilde.<br />
'A firme se vede automaticamende.",
	'lqt-marked-as-read-placeholder' => "L'argomende $1 ha state signate cumme lette.",
	'lqt-change-subject' => 'Cange suggette',
	'lqt-save-subject' => 'Reggistre',
	'lqt-save-subject-failed' => "'U seguende errore se verifiche quanne ste pruève a cangià 'u suggette de st'argomende: $1",
	'lqt-ajax-invalid-subject' => "'U suggette specificate ere invalide, probbabbilmende purcé jè troppe luènghe.",
	'lqt-ajax-no-subject' => "Tu à specificà 'nu suggette pe 'n'argomende nuève.",
	'lqt-save-subject-error-unknown' => "'N'errore scanusciute s'à verificate quanne è pruvate a 'mbostà 'u suggette de st'argomende. Pe piacere pruève a fà sta cose cazzanne \"cange\" 'ngape a 'u messagge.",
	'lqt-cancel-subject-edit' => 'Annulle',
	'lqt-drag-activate' => "Trascine sus 'a posiziona nove",
	'lqt-drag-drop-zone' => 'Lasse aqquà',
	'lqt-drag-confirm' => 'Pe combletà le aziune seguende, pe piacere inghie \'u mutive e cazze "Conferme".',
	'lqt-drag-reparent' => "Spuèste 'u messagge sotte a 'n'attane nuève.",
	'lqt-drag-split' => "Spuèste 'u messagge sotte l'argomende sue",
	'lqt-drag-setsortkey' => "conziglie 'a posizione d'u messagge jndr'à pàgene",
	'lqt-drag-bump' => "Spuèste 'u messagge a l'inizie d'a pàgene de le 'ngazzaminde",
	'lqt-drag-save' => 'Conferme',
	'lqt-drag-title' => "Conferme 'u trascinamende",
	'lqt-drag-reason' => 'Mutive:',
	'lqt-drag-subject' => "Suggette pe l'argomende nuève (obbligatorie):",
	'lqt-edit-signature' => "(cange 'a firme)",
	'lqt-preview-signature' => '(andeprime)',
	'lqt-feed-title-all' => '{{SITENAME}} — Messagge nuève',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Messagge nuève da $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Argumende nuève',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Argumende nuève da $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Resposte',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Resposte da $1',
	'lqt-feed-new-thread-intro' => 'Argomende nuève sus a $1 lassate da $2',
	'lqt-feed-reply-intro' => 'Resposte a $3 (sus a $1) lassate da $2',
	'tooltip-pt-newmessages' => "Fa vedè le messagge nuève a le argomende o sus a le pàggene de le 'ngazzaminde argomendate ca tu stè uarde",
	'lqt-newmessages-n' => 'Messagge nuève ($1)',
	'lqt_newmessages' => 'Le messagge nuève mije (Ninde)',
	'lqt_newmessages-title' => 'Messagge nuève',
	'lqt-newpost-summary' => 'Argomende nuève: $1',
	'lqt-reply-summary' => 'Respunne a [[$2|$1]]',
	'lqt-talkpage-history-title' => "Cunde d'a pàgene de le 'ngazzaminde",
	'lqt-talkpage-history-subtitle' => 'Pe $1',
	'lqt-talkpage-history-tab' => 'Testate',
	'restriction-reply' => 'Manne le resposte',
	'restriction-newthread' => 'Manne argumende nuève',
	'lqt-protected-reply-thread' => "Tu non ge puè scrivere jndr'à st'argomende purcé ha state protette da messagge nuève.",
	'lqt-protected-reply-talkpage' => "Tu non ge puè scrivere jndr'à st'argomende purcé 'a pàgene de le 'ngazzaminde ha state protette da le resposte sus a st'argomende.",
	'lqt-protected-newthread' => "Tu non ge puè scrivere argumende nuève jndr'à sta pàgene de le 'ngazzaminde purcé ha state protette da argumende nuève.",
	'lqt-edit-bump' => "Fà 'nghianà st'argomende",
	'lqt-edit-bump-tooltip' => "Spuèste st'argomende a l'inizie d'a pàgene de le 'ngazzaminde",
	'lqt-historicalrevision-error' => "'A revisione ca tu è scacchiate jè sckuasciate e none ge pò essere viste.",
	'lqt-reply-subpage' => 'respunne',
	'nstab-thread' => 'Argomende',
	'nstab-summary' => 'Riepileghe',
);

/** Russian (Русский)
 * @author Ferrer
 * @author Innv
 * @author Kaganer
 * @author Kv75
 * @author Lockal
 * @author MaxSem
 * @author McDutchie
 * @author Mormegil
 * @author VasilievVV
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'lqt-desc' => 'Добавляет на страницы обсуждения ветки (потоки) обсуждений',
	'lqt_movethread' => 'Переместить ветку на другую страницу',
	'lqt_deletethread' => 'Удалить/восстановить ветку',
	'lqt_contents_title' => 'Оглавление',
	'lqt_toc_thread_title' => 'Заголовок ветки',
	'lqt_toc_thread_author' => 'Инициатор',
	'lqt_toc_thread_replycount' => 'Ответов',
	'lqt_toc_thread_modified' => 'Последнее изменение',
	'lqt_add_header' => 'Добавить «шапку»',
	'lqt_new_thread' => 'Начать новое обсуждение',
	'lqt_invalid_subject' => 'Указанный вами заголовок ошибочен, по одной из следующих причин:
* слишком длинен;
* совпадает с интервики-приставками или названиями пространств имён.',
	'lqt_empty_subject' => 'Вы должны указать тему.',
	'lqt_reply' => 'Ответить',
	'lqt-parent' => 'Родитель',
	'lqt_delete' => 'Удалить',
	'lqt_undelete' => 'Восстановить',
	'lqt_permalink' => 'Ссылка сюда',
	'lqt_fragment' => 'Фрагмент $1 из $2',
	'lqt_discussion_link' => 'обсуждения',
	'lqt_from_talk' => 'Из $1',
	'lqt-history-title' => 'История ветки',
	'lqt_hist_comment_edited' => 'Текст комментария [$2 отредактирован]',
	'lqt_hist_summary_changed' => 'Итог изменён',
	'lqt_hist_reply_created' => 'Создан [[$1|новый ответ]]',
	'lqt_hist_thread_created' => 'Создана новая ветка',
	'lqt_hist_deleted' => 'Удалена',
	'lqt_hist_undeleted' => 'Восстановлена',
	'lqt_hist_moved_talkpage' => 'Перемещена',
	'lqt_hist_listing_subtitle' => 'Просмотр истории',
	'lqt_hist_view_whole_thread' => 'Просмотреть историю для всей ветки',
	'lqt_hist_no_revisions_error' => 'Данная ветка не имеет какой либо истории.',
	'lqt_hist_past_last_page_error' => 'Вы вышли за пределы количества существующих страниц истории.',
	'lqt_hist_tooltip_newer_disabled' => 'Эта ссылка отключена, потому что вы находитесь на первой странице.',
	'lqt_hist_tooltip_older_disabled' => 'Эта ссылка отключена, потому что вы на последней странице.',
	'lqt_hist_split' => 'Ответ выделен в новую ветку',
	'lqt_hist_edited_subject' => 'Заголовок изменён с «$2» на «$3»',
	'lqt_hist_edited_subject_corrupt' => 'Тема изменена',
	'lqt_hist_merged_from' => '[[$1|Ответ]] перемещён в другую ветку',
	'lqt_hist_merged_to' => '[[$1|Ответ]] перемещён с другой ветки',
	'lqt_hist_split_from' => 'Выделить в новую ветку',
	'lqt_hist_root_blanked' => 'Текст комментария удалён',
	'lqt_hist_adjusted_sortkey' => 'Изменил расположение ветки',
	'lqt_revision_as_of' => 'Версия от $2 $3.',
	'lqt_change_new_thread' => 'Это изначальная версия ветки.',
	'lqt_change_reply_created' => '[$1 Выделенный комментарий] был создан в этой версии.',
	'lqt_change_edited_root' => '[$1 Выделенный комментарий] был отредактирован в этой версии.',
	'lqt_change_edited_summary' => 'Описание ветки было изменено',
	'lqt_change_deleted' => '[$1 Эта ветка] или её родительская ветка были удалены',
	'lqt_change_undeleted' => '[$1 Выделенное сообщение] было восстановлено',
	'lqt_change_moved' => '[$1 Эта ветка] была перенесена на другую страницу обсуждения',
	'lqt_change_split' => '[$1 Эта ветка] была выделена из другой ветки',
	'lqt_change_edited_subject' => 'Заголовок этой ветки изменён с «$2» на «$3»',
	'lqt_change_merged_from' => '[$1 Ответ] на эту ветку был перенесён в другую ветку',
	'lqt_change_merged_to' => '[$1 Выделенный ответ] был перенесён из другой ветки',
	'lqt_change_split_from' => '[$1 Подветка] этой ветки была выделена в собственную ветку',
	'lqt_change_root_blanked' => 'Текст [$1 комментария] был удалён.',
	'lqt_youhavenewmessages' => 'Вы получили [[$1|новые сообщения]].',
	'lqt_protectedfromreply' => 'Эта ветка была $1 от ответа на неё.',
	'lqt_protectedfromreply_link' => 'защищена',
	'lqt_subject' => 'Заголовок:',
	'lqt_noreason' => 'Не указана причина.',
	'lqt_move_placeholder' => 'Ветка $1 была перемещена с этой страницы в $5.
Перемещение произведено участником $2 $3 в $4.',
	'lqt_thread_deleted_for_sysops' => "Эта ветка была '''удалена''' и видна только администраторам.",
	'lqt_thread_deleted' => 'Эта ветка была удалена.',
	'lqt_summary_notice' => 'Это обсуждение не изменялось как минимум $2 {{PLURAL:$2|день|дня|дней}}.
Если оно подошло к концу, вы можете $1.',
	'lqt_summary_notice_link' => 'подвести итог',
	'lqt_summary_label' => 'Краткое описание ветки:',
	'lqt_summary_subtitle' => 'Описание ветки «$1»',
	'lqt_nosuchrevision' => 'В этой ветке нет такой версии.',
	'lqt_nosuchthread' => 'Указанной вами ветки не существует.',
	'lqt_nosuchthread_title' => 'Нет такой ветки',
	'lqt_threadrequired' => 'Вы должны указать ветку в URL',
	'lqt_move_movingthread' => 'Перемещение $1. Эта ветка является частью $2.',
	'lqt_move_torename' => 'Для того, чтобы переименовать эту ветку, $1 и измените поле «Заголовок».',
	'lqt_move_torename_edit' => 'отредактируйте её',
	'lqt_move_destinationtitle' => 'Название целевой страницы обсуждения:',
	'lqt_move_move' => 'Переместить',
	'lqt_move_nodestination' => 'Вы должны указать целевую страницу.',
	'lqt_move_thread_bad_destination' => 'Страница назначения не является страницей обсуждения.',
	'lqt_move_samedestination' => 'Ветка уже на этой странице!',
	'lqt_move_noreason' => 'Не была указана причина.',
	'lqt_move_success' => 'Эта ветка была перемещена в $1.',
	'lqt_delete_undeletethread' => 'Восстановление ветки',
	'lqt_delete_partof' => "Эта ветка является частью '''$1'''.",
	'lqt_delete_deleting' => "Удаление '''$1''' и '''всех ответов''' на неё.",
	'lqt_delete_deletethread' => 'Удалить ветку и ответы',
	'lqt_delete_deleted' => 'Ветка была удалена.',
	'lqt_delete_undeleted' => 'Ветка была восстановлена.',
	'lqt_delete_return' => 'Возвратиться на $1.',
	'lqt_delete_return_link' => 'страницу обсуждения',
	'lqt_delete_unallowed' => 'Вы не можете удалять обсуждения.',
	'lqt_delete_show_checkbox' => 'Показать удалённые ветки',
	'lqt_talkpage_autocreate_summary' => 'Страница обсуждения создаётся автоматически, как только отправлено первое сообщение.',
	'lqt_header_warning_big' => 'Вы редактируете $1.',
	'lqt_header_warning_after_big' => 'Заголовки служат для объявлений и введений. Вы можете $2.',
	'lqt_header_warning_bold' => 'заголовок страницы обсуждения',
	'lqt_header_warning_new_discussion' => 'начать новое обсуждение',
	'lqt_sorting_order' => 'Порядок сортировки:',
	'lqt_sort_newest_changes' => 'изменённые вначале',
	'lqt_sort_newest_threads' => 'новые ветки вначале',
	'lqt_sort_oldest_threads' => 'старые ветки вначале',
	'lqt-title' => 'Заголовок',
	'lqt-summary' => 'Описание',
	'lqt-searching' => 'Поиск по веткам',
	'lqt-read-message' => 'Отметить как прочитанное',
	'lqt-read-message-tooltip' => 'Убрать эту ветку из списка новых сообщений.
Она останется видна на соответствующей странице обсуждения.',
	'lqt-read-all' => 'Отметить все как прочитанные',
	'lqt-read-all-tooltip' => 'Убрать все ветки из списка новых сообщений.
Они останутся видны на соответствующих страницах обсуждений.
Эта операция необратима.',
	'lqt-marked-read' => "Ветка '''$1''' отмечена как прочитанная.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|сообщение отмечено как прочитанное|сообщения отмечены как прочитанные|сообщений отмечены как прочитанные}}.',
	'lqt-email-undo' => 'Отменить',
	'lqt-no-new-messages' => 'Для вас нет новых сообщений.',
	'lqt-new-messages' => '✒ Для вас есть новые сообщения.',
	'lqt-email-info-undo' => 'Вернуть назад только что убранную ветку.',
	'lqt-date-info' => 'Эта ссылка отключена, так как вы просматриваете ветки за все даты.',
	'lqt-newmessages-context' => 'Полная ветка',
	'lqt-thread-created' => 'Создан',
	'lqt-history-time' => 'Время',
	'lqt-history-user' => 'Участник',
	'lqt-history-action' => 'Действия',
	'lqt-history-comment' => 'Комментарий',
	'lqt-history-thread' => 'Ветка',
	'lqt-thread-edited-author' => 'Исправлено автором.<br />
Последняя правка: $1',
	'lqt-thread-edited-others' => 'Исправлено {{PLURAL:$2|1 другим участником|$2 другими участниками|$2 другими участниками}}.<br />
Последняя правка: $1',
	'lqt-header-actions' => 'Действия',
	'lqt_summarize_link' => 'Подвести итог',
	'lqt-summarize-intro' => 'Пожалуйста, кратко опишите в поле редактирования содержимое данной ветки обсуждения.
Вы можете использовать любой викитекст. Нажмите «{{int:savearticle}}», когда закончите.',
	'lqt-thread-split' => 'Выделить в новую ветку',
	'lqt-split-success' => 'Вы успешно разделили ветку $1.',
	'lqt_split_thread' => 'Разделение ветки',
	'lqt-thread-split-subject' => 'Заголовок новой ветки:',
	'lqt-thread-split-thread' => 'Ветка:',
	'lqt-split-submit' => 'Разделить',
	'lqt_split_badsubject' => 'Указанный вами заголовок не может быть использован.',
	'lqt-no-threads' => 'На этой странице ещё нет веток обсуждений.',
	'lqt-delete-parent-warning' => 'Это ветка верхнего уровня, имеющая ответы.
Все ответы также будут автоматически удалены.
Чтобы избежать этого, перед удалением ветки вынесите из неё ответы.',
	'lqt-delete-parent-deleted' => 'Вышестоящая ветка удалена ($1)',
	'lqt-delete-replies-done' => 'Также были удалены все ответы на эту ветку.',
	'lqt-movethread' => 'Перенести',
	'lqt-menu-trigger' => 'Ещё',
	'lqt-newmessages-from' => 'Со страницы $1',
	'lqt-hot-topics' => 'Горячие темы',
	'lqt-add-reply' => 'Добавить ответ',
	'lqt_rc_new_discussion' => 'создал новую ветку, «$1»',
	'lqt_rc_new_reply' => 'написал ответ на «$1»',
	'right-lqt-split' => 'разделение ветвей',
	'right-lqt-merge' => 'объединение ветвей',
	'right-lqt-react' => 'Ответить на ветку',
	'lqt-thread-merge' => 'Присоединить к другой ветке',
	'lqt-thread-merge-to' => 'Присоединить к этой ветке',
	'lqt_merge_thread' => 'Присоединение веток',
	'lqt-thread-merge-source' => 'Что присоединить:',
	'lqt-thread-merge-dest' => 'Куда присоединить:',
	'lqt-merge-submit' => 'Присоединить',
	'lqt-merge-success' => 'Вы успешно присоединили ветку $1 к ветке $2.',
	'lqt-log-name' => 'Журнал веток обсуждений',
	'lqt-log-header' => 'В этот журнал записываются действия, предпринятые в ветках обсуждений.',
	'lqt-log-action-move' => 'перемещено [[$1]] из [[$2]] в [[$3]].',
	'lqt-log-action-split' => 'выделил [[$1]] из [[$3]], с новой темой «$2»',
	'lqt-log-action-merge-across' => 'переместил [[$1]] из [[$2]] в [[$3]]',
	'lqt-log-action-merge-down' => 'объединил [[$1]] в [[$3]]',
	'lqt-log-action-subjectedit' => 'изменил тему [[$1]] с «$2» на «$3»',
	'lqt-log-action-resort' => 'изменил порядок сортировки [[$1]]. Смена ключа сортировки с $2 на $3',
	'lqt-preference-notify-talk' => 'Уведомлять меня по почте о новых ответах на ветке, за которой я слежу',
	'lqt-preference-watch-threads' => 'Следить за ветками, которые я создал, или на которые отвечал',
	'prefs-lqt' => 'Обсуждения по веткам',
	'lqt-preference-display-depth' => '* Максимальная глубина ответов для отображения:',
	'lqt-preference-display-count' => '* Максимальное количество ответов для отображения:',
	'lqt-preference-custom-signatures' => 'Показать настраиваемые подписи участников',
	'lqt-enotif-subject-reply' => '{{SITENAME}} обсуждение — Ответ: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} обсуждение — Новая ветка: $1',
	'lqt-enotif-newthread' => 'Привет, $1.

Это уведомление с сайта {{SITENAME}} о том, что $3 $4 на странице $5
участником $8 была создана новая ветка «$2» 

Вы можете увидеть её по адресу <$6>

Текст ветки:
$7',
	'lqt-enotif-reply' => 'Привет, $1.

Это уведомление с сайта {{SITENAME}} о том, что $3 $4 на страницу $5
участником $8 был добавлен новый ответ на ветку «$2».

Вы можете увидеть её по адресу <$6>

Текст ответа:
$7',
	'lqt-quote-intro' => '$2 $3, [[User:$1|$1]] написал:',
	'lqt-quote' => 'Цитировать',
	'lqt-search-legend' => 'Поиск обсуждений на этой странице',
	'lqt-search-label' => 'Условия поиска:',
	'lqt-search-button' => 'Найти',
	'searchprofile-threads' => 'Обсуждения',
	'searchprofile-threads-tooltip' => 'Поиск в обсуждениях по веткам и на страницах обсуждений',
	'lqt-ajax-updated' => 'В этой ветке есть новые сообщения.',
	'lqt-ajax-update-link' => 'Обновить',
	'lqt-thread-show-replies' => '* Показать $1 ответов',
	'lqt-thread-show-more' => 'Показать больше ответов',
	'lqt-thread-link-url' => 'Ссылка на URL:',
	'lqt-thread-link-title' => 'Вики-ссылка:',
	'lqt-thread-link-copy' => 'Копировать в буфер обмена',
	'lqt-sign-not-necessary' => 'Нет необходимости подписывать своё сообщение четыремя тильдами.
Подпись показывается автоматически.',
	'lqt-marked-as-read-placeholder' => 'Ветка $1 была отмечена как прочитанная.',
	'lqt-change-subject' => 'Изменить заголовок',
	'lqt-save-subject' => 'Сохранить',
	'lqt-save-subject-failed' => 'Произошла следующая ошибка при попытке изменить заголовок этой ветки: $1',
	'lqt-ajax-invalid-subject' => 'Указанный вами заголовок не является допустимым, возможно, у него слишком большая длина.',
	'lqt-ajax-no-subject' => 'Вы должны указать заголовок новой ветки',
	'lqt-save-subject-error-unknown' => 'Произошла неизвестная ошибка при попытке установить заголовок этой ветки. Пожалуйста, попробуйте сделать это, нажав кнопку «править» в верхней части сообщения.',
	'lqt-cancel-subject-edit' => 'Отмена',
	'lqt-drag-activate' => 'Перетащить',
	'lqt-drag-drop-zone' => 'Перетащить сюда',
	'lqt-drag-confirm' => 'Чтобы выполнить данные действия, пожалуйста, укажите причину и нажмите кнопку «Подтвердить».',
	'lqt-drag-reparent' => 'Переместить запись к другой родительской записи.',
	'lqt-drag-split' => 'Переместить запись в свою собственную ветку',
	'lqt-drag-setsortkey' => 'Изменить расположение записи на странице',
	'lqt-drag-bump' => 'Переместить запись в начало страницы обсуждения',
	'lqt-drag-save' => 'Подтвердить',
	'lqt-drag-title' => 'Подтвердить перетаскивание',
	'lqt-drag-reason' => 'Причина:',
	'lqt-drag-subject' => 'Тема для новой ветки (обязательно):',
	'lqt-edit-signature' => '(править подпись)',
	'lqt-preview-signature' => '(предпросмотр)',
	'lqt-feed-title-all' => '{{SITENAME}} — Новые записи',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Новые сообщения $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Новые ветки',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Новые ветки $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Ответы',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Ответы $1',
	'lqt-feed-new-thread-intro' => 'Новая ветка в $1, размещена $2',
	'lqt-feed-reply-intro' => 'Ответ на $3 (в $1), размещена $2',
	'tooltip-pt-newmessages' => 'Показывает новые сообщения на ветках и нитях обсуждений, за которыми вы наблюдаете',
	'lqt-newmessages-n' => 'Новые сообщения ($1)',
	'lqt_newmessages' => 'Новые сообщения (Нет)',
	'lqt_newmessages-title' => 'Новые сообщения',
	'lqt-newpost-summary' => 'Новая ветка: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Пожалуйста, введите текст для этой ветки. Затем удалите эту строчку.',
	'lqt-reply-summary' => 'Ответ на [[$2|$1]]',
	'lqt-talkpage-history-title' => 'История страницы обсуждения',
	'lqt-talkpage-history-subtitle' => 'Для $1',
	'lqt-talkpage-history-tab' => 'Заголовок',
	'restriction-reply' => 'писать ответы',
	'restriction-newthread' => 'создавать новые ветки',
	'lqt-protected-reply-thread' => 'Вы не можете писать в эту ветку, так как она была защищена от новых записей.',
	'lqt-protected-reply-talkpage' => 'Вы не можете писать в эту ветку, так как эта страница обсуждения была защищена от ответов в её ветках.',
	'lqt-protected-newthread' => 'Вы не можете создавать новые ветки в этой странице обсуждения, так как она была защищена от создания новых веток.',
	'lqt-edit-bump' => 'Поднять эту ветку',
	'lqt-edit-bump-tooltip' => 'Перенести эту ветку в начало её страницы обсуждения',
	'lqt-historicalrevision-error' => 'Выбранная версия повреждена, она не может быть просмотрена.',
	'lqt-reply-subpage' => 'ответить',
	'nstab-thread' => 'Ветка',
	'nstab-summary' => 'Описание',
);

/** Rusyn (Русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'lqt-desc' => 'Додасть на сторінкы діскузії волокна діскузії',
	'lqt_movethread' => 'Пересунути волокно на іншу сторінку',
	'lqt_deletethread' => 'Змазати або обновити волокно',
	'lqt_contents_title' => 'Обсяг',
	'lqt_toc_thread_title' => 'Назва волокна',
	'lqt_toc_thread_author' => 'Основатель',
	'lqt_toc_thread_replycount' => 'Одповідей',
	'lqt_toc_thread_modified' => 'Послїдня зміна',
	'lqt_add_header' => 'Придати заголовя',
	'lqt_new_thread' => 'Зачати нову діскузію',
	'lqt_empty_subject' => 'Мусите увести тему.',
	'lqt_reply' => 'Одповісти',
	'lqt-parent' => 'Родичовскы',
	'lqt_delete' => 'Вымазати',
	'lqt_undelete' => 'Обновити',
	'lqt_permalink' => 'Одказ',
	'lqt_fragment' => 'Фраґмент $1 з $2',
	'lqt_discussion_link' => 'діскузія',
	'lqt_from_talk' => 'З $1',
	'lqt-history-title' => 'Історія волокна',
	'lqt_hist_comment_edited' => 'Текст коментаря [$2 едітованый]',
	'lqt_hist_summary_changed' => 'Резюме змінене',
	'lqt_hist_reply_created' => 'Створена [[$1|нова одповідь]]',
	'lqt_hist_thread_created' => 'Нове волокно створене',
	'lqt_hist_deleted' => 'Змазане',
	'lqt_hist_undeleted' => 'Обновене',
	'lqt_hist_moved_talkpage' => 'Пересунуте',
	'lqt_hist_view_whole_thread' => 'Зобразити історію цалого волокна',
	'lqt_hist_no_revisions_error' => 'Тото волокно не має історію змін.',
	'lqt_hist_split' => 'Одповідь роздїлена до нового волокна',
	'lqt_hist_edited_subject' => 'Змінена тема з "$2" на "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Змінена тема',
	'lqt_hist_merged_from' => '[[$1|Одповідь]] переміщена до іншого волокна',
	'lqt_hist_merged_to' => '[[$1|Одповідь]] переміщена з іншого волокна',
	'lqt_hist_split_from' => 'Оддїлити до нового волокна',
	'lqt_hist_root_blanked' => 'Вылученый текст коментаря',
	'lqt_hist_adjusted_sortkey' => 'Управлена позіція волокна',
	'lqt_revision_as_of' => 'Ревізія з $2, $3.',
	'lqt_change_new_thread' => 'Тото є початочна ревізія волокна.',
	'lqt_change_edited_summary' => 'Попис волокна быв зміненый',
	'lqt_change_moved' => '[$1 Тото волокно] было перенесене на іншу діскузну сторінку',
	'lqt_change_edited_subject' => 'Тема того волокна была змінена з "$2" на "$3"',
	'lqt_change_split_from' => '[$1 Часть того волокна] была оддїлена до окремого волокна',
	'lqt_change_root_blanked' => 'Текст [$1 коментаря] быв вылученый.',
	'lqt_youhavenewmessages' => 'Маєте [[$1|новы повідомлїня]].',
	'lqt_protectedfromreply' => 'Тото волокно є $1, также ся не дасть на ного одповідати.',
	'lqt_protectedfromreply_link' => 'хранена',
	'lqt_subject' => 'Тема:',
	'lqt_noreason' => 'Причіна не была задана.',
	'lqt_thread_deleted' => 'Волокно было вылучене.',
	'lqt_summary_notice_link' => 'створити резюме',
	'lqt_summary_label' => 'Резюме волокна:',
	'lqt_summary_subtitle' => 'Сумар „$1“',
	'lqt_nosuchrevision' => 'Такой ревізії волокна не є.',
	'lqt_nosuchthread' => 'Зазначене волокно не єствує.',
	'lqt_nosuchthread_title' => 'Таке волокно не є',
	'lqt_threadrequired' => 'Мусите в URL задати волокно.',
	'lqt_move_movingthread' => 'Переміщїня $1.
Тото волокно є частёв $2.',
	'lqt_move_torename_edit' => 'едітуйте єй',
	'lqt_move_destinationtitle' => 'Назва цілёвой діскузной сторінкы:',
	'lqt_move_move' => 'Пересунути',
	'lqt_move_nodestination' => 'Мусите задати ціль.',
	'lqt_move_thread_bad_destination' => 'Цілёва сторінка не є діскузія',
	'lqt_move_samedestination' => 'Волокно уж на тій сторінцї є!',
	'lqt_move_noreason' => 'Причіна не была задана.',
	'lqt_move_success' => 'Волокно было пересунуте на $1.',
	'lqt_delete_undeletethread' => 'Обновити волокно',
	'lqt_delete_partof' => "Тото волокно є частёв '''$1'''.",
	'lqt_delete_deletethread' => 'Змазати волокно і одповідї',
	'lqt_delete_deleted' => 'Волокно было змазане.',
	'lqt_delete_undeleted' => 'Волокно было обновлене.',
	'lqt_delete_return' => 'Вернути ся на $1.',
	'lqt_delete_return_link' => 'діскузну сторінку',
	'lqt_delete_unallowed' => 'Не можете мазати волокна.',
	'lqt_delete_show_checkbox' => 'Указати вылучены волокна',
	'lqt_talkpage_autocreate_summary' => 'Діскузна сторінка створена автоматічно почас публікації першого волокна',
	'lqt_header_warning_big' => 'Едітуєте $1.',
	'lqt_header_warning_bold' => 'заголовя діскузной сторінкы',
	'lqt_header_warning_new_discussion' => 'зачати нову діскузію',
	'lqt_sorting_order' => 'Порядок сортованя:',
	'lqt_sort_newest_threads' => 'найновшы волокна першы',
	'lqt_sort_oldest_threads' => 'найстаршы волокна першы',
	'lqt-title' => 'Надпис',
	'lqt-summary' => 'Попис',
	'lqt-searching' => 'Глядають ся волокна',
	'lqt-read-message' => 'Означіти як прочітане',
	'lqt-read-all' => 'Означіти вшытко як прочітане',
	'lqt-marked-read' => "Волокно '''$1''' было означене як прочітане.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|повідомлїня позначене як проччтане|повідомлїня позначены як прочітаны|повідомлїнь позначеных як прочітаных}}.',
	'lqt-email-undo' => 'Вернути назад',
	'lqt-no-new-messages' => 'Не маєте жадны новы повідомлїя.',
	'lqt-new-messages' => '✒ Маєте новы повідомлїня.',
	'lqt-newmessages-context' => 'Цале волокно',
	'lqt-thread-created' => 'Створено',
	'lqt-history-time' => 'Час',
	'lqt-history-user' => 'Хоснователь',
	'lqt-history-action' => 'Дїї',
	'lqt-history-comment' => 'Коментарь',
	'lqt-history-thread' => 'Волокно',
	'lqt-header-actions' => 'Дїї',
	'lqt_summarize_link' => 'Резюмовати',
	'lqt-thread-split' => 'Оддїлити до нового волокна',
	'lqt_split_thread' => 'Роздїлити волокно',
	'lqt-thread-split-subject' => 'Тема нового волокна:',
	'lqt-thread-split-thread' => 'Волокно:',
	'lqt-split-submit' => 'Роздїлити',
	'lqt_split_badsubject' => 'Задана тема ся не може хосновати.',
	'lqt-no-threads' => 'На тій сторінцї не суть жадны діскузны волокна.',
	'lqt-movethread' => 'Пересунути',
	'lqt-menu-trigger' => 'Веце',
	'lqt-newmessages-from' => 'З $1',
	'lqt-hot-topics' => 'Горячі темы',
	'lqt-add-reply' => 'Придати одповідь',
	'lqt_rc_new_discussion' => 'написав нову тему, "$1"',
	'lqt_rc_new_reply' => 'написав одповідь на «$1»',
	'right-lqt-split' => 'Роздїлити волокна',
	'right-lqt-merge' => 'Злучованя волокн',
	'lqt-thread-merge' => 'Злучіти до іншого волокна',
	'lqt-thread-merge-to' => 'Злучіти до того волокна',
	'lqt_merge_thread' => 'Злучіти волокна',
	'lqt-thread-merge-source' => 'Жрідлове волокно:',
	'lqt-thread-merge-dest' => 'Цілёве волокно:',
	'lqt-merge-submit' => 'Злучіти',
	'lqt-log-action-move' => 'перенїс [[$1]] з [[$2]] до [[$3]]',
	'lqt-log-action-split' => 'роздїлив [[$1]] з-під [[$3]], з новов темов "$2"',
	'lqt-log-action-merge-across' => 'перемістив [[$1]] із [[$2]] в [[$3]]',
	'lqt-log-action-merge-down' => 'злучів [[$1]] з [[$3]]',
	'lqt-log-action-subjectedit' => 'змінив тему [[$1]] з "$2" на "$3"',
	'lqt-log-action-resort' => 'змінив порядок сортованя [[$1]]. Зміненый ключ сортованя з $2 на $3',
	'lqt-preference-display-depth' => 'Зобразовати одповідї до глубкы:',
	'lqt-preference-display-count' => 'Максімалне чісло зображеных одповідей:',
	'lqt-enotif-subject-reply' => '{{SITENAME}} діскузія - Одповідь: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} діскузія - Нове волокно: $1',
	'lqt-quote-intro' => '$2 о $3, [[User:$1|$1]] написав:',
	'lqt-quote' => 'Цітовати',
	'lqt-search-legend' => 'Глядати в діскузіях на тій сторінцї',
	'lqt-search-label' => 'Гляданы выразы:',
	'lqt-search-button' => 'Глядати',
	'searchprofile-threads' => 'Діскузії',
	'searchprofile-threads-tooltip' => 'Глядати в діскузіях і діскузных волокнах',
	'lqt-ajax-updated' => 'У тім волокнї суть новы приспевкы.',
	'lqt-ajax-update-link' => 'Обновити',
	'lqt-thread-show-replies' => 'Указати $1 {{PLURAL:$1|одповідь|одповідї|одповідей}}',
	'lqt-thread-show-more' => 'Указати веце одповідей',
	'lqt-thread-link-url' => 'URL одказу:',
	'lqt-thread-link-title' => 'Вікітекстовый одказ:',
	'lqt-thread-link-copy' => 'Копіровати до кліпборду',
	'lqt-marked-as-read-placeholder' => 'Волокно $1 позначене як прочітане.',
	'lqt-change-subject' => 'Змінити тему',
	'lqt-save-subject' => 'Уложыти',
	'lqt-ajax-no-subject' => 'Мусите увести тему.',
	'lqt-cancel-subject-edit' => 'Сторно',
	'lqt-drag-activate' => 'Перемістити на інше місце',
	'lqt-drag-drop-zone' => 'Ту пустити',
	'lqt-drag-confirm' => 'Про докінчіня наслїдуючіх дїї выповните причіну і кликните на "Підтвердити"',
	'lqt-drag-reparent' => 'Пересун приспевку під іншый надрядженый приспевок.',
	'lqt-drag-split' => 'Пересун приспевку до властного волокна',
	'lqt-drag-setsortkey' => 'Змінити позіцію приспевку на сторінцї',
	'lqt-drag-bump' => 'Пересун приспевку на початок діскузной сторінкы',
	'lqt-drag-save' => 'Підтвердити',
	'lqt-drag-title' => 'Підтвердити пересун',
	'lqt-drag-reason' => 'Причіна:',
	'lqt-drag-subject' => 'Тема нового волокна:',
	'lqt-edit-signature' => '(управити підпис)',
	'lqt-preview-signature' => '(нагляд)',
	'lqt-feed-title-all' => '{{SITENAME}} – Новы приспевкы',
	'lqt-feed-title-all-from' => '{{SITENAME}} – Новы приспевкы з $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – Новы волокна',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – Новы волокна з $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Одповідї',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – Одповідї од $1',
	'lqt-feed-new-thread-intro' => 'Нове волокно на $1 послане $2',
	'lqt-feed-reply-intro' => 'Одповідь про $3 (на $1), публікована $2',
	'lqt-newmessages-n' => 'Новы повідомлїня $1',
	'lqt_newmessages' => 'Новы повідомлїня',
	'lqt_newmessages-title' => 'Новы повідомлїня',
	'lqt-newpost-summary' => 'Нова волокно: $1',
	'lqt-reply-summary' => 'Одповідь на [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Історія сторінкы діскузії',
	'lqt-talkpage-history-subtitle' => 'Про сторінку $1',
	'lqt-talkpage-history-tab' => 'Головка',
	'restriction-reply' => 'Писати одповідї',
	'restriction-newthread' => 'Створёвати новы волокна',
	'lqt-edit-bump' => 'Ожывити волокно',
	'lqt-edit-bump-tooltip' => 'Пересунути тото волокно на верьх діскузной сторінкы',
	'lqt-historicalrevision-error' => 'Зволена ревізія є пошкоджена і не дасть ся зобразити.',
	'lqt-reply-subpage' => 'одповісти',
	'nstab-thread' => 'Волокно',
	'nstab-summary' => 'Резюме',
);

/** Yakut (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'lqt-desc' => 'Ырытыы сирэйдэригэр салаалары эбэр',
	'lqt_movethread' => 'Салааны атын сирэйгэ көһөрүү',
	'lqt_deletethread' => 'Салааны соторго/төннөрөргө',
	'lqt_contents_title' => 'Баһа',
	'lqt_toc_thread_title' => 'Салаа баһа',
	'lqt_toc_thread_author' => 'Саҕалааччы',
	'lqt_toc_thread_replycount' => 'Хоруй',
	'lqt_toc_thread_modified' => 'Бүтэһик уларытыы',
	'lqt_add_header' => 'Аат эбии',
	'lqt_new_thread' => 'Саҥа ырытыыны саҕалааһын',
	'lqt_invalid_subject' => 'Эн оҥорбут аатыҥ алҕастаах, төрүөтүнэн балартан биирдэстэрэ буолар:
* наһаа уһун;
* интервики-приставкалары кытта дуу аат далларын кытта дуу биир.',
	'lqt_empty_subject' => 'Туох туһунан суруйаргын этиэхтээххин.',
	'lqt_reply' => 'Хоруйдуурга',
	'lqt-parent' => 'Төрөппүтэ',
	'lqt_delete' => 'Соторго',
	'lqt_undelete' => 'Төннөрөргө',
	'lqt_permalink' => 'Манна сигэнии',
	'lqt_fragment' => 'Мантан ылыллыбыт $2 быһа тардыы $1',
	'lqt_discussion_link' => 'ырытыылар',
	'lqt_from_talk' => 'Мантан ылыллыбыт $1',
	'lqt-history-title' => 'Салаа устуоруйата',
	'lqt_hist_comment_edited' => 'Комментарий [уларытылынна $2]',
	'lqt_hist_summary_changed' => 'Түмүгэ уларытылынна',
	'lqt_hist_reply_created' => '[[$1|Саҥа хоруй]] сурулунна',
	'lqt_hist_thread_created' => 'Саҥа салаа оҥоһулунна',
	'lqt_hist_deleted' => 'Сотулунна',
	'lqt_hist_undeleted' => 'Төннөрүлүннэ',
	'lqt_hist_moved_talkpage' => 'Көһөрүлүннэ',
	'lqt_hist_listing_subtitle' => 'Устуоруйатын көрүү',
	'lqt_hist_view_whole_thread' => 'Салаа устуоруйатын барытын көрүү',
	'lqt_hist_no_revisions_error' => 'Бу салаа устуоруйата отой суох',
	'lqt_hist_past_last_page_error' => 'Устуоруйалар сирэйдэрин ахсаанын бүтэр уһугар кэлбиккин.',
	'lqt_hist_tooltip_newer_disabled' => 'Бу сигэ арахсыбыт, тоҕо диэтэххэ эн бастакы сирэйгэ тураҕын.',
	'lqt_hist_tooltip_older_disabled' => 'Бу сигэ арахсыбыт, тоҕо диэтэххэ эн бүтэһик сирэйгэ тураҕын.',
	'lqt_hist_split' => 'Хоруй саҥа салааҕа көһөрүлүннэ',
	'lqt_hist_edited_subject' => 'Урукку "$2" аат маннык буолла(-бут): "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Тиэмэтэ уларыйда',
	'lqt_hist_merged_from' => '[[$1|Хоруй]] атын салааҕа көһөрүлүннэ',
	'lqt_hist_merged_to' => '[[$1|Хоруй]] атын салааттан көһөрүлүннэ',
	'lqt_hist_split_from' => 'Саҥа салааҕа көһөр',
	'lqt_hist_root_blanked' => 'Комментарий тиэкиһэ сотуллубут',
	'lqt_hist_adjusted_sortkey' => 'Салаа оннун уларыппыт',
	'lqt_revision_as_of' => 'Барыл $2 $3.',
	'lqt_change_new_thread' => 'Салаа бастакы барыла',
	'lqt_change_reply_created' => '[$1 бэлиэтэммит комментарий] бу барылга оҥоһуллубут.',
	'lqt_change_edited_root' => '[$1 бэлиэтэммит комментарий] бу барылга уларытыллыбыт.',
	'lqt_change_edited_summary' => 'Салаа туһунан сурук уларыйда',
	'lqt_change_deleted' => '[$1 Бу салаа] эбэтэр онно хоруй сотуллубуттар',
	'lqt_change_undeleted' => '[$1 Бэлиэтэммит этии] төннөрүлүннэ',
	'lqt_change_moved' => '[$1 Бу салаа] атын ырытыы сирэйигэр көһөрүллубүт',
	'lqt_change_split' => '[$1 Бу салаа] атын салааттан араарыллан оҥоһуллубут',
	'lqt_change_edited_subject' => 'Бу салаа урукку "$2" аата "$3" буолла',
	'lqt_change_merged_from' => 'Бу салаа [$1 хоруйа] атын салааҕа көһөрүллүбүт',
	'lqt_change_merged_to' => '[$1 Бэлиэтэммит хоруй] атын салааттан көһөрүллүбүт',
	'lqt_change_split_from' => '[$1 Бу салаа] аннынан баар салаа туспа салаа буолбут',
	'lqt_change_root_blanked' => '[$1 комментарий] тиэкиһэ сотуллубут.',
	'lqt_youhavenewmessages' => 'Эйиэхэ [[$1|саҥа сурук]] кэлбит.',
	'lqt_protectedfromreply' => 'Бу салаа киниэхэ хоруйтан $1.',
	'lqt_protectedfromreply_link' => 'көмүскэммит',
	'lqt_subject' => 'Аата:',
	'lqt_noreason' => 'Төрүөтэ ыйыллыбатах.',
	'lqt_move_placeholder' => 'Бу салаа бүөтэ $1 салаа бу сирэйтэн көһөрүллүбүтүн көрдөрөр. 
Көһөрүүнү $3 $4 сирэйгэ $2 кыттааччы оҥорбут. Онон салаа маннык буолбут $5.',
	'lqt_thread_deleted_for_sysops' => "Бу салаа '''сотуллубут''', дьаһабылларга эрэ костөр кыахтаах.",
	'lqt_thread_deleted' => 'Бу салаа сотуллубут.',
	'lqt_summary_notice' => 'Бу ырытыы $2 хонуктан ордук кэмҥэ уларытыллыбатах.
Бүппүт буоллаҕына $1.',
	'lqt_summary_notice_link' => 'түмүктээ',
	'lqt_summary_label' => 'Салаа түмүгэ:',
	'lqt_summary_subtitle' => '«$1» салаа түмүгэ',
	'lqt_nosuchrevision' => 'Бу салааҕа итинник барыл суох эбит.',
	'lqt_nosuchthread' => 'Ыйбыт салааҥ суох эбит.',
	'lqt_nosuchthread_title' => 'Маннык салаа суох',
	'lqt_threadrequired' => 'URL-га салааны ыйыахтааххын.',
	'lqt_move_movingthread' => '$1 көһөрүү. 
Бу салаа $2 сорҕото буолар.',
	'lqt_move_torename' => "Салааны аатын уларытыаххын баҕарар буоллаххына, $1 уонна 'Аата' диэн түннүгү уларыт.",
	'lqt_move_torename_edit' => 'маны көннөр',
	'lqt_move_destinationtitle' => 'Ырытыы сирэйин саҥа аата:',
	'lqt_move_move' => 'Көһөр',
	'lqt_move_nodestination' => 'Ханна көһөрөргүн ыйыахтааххын.',
	'lqt_move_thread_bad_destination' => 'Ыйыллыбыт сирэй ырытыы сирэйэ буолбатах дии.',
	'lqt_move_samedestination' => 'Маннык салаа бу сирэйгэ баар ээ!',
	'lqt_move_noreason' => 'Төрүөтэ ыйыллыбытах',
	'lqt_move_success' => 'Бу салаа манна көспүт $1.',
	'lqt_delete_undeletethread' => 'Салааны төннөрүү',
	'lqt_delete_partof' => "Бу салаа '''$1''' сорҕото буолар.",
	'lqt_delete_deleting' => "'''$1''' уонна '''бары хоруйдарын''' сотуу.",
	'lqt_delete_deletethread' => 'Салааны хоруйдарын кытта сот',
	'lqt_delete_deleted' => 'Салаа сотуллубут.',
	'lqt_delete_undeleted' => 'Салаа төннөрүлүннэ.',
	'lqt_delete_return' => 'Манна төнүн $1.',
	'lqt_delete_return_link' => 'ырытыы сирэйин',
	'lqt_delete_unallowed' => 'Ыстатыйаны сотор кыаҕыҥ суох.',
	'lqt_delete_show_checkbox' => 'Сотуллубут салаалары көрдөр',
	'lqt_talkpage_autocreate_summary' => 'Саҥа ырытыы сирэйэ бастакы этии оҥоһуллубутун кэннэ апатмаатынан оҥоһулунна.',
	'lqt_header_warning_big' => 'Маны эрэдээксийэлиигин $1.',
	'lqt_header_warning_after_big' => 'Ааттар биллэрии уонна киирии быһыытынан туттуллаллар. 
Эн маны оҥоруоххун сөп $2.',
	'lqt_header_warning_bold' => 'ырытар сирэй аата',
	'lqt_header_warning_new_discussion' => 'саҥа ырытыыны саҕалааһын',
	'lqt_sorting_order' => 'Наардааһын бэрээдэгэ:',
	'lqt_sort_newest_changes' => 'Бастаан уларытыллыбыттар',
	'lqt_sort_newest_threads' => 'кэлин уларытыллыбыттары бастаан туруор',
	'lqt_sort_oldest_threads' => 'урукку салаалары бастаан туруор',
	'lqt-title' => 'Баһа (аата)',
	'lqt-summary' => 'Ис хоһооно',
	'lqt-searching' => 'Салааларынан көрдөөһүн',
	'lqt-read-message' => 'Ааҕыллыбыт курдук бэлиэтээ',
	'lqt-read-message-tooltip' => 'Бу салааны саҥа этиилэр тиһиктэриттэн сот.
Ырытыы сирэйигэр оннунан хаалыа.',
	'lqt-read-all' => 'Барытын ааҕыллыбыт курдук бэлиэтээ',
	'lqt-read-all-tooltip' => 'Саҥа этиилэр тиһиктэриттэн салаалары барытын ылан кэбис.
Ол салаалар аналлаах ырытыы сирэйдэригэр хаалыахтара.
Бу дьайыы төннөрүллэр кыаҕа суох.',
	'lqt-marked-read' => "'''$1''' салаа ааҕыллыбыт курдук бэлиэтэннэ.",
	'lqt-count-marked-read' => '$1 этии ааҕыллыбыт курдук бэлиэтэннэ.',
	'lqt-email-undo' => 'Төннөр',
	'lqt-no-new-messages' => 'Эйиэхэ анаммыт саҥа сурук суох.',
	'lqt-new-messages' => '✒ Эйиэхэ саҥа суруктар бааллар.',
	'lqt-email-info-undo' => 'Билигин көрбүт салаабын төннөр.',
	'lqt-date-info' => 'Бу сигэ арахса сылдьар, тоҕо диэтэххэ эн туох баар салаалары барытын көрө олороҕун.',
	'lqt-newmessages-context' => 'Толору салаа',
	'lqt-thread-created' => 'Оҥоһулунна',
	'lqt-history-time' => 'Кэмэ',
	'lqt-history-user' => 'Кыттааччы',
	'lqt-history-action' => 'Көҕө',
	'lqt-history-comment' => 'Этии',
	'lqt-history-thread' => 'Салаа',
	'lqt-thread-edited-author' => 'Бу ааптар уларыппыт<br />
Бүтэһик уларытыы: $1',
	'lqt-thread-edited-others' => '$2 кыттааччы уларыппыт<br />
Бүтэһик уларытыы: $1',
	'lqt-header-actions' => 'Дьайыылар',
	'lqt_summarize_link' => 'Түмүк таһаарыы',
	'lqt-summarize-intro' => 'Бука диэн, кылгастык бу салаа туһунан суруй эрэ.
Ханнык баҕарар биики тиэкиһи туттуоххун сөп. Бүттэххинэ маны «{{int:savearticle}}» баттаа.',
	'lqt-thread-split' => 'Саҥа ырытыы салаатыгар таһаарарга',
	'lqt-split-success' => '$1 салааны сөпкө араардыҥ.',
	'lqt_split_thread' => 'Салаа араарыыта',
	'lqt-thread-split-subject' => 'Саҥа салаа аата:',
	'lqt-thread-split-thread' => 'Салаа:',
	'lqt-split-submit' => 'Араарыы',
	'lqt_split_badsubject' => 'Эн эппит аатыҥ сатаан туттуллубат.',
	'lqt-no-threads' => 'Бу сирэйгэ салаалара өссө суох.',
	'lqt-delete-parent-warning' => 'Бу бэйэтэ эппиэттэрдээх үөһээ салаа.
Туох баар хоруйдара эмиэ сотуллуохтара.
Олору сотуоххун баҕарбат буоллаххына ол хоруйдары бастаан атын салааларга таһаар.',
	'lqt-delete-parent-deleted' => 'Үөһээ салаа сотулунна ($1)',
	'lqt-delete-replies-done' => 'Бу салаа хоруйдара эмиэ сотулуннулар.',
	'lqt-movethread' => 'Аатын уларыт',
	'lqt-menu-trigger' => 'Эбии',
	'lqt-newmessages-from' => '$1 сирэйтэн',
	'lqt-hot-topics' => 'Итии тиэмэлэр',
	'lqt-add-reply' => 'Хоруйу эбии',
	'lqt_rc_new_discussion' => 'саҥа ырытыыны суруйда, "$1"',
	'lqt_rc_new_reply' => '"$1" этиигэ хоруйдааһын',
	'right-lqt-split' => 'Салаалары араарыы',
	'right-lqt-merge' => 'Салаалары холбооһун',
	'lqt-thread-merge' => 'Атын салааҕа холбооһун',
	'lqt-thread-merge-to' => 'Атын салааны холбооһун',
	'lqt_merge_thread' => 'Салаалары манна холбооһун',
	'lqt-thread-merge-source' => 'Холбонор салаалар:',
	'lqt-thread-merge-dest' => 'Ханна холбоноллоро:',
	'lqt-merge-submit' => 'Холбоо',
	'lqt-merge-success' => '$1 салаа $2 салааҕа сөпкө холбонно.',
	'lqt-log-name' => 'Ырытыы салааларын сурунаала',
	'lqt-log-header' => 'Бу сурунаалга ырытыы салааларыгар туох буолбута суруллан иһэр.',
	'lqt-log-action-move' => '[[$1]] мантан [[$2]] манна [[$3]] көспүт.',
	'lqt-log-action-split' => '[[$1]] кыттааччы мантан [[$3]] араарбыт, саҥа тиэмэ аата "$2"',
	'lqt-log-action-merge-across' => 'мантан [[$2]] манна [[$3]] [[$1]] көһөрбүт',
	'lqt-log-action-merge-down' => 'маны [[$1]] манна [[$3]] холбообут',
	'lqt-log-action-subjectedit' => '[[$1]] тиэмэни мантан «$2» манна «$3» уларыппыт',
	'lqt-log-action-resort' => 'наардааһын бэрээдэгин уларыппыт [[$1]]. Наардааһын күлүүһэ мантан $2 манныкка $3 уларыйбыт',
	'lqt-preference-notify-talk' => 'Кэтиир салаабар саҥа этии киирдэҕинэ мин почтабар сурукта ыыт',
	'lqt-preference-watch-threads' => 'Оҥорбут уонна хоруйдаабыт салааларбын кэтииргэ',
	'prefs-lqt' => 'Салааларынан ырытыылар',
	'lqt-preference-display-depth' => 'Хоруйдар көрдөрүллэр дириҥнэрэ:',
	'lqt-preference-display-count' => 'Хоруйдар көрдөрүллэр ахсааннара',
	'lqt-preference-custom-signatures' => 'Кыттаачылар улартыллар илии баттааһыннарын көрдөр',
	'lqt-enotif-subject-reply' => '{{SITENAME}} ырытыы — Хоруй: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} ырытыы — Саҥа салаа: $1',
	'lqt-enotif-newthread' => 'Дорообо, $1.
Бу $3 $4 {{SITENAME}} саайка баар $5 сирэйгэ «$2» диэн саҥа салаа үөскээбитин туһунан биллэрии. 

Бу аадырыска <$6> көрүөххүн сөп.',
	'lqt-enotif-reply' => 'Дорообо, $1.
Бу $3 $4 {{SITENAME}} саайка баар $5 сирэй «$2» салаатыгар саҥа хоруй баар буолбутун туһунан биллэрии. 

Бу аадырыска <$6> көрүөххүн сөп.

Хоруй тиэкиһэ:
$7',
	'lqt-quote-intro' => '$2 $3, [[User:$1|$1]] суруйбут:',
	'lqt-quote' => 'Цитааталааһын',
	'lqt-search-legend' => 'Бу сирэйгэ баар ырытыылары көрдөөһүн',
	'lqt-search-label' => 'Көрдөөһүн усулуобуйата:',
	'lqt-search-button' => 'Буларга',
	'searchprofile-threads' => 'Ырытыылар',
	'searchprofile-threads-tooltip' => 'Ырытыы салааларыгар уонна ырытыы сирэйдэригэр көрдөөһүн',
	'lqt-ajax-updated' => 'Бу салааҕа саҥа ырытыылар бааллар.',
	'lqt-ajax-update-link' => 'Саҥардыы',
	'lqt-thread-show-replies' => '$1 хоруйу көрдөр',
	'lqt-thread-show-more' => 'Өссө элбэҕи көрдөр',
	'lqt-thread-link-url' => 'URL:',
	'lqt-thread-link-title' => 'Биики сигэ:',
	'lqt-thread-link-copy' => 'Атастаһыы буферыгар угуу',
	'lqt-sign-not-necessary' => 'Түөрт тильда көмөтүнэн илии баттыыр наадата суох.
Илии баттааһыныҥ бэйэтэ тахсыаҕа.',
	'lqt-marked-as-read-placeholder' => '$1 салаа ааҕыллыбыт курдук бэлиэтэннэ.',
	'lqt-change-subject' => 'Тиэмэ аатын уларыт',
	'lqt-save-subject' => 'Бигэргэтэргэ',
	'lqt-save-subject-failed' => 'Бу салаа аатын уларытарга маннык алҕас таҕыста: $1',
	'lqt-ajax-invalid-subject' => 'Эн эппит ааккын суруйар табыллыбата, баҕар наһаа уһун буолбута буолуо.',
	'lqt-ajax-no-subject' => 'Тиэмэ аатын суруйуохтааххын.',
	'lqt-save-subject-error-unknown' => 'Бу салаа аатын ааҕарга туох эрэ биллибэт алҕас таҕыста. Онон, бука диэн, этии үөһээ өттүгэр баар "уларыт" тимэҕи баттаан көр.',
	'lqt-cancel-subject-edit' => 'Таҕыс',
	'lqt-drag-activate' => 'Саҥа сиргэ көһөрүү',
	'lqt-drag-drop-zone' => 'Манна көһөрүү',
	'lqt-drag-confirm' => 'Бу дьайыыны оҥорорго бастаан бука диэн төрүөтун ый, онтон «Бигэргэтэргэ» тимэҕи баттаа.',
	'lqt-drag-reparent' => 'Суругу атын төрөппүт сурукка көһөрүү',
	'lqt-drag-split' => 'Суругу бэйэ салаатыгар көһөрүү',
	'lqt-drag-setsortkey' => 'Сурук сирэйгэ баар сирин уларытыы',
	'lqt-drag-bump' => 'Суругу ырытыы саҕаланыытыгар көһөрөргө',
	'lqt-drag-save' => 'Бигэргэтии',
	'lqt-drag-title' => 'Көһөрүүнү бигэргэтии',
	'lqt-drag-reason' => 'Төрүөтэ:',
	'lqt-drag-subject' => 'Саҥа салаа тиэмэтэ:',
	'lqt-edit-signature' => '(илии баттааһыны уларытыы)',
	'lqt-preview-signature' => '(эрдэ көрүү)',
	'lqt-feed-title-all' => '{{SITENAME}} — Саҥа суруктар',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Саҥа суруктар $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Саҥа салаалар',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Саҥа салаалар $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Хоруйдар',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Хоруйдар $1',
	'lqt-feed-new-thread-intro' => 'Манна $1 $2 оҥорбут саҥа салаата',
	'lqt-feed-reply-intro' => '$3 сурукка хоруй ($1) манна баар $2',
	'tooltip-pt-newmessages' => 'Эн кэтиир салааларгар уонна ырытыыларгар саҥа суруктары көрдөрөр',
	'lqt-newmessages-n' => 'Саҥа этиилэр ($1)',
	'lqt_newmessages' => 'Саҥа этиилэрим (Суох)',
	'lqt_newmessages-title' => 'Саҥа этиилэр',
	'lqt-newpost-summary' => 'Саҥа салаа: $1',
	'lqt-reply-summary' => 'Манна [[$2|$1]] хоруй',
	'lqt-talkpage-history-title' => 'Ырытыы сирэйин устуоруйата',
	'lqt-talkpage-history-subtitle' => '$1 аналлаах',
	'lqt-talkpage-history-tab' => 'Аата/Баһа',
	'restriction-reply' => 'хоруй суруйуу',
	'restriction-newthread' => 'Саҥа салаалары саҕалааһын',
	'lqt-protected-reply-thread' => 'Бу салааҕа суруйар кыаҕыҥ суох, тоҕо диэтэххэ саҥа суруйуулары оҥорор бобуллубут.',
	'lqt-protected-reply-talkpage' => 'Бу салааҕа суруйар кыаҕыҥ суох эбит, тоҕо диэтэххэ бу ырытыы сирэйин салааларыгар хоруйдуур бобуллубут.',
	'lqt-protected-newthread' => 'Бу ырытыы сирэйигэр саҥа салаалары оҥорор бобуллубут эбит.',
	'lqt-edit-bump' => 'Бу салааны үөһэ көтөҕөн биэр',
	'lqt-edit-bump-tooltip' => 'Бу салааны сирэй саҕаланыытыгар көһөр',
	'lqt-historicalrevision-error' => 'Талбыт барылыҥ алҕастаах буолан сатаан көрүллүбэт эбит.',
	'lqt-reply-subpage' => 'хоруйдуурга',
	'nstab-thread' => 'Салаа',
	'nstab-summary' => 'Быһаарыы',
);

/** Sicilian (Sicilianu)
 * @author Melos
 */
$messages['scn'] = array(
	'lqt_hist_deleted' => 'Cancillatu',
	'lqt_hist_undeleted' => 'Ripristinatu',
	'lqt_hist_moved_talkpage' => 'Spustatu',
);

/** Tachelhit (Tašlḥiyt)
 * @author Zanatos
 */
$messages['shi'] = array(
	'lqt_reply' => 'jawb',
	'lqt_delete' => 'msḥ',
	'lqt_hist_deleted' => 'ityumsaḥ',
	'lqt_hist_undeleted' => 'ur-ityumsaḥ',
);

/** Sinhala (සිංහල)
 * @author බිඟුවා
 */
$messages['si'] = array(
	'lqt_from_talk' => '$1 වෙතින්',
	'lqt_hist_deleted' => 'මකා දමන ලදී',
	'lqt_hist_undeleted' => 'මකාදැමීම අවලංගු කරන ලදී',
	'lqt_subject' => 'විෂයය:',
	'lqt_move_move' => 'ගෙනයන්න',
	'lqt-title' => 'මාතෘකාව',
	'lqt-history-time' => 'වේලාව',
	'lqt-history-user' => 'පරිශීලක',
	'lqt-history-comment' => 'පරිකථනය',
);

/** Slovak (Slovenčina)
 * @author Helix84
 * @author Jkjk
 * @author Mormegil
 */
$messages['sk'] = array(
	'lqt-desc' => 'Pridáva organizáciu správ na diskusných stránkach do vlákien',
	'lqt_movethread' => 'Presunúť vlákno na inú stránku',
	'lqt_deletethread' => 'Zmazať alebo obnoviť zmazané vlákno',
	'lqt_contents_title' => 'Obsah',
	'lqt_toc_thread_title' => 'Názov vlákna',
	'lqt_toc_thread_author' => 'Začal',
	'lqt_toc_thread_replycount' => 'Odpovede',
	'lqt_toc_thread_modified' => 'Posledná zmena',
	'lqt_add_header' => 'Pridať hlavičku',
	'lqt_new_thread' => 'Začať novú diskusiu',
	'lqt_invalid_subject' => 'Predmet, ktorý ste zadali je neplatný. Môže:
* byť príliš dlhý alebo
* byť v konflikte s predponami interwiki alebo názvami menných priestorov.',
	'lqt_empty_subject' => 'Musíte napísať predmet.',
	'lqt_reply' => 'Odpovedať',
	'lqt-parent' => 'Nadradené',
	'lqt_delete' => 'Zmazať',
	'lqt_undelete' => 'Obnoviť zmazané',
	'lqt_permalink' => 'Odkaz na',
	'lqt_fragment' => 'úryvok z $1 od $2',
	'lqt_discussion_link' => 'diskusia',
	'lqt_from_talk' => 'od $1',
	'lqt-history-title' => 'História vlákna',
	'lqt_hist_comment_edited' => 'Text komentára [$2 upravený]',
	'lqt_hist_summary_changed' => 'Zhrnutie sa zmenilo',
	'lqt_hist_reply_created' => '[[$1|Nová odpoveď]] vytvorená',
	'lqt_hist_thread_created' => 'Bolo vytvorené nové vlákno',
	'lqt_hist_deleted' => 'Zmazané',
	'lqt_hist_undeleted' => 'Obnovené zmazanie',
	'lqt_hist_moved_talkpage' => 'Presunuté',
	'lqt_hist_listing_subtitle' => 'Zobrazuje sa výpis histórie',
	'lqt_hist_view_whole_thread' => 'Zobraziť históriu celého vlákna',
	'lqt_hist_no_revisions_error' => 'Toto vlákno nemá historické revízie.',
	'lqt_hist_past_last_page_error' => 'Prekročili ste počet stránok histórie, ktoré táto stránka má.',
	'lqt_hist_tooltip_newer_disabled' => 'Tento odkaz je nefunkčný, pretože sa nachádzate na prvej stránke.',
	'lqt_hist_tooltip_older_disabled' => 'Tento odkaz je nefunkčný, pretože sa nachádzate na poslednej stránke.',
	'lqt_hist_split' => 'Odpoveď oddelená do nového vlákna',
	'lqt_hist_edited_subject' => 'Upravený predmet z „$2“ na „$3“',
	'lqt_hist_edited_subject_corrupt' => 'Zmenený predmet',
	'lqt_hist_merged_from' => '[[$1|Odpoveď]] presunutá do iného vlákna',
	'lqt_hist_merged_to' => '[[$1|Odpoveď]] presunutá z iného vlákna',
	'lqt_hist_split_from' => 'Oddelené do nového vlákna',
	'lqt_hist_root_blanked' => 'Text odstráneného komentára',
	'lqt_hist_adjusted_sortkey' => 'Upravená pozícia vlákna',
	'lqt_revision_as_of' => 'Revízia z $2 $3.',
	'lqt_change_new_thread' => 'Toto je prvotná revízia vlákna.',
	'lqt_change_reply_created' => '[$1 Zvýraznený komentár] bol vytvorený v tejto revízii.',
	'lqt_change_edited_root' => '[$1 Zvýraznený komentár] bol upravený v tejto revízii.',
	'lqt_change_edited_summary' => 'Zhrnutie vlákna bolo upravené',
	'lqt_change_deleted' => '[$1 Toto vlákno] alebo odpoveď naň bola zmazaná',
	'lqt_change_undeleted' => '[$1 Zvýraznený príspevok] bol obnovený',
	'lqt_change_moved' => '[$1 Toto vlákno] bolo presunuté na inú diskusnú stránku',
	'lqt_change_split' => '[$1 Toto vlákno] bolo oddelené z iného vlákna',
	'lqt_change_edited_subject' => 'Predmet tohto vlákna bol zmenený z „$2“ na „$3“',
	'lqt_change_merged_from' => '[$1 Odpoveď] na toto vlákno bola presunutá do iného vlákna',
	'lqt_change_merged_to' => '[$1 Zvýraznená odpoveď] bola presunutá z iného vlákna',
	'lqt_change_split_from' => '[$1 Podvlákno] tohto vlákna bolo oddelené do samostatného vlákna',
	'lqt_change_root_blanked' => 'Text [$1 komentára] bol odstránený.',
	'lqt_youhavenewmessages' => 'Máte [[$1|nové správy]].',
	'lqt_protectedfromreply' => 'Toto vlákno bolo $1 proti odpovediam naň.',
	'lqt_protectedfromreply_link' => 'zamknuté',
	'lqt_subject' => 'Predmet:',
	'lqt_noreason' => 'Nebol udaný dôvod.',
	'lqt_move_placeholder' => 'Toto vlákno je vyhradené miesto, ktoré označuje, že vlákno $1 bolo presunuté z tejto stránky na inú diskusnú stránku.
Tento presun vykonal $2 $3 $4. Vlákno sa teraz nachádza na $5.',
	'lqt_thread_deleted_for_sysops' => "Vlákno bolo '''zmazané''' a môžu ho vidieť iba správcovia.",
	'lqt_thread_deleted' => 'Toto vlákno bolo zmazané.',
	'lqt_summary_notice' => 'V tejto diskusii nenastali zmeny najmenej $2 {{PLURAL:$2|deň|dni|dní}}.
Ak diskusia skončila, mali by ste $1.',
	'lqt_summary_notice_link' => 'napísať jej zhrnutie',
	'lqt_summary_label' => 'Zhrnutie vlákna:',
	'lqt_summary_subtitle' => 'zhrnutie „$1“.',
	'lqt_nosuchrevision' => 'Takáto revízia v tomto vlákne neexistuje.',
	'lqt_nosuchthread' => 'Vlákno, ktoré ste zadali neexistuje.',
	'lqt_nosuchthread_title' => 'Také vlákno neexistuje',
	'lqt_threadrequired' => 'V URL musíte zadať vlákno.',
	'lqt_move_movingthread' => 'Presúva sa $1. Toto vlákno je súčasťou $2.',
	'lqt_move_torename' => 'Aby ste premenovali toto vlákno, $1 a zmeňte pole „Predmet“.',
	'lqt_move_torename_edit' => 'upravte ho',
	'lqt_move_destinationtitle' => 'Názov cieľovej diskusnej stránky:',
	'lqt_move_move' => 'Presunúť',
	'lqt_move_nodestination' => 'Musíte zadať cieľ.',
	'lqt_move_thread_bad_destination' => 'Cieľová stránka nie je diskusná stránka.',
	'lqt_move_samedestination' => 'Vlákno už na tejto stránke existuje!',
	'lqt_move_noreason' => 'Nebol uvedený dôvod.',
	'lqt_move_success' => 'Vlákno bolo presunuté na $1.',
	'lqt_delete_undeletethread' => 'Obnoviť zmazané vlákno',
	'lqt_delete_partof' => "Toto vlákno je súčasťou '''$1'''.",
	'lqt_delete_deleting' => "Maže sa '''$1''' a '''všetky odpovede'''naň.",
	'lqt_delete_deletethread' => 'Zmazať vlákno a odpovede',
	'lqt_delete_deleted' => 'Vlákno bolo zmazané.',
	'lqt_delete_undeleted' => 'Vlákno bolo obnovené.',
	'lqt_delete_return' => 'Vrátiť sa na $1.',
	'lqt_delete_return_link' => 'diskusnú stránku',
	'lqt_delete_unallowed' => 'Nemáte povolenie mazať vlákna.',
	'lqt_delete_show_checkbox' => 'Zobraziť zmazané vlákna',
	'lqt_talkpage_autocreate_summary' => 'Diskusná stránka bola automaticky vytvorená pri prvom príspevku do vlákna.',
	'lqt_header_warning_big' => 'Upravujete $1.',
	'lqt_header_warning_after_big' => 'Hlavičky slúžia na oznámenia a úvody. Namiesto toho môžete $2.',
	'lqt_header_warning_bold' => 'hlavička diskusnej stránky',
	'lqt_header_warning_new_discussion' => 'začať novú diskusiu',
	'lqt_sorting_order' => 'Poradie radenia:',
	'lqt_sort_newest_changes' => 'posledné zmenené na začiatku',
	'lqt_sort_newest_threads' => 'najnovšie vlákna na začiatku',
	'lqt_sort_oldest_threads' => 'najstaršie vlákna na začiatku',
	'lqt-title' => 'Nadpis',
	'lqt-summary' => 'Zhrnutie',
	'lqt-searching' => 'Hľadajú sa vlákna',
	'lqt-read-message' => 'Označiť ako prečítané',
	'lqt-read-message-tooltip' => 'Odstrániť toto vlákno z nových správ.
Stále bude viditeľné na jeho pôvodnej diskusnej stránke.',
	'lqt-read-all' => 'Označiť všetky ako prečítané',
	'lqt-read-all-tooltip' => 'Odstrániť všetky vlákna z nových správ. Budú stále viditeľné na ich pôvodných diskusných stránkach. Túto operáciu možno vrátiť späť.',
	'lqt-marked-read' => "Vlákno '''$1''' bolo označené ako prečítané.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|správa bola označená ako prečítaná|správy boli označené ako prečítané|správ bolo označených ako prečítané}}.',
	'lqt-email-undo' => 'Vrátiť',
	'lqt-no-new-messages' => 'Nemáte žiadne nové správy.',
	'lqt-new-messages' => '✒ Máte nové správy.',
	'lqt-email-info-undo' => 'Vrátiť vlákno, ktoré ste práve zrušili.',
	'lqt-date-info' => 'Tento odkaz je vypnutý, pretože zobrazujete vlákna bez ohľadu na dátum.',
	'lqt-newmessages-context' => 'Celé vlákno',
	'lqt-thread-created' => 'Vytvorené',
	'lqt-history-time' => 'Čas',
	'lqt-history-user' => 'Používateľ',
	'lqt-history-action' => 'Aktivita',
	'lqt-history-comment' => 'Komentár',
	'lqt-history-thread' => 'Vlákno',
	'lqt-thread-edited-author' => 'Upravené autorom<br />
Posledná úprava: $1',
	'lqt-thread-edited-others' => 'Upravené {{PLURAL:$2|iným používateľom|$2 inými používateľmi}}.<br />
Posledná úprava: $1',
	'lqt-header-actions' => 'Operácie',
	'lqt_summarize_link' => 'Zhrnúť',
	'lqt-summarize-intro' => 'Zhrňte prosím dolu uvedené vlákno do poľa na úpravy.
V zhrnutí môžete použiť wikitext. Keď skončíte, kliknite na „{{int:savearticle}}“.',
	'lqt-thread-split' => 'Oddeliť do nového vlákna',
	'lqt-split-success' => 'Úspešne ste oddelili vlákno $1.',
	'lqt_split_thread' => 'Oddeliť vlákno',
	'lqt-thread-split-subject' => 'Predmet nového vlákna:',
	'lqt-thread-split-thread' => 'Vlákno:',
	'lqt-split-submit' => 'Oddeliť',
	'lqt_split_badsubject' => 'Predmet, ktorý ste zadali nie je platný.',
	'lqt-no-threads' => 'Na tejto stránke zatiaľ nie sú žiadne vlákna.',
	'lqt-delete-parent-warning' => 'Toto je vlákno najvyššej úrovne s odpoveami.
Odpovede naň sa tiež automaticky zmažú.
Ak tomu chcete zabrániť, oddeľte ich od tohto vlákna predtým, než ho zmažete.',
	'lqt-delete-parent-deleted' => 'Rodičovské vlákno zmazané ($1)',
	'lqt-delete-replies-done' => 'Boli zmazané aj všetky odpovede na toto vlákno.',
	'lqt-movethread' => 'Presunúť',
	'lqt-menu-trigger' => 'Viac',
	'lqt-newmessages-from' => 'Z $1',
	'lqt-hot-topics' => 'Horúce témy',
	'lqt-add-reply' => 'Pridať odpoveď',
	'lqt_rc_new_discussion' => 'začal nové vlákno, „$1“',
	'lqt_rc_new_reply' => 'odpovedal na „$1“',
	'right-lqt-split' => 'Oddeliť vlákna',
	'right-lqt-merge' => 'Zlúčiť vlákna',
	'lqt-thread-merge' => 'Zlúčiť do iného vlákna',
	'lqt-thread-merge-to' => 'Zlúčiť do tohto vlákna',
	'lqt_merge_thread' => 'Zlúčiť vlákna',
	'lqt-thread-merge-source' => 'Zdrojové vlákno:',
	'lqt-thread-merge-dest' => 'Cieľové vlákno:',
	'lqt-merge-submit' => 'Zlúčiť',
	'lqt-merge-success' => 'Úspešne ste zlúčili vlákno $1 pod $2.',
	'lqt-log-name' => 'Záznam diskusie vo vláknach',
	'lqt-log-header' => 'Tento záznam obsahuje podrobnosti o operáciách s diskusnými vláknami.',
	'lqt-log-action-move' => 'presunul [[$1]] z [[$2]] na [[$3]].',
	'lqt-log-action-split' => 'oddelil [[$1]] spod [[$3]], s novým predmetom „$2“',
	'lqt-log-action-merge-across' => 'presunul [[$1]] spod [[$2]] pod [[$3]]',
	'lqt-log-action-merge-down' => 'zlúčil [[$1]] pod [[$3]]',
	'lqt-log-action-subjectedit' => 'zmenil predmet [[$1]] z „$2“ na „$3“',
	'lqt-log-action-resort' => 'zmenil zoradenie [[$1]]. Zoraďovací kľúč zmenený z „$2“ na „$3“',
	'lqt-preference-notify-talk' => 'Posielať mi odpovede na vlákna, ktoré sledujem emailom',
	'lqt-preference-watch-threads' => 'Sledovať vlákna, ktoré vytvorím alebo na ktoré odpoviem',
	'prefs-lqt' => 'Diskusia vo vláknach',
	'lqt-preference-display-depth' => 'Zobrazovať odpovede najviac do úrovne:',
	'lqt-preference-display-count' => 'Zobrazovať najviac odpovedí:',
	'lqt-preference-custom-signatures' => 'Zobraziť prispôsobené podpisy používateľov',
	'lqt-enotif-subject-reply' => 'Diskusia {{GRAMMAR:genitív|{{SITENAME}}}} - Odpoveď: $1',
	'lqt-enotif-subject-newthread' => 'Diskusia {{GRAMMAR:genitív|{{SITENAME}}}} - Nové vlákno: $1',
	'lqt-enotif-newthread' => 'Ahoj $1,
toto je oznámenie z {{GRAMMAR:genitív|{{SITENAME}}}}, že nové vlákno $5, „$2“,
$3 $4 vytvoril $8.

Môžete si ho pozrieť na <$6>

Text je:
$7',
	'lqt-enotif-reply' => 'Ahoj $1,
toto je oznámenie z {{GRAMMAR:genitív|{{SITENAME}}}}, že používateľ $8 pridal $3 $4
novú odpoveď na $5, „$2“.

Môžete si ju pozrieť na <$6>

Text odpovede je:
$7',
	'lqt-quote-intro' => '$2 $3 [[User:$1|$1]] napísal:',
	'lqt-quote' => 'Citovať',
	'lqt-search-legend' => 'Hľadať v diskusiách k tejto stránke',
	'lqt-search-label' => 'Hľadaný výraz:',
	'lqt-search-button' => 'Hľadať',
	'searchprofile-threads' => 'Diskusie',
	'searchprofile-threads-tooltip' => 'Hľadať v diskusiách vo vláknach a na diskusných stránkach',
	'lqt-ajax-updated' => 'Toto vlákno má nové príspevky.',
	'lqt-ajax-update-link' => 'Aktualizovať',
	'lqt-thread-show-replies' => 'Zobraziť $1 odpovedí',
	'lqt-thread-show-more' => 'Zobraziť ďalšie odpovede',
	'lqt-thread-link-url' => 'URL odkazu:',
	'lqt-thread-link-title' => 'Odkaz wikitextu:',
	'lqt-thread-link-copy' => 'Skopírovať do schránky',
	'lqt-sign-not-necessary' => 'Je je nutné podpisovať vaše príspevky tildami.
Podpis sa zobrazí automaticky.',
	'lqt-marked-as-read-placeholder' => 'Vlákno $1 bolo označené ako prečítané.',
	'lqt-change-subject' => 'Zmeniť predmet',
	'lqt-save-subject' => 'Uložiť',
	'lqt-save-subject-failed' => 'Počas zmeny predmetu tohto vlákna sa vyskytla nasledovná chyba: $1',
	'lqt-ajax-invalid-subject' => 'Predmet, ktorý ste uviedli nie je platný, pravdepodobne preto, že je príliš dlhý.',
	'lqt-ajax-no-subject' => 'Musíte uviesť predmet.',
	'lqt-save-subject-error-unknown' => 'Počas zmeny predmetu tohto vlákna sa vyskytla neznáma chyba. Prosím, skúste to kliknutím na „upraviť“ v hornom príspevku.',
	'lqt-cancel-subject-edit' => 'Zrušiť',
	'lqt-drag-activate' => 'Pretiahnuť na novú pozíciu',
	'lqt-drag-drop-zone' => 'Pustiť tu',
	'lqt-drag-confirm' => 'Nasledovné operácie ukončíte napísaním dôvodu a kliknutím na „Potvrdiť“.',
	'lqt-drag-reparent' => 'Presunúť príspevok pod nový nadradený príspevok.',
	'lqt-drag-split' => 'Presunúť príspevok do vlastného vlákna',
	'lqt-drag-setsortkey' => 'Prispôsobiť pozíciu príspevku na stránke',
	'lqt-drag-bump' => 'Presunúť príspevok na vrch diskusnej stránky',
	'lqt-drag-save' => 'Potvrdiť',
	'lqt-drag-title' => 'Potvrdiť ťahanie',
	'lqt-drag-reason' => 'Dôvod:',
	'lqt-drag-subject' => 'Predmet nového vlákna:',
	'lqt-edit-signature' => '(upraviť podpis)',
	'lqt-preview-signature' => '(náhľad)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nové príspevky',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nové príspevky od $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nové vlákna',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nové vlákna od $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Odpovede',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Odpovede od $1',
	'lqt-feed-new-thread-intro' => 'Nové vlákno na tému $1, ktoré poslal $2',
	'lqt-feed-reply-intro' => 'Odpoveď na $3 (na tému $1), ktorú poslal $2',
	'tooltip-pt-newmessages' => 'Zobrazuje nové príspevky vo vláknach alebo na diskusných stránkach s vláknami, ktoré sledujete',
	'lqt-newmessages-n' => '{{PLURAL:$1|Nová správa|Nové správy}} ($1)',
	'lqt_newmessages' => 'Moje nové správy (žiadne)',
	'lqt_newmessages-title' => 'Nové správy',
	'lqt-newpost-summary' => 'Nové vlákno: $1',
	'lqt-reply-summary' => 'Odpoveď na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'História diskusnej stránky',
	'lqt-talkpage-history-subtitle' => 'Pre $1',
	'lqt-talkpage-history-tab' => 'Hlavička',
	'restriction-reply' => 'Poslať odpovede',
	'restriction-newthread' => 'Poslať nové vlákna',
	'lqt-protected-reply-thread' => 'Nemôžete prispievať do tohto vlákna, pretože nové príspevky doň boli zakázané.',
	'lqt-protected-reply-talkpage' => 'Nemôžete prispievať do tohto vlákna, pretože odpovede na vlákna na tejto diskusnej stránke boli zakázané.',
	'lqt-protected-newthread' => 'Nemôžete prispievať na túto diskusnú stránku, pretože boli zakázané nové vlákna na tejto diskusnej stránke.',
	'lqt-edit-bump' => 'Zviditeľniť toto vlákno',
	'lqt-edit-bump-tooltip' => 'Presunúť toto vlákno na vrch diskusnej stránky',
	'lqt-historicalrevision-error' => 'Revízia, ktorú ste si vybrali je poškodená a nemožno ju zobraziť.',
	'lqt-reply-subpage' => 'odpovedať',
	'nstab-thread' => 'Vlákno',
	'nstab-summary' => 'Zhrnutie',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'lqt-desc' => 'Doda možnost razprav na pogovorne strani',
	'lqt_movethread' => 'Premakni razpravo na drugo stran',
	'lqt_deletethread' => 'Izbriši ali obnovi razpravo',
	'lqt_contents_title' => 'Vsebina',
	'lqt_toc_thread_title' => 'Naslov razprave',
	'lqt_toc_thread_author' => 'Začel',
	'lqt_toc_thread_replycount' => 'Odgovori',
	'lqt_toc_thread_modified' => 'Zadnja sprememba',
	'lqt_add_header' => 'Dodaj glavo',
	'lqt_new_thread' => 'Začni novo razpravo',
	'lqt_invalid_subject' => 'Vnesena zadeva je neveljavna.
Lahko:
* je predolga ali
* je v sporu s predponami interwiki ali imeni imenskih prostorov.',
	'lqt_empty_subject' => 'Vnesti morate zadevo.',
	'lqt_reply' => 'Odgovori',
	'lqt-parent' => 'Starš',
	'lqt_delete' => 'Izbriši',
	'lqt_undelete' => 'Obnovi',
	'lqt_permalink' => 'Trajna povezava',
	'lqt_fragment' => 'Odlomek $1 iz $2',
	'lqt_discussion_link' => 'razprave',
	'lqt_from_talk' => 'Iz $1',
	'lqt-history-title' => 'Zgodovina razprave',
	'lqt_hist_comment_edited' => '[$2 Urejeno] besedilo pripombe',
	'lqt_hist_summary_changed' => 'Povzetek je spremenjen',
	'lqt_hist_reply_created' => 'Ustvarjen [[$1|nov odgovor]]',
	'lqt_hist_thread_created' => 'Ustvarjena nova razprava',
	'lqt_hist_deleted' => 'Izbrisano',
	'lqt_hist_undeleted' => 'Obnovljeno',
	'lqt_hist_moved_talkpage' => 'Prestavljeno',
	'lqt_hist_listing_subtitle' => 'Pregledovanje seznama zgodovine',
	'lqt_hist_view_whole_thread' => 'Ogled zgodovine za celotno razpravo',
	'lqt_hist_no_revisions_error' => 'Ta razprava nima nobenih zgodovinskih redakcij.',
	'lqt_hist_past_last_page_error' => 'Presegate število strani v zgodovini, ki obstajajo.',
	'lqt_hist_tooltip_newer_disabled' => 'Povezava je onemogočena, ker ste na prvi strani.',
	'lqt_hist_tooltip_older_disabled' => 'Povezava je onemogočena, ker ste na zadnji strani.',
	'lqt_hist_split' => 'Odgovor je razdejen v novo razpravo',
	'lqt_hist_edited_subject' => 'Sprememba zadeve iz »$2« v »$3«',
	'lqt_hist_edited_subject_corrupt' => 'Sprememba zadeve',
	'lqt_hist_merged_from' => '[[$1|Odgovor]] je prestavljen v drugo razpravo',
	'lqt_hist_merged_to' => '[[$1|Odgovor]] je prestavljen iz druge razprave',
	'lqt_hist_split_from' => 'Razcep na novo razpravo',
	'lqt_hist_root_blanked' => 'Odstranitev besedila komentarja',
	'lqt_hist_adjusted_sortkey' => 'Prilagoditev položaja razprav',
	'lqt_revision_as_of' => 'Redakcija dne $2 ob $3.',
	'lqt_change_new_thread' => 'To je začetna redakcija razprave.',
	'lqt_change_reply_created' => '[$1 Poudarjena pripomba] je bila ustvarjena v tej redakciji.',
	'lqt_change_edited_root' => '[$1 Poudarjena pripomba] je bila spremenjena v tej redakciji.',
	'lqt_change_edited_summary' => 'Povzetek razprave je bil spremenjen',
	'lqt_change_deleted' => '[$1 Razprava] ali njen starš sta bila izbrisana',
	'lqt_change_undeleted' => '[$1 Označena objava] je obnovljena',
	'lqt_change_moved' => '[$1 Razprava] je prestavljena na drugo stran z razpravami',
	'lqt_change_split' => '[$1 Razprava] je bila razcepljena iz druge razprave',
	'lqt_change_edited_subject' => 'Zadeva razprave je spremenjena iz »$2« v »$3«',
	'lqt_change_merged_from' => '[$1 Odgovor] na razpravo je prestavljen na drugo razpravo',
	'lqt_change_merged_to' => '[$1 Označeni odgovor] je prestavljen na drugo razpravo',
	'lqt_change_split_from' => '[$1 Podrazprava] te razprave je bila razdeljena v svojo lastno razpravo',
	'lqt_change_root_blanked' => 'Besedilo [$1 komentarja] je bilo odstranjeno.',
	'lqt_youhavenewmessages' => 'Imate [[$1|nova sporočila]].',
	'lqt_protectedfromreply' => 'Ta razprava je bila $1 pred odgovori.',
	'lqt_protectedfromreply_link' => 'zaščitena',
	'lqt_subject' => 'Zadeva:',
	'lqt_noreason' => 'Razlog ni podan.',
	'lqt_move_placeholder' => 'Razprava, $1, je bila prestavljena od tukaj na $5.
Prestavitev je izvedel $2 dne $3 ob $4.',
	'lqt_thread_deleted_for_sysops' => "Ta razprava je bila '''izbrisana''' in je vidna samo administratorjem.",
	'lqt_thread_deleted' => 'Ta razprava je bila izbrisana.',
	'lqt_summary_notice' => 'V tej razpravi ni bilo sprememb že najmanj $2 {{PLURAL:$2|dan|dneva|dnevi|dni}}.
Če je sklenjena, morda želite $1.',
	'lqt_summary_notice_link' => 'napisati povzetek',
	'lqt_summary_label' => 'Povzetek razprave:',
	'lqt_summary_subtitle' => 'Povzetek »$1«',
	'lqt_nosuchrevision' => 'Ni takšne redakcije te razprave.',
	'lqt_nosuchthread' => 'Določena razprava ne obstaja.',
	'lqt_nosuchthread_title' => 'Ni takšne razprave',
	'lqt_threadrequired' => 'Razpravo morate določiti v URL.',
	'lqt_move_movingthread' => 'Prestavljanje $1.
Ta razprava je del $2.',
	'lqt_move_torename' => "Če želite preimenovati to razpravo, $1 in spremenite polje 'Zadeva'.",
	'lqt_move_torename_edit' => 'jo uredite',
	'lqt_move_destinationtitle' => 'Naslov ciljne pogovorne strani:',
	'lqt_move_move' => 'Prestavi',
	'lqt_move_nodestination' => 'Navesti morate cilj.',
	'lqt_move_thread_bad_destination' => 'Ciljna stran ni stran z razpravo.',
	'lqt_move_samedestination' => 'Razprava je že na tej strani!',
	'lqt_move_noreason' => 'Razlog ni podan.',
	'lqt_move_success' => 'Razprava je bila predstavljena na $1.',
	'lqt_delete_undeletethread' => 'Obnovi razpravo',
	'lqt_delete_partof' => "Ta razprava je del  '''$1'''.",
	'lqt_delete_deleting' => "Brisanje '''$1''' in '''vseh odgovorov''' nanjo.",
	'lqt_delete_deletethread' => 'Izbriši razpravo in odgovore',
	'lqt_delete_deleted' => 'Razprava je izbrisana.',
	'lqt_delete_undeleted' => 'Razprava je obnovljena.',
	'lqt_delete_return' => 'Vrni se na $1.',
	'lqt_delete_return_link' => 'pogovorno stran',
	'lqt_delete_unallowed' => 'Brisanje razprav vam ni dovoljeno.',
	'lqt_delete_show_checkbox' => 'Prikaži izbrisane razprave',
	'lqt_talkpage_autocreate_summary' => 'Pogovorna stran je bila samodejno ustvarjena, ko je bila objavljena prva razprava',
	'lqt_header_warning_big' => 'Urejate $1.',
	'lqt_header_warning_after_big' => 'Glave so namenjene objavam in predgovorom.
Morda namesto tega želite $2.',
	'lqt_header_warning_bold' => 'glavo strani razprave',
	'lqt_header_warning_new_discussion' => 'začeti novo razpravo',
	'lqt_sorting_order' => 'Vrstni red',
	'lqt_sort_newest_changes' => 'zadnje spremenjene na vrh',
	'lqt_sort_newest_threads' => 'najnovejše teme na vrh',
	'lqt_sort_oldest_threads' => 'najstarejše teme na vrh',
	'lqt-title' => 'Naslov',
	'lqt-summary' => 'Povzetek',
	'lqt-searching' => 'Iskanje razprav',
	'lqt-read-message' => 'Označi kot prebrano',
	'lqt-read-message-tooltip' => 'Odstrani razpravo iz novih sporočil.
Še vedno bo vidna na svoji prvotni pogovorni strani.',
	'lqt-read-all' => 'Označi vse kot prebrano',
	'lqt-read-all-tooltip' => 'Odstranite vse razprave iz novih sporočil.
Še vedno bodo vidne na svojih prvotnih pogovornih straneh.
To operacijo je mogoče razveljaviti.',
	'lqt-marked-read' => "Razprava '''$1''' je označena kot prebrana.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|sporočilo označeno kot prebrano|sporočili označeni kot prebrani|sporočila označena kot prebrana|sporočil označenih kot prebranih}}',
	'lqt-email-undo' => 'Razveljavi',
	'lqt-no-new-messages' => 'Ni novih sporočil za vas.',
	'lqt-new-messages' => '✒ Imate nova sporočila.',
	'lqt-email-info-undo' => 'Vrni razpravo, ki ste jo pravkar odpisali.',
	'lqt-date-info' => 'Ta povezava je onemogočena, ker si ogledujete teme iz vseh dni.',
	'lqt-newmessages-context' => 'Polna razprava',
	'lqt-thread-created' => 'Ustvarjeno',
	'lqt-history-time' => 'Čas',
	'lqt-history-user' => 'Uporabnik',
	'lqt-history-action' => 'Dejavnost',
	'lqt-history-comment' => 'Komentar',
	'lqt-history-thread' => 'Razprava',
	'lqt-thread-edited-author' => 'Uredil avtor.<br />
Zadnje urejanje: $1',
	'lqt-thread-edited-others' => '{{PLURAL:$2|Uredil drug uporabnik|Uredila $2 uporabnika||Uredili $2 uporabniki|Uredilo $2 uporabnikov}}.<br />
Zadnje urejanje: $1',
	'lqt-header-actions' => 'Dejanja',
	'lqt_summarize_link' => 'Povzemi',
	'lqt-summarize-intro' => 'Prosimo, povzemite spodnjo razpravo v polje za urejanje.
V povzetku lahko uporabite katero koli wikibesedilo.
Ko končate, kliknite »{{int:savearticle}}«.',
	'lqt-thread-split' => 'Razcep na novo razpravo',
	'lqt-split-success' => 'Uspešno ste odcepili razpravo $1.',
	'lqt_split_thread' => 'Razcepi razpravo',
	'lqt-thread-split-subject' => 'Zadeva nove razprave:',
	'lqt-thread-split-thread' => 'Razprava:',
	'lqt-split-submit' => 'Razcepi',
	'lqt_split_badsubject' => 'Vnesena zadeva ni veljavna.',
	'lqt-no-threads' => 'Na tej strani še ni razprav.',
	'lqt-delete-parent-warning' => 'To je vrhnja razprava z odgovori.
Vsi njeni odgovori bodo samodejno pobrisani.
Da se temu izognete, jih pred brisanjem odcepite od razprave.',
	'lqt-delete-parent-deleted' => 'Starševska razprava je izbrisana ($1)',
	'lqt-delete-replies-done' => 'Vsi odgovori na to temo so tudi izbrisani.',
	'lqt-movethread' => 'Prestavi',
	'lqt-menu-trigger' => 'Več',
	'lqt-newmessages-from' => 'Od $1',
	'lqt-hot-topics' => 'Vroče teme',
	'lqt-add-reply' => 'Dodaj odgovor',
	'lqt_rc_new_discussion' => 'objavil novo razpravo, »$1«',
	'lqt_rc_new_reply' => 'objavil odgovor na »$1«',
	'right-lqt-split' => 'Razcep razprav',
	'right-lqt-merge' => 'Združevanje razprav',
	'right-lqt-react' => 'Odgovarjanje na razprave',
	'lqt-thread-merge' => 'Združi z drugo razpravo',
	'lqt-thread-merge-to' => 'Združi s to razpravo',
	'lqt_merge_thread' => 'Združi razprave',
	'lqt-thread-merge-source' => 'Izvorna razprava:',
	'lqt-thread-merge-dest' => 'Ciljna razprava:',
	'lqt-merge-submit' => 'Združi',
	'lqt-merge-success' => 'Uspešno ste združili razpravo $1 pod $2.',
	'lqt-log-name' => 'Dnevnik nitnih razprav',
	'lqt-log-header' => 'Ta dnevnik navaja podrobnosti dejanj, ki so bila storjena nitnim razpravam.',
	'lqt-log-action-move' => 'je prestavil(-a) [[$1]] iz [[$2]] v [[$3]]',
	'lqt-log-action-split' => 'je razcepil(-a) [[$1]] od [[$3]], z novo zadevo »$2«',
	'lqt-log-action-merge-across' => 'je prestavil(-a) [[$1]] izpod [[$2]] pod [[$3]]',
	'lqt-log-action-merge-down' => 'je združil(-a) [[$1]] pod [[$2]]',
	'lqt-log-action-subjectedit' => 'je spremenil(-a) zadevo [[$1]] iz »$2« v »$3«',
	'lqt-log-action-resort' => 'je spremenil(-a) vrsti red razvrščanja [[$1]]. Ključ razvrščanja je spremenjen iz $2 v $3',
	'lqt-preference-notify-talk' => 'Pošlji e-pošto ob odgovorih na razprave, ki jih opazujem',
	'lqt-preference-watch-threads' => 'Opazuj razprave, ki sem jih ustvaril ali nanje odgovoril',
	'prefs-lqt' => 'Povezana razprava',
	'lqt-preference-display-depth' => 'Največja prikazana globina odgovorov:',
	'lqt-preference-display-count' => 'Največje število prikazanih odgovor:',
	'lqt-preference-custom-signatures' => 'Prikaži uporabniške podpise po meri',
	'lqt-enotif-subject-reply' => 'Razprava {{SITENAME}} – Odgovor: $1',
	'lqt-enotif-subject-newthread' => 'Razprava {{SITENAME}} – Nova razprava: $1',
	'lqt-enotif-newthread' => '$1, pozdravljeni,

{{SITENAME}} vaš obvešča, da je $8 na $5
dne $3 ob $4 ustvaril(-a) novo razpravo »$2«.

Ogledate si jo lahko na <$6>

Vsebina je:
$7',
	'lqt-enotif-reply' => '$1, pozdravljeni,

{{SITENAME}} vaš obvešča, da je $8 dne $3 ob $4
odgovoril na razpravo »$2« na $5.

Odgovor si lahko ogledate na <$6>

Besedilo odgovora je:
$7',
	'lqt-quote-intro' => 'Dne $2 ob $3 je [[User:$1|$1]] napisal:',
	'lqt-quote' => 'Navedi',
	'lqt-search-legend' => 'Iskanje razprav na tej strani',
	'lqt-search-label' => 'Iskalni pojmi:',
	'lqt-search-button' => 'Iskanje',
	'searchprofile-threads' => 'Razprave',
	'searchprofile-threads-tooltip' => 'Iskanje nitnih razprav in pogovornih strani',
	'lqt-ajax-updated' => 'Ta razprava ima nove objave.',
	'lqt-ajax-update-link' => 'Posodobi',
	'lqt-thread-show-replies' => 'Prikaži $1 {{PLURAL:$1|odgovor|odgovora|odgovore|odgovorov}}',
	'lqt-thread-show-more' => 'Prikaži več odgovorov',
	'lqt-thread-link-url' => 'URL povezave:',
	'lqt-thread-link-title' => 'Povezava wikibesedila:',
	'lqt-thread-link-copy' => 'Kopiraj v odložišče',
	'lqt-sign-not-necessary' => 'Ni potrebno podpisati svoje objave s štirimi tildami.
Podpis je prikazan samodejno.',
	'lqt-marked-as-read-placeholder' => 'Razprava $1 je bila označena kot prebrana.',
	'lqt-change-subject' => 'Spremeni zadevo',
	'lqt-save-subject' => 'Shrani',
	'lqt-save-subject-failed' => 'Med poskusom spremembe zadeve te razprave je prišlo do naslednje napake: $1',
	'lqt-ajax-invalid-subject' => 'Določena zadeva ni veljavna, verjetno zato, ker je predolga.',
	'lqt-ajax-no-subject' => 'Določiti morate zadevo nove razprave.',
	'lqt-save-subject-error-unknown' => 'Med poskusom nastavljanja zadeve te razprave je prišlo do neznane napake. Prosimo, poskusite to storiti s klikom na »uredi« na vrhnji objavi.',
	'lqt-cancel-subject-edit' => 'Prekliči',
	'lqt-drag-activate' => 'Povleci na novo mesto',
	'lqt-drag-drop-zone' => 'Spusti tukaj',
	'lqt-drag-confirm' => 'Za dokončanje naslednjih dejanj, prosimo, vpišite razlog in kliknite »Potrdi«.',
	'lqt-drag-reparent' => 'Prestavi objavo pod novega starša.',
	'lqt-drag-split' => 'Prestavi objavo v svojo lastno razpravo',
	'lqt-drag-setsortkey' => 'Prilagodi položaj objave na strani',
	'lqt-drag-bump' => 'Prestavi objavo na vrh pogovorne strani',
	'lqt-drag-save' => 'Potrdi',
	'lqt-drag-title' => 'Potrdi povlek',
	'lqt-drag-reason' => 'Razlog:',
	'lqt-drag-subject' => 'Zadeva nove razprave (obvezno):',
	'lqt-edit-signature' => '(uredi podpis)',
	'lqt-preview-signature' => '(predogled)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nove objave',
	'lqt-feed-title-all-from' => '{{SITENAME}} — {{PLURAL:$2|Nova objava|Novi objavi|Nove objave}} od $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nove razprave',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — {{PLURAL:$2|Nova razprava|Novi razpravi|Nove razprave}} od $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Odgovori',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — {{PLURAL:$2|Odgovor|Odgovora|Odgovori}} od $1',
	'lqt-feed-new-thread-intro' => 'Nova razprava na $1, objavil(-a) jo je $2',
	'lqt-feed-reply-intro' => 'Odgovor na $3 (na $1), objavil(-a) ga je $2',
	'tooltip-pt-newmessages' => 'Prikaže nove objave v razpravah ali na razpravljalnih pogovornih straneh, ki jih spremljate',
	'lqt-newmessages-n' => 'Nova sporočila ($1)',
	'lqt_newmessages' => 'Moja nova sporočila (Nobena)',
	'lqt_newmessages-title' => 'Nova sporočila',
	'lqt-newpost-summary' => 'Nova razprava: $1',
	'lqt-newpost-defaultbody-user-submitted-empty-textbody' => 'Prosimo, vnesite vaše besedilo za to razpravo. Nato izbrišite to vrstico.',
	'lqt-reply-summary' => 'Odgovor na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Zgodovina strani z razpravo',
	'lqt-talkpage-history-subtitle' => 'Za $1',
	'lqt-talkpage-history-tab' => 'Glava',
	'restriction-reply' => 'Objavi odgovore',
	'restriction-newthread' => 'Objavi nove razprave',
	'lqt-protected-reply-thread' => 'V tej razpravi ne morete objavljati, ker je zaščitena pred novimi objavami.',
	'lqt-protected-reply-talkpage' => 'V tej razpravi ne morete objavljati, ker je pogovorna stran zaščitena pred odgovori na njene razprave.',
	'lqt-protected-newthread' => 'Na tej pogovorni strani ne morete objavljati novih raprav, kjer je zaščitena pred novimi razpravami.',
	'lqt-edit-bump' => 'Izpostavi razpravo',
	'lqt-edit-bump-tooltip' => 'Prestavi razpravo na vrh pogovorne strani',
	'lqt-historicalrevision-error' => 'Izbrana redakcije je poškodovana in si je ni mogoče ogledati.',
	'lqt-reply-subpage' => 'odgovor',
	'nstab-thread' => 'Razprava',
	'nstab-summary' => 'Povzetek',
);

/** Lower Silesian (Schläsch)
 * @author Timpul
 */
$messages['sli'] = array(
	'lqt_move_move' => 'Verschieba',
);

/** Somali (Soomaaliga)
 * @author Maax
 */
$messages['so'] = array(
	'lqt-search-button' => 'Raadi',
);

/** Serbian Cyrillic ekavian (‪Српски (ћирилица)‬)
 * @author Mormegil
 * @author Rancher
 * @author Жељко Тодоровић
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'lqt-desc' => 'Додаје могућност отварања тема на страницама за разговор',
	'lqt_movethread' => 'Премештање теме на другу страницу',
	'lqt_deletethread' => 'Брисање или враћање теме',
	'lqt_contents_title' => 'Садржај',
	'lqt_toc_thread_title' => 'Наслов теме',
	'lqt_toc_thread_author' => 'Започео/-ла',
	'lqt_toc_thread_replycount' => 'Одговора',
	'lqt_toc_thread_modified' => 'Последња измена',
	'lqt_add_header' => 'Додај заглавље',
	'lqt_new_thread' => 'Започни нови разговор',
	'lqt_invalid_subject' => 'Наслов који сте унели није исправан.
Разлог томе може бити:
* наслов је предугачак
* дошло је до сукоба с међувики префиксима или називима именских простора.',
	'lqt_empty_subject' => 'Морате унети наслов.',
	'lqt_reply' => 'Одговори',
	'lqt-parent' => 'Надређени',
	'lqt_delete' => 'Обриши',
	'lqt_undelete' => 'Врати',
	'lqt_permalink' => 'Веза',
	'lqt_fragment' => 'Одломак од $1 из $2',
	'lqt_discussion_link' => 'разговор',
	'lqt_from_talk' => 'Од $1',
	'lqt-history-title' => 'Историја теме',
	'lqt_hist_comment_edited' => '[$2 Измењен] је текст коментара.',
	'lqt_hist_summary_changed' => 'Сажетак је промењен.',
	'lqt_hist_reply_created' => 'Постављен је [[$1|нови одговор]].',
	'lqt_hist_thread_created' => 'Направљена је нова тема.',
	'lqt_hist_deleted' => 'Обрисано.',
	'lqt_hist_undeleted' => 'Враћено.',
	'lqt_hist_moved_talkpage' => 'Премештено.',
	'lqt_hist_listing_subtitle' => 'Прегледање историје',
	'lqt_hist_view_whole_thread' => 'Прикажи историју целе теме',
	'lqt_hist_no_revisions_error' => 'Ова тема нема ревизија у историји.',
	'lqt_hist_past_last_page_error' => 'Прекорачили сте број страница које има постојећа историја.',
	'lqt_hist_tooltip_newer_disabled' => 'Ова веза је онемогућена јер сте на првој страници.',
	'lqt_hist_tooltip_older_disabled' => 'Ова веза је онемогућена јер сте на последњој страници.',
	'lqt_hist_split' => 'Раздвоји одговор на нову тему',
	'lqt_hist_edited_subject' => 'Наслов је промењен из „$2“ у „$3“.',
	'lqt_hist_edited_subject_corrupt' => 'Наслов је промењен.',
	'lqt_hist_merged_from' => '[[$1|Одговор]] је премештен на другу тему.',
	'lqt_hist_merged_to' => '[[$1|Одговор]] је премештен с друге теме.',
	'lqt_hist_split_from' => 'Раздвоји у нову тему',
	'lqt_hist_root_blanked' => 'Текст коментара је уклоњен.',
	'lqt_hist_adjusted_sortkey' => 'Подешен је положај теме.',
	'lqt_revision_as_of' => 'Измена од $2, $3.',
	'lqt_change_new_thread' => 'Ово је прва измена теме.',
	'lqt_change_reply_created' => '[$1 Истакнути коментар] је направљен у овој измени.',
	'lqt_change_edited_root' => '[$1 Истакнути коментар] је промењен у овој измени.',
	'lqt_change_edited_summary' => 'Сажетак теме је измењен.',
	'lqt_change_deleted' => '[$1 Ова тема] или њена надређена страница је обрисана.',
	'lqt_change_undeleted' => '[$1 Истакнута порука] је враћена.',
	'lqt_change_moved' => '[$1 Ова тема] је премештена на другу страницу за разговор.',
	'lqt_change_split' => '[$1 Ова тема] је издвојена из друге теме.',
	'lqt_change_edited_subject' => 'Наслов ове теме је промењен из „$2“ у „$3“.',
	'lqt_change_merged_from' => '[$1 Одговор] с ове теме је премештен на другу тему.',
	'lqt_change_merged_to' => '[$1 Истакнути одговор] је премештен с друге теме.',
	'lqt_change_split_from' => '[$1 Подтема] ове теме је издвојена у нову тему.',
	'lqt_change_root_blanked' => 'Текст [$1 коментара] је уклоњен.',
	'lqt_youhavenewmessages' => 'Имате [[$1|нових порука]].',
	'lqt_protectedfromreply' => 'Ова тема је $1 и у њој не можете одговарати.',
	'lqt_protectedfromreply_link' => 'заштићена',
	'lqt_subject' => 'Наслов:',
	'lqt_noreason' => 'Разлог није наведен.',
	'lqt_move_placeholder' => 'Тема „$1“ је премештена одавде у $5.
Премештање {{GENDER:$2|је извршио|је извршила|изврши}} $2, $3 у $4.',
	'lqt_thread_deleted_for_sysops' => "Ова тема је '''обрисана''' и видљива је само администраторима.",
	'lqt_thread_deleted' => 'Ова тема је обрисана.',
	'lqt_summary_notice' => 'На овом разговору није било измена бар $2 {{PLURAL:$2|дан|дана|дана}}.
Ако је завршен, можете $1.',
	'lqt_summary_notice_link' => 'написати сажетак',
	'lqt_summary_label' => 'Сажетак теме:',
	'lqt_summary_subtitle' => 'Сажетак за „$1“',
	'lqt_nosuchrevision' => 'Нема такве измене ове теме.',
	'lqt_nosuchthread' => 'Тражена тема не постоји.',
	'lqt_nosuchthread_title' => 'Тема не постоји',
	'lqt_threadrequired' => 'Морате унети URL адресу теме.',
	'lqt_move_movingthread' => 'Премештање теме $1.
Она је део $2.',
	'lqt_move_torename' => 'Да бисте преименовали ову тему, $1 и промените поље за наслов.',
	'lqt_move_torename_edit' => 'уредите је',
	'lqt_move_destinationtitle' => 'Наслов одредишне странице за разговор:',
	'lqt_move_move' => 'Премести',
	'lqt_move_nodestination' => 'Морате унети одредиште.',
	'lqt_move_thread_bad_destination' => 'Одредишна страница није страница за разговор.',
	'lqt_move_samedestination' => 'Тема се већ налази на овој страници!',
	'lqt_move_noreason' => 'Разлог није наведен.',
	'lqt_move_success' => 'Тема је премештена у $1.',
	'lqt_delete_undeletethread' => 'Врати тему',
	'lqt_delete_partof' => "Ова тема је део '''$1'''.",
	'lqt_delete_deleting' => "Брисање '''$1''' и '''свих одговора'''.",
	'lqt_delete_deletethread' => 'Обриши теме и одговоре',
	'lqt_delete_deleted' => 'Тема је обрисана.',
	'lqt_delete_undeleted' => 'Тема је враћена.',
	'lqt_delete_return' => 'Повратак на $1.',
	'lqt_delete_return_link' => 'страница за разговор',
	'lqt_delete_unallowed' => 'Немате дозволу да бришете теме.',
	'lqt_delete_show_checkbox' => 'Прикажи обрисане теме',
	'lqt_talkpage_autocreate_summary' => 'Страница за разговор је самостално направљена када је прва тема постављена.',
	'lqt_header_warning_big' => 'Уређујете $1.',
	'lqt_header_warning_after_big' => 'Заглавља се користе за саопштења и предговоре.
Можда би било боље да $2.',
	'lqt_header_warning_bold' => 'заглавље странице за разговор',
	'lqt_header_warning_new_discussion' => 'започнете нови разговор',
	'lqt_sorting_order' => 'Редослед сврставања:',
	'lqt_sort_newest_changes' => 'прво најскорије измењене',
	'lqt_sort_newest_threads' => 'прво најскорије направљене',
	'lqt_sort_oldest_threads' => 'прво најстарије теме',
	'lqt-title' => 'Наслов',
	'lqt-summary' => 'Сажетак',
	'lqt-searching' => 'Тражење тема',
	'lqt-read-message' => 'Означи као прочитано',
	'lqt-read-message-tooltip' => 'Уклоните ову тему из нових порука.
Она ће још увек бити доступна на страници за разговор.',
	'lqt-read-all' => 'Означи све као прочитано',
	'lqt-read-all-tooltip' => 'Уклоните све теме из нових порука.
Оне ће још увек бити доступне на страници за разговор.
Ова радња се не може опозвати.',
	'lqt-marked-read' => 'Тема „$1“ је означена као прочитана.',
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|порука је означена као прочитана|поруке су означене као прочитане|порука је означено као прочитано}}.',
	'lqt-email-undo' => 'Опозови',
	'lqt-no-new-messages' => 'Нема нових порука.',
	'lqt-new-messages' => '✒ Имате нових порука.',
	'lqt-email-info-undo' => 'Вратите тему коју сте управо одбацили.',
	'lqt-date-info' => 'Ова веза је онемогућена јер прегледате теме из свих датума.',
	'lqt-newmessages-context' => 'Цела тема',
	'lqt-thread-created' => 'Направљено',
	'lqt-history-time' => 'Време',
	'lqt-history-user' => 'Корисник',
	'lqt-history-action' => 'Активност',
	'lqt-history-comment' => 'Коментар',
	'lqt-history-thread' => 'Тема',
	'lqt-thread-edited-author' => 'Измењено од стране аутора.<br />
Последња измена: $1',
	'lqt-thread-edited-others' => 'Измењено од стране {{PLURAL:$2|другог корисника|$2 корисника|$2 корисника}}.<br />
Последња измена: $1',
	'lqt-header-actions' => 'Радње',
	'lqt_summarize_link' => 'Сажми',
	'lqt-summarize-intro' => 'Сажмите тему путем оквира за уређивање.
Можете користити било који викитекст у сажетку.
Када завршите, кликните на „{{int:savearticle}}“.',
	'lqt-thread-split' => 'Раздвоји у нову тему',
	'lqt-split-success' => 'Успешно сте раздвојили тему $1.',
	'lqt_split_thread' => 'Раздвоји тему',
	'lqt-thread-split-subject' => 'Наслов нове теме:',
	'lqt-thread-split-thread' => 'Тема:',
	'lqt-split-submit' => 'Раздвоји',
	'lqt_split_badsubject' => 'Наслов је неисправан.',
	'lqt-no-threads' => 'Још увек нема тема на овој страници.',
	'lqt-delete-parent-warning' => 'Ово је тема највећег нивоа с одговорима.
Њени одговори биће самостално обрисани.
Да бисте ово избегли, раздвојте их с ове теме пре брисања.',
	'lqt-delete-parent-deleted' => 'Надређена тема је обрисана ($1).',
	'lqt-delete-replies-done' => 'Сви одговори на овој теми су обрисани.',
	'lqt-movethread' => 'Премести',
	'lqt-menu-trigger' => 'Више',
	'lqt-newmessages-from' => 'Од $1',
	'lqt-hot-topics' => 'Вруће теме',
	'lqt-add-reply' => 'Додај одговор',
	'lqt_rc_new_discussion' => '{{GENDER:|је поставио|је поставила|постави}} нову тему, „$1“',
	'lqt_rc_new_reply' => '{{GENDER:|је поставио|је поставила|постави}} одговор на „$1“',
	'right-lqt-split' => 'раздвајање тема',
	'right-lqt-merge' => 'спајање тема',
	'lqt-thread-merge' => 'Споји с другом темом',
	'lqt-thread-merge-to' => 'Споји у ову тему',
	'lqt_merge_thread' => 'Споји тему',
	'lqt-thread-merge-source' => 'Изворна тема:',
	'lqt-thread-merge-dest' => 'Одредишна тема:',
	'lqt-merge-submit' => 'Споји',
	'lqt-merge-success' => 'Успешно сте спојили тему $1 са $2.',
	'lqt-log-name' => 'Извештај разговора на темама',
	'lqt-log-header' => 'Овај извештај описује радње које су извршене на темама.',
	'lqt-log-action-move' => '{{GENDER:|је преместио|је преместила|премести}} [[$1]] из [[$2]] у [[$3]]',
	'lqt-log-action-split' => '{{GENDER:|је раздвојио|је раздвојила|раздвоји}} [[$1]] из [[$3]], с новим насловом „$2“',
	'lqt-log-action-merge-across' => '{{GENDER:|је преместио|је преместила|премести}} [[$1]] из [[$2]] у [[$3]]',
	'lqt-log-action-merge-down' => '{{GENDER:|је спојио|је спојила|споји}} [[$1]] са [[$3]]',
	'lqt-log-action-subjectedit' => '{{GENDER:|је променио|је променила|промени}} наслов [[$1]] из „$2“ у „$3“',
	'lqt-log-action-resort' => '{{GENDER:|је променио|је променила|промени}} редослед сврставања [[$1]]. Кључ сврставања је промењен из $2 у $3',
	'lqt-preference-notify-talk' => 'Пошаљи ми е-поруку када се промени тема коју надгледам',
	'lqt-preference-watch-threads' => 'Додај теме које изменим у списак надгледања',
	'prefs-lqt' => 'Разговори на темама',
	'lqt-preference-display-depth' => 'Највећи низ одговора:',
	'lqt-preference-display-count' => 'Највећи број одговора:',
	'lqt-preference-custom-signatures' => 'Прикажи корисничке потписе',
	'lqt-enotif-subject-reply' => '{{SITENAME}} разговор – одговор: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} разговор – нова тема: $1',
	'lqt-enotif-newthread' => 'Здраво, $1,

Ово је обавештење са {{SITENAME}} да је нова тема на $5, „$2“,
направљена $3 у $4 од стране члана $8.

Можете је погледати на $6

Текст поруке гласи:
$7',
	'lqt-enotif-reply' => 'Здраво, $1,

Ово је обавештење са {{SITENAME}} да је нова тема на $5, „$2“,
направљена $3 у $4 од стране члана $8.

Можете је погледати на $6

Текст поруке гласи:
$7',
	'lqt-quote-intro' => '$2 у $3, [[User:$1|$1]] {{GENDER:$1|је написао|је написала|написа}}:',
	'lqt-quote' => 'Цитат',
	'lqt-search-legend' => 'Претражи расправе на овој страници',
	'lqt-search-label' => 'Упити претраге:',
	'lqt-search-button' => 'Претражи',
	'searchprofile-threads' => 'Разговори',
	'searchprofile-threads-tooltip' => 'Претражите расправе на темама и странице за разговор',
	'lqt-ajax-updated' => 'Ова тема има нових порука.',
	'lqt-ajax-update-link' => 'Ажурирај',
	'lqt-thread-show-replies' => 'Прикажи $1 {{PLURAL:$1|одговор|одговора|одговора}}',
	'lqt-thread-show-more' => 'Прикажи више одговора',
	'lqt-thread-link-url' => 'Адреса везе:',
	'lqt-thread-link-title' => 'Веза викитекста:',
	'lqt-thread-link-copy' => 'Умножи',
	'lqt-sign-not-necessary' => 'Није неопходно да се потпишете.
Потпис је аутоматски приказан.',
	'lqt-marked-as-read-placeholder' => 'Тема „$1“ је означена као прочитана.',
	'lqt-change-subject' => 'Измени наслов',
	'lqt-save-subject' => 'Сачувај',
	'lqt-save-subject-failed' => 'Дошло је до следеће грешке при мењању наслова теме: $1',
	'lqt-ajax-invalid-subject' => 'Наслов који сте унели није исправан. Пробајте да га скратите.',
	'lqt-ajax-no-subject' => 'Морате унети наслов.',
	'lqt-save-subject-error-unknown' => 'Дошло је до непознате грешке при постављању наслова теме. Покушајте да извршите ову радњу кликом на дугме „уреди“.',
	'lqt-cancel-subject-edit' => 'Откажи',
	'lqt-drag-activate' => 'Превуци',
	'lqt-drag-drop-zone' => 'Испустите овде',
	'lqt-drag-confirm' => 'Да бисте завршили следеће радње, унесите разлог и кликните на „Потврди“.',
	'lqt-drag-reparent' => 'Премести поруку испод надређене.',
	'lqt-drag-split' => 'Премести поруку у нову тему',
	'lqt-drag-setsortkey' => 'Подеси положај поруке на страници',
	'lqt-drag-bump' => 'Премести поруку на врх странице за разговор',
	'lqt-drag-save' => 'Потврди',
	'lqt-drag-title' => 'Потврди превлачење',
	'lqt-drag-reason' => 'Разлог:',
	'lqt-drag-subject' => 'Наслов нове теме:',
	'lqt-edit-signature' => '(измени потпис)',
	'lqt-preview-signature' => '(преглед)',
	'lqt-feed-title-all' => '{{SITENAME}} – нове поруке',
	'lqt-feed-title-all-from' => '{{SITENAME}} – нове поруке од $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} – нове теме',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} – нове теме од $1',
	'lqt-feed-title-replies' => '{{SITENAME}} – одговори',
	'lqt-feed-title-replies-from' => '{{SITENAME}} – одговори од $1',
	'lqt-feed-new-thread-intro' => 'Нова тема на $1 је постављена од члана $2',
	'lqt-feed-reply-intro' => 'Одговор на $3 ($1) је постављен од члана $2',
	'tooltip-pt-newmessages' => 'Приказује нове поруке на темама или на страницама за разговор које пратите',
	'lqt-newmessages-n' => 'Нове поруке ($1)',
	'lqt_newmessages' => 'Поруке',
	'lqt_newmessages-title' => 'Поруке',
	'lqt-newpost-summary' => 'Нова тема: $1',
	'lqt-reply-summary' => 'Одговор на [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Историја странице за разговор',
	'lqt-talkpage-history-subtitle' => 'За $1',
	'lqt-talkpage-history-tab' => 'Заглавље',
	'restriction-reply' => 'Постављање одговора',
	'restriction-newthread' => 'Постављање нових тема',
	'lqt-protected-reply-thread' => 'Не можете постављати поруке на ову тему јер је она заштићена.',
	'lqt-protected-reply-talkpage' => 'Не можете постављати поруке на ову тему јер је страница за разговор заштићена.',
	'lqt-protected-newthread' => 'Не можете постављати нове теме на ову страницу за разговор јер је она заштићена.',
	'lqt-edit-bump' => 'Оживи ову тему',
	'lqt-edit-bump-tooltip' => 'Премести ову тему на врх странице за разговор',
	'lqt-historicalrevision-error' => 'Измена коју сте изабрали је оштећена и не може бити приказана.',
	'lqt-reply-subpage' => 'одговор',
	'nstab-thread' => 'Тема',
	'nstab-summary' => 'Сажетак',
);

/** Serbian Latin ekavian (‪Srpski (latinica)‬)
 * @author Michaello
 * @author Mormegil
 * @author Rancher
 * @author Жељко Тодоровић
 * @author Михајло Анђелковић
 */
$messages['sr-el'] = array(
	'lqt-desc' => 'Dodaje mogućnost otvaranja tema na stranicama za razgovor',
	'lqt_movethread' => 'Premesti temu na drugu stranu',
	'lqt_deletethread' => 'Obriši ili vrati temu',
	'lqt_contents_title' => 'Sadržaj',
	'lqt_toc_thread_title' => 'Naslov teme',
	'lqt_toc_thread_author' => 'Započeo/la',
	'lqt_toc_thread_replycount' => 'Odgovori',
	'lqt_toc_thread_modified' => 'Poslednja izmena',
	'lqt_add_header' => 'Dodaj zaglavlje',
	'lqt_new_thread' => 'Započni novi razgovor',
	'lqt_invalid_subject' => 'Naslov koji ste zadali je neispravan.
Razlog za ovo može biti:
* To što je predugačak, ili
* To što je u sukobu sa međuviki prefiksima ili nazivima imenskih prostora.',
	'lqt_empty_subject' => 'Morate da unesete naslov.',
	'lqt_reply' => 'Odgovor',
	'lqt-parent' => 'Roditelj',
	'lqt_delete' => 'Obriši',
	'lqt_undelete' => 'Vrati',
	'lqt_permalink' => 'Veza ka',
	'lqt_fragment' => 'Fragment od $1 iz $2',
	'lqt_discussion_link' => 'razgovor',
	'lqt_from_talk' => 'Od $1',
	'lqt-history-title' => 'Istorija teme',
	'lqt_hist_comment_edited' => '[$2 Izmenjen] je tekst komentara',
	'lqt_hist_summary_changed' => 'Sažetak promenjen',
	'lqt_hist_reply_created' => '[[$1|Novi odgovor]] poslat',
	'lqt_hist_thread_created' => 'Nova tema napravljena',
	'lqt_hist_deleted' => 'Obrisano',
	'lqt_hist_undeleted' => 'Vraćeno',
	'lqt_hist_moved_talkpage' => 'Premešteno',
	'lqt_hist_listing_subtitle' => 'Pregleda istoriju',
	'lqt_hist_view_whole_thread' => 'Vidi istoriju cele teme',
	'lqt_hist_no_revisions_error' => 'Ova tema nema revizija u istoriji.',
	'lqt_hist_past_last_page_error' => 'Prekoračili ste broj strana koje ima postojeća istorija.',
	'lqt_hist_tooltip_newer_disabled' => 'Ova veza je onemogućena jer ste na prvoj strani.',
	'lqt_hist_tooltip_older_disabled' => 'Ova veza je onemogućena jer ste na zadnjoj strani.',
	'lqt_hist_edited_subject' => 'Naslov promenjen sa "$2" na "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Naslov promenjen',
	'lqt_hist_merged_from' => '[[$1|Odgovor]] je premešten na drugu temu',
	'lqt_hist_merged_to' => '[[$1|Odgovor]] je premešten sa druge teme',
	'lqt_hist_split_from' => 'Razdvoj u novu temu',
	'lqt_hist_adjusted_sortkey' => 'Podešeno je mesto teme',
	'lqt_revision_as_of' => 'Revizija od $2 u $3.',
	'lqt_change_new_thread' => 'Ovo je prva revizija teme.',
	'lqt_change_reply_created' => '[$1 Označeni komentar] je napravljen u ovoj reviziji.',
	'lqt_change_edited_root' => '[$1 Označeni komentar] je izmenjen u ovoj reviziji.',
	'lqt_change_edited_summary' => 'Sažetak teme je izmenjen',
	'lqt_change_deleted' => '[$1 Ova tema] ili njena nadstrana je obrisana',
	'lqt_change_undeleted' => '[$1 Označena poruka] je vraćena',
	'lqt_change_moved' => '[$1 Ova tema] je premeštena na drugu stranu za razgovor',
	'lqt_change_split' => '[$1 Ova tema] je izdvojena iz druge teme',
	'lqt_change_edited_subject' => 'Naslov ove teme je promenjen sa "$2" na "$3"',
	'lqt_change_merged_from' => '[$1 Odgovor] sa ove teme je premešten na drugu temu',
	'lqt_change_merged_to' => '[$1 Označena poruka] je ovde premeštena sa neke druge teme',
	'lqt_change_root_blanked' => 'Tekst [$1 jednog komentara] je obrisan.',
	'lqt_youhavenewmessages' => 'Imate [[$1|novih poruka]].',
	'lqt_protectedfromreply_link' => 'zaštićeno',
	'lqt_subject' => 'Naslov:',
	'lqt_noreason' => 'Nije dat razlog.',
	'lqt_summary_notice_link' => 'napišite sažetak',
	'lqt_summary_label' => 'Sažetak teme:',
	'lqt_summary_subtitle' => 'Sažetak za "$1"',
	'lqt_nosuchrevision' => 'Nema takve revizije ove teme.',
	'lqt_nosuchthread' => 'Tema koju ste naveli ne postoji.',
	'lqt_nosuchthread_title' => 'Nema takve teme',
	'lqt_move_movingthread' => 'Premeštam $1.
Ova tema je deo $2.',
	'lqt_move_torename_edit' => 'izmeni ga',
	'lqt_move_move' => 'Premesti',
	'lqt_move_noreason' => 'Nije dat razlog.',
	'lqt_delete_undeletethread' => 'Vrati temu',
	'lqt_delete_deletethread' => 'Obriši teme i odgovore',
	'lqt_delete_deleted' => 'Tema je obrisana.',
	'lqt_delete_undeleted' => 'Tema je vraćena.',
	'lqt_delete_return' => 'Povratak na $1.',
	'lqt_delete_return_link' => 'strana za razgovor',
	'lqt_delete_show_checkbox' => 'Prikaži obrisane teme',
	'lqt_header_warning_big' => 'Vi menjate $1.',
	'lqt_header_warning_bold' => 'zaglavlje strane rasprave',
	'lqt_header_warning_new_discussion' => 'započni novi razgovor',
	'lqt_sorting_order' => 'Redosled sortiranja:',
	'lqt_sort_newest_changes' => 'prvo najskorije izmenjene',
	'lqt_sort_newest_threads' => 'prvo najskorije napravljene',
	'lqt_sort_oldest_threads' => 'prvo najstarije teme',
	'lqt-title' => 'Naslov',
	'lqt-summary' => 'Sažetak',
	'lqt-read-message' => 'Označi kao pročitano',
	'lqt-read-all' => 'Označi sve kao pročitano',
	'lqt-marked-read' => "Tema '''$1''' je označena kao pročitana.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|poruka označena kao pročitana|poruka označenih kao pročitane}}.',
	'lqt-email-undo' => 'Vrati',
	'lqt-newmessages-context' => 'Cela tema',
	'lqt-thread-created' => 'Napravljeno',
	'lqt-history-time' => 'Vreme',
	'lqt-history-user' => 'Korisnik',
	'lqt-history-action' => 'Aktivnost',
	'lqt-history-comment' => 'Komentar',
	'lqt-history-thread' => 'Tema',
	'lqt-thread-edited-author' => 'Izmenio autor.<br />
Poslednja izmena: $1',
	'lqt-header-actions' => 'Radnje',
	'lqt-split-success' => 'Uspešno ste podelili temu $1.',
	'lqt_split_thread' => 'Podeli temu',
	'lqt-thread-split-subject' => 'Naslov nove teme:',
	'lqt-thread-split-thread' => 'Tema:',
	'lqt-split-submit' => 'Podeli',
	'lqt-movethread' => 'Premesti',
	'lqt-menu-trigger' => 'Više',
	'lqt-newmessages-from' => 'Od $1',
	'lqt-add-reply' => 'Dodaj odgovor',
	'lqt_rc_new_discussion' => 'postavljena nova tema, "$1"',
	'lqt_rc_new_reply' => 'poslat novi odgovor na "$1"',
	'right-lqt-split' => 'Razdvoji teme',
	'right-lqt-merge' => 'Spoji teme',
	'lqt-thread-merge' => 'Spoji sa drugom temom',
	'lqt-thread-merge-to' => 'Spoji u ovu temu',
	'lqt_merge_thread' => 'Spoji temu',
	'lqt-thread-merge-source' => 'Izvorna tema:',
	'lqt-thread-merge-dest' => 'Ciljana tema:',
	'lqt-merge-submit' => 'Spoji',
	'lqt-merge-success' => 'Uspešno ste spojili temu $1 sa $2.',
	'lqt-log-action-move' => 'moved [[$1]] from [[$2]] to [[$3]]
premeštena [[$1]] sa [[$2]] na [[$3]]',
	'lqt-log-action-split' => 'split [[$1]] from under [[$3]], with the new subject "$2"
podeljena [[$1]] sa [[$3]], s novim naslovom "$2"',
	'lqt-log-action-merge-across' => 'moved [[$1]] from under [[$2]] to under [[$3]]
premeštena [[$1]] sa [[$2]] na [[$3]]',
	'lqt-log-action-merge-down' => 'spojena [[$1]] sa [[$3]]',
	'lqt-log-action-subjectedit' => '{{GENDER:|je promenio|je promenila|promeni}} naslov [[$1]] iz „$2“ u „$3“',
	'lqt-log-action-resort' => 'promenjen je redosled sortiranja od [[$1]]. Ključ sortiranja promenjen sa $2 na $3',
	'lqt-preference-custom-signatures' => 'Pokaži podesive korisničke potpise',
	'lqt-enotif-subject-reply' => '{{SITENAME}} razgovor - Odgovor: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} razgovor - Nova tema: $1',
	'lqt-quote' => 'Citat',
	'lqt-search-label' => 'Uslovi pretrage:',
	'lqt-search-button' => 'Pretraga',
	'searchprofile-threads' => 'Razgovori',
	'lqt-ajax-updated' => 'Ova tema ima novih poruka.',
	'lqt-ajax-update-link' => 'Ažuriraj',
	'lqt-thread-show-replies' => 'Pokaži $1 {{PLURAL:$1|odgovor|odgovora}}',
	'lqt-thread-show-more' => 'Prikaži više odgovora',
	'lqt-thread-link-url' => 'Putanja veze (URL):',
	'lqt-thread-link-copy' => 'Iskopiraj u klipbord',
	'lqt-change-subject' => 'Izmeni naslov',
	'lqt-save-subject' => 'Snimi',
	'lqt-ajax-no-subject' => 'Morate navesti naslov.',
	'lqt-cancel-subject-edit' => 'Otkaži',
	'lqt-drag-activate' => 'Prevuci',
	'lqt-drag-drop-zone' => 'Ispusti ovde',
	'lqt-drag-save' => 'Potvrdi',
	'lqt-drag-reason' => 'Razlog:',
	'lqt-drag-subject' => 'Naslov nove teme:',
	'lqt-edit-signature' => '(izmeni potpis)',
	'lqt-preview-signature' => '(pregled)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nove poruke',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nove poruke od $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nove teme',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nove teme od $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Odgovori',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Odgovori od $1',
	'lqt-feed-new-thread-intro' => 'Nove teme na $1 postavljene od $2',
	'lqt-feed-reply-intro' => 'Odgovor na $3 (na $1) poslat od $2',
	'lqt-newmessages-n' => 'Nove poruke ($1)',
	'lqt_newmessages' => 'Nove poruke',
	'lqt_newmessages-title' => 'Nove poruke',
	'lqt-newpost-summary' => 'Nova tema: $1',
	'lqt-reply-summary' => 'Odgovor na [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Istorija strane za razgovor',
	'lqt-talkpage-history-subtitle' => 'Za $1',
	'lqt-talkpage-history-tab' => 'Zaglavlje',
	'restriction-reply' => 'Slanje odgovora',
	'restriction-newthread' => 'Postavljanje novih tema',
	'lqt-historicalrevision-error' => 'Revizija koju ste izabrali je korumpirana, i ne može biti prikazana.',
	'lqt-reply-subpage' => 'odgovori',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'lqt-desc' => 'Ferweendenge fon Theme ap Diskussionssieden',
	'lqt_movethread' => 'Ferschuuwe Diskussionsstrang ap ne uur Siede',
	'lqt_deletethread' => 'Läsk Diskussionsstrang of staal ju wier häär',
	'lqt_contents_title' => 'Inhoold',
	'lqt_toc_thread_title' => 'Beträf',
	'lqt_toc_thread_author' => 'Eepenmoaked fon',
	'lqt_toc_thread_modified' => 'Toulääst annerd',
	'lqt_add_header' => 'Uurschrift touföigje',
	'lqt_new_thread' => 'Fang ne näie Diskussion oun',
	'lqt_invalid_subject' => 'Die Beträf, dán du ienroat hääst, is nit gultich.
Dät is muugelk, dät hie
* tou loang is of
* in Konflikt mäd Interwikipräfixe of Noomensruumbeteekengen stoant.',
	'lqt_empty_subject' => 'Du moast n Beträf ienreeke.',
	'lqt_reply' => 'Oantwoudje',
	'lqt-parent' => 'buppe-oardende Oantwoud',
	'lqt_delete' => 'Läskje',
	'lqt_undelete' => 'Wierhäärstaale',
	'lqt_permalink' => 'Hierwai ferwiese',
	'lqt_fragment' => 'Paat fon n $1 fon $2',
	'lqt_discussion_link' => 'Diskussion',
	'lqt_from_talk' => 'Uut $1',
	'lqt_hist_comment_edited' => 'Kommentoartext [$2 beoarbaided]',
	'lqt_hist_summary_changed' => 'Touhoopefoatenge annerd',
	'lqt_hist_reply_created' => '[[$1|Näie Oantwoud]] moaked',
	'lqt_hist_thread_created' => 'Näien Diskussionsstrang moaked',
	'lqt_hist_deleted' => 'Läsked',
	'lqt_hist_undeleted' => 'wierhäärstoald',
	'lqt_hist_moved_talkpage' => 'ferschäuwen',
	'lqt_hist_listing_subtitle' => 'Bekiekjen fon ne Versionsgeschichte',
	'lqt_hist_view_whole_thread' => 'Versonsgeschichte fon n gansen Diskussionsstrang bekiekje',
	'lqt_hist_no_revisions_error' => 'Dissen Diskussionsstrang häd neen Versionsgeschichte.',
	'lqt_hist_past_last_page_error' => 'Du bäst buute dät Siedenberäk fon ju Versionsgeschichte.',
	'lqt_hist_tooltip_newer_disabled' => 'Disse Ferbiendenge is deaktivierd, deeruum dät du ap ju eerste Siede bäst.',
	'lqt_hist_tooltip_older_disabled' => 'Disse Ferbiendenge is deaktivierd, deeruum dät du ap ju lääste Siede bäst.',
	'lqt_hist_split' => 'Oantwoud wuud ap n näi Thema apdeeld',
	'lqt_hist_edited_subject' => 'Die Beträf wuud fon "$2" tou "$3"annerd',
	'lqt_hist_merged_from' => 'Ju [[$1|Oantwoud]] wuud ätter n uur Thema ferschäuwen',
	'lqt_hist_merged_to' => 'Ju [[$1|Oantwoud]] wuud uut n uur Thema ferschäuwen',
	'lqt_hist_root_blanked' => 'Wächhoalden Kommentoar',
	'lqt_hist_adjusted_sortkey' => 'Anpaasede Threadposition',
	'lqt_revision_as_of' => 'Versionsgeschichte fon dän $2 uum $3 Uure.',
	'lqt_change_new_thread' => 'Dit is ju eerste Version fon dät Diskussionsthema.',
	'lqt_change_reply_created' => 'Die [$1 fatdrukte Kommentoar] wuud in disse Version moaked.',
	'lqt_change_edited_root' => 'Die [$1 fat drukte Kommentoar] wuud in disse Version beoarbaided.',
	'lqt_change_edited_summary' => 'Ju Touhoopefoatenge fon dit Thema wuud beoarbaided',
	'lqt_change_deleted' => '[$1 Dissen] of n uuroardenden Biedraach wuud läsked',
	'lqt_change_split' => '[$1 Dit Thema] wuud uut n uur Thema outränd',
	'lqt_change_edited_subject' => 'Die Beträf fon dit Thema wuud fon "$2"tou "$3" annerd',
	'lqt_change_split_from' => 'N [$1 Deel] fon dit Thema wuud as oain Thema uutleegerd',
	'lqt_change_root_blanked' => 'Die Text [$1 fon n Kommentoar] wuud wächhoald.',
	'lqt_move_placeholder' => 'Dissen Biedraach is  n Steedehoolder uum antouwiesen, dät dát Thema ap n uur Diskussionssiede ferschäuwen wuude.
Disse Ferschuuwenge waas däin fon $2 ap n $3 uum $4 Uure. Dät Thema fint sik nuu ap ju Siede $5.',
	'lqt_thread_deleted_for_sysops' => "Dit Diskussionsthema wuud '''läsked''' un is bloot foar Administratore tou sjoon.",
	'lqt-thread-split-thread' => 'Thema:',
	'lqt-split-submit' => 'Deele',
	'lqt-delete-parent-warning' => 'Dit is n Thema ap hoochste Ieuwene mäd Oantwoude.
Uk sien Oantwoude wäide automatisk läsked.
Uum dit tou fermieden, deel do fon dit Thema ou, eer du et läskest.',
	'lqt-delete-parent-deleted' => 'Die uuroardende Diskussionsstrang wuud läsked ($1)',
	'lqt-movethread' => 'Ferschuuwe',
	'lqt-menu-trigger' => 'Moor',
	'lqt-newmessages-from' => 'Uut $1',
	'lqt_rc_new_reply' => 'Oantwoud ap "$1',
	'right-lqt-split' => '"Thema deele',
	'lqt-thread-merge-to' => 'Mäd dissen Diskussionsstrang touhoopefiere',
	'lqt_merge_thread' => 'Diskussione touhoopefiere',
	'lqt-merge-submit' => 'Touhoopefiere',
	'lqt-merge-success' => 'Dät Thema $1 wuud mäd Ärfoulch mäd $2 touhoopefierd.',
	'lqt-log-action-move' => 'häd [[$1]] fon [[$2]] ätter [[$3]] ferschäuwen',
	'lqt-log-action-split' => 'trände [[$1]] fon [[$3]] ou, näien Beträf is "$2"',
	'lqt-log-action-subjectedit' => 'annerde dän Beträf fon [[$1]] fon "$2" ap "$3"',
	'lqt-log-action-resort' => 'ferannerde dän Sortierkoai fon [[$1]]. Sortierkoai annerd fon $2 ätter $3',
	'lqt_newmessages' => 'Näie Ättergjuchte',
);

/** Sundanese (Basa Sunda)
 * @author Irwangatot
 */
$messages['su'] = array(
	'lqt_contents_title' => 'Eusi',
	'lqt_reply' => 'Balesan',
	'lqt_delete' => 'Hapus',
	'lqt_hist_deleted' => 'Hapus',
	'lqt_hist_moved_talkpage' => 'Pindah',
	'lqt_move_move' => 'Pindah',
	'lqt_move_noreason' => 'Henteu di béré alesan.',
	'lqt_delete_return' => 'Balik deui ka $1.',
	'lqt_header_warning_big' => 'Anjeun keur ngédit $1',
	'lqt_newmessages' => 'Talatah anyar',
);

/** Swedish (Svenska)
 * @author Ainali
 * @author Boivie
 * @author Cohan
 * @author Dafer45
 * @author Fluff
 * @author GameOn
 * @author Jon Harald Søby
 * @author Lejonel
 * @author M.M.S.
 * @author Najami
 * @author Per
 * @author Rotsee
 * @author Sertion
 * @author Skalman
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'lqt-desc' => 'Lägger till trådade diskussioner till diskussionssidor',
	'lqt_movethread' => 'Flytta diskussionstråd till en annan sida',
	'lqt_deletethread' => 'Radera eller återställ diskussionstråd',
	'lqt_contents_title' => 'Innehåll',
	'lqt_toc_thread_title' => 'Trådnamn',
	'lqt_toc_thread_author' => 'Startad av',
	'lqt_toc_thread_replycount' => 'Svar',
	'lqt_toc_thread_modified' => 'Senast ändrad',
	'lqt_add_header' => 'Lägg till rubrik',
	'lqt_new_thread' => 'Starta en ny diskussion',
	'lqt_invalid_subject' => 'Ämnet du angivit är oglitigt
Det kan bero på att:
* namnet är för långt, eller att
* det sammanfaller med ett interwiki-prefix eller namnrymndsnamn.',
	'lqt_empty_subject' => 'Du måste ange ett ämne.',
	'lqt_reply' => 'Svara',
	'lqt-parent' => 'Förälder',
	'lqt_delete' => 'Radera',
	'lqt_undelete' => 'Återupprätta',
	'lqt_permalink' => 'Länk till detta',
	'lqt_fragment' => 'Fragment av en $1 från $2',
	'lqt_discussion_link' => 'diskussion',
	'lqt_from_talk' => 'Från $1',
	'lqt-history-title' => 'Trådhistorik',
	'lqt_hist_comment_edited' => 'Kommentartext [$2 redigerad]',
	'lqt_hist_summary_changed' => 'Sammanfattning ändrad',
	'lqt_hist_reply_created' => '[[$1|Nytt svar]] skapat',
	'lqt_hist_thread_created' => 'Ny diskussionssida skapad',
	'lqt_hist_deleted' => 'Raderad',
	'lqt_hist_undeleted' => 'Återupprättad',
	'lqt_hist_moved_talkpage' => 'Flyttad',
	'lqt_hist_listing_subtitle' => 'Visar en historiklista',
	'lqt_hist_view_whole_thread' => 'Se historiken för hela diskussionssidan',
	'lqt_hist_no_revisions_error' => 'Den här diskussionssidan har ingen versionshistorik.',
	'lqt_hist_past_last_page_error' => 'Det finns inga fler sidor med historik.',
	'lqt_hist_tooltip_newer_disabled' => 'Den här länken är avaktiverad för du är på den första sidan.',
	'lqt_hist_tooltip_older_disabled' => 'Den här länken är avaktiverad för att du är på den sista sidan.',
	'lqt_hist_split' => 'Svaret delat till en ny tråd',
	'lqt_hist_edited_subject' => 'Ändrade ämne från "$2" till "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Ändrade ämne',
	'lqt_hist_merged_from' => '[[$1|Svar]] flyttat till en annan tråd',
	'lqt_hist_merged_to' => '[[$1|Svar]] flyttat från en annan tråd',
	'lqt_hist_split_from' => 'Dela av till en ny tråd',
	'lqt_hist_root_blanked' => 'Tog bort kommentartext',
	'lqt_hist_adjusted_sortkey' => 'Justerade trådposition',
	'lqt_revision_as_of' => 'Version från $2 vid $3.',
	'lqt_change_new_thread' => 'Detta är diskussionssidans första version.',
	'lqt_change_reply_created' => 'Den [$1 markerade kommentaren] skapades i denna version.',
	'lqt_change_edited_root' => 'Den [$1 markerade kommentaren] redigerades i denna version.',
	'lqt_change_edited_summary' => 'Trådens sammanfattning har redigerats',
	'lqt_change_deleted' => '[$1 Denna tråd] eller dess förälder har raderats',
	'lqt_change_undeleted' => 'Det [$1 markerade inlägget] återställdes',
	'lqt_change_moved' => '[$1 Denna tråd] flyttades till en annan diskussionssida',
	'lqt_change_split' => '[$1 Denna tråd] delades av från en annan tråd',
	'lqt_change_edited_subject' => 'Ämnet för denna tråd ändrades från "$2" till "$3"',
	'lqt_change_merged_from' => '[$1 Ett svar] till den här tråden flyttades till en annan tråd',
	'lqt_change_merged_to' => '[$1 Det markerade svaret] flyttades från en annan tråd',
	'lqt_change_split_from' => 'En [$1 undertråd] till den här tråden delades av till en egen tråd',
	'lqt_change_root_blanked' => 'Texten för [$1 en kommentar] togs bort.',
	'lqt_youhavenewmessages' => 'Du har [[$1|nya meddelanden]].',
	'lqt_protectedfromreply' => 'Den här diskussionssidan har blivit $1 för svar.',
	'lqt_protectedfromreply_link' => 'skyddad',
	'lqt_subject' => 'Ämne:',
	'lqt_noreason' => 'Ingen anledning given.',
	'lqt_move_placeholder' => 'Denna tråd finns för att visa att en tråd, $1, flyttades från denna sida.
Denna flyttning gjordes av $2 $3 $4.
Tråden finns nu på $5.',
	'lqt_thread_deleted_for_sysops' => "Denna tråd har '''raderats''' och är endast synlig för administratörer.",
	'lqt_thread_deleted' => 'Den här diskussionssidan har blivit raderad.',
	'lqt_summary_notice' => 'Den här diskussionen har inte ändrats på minst $2 {{PLURAL:$2|dag|dagar}}.
Om den är avslutad, vill du kanske $1.',
	'lqt_summary_notice_link' => 'skriva en sammanfattning',
	'lqt_summary_label' => 'Diskussionssammanfattning:',
	'lqt_summary_subtitle' => 'Sammanfattning av "$1"',
	'lqt_nosuchrevision' => 'Det finns ingen sådan version av den här diskussionssidan.',
	'lqt_nosuchthread' => 'Tråden du angav finns inte.',
	'lqt_nosuchthread_title' => 'Tråden finns ej',
	'lqt_threadrequired' => 'Du måste ange en diskussionssida i URL-en.',
	'lqt_move_movingthread' => 'Flyttar $1. Den här diskussionssidan är en del av $2.',
	'lqt_move_torename' => 'För att döpa om den här diskussionssidan, $1 och ändra "Ämne"-fältet.',
	'lqt_move_torename_edit' => 'redigera den',
	'lqt_move_destinationtitle' => 'Titel på måldiskussionssida:',
	'lqt_move_move' => 'Flytta',
	'lqt_move_nodestination' => 'Du måste ange ett mål.',
	'lqt_move_thread_bad_destination' => 'Målsidan är ingen diskussionssida.',
	'lqt_move_samedestination' => 'Tråden visas redan på denna sida!',
	'lqt_move_noreason' => 'Ingen anledning given.',
	'lqt_move_success' => 'Den här diskussionssidan flyttades till $1.',
	'lqt_delete_undeletethread' => 'Återupprätta diskussionssida',
	'lqt_delete_partof' => "Denna tråd är en del av '''$1'''.",
	'lqt_delete_deleting' => "Raderar '''$1''' och '''alla svar''' på den.",
	'lqt_delete_deletethread' => 'Radera diskussionssida och svar',
	'lqt_delete_deleted' => 'Diskussionssidan raderades.',
	'lqt_delete_undeleted' => 'Diskussionssidan återupprättades.',
	'lqt_delete_return' => 'Tillbaka till $1.',
	'lqt_delete_return_link' => 'diskussionssidan',
	'lqt_delete_unallowed' => 'Du är inte tillåten att radera diskussionssidor.',
	'lqt_delete_show_checkbox' => 'Visa raderade trådar',
	'lqt_talkpage_autocreate_summary' => 'Diskussionssida upprättades automatiskt när första diskussionssidan postades.',
	'lqt_header_warning_big' => 'Du redigerar en $1.',
	'lqt_header_warning_after_big' => 'Huvudsektioner är för annonseringar och inledningar.
Du vill kanske $2 istället.',
	'lqt_header_warning_bold' => 'diskussionssidsinledning',
	'lqt_header_warning_new_discussion' => 'starta en ny diskussion',
	'lqt_sorting_order' => 'Sorteringsföljd:',
	'lqt_sort_newest_changes' => 'senast ändrade först',
	'lqt_sort_newest_threads' => 'nyaste diskussionssidor först',
	'lqt_sort_oldest_threads' => 'äldsta diskussionssidor först',
	'lqt-title' => 'Titel',
	'lqt-summary' => 'Sammanfattning',
	'lqt-searching' => 'Sök efter trådar',
	'lqt-read-message' => 'Markera som läst',
	'lqt-read-message-tooltip' => 'Ta bort den här tråden från nya meddelanden.
Den kommer fortfarande att visas på dens orginala diskussionssida.',
	'lqt-read-all' => 'Markera alla som lästa',
	'lqt-read-all-tooltip' => 'Ta bort alla trådar från nya meddelanden.
De kommer fortfarande att vara synliga på dess ursprungliga diskussionssidor.
Denna handling kan inte göras om.',
	'lqt-marked-read' => "Tråden '''$1''' markerad som läst.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|meddelande markerat som läst|meddelanden markerade som lästa}}.',
	'lqt-email-undo' => 'Ångra',
	'lqt-no-new-messages' => 'Du har inga nya meddelanden.',
	'lqt-new-messages' => '✒ Du har nya meddelanden.',
	'lqt-email-info-undo' => 'Ta tillbaka tråden du precis tog bort.',
	'lqt-date-info' => 'Denna länk är avaktiverad eftersom du ser trådar från alla datum.',
	'lqt-newmessages-context' => 'Hela tråden',
	'lqt-thread-created' => 'Skapad',
	'lqt-history-time' => 'Tid',
	'lqt-history-user' => 'Användare',
	'lqt-history-action' => 'Aktivitet',
	'lqt-history-comment' => 'Kommentar',
	'lqt-history-thread' => 'Tråd',
	'lqt-thread-edited-author' => 'Redigerad av författaren.<br />
Senast redigerad: $1',
	'lqt-thread-edited-others' => 'Redigerad av {{PLURAL:$2|annan användare|$2 användare}}.<br />
Senaste redigerad: $1',
	'lqt-header-actions' => 'Åtgärder',
	'lqt_summarize_link' => 'Sammanfatta',
	'lqt-summarize-intro' => 'Sammanfatta tråden nedan i redigeringsfönstret.
Du kan använda wikitext i sammanfattningen. Klicka på "{{int:savearticle}}" när du är färdig.',
	'lqt-thread-split' => 'Dela upp till en ny tråd',
	'lqt-split-success' => 'Du har nu knoppat av tråden $1.',
	'lqt_split_thread' => 'Dela tråden i två',
	'lqt-thread-split-subject' => 'Ny trådtitel:',
	'lqt-thread-split-thread' => 'Tråd:',
	'lqt-split-submit' => 'Dela',
	'lqt_split_badsubject' => 'Angivet ämnesnamn är ogiltigt',
	'lqt-no-threads' => 'Det finns inga trådar på den här sidan ännu.',
	'lqt-delete-parent-warning' => 'Det här är en toppnivå-tråd med svar.
Dess svar kommer också raderas automatiskt.
För att undvika detta, splitta dem från denna tråd innan du raderar den.',
	'lqt-delete-parent-deleted' => 'Föräldratråd raderad ($1)',
	'lqt-delete-replies-done' => 'Alla svar till denna tråd har också raderats.',
	'lqt-movethread' => 'Flytta',
	'lqt-menu-trigger' => 'Mer',
	'lqt-newmessages-from' => 'Från $1',
	'lqt-hot-topics' => 'Heta ämnen',
	'lqt-add-reply' => 'Lägg till ett svar',
	'lqt_rc_new_discussion' => 'skapade en ny tråd, "$1"',
	'lqt_rc_new_reply' => 'postade ett svar till "$1"',
	'right-lqt-split' => 'Delade trådar',
	'right-lqt-merge' => 'Slå ihop trådar',
	'lqt-thread-merge' => 'Slå ihop in i en annan tråd.',
	'lqt-thread-merge-to' => 'Slå ihop in i den här tråden',
	'lqt_merge_thread' => 'Slå ihop tråd',
	'lqt-thread-merge-source' => 'Källtråd:',
	'lqt-thread-merge-dest' => 'Måltråd:',
	'lqt-merge-submit' => 'Slå ihop',
	'lqt-merge-success' => 'Du har framgångsrikt slagit ihop tråden $1 inunder tråden $2.',
	'lqt-log-name' => 'Diskussionssidor i trådform',
	'lqt-log-header' => 'Den här loggen visar händelser i diskussionstrådor.',
	'lqt-log-action-move' => 'flyttade [[$1]] från [[$2]] till [[$3]].',
	'lqt-log-action-split' => 'delade [[$1]] från under [[$3]], med det nya ämnet "$2".',
	'lqt-log-action-merge-across' => 'flyttade [[$1]] från under [[$2]] till under [[$3]].',
	'lqt-log-action-merge-down' => 'slog samman [[$1]] till under [[$3]]',
	'lqt-log-action-subjectedit' => 'ändrade ämnet för [[$1]] från "$2" till "$3"',
	'lqt-log-action-resort' => 'modifierade sorderingsordningen för [[$1]]. Ändrade sorderingsnyckel från $2 till $3.',
	'lqt-preference-notify-talk' => 'E-posta mig när någon svarar i en tråd jag bevakar',
	'lqt-preference-watch-threads' => 'Bevaka trådar jag skapar eller svarar i',
	'prefs-lqt' => 'Trådad diskussion',
	'lqt-preference-display-depth' => 'Maximalt svarsdjup som visas:',
	'lqt-preference-display-count' => 'Maximalt antal svar som visas:',
	'lqt-preference-custom-signatures' => 'Visa modifierade användarsignaturer',
	'lqt-enotif-subject-reply' => '{{SITENAME}}-diskussion - Svar: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}}-diskussion - Ny tråd: $1',
	'lqt-enotif-newthread' => "Hej $1,

Detta är ett meddelande från {{SITENAME}} om att det finns en ny tråd på $5, '$2', som skapades den $3 klockan $4 av $8.

Du kan läsa tråden på <$6>

Texten är:
$7",
	'lqt-enotif-reply' => "Hej $1,

Det här är ett meddelande från {{SITENAME}} om ett nytt svar på '$2' på $5
skapades den $3 klockan $4 av $8.

Du kan läsa svaret på <$6>

Texten i svaret är:
$7",
	'lqt-quote-intro' => 'Den $2 klockan $3 skrev [[User:$1|$1]]:',
	'lqt-quote' => 'Citera',
	'lqt-search-legend' => 'Sök i diskussionerna på den här sidan',
	'lqt-search-label' => 'Sökord:',
	'lqt-search-button' => 'Sök',
	'searchprofile-threads' => 'Diskussioner',
	'searchprofile-threads-tooltip' => 'Sök trådade diskussioner och diskussionssidor',
	'lqt-ajax-updated' => 'Denna tråd har nya poster.',
	'lqt-ajax-update-link' => 'Uppdatera',
	'lqt-thread-show-replies' => 'Visa $1 svar',
	'lqt-thread-show-more' => 'Visa fler svar',
	'lqt-thread-link-url' => 'Länk-URL:',
	'lqt-thread-link-title' => 'Wikitext-länk:',
	'lqt-thread-link-copy' => 'Kopiera till urklipp',
	'lqt-sign-not-necessary' => 'Det är inte nödvändigt att signera din post med fyra tilden.
Signaturen visas automatiskt.',
	'lqt-marked-as-read-placeholder' => 'Tråden $1 markerades som läst.',
	'lqt-change-subject' => 'Ändra ämne',
	'lqt-save-subject' => 'Spara',
	'lqt-save-subject-failed' => 'Följande fel uppstod vid försök att ändra ämne för denna tråd: $1',
	'lqt-ajax-invalid-subject' => 'Ämnet du angav var ogiltigt, förmodligen för att det var för långt.',
	'lqt-ajax-no-subject' => 'Du måste ange ett ämne.',
	'lqt-save-subject-error-unknown' => 'Ett fel uppstod vid försök att sätta ämnet för denna tråd. Vänligen försök göra det genom att klicka "redigera" på översta posten.',
	'lqt-cancel-subject-edit' => 'Avbryt',
	'lqt-drag-activate' => 'Dra till ny position',
	'lqt-drag-drop-zone' => 'Släpp här',
	'lqt-drag-confirm' => 'För att slutföra följande handlingar, fyll i en anledning och klicka "Bekräfta".',
	'lqt-drag-reparent' => 'Flytta post till under en ny förälder.',
	'lqt-drag-split' => 'Flytta post till sin egen tråd',
	'lqt-drag-setsortkey' => 'Justera posts position på sidan',
	'lqt-drag-bump' => 'Flytta post till överst på diskussionssida',
	'lqt-drag-save' => 'Bekräfta',
	'lqt-drag-title' => 'Bekräfta dra',
	'lqt-drag-reason' => 'Anledning:',
	'lqt-drag-subject' => 'Ämne för ny tråd:',
	'lqt-edit-signature' => '(redigera signatur)',
	'lqt-preview-signature' => '(förhandsgranska)',
	'lqt-feed-title-all' => '{{SITENAME}} — Nya poster',
	'lqt-feed-title-all-from' => '{{SITENAME}} — Nya poster från $1',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — Nya trådar',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — Nya trådar från $1',
	'lqt-feed-title-replies' => '{{SITENAME}} — Svar',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — Svar från $1',
	'lqt-feed-new-thread-intro' => 'Ny tråd på $1 postad av $2',
	'lqt-feed-reply-intro' => 'Svar till $3 (på $1) postad av $2',
	'tooltip-pt-newmessages' => 'Visar nya inlägg i trådar eller trådade diskussionssidor du bevakar',
	'lqt-newmessages-n' => 'Mina nya meddelanden ($1)',
	'lqt_newmessages' => 'Mina nya meddelanden (0)',
	'lqt_newmessages-title' => 'Nya meddelanden',
	'lqt-newpost-summary' => 'Ny tråd: $1',
	'lqt-reply-summary' => 'Svar på [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Diskussionssidehistorik',
	'lqt-talkpage-history-subtitle' => 'För $1',
	'lqt-talkpage-history-tab' => 'Rubrik',
	'restriction-reply' => 'Posta svar',
	'restriction-newthread' => 'Posta nya trådar',
	'lqt-protected-reply-thread' => 'Du kan inte posta i denna tråd eftersom den har skyddats från nya poster.',
	'lqt-protected-reply-talkpage' => 'Du kan inte posta i denna tråd eftersom denna diskussionssida har skyddats från svar på dess trådar.',
	'lqt-protected-newthread' => 'Du kan inte posta nya trådar till denna diskussionssida eftersom den har skyddats från nya trådar.',
	'lqt-edit-bump' => 'Bumpa denna tråd',
	'lqt-edit-bump-tooltip' => 'Flytta denna tråd till överst på sin diskussionssida',
	'lqt-historicalrevision-error' => 'Versionen du har valt är korrupt, och kan inte visas.',
	'lqt-reply-subpage' => 'svar',
	'nstab-thread' => 'Tråd',
	'nstab-summary' => 'Sammanfattning',
);

/** Swahili (Kiswahili)
 * @author Lloffiwr
 * @author Muddyb Blast Producer
 */
$messages['sw'] = array(
	'lqt-desc' => 'Kutumia milolongo ya majadiliano katika kurasa za majadiliano',
	'lqt_movethread' => 'Kuhamisha mlolongo katika ukurasa mwingine',
	'lqt_deletethread' => 'Kufuta au kufutua mlolongo',
	'lqt_contents_title' => 'Yaliyomo',
	'lqt_toc_thread_title' => 'Jina la mlolongo',
	'lqt_toc_thread_author' => 'Ulianzishwa na',
	'lqt_toc_thread_replycount' => 'Majibu',
	'lqt_toc_thread_modified' => 'Saa iliyobadilishwa mwishoni',
	'lqt_add_header' => 'Weka mada',
	'lqt_new_thread' => 'Anzisha jadiliano jipya',
	'lqt_empty_subject' => 'Lazima uandike jina la jadiliano.',
	'lqt_reply' => 'Jibu',
	'lqt-parent' => 'Hoja iliyotangulia',
	'lqt_delete' => 'Futa',
	'lqt_undelete' => 'Rudisha',
	'lqt_permalink' => 'Kiungo cha daima',
	'lqt_discussion_link' => 'majadiliano',
	'lqt_from_talk' => 'Kutoka kwa $1',
	'lqt-history-title' => 'Historia ya mlolongo',
	'lqt_hist_comment_edited' => 'Maandishi ya muhtasari [$2 uliohaririwa]',
	'lqt_hist_summary_changed' => 'Muhtasari ilibadilishwa',
	'lqt_hist_reply_created' => '[[$1|Jibu jipya]] lilianzishwa',
	'lqt_hist_thread_created' => 'Mlolongo mpya ulianzishwa',
	'lqt_hist_deleted' => 'Ilifutwa',
	'lqt_hist_undeleted' => 'Ilirudishwa',
	'lqt_hist_moved_talkpage' => 'Ilihamishwa',
	'lqt_hist_tooltip_newer_disabled' => 'Kiungo hichi hakifanyi kazi kwa sababu tayari upo ukurasa wa kwanza.',
	'lqt_hist_edited_subject' => 'Mada ya "$2" ilibadilishwa iwe "$3"',
	'lqt_hist_edited_subject_corrupt' => 'Mada ilibadilishwa',
	'lqt_protectedfromreply_link' => 'imelindwa',
	'lqt_subject' => 'Mada:',
	'lqt_noreason' => 'Sababu haikutajwa.',
	'lqt_summary_notice_link' => 'andika muhtasari',
	'lqt_summary_label' => 'Muhtasari wa mlolongo:',
	'lqt_summary_subtitle' => 'Muhtasari wa "$1"',
	'lqt_move_torename_edit' => 'uuharirie',
	'lqt_move_move' => 'Sogeza',
	'lqt_move_noreason' => 'Sababu haikutajwa.',
	'lqt_move_success' => 'Mlolongo ulihamishwa hadi $1.',
	'lqt_delete_deleted' => 'Mlolongo ulifutwa.',
	'lqt_delete_return' => 'Rudia $1.',
	'lqt_delete_return_link' => 'ukurasa wa majadiliano',
	'lqt_sorting_order' => 'Zipangwe kwa kuanzia na:',
	'lqt_sort_newest_changes' => 'zilizobadilishwa mwishoni',
	'lqt_sort_newest_threads' => 'zilizoanzishwa hivi karibuni',
	'lqt_sort_oldest_threads' => 'zilizoanzishwa mwanzoni',
	'lqt-title' => 'Cheo',
	'lqt-summary' => 'Muhtasari',
	'lqt-newmessages-context' => 'Mlolongo wote',
	'lqt-thread-created' => 'Ilianzishwa',
	'lqt-history-time' => 'Saa',
	'lqt-history-user' => 'Mtumiaji',
	'lqt-history-action' => 'Tendo',
	'lqt-history-comment' => 'Maelezo',
	'lqt-history-thread' => 'Mlolongo',
	'lqt-thread-edited-author' => 'Imehaririwa na mwanzilishaji.<br />
Haririo ya mwisho: $1',
	'lqt-thread-edited-others' => 'Imehaririwa na {{PLURAL:$2|mtumiaji mwingine|watumiaji wengine $2}}.<br />
Haririo ya mwisho: $1',
	'lqt-header-actions' => 'Vitendo',
	'lqt-thread-split-thread' => 'Mlolongo:',
	'lqt-movethread' => 'Sogeza',
	'lqt-menu-trigger' => 'Zaidi',
	'lqt-add-reply' => 'Weka jibu',
	'lqt-preference-notify-talk' => 'Unitumie barua pepe mada ninayofuata inapojibiwa',
	'prefs-lqt' => 'Mlolongo wa majadiliano',
	'lqt-preference-display-depth' => 'Upeo wa kina cha majibu yakuonyeshwa:',
	'lqt-preference-display-count' => 'Upeo wa idadi ya majibu ya kuonyesha:',
	'lqt-search-button' => 'Tafuta',
	'lqt-thread-link-url' => 'KISARA ya kiungo:',
	'lqt-save-subject' => 'Hifadhi',
	'lqt-cancel-subject-edit' => 'Batilisha',
	'lqt-drag-save' => 'Yakinisha',
	'lqt-drag-reason' => 'Sababu:',
	'lqt-drag-subject' => 'Mada ya mlolongo mpya:',
	'lqt-edit-signature' => '(hariri sahihi)',
	'lqt-preview-signature' => '(hakiki)',
	'lqt-newmessages-n' => 'Jumbe mpya ($1)',
	'lqt_newmessages' => 'Jumbe mpya',
	'lqt_newmessages-title' => 'Jumbe mpya',
	'lqt-newpost-summary' => 'Mlolongo mpya: $1',
	'lqt-reply-summary' => 'Jibu la [[$2|$1]]',
	'lqt-talkpage-history-title' => 'Historia ya ukurasa wa majadiliano',
	'lqt-talkpage-history-subtitle' => 'Kwa $1',
	'lqt-reply-subpage' => 'jibu',
	'nstab-thread' => 'Mlolongo',
	'nstab-summary' => 'Muhtasari',
);

/** Silesian (Ślůnski)
 * @author Herr Kriss
 * @author Timpul
 */
$messages['szl'] = array(
	'lqt_move_move' => 'Przećep',
);

/** Tamil (தமிழ்)
 * @author TRYPPN
 * @author செல்வா
 */
$messages['ta'] = array(
	'lqt_contents_title' => 'பொருளடக்கம்',
	'lqt_toc_thread_replycount' => 'பதில்கள்',
	'lqt_toc_thread_modified' => 'கடைசியாக திருத்தப்பட்டது',
	'lqt_add_header' => 'தலைப்பைக் கொடுக்கவும்',
	'lqt_empty_subject' => 'தாங்கள் இதற்கான ஒரு தலைப்பைக் கொடுக்கவும்',
	'lqt_reply' => 'பதில் அளி',
	'lqt_delete' => 'நீக்கவும்',
	'lqt_undelete' => 'நீக்கத்தை நிறுத்து',
	'lqt_discussion_link' => 'உரையாடல்',
	'lqt_hist_deleted' => 'நீக்கப்பட்டது',
	'lqt_hist_undeleted' => 'நீக்கம் நிறுத்தப்பட்டது',
	'lqt_hist_moved_talkpage' => 'நகர்த்தப்பட்டது',
	'lqt_protectedfromreply_link' => 'காக்கப்பட்டது',
	'lqt_subject' => 'பொருள்:',
	'lqt_noreason' => 'காரணம் தரப்படவில்லை.',
	'lqt_move_torename_edit' => 'இதைத் தொகுக்கவும்',
	'lqt_move_move' => 'நகர்த்தவும்',
	'lqt-title' => 'தலைப்பு',
	'lqt-summary' => 'சுருக்கம்',
	'lqt-thread-created' => 'உருவாக்கப்பட்டுவிட்டது',
	'lqt-history-time' => 'நேரம்',
	'lqt-history-user' => 'பயனர்',
	'lqt-history-action' => 'செயல்',
	'lqt-history-comment' => 'கருத்து',
	'lqt-header-actions' => 'செயல்கள்',
	'lqt-movethread' => 'நகர்த்தவும்',
	'lqt-menu-trigger' => 'மேலும்',
	'lqt-merge-submit' => 'இணைக்கவும்',
	'lqt-search-button' => 'தேடுக',
	'searchprofile-threads' => 'உரையாடல்',
	'lqt-ajax-update-link' => 'புதுப்பி',
	'lqt-save-subject' => 'சேமி',
	'lqt-cancel-subject-edit' => 'செய்யாமல் விடுக',
	'lqt-drag-save' => 'உறுதிப்படுத்து',
	'lqt-drag-reason' => 'காரணம்:',
	'lqt-preview-signature' => '(முன்தோற்றம்)',
	'lqt-talkpage-history-tab' => 'தலைப்பு',
	'lqt-reply-subpage' => 'பதில்',
	'nstab-summary' => 'சுருக்கம்',
);

/** Telugu (తెలుగు)
 * @author Kiranmayee
 * @author Veeven
 */
$messages['te'] = array(
	'lqt-desc' => 'చర్చా పుటలకి చర్చాహారాని చేర్చండి',
	'lqt_movethread' => 'చర్చాహారాన్ని మరో పేజీకి తరలించండి',
	'lqt_contents_title' => 'విషయాలు',
	'lqt_toc_thread_title' => 'చర్చాహారపు శీర్షిక',
	'lqt_toc_thread_author' => 'మొదలుపెట్టినది',
	'lqt_toc_thread_replycount' => 'స్పందనలు',
	'lqt_toc_thread_modified' => 'చివరి మార్పు',
	'lqt_add_header' => 'శీర్షాన్ని చేర్చు',
	'lqt_new_thread' => 'కొత్త చర్చని ప్రారంభించండి',
	'lqt_invalid_subject' => 'మీరు ఇచ్చిన విషయం చెల్లదు.
అది:
* చాలా పొడవుగా ఉంది, లేదా
* అంతర్వికీ ఉపసర్గలతోనూ లేదా పేరుబరులతోనూ సంఘర్షిస్తుంది.',
	'lqt_empty_subject' => 'మీరు తప్పనిసరిగా విషయాన్ని ఇవ్వాలి.',
	'lqt_reply' => 'స్పందించు',
	'lqt_delete' => 'తొలగించు',
	'lqt_permalink' => 'కి లంకె',
	'lqt_discussion_link' => 'చర్చ',
	'lqt_from_talk' => '$1 నుండి',
	'lqt-history-title' => 'చర్చాహారపు చరిత్ర',
	'lqt_hist_comment_edited' => 'వ్యాఖ్య పాఠ్యాన్ని [$2 మార్చారు]',
	'lqt_hist_summary_changed' => 'సంగ్రహం మార్చారు',
	'lqt_hist_reply_created' => '[[$1|కొత్త స్పందన]]ని సృష్టించారు',
	'lqt_hist_thread_created' => 'కొత్త చర్చాహారాన్ని సృష్టించారు',
	'lqt_hist_deleted' => 'తొలగించారు',
	'lqt_hist_moved_talkpage' => 'తరలించారు',
	'lqt_hist_listing_subtitle' => 'చారిత్రక జాబితాని చూస్తున్నారు',
	'lqt_hist_view_whole_thread' => 'మొత్తం చర్చాహారానికి చరిత్రని చూడండి',
	'lqt_hist_no_revisions_error' => 'ఈ చర్చాహారానికి చరిత్ర కూర్పులేమీ లేవు.',
	'lqt_hist_past_last_page_error' => 'మీరు ఉన్న చరిత్ర యొక్క పేజీల సంఖ్యని దాటిపోయారు.',
	'lqt_hist_tooltip_newer_disabled' => 'మీరు మొదటి పేజీలో ఉన్నందున ఈ లింకుని అచేతనం చేసాం.',
	'lqt_hist_tooltip_older_disabled' => 'మీరు చివరి పేజీలో ఉన్నారు కనుక ఈ లింకుని అచేతనం చేసాం.',
	'lqt_hist_edited_subject' => 'విషయాన్ని "$2" నుండి "$3"కి మార్చారు',
	'lqt_hist_edited_subject_corrupt' => 'విషయాన్ని మార్చారు',
	'lqt_hist_root_blanked' => 'వ్యాఖ్య పాఠ్యాన్ని తొలగించారు',
	'lqt_revision_as_of' => '$2 న $3 కి ఉన్న కూర్పు.',
	'lqt_change_new_thread' => 'ఇది చర్చాహారం యొక్క మొట్టమొదటి కూర్పు.',
	'lqt_change_reply_created' => '[$1 ఉద్దీపిత వ్యాఖ్య]ని ఈ కూర్పులో సృష్టించారు.',
	'lqt_change_edited_root' => '[$1 ఉద్దీపిత వ్యాఖ్య]ని ఈ కూర్పులో మార్చారు.',
	'lqt_change_edited_summary' => 'చర్చాహారపు సారాంశాన్ని మార్చారు',
	'lqt_change_root_blanked' => '[$1 ఒక వ్యాఖ్య] యొక్క పాఠ్యాన్ని తొలగించారు.',
	'lqt_youhavenewmessages' => 'మీకు [[$1|క్రొత్త సందేశాలు]] ఉన్నాయి.',
	'lqt_protectedfromreply_link' => 'సంరక్షించారు',
	'lqt_subject' => 'విషయం:',
	'lqt_noreason' => 'కారణం తెలుపలేదు.',
	'lqt_thread_deleted' => 'ఈ చర్చాహారాన్ని తొలగించాం.',
	'lqt_summary_notice_link' => 'సంగ్రహం వ్రాయండి',
	'lqt_summary_label' => 'చర్చాహారపు సారాంశం:',
	'lqt_summary_subtitle' => '$1 యొక్క సంగ్రహం',
	'lqt_nosuchrevision' => 'ఈ చర్చాహారానికి అటువంటి కూర్పు లేదు.',
	'lqt_nosuchthread' => 'మీరు పేర్కొన్నటువంటి చర్చాహారమేదీ లేదు.',
	'lqt_nosuchthread_title' => 'అటువంటి చర్చాహారం లేదు',
	'lqt_move_torename' => "ఈ చర్చాహారపు పేరు మార్చడానికి, $1 మరియు 'విషయం' అంశాన్ని మార్చండి.",
	'lqt_move_torename_edit' => 'దీన్ని మార్చండి',
	'lqt_move_destinationtitle' => 'గమ్యస్థానపు చర్చాపేజీ యొక్క శీర్షిక:',
	'lqt_move_move' => 'తరలించు',
	'lqt_move_nodestination' => 'మీరు తప్పనిసరిగా ఓ గమ్యస్థానం చెప్పాలి.',
	'lqt_move_thread_bad_destination' => 'గమ్యస్థానపు పేజీ ఒక చర్చాపేజీ కాదు.',
	'lqt_move_samedestination' => 'ఈ పేజీలో ఇప్పటికే ఆ చర్చాహారం ఉంది!',
	'lqt_move_noreason' => 'కారణం తెలుపలేదు.',
	'lqt_move_success' => 'ఈ చర్చాహారాన్ని $1కి తరలించాం.',
	'lqt_delete_partof' => "ఈ చర్చాహారం '''$1''' లో భాగం.",
	'lqt_delete_deleting' => "'''$1'''ని మరియు దానికి ఉన్న '''అన్ని స్పందనలనూ''' తొలగిస్తున్నారు.",
	'lqt_delete_deletethread' => 'చర్చాహారాన్ని మరియు స్పందనలను తొలగించు',
	'lqt_delete_deleted' => 'చర్చాహారాన్ని తొలగించాం.',
	'lqt_delete_return' => 'తిరిగి $1కి.',
	'lqt_delete_return_link' => 'చర్చా పేజీ',
	'lqt_delete_unallowed' => 'మీరు చర్చాహారాలని తొలగించలేరు.',
	'lqt_delete_show_checkbox' => 'తొలగించిన చర్చాహారాలను చూపించు',
	'lqt_header_warning_big' => 'మీరు ఒక $1ని మారుస్తున్నారు.',
	'lqt_header_warning_bold' => 'చర్చాపేజీ శీర్షిక',
	'lqt_header_warning_new_discussion' => 'కొత్త చర్చను మొదలుపెట్టండి',
	'lqt_sorting_order' => 'వరుస క్రమం:',
	'lqt_sort_newest_changes' => 'చివరగా మార్చినవి మొదట',
	'lqt_sort_newest_threads' => 'కొత్త చర్చాహారాలు మొదట',
	'lqt_sort_oldest_threads' => 'పాత చర్చాహారాలు మొదట',
	'lqt-title' => 'శీర్షిక',
	'lqt-summary' => 'సంగ్రహం',
	'lqt-read-message' => 'చదివినట్టుగా గుర్తుపెట్టు',
	'lqt-read-all' => 'అన్నింటినీ చదివినట్టుగా గుర్తుపెట్టు',
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|సందేశాన్ని|సందేశాలని}} చదివినట్లుగా గుర్తించాం.',
	'lqt-email-undo' => 'రద్దుచెయ్యి',
	'lqt-no-new-messages' => 'మీకు కొత్త సందేశాలేమీ లేవు.',
	'lqt-new-messages' => '✒ మీకు కొత్త సందేశాలు ఉన్నాయి.',
	'lqt-date-info' => 'మీరు అన్ని తేదీల నుండి చర్చాహారాలని చూస్తున్నారు కాబట్టి ఈ లంకెని అచేతనం చేసారు.',
	'lqt-newmessages-context' => 'పూర్తి చర్చాహారం',
	'lqt-thread-created' => 'సృష్టించినది',
	'lqt-history-time' => 'సమయం',
	'lqt-history-user' => 'వాడుకరి',
	'lqt-history-action' => 'కలాపం',
	'lqt-history-comment' => 'వ్యాఖ్య',
	'lqt-history-thread' => 'చర్చాహారం',
	'lqt-thread-edited-author' => 'రచయిత మార్చారు.<br />
చివరి మార్పు: $1',
	'lqt-thread-edited-others' => '{{PLURAL:$2|ఇతర వాడుకరి|$2 వాడుకరులు}} మార్చారు.<br />
చివరి మార్పు: $1',
	'lqt-header-actions' => 'చర్యలు',
	'lqt_summarize_link' => 'సంగ్రహించు',
	'lqt-thread-split-subject' => 'కొత్త చర్చాహారపు విషయం:',
	'lqt-thread-split-thread' => 'చర్చాహారం:',
	'lqt-split-submit' => 'విడదీయి',
	'lqt_split_badsubject' => 'మీరు ఇచ్చిన విషయం సరైనది కాదు.',
	'lqt-no-threads' => 'ఈ పుటలో ఇంకా చర్చాహారాలేమీ లేవు.',
	'lqt-delete-parent-deleted' => 'పైన చర్చ తొలగించడమైనది ($1)',
	'lqt-delete-replies-done' => 'ఈ చర్చాహారానికి వచ్చిన అన్ని స్పందనలను కూడా తొలగించాం.',
	'lqt-movethread' => 'తరలించు',
	'lqt-menu-trigger' => 'మరిన్ని',
	'lqt-newmessages-from' => '$1 నుండి',
	'lqt-hot-topics' => 'వేడి చర్చలు',
	'lqt-add-reply' => 'ఓ స్పందనని చేర్చు',
	'lqt_rc_new_discussion' => '$2లో కొత్త చర్చ "$1" • $3 అంటున్నారు:',
	'lqt-thread-merge-source' => 'మూల చర్చాహారం:',
	'lqt-thread-merge-dest' => 'లక్ష్యిత చర్చాహారం:',
	'lqt-merge-submit' => 'కలుపు',
	'lqt-merge-success' => '$1 చర్చాహారాన్ని $2 క్రింద మీరు విజయవంతంగా విలీనంచేసారు.',
	'lqt-log-name' => 'చర్చాహారాల చిట్టా',
	'lqt-log-header' => 'చర్చాహారాలపై జరిగిన చర్యల వివరాలు ఈ చిట్టాలో ఉంటాయి.',
	'lqt-log-action-move' => '[[$1]]ని [[$2]] నుండి [[$3]]కి తరలించారు.',
	'lqt-preference-notify-talk' => 'నేను వీక్షిస్తున్న చర్చాహారాలకి స్పందనలు వచ్చినప్పుడు నాకు ఈ-మెయిల్ పంపించు',
	'lqt-preference-watch-threads' => 'నేను సృష్టించే లేదా స్పందించే చర్చాహారాలను వీక్షించు',
	'prefs-lqt' => 'చర్చాహారాలు',
	'lqt-preference-display-depth' => 'చూపించాల్సిన స్పందనల గరిష్ఠ లోతు:',
	'lqt-preference-display-count' => 'చూపించాల్సిన స్పందనల యొక్క గరిష్ఠ సంఖ్య:',
	'lqt-enotif-subject-reply' => '{{SITENAME}} చర్చ - స్పందన: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} చర్చ - కొత్త చర్చాహారం: $1',
	'lqt-quote-intro' => '$2 నాడు $3 కి, [[User:$1|$1]] వ్రాసారు:',
	'lqt-quote' => 'ఉదహరించు',
	'lqt-search-legend' => 'ఈ పేజీలోని చర్చల్లో వెతుకు',
	'lqt-search-label' => 'అన్వేషణ పదాలు:',
	'lqt-search-button' => 'వెతుకు',
	'searchprofile-threads' => 'చర్చలు',
	'lqt-ajax-updated' => 'ఈ చర్చాహారంలో కొత్త టపాలు ఉన్నాయి.',
	'lqt-ajax-update-link' => 'తాజాకరించు',
	'lqt-thread-show-replies' => '$1 {{PLURAL:$1|స్పందనని|స్పందనలని}} చూపించు',
	'lqt-thread-show-more' => 'మరిన్ని స్పందనలని చూపించు',
	'lqt-thread-link-url' => 'లింకు URL:',
	'lqt-thread-link-title' => 'వికీపాఠ్యపు లింకు:',
	'lqt-sign-not-necessary' => 'మీ వ్యాఖ్యని నాలుగు టిల్డెలతో సంతకం చేయాల్సిన అవసరం లేదు.
సంతకాన్ని స్వయంచాలకంగా చూపిస్తాం.',
	'lqt-change-subject' => 'విషయాన్ని మార్చు',
	'lqt-save-subject' => 'భద్రపరచు',
	'lqt-save-subject-failed' => 'ఈ చర్చాహారం యొక్క విషయాన్ని మార్చడంలో ఈ పొరపాటు జరిగింది: $1',
	'lqt-ajax-invalid-subject' => 'మీరు ఇచ్చిన విషయం చెల్లదు, బహుశా అది బాగా పొడవుగా ఉండటంవల్ల కావచ్చు.',
	'lqt-ajax-no-subject' => 'మీరు తప్పనిసరిగా విషయాన్ని ఇవ్వాలి.',
	'lqt-cancel-subject-edit' => 'రద్దుచేయి',
	'lqt-drag-drop-zone' => 'ఇక్కడ వదలండి',
	'lqt-drag-bump' => 'టపాని చర్చా పేజీలో పైకి కదుపు',
	'lqt-drag-save' => 'నిర్ధారించు',
	'lqt-drag-reason' => 'కారణం:',
	'lqt-drag-subject' => 'కొత్త చర్చాహారానికై విషయం:',
	'lqt-edit-signature' => '(సంతకాన్ని మార్చండి)',
	'lqt-preview-signature' => '(మునుజూపు)',
	'lqt-feed-title-all' => '{{SITENAME}} — కొత్త టపాలు',
	'lqt-feed-title-all-from' => '{{SITENAME}} — $1 నుండి కొత్త టపాలు',
	'lqt-feed-title-new-threads' => '{{SITENAME}} — కొత్త చర్చాహారాలు',
	'lqt-feed-title-new-threads-from' => '{{SITENAME}} — $1 నుండి కొత్త చర్చాహారాలు',
	'lqt-feed-title-replies' => '{{SITENAME}} — స్పందనలు',
	'lqt-feed-title-replies-from' => '{{SITENAME}} — $1 నుండి స్పందనలు',
	'lqt-newmessages-n' => 'కొత్త సందేశాలు ($1)',
	'lqt_newmessages' => 'నా కొత్త సందేశాలు (ఏమీలేవు)',
	'lqt_newmessages-title' => 'కొత్త సందేశాలు',
	'lqt-newpost-summary' => 'కొత్త చర్చాహారం: $1',
	'lqt-reply-summary' => '[[$2|$1]]కి స్పందన',
	'lqt-talkpage-history-title' => 'చర్చా పేజీ చరిత్ర',
	'lqt-talkpage-history-subtitle' => '$1 కొరకు',
	'lqt-talkpage-history-tab' => 'శీర్షిక',
	'restriction-reply' => 'స్పందనలు వ్రాయడం',
	'lqt-edit-bump-tooltip' => 'ఈ చర్చాహారాన్ని దాని చర్చాపుటలలో పైకి కదపండి',
	'lqt-reply-subpage' => 'స్పందించు',
	'nstab-thread' => 'చర్చాహారం',
	'nstab-summary' => 'సారాంశం',
);

/** Tetum (Tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'lqt_contents_title' => 'Konteúdu',
	'lqt_delete' => 'Halakon',
	'lqt_protectedfromreply_link' => 'proteje tiha',
	'lqt_noreason' => 'Laiha motivu.',
	'lqt_move_torename_edit' => 'edita nia',
	'lqt_move_move' => 'Book',
	'lqt_move_noreason' => 'Laiha motivu.',
	'lqt_delete_return' => 'Fali ba $1.',
	'lqt-title' => 'Títulu',
	'lqt-summary' => 'Rezumu',
	'nstab-summary' => 'Rezumu',
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'lqt-desc' => 'Илова кардани баҳси торкашӣ ба саҳифаҳои баҳс',
	'lqt_movethread' => 'Кӯчонидани тор ба дигар саҳифа',
	'lqt_deletethread' => 'Ҳазф ё барқарор кардани тор',
	'lqt_contents_title' => 'Мундариҷа',
	'lqt_new_thread' => 'Оғози мубоҳисаи ҷадид',
	'lqt_reply' => 'Посух додан',
	'lqt_delete' => 'Ҳафз',
	'lqt_discussion_link' => 'баҳс',
	'lqt_from_talk' => 'аз $1',
	'lqt_hist_deleted' => 'Ҳазфшуда',
	'lqt_protectedfromreply_link' => 'ҳифзшуда',
	'lqt_subject' => 'Мавзӯъ:',
	'lqt_noreason' => 'Далеле мушаххас нашудааст.',
	'lqt_summary_notice_link' => 'навиштани хулоса',
	'lqt_summary_label' => 'Ин тор ба таври зерин хулоса шудааст:',
	'lqt_summary_subtitle' => 'хулоса аз $1.',
	'lqt_nosuchrevision' => 'Чунин нусхае аз ин тор нест.',
	'lqt_nosuchthread' => 'Чунин тор нест.',
	'lqt_threadrequired' => 'Шумо бояд тореро дар нишонаи интернетии URL мушаххас кунед.',
	'lqt_move_movingthread' => 'Дар ҳоли кӯчонидани $1. Ин тор қисме аз $2 мебошад.',
	'lqt_move_torename' => "Барои тағйири номи ин тор, $1 ва ноҳияи 'Мавзӯъ'-ро тағйир диҳед.",
	'lqt_move_torename_edit' => 'инро вироиш кунед',
	'lqt_move_move' => 'Кӯчонидан',
	'lqt_move_nodestination' => 'Шумо бояд мақсадро мушаххас кунед.',
	'lqt_move_noreason' => 'Далеле мушаххас нашудааст',
	'lqt_move_success' => 'Тор ба $1 кӯчонида шуд.',
	'lqt_delete_unallowed' => 'Шумо иҷозати ҳазф кардани ин торҳоро надоред.',
	'lqt_header_warning_big' => 'Шумо дар ҳоли вироиши $1 ҳастед.',
	'lqt_header_warning_new_discussion' => 'оғози мубоҳисаи ҷадид',
	'lqt_sort_newest_threads' => 'торҳои навтарин аввал',
	'lqt_sort_oldest_threads' => 'торҳои кӯҳнатарин аввал',
	'lqt_newmessages' => 'Пайёмҳои нав',
);

/** Tajik (Latin) (Тоҷикӣ (Latin))
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'lqt-desc' => 'Ilova kardani bahsi torkaşī ba sahifahoi bahs',
	'lqt_movethread' => 'Kūconidani tor ba digar sahifa',
	'lqt_deletethread' => 'Hazf jo barqaror kardani tor',
	'lqt_contents_title' => 'Mundariça',
	'lqt_new_thread' => 'Oƣozi mubohisai çadid',
	'lqt_reply' => 'Posux dodan',
	'lqt_delete' => 'Hafz',
	'lqt_discussion_link' => 'bahs',
	'lqt_hist_deleted' => 'Hazfşuda',
	'lqt_protectedfromreply_link' => 'hifzşuda',
	'lqt_subject' => "Mavzū':",
	'lqt_noreason' => 'Dalele muşaxxas naşudaast.',
	'lqt_summary_notice_link' => 'naviştani xulosa',
	'lqt_summary_label' => 'In tor ba tavri zerin xulosa şudaast:',
	'lqt_nosuchrevision' => 'Cunin nusxae az in tor nest.',
	'lqt_threadrequired' => 'Şumo bojad torero dar nişonai internetiji URL muşaxxas kuned.',
	'lqt_move_movingthread' => 'Dar holi kūconidani $1. In tor qisme az $2 meboşad.',
	'lqt_move_torename' => "Baroi taƣjiri nomi in tor, $1 va nohijai 'Mavzū''-ro taƣjir dihed.",
	'lqt_move_torename_edit' => 'inro viroiş kuned',
	'lqt_move_move' => 'Kūconidan',
	'lqt_move_nodestination' => 'Şumo bojad maqsadro muşaxxas kuned.',
	'lqt_move_noreason' => 'Dalele muşaxxas naşudaast',
	'lqt_move_success' => 'Tor ba $1 kūconida şud.',
	'lqt_delete_unallowed' => 'Şumo içozati hazf kardani in torhoro nadored.',
	'lqt_header_warning_big' => 'Şumo dar holi viroişi $1 hasted.',
	'lqt_header_warning_new_discussion' => 'oƣozi mubohisai çadid',
	'lqt_sort_newest_threads' => 'torhoi navtarin avval',
	'lqt_sort_oldest_threads' => 'torhoi kūhnatarin avval',
	'lqt_newmessages' => 'Pajjomhoi nav',
);

/** Thai (ไทย)
 * @author Octahedron80
 * @author Woraponboonkerd
 */
$messages['th'] = array(
	'lqt_delete' => 'ลบ',
	'lqt-thread-link-copy' => 'คัดลอกไปยังคลิปบอร์ด',
	'lqt-cancel-subject-edit' => 'ยกเลิก',
	'lqt-drag-activate' => 'ลากไปยังที่อื่น',
	'lqt-drag-drop-zone' => 'วางที่นี่',
	'lqt-drag-save' => 'ยืนยัน',
	'lqt-edit-signature' => '(แก้ไขลายเซ็นต์)',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 * @author Runningfridgesrule
 */
$messages['tk'] = array(
	'lqt-desc' => 'Pikir alyşma sahypalaryna tredli çekişmeleri goş',
	'lqt_movethread' => 'Tredi başga sahypa geçir',
	'lqt_deletethread' => 'Tredi öçür ýa-da yzyna dikelt',
	'lqt_contents_title' => 'Mazmuny',
	'lqt_toc_thread_title' => 'Trediň ady',
	'lqt_toc_thread_author' => 'Başladan',
	'lqt_toc_thread_replycount' => 'Jogaplar',
	'lqt_toc_thread_modified' => 'Soňky üýtgedilen wagty',
	'lqt_add_header' => 'At goş',
	'lqt_new_thread' => 'Täze çekişme başlat',
	'lqt_invalid_subject' => 'Ýazan temaňyz nädogry.
Belkem:
* ol aşa uzyndyr, ýa-da
* Wikiara pristawkalar ýa-da at giňişlikleri bilen çaknyşýandyr.',
	'lqt_empty_subject' => 'Tema ýazmalysyňyz.',
	'lqt_reply' => 'Jogap ber',
	'lqt-parent' => 'Ene-ata',
	'lqt_delete' => 'Öçür',
	'lqt_undelete' => 'Öçürmäni yzyna al',
	'lqt_permalink' => 'Şuňa çykgyt',
	'lqt_fragment' => '$2 sahypasyndan $1 fragmenti',
	'lqt_discussion_link' => 'çekişme',
	'lqt_from_talk' => '$1 sahypasyndan',
	'lqt-history-title' => 'Tred geçmişi',
	'lqt_hist_comment_edited' => 'Teswiriň teksti [$2 redaktirlendi]',
	'lqt_hist_summary_changed' => 'Düşündiriş üýtgedildi',
	'lqt_hist_reply_created' => '[[$1|Täze jogap]] döredildi',
	'lqt_hist_thread_created' => 'Täze tred döredildi',
	'lqt_hist_deleted' => 'Öçürildi',
	'lqt_hist_undeleted' => 'Öçürme yzyna alyndy',
	'lqt_hist_moved_talkpage' => 'Geçirildi',
	'lqt_hist_listing_subtitle' => 'Geçmiş sanawy görkezilýär',
	'lqt_hist_view_whole_thread' => 'Tutuş trediň geçmişini gör',
	'lqt_hist_no_revisions_error' => 'Bu trediň hiç hili geçmiş wersiýasy ýok.',
	'lqt_hist_past_last_page_error' => 'Bar bolan geçmiş sahypasy sanyndan has öte geçdiňiz.',
	'lqt_hist_tooltip_newer_disabled' => 'Bu çykgyt ýapyldy, sebäbi siz ilkinji sahypada.',
	'lqt_hist_tooltip_older_disabled' => 'Bu çykgyt ýapyldy, sebäbi siz iň soňky sahypada.',
	'lqt_hist_split' => 'Jogap täze trede bölünen',
	'lqt_hist_edited_subject' => 'Tema bolan $2, $3 diýlip üýtgedildi',
	'lqt_hist_edited_subject_corrupt' => 'Temany üýtgetdi',
	'lqt_hist_merged_from' => '[[$1|Jogap]] başga bir trede geçirildi',
	'lqt_hist_merged_to' => '[[$1|Jogap]] başga bir tredden geçirildi',
	'lqt_hist_split_from' => 'Täze trede böl',
	'lqt_hist_root_blanked' => 'Teswir teksti aýyryldy',
	'lqt_hist_adjusted_sortkey' => 'Sazlanan tred pozisiýasy',
	'lqt_revision_as_of' => '$3 $2 seneli wersiýa',
	'lqt_change_new_thread' => 'Bu trediň ilkibaşdaky wersiýasy.',
	'lqt_change_reply_created' => '[$1 Nygtalan teswir] bu wersiýada döredildi.',
	'lqt_change_edited_root' => '[$1 Nygtalan teswir] bu wersiýada redaktirlendi.',
	'lqt_change_edited_summary' => 'Trediň düşündirişi redaktirlendi',
	'lqt_change_deleted' => '[$1 Bu tred] ýa-da onuň ene tredi öçürilipdir',
	'lqt_change_undeleted' => '[$1 Nygtalan iberme] yzyna dikeldildi',
	'lqt_change_moved' => '[$1 Bu tred] başga bir çekişme sahypasyna geçirildi',
	'lqt_change_split' => '[$1 Bu tred] başga bir tredden bölündi',
	'lqt_change_edited_subject' => 'Bu trediň temasy bolan "$2", "$3" diýlip üýtgedildi',
	'lqt_change_merged_from' => 'Bu trede gelen bir [$1 jogap] başga bir trede geçirildi',
	'lqt_change_merged_to' => '[$1 Nygtalan jogap] başga bir tredden geçirildi',
	'lqt_change_split_from' => 'Bu trediň [$1 kiçi tredi] öz tredine bölündi',
	'lqt_change_root_blanked' => '[$1 Teswiriň] teksti aýyryldy.',
	'lqt_youhavenewmessages' => 'Size [[$1|täze habarlaşyk]] bar.',
	'lqt_protectedfromreply' => 'Bu tred jogap berilmezligi üçin $1.',
	'lqt_protectedfromreply_link' => 'goragly',
	'lqt_subject' => 'Tema:',
	'lqt_noreason' => 'Sebäp görkezilmedik.',
	'lqt_move_placeholder' => 'Bu tred , $1 trediniň bu sahypadan başga bir ýere geçirilendigini görkezýän ýer-saklaýjydyr.
Tred $4 $3 senesinde $2 tarapyndan geçirilipdir. 
Tred häzirki wagtda $5 adresinde ýerleşýär.',
	'lqt_thread_deleted_for_sysops' => "Bu tred '''öçürilipdir''' we ony diňe administratorlar görüp bilýär.",
	'lqt_thread_deleted' => 'Bu tred öçürilipdir.',
	'lqt_summary_notice' => 'Bu çekişmede iň bolmanda $2 {{PLURAL:$2|günden bäri|günden bäri}} hiç hili üýtgeşme ýok.
Eger tamamlanan bolsa, $1 gelmegi mümkin.',
	'lqt_summary_notice_link' => 'düşündiriş ýazasyňyz',
	'lqt_summary_label' => 'Bu tred aşakdaky ýaly gysgaça düşündirilýär:',
	'lqt_summary_subtitle' => '"$1" üçin düşündiriş',
	'lqt_nosuchrevision' => 'Be trediň beýle wersiýasy ýok.',
	'lqt_nosuchthread' => 'Görkezen trediňiz ýok.',
	'lqt_nosuchthread_title' => 'Beýle tred ýok.',
	'lqt_threadrequired' => 'Tredi URL-de görkezmelisiňiz.',
	'lqt_move_movingthread' => '$1 geçirilýär.
Bu tred $2 trediniň bir bölegidir.',
	'lqt_move_torename' => "Bu trediň adyny üýtgetmek üçin $1 we 'Tema' meýdançasyny üýtgediň.",
	'lqt_move_torename_edit' => 'ony redaktirläň',
	'lqt_move_destinationtitle' => 'Niýetlenilýän pikir alyşma sahypasynyň ady:',
	'lqt_move_move' => 'Geçir',
	'lqt_move_nodestination' => 'Niýetlenilýän sahypa görkezmeli.',
	'lqt_move_thread_bad_destination' => 'Niýetlenilýän sahypa çekişme sahypasy däl.',
	'lqt_move_samedestination' => 'Tred eýýäm bu sahypada!',
	'lqt_move_noreason' => 'Sebäp görkezilmändir.',
	'lqt_move_success' => 'Tred $1 sahypasyna geçirildi.',
	'lqt_delete_undeletethread' => 'Tredi yzyna dikelt',
	'lqt_delete_partof' => "Bu tred '''$1''' trediniň bir bölegidir.",
	'lqt_delete_deleting' => "'''$1''' we '''ähli jogaplar''' öçürilýär.",
	'lqt_delete_deletethread' => 'Tredi we jogaplary öçür',
	'lqt_delete_deleted' => 'Tred öçürildi.',
	'lqt_delete_undeleted' => 'Tred yzyna dikeldi.',
	'lqt_delete_return' => '$1 gaýdyp bar.',
	'lqt_delete_return_link' => 'Pikir alyşma sahypasyna',
	'lqt_delete_unallowed' => 'Tredleri öçürmäge rugsadyňyz ýok.',
	'lqt_delete_show_checkbox' => 'Öçürilen tredleri görkez',
	'lqt_talkpage_autocreate_summary' => 'Pikir alyşma sahypasy ilkinji tred iberilende awtomatik döredildi.',
	'lqt_header_warning_big' => '$1 redaktirleýärsiňiz.',
	'lqt_header_warning_after_big' => 'Atlar bildirişler we sözbaşylar üçindir.
Oňa derek $2 gelmegi ahmal.',
	'lqt_header_warning_bold' => 'çekişme sahypasynyň adyny',
	'lqt_header_warning_new_discussion' => 'täze çekişme başladasyňyz',
	'lqt_sorting_order' => 'Düzüliş tertibi:',
	'lqt_sort_newest_changes' => 'ilki iň soňky üýtgedilen',
	'lqt_sort_newest_threads' => 'ilki has täze tredler',
	'lqt_sort_oldest_threads' => 'ilki has köne tredler',
	'lqt-title' => 'At',
	'lqt-summary' => 'Düşündiriş',
	'lqt-searching' => 'Tredler gözlenilýär',
	'lqt-read-message' => 'Okalan diýip belle',
	'lqt-read-message-tooltip' => 'Bu tredi täze habarlaşyklardan aýyr.
Ol özüniň esasy pikir alyşma sahypasynda görnüp durar.',
	'lqt-read-all' => 'Ählisini okalan diýip belle',
	'lqt-read-all-tooltip' => 'Ähli tredleri täze habarlaşyklardan aýyryň.
Olar özleriniň esasy pikir alyşma sahypalarynda görnüp durarlar.
Bu operasiýany yzyna alyp bolmaýar.',
	'lqt-marked-read' => "'''$1''' tredi okalan diýlip bellenildi.",
	'lqt-count-marked-read' => '$1 {{PLURAL:$1|habarlaşyk|habarlaşyk}} okalan diýlip bellenildi.',
	'lqt-email-undo' => 'Yzyna al',
	'lqt-no-new-messages' => 'Size täze habarlaşyk ýok.',
	'lqt-new-messages' => '✒ Size täze habarlar bar.',
	'lqt-email-info-undo' => 'Ýaňyja aýyran trediňizi yzyna getirýär',
	'lqt-date-info' => 'Bu çykgyt ýapyldy, sebäbi siz ähli senelerden tredleri görkezýärsiňiz.',
	'lqt-newmessages-context' => 'Doly tred',
	'lqt-thread-created' => 'Döredildi',
	'lqt-history-time' => 'Wagt',
	'lqt-history-user' => 'Ulanyjy',
	'lqt-history-action' => 'Işjeňlik',
	'lqt-history-comment' => 'Teswir',
	'lqt-history-thread' => 'Tred',
	'lqt-thread-edited-author' => 'Awtor tarapyndan redaktirlenen',
	'lqt-thread-edited-others' => 'Başga ulanyjylar tarapyndan redaktirlenen',
	'lqt-header-actions' => 'Hereketler',
	'lqt_summarize_link' => 'Jemläp ýaz',
	'lqt-summarize-intro' => 'Aşakdaky tredi redaktirleme gutusynda jemläp ýazyň.
Jemlemede islendik wikiteksti ulanyp bilersiňiz.
Gutaranyňyzdan soň, tyklaň: "{{int:savearticle}}".',
	'lqt-thread-split' => 'Täze trede böl',
	'lqt-split-success' => '$1 tredini şowly böldüňiz.',
	'lqt_split_thread' => 'Tred böl',
	'lqt-thread-split-subject' => 'Täze tred temasy:',
	'lqt-thread-split-thread' => 'Tred:',
	'lqt-split-submit' => 'Böl',
	'lqt_split_badsubject' => 'Ýazan temaňyz nädogry.',
	'lqt-no-threads' => 'Bu sahypada heniz tred ýok.',
	'lqt-delete-parent-warning' => 'Bu jogaplary bar bolan ýokary derejeli treddir.',
	'lqt-delete-parent-deleted' => 'Ene tred öçürildi ($1)',
	'lqt-delete-replies-done' => 'Bu trede berlen ähli jogaplar hem öçürildi.',
	'lqt-movethread' => 'Geçir',
	'lqt-menu-trigger' => 'Has köp',
	'lqt-newmessages-from' => '$1 sahypasyndan',
	'lqt-hot-topics' => 'Täze temalar',
	'lqt-add-reply' => 'Jogap goş',
	'lqt_rc_new_discussion' => '$2 sahypasynda täze çekişme "$1" • $3 ýazýar:',
	'lqt_rc_new_reply' => '$2 sahaypasyndaky "$1" tredine jogap • $3 ýazýar:',
	'right-lqt-split' => 'Tredleri böl',
	'right-lqt-merge' => 'Tredleri birleşdir',
	'lqt-thread-merge' => 'Başga bir trede birleşdir',
	'lqt-thread-merge-to' => 'Şu trede birleşdir',
	'lqt_merge_thread' => 'Tredi birleşdir',
	'lqt-thread-merge-source' => 'Çeşme tred:',
	'lqt-thread-merge-dest' => 'Niýetlenilýän tred:',
	'lqt-merge-submit' => 'Birikdir',
	'lqt-merge-success' => '$1 tredini $2 trediniň aşagyna şowly birleşdirdiňiz.',
	'lqt-log-name' => 'Tredli çekişme gündeligi',
	'lqt-log-header' => 'Bu gündelik çekişme tredleri boýunça edilen hereketleri jikme-jik görkezýär.',
	'lqt-log-action-move' => '[[$1]] tredini [[$2]] sahypasyndan [[$3]] sahypasyna geçirdi.',
	'lqt-log-action-split' => '[[$1]] setirini [[$3]] setiriniň aşagyndan aýyrdy, täze tema: "$2"',
	'lqt-log-action-merge-across' => '[[$1]] setirini [[$2]] setiriniň aşagynda [[$3]] setiriniň aşagyna geçirdi',
	'lqt-log-action-merge-down' => '[[$1]] setirini [[$3]] setiriniň aşagyna birleşdirdi',
	'lqt-log-action-subjectedit' => '[[$1]] setiriniň temasyny "$2" ýagdaýyndan "$3" edip üýtgetdi',
	'lqt-log-action-resort' => '[[$1]] setiriniň sortirlemesini üýtgetdi. Sortirleme açary $2 ýagdaýyndan $3 edilip üýtgedildi.',
	'lqt-preference-notify-talk' => 'Gözegçilik edýän tredime jogap gelende maňa e-poçta iber',
	'lqt-preference-watch-threads' => 'Döreden ýa-da jogap beren tredlerimi gözegçilikde sakla',
	'prefs-lqt' => 'Tredli çekişme',
	'lqt-preference-display-depth' => 'Görkezilmeli maksimum jogap çuňlugy:',
	'lqt-preference-display-count' => 'Görkezilmeli maksimum jogap sany:',
	'lqt-preference-custom-signatures' => 'Hususy ulanyjy gollaryny görkez',
	'lqt-enotif-subject-reply' => '{{SITENAME}} çekişmesi - Jogap: $1',
	'lqt-enotif-subject-newthread' => '{{SITENAME}} çekişmesi - Täze tred: $1',
	'lqt-enotif-newthread' => "Salam $1,
Bu {{SITENAME}} saýtynyň bir uwedomleniýesidir: $5 sahypasynda $4 $3 senesinde täze '$2' tredi döredildi.

Ony <$6> adresinde görüp bilersiňiz.",
	'lqt-enotif-reply' => "Salam $1,
Bu {{SITENAME}} saýtynyň uwedomleniýasydyr: $5 sahypasynda $4 $3 senesinde '$2' tredine täze bir jogap döredildi. 

Ony <$6> adresinde görüp bilersiňiz.",
	'lqt-quote-intro' => '$2, $3 senesinde [[User:$1|$1]] ýazdy:',
	'lqt-quote' => 'Sitata',
	'lqt-search-legend' => 'Şu sahypadaky çekişmeleri gözle',
	'lqt-search-label' => 'Gözleg terminleri:',
	'lqt-search-button' => 'Gözle',
	'searchprofile-threads' => 'Çekişmeler',
	'searchprofile-threads-tooltip' => 'Tredli çekişmelerini we pikir alyşma sahypalaryny gözle',
	'lqt-ajax-updated' => 'Bu tredde täze ibermeler bar.',
	'lqt-ajax-update-link' => 'Täzele',
	'lqt-thread-show-replies' => '$1 {{PLURAL:$1|jogap|jogap}} görkez',
	'lqt-thread-show-more' => 'Has köp jogap görkez',
	'lqt-thread-link-url' => 'Çykgyt URL-si:',
	'lqt-thread-link-title' => 'Wikitekst çykgydy:',
	'lqt-thread-link-copy' => 'Alyş-çalyş buferine göçür',
	'lqt-sign-not-necessary' => 'Ibermäňize dört tilda bilen gol çekmek gerek däl.
Gol awtomatik görkezilýär.',
	'lqt-marked-as-read-placeholder' => '$1 tredi okalan diýlip bellenilipdir.',
	'lqt-change-subject' => 'Temany üýtget',
	'lqt-save-subject' => 'Ýazdyr',
	'lqt-save-subject-failed' => 'Bu trediň temasy üýtgediljek bolnanda aşakdaky säwlik ýüze çykdy: $1',
	'lqt-ajax-invalid-subject' => 'Görkezen temaňyz nädogry, ähtimal ol örän uzyn