<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'DeleteThread' => array( 'DeleteThread' ),
	'HotTopics' => array( 'HotTopics' ),
	'MoveThread' => array( 'MoveThread' ),
	'NewMessages' => array( 'NewMessages' ),
	'SplitThread' => array( 'SplitThread' ),
	'MergeThread' => array( 'MergeThread' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'DeleteThread' => array( 'حذف_الخيط' ),
	'HotTopics' => array( 'مواضيع_ساخنة' ),
	'MoveThread' => array( 'نقل_الخيط' ),
	'NewMessages' => array( 'رسائل_جديدة' ),
	'SplitThread' => array( 'فصل_الخيط' ),
	'MergeThread' => array( 'دمج_الخيط' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'DeleteThread' => array( 'مسح_جروپ_الرسايل' ),
	'MoveThread' => array( 'نقل_جروپ_الرسايل' ),
	'NewMessages' => array( 'رسايل_جديده' ),
	'SplitThread' => array( 'فصل_الخيط' ),
	'MergeThread' => array( 'دمج_الخيط' ),
);

/** Breton (Brezhoneg) */
$specialPageAliases['br'] = array(
	'DeleteThread' => array( 'DiverkañNeudennad' ),
	'MoveThread' => array( 'Dilec\'hiañNeudennad' ),
	'NewMessages' => array( 'KemennoùNevez' ),
	'SplitThread' => array( 'DispartiañNeudennad' ),
	'MergeThread' => array( 'KendeuziñNeudennad' ),
);

/** Bosnian (Bosanski) */
$specialPageAliases['bs'] = array(
	'DeleteThread' => array( 'ObrisiTok' ),
	'HotTopics' => array( 'VruceTeme' ),
	'MoveThread' => array( 'PremjestiTok' ),
	'NewMessages' => array( 'NovePoruke' ),
	'SplitThread' => array( 'RazdvojiTok' ),
	'MergeThread' => array( 'SpojiTok' ),
);

/** Czech (Česky) */
$specialPageAliases['cs'] = array(
	'DeleteThread' => array( 'Smazat_vlákno', 'Smazat_vlakno' ),
	'MoveThread' => array( 'Přesunout_vlákno', 'Presunout_vlakno' ),
	'NewMessages' => array( 'Nové_zprávy', 'Nove_zpravy' ),
	'SplitThread' => array( 'Oddělit_vlákno', 'Oddelit_vlakno' ),
	'MergeThread' => array( 'Sloučit_vlákno', 'Sloucit_vlakno' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'DeleteThread' => array( 'Thread_löschen' ),
	'MoveThread' => array( 'Thread_verschieben' ),
	'NewMessages' => array( 'Neue_Nachrichten' ),
);

/** Lower Sorbian (Dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'DeleteThread' => array( 'Nitku_lašowaś' ),
	'MoveThread' => array( 'Nitku_pśesunuś' ),
	'NewMessages' => array( 'Nowe_powěsći' ),
);

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = array(
	'DeleteThread' => array( 'ΔιαγραφήΝήματος' ),
	'MoveThread' => array( 'ΜετακίνησηΝήματος' ),
	'NewMessages' => array( 'ΝέαΜηνύματα' ),
);

/** Spanish (Español) */
$specialPageAliases['es'] = array(
	'DeleteThread' => array( 'BorrarHilo', 'Borrar_hilo' ),
	'MoveThread' => array( 'MoverHilo', 'Mover_hilo' ),
	'NewMessages' => array( 'MensajesNuevos', 'Mensajes_nuevos' ),
	'SplitThread' => array( 'SepararHilo', 'Separar_hilo' ),
	'MergeThread' => array( 'FusionarHilo', 'Fusionar_hilo' ),
);

/** Estonian (Eesti) */
$specialPageAliases['et'] = array(
	'DeleteThread' => array( 'Lõime_kustutamine' ),
	'MoveThread' => array( 'Lõime_teisaldamine' ),
	'NewMessages' => array( 'Uued_sõnumid' ),
	'SplitThread' => array( 'Lõime_jagamine' ),
	'MergeThread' => array( 'Lõime_liitmine' ),
);

/** Basque (Euskara) */
$specialPageAliases['eu'] = array(
	'NewMessages' => array( 'MezuBerriak' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'DeleteThread' => array( 'حذف_رشته' ),
	'HotTopics' => array( 'عناوین_داغ' ),
	'MoveThread' => array( 'انتقال_رشته' ),
	'NewMessages' => array( 'پیام‌های_جدید' ),
	'SplitThread' => array( 'گسستن_رشته' ),
	'MergeThread' => array( 'ادغام_رشته' ),
);

/** Finnish (Suomi) */
$specialPageAliases['fi'] = array(
	'DeleteThread' => array( 'Poista_keskusteluketju' ),
	'HotTopics' => array( 'Keskustelluimmat' ),
	'MoveThread' => array( 'Siirrä_keskusteluketju' ),
	'NewMessages' => array( 'Uudet_viestit' ),
	'SplitThread' => array( 'Pilko_keskustelu' ),
	'MergeThread' => array( 'Yhdistä_keskusteluja' ),
);

/** French (Français) */
$specialPageAliases['fr'] = array(
	'NewMessages' => array( 'NouveauxMessages', 'Nouveaux_Messages' ),
);

/** Franco-Provençal (Arpetan) */
$specialPageAliases['frp'] = array(
	'DeleteThread' => array( 'Èfaciér_lo_fil', 'ÈfaciérLoFil' ),
	'MoveThread' => array( 'Dèplaciér_lo_fil', 'DèplaciérLoFil' ),
	'NewMessages' => array( 'Mèssâjos_novéls', 'MèssâjosNovéls' ),
);

/** Gagauz (Gagauz) */
$specialPageAliases['gag'] = array(
	'NewMessages' => array( 'EniSözleşmäkler' ),
);

/** Galician (Galego) */
$specialPageAliases['gl'] = array(
	'NewMessages' => array( 'Mensaxes_novas' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'DeleteThread' => array( 'Thread lesche' ),
	'MoveThread' => array( 'Thread verschiebe' ),
	'NewMessages' => array( 'Neji Nochrichte' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'DeleteThread' => array( 'מחיקת_שרשור' ),
	'MoveThread' => array( 'העברת_שרשור' ),
	'NewMessages' => array( 'הודעות_חדשות' ),
	'SplitThread' => array( 'פיצול_שרשור' ),
	'MergeThread' => array( 'מיזוג_שרשור' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'DeleteThread' => array( 'Nitku_wušmórnyć' ),
	'MoveThread' => array( 'Nitku_přesunyć' ),
	'NewMessages' => array( 'Nowe_powěsće' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'DeleteThread' => array( 'EfaseFil' ),
	'HotTopics' => array( 'SijèCho' ),
	'MoveThread' => array( 'DeplaseFil' ),
	'NewMessages' => array( 'NouvoMesaj' ),
	'SplitThread' => array( 'SepareFil' ),
	'MergeThread' => array( 'FizyoneFil' ),
);

/** Hungarian (Magyar) */
$specialPageAliases['hu'] = array(
	'DeleteThread' => array( 'Szál_törlése' ),
	'HotTopics' => array( 'Népszerű_témák' ),
	'MoveThread' => array( 'Szál_mozgatása' ),
	'NewMessages' => array( 'Új_üzenetek' ),
	'SplitThread' => array( 'Szál_felosztása' ),
	'MergeThread' => array( 'Szál_egyesítése' ),
);

/** Interlingua (Interlingua) */
$specialPageAliases['ia'] = array(
	'DeleteThread' => array( 'Deler_filo' ),
	'HotTopics' => array( 'Topicos_active' ),
	'MoveThread' => array( 'Displaciar_filo' ),
	'NewMessages' => array( 'Nove_messages' ),
	'SplitThread' => array( 'Separar_filo' ),
	'MergeThread' => array( 'Fusionar_filo' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'DeleteThread' => array( 'Hapus_topik', 'HapusTopik', 'Hapus_utas', 'HapusUtas' ),
	'HotTopics' => array( 'Topik_hangat', 'TopikHangat' ),
	'MoveThread' => array( 'Pindahkan_topik', 'PindahkanTopik', 'Pindahkan_utas', 'PindahkanUtas' ),
	'NewMessages' => array( 'Pesan_baru', 'PesanBaru' ),
	'SplitThread' => array( 'Pisah_topik', 'PisahTopik', 'Pisah_utas', 'PisahUtas' ),
	'MergeThread' => array( 'Gabung_topik', 'GabungTopik', 'Gabung_utas', 'GabungUtas' ),
);

/** Italian (Italiano) */
$specialPageAliases['it'] = array(
	'DeleteThread' => array( 'CancellaDiscussione' ),
	'HotTopics' => array( 'InEvidenza' ),
	'MoveThread' => array( 'SpostaDiscussione' ),
	'NewMessages' => array( 'NuoviMessaggi' ),
	'SplitThread' => array( 'DividiDiscussione' ),
	'MergeThread' => array( 'UnisciThread' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'DeleteThread' => array( 'スレッド削除' ),
	'HotTopics' => array( 'ホットな話題' ),
	'MoveThread' => array( 'スレッド移動' ),
	'NewMessages' => array( '新規投稿', '新しい伝言' ),
	'SplitThread' => array( 'スレッド分割' ),
	'MergeThread' => array( 'スレッド統合' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'NewMessages' => array( 'ახალი_წერილები' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'NewMessages' => array( 'សារថ្មីៗ' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'NewMessages' => array( '새_메시지' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'DeleteThread' => array( 'JeschprääschßfäddemFottschmiiße' ),
	'MoveThread' => array( 'JeschprääschßfäddemÖmträke' ),
	'NewMessages' => array( 'NeuJeschprääschßfäddeme' ),
	'SplitThread' => array( 'JeschprääschßfäddemOpdeile' ),
);

/** Cornish (Kernowek) */
$specialPageAliases['kw'] = array(
	'NewMessages' => array( 'MessajowNowyth' ),
);

/** Ladino (Ladino) */
$specialPageAliases['lad'] = array(
	'DeleteThread' => array( 'EfassarTítůlos' ),
	'HotTopics' => array( 'SujetosActivos' ),
	'MoveThread' => array( 'TaxirearTítůlo' ),
	'NewMessages' => array( 'MessajesNuevos' ),
	'SplitThread' => array( 'EspartirTítůlo' ),
	'MergeThread' => array( 'AjuntarTítůlo' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'DeleteThread' => array( 'Rubrik_läschen' ),
	'HotTopics' => array( 'Waarm_Sujeten' ),
	'MoveThread' => array( 'Rubrik_réckelen' ),
	'NewMessages' => array( 'Nei_Messagen' ),
	'SplitThread' => array( 'Rubrik_opdeelen' ),
	'MergeThread' => array( 'Rubrike_fusionéieren' ),
);

/** Macedonian (Македонски) */
$specialPageAliases['mk'] = array(
	'DeleteThread' => array( 'НишкаНаБришење' ),
	'HotTopics' => array( 'АктуелниТеми' ),
	'MoveThread' => array( 'НишкаНаПреместување' ),
	'NewMessages' => array( 'НовиПораки' ),
	'SplitThread' => array( 'РазделенаНишка' ),
	'MergeThread' => array( 'СпоенаНишка' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'DeleteThread' => array( 'ചരട്‌_മായ്ക്കുക' ),
	'HotTopics' => array( 'ചൂടൻവിഷയങ്ങൾ' ),
	'MoveThread' => array( 'ചരട്‌_മാറ്റുക' ),
	'NewMessages' => array( 'പുതുസന്ദേശങ്ങൾ' ),
	'SplitThread' => array( 'ചരട്_വിഘടിപ്പിക്കുക' ),
	'MergeThread' => array( 'ചരട്_സംയോജിപ്പിക്കുക' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'NewMessages' => array( 'नवीनसंदेश' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'NewMessages' => array( 'MessaġġiĠodda' ),
);

/** Erzya (Эрзянь) */
$specialPageAliases['myv'] = array(
	'DeleteThread' => array( 'НардамсСуре' ),
	'MoveThread' => array( 'ПечтевтемсСуре' ),
	'NewMessages' => array( 'ОдПачтямнэть' ),
	'MergeThread' => array( 'ПальдямсСуре' ),
);

/** Nedersaksisch (Nedersaksisch) */
$specialPageAliases['nds-nl'] = array(
	'DeleteThread' => array( 'Draod_vortdoon' ),
	'MoveThread' => array( 'Draod_verplaosen' ),
	'NewMessages' => array( 'Nieje_berichen' ),
	'SplitThread' => array( 'Onderwarp_splitsen' ),
	'MergeThread' => array( 'Draod_samenvoegen' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'DeleteThread' => array( 'OnderwerpVerwijderen' ),
	'HotTopics' => array( 'PopulaireOnderwerpen' ),
	'MoveThread' => array( 'OnderwerpVerplaatsen' ),
	'NewMessages' => array( 'NieuweBerichten' ),
	'SplitThread' => array( 'OnderwerpSplitsen' ),
	'MergeThread' => array( 'OnderwerpSamenvoegen' ),
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬) */
$specialPageAliases['nn'] = array(
	'DeleteThread' => array( 'Slett_tråd' ),
	'MoveThread' => array( 'Flytt_tråd' ),
	'NewMessages' => array( 'Nye_meldingar' ),
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬) */
$specialPageAliases['no'] = array(
	'DeleteThread' => array( 'Slett_tråd' ),
	'HotTopics' => array( 'Aktuelle_saker' ),
	'MoveThread' => array( 'Flytt_tråd' ),
	'NewMessages' => array( 'Nye_beskjeder' ),
	'SplitThread' => array( 'Splitt_tråd' ),
	'MergeThread' => array( 'Slå_sammen_tråd' ),
);

/** Occitan (Occitan) */
$specialPageAliases['oc'] = array(
	'NewMessages' => array( 'Messatges_novèls', 'MessatgesNovèls' ),
);

/** Polish (Polski) */
$specialPageAliases['pl'] = array(
	'DeleteThread' => array( 'Usuwanie_wątku' ),
	'MoveThread' => array( 'Przenoszenie_wątku' ),
	'NewMessages' => array( 'Nowe_wiadomości' ),
	'SplitThread' => array( 'Rodzielanie_wątku' ),
	'MergeThread' => array( 'Łączenie_wątku' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'NewMessages' => array( 'نوي_پيغامونه' ),
);

/** Portuguese (Português) */
$specialPageAliases['pt'] = array(
	'DeleteThread' => array( 'Eliminar_tópico' ),
	'HotTopics' => array( 'Tópicos_populares' ),
	'MoveThread' => array( 'Mover_tópico' ),
	'NewMessages' => array( 'Mensagens_novas' ),
	'SplitThread' => array( 'Dividir_tópico' ),
	'MergeThread' => array( 'Fundir_tópico' ),
);

/** Brazilian Portuguese (Português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'NewMessages' => array( 'Novas_mensagens' ),
);

/** Sanskrit (संस्कृत) */
$specialPageAliases['sa'] = array(
	'DeleteThread' => array( 'सूत्रपरित्यजति' ),
	'MoveThread' => array( 'सूत्रस्थानान्तर' ),
	'NewMessages' => array( 'नूतनसन्देश' ),
);

/** Sinhala (සිංහල) */
$specialPageAliases['si'] = array(
	'NewMessages' => array( 'නවපණිවුඩ' ),
);

/** Slovak (Slovenčina) */
$specialPageAliases['sk'] = array(
	'DeleteThread' => array( 'ZmazaťVlákno' ),
	'MoveThread' => array( 'PresunúťVlákno' ),
	'NewMessages' => array( 'NovéSprávy' ),
	'SplitThread' => array( 'RozdeliťVlákno' ),
);

/** Serbian Cyrillic ekavian (‪Српски (ћирилица)‬) */
$specialPageAliases['sr-ec'] = array(
	'DeleteThread' => array( 'Обриши_тему' ),
	'HotTopics' => array( 'Вруће_теме' ),
	'MoveThread' => array( 'Премести_тему' ),
	'NewMessages' => array( 'Нове_поруке' ),
	'SplitThread' => array( 'Раздвоји_тему' ),
	'MergeThread' => array( 'Споји_тему' ),
);

/** Swedish (Svenska) */
$specialPageAliases['sv'] = array(
	'DeleteThread' => array( 'Radera_tråd' ),
	'MoveThread' => array( 'Flytta_tråd' ),
	'NewMessages' => array( 'Nya_meddelanden' ),
	'SplitThread' => array( 'Dela_tråd' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'NewMessages' => array( 'MijumbeMipya' ),
);

/** Thai (ไทย) */
$specialPageAliases['th'] = array(
	'NewMessages' => array( 'ข้อควาใหม่' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'DeleteThread' => array( 'Burahin ang bagting' ),
	'MoveThread' => array( 'Ilipat ang bagting' ),
	'NewMessages' => array( 'Bagong mga mensahe' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'DeleteThread' => array( 'BaşlıkSil' ),
	'HotTopics' => array( 'AktifKonular' ),
	'MoveThread' => array( 'BaşlıkTaşı' ),
	'NewMessages' => array( 'YeniMesajlar', 'Yeniİletiler' ),
	'SplitThread' => array( 'BaşlıkBöl' ),
	'MergeThread' => array( 'BaşlıkBirleştir' ),
);

/** Татарча (Татарча) */
$specialPageAliases['tt-cyrl'] = array(
	'NewMessages' => array( 'Яңа_хатлар' ),
);

/** Vèneto (Vèneto) */
$specialPageAliases['vec'] = array(
	'DeleteThread' => array( 'ScancelaArgomento' ),
	'MoveThread' => array( 'SpostaArgomento' ),
	'NewMessages' => array( 'MessagiNovi' ),
	'SplitThread' => array( 'DividiArgomento' ),
	'MergeThread' => array( 'UnissiArgomento' ),
);

/** Chinese (中文) */
$specialPageAliases['zh'] = array(
	'DeleteThread' => array( '删除话题', '刪除話題' ),
	'MoveThread' => array( '移动话题', '移動話題' ),
	'NewMessages' => array( '新消息', '新訊息', '新讯息' ),
	'SplitThread' => array( '分割话题', '分割話題' ),
	'MergeThread' => array( '合并话题', '合併話題' ),
);

/** Simplified Chinese (‪中文(简体)‬) */
$specialPageAliases['zh-hans'] = array(
	'DeleteThread' => array( '删除话题' ),
	'HotTopics' => array( '热门话题' ),
	'MoveThread' => array( '移动话题' ),
	'NewMessages' => array( '新信息' ),
	'SplitThread' => array( '分割话题' ),
	'MergeThread' => array( '合并话题' ),
);

/** Traditional Chinese (‪中文(繁體)‬) */
$specialPageAliases['zh-hant'] = array(
	'DeleteThread' => array( '刪除話題' ),
	'HotTopics' => array( '熱門話題' ),
	'MoveThread' => array( '移動話題' ),
	'NewMessages' => array( '新消息' ),
	'SplitThread' => array( '分割話題' ),
	'MergeThread' => array( '合併話題' ),
);

/**
 * For backwards compatibility with MediaWiki 1.15 and earlier.
 */
$aliases =& $specialPageAliases;