<?php
/**
 * Internationalisation file for extension Lingo.
 *
 * @file
 * @ingroup Lingo
 */

$messages = array();

$messages['en'] = array(
	'lingo-desc' => 'Provides hover-over tool tips on pages from words defined on the [[$1]] page',
	'lingo-terminologypagename' => 'Terminology',
	'lingo-noterminologypage' => 'Page "$1" does not exist.',
	'lingo-terminologypagenotlocal' => 'Page "$1" is not a local page.',
);

/** Message documentation (Message documentation) */
$messages['qqq'] = array(
	'lingo-desc' => '{{desc}}',
	'lingo-terminologypagename' => 'Name of the page where the terms and definitions of the glossary are stored',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'lingo-desc' => 'Паказвае падказкі да словаў, вызначаных на старонцы [[$1]]',
	'lingo-terminologypagename' => 'Тэрміналёгія',
	'lingo-noterminologypage' => 'Старонка «$1» не існуе.',
	'lingo-terminologypagenotlocal' => 'Старонка «$1» не зьяўляецца лякальнай.',
);

/** Breton (Brezhoneg)
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'lingo-terminologypagename' => 'Termenadurezh',
	'lingo-noterminologypage' => 'N\'eus ket eus ar bajenn "$1".',
	'lingo-terminologypagenotlocal' => 'N\'eus ket ur bajenn lec\'hel eus "$1".',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'lingo-desc' => 'Ermöglicht Informationstexte, die eingeblendet werden, sobald man die Maus über einen auf der Seite [[$1]] hinterlegten Begriff führt',
	'lingo-terminologypagename' => 'Glossar',
	'lingo-noterminologypage' => 'Seite „$1“ ist nicht vorhanden.',
	'lingo-terminologypagenotlocal' => 'Seite „$1“ befindet sich nicht auf diesem Wiki.',
);

/** French (Français)
 * @author Sherbrooke
 */
$messages['fr'] = array(
	'lingo-desc' => 'Dans les pages, affiche une info-bulle si le mot est défini dans la page de [[$1]].',
	'lingo-terminologypagename' => 'Terminologie',
	'lingo-noterminologypage' => "Page « $1 » n'existe pas.",
	'lingo-terminologypagenotlocal' => "Page « $1 » n'est pas une page locale.",
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'lingo-terminologypagename' => 'Tèrminologia',
	'lingo-noterminologypage' => 'Pâge « $1 » ègziste pas.',
	'lingo-terminologypagenotlocal' => 'Pâge « $1 » est pas una pâge locala.',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'lingo-desc' => 'Proporciona consellos nas páxinas ao pasar o rato por riba das palabras definidas na páxina "[[$1]]"',
	'lingo-terminologypagename' => 'Terminoloxía',
	'lingo-noterminologypage' => 'A páxina "$1" non existe.',
	'lingo-terminologypagenotlocal' => 'A páxina "$1" non é unha páxina local.',
);

/** Hebrew (עברית)
 * @author Amire80
 */
$messages['he'] = array(
	'lingo-desc' => 'כלי לתצוגה רמזים צצים בדפים לפי מילים שמוגדרות בדף [[$1]]',
	'lingo-terminologypagename' => 'מינוח',
	'lingo-noterminologypage' => 'הדף "$1" אניו קיים.',
	'lingo-terminologypagenotlocal' => 'הדם "$1" אינו דף מקומי.',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'lingo-desc' => 'Zwobraznja pomocne teksty, hdyž kursor myše nad słowom steji, kotrež je na stronje [[$1]] definowane.',
	'lingo-terminologypagename' => 'Terminologija',
	'lingo-noterminologypage' => 'Strona "$1" njeeksistuje',
	'lingo-terminologypagenotlocal' => 'Strona "$1" lokalna strona njeje.',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'lingo-desc' => 'Monstra, al passage del cursor del mus, quadros de information super paginas de parolas definite in le pagina [[$1]]',
	'lingo-terminologypagename' => 'Terminologia',
	'lingo-noterminologypage' => 'Le pagina "$1" non existe.',
	'lingo-terminologypagenotlocal' => 'Le pagina "$1" non es un pagina local.',
);

/** Japanese (日本語)
 * @author Schu
 */
$messages['ja'] = array(
	'lingo-desc' => '[[$1]] ページに定義された用語から、ページ上にヒントを表示する hover-over ツールを提供します。',
	'lingo-terminologypagename' => 'Terminology',
	'lingo-noterminologypage' => '"$1" ページが存在しません。',
	'lingo-terminologypagenotlocal' => '" $1 "ページはローカルページではありません。',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'lingo-desc' => "Erlaabt et 'Tool Tips' ze weisen, wann ee mat der Maus iwwer Wierder fiert déi op der [[$1]]-Säit definéiert sinn",
	'lingo-terminologypagename' => 'Terminologie',
	'lingo-noterminologypage' => "Säit '$1' gëtt et net.",
	'lingo-terminologypagenotlocal' => "Säit '$1' gëtt et op dëser Wiki net.",
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'lingo-desc' => 'Овозможува описи при лебдење над алатките на страниците (од зборови со утврдени значења на страницата [[$1]])',
	'lingo-terminologypagename' => 'Терминологија',
	'lingo-noterminologypage' => 'Страницата „$1“ не постои.',
	'lingo-terminologypagenotlocal' => 'Страницата „$1“ не е локална страница.',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'lingo-desc' => 'Menyediakan petua-petua alatan secara hover pada laman-laman daripada kata-kata yang ditakrifkan di laman [[$1]]',
	'lingo-terminologypagename' => 'Peristilahan',
	'lingo-noterminologypage' => 'Laman "$1" tidak wujud.',
	'lingo-terminologypagenotlocal' => 'Laman "$1" bukan laman tempatan.',
);

/** Dutch (Nederlands)
 * @author Siebrand
 * @author Tjcool007
 */
$messages['nl'] = array(
	'lingo-desc' => "Zorgt voor tooltips op pagina's voor woorden gedefinieerd op [[$1]].",
	'lingo-terminologypagename' => 'Terminologie',
	'lingo-noterminologypage' => 'De pagina "$1" bestaat niet.',
	'lingo-terminologypagenotlocal' => 'De pagina "$1" is geen lokale pagina.',
);

/** Polish (Polski)
 * @author Sp5uhe
 * @author Woytecr
 */
$messages['pl'] = array(
	'lingo-noterminologypage' => 'Strona „$1“ nie istnieje.',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'lingo-desc' => 'Permite que a passagem do ponteiro do rato sobre palavras nas páginas, resulte no aparecimento de uma legenda. As palavras são definidas na página [[$1]].',
	'lingo-terminologypagename' => 'Terminology',
	'lingo-noterminologypage' => "A página '$1' não existe.",
	'lingo-terminologypagenotlocal' => "A página '$1' não é uma página local.",
);

/** Russian (Русский)
 * @author Adata80
 * @author Askarmuk
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'lingo-desc' => 'Показывает всплывающую подсказку при наведении на слово, присутствующее на странице [[$1]]',
	'lingo-terminologypagename' => 'Терминология',
	'lingo-noterminologypage' => 'Страница "$1" не существует.',
	'lingo-terminologypagenotlocal' => 'Страница "$1" не является локальной.',
);

/** Swedish (Svenska)
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'lingo-terminologypagename' => 'Terminologi',
	'lingo-noterminologypage' => 'Sidan "$1" finns inte',
	'lingo-terminologypagenotlocal' => 'Sidan "$1" är inte en lokal sida.',
);

