<?php
/**
 * Internationalisation file for DiscussionThreading extension.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English
 * @author Jack D. Pond
 */
$messages['en'] = array(
	'discussionthreading-desc' => 'Add threading to talk pages',
	'discussionthreading-replysection' => 'reply',
	'discussionthreading-replysectionhint' => "Reply to this posting",
	'discussionthreading-threadnewsection' => 'new',
	'discussionthreading-threadnewsectionhint' => "Start a new thread"
);

/** Message documentation (Message documentation)
 * @author Fryed-peach
 * @author Purodha
 * @author The Evil IP address
 */
$messages['qqq'] = array(
	'discussionthreading-desc' => '{{desc}}',
	'discussionthreading-replysection' => '{{Identical|Reply}}',
	'discussionthreading-threadnewsection' => '{{Identical|New}}',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'discussionthreading-desc' => 'Voeg "threading" by vir besprekingsbladsye',
	'discussionthreading-replysection' => 'antwoord',
	'discussionthreading-replysectionhint' => 'Beantwoord hierdie opmerking',
	'discussionthreading-threadnewsection' => 'nuut',
	'discussionthreading-threadnewsectionhint' => "Begin 'n nuwe onderwerp",
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'discussionthreading-desc' => 'Shto fillesë për të folur faqe',
	'discussionthreading-replysection' => 'përgjigje',
	'discussionthreading-replysectionhint' => 'Përgjigju me këtë postimin',
	'discussionthreading-threadnewsection' => 'i ri',
	'discussionthreading-threadnewsectionhint' => 'Fillo një fije të re',
);

/** Old English (Ænglisc)
 * @author Wōdenhelm
 */
$messages['ang'] = array(
	'discussionthreading-replysection' => 'andsƿarian',
	'discussionthreading-threadnewsection' => 'nīƿe',
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'discussionthreading-desc' => 'يضيف مجموعات الرسائل إلى صفحات النقاش',
	'discussionthreading-replysection' => 'رد',
	'discussionthreading-replysectionhint' => 'رد على هذه الرسالة',
	'discussionthreading-threadnewsection' => 'جديد',
	'discussionthreading-threadnewsectionhint' => 'بدء مجموعة رسائل جديدة',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'discussionthreading-threadnewsection' => 'ܚܕܬܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 */
$messages['arz'] = array(
	'discussionthreading-desc' => 'يضيف مجموعات الرسائل إلى صفحات النقاش',
	'discussionthreading-replysection' => 'رد',
	'discussionthreading-replysectionhint' => 'رد على هذه الرسالة',
	'discussionthreading-threadnewsection' => 'جديد',
	'discussionthreading-threadnewsectionhint' => 'بدء مجموعة رسائل جديدة',
);

/** Azerbaijani (Azərbaycanca)
 * @author Cekli829
 */
$messages['az'] = array(
	'discussionthreading-replysection' => 'yenidən',
	'discussionthreading-threadnewsection' => 'yeni',
	'discussionthreading-threadnewsectionhint' => 'Yeni bir başlıq başla',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'discussionthreading-desc' => 'Даданьне галінаў у старонкі абмеркаваньня',
	'discussionthreading-replysection' => 'адказ',
	'discussionthreading-replysectionhint' => 'Адказаць на гэта паведамленьне',
	'discussionthreading-threadnewsection' => 'новае',
	'discussionthreading-threadnewsectionhint' => 'Пачаць новую галіну',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'discussionthreading-replysection' => 'отговаряне',
	'discussionthreading-threadnewsectionhint' => 'Започване на нова нишка',
);

/** Bengali (বাংলা)
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'discussionthreading-desc' => 'আলাপ পাতায় আলোচনা শিরোনাম যোগ',
	'discussionthreading-replysection' => 'উত্তর',
	'discussionthreading-replysectionhint' => 'এই সংযোজনের প্রেক্ষিতে উত্তর',
	'discussionthreading-threadnewsection' => 'নতুন',
	'discussionthreading-threadnewsectionhint' => 'নতুন একটি আলোচনা শুরু করুন',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'discussionthreading-desc' => "Ouzhpennañ a ra an neudennoù d'ar bajenn gaozeal",
	'discussionthreading-replysection' => 'Respont',
	'discussionthreading-replysectionhint' => "Respont d'ar gemennadenn-mañ",
	'discussionthreading-threadnewsection' => 'nevez',
	'discussionthreading-threadnewsectionhint' => 'Sevel ur gaoz nevez',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'discussionthreading-desc' => 'Dodaje threading na stranicu za razgovor',
	'discussionthreading-replysection' => 'odgovor',
	'discussionthreading-replysectionhint' => 'Odgovori na ovaj post',
	'discussionthreading-threadnewsection' => 'novo',
	'discussionthreading-threadnewsectionhint' => 'Započni novu temu',
);

/** Catalan (Català)
 * @author SMP
 * @author Solde
 */
$messages['ca'] = array(
	'discussionthreading-desc' => 'Afegeix fils a les pàgines de discussió',
	'discussionthreading-replysection' => 'respon',
	'discussionthreading-replysectionhint' => 'Respon aquest missatge',
	'discussionthreading-threadnewsection' => 'nou',
	'discussionthreading-threadnewsectionhint' => 'Comença un nou fil',
);

/** Czech (Česky)
 * @author Matěj Grabovský
 */
$messages['cs'] = array(
	'discussionthreading-desc' => 'Přidává zobrazení vláken na diskusní stránky',
	'discussionthreading-replysection' => 'odpovědět',
	'discussionthreading-replysectionhint' => 'Odpovědět na tento příspěvek',
	'discussionthreading-threadnewsection' => 'nové',
	'discussionthreading-threadnewsectionhint' => 'Začít nové vlákno',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'discussionthreading-desc' => 'Ychwanegu trafod ar drywydd i dudalennau sgwrs',
	'discussionthreading-replysection' => 'ateb',
	'discussionthreading-replysectionhint' => 'Ateb y cyfraniad hwn',
	'discussionthreading-threadnewsection' => 'newydd',
	'discussionthreading-threadnewsectionhint' => 'Dechrau trywydd newydd',
);

/** German (Deutsch)
 * @author ChrisiPK
 */
$messages['de'] = array(
	'discussionthreading-desc' => 'Thread-Verwaltung für Diskussionsseiten',
	'discussionthreading-replysection' => 'antworten',
	'discussionthreading-replysectionhint' => 'Auf diesen Eintrag antworten',
	'discussionthreading-threadnewsection' => 'neu',
	'discussionthreading-threadnewsectionhint' => 'Neuen Eintrag erstellen',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'discussionthreading-desc' => 'Nitkowu funkciju diskusijnym bokam pśidaś',
	'discussionthreading-replysection' => 'wótegroniś',
	'discussionthreading-replysectionhint' => 'Na toś tu powěsć wótegroniś',
	'discussionthreading-threadnewsection' => 'nowy',
	'discussionthreading-threadnewsectionhint' => 'Nowu nitku startowaś',
);

/** Greek (Ελληνικά)
 * @author Konsnos
 * @author Omnipaedista
 */
$messages['el'] = array(
	'discussionthreading-desc' => 'Προσθήκη τμημάτων στις σελίδες συζήτησης',
	'discussionthreading-replysection' => 'απάντηση',
	'discussionthreading-replysectionhint' => 'Απάντηση σε αυτό το ποστ',
	'discussionthreading-threadnewsection' => 'νέο',
	'discussionthreading-threadnewsectionhint' => 'Προσθήκη νέου τμήματος',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'discussionthreading-replysection' => 'respondo',
	'discussionthreading-replysectionhint' => 'Respondi al ĉi tiu afiŝaĵo',
	'discussionthreading-threadnewsection' => 'nova',
	'discussionthreading-threadnewsectionhint' => 'Fari novan fadenon',
);

/** Spanish (Español)
 * @author Sanbec
 */
$messages['es'] = array(
	'discussionthreading-desc' => 'Añade organización por temas a las páginas de discusión',
	'discussionthreading-replysection' => 'respuesta',
	'discussionthreading-replysectionhint' => 'Respuesta a este tema',
	'discussionthreading-threadnewsection' => 'nuevo',
	'discussionthreading-threadnewsectionhint' => 'Empezar un nuevo tema',
);

/** Estonian (Eesti)
 * @author Avjoska
 * @author Pikne
 */
$messages['et'] = array(
	'discussionthreading-replysection' => 'vasta',
	'discussionthreading-replysectionhint' => 'Vasta sellele sõnumile',
	'discussionthreading-threadnewsection' => 'uus',
);

/** Basque (Euskara)
 * @author Theklan
 */
$messages['eu'] = array(
	'discussionthreading-desc' => 'Eztabaida orrialdeei gaikako antolatzea gehiten die',
	'discussionthreading-replysection' => 'erantzun',
	'discussionthreading-replysectionhint' => 'Erantzun bidalketa honi',
	'discussionthreading-threadnewsection' => 'berria',
	'discussionthreading-threadnewsectionhint' => 'Kategoria berria hasi',
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Mjbmr
 */
$messages['fa'] = array(
	'discussionthreading-desc' => 'افزودن موضوع جدید به صفحات بحث',
	'discussionthreading-replysection' => 'پاسخ',
	'discussionthreading-replysectionhint' => 'به این پیام پاسخ دهید',
	'discussionthreading-threadnewsection' => 'تازه',
	'discussionthreading-threadnewsectionhint' => 'شروع کردن یک موضوع جدید',
);

/** Finnish (Suomi)
 * @author Vililikku
 */
$messages['fi'] = array(
	'discussionthreading-desc' => 'Lisää viestiketjut keskustelusivuille',
	'discussionthreading-replysection' => 'vastaa',
	'discussionthreading-replysectionhint' => 'Vastaa tähän viestiin',
	'discussionthreading-threadnewsection' => 'uusi',
	'discussionthreading-threadnewsectionhint' => 'Aloita uusi viestiketju',
);

/** French (Français)
 * @author Grondin
 * @author Verdy p
 */
$messages['fr'] = array(
	'discussionthreading-desc' => 'Ajoute la liaison par fil des messages postés dans les pages de discussion',
	'discussionthreading-replysection' => 'répondre',
	'discussionthreading-replysectionhint' => 'Répondre à ce message',
	'discussionthreading-threadnewsection' => 'nouveau',
	'discussionthreading-threadnewsectionhint' => 'Commencer un nouveau fil de discussion',
);

/** Franco-Provençal (Arpetan)
 * @author Cedric31
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'discussionthreading-replysection' => 'rèpondre',
	'discussionthreading-replysectionhint' => 'Rèpondre a ceti mèssâjo',
	'discussionthreading-threadnewsection' => 'novél',
	'discussionthreading-threadnewsectionhint' => 'Comenciér un fil de discussion novél',
);

/** Irish (Gaeilge)
 * @author Alison
 */
$messages['ga'] = array(
	'discussionthreading-desc' => 'Cuir snáithiú leis an leathanaigh phlé',
	'discussionthreading-replysection' => 'freagair',
	'discussionthreading-replysectionhint' => 'Déan freagair don teachtaireacht seo',
	'discussionthreading-threadnewsection' => 'nua',
	'discussionthreading-threadnewsectionhint' => 'Tosaigh ar snáth nua',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'discussionthreading-desc' => 'Engadir o encadeamento ás páxinas de conversa',
	'discussionthreading-replysection' => 'responder',
	'discussionthreading-replysectionhint' => 'Respostar esta publicación',
	'discussionthreading-threadnewsection' => 'novo',
	'discussionthreading-threadnewsectionhint' => 'Comezar un novo fío de conversa',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'discussionthreading-desc' => 'Προστιθέναι τμήματα εἰς τὰς δέλτους διαλέξεως',
	'discussionthreading-replysection' => 'ἀποκρίνεσθαι',
	'discussionthreading-replysectionhint' => 'Ἀποκρίνεσθαι τῷδε',
	'discussionthreading-threadnewsection' => 'νέα',
	'discussionthreading-threadnewsectionhint' => 'Ἄρχειν νέον τμῆμα',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'discussionthreading-desc' => 'Strang-Verwaltig fir Diskussionssyte',
	'discussionthreading-replysection' => 'Antwort gee',
	'discussionthreading-replysectionhint' => 'Zue däm Yytrag e Antwort gee',
	'discussionthreading-threadnewsection' => 'nej',
	'discussionthreading-threadnewsectionhint' => 'E neje Diskussionsstrang aalege',
);

/** Gujarati (ગુજરાતી)
 * @author Dineshjk
 */
$messages['gu'] = array(
	'discussionthreading-desc' => 'ચર્ચા પાનાં પર આ થ્રેડ ઉમેરો.',
	'discussionthreading-replysection' => 'જવાબ આપો',
	'discussionthreading-replysectionhint' => 'આ પોસ્ટીંગનો જવાબ આપો.',
	'discussionthreading-threadnewsection' => 'નવું',
	'discussionthreading-threadnewsectionhint' => 'નવો થ્રેડ ચાલુ કરો.',
);

/** Hebrew (עברית)
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'discussionthreading-desc' => 'הוספת אפשרות שרשור לדפי שיחה',
	'discussionthreading-replysection' => 'תגובה',
	'discussionthreading-replysectionhint' => 'תגובה להודעה זו',
	'discussionthreading-threadnewsection' => 'חדשה',
	'discussionthreading-threadnewsectionhint' => 'התחלת שרשור חדש',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'discussionthreading-desc' => 'Zwobraznjenje nitkow k diskusijnym stronam přidać',
	'discussionthreading-replysection' => 'wotmołwić',
	'discussionthreading-replysectionhint' => 'Na tutu powěsć wotmołwić',
	'discussionthreading-threadnewsection' => 'nowy',
	'discussionthreading-threadnewsectionhint' => 'Nowu nitku startować',
);

/** Hungarian (Magyar)
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'discussionthreading-desc' => 'Témakezelés a vitalapokhoz',
	'discussionthreading-replysection' => 'válasz',
	'discussionthreading-replysectionhint' => 'Válasz erre az üzenetre',
	'discussionthreading-threadnewsection' => 'új',
	'discussionthreading-threadnewsectionhint' => 'Új téma indítása',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'discussionthreading-desc' => 'Adde un organisation in filos al paginas de discussion',
	'discussionthreading-replysection' => 'responder',
	'discussionthreading-replysectionhint' => 'Responder a iste commento',
	'discussionthreading-threadnewsection' => 'nove',
	'discussionthreading-threadnewsectionhint' => 'Initiar un nove filo',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 */
$messages['id'] = array(
	'discussionthreading-desc' => 'Tambahkan kemampuan "thread" di halaman pembicaraan',
	'discussionthreading-replysection' => 'balas',
	'discussionthreading-replysectionhint' => 'Balas posting ini',
	'discussionthreading-threadnewsection' => 'baru',
	'discussionthreading-threadnewsectionhint' => 'Mulai sebuah topik baru',
);

/** Italian (Italiano)
 * @author Pietrodn
 */
$messages['it'] = array(
	'discussionthreading-desc' => "Aggiunge il ''threading'' alle pagine di discussione",
	'discussionthreading-replysection' => 'rispondi',
	'discussionthreading-replysectionhint' => 'Rispondi a questo messaggio',
	'discussionthreading-threadnewsection' => 'nuovo',
	'discussionthreading-threadnewsectionhint' => 'Avvia una nuova discussione',
);

/** Japanese (日本語)
 * @author Fryed-peach
 */
$messages['ja'] = array(
	'discussionthreading-desc' => 'ノートページにスレッド機能を追加する',
	'discussionthreading-replysection' => '返信',
	'discussionthreading-replysectionhint' => 'この投稿に返信する',
	'discussionthreading-threadnewsection' => '新規',
	'discussionthreading-threadnewsectionhint' => '新しいスレッドを立てる',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Thearith
 */
$messages['km'] = array(
	'discussionthreading-replysection' => 'ឆ្លើយតប',
	'discussionthreading-threadnewsection' => 'ថ្មី',
	'discussionthreading-threadnewsectionhint' => 'ចាប់ផ្ដើម​ខ្សែស្រឡាយ​ថ្មី​មួយ',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'discussionthreading-threadnewsection' => 'ಹೊಸ',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'discussionthreading-desc' => 'Määt et müjjelelsch, de Fäddeme fum Klaafe op de Klaafsigge afzebelde.',
	'discussionthreading-replysection' => 'antwoote',
	'discussionthreading-replysectionhint' => 'Don op dä Beidraach antwoote',
	'discussionthreading-threadnewsection' => 'neu',
	'discussionthreading-threadnewsectionhint' => 'Ene neue Fäddem aanfange',
);

/** Cornish (Kernowek)
 * @author Kw-Moon
 */
$messages['kw'] = array(
	'discussionthreading-threadnewsection' => 'noweth',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'discussionthreading-desc' => 'Bemierkungen (threads) op Diskussiounssäiten derbäisetzen',
	'discussionthreading-replysection' => 'äntwerten',
	'discussionthreading-replysectionhint' => 'Op dës Bemierkung äntwerten',
	'discussionthreading-threadnewsection' => 'nei',
	'discussionthreading-threadnewsectionhint' => 'Eng nei Bemierkung derbäisetzen',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'discussionthreading-desc' => 'Додава ниски на страници за разговор',
	'discussionthreading-replysection' => 'одговор',
	'discussionthreading-replysectionhint' => 'Одговори на оваа порака',
	'discussionthreading-threadnewsection' => 'нови',
	'discussionthreading-threadnewsectionhint' => 'Започни нова нишка',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 */
$messages['ml'] = array(
	'discussionthreading-desc' => 'സംവാദം താളുകളിൽ ചരട് ചേർക്കുക',
	'discussionthreading-replysection' => 'മറുപടി',
	'discussionthreading-replysectionhint' => 'ഈ പ്രസിദ്ധപ്പെടുത്തലിന് മറുപടിയിടുക',
	'discussionthreading-threadnewsection' => 'നൂതനം',
	'discussionthreading-threadnewsectionhint' => 'പുതിയൊരു ചരട് തുടങ്ങുക',
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'discussionthreading-replysection' => 'пандомс',
	'discussionthreading-threadnewsection' => 'од',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'discussionthreading-desc' => "Voegt threading toe aan overlegpagina's",
	'discussionthreading-replysection' => 'antwoorden',
	'discussionthreading-replysectionhint' => 'Deze opmerking beantwoorden',
	'discussionthreading-threadnewsection' => 'nieuw',
	'discussionthreading-threadnewsectionhint' => 'Nieuwe thread starten',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Harald Khan
 */
$messages['nn'] = array(
	'discussionthreading-desc' => 'Legg til tråding på diskusjonssider.',
	'discussionthreading-replysection' => 'svar',
	'discussionthreading-replysectionhint' => 'Svar på dette innlegget',
	'discussionthreading-threadnewsection' => 'ny',
	'discussionthreading-threadnewsectionhint' => 'Start ein ny tråd',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 * @author Nghtwlkr
 */
$messages['no'] = array(
	'discussionthreading-desc' => 'Legg til tråding på diskusjonssider',
	'discussionthreading-replysection' => 'svar',
	'discussionthreading-replysectionhint' => 'Svar på denne posten',
	'discussionthreading-threadnewsection' => 'ny',
	'discussionthreading-threadnewsectionhint' => 'Start en ny tråd',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'discussionthreading-desc' => 'Apondre un fial de discussion dins las paginas de discussion',
	'discussionthreading-replysection' => 'respondre',
	'discussionthreading-replysectionhint' => 'Respondre al comentari',
	'discussionthreading-threadnewsection' => 'novèl',
	'discussionthreading-threadnewsectionhint' => 'Començar una discussion novèla',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'discussionthreading-threadnewsection' => 'nei',
);

/** Polish (Polski)
 * @author Holek
 * @author Leinad
 * @author Maikking
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'discussionthreading-desc' => 'Dodaje obsługę wątków do stron dyskusji',
	'discussionthreading-replysection' => 'odpowiedz',
	'discussionthreading-replysectionhint' => 'Odpowiedz na tę wiadomość',
	'discussionthreading-threadnewsection' => 'nowy',
	'discussionthreading-threadnewsectionhint' => 'Zacznij nowy wątek',
);

/** Piedmontese (Piemontèis)
 * @author Dragonòt
 */
$messages['pms'] = array(
	'discussionthreading-desc' => 'Gionta ël threading a le pàgine ëd discussion',
	'discussionthreading-replysection' => 'arspond',
	'discussionthreading-replysectionhint' => 'Arspond a sto messagi-sì',
	'discussionthreading-threadnewsection' => 'neuv',
	'discussionthreading-threadnewsectionhint' => 'Fa parte un neuv thread',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'discussionthreading-replysection' => 'ځوابول',
	'discussionthreading-threadnewsection' => 'نوی',
);

/** Portuguese (Português)
 * @author Malafaya
 * @author Waldir
 */
$messages['pt'] = array(
	'discussionthreading-desc' => 'Adiciona a funcionalidade de tópicos às páginas de discussão',
	'discussionthreading-replysection' => 'responder',
	'discussionthreading-replysectionhint' => 'Responder a este comentário',
	'discussionthreading-threadnewsection' => 'novo',
	'discussionthreading-threadnewsectionhint' => 'Iniciar um novo tópico',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 */
$messages['pt-br'] = array(
	'discussionthreading-desc' => 'Adiciona a funcionalidade de tópicos às páginas de discussão',
	'discussionthreading-replysection' => 'responder',
	'discussionthreading-replysectionhint' => 'Responder a este comentário',
	'discussionthreading-threadnewsection' => 'novo',
	'discussionthreading-threadnewsectionhint' => 'Iniciar um novo tópico',
);

/** Romanian (Română)
 * @author Firilacroco
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'discussionthreading-replysection' => 'răspuns',
	'discussionthreading-replysectionhint' => 'Răspunde la această postare',
	'discussionthreading-threadnewsection' => 'nou',
	'discussionthreading-threadnewsectionhint' => 'Începe un nou fir',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'discussionthreading-desc' => "Aggiunge le thread jndr'à le pàggene de le 'ngazzaminde",
	'discussionthreading-replysection' => 'respunne',
	'discussionthreading-replysectionhint' => 'Responne a stu messagge',
	'discussionthreading-threadnewsection' => 'nuève',
	'discussionthreading-threadnewsectionhint' => "Accuminze 'nu thread nuève",
);

/** Russian (Русский)
 * @author Ferrer
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'discussionthreading-desc' => 'Добавляет ветви обсуждений на страницы обсуждений',
	'discussionthreading-replysection' => 'ответ',
	'discussionthreading-replysectionhint' => 'Ответить на это сообщение',
	'discussionthreading-threadnewsection' => 'новые',
	'discussionthreading-threadnewsectionhint' => 'Начать новую ветвь',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'discussionthreading-desc' => 'Pridať zobrazenie vlákien na diskusné stránky',
	'discussionthreading-replysection' => 'odpovedať',
	'discussionthreading-replysectionhint' => 'Odpovedať na tento príspevok',
	'discussionthreading-threadnewsection' => 'nové',
	'discussionthreading-threadnewsectionhint' => 'Začať nové vlákno',
);

/** Serbian Cyrillic ekavian (‪Српски (ћирилица)‬)
 * @author Rancher
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'discussionthreading-replysection' => 'одговори',
	'discussionthreading-replysectionhint' => 'Одговори на ову поруку',
	'discussionthreading-threadnewsection' => 'ново',
	'discussionthreading-threadnewsectionhint' => 'Започни нову тему',
);

/** Serbian Latin ekavian (‪Srpski (latinica)‬) */
$messages['sr-el'] = array(
	'discussionthreading-replysection' => 'odgovori',
	'discussionthreading-threadnewsection' => 'novo',
	'discussionthreading-threadnewsectionhint' => 'Započni novu temu',
);

/** Swedish (Svenska)
 * @author Najami
 */
$messages['sv'] = array(
	'discussionthreading-desc' => 'Lägg till trådning på diskussionssidor',
	'discussionthreading-replysection' => 'svar',
	'discussionthreading-replysectionhint' => 'Svar på den här posten',
	'discussionthreading-threadnewsection' => 'ny',
	'discussionthreading-threadnewsectionhint' => 'Starta en ny tråd',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'discussionthreading-replysection' => 'స్పందించండి',
	'discussionthreading-threadnewsection' => 'కొత్తది',
);

/** Thai (ไทย)
 * @author Harley Hartwell
 */
$messages['th'] = array(
	'discussionthreading-desc' => 'เริ่มหัวข้อใหม่ในหน้าพูดคุย',
	'discussionthreading-replysection' => 'ตอบ',
	'discussionthreading-replysectionhint' => 'ตอบหัวข้อพูดคุยนี้',
	'discussionthreading-threadnewsection' => 'ใหม่',
	'discussionthreading-threadnewsectionhint' => 'เริ่มหัวข้อใหม่',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'discussionthreading-desc' => "Magdagdag ng kahanayan ng \"hibla\" ng paguusap (''threading'') sa mga pahina ng usapan",
	'discussionthreading-replysection' => 'tumugon',
	'discussionthreading-replysectionhint' => 'Sumagot sa pagtatalang (pagpapahayag na) ito',
	'discussionthreading-threadnewsection' => 'bago',
	'discussionthreading-threadnewsectionhint' => "Magsimula ng isang bagong \"hibla\" (''thread'') ng pag-uusap",
);

/** Turkish (Türkçe)
 * @author Mach
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'discussionthreading-desc' => 'Tartışma sayfalarına başlık sistemi ekle',
	'discussionthreading-replysection' => 'cevap',
	'discussionthreading-replysectionhint' => 'Bu gönderiye cevap ver',
	'discussionthreading-threadnewsection' => 'yeni',
	'discussionthreading-threadnewsectionhint' => 'Yeni bir başlık başlat',
);

/** Ukrainian (Українська)
 * @author Prima klasy4na
 */
$messages['uk'] = array(
	'discussionthreading-desc' => 'Додає гілки обговорень на сторінки обговорень',
	'discussionthreading-replysection' => 'відповідь',
	'discussionthreading-replysectionhint' => 'Відповісти на це повідомлення',
	'discussionthreading-threadnewsection' => 'нові',
	'discussionthreading-threadnewsectionhint' => 'Створити нову тему',
);

/** Veps (Vepsan kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'discussionthreading-desc' => 'Ližadab lodubarboid lodulehtpolile',
	'discussionthreading-replysection' => 'vastuz',
	'discussionthreading-replysectionhint' => 'Antta vastust neche tedotushe',
	'discussionthreading-threadnewsection' => "uz'",
	'discussionthreading-threadnewsectionhint' => "Augotada uz' barb",
);

/** Vietnamese (Tiếng Việt)
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'discussionthreading-desc' => 'Thêm luồng vào trang thảo luận',
	'discussionthreading-replysection' => 'trả lời',
	'discussionthreading-replysectionhint' => 'Trả lời bài đăng này',
	'discussionthreading-threadnewsection' => 'mới',
	'discussionthreading-threadnewsectionhint' => 'Bắt đầu luồng mới',
);

/** Volapük (Volapük)
 * @author Smeira
 */
$messages['vo'] = array(
	'discussionthreading-desc' => 'Givön bespikapades mögi ad jafön fadis',
	'discussionthreading-replysection' => 'gepenön',
	'discussionthreading-replysectionhint' => 'Gepenön keblünote at',
	'discussionthreading-threadnewsection' => 'nulik',
	'discussionthreading-threadnewsectionhint' => 'Primön fadi nulik',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'discussionthreading-replysection' => 'אָנרופֿן',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Hydra
 */
$messages['zh-hans'] = array(
	'discussionthreading-desc' => '添加线程交谈页',
	'discussionthreading-replysection' => '回复',
	'discussionthreading-replysectionhint' => '回复本贴',
	'discussionthreading-threadnewsection' => '新',
	'discussionthreading-threadnewsectionhint' => '启动一个新的线程',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Mark85296341
 */
$messages['zh-hant'] = array(
	'discussionthreading-replysection' => '回覆',
	'discussionthreading-replysectionhint' => '回覆這個帖子',
	'discussionthreading-threadnewsection' => '新',
);

