<?php
/**
 * Internationalisation file for Advanced Meta extension.
 *
 * @file
 * @ingroup Extensions
 * @license Public Domain
 */

$messages = array();

$messages['en'] = array(
	'ameta-desc' => 'Allows per page meta settings (robots, keywords, description) and change title',
	'ameta-metasettings' => 'Meta settings',
	'ameta-titlealias' => 'Title alias:',
	'ameta-keywordsadd' => 'the following keywords are added to all pages:',
	'ameta-keywordsmodify' => 'can be modified at Mediawiki:Globalkeywords',
);

/** Message documentation (Message documentation)
 * @author Purodha
 */
$messages['qqq'] = array(
	'ameta-desc' => '{{desc}}',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'ameta-desc' => 'Налады мэтазьвестак для асобных старонак (робаты, ключавыя словы, апісаньне) і магчымасьць зьмены загалоўка',
	'ameta-metasettings' => 'Мэта-налады',
	'ameta-keywordsadd' => 'наступныя ключавыя словы дадаюцца да ўсіх старонак:',
	'ameta-keywordsmodify' => 'могуць быць зьмененыя на Mediawiki:Globalkeywords',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'ameta-metasettings' => 'Мета настройки',
);

/** German (Deutsch) */
$messages['de'] = array(
	'ameta-desc' => 'Ermöglicht das Festlegen der Meta-Elemente „robots“, „keywords“ und „description“ sowie das Anpassen des Seitentitels',
	'ameta-metasettings' => 'Meta-Einstellungen',
	'ameta-titlealias' => 'Title:',
	'ameta-keywordsadd' => 'Die folgenden „keywords“ werden allen Seiten hinzugefügt:',
	'ameta-keywordsmodify' => 'Sie können auf der Seite Mediawiki:Globalkeywords angepasst werden.',
);

/** Spanish (Español)
 * @author Mor
 * @author Pvgreenzebra
 */
$messages['es'] = array(
	'ameta-metasettings' => 'Configuración de meta',
	'ameta-titlealias' => 'Alias de título:',
);

$messages['fr'] = array(
	'ameta-desc' => 'Permet le paramétrage des balises meta de chaque page (robots, mots clés, description) et le changement de titre',
	'ameta-metasettings' => 'Paramètres des balises meta',
	'ameta-titlealias' => 'Alias de titre:',
	'ameta-keywordsadd' => 'Les mots clés suivant sont ajouté à toutes les pages:',
	'ameta-keywordsmodify' => 'peuvent être modifiées sur la page Mediawiki:Globalkeywords',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'ameta-desc' => 'Permitte configurar le metadatos de cata pagina (robots, parolas-clave, description) e cambiar le titulo',
	'ameta-metasettings' => 'Configuration de metadatos',
	'ameta-titlealias' => 'Titulo alternative:',
	'ameta-keywordsadd' => 'le sequente parolas-clave es addite a tote le paginas:',
	'ameta-keywordsmodify' => 'pote esser modificate a Mediawiki:Globalkeywords',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'ameta-desc' => 'Määd et müjjejesch, de HTML Metta-Daate „<code lang="en">robots</code>“, „<code lang="en">keywords</code>“ un „<code lang="en">description</code>“ fö jeede Sigg enzejävve, un dä Tittel för di Sigg aanzpaße.',
	'ameta-metasettings' => 'Metta-Daate',
	'ameta-titlealias' => 'Dä zohsäzlejje Tittel:',
	'ameta-keywordsadd' => 'Heh di Schlößelwööter kumme en de „<code lang="en">keywords</code>“ en alle Sigge:',
	'ameta-keywordsmodify' => 'Se künne op dä Sigg [[Mediawiki:Globalkeywords]] aanjepaß wääde.',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'ameta-metasettings' => 'Meta-Astellungen',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'ameta-desc' => 'Овозможува мета-поставки за поединечни страници (роботи, клучни зборови, опис) и промена на насловот',
	'ameta-metasettings' => 'Мета-псотавки',
	'ameta-titlealias' => 'Алијас на насловот:',
	'ameta-keywordsadd' => 'следниве клучни зборови се додадени на сите страници:',
	'ameta-keywordsmodify' => 'може да се измени во Mediawiki:Globalkeywords',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'ameta-desc' => 'Membolehkan tetapan meta selaman (robot, kata kunci, keterangan) dan penukaran tajuk',
	'ameta-metasettings' => 'Tetapan meta',
	'ameta-titlealias' => 'Alias tajuk:',
	'ameta-keywordsadd' => 'kata-kata kunci berikut dibubuh di semua laman:',
	'ameta-keywordsmodify' => 'boleh diubah suai di Mediawiki:Globalkeywords',
);

/** Dutch (Nederlands) */
$messages['nl'] = array(
	'ameta-desc' => 'Maakt het mogelijk de meta-instellingen (robots, keywords, description) en de titel per pagina te veranderen',
	'ameta-metasettings' => 'Meta-instellingen',
	'ameta-titlealias' => 'Titel-alias:',
	'ameta-keywordsadd' => 'de volgende trefwoorden worden aan elke pagina toegevoegd:',
	'ameta-keywordsmodify' => 'kan worden gewijzigd op Mediawiki:Globalkeywords',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'ameta-desc' => 'Permite meta configurações por página (robôs, termos-chave, descrição) e alteração do título',
	'ameta-metasettings' => 'Meta configurações',
	'ameta-titlealias' => 'Nome alternativo para o título:',
	'ameta-keywordsadd' => 'os seguintes termos-chave são adicionados a todas as páginas:',
	'ameta-keywordsmodify' => 'podem ser alterados em Mediawiki:Globalkeywords',
);

/** Swedish (Svenska)
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'ameta-metasettings' => 'Meta-inställningar',
);

/** Simplified Chinese (‪中文(简体)‬) */
$messages['zh-hans'] = array(
	'ameta-desc' => '允许为每个页面设置机器人政策、关键词和描述，以及修改标题',
	'ameta-metasettings' => 'Meta设置',
	'ameta-titlealias' => '修改标题:',
	'ameta-keywordsadd' => '以下内容自动作为关键词添加:',
	'ameta-keywordsmodify' => '可在 Mediawiki:Globalkeywords 修改全局关键词',
);

$messages['zh-hant'] = array(
	'ameta-desc' => '允許為每個頁面設置機器人政策、關鍵字和描述，以及修改標題',
	'ameta-metasettings' => 'Meta設置',
	'ameta-titlealias' => '修改標題:',
	'ameta-keywordsadd' => '以下內容自動作為關鍵字添加:',
	'ameta-keywordsmodify' => '可在 Mediawiki:Globalkeywords 修改全域關鍵字',
);

